%------------------------------------------------------------------------------
% File     : COM102_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 240
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_240 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  192 (  63 unt;  62 typ;   0 def)
%            Number of atoms       :  240 ( 124 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  163 (  53   ~;  22   |;  13   &)
%                                         (  28 <=>;  47  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   47 (  29   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-2 aty)
%            Number of functors    :   50 (  50 usr;  15 con; 0-5 aty)
%            Number of variables   :  374 ( 321   !;  10   ?; 374   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:00
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (55)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olists,type,
    lists: 
      !>[A: $tType] : ( fun(A,bool) > fun(list(A),bool) ) ).

tff(sy_c_List_Olistset,type,
    listset: 
      !>[A: $tType] : ( list(fun(A,bool)) > fun(list(A),bool) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Oset__Cons,type,
    set_Cons: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(list(A),bool) ) > fun(list(A),bool) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Ohd__coeffs1,type,
    qEpres1907640072oeffs1: list(atom) > list(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_i____,type,
    i: int ).

tff(sy_v_ks____,type,
    ks: list(int) ).

tff(sy_v_li____,type,
    li: int ).

tff(sy_v_lks____,type,
    lks: list(int) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (96)
tff(fact_0__096a_A_058_Aset_Aas_096,axiom,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),a),set(atom,as))) ).

tff(fact_1__096_Ili_M_Alks_J_A_058_Aset_A_Ilbounds_Aas_J_096,axiom,
    pp(aa(fun(product_prod(int,list(int)),bool),bool,aa(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),member(product_prod(int,list(int))),product_Pair(int,list(int),li,lks)),set(product_prod(int,list(int)),lbounds(as)))) ).

tff(fact_2__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_3_atom_Osimps_I1_J,axiom,
    ! [List4: list(int),Int2: int,List: list(int),Int1: int] :
      ( ( c_PresArith_Oatom_OLe(Int1,List) = c_PresArith_Oatom_OLe(Int2,List4) )
    <=> ( ( Int1 = Int2 )
        & ( List = List4 ) ) ) ).

tff(fact_4_list_Oinject,axiom,
    ! [A: $tType,List4: list(A),A6: A,List: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Aa),List) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A6),List4) )
    <=> ( ( Aa = A6 )
        & ( List = List4 ) ) ) ).

tff(fact_5_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa))))
     => ( ( Y2 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa))) ) ) ).

tff(fact_6__096a_A_061_ALe_Ai_A_I_N1_A_D_Aks_J_096,axiom,
    a = c_PresArith_Oatom_OLe(i,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),number_number_of(int,min)),ks)) ).

tff(fact_7_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] : ( set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa)) = insert(A,Xa,set(A,Xsa)) ) ).

tff(fact_8__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X2: int] :
    ! [Xa2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
     => i_Z(Xa2,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X2),xs)) ) ).

tff(fact_9_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( divisor(X3) != zero_zero(int) ) ) ).

tff(fact_10_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => i_Z(X3,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),x),xs)) ) ).

tff(fact_11__096_B_Bthesis_O_A_I_B_Bi_Aks_O_Aa_A_061_ALe_Ai_A_I_N1_A_D_Aks_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [I1: int,Ks1: list(int)] : ( a != c_PresArith_Oatom_OLe(I1,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),number_number_of(int,min)),Ks1)) ) ).

tff(fact_12_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) ) ).

tff(fact_13_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) != Xs ) ).

tff(fact_14__096I_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    i_Z(a,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),x),xs)) ).

tff(fact_15_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( divisor(c_PresArith_Oatom_OLe(I,Ks)) = one_one(int) ) ).

tff(fact_16__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X2: int] :
        ~ ! [Xa2: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
           => i_Z(Xa2,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X2),xs)) ) ).

tff(fact_17_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_18_list_Osimps_I3_J,axiom,
    ! [A: $tType,List3: list(A),A4: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List3) != nil(A) ) ).

tff(fact_19_list_Osimps_I2_J,axiom,
    ! [A: $tType,List3: list(A),A4: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List3) ) ).

tff(fact_20_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_21_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_22_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_23_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_24_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int1,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int1),List) ) ).

tff(fact_25_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] : ( insert(A,Xa,insert(A,Xa,A1)) = insert(A,Xa,A1) ) ).

tff(fact_26_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,A1)))
    <=> ( ( Aa = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_27_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,A1)))
     => ( ( Aa != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_28_emptyE,axiom,
    ! [A: $tType,Aa: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),bot_bot(fun(A,bool)))) ).

tff(fact_29_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_30_empty__iff,axiom,
    ! [A: $tType,C2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),bot_bot(fun(A,bool)))) ).

tff(fact_31_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_32_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_33_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y2: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Y2) )
        <=> ( Xa = Y2 ) ) ) ).

tff(fact_34_insertCI,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),Aa: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B1))
       => ( Aa = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,B1))) ) ).

tff(fact_35_equals0D,axiom,
    ! [A: $tType,Aa: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ).

tff(fact_36_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_37_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_38_singleton__inject,axiom,
    ! [A: $tType,B2: A,Aa: A] :
      ( ( insert(A,Aa,bot_bot(fun(A,bool))) = insert(A,B2,bot_bot(fun(A,bool))) )
     => ( Aa = B2 ) ) ).

tff(fact_39_singletonE,axiom,
    ! [A: $tType,Aa: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,Aa,bot_bot(fun(A,bool)))))
     => ( B2 = Aa ) ) ).

tff(fact_40_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C2: A,B2: A,Aa: A] :
      ( ( insert(A,Aa,insert(A,B2,bot_bot(fun(A,bool)))) = insert(A,C2,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( Aa = C2 )
          & ( B2 = D ) )
        | ( ( Aa = D )
          & ( B2 = C2 ) ) ) ) ).

tff(fact_41_singleton__iff,axiom,
    ! [A: $tType,Aa: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,Aa,bot_bot(fun(A,bool)))))
    <=> ( B2 = Aa ) ) ).

tff(fact_42_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] : ( insert(A,Aa,A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_43_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] : ( bot_bot(fun(A,bool)) != insert(A,Aa,A1) ) ).

tff(fact_44_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,W: int] :
          ( ( number_number_of(A,W) = Xa )
        <=> ( Xa = number_number_of(A,W) ) ) ) ).

tff(fact_45_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( insert(A,Aa,A1) = A1 ) ) ).

tff(fact_46_insertI2,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,B1))) ) ).

tff(fact_47_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B2: A,A1: fun(A,bool),Aa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B1))
       => ( ( insert(A,Aa,A1) = insert(A,B2,B1) )
        <=> ( ( ( Aa = B2 )
             => ( A1 = B1 ) )
            & ( ( Aa != B2 )
             => ? [C1: fun(A,bool)] :
                  ( ( A1 = insert(A,B2,C1) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C1))
                  & ( B1 = insert(A,Aa,C1) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),C1)) ) ) ) ) ) ) ).

tff(fact_48_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B1))
       => ( ( insert(A,Xa,A1) = insert(A,Xa,B1) )
        <=> ( A1 = B1 ) ) ) ) ).

tff(fact_49_insert__code,axiom,
    ! [A: $tType,Xa: A,A1: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,A1),Xa))
    <=> ( ( Y2 = Xa )
        | pp(aa(A,bool,A1,Xa)) ) ) ).

tff(fact_50_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y2: A,Xa: A] : ( insert(A,Xa,insert(A,Y2,A1)) = insert(A,Y2,insert(A,Xa,A1)) ) ).

tff(fact_51_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),Aa: A] : ( insert(A,Aa,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),Aa))),P1)) ) ).

tff(fact_52_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),Aa: A] : ( insert(A,Aa,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),Aa)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_53_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),Aa: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,Aa,B1))) ).

tff(fact_54_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_55_atom_Osize_I1_J,axiom,
    ! [List1: list(int),Int: int] : ( atom_size(c_PresArith_Oatom_OLe(Int,List1)) = zero_zero(nat) ) ).

tff(fact_56_the__elem__eq,axiom,
    ! [A: $tType,Xa: A] : ( the_elem(A,insert(A,Xa,bot_bot(fun(A,bool)))) = Xa ) ).

tff(fact_57_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A6: A,B2: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,B2) = product_Pair(A,B,A6,B6) )
    <=> ( ( Aa = A6 )
        & ( B2 = B6 ) ) ) ).

tff(fact_58_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A3: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A3,B4))) ) ).

tff(fact_59_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys: list(A)] : ( Xsa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys) ) ) ).

tff(fact_60_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A5: A,List2: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) ) ) ).

tff(fact_61_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A4: A,B3: B,A2: A] :
      ( ( product_Pair(A,B,A2,B3) = product_Pair(A,B,A4,B5) )
     => ~ ( ( A2 = A4 )
         => ( B3 != B5 ) ) ) ).

tff(fact_62_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A3: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A3,B4))) ) ).

tff(fact_63_atom_Osize_I4_J,axiom,
    ! [List1: list(int),Int: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int,List1)) = zero_zero(nat) ) ).

tff(fact_64_hd,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => pp(atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),hd_coeff(X3)),insert(int,one_one(int),insert(int,number_number_of(int,min),bot_bot(fun(int,bool))))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X3)),one_one(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X3)),one_one(int))))),X3)) ) ).

tff(fact_65_singleton__conv,axiom,
    ! [A: $tType,Aa: A] : ( collect(A,combc(A,A,bool,fequal(A),Aa)) = insert(A,Aa,bot_bot(fun(A,bool))) ) ).

tff(fact_66_singleton__conv2,axiom,
    ! [A: $tType,Aa: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),Aa)) = insert(A,Aa,bot_bot(fun(A,bool))) ) ).

tff(fact_67_insert__compr__raw,axiom,
    ! [A: $tType,X3: A,Xa2: fun(A,bool)] : ( insert(A,X3,Xa2) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X3)),combc(A,fun(A,bool),bool,member(A),Xa2))) ) ).

tff(fact_68_Collect__conv__if,axiom,
    ! [A: $tType,Aa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),Aa)),P1)) = insert(A,Aa,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),Aa)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_69_Collect__conv__if2,axiom,
    ! [A: $tType,Aa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),Aa)),P1)) = insert(A,Aa,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),Aa)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_70_hd__coeff_Osimps_I1_J,axiom,
    ! [Ksa: list(int),Ia: int] : ( hd_coeff(c_PresArith_Oatom_OLe(Ia,Ksa)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ksa) ) ).

tff(fact_71_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_72_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_73_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_74_I__hd__coeffs1,axiom,
    ! [Xsa: list(int),Asa: list(atom)] :
      ( ! [X2: atom] :
          ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X2),set(atom,Asa)))
         => ( hd_coeff(X2) != zero_zero(int) ) )
     => ( ? [X1: int] :
          ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,qEpres1907640072oeffs1(Asa))))
           => i_Z(Xa1,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X1),Xsa)) )
      <=> ? [X1: int] :
          ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,Asa)))
           => i_Z(Xa1,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X1),Xsa)) ) ) ) ).

tff(fact_75_listset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( listset(A,nil(fun(A,bool))) = insert(list(A),nil(A),bot_bot(fun(list(A),bool))) ) ).

tff(fact_76_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Aa),List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_77_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_78_listset_Osimps_I2_J,axiom,
    ! [A: $tType,As: list(fun(A,bool)),A1: fun(A,bool)] : ( listset(A,aa(list(fun(A,bool)),list(fun(A,bool)),aa(fun(A,bool),fun(list(fun(A,bool)),list(fun(A,bool))),cons(fun(A,bool)),A1),As)) = set_Cons(A,A1,listset(A,As)) ) ).

tff(fact_79_I__cyclic,axiom,
    ! [E: list(int),J: int,Ia: int,Aa: atom] :
      ( pp(atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),Aa))
     => ( ( hd_coeff(Aa) = one_one(int) )
       => ( ( div_mod(int,Ia,divisor(Aa)) = div_mod(int,J,divisor(Aa)) )
         => ( i_Z(Aa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),Ia),E))
          <=> i_Z(Aa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),J),E)) ) ) ) ) ).

tff(fact_80_zmod__minus1__right,axiom,
    ! [A2: int] : ( div_mod(int,A2,number_number_of(int,min)) = zero_zero(int) ) ).

tff(fact_81_mod__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,one_one(A)) = zero_zero(A) ) ) ).

tff(fact_82_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,A2: A] : ( div_mod(A,div_mod(A,A2,B3),B3) = div_mod(A,A2,B3) ) ) ).

tff(fact_83_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,A2) = zero_zero(A) ) ) ).

tff(fact_84_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,zero_zero(A),A2) = zero_zero(A) ) ) ).

tff(fact_85_zmod__zero,axiom,
    ! [B3: int] : ( div_mod(int,zero_zero(int),B3) = zero_zero(int) ) ).

tff(fact_86_zmod__self,axiom,
    ! [A2: int] : ( div_mod(int,A2,A2) = zero_zero(int) ) ).

tff(fact_87_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_88_set__Cons__sing__Nil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( set_Cons(A,A1,insert(list(A),nil(A),bot_bot(fun(list(A),bool)))) = image(A,list(A),combc(A,list(A),list(A),cons(A),nil(A)),A1) ) ).

tff(fact_89_lists__empty,axiom,
    ! [A: $tType] : ( lists(A,bot_bot(fun(A,bool))) = insert(list(A),nil(A),bot_bot(fun(list(A),bool))) ) ).

tff(fact_90_image__eqI,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),Xa: B,F: fun(B,A),B2: A] :
      ( ( B2 = aa(B,A,F,Xa) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Xa),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),image(B,A,F,A1))) ) ) ).

tff(fact_91_empty__is__image,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A)] :
      ( ( bot_bot(fun(A,bool)) = image(B,A,F,A1) )
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_92_image__empty,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( image(B,A,F,bot_bot(fun(B,bool))) = bot_bot(fun(A,bool)) ) ).

tff(fact_93_image__is__empty,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A)] :
      ( ( image(B,A,F,A1) = bot_bot(fun(A,bool)) )
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_94_image__insert,axiom,
    ! [A: $tType,B: $tType,B1: fun(B,bool),Aa: B,F: fun(B,A)] : ( image(B,A,F,insert(B,Aa,B1)) = insert(A,aa(B,A,F,Aa),image(B,A,F,B1)) ) ).

tff(fact_95_Cons__in__lists__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),Xsa: list(A),Xa: A] :
      ( pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa)),lists(A,A1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
        & pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),Xsa),lists(A,A1))) ) ) ).

%----Arities (10)
tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Divides_Osemiring__div,axiom,
    semiring_div(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (23)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),c_PresArith_Oatom_OLe(li,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),one_one(int)),lks))),set(atom,as))) ).

%------------------------------------------------------------------------------
