%------------------------------------------------------------------------------
% File     : COM097_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 230
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_230 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  187 (  62 unt;  57 typ;   0 def)
%            Number of atoms       :  242 ( 105 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  163 (  51   ~;  17   |;  10   &)
%                                         (  28 <=>;  57  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   4 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   47 (  27   >;  20   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   1 prp; 0-3 aty)
%            Number of functors    :   40 (  40 usr;  10 con; 0-5 aty)
%            Number of variables   :  333 ( 288   !;   3   ?; 333   :)
%                                         (  42  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:23:28
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (50)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) * list(A) ) > T1 ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) * atom ) > T1 ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) * atom ) > T1 ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_thesis____,type,
    thesis: $o ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (96)
tff(fact_0__096a_A_058_Aset_Aas_096,axiom,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),a),set(atom,as))) ).

tff(fact_1_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int2: int,List2: list(int),Int1: int] :
      ( ( c_PresArith_Oatom_OLe(Int1,List2) = c_PresArith_Oatom_OLe(Int2,List3) )
    <=> ( ( Int1 = Int2 )
        & ( List2 = List3 ) ) ) ).

tff(fact_2_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A3: A,List2: list(A),Aa: A] :
      ( ( cons(A,Aa,List2) = cons(A,A3,List3) )
    <=> ( ( Aa = A3 )
        & ( List2 = List3 ) ) ) ).

tff(fact_3_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_4_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_5_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_6_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List2: list(int),Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int1,List2)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int1),List2) ) ).

tff(fact_7_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List2) ) ).

tff(fact_8__096I_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    i_Z(a,cons(int,x,xs)) ).

tff(fact_9_divisor_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( divisor(c_PresArith_Oatom_OLe(I1,Ks1)) = one_one(int) ) ).

tff(fact_10_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_11_atom_Orecs_I1_J,axiom,
    ! [A: $tType,List2: list(int),Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int1,List2)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int1),List2) ) ).

tff(fact_12_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( divisor(X3) != zero_zero(int) ) ) ).

tff(fact_13__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X1: int] :
    ! [Xa1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
     => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_14_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W1: int] :
          ( ( ring_1_of_int(A,W1) = ring_1_of_int(A,Z) )
        <=> ( W1 = Z ) ) ) ).

tff(fact_15_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => i_Z(X3,cons(int,x,xs)) ) ).

tff(fact_16__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int] :
        ~ ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
           => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_17_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,cons(A,Xa,Xsa))))
     => ( ( Y1 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa))) ) ) ).

tff(fact_18_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] : ( set(A,cons(A,Xa,Xsa)) = insert(A,Xa,set(A,Xsa)) ) ).

tff(fact_19_number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [K: int] : ( number_number_of(A,K) = ring_1_of_int(A,K) ) ) ).

tff(fact_20__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_21_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_22_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_23_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( ring_1_of_int(A,Z) = zero_zero(A) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_24_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_25_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int,W1: int] :
          ( ord_less(A,ring_1_of_int(A,W1),ring_1_of_int(A,Z))
        <=> ord_less(int,W1,Z) ) ) ).

tff(fact_26_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Y1) )
        <=> ( Xa = Y1 ) ) ) ).

tff(fact_27_of__int__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( ring_1_of_int(A,number_number_of(int,V)) = number_number_of(A,V) ) ) ).

tff(fact_28_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),number_number_of(A,Y1))
        <=> ord_less(int,Xa,Y1) ) ) ).

tff(fact_29_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less(int,Z,zero_zero(int)) ) ) ).

tff(fact_30_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less(int,zero_zero(int),Z) ) ) ).

tff(fact_31_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_32_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_33_less__number__of__int__code,axiom,
    ! [L: int,K1: int] :
      ( ord_less(int,number_number_of(int,K1),number_number_of(int,L))
    <=> ord_less(int,K1,L) ) ).

tff(fact_34_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_35_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A2: A] : ( nil(A) != cons(A,A2,List1) ) ).

tff(fact_36_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A2: A] : ( cons(A,A2,List1) != nil(A) ) ).

tff(fact_37_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,W1: int] :
          ( ( number_number_of(A,W1) = Xa )
        <=> ( Xa = number_number_of(A,W1) ) ) ) ).

tff(fact_38_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_39_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_40_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_41_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_42_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_43_of__int__m1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( ring_1_of_int(A,number_number_of(int,min)) = number_number_of(A,min) ) ) ).

tff(fact_44_rel__simps_I7_J,axiom,
    ~ ord_less(int,min,min) ).

tff(fact_45_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_46_int__number__of__def,axiom,
    ! [W: int] : ( number_number_of(int,W) = ring_1_of_int(int,W) ) ).

tff(fact_47_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_48_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_49_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_50_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_51_bin__less__0__simps_I2_J,axiom,
    ord_less(int,min,zero_zero(int)) ).

tff(fact_52_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_53_atom_Osize_I1_J,axiom,
    ! [List: list(int),Int: int] : ( atom_size(c_PresArith_Oatom_OLe(Int,List)) = zero_zero(nat) ) ).

tff(fact_54_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] : ( insert(A,Xa,insert(A,Xa,A1)) = insert(A,Xa,A1) ) ).

tff(fact_55_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,A1)))
    <=> ( ( Aa = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_56_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,A1)))
     => ( ( Aa != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_57_emptyE,axiom,
    ! [A: $tType,Aa: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),bot_bot(fun(A,bool)))) ).

tff(fact_58_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_59_empty__iff,axiom,
    ! [A: $tType,C2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),bot_bot(fun(A,bool)))) ).

tff(fact_60_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_61_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_62_insertCI,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),Aa: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B1))
       => ( Aa = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,B1))) ) ).

tff(fact_63_equals0D,axiom,
    ! [A: $tType,Aa: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ).

tff(fact_64_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_65_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_66_not__psubset__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ~ ord_less(fun(A,bool),A1,bot_bot(fun(A,bool))) ).

tff(fact_67_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( insert(A,Aa,A1) = A1 ) ) ).

tff(fact_68_insertI2,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,B1))) ) ).

tff(fact_69_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B2: A,A1: fun(A,bool),Aa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B1))
       => ( ( insert(A,Aa,A1) = insert(A,B2,B1) )
        <=> ( ( ( Aa = B2 )
             => ( A1 = B1 ) )
            & ( ( Aa != B2 )
             => ? [C3: fun(A,bool)] :
                  ( ( A1 = insert(A,B2,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C3))
                  & ( B1 = insert(A,Aa,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),C3)) ) ) ) ) ) ) ).

tff(fact_70_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B1))
       => ( ( insert(A,Xa,A1) = insert(A,Xa,B1) )
        <=> ( A1 = B1 ) ) ) ) ).

tff(fact_71_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_72_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_73_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_74_insert__code,axiom,
    ! [A: $tType,Xa: A,A1: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,A1),Xa))
    <=> ( ( Y1 = Xa )
        | pp(aa(A,bool,A1,Xa)) ) ) ).

tff(fact_75_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y1: A,Xa: A] : ( insert(A,Xa,insert(A,Y1,A1)) = insert(A,Y1,insert(A,Xa,A1)) ) ).

tff(fact_76_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),Aa: A] : ( insert(A,Aa,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),Aa))),P1)) ) ).

tff(fact_77_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),Aa: A] : ( insert(A,Aa,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),Aa)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_78_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),Aa: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,Aa,B1))) ).

tff(fact_79_singleton__inject,axiom,
    ! [A: $tType,B2: A,Aa: A] :
      ( ( insert(A,Aa,bot_bot(fun(A,bool))) = insert(A,B2,bot_bot(fun(A,bool))) )
     => ( Aa = B2 ) ) ).

tff(fact_80_singletonE,axiom,
    ! [A: $tType,Aa: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,Aa,bot_bot(fun(A,bool)))))
     => ( B2 = Aa ) ) ).

tff(fact_81_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C2: A,B2: A,Aa: A] :
      ( ( insert(A,Aa,insert(A,B2,bot_bot(fun(A,bool)))) = insert(A,C2,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( Aa = C2 )
          & ( B2 = D ) )
        | ( ( Aa = D )
          & ( B2 = C2 ) ) ) ) ).

tff(fact_82_singleton__iff,axiom,
    ! [A: $tType,Aa: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,Aa,bot_bot(fun(A,bool)))))
    <=> ( B2 = Aa ) ) ).

tff(fact_83_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] : ( insert(A,Aa,A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_84_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] : ( bot_bot(fun(A,bool)) != insert(A,Aa,A1) ) ).

tff(fact_85_atom_Osize_I4_J,axiom,
    ! [List: list(int),Int: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int,List)) = zero_zero(nat) ) ).

tff(fact_86_the__elem__eq,axiom,
    ! [A: $tType,Xa: A] : ( the_elem(A,insert(A,Xa,bot_bot(fun(A,bool)))) = Xa ) ).

tff(fact_87_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_88_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_89_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_90_psubsetD,axiom,
    ! [A: $tType,C2: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_91_psubset__trans,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less(fun(A,bool),A1,B1)
     => ( ord_less(fun(A,bool),B1,C1)
       => ord_less(fun(A,bool),A1,C1) ) ) ).

tff(fact_92_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) ) ) ) ).

tff(fact_93_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_94_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_95_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

%----Arities (14)
tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (18)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [I: int,Ks: list(int)] :
      ( ( a = c_PresArith_Oatom_OLe(I,cons(int,one_one(int),Ks)) )
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
