%------------------------------------------------------------------------------
% File     : COM095_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 225
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_225 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  170 (  55 unt;  53 typ;   0 def)
%            Number of atoms       :  217 (  97 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  141 (  41   ~;   6   |;  20   &)
%                                         (  22 <=>;  52  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   57 (  31   >;  26   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   39 (  39 usr;   8 con; 0-6 aty)
%            Number of variables   :  447 ( 388   !;  12   ?; 447   :)
%                                         (  47  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:23:13
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_HOL_Oequal,type,
    cl_HOL_Oequal: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Enum_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( ( nat * list(A) ) > list(list(A)) ) ).

tff(sy_c_Enum_Oproduct,type,
    product: 
      !>[A: $tType,B1: $tType] : ( ( list(A) * list(B1) ) > list(product_prod(A,B1)) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B1: $tType,C: $tType] : ( ( fun(A,fun(B1,C)) * list(A) * list(B1) ) > list(C) ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olexord,type,
    lexord: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oremdups,type,
    remdups: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_List_Otranspose,type,
    transpose: 
      !>[A: $tType] : ( list(list(A)) > list(list(A)) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B1: $tType] : ( ( A * B1 ) > product_prod(A,B1) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B1: $tType,C: $tType] : ( ( fun(product_prod(A,B1),C) * A * B1 ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B1: $tType,C: $tType] : ( ( fun(A,fun(B1,C)) * product_prod(A,B1) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B1: $tType,T: $tType] : ( ( fun(A,fun(B1,T)) * product_prod(A,B1) ) > T ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_li____,type,
    li: int ).

tff(sy_v_lks____,type,
    lks: list(int) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096a_A_058_Aset_Aas_096,axiom,
    member(atom,a,aa(list(atom),fun(atom,bool),set(atom),as)) ).

tff(fact_1_x,axiom,
    ! [X3: atom] :
      ( member(atom,X3,aa(list(atom),fun(atom,bool),set(atom),as))
     => i_Z(X3,cons(int,x,xs)) ) ).

tff(fact_2__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X1: int] :
    ! [Xa1: atom] :
      ( member(atom,Xa1,aa(list(atom),fun(atom,bool),set(atom),as))
     => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_3__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int] :
        ~ ! [Xa1: atom] :
            ( member(atom,Xa1,aa(list(atom),fun(atom,bool),set(atom),as))
           => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_4_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),Aa: A] :
      ( ( cons(A,Aa,List2) = cons(A,A6,List3) )
    <=> ( ( Aa = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_5_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_6_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_7_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y1: A] :
      ( member(A,Y1,aa(list(A),fun(A,bool),set(A),cons(A,Xa,Xsa)))
     => ( ( Y1 = Xa )
        | member(A,Y1,aa(list(A),fun(A,bool),set(A),Xsa)) ) ) ).

tff(fact_8_list_Osimps_I5_J,axiom,
    ! [A: $tType,B1: $tType,List2: list(B1),Aa: B1,F21: fun(B1,fun(list(B1),A)),F11: A] : ( list_case(A,B1,F11,F21,cons(B1,Aa,List2)) = aa(list(B1),A,aa(B1,fun(list(B1),A),F21,Aa),List2) ) ).

tff(fact_9_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_10_list_Orecs_I2_J,axiom,
    ! [A: $tType,B1: $tType,List2: list(B1),Aa: B1,F21: fun(B1,fun(list(B1),fun(A,A))),F11: A] : ( list_rec(A,B1,F11,F21,cons(B1,Aa,List2)) = aa(A,A,aa(list(B1),fun(A,A),aa(B1,fun(list(B1),fun(A,A)),F21,Aa),List2),list_rec(A,B1,F11,F21,List2)) ) ).

tff(fact_11_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ~ null(A,cons(A,X,Xs)) ).

tff(fact_12_zipwith0_Osimps_I2_J,axiom,
    ! [B1: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B1) )
     => ! [Ys2: list(C),Y1: C,Xsa: list(B1),Xa: B1,F: fun(B1,fun(C,A))] : ( zipwith0(B1,C,A,F,cons(B1,Xa,Xsa),cons(C,Y1,Ys2)) = cons(A,aa(C,A,aa(B1,fun(C,A),F,Xa),Y1),zipwith0(B1,C,A,F,Xsa,Ys2)) ) ) ).

tff(fact_13_elem,axiom,
    ! [A: $tType,Xs: list(A),X: A] : listMem(A,X,cons(A,X,Xs)) ).

tff(fact_14_member__rec_I1_J,axiom,
    ! [A: $tType,Y1: A,Xsa: list(A),Xa: A] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),cons(A,Xa,Xsa)),Y1))
    <=> ( ( Xa = Y1 )
        | pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),Y1)) ) ) ).

tff(fact_15_member__set,axiom,
    ! [A: $tType] : ( member1(A) = set(A) ) ).

tff(fact_16_List_Omember__def,axiom,
    ! [A: $tType,Xa: A,Xsa: list(A)] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),Xa))
    <=> member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa)) ) ).

tff(fact_17_ListMem__iff,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( listMem(A,Xa,Xsa)
    <=> member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa)) ) ).

tff(fact_18_in__set__member,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
    <=> pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),Xa)) ) ).

tff(fact_19_insert,axiom,
    ! [A: $tType,Y: A,Xs: list(A),X: A] :
      ( listMem(A,X,Xs)
     => listMem(A,X,cons(A,Y,Xs)) ) ).

tff(fact_20__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_21_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ~ member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
     => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ).

tff(fact_22_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
       => ( insert(A,Xa,Xsa) = Xsa ) )
      & ( ~ member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
       => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ) ).

tff(fact_23_norm,axiom,
    ! [X3: atom] :
      ( member(atom,X3,aa(list(atom),fun(atom,bool),set(atom),as))
     => ( divisor(X3) != zero_zero(int) ) ) ).

tff(fact_24_remdups_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
       => ( remdups(A,cons(A,Xa,Xsa)) = remdups(A,Xsa) ) )
      & ( ~ member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
       => ( remdups(A,cons(A,Xa,Xsa)) = cons(A,Xa,remdups(A,Xsa)) ) ) ) ).

tff(fact_25_ListMem_Osimps,axiom,
    ! [A: $tType,A21: list(A),A11: A] :
      ( listMem(A,A11,A21)
    <=> ( ? [X2: A,Xs2: list(A)] :
            ( ( A11 = X2 )
            & ( A21 = cons(A,X2,Xs2) ) )
        | ? [X2: A,Xs2: list(A),Y3: A] :
            ( ( A11 = X2 )
            & ( A21 = cons(A,Y3,Xs2) )
            & listMem(A,X2,Xs2) ) ) ) ).

tff(fact_26_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P: fun(A,bool)] :
      ( list_ex1(A,P,Xsa)
    <=> ? [X2: A] :
          ( member(A,X2,aa(list(A),fun(A,bool),set(A),Xsa))
          & pp(aa(A,bool,P,X2))
          & ! [Y3: A] :
              ( ( member(A,Y3,aa(list(A),fun(A,bool),set(A),Xsa))
                & pp(aa(A,bool,P,Y3)) )
             => ( Y3 = X2 ) ) ) ) ).

tff(fact_27_set__rotate1,axiom,
    ! [A: $tType,Xsa: list(A)] : ( aa(list(A),fun(A,bool),set(A),rotate1(A,Xsa)) = aa(list(A),fun(A,bool),set(A),Xsa) ) ).

tff(fact_28_set__remdups,axiom,
    ! [A: $tType,Xsa: list(A)] : ( aa(list(A),fun(A,bool),set(A),remdups(A,Xsa)) = aa(list(A),fun(A,bool),set(A),Xsa) ) ).

tff(fact_29_remdups_Osimps_I1_J,axiom,
    ! [A: $tType] : ( remdups(A,nil(A)) = nil(A) ) ).

tff(fact_30_remdups__eq__nil__right__iff,axiom,
    ! [A: $tType,Xa: list(A)] :
      ( ( nil(A) = remdups(A,Xa) )
    <=> ( Xa = nil(A) ) ) ).

tff(fact_31_remdups__eq__nil__iff,axiom,
    ! [A: $tType,Xa: list(A)] :
      ( ( remdups(A,Xa) = nil(A) )
    <=> ( Xa = nil(A) ) ) ).

tff(fact_32_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( rotate1(A,Xsa) = nil(A) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_33_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B1: $tType,A: $tType] :
      ( ( zero(B1)
        & zero(C) )
     => ! [F: fun(B1,fun(C,A))] : ( zipwith0(B1,C,A,F,nil(B1),nil(C)) = nil(A) ) ) ).

tff(fact_34_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_35_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_36_zipwith0_Osimps_I3_J,axiom,
    ! [B1: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B1) )
     => ! [Xsa: list(B1),Xa: B1,F: fun(B1,fun(C,A))] : ( zipwith0(B1,C,A,F,cons(B1,Xa,Xsa),nil(C)) = cons(A,aa(C,A,aa(B1,fun(C,A),F,Xa),zero_zero(C)),zipwith0(B1,C,A,F,Xsa,nil(C))) ) ) ).

tff(fact_37_zipwith0_Osimps_I4_J,axiom,
    ! [B1: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B1) )
     => ! [Ys2: list(C),Y1: C,F: fun(B1,fun(C,A))] : ( zipwith0(B1,C,A,F,nil(B1),cons(C,Y1,Ys2)) = cons(A,aa(C,A,aa(B1,fun(C,A),F,zero_zero(B1)),Y1),zipwith0(B1,C,A,F,nil(B1),Ys2)) ) ) ).

tff(fact_38_remdups__remdups,axiom,
    ! [A: $tType,Xs: list(A)] : ( remdups(A,remdups(A,Xs)) = remdups(A,Xs) ) ).

tff(fact_39_insert__remdups,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( insert(A,X,remdups(A,Xs)) = remdups(A,insert(A,X,Xs)) ) ).

tff(fact_40_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_41_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_42_list_Osimps_I4_J,axiom,
    ! [B1: $tType,A: $tType,F21: fun(B1,fun(list(B1),A)),F11: A] : ( list_case(A,B1,F11,F21,nil(B1)) = F11 ) ).

tff(fact_43_eq__Nil__null,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa = nil(A) )
    <=> null(A,Xsa) ) ).

tff(fact_44_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_45_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_46_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] : ~ pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),nil(A)),Y)) ).

tff(fact_47_List_Onull__def,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( null(A,Xsa)
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_48_null__rec_I2_J,axiom,
    ! [B1: $tType] : null(B1,nil(B1)) ).

tff(fact_49_list_Orecs_I1_J,axiom,
    ! [B1: $tType,A: $tType,F21: fun(B1,fun(list(B1),fun(A,A))),F11: A] : ( list_rec(A,B1,F11,F21,nil(B1)) = F11 ) ).

tff(fact_50_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
     => ( insert(A,Xa,Xsa) = Xsa ) ) ).

tff(fact_51_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_52_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y3: A,Ys1: list(A)] : ( Xsa = cons(A,Y3,Ys1) ) ) ).

tff(fact_53_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != cons(A,A2,List) ) ) ).

tff(fact_54_calculation_I1_J,axiom,
    member(product_prod(int,list(int)),product_Pair(int,list(int),li,lks),aa(list(product_prod(int,list(int))),fun(product_prod(int,list(int)),bool),set(product_prod(int,list(int))),lbounds(as))) ).

tff(fact_55_equal__Nil__null,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),Xsa),nil(A)))
    <=> null(A,Xsa) ) ).

tff(fact_56_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( iprod(A,nil(A),Ys) = zero_zero(A) ) ) ).

tff(fact_57_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( iprod(A,Xs,nil(A)) = zero_zero(A) ) ) ).

tff(fact_58_equal__list__def,axiom,
    ! [A: $tType,Y1: list(A),Xa: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),Xa),Y1))
    <=> ( Xa = Y1 ) ) ).

tff(fact_59_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_60_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X1: A] :
              ( member(A,X1,aa(list(A),fun(A,bool),set(A),Cs))
             => ( X1 = zero_zero(A) ) )
         => ( iprod(A,Cs,Xsa) = zero_zero(A) ) ) ) ).

tff(fact_61_split__paired__All,axiom,
    ! [A: $tType,B1: $tType,P: fun(product_prod(A,B1),bool)] :
      ( ! [X11: product_prod(A,B1)] : pp(aa(product_prod(A,B1),bool,P,X11))
    <=> ! [A3: A,B3: B1] : pp(aa(product_prod(A,B1),bool,P,product_Pair(A,B1,A3,B3))) ) ).

tff(fact_62_Pair__eq,axiom,
    ! [A: $tType,B1: $tType,B6: B1,A6: A,B: B1,Aa: A] :
      ( ( product_Pair(A,B1,Aa,B) = product_Pair(A,B1,A6,B6) )
    <=> ( ( Aa = A6 )
        & ( B = B6 ) ) ) ).

tff(fact_63_Pair__inject,axiom,
    ! [A: $tType,B1: $tType,B5: B1,A5: A,B4: B1,A4: A] :
      ( ( product_Pair(A,B1,A4,B4) = product_Pair(A,B1,A5,B5) )
     => ~ ( ( A4 = A5 )
         => ( B4 != B5 ) ) ) ).

tff(fact_64_split__paired__Ex,axiom,
    ! [A: $tType,B1: $tType,P: fun(product_prod(A,B1),bool)] :
      ( ? [X11: product_prod(A,B1)] : pp(aa(product_prod(A,B1),bool,P,X11))
    <=> ? [A3: A,B3: B1] : pp(aa(product_prod(A,B1),bool,P,product_Pair(A,B1,A3,B3))) ) ).

tff(fact_65_prod_Orecs,axiom,
    ! [B1: $tType,A: $tType,C: $tType,B: C,Aa: B1,F11: fun(B1,fun(C,A))] : ( product_prod_rec(B1,C,A,F11,product_Pair(B1,C,Aa,B)) = aa(C,A,aa(B1,fun(C,A),F11,Aa),B) ) ).

tff(fact_66_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C: $tType,B1: $tType,A: $tType,Xa: product_prod(A,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F1))))),P: fun(product_prod(A,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A2: A,B2: B1,C2: C,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P,product_Pair(A,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F1))),B2,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2)))))))
     => pp(aa(product_prod(A,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P,Xa)) ) ).

tff(fact_67_prod__cases6,axiom,
    ! [A: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,F1: $tType,Y: product_prod(A,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A2: A,B2: B1,C2: C,D1: D,E1: E,F2: F1] : ( Y != product_Pair(A,product_prod(B1,product_prod(C,product_prod(D,product_prod(E,F1)))),A2,product_Pair(B1,product_prod(C,product_prod(D,product_prod(E,F1))),B2,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2))))) ) ).

tff(fact_68_prod__cases5,axiom,
    ! [A: $tType,B1: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B1,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A,B2: B1,C2: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B1,product_prod(C,product_prod(D,E))),A2,product_Pair(B1,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_69_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B1: $tType,A: $tType,Xa: product_prod(A,product_prod(B1,product_prod(C,product_prod(D,E)))),P: fun(product_prod(A,product_prod(B1,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B2: B1,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P,product_Pair(A,product_prod(B1,product_prod(C,product_prod(D,E))),A2,product_Pair(B1,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B1,product_prod(C,product_prod(D,E)))),bool,P,Xa)) ) ).

tff(fact_70_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B1: $tType,A: $tType,Xa: product_prod(A,product_prod(B1,product_prod(C,D))),P: fun(product_prod(A,product_prod(B1,product_prod(C,D))),bool)] :
      ( ! [A2: A,B2: B1,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B1,product_prod(C,D))),bool,P,product_Pair(A,product_prod(B1,product_prod(C,D)),A2,product_Pair(B1,product_prod(C,D),B2,product_Pair(C,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B1,product_prod(C,D))),bool,P,Xa)) ) ).

tff(fact_71_prod__cases4,axiom,
    ! [A: $tType,B1: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B1,product_prod(C,D)))] :
      ~ ! [A2: A,B2: B1,C2: C,D1: D] : ( Y != product_Pair(A,product_prod(B1,product_prod(C,D)),A2,product_Pair(B1,product_prod(C,D),B2,product_Pair(C,D,C2,D1))) ) ).

tff(fact_72_prod__induct3,axiom,
    ! [C: $tType,B1: $tType,A: $tType,Xa: product_prod(A,product_prod(B1,C)),P: fun(product_prod(A,product_prod(B1,C)),bool)] :
      ( ! [A2: A,B2: B1,C2: C] : pp(aa(product_prod(A,product_prod(B1,C)),bool,P,product_Pair(A,product_prod(B1,C),A2,product_Pair(B1,C,B2,C2))))
     => pp(aa(product_prod(A,product_prod(B1,C)),bool,P,Xa)) ) ).

tff(fact_73_prod__cases3,axiom,
    ! [A: $tType,B1: $tType,C: $tType,Y: product_prod(A,product_prod(B1,C))] :
      ~ ! [A2: A,B2: B1,C2: C] : ( Y != product_Pair(A,product_prod(B1,C),A2,product_Pair(B1,C,B2,C2)) ) ).

tff(fact_74_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X1: A] : ( aa(A,B1,F,X1) = aa(A,B1,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( member(A,Xa,A1)
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_76_prod_Oexhaust,axiom,
    ! [A: $tType,B1: $tType,Y: product_prod(A,B1)] :
      ~ ! [A2: A,B2: B1] : ( Y != product_Pair(A,B1,A2,B2) ) ).

tff(fact_77_PairE,axiom,
    ! [A: $tType,B1: $tType,P1: product_prod(A,B1)] :
      ~ ! [X1: A,Y2: B1] : ( P1 != product_Pair(A,B1,X1,Y2) ) ).

tff(fact_78_internal__split__conv,axiom,
    ! [B1: $tType,A: $tType,C: $tType,B: C,Aa: B1,C1: fun(B1,fun(C,A))] : ( produc1605651328_split(B1,C,A,C1,product_Pair(B1,C,Aa,B)) = aa(C,A,aa(B1,fun(C,A),C1,Aa),B) ) ).

tff(fact_79_curry__conv,axiom,
    ! [A: $tType,B1: $tType,C: $tType,B: C,Aa: B1,F: fun(product_prod(B1,C),A)] : ( product_curry(B1,C,A,F,Aa,B) = aa(product_prod(B1,C),A,F,product_Pair(B1,C,Aa,B)) ) ).

tff(fact_80_sublist__singleton,axiom,
    ! [A: $tType,Xa: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,Xa,nil(A)),A1) = cons(A,Xa,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,Xa,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_81_curryI,axiom,
    ! [A: $tType,B1: $tType,B: B1,Aa: A,F: fun(product_prod(A,B1),bool)] :
      ( pp(aa(product_prod(A,B1),bool,F,product_Pair(A,B1,Aa,B)))
     => pp(product_curry(A,B1,bool,F,Aa,B)) ) ).

tff(fact_82_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_83_notin__set__sublistI,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( ~ member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa))
     => ~ member(A,Xa,aa(list(A),fun(A,bool),set(A),sublist(A,Xsa,I))) ) ).

tff(fact_84_in__set__sublistD,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( member(A,Xa,aa(list(A),fun(A,bool),set(A),sublist(A,Xsa,I)))
     => member(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa)) ) ).

tff(fact_85_curryE,axiom,
    ! [A: $tType,B1: $tType,B: B1,Aa: A,F: fun(product_prod(A,B1),bool)] :
      ( pp(product_curry(A,B1,bool,F,Aa,B))
     => pp(aa(product_prod(A,B1),bool,F,product_Pair(A,B1,Aa,B))) ) ).

tff(fact_86_curryD,axiom,
    ! [A: $tType,B1: $tType,B: B1,Aa: A,F: fun(product_prod(A,B1),bool)] :
      ( pp(product_curry(A,B1,bool,F,Aa,B))
     => pp(aa(product_prod(A,B1),bool,F,product_Pair(A,B1,Aa,B))) ) ).

tff(fact_87_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_88_list__nonempty__induct,axiom,
    ! [A: $tType,P: fun(list(A),bool),Xsa: list(A)] :
      ( ( Xsa != nil(A) )
     => ( ! [X1: A] : pp(aa(list(A),bool,P,cons(A,X1,nil(A))))
       => ( ! [X1: A,Xs1: list(A)] :
              ( ( Xs1 != nil(A) )
             => ( pp(aa(list(A),bool,P,Xs1))
               => pp(aa(list(A),bool,P,cons(A,X1,Xs1))) ) )
         => pp(aa(list(A),bool,P,Xsa)) ) ) ) ).

tff(fact_89_product_Osimps_I1_J,axiom,
    ! [B1: $tType,A: $tType,Uu: list(B1)] : ( product(A,B1,nil(A),Uu) = nil(product_prod(A,B1)) ) ).

tff(fact_90_equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( equal_equal(A) = fequal(A) ) ) ).

tff(fact_91_eq__equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( fequal(A) = equal_equal(A) ) ) ).

tff(fact_92_equal__eq,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [Y1: A,Xa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),Xa),Y1))
        <=> ( Xa = Y1 ) ) ) ).

tff(fact_93_equal__refl,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [X: A] : pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X),X)) ) ).

tff(fact_94_n__lists__Nil,axiom,
    ! [A: $tType,N: nat] :
      ( ( ( N = zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = cons(list(A),nil(A),nil(list(A))) ) )
      & ( ( N != zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = nil(list(A)) ) ) ) ).

tff(fact_95_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs: list(A)] : ( n_lists(A,zero_zero(nat),Xs) = cons(list(A),nil(A),nil(list(A))) ) ).

tff(fact_96_transpose_Osimps_I2_J,axiom,
    ! [A: $tType,Xss: list(list(A))] : ( transpose(A,cons(list(A),nil(A),Xss)) = transpose(A,Xss) ) ).

tff(fact_97_lexord__cons__cons,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Y1: list(A),B: A,Xa: list(A),Aa: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,Aa,Xa),cons(A,B,Y1)),lexord(A,R))
    <=> ( member(product_prod(A,A),product_Pair(A,A,Aa,B),R)
        | ( ( Aa = B )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xa,Y1),lexord(A,R)) ) ) ) ).

tff(fact_98_transpose_Osimps_I1_J,axiom,
    ! [A: $tType] : ( transpose(A,nil(list(A))) = nil(list(A)) ) ).

%----Arities (13)
tff(arity_prod___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(product_prod(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_fun___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( cl_HOL_Oequal(T_2)
        & enum(T_1) )
     => cl_HOL_Oequal(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___HOL_Oequal,axiom,
    cl_HOL_Oequal(int) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___HOL_Oequal,axiom,
    cl_HOL_Oequal(nat) ).

tff(arity_HOL_Obool___HOL_Oequal,axiom,
    cl_HOL_Oequal(bool) ).

tff(arity_List_Olist___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(list(T_1)) ).

tff(arity_PresArith_Oatom___HOL_Oequal,axiom,
    cl_HOL_Oequal(atom) ).

tff(arity_prod___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] : cl_HOL_Oequal(product_prod(T_1,T_2)) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    i_Z(a,cons(int,x,xs)) ).

%------------------------------------------------------------------------------
