%------------------------------------------------------------------------------
% File     : COM088_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 212
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_212 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  185 (  46 unt;  54 typ;   0 def)
%            Number of atoms       :  273 (  98 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  185 (  43   ~;  14   |;  21   &)
%                                         (  17 <=>;  90  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   47 (  26   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-3 aty)
%            Number of functors    :   39 (  39 usr;   8 con; 0-5 aty)
%            Number of variables   :  456 ( 396   !;   7   ?; 456   :)
%                                         (  53  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:28
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(list(A),fun(list(B),list(C))) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olinorder__class_Oinsort__insert__key,type,
    linord2118332866rt_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * B * list(B) ) > list(B) ) ).

tff(sy_c_List_Olinorder__class_Oinsort__key,type,
    linorder_insort_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * B * list(B) ) > list(B) ) ).

tff(sy_c_List_Olinorder__class_Osort__key,type,
    linorder_sort_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * list(B) ) > list(B) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(product_prod(A,B),C)) ).

tff(sy_c_Product__Type_Oprod_Oprod__case,type,
    product_prod_case: 
      !>[A: $tType,B: $tType,T: $tType] : fun(fun(A,fun(B,T)),fun(product_prod(A,B),T)) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_1_finite__imageI,axiom,
    ! [B: $tType,A: $tType,H: fun(A,B),F3: fun(A,bool)] :
      ( finite_finite(A,F3)
     => finite_finite(B,image(A,B,H,F3)) ) ).

tff(fact_2_finite__set,axiom,
    ! [A: $tType,Xsa: list(A)] : finite_finite(A,set(A,Xsa)) ).

tff(fact_3_finite__Collect__disjI,axiom,
    ! [A: $tType,Q2: fun(A,bool),P1: fun(A,bool)] :
      ( finite_finite(A,collect(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),P1),Q2)))
    <=> ( finite_finite(A,collect(A,P1))
        & finite_finite(A,collect(A,Q2)) ) ) ).

tff(fact_4_finite__Collect__conjI,axiom,
    ! [A: $tType,Q2: fun(A,bool),P1: fun(A,bool)] :
      ( ( finite_finite(A,collect(A,P1))
        | finite_finite(A,collect(A,Q2)) )
     => finite_finite(A,collect(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),P1),Q2))) ) ).

tff(fact_5_image__eqI,axiom,
    ! [A: $tType,B: $tType,A2: fun(B,bool),Xa: B,F: fun(B,A),B1: A] :
      ( ( B1 = aa(B,A,F,Xa) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Xa),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),image(B,A,F,A2))) ) ) ).

tff(fact_6_finite__code,axiom,
    ! [A: $tType] :
      ( finite_finite1(A)
     => ! [A2: fun(A,bool)] : finite_finite(A,A2) ) ).

tff(fact_7_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_8_split__twice,axiom,
    ! [B: $tType,C: $tType,A: $tType,E: $tType,D1: $tType,P2: product_prod(D1,E),G: fun(D1,fun(E,product_prod(B,C))),F: fun(B,fun(C,A))] : ( aa(product_prod(B,C),A,aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F),aa(product_prod(D1,E),product_prod(B,C),aa(fun(D1,fun(E,product_prod(B,C))),fun(product_prod(D1,E),product_prod(B,C)),product_prod_case(D1,E,product_prod(B,C)),G),P2)) = aa(product_prod(D1,E),A,aa(fun(D1,fun(E,A)),fun(product_prod(D1,E),A),product_prod_case(D1,E,A),aa(fun(D1,fun(E,product_prod(B,C))),fun(D1,fun(E,A)),aa(fun(fun(E,product_prod(B,C)),fun(E,A)),fun(fun(D1,fun(E,product_prod(B,C))),fun(D1,fun(E,A))),combb(fun(E,product_prod(B,C)),fun(E,A),D1),aa(fun(product_prod(B,C),A),fun(fun(E,product_prod(B,C)),fun(E,A)),combb(product_prod(B,C),A,E),aa(fun(B,fun(C,A)),fun(product_prod(B,C),A),product_prod_case(B,C,A),F))),G)),P2) ) ).

tff(fact_9_image__image,axiom,
    ! [B: $tType,A: $tType,C: $tType,A2: fun(C,bool),G: fun(C,B),F: fun(B,A)] : ( image(B,A,F,image(C,B,G,A2)) = image(C,A,aa(fun(C,B),fun(C,A),aa(fun(B,A),fun(fun(C,B),fun(C,A)),combb(B,A,C),F),G),A2) ) ).

tff(fact_10_image__ident,axiom,
    ! [A: $tType,Y3: fun(A,bool)] : ( image(A,A,combi(A),Y3) = Y3 ) ).

tff(fact_11_pigeonhole__infinite,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A2: fun(A,bool)] :
      ( ~ finite_finite(A,A2)
     => ( finite_finite(B,image(A,B,F,A2))
       => ? [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A2))
            & ~ finite_finite(A,collect(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),combc(A,fun(A,bool),bool,member(A),A2)),combc(A,B,bool,aa(fun(A,B),fun(A,fun(B,bool)),aa(fun(B,fun(B,bool)),fun(fun(A,B),fun(A,fun(B,bool))),combb(B,fun(B,bool),A),fequal(B)),F),aa(A,B,F,X1))))) ) ) ) ).

tff(fact_12_split__weak__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,C1: fun(A,fun(B,C)),Q1: product_prod(A,B),P2: product_prod(A,B)] :
      ( ( P2 = Q1 )
     => ( aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),P2) = aa(product_prod(A,B),C,aa(fun(A,fun(B,C)),fun(product_prod(A,B),C),product_prod_case(A,B,C),C1),Q1) ) ) ).

tff(fact_13_finite__Diff,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( finite_finite(A,A2)
     => finite_finite(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2)) ) ).

tff(fact_14_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),nil(A)) = Xs ) ) ).

tff(fact_15_finite__Diff2,axiom,
    ! [A: $tType,A2: fun(A,bool),B2: fun(A,bool)] :
      ( finite_finite(A,B2)
     => ( finite_finite(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2))
      <=> finite_finite(A,A2) ) ) ).

tff(fact_16_finite,axiom,
    ! [A: $tType] :
      ( finite_finite1(A)
     => ! [A2: fun(A,bool)] : finite_finite(A,A2) ) ).

tff(fact_17_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B1: B,A2: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
     => ( ( B1 = aa(A,B,F,Xa) )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),image(A,B,F,A2))) ) ) ).

tff(fact_18_imageI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A2: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,Xa)),image(A,B,F,A2))) ) ).

tff(fact_19_image__iff,axiom,
    ! [A: $tType,B: $tType,A2: fun(B,bool),F: fun(B,A),Z: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Z),image(B,A,F,A2)))
    <=> ? [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A2))
          & ( Z = aa(B,A,F,X3) ) ) ) ).

tff(fact_20_imageE,axiom,
    ! [A: $tType,B: $tType,A2: fun(B,bool),F: fun(B,A),B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),image(B,A,F,A2)))
     => ~ ! [X1: B] :
            ( ( B1 = aa(B,A,F,X1) )
           => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A2)) ) ) ).

tff(fact_21_finite__list,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( finite_finite(A,A2)
     => ? [Xs1: list(A)] : ( set(A,Xs1) = A2 ) ) ).

tff(fact_22_internal__split__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] : ( produc1605651328_split(A,B,C) = product_prod_case(A,B,C) ) ).

tff(fact_23_image__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),N1: fun(A,bool),M1: fun(A,bool)] :
      ( ( M1 = N1 )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),N1))
           => ( aa(A,B,F,X1) = aa(A,B,G,X1) ) )
       => ( image(A,B,F,M1) = image(A,B,G,N1) ) ) ) ).

tff(fact_24_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_25_x,axiom,
    ! [X2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X2),set(atom,as)))
     => i_Z(X2,cons(int,x,xs)) ) ).

tff(fact_26_list__diff__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ( minus_minus(list(A)) = zipwith0(A,A,A,minus_minus(A)) ) ) ).

tff(fact_27__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X1: int] :
    ! [Xa1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
     => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_28_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_29_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),A1: A] :
      ( ( cons(A,A1,List2) = cons(A,A6,List3) )
    <=> ( ( A1 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_30_Diff__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
        & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B2)) ) ) ).

tff(fact_31_Diff__idemp,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2)),B2) = aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2) ) ).

tff(fact_32_DiffI,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2))) ) ) ).

tff(fact_33_DiffE,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2)))
     => ~ ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B2)) ) ) ).

tff(fact_34_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys1: list(C),Y1: C,Xsa: list(B),Xa: B,F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),cons(B,Xa,Xsa)),cons(C,Y1,Ys1)) = cons(A,aa(C,A,aa(B,fun(C,A),F,Xa),Y1),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),Xsa),Ys1)) ) ) ).

tff(fact_35_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),nil(C)) = nil(A) ) ) ).

tff(fact_36_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),cons(A,X,Xs)),cons(A,Y,Ys)) = cons(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),X),Y),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)) ) ) ).

tff(fact_37__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int] :
        ~ ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
           => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_38_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_39_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_40_set__diff__eq,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2) = collect(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),combc(A,fun(A,bool),bool,member(A),A2)),aa(fun(A,bool),fun(A,bool),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot),combc(A,fun(A,bool),bool,member(A),B2)))) ) ).

tff(fact_41_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A1: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A1,List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A1),List2) ) ).

tff(fact_42_DiffD1,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2)))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2)) ) ).

tff(fact_43_DiffD2,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A2),B2)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B2)) ) ).

tff(fact_44_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,cons(A,Xa,Xsa))))
     => ( ( Y1 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa))) ) ) ).

tff(fact_45_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_46_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_47_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
          & pp(aa(A,bool,P1,X3))
          & ! [Y2: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa)))
                & pp(aa(A,bool,P1,Y2)) )
             => ( Y2 = X3 ) ) ) ) ).

tff(fact_48_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List: list(A)] : ( Y != cons(A,A4,List) ) ) ).

tff(fact_49_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys2: list(A)] : ( Xsa = cons(A,Y2,Ys2) ) ) ).

tff(fact_50_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( cl_Groups_Ominus(B)
     => ! [B2: fun(A,B),A2: fun(A,B),X2: A] : ( aa(A,B,aa(fun(A,B),fun(A,B),aa(fun(A,B),fun(fun(A,B),fun(A,B)),minus_minus(fun(A,B)),A2),B2),X2) = aa(B,B,aa(B,fun(B,B),minus_minus(B),aa(A,B,A2,X2)),aa(A,B,B2,X2)) ) ) ).

tff(fact_51_minus__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( cl_Groups_Ominus(A)
     => ! [Xa: B,B2: fun(B,A),A2: fun(B,A)] : ( aa(B,A,aa(fun(B,A),fun(B,A),aa(fun(B,A),fun(fun(B,A),fun(B,A)),minus_minus(fun(B,A)),A2),B2),Xa) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(B,A,A2,Xa)),aa(B,A,B2,Xa)) ) ) ).

tff(fact_52_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_53_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( list_ex1(A,P1,cons(A,Xa,Xsa))
    <=> ( ( pp(aa(A,bool,P1,Xa))
         => list_all(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),aa(fun(A,bool),fun(A,bool),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot),P1)),aa(A,fun(A,bool),fequal(A),Xa)),Xsa) )
        & ( ~ pp(aa(A,bool,P1,Xa))
         => list_ex1(A,P1,Xsa) ) ) ) ).

tff(fact_54_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( list_all(A,P1,cons(A,Xa,Xsa))
    <=> ( pp(aa(A,bool,P1,Xa))
        & list_all(A,P1,Xsa) ) ) ).

tff(fact_55_list__all__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : list_all(A,P1,nil(A)) ).

tff(fact_56_list__all__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_all(A,P1,Xsa)
    <=> ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
         => pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_57_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = Xsa ) ) ).

tff(fact_58_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ) ).

tff(fact_59_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ).

tff(fact_60_list__all__cong,axiom,
    ! [A: $tType,G: fun(A,bool),F: fun(A,bool),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Ys1)))
           => ( pp(aa(A,bool,F,X1))
            <=> pp(aa(A,bool,G,X1)) ) )
       => ( list_all(A,F,Xsa)
        <=> list_all(A,G,Ys1) ) ) ) ).

tff(fact_61_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_62_norm,axiom,
    ! [X2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X2),set(atom,as)))
     => ( divisor(X2) != zero_zero(int) ) ) ).

tff(fact_63_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xsa: list(B),Xa: B,F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),cons(B,Xa,Xsa)),nil(C)) = cons(A,aa(C,A,aa(B,fun(C,A),F,Xa),zero_zero(C)),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),Xsa),nil(C))) ) ) ).

tff(fact_64_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_65_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),nil(A)),Ys) = zero_zero(A) ) ) ).

tff(fact_66_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),nil(A)) = zero_zero(A) ) ) ).

tff(fact_67_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys1: list(C),Y1: C,F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),cons(C,Y1,Ys1)) = cons(A,aa(C,A,aa(B,fun(C,A),F,zero_zero(B)),Y1),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),Ys1)) ) ) ).

tff(fact_68_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_69_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_70_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),A3) = zero_zero(A) ) ) ).

tff(fact_71_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X1: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Cs)))
             => ( X1 = zero_zero(A) ) )
         => ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Cs),Xsa) = zero_zero(A) ) ) ) ).

tff(fact_72_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_73_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( ( A1 = B1 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
    <=> pp(aa(A,bool,A2,Xa)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = zero_zero(A) )
        <=> ( A1 = B1 ) ) ) ).

tff(fact_78_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( A1 = B1 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = zero_zero(A) ) ) ) ).

tff(fact_79_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),zero_zero(A)) = A3 ) ) ).

tff(fact_80_sublist__singleton,axiom,
    ! [A: $tType,Xa: A,A2: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A2))
       => ( sublist(A,cons(A,Xa,nil(A)),A2) = cons(A,Xa,nil(A)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A2))
       => ( sublist(A,cons(A,Xa,nil(A)),A2) = nil(A) ) ) ) ).

tff(fact_81_insort__insert__key__triv,axiom,
    ! [A: $tType,B: $tType] :
      ( linorder(A)
     => ! [Xsa: list(B),Xa: B,F: fun(B,A)] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),aa(B,A,F,Xa)),image(B,A,F,set(B,Xsa))))
         => ( linord2118332866rt_key(B,A,F,Xa,Xsa) = Xsa ) ) ) ).

tff(fact_82_sublist__nil,axiom,
    ! [A: $tType,A2: fun(nat,bool)] : ( sublist(A,nil(A),A2) = nil(A) ) ).

tff(fact_83_in__set__sublistD,axiom,
    ! [A: $tType,I1: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,sublist(A,Xsa,I1))))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa))) ) ).

tff(fact_84_notin__set__sublistI,axiom,
    ! [A: $tType,I1: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,sublist(A,Xsa,I1)))) ) ).

tff(fact_85_insort__insert__triv,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xsa: list(A),Xa: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
         => ( linord2118332866rt_key(A,A,combi(A),Xa,Xsa) = Xsa ) ) ) ).

tff(fact_86_diff__self__eq__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),M) = zero_zero(nat) ) ).

tff(fact_87_diff__0__eq__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_88_diff__commute,axiom,
    ! [K: nat,J: nat,I: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),J)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),K)),J) ) ).

tff(fact_89_minus__nat_Odiff__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_90_diffs0__imp__equal,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N) = zero_zero(nat) )
     => ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),N),M) = zero_zero(nat) )
       => ( M = N ) ) ) ).

tff(fact_91_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_92_insort__insert__insort__key,axiom,
    ! [A: $tType,B: $tType] :
      ( linorder(A)
     => ! [Xsa: list(B),Xa: B,F: fun(B,A)] :
          ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),aa(B,A,F,Xa)),image(B,A,F,set(B,Xsa))))
         => ( linord2118332866rt_key(B,A,F,Xa,Xsa) = linorder_insort_key(B,A,F,Xa,Xsa) ) ) ) ).

tff(fact_93_insort__key_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType] :
      ( linorder(B)
     => ! [Xa: A,F: fun(A,B)] : ( linorder_insort_key(A,B,F,Xa,nil(A)) = cons(A,Xa,nil(A)) ) ) ).

tff(fact_94_insort__not__Nil,axiom,
    ! [B: $tType,A: $tType] :
      ( linorder(B)
     => ! [Xsa: list(A),A1: A,F: fun(A,B)] : ( linorder_insort_key(A,B,F,A1,Xsa) != nil(A) ) ) ).

tff(fact_95_insort__key__left__comm,axiom,
    ! [A: $tType,B: $tType] :
      ( linorder(A)
     => ! [Xsa: list(B),Y1: B,Xa: B,F: fun(B,A)] :
          ( ( aa(B,A,F,Xa) != aa(B,A,F,Y1) )
         => ( linorder_insort_key(B,A,F,Y1,linorder_insort_key(B,A,F,Xa,Xsa)) = linorder_insort_key(B,A,F,Xa,linorder_insort_key(B,A,F,Y1,Xsa)) ) ) ) ).

tff(fact_96_insort__left__comm,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xsa: list(A),Y1: A,Xa: A] : ( linorder_insort_key(A,A,combi(A),Xa,linorder_insort_key(A,A,combi(A),Y1,Xsa)) = linorder_insort_key(A,A,combi(A),Y1,linorder_insort_key(A,A,combi(A),Xa,Xsa)) ) ) ).

tff(fact_97_insort__insert__insort,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xsa: list(A),Xa: A] :
          ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
         => ( linord2118332866rt_key(A,A,combi(A),Xa,Xsa) = linorder_insort_key(A,A,combi(A),Xa,Xsa) ) ) ) ).

tff(fact_98_sort__key__simps_I2_J,axiom,
    ! [B: $tType,A: $tType] :
      ( linorder(B)
     => ! [Xsa: list(A),Xa: A,F: fun(A,B)] : ( linorder_sort_key(A,B,F,cons(A,Xa,Xsa)) = linorder_insort_key(A,B,F,Xa,linorder_sort_key(A,B,F,Xsa)) ) ) ).

%----Arities (15)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite1(T_2)
        & finite_finite1(T_1) )
     => finite_finite1(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Groups_Ominus,axiom,
    cl_Groups_Ominus(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite1(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

tff(arity_prod___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite1(T_2)
        & finite_finite1(T_1) )
     => finite_finite1(product_prod(T_1,T_2)) ) ).

%----Helper facts (16)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    finite_finite(int,image(product_prod(int,list(int)),int,aa(fun(int,fun(list(int),int)),fun(product_prod(int,list(int)),int),product_prod_case(int,list(int),int),combc(int,fun(list(int),int),fun(list(int),int),aa(fun(int,fun(int,int)),fun(int,fun(fun(list(int),int),fun(list(int),int))),aa(fun(fun(int,int),fun(fun(list(int),int),fun(list(int),int))),fun(fun(int,fun(int,int)),fun(int,fun(fun(list(int),int),fun(list(int),int)))),combb(fun(int,int),fun(fun(list(int),int),fun(list(int),int)),int),combb(int,int,list(int))),minus_minus(int)),combc(list(int),list(int),int,iprod(int),xs))),set(product_prod(int,list(int)),lbounds(as)))) ).

%------------------------------------------------------------------------------
