%------------------------------------------------------------------------------
% File     : COM086_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 203
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_203 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  156 (  63 unt;  47 typ;   0 def)
%            Number of atoms       :  209 ( 139 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  156 (  56   ~;  10   |;  18   &)
%                                         (  28 <=>;  44  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   46 (  30   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-5 aty)
%            Number of functors    :   41 (  41 usr;   8 con; 0-5 aty)
%            Number of variables   :  370 ( 326   !;   8   ?; 370   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:15
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Logic_OATOM_Onnf,type,
    nnf: 
      !>[A: $tType] : ( ( fun(A,fm(A)) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Oand,type,
    c_Logic_Oand: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Odnf,type,
    dnf: 
      !>[A: $tType] : ( fm(A) > list(list(A)) ) ).

tff(sy_c_Logic_Ofm_OAnd,type,
    c_Logic_Ofm_OAnd: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OAtom,type,
    atom1: 
      !>[A: $tType] : ( A > fm(A) ) ).

tff(sy_c_Logic_Ofm_OFalseF,type,
    falseF: 
      !>[A: $tType] : fm(A) ).

tff(sy_c_Logic_Ofm_ONeg,type,
    neg: 
      !>[A: $tType] : ( fm(A) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OOr,type,
    c_Logic_Ofm_OOr: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OTrueF,type,
    trueF: 
      !>[A: $tType] : fm(A) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Oneg,type,
    neg1: 
      !>[A: $tType] : ( fm(A) > fm(A) ) ).

tff(sy_c_Logic_Oor,type,
    c_Logic_Oor: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_PresArith_Oneg_092_060_094isub_062Z,type,
    neg_Z: fun(atom,fm(atom)) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_1_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( divisor(X3) != zero_zero(int) ) ) ).

tff(fact_2_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,X3),cons(int,x,xs))) ) ).

tff(fact_3__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X: int] :
    ! [Xa2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa2),cons(int,X,xs))) ) ).

tff(fact_4__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X: int] :
        ~ ! [Xa2: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
           => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa2),cons(int,X,xs))) ) ).

tff(fact_5_Z_OI_092_060_094isub_062a__aneg,axiom,
    ! [Xsa: list(int),A2: atom] :
      ( interpret(atom,int,i_Z,aa(atom,fm(atom),neg_Z,A2),Xsa)
    <=> ~ pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,A2),Xsa)) ) ).

tff(fact_6_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X1: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X1),set(fm(atom),Fs)))
         => interpret(atom,int,i_Z,X1,Xsa) ) ) ).

tff(fact_7_Z_OI__and,axiom,
    ! [Xsa: list(int),Phi_2: fm(atom),Phi_1: fm(atom)] :
      ( interpret(atom,int,i_Z,c_Logic_Oand(atom,Phi_1,Phi_2),Xsa)
    <=> interpret(atom,int,i_Z,c_Logic_Ofm_OAnd(atom,Phi_1,Phi_2),Xsa) ) ).

tff(fact_8_Z_OI__or,axiom,
    ! [Xsa: list(int),Phi_2: fm(atom),Phi_1: fm(atom)] :
      ( interpret(atom,int,i_Z,c_Logic_Oor(atom,Phi_1,Phi_2),Xsa)
    <=> interpret(atom,int,i_Z,c_Logic_Ofm_OOr(atom,Phi_1,Phi_2),Xsa) ) ).

tff(fact_9_Z_OI__neg,axiom,
    ! [Xsa: list(int),Phi: fm(atom)] :
      ( interpret(atom,int,i_Z,neg1(atom,Phi),Xsa)
    <=> interpret(atom,int,i_Z,neg(atom,Phi),Xsa) ) ).

tff(fact_10_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X1: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X1),set(fm(atom),Fs)))
          & interpret(atom,int,i_Z,X1,Xsa) ) ) ).

tff(fact_11_interpret_Osimps_I3_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),A2: A,H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,atom1(A,A2),Xsa)
    <=> pp(aa(list(B),bool,aa(A,fun(list(B),bool),H,A2),Xsa)) ) ).

tff(fact_12_interpret_Osimps_I1_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),H: fun(A,fun(list(B),bool))] : interpret(A,B,H,trueF(A),Xsa) ).

tff(fact_13_interpret_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),H: fun(A,fun(list(B),bool))] : ~ interpret(A,B,H,falseF(A),Xsa) ).

tff(fact_14_interpret_Osimps_I4_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi_2: fm(A),Phi_1: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,c_Logic_Ofm_OAnd(A,Phi_1,Phi_2),Xsa)
    <=> ( interpret(A,B,H,Phi_1,Xsa)
        & interpret(A,B,H,Phi_2,Xsa) ) ) ).

tff(fact_15_interpret_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi_2: fm(A),Phi_1: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,c_Logic_Ofm_OOr(A,Phi_1,Phi_2),Xsa)
    <=> ( interpret(A,B,H,Phi_1,Xsa)
        | interpret(A,B,H,Phi_2,Xsa) ) ) ).

tff(fact_16_fm_Osimps_I4_J,axiom,
    ! [A: $tType,Fm4: fm(A),Fm3: fm(A)] :
      ( ( neg(A,Fm3) = neg(A,Fm4) )
    <=> ( Fm3 = Fm4 ) ) ).

tff(fact_17_fm_Osimps_I1_J,axiom,
    ! [A: $tType,A4: A,A2: A] :
      ( ( atom1(A,A2) = atom1(A,A4) )
    <=> ( A2 = A4 ) ) ).

tff(fact_18_fm_Osimps_I3_J,axiom,
    ! [A: $tType,Fm23: fm(A),Fm13: fm(A),Fm22: fm(A),Fm12: fm(A)] :
      ( ( c_Logic_Ofm_OOr(A,Fm12,Fm22) = c_Logic_Ofm_OOr(A,Fm13,Fm23) )
    <=> ( ( Fm12 = Fm13 )
        & ( Fm22 = Fm23 ) ) ) ).

tff(fact_19_fm_Osimps_I2_J,axiom,
    ! [A: $tType,Fm23: fm(A),Fm13: fm(A),Fm22: fm(A),Fm12: fm(A)] :
      ( ( c_Logic_Ofm_OAnd(A,Fm12,Fm22) = c_Logic_Ofm_OAnd(A,Fm13,Fm23) )
    <=> ( ( Fm12 = Fm13 )
        & ( Fm22 = Fm23 ) ) ) ).

tff(fact_20_interpret_Osimps_I6_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,neg(A,Phi),Xsa)
    <=> ~ interpret(A,B,H,Phi,Xsa) ) ).

tff(fact_21_fm_Osimps_I6_J,axiom,
    ! [A: $tType] : ( trueF(A) != falseF(A) ) ).

tff(fact_22_fm_Osimps_I7_J,axiom,
    ! [A: $tType] : ( falseF(A) != trueF(A) ) ).

tff(fact_23_fm_Osimps_I14_J,axiom,
    ! [A: $tType,Fm: fm(A)] : ( trueF(A) != neg(A,Fm) ) ).

tff(fact_24_fm_Osimps_I8_J,axiom,
    ! [A: $tType,A3: A] : ( trueF(A) != atom1(A,A3) ) ).

tff(fact_25_fm_Osimps_I24_J,axiom,
    ! [A: $tType,Fm: fm(A)] : ( falseF(A) != neg(A,Fm) ) ).

tff(fact_26_fm_Osimps_I18_J,axiom,
    ! [A: $tType,A3: A] : ( falseF(A) != atom1(A,A3) ) ).

tff(fact_27_fm_Osimps_I12_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( trueF(A) != c_Logic_Ofm_OOr(A,Fm11,Fm21) ) ).

tff(fact_28_fm_Osimps_I10_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( trueF(A) != c_Logic_Ofm_OAnd(A,Fm11,Fm21) ) ).

tff(fact_29_fm_Osimps_I22_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( falseF(A) != c_Logic_Ofm_OOr(A,Fm11,Fm21) ) ).

tff(fact_30_fm_Osimps_I20_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( falseF(A) != c_Logic_Ofm_OAnd(A,Fm11,Fm21) ) ).

tff(fact_31_fm_Osimps_I15_J,axiom,
    ! [A: $tType,Fm: fm(A)] : ( neg(A,Fm) != trueF(A) ) ).

tff(fact_32_fm_Osimps_I25_J,axiom,
    ! [A: $tType,Fm: fm(A)] : ( neg(A,Fm) != falseF(A) ) ).

tff(fact_33_fm_Osimps_I9_J,axiom,
    ! [A: $tType,A3: A] : ( atom1(A,A3) != trueF(A) ) ).

tff(fact_34_fm_Osimps_I19_J,axiom,
    ! [A: $tType,A3: A] : ( atom1(A,A3) != falseF(A) ) ).

tff(fact_35_fm_Osimps_I33_J,axiom,
    ! [A: $tType,A5: A,Fm: fm(A)] : ( neg(A,Fm) != atom1(A,A5) ) ).

tff(fact_36_fm_Osimps_I32_J,axiom,
    ! [A: $tType,Fm: fm(A),A5: A] : ( atom1(A,A5) != neg(A,Fm) ) ).

tff(fact_37_fm_Osimps_I43_J,axiom,
    ! [A: $tType,Fm2: fm(A),Fm1: fm(A),Fm: fm(A)] : ( neg(A,Fm) != c_Logic_Ofm_OOr(A,Fm1,Fm2) ) ).

tff(fact_38_fm_Osimps_I39_J,axiom,
    ! [A: $tType,Fm2: fm(A),Fm1: fm(A),Fm: fm(A)] : ( neg(A,Fm) != c_Logic_Ofm_OAnd(A,Fm1,Fm2) ) ).

tff(fact_39_fm_Osimps_I30_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),A5: A] : ( atom1(A,A5) != c_Logic_Ofm_OOr(A,Fm11,Fm21) ) ).

tff(fact_40_fm_Osimps_I28_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),A5: A] : ( atom1(A,A5) != c_Logic_Ofm_OAnd(A,Fm11,Fm21) ) ).

tff(fact_41_fm_Osimps_I13_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm11,Fm21) != trueF(A) ) ).

tff(fact_42_fm_Osimps_I23_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm11,Fm21) != falseF(A) ) ).

tff(fact_43_fm_Osimps_I11_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm11,Fm21) != trueF(A) ) ).

tff(fact_44_fm_Osimps_I21_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm11,Fm21) != falseF(A) ) ).

tff(fact_45_fm_Osimps_I42_J,axiom,
    ! [A: $tType,Fm: fm(A),Fm2: fm(A),Fm1: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm1,Fm2) != neg(A,Fm) ) ).

tff(fact_46_fm_Osimps_I31_J,axiom,
    ! [A: $tType,A5: A,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm11,Fm21) != atom1(A,A5) ) ).

tff(fact_47_fm_Osimps_I38_J,axiom,
    ! [A: $tType,Fm: fm(A),Fm2: fm(A),Fm1: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm1,Fm2) != neg(A,Fm) ) ).

tff(fact_48_fm_Osimps_I29_J,axiom,
    ! [A: $tType,A5: A,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm11,Fm21) != atom1(A,A5) ) ).

tff(fact_49_fm_Osimps_I37_J,axiom,
    ! [A: $tType,Fm2: fm(A),Fm1: fm(A),Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm11,Fm21) != c_Logic_Ofm_OAnd(A,Fm1,Fm2) ) ).

tff(fact_50_fm_Osimps_I36_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),Fm2: fm(A),Fm1: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm1,Fm2) != c_Logic_Ofm_OOr(A,Fm11,Fm21) ) ).

tff(fact_51_Logic_Oneg__def,axiom,
    ! [A: $tType,Phi1: fm(A)] :
      ( ( ( Phi1 = trueF(A) )
       => ( neg1(A,Phi1) = falseF(A) ) )
      & ( ( Phi1 != trueF(A) )
       => ( ( ( Phi1 = falseF(A) )
           => ( neg1(A,Phi1) = trueF(A) ) )
          & ( ( Phi1 != falseF(A) )
           => ( neg1(A,Phi1) = neg(A,Phi1) ) ) ) ) ) ).

tff(fact_52_Logic_Oor__def,axiom,
    ! [A: $tType,Phi_21: fm(A),Phi_11: fm(A)] :
      ( ( ( Phi_11 = falseF(A) )
       => ( c_Logic_Oor(A,Phi_11,Phi_21) = Phi_21 ) )
      & ( ( Phi_11 != falseF(A) )
       => ( ( ( Phi_21 = falseF(A) )
           => ( c_Logic_Oor(A,Phi_11,Phi_21) = Phi_11 ) )
          & ( ( Phi_21 != falseF(A) )
           => ( ( ( ( Phi_11 = trueF(A) )
                  | ( Phi_21 = trueF(A) ) )
               => ( c_Logic_Oor(A,Phi_11,Phi_21) = trueF(A) ) )
              & ( ~ ( ( Phi_11 = trueF(A) )
                    | ( Phi_21 = trueF(A) ) )
               => ( c_Logic_Oor(A,Phi_11,Phi_21) = c_Logic_Ofm_OOr(A,Phi_11,Phi_21) ) ) ) ) ) ) ) ).

tff(fact_53_Logic_Oand__def,axiom,
    ! [A: $tType,Phi_21: fm(A),Phi_11: fm(A)] :
      ( ( ( Phi_11 = trueF(A) )
       => ( c_Logic_Oand(A,Phi_11,Phi_21) = Phi_21 ) )
      & ( ( Phi_11 != trueF(A) )
       => ( ( ( Phi_21 = trueF(A) )
           => ( c_Logic_Oand(A,Phi_11,Phi_21) = Phi_11 ) )
          & ( ( Phi_21 != trueF(A) )
           => ( ( ( ( Phi_11 = falseF(A) )
                  | ( Phi_21 = falseF(A) ) )
               => ( c_Logic_Oand(A,Phi_11,Phi_21) = falseF(A) ) )
              & ( ~ ( ( Phi_11 = falseF(A) )
                    | ( Phi_21 = falseF(A) ) )
               => ( c_Logic_Oand(A,Phi_11,Phi_21) = c_Logic_Ofm_OAnd(A,Phi_11,Phi_21) ) ) ) ) ) ) ) ).

tff(fact_54_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A4: A,List1: list(A),A2: A] :
      ( ( cons(A,A2,List1) = cons(A,A4,List2) )
    <=> ( ( A2 = A4 )
        & ( List1 = List2 ) ) ) ).

tff(fact_55_dnf_Osimps_I3_J,axiom,
    ! [A: $tType,Phi1: A] : ( dnf(A,atom1(A,Phi1)) = cons(list(A),cons(A,Phi1,nil(A)),nil(list(A))) ) ).

tff(fact_56_list_Osimps_I2_J,axiom,
    ! [A: $tType,List: list(A),A3: A] : ( nil(A) != cons(A,A3,List) ) ).

tff(fact_57_list_Osimps_I3_J,axiom,
    ! [A: $tType,List: list(A),A3: A] : ( cons(A,A3,List) != nil(A) ) ).

tff(fact_58_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),set(A,cons(A,Xa,Xsa))))
     => ( ( Y = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),set(A,Xsa))) ) ) ).

tff(fact_59_Z_Onnf_Osimps_I7_J,axiom,
    ! [Phi_2: fm(atom),Phi_1: fm(atom)] : ( nnf(atom,neg_Z,neg(atom,c_Logic_Ofm_OOr(atom,Phi_1,Phi_2))) = c_Logic_Ofm_OAnd(atom,nnf(atom,neg_Z,neg(atom,Phi_1)),nnf(atom,neg_Z,neg(atom,Phi_2))) ) ).

tff(fact_60_Z_Onnf_Osimps_I6_J,axiom,
    ! [Phi_2: fm(atom),Phi_1: fm(atom)] : ( nnf(atom,neg_Z,neg(atom,c_Logic_Ofm_OAnd(atom,Phi_1,Phi_2))) = c_Logic_Ofm_OOr(atom,nnf(atom,neg_Z,neg(atom,Phi_1)),nnf(atom,neg_Z,neg(atom,Phi_2))) ) ).

tff(fact_61_Z_Onnf_Osimps_I11_J,axiom,
    ! [V: atom] : ( nnf(atom,neg_Z,atom1(atom,V)) = atom1(atom,V) ) ).

tff(fact_62_Z_Onnf_Osimps_I10_J,axiom,
    nnf(atom,neg_Z,falseF(atom)) = falseF(atom) ).

tff(fact_63_Z_Onnf_Osimps_I9_J,axiom,
    nnf(atom,neg_Z,trueF(atom)) = trueF(atom) ).

tff(fact_64_Z_Onnf_Osimps_I5_J,axiom,
    ! [Phi: fm(atom)] : ( nnf(atom,neg_Z,neg(atom,neg(atom,Phi))) = nnf(atom,neg_Z,Phi) ) ).

tff(fact_65_Z_Onnf_Osimps_I8_J,axiom,
    ! [A2: atom] : ( nnf(atom,neg_Z,neg(atom,atom1(atom,A2))) = aa(atom,fm(atom),neg_Z,A2) ) ).

tff(fact_66_Z_Onnf_Osimps_I4_J,axiom,
    nnf(atom,neg_Z,neg(atom,falseF(atom))) = trueF(atom) ).

tff(fact_67_Z_Onnf_Osimps_I3_J,axiom,
    nnf(atom,neg_Z,neg(atom,trueF(atom))) = falseF(atom) ).

tff(fact_68_dnf_Osimps_I2_J,axiom,
    ! [A: $tType] : ( dnf(A,falseF(A)) = nil(list(A)) ) ).

tff(fact_69_Z_Onnf_Osimps_I1_J,axiom,
    ! [Phi_2: fm(atom),Phi_1: fm(atom)] : ( nnf(atom,neg_Z,c_Logic_Ofm_OAnd(atom,Phi_1,Phi_2)) = c_Logic_Ofm_OAnd(atom,nnf(atom,neg_Z,Phi_1),nnf(atom,neg_Z,Phi_2)) ) ).

tff(fact_70_Z_Onnf_Osimps_I2_J,axiom,
    ! [Phi_2: fm(atom),Phi_1: fm(atom)] : ( nnf(atom,neg_Z,c_Logic_Ofm_OOr(atom,Phi_1,Phi_2)) = c_Logic_Ofm_OOr(atom,nnf(atom,neg_Z,Phi_1),nnf(atom,neg_Z,Phi_2)) ) ).

tff(fact_71_dnf_Osimps_I1_J,axiom,
    ! [A: $tType] : ( dnf(A,trueF(A)) = cons(list(A),nil(A),nil(list(A))) ) ).

tff(fact_72_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_73_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] : ( cons(A,X2,Xs1) != Xs1 ) ).

tff(fact_78_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs1: list(A)] : ( Xs1 != cons(A,X2,Xs1) ) ).

tff(fact_79_Z_OI__nnf,axiom,
    ! [Xsa: list(int),Phi: fm(atom)] :
      ( interpret(atom,int,i_Z,nnf(atom,neg_Z,Phi),Xsa)
    <=> interpret(atom,int,i_Z,Phi,Xsa) ) ).

tff(fact_80_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( filter(A,P1,nil(A)) = nil(A) ) ).

tff(fact_81_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,fun(A,bool),bool,member(A),set(A,Xsa))),P1)) ) ).

tff(fact_82_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,cons(A,Xa,Xsa)) = cons(A,Xa,filter(A,P1,Xsa)) ) )
      & ( ~ pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,cons(A,Xa,Xsa)) = filter(A,P1,Xsa) ) ) ) ).

tff(fact_83_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => pp(aa(A,bool,P1,X1)) ) ) ).

tff(fact_84_filter__empty__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = nil(A) )
    <=> ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X1)) ) ) ).

tff(fact_85_filter__False,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X)) )
     => ( filter(A,P1,Xsa) = nil(A) ) ) ).

tff(fact_86_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_87_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Xa: B,F: fun(B,A)] : ( map(B,A,F,cons(B,Xa,Xsa)) = cons(A,aa(B,A,F,Xa),map(B,A,F,Xsa)) ) ).

tff(fact_88_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X1: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xsa)))
         => ( aa(B,A,F,X1) = aa(B,A,G,X1) ) ) ) ).

tff(fact_89_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_90_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_91_filter__True,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => pp(aa(A,bool,P1,X)) )
     => ( filter(A,P1,Xsa) = Xsa ) ) ).

tff(fact_92_filter__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Ys)))
           => ( pp(aa(A,bool,P1,X))
            <=> pp(aa(A,bool,Q1,X)) ) )
       => ( filter(A,P1,Xsa) = filter(A,Q1,Ys) ) ) ) ).

tff(fact_93_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Ys)))
           => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
       => ( map(A,B,F,Xsa) = map(A,B,G,Ys) ) ) ) ).

tff(fact_94_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,A,F,X) = X ) )
     => ( map(A,A,F,Xsa) = Xsa ) ) ).

tff(fact_95_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys: list(B)] :
      ( ? [Xs: list(A)] : ( Ys = map(A,B,F,Xs) )
    <=> ! [X1: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Ys)))
         => ? [Xa1: A] : ( X1 = aa(A,B,F,Xa1) ) ) ) ).

tff(fact_96_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
     => ( map(A,B,F,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_97_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y: A,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = cons(A,Y,Ys) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xsa = cons(B,Z,Zs) )
          & ( aa(B,A,F,Z) = Y )
          & ( map(B,A,F,Zs) = Ys ) ) ) ).

tff(fact_98_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xsa: list(A),Xa: A] :
      ( ( cons(A,Xa,Xsa) = map(B,A,F,Ys) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys = cons(B,Z,Zs) )
          & ( Xa = aa(B,A,F,Z) )
          & ( Xsa = map(B,A,F,Zs) ) ) ) ).

%----Arities (1)
tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

%----Helper facts (8)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

%------------------------------------------------------------------------------
