%------------------------------------------------------------------------------
% File     : COM085_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 201
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_201 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  168 (  35 unt;  41 typ;   0 def)
%            Number of atoms       :  310 (  96 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  229 (  46   ~;  14   |;  13   &)
%                                         (  26 <=>; 130  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   36 (  21   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   28 (  28 usr;   7 con; 0-5 aty)
%            Number of variables   :  392 ( 350   !;   9   ?; 392   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:07
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: fun(atom,int) ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( aa(atom,int,divisor,X3) != zero_zero(int) ) ) ).

tff(fact_1_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => i_Z(X3,cons(int,x,xs)) ) ).

tff(fact_2__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X: int] :
    ! [Xa2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
     => i_Z(Xa2,cons(int,X,xs)) ) ).

tff(fact_3__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X: int] :
        ~ ! [Xa2: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
           => i_Z(Xa2,cons(int,X,xs)) ) ).

tff(fact_4_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,fun(A,bool),bool,member(A),set(A,Xsa))),P1)) ) ).

tff(fact_5_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,cons(A,Xa,Xsa)) = cons(A,Xa,filter(A,P1,Xsa)) ) )
      & ( ~ pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,cons(A,Xa,Xsa)) = filter(A,P1,Xsa) ) ) ) ).

tff(fact_6_zmod__zero,axiom,
    ! [B1: int] : ( div_mod(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_7_zmod__self,axiom,
    ! [A1: int] : ( div_mod(int,A1,A1) = zero_zero(int) ) ).

tff(fact_8_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),set(B,Xsa)))
         => ( aa(B,A,F,X2) = aa(B,A,G,X2) ) ) ) ).

tff(fact_9_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Xa: B,F: fun(B,A)] : ( map(B,A,F,cons(B,Xa,Xsa)) = cons(A,aa(B,A,F,Xa),map(B,A,F,Xsa)) ) ).

tff(fact_10_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_11_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_12_pos__mod__sign,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,zero_zero(int),B1)
     => ord_less_eq(int,zero_zero(int),div_mod(int,A1,B1)) ) ).

tff(fact_13_pos__mod__conj,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,zero_zero(int),B1)
     => ( ord_less_eq(int,zero_zero(int),div_mod(int,A1,B1))
        & ord_less(int,div_mod(int,A1,B1),B1) ) ) ).

tff(fact_14_mod__pos__pos__trivial,axiom,
    ! [B1: int,A1: int] :
      ( ord_less_eq(int,zero_zero(int),A1)
     => ( ord_less(int,A1,B1)
       => ( div_mod(int,A1,B1) = A1 ) ) ) ).

tff(fact_15_neg__mod__sign,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,B1,zero_zero(int))
     => ord_less_eq(int,div_mod(int,A1,B1),zero_zero(int)) ) ).

tff(fact_16_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),A5: A] :
      ( ( cons(A,A5,List2) = cons(A,A6,List3) )
    <=> ( ( A5 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_17_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,div_mod(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_18_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_19_filter__filter,axiom,
    ! [A: $tType,Xsa: list(A),Q1: fun(A,bool),P1: fun(A,bool)] : ( filter(A,P1,filter(A,Q1,Xsa)) = filter(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,Q1),P1),Xsa) ) ).

tff(fact_20_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( cons(A,X1,Xs1) != Xs1 ) ).

tff(fact_21_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != cons(A,X1,Xs1) ) ).

tff(fact_22_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_23_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),set(A,cons(A,Xa,Xsa))))
     => ( ( Y = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),set(A,Xsa))) ) ) ).

tff(fact_24_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_25_Divides_Otransfer__nat__int__function__closures_I2_J,axiom,
    ! [Y1: int,X1: int] :
      ( ord_less_eq(int,zero_zero(int),X1)
     => ( ord_less_eq(int,zero_zero(int),Y1)
       => ord_less_eq(int,zero_zero(int),div_mod(int,X1,Y1)) ) ) ).

tff(fact_26_zmod__le__nonneg__dividend,axiom,
    ! [K: int,M: int] :
      ( ord_less_eq(int,zero_zero(int),M)
     => ord_less_eq(int,div_mod(int,M,K),M) ) ).

tff(fact_27_neg__mod__bound,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,B1,zero_zero(int))
     => ord_less(int,B1,div_mod(int,A1,B1)) ) ).

tff(fact_28_pos__mod__bound,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,zero_zero(int),B1)
     => ord_less(int,div_mod(int,A1,B1),B1) ) ).

tff(fact_29_mod__neg__neg__trivial,axiom,
    ! [B1: int,A1: int] :
      ( ord_less_eq(int,A1,zero_zero(int))
     => ( ord_less(int,B1,A1)
       => ( div_mod(int,A1,B1) = A1 ) ) ) ).

tff(fact_30_neg__mod__conj,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,B1,zero_zero(int))
     => ( ord_less_eq(int,div_mod(int,A1,B1),zero_zero(int))
        & ord_less(int,B1,div_mod(int,A1,B1)) ) ) ).

tff(fact_31_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_32_calculation,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_33_filter__True,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => pp(aa(A,bool,P1,X)) )
     => ( filter(A,P1,Xsa) = Xsa ) ) ).

tff(fact_34_filter__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Ys1)))
           => ( pp(aa(A,bool,P1,X))
            <=> pp(aa(A,bool,Q1,X)) ) )
       => ( filter(A,P1,Xsa) = filter(A,Q1,Ys1) ) ) ) ).

tff(fact_35_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Ys1)))
           => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
       => ( map(A,B,F,Xsa) = map(A,B,G,Ys1) ) ) ) ).

tff(fact_36_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,A,F,X) = X ) )
     => ( map(A,A,F,Xsa) = Xsa ) ) ).

tff(fact_37_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
     => ( map(A,B,F,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_38_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys1: list(B)] :
      ( ? [Xs: list(A)] : ( Ys1 = map(A,B,F,Xs) )
    <=> ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),set(B,Ys1)))
         => ? [Xa1: A] : ( X2 = aa(A,B,F,Xa1) ) ) ) ).

tff(fact_39_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_40_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_41_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_42_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( filter(A,P1,nil(A)) = nil(A) ) ).

tff(fact_43_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( nil(A) != cons(A,A4,List1) ) ).

tff(fact_44_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( cons(A,A4,List1) != nil(A) ) ).

tff(fact_45_filter__empty__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = nil(A) )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_46_zlcms__pos,axiom,
    ! [Is: list(int)] :
      ( ! [X: int] :
          ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),X),set(int,Is)))
         => ( X != zero_zero(int) ) )
     => ord_less(int,zero_zero(int),zlcms(Is)) ) ).

tff(fact_47_elem__le__zlcms,axiom,
    ! [I: int,Is: list(int)] :
      ( ! [X: int] :
          ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),X),set(int,Is)))
         => ( X != zero_zero(int) ) )
     => ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),I),set(int,Is)))
       => ord_less_eq(int,I,zlcms(Is)) ) ) ).

tff(fact_48_filter__False,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X)) )
     => ( filter(A,P1,Xsa) = nil(A) ) ) ).

tff(fact_49_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),F: fun(B,A),Xsa: list(A),Xa: A] :
      ( ( cons(A,Xa,Xsa) = map(B,A,F,Ys1) )
    <=> ? [Z1: B,Zs: list(B)] :
          ( ( Ys1 = cons(B,Z1,Zs) )
          & ( Xa = aa(B,A,F,Z1) )
          & ( Xsa = map(B,A,F,Zs) ) ) ) ).

tff(fact_50_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys1: list(A),Y: A,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = cons(A,Y,Ys1) )
    <=> ? [Z1: B,Zs: list(B)] :
          ( ( Xsa = cons(B,Z1,Zs) )
          & ( aa(B,A,F,Z1) = Y )
          & ( map(B,A,F,Zs) = Ys1 ) ) ) ).

tff(fact_51_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X1: A] : ord_less_eq(A,X1,X1) ) ).

tff(fact_52_list_Oexhaust,axiom,
    ! [A: $tType,Y1: list(A)] :
      ( ( Y1 != nil(A) )
     => ~ ! [A3: A,List: list(A)] : ( Y1 != cons(A,A3,List) ) ) ).

tff(fact_53_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys: list(A)] : ( Xsa = cons(A,Y2,Ys) ) ) ).

tff(fact_54_set__subset__Cons,axiom,
    ! [A: $tType,Xa: A,Xsa: list(A)] : ord_less_eq(fun(A,bool),set(A,Xsa),set(A,cons(A,Xa,Xsa))) ).

tff(fact_55_filter__is__subset,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ord_less_eq(fun(A,bool),set(A,filter(A,P1,Xsa)),set(A,Xsa)) ).

tff(fact_56_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_57_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X2: A] : ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_58_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
          | ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_59_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,Xa: A] :
          ( ( Xa = Y )
        <=> ( ord_less_eq(A,Xa,Y)
            & ord_less_eq(A,Y,Xa) ) ) ) ).

tff(fact_60_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 = Y1 )
         => ord_less_eq(A,X1,Y1) ) ) ).

tff(fact_61_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa),aa(A,B,G,Xa)) ) ) ).

tff(fact_62_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Xa: A,Y: A] :
          ( ord_less_eq(A,Y,Xa)
         => ( ord_less_eq(A,Xa,Y)
          <=> ( Xa = Y ) ) ) ) ).

tff(fact_63_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less_eq(A,B1,C1)
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_64_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( B1 = C1 )
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_65_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less_eq(A,Y1,X1)
           => ( X1 = Y1 ) ) ) ) ).

tff(fact_66_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less_eq(A,X1,Z) ) ) ) ).

tff(fact_67_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa),aa(A,B,G,Xa)) ) ) ).

tff(fact_68_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less_eq(A,X1,Y1)
         => ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_69_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X1: A] : ~ ord_less(A,X1,X1) ) ).

tff(fact_70_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa: A] :
          ( ( Xa != Y )
        <=> ( ord_less(A,Xa,Y)
            | ord_less(A,Y,Xa) ) ) ) ).

tff(fact_71_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa: A] :
          ( ~ ord_less(A,Xa,Y)
        <=> ( ord_less(A,Y,Xa)
            | ( Xa = Y ) ) ) ) ).

tff(fact_72_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
          | ( X1 = Y1 )
          | ord_less(A,Y1,X1) ) ) ).

tff(fact_73_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xa: A,Y: A] :
          ( ~ ord_less(A,Y,Xa)
         => ( ~ ord_less(A,Xa,Y)
          <=> ( Xa = Y ) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
    <=> pp(aa(A,bool,A2,Xa)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 != Y1 )
         => ( ~ ord_less(A,X1,Y1)
           => ord_less(A,Y1,X1) ) ) ) ).

tff(fact_78_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( X1 != Y1 ) ) ) ).

tff(fact_79_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ~ ord_less(A,Y1,X1) ) ) ).

tff(fact_80_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ~ ord_less(A,Y1,X1) ) ) ).

tff(fact_81_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( X1 != Y1 ) ) ) ).

tff(fact_82_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( Y1 != X1 ) ) ) ).

tff(fact_83_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y: A,Xa: A] :
          ( ord_less(A,Xa,Y)
         => ( ord_less(A,Y,Xa)
           => pp(P1) ) ) ) ).

tff(fact_84_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ~ ord_less(A,B1,A1) ) ) ).

tff(fact_85_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less(A,B1,C1)
           => ord_less(A,A1,C1) ) ) ) ).

tff(fact_86_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ( B1 = C1 )
           => ord_less(A,A1,C1) ) ) ) ).

tff(fact_87_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( ord_less(A,Y1,Z)
           => ord_less(A,X1,Z) ) ) ) ).

tff(fact_88_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ~ ord_less(A,Y1,X1) ) ) ).

tff(fact_89_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
         => ( ( X1 != Y1 )
           => ord_less(A,Y1,X1) ) ) ) ).

tff(fact_90_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa: A] :
          ( ~ ord_less(A,Xa,Y)
        <=> ord_less_eq(A,Y,Xa) ) ) ).

tff(fact_91_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa: A] :
          ( ~ ord_less_eq(A,Xa,Y)
        <=> ord_less(A,Y,Xa) ) ) ).

tff(fact_92_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
          | ord_less(A,Y1,X1) ) ) ).

tff(fact_93_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,Xa: A] :
          ( ord_less(A,Xa,Y)
        <=> ( ord_less_eq(A,Xa,Y)
            & ( Xa != Y ) ) ) ) ).

tff(fact_94_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,Xa: A] :
          ( ord_less(A,Xa,Y)
        <=> ( ord_less_eq(A,Xa,Y)
            & ~ ord_less_eq(A,Y,Xa) ) ) ) ).

tff(fact_95_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,Xa: A] :
          ( ord_less_eq(A,Xa,Y)
        <=> ( ord_less(A,Xa,Y)
            | ( Xa = Y ) ) ) ) ).

tff(fact_96_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
         => ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_97_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y1: A] :
          ( ~ ord_less_eq(A,Y1,X1)
         => ord_less(A,X1,Y1) ) ) ).

tff(fact_98_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa: A] :
          ( ~ ord_less(A,Xa,Y)
         => ( ord_less_eq(A,Xa,Y)
          <=> ( Xa = Y ) ) ) ) ).

%----Arities (13)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( ord_less_eq(int,zero_zero(int),div_mod(int,x,zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue)))),as)))))
    & ord_less(int,div_mod(int,x,zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue)))),as)))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue)))),as))))
    & ! [X: atom] :
        ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))))))))
       => i_Z(X,cons(int,div_mod(int,x,zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue)))),as)))),xs)) ) ) ).

%------------------------------------------------------------------------------
