%------------------------------------------------------------------------------
% File     : COM084_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 199
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_199 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  176 (  67 unt;  55 typ;   0 def)
%            Number of atoms       :  217 ( 137 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  134 (  38   ~;   7   |;  13   &)
%                                         (  22 <=>;  54  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   55 (  31   >;  24   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-2 aty)
%            Number of functors    :   45 (  45 usr;   9 con; 0-5 aty)
%            Number of variables   :  412 ( 364   !;  11   ?; 412   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:54
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (48)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( list(list(A)) > list(A) ) ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odecr_092_060_094isub_062Z,type,
    decr_Z: atom > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff1,type,
    hd_coeff1: int > fun(atom,atom) ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Ohd__coeffs1,type,
    qEpres1907640072oeffs1: list(atom) > list(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (98)
tff(fact_0__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X1: int] :
    ! [Xa2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
     => i_Z(Xa2,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X1),xs)) ) ).

tff(fact_1_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => i_Z(X3,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),x),xs)) ) ).

tff(fact_2_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( aa(atom,int,divisor,X3) != zero_zero(int) ) ) ).

tff(fact_3__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int] :
        ~ ! [Xa2: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa2),set(atom,as)))
           => i_Z(Xa2,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X1),xs)) ) ).

tff(fact_4_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),filter(A,P1,Xsa)) ) )
      & ( ~ pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa)) = filter(A,P1,Xsa) ) ) ) ).

tff(fact_5_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Xa: B,F: fun(B,A)] : ( map(B,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Xa),Xsa)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(B,A,F,Xa)),map(B,A,F,Xsa)) ) ).

tff(fact_6_I__cyclic,axiom,
    ! [E: list(int),J: int,I3: int,Aa: atom] :
      ( pp(aa(atom,bool,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),Aa))
     => ( ( aa(atom,int,hd_coeff,Aa) = one_one(int) )
       => ( ( div_mod(int,I3,aa(atom,int,divisor,Aa)) = div_mod(int,J,aa(atom,int,divisor,Aa)) )
         => ( i_Z(Aa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),I3),E))
          <=> i_Z(Aa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),J),E)) ) ) ) ) ).

tff(fact_7_filter__filter,axiom,
    ! [A: $tType,Xsa: list(A),Q1: fun(A,bool),P1: fun(A,bool)] : ( filter(A,P1,filter(A,Q1,Xsa)) = filter(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,Q1),P1),Xsa) ) ).

tff(fact_8_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_9_calculation,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_10_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,div_mod(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_11_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Aa),List) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List3) )
    <=> ( ( Aa = A5 )
        & ( List = List3 ) ) ) ).

tff(fact_12_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),F: fun(B,A),Xsa: list(A),Xa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa) = map(B,A,F,Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys1 = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( Xa = aa(B,A,F,Z) )
          & ( Xsa = map(B,A,F,Zs) ) ) ) ).

tff(fact_13_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys1: list(A),Y2: A,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xsa = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( aa(B,A,F,Z) = Y2 )
          & ( map(B,A,F,Zs) = Ys1 ) ) ) ).

tff(fact_14_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_15_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_16_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),set(B,Xsa)))
         => ( aa(B,A,F,X2) = aa(B,A,G,X2) ) ) ) ).

tff(fact_17_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_18_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_19_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_20_zmod__self,axiom,
    ! [A1: int] : ( div_mod(int,A1,A1) = zero_zero(int) ) ).

tff(fact_21_zmod__zero,axiom,
    ! [B1: int] : ( div_mod(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_22_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,fun(A,bool),bool,member(A),set(A,Xsa))),P1)) ) ).

tff(fact_23_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( filter(A,P1,nil(A)) = nil(A) ) ).

tff(fact_24_mod__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,one_one(A)) = zero_zero(A) ) ) ).

tff(fact_25_filter__empty__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = nil(A) )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_26_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) != nil(A) ) ).

tff(fact_27_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) ) ).

tff(fact_28_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_29_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa))))
     => ( ( Y2 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa))) ) ) ).

tff(fact_30_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_31_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) != Xs1 ) ).

tff(fact_32_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) ) ).

tff(fact_33_filter__False,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X1)) )
     => ( filter(A,P1,Xsa) = nil(A) ) ) ).

tff(fact_34_I__hd__coeffs1,axiom,
    ! [Xsa: list(int),Asa: list(atom)] :
      ( ! [X1: atom] :
          ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X1),set(atom,Asa)))
         => ( aa(atom,int,hd_coeff,X1) != zero_zero(int) ) )
     => ( ? [X2: int] :
          ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,qEpres1907640072oeffs1(Asa))))
           => i_Z(Xa1,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X2),Xsa)) )
      <=> ? [X2: int] :
          ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,Asa)))
           => i_Z(Xa1,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X2),Xsa)) ) ) ) ).

tff(fact_35_filter__True,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => pp(aa(A,bool,P1,X1)) )
     => ( filter(A,P1,Xsa) = Xsa ) ) ).

tff(fact_36_filter__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Ys1)))
           => ( pp(aa(A,bool,P1,X1))
            <=> pp(aa(A,bool,Q1,X1)) ) )
       => ( filter(A,P1,Xsa) = filter(A,Q1,Ys1) ) ) ) ).

tff(fact_37_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Ys1)))
           => ( aa(A,B,F,X1) = aa(A,B,G,X1) ) )
       => ( map(A,B,F,Xsa) = map(A,B,G,Ys1) ) ) ) ).

tff(fact_38_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ( aa(A,A,F,X1) = X1 ) )
     => ( map(A,A,F,Xsa) = Xsa ) ) ).

tff(fact_39_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ( aa(A,B,F,X1) = aa(A,B,G,X1) ) )
     => ( map(A,B,F,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_40_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys1: list(B)] :
      ( ? [Xs: list(A)] : ( Ys1 = map(A,B,F,Xs) )
    <=> ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),set(B,Ys1)))
         => ? [Xa1: A] : ( X2 = aa(A,B,F,Xa1) ) ) ) ).

tff(fact_41_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_42_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_43_zlcms_Osimps_I1_J,axiom,
    zlcms(nil(int)) = one_one(int) ).

tff(fact_44_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_45_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys: list(A)] : ( Xsa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys) ) ) ).

tff(fact_46_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List4: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List4) ) ) ).

tff(fact_47_hd__coeffs1__def,axiom,
    ! [Asa: list(atom)] : ( qEpres1907640072oeffs1(Asa) = aa(list(atom),list(atom),aa(atom,fun(list(atom),list(atom)),cons(atom),dvd(zlcms(map(atom,int,hd_coeff,Asa)),zero_zero(int),aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),one_one(int)),nil(int)))),map(atom,atom,hd_coeff1(zlcms(map(atom,int,hd_coeff,Asa))),Asa)) ) ).

tff(fact_48_atom_Osimps_I2_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List: list(int),Int2: int,Int1: int] :
      ( ( dvd(Int1,Int2,List) = dvd(Int13,Int23,List3) )
    <=> ( ( Int1 = Int13 )
        & ( Int2 = Int23 )
        & ( List = List3 ) ) ) ).

tff(fact_49_hd__coeff1_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_50_divisor_Osimps_I2_J,axiom,
    ! [Ks: list(int),I1: int,D: int] : ( aa(atom,int,divisor,dvd(D,I1,Ks)) = D ) ).

tff(fact_51_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),dvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int1),Int2),List) ) ).

tff(fact_52_hd__coeff_Osimps_I2_J,axiom,
    ! [Ks2: list(int),I3: int,D1: int] : ( aa(atom,int,hd_coeff,dvd(D1,I3,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_53_atom_Osize_I2_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( atom_size(dvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_54_asubst_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Ks1: list(int),I2: int] : ( asubst(I2,Ks1,dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_55_atom_Osize_I5_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( size_size(atom,dvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_56_divisor__asubst,axiom,
    ! [A1: atom,Ks: list(int),I1: int] : ( aa(atom,int,divisor,asubst(I1,Ks,A1)) = aa(atom,int,divisor,A1) ) ).

tff(fact_57_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Aa),List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_58_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_59_hd__coeff_Osimps_I3_J,axiom,
    ! [Ks2: list(int),I3: int,D1: int] : ( aa(atom,int,hd_coeff,nDvd(D1,I3,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_60_hd__coeff_Osimps_I1_J,axiom,
    ! [Ks2: list(int),I3: int] : ( aa(atom,int,hd_coeff,c_PresArith_Oatom_OLe(I3,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_61_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_62_atom_Osimps_I3_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List: list(int),Int2: int,Int1: int] :
      ( ( nDvd(Int1,Int2,List) = nDvd(Int13,Int23,List3) )
    <=> ( ( Int1 = Int13 )
        & ( Int2 = Int23 )
        & ( List = List3 ) ) ) ).

tff(fact_63_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int4: int,List: list(int),Int: int] :
      ( ( c_PresArith_Oatom_OLe(Int,List) = c_PresArith_Oatom_OLe(Int4,List3) )
    <=> ( ( Int = Int4 )
        & ( List = List3 ) ) ) ).

tff(fact_64_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I1: int] : ( aa(atom,int,divisor,c_PresArith_Oatom_OLe(I1,Ks)) = one_one(int) ) ).

tff(fact_65_hd__coeff1_Osimps_I4_J,axiom,
    ! [V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_66_hd__coeff1_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

tff(fact_67_asubst_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Ks1: list(int),I2: int] : ( asubst(I2,Ks1,nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

tff(fact_68_asubst_Osimps_I4_J,axiom,
    ! [V: int,Ks1: list(int),I2: int] : ( asubst(I2,Ks1,c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_69_atom_Osize_I3_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( atom_size(nDvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_70_atom_Osize_I6_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( size_size(atom,nDvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_71_atom_Osize_I1_J,axiom,
    ! [List2: list(int),Int3: int] : ( atom_size(c_PresArith_Oatom_OLe(Int3,List2)) = zero_zero(nat) ) ).

tff(fact_72_atom_Osize_I4_J,axiom,
    ! [List2: list(int),Int3: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int3,List2)) = zero_zero(nat) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
    <=> pp(aa(A,bool,A2,Xa)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_divisor_Osimps_I3_J,axiom,
    ! [Ks: list(int),I1: int,D: int] : ( aa(atom,int,divisor,nDvd(D,I1,Ks)) = D ) ).

tff(fact_77_atom_Osimps_I7_J,axiom,
    ! [List2: list(int),Int3: int,List1: list(int),Int21: int,Int11: int] : ( nDvd(Int11,Int21,List1) != c_PresArith_Oatom_OLe(Int3,List2) ) ).

tff(fact_78_atom_Osimps_I6_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List2: list(int),Int3: int] : ( c_PresArith_Oatom_OLe(Int3,List2) != nDvd(Int11,Int21,List1) ) ).

tff(fact_79_atom_Osimps_I4_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List2: list(int),Int3: int] : ( c_PresArith_Oatom_OLe(Int3,List2) != dvd(Int11,Int21,List1) ) ).

tff(fact_80_atom_Osimps_I5_J,axiom,
    ! [List2: list(int),Int3: int,List1: list(int),Int21: int,Int11: int] : ( dvd(Int11,Int21,List1) != c_PresArith_Oatom_OLe(Int3,List2) ) ).

tff(fact_81_atom_Osimps_I8_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List2: list(int),Int22: int,Int12: int] : ( dvd(Int12,Int22,List2) != nDvd(Int11,Int21,List1) ) ).

tff(fact_82_atom_Osimps_I9_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int,List1: list(int),Int21: int,Int11: int] : ( nDvd(Int11,Int21,List1) != dvd(Int12,Int22,List2) ) ).

tff(fact_83_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_84_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_85_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_86_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) ).

tff(fact_87_sublist__singleton,axiom,
    ! [A: $tType,Xa: A,A2: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A2))
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),nil(A)),A2) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),nil(A)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A2))
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),nil(A)),A2) = nil(A) ) ) ) ).

tff(fact_88_Z_Onot__dep__decr,axiom,
    ! [Xsa: list(int),Xa: int,Aa: atom] :
      ( ( aa(atom,int,hd_coeff,Aa) = zero_zero(int) )
     => ( i_Z(Aa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),Xa),Xsa))
      <=> i_Z(decr_Z(Aa),Xsa) ) ) ).

tff(fact_89_sublist__nil,axiom,
    ! [A: $tType,A2: fun(nat,bool)] : ( sublist(A,nil(A),A2) = nil(A) ) ).

tff(fact_90_notin__set__sublistI,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,sublist(A,Xsa,I)))) ) ).

tff(fact_91_in__set__sublistD,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,sublist(A,Xsa,I))))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa))) ) ).

tff(fact_92_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = Xsa ) ) ).

tff(fact_93_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa) ) ) ) ).

tff(fact_94_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa) ) ) ).

tff(fact_95_Z_Oanormal__decr,axiom,
    ! [A1: atom] :
      ( ( aa(atom,int,hd_coeff,A1) = zero_zero(int) )
     => ( ( aa(atom,int,divisor,A1) != zero_zero(int) )
       => ( aa(atom,int,divisor,decr_Z(A1)) != zero_zero(int) ) ) ) ).

tff(fact_96_concat__map__singleton,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] : ( concat(A,map(B,list(A),combc(B,list(A),list(A),combb(A,fun(list(A),list(A)),B,cons(A),F),nil(A)),Xsa)) = map(B,A,F,Xsa) ) ).

tff(fact_97_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

%----Arities (8)
tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Divides_Osemiring__div,axiom,
    semiring_div(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( i_Z(a,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),div_mod(int,x,zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as))))),xs))
    <=> ~ i_Z(a,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),x),xs)) ) ).

%------------------------------------------------------------------------------
