%------------------------------------------------------------------------------
% File     : COM083_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 196
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_196 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  165 (  33 unt;  39 typ;   0 def)
%            Number of atoms       :  324 (  87 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  247 (  49   ~;  16   |;  11   &)
%                                         (  29 <=>; 142  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   6 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   34 (  20   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-3 aty)
%            Number of functors    :   27 (  27 usr;   7 con; 0-5 aty)
%            Number of variables   :  399 ( 364   !;   4   ?; 399   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: fun(atom,int) ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),set(atom,as)))
     => ( aa(atom,int,divisor,X) != zero_zero(int) ) ) ).

tff(fact_1_x,axiom,
    ! [X: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),set(atom,as)))
     => i_Z(X,cons(int,x,xs)) ) ).

tff(fact_2__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X1: int] :
    ! [Xa3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa3),set(atom,as)))
     => i_Z(Xa3,cons(int,X1,xs)) ) ).

tff(fact_3__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int] :
        ~ ! [Xa3: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa3),set(atom,as)))
           => i_Z(Xa3,cons(int,X1,xs)) ) ).

tff(fact_4_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,fun(A,bool),bool,member(A),set(A,Xsa))),P1)) ) ).

tff(fact_5_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Xa1))
       => ( filter(A,P1,cons(A,Xa1,Xsa)) = cons(A,Xa1,filter(A,P1,Xsa)) ) )
      & ( ~ pp(aa(A,bool,P1,Xa1))
       => ( filter(A,P1,cons(A,Xa1,Xsa)) = filter(A,P1,Xsa) ) ) ) ).

tff(fact_6_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),set(B,Xsa)))
         => ( aa(B,A,F,X2) = aa(B,A,G,X2) ) ) ) ).

tff(fact_7_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Xa1: B,F: fun(B,A)] : ( map(B,A,F,cons(B,Xa1,Xsa)) = cons(A,aa(B,A,F,Xa1),map(B,A,F,Xsa)) ) ).

tff(fact_8_filter__filter,axiom,
    ! [A: $tType,Xsa: list(A),Q1: fun(A,bool),P1: fun(A,bool)] : ( filter(A,P1,filter(A,Q1,Xsa)) = filter(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,Q1),P1),Xsa) ) ).

tff(fact_9_map__ident,axiom,
    ! [A: $tType,X: list(A)] : ( map(A,A,combi(A),X) = X ) ).

tff(fact_10_calculation,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_11_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A5: A,List1: list(A),A4: A] :
      ( ( cons(A,A4,List1) = cons(A,A5,List2) )
    <=> ( ( A4 = A5 )
        & ( List1 = List2 ) ) ) ).

tff(fact_12_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X3: A] : ord_less_eq(A,X3,X3) ) ).

tff(fact_13_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_14_less__int__def,axiom,
    ! [W: int,Z1: int] :
      ( ord_less(int,Z1,W)
    <=> ( ord_less_eq(int,Z1,W)
        & ( Z1 != W ) ) ) ).

tff(fact_15_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_16_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_17_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_18_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( filter(A,P1,nil(A)) = nil(A) ) ).

tff(fact_19_list_Osimps_I3_J,axiom,
    ! [A: $tType,List: list(A),A3: A] : ( cons(A,A3,List) != nil(A) ) ).

tff(fact_20_list_Osimps_I2_J,axiom,
    ! [A: $tType,List: list(A),A3: A] : ( nil(A) != cons(A,A3,List) ) ).

tff(fact_21_set__subset__Cons,axiom,
    ! [A: $tType,Xa1: A,Xsa: list(A)] : ord_less_eq(fun(A,bool),set(A,Xsa),set(A,cons(A,Xa1,Xsa))) ).

tff(fact_22_filter__empty__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = nil(A) )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_23_filter__is__subset,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ord_less_eq(fun(A,bool),set(A,filter(A,P1,Xsa)),set(A,Xsa)) ).

tff(fact_24_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa1: A] :
          ( ( zero_zero(A) = Xa1 )
        <=> ( Xa1 = zero_zero(A) ) ) ) ).

tff(fact_25_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less_eq(A,X3,Y1)
         => ord_less_eq(A,Y1,X3) ) ) ).

tff(fact_26_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa1),aa(A,B,G,Xa1)) ) ) ).

tff(fact_27_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less_eq(A,X3,Z) ) ) ) ).

tff(fact_28_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
         => ( ord_less_eq(A,Y1,X3)
           => ( X3 = Y1 ) ) ) ) ).

tff(fact_29_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( B2 = C2 )
           => ord_less_eq(A,A2,C2) ) ) ) ).

tff(fact_30_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less_eq(A,B2,C2)
           => ord_less_eq(A,A2,C2) ) ) ) ).

tff(fact_31_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Xa1: A,Y: A] :
          ( ord_less_eq(A,Y,Xa1)
         => ( ord_less_eq(A,Xa1,Y)
          <=> ( Xa1 = Y ) ) ) ) ).

tff(fact_32_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa1),aa(A,B,G,Xa1)) ) ) ).

tff(fact_33_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( ( X3 = Y1 )
         => ord_less_eq(A,X3,Y1) ) ) ).

tff(fact_34_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,Xa1: A] :
          ( ( Xa1 = Y )
        <=> ( ord_less_eq(A,Xa1,Y)
            & ord_less_eq(A,Y,Xa1) ) ) ) ).

tff(fact_35_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
          | ord_less_eq(A,Y1,X3) ) ) ).

tff(fact_36_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X2: A] : ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_37_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less(A,X3,Y1)
         => ( ( X3 != Y1 )
           => ord_less(A,Y1,X3) ) ) ) ).

tff(fact_38_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ~ ord_less(A,Y1,X3) ) ) ).

tff(fact_39_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ( ord_less(A,Y1,Z)
           => ord_less(A,X3,Z) ) ) ) ).

tff(fact_40_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ( B2 = C2 )
           => ord_less(A,A2,C2) ) ) ) ).

tff(fact_41_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less(A,B2,C2)
           => ord_less(A,A2,C2) ) ) ) ).

tff(fact_42_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ~ ord_less(A,B2,A2) ) ) ).

tff(fact_43_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y: A,Xa1: A] :
          ( ord_less(A,Xa1,Y)
         => ( ord_less(A,Y,Xa1)
           => pp(P1) ) ) ) ).

tff(fact_44_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ( Y1 != X3 ) ) ) ).

tff(fact_45_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ( X3 != Y1 ) ) ) ).

tff(fact_46_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ~ ord_less(A,Y1,X3) ) ) ).

tff(fact_47_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ~ ord_less(A,Y1,X3) ) ) ).

tff(fact_48_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ( X3 != Y1 ) ) ) ).

tff(fact_49_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ( X3 != Y1 )
         => ( ~ ord_less(A,X3,Y1)
           => ord_less(A,Y1,X3) ) ) ) ).

tff(fact_50_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xa1: A,Y: A] :
          ( ~ ord_less(A,Y,Xa1)
         => ( ~ ord_less(A,Xa1,Y)
          <=> ( Xa1 = Y ) ) ) ) ).

tff(fact_51_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
          | ( X3 = Y1 )
          | ord_less(A,Y1,X3) ) ) ).

tff(fact_52_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa1: A] :
          ( ~ ord_less(A,Xa1,Y)
        <=> ( ord_less(A,Y,Xa1)
            | ( Xa1 = Y ) ) ) ) ).

tff(fact_53_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa1: A] :
          ( ( Xa1 != Y )
        <=> ( ord_less(A,Xa1,Y)
            | ord_less(A,Y,Xa1) ) ) ) ).

tff(fact_54_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X3: A] : ~ ord_less(A,X3,X3) ) ).

tff(fact_55_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X3: A] : ( cons(A,X3,Xs1) != Xs1 ) ).

tff(fact_56_not__Cons__self,axiom,
    ! [A: $tType,X3: A,Xs1: list(A)] : ( Xs1 != cons(A,X3,Xs1) ) ).

tff(fact_57_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
         => ( ord_less(A,Y1,Z)
           => ord_less(A,X3,Z) ) ) ) ).

tff(fact_58_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less(A,X3,Z) ) ) ) ).

tff(fact_59_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( A2 != B2 )
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_60_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
         => ( ord_less(A,X3,Y1)
            | ( X3 = Y1 ) ) ) ) ).

tff(fact_61_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa1: A] :
          ( ord_less_eq(A,Xa1,Y)
         => ( ~ ord_less(A,Xa1,Y)
          <=> ( Xa1 = Y ) ) ) ) ).

tff(fact_62_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ord_less_eq(A,X3,Y1) ) ) ).

tff(fact_63_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X3: A,Y1: A] :
          ( ord_less_eq(A,Y1,X3)
         => ~ ord_less(A,X3,Y1) ) ) ).

tff(fact_64_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ( A2 != B2 )
         => ( ord_less_eq(A,A2,B2)
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_65_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa1: A] :
          ( ~ ord_less(A,Xa1,Y)
         => ( ord_less_eq(A,Xa1,Y)
          <=> ( Xa1 = Y ) ) ) ) ).

tff(fact_66_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X3: A,Y1: A] :
          ( ~ ord_less_eq(A,Y1,X3)
         => ord_less(A,X3,Y1) ) ) ).

tff(fact_67_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less(A,X3,Y1)
         => ord_less_eq(A,Y1,X3) ) ) ).

tff(fact_68_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,Xa1: A] :
          ( ord_less_eq(A,Xa1,Y)
        <=> ( ord_less(A,Xa1,Y)
            | ( Xa1 = Y ) ) ) ) ).

tff(fact_69_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,Xa1: A] :
          ( ord_less(A,Xa1,Y)
        <=> ( ord_less_eq(A,Xa1,Y)
            & ~ ord_less_eq(A,Y,Xa1) ) ) ) ).

tff(fact_70_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,Xa1: A] :
          ( ord_less(A,Xa1,Y)
        <=> ( ord_less_eq(A,Xa1,Y)
            & ( Xa1 != Y ) ) ) ) ).

tff(fact_71_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
          | ord_less(A,Y1,X3) ) ) ).

tff(fact_72_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa1: A] :
          ( ~ ord_less_eq(A,Xa1,Y)
        <=> ord_less(A,Y,Xa1) ) ) ).

tff(fact_73_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,Xa1: A] :
          ( ~ ord_less(A,Xa1,Y)
        <=> ord_less_eq(A,Y,Xa1) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa1),A1))
    <=> pp(aa(A,bool,A1,Xa1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa1: A,Y: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),set(A,cons(A,Xa1,Xsa))))
     => ( ( Y = Xa1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),set(A,Xsa))) ) ) ).

tff(fact_78_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_79_filter__False,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X1)) )
     => ( filter(A,P1,Xsa) = nil(A) ) ) ).

tff(fact_80_filter__True,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => pp(aa(A,bool,P1,X1)) )
     => ( filter(A,P1,Xsa) = Xsa ) ) ).

tff(fact_81_filter__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Ys)))
           => ( pp(aa(A,bool,P1,X1))
            <=> pp(aa(A,bool,Q1,X1)) ) )
       => ( filter(A,P1,Xsa) = filter(A,Q1,Ys) ) ) ) ).

tff(fact_82_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Ys)))
           => ( aa(A,B,F,X1) = aa(A,B,G,X1) ) )
       => ( map(A,B,F,Xsa) = map(A,B,G,Ys) ) ) ) ).

tff(fact_83_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ( aa(A,A,F,X1) = X1 ) )
     => ( map(A,A,F,Xsa) = Xsa ) ) ).

tff(fact_84_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ( aa(A,B,F,X1) = aa(A,B,G,X1) ) )
     => ( map(A,B,F,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_85_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys: list(B)] :
      ( ? [Xs: list(A)] : ( Ys = map(A,B,F,Xs) )
    <=> ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),set(B,Ys)))
         => ? [Xa2: A] : ( X2 = aa(A,B,F,Xa2) ) ) ) ).

tff(fact_86_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less(fun(A,B),F,G)
        <=> ( ord_less_eq(fun(A,B),F,G)
            & ~ ord_less_eq(fun(A,B),G,F) ) ) ) ).

tff(fact_87_zlcms__pos,axiom,
    ! [Is: list(int)] :
      ( ! [X1: int] :
          ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),X1),set(int,Is)))
         => ( X1 != zero_zero(int) ) )
     => ord_less(int,zero_zero(int),zlcms(Is)) ) ).

tff(fact_88_elem__le__zlcms,axiom,
    ! [I: int,Is: list(int)] :
      ( ! [X1: int] :
          ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),X1),set(int,Is)))
         => ( X1 != zero_zero(int) ) )
     => ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),I),set(int,Is)))
       => ord_less_eq(int,I,zlcms(Is)) ) ) ).

tff(fact_89_equalityI,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( ord_less_eq(fun(A,bool),B1,A1)
       => ( A1 = B1 ) ) ) ).

tff(fact_90_subsetD,axiom,
    ! [A: $tType,C1: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_91_subset__refl,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,A1) ).

tff(fact_92_psubset__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less(fun(A,bool),A1,B1)
    <=> ( ord_less_eq(fun(A,bool),A1,B1)
        & ( A1 != B1 ) ) ) ).

tff(fact_93_set__eq__subset,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
    <=> ( ord_less_eq(fun(A,bool),A1,B1)
        & ord_less_eq(fun(A,bool),B1,A1) ) ) ).

tff(fact_94_subset__iff__psubset__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
    <=> ( ord_less(fun(A,bool),A1,B1)
        | ( A1 = B1 ) ) ) ).

tff(fact_95_equalityD1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
     => ord_less_eq(fun(A,bool),A1,B1) ) ).

tff(fact_96_equalityD2,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
     => ord_less_eq(fun(A,bool),B1,A1) ) ).

tff(fact_97_psubset__imp__subset,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less(fun(A,bool),A1,B1)
     => ord_less_eq(fun(A,bool),A1,B1) ) ).

tff(fact_98_in__mono,axiom,
    ! [A: $tType,Xa1: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa1),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa1),B1)) ) ) ).

%----Arities (12)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [X: int] :
      ( ord_less_eq(int,zero_zero(int),X)
      & ord_less(int,X,zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue)))),as))))
      & ! [Xa: atom] :
          ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))))))))
         => i_Z(Xa,cons(int,X,xs)) ) ) ).

%------------------------------------------------------------------------------
