%------------------------------------------------------------------------------
% File     : COM081_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 187
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_187 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.5.0, 0.00 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  161 (  53 unt;  53 typ;   0 def)
%            Number of atoms       :  216 ( 138 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  134 (  26   ~;   1   |;  23   &)
%                                         (  21 <=>;  63  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   60 (  35   >;  25   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-5 aty)
%            Number of functors    :   42 (  42 usr;   5 con; 0-6 aty)
%            Number of variables   :  409 ( 344   !;  17   ?; 409   :)
%                                         (  48  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:33
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_Enum_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( ( nat * list(A) ) > list(list(A)) ) ).

tff(sy_c_Enum_Oproduct,type,
    product: 
      !>[A: $tType,B: $tType] : ( ( list(A) * list(B) ) > list(product_prod(A,B)) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * list(A) * list(B) ) > list(C) ) ).

tff(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( list(list(A)) > list(A) ) ).

tff(sy_c_List_OdropWhile,type,
    dropWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : fun(fun(A,B),fun(list(A),list(B))) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oremdups,type,
    remdups: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_List_Otranspose,type,
    transpose: 
      !>[A: $tType] : ( list(list(A)) > list(list(A)) ) ).

tff(sy_c_List_Otranspose__rel,type,
    transpose_rel: 
      !>[A: $tType] : fun(list(list(A)),fun(list(list(A)),bool)) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Wellfounded_Oaccp,type,
    accp: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (98)
tff(fact_0__096lbounds_Aas_A_126_061_A_091_093_A_061_061_062_AEX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ( ( lbounds(as) != nil(product_prod(int,list(int))) )
   => ? [X4: int] :
      ! [Xa2: atom] :
        ( member(atom,Xa2,set(atom,as))
       => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa2),aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X4),xs))) ) ) ).

tff(fact_1__096lbounds_Aas_A_061_A_091_093_A_061_061_062_AEX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ( ( lbounds(as) = nil(product_prod(int,list(int))) )
   => ? [X4: int] :
      ! [Xa2: atom] :
        ( member(atom,Xa2,set(atom,as))
       => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa2),aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X4),xs))) ) ) ).

tff(fact_2__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

tff(fact_3_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List: list(A),A3: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A6),List3) )
    <=> ( ( A3 = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_4_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,Y1: A] :
      ( member(A,Y1,set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)))
     => ( ( Y1 = X2 )
        | member(A,Y1,set(A,Xsa)) ) ) ).

tff(fact_5_norm,axiom,
    ! [X: atom] :
      ( member(atom,X,set(atom,as))
     => ( divisor(X) != zero_zero(int) ) ) ).

tff(fact_6_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1) ) ).

tff(fact_7_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1) != Xs1 ) ).

tff(fact_8_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ( member(A,X2,set(A,Xsa))
       => ( insert(A,X2,Xsa) = Xsa ) )
      & ( ~ member(A,X2,set(A,Xsa))
       => ( insert(A,X2,Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa) ) ) ) ).

tff(fact_9_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ~ member(A,X2,set(A,Xsa))
     => ( insert(A,X2,Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa) ) ) ).

tff(fact_10_remdups_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ( member(A,X2,set(A,Xsa))
       => ( remdups(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)) = remdups(A,Xsa) ) )
      & ( ~ member(A,X2,set(A,Xsa))
       => ( remdups(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),remdups(A,Xsa)) ) ) ) ).

tff(fact_11_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) ) ).

tff(fact_12_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) != nil(A) ) ).

tff(fact_13_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A3: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A3),List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A3),List) ) ).

tff(fact_14_set__remdups,axiom,
    ! [A: $tType,Xsa: list(A)] : ( set(A,remdups(A,Xsa)) = set(A,Xsa) ) ).

tff(fact_15_remdups_Osimps_I1_J,axiom,
    ! [A: $tType] : ( remdups(A,nil(A)) = nil(A) ) ).

tff(fact_16_remdups__eq__nil__right__iff,axiom,
    ! [A: $tType,X2: list(A)] :
      ( ( nil(A) = remdups(A,X2) )
    <=> ( X2 = nil(A) ) ) ).

tff(fact_17_remdups__eq__nil__iff,axiom,
    ! [A: $tType,X2: list(A)] :
      ( ( remdups(A,X2) = nil(A) )
    <=> ( X2 = nil(A) ) ) ).

tff(fact_18_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)) ) ).

tff(fact_19_remdups__remdups,axiom,
    ! [A: $tType,Xs1: list(A)] : ( remdups(A,remdups(A,Xs1)) = remdups(A,Xs1) ) ).

tff(fact_20_insert__remdups,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( insert(A,X1,remdups(A,Xs1)) = remdups(A,insert(A,X1,Xs1)) ) ).

tff(fact_21_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_22_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( member(A,X2,set(A,Xsa))
     => ( insert(A,X2,Xsa) = Xsa ) ) ).

tff(fact_23_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List1: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) ) ) ).

tff(fact_24_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys2: list(A)] : ( Xsa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys2) ) ) ).

tff(fact_25_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

tff(fact_26_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_27_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs1: list(A),X1: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys1)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),splice(A,Xs1,Ys1))) ) ).

tff(fact_28_list__nonempty__induct,axiom,
    ! [A: $tType,P1: fun(list(A),bool),Xsa: list(A)] :
      ( ( Xsa != nil(A) )
     => ( ! [X4: A] : pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X4),nil(A))))
       => ( ! [X4: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P1,Xs2))
               => pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X4),Xs2))) ) )
         => pp(aa(list(A),bool,P1,Xsa)) ) ) ) ).

tff(fact_29_product_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Uu: list(B)] : ( product(A,B,nil(A),Uu) = nil(product_prod(A,B)) ) ).

tff(fact_30_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X3: fm(atom)] :
          ( member(fm(atom),X3,set(fm(atom),Fs))
         => interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_31_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X3: A] :
          ( member(A,X3,set(A,Xsa))
          & pp(aa(A,bool,P1,X3))
          & ! [Y2: A] :
              ( ( member(A,Y2,set(A,Xsa))
                & pp(aa(A,bool,P1,Y2)) )
             => ( Y2 = X3 ) ) ) ) ).

tff(fact_32_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_33_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_34_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_35_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X3: fm(atom)] :
          ( member(fm(atom),X3,set(fm(atom),Fs))
          & interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_36_sublist__singleton,axiom,
    ! [A: $tType,X2: A,A2: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A2)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A)),A2) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A2)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A)),A2) = nil(A) ) ) ) ).

tff(fact_37_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xsa: list(B),X2: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X2),Xsa),nil(C)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F,X2),zero_zero(C))),zipwith0(B,C,A,F,Xsa,nil(C))) ) ) ).

tff(fact_38_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),aa(list(C),list(C),aa(C,fun(list(C),list(C)),cons(C),Y1),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F,zero_zero(B)),Y1)),zipwith0(B,C,A,F,nil(B),Ys)) ) ) ).

tff(fact_39_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_40_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A3: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A3),List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A3),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_41_sublist__nil,axiom,
    ! [A: $tType,A2: fun(nat,bool)] : ( sublist(A,nil(A),A2) = nil(A) ) ).

tff(fact_42_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,Xsa: list(B),X2: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X2),Xsa),aa(list(C),list(C),aa(C,fun(list(C),list(C)),cons(C),Y1),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F,X2),Y1)),zipwith0(B,C,A,F,Xsa,Ys)) ) ) ).

tff(fact_43_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),nil(C)) = nil(A) ) ) ).

tff(fact_44_in__set__sublistD,axiom,
    ! [A: $tType,I1: fun(nat,bool),Xsa: list(A),X2: A] :
      ( member(A,X2,set(A,sublist(A,Xsa,I1)))
     => member(A,X2,set(A,Xsa)) ) ).

tff(fact_45_notin__set__sublistI,axiom,
    ! [A: $tType,I1: fun(nat,bool),Xsa: list(A),X2: A] :
      ( ~ member(A,X2,set(A,Xsa))
     => ~ member(A,X2,set(A,sublist(A,Xsa,I1))) ) ).

tff(fact_46_n__lists__Nil,axiom,
    ! [A: $tType,N: nat] :
      ( ( ( N = zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),nil(list(A))) ) )
      & ( ( N != zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = nil(list(A)) ) ) ) ).

tff(fact_47_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs1: list(A)] : ( n_lists(A,zero_zero(nat),Xs1) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),nil(list(A))) ) ).

tff(fact_48_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_49_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A)] : ( iprod(A,nil(A),Ys1) = zero_zero(A) ) ) ).

tff(fact_50_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs1: list(A)] : ( iprod(A,Xs1,nil(A)) = zero_zero(A) ) ) ).

tff(fact_51_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X4: A] :
              ( member(A,X4,set(A,Cs))
             => ( X4 = zero_zero(A) ) )
         => ( iprod(A,Cs,Xsa) = zero_zero(A) ) ) ) ).

tff(fact_52_transpose_Osimps_I2_J,axiom,
    ! [A: $tType,Xss1: list(list(A))] : ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),Xss1)) = transpose(A,Xss1) ) ).

tff(fact_53_dropWhile__eq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( dropWhile(A,P1,Xsa) = nil(A) )
    <=> ! [X3: A] :
          ( member(A,X3,set(A,Xsa))
         => pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_54_zipwith0__Nil,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),Ys) = aa(list(C),list(A),aa(fun(C,A),fun(list(C),list(A)),map(C,A),aa(B,fun(C,A),F,zero_zero(B))),Ys) ) ) ).

tff(fact_55_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),X2: B,F: fun(B,A)] : ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X2),Xsa)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(B,A,F,X2)),aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa)) ) ).

tff(fact_56_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),G),Xsa) )
    <=> ! [X3: B] :
          ( member(B,X3,set(B,Xsa))
         => ( aa(B,A,F,X3) = aa(B,A,G,X3) ) ) ) ).

tff(fact_57_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_58_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),nil(B)) = nil(A) ) ).

tff(fact_59_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_60_dropWhile_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,X2))
       => ( dropWhile(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)) = dropWhile(A,P1,Xsa) ) )
      & ( ~ pp(aa(A,bool,P1,X2))
       => ( dropWhile(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa) ) ) ) ).

tff(fact_61_dropWhile_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( dropWhile(A,P1,nil(A)) = nil(A) ) ).

tff(fact_62_transpose_Osimps_I1_J,axiom,
    ! [A: $tType] : ( transpose(A,nil(list(A))) = nil(list(A)) ) ).

tff(fact_63_transpose__map__map,axiom,
    ! [A: $tType,B: $tType,Xsa: list(list(B)),F: fun(B,A)] : ( transpose(A,aa(list(list(B)),list(list(A)),aa(fun(list(B),list(A)),fun(list(list(B)),list(list(A))),map(list(B),list(A)),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F)),Xsa)) = aa(list(list(B)),list(list(A)),aa(fun(list(B),list(A)),fun(list(list(B)),list(list(A))),map(list(B),list(A)),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F)),transpose(B,Xsa)) ) ).

tff(fact_64_remdups__map__remdups,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] : ( remdups(A,aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),remdups(B,Xsa))) = remdups(A,aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa)) ) ).

tff(fact_65_transpose__empty,axiom,
    ! [A: $tType,Xsa: list(list(A))] :
      ( ( transpose(A,Xsa) = nil(list(A)) )
    <=> ! [X3: list(A)] :
          ( member(list(A),X3,set(list(A),Xsa))
         => ( X3 = nil(A) ) ) ) ).

tff(fact_66_dropWhile__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),K: list(A),L: list(A)] :
      ( ( L = K )
     => ( ! [X4: A] :
            ( member(A,X4,set(A,L))
           => ( pp(aa(A,bool,P1,X4))
            <=> pp(aa(A,bool,Q1,X4)) ) )
       => ( dropWhile(A,P1,L) = dropWhile(A,Q1,K) ) ) ) ).

tff(fact_67_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys: list(B)] :
      ( ? [Xs: list(A)] : ( Ys = aa(list(A),list(B),aa(fun(A,B),fun(list(A),list(B)),map(A,B),F),Xs) )
    <=> ! [X3: B] :
          ( member(B,X3,set(B,Ys))
         => ? [Xa1: A] : ( X3 = aa(A,B,F,Xa1) ) ) ) ).

tff(fact_68_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X4: A] :
          ( member(A,X4,set(A,Xsa))
         => ( aa(A,B,F,X4) = aa(A,B,G,X4) ) )
     => ( aa(list(A),list(B),aa(fun(A,B),fun(list(A),list(B)),map(A,B),F),Xsa) = aa(list(A),list(B),aa(fun(A,B),fun(list(A),list(B)),map(A,B),G),Xsa) ) ) ).

tff(fact_69_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X4: A] :
            ( member(A,X4,set(A,Ys))
           => ( aa(A,B,F,X4) = aa(A,B,G,X4) ) )
       => ( aa(list(A),list(B),aa(fun(A,B),fun(list(A),list(B)),map(A,B),F),Xsa) = aa(list(A),list(B),aa(fun(A,B),fun(list(A),list(B)),map(A,B),G),Ys) ) ) ) ).

tff(fact_70_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X4: A] :
          ( member(A,X4,set(A,Xsa))
         => ( aa(A,A,F,X4) = X4 ) )
     => ( aa(list(A),list(A),aa(fun(A,A),fun(list(A),list(A)),map(A,A),F),Xsa) = Xsa ) ) ).

tff(fact_71_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xsa: list(A),X2: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Ys) )
    <=> ? [Z1: B,Zs1: list(B)] :
          ( ( Ys = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z1),Zs1) )
          & ( X2 = aa(B,A,F,Z1) )
          & ( Xsa = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs1) ) ) ) ).

tff(fact_72_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y1: A,Xsa: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys) )
    <=> ? [Z1: B,Zs1: list(B)] :
          ( ( Xsa = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z1),Zs1) )
          & ( aa(B,A,F,Z1) = Y1 )
          & ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs1) = Ys ) ) ) ).

tff(fact_73_Cons__eq__map__D,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xsa: list(A),X2: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Ys) )
     => ? [Z: B,Zs: list(B)] :
          ( ( Ys = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( X2 = aa(B,A,F,Z) )
          & ( Xsa = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X4: A] : ( aa(A,B,F,X4) = aa(A,B,G,X4) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] :
      ( member(A,X2,A2)
    <=> pp(aa(A,bool,A2,X2)) ) ).

tff(fact_76_map__eq__Cons__D,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y1: A,Xsa: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys) )
     => ? [Z: B,Zs: list(B)] :
          ( ( Xsa = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( aa(B,A,F,Z) = Y1 )
          & ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs) = Ys ) ) ) ).

tff(fact_77_concat__eq__Nil__conv,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( ( concat(A,Xss) = nil(A) )
    <=> ! [X3: list(A)] :
          ( member(list(A),X3,set(list(A),Xss))
         => ( X3 = nil(A) ) ) ) ).

tff(fact_78_concat_Osimps_I1_J,axiom,
    ! [A: $tType] : ( concat(A,nil(list(A))) = nil(A) ) ).

tff(fact_79_Nil__eq__concat__conv,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( ( nil(A) = concat(A,Xss) )
    <=> ! [X3: list(A)] :
          ( member(list(A),X3,set(list(A),Xss))
         => ( X3 = nil(A) ) ) ) ).

tff(fact_80_map__concat,axiom,
    ! [A: $tType,B: $tType,Xsa: list(list(B)),F: fun(B,A)] : ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),concat(B,Xsa)) = concat(A,aa(list(list(B)),list(list(A)),aa(fun(list(B),list(A)),fun(list(list(B)),list(list(A))),map(list(B),list(A)),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F)),Xsa)) ) ).

tff(fact_81_maps__def,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,list(A))] : ( maps(B,A,F,Xsa) = concat(A,aa(list(B),list(list(A)),aa(fun(B,list(A)),fun(list(B),list(list(A))),map(B,list(A)),F),Xsa)) ) ).

tff(fact_82_concat__map__maps,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,list(A))] : ( concat(A,aa(list(B),list(list(A)),aa(fun(B,list(A)),fun(list(B),list(list(A))),map(B,list(A)),F),Xsa)) = maps(B,A,F,Xsa) ) ).

tff(fact_83_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_84_transpose_Osimps_I3_J,axiom,
    ! [A: $tType,Xss: list(list(A)),Xsa: list(A),X2: A] : ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)),Xss)) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),concat(A,aa(list(list(A)),list(list(A)),aa(fun(list(A),list(A)),fun(list(list(A)),list(list(A))),map(list(A),list(A)),list_case(list(A),A,nil(A),combb(list(A),fun(list(A),list(A)),A,combk(list(A),list(A)),aa(list(A),fun(A,list(A)),combc(A,list(A),list(A),cons(A)),nil(A))))),Xss)))),transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),Xsa),concat(list(A),aa(list(list(A)),list(list(list(A))),aa(fun(list(A),list(list(A))),fun(list(list(A)),list(list(list(A)))),map(list(A),list(list(A))),list_case(list(list(A)),A,nil(list(A)),aa(fun(list(A),list(list(A))),fun(A,fun(list(A),list(list(A)))),combk(fun(list(A),list(list(A))),A),aa(list(list(A)),fun(list(A),list(list(A))),combc(list(A),list(list(A)),list(list(A)),cons(list(A))),nil(list(A)))))),Xss))))) ) ).

tff(fact_85_divisor__asubst,axiom,
    ! [A1: atom,Ks: list(int),I: int] : ( divisor(asubst(I,Ks,A1)) = divisor(A1) ) ).

tff(fact_86_map__ident,axiom,
    ! [A: $tType,X: list(A)] : ( aa(list(A),list(A),aa(fun(A,A),fun(list(A),list(A)),map(A,A),combi(A)),X) = X ) ).

tff(fact_87_concat__map__singleton,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] : ( concat(A,aa(list(B),list(list(A)),aa(fun(B,list(A)),fun(list(B),list(list(A))),map(B,list(A)),aa(list(A),fun(B,list(A)),combc(B,list(A),list(A),combb(A,fun(list(A),list(A)),B,cons(A),F)),nil(A))),Xsa)) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xsa) ) ).

tff(fact_88_transpose_Opsimps_I3_J,axiom,
    ! [A: $tType,Xss: list(list(A)),Xsa: list(A),X2: A] :
      ( accp(list(list(A)),transpose_rel(A),aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)),Xss))
     => ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)),Xss)) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),concat(A,aa(list(list(A)),list(list(A)),aa(fun(list(A),list(A)),fun(list(list(A)),list(list(A))),map(list(A),list(A)),list_case(list(A),A,nil(A),combb(list(A),fun(list(A),list(A)),A,combk(list(A),list(A)),aa(list(A),fun(A,list(A)),combc(A,list(A),list(A),cons(A)),nil(A))))),Xss)))),transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),Xsa),concat(list(A),aa(list(list(A)),list(list(list(A))),aa(fun(list(A),list(list(A))),fun(list(list(A)),list(list(list(A)))),map(list(A),list(list(A))),list_case(list(list(A)),A,nil(list(A)),aa(fun(list(A),list(list(A))),fun(A,fun(list(A),list(list(A)))),combk(fun(list(A),list(list(A))),A),aa(list(list(A)),fun(list(A),list(list(A))),combc(list(A),list(list(A)),list(list(A)),cons(list(A))),nil(list(A)))))),Xss))))) ) ) ).

tff(fact_89_n__lists_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),N1: nat] : ( n_lists(A,suc(N1),Xsa) = concat(list(A),aa(list(list(A)),list(list(list(A))),aa(fun(list(A),list(list(A))),fun(list(list(A)),list(list(list(A)))),map(list(A),list(list(A))),aa(list(A),fun(list(A),list(list(A))),combc(list(A),list(A),list(list(A)),combb(fun(A,list(A)),fun(list(A),list(list(A))),list(A),map(A,list(A)),combc(A,list(A),list(A),cons(A)))),Xsa)),n_lists(A,N1,Xsa))) ) ).

tff(fact_90_transpose_Opsimps_I1_J,axiom,
    ! [A: $tType] :
      ( accp(list(list(A)),transpose_rel(A),nil(list(A)))
     => ( transpose(A,nil(list(A))) = nil(list(A)) ) ) ).

tff(fact_91_transpose_Opsimps_I2_J,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( accp(list(list(A)),transpose_rel(A),aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),Xss))
     => ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),Xss)) = transpose(A,Xss) ) ) ).

tff(fact_92_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_93_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_94_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_95_Suc__inject,axiom,
    ! [Y: nat,X1: nat] :
      ( ( suc(X1) = suc(Y) )
     => ( X1 = Y ) ) ).

tff(fact_96_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_97_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

%----Arities (3)
tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [X: int] :
    ! [Xa: atom] :
      ( member(atom,Xa,set(atom,as))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa),aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X),xs))) ) ).

%------------------------------------------------------------------------------
