%------------------------------------------------------------------------------
% File     : COM080_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 185
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_185 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.50 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  178 (  50 unt;  55 typ;   0 def)
%            Number of atoms       :  239 ( 116 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  137 (  21   ~;   4   |;  16   &)
%                                         (  24 <=>;  72  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   47 (  29   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   17 (  16 usr;   0 prp; 1-5 aty)
%            Number of functors    :   35 (  35 usr;   8 con; 0-5 aty)
%            Number of variables   :  344 ( 300   !;   5   ?; 344   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:32
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C1: $tType] : ( fun(A,fun(B,C1)) > fun(list(A),fun(list(B),list(C1))) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Omap__fm,type,
    map_fm: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fm(A) ) > fm(B) ) ).

tff(sy_c_Logic_Oneg,type,
    neg: 
      !>[A: $tType] : ( fm(A) > fm(A) ) ).

tff(sy_c_Logic_Oqfree,type,
    qfree: 
      !>[A: $tType] : ( fm(A) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) ) > fun(atom,atom) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_il____,type,
    il: int ).

tff(sy_v_ksl____,type,
    ksl: list(int) ).

tff(sy_v_m____,type,
    m: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096ALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_A_Iasubst_A_Iil_A_L_Am_J_Aksl_Aa_J_Axs_096,axiom,
    ! [X4: atom] :
      ( member(atom,X4,set(atom,as))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,aa(atom,atom,asubst(aa(int,int,aa(int,fun(int,int),plus_plus(int),il),m),ksl),X4)),xs)) ) ).

tff(fact_1__096_B_Bthesis_O_A_I_B_Bil_Aksl_Am_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_A_Iasubst_A_Iil_A_L_Am_J_Aksl_Aa_J_Axs_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Il: int,Ksl: list(int),M1: int] :
        ~ ! [X4: atom] :
            ( member(atom,X4,set(atom,as))
           => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,aa(atom,atom,asubst(aa(int,int,aa(int,fun(int,int),plus_plus(int),Il),M1),Ksl),X4)),xs)) ) ).

tff(fact_2__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

tff(fact_3_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X1: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),cons(A,X1,Xs)),cons(A,Y,Ys)) = cons(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),X1),Y),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),Ys)) ) ) ).

tff(fact_4_IZ__asubst,axiom,
    ! [Xsa: list(int),A1: atom,Ks: list(int),I1: int] :
      ( pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,aa(atom,atom,asubst(I1,Ks),A1)),Xsa))
    <=> pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,A1),cons(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),I1),iprod(int,Ks,Xsa)),Xsa))) ) ).

tff(fact_5__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_6_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List: list(A),A1: A] :
      ( ( cons(A,A1,List) = cons(A,A6,List3) )
    <=> ( ( A1 = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_7_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_8_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A1: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C2),A1) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_9_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( iprod(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),Ys),Zs) = aa(A,A,aa(A,fun(A,A),plus_plus(A),iprod(A,Xs,Zs)),iprod(A,Ys,Zs)) ) ) ).

tff(fact_10_calculation,axiom,
    ( ( lbounds(as) = nil(product_prod(int,list(int))) )
   => ? [X: int] :
      ! [Xa: atom] :
        ( member(atom,Xa,set(atom,as))
       => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa),cons(int,X,xs))) ) ) ).

tff(fact_11_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,Y2: A] :
      ( member(A,Y2,set(A,cons(A,X2,Xsa)))
     => ( ( Y2 = X2 )
        | member(A,Y2,set(A,Xsa)) ) ) ).

tff(fact_12_norm,axiom,
    ! [X4: atom] :
      ( member(atom,X4,set(atom,as))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_13_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_14_divisor__asubst,axiom,
    ! [A3: atom,Ks1: list(int),I2: int] : ( divisor(aa(atom,atom,asubst(I2,Ks1),A3)) = divisor(A3) ) ).

tff(fact_15_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( iprod(A,Xs,nil(A)) = zero_zero(A) ) ) ).

tff(fact_16_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( iprod(A,nil(A),Ys) = zero_zero(A) ) ) ).

tff(fact_17_list__add__Nil,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),nil(A)),Xs) = Xs ) ) ).

tff(fact_18_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_19_list__add__Nil2,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),nil(A)) = Xs ) ) ).

tff(fact_20_list__add__assoc,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),Ys)),Zs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Ys),Zs)) ) ) ).

tff(fact_21_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( cons(A,A5,List2) != nil(A) ) ).

tff(fact_22_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != cons(A,A5,List2) ) ).

tff(fact_23_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),zero_zero(A)) = A3 ) ) ).

tff(fact_24_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),zero_zero(A)) = A3 ) ) ).

tff(fact_25_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A3) = A3 ) ) ).

tff(fact_26_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A3) = A3 ) ) ).

tff(fact_27_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A3: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A3) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),A3) )
         => ( B1 = C ) ) ) ).

tff(fact_28_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B1: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),C) )
         => ( B1 = C ) ) ) ).

tff(fact_29_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B1: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),C) )
         => ( B1 = C ) ) ) ).

tff(fact_30_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B1: A,A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C)) ) ) ).

tff(fact_31_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( cons(A,X1,Xs) != Xs ) ).

tff(fact_32_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] : ( Xs != cons(A,X1,Xs) ) ).

tff(fact_33_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_34_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X: A] :
              ( member(A,X,set(A,Cs))
             => ( X = zero_zero(A) ) )
         => ( iprod(A,Cs,Xsa) = zero_zero(A) ) ) ) ).

tff(fact_35_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X3: fm(atom)] :
          ( member(fm(atom),X3,set(fm(atom),Fs))
         => interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_36_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List1: list(A)] : ( Y != cons(A,A4,List1) ) ) ).

tff(fact_37_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys2: list(A)] : ( Xsa = cons(A,Y1,Ys2) ) ) ).

tff(fact_38_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C1: $tType] :
      ( ( zero(C1)
        & zero(B) )
     => ! [Ys1: list(C1),Y2: C1,F: fun(B,fun(C1,A))] : ( aa(list(C1),list(A),aa(list(B),fun(list(C1),list(A)),zipwith0(B,C1,A,F),nil(B)),cons(C1,Y2,Ys1)) = cons(A,aa(C1,A,aa(B,fun(C1,A),F,zero_zero(B)),Y2),aa(list(C1),list(A),aa(list(B),fun(list(C1),list(A)),zipwith0(B,C1,A,F),nil(B)),Ys1)) ) ) ).

tff(fact_39_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C1: $tType] :
      ( ( zero(C1)
        & zero(B) )
     => ! [Xsa: list(B),X2: B,F: fun(B,fun(C1,A))] : ( aa(list(C1),list(A),aa(list(B),fun(list(C1),list(A)),zipwith0(B,C1,A,F),cons(B,X2,Xsa)),nil(C1)) = cons(A,aa(C1,A,aa(B,fun(C1,A),F,X2),zero_zero(C1)),aa(list(C1),list(A),aa(list(B),fun(list(C1),list(A)),zipwith0(B,C1,A,F),Xsa),nil(C1))) ) ) ).

tff(fact_40_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [A1: A,B2: A] :
          ( ( B2 = aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_41_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),zero_zero(A)) = A3 ) ) ).

tff(fact_42_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C1: $tType] :
      ( ( zero(C1)
        & zero(B) )
     => ! [Ys1: list(C1),Y2: C1,Xsa: list(B),X2: B,F: fun(B,fun(C1,A))] : ( aa(list(C1),list(A),aa(list(B),fun(list(C1),list(A)),zipwith0(B,C1,A,F),cons(B,X2,Xsa)),cons(C1,Y2,Ys1)) = cons(A,aa(C1,A,aa(B,fun(C1,A),F,X2),Y2),aa(list(C1),list(A),aa(list(B),fun(list(C1),list(A)),zipwith0(B,C1,A,F),Xsa),Ys1)) ) ) ).

tff(fact_43_zipwith0_Osimps_I1_J,axiom,
    ! [C1: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C1) )
     => ! [F: fun(B,fun(C1,A))] : ( aa(list(C1),list(A),aa(list(B),fun(list(C1),list(A)),zipwith0(B,C1,A,F),nil(B)),nil(C1)) = nil(A) ) ) ).

tff(fact_44_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),A3) ) ) ).

tff(fact_45_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),aa(A,A,aa(A,fun(A,A),plus_plus(A),C),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),D)) ) ) ).

tff(fact_46_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),aa(A,A,aa(A,fun(A,A),plus_plus(A),C),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),C)),D) ) ) ).

tff(fact_47_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C)) ) ) ).

tff(fact_48_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),C)),B1) ) ) ).

tff(fact_49_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,B1: A,A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),B1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),C),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),C)),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),D)) ) ) ).

tff(fact_50_list__add__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ( plus_plus(list(A)) = zipwith0(A,A,A,plus_plus(A)) ) ) ).

tff(fact_51_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A3: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A3) = A3 ) ) ).

tff(fact_52_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X3: fm(atom)] :
          ( member(fm(atom),X3,set(fm(atom),Fs))
          & interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_53_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_54_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_55_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_56_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A1: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A1,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A1),List) ) ).

tff(fact_57_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X1: A] : ( splice(A,cons(A,X1,Xs),cons(A,Y,Ys)) = cons(A,X1,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_58_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( member(A,X2,set(A,Xsa))
     => ( insert(A,X2,Xsa) = Xsa ) ) ).

tff(fact_59_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_60_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_61_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ~ member(A,X2,set(A,Xsa))
     => ( insert(A,X2,Xsa) = cons(A,X2,Xsa) ) ) ).

tff(fact_62_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ( member(A,X2,set(A,Xsa))
       => ( insert(A,X2,Xsa) = Xsa ) )
      & ( ~ member(A,X2,set(A,Xsa))
       => ( insert(A,X2,Xsa) = cons(A,X2,Xsa) ) ) ) ).

tff(fact_63_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_64_sublist__singleton,axiom,
    ! [A: $tType,X2: A,A2: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A2)
       => ( sublist(A,cons(A,X2,nil(A)),A2) = cons(A,X2,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A2)
       => ( sublist(A,cons(A,X2,nil(A)),A2) = nil(A) ) ) ) ).

tff(fact_65_I__subst,axiom,
    ! [Xsa: list(int),Ks: list(int),I1: int,Phi: fm(atom)] :
      ( qfree(atom,Phi)
     => ( interpret(atom,int,i_Z,Phi,cons(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),I1),iprod(int,Ks,Xsa)),Xsa))
      <=> interpret(atom,int,i_Z,map_fm(atom,atom,asubst(I1,Ks),Phi),Xsa) ) ) ).

tff(fact_66_sublist__nil,axiom,
    ! [A: $tType,A2: fun(nat,bool)] : ( sublist(A,nil(A),A2) = nil(A) ) ).

tff(fact_67_notin__set__sublistI,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),X2: A] :
      ( ~ member(A,X2,set(A,Xsa))
     => ~ member(A,X2,set(A,sublist(A,Xsa,I))) ) ).

tff(fact_68_in__set__sublistD,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),X2: A] :
      ( member(A,X2,set(A,sublist(A,Xsa,I)))
     => member(A,X2,set(A,Xsa)) ) ).

tff(fact_69_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P: fun(A,bool)] :
      ( list_ex1(A,P,Xsa)
    <=> ? [X3: A] :
          ( member(A,X3,set(A,Xsa))
          & pp(aa(A,bool,P,X3))
          & ! [Y1: A] :
              ( ( member(A,Y1,set(A,Xsa))
                & pp(aa(A,bool,P,Y1)) )
             => ( Y1 = X3 ) ) ) ) ).

tff(fact_70_add__is__0,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Ma),N1) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_71_qfree__map__fm,axiom,
    ! [A: $tType,B: $tType,Phi: fm(B),F: fun(B,A)] :
      ( qfree(A,map_fm(B,A,F,Phi))
    <=> qfree(B,Phi) ) ).

tff(fact_72_qfree__list__conj,axiom,
    ! [A: $tType,Fs: list(fm(A))] :
      ( ! [X: fm(A)] :
          ( member(fm(A),X,set(fm(A),Fs))
         => qfree(A,X) )
     => qfree(A,list_conj(A,Fs)) ) ).

tff(fact_73_nat__add__right__cancel,axiom,
    ! [N1: nat,K: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Ma),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K) )
    <=> ( Ma = N1 ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] :
      ( member(A,X2,A2)
    <=> pp(aa(A,bool,A2,X2)) ) ).

tff(fact_76_nat__add__left__cancel,axiom,
    ! [N1: nat,Ma: nat,K: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),Ma) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),N1) )
    <=> ( Ma = N1 ) ) ).

tff(fact_77_nat__add__assoc,axiom,
    ! [K1: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K1)) ) ).

tff(fact_78_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),Z)) ) ).

tff(fact_79_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M) ) ).

tff(fact_80_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N) = N ) ).

tff(fact_81_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_82_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_83_qfree__list__disj,axiom,
    ! [A: $tType,Fs: list(fm(A))] :
      ( ! [X: fm(A)] :
          ( member(fm(A),X,set(fm(A),Fs))
         => qfree(A,X) )
     => qfree(A,list_disj(A,Fs)) ) ).

tff(fact_84_qfree__neg,axiom,
    ! [A: $tType,Phi: fm(A)] :
      ( qfree(A,neg(A,Phi))
    <=> qfree(A,Phi) ) ).

tff(fact_85_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_86_list__nonempty__induct,axiom,
    ! [A: $tType,P: fun(list(A),bool),Xsa: list(A)] :
      ( ( Xsa != nil(A) )
     => ( ! [X: A] : pp(aa(list(A),bool,P,cons(A,X,nil(A))))
       => ( ! [X: A,Xs1: list(A)] :
              ( ( Xs1 != nil(A) )
             => ( pp(aa(list(A),bool,P,Xs1))
               => pp(aa(list(A),bool,P,cons(A,X,Xs1))) ) )
         => pp(aa(list(A),bool,P,Xsa)) ) ) ) ).

tff(fact_87_list_Osize_I2_J,axiom,
    ! [A: $tType,List: list(A),A1: A,Fa: fun(A,nat)] : ( list_size(A,Fa,cons(A,A1,List)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(A,nat,Fa,A1)),list_size(A,Fa,List))),suc(zero_zero(nat))) ) ).

tff(fact_88_iprod__Cons,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A),Y: A,Xs: list(A),X1: A] : ( iprod(A,cons(A,X1,Xs),cons(A,Y,Ys)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),times_times(A,X1,Y)),iprod(A,Xs,Ys)) ) ) ).

tff(fact_89_mult__cancel2,axiom,
    ! [N1: nat,K: nat,Ma: nat] :
      ( ( times_times(nat,Ma,K) = times_times(nat,N1,K) )
    <=> ( ( Ma = N1 )
        | ( K = zero_zero(nat) ) ) ) ).

tff(fact_90_mult__cancel1,axiom,
    ! [N1: nat,Ma: nat,K: nat] :
      ( ( times_times(nat,K,Ma) = times_times(nat,K,N1) )
    <=> ( ( Ma = N1 )
        | ( K = zero_zero(nat) ) ) ) ).

tff(fact_91_mult__is__0,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( times_times(nat,Ma,N1) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        | ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_92_mult__0__right,axiom,
    ! [M: nat] : ( times_times(nat,M,zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_93_mult__0,axiom,
    ! [N: nat] : ( times_times(nat,zero_zero(nat),N) = zero_zero(nat) ) ).

tff(fact_94_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_95_mult__eq__1__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( times_times(nat,Ma,N1) = suc(zero_zero(nat)) )
    <=> ( ( Ma = suc(zero_zero(nat)) )
        & ( N1 = suc(zero_zero(nat)) ) ) ) ).

tff(fact_96_mult__Suc,axiom,
    ! [N: nat,M: nat] : ( times_times(nat,suc(M),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),times_times(nat,M,N)) ) ).

tff(fact_97_add__Suc,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M)),N) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)) ) ).

tff(fact_98_mult__Suc__right,axiom,
    ! [N: nat,M: nat] : ( times_times(nat,M,suc(N)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),times_times(nat,M,N)) ) ).

%----Arities (21)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oplus,axiom,
    cl_Groups_Oplus(nat) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [X: atom] :
      ( member(atom,X,set(atom,as))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,X),cons(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),il),m)),iprod(int,ksl,xs)),xs))) ) ).

%------------------------------------------------------------------------------
