%------------------------------------------------------------------------------
% File     : COM077_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 176
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_176 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  183 (  44 unt;  43 typ;   0 def)
%            Number of atoms       :  313 (  81 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  215 (  42   ~;  16   |;  14   &)
%                                         (  20 <=>; 123  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   30 (  18   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-3 aty)
%            Number of functors    :   27 (  27 usr;   5 con; 0-5 aty)
%            Number of variables   :  422 ( 375   !;   8   ?; 422   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:20
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Enum_Oproduct,type,
    product: 
      !>[A: $tType,B: $tType] : ( ( list(A) * list(B) ) > list(product_prod(A,B)) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_Olinorder__class_Osorted__list__of__set,type,
    linord467138063of_set: 
      !>[A: $tType] : ( fun(A,bool) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_1__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_2_Un__iff,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B3)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_3_UnE,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B3)))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_4_sup1E,axiom,
    ! [A: $tType,X3: A,B3: fun(A,bool),A2: fun(A,bool)] :
      ( pp(aa(A,bool,sup_sup(fun(A,bool),A2,B3),X3))
     => ( ~ pp(aa(A,bool,A2,X3))
       => pp(aa(A,bool,B3,X3)) ) ) ).

tff(fact_5_sup1CI,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A,B3: fun(A,bool)] :
      ( ( ~ pp(aa(A,bool,B3,X3))
       => pp(aa(A,bool,A2,X3)) )
     => pp(aa(A,bool,sup_sup(fun(A,bool),A2,B3),X3)) ) ).

tff(fact_6_UnCI,axiom,
    ! [A: $tType,A2: fun(A,bool),B3: fun(A,bool),C1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2)) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B3))) ) ).

tff(fact_7_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A3: A] : ( sup_sup(A,A3,sup_sup(A,A3,B2)) = sup_sup(A,A3,B2) ) ) ).

tff(fact_8_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y2: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,X2,Y2)) = sup_sup(A,X2,Y2) ) ) ).

tff(fact_9_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( lattice(B)
     => ! [G: fun(A,B),F: fun(A,B),X4: A] : ( aa(A,B,sup_sup(fun(A,B),F,G),X4) = sup_sup(B,aa(A,B,F,X4),aa(A,B,G,X4)) ) ) ).

tff(fact_10_sup__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( lattice(A)
     => ! [X3: B,G: fun(B,A),F: fun(B,A)] : ( aa(B,A,sup_sup(fun(B,A),F,G),X3) = sup_sup(A,aa(B,A,F,X3),aa(B,A,G,X3)) ) ) ).

tff(fact_11_less__supI1,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A3: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),A3))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),sup_sup(A,A3,B2))) ) ) ).

tff(fact_12_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X3: A] :
          ( ( zero_zero(A) = X3 )
        <=> ( X3 = zero_zero(A) ) ) ) ).

tff(fact_13_sup__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z1: A,Y2: A,X2: A] : ( sup_sup(A,sup_sup(A,X2,Y2),Z1) = sup_sup(A,X2,sup_sup(A,Y2,Z1)) ) ) ).

tff(fact_14_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z1: A,Y2: A,X2: A] : ( sup_sup(A,sup_sup(A,X2,Y2),Z1) = sup_sup(A,X2,sup_sup(A,Y2,Z1)) ) ) ).

tff(fact_15_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C2: A,B2: A,A3: A] : ( sup_sup(A,sup_sup(A,A3,B2),C2) = sup_sup(A,A3,sup_sup(A,B2,C2)) ) ) ).

tff(fact_16_sup__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z1: A,Y2: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,Y2,Z1)) = sup_sup(A,Y2,sup_sup(A,X2,Z1)) ) ) ).

tff(fact_17_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z1: A,Y2: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,Y2,Z1)) = sup_sup(A,Y2,sup_sup(A,X2,Z1)) ) ) ).

tff(fact_18_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C2: A,A3: A,B2: A] : ( sup_sup(A,B2,sup_sup(A,A3,C2)) = sup_sup(A,A3,sup_sup(A,B2,C2)) ) ) ).

tff(fact_19_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y2: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,X2,Y2)) = sup_sup(A,X2,Y2) ) ) ).

tff(fact_20_sup__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y2: A,X2: A] : ( sup_sup(A,X2,Y2) = sup_sup(A,Y2,X2) ) ) ).

tff(fact_21_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y2: A,X2: A] : ( sup_sup(A,X2,Y2) = sup_sup(A,Y2,X2) ) ) ).

tff(fact_22_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A3: A] : ( sup_sup(A,A3,B2) = sup_sup(A,B2,A3) ) ) ).

tff(fact_23_sup__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X2: A] : ( sup_sup(A,X2,X2) = X2 ) ) ).

tff(fact_24_sup_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A3: A] : ( sup_sup(A,A3,A3) = A3 ) ) ).

tff(fact_25_UnI2,axiom,
    ! [A: $tType,A2: fun(A,bool),B3: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B3))) ) ).

tff(fact_26_UnI1,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B3))) ) ).

tff(fact_27_sup1I2,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A,B3: fun(A,bool)] :
      ( pp(aa(A,bool,B3,X3))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A2,B3),X3)) ) ).

tff(fact_28_sup1I1,axiom,
    ! [A: $tType,B3: fun(A,bool),X3: A,A2: fun(A,bool)] :
      ( pp(aa(A,bool,A2,X3))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A2,B3),X3)) ) ).

tff(fact_29_ball__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B3: fun(A,bool),A2: fun(A,bool)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),sup_sup(fun(A,bool),A2,B3)))
         => pp(aa(A,bool,P1,X)) )
    <=> ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A2))
           => pp(aa(A,bool,P1,X)) )
        & ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),B3))
           => pp(aa(A,bool,P1,X)) ) ) ) ).

tff(fact_30_bex__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B3: fun(A,bool),A2: fun(A,bool)] :
      ( ? [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),sup_sup(fun(A,bool),A2,B3)))
          & pp(aa(A,bool,P1,X)) )
    <=> ( ? [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A2))
            & pp(aa(A,bool,P1,X)) )
        | ? [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),B3))
            & pp(aa(A,bool,P1,X)) ) ) ) ).

tff(fact_31_Un__assoc,axiom,
    ! [A: $tType,C3: fun(A,bool),B3: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),sup_sup(fun(A,bool),A2,B3),C3) = sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B3,C3)) ) ).

tff(fact_32_Un__left__commute,axiom,
    ! [A: $tType,C3: fun(A,bool),B3: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B3,C3)) = sup_sup(fun(A,bool),B3,sup_sup(fun(A,bool),A2,C3)) ) ).

tff(fact_33_Un__left__absorb,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),A2,B3)) = sup_sup(fun(A,bool),A2,B3) ) ).

tff(fact_34_Un__commute,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B3) = sup_sup(fun(A,bool),B3,A2) ) ).

tff(fact_35_Un__def,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B3) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,fun(A,bool),bool,member(A),A2)),combc(A,fun(A,bool),bool,member(A),B3))) ) ).

tff(fact_36_Un__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,A2) = A2 ) ).

tff(fact_37_sup__Un__eq,axiom,
    ! [A: $tType,S: fun(A,bool),R1: fun(A,bool),X4: A] :
      ( pp(aa(A,bool,sup_sup(fun(A,bool),combc(A,fun(A,bool),bool,member(A),R1),combc(A,fun(A,bool),bool,member(A),S)),X4))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),sup_sup(fun(A,bool),R1,S))) ) ).

tff(fact_38_Collect__disj__eq,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] : ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,P1),Q1)) = sup_sup(fun(A,bool),collect(A,P1),collect(A,Q1)) ) ).

tff(fact_39_less__supI2,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A3: A,B2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),B2))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),sup_sup(A,A3,B2))) ) ) ).

tff(fact_40_sup__eq__bot__iff,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [Y3: A,X3: A] :
          ( ( sup_sup(A,X3,Y3) = bot_bot(A) )
        <=> ( ( X3 = bot_bot(A) )
            & ( Y3 = bot_bot(A) ) ) ) ) ).

tff(fact_41_Un__empty,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ( sup_sup(fun(A,bool),A2,B3) = bot_bot(fun(A,bool)) )
    <=> ( ( A2 = bot_bot(fun(A,bool)) )
        & ( B3 = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_42_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_43_sup__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X2: A] : ( sup_sup(A,X2,bot_bot(A)) = X2 ) ) ).

tff(fact_44_sup__bot__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X2: A] : ( sup_sup(A,bot_bot(A),X2) = X2 ) ) ).

tff(fact_45_Un__empty__right,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,bot_bot(fun(A,bool))) = A2 ) ).

tff(fact_46_Un__empty__left,axiom,
    ! [A: $tType,B3: fun(A,bool)] : ( sup_sup(fun(A,bool),bot_bot(fun(A,bool)),B3) = B3 ) ).

tff(fact_47_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_48_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_49_emptyE,axiom,
    ! [A: $tType,A1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),bot_bot(fun(A,bool)))) ).

tff(fact_50_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X: A] : ~ pp(aa(A,bool,P1,X)) ) ).

tff(fact_51_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_52_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X: A] : ~ pp(aa(A,bool,P1,X)) ) ).

tff(fact_53_all__not__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ! [X: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A2))
    <=> ( A2 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_54_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_55_equals0D,axiom,
    ! [A: $tType,A1: A,A2: fun(A,bool)] :
      ( ( A2 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ).

tff(fact_56_ex__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ? [X: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A2))
    <=> ( A2 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_57_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_58_bot__empty__eq,axiom,
    ! [A: $tType,X4: A] :
      ( pp(aa(A,bool,bot_bot(fun(A,bool)),X4))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),bot_bot(fun(A,bool)))) ) ).

tff(fact_59_not__psubset__empty,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ~ pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A2),bot_bot(fun(A,bool)))) ).

tff(fact_60_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X3: B] : ( aa(B,A,bot_bot(fun(B,A)),X3) = bot_bot(A) ) ) ).

tff(fact_61_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X4: A] : ( aa(A,B,bot_bot(fun(A,B)),X4) = bot_bot(B) ) ) ).

tff(fact_62_not__less__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A3: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),bot_bot(A))) ) ).

tff(fact_63_bot__less,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A1: A] :
          ( ( A1 != bot_bot(A) )
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),bot_bot(A)),A1)) ) ) ).

tff(fact_64_psubset__trans,axiom,
    ! [A: $tType,C3: fun(A,bool),B3: fun(A,bool),A2: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A2),B3))
     => ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),B3),C3))
       => pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A2),C3)) ) ) ).

tff(fact_65_psubsetD,axiom,
    ! [A: $tType,C1: A,B3: fun(A,bool),A2: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A2),B3))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_66_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( ( X2 != Y2 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ) ).

tff(fact_67_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ).

tff(fact_68_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),Z1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Z1)) ) ) ) ).

tff(fact_69_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
         => ( ( B2 = C2 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C2)) ) ) ) ).

tff(fact_70_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ( A3 = B2 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),C2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C2)) ) ) ) ).

tff(fact_71_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),A3)) ) ) ).

tff(fact_72_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y3: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y3))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y3),X3))
           => pp(P1) ) ) ) ).

tff(fact_73_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( Y2 != X2 ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A2))
    <=> pp(aa(A,bool,A2,X3)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( X2 != Y2 ) ) ) ).

tff(fact_78_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ).

tff(fact_79_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ).

tff(fact_80_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( X2 != Y2 ) ) ) ).

tff(fact_81_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ) ).

tff(fact_82_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X3: A,Y3: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y3),X3))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y3))
          <=> ( X3 = Y3 ) ) ) ) ).

tff(fact_83_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
          | ( X2 = Y2 )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ).

tff(fact_84_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y3: A,X3: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y3))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y3),X3))
            | ( X3 = Y3 ) ) ) ) ).

tff(fact_85_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y3: A,X3: A] :
          ( ( X3 != Y3 )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y3))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y3),X3)) ) ) ) ).

tff(fact_86_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),X2)) ) ).

tff(fact_87_sorted__list__of__set__empty,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ( linord467138063of_set(A,bot_bot(fun(A,bool))) = nil(A) ) ) ).

tff(fact_88_equals0I,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ! [Y1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),A2))
     => ( A2 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_89_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F: fun(B,A),A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),aa(B,A,F,B1)))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),B1),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X1),Y1))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F,X1)),aa(B,A,F,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_90_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X3: A] :
        ? [X11: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),X11)) ) ).

tff(fact_91_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X2: A] :
        ? [Y1: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X2)) ) ).

tff(fact_92_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,B1: B,F: fun(B,A),A1: A] :
          ( ( A1 = aa(B,A,F,B1) )
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),B1),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X1),Y1))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F,X1)),aa(B,A,F,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_93_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F: fun(A,B),B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,B1)),C1))
           => ( ! [X1: A,Y1: A] :
                  ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,X1)),aa(A,B,F,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,A1)),C1)) ) ) ) ) ).

tff(fact_94_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ? [Z: A] :
              ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Z))
              & pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Z),Y2)) ) ) ) ).

tff(fact_95_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F: fun(A,B),B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
         => ( ( aa(A,B,F,B1) = C1 )
           => ( ! [X1: A,Y1: A] :
                  ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,X1)),aa(A,B,F,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,A1)),C1)) ) ) ) ) ).

tff(fact_96_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_97_product_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Uu: list(B)] : ( product(A,B,nil(A),Uu) = nil(product_prod(A,B)) ) ).

tff(fact_98_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
          & pp(aa(A,bool,P1,X))
          & ! [Y: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y),set(A,Xsa)))
                & pp(aa(A,bool,P1,Y)) )
             => ( Y = X ) ) ) ) ).

%----Arities (24)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_sup(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Lattices_Olattice,axiom,
    lattice(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (16)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    set(atom,as) = sup_sup(fun(atom,bool),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))))),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,combb(bool,fun(list(int),bool),int,combk(bool,list(int)),combc(int,int,bool,ord_less(int),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))) ).

%------------------------------------------------------------------------------
