%------------------------------------------------------------------------------
% File     : COM075_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 170
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_170 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  194 (  51 unt;  61 typ;   0 def)
%            Number of atoms       :  267 ( 115 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  162 (  28   ~;  10   |;   7   &)
%                                         (  28 <=>;  89  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   24 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   35 (  24   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-5 aty)
%            Number of functors    :   45 (  45 usr;   9 con; 0-4 aty)
%            Number of variables   :  367 ( 312   !;   3   ?; 367   :)
%                                         (  52  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:05
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (53)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Oring__div,type,
    ring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Olinorder__class_OMin,type,
    big_linorder_Min: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(list(A),fun(list(B),list(C))) ) ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) ) > fun(list(A),T1) ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: fun(int,fun(list(int),atom)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) ) > fun(atom,T1) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: fun(atom,int) ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_n____,type,
    n: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( aa(atom,int,divisor,X4) != zero_zero(int) ) ) ).

tff(fact_1_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),set(A,Xsa)))),P1)) ) ).

tff(fact_2_zmod__zero,axiom,
    ! [B2: int] : ( div_mod(int,zero_zero(int),B2) = zero_zero(int) ) ).

tff(fact_3_zmod__self,axiom,
    ! [A2: int] : ( div_mod(int,A2,A2) = zero_zero(int) ) ).

tff(fact_4_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X1: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xsa)))
         => ( aa(B,A,F,X1) = aa(B,A,G,X1) ) ) ) ).

tff(fact_5_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,zero_zero(A),A2) = zero_zero(A) ) ) ).

tff(fact_6_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,A2) = zero_zero(A) ) ) ).

tff(fact_7_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),A2) = zero_zero(A) ) ) ).

tff(fact_8__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_9_filter__filter,axiom,
    ! [A: $tType,Xsa: list(A),Q1: fun(A,bool),P1: fun(A,bool)] : ( filter(A,P1,filter(A,Q1,Xsa)) = filter(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),Q1)),P1),Xsa) ) ).

tff(fact_10_map__ident,axiom,
    ! [A: $tType,X4: list(A)] : ( map(A,A,combi(A),X4) = X4 ) ).

tff(fact_11_pos__mod__bound,axiom,
    ! [A2: int,B2: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),B2))
     => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_mod(int,A2,B2)),B2)) ) ).

tff(fact_12_neg__mod__bound,axiom,
    ! [A2: int,B2: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),B2),zero_zero(int)))
     => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),B2),div_mod(int,A2,B2))) ) ).

tff(fact_13_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,A2: A] : ( div_mod(A,div_mod(A,A2,B2),B2) = div_mod(A,A2,B2) ) ) ).

tff(fact_14_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_15_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_16_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_17_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( filter(A,P1,nil(A)) = nil(A) ) ).

tff(fact_18_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( aa(list(A),list(A),tl(A),nil(A)) = nil(A) ) ).

tff(fact_19_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_20_filter__empty__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = nil(A) )
    <=> ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X1)) ) ) ).

tff(fact_21_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X3: A] :
          ( ( zero_zero(A) = X3 )
        <=> ( X3 = zero_zero(A) ) ) ) ).

tff(fact_22_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C2: A,B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D) )
         => ( ( Aa = B1 )
          <=> ( C2 = D ) ) ) ) ).

tff(fact_23_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = zero_zero(A) )
        <=> ( Aa = B1 ) ) ) ).

tff(fact_24_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,Aa: A] :
          ( ( Aa = B1 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = zero_zero(A) ) ) ) ).

tff(fact_25_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_26_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C2: A,B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D) )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B1))
          <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C2),D)) ) ) ) ).

tff(fact_27_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_28_mod__diff__cong,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [B3: A,B2: A,A3: A,C1: A,A2: A] :
          ( ( div_mod(A,A2,C1) = div_mod(A,A3,C1) )
         => ( ( div_mod(A,B2,C1) = div_mod(A,B3,C1) )
           => ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B3),C1) ) ) ) ) ).

tff(fact_29_mod__diff__eq,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [C1: A,B2: A,A2: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),div_mod(A,A2,C1)),div_mod(A,B2,C1)),C1) ) ) ).

tff(fact_30_mod__diff__left__eq,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [C1: A,B2: A,A2: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),div_mod(A,A2,C1)),B2),C1) ) ) ).

tff(fact_31_mod__diff__right__eq,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [C1: A,B2: A,A2: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),div_mod(A,B2,C1)),C1) ) ) ).

tff(fact_32_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => pp(aa(A,bool,P1,X1)) ) ) ).

tff(fact_33_zdiff__zmod__left,axiom,
    ! [Y: int,M: int,X: int] : ( div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),div_mod(int,X,M)),Y),M) = div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),X),Y),M) ) ).

tff(fact_34_zdiff__zmod__right,axiom,
    ! [M: int,Y: int,X: int] : ( div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),X),div_mod(int,Y,M)),M) = div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),X),Y),M) ) ).

tff(fact_35_map__tl,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] : ( map(B,A,F,aa(list(B),list(B),tl(B),Xsa)) = aa(list(A),list(A),tl(A),map(B,A,F,Xsa)) ) ).

tff(fact_36_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B1))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1)),zero_zero(A))) ) ) ).

tff(fact_37_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs1: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs1),nil(A)) = zero_zero(A) ) ) ).

tff(fact_38_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),nil(A)),Ys1) = zero_zero(A) ) ) ).

tff(fact_39_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_40_filter__False,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X2)) )
     => ( filter(A,P1,Xsa) = nil(A) ) ) ).

tff(fact_41_less__bin__lemma,axiom,
    ! [La: int,K1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),K1),La))
    <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),aa(int,int,aa(int,fun(int,int),minus_minus(int),K1),La)),zero_zero(int))) ) ).

tff(fact_42_atom_Osimps_I1_J,axiom,
    ! [List2: list(int),Int2: int,List1: list(int),Int1: int] :
      ( ( aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1) = aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int2),List2) )
    <=> ( ( Int1 = Int2 )
        & ( List1 = List2 ) ) ) ).

tff(fact_43_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List1: list(int),Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int1),List1) ) ).

tff(fact_44_filter__True,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => pp(aa(A,bool,P1,X2)) )
     => ( filter(A,P1,Xsa) = Xsa ) ) ).

tff(fact_45_filter__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Ys)))
           => ( pp(aa(A,bool,P1,X2))
            <=> pp(aa(A,bool,Q1,X2)) ) )
       => ( filter(A,P1,Xsa) = filter(A,Q1,Ys) ) ) ) ).

tff(fact_46_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs1),nil(A)) = Xs1 ) ) ).

tff(fact_47_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys1: list(A),Xs1: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs1),Ys1)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs1),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys1),Zs)) ) ) ).

tff(fact_48_zlcms__pos,axiom,
    ! [Is: list(int)] :
      ( ! [X2: int] :
          ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),X2),set(int,Is)))
         => ( X2 != zero_zero(int) ) )
     => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),zlcms(Is))) ) ).

tff(fact_49_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X2: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Cs)))
             => ( X2 = zero_zero(A) ) )
         => ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Cs),Xsa) = zero_zero(A) ) ) ) ).

tff(fact_50_atom_Osize_I1_J,axiom,
    ! [List: list(int),Int: int] : ( atom_size(aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = zero_zero(nat) ) ).

tff(fact_51_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys: list(B)] :
      ( ? [Xs: list(A)] : ( Ys = map(A,B,F,Xs) )
    <=> ! [X1: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Ys)))
         => ? [Xa: A] : ( X1 = aa(A,B,F,Xa) ) ) ) ).

tff(fact_52_mod__less__divisor,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),div_mod(nat,M,N)),N)) ) ).

tff(fact_53_atom_Osize_I4_J,axiom,
    ! [List: list(int),Int: int] : ( size_size(atom,aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = zero_zero(nat) ) ).

tff(fact_54_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),Na)) ) ).

tff(fact_55_zero__less__diff,axiom,
    ! [M1: nat,Na: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),Na),M1)))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na)) ) ).

tff(fact_56_less__nat__zero__code,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_57_less__zeroE,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_58_diff__0__eq__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_59_diff__self__eq__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),M) = zero_zero(nat) ) ).

tff(fact_60_mod__if,axiom,
    ! [N: nat,M: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
       => ( div_mod(nat,M,N) = M ) )
      & ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
       => ( div_mod(nat,M,N) = div_mod(nat,aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N),N) ) ) ) ).

tff(fact_61_mod__geq,axiom,
    ! [N: nat,M: nat] :
      ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( div_mod(nat,M,N) = div_mod(nat,aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N),N) ) ) ).

tff(fact_62_less__imp__diff__less,axiom,
    ! [N: nat,K: nat,J: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),J),K))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),J),N)),K)) ) ).

tff(fact_63_diff__less__mono2,axiom,
    ! [L: nat,N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),L))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),N)),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),M))) ) ) ).

tff(fact_64_diff__commute,axiom,
    ! [K: nat,J: nat,I: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),J)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),K)),J) ) ).

tff(fact_65_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_66_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1)) ) ) ).

tff(fact_67_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_68_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_69_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M))
     => ( M != N ) ) ).

tff(fact_70_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S),T))
     => ( S != T ) ) ).

tff(fact_71_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_72_mod__less,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( div_mod(nat,M,N) = M ) ) ).

tff(fact_73_minus__nat_Odiff__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> pp(aa(A,bool,A1,X3)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_diffs0__imp__equal,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N) = zero_zero(nat) )
     => ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),N),M) = zero_zero(nat) )
       => ( M = N ) ) ) ).

tff(fact_78_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N)) ) ).

tff(fact_79_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( N != zero_zero(nat) ) ) ).

tff(fact_80_diff__less,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N))
     => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),M))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N)),M)) ) ) ).

tff(fact_81_not__less0,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_82_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => ( aa(A,B,F,X2) = aa(A,B,G,X2) ) )
     => ( map(A,B,F,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_83_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => ( aa(A,A,F,X2) = X2 ) )
     => ( map(A,A,F,Xsa) = Xsa ) ) ).

tff(fact_84_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Ys)))
           => ( aa(A,B,F,X2) = aa(A,B,G,X2) ) )
       => ( map(A,B,F,Xsa) = map(A,B,G,Ys) ) ) ) ).

tff(fact_85_zipwith0__Nil,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),Ys) = map(C,A,aa(B,fun(C,A),F,zero_zero(B)),Ys) ) ) ).

tff(fact_86__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

tff(fact_87_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),nil(C)) = nil(A) ) ) ).

tff(fact_88_list__diff__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ( minus_minus(list(A)) = zipwith0(A,A,A,minus_minus(A)) ) ) ).

tff(fact_89_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X1: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X1),set(fm(atom),Fs)))
         => interpret(atom,int,i_Z,X1,Xsa) ) ) ).

tff(fact_90_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X1: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X1),set(fm(atom),Fs)))
          & interpret(atom,int,i_Z,X1,Xsa) ) ) ).

tff(fact_91_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),ring_1_of_int(A,Z1)),zero_zero(A)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),Z1),zero_zero(int))) ) ) ).

tff(fact_92_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),ring_1_of_int(A,Z1)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),Z1)) ) ) ).

tff(fact_93_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int,W1: int] :
          ( ( ring_1_of_int(A,W1) = ring_1_of_int(A,Z1) )
        <=> ( W1 = Z1 ) ) ) ).

tff(fact_94_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( ring_1_of_int(A,Z1) = zero_zero(A) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_95_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z1) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_96_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_97_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int,W1: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),ring_1_of_int(A,W1)),ring_1_of_int(A,Z1)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),W1),Z1)) ) ) ).

tff(fact_98_of__int__diff,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Z: int,W: int] : ( ring_1_of_int(A,aa(int,int,aa(int,fun(int,int),minus_minus(int),W),Z)) = aa(A,A,aa(A,fun(A,A),minus_minus(A),ring_1_of_int(A,W)),ring_1_of_int(A,Z)) ) ) ).

%----Arities (16)
tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Divides_Oring__div,axiom,
    ring_div(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Divides_Osemiring__div,axiom,
    semiring_div(nat) ).

tff(arity_Nat_Onat___Groups_Ominus,axiom,
    cl_Groups_Ominus(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

%----Helper facts (17)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),n),big_linorder_Min(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))))))),aa(fun(atom,bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(atom,bool),fun(int,bool))),fun(fun(atom,bool),fun(list(int),fun(int,bool))),combc(list(int),fun(atom,bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool))),aa(fun(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool)))),combb(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool)),list(int)),combc(int,fun(atom,bool),bool)),aa(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool))),aa(fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),fun(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool)))),combb(fun(int,atom),fun(int,fun(fun(atom,bool),bool)),list(int)),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),combb(atom,fun(fun(atom,bool),bool),int),member(atom))),aa(fun(int,fun(list(int),atom)),fun(list(int),fun(int,atom)),combc(int,list(int),atom),c_PresArith_Oatom_OLe)))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,aa(fun(int,bool),fun(int,fun(list(int),bool)),aa(fun(bool,fun(list(int),bool)),fun(fun(int,bool),fun(int,fun(list(int),bool))),combb(bool,fun(list(int),bool),int),combk(bool,list(int))),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))))))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as))))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as))))) ).

%------------------------------------------------------------------------------
