%------------------------------------------------------------------------------
% File     : COM074_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 168
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_168 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  182 (  41 unt;  48 typ;   0 def)
%            Number of atoms       :  341 (  72 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  251 (  44   ~;  18   |;  11   &)
%                                         (  33 <=>; 145  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   22 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   21 (  15   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-2 aty)
%            Number of functors    :   35 (  35 usr;   8 con; 0-4 aty)
%            Number of variables   :  379 ( 341   !;   0   ?; 379   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:58
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (41)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Olinorder__class_OMin,type,
    big_linorder_Min: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: fun(int,fun(list(int),atom)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_ks____,type,
    ks: list(int) ).

tff(sy_v_l____,type,
    l: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_1_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),A2) = zero_zero(A) ) ) ).

tff(fact_2__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_3_less__bin__lemma,axiom,
    ! [La: int,K: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),K),La))
    <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),aa(int,int,aa(int,fun(int,int),minus_minus(int),K),La)),zero_zero(int))) ) ).

tff(fact_4_atom_Osimps_I1_J,axiom,
    ! [List2: list(int),Int2: int,List1: list(int),Int1: int] :
      ( ( aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1) = aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int2),List2) )
    <=> ( ( Int1 = Int2 )
        & ( List1 = List2 ) ) ) ).

tff(fact_5_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B1))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1)),zero_zero(A))) ) ) ).

tff(fact_6_le__iff__diff__le__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,Aa: A] :
          ( pp(aa(A,bool,ord_less_eq(A,Aa),B1))
        <=> pp(aa(A,bool,ord_less_eq(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1)),zero_zero(A))) ) ) ).

tff(fact_7_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List1: list(int),Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int1),List1) ) ).

tff(fact_8_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : pp(aa(A,bool,ord_less_eq(A,X),X)) ) ).

tff(fact_9_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_10_less__int__def,axiom,
    ! [W: int,Z1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),Z1),W))
    <=> ( pp(aa(int,bool,ord_less_eq(int,Z1),W))
        & ( Z1 != W ) ) ) ).

tff(fact_11_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    pp(aa(int,bool,ord_less_eq(int,zero_zero(int)),zero_zero(int))) ).

tff(fact_12_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),nil(A)) = zero_zero(A) ) ) ).

tff(fact_13_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),nil(A)),Ys) = zero_zero(A) ) ) ).

tff(fact_14_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),nil(A)) = Xs ) ) ).

tff(fact_15_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_16_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,ord_less_eq(A,X),Y))
         => pp(aa(A,bool,ord_less_eq(A,Y),X)) ) ) ).

tff(fact_17_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( pp(aa(fun(A,B),bool,ord_less_eq(fun(A,B),F),G))
         => pp(aa(B,bool,ord_less_eq(B,aa(A,B,F,X2)),aa(A,B,G,X2))) ) ) ).

tff(fact_18_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X),Y))
         => ( pp(aa(A,bool,ord_less_eq(A,Y),Z))
           => pp(aa(A,bool,ord_less_eq(A,X),Z)) ) ) ) ).

tff(fact_19_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X),Y))
         => ( pp(aa(A,bool,ord_less_eq(A,Y),X))
           => ( X = Y ) ) ) ) ).

tff(fact_20_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( pp(aa(A,bool,ord_less_eq(A,A2),B2))
         => ( ( B2 = C2 )
           => pp(aa(A,bool,ord_less_eq(A,A2),C2)) ) ) ) ).

tff(fact_21_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( pp(aa(A,bool,ord_less_eq(A,B2),C2))
           => pp(aa(A,bool,ord_less_eq(A,A2),C2)) ) ) ) ).

tff(fact_22_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X2: A,Y2: A] :
          ( pp(aa(A,bool,ord_less_eq(A,Y2),X2))
         => ( pp(aa(A,bool,ord_less_eq(A,X2),Y2))
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_23_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( pp(aa(fun(A,B),bool,ord_less_eq(fun(A,B),F),G))
         => pp(aa(B,bool,ord_less_eq(B,aa(A,B,F,X2)),aa(A,B,G,X2))) ) ) ).

tff(fact_24_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => pp(aa(A,bool,ord_less_eq(A,X),Y)) ) ) ).

tff(fact_25_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 = Y2 )
        <=> ( pp(aa(A,bool,ord_less_eq(A,X2),Y2))
            & pp(aa(A,bool,ord_less_eq(A,Y2),X2)) ) ) ) ).

tff(fact_26_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X),Y))
          | pp(aa(A,bool,ord_less_eq(A,Y),X)) ) ) ).

tff(fact_27_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( pp(aa(fun(A,B),bool,ord_less_eq(fun(A,B),F),G))
        <=> ! [X3: A] : pp(aa(B,bool,ord_less_eq(B,aa(A,B,F,X3)),aa(A,B,G,X3))) ) ) ).

tff(fact_28_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( ( X != Y )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_29_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_30_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z)) ) ) ) ).

tff(fact_31_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => ( ( B2 = C2 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),C2)) ) ) ) ).

tff(fact_32_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),C2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),C2)) ) ) ) ).

tff(fact_33_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),A2)) ) ) ).

tff(fact_34_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
           => pp(P1) ) ) ) ).

tff(fact_35_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( Y != X ) ) ) ).

tff(fact_36_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_37_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_38_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_39_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( X != Y ) ) ) ).

tff(fact_40_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_41_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_42_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
          | ( X = Y )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_43_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2))
            | ( X2 = Y2 ) ) ) ) ).

tff(fact_44_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ) ).

tff(fact_45_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),X)) ) ).

tff(fact_46_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( ( Aa = B1 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_47_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z)) ) ) ) ).

tff(fact_48_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( pp(aa(A,bool,ord_less_eq(A,Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Z)) ) ) ) ).

tff(fact_49_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( pp(aa(A,bool,ord_less_eq(A,A2),B2))
         => ( ( A2 != B2 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2)) ) ) ) ).

tff(fact_50_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
            | ( X = Y ) ) ) ) ).

tff(fact_51_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X2),Y2))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_52_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => pp(aa(A,bool,ord_less_eq(A,X),Y)) ) ) ).

tff(fact_53_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( pp(aa(A,bool,ord_less_eq(A,Y),X))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y)) ) ) ).

tff(fact_54_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ( A2 != B2 )
         => ( pp(aa(A,bool,ord_less_eq(A,A2),B2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2)) ) ) ) ).

tff(fact_55_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
         => ( pp(aa(A,bool,ord_less_eq(A,X2),Y2))
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_56_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ~ pp(aa(A,bool,ord_less_eq(A,Y),X))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y)) ) ) ).

tff(fact_57_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => pp(aa(A,bool,ord_less_eq(A,Y),X)) ) ) ).

tff(fact_58_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X2),Y2))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
            | ( X2 = Y2 ) ) ) ) ).

tff(fact_59_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
        <=> ( pp(aa(A,bool,ord_less_eq(A,X2),Y2))
            & ~ pp(aa(A,bool,ord_less_eq(A,Y2),X2)) ) ) ) ).

tff(fact_60_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
        <=> ( pp(aa(A,bool,ord_less_eq(A,X2),Y2))
            & ( X2 != Y2 ) ) ) ) ).

tff(fact_61_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less_eq(A,X),Y))
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

tff(fact_62_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ pp(aa(A,bool,ord_less_eq(A,X2),Y2))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X2)) ) ) ).

tff(fact_63_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
        <=> pp(aa(A,bool,ord_less_eq(A,Y2),X2)) ) ) ).

tff(fact_64_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = zero_zero(A) )
        <=> ( Aa = B1 ) ) ) ).

tff(fact_65_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,Aa: A] :
          ( ( Aa = B1 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = zero_zero(A) ) ) ) ).

tff(fact_66_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_67_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C1: A,B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( pp(aa(A,bool,ord_less_eq(A,Aa),B1))
          <=> pp(aa(A,bool,ord_less_eq(A,C1),D)) ) ) ) ).

tff(fact_68_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C1: A,B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B1))
          <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C1),D)) ) ) ) ).

tff(fact_69_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( aa(list(A),list(A),tl(A),nil(A)) = nil(A) ) ).

tff(fact_70_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X1: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Cs)))
             => ( X1 = zero_zero(A) ) )
         => ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Cs),Xsa) = zero_zero(A) ) ) ) ).

tff(fact_71_transfer__nat__int__set__cong,axiom,
    ! [P2: fun(int,bool),P1: fun(int,bool)] :
      ( ! [X1: int] :
          ( pp(aa(int,bool,ord_less_eq(int,zero_zero(int)),X1))
         => ( pp(aa(int,bool,P1,X1))
          <=> pp(aa(int,bool,P2,X1)) ) )
     => ( collect(int,aa(fun(int,bool),fun(int,bool),aa(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),combs(int,bool,bool),aa(fun(int,bool),fun(int,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj),ord_less_eq(int,zero_zero(int)))),P1)) = collect(int,aa(fun(int,bool),fun(int,bool),aa(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),combs(int,bool,bool),aa(fun(int,bool),fun(int,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj),ord_less_eq(int,zero_zero(int)))),P2)) ) ) ).

tff(fact_72_atom_Osize_I1_J,axiom,
    ! [List: list(int),Int: int] : ( atom_size(aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = zero_zero(nat) ) ).

tff(fact_73_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F: fun(B,A),Aa: A] :
          ( pp(aa(A,bool,ord_less_eq(A,Aa),aa(B,A,F,B1)))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),B1),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X1),Y1))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F,X1)),aa(B,A,F,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_77_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F: fun(B,A),Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F,B1)))
         => ( pp(aa(B,bool,ord_less_eq(B,B1),C1))
           => ( ! [X1: B,Y1: B] :
                  ( pp(aa(B,bool,ord_less_eq(B,X1),Y1))
                 => pp(aa(A,bool,ord_less_eq(A,aa(B,A,F,X1)),aa(B,A,F,Y1))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_78_order__le__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F: fun(A,B),B1: A,Aa: A] :
          ( pp(aa(A,bool,ord_less_eq(A,Aa),B1))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,B1)),C1))
           => ( ! [X1: A,Y1: A] :
                  ( pp(aa(A,bool,ord_less_eq(A,X1),Y1))
                 => pp(aa(B,bool,ord_less_eq(B,aa(A,B,F,X1)),aa(A,B,F,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,Aa)),C1)) ) ) ) ) ).

tff(fact_79_order__less__le__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F: fun(A,B),B1: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B1))
         => ( pp(aa(B,bool,ord_less_eq(B,aa(A,B,F,B1)),C1))
           => ( ! [X1: A,Y1: A] :
                  ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,X1)),aa(A,B,F,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,Aa)),C1)) ) ) ) ) ).

tff(fact_80_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( pp(aa(fun(A,B),bool,aa(fun(A,B),fun(fun(A,B),bool),ord_less(fun(A,B)),F),G))
        <=> ( pp(aa(fun(A,B),bool,ord_less_eq(fun(A,B),F),G))
            & ~ pp(aa(fun(A,B),bool,ord_less_eq(fun(A,B),G),F)) ) ) ) ).

tff(fact_81_atom_Osize_I4_J,axiom,
    ! [List: list(int),Int: int] : ( size_size(atom,aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = zero_zero(nat) ) ).

tff(fact_82_le0,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less_eq(nat,zero_zero(nat)),N)) ).

tff(fact_83_less__zeroE,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_84_diff__self__eq__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),M) = zero_zero(nat) ) ).

tff(fact_85_less__nat__zero__code,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_86_zero__less__diff,axiom,
    ! [M1: nat,Na: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),Na),M1)))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na)) ) ).

tff(fact_87_diff__0__eq__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_88_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),Na)) ) ).

tff(fact_89_diff__is__0__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M1),Na) = zero_zero(nat) )
    <=> pp(aa(nat,bool,ord_less_eq(nat,M1),Na)) ) ).

tff(fact_90_le__0__eq,axiom,
    ! [Na: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,Na),zero_zero(nat)))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_91_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less_eq(nat,zero_zero(nat)),N)) ).

tff(fact_92_le__refl,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less_eq(nat,N),N)) ).

tff(fact_93_diff__le__self,axiom,
    ! [N: nat,M: nat] : pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N)),M)) ).

tff(fact_94_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M),N))
      | pp(aa(nat,bool,ord_less_eq(nat,N),M)) ) ).

tff(fact_95_nat__less__le,axiom,
    ! [Na: nat,M1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
    <=> ( pp(aa(nat,bool,ord_less_eq(nat,M1),Na))
        & ( M1 != Na ) ) ) ).

tff(fact_96_le__eq__less__or__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M1),Na))
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
        | ( M1 = Na ) ) ) ).

tff(fact_97_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => pp(aa(nat,bool,ord_less_eq(nat,M),N)) ) ).

tff(fact_98_less__imp__le__nat,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => pp(aa(nat,bool,ord_less_eq(nat,M),N)) ) ).

%----Arities (20)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(int,bool,ord_less_eq(int,big_linorder_Min(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))))))),aa(fun(atom,bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(atom,bool),fun(int,bool))),fun(fun(atom,bool),fun(list(int),fun(int,bool))),combc(list(int),fun(atom,bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool))),aa(fun(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool)))),combb(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool)),list(int)),combc(int,fun(atom,bool),bool)),aa(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool))),aa(fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),fun(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool)))),combb(fun(int,atom),fun(int,fun(fun(atom,bool),bool)),list(int)),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),combb(atom,fun(fun(atom,bool),bool),int),member(atom))),aa(fun(int,fun(list(int),atom)),fun(list(int),fun(int,atom)),combc(int,list(int),atom),c_PresArith_Oatom_OLe)))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,aa(fun(int,bool),fun(int,fun(list(int),bool)),aa(fun(bool,fun(list(int),bool)),fun(fun(int,bool),fun(int,fun(list(int),bool))),combb(bool,fun(list(int),bool),int),combk(bool,list(int))),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))))))),aa(int,int,aa(int,fun(int,int),minus_minus(int),aa(list(int),int,aa(list(int),fun(list(int),int),iprod(int),ks),xs)),l))) ).

%------------------------------------------------------------------------------
