%------------------------------------------------------------------------------
% File     : COM069_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 154
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_154 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  194 (  38 unt;  60 typ;   0 def)
%            Number of atoms       :  276 ( 122 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  158 (  16   ~;   9   |;   2   &)
%                                         (  16 <=>; 115  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :   28 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   26 (  16   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-2 aty)
%            Number of functors    :   37 (  37 usr;   9 con; 0-4 aty)
%            Number of variables   :  406 ( 352   !;   0   ?; 406   :)
%                                         (  54  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:10
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (55)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Oring__div,type,
    ring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Olinorder__class_OMin,type,
    big_linorder_Min: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Divides_Odiv__class_Odiv,type,
    div_div: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: fun(int,fun(list(int),atom)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: fun(atom,int) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_n____,type,
    n: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (98)
tff(fact_0_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( aa(atom,int,divisor,X3) != zero_zero(int) ) ) ).

tff(fact_1_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( aa(atom,int,divisor,aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,I),Ks)) = one_one(int) ) ).

tff(fact_2_iprod__assoc,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A),Xsa: list(A),X1: A] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),map(A,A,times_times(A,X1),Xsa)),Ys1) = aa(A,A,times_times(A,X1),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xsa),Ys1)) ) ) ).

tff(fact_3_mod__div__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_div(A,div_mod(A,A1,B1),B1) = zero_zero(A) ) ) ).

tff(fact_4_mod__mult__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,aa(A,A,times_times(A,B1),C1)),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_5_mod__mult__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,aa(A,A,times_times(A,C1),B1)),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_6_mod__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,one_one(A)) = zero_zero(A) ) ) ).

tff(fact_7_div__mult__mult1__if,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A,C1: A] :
          ( ( ( C1 = zero_zero(A) )
           => ( div_div(A,aa(A,A,times_times(A,C1),A1),aa(A,A,times_times(A,C1),B1)) = zero_zero(A) ) )
          & ( ( C1 != zero_zero(A) )
           => ( div_div(A,aa(A,A,times_times(A,C1),A1),aa(A,A,times_times(A,C1),B1)) = div_div(A,A1,B1) ) ) ) ) ).

tff(fact_8_mod__mult__self2__is__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B1),B1) = zero_zero(A) ) ) ).

tff(fact_9_mod__mult__self1__is__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] : ( div_mod(A,aa(A,A,times_times(A,B1),A1),B1) = zero_zero(A) ) ) ).

tff(fact_10_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,Aa,Aa)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),Aa)) ) ) ).

tff(fact_11_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,Aa,Aa)),zero_zero(A)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),zero_zero(A))) ) ) ).

tff(fact_12_zmod__zmult2__eq,axiom,
    ! [B1: int,A1: int,C1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),C1))
     => ( div_mod(int,A1,aa(int,int,times_times(int,B1),C1)) = plus_plus(int,aa(int,int,times_times(int,B1),div_mod(int,div_div(int,A1,B1),C1)),div_mod(int,A1,B1)) ) ) ).

tff(fact_13_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,Aa: A,B2: A] :
          ( ( plus_plus(A,B2,Aa) = plus_plus(A,C2,Aa) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_14_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B2: A,Aa: A] :
          ( ( plus_plus(A,Aa,B2) = plus_plus(A,Aa,C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_15_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,div_mod(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_16_atom_Osimps_I1_J,axiom,
    ! [List1: list(int),Int1: int,List: list(int),Int: int] :
      ( ( aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List) = aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1) )
    <=> ( ( Int = Int1 )
        & ( List = List1 ) ) ) ).

tff(fact_17_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_18_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,Aa: A,C2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,C2,Aa)),plus_plus(A,C2,B2)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B2)) ) ) ).

tff(fact_19_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,C2: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,Aa,C2)),plus_plus(A,B2,C2)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B2)) ) ) ).

tff(fact_20_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),A1) = zero_zero(A) ) ) ).

tff(fact_21_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_22_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_23_div__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_div(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_24_div__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_div(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_25_mod__add__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] : ( div_mod(A,plus_plus(A,B1,A1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_26_mod__add__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_27_zmod__self,axiom,
    ! [A1: int] : ( div_mod(int,A1,A1) = zero_zero(int) ) ).

tff(fact_28_zmod__zero,axiom,
    ! [B1: int] : ( div_mod(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_29_zdiv__zero,axiom,
    ! [B1: int] : ( div_div(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_30_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_31_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,A1),B1)),C1) = aa(A,A,times_times(A,A1),aa(A,A,times_times(A,B1),C1)) ) ) ).

tff(fact_32_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C1,A1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_33_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_34_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_35_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C1) = plus_plus(A,A1,plus_plus(A,B1,C1)) ) ) ).

tff(fact_36_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_37_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C2: A,B2: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B2) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D) )
         => ( ( Aa = B2 )
          <=> ( C2 = D ) ) ) ) ).

tff(fact_38_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_39_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_40_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_41_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_42_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A1: A,C1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,C1,A1)),plus_plus(A,C1,B1)))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1)) ) ) ).

tff(fact_43_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,C1)),plus_plus(A,B1,C1)))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1)) ) ) ).

tff(fact_44_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D1: A,C1: A,B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C1),D1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,C1)),plus_plus(A,B1,D1))) ) ) ) ).

tff(fact_45_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,C1,A1)),plus_plus(A,C1,B1))) ) ) ).

tff(fact_46_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,C1)),plus_plus(A,B1,C1))) ) ) ).

tff(fact_47_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B2) = zero_zero(A) )
        <=> ( Aa = B2 ) ) ) ).

tff(fact_48_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,Aa: A] :
          ( ( Aa = B2 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B2) = zero_zero(A) ) ) ) ).

tff(fact_49_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_50_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C2: A,B2: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B2) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D) )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B2))
          <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C2),D)) ) ) ) ).

tff(fact_51_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_52_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_53_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_54_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_55_add__diff__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),plus_plus(A,A1,B1)),B1) = A1 ) ) ).

tff(fact_56_diff__add__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] : ( plus_plus(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1),B1) = A1 ) ) ).

tff(fact_57_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_58_mod__mult__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,B1: A,A3: A,C1: A,A1: A] :
          ( ( div_mod(A,A1,C1) = div_mod(A,A3,C1) )
         => ( ( div_mod(A,B1,C1) = div_mod(A,B3,C1) )
           => ( div_mod(A,aa(A,A,times_times(A,A1),B1),C1) = div_mod(A,aa(A,A,times_times(A,A3),B3),C1) ) ) ) ) ).

tff(fact_59_zmod__simps_I4_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C1)),B1),C1) = div_mod(A,aa(A,A,times_times(A,A1),B1),C1) ) ) ).

tff(fact_60_mod__mult__mult2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),C1),aa(A,A,times_times(A,B1),C1)) = aa(A,A,times_times(A,div_mod(A,A1,B1)),C1) ) ) ).

tff(fact_61_mod__mult__mult1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A,C1: A] : ( div_mod(A,aa(A,A,times_times(A,C1),A1),aa(A,A,times_times(A,C1),B1)) = aa(A,A,times_times(A,C1),div_mod(A,A1,B1)) ) ) ).

tff(fact_62_mod__mult__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B1),C1) = div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C1)),div_mod(A,B1,C1)),C1) ) ) ).

tff(fact_63_mod__mult__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B1),C1) = div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C1)),B1),C1) ) ) ).

tff(fact_64_mod__mult__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B1),C1) = div_mod(A,aa(A,A,times_times(A,A1),div_mod(A,B1,C1)),C1) ) ) ).

tff(fact_65_mod__add__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,B1: A,A3: A,C1: A,A1: A] :
          ( ( div_mod(A,A1,C1) = div_mod(A,A3,C1) )
         => ( ( div_mod(A,B1,C1) = div_mod(A,B3,C1) )
           => ( div_mod(A,plus_plus(A,A1,B1),C1) = div_mod(A,plus_plus(A,A3,B3),C1) ) ) ) ) ).

tff(fact_66_zmod__simps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C1: A,A1: A] : ( div_mod(A,plus_plus(A,div_mod(A,A1,C1),B1),C1) = div_mod(A,plus_plus(A,A1,B1),C1) ) ) ).

tff(fact_67_zmod__simps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,div_mod(A,B1,C1)),C1) = div_mod(A,plus_plus(A,A1,B1),C1) ) ) ).

tff(fact_68_mod__add__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),C1) = div_mod(A,plus_plus(A,div_mod(A,A1,C1),div_mod(A,B1,C1)),C1) ) ) ).

tff(fact_69_mod__add__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),C1) = div_mod(A,plus_plus(A,div_mod(A,A1,C1),B1),C1) ) ) ).

tff(fact_70_mod__add__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),C1) = div_mod(A,plus_plus(A,A1,div_mod(A,B1,C1)),C1) ) ) ).

tff(fact_71_mod__diff__cong,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [B3: A,B1: A,A3: A,C1: A,A1: A] :
          ( ( div_mod(A,A1,C1) = div_mod(A,A3,C1) )
         => ( ( div_mod(A,B1,C1) = div_mod(A,B3,C1) )
           => ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B3),C1) ) ) ) ) ).

tff(fact_72_mod__diff__eq,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),div_mod(A,A1,C1)),div_mod(A,B1,C1)),C1) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A2))
    <=> pp(aa(A,bool,A2,X1)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_mod__diff__left__eq,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),div_mod(A,A1,C1)),B1),C1) ) ) ).

tff(fact_77_mod__diff__right__eq,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [C1: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),div_mod(A,B1,C1)),C1) ) ) ).

tff(fact_78_div__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_div(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_79_zmod__simps_I3_J,axiom,
    ! [C1: int,B1: int,A1: int] : ( div_mod(int,aa(int,int,times_times(int,A1),div_mod(int,B1,C1)),C1) = div_mod(int,aa(int,int,times_times(int,A1),B1),C1) ) ).

tff(fact_80_zmod__zmult1__eq,axiom,
    ! [C1: int,B1: int,A1: int] : ( div_mod(int,aa(int,int,times_times(int,A1),B1),C1) = div_mod(int,aa(int,int,times_times(int,A1),div_mod(int,B1,C1)),C1) ) ).

tff(fact_81_zdiff__zmod__left,axiom,
    ! [Y: int,M: int,X: int] : ( div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),div_mod(int,X,M)),Y),M) = div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),X),Y),M) ) ).

tff(fact_82_zdiff__zmod__right,axiom,
    ! [M: int,Y: int,X: int] : ( div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),X),div_mod(int,Y,M)),M) = div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),X),Y),M) ) ).

tff(fact_83_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),plus_plus(list(A),Xs,Ys)),Zs) = plus_plus(A,aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_84_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_85_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_86_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),zero_zero(A)))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B1),zero_zero(A)))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,B1)),zero_zero(A))) ) ) ) ).

tff(fact_87_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A1))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),B1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,A1,B1))) ) ) ) ).

tff(fact_88_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B2: A,Aa: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Aa),B2))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),Aa),B2)),zero_zero(A))) ) ) ).

tff(fact_89_div__mult__mult1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A,C1: A] :
          ( ( C1 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,C1),A1),aa(A,A,times_times(A,C1),B1)) = div_div(A,A1,B1) ) ) ) ).

tff(fact_90_div__mult__mult2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A,C1: A] :
          ( ( C1 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,A1),C1),aa(A,A,times_times(A,B1),C1)) = div_div(A,A1,B1) ) ) ) ).

tff(fact_91_div__mult__self1__is__id,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] :
          ( ( B1 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,B1),A1),B1) = A1 ) ) ) ).

tff(fact_92_div__mult__self2__is__id,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] :
          ( ( B1 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,A1),B1),B1) = A1 ) ) ) ).

tff(fact_93_div__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( div_div(A,A1,A1) = one_one(A) ) ) ) ).

tff(fact_94_scale1,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [Xsa: list(A)] : ( map(A,A,times_times(A,one_one(A)),Xsa) = Xsa ) ) ).

tff(fact_95_neg__mod__bound,axiom,
    ! [A1: int,B1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),B1),zero_zero(int)))
     => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),B1),div_mod(int,A1,B1))) ) ).

tff(fact_96_pos__mod__bound,axiom,
    ! [A1: int,B1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),B1))
     => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_mod(int,A1,B1)),B1)) ) ).

tff(fact_97_div__neg__pos__less0,axiom,
    ! [B1: int,A1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),A1),zero_zero(int)))
     => ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),B1))
       => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_div(int,A1,B1)),zero_zero(int))) ) ) ).

%----Arities (19)
tff(arity_Int_Oint___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(int) ).

tff(arity_Int_Oint___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Divides_Oring__div,axiom,
    ring_div(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

%----Helper facts (16)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),n),aa(int,int,times_times(int,plus_plus(int,div_div(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),n),big_linorder_Min(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))))))),aa(fun(atom,bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(atom,bool),fun(int,bool))),fun(fun(atom,bool),fun(list(int),fun(int,bool))),combc(list(int),fun(atom,bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool))),aa(fun(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool)))),combb(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool)),list(int)),combc(int,fun(atom,bool),bool)),aa(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool))),aa(fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),fun(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool)))),combb(fun(int,atom),fun(int,fun(fun(atom,bool),bool)),list(int)),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),combb(atom,fun(fun(atom,bool),bool),int),member(atom))),aa(fun(int,fun(list(int),atom)),fun(list(int),fun(int,atom)),combc(int,list(int),atom),c_PresArith_Oatom_OLe)))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,aa(fun(int,bool),fun(int,fun(list(int),bool)),aa(fun(bool,fun(list(int),bool)),fun(fun(int,bool),fun(int,fun(list(int),bool))),combb(bool,fun(list(int),bool),int),combk(bool,list(int))),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))))))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as)))),one_one(int))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as))))),aa(atom,int,divisor,a)) = div_mod(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),div_mod(int,n,aa(atom,int,divisor,a))),div_mod(int,aa(int,int,times_times(int,plus_plus(int,div_div(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),n),big_linorder_Min(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))))))),aa(fun(atom,bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(atom,bool),fun(int,bool))),fun(fun(atom,bool),fun(list(int),fun(int,bool))),combc(list(int),fun(atom,bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool))),aa(fun(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool)))),combb(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool)),list(int)),combc(int,fun(atom,bool),bool)),aa(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool))),aa(fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),fun(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool)))),combb(fun(int,atom),fun(int,fun(fun(atom,bool),bool)),list(int)),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),combb(atom,fun(fun(atom,bool),bool),int),member(atom))),aa(fun(int,fun(list(int),atom)),fun(list(int),fun(int,atom)),combc(int,list(int),atom),c_PresArith_Oatom_OLe)))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,aa(fun(int,bool),fun(int,fun(list(int),bool)),aa(fun(bool,fun(list(int),bool)),fun(fun(int,bool),fun(int,fun(list(int),bool))),combb(bool,fun(list(int),bool),int),combk(bool,list(int))),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))))))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as)))),one_one(int))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as)))),aa(atom,int,divisor,a))),aa(atom,int,divisor,a)) ).

%------------------------------------------------------------------------------
