%------------------------------------------------------------------------------
% File     : COM067_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 147
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_147 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  213 (  48 unt;  69 typ;   0 def)
%            Number of atoms       :  304 ( 125 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  184 (  24   ~;  11   |;   9   &)
%                                         (  28 <=>; 112  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   5 avg)
%            Maximal term depth    :   28 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   31 (  19   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :   27 (  26 usr;   0 prp; 1-5 aty)
%            Number of functors    :   40 (  40 usr;   9 con; 0-4 aty)
%            Number of variables   :  418 ( 356   !;   0   ?; 418   :)
%                                         (  62  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:49
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (63)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oordered__ring,type,
    ordered_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Olinorder__class_OMin,type,
    big_linorder_Min: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Divides_Odiv__class_Odiv,type,
    div_div: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: fun(int,fun(list(int),atom)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: fun(atom,int) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_n____,type,
    n: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (98)
tff(fact_0_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( aa(atom,int,divisor,X4) != zero_zero(int) ) ) ).

tff(fact_1__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

tff(fact_2_iprod__Cons,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A),Y: A,Xs: list(A),X1: A] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),cons(A,X1,Xs)),cons(A,Y,Ys)) = plus_plus(A,aa(A,A,times_times(A,X1),Y),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Ys)) ) ) ).

tff(fact_3_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( aa(atom,int,divisor,aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,I),Ks)) = one_one(int) ) ).

tff(fact_4_iprod__assoc,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A),Xsa: list(A),X2: A] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),map(A,A,times_times(A,X2),Xsa)),Ys1) = aa(A,A,times_times(A,X2),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xsa),Ys1)) ) ) ).

tff(fact_5_div__mult__mult1__if,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( C2 = zero_zero(A) )
           => ( div_div(A,aa(A,A,times_times(A,C2),A2),aa(A,A,times_times(A,C2),B2)) = zero_zero(A) ) )
          & ( ( C2 != zero_zero(A) )
           => ( div_div(A,aa(A,A,times_times(A,C2),A2),aa(A,A,times_times(A,C2),B2)) = div_div(A,A2,B2) ) ) ) ) ).

tff(fact_6_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,A1,A1)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A1)) ) ) ).

tff(fact_7_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,A1)),zero_zero(A)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),zero_zero(A))) ) ) ).

tff(fact_8_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),set(A,Xsa)))),P1)) ) ).

tff(fact_9_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,X2))
       => ( filter(A,P1,cons(A,X2,Xsa)) = cons(A,X2,filter(A,P1,Xsa)) ) )
      & ( ~ pp(aa(A,bool,P1,X2))
       => ( filter(A,P1,cons(A,X2,Xsa)) = filter(A,P1,Xsa) ) ) ) ).

tff(fact_10_zdiv__zero,axiom,
    ! [B2: int] : ( div_div(int,zero_zero(int),B2) = zero_zero(int) ) ).

tff(fact_11_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),set(B,Xsa)))
         => ( aa(B,A,F,X3) = aa(B,A,G,X3) ) ) ) ).

tff(fact_12_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),X2: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X2,Xsa)) = cons(A,aa(B,A,F,X2),map(B,A,F,Xsa)) ) ).

tff(fact_13_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C1,A1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_14_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_15_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A4: A,List: list(A),A1: A] :
      ( ( cons(A,A1,List) = cons(A,A4,List1) )
    <=> ( ( A1 = A4 )
        & ( List = List1 ) ) ) ).

tff(fact_16_atom_Osimps_I1_J,axiom,
    ! [List1: list(int),Int1: int,List: list(int),Int: int] :
      ( ( aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List) = aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1) )
    <=> ( ( Int = Int1 )
        & ( List = List1 ) ) ) ).

tff(fact_17_map__ident,axiom,
    ! [A: $tType,X4: list(A)] : ( map(A,A,combi(A),X4) = X4 ) ).

tff(fact_18_filter__filter,axiom,
    ! [A: $tType,Xsa: list(A),Q1: fun(A,bool),P1: fun(A,bool)] : ( filter(A,P1,filter(A,Q1,Xsa)) = filter(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),Q1)),P1),Xsa) ) ).

tff(fact_19_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = plus_plus(A,A1,A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_20_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A1: A,C1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,C1,A1)),plus_plus(A,C1,B1)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1)) ) ) ).

tff(fact_21_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A1,C1)),plus_plus(A,B1,C1)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1)) ) ) ).

tff(fact_22_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),A2) = zero_zero(A) ) ) ).

tff(fact_23_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X1: A] : ( plus_plus(list(A),cons(A,X1,Xs),cons(A,Y,Ys)) = cons(A,plus_plus(A,X1,Y),plus_plus(list(A),Xs,Ys)) ) ) ).

tff(fact_24_div__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_div(A,A2,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_25_div__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_div(A,zero_zero(A),A2) = zero_zero(A) ) ) ).

tff(fact_26_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X1: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),cons(A,X1,Xs)),cons(A,Y,Ys)) = cons(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),X1),Y),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)) ) ) ).

tff(fact_27_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_28_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_29_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C2: A,B2: A,A2: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,A2),B2)),C2) = aa(A,A,times_times(A,A2),aa(A,A,times_times(A,B2),C2)) ) ) ).

tff(fact_30_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A2: A,B2: A] :
          ( ( plus_plus(A,B2,A2) = plus_plus(A,C2,A2) )
         => ( B2 = C2 ) ) ) ).

tff(fact_31_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C2) )
         => ( B2 = C2 ) ) ) ).

tff(fact_32_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C2) )
         => ( B2 = C2 ) ) ) ).

tff(fact_33_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C2: A,B2: A,A2: A] : ( plus_plus(A,plus_plus(A,A2,B2),C2) = plus_plus(A,A2,plus_plus(A,B2,C2)) ) ) ).

tff(fact_34_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X2: A] :
          ( ( one_one(A) = X2 )
        <=> ( X2 = one_one(A) ) ) ) ).

tff(fact_35_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( ( A1 = B1 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_36_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( cons(A,X1,Xs) != Xs ) ).

tff(fact_37_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] : ( Xs != cons(A,X1,Xs) ) ).

tff(fact_38_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_39_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_40_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,zero_zero(A),A2) = A2 ) ) ).

tff(fact_41_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( plus_plus(A,zero_zero(A),A2) = A2 ) ) ).

tff(fact_42_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,A2: A,C2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,C2,A2)),plus_plus(A,C2,B2)))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2)) ) ) ).

tff(fact_43_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,C2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A2,C2)),plus_plus(A,B2,C2)))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2)) ) ) ).

tff(fact_44_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D1: A,C2: A,B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C2),D1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A2,C2)),plus_plus(A,B2,D1))) ) ) ) ).

tff(fact_45_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C2: A,B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,C2,A2)),plus_plus(A,C2,B2))) ) ) ).

tff(fact_46_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C2: A,B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A2,C2)),plus_plus(A,B2,C2))) ) ) ).

tff(fact_47_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = zero_zero(A) )
        <=> ( A1 = B1 ) ) ) ).

tff(fact_48_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( A1 = B1 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = zero_zero(A) ) ) ) ).

tff(fact_49_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_50_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C1: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
          <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C1),D)) ) ) ) ).

tff(fact_51_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A2: A] : ( aa(A,A,times_times(A,A2),one_one(A)) = A2 ) ) ).

tff(fact_52_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( aa(A,A,times_times(A,A2),one_one(A)) = A2 ) ) ).

tff(fact_53_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A2: A] : ( aa(A,A,times_times(A,one_one(A)),A2) = A2 ) ) ).

tff(fact_54_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( aa(A,A,times_times(A,one_one(A)),A2) = A2 ) ) ).

tff(fact_55_add__diff__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),plus_plus(A,A2,B2)),B2) = A2 ) ) ).

tff(fact_56_diff__add__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A2: A] : ( plus_plus(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2),B2) = A2 ) ) ).

tff(fact_57_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,cons(A,X2,Xsa))))
     => ( ( Y1 = X2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa))) ) ) ).

tff(fact_58_div__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_div(A,A2,one_one(A)) = A2 ) ) ).

tff(fact_59_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
         => pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_60_tl_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( aa(list(A),list(A),tl(A),cons(A,X1,Xs)) = Xs ) ).

tff(fact_61_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),plus_plus(list(A),Xs,Ys)),Zs) = plus_plus(A,aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_62_map__tl,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] : ( map(B,A,F,aa(list(B),list(B),tl(B),Xsa)) = aa(list(A),list(A),tl(A),map(B,A,F,Xsa)) ) ).

tff(fact_63_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_64_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A1: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),cons(B,A1,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A1),List) ) ).

tff(fact_65_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_66_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),zero_zero(A)))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),zero_zero(A)))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,A2,B2)),zero_zero(A))) ) ) ) ).

tff(fact_67_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A2))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),B2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),plus_plus(A,A2,B2))) ) ) ) ).

tff(fact_68_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1)),zero_zero(A))) ) ) ).

tff(fact_69_div__mult__mult1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,A2: A,C2: A] :
          ( ( C2 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,C2),A2),aa(A,A,times_times(A,C2),B2)) = div_div(A,A2,B2) ) ) ) ).

tff(fact_70_div__mult__mult2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,A2: A,C2: A] :
          ( ( C2 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,A2),C2),aa(A,A,times_times(A,B2),C2)) = div_div(A,A2,B2) ) ) ) ).

tff(fact_71_div__mult__self1__is__id,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A,B2: A] :
          ( ( B2 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,B2),A2),B2) = A2 ) ) ) ).

tff(fact_72_div__mult__self2__is__id,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A,B2: A] :
          ( ( B2 != zero_zero(A) )
         => ( div_div(A,aa(A,A,times_times(A,A2),B2),B2) = A2 ) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A3))
    <=> pp(aa(A,bool,A3,X2)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_div__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] :
          ( ( A2 != zero_zero(A) )
         => ( div_div(A,A2,A2) = one_one(A) ) ) ) ).

tff(fact_77_scale1,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [Xsa: list(A)] : ( map(A,A,times_times(A,one_one(A)),Xsa) = Xsa ) ) ).

tff(fact_78_div__neg__pos__less0,axiom,
    ! [B2: int,A2: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),A2),zero_zero(int)))
     => ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),B2))
       => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_div(int,A2,B2)),zero_zero(int))) ) ) ).

tff(fact_79_neg__imp__zdiv__neg__iff,axiom,
    ! [A1: int,B1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),B1),zero_zero(int)))
     => ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_div(int,A1,B1)),zero_zero(int)))
      <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),A1)) ) ) ).

tff(fact_80_pos__imp__zdiv__neg__iff,axiom,
    ! [A1: int,B1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),B1))
     => ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_div(int,A1,B1)),zero_zero(int)))
      <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),A1),zero_zero(int))) ) ) ).

tff(fact_81_zdiv__self,axiom,
    ! [A2: int] :
      ( ( A2 != zero_zero(int) )
     => ( div_div(int,A2,A2) = one_one(int) ) ) ).

tff(fact_82_div__mult__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C2: A,A2: A,B2: A] :
          ( ( B2 != zero_zero(A) )
         => ( div_div(A,plus_plus(A,A2,aa(A,A,times_times(A,C2),B2)),B2) = plus_plus(A,C2,div_div(A,A2,B2)) ) ) ) ).

tff(fact_83_div__mult__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C2: A,A2: A,B2: A] :
          ( ( B2 != zero_zero(A) )
         => ( div_div(A,plus_plus(A,A2,aa(A,A,times_times(A,B2),C2)),B2) = plus_plus(A,C2,div_div(A,A2,B2)) ) ) ) ).

tff(fact_84_div__add__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A,B2: A] :
          ( ( B2 != zero_zero(A) )
         => ( div_div(A,plus_plus(A,B2,A2),B2) = plus_plus(A,div_div(A,A2,B2),one_one(A)) ) ) ) ).

tff(fact_85_div__add__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A,B2: A] :
          ( ( B2 != zero_zero(A) )
         => ( div_div(A,plus_plus(A,A2,B2),B2) = plus_plus(A,div_div(A,A2,B2),one_one(A)) ) ) ) ).

tff(fact_86_int__div__less__self,axiom,
    ! [K: int,X1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),X1))
     => ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),one_one(int)),K))
       => pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),div_div(int,X1,K)),X1)) ) ) ).

tff(fact_87_zdiv__zmult2__eq,axiom,
    ! [B2: int,A2: int,C2: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),C2))
     => ( div_div(int,A2,aa(int,int,times_times(int,B2),C2)) = div_div(int,div_div(int,A2,B2),C2) ) ) ).

tff(fact_88_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( plus_plus(A,A1,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_89_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B1: A,A1: A] :
          ( ( aa(A,A,times_times(A,A1),B1) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

tff(fact_90_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A2: A] : ( aa(A,A,times_times(A,A2),zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_91_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A2: A] : ( aa(A,A,times_times(A,zero_zero(A)),A2) = zero_zero(A) ) ) ).

tff(fact_92_pos__zmult__eq__1__iff,axiom,
    ! [Na: int,M: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),M))
     => ( ( aa(int,int,times_times(int,M),Na) = one_one(int) )
      <=> ( ( M = one_one(int) )
          & ( Na = one_one(int) ) ) ) ) ).

tff(fact_93_odd__less__0__iff,axiom,
    ! [Z: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),plus_plus(int,plus_plus(int,one_one(int),Z),Z)),zero_zero(int)))
    <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),Z),zero_zero(int))) ) ).

tff(fact_94_square__diff__one__factored,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [X1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(A,A,times_times(A,X1),X1)),one_one(A)) = aa(A,A,times_times(A,plus_plus(A,X1,one_one(A))),aa(A,A,aa(A,fun(A,A),minus_minus(A),X1),one_one(A))) ) ) ).

tff(fact_95_less__add__iff1,axiom,
    ! [A: $tType] :
      ( ordered_ring(A)
     => ! [D: A,B1: A,C1: A,E: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,aa(A,A,times_times(A,A1),E),C1)),plus_plus(A,aa(A,A,times_times(A,B1),E),D)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1)),E),C1)),D)) ) ) ).

tff(fact_96_less__add__iff2,axiom,
    ! [A: $tType] :
      ( ordered_ring(A)
     => ! [D: A,B1: A,C1: A,E: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),plus_plus(A,aa(A,A,times_times(A,A1),E),C1)),plus_plus(A,aa(A,A,times_times(A,B1),E),D)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C1),plus_plus(A,aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),B1),A1)),E),D))) ) ) ).

tff(fact_97_list__add__assoc,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( plus_plus(list(A),plus_plus(list(A),Xs,Ys),Zs) = plus_plus(list(A),Xs,plus_plus(list(A),Ys,Zs)) ) ) ).

%----Arities (28)
tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(int) ).

tff(arity_Int_Oint___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Rings_Oordered__ring,axiom,
    ordered_ring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (17)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X1: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X1))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y))
      | ( X1 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ( X1 != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [X: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))))))))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,X),cons(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),n),aa(int,int,times_times(int,plus_plus(int,div_div(int,aa(int,int,aa(int,fun(int,int),minus_minus(int),n),big_linorder_Min(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))))))),aa(fun(atom,bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(atom,bool),fun(int,bool))),fun(fun(atom,bool),fun(list(int),fun(int,bool))),combc(list(int),fun(atom,bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool))),aa(fun(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool)))),combb(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool)),list(int)),combc(int,fun(atom,bool),bool)),aa(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool))),aa(fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),fun(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool)))),combb(fun(int,atom),fun(int,fun(fun(atom,bool),bool)),list(int)),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),combb(atom,fun(fun(atom,bool),bool),int),member(atom))),aa(fun(int,fun(list(int),atom)),fun(list(int),fun(int,atom)),combc(int,list(int),atom),c_PresArith_Oatom_OLe)))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,aa(fun(int,bool),fun(int,fun(list(int),bool)),aa(fun(bool,fun(list(int),bool)),fun(fun(int,bool),fun(int,fun(list(int),bool))),combb(bool,fun(list(int),bool),int),combk(bool,list(int))),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))))))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as)))),one_one(int))),zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as))))),xs))) ) ).

%------------------------------------------------------------------------------
