%------------------------------------------------------------------------------
% File     : COM066_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 143
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_143 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  186 (  59 unt;  50 typ;   0 def)
%            Number of atoms       :  255 ( 101 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  168 (  49   ~;  16   |;  10   &)
%                                         (  23 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :   19 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   23 (  16   >;   7   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-2 aty)
%            Number of functors    :   37 (  37 usr;   7 con; 0-4 aty)
%            Number of variables   :  371 ( 324   !;   4   ?; 371   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:42
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(list(A),fun(list(B),list(C))) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) ) > fun(list(A),T1) ) ).

tff(sy_c_List_Olistset,type,
    listset: 
      !>[A: $tType] : ( list(fun(A,bool)) > fun(list(A),bool) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Oset__Cons,type,
    set_Cons: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(list(A),bool) ) > fun(list(A),bool) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: fun(int,fun(list(int),atom)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) ) > fun(atom,T1) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X2),set(atom,as)))
     => ( divisor(X2) != zero_zero(int) ) ) ).

tff(fact_1_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A6: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A6),A6) = zero_zero(A) ) ) ).

tff(fact_2__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_3_less__bin__lemma,axiom,
    ! [L1: int,Ka: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),Ka),L1))
    <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),aa(int,int,aa(int,fun(int,int),minus_minus(int),Ka),L1)),zero_zero(int))) ) ).

tff(fact_4_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int2: int,List1: list(int),Int1: int] :
      ( ( aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1) = aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int2),List3) )
    <=> ( ( Int1 = Int2 )
        & ( List1 = List3 ) ) ) ).

tff(fact_5_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B3: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B3))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B3)),zero_zero(A))) ) ) ).

tff(fact_6_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List1: list(int),Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List1)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int1),List1) ) ).

tff(fact_7_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X4: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_8_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X4: A] : ~ pp(aa(A,bool,P1,X4)) ) ).

tff(fact_9_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_10_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X4: A] : ~ pp(aa(A,bool,P1,X4)) ) ).

tff(fact_11_emptyE,axiom,
    ! [A: $tType,A3: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),bot_bot(fun(A,bool)))) ).

tff(fact_12_Diff__cancel,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),A1) = bot_bot(fun(A,bool)) ) ).

tff(fact_13_empty__Diff,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),bot_bot(fun(A,bool))),A1) = bot_bot(fun(A,bool)) ) ).

tff(fact_14_Diff__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),bot_bot(fun(A,bool))) = A1 ) ).

tff(fact_15_not__psubset__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ~ pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),bot_bot(fun(A,bool)))) ).

tff(fact_16_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_17_equals0D,axiom,
    ! [A: $tType,A3: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1)) ) ).

tff(fact_18_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_19_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_20_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B3: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B3) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( ( A3 = B3 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_21_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B3: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B3) = zero_zero(A) )
        <=> ( A3 = B3 ) ) ) ).

tff(fact_22_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B3: A,A3: A] :
          ( ( A3 = B3 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B3) = zero_zero(A) ) ) ) ).

tff(fact_23_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A6: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A6),zero_zero(A)) = A6 ) ) ).

tff(fact_24_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C1: A,B3: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B3) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B3))
          <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C1),D)) ) ) ) ).

tff(fact_25_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),nil(A)) = zero_zero(A) ) ) ).

tff(fact_26_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys2: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),nil(A)),Ys2) = zero_zero(A) ) ) ).

tff(fact_27_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_28_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_29_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_30_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( aa(list(A),list(A),tl(A),nil(A)) = nil(A) ) ).

tff(fact_31_atom_Osize_I1_J,axiom,
    ! [List4: list(int),Int: int] : ( atom_size(aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List4)) = zero_zero(nat) ) ).

tff(fact_32_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_33_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys2: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys2)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys2),Zs)) ) ) ).

tff(fact_34_Diff__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
        & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_35_Diff__idemp,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)),B1) = aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1) ) ).

tff(fact_36_DiffI,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1))) ) ) ).

tff(fact_37_DiffE,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
     => ~ ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_38_set__diff__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),A1))),aa(fun(A,bool),fun(A,bool),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),B1)))) ) ).

tff(fact_39_psubsetD,axiom,
    ! [A: $tType,C1: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B1))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_40_psubset__trans,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B1))
     => ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),B1),C2))
       => pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),C2)) ) ) ).

tff(fact_41_DiffD1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1)) ) ).

tff(fact_42_DiffD2,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ).

tff(fact_43_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),nil(A)) = Xs ) ) ).

tff(fact_44_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys2: list(A),Y: A,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys2)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),X),Y)),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys2)) ) ) ).

tff(fact_45_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X3: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Cs)))
             => ( X3 = zero_zero(A) ) )
         => ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Cs),Xsa) = zero_zero(A) ) ) ) ).

tff(fact_46_atom_Osize_I4_J,axiom,
    ! [List4: list(int),Int: int] : ( size_size(atom,aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List4)) = zero_zero(nat) ) ).

tff(fact_47_psubset__imp__ex__mem,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B1))
     => ? [B2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),B1),A1))) ) ).

tff(fact_48_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),Na)) ) ).

tff(fact_49_diff__self__eq__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),M) = zero_zero(nat) ) ).

tff(fact_50_diff__0__eq__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_51_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List1: list(A),A3: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List3) )
    <=> ( ( A3 = A5 )
        & ( List1 = List3 ) ) ) ).

tff(fact_52_less__zeroE,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_53_less__nat__zero__code,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_54_zero__less__diff,axiom,
    ! [M1: nat,Na: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),Na),M1)))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na)) ) ).

tff(fact_55_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_56_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1)) ) ) ).

tff(fact_57_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_58_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_59_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M))
     => ( M != N ) ) ).

tff(fact_60_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S),T))
     => ( S != T ) ) ).

tff(fact_61_less__imp__diff__less,axiom,
    ! [N: nat,K: nat,J: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),J),K))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),J),N)),K)) ) ).

tff(fact_62_diff__less__mono2,axiom,
    ! [L: nat,N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),L))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),N)),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),M))) ) ) ).

tff(fact_63_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_64_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) ) ).

tff(fact_65_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) != Xs ) ).

tff(fact_66_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N)) ) ).

tff(fact_67_diffs0__imp__equal,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N) = zero_zero(nat) )
     => ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),N),M) = zero_zero(nat) )
       => ( M = N ) ) ) ).

tff(fact_68_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( N != zero_zero(nat) ) ) ).

tff(fact_69_diff__less,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N))
     => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),M))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N)),M)) ) ) ).

tff(fact_70_minus__nat_Odiff__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_71_not__less0,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_72_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X1: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xsa))))
     => ( ( Y1 = X1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa))) ) ) ).

tff(fact_73_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List2) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List2) != nil(A) ) ).

tff(fact_78_tl_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( aa(list(A),list(A),tl(A),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs)) = Xs ) ).

tff(fact_79_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A3: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A3),List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A3),List1) ) ).

tff(fact_80_set__Cons__def,axiom,
    ! [A: $tType,XS: fun(list(A),bool),A1: fun(A,bool)] : ( set_Cons(A,A1,XS) = collect(list(A),aa(fun(list(A),fun(A,bool)),fun(list(A),bool),aa(fun(fun(A,bool),bool),fun(fun(list(A),fun(A,bool)),fun(list(A),bool)),combb(fun(A,bool),bool,list(A)),fEx(A)),aa(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,bool)),aa(fun(fun(A,fun(list(A),bool)),fun(A,bool)),fun(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,bool))),combb(fun(A,fun(list(A),bool)),fun(A,bool),list(A)),aa(fun(fun(list(A),bool),bool),fun(fun(A,fun(list(A),bool)),fun(A,bool)),combb(fun(list(A),bool),bool,A),fEx(list(A)))),aa(fun(A,fun(list(A),bool)),fun(list(A),fun(A,fun(list(A),bool))),aa(fun(list(A),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool)))),fun(fun(A,fun(list(A),bool)),fun(list(A),fun(A,fun(list(A),bool)))),combc(list(A),fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool))),aa(fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),fun(list(A),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool)))),aa(fun(fun(A,fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool)))),fun(fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),fun(list(A),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool))))),combb(fun(A,fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool))),list(A)),combs(A,fun(list(A),bool),fun(list(A),bool))),aa(fun(list(A),fun(A,fun(list(A),fun(bool,bool)))),fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),aa(fun(fun(A,fun(list(A),fun(bool,bool))),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),fun(fun(list(A),fun(A,fun(list(A),fun(bool,bool)))),fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool))))),combb(fun(A,fun(list(A),fun(bool,bool))),fun(A,fun(fun(list(A),bool),fun(list(A),bool))),list(A)),aa(fun(fun(list(A),fun(bool,bool)),fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(list(A),fun(bool,bool))),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),combb(fun(list(A),fun(bool,bool)),fun(fun(list(A),bool),fun(list(A),bool)),A),combs(list(A),bool,bool))),aa(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,fun(list(A),fun(bool,bool)))),aa(fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),fun(bool,bool)))),fun(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,fun(list(A),fun(bool,bool))))),combb(fun(A,fun(list(A),bool)),fun(A,fun(list(A),fun(bool,bool))),list(A)),aa(fun(fun(list(A),bool),fun(list(A),fun(bool,bool))),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),fun(bool,bool)))),combb(fun(list(A),bool),fun(list(A),fun(bool,bool)),A),aa(fun(bool,fun(bool,bool)),fun(fun(list(A),bool),fun(list(A),fun(bool,bool))),combb(bool,fun(bool,bool),list(A)),fconj))),aa(fun(A,fun(list(A),list(A))),fun(list(A),fun(A,fun(list(A),bool))),aa(fun(list(A),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool)))),fun(fun(A,fun(list(A),list(A))),fun(list(A),fun(A,fun(list(A),bool)))),combc(list(A),fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool))),aa(fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool))),fun(list(A),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool)))),aa(fun(fun(fun(list(A),list(A)),fun(list(A),bool)),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool)))),fun(fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool))),fun(list(A),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool))))),combb(fun(fun(list(A),list(A)),fun(list(A),bool)),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool))),list(A)),combb(fun(list(A),list(A)),fun(list(A),bool),A)),aa(fun(list(A),fun(list(A),bool)),fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool))),aa(fun(fun(list(A),bool),fun(fun(list(A),list(A)),fun(list(A),bool))),fun(fun(list(A),fun(list(A),bool)),fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool)))),combb(fun(list(A),bool),fun(fun(list(A),list(A)),fun(list(A),bool)),list(A)),combb(list(A),bool,list(A))),fequal(list(A))))),cons(A)))))),aa(fun(list(A),bool),fun(A,fun(list(A),bool)),aa(fun(A,fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(list(A),bool),fun(A,fun(list(A),bool))),combc(A,fun(list(A),bool),fun(list(A),bool)),aa(fun(A,fun(bool,bool)),fun(A,fun(fun(list(A),bool),fun(list(A),bool))),aa(fun(fun(bool,bool),fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(bool,bool)),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),combb(fun(bool,bool),fun(fun(list(A),bool),fun(list(A),bool)),A),combb(bool,bool,list(A))),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),A1)))),aa(fun(list(A),bool),fun(list(A),bool),aa(fun(list(A),fun(fun(list(A),bool),bool)),fun(fun(list(A),bool),fun(list(A),bool)),combc(list(A),fun(list(A),bool),bool),member(list(A))),XS)))))) ) ).

tff(fact_81_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys1: list(A)] : ( Xsa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys1) ) ) ).

tff(fact_82_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List) ) ) ).

tff(fact_83_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),aa(list(C),list(C),aa(C,fun(list(C),list(C)),cons(C),Y1),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F,zero_zero(B)),Y1)),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),Ys)) ) ) ).

tff(fact_84_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,Xsa: list(B),X1: B,F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xsa)),aa(list(C),list(C),aa(C,fun(list(C),list(C)),cons(C),Y1),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F,X1),Y1)),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),Xsa),Ys)) ) ) ).

tff(fact_85_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),nil(B)),nil(C)) = nil(A) ) ) ).

tff(fact_86_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xsa: list(B),X1: B,F: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xsa)),nil(C)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F,X1),zero_zero(C))),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F),Xsa),nil(C))) ) ) ).

tff(fact_87_diff__commute,axiom,
    ! [K: nat,J: nat,I: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),J)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),K)),J) ) ).

tff(fact_88_list__diff__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ( minus_minus(list(A)) = zipwith0(A,A,A,minus_minus(A)) ) ) ).

tff(fact_89_listset_Osimps_I2_J,axiom,
    ! [A: $tType,As: list(fun(A,bool)),A1: fun(A,bool)] : ( listset(A,aa(list(fun(A,bool)),list(fun(A,bool)),aa(fun(A,bool),fun(list(fun(A,bool)),list(fun(A,bool))),cons(fun(A,bool)),A1),As)) = set_Cons(A,A1,listset(A,As)) ) ).

tff(fact_90_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( cl_Groups_Ominus(B)
     => ! [B1: fun(A,B),A1: fun(A,B),X2: A] : ( aa(A,B,aa(fun(A,B),fun(A,B),aa(fun(A,B),fun(fun(A,B),fun(A,B)),minus_minus(fun(A,B)),A1),B1),X2) = aa(B,B,aa(B,fun(B,B),minus_minus(B),aa(A,B,A1,X2)),aa(A,B,B1,X2)) ) ) ).

tff(fact_91_minus__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( cl_Groups_Ominus(A)
     => ! [X1: B,B1: fun(B,A),A1: fun(B,A)] : ( aa(B,A,aa(fun(B,A),fun(B,A),aa(fun(B,A),fun(fun(B,A),fun(B,A)),minus_minus(fun(B,A)),A1),B1),X1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(B,A,A1,X1)),aa(B,A,B1,X1)) ) ) ).

tff(fact_92_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X1: B] : ( aa(B,A,bot_bot(fun(B,A)),X1) = bot_bot(A) ) ) ).

tff(fact_93_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X2: A] : ( aa(A,B,bot_bot(fun(A,B)),X2) = bot_bot(B) ) ) ).

tff(fact_94_bot__nat__def,axiom,
    bot_bot(nat) = zero_zero(nat) ).

tff(fact_95_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),X)) ) ).

tff(fact_96_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 != Y1 )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X1)) ) ) ) ).

tff(fact_97_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y1))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X1))
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_98_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
          | ( X = Y )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ).

%----Arities (20)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ominus,axiom,
    cl_Groups_Ominus(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

%----Helper facts (16)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))))))),aa(fun(atom,bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(atom,bool),fun(int,bool))),fun(fun(atom,bool),fun(list(int),fun(int,bool))),combc(list(int),fun(atom,bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool))),aa(fun(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool)))),combb(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool)),list(int)),combc(int,fun(atom,bool),bool)),aa(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool))),aa(fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),fun(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool)))),combb(fun(int,atom),fun(int,fun(fun(atom,bool),bool)),list(int)),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),combb(atom,fun(fun(atom,bool),bool),int),member(atom))),aa(fun(int,fun(list(int),atom)),fun(list(int),fun(int,atom)),combc(int,list(int),atom),c_PresArith_Oatom_OLe)))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,aa(fun(int,bool),fun(int,fun(list(int),bool)),aa(fun(bool,fun(list(int),bool)),fun(fun(int,bool),fun(int,fun(list(int),bool))),combb(bool,fun(list(int),bool),int),combk(bool,list(int))),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))))) != bot_bot(fun(int,bool)) ).

%------------------------------------------------------------------------------
