%------------------------------------------------------------------------------
% File     : COM065_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 142
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_142 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  187 (  64 unt;  50 typ;   0 def)
%            Number of atoms       :  266 (  98 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  190 (  61   ~;  11   |;   7   &)
%                                         (  25 <=>;  86  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   41 (  25   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   1 prp; 0-2 aty)
%            Number of functors    :   34 (  34 usr;   4 con; 0-5 aty)
%            Number of variables   :  357 ( 310   !;   6   ?; 357   :)
%                                         (  41  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olinorder__class_Osorted__list__of__set,type,
    linord467138063of_set: 
      !>[A: $tType] : ( fun(A,bool) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) ) > fun(list(A),T1) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) ) > fun(atom,T1) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_1__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_2_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int4: int,List: list(int),Int3: int] :
      ( ( c_PresArith_Oatom_OLe(Int3,List) = c_PresArith_Oatom_OLe(Int4,List3) )
    <=> ( ( Int3 = Int4 )
        & ( List = List3 ) ) ) ).

tff(fact_3_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),c_PresArith_Oatom_OLe(Int3,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int3),List) ) ).

tff(fact_4_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List: list(A),A2: A] :
      ( ( cons(A,A2,List) = cons(A,A6,List3) )
    <=> ( ( A2 = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_5_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),cons(B,A2,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List) ) ).

tff(fact_6_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X: A,Y2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,cons(A,X,Xsa))))
     => ( ( Y2 = X )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa))) ) ) ).

tff(fact_7_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),ring_1_of_int(A,Z1)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),Z1)) ) ) ).

tff(fact_8_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),ring_1_of_int(A,Z1)),zero_zero(A)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),Z1),zero_zero(int))) ) ) ).

tff(fact_9_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] : ( Xs != cons(A,X1,Xs) ) ).

tff(fact_10_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( cons(A,X1,Xs) != Xs ) ).

tff(fact_11_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X1: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),X1)) ) ).

tff(fact_12_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z1) )
        <=> ( W = Z1 ) ) ) ).

tff(fact_13_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( ring_1_of_int(A,Z1) = zero_zero(A) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_14_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z1) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_15_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_16_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int,W: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),ring_1_of_int(A,W)),ring_1_of_int(A,Z1)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),W),Z1)) ) ) ).

tff(fact_17_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_18_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_19_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_20_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_21_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( ( X1 != Y )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ) ).

tff(fact_22_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ).

tff(fact_23_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Z)) ) ) ) ).

tff(fact_24_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B2: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
         => ( ( B2 = C3 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C3)) ) ) ) ).

tff(fact_25_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B2: A,A3: A] :
          ( ( A3 = B2 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),C3))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),C3)) ) ) ) ).

tff(fact_26_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),A3)) ) ) ).

tff(fact_27_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y2: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y2))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X))
           => pp(P1) ) ) ) ).

tff(fact_28_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( Y != X1 ) ) ) ).

tff(fact_29_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( X1 != Y ) ) ) ).

tff(fact_30_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ).

tff(fact_31_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ).

tff(fact_32_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
         => ( X1 != Y ) ) ) ).

tff(fact_33_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( ( X1 != Y )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ) ).

tff(fact_34_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y2: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y2))
          <=> ( X = Y2 ) ) ) ) ).

tff(fact_35_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X1),Y))
          | ( X1 = Y )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X1)) ) ) ).

tff(fact_36_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y2))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X))
            | ( X = Y2 ) ) ) ) ).

tff(fact_37_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X: A] :
          ( ( X != Y2 )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y2))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X)) ) ) ) ).

tff(fact_38_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_39_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_40_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_41_atom_Osize_I1_J,axiom,
    ! [List2: list(int),Int: int] : ( atom_size(c_PresArith_Oatom_OLe(Int,List2)) = zero_zero(nat) ) ).

tff(fact_42_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List4: list(A)] : ( Y != cons(A,A4,List4) ) ) ).

tff(fact_43_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys1: list(A)] : ( Xsa = cons(A,Y1,Ys1) ) ) ).

tff(fact_44_atom_Osize_I4_J,axiom,
    ! [List2: list(int),Int: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int,List2)) = zero_zero(nat) ) ).

tff(fact_45_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_46_bot__less,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A2: A] :
          ( ( A2 != bot_bot(A) )
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),bot_bot(A)),A2)) ) ) ).

tff(fact_47_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X: B] : ( aa(B,A,bot_bot(fun(B,A)),X) = bot_bot(A) ) ) ).

tff(fact_48_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X4: A] : ( aa(A,B,bot_bot(fun(A,B)),X4) = bot_bot(B) ) ) ).

tff(fact_49_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
     => ( insert(A,X,Xsa) = Xsa ) ) ).

tff(fact_50_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),X: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
       => ( insert(A,X,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
       => ( insert(A,X,Xsa) = cons(A,X,Xsa) ) ) ) ).

tff(fact_51_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
     => ( insert(A,X,Xsa) = cons(A,X,Xsa) ) ) ).

tff(fact_52_not__less__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A3: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),bot_bot(A))) ) ).

tff(fact_53_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),Na)) ) ).

tff(fact_54_less__nat__zero__code,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_55_less__zeroE,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_56_emptyE,axiom,
    ! [A: $tType,A2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),bot_bot(fun(A,bool)))) ).

tff(fact_57_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X3: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_58_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X3: A] : ~ pp(aa(A,bool,P1,X3)) ) ).

tff(fact_59_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_60_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X3: A] : ~ pp(aa(A,bool,P1,X3)) ) ).

tff(fact_61_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_62_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S),T))
     => ( S != T ) ) ).

tff(fact_63_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),M))
     => ( M != N ) ) ).

tff(fact_64_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_65_linorder__neqE__nat,axiom,
    ! [Y: nat,X1: nat] :
      ( ( X1 != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X1),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X1)) ) ) ).

tff(fact_66_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),Na))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M1)) ) ) ).

tff(fact_67_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),N)) ).

tff(fact_68_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_69_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_70_equals0D,axiom,
    ! [A: $tType,A2: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ).

tff(fact_71_not__psubset__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ~ pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),bot_bot(fun(A,bool)))) ).

tff(fact_72_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N)) ) ).

tff(fact_73_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M),N))
     => ( N != zero_zero(nat) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A1))
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_bot__nat__def,axiom,
    bot_bot(nat) = zero_zero(nat) ).

tff(fact_78_not__less0,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N),zero_zero(nat))) ).

tff(fact_79_sublist__singleton,axiom,
    ! [A: $tType,X: A,A1: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A1))
       => ( sublist(A,cons(A,X,nil(A)),A1) = cons(A,X,nil(A)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A1))
       => ( sublist(A,cons(A,X,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_80_sorted__list__of__set__empty,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ( linord467138063of_set(A,bot_bot(fun(A,bool))) = nil(A) ) ) ).

tff(fact_81_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_82_sublist__empty,axiom,
    ! [A: $tType,Xsa: list(A)] : ( sublist(A,Xsa,bot_bot(fun(nat,bool))) = nil(A) ) ).

tff(fact_83_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_84_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X1: A] : ( splice(A,cons(A,X1,Xs),cons(A,Y,Ys)) = cons(A,X1,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_85_psubset__trans,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B1))
     => ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),B1),C2))
       => pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),C2)) ) ) ).

tff(fact_86_psubsetD,axiom,
    ! [A: $tType,C1: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),B1))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_87_notin__set__sublistI,axiom,
    ! [A: $tType,I2: fun(nat,bool),Xsa: list(A),X: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,sublist(A,Xsa,I2)))) ) ).

tff(fact_88_in__set__sublistD,axiom,
    ! [A: $tType,I2: fun(nat,bool),Xsa: list(A),X: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,sublist(A,Xsa,I2))))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa))) ) ).

tff(fact_89_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_90_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_91_atom_Osize_I6_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( size_size(atom,nDvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_92_atom_Osize_I3_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( atom_size(nDvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_93_atom_Osimps_I3_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List: list(int),Int2: int,Int1: int] :
      ( ( nDvd(Int1,Int2,List) = nDvd(Int12,Int22,List3) )
    <=> ( ( Int1 = Int12 )
        & ( Int2 = Int22 )
        & ( List = List3 ) ) ) ).

tff(fact_94_atom_Osimps_I6_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List2: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List2) != nDvd(Int11,Int21,List1) ) ).

tff(fact_95_atom_Osimps_I7_J,axiom,
    ! [List2: list(int),Int: int,List1: list(int),Int21: int,Int11: int] : ( nDvd(Int11,Int21,List1) != c_PresArith_Oatom_OLe(Int,List2) ) ).

tff(fact_96_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_97_divisor_Osimps_I3_J,axiom,
    ! [Ks1: list(int),I1: int,D: int] : ( divisor(nDvd(D,I1,Ks1)) = D ) ).

tff(fact_98_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),semiring_1_of_nat(A,Na)))
        <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),Na)) ) ) ).

%----Arities (25)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ( ? [I: int,K: int] :
        ( ? [Ks: list(int)] : pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),c_PresArith_Oatom_OLe(I,cons(int,K,Ks))),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,combb(bool,fun(list(int),bool),int,combk(bool,list(int)),combc(int,int,bool,ord_less(int),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))
        & pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),K),zero_zero(int))) )
   => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
