%------------------------------------------------------------------------------
% File     : COM062_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 136
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_136 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  189 (  60 unt;  56 typ;   0 def)
%            Number of atoms       :  251 ( 124 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  165 (  47   ~;  21   |;  17   &)
%                                         (  27 <=>;  53  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   19 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   23 (  15   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-2 aty)
%            Number of functors    :   42 (  42 usr;  10 con; 0-4 aty)
%            Number of variables   :  401 ( 352   !;   3   ?; 401   :)
%                                         (  46  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:14
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (50)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oundefined,type,
    undefined: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: fun(int,fun(list(int),atom)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (96)
tff(fact_0_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( divisor(X3) != zero_zero(int) ) ) ).

tff(fact_1_hd,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => pp(aa(atom,bool,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),hd_coeff(X3)),insert(int,one_one(int),insert(int,number_number_of(int,min),bot_bot(fun(int,bool))))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X3)),one_one(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X3)),one_one(int)))))),X3)) ) ).

tff(fact_2_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),X),Y)),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)) ) ) ).

tff(fact_3_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A5: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A5),A5) = zero_zero(A) ) ) ).

tff(fact_4__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_5_less__bin__lemma,axiom,
    ! [L: int,K: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),K),L))
    <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),aa(int,int,aa(int,fun(int,int),minus_minus(int),K),L)),zero_zero(int))) ) ).

tff(fact_6_atom_Osimps_I1_J,axiom,
    ! [List2: list(int),Int1: int,List1: list(int),Int: int] :
      ( ( aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List1) = aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List2) )
    <=> ( ( Int = Int1 )
        & ( List1 = List2 ) ) ) ).

tff(fact_7_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B1))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B1)),zero_zero(A))) ) ) ).

tff(fact_8_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List1: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List1)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List1) ) ).

tff(fact_9_image__eqI,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),X2: B,F: fun(B,A),B1: A] :
      ( ( B1 = aa(B,A,F,X2) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),image(B,A,F,A1))) ) ) ).

tff(fact_10_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A4: A,List1: list(A),A2: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List2) )
    <=> ( ( A2 = A4 )
        & ( List1 = List2 ) ) ) ).

tff(fact_11_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A2),List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List1) ) ).

tff(fact_12_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_13_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_14_empty__Diff,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),bot_bot(fun(A,bool))),A1) = bot_bot(fun(A,bool)) ) ).

tff(fact_15_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_16_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_17_Diff__cancel,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),A1) = bot_bot(fun(A,bool)) ) ).

tff(fact_18_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_19_emptyE,axiom,
    ! [A: $tType,A2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),bot_bot(fun(A,bool)))) ).

tff(fact_20_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y2: int,X2: int] :
          ( ( number_number_of(A,X2) = number_number_of(A,Y2) )
        <=> ( X2 = Y2 ) ) ) ).

tff(fact_21_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] : ( insert(A,X2,insert(A,X2,A1)) = insert(A,X2,A1) ) ).

tff(fact_22_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,A1)))
    <=> ( ( A2 = B1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_23_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,A1)))
     => ( ( A2 != B1 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_24_insertCI,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),A2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B2))
       => ( A2 = B1 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,B2))) ) ).

tff(fact_25_insert__Diff__single,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( insert(A,A2,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),insert(A,A2,bot_bot(fun(A,bool))))) = insert(A,A2,A1) ) ).

tff(fact_26_image__is__empty,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A)] :
      ( ( image(B,A,F,A1) = bot_bot(fun(A,bool)) )
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_27_image__empty,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( image(B,A,F,bot_bot(fun(B,bool))) = bot_bot(fun(A,bool)) ) ).

tff(fact_28_empty__is__image,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A)] :
      ( ( bot_bot(fun(A,bool)) = image(B,A,F,A1) )
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_29_image__insert,axiom,
    ! [A: $tType,B: $tType,B2: fun(B,bool),A2: B,F: fun(B,A)] : ( image(B,A,F,insert(B,A2,B2)) = insert(A,aa(B,A,F,A2),image(B,A,F,B2)) ) ).

tff(fact_30_rel__simps_I7_J,axiom,
    ~ pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),min),min)) ).

tff(fact_31_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( aa(list(A),list(A),tl(A),nil(A)) = nil(A) ) ).

tff(fact_32_singleton__conv,axiom,
    ! [A: $tType,A2: A] : ( collect(A,aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2)) = insert(A,A2,bot_bot(fun(A,bool))) ) ).

tff(fact_33_singleton__conv2,axiom,
    ! [A: $tType,A2: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A2)) = insert(A,A2,bot_bot(fun(A,bool))) ) ).

tff(fact_34_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y2: int,X2: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),number_number_of(A,X2)),number_number_of(A,Y2)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),X2),Y2)) ) ) ).

tff(fact_35_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_36_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_37_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_38_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] : ( set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa)) = insert(A,X2,set(A,Xsa)) ) ).

tff(fact_39_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),nil(A)) = zero_zero(A) ) ) ).

tff(fact_40_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),nil(A)),Ys) = zero_zero(A) ) ) ).

tff(fact_41_divisor_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( divisor(aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,I1),Ks1)) = one_one(int) ) ).

tff(fact_42_hd__coeff_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( hd_coeff(aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,I),Ks)) = aa(list(int),int,list_case(int,int,zero_zero(int),combk(int,list(int))),Ks) ) ).

tff(fact_43_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( bot_bot(fun(A,bool)) != insert(A,A2,A1) ) ).

tff(fact_44_not__psubset__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ~ pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),bot_bot(fun(A,bool)))) ).

tff(fact_45_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( insert(A,A2,A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_46_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_47_insertI1,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,A2,B2))) ).

tff(fact_48_number__of__is__id,axiom,
    ! [K1: int] : ( number_number_of(int,K1) = K1 ) ).

tff(fact_49_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_50_Collect__conv__if2,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(A,fun(A,bool),fequal(A),A2))),P1)) = insert(A,A2,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(A,fun(A,bool),fequal(A),A2))),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_51_Collect__conv__if,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2))),P1)) = insert(A,A2,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2))),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_52_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X2: A] :
          ( ( one_one(A) = X2 )
        <=> ( X2 = one_one(A) ) ) ) ).

tff(fact_53_Diff__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),bot_bot(fun(A,bool))) = A1 ) ).

tff(fact_54_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),nil(A)) = Xs ) ) ).

tff(fact_55_insert__compr,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A] : ( insert(A,A2,B2) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2))),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),B2))) ) ).

tff(fact_56_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A2: A] : ( insert(A,A2,collect(A,P1)) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fimplies),aa(fun(A,bool),fun(A,bool),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2)))),P1)) ) ).

tff(fact_57_singleton__iff,axiom,
    ! [A: $tType,A2: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A2,bot_bot(fun(A,bool)))))
    <=> ( B1 = A2 ) ) ).

tff(fact_58_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y2: A,X2: A] : ( insert(A,X2,insert(A,Y2,A1)) = insert(A,Y2,insert(A,X2,A1)) ) ).

tff(fact_59_Diff__insert,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),insert(A,A2,B2)) = aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B2)),insert(A,A2,bot_bot(fun(A,bool)))) ) ).

tff(fact_60_Diff__insert2,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A,A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),insert(A,A2,B2)) = aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),insert(A,A2,bot_bot(fun(A,bool))))),B2) ) ).

tff(fact_61_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X2: A,W1: int] :
          ( ( number_number_of(A,W1) = X2 )
        <=> ( X2 = number_number_of(A,W1) ) ) ) ).

tff(fact_62_insert__Diff__if,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: fun(A,bool),X2: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2))
       => ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),insert(A,X2,A1)),B2) = aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B2) ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2))
       => ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),insert(A,X2,A1)),B2) = insert(A,X2,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B2)) ) ) ) ).

tff(fact_63_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C1: A,B1: A,A2: A] :
      ( ( insert(A,A2,insert(A,B1,bot_bot(fun(A,bool)))) = insert(A,C1,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A2 = C1 )
          & ( B1 = D ) )
        | ( ( A2 = D )
          & ( B1 = C1 ) ) ) ) ).

tff(fact_64_insert__code,axiom,
    ! [A: $tType,X2: A,A1: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,A1),X2))
    <=> ( ( Y2 = X2 )
        | pp(aa(A,bool,A1,X2)) ) ) ).

tff(fact_65_Diff__insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),insert(A,X2,A1)),insert(A,X2,bot_bot(fun(A,bool)))) = A1 ) ) ).

tff(fact_66_insert__ident,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2))
       => ( ( insert(A,X2,A1) = insert(A,X2,B2) )
        <=> ( A1 = B2 ) ) ) ) ).

tff(fact_67_insert__eq__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),B1: A,A1: fun(A,bool),A2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),B2))
       => ( ( insert(A,A2,A1) = insert(A,B1,B2) )
        <=> ( ( ( A2 = B1 )
             => ( A1 = B2 ) )
            & ( ( A2 != B1 )
             => ? [C2: fun(A,bool)] :
                  ( ( A1 = insert(A,B1,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),C2))
                  & ( B2 = insert(A,A2,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),C2)) ) ) ) ) ) ) ).

tff(fact_68_equals0D,axiom,
    ! [A: $tType,A2: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ).

tff(fact_69_insertI2,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,B2))) ) ).

tff(fact_70_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( insert(A,A2,A1) = A1 ) ) ).

tff(fact_71_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X4: A] : ( aa(A,B,F,X4) = aa(A,B,G,X4) )
     => ( F = G ) ) ).

tff(fact_72_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_73_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_74_insert__Diff,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( insert(A,A2,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),insert(A,A2,bot_bot(fun(A,bool))))) = A1 ) ) ).

tff(fact_75_insert__Diff1,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2))
     => ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),insert(A,X2,A1)),B2) = aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B2) ) ) ).

tff(fact_76_singletonE,axiom,
    ! [A: $tType,A2: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A2,bot_bot(fun(A,bool)))))
     => ( B1 = A2 ) ) ).

tff(fact_77_singleton__inject,axiom,
    ! [A: $tType,B1: A,A2: A] :
      ( ( insert(A,A2,bot_bot(fun(A,bool))) = insert(A,B1,bot_bot(fun(A,bool))) )
     => ( A2 = B1 ) ) ).

tff(fact_78_insert__compr__raw,axiom,
    ! [A: $tType,X3: A,Xa: fun(A,bool)] : ( insert(A,X3,Xa) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),X3))),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),Xa))) ) ).

tff(fact_79_list_Osimps_I3_J,axiom,
    ! [A: $tType,List: list(A),A3: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List) != nil(A) ) ).

tff(fact_80_list_Osimps_I2_J,axiom,
    ! [A: $tType,List: list(A),A3: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List) ) ).

tff(fact_81_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_82_image__constant,axiom,
    ! [A: $tType,B: $tType,C1: B,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( image(A,B,aa(B,fun(A,B),combk(B,A),C1),A1) = insert(B,C1,bot_bot(fun(B,bool))) ) ) ).

tff(fact_83_image__constant__conv,axiom,
    ! [A: $tType,B: $tType,C1: B,A1: fun(A,bool)] :
      ( ( ( A1 = bot_bot(fun(A,bool)) )
       => ( image(A,B,aa(B,fun(A,B),combk(B,A),C1),A1) = bot_bot(fun(B,bool)) ) )
      & ( ( A1 != bot_bot(fun(A,bool)) )
       => ( image(A,B,aa(B,fun(A,B),combk(B,A),C1),A1) = insert(B,C1,bot_bot(fun(B,bool))) ) ) ) ).

tff(fact_84_insert__image,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( insert(B,aa(A,B,F,X2),image(A,B,F,A1)) = image(A,B,F,A1) ) ) ).

tff(fact_85_less__number__of__int__code,axiom,
    ! [L: int,K: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),number_number_of(int,K)),number_number_of(int,L)))
    <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),K),L)) ) ).

tff(fact_86_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_87_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( ( A2 = B1 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_88_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) != Xs ) ).

tff(fact_89_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) ) ).

tff(fact_90_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B1: B,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ( B1 = aa(A,B,F,X2) )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),image(A,B,F,A1))) ) ) ).

tff(fact_91_imageI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X2)),image(A,B,F,A1))) ) ).

tff(fact_92_image__iff,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A),Z: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Z),image(B,A,F,A1)))
    <=> ? [X1: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
          & ( Z = aa(B,A,F,X1) ) ) ) ).

tff(fact_93_bin__less__0__simps_I2_J,axiom,
    pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),min),zero_zero(int))) ).

tff(fact_94_number__of__diff,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,aa(int,fun(int,int),minus_minus(int),V),W)) = aa(A,A,aa(A,fun(A,A),minus_minus(A),number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_95_image__ident,axiom,
    ! [A: $tType,Y1: fun(A,bool)] : ( image(A,A,combi(A),Y1) = Y1 ) ).

%----Arities (13)
tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

%----Helper facts (23)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    image(atom,int,atom_case(int,aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),int)),combc(list(int),int,int),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))),aa(fun(int,fun(list(int),int)),fun(int,fun(int,fun(list(int),int))),combk(fun(int,fun(list(int),int)),int),aa(fun(list(int),int),fun(int,fun(list(int),int)),combk(fun(list(int),int),int),aa(int,fun(list(int),int),combk(int,list(int)),undefined(int)))),aa(fun(int,fun(list(int),int)),fun(int,fun(int,fun(list(int),int))),combk(fun(int,fun(list(int),int)),int),aa(fun(list(int),int),fun(int,fun(list(int),int)),combk(fun(list(int),int),int),aa(int,fun(list(int),int),combk(int,list(int)),undefined(int))))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),aa(fun(atom,fun(int,bool)),fun(atom,bool),aa(fun(fun(int,bool),bool),fun(fun(atom,fun(int,bool)),fun(atom,bool)),combb(fun(int,bool),bool,atom),fEx(int)),aa(fun(atom,fun(int,fun(int,bool))),fun(atom,fun(int,bool)),aa(fun(fun(int,fun(int,bool)),fun(int,bool)),fun(fun(atom,fun(int,fun(int,bool))),fun(atom,fun(int,bool))),combb(fun(int,fun(int,bool)),fun(int,bool),atom),aa(fun(fun(int,bool),bool),fun(fun(int,fun(int,bool)),fun(int,bool)),combb(fun(int,bool),bool,int),fEx(int))),aa(fun(atom,fun(int,fun(int,bool))),fun(atom,fun(int,fun(int,bool))),aa(fun(fun(int,fun(int,bool)),fun(int,fun(int,bool))),fun(fun(atom,fun(int,fun(int,bool))),fun(atom,fun(int,fun(int,bool)))),combb(fun(int,fun(int,bool)),fun(int,fun(int,bool)),atom),aa(fun(fun(int,bool),fun(int,bool)),fun(fun(int,fun(int,bool)),fun(int,fun(int,bool))),combb(fun(int,bool),fun(int,bool),int),aa(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),combs(int,bool,bool),aa(fun(int,bool),fun(int,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int)))))),aa(fun(atom,fun(int,fun(int,fun(list(int),bool)))),fun(atom,fun(int,fun(int,bool))),aa(fun(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,bool))),fun(fun(atom,fun(int,fun(int,fun(list(int),bool)))),fun(atom,fun(int,fun(int,bool)))),combb(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,bool)),atom),aa(fun(fun(int,fun(list(int),bool)),fun(int,bool)),fun(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,bool))),combb(fun(int,fun(list(int),bool)),fun(int,bool),int),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))))),aa(fun(int,fun(int,fun(list(int),atom))),fun(atom,fun(int,fun(int,fun(list(int),bool)))),aa(fun(atom,fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool))))),fun(fun(int,fun(int,fun(list(int),atom))),fun(atom,fun(int,fun(int,fun(list(int),bool))))),combc(atom,fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool)))),aa(fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),fun(atom,fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool))))),aa(fun(fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))),fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool))))),fun(fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),fun(atom,fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool)))))),combb(fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))),fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool)))),atom),combb(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)),int)),aa(fun(atom,fun(fun(list(int),atom),fun(list(int),bool))),fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),aa(fun(fun(fun(list(int),atom),fun(list(int),bool)),fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),fun(fun(atom,fun(fun(list(int),atom),fun(list(int),bool))),fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))))),combb(fun(fun(list(int),atom),fun(list(int),bool)),fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))),atom),combb(fun(list(int),atom),fun(list(int),bool),int)),aa(fun(atom,fun(atom,bool)),fun(atom,fun(fun(list(int),atom),fun(list(int),bool))),aa(fun(fun(atom,bool),fun(fun(list(int),atom),fun(list(int),bool))),fun(fun(atom,fun(atom,bool)),fun(atom,fun(fun(list(int),atom),fun(list(int),bool)))),combb(fun(atom,bool),fun(fun(list(int),atom),fun(list(int),bool)),atom),combb(atom,bool,list(int))),fequal(atom))))),aa(fun(int,fun(list(int),list(int))),fun(int,fun(int,fun(list(int),atom))),aa(fun(int,fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom)))),fun(fun(int,fun(list(int),list(int))),fun(int,fun(int,fun(list(int),atom)))),combc(int,fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom))),aa(fun(int,fun(fun(list(int),list(int)),fun(list(int),atom))),fun(int,fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom)))),aa(fun(fun(fun(list(int),list(int)),fun(list(int),atom)),fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom)))),fun(fun(int,fun(fun(list(int),list(int)),fun(list(int),atom))),fun(int,fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom))))),combb(fun(fun(list(int),list(int)),fun(list(int),atom)),fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom))),int),combb(fun(list(int),list(int)),fun(list(int),atom),int)),aa(fun(int,fun(list(int),atom)),fun(int,fun(fun(list(int),list(int)),fun(list(int),atom))),aa(fun(fun(list(int),atom),fun(fun(list(int),list(int)),fun(list(int),atom))),fun(fun(int,fun(list(int),atom)),fun(int,fun(fun(list(int),list(int)),fun(list(int),atom)))),combb(fun(list(int),atom),fun(fun(list(int),list(int)),fun(list(int),atom)),int),combb(list(int),atom,list(int))),c_PresArith_Oatom_OLe))),cons(int)))))))))) = collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))))))),aa(fun(atom,bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(atom,bool),fun(int,bool))),fun(fun(atom,bool),fun(list(int),fun(int,bool))),combc(list(int),fun(atom,bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool))),aa(fun(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(atom,bool),bool))),fun(list(int),fun(fun(atom,bool),fun(int,bool)))),combb(fun(int,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(int,bool)),list(int)),combc(int,fun(atom,bool),bool)),aa(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool))),aa(fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),fun(fun(list(int),fun(int,atom)),fun(list(int),fun(int,fun(fun(atom,bool),bool)))),combb(fun(int,atom),fun(int,fun(fun(atom,bool),bool)),list(int)),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(int,atom),fun(int,fun(fun(atom,bool),bool))),combb(atom,fun(fun(atom,bool),bool),int),member(atom))),aa(fun(int,fun(list(int),atom)),fun(list(int),fun(int,atom)),combc(int,list(int),atom),c_PresArith_Oatom_OLe)))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(fun(atom,bool),bool)),fun(fun(atom,bool),fun(atom,bool)),combc(atom,fun(atom,bool),bool),member(atom)),set(atom,as)))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,aa(fun(int,bool),fun(int,fun(list(int),bool)),aa(fun(bool,fun(list(int),bool)),fun(fun(int,bool),fun(int,fun(list(int),bool))),combb(bool,fun(list(int),bool),int),combk(bool,list(int))),aa(int,fun(int,bool),aa(fun(int,fun(int,bool)),fun(int,fun(int,bool)),combc(int,int,bool),ord_less(int)),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))))) ).

%------------------------------------------------------------------------------
