%------------------------------------------------------------------------------
% File     : COM061_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 134
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_134 [Bla13]

% Status   : Theorem
% Rating   : 1.00 v8.1.0, 0.67 v7.5.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  187 (  48 unt;  56 typ;   0 def)
%            Number of atoms       :  264 (  87 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  176 (  43   ~;  16   |;  15   &)
%                                         (  21 <=>;  81  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   19 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   33 (  23   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-5 aty)
%            Number of functors    :   43 (  43 usr;   9 con; 0-4 aty)
%            Number of variables   :  404 ( 350   !;   8   ?; 404   :)
%                                         (  46  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:01
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (48)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oundefined,type,
    undefined: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(list(A),fun(list(B),list(C))) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olistset,type,
    listset: 
      !>[A: $tType] : ( list(fun(A,bool)) > fun(list(A),bool) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Oset__Cons,type,
    set_Cons: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(list(A),bool) ) > fun(list(A),bool) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: fun(int,fun(list(int),atom)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) ) > fun(atom,T1) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_norm,axiom,
    ! [X1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X1),set(atom,as)))
     => ( divisor(X1) != zero_zero(int) ) ) ).

tff(fact_1_finite__imageI,axiom,
    ! [B: $tType,A: $tType,H: fun(A,B),F4: fun(A,bool)] :
      ( finite_finite(A,F4)
     => finite_finite(B,image(A,B,H,F4)) ) ).

tff(fact_2_finite__set,axiom,
    ! [A: $tType,Xsa: list(A)] : finite_finite(A,set(A,Xsa)) ).

tff(fact_3_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys2: list(A),Y: A,Xs1: list(A),X: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys2)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),X),Y)),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs1),Ys2)) ) ) ).

tff(fact_4_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A4: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A4),A4) = zero_zero(A) ) ) ).

tff(fact_5__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_6_finite__Collect__disjI,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( finite_finite(A,collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),P1)),Q1)))
    <=> ( finite_finite(A,collect(A,P1))
        & finite_finite(A,collect(A,Q1)) ) ) ).

tff(fact_7_finite__Collect__conjI,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( ( finite_finite(A,collect(A,P1))
        | finite_finite(A,collect(A,Q1)) )
     => finite_finite(A,collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),P1)),Q1))) ) ).

tff(fact_8_less__bin__lemma,axiom,
    ! [L1: int,K1: int] :
      ( pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),K1),L1))
    <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),aa(int,int,aa(int,fun(int,int),minus_minus(int),K1),L1)),zero_zero(int))) ) ).

tff(fact_9_atom_Osimps_I1_J,axiom,
    ! [List4: list(int),Int2: int,List3: list(int),Int1: int] :
      ( ( aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List3) = aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int2),List4) )
    <=> ( ( Int1 = Int2 )
        & ( List3 = List4 ) ) ) ).

tff(fact_10_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B2: A,A3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B2)),zero_zero(A))) ) ) ).

tff(fact_11_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List3: list(int),Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F11: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F11,F2,F3),aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int1),List3)) = aa(list(int),A,aa(int,fun(list(int),A),F11,Int1),List3) ) ).

tff(fact_12_image__eqI,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),X2: B,F1: fun(B,A),B2: A] :
      ( ( B2 = aa(B,A,F1,X2) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),image(B,A,F1,A1))) ) ) ).

tff(fact_13_finite__Diff,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( finite_finite(A,A1)
     => finite_finite(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)) ) ).

tff(fact_14_finite__code,axiom,
    ! [A: $tType] :
      ( finite_finite1(A)
     => ! [A1: fun(A,bool)] : finite_finite(A,A1) ) ).

tff(fact_15_list_Oinject,axiom,
    ! [A: $tType,List4: list(A),A6: A,List3: list(A),A3: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List3) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A6),List4) )
    <=> ( ( A3 = A6 )
        & ( List3 = List4 ) ) ) ).

tff(fact_16_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( aa(list(A),list(A),tl(A),nil(A)) = nil(A) ) ).

tff(fact_17_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs1: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs1),nil(A)) = zero_zero(A) ) ) ).

tff(fact_18_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys2: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),nil(A)),Ys2) = zero_zero(A) ) ) ).

tff(fact_19_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs1),nil(A)) = Xs1 ) ) ).

tff(fact_20_nat__seg__image__imp__finite,axiom,
    ! [A: $tType,Na: nat,F1: fun(nat,A),A1: fun(A,bool)] :
      ( ( A1 = image(nat,A,F1,collect(nat,aa(nat,fun(nat,bool),combc(nat,nat,bool,ord_less(nat)),Na))) )
     => finite_finite(A,A1) ) ).

tff(fact_21_finite__Diff2,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: fun(A,bool)] :
      ( finite_finite(A,B1)
     => ( finite_finite(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1))
      <=> finite_finite(A,A1) ) ) ).

tff(fact_22_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) != nil(A) ) ).

tff(fact_23_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) ) ).

tff(fact_24_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_25_finite,axiom,
    ! [A: $tType] :
      ( finite_finite1(A)
     => ! [A1: fun(A,bool)] : finite_finite(A,A1) ) ).

tff(fact_26_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B2: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B2) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( ( A3 = B2 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_27_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) != Xs1 ) ).

tff(fact_28_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) ) ).

tff(fact_29_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,F1: fun(A,B),B2: B,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ( B2 = aa(A,B,F1,X2) )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B2),image(A,B,F1,A1))) ) ) ).

tff(fact_30_imageI,axiom,
    ! [B: $tType,A: $tType,F1: fun(A,B),A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F1,X2)),image(A,B,F1,A1))) ) ).

tff(fact_31_image__iff,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F1: fun(B,A),Z: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Z),image(B,A,F1,A1)))
    <=> ? [X4: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A1))
          & ( Z = aa(B,A,F1,X4) ) ) ) ).

tff(fact_32_image__ident,axiom,
    ! [A: $tType,Y3: fun(A,bool)] : ( image(A,A,combi(A),Y3) = Y3 ) ).

tff(fact_33_image__image,axiom,
    ! [B: $tType,A: $tType,C: $tType,A1: fun(C,bool),G: fun(C,B),F1: fun(B,A)] : ( image(B,A,F1,image(C,B,G,A1)) = image(C,A,aa(fun(C,B),fun(C,A),aa(fun(B,A),fun(fun(C,B),fun(C,A)),combb(B,A,C),F1),G),A1) ) ).

tff(fact_34_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B2) = zero_zero(A) )
        <=> ( A3 = B2 ) ) ) ).

tff(fact_35_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A3: A] :
          ( ( A3 = B2 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B2) = zero_zero(A) ) ) ) ).

tff(fact_36_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A4: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A4),zero_zero(A)) = A4 ) ) ).

tff(fact_37_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C1: A,B2: A,A3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A3),B2) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C1),D) )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A3),B2))
          <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),C1),D)) ) ) ) ).

tff(fact_38_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xsa))))
     => ( ( Y1 = X2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa))) ) ) ).

tff(fact_39_tl_Osimps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),list(A),tl(A),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = Xs1 ) ).

tff(fact_40_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys2: list(A),Xs1: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs1),Ys2)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs1),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys2),Zs)) ) ) ).

tff(fact_41_finite__Collect__bounded__ex,axiom,
    ! [B: $tType,A: $tType,Q1: fun(B,fun(A,bool)),P1: fun(A,bool)] :
      ( finite_finite(A,collect(A,P1))
     => ( finite_finite(B,collect(B,aa(fun(B,fun(A,bool)),fun(B,bool),aa(fun(fun(A,bool),bool),fun(fun(B,fun(A,bool)),fun(B,bool)),combb(fun(A,bool),bool,B),fEx(A)),aa(fun(B,fun(A,bool)),fun(B,fun(A,bool)),aa(fun(fun(A,bool),fun(A,bool)),fun(fun(B,fun(A,bool)),fun(B,fun(A,bool))),combb(fun(A,bool),fun(A,bool),B),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),P1))),Q1))))
      <=> ! [Y2: A] :
            ( pp(aa(A,bool,P1,Y2))
           => finite_finite(B,collect(B,aa(A,fun(B,bool),combc(B,A,bool,Q1),Y2))) ) ) ) ).

tff(fact_42_finite__image__set,axiom,
    ! [B: $tType,A: $tType,F1: fun(A,B),P1: fun(A,bool)] :
      ( finite_finite(A,collect(A,P1))
     => finite_finite(B,collect(B,aa(fun(B,fun(A,bool)),fun(B,bool),aa(fun(fun(A,bool),bool),fun(fun(B,fun(A,bool)),fun(B,bool)),combb(fun(A,bool),bool,B),fEx(A)),aa(fun(A,bool),fun(B,fun(A,bool)),combc(B,fun(A,bool),fun(A,bool),aa(fun(B,fun(A,fun(bool,bool))),fun(B,fun(fun(A,bool),fun(A,bool))),aa(fun(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool))),fun(fun(B,fun(A,fun(bool,bool))),fun(B,fun(fun(A,bool),fun(A,bool)))),combb(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),B),combs(A,bool,bool)),aa(fun(B,fun(A,bool)),fun(B,fun(A,fun(bool,bool))),aa(fun(fun(A,bool),fun(A,fun(bool,bool))),fun(fun(B,fun(A,bool)),fun(B,fun(A,fun(bool,bool)))),combb(fun(A,bool),fun(A,fun(bool,bool)),B),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj)),aa(fun(A,B),fun(B,fun(A,bool)),combc(B,fun(A,B),fun(A,bool),aa(fun(B,fun(B,bool)),fun(B,fun(fun(A,B),fun(A,bool))),aa(fun(fun(B,bool),fun(fun(A,B),fun(A,bool))),fun(fun(B,fun(B,bool)),fun(B,fun(fun(A,B),fun(A,bool)))),combb(fun(B,bool),fun(fun(A,B),fun(A,bool)),B),combb(B,bool,A)),fequal(B))),F1)))),P1)))) ) ).

tff(fact_43_imageE,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F1: fun(B,A),B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),image(B,A,F1,A1)))
     => ~ ! [X3: B] :
            ( ( B2 = aa(B,A,F1,X3) )
           => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A1)) ) ) ).

tff(fact_44_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X3: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Cs)))
             => ( X3 = zero_zero(A) ) )
         => ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Cs),Xsa) = zero_zero(A) ) ) ) ).

tff(fact_45_set__Cons__def,axiom,
    ! [A: $tType,XS: fun(list(A),bool),A1: fun(A,bool)] : ( set_Cons(A,A1,XS) = collect(list(A),aa(fun(list(A),fun(A,bool)),fun(list(A),bool),aa(fun(fun(A,bool),bool),fun(fun(list(A),fun(A,bool)),fun(list(A),bool)),combb(fun(A,bool),bool,list(A)),fEx(A)),aa(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,bool)),aa(fun(fun(A,fun(list(A),bool)),fun(A,bool)),fun(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,bool))),combb(fun(A,fun(list(A),bool)),fun(A,bool),list(A)),aa(fun(fun(list(A),bool),bool),fun(fun(A,fun(list(A),bool)),fun(A,bool)),combb(fun(list(A),bool),bool,A),fEx(list(A)))),aa(fun(A,fun(list(A),bool)),fun(list(A),fun(A,fun(list(A),bool))),combc(list(A),fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool)),aa(fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),fun(list(A),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool)))),aa(fun(fun(A,fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool)))),fun(fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),fun(list(A),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool))))),combb(fun(A,fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),bool))),list(A)),combs(A,fun(list(A),bool),fun(list(A),bool))),aa(fun(list(A),fun(A,fun(list(A),fun(bool,bool)))),fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),aa(fun(fun(A,fun(list(A),fun(bool,bool))),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),fun(fun(list(A),fun(A,fun(list(A),fun(bool,bool)))),fun(list(A),fun(A,fun(fun(list(A),bool),fun(list(A),bool))))),combb(fun(A,fun(list(A),fun(bool,bool))),fun(A,fun(fun(list(A),bool),fun(list(A),bool))),list(A)),aa(fun(fun(list(A),fun(bool,bool)),fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(list(A),fun(bool,bool))),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),combb(fun(list(A),fun(bool,bool)),fun(fun(list(A),bool),fun(list(A),bool)),A),combs(list(A),bool,bool))),aa(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,fun(list(A),fun(bool,bool)))),aa(fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),fun(bool,bool)))),fun(fun(list(A),fun(A,fun(list(A),bool))),fun(list(A),fun(A,fun(list(A),fun(bool,bool))))),combb(fun(A,fun(list(A),bool)),fun(A,fun(list(A),fun(bool,bool))),list(A)),aa(fun(fun(list(A),bool),fun(list(A),fun(bool,bool))),fun(fun(A,fun(list(A),bool)),fun(A,fun(list(A),fun(bool,bool)))),combb(fun(list(A),bool),fun(list(A),fun(bool,bool)),A),aa(fun(bool,fun(bool,bool)),fun(fun(list(A),bool),fun(list(A),fun(bool,bool))),combb(bool,fun(bool,bool),list(A)),fconj))),aa(fun(A,fun(list(A),list(A))),fun(list(A),fun(A,fun(list(A),bool))),combc(list(A),fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool)),aa(fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool))),fun(list(A),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool)))),aa(fun(fun(fun(list(A),list(A)),fun(list(A),bool)),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool)))),fun(fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool))),fun(list(A),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool))))),combb(fun(fun(list(A),list(A)),fun(list(A),bool)),fun(fun(A,fun(list(A),list(A))),fun(A,fun(list(A),bool))),list(A)),combb(fun(list(A),list(A)),fun(list(A),bool),A)),aa(fun(list(A),fun(list(A),bool)),fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool))),aa(fun(fun(list(A),bool),fun(fun(list(A),list(A)),fun(list(A),bool))),fun(fun(list(A),fun(list(A),bool)),fun(list(A),fun(fun(list(A),list(A)),fun(list(A),bool)))),combb(fun(list(A),bool),fun(fun(list(A),list(A)),fun(list(A),bool)),list(A)),combb(list(A),bool,list(A))),fequal(list(A))))),cons(A)))))),aa(fun(list(A),bool),fun(A,fun(list(A),bool)),combc(A,fun(list(A),bool),fun(list(A),bool),aa(fun(A,fun(bool,bool)),fun(A,fun(fun(list(A),bool),fun(list(A),bool))),aa(fun(fun(bool,bool),fun(fun(list(A),bool),fun(list(A),bool))),fun(fun(A,fun(bool,bool)),fun(A,fun(fun(list(A),bool),fun(list(A),bool)))),combb(fun(bool,bool),fun(fun(list(A),bool),fun(list(A),bool)),A),combb(bool,bool,list(A))),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),combc(A,fun(A,bool),bool,member(A)),A1)))),aa(fun(list(A),bool),fun(list(A),bool),combc(list(A),fun(list(A),bool),bool,member(list(A))),XS)))))) ) ).

tff(fact_46_pigeonhole__infinite,axiom,
    ! [B: $tType,A: $tType,F1: fun(A,B),A1: fun(A,bool)] :
      ( ~ finite_finite(A,A1)
     => ( finite_finite(B,image(A,B,F1,A1))
       => ? [X3: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
            & ~ finite_finite(A,collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),combc(A,fun(A,bool),bool,member(A)),A1))),aa(B,fun(A,bool),combc(A,B,bool,aa(fun(A,B),fun(A,fun(B,bool)),aa(fun(B,fun(B,bool)),fun(fun(A,B),fun(A,fun(B,bool))),combb(B,fun(B,bool),A),fequal(B)),F1)),aa(A,B,F1,X3))))) ) ) ) ).

tff(fact_47_atom_Osize_I1_J,axiom,
    ! [List: list(int),Int: int] : ( atom_size(aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = zero_zero(nat) ) ).

tff(fact_48_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List1: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List1) ) ) ).

tff(fact_49_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys1: list(A)] : ( Xsa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys1) ) ) ).

tff(fact_50_finite__list,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( finite_finite(A,A1)
     => ? [Xs: list(A)] : ( set(A,Xs) = A1 ) ) ).

tff(fact_51_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xsa: list(B),X2: B,F1: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F1),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X2),Xsa)),nil(C)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F1,X2),zero_zero(C))),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F1),Xsa),nil(C))) ) ) ).

tff(fact_52_Diff__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
        & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_53_Diff__idemp,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)),B1) = aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1) ) ).

tff(fact_54_DiffI,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1))) ) ) ).

tff(fact_55_DiffE,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
     => ~ ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_56_finite__Collect__less__nat,axiom,
    ! [K1: nat] : finite_finite(nat,collect(nat,aa(nat,fun(nat,bool),combc(nat,nat,bool,ord_less(nat)),K1))) ).

tff(fact_57_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,Xsa: list(B),X2: B,F1: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F1),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X2),Xsa)),aa(list(C),list(C),aa(C,fun(list(C),list(C)),cons(C),Y1),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F1,X2),Y1)),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F1),Xsa),Ys)) ) ) ).

tff(fact_58_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F1: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F1),nil(B)),nil(C)) = nil(A) ) ) ).

tff(fact_59_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,F1: fun(B,fun(C,A))] : ( aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F1),nil(B)),aa(list(C),list(C),aa(C,fun(list(C),list(C)),cons(C),Y1),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(C,A,aa(B,fun(C,A),F1,zero_zero(B)),Y1)),aa(list(C),list(A),aa(list(B),fun(list(C),list(A)),zipwith0(B,C,A,F1),nil(B)),Ys)) ) ) ).

tff(fact_60_set__diff__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),combc(A,fun(A,bool),bool,member(A)),A1))),aa(fun(A,bool),fun(A,bool),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot),aa(fun(A,bool),fun(A,bool),combc(A,fun(A,bool),bool,member(A)),B1)))) ) ).

tff(fact_61_DiffD1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1)) ) ).

tff(fact_62_DiffD2,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A1),B1)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ).

tff(fact_63_list__diff__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ( minus_minus(list(A)) = zipwith0(A,A,A,minus_minus(A)) ) ) ).

tff(fact_64_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),Na)) ) ).

tff(fact_65_zero__less__diff,axiom,
    ! [M2: nat,Na: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),Na),M2)))
    <=> pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M2),Na)) ) ).

tff(fact_66_less__nat__zero__code,axiom,
    ! [N2: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),zero_zero(nat))) ).

tff(fact_67_less__zeroE,axiom,
    ! [N2: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),zero_zero(nat))) ).

tff(fact_68_diff__self__eq__0,axiom,
    ! [M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M1),M1) = zero_zero(nat) ) ).

tff(fact_69_diff__0__eq__0,axiom,
    ! [N2: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),zero_zero(nat)),N2) = zero_zero(nat) ) ).

tff(fact_70_diff__commute,axiom,
    ! [K: nat,J: nat,I1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I1),J)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I1),K)),J) ) ).

tff(fact_71_diffs0__imp__equal,axiom,
    ! [N2: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M1),N2) = zero_zero(nat) )
     => ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),N2),M1) = zero_zero(nat) )
       => ( M1 = N2 ) ) ) ).

tff(fact_72_minus__nat_Odiff__0,axiom,
    ! [M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M1),zero_zero(nat)) = M1 ) ).

tff(fact_73_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M2: nat] :
      ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M2),Na))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) )
     => ( ( ( M2 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) )
       => ( ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M2))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F1: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F1,X3) = aa(A,B,G,X3) )
     => ( F1 = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_diff__less__mono2,axiom,
    ! [L: nat,N2: nat,M1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),N2))
     => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),L))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),N2)),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),M1))) ) ) ).

tff(fact_78_less__imp__diff__less,axiom,
    ! [N2: nat,K: nat,J: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),J),K))
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),J),N2)),K)) ) ).

tff(fact_79_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),S),T))
     => ( S != T ) ) ).

tff(fact_80_less__not__refl2,axiom,
    ! [M1: nat,N2: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),M1))
     => ( M1 != N2 ) ) ).

tff(fact_81_less__irrefl__nat,axiom,
    ! [N2: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),N2)) ).

tff(fact_82_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X),Y))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Y),X)) ) ) ).

tff(fact_83_nat__neq__iff,axiom,
    ! [Na: nat,M2: nat] :
      ( ( M2 != Na )
    <=> ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M2),Na))
        | pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),Na),M2)) ) ) ).

tff(fact_84_less__not__refl,axiom,
    ! [N2: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),N2)) ).

tff(fact_85_gr0I,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N2)) ) ).

tff(fact_86_gr__implies__not0,axiom,
    ! [N2: nat,M1: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),M1),N2))
     => ( N2 != zero_zero(nat) ) ) ).

tff(fact_87_diff__less,axiom,
    ! [M1: nat,N2: nat] :
      ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),N2))
     => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),zero_zero(nat)),M1))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M1),N2)),M1)) ) ) ).

tff(fact_88_not__less0,axiom,
    ! [N2: nat] : ~ pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),N2),zero_zero(nat))) ).

tff(fact_89_finite__conv__nat__seg__image,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( finite_finite(A,A1)
    <=> ? [N1: nat,F: fun(nat,A)] : ( A1 = image(nat,A,F,collect(nat,aa(nat,fun(nat,bool),combc(nat,nat,bool,ord_less(nat)),N1))) ) ) ).

tff(fact_90_listset_Osimps_I2_J,axiom,
    ! [A: $tType,As: list(fun(A,bool)),A1: fun(A,bool)] : ( listset(A,aa(list(fun(A,bool)),list(fun(A,bool)),aa(fun(A,bool),fun(list(fun(A,bool)),list(fun(A,bool))),cons(fun(A,bool)),A1),As)) = set_Cons(A,A1,listset(A,As)) ) ).

tff(fact_91_atom_Osize_I4_J,axiom,
    ! [List: list(int),Int: int] : ( size_size(atom,aa(list(int),atom,aa(int,fun(list(int),atom),c_PresArith_Oatom_OLe,Int),List)) = zero_zero(nat) ) ).

tff(fact_92_finite__M__bounded__by__nat,axiom,
    ! [I: nat,P1: fun(nat,bool)] : finite_finite(nat,collect(nat,aa(fun(nat,bool),fun(nat,bool),aa(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),combs(nat,bool,bool),aa(fun(nat,bool),fun(nat,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fconj),P1)),aa(nat,fun(nat,bool),combc(nat,nat,bool,ord_less(nat)),I)))) ).

tff(fact_93_finite__nat__set__iff__bounded,axiom,
    ! [N: fun(nat,bool)] :
      ( finite_finite(nat,N)
    <=> ? [M: nat] :
        ! [X4: nat] :
          ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),X4),N))
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X4),M)) ) ) ).

tff(fact_94_bounded__nat__set__is__finite,axiom,
    ! [Na: nat,N: fun(nat,bool)] :
      ( ! [X3: nat] :
          ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),X3),N))
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),ord_less(nat),X3),Na)) )
     => finite_finite(nat,N) ) ).

tff(fact_95_minus__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( cl_Groups_Ominus(A)
     => ! [X2: B,B1: fun(B,A),A1: fun(B,A)] : ( aa(B,A,aa(fun(B,A),fun(B,A),aa(fun(B,A),fun(fun(B,A),fun(B,A)),minus_minus(fun(B,A)),A1),B1),X2) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(B,A,A1,X2)),aa(B,A,B1,X2)) ) ) ).

tff(fact_96_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( cl_Groups_Ominus(B)
     => ! [B1: fun(A,B),A1: fun(A,B),X1: A] : ( aa(A,B,aa(fun(A,B),fun(A,B),aa(fun(A,B),fun(fun(A,B),fun(A,B)),minus_minus(fun(A,B)),A1),B1),X1) = aa(B,B,aa(B,fun(B,B),minus_minus(B),aa(A,B,A1,X1)),aa(A,B,B1,X1)) ) ) ).

tff(fact_97_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) ).

tff(fact_98__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

%----Arities (13)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite1(T_2)
        & finite_finite1(T_1) )
     => finite_finite1(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Groups_Ominus,axiom,
    cl_Groups_Ominus(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite1(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

tff(arity_prod___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite1(T_2)
        & finite_finite1(T_1) )
     => finite_finite1(product_prod(T_1,T_2)) ) ).

%----Helper facts (18)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    finite_finite(int,image(atom,int,atom_case(int,combc(list(int),int,int,aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),minus_minus(int)),aa(list(int),fun(list(int),int),combc(list(int),list(int),int,aa(fun(list(int),list(int)),fun(list(int),fun(list(int),int)),aa(fun(list(int),fun(list(int),int)),fun(fun(list(int),list(int)),fun(list(int),fun(list(int),int))),combb(list(int),fun(list(int),int),list(int)),iprod(int)),tl(int))),xs))),combk(fun(int,fun(list(int),int)),int,combk(fun(list(int),int),int,combk(int,list(int),undefined(int)))),combk(fun(int,fun(list(int),int)),int,combk(fun(list(int),int),int,combk(int,list(int),undefined(int))))),collect(atom,aa(fun(atom,bool),fun(atom,bool),aa(fun(atom,fun(bool,bool)),fun(fun(atom,bool),fun(atom,bool)),combs(atom,bool,bool),aa(fun(atom,bool),fun(atom,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(atom,bool),fun(atom,fun(bool,bool))),combb(bool,fun(bool,bool),atom),fconj),aa(fun(atom,bool),fun(atom,bool),combc(atom,fun(atom,bool),bool,member(atom)),set(atom,as)))),aa(fun(atom,fun(int,bool)),fun(atom,bool),aa(fun(fun(int,bool),bool),fun(fun(atom,fun(int,bool)),fun(atom,bool)),combb(fun(int,bool),bool,atom),fEx(int)),aa(fun(atom,fun(int,fun(int,bool))),fun(atom,fun(int,bool)),aa(fun(fun(int,fun(int,bool)),fun(int,bool)),fun(fun(atom,fun(int,fun(int,bool))),fun(atom,fun(int,bool))),combb(fun(int,fun(int,bool)),fun(int,bool),atom),aa(fun(fun(int,bool),bool),fun(fun(int,fun(int,bool)),fun(int,bool)),combb(fun(int,bool),bool,int),fEx(int))),aa(fun(atom,fun(int,fun(int,fun(list(int),bool)))),fun(atom,fun(int,fun(int,bool))),aa(fun(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,bool))),fun(fun(atom,fun(int,fun(int,fun(list(int),bool)))),fun(atom,fun(int,fun(int,bool)))),combb(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,bool)),atom),aa(fun(fun(int,fun(list(int),bool)),fun(int,bool)),fun(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,bool))),combb(fun(int,fun(list(int),bool)),fun(int,bool),int),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))))),aa(fun(atom,fun(int,fun(int,fun(list(int),bool)))),fun(atom,fun(int,fun(int,fun(list(int),bool)))),aa(fun(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,fun(list(int),bool)))),fun(fun(atom,fun(int,fun(int,fun(list(int),bool)))),fun(atom,fun(int,fun(int,fun(list(int),bool))))),combb(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,fun(list(int),bool))),atom),aa(fun(fun(int,fun(list(int),bool)),fun(int,fun(list(int),bool))),fun(fun(int,fun(int,fun(list(int),bool))),fun(int,fun(int,fun(list(int),bool)))),combb(fun(int,fun(list(int),bool)),fun(int,fun(list(int),bool)),int),aa(fun(int,fun(fun(list(int),bool),fun(list(int),bool))),fun(fun(int,fun(list(int),bool)),fun(int,fun(list(int),bool))),combs(int,fun(list(int),bool),fun(list(int),bool)),aa(fun(int,fun(bool,bool)),fun(int,fun(fun(list(int),bool),fun(list(int),bool))),aa(fun(fun(bool,bool),fun(fun(list(int),bool),fun(list(int),bool))),fun(fun(int,fun(bool,bool)),fun(int,fun(fun(list(int),bool),fun(list(int),bool)))),combb(fun(bool,bool),fun(fun(list(int),bool),fun(list(int),bool)),int),combb(bool,bool,list(int))),aa(fun(int,bool),fun(int,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj),aa(int,fun(int,bool),combc(int,int,bool,ord_less(int)),zero_zero(int))))))),aa(fun(int,fun(int,fun(list(int),atom))),fun(atom,fun(int,fun(int,fun(list(int),bool)))),combc(atom,fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool))),aa(fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),fun(atom,fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool))))),aa(fun(fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))),fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool))))),fun(fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),fun(atom,fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool)))))),combb(fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))),fun(fun(int,fun(int,fun(list(int),atom))),fun(int,fun(int,fun(list(int),bool)))),atom),combb(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)),int)),aa(fun(atom,fun(fun(list(int),atom),fun(list(int),bool))),fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),aa(fun(fun(fun(list(int),atom),fun(list(int),bool)),fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool)))),fun(fun(atom,fun(fun(list(int),atom),fun(list(int),bool))),fun(atom,fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))))),combb(fun(fun(list(int),atom),fun(list(int),bool)),fun(fun(int,fun(list(int),atom)),fun(int,fun(list(int),bool))),atom),combb(fun(list(int),atom),fun(list(int),bool),int)),aa(fun(atom,fun(atom,bool)),fun(atom,fun(fun(list(int),atom),fun(list(int),bool))),aa(fun(fun(atom,bool),fun(fun(list(int),atom),fun(list(int),bool))),fun(fun(atom,fun(atom,bool)),fun(atom,fun(fun(list(int),atom),fun(list(int),bool)))),combb(fun(atom,bool),fun(fun(list(int),atom),fun(list(int),bool)),atom),combb(atom,bool,list(int))),fequal(atom))))),aa(fun(int,fun(list(int),list(int))),fun(int,fun(int,fun(list(int),atom))),combc(int,fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom)),aa(fun(int,fun(fun(list(int),list(int)),fun(list(int),atom))),fun(int,fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom)))),aa(fun(fun(fun(list(int),list(int)),fun(list(int),atom)),fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom)))),fun(fun(int,fun(fun(list(int),list(int)),fun(list(int),atom))),fun(int,fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom))))),combb(fun(fun(list(int),list(int)),fun(list(int),atom)),fun(fun(int,fun(list(int),list(int))),fun(int,fun(list(int),atom))),int),combb(fun(list(int),list(int)),fun(list(int),atom),int)),aa(fun(int,fun(list(int),atom)),fun(int,fun(fun(list(int),list(int)),fun(list(int),atom))),aa(fun(fun(list(int),atom),fun(fun(list(int),list(int)),fun(list(int),atom))),fun(fun(int,fun(list(int),atom)),fun(int,fun(fun(list(int),list(int)),fun(list(int),atom)))),combb(fun(list(int),atom),fun(fun(list(int),list(int)),fun(list(int),atom)),int),combb(list(int),atom,list(int))),c_PresArith_Oatom_OLe))),cons(int))))))))))) ).

%------------------------------------------------------------------------------
