%------------------------------------------------------------------------------
% File     : COM059_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 124
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_124 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  173 (  52 unt;  55 typ;   0 def)
%            Number of atoms       :  249 ( 136 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  173 (  42   ~;  15   |;  24   &)
%                                         (  24 <=>;  68  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   62 (  36   >;  26   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-5 aty)
%            Number of functors    :   46 (  46 usr;   9 con; 0-6 aty)
%            Number of variables   :  443 ( 382   !;  12   ?; 443   :)
%                                         (  49  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Enum_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( ( nat * list(A) ) > list(list(A)) ) ).

tff(sy_c_Enum_Oproduct,type,
    product: 
      !>[A: $tType,B: $tType] : ( ( list(A) * list(B) ) > list(product_prod(A,B)) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * list(A) * list(B) ) > list(C) ) ).

tff(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( list(list(A)) > list(A) ) ).

tff(sy_c_List_OdropWhile,type,
    dropWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Oinsert,type,
    insert1: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > fun(list(A),list(B)) ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oremdups,type,
    remdups: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_List_Otranspose,type,
    transpose: 
      !>[A: $tType] : ( list(list(A)) > list(list(A)) ) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_n____,type,
    n: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

tff(fact_1__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_2_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List: list(A),A2: A] :
      ( ( cons(A,A2,List) = cons(A,A5,List3) )
    <=> ( ( A2 = A5 )
        & ( List = List3 ) ) ) ).

tff(fact_3_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,cons(A,X2,Xsa))))
     => ( ( Y1 = X2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa))) ) ) ).

tff(fact_4_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_5_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != cons(A,X1,Xs1) ) ).

tff(fact_6_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( cons(A,X1,Xs1) != Xs1 ) ).

tff(fact_7_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( insert1(A,X2,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( insert1(A,X2,Xsa) = cons(A,X2,Xsa) ) ) ) ).

tff(fact_8_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
     => ( insert1(A,X2,Xsa) = cons(A,X2,Xsa) ) ) ).

tff(fact_9_remdups_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( remdups(A,cons(A,X2,Xsa)) = remdups(A,Xsa) ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( remdups(A,cons(A,X2,Xsa)) = cons(A,X2,remdups(A,Xsa)) ) ) ) ).

tff(fact_10_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A2,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List) ) ).

tff(fact_11_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] : ( set(A,cons(A,X2,Xsa)) = insert(A,X2,set(A,Xsa)) ) ).

tff(fact_12_set__remdups,axiom,
    ! [A: $tType,Xsa: list(A)] : ( set(A,remdups(A,Xsa)) = set(A,Xsa) ) ).

tff(fact_13_remdups_Osimps_I1_J,axiom,
    ! [A: $tType] : ( remdups(A,nil(A)) = nil(A) ) ).

tff(fact_14_remdups__eq__nil__right__iff,axiom,
    ! [A: $tType,X2: list(A)] :
      ( ( nil(A) = remdups(A,X2) )
    <=> ( X2 = nil(A) ) ) ).

tff(fact_15_remdups__eq__nil__iff,axiom,
    ! [A: $tType,X2: list(A)] :
      ( ( remdups(A,X2) = nil(A) )
    <=> ( X2 = nil(A) ) ) ).

tff(fact_16_List_Oset__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] : ( set(A,insert1(A,X2,Xsa)) = insert(A,X2,set(A,Xsa)) ) ).

tff(fact_17_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert1(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_18_remdups__remdups,axiom,
    ! [A: $tType,Xs1: list(A)] : ( remdups(A,remdups(A,Xs1)) = remdups(A,Xs1) ) ).

tff(fact_19_insert__remdups,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( insert1(A,X1,remdups(A,Xs1)) = remdups(A,insert1(A,X1,Xs1)) ) ).

tff(fact_20_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_21_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( cons(A,A4,List2) != nil(A) ) ).

tff(fact_22_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( nil(A) != cons(A,A4,List2) ) ).

tff(fact_23_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
     => ( insert1(A,X2,Xsa) = Xsa ) ) ).

tff(fact_24_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] : ( insert(A,X2,insert(A,X2,A1)) = insert(A,X2,A1) ) ).

tff(fact_25_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B3: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B3,A1)))
    <=> ( ( A2 = B3 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_26_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B3: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B3,A1)))
     => ( ( A2 != B3 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_27_insertCI,axiom,
    ! [A: $tType,B3: A,B2: fun(A,bool),A2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B2))
       => ( A2 = B3 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B3,B2))) ) ).

tff(fact_28_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List1: list(A)] : ( Y != cons(A,A3,List1) ) ) ).

tff(fact_29_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys2: list(A)] : ( Xsa = cons(A,Y2,Ys2) ) ) ).

tff(fact_30_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_31_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_32_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs1: list(A),X1: A] : ( splice(A,cons(A,X1,Xs1),cons(A,Y,Ys1)) = cons(A,X1,cons(A,Y,splice(A,Xs1,Ys1))) ) ).

tff(fact_33_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
          & pp(aa(A,bool,P1,X3))
          & ! [Y2: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa)))
                & pp(aa(A,bool,P1,Y2)) )
             => ( Y2 = X3 ) ) ) ) ).

tff(fact_34_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_35_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_36_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_37_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( insert(A,A2,A1) = A1 ) ) ).

tff(fact_38_insertI2,axiom,
    ! [A: $tType,B3: A,B2: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B3,B2))) ) ).

tff(fact_39_insert__eq__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),B3: A,A1: fun(A,bool),A2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B3),B2))
       => ( ( insert(A,A2,A1) = insert(A,B3,B2) )
        <=> ( ( ( A2 = B3 )
             => ( A1 = B2 ) )
            & ( ( A2 != B3 )
             => ? [C1: fun(A,bool)] :
                  ( ( A1 = insert(A,B3,C1) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B3),C1))
                  & ( B2 = insert(A,A2,C1) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),C1)) ) ) ) ) ) ) ).

tff(fact_40_insert__ident,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2))
       => ( ( insert(A,X2,A1) = insert(A,X2,B2) )
        <=> ( A1 = B2 ) ) ) ) ).

tff(fact_41_insert__code,axiom,
    ! [A: $tType,X2: A,A1: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,A1),X2))
    <=> ( ( Y1 = X2 )
        | pp(aa(A,bool,A1,X2)) ) ) ).

tff(fact_42_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y1: A,X2: A] : ( insert(A,X2,insert(A,Y1,A1)) = insert(A,Y1,insert(A,X2,A1)) ) ).

tff(fact_43_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A2: A] : ( insert(A,A2,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A2))),P1)) ) ).

tff(fact_44_insert__compr,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A] : ( insert(A,A2,B2) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A2)),combc(A,fun(A,bool),bool,member(A),B2))) ) ).

tff(fact_45_insertI1,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,A2,B2))) ).

tff(fact_46_Set_Oset__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ~ ! [B1: fun(A,bool)] :
            ( ( A1 = insert(A,X2,B1) )
           => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1)) ) ) ).

tff(fact_47_mk__disjoint__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ? [B1: fun(A,bool)] :
          ( ( A1 = insert(A,A2,B1) )
          & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B1)) ) ) ).

tff(fact_48_sublist__singleton,axiom,
    ! [A: $tType,X2: A,A1: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A1))
       => ( sublist(A,cons(A,X2,nil(A)),A1) = cons(A,X2,nil(A)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A1))
       => ( sublist(A,cons(A,X2,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_49_list__nonempty__induct,axiom,
    ! [A: $tType,P1: fun(list(A),bool),Xsa: list(A)] :
      ( ( Xsa != nil(A) )
     => ( ! [X: A] : pp(aa(list(A),bool,P1,cons(A,X,nil(A))))
       => ( ! [X: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P1,Xs2))
               => pp(aa(list(A),bool,P1,cons(A,X,Xs2))) ) )
         => pp(aa(list(A),bool,P1,Xsa)) ) ) ) ).

tff(fact_50_product_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Uu: list(B)] : ( product(A,B,nil(A),Uu) = nil(product_prod(A,B)) ) ).

tff(fact_51_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X3: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X3),set(fm(atom),Fs)))
         => interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_52_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_53_in__set__sublistD,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,sublist(A,Xsa,I))))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa))) ) ).

tff(fact_54_notin__set__sublistI,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,sublist(A,Xsa,I)))) ) ).

tff(fact_55_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X3: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X3),set(fm(atom),Fs)))
          & interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_56_n__lists__Nil,axiom,
    ! [A: $tType,N: nat] :
      ( ( ( N = zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = cons(list(A),nil(A),nil(list(A))) ) )
      & ( ( N != zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = nil(list(A)) ) ) ) ).

tff(fact_57_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs1: list(A)] : ( n_lists(A,zero_zero(nat),Xs1) = cons(list(A),nil(A),nil(list(A))) ) ).

tff(fact_58_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_59_transpose_Osimps_I2_J,axiom,
    ! [A: $tType,Xss1: list(list(A))] : ( transpose(A,cons(list(A),nil(A),Xss1)) = transpose(A,Xss1) ) ).

tff(fact_60_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xsa: list(B),X2: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X2,Xsa),nil(C)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X2),zero_zero(C)),zipwith0(B,C,A,F,Xsa,nil(C))) ) ) ).

tff(fact_61_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),cons(C,Y1,Ys)) = cons(A,aa(C,A,aa(B,fun(C,A),F,zero_zero(B)),Y1),zipwith0(B,C,A,F,nil(B),Ys)) ) ) ).

tff(fact_62_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,Xsa: list(B),X2: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X2,Xsa),cons(C,Y1,Ys)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X2),Y1),zipwith0(B,C,A,F,Xsa,Ys)) ) ) ).

tff(fact_63_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),nil(C)) = nil(A) ) ) ).

tff(fact_64_transpose_Osimps_I1_J,axiom,
    ! [A: $tType] : ( transpose(A,nil(list(A))) = nil(list(A)) ) ).

tff(fact_65_transpose__empty,axiom,
    ! [A: $tType,Xsa: list(list(A))] :
      ( ( transpose(A,Xsa) = nil(list(A)) )
    <=> ! [X3: list(A)] :
          ( pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),X3),set(list(A),Xsa)))
         => ( X3 = nil(A) ) ) ) ).

tff(fact_66_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A)] : ( iprod(A,nil(A),Ys1) = zero_zero(A) ) ) ).

tff(fact_67_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs1: list(A)] : ( iprod(A,Xs1,nil(A)) = zero_zero(A) ) ) ).

tff(fact_68_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_69_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A2: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,A2,List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A2),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_70_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Cs)))
             => ( X = zero_zero(A) ) )
         => ( iprod(A,Cs,Xsa) = zero_zero(A) ) ) ) ).

tff(fact_71_dropWhile__eq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( dropWhile(A,P1,Xsa) = nil(A) )
    <=> ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
         => pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_72_Nil__eq__concat__conv,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( ( nil(A) = concat(A,Xss) )
    <=> ! [X3: list(A)] :
          ( pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),X3),set(list(A),Xss)))
         => ( X3 = nil(A) ) ) ) ).

tff(fact_73_dropWhile_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,X2))
       => ( dropWhile(A,P1,cons(A,X2,Xsa)) = dropWhile(A,P1,Xsa) ) )
      & ( ~ pp(aa(A,bool,P1,X2))
       => ( dropWhile(A,P1,cons(A,X2,Xsa)) = cons(A,X2,Xsa) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_dropWhile_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( dropWhile(A,P1,nil(A)) = nil(A) ) ).

tff(fact_78_concat_Osimps_I1_J,axiom,
    ! [A: $tType] : ( concat(A,nil(list(A))) = nil(A) ) ).

tff(fact_79_concat__eq__Nil__conv,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( ( concat(A,Xss) = nil(A) )
    <=> ! [X3: list(A)] :
          ( pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),X3),set(list(A),Xss)))
         => ( X3 = nil(A) ) ) ) ).

tff(fact_80_dropWhile__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),K: list(A),L: list(A)] :
      ( ( L = K )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,L)))
           => ( pp(aa(A,bool,P1,X))
            <=> pp(aa(A,bool,Q1,X)) ) )
       => ( dropWhile(A,P1,L) = dropWhile(A,Q1,K) ) ) ) ).

tff(fact_81_zipwith0__Nil,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),Ys) = aa(list(C),list(A),map(C,A,aa(B,fun(C,A),F,zero_zero(B))),Ys) ) ) ).

tff(fact_82_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),X2: B,F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),cons(B,X2,Xsa)) = cons(A,aa(B,A,F,X2),aa(list(B),list(A),map(B,A,F),Xsa)) ) ).

tff(fact_83_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xsa) = aa(list(B),list(A),map(B,A,G),Xsa) )
    <=> ! [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),set(B,Xsa)))
         => ( aa(B,A,F,X3) = aa(B,A,G,X3) ) ) ) ).

tff(fact_84_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_85_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),nil(B)) = nil(A) ) ).

tff(fact_86_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = aa(list(B),list(A),map(B,A,F),Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_87_map__concat,axiom,
    ! [A: $tType,B: $tType,Xsa: list(list(B)),F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),concat(B,Xsa)) = concat(A,aa(list(list(B)),list(list(A)),map(list(B),list(A),map(B,A,F)),Xsa)) ) ).

tff(fact_88_transpose__map__map,axiom,
    ! [A: $tType,B: $tType,Xsa: list(list(B)),F: fun(B,A)] : ( transpose(A,aa(list(list(B)),list(list(A)),map(list(B),list(A),map(B,A,F)),Xsa)) = aa(list(list(B)),list(list(A)),map(list(B),list(A),map(B,A,F)),transpose(B,Xsa)) ) ).

tff(fact_89_remdups__map__remdups,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] : ( remdups(A,aa(list(B),list(A),map(B,A,F),remdups(B,Xsa))) = remdups(A,aa(list(B),list(A),map(B,A,F),Xsa)) ) ).

tff(fact_90_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Ys)))
           => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
       => ( aa(list(A),list(B),map(A,B,F),Xsa) = aa(list(A),list(B),map(A,B,G),Ys) ) ) ) ).

tff(fact_91_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,A,F,X) = X ) )
     => ( aa(list(A),list(A),map(A,A,F),Xsa) = Xsa ) ) ).

tff(fact_92_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys: list(B)] :
      ( ? [Xs: list(A)] : ( Ys = aa(list(A),list(B),map(A,B,F),Xs) )
    <=> ! [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),set(B,Ys)))
         => ? [Xa: A] : ( X3 = aa(A,B,F,Xa) ) ) ) ).

tff(fact_93_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
     => ( aa(list(A),list(B),map(A,B,F),Xsa) = aa(list(A),list(B),map(A,B,G),Xsa) ) ) ).

tff(fact_94_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xsa: list(A),X2: A] :
      ( ( cons(A,X2,Xsa) = aa(list(B),list(A),map(B,A,F),Ys) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys = cons(B,Z,Zs) )
          & ( X2 = aa(B,A,F,Z) )
          & ( Xsa = aa(list(B),list(A),map(B,A,F),Zs) ) ) ) ).

tff(fact_95_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y1: A,Xsa: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xsa) = cons(A,Y1,Ys) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xsa = cons(B,Z,Zs) )
          & ( aa(B,A,F,Z) = Y1 )
          & ( aa(list(B),list(A),map(B,A,F),Zs) = Ys ) ) ) ).

tff(fact_96_concat__map__maps,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,list(A))] : ( concat(A,aa(list(B),list(list(A)),map(B,list(A),F),Xsa)) = maps(B,A,F,Xsa) ) ).

tff(fact_97_maps__def,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,list(A))] : ( maps(B,A,F,Xsa) = concat(A,aa(list(B),list(list(A)),map(B,list(A),F),Xsa)) ) ).

tff(fact_98_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

%----Arities (3)
tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y))
      | ( X1 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ( X1 != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [X: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),set(atom,as)))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,X),cons(int,n,xs))) ) ).

%------------------------------------------------------------------------------
