%------------------------------------------------------------------------------
% File     : COM058_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 123
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_123 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  186 (  66 unt;  57 typ;   0 def)
%            Number of atoms       :  245 ( 114 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  164 (  48   ~;  23   |;  24   &)
%                                         (  30 <=>;  39  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   53 (  29   >;  24   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-5 aty)
%            Number of functors    :   44 (  44 usr;  10 con; 0-5 aty)
%            Number of variables   :  419 ( 369   !;   7   ?; 419   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:45
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (50)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Olinorder__class_Oinsort__insert__key,type,
    linord2118332866rt_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * B * list(B) ) > list(B) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (98)
tff(fact_0_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),aa(list(atom),fun(atom,bool),set(atom),as)))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_1__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_2__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

tff(fact_3_insort__insert__triv,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xsa: list(A),X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),aa(list(A),fun(A,bool),set(A),Xsa)))
         => ( linord2118332866rt_key(A,A,combi(A),X2,Xsa) = Xsa ) ) ) ).

tff(fact_4_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List2: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),c_PresArith_Oatom_OLe(Int3,List2)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int3),List2) ) ).

tff(fact_5_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List2: list(int),Int22: int,Int12: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),nDvd(Int12,Int22,List2)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int12),Int22),List2) ) ).

tff(fact_6_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List2: list(int),Int22: int,Int12: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),dvd(Int12,Int22,List2)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int12),Int22),List2) ) ).

tff(fact_7_hd,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),aa(list(atom),fun(atom,bool),set(atom),as)))
     => pp(aa(atom,bool,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),hd_coeff(X4)),insert(int,one_one(int),insert(int,number_number_of(int,min),bot_bot(fun(int,bool))))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X4)),one_one(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X4)),one_one(int)))))),X4)) ) ).

tff(fact_8_member__set,axiom,
    ! [A: $tType] : ( member1(A) = set(A) ) ).

tff(fact_9_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),aa(list(A),fun(A,bool),set(A),Xsa)))
          & pp(aa(A,bool,P1,X1))
          & ! [Y2: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),aa(list(A),fun(A,bool),set(A),Xsa)))
                & pp(aa(A,bool,P1,Y2)) )
             => ( Y2 = X1 ) ) ) ) ).

tff(fact_10_List_Omember__def,axiom,
    ! [A: $tType,X2: A,Xsa: list(A)] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),X2))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),aa(list(A),fun(A,bool),set(A),Xsa))) ) ).

tff(fact_11_ListMem__iff,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( listMem(A,X2,Xsa)
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),aa(list(A),fun(A,bool),set(A),Xsa))) ) ).

tff(fact_12_atom_Osimps_I2_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List2: list(int),Int22: int,Int12: int] :
      ( ( dvd(Int12,Int22,List2) = dvd(Int13,Int23,List3) )
    <=> ( ( Int12 = Int13 )
        & ( Int22 = Int23 )
        & ( List2 = List3 ) ) ) ).

tff(fact_13_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int4: int,List2: list(int),Int3: int] :
      ( ( c_PresArith_Oatom_OLe(Int3,List2) = c_PresArith_Oatom_OLe(Int4,List3) )
    <=> ( ( Int3 = Int4 )
        & ( List2 = List3 ) ) ) ).

tff(fact_14_atom_Osimps_I3_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List2: list(int),Int22: int,Int12: int] :
      ( ( nDvd(Int12,Int22,List2) = nDvd(Int13,Int23,List3) )
    <=> ( ( Int12 = Int13 )
        & ( Int22 = Int23 )
        & ( List2 = List3 ) ) ) ).

tff(fact_15_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_16_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( aa(list(A),fun(A,bool),set(A),Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_17_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = aa(list(A),fun(A,bool),set(A),Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_18_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( aa(list(A),fun(A,bool),set(A),nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_19_divisor_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( divisor(c_PresArith_Oatom_OLe(I1,Ks1)) = one_one(int) ) ).

tff(fact_20_atom_Osimps_I4_J,axiom,
    ! [List: list(int),Int2: int,Int1: int,List1: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List1) != dvd(Int1,Int2,List) ) ).

tff(fact_21_atom_Osimps_I6_J,axiom,
    ! [List: list(int),Int2: int,Int1: int,List1: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List1) != nDvd(Int1,Int2,List) ) ).

tff(fact_22_atom_Osimps_I5_J,axiom,
    ! [List1: list(int),Int: int,List: list(int),Int2: int,Int1: int] : ( dvd(Int1,Int2,List) != c_PresArith_Oatom_OLe(Int,List1) ) ).

tff(fact_23_atom_Osimps_I7_J,axiom,
    ! [List1: list(int),Int: int,List: list(int),Int2: int,Int1: int] : ( nDvd(Int1,Int2,List) != c_PresArith_Oatom_OLe(Int,List1) ) ).

tff(fact_24_atom_Osimps_I8_J,axiom,
    ! [List: list(int),Int2: int,Int1: int,List1: list(int),Int21: int,Int11: int] : ( dvd(Int11,Int21,List1) != nDvd(Int1,Int2,List) ) ).

tff(fact_25_atom_Osimps_I9_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int2: int,Int1: int] : ( nDvd(Int1,Int2,List) != dvd(Int11,Int21,List1) ) ).

tff(fact_26_divisor_Osimps_I2_J,axiom,
    ! [Ks1: list(int),I1: int,D1: int] : ( divisor(dvd(D1,I1,Ks1)) = D1 ) ).

tff(fact_27_divisor_Osimps_I3_J,axiom,
    ! [Ks1: list(int),I1: int,D1: int] : ( divisor(nDvd(D1,I1,Ks1)) = D1 ) ).

tff(fact_28_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] : ~ pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),nil(A)),Y)) ).

tff(fact_29_set__insort__insert,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xsa: list(A),X2: A] : ( aa(list(A),fun(A,bool),set(A),linord2118332866rt_key(A,A,combi(A),X2,Xsa)) = insert(A,X2,aa(list(A),fun(A,bool),set(A),Xsa)) ) ) ).

tff(fact_30_in__set__member,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),aa(list(A),fun(A,bool),set(A),Xsa)))
    <=> pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),X2)) ) ).

tff(fact_31_singleton__conv2,axiom,
    ! [A: $tType,A1: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A1)) = insert(A,A1,bot_bot(fun(A,bool))) ) ).

tff(fact_32_singleton__conv,axiom,
    ! [A: $tType,A1: A] : ( collect(A,combc(A,A,bool,fequal(A),A1)) = insert(A,A1,bot_bot(fun(A,bool))) ) ).

tff(fact_33_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_34_hd__coeff_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( hd_coeff(c_PresArith_Oatom_OLe(I,Ks)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks) ) ).

tff(fact_35_hd__coeff_Osimps_I3_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( hd_coeff(nDvd(D,I,Ks)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks) ) ).

tff(fact_36_hd__coeff_Osimps_I2_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( hd_coeff(dvd(D,I,Ks)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks) ) ).

tff(fact_37_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X1: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X1),aa(list(fm(atom)),fun(fm(atom),bool),set(fm(atom)),Fs)))
         => interpret(atom,int,i_Z,X1,Xsa) ) ) ).

tff(fact_38_insert__absorb2,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] : ( insert(A,X2,insert(A,X2,A2)) = insert(A,X2,A2) ) ).

tff(fact_39_emptyE,axiom,
    ! [A: $tType,A1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),bot_bot(fun(A,bool)))) ).

tff(fact_40_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_41_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_42_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_43_all__not__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ! [X1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A2))
    <=> ( A2 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_44_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X2: int] :
          ( ( number_number_of(A,X2) = number_number_of(A,Y1) )
        <=> ( X2 = Y1 ) ) ) ).

tff(fact_45_insertCI,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),A1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),B1))
       => ( A1 = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,B1))) ) ).

tff(fact_46_insertE,axiom,
    ! [A: $tType,A2: fun(A,bool),B2: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,A2)))
     => ( ( A1 != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ) ).

tff(fact_47_insert__iff,axiom,
    ! [A: $tType,A2: fun(A,bool),B2: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,A2)))
    <=> ( ( A1 = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ) ).

tff(fact_48_equals0D,axiom,
    ! [A: $tType,A1: A,A2: fun(A,bool)] :
      ( ( A2 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ).

tff(fact_49_ex__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ? [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A2))
    <=> ( A2 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_50_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_51_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X2: A,W: int] :
          ( ( number_number_of(A,W) = X2 )
        <=> ( X2 = number_number_of(A,W) ) ) ) ).

tff(fact_52_insert__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2))
     => ( insert(A,A1,A2) = A2 ) ) ).

tff(fact_53_insertI2,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,B1))) ) ).

tff(fact_54_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B2: A,A2: fun(A,bool),A1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B1))
       => ( ( insert(A,A1,A2) = insert(A,B2,B1) )
        <=> ( ( ( A1 = B2 )
             => ( A2 = B1 ) )
            & ( ( A1 != B2 )
             => ? [C3: fun(A,bool)] :
                  ( ( A2 = insert(A,B2,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C3))
                  & ( B1 = insert(A,A1,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),C3)) ) ) ) ) ) ) ).

tff(fact_55_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
       => ( ( insert(A,X2,A2) = insert(A,X2,B1) )
        <=> ( A2 = B1 ) ) ) ) ).

tff(fact_56_insert__code,axiom,
    ! [A: $tType,X2: A,A2: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,A2),X2))
    <=> ( ( Y1 = X2 )
        | pp(aa(A,bool,A2,X2)) ) ) ).

tff(fact_57_insert__commute,axiom,
    ! [A: $tType,A2: fun(A,bool),Y1: A,X2: A] : ( insert(A,X2,insert(A,Y1,A2)) = insert(A,Y1,insert(A,X2,A2)) ) ).

tff(fact_58_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A1: A] : ( insert(A,A1,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A1))),P1)) ) ).

tff(fact_59_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: A] : ( insert(A,A1,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A1)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_60_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,A1,B1))) ).

tff(fact_61_number__of__is__id,axiom,
    ! [K1: int] : ( number_number_of(int,K1) = K1 ) ).

tff(fact_62_insert__compr__raw,axiom,
    ! [A: $tType,X4: A,Xa: fun(A,bool)] : ( insert(A,X4,Xa) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X4)),combc(A,fun(A,bool),bool,member(A),Xa))) ) ).

tff(fact_63_singleton__inject,axiom,
    ! [A: $tType,B2: A,A1: A] :
      ( ( insert(A,A1,bot_bot(fun(A,bool))) = insert(A,B2,bot_bot(fun(A,bool))) )
     => ( A1 = B2 ) ) ).

tff(fact_64_singletonE,axiom,
    ! [A: $tType,A1: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,A1,bot_bot(fun(A,bool)))))
     => ( B2 = A1 ) ) ).

tff(fact_65_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C1: A,B2: A,A1: A] :
      ( ( insert(A,A1,insert(A,B2,bot_bot(fun(A,bool)))) = insert(A,C1,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A1 = C1 )
          & ( B2 = D ) )
        | ( ( A1 = D )
          & ( B2 = C1 ) ) ) ) ).

tff(fact_66_singleton__iff,axiom,
    ! [A: $tType,A1: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,A1,bot_bot(fun(A,bool)))))
    <=> ( B2 = A1 ) ) ).

tff(fact_67_insert__not__empty,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] : ( insert(A,A1,A2) != bot_bot(fun(A,bool)) ) ).

tff(fact_68_empty__not__insert,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] : ( bot_bot(fun(A,bool)) != insert(A,A1,A2) ) ).

tff(fact_69_Collect__conv__if,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = insert(A,A1,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_70_Collect__conv__if2,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = insert(A,A1,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_71_rel__simps_I7_J,axiom,
    ~ ord_less(int,min,min) ).

tff(fact_72_Un__insert__left,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A1: A] : ( sup_sup(fun(A,bool),insert(A,A1,B1),C2) = insert(A,A1,sup_sup(fun(A,bool),B1,C2)) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
    <=> pp(aa(A,bool,A2,X2)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_Un__insert__right,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: A,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,insert(A,A1,B1)) = insert(A,A1,sup_sup(fun(A,bool),A2,B1)) ) ).

tff(fact_77_Un__empty,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] :
      ( ( sup_sup(fun(A,bool),A2,B1) = bot_bot(fun(A,bool)) )
    <=> ( ( A2 = bot_bot(fun(A,bool)) )
        & ( B1 = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_78_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X1: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X1),aa(list(fm(atom)),fun(fm(atom),bool),set(fm(atom)),Fs)))
          & interpret(atom,int,i_Z,X1,Xsa) ) ) ).

tff(fact_79_Un__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_80_UnE,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B1)))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1)) ) ) ).

tff(fact_81_UnCI,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: fun(A,bool),C1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2)) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B1))) ) ).

tff(fact_82_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,X2: int] :
          ( ord_less(A,number_number_of(A,X2),number_number_of(A,Y1))
        <=> ord_less(int,X2,Y1) ) ) ).

tff(fact_83_Un__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,A2) = A2 ) ).

tff(fact_84_Un__def,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,fun(A,bool),bool,member(A),A2)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_85_Un__commute,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B1) = sup_sup(fun(A,bool),B1,A2) ) ).

tff(fact_86_Un__left__absorb,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),A2,B1)) = sup_sup(fun(A,bool),A2,B1) ) ).

tff(fact_87_Un__left__commute,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B1,C2)) = sup_sup(fun(A,bool),B1,sup_sup(fun(A,bool),A2,C2)) ) ).

tff(fact_88_Un__assoc,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),sup_sup(fun(A,bool),A2,B1),C2) = sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B1,C2)) ) ).

tff(fact_89_bex__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] :
      ( ? [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),sup_sup(fun(A,bool),A2,B1)))
          & pp(aa(A,bool,P1,X1)) )
    <=> ( ? [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A2))
            & pp(aa(A,bool,P1,X1)) )
        | ? [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),B1))
            & pp(aa(A,bool,P1,X1)) ) ) ) ).

tff(fact_90_ball__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] :
      ( ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),sup_sup(fun(A,bool),A2,B1)))
         => pp(aa(A,bool,P1,X1)) )
    <=> ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A2))
           => pp(aa(A,bool,P1,X1)) )
        & ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),B1))
           => pp(aa(A,bool,P1,X1)) ) ) ) ).

tff(fact_91_UnI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B1))) ) ).

tff(fact_92_UnI2,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A2,B1))) ) ).

tff(fact_93_Collect__disj__eq,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] : ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,P1),Q1)) = sup_sup(fun(A,bool),collect(A,P1),collect(A,Q1)) ) ).

tff(fact_94_Un__empty__left,axiom,
    ! [A: $tType,B1: fun(A,bool)] : ( sup_sup(fun(A,bool),bot_bot(fun(A,bool)),B1) = B1 ) ).

tff(fact_95_Un__empty__right,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,bot_bot(fun(A,bool))) = A2 ) ).

tff(fact_96_less__number__of__int__code,axiom,
    ! [L: int,K: int] :
      ( ord_less(int,number_number_of(int,K),number_number_of(int,L))
    <=> ord_less(int,K,L) ) ).

tff(fact_97_insert__def,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: A] : ( insert(A,A1,B1) = sup_sup(fun(A,bool),collect(A,combc(A,A,bool,fequal(A),A1)),B1) ) ).

%----Arities (6)
tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

%----Helper facts (24)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(list(atom),fun(atom,bool),set(atom),as) = collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),aa(list(atom),fun(atom,bool),set(atom),as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))))) ).

%------------------------------------------------------------------------------
