%------------------------------------------------------------------------------
% File     : COM056_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 119
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_119 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  193 (  58 unt;  49 typ;   0 def)
%            Number of atoms       :  310 (  85 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  236 (  70   ~;  19   |;  13   &)
%                                         (  22 <=>; 112  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   39 (  24   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-3 aty)
%            Number of functors    :   32 (  32 usr;   6 con; 0-5 aty)
%            Number of variables   :  382 ( 333   !;   7   ?; 382   :)
%                                         (  42  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:36
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olinorder__class_Osorted__list__of__set,type,
    linord467138063of_set: 
      !>[A: $tType] : ( fun(A,bool) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) ) > fun(list(A),T1) ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) ) > fun(atom,T1) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

%----Relevant facts (99)
tff(fact_0__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_1_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_2_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X3: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_3_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X3: A] : ~ pp(aa(A,bool,P1,X3)) ) ).

tff(fact_4_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_5_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X3: A] : ~ pp(aa(A,bool,P1,X3)) ) ).

tff(fact_6_emptyE,axiom,
    ! [A: $tType,A2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),bot_bot(fun(A,bool)))) ).

tff(fact_7_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X4: A] : ( aa(A,B,bot_bot(fun(A,B)),X4) = bot_bot(B) ) ) ).

tff(fact_8_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X1: B] : ( aa(B,A,bot_bot(fun(B,A)),X1) = bot_bot(A) ) ) ).

tff(fact_9_not__less__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A6: A] : ~ pp(aa(A,bool,ord_less(A,A6),bot_bot(A))) ) ).

tff(fact_10_bot__less,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A2: A] :
          ( ( A2 != bot_bot(A) )
        <=> pp(aa(A,bool,ord_less(A,bot_bot(A)),A2)) ) ) ).

tff(fact_11_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_12_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_13_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_14_not__psubset__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ~ pp(aa(fun(A,bool),bool,ord_less(fun(A,bool),A1),bot_bot(fun(A,bool)))) ).

tff(fact_15_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_16_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_17_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,ord_less(A,X),Y))
         => ( ( X != Y )
           => pp(aa(A,bool,ord_less(A,Y),X)) ) ) ) ).

tff(fact_18_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ~ pp(aa(A,bool,ord_less(A,Y),X)) ) ) ).

tff(fact_19_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ( pp(aa(A,bool,ord_less(A,Y),Z1))
           => pp(aa(A,bool,ord_less(A,X),Z1)) ) ) ) ).

tff(fact_20_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A6: A] :
          ( pp(aa(A,bool,ord_less(A,A6),B3))
         => ( ( B3 = C3 )
           => pp(aa(A,bool,ord_less(A,A6),C3)) ) ) ) ).

tff(fact_21_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A6: A] :
          ( ( A6 = B3 )
         => ( pp(aa(A,bool,ord_less(A,B3),C3))
           => pp(aa(A,bool,ord_less(A,A6),C3)) ) ) ) ).

tff(fact_22_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B3: A,A6: A] :
          ( pp(aa(A,bool,ord_less(A,A6),B3))
         => ~ pp(aa(A,bool,ord_less(A,B3),A6)) ) ) ).

tff(fact_23_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y3: A,X1: A] :
          ( pp(aa(A,bool,ord_less(A,X1),Y3))
         => ( pp(aa(A,bool,ord_less(A,Y3),X1))
           => pp(P1) ) ) ) ).

tff(fact_24_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ( Y != X ) ) ) ).

tff(fact_25_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ( X != Y ) ) ) ).

tff(fact_26_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ~ pp(aa(A,bool,ord_less(A,Y),X)) ) ) ).

tff(fact_27_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ~ pp(aa(A,bool,ord_less(A,Y),X)) ) ) ).

tff(fact_28_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ( X != Y ) ) ) ).

tff(fact_29_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ pp(aa(A,bool,ord_less(A,X),Y))
           => pp(aa(A,bool,ord_less(A,Y),X)) ) ) ) ).

tff(fact_30_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y3: A] :
          ( ~ pp(aa(A,bool,ord_less(A,Y3),X1))
         => ( ~ pp(aa(A,bool,ord_less(A,X1),Y3))
          <=> ( X1 = Y3 ) ) ) ) ).

tff(fact_31_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
          | ( X = Y )
          | pp(aa(A,bool,ord_less(A,Y),X)) ) ) ).

tff(fact_32_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y3: A,X1: A] :
          ( ~ pp(aa(A,bool,ord_less(A,X1),Y3))
        <=> ( pp(aa(A,bool,ord_less(A,Y3),X1))
            | ( X1 = Y3 ) ) ) ) ).

tff(fact_33_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y3: A,X1: A] :
          ( ( X1 != Y3 )
        <=> ( pp(aa(A,bool,ord_less(A,X1),Y3))
            | pp(aa(A,bool,ord_less(A,Y3),X1)) ) ) ) ).

tff(fact_34_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ pp(aa(A,bool,ord_less(A,X),X)) ) ).

tff(fact_35_equals0D,axiom,
    ! [A: $tType,A2: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ).

tff(fact_36_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_37_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_38_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),cons(B,A2,List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List1) ) ).

tff(fact_39_sorted__list__of__set__empty,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ( linord467138063of_set(A,bot_bot(fun(A,bool))) = nil(A) ) ) ).

tff(fact_40_list_Osimps_I2_J,axiom,
    ! [A: $tType,List3: list(A),A5: A] : ( nil(A) != cons(A,A5,List3) ) ).

tff(fact_41_list_Osimps_I3_J,axiom,
    ! [A: $tType,List3: list(A),A5: A] : ( cons(A,A5,List3) != nil(A) ) ).

tff(fact_42_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X1: A,Y3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y3),set(A,cons(A,X1,Xsa))))
     => ( ( Y3 = X1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y3),set(A,Xsa))) ) ) ).

tff(fact_43_equals0I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [Y2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),A1))
     => ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_44_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F: fun(B,A),A2: A] :
          ( pp(aa(A,bool,ord_less(A,A2),aa(B,A,F,B1)))
         => ( pp(aa(B,bool,ord_less(B,B1),C1))
           => ( ! [X2: B,Y2: B] :
                  ( pp(aa(B,bool,ord_less(B,X2),Y2))
                 => pp(aa(A,bool,ord_less(A,aa(B,A,F,X2)),aa(B,A,F,Y2))) )
             => pp(aa(A,bool,ord_less(A,A2),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_45_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,B1: B,F: fun(B,A),A2: A] :
          ( ( A2 = aa(B,A,F,B1) )
         => ( pp(aa(B,bool,ord_less(B,B1),C1))
           => ( ! [X2: B,Y2: B] :
                  ( pp(aa(B,bool,ord_less(B,X2),Y2))
                 => pp(aa(A,bool,ord_less(A,aa(B,A,F,X2)),aa(B,A,F,Y2))) )
             => pp(aa(A,bool,ord_less(A,A2),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_46_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F: fun(A,B),B1: A,A2: A] :
          ( pp(aa(A,bool,ord_less(A,A2),B1))
         => ( pp(aa(B,bool,ord_less(B,aa(A,B,F,B1)),C1))
           => ( ! [X2: A,Y2: A] :
                  ( pp(aa(A,bool,ord_less(A,X2),Y2))
                 => pp(aa(B,bool,ord_less(B,aa(A,B,F,X2)),aa(A,B,F,Y2))) )
             => pp(aa(B,bool,ord_less(B,aa(A,B,F,A2)),C1)) ) ) ) ) ).

tff(fact_47_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A4: A,List1: list(A),A2: A] :
      ( ( cons(A,A2,List1) = cons(A,A4,List2) )
    <=> ( ( A2 = A4 )
        & ( List1 = List2 ) ) ) ).

tff(fact_48_psubsetD,axiom,
    ! [A: $tType,C1: A,B2: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,ord_less(fun(A,bool),A1),B2))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B2)) ) ) ).

tff(fact_49_psubset__trans,axiom,
    ! [A: $tType,C2: fun(A,bool),B2: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(fun(A,bool),bool,ord_less(fun(A,bool),A1),B2))
     => ( pp(aa(fun(A,bool),bool,ord_less(fun(A,bool),B2),C2))
       => pp(aa(fun(A,bool),bool,ord_less(fun(A,bool),A1),C2)) ) ) ).

tff(fact_50_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_51_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_52_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List: list(A)] : ( Y != cons(A,A3,List) ) ) ).

tff(fact_53_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys1: list(A)] : ( Xsa = cons(A,Y1,Ys1) ) ) ).

tff(fact_54_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_55_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_56_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_57_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
     => ( insert(A,X1,Xsa) = Xsa ) ) ).

tff(fact_58_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_59_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_60_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
     => ( insert(A,X1,Xsa) = cons(A,X1,Xsa) ) ) ).

tff(fact_61_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),X1: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
       => ( insert(A,X1,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
       => ( insert(A,X1,Xsa) = cons(A,X1,Xsa) ) ) ) ).

tff(fact_62_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F: fun(A,B),B1: A,A2: A] :
          ( pp(aa(A,bool,ord_less(A,A2),B1))
         => ( ( aa(A,B,F,B1) = C1 )
           => ( ! [X2: A,Y2: A] :
                  ( pp(aa(A,bool,ord_less(A,X2),Y2))
                 => pp(aa(B,bool,ord_less(B,aa(A,B,F,X2)),aa(A,B,F,Y2))) )
             => pp(aa(B,bool,ord_less(B,aa(A,B,F,A2)),C1)) ) ) ) ) ).

tff(fact_63_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,ord_less(A,X),Y))
         => ? [Z: A] :
              ( pp(aa(A,bool,ord_less(A,X),Z))
              & pp(aa(A,bool,ord_less(A,Z),Y)) ) ) ) ).

tff(fact_64_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [Y2: A] : pp(aa(A,bool,ord_less(A,Y2),X)) ) ).

tff(fact_65_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X1: A] :
        ? [X11: A] : pp(aa(A,bool,ord_less(A,X1),X11)) ) ).

tff(fact_66_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_67_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A1))
       => ( sublist(A,cons(A,X1,nil(A)),A1) = cons(A,X1,nil(A)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A1))
       => ( sublist(A,cons(A,X1,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_68_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_69_sublist__empty,axiom,
    ! [A: $tType,Xsa: list(A)] : ( sublist(A,Xsa,bot_bot(fun(nat,bool))) = nil(A) ) ).

tff(fact_70_notin__set__sublistI,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),X1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,sublist(A,Xsa,I)))) ) ).

tff(fact_71_in__set__sublistD,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,sublist(A,Xsa,I))))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa))) ) ).

tff(fact_72_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
          & pp(aa(A,bool,P1,X3))
          & ! [Y1: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa)))
                & pp(aa(A,bool,P1,Y1)) )
             => ( Y1 = X3 ) ) ) ) ).

tff(fact_73_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),Na)) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_less__nat__zero__code,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),zero_zero(nat))) ).

tff(fact_78_less__zeroE,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),zero_zero(nat))) ).

tff(fact_79_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( pp(aa(nat,bool,ord_less(nat,M1),Na))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( pp(aa(nat,bool,ord_less(nat,Na),M1))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_80_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,ord_less(nat,S),T))
     => ( S != T ) ) ).

tff(fact_81_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,ord_less(nat,N),M))
     => ( M != N ) ) ).

tff(fact_82_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),N)) ).

tff(fact_83_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ pp(aa(nat,bool,ord_less(nat,X),Y))
       => pp(aa(nat,bool,ord_less(nat,Y),X)) ) ) ).

tff(fact_84_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( pp(aa(nat,bool,ord_less(nat,M1),Na))
        | pp(aa(nat,bool,ord_less(nat,Na),M1)) ) ) ).

tff(fact_85_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),N)) ).

tff(fact_86_bot__nat__def,axiom,
    bot_bot(nat) = zero_zero(nat) ).

tff(fact_87_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),N)) ) ).

tff(fact_88_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),N))
     => ( N != zero_zero(nat) ) ) ).

tff(fact_89_not__less0,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),zero_zero(nat))) ).

tff(fact_90_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X1: A,P1: fun(A,bool)] :
      ( list_ex1(A,P1,cons(A,X1,Xsa))
    <=> ( ( pp(aa(A,bool,P1,X1))
         => list_all(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combb(bool,bool,A,fNot,P1)),fequal(A,X1)),Xsa) )
        & ( ~ pp(aa(A,bool,P1,X1))
         => list_ex1(A,P1,Xsa) ) ) ) ).

tff(fact_91_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat] :
          ( pp(aa(A,bool,ord_less(A,zero_zero(A)),semiring_1_of_nat(A,Na)))
        <=> pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),Na)) ) ) ).

tff(fact_92_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [Na: nat,M1: nat] :
          ( ( semiring_1_of_nat(A,M1) = semiring_1_of_nat(A,Na) )
        <=> ( M1 = Na ) ) ) ).

tff(fact_93_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xsa: list(A),X1: A,P1: fun(A,bool)] :
      ( list_all(A,P1,cons(A,X1,Xsa))
    <=> ( pp(aa(A,bool,P1,X1))
        & list_all(A,P1,Xsa) ) ) ).

tff(fact_94_list__all__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : list_all(A,P1,nil(A)) ).

tff(fact_95_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_96_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M1: nat] :
          ( pp(aa(A,bool,ord_less(A,semiring_1_of_nat(A,M1)),semiring_1_of_nat(A,Na)))
        <=> pp(aa(nat,bool,ord_less(nat,M1),Na)) ) ) ).

tff(fact_97_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ pp(aa(A,bool,ord_less(A,semiring_1_of_nat(A,M)),zero_zero(A))) ) ).

tff(fact_98_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( pp(aa(nat,bool,ord_less(nat,M),N))
         => pp(aa(A,bool,ord_less(A,semiring_1_of_nat(A,M)),semiring_1_of_nat(A,N))) ) ) ).

%----Arities (26)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (18)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,fequal(A,X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,fequal(A,X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,combb(bool,fun(list(int),bool),int,combk(bool,list(int)),ord_less(int,zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)))))) = bot_bot(fun(atom,bool)) ).

%------------------------------------------------------------------------------
