%------------------------------------------------------------------------------
% File     : COM055_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 117
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_117 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  182 (  64 unt;  57 typ;   0 def)
%            Number of atoms       :  236 ( 125 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  151 (  40   ~;   8   |;  12   &)
%                                         (  24 <=>;  67  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   56 (  32   >;  24   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   1 prp; 0-5 aty)
%            Number of functors    :   43 (  43 usr;   8 con; 0-5 aty)
%            Number of variables   :  377 ( 326   !;  11   ?; 377   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:20
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (49)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) * list(A) ) > T1 ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T1: $tType] : ( ( fun(int,fun(list(int),T1)) * fun(int,fun(int,fun(list(int),T1))) * fun(int,fun(int,fun(list(int),T1))) ) > fun(atom,T1) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff1,type,
    hd_coeff1: int > fun(atom,atom) ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Ohd__coeffs1,type,
    qEpres1907640072oeffs1: list(atom) > list(atom) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_thesis____,type,
    thesis: $o ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (98)
tff(fact_0__096lbounds_Aas_A_061_A_091_093_096,axiom,
    lbounds(as) = nil(product_prod(int,list(int))) ).

tff(fact_1__096Z_OI_A_Iqe__pres_092_060_094isub_0621_Aas_J_Axs_096,axiom,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

tff(fact_2_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( aa(atom,int,divisor,X4) != zero_zero(int) ) ) ).

tff(fact_3_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,fun(A,bool),bool,member(A),set(A,Xsa))),P1)) ) ).

tff(fact_4_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,X1))
       => ( filter(A,P1,cons(A,X1,Xsa)) = cons(A,X1,filter(A,P1,Xsa)) ) )
      & ( ~ pp(aa(A,bool,P1,X1))
       => ( filter(A,P1,cons(A,X1,Xsa)) = filter(A,P1,Xsa) ) ) ) ).

tff(fact_5_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),set(B,Xsa)))
         => ( aa(B,A,F,X3) = aa(B,A,G,X3) ) ) ) ).

tff(fact_6_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),X1: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X1,Xsa)) = cons(A,aa(B,A,F,X1),map(B,A,F,Xsa)) ) ).

tff(fact_7_filter__filter,axiom,
    ! [A: $tType,Xsa: list(A),Q1: fun(A,bool),P1: fun(A,bool)] : ( filter(A,P1,filter(A,Q1,Xsa)) = filter(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,Q1),P1),Xsa) ) ).

tff(fact_8_map__ident,axiom,
    ! [A: $tType,X4: list(A)] : ( map(A,A,combi(A),X4) = X4 ) ).

tff(fact_9_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A6: A,List: list(A),A4: A] :
      ( ( cons(A,A4,List) = cons(A,A6,List1) )
    <=> ( ( A4 = A6 )
        & ( List = List1 ) ) ) ).

tff(fact_10_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
         => pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_11_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X1: A,Y2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,cons(A,X1,Xsa))))
     => ( ( Y2 = X1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa))) ) ) ).

tff(fact_12_I__cyclic,axiom,
    ! [E: list(int),J: int,I2: int,A4: atom] :
      ( pp(aa(atom,bool,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),A4))
     => ( ( aa(atom,int,hd_coeff,A4) = one_one(int) )
       => ( ( div_mod(int,I2,aa(atom,int,divisor,A4)) = div_mod(int,J,aa(atom,int,divisor,A4)) )
         => ( pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,A4),cons(int,I2,E)))
          <=> pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,A4),cons(int,J,E))) ) ) ) ) ).

tff(fact_13_filter__empty__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = nil(A) )
    <=> ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_14_filter__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Ys1)))
           => ( pp(aa(A,bool,P1,X))
            <=> pp(aa(A,bool,Q1,X)) ) )
       => ( filter(A,P1,Xsa) = filter(A,Q1,Ys1) ) ) ) ).

tff(fact_15_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = nil(A) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_16_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_17_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xsa) )
    <=> ( Xsa = nil(B) ) ) ).

tff(fact_18_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( filter(A,P1,nil(A)) = nil(A) ) ).

tff(fact_19_list_Osimps_I3_J,axiom,
    ! [A: $tType,List3: list(A),A5: A] : ( cons(A,A5,List3) != nil(A) ) ).

tff(fact_20_list_Osimps_I2_J,axiom,
    ! [A: $tType,List3: list(A),A5: A] : ( nil(A) != cons(A,A5,List3) ) ).

tff(fact_21_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] : ( cons(A,X2,Xs1) != Xs1 ) ).

tff(fact_22_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs1: list(A)] : ( Xs1 != cons(A,X2,Xs1) ) ).

tff(fact_23_mod__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,one_one(A)) = zero_zero(A) ) ) ).

tff(fact_24_zlcms_Osimps_I1_J,axiom,
    zlcms(nil(int)) = one_one(int) ).

tff(fact_25_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_26_zmod__zero,axiom,
    ! [B1: int] : ( div_mod(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_27_zmod__self,axiom,
    ! [A1: int] : ( div_mod(int,A1,A1) = zero_zero(int) ) ).

tff(fact_28_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_29_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_30_filter__False,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X)) )
     => ( filter(A,P1,Xsa) = nil(A) ) ) ).

tff(fact_31_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,div_mod(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_32_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_33_neg__mod__bound,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,B1,zero_zero(int))
     => ord_less(int,B1,div_mod(int,A1,B1)) ) ).

tff(fact_34_pos__mod__bound,axiom,
    ! [A1: int,B1: int] :
      ( ord_less(int,zero_zero(int),B1)
     => ord_less(int,div_mod(int,A1,B1),B1) ) ).

tff(fact_35_zlcms__pos,axiom,
    ! [Is: list(int)] :
      ( ! [X: int] :
          ( pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),X),set(int,Is)))
         => ( X != zero_zero(int) ) )
     => ord_less(int,zero_zero(int),zlcms(Is)) ) ).

tff(fact_36_I__hd__coeffs1,axiom,
    ! [Xsa: list(int),Asa: list(atom)] :
      ( ! [X: atom] :
          ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),set(atom,Asa)))
         => ( aa(atom,int,hd_coeff,X) != zero_zero(int) ) )
     => ( ? [X3: int] :
          ! [Xa: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa),set(atom,qEpres1907640072oeffs1(Asa))))
           => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa),cons(int,X3,Xsa))) )
      <=> ? [X3: int] :
          ! [Xa: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa),set(atom,Asa)))
           => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa),cons(int,X3,Xsa))) ) ) ) ).

tff(fact_37_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_38_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_39_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X3: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X3),set(fm(atom),Fs)))
         => interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_40_filter__True,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => pp(aa(A,bool,P1,X)) )
     => ( filter(A,P1,Xsa) = Xsa ) ) ).

tff(fact_41_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X2: A] :
          ( ( X2 != Y )
         => ( ~ ord_less(A,X2,Y)
           => ord_less(A,Y,X2) ) ) ) ).

tff(fact_42_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_43_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_44_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X3: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X3),set(fm(atom),Fs)))
          & interpret(atom,int,i_Z,X3,Xsa) ) ) ).

tff(fact_45_hd__coeffs1__def,axiom,
    ! [Asa: list(atom)] : ( qEpres1907640072oeffs1(Asa) = cons(atom,dvd(zlcms(map(atom,int,hd_coeff,Asa)),zero_zero(int),cons(int,one_one(int),nil(int))),map(atom,atom,hd_coeff1(zlcms(map(atom,int,hd_coeff,Asa))),Asa)) ) ).

tff(fact_46_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Ys1)))
           => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
       => ( map(A,B,F,Xsa) = map(A,B,G,Ys1) ) ) ) ).

tff(fact_47_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,A,F,X) = X ) )
     => ( map(A,A,F,Xsa) = Xsa ) ) ).

tff(fact_48_atom_Osimps_I2_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int2: int,Int1: int] :
      ( ( dvd(Int1,Int2,List) = dvd(Int11,Int21,List1) )
    <=> ( ( Int1 = Int11 )
        & ( Int2 = Int21 )
        & ( List = List1 ) ) ) ).

tff(fact_49_hd__coeff1_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_50_divisor_Osimps_I2_J,axiom,
    ! [Ks1: list(int),I1: int,D1: int] : ( aa(atom,int,divisor,dvd(D1,I1,Ks1)) = D1 ) ).

tff(fact_51_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),dvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int1),Int2),List) ) ).

tff(fact_52_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_53_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_54_hd__coeff_Osimps_I2_J,axiom,
    ! [Ks2: list(int),I2: int,D: int] : ( aa(atom,int,hd_coeff,dvd(D,I2,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_55_atom_Osize_I2_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( atom_size(dvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_56_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys1: list(B)] :
      ( ? [Xs: list(A)] : ( Ys1 = map(A,B,F,Xs) )
    <=> ! [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),set(B,Ys1)))
         => ? [Xa: A] : ( X3 = aa(A,B,F,Xa) ) ) ) ).

tff(fact_57_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
     => ( map(A,B,F,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_58_mod__less__divisor,axiom,
    ! [M: nat,N1: nat] :
      ( ord_less(nat,zero_zero(nat),N1)
     => ord_less(nat,div_mod(nat,M,N1),N1) ) ).

tff(fact_59_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A4: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A4,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A4),List) ) ).

tff(fact_60_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_61_atom_Osize_I5_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( size_size(atom,dvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_62_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_63_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_64_neq0__conv,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N2) ) ).

tff(fact_65_mod__less,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less(nat,M,N1)
     => ( div_mod(nat,M,N1) = M ) ) ).

tff(fact_66_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_67_nat__neq__iff,axiom,
    ! [N2: nat,M1: nat] :
      ( ( M1 != N2 )
    <=> ( ord_less(nat,M1,N2)
        | ord_less(nat,N2,M1) ) ) ).

tff(fact_68_linorder__neqE__nat,axiom,
    ! [Y: nat,X2: nat] :
      ( ( X2 != Y )
     => ( ~ ord_less(nat,X2,Y)
       => ord_less(nat,Y,X2) ) ) ).

tff(fact_69_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_70_less__not__refl2,axiom,
    ! [M: nat,N1: nat] :
      ( ord_less(nat,N1,M)
     => ( M != N1 ) ) ).

tff(fact_71_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_72_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N2: nat,M1: nat] :
      ( ( ord_less(nat,M1,N2)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M1)) )
     => ( ( ( M1 = N2 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M1)) )
       => ( ( ord_less(nat,N2,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N2),M1)) ) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A3))
    <=> pp(aa(A,bool,A3,X1)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_77_gr__implies__not0,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less(nat,M,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_78_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_79_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),F: fun(B,A),Xsa: list(A),X1: A] :
      ( ( cons(A,X1,Xsa) = map(B,A,F,Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys1 = cons(B,Z,Zs) )
          & ( X1 = aa(B,A,F,Z) )
          & ( Xsa = map(B,A,F,Zs) ) ) ) ).

tff(fact_80_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys1: list(A),Y2: A,Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = cons(A,Y2,Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xsa = cons(B,Z,Zs) )
          & ( aa(B,A,F,Z) = Y2 )
          & ( map(B,A,F,Zs) = Ys1 ) ) ) ).

tff(fact_81_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys: list(A)] : ( Xsa = cons(A,Y1,Ys) ) ) ).

tff(fact_82_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List4: list(A)] : ( Y != cons(A,A2,List4) ) ) ).

tff(fact_83_hd__coeff_Osimps_I1_J,axiom,
    ! [Ks2: list(int),I2: int] : ( aa(atom,int,hd_coeff,c_PresArith_Oatom_OLe(I2,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_84_atom_Osimps_I1_J,axiom,
    ! [List1: list(int),Int4: int,List: list(int),Int3: int] :
      ( ( c_PresArith_Oatom_OLe(Int3,List) = c_PresArith_Oatom_OLe(Int4,List1) )
    <=> ( ( Int3 = Int4 )
        & ( List = List1 ) ) ) ).

tff(fact_85_divisor_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( aa(atom,int,divisor,c_PresArith_Oatom_OLe(I1,Ks1)) = one_one(int) ) ).

tff(fact_86_hd__coeff1_Osimps_I4_J,axiom,
    ! [V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_87_atom_Osize_I4_J,axiom,
    ! [List2: list(int),Int: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int,List2)) = zero_zero(nat) ) ).

tff(fact_88_atom_Osize_I1_J,axiom,
    ! [List2: list(int),Int: int] : ( atom_size(c_PresArith_Oatom_OLe(Int,List2)) = zero_zero(nat) ) ).

tff(fact_89_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),c_PresArith_Oatom_OLe(Int3,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int3),List) ) ).

tff(fact_90_atom_Osimps_I5_J,axiom,
    ! [List2: list(int),Int: int,List3: list(int),Int22: int,Int12: int] : ( dvd(Int12,Int22,List3) != c_PresArith_Oatom_OLe(Int,List2) ) ).

tff(fact_91_atom_Osimps_I4_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List2: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List2) != dvd(Int12,Int22,List3) ) ).

tff(fact_92_hd__coeff_Osimps_I3_J,axiom,
    ! [Ks2: list(int),I2: int,D: int] : ( aa(atom,int,hd_coeff,nDvd(D,I2,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_93_asubst_Osimps_I4_J,axiom,
    ! [V: int,Ks: list(int),I: int] : ( asubst(I,Ks,c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_94_atom_Osimps_I3_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int2: int,Int1: int] :
      ( ( nDvd(Int1,Int2,List) = nDvd(Int11,Int21,List1) )
    <=> ( ( Int1 = Int11 )
        & ( Int2 = Int21 )
        & ( List = List1 ) ) ) ).

tff(fact_95_divisor__asubst,axiom,
    ! [A1: atom,Ks1: list(int),I1: int] : ( aa(atom,int,divisor,asubst(I1,Ks1,A1)) = aa(atom,int,divisor,A1) ) ).

tff(fact_96_asubst_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Ks: list(int),I: int] : ( asubst(I,Ks,dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_97_asubst_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Ks: list(int),I: int] : ( asubst(I,Ks,nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

%----Arities (11)
tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Divides_Osemiring__div,axiom,
    semiring_div(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [N: int] :
      ( ord_less(int,N,zlcms(map(atom,int,divisor,filter(atom,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))),as))))
     => ( ! [X: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))))))))
           => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,X),cons(int,N,xs))) )
       => thesis ) ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
