%------------------------------------------------------------------------------
% File     : COM054_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 112
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_112 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  171 (  47 unt;  55 typ;   0 def)
%            Number of atoms       :  252 (  98 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  180 (  44   ~;  17   |;  20   &)
%                                         (  36 <=>;  63  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   6 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   77 (  39   >;  38   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-7 aty)
%            Number of functors    :   45 (  45 usr;   8 con; 0-6 aty)
%            Number of variables   :  514 ( 455   !;  11   ?; 514   :)
%                                         (  48  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:12
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (49)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_GCD_OGcd__class_OLcm,type,
    gcd_Lcm: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_GCD_Ogcd__class_Olcm,type,
    gcd_lcm: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert1: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oremdups,type,
    remdups: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Logic_OATOM,type,
    atom1: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fm(A)) * fun(A,bool) * fun(A,fun(list(B),bool)) * fun(A,bool) * fun(A,A) ) > $o ) ).

tff(sy_c_Logic_OATOM_Onormal,type,
    normal: 
      !>[A: $tType] : ( ( fun(A,bool) * fm(A) ) > $o ) ).

tff(sy_c_Logic_Oamap__fm,type,
    amap_fm: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fm(B)) * fm(A) ) > fm(B) ) ).

tff(sy_c_Logic_Oand,type,
    c_Logic_Oand: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OAnd,type,
    c_Logic_Ofm_OAnd: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OExQ,type,
    exQ: 
      !>[A: $tType] : ( fm(A) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OOr,type,
    c_Logic_Ofm_OOr: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Oor,type,
    c_Logic_Oor: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QE_OATOM_Olift__dnf__qe,type,
    lift_dnf_qe: 
      !>[A: $tType] : ( ( fun(A,fm(A)) * fun(A,bool) * fun(A,A) * fun(list(A),fm(A)) * fm(A) ) > fm(A) ) ).

tff(sy_c_QE_OATOM_Olift__nnf__qe,type,
    lift_nnf_qe: 
      !>[A: $tType] : ( ( fun(A,fm(A)) * fun(fm(A),fm(A)) * fm(A) ) > fm(A) ) ).

tff(sy_c_QE_OATOM_Oqelim,type,
    qelim: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(A,A) * fun(list(A),fm(A)) * list(A) ) > fm(A) ) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),A4: A] :
      ( ( cons(A,A4,List2) = cons(A,A6,List3) )
    <=> ( ( A4 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_1_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X2: A,Y2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,cons(A,X2,Xsa))))
     => ( ( Y2 = X2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa))) ) ) ).

tff(fact_2_norm,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_3_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] : ( Xs != cons(A,X1,Xs) ) ).

tff(fact_4_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( cons(A,X1,Xs) != Xs ) ).

tff(fact_5_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( insert1(A,X2,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( insert1(A,X2,Xsa) = cons(A,X2,Xsa) ) ) ) ).

tff(fact_6_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
     => ( insert1(A,X2,Xsa) = cons(A,X2,Xsa) ) ) ).

tff(fact_7_interpret_Osimps_I7_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,exQ(A,Phi),Xsa)
    <=> ? [X: B] : interpret(A,B,H,Phi,cons(B,X,Xsa)) ) ).

tff(fact_8_remdups_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( remdups(A,cons(A,X2,Xsa)) = remdups(A,Xsa) ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
       => ( remdups(A,cons(A,X2,Xsa)) = cons(A,X2,remdups(A,Xsa)) ) ) ) ).

tff(fact_9_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A4: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A4,List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A4),List2) ) ).

tff(fact_10_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] : ( set(A,cons(A,X2,Xsa)) = insert(A,X2,set(A,Xsa)) ) ).

tff(fact_11_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( distinct(A,cons(A,X2,Xsa))
    <=> ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
        & distinct(A,Xsa) ) ) ).

tff(fact_12_fm_Osimps_I5_J,axiom,
    ! [A: $tType,Fm4: fm(A),Fm3: fm(A)] :
      ( ( exQ(A,Fm3) = exQ(A,Fm4) )
    <=> ( Fm3 = Fm4 ) ) ).

tff(fact_13_set__remdups,axiom,
    ! [A: $tType,Xsa: list(A)] : ( set(A,remdups(A,Xsa)) = set(A,Xsa) ) ).

tff(fact_14_distinct__remdups,axiom,
    ! [A: $tType,Xs: list(A)] : distinct(A,remdups(A,Xs)) ).

tff(fact_15_remdups__id__iff__distinct,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( remdups(A,Xsa) = Xsa )
    <=> distinct(A,Xsa) ) ).

tff(fact_16_List_Oset__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] : ( set(A,insert1(A,X2,Xsa)) = insert(A,X2,set(A,Xsa)) ) ).

tff(fact_17_remdups__remdups,axiom,
    ! [A: $tType,Xs: list(A)] : ( remdups(A,remdups(A,Xs)) = remdups(A,Xs) ) ).

tff(fact_18_insert__remdups,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( insert1(A,X1,remdups(A,Xs)) = remdups(A,insert1(A,X1,Xs)) ) ).

tff(fact_19_distinct__insert,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] :
      ( distinct(A,Xs)
     => distinct(A,insert1(A,X1,Xs)) ) ).

tff(fact_20_distinct__remdups__id,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( distinct(A,Xs)
     => ( remdups(A,Xs) = Xs ) ) ).

tff(fact_21_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xsa: list(A),B4: A,A4: A] :
      ( distinct(A,cons(A,A4,cons(A,B4,Xsa)))
    <=> ( ( A4 != B4 )
        & distinct(A,cons(A,A4,Xsa))
        & distinct(A,cons(A,B4,Xsa)) ) ) ).

tff(fact_22_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
     => ( insert1(A,X2,Xsa) = Xsa ) ) ).

tff(fact_23_insert__absorb2,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] : ( insert(A,X2,insert(A,X2,A2)) = insert(A,X2,A2) ) ).

tff(fact_24_insert__iff,axiom,
    ! [A: $tType,A2: fun(A,bool),B4: A,A4: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),insert(A,B4,A2)))
    <=> ( ( A4 = B4 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),A2)) ) ) ).

tff(fact_25_insertE,axiom,
    ! [A: $tType,A2: fun(A,bool),B4: A,A4: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),insert(A,B4,A2)))
     => ( ( A4 != B4 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),A2)) ) ) ).

tff(fact_26_insertCI,axiom,
    ! [A: $tType,B4: A,B3: fun(A,bool),A4: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),B3))
       => ( A4 = B4 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),insert(A,B4,B3))) ) ).

tff(fact_27_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs: list(A),X1: A] : ( splice(A,cons(A,X1,Xs),cons(A,Y,Ys1)) = cons(A,X1,cons(A,Y,splice(A,Xs,Ys1))) ) ).

tff(fact_28_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X),set(fm(atom),Fs)))
         => interpret(atom,int,i_Z,X,Xsa) ) ) ).

tff(fact_29_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A4: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,A4,List2)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A4),List2),list_rec(A,B,F1,F2,List2)) ) ).

tff(fact_30_insertI1,axiom,
    ! [A: $tType,B3: fun(A,bool),A4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),insert(A,A4,B3))) ).

tff(fact_31_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_32_insert__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool),A4: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),A2))
     => ( insert(A,A4,A2) = A2 ) ) ).

tff(fact_33_insertI2,axiom,
    ! [A: $tType,B4: A,B3: fun(A,bool),A4: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),B3))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),insert(A,B4,B3))) ) ).

tff(fact_34_insert__eq__iff,axiom,
    ! [A: $tType,B3: fun(A,bool),B4: A,A2: fun(A,bool),A4: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B4),B3))
       => ( ( insert(A,A4,A2) = insert(A,B4,B3) )
        <=> ( ( ( A4 = B4 )
             => ( A2 = B3 ) )
            & ( ( A4 != B4 )
             => ? [C2: fun(A,bool)] :
                  ( ( A2 = insert(A,B4,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B4),C2))
                  & ( B3 = insert(A,A4,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),C2)) ) ) ) ) ) ) ).

tff(fact_35_insert__ident,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B3))
       => ( ( insert(A,X2,A2) = insert(A,X2,B3) )
        <=> ( A2 = B3 ) ) ) ) ).

tff(fact_36_insert__code,axiom,
    ! [A: $tType,X2: A,A2: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,A2),X2))
    <=> ( ( Y2 = X2 )
        | pp(aa(A,bool,A2,X2)) ) ) ).

tff(fact_37_insert__commute,axiom,
    ! [A: $tType,A2: fun(A,bool),Y2: A,X2: A] : ( insert(A,X2,insert(A,Y2,A2)) = insert(A,Y2,insert(A,X2,A2)) ) ).

tff(fact_38_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A4: A] : ( insert(A,A4,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A4))),P1)) ) ).

tff(fact_39_insert__compr,axiom,
    ! [A: $tType,B3: fun(A,bool),A4: A] : ( insert(A,A4,B3) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A4)),combc(A,fun(A,bool),bool,member(A),B3))) ) ).

tff(fact_40_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X),set(fm(atom),Fs)))
          & interpret(atom,int,i_Z,X,Xsa) ) ) ).

tff(fact_41_Set_Oset__insert,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
     => ~ ! [B2: fun(A,bool)] :
            ( ( A2 = insert(A,X2,B2) )
           => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_42_mk__disjoint__insert,axiom,
    ! [A: $tType,A2: fun(A,bool),A4: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),A2))
     => ? [B2: fun(A,bool)] :
          ( ( A2 = insert(A,A4,B2) )
          & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A4),B2)) ) ) ).

tff(fact_43_ATOM_OI__list__conj,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Fs: list(fm(A)),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( interpret(A,B,I_a,list_conj(A,Fs),Xsa)
      <=> ! [X: fm(A)] :
            ( pp(aa(fun(fm(A),bool),bool,aa(fm(A),fun(fun(fm(A),bool),bool),member(fm(A)),X),set(fm(A),Fs)))
           => interpret(A,B,I_a,X,Xsa) ) ) ) ).

tff(fact_44_divisor__asubst,axiom,
    ! [A1: atom,Ks: list(int),I: int] : ( divisor(asubst(I,Ks,A1)) = divisor(A1) ) ).

tff(fact_45_zlcms0__iff,axiom,
    ! [Is1: list(int)] :
      ( ( zlcms(Is1) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is1))) ) ).

tff(fact_46_ATOM_Oanormal__decr,axiom,
    ! [B: $tType,A: $tType,A4: A,Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( ~ pp(aa(A,bool,Depends_0,A4))
       => ( pp(aa(A,bool,Anormal,A4))
         => pp(aa(A,bool,Anormal,aa(A,A,Decr,A4))) ) ) ) ).

tff(fact_47_ATOM_Onot__dep__decr,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),X2: B,A4: A,Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( ~ pp(aa(A,bool,Depends_0,A4))
       => ( pp(aa(list(B),bool,aa(A,fun(list(B),bool),I_a,A4),cons(B,X2,Xsa)))
        <=> pp(aa(list(B),bool,aa(A,fun(list(B),bool),I_a,aa(A,A,Decr,A4)),Xsa)) ) ) ) ).

tff(fact_48_ATOM_OI_092_060_094isub_062a__aneg,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),A4: A,Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( interpret(A,B,I_a,aa(A,fm(A),Aneg,A4),Xsa)
      <=> ~ pp(aa(list(B),bool,aa(A,fun(list(B),bool),I_a,A4),Xsa)) ) ) ).

tff(fact_49_ATOM_OI__list__disj,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Fs: list(fm(A)),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( interpret(A,B,I_a,list_disj(A,Fs),Xsa)
      <=> ? [X: fm(A)] :
            ( pp(aa(fun(fm(A),bool),bool,aa(fm(A),fun(fun(fm(A),bool),bool),member(fm(A)),X),set(fm(A),Fs)))
            & interpret(A,B,I_a,X,Xsa) ) ) ) ).

tff(fact_50_zlcms_Osimps_I2_J,axiom,
    ! [Is: list(int),I: int] : ( zlcms(cons(int,I,Is)) = gcd_lcm(int,I,zlcms(Is)) ) ).

tff(fact_51_ATOM_OI__qelim,axiom,
    ! [A: $tType,B: $tType,Asa: list(A),Qe: fun(list(A),fm(A)),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( ! [As: list(A)] :
            ( ! [X4: A] :
                ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),set(A,As)))
               => pp(aa(A,bool,Depends_0,X4)) )
           => ! [Xs2: list(B)] :
                ( interpret(A,B,I_a,aa(list(A),fm(A),Qe,As),Xs2)
              <=> ? [X: B] :
                  ! [Xa: A] :
                    ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,As)))
                   => pp(aa(list(B),bool,aa(A,fun(list(B),bool),I_a,Xa),cons(B,X,Xs2))) ) ) )
       => ! [Xs1: list(B)] :
            ( interpret(A,B,I_a,qelim(A,Depends_0,Decr,Qe,Asa),Xs1)
          <=> ? [X: B] :
              ! [Xa: A] :
                ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Asa)))
               => pp(aa(list(B),bool,aa(A,fun(list(B),bool),I_a,Xa),cons(B,X,Xs1))) ) ) ) ) ).

tff(fact_52_ATOM_Onormal__list__disj,axiom,
    ! [B: $tType,A: $tType,Fs: list(fm(A)),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( ! [X3: fm(A)] :
            ( pp(aa(fun(fm(A),bool),bool,aa(fm(A),fun(fun(fm(A),bool),bool),member(fm(A)),X3),set(fm(A),Fs)))
           => normal(A,Anormal,X3) )
       => normal(A,Anormal,list_disj(A,Fs)) ) ) ).

tff(fact_53_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert1(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_54_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_55_remdups__eq__nil__iff,axiom,
    ! [A: $tType,X2: list(A)] :
      ( ( remdups(A,X2) = nil(A) )
    <=> ( X2 = nil(A) ) ) ).

tff(fact_56_remdups__eq__nil__right__iff,axiom,
    ! [A: $tType,X2: list(A)] :
      ( ( nil(A) = remdups(A,X2) )
    <=> ( X2 = nil(A) ) ) ).

tff(fact_57_remdups_Osimps_I1_J,axiom,
    ! [A: $tType] : ( remdups(A,nil(A)) = nil(A) ) ).

tff(fact_58_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_59_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_60_ATOM_Onormal__aneg,axiom,
    ! [B: $tType,A: $tType,A4: A,Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( pp(aa(A,bool,Anormal,A4))
       => normal(A,Anormal,aa(A,fm(A),Aneg,A4)) ) ) ).

tff(fact_61_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_62_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_63_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_64_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_65_distinct__singleton,axiom,
    ! [A: $tType,X1: A] : distinct(A,cons(A,X1,nil(A))) ).

tff(fact_66_ATOM_Onormal__simps_I7_J,axiom,
    ! [B: $tType,A: $tType,Phi: fm(A),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( normal(A,Anormal,exQ(A,Phi))
      <=> normal(A,Anormal,Phi) ) ) ).

tff(fact_67_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_68_lcm__0__left__int,axiom,
    ! [N2: int] : ( gcd_lcm(int,zero_zero(int),N2) = zero_zero(int) ) ).

tff(fact_69_lcm__0__int,axiom,
    ! [M1: int] : ( gcd_lcm(int,M1,zero_zero(int)) = zero_zero(int) ) ).

tff(fact_70_lcm__0__iff__int,axiom,
    ! [N: int,M: int] :
      ( ( gcd_lcm(int,M,N) = zero_zero(int) )
    <=> ( ( M = zero_zero(int) )
        | ( N = zero_zero(int) ) ) ) ).

tff(fact_71_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List: list(A)] : ( Y != cons(A,A3,List) ) ) ).

tff(fact_72_lcm__commute__int,axiom,
    ! [B1: int,A1: int] : ( gcd_lcm(int,A1,B1) = gcd_lcm(int,B1,A1) ) ).

tff(fact_73_lcm__int_Oleft__commute,axiom,
    ! [C1: int,A1: int,B1: int] : ( gcd_lcm(int,B1,gcd_lcm(int,A1,C1)) = gcd_lcm(int,A1,gcd_lcm(int,B1,C1)) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
    <=> pp(aa(A,bool,A2,X2)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_lcm__assoc__int,axiom,
    ! [C1: int,B1: int,A1: int] : ( gcd_lcm(int,gcd_lcm(int,A1,B1),C1) = gcd_lcm(int,A1,gcd_lcm(int,B1,C1)) ) ).

tff(fact_78_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys: list(A)] : ( Xsa = cons(A,Y1,Ys) ) ) ).

tff(fact_79_ATOM_Onormal__or,axiom,
    ! [B: $tType,A: $tType,Phi_2: fm(A),Phi_1: fm(A),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( normal(A,Anormal,Phi_1)
       => ( normal(A,Anormal,Phi_2)
         => normal(A,Anormal,c_Logic_Oor(A,Phi_1,Phi_2)) ) ) ) ).

tff(fact_80_ATOM_Onormal__and,axiom,
    ! [B: $tType,A: $tType,Phi_2: fm(A),Phi_1: fm(A),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( normal(A,Anormal,Phi_1)
       => ( normal(A,Anormal,Phi_2)
         => normal(A,Anormal,c_Logic_Oand(A,Phi_1,Phi_2)) ) ) ) ).

tff(fact_81_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_82_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
          & pp(aa(A,bool,P1,X))
          & ! [Y1: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa)))
                & pp(aa(A,bool,P1,Y1)) )
             => ( Y1 = X ) ) ) ) ).

tff(fact_83_Lcm__insert__int,axiom,
    ! [N1: fun(int,bool),N: int] : ( gcd_Lcm(int,insert(int,N,N1)) = gcd_lcm(int,N,gcd_Lcm(int,N1)) ) ).

tff(fact_84_ATOM_OI__and,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi_2: fm(A),Phi_1: fm(A),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( interpret(A,B,I_a,c_Logic_Oand(A,Phi_1,Phi_2),Xsa)
      <=> interpret(A,B,I_a,c_Logic_Ofm_OAnd(A,Phi_1,Phi_2),Xsa) ) ) ).

tff(fact_85_fm_Osimps_I2_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),Fm2: fm(A),Fm1: fm(A)] :
      ( ( c_Logic_Ofm_OAnd(A,Fm1,Fm2) = c_Logic_Ofm_OAnd(A,Fm11,Fm21) )
    <=> ( ( Fm1 = Fm11 )
        & ( Fm2 = Fm21 ) ) ) ).

tff(fact_86_interpret_Osimps_I4_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi_2: fm(A),Phi_1: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,c_Logic_Ofm_OAnd(A,Phi_1,Phi_2),Xsa)
    <=> ( interpret(A,B,H,Phi_1,Xsa)
        & interpret(A,B,H,Phi_2,Xsa) ) ) ).

tff(fact_87_Z_OI__and,axiom,
    ! [Xsa: list(int),Phi_2: fm(atom),Phi_1: fm(atom)] :
      ( interpret(atom,int,i_Z,c_Logic_Oand(atom,Phi_1,Phi_2),Xsa)
    <=> interpret(atom,int,i_Z,c_Logic_Ofm_OAnd(atom,Phi_1,Phi_2),Xsa) ) ).

tff(fact_88_fm_Osimps_I41_J,axiom,
    ! [A: $tType,Fm22: fm(A),Fm12: fm(A),Fm: fm(A)] : ( exQ(A,Fm) != c_Logic_Ofm_OAnd(A,Fm12,Fm22) ) ).

tff(fact_89_fm_Osimps_I40_J,axiom,
    ! [A: $tType,Fm: fm(A),Fm22: fm(A),Fm12: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm12,Fm22) != exQ(A,Fm) ) ).

tff(fact_90_ATOM_Onormal__simps_I4_J,axiom,
    ! [B: $tType,A: $tType,Phi_2: fm(A),Phi_1: fm(A),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( normal(A,Anormal,c_Logic_Ofm_OAnd(A,Phi_1,Phi_2))
      <=> ( normal(A,Anormal,Phi_1)
          & normal(A,Anormal,Phi_2) ) ) ) ).

tff(fact_91_amap__fm_Osimps_I4_J,axiom,
    ! [A: $tType,B: $tType,Phi_2: fm(B),Phi_1: fm(B),H: fun(B,fm(A))] : ( amap_fm(B,A,H,c_Logic_Ofm_OAnd(B,Phi_1,Phi_2)) = c_Logic_Oand(A,amap_fm(B,A,H,Phi_1),amap_fm(B,A,H,Phi_2)) ) ).

tff(fact_92_ATOM_Olift__dnf__qe_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Phi_2: fm(A),Phi_1: fm(A),Qe: fun(list(A),fm(A)),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( lift_dnf_qe(A,Aneg,Depends_0,Decr,Qe,c_Logic_Ofm_OAnd(A,Phi_1,Phi_2)) = c_Logic_Oand(A,lift_dnf_qe(A,Aneg,Depends_0,Decr,Qe,Phi_1),lift_dnf_qe(A,Aneg,Depends_0,Decr,Qe,Phi_2)) ) ) ).

tff(fact_93_ATOM_Olift__nnf__qe_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Phi_2: fm(A),Phi_1: fm(A),Qe: fun(fm(A),fm(A)),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( lift_nnf_qe(A,Aneg,Qe,c_Logic_Ofm_OAnd(A,Phi_1,Phi_2)) = c_Logic_Oand(A,lift_nnf_qe(A,Aneg,Qe,Phi_1),lift_nnf_qe(A,Aneg,Qe,Phi_2)) ) ) ).

tff(fact_94_ATOM_Olift__dnf__qe_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Phi_2: fm(A),Phi_1: fm(A),Qe: fun(list(A),fm(A)),Decr: fun(A,A),Depends_0: fun(A,bool),I_a: fun(A,fun(list(B),bool)),Anormal: fun(A,bool),Aneg: fun(A,fm(A))] :
      ( atom1(A,B,Aneg,Anormal,I_a,Depends_0,Decr)
     => ( lift_dnf_qe(A,Aneg,Depends_0,Decr,Qe,c_Logic_Ofm_OOr(A,Phi_1,Phi_2)) = c_Logic_Oor(A,lift_dnf_qe(A,Aneg,Depends_0,Decr,Qe,Phi_1),lift_dnf_qe(A,Aneg,Depends_0,Decr,Qe,Phi_2)) ) ) ).

tff(fact_95_fm_Osimps_I3_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),Fm2: fm(A),Fm1: fm(A)] :
      ( ( c_Logic_Ofm_OOr(A,Fm1,Fm2) = c_Logic_Ofm_OOr(A,Fm11,Fm21) )
    <=> ( ( Fm1 = Fm11 )
        & ( Fm2 = Fm21 ) ) ) ).

tff(fact_96_interpret_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi_2: fm(A),Phi_1: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,c_Logic_Ofm_OOr(A,Phi_1,Phi_2),Xsa)
    <=> ( interpret(A,B,H,Phi_1,Xsa)
        | interpret(A,B,H,Phi_2,Xsa) ) ) ).

tff(fact_97_Z_OI__or,axiom,
    ! [Xsa: list(int),Phi_2: fm(atom),Phi_1: fm(atom)] :
      ( interpret(atom,int,i_Z,c_Logic_Oor(atom,Phi_1,Phi_2),Xsa)
    <=> interpret(atom,int,i_Z,c_Logic_Ofm_OOr(atom,Phi_1,Phi_2),Xsa) ) ).

tff(fact_98_amap__fm_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,Phi_2: fm(B),Phi_1: fm(B),H: fun(B,fm(A))] : ( amap_fm(B,A,H,c_Logic_Ofm_OOr(B,Phi_1,Phi_2)) = c_Logic_Oor(A,amap_fm(B,A,H,Phi_1),amap_fm(B,A,H,Phi_2)) ) ).

%----Arities (1)
tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y))
      | ( X1 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ( X1 != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs)
    <=> ~ ? [X: int] :
          ! [Xa: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa),set(atom,as)))
           => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa),cons(int,X,xs))) ) ) ).

%------------------------------------------------------------------------------
