%------------------------------------------------------------------------------
% File     : COM053_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 110
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_110 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  194 (  68 unt;  56 typ;   0 def)
%            Number of atoms       :  258 ( 130 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  166 (  46   ~;  21   |;  19   &)
%                                         (  25 <=>;  55  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   44 (  25   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   40 (  40 usr;   8 con; 0-5 aty)
%            Number of variables   :  399 ( 350   !;   4   ?; 399   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:10
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (50)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_OThe,type,
    the: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olinorder__class_Oinsort__insert__key,type,
    linord2118332866rt_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * B * list(B) ) > list(B) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert1: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),fun(A,bool))) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

%----Relevant facts (96)
tff(fact_0_hd,axiom,
    ! [X2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X2),aa(list(atom),fun(atom,bool),set(atom),as)))
     => pp(aa(atom,bool,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),hd_coeff(X2)),aa(fun(int,bool),fun(int,bool),aa(int,fun(fun(int,bool),fun(int,bool)),insert1(int),one_one(int)),aa(fun(int,bool),fun(int,bool),aa(int,fun(fun(int,bool),fun(int,bool)),insert1(int),number_number_of(int,min)),bot_bot(fun(int,bool))))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X2)),one_one(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X2)),one_one(int)))))),X2)) ) ).

tff(fact_1_norm,axiom,
    ! [X2: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X2),aa(list(atom),fun(atom,bool),set(atom),as)))
     => ( divisor(X2) != zero_zero(int) ) ) ).

tff(fact_2_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X3: A] :
          ( ( one_one(A) = X3 )
        <=> ( X3 = one_one(A) ) ) ) ).

tff(fact_3_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_4_insort__insert__triv,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xsa: list(A),X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),aa(list(A),fun(A,bool),set(A),Xsa)))
         => ( linord2118332866rt_key(A,A,combi(A),X3,Xsa) = Xsa ) ) ) ).

tff(fact_5_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List2: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),c_PresArith_Oatom_OLe(Int3,List2)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int3),List2) ) ).

tff(fact_6_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List2: list(int),Int22: int,Int12: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),nDvd(Int12,Int22,List2)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int12),Int22),List2) ) ).

tff(fact_7_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List2: list(int),Int22: int,Int12: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( aa(atom,A,atom_case(A,F1,F2,F3),dvd(Int12,Int22,List2)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int12),Int22),List2) ) ).

tff(fact_8_member__set,axiom,
    ! [A: $tType] : ( member1(A) = set(A) ) ).

tff(fact_9_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X5: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),aa(list(A),fun(A,bool),set(A),Xsa)))
          & pp(aa(A,bool,P1,X5))
          & ! [Y3: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y3),aa(list(A),fun(A,bool),set(A),Xsa)))
                & pp(aa(A,bool,P1,Y3)) )
             => ( Y3 = X5 ) ) ) ) ).

tff(fact_10_List_Omember__def,axiom,
    ! [A: $tType,X3: A,Xsa: list(A)] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),X3))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),aa(list(A),fun(A,bool),set(A),Xsa))) ) ).

tff(fact_11_ListMem__iff,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( listMem(A,X3,Xsa)
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),aa(list(A),fun(A,bool),set(A),Xsa))) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y2: int,X3: int] :
          ( ( number_number_of(A,X3) = number_number_of(A,Y2) )
        <=> ( X3 = Y2 ) ) ) ).

tff(fact_13_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z) )
        <=> ( W = Z ) ) ) ).

tff(fact_14_atom_Osimps_I2_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List2: list(int),Int22: int,Int12: int] :
      ( ( dvd(Int12,Int22,List2) = dvd(Int13,Int23,List3) )
    <=> ( ( Int12 = Int13 )
        & ( Int22 = Int23 )
        & ( List2 = List3 ) ) ) ).

tff(fact_15_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int4: int,List2: list(int),Int3: int] :
      ( ( c_PresArith_Oatom_OLe(Int3,List2) = c_PresArith_Oatom_OLe(Int4,List3) )
    <=> ( ( Int3 = Int4 )
        & ( List2 = List3 ) ) ) ).

tff(fact_16_atom_Osimps_I3_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List2: list(int),Int22: int,Int12: int] :
      ( ( nDvd(Int12,Int22,List2) = nDvd(Int13,Int23,List3) )
    <=> ( ( Int12 = Int13 )
        & ( Int22 = Int23 )
        & ( List2 = List3 ) ) ) ).

tff(fact_17_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_18_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_19_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( ring_1_of_int(A,Z) = zero_zero(A) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_20_of__int__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( ring_1_of_int(A,number_number_of(int,V)) = number_number_of(A,V) ) ) ).

tff(fact_21_divisor_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( divisor(c_PresArith_Oatom_OLe(I1,Ks1)) = one_one(int) ) ).

tff(fact_22_of__int__m1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( ring_1_of_int(A,number_number_of(int,min)) = number_number_of(A,min) ) ) ).

tff(fact_23_atom_Osimps_I4_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List) != dvd(Int11,Int21,List1) ) ).

tff(fact_24_atom_Osimps_I6_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List) != nDvd(Int11,Int21,List1) ) ).

tff(fact_25_atom_Osimps_I5_J,axiom,
    ! [List: list(int),Int: int,List1: list(int),Int21: int,Int11: int] : ( dvd(Int11,Int21,List1) != c_PresArith_Oatom_OLe(Int,List) ) ).

tff(fact_26_atom_Osimps_I7_J,axiom,
    ! [List: list(int),Int: int,List1: list(int),Int21: int,Int11: int] : ( nDvd(Int11,Int21,List1) != c_PresArith_Oatom_OLe(Int,List) ) ).

tff(fact_27_atom_Osimps_I8_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int2: int,Int1: int] : ( dvd(Int1,Int2,List) != nDvd(Int11,Int21,List1) ) ).

tff(fact_28_atom_Osimps_I9_J,axiom,
    ! [List: list(int),Int2: int,Int1: int,List1: list(int),Int21: int,Int11: int] : ( nDvd(Int11,Int21,List1) != dvd(Int1,Int2,List) ) ).

tff(fact_29_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_30_number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [K: int] : ( number_number_of(A,K) = ring_1_of_int(A,K) ) ) ).

tff(fact_31_int__number__of__def,axiom,
    ! [W1: int] : ( number_number_of(int,W1) = ring_1_of_int(int,W1) ) ).

tff(fact_32_divisor_Osimps_I2_J,axiom,
    ! [Ks1: list(int),I1: int,D1: int] : ( divisor(dvd(D1,I1,Ks1)) = D1 ) ).

tff(fact_33_divisor_Osimps_I3_J,axiom,
    ! [Ks1: list(int),I1: int,D1: int] : ( divisor(nDvd(D1,I1,Ks1)) = D1 ) ).

tff(fact_34_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X3: A] :
          ( ( zero_zero(A) = X3 )
        <=> ( X3 = zero_zero(A) ) ) ) ).

tff(fact_35_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X3: A,W: int] :
          ( ( number_number_of(A,W) = X3 )
        <=> ( X3 = number_number_of(A,W) ) ) ) ).

tff(fact_36_set__insort__insert,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Xsa: list(A),X3: A] : ( aa(list(A),fun(A,bool),set(A),linord2118332866rt_key(A,A,combi(A),X3,Xsa)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),aa(list(A),fun(A,bool),set(A),Xsa)) ) ) ).

tff(fact_37_in__set__member,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),aa(list(A),fun(A,bool),set(A),Xsa)))
    <=> pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),X3)) ) ).

tff(fact_38_singleton__conv,axiom,
    ! [A: $tType,A1: A] : ( collect(A,combc(A,A,bool,fequal(A),A1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),bot_bot(fun(A,bool))) ) ).

tff(fact_39_singleton__conv2,axiom,
    ! [A: $tType,A1: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),bot_bot(fun(A,bool))) ) ).

tff(fact_40_hd__coeff_Osimps_I3_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( hd_coeff(nDvd(D,I,Ks)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks) ) ).

tff(fact_41_hd__coeff_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( hd_coeff(c_PresArith_Oatom_OLe(I,Ks)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks) ) ).

tff(fact_42_hd__coeff_Osimps_I2_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( hd_coeff(dvd(D,I,Ks)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks) ) ).

tff(fact_43_insert__absorb2,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),A2)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),A2) ) ).

tff(fact_44_insert__iff,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),A2)))
    <=> ( ( A1 = B1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ) ).

tff(fact_45_insertE,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),A2)))
     => ( ( A1 != B1 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ) ).

tff(fact_46_insertCI,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),A1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),B2))
       => ( A1 = B1 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),B2))) ) ).

tff(fact_47_emptyE,axiom,
    ! [A: $tType,A1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),bot_bot(fun(A,bool)))) ).

tff(fact_48_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X5: A] : ~ pp(aa(A,bool,P1,X5)) ) ).

tff(fact_49_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_50_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X5: A] : ~ pp(aa(A,bool,P1,X5)) ) ).

tff(fact_51_all__not__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ! [X5: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),A2))
    <=> ( A2 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_52_equals0D,axiom,
    ! [A: $tType,A1: A,A2: fun(A,bool)] :
      ( ( A2 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ).

tff(fact_53_ex__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ? [X5: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),A2))
    <=> ( A2 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_54_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_55_insert__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2))
     => ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),A2) = A2 ) ) ).

tff(fact_56_insertI2,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),B2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),B2))) ) ).

tff(fact_57_insert__eq__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),B1: A,A2: fun(A,bool),A1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),B2))
       => ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),A2) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),B2) )
        <=> ( ( ( A1 = B1 )
             => ( A2 = B2 ) )
            & ( ( A1 != B1 )
             => ? [C2: fun(A,bool)] :
                  ( ( A2 = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),C2))
                  & ( B2 = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),C2)) ) ) ) ) ) ) ).

tff(fact_58_insert__ident,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B2))
       => ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),A2) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),B2) )
        <=> ( A2 = B2 ) ) ) ) ).

tff(fact_59_insert__code,axiom,
    ! [A: $tType,X3: A,A2: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),Y2),A2),X3))
    <=> ( ( Y2 = X3 )
        | pp(aa(A,bool,A2,X3)) ) ) ).

tff(fact_60_insert__commute,axiom,
    ! [A: $tType,A2: fun(A,bool),Y2: A,X3: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),Y2),A2)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),Y2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),A2)) ) ).

tff(fact_61_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A1: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A1))),P1)) ) ).

tff(fact_62_insert__compr,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),B2) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A1)),combc(A,fun(A,bool),bool,member(A),B2))) ) ).

tff(fact_63_insertI1,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),B2))) ).

tff(fact_64_insert__compr__raw,axiom,
    ! [A: $tType,X2: A,Xa: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X2),Xa) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X2)),combc(A,fun(A,bool),bool,member(A),Xa))) ) ).

tff(fact_65_singleton__inject,axiom,
    ! [A: $tType,B1: A,A1: A] :
      ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),bot_bot(fun(A,bool))) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),bot_bot(fun(A,bool))) )
     => ( A1 = B1 ) ) ).

tff(fact_66_singletonE,axiom,
    ! [A: $tType,A1: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),bot_bot(fun(A,bool)))))
     => ( B1 = A1 ) ) ).

tff(fact_67_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C1: A,B1: A,A1: A] :
      ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),B1),bot_bot(fun(A,bool)))) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),C1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),D),bot_bot(fun(A,bool)))) )
    <=> ( ( ( A1 = C1 )
          & ( B1 = D ) )
        | ( ( A1 = D )
          & ( B1 = C1 ) ) ) ) ).

tff(fact_68_singleton__iff,axiom,
    ! [A: $tType,A1: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),bot_bot(fun(A,bool)))))
    <=> ( B1 = A1 ) ) ).

tff(fact_69_insert__not__empty,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),A2) != bot_bot(fun(A,bool)) ) ).

tff(fact_70_empty__not__insert,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] : ( bot_bot(fun(A,bool)) != aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),A2) ) ).

tff(fact_71_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_72_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A2))
    <=> pp(aa(A,bool,A2,X3)) ) ).

tff(fact_73_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_74_Collect__conv__if,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_75_Collect__conv__if2,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),A1),bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_76_atom_Osize_I3_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( atom_size(nDvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_77_atom_Osize_I1_J,axiom,
    ! [List: list(int),Int: int] : ( atom_size(c_PresArith_Oatom_OLe(Int,List)) = zero_zero(nat) ) ).

tff(fact_78_atom_Osize_I2_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( atom_size(dvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_79_the__elem__eq,axiom,
    ! [A: $tType,X3: A] : ( the_elem(A,aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),bot_bot(fun(A,bool)))) = X3 ) ).

tff(fact_80_atom_Osize_I4_J,axiom,
    ! [List: list(int),Int: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int,List)) = zero_zero(nat) ) ).

tff(fact_81_atom_Osize_I6_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( size_size(atom,nDvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_82_atom_Osize_I5_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( size_size(atom,dvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_83_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X3: B] : ( aa(B,A,bot_bot(fun(B,A)),X3) = bot_bot(A) ) ) ).

tff(fact_84_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X2: A] : ( aa(A,B,bot_bot(fun(A,B)),X2) = bot_bot(B) ) ) ).

tff(fact_85_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_86_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_87_List_Oset__insert,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] : ( aa(list(A),fun(A,bool),set(A),insert(A,X3,Xsa)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert1(A),X3),aa(list(A),fun(A,bool),set(A),Xsa)) ) ).

tff(fact_88_the__elem__def,axiom,
    ! [A: $tType,X4: fun(A,bool)] : ( the_elem(A,X4) = the(A,combb(fun(A,bool),bool,A,aa(fun(A,bool),fun(fun(A,bool),bool),fequal(fun(A,bool)),X4),combc(A,fun(A,bool),fun(A,bool),insert1(A),bot_bot(fun(A,bool))))) ) ).

tff(fact_89_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),aa(list(A),fun(A,bool),set(A),Xsa)))
     => ( insert(A,X3,Xsa) = Xsa ) ) ).

tff(fact_90_the__sym__eq__trivial,axiom,
    ! [A: $tType,X3: A] : ( the(A,aa(A,fun(A,bool),fequal(A),X3)) = X3 ) ).

tff(fact_91_the__eq__trivial,axiom,
    ! [A: $tType,A1: A] : ( the(A,combc(A,A,bool,fequal(A),A1)) = A1 ) ).

tff(fact_92_If__def,axiom,
    ! [A: $tType,Y2: A,X3: A,P1: bool] :
      ( ( pp(P1)
       => ( X3 = the(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,P1),combc(A,A,bool,fequal(A),X3))),combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,P1)),combc(A,A,bool,fequal(A),Y2)))) ) )
      & ( ~ pp(P1)
       => ( Y2 = the(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,P1),combc(A,A,bool,fequal(A),X3))),combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,P1)),combc(A,A,bool,fequal(A),Y2)))) ) ) ) ).

tff(fact_93_the__equality,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,A1))
     => ( ! [X: A] :
            ( pp(aa(A,bool,P1,X))
           => ( X = A1 ) )
       => ( the(A,P1) = A1 ) ) ) ).

tff(fact_94_theI_H,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ? [X2: A] :
          ( pp(aa(A,bool,P1,X2))
          & ! [Y1: A] :
              ( pp(aa(A,bool,P1,Y1))
             => ( Y1 = X2 ) ) )
     => pp(aa(A,bool,P1,the(A,P1))) ) ).

tff(fact_95_theI,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,A1))
     => ( ! [X: A] :
            ( pp(aa(A,bool,P1,X))
           => ( X = A1 ) )
       => pp(aa(A,bool,P1,the(A,P1))) ) ) ).

%----Arities (17)
tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (24)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y))
      | ( X1 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ( X1 != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [X: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),aa(list(atom),fun(atom,bool),set(atom),as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))))))))
     => ( hd_coeff(X) = one_one(int) ) ) ).

%------------------------------------------------------------------------------
