%------------------------------------------------------------------------------
% File     : COM052_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 108
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_108 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  192 (  40 unt;  48 typ;   0 def)
%            Number of atoms       :  336 (  83 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  227 (  35   ~;  16   |;   9   &)
%                                         (  28 <=>; 139  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   29 (  17   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-6 aty)
%            Number of functors    :   25 (  25 usr;   5 con; 0-5 aty)
%            Number of variables   :  414 ( 362   !;   6   ?; 414   :)
%                                         (  46  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:03
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

%----Relevant facts (98)
tff(fact_0_norm,axiom,
    ! [X1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X1),set(atom,as)))
     => ( divisor(X1) != zero_zero(int) ) ) ).

tff(fact_1_Un__iff,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A3,B3)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A3))
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_2_UnE,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A3,B3)))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A3))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_3_sup1E,axiom,
    ! [A: $tType,X: A,B3: fun(A,bool),A3: fun(A,bool)] :
      ( pp(aa(A,bool,sup_sup(fun(A,bool),A3,B3),X))
     => ( ~ pp(aa(A,bool,A3,X))
       => pp(aa(A,bool,B3,X)) ) ) ).

tff(fact_4_sup1CI,axiom,
    ! [A: $tType,A3: fun(A,bool),X: A,B3: fun(A,bool)] :
      ( ( ~ pp(aa(A,bool,B3,X))
       => pp(aa(A,bool,A3,X)) )
     => pp(aa(A,bool,sup_sup(fun(A,bool),A3,B3),X)) ) ).

tff(fact_5_UnCI,axiom,
    ! [A: $tType,A3: fun(A,bool),B3: fun(A,bool),C1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A3)) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A3,B3))) ) ).

tff(fact_6_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,sup_sup(A,A2,B2)) = sup_sup(A,A2,B2) ) ) ).

tff(fact_7_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y1: A,X3: A] : ( sup_sup(A,X3,sup_sup(A,X3,Y1)) = sup_sup(A,X3,Y1) ) ) ).

tff(fact_8_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( lattice(B)
     => ! [G: fun(A,B),F: fun(A,B),X1: A] : ( aa(A,B,sup_sup(fun(A,B),F,G),X1) = sup_sup(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_9_sup__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( lattice(A)
     => ! [X: B,G: fun(B,A),F: fun(B,A)] : ( aa(B,A,sup_sup(fun(B,A),F,G),X) = sup_sup(A,aa(B,A,F,X),aa(B,A,G,X)) ) ) ).

tff(fact_10_less__supI1,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),A2))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),sup_sup(A,A2,B2))) ) ) ).

tff(fact_11_less__supI2,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A2: A,B2: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),B2))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),sup_sup(A,A2,B2))) ) ) ).

tff(fact_12_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_13_sup__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z2: A,Y1: A,X3: A] : ( sup_sup(A,sup_sup(A,X3,Y1),Z2) = sup_sup(A,X3,sup_sup(A,Y1,Z2)) ) ) ).

tff(fact_14_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z2: A,Y1: A,X3: A] : ( sup_sup(A,sup_sup(A,X3,Y1),Z2) = sup_sup(A,X3,sup_sup(A,Y1,Z2)) ) ) ).

tff(fact_15_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C2: A,B2: A,A2: A] : ( sup_sup(A,sup_sup(A,A2,B2),C2) = sup_sup(A,A2,sup_sup(A,B2,C2)) ) ) ).

tff(fact_16_sup__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z2: A,Y1: A,X3: A] : ( sup_sup(A,X3,sup_sup(A,Y1,Z2)) = sup_sup(A,Y1,sup_sup(A,X3,Z2)) ) ) ).

tff(fact_17_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z2: A,Y1: A,X3: A] : ( sup_sup(A,X3,sup_sup(A,Y1,Z2)) = sup_sup(A,Y1,sup_sup(A,X3,Z2)) ) ) ).

tff(fact_18_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C2: A,A2: A,B2: A] : ( sup_sup(A,B2,sup_sup(A,A2,C2)) = sup_sup(A,A2,sup_sup(A,B2,C2)) ) ) ).

tff(fact_19_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y1: A,X3: A] : ( sup_sup(A,X3,sup_sup(A,X3,Y1)) = sup_sup(A,X3,Y1) ) ) ).

tff(fact_20_sup__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y1: A,X3: A] : ( sup_sup(A,X3,Y1) = sup_sup(A,Y1,X3) ) ) ).

tff(fact_21_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y1: A,X3: A] : ( sup_sup(A,X3,Y1) = sup_sup(A,Y1,X3) ) ) ).

tff(fact_22_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,B2) = sup_sup(A,B2,A2) ) ) ).

tff(fact_23_sup__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X3: A] : ( sup_sup(A,X3,X3) = X3 ) ) ).

tff(fact_24_sup_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A2: A] : ( sup_sup(A,A2,A2) = A2 ) ) ).

tff(fact_25_UnI2,axiom,
    ! [A: $tType,A3: fun(A,bool),B3: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A3,B3))) ) ).

tff(fact_26_UnI1,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A3))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),sup_sup(fun(A,bool),A3,B3))) ) ).

tff(fact_27_sup1I2,axiom,
    ! [A: $tType,A3: fun(A,bool),X: A,B3: fun(A,bool)] :
      ( pp(aa(A,bool,B3,X))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A3,B3),X)) ) ).

tff(fact_28_sup1I1,axiom,
    ! [A: $tType,B3: fun(A,bool),X: A,A3: fun(A,bool)] :
      ( pp(aa(A,bool,A3,X))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A3,B3),X)) ) ).

tff(fact_29_ball__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B3: fun(A,bool),A3: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),sup_sup(fun(A,bool),A3,B3)))
         => pp(aa(A,bool,P1,X4)) )
    <=> ( ! [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A3))
           => pp(aa(A,bool,P1,X4)) )
        & ! [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),B3))
           => pp(aa(A,bool,P1,X4)) ) ) ) ).

tff(fact_30_bex__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B3: fun(A,bool),A3: fun(A,bool)] :
      ( ? [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),sup_sup(fun(A,bool),A3,B3)))
          & pp(aa(A,bool,P1,X4)) )
    <=> ( ? [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A3))
            & pp(aa(A,bool,P1,X4)) )
        | ? [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),B3))
            & pp(aa(A,bool,P1,X4)) ) ) ) ).

tff(fact_31_Un__assoc,axiom,
    ! [A: $tType,C3: fun(A,bool),B3: fun(A,bool),A3: fun(A,bool)] : ( sup_sup(fun(A,bool),sup_sup(fun(A,bool),A3,B3),C3) = sup_sup(fun(A,bool),A3,sup_sup(fun(A,bool),B3,C3)) ) ).

tff(fact_32_Un__left__commute,axiom,
    ! [A: $tType,C3: fun(A,bool),B3: fun(A,bool),A3: fun(A,bool)] : ( sup_sup(fun(A,bool),A3,sup_sup(fun(A,bool),B3,C3)) = sup_sup(fun(A,bool),B3,sup_sup(fun(A,bool),A3,C3)) ) ).

tff(fact_33_Un__left__absorb,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool)] : ( sup_sup(fun(A,bool),A3,sup_sup(fun(A,bool),A3,B3)) = sup_sup(fun(A,bool),A3,B3) ) ).

tff(fact_34_Un__commute,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool)] : ( sup_sup(fun(A,bool),A3,B3) = sup_sup(fun(A,bool),B3,A3) ) ).

tff(fact_35_Un__def,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool)] : ( sup_sup(fun(A,bool),A3,B3) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,fun(A,bool),bool,member(A),A3)),combc(A,fun(A,bool),bool,member(A),B3))) ) ).

tff(fact_36_Un__absorb,axiom,
    ! [A: $tType,A3: fun(A,bool)] : ( sup_sup(fun(A,bool),A3,A3) = A3 ) ).

tff(fact_37_sup__Un__eq,axiom,
    ! [A: $tType,S: fun(A,bool),R2: fun(A,bool),X1: A] :
      ( pp(aa(A,bool,sup_sup(fun(A,bool),combc(A,fun(A,bool),bool,member(A),R2),combc(A,fun(A,bool),bool,member(A),S)),X1))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),sup_sup(fun(A,bool),R2,S))) ) ).

tff(fact_38_Collect__disj__eq,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] : ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,P1),Q1)) = sup_sup(fun(A,bool),collect(A,P1),collect(A,Q1)) ) ).

tff(fact_39_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),ring_1_of_int(A,Z1)),zero_zero(A)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),Z1),zero_zero(int))) ) ) ).

tff(fact_40_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),ring_1_of_int(A,Z1)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),zero_zero(int)),Z1)) ) ) ).

tff(fact_41_Sup__fin_Oidem,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [X3: A] : ( sup_sup(A,X3,X3) = X3 ) ) ).

tff(fact_42_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ( ( X3 != Y1 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X3)) ) ) ) ).

tff(fact_43_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X3)) ) ) ).

tff(fact_44_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),Z2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Z2)) ) ) ) ).

tff(fact_45_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => ( ( B2 = C2 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),C2)) ) ) ) ).

tff(fact_46_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),C2))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),C2)) ) ) ) ).

tff(fact_47_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),B2))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),B2),A2)) ) ) ).

tff(fact_48_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z1) )
        <=> ( W = Z1 ) ) ) ).

tff(fact_49_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_50_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z1) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_51_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( ring_1_of_int(A,Z1) = zero_zero(A) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_52_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int,W: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),ring_1_of_int(A,W)),ring_1_of_int(A,Z1)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),W),Z1)) ) ) ).

tff(fact_53_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X3: A] : ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),X3)) ) ).

tff(fact_54_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
            | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X)) ) ) ) ).

tff(fact_55_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
        <=> ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X))
            | ( X = Y ) ) ) ) ).

tff(fact_56_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
          | ( X3 = Y1 )
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X3)) ) ) ).

tff(fact_57_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X))
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
          <=> ( X = Y ) ) ) ) ).

tff(fact_58_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ( X3 != Y1 )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X3)) ) ) ) ).

tff(fact_59_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ( X3 != Y1 ) ) ) ).

tff(fact_60_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X3)) ) ) ).

tff(fact_61_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X3)) ) ) ).

tff(fact_62_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ( X3 != Y1 ) ) ) ).

tff(fact_63_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ( Y1 != X3 ) ) ) ).

tff(fact_64_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y),X))
           => pp(P1) ) ) ) ).

tff(fact_65_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [X11: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),X11)) ) ).

tff(fact_66_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X3: A] :
        ? [Y2: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y2),X3)) ) ).

tff(fact_67_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
         => ? [Z: A] :
              ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Z))
              & pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Z),Y1)) ) ) ) ).

tff(fact_68_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F: fun(A,B),B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
         => ( ( aa(A,B,F,B1) = C1 )
           => ( ! [X2: A,Y2: A] :
                  ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,X2)),aa(A,B,F,Y2))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,A1)),C1)) ) ) ) ) ).

tff(fact_69_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F: fun(B,A),A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),aa(B,A,F,B1)))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),B1),C1))
           => ( ! [X2: B,Y2: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X2),Y2))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F,X2)),aa(B,A,F,Y2))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_70_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,B1: B,F: fun(B,A),A1: A] :
          ( ( A1 = aa(B,A,F,B1) )
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),B1),C1))
           => ( ! [X2: B,Y2: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),X2),Y2))
                 => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),aa(B,A,F,X2)),aa(B,A,F,Y2))) )
             => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),aa(B,A,F,C1))) ) ) ) ) ).

tff(fact_71_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F: fun(A,B),B1: A,A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),B1))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,B1)),C1))
           => ( ! [X2: A,Y2: A] :
                  ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X2),Y2))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,X2)),aa(A,B,F,Y2))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less(B),aa(A,B,F,A1)),C1)) ) ) ) ) ).

tff(fact_72_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X3: A] :
          ( ( X3 != Y1 )
         => ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X3),Y1))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),Y1),X3)) ) ) ) ).

tff(fact_73_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y: B,X: B,F: fun(B,A),R1: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R1,F,X,Y)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R1,aa(B,A,F,X)),aa(B,A,F,Y))) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A3))
    <=> pp(aa(A,bool,A3,X)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_inv__imagep__def,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R1: fun(B,fun(B,bool)),X1: A,Xa: A] :
      ( inv_imagep(B,A,R1,F,X1,Xa)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(A,B,F,X1)),aa(A,B,F,Xa))) ) ).

tff(fact_78_sgn__greater,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),sgn_sgn(A,A1)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A1)) ) ) ).

tff(fact_79_sgn__less,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),sgn_sgn(A,A1)),zero_zero(A)))
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),zero_zero(A))) ) ) ).

tff(fact_80_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] : ( sgn_sgn(A,sgn_sgn(A,A2)) = sgn_sgn(A,A2) ) ) ).

tff(fact_81_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_82_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_83_sgn__1__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = one_one(A) )
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A1)) ) ) ).

tff(fact_84_sgn__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),A2))
         => ( sgn_sgn(A,A2) = one_one(A) ) ) ) ).

tff(fact_85_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_86_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X: A] :
          ( ( one_one(A) = X )
        <=> ( X = one_one(A) ) ) ) ).

tff(fact_87_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_88_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_89_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),one_one(A))) ) ).

tff(fact_90_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),one_one(A)),zero_zero(A))) ) ).

tff(fact_91_sgn__1__neg,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = uminus_uminus(A,one_one(A)) )
        <=> pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A1),zero_zero(A))) ) ) ).

tff(fact_92_sgn__neg,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),A2),zero_zero(A)))
         => ( sgn_sgn(A,A2) = uminus_uminus(A,one_one(A)) ) ) ) ).

tff(fact_93_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( uminus_uminus(A,A1) = uminus_uminus(A,B1) )
        <=> ( A1 = B1 ) ) ) ).

tff(fact_94_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [Y: A,X: A] :
          ( ( uminus_uminus(A,X) = uminus_uminus(A,Y) )
        <=> ( X = Y ) ) ) ).

tff(fact_95_neg__equal__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( uminus_uminus(A,A1) = A1 )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_96_neg__equal__0__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] :
          ( ( uminus_uminus(A,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_97_equal__neg__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( A1 = uminus_uminus(A,A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

%----Arities (29)
tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_sup(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Oboolean__algebra,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( boolean_algebra(T_2)
     => boolean_algebra(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Lattices_Olattice,axiom,
    lattice(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Lattices_Oboolean__algebra,axiom,
    boolean_algebra(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (16)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    set(atom,as) = sup_sup(fun(atom,bool),sup_sup(fun(atom,bool),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))))),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,combb(bool,fun(list(int),bool),int,combk(bool,list(int)),aa(int,fun(int,bool),ord_less(int),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,combb(bool,fun(list(int),bool),int,combk(bool,list(int)),combc(int,int,bool,ord_less(int),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))) ).

%------------------------------------------------------------------------------
