%------------------------------------------------------------------------------
% File     : COM051_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 107
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_107 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  175 (  58 unt;  46 typ;   0 def)
%            Number of atoms       :  248 (  96 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  158 (  39   ~;  19   |;  16   &)
%                                         (  20 <=>;  64  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   39 (  22   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-3 aty)
%            Number of functors    :   33 (  33 usr;   7 con; 0-5 aty)
%            Number of variables   :  403 ( 356   !;   7   ?; 403   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:32
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert1: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olinorder__class_Osort__key,type,
    linorder_sort_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * list(B) ) > list(B) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex,type,
    list_ex: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_List_Oremdups,type,
    remdups: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Orotate,type,
    rotate: 
      !>[A: $tType] : ( nat > fun(list(A),list(A)) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Ocompow,type,
    compow: 
      !>[A: $tType,B: $tType] : fun(nat,fun(fun(A,B),fun(A,B))) ).

tff(sy_c_Nat_Ofunpow,type,
    funpow: 
      !>[A: $tType] : fun(nat,fun(fun(A,A),fun(A,A))) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: atom ).

%----Relevant facts (98)
tff(fact_0_norm,axiom,
    ! [X1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X1),aa(list(atom),fun(atom,bool),set(atom),as)))
     => ( divisor(X1) != zero_zero(int) ) ) ).

tff(fact_1_member__set,axiom,
    ! [A: $tType] : ( member1(A) = set(A) ) ).

tff(fact_2_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),aa(list(A),fun(A,bool),set(A),Xsa)))
          & pp(aa(A,bool,P1,X3))
          & ! [Y2: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),aa(list(A),fun(A,bool),set(A),Xsa)))
                & pp(aa(A,bool,P1,Y2)) )
             => ( Y2 = X3 ) ) ) ) ).

tff(fact_3_List_Omember__def,axiom,
    ! [A: $tType,Xa: A,Xsa: list(A)] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),Xa))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa))) ) ).

tff(fact_4_ListMem__iff,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( listMem(A,Xa,Xsa)
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa))) ) ).

tff(fact_5_in__set__member,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa)))
    <=> pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),Xa)) ) ).

tff(fact_6_set__rotate1,axiom,
    ! [A: $tType,Xsa: list(A)] : ( aa(list(A),fun(A,bool),set(A),aa(list(A),list(A),rotate1(A),Xsa)) = aa(list(A),fun(A,bool),set(A),Xsa) ) ).

tff(fact_7_set__sort,axiom,
    ! [B: $tType,A: $tType] :
      ( linorder(B)
     => ! [Xsa: list(A),F: fun(A,B)] : ( aa(list(A),fun(A,bool),set(A),linorder_sort_key(A,B,F,Xsa)) = aa(list(A),fun(A,bool),set(A),Xsa) ) ) ).

tff(fact_8_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa)))
     => ( insert1(A,Xa,Xsa) = Xsa ) ) ).

tff(fact_9_set__rotate,axiom,
    ! [A: $tType,Xsa: list(A),N: nat] : ( aa(list(A),fun(A,bool),set(A),aa(list(A),list(A),rotate(A,N),Xsa)) = aa(list(A),fun(A,bool),set(A),Xsa) ) ).

tff(fact_10_list__ex__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex(A,P1,Xsa)
    <=> ? [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),aa(list(A),fun(A,bool),set(A),Xsa)))
          & pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_11_set__remdups,axiom,
    ! [A: $tType,Xsa: list(A)] : ( aa(list(A),fun(A,bool),set(A),remdups(A,Xsa)) = aa(list(A),fun(A,bool),set(A),Xsa) ) ).

tff(fact_12_remdups__remdups,axiom,
    ! [A: $tType,Xs: list(A)] : ( remdups(A,remdups(A,Xs)) = remdups(A,Xs) ) ).

tff(fact_13_rotate1__rotate__swap,axiom,
    ! [A: $tType,Xs: list(A),N1: nat] : ( aa(list(A),list(A),rotate1(A),aa(list(A),list(A),rotate(A,N1),Xs)) = aa(list(A),list(A),rotate(A,N1),aa(list(A),list(A),rotate1(A),Xs)) ) ).

tff(fact_14_insert__remdups,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( insert1(A,X,remdups(A,Xs)) = remdups(A,insert1(A,X,Xs)) ) ).

tff(fact_15_list__any__cong,axiom,
    ! [A: $tType,G: fun(A,bool),F: fun(A,bool),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),aa(list(A),fun(A,bool),set(A),Ys)))
           => ( pp(aa(A,bool,F,X2))
            <=> pp(aa(A,bool,G,X2)) ) )
       => ( list_ex(A,F,Xsa)
        <=> list_ex(A,G,Ys) ) ) ) ).

tff(fact_16_rotate__def,axiom,
    ! [A: $tType,N: nat] : ( rotate(A,N) = aa(fun(list(A),list(A)),fun(list(A),list(A)),aa(nat,fun(fun(list(A),list(A)),fun(list(A),list(A))),compow(list(A),list(A)),N),rotate1(A)) ) ).

tff(fact_17_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_18_rotate__Suc,axiom,
    ! [A: $tType,Xs: list(A),N1: nat] : ( aa(list(A),list(A),rotate(A,suc(N1)),Xs) = aa(list(A),list(A),rotate1(A),aa(list(A),list(A),rotate(A,N1),Xs)) ) ).

tff(fact_19_List_Oset__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] : ( aa(list(A),fun(A,bool),set(A),insert1(A,Xa,Xsa)) = insert(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa)) ) ).

tff(fact_20_remdups_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa)))
       => ( remdups(A,cons(A,Xa,Xsa)) = remdups(A,Xsa) ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa)))
       => ( remdups(A,cons(A,Xa,Xsa)) = cons(A,Xa,remdups(A,Xsa)) ) ) ) ).

tff(fact_21_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa)))
       => ( insert1(A,Xa,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa)))
       => ( insert1(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ) ).

tff(fact_22_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),aa(list(A),fun(A,bool),set(A),Xsa)))
     => ( insert1(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ).

tff(fact_23_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A4: A,List: list(A),A3: A] :
      ( ( cons(A,A3,List) = cons(A,A4,List1) )
    <=> ( ( A3 = A4 )
        & ( List = List1 ) ) ) ).

tff(fact_24_list__ex__simps_I1_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( list_ex(A,P1,cons(A,Xa,Xsa))
    <=> ( pp(aa(A,bool,P1,Xa))
        | list_ex(A,P1,Xsa) ) ) ).

tff(fact_25_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] : ( aa(list(A),fun(A,bool),set(A),cons(A,Xa,Xsa)) = insert(A,Xa,aa(list(A),fun(A,bool),set(A),Xsa)) ) ).

tff(fact_26_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_27_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_28_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),aa(list(A),fun(A,bool),set(A),cons(A,Xa,Xsa))))
     => ( ( Y1 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),aa(list(A),fun(A,bool),set(A),Xsa))) ) ) ).

tff(fact_29_insert,axiom,
    ! [A: $tType,Y: A,Xs: list(A),X: A] :
      ( listMem(A,X,Xs)
     => listMem(A,X,cons(A,Y,Xs)) ) ).

tff(fact_30_member__rec_I1_J,axiom,
    ! [A: $tType,Y1: A,Xsa: list(A),Xa: A] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),cons(A,Xa,Xsa)),Y1))
    <=> ( ( Xa = Y1 )
        | pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xsa),Y1)) ) ) ).

tff(fact_31_elem,axiom,
    ! [A: $tType,Xs: list(A),X: A] : listMem(A,X,cons(A,X,Xs)) ).

tff(fact_32_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A3: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A3,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A3),List) ) ).

tff(fact_33_insertCI,axiom,
    ! [A: $tType,B4: A,B1: fun(A,bool),A3: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),B1))
       => ( A3 = B4 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B4,B1))) ) ).

tff(fact_34_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B4: A,A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B4,A1)))
     => ( ( A3 != B4 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1)) ) ) ).

tff(fact_35_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B4: A,A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B4,A1)))
    <=> ( ( A3 = B4 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1)) ) ) ).

tff(fact_36_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] : ( insert(A,Xa,insert(A,Xa,A1)) = insert(A,Xa,A1) ) ).

tff(fact_37_nat_Oinject,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( suc(Nat2) = suc(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_38_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_39_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_40_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_41_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_42_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_43_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( suc(Nat1) != zero_zero(nat) ) ).

tff(fact_44_Suc__not__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_45_nat_Osimps_I2_J,axiom,
    ! [Nat: nat] : ( zero_zero(nat) != suc(Nat) ) ).

tff(fact_46_Zero__not__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_47_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,A3,B1))) ).

tff(fact_48_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: A] : ( insert(A,A3,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A3)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_49_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A3: A] : ( insert(A,A3,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A3))),P1)) ) ).

tff(fact_50_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y1: A,Xa: A] : ( insert(A,Xa,insert(A,Y1,A1)) = insert(A,Y1,insert(A,Xa,A1)) ) ).

tff(fact_51_insert__code,axiom,
    ! [A: $tType,Xa: A,A1: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,A1),Xa))
    <=> ( ( Y1 = Xa )
        | pp(aa(A,bool,A1,Xa)) ) ) ).

tff(fact_52_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B1))
       => ( ( insert(A,Xa,A1) = insert(A,Xa,B1) )
        <=> ( A1 = B1 ) ) ) ) ).

tff(fact_53_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B4: A,A1: fun(A,bool),A3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B4),B1))
       => ( ( insert(A,A3,A1) = insert(A,B4,B1) )
        <=> ( ( ( A3 = B4 )
             => ( A1 = B1 ) )
            & ( ( A3 != B4 )
             => ? [C4: fun(A,bool)] :
                  ( ( A1 = insert(A,B4,C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B4),C4))
                  & ( B1 = insert(A,A3,C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),C4)) ) ) ) ) ) ) ).

tff(fact_54_insertI2,axiom,
    ! [A: $tType,B4: A,B1: fun(A,bool),A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B4,B1))) ) ).

tff(fact_55_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1))
     => ( insert(A,A3,A1) = A1 ) ) ).

tff(fact_56_funpow__swap1,axiom,
    ! [A: $tType,Xa: A,N: nat,F: fun(A,A)] : ( aa(A,A,F,aa(A,A,aa(fun(A,A),fun(A,A),aa(nat,fun(fun(A,A),fun(A,A)),compow(A,A),N),F),Xa)) = aa(A,A,aa(fun(A,A),fun(A,A),aa(nat,fun(fun(A,A),fun(A,A)),compow(A,A),N),F),aa(A,A,F,Xa)) ) ).

tff(fact_57_Un__insert__right,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: A,A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,insert(A,A3,B1)) = insert(A,A3,sup_sup(fun(A,bool),A1,B1)) ) ).

tff(fact_58_Un__insert__left,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A3: A] : ( sup_sup(fun(A,bool),insert(A,A3,B1),C2) = insert(A,A3,sup_sup(fun(A,bool),B1,C2)) ) ).

tff(fact_59_funpow__code__def,axiom,
    ! [A: $tType] : ( funpow(A) = compow(A,A) ) ).

tff(fact_60_of__nat__aux_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [I: A,N: nat,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,suc(N),I) = semiri532925092at_aux(A,Inc,N,aa(A,A,Inc,I)) ) ) ).

tff(fact_61_mk__disjoint__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1))
     => ? [B3: fun(A,bool)] :
          ( ( A1 = insert(A,A3,B3) )
          & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),B3)) ) ) ).

tff(fact_62_UnCI,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: fun(A,bool),C3: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),B1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),A1)) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),sup_sup(fun(A,bool),A1,B1))) ) ).

tff(fact_63_UnE,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),sup_sup(fun(A,bool),A1,B1)))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),B1)) ) ) ).

tff(fact_64_Un__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),sup_sup(fun(A,bool),A1,B1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),A1))
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),B1)) ) ) ).

tff(fact_65_of__nat__aux_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [I: A,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,zero_zero(nat),I) = I ) ) ).

tff(fact_66_UnI2,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: fun(A,bool),C3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),sup_sup(fun(A,bool),A1,B1))) ) ).

tff(fact_67_UnI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),A1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),sup_sup(fun(A,bool),A1,B1))) ) ).

tff(fact_68_ball__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),sup_sup(fun(A,bool),A1,B1)))
         => pp(aa(A,bool,P1,X3)) )
    <=> ( ! [X3: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
           => pp(aa(A,bool,P1,X3)) )
        & ! [X3: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B1))
           => pp(aa(A,bool,P1,X3)) ) ) ) ).

tff(fact_69_bex__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( ? [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),sup_sup(fun(A,bool),A1,B1)))
          & pp(aa(A,bool,P1,X3)) )
    <=> ( ? [X3: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
            & pp(aa(A,bool,P1,X3)) )
        | ? [X3: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B1))
            & pp(aa(A,bool,P1,X3)) ) ) ) ).

tff(fact_70_Un__assoc,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),sup_sup(fun(A,bool),A1,B1),C2) = sup_sup(fun(A,bool),A1,sup_sup(fun(A,bool),B1,C2)) ) ).

tff(fact_71_Un__left__commute,axiom,
    ! [A: $tType,C2: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,sup_sup(fun(A,bool),B1,C2)) = sup_sup(fun(A,bool),B1,sup_sup(fun(A,bool),A1,C2)) ) ).

tff(fact_72_Un__left__absorb,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,sup_sup(fun(A,bool),A1,B1)) = sup_sup(fun(A,bool),A1,B1) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_Un__commute,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,B1) = sup_sup(fun(A,bool),B1,A1) ) ).

tff(fact_77_Un__def,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,fun(A,bool),bool,member(A),A1)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_78_Un__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,A1) = A1 ) ).

tff(fact_79_sup1CI,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A,B1: fun(A,bool)] :
      ( ( ~ pp(aa(A,bool,B1,Xa))
       => pp(aa(A,bool,A1,Xa)) )
     => pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa)) ) ).

tff(fact_80_sup1E,axiom,
    ! [A: $tType,Xa: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa))
     => ( ~ pp(aa(A,bool,A1,Xa))
       => pp(aa(A,bool,B1,Xa)) ) ) ).

tff(fact_81_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,X,Y)) = sup_sup(A,X,Y) ) ) ).

tff(fact_82_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,sup_sup(A,A2,B2)) = sup_sup(A,A2,B2) ) ) ).

tff(fact_83_sup_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A2: A] : ( sup_sup(A,A2,A2) = A2 ) ) ).

tff(fact_84_sup__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X: A] : ( sup_sup(A,X,X) = X ) ) ).

tff(fact_85_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,B2) = sup_sup(A,B2,A2) ) ) ).

tff(fact_86_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,Y) = sup_sup(A,Y,X) ) ) ).

tff(fact_87_sup__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,Y) = sup_sup(A,Y,X) ) ) ).

tff(fact_88_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,X,Y)) = sup_sup(A,X,Y) ) ) ).

tff(fact_89_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C1: A,A2: A,B2: A] : ( sup_sup(A,B2,sup_sup(A,A2,C1)) = sup_sup(A,A2,sup_sup(A,B2,C1)) ) ) ).

tff(fact_90_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X,Z)) ) ) ).

tff(fact_91_sup__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X,Z)) ) ) ).

tff(fact_92_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C1: A,B2: A,A2: A] : ( sup_sup(A,sup_sup(A,A2,B2),C1) = sup_sup(A,A2,sup_sup(A,B2,C1)) ) ) ).

tff(fact_93_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,sup_sup(A,X,Y),Z) = sup_sup(A,X,sup_sup(A,Y,Z)) ) ) ).

tff(fact_94_sup__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,sup_sup(A,X,Y),Z) = sup_sup(A,X,sup_sup(A,Y,Z)) ) ) ).

tff(fact_95_sup1I1,axiom,
    ! [A: $tType,B1: fun(A,bool),Xa: A,A1: fun(A,bool)] :
      ( pp(aa(A,bool,A1,Xa))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa)) ) ).

tff(fact_96_sup1I2,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A,B1: fun(A,bool)] :
      ( pp(aa(A,bool,B1,Xa))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa)) ) ).

tff(fact_97_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( lattice(B)
     => ! [G: fun(A,B),F: fun(A,B),X1: A] : ( aa(A,B,sup_sup(fun(A,B),F,G),X1) = sup_sup(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

%----Arities (15)
tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_sup(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Lattices_Olattice,axiom,
    lattice(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),x),aa(list(atom),fun(atom,bool),set(atom),as))) ).

%------------------------------------------------------------------------------
