%------------------------------------------------------------------------------
% File     : COM050_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 104
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_104 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  184 (  54 unt;  47 typ;   0 def)
%            Number of atoms       :  268 (  99 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  175 (  44   ~;  23   |;  16   &)
%                                         (  22 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   27 (  17   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-2 aty)
%            Number of functors    :   32 (  32 usr;   9 con; 0-5 aty)
%            Number of variables   :  397 ( 353   !;   5   ?; 397   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:25
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) ) > fun(atom,T) ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: atom ).

%----Relevant facts (96)
tff(fact_0__096x_A_058_Aset_Aas_096,axiom,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),x),set(atom,as))) ).

tff(fact_1_norm,axiom,
    ! [X1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X1),set(atom,as)))
     => ( divisor(X1) != zero_zero(int) ) ) ).

tff(fact_2_hd,axiom,
    ! [X1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X1),set(atom,as)))
     => pp(aa(atom,bool,atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),hd_coeff(X1)),insert(int,one_one(int),insert(int,number_number_of(int,min),bot_bot(fun(int,bool))))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X1)),one_one(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X1)),one_one(int)))))),X1)) ) ).

tff(fact_3_Un__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A1,B1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_4_UnE,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A1,B1)))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_5_sup1E,axiom,
    ! [A: $tType,Xa: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa))
     => ( ~ pp(aa(A,bool,A1,Xa))
       => pp(aa(A,bool,B1,Xa)) ) ) ).

tff(fact_6_sup1CI,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A,B1: fun(A,bool)] :
      ( ( ~ pp(aa(A,bool,B1,Xa))
       => pp(aa(A,bool,A1,Xa)) )
     => pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa)) ) ).

tff(fact_7_UnCI,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: fun(A,bool),C2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1)) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A1,B1))) ) ).

tff(fact_8_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,sup_sup(A,A2,B2)) = sup_sup(A,A2,B2) ) ) ).

tff(fact_9_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,X,Y)) = sup_sup(A,X,Y) ) ) ).

tff(fact_10_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( lattice(B)
     => ! [G: fun(A,B),F: fun(A,B),X1: A] : ( aa(A,B,sup_sup(fun(A,B),F,G),X1) = sup_sup(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_11_sup__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( lattice(A)
     => ! [Xa: B,G: fun(B,A),F: fun(B,A)] : ( aa(B,A,sup_sup(fun(B,A),F,G),Xa) = sup_sup(A,aa(B,A,F,Xa),aa(B,A,G,Xa)) ) ) ).

tff(fact_12_less__supI1,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),A2))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),sup_sup(A,A2,B2))) ) ) ).

tff(fact_13_less__supI2,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A2: A,B2: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),B2))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),X),sup_sup(A,A2,B2))) ) ) ).

tff(fact_14_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_15_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_16_empty__iff,axiom,
    ! [A: $tType,C2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),bot_bot(fun(A,bool)))) ).

tff(fact_17_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_18_emptyE,axiom,
    ! [A: $tType,A3: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),bot_bot(fun(A,bool)))) ).

tff(fact_19_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] : ( insert(A,Xa,insert(A,Xa,A1)) = insert(A,Xa,A1) ) ).

tff(fact_20_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B3: A,A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B3,A1)))
    <=> ( ( A3 = B3 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1)) ) ) ).

tff(fact_21_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B3: A,A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B3,A1)))
     => ( ( A3 != B3 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1)) ) ) ).

tff(fact_22_insertCI,axiom,
    ! [A: $tType,B3: A,B1: fun(A,bool),A3: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),B1))
       => ( A3 = B3 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B3,B1))) ) ).

tff(fact_23_sup__eq__bot__iff,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [Y1: A,Xa: A] :
          ( ( sup_sup(A,Xa,Y1) = bot_bot(A) )
        <=> ( ( Xa = bot_bot(A) )
            & ( Y1 = bot_bot(A) ) ) ) ) ).

tff(fact_24_Un__empty,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( sup_sup(fun(A,bool),A1,B1) = bot_bot(fun(A,bool)) )
    <=> ( ( A1 = bot_bot(fun(A,bool)) )
        & ( B1 = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_25_Un__insert__left,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A3: A] : ( sup_sup(fun(A,bool),insert(A,A3,B1),C1) = insert(A,A3,sup_sup(fun(A,bool),B1,C1)) ) ).

tff(fact_26_Un__insert__right,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: A,A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,insert(A,A3,B1)) = insert(A,A3,sup_sup(fun(A,bool),A1,B1)) ) ).

tff(fact_27_singleton__conv,axiom,
    ! [A: $tType,A3: A] : ( collect(A,combc(A,A,bool,fequal(A),A3)) = insert(A,A3,bot_bot(fun(A,bool))) ) ).

tff(fact_28_singleton__conv2,axiom,
    ! [A: $tType,A3: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A3)) = insert(A,A3,bot_bot(fun(A,bool))) ) ).

tff(fact_29_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A3: A] : ( bot_bot(fun(A,bool)) != insert(A,A3,A1) ) ).

tff(fact_30_not__psubset__empty,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ~ pp(aa(fun(A,bool),bool,aa(fun(A,bool),fun(fun(A,bool),bool),ord_less(fun(A,bool)),A1),bot_bot(fun(A,bool)))) ).

tff(fact_31_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),A3: A] : ( insert(A,A3,A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_32_bot__empty__eq,axiom,
    ! [A: $tType,X1: A] :
      ( pp(aa(A,bool,bot_bot(fun(A,bool)),X1))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),bot_bot(fun(A,bool)))) ) ).

tff(fact_33_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,aa(bool,fun(A,bool),combk(bool,A),fFalse)) ) ).

tff(fact_34_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,A3,B1))) ).

tff(fact_35_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_36_Collect__conv__if2,axiom,
    ! [A: $tType,A3: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A3))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A3)),P1)) = insert(A,A3,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A3))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A3)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_37_Collect__conv__if,axiom,
    ! [A: $tType,A3: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A3))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A3)),P1)) = insert(A,A3,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A3))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A3)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_38_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_39_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: A] : ( insert(A,A3,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A3)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_40_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A3: A] : ( insert(A,A3,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A3))),P1)) ) ).

tff(fact_41_singleton__iff,axiom,
    ! [A: $tType,A3: A,B3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B3),insert(A,A3,bot_bot(fun(A,bool)))))
    <=> ( B3 = A3 ) ) ).

tff(fact_42_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y1: A,Xa: A] : ( insert(A,Xa,insert(A,Y1,A1)) = insert(A,Y1,insert(A,Xa,A1)) ) ).

tff(fact_43_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C2: A,B3: A,A3: A] :
      ( ( insert(A,A3,insert(A,B3,bot_bot(fun(A,bool)))) = insert(A,C2,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A3 = C2 )
          & ( B3 = D ) )
        | ( ( A3 = D )
          & ( B3 = C2 ) ) ) ) ).

tff(fact_44_insert__code,axiom,
    ! [A: $tType,Xa: A,A1: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,A1),Xa))
    <=> ( ( Y1 = Xa )
        | pp(aa(A,bool,A1,Xa)) ) ) ).

tff(fact_45_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B1))
       => ( ( insert(A,Xa,A1) = insert(A,Xa,B1) )
        <=> ( A1 = B1 ) ) ) ) ).

tff(fact_46_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B3: A,A1: fun(A,bool),A3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B3),B1))
       => ( ( insert(A,A3,A1) = insert(A,B3,B1) )
        <=> ( ( ( A3 = B3 )
             => ( A1 = B1 ) )
            & ( ( A3 != B3 )
             => ? [C4: fun(A,bool)] :
                  ( ( A1 = insert(A,B3,C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B3),C4))
                  & ( B1 = insert(A,A3,C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),C4)) ) ) ) ) ) ) ).

tff(fact_47_equals0D,axiom,
    ! [A: $tType,A3: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1)) ) ).

tff(fact_48_insertI2,axiom,
    ! [A: $tType,B3: A,B1: fun(A,bool),A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B3,B1))) ) ).

tff(fact_49_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),A1))
     => ( insert(A,A3,A1) = A1 ) ) ).

tff(fact_50_singletonE,axiom,
    ! [A: $tType,A3: A,B3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B3),insert(A,A3,bot_bot(fun(A,bool)))))
     => ( B3 = A3 ) ) ).

tff(fact_51_singleton__inject,axiom,
    ! [A: $tType,B3: A,A3: A] :
      ( ( insert(A,A3,bot_bot(fun(A,bool))) = insert(A,B3,bot_bot(fun(A,bool))) )
     => ( A3 = B3 ) ) ).

tff(fact_52_insert__compr__raw,axiom,
    ! [A: $tType,X1: A,Xa1: fun(A,bool)] : ( insert(A,X1,Xa1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X1)),combc(A,fun(A,bool),bool,member(A),Xa1))) ) ).

tff(fact_53_insert__is__Un,axiom,
    ! [A: $tType,A1: fun(A,bool),A3: A] : ( insert(A,A3,A1) = sup_sup(fun(A,bool),insert(A,A3,bot_bot(fun(A,bool))),A1) ) ).

tff(fact_54_Un__empty__right,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,bot_bot(fun(A,bool))) = A1 ) ).

tff(fact_55_Un__empty__left,axiom,
    ! [A: $tType,B1: fun(A,bool)] : ( sup_sup(fun(A,bool),bot_bot(fun(A,bool)),B1) = B1 ) ).

tff(fact_56_sup__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( sup_sup(A,X,bot_bot(A)) = X ) ) ).

tff(fact_57_sup__bot__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( sup_sup(A,bot_bot(A),X) = X ) ) ).

tff(fact_58_insert__def,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: A] : ( insert(A,A3,B1) = sup_sup(fun(A,bool),collect(A,combc(A,A,bool,fequal(A),A3)),B1) ) ).

tff(fact_59_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_60_sup__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,sup_sup(A,X,Y),Z) = sup_sup(A,X,sup_sup(A,Y,Z)) ) ) ).

tff(fact_61_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,sup_sup(A,X,Y),Z) = sup_sup(A,X,sup_sup(A,Y,Z)) ) ) ).

tff(fact_62_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C3: A,B2: A,A2: A] : ( sup_sup(A,sup_sup(A,A2,B2),C3) = sup_sup(A,A2,sup_sup(A,B2,C3)) ) ) ).

tff(fact_63_sup__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X,Z)) ) ) ).

tff(fact_64_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X,Z)) ) ) ).

tff(fact_65_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C3: A,A2: A,B2: A] : ( sup_sup(A,B2,sup_sup(A,A2,C3)) = sup_sup(A,A2,sup_sup(A,B2,C3)) ) ) ).

tff(fact_66_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,X,Y)) = sup_sup(A,X,Y) ) ) ).

tff(fact_67_sup__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,Y) = sup_sup(A,Y,X) ) ) ).

tff(fact_68_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,Y) = sup_sup(A,Y,X) ) ) ).

tff(fact_69_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,B2) = sup_sup(A,B2,A2) ) ) ).

tff(fact_70_sup__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X: A] : ( sup_sup(A,X,X) = X ) ) ).

tff(fact_71_sup_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A2: A] : ( sup_sup(A,A2,A2) = A2 ) ) ).

tff(fact_72_UnI2,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A1,B1))) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_76_UnI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A1,B1))) ) ).

tff(fact_77_sup1I2,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A,B1: fun(A,bool)] :
      ( pp(aa(A,bool,B1,Xa))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa)) ) ).

tff(fact_78_sup1I1,axiom,
    ! [A: $tType,B1: fun(A,bool),Xa: A,A1: fun(A,bool)] :
      ( pp(aa(A,bool,A1,Xa))
     => pp(aa(A,bool,sup_sup(fun(A,bool),A1,B1),Xa)) ) ).

tff(fact_79_ball__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),sup_sup(fun(A,bool),A1,B1)))
         => pp(aa(A,bool,P1,X2)) )
    <=> ( ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
           => pp(aa(A,bool,P1,X2)) )
        & ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
           => pp(aa(A,bool,P1,X2)) ) ) ) ).

tff(fact_80_bex__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( ? [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),sup_sup(fun(A,bool),A1,B1)))
          & pp(aa(A,bool,P1,X2)) )
    <=> ( ? [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
            & pp(aa(A,bool,P1,X2)) )
        | ? [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
            & pp(aa(A,bool,P1,X2)) ) ) ) ).

tff(fact_81_Un__assoc,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),sup_sup(fun(A,bool),A1,B1),C1) = sup_sup(fun(A,bool),A1,sup_sup(fun(A,bool),B1,C1)) ) ).

tff(fact_82_Un__left__commute,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,sup_sup(fun(A,bool),B1,C1)) = sup_sup(fun(A,bool),B1,sup_sup(fun(A,bool),A1,C1)) ) ).

tff(fact_83_Un__left__absorb,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,sup_sup(fun(A,bool),A1,B1)) = sup_sup(fun(A,bool),A1,B1) ) ).

tff(fact_84_Un__commute,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,B1) = sup_sup(fun(A,bool),B1,A1) ) ).

tff(fact_85_Un__def,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,fun(A,bool),bool,member(A),A1)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_86_Un__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( sup_sup(fun(A,bool),A1,A1) = A1 ) ).

tff(fact_87_sup__Un__eq,axiom,
    ! [A: $tType,S: fun(A,bool),R1: fun(A,bool),X1: A] :
      ( pp(aa(A,bool,sup_sup(fun(A,bool),combc(A,fun(A,bool),bool,member(A),R1),combc(A,fun(A,bool),bool,member(A),S)),X1))
    <=> pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),sup_sup(fun(A,bool),R1,S))) ) ).

tff(fact_88_Collect__disj__eq,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] : ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,P1),Q1)) = sup_sup(fun(A,bool),collect(A,P1),collect(A,Q1)) ) ).

tff(fact_89_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,Xa: int] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),number_number_of(A,Xa)),number_number_of(A,Y1)))
        <=> pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),Xa),Y1)) ) ) ).

tff(fact_90_rel__simps_I7_J,axiom,
    ~ pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),min),min)) ).

tff(fact_91_bin__less__0__simps_I2_J,axiom,
    pp(aa(int,bool,aa(int,fun(int,bool),ord_less(int),min),zero_zero(int))) ).

tff(fact_92_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),zero_zero(A)),one_one(A))) ) ).

tff(fact_93_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less(A),one_one(A)),zero_zero(A))) ) ).

tff(fact_94_the__elem__eq,axiom,
    ! [A: $tType,Xa: A] : ( the_elem(A,insert(A,Xa,bot_bot(fun(A,bool)))) = Xa ) ).

tff(fact_95_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Y1) )
        <=> ( Xa = Y1 ) ) ) ).

%----Arities (17)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_sup(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Lattices_Olattice,axiom,
    lattice(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

%----Helper facts (23)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),x),sup_sup(fun(atom,bool),sup_sup(fun(atom,bool),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue)))))),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,combb(bool,fun(list(int),bool),int,combk(bool,list(int)),aa(int,fun(int,bool),ord_less(int),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))),collect(atom,combs(atom,bool,bool,combb(bool,fun(bool,bool),atom,fconj,combc(atom,fun(atom,bool),bool,member(atom),set(atom,as))),atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),list_case(bool,int,fFalse,combb(bool,fun(list(int),bool),int,combk(bool,list(int)),combc(int,int,bool,ord_less(int),zero_zero(int))))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse))))))))) ).

%------------------------------------------------------------------------------
