%------------------------------------------------------------------------------
% File     : COM045_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 82
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_82 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  172 (  48 unt;  53 typ;   0 def)
%            Number of atoms       :  212 ( 121 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  103 (  10   ~;   1   |;   9   &)
%                                         (   9 <=>;  74  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   44 (  21   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :   31 (  31 usr;  10 con; 0-5 aty)
%            Number of variables   :  394 ( 357   !;   0   ?; 394   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:00
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (48)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A1: $tType] : $o ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A1: $tType] : ( ( A1 * A1 ) > A1 ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A1: $tType] : A1 ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A1: $tType] : fun(A1,fun(A1,A1)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A1: $tType] : ( A1 > fun(A1,A1) ) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > A1 ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A1: $tType,B: $tType,C2: $tType] : ( fun(A1,fun(B,C2)) > fun(list(A1),fun(list(B),list(C2))) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A1: $tType] : ( ( T * fun(A1,fun(list(A1),T)) * list(A1) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A1: $tType] : ( ( T * fun(A1,fun(list(A1),fun(T,T))) * list(A1) ) > T ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,B) * list(A1) ) > list(B) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > list(A1) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,B) * A1 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_d____,type,
    d: int ).

tff(sy_v_e,type,
    e: list(int) ).

tff(sy_v_i,type,
    i: int ).

tff(sy_v_j,type,
    j: int ).

tff(sy_v_ks_H____,type,
    ks: list(int) ).

tff(sy_v_ks____,type,
    ks1: list(int) ).

tff(sy_v_l____,type,
    l: int ).

%----Relevant facts (99)
tff(fact_0__096_Ij_Amod_Ad_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_Amod_Ad_J_Amod_Ad_A_061_Ij_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_Amod_Ad_096,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,j,d)),div_mod(int,iprod(int,ks,e),d)),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),j),iprod(int,ks,e)),d) ).

tff(fact_1_calculation,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e))),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,l,d)),div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),j),iprod(int,ks,e)),d)),d) ).

tff(fact_2__096_Il_A_L_A_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_J_Amod_Ad_A_061_Il_Amod_Ad_A_L_A_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_Amod_Ad_J_Amod_Ad_096,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e))),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,l,d)),div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e)),d)),d) ).

tff(fact_3__096_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_Amod_Ad_A_061_Ii_Amod_Ad_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_Amod_Ad_J_Amod_Ad_096,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e)),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,i,d)),div_mod(int,iprod(int,ks,e),d)),d) ).

tff(fact_4__096i_Amod_Ad_A_061_Aj_Amod_Ad_096,axiom,
    div_mod(int,i,d) = div_mod(int,j,d) ).

tff(fact_5_mod__add__self2,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1),B1) = div_mod(A1,A,B1) ) ) ).

tff(fact_6_mod__add__self1,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [A: A1,B1: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),B1),A),B1) = div_mod(A1,A,B1) ) ) ).

tff(fact_7_mod__mod__trivial,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B1: A1,A: A1] : ( div_mod(A1,div_mod(A1,A,B1),B1) = div_mod(A1,A,B1) ) ) ).

tff(fact_8_add__left__cancel,axiom,
    ! [A1: $tType] :
      ( cancel_semigroup_add(A1)
     => ! [C1: A1,B3: A1,Aa: A1] :
          ( ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),Aa),B3) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),Aa),C1) )
        <=> ( B3 = C1 ) ) ) ).

tff(fact_9_add__right__cancel,axiom,
    ! [A1: $tType] :
      ( cancel_semigroup_add(A1)
     => ! [C1: A1,Aa: A1,B3: A1] :
          ( ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),B3),Aa) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),C1),Aa) )
        <=> ( B3 = C1 ) ) ) ).

tff(fact_10_iprod__left__add__distrib,axiom,
    ! [A1: $tType] :
      ( ring(A1)
     => ! [Zs: list(A1),Ys: list(A1),Xs1: list(A1)] : ( iprod(A1,aa(list(A1),list(A1),aa(list(A1),fun(list(A1),list(A1)),plus_plus(list(A1)),Xs1),Ys),Zs) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),iprod(A1,Xs1,Zs)),iprod(A1,Ys,Zs)) ) ) ).

tff(fact_11_mod__add__right__eq,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1),C) = div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),div_mod(A1,B1,C)),C) ) ) ).

tff(fact_12_mod__add__left__eq,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1),C) = div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),div_mod(A1,A,C)),B1),C) ) ) ).

tff(fact_13_list__add__assoc,axiom,
    ! [A1: $tType] :
      ( monoid_add(A1)
     => ! [Zs: list(A1),Ys: list(A1),Xs1: list(A1)] : ( aa(list(A1),list(A1),aa(list(A1),fun(list(A1),list(A1)),plus_plus(list(A1)),aa(list(A1),list(A1),aa(list(A1),fun(list(A1),list(A1)),plus_plus(list(A1)),Xs1),Ys)),Zs) = aa(list(A1),list(A1),aa(list(A1),fun(list(A1),list(A1)),plus_plus(list(A1)),Xs1),aa(list(A1),list(A1),aa(list(A1),fun(list(A1),list(A1)),plus_plus(list(A1)),Ys),Zs)) ) ) ).

tff(fact_14_add__right__imp__eq,axiom,
    ! [A1: $tType] :
      ( cancel_semigroup_add(A1)
     => ! [C: A1,A: A1,B1: A1] :
          ( ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),B1),A) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),C),A) )
         => ( B1 = C ) ) ) ).

tff(fact_15_add__imp__eq,axiom,
    ! [A1: $tType] :
      ( cancel146912293up_add(A1)
     => ! [C: A1,B1: A1,A: A1] :
          ( ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),C) )
         => ( B1 = C ) ) ) ).

tff(fact_16_add__left__imp__eq,axiom,
    ! [A1: $tType] :
      ( cancel_semigroup_add(A1)
     => ! [C: A1,B1: A1,A: A1] :
          ( ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),C) )
         => ( B1 = C ) ) ) ).

tff(fact_17_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A1: $tType] :
      ( ab_semigroup_add(A1)
     => ! [C: A1,B1: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),C) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),B1),C)) ) ) ).

tff(fact_18_mod__add__cong,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B2: A1,B1: A1,A3: A1,C: A1,A: A1] :
          ( ( div_mod(A1,A,C) = div_mod(A1,A3,C) )
         => ( ( div_mod(A1,B1,C) = div_mod(A1,B2,C) )
           => ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1),C) = div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A3),B2),C) ) ) ) ) ).

tff(fact_19_zmod__simps_I1_J,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B1: A1,C: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),div_mod(A1,A,C)),B1),C) = div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1),C) ) ) ).

tff(fact_20_zmod__simps_I2_J,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),div_mod(A1,B1,C)),C) = div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1),C) ) ) ).

tff(fact_21_mod__add__eq,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1),C) = div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),div_mod(A1,A,C)),div_mod(A1,B1,C)),C) ) ) ).

tff(fact_22_assms_I3_J,axiom,
    div_mod(int,i,divisor(a)) = div_mod(int,j,divisor(a)) ).

tff(fact_23_NDvd,axiom,
    a = nDvd(d,l,ks1) ).

tff(fact_24_list__add__def,axiom,
    ! [A1: $tType] :
      ( ( cl_Groups_Oplus(A1)
        & zero(A1) )
     => ( plus_plus(list(A1)) = zipwith0(A1,A1,A1,plus_plus(A1)) ) ) ).

tff(fact_25_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [D: A1,C: A1,B1: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),C),D)) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),C)),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),B1),D)) ) ) ).

tff(fact_26_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [C: A1,B1: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),C) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),C)),B1) ) ) ).

tff(fact_27_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [C: A1,B1: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),C) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),B1),C)) ) ) ).

tff(fact_28_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [D: A1,C: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),C),D)) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),C)),D) ) ) ).

tff(fact_29_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [D: A1,C: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),C),D)) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),C),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),D)) ) ) ).

tff(fact_30_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [C: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),C) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),C),A) ) ) ).

tff(fact_31_atom_Osimps_I3_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List: list(int),Int21: int,Int11: int] :
      ( ( nDvd(Int11,Int21,List) = nDvd(Int12,Int22,List3) )
    <=> ( ( Int11 = Int12 )
        & ( Int21 = Int22 )
        & ( List = List3 ) ) ) ).

tff(fact_32_divisor_Osimps_I3_J,axiom,
    ! [Ks: list(int),I1: int,D: int] : ( divisor(nDvd(D,I1,Ks)) = D ) ).

tff(fact_33__096ks_A_061_A1_A_D_Aks_H_096,axiom,
    ks1 = cons(int,one_one(int),ks) ).

tff(fact_34_assms_I2_J,axiom,
    hd_coeff(a) = one_one(int) ).

tff(fact_35_list__add__Cons,axiom,
    ! [A1: $tType] :
      ( ( cl_Groups_Oplus(A1)
        & zero(A1) )
     => ! [Ys: list(A1),Y: A1,Xs1: list(A1),X: A1] : ( aa(list(A1),list(A1),aa(list(A1),fun(list(A1),list(A1)),plus_plus(list(A1)),cons(A1,X,Xs1)),cons(A1,Y,Ys)) = cons(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),X),Y),aa(list(A1),list(A1),aa(list(A1),fun(list(A1),list(A1)),plus_plus(list(A1)),Xs1),Ys)) ) ) ).

tff(fact_36_mod__mult__self2,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),aa(A1,A1,times_times(A1,B1),C)),B1) = div_mod(A1,A,B1) ) ) ).

tff(fact_37__096_B_Bthesis_O_A_I_B_Bks_H_O_Aks_A_061_A1_A_D_Aks_H_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ks1: list(int)] : ( ks1 != cons(int,one_one(int),Ks1) ) ).

tff(fact_38_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A1: $tType,C2: $tType] :
      ( ( zero(C2)
        & zero(B) )
     => ! [Ys1: list(C2),Y1: C2,Xs: list(B),X2: B,F: fun(B,fun(C2,A1))] : ( aa(list(C2),list(A1),aa(list(B),fun(list(C2),list(A1)),zipwith0(B,C2,A1,F),cons(B,X2,Xs)),cons(C2,Y1,Ys1)) = cons(A1,aa(C2,A1,aa(B,fun(C2,A1),F,X2),Y1),aa(list(C2),list(A1),aa(list(B),fun(list(C2),list(A1)),zipwith0(B,C2,A1,F),Xs),Ys1)) ) ) ).

tff(fact_39_mod__mult__self1,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B1: A1,C: A1,A: A1] : ( div_mod(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),aa(A1,A1,times_times(A1,C),B1)),B1) = div_mod(A1,A,B1) ) ) ).

tff(fact_40_iprod__Cons,axiom,
    ! [A1: $tType] :
      ( ring(A1)
     => ! [Ys: list(A1),Y: A1,Xs1: list(A1),X: A1] : ( iprod(A1,cons(A1,X,Xs1),cons(A1,Y,Ys)) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,X),Y)),iprod(A1,Xs1,Ys)) ) ) ).

tff(fact_41_comm__semiring__1__class_Onormalizing__semiring__rules_I4_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [M: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),M),M) = aa(A1,A1,times_times(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),one_one(A1)),one_one(A1))),M) ) ) ).

tff(fact_42_comm__semiring__1__class_Onormalizing__semiring__rules_I3_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [A: A1,M: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),M),aa(A1,A1,times_times(A1,A),M)) = aa(A1,A1,times_times(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),one_one(A1))),M) ) ) ).

tff(fact_43_comm__semiring__1__class_Onormalizing__semiring__rules_I2_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [M: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,A),M)),M) = aa(A1,A1,times_times(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),one_one(A1))),M) ) ) ).

tff(fact_44_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Ry: A1,Rx: A1,Ly: A1,Lx: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Ly)),aa(A1,A1,times_times(A1,Rx),Ry)) = aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Rx)),aa(A1,A1,times_times(A1,Ly),Ry)) ) ) ).

tff(fact_45_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Ry: A1,Rx: A1,Ly: A1,Lx: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Ly)),aa(A1,A1,times_times(A1,Rx),Ry)) = aa(A1,A1,times_times(A1,Rx),aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Ly)),Ry)) ) ) ).

tff(fact_46_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Ry: A1,Rx: A1,Ly: A1,Lx: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Ly)),aa(A1,A1,times_times(A1,Rx),Ry)) = aa(A1,A1,times_times(A1,Lx),aa(A1,A1,times_times(A1,Ly),aa(A1,A1,times_times(A1,Rx),Ry))) ) ) ).

tff(fact_47_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Rx: A1,Ly: A1,Lx: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Ly)),Rx) = aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Rx)),Ly) ) ) ).

tff(fact_48_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Rx: A1,Ly: A1,Lx: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Ly)),Rx) = aa(A1,A1,times_times(A1,Lx),aa(A1,A1,times_times(A1,Ly),Rx)) ) ) ).

tff(fact_49_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Ry: A1,Rx: A1,Lx: A1] : ( aa(A1,A1,times_times(A1,Lx),aa(A1,A1,times_times(A1,Rx),Ry)) = aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,Lx),Rx)),Ry) ) ) ).

tff(fact_50_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Ry: A1,Rx: A1,Lx: A1] : ( aa(A1,A1,times_times(A1,Lx),aa(A1,A1,times_times(A1,Rx),Ry)) = aa(A1,A1,times_times(A1,Rx),aa(A1,A1,times_times(A1,Lx),Ry)) ) ) ).

tff(fact_51_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [B1: A1,A: A1] : ( aa(A1,A1,times_times(A1,A),B1) = aa(A1,A1,times_times(A1,B1),A) ) ) ).

tff(fact_52_comm__semiring__1__class_Onormalizing__semiring__rules_I12_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [A: A1] : ( aa(A1,A1,times_times(A1,A),one_one(A1)) = A ) ) ).

tff(fact_53_comm__semiring__1__class_Onormalizing__semiring__rules_I11_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [A: A1] : ( aa(A1,A1,times_times(A1,one_one(A1)),A) = A ) ) ).

tff(fact_54_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A1: $tType] :
      ( ab_semigroup_mult(A1)
     => ! [C: A1,B1: A1,A: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,times_times(A1,A),B1)),C) = aa(A1,A1,times_times(A1,A),aa(A1,A1,times_times(A1,B1),C)) ) ) ).

tff(fact_55_mult_Ocomm__neutral,axiom,
    ! [A1: $tType] :
      ( comm_monoid_mult(A1)
     => ! [A: A1] : ( aa(A1,A1,times_times(A1,A),one_one(A1)) = A ) ) ).

tff(fact_56_mult__1__right,axiom,
    ! [A1: $tType] :
      ( monoid_mult(A1)
     => ! [A: A1] : ( aa(A1,A1,times_times(A1,A),one_one(A1)) = A ) ) ).

tff(fact_57_one__reorient,axiom,
    ! [A1: $tType] :
      ( one(A1)
     => ! [X2: A1] :
          ( ( one_one(A1) = X2 )
        <=> ( X2 = one_one(A1) ) ) ) ).

tff(fact_58_mult__1,axiom,
    ! [A1: $tType] :
      ( comm_monoid_mult(A1)
     => ! [A: A1] : ( aa(A1,A1,times_times(A1,one_one(A1)),A) = A ) ) ).

tff(fact_59_mult__1__left,axiom,
    ! [A1: $tType] :
      ( monoid_mult(A1)
     => ! [A: A1] : ( aa(A1,A1,times_times(A1,one_one(A1)),A) = A ) ) ).

tff(fact_60_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [Z3: A1,Y: A1,X: A1] : ( aa(A1,A1,times_times(A1,X),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),Y),Z3)) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,X),Y)),aa(A1,A1,times_times(A1,X),Z3)) ) ) ).

tff(fact_61_crossproduct__noteq,axiom,
    ! [A1: $tType] :
      ( semiri456707255roduct(A1)
     => ! [Da: A1,C1: A1,B3: A1,Aa: A1] :
          ( ( ( Aa != B3 )
            & ( C1 != Da ) )
        <=> ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,Aa),C1)),aa(A1,A1,times_times(A1,B3),Da)) != aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,Aa),Da)),aa(A1,A1,times_times(A1,B3),C1)) ) ) ) ).

tff(fact_62_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [C: A1,B1: A1,A: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),C) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,A),C)),aa(A1,A1,times_times(A1,B1),C)) ) ) ).

tff(fact_63_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A1: $tType] :
      ( comm_semiring_1(A1)
     => ! [B1: A1,M: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,A),M)),aa(A1,A1,times_times(A1,B1),M)) = aa(A1,A1,times_times(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),M) ) ) ).

tff(fact_64_crossproduct__eq,axiom,
    ! [A1: $tType] :
      ( semiri456707255roduct(A1)
     => ! [Z: A1,X2: A1,Y1: A1,W1: A1] :
          ( ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,W1),Y1)),aa(A1,A1,times_times(A1,X2),Z)) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,W1),Z)),aa(A1,A1,times_times(A1,X2),Y1)) )
        <=> ( ( W1 = X2 )
            | ( Y1 = Z ) ) ) ) ).

tff(fact_65_mod__mult__cong,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B2: A1,B1: A1,A3: A1,C: A1,A: A1] :
          ( ( div_mod(A1,A,C) = div_mod(A1,A3,C) )
         => ( ( div_mod(A1,B1,C) = div_mod(A1,B2,C) )
           => ( div_mod(A1,aa(A1,A1,times_times(A1,A),B1),C) = div_mod(A1,aa(A1,A1,times_times(A1,A3),B2),C) ) ) ) ) ).

tff(fact_66_zmod__simps_I4_J,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B1: A1,C: A1,A: A1] : ( div_mod(A1,aa(A1,A1,times_times(A1,div_mod(A1,A,C)),B1),C) = div_mod(A1,aa(A1,A1,times_times(A1,A),B1),C) ) ) ).

tff(fact_67_mod__mult__mult2,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B1: A1,C: A1,A: A1] : ( div_mod(A1,aa(A1,A1,times_times(A1,A),C),aa(A1,A1,times_times(A1,B1),C)) = aa(A1,A1,times_times(A1,div_mod(A1,A,B1)),C) ) ) ).

tff(fact_68_mod__mult__mult1,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [B1: A1,A: A1,C: A1] : ( div_mod(A1,aa(A1,A1,times_times(A1,C),A),aa(A1,A1,times_times(A1,C),B1)) = aa(A1,A1,times_times(A1,C),div_mod(A1,A,B1)) ) ) ).

tff(fact_69_mod__mult__eq,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,times_times(A1,A),B1),C) = div_mod(A1,aa(A1,A1,times_times(A1,div_mod(A1,A,C)),div_mod(A1,B1,C)),C) ) ) ).

tff(fact_70_mod__mult__left__eq,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,times_times(A1,A),B1),C) = div_mod(A1,aa(A1,A1,times_times(A1,div_mod(A1,A,C)),B1),C) ) ) ).

tff(fact_71_mod__mult__right__eq,axiom,
    ! [A1: $tType] :
      ( semiring_div(A1)
     => ! [C: A1,B1: A1,A: A1] : ( div_mod(A1,aa(A1,A1,times_times(A1,A),B1),C) = div_mod(A1,aa(A1,A1,times_times(A1,A),div_mod(A1,B1,C)),C) ) ) ).

tff(fact_72_zmod__simps_I3_J,axiom,
    ! [C: int,B1: int,A: int] : ( div_mod(int,aa(int,int,times_times(int,A),div_mod(int,B1,C)),C) = div_mod(int,aa(int,int,times_times(int,A),B1),C) ) ).

tff(fact_73_zmod__zmult1__eq,axiom,
    ! [C: int,B1: int,A: int] : ( div_mod(int,aa(int,int,times_times(int,A),B1),C) = div_mod(int,aa(int,int,times_times(int,A),div_mod(int,B1,C)),C) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A1: $tType,G: fun(A1,B),F: fun(A1,B)] :
      ( ! [X1: A1] : ( aa(A1,B,F,X1) = aa(A1,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_list_Oinject,axiom,
    ! [A1: $tType,List3: list(A1),A2: A1,List: list(A1),Aa: A1] :
      ( ( cons(A1,Aa,List) = cons(A1,A2,List3) )
    <=> ( ( Aa = A2 )
        & ( List = List3 ) ) ) ).

tff(fact_76_mult__left__idem,axiom,
    ! [A1: $tType] :
      ( ab_sem1668676832m_mult(A1)
     => ! [B1: A1,A: A1] : ( aa(A1,A1,times_times(A1,A),aa(A1,A1,times_times(A1,A),B1)) = aa(A1,A1,times_times(A1,A),B1) ) ) ).

tff(fact_77_comm__semiring__class_Odistrib,axiom,
    ! [A1: $tType] :
      ( comm_semiring(A1)
     => ! [C: A1,B1: A1,A: A1] : ( aa(A1,A1,times_times(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),C) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,A),C)),aa(A1,A1,times_times(A1,B1),C)) ) ) ).

tff(fact_78_combine__common__factor,axiom,
    ! [A1: $tType] :
      ( semiring(A1)
     => ! [C: A1,B1: A1,E: A1,A: A1] : ( aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,A),E)),aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,B1),E)),C)) = aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),aa(A1,A1,times_times(A1,aa(A1,A1,aa(A1,fun(A1,A1),plus_plus(A1),A),B1)),E)),C) ) ) ).

tff(fact_79_atom_Orecs_I3_J,axiom,
    ! [A1: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A1))),F2: fun(int,fun(int,fun(list(int),A1))),F1: fun(int,fun(list(int),A1))] : ( atom_rec(A1,F1,F2,F3,nDvd(Int11,Int21,List)) = aa(list(int),A1,aa(int,fun(list(int),A1),aa(int,fun(int,fun(list(int),A1)),F3,Int11),Int21),List) ) ).

tff(fact_80_mult__idem,axiom,
    ! [A1: $tType] :
      ( ab_sem1668676832m_mult(A1)
     => ! [X: A1] : ( aa(A1,A1,times_times(A1,X),X) = X ) ) ).

tff(fact_81_times_Oidem,axiom,
    ! [A1: $tType] :
      ( ab_sem1668676832m_mult(A1)
     => ! [A: A1] : ( aa(A1,A1,times_times(A1,A),A) = A ) ) ).

tff(fact_82_not__Cons__self2,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] : ( cons(A1,X,Xs1) != Xs1 ) ).

tff(fact_83_not__Cons__self,axiom,
    ! [A1: $tType,X: A1,Xs1: list(A1)] : ( Xs1 != cons(A1,X,Xs1) ) ).

tff(fact_84_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( aa(int,int,times_times(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)),W) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,Z1),W)),aa(int,int,times_times(int,Z2),W)) ) ).

tff(fact_85_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( aa(int,int,times_times(int,W),aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,W),Z1)),aa(int,int,times_times(int,W),Z2)) ) ).

tff(fact_86_list_Osimps_I5_J,axiom,
    ! [A1: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A1)),F1: A1] : ( list_case(A1,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A1,aa(B,fun(list(B),A1),F2,Aa),List) ) ).

tff(fact_87_splice_Osimps_I3_J,axiom,
    ! [A1: $tType,Ys: list(A1),Y: A1,Xs1: list(A1),X: A1] : ( splice(A1,cons(A1,X,Xs1),cons(A1,Y,Ys)) = cons(A1,X,cons(A1,Y,splice(A1,Xs1,Ys))) ) ).

tff(fact_88_atom_Osimps_I12_J,axiom,
    ! [A1: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A1))),F2: fun(int,fun(int,fun(list(int),A1))),F1: fun(int,fun(list(int),A1))] : ( atom_case(A1,F1,F2,F3,nDvd(Int11,Int21,List)) = aa(list(int),A1,aa(int,fun(list(int),A1),aa(int,fun(int,fun(list(int),A1)),F3,Int11),Int21),List) ) ).

tff(fact_89_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I1: int] : ( divisor(c_PresArith_Oatom_OLe(I1,Ks)) = one_one(int) ) ).

tff(fact_90_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int4: int,List: list(int),Int: int] :
      ( ( c_PresArith_Oatom_OLe(Int,List) = c_PresArith_Oatom_OLe(Int4,List3) )
    <=> ( ( Int = Int4 )
        & ( List = List3 ) ) ) ).

tff(fact_91_atom_Orecs_I1_J,axiom,
    ! [A1: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A1))),F2: fun(int,fun(int,fun(list(int),A1))),F1: fun(int,fun(list(int),A1))] : ( atom_rec(A1,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A1,aa(int,fun(list(int),A1),F1,Int),List) ) ).

tff(fact_92_atom_Osimps_I6_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int,List2: list(int),Int3: int] : ( c_PresArith_Oatom_OLe(Int3,List2) != nDvd(Int1,Int2,List1) ) ).

tff(fact_93_atom_Osimps_I7_J,axiom,
    ! [List2: list(int),Int3: int,List1: list(int),Int2: int,Int1: int] : ( nDvd(Int1,Int2,List1) != c_PresArith_Oatom_OLe(Int3,List2) ) ).

tff(fact_94_atom_Osimps_I10_J,axiom,
    ! [A1: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A1))),F2: fun(int,fun(int,fun(list(int),A1))),F1: fun(int,fun(list(int),A1))] : ( atom_case(A1,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A1,aa(int,fun(list(int),A1),F1,Int),List) ) ).

tff(fact_95_list_Orecs_I2_J,axiom,
    ! [A1: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A1,A1))),F1: A1] : ( list_rec(A1,B,F1,F2,cons(B,Aa,List)) = aa(A1,A1,aa(list(B),fun(A1,A1),aa(B,fun(list(B),fun(A1,A1)),F2,Aa),List),list_rec(A1,B,F1,F2,List)) ) ).

tff(fact_96_divisor__asubst,axiom,
    ! [A: atom,Ks: list(int),I1: int] : ( divisor(asubst(I1,Ks,A)) = divisor(A) ) ).

tff(fact_97_asubst_Osimps_I3_J,axiom,
    ! [Ksa: list(int),K: int,Ia: int,Da: int,Ks_a: list(int),I: int] : ( asubst(I,Ks_a,nDvd(Da,Ia,cons(int,K,Ksa))) = nDvd(Da,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),aa(int,int,times_times(int,K),I)),aa(list(int),list(int),aa(list(int),fun(list(int),list(int)),plus_plus(list(int)),map(int,int,times_times(int,K),Ks_a)),Ksa)) ) ).

tff(fact_98_IZ__asubst,axiom,
    ! [Xs: list(int),Aa: atom,Ksa: list(int),Ia: int] :
      ( i_Z(asubst(Ia,Ksa,Aa),Xs)
    <=> i_Z(Aa,cons(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),iprod(int,Ksa,Xs)),Xs)) ) ).

%----Arities (17)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring,axiom,
    comm_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,l,d)),div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),j),iprod(int,ks,e)),d)),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),j),iprod(int,ks,e))),d) ).

%------------------------------------------------------------------------------
