%------------------------------------------------------------------------------
% File     : COM044_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 80
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_80 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  172 (  48 unt;  53 typ;   0 def)
%            Number of atoms       :  212 ( 121 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  103 (  10   ~;   1   |;   9   &)
%                                         (   9 <=>;  74  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   44 (  21   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :   31 (  31 usr;  10 con; 0-5 aty)
%            Number of variables   :  399 ( 362   !;   0   ?; 399   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:58
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (48)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C2: $tType] : ( fun(A,fun(B,C2)) > fun(list(A),fun(list(B),list(C2))) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_d____,type,
    d: int ).

tff(sy_v_e,type,
    e: list(int) ).

tff(sy_v_i,type,
    i: int ).

tff(sy_v_j,type,
    j: int ).

tff(sy_v_ks_H____,type,
    ks: list(int) ).

tff(sy_v_ks____,type,
    ks1: list(int) ).

tff(sy_v_l____,type,
    l: int ).

%----Relevant facts (99)
tff(fact_0__096_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_Amod_Ad_A_061_Ii_Amod_Ad_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_Amod_Ad_J_Amod_Ad_096,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e)),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,i,d)),div_mod(int,iprod(int,ks,e),d)),d) ).

tff(fact_1__096i_Amod_Ad_A_061_Aj_Amod_Ad_096,axiom,
    div_mod(int,i,d) = div_mod(int,j,d) ).

tff(fact_2_calculation,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e))),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,l,d)),div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,j,d)),div_mod(int,iprod(int,ks,e),d)),d)),d) ).

tff(fact_3_mod__add__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_4_mod__add__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_5__096_Il_A_L_A_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_J_Amod_Ad_A_061_Il_Amod_Ad_A_L_A_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_Amod_Ad_J_Amod_Ad_096,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e))),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,l,d)),div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e)),d)),d) ).

tff(fact_6_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,div_mod(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_7_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B3: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),B3) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),C1) )
        <=> ( B3 = C1 ) ) ) ).

tff(fact_8_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,B3: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B3),Aa) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),Aa) )
        <=> ( B3 = C1 ) ) ) ).

tff(fact_9_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs1: list(A)] : ( iprod(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),Ys),Zs) = aa(A,A,aa(A,fun(A,A),plus_plus(A),iprod(A,Xs1,Zs)),iprod(A,Ys,Zs)) ) ) ).

tff(fact_10_mod__add__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),div_mod(A,B1,C)),C) ) ) ).

tff(fact_11_mod__add__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C)),B1),C) ) ) ).

tff(fact_12_list__add__assoc,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),Ys: list(A),Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),Ys)),Zs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Ys),Zs)) ) ) ).

tff(fact_13_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),A1) )
         => ( B1 = C ) ) ) ).

tff(fact_14_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C) )
         => ( B1 = C ) ) ) ).

tff(fact_15_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C) )
         => ( B1 = C ) ) ) ).

tff(fact_16_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C)) ) ) ).

tff(fact_17_mod__add__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,B1: A,A3: A,C: A,A1: A] :
          ( ( div_mod(A,A1,C) = div_mod(A,A3,C) )
         => ( ( div_mod(A,B1,C) = div_mod(A,B2,C) )
           => ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A3),B2),C) ) ) ) ) ).

tff(fact_18_zmod__simps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C)),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) ) ) ).

tff(fact_19_zmod__simps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),div_mod(A,B1,C)),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) ) ) ).

tff(fact_20_mod__add__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C)),div_mod(A,B1,C)),C) ) ) ).

tff(fact_21_assms_I3_J,axiom,
    div_mod(int,i,divisor(a)) = div_mod(int,j,divisor(a)) ).

tff(fact_22_NDvd,axiom,
    a = nDvd(d,l,ks1) ).

tff(fact_23_list__add__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ( plus_plus(list(A)) = zipwith0(A,A,A,plus_plus(A)) ) ) ).

tff(fact_24_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),C),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C)),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),D)) ) ) ).

tff(fact_25_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C)),B1) ) ) ).

tff(fact_26_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C)) ) ) ).

tff(fact_27_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C)),D) ) ) ).

tff(fact_28_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),D)) ) ) ).

tff(fact_29_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),A1) ) ) ).

tff(fact_30_atom_Osimps_I3_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List: list(int),Int21: int,Int11: int] :
      ( ( nDvd(Int11,Int21,List) = nDvd(Int12,Int22,List3) )
    <=> ( ( Int11 = Int12 )
        & ( Int21 = Int22 )
        & ( List = List3 ) ) ) ).

tff(fact_31_divisor_Osimps_I3_J,axiom,
    ! [Ks: list(int),I1: int,D: int] : ( divisor(nDvd(D,I1,Ks)) = D ) ).

tff(fact_32__096ks_A_061_A1_A_D_Aks_H_096,axiom,
    ks1 = cons(int,one_one(int),ks) ).

tff(fact_33_assms_I2_J,axiom,
    hd_coeff(a) = one_one(int) ).

tff(fact_34_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs1: list(A),X1: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),cons(A,X1,Xs1)),cons(A,Y,Ys)) = cons(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),X1),Y),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),Ys)) ) ) ).

tff(fact_35_mod__mult__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,times_times(A,B1),C)),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_36__096_B_Bthesis_O_A_I_B_Bks_H_O_Aks_A_061_A1_A_D_Aks_H_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ks1: list(int)] : ( ks1 != cons(int,one_one(int),Ks1) ) ).

tff(fact_37_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C2: $tType] :
      ( ( zero(C2)
        & zero(B) )
     => ! [Ys1: list(C2),Y1: C2,Xs: list(B),X: B,F: fun(B,fun(C2,A))] : ( aa(list(C2),list(A),aa(list(B),fun(list(C2),list(A)),zipwith0(B,C2,A,F),cons(B,X,Xs)),cons(C2,Y1,Ys1)) = cons(A,aa(C2,A,aa(B,fun(C2,A),F,X),Y1),aa(list(C2),list(A),aa(list(B),fun(list(C2),list(A)),zipwith0(B,C2,A,F),Xs),Ys1)) ) ) ).

tff(fact_38_mod__mult__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,times_times(A,C),B1)),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_39_iprod__Cons,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A),Y: A,Xs1: list(A),X1: A] : ( iprod(A,cons(A,X1,Xs1),cons(A,Y,Ys)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,X1),Y)),iprod(A,Xs1,Ys)) ) ) ).

tff(fact_40_comm__semiring__1__class_Onormalizing__semiring__rules_I4_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [M: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),M),M) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A))),M) ) ) ).

tff(fact_41_comm__semiring__1__class_Onormalizing__semiring__rules_I3_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A,M: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),M),aa(A,A,times_times(A,A1),M)) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),one_one(A))),M) ) ) ).

tff(fact_42_comm__semiring__1__class_Onormalizing__semiring__rules_I2_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [M: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),M)),M) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),one_one(A))),M) ) ) ).

tff(fact_43_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),aa(A,A,times_times(A,Ly),Ry)) ) ) ).

tff(fact_44_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Rx),aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Ry)) ) ) ).

tff(fact_45_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Ly),aa(A,A,times_times(A,Rx),Ry))) ) ) ).

tff(fact_46_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Rx) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),Ly) ) ) ).

tff(fact_47_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Rx) = aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Ly),Rx)) ) ) ).

tff(fact_48_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),Ry) ) ) ).

tff(fact_49_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Rx),aa(A,A,times_times(A,Lx),Ry)) ) ) ).

tff(fact_50_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A1: A] : ( aa(A,A,times_times(A,A1),B1) = aa(A,A,times_times(A,B1),A1) ) ) ).

tff(fact_51_comm__semiring__1__class_Onormalizing__semiring__rules_I12_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_52_comm__semiring__1__class_Onormalizing__semiring__rules_I11_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_53_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C: A,B1: A,A1: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,A1),B1)),C) = aa(A,A,times_times(A,A1),aa(A,A,times_times(A,B1),C)) ) ) ).

tff(fact_54_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_55_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_56_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X: A] :
          ( ( one_one(A) = X )
        <=> ( X = one_one(A) ) ) ) ).

tff(fact_57_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_58_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_59_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Z3: A,Y: A,X1: A] : ( aa(A,A,times_times(A,X1),aa(A,A,aa(A,fun(A,A),plus_plus(A),Y),Z3)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,X1),Y)),aa(A,A,times_times(A,X1),Z3)) ) ) ).

tff(fact_60_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Da: A,C1: A,B3: A,Aa: A] :
          ( ( ( Aa != B3 )
            & ( C1 != Da ) )
        <=> ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,Aa),C1)),aa(A,A,times_times(A,B3),Da)) != aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,Aa),Da)),aa(A,A,times_times(A,B3),C1)) ) ) ) ).

tff(fact_61_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] : ( aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),C)),aa(A,A,times_times(A,B1),C)) ) ) ).

tff(fact_62_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,M: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),M)),aa(A,A,times_times(A,B1),M)) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),M) ) ) ).

tff(fact_63_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Z: A,X: A,Y1: A,W1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,W1),Y1)),aa(A,A,times_times(A,X),Z)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,W1),Z)),aa(A,A,times_times(A,X),Y1)) )
        <=> ( ( W1 = X )
            | ( Y1 = Z ) ) ) ) ).

tff(fact_64_mod__mult__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,B1: A,A3: A,C: A,A1: A] :
          ( ( div_mod(A,A1,C) = div_mod(A,A3,C) )
         => ( ( div_mod(A,B1,C) = div_mod(A,B2,C) )
           => ( div_mod(A,aa(A,A,times_times(A,A1),B1),C) = div_mod(A,aa(A,A,times_times(A,A3),B2),C) ) ) ) ) ).

tff(fact_65_zmod__simps_I4_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C)),B1),C) = div_mod(A,aa(A,A,times_times(A,A1),B1),C) ) ) ).

tff(fact_66_mod__mult__mult2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),C),aa(A,A,times_times(A,B1),C)) = aa(A,A,times_times(A,div_mod(A,A1,B1)),C) ) ) ).

tff(fact_67_mod__mult__mult1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A,C: A] : ( div_mod(A,aa(A,A,times_times(A,C),A1),aa(A,A,times_times(A,C),B1)) = aa(A,A,times_times(A,C),div_mod(A,A1,B1)) ) ) ).

tff(fact_68_mod__mult__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B1),C) = div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C)),div_mod(A,B1,C)),C) ) ) ).

tff(fact_69_mod__mult__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B1),C) = div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C)),B1),C) ) ) ).

tff(fact_70_mod__mult__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B1),C) = div_mod(A,aa(A,A,times_times(A,A1),div_mod(A,B1,C)),C) ) ) ).

tff(fact_71_zmod__simps_I3_J,axiom,
    ! [C: int,B1: int,A1: int] : ( div_mod(int,aa(int,int,times_times(int,A1),div_mod(int,B1,C)),C) = div_mod(int,aa(int,int,times_times(int,A1),B1),C) ) ).

tff(fact_72_zmod__zmult1__eq,axiom,
    ! [C: int,B1: int,A1: int] : ( div_mod(int,aa(int,int,times_times(int,A1),B1),C) = div_mod(int,aa(int,int,times_times(int,A1),div_mod(int,B1,C)),C) ) ).

tff(fact_73_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A2: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A2,List3) )
    <=> ( ( Aa = A2 )
        & ( List = List3 ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B1: A,A1: A] : ( aa(A,A,times_times(A,A1),aa(A,A,times_times(A,A1),B1)) = aa(A,A,times_times(A,A1),B1) ) ) ).

tff(fact_76_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( comm_semiring(A)
     => ! [C: A,B1: A,A1: A] : ( aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),C)),aa(A,A,times_times(A,B1),C)) ) ) ).

tff(fact_77_combine__common__factor,axiom,
    ! [A: $tType] :
      ( semiring(A)
     => ! [C: A,B1: A,E: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),E)),aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,B1),E)),C)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),E)),C) ) ) ).

tff(fact_78_atom_Orecs_I3_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,nDvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int11),Int21),List) ) ).

tff(fact_79_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X1: A] : ( aa(A,A,times_times(A,X1),X1) = X1 ) ) ).

tff(fact_80_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),A1) = A1 ) ) ).

tff(fact_81_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( cons(A,X1,Xs1) != Xs1 ) ).

tff(fact_82_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != cons(A,X1,Xs1) ) ).

tff(fact_83_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( aa(int,int,times_times(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)),W) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,Z1),W)),aa(int,int,times_times(int,Z2),W)) ) ).

tff(fact_84_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( aa(int,int,times_times(int,W),aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,W),Z1)),aa(int,int,times_times(int,W),Z2)) ) ).

tff(fact_85_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_86_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs1: list(A),X1: A] : ( splice(A,cons(A,X1,Xs1),cons(A,Y,Ys)) = cons(A,X1,cons(A,Y,splice(A,Xs1,Ys))) ) ).

tff(fact_87_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,nDvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int11),Int21),List) ) ).

tff(fact_88_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I1: int] : ( divisor(c_PresArith_Oatom_OLe(I1,Ks)) = one_one(int) ) ).

tff(fact_89_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int4: int,List: list(int),Int: int] :
      ( ( c_PresArith_Oatom_OLe(Int,List) = c_PresArith_Oatom_OLe(Int4,List3) )
    <=> ( ( Int = Int4 )
        & ( List = List3 ) ) ) ).

tff(fact_90_atom_Osimps_I6_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int,List2: list(int),Int3: int] : ( c_PresArith_Oatom_OLe(Int3,List2) != nDvd(Int1,Int2,List1) ) ).

tff(fact_91_atom_Osimps_I7_J,axiom,
    ! [List2: list(int),Int3: int,List1: list(int),Int2: int,Int1: int] : ( nDvd(Int1,Int2,List1) != c_PresArith_Oatom_OLe(Int3,List2) ) ).

tff(fact_92_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_93_atom_Orecs_I1_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_94_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,Aa,List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,Aa),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_95_divisor__asubst,axiom,
    ! [A1: atom,Ks: list(int),I1: int] : ( divisor(asubst(I1,Ks,A1)) = divisor(A1) ) ).

tff(fact_96_asubst_Osimps_I3_J,axiom,
    ! [Ksa: list(int),K: int,Ia: int,Da: int,Ks_a: list(int),I: int] : ( asubst(I,Ks_a,nDvd(Da,Ia,cons(int,K,Ksa))) = nDvd(Da,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),aa(int,int,times_times(int,K),I)),aa(list(int),list(int),aa(list(int),fun(list(int),list(int)),plus_plus(list(int)),map(int,int,times_times(int,K),Ks_a)),Ksa)) ) ).

tff(fact_97_IZ__asubst,axiom,
    ! [Xs: list(int),Aa: atom,Ksa: list(int),Ia: int] :
      ( i_Z(asubst(Ia,Ksa,Aa),Xs)
    <=> i_Z(Aa,cons(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),iprod(int,Ksa,Xs)),Xs)) ) ).

tff(fact_98_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X,Xs)) = cons(A,aa(B,A,F,X),map(B,A,F,Xs)) ) ).

%----Arities (17)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring,axiom,
    comm_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,j,d)),div_mod(int,iprod(int,ks,e),d)),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),j),iprod(int,ks,e)),d) ).

%------------------------------------------------------------------------------
