%------------------------------------------------------------------------------
% File     : COM043_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 78
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_78 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  184 (  56 unt;  49 typ;   0 def)
%            Number of atoms       :  247 ( 129 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  120 (   8   ~;   0   |;   7   &)
%                                         (  21 <=>;  84  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   23 (  15   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-2 aty)
%            Number of functors    :   25 (  25 usr;  10 con; 0-4 aty)
%            Number of variables   :  289 ( 261   !;   0   ?; 289   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:56
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ouminus,type,
    uminus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Oring__div,type,
    ring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Nat__Transfer_Ois__nat,type,
    nat_is_nat: int > $o ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_d____,type,
    d: int ).

tff(sy_v_e,type,
    e: list(int) ).

tff(sy_v_i,type,
    i: int ).

tff(sy_v_j,type,
    j: int ).

tff(sy_v_ks_H____,type,
    ks1: list(int) ).

tff(sy_v_ks____,type,
    ks: list(int) ).

tff(sy_v_l____,type,
    l: int ).

%----Relevant facts (98)
tff(fact_0_NDvd,axiom,
    a = nDvd(d,l,ks) ).

tff(fact_1_assms_I3_J,axiom,
    div_mod(int,i,divisor(a)) = div_mod(int,j,divisor(a)) ).

tff(fact_2_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,div_mod(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_3__096_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_Amod_Ad_A_061_Ii_Amod_Ad_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_Amod_Ad_J_Amod_Ad_096,axiom,
    div_mod(int,plus_plus(int,i,iprod(int,ks1,e)),d) = div_mod(int,plus_plus(int,div_mod(int,i,d),div_mod(int,iprod(int,ks1,e),d)),d) ).

tff(fact_4__096_Il_A_L_A_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_J_Amod_Ad_A_061_Il_Amod_Ad_A_L_A_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_Amod_Ad_J_Amod_Ad_096,axiom,
    div_mod(int,plus_plus(int,l,plus_plus(int,i,iprod(int,ks1,e))),d) = div_mod(int,plus_plus(int,div_mod(int,l,d),div_mod(int,plus_plus(int,i,iprod(int,ks1,e)),d)),d) ).

tff(fact_5_calculation,axiom,
    div_mod(int,plus_plus(int,l,plus_plus(int,i,iprod(int,ks1,e))),d) = div_mod(int,plus_plus(int,div_mod(int,l,d),div_mod(int,plus_plus(int,div_mod(int,i,d),div_mod(int,iprod(int,ks1,e),d)),d)),d) ).

tff(fact_6_zmod__zero,axiom,
    ! [B1: int] : ( div_mod(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_7_zmod__self,axiom,
    ! [A1: int] : ( div_mod(int,A1,A1) = zero_zero(int) ) ).

tff(fact_8_Divides_Otransfer__int__nat__function__closures_I2_J,axiom,
    ! [Y: int,X: int] :
      ( nat_is_nat(X)
     => ( nat_is_nat(Y)
       => nat_is_nat(div_mod(int,X,Y)) ) ) ).

tff(fact_9_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_10_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_11_zmod__zminus__zminus,axiom,
    ! [B1: int,A1: int] : ( div_mod(int,uminus_uminus(int,A1),uminus_uminus(int,B1)) = uminus_uminus(int,div_mod(int,A1,B1)) ) ).

tff(fact_12_mod__add__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_13_mod__add__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] : ( div_mod(A,plus_plus(A,B1,A1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_14_zmod__zminus2__not__zero,axiom,
    ! [L: int,K: int] :
      ( ( div_mod(int,K,uminus_uminus(int,L)) != zero_zero(int) )
     => ( div_mod(int,K,L) != zero_zero(int) ) ) ).

tff(fact_15_zmod__zminus1__not__zero,axiom,
    ! [L: int,K: int] :
      ( ( div_mod(int,uminus_uminus(int,K),L) != zero_zero(int) )
     => ( div_mod(int,K,L) != zero_zero(int) ) ) ).

tff(fact_16_mod__minus__cong,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [A3: A,B1: A,A1: A] :
          ( ( div_mod(A,A1,B1) = div_mod(A,A3,B1) )
         => ( div_mod(A,uminus_uminus(A,A1),B1) = div_mod(A,uminus_uminus(A,A3),B1) ) ) ) ).

tff(fact_17_mod__minus__eq,axiom,
    ! [A: $tType] :
      ( ring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,uminus_uminus(A,A1),B1) = div_mod(A,uminus_uminus(A,div_mod(A,A1,B1)),B1) ) ) ).

tff(fact_18_mod__add__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,B1: A,A3: A,C: A,A1: A] :
          ( ( div_mod(A,A1,C) = div_mod(A,A3,C) )
         => ( ( div_mod(A,B1,C) = div_mod(A,B3,C) )
           => ( div_mod(A,plus_plus(A,A1,B1),C) = div_mod(A,plus_plus(A,A3,B3),C) ) ) ) ) ).

tff(fact_19_zmod__simps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,plus_plus(A,div_mod(A,A1,C),B1),C) = div_mod(A,plus_plus(A,A1,B1),C) ) ) ).

tff(fact_20_zmod__simps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,div_mod(A,B1,C)),C) = div_mod(A,plus_plus(A,A1,B1),C) ) ) ).

tff(fact_21_mod__add__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),C) = div_mod(A,plus_plus(A,div_mod(A,A1,C),div_mod(A,B1,C)),C) ) ) ).

tff(fact_22_mod__add__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),C) = div_mod(A,plus_plus(A,div_mod(A,A1,C),B1),C) ) ) ).

tff(fact_23_mod__add__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,plus_plus(A,A1,B1),C) = div_mod(A,plus_plus(A,A1,div_mod(A,B1,C)),C) ) ) ).

tff(fact_24_zminus__zmod,axiom,
    ! [M: int,X: int] : ( div_mod(int,uminus_uminus(int,div_mod(int,X,M)),M) = div_mod(int,uminus_uminus(int,X),M) ) ).

tff(fact_25_zmod__zminus2,axiom,
    ! [B1: int,A1: int] : ( div_mod(int,A1,uminus_uminus(int,B1)) = uminus_uminus(int,div_mod(int,uminus_uminus(int,A1),B1)) ) ).

tff(fact_26_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_27_right__minus,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,uminus_uminus(A,A1)) = zero_zero(A) ) ) ).

tff(fact_28_left__minus,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( plus_plus(A,uminus_uminus(A,A1),A1) = zero_zero(A) ) ) ).

tff(fact_29_iprod__uminus,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A),Xs: list(A)] : ( iprod(A,uminus_uminus(list(A),Xs),Ys) = uminus_uminus(A,iprod(A,Xs,Ys)) ) ) ).

tff(fact_30_minus__add__distrib,axiom,
    ! [A: $tType] :
      ( ab_group_add(A)
     => ! [B1: A,A1: A] : ( uminus_uminus(A,plus_plus(A,A1,B1)) = plus_plus(A,uminus_uminus(A,A1),uminus_uminus(A,B1)) ) ) ).

tff(fact_31_minus__zero,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ( uminus_uminus(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_32_neg__0__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = uminus_uminus(A,Aa) )
        <=> ( zero_zero(A) = Aa ) ) ) ).

tff(fact_33_equal__neg__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( Aa = uminus_uminus(A,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_34_neg__equal__0__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Aa: A] :
          ( ( uminus_uminus(A,Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_35_neg__equal__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( uminus_uminus(A,Aa) = Aa )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_36_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,B: A] :
          ( ( plus_plus(A,B,Aa) = plus_plus(A,C1,Aa) )
        <=> ( B = C1 ) ) ) ).

tff(fact_37_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B: A,Aa: A] :
          ( ( plus_plus(A,Aa,B) = plus_plus(A,Aa,C1) )
        <=> ( B = C1 ) ) ) ).

tff(fact_38_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,Aa: A] :
          ( ( uminus_uminus(A,Aa) = uminus_uminus(A,B) )
        <=> ( Aa = B ) ) ) ).

tff(fact_39_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_40_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_41_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C,A1) )
         => ( B1 = C ) ) ) ).

tff(fact_42_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C) )
         => ( B1 = C ) ) ) ).

tff(fact_43_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C) )
         => ( B1 = C ) ) ) ).

tff(fact_44_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C) = plus_plus(A,A1,plus_plus(A,B1,C)) ) ) ).

tff(fact_45_minus__equation__iff,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,Aa: A] :
          ( ( uminus_uminus(A,Aa) = B )
        <=> ( uminus_uminus(A,B) = Aa ) ) ) ).

tff(fact_46_equation__minus__iff,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,Aa: A] :
          ( ( Aa = uminus_uminus(A,B) )
        <=> ( B = uminus_uminus(A,Aa) ) ) ) ).

tff(fact_47_minus__minus,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( uminus_uminus(A,uminus_uminus(A,A1)) = A1 ) ) ).

tff(fact_48_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_49_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_50_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_51_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_52_minus__add__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] : ( plus_plus(A,uminus_uminus(A,A1),plus_plus(A,A1,B1)) = B1 ) ) ).

tff(fact_53_add__minus__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,uminus_uminus(A,A1),B1)) = B1 ) ) ).

tff(fact_54_minus__add,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] : ( uminus_uminus(A,plus_plus(A,A1,B1)) = plus_plus(A,uminus_uminus(A,B1),uminus_uminus(A,A1)) ) ) ).

tff(fact_55_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( iprod(A,plus_plus(list(A),Xs,Ys),Zs) = plus_plus(A,iprod(A,Xs,Zs),iprod(A,Ys,Zs)) ) ) ).

tff(fact_56_minus__unique,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = zero_zero(A) )
         => ( uminus_uminus(A,A1) = B1 ) ) ) ).

tff(fact_57_add__eq__0__iff,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Y1: A,X1: A] :
          ( ( plus_plus(A,X1,Y1) = zero_zero(A) )
        <=> ( Y1 = uminus_uminus(A,X1) ) ) ) ).

tff(fact_58_ab__left__minus,axiom,
    ! [A: $tType] :
      ( ab_group_add(A)
     => ! [A1: A] : ( plus_plus(A,uminus_uminus(A,A1),A1) = zero_zero(A) ) ) ).

tff(fact_59_eq__neg__iff__add__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,Aa: A] :
          ( ( Aa = uminus_uminus(A,B) )
        <=> ( plus_plus(A,Aa,B) = zero_zero(A) ) ) ) ).

tff(fact_60_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( plus_plus(A,Aa,Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_61_atom_Osimps_I3_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int,List1: list(int),Int21: int,Int11: int] :
      ( ( nDvd(Int11,Int21,List1) = nDvd(Int12,Int22,List2) )
    <=> ( ( Int11 = Int12 )
        & ( Int21 = Int22 )
        & ( List1 = List2 ) ) ) ).

tff(fact_62_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [Y1: A,X1: A] :
          ( ( uminus_uminus(A,X1) = uminus_uminus(A,Y1) )
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_63_divisor_Osimps_I3_J,axiom,
    ! [Ks1: list(int),I: int,D: int] : ( divisor(nDvd(D,I,Ks1)) = D ) ).

tff(fact_64_Nat__Transfer_Otransfer__int__nat__function__closures_I1_J,axiom,
    ! [Y: int,X: int] :
      ( nat_is_nat(X)
     => ( nat_is_nat(Y)
       => nat_is_nat(plus_plus(int,X,Y)) ) ) ).

tff(fact_65_list__add__assoc,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( plus_plus(list(A),plus_plus(list(A),Xs,Ys),Zs) = plus_plus(list(A),Xs,plus_plus(list(A),Ys,Zs)) ) ) ).

tff(fact_66_fun__Compl__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( uminus(B2)
     => ! [A2: fun(A,B2),X3: A] : ( aa(A,B2,uminus_uminus(fun(A,B2),A2),X3) = uminus_uminus(B2,aa(A,B2,A2,X3)) ) ) ).

tff(fact_67_double__compl,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [X: A] : ( uminus_uminus(A,uminus_uminus(A,X)) = X ) ) ).

tff(fact_68_uminus__apply,axiom,
    ! [A: $tType,B2: $tType] :
      ( uminus(A)
     => ! [X1: B2,A2: fun(B2,A)] : ( aa(B2,A,uminus_uminus(fun(B2,A),A2),X1) = uminus_uminus(A,aa(B2,A,A2,X1)) ) ) ).

tff(fact_69_Nat__Transfer_Otransfer__int__nat__function__closures_I5_J,axiom,
    nat_is_nat(zero_zero(int)) ).

tff(fact_70_atom_Osize_I3_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( atom_size(nDvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_71_atom_Osize_I6_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( size_size(atom,nDvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_72_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_73_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),plus_plus(A,B1,D)) ) ) ).

tff(fact_74_ext,axiom,
    ! [B2: $tType,A: $tType,G: fun(A,B2),F: fun(A,B2)] :
      ( ! [X2: A] : ( aa(A,B2,F,X2) = aa(A,B2,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C) = plus_plus(A,plus_plus(A,A1,C),B1) ) ) ).

tff(fact_76_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C) = plus_plus(A,A1,plus_plus(A,B1,C)) ) ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),D) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,C,plus_plus(A,A1,D)) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( plus_plus(A,A1,C) = plus_plus(A,C,A1) ) ) ).

tff(fact_80_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Aa: A,B: A] :
          ( ( B = plus_plus(A,B,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_81_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_82_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_83__096ks_A_061_A1_A_D_Aks_H_096,axiom,
    ks = cons(int,one_one(int),ks1) ).

tff(fact_84_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M1) = plus_plus(nat,K1,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_85_nat__add__right__cancel,axiom,
    ! [N1: nat,K1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K1) = plus_plus(nat,N1,K1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_86__096_B_Bthesis_O_A_I_B_Bks_H_O_Aks_A_061_A1_A_D_Aks_H_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ks: list(int)] : ( ks != cons(int,one_one(int),Ks) ) ).

tff(fact_87_assms_I2_J,axiom,
    hd_coeff(a) = one_one(int) ).

tff(fact_88_mod__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,one_one(A)) = zero_zero(A) ) ) ).

tff(fact_89_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( plus_plus(list(A),cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,plus_plus(A,X,Y),plus_plus(list(A),Xs,Ys)) ) ) ).

tff(fact_90_list__uminus__Cons,axiom,
    ! [A: $tType] :
      ( ( uminus(A)
        & zero(A) )
     => ! [Xs: list(A),X: A] : ( uminus_uminus(list(A),cons(A,X,Xs)) = cons(A,uminus_uminus(A,X),uminus_uminus(list(A),Xs)) ) ) ).

tff(fact_91_odd__nonzero,axiom,
    ! [Z: int] : ( plus_plus(int,plus_plus(int,one_one(int),Z),Z) != zero_zero(int) ) ).

tff(fact_92_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_93_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_94_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_95_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K) = plus_plus(nat,M,plus_plus(nat,N,K)) ) ).

tff(fact_96_Nat__Transfer_Otransfer__int__nat__function__closures_I6_J,axiom,
    nat_is_nat(one_one(int)) ).

tff(fact_97_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( plus_plus(nat,zero_zero(nat),N) = N ) ).

%----Arities (34)
tff(arity_fun___Lattices_Oboolean__algebra,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( boolean_algebra(T_2)
     => boolean_algebra(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ouminus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( uminus(T_2)
     => uminus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Groups_Oab__group__add,axiom,
    ab_group_add(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Divides_Oring__div,axiom,
    ring_div(int) ).

tff(arity_Int_Oint___Groups_Ouminus,axiom,
    uminus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Divides_Osemiring__div,axiom,
    semiring_div(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oplus,axiom,
    cl_Groups_Oplus(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Lattices_Oboolean__algebra,axiom,
    boolean_algebra(bool) ).

tff(arity_HOL_Obool___Groups_Ouminus,axiom,
    uminus(bool) ).

tff(arity_List_Olist___Groups_Ouminus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & uminus(T_1) )
     => uminus(list(T_1)) ) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    div_mod(int,i,d) = div_mod(int,j,d) ).

%------------------------------------------------------------------------------
