%------------------------------------------------------------------------------
% File     : COM041_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 74
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_74 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  178 (  44 unt;  54 typ;   0 def)
%            Number of atoms       :  232 ( 126 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  118 (  10   ~;   1   |;  13   &)
%                                         (  12 <=>;  82  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   41 (  20   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :   22 (  21 usr;   0 prp; 1-2 aty)
%            Number of functors    :   30 (  30 usr;  10 con; 0-5 aty)
%            Number of variables   :  420 ( 385   !;   0   ?; 420   :)
%                                         (  35  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:52
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (49)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__ring,type,
    comm_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B1: $tType,C2: $tType] : ( fun(A,fun(B1,C2)) > fun(list(A),fun(list(B1),list(C2))) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * list(A) ) > list(B1) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_d____,type,
    d: int ).

tff(sy_v_e,type,
    e: list(int) ).

tff(sy_v_i,type,
    i: int ).

tff(sy_v_j,type,
    j: int ).

tff(sy_v_ks_H____,type,
    ks: list(int) ).

tff(sy_v_ks____,type,
    ks1: list(int) ).

tff(sy_v_l____,type,
    l: int ).

%----Relevant facts (99)
tff(fact_0_mod__add__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2),B2) = div_mod(A,A1,B2) ) ) ).

tff(fact_1_mod__add__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B2: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1),B2) = div_mod(A,A1,B2) ) ) ).

tff(fact_2_NDvd,axiom,
    a = nDvd(d,l,ks1) ).

tff(fact_3_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,A1: A] : ( div_mod(A,div_mod(A,A1,B2),B2) = div_mod(A,A1,B2) ) ) ).

tff(fact_4_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),B) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),C) )
        <=> ( B = C ) ) ) ).

tff(fact_5_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,Aa: A,B: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B),Aa) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),Aa) )
        <=> ( B = C ) ) ) ).

tff(fact_6_assms_I3_J,axiom,
    div_mod(int,i,divisor(a)) = div_mod(int,j,divisor(a)) ).

tff(fact_7_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( iprod(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),Ys),Zs) = aa(A,A,aa(A,fun(A,A),plus_plus(A),iprod(A,Xs,Zs)),iprod(A,Ys,Zs)) ) ) ).

tff(fact_8_mod__add__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),div_mod(A,B2,C1)),C1) ) ) ).

tff(fact_9_mod__add__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C1)),B2),C1) ) ) ).

tff(fact_10_mod__add__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C1)),div_mod(A,B2,C1)),C1) ) ) ).

tff(fact_11_zmod__simps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),div_mod(A,B2,C1)),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2),C1) ) ) ).

tff(fact_12_list__add__assoc,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),Ys)),Zs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Ys),Zs)) ) ) ).

tff(fact_13_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_14_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_15_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_16_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_17_mod__add__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,B2: A,A2: A,C1: A,A1: A] :
          ( ( div_mod(A,A1,C1) = div_mod(A,A2,C1) )
         => ( ( div_mod(A,B2,C1) = div_mod(A,B3,C1) )
           => ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B3),C1) ) ) ) ) ).

tff(fact_18_zmod__simps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,C1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C1)),B2),C1) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2),C1) ) ) ).

tff(fact_19_atom_Osimps_I3_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int2: int,Int1: int] :
      ( ( nDvd(Int1,Int2,List) = nDvd(Int11,Int21,List1) )
    <=> ( ( Int1 = Int11 )
        & ( Int2 = Int21 )
        & ( List = List1 ) ) ) ).

tff(fact_20__096ks_A_061_A1_A_D_Aks_H_096,axiom,
    ks1 = cons(int,one_one(int),ks) ).

tff(fact_21_divisor_Osimps_I3_J,axiom,
    ! [Ks: list(int),I1: int,D: int] : ( divisor(nDvd(D,I1,Ks)) = D ) ).

tff(fact_22_list__add__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ( plus_plus(list(A)) = zipwith0(A,A,A,plus_plus(A)) ) ) ).

tff(fact_23_assms_I2_J,axiom,
    hd_coeff(a) = one_one(int) ).

tff(fact_24_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),D)) ) ) ).

tff(fact_25_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),B2) ) ) ).

tff(fact_26_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_27_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),D) ) ) ).

tff(fact_28__096_B_Bthesis_O_A_I_B_Bks_H_O_Aks_A_061_A1_A_D_Aks_H_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ks1: list(int)] : ( ks1 != cons(int,one_one(int),Ks1) ) ).

tff(fact_29_zipwith0_Osimps_I2_J,axiom,
    ! [B1: $tType,A: $tType,C2: $tType] :
      ( ( zero(C2)
        & zero(B1) )
     => ! [Ys1: list(C2),Y1: C2,Xs1: list(B1),X1: B1,F: fun(B1,fun(C2,A))] : ( aa(list(C2),list(A),aa(list(B1),fun(list(C2),list(A)),zipwith0(B1,C2,A,F),cons(B1,X1,Xs1)),cons(C2,Y1,Ys1)) = cons(A,aa(C2,A,aa(B1,fun(C2,A),F,X1),Y1),aa(list(C2),list(A),aa(list(B1),fun(list(C2),list(A)),zipwith0(B1,C2,A,F),Xs1),Ys1)) ) ) ).

tff(fact_30_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),cons(A,X,Xs)),cons(A,Y,Ys)) = cons(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),X),Y),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs),Ys)) ) ) ).

tff(fact_31_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_32_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) ) ) ).

tff(fact_33_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),D)) ) ) ).

tff(fact_34_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A3: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A3,List1) )
    <=> ( ( Aa = A3 )
        & ( List = List1 ) ) ) ).

tff(fact_35_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_36_atom_Orecs_I3_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_37_iprod__Cons,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( iprod(A,cons(A,X,Xs),cons(A,Y,Ys)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,X),Y)),iprod(A,Xs,Ys)) ) ) ).

tff(fact_38_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I1: int] : ( divisor(c_PresArith_Oatom_OLe(I1,Ks)) = one_one(int) ) ).

tff(fact_39_divisor__asubst,axiom,
    ! [A1: atom,Ks: list(int),I1: int] : ( divisor(asubst(I1,Ks,A1)) = divisor(A1) ) ).

tff(fact_40_atom_Osimps_I1_J,axiom,
    ! [List1: list(int),Int4: int,List: list(int),Int3: int] :
      ( ( c_PresArith_Oatom_OLe(Int3,List) = c_PresArith_Oatom_OLe(Int4,List1) )
    <=> ( ( Int3 = Int4 )
        & ( List = List1 ) ) ) ).

tff(fact_41_mod__mult__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,C1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,times_times(A,C1),B2)),B2) = div_mod(A,A1,B2) ) ) ).

tff(fact_42_mod__mult__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,times_times(A,B2),C1)),B2) = div_mod(A,A1,B2) ) ) ).

tff(fact_43_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int3,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int3),List) ) ).

tff(fact_44_atom_Orecs_I1_J,axiom,
    ! [A: $tType,List: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int3,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int3),List) ) ).

tff(fact_45_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),aa(A,A,times_times(A,Ly),Ry)) ) ) ).

tff(fact_46_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Rx),aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Ry)) ) ) ).

tff(fact_47_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Ly),aa(A,A,times_times(A,Rx),Ry))) ) ) ).

tff(fact_48_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Rx) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),Ly) ) ) ).

tff(fact_49_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Rx) = aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Ly),Rx)) ) ) ).

tff(fact_50_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),Ry) ) ) ).

tff(fact_51_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Rx),aa(A,A,times_times(A,Lx),Ry)) ) ) ).

tff(fact_52_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B2: A,A1: A] : ( aa(A,A,times_times(A,A1),B2) = aa(A,A,times_times(A,B2),A1) ) ) ).

tff(fact_53_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,A1),B2)),C1) = aa(A,A,times_times(A,A1),aa(A,A,times_times(A,B2),C1)) ) ) ).

tff(fact_54_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Z1: A,Y: A,X: A] : ( aa(A,A,times_times(A,X),aa(A,A,aa(A,fun(A,A),plus_plus(A),Y),Z1)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,X),Y)),aa(A,A,times_times(A,X),Z1)) ) ) ).

tff(fact_55_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Da: A,C: A,B: A,Aa: A] :
          ( ( ( Aa != B )
            & ( C != Da ) )
        <=> ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,Aa),C)),aa(A,A,times_times(A,B),Da)) != aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,Aa),Da)),aa(A,A,times_times(A,B),C)) ) ) ) ).

tff(fact_56_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),C1)),aa(A,A,times_times(A,B2),C1)) ) ) ).

tff(fact_57_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B2: A,M: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),M)),aa(A,A,times_times(A,B2),M)) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),M) ) ) ).

tff(fact_58_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Z: A,X1: A,Y1: A,W: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,W),Y1)),aa(A,A,times_times(A,X1),Z)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,W),Z)),aa(A,A,times_times(A,X1),Y1)) )
        <=> ( ( W = X1 )
            | ( Y1 = Z ) ) ) ) ).

tff(fact_59_comm__semiring__1__class_Onormalizing__semiring__rules_I11_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_60_comm__semiring__1__class_Onormalizing__semiring__rules_I12_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_61_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_62_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),one_one(A)) = A1 ) ) ).

tff(fact_63_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_64_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,one_one(A)),A1) = A1 ) ) ).

tff(fact_65_mod__mult__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,B2: A,A2: A,C1: A,A1: A] :
          ( ( div_mod(A,A1,C1) = div_mod(A,A2,C1) )
         => ( ( div_mod(A,B2,C1) = div_mod(A,B3,C1) )
           => ( div_mod(A,aa(A,A,times_times(A,A1),B2),C1) = div_mod(A,aa(A,A,times_times(A,A2),B3),C1) ) ) ) ) ).

tff(fact_66_zmod__simps_I4_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,C1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C1)),B2),C1) = div_mod(A,aa(A,A,times_times(A,A1),B2),C1) ) ) ).

tff(fact_67_mod__mult__mult2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,C1: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),C1),aa(A,A,times_times(A,B2),C1)) = aa(A,A,times_times(A,div_mod(A,A1,B2)),C1) ) ) ).

tff(fact_68_mod__mult__mult1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,A1: A,C1: A] : ( div_mod(A,aa(A,A,times_times(A,C1),A1),aa(A,A,times_times(A,C1),B2)) = aa(A,A,times_times(A,C1),div_mod(A,A1,B2)) ) ) ).

tff(fact_69_mod__mult__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B2),C1) = div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C1)),div_mod(A,B2,C1)),C1) ) ) ).

tff(fact_70_mod__mult__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B2),C1) = div_mod(A,aa(A,A,times_times(A,div_mod(A,A1,C1)),B2),C1) ) ) ).

tff(fact_71_mod__mult__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C1: A,B2: A,A1: A] : ( div_mod(A,aa(A,A,times_times(A,A1),B2),C1) = div_mod(A,aa(A,A,times_times(A,A1),div_mod(A,B2,C1)),C1) ) ) ).

tff(fact_72_zmod__simps_I3_J,axiom,
    ! [C1: int,B2: int,A1: int] : ( div_mod(int,aa(int,int,times_times(int,A1),div_mod(int,B2,C1)),C1) = div_mod(int,aa(int,int,times_times(int,A1),B2),C1) ) ).

tff(fact_73_zmod__zmult1__eq,axiom,
    ! [C1: int,B2: int,A1: int] : ( div_mod(int,aa(int,int,times_times(int,A1),B2),C1) = div_mod(int,aa(int,int,times_times(int,A1),div_mod(int,B2,C1)),C1) ) ).

tff(fact_74_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X2: A] : ( aa(A,B1,F,X2) = aa(A,B1,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_atom_Osimps_I6_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int,List3: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List3) != nDvd(Int12,Int22,List2) ) ).

tff(fact_76_atom_Osimps_I7_J,axiom,
    ! [List3: list(int),Int: int,List2: list(int),Int22: int,Int12: int] : ( nDvd(Int12,Int22,List2) != c_PresArith_Oatom_OLe(Int,List3) ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I2_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [M: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),M)),M) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),one_one(A))),M) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I3_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A,M: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),M),aa(A,A,times_times(A,A1),M)) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),one_one(A))),M) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I4_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [M: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),M),M) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A))),M) ) ) ).

tff(fact_80_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_81_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_82_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B2: A,A1: A] : ( aa(A,A,times_times(A,A1),aa(A,A,times_times(A,A1),B2)) = aa(A,A,times_times(A,A1),B2) ) ) ).

tff(fact_83_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( comm_semiring(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),C1)),aa(A,A,times_times(A,B2),C1)) ) ) ).

tff(fact_84_combine__common__factor,axiom,
    ! [A: $tType] :
      ( semiring(A)
     => ! [C1: A,B2: A,E: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,A1),E)),aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,B2),E)),C1)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),E)),C1) ) ) ).

tff(fact_85_IZ__asubst,axiom,
    ! [Xs1: list(int),Aa: atom,Ksa: list(int),Ia: int] :
      ( i_Z(asubst(Ia,Ksa,Aa),Xs1)
    <=> i_Z(Aa,cons(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),iprod(int,Ksa,Xs1)),Xs1)) ) ).

tff(fact_86_asubst_Osimps_I3_J,axiom,
    ! [Ksa: list(int),K: int,Ia: int,Da: int,Ks_a: list(int),I: int] : ( asubst(I,Ks_a,nDvd(Da,Ia,cons(int,K,Ksa))) = nDvd(Da,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),aa(int,int,times_times(int,K),I)),aa(list(int),list(int),aa(list(int),fun(list(int),list(int)),plus_plus(list(int)),map(int,int,times_times(int,K),Ks_a)),Ksa)) ) ).

tff(fact_87_map_Osimps_I2_J,axiom,
    ! [A: $tType,B1: $tType,Xs1: list(B1),X1: B1,F: fun(B1,A)] : ( map(B1,A,F,cons(B1,X1,Xs1)) = cons(A,aa(B1,A,F,X1),map(B1,A,F,Xs1)) ) ).

tff(fact_88_iprod__assoc,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A),Xs1: list(A),X1: A] : ( iprod(A,map(A,A,times_times(A,X1),Xs1),Ys1) = aa(A,A,times_times(A,X1),iprod(A,Xs1,Ys1)) ) ) ).

tff(fact_89_scale1,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [Xs1: list(A)] : ( map(A,A,times_times(A,one_one(A)),Xs1) = Xs1 ) ) ).

tff(fact_90_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X: A] : ( aa(A,A,times_times(A,X),X) = X ) ) ).

tff(fact_91_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),A1) = A1 ) ) ).

tff(fact_92_asubst_Osimps_I2_J,axiom,
    ! [Ksa: list(int),K: int,Ia: int,Da: int,Ks_a: list(int),I: int] : ( asubst(I,Ks_a,dvd(Da,Ia,cons(int,K,Ksa))) = dvd(Da,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),aa(int,int,times_times(int,K),I)),aa(list(int),list(int),aa(list(int),fun(list(int),list(int)),plus_plus(list(int)),map(int,int,times_times(int,K),Ks_a)),Ksa)) ) ).

tff(fact_93_asubst_Osimps_I1_J,axiom,
    ! [Ksa: list(int),K: int,Ia: int,Ks_a: list(int),I: int] : ( asubst(I,Ks_a,c_PresArith_Oatom_OLe(Ia,cons(int,K,Ksa))) = c_PresArith_Oatom_OLe(minus_minus(int,Ia,aa(int,int,times_times(int,K),I)),aa(list(int),list(int),aa(list(int),fun(list(int),list(int)),plus_plus(list(int)),map(int,int,times_times(int,K),Ks_a)),Ksa)) ) ).

tff(fact_94_atom_Osimps_I2_J,axiom,
    ! [List1: list(int),Int21: int,Int11: int,List: list(int),Int2: int,Int1: int] :
      ( ( dvd(Int1,Int2,List) = dvd(Int11,Int21,List1) )
    <=> ( ( Int1 = Int11 )
        & ( Int2 = Int21 )
        & ( List = List1 ) ) ) ).

tff(fact_95_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( minus_minus(list(A),cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,minus_minus(A,X,Y),minus_minus(list(A),Xs,Ys)) ) ) ).

tff(fact_96_eq__add__iff1,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Da: A,B: A,C: A,Ea: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,Aa),Ea)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,B),Ea)),Da) )
        <=> ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,minus_minus(A,Aa,B)),Ea)),C) = Da ) ) ) ).

tff(fact_97_eq__add__iff2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Da: A,B: A,C: A,Ea: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,Aa),Ea)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,B),Ea)),Da) )
        <=> ( C = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,minus_minus(A,B,Aa)),Ea)),Da) ) ) ) ).

tff(fact_98_square__diff__square__factored,axiom,
    ! [A: $tType] :
      ( comm_ring(A)
     => ! [Y: A,X: A] : ( minus_minus(A,aa(A,A,times_times(A,X),X),aa(A,A,times_times(A,Y),Y)) = aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),X),Y)),minus_minus(A,X,Y)) ) ) ).

%----Arities (22)
tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring,axiom,
    comm_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__ring,axiom,
    comm_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e))),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),div_mod(int,l,d)),div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks,e)),d)),d) ).

%------------------------------------------------------------------------------
