%------------------------------------------------------------------------------
% File     : COM039_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 70
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_70 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  183 (  71 unt;  62 typ;   0 def)
%            Number of atoms       :  214 ( 120 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  125 (  32   ~;   6   |;  24   &)
%                                         (  21 <=>;  42  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   76 (  38   >;  38   *;   0   +;   0  <<)
%            Number of predicates  :   20 (  19 usr;   1 prp; 0-4 aty)
%            Number of functors    :   39 (  39 usr;   6 con; 0-6 aty)
%            Number of variables   :  407 ( 351   !;  11   ?; 407   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:48
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (56)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_HOL_Oequal,type,
    cl_HOL_Oequal: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osemigroup,type,
    semigroup: 
      !>[A: $tType] : ( fun(A,fun(A,A)) > $o ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * list(A) * list(B) ) > list(C) ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex,type,
    list_ex: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistrelp,type,
    listrelp: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : ( ( list(A) * A ) > $o ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_OremoveAll,type,
    removeAll: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Oreturn__list,type,
    return_list: list(int) > list(nat) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_PresArith_Ohd__coeff1,type,
    hd_coeff1: ( int * atom ) > atom ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_d____,type,
    d: int ).

tff(sy_v_ks____,type,
    ks: list(int) ).

tff(sy_v_l____,type,
    l: int ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (98)
tff(fact_0_assms_I2_J,axiom,
    hd_coeff(a) = one_one(int) ).

tff(fact_1_NDvd,axiom,
    a = nDvd(d,l,ks) ).

tff(fact_2_list_Oinject,axiom,
    ! [A: $tType,List4: list(A),A5: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A5,List4) )
    <=> ( ( Aa = A5 )
        & ( List = List4 ) ) ) ).

tff(fact_3_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_4_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_5_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_6_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_7_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_8_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs1: list(A),X: A] : ( splice(A,cons(A,X,Xs1),cons(A,Y,Ys1)) = cons(A,X,cons(A,Y,splice(A,Xs1,Ys1))) ) ).

tff(fact_9_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,Aa,List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,Aa),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_10_null__rec_I1_J,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ~ null(A,cons(A,X,Xs1)) ).

tff(fact_11_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,Xs: list(B),X1: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X1,Xs),cons(C,Y1,Ys)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X1),Y1),zipwith0(B,C,A,F,Xs,Ys)) ) ) ).

tff(fact_12_elem,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : listMem(A,X,cons(A,X,Xs1)) ).

tff(fact_13_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z) )
        <=> ( W = Z ) ) ) ).

tff(fact_14_insert,axiom,
    ! [A: $tType,Y: A,Xs1: list(A),X: A] :
      ( listMem(A,X,Xs1)
     => listMem(A,X,cons(A,Y,Xs1)) ) ).

tff(fact_15_atom_Osimps_I3_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List: list(int),Int2: int,Int1: int] :
      ( ( nDvd(Int1,Int2,List) = nDvd(Int14,Int24,List4) )
    <=> ( ( Int1 = Int14 )
        & ( Int2 = Int24 )
        & ( List = List4 ) ) ) ).

tff(fact_16_ListMem_Osimps,axiom,
    ! [A: $tType,A2: list(A),A11: A] :
      ( listMem(A,A11,A2)
    <=> ( ? [X3: A,Xs3: list(A)] :
            ( ( A11 = X3 )
            & ( A2 = cons(A,X3,Xs3) ) )
        | ? [X3: A,Xs3: list(A),Y2: A] :
            ( ( A11 = X3 )
            & ( A2 = cons(A,Y2,Xs3) )
            & listMem(A,X3,Xs3) ) ) ) ).

tff(fact_17_member__rec_I1_J,axiom,
    ! [A: $tType,Y1: A,Xs: list(A),X1: A] :
      ( member1(A,cons(A,X1,Xs),Y1)
    <=> ( ( X1 = Y1 )
        | member1(A,Xs,Y1) ) ) ).

tff(fact_18_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_19_list__ex__simps_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,P: fun(A,bool)] :
      ( list_ex(A,P,cons(A,X1,Xs))
    <=> ( pp(aa(A,bool,P,X1))
        | list_ex(A,P,Xs) ) ) ).

tff(fact_20_listrelp_OCons,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),Y1: A,X1: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),R,X1),Y1))
     => ( listrelp(A,R,Xs,Ys)
       => listrelp(A,R,cons(A,X1,Xs),cons(A,Y1,Ys)) ) ) ).

tff(fact_21_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,P: fun(A,bool)] :
      ( list_all(A,P,cons(A,X1,Xs))
    <=> ( pp(aa(A,bool,P,X1))
        & list_all(A,P,Xs) ) ) ).

tff(fact_22_removeAll_Osimps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),Y: A,X: A] :
      ( ( ( X = Y )
       => ( removeAll(A,X,cons(A,Y,Xs1)) = removeAll(A,X,Xs1) ) )
      & ( ( X != Y )
       => ( removeAll(A,X,cons(A,Y,Xs1)) = cons(A,Y,removeAll(A,X,Xs1)) ) ) ) ).

tff(fact_23_semigroup_Oassoc,axiom,
    ! [A: $tType,C1: A,B1: A,Aa: A,F: fun(A,fun(A,A))] :
      ( semigroup(A,F)
     => ( aa(A,A,aa(A,fun(A,A),F,aa(A,A,aa(A,fun(A,A),F,Aa),B1)),C1) = aa(A,A,aa(A,fun(A,A),F,Aa),aa(A,A,aa(A,fun(A,A),F,B1),C1)) ) ) ).

tff(fact_24_list__all__simps_I2_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : list_all(A,P,nil(A)) ).

tff(fact_25_list__ex__simps_I2_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex(A,P,nil(A)) ).

tff(fact_26_removeAll_Osimps_I1_J,axiom,
    ! [A: $tType,X: A] : ( removeAll(A,X,nil(A)) = nil(A) ) ).

tff(fact_27_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),nil(C)) = nil(A) ) ) ).

tff(fact_28_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] : ~ member1(A,nil(A),Y) ).

tff(fact_29_listrelp_ONil,axiom,
    ! [A: $tType,R: fun(A,fun(A,bool))] : listrelp(A,R,nil(A),nil(A)) ).

tff(fact_30_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( nil(A) != cons(A,A4,List2) ) ).

tff(fact_31_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( cons(A,A4,List2) != nil(A) ) ).

tff(fact_32_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_33_eq__Nil__null,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs = nil(A) )
    <=> null(A,Xs) ) ).

tff(fact_34_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_35_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_36_List_Onull__def,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( null(A,Xs)
    <=> ( Xs = nil(A) ) ) ).

tff(fact_37_null__rec_I2_J,axiom,
    ! [B: $tType] : null(B,nil(B)) ).

tff(fact_38_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_39_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y2: A,Ys2: list(A)] : ( Xs = cons(A,Y2,Ys2) ) ) ).

tff(fact_40_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List1: list(A)] : ( Y != cons(A,A3,List1) ) ) ).

tff(fact_41_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_42_equal__Nil__null,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),Xs),nil(A)))
    <=> null(A,Xs) ) ).

tff(fact_43_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xs: list(B),X1: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X1,Xs),nil(C)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X1),zero_zero(C)),zipwith0(B,C,A,F,Xs,nil(C))) ) ) ).

tff(fact_44_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),Y1: C,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),cons(C,Y1,Ys)) = cons(A,aa(C,A,aa(B,fun(C,A),F,zero_zero(B)),Y1),zipwith0(B,C,A,F,nil(B),Ys)) ) ) ).

tff(fact_45_listrelp_Osimps,axiom,
    ! [A: $tType,A2: list(A),A11: list(A),R: fun(A,fun(A,bool))] :
      ( listrelp(A,R,A11,A2)
    <=> ( ( ( A11 = nil(A) )
          & ( A2 = nil(A) ) )
        | ? [X3: A,Y2: A,Xs3: list(A),Ys2: list(A)] :
            ( ( A11 = cons(A,X3,Xs3) )
            & ( A2 = cons(A,Y2,Ys2) )
            & pp(aa(A,bool,aa(A,fun(A,bool),R,X3),Y2))
            & listrelp(A,R,Xs3,Ys2) ) ) ) ).

tff(fact_46_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( ring_1_of_int(A,Z) = zero_zero(A) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_47_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_48_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_49_equal__list__def,axiom,
    ! [A: $tType,Y1: list(A),X1: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),X1),Y1))
    <=> ( X1 = Y1 ) ) ).

tff(fact_50_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_51_atom_Osize_I3_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int] : ( atom_size(nDvd(Int13,Int23,List3)) = zero_zero(nat) ) ).

tff(fact_52_atom_Osize_I6_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int] : ( size_size(atom,nDvd(Int13,Int23,List3)) = zero_zero(nat) ) ).

tff(fact_53_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_54_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_55_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = cons(A,X1,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_56_atom_Osize_I1_J,axiom,
    ! [List3: list(int),Int4: int] : ( atom_size(c_PresArith_Oatom_OLe(Int4,List3)) = zero_zero(nat) ) ).

tff(fact_57_atom_Osize_I4_J,axiom,
    ! [List3: list(int),Int4: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int4,List3)) = zero_zero(nat) ) ).

tff(fact_58_atom_Osimps_I1_J,axiom,
    ! [List4: list(int),Int5: int,List: list(int),Int: int] :
      ( ( c_PresArith_Oatom_OLe(Int,List) = c_PresArith_Oatom_OLe(Int5,List4) )
    <=> ( ( Int = Int5 )
        & ( List = List4 ) ) ) ).

tff(fact_59_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_60_atom_Osimps_I6_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int,List3: list(int),Int4: int] : ( c_PresArith_Oatom_OLe(Int4,List3) != nDvd(Int12,Int22,List2) ) ).

tff(fact_61_atom_Osimps_I7_J,axiom,
    ! [List3: list(int),Int4: int,List2: list(int),Int22: int,Int12: int] : ( nDvd(Int12,Int22,List2) != c_PresArith_Oatom_OLe(Int4,List3) ) ).

tff(fact_62_atom_Osize_I5_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int] : ( size_size(atom,dvd(Int13,Int23,List3)) = zero_zero(nat) ) ).

tff(fact_63_atom_Osize_I2_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int] : ( atom_size(dvd(Int13,Int23,List3)) = zero_zero(nat) ) ).

tff(fact_64_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_65_atom_Osimps_I2_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List: list(int),Int2: int,Int1: int] :
      ( ( dvd(Int1,Int2,List) = dvd(Int14,Int24,List4) )
    <=> ( ( Int1 = Int14 )
        & ( Int2 = Int24 )
        & ( List = List4 ) ) ) ).

tff(fact_66_atom_Osimps_I5_J,axiom,
    ! [List3: list(int),Int4: int,List2: list(int),Int22: int,Int12: int] : ( dvd(Int12,Int22,List2) != c_PresArith_Oatom_OLe(Int4,List3) ) ).

tff(fact_67_atom_Osimps_I4_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int,List3: list(int),Int4: int] : ( c_PresArith_Oatom_OLe(Int4,List3) != dvd(Int12,Int22,List2) ) ).

tff(fact_68_atom_Osimps_I8_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int,List3: list(int),Int23: int,Int13: int] : ( dvd(Int13,Int23,List3) != nDvd(Int12,Int22,List2) ) ).

tff(fact_69_atom_Osimps_I9_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List2: list(int),Int22: int,Int12: int] : ( nDvd(Int12,Int22,List2) != dvd(Int13,Int23,List3) ) ).

tff(fact_70_atom_Oexhaust,axiom,
    ! [Y: atom] :
      ( ! [Int3: int,List1: list(int)] : ( Y != c_PresArith_Oatom_OLe(Int3,List1) )
     => ( ! [Int11: int,Int21: int,List1: list(int)] : ( Y != dvd(Int11,Int21,List1) )
       => ~ ! [Int11: int,Int21: int,List1: list(int)] : ( Y != nDvd(Int11,Int21,List1) ) ) ) ).

tff(fact_71_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_72_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs1: list(A)] : ( iprod(A,Xs1,nil(A)) = zero_zero(A) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_75_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A)] : ( iprod(A,nil(A),Ys1) = zero_zero(A) ) ) ).

tff(fact_76_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_77_atom_Orecs_I1_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_78_atom_Orecs_I2_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,dvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int1),Int2),List) ) ).

tff(fact_79_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,dvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int1),Int2),List) ) ).

tff(fact_80_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_81_atom_Orecs_I3_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_82_list__nonempty__induct,axiom,
    ! [A: $tType,P: fun(list(A),bool),Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,P,cons(A,X2,nil(A))))
       => ( ! [X2: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P,Xs2))
               => pp(aa(list(A),bool,P,cons(A,X2,Xs2))) ) )
         => pp(aa(list(A),bool,P,Xs)) ) ) ) ).

tff(fact_83_hd__coeff1_Osimps_I4_J,axiom,
    ! [V: int,Uu: int] : ( hd_coeff1(Uu,c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_84_hd__coeff1_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( hd_coeff1(Uu,nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

tff(fact_85_hd__coeff1_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( hd_coeff1(Uu,dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_86_zlcms_Osimps_I1_J,axiom,
    zlcms(nil(int)) = one_one(int) ).

tff(fact_87_asubst_Osimps_I4_J,axiom,
    ! [V: int,Ks1: list(int),I: int] : ( asubst(I,Ks1,c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_88_asubst_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Ks1: list(int),I: int] : ( asubst(I,Ks1,dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_89_asubst_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Ks1: list(int),I: int] : ( asubst(I,Ks1,nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

tff(fact_90_transfer__nat__int__list__functions_I2_J,axiom,
    nil(nat) = return_list(nil(int)) ).

tff(fact_91_eq__equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( fequal(A) = equal_equal(A) ) ) ).

tff(fact_92_equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( equal_equal(A) = fequal(A) ) ) ).

tff(fact_93_equal__refl,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [X: A] : pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X),X)) ) ).

tff(fact_94_equal__eq,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [Y1: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X1),Y1))
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_95_zipwith0__Nil,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys: list(C),F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),Ys) = map(C,A,aa(B,fun(C,A),F,zero_zero(B)),Ys) ) ) ).

tff(fact_96_last_Osimps,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] :
      ( ( ( Xs1 = nil(A) )
       => ( last(A,cons(A,X,Xs1)) = X ) )
      & ( ( Xs1 != nil(A) )
       => ( last(A,cons(A,X,Xs1)) = last(A,Xs1) ) ) ) ).

tff(fact_97_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X1,Xs)) = cons(A,aa(B,A,F,X1),map(B,A,F,Xs)) ) ).

%----Arities (17)
tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_fun___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( cl_HOL_Oequal(T_2)
        & enum(T_1) )
     => cl_HOL_Oequal(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Int_Oint___HOL_Oequal,axiom,
    cl_HOL_Oequal(int) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Nat_Onat___HOL_Oequal,axiom,
    cl_HOL_Oequal(nat) ).

tff(arity_HOL_Obool___HOL_Oequal,axiom,
    cl_HOL_Oequal(bool) ).

tff(arity_List_Olist___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(list(T_1)) ).

tff(arity_PresArith_Oatom___HOL_Oequal,axiom,
    cl_HOL_Oequal(atom) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [Ks: list(int)] :
      ( ( ks = cons(int,one_one(int),Ks) )
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
