%------------------------------------------------------------------------------
% File     : COM038_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 66
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_66 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v9.0.0, 0.33 v8.1.0, 0.67 v7.4.0, 0.50 v7.3.0, 0.75 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  181 (  50 unt;  56 typ;   0 def)
%            Number of atoms       :  240 ( 117 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  123 (   8   ~;   5   |;   8   &)
%                                         (  18 <=>;  84  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   45 (  21   >;  24   *;   0   +;   0  <<)
%            Number of predicates  :   22 (  21 usr;   0 prp; 1-3 aty)
%            Number of functors    :   32 (  32 usr;  10 con; 0-5 aty)
%            Number of variables   :  374 ( 333   !;   1   ?; 374   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:46
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (51)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C2: $tType] : ( fun(A,fun(B,C2)) > fun(list(A),fun(list(B),list(C2))) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_Rings_Odvd__class_Odvd,type,
    dvd_dvd: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_d____,type,
    d: int ).

tff(sy_v_e,type,
    e: list(int) ).

tff(sy_v_i,type,
    i: int ).

tff(sy_v_j,type,
    j: int ).

tff(sy_v_ks_H____,type,
    ks1: list(int) ).

tff(sy_v_ks____,type,
    ks: list(int) ).

tff(sy_v_l____,type,
    l: int ).

%----Relevant facts (98)
tff(fact_0_Dvd,axiom,
    a = dvd(d,l,ks) ).

tff(fact_1__096_Il_A_L_A_Ii_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_J_Amod_Ad_A_061_Il_A_L_A_Ij_A_L_A_092_060langle_062ks_H_Me_092_060rangle_062_J_J_Amod_Ad_096,axiom,
    div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),i),iprod(int,ks1,e))),d) = div_mod(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),l),aa(int,int,aa(int,fun(int,int),plus_plus(int),j),iprod(int,ks1,e))),d) ).

tff(fact_2_assms_I3_J,axiom,
    div_mod(int,i,divisor(a)) = div_mod(int,j,divisor(a)) ).

tff(fact_3__096ks_A_061_A1_A_D_Aks_H_096,axiom,
    ks = cons(int,one_one(int),ks1) ).

tff(fact_4_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A3: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A3,List3) )
    <=> ( ( Aa = A3 )
        & ( List = List3 ) ) ) ).

tff(fact_5_assms_I2_J,axiom,
    hd_coeff(a) = one_one(int) ).

tff(fact_6_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs1: list(A)] : ( Xs1 != cons(A,X2,Xs1) ) ).

tff(fact_7_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] : ( cons(A,X2,Xs1) != Xs1 ) ).

tff(fact_8__096_B_Bthesis_O_A_I_B_Bks_H_O_Aks_A_061_A1_A_D_Aks_H_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ks1: list(int)] : ( ks != cons(int,one_one(int),Ks1) ) ).

tff(fact_9_assms_I1_J,axiom,
    pp(atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),a)) ).

tff(fact_10_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_11_IZ__asubst,axiom,
    ! [Xs: list(int),Aa: atom,Ksa: list(int),Ia: int] :
      ( i_Z(asubst(Ia,Ksa,Aa),Xs)
    <=> i_Z(Aa,cons(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),iprod(int,Ksa,Xs)),Xs)) ) ).

tff(fact_12_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y1: A,Xs1: list(A),X2: A] : ( splice(A,cons(A,X2,Xs1),cons(A,Y1,Ys1)) = cons(A,X2,cons(A,Y1,splice(A,Xs1,Ys1))) ) ).

tff(fact_13_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,Aa,List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,Aa),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_14_atom_Osimps_I2_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List: list(int),Int21: int,Int11: int] :
      ( ( dvd(Int11,Int21,List) = dvd(Int12,Int22,List3) )
    <=> ( ( Int11 = Int12 )
        & ( Int21 = Int22 )
        & ( List = List3 ) ) ) ).

tff(fact_15_divisor__asubst,axiom,
    ! [A1: atom,Ks: list(int),I: int] : ( divisor(asubst(I,Ks,A1)) = divisor(A1) ) ).

tff(fact_16_divisor_Osimps_I2_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( divisor(dvd(D,I,Ks)) = D ) ).

tff(fact_17_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,dvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int11),Int21),List) ) ).

tff(fact_18_mod__add__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_19_mod__add__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_20_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys1: list(A),Y1: A,Xs1: list(A),X2: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),cons(A,X2,Xs1)),cons(A,Y1,Ys1)) = cons(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),X2),Y1),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),Ys1)) ) ) ).

tff(fact_21_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,div_mod(A,A1,B1),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_22_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),C1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_23_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),Aa) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),Aa) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_24_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys1: list(A),Xs1: list(A)] : ( iprod(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),Ys1),Zs) = aa(A,A,aa(A,fun(A,A),plus_plus(A),iprod(A,Xs1,Zs)),iprod(A,Ys1,Zs)) ) ) ).

tff(fact_25_mod__add__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),div_mod(A,B1,C)),C) ) ) ).

tff(fact_26_list__add__assoc,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),Ys1: list(A),Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),Ys1)),Zs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Xs1),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),plus_plus(list(A)),Ys1),Zs)) ) ) ).

tff(fact_27_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),A1) )
         => ( B1 = C ) ) ) ).

tff(fact_28_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C) )
         => ( B1 = C ) ) ) ).

tff(fact_29_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C) )
         => ( B1 = C ) ) ) ).

tff(fact_30_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C)) ) ) ).

tff(fact_31_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_32_mod__add__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,B1: A,A2: A,C: A,A1: A] :
          ( ( div_mod(A,A1,C) = div_mod(A,A2,C) )
         => ( ( div_mod(A,B1,C) = div_mod(A,B3,C) )
           => ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B3),C) ) ) ) ) ).

tff(fact_33_zmod__simps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C)),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) ) ) ).

tff(fact_34_zmod__simps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),div_mod(A,B1,C)),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) ) ) ).

tff(fact_35_mod__add__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C)),div_mod(A,B1,C)),C) ) ) ).

tff(fact_36_mod__add__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1),C) = div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),div_mod(A,A1,C)),B1),C) ) ) ).

tff(fact_37_I_092_060_094isub_062Z_Osimps_I2_J,axiom,
    ! [Xs: list(int),Ksa: list(int),Ia: int,Da: int] :
      ( i_Z(dvd(Da,Ia,Ksa),Xs)
    <=> dvd_dvd(int,Da,aa(int,int,aa(int,fun(int,int),plus_plus(int),Ia),iprod(int,Ksa,Xs))) ) ).

tff(fact_38_atom_Orecs_I2_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,dvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int11),Int21),List) ) ).

tff(fact_39_list__add__def,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ( plus_plus(list(A)) = zipwith0(A,A,A,plus_plus(A)) ) ) ).

tff(fact_40_iprod__Cons,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys1: list(A),Y1: A,Xs1: list(A),X2: A] : ( iprod(A,cons(A,X2,Xs1),cons(A,Y1,Ys1)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),times_times(A,X2,Y1)),iprod(A,Xs1,Ys1)) ) ) ).

tff(fact_41_hd__coeff_Osimps_I2_J,axiom,
    ! [Ksa: list(int),Ia: int,Da: int] : ( hd_coeff(dvd(Da,Ia,Ksa)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ksa) ) ).

tff(fact_42_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( divisor(c_PresArith_Oatom_OLe(I,Ks)) = one_one(int) ) ).

tff(fact_43_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int4: int,List: list(int),Int: int] :
      ( ( c_PresArith_Oatom_OLe(Int,List) = c_PresArith_Oatom_OLe(Int4,List3) )
    <=> ( ( Int = Int4 )
        & ( List = List3 ) ) ) ).

tff(fact_44_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_45_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_46_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_47_zmod__zero,axiom,
    ! [B1: int] : ( div_mod(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_48_zmod__self,axiom,
    ! [A1: int] : ( div_mod(int,A1,A1) = zero_zero(int) ) ).

tff(fact_49_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C2: $tType] :
      ( ( zero(C2)
        & zero(B) )
     => ! [Ys: list(C2),Y: C2,Xs: list(B),X1: B,F: fun(B,fun(C2,A))] : ( aa(list(C2),list(A),aa(list(B),fun(list(C2),list(A)),zipwith0(B,C2,A,F),cons(B,X1,Xs)),cons(C2,Y,Ys)) = cons(A,aa(C2,A,aa(B,fun(C2,A),F,X1),Y),aa(list(C2),list(A),aa(list(B),fun(list(C2),list(A)),zipwith0(B,C2,A,F),Xs),Ys)) ) ) ).

tff(fact_50_mod__mult__self2__is__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] : ( div_mod(A,times_times(A,A1,B1),B1) = zero_zero(A) ) ) ).

tff(fact_51_mod__mult__self1__is__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A] : ( div_mod(A,times_times(A,B1,A1),B1) = zero_zero(A) ) ) ).

tff(fact_52_mod__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,one_one(A)) = zero_zero(A) ) ) ).

tff(fact_53_mod__mult__self2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),times_times(A,B1,C)),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_54_mod__mult__self1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),times_times(A,C,B1)),B1) = div_mod(A,A1,B1) ) ) ).

tff(fact_55_hd__coeff_Osimps_I1_J,axiom,
    ! [Ksa: list(int),Ia: int] : ( hd_coeff(c_PresArith_Oatom_OLe(Ia,Ksa)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ksa) ) ).

tff(fact_56_dvd__eq__mod__eq__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B2: A,Aa: A] :
          ( dvd_dvd(A,Aa,B2)
        <=> ( div_mod(A,B2,Aa) = zero_zero(A) ) ) ) ).

tff(fact_57_zmod__eq__0__iff,axiom,
    ! [Da: int,M1: int] :
      ( ( div_mod(int,M1,Da) = zero_zero(int) )
    <=> ? [Q1: int] : ( M1 = times_times(int,Da,Q1) ) ) ).

tff(fact_58_dvd__imp__mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A] :
          ( dvd_dvd(A,A1,B1)
         => ( div_mod(A,B1,A1) = zero_zero(A) ) ) ) ).

tff(fact_59_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C: A,B1: A,A1: A] : ( times_times(A,times_times(A,A1,B1),C) = times_times(A,A1,times_times(A,B1,C)) ) ) ).

tff(fact_60_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_61_atom_Orecs_I1_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_62_dvd__mod__imp__dvd,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [N: A,M: A,K: A] :
          ( dvd_dvd(A,K,div_mod(A,M,N))
         => ( dvd_dvd(A,K,N)
           => dvd_dvd(A,K,M) ) ) ) ).

tff(fact_63_dvd__mod,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [N: A,M: A,K: A] :
          ( dvd_dvd(A,K,M)
         => ( dvd_dvd(A,K,N)
           => dvd_dvd(A,K,div_mod(A,M,N)) ) ) ) ).

tff(fact_64_mod__mod__cancel,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A,B1: A,C: A] :
          ( dvd_dvd(A,C,B1)
         => ( div_mod(A,div_mod(A,A1,B1),C) = div_mod(A,A1,C) ) ) ) ).

tff(fact_65_dvd__mod__iff,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [M1: A,N1: A,K1: A] :
          ( dvd_dvd(A,K1,N1)
         => ( dvd_dvd(A,K1,div_mod(A,M1,N1))
          <=> dvd_dvd(A,K1,M1) ) ) ) ).

tff(fact_66_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( times_times(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_67_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( times_times(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_68_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( times_times(A,one_one(A),A1) = A1 ) ) ).

tff(fact_69_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( times_times(A,one_one(A),A1) = A1 ) ) ).

tff(fact_70_zdvd__zmod__imp__zdvd,axiom,
    ! [N: int,M: int,K: int] :
      ( dvd_dvd(int,K,div_mod(int,M,N))
     => ( dvd_dvd(int,K,N)
       => dvd_dvd(int,K,M) ) ) ).

tff(fact_71_zdvd__zmod,axiom,
    ! [N: int,M: int,F4: int] :
      ( dvd_dvd(int,F4,M)
     => ( dvd_dvd(int,F4,N)
       => dvd_dvd(int,F4,div_mod(int,M,N)) ) ) ).

tff(fact_72_mod__mult__cong,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B3: A,B1: A,A2: A,C: A,A1: A] :
          ( ( div_mod(A,A1,C) = div_mod(A,A2,C) )
         => ( ( div_mod(A,B1,C) = div_mod(A,B3,C) )
           => ( div_mod(A,times_times(A,A1,B1),C) = div_mod(A,times_times(A,A2,B3),C) ) ) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_74_zmod__simps_I4_J,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,times_times(A,div_mod(A,A1,C),B1),C) = div_mod(A,times_times(A,A1,B1),C) ) ) ).

tff(fact_75_mod__mult__mult2,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,C: A,A1: A] : ( div_mod(A,times_times(A,A1,C),times_times(A,B1,C)) = times_times(A,div_mod(A,A1,B1),C) ) ) ).

tff(fact_76_mod__mult__mult1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A1: A,C: A] : ( div_mod(A,times_times(A,C,A1),times_times(A,C,B1)) = times_times(A,C,div_mod(A,A1,B1)) ) ) ).

tff(fact_77_mod__mult__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,times_times(A,A1,B1),C) = div_mod(A,times_times(A,div_mod(A,A1,C),div_mod(A,B1,C)),C) ) ) ).

tff(fact_78_mod__mult__left__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,times_times(A,A1,B1),C) = div_mod(A,times_times(A,div_mod(A,A1,C),B1),C) ) ) ).

tff(fact_79_mod__mult__right__eq,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [C: A,B1: A,A1: A] : ( div_mod(A,times_times(A,A1,B1),C) = div_mod(A,times_times(A,A1,div_mod(A,B1,C)),C) ) ) ).

tff(fact_80_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_81_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_82_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_83_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_84_zmod__zmult1__eq,axiom,
    ! [C: int,B1: int,A1: int] : ( div_mod(int,times_times(int,A1,B1),C) = div_mod(int,times_times(int,A1,div_mod(int,B1,C)),C) ) ).

tff(fact_85_zmod__simps_I3_J,axiom,
    ! [C: int,B1: int,A1: int] : ( div_mod(int,times_times(int,A1,div_mod(int,B1,C)),C) = div_mod(int,times_times(int,A1,B1),C) ) ).

tff(fact_86_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A1: A] : ( div_mod(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_87_atom_Osimps_I4_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int,List2: list(int),Int3: int] : ( c_PresArith_Oatom_OLe(Int3,List2) != dvd(Int1,Int2,List1) ) ).

tff(fact_88_atom_Osimps_I5_J,axiom,
    ! [List2: list(int),Int3: int,List1: list(int),Int2: int,Int1: int] : ( dvd(Int1,Int2,List1) != c_PresArith_Oatom_OLe(Int3,List2) ) ).

tff(fact_89_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_90_dvd__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [B2: A,C1: A,Aa: A] :
          ( dvd_dvd(A,times_times(A,Aa,C1),times_times(A,B2,C1))
        <=> ( ( C1 = zero_zero(A) )
            | dvd_dvd(A,Aa,B2) ) ) ) ).

tff(fact_91_dvd__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [B2: A,Aa: A,C1: A] :
          ( dvd_dvd(A,times_times(A,C1,Aa),times_times(A,C1,B2))
        <=> ( ( C1 = zero_zero(A) )
            | dvd_dvd(A,Aa,B2) ) ) ) ).

tff(fact_92_dvd__0__right,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : dvd_dvd(A,A1,zero_zero(A)) ) ).

tff(fact_93_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_94_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B2: A,Aa: A] :
          ( ( times_times(A,Aa,B2) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            | ( B2 = zero_zero(A) ) ) ) ) ).

tff(fact_95_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_96_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_97_dvd__trans,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B1: A,A1: A] :
          ( dvd_dvd(A,A1,B1)
         => ( dvd_dvd(A,B1,C)
           => dvd_dvd(A,A1,C) ) ) ) ).

%----Arities (19)
tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Rings_Oidom,axiom,
    idom(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (7)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( i_Z(a,cons(int,i,e))
  <=> i_Z(a,cons(int,j,e)) ) ).

%------------------------------------------------------------------------------
