%------------------------------------------------------------------------------
% File     : COM030_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 48
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_48 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  184 (  75 unt;  60 typ;   0 def)
%            Number of atoms       :  211 ( 117 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  126 (  39   ~;  14   |;  20   &)
%                                         (  20 <=>;  33  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   79 (  39   >;  40   *;   0   +;   0  <<)
%            Number of predicates  :   17 (  16 usr;   0 prp; 1-4 aty)
%            Number of functors    :   40 (  40 usr;   8 con; 0-6 aty)
%            Number of variables   :  420 ( 363   !;  11   ?; 420   :)
%                                         (  46  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:29
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (54)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Divides_Odiv__class_Omod,type,
    div_mod: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * list(A) * list(B) ) > list(C) ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex,type,
    list_ex: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistrelp,type,
    listrelp: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : ( ( list(A) * A ) > $o ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odecr_092_060_094isub_062Z,type,
    decr_Z: atom > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_e,type,
    e: list(int) ).

tff(sy_v_i,type,
    i: int ).

tff(sy_v_j,type,
    j: int ).

%----Relevant facts (98)
tff(fact_0_assms_I3_J,axiom,
    div_mod(int,i,divisor(a)) = div_mod(int,j,divisor(a)) ).

tff(fact_1_list_Oinject,axiom,
    ! [A: $tType,List4: list(A),A5: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A5,List4) )
    <=> ( ( Aa = A5 )
        & ( List = List4 ) ) ) ).

tff(fact_2_assms_I2_J,axiom,
    hd_coeff(a) = one_one(int) ).

tff(fact_3_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_4_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_5_assms_I1_J,axiom,
    pp(atom_case(bool,aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fFalse)),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),aa(fun(int,fun(list(int),bool)),fun(int,fun(int,fun(list(int),bool))),combk(fun(int,fun(list(int),bool)),int),aa(fun(list(int),bool),fun(int,fun(list(int),bool)),combk(fun(list(int),bool),int),aa(bool,fun(list(int),bool),combk(bool,list(int)),fTrue))),a)) ).

tff(fact_6_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_7_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_8_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,Aa,List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,Aa),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_9_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ~ null(A,cons(A,X,Xs)) ).

tff(fact_10_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys2: list(C),Y2: C,Xs1: list(B),X1: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X1,Xs1),cons(C,Y2,Ys2)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X1),Y2),zipwith0(B,C,A,F,Xs1,Ys2)) ) ) ).

tff(fact_11_elem,axiom,
    ! [A: $tType,Xs: list(A),X: A] : listMem(A,X,cons(A,X,Xs)) ).

tff(fact_12_insert,axiom,
    ! [A: $tType,Y: A,Xs: list(A),X: A] :
      ( listMem(A,X,Xs)
     => listMem(A,X,cons(A,Y,Xs)) ) ).

tff(fact_13_mod__mod__trivial,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [B1: A,A2: A] : ( div_mod(A,div_mod(A,A2,B1),B1) = div_mod(A,A2,B1) ) ) ).

tff(fact_14_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_15_ListMem_Osimps,axiom,
    ! [A: $tType,A21: list(A),A11: A] :
      ( listMem(A,A11,A21)
    <=> ( ? [X3: A,Xs3: list(A)] :
            ( ( A11 = X3 )
            & ( A21 = cons(A,X3,Xs3) ) )
        | ? [X3: A,Xs3: list(A),Y1: A] :
            ( ( A11 = X3 )
            & ( A21 = cons(A,Y1,Xs3) )
            & listMem(A,X3,Xs3) ) ) ) ).

tff(fact_16_member__rec_I1_J,axiom,
    ! [A: $tType,Y2: A,Xs1: list(A),X1: A] :
      ( member1(A,cons(A,X1,Xs1),Y2)
    <=> ( ( X1 = Y2 )
        | member1(A,Xs1,Y2) ) ) ).

tff(fact_17_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_18_list__ex__simps_I1_J,axiom,
    ! [A: $tType,Xs1: list(A),X1: A,P1: fun(A,bool)] :
      ( list_ex(A,P1,cons(A,X1,Xs1))
    <=> ( pp(aa(A,bool,P1,X1))
        | list_ex(A,P1,Xs1) ) ) ).

tff(fact_19_listrelp_OCons,axiom,
    ! [A: $tType,Ys2: list(A),Xs1: list(A),Y2: A,X1: A,R1: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),R1,X1),Y2))
     => ( listrelp(A,R1,Xs1,Ys2)
       => listrelp(A,R1,cons(A,X1,Xs1),cons(A,Y2,Ys2)) ) ) ).

tff(fact_20_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xs1: list(A),X1: A,P1: fun(A,bool)] :
      ( list_all(A,P1,cons(A,X1,Xs1))
    <=> ( pp(aa(A,bool,P1,X1))
        & list_all(A,P1,Xs1) ) ) ).

tff(fact_21_list__all__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : list_all(A,P1,nil(A)) ).

tff(fact_22_list__ex__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex(A,P1,nil(A)) ).

tff(fact_23_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),nil(C)) = nil(A) ) ) ).

tff(fact_24_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] : ~ member1(A,nil(A),Y) ).

tff(fact_25_listrelp_ONil,axiom,
    ! [A: $tType,R1: fun(A,fun(A,bool))] : listrelp(A,R1,nil(A),nil(A)) ).

tff(fact_26_list_Osimps_I2_J,axiom,
    ! [A: $tType,List3: list(A),A4: A] : ( nil(A) != cons(A,A4,List3) ) ).

tff(fact_27_list_Osimps_I3_J,axiom,
    ! [A: $tType,List3: list(A),A4: A] : ( cons(A,A4,List3) != nil(A) ) ).

tff(fact_28_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_29_eq__Nil__null,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 = nil(A) )
    <=> null(A,Xs1) ) ).

tff(fact_30_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_31_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_32_List_Onull__def,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( null(A,Xs1)
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_33_null__rec_I2_J,axiom,
    ! [B: $tType] : null(B,nil(B)) ).

tff(fact_34_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_35_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),X1: A,P1: fun(A,bool)] :
      ( list_ex1(A,P1,cons(A,X1,Xs1))
    <=> ( ( pp(aa(A,bool,P1,X1))
         => list_all(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combb(bool,bool,A,fNot,P1)),fequal(A,X1)),Xs1) )
        & ( ~ pp(aa(A,bool,P1,X1))
         => list_ex1(A,P1,Xs1) ) ) ) ).

tff(fact_36_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y1: A,Ys1: list(A)] : ( Xs1 = cons(A,Y1,Ys1) ) ) ).

tff(fact_37_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List1: list(A)] : ( Y != cons(A,A3,List1) ) ) ).

tff(fact_38_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_39_equal__Nil__null,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( equal_equal(list(A),Xs1,nil(A))
    <=> null(A,Xs1) ) ).

tff(fact_40_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xs1: list(B),X1: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X1,Xs1),nil(C)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X1),zero_zero(C)),zipwith0(B,C,A,F,Xs1,nil(C))) ) ) ).

tff(fact_41_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys2: list(C),Y2: C,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),cons(C,Y2,Ys2)) = cons(A,aa(C,A,aa(B,fun(C,A),F,zero_zero(B)),Y2),zipwith0(B,C,A,F,nil(B),Ys2)) ) ) ).

tff(fact_42_zmod__zero,axiom,
    ! [B1: int] : ( div_mod(int,zero_zero(int),B1) = zero_zero(int) ) ).

tff(fact_43_zmod__self,axiom,
    ! [A2: int] : ( div_mod(int,A2,A2) = zero_zero(int) ) ).

tff(fact_44_mod__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,zero_zero(A),A2) = zero_zero(A) ) ) ).

tff(fact_45_mod__self,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,A2) = zero_zero(A) ) ) ).

tff(fact_46_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_47_mod__by__1,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,one_one(A)) = zero_zero(A) ) ) ).

tff(fact_48_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_49_equal__list__def,axiom,
    ! [A: $tType,Y2: list(A),X1: list(A)] :
      ( equal_equal(list(A),X1,Y2)
    <=> ( X1 = Y2 ) ) ).

tff(fact_50_mod__by__0,axiom,
    ! [A: $tType] :
      ( semiring_div(A)
     => ! [A2: A] : ( div_mod(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_51_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_52_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_53_listrelp_Osimps,axiom,
    ! [A: $tType,A21: list(A),A11: list(A),R1: fun(A,fun(A,bool))] :
      ( listrelp(A,R1,A11,A21)
    <=> ( ( ( A11 = nil(A) )
          & ( A21 = nil(A) ) )
        | ? [X3: A,Y1: A,Xs3: list(A),Ys1: list(A)] :
            ( ( A11 = cons(A,X3,Xs3) )
            & ( A21 = cons(A,Y1,Ys1) )
            & pp(aa(A,bool,aa(A,fun(A,bool),R1,X3),Y1))
            & listrelp(A,R1,Xs3,Ys1) ) ) ) ).

tff(fact_54_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( iprod(A,nil(A),Ys) = zero_zero(A) ) ) ).

tff(fact_55_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( iprod(A,Xs,nil(A)) = zero_zero(A) ) ) ).

tff(fact_56_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = cons(A,X1,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_57_list__nonempty__induct,axiom,
    ! [A: $tType,P1: fun(list(A),bool),Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,P1,cons(A,X2,nil(A))))
       => ( ! [X2: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P1,Xs2))
               => pp(aa(list(A),bool,P1,cons(A,X2,Xs2))) ) )
         => pp(aa(list(A),bool,P1,Xs1)) ) ) ) ).

tff(fact_58_Z_Onot__dep__decr,axiom,
    ! [Xs1: list(int),X1: int,Aa: atom] :
      ( ( hd_coeff(Aa) = zero_zero(int) )
     => ( i_Z(Aa,cons(int,X1,Xs1))
      <=> i_Z(decr_Z(Aa),Xs1) ) ) ).

tff(fact_59_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_60_Z_Oanormal__decr,axiom,
    ! [A2: atom] :
      ( ( hd_coeff(A2) = zero_zero(int) )
     => ( ( divisor(A2) != zero_zero(int) )
       => ( divisor(decr_Z(A2)) != zero_zero(int) ) ) ) ).

tff(fact_61_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_62_hd__coeff_Osimps_I3_J,axiom,
    ! [Ks2: list(int),Ia: int,D1: int] : ( hd_coeff(nDvd(D1,Ia,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_63_hd__coeff_Osimps_I1_J,axiom,
    ! [Ks2: list(int),Ia: int] : ( hd_coeff(c_PresArith_Oatom_OLe(Ia,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_64_atom_Osimps_I1_J,axiom,
    ! [List4: list(int),Int5: int,List: list(int),Int: int] :
      ( ( c_PresArith_Oatom_OLe(Int,List) = c_PresArith_Oatom_OLe(Int5,List4) )
    <=> ( ( Int = Int5 )
        & ( List = List4 ) ) ) ).

tff(fact_65_atom_Osimps_I3_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List: list(int),Int2: int,Int1: int] :
      ( ( nDvd(Int1,Int2,List) = nDvd(Int14,Int24,List4) )
    <=> ( ( Int1 = Int14 )
        & ( Int2 = Int24 )
        & ( List = List4 ) ) ) ).

tff(fact_66_divisor_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( divisor(c_PresArith_Oatom_OLe(I1,Ks1)) = one_one(int) ) ).

tff(fact_67_atom_Osimps_I6_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List2: list(int),Int4: int] : ( c_PresArith_Oatom_OLe(Int4,List2) != nDvd(Int12,Int22,List3) ) ).

tff(fact_68_atom_Osimps_I7_J,axiom,
    ! [List2: list(int),Int4: int,List3: list(int),Int22: int,Int12: int] : ( nDvd(Int12,Int22,List3) != c_PresArith_Oatom_OLe(Int4,List2) ) ).

tff(fact_69_divisor_Osimps_I3_J,axiom,
    ! [Ks1: list(int),I1: int,D: int] : ( divisor(nDvd(D,I1,Ks1)) = D ) ).

tff(fact_70_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_71_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_72_atom_Osize_I1_J,axiom,
    ! [List2: list(int),Int4: int] : ( atom_size(c_PresArith_Oatom_OLe(Int4,List2)) = zero_zero(nat) ) ).

tff(fact_73_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_74_atom_Osize_I3_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( atom_size(nDvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_75_atom_Osize_I4_J,axiom,
    ! [List2: list(int),Int4: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int4,List2)) = zero_zero(nat) ) ).

tff(fact_76_atom_Osize_I6_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( size_size(atom,nDvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_77_hd__coeff_Osimps_I2_J,axiom,
    ! [Ks2: list(int),Ia: int,D1: int] : ( hd_coeff(dvd(D1,Ia,Ks2)) = list_case(int,int,zero_zero(int),combk(int,list(int)),Ks2) ) ).

tff(fact_78_atom_Osize_I2_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( atom_size(dvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_79_atom_Osimps_I2_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List: list(int),Int2: int,Int1: int] :
      ( ( dvd(Int1,Int2,List) = dvd(Int14,Int24,List4) )
    <=> ( ( Int1 = Int14 )
        & ( Int2 = Int24 )
        & ( List = List4 ) ) ) ).

tff(fact_80_atom_Osize_I5_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int] : ( size_size(atom,dvd(Int13,Int23,List2)) = zero_zero(nat) ) ).

tff(fact_81_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_case(A,F1,F2,F3,dvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int1),Int2),List) ) ).

tff(fact_82_divisor_Osimps_I2_J,axiom,
    ! [Ks1: list(int),I1: int,D: int] : ( divisor(dvd(D,I1,Ks1)) = D ) ).

tff(fact_83_atom_Osimps_I9_J,axiom,
    ! [List2: list(int),Int23: int,Int13: int,List3: list(int),Int22: int,Int12: int] : ( nDvd(Int12,Int22,List3) != dvd(Int13,Int23,List2) ) ).

tff(fact_84_atom_Osimps_I8_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List2: list(int),Int23: int,Int13: int] : ( dvd(Int13,Int23,List2) != nDvd(Int12,Int22,List3) ) ).

tff(fact_85_atom_Osimps_I5_J,axiom,
    ! [List2: list(int),Int4: int,List3: list(int),Int22: int,Int12: int] : ( dvd(Int12,Int22,List3) != c_PresArith_Oatom_OLe(Int4,List2) ) ).

tff(fact_86_atom_Osimps_I4_J,axiom,
    ! [List3: list(int),Int22: int,Int12: int,List2: list(int),Int4: int] : ( c_PresArith_Oatom_OLe(Int4,List2) != dvd(Int12,Int22,List3) ) ).

tff(fact_87_atom_Oexhaust,axiom,
    ! [Y: atom] :
      ( ! [Int3: int,List1: list(int)] : ( Y != c_PresArith_Oatom_OLe(Int3,List1) )
     => ( ! [Int11: int,Int21: int,List1: list(int)] : ( Y != dvd(Int11,Int21,List1) )
       => ~ ! [Int11: int,Int21: int,List1: list(int)] : ( Y != nDvd(Int11,Int21,List1) ) ) ) ).

tff(fact_88_atom_Orecs_I1_J,axiom,
    ! [A: $tType,List: list(int),Int: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,c_PresArith_Oatom_OLe(Int,List)) = aa(list(int),A,aa(int,fun(list(int),A),F1,Int),List) ) ).

tff(fact_89_atom_Orecs_I2_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,dvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F2,Int1),Int2),List) ) ).

tff(fact_90_atom_Orecs_I3_J,axiom,
    ! [A: $tType,List: list(int),Int2: int,Int1: int,F3: fun(int,fun(int,fun(list(int),A))),F2: fun(int,fun(int,fun(list(int),A))),F1: fun(int,fun(list(int),A))] : ( atom_rec(A,F1,F2,F3,nDvd(Int1,Int2,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int1),Int2),List) ) ).

tff(fact_91_decr_092_060_094isub_062Z_Osimps_I3_J,axiom,
    ! [Ks1: list(int),I1: int,D: int] : ( decr_Z(nDvd(D,I1,Ks1)) = nDvd(D,I1,tl(int,Ks1)) ) ).

tff(fact_92_decr_092_060_094isub_062Z_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( decr_Z(c_PresArith_Oatom_OLe(I1,Ks1)) = c_PresArith_Oatom_OLe(I1,tl(int,Ks1)) ) ).

tff(fact_93_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( tl(A,nil(A)) = nil(A) ) ).

tff(fact_94_decr_092_060_094isub_062Z_Osimps_I2_J,axiom,
    ! [Ks1: list(int),I1: int,D: int] : ( decr_Z(dvd(D,I1,Ks1)) = dvd(D,I1,tl(int,Ks1)) ) ).

tff(fact_95_tl_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( tl(A,cons(A,X,Xs)) = Xs ) ).

tff(fact_96_asubst_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Ks: list(int),I: int] : ( asubst(I,Ks,nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

tff(fact_97_asubst_Osimps_I4_J,axiom,
    ! [V: int,Ks: list(int),I: int] : ( asubst(I,Ks,c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

%----Arities (9)
tff(arity_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Divides_Osemiring__div,axiom,
    semiring_div(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (16)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,fequal(A,X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,fequal(A,X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( i_Z(a,cons(int,i,e))
  <=> i_Z(a,cons(int,j,e)) ) ).

%------------------------------------------------------------------------------
