%------------------------------------------------------------------------------
% File     : COM028_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 25
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_25 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  183 (  36 unt;  52 typ;   0 def)
%            Number of atoms       :  339 (  72 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  229 (  21   ~;   9   |;  12   &)
%                                         (  30 <=>; 157  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   26 (  15   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :   34 (  33 usr;   0 prp; 1-3 aty)
%            Number of functors    :   16 (  16 usr;   5 con; 0-4 aty)
%            Number of variables   :  380 ( 334   !;   6   ?; 380   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:04
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Rings_Odvd,type,
    dvd: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semiring__strict,type,
    linord20386208strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__comm__semiring__strict,type,
    linord893533164strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * list(A) ) > list(B1) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff1,type,
    hd_coeff1: ( int * atom ) > atom ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_Rings_Odvd__class_Odvd,type,
    dvd_dvd: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__C0_C,axiom,
    ! [X4: atom] :
      ( member(atom,X4,set(atom,as))
     => ( aa(atom,int,hd_coeff,X4) != zero_zero(int) ) ) ).

tff(fact_1_calculation,axiom,
    ( ? [X: int] :
      ! [Xa: atom] :
        ( member(atom,Xa,set(atom,as))
       => i_Z(Xa,cons(int,X,xs)) )
  <=> ? [X: int] :
      ! [Xa: atom] :
        ( member(atom,Xa,set(atom,as))
       => i_Z(hd_coeff1(zlcms(map(atom,int,hd_coeff,as)),Xa),cons(int,times_times(int,zlcms(map(atom,int,hd_coeff,as)),X),xs)) ) ) ).

tff(fact_2_dvd__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [B2: A,C1: A,A2: A] :
          ( dvd_dvd(A,times_times(A,A2,C1),times_times(A,B2,C1))
        <=> ( ( C1 = zero_zero(A) )
            | dvd_dvd(A,A2,B2) ) ) ) ).

tff(fact_3_dvd__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [B2: A,A2: A,C1: A] :
          ( dvd_dvd(A,times_times(A,C1,A2),times_times(A,C1,B2))
        <=> ( ( C1 = zero_zero(A) )
            | dvd_dvd(A,A2,B2) ) ) ) ).

tff(fact_4__0960_A_060_Azlcms_A_Imap_Ahd__coeff_Aas_J_096,axiom,
    ord_less(int,zero_zero(int),zlcms(map(atom,int,hd_coeff,as))) ).

tff(fact_5_map__eq__conv,axiom,
    ! [A: $tType,B1: $tType,G: fun(B1,A),Xsa: list(B1),F: fun(B1,A)] :
      ( ( map(B1,A,F,Xsa) = map(B1,A,G,Xsa) )
    <=> ! [X: B1] :
          ( member(B1,X,set(B1,Xsa))
         => ( aa(B1,A,F,X) = aa(B1,A,G,X) ) ) ) ).

tff(fact_6_map_Osimps_I2_J,axiom,
    ! [A: $tType,B1: $tType,Xsa: list(B1),X1: B1,F: fun(B1,A)] : ( map(B1,A,F,cons(B1,X1,Xsa)) = cons(A,aa(B1,A,F,X1),map(B1,A,F,Xsa)) ) ).

tff(fact_7_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y1: A,Xs: list(A),X2: A] : ( plus_plus(list(A),cons(A,X2,Xs),cons(A,Y1,Ys)) = cons(A,plus_plus(A,X2,Y1),plus_plus(list(A),Xs,Ys)) ) ) ).

tff(fact_8_dvd__0__right,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : dvd_dvd(A,A1,zero_zero(A)) ) ).

tff(fact_9_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_10_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( plus_plus(A,A2,A2) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_11_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_12_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_13_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B2: A,A2: A] :
          ( ( times_times(A,A2,B2) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            | ( B2 = zero_zero(A) ) ) ) ) ).

tff(fact_14_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B2: A] :
          ( ( plus_plus(A,B2,A2) = plus_plus(A,C1,A2) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_15_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_16_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A4: A,List: list(A),A2: A] :
      ( ( cons(A,A2,List) = cons(A,A4,List1) )
    <=> ( ( A2 = A4 )
        & ( List = List1 ) ) ) ).

tff(fact_17_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B2))
        <=> ord_less(A,A2,B2) ) ) ).

tff(fact_18_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,C1: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B2,C1))
        <=> ord_less(A,A2,B2) ) ) ).

tff(fact_19_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_20_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A2,A2))
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_21_list__add__assoc,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( plus_plus(list(A),plus_plus(list(A),Xs,Ys),Zs) = plus_plus(list(A),Xs,plus_plus(list(A),Ys,Zs)) ) ) ).

tff(fact_22_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 != Y1 )
         => ( ~ ord_less(A,X2,Y1)
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_23_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
         => ord_less(A,A1,B) ) ) ).

tff(fact_24_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
         => ord_less(A,A1,B) ) ) ).

tff(fact_25_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C,D)
           => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ) ).

tff(fact_26_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B)) ) ) ).

tff(fact_27_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C)) ) ) ).

tff(fact_28_mult__strict__left__mono__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [C: A,A1: A,B: A] :
          ( ord_less(A,B,A1)
         => ( ord_less(A,C,zero_zero(A))
           => ord_less(A,times_times(A,C,A1),times_times(A,C,B)) ) ) ) ).

tff(fact_29_mult__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [C: A,A1: A,B: A] :
          ( ord_less(A,B,A1)
         => ( ord_less(A,C,zero_zero(A))
           => ord_less(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ) ).

tff(fact_30_comm__mult__strict__left__mono,axiom,
    ! [A: $tType] :
      ( linord893533164strict(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,zero_zero(A),C)
           => ord_less(A,times_times(A,C,A1),times_times(A,C,B)) ) ) ) ).

tff(fact_31_mult__strict__left__mono,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,zero_zero(A),C)
           => ord_less(A,times_times(A,C,A1),times_times(A,C,B)) ) ) ) ).

tff(fact_32_mult__strict__right__mono,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,zero_zero(A),C)
           => ord_less(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ) ).

tff(fact_33_mult__neg__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,zero_zero(A),times_times(A,A1,B)) ) ) ) ).

tff(fact_34_mult__neg__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,times_times(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_35_mult__less__cancel__left__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,C1,zero_zero(A))
         => ( ord_less(A,times_times(A,C1,A2),times_times(A,C1,B2))
          <=> ord_less(A,B2,A2) ) ) ) ).

tff(fact_36_zero__less__mult__pos2,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [A1: A,B: A] :
          ( ord_less(A,zero_zero(A),times_times(A,B,A1))
         => ( ord_less(A,zero_zero(A),A1)
           => ord_less(A,zero_zero(A),B) ) ) ) ).

tff(fact_37_zero__less__mult__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),times_times(A,A1,B))
         => ( ord_less(A,zero_zero(A),A1)
           => ord_less(A,zero_zero(A),B) ) ) ) ).

tff(fact_38_mult__pos__neg2,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,times_times(A,B,A1),zero_zero(A)) ) ) ) ).

tff(fact_39_mult__pos__neg,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,times_times(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_40_mult__pos__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),times_times(A,A1,B)) ) ) ) ).

tff(fact_41_mult__less__cancel__left__pos,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,zero_zero(A),C1)
         => ( ord_less(A,times_times(A,C1,A2),times_times(A,C1,B2))
          <=> ord_less(A,A2,B2) ) ) ) ).

tff(fact_42_mult__less__cancel__left__disj,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,times_times(A,C1,A2),times_times(A,C1,B2))
        <=> ( ( ord_less(A,zero_zero(A),C1)
              & ord_less(A,A2,B2) )
            | ( ord_less(A,C1,zero_zero(A))
              & ord_less(A,B2,A2) ) ) ) ) ).

tff(fact_43_mult__less__cancel__right__disj,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,C1: A,A2: A] :
          ( ord_less(A,times_times(A,A2,C1),times_times(A,B2,C1))
        <=> ( ( ord_less(A,zero_zero(A),C1)
              & ord_less(A,A2,B2) )
            | ( ord_less(A,C1,zero_zero(A))
              & ord_less(A,B2,A2) ) ) ) ) ).

tff(fact_44_not__square__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_ring(A)
     => ! [A1: A] : ~ ord_less(A,times_times(A,A1,A1),zero_zero(A)) ) ).

tff(fact_45_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,plus_plus(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_46_pos__add__strict,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B,C)
           => ord_less(A,B,plus_plus(A,A1,C)) ) ) ) ).

tff(fact_47_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),plus_plus(A,A1,B)) ) ) ) ).

tff(fact_48_even__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_49_zmult__zless__mono2,axiom,
    ! [K1: int,J: int,I1: int] :
      ( ord_less(int,I1,J)
     => ( ord_less(int,zero_zero(int),K1)
       => ord_less(int,times_times(int,K1,I1),times_times(int,K1,J)) ) ) ).

tff(fact_50_zdvd__not__zless,axiom,
    ! [N1: int,M1: int] :
      ( ord_less(int,zero_zero(int),M1)
     => ( ord_less(int,M1,N1)
       => ~ dvd_dvd(int,N1,M1) ) ) ).

tff(fact_51_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_52_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,times_times(A,A1,B),C) = times_times(A,A1,times_times(A,B,C)) ) ) ).

tff(fact_53_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_54_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_55_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_56_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_57_dvd__trans,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] :
          ( dvd_dvd(A,A1,B)
         => ( dvd_dvd(A,B,C)
           => dvd_dvd(A,A1,C) ) ) ) ).

tff(fact_58_dvd__refl,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : dvd_dvd(A,A1,A1) ) ).

tff(fact_59_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X2: A] : ( cons(A,X2,Xs) != Xs ) ).

tff(fact_60_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs: list(A)] : ( Xs != cons(A,X2,Xs) ) ).

tff(fact_61_divisors__zero,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( times_times(A,A1,B) = zero_zero(A) )
         => ( ( A1 = zero_zero(A) )
            | ( B = zero_zero(A) ) ) ) ) ).

tff(fact_62_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( ( B != zero_zero(A) )
           => ( times_times(A,A1,B) != zero_zero(A) ) ) ) ) ).

tff(fact_63_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_64_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_65_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_66_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_67_dvd__0__left,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] :
          ( dvd_dvd(A,zero_zero(A),A1)
         => ( A1 = zero_zero(A) ) ) ) ).

tff(fact_68_combine__common__factor,axiom,
    ! [A: $tType] :
      ( semiring(A)
     => ! [C: A,B: A,E: A,A1: A] : ( plus_plus(A,times_times(A,A1,E),plus_plus(A,times_times(A,B,E),C)) = plus_plus(A,times_times(A,plus_plus(A,A1,B),E),C) ) ) ).

tff(fact_69_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( comm_semiring(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,plus_plus(A,A1,B),C) = plus_plus(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ).

tff(fact_70_dvd__mult__right,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] :
          ( dvd_dvd(A,times_times(A,A1,B),C)
         => dvd_dvd(A,B,C) ) ) ).

tff(fact_71_dvd__mult__left,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] :
          ( dvd_dvd(A,times_times(A,A1,B),C)
         => dvd_dvd(A,A1,C) ) ) ).

tff(fact_72_dvdI,axiom,
    ! [A: $tType] :
      ( dvd(A)
     => ! [K1: A,B: A,A1: A] :
          ( ( A1 = times_times(A,B,K1) )
         => dvd_dvd(A,B,A1) ) ) ).

tff(fact_73_mult__dvd__mono,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( dvd_dvd(A,A1,B)
         => ( dvd_dvd(A,C,D)
           => dvd_dvd(A,times_times(A,A1,C),times_times(A,B,D)) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X3: A] : ( aa(A,B1,F,X3) = aa(A,B1,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X1: A] :
      ( member(A,X1,A3)
    <=> pp(aa(A,bool,A3,X1)) ) ).

tff(fact_76_dvd__mult,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,C: A,A1: A] :
          ( dvd_dvd(A,A1,C)
         => dvd_dvd(A,A1,times_times(A,B,C)) ) ) ).

tff(fact_77_dvd__mult2,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] :
          ( dvd_dvd(A,A1,B)
         => dvd_dvd(A,A1,times_times(A,B,C)) ) ) ).

tff(fact_78_dvd__triv__right,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : dvd_dvd(A,A1,times_times(A,B,A1)) ) ).

tff(fact_79_dvd__triv__left,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : dvd_dvd(A,A1,times_times(A,A1,B)) ) ).

tff(fact_80_dvd__add,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] :
          ( dvd_dvd(A,A1,B)
         => ( dvd_dvd(A,A1,C)
           => dvd_dvd(A,A1,plus_plus(A,B,C)) ) ) ) ).

tff(fact_81_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X1: A,Y: A] :
      ( member(A,Y,set(A,cons(A,X1,Xsa)))
     => ( ( Y = X1 )
        | member(A,Y,set(A,Xsa)) ) ) ).

tff(fact_82_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( times_times(int,plus_plus(int,Z1,Z2),W) = plus_plus(int,times_times(int,Z1,W),times_times(int,Z2,W)) ) ).

tff(fact_83_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( times_times(int,W,plus_plus(int,Z1,Z2)) = plus_plus(int,times_times(int,W,Z1),times_times(int,W,Z2)) ) ).

tff(fact_84_zdvd__mult__cancel,axiom,
    ! [N1: int,M1: int,K1: int] :
      ( dvd_dvd(int,times_times(int,K1,M1),times_times(int,K1,N1))
     => ( ( K1 != zero_zero(int) )
       => dvd_dvd(int,M1,N1) ) ) ).

tff(fact_85_zdvd__period,axiom,
    ! [C1: int,T: int,X1: int,D1: int,A2: int] :
      ( dvd_dvd(int,A2,D1)
     => ( dvd_dvd(int,A2,plus_plus(int,X1,T))
      <=> dvd_dvd(int,A2,plus_plus(int,plus_plus(int,X1,times_times(int,C1,D1)),T)) ) ) ).

tff(fact_86_zdvd__reduce,axiom,
    ! [M: int,N: int,K: int] :
      ( dvd_dvd(int,K,plus_plus(int,N,times_times(int,K,M)))
    <=> dvd_dvd(int,K,N) ) ).

tff(fact_87_I__hd__coeff1__mult__a,axiom,
    ! [Xsa: list(int),X1: int,A2: atom,M: int] :
      ( ord_less(int,zero_zero(int),M)
     => ( ( dvd_dvd(int,aa(atom,int,hd_coeff,A2),M)
          | ( aa(atom,int,hd_coeff,A2) = zero_zero(int) ) )
       => ( i_Z(hd_coeff1(M,A2),cons(int,times_times(int,M,X1),Xsa))
        <=> i_Z(A2,cons(int,X1,Xsa)) ) ) ) ).

tff(fact_88_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> member(int,zero_zero(int),set(int,Is)) ) ).

tff(fact_89_unity__coeff__ex,axiom,
    ! [A: $tType] :
      ( ( dvd(A)
        & semiring_0(A) )
     => ! [L: A,P: fun(A,bool)] :
          ( ? [X: A] : pp(aa(A,bool,P,times_times(A,L,X)))
        <=> ? [X: A] :
              ( dvd_dvd(A,L,plus_plus(A,X,zero_zero(A)))
              & pp(aa(A,bool,P,X)) ) ) ) ).

tff(fact_90_sum__squares__gt__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,times_times(A,X1,X1),times_times(A,Y,Y)))
        <=> ( ( X1 != zero_zero(A) )
            | ( Y != zero_zero(A) ) ) ) ) ).

tff(fact_91_not__sum__squares__lt__zero,axiom,
    ! [A: $tType] :
      ( linordered_ring(A)
     => ! [Y1: A,X2: A] : ~ ord_less(A,plus_plus(A,times_times(A,X2,X2),times_times(A,Y1,Y1)),zero_zero(A)) ) ).

tff(fact_92_zdvd__mono,axiom,
    ! [T: int,M: int,K: int] :
      ( ( K != zero_zero(int) )
     => ( dvd_dvd(int,M,T)
      <=> dvd_dvd(int,times_times(int,K,M),times_times(int,K,T)) ) ) ).

tff(fact_93_add__scale__eq__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [D: A,C: A,B: A,A1: A,R: A] :
          ( ( R != zero_zero(A) )
         => ( ( ( A1 = B )
              & ( C != D ) )
           => ( plus_plus(A,A1,times_times(A,R,C)) != plus_plus(A,B,times_times(A,R,D)) ) ) ) ) ).

tff(fact_94_sum__squares__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Y: A,X1: A] :
          ( ( plus_plus(A,times_times(A,X1,X1),times_times(A,Y,Y)) = zero_zero(A) )
        <=> ( ( X1 = zero_zero(A) )
            & ( Y = zero_zero(A) ) ) ) ) ).

tff(fact_95_dvd__zlcms,axiom,
    ! [Is: list(int),I: int] :
      ( member(int,I,set(int,Is))
     => dvd_dvd(int,I,zlcms(Is)) ) ).

tff(fact_96_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,B) = times_times(A,B,A1) ) ) ).

tff(fact_97_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_98_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

%----Arities (29)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(int) ).

tff(arity_Int_Oint___Rings_Olinordered__comm__semiring__strict,axiom,
    linord893533164strict(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semiring__strict,axiom,
    linord20386208strict(int) ).

tff(arity_Int_Oint___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring,axiom,
    linordered_ring(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring,axiom,
    comm_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Osemiring__0,axiom,
    semiring_0(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oidom,axiom,
    idom(int) ).

tff(arity_Int_Oint___Rings_Odvd,axiom,
    dvd(int) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( ? [X: int] :
        ! [Xa: atom] :
          ( member(atom,Xa,set(atom,as))
         => i_Z(hd_coeff1(zlcms(map(atom,int,hd_coeff,as)),Xa),cons(int,times_times(int,zlcms(map(atom,int,hd_coeff,as)),X),xs)) )
    <=> ~ ? [X: int] :
            ( dvd_dvd(int,zlcms(map(atom,int,hd_coeff,as)),plus_plus(int,X,zero_zero(int)))
            & ! [Xa: atom] :
                ( member(atom,Xa,set(atom,as))
               => i_Z(hd_coeff1(zlcms(map(atom,int,hd_coeff,as)),Xa),cons(int,X,xs)) ) ) ) ).

%------------------------------------------------------------------------------
