%------------------------------------------------------------------------------
% File     : COM027_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 23
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_23 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  167 (  27 unt;  45 typ;   0 def)
%            Number of atoms       :  353 (  83 equ)
%            Maximal formula atoms :   12 (   2 avg)
%            Number of connectives :  254 (  23   ~;  12   |;  13   &)
%                                         (  37 <=>; 169  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   31 (  18   >;  13   *;   0   +;   0  <<)
%            Number of predicates  :   24 (  23 usr;   0 prp; 1-3 aty)
%            Number of functors    :   19 (  19 usr;   5 con; 0-5 aty)
%            Number of variables   :  419 ( 359   !;  27   ?; 419   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:02
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Rings_Odvd,type,
    dvd: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semiring__strict,type,
    linord20386208strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__comm__semiring__strict,type,
    linord893533164strict: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),T2)) * list(A) ) > T2 ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Odecr_092_060_094isub_062Z,type,
    decr_Z: atom > atom ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff1,type,
    hd_coeff1: ( int * atom ) > atom ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_Rings_Odvd__class_Odvd,type,
    dvd_dvd: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__C0_C,axiom,
    ! [X1: atom] :
      ( member(atom,X1,set(atom,as))
     => ( aa(atom,int,hd_coeff,X1) != zero_zero(int) ) ) ).

tff(fact_1_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F3: fun(B,A)] :
      ( ( map(B,A,F3,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X: B] :
          ( member(B,X,set(B,Xsa))
         => ( aa(B,A,F3,X) = aa(B,A,G,X) ) ) ) ).

tff(fact_2_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),X4: B,F3: fun(B,A)] : ( map(B,A,F3,cons(B,X4,Xsa)) = cons(A,aa(B,A,F3,X4),map(B,A,F3,Xsa)) ) ).

tff(fact_3_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A4: A,List: list(A),A1: A] :
      ( ( cons(A,A1,List) = cons(A,A4,List1) )
    <=> ( ( A1 = A4 )
        & ( List = List1 ) ) ) ).

tff(fact_4_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B1: A,A2: A] : ( times_times(A,A2,times_times(A,A2,B1)) = times_times(A,A2,B1) ) ) ).

tff(fact_5_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X4: A,Y1: A] :
      ( member(A,Y1,set(A,cons(A,X4,Xsa)))
     => ( ( Y1 = X4 )
        | member(A,Y1,set(A,Xsa)) ) ) ).

tff(fact_6__0960_A_060_Azlcms_A_Imap_Ahd__coeff_Aas_J_096,axiom,
    ord_less(int,zero_zero(int),zlcms(map(atom,int,hd_coeff,as))) ).

tff(fact_7_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F3: fun(A,B),Ys1: list(B)] :
      ( ? [Xs1: list(A)] : ( Ys1 = map(A,B,F3,Xs1) )
    <=> ! [X: B] :
          ( member(B,X,set(B,Ys1))
         => ? [Xa: A] : ( X = aa(A,B,F3,Xa) ) ) ) ).

tff(fact_8_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F3: fun(A,B),Xsa: list(A)] :
      ( ! [X2: A] :
          ( member(A,X2,set(A,Xsa))
         => ( aa(A,B,F3,X2) = aa(A,B,G,X2) ) )
     => ( map(A,B,F3,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_9_map__idI,axiom,
    ! [A: $tType,F3: fun(A,A),Xsa: list(A)] :
      ( ! [X2: A] :
          ( member(A,X2,set(A,Xsa))
         => ( aa(A,A,F3,X2) = X2 ) )
     => ( map(A,A,F3,Xsa) = Xsa ) ) ).

tff(fact_10_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F3: fun(A,B),Ys1: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys1 )
     => ( ! [X2: A] :
            ( member(A,X2,set(A,Ys1))
           => ( aa(A,B,F3,X2) = aa(A,B,G,X2) ) )
       => ( map(A,B,F3,Xsa) = map(A,B,G,Ys1) ) ) ) ).

tff(fact_11_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),F3: fun(B,A),Xsa: list(A),X4: A] :
      ( ( cons(A,X4,Xsa) = map(B,A,F3,Ys1) )
    <=> ? [Z4: B,Zs: list(B)] :
          ( ( Ys1 = cons(B,Z4,Zs) )
          & ( X4 = aa(B,A,F3,Z4) )
          & ( Xsa = map(B,A,F3,Zs) ) ) ) ).

tff(fact_12_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys1: list(A),Y1: A,Xsa: list(B),F3: fun(B,A)] :
      ( ( map(B,A,F3,Xsa) = cons(A,Y1,Ys1) )
    <=> ? [Z4: B,Zs: list(B)] :
          ( ( Xsa = cons(B,Z4,Zs) )
          & ( aa(B,A,F3,Z4) = Y1 )
          & ( map(B,A,F3,Zs) = Ys1 ) ) ) ).

tff(fact_13_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X3: A] : ( times_times(A,X3,X3) = X3 ) ) ).

tff(fact_14_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A2: A] : ( times_times(A,A2,A2) = A2 ) ) ).

tff(fact_15_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X3: A] : ( cons(A,X3,Xs) != Xs ) ).

tff(fact_16_not__Cons__self,axiom,
    ! [A: $tType,X3: A,Xs: list(A)] : ( Xs != cons(A,X3,Xs) ) ).

tff(fact_17_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> member(int,zero_zero(int),set(int,Is)) ) ).

tff(fact_18_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B2: A,A1: A] :
          ( ( times_times(A,A1,B2) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            | ( B2 = zero_zero(A) ) ) ) ) ).

tff(fact_19_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A2: A] : ( times_times(A,A2,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_20_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A2: A] : ( times_times(A,zero_zero(A),A2) = zero_zero(A) ) ) ).

tff(fact_21_zmult__zless__mono2,axiom,
    ! [K2: int,J: int,I1: int] :
      ( ord_less(int,I1,J)
     => ( ord_less(int,zero_zero(int),K2)
       => ord_less(int,times_times(int,K2,I1),times_times(int,K2,J)) ) ) ).

tff(fact_22_not__square__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_ring(A)
     => ! [A2: A] : ~ ord_less(A,times_times(A,A2,A2),zero_zero(A)) ) ).

tff(fact_23_mult__less__cancel__right__disj,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,C2: A,A1: A] :
          ( ord_less(A,times_times(A,A1,C2),times_times(A,B2,C2))
        <=> ( ( ord_less(A,zero_zero(A),C2)
              & ord_less(A,A1,B2) )
            | ( ord_less(A,C2,zero_zero(A))
              & ord_less(A,B2,A1) ) ) ) ) ).

tff(fact_24_mult__less__cancel__left__disj,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A1: A,C2: A] :
          ( ord_less(A,times_times(A,C2,A1),times_times(A,C2,B2))
        <=> ( ( ord_less(A,zero_zero(A),C2)
              & ord_less(A,A1,B2) )
            | ( ord_less(A,C2,zero_zero(A))
              & ord_less(A,B2,A1) ) ) ) ) ).

tff(fact_25_mult__less__cancel__left__pos,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A1: A,C2: A] :
          ( ord_less(A,zero_zero(A),C2)
         => ( ord_less(A,times_times(A,C2,A1),times_times(A,C2,B2))
          <=> ord_less(A,A1,B2) ) ) ) ).

tff(fact_26_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X3: A] :
          ( ( X3 != Y )
         => ( ~ ord_less(A,X3,Y)
           => ord_less(A,Y,X3) ) ) ) ).

tff(fact_27_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B1: A,A2: A] :
          ( ( A2 != zero_zero(A) )
         => ( ( B1 != zero_zero(A) )
           => ( times_times(A,A2,B1) != zero_zero(A) ) ) ) ) ).

tff(fact_28_divisors__zero,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B1: A,A2: A] :
          ( ( times_times(A,A2,B1) = zero_zero(A) )
         => ( ( A2 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

tff(fact_29_mult__strict__left__mono__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ord_less(A,B1,A2)
         => ( ord_less(A,C1,zero_zero(A))
           => ord_less(A,times_times(A,C1,A2),times_times(A,C1,B1)) ) ) ) ).

tff(fact_30_mult__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ord_less(A,B1,A2)
         => ( ord_less(A,C1,zero_zero(A))
           => ord_less(A,times_times(A,A2,C1),times_times(A,B1,C1)) ) ) ) ).

tff(fact_31_comm__mult__strict__left__mono,axiom,
    ! [A: $tType] :
      ( linord893533164strict(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ord_less(A,zero_zero(A),C1)
           => ord_less(A,times_times(A,C1,A2),times_times(A,C1,B1)) ) ) ) ).

tff(fact_32_mult__strict__left__mono,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ord_less(A,zero_zero(A),C1)
           => ord_less(A,times_times(A,C1,A2),times_times(A,C1,B1)) ) ) ) ).

tff(fact_33_mult__strict__right__mono,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ord_less(A,zero_zero(A),C1)
           => ord_less(A,times_times(A,A2,C1),times_times(A,B1,C1)) ) ) ) ).

tff(fact_34_mult__neg__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,A2,zero_zero(A))
         => ( ord_less(A,B1,zero_zero(A))
           => ord_less(A,zero_zero(A),times_times(A,A2,B1)) ) ) ) ).

tff(fact_35_mult__neg__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,A2,zero_zero(A))
         => ( ord_less(A,zero_zero(A),B1)
           => ord_less(A,times_times(A,A2,B1),zero_zero(A)) ) ) ) ).

tff(fact_36_mult__less__cancel__left__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A1: A,C2: A] :
          ( ord_less(A,C2,zero_zero(A))
         => ( ord_less(A,times_times(A,C2,A1),times_times(A,C2,B2))
          <=> ord_less(A,B2,A1) ) ) ) ).

tff(fact_37_zero__less__mult__pos2,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [A2: A,B1: A] :
          ( ord_less(A,zero_zero(A),times_times(A,B1,A2))
         => ( ord_less(A,zero_zero(A),A2)
           => ord_less(A,zero_zero(A),B1) ) ) ) ).

tff(fact_38_zero__less__mult__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,zero_zero(A),times_times(A,A2,B1))
         => ( ord_less(A,zero_zero(A),A2)
           => ord_less(A,zero_zero(A),B1) ) ) ) ).

tff(fact_39_mult__pos__neg2,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( ord_less(A,B1,zero_zero(A))
           => ord_less(A,times_times(A,B1,A2),zero_zero(A)) ) ) ) ).

tff(fact_40_mult__pos__neg,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( ord_less(A,B1,zero_zero(A))
           => ord_less(A,times_times(A,A2,B1),zero_zero(A)) ) ) ) ).

tff(fact_41_mult__pos__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( ord_less(A,zero_zero(A),B1)
           => ord_less(A,zero_zero(A),times_times(A,A2,B1)) ) ) ) ).

tff(fact_42_zlcms__pos,axiom,
    ! [Is: list(int)] :
      ( ! [X2: int] :
          ( member(int,X2,set(int,Is))
         => ( X2 != zero_zero(int) ) )
     => ord_less(int,zero_zero(int),zlcms(Is)) ) ).

tff(fact_43_I__hd__coeff1__mult__a,axiom,
    ! [Xsa: list(int),X4: int,A1: atom,M: int] :
      ( ord_less(int,zero_zero(int),M)
     => ( ( dvd_dvd(int,aa(atom,int,hd_coeff,A1),M)
          | ( aa(atom,int,hd_coeff,A1) = zero_zero(int) ) )
       => ( i_Z(hd_coeff1(M,A1),cons(int,times_times(int,M,X4),Xsa))
        <=> i_Z(A1,cons(int,X4,Xsa)) ) ) ) ).

tff(fact_44_comm__semiring__1__class_Onormalizing__semiring__rules_I9_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : ( times_times(A,zero_zero(A),A2) = zero_zero(A) ) ) ).

tff(fact_45_comm__semiring__1__class_Onormalizing__semiring__rules_I10_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : ( times_times(A,A2,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_46_Z_Onot__dep__decr,axiom,
    ! [Xsa: list(int),X4: int,A1: atom] :
      ( ( aa(atom,int,hd_coeff,A1) = zero_zero(int) )
     => ( i_Z(A1,cons(int,X4,Xsa))
      <=> i_Z(decr_Z(A1),Xsa) ) ) ).

tff(fact_47_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int] :
          ( ord_less(A,ring_1_of_int(A,Z2),zero_zero(A))
        <=> ord_less(int,Z2,zero_zero(int)) ) ) ).

tff(fact_48_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z2: int,W1: int] :
          ( ( ring_1_of_int(A,W1) = ring_1_of_int(A,Z2) )
        <=> ( W1 = Z2 ) ) ) ).

tff(fact_49_dvd__0__right,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : dvd_dvd(A,A2,zero_zero(A)) ) ).

tff(fact_50_dvd__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [B2: A,C2: A,A1: A] :
          ( dvd_dvd(A,times_times(A,A1,C2),times_times(A,B2,C2))
        <=> ( ( C2 = zero_zero(A) )
            | dvd_dvd(A,A1,B2) ) ) ) ).

tff(fact_51_dvd__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [B2: A,A1: A,C2: A] :
          ( dvd_dvd(A,times_times(A,C2,A1),times_times(A,C2,B2))
        <=> ( ( C2 = zero_zero(A) )
            | dvd_dvd(A,A1,B2) ) ) ) ).

tff(fact_52_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_53_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z2: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z2) )
        <=> ( Z2 = zero_zero(int) ) ) ) ).

tff(fact_54_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z2: int] :
          ( ( ring_1_of_int(A,Z2) = zero_zero(A) )
        <=> ( Z2 = zero_zero(int) ) ) ) ).

tff(fact_55_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int,W1: int] :
          ( ord_less(A,ring_1_of_int(A,W1),ring_1_of_int(A,Z2))
        <=> ord_less(int,W1,Z2) ) ) ).

tff(fact_56_of__int__mult,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Z3: int,W: int] : ( ring_1_of_int(A,times_times(int,W,Z3)) = times_times(A,ring_1_of_int(A,W),ring_1_of_int(A,Z3)) ) ) ).

tff(fact_57_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z2))
        <=> ord_less(int,zero_zero(int),Z2) ) ) ).

tff(fact_58_dvd__trans,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A2: A] :
          ( dvd_dvd(A,A2,B1)
         => ( dvd_dvd(A,B1,C1)
           => dvd_dvd(A,A2,C1) ) ) ) ).

tff(fact_59_dvd__refl,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : dvd_dvd(A,A2,A2) ) ).

tff(fact_60_dvd__0__left,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] :
          ( dvd_dvd(A,zero_zero(A),A2)
         => ( A2 = zero_zero(A) ) ) ) ).

tff(fact_61_dvd__triv__left,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A2: A] : dvd_dvd(A,A2,times_times(A,A2,B1)) ) ).

tff(fact_62_dvd__triv__right,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A2: A] : dvd_dvd(A,A2,times_times(A,B1,A2)) ) ).

tff(fact_63_dvd__mult2,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A2: A] :
          ( dvd_dvd(A,A2,B1)
         => dvd_dvd(A,A2,times_times(A,B1,C1)) ) ) ).

tff(fact_64_dvd__mult,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,C1: A,A2: A] :
          ( dvd_dvd(A,A2,C1)
         => dvd_dvd(A,A2,times_times(A,B1,C1)) ) ) ).

tff(fact_65_mult__dvd__mono,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C1: A,B1: A,A2: A] :
          ( dvd_dvd(A,A2,B1)
         => ( dvd_dvd(A,C1,D1)
           => dvd_dvd(A,times_times(A,A2,C1),times_times(A,B1,D1)) ) ) ) ).

tff(fact_66_dvdI,axiom,
    ! [A: $tType] :
      ( dvd(A)
     => ! [K2: A,B1: A,A2: A] :
          ( ( A2 = times_times(A,B1,K2) )
         => dvd_dvd(A,B1,A2) ) ) ).

tff(fact_67_dvd__mult__left,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A2: A] :
          ( dvd_dvd(A,times_times(A,A2,B1),C1)
         => dvd_dvd(A,A2,C1) ) ) ).

tff(fact_68_dvd__mult__right,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A2: A] :
          ( dvd_dvd(A,times_times(A,A2,B1),C1)
         => dvd_dvd(A,B1,C1) ) ) ).

tff(fact_69_zdvd__not__zless,axiom,
    ! [N: int,M1: int] :
      ( ord_less(int,zero_zero(int),M1)
     => ( ord_less(int,M1,N)
       => ~ dvd_dvd(int,N,M1) ) ) ).

tff(fact_70_zdvd__mult__cancel,axiom,
    ! [N: int,M1: int,K2: int] :
      ( dvd_dvd(int,times_times(int,K2,M1),times_times(int,K2,N))
     => ( ( K2 != zero_zero(int) )
       => dvd_dvd(int,M1,N) ) ) ).

tff(fact_71_dvd__zlcms,axiom,
    ! [Is: list(int),I: int] :
      ( member(int,I,set(int,Is))
     => dvd_dvd(int,I,zlcms(Is)) ) ).

tff(fact_72_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X4: A] :
          ( ( zero_zero(A) = X4 )
        <=> ( X4 = zero_zero(A) ) ) ) ).

tff(fact_73_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F3: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F3,X2) = aa(A,B,G,X2) )
     => ( F3 = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X4: A] :
      ( member(A,X4,A3)
    <=> pp(aa(A,bool,A3,X4)) ) ).

tff(fact_76_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_80_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C1: A,B1: A,A2: A] : ( times_times(A,times_times(A,A2,B1),C1) = times_times(A,A2,times_times(A,B1,C1)) ) ) ).

tff(fact_81_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_82_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A2: A] : ( times_times(A,A2,B1) = times_times(A,B1,A2) ) ) ).

tff(fact_84_zdvd__mono,axiom,
    ! [T1: int,M: int,K1: int] :
      ( ( K1 != zero_zero(int) )
     => ( dvd_dvd(int,M,T1)
      <=> dvd_dvd(int,times_times(int,K1,M),times_times(int,K1,T1)) ) ) ).

tff(fact_85_dvdE,axiom,
    ! [A: $tType] :
      ( dvd(A)
     => ! [A2: A,B1: A] :
          ( dvd_dvd(A,B1,A2)
         => ~ ! [K: A] : ( A2 != times_times(A,B1,K) ) ) ) ).

tff(fact_86_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A1: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A1,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A1),List) ) ).

tff(fact_87_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X3: A] : ( splice(A,cons(A,X3,Xs),cons(A,Y,Ys)) = cons(A,X3,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_88_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P1: fun(A,bool),P: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,Z1,X2)
             => ( pp(aa(A,bool,P,X2))
              <=> pp(aa(A,bool,P1,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,Z1,X2)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,Z,X1)
               => ( ( pp(aa(A,bool,P,X1))
                    | pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P1,X1))
                    | pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_89_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P1: fun(A,bool),P: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,Z1,X2)
             => ( pp(aa(A,bool,P,X2))
              <=> pp(aa(A,bool,P1,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,Z1,X2)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,Z,X1)
               => ( ( pp(aa(A,bool,P,X1))
                    & pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P1,X1))
                    & pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_90_minf_I11_J,axiom,
    ! [C: $tType,D: $tType] :
      ( ord(C)
     => ! [F: D] :
        ? [Z: C] :
        ! [X1: C] :
          ( ord_less(C,X1,Z)
         => ( F = F ) ) ) ).

tff(fact_91_pinf_I11_J,axiom,
    ! [C: $tType,D: $tType] :
      ( ord(C)
     => ! [F: D] :
        ? [Z: C] :
        ! [X1: C] :
          ( ord_less(C,Z,X1)
         => ( F = F ) ) ) ).

tff(fact_92_minf_I2_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P1: fun(A,bool),P: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,X2,Z1)
             => ( pp(aa(A,bool,P,X2))
              <=> pp(aa(A,bool,P1,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,X2,Z1)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,X1,Z)
               => ( ( pp(aa(A,bool,P,X1))
                    | pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P1,X1))
                    | pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_93_minf_I1_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P1: fun(A,bool),P: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,X2,Z1)
             => ( pp(aa(A,bool,P,X2))
              <=> pp(aa(A,bool,P1,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,X2,Z1)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,X1,Z)
               => ( ( pp(aa(A,bool,P,X1))
                    & pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P1,X1))
                    & pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_94_minf_I4_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ( X1 != T ) ) ) ).

tff(fact_95_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ( X1 != T ) ) ) ).

tff(fact_96_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ~ ord_less(A,X1,T) ) ) ).

tff(fact_97_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ( X1 != T ) ) ) ).

tff(fact_98_minf_I7_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ~ ord_less(A,T,X1) ) ) ).

%----Arities (20)
tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__comm__semiring__strict,axiom,
    linord893533164strict(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semiring__strict,axiom,
    linord20386208strict(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring,axiom,
    linordered_ring(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oidom,axiom,
    idom(int) ).

tff(arity_Int_Oint___Rings_Odvd,axiom,
    dvd(int) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( ? [X: int] :
        ! [Xa: atom] :
          ( member(atom,Xa,set(atom,as))
         => i_Z(Xa,cons(int,X,xs)) )
    <=> ~ ? [X: int] :
          ! [Xa: atom] :
            ( member(atom,Xa,set(atom,as))
           => i_Z(hd_coeff1(zlcms(map(atom,int,hd_coeff,as)),Xa),cons(int,times_times(int,zlcms(map(atom,int,hd_coeff,as)),X),xs)) ) ) ).

%------------------------------------------------------------------------------
