%------------------------------------------------------------------------------
% File     : COM026_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 21
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_21 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  154 (  19 unt;  34 typ;   0 def)
%            Number of atoms       :  363 (  63 equ)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives :  282 (  39   ~;   8   |;  13   &)
%                                         (  34 <=>; 188  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   18 (  12   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  17 usr;   0 prp; 1-3 aty)
%            Number of functors    :   14 (  14 usr;   4 con; 0-4 aty)
%            Number of variables   :  354 ( 324   !;   5   ?; 354   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:59
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (29)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: fun(atom,int) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

%----Relevant facts (98)
tff(fact_0__C0_C,axiom,
    ! [X4: atom] :
      ( member(atom,X4,set(atom,as))
     => ( aa(atom,int,hd_coeff,X4) != zero_zero(int) ) ) ).

tff(fact_1_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less(int,zero_zero(int),Z) ) ) ).

tff(fact_2_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less(int,Z,zero_zero(int)) ) ) ).

tff(fact_3_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ~ ord_less(A,X2,X2) ) ).

tff(fact_4_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 != Y1 )
        <=> ( ord_less(A,X1,Y1)
            | ord_less(A,Y1,X1) ) ) ) ).

tff(fact_5_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
        <=> ( ord_less(A,Y1,X1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_6_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
          | ( X2 = Y2 )
          | ord_less(A,Y2,X2) ) ) ).

tff(fact_7_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y1: A] :
          ( ~ ord_less(A,Y1,X1)
         => ( ~ ord_less(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_8_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
         => ( ~ ord_less(A,X2,Y2)
           => ord_less(A,Y2,X2) ) ) ) ).

tff(fact_9_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
         => ( ~ ord_less(A,X2,Y2)
           => ord_less(A,Y2,X2) ) ) ) ).

tff(fact_10_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( X2 != Y2 ) ) ) ).

tff(fact_11_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ~ ord_less(A,Y2,X2) ) ) ).

tff(fact_12_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z) )
        <=> ( W = Z ) ) ) ).

tff(fact_13_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( ring_1_of_int(A,Z) = zero_zero(A) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_14_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_15_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_16_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int,W: int] :
          ( ord_less(A,ring_1_of_int(A,W),ring_1_of_int(A,Z))
        <=> ord_less(int,W,Z) ) ) ).

tff(fact_17_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_18_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less(A,X2,Y2)
         => ( ( X2 != Y2 )
           => ord_less(A,Y2,X2) ) ) ) ).

tff(fact_19_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ~ ord_less(A,Y2,X2) ) ) ).

tff(fact_20_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( ord_less(A,Y2,Z1)
           => ord_less(A,X2,Z1) ) ) ) ).

tff(fact_21_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ( B2 = C1 )
           => ord_less(A,A2,C1) ) ) ) ).

tff(fact_22_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less(A,B2,C1)
           => ord_less(A,A2,C1) ) ) ) ).

tff(fact_23_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ~ ord_less(A,B2,A2) ) ) ).

tff(fact_24_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P: bool,Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( ord_less(A,Y1,X1)
           => pp(P) ) ) ) ).

tff(fact_25_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( Y2 != X2 ) ) ) ).

tff(fact_26_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( X2 != Y2 ) ) ) ).

tff(fact_27_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ~ ord_less(A,Y2,X2) ) ) ).

tff(fact_28_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xsa: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xsa) = map(B,A,G,Xsa) )
    <=> ! [X3: B] :
          ( member(B,X3,set(B,Xsa))
         => ( aa(B,A,F,X3) = aa(B,A,G,X3) ) ) ) ).

tff(fact_29_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F,B1))
         => ( ord_less(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less(B,X,Y)
                 => ord_less(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_30_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ( A1 = aa(B,A,F,B1) )
         => ( ord_less(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less(B,X,Y)
                 => ord_less(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_31_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(B,aa(A,B,F,B1),C)
           => ( ! [X: A,Y: A] :
                  ( ord_less(A,X,Y)
                 => ord_less(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less(B,aa(A,B,F,A1),C) ) ) ) ) ).

tff(fact_32_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ( aa(A,B,F,B1) = C )
           => ( ! [X: A,Y: A] :
                  ( ord_less(A,X,Y)
                 => ord_less(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less(B,aa(A,B,F,A1),C) ) ) ) ) ).

tff(fact_33_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ? [Z2: A] :
              ( ord_less(A,X2,Z2)
              & ord_less(A,Z2,Y2) ) ) ) ).

tff(fact_34_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X2: A] :
        ? [Y: A] : ord_less(A,Y,X2) ) ).

tff(fact_35_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X1: A] :
        ? [X11: A] : ord_less(A,X1,X11) ) ).

tff(fact_36_sgn__less,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,sgn_sgn(A,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_37_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] : ( sgn_sgn(A,sgn_sgn(A,A2)) = sgn_sgn(A,A2) ) ) ).

tff(fact_38_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_39_sgn__greater,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),sgn_sgn(A,A1))
        <=> ord_less(A,zero_zero(A),A1) ) ) ).

tff(fact_40_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_41_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> member(int,zero_zero(int),set(int,Is)) ) ).

tff(fact_42_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys: list(B)] :
      ( ? [Xs: list(A)] : ( Ys = map(A,B,F,Xs) )
    <=> ! [X3: B] :
          ( member(B,X3,set(B,Ys))
         => ? [Xa: A] : ( X3 = aa(A,B,F,Xa) ) ) ) ).

tff(fact_43_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xsa: list(A)] :
      ( ! [X: A] :
          ( member(A,X,set(A,Xsa))
         => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
     => ( map(A,B,F,Xsa) = map(A,B,G,Xsa) ) ) ).

tff(fact_44_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xsa: list(A)] :
      ( ! [X: A] :
          ( member(A,X,set(A,Xsa))
         => ( aa(A,A,F,X) = X ) )
     => ( map(A,A,F,Xsa) = Xsa ) ) ).

tff(fact_45_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X: A] :
            ( member(A,X,set(A,Ys))
           => ( aa(A,B,F,X) = aa(A,B,G,X) ) )
       => ( map(A,B,F,Xsa) = map(A,B,G,Ys) ) ) ) ).

tff(fact_46_zlcms__pos,axiom,
    ! [Is: list(int)] :
      ( ! [X: int] :
          ( member(int,X,set(int,Is))
         => ( X != zero_zero(int) ) )
     => ord_less(int,zero_zero(int),zlcms(Is)) ) ).

tff(fact_47_sgn__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( sgn_sgn(A,A2) = one_one(A) ) ) ) ).

tff(fact_48_sgn__1__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = one_one(A) )
        <=> ord_less(A,zero_zero(A),A1) ) ) ).

tff(fact_49_elem__le__zlcms,axiom,
    ! [I: int,Is: list(int)] :
      ( ! [X: int] :
          ( member(int,X,set(int,Is))
         => ( X != zero_zero(int) ) )
     => ( member(int,I,set(int,Is))
       => ord_less_eq(int,I,zlcms(Is)) ) ) ).

tff(fact_50_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ord_less_eq(A,X2,X2) ) ).

tff(fact_51_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_52_of__int__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int,W: int] :
          ( ord_less_eq(A,ring_1_of_int(A,W),ring_1_of_int(A,Z))
        <=> ord_less_eq(int,W,Z) ) ) ).

tff(fact_53_of__int__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less_eq(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less_eq(int,zero_zero(int),Z) ) ) ).

tff(fact_54_of__int__le__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less_eq(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less_eq(int,Z,zero_zero(int)) ) ) ).

tff(fact_55_less__int__def,axiom,
    ! [W: int,Z: int] :
      ( ord_less(int,Z,W)
    <=> ( ord_less_eq(int,Z,W)
        & ( Z != W ) ) ) ).

tff(fact_56_not__one__le__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less_eq(A,one_one(A),zero_zero(A)) ) ).

tff(fact_57_zero__le__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less_eq(A,zero_zero(A),one_one(A)) ) ).

tff(fact_58_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_59_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X3: A] : ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_60_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
          | ord_less_eq(A,Y2,X2) ) ) ).

tff(fact_61_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 = Y1 )
        <=> ( ord_less_eq(A,X1,Y1)
            & ord_less_eq(A,Y1,X1) ) ) ) ).

tff(fact_62_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 = Y2 )
         => ord_less_eq(A,X2,Y2) ) ) ).

tff(fact_63_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_64_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X1: A,Y1: A] :
          ( ord_less_eq(A,Y1,X1)
         => ( ord_less_eq(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_65_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less_eq(A,B2,C1)
           => ord_less_eq(A,A2,C1) ) ) ) ).

tff(fact_66_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( B2 = C1 )
           => ord_less_eq(A,A2,C1) ) ) ) ).

tff(fact_67_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
         => ( ord_less_eq(A,Y2,X2)
           => ( X2 = Y2 ) ) ) ) ).

tff(fact_68_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
         => ( ord_less_eq(A,Y2,Z1)
           => ord_less_eq(A,X2,Z1) ) ) ) ).

tff(fact_69_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_70_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less_eq(A,X2,Y2)
         => ord_less_eq(A,Y2,X2) ) ) ).

tff(fact_71_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
         => ( ord_less(A,Y2,Z1)
           => ord_less(A,X2,Z1) ) ) ) ).

tff(fact_72_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( ord_less_eq(A,Y2,Z1)
           => ord_less(A,X2,Z1) ) ) ) ).

tff(fact_73_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X1: A] :
      ( member(A,X1,A3)
    <=> pp(aa(A,bool,A3,X1)) ) ).

tff(fact_74_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( A2 != B2 )
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_75_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
         => ( ord_less(A,X2,Y2)
            | ( X2 = Y2 ) ) ) ) ).

tff(fact_76_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ~ ord_less(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_77_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ord_less_eq(A,X2,Y2) ) ) ).

tff(fact_78_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y2: A] :
          ( ord_less_eq(A,Y2,X2)
         => ~ ord_less(A,X2,Y2) ) ) ).

tff(fact_79_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ( A2 != B2 )
         => ( ord_less_eq(A,A2,B2)
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_80_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
         => ( ord_less_eq(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_81_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y2: A] :
          ( ~ ord_less_eq(A,Y2,X2)
         => ord_less(A,X2,Y2) ) ) ).

tff(fact_82_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less(A,X2,Y2)
         => ord_less_eq(A,Y2,X2) ) ) ).

tff(fact_83_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
        <=> ( ord_less(A,X1,Y1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_84_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
        <=> ( ord_less_eq(A,X1,Y1)
            & ~ ord_less_eq(A,Y1,X1) ) ) ) ).

tff(fact_85_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
        <=> ( ord_less_eq(A,X1,Y1)
            & ( X1 != Y1 ) ) ) ) ).

tff(fact_86_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
          | ord_less(A,Y2,X2) ) ) ).

tff(fact_87_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less_eq(A,X1,Y1)
        <=> ord_less(A,Y1,X1) ) ) ).

tff(fact_88_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
        <=> ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_89_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_90_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_91_int__one__le__iff__zero__less,axiom,
    ! [Z: int] :
      ( ord_less_eq(int,one_one(int),Z)
    <=> ord_less(int,zero_zero(int),Z) ) ).

tff(fact_92_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_93_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_94_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less_eq(A,A1,aa(B,A,F,B1))
         => ( ord_less(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less(B,X,Y)
                 => ord_less(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_95_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F,B1))
         => ( ord_less_eq(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_96_order__le__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less(B,aa(A,B,F,B1),C)
           => ( ! [X: A,Y: A] :
                  ( ord_less_eq(A,X,Y)
                 => ord_less_eq(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less(B,aa(A,B,F,A1),C) ) ) ) ) ).

tff(fact_97_order__less__le__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less_eq(B,aa(A,B,F,B1),C)
           => ( ! [X: A,Y: A] :
                  ( ord_less(A,X,Y)
                 => ord_less(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less(B,aa(A,B,F,A1),C) ) ) ) ) ).

%----Arities (19)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ord_less(int,zero_zero(int),zlcms(map(atom,int,hd_coeff,as))) ).

%------------------------------------------------------------------------------
