%------------------------------------------------------------------------------
% File     : COM025_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 19
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_19 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  187 (  54 unt;  55 typ;   0 def)
%            Number of atoms       :  273 ( 113 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  189 (  48   ~;  15   |;  24   &)
%                                         (  28 <=>;  74  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   56 (  32   >;  24   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   39 (  39 usr;   7 con; 0-6 aty)
%            Number of variables   :  412 ( 360   !;   7   ?; 412   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:58
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (49)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_HOL_Oequal,type,
    cl_HOL_Oequal: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_ListVector_Ozipwith0,type,
    zipwith0: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * list(A) * list(B) ) > list(C) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_OdropWhile,type,
    dropWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),fun(T,T))) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oremdups,type,
    remdups: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Odecr_092_060_094isub_062Z,type,
    decr_Z: atom > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Ohd__coeffs1,type,
    qEpres1907640072oeffs1: list(atom) > list(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert1: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),A2: A] :
      ( ( cons(A,A2,List2) = cons(A,A6,List3) )
    <=> ( ( A2 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_1__C0_C,axiom,
    ! [X4: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X4),set(atom,as)))
     => ( hd_coeff(X4) != zero_zero(int) ) ) ).

tff(fact_2_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),X3: A,Y1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,cons(A,X3,Xsa))))
     => ( ( Y1 = X3 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa))) ) ) ).

tff(fact_3_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] : ( Xs != cons(A,X1,Xs) ) ).

tff(fact_4_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( cons(A,X1,Xs) != Xs ) ).

tff(fact_5_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
       => ( insert(A,X3,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
       => ( insert(A,X3,Xsa) = cons(A,X3,Xsa) ) ) ) ).

tff(fact_6_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
     => ( insert(A,X3,Xsa) = cons(A,X3,Xsa) ) ) ).

tff(fact_7_remdups_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
       => ( remdups(A,cons(A,X3,Xsa)) = remdups(A,Xsa) ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
       => ( remdups(A,cons(A,X3,Xsa)) = cons(A,X3,remdups(A,Xsa)) ) ) ) ).

tff(fact_8_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A2,List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List2) ) ).

tff(fact_9_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] : ( set(A,cons(A,X3,Xsa)) = insert1(A,X3,set(A,Xsa)) ) ).

tff(fact_10_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( distinct(A,cons(A,X3,Xsa))
    <=> ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
        & distinct(A,Xsa) ) ) ).

tff(fact_11_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X1: A] : ( splice(A,cons(A,X1,Xs),cons(A,Y,Ys)) = cons(A,X1,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_12_set__remdups,axiom,
    ! [A: $tType,Xsa: list(A)] : ( set(A,remdups(A,Xsa)) = set(A,Xsa) ) ).

tff(fact_13_distinct__remdups,axiom,
    ! [A: $tType,Xs: list(A)] : distinct(A,remdups(A,Xs)) ).

tff(fact_14_remdups__id__iff__distinct,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( remdups(A,Xsa) = Xsa )
    <=> distinct(A,Xsa) ) ).

tff(fact_15_List_Oset__insert,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] : ( set(A,insert(A,X3,Xsa)) = insert1(A,X3,set(A,Xsa)) ) ).

tff(fact_16_remdups__remdups,axiom,
    ! [A: $tType,Xs: list(A)] : ( remdups(A,remdups(A,Xs)) = remdups(A,Xs) ) ).

tff(fact_17_insert__remdups,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( insert(A,X1,remdups(A,Xs)) = remdups(A,insert(A,X1,Xs)) ) ).

tff(fact_18_distinct__insert,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] :
      ( distinct(A,Xs)
     => distinct(A,insert(A,X1,Xs)) ) ).

tff(fact_19_distinct__remdups__id,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( distinct(A,Xs)
     => ( remdups(A,Xs) = Xs ) ) ).

tff(fact_20_distinct__length__2__or__more,axiom,
    ! [A: $tType,Xsa: list(A),B2: A,A2: A] :
      ( distinct(A,cons(A,A2,cons(A,B2,Xsa)))
    <=> ( ( A2 != B2 )
        & distinct(A,cons(A,A2,Xsa))
        & distinct(A,cons(A,B2,Xsa)) ) ) ).

tff(fact_21_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
     => ( insert(A,X3,Xsa) = Xsa ) ) ).

tff(fact_22_insert__absorb2,axiom,
    ! [A: $tType,A3: fun(A,bool),X3: A] : ( insert1(A,X3,insert1(A,X3,A3)) = insert1(A,X3,A3) ) ).

tff(fact_23_insert__iff,axiom,
    ! [A: $tType,A3: fun(A,bool),B2: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert1(A,B2,A3)))
    <=> ( ( A2 = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A3)) ) ) ).

tff(fact_24_insertE,axiom,
    ! [A: $tType,A3: fun(A,bool),B2: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert1(A,B2,A3)))
     => ( ( A2 != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A3)) ) ) ).

tff(fact_25_insertCI,axiom,
    ! [A: $tType,B2: A,B4: fun(A,bool),A2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B4))
       => ( A2 = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert1(A,B2,B4))) ) ).

tff(fact_26_Z_Onot__dep__decr,axiom,
    ! [Xsa: list(int),X3: int,A2: atom] :
      ( ( hd_coeff(A2) = zero_zero(int) )
     => ( i_Z(A2,cons(int,X3,Xsa))
      <=> i_Z(decr_Z(A2),Xsa) ) ) ).

tff(fact_27_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A2: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,A2,List2)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A2),List2),list_rec(A,B,F1,F2,List2)) ) ).

tff(fact_28_insertI1,axiom,
    ! [A: $tType,B4: fun(A,bool),A2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert1(A,A2,B4))) ).

tff(fact_29_insert__compr,axiom,
    ! [A: $tType,B4: fun(A,bool),A2: A] : ( insert1(A,A2,B4) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A2)),combc(A,fun(A,bool),bool,member(A),B4))) ) ).

tff(fact_30_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X3: A] :
          ( ( zero_zero(A) = X3 )
        <=> ( X3 = zero_zero(A) ) ) ) ).

tff(fact_31_insert__absorb,axiom,
    ! [A: $tType,A3: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A3))
     => ( insert1(A,A2,A3) = A3 ) ) ).

tff(fact_32_insertI2,axiom,
    ! [A: $tType,B2: A,B4: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B4))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert1(A,B2,B4))) ) ).

tff(fact_33_insert__eq__iff,axiom,
    ! [A: $tType,B4: fun(A,bool),B2: A,A3: fun(A,bool),A2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A3))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B4))
       => ( ( insert1(A,A2,A3) = insert1(A,B2,B4) )
        <=> ( ( ( A2 = B2 )
             => ( A3 = B4 ) )
            & ( ( A2 != B2 )
             => ? [C3: fun(A,bool)] :
                  ( ( A3 = insert1(A,B2,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C3))
                  & ( B4 = insert1(A,A2,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),C3)) ) ) ) ) ) ) ).

tff(fact_34_insert__ident,axiom,
    ! [A: $tType,B4: fun(A,bool),A3: fun(A,bool),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A3))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B4))
       => ( ( insert1(A,X3,A3) = insert1(A,X3,B4) )
        <=> ( A3 = B4 ) ) ) ) ).

tff(fact_35_insert__code,axiom,
    ! [A: $tType,X3: A,A3: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert1(A,Y1,A3),X3))
    <=> ( ( Y1 = X3 )
        | pp(aa(A,bool,A3,X3)) ) ) ).

tff(fact_36_insert__commute,axiom,
    ! [A: $tType,A3: fun(A,bool),Y1: A,X3: A] : ( insert1(A,X3,insert1(A,Y1,A3)) = insert1(A,Y1,insert1(A,X3,A3)) ) ).

tff(fact_37_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A2: A] : ( insert1(A,A2,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A2))),P1)) ) ).

tff(fact_38_Set_Oset__insert,axiom,
    ! [A: $tType,A3: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A3))
     => ~ ! [B3: fun(A,bool)] :
            ( ( A3 = insert1(A,X3,B3) )
           => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B3)) ) ) ).

tff(fact_39_mk__disjoint__insert,axiom,
    ! [A: $tType,A3: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A3))
     => ? [B3: fun(A,bool)] :
          ( ( A3 = insert1(A,A2,B3) )
          & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B3)) ) ) ).

tff(fact_40_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_41_Z_Oanormal__decr,axiom,
    ! [A1: atom] :
      ( ( hd_coeff(A1) = zero_zero(int) )
     => ( ( divisor(A1) != zero_zero(int) )
       => ( divisor(decr_Z(A1)) != zero_zero(int) ) ) ) ).

tff(fact_42_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_43_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ~ null(A,cons(A,X1,Xs)) ).

tff(fact_44_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : distinct(A,nil(A)) ).

tff(fact_45_remdups_Osimps_I1_J,axiom,
    ! [A: $tType] : ( remdups(A,nil(A)) = nil(A) ) ).

tff(fact_46_remdups__eq__nil__right__iff,axiom,
    ! [A: $tType,X3: list(A)] :
      ( ( nil(A) = remdups(A,X3) )
    <=> ( X3 = nil(A) ) ) ).

tff(fact_47_remdups__eq__nil__iff,axiom,
    ! [A: $tType,X3: list(A)] :
      ( ( remdups(A,X3) = nil(A) )
    <=> ( X3 = nil(A) ) ) ).

tff(fact_48_eq__Nil__null,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa = nil(A) )
    <=> null(A,Xsa) ) ).

tff(fact_49_List_Onull__def,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( null(A,Xsa)
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_50_null__rec_I2_J,axiom,
    ! [B: $tType] : null(B,nil(B)) ).

tff(fact_51_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_52_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_53_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_54_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_55_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_56_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_57_distinct__singleton,axiom,
    ! [A: $tType,X1: A] : distinct(A,cons(A,X1,nil(A))) ).

tff(fact_58_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_59_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys2: list(A)] : ( Xsa = cons(A,Y2,Ys2) ) ) ).

tff(fact_60_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List: list(A)] : ( Y != cons(A,A4,List) ) ) ).

tff(fact_61_equal__Nil__null,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),Xsa),nil(A)))
    <=> null(A,Xsa) ) ).

tff(fact_62_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_63_equal__list__def,axiom,
    ! [A: $tType,Y1: list(A),X3: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),X3),Y1))
    <=> ( X3 = Y1 ) ) ).

tff(fact_64_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
          & pp(aa(A,bool,P1,X))
          & ! [Y2: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa)))
                & pp(aa(A,bool,P1,Y2)) )
             => ( Y2 = X ) ) ) ) ).

tff(fact_65_sublist__singleton,axiom,
    ! [A: $tType,X3: A,A3: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A3))
       => ( sublist(A,cons(A,X3,nil(A)),A3) = cons(A,X3,nil(A)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A3))
       => ( sublist(A,cons(A,X3,nil(A)),A3) = nil(A) ) ) ) ).

tff(fact_66_list__nonempty__induct,axiom,
    ! [A: $tType,P1: fun(list(A),bool),Xsa: list(A)] :
      ( ( Xsa != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,P1,cons(A,X2,nil(A))))
       => ( ! [X2: A,Xs1: list(A)] :
              ( ( Xs1 != nil(A) )
             => ( pp(aa(list(A),bool,P1,Xs1))
               => pp(aa(list(A),bool,P1,cons(A,X2,Xs1))) ) )
         => pp(aa(list(A),bool,P1,Xsa)) ) ) ) ).

tff(fact_67_zipwith0_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys1: list(C),Y1: C,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),cons(C,Y1,Ys1)) = cons(A,aa(C,A,aa(B,fun(C,A),F,zero_zero(B)),Y1),zipwith0(B,C,A,F,nil(B),Ys1)) ) ) ).

tff(fact_68_sublist__nil,axiom,
    ! [A: $tType,A3: fun(nat,bool)] : ( sublist(A,nil(A),A3) = nil(A) ) ).

tff(fact_69_zipwith0_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Ys1: list(C),Y1: C,Xsa: list(B),X3: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X3,Xsa),cons(C,Y1,Ys1)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X3),Y1),zipwith0(B,C,A,F,Xsa,Ys1)) ) ) ).

tff(fact_70_zipwith0_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( zero(B)
        & zero(C) )
     => ! [F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,nil(B),nil(C)) = nil(A) ) ) ).

tff(fact_71_zipwith0_Osimps_I3_J,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( zero(C)
        & zero(B) )
     => ! [Xsa: list(B),X3: B,F: fun(B,fun(C,A))] : ( zipwith0(B,C,A,F,cons(B,X3,Xsa),nil(C)) = cons(A,aa(C,A,aa(B,fun(C,A),F,X3),zero_zero(C)),zipwith0(B,C,A,F,Xsa,nil(C))) ) ) ).

tff(fact_72_notin__set__sublistI,axiom,
    ! [A: $tType,I2: fun(nat,bool),Xsa: list(A),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,sublist(A,Xsa,I2)))) ) ).

tff(fact_73_in__set__sublistD,axiom,
    ! [A: $tType,I2: fun(nat,bool),Xsa: list(A),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,sublist(A,Xsa,I2))))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xsa))) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A3))
    <=> pp(aa(A,bool,A3,X3)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_distinct__sublistI,axiom,
    ! [A: $tType,I2: fun(nat,bool),Xsa: list(A)] :
      ( distinct(A,Xsa)
     => distinct(A,sublist(A,Xsa,I2)) ) ).

tff(fact_78_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_79_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( iprod(A,nil(A),Ys) = zero_zero(A) ) ) ).

tff(fact_80_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( iprod(A,Xs,nil(A)) = zero_zero(A) ) ) ).

tff(fact_81_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X2: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Cs)))
             => ( X2 = zero_zero(A) ) )
         => ( iprod(A,Cs,Xsa) = zero_zero(A) ) ) ) ).

tff(fact_82_eq__equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( fequal(A) = equal_equal(A) ) ) ).

tff(fact_83_equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( equal_equal(A) = fequal(A) ) ) ).

tff(fact_84_equal__refl,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [X1: A] : pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X1),X1)) ) ).

tff(fact_85_equal__eq,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [Y1: A,X3: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X3),Y1))
        <=> ( X3 = Y1 ) ) ) ).

tff(fact_86_dropWhile__eq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( dropWhile(A,P1,Xsa) = nil(A) )
    <=> ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),set(A,Xsa)))
         => pp(aa(A,bool,P1,X)) ) ) ).

tff(fact_87_divisor__asubst,axiom,
    ! [A1: atom,Ks1: list(int),I1: int] : ( divisor(asubst(I1,Ks1,A1)) = divisor(A1) ) ).

tff(fact_88_dropWhile_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),X3: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,X3))
       => ( dropWhile(A,P1,cons(A,X3,Xsa)) = dropWhile(A,P1,Xsa) ) )
      & ( ~ pp(aa(A,bool,P1,X3))
       => ( dropWhile(A,P1,cons(A,X3,Xsa)) = cons(A,X3,Xsa) ) ) ) ).

tff(fact_89_dropWhile_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( dropWhile(A,P1,nil(A)) = nil(A) ) ).

tff(fact_90_distinct__dropWhile,axiom,
    ! [A: $tType,P1: fun(A,bool),Xsa: list(A)] :
      ( distinct(A,Xsa)
     => distinct(A,dropWhile(A,P1,Xsa)) ) ).

tff(fact_91_dropWhile__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),K: list(A),L: list(A)] :
      ( ( L = K )
     => ( ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,L)))
           => ( pp(aa(A,bool,P1,X2))
            <=> pp(aa(A,bool,Q1,X2)) ) )
       => ( dropWhile(A,P1,L) = dropWhile(A,Q1,K) ) ) ) ).

tff(fact_92_IZ__asubst,axiom,
    ! [Xsa: list(int),A2: atom,Ks: list(int),I: int] :
      ( i_Z(asubst(I,Ks,A2),Xsa)
    <=> i_Z(A2,cons(int,plus_plus(int,I,iprod(int,Ks,Xsa)),Xsa)) ) ).

tff(fact_93_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A2: A,B2: A] :
          ( ( plus_plus(A,B2,A2) = plus_plus(A,C2,A2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_94_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_95_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_96_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X1: A] : ( plus_plus(list(A),cons(A,X1,Xs),cons(A,Y,Ys)) = cons(A,plus_plus(A,X1,Y),plus_plus(list(A),Xs,Ys)) ) ) ).

tff(fact_97_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( iprod(A,plus_plus(list(A),Xs,Ys),Zs) = plus_plus(A,iprod(A,Xs,Zs),iprod(A,Ys,Zs)) ) ) ).

tff(fact_98_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C1,A1) )
         => ( B1 = C1 ) ) ) ).

%----Arities (17)
tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_fun___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( cl_HOL_Oequal(T_2)
        & enum(T_1) )
     => cl_HOL_Oequal(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___HOL_Oequal,axiom,
    cl_HOL_Oequal(int) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oplus,axiom,
    cl_Groups_Oplus(nat) ).

tff(arity_Nat_Onat___HOL_Oequal,axiom,
    cl_HOL_Oequal(nat) ).

tff(arity_HOL_Obool___HOL_Oequal,axiom,
    cl_HOL_Oequal(bool) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

tff(arity_List_Olist___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(list(T_1)) ).

tff(arity_PresArith_Oatom___HOL_Oequal,axiom,
    cl_HOL_Oequal(atom) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y))
      | ( X1 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ( X1 != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ~ ( ? [X: int] :
        ! [Xa: atom] :
          ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa),set(atom,qEpres1907640072oeffs1(as))))
         => i_Z(Xa,cons(int,X,xs)) )
    <=> ~ ? [X: int] :
          ! [Xa: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa),set(atom,as)))
           => i_Z(Xa,cons(int,X,xs)) ) ) ).

%------------------------------------------------------------------------------
