%------------------------------------------------------------------------------
% File     : ANA024-1 : TPTP v9.2.0. Released v3.2.0.
% Domain   : Analysis
% Problem  : Problem about Big-O notation
% Version  : [Pau06] axioms : Especial.
% English  :

% Refs     : [Pau06] Paulson (2006), Email to G. Sutcliffe
% Source   : [Pau06]
% Names    : BigO__bigo_lesso2_simpler_2 [Pau06]

% Status   : Unsatisfiable
% Rating   : 0.36 v9.1.0, 0.40 v8.2.0, 0.43 v8.1.0, 0.42 v7.5.0, 0.47 v7.4.0, 0.53 v7.3.0, 0.50 v7.2.0, 0.42 v7.1.0, 0.33 v7.0.0, 0.47 v6.4.0, 0.53 v6.3.0, 0.45 v6.2.0, 0.50 v6.1.0, 0.79 v6.0.0, 0.70 v5.5.0, 0.95 v5.4.0, 0.85 v5.3.0, 0.89 v5.2.0, 0.81 v5.1.0, 0.88 v5.0.0, 0.86 v4.1.0, 0.85 v4.0.1, 0.82 v3.7.0, 0.70 v3.5.0, 0.73 v3.4.0, 0.75 v3.3.0, 0.86 v3.2.0
% Syntax   : Number of clauses     : 2809 ( 649 unt; 249 nHn;1987 RR)
%            Number of literals    : 6176 (1289 equ;3178 neg)
%            Maximal clause size   :    7 (   2 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of predicates  :   87 (  86 usr;   0 prp; 1-3 aty)
%            Number of functors    :  239 ( 239 usr;  46 con; 0-18 aty)
%            Number of variables   : 5879 (1184 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments : The problems in the [Pau06] collection each have very many axioms,
%            of which only a small selection are required for the refutation.
%            The mission is to find those few axioms, after which a refutation
%            can be quite easily found.
%------------------------------------------------------------------------------
include('Axioms/ANA003-0.ax').
include('Axioms/MSC001-1.ax').
include('Axioms/MSC001-0.ax').
%------------------------------------------------------------------------------
cnf(cls_OrderedGroup_Ocompare__rls__10_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | V_a = c_plus(c_minus(V_a,V_b,T_a),V_b,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__10_1,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_minus(c_plus(V_c,V_b,T_a),V_b,T_a) = V_c ) ).

cnf(cls_OrderedGroup_Ocompare__rls__11_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_plus(c_minus(V_c,V_b,T_a),V_b,T_a) = V_c ) ).

cnf(cls_OrderedGroup_Ocompare__rls__11_1,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | V_a = c_minus(c_plus(V_a,V_b,T_a),V_b,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__1_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_plus(V_a,c_uminus(V_b,T_a),T_a) = c_minus(V_a,V_b,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__2_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_plus(V_a,c_minus(V_b,V_c,T_a),T_a) = c_minus(c_plus(V_a,V_b,T_a),V_c,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__3_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_plus(c_minus(V_a,V_b,T_a),V_c,T_a) = c_minus(c_plus(V_a,V_c,T_a),V_b,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__4_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_minus(c_minus(V_a,V_b,T_a),V_c,T_a) = c_minus(V_a,c_plus(V_b,V_c,T_a),T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__5_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_minus(V_a,c_minus(V_b,V_c,T_a),T_a) = c_minus(c_plus(V_a,V_c,T_a),V_b,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__6_0,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_less(c_minus(V_a,V_b,T_a),V_c,T_a)
    | c_less(V_a,c_plus(V_c,V_b,T_a),T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__6_1,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_less(V_a,c_plus(V_c,V_b,T_a),T_a)
    | c_less(c_minus(V_a,V_b,T_a),V_c,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__7_0,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_less(V_a,c_minus(V_c,V_b,T_a),T_a)
    | c_less(c_plus(V_a,V_b,T_a),V_c,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__7_1,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_less(c_plus(V_a,V_b,T_a),V_c,T_a)
    | c_less(V_a,c_minus(V_c,V_b,T_a),T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__8_0,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_lessequals(c_minus(V_a,V_b,T_a),V_c,T_a)
    | c_lessequals(V_a,c_plus(V_c,V_b,T_a),T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__8_1,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_lessequals(V_a,c_plus(V_c,V_b,T_a),T_a)
    | c_lessequals(c_minus(V_a,V_b,T_a),V_c,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__9_0,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_lessequals(V_a,c_minus(V_c,V_b,T_a),T_a)
    | c_lessequals(c_plus(V_a,V_b,T_a),V_c,T_a) ) ).

cnf(cls_OrderedGroup_Ocompare__rls__9_1,axiom,
    ( ~ class_OrderedGroup_Opordered__ab__group__add(T_a)
    | ~ c_lessequals(c_plus(V_a,V_b,T_a),V_c,T_a)
    | c_lessequals(V_a,c_minus(V_c,V_b,T_a),T_a) ) ).

cnf(cls_SetsAndFunctions_Oset__one__times_0,axiom,
    ( ~ class_OrderedGroup_Ocomm__monoid__mult(T_a)
    | c_SetsAndFunctions_Oelt__set__times(c_1,V_y,T_a) = V_y ) ).

cnf(cls_SetsAndFunctions_Oset__zero__plus_0,axiom,
    ( ~ class_OrderedGroup_Ocomm__monoid__add(T_a)
    | c_SetsAndFunctions_Oelt__set__plus(c_0,V_y,T_a) = V_y ) ).

cnf(cls_OrderedGroup_Oab__group__add__class_Odiff__minus_0,axiom,
    ( ~ class_OrderedGroup_Oab__group__add(T_a)
    | c_minus(V_a,V_b,T_a) = c_plus(V_a,c_uminus(V_b,T_a),T_a) ) ).

cnf(cls_Orderings_Olinorder__not__le_0,axiom,
    ( ~ class_Orderings_Olinorder(T_a)
    | c_less(V_y,V_x,T_a)
    | c_lessequals(V_x,V_y,T_a) ) ).

cnf(cls_Orderings_Olinorder__not__le_1,axiom,
    ( ~ class_Orderings_Olinorder(T_a)
    | ~ c_less(V_y,V_x,T_a)
    | ~ c_lessequals(V_x,V_y,T_a) ) ).

cnf(cls_Orderings_Oorder__class_Oorder__trans_0,axiom,
    ( ~ class_Orderings_Oorder(T_a)
    | ~ c_lessequals(V_y,V_z,T_a)
    | ~ c_lessequals(V_x,V_y,T_a)
    | c_lessequals(V_x,V_z,T_a) ) ).

cnf(cls_Orderings_Oorder__less__imp__le_0,axiom,
    ( ~ class_Orderings_Oorder(T_a)
    | ~ c_less(V_x,V_y,T_a)
    | c_lessequals(V_x,V_y,T_a) ) ).

cnf(cls_conjecture_0,negated_conjecture,
    c_lessequals(c_0,v_k(V_U),t_b) ).

cnf(cls_conjecture_1,negated_conjecture,
    c_lessequals(v_k(V_U),v_f(V_U),t_b) ).

cnf(cls_conjecture_2,negated_conjecture,
    c_lessequals(c_0,c_minus(v_k(v_x),v_g(v_x),t_b),t_b) ).

cnf(cls_conjecture_3,negated_conjecture,
    ~ c_lessequals(c_minus(v_k(v_x),v_g(v_x),t_b),c_minus(v_f(v_x),v_g(v_x),t_b),t_b) ).

cnf(tfree_tcs,negated_conjecture,
    class_Ring__and__Field_Oordered__idom(t_b) ).

%------------------------------------------------------------------------------
