%------------------------------------------------------------------------------
% File     : ANA012-2 : TPTP v9.2.0. Released v3.2.0.
% Domain   : Analysis
% Problem  : Problem about Big-O notation
% Version  : [Pau06] axioms : Reduced > Especial.
% English  :

% Refs     : [Pau06] Paulson (2006), Email to G. Sutcliffe
% Source   : [Pau06]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.09 v9.1.0, 0.05 v9.0.0, 0.10 v8.1.0, 0.00 v7.5.0, 0.05 v7.4.0, 0.06 v7.3.0, 0.08 v7.1.0, 0.00 v7.0.0, 0.13 v6.4.0, 0.07 v6.3.0, 0.09 v6.2.0, 0.00 v6.1.0, 0.14 v6.0.0, 0.00 v5.5.0, 0.05 v5.4.0, 0.10 v5.3.0, 0.11 v5.2.0, 0.06 v5.0.0, 0.00 v4.1.0, 0.08 v4.0.1, 0.09 v4.0.0, 0.00 v3.3.0, 0.07 v3.2.0
% Syntax   : Number of clauses     :    9 (   3 unt;   1 nHn;   7 RR)
%            Number of literals    :   17 (   5 equ;   9 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-3 aty)
%            Number of functors    :    7 (   7 usr;   4 con; 0-3 aty)
%            Number of variables   :   10 (   1 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments : The problems in the [Pau06] collection each have very many axioms,
%            of which only a small selection are required for the refutation.
%            The mission is to find those few axioms, after which a refutation
%            can be quite easily found. This version has only the necessary
%            axioms.
%------------------------------------------------------------------------------
cnf(cls_conjecture_0,negated_conjecture,
    v_c != c_0 ).

cnf(cls_conjecture_1,negated_conjecture,
    ~ c_lessequals(c_1,c_times(V_U,c_HOL_Oabs(v_c,t_a),t_a),t_a) ).

cnf(tfree_tcs,negated_conjecture,
    class_Ring__and__Field_Oordered__field(t_a) ).

cnf(cls_OrderedGroup_Oabs__eq__0_0,axiom,
    ( ~ class_OrderedGroup_Olordered__ab__group__abs(T_a)
    | c_HOL_Oabs(V_a,T_a) != c_0
    | V_a = c_0 ) ).

cnf(cls_Orderings_Oorder__class_Oaxioms__1_0,axiom,
    ( ~ class_Orderings_Oorder(T_a)
    | c_lessequals(V_x,V_x,T_a) ) ).

cnf(cls_Ring__and__Field_Ofield__class_Oaxioms__1_0,axiom,
    ( ~ class_Ring__and__Field_Ofield(T_a)
    | V_a = c_0
    | c_times(c_HOL_Oinverse(V_a,T_a),V_a,T_a) = c_1 ) ).

cnf(clsrel_Ring__and__Field_Oordered__field_0,axiom,
    ( ~ class_Ring__and__Field_Oordered__field(T)
    | class_Ring__and__Field_Ofield(T) ) ).

cnf(clsrel_Ring__and__Field_Oordered__field_47,axiom,
    ( ~ class_Ring__and__Field_Oordered__field(T)
    | class_OrderedGroup_Olordered__ab__group__abs(T) ) ).

cnf(clsrel_Ring__and__Field_Oordered__field_58,axiom,
    ( ~ class_Ring__and__Field_Oordered__field(T)
    | class_Orderings_Oorder(T) ) ).

%------------------------------------------------------------------------------
