%--------------------------------------------------------------------------
% File     : ANA004-5 : TPTP v9.2.0. Released v1.0.0.
% Domain   : Analysis
% Problem  : Lemma 2 for the sum of two continuous functions is continuous
% Version  : [Ble90] axioms : Incomplete.
% English  : A lemma formed by adding in some resolvants and taking out
%            the corresponding clauses.

% Refs     : [Ble90] Bledsoe (1990), Challenge Problems in Elementary Calcu
%          : [Ble92] Bledsoe (1992), Email to G. Sutcliffe
% Source   : [Ble92]
% Names    : Problem 3 [Ble90]
%          : p3.lop [SETHEO]

% Status   : Unsatisfiable
% Rating   : 0.85 v9.1.0, 0.82 v9.0.0, 0.83 v8.2.0, 0.57 v8.1.0, 0.43 v7.5.0, 0.67 v7.3.0, 0.83 v7.0.0, 0.88 v6.4.0, 0.75 v6.3.0, 0.71 v6.2.0, 0.78 v6.1.0, 0.86 v5.5.0, 1.00 v5.4.0, 0.90 v5.3.0, 1.00 v5.2.0, 0.90 v5.1.0, 0.91 v5.0.0, 0.93 v4.1.0, 0.88 v4.0.1, 0.80 v4.0.0, 0.71 v3.4.0, 0.50 v3.3.0, 0.33 v3.2.0, 0.67 v3.1.0, 0.50 v2.7.0, 0.75 v2.6.0, 1.00 v2.0.0
% Syntax   : Number of clauses     :   16 (   4 unt;   4 nHn;  11 RR)
%            Number of literals    :   32 (   0 equ;  13 neg)
%            Maximal clause size   :    3 (   2 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :    1 (   1 usr;   0 prp; 2-2 aty)
%            Number of functors    :   13 (  13 usr;   3 con; 0-2 aty)
%            Number of variables   :   27 (   2 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments : Based on the theorem in calculus that the sum of two continuous
%            functions is continuous.
%          : [TUM] provided some input to this problem.
%--------------------------------------------------------------------------
%----|X + Y| <= |X| + |Y|.
%----Clause 8
cnf(absolute_sum_less_or_equal_sum_of_absolutes1,axiom,
    less_or_equal(absolute(add(X,Y)),add(absolute(X),absolute(Y))) ).

%----Clause 9.1
cnf(minimum2,axiom,
    less_or_equal(minimum(X,Y),X) ).

%----Clause 9.2
cnf(minimum4,axiom,
    ( ~ less_or_equal(X,Y)
    | less_or_equal(X,minimum(X,Y)) ) ).

%----Clause 10.1
cnf(minimum6,axiom,
    less_or_equal(minimum(X,Y),Y) ).

%----Clause 10.2
cnf(minimum8,axiom,
    ( ~ less_or_equal(Y,X)
    | less_or_equal(Y,minimum(X,Y)) ) ).

%----Clause 11.3
cnf(less_or_equal_sum_of_halves,axiom,
    ( ~ less_or_equal(X,half(Z))
    | ~ less_or_equal(Y,half(Z))
    | less_or_equal(add(X,Y),Z) ) ).

%----Clause 12
cnf(zero_and_half,axiom,
    ( less_or_equal(X,n0)
    | ~ less_or_equal(half(X),n0) ) ).

%----Clause 14
cnf(commutativity_of_less_or_equal,axiom,
    ( less_or_equal(X,Y)
    | less_or_equal(Y,X) ) ).

%----Clause 15
cnf(transitivity_of_less_or_equal,axiom,
    ( ~ less_or_equal(X,Y)
    | ~ less_or_equal(Y,Z)
    | less_or_equal(X,Z) ) ).

%----Clause 15.1 omitted - it's the same as Clause 15

%----Clause 1
cnf(clause_1,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(delta_1(Epsilon),n0) ) ).

%----Clause 2
cnf(clause_2,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(delta_2(Epsilon),n0) ) ).

%----Clause 3
cnf(clause_3,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(absolute(add(Z,negate(a_real_number))),delta_1(Epsilon))
    | less_or_equal(absolute(add(f(Z),negate(f(a_real_number)))),Epsilon) ) ).

%----Clause 4
cnf(clause_4,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(absolute(add(Z,negate(a_real_number))),delta_2(Epsilon))
    | less_or_equal(absolute(add(g(Z),negate(g(a_real_number)))),Epsilon) ) ).

%----Clause 5
cnf(clause_5,hypothesis,
    ~ less_or_equal(epsilon_0,n0) ).

%----Clause 6
cnf(clause_6,hypothesis,
    ( less_or_equal(Delta,n0)
    | less_or_equal(absolute(add(xs(Delta),negate(a_real_number))),Delta) ) ).

%----Clause 7_1
cnf(clause_7_1,negated_conjecture,
    ( less_or_equal(Delta,n0)
    | ~ less_or_equal(absolute(add(add(f(xs(Delta)),negate(f(a_real_number))),add(g(xs(Delta)),negate(g(a_real_number))))),epsilon_0) ) ).

%--------------------------------------------------------------------------
