%--------------------------------------------------------------------------
% File     : ANA004-3 : TPTP v9.2.0. Released v1.0.0.
% Domain   : Analysis
% Problem  : Lemma 2 for the sum of two continuous functions is continuous
% Version  : [Ble90] axioms : Incomplete > Augmented > Complete.
% English  : A lemma formed by adding in some resolvants and taking out
%            the corresponding clauses.

% Refs     : [Ble90] Bledsoe (1990), Challenge Problems in Elementary Calcu
%          : [Ble92] Bledsoe (1992), Email to G. Sutcliffe
% Source   : [TPTP]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.95 v9.1.0, 0.90 v8.2.0, 0.95 v8.1.0, 0.89 v7.5.0, 0.95 v7.4.0, 0.88 v7.3.0, 0.83 v7.0.0, 1.00 v6.3.0, 0.91 v6.2.0, 0.90 v6.1.0, 1.00 v5.0.0, 0.93 v4.1.0, 1.00 v4.0.0, 0.91 v3.7.0, 0.90 v3.5.0, 0.91 v3.4.0, 0.92 v3.3.0, 1.00 v2.0.0
% Syntax   : Number of clauses     :   33 (  12 unt;   5 nHn;  19 RR)
%            Number of literals    :   60 (   6 equ;  23 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 2-2 aty)
%            Number of functors    :   13 (  13 usr;   3 con; 0-2 aty)
%            Number of variables   :   67 (   4 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments : Based on the theorem in calculus that the sum of two continuous
%            functions is continuous.
%          : [TUM] provided some input to this problem.
%--------------------------------------------------------------------------
%----Include axioms for limits
include('Axioms/ANA002-0.ax').
%--------------------------------------------------------------------------
%----Clause 1
cnf(clause_1,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(delta_1(Epsilon),n0) ) ).

%----Clause 2
cnf(clause_2,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(delta_2(Epsilon),n0) ) ).

%----Clause 3
cnf(clause_3,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(absolute(add(Z,negate(a_real_number))),delta_1(Epsilon))
    | less_or_equal(absolute(add(f(Z),negate(f(a_real_number)))),Epsilon) ) ).

%----Clause 4
cnf(clause_4,hypothesis,
    ( less_or_equal(Epsilon,n0)
    | ~ less_or_equal(absolute(add(Z,negate(a_real_number))),delta_2(Epsilon))
    | less_or_equal(absolute(add(g(Z),negate(g(a_real_number)))),Epsilon) ) ).

%----Clause 5
cnf(clause_5,hypothesis,
    ~ less_or_equal(epsilon_0,n0) ).

%----Clause 6
cnf(clause_6,hypothesis,
    ( less_or_equal(Delta,n0)
    | less_or_equal(absolute(add(xs(Delta),negate(a_real_number))),Delta) ) ).

%----Clause 7_1
cnf(clause_7_1,negated_conjecture,
    ( less_or_equal(Delta,n0)
    | ~ less_or_equal(absolute(add(add(f(xs(Delta)),negate(f(a_real_number))),add(g(xs(Delta)),negate(g(a_real_number))))),epsilon_0) ) ).

%--------------------------------------------------------------------------
