%--------------------------------------------------------------------------
% File     : ALG002-1 : TPTP v9.2.0. Released v1.0.0.
% Domain   : General Algebra
% Problem  : In an ordered field, if X > 0 then X^-1 > 0
% Version  : [FL+74] axioms.
% English  :

% Refs     : [FL+74] Fleisig et al. (1974), An Implementation of the Model
%          : [WM76]  Wilson & Minker (1976), Resolution, Refinements, and S
% Source   : [SPRFN]
% Names    : Example 5 [FL+74]
%          : EX5-T? [WM76]
%          : ex5.lop [SETHEO]
%          : FEX5 [SPRFN]

% Status   : Unsatisfiable
% Rating   : 0.00 v8.1.0, 0.17 v7.0.0, 0.12 v6.3.0, 0.14 v6.2.0, 0.00 v2.0.0
% Syntax   : Number of clauses     :   14 (   4 unt;   2 nHn;  11 RR)
%            Number of literals    :   28 (   0 equ;  15 neg)
%            Maximal clause size   :    4 (   2 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of predicates  :    2 (   2 usr;   0 prp; 1-3 aty)
%            Number of functors    :    5 (   5 usr;   3 con; 0-1 aty)
%            Number of variables   :   23 (   1 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
%--------------------------------------------------------------------------
cnf(right_identity,axiom,
    product(X,multiplicative_identity,X) ).

cnf(not_abelian,axiom,
    ~ product(multiplicative_identity,multiplicative_identity,additive_identity) ).

cnf(product_of_inverses1,axiom,
    ( ~ product(X,Y,Z)
    | product(additive_inverse(X),additive_inverse(Y),Z) ) ).

cnf(product_of_inverses2,axiom,
    ( product(X,Y,Z)
    | ~ product(additive_inverse(X),additive_inverse(Y),Z) ) ).

cnf(product_to_inverse,axiom,
    ( ~ product(X,Y,Z)
    | product(X,additive_inverse(Y),additive_inverse(Z)) ) ).

cnf(inverse_and_identity,axiom,
    ( product(X,multiplicative_inverse(X),multiplicative_identity)
    | product(X,X,additive_identity) ) ).

cnf(inverse_greater_than_0,axiom,
    ( ~ greater_than_0(X)
    | ~ greater_than_0(additive_inverse(X)) ) ).

cnf(greater_than_0_square,axiom,
    ( ~ greater_than_0(X)
    | ~ product(X,X,additive_identity) ) ).

cnf(commutativity_of_product,axiom,
    ( ~ product(X,Y,Z)
    | product(Y,X,Z) ) ).

cnf(product_and_inverse,axiom,
    ( greater_than_0(X)
    | product(X,X,additive_identity)
    | greater_than_0(additive_inverse(X)) ) ).

cnf(square_to_0,axiom,
    ( ~ product(Y,Z,X)
    | ~ product(Y,Y,additive_identity)
    | product(X,X,additive_identity) ) ).

cnf(product_and_greater_than_0,axiom,
    ( ~ product(Y,Z,X)
    | ~ greater_than_0(Y)
    | ~ greater_than_0(Z)
    | greater_than_0(X) ) ).

cnf(a_greater_than_0,hypothesis,
    greater_than_0(a) ).

cnf(prove_a_inverse_greater_than_0,negated_conjecture,
    ~ greater_than_0(multiplicative_inverse(a)) ).

%--------------------------------------------------------------------------
