%--------------------------------------------------------------------------
% File     : PUZ034-1.SIZE : TPTP . Released v1.0.0.
% Domain   : Puzzles
% Problem  : N queens problem
% Version  : [SETHEO] axioms : Biased.
% English  : The problem is to place SIZE queens on an SIZExSIZE chess board, 
%            so that no queen can attack another.

% Refs     : 
% Source   : [SETHEO]
% Names    : q1-2.lop (Size 8) [SETHEO]
%          : q1-9.lop (Size 9) [SETHEO]
%          : q1-10.lop (Size 10) [SETHEO]

% Status   : STATUS
% Rating   : ? v2.0.0
% Syntax   : 

% Comments : Biased towards SETHEO.
%--------------------------------------------------------------------------
'PUZ034-1_fixed_N_queens_clauses'([
cnf(make_list_of_numbers1,axiom,
    ( range('Low','High',cons('Low','RestOfNumbers')) |
     ~less('Low','High') |
     ~sum('Low',s(zero),'NewLow') |
     ~range('NewLow','High','RestOfNumbers') )),
cnf(make_list_of_numbers2,axiom,
    ( range('Same','Same',cons('Same',empty_list)) )),
cnf(less1,axiom,
    ( less(zero,s('X')) )),
cnf(less2,axiom,
    ( less(s('X'),s('Y')) |
     ~less('X','Y') )),
cnf(add_zero,axiom,
    ( sum('X',zero,'X') )),
cnf(add,axiom,
    ( ~sum('X','Y','Z') |
     sum('X',s('Y'),s('Z')) )),
cnf(select1,axiom,
    ( select('Head',cons('Head','Tail'),'Tail') )),
cnf(select2,axiom,
    ( select('Element',cons('Head','Tail'),cons('Head','NewTail')) |
     ~select('Element','Tail','NewTail') )),
cnf(same_definition1,axiom,
    ( ~same(s('X'),zero) )),
cnf(same_definition2,axiom,
    ( ~same(zero,s('X')) )),
cnf(same_definition3,axiom,
    ( ~same(s('X'),s('Y')) |
     same('X','Y') )),
cnf(attack,axiom,
    ( diagonal_attack('Queen',s(zero),'PlacedQueens') |
     ~attack('Queen','PlacedQueens') )),
cnf(check_diagonals1,axiom,
    ( ~diagonal_attack('Queen','QueenNumber',cons('PlacedQueen',
'OtherPlacedQueens')) |
     ~sum('Diagonal1','QueenNumber','PlacedQueen') |
     same('Diagonal1','Queen') |
     ~sum('PlacedQueen','QueenNumber','Diagonal2') |
     same('Diagonal2','Queen') |
     ~sum('QueenNumber',s(zero),'NextQueenNumber') |
     diagonal_attack('Queen','NextQueenNumber','OtherPlacedQueens') )),
cnf(check_diagonals2,axiom,
    ( ~diagonal_attack('Queen','LastQueen',empty_list) )),
cnf(place_a_queen1,axiom,
    ( do_queens('UnplacedQueens','SafeQueens','Placement') |
     ~select('AQueen','UnplacedQueens','RestOfUnplacedQueens') |
     attack('AQueen','SafeQueens') |
     ~do_queens('RestOfUnplacedQueens',cons('AQueen','SafeQueens'),
'Placement') )),
cnf(place_a_queen2,axiom,
    ( do_queens(empty_list,'Placement','Placement') )),
cnf(set_up_queens,axiom,
    ( queens('NumberOfQueens','Placement') |
     ~sum('NumberOfQueens',s(zero),'Low') |
     ~sum('NumberOfQueens','NumberOfQueens','High') |
     ~range('Low','High','Positions') |
     ~do_queens('Positions',empty_list,'Placement') ))
]).
%--------------------------------------------------------------------------
'PUZ034-1_successor_integer'(0,zero).

'PUZ034-1_successor_integer'(Size,s(SuccessorInteger)):-
    Size > 0,
    Size1 is Size - 1,
    'PUZ034-1_successor_integer'(Size1,SuccessorInteger).
%--------------------------------------------------------------------------
%----The status of this problem
'PUZ034-1_status'(Size,'Satisfiable'):-
    tptp2X_member(Size,[2,3]),
    !.

'PUZ034-1_status'(_,'Unknown'):-
    !.
%--------------------------------------------------------------------------
'PUZ034-1'(Size,Clauses,Status):-
    integer(Size),
    'PUZ034-1_fixed_N_queens_clauses'(FixedClauses),
    'PUZ034-1_successor_integer'(Size,SuccessorInteger),
    tptp2X_append(FixedClauses,[cnf(place_queens,negated_conjecture,
( ~queens(SuccessorInteger,'Placement') ))],Clauses),
    'PUZ034-1_status'(Size,Status).
%--------------------------------------------------------------------------
%----Provide information about the PUZ034-1 generator
'PUZ034-1_file_information'(generator,sizes(X,(X>=2)),sota(4,3)).
%----Unsatisfiable size 4 ()
%----Satisfiable size 3 ()
%--------------------------------------------------------------------------
