%------------------------------------------------------------------------------
% File     : KLE152+1 : TPTP v9.0.0. Released v4.0.0.
% Domain   : Kleene Algebra (Demonic Refinement Algebra)
% Problem  : Sliding of strong iteration
% Version  : [Hoe08] axioms.
% English  : Two ways of grouping an alternation of x's and y's that starts
%            and ends with x.

% Refs     : [vW02]  von Wright (2002), From Kleene Algebra to Refinement A
%          : [Hoe08] Hoefner (2008), Email to G. Sutcliffe
% Source   : [Hoe08]
% Names    :

% Status   : Theorem
% Rating   : 0.97 v9.0.0, 1.00 v4.0.0
% Syntax   : Number of formulae    :   19 (  15 unt;   0 def)
%            Number of atoms       :   23 (  15 equ)
%            Maximal formula atoms :    2 (   1 avg)
%            Number of connectives :    4 (   0   ~;   0   |;   0   &)
%                                         (   1 <=>;   3  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    5 (   3 avg)
%            Maximal term depth    :    4 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 2-2 aty)
%            Number of functors    :    6 (   6 usr;   2 con; 0-2 aty)
%            Number of variables   :   36 (  36   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : The converse inequation holds also (KLE151).
%------------------------------------------------------------------------------
%---Include axioms for demonic refinement algebra
%------------------------------------------------------------------------------
%----Additive idempotent monoid
fof(additive_commutativity,axiom,
    ! [A,B] : addition(A,B) = addition(B,A) ).

fof(additive_associativity,axiom,
    ! [C,B,A] : addition(A,addition(B,C)) = addition(addition(A,B),C) ).

fof(additive_identity,axiom,
    ! [A] : addition(A,zero) = A ).

fof(idempotence,axiom,
    ! [A] : addition(A,A) = A ).

%----Multiplicative and commutative monoid
fof(multiplicative_associativity,axiom,
    ! [A,B,C] : multiplication(A,multiplication(B,C)) = multiplication(multiplication(A,B),C) ).

fof(multiplicative_right_identity,axiom,
    ! [A] : multiplication(A,one) = A ).

fof(multiplicative_left_identity,axiom,
    ! [A] : multiplication(one,A) = A ).

%----Distributivity laws
fof(distributivity1,axiom,
    ! [A,B,C] : multiplication(A,addition(B,C)) = addition(multiplication(A,B),multiplication(A,C)) ).

fof(distributivity2,axiom,
    ! [A,B,C] : multiplication(addition(A,B),C) = addition(multiplication(A,C),multiplication(B,C)) ).

%----Annihilation (right zero law)
fof(left_annihilation,axiom,
    ! [A] : multiplication(zero,A) = zero ).

%----Kleene star
fof(star_unfold1,axiom,
    ! [A] : addition(one,multiplication(A,star(A))) = star(A) ).

fof(star_unfold2,axiom,
    ! [A] : addition(one,multiplication(star(A),A)) = star(A) ).

fof(star_induction1,axiom,
    ! [A,B,C] :
      ( leq(addition(multiplication(A,C),B),C)
     => leq(multiplication(star(A),B),C) ) ).

fof(star_induction2,axiom,
    ! [A,B,C] :
      ( leq(addition(multiplication(C,A),B),C)
     => leq(multiplication(B,star(A)),C) ) ).

%----Strong iteration
fof(infty_unfold1,axiom,
    ! [A] : strong_iteration(A) = addition(multiplication(A,strong_iteration(A)),one) ).

fof(infty_coinduction,axiom,
    ! [A,B,C] :
      ( leq(C,addition(multiplication(A,C),B))
     => leq(C,multiplication(strong_iteration(A),B)) ) ).

fof(isolation,axiom,
    ! [A] : strong_iteration(A) = addition(star(A),multiplication(strong_iteration(A),zero)) ).

%----Ordering
fof(order,axiom,
    ! [A,B] :
      ( leq(A,B)
    <=> addition(A,B) = B ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(goals,conjecture,
    ! [X0,X1] : leq(multiplication(strong_iteration(multiplication(X0,X1)),X0),multiplication(X0,strong_iteration(multiplication(X1,X0)))) ).

%------------------------------------------------------------------------------
