%------------------------------------------------------------------------------
% File     : CSR091+6 : TPTP v9.1.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Therapeutic process
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG18

% Status   : ContradictoryAxioms
% Rating   : 0.91 v9.0.0, 0.92 v8.2.0, 0.89 v8.1.0, 0.92 v7.5.0, 0.88 v7.4.0, 0.71 v7.3.0
% Syntax   : Number of formulae    : 55591 (40664 unt;   0 def)
%            Number of atoms       : 150983 (14168 equ)
%            Maximal formula atoms :   29 (   2 avg)
%            Number of connectives : 99399 (4007   ~; 275   |;60338   &)
%                                         ( 249 <=>;34530  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   3 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33068 (32451 usr;32840 con; 0-8 aty)
%            Number of variables   : 56935 (49181   !;7754   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
%------------------------------------------------------------------------------
fof(kb_SUMO_1,axiom,
    s__subclass(s__Ramadan,s__TimeInterval) ).

fof(kb_SUMO_2,axiom,
    s__instance(s__Ramadan__t,s__SetOrClass) ).

fof(kb_SUMO_3,axiom,
    s__documentation(s__Ramadan,s__EnglishLanguage,'Ramadan is the ninth month of the Islamic calendar. It is the Islamic month of fasting, in which participating Muslims refrain from eating, drinking, having sex, smoking, and indulging in anything that is in excess or ill-natured; from dawn until sunset. [Wikipedia]') ).

fof(kb_SUMO_4,axiom,
    s__documentation(s__Suhur,s__EnglishLanguage,'A light meal before starting a new day of Ramadan (before daybreak).') ).

fof(kb_SUMO_5,axiom,
    s__subclass(s__Suhur,s__Eating) ).

fof(kb_SUMO_6,axiom,
    s__instance(s__Suhur__t,s__SetOrClass) ).

fof(kb_SUMO_7,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Physical)
     => ( s__instance(V__X,s__Suhur)
       => ? [V__R,V__S,V__D] :
            ( s__instance(V__D,s__TimeInterval)
            & s__instance(V__S,s__TimeInterval)
            & s__instance(V__S,s__TimePoint)
            & s__instance(V__R,s__TimeInterval)
            & s__instance(V__S,s__Sunrise)
            & s__instance(V__R,s__Ramadan)
            & s__instance(V__D,s__Day)
            & s__during(V__D,V__R)
            & s__during(s__WhenFn(V__X),V__D)
            & s__during(V__S,V__D)
            & s__before(s__WhenFn(V__X),V__S) ) ) ) ).

fof(kb_SUMO_8,axiom,
    s__documentation(s__Mausaharati,s__EnglishLanguage,'A man who beats a drum in the streets (before dawn) to wake people up to have xsuhurx before they start a new day of fasting.') ).

fof(kb_SUMO_9,axiom,
    s__instance(s__Mausaharati,s__SocialRole) ).

fof(kb_SUMO_10,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__Agent)
     => ( s__attribute(V__H,s__Mausaharati)
       => s__hasSkill(s__Drumming,V__H) ) ) ).

fof(kb_SUMO_11,axiom,
    ! [V__DAY,V__S,V__D,V__H] :
      ( ( s__instance(V__H,s__Agent)
        & s__instance(V__D,s__Process)
        & s__instance(V__D,s__TimeInterval)
        & s__instance(V__D,s__TimePoint)
        & s__instance(V__S,s__TimeInterval)
        & s__instance(V__S,s__TimePoint)
        & s__instance(V__DAY,s__TimeInterval) )
     => ( ( s__attribute(V__H,s__Mausaharati)
          & s__instance(V__D,s__Drumming)
          & s__agent(V__D,V__H)
          & s__instance(V__DAY,s__Day)
          & s__instance(V__S,s__Sunrise)
          & s__during(V__S,V__D)
          & s__before(V__D,V__S) )
       => s__hasPurpose(V__D,'(? [V__P,V__SUHUR,V__WU] : (s__instance(V__WU,s__Process) & s__instance(V__WU,s__TimePoint) & s__instance(V__WU,s__TimeInterval) & s__instance(V__SUHUR,s__Process) & s__instance(V__SUHUR,s__TimePoint) & s__instance(V__SUHUR,s__TimeInterval) & s__instance(V__P,s__Agent) & s__instance(V__WU,s__WakingUp) & s__experiencer(V__WU,V__P) & s__instance(V__SUHUR,s__Suhur) & s__agent(V__SUHUR,V__P) & s__before(V__WU,V__SUHUR) & s__during(V__WU,V__DAY) & s__during(V__SUHUR,V__DAY)))') ) ) ).

fof(kb_SUMO_12,axiom,
    s__documentation(s__Iftar,s__EnglishLanguage,'A meal at the end of each day of Ramadan, at the sunset.') ).

fof(kb_SUMO_13,axiom,
    s__subclass(s__Iftar,s__Eating) ).

fof(kb_SUMO_14,axiom,
    s__instance(s__Iftar__t,s__SetOrClass) ).

fof(kb_SUMO_15,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Physical)
     => ( s__instance(V__X,s__Iftar)
       => ? [V__R,V__S,V__D] :
            ( s__instance(V__D,s__TimeInterval)
            & s__instance(V__S,s__TimeInterval)
            & s__instance(V__S,s__TimePoint)
            & s__instance(V__R,s__TimeInterval)
            & s__instance(V__S,s__Sunset)
            & s__instance(V__R,s__Ramadan)
            & s__instance(V__D,s__Day)
            & s__during(V__D,V__R)
            & s__during(s__WhenFn(V__X),V__D)
            & s__during(V__S,V__D)
            & s__before(V__S,s__WhenFn(V__X)) ) ) ) ).

fof(kb_SUMO_16,axiom,
    s__documentation(s__DhuAlHijjah,s__EnglishLanguage,'Dhu al-Hijja is the twelfth and final month in the Islamic Calendar. It is also known as Thw al-Hijja. This is a very sacred month in the Islamic calendar, marking the end of the year. It is in this month in which the Hajj Pilgrimage takes place. Dhu al-hijjah literally means xLord of the Pilgrimage.x It is during this month that pilgrims from all around the world congregate at Mecca to visit the Kaaba. The Hajj is performed on the eighth, ninth and the tenth of this month. Eid ul-Adha, the xFestival of the Sacrifice,x is held on the tenth day. (from Wikipedia)') ).

fof(kb_SUMO_17,axiom,
    s__subclass(s__DhuAlHijjah,s__TimeInterval) ).

fof(kb_SUMO_18,axiom,
    s__instance(s__DhuAlHijjah__t,s__SetOrClass) ).

fof(kb_SUMO_19,axiom,
    s__relatedInternalConcept(s__DhuAlHijjah,s__Month) ).

fof(kb_SUMO_20,axiom,
    s__documentation(s__Hajj,s__EnglishLanguage,'The Pilgrimage to Mecca in Islam. It is the fifth obligatory Pillar of the Five Pillars of Islam for those who are ablebodied and can afford to do pilgrimage to Mecca at least once in their lifetime. It takes place every year in the Islamic month of Dhu al-Hijjah.') ).

fof(kb_SUMO_21,axiom,
    s__subclass(s__Hajj,s__ReligiousProcess) ).

fof(kb_SUMO_22,axiom,
    s__subclass(s__Hajj,s__Translocation) ).

fof(kb_SUMO_23,axiom,
    s__instance(s__Hajj__t,s__SetOrClass) ).

fof(kb_SUMO_24,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__Process)
     => ( s__instance(V__H,s__Hajj)
       => s__destination(V__H,s__MeccaSaudiArabia) ) ) ).

fof(kb_SUMO_25,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__TimeInterval)
     => ( s__instance(V__H,s__Hajj)
       => ? [V__D] :
            ( s__instance(V__D,s__TimeInterval)
            & s__instance(V__D,s__DhuAlHijjah)
            & s__during(V__H,V__D) ) ) ) ).

fof(kb_SUMO_26,axiom,
    ! [V__P] :
      ( s__instance(V__P,s__Agent)
     => ( ( s__attribute(V__P,s__Muslim)
          & s__capability(s__Hajj,s__agent__m,V__P) )
       => s__modalAttribute('(? [V__H] : (s__instance(V__H,s__Process) & s__instance(V__H,s__Hajj) & s__agent(V__H,V__P)))',s__Obligation) ) ) ).

fof(kb_SUMO_27,axiom,
    s__documentation(s__IhramClothing,s__EnglishLanguage,'Special &%Muslim clothing, worn during Pilgrimage ceremonies. It consists of a white robe, belt and sandals for men. For women it can be any modest garment, although some regional and sectarian conventions are prescribed.') ).

fof(kb_SUMO_28,axiom,
    s__subclass(s__IhramClothing,s__ClothingSuit) ).

fof(kb_SUMO_29,axiom,
    s__instance(s__IhramClothing__t,s__SetOrClass) ).

fof(kb_SUMO_30,axiom,
    ! [V__IC,V__M] :
      ( ( s__instance(V__M,s__WearableItem)
        & s__instance(V__IC,s__Animal)
        & s__instance(V__IC,s__Collection) )
     => ( ( s__instance(V__IC,s__IhramClothing)
          & s__wears(V__IC,V__M)
          & s__attribute(V__M,s__Male) )
       => ? [V__C,V__B,V__S] :
            ( s__instance(V__S,s__SelfConnectedObject)
            & s__instance(V__B,s__SelfConnectedObject)
            & s__instance(V__C,s__SelfConnectedObject)
            & s__instance(V__C,s__Cloak)
            & s__instance(V__B,s__Belt)
            & s__instance(V__S,s__Sandal)
            & s__member(V__C,V__IC)
            & s__member(V__B,V__IC)
            & s__member(V__S,V__IC) ) ) ) ).

fof(kb_SUMO_31,axiom,
    s__documentation(s__IhramPeriod,s__EnglishLanguage,'Special Muslim practices including the type of clothing, hair cutting/shaving and behaviour prior to and during Pilgrimage ceremonies.') ).

fof(kb_SUMO_32,axiom,
    s__subclass(s__IhramPeriod,s__ReligiousProcess) ).

fof(kb_SUMO_33,axiom,
    s__instance(s__IhramPeriod__t,s__SetOrClass) ).

%FOL fof(kb_SUMO_34,axiom,(( (! [V__A,V__IP] : ((s__instance(V__IP,s__Process) & s__instance(V__A,s__Animal)) => (s__experiencer(V__IP,V__A) => (? [V__IC] : (s__instance(V__IC,s__WearableItem) & s__instance(V__IC,s__IhramClothing) & s__holdsDuring(s__WhenFn(V__IP),'s__wears(V__A,V__IC)')))))) ))).

fof(kb_SUMO_35,axiom,
    s__documentation(s__Umrah,s__EnglishLanguage,'A pilgrimage to Meccca performed by Muslims that can be undertaken at any time of the year. According to some schools of Islamic thought, the Umrah is not compulsory (as with Hajj) but highly recommended.') ).

fof(kb_SUMO_36,axiom,
    s__subclass(s__Umrah,s__ReligiousProcess) ).

fof(kb_SUMO_37,axiom,
    s__subclass(s__Umrah,s__Translocation) ).

fof(kb_SUMO_38,axiom,
    s__instance(s__Umrah__t,s__SetOrClass) ).

fof(kb_SUMO_39,axiom,
    ! [V__U] :
      ( s__instance(V__U,s__Process)
     => ( s__instance(V__U,s__Umrah)
       => s__destination(V__U,s__MeccaSaudiArabia) ) ) ).

fof(kb_SUMO_40,axiom,
    s__documentation(s__Zakat,s__EnglishLanguage,'The third of the Five Pillars of Islam and refers to spending at least 2.5% of ones wealth each year for the poor or needy.') ).

fof(kb_SUMO_41,axiom,
    s__subclass(s__Zakat,s__ReligiousProcess) ).

fof(kb_SUMO_42,axiom,
    s__instance(s__Zakat__t,s__SetOrClass) ).

fof(kb_SUMO_43,axiom,
    ! [V__H,V__Z] :
      ( ( s__instance(V__Z,s__Process)
        & s__instance(V__H,s__Agent) )
     => ( s__instance(V__Z,s__Zakat)
       => ( s__agent(V__Z,V__H)
          & s__attribute(V__H,s__Muslim) ) ) ) ).

fof(kb_SUMO_44,axiom,
    ! [V__C,V__W,V__H,V__Y] :
      ( ( s__instance(V__Y,s__TimeInterval)
        & s__instance(V__H,s__Agent)
        & s__instance(V__W,s__Quantity)
        & s__instance(V__C,s__CurrencyMeasure) )
     => ( ( s__attribute(V__H,s__Muslim)
          & s__WealthFn(V__H) = V__W )
       => s__modalAttribute('(? [V__Z,V__T] : (s__instance(V__T,s__Physical) & s__instance(V__Z,s__Process) & s__instance(V__Z,s__Zakat) & s__instance(V__Y,s__Year) & s__during(V__Y,s__WhenFn(V__H)) & s__holdsDuring(V__Y,s__attribute(V__H,s__FullyFormed)) & s__agent(V__Z,V__H) & s__patient(V__Z,V__T) & s__monetaryValue(V__T,V__C) & greater(V__C,times(V__W,0.025))))',s__Obligation) ) ) ).

fof(kb_SUMO_45,axiom,
    s__documentation(s__EidAlFitr,s__EnglishLanguage,'Socioreligious event in which Muslims celebrate their end of fasting at the end of the Holy month of Ramadan.') ).

fof(kb_SUMO_46,axiom,
    s__subclass(s__EidAlFitr,s__Holiday) ).

fof(kb_SUMO_47,axiom,
    s__instance(s__EidAlFitr__t,s__SetOrClass) ).

fof(kb_SUMO_48,axiom,
    ! [V__E] :
      ( ( s__instance(V__E,s__TimeInterval)
        & s__instance(V__E,s__TimePoint) )
     => ( s__instance(V__E,s__EidAlFitr)
       => ? [V__R,V__Y] :
            ( s__instance(V__Y,s__TimeInterval)
            & s__instance(V__R,s__TimeInterval)
            & s__instance(V__R,s__TimePoint)
            & s__instance(V__R,s__Ramadan)
            & s__instance(V__Y,s__Year)
            & s__during(V__R,V__Y)
            & s__during(V__E,V__Y)
            & s__before(V__R,V__E) ) ) ) ).

fof(kb_SUMO_49,axiom,
    s__documentation(s__UdhiyahRitual,s__EnglishLanguage,'A ritual in which a lamb is killed as sacrifice on the day of The Greater Eid (Eid Aladha).') ).

fof(kb_SUMO_50,axiom,
    s__subclass(s__UdhiyahRitual,s__ReligiousProcess) ).

fof(kb_SUMO_51,axiom,
    s__subclass(s__UdhiyahRitual,s__Killing) ).

fof(kb_SUMO_52,axiom,
    s__instance(s__UdhiyahRitual__t,s__SetOrClass) ).

fof(kb_SUMO_53,axiom,
    ! [V__UR] :
      ( ( s__instance(V__UR,s__TimeInterval)
        & s__instance(V__UR,s__Process) )
     => ( s__instance(V__UR,s__UdhiyahRitual)
       => ? [V__S,V__EA,V__P] :
            ( s__instance(V__P,s__Agent)
            & s__instance(V__EA,s__TimeInterval)
            & s__instance(V__S,s__Object)
            & s__instance(V__EA,s__EidAladha)
            & s__during(V__UR,V__EA)
            & s__attribute(V__S,s__Udhiyah)
            & s__agent(V__UR,V__P)
            & s__attribute(V__P,s__Muslim)
            & s__patient(V__UR,V__S) ) ) ) ).

fof(kb_SUMO_54,axiom,
    s__documentation(s__Udhiyah,s__EnglishLanguage,'A lamb that is killed as sacrifice on the day of The Greater ?eid (Eid Aladha).') ).

fof(kb_SUMO_55,axiom,
    s__instance(s__Udhiyah,s__RelationalAttribute) ).

fof(kb_SUMO_56,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__attribute(V__S,s__Udhiyah)
       => ? [V__UR] :
            ( s__instance(V__UR,s__Process)
            & s__instance(V__S,s__Lamb)
            & s__instance(V__UR,s__UdhiyahRitual)
            & s__patient(V__UR,V__S) ) ) ) ).

fof(kb_SUMO_57,axiom,
    s__documentation(s__EidAladha,s__EnglishLanguage,'A socioreligious event which commemorates the Prophet Ibrahimxs (Abrahamxs) willingness to sacrifice his son Ismail. Muslims slaughter a lamb as an act of gratitude to God who saved Ismail by sending the angels with a great lamb to be slaughtered instead of Ismail.') ).

fof(kb_SUMO_58,axiom,
    s__subclass(s__EidAladha,s__ReligiousProcess) ).

fof(kb_SUMO_59,axiom,
    s__instance(s__EidAladha__t,s__SetOrClass) ).

fof(kb_SUMO_60,axiom,
    ! [V__EA] :
      ( s__instance(V__EA,s__Process)
     => ( s__instance(V__EA,s__EidAladha)
       => ? [V__UR] :
            ( s__instance(V__UR,s__Process)
            & s__instance(V__UR,s__UdhiyahRitual)
            & s__subProcess(V__UR,V__EA) ) ) ) ).

fof(kb_SUMO_61,axiom,
    s__documentation(s__MuakharSadaq,s__EnglishLanguage,'Delayed dowry: Money or property stipulated upon in the marriage contract which is due to be paid by the husband to his wife in case he intends to divorce her.') ).

fof(kb_SUMO_62,axiom,
    s__subclass(s__MuakharSadaq,s__FinancialTransaction) ).

fof(kb_SUMO_63,axiom,
    s__instance(s__MuakharSadaq__t,s__SetOrClass) ).

%FOL fof(kb_SUMO_64,axiom,(( (! [V__MS] : ((s__instance(V__MS,s__Process) & s__instance(V__MS,s__TimeInterval)) => (s__instance(V__MS,s__MuakharSadaq) => (? [V__H,V__W,V__T1,V__T2] : (s__instance(V__T2,s__TimePoint) & s__instance(V__T2,s__TimeInterval) & s__instance(V__T1,s__TimeInterval) & s__instance(V__T1,s__TimePoint) & s__instance(V__W,s__Woman) & s__instance(V__H,s__Man) & s__agent(V__MS,V__H) & s__origin(V__MS,V__H) & s__destination(V__MS,V__W) & s__holdsDuring(V__T1,'s__wife(V__W,V__H)') & (~ s__holdsDuring(V__T2,'s__wife(V__W,V__H)')) & s__finishes(V__T1,V__MS) & s__before(V__T1,V__T2) & s__starts(V__T2,V__MS)))))) ))).

fof(kb_SUMO_65,axiom,
    s__documentation(s__MuqaddamSadaq,s__EnglishLanguage,'Advance dowry: Money or property brought by a man to his wife at marriage') ).

fof(kb_SUMO_66,axiom,
    s__subclass(s__MuqaddamSadaq,s__FinancialTransaction) ).

fof(kb_SUMO_67,axiom,
    s__instance(s__MuqaddamSadaq__t,s__SetOrClass) ).

%FOL fof(kb_SUMO_68,axiom,(( (! [V__MS] : ((s__instance(V__MS,s__Process) & s__instance(V__MS,s__TimeInterval)) => (s__instance(V__MS,s__MuqaddamSadaq) => (? [V__H,V__W,V__T1,V__T2] : (s__instance(V__T2,s__TimePoint) & s__instance(V__T2,s__TimeInterval) & s__instance(V__T1,s__TimeInterval) & s__instance(V__T1,s__TimePoint) & s__instance(V__W,s__Woman) & s__instance(V__H,s__Man) & s__agent(V__MS,V__H) & s__origin(V__MS,V__H) & s__destination(V__MS,V__W) & (~ s__holdsDuring(V__T1,'s__wife(V__W,V__H)')) & s__holdsDuring(V__T2,'s__wife(V__W,V__H)') & s__finishes(V__T1,V__MS) & s__before(V__T1,V__T2) & s__starts(V__T2,V__MS)))))) ))).

fof(kb_SUMO_69,axiom,
    s__documentation(s__Aqiqah,s__EnglishLanguage,'A Muslim rite in which a special meal is hosted in celebration of having a new born baby.') ).

fof(kb_SUMO_70,axiom,
    s__subclass(s__Aqiqah,s__ReligiousProcess) ).

fof(kb_SUMO_71,axiom,
    s__instance(s__Aqiqah__t,s__SetOrClass) ).

fof(kb_SUMO_72,axiom,
    s__subclass(s__Aqiqah,s__Eating) ).

fof(kb_SUMO_73,axiom,
    ! [V__A] :
      ( ( s__instance(V__A,s__Process)
        & s__instance(V__A,s__Object) )
     => ( s__instance(V__A,s__Aqiqah)
       => ? [V__AGENT] :
            ( s__instance(V__AGENT,s__Agent)
            & s__agent(V__A,V__AGENT)
            & s__attribute(V__A,s__Muslim) ) ) ) ).

fof(kb_SUMO_74,axiom,
    ! [V__A] :
      ( s__instance(V__A,s__Physical)
     => ( s__instance(V__A,s__Aqiqah)
       => ? [V__BIRTH] :
            ( s__instance(V__BIRTH,s__Physical)
            & s__refers(V__A,V__BIRTH)
            & s__earlier(s__WhenFn(V__BIRTH),s__WhenFn(V__A)) ) ) ) ).

fof(kb_SUMO_75,axiom,
    s__documentation(s__Khitan,s__EnglishLanguage,'A &%Circumcision performed as a religious rite in a social event on a &%Male child.') ).

fof(kb_SUMO_76,axiom,
    s__subclass(s__Khitan,s__Circumision) ).

fof(kb_SUMO_77,axiom,
    s__subclass(s__Khitan,s__ReligiousProcess) ).

fof(kb_SUMO_78,axiom,
    s__instance(s__Khitan__t,s__SetOrClass) ).

fof(kb_SUMO_79,axiom,
    s__documentation(s__Miswak,s__EnglishLanguage,'A natural tooth brush in the form of a small branch from the plant Salvadora persica, still in use by Arabs and Muslims.') ).

fof(kb_SUMO_80,axiom,
    s__subclass(s__Miswak,s__Toothbrush) ).

fof(kb_SUMO_81,axiom,
    s__subclass(s__Miswak,s__OrganicObject) ).

fof(kb_SUMO_82,axiom,
    s__instance(s__Miswak__t,s__SetOrClass) ).

fof(kb_SUMO_83,axiom,
    s__documentation(s__Kufiyyah,s__EnglishLanguage,'Traditional head wear for Arabic men (see also xShimaghx).') ).

fof(kb_SUMO_84,axiom,
    s__subclass(s__Kufiyyah,s__Hat) ).

fof(kb_SUMO_85,axiom,
    s__instance(s__Kufiyyah__t,s__SetOrClass) ).

fof(kb_SUMO_86,axiom,
    s__documentation(s__Tagiyyah,s__EnglishLanguage,'A white cap that is used by Arabs in north Africa as head cover. In the Gulf countries it is used as one of threepiece head cover where it is worn as the bottom piece under the xgutrahx and xoqalx.') ).

fof(kb_SUMO_87,axiom,
    s__subclass(s__Tagiyyah,s__Hat) ).

fof(kb_SUMO_88,axiom,
    s__instance(s__Tagiyyah__t,s__SetOrClass) ).

fof(kb_SUMO_89,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Tagiyyah)
       => s__attribute(V__T,s__White) ) ) ).

fof(kb_SUMO_90,axiom,
    s__documentation(s__Gutrah,s__EnglishLanguage,'A white scarf-like head cover which is worn by Arabs in the Gulf countries in Summer') ).

fof(kb_SUMO_91,axiom,
    s__subclass(s__Gutrah,s__Hat) ).

fof(kb_SUMO_92,axiom,
    s__instance(s__Gutrah__t,s__SetOrClass) ).

fof(kb_SUMO_93,axiom,
    ! [V__G] :
      ( s__instance(V__G,s__Object)
     => ( s__instance(V__G,s__Gutrah)
       => s__attribute(V__G,s__White) ) ) ).

fof(kb_SUMO_94,axiom,
    ! [V__S,V__T,V__H,V__G,V__AREA] :
      ( ( s__instance(V__AREA,s__GeographicArea)
        & s__instance(V__G,s__WearableItem)
        & s__instance(V__H,s__Animal)
        & s__instance(V__T,s__TimeInterval)
        & s__subclass(V__S,s__TimeInterval)
        & s__instance(V__S,s__TimeInterval)
        & s__instance(V__S,s__SetOrClass) )
     => ( s__instance(V__G,s__Gutrah)
       => s__hasPurpose(V__G,'((s__holdsDuring(V__T,s__wears(V__H,V__G)) & s__holdsDuring(V__T,s__located(V__H,V__AREA)) & s__hotSeasonInArea(V__AREA,V__S)) => s__during(V__T,V__S))') ) ) ).

fof(kb_SUMO_95,axiom,
    s__documentation(s__Shimagh,s__EnglishLanguage,'A heavy red and white checked scarflike head cover which is worn by Arabs in the Gulf countries in Winter.') ).

fof(kb_SUMO_96,axiom,
    s__subclass(s__Shimagh,s__Hat) ).

fof(kb_SUMO_97,axiom,
    s__instance(s__Shimagh__t,s__SetOrClass) ).

fof(kb_SUMO_98,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Shimagh)
       => ( s__attribute(V__T,s__White)
          & s__attribute(V__T,s__Red) ) ) ) ).

fof(kb_SUMO_99,axiom,
    ! [V__S,V__T,V__H,V__G,V__AREA] :
      ( ( s__instance(V__AREA,s__GeographicArea)
        & s__instance(V__G,s__WearableItem)
        & s__instance(V__H,s__Animal)
        & s__instance(V__T,s__TimeInterval)
        & s__subclass(V__S,s__TimeInterval)
        & s__instance(V__S,s__TimeInterval)
        & s__instance(V__S,s__SetOrClass) )
     => ( s__instance(V__G,s__Shimagh)
       => s__hasPurpose(V__G,'((s__holdsDuring(V__T,s__wears(V__H,V__G)) & s__holdsDuring(V__T,s__located(V__H,V__AREA)) & s__coldSeasonInArea(V__AREA,V__S)) => s__during(V__T,V__S))') ) ) ).

fof(kb_SUMO_100,axiom,
    s__documentation(s__Oqal,s__EnglishLanguage,'A black headband worn by Saudi Arabia and Gulf state Arabs to hold other pieces of head cover in place.') ).

fof(kb_SUMO_101,axiom,
    s__subclass(s__Oqal,s__Clothing) ).

fof(kb_SUMO_102,axiom,
    s__instance(s__Oqal__t,s__SetOrClass) ).

fof(kb_SUMO_103,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Oqal)
       => s__attribute(V__T,s__Black) ) ) ).

fof(kb_SUMO_104,axiom,
    ! [V__O,V__D,V__H] :
      ( ( s__instance(V__D,s__Process)
        & s__instance(V__O,s__Object) )
     => ( ( s__instance(V__D,s__Dressing)
          & s__instance(V__O,s__Oqal)
          & s__instance(V__H,s__Hat)
          & s__patient(V__D,V__O)
          & s__patient(V__D,V__H) )
       => s__hasPurpose(V__O,'(? [V__A] : (s__instance(V__A,s__Process) & s__instance(V__A,s__Attaching) & s__instrument(V__A,V__O)))') ) ) ).

fof(kb_SUMO_105,axiom,
    s__documentation(s__Jallabiyyah,s__EnglishLanguage,'Manxs long baggy dress (down to the heels) worn by Arabs in Morocco, known as jallabiyyah in Egypt (with minor difference in the design).') ).

fof(kb_SUMO_106,axiom,
    s__subclass(s__Jallabiyyah,s__Cloak) ).

fof(kb_SUMO_107,axiom,
    s__instance(s__Jallabiyyah__t,s__SetOrClass) ).

fof(kb_SUMO_108,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__WearableItem)
     => ( s__instance(V__H,s__Jallabiyyah)
       => s__hasPurpose(V__H,'(? [V__M] : (s__instance(V__M,s__Animal) & s__instance(V__M,s__Man) & s__wears(V__M,V__H)))') ) ) ).

fof(kb_SUMO_109,axiom,
    s__documentation(s__Dishdashah,s__EnglishLanguage,'Manxs long baggy dress worn by Arabs in the Gulf states.') ).

fof(kb_SUMO_110,axiom,
    s__subclass(s__Dishdashah,s__Cloak) ).

fof(kb_SUMO_111,axiom,
    s__instance(s__Dishdashah__t,s__SetOrClass) ).

fof(kb_SUMO_112,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__WearableItem)
     => ( s__instance(V__H,s__Dishdashah)
       => s__hasPurpose(V__H,'(? [V__M] : (s__instance(V__M,s__Animal) & s__instance(V__M,s__Man) & s__wears(V__M,V__H)))') ) ) ).

fof(kb_SUMO_113,axiom,
    s__documentation(s__Niqab,s__EnglishLanguage,'A piece of (mostly) black cloth worn to cover a womanxs lower part of the face (in Saudi Arabia, Yemen and Gulf states).') ).

fof(kb_SUMO_114,axiom,
    s__subclass(s__Niqab,s__Veil) ).

fof(kb_SUMO_115,axiom,
    s__instance(s__Niqab__t,s__SetOrClass) ).

fof(kb_SUMO_116,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Niqab)
       => ? [V__P] :
            ( s__instance(V__P,s__Object)
            & s__part(V__P,V__T)
            & s__attribute(V__P,s__Black) ) ) ) ).

fof(kb_SUMO_117,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__WearableItem)
     => ( s__instance(V__H,s__Niqab)
       => s__hasPurpose(V__H,'(? [V__W] : (s__instance(V__W,s__Animal) & s__instance(V__W,s__Woman) & s__wears(V__W,V__H)))') ) ) ).

fof(kb_SUMO_118,axiom,
    s__documentation(s__Khimar,s__EnglishLanguage,'A piece of (mostly) black cloth worn to cover a womanxs whole face (in Saudi Arabia and Gulf states)') ).

fof(kb_SUMO_119,axiom,
    s__subclass(s__Khimar,s__Veil) ).

fof(kb_SUMO_120,axiom,
    s__instance(s__Khimar__t,s__SetOrClass) ).

fof(kb_SUMO_121,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Khimar)
       => ? [V__P] :
            ( s__instance(V__P,s__Object)
            & s__part(V__P,V__T)
            & s__attribute(V__P,s__Black) ) ) ) ).

fof(kb_SUMO_122,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__WearableItem)
     => ( s__instance(V__H,s__Khimar)
       => s__hasPurpose(V__H,'(? [V__W] : (s__instance(V__W,s__Animal) & s__instance(V__W,s__Woman) & s__wears(V__W,V__H)))') ) ) ).

fof(kb_SUMO_123,axiom,
    s__documentation(s__Hijab,s__EnglishLanguage,'Arabic and Muslim veil which is worn by women to cover the hair and the neck.') ).

fof(kb_SUMO_124,axiom,
    s__subclass(s__Hijab,s__Veil) ).

fof(kb_SUMO_125,axiom,
    s__instance(s__Hijab__t,s__SetOrClass) ).

fof(kb_SUMO_126,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__WearableItem)
     => ( s__instance(V__H,s__Hijab)
       => s__hasPurpose(V__H,'(? [V__W] : (s__instance(V__W,s__Animal) & s__instance(V__W,s__Woman) & s__wears(V__W,V__H)))') ) ) ).

fof(kb_SUMO_127,axiom,
    s__documentation(s__Jilbab,s__EnglishLanguage,'A long, flowing, baggy overgarment worn by some Muslim women to show modesty.') ).

fof(kb_SUMO_128,axiom,
    s__subclass(s__Jilbab,s__Cloak) ).

fof(kb_SUMO_129,axiom,
    s__instance(s__Jilbab__t,s__SetOrClass) ).

fof(kb_SUMO_130,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__WearableItem)
     => ( s__instance(V__H,s__Jilbab)
       => s__hasPurpose(V__H,'(? [V__W] : (s__instance(V__W,s__Animal) & s__instance(V__W,s__Woman) & s__wears(V__W,V__H)))') ) ) ).

fof(kb_SUMO_131,axiom,
    s__documentation(s__Abayah,s__EnglishLanguage,'A traditional long black overgarment worn by conservative Arab woman that cover the body from the shoulders down to the feet.') ).

fof(kb_SUMO_132,axiom,
    s__subclass(s__Abayah,s__Cloak) ).

fof(kb_SUMO_133,axiom,
    s__instance(s__Abayah__t,s__SetOrClass) ).

fof(kb_SUMO_134,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Abayah)
       => s__attribute(V__T,s__Black) ) ) ).

fof(kb_SUMO_135,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__WearableItem)
     => ( s__instance(V__H,s__Abayah)
       => s__hasPurpose(V__H,'(? [V__W] : (s__instance(V__W,s__Animal) & s__instance(V__W,s__Woman) & s__wears(V__W,V__H)))') ) ) ).

fof(kb_SUMO_136,axiom,
    s__documentation(s__Misbahah,s__EnglishLanguage,'Rosary or beads (usually 33 beads in a string) used by Muslims to say silent prayers in private.') ).

fof(kb_SUMO_137,axiom,
    s__subclass(s__Misbahah,s__Jewelry) ).

fof(kb_SUMO_138,axiom,
    s__instance(s__Misbahah__t,s__SetOrClass) ).

fof(kb_SUMO_139,axiom,
    s__instance(s__Jewelry__t,s__SetOrClass) ).

fof(kb_SUMO_140,axiom,
    ! [V__M] :
      ( s__instance(V__M,s__Physical)
     => ( s__instance(V__M,s__Misbahah)
       => s__hasPurpose(V__M,'(? [V__P,V__H] : (s__instance(V__H,s__Agent) & s__instance(V__P,s__Process) & s__instance(V__P,s__Praying) & s__agent(V__P,V__H) & s__attribute(V__H,s__Muslim) & s__patient(V__P,V__M)))') ) ) ).

fof(kb_SUMO_141,axiom,
    s__instance(s__paternalUncle__m,s__BinaryRelation) ).

fof(kb_SUMO_142,axiom,
    s__subrelation(s__paternalUncle__m,s__familyRelation__m) ).

fof(kb_SUMO_143,axiom,
    s__documentation(s__paternalUncle__m,s__EnglishLanguage,'In Arabic: Eam~. Fathers brother, paternal uncle.') ).

fof(kb_SUMO_144,axiom,
    ! [V__UNC,V__P] :
      ( ( s__instance(V__P,s__Organism)
        & s__instance(V__UNC,s__Human) )
     => ( s__paternalUncle(V__P,V__UNC)
       => ? [V__F] :
            ( s__instance(V__F,s__Man)
            & s__father(V__P,V__F)
            & s__brother(V__F,V__UNC) ) ) ) ).

fof(kb_SUMO_145,axiom,
    s__instance(s__maternalUncle__m,s__BinaryRelation) ).

fof(kb_SUMO_146,axiom,
    s__subrelation(s__maternalUncle__m,s__familyRelation__m) ).

fof(kb_SUMO_147,axiom,
    s__documentation(s__maternalUncle__m,s__EnglishLanguage,'In Arabic: xaAl. Mothers brother, maternal uncle.') ).

fof(kb_SUMO_148,axiom,
    ! [V__UNC,V__P] :
      ( ( s__instance(V__P,s__Organism)
        & s__instance(V__UNC,s__Man) )
     => ( s__maternalUncle(V__P,V__UNC)
       => ? [V__M] :
            ( s__instance(V__M,s__Human)
            & s__mother(V__P,V__M)
            & s__brother(V__UNC,V__M) ) ) ) ).

fof(kb_SUMO_149,axiom,
    s__instance(s__paternalAunt__m,s__BinaryRelation) ).

fof(kb_SUMO_150,axiom,
    s__subrelation(s__paternalAunt__m,s__familyRelation__m) ).

fof(kb_SUMO_151,axiom,
    s__documentation(s__paternalAunt__m,s__EnglishLanguage,'In Arabic: Eam~ap. Fathers sister, paternal aunt.') ).

fof(kb_SUMO_152,axiom,
    ! [V__P,V__AUN] :
      ( ( s__instance(V__AUN,s__Human)
        & s__instance(V__P,s__Organism) )
     => ( s__paternalAunt(V__P,V__AUN)
       => ? [V__F] :
            ( s__instance(V__F,s__Woman)
            & s__father(V__P,V__F)
            & s__sister(V__F,V__AUN) ) ) ) ).

fof(kb_SUMO_153,axiom,
    s__instance(s__maternalAunt__m,s__BinaryRelation) ).

fof(kb_SUMO_154,axiom,
    s__subrelation(s__maternalAunt__m,s__familyRelation__m) ).

fof(kb_SUMO_155,axiom,
    s__documentation(s__maternalAunt__m,s__EnglishLanguage,'In Arabic: xaAlap. Mothers sister, maternal aunt.') ).

fof(kb_SUMO_156,axiom,
    ! [V__P,V__AUN] :
      ( ( s__instance(V__AUN,s__Human)
        & s__instance(V__P,s__Organism) )
     => ( s__maternalAunt(V__P,V__AUN)
       => ? [V__M] :
            ( s__instance(V__M,s__Woman)
            & s__mother(V__P,V__M)
            & s__sister(V__M,V__AUN) ) ) ) ).

fof(kb_SUMO_157,axiom,
    s__instance(s__fathersBrothersWife__m,s__BinaryRelation) ).

fof(kb_SUMO_158,axiom,
    s__subrelation(s__fathersBrothersWife__m,s__familyRelation__m) ).

fof(kb_SUMO_159,axiom,
    s__documentation(s__fathersBrothersWife__m,s__EnglishLanguage,'In Arabic: zawojap AlEam~. Wife of fathers brother.') ).

fof(kb_SUMO_160,axiom,
    ! [V__P,V__W] :
      ( ( s__instance(V__W,s__Man)
        & s__instance(V__P,s__Organism) )
     => ( s__fathersBrothersWife(V__P,V__W)
       => ? [V__F,V__UNC] :
            ( s__instance(V__UNC,s__Woman)
            & s__instance(V__F,s__Man)
            & s__father(V__P,V__F)
            & s__brother(V__F,V__UNC)
            & s__wife(V__UNC,V__W) ) ) ) ).

fof(kb_SUMO_161,axiom,
    s__instance(s__mothersBrothersWife__m,s__BinaryRelation) ).

fof(kb_SUMO_162,axiom,
    s__subrelation(s__mothersBrothersWife__m,s__familyRelation__m) ).

fof(kb_SUMO_163,axiom,
    s__documentation(s__mothersBrothersWife__m,s__EnglishLanguage,'In Arabic: zawojap AlxaAl. Wife of mothers brother.') ).

fof(kb_SUMO_164,axiom,
    ! [V__P,V__W] :
      ( ( s__instance(V__W,s__Man)
        & s__instance(V__P,s__Organism) )
     => ( s__mothersBrothersWife(V__P,V__W)
       => ? [V__M,V__UNC] :
            ( s__instance(V__UNC,s__Woman)
            & s__instance(V__M,s__Man)
            & s__mother(V__P,V__M)
            & s__brother(V__M,V__UNC)
            & s__wife(V__UNC,V__W) ) ) ) ).

fof(kb_SUMO_165,axiom,
    s__instance(s__fathersSistersHusband__m,s__BinaryRelation) ).

fof(kb_SUMO_166,axiom,
    s__subrelation(s__fathersSistersHusband__m,s__familyRelation__m) ).

fof(kb_SUMO_167,axiom,
    s__documentation(s__fathersSistersHusband__m,s__EnglishLanguage,'In Arabic: zawoj AlEam~ap. Husband of fathers sister.') ).

fof(kb_SUMO_168,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Woman)
        & s__instance(V__P,s__Organism) )
     => ( s__fathersSistersHusband(V__P,V__H)
       => ? [V__F,V__AUN] :
            ( s__instance(V__AUN,s__Man)
            & s__instance(V__F,s__Woman)
            & s__father(V__P,V__F)
            & s__sister(V__F,V__AUN)
            & s__husband(V__AUN,V__H) ) ) ) ).

fof(kb_SUMO_169,axiom,
    s__instance(s__mothersSistersHusband__m,s__BinaryRelation) ).

fof(kb_SUMO_170,axiom,
    s__subrelation(s__mothersSistersHusband__m,s__familyRelation__m) ).

fof(kb_SUMO_171,axiom,
    s__documentation(s__mothersSistersHusband__m,s__EnglishLanguage,'In Arabic: zawoj AlxaAlap. Husband of mothers sister.') ).

fof(kb_SUMO_172,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Woman)
        & s__instance(V__P,s__Organism) )
     => ( s__mothersSistersHusband(V__P,V__H)
       => ? [V__M,V__AUN] :
            ( s__instance(V__AUN,s__Man)
            & s__instance(V__M,s__Woman)
            & s__mother(V__P,V__M)
            & s__sister(V__M,V__AUN)
            & s__husband(V__AUN,V__H) ) ) ) ).

fof(kb_SUMO_173,axiom,
    s__instance(s__fathersBrothersSon__m,s__BinaryRelation) ).

fof(kb_SUMO_174,axiom,
    s__subrelation(s__fathersBrothersSon__m,s__familyRelation__m) ).

fof(kb_SUMO_175,axiom,
    s__documentation(s__fathersBrothersSon__m,s__EnglishLanguage,'In Arabic: Aibon AlEam~. Son of fathers brother.') ).

fof(kb_SUMO_176,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__fathersBrothersSon(V__P,V__H)
       => ? [V__F,V__UNC] :
            ( s__instance(V__UNC,s__Human)
            & s__instance(V__F,s__Man)
            & s__father(V__P,V__F)
            & s__brother(V__F,V__UNC)
            & s__son(V__UNC,V__H) ) ) ) ).

fof(kb_SUMO_177,axiom,
    s__instance(s__fathersBrothersDaughter__m,s__BinaryRelation) ).

fof(kb_SUMO_178,axiom,
    s__subrelation(s__fathersBrothersDaughter__m,s__familyRelation__m) ).

fof(kb_SUMO_179,axiom,
    s__documentation(s__fathersBrothersDaughter__m,s__EnglishLanguage,'In Arabic: binot AlEam~. Female cousin on the father side, daughter of fathers brother .') ).

fof(kb_SUMO_180,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__fathersBrothersDaughter(V__P,V__H)
       => ? [V__F,V__UNC] :
            ( s__instance(V__UNC,s__Human)
            & s__instance(V__F,s__Man)
            & s__father(V__P,V__F)
            & s__brother(V__F,V__UNC)
            & s__daughter(V__UNC,V__H) ) ) ) ).

fof(kb_SUMO_181,axiom,
    s__instance(s__mothersBrothersSon__m,s__BinaryRelation) ).

fof(kb_SUMO_182,axiom,
    s__subrelation(s__mothersBrothersSon__m,s__familyRelation__m) ).

fof(kb_SUMO_183,axiom,
    s__documentation(s__mothersBrothersSon__m,s__EnglishLanguage,'In Arabic: Aibon AlxaAl. Male cousin on the mothers side, son of mothers brother.') ).

fof(kb_SUMO_184,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__mothersBrothersSon(V__P,V__H)
       => ? [V__M,V__UNC] :
            ( s__instance(V__UNC,s__Human)
            & s__instance(V__M,s__Man)
            & s__mother(V__P,V__M)
            & s__brother(V__M,V__UNC)
            & s__son(V__UNC,V__H) ) ) ) ).

fof(kb_SUMO_185,axiom,
    s__instance(s__mothersBrothersDaughter__m,s__BinaryRelation) ).

fof(kb_SUMO_186,axiom,
    s__subrelation(s__mothersBrothersDaughter__m,s__familyRelation__m) ).

fof(kb_SUMO_187,axiom,
    s__documentation(s__mothersBrothersDaughter__m,s__EnglishLanguage,'In Arabic: binot AlxaAl. Female cousin on the mothers side, daughter of mothers brother.') ).

fof(kb_SUMO_188,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__mothersBrothersDaughter(V__P,V__H)
       => ? [V__M,V__UNC] :
            ( s__instance(V__UNC,s__Human)
            & s__instance(V__M,s__Man)
            & s__mother(V__P,V__M)
            & s__brother(V__M,V__UNC)
            & s__daughter(V__UNC,V__H) ) ) ) ).

fof(kb_SUMO_189,axiom,
    s__instance(s__fathersSistersSon__m,s__BinaryRelation) ).

fof(kb_SUMO_190,axiom,
    s__subrelation(s__fathersSistersSon__m,s__familyRelation__m) ).

fof(kb_SUMO_191,axiom,
    s__documentation(s__fathersSistersSon__m,s__EnglishLanguage,'In Arabic: Aibon AlEam~ap. Son of fathers sister.') ).

fof(kb_SUMO_192,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__fathersSistersSon(V__P,V__H)
       => ? [V__F,V__AUN] :
            ( s__instance(V__AUN,s__Human)
            & s__instance(V__F,s__Woman)
            & s__father(V__P,V__F)
            & s__sister(V__F,V__AUN)
            & s__son(V__AUN,V__H) ) ) ) ).

fof(kb_SUMO_193,axiom,
    s__instance(s__fathersSistersDaughter__m,s__BinaryRelation) ).

fof(kb_SUMO_194,axiom,
    s__subrelation(s__fathersSistersDaughter__m,s__familyRelation__m) ).

fof(kb_SUMO_195,axiom,
    s__documentation(s__fathersSistersDaughter__m,s__EnglishLanguage,'In Arabic: binot AlEam~ap. Daughter of fathers sister.') ).

fof(kb_SUMO_196,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__fathersSistersDaughter(V__P,V__H)
       => ? [V__F,V__AUN] :
            ( s__instance(V__AUN,s__Human)
            & s__instance(V__F,s__Woman)
            & s__father(V__P,V__F)
            & s__sister(V__F,V__AUN)
            & s__daughter(V__AUN,V__H) ) ) ) ).

fof(kb_SUMO_197,axiom,
    s__instance(s__mothersSistersSon__m,s__BinaryRelation) ).

fof(kb_SUMO_198,axiom,
    s__subrelation(s__mothersSistersSon__m,s__familyRelation__m) ).

fof(kb_SUMO_199,axiom,
    s__documentation(s__mothersSistersSon__m,s__EnglishLanguage,'In Arabic: Aibon AlxaAlap. Son of mothers sister.') ).

fof(kb_SUMO_200,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__mothersSistersSon(V__P,V__H)
       => ? [V__M,V__AUN] :
            ( s__instance(V__AUN,s__Human)
            & s__instance(V__M,s__Woman)
            & s__mother(V__P,V__M)
            & s__sister(V__M,V__AUN)
            & s__son(V__AUN,V__H) ) ) ) ).

fof(kb_SUMO_201,axiom,
    s__instance(s__mothersSistersDaughter__m,s__BinaryRelation) ).

fof(kb_SUMO_202,axiom,
    s__subrelation(s__mothersSistersDaughter__m,s__familyRelation__m) ).

fof(kb_SUMO_203,axiom,
    s__documentation(s__mothersSistersDaughter__m,s__EnglishLanguage,'In Arabic: binot AlxaAlap. Daughter of mothers sister.') ).

fof(kb_SUMO_204,axiom,
    ! [V__P,V__H] :
      ( ( s__instance(V__H,s__Organism)
        & s__instance(V__P,s__Organism) )
     => ( s__mothersSistersDaughter(V__P,V__H)
       => ? [V__M,V__AUN] :
            ( s__instance(V__AUN,s__Human)
            & s__instance(V__M,s__Woman)
            & s__mother(V__P,V__M)
            & s__sister(V__M,V__AUN)
            & s__daughter(V__AUN,V__H) ) ) ) ).

fof(kb_SUMO_205,axiom,
    s__instance(s__BereavedFather,s__Attribute) ).

fof(kb_SUMO_206,axiom,
    s__documentation(s__BereavedFather,s__EnglishLanguage,'In Arabic: vakolAn. A father bereaved of a child (as opposed to (yatiym) or (yatiymap) for feminine: orphan a person whose father or mother died or both father and mother died).') ).

%FOL fof(kb_SUMO_207,axiom,(( (! [V__P,V__T] : ((s__instance(V__T,s__TimeInterval) & s__instance(V__P,s__Organism)) => (s__holdsDuring(V__T,'s__attribute(V__P,s__BereavedFather)') => (? [V__BEFORE,V__C] : (s__instance(V__C,s__Organism) & s__instance(V__BEFORE,s__TimeInterval) & s__earlier(V__BEFORE,V__T) & s__holdsDuring(V__BEFORE,'s__father(V__P,V__C)') & s__holdsDuring(V__T,'s__attribute(V__C,s__Dead)')))))) ))).

fof(kb_SUMO_208,axiom,
    s__instance(s__BereavedMother,s__Attribute) ).

fof(kb_SUMO_209,axiom,
    s__documentation(s__BereavedMother,s__EnglishLanguage,'In Arabic: vakolaY. A mother bereaved of a child (as opposed to orphan a person whose father or mother died or both father and mother died).') ).

%FOL fof(kb_SUMO_210,axiom,(( (! [V__P,V__T] : ((s__instance(V__T,s__TimeInterval) & s__instance(V__P,s__Organism)) => (s__holdsDuring(V__T,'s__attribute(V__P,s__BereavedMother)') => (? [V__BEFORE,V__C] : (s__instance(V__C,s__Organism) & s__instance(V__BEFORE,s__TimeInterval) & s__earlier(V__BEFORE,V__T) & s__holdsDuring(V__BEFORE,'s__mother(V__P,V__C)') & s__holdsDuring(V__T,'s__attribute(V__C,s__Dead)')))))) ))).

fof(kb_SUMO_211,axiom,
    ! [V__C] :
      ( s__instance(V__C,s__Process)
     => ( s__instance(V__C,s__Combustion)
       => ? [V__O] :
            ( s__instance(V__O,s__Object)
            & s__instance(V__O,s__Oxygen)
            & s__resource(V__C,V__O) ) ) ) ).

fof(kb_SUMO_212,axiom,
    s__documentation(s__InternalCombustionEngine,s__EnglishLanguage,'The internal combustion engine is an engine in which the combustion of a fuel (normally a fossil fuel) occurs with an oxidizer (usually air) in a combustion chamber. In an internal combustion engine, the expansion of the high-temperature and high -pressure gases produced by combustion apply direct force to some component of the engine. This force is applied typically to pistons, turbine blades, or a nozzle. This force moves the component over a distance, transforming chemical energy into useful mechanical energy. The term internal combustion engine usually refers to an engine in which combustion is intermittent, such as the more familiar four-stroke and two-stroke piston engines, along with variants, such as the six-stroke piston engine and the Wankel rotary engine. A second class of internal combustion engines use continuous combustion: gas turbines, jet engines and most rocket engines, each of which are internal combustion engines on the same principle as previously described. The internal combustion engine (or ICE) is quite different from external combustion engines, such as steam or Stirling engines, in which the energy is delivered to a working fluid not consisting of, mixed with, or contaminated by combustion products. [from Wikipedia]') ).

fof(kb_SUMO_213,axiom,
    ! [V__I] :
      ( s__instance(V__I,s__Object)
     => ( s__instance(V__I,s__InternalCombustionEngine)
       => s__hasPurpose(V__I,'(? [V__F,V__C] : (s__instance(V__C,s__Process) & s__instance(V__F,s__Object) & s__instance(V__F,s__Fuel) & s__instance(V__C,s__Combustion) & s__instrument(V__C,V__I) & s__resource(V__C,V__F)))') ) ) ).

fof(kb_SUMO_214,axiom,
    ! [V__I] :
      ( s__instance(V__I,s__Object)
     => ( s__instance(V__I,s__InternalCombustionEngine)
       => s__hasPurpose(V__I,'(? [V__C,V__M,V__P] : (s__instance(V__P,s__Object) & s__instance(V__M,s__Process) & s__instance(V__C,s__Combustion) & s__instance(V__M,s__Motion) & s__part(V__P,V__I) & s__patient(V__M,V__P)))') ) ) ).

fof(kb_SUMO_215,axiom,
    s__subclass(s__FuelVapor,s__GasMixture) ).

fof(kb_SUMO_216,axiom,
    s__instance(s__FuelVapor__t,s__SetOrClass) ).

fof(kb_SUMO_217,axiom,
    s__termFormat(s__EnglishLanguage,s__FuelVapor,'fuel vapor') ).

fof(kb_SUMO_218,axiom,
    s__documentation(s__FuelVapor,s__EnglishLanguage,'A mixture of a gas (often &%Air) and fuel, typically produced intentionally in &%Engines for the purpose of &%Combustion.') ).

fof(kb_SUMO_219,axiom,
    ! [V__FV] :
      ( s__instance(V__FV,s__Object)
     => ( s__instance(V__FV,s__FuelVapor)
       => ? [V__F] :
            ( s__instance(V__F,s__Object)
            & s__instance(V__F,s__Fuel)
            & s__part(V__F,V__FV) ) ) ) ).

fof(kb_SUMO_220,axiom,
    s__subclass(s__EngineCycle,s__Motion) ).

fof(kb_SUMO_221,axiom,
    s__instance(s__EngineCycle__t,s__SetOrClass) ).

fof(kb_SUMO_222,axiom,
    s__documentation(s__EngineCycle,s__EnglishLanguage,'A complete cycle of &%Engine phases, including a repeat of the first phase. In a &%FourStrokeEngine this means intake, compression, combustion, exhaust and back to intake.') ).

fof(kb_SUMO_223,axiom,
    s__subclass(s__ContinuousCombustionEngine,s__InternalCombustionEngine) ).

fof(kb_SUMO_224,axiom,
    s__instance(s__ContinuousCombustionEngine__t,s__SetOrClass) ).

fof(kb_SUMO_225,axiom,
    s__documentation(s__ContinuousCombustionEngine,s__EnglishLanguage,'An &%Engine, such as used in a &%Rocket where &%Combustion is continuous, rather than intermittent, as in a modern automobile gas engine.') ).

fof(kb_SUMO_226,axiom,
    s__subclass(s__Turbine,s__InternalCombustionEngine) ).

fof(kb_SUMO_227,axiom,
    s__subclass(s__IntermittentCombustionEngine,s__InternalCombustionEngine) ).

fof(kb_SUMO_228,axiom,
    s__documentation(s__IntermittentCombustionEngine,s__EnglishLanguage,'An &%Engine, such as found in a modern &%Automobile, in which &%Combustion is not continuous, as in a &%Rocket, but rather a rapid series of small &%Explosions.') ).

fof(kb_SUMO_229,axiom,
    s__subclass(s__FourStrokeEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_230,axiom,
    s__instance(s__FourStrokeEngine__t,s__SetOrClass) ).

fof(kb_SUMO_231,axiom,
    s__instance(s__IntermittentCombustionEngine__t,s__SetOrClass) ).

fof(kb_SUMO_232,axiom,
    s__externalImage(s__FourStrokeEngine,'http://upload.wikimedia.org/wikipedia/commons/d/dc/4StrokeEngine_Ortho_3D_Small.gif') ).

fof(kb_SUMO_233,axiom,
    s__termFormat(s__EnglishLanguage,s__FourStrokeEngine,'four stroke engine') ).

fof(kb_SUMO_234,axiom,
    s__documentation(s__FourStrokeEngine,s__EnglishLanguage,'&%InternalCombustionEngines based on the four-stroke (Otto cycle) have one power stroke for every four strokes (up-down-up-down) and employ spark plug ignition. &%Combustion occurs rapidly, and during combustion the volume varies little (constant volume). They are used in cars, larger boats, some motorcycles, and many light aircraft. They are generally quieter, more efficient, and larger than their &%TwoStrokeEngine counterparts. [from Wikipedia]') ).

fof(kb_SUMO_235,axiom,
    ! [V__FSE] :
      ( s__instance(V__FSE,s__Object)
     => ( s__instance(V__FSE,s__FourStrokeEngine)
       => ? [V__C] :
            ( s__instance(V__C,s__Object)
            & s__instance(V__C,s__EngineCylinder)
            & s__part(V__C,V__FSE) ) ) ) ).

fof(kb_SUMO_236,axiom,
    ! [V__FSE] :
      ( s__instance(V__FSE,s__Object)
     => ( s__instance(V__FSE,s__FourStrokeEngine)
       => s__hasPurpose(V__FSE,'(? [V__I,V__CM,V__CB,V__E,V__I2] : (s__instance(V__I2,s__Process) & s__instance(V__I2,s__TimeInterval) & s__instance(V__E,s__Process) & s__instance(V__E,s__TimeInterval) & s__instance(V__CB,s__Process) & s__instance(V__CB,s__TimeInterval) & s__instance(V__CM,s__Process) & s__instance(V__CM,s__TimeInterval) & s__instance(V__I,s__Process) & s__instance(V__I,s__TimeInterval) & s__instance(V__I,s__FourStrokeIntake) & s__instance(V__CM,s__FourStrokeCompression) & s__instance(V__CB,s__FourStrokeCombustion) & s__instance(V__E,s__FourStrokeExhaust) & s__instance(V__I2,s__FourStrokeIntake) & s__eventLocated(V__I,V__FSE) & s__eventLocated(V__CM,V__FSE) & s__eventLocated(V__CB,V__FSE) & s__eventLocated(V__E,V__FSE) & s__eventLocated(V__I2,V__FSE) & s__meetsTemporally(V__I,V__CM) & s__meetsTemporally(V__CM,V__CB) & s__meetsTemporally(V__CB,V__E) & s__meetsTemporally(V__E,V__I2)))') ) ) ).

fof(kb_SUMO_237,axiom,
    s__subclass(s__FourStrokeEngineCycle,s__EngineCycle) ).

fof(kb_SUMO_238,axiom,
    s__instance(s__FourStrokeEngineCycle__t,s__SetOrClass) ).

fof(kb_SUMO_239,axiom,
    s__termFormat(s__EnglishLanguage,s__FourStrokeEngineCycle,'four stroke engine cycle') ).

fof(kb_SUMO_240,axiom,
    s__documentation(s__FourStrokeEngineCycle,s__EnglishLanguage,'The &%Processes that occur in a &%FourStrokeEngine. Such a cycle necessarily includes each instance of one of the four strokes, in sequence, followed by another intake stroke.') ).

fof(kb_SUMO_241,axiom,
    ! [V__F] :
      ( s__instance(V__F,s__Process)
     => ( s__instance(V__F,s__FourStrokeEngineCycle)
       => ? [V__E] :
            ( s__instance(V__E,s__Object)
            & s__instance(V__E,s__FourStrokeEngine)
            & s__eventLocated(V__F,V__E) ) ) ) ).

fof(kb_SUMO_242,axiom,
    ! [V__FSE] :
      ( s__instance(V__FSE,s__Process)
     => ( s__instance(V__FSE,s__FourStrokeEngineCycle)
       => ? [V__I,V__CM,V__CB,V__E,V__I2] :
            ( s__instance(V__I2,s__Process)
            & s__instance(V__I2,s__TimeInterval)
            & s__instance(V__E,s__Process)
            & s__instance(V__E,s__TimeInterval)
            & s__instance(V__CB,s__Process)
            & s__instance(V__CB,s__TimeInterval)
            & s__instance(V__CM,s__Process)
            & s__instance(V__CM,s__TimeInterval)
            & s__instance(V__I,s__Process)
            & s__instance(V__I,s__TimeInterval)
            & s__instance(V__I,s__FourStrokeIntake)
            & s__instance(V__CM,s__FourStrokeCompression)
            & s__instance(V__CB,s__FourStrokeCombustion)
            & s__instance(V__E,s__FourStrokeExhaust)
            & s__instance(V__I2,s__FourStrokeIntake)
            & s__subProcess(V__I,V__FSE)
            & s__subProcess(V__CM,V__FSE)
            & s__subProcess(V__CB,V__FSE)
            & s__subProcess(V__E,V__FSE)
            & s__subProcess(V__I2,V__FSE)
            & s__meetsTemporally(V__I,V__CM)
            & s__meetsTemporally(V__CM,V__CB)
            & s__meetsTemporally(V__CB,V__E)
            & s__meetsTemporally(V__E,V__I2) ) ) ) ).

fof(kb_SUMO_243,axiom,
    s__subclass(s__FourStrokeIntake,s__Motion) ).

fof(kb_SUMO_244,axiom,
    s__instance(s__FourStrokeIntake__t,s__SetOrClass) ).

fof(kb_SUMO_245,axiom,
    s__termFormat(s__EnglishLanguage,s__FourStrokeIntake,'four stroke intake') ).

fof(kb_SUMO_246,axiom,
    s__documentation(s__FourStrokeIntake,s__EnglishLanguage,'In this cycle of a four stroke engine, air and vaporized fuel are drawn in.') ).

fof(kb_SUMO_247,axiom,
    ! [V__C,V__F,V__I] :
      ( ( s__instance(V__I,s__Hole)
        & s__instance(V__F,s__Process)
        & s__instance(V__C,s__Object) )
     => ( ( s__instance(V__F,s__FourStrokeIntake)
          & s__instance(V__C,s__EngineCylinder)
          & s__instance(V__I,s__InternalCombustionChamber)
          & V__C = s__HoleHostFn(V__I)
          & s__eventLocated(V__F,V__C) )
       => ? [V__FV,V__M] :
            ( s__instance(V__M,s__Process)
            & s__instance(V__M,s__GasMotion)
            & s__instance(V__FV,s__FuelVapor)
            & s__subProcess(V__M,V__F)
            & s__destination(V__M,V__I)
            & s__patient(V__M,V__FV) ) ) ) ).

fof(kb_SUMO_248,axiom,
    s__subclass(s__FourStrokeCompression,s__Motion) ).

fof(kb_SUMO_249,axiom,
    s__instance(s__FourStrokeCompression__t,s__SetOrClass) ).

fof(kb_SUMO_250,axiom,
    s__termFormat(s__EnglishLanguage,s__FourStrokeCompression,'four stroke compression') ).

fof(kb_SUMO_251,axiom,
    s__documentation(s__FourStrokeCompression,s__EnglishLanguage,'In this cycle of a four stroke engine, fuel vapor and air are compressed and ignited.') ).

%FOL fof(kb_SUMO_252,axiom,(( (! [V__C,V__F,V__I] : ((s__instance(V__I,s__Hole) & s__instance(V__F,s__Process) & s__instance(V__C,s__Object)) => ((s__instance(V__F,s__FourStrokeCompression) & s__instance(V__C,s__EngineCylinder) & s__instance(V__I,s__InternalCombustionChamber) & (V__C = s__HoleHostFn(V__I)) & s__eventLocated(V__F,V__C)) => s__holdsDuring(s__EndFn(s__WhenFn(V__F)),'s__attribute(V__I,s__Pressurized)')))) ))).

fof(kb_SUMO_253,axiom,
    s__subclass(s__FourStrokeCombustion,s__Motion) ).

fof(kb_SUMO_254,axiom,
    s__instance(s__FourStrokeCombustion__t,s__SetOrClass) ).

fof(kb_SUMO_255,axiom,
    s__termFormat(s__EnglishLanguage,s__FourStrokeCombustion,'four stroke combustion') ).

fof(kb_SUMO_256,axiom,
    s__documentation(s__FourStrokeCombustion,s__EnglishLanguage,'In this cycle of a four stroke engine, fuel combusts and piston is pushed downwards.') ).

fof(kb_SUMO_257,axiom,
    ! [V__C,V__F,V__I] :
      ( ( s__instance(V__I,s__Hole)
        & s__instance(V__F,s__Process)
        & s__instance(V__C,s__Object) )
     => ( ( s__instance(V__F,s__FourStrokeCombustion)
          & s__instance(V__C,s__EngineCylinder)
          & s__instance(V__I,s__InternalCombustionChamber)
          & V__C = s__HoleHostFn(V__I)
          & s__eventLocated(V__F,V__C) )
       => ? [V__CO] :
            ( s__instance(V__CO,s__Process)
            & s__instance(V__CO,s__Combustion)
            & s__subProcess(V__CO,V__F) ) ) ) ).

fof(kb_SUMO_258,axiom,
    s__subclass(s__FourStrokeExhaust,s__Motion) ).

fof(kb_SUMO_259,axiom,
    s__instance(s__FourStrokeExhaust__t,s__SetOrClass) ).

fof(kb_SUMO_260,axiom,
    s__termFormat(s__EnglishLanguage,s__FourStrokeExhaust,'four stroke exhaust') ).

fof(kb_SUMO_261,axiom,
    s__documentation(s__FourStrokeExhaust,s__EnglishLanguage,'In this cycle of a four stroke engine, exhaust is driven out. During the 1st, 2nd, and 4th stroke the piston is relying on power and the momentum generated by the other pistons.') ).

fof(kb_SUMO_262,axiom,
    ! [V__C,V__F,V__I] :
      ( ( s__instance(V__I,s__Hole)
        & s__instance(V__F,s__Process)
        & s__instance(V__C,s__Object) )
     => ( ( s__instance(V__F,s__FourStrokeExhaust)
          & s__instance(V__C,s__EngineCylinder)
          & s__instance(V__I,s__InternalCombustionChamber)
          & V__C = s__HoleHostFn(V__I)
          & s__eventLocated(V__F,V__C) )
       => ? [V__E,V__M] :
            ( s__instance(V__M,s__Process)
            & s__instance(V__M,s__GasMotion)
            & s__instance(V__E,s__Exhaust)
            & s__subProcess(V__M,V__F)
            & s__origin(V__M,V__I)
            & s__patient(V__M,V__E) ) ) ) ).

fof(kb_SUMO_263,axiom,
    s__subclass(s__TwoStrokeEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_264,axiom,
    s__instance(s__TwoStrokeEngine__t,s__SetOrClass) ).

fof(kb_SUMO_265,axiom,
    s__termFormat(s__EnglishLanguage,s__TwoStrokeEngine,'two stroke engine') ).

fof(kb_SUMO_266,axiom,
    s__documentation(s__TwoStrokeEngine,s__EnglishLanguage,'Engines based on the two-stroke cycle use two strokes (one up, one down) for every power stroke. Since there are no dedicated intake or exhaust strokes, alternative methods must be used to scavenge the cylinders. The most common method in spark-ignition two-strokes is to use the downward motion of the piston to pressurize fresh charge in the &%Crankcase, which is then blown through the &%Cylinder through ports in the cylinder walls. [from Wikipedia]') ).

fof(kb_SUMO_267,axiom,
    s__subclass(s__TwoStrokeEngineCycle,s__EngineCycle) ).

fof(kb_SUMO_268,axiom,
    s__instance(s__TwoStrokeEngineCycle__t,s__SetOrClass) ).

fof(kb_SUMO_269,axiom,
    s__termFormat(s__EnglishLanguage,s__TwoStrokeEngineCycle,'two stroke engine cycle') ).

fof(kb_SUMO_270,axiom,
    s__documentation(s__TwoStrokeEngineCycle,s__EnglishLanguage,'The &%Processes that occur in a &%TwoStrokeEngine. Such a cycle necessarily includes each instance of one of the strokes, in sequence, followed by another intake stroke.') ).

fof(kb_SUMO_271,axiom,
    ! [V__F] :
      ( s__instance(V__F,s__Process)
     => ( s__instance(V__F,s__TwoStrokeEngineCycle)
       => ? [V__E] :
            ( s__instance(V__E,s__Object)
            & s__instance(V__E,s__TwoStrokeEngine)
            & s__eventLocated(V__F,V__E) ) ) ) ).

fof(kb_SUMO_272,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__TwoStrokeEngineCycle)
     => ? [V__I,V__C,V__T,V__I2] :
          ( s__instance(V__I2,s__Process)
          & s__instance(V__I2,s__TimeInterval)
          & s__instance(V__T,s__Process)
          & s__instance(V__T,s__TimeInterval)
          & s__instance(V__C,s__Process)
          & s__instance(V__C,s__TimeInterval)
          & s__instance(V__I,s__Process)
          & s__instance(V__I,s__TimeInterval)
          & s__instance(V__I,s__TwoStrokeIntake)
          & s__instance(V__C,s__TwoStrokeCompression)
          & s__instance(V__T,s__TwoStrokeTransfer)
          & s__instance(V__I2,s__TwoStrokeIntake)
          & s__subProcess(V__I,V__T)
          & s__subProcess(V__C,V__T)
          & s__subProcess(V__T,V__T)
          & s__subProcess(V__I2,V__T)
          & s__meetsTemporally(V__I,V__C)
          & s__meetsTemporally(V__C,V__T)
          & s__meetsTemporally(V__T,V__I2) ) ) ).

fof(kb_SUMO_273,axiom,
    ! [V__I] :
      ( s__instance(V__I,s__Object)
     => ( s__instance(V__I,s__IntermittentCombustionEngine)
       => s__hasPurpose(V__I,'(? [V__E,V__M] : (s__instance(V__M,s__Process) & s__instance(V__E,s__Process) & s__instance(V__E,s__Explosion) & s__instance(V__M,s__Motion) & s__eventLocated(V__E,V__I) & s__eventLocated(V__M,V__I) & s__causes(V__E,V__M)))') ) ) ).

fof(kb_SUMO_274,axiom,
    s__subclass(s__Piston,s__Artifact) ).

fof(kb_SUMO_275,axiom,
    s__instance(s__Piston__t,s__SetOrClass) ).

fof(kb_SUMO_276,axiom,
    s__termFormat(s__EnglishLanguage,s__Piston,piston) ).

fof(kb_SUMO_277,axiom,
    s__documentation(s__Piston,s__EnglishLanguage,'A piston is a component of reciprocating engines, reciprocating pumps, gas compressors and pneumatic cylinders, among other similar mechanisms. It is the moving component that is contained by a cylinder and is made gas- tight by piston rings. In an engine, its purpose is to transfer force from expanding gas in the cylinder to the crankshaft via a piston rod and/or connecting rod. In a pump, the function is reversed and force is transferred from the crankshaft to the piston for the purpose of compressing or ejecting the fluid in the cylinder. In some engines, the piston also acts as a valve by covering and uncovering ports in the cylinder wall.') ).

fof(kb_SUMO_278,axiom,
    s__externalImage(s__Piston,'http://upload.wikimedia.org/wikipedia/commons/thumb/d/d4/Piston.gif/73px-Piston.gif') ).

fof(kb_SUMO_279,axiom,
    s__subclass(s__EngineCylinder,s__Artifact) ).

fof(kb_SUMO_280,axiom,
    s__instance(s__EngineCylinder__t,s__SetOrClass) ).

fof(kb_SUMO_281,axiom,
    s__documentation(s__EngineCylinder,s__EnglishLanguage,'A single cylinder of an &%Engine block and its associated components.') ).

fof(kb_SUMO_282,axiom,
    s__subclass(s__InternalCombustionChamber,s__Hole) ).

fof(kb_SUMO_283,axiom,
    s__instance(s__InternalCombustionChamber__t,s__SetOrClass) ).

fof(kb_SUMO_284,axiom,
    s__termFormat(s__EnglishLanguage,s__InternalCombustionChamber,'internal combustion chamber') ).

fof(kb_SUMO_285,axiom,
    s__documentation(s__InternalCombustionChamber,s__EnglishLanguage,'The &%Hole that is part of a &%Cylinder in which &%Cumbustion occurs, forcing gases to expand and expelling the piston, to generate power.') ).

fof(kb_SUMO_286,axiom,
    ! [V__E] :
      ( s__instance(V__E,s__EngineCylinder)
     => ? [V__H] :
          ( s__instance(V__H,s__Hole)
          & s__instance(V__H,s__InternalCombustionChamber)
          & V__E = s__HoleHostFn(V__H) ) ) ).

fof(kb_SUMO_287,axiom,
    s__subclass(s__Crankcase,s__Hole) ).

fof(kb_SUMO_288,axiom,
    s__instance(s__Crankcase__t,s__SetOrClass) ).

fof(kb_SUMO_289,axiom,
    s__documentation(s__Crankcase,s__EnglishLanguage,'A &%Hole in an &%InternalCombustionEngine where the &%Piston rods join with the &%Crankshaft.') ).

fof(kb_SUMO_290,axiom,
    ! [V__E] :
      ( s__instance(V__E,s__Engine)
     => ? [V__C] :
          ( s__instance(V__C,s__Hole)
          & s__instance(V__C,s__Crankcase)
          & V__E = s__HoleHostFn(V__C) ) ) ).

fof(kb_SUMO_291,axiom,
    s__subclass(s__Crankshaft,s__Shaft) ).

fof(kb_SUMO_292,axiom,
    s__instance(s__Crankshaft__t,s__SetOrClass) ).

fof(kb_SUMO_293,axiom,
    s__instance(s__Shaft__t,s__SetOrClass) ).

fof(kb_SUMO_294,axiom,
    s__documentation(s__Crankshaft,s__EnglishLanguage,'The output of the effort of a &%Engine. It is a rotating rod that transfers power to other &%Devices.') ).

fof(kb_SUMO_295,axiom,
    s__typicalPart(s__Crankshaft,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_296,axiom,
    s__typicallyContainsPart(s__Crankshaft,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_297,axiom,
    s__typicalPart(s__Crankshaft,s__Crankcase) ).

fof(kb_SUMO_298,axiom,
    s__typicallyContainsPart(s__Crankshaft,s__Crankcase) ).

fof(kb_SUMO_299,axiom,
    s__typicalPart(s__Piston,s__EngineCylinder) ).

fof(kb_SUMO_300,axiom,
    s__typicallyContainsPart(s__Piston,s__EngineCylinder) ).

fof(kb_SUMO_301,axiom,
    s__relatedInternalConcept(s__typicallyContainsPart__m,s__typicalPart__m) ).

fof(kb_SUMO_302,axiom,
    ! [V__C,V__I] :
      ( ( s__instance(V__I,s__Object)
        & s__instance(V__C,s__Object) )
     => ( ( s__instance(V__C,s__Crankshaft)
          & s__instance(V__I,s__IntermittentCombustionEngine)
          & s__part(V__I,V__C) )
       => s__hasPurpose(V__C,'(? [V__E,V__R] : (s__instance(V__R,s__Process) & s__instance(V__E,s__Process) & s__instance(V__E,s__Explosion) & s__instance(V__R,s__Rotating) & s__patient(V__R,V__C) & s__eventLocated(V__R,V__I) & s__causes(V__E,V__R)))') ) ) ).

fof(kb_SUMO_303,axiom,
    s__instance(s__Vacuum,s__InternalAttribute) ).

fof(kb_SUMO_304,axiom,
    s__termFormat(s__EnglishLanguage,s__Vacuum,vacuum) ).

fof(kb_SUMO_305,axiom,
    s__documentation(s__Vacuum,s__EnglishLanguage,'An area of space in which does not contain any matter.') ).

fof(kb_SUMO_306,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Object)
     => ( ( s__instance(V__X,s__Region)
          & s__attribute(V__X,s__Vacuum) )
       => ~ ? [V__O] :
              ( s__instance(V__O,s__Physical)
              & s__instance(V__O,s__Object)
              & s__located(V__O,V__X) ) ) ) ).

fof(kb_SUMO_307,axiom,
    s__instance(s__PartialVacuum,s__RelationalAttribute) ).

fof(kb_SUMO_308,axiom,
    s__termFormat(s__EnglishLanguage,s__PartialVacuum,'partial vacuum') ).

fof(kb_SUMO_309,axiom,
    s__documentation(s__PartialVacuum,s__EnglishLanguage,'An area of space which is at a lower pressure than surrounding regions.') ).

fof(kb_SUMO_310,axiom,
    ! [V__P2,V__P1,V__PM,V__X] :
      ( ( s__instance(V__X,s__Object)
        & s__instance(V__PM,s__RealNumber)
        & s__instance(V__P1,s__UnitOfMeasure)
        & s__instance(V__P2,s__UnitOfMeasure) )
     => ( s__attribute(V__X,s__PartialVacuum)
       => ? [V__O,V__G] :
            ( s__instance(V__G,s__Object)
            & s__instance(V__O,s__Object)
            & s__instance(V__O,s__SelfConnectedObject)
            & s__instance(V__G,s__Region)
            & V__G != V__X
            & s__connected(V__X,V__O)
            & s__connected(V__G,V__O)
            & s__measure(V__G,s__MeasureFn(V__PM,V__P1))
            & s__measure(V__X,s__MeasureFn(V__PM,V__P2))
            & s__instance(V__PM,s__UnitOfAtmosphericPressure)
            & greater(V__P1,V__P2) ) ) ) ).

fof(kb_SUMO_311,axiom,
    s__instance(s__Pressurized,s__RelationalAttribute) ).

fof(kb_SUMO_312,axiom,
    s__termFormat(s__EnglishLanguage,s__Pressurized,pressurized) ).

fof(kb_SUMO_313,axiom,
    s__documentation(s__Pressurized,s__EnglishLanguage,'An area of space which is at a higher pressure than surrounding regions.') ).

fof(kb_SUMO_314,axiom,
    ! [V__P2,V__P1,V__PM,V__X] :
      ( ( s__instance(V__X,s__Object)
        & s__instance(V__PM,s__RealNumber)
        & s__instance(V__P1,s__UnitOfMeasure)
        & s__instance(V__P2,s__UnitOfMeasure) )
     => ( s__attribute(V__X,s__Pressurized)
       => ? [V__O,V__G] :
            ( s__instance(V__G,s__Object)
            & s__instance(V__O,s__Object)
            & s__instance(V__O,s__SelfConnectedObject)
            & s__instance(V__G,s__Region)
            & V__G != V__X
            & s__connected(V__X,V__O)
            & s__connected(V__G,V__O)
            & s__measure(V__G,s__MeasureFn(V__PM,V__P1))
            & s__measure(V__X,s__MeasureFn(V__PM,V__P2))
            & s__instance(V__PM,s__UnitOfAtmosphericPressure)
            & greater(V__P2,V__P1) ) ) ) ).

fof(kb_SUMO_315,axiom,
    s__subclass(s__Spark,s__ElectricTransmission) ).

fof(kb_SUMO_316,axiom,
    s__instance(s__Spark__t,s__SetOrClass) ).

fof(kb_SUMO_317,axiom,
    s__termFormat(s__EnglishLanguage,s__Spark,spark) ).

fof(kb_SUMO_318,axiom,
    s__documentation(s__Spark,s__EnglishLanguage,'An electric charge that moves from point to point across an &%Air gap, rather than travelling through a solid conductor.') ).

fof(kb_SUMO_319,axiom,
    s__subclass(s__Lightning,s__Spark) ).

fof(kb_SUMO_320,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Process)
     => ( s__instance(V__S,s__Spark)
       => ? [V__E,V__G] :
            ( s__instance(V__G,s__Object)
            & s__instance(V__E,s__Electricity)
            & s__patient(V__S,V__E)
            & s__instance(V__G,s__Substance)
            & s__attribute(V__G,s__Gas)
            & s__eventLocated(V__S,V__G) ) ) ) ).

fof(kb_SUMO_321,axiom,
    s__subclass(s__SparkPlug,s__ElectricalComponent) ).

fof(kb_SUMO_322,axiom,
    s__instance(s__SparkPlug__t,s__SetOrClass) ).

fof(kb_SUMO_323,axiom,
    s__instance(s__ElectricalComponent__t,s__SetOrClass) ).

fof(kb_SUMO_324,axiom,
    s__termFormat(s__EnglishLanguage,s__SparkPlug,'spark plug') ).

fof(kb_SUMO_325,axiom,
    s__documentation(s__SparkPlug,s__EnglishLanguage,'A device, used to ignite &%Fuel, that generates a &%Spark.') ).

fof(kb_SUMO_326,axiom,
    ! [V__SP] :
      ( s__instance(V__SP,s__Object)
     => ( s__instance(V__SP,s__SparkPlug)
       => s__hasPurpose(V__SP,'(? [V__S] : (s__instance(V__S,s__Process) & s__instance(V__S,s__Spark) & s__instrument(V__S,V__SP)))') ) ) ).

fof(kb_SUMO_327,axiom,
    ! [V__SP] :
      ( s__instance(V__SP,s__Object)
     => ( s__instance(V__SP,s__SparkPlug)
       => s__hasPurpose(V__SP,'(? [V__S,V__C] : (s__instance(V__C,s__Process) & s__instance(V__S,s__Process) & s__instance(V__S,s__Spark) & s__instrument(V__S,V__SP) & s__instance(V__C,s__Combustion) & s__causes(V__S,V__C)))') ) ) ).

fof(kb_SUMO_328,axiom,
    s__subclass(s__TwoStrokeIntake,s__Motion) ).

fof(kb_SUMO_329,axiom,
    s__instance(s__TwoStrokeIntake__t,s__SetOrClass) ).

fof(kb_SUMO_330,axiom,
    s__termFormat(s__EnglishLanguage,s__TwoStrokeIntake,'two stroke intake') ).

fof(kb_SUMO_331,axiom,
    s__documentation(s__TwoStrokeIntake,s__EnglishLanguage,'The portion of a two stroke engine cycle where the piston moves into the combustion chamber creating a partial vacuum in the crankcase that draws fuel into the crankcase.') ).

%FOL fof(kb_SUMO_332,axiom,(( (! [V__P,V__T,V__E,V__I] : ((s__instance(V__I,s__Hole) & s__instance(V__E,s__Object) & s__instance(V__T,s__TimePosition) & s__instance(V__T,s__Process) & s__instance(V__P,s__Object)) => ((s__instance(V__E,s__EngineCylinder) & s__instance(V__I,s__InternalCombustionChamber) & s__instance(V__P,s__Piston) & s__instance(V__T,s__TwoStrokeIntake) & s__holdsDuring(V__T,'s__located(V__P,V__E)') & (V__E = s__HoleHostFn(V__I)) & s__eventLocated(V__T,V__E)) => s__hasPurpose(V__P,'s__holdsDuring(V__T,s__partiallyFills(V__P,V__I))')))) ))).

%FOL fof(kb_SUMO_333,axiom,(( (! [V__C,V__TSC,V__TSI] : ((s__instance(V__TSI,s__TimePosition) & s__instance(V__TSC,s__Process) & s__instance(V__C,s__Object)) => ((s__instance(V__TSI,s__TwoStrokeIntake) & s__instance(V__C,s__Crankcase) & s__eventPartlyLocated(V__TSC,V__C)) => s__holdsDuring(V__TSI,'s__attribute(V__C,s__PartialVacuum)')))) ))).

fof(kb_SUMO_334,axiom,
    s__subclass(s__TwoStrokeCompression,s__Motion) ).

fof(kb_SUMO_335,axiom,
    s__instance(s__TwoStrokeCompression__t,s__SetOrClass) ).

fof(kb_SUMO_336,axiom,
    s__termFormat(s__EnglishLanguage,s__TwoStrokeCompression,'two stroke compression') ).

fof(kb_SUMO_337,axiom,
    s__documentation(s__TwoStrokeCompression,s__EnglishLanguage,'The portion of a two stroke engine cycle where combustion occurs, forcing the piston out of the combustion chamber, and the fuel mixture is compressed in the crankcase.') ).

fof(kb_SUMO_338,axiom,
    ! [V__TSC,V__E] :
      ( ( s__instance(V__E,s__Object)
        & s__instance(V__TSC,s__Process)
        & s__instance(V__TSC,s__TimeInterval) )
     => ( ( s__instance(V__TSC,s__TwoStrokeCompression)
          & s__eventLocated(V__TSC,V__E)
          & s__instance(V__E,s__TwoStrokeEngine) )
       => ? [V__C] :
            ( s__instance(V__C,s__TimeInterval)
            & s__instance(V__C,s__Process)
            & s__instance(V__C,s__Explosion)
            & s__during(V__C,V__TSC)
            & s__eventLocated(V__C,V__E) ) ) ) ).

fof(kb_SUMO_339,axiom,
    s__subclass(s__TwoStrokeTransfer,s__Motion) ).

fof(kb_SUMO_340,axiom,
    s__instance(s__TwoStrokeTransfer__t,s__SetOrClass) ).

fof(kb_SUMO_341,axiom,
    s__termFormat(s__EnglishLanguage,s__TwoStrokeTransfer,'two stroke transfer') ).

fof(kb_SUMO_342,axiom,
    s__documentation(s__TwoStrokeTransfer,s__EnglishLanguage,'The portion of a two stroke engine cycle where the combustion chamber is opened to the crankcase and the exhaust. This allows the exhaust to vent, and the pressurized fuel mixture to enter the combustion chamber. The piston is most fully removed from the combustion chamber at this point.') ).

%FOL fof(kb_SUMO_343,axiom,(( (! [V__P,V__T,V__C,V__E] : ((s__instance(V__E,s__Object) & s__instance(V__C,s__Hole) & s__instance(V__T,s__TimePosition) & s__instance(V__T,s__Process) & s__instance(V__P,s__Object)) => ((s__instance(V__E,s__EngineCylinder) & s__instance(V__C,s__Crankcase) & s__instance(V__P,s__Piston) & s__instance(V__T,s__TwoStrokeTransfer) & s__holdsDuring(V__T,'s__located(V__P,V__E)') & (V__E = s__HoleHostFn(V__C)) & s__eventLocated(V__T,V__E)) => s__hasPurpose(V__P,'s__holdsDuring(V__T,s__partiallyFills(V__P,V__C))')))) ))).

fof(kb_SUMO_344,axiom,
    ! [V__C,V__T,V__F,V__I] :
      ( ( s__instance(V__I,s__Hole)
        & s__instance(V__F,s__Process)
        & s__instance(V__T,s__Process)
        & s__instance(V__C,s__Object) )
     => ( ( s__instance(V__T,s__TwoStrokeTransfer)
          & s__instance(V__C,s__EngineCylinder)
          & s__instance(V__I,s__InternalCombustionChamber)
          & V__C = s__HoleHostFn(V__I)
          & s__eventLocated(V__F,V__C) )
       => ? [V__E,V__M] :
            ( s__instance(V__M,s__Process)
            & s__instance(V__M,s__GasMotion)
            & s__instance(V__E,s__Exhaust)
            & s__subProcess(V__M,V__T)
            & s__origin(V__M,V__I)
            & s__patient(V__M,V__E) ) ) ) ).

fof(kb_SUMO_345,axiom,
    s__subclass(s__Brake,s__Device) ).

fof(kb_SUMO_346,axiom,
    s__termFormat(s__EnglishLanguage,s__Brake,brake) ).

fof(kb_SUMO_347,axiom,
    s__documentation(s__Brake,s__EnglishLanguage,'Any device that is designed to slow and stop the &%Motion of an object. This include brakes on wheeled vehicles as well as rock climbing equipment that uses friction to slow decent when rappelling.') ).

fof(kb_SUMO_348,axiom,
    ! [V__B] :
      ( s__instance(V__B,s__Object)
     => ( s__instance(V__B,s__Brake)
       => s__hasPurpose(V__B,'(? [V__D] : (s__instance(V__D,s__Process) & s__instance(V__D,s__Decelerating) & s__instrument(V__D,V__B)))') ) ) ).

fof(kb_SUMO_349,axiom,
    s__subclass(s__VehicleBrake,s__Brake) ).

fof(kb_SUMO_350,axiom,
    s__instance(s__Brake__t,s__SetOrClass) ).

fof(kb_SUMO_351,axiom,
    s__subclass(s__ParkingBrake,s__VehicleBrake) ).

fof(kb_SUMO_352,axiom,
    s__instance(s__ParkingBrake__t,s__SetOrClass) ).

fof(kb_SUMO_353,axiom,
    s__termFormat(s__EnglishLanguage,s__ParkingBrake,'parking brake') ).

fof(kb_SUMO_354,axiom,
    s__documentation(s__ParkingBrake,s__EnglishLanguage,'A kind of brake chiefly designed to prevent motion from occuring in a stopped vehicle, although it can be used to slow a vehicle that is in motion. Most other types of brakes are designed to be used intermittently to slow a vehicle, or only temporarily to keep a vehicle stationary, while the driver is applying the brake. In contrast, most parking brakes employ some sort of ratcheting system so the parking brake may remain active even when the driver is not applying force to a braking actuator, or even being present in the vehicle. Typically, it is implemented as a &%DrumBrake in most modern passenger vehicles.') ).

fof(kb_SUMO_355,axiom,
    s__typicallyContainsPart(s__ParkingBrake,s__DrumBrake) ).

%FOL fof(kb_SUMO_356,axiom,(( (! [V__P,V__E,V__V] : ((s__instance(V__V,s__Object) & s__instance(V__E,s__TimePosition) & s__instance(V__P,s__Object)) => ((s__instance(V__P,s__ParkingBrake) & s__instance(V__V,s__Vehicle) & s__part(V__P,V__V)) => s__hasPurpose(V__P,'s__holdsDuring(V__E,(s__attribute(V__P,s__DeviceOn) & (~ (? [V__T] : (s__instance(V__T,s__Process) & s__instance(V__T,s__Translocation) & s__patient(V__T,V__V))))))')))) ))).

fof(kb_SUMO_357,axiom,
    s__subclass(s__WearingFrictionSurface,s__Device) ).

fof(kb_SUMO_358,axiom,
    s__instance(s__WearingFrictionSurface__t,s__SetOrClass) ).

fof(kb_SUMO_359,axiom,
    s__termFormat(s__EnglishLanguage,s__WearingFrictionSurface,'wearing friction surface') ).

fof(kb_SUMO_360,axiom,
    s__documentation(s__WearingFrictionSurface,s__EnglishLanguage,'A device designed to cause friction and exhibit a particular process of wear. This includes items such as brake pads and match striking surfaces on a matchbox.') ).

fof(kb_SUMO_361,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__instance(V__S,s__WearingFrictionSurface)
       => s__hasPurpose(V__S,'(? [V__F] : (s__instance(V__F,s__Process) & s__instance(V__F,s__Friction) & s__resource(V__F,V__S)))') ) ) ).

fof(kb_SUMO_362,axiom,
    s__subclass(s__BrakeShoe,s__WearingFrictionSurface) ).

fof(kb_SUMO_363,axiom,
    s__instance(s__BrakeShoe__t,s__SetOrClass) ).

fof(kb_SUMO_364,axiom,
    s__documentation(s__BrakeShoe,s__EnglishLanguage,'A &%WearingFrictionSurface that is designed to press against a rotating &%BrakeDrum to cause vehicle braking.') ).

fof(kb_SUMO_365,axiom,
    s__termFormat(s__EnglishLanguage,s__BrakeShoe,'brake shoe') ).

fof(kb_SUMO_366,axiom,
    s__typicalPart(s__BrakeShoe,s__DrumBrake) ).

fof(kb_SUMO_367,axiom,
    s__subclass(s__DrumBrake,s__VehicleBrake) ).

fof(kb_SUMO_368,axiom,
    s__instance(s__DrumBrake__t,s__SetOrClass) ).

fof(kb_SUMO_369,axiom,
    s__documentation(s__DrumBrake,s__EnglishLanguage,'A &%Brake in which a &%BrakeShoe presses against a rotating &%BrakeDrum to cause vehicle braking.') ).

fof(kb_SUMO_370,axiom,
    s__termFormat(s__EnglishLanguage,s__DrumBrake,'drum brake') ).

fof(kb_SUMO_371,axiom,
    ! [V__B,V__BR] :
      ( s__instance(V__B,s__Object)
     => ( s__instance(V__B,s__BrakePad)
       => s__hasPurpose(V__B,'(? [V__F,V__BS] : (s__instance(V__F,s__Process) & s__instance(V__F,s__Friction) & s__resource(V__F,V__B) & s__instance(V__BR,s__BrakeRotor) & s__patient(V__F,V__BS)))') ) ) ).

fof(kb_SUMO_372,axiom,
    ! [V__R,V__BR,V__F,V__BP] :
      ( ( s__instance(V__BP,s__Object)
        & s__instance(V__F,s__Process)
        & s__instance(V__R,s__Process) )
     => ( ( s__instance(V__BP,s__BrakePad)
          & s__instance(V__BR,s__BrakeRotor)
          & s__instance(V__R,s__Rotating)
          & s__patient(V__R,V__BR)
          & s__instance(V__F,s__Friction)
          & s__resource(V__F,V__BP)
          & s__patient(V__F,V__BR) )
       => ~ s__patient(V__R,V__BP) ) ) ).

fof(kb_SUMO_373,axiom,
    ! [V__B] :
      ( s__instance(V__B,s__Object)
     => ( s__instance(V__B,s__BrakeShoe)
       => s__hasPurpose(V__B,'(? [V__F,V__BD] : (s__instance(V__F,s__Process) & s__instance(V__F,s__Friction) & s__resource(V__F,V__B) & s__instance(V__BD,s__BrakeDrum) & s__patient(V__F,V__BD)))') ) ) ).

fof(kb_SUMO_374,axiom,
    ! [V__R,V__F,V__BD,V__BS] :
      ( ( s__instance(V__BS,s__Object)
        & s__instance(V__F,s__Process)
        & s__instance(V__R,s__Process) )
     => ( ( s__instance(V__BS,s__BrakeShoe)
          & s__instance(V__BD,s__BrakeDrum)
          & s__instance(V__R,s__Rotating)
          & s__patient(V__R,V__BD)
          & s__instance(V__F,s__Friction)
          & s__resource(V__F,V__BS)
          & s__patient(V__F,V__BD) )
       => ~ s__patient(V__R,V__BS) ) ) ).

fof(kb_SUMO_375,axiom,
    s__subclass(s__DiscBrake,s__VehicleBrake) ).

fof(kb_SUMO_376,axiom,
    s__instance(s__DiscBrake__t,s__SetOrClass) ).

fof(kb_SUMO_377,axiom,
    s__termFormat(s__EnglishLanguage,s__DiscBrake,'disc brake') ).

fof(kb_SUMO_378,axiom,
    s__typicalPart(s__BrakePad,s__DiscBrake) ).

fof(kb_SUMO_379,axiom,
    s__documentation(s__BrakePad,s__EnglishLanguage,'A &%WearingFrictionSurface that presses against a &%BrakeRotor to cause vehicle braking.') ).

fof(kb_SUMO_380,axiom,
    s__subclass(s__BrakePad,s__WearingFrictionSurface) ).

fof(kb_SUMO_381,axiom,
    s__instance(s__BrakePad__t,s__SetOrClass) ).

fof(kb_SUMO_382,axiom,
    s__subclass(s__BrakeRotor,s__Device) ).

fof(kb_SUMO_383,axiom,
    s__instance(s__BrakeRotor__t,s__SetOrClass) ).

fof(kb_SUMO_384,axiom,
    s__documentation(s__BrakeRotor,s__EnglishLanguage,'A rotating &%Metal disc that is pressed upon by a &%BrakePad to cause vehicle braking.') ).

fof(kb_SUMO_385,axiom,
    s__typicalPart(s__BrakeRotor,s__DiscBrake) ).

fof(kb_SUMO_386,axiom,
    s__typicallyContainsPart(s__BrakeRotor,s__DiscBrake) ).

fof(kb_SUMO_387,axiom,
    s__subclass(s__BrakeDrum,s__Device) ).

fof(kb_SUMO_388,axiom,
    s__instance(s__BrakeDrum__t,s__SetOrClass) ).

fof(kb_SUMO_389,axiom,
    s__documentation(s__BrakeDrum,s__EnglishLanguage,'A rotating surface that is pressed on by the &%BrakeShoe.') ).

fof(kb_SUMO_390,axiom,
    s__typicalPart(s__BrakeDrum,s__DrumBrake) ).

fof(kb_SUMO_391,axiom,
    s__typicallyContainsPart(s__BrakeDrum,s__DrumBrake) ).

fof(kb_SUMO_392,axiom,
    s__subclass(s__BrakeCaliper,s__Device) ).

fof(kb_SUMO_393,axiom,
    s__instance(s__BrakeCaliper__t,s__SetOrClass) ).

fof(kb_SUMO_394,axiom,
    s__documentation(s__BrakeCaliper,s__EnglishLanguage,'A &%Device assembly that presses a &%BrakePad against a &%BrakeRotor.') ).

fof(kb_SUMO_395,axiom,
    s__typicalPart(s__BrakeCaliper,s__VehicleBrake) ).

fof(kb_SUMO_396,axiom,
    s__subclass(s__BrakePedal,s__Device) ).

fof(kb_SUMO_397,axiom,
    s__instance(s__BrakePedal__t,s__SetOrClass) ).

fof(kb_SUMO_398,axiom,
    s__termFormat(s__EnglishLanguage,s__BrakePedal,'brake pedal') ).

fof(kb_SUMO_399,axiom,
    s__documentation(s__BrakePedal,s__EnglishLanguage,'A brake pedal is a device inside a vehicle that has the purpose of being pushed to activate the bakes of the vehicle. Although normally pushed with the foot, this concept also covers handicapped-accessible devices mounted on the steering column that can be activated by pressing with the hands or fingers.') ).

fof(kb_SUMO_400,axiom,
    ! [V__BP] :
      ( s__instance(V__BP,s__Physical)
     => ( s__instance(V__BP,s__BrakePedal)
       => s__hasPurpose(V__BP,'(? [V__PU] : (s__instance(V__PU,s__Process) & s__instance(V__PU,s__Pushing) & s__destination(V__PU,V__BP)))') ) ) ).

fof(kb_SUMO_401,axiom,
    ! [V__P,V__V,V__BP] :
      ( ( s__instance(V__BP,s__Object)
        & s__instance(V__V,s__Object)
        & s__instance(V__P,s__Process) )
     => ( ( s__instance(V__BP,s__BrakePedal)
          & s__instance(V__P,s__Pushing)
          & s__instance(V__V,s__Vehicle)
          & s__destination(V__P,V__BP)
          & s__eventLocated(V__P,V__V)
          & s__part(V__BP,V__V) )
       => s__hasPurpose(V__BP,'(? [V__FS,V__F] : (s__instance(V__F,s__Process) & s__instance(V__FS,s__Object) & s__instance(V__FS,s__WearingFrictionSurface) & s__instance(V__F,s__Friction) & s__instrument(V__F,V__FS) & s__causes(V__P,V__F)))') ) ) ).

fof(kb_SUMO_402,axiom,
    s__disjoint(s__Pulling,s__Pushing) ).

%FOL fof(kb_SUMO_403,axiom,(( (! [V__O,V__P,V__A,V__D,V__SMALLER,V__LARGER,V__ALOC] : ((s__instance(V__ALOC,s__Object) & s__instance(V__LARGER,s__LengthMeasure) & s__instance(V__SMALLER,s__LengthMeasure) & s__instance(V__D,s__Physical) & s__instance(V__A,s__Agent) & s__instance(V__P,s__Process) & s__instance(V__P,s__TimeInterval) & s__instance(V__O,s__Object)) => ((s__instance(V__P,s__Pulling) & s__origin(V__P,V__O) & s__agent(V__P,V__A) & s__holdsDuring(s__BeginFn(V__P),'s__located(V__A,V__ALOC)') & s__destination(V__P,V__D)) => s__holdsDuring(s__ImmediateFutureFn(s__BeginFn(V__P)),'(s__distance(V__ALOC,V__D,V__SMALLER) & s__distance(V__ALOC,V__O,V__LARGER) & greater(V__LARGER,V__SMALLER))')))) ))).

fof(kb_SUMO_404,axiom,
    s__documentation(s__Pushing,s__EnglishLanguage,'Pushing describes the exertion of force so as to cause or tend to cause motion away from the agent.') ).

fof(kb_SUMO_405,axiom,
    s__subclass(s__Pushing,s__Motion) ).

fof(kb_SUMO_406,axiom,
    s__instance(s__Pushing__t,s__SetOrClass) ).

fof(kb_SUMO_407,axiom,
    s__termFormat(s__EnglishLanguage,s__Pushing,pushing) ).

%FOL fof(kb_SUMO_408,axiom,(( (! [V__O,V__P,V__A,V__D,V__SMALLER,V__LARGER,V__ALOC] : ((s__instance(V__ALOC,s__Object) & s__instance(V__LARGER,s__LengthMeasure) & s__instance(V__SMALLER,s__LengthMeasure) & s__instance(V__D,s__Physical) & s__instance(V__A,s__Agent) & s__instance(V__P,s__Process) & s__instance(V__P,s__TimeInterval) & s__instance(V__O,s__Object)) => ((s__instance(V__P,s__Pushing) & s__origin(V__P,V__O) & s__agent(V__P,V__A) & s__holdsDuring(s__BeginFn(V__P),'s__located(V__A,V__ALOC)') & s__destination(V__P,V__D)) => s__holdsDuring(s__ImmediateFutureFn(s__BeginFn(V__P)),'(s__distance(V__ALOC,V__D,V__SMALLER) & s__distance(V__ALOC,V__O,V__LARGER) & greater(V__LARGER,V__SMALLER))')))) ))).

fof(kb_SUMO_409,axiom,
    s__subrelation(s__systemPart__m,s__part__m) ).

fof(kb_SUMO_410,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Physical)
     => ( s__instance(V__S,s__PhysicalSystem)
       => ? [V__P] :
            ( s__instance(V__P,s__Formula)
            & s__hasPurpose(V__S,V__P) ) ) ) ).

fof(kb_SUMO_411,axiom,
    s__subclass(s__AutoSuspensionSystem,s__PhysicalSystem) ).

fof(kb_SUMO_412,axiom,
    s__instance(s__AutoSuspensionSystem__t,s__SetOrClass) ).

fof(kb_SUMO_413,axiom,
    s__termFormat(s__EnglishLanguage,s__AutoSuspensionSystem,'auto suspension system') ).

fof(kb_SUMO_414,axiom,
    s__documentation(s__AutoSuspensionSystem,s__EnglishLanguage,'A system, typically consisting of &%Springs and &%Shocks that couples the &%Wheels or &%Axles of a &%RoadVehicle to the rest of the body, and serving to dampen the effect of uneven road surfaces on the occupants or cargo.') ).

fof(kb_SUMO_415,axiom,
    s__subclass(s__WireSpring,s__Spring) ).

fof(kb_SUMO_416,axiom,
    s__instance(s__Spring__t,s__SetOrClass) ).

fof(kb_SUMO_417,axiom,
    s__typicallyContainsPart(s__Spring,s__AutoSuspensionSystem) ).

fof(kb_SUMO_418,axiom,
    s__typicallyContainsPart(s__AutoSuspensionSystem,s__Automobile) ).

fof(kb_SUMO_419,axiom,
    s__typicalPart(s__AutoSuspensionSystem,s__Automobile) ).

fof(kb_SUMO_420,axiom,
    s__instance(s__physicalAmplitude__m,s__SpatialRelation) ).

fof(kb_SUMO_421,axiom,
    s__domain(s__physicalAmplitude__m,"1",s__Tremor) ).

fof(kb_SUMO_422,axiom,
    s__domain(s__physicalAmplitude__m,"2",s__LengthMeasure) ).

fof(kb_SUMO_423,axiom,
    s__format(s__EnglishLanguage,s__physicalAmplitude__m,'the amplitude %1 is %n %2') ).

fof(kb_SUMO_424,axiom,
    s__documentation(s__physicalAmplitude__m,s__EnglishLanguage,'A relation between a periodic motion and the distance between the physical extremes of the period.') ).

%FOL fof(kb_SUMO_425,axiom,(( (! [V__O,V__T,V__L] : ((s__instance(V__L,s__LengthMeasure) & s__instance(V__T,s__Tremor) & s__instance(V__O,s__Physical)) => ((s__physicalAmplitude(V__T,V__L) & s__patient(V__T,V__O)) => (? [V__P1,V__P2,V__T1,V__T2] : (s__instance(V__T2,s__TimeInterval) & s__instance(V__T1,s__TimeInterval) & s__instance(V__P2,s__Object) & s__instance(V__P1,s__Object) & s__during(V__T1,s__WhenFn(V__T)) & s__during(V__T2,s__WhenFn(V__T)) & s__holdsDuring(V__T1,'s__located(V__O,V__P1)') & s__holdsDuring(V__T2,'s__located(V__O,V__P2)') & s__distance(V__P1,V__P2,V__L)))))) ))).

%FOL fof(kb_SUMO_426,axiom,(( (! [V__O,V__T,V__L,V__L2] : ((s__instance(V__L2,s__LengthMeasure) & s__instance(V__L,s__LengthMeasure) & s__instance(V__T,s__Tremor) & s__instance(V__O,s__Physical)) => ((s__physicalAmplitude(V__T,V__L) & s__patient(V__T,V__O)) => (~ (? [V__P1,V__P2,V__T1,V__T2] : (s__instance(V__T2,s__TimeInterval) & s__instance(V__T1,s__TimeInterval) & s__instance(V__P2,s__Object) & s__instance(V__P1,s__Object) & s__during(V__T1,s__WhenFn(V__T)) & s__during(V__T2,s__WhenFn(V__T)) & s__holdsDuring(V__T1,'s__located(V__O,V__P1)') & s__holdsDuring(V__T2,'s__located(V__O,V__P2)') & s__distance(V__P1,V__P2,V__L2) & greater(V__L2,V__L))))))) ))).

fof(kb_SUMO_427,axiom,
    s__subclass(s__Damper,s__MechanicalDevice) ).

fof(kb_SUMO_428,axiom,
    s__instance(s__Damper__t,s__SetOrClass) ).

fof(kb_SUMO_429,axiom,
    s__instance(s__MechanicalDevice__t,s__SetOrClass) ).

fof(kb_SUMO_430,axiom,
    s__termFormat(s__EnglishLanguage,s__Damper,damper) ).

fof(kb_SUMO_431,axiom,
    s__documentation(s__Damper,s__EnglishLanguage,'A &%Device designed to lessen or to remove a &%Tremor from a &%PhysicalSystem. Examples include a cars air shocks, or rubber and fluid-filled foundation mounts for buildings in earthquake-prone areas.') ).

fof(kb_SUMO_432,axiom,
    s__externalImage(s__Damper,'http://upload.wikimedia.org/wikipedia/commons/2/2b/Damped_spring.gif') ).

%FOL fof(kb_SUMO_433,axiom,(( (! [V__O,V__A1,V__D,V__T,V__E,V__A2] : ((s__instance(V__A2,s__LengthMeasure) & s__instance(V__E,s__Process) & s__instance(V__E,s__TimePosition) & s__instance(V__D,s__Object) & s__instance(V__A1,s__LengthMeasure) & s__instance(V__O,s__Object)) => ((s__instance(V__E,s__Motion) & s__instance(V__T,s__Tremor) & s__instance(V__D,s__Damper) & s__patient(V__T,V__O) & s__part(V__D,V__O) & s__causes(V__E,V__T) & s__holdsDuring(s__WhenFn(V__E),'s__physicalAmplitude(V__T,V__A1)') & s__holdsDuring(s__ImmediateFutureFn(V__E),'s__physicalAmplitude(V__T,V__A2)')) => greater(V__A1,V__A2)))) ))).

fof(kb_SUMO_434,axiom,
    s__instance(s__dampingRatio__m,s__BinaryRelation) ).

fof(kb_SUMO_435,axiom,
    s__domain(s__dampingRatio__m,"1",s__PhysicalSystem) ).

fof(kb_SUMO_436,axiom,
    s__domain(s__dampingRatio__m,"2",s__RealNumber) ).

fof(kb_SUMO_437,axiom,
    s__format(s__EnglishLanguage,s__dampingRatio__m,'the damping ratio of %1 is %n %2') ).

fof(kb_SUMO_438,axiom,
    s__documentation(s__dampingRatio__m,s__EnglishLanguage,'(dampingRation ?SYSTEM ?NUM) is a measure of to what degree a system is free to oscillate or not. In an overdamped system ?NUM is greater than 1. The system returns (exponentially decays) to equilibrium without oscillating. Larger values of the damping ratio signify a return to equilibrium more slowly. In a critically damped ?NUM equals 1. The system returns to equilibrium as quickly as possible without oscillating. This is often desired for the damping of systems such as doors. In an underdamped system 0 < ?NUM < 1. The system oscillates (at reduced frequency compared to the undamped case) with the amplitude gradually decreasing to zero. Finally, in an undamped system ?NUM is 0. The system oscillates at its natural &%resonantFrequency. [adapted from Wikipedia].') ).

%FOL fof(kb_SUMO_439,axiom,(( (! [V__A1,V__P,V__T2,V__T1,V__R,V__T,V__A2] : ((s__instance(V__A2,s__LengthMeasure) & s__instance(V__T,s__TimeInterval) & s__instance(V__R,s__RealNumber) & s__instance(V__T1,s__TimeInterval) & s__instance(V__T2,s__TimeInterval) & s__instance(V__P,s__PhysicalSystem) & s__instance(V__A1,s__LengthMeasure)) => ((s__dampingRatio(V__P,V__R) & greater(V__R,0) & s__instance(V__T,s__Tremor) & s__patient(V__T,V__P) & s__holdsDuring(V__T1,'s__physicalAmplitude(V__T,V__A1)') & s__holdsDuring(V__T2,'s__physicalAmplitude(V__T,V__A2)') & s__during(V__T1,V__T) & s__during(V__T2,V__T) & s__earlier(V__T1,V__T2)) => greater(V__A1,V__A2)))) ))).

fof(kb_SUMO_440,axiom,
    s__instance(s__resonantFrequency__m,s__BinaryRelation) ).

fof(kb_SUMO_441,axiom,
    s__domain(s__resonantFrequency__m,"1",s__PhysicalSystem) ).

fof(kb_SUMO_442,axiom,
    s__domain(s__resonantFrequency__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_443,axiom,
    s__format(s__EnglishLanguage,s__resonantFrequency__m,'the resonant frequency of %1 is %n %2') ).

fof(kb_SUMO_444,axiom,
    s__documentation(s__resonantFrequency__m,s__EnglishLanguage,'The natural resonancy frequency of a system. A system that is undamped or underdamped will oscillate at this frequency, at least for a while, after a force is applied.') ).

fof(kb_SUMO_445,axiom,
    s__relatedInternalConcept(s__resonantFrequency__m,s__dampingRatio__m) ).

fof(kb_SUMO_446,axiom,
    s__subclass(s__Automobile,s__PhysicalSystem) ).

fof(kb_SUMO_447,axiom,
    s__subclass(s__AutomobileShock,s__Damper) ).

fof(kb_SUMO_448,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileShock,shock) ).

fof(kb_SUMO_449,axiom,
    s__typicalPart(s__AutomobileShock,s__AutoSuspensionSystem) ).

fof(kb_SUMO_450,axiom,
    s__documentation(s__AutomobileShock,s__EnglishLanguage,'A &%Damper that is part of a modern &%RoadVehicles &%AutoSuspensionSystem. It may include various kinds of fluids that have the effect of being a &%Damper on &%Motion.') ).

fof(kb_SUMO_451,axiom,
    ! [V__A] :
      ( s__instance(V__A,s__Object)
     => ( s__instance(V__A,s__AutomobileShock)
       => s__hasPurpose(V__A,'(? [V__C] : (s__instance(V__C,s__Object) & s__instance(V__C,s__Automobile) & s__part(V__A,V__C)))') ) ) ).

fof(kb_SUMO_452,axiom,
    ! [V__A1,V__R2,V__S1,V__R1,V__A2] :
      ( ( s__instance(V__A2,s__Object)
        & s__instance(V__A2,s__PhysicalSystem)
        & s__instance(V__R1,s__RealNumber)
        & s__instance(V__S1,s__Object)
        & s__instance(V__R2,s__RealNumber)
        & s__instance(V__A1,s__Object)
        & s__instance(V__A1,s__PhysicalSystem) )
     => ( ( s__instance(V__A1,s__Automobile)
          & s__instance(V__A2,s__Automobile)
          & s__instance(V__S1,s__AutomobileShock)
          & s__part(V__S1,V__A1)
          & ~ ? [V__S2] :
                ( s__instance(V__S2,s__Object)
                & s__instance(V__S2,s__AutomobileShock)
                & s__part(V__S2,V__A2) )
          & s__dampingRatio(V__A1,V__R1)
          & s__dampingRatio(V__A2,V__R2) )
       => greater(V__R2,V__R1) ) ) ).

fof(kb_SUMO_453,axiom,
    s__typicalPart(s__AutomobileShock,s__Automobile) ).

fof(kb_SUMO_454,axiom,
    s__typicallyContainsPart(s__AutomobileShock,s__Automobile) ).

fof(kb_SUMO_455,axiom,
    ! [V__C,V__F,V__H,V__AS] :
      ( ( s__instance(V__AS,s__SelfConnectedObject)
        & s__instance(V__F,s__Object)
        & s__instance(V__C,s__Process) )
     => ( ( s__instance(V__AS,s__AutomobileShock)
          & s__instance(V__C,s__Compressing)
          & s__instance(V__H,s__Hole)
          & s__attribute(V__F,s__Fluid)
          & V__AS = s__HoleHostFn(V__H)
          & s__contains(V__AS,V__F)
          & s__patient(V__C,V__AS) )
       => ? [V__T] :
            ( s__instance(V__T,s__Transfer)
            & s__objectTransferred(V__T,V__F)
            & s__path(V__T,V__H)
            & s__causes(V__C,V__T) ) ) ) ).

fof(kb_SUMO_456,axiom,
    s__subclass(s__LeafSpring,s__Spring) ).

fof(kb_SUMO_457,axiom,
    s__instance(s__LeafSpring__t,s__SetOrClass) ).

fof(kb_SUMO_458,axiom,
    s__documentation(s__LeafSpring,s__EnglishLanguage,'A type of spring found in &%Trucks and older &%Automobiles, and is designed to minimize the transmission of shocks to the frame of a &%LandVehicle from hitting imperfections in a road surface. They are typically arranged into a group of layers that provides stronger resistance when the shock encountered is greater.') ).

fof(kb_SUMO_459,axiom,
    s__externalImage(s__LeafSpring,'http://upload.wikimedia.org/wikipedia/commons/6/63/Leafs1.jpg') ).

fof(kb_SUMO_460,axiom,
    s__termFormat(s__EnglishLanguage,s__LeafSpring,'leaf spring') ).

fof(kb_SUMO_461,axiom,
    s__typicalPart(s__LeafSpring,s__AutoSuspensionSystem) ).

fof(kb_SUMO_462,axiom,
    ! [V__L] :
      ( s__instance(V__L,s__Object)
     => ( s__instance(V__L,s__LeafSpring)
       => s__attribute(V__L,s__LongAndThin) ) ) ).

fof(kb_SUMO_463,axiom,
    ! [V__L,V__RV] :
      ( ( s__instance(V__RV,s__Object)
        & s__instance(V__L,s__Object) )
     => ( ( s__instance(V__L,s__LeafSpring)
          & s__part(V__L,V__RV)
          & s__instance(V__RV,s__RoadVehicle) )
       => s__modalAttribute('(? [V__L2] : (s__instance(V__L2,s__Object) & s__instance(V__L2,s__LeafSpring) & s__part(V__L2,V__RV) & (~ (V__L = V__L2)) & s__meetsSpatially(V__L,V__L2)))',s__Likely) ) ) ).

fof(kb_SUMO_464,axiom,
    s__subclass(s__FuelFilter,s__Filter) ).

fof(kb_SUMO_465,axiom,
    s__instance(s__FuelFilter__t,s__SetOrClass) ).

fof(kb_SUMO_466,axiom,
    s__termFormat(s__EnglishLanguage,s__FuelFilter,'fuel filter') ).

fof(kb_SUMO_467,axiom,
    s__documentation(s__FuelFilter,s__EnglishLanguage,'A fuel filter is designed to remove impurities from &%Fuel.') ).

fof(kb_SUMO_468,axiom,
    ! [V__FILTER] :
      ( s__instance(V__FILTER,s__Object)
     => ( s__instance(V__FILTER,s__FuelFilter)
       => s__hasPurpose(V__FILTER,'(? [V__REMOVE,V__FUEL,V__NONFUEL,V__SOLUTION] : (s__instance(V__SOLUTION,s__Object) & s__instance(V__NONFUEL,s__Object) & s__instance(V__FUEL,s__Object) & s__instance(V__REMOVE,s__Process) & s__instance(V__REMOVE,s__Removing) & s__part(V__FUEL,V__SOLUTION) & s__instance(V__FUEL,s__Fuel) & (~ s__instance(V__NONFUEL,s__Fuel)) & s__patient(V__REMOVE,V__NONFUEL) & s__part(V__NONFUEL,V__SOLUTION) & s__origin(V__REMOVE,V__SOLUTION) & s__instance(V__SOLUTION,s__Solution) & s__instrument(V__REMOVE,V__FILTER)))') ) ) ).

fof(kb_SUMO_469,axiom,
    s__subclass(s__AirFilter,s__Filter) ).

fof(kb_SUMO_470,axiom,
    s__instance(s__AirFilter__t,s__SetOrClass) ).

fof(kb_SUMO_471,axiom,
    s__termFormat(s__EnglishLanguage,s__AirFilter,'air filter') ).

fof(kb_SUMO_472,axiom,
    s__documentation(s__AirFilter,s__EnglishLanguage,'An air filter is designed to remove &%Solid impurities from &%Air.') ).

fof(kb_SUMO_473,axiom,
    ! [V__FILTER] :
      ( s__instance(V__FILTER,s__Object)
     => ( s__instance(V__FILTER,s__AirFilter)
       => s__hasPurpose(V__FILTER,'(? [V__REMOVE,V__AIR,V__NONAIR,V__MIX] : (s__instance(V__MIX,s__Object) & s__instance(V__NONAIR,s__Object) & s__instance(V__AIR,s__Object) & s__instance(V__REMOVE,s__Process) & s__instance(V__REMOVE,s__Removing) & s__part(V__AIR,V__MIX) & s__instance(V__AIR,s__Air) & (~ s__instance(V__NONAIR,s__Air)) & s__attribute(V__NONAIR,s__Solid) & s__patient(V__REMOVE,V__NONAIR) & s__part(V__NONAIR,V__MIX) & s__origin(V__REMOVE,V__MIX) & s__instance(V__MIX,s__Mixture) & s__instrument(V__REMOVE,V__FILTER)))') ) ) ).

fof(kb_SUMO_474,axiom,
    s__subclass(s__AirIntake,s__Tube) ).

fof(kb_SUMO_475,axiom,
    s__instance(s__AirIntake__t,s__SetOrClass) ).

fof(kb_SUMO_476,axiom,
    s__termFormat(s__EnglishLanguage,s__AirIntake,'air intake') ).

fof(kb_SUMO_477,axiom,
    s__documentation(s__AirIntake,s__EnglishLanguage,'A &%Tube that channels &%Air on a &%path ultimately into an &%Engine.') ).

fof(kb_SUMO_478,axiom,
    ! [V__AI] :
      ( s__instance(V__AI,s__SelfConnectedObject)
     => ( s__instance(V__AI,s__AirIntake)
       => s__hasPurpose(V__AI,'(? [V__A] : (s__instance(V__A,s__Object) & s__instance(V__A,s__Air) & s__contains(V__AI,V__A)))') ) ) ).

fof(kb_SUMO_479,axiom,
    ! [V__T,V__E,V__AI] :
      ( ( s__instance(V__AI,s__Object)
        & s__instance(V__T,s__Process) )
     => ( s__instance(V__AI,s__AirIntake)
       => s__hasPurpose(V__AI,'(? [V__A] : (s__instance(V__A,s__Air) & s__instance(V__E,s__Engine) & s__instance(V__T,s__Transfer) & s__origin(V__T,V__AI) & s__destination(V__T,V__E) & s__patient(V__T,V__A)))') ) ) ).

fof(kb_SUMO_480,axiom,
    s__subclass(s__GasTank,s__FluidContainer) ).

fof(kb_SUMO_481,axiom,
    s__instance(s__GasTank__t,s__SetOrClass) ).

fof(kb_SUMO_482,axiom,
    s__termFormat(s__EnglishLanguage,s__GasTank,'gas tank') ).

fof(kb_SUMO_483,axiom,
    s__documentation(s__GasTank,s__EnglishLanguage,'A &%Container in a &%Vehicle designed to hold a &%Liquid &%Fuel for use in its &%Engine. Note that this does not include container such as portable fuel tanks that may be used to carry gas, but which do not directly supply an engine.') ).

fof(kb_SUMO_484,axiom,
    ! [V__GT] :
      ( s__instance(V__GT,s__SelfConnectedObject)
     => ( s__instance(V__GT,s__GasTank)
       => s__hasPurpose(V__GT,'(? [V__F] : (s__instance(V__F,s__Object) & s__instance(V__F,s__Fuel) & s__contains(V__GT,V__F)))') ) ) ).

fof(kb_SUMO_485,axiom,
    ! [V__GT] :
      ( s__instance(V__GT,s__SelfConnectedObject)
     => ( s__instance(V__GT,s__GasTank)
       => s__hasPurpose(V__GT,'(? [V__F,V__T,V__E] : (s__instance(V__T,s__Process) & s__instance(V__F,s__Object) & s__instance(V__F,s__Fuel) & s__contains(V__GT,V__F) & s__instance(V__E,s__Engine) & s__instance(V__T,s__Transfer) & s__origin(V__T,V__GT) & s__destination(V__T,V__E) & s__patient(V__T,V__F)))') ) ) ).

fof(kb_SUMO_486,axiom,
    s__subclass(s__FuelPump,s__Pump) ).

fof(kb_SUMO_487,axiom,
    s__instance(s__FuelPump__t,s__SetOrClass) ).

fof(kb_SUMO_488,axiom,
    s__termFormat(s__EnglishLanguage,s__FuelPump,'fuel pump') ).

fof(kb_SUMO_489,axiom,
    s__documentation(s__FuelPump,s__EnglishLanguage,'A pump that moves fuel from the gas tank through a &%FuelFilter and ultimately to the &%EngineCylinder.') ).

fof(kb_SUMO_490,axiom,
    ! [V__FP] :
      ( s__instance(V__FP,s__Object)
     => ( s__instance(V__FP,s__FuelPump)
       => s__hasPurpose(V__FP,'(? [V__F,V__T] : (s__instance(V__T,s__Process) & s__instance(V__F,s__Process) & s__instance(V__T,s__Transportation) & s__instance(V__F,s__Fuel) & s__patient(V__T,V__F) & s__instrument(V__F,V__FP)))') ) ) ).

fof(kb_SUMO_491,axiom,
    ! [V__A,V__T,V__F,V__FP] :
      ( ( s__instance(V__FP,s__Object)
        & s__instance(V__F,s__Process)
        & s__instance(V__T,s__Process)
        & s__instance(V__A,s__Object) )
     => ( ( s__instance(V__FP,s__FuelPump)
          & s__instance(V__A,s__Automobile)
          & s__part(V__FP,V__A)
          & s__instance(V__T,s__Transportation)
          & s__instance(V__F,s__Fuel)
          & s__patient(V__T,V__F)
          & s__instrument(V__F,V__FP) )
       => s__hasPurpose(V__FP,'(? [V__GT,V__EC] : (s__instance(V__EC,s__Object) & s__instance(V__GT,s__Object) & s__instance(V__GT,s__GasTank) & s__part(V__GT,V__A) & s__instance(V__EC,s__EngineCylinder) & s__part(V__EC,V__A) & s__origin(V__T,V__GT) & s__destination(V__T,V__EC)))') ) ) ).

fof(kb_SUMO_492,axiom,
    ! [V__P,V__A,V__T,V__F,V__FP,V__EC,V__GT] :
      ( ( s__instance(V__GT,s__Object)
        & s__instance(V__EC,s__Object)
        & s__instance(V__FP,s__Object)
        & s__instance(V__F,s__Process)
        & s__instance(V__T,s__Motion)
        & s__instance(V__A,s__Object)
        & s__instance(V__P,s__Object) )
     => ( ( s__instance(V__FP,s__FuelPump)
          & s__instance(V__A,s__Automobile)
          & s__part(V__FP,V__A)
          & s__instance(V__T,s__Transportation)
          & s__instance(V__F,s__Fuel)
          & s__patient(V__T,V__F)
          & s__instrument(V__F,V__FP)
          & s__instance(V__GT,s__GasTank)
          & s__part(V__GT,V__A)
          & s__instance(V__EC,s__EngineCylinder)
          & s__part(V__EC,V__A)
          & s__origin(V__T,V__GT)
          & s__destination(V__T,V__EC)
          & s__path(V__T,V__P) )
       => s__hasPurpose(V__T,'(? [V__FF] : (s__instance(V__FF,s__Object) & s__instance(V__FF,s__FuelFilter) & s__betweenOnPath(V__GT,V__FF,V__EC,V__P)))') ) ) ).

fof(kb_SUMO_493,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Process)
     => ( s__instance(V__S,s__Spraying)
       => ? [V__G,V__L,V__M] :
            ( s__instance(V__M,s__Object)
            & s__instance(V__L,s__Object)
            & s__instance(V__G,s__Object)
            & s__attribute(V__G,s__Gas)
            & s__attribute(V__L,s__Liquid)
            & s__instance(V__M,s__GasMixture)
            & s__part(V__M,V__G)
            & s__part(V__M,V__L)
            & s__patient(V__S,V__G)
            & s__patient(V__S,V__L)
            & s__result(V__S,V__M) ) ) ) ).

fof(kb_SUMO_494,axiom,
    s__subclass(s__FuelAtomizer,s__Device) ).

fof(kb_SUMO_495,axiom,
    s__termFormat(s__EnglishLanguage,s__FuelAtomizer,'fuel atomizer') ).

fof(kb_SUMO_496,axiom,
    s__documentation(s__FuelAtomizer,s__EnglishLanguage,'A &%Device designed to atomize fuel to put into a &%GasMixture for use in &%Combustion. In a gas-powered automobile that typically has 14.7 parts air per part gasoline. Principal subclasses are &%FuelInjectors and &%Carburetors.') ).

fof(kb_SUMO_497,axiom,
    ! [V__FA] :
      ( s__instance(V__FA,s__Physical)
     => ( s__instance(V__FA,s__FuelAtomizer)
       => s__hasPurpose(V__FA,'(? [V__F,V__S,V__A,V__C] : (s__instance(V__C,s__Process) & s__instance(V__A,s__Object) & s__instance(V__S,s__Process) & s__instance(V__F,s__Object) & s__instance(V__F,s__Fuel) & s__instance(V__S,s__Spraying) & s__instance(V__A,s__Air) & s__instance(V__C,s__Combustion) & s__patient(V__S,V__A) & s__patient(V__S,V__F) & s__resource(V__C,V__F) & s__resource(V__C,V__A)))') ) ) ).

fof(kb_SUMO_498,axiom,
    s__subclass(s__FuelInjector,s__FuelAtomizer) ).

fof(kb_SUMO_499,axiom,
    s__instance(s__FuelInjector__t,s__SetOrClass) ).

fof(kb_SUMO_500,axiom,
    s__termFormat(s__EnglishLanguage,s__FuelInjector,'fuel injector') ).

fof(kb_SUMO_501,axiom,
    s__documentation(s__FuelInjector,s__EnglishLanguage,'A &%Device that atomizes &%Fuel by forcing it through a small orifice under high pressure. They have largely superceded the use of &%Carburetors in modern &%Automobiles, since the late 1980s.') ).

fof(kb_SUMO_502,axiom,
    s__subclass(s__Carburetor,s__FuelAtomizer) ).

fof(kb_SUMO_503,axiom,
    s__instance(s__Carburetor__t,s__SetOrClass) ).

fof(kb_SUMO_504,axiom,
    s__instance(s__FuelAtomizer__t,s__SetOrClass) ).

fof(kb_SUMO_505,axiom,
    s__termFormat(s__EnglishLanguage,s__Carburetor,carburetor) ).

fof(kb_SUMO_506,axiom,
    s__externalImage(s__Carburetor,'http://upload.wikimedia.org/wikipedia/commons/thumb/2/2b/Carburetor.svg/220px-Carburetor.svg.png') ).

fof(kb_SUMO_507,axiom,
    s__documentation(s__Carburetor,s__EnglishLanguage,'A &%Device that uses the suction created by engine cycles, and the venturi effect in the carburetor itself to draw fuel through and out a small opening to atomize it and combine it with &%Air.') ).

fof(kb_SUMO_508,axiom,
    s__subclass(s__Exhaust,s__Mixture) ).

fof(kb_SUMO_509,axiom,
    s__subclass(s__Smoke,s__Exhaust) ).

fof(kb_SUMO_510,axiom,
    s__instance(s__Exhaust__t,s__SetOrClass) ).

fof(kb_SUMO_511,axiom,
    s__termFormat(s__EnglishLanguage,s__Exhaust,exhaust) ).

fof(kb_SUMO_512,axiom,
    s__documentation(s__Exhaust,s__EnglishLanguage,'A concept to broadly cover all physical byproducts of &%Combustion, other than light or heat. While exhaust is often an undesirable byproduct of combustion that serves some particular purpose, and where heat or light is desired, there is also the case of smoke signals or mosquito-repelling smudge pots in which exhaust (and often ineffecient combustion, to produce the most smoke) is the desirable output of combustion. Exhaust differs from Smoke in that it need not be visible.') ).

fof(kb_SUMO_513,axiom,
    ! [V__E] :
      ( s__instance(V__E,s__Object)
     => ( s__instance(V__E,s__Exhaust)
       => ? [V__S,V__G,V__C] :
            ( s__instance(V__C,s__Process)
            & s__instance(V__G,s__Object)
            & s__instance(V__S,s__Object)
            & s__instance(V__C,s__Combustion)
            & s__attribute(V__S,s__Solid)
            & s__attribute(V__G,s__Gas)
            & s__part(V__S,V__E)
            & s__part(V__G,V__E)
            & s__result(V__C,V__E) ) ) ) ).

%FOL fof(kb_SUMO_514,axiom,(( (! [V__E] : (s__instance(V__E,s__Object) => (s__instance(V__E,s__Exhaust) => s__modalAttribute('s__capability(s__Seeing,s__patient__m,V__E)',s__Possibility)))) ))).

fof(kb_SUMO_515,axiom,
    ! [V__E] :
      ( s__instance(V__E,s__Object)
     => ( s__instance(V__E,s__Exhaust)
       => s__modalAttribute('(~ s__capability(s__Seeing,s__patient__m,V__E))',s__Possibility) ) ) ).

fof(kb_SUMO_516,axiom,
    s__instance(s__AllWheelDrive,s__RelationalAttribute) ).

fof(kb_SUMO_517,axiom,
    s__termFormat(s__EnglishLanguage,s__AllWheelDrive,'all wheel drive') ).

fof(kb_SUMO_518,axiom,
    s__documentation(s__AllWheelDrive,s__EnglishLanguage,'An &%Attribute of an &%Automobile, specifying that it is capable of supplying power to all of its wheels at the same time, typically for the purpose of increasing traction on slippery or uneven surfaces.') ).

fof(kb_SUMO_519,axiom,
    s__instance(s__TwoWheelDrive,s__RelationalAttribute) ).

fof(kb_SUMO_520,axiom,
    s__termFormat(s__EnglishLanguage,s__TwoWheelDrive,'two wheel drive') ).

fof(kb_SUMO_521,axiom,
    s__documentation(s__TwoWheelDrive,s__EnglishLanguage,'An &%Attribute of an &%Automobile, specifying that it is capable of supplying power only to two of its wheels at the same time. Note that this attribute can be used with temporal qualification to specify that a four-wheel-drive vehicle is in two-wheel-drive mode.') ).

fof(kb_SUMO_522,axiom,
    s__subclass(s__Generator,s__Machine) ).

fof(kb_SUMO_523,axiom,
    s__instance(s__Generator__t,s__SetOrClass) ).

fof(kb_SUMO_524,axiom,
    s__termFormat(s__EnglishLanguage,s__Generator,generator) ).

fof(kb_SUMO_525,axiom,
    s__documentation(s__Generator,s__EnglishLanguage,'Any &%Machine that generates &%Electricity.') ).

fof(kb_SUMO_526,axiom,
    ! [V__G] :
      ( s__instance(V__G,s__Object)
     => ( s__instance(V__G,s__Generator)
       => s__hasPurpose(V__G,'(? [V__P,V__E] : (s__instance(V__P,s__Process) & s__instance(V__E,s__Electricity) & s__result(V__P,V__E) & s__instrument(V__P,V__G)))') ) ) ).

fof(kb_SUMO_527,axiom,
    s__subclass(s__Alternator,s__Generator) ).

fof(kb_SUMO_528,axiom,
    s__instance(s__Alternator__t,s__SetOrClass) ).

fof(kb_SUMO_529,axiom,
    s__termFormat(s__EnglishLanguage,s__Alternator,alternator) ).

fof(kb_SUMO_530,axiom,
    s__documentation(s__Alternator,s__EnglishLanguage,'A &%Generator that is part of a &%Vehicle, intended to use the power of the motor to generate electricity to keep the &%Battery charged and supply &%Electricity for the systems of the &%Vehicle, including the &%SparkPlugs, lights, radio etc.') ).

fof(kb_SUMO_531,axiom,
    s__typicalPart(s__Alternator,s__Vehicle) ).

fof(kb_SUMO_532,axiom,
    s__typicallyContainsPart(s__Alternator,s__Vehicle) ).

fof(kb_SUMO_533,axiom,
    s__subclass(s__AirPump,s__Pump) ).

fof(kb_SUMO_534,axiom,
    s__instance(s__AirPump__t,s__SetOrClass) ).

fof(kb_SUMO_535,axiom,
    s__termFormat(s__EnglishLanguage,s__AirPump,'air pump') ).

fof(kb_SUMO_536,axiom,
    s__documentation(s__AirPump,s__EnglishLanguage,'Any &%Pump designed to move &%Air.') ).

fof(kb_SUMO_537,axiom,
    ! [V__AP] :
      ( s__instance(V__AP,s__Object)
     => ( s__instance(V__AP,s__AirPump)
       => s__hasPurpose(V__AP,'(? [V__T,V__A] : (s__instance(V__T,s__Process) & s__instance(V__T,s__Transportation) & s__instrument(V__T,V__AP) & s__patient(V__T,V__A)))') ) ) ).

fof(kb_SUMO_538,axiom,
    s__subclass(s__Antifreeze,s__Substance) ).

fof(kb_SUMO_539,axiom,
    s__instance(s__Antifreeze__t,s__SetOrClass) ).

fof(kb_SUMO_540,axiom,
    s__termFormat(s__EnglishLanguage,s__Antifreeze,antifreeze) ).

fof(kb_SUMO_541,axiom,
    s__documentation(s__Antifreeze,s__EnglishLanguage,'Any &%Substance designed to lower the &%meltingPoint of &%Water.') ).

%FOL fof(kb_SUMO_542,axiom,(( (! [V__A,V__D,V__W,V__M] : ((s__instance(V__M,s__Object) & s__instance(V__W,s__Object) & s__instance(V__D,s__Quantity) & s__instance(V__A,s__Object)) => ((s__instance(V__W,s__Water) & s__instance(V__M,s__Mixture) & s__part(V__W,V__M) & s__instance(V__A,s__Antifreeze) & s__part(V__A,V__M) & s__attribute(V__M,s__Solid) & s__measure(V__M,'s__CelsiusDegree(V__D)')) => greater(32,V__D)))) ))).

fof(kb_SUMO_543,axiom,
    s__subclass(s__BrakeSystem,s__PhysicalSystem) ).

fof(kb_SUMO_544,axiom,
    s__instance(s__BrakeSystem__t,s__SetOrClass) ).

fof(kb_SUMO_545,axiom,
    s__termFormat(s__EnglishLanguage,s__BrakeSystem,'brake system') ).

fof(kb_SUMO_546,axiom,
    s__documentation(s__BrakeSystem,s__EnglishLanguage,'A system, typically consisting of &%VehicleBrakes, and often a &%MasterCylinder, &%BrakeCalipers and &%BrakePads that serves to slow or stop a vehicle (or just reduce its downhill acceleration).') ).

fof(kb_SUMO_547,axiom,
    s__typicallyContainsPart(s__BrakeSystem,s__Automobile) ).

fof(kb_SUMO_548,axiom,
    s__typicalPart(s__BrakeSystem,s__Automobile) ).

fof(kb_SUMO_549,axiom,
    ! [V__BS] :
      ( s__instance(V__BS,s__Object)
     => ( s__instance(V__BS,s__BrakeSystem)
       => s__hasPurpose(V__BS,'(? [V__B] : (s__instance(V__B,s__Process) & s__instance(V__B,s__Braking) & s__instrument(V__B,V__BS)))') ) ) ).

fof(kb_SUMO_550,axiom,
    s__subclass(s__Braking,s__Decreasing) ).

fof(kb_SUMO_551,axiom,
    s__instance(s__Braking__t,s__SetOrClass) ).

fof(kb_SUMO_552,axiom,
    s__termFormat(s__EnglishLanguage,s__Braking,braking) ).

fof(kb_SUMO_553,axiom,
    s__documentation(s__Braking,s__EnglishLanguage,'An application of a &%BrakeSystem to slow or stop a vehicle (or just reduce its downhill acceleration).') ).

fof(kb_SUMO_554,axiom,
    ! [V__O,V__A1,V__B,V__D,V__T,V__FQ,V__A2] :
      ( ( s__instance(V__A2,s__Quantity)
        & s__instance(V__FQ,s__FunctionQuantity)
        & s__instance(V__T,s__TimeDuration)
        & s__instance(V__D,s__DirectionalAttribute)
        & s__instance(V__B,s__Process)
        & s__instance(V__A1,s__Quantity)
        & s__instance(V__O,s__Object) )
     => ( ( s__instance(V__B,s__Braking)
          & s__patient(V__B,V__O) )
       => ( s__holdsDuring(s__ImmediatePastFn(s__WhenFn(V__B)),'(V__A1 = s__AccelerationFn(V__FQ,V__T,V__O,V__D))')
          & s__holdsDuring(s__ImmediateFutureFn(s__WhenFn(V__B)),'(V__A2 = s__AccelerationFn(V__FQ,V__T,V__O,V__D))')
          & greater(V__A1,V__A2) ) ) ) ).

fof(kb_SUMO_555,axiom,
    s__documentation(s__AccelerationFn__m,s__EnglishLanguage,'Specifies the acceleration of an object, i.e. the change in speed for a given direction.') ).

fof(kb_SUMO_556,axiom,
    s__format(s__EnglishLanguage,s__AccelerationFn__m,'the accelleration %1 of %3 in %2 in the direction %4') ).

fof(kb_SUMO_557,axiom,
    s__domain(s__AccelerationFn__m,"1",s__FunctionQuantity) ).

fof(kb_SUMO_558,axiom,
    s__domain(s__AccelerationFn__m,"2",s__TimeDuration) ).

fof(kb_SUMO_559,axiom,
    s__domain(s__AccelerationFn__m,"3",s__Object) ).

fof(kb_SUMO_560,axiom,
    s__domain(s__AccelerationFn__m,"4",s__DirectionalAttribute) ).

fof(kb_SUMO_561,axiom,
    s__instance(s__AccelerationFn__m,s__QuaternaryFunction) ).

fof(kb_SUMO_562,axiom,
    s__instance(s__AccelerationFn__m,s__TotalValuedRelation) ).

fof(kb_SUMO_563,axiom,
    s__range(s__AccelerationFn__m,s__FunctionQuantity) ).

fof(kb_SUMO_564,axiom,
    s__subclass(s__AntilockBrake,s__VehicleBrake) ).

fof(kb_SUMO_565,axiom,
    s__instance(s__AntilockBrake__t,s__SetOrClass) ).

fof(kb_SUMO_566,axiom,
    s__termFormat(s__EnglishLanguage,s__AntilockBrake,'antilock brake') ).

fof(kb_SUMO_567,axiom,
    s__documentation(s__AntilockBrake,s__EnglishLanguage,'A &%VehicleBrake with an electronic component that reduces the likelihood of locking up the wheels during a sudden stop. If the wheels stop turning, the controller reduces pressure on the brakes until they begin turning again, then alternates application and reduction of braking pressure in short intervals. The goal is to keep the wheels at as near as possible the point of transition between dynamic or sliding friction and the point of static friction (at which the stopping force is greater).') ).

fof(kb_SUMO_568,axiom,
    ! [V__A,V__D,V__T,V__W,V__AB] :
      ( ( s__instance(V__AB,s__Object)
        & s__instance(V__W,s__Object)
        & s__instance(V__T,s__Process)
        & s__instance(V__D,s__Process)
        & s__instance(V__D,s__TimeInterval)
        & s__instance(V__A,s__Object) )
     => ( ( s__instance(V__T,s__Transportation)
          & s__instance(V__W,s__Wheel)
          & s__instance(V__A,s__Automobile)
          & s__part(V__W,V__A)
          & s__instrument(V__T,V__A)
          & s__instance(V__AB,s__AntilockBrake)
          & s__instance(V__D,s__Decelerating)
          & s__instrument(V__D,V__AB)
          & s__part(V__AB,V__W) )
       => s__hasPurpose(V__AB,'(? [V__R] : (s__instance(V__R,s__TimeInterval) & s__instance(V__R,s__Rotating) & s__during(V__R,V__D)))') ) ) ).

fof(kb_SUMO_569,axiom,
    s__subclass(s__EngineChoke,s__Device) ).

fof(kb_SUMO_570,axiom,
    s__instance(s__EngineChoke__t,s__SetOrClass) ).

fof(kb_SUMO_571,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineChoke,'engine choke') ).

fof(kb_SUMO_572,axiom,
    s__documentation(s__EngineChoke,s__EnglishLanguage,'A device to restrict the flow of &%Air to an engine, typically when cold, that increases the &%Fuel to &%Air ratio.') ).

%FOL fof(kb_SUMO_573,axiom,(( (! [V__F1M,V__A1,V__EC,V__F2M,V__C,V__MIX2,V__MIX1,V__FSC1,V__A1M,V__FSC2,V__A2M,V__F2,V__F1,V__M,V__A2] : ((s__instance(V__A2,s__Object) & s__instance(V__M,s__ConstantQuantity) & s__instance(V__F1,s__Object) & s__instance(V__F2,s__Object) & s__instance(V__A2M,s__PhysicalQuantity) & s__instance(V__FSC2,s__TimePosition) & s__instance(V__FSC2,s__Process) & s__instance(V__A1M,s__PhysicalQuantity) & s__instance(V__FSC1,s__TimePosition) & s__instance(V__FSC1,s__Process) & s__instance(V__MIX1,s__Object) & s__instance(V__MIX2,s__Object) & s__instance(V__C,s__SelfConnectedObject) & s__instance(V__F2M,s__PhysicalQuantity) & s__instance(V__EC,s__Object) & s__instance(V__A1,s__Object) & s__instance(V__F1M,s__PhysicalQuantity)) => ((s__instance(V__EC,s__EngineChoke) & s__holdsDuring(V__FSC1,'s__attribute(V__EC,s__DeviceOn)') & s__holdsDuring(V__FSC2,'s__attribute(V__EC,s__DeviceOff)') & s__instance(V__C,s__EngineCylinder) & s__capacity(V__C,V__M) & s__instance(V__FSC1,s__FourStrokeCompression) & s__instance(V__FSC2,s__FourStrokeCompression) & s__eventLocated(V__FSC1,V__C) & s__eventLocated(V__FSC2,V__C) & s__instance(V__A1,s__Air) & s__instance(V__F1,s__Fuel) & s__part(V__A1,V__MIX1) & s__part(V__F1,V__MIX1) & s__measure(V__MIX1,V__M) & s__instance(V__A2,s__Air) & s__instance(V__F2,s__Fuel) & s__part(V__A2,V__MIX2) & s__part(V__F2,V__MIX2) & s__measure(V__MIX2,V__M) & s__measure(V__A1,V__A1M) & s__measure(V__A2,V__A2M) & s__measure(V__F1,V__F1M) & s__measure(V__F2,V__F2M)) => greater(divide(V__A2M,V__F2M),divide(V__A1M,V__F1M))))) ))).

fof(kb_SUMO_574,axiom,
    s__subclass(s__Backfire,s__Combustion) ).

fof(kb_SUMO_575,axiom,
    s__instance(s__Backfire__t,s__SetOrClass) ).

fof(kb_SUMO_576,axiom,
    s__termFormat(s__EnglishLanguage,s__Backfire,backfire) ).

fof(kb_SUMO_577,axiom,
    s__documentation(s__Backfire,s__EnglishLanguage,'An improper case of &%Engine operation where &%Combustion occurs in the &%Exhaust or intake.') ).

fof(kb_SUMO_578,axiom,
    ! [V__B] :
      ( s__instance(V__B,s__Process)
     => ( s__instance(V__B,s__Backfire)
       => ? [V__E,V__NC] :
            ( s__instance(V__NC,s__Object)
            & s__instance(V__E,s__Object)
            & ~ s__instance(V__NC,s__EngineCylinder)
            & s__instance(V__E,s__Engine)
            & s__part(V__NC,V__E)
            & s__eventLocated(V__B,V__NC) ) ) ) ).

fof(kb_SUMO_579,axiom,
    s__subclass(s__BallJoint,s__MechanicalJoint) ).

fof(kb_SUMO_580,axiom,
    s__instance(s__BallJoint__t,s__SetOrClass) ).

fof(kb_SUMO_581,axiom,
    s__externalImage(s__BallJoint,'http://upload.wikimedia.org/wikipedia/en/thumb/0/0f/Ball_joint_cross_section.jpg/220px-Ball_joint_cross_section.jpg') ).

fof(kb_SUMO_582,axiom,
    s__documentation(s__BallJoint,s__EnglishLanguage,'A ball joint allows for travel of two linked entities, where if one entity is fixed, the other can travel on paths that describe a portion of the surface of a sphere. A typical application is a linkage between the &%Wheels and &%AutoSuspensionSystem. A spring is typically included in order to reduce vibration.') ).

fof(kb_SUMO_583,axiom,
    s__termFormat(s__EnglishLanguage,s__BallJoint,'ball joint') ).

fof(kb_SUMO_584,axiom,
    s__typicallyContainsPart(s__Spring,s__BallJoint) ).

fof(kb_SUMO_585,axiom,
    s__subclass(s__Hinge,s__MechanicalJoint) ).

fof(kb_SUMO_586,axiom,
    s__subclass(s__MechanicalJoint,s__EngineeringComponent) ).

fof(kb_SUMO_587,axiom,
    s__termFormat(s__EnglishLanguage,s__MechanicalJoint,'mechanical joint') ).

fof(kb_SUMO_588,axiom,
    s__documentation(s__MechanicalJoint,s__EnglishLanguage,'A &%Device that links two parts of a &%PhysicalSystem and allows them to move in relation to one another. Examples include &%Hinges, drawer slides and &%BallJoints.') ).

fof(kb_SUMO_589,axiom,
    ! [V__MJ] :
      ( s__instance(V__MJ,s__EngineeringComponent)
     => ( s__instance(V__MJ,s__MechanicalJoint)
       => s__hasPurpose(V__MJ,'(? [V__S,V__P1,V__P2,V__M] : (s__instance(V__M,s__Process) & s__instance(V__M,s__Motion) & s__instance(V__S,s__PhysicalSystem) & s__instance(V__P1,s__EngineeringComponent) & s__instance(V__P2,s__EngineeringComponent) & s__part(V__P1,s__PhysicalSystem) & s__part(V__MJ,s__PhysicalSystem) & s__part(V__P2,s__PhysicalSystem) & (~ s__patient(V__M,V__P1)) & s__patient(V__M,V__P2) & s__connectedEngineeringComponents(V__P1,V__MJ) & s__connectedEngineeringComponents(V__P2,V__MJ)))') ) ) ).

fof(kb_SUMO_590,axiom,
    s__subclass(s__Bearing,s__MechanicalJoint) ).

fof(kb_SUMO_591,axiom,
    s__instance(s__Bearing__t,s__SetOrClass) ).

fof(kb_SUMO_592,axiom,
    s__instance(s__MechanicalJoint__t,s__SetOrClass) ).

fof(kb_SUMO_593,axiom,
    s__termFormat(s__EnglishLanguage,s__Bearing,bearing) ).

fof(kb_SUMO_594,axiom,
    s__documentation(s__Bearing,s__EnglishLanguage,'A &%Device designed to let the surfaces of two objects move in relation to one another with limited friction. Ball bearings roll in a channel affixed to one surface.') ).

fof(kb_SUMO_595,axiom,
    s__subclass(s__BallBearing,s__Device) ).

fof(kb_SUMO_596,axiom,
    s__instance(s__BallBearing__t,s__SetOrClass) ).

fof(kb_SUMO_597,axiom,
    s__termFormat(s__EnglishLanguage,s__BallBearing,'ball bearing') ).

fof(kb_SUMO_598,axiom,
    s__documentation(s__BallBearing,s__EnglishLanguage,'A small &%Metal &%Sphere designed for use in applications where it is desirable to reduce friction between two parts.') ).

fof(kb_SUMO_599,axiom,
    ! [V__BB] :
      ( s__instance(V__BB,s__CorpuscularObject)
     => ( s__instance(V__BB,s__BallBearing)
       => s__material(s__Metal,V__BB) ) ) ).

fof(kb_SUMO_600,axiom,
    ! [V__BB] :
      ( s__instance(V__BB,s__Object)
     => ( s__instance(V__BB,s__BallBearing)
       => s__attribute(V__BB,s__Sphere) ) ) ).

fof(kb_SUMO_601,axiom,
    s__subclass(s__BevelGear,s__Gear) ).

fof(kb_SUMO_602,axiom,
    s__instance(s__BevelGear__t,s__SetOrClass) ).

fof(kb_SUMO_603,axiom,
    s__instance(s__Gear__t,s__SetOrClass) ).

fof(kb_SUMO_604,axiom,
    s__termFormat(s__EnglishLanguage,s__BevelGear,'bevel gear') ).

fof(kb_SUMO_605,axiom,
    s__documentation(s__BevelGear,s__EnglishLanguage,'A &%Gear that is shaped as a segment of a &%Cone, which allows axles connected to a pair of gears not to be parallel.') ).

fof(kb_SUMO_606,axiom,
    ! [V__BV] :
      ( s__instance(V__BV,s__Object)
     => ( s__instance(V__BV,s__BevelGear)
       => s__attribute(V__BV,s__ConeSegment) ) ) ).

fof(kb_SUMO_607,axiom,
    s__instance(s__ConeSegment,s__ShapeAttribute) ).

fof(kb_SUMO_608,axiom,
    s__termFormat(s__EnglishLanguage,s__ConeSegment,'cone segment') ).

fof(kb_SUMO_609,axiom,
    s__documentation(s__ConeSegment,s__EnglishLanguage,'A &%ShapeAttribute that specifies a figure described by rotating a quadrilateral with two &%RightAngles around its right-angled axis.') ).

fof(kb_SUMO_610,axiom,
    s__instance(s__typicalTemporalPart__m,s__BinaryRelation) ).

fof(kb_SUMO_611,axiom,
    s__instance(s__typicalTemporalPart__m,s__TemporalRelation) ).

fof(kb_SUMO_612,axiom,
    s__relatedInternalConcept(s__typicalTemporalPart__m,s__temporalPart__m) ).

fof(kb_SUMO_613,axiom,
    s__relatedInternalConcept(s__typicalTemporalPart__m,s__typicalPart__m) ).

fof(kb_SUMO_614,axiom,
    s__format(s__EnglishLanguage,s__typicalTemporalPart__m,'a %1 is typically a part of a %2') ).

fof(kb_SUMO_615,axiom,
    s__documentation(s__typicalTemporalPart__m,s__EnglishLanguage,'An instance of the first argument is typically a temporal part of an instance of the second argument. This is a class-level relation roughly corresponding to &%temporalPart. Note that this does not imply that such wholes typically have such parts.') ).

fof(kb_SUMO_616,axiom,
    s__domainSubclass(s__typicalTemporalPart__m,"1",s__Process) ).

fof(kb_SUMO_617,axiom,
    s__domainSubclass(s__typicalTemporalPart__m,"2",s__Process) ).

fof(kb_SUMO_618,axiom,
    ! [V__PART,V__WHOLE] :
      ( ( s__subclass(V__WHOLE,s__Process)
        & s__instance(V__WHOLE,s__SetOrClass)
        & s__subclass(V__PART,s__Process)
        & s__instance(V__PART,s__SetOrClass) )
     => ( s__typicalTemporalPart(V__PART,V__WHOLE)
       => ? [V__X,V__Y] :
            ( s__instance(V__Y,s__TimePosition)
            & s__instance(V__X,s__TimePosition)
            & s__instance(V__X,V__WHOLE)
            & s__instance(V__Y,V__PART)
            & s__temporalPart(V__Y,V__X) ) ) ) ).

fof(kb_SUMO_619,axiom,
    ! [V__NOTPARTPROB,V__PART,V__PARTPROB,V__X,V__WHOLE] :
      ( ( s__subclass(V__WHOLE,s__Process)
        & s__instance(V__WHOLE,s__SetOrClass)
        & s__instance(V__X,s__TimePosition)
        & s__instance(V__PARTPROB,s__Quantity)
        & s__subclass(V__PART,s__Process)
        & s__instance(V__PART,s__SetOrClass)
        & s__instance(V__NOTPARTPROB,s__Quantity) )
     => ( ( s__typicalTemporalPart(V__PART,V__WHOLE)
          & s__instance(V__X,V__PART)
          & V__PARTPROB = s__ProbabilityFn('(? [V__Y] : (s__instance(V__Y,s__TimePosition) & s__instance(V__Y,V__WHOLE) & s__temporalPart(V__X,V__Y)))')
          & V__NOTPARTPROB = s__ProbabilityFn('(~ (? [V__Z] : (s__instance(V__Z,s__TimePosition) & s__instance(V__Z,V__WHOLE) & s__temporalPart(V__X,V__Z))))') )
       => greater(V__PARTPROB,V__NOTPARTPROB) ) ) ).

fof(kb_SUMO_620,axiom,
    s__instance(s__typicallyContainsTemporalPart__m,s__BinaryRelation) ).

fof(kb_SUMO_621,axiom,
    s__instance(s__typicallyContainsTemporalPart__m,s__TemporalRelation) ).

fof(kb_SUMO_622,axiom,
    s__relatedInternalConcept(s__typicallyContainsTemporalPart__m,s__typicallyContainsPart__m) ).

fof(kb_SUMO_623,axiom,
    s__relatedInternalConcept(s__typicallyContainsTemporalPart__m,s__temporalPart__m) ).

fof(kb_SUMO_624,axiom,
    s__format(s__EnglishLanguage,s__typicallyContainsTemporalPart__m,'a %2 typically contains a %1') ).

fof(kb_SUMO_625,axiom,
    s__documentation(s__typicallyContainsTemporalPart__m,s__EnglishLanguage,'An instance of the second argument typically contains an instance of the first argument. This is a class-level relation roughly corresponding to &%part. Note that this does not imply that such parts typically have such wholes.') ).

fof(kb_SUMO_626,axiom,
    s__domainSubclass(s__typicallyContainsTemporalPart__m,"1",s__Process) ).

fof(kb_SUMO_627,axiom,
    s__domainSubclass(s__typicallyContainsTemporalPart__m,"2",s__Process) ).

fof(kb_SUMO_628,axiom,
    ! [V__PART,V__WHOLE] :
      ( ( s__subclass(V__WHOLE,s__Process)
        & s__instance(V__WHOLE,s__SetOrClass)
        & s__subclass(V__PART,s__Process)
        & s__instance(V__PART,s__SetOrClass) )
     => ( s__typicallyContainsTemporalPart(V__PART,V__WHOLE)
       => ? [V__X,V__Y] :
            ( s__instance(V__Y,s__TimePosition)
            & s__instance(V__X,s__TimePosition)
            & s__instance(V__X,V__WHOLE)
            & s__instance(V__Y,V__PART)
            & s__temporalPart(V__Y,V__X) ) ) ) ).

fof(kb_SUMO_629,axiom,
    ! [V__NOTPARTPROB,V__PART,V__PARTPROB,V__WHOLE,V__Y] :
      ( ( s__instance(V__Y,s__TimePosition)
        & s__subclass(V__WHOLE,s__Process)
        & s__instance(V__WHOLE,s__SetOrClass)
        & s__instance(V__PARTPROB,s__Quantity)
        & s__subclass(V__PART,s__Process)
        & s__instance(V__PART,s__SetOrClass)
        & s__instance(V__NOTPARTPROB,s__Quantity) )
     => ( ( s__typicallyContainsTemporalPart(V__PART,V__WHOLE)
          & s__instance(V__Y,V__WHOLE)
          & V__PARTPROB = s__ProbabilityFn('(? [V__X1] : (s__instance(V__X1,s__TimePosition) & s__instance(V__X1,V__PART) & s__temporalPart(V__X1,V__Y)))')
          & V__NOTPARTPROB = s__ProbabilityFn('(~ (? [V__X2] : (s__instance(V__X2,s__TimePosition) & s__instance(V__X2,V__PART) & s__temporalPart(V__X2,V__Y))))') )
       => greater(V__PARTPROB,V__NOTPARTPROB) ) ) ).

fof(kb_SUMO_630,axiom,
    s__subclass(s__BleedingAir,s__LiquidMotion) ).

fof(kb_SUMO_631,axiom,
    s__instance(s__BleedingAir__t,s__SetOrClass) ).

fof(kb_SUMO_632,axiom,
    s__subclass(s__BleedingAir,s__Removing) ).

fof(kb_SUMO_633,axiom,
    s__termFormat(s__EnglishLanguage,s__BleedingAir,'bleeding air') ).

fof(kb_SUMO_634,axiom,
    s__documentation(s__BleedingAir,s__EnglishLanguage,'The process of removing fluid under pressure to locate and remove pockets of &%Air. This is done typically in hydraulic applications since air is compressible, and therefore undesirable in a hydraulic line.') ).

fof(kb_SUMO_635,axiom,
    ! [V__BA] :
      ( ( s__instance(V__BA,s__Physical)
        & s__instance(V__BA,s__TimePosition) )
     => ( s__instance(V__BA,s__BleedingAir)
       => s__hasPurpose(V__BA,'(? [V__FC,V__A] : (s__instance(V__A,s__Object) & s__instance(V__FC,s__SelfConnectedObject) & s__instance(V__FC,s__FluidContainer) & s__instance(V__A,s__Air) & s__holdsDuring(s__ImmediatePastFn(V__BA),s__contains(V__FC,V__A)) & s__holdsDuring(s__ImmediateFutureFn(V__BA),(~ s__contains(V__FC,V__A)))))') ) ) ).

fof(kb_SUMO_636,axiom,
    s__instance(s__cylinderBore__m,s__SpatialRelation) ).

fof(kb_SUMO_637,axiom,
    s__instance(s__cylinderBore__m,s__BinaryRelation) ).

fof(kb_SUMO_638,axiom,
    s__format(s__EnglishLanguage,s__cylinderBore__m,'the bore of %1 is %2') ).

fof(kb_SUMO_639,axiom,
    s__documentation(s__cylinderBore__m,s__EnglishLanguage,'The diameter of a cylindrical &%Hole.') ).

fof(kb_SUMO_640,axiom,
    s__domain(s__cylinderBore__m,"1",s__Cylinder) ).

fof(kb_SUMO_641,axiom,
    s__domain(s__cylinderBore__m,"2",s__LengthMeasure) ).

fof(kb_SUMO_642,axiom,
    ! [V__CY,V__CI,V__M] :
      ( ( s__instance(V__M,s__LengthMeasure)
        & s__instance(V__CI,s__Object)
        & s__instance(V__CY,s__Object) )
     => ( ( s__cylinderBore(V__CY,V__M)
          & s__instance(V__CY,s__Cylinder)
          & s__instance(V__CI,s__Circle)
          & s__part(V__CI,V__CY) )
       => s__diameter(V__CI,V__M) ) ) ).

fof(kb_SUMO_643,axiom,
    s__subclass(s__BleederValve,s__Valve) ).

fof(kb_SUMO_644,axiom,
    s__instance(s__BleederValve__t,s__SetOrClass) ).

fof(kb_SUMO_645,axiom,
    s__instance(s__Valve__t,s__SetOrClass) ).

fof(kb_SUMO_646,axiom,
    s__termFormat(s__EnglishLanguage,s__BleederValve,'bleeder valve') ).

fof(kb_SUMO_647,axiom,
    s__documentation(s__BleederValve,s__EnglishLanguage,'A &%Valve designed for use in &%BleedingAir, typically from hydraulics such a brake lines.') ).

fof(kb_SUMO_648,axiom,
    ! [V__BV] :
      ( s__instance(V__BV,s__Object)
     => ( s__instance(V__BV,s__BleederValve)
       => s__hasPurpose(V__BV,'(? [V__B] : (s__instance(V__B,s__Process) & s__instance(V__B,s__BleedingAir) & s__instrument(V__B,V__BV)))') ) ) ).

fof(kb_SUMO_649,axiom,
    s__typicalPart(s__BrakeCaliper,s__BrakeSystem) ).

fof(kb_SUMO_650,axiom,
    s__typicallyContainsPart(s__BrakeCaliper,s__BrakeSystem) ).

fof(kb_SUMO_651,axiom,
    ! [V__BC] :
      ( s__instance(V__BC,s__Object)
     => ( s__instance(V__BC,s__BrakeCaliper)
       => s__hasPurpose(V__BC,'(? [V__P,V__W] : (s__instance(V__P,s__Process) & s__instance(V__P,s__Pushing) & s__instrument(V__P,V__BC) & s__patient(V__P,V__W) & s__instance(V__W,s__WearingFrictionSurface)))') ) ) ).

fof(kb_SUMO_652,axiom,
    ! [V__BC] :
      ( s__instance(V__BC,s__Object)
     => ( s__instance(V__BC,s__BrakeCaliper)
       => s__hasPurpose(V__BC,'(? [V__B] : (s__instance(V__B,s__Process) & s__instance(V__B,s__Braking) & s__instrument(V__B,V__BC)))') ) ) ).

fof(kb_SUMO_653,axiom,
    s__subclass(s__HydraulicFluid,s__Mixture) ).

fof(kb_SUMO_654,axiom,
    s__instance(s__HydraulicFluid__t,s__SetOrClass) ).

fof(kb_SUMO_655,axiom,
    s__termFormat(s__EnglishLanguage,s__HydraulicFluid,'hydraulic fluid') ).

fof(kb_SUMO_656,axiom,
    s__documentation(s__HydraulicFluid,s__EnglishLanguage,'A &%Substance that is virtuall incompressible. It is intended to be used in its &%Liquid state. It can be thought of as a liquid gear, creating a mechanical advantage in a hydraulic system. Small amounts of fluid can be easily and rapidly added to a chamber that actuates a piston which can generate great force.') ).

fof(kb_SUMO_657,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__Object)
     => ( s__instance(V__H,s__HydraulicFluid)
       => s__hasPurpose(V__H,'(? [V__P] : (s__instance(V__P,s__Process) & s__instrument(V__P,V__H) & s__holdsDuring(s__WhenFn(V__P),s__attribute(V__H,s__Liquid))))') ) ) ).

fof(kb_SUMO_658,axiom,
    s__instance(s__objectTransferred__m,s__CaseRole) ).

fof(kb_SUMO_659,axiom,
    s__subrelation(s__objectTransferred__m,s__patient__m) ).

fof(kb_SUMO_660,axiom,
    s__domain(s__objectTransferred__m,"1",s__Transfer) ).

fof(kb_SUMO_661,axiom,
    s__domain(s__objectTransferred__m,"2",s__Object) ).

fof(kb_SUMO_662,axiom,
    s__format(s__EnglishLanguage,s__objectTransferred__m,'the object transferred in %1 is %n %2') ).

fof(kb_SUMO_663,axiom,
    s__documentation(s__objectTransferred__m,s__EnglishLanguage,'A relation that specifies the object that is transferred during the process. For example, in a &%Mailing process, the object transferred is a letter or package.') ).

%FOL fof(kb_SUMO_664,axiom,(( (! [V__OBJ,V__P] : ((s__instance(V__P,s__Transfer) & s__instance(V__P,s__TimePosition) & s__instance(V__OBJ,s__Object)) => (s__objectTransferred(V__P,V__OBJ) => (? [V__O,V__D] : (s__instance(V__D,s__Object) & s__instance(V__O,s__Object) & s__origin(V__P,V__O) & s__destination(V__P,V__D) & s__holdsDuring(s__ImmediatePastFn(V__P),'s__located(V__OBJ,V__O)') & s__holdsDuring(s__ImmediateFutureFn(V__P),'s__located(V__OBJ,V__D)')))))) ))).

fof(kb_SUMO_665,axiom,
    s__subclass(s__HydraulicCylinder,s__PhysicalSystem) ).

fof(kb_SUMO_666,axiom,
    s__instance(s__HydraulicCylinder__t,s__SetOrClass) ).

fof(kb_SUMO_667,axiom,
    s__termFormat(s__EnglishLanguage,s__HydraulicCylinder,'hydraulic cylinder') ).

fof(kb_SUMO_668,axiom,
    s__documentation(s__HydraulicCylinder,s__EnglishLanguage,'A &%Device consisting of a &%Hole that is the cylinder, and a &%Piston. Oil is forces into one part of the cylinder, moving the piston in the opposite direction, imparting force to a shaft that is part of the piston. Note that a cylinder without a piston, or a piston without a cylinder, is not considered a hydraulic cylinder. Both parts are essential to its identity.') ).

fof(kb_SUMO_669,axiom,
    ! [V__HC] :
      ( s__instance(V__HC,s__Object)
     => ( s__instance(V__HC,s__HydraulicCylinder)
       => ? [V__HH,V__C,V__P] :
            ( s__instance(V__P,s__Object)
            & s__instance(V__HH,s__Object)
            & s__instance(V__C,s__Hole)
            & V__HH = s__HoleHostFn(V__C)
            & s__attribute(V__C,s__Cylinder)
            & s__instance(V__P,s__Piston)
            & s__part(V__P,V__HC)
            & s__part(V__HH,V__HC) ) ) ) ).

fof(kb_SUMO_670,axiom,
    s__subclass(s__BrakeMasterCylinder,s__HydraulicCylinder) ).

fof(kb_SUMO_671,axiom,
    s__instance(s__BrakeMasterCylinder__t,s__SetOrClass) ).

fof(kb_SUMO_672,axiom,
    s__termFormat(s__EnglishLanguage,s__BrakeMasterCylinder,'master cylinder') ).

fof(kb_SUMO_673,axiom,
    s__documentation(s__BrakeMasterCylinder,s__EnglishLanguage,'This is the source of hydraulic pressure that actuates the &%BrakeCaliper, and is in turn actuated by the driver stepping on the &%BrakePedal.') ).

fof(kb_SUMO_674,axiom,
    ! [V__BMC] :
      ( s__instance(V__BMC,s__Object)
     => ( s__instance(V__BMC,s__BrakeMasterCylinder)
       => s__hasPurpose(V__BMC,'(? [V__BS] : (s__instance(V__BS,s__Object) & s__instance(V__BS,s__BrakeSystem) & s__part(V__BMC,V__BS)))') ) ) ).

fof(kb_SUMO_675,axiom,
    s__typicalPart(s__BrakeMasterCylinder,s__BrakeSystem) ).

fof(kb_SUMO_676,axiom,
    s__typicallyContainsPart(s__BrakeMasterCylinder,s__BrakeSystem) ).

fof(kb_SUMO_677,axiom,
    s__subclass(s__Cam,s__Device) ).

fof(kb_SUMO_678,axiom,
    s__instance(s__Cam__t,s__SetOrClass) ).

fof(kb_SUMO_679,axiom,
    s__termFormat(s__EnglishLanguage,s__Cam,cam) ).

fof(kb_SUMO_680,axiom,
    s__documentation(s__Cam,s__EnglishLanguage,'An eccentric lobe that presses against a valve or level as it rotates.') ).

fof(kb_SUMO_681,axiom,
    ! [V__C] :
      ( s__instance(V__C,s__Physical)
     => ( s__instance(V__C,s__Cam)
       => s__hasPurpose(V__C,'(? [V__R] : (s__instance(V__R,s__Process) & s__instance(V__R,s__Rotating) & s__patient(V__R,V__C)))') ) ) ).

fof(kb_SUMO_682,axiom,
    s__subclass(s__Camshaft,s__Shaft) ).

fof(kb_SUMO_683,axiom,
    s__instance(s__Camshaft__t,s__SetOrClass) ).

fof(kb_SUMO_684,axiom,
    s__termFormat(s__EnglishLanguage,s__Camshaft,camshaft) ).

fof(kb_SUMO_685,axiom,
    s__documentation(s__Camshaft,s__EnglishLanguage,'A rotating &%Shaft, tied to the &%Crankshaft, which serves to move &%Cams that open and close &%Valves in an &%InternalCombustionEngine.') ).

fof(kb_SUMO_686,axiom,
    ! [V__C] :
      ( s__instance(V__C,s__Physical)
     => ( s__instance(V__C,s__Camshaft)
       => s__hasPurpose(V__C,'(? [V__R] : (s__instance(V__R,s__Process) & s__instance(V__R,s__Rotating) & s__patient(V__R,V__C)))') ) ) ).

%FOL fof(kb_SUMO_687,axiom,(( (! [V__C,V__E,V__CS] : ((s__instance(V__CS,s__EngineeringComponent) & s__instance(V__E,s__Object) & s__instance(V__C,s__EngineeringComponent)) => ((s__instance(V__C,s__Cam) & s__instance(V__CS,s__Camshaft) & s__instance(V__E,s__Engine) & s__part(V__C,V__E) & s__part(V__CS,V__E)) => s__hasPurpose(V__CS,'s__connectedEngineeringComponents(V__C,V__CS)')))) ))).

fof(kb_SUMO_688,axiom,
    s__subclass(s__CharcoalFilter,s__Filter) ).

fof(kb_SUMO_689,axiom,
    s__instance(s__CharcoalFilter__t,s__SetOrClass) ).

fof(kb_SUMO_690,axiom,
    s__termFormat(s__EnglishLanguage,s__CharcoalFilter,'charcoal filter') ).

fof(kb_SUMO_691,axiom,
    s__documentation(s__CharcoalFilter,s__EnglishLanguage,'A &%Filter that uses &%Charcoal to remove impurities from a &%Gas or &%Liquid &%Mixture.') ).

fof(kb_SUMO_692,axiom,
    ! [V__CF] :
      ( s__instance(V__CF,s__CorpuscularObject)
     => ( s__instance(V__CF,s__CharcoalFilter)
       => ? [V__C] :
            ( s__subclass(V__C,s__Substance)
            & s__instance(V__C,s__Charcoal)
            & s__material(V__C,V__CF) ) ) ) ).

fof(kb_SUMO_693,axiom,
    s__subclass(s__CombustionChamber,s__Device) ).

fof(kb_SUMO_694,axiom,
    s__instance(s__CombustionChamber__t,s__SetOrClass) ).

fof(kb_SUMO_695,axiom,
    s__termFormat(s__EnglishLanguage,s__CombustionChamber,'combustion chamber') ).

fof(kb_SUMO_696,axiom,
    s__documentation(s__CombustionChamber,s__EnglishLanguage,'Any host of a &%Hole that is intended to contain &%Combustion events.') ).

fof(kb_SUMO_697,axiom,
    ! [V__CC] :
      ( s__instance(V__CC,s__CombustionChamber)
     => ? [V__H] :
          ( s__instance(V__H,s__Hole)
          & V__CC = s__HoleHostFn(V__H) ) ) ).

fof(kb_SUMO_698,axiom,
    s__subclass(s__CatalyticConverter,s__CombustionChamber) ).

fof(kb_SUMO_699,axiom,
    s__instance(s__CatalyticConverter__t,s__SetOrClass) ).

fof(kb_SUMO_700,axiom,
    s__termFormat(s__EnglishLanguage,s__CatalyticConverter,'catalytic converter') ).

fof(kb_SUMO_701,axiom,
    s__documentation(s__CatalyticConverter,s__EnglishLanguage,'A &%Device that decreases pollution output by creating a secondary &%Combustion, outside the &%Engine that burns any &%Fuel that is in the &%Exhaust of the primary combustion in the engine. It typically employs rare metals that act as catalysts for the chemical reaction.') ).

fof(kb_SUMO_702,axiom,
    s__typicalPart(s__CatalyticConverter,s__AutomobileExhaustSystem) ).

fof(kb_SUMO_703,axiom,
    s__typicallyContainsPart(s__CatalyticConverter,s__AutomobileExhaustSystem) ).

fof(kb_SUMO_704,axiom,
    ! [V__CC,V__T,V__E,V__ENG] :
      ( ( s__instance(V__ENG,s__Object)
        & s__instance(V__E,s__CorpuscularObject)
        & s__instance(V__CC,s__Object) )
     => ( ( s__instance(V__E,s__Exhaust)
          & s__material(s__Fuel,V__E)
          & s__instance(V__T,s__Transfer)
          & s__instance(V__ENG,s__Engine)
          & s__origin(V__T,V__ENG)
          & s__instance(V__CC,s__CatalyticConverter)
          & s__destination(V__T,V__CC)
          & s__objectTransferred(V__T,V__E) )
       => s__hasPurpose(V__CC,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Combustion) & s__instrument(V__C,V__CC) & s__patient(V__C,V__E) & s__eventLocated(V__C,V__CC)))') ) ) ).

fof(kb_SUMO_705,axiom,
    s__subclass(s__Cavitating,s__LiquidMotion) ).

fof(kb_SUMO_706,axiom,
    s__instance(s__Cavitating__t,s__SetOrClass) ).

fof(kb_SUMO_707,axiom,
    s__termFormat(s__EnglishLanguage,s__Cavitating,cavitating) ).

fof(kb_SUMO_708,axiom,
    s__documentation(s__Cavitating,s__EnglishLanguage,'A process whereby a &%PartialVacuum forms in a &%Liquid, near the blades or impellers of a &%Pump, reducing its ability to move the liquid.') ).

fof(kb_SUMO_709,axiom,
    ! [V__P,V__C,V__L1,V__L2] :
      ( ( s__instance(V__L2,s__Object)
        & s__instance(V__L1,s__Object)
        & s__instance(V__C,s__Physical)
        & s__instance(V__P,s__SelfConnectedObject) )
     => ( ( s__instance(V__C,s__Cavitating)
          & s__instance(V__P,s__Pump)
          & s__attribute(V__P,s__DeviceOn)
          & s__attribute(V__L1,s__Liquid)
          & s__contains(V__P,V__L1) )
       => ? [V__PP] :
            ( s__part(V__PP,V__P)
            & s__hasPurpose(V__PP,'(s__attribute(V__L2,s__Liquid) & s__meetsSpatially(V__L2,V__PP))')
            & s__holdsDuring(s__WhenFn(V__C),'(~ (? [V__L3] : (s__instance(V__L3,s__Object) & s__instance(V__PP,s__Object) & s__attribute(V__L3,s__Liquid) & s__meetsSpatially(V__PP,V__L3))))') ) ) ) ).

fof(kb_SUMO_710,axiom,
    s__instance(s__molecularRatio__m,s__TernaryRelation) ).

fof(kb_SUMO_711,axiom,
    s__format(s__EnglishLanguage,s__molecularRatio__m,'the number of molecules of %1 in a molecule of %3 is %n %2') ).

fof(kb_SUMO_712,axiom,
    s__documentation(s__molecularRatio__m,s__EnglishLanguage,'The number of molecules of a particular &%ElementalSubstance in a given &%CompoundSubstance.') ).

fof(kb_SUMO_713,axiom,
    s__domainSubclass(s__molecularRatio__m,"1",s__ElementalSubstance) ).

fof(kb_SUMO_714,axiom,
    s__domain(s__molecularRatio__m,"2",s__Integer) ).

fof(kb_SUMO_715,axiom,
    s__domainSubclass(s__molecularRatio__m,"3",s__CompoundSubstance) ).

fof(kb_SUMO_716,axiom,
    ! [V__ECLASS,V__CLASS,V__E,V__CS1,V__G,V__N] :
      ( ( s__instance(V__N,s__Integer)
        & s__instance(V__G,s__Collection)
        & s__instance(V__CS1,s__Object)
        & s__instance(V__E,s__SelfConnectedObject)
        & s__instance(V__CLASS,s__SetOrClass)
        & s__subclass(V__ECLASS,s__ElementalSubstance)
        & s__instance(V__ECLASS,s__SetOrClass) )
     => ( ( s__instance(V__CS1,V__CLASS)
          & s__subclass(V__CLASS,s__CompoundSubstance)
          & ~ ? [V__CS2] :
                ( s__instance(V__CS2,s__Object)
                & s__instance(V__CS2,V__CLASS)
                & s__part(V__CS2,V__CS1) )
          & s__molecularRatio(V__ECLASS,V__N,V__CLASS)
          & s__instance(V__G,s__Group)
          & s__member(V__E,V__G)
          & s__part(V__E,V__CS1)
          & s__instance(V__E,V__ECLASS) )
       => s__memberCount(V__G,V__N) ) ) ).

fof(kb_SUMO_717,axiom,
    s__subclass(s__Chlorofluorocarbon,s__CompoundSubstance) ).

fof(kb_SUMO_718,axiom,
    s__termFormat(s__EnglishLanguage,s__Chlorofluorocarbon,chlorofluorocarbon) ).

fof(kb_SUMO_719,axiom,
    s__documentation(s__Chlorofluorocarbon,s__EnglishLanguage,'A chlorofluorocarbon (CFC) is an organic compound that contains carbon, chlorine, and fluorine, produced as a volatile derivative of methane and ethane. A common subclass are the hydrochlorofluorocarbons (HCFCs), which contain hydrogen, as well. They are also commonly known by the DuPont trade name Freon. The most common representative is dichlorodifluoromethane (R-12 or Freon-12). Many CFCs have been widely used as refrigerants, propellants (in aerosol applications), and solvents. The manufacture of such compounds has been phased out by the Montreal Protocol because they contribute to ozone depletion. [from Wikipedia]') ).

fof(kb_SUMO_720,axiom,
    s__subclass(s__Freon12,s__Chlorofluorocarbon) ).

fof(kb_SUMO_721,axiom,
    s__instance(s__Freon12__t,s__SetOrClass) ).

fof(kb_SUMO_722,axiom,
    s__instance(s__Chlorofluorocarbon__t,s__SetOrClass) ).

fof(kb_SUMO_723,axiom,
    s__termFormat(s__EnglishLanguage,s__Freon12,'freon-12') ).

fof(kb_SUMO_724,axiom,
    s__documentation(s__Freon12,s__EnglishLanguage,'A &%Chlorofluorocarbon with formula CCl2F2, which prior to widespread environmental concerns about its use was the most common refridgerant.') ).

fof(kb_SUMO_725,axiom,
    s__molecularRatio(s__Carbon,"1",s__Freon12) ).

fof(kb_SUMO_726,axiom,
    s__molecularRatio(s__Chlorine,"2",s__Freon12) ).

fof(kb_SUMO_727,axiom,
    s__molecularRatio(s__Fluorine,"2",s__Freon12) ).

fof(kb_SUMO_728,axiom,
    s__subclass(s__Clutch,s__Device) ).

fof(kb_SUMO_729,axiom,
    s__instance(s__Clutch__t,s__SetOrClass) ).

fof(kb_SUMO_730,axiom,
    s__termFormat(s__EnglishLanguage,s__Clutch,clutch) ).

fof(kb_SUMO_731,axiom,
    s__documentation(s__Clutch,s__EnglishLanguage,'A &%Device used to engage and disengage moving parts. It consists of a friction plate and a spring-loaded mechanism that engages the plate with varying force as the clutch is released. In an &%Automobile it ultimately connects the &%Engine with the &%Gearbox. For the purposes of this definition, we consider the &%DeviceOn state of the clutch to mean that it is not engaged with the clutch plate.') ).

fof(kb_SUMO_732,axiom,
    ! [V__A,V__C,V__E,V__G,V__M,V__GEAR] :
      ( ( s__instance(V__GEAR,s__Object)
        & s__instance(V__M,s__Process)
        & s__instance(V__G,s__Object)
        & s__instance(V__E,s__Object)
        & s__instance(V__C,s__Object)
        & s__instance(V__A,s__Object) )
     => ( ( s__instance(V__C,s__Clutch)
          & s__instance(V__A,s__Automobile)
          & s__instance(V__E,s__Engine)
          & s__instance(V__G,s__Gearbox)
          & s__instance(V__GEAR,s__Gear)
          & s__part(V__GEAR,V__G)
          & s__part(V__G,V__A)
          & s__part(V__C,V__A)
          & s__part(V__E,V__A)
          & s__instance(V__M,s__Motion)
          & s__patient(V__M,V__E)
          & s__attribute(V__C,s__DeviceOn) )
       => ~ ? [V__M2] :
              ( s__instance(V__M2,s__Process)
              & s__instance(V__M2,s__Motion)
              & s__patient(V__M2,V__G)
              & s__causes(V__M,V__M2) ) ) ) ).

fof(kb_SUMO_733,axiom,
    ! [V__A,V__C,V__E,V__G,V__M,V__GEAR] :
      ( ( s__instance(V__GEAR,s__Object)
        & s__instance(V__M,s__Process)
        & s__instance(V__G,s__Object)
        & s__instance(V__E,s__Object)
        & s__instance(V__C,s__Object)
        & s__instance(V__A,s__Object) )
     => ( ( s__instance(V__C,s__Clutch)
          & s__instance(V__A,s__Automobile)
          & s__instance(V__E,s__Engine)
          & s__instance(V__G,s__Gearbox)
          & s__instance(V__GEAR,s__Gear)
          & s__part(V__GEAR,V__G)
          & s__part(V__G,V__A)
          & s__part(V__C,V__A)
          & s__part(V__E,V__A)
          & s__instance(V__M,s__Motion)
          & s__patient(V__M,V__E)
          & s__attribute(V__C,s__DeviceOff) )
       => ? [V__M2] :
            ( s__instance(V__M2,s__Process)
            & s__instance(V__M2,s__Motion)
            & s__patient(V__M2,V__G)
            & s__causes(V__M,V__M2) ) ) ) ).

fof(kb_SUMO_734,axiom,
    s__instance(s__minCylinderVolume__m,s__BinaryRelation) ).

fof(kb_SUMO_735,axiom,
    s__domain(s__minCylinderVolume__m,"1",s__Engine) ).

fof(kb_SUMO_736,axiom,
    s__domain(s__minCylinderVolume__m,"2",s__VolumeMeasure) ).

fof(kb_SUMO_737,axiom,
    s__format(s__EnglishLanguage,s__minCylinderVolume__m,'the minimum volume of the cylinders in the engine %1 is %n %2') ).

fof(kb_SUMO_738,axiom,
    s__documentation(s__minCylinderVolume__m,s__EnglishLanguage,'The volume of the &%CombustionChamber of the &%EngineCylinder at the maximum point of compression of the cylinder.') ).

%FOL fof(kb_SUMO_739,axiom,(( (! [V__CC,V__E,V__EC,V__V1] : ((s__instance(V__V1,s__VolumeMeasure) & s__instance(V__EC,s__Process) & s__instance(V__E,s__Engine) & s__instance(V__CC,s__Object)) => ((s__instance(V__EC,s__EngineCycle) & s__instance(V__E,s__InternalCombustionEngine) & s__instance(V__CC,s__CombustionChamber) & s__part(V__CC,V__E) & s__eventLocated(V__EC,V__E) & s__holdsDuring(s__WhenFn(V__EC),'s__minCylinderVolume(V__E,V__V1)')) => (~ (? [V__V2,V__T] : (s__instance(V__T,s__TimeInterval) & s__instance(V__V2,s__PhysicalQuantity) & s__during(V__T,s__WhenFn(V__EC)) & s__holdsDuring(V__T,'s__measure(V__CC,V__V2)') & greater(V__V1,V__V2))))))) ))).

fof(kb_SUMO_740,axiom,
    s__instance(s__maxCylinderVolume__m,s__BinaryRelation) ).

fof(kb_SUMO_741,axiom,
    s__domain(s__maxCylinderVolume__m,"1",s__Engine) ).

fof(kb_SUMO_742,axiom,
    s__domain(s__maxCylinderVolume__m,"2",s__VolumeMeasure) ).

fof(kb_SUMO_743,axiom,
    s__format(s__EnglishLanguage,s__maxCylinderVolume__m,'the maximum volume of the cylinders in the engine %1 is %n %2') ).

fof(kb_SUMO_744,axiom,
    s__documentation(s__maxCylinderVolume__m,s__EnglishLanguage,'The volume of the &%CombustionChamber of the &%EngineCylinder at the maximum point of extension of the piston.') ).

%FOL fof(kb_SUMO_745,axiom,(( (! [V__CC,V__E,V__EC,V__V1] : ((s__instance(V__V1,s__VolumeMeasure) & s__instance(V__EC,s__Process) & s__instance(V__E,s__Engine) & s__instance(V__CC,s__Object)) => ((s__instance(V__EC,s__EngineCycle) & s__instance(V__E,s__InternalCombustionEngine) & s__instance(V__CC,s__CombustionChamber) & s__part(V__CC,V__E) & s__eventLocated(V__EC,V__E) & s__holdsDuring(s__WhenFn(V__EC),'s__maxCylinderVolume(V__E,V__V1)')) => (~ (? [V__V2,V__T] : (s__instance(V__T,s__TimeInterval) & s__instance(V__V2,s__PhysicalQuantity) & s__during(V__T,s__WhenFn(V__EC)) & s__holdsDuring(V__T,'s__measure(V__CC,V__V2)') & greater(V__V2,V__V1))))))) ))).

fof(kb_SUMO_746,axiom,
    s__instance(s__compressionRatio__m,s__BinaryRelation) ).

fof(kb_SUMO_747,axiom,
    s__domain(s__compressionRatio__m,"1",s__Engine) ).

fof(kb_SUMO_748,axiom,
    s__domain(s__compressionRatio__m,"2",s__RealNumber) ).

fof(kb_SUMO_749,axiom,
    s__format(s__EnglishLanguage,s__compressionRatio__m,'the compression ratio of %1 is %n %2') ).

fof(kb_SUMO_750,axiom,
    s__documentation(s__compressionRatio__m,s__EnglishLanguage,'The ratio of the volume of the &%CombustionChamber of the &%EngineCylinder at the maximum point of compression of the cylinder, to the volume of the chamber with the piston fully retracted.') ).

fof(kb_SUMO_751,axiom,
    ! [V__MIN,V__R,V__MAX,V__E,V__M] :
      ( ( s__instance(V__M,s__UnitOfMeasure)
        & s__instance(V__E,s__Engine)
        & s__instance(V__MAX,s__RealNumber)
        & s__instance(V__R,s__RealNumber)
        & s__instance(V__MIN,s__RealNumber) )
     => ( s__compressionRatio(V__E,V__R)
      <=> ( s__minCylinderVolume(V__E,s__MeasureFn(V__MIN,V__M))
          & s__maxCylinderVolume(V__E,s__MeasureFn(V__MAX,V__M))
          & V__R = divide(V__MIN,V__MAX) ) ) ) ).

fof(kb_SUMO_752,axiom,
    s__instance(s__pistonStroke__m,s__BinaryRelation) ).

fof(kb_SUMO_753,axiom,
    s__subrelation(s__pistonStroke__m,s__distance__m) ).

fof(kb_SUMO_754,axiom,
    s__domain(s__pistonStroke__m,"1",s__Engine) ).

fof(kb_SUMO_755,axiom,
    s__domain(s__pistonStroke__m,"2",s__LengthMeasure) ).

fof(kb_SUMO_756,axiom,
    s__format(s__EnglishLanguage,s__pistonStroke__m,'the maximum distance that the pistons of engine %1 travel is %n %2') ).

fof(kb_SUMO_757,axiom,
    s__documentation(s__pistonStroke__m,s__EnglishLanguage,'The maximum &%distance that a piston travels during normal operation of the &%Engine.') ).

fof(kb_SUMO_758,axiom,
    s__subclass(s__EngineConnectingRod,s__Device) ).

fof(kb_SUMO_759,axiom,
    s__instance(s__EngineConnectingRod__t,s__SetOrClass) ).

fof(kb_SUMO_760,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineConnectingRod,'engine connecting rod') ).

fof(kb_SUMO_761,axiom,
    s__documentation(s__EngineConnectingRod,s__EnglishLanguage,'A &%Device that connects the &%Piston to the &%Crankshaft.') ).

fof(kb_SUMO_762,axiom,
    ! [V__ECR] :
      ( s__instance(V__ECR,s__EngineeringComponent)
     => ( s__instance(V__ECR,s__EngineConnectingRod)
       => s__hasPurpose(V__ECR,'(? [V__P,V__C] : (s__instance(V__C,s__EngineeringComponent) & s__instance(V__P,s__EngineeringComponent) & s__instance(V__P,s__Piston) & s__instance(V__C,s__Crankshaft) & s__connectedEngineeringComponents(V__P,V__ECR) & s__connectedEngineeringComponents(V__C,V__ECR)))') ) ) ).

fof(kb_SUMO_763,axiom,
    s__subclass(s__Compressing,s__Motion) ).

fof(kb_SUMO_764,axiom,
    s__instance(s__Compressing__t,s__SetOrClass) ).

fof(kb_SUMO_765,axiom,
    s__termFormat(s__EnglishLanguage,s__Compressing,compressing) ).

fof(kb_SUMO_766,axiom,
    s__documentation(s__Compressing,s__EnglishLanguage,'Forcing some &%SelfConnectedObject into a smaller space than at the beginning of the action.') ).

%FOL fof(kb_SUMO_767,axiom,(( (! [V__SCO,V__N2,V__N1,V__C,V__V] : ((s__instance(V__V,s__UnitOfMeasure) & s__instance(V__C,s__Process) & s__instance(V__N1,s__RealNumber) & s__instance(V__N2,s__RealNumber) & s__instance(V__SCO,s__Object)) => ((s__instance(V__SCO,s__SelfConnectedObject) & s__instance(V__C,s__Compressing) & s__patient(V__C,V__SCO) & s__holdsDuring(s__ImmediatePastFn(s__WhenFn(V__C)),'s__measure(V__SCO,s__MeasureFn(V__N1,V__V))') & s__instance(V__V,s__VolumeMeasure) & s__holdsDuring(s__ImmediateFutureFn(s__WhenFn(V__C)),'s__measure(V__SCO,s__MeasureFn(V__N2,V__V))')) => greater(V__N1,V__N2)))) ))).

fof(kb_SUMO_768,axiom,
    s__subclass(s__AirConditioningCompressor,s__GasCompressor) ).

fof(kb_SUMO_769,axiom,
    s__instance(s__AirConditioningCompressor__t,s__SetOrClass) ).

fof(kb_SUMO_770,axiom,
    s__termFormat(s__EnglishLanguage,s__AirConditioningCompressor,'air conditioning compressor') ).

fof(kb_SUMO_771,axiom,
    s__documentation(s__AirConditioningCompressor,s__EnglishLanguage,'A &%Machine that pulls refrigerant in its &%Gas state out of the &%AirConditioningEvaporator and subjects it to &%Compressing in a &%VaporCompressionCycle.') ).

fof(kb_SUMO_772,axiom,
    s__typicalPart(s__AirConditioningCompressor,s__AirConditioner) ).

fof(kb_SUMO_773,axiom,
    s__typicallyContainsPart(s__AirConditioningCompressor,s__AirConditioner) ).

fof(kb_SUMO_774,axiom,
    ! [V__ACC] :
      ( s__instance(V__ACC,s__Object)
     => ( s__instance(V__ACC,s__AirConditioningCompressor)
       => s__hasPurpose(V__ACC,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Cooling) & s__instrument(V__C,V__ACC)))') ) ) ).

fof(kb_SUMO_775,axiom,
    s__subclass(s__VaporCompressionCycle,s__Cooling) ).

fof(kb_SUMO_776,axiom,
    s__instance(s__VaporCompressionCycle__t,s__SetOrClass) ).

fof(kb_SUMO_777,axiom,
    s__termFormat(s__EnglishLanguage,s__VaporCompressionCycle,'vapor compression cycle') ).

fof(kb_SUMO_778,axiom,
    s__documentation(s__VaporCompressionCycle,s__EnglishLanguage,'A complete cycle of &%Compressing, &%Condensing and &%Evaporating, for the purpose of &%Cooling.') ).

fof(kb_SUMO_779,axiom,
    s__externalImage(s__VaporCompressionCycle,'http://upload.wikimedia.org/wikipedia/commons/5/5d/Refrigeration.png') ).

fof(kb_SUMO_780,axiom,
    ! [V__VCC] :
      ( s__instance(V__VCC,s__Process)
     => ( s__instance(V__VCC,s__VaporCompressionCycle)
       => ? [V__CMP,V__COND,V__EV,V__CMP2] :
            ( s__instance(V__CMP2,s__Process)
            & s__instance(V__EV,s__Process)
            & s__instance(V__COND,s__Process)
            & s__instance(V__CMP,s__Process)
            & s__instance(V__CMP,s__Compressing)
            & s__instance(V__COND,s__Condensing)
            & s__instance(V__EV,s__Evaporating)
            & s__instance(V__CMP2,s__Compressing)
            & s__subProcess(V__CMP,V__VCC)
            & s__subProcess(V__COND,V__VCC)
            & s__subProcess(V__EV,V__VCC)
            & s__subProcess(V__CMP2,V__VCC)
            & s__meetsTemporally(s__WhenFn(V__CMP),s__WhenFn(V__COND))
            & s__meetsTemporally(s__WhenFn(V__COND),s__WhenFn(V__EV))
            & s__meetsTemporally(s__WhenFn(V__EV),s__WhenFn(V__CMP2)) ) ) ) ).

fof(kb_SUMO_781,axiom,
    s__subclass(s__AirConditioningCondenser,s__Machine) ).

fof(kb_SUMO_782,axiom,
    s__instance(s__AirConditioningCondenser__t,s__SetOrClass) ).

fof(kb_SUMO_783,axiom,
    s__termFormat(s__EnglishLanguage,s__AirConditioningCondenser,'air conditioning condenser') ).

fof(kb_SUMO_784,axiom,
    s__documentation(s__AirConditioningCondenser,s__EnglishLanguage,'A &%Machine that pulls compressed refrigerant in its &%Gas state out of the &%AirConditioningCompressor and turns it into a &%Liquid via a &%VaporCompressionCycle.') ).

fof(kb_SUMO_785,axiom,
    s__typicalPart(s__AirConditioningCondenser,s__AirConditioner) ).

fof(kb_SUMO_786,axiom,
    s__typicallyContainsPart(s__AirConditioningCondenser,s__AirConditioner) ).

fof(kb_SUMO_787,axiom,
    ! [V__ACC] :
      ( s__instance(V__ACC,s__Object)
     => ( s__instance(V__ACC,s__AirConditioningCondenser)
       => s__hasPurpose(V__ACC,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Cooling) & s__instrument(V__C,V__ACC)))') ) ) ).

fof(kb_SUMO_788,axiom,
    ! [V__ACC] :
      ( s__instance(V__ACC,s__Object)
     => ( s__instance(V__ACC,s__AirConditioningCondenser)
       => s__hasPurpose(V__ACC,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Condensing) & s__instrument(V__C,V__ACC)))') ) ) ).

fof(kb_SUMO_789,axiom,
    s__subclass(s__AirConditioningEvaporator,s__Machine) ).

fof(kb_SUMO_790,axiom,
    s__instance(s__AirConditioningEvaporator__t,s__SetOrClass) ).

fof(kb_SUMO_791,axiom,
    s__termFormat(s__EnglishLanguage,s__AirConditioningEvaporator,'air conditioning evaporator') ).

fof(kb_SUMO_792,axiom,
    s__documentation(s__AirConditioningEvaporator,s__EnglishLanguage,'A &%Machine that pulls refrigerant in its &%Liquid state out of the &%AirConditioningCondenser and turns it into a &%Gas via a &%VaporCompressionCycle.') ).

fof(kb_SUMO_793,axiom,
    s__typicalPart(s__AirConditioningEvaporator,s__AirConditioner) ).

fof(kb_SUMO_794,axiom,
    s__typicallyContainsPart(s__AirConditioningEvaporator,s__AirConditioner) ).

fof(kb_SUMO_795,axiom,
    ! [V__ACE] :
      ( s__instance(V__ACE,s__Object)
     => ( s__instance(V__ACE,s__AirConditioningEvaporator)
       => s__hasPurpose(V__ACE,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Cooling) & s__instrument(V__C,V__ACE)))') ) ) ).

fof(kb_SUMO_796,axiom,
    ! [V__ACE,V__E] :
      ( s__instance(V__ACE,s__Object)
     => ( s__instance(V__ACE,s__AirConditioningEvaporator)
       => s__hasPurpose(V__ACE,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__E,s__Evaporating) & s__instrument(V__C,V__ACE)))') ) ) ).

fof(kb_SUMO_797,axiom,
    s__instance(s__RevolutionsPerMinute,s__UnitOfMeasure) ).

fof(kb_SUMO_798,axiom,
    s__termFormat(s__EnglishLanguage,s__RevolutionsPerMinute,'revolutions per minute') ).

fof(kb_SUMO_799,axiom,
    s__documentation(s__RevolutionsPerMinute,s__EnglishLanguage,'The number of complete revolutions in one plane of motion for a given object.') ).

fof(kb_SUMO_800,axiom,
    s__instance(s__RotationFn__m,s__BinaryFunction) ).

fof(kb_SUMO_801,axiom,
    s__format(s__EnglishLanguage,s__RotationFn__m,'the rotation of %1 during %2') ).

fof(kb_SUMO_802,axiom,
    s__documentation(s__RotationFn__m,s__EnglishLanguage,'A &%Function that maps an instance of &%Rotating to the speed of the rotation.') ).

fof(kb_SUMO_803,axiom,
    s__domain(s__RotationFn__m,"1",s__Rotating) ).

fof(kb_SUMO_804,axiom,
    s__domain(s__RotationFn__m,"2",s__TimeDuration) ).

fof(kb_SUMO_805,axiom,
    s__range(s__RotationFn__m,s__FunctionQuantity) ).

fof(kb_SUMO_806,axiom,
    s__subclass(s__CVJoint,s__MechanicalJoint) ).

fof(kb_SUMO_807,axiom,
    s__instance(s__CVJoint__t,s__SetOrClass) ).

fof(kb_SUMO_808,axiom,
    s__termFormat(s__EnglishLanguage,s__CVJoint,'C.V. joint') ).

fof(kb_SUMO_809,axiom,
    s__documentation(s__CVJoint,s__EnglishLanguage,'A &%MechanicalJoint that allows two joined shafts to turn at the same speed throughout a range of angles with respect to each other. The most common type of CV joint is a &%BallJoint, although there are also other kinds.') ).

fof(kb_SUMO_810,axiom,
    ! [V__R2,V__T,V__R1,V__SH2,V__SH1,V__CV,V__N] :
      ( ( s__instance(V__N,s__Rotating)
        & s__instance(V__CV,s__EngineeringComponent)
        & s__instance(V__R1,s__Process)
        & s__instance(V__R1,s__EngineeringComponent)
        & s__instance(V__T,s__TimeDuration)
        & s__instance(V__R2,s__Process)
        & s__instance(V__R2,s__EngineeringComponent) )
     => ( ( s__instance(V__SH1,s__Shaft)
          & s__instance(V__SH2,s__Shaft)
          & V__SH1 != V__SH2
          & s__instance(V__R1,s__Rotating)
          & s__patient(V__R1,V__SH1)
          & s__instance(V__R2,s__Rotating)
          & s__patient(V__R2,V__SH2)
          & s__causes(V__R1,V__R2)
          & s__instance(V__CV,s__CVJoint)
          & s__connectedEngineeringComponents(V__R1,V__CV)
          & s__connectedEngineeringComponents(V__R2,V__CV)
          & s__holdsDuring(s__WhenFn(V__R1),'(V__SH1 = s__RotationFn(V__N,V__T))') )
       => s__holdsDuring(s__WhenFn(V__R2),'(V__SH2 = s__RotationFn(V__N,V__T))') ) ) ).

fof(kb_SUMO_811,axiom,
    s__subclass(s__EngineCoolingSystem,s__PhysicalSystem) ).

fof(kb_SUMO_812,axiom,
    s__instance(s__EngineCoolingSystem__t,s__SetOrClass) ).

fof(kb_SUMO_813,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineCoolingSystem,'engine cooling system') ).

fof(kb_SUMO_814,axiom,
    s__documentation(s__EngineCoolingSystem,s__EnglishLanguage,'A system designed to keep the engine cool (and therefore prevent it from seizing), that may also heat the passenger compartment as a byproduct.') ).

fof(kb_SUMO_815,axiom,
    s__typicallyContainsPart(s__EngineCoolingSystem,s__Pump) ).

fof(kb_SUMO_816,axiom,
    ! [V__A,V__ECS,V__E] :
      ( ( s__instance(V__E,s__Object)
        & s__instance(V__ECS,s__Object)
        & s__instance(V__A,s__Object) )
     => ( ( s__instance(V__ECS,s__EngineCoolingSystem)
          & s__instance(V__E,s__Engine)
          & s__instance(V__A,s__Automobile)
          & s__part(V__ECS,V__A)
          & s__part(V__E,V__A) )
       => s__hasPurpose(V__ECS,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Cooling) & s__instrument(V__C,V__ECS) & s__patient(V__C,V__E)))') ) ) ).

fof(kb_SUMO_817,axiom,
    s__subclass(s__LiquidEngineCoolingSystem,s__EngineCoolingSystem) ).

fof(kb_SUMO_818,axiom,
    s__instance(s__LiquidEngineCoolingSystem__t,s__SetOrClass) ).

fof(kb_SUMO_819,axiom,
    s__termFormat(s__EnglishLanguage,s__LiquidEngineCoolingSystem,'water cooling system') ).

fof(kb_SUMO_820,axiom,
    s__documentation(s__LiquidEngineCoolingSystem,s__EnglishLanguage,'A kind of &%EngineCoolingSystem found in most &%Automobiles, that uses a liquid coolant to cool the &%Engine. It consists of a series of tubes through which a coolant can flow, a radiator, a pump, and a temperature sensor that allows the engine to reach a normal operating temperature before starting the cooling mechanism.') ).

fof(kb_SUMO_821,axiom,
    s__typicallyContainsPart(s__Thermometer,s__LiquidEngineCoolingSystem) ).

fof(kb_SUMO_822,axiom,
    ! [V__C,V__LECS] :
      ( ( s__instance(V__LECS,s__Object)
        & s__instance(V__C,s__Transfer) )
     => ( ( s__instance(V__LECS,s__LiquidEngineCoolingSystem)
          & s__instance(V__C,s__Cooling)
          & s__instrument(V__C,V__LECS) )
       => ? [V__L] :
            ( s__instance(V__L,s__Object)
            & s__attribute(V__L,s__Liquid)
            & s__objectTransferred(V__C,V__L) ) ) ) ).

fof(kb_SUMO_823,axiom,
    s__subclass(s__AirEngineCoolingSystem,s__EngineCoolingSystem) ).

fof(kb_SUMO_824,axiom,
    s__instance(s__AirEngineCoolingSystem__t,s__SetOrClass) ).

fof(kb_SUMO_825,axiom,
    s__termFormat(s__EnglishLanguage,s__AirEngineCoolingSystem,'air cooling system') ).

fof(kb_SUMO_826,axiom,
    s__documentation(s__AirEngineCoolingSystem,s__EnglishLanguage,'A kind of &%EngineCoolingSystem less commonly found in &%Automobiles than a &%LiquidEngineCoolingSystem. It uses a &%Air to cool the &%Engine.') ).

fof(kb_SUMO_827,axiom,
    ! [V__C,V__LECS] :
      ( ( s__instance(V__LECS,s__Object)
        & s__instance(V__C,s__Transfer) )
     => ( ( s__instance(V__LECS,s__AirEngineCoolingSystem)
          & s__instance(V__C,s__Cooling)
          & s__instrument(V__C,V__LECS) )
       => ? [V__A] :
            ( s__instance(V__A,s__Object)
            & s__instance(V__A,s__Air)
            & s__objectTransferred(V__C,V__A) ) ) ) ).

fof(kb_SUMO_828,axiom,
    s__subclass(s__Radiator,s__EngineeringComponent) ).

fof(kb_SUMO_829,axiom,
    s__instance(s__Radiator__t,s__SetOrClass) ).

fof(kb_SUMO_830,axiom,
    s__termFormat(s__EnglishLanguage,s__Radiator,radiator) ).

fof(kb_SUMO_831,axiom,
    s__documentation(s__Radiator,s__EnglishLanguage,'A &%Device which is designed for having a &%Liquid travel through a metal honeycomb, in order to cool the liquid, which in turn is used to cool something else.') ).

fof(kb_SUMO_832,axiom,
    s__typicalPart(s__Radiator,s__LiquidEngineCoolingSystem) ).

fof(kb_SUMO_833,axiom,
    s__typicallyContainsPart(s__Radiator,s__LiquidEngineCoolingSystem) ).

fof(kb_SUMO_834,axiom,
    ! [V__R] :
      ( s__instance(V__R,s__Object)
     => ( s__instance(V__R,s__Radiator)
       => s__hasPurpose(V__R,'(? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Cooling) & s__instrument(V__C,V__R)))') ) ) ).

fof(kb_SUMO_835,axiom,
    s__subclass(s__EngineCranking,s__Motion) ).

fof(kb_SUMO_836,axiom,
    s__instance(s__EngineCranking__t,s__SetOrClass) ).

fof(kb_SUMO_837,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineCranking,'engine cranking') ).

fof(kb_SUMO_838,axiom,
    s__documentation(s__EngineCranking,s__EnglishLanguage,'Starting an &%InternalCombustionEngine, in which an electric motor is employed to initiate &%Rotating of the &%Crankshaft and &%Flywheel to the point where &%Combusion can sustain the rotation.') ).

fof(kb_SUMO_839,axiom,
    ! [V__R,V__EC] :
      ( s__instance(V__R,s__Process)
     => ( s__instance(V__EC,s__EngineCranking)
       => ? [V__EM,V__E,V__S,V__R1,V__C,V__R2] :
            ( s__instance(V__R2,s__Process)
            & s__instance(V__C,s__Object)
            & s__instance(V__R1,s__Process)
            & s__instance(V__S,s__Object)
            & s__instance(V__E,s__Object)
            & s__instance(V__EM,s__Object)
            & s__instance(V__EM,s__ElectricalMotor)
            & s__instance(V__E,s__InternalCombustionEngine)
            & s__instance(V__S,s__Shaft)
            & s__instance(V__C,s__Crankshaft)
            & s__part(V__S,V__EM)
            & s__instance(V__R1,s__Rotating)
            & s__patient(V__R,V__S)
            & s__part(V__C,V__E)
            & s__instance(V__R2,s__Rotating)
            & s__patient(V__R2,V__C)
            & s__part(V__C,V__E)
            & s__causes(V__R1,V__R2) ) ) ) ).

fof(kb_SUMO_840,axiom,
    s__subclass(s__Flywheel,s__EngineeringComponent) ).

fof(kb_SUMO_841,axiom,
    s__instance(s__Flywheel__t,s__SetOrClass) ).

fof(kb_SUMO_842,axiom,
    s__termFormat(s__EnglishLanguage,s__Flywheel,flywheel) ).

fof(kb_SUMO_843,axiom,
    s__documentation(s__Flywheel,s__EnglishLanguage,'Any &%Device designed to smooth the application of force or keep a &%Shaft spinning in the absence of other power inputs. It can either be massive or spin quickly (or both), in order to have significant intertia.') ).

fof(kb_SUMO_844,axiom,
    ! [V__F] :
      ( s__instance(V__F,s__Physical)
     => ( s__instance(V__F,s__Flywheel)
       => s__hasPurpose(V__F,'(? [V__R1,V__R2] : (s__instance(V__R2,s__Process) & s__instance(V__R1,s__Process) & s__instance(V__R1,s__Rotating) & s__instance(V__R2,s__Rotating) & s__patient(V__R1,V__F) & s__causes(V__R1,V__R2)))') ) ) ).

fof(kb_SUMO_845,axiom,
    s__instance(s__RightAngle,s__PositionalAttribute) ).

fof(kb_SUMO_846,axiom,
    s__subclass(s__Differential,s__GearTrain) ).

fof(kb_SUMO_847,axiom,
    s__instance(s__Differential__t,s__SetOrClass) ).

fof(kb_SUMO_848,axiom,
    s__instance(s__GearTrain__t,s__SetOrClass) ).

fof(kb_SUMO_849,axiom,
    s__termFormat(s__EnglishLanguage,s__Differential,differential) ).

fof(kb_SUMO_850,axiom,
    s__documentation(s__Differential,s__EnglishLanguage,'A set of &%Gears that change the axis of &%Rotating of a &%Shaft, in order to transmit power from an &%Automobile &%Engine to its &%Wheels.') ).

fof(kb_SUMO_851,axiom,
    ! [V__D] :
      ( s__instance(V__D,s__Object)
     => ( s__instance(V__D,s__Differential)
       => ? [V__G1,V__G2] :
            ( s__instance(V__G2,s__Object)
            & s__instance(V__G1,s__Object)
            & s__instance(V__G1,s__Gear)
            & s__instance(V__G2,s__Gear)
            & s__part(V__G1,V__D)
            & s__part(V__G2,V__D)
            & s__orientation(V__G1,V__G2,s__RightAngle) ) ) ) ).

fof(kb_SUMO_852,axiom,
    s__subclass(s__Distributor,s__Device) ).

fof(kb_SUMO_853,axiom,
    s__instance(s__Distributor__t,s__SetOrClass) ).

fof(kb_SUMO_854,axiom,
    s__termFormat(s__EnglishLanguage,s__Distributor,distributor) ).

fof(kb_SUMO_855,axiom,
    s__documentation(s__Distributor,s__EnglishLanguage,'A mechanical &%Device that is part of an &%InternalCombustionEngine that sends electric power to the &%SparkPlugs at intervals that track the speed of engine rotation. They have been largely superceded in modern &%Automobile engines by electronic devices.') ).

fof(kb_SUMO_856,axiom,
    ! [V__D] :
      ( s__instance(V__D,s__Object)
     => ( s__instance(V__D,s__Distributor)
       => s__hasPurpose(V__D,'(? [V__SP,V__S,V__O,V__R,V__E] : (s__instance(V__E,s__Object) & s__instance(V__R,s__Process) & s__instance(V__O,s__Object) & s__instance(V__S,s__Process) & s__instance(V__SP,s__Object) & s__instance(V__E,s__Engine) & s__instance(V__SP,s__SparkPlug) & s__instance(V__S,s__Spark) & s__part(V__O,V__D) & s__part(V__D,V__E) & s__part(V__SP,V__E) & s__instance(V__R,s__Rotating) & s__causes(V__R,V__S)))') ) ) ).

fof(kb_SUMO_857,axiom,
    s__subclass(s__Pulley,s__DriveComponent) ).

fof(kb_SUMO_858,axiom,
    s__instance(s__Pulley__t,s__SetOrClass) ).

fof(kb_SUMO_859,axiom,
    s__termFormat(s__EnglishLanguage,s__Pulley,pulley) ).

fof(kb_SUMO_860,axiom,
    s__documentation(s__Pulley,s__EnglishLanguage,'A grooved wheel designed to hold a &%Drivebelt, and transmit the force of &%Rotating to another &%Pulley.') ).

fof(kb_SUMO_861,axiom,
    ! [V__P] :
      ( s__instance(V__P,s__EngineeringComponent)
     => ( s__instance(V__P,s__Pulley)
       => s__hasPurpose(V__P,'(? [V__P2,V__D,V__R1,V__R2] : (s__instance(V__R2,s__Process) & s__instance(V__R1,s__Process) & s__instance(V__D,s__EngineeringComponent) & s__instance(V__P2,s__EngineeringComponent) & s__instance(V__P2,s__Pulley) & (~ (V__P = V__P2)) & s__instance(V__D,s__Drivebelt) & s__instance(V__R1,s__Rotating) & s__instance(V__R2,s__Rotating) & s__connectedEngineeringComponents(V__P,V__D) & s__connectedEngineeringComponents(V__P2,V__D) & s__patient(V__R1,V__P) & s__patient(V__R2,V__P2) & s__causes(V__R1,V__R2)))') ) ) ).

fof(kb_SUMO_862,axiom,
    s__subclass(s__Drivebelt,s__Device) ).

fof(kb_SUMO_863,axiom,
    s__instance(s__Drivebelt__t,s__SetOrClass) ).

fof(kb_SUMO_864,axiom,
    s__termFormat(s__EnglishLanguage,s__Drivebelt,drivebelt) ).

fof(kb_SUMO_865,axiom,
    s__documentation(s__Drivebelt,s__EnglishLanguage,'A &%Pliable belt that links two &%Pulleys') ).

fof(kb_SUMO_866,axiom,
    ! [V__D] :
      ( s__instance(V__D,s__Object)
     => ( s__instance(V__D,s__Drivebelt)
       => s__attribute(V__D,s__Pliable) ) ) ).

fof(kb_SUMO_867,axiom,
    s__subclass(s__Driveshaft,s__Shaft) ).

fof(kb_SUMO_868,axiom,
    s__instance(s__Driveshaft__t,s__SetOrClass) ).

fof(kb_SUMO_869,axiom,
    s__termFormat(s__EnglishLanguage,s__Driveshaft,driveshaft) ).

fof(kb_SUMO_870,axiom,
    s__documentation(s__Driveshaft,s__EnglishLanguage,'A &%Shaft that transmits power from the &%AutomobileTransmission to a &%Differential or more directly to the &%Wheels of an &%Automobile.') ).

fof(kb_SUMO_871,axiom,
    ! [V__D] :
      ( s__instance(V__D,s__Object)
     => ( s__instance(V__D,s__Driveshaft)
       => s__hasPurpose(V__D,'(? [V__R1,V__R2,V__W,V__A] : (s__instance(V__A,s__Object) & s__instance(V__W,s__Object) & s__instance(V__R2,s__Process) & s__instance(V__R1,s__Process) & s__instance(V__A,s__Automobile) & s__instance(V__W,s__Wheel) & s__part(V__D,V__A) & s__part(V__W,V__A) & s__instance(V__R1,s__Rotating) & s__patient(V__R1,V__D) & s__patient(V__R2,V__W) & s__causes(V__R1,V__R2)))') ) ) ).

fof(kb_SUMO_872,axiom,
    s__subclass(s__AutomobileTransmission,s__Gearbox) ).

fof(kb_SUMO_873,axiom,
    s__instance(s__AutomobileTransmission__t,s__SetOrClass) ).

fof(kb_SUMO_874,axiom,
    s__instance(s__Gearbox__t,s__SetOrClass) ).

fof(kb_SUMO_875,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileTransmission,transmission) ).

fof(kb_SUMO_876,axiom,
    s__documentation(s__AutomobileTransmission,s__EnglishLanguage,'A &%Gearbox with several &%Gears that allow a given rotational speed of the &%Crankshaft to be translated ultimately to different speeds of the &%Driveshaft (within the power and maximum RPM capabilities of the &%Engine).') ).

fof(kb_SUMO_877,axiom,
    ! [V__AT] :
      ( s__instance(V__AT,s__EngineeringComponent)
     => ( s__instance(V__AT,s__AutomobileTransmission)
       => s__hasPurpose(V__AT,'(? [V__C,V__D,V__A,V__R1,V__N1,V__R2,V__R3,V__R4,V__N2,V__N3] : (s__instance(V__N3,s__Rotating) & s__instance(V__N2,s__Rotating) & s__instance(V__R4,s__Process) & s__instance(V__R4,s__TimePosition) & s__instance(V__R3,s__Process) & s__instance(V__R3,s__TimePosition) & s__instance(V__R2,s__Process) & s__instance(V__R2,s__TimePosition) & s__instance(V__N1,s__Rotating) & s__instance(V__R1,s__Process) & s__instance(V__R1,s__TimePosition) & s__instance(V__A,s__Object) & s__instance(V__D,s__EngineeringComponent) & s__instance(V__C,s__EngineeringComponent) & s__instance(V__C,s__Crankshaft) & s__instance(V__D,s__Driveshaft) & s__instance(V__A,s__Automobile) & s__part(V__D,V__A) & s__part(V__AT,V__A) & s__part(V__C,V__A) & s__connectedEngineeringComponents(V__C,V__AT) & s__connectedEngineeringComponents(V__D,V__AT) & s__instance(V__R1,s__Rotating) & s__instance(V__R2,s__Rotating) & s__instance(V__R3,s__Rotating) & s__instance(V__R4,s__Rotating) & s__patient(V__R1,V__C) & s__patient(V__R2,V__C) & s__patient(V__R3,V__D) & s__patient(V__R4,V__D) & s__causes(V__R1,V__R3) & s__causes(V__R2,V__R4) & (~ (V__R1 = V__R2)) & s__holdsDuring(V__R1,s__measure(V__C,s__RotationFn(V__N1,s__MinuteDuration))) & s__holdsDuring(V__R2,s__measure(V__C,s__RotationFn(V__N1,s__MinuteDuration))) & s__holdsDuring(V__R3,s__measure(V__D,s__RotationFn(V__N2,s__MinuteDuration))) & s__holdsDuring(V__R4,s__measure(V__D,s__RotationFn(V__N3,s__MinuteDuration))) & (~ (V__N2 = V__N3))))') ) ) ).

fof(kb_SUMO_878,axiom,
    s__subclass(s__ElectricTransmission,s__Transfer) ).

fof(kb_SUMO_879,axiom,
    s__instance(s__ElectricTransmission__t,s__SetOrClass) ).

fof(kb_SUMO_880,axiom,
    s__subclass(s__ElectricTransmission,s__RadiatingElectromagnetic) ).

fof(kb_SUMO_881,axiom,
    s__termFormat(s__EnglishLanguage,s__ElectricTransmission,'electric transmission') ).

fof(kb_SUMO_882,axiom,
    s__documentation(s__ElectricTransmission,s__EnglishLanguage,'The movement of a electric potential (modeled as a &%Substance) from one point to another necessarily through a conductive medium (although the degree of conductivity may be quite low, as in &%Lightning through &%Air).') ).

fof(kb_SUMO_883,axiom,
    ! [V__EC] :
      ( s__instance(V__EC,s__Transfer)
     => ( s__instance(V__EC,s__ElectricTransmission)
       => ? [V__E] :
            ( s__instance(V__E,s__Object)
            & s__instance(V__E,s__Electricity)
            & s__objectTransferred(V__EC,V__E) ) ) ) ).

fof(kb_SUMO_884,axiom,
    s__subclass(s__Charging,s__ElectricTransmission) ).

fof(kb_SUMO_885,axiom,
    s__instance(s__Charging__t,s__SetOrClass) ).

fof(kb_SUMO_886,axiom,
    s__termFormat(s__EnglishLanguage,s__Charging,charging) ).

fof(kb_SUMO_887,axiom,
    s__documentation(s__Charging,s__EnglishLanguage,'The &%Process of moving electric potential into a &%RechargeableBattery.') ).

fof(kb_SUMO_888,axiom,
    ! [V__C] :
      ( s__instance(V__C,s__Process)
     => ( s__instance(V__C,s__Charging)
       => ? [V__RB] :
            ( s__instance(V__RB,s__RechargeableBattery)
            & s__destination(V__C,V__RB) ) ) ) ).

fof(kb_SUMO_889,axiom,
    s__subclass(s__Discharging,s__ElectricTransmission) ).

fof(kb_SUMO_890,axiom,
    s__instance(s__Discharging__t,s__SetOrClass) ).

fof(kb_SUMO_891,axiom,
    s__termFormat(s__EnglishLanguage,s__Discharging,discharging) ).

fof(kb_SUMO_892,axiom,
    s__documentation(s__Charging,s__EnglishLanguage,'The &%Process of moving electric potential out of a &%Battery.') ).

fof(kb_SUMO_893,axiom,
    ! [V__D] :
      ( s__instance(V__D,s__Process)
     => ( s__instance(V__D,s__Discharging)
       => ? [V__B] :
            ( s__instance(V__B,s__Object)
            & s__instance(V__B,s__Battery)
            & s__origin(V__D,V__B) ) ) ) ).

fof(kb_SUMO_894,axiom,
    s__subclass(s__RechargeableBattery,s__Battery) ).

fof(kb_SUMO_895,axiom,
    s__instance(s__RechargeableBattery__t,s__SetOrClass) ).

fof(kb_SUMO_896,axiom,
    s__termFormat(s__EnglishLanguage,s__RechargeableBattery,'rechargeable battery') ).

fof(kb_SUMO_897,axiom,
    s__documentation(s__RechargeableBattery,s__EnglishLanguage,'A &%Battery that may be recharged after discharge. &%LeadAcidWetBattery(s) are the most common subclass.') ).

fof(kb_SUMO_898,axiom,
    ! [V__RB] :
      ( s__instance(V__RB,s__Object)
     => ( s__instance(V__RB,s__RechargeableBattery)
       => s__capability(s__Charging,s__destination__m,V__RB) ) ) ).

fof(kb_SUMO_899,axiom,
    s__subclass(s__NonRechargeableBattery,s__Battery) ).

fof(kb_SUMO_900,axiom,
    s__instance(s__NonRechargeableBattery__t,s__SetOrClass) ).

fof(kb_SUMO_901,axiom,
    s__termFormat(s__EnglishLanguage,s__NonRechargeableBattery,'non-rechargeable battery') ).

fof(kb_SUMO_902,axiom,
    s__documentation(s__NonRechargeableBattery,s__EnglishLanguage,'A &%Battery that is not capable of being subjected to &%Recharging.') ).

fof(kb_SUMO_903,axiom,
    ! [V__RB] :
      ( s__instance(V__RB,s__Object)
     => ( s__instance(V__RB,s__RechargeableBattery)
       => ~ s__capability(s__Charging,s__destination__m,V__RB) ) ) ).

fof(kb_SUMO_904,axiom,
    s__subclass(s__LeadAcidWetBattery,s__RechargeableBattery) ).

fof(kb_SUMO_905,axiom,
    s__instance(s__LeadAcidWetBattery__t,s__SetOrClass) ).

fof(kb_SUMO_906,axiom,
    s__termFormat(s__EnglishLanguage,s__LeadAcidWetBattery,'lead acid battery') ).

fof(kb_SUMO_907,axiom,
    s__documentation(s__LeadAcidWetBattery,s__EnglishLanguage,'One of the most prevalent types of &%Battery. It consists of plates made (in part) of &%Lead, in an &%Acid solution.') ).

fof(kb_SUMO_908,axiom,
    ! [V__LAWB] :
      ( s__instance(V__LAWB,s__LeadAcidWetBattery)
     => s__material(s__Lead,s__LeadAcidWetBattery) ) ).

fof(kb_SUMO_909,axiom,
    ! [V__LAWB] :
      ( s__instance(V__LAWB,s__LeadAcidWetBattery)
     => s__material(s__Acid,s__LeadAcidWetBattery) ) ).

fof(kb_SUMO_910,axiom,
    ! [V__LAWB] :
      ( s__instance(V__LAWB,s__LeadAcidWetBattery)
     => s__material(s__Water,s__LeadAcidWetBattery) ) ).

fof(kb_SUMO_911,axiom,
    s__externalImage(s__LeadAcidWetBattery,'http://en.wikipedia.org/wiki/File:Photo-CarBattery.jpg') ).

fof(kb_SUMO_912,axiom,
    s__subclass(s__ChemicalAcid,s__Substance) ).

fof(kb_SUMO_913,axiom,
    s__termFormat(s__EnglishLanguage,s__ChemicalAcid,acid) ).

fof(kb_SUMO_914,axiom,
    s__documentation(s__ChemicalAcid,s__EnglishLanguage,'Acids are substances which increase the concentration of hydronium ions (H3O+) in solution, substances which can act as a proton donor, and substances which are are electron-pair acceptors. This is a restrictive definition combining the Arrhenius definition, the Brxnsted-Lowry definition and the Lewis definition [adapted from Wikipedia]') ).

fof(kb_SUMO_915,axiom,
    s__subclass(s__SulfuricAcid,s__ChemicalAcid) ).

fof(kb_SUMO_916,axiom,
    s__instance(s__SulfuricAcid__t,s__SetOrClass) ).

fof(kb_SUMO_917,axiom,
    s__termFormat(s__EnglishLanguage,s__SulfuricAcid,'sulfuric acid') ).

fof(kb_SUMO_918,axiom,
    s__documentation(s__SulfuricAcid,s__EnglishLanguage,'Sulfuric acid is a highly corrosive strong mineral acid with the molecular formula H2SO4. It is a colorless to slightly yellow viscous &%Liquid and is soluble in &%Water. The corrosiveness of it is mainly due to its strong acidic nature, strong dehydrating property and if concentrated strong oxidizing property. It has many applications and is a central &%Substance in the chemical industry. Principal uses include &%LeadAcidWetBattery(s) for &%Automobiles and other &%Vehicles, mineral processing, fertilizer manufacturing, oil refining, wastewater processing, and &%ChemicalSynthesis. [from Wikipedia]') ).

fof(kb_SUMO_919,axiom,
    s__molecularRatio(s__Hydrogen,"2",s__SulfuricAcid) ).

fof(kb_SUMO_920,axiom,
    s__molecularRatio(s__Sulphur,"1",s__SulfuricAcid) ).

fof(kb_SUMO_921,axiom,
    s__molecularRatio(s__Oxygen,"4",s__SulfuricAcid) ).

fof(kb_SUMO_922,axiom,
    s__subclass(s__Electrolyte,s__ConductorSubstance) ).

fof(kb_SUMO_923,axiom,
    s__instance(s__Electrolyte__t,s__SetOrClass) ).

fof(kb_SUMO_924,axiom,
    s__instance(s__ConductorSubstance__t,s__SetOrClass) ).

fof(kb_SUMO_925,axiom,
    s__termFormat(s__EnglishLanguage,s__Electrolyte,electrolyte) ).

fof(kb_SUMO_926,axiom,
    s__documentation(s__Electrolyte,s__EnglishLanguage,'A &%Substance that conducts &%Electricity and is a &%Liquid, typically found in &%Battery(s). In a &%LeadAcidWetBattery the electrolyte is a &%Mixture of distilled &%Water and &%SulfuricAcid.') ).

fof(kb_SUMO_927,axiom,
    ! [V__E] :
      ( s__instance(V__E,s__Object)
     => ( s__instance(V__E,s__Electrolyte)
       => s__hasPurpose(V__E,'(? [V__ET] : (s__instance(V__ET,s__Process) & s__instance(V__ET,s__TimePosition) & s__instance(V__ET,s__ElectricTransmission) & s__patient(V__ET,V__E) & s__holdsDuring(V__ET,s__attribute(V__E,s__Liquid))))') ) ) ).

fof(kb_SUMO_928,axiom,
    s__subclass(s__EngineControlModule,s__Computer) ).

fof(kb_SUMO_929,axiom,
    s__instance(s__EngineControlModule__t,s__SetOrClass) ).

fof(kb_SUMO_930,axiom,
    s__instance(s__Computer__t,s__SetOrClass) ).

fof(kb_SUMO_931,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineControlModule,'engine control module') ).

fof(kb_SUMO_932,axiom,
    s__documentation(s__EngineControlModule,s__EnglishLanguage,'A &%Computer that is present in most modern &%Automobiles, which controls the major functions of the &%Engine, including the &%Air - &%Fuel &%Mixture, ignition timing and pollution control systems.') ).

fof(kb_SUMO_933,axiom,
    ! [V__ECM] :
      ( s__instance(V__ECM,s__Object)
     => ( s__instance(V__ECM,s__EngineControlModule)
       => s__hasPurpose(V__ECM,'(? [V__A,V__E,V__P1,V__P2] : (s__instance(V__E,s__Object) & s__instance(V__A,s__Object) & s__instance(V__A,s__Automobile) & s__instance(V__E,s__Engine) & s__instance(V__P1,s__Process) & s__instance(V__P2,s__Process) & s__part(V__E,V__A) & s__part(V__ECM,V__A) & s__eventLocated(V__P1,V__ECM) & s__eventLocated(V__P2,V__E) & s__causes(V__P1,V__P2)))') ) ) ).

fof(kb_SUMO_934,axiom,
    s__subclass(s__GasPedal,s__Device) ).

fof(kb_SUMO_935,axiom,
    s__instance(s__GasPedal__t,s__SetOrClass) ).

fof(kb_SUMO_936,axiom,
    s__termFormat(s__EnglishLanguage,s__GasPedal,'gas pedal') ).

fof(kb_SUMO_937,axiom,
    s__documentation(s__GasPedal,s__EnglishLanguage,'A &%Device that controls the flow of &%Fuel (which may be &%Diesel as well as &%Gasoline) to the &%Engine.') ).

fof(kb_SUMO_938,axiom,
    ! [V__GP] :
      ( s__instance(V__GP,s__Object)
     => ( s__instance(V__GP,s__GasPedal)
       => s__hasPurpose(V__GP,'(? [V__P,V__T,V__F,V__E,V__A] : (s__instance(V__A,s__Object) & s__instance(V__E,s__Object) & s__instance(V__T,s__Process) & s__instance(V__P,s__Process) & s__instance(V__P,s__Pushing) & s__instance(V__T,s__Transfer) & s__instance(V__F,s__Fuel) & s__instance(V__E,s__Engine) & s__instance(V__A,s__Automobile) & s__part(V__GP,V__A) & s__part(V__E,V__A) & s__destination(V__P,V__GP) & s__destination(V__T,V__E) & s__patient(V__T,V__F) & s__causes(V__P,V__T)))') ) ) ).

fof(kb_SUMO_939,axiom,
    s__instance(s__engineIdleSpeed__m,s__BinaryRelation) ).

fof(kb_SUMO_940,axiom,
    s__domain(s__engineIdleSpeed__m,"1",s__InternalCombustionEngine) ).

fof(kb_SUMO_941,axiom,
    s__domain(s__engineIdleSpeed__m,"2",s__FunctionQuantity) ).

fof(kb_SUMO_942,axiom,
    s__format(s__EnglishLanguage,s__engineIdleSpeed__m,'the idle speed of %1 is %n %2') ).

fof(kb_SUMO_943,axiom,
    s__documentation(s__engineIdleSpeed__m,s__EnglishLanguage,'The rotation rate of the &%Crankshaft that exists when the &%Engine is running but the &%GasPedal is not depressed. Note that under certain conditions of load on the engine and gear ratio, the same speed is possible even when the gas pedal is depressed.') ).

%FOL fof(kb_SUMO_944,axiom,(( (! [V__A,V__S,V__C,V__T,V__E] : ((s__instance(V__E,s__InternalCombustionEngine) & s__instance(V__T,s__TimeInterval) & s__instance(V__C,s__Object) & s__instance(V__S,s__FunctionQuantity) & s__instance(V__A,s__Object)) => ((s__holdsDuring(V__T,'s__measure(V__C,V__S)') & s__engineIdleSpeed(V__E,V__S) & s__instance(V__A,s__Automobile) & s__part(V__E,V__A) & s__part(V__C,V__E)) => s__modalAttribute('(~ (? [V__P,V__GP] : (s__instance(V__GP,s__Object) & s__instance(V__P,s__TimeInterval) & s__instance(V__P,s__Process) & s__during(V__P,V__T) & s__instance(V__P,s__Pushing) & s__destination(V__P,V__GP) & s__part(V__GP,V__A))))',s__Likely)))) ))).

%FOL fof(kb_SUMO_945,axiom,(( (! [V__P,V__N2,V__A,V__N1,V__C,V__E,V__GP,V__M] : ((s__instance(V__M,s__TimeDuration) & s__instance(V__GP,s__Object) & s__instance(V__E,s__InternalCombustionEngine) & s__instance(V__C,s__Object) & s__instance(V__N1,s__Rotating) & s__instance(V__N1,s__Quantity) & s__instance(V__A,s__Object) & s__instance(V__N2,s__Rotating) & s__instance(V__N2,s__Quantity) & s__instance(V__P,s__Process)) => ((s__engineIdleSpeed(V__E,s__RotationFn(V__N1,V__M)) & s__instance(V__A,s__Automobile) & s__instance(V__P,s__GasPedal) & s__instance(V__P,s__Pushing) & s__destination(V__P,V__GP) & s__part(V__GP,V__A) & s__instance(V__C,s__Crankshaft) & s__part(V__C,V__A) & s__measure(V__C,s__RotationFn(V__N2,V__M))) => s__modalAttribute('greater(V__N2,V__N1)',s__Likely)))) ))).

fof(kb_SUMO_946,axiom,
    s__subclass(s__AutomobileExhaustSystem,s__PhysicalSystem) ).

fof(kb_SUMO_947,axiom,
    s__instance(s__AutomobileExhaustSystem__t,s__SetOrClass) ).

fof(kb_SUMO_948,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileExhaustSystem,'exhaust system') ).

fof(kb_SUMO_949,axiom,
    s__documentation(s__AutomobileExhaustSystem,s__EnglishLanguage,'A &%part of an &%Automobile that handles the venting of &%Exhaust from the &%Engine. It typically includes an exhaust manifold, &%Muffler and &%Tailpipe. Modern engines may also include a &%CatalyticConverter and exhaust recirculation hoses and controls.') ).

fof(kb_SUMO_950,axiom,
    s__subclass(s__AutomobileMuffler,s__Device) ).

fof(kb_SUMO_951,axiom,
    s__instance(s__AutomobileMuffler__t,s__SetOrClass) ).

fof(kb_SUMO_952,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileMuffler,muffler) ).

fof(kb_SUMO_953,axiom,
    s__documentation(s__AutomobileMuffler,s__EnglishLanguage,'A &%part of an &%AutomobileExhaustSystem that serves to reduce the amount of noise transmitted from the &%Engine to the environment.') ).

fof(kb_SUMO_954,axiom,
    s__subclass(s__ExhaustManifold,s__Device) ).

fof(kb_SUMO_955,axiom,
    s__instance(s__ExhaustManifold__t,s__SetOrClass) ).

fof(kb_SUMO_956,axiom,
    s__termFormat(s__EnglishLanguage,s__ExhaustManifold,'exhaust manifold') ).

fof(kb_SUMO_957,axiom,
    s__documentation(s__ExhaustManifold,s__EnglishLanguage,'A junction of several &%Tubes, which take exhaust &%Gases from the &%Engine &%Cylinders and route them to the &%Muffler and &%Tailpipe. Note that this class also includes what are known as headers, since a header is essentially just a high performance manifold.') ).

fof(kb_SUMO_958,axiom,
    s__typicalPart(s__ExhaustManifold,s__AutomobileExhaustSystem) ).

fof(kb_SUMO_959,axiom,
    s__typicallyContainsPart(s__ExhaustManifold,s__AutomobileExhaustSystem) ).

fof(kb_SUMO_960,axiom,
    ! [V__EM] :
      ( s__instance(V__EM,s__Object)
     => ( s__instance(V__EM,s__ExhaustManifold)
       => s__hasPurpose(V__EM,'(? [V__A,V__E,V__C,V__M,V__T] : (s__instance(V__T,s__Process) & s__instance(V__M,s__Object) & s__instance(V__C,s__Object) & s__instance(V__E,s__Object) & s__instance(V__A,s__Object) & s__instance(V__A,s__Automobile) & s__instance(V__E,s__Exhaust) & s__instance(V__C,s__EngineCylinder) & s__instance(V__M,s__AutomobileMuffler) & s__instance(V__T,s__Transfer) & s__part(V__EM,V__A) & s__part(V__C,V__A) & s__part(V__M,V__A) & s__origin(V__T,V__C) & s__destination(V__T,V__M) & s__patient(V__T,V__E) & s__instrument(V__T,V__E)))') ) ) ).

fof(kb_SUMO_961,axiom,
    ! [V__EM] :
      ( s__instance(V__EM,s__Object)
     => ( s__instance(V__EM,s__ExhaustManifold)
       => ? [V__T1,V__T2] :
            ( s__instance(V__T2,s__Object)
            & s__instance(V__T1,s__Object)
            & s__instance(V__T1,s__Tube)
            & s__instance(V__T2,s__Tube)
            & V__T1 != V__T2
            & s__part(V__T1,V__EM)
            & s__part(V__T2,V__EM) ) ) ) ).

fof(kb_SUMO_962,axiom,
    s__subclass(s__ExhaustValve,s__Valve) ).

fof(kb_SUMO_963,axiom,
    s__instance(s__ExhaustValve__t,s__SetOrClass) ).

fof(kb_SUMO_964,axiom,
    s__termFormat(s__EnglishLanguage,s__ExhaustValve,'exhaust valve') ).

fof(kb_SUMO_965,axiom,
    s__documentation(s__ExhaustValve,s__EnglishLanguage,'A &%Valve that opens to let the &%Exhaust escape into the &%ExhaustManifold.') ).

fof(kb_SUMO_966,axiom,
    s__typicalPart(s__ExhaustValve,s__FourStrokeEngine) ).

fof(kb_SUMO_967,axiom,
    s__typicallyContainsPart(s__ExhaustValve,s__FourStrokeEngine) ).

fof(kb_SUMO_968,axiom,
    ! [V__EV] :
      ( s__instance(V__EV,s__Object)
     => ( s__instance(V__EV,s__ExhaustValve)
       => s__hasPurpose(V__EV,'(? [V__E,V__T] : (s__instance(V__E,s__Object) & s__instance(V__T,s__Transfer) & s__objectTransferred(V__T,V__E) & s__path(V__T,V__EV) & s__instance(V__E,s__Exhaust)))') ) ) ).

fof(kb_SUMO_969,axiom,
    ! [V__EV] :
      ( s__instance(V__EV,s__EngineeringComponent)
     => ( s__instance(V__EV,s__ExhaustValve)
       => s__hasPurpose(V__EV,'(? [V__EM] : (s__instance(V__EM,s__EngineeringComponent) & s__instance(V__EM,s__ExhaustManifold) & s__connectedEngineeringComponents(V__EV,V__EM)))') ) ) ).

fof(kb_SUMO_970,axiom,
    s__subclass(s__IntakeValve,s__Valve) ).

fof(kb_SUMO_971,axiom,
    s__instance(s__IntakeValve__t,s__SetOrClass) ).

fof(kb_SUMO_972,axiom,
    s__termFormat(s__EnglishLanguage,s__IntakeValve,'intake valve') ).

fof(kb_SUMO_973,axiom,
    s__documentation(s__ExhaustValve,s__EnglishLanguage,'A &%Valve that opens to let the &%FuelVapor in to the &%CombustionChamber.') ).

fof(kb_SUMO_974,axiom,
    s__typicalPart(s__IntakeValve,s__FourStrokeEngine) ).

fof(kb_SUMO_975,axiom,
    s__typicallyContainsPart(s__IntakeValve,s__FourStrokeEngine) ).

fof(kb_SUMO_976,axiom,
    ! [V__IV] :
      ( s__instance(V__IV,s__Object)
     => ( s__instance(V__IV,s__IntakeValve)
       => s__hasPurpose(V__IV,'(? [V__A,V__FV,V__CC,V__T] : (s__instance(V__T,s__Motion) & s__instance(V__CC,s__Object) & s__instance(V__A,s__Object) & s__instance(V__A,s__Automobile) & s__instance(V__FV,s__FuelVapor) & s__instance(V__CC,s__CombustionChamber) & s__instance(V__T,s__Transfer) & s__part(V__IV,V__A) & s__part(V__CC,V__A) & s__patient(V__T,V__FV) & s__path(V__T,V__IV) & s__destination(V__T,V__CC)))') ) ) ).

fof(kb_SUMO_977,axiom,
    s__subclass(s__FanBelt,s__Drivebelt) ).

fof(kb_SUMO_978,axiom,
    s__instance(s__FanBelt__t,s__SetOrClass) ).

fof(kb_SUMO_979,axiom,
    s__termFormat(s__EnglishLanguage,s__FanBelt,'fan belt') ).

fof(kb_SUMO_980,axiom,
    s__documentation(s__FanBelt,s__EnglishLanguage,'A &%Drivebelt driven from a &%Pulley &%connected to the &%Crankshaft, which drives other systems, such as the &%EngineFan, &%EngineWaterPump etc.') ).

fof(kb_SUMO_981,axiom,
    ! [V__FB] :
      ( s__instance(V__FB,s__EngineeringComponent)
     => ( s__instance(V__FB,s__FanBelt)
       => s__hasPurpose(V__FB,'(? [V__P1,V__P2,V__C,V__A] : (s__instance(V__A,s__Object) & s__instance(V__C,s__EngineeringComponent) & s__instance(V__P2,s__EngineeringComponent) & s__instance(V__P1,s__EngineeringComponent) & s__instance(V__P1,s__Pulley) & s__instance(V__P2,s__Pulley) & (~ (V__P1 = V__P2)) & s__instance(V__C,s__Crankshaft) & s__instance(V__A,s__Automobile) & s__part(V__P1,V__A) & s__part(V__P2,V__A) & s__part(V__C,V__A) & s__part(V__FB,V__A) & s__connectedEngineeringComponents(V__C,V__P1) & s__connectedEngineeringComponents(V__P1,V__FB) & s__connectedEngineeringComponents(V__FB,V__P2)))') ) ) ).

fof(kb_SUMO_982,axiom,
    ! [V__A,V__EF,V__FB,V__M] :
      ( ( s__instance(V__M,s__Process)
        & s__instance(V__FB,s__Object)
        & s__instance(V__EF,s__Object)
        & s__instance(V__A,s__Object) )
     => ( ( s__instance(V__FB,s__FanBelt)
          & s__instance(V__EF,s__EngineFan)
          & s__instance(V__A,s__Automobile)
          & s__part(V__FB,V__A)
          & s__part(V__EF,V__A)
          & s__instance(V__M,s__Motion)
          & s__patient(V__M,V__FB) )
       => s__hasPurpose(V__FB,'(? [V__M2] : (s__instance(V__M2,s__Process) & s__instance(V__M2,s__Rotating) & s__causes(V__M,V__M2) & s__patient(V__M2,V__EF)))') ) ) ).

fof(kb_SUMO_983,axiom,
    s__subclass(s__EngineFan,s__FanDevice) ).

fof(kb_SUMO_984,axiom,
    s__instance(s__EngineFan__t,s__SetOrClass) ).

fof(kb_SUMO_985,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineFan,'engine fan') ).

fof(kb_SUMO_986,axiom,
    s__documentation(s__EngineFan,s__EnglishLanguage,'A &%FanDevice that is part of an &%Engine, designed for &%Cooling the engine, and therefore distinguished from fans that are for moving &%Air in the passenger compartment of an &%Automobile.') ).

fof(kb_SUMO_987,axiom,
    ! [V__EF] :
      ( s__instance(V__EF,s__Object)
     => ( s__instance(V__EF,s__EngineFan)
       => s__hasPurpose(V__EF,'(? [V__C,V__E,V__A] : (s__instance(V__A,s__Object) & s__instance(V__E,s__Object) & s__instance(V__C,s__Process) & s__instance(V__A,s__Automobile) & s__instance(V__C,s__Cooling) & s__instance(V__E,s__InternalCombustionEngine) & s__part(V__E,V__A) & s__part(V__EF,V__A) & s__instrument(V__C,V__EF) & s__patient(V__C,V__E)))') ) ) ).

fof(kb_SUMO_988,axiom,
    s__subclass(s__WaterPump,s__Pump) ).

fof(kb_SUMO_989,axiom,
    s__termFormat(s__EnglishLanguage,s__WaterPump,'water pump') ).

fof(kb_SUMO_990,axiom,
    s__documentation(s__WaterPump,s__EnglishLanguage,'A &%Pump that is designed to move &%Water.') ).

fof(kb_SUMO_991,axiom,
    ! [V__WP] :
      ( s__instance(V__WP,s__Object)
     => ( s__instance(V__WP,s__WaterPump)
       => s__hasPurpose(V__WP,'(? [V__T,V__W] : (s__instance(V__W,s__Object) & s__instance(V__T,s__Transfer) & s__instance(V__W,s__Water) & s__objectTransferred(V__T,V__W) & s__instrument(V__T,V__WP)))') ) ) ).

fof(kb_SUMO_992,axiom,
    s__subclass(s__EngineWaterPump,s__WaterPump) ).

fof(kb_SUMO_993,axiom,
    s__instance(s__EngineWaterPump__t,s__SetOrClass) ).

fof(kb_SUMO_994,axiom,
    s__instance(s__WaterPump__t,s__SetOrClass) ).

fof(kb_SUMO_995,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineWaterPump,'engine water pump') ).

fof(kb_SUMO_996,axiom,
    s__documentation(s__EngineWaterPump,s__EnglishLanguage,'A &%WaterPump that is intended to move &%Water (and possibly other additives such as &%Alcohol to lower the &%meltingPoint) in the &%EngineCoolingSystem.') ).

fof(kb_SUMO_997,axiom,
    s__typicalPart(s__EngineWaterPump,s__EngineCoolingSystem) ).

fof(kb_SUMO_998,axiom,
    s__typicallyContainsPart(s__EngineWaterPump,s__EngineCoolingSystem) ).

fof(kb_SUMO_999,axiom,
    s__subclass(s__FeelerGauge,s__MeasuringDevice) ).

fof(kb_SUMO_1000,axiom,
    s__instance(s__FeelerGauge__t,s__SetOrClass) ).

fof(kb_SUMO_1001,axiom,
    s__termFormat(s__EnglishLanguage,s__FeelerGauge,'feeler gauge') ).

fof(kb_SUMO_1002,axiom,
    s__documentation(s__FeelerGauge,s__EnglishLanguage,'A &%Device used to measure small gaps. It is typically a &%Collection of several such gauges of varying thicknesses that a user places into the gap until one is found that fits with slight resistence, which indicates a good assessment of the size of the gap. A typical use is measure the gap between electrodes of a &%SparkPlug.') ).

fof(kb_SUMO_1003,axiom,
    ! [V__FG] :
      ( s__instance(V__FG,s__Object)
     => ( s__instance(V__FG,s__FeelerGauge)
       => s__hasPurpose(V__FG,'(? [V__TP,V__M] : (s__instance(V__M,s__Process) & s__instance(V__TP,s__Process) & s__instance(V__M,s__Measuring) & s__instance(V__TP,s__TactilePerception) & s__subProcess(V__TP,V__M) & s__instrument(V__M,V__FG)))') ) ) ).

fof(kb_SUMO_1004,axiom,
    s__instance(s__EngineFlooded,s__RelationalAttribute) ).

fof(kb_SUMO_1005,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineFlooded,'engine flooded') ).

fof(kb_SUMO_1006,axiom,
    s__documentation(s__EngineFlooded,s__EnglishLanguage,'A state in which an &%InternalCombustionEngine has too much &%Fuel in its &%CombustionChamber to operate as intended.') ).

fof(kb_SUMO_1007,axiom,
    ! [V__N2,V__N1,V__CC,V__T,V__F,V__E,V__M] :
      ( ( s__instance(V__M,s__UnitOfMeasure)
        & s__instance(V__E,s__Object)
        & s__instance(V__F,s__Object)
        & s__instance(V__T,s__TimePosition)
        & s__instance(V__CC,s__SelfConnectedObject)
        & s__instance(V__N1,s__RealNumber)
        & s__instance(V__N2,s__RealNumber) )
     => ( ( s__instance(V__E,s__InternalCombustionEngine)
          & s__instance(V__CC,s__CombustionChamber)
          & s__part(V__CC,V__E)
          & s__instance(V__F,s__Fuel)
          & s__instance(V__M,s__UnitOfVolume)
          & s__holdsDuring(V__T,'(s__contains(V__CC,V__F) & s__measure(V__F,s__MeasureFn(V__N1,V__M)) & s__attribute(V__E,s__EngineFlooded))') )
       => s__hasPurpose(V__CC,'(~ (? [V__F2] : (s__instance(V__F2,s__Object) & s__instance(V__F2,s__Fuel) & s__contains(V__CC,V__F2) & s__measure(V__F2,s__MeasureFn(V__N2,V__M)) & greatereq(V__N2,V__N1))))') ) ) ).

fof(kb_SUMO_1008,axiom,
    s__subclass(s__Gasket,s__Device) ).

fof(kb_SUMO_1009,axiom,
    s__instance(s__Gasket__t,s__SetOrClass) ).

fof(kb_SUMO_1010,axiom,
    s__termFormat(s__EnglishLanguage,s__Gasket,gasket) ).

fof(kb_SUMO_1011,axiom,
    s__documentation(s__Gasket,s__EnglishLanguage,'A &%Device that is designed to allow two imperfect surfaces to mate cleanly, without gaps, and therefore prevent leakage of any &%Liquids.') ).

fof(kb_SUMO_1012,axiom,
    ! [V__O,V__D,V__T,V__G] :
      ( ( s__instance(V__G,s__Object)
        & s__instance(V__T,s__Motion)
        & s__instance(V__D,s__Object)
        & s__instance(V__O,s__Object) )
     => ( s__instance(V__G,s__Gasket)
       => s__hasPurpose(V__G,'(? [V__O1,V__O2] : (s__instance(V__O1,s__CorpuscularObject) & s__instance(V__O2,s__CorpuscularObject) & s__meetsSpatially(V__O1,V__G) & s__meetsSpatially(V__O2,V__G) & (~ (? [V__H] : (s__instance(V__H,s__Hole) & (V__G = s__HoleHostFn(V__H)) & s__instance(V__T,s__Translocation) & s__path(V__T,V__H) & s__origin(V__T,V__O) & s__destination(V__T,V__D) & s__contains(V__O1,V__O) & (~ s__contains(V__O1,V__D)) & s__meetsSpatially(V__O1,V__D) & (~ (? [V__O3] : (s__instance(V__O3,s__Object) & s__instance(V__H,s__Hole) & s__instance(V__H,s__SelfConnectedObject) & s__instance(V__O2,s__SelfConnectedObject) & s__instance(V__O1,s__SelfConnectedObject) & s__contains(V__H,V__O3) & (~ s__contains(V__O1,V__O3)) & (~ s__contains(V__O2,V__O3))))))))))') ) ) ).

fof(kb_SUMO_1013,axiom,
    s__documentation(s__governorSpeed__m,s__EnglishLanguage,'The maximum speed under normal conditions that a governor will allow a moving part or vehicle to attain before killing power. Note that a vehicle could still conceivably exceed governed speed while coasting down a hill, after the governor has activated.') ).

fof(kb_SUMO_1014,axiom,
    s__format(s__EnglishLanguage,s__governorSpeed__m,'the maximum speed allowed by %1 is %n %2') ).

fof(kb_SUMO_1015,axiom,
    s__domain(s__governorSpeed__m,"1",s__SpeedGovernor) ).

fof(kb_SUMO_1016,axiom,
    s__domain(s__governorSpeed__m,"2",s__FunctionQuantity) ).

fof(kb_SUMO_1017,axiom,
    s__instance(s__governorSpeed__m,s__BinaryPredicate) ).

%FOL fof(kb_SUMO_1018,axiom,(( (! [V__SLOWPROB,V__T2,V__Q,V__T1,V__FASTPROB,V__V,V__L1,V__L2] : ((s__instance(V__L2,s__PhysicalQuantity) & s__instance(V__L1,s__PhysicalQuantity) & s__instance(V__V,s__SpeedGovernor) & s__instance(V__FASTPROB,s__Quantity) & s__instance(V__T1,s__PhysicalQuantity) & s__instance(V__Q,s__FunctionQuantity) & s__instance(V__T2,s__PhysicalQuantity) & s__instance(V__SLOWPROB,s__Quantity)) => ((s__governorSpeed(V__V,V__Q) & (V__FASTPROB = s__ProbabilityFn('s__measure(V__V,s__PerFn(V__L1,V__T1))')) & (V__SLOWPROB = s__ProbabilityFn('s__measure(V__V,s__PerFn(V__L2,V__T2))')) & greater(s__PerFn(V__L1,V__T1),s__PerFn(V__L2,V__T2))) => greater(V__SLOWPROB,V__FASTPROB)))) ))).

fof(kb_SUMO_1019,axiom,
    s__subclass(s__SpeedGovernor,s__Device) ).

fof(kb_SUMO_1020,axiom,
    s__termFormat(s__EnglishLanguage,s__SpeedGovernor,governor) ).

fof(kb_SUMO_1021,axiom,
    s__documentation(s__SpeedGovernor,s__EnglishLanguage,'Any &%Device that is designed to limit the speed of an object under power.') ).

fof(kb_SUMO_1022,axiom,
    ! [V__S,V__V,V__G] :
      ( ( s__instance(V__G,s__EngineeringComponent)
        & s__instance(V__V,s__SpeedGovernor)
        & s__instance(V__V,s__EngineeringComponent)
        & s__instance(V__S,s__FunctionQuantity) )
     => ( ( s__instance(V__G,s__SpeedGovernor)
          & s__governorSpeed(V__V,V__S)
          & s__connectedEngineeringComponents(V__G,V__V) )
       => s__hasPurpose(V__G,'(~ (? [V__SP2] : (s__instance(V__SP2,s__PhysicalQuantity) & s__measure(V__V,V__SP2) & greater(V__SP2,V__S))))') ) ) ).

fof(kb_SUMO_1023,axiom,
    s__subclass(s__EngineGovernor,s__SpeedGovernor) ).

fof(kb_SUMO_1024,axiom,
    s__instance(s__EngineGovernor__t,s__SetOrClass) ).

fof(kb_SUMO_1025,axiom,
    s__instance(s__SpeedGovernor__t,s__SetOrClass) ).

fof(kb_SUMO_1026,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineGovernor,governor) ).

fof(kb_SUMO_1027,axiom,
    s__documentation(s__EngineGovernor,s__EnglishLanguage,'A &%Device that limits the rotational speed of the &%Crankshaft of an engine. This is distinguished from an &%AutomobileGovernor which is designed to limit the speed of an entire &%Automobile.') ).

fof(kb_SUMO_1028,axiom,
    ! [V__S,V__EG,V__E] :
      ( ( s__instance(V__E,s__EngineeringComponent)
        & s__instance(V__E,s__SpeedGovernor)
        & s__instance(V__EG,s__EngineeringComponent)
        & s__instance(V__S,s__FunctionQuantity) )
     => ( ( s__instance(V__EG,s__EngineGovernor)
          & s__instance(V__E,s__Engine)
          & s__connectedEngineeringComponents(V__EG,V__E)
          & s__governorSpeed(V__E,V__S) )
       => s__hasPurpose(V__EG,'(~ (? [V__R,V__P,V__M] : (s__instance(V__M,s__PhysicalQuantity) & s__instance(V__P,s__Object) & s__instance(V__R,s__Physical) & s__instance(V__P,s__Device) & s__part(V__P,V__E) & s__instance(V__R,s__Rotating) & s__holdsDuring(s__WhenFn(V__R),(s__measure(V__P,V__M) & greater(V__M,V__S))))))') ) ) ).

fof(kb_SUMO_1029,axiom,
    s__subclass(s__AutomobileGovernor,s__SpeedGovernor) ).

fof(kb_SUMO_1030,axiom,
    s__instance(s__AutomobileGovernor__t,s__SetOrClass) ).

fof(kb_SUMO_1031,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileGovernor,governor) ).

fof(kb_SUMO_1032,axiom,
    s__documentation(s__AutomobileGovernor,s__EnglishLanguage,'A &%Device that limits the translational speed of a &%Vehicle. This is distinguished from an &%EngineGovernor which is designed to limit the rotational speed of part of an &%Engine.') ).

fof(kb_SUMO_1033,axiom,
    ! [V__S,V__EG,V__E,V__V] :
      ( ( s__instance(V__V,s__EngineeringComponent)
        & s__instance(V__E,s__SpeedGovernor)
        & s__instance(V__EG,s__EngineeringComponent)
        & s__instance(V__S,s__FunctionQuantity) )
     => ( ( s__instance(V__EG,s__EngineGovernor)
          & s__instance(V__V,s__Vehicle)
          & s__connectedEngineeringComponents(V__EG,V__V)
          & s__governorSpeed(V__E,V__S) )
       => s__hasPurpose(V__EG,'(~ (? [V__T,V__M] : (s__instance(V__M,s__PhysicalQuantity) & s__instance(V__T,s__Physical) & s__instance(V__T,s__Translocation) & s__holdsDuring(s__WhenFn(V__T),(s__measure(V__V,V__M) & greater(V__M,V__S))))))') ) ) ).

fof(kb_SUMO_1034,axiom,
    s__subclass(s__Lubricant,s__Substance) ).

fof(kb_SUMO_1035,axiom,
    s__instance(s__Lubricant__t,s__SetOrClass) ).

fof(kb_SUMO_1036,axiom,
    s__termFormat(s__EnglishLanguage,s__Lubricant,lubricant) ).

fof(kb_SUMO_1037,axiom,
    s__documentation(s__Lubricant,s__EnglishLanguage,'Any &%Substance that reduces &%Friction between two objects that are in contact and move with respect to one another. Note that this does not include &%CorpuscularObjects like &%BallBearings.') ).

fof(kb_SUMO_1038,axiom,
    s__subclass(s__Grease,s__Lubricant) ).

fof(kb_SUMO_1039,axiom,
    s__instance(s__Grease__t,s__SetOrClass) ).

fof(kb_SUMO_1040,axiom,
    s__termFormat(s__EnglishLanguage,s__Grease,grease) ).

fof(kb_SUMO_1041,axiom,
    s__documentation(s__Grease,s__EnglishLanguage,'Any &%Lubricant that is a &%Solid at standard ambient temperature.') ).

%FOL fof(kb_SUMO_1042,axiom,(( (! [V__T,V__G] : ((s__instance(V__G,s__Object) & s__instance(V__T,s__TimePosition)) => ((s__instance(V__G,s__Grease) & s__holdsDuring(V__T,'s__measure(V__G,s__MeasureFn(77,s__FahrenheitDegree))')) => s__holdsDuring(V__T,'s__attribute(V__G,s__Solid)')))) ))).

fof(kb_SUMO_1043,axiom,
    s__subclass(s__Lubricating,s__Putting) ).

fof(kb_SUMO_1044,axiom,
    s__instance(s__Lubricating__t,s__SetOrClass) ).

fof(kb_SUMO_1045,axiom,
    s__termFormat(s__EnglishLanguage,s__Lubricating,lubricating) ).

fof(kb_SUMO_1046,axiom,
    s__documentation(s__Lubricating,s__EnglishLanguage,'&%Putting a &%Lubricant on some &%Object with the purpose to reduce &%Friction when that part moves against another.') ).

fof(kb_SUMO_1047,axiom,
    ! [V__LP] :
      ( s__instance(V__LP,s__Transfer)
     => ( s__instance(V__LP,s__Lubricating)
       => ? [V__L] :
            ( s__instance(V__L,s__Object)
            & s__instance(V__L,s__Lubricant)
            & s__objectTransferred(V__LP,V__L) ) ) ) ).

fof(kb_SUMO_1048,axiom,
    s__subclass(s__GreaseFitting,s__Device) ).

fof(kb_SUMO_1049,axiom,
    s__instance(s__GreaseFitting__t,s__SetOrClass) ).

fof(kb_SUMO_1050,axiom,
    s__termFormat(s__EnglishLanguage,s__GreaseFitting,'grease fitting') ).

fof(kb_SUMO_1051,axiom,
    s__documentation(s__GreaseFitting,s__EnglishLanguage,'A grease fitting is a small &%Device that is designed for use with a &%GreaseGun, and includes a &%Valve that lets &%Grease get pumped into (but not out of) a small space, for the purpose of &%Lubricating parts.') ).

fof(kb_SUMO_1052,axiom,
    ! [V__GF] :
      ( s__instance(V__GF,s__Object)
     => ( s__instance(V__GF,s__GreaseFitting)
       => ? [V__V] :
            ( s__instance(V__V,s__Object)
            & s__instance(V__V,s__Valve)
            & s__part(V__V,V__GF) ) ) ) ).

fof(kb_SUMO_1053,axiom,
    ! [V__GF] :
      ( s__instance(V__GF,s__Object)
     => ( s__instance(V__GF,s__GreaseFitting)
       => s__hasPurpose(V__GF,'(? [V__P,V__G] : (s__instance(V__G,s__Object) & s__instance(V__P,s__Transfer) & s__instance(V__G,s__Grease) & s__instance(V__P,s__Putting) & s__path(V__P,V__GF) & s__objectTransferred(V__P,V__G)))') ) ) ).

fof(kb_SUMO_1054,axiom,
    s__subclass(s__GreaseGun,s__Device) ).

fof(kb_SUMO_1055,axiom,
    s__instance(s__GreaseGun__t,s__SetOrClass) ).

fof(kb_SUMO_1056,axiom,
    s__termFormat(s__EnglishLanguage,s__GreaseGun,'grease gun') ).

fof(kb_SUMO_1057,axiom,
    s__documentation(s__GreaseGun,s__EnglishLanguage,'A &%Device used to inject &%Grease through a &%GreaseFitting or other mechanicm. This includes manual guns that use some sort of lever action for mechanical advantage as well as electric or battery-powered guns.') ).

fof(kb_SUMO_1058,axiom,
    ! [V__GG] :
      ( s__instance(V__GG,s__Object)
     => ( s__instance(V__GG,s__GreaseGun)
       => s__hasPurpose(V__GG,'(? [V__P,V__G] : (s__instance(V__G,s__Object) & s__instance(V__P,s__Transfer) & s__instance(V__G,s__Grease) & s__instance(V__P,s__Putting) & s__instrument(V__P,V__GG) & s__objectTransferred(V__P,V__G)))') ) ) ).

fof(kb_SUMO_1059,axiom,
    s__subclass(s__Hydrometer,s__MeasuringDevice) ).

fof(kb_SUMO_1060,axiom,
    s__instance(s__Hydrometer__t,s__SetOrClass) ).

fof(kb_SUMO_1061,axiom,
    s__termFormat(s__EnglishLanguage,s__Hydrometer,hydrometer) ).

fof(kb_SUMO_1062,axiom,
    s__documentation(s__Hydrometer,s__EnglishLanguage,'A &%MeasuringDevice that is used in &%Measuring the &%DensityFn of a liquid, usually with respect to &%Water.') ).

fof(kb_SUMO_1063,axiom,
    ! [V__H] :
      ( s__instance(V__H,s__Object)
     => ( s__instance(V__H,s__Hydrometer)
       => s__hasPurpose(V__H,'(? [V__M,V__S] : (s__instance(V__S,s__Object) & s__instance(V__M,s__Process) & s__instance(V__M,s__Measuring) & s__instance(V__S,s__Substance) & s__attribute(V__S,s__Liquid) & s__patient(V__M,V__S) & s__instrument(V__M,V__H)))') ) ) ).

fof(kb_SUMO_1064,axiom,
    s__subclass(s__WireCoil,s__Wire) ).

fof(kb_SUMO_1065,axiom,
    s__instance(s__WireCoil__t,s__SetOrClass) ).

fof(kb_SUMO_1066,axiom,
    s__termFormat(s__EnglishLanguage,s__WireCoil,'wire coil') ).

fof(kb_SUMO_1067,axiom,
    s__documentation(s__WireCoil,s__EnglishLanguage,'A length of &%Wire wound in a set of &%Circles or &%Polygons, intended to conduct &%Electricity, and often used in the construction of &%ElectricalTransformers.') ).

fof(kb_SUMO_1068,axiom,
    ! [V__WC] :
      ( s__instance(V__WC,s__CorpuscularObject)
     => ( s__instance(V__WC,s__WireCoil)
       => s__material(s__ConductorSubstance,V__WC) ) ) ).

fof(kb_SUMO_1069,axiom,
    ! [V__WC] :
      ( s__instance(V__WC,s__Object)
     => ( s__instance(V__WC,s__WireCoil)
       => ? [V__P] :
            ( s__instance(V__P,s__Object)
            & s__part(V__P,V__WC)
            & s__attribute(V__P,s__ClosedTwoDimensionalFigure) ) ) ) ).

fof(kb_SUMO_1070,axiom,
    s__subclass(s__ElectricalTransformer,s__Transformer) ).

fof(kb_SUMO_1071,axiom,
    s__instance(s__ElectricalTransformer__t,s__SetOrClass) ).

fof(kb_SUMO_1072,axiom,
    s__instance(s__Transformer__t,s__SetOrClass) ).

fof(kb_SUMO_1073,axiom,
    s__termFormat(s__EnglishLanguage,s__ElectricalTransformer,'electrical transformer') ).

fof(kb_SUMO_1074,axiom,
    s__documentation(s__ElectricalTransformer,s__EnglishLanguage,'A &%Device for converting one measure of &%Volts to another. Two coils of wire are inductively coupled around a common core. The ratio of the number of windings in each coil is same as the ratio of the resulting voltages.') ).

fof(kb_SUMO_1075,axiom,
    ! [V__ET] :
      ( s__instance(V__ET,s__Object)
     => ( s__instance(V__ET,s__ElectricalTransformer)
       => ? [V__WC1,V__WC2] :
            ( s__instance(V__WC2,s__Object)
            & s__instance(V__WC1,s__Object)
            & s__instance(V__WC1,s__WireCoil)
            & s__instance(V__WC2,s__WireCoil)
            & s__part(V__WC1,V__ET)
            & s__part(V__WC2,V__ET) ) ) ) ).

%FOL fof(kb_SUMO_1076,axiom,(( (! [V__N2,V__N1,V__T,V__WC1,V__WC2,V__V1,V__V2] : ((s__instance(V__V2,s__UnitOfMeasure) & s__instance(V__V1,s__UnitOfMeasure) & s__instance(V__T,s__TimePosition) & s__instance(V__N1,s__Integer) & s__instance(V__N2,s__Integer)) => ((s__instance(V__T,s__ElectricalTransformer) & s__instance(V__WC1,s__WireCoil) & s__instance(V__WC2,s__WireCoil) & s__coilCount(V__WC1,V__N1) & s__coilCount(V__WC2,V__N2) & s__holdsDuring(V__T,'s__measure(V__WC1,s__MeasureFn(s__Volt,V__V1))')) => (s__holdsDuring(V__T,'s__measure(V__WC2,s__MeasureFn(s__Volt,V__V2))') & (V__V2 = times(V__V1,divide(V__N2,V__N1))))))) ))).

fof(kb_SUMO_1077,axiom,
    s__instance(s__coilCount__m,s__BinaryPredicate) ).

fof(kb_SUMO_1078,axiom,
    s__domain(s__coilCount__m,"1",s__WireCoil) ).

fof(kb_SUMO_1079,axiom,
    s__domain(s__coilCount__m,"2",s__Integer) ).

fof(kb_SUMO_1080,axiom,
    s__format(s__EnglishLanguage,s__coilCount__m,'the number of coils in %1 is %n %2') ).

fof(kb_SUMO_1081,axiom,
    s__documentation(s__coilCount__m,s__EnglishLanguage,'The number of windings in a &%WireCoil.') ).

fof(kb_SUMO_1082,axiom,
    ! [V__N,V__WC] :
      ( s__coilCount(V__WC,V__N)
     => ? [V__C] :
          ( s__instance(V__C,s__Collection)
          & s__memberCount(V__C,V__N)
          & ! [V__M] :
              ( ( s__instance(V__M,s__SelfConnectedObject)
                & s__instance(V__WC,s__WireCoil)
                & s__instance(V__N,s__Integer) )
             => ( s__member(V__M,V__C)
               => ( s__attribute(V__M,s__ClosedTwoDimensionalFigure)
                  & s__part(V__M,V__WC)
                  & ~ ? [V__M2] :
                        ( s__instance(V__M2,s__SelfConnectedObject)
                        & s__instance(V__C,s__Collection)
                        & s__overlapsSpatially(V__M2,V__M)
                        & s__member(V__M2,V__C) ) ) ) ) ) ) ).

fof(kb_SUMO_1083,axiom,
    s__subclass(s__IgnitionCoil,s__ElectricalTransformer) ).

fof(kb_SUMO_1084,axiom,
    s__instance(s__IgnitionCoil__t,s__SetOrClass) ).

fof(kb_SUMO_1085,axiom,
    s__termFormat(s__EnglishLanguage,s__IgnitionCoil,'ignition coil') ).

fof(kb_SUMO_1086,axiom,
    s__documentation(s__IgnitionCoil,s__EnglishLanguage,'An &%ElectricalTransformer designed to take 12 &%Volt power from the &%Battery of an &%Automobile and convert it to the 10,000-50,000 volts required to produce a &%Spark across the &%SparkPlugs.') ).

fof(kb_SUMO_1087,axiom,
    s__typicalPart(s__IgnitionCoil,s__Automobile) ).

fof(kb_SUMO_1088,axiom,
    s__typicallyContainsPart(s__IgnitionCoil,s__Automobile) ).

fof(kb_SUMO_1089,axiom,
    ! [V__IC] :
      ( s__instance(V__IC,s__Object)
     => ( s__instance(V__IC,s__IgnitionCoil)
       => s__hasPurpose(V__IC,'(? [V__E1,V__E2,V__P] : (s__instance(V__P,s__Process) & s__instance(V__E1,s__Object) & s__instance(V__P,s__ElectricTransmission) & s__resource(V__P,V__E1) & s__instance(V__E1,s__Electricity) & s__instance(V__E2,s__Electricity) & s__result(V__P,V__E2) & s__instrument(V__P,V__IC)))') ) ) ).

fof(kb_SUMO_1090,axiom,
    ! [V__P,V__N1,V__IC,V__E2,V__E1] :
      ( ( s__instance(V__E1,s__Object)
        & s__instance(V__IC,s__Object)
        & s__instance(V__N1,s__UnitOfMeasure)
        & s__instance(V__N1,s__RealNumber)
        & s__instance(V__P,s__Process) )
     => ( ( s__instance(V__IC,s__IgnitionCoil)
          & s__instance(V__P,s__ElectricTransmission)
          & s__resource(V__P,V__E1)
          & s__instance(V__E1,s__Electricity)
          & s__instance(V__E2,s__Electricity)
          & s__result(V__P,V__E2)
          & s__instrument(V__P,V__IC)
          & s__measure(V__E1,s__MeasureFn(s__Volt,V__N1)) )
       => s__approximateValue(V__N1,"12") ) ) ).

fof(kb_SUMO_1091,axiom,
    ! [V__IC] :
      ( s__instance(V__IC,s__Object)
     => ( s__instance(V__IC,s__IgnitionCoil)
       => s__hasPurpose(V__IC,'(? [V__P,V__S] : (s__instance(V__S,s__Process) & s__instance(V__P,s__Process) & s__instance(V__P,s__ElectricTransmission) & s__instrument(V__P,V__IC) & s__instance(V__S,s__Spark) & s__causes(V__P,V__S)))') ) ) ).

fof(kb_SUMO_1092,axiom,
    s__instance(s__approximateValue__m,s__BinaryPredicate) ).

fof(kb_SUMO_1093,axiom,
    s__domain(s__approximateValue__m,"1",s__RealNumber) ).

fof(kb_SUMO_1094,axiom,
    s__domain(s__approximateValue__m,"2",s__RealNumber) ).

fof(kb_SUMO_1095,axiom,
    s__format(s__EnglishLanguage,s__approximateValue__m,'the approximate value of %1 is %n %2') ).

fof(kb_SUMO_1096,axiom,
    s__documentation(s__approximateValue__m,s__EnglishLanguage,'A relation that specifies two numbers are equal or nearly so.') ).

fof(kb_SUMO_1097,axiom,
    ! [V__N2,V__N1] :
      ( ( s__instance(V__N1,s__RealNumber)
        & s__instance(V__N2,s__RealNumber) )
     => ( s__approximateValue(V__N1,V__N2)
       => s__modalAttribute('(V__N1 = V__N2)',s__Likely) ) ) ).

%FOL fof(kb_SUMO_1098,axiom,(( (! [V__N2,V__N1] : ((s__instance(V__N1,s__RealNumber) & s__instance(V__N2,s__RealNumber)) => (s__approximateValue(V__N1,V__N2) => s__modalAttribute('greater(0.9,divide(V__N1,V__N2))',s__Unlikely)))) ))).

%FOL fof(kb_SUMO_1099,axiom,(( (! [V__N2,V__N1] : ((s__instance(V__N1,s__RealNumber) & s__instance(V__N2,s__RealNumber)) => (s__approximateValue(V__N1,V__N2) => s__modalAttribute('greater(0.9,divide(V__N2,V__N1))',s__Unlikely)))) ))).

fof(kb_SUMO_1100,axiom,
    s__subclass(s__IgnitionControlModule,s__Computer) ).

fof(kb_SUMO_1101,axiom,
    s__instance(s__IgnitionControlModule__t,s__SetOrClass) ).

fof(kb_SUMO_1102,axiom,
    s__termFormat(s__EnglishLanguage,s__IgnitionControlModule,'ignition control module') ).

fof(kb_SUMO_1103,axiom,
    s__documentation(s__IgnitionControlModule,s__EnglishLanguage,'A &%Computer that controls the ignition system, and may itself be controlled by the &%EngineControlModule.') ).

fof(kb_SUMO_1104,axiom,
    ! [V__ICM] :
      ( s__instance(V__ICM,s__Object)
     => ( s__instance(V__ICM,s__IgnitionControlModule)
       => s__hasPurpose(V__ICM,'(? [V__S,V__A,V__CP] : (s__instance(V__CP,s__Process) & s__instance(V__A,s__Object) & s__instance(V__S,s__Process) & s__instance(V__A,s__Automobile) & s__instance(V__S,s__Spark) & s__instance(V__CP,s__ComputerProcess) & s__part(V__ICM,V__A) & s__eventLocated(V__CP,V__A) & s__eventLocated(V__S,V__A) & s__causes(V__CP,V__S)))') ) ) ).

fof(kb_SUMO_1105,axiom,
    s__subclass(s__AutomobileIgnitionSystem,s__PhysicalSystem) ).

fof(kb_SUMO_1106,axiom,
    s__instance(s__AutomobileIgnitionSystem__t,s__SetOrClass) ).

fof(kb_SUMO_1107,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileIgnitionSystem,'automobile ignition system') ).

fof(kb_SUMO_1108,axiom,
    s__documentation(s__AutomobileIgnitionSystem,s__EnglishLanguage,'The system of an &%Automobile that is responsible for taking power from the &%Battery, increasing its voltage and sending it, with the appropriate timing, to the &%SparkPlugs so that sparks ignite the &%FuelVapor in the &%CombustionChambers of the &%Engine.') ).

fof(kb_SUMO_1109,axiom,
    s__typicalPart(s__IgnitionControlModule,s__AutomobileIgnitionSystem) ).

fof(kb_SUMO_1110,axiom,
    s__typicallyContainsPart(s__IgnitionControlModule,s__AutomobileIgnitionSystem) ).

fof(kb_SUMO_1111,axiom,
    s__typicalPart(s__SparkPlug,s__AutomobileIgnitionSystem) ).

fof(kb_SUMO_1112,axiom,
    s__typicallyContainsPart(s__SparkPlug,s__AutomobileIgnitionSystem) ).

fof(kb_SUMO_1113,axiom,
    s__subclass(s__JumperCable,s__Device) ).

fof(kb_SUMO_1114,axiom,
    s__instance(s__JumperCable__t,s__SetOrClass) ).

fof(kb_SUMO_1115,axiom,
    s__termFormat(s__EnglishLanguage,s__JumperCable,'jumper cable') ).

fof(kb_SUMO_1116,axiom,
    s__documentation(s__JumperCable,s__EnglishLanguage,'A &%Wire with &%Clamps on both ends, designed for making temporary electrical connections.') ).

fof(kb_SUMO_1117,axiom,
    ! [V__JC] :
      ( s__instance(V__JC,s__JumperCable)
     => ? [V__C1,V__C2,V__W] :
          ( s__instance(V__W,s__EngineeringComponent)
          & s__instance(V__C2,s__EngineeringComponent)
          & s__instance(V__C1,s__EngineeringComponent)
          & s__instance(V__C1,s__Clamp)
          & s__instance(V__C2,s__Clamp)
          & s__instance(V__W,s__Wire)
          & s__connectedEngineeringComponents(V__C1,V__W)
          & s__connectedEngineeringComponents(V__C2,V__W)
          & V__C1 != V__C2 ) ) ).

fof(kb_SUMO_1118,axiom,
    s__subclass(s__LaminatedWindshield,s__Windshield) ).

fof(kb_SUMO_1119,axiom,
    s__instance(s__LaminatedWindshield__t,s__SetOrClass) ).

fof(kb_SUMO_1120,axiom,
    s__termFormat(s__EnglishLanguage,s__LaminatedWindshield,windshield) ).

fof(kb_SUMO_1121,axiom,
    s__documentation(s__LaminatedWindshield,s__EnglishLanguage,'A type of glass required in all modern &%Automobiles that consists of two layers of glass with a layer of plastic sandwiched in between. The plastic layer keeps shards of glass from separating completely from the rest of the windshield when broken, and is therefore a key feature in accident safety.') ).

fof(kb_SUMO_1122,axiom,
    ! [V__LW] :
      ( s__instance(V__LW,s__Object)
     => ( s__instance(V__LW,s__LaminatedWindshield)
       => ? [V__G1,V__G2,V__P] :
            ( s__instance(V__P,s__Object)
            & s__instance(V__G2,s__Object)
            & s__instance(V__G1,s__Object)
            & s__instance(V__G1,s__Glass)
            & s__instance(V__G2,s__Glass)
            & s__instance(V__P,s__Plastic)
            & s__part(V__G1,V__LW)
            & s__part(V__G2,V__LW)
            & s__part(V__P,V__LW)
            & s__between(V__G1,V__P,V__G2) ) ) ) ).

fof(kb_SUMO_1123,axiom,
    s__subclass(s__MacPhersonStrut,s__AutomobileShock) ).

fof(kb_SUMO_1124,axiom,
    s__instance(s__MacPhersonStrut__t,s__SetOrClass) ).

fof(kb_SUMO_1125,axiom,
    s__instance(s__AutomobileShock__t,s__SetOrClass) ).

fof(kb_SUMO_1126,axiom,
    s__termFormat(s__EnglishLanguage,s__MacPhersonStrut,'MacPherson strut') ).

fof(kb_SUMO_1127,axiom,
    s__documentation(s__MacPhersonStrut,s__EnglishLanguage,'A type of oversized shock absorber that has easily replaceable components.') ).

fof(kb_SUMO_1128,axiom,
    s__typicalPart(s__MacPhersonStrut,s__AutoSuspensionSystem) ).

fof(kb_SUMO_1129,axiom,
    s__subclass(s__ManifoldHeatControlValve,s__Valve) ).

fof(kb_SUMO_1130,axiom,
    s__instance(s__ManifoldHeatControlValve__t,s__SetOrClass) ).

fof(kb_SUMO_1131,axiom,
    s__documentation(s__ManifoldHeatControlValve,s__EnglishLanguage,'A device present on older vehicles with &%Carburetors that sends hot &%Exhaust gases to pre-heat the &%FuelVapor for more efficient &%Combustion.') ).

fof(kb_SUMO_1132,axiom,
    s__typicalPart(s__ManifoldHeatControlValve,s__Manifold) ).

fof(kb_SUMO_1133,axiom,
    ! [V__MHCV] :
      ( s__instance(V__MHCV,s__Object)
     => ( s__instance(V__MHCV,s__ManifoldHeatControlValve)
       => s__hasPurpose(V__MHCV,'(? [V__H,V__O,V__E,V__FV,V__T] : (s__instance(V__T,s__Motion) & s__instance(V__E,s__Object) & s__instance(V__O,s__Process) & s__instance(V__H,s__Process) & s__instance(V__H,s__Heating) & s__instance(V__O,s__Opening) & s__instance(V__E,s__Exhaust) & s__instance(V__T,s__Transfer) & s__instance(V__FV,s__FuelVapor) & s__patient(V__O,V__MHCV) & s__instrument(V__H,V__E) & s__patient(V__H,V__FV) & s__path(V__T,V__MHCV) & s__causes(V__O,V__T) & s__causes(V__T,V__H)))') ) ) ).

fof(kb_SUMO_1134,axiom,
    s__subclass(s__EngineMAPSensor,s__PressureMeasuringDevice) ).

fof(kb_SUMO_1135,axiom,
    s__instance(s__EngineMAPSensor__t,s__SetOrClass) ).

fof(kb_SUMO_1136,axiom,
    s__documentation(s__EngineMAPSensor,s__EnglishLanguage,'A sensor that measures the pressure in the &%ExhaustManifold and adjusts &%FuelVapor mixture and &%Engine timing accordingly.') ).

fof(kb_SUMO_1137,axiom,
    s__termFormat(s__EnglishLanguage,s__EngineMAPSensor,'manifold absolute pressure sensor') ).

fof(kb_SUMO_1138,axiom,
    s__typicalPart(s__EngineMAPSensor,s__ExhaustManifold) ).

fof(kb_SUMO_1139,axiom,
    ! [V__EMS] :
      ( s__instance(V__EMS,s__EngineeringComponent)
     => ( s__instance(V__EMS,s__EngineMAPSensor)
       => s__hasPurpose(V__EMS,'(? [V__ECM,V__A] : (s__instance(V__A,s__Object) & s__instance(V__ECM,s__EngineeringComponent) & s__instance(V__ECM,s__EngineControlModule) & s__instance(V__A,s__Automobile) & s__part(V__EMS,V__A) & s__part(V__ECM,V__A) & s__connectedEngineeringComponents(V__EMS,V__ECM)))') ) ) ).

fof(kb_SUMO_1140,axiom,
    s__subclass(s__MassAirflowSensor,s__MeasuringDevice) ).

fof(kb_SUMO_1141,axiom,
    s__instance(s__MassAirflowSensor__t,s__SetOrClass) ).

fof(kb_SUMO_1142,axiom,
    s__termFormat(s__EnglishLanguage,s__MassAirflowSensor,'mass airflow sensor') ).

fof(kb_SUMO_1143,axiom,
    s__documentation(s__MassAirflowSensor,s__EnglishLanguage,'A &%Device that measures the amount of &%Air flowing to the throttle body in a fuel injection system. It sends this information to the &%EngineControlModule.') ).

fof(kb_SUMO_1144,axiom,
    ! [V__MAS,V__GM,V__Air] :
      ( ( s__instance(V__Air,s__SetOrClass)
        & s__instance(V__GM,s__Process)
        & s__instance(V__MAS,s__Object) )
     => ( s__instance(V__MAS,s__MassAirflowSensor)
       => s__hasPurpose(V__MAS,'(? [V__T,V__M,V__A] : (s__instance(V__M,s__Process) & s__instance(V__T,s__Transfer) & s__instance(V__A,V__Air) & s__patient(V__GM,V__A) & s__instance(V__M,s__Measuring) & s__patient(V__M,V__A) & s__instrument(V__M,V__MAS)))') ) ) ).

fof(kb_SUMO_1145,axiom,
    s__subclass(s__OilPan,s__FluidContainer) ).

fof(kb_SUMO_1146,axiom,
    s__instance(s__OilPan__t,s__SetOrClass) ).

fof(kb_SUMO_1147,axiom,
    s__termFormat(s__EnglishLanguage,s__OilPan,'oil pan') ).

fof(kb_SUMO_1148,axiom,
    s__documentation(s__OilPan,s__EnglishLanguage,'A &%Container for the &%Oil that is used in &%Lubricating the &%Engine of an &%Automobile. The oil is pumped continuously to the engines moving parts, when in operation, by the &%OilPump.') ).

fof(kb_SUMO_1149,axiom,
    s__typicalPart(s__OilPan,s__InternalCombustionEngine) ).

fof(kb_SUMO_1150,axiom,
    s__typicallyContainsPart(s__OilPan,s__InternalCombustionEngine) ).

fof(kb_SUMO_1151,axiom,
    ! [V__OP] :
      ( s__instance(V__OP,s__SelfConnectedObject)
     => ( s__instance(V__OP,s__OilPan)
       => s__hasPurpose(V__OP,'(? [V__O] : (s__instance(V__O,s__Object) & s__instance(V__O,s__Oil) & s__contains(V__OP,V__O)))') ) ) ).

fof(kb_SUMO_1152,axiom,
    s__subclass(s__ORing,s__Gasket) ).

fof(kb_SUMO_1153,axiom,
    s__instance(s__ORing__t,s__SetOrClass) ).

fof(kb_SUMO_1154,axiom,
    s__documentation(s__ORing,s__EnglishLanguage,'A &%Gasket that has an O-shaped cross section. It is often made of &%Rubber or a synthetic rubber which is actually &%Plastic.') ).

fof(kb_SUMO_1155,axiom,
    s__subclass(s__OxygenSensor,s__MeasuringDevice) ).

fof(kb_SUMO_1156,axiom,
    s__instance(s__OxygenSensor__t,s__SetOrClass) ).

fof(kb_SUMO_1157,axiom,
    s__documentation(s__OxygenSensor,s__EnglishLanguage,'A sensor that measures &%Oxygen. Typically it is to measure the &%Exhaust of an &%Automobile. More oxygen signals a lean fuel mixture, and less a rich one.') ).

fof(kb_SUMO_1158,axiom,
    ! [V__OS] :
      ( s__instance(V__OS,s__Object)
     => ( s__instance(V__OS,s__OxygenSensor)
       => s__hasPurpose(V__OS,'(? [V__O,V__M] : (s__instance(V__M,s__Process) & s__instance(V__O,s__Oxygen) & s__instance(V__M,s__Measuring) & s__patient(V__M,V__O) & s__instrument(V__M,V__OS)))') ) ) ).

fof(kb_SUMO_1159,axiom,
    s__subclass(s__SafetyDevice,s__Device) ).

fof(kb_SUMO_1160,axiom,
    s__termFormat(s__EnglishLanguage,s__SafetyDevice,'safety device') ).

fof(kb_SUMO_1161,axiom,
    s__documentation(s__SafetyDevice,s__EnglishLanguage,'Any &%Device that is designed to prevent (or lessen the likelihood of) the &%Injuring of a &%Human.') ).

fof(kb_SUMO_1162,axiom,
    ! [V__SD] :
      ( s__instance(V__SD,s__Object)
     => ( s__instance(V__SD,s__SafetyDevice)
       => s__hasPurpose(V__SD,'(? [V__P,V__I,V__H] : (s__instance(V__H,s__Agent) & s__instance(V__I,s__Process) & s__subclass(V__I,s__Process) & s__subclass(V__P,s__Process) & s__instance(V__H,s__Human) & s__instance(V__P,s__Process) & s__instance(V__I,s__Injuring) & s__experiencer(V__I,V__H) & s__instrument(V__P,V__SD) & s__prevents(V__P,V__I)))') ) ) ).

fof(kb_SUMO_1163,axiom,
    s__subclass(s__VehicleSafetyDevice,s__SafetyDevice) ).

fof(kb_SUMO_1164,axiom,
    s__termFormat(s__EnglishLanguage,s__VehicleSafetyDevice,'vehicle safety device') ).

fof(kb_SUMO_1165,axiom,
    s__documentation(s__VehicleSafetyDevice,s__EnglishLanguage,'Any &%SafetyDevice that is designed to prevent (or lessen the likelihood of) the &%Injuring of a &%Human while in &%Vehicle.') ).

fof(kb_SUMO_1166,axiom,
    ! [V__VSD] :
      ( s__instance(V__VSD,s__Object)
     => ( s__instance(V__VSD,s__VehicleSafetyDevice)
       => s__hasPurpose(V__VSD,'(? [V__V] : (s__instance(V__V,s__Object) & s__instance(V__V,s__Vehicle) & s__part(V__VSD,V__V)))') ) ) ).

fof(kb_SUMO_1167,axiom,
    s__subclass(s__Balloon,s__FluidContainer) ).

fof(kb_SUMO_1168,axiom,
    s__instance(s__Balloon__t,s__SetOrClass) ).

fof(kb_SUMO_1169,axiom,
    s__termFormat(s__EnglishLanguage,s__Balloon,balloon) ).

fof(kb_SUMO_1170,axiom,
    s__documentation(s__Balloon,s__EnglishLanguage,'Any &%Pliable container that is made for holding a &%Gas.') ).

fof(kb_SUMO_1171,axiom,
    ! [V__B] :
      ( s__instance(V__B,s__Object)
     => ( s__instance(V__B,s__Balloon)
       => s__attribute(V__B,s__Pliable) ) ) ).

fof(kb_SUMO_1172,axiom,
    ! [V__B] :
      ( s__instance(V__B,s__SelfConnectedObject)
     => ( s__instance(V__B,s__Balloon)
       => s__hasPurpose(V__B,'(? [V__G] : (s__instance(V__G,s__Object) & s__attribute(V__G,s__Gas) & s__contains(V__B,V__G)))') ) ) ).

fof(kb_SUMO_1173,axiom,
    s__subclass(s__Inflating,s__Increasing) ).

fof(kb_SUMO_1174,axiom,
    s__instance(s__Inflating__t,s__SetOrClass) ).

fof(kb_SUMO_1175,axiom,
    s__termFormat(s__EnglishLanguage,s__Inflating,'Any &%Process where a &%Balloon is filled with a &%Gas.') ).

%FOL fof(kb_SUMO_1176,axiom,(( (! [V__I] : (s__instance(V__I,s__Physical) => (s__instance(V__I,s__Inflating) => (? [V__G1,V__G2,V__V1,V__V2,V__S] : (s__instance(V__S,s__SetOrClass) & s__instance(V__V2,s__PhysicalQuantity) & s__instance(V__V1,s__PhysicalQuantity) & s__instance(V__G2,s__Object) & s__instance(V__G2,s__Quantity) & s__instance(V__G1,s__Object) & s__instance(V__G1,s__Quantity) & s__instance(V__G1,V__S) & s__instance(V__G2,V__S) & s__attribute(V__G1,s__Gas) & s__attribute(V__G2,s__Gas) & s__instance(V__V1,s__VolumeMeasure) & s__holdsDuring(s__ImmediatePastFn(s__WhenFn(V__I)),'s__measure(V__G1,V__V1)') & s__holdsDuring(s__ImmediateFutureFn(s__WhenFn(V__I)),'s__measure(V__G2,V__V2)') & greater(V__G2,V__G1)))))) ))).

fof(kb_SUMO_1177,axiom,
    s__subclass(s__AutoAirbag,s__VehicleSafetyDevice) ).

fof(kb_SUMO_1178,axiom,
    s__instance(s__AutoAirbag__t,s__SetOrClass) ).

fof(kb_SUMO_1179,axiom,
    s__instance(s__VehicleSafetyDevice__t,s__SetOrClass) ).

fof(kb_SUMO_1180,axiom,
    s__subclass(s__AutoAirbag,s__Balloon) ).

fof(kb_SUMO_1181,axiom,
    s__termFormat(s__EnglishLanguage,s__AutoAirbag,airbag) ).

fof(kb_SUMO_1182,axiom,
    s__documentation(s__AutoAirbag,s__EnglishLanguage,'Sensors that detect a sudden &%Decelerating deploy the airbag by an explosive release of a &%Gas that fills the bag before the occupant can be thrown against the hard interior surfaces of the &%Vehicle.') ).

fof(kb_SUMO_1183,axiom,
    s__typicallyContainsPart(s__AutoAirbag,s__Automobile) ).

fof(kb_SUMO_1184,axiom,
    ! [V__AB] :
      ( s__instance(V__AB,s__Object)
     => ( s__instance(V__AB,s__Airbag)
       => s__hasPurpose(V__AB,'(? [V__A,V__D,V__H,V__I,V__P] : (s__instance(V__P,s__Object) & s__instance(V__I,s__Process) & s__subclass(V__I,s__Process) & s__instance(V__H,s__Transfer) & s__subclass(V__H,s__Process) & s__instance(V__D,s__Process) & s__instance(V__A,s__SelfConnectedObject) & s__instance(V__A,s__Automobile) & s__instance(V__D,s__Decelerating) & s__instance(V__H,s__Impacting) & s__instance(V__I,s__Inflating) & s__instance(V__P,s__Human) & s__holdsDuring(s__WhenFn(V__D),s__contains(V__A,V__P)) & s__part(V__AB,V__A) & s__patient(V__D,V__A) & s__patient(V__I,V__AB) & s__objectTransferred(V__H,V__P) & s__destination(V__H,V__A) & s__prevents(V__I,V__H)))') ) ) ).

fof(kb_SUMO_1185,axiom,
    s__subclass(s__SeatBelt,s__VehicleSafetyDevice) ).

fof(kb_SUMO_1186,axiom,
    s__instance(s__SeatBelt__t,s__SetOrClass) ).

fof(kb_SUMO_1187,axiom,
    s__termFormat(s__EnglishLanguage,s__SeatBelt,'seat belt') ).

fof(kb_SUMO_1188,axiom,
    s__documentation(s__SeatBelt,s__EnglishLanguage,'A flexible belt that is part of a &%Vehicle, and worn across the waist, and also typically the shoulder, that prevents impact of the wearer into the interior surfaces of the &%Vehicle during rapid &%Decelerating.') ).

fof(kb_SUMO_1189,axiom,
    s__typicallyContainsPart(s__SeatBelt,s__Automobile) ).

fof(kb_SUMO_1190,axiom,
    ! [V__SB] :
      ( s__instance(V__SB,s__Object)
     => ( s__instance(V__SB,s__SeatBelt)
       => s__attribute(V__SB,s__Pliable) ) ) ).

fof(kb_SUMO_1191,axiom,
    s__subclass(s__PistonRing,s__Gasket) ).

fof(kb_SUMO_1192,axiom,
    s__instance(s__PistonRing__t,s__SetOrClass) ).

fof(kb_SUMO_1193,axiom,
    s__termFormat(s__EnglishLanguage,s__PistonRing,'piston ring') ).

fof(kb_SUMO_1194,axiom,
    s__documentation(s__PistonRing,s__EnglishLanguage,'A &%Piston typically has several such rings to seal the piston against the &%EngineCylinder while allowing it to move, and yet contain &%Combustion and the &%Oil that is used for &%Lubricating the involved surfaces.') ).

fof(kb_SUMO_1195,axiom,
    s__typicalPart(s__PistonRing,s__Piston) ).

fof(kb_SUMO_1196,axiom,
    s__typicallyContainsPart(s__PistonRing,s__Piston) ).

fof(kb_SUMO_1197,axiom,
    s__subclass(s__PositiveCrankcaseVentilationValve,s__Valve) ).

fof(kb_SUMO_1198,axiom,
    s__instance(s__PositiveCrankcaseVentilationValve__t,s__SetOrClass) ).

fof(kb_SUMO_1199,axiom,
    s__termFormat(s__EnglishLanguage,s__PositiveCrankcaseVentilationValve,'positive crankcase ventilation valve') ).

fof(kb_SUMO_1200,axiom,
    s__documentation(s__PositiveCrankcaseVentilationValve,s__EnglishLanguage,'A valve that is designed to send unburned fuel that escapes into the &%Crankcase back to the &%CombustionChamber.') ).

fof(kb_SUMO_1201,axiom,
    s__typicalPart(s__PositiveCrankcaseVentilationValve,s__FourStrokeEngine) ).

fof(kb_SUMO_1202,axiom,
    ! [V__PCVV] :
      ( s__instance(V__PCVV,s__Object)
     => ( s__instance(V__PCVV,s__PositiveCrankcaseVentilationValve)
       => s__hasPurpose(V__PCVV,'(? [V__CR,V__F,V__CC,V__T,V__A] : (s__instance(V__A,s__Object) & s__instance(V__CC,s__Object) & s__instance(V__F,s__Object) & s__instance(V__CR,s__Object) & s__instance(V__CR,s__Crankcase) & s__instance(V__F,s__Fuel) & s__instance(V__CC,s__CombustionChamber) & s__instance(V__T,s__Transfer) & s__instance(V__A,s__Automobile) & s__part(V__CR,V__A) & s__part(V__CC,V__A) & s__part(V__PCVV,V__A) & s__origin(V__T,V__CR) & s__destination(V__T,V__CC) & s__objectTransferred(V__T,V__F) & s__path(V__T,V__PCVV)))') ) ) ).

fof(kb_SUMO_1203,axiom,
    s__subclass(s__Lever,s__Device) ).

fof(kb_SUMO_1204,axiom,
    s__termFormat(s__EnglishLanguage,s__Lever,lever) ).

fof(kb_SUMO_1205,axiom,
    s__documentation(s__Lever,s__EnglishLanguage,'Anything which is actually used as a lever, since many things can be used as such, regardless of the intent during their &%Manufacture. A lever necessarily has a &%Fulcrum around which the lever exhibits &%Rotating. A lever has a mechanical advantage at the point of output compared to the point of input of force.') ).

fof(kb_SUMO_1206,axiom,
    s__externalImage(s__Lever,'http://upload.wikimedia.org/wikipedia/commons/thumb/f/f2/Palanca-ejemplo.jpg/800px-Palanca-ejemplo.jpg') ).

fof(kb_SUMO_1207,axiom,
    ! [V__L] :
      ( s__instance(V__L,s__Object)
     => ( s__instance(V__L,s__Lever)
       => ? [V__A] :
            ( s__instance(V__A,s__Object)
            & s__axis(V__A,V__L) ) ) ) ).

%FOL fof(kb_SUMO_1208,axiom,(( (! [V__M1,V__P,V__D1,V__P2,V__D2,V__P1,V__P4,V__P3,V__E2,V__L,V__E1] : ((s__instance(V__E1,s__Object) & s__instance(V__L,s__Object) & s__instance(V__E2,s__Object) & s__instance(V__P3,s__Object) & s__instance(V__P4,s__Object) & s__instance(V__P1,s__Object) & s__instance(V__D2,s__LengthMeasure) & s__instance(V__P2,s__Object) & s__instance(V__D1,s__LengthMeasure) & s__instance(V__P,s__Process) & s__instance(V__M1,s__Physical)) => ((s__instance(V__L,s__Lever) & s__instance(V__P,s__Pushing) & s__instance(V__M1,s__Motion) & s__destination(V__P,V__E1) & s__physicalEnd(V__E1,V__L) & s__physicalEnd(V__E2,V__L) & (~ (V__E1 = V__E2)) & s__holdsDuring(s__ImmediatePastFn(s__WhenFn(V__M1)),'s__located(V__E1,V__P1)') & s__holdsDuring(s__ImmediateFutureFn(s__WhenFn(V__M1)),'s__located(V__E1,V__P2)') & s__holdsDuring(s__ImmediatePastFn(s__WhenFn(V__M1)),'s__located(V__E2,V__P3)') & s__holdsDuring(s__ImmediateFutureFn(s__WhenFn(V__M1)),'s__located(V__E2,V__P4)') & s__distance(V__P1,V__P2,V__D1) & s__distance(V__P3,V__P4,V__D2)) => greater(V__D2,V__D1)))) ))).

fof(kb_SUMO_1209,axiom,
    s__subclass(s__RockerArm,s__Device) ).

fof(kb_SUMO_1210,axiom,
    s__instance(s__RockerArm__t,s__SetOrClass) ).

fof(kb_SUMO_1211,axiom,
    s__termFormat(s__EnglishLanguage,s__RockerArm,'A &%Device located in the &%Cylinder head of a &%FourStrokeEngine that opens a &%Valve. It is typically activated by contact from a &%Cam on the &%Camshaft.') ).

fof(kb_SUMO_1212,axiom,
    s__typicalPart(s__RockerArm,s__FourStrokeEngine) ).

fof(kb_SUMO_1213,axiom,
    s__typicallyContainsPart(s__RockerArm,s__FourStrokeEngine) ).

fof(kb_SUMO_1214,axiom,
    ! [V__RA] :
      ( s__instance(V__RA,s__Object)
     => ( s__instance(V__RA,s__RockerArm)
       => s__hasPurpose(V__RA,'(? [V__P1,V__C,V__P2,V__V,V__O,V__FSE] : (s__instance(V__FSE,s__Object) & s__instance(V__O,s__Process) & s__instance(V__V,s__Object) & s__instance(V__P2,s__Process) & s__instance(V__C,s__Object) & s__instance(V__P1,s__Process) & s__instance(V__P1,s__Pushing) & s__instance(V__C,s__Cam) & s__instance(V__P2,s__Pushing) & s__instance(V__V,s__Valve) & s__instance(V__O,s__Opening) & s__instance(V__FSE,s__FourStrokeEngine) & s__part(V__RA,V__FSE) & s__part(V__C,V__FSE) & s__part(V__V,V__FSE) & s__instrument(V__P1,V__C) & s__destination(V__P1,V__RA) & s__instrument(V__P2,V__RA) & s__destination(V__P2,V__V) & s__causes(V__P1,V__P2) & s__causes(V__P2,V__O) & s__patient(V__O,V__V)))') ) ) ).

fof(kb_SUMO_1215,axiom,
    s__subclass(s__Magnet,s__Object) ).

fof(kb_SUMO_1216,axiom,
    s__termFormat(s__EnglishLanguage,s__Magnet,magnet) ).

fof(kb_SUMO_1217,axiom,
    s__documentation(s__Magnet,s__EnglishLanguage,'Any object that emits &%Magnetism. Note that this includes both &%NaturalMagnets and &%Electromagnets and therefore the most specific superclass is &%Object, since natural magnets are divisible &%Substances and electromagnets are &%CorpuscularObjects.') ).

fof(kb_SUMO_1218,axiom,
    ! [V__M] :
      ( s__instance(V__M,s__Object)
     => ( s__instance(V__M,s__Magnet)
       => ? [V__MAG] :
            ( s__instance(V__MAG,s__Process)
            & s__instance(V__MAG,s__Magnetism)
            & s__instrument(V__MAG,V__M) ) ) ) ).

fof(kb_SUMO_1219,axiom,
    s__subclass(s__NaturalMagnet,s__Magnet) ).

fof(kb_SUMO_1220,axiom,
    s__instance(s__NaturalMagnet__t,s__SetOrClass) ).

fof(kb_SUMO_1221,axiom,
    s__instance(s__Magnet__t,s__SetOrClass) ).

fof(kb_SUMO_1222,axiom,
    s__subclass(s__NaturalMagnet,s__NaturalSubstance) ).

fof(kb_SUMO_1223,axiom,
    s__termFormat(s__EnglishLanguage,s__NaturalMagnet,magnet) ).

fof(kb_SUMO_1224,axiom,
    s__documentation(s__NaturalMagnet,s__EnglishLanguage,'Any &%Substance from nature that exhibits &%Magnetism.') ).

fof(kb_SUMO_1225,axiom,
    s__subclass(s__Electromagnet,s__Magnet) ).

fof(kb_SUMO_1226,axiom,
    s__instance(s__Electromagnet__t,s__SetOrClass) ).

fof(kb_SUMO_1227,axiom,
    s__subclass(s__Electromagnet,s__ElectricDevice) ).

fof(kb_SUMO_1228,axiom,
    s__termFormat(s__EnglishLanguage,s__Electromagnet,electromagnet) ).

fof(kb_SUMO_1229,axiom,
    s__documentation(s__Electromagnet,s__EnglishLanguage,'A &%Magnet that is created by sending &%Electricity through coils of &%Wire that are wound around a ferromagnetic core.') ).

fof(kb_SUMO_1230,axiom,
    ! [V__EM,V__T,V__E] :
      ( ( s__instance(V__E,s__Object)
        & s__instance(V__EM,s__Object) )
     => ( ( s__instance(V__EM,s__Electromagnet)
          & s__instance(V__T,s__Transfer)
          & s__instance(V__E,s__Electricity)
          & s__objectTransferred(V__T,V__E)
          & s__path(V__T,V__EM) )
       => ? [V__M] :
            ( s__instance(V__M,s__Process)
            & s__instance(V__M,s__Magnetism)
            & s__instrument(V__M,V__EM) ) ) ) ).

fof(kb_SUMO_1231,axiom,
    ! [V__EM,V__T1] :
      ( ( s__instance(V__T1,s__TimePosition)
        & s__instance(V__EM,s__Object) )
     => ( ( s__instance(V__EM,s__Electromagnet)
          & ~ s__holdsDuring(V__T1,'(? [V__T,V__E] : (s__instance(V__E,s__Object) & s__instance(V__T,s__Transfer) & s__instance(V__E,s__Electricity) & s__objectTransferred(V__T,V__E) & s__path(V__T,V__EM)))') )
       => ~ s__holdsDuring(V__T1,'(? [V__M] : (s__instance(V__M,s__Process) & s__instance(V__M,s__Magnetism) & s__instrument(V__M,V__EM)))') ) ) ).

fof(kb_SUMO_1232,axiom,
    s__subclass(s__Solenoid,s__ElectricDevice) ).

fof(kb_SUMO_1233,axiom,
    s__instance(s__Solenoid__t,s__SetOrClass) ).

fof(kb_SUMO_1234,axiom,
    s__termFormat(s__EnglishLanguage,s__Solenoid,solenoid) ).

fof(kb_SUMO_1235,axiom,
    s__documentation(s__Solenoid,s__EnglishLanguage,'A &%Device that uses an &%Electromagnet to actuate an arm or shaft to perform some function.') ).

fof(kb_SUMO_1236,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__instance(V__S,s__Solenoid)
       => s__hasPurpose(V__S,'(? [V__P,V__T1,V__T2,V__L1,V__L2] : (s__instance(V__L2,s__Object) & s__instance(V__L1,s__Object) & s__instance(V__T2,s__TimePosition) & s__instance(V__T1,s__TimePosition) & s__instance(V__P,s__Object) & s__part(V__P,V__S) & s__holdsDuring(V__T1,(s__attribute(V__S,s__DeviceOn) & s__located(V__P,V__L1))) & s__holdsDuring(V__T2,(s__attribute(V__S,s__DeviceOn) & s__located(V__P,V__L2))) & (~ (V__L1 = V__L2))))') ) ) ).

fof(kb_SUMO_1237,axiom,
    s__subclass(s__StarterMotor,s__Motor) ).

fof(kb_SUMO_1238,axiom,
    s__instance(s__StarterMotor__t,s__SetOrClass) ).

fof(kb_SUMO_1239,axiom,
    s__instance(s__Motor__t,s__SetOrClass) ).

fof(kb_SUMO_1240,axiom,
    s__termFormat(s__EnglishLanguage,s__StarterMotor,'starter motor') ).

fof(kb_SUMO_1241,axiom,
    s__documentation(s__StarterMotor,s__EnglishLanguage,'Any &%Motor that has the intended use of starting an &%IntermittentCombustionEngine. In most &%Automobiles it is a small electric motor, but in a diesel heavy equipment engine there may be an electric motor that starts a gas engine that in turn starts the diesel engine.') ).

fof(kb_SUMO_1242,axiom,
    ! [V__SM] :
      ( s__instance(V__SM,s__Object)
     => ( s__instance(V__SM,s__StarterMotor)
       => s__hasPurpose(V__SM,'(? [V__P1,V__P2,V__ICE] : (s__instance(V__ICE,s__Object) & s__instance(V__P2,s__Process) & s__instance(V__P1,s__Process) & s__instance(V__ICE,s__InternalCombustionEngine) & s__instrument(V__P1,V__SM) & s__instrument(V__P2,V__ICE) & s__causes(V__P1,V__P2)))') ) ) ).

fof(kb_SUMO_1243,axiom,
    s__subclass(s__SteeringBox,s__Gearbox) ).

fof(kb_SUMO_1244,axiom,
    s__instance(s__SteeringBox__t,s__SetOrClass) ).

fof(kb_SUMO_1245,axiom,
    s__termFormat(s__EnglishLanguage,s__SteeringBox,'steering box') ).

fof(kb_SUMO_1246,axiom,
    s__documentation(s__SteeringBox,s__EnglishLanguage,'A &%Gearbox at the end of the &%SteeringColumn that transmits &%Motion to the &%SteeringArms.') ).

fof(kb_SUMO_1247,axiom,
    s__typicalPart(s__SteeringBox,s__Automobile) ).

fof(kb_SUMO_1248,axiom,
    s__typicallyContainsPart(s__SteeringBox,s__Automobile) ).

fof(kb_SUMO_1249,axiom,
    ! [V__SB] :
      ( s__instance(V__SB,s__EngineeringComponent)
     => ( s__instance(V__SB,s__SteeringBox)
       => s__hasPurpose(V__SB,'(? [V__SW,V__SC] : (s__instance(V__SC,s__EngineeringComponent) & s__instance(V__SW,s__EngineeringComponent) & s__instance(V__SW,s__SteeringWheel) & s__instance(V__SC,s__SteeringColumn) & s__connectedEngineeringComponents(V__SW,V__SC) & s__connectedEngineeringComponents(V__SC,V__SB)))') ) ) ).

fof(kb_SUMO_1250,axiom,
    s__subclass(s__SteeringColumn,s__Shaft) ).

fof(kb_SUMO_1251,axiom,
    s__instance(s__SteeringColumn__t,s__SetOrClass) ).

fof(kb_SUMO_1252,axiom,
    s__termFormat(s__EnglishLanguage,s__SteeringColumn,'steering column') ).

fof(kb_SUMO_1253,axiom,
    s__documentation(s__SteeringColumn,s__EnglishLanguage,'A &%Shaft that connects the &%SteeringWheel of an &%Automobile to the &%SteeringBox.') ).

fof(kb_SUMO_1254,axiom,
    s__typicalPart(s__SteeringColumn,s__Automobile) ).

fof(kb_SUMO_1255,axiom,
    s__typicallyContainsPart(s__SteeringColumn,s__Automobile) ).

fof(kb_SUMO_1256,axiom,
    s__termFormat(s__EnglishLanguage,s__SteeringWheel,'steering wheel') ).

fof(kb_SUMO_1257,axiom,
    s__typicalPart(s__SteeringWheel,s__Automobile) ).

fof(kb_SUMO_1258,axiom,
    s__typicallyContainsPart(s__SteeringWheel,s__Automobile) ).

fof(kb_SUMO_1259,axiom,
    s__subclass(s__Tachometer,s__MeasuringDevice) ).

fof(kb_SUMO_1260,axiom,
    s__instance(s__Tachometer__t,s__SetOrClass) ).

fof(kb_SUMO_1261,axiom,
    s__termFormat(s__EnglishLanguage,s__Tachometer,tachometer) ).

fof(kb_SUMO_1262,axiom,
    s__documentation(s__Tachometer,s__EnglishLanguage,'A &%Device for &%Measuring the number of &%RevolutionsPerMinute of an object, typically an &%Engine &%Crankshaft.') ).

fof(kb_SUMO_1263,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Tachometer)
       => s__hasPurpose(V__T,'(? [V__R,V__M,V__O] : (s__instance(V__M,s__Process) & s__instance(V__R,s__Process) & s__instance(V__R,s__Rotating) & s__patient(V__R,V__O) & s__instance(V__M,s__Measuring) & s__instrument(V__M,V__T) & s__patient(V__M,V__O)))') ) ) ).

fof(kb_SUMO_1264,axiom,
    s__documentation(s__beforeOnPath__m,s__EnglishLanguage,'(beforeOnPath ?OBJ1 ?OBJ2 ?PATH ?PROC) means that ?OBJ1 is spatially before ?OBJ2 on the path ?PATH with respect to a particular &%Transfer &%Process.') ).

fof(kb_SUMO_1265,axiom,
    s__domain(s__beforeOnPath__m,"1",s__Object) ).

fof(kb_SUMO_1266,axiom,
    s__domain(s__beforeOnPath__m,"2",s__Object) ).

fof(kb_SUMO_1267,axiom,
    s__domain(s__beforeOnPath__m,"3",s__Object) ).

fof(kb_SUMO_1268,axiom,
    s__domain(s__beforeOnPath__m,"4",s__Transfer) ).

fof(kb_SUMO_1269,axiom,
    s__instance(s__beforeOnPath__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_1270,axiom,
    s__instance(s__beforeOnPath__m,s__SpatialRelation) ).

fof(kb_SUMO_1271,axiom,
    s__instance(s__beforeOnPath__m,s__TransitiveRelation) ).

fof(kb_SUMO_1272,axiom,
    s__format(s__EnglishLanguage,s__beforeOnPath__m,'%1 %n before %2 on path %3 during %4') ).

fof(kb_SUMO_1273,axiom,
    s__termFormat(s__EnglishLanguage,s__betweenOnPath__m,'before on path') ).

fof(kb_SUMO_1274,axiom,
    s__subclass(s__Tailpipe,s__Tube) ).

fof(kb_SUMO_1275,axiom,
    s__instance(s__Tailpipe__t,s__SetOrClass) ).

fof(kb_SUMO_1276,axiom,
    s__typicalPart(s__Tailpipe,s__AutomobileExhaustSystem) ).

fof(kb_SUMO_1277,axiom,
    s__typicallyContainsPart(s__Tailpipe,s__AutomobileExhaustSystem) ).

fof(kb_SUMO_1278,axiom,
    s__termFormat(s__EnglishLanguage,s__Tailpipe,tailpipe) ).

fof(kb_SUMO_1279,axiom,
    s__documentation(s__Tailpipe,s__EnglishLanguage,'Typically the last portion of an AutomobileExhaustSystem, which is after the &%Muffler, just before &%Engine &%Exhaust is vented to the surrounding &%Air.') ).

fof(kb_SUMO_1280,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__EngineeringComponent)
     => ( s__instance(V__T,s__Tailpipe)
       => s__hasPurpose(V__T,'(? [V__M] : (s__instance(V__M,s__EngineeringComponent) & s__instance(V__M,s__Muffler) & s__connectedEngineeringComponents(V__M,V__T)))') ) ) ).

fof(kb_SUMO_1281,axiom,
    s__subclass(s__BimetalTemperatureSensor,s__MeasuringDevice) ).

fof(kb_SUMO_1282,axiom,
    s__instance(s__BimetalTemperatureSensor__t,s__SetOrClass) ).

fof(kb_SUMO_1283,axiom,
    s__termFormat(s__EnglishLanguage,s__BimetalTemperatureSensor,'bi-metal temperature sensor') ).

fof(kb_SUMO_1284,axiom,
    s__documentation(s__BimetalTemperatureSensor,s__EnglishLanguage,'Two metals bonded together that have dissimilar thermal expansion properties. This leads to the strip curling one direction or another with changes in &%TemperatureMeasure, typically activating a switch or other device.') ).

fof(kb_SUMO_1285,axiom,
    ! [V__BTS] :
      ( s__instance(V__BTS,s__Object)
     => ( s__instance(V__BTS,s__BimetalTemperatureSensor)
       => ? [V__M1,V__M2] :
            ( s__instance(V__M2,s__Object)
            & s__instance(V__M1,s__Object)
            & s__instance(V__M1,s__Metal)
            & s__instance(V__M2,s__Metal)
            & s__part(V__M1,V__BTS)
            & s__part(V__M2,V__BTS)
            & V__M1 != V__M2 ) ) ) ).

fof(kb_SUMO_1286,axiom,
    ! [V__M1,V__T2,V__T1,V__BTS,V__M2,V__TM2,V__TM1,V__L3,V__L4,V__L1,V__L2] :
      ( ( s__instance(V__L2,s__PhysicalQuantity)
        & s__instance(V__L1,s__PhysicalQuantity)
        & s__instance(V__L4,s__PhysicalQuantity)
        & s__instance(V__L3,s__PhysicalQuantity)
        & s__instance(V__TM1,s__TimePosition)
        & s__instance(V__TM2,s__TimePosition)
        & s__instance(V__M2,s__Object)
        & s__instance(V__BTS,s__Object)
        & s__instance(V__T1,s__PhysicalQuantity)
        & s__instance(V__T2,s__PhysicalQuantity)
        & s__instance(V__M1,s__Object) )
     => ( ( s__instance(V__BTS,s__BimetalTemperatureSensor)
          & s__instance(V__M1,s__Metal)
          & s__instance(V__M2,s__Metal)
          & V__M1 != V__M2
          & s__part(V__M1,V__BTS)
          & s__part(V__M2,V__BTS)
          & s__instance(V__T1,s__TemperatureMeasure)
          & s__instance(V__T2,s__TemperatureMeasure)
          & s__instance(V__L1,s__LengthMeasure)
          & s__instance(V__L2,s__LengthMeasure)
          & s__instance(V__L3,s__LengthMeasure)
          & s__instance(V__L4,s__LengthMeasure)
          & V__T1 != V__T2
          & s__holdsDuring(V__TM1,'(s__measure(V__BTS,V__T1) & s__measure(V__M1,V__L1) & s__measure(V__M2,V__L2))')
          & s__holdsDuring(V__TM2,'(s__measure(V__BTS,V__T2) & s__measure(V__M1,V__L3) & s__measure(V__M2,V__L4))') )
       => divide(V__L1,V__L2) != divide(V__L3,V__L4) ) ) ).

fof(kb_SUMO_1287,axiom,
    s__instance(s__physicalEnd__m,s__BinaryPredicate) ).

fof(kb_SUMO_1288,axiom,
    s__subrelation(s__physicalEnd__m,s__properPart__m) ).

fof(kb_SUMO_1289,axiom,
    s__format(s__EnglishLanguage,s__physicalEnd__m,'one end of %2 is %1') ).

fof(kb_SUMO_1290,axiom,
    s__documentation(s__physicalEnd__m,s__EnglishLanguage,'A notion of an indeterminate portion at the end of an &%Object that has a &%LongAndThin &%ShapeAttribute.') ).

fof(kb_SUMO_1291,axiom,
    s__domain(s__physicalEnd__m,"1",s__Object) ).

fof(kb_SUMO_1292,axiom,
    s__domain(s__physicalEnd__m,"2",s__Object) ).

fof(kb_SUMO_1293,axiom,
    ! [V__O,V__E] :
      ( ( s__instance(V__E,s__Object)
        & s__instance(V__O,s__Object) )
     => ( s__physicalEnd(V__E,V__O)
       => s__attribute(V__O,s__LongAndThin) ) ) ).

fof(kb_SUMO_1294,axiom,
    ! [V__O,V__E] :
      ( ( s__instance(V__E,s__Object)
        & s__instance(V__O,s__Object) )
     => ( s__physicalEnd(V__E,V__O)
       => ~ s__attribute(V__E,s__LongAndThin) ) ) ).

fof(kb_SUMO_1295,axiom,
    ! [V__O,V__E2,V__E1] :
      ( ( s__instance(V__E1,s__Object)
        & s__instance(V__E2,s__Object)
        & s__instance(V__O,s__Object) )
     => ( ( s__physicalEnd(V__E1,V__O)
          & s__physicalEnd(V__E2,V__O)
          & V__E1 != V__E2 )
       => ~ s__overlapsSpatially(V__E1,V__E2) ) ) ).

fof(kb_SUMO_1296,axiom,
    ! [V__O,V__E2,V__E1] :
      ( ( s__instance(V__E1,s__Object)
        & s__instance(V__E2,s__Object)
        & s__instance(V__O,s__Object) )
     => ( ( s__physicalEnd(V__E1,V__O)
          & s__physicalEnd(V__E2,V__O)
          & V__E1 != V__E2 )
       => ~ s__meetsSpatially(V__E1,V__E2) ) ) ).

fof(kb_SUMO_1297,axiom,
    ! [V__O,V__SP,V__E] :
      ( ( s__instance(V__E,s__Object)
        & s__instance(V__SP,s__Object)
        & s__instance(V__O,s__Object) )
     => ( ( s__physicalEnd(V__E,V__O)
          & s__superficialPart(V__SP,V__O) )
       => s__meetsSpatially(V__E,V__SP) ) ) ).

fof(kb_SUMO_1298,axiom,
    ! [V__O,V__D1,V__P2,V__P1,V__E2,V__E1] :
      ( ( s__instance(V__E1,s__Object)
        & s__instance(V__E2,s__Object)
        & s__instance(V__P1,s__Object)
        & s__instance(V__P2,s__Object)
        & s__instance(V__D1,s__LengthMeasure)
        & s__instance(V__O,s__Object) )
     => ( ( s__physicalEnd(V__E1,V__O)
          & s__physicalEnd(V__E2,V__O)
          & s__part(V__P1,V__E1)
          & s__part(V__P2,V__E2)
          & s__distance(V__P1,V__P2,V__D1)
          & V__E1 != V__E2 )
       => ~ ? [V__OP1,V__OP2,V__D2] :
              ( s__instance(V__D2,s__LengthMeasure)
              & s__instance(V__OP2,s__Object)
              & s__instance(V__OP1,s__Object)
              & ~ s__part(V__OP1,V__E1)
              & ~ s__part(V__OP2,V__E2)
              & s__distance(V__OP1,V__OP2,V__D2)
              & greater(V__D2,V__D1) ) ) ) ).

fof(kb_SUMO_1299,axiom,
    s__subclass(s__Rod,s__Device) ).

fof(kb_SUMO_1300,axiom,
    s__instance(s__Rod__t,s__SetOrClass) ).

fof(kb_SUMO_1301,axiom,
    s__termFormat(s__EnglishLanguage,s__Rod,rod) ).

fof(kb_SUMO_1302,axiom,
    s__documentation(s__Rod,s__EnglishLanguage,'Any &%LongAndThin object that has some structural function in another &%Device.') ).

fof(kb_SUMO_1303,axiom,
    ! [V__R] :
      ( s__instance(V__R,s__EngineeringComponent)
     => ( s__instance(V__R,s__Rod)
       => s__hasPurpose(V__R,'(? [V__D] : (s__instance(V__D,s__EngineeringComponent) & s__connectedEngineeringComponents(V__R,V__D)))') ) ) ).

fof(kb_SUMO_1304,axiom,
    ! [V__R] :
      ( s__instance(V__R,s__Object)
     => ( s__instance(V__R,s__Rod)
       => s__attribute(V__R,s__LongAndThin) ) ) ).

fof(kb_SUMO_1305,axiom,
    s__subclass(s__TieRod,s__Rod) ).

fof(kb_SUMO_1306,axiom,
    s__instance(s__TieRod__t,s__SetOrClass) ).

fof(kb_SUMO_1307,axiom,
    s__externalImage(s__TieRod,'http://img217.imageshack.us/img217/5804/4tierodremovalop3.jpg') ).

fof(kb_SUMO_1308,axiom,
    s__termFormat(s__EnglishLanguage,s__TieRod,'tie rod') ).

fof(kb_SUMO_1309,axiom,
    s__documentation(s__TieRod,s__EnglishLanguage,'A &%Rod in an &%Automobile that serves to link the steering system to the &%Wheels. A tie rod is distinct from many other types of rods in that it functions in both compression and tension forces.') ).

fof(kb_SUMO_1310,axiom,
    s__typicalPart(s__TieRod,s__Automobile) ).

fof(kb_SUMO_1311,axiom,
    s__typicallyContainsPart(s__TieRod,s__Automobile) ).

fof(kb_SUMO_1312,axiom,
    s__subclass(s__TorqueWrench,s__MeasuringDevice) ).

fof(kb_SUMO_1313,axiom,
    s__instance(s__TorqueWrench__t,s__SetOrClass) ).

fof(kb_SUMO_1314,axiom,
    s__subclass(s__TorqueWrench,s__Wrench) ).

fof(kb_SUMO_1315,axiom,
    s__termFormat(s__EnglishLanguage,s__TorqueWrench,'torque wrench') ).

fof(kb_SUMO_1316,axiom,
    s__documentation(s__TorqueWrench,s__EnglishLanguage,'A &%Wrench that measures the amount of force applied, typically in pound-feet or Newton-meters.') ).

fof(kb_SUMO_1317,axiom,
    s__subclass(s__Wrench,s__Device) ).

fof(kb_SUMO_1318,axiom,
    s__instance(s__Wrench__t,s__SetOrClass) ).

fof(kb_SUMO_1319,axiom,
    s__termFormat(s__EnglishLanguage,s__Wrench,wrench) ).

fof(kb_SUMO_1320,axiom,
    s__documentation(s__Wrench,s__EnglishLanguage,'A &%Device that is designed to apply a rotational force to an &%AttachingDevice, such as a &%Bolt.') ).

fof(kb_SUMO_1321,axiom,
    ! [V__W] :
      ( s__instance(V__W,s__Object)
     => ( s__instance(V__W,s__Wrench)
       => s__hasPurpose(V__W,'(? [V__R,V__AD] : (s__instance(V__R,s__Process) & s__instance(V__R,s__Rotating) & s__instance(V__AD,s__AttachingDevice) & s__patient(V__R,V__AD) & s__instrument(V__R,V__W)))') ) ) ).

fof(kb_SUMO_1322,axiom,
    s__subclass(s__Bolt,s__AttachingDevice) ).

fof(kb_SUMO_1323,axiom,
    s__instance(s__Bolt__t,s__SetOrClass) ).

fof(kb_SUMO_1324,axiom,
    s__termFormat(s__EnglishLanguage,s__Bolt,bolt) ).

fof(kb_SUMO_1325,axiom,
    s__documentation(s__Bolt,s__EnglishLanguage,'Any &%AttachingDevice that is designed to mate with a &%MechanicalNut thereby &%Attaching two &%Objects. This includes nuts with hexagonal heads that must be held or turned by a &%Wrench or &%Screwdriver as well as those that have round heads but some non-round feature that is designed to catch on the material being attached, and therefore prevent rotation, as in a carriage bolt. Bolts are distinguished from &%Screws in that screws must create a mating surface by gouging a thread into material, whereas bolts are designed to slip through a hole and are held in place by a nut at the opposite end from the head of the bolt. This includes threaded rods that may have nuts as spacers for freely rotating items.') ).

fof(kb_SUMO_1326,axiom,
    ! [V__B] :
      ( s__instance(V__B,s__Object)
     => ( s__instance(V__B,s__Bolt)
       => s__hasPurpose(V__B,'(? [V__A,V__N] : (s__instance(V__N,s__Object) & s__instance(V__A,s__Process) & s__instance(V__A,s__Attaching) & s__instance(V__N,s__Nut) & s__instrument(V__A,V__B) & s__instrument(V__A,V__N)))') ) ) ).

fof(kb_SUMO_1327,axiom,
    s__subclass(s__MechanicalNut,s__AttachingDevice) ).

fof(kb_SUMO_1328,axiom,
    s__instance(s__MechanicalNut__t,s__SetOrClass) ).

fof(kb_SUMO_1329,axiom,
    s__termFormat(s__EnglishLanguage,s__MechanicalNut,nut) ).

fof(kb_SUMO_1330,axiom,
    s__documentation(s__MechanicalNut,s__EnglishLanguage,'Any object with threads designed to mate with those of a &%Bolt. This includes any large object with a region that functions as a nut. However, it does not include regions of objects where a screw has created a threaded area and where typically therefore the material is soft enough that retracting and reinserting a screw may create a different thread pattern. This can also be contrasted with regions that are created to be nuts by the use of a &%MechanicalTap and &%MechanicalDie set.') ).

fof(kb_SUMO_1331,axiom,
    ! [V__B,V__N] :
      ( ( s__instance(V__N,s__Object)
        & s__instance(V__B,s__Physical) )
     => ( s__instance(V__N,s__Nut)
       => s__hasPurpose(V__B,'(? [V__A,V__B] : (s__instance(V__B,s__Object) & s__instance(V__A,s__Process) & s__instance(V__A,s__Attaching) & s__instance(V__B,s__Bolt) & s__instrument(V__A,V__B) & s__instrument(V__A,V__N)))') ) ) ).

fof(kb_SUMO_1332,axiom,
    s__subclass(s__WasherForBolt,s__Device) ).

fof(kb_SUMO_1333,axiom,
    s__instance(s__WasherForBolt__t,s__SetOrClass) ).

fof(kb_SUMO_1334,axiom,
    s__termFormat(s__EnglishLanguage,s__WasherForBolt,washer) ).

fof(kb_SUMO_1335,axiom,
    s__documentation(s__WasherForBolt,s__EnglishLanguage,'A durable material in the shape of a &%Circle with a &%Hole in it, designed to isolate an object fixed by the &%Bolt from the head of the bolt or from contact with a &%MechanicalNut.') ).

fof(kb_SUMO_1336,axiom,
    ! [V__W] :
      ( s__instance(V__W,s__SelfConnectedObject)
     => ( s__instance(V__W,s__WasherForBolt)
       => s__hasPurpose(V__W,'(? [V__B] : (s__instance(V__B,s__Object) & s__instance(V__B,s__Bolt) & s__contains(V__W,V__B)))') ) ) ).

fof(kb_SUMO_1337,axiom,
    ! [V__W] :
      ( s__instance(V__W,s__WasherForBolt)
     => ? [V__H] :
          ( s__instance(V__H,s__Hole)
          & V__W = s__HoleHostFn(V__H) ) ) ).

fof(kb_SUMO_1338,axiom,
    ! [V__W] :
      ( s__instance(V__W,s__Object)
     => ( s__instance(V__W,s__WasherForBolt)
       => s__attribute(V__W,s__Circle) ) ) ).

fof(kb_SUMO_1339,axiom,
    s__subclass(s__MechanicalTap,s__Device) ).

fof(kb_SUMO_1340,axiom,
    s__instance(s__MechanicalTap__t,s__SetOrClass) ).

fof(kb_SUMO_1341,axiom,
    s__termFormat(s__EnglishLanguage,s__MechanicalTap,tap) ).

fof(kb_SUMO_1342,axiom,
    s__documentation(s__MechanicalDie,s__EnglishLanguage,'A &%Device for creating a &%Bolt out of a piece of metal (or other hard material) with a &%Hole in it.') ).

fof(kb_SUMO_1343,axiom,
    ! [V__MT] :
      ( s__instance(V__MT,s__Object)
     => ( s__instance(V__MT,s__MechanicalTap)
       => s__hasPurpose(V__MT,'(? [V__M,V__B] : (s__instance(V__M,s__Process) & s__instance(V__M,s__Making) & s__instance(V__B,s__Bolt) & s__instrument(V__M,V__MT) & s__result(V__M,V__B)))') ) ) ).

fof(kb_SUMO_1344,axiom,
    s__subclass(s__MechanicalDie,s__Device) ).

fof(kb_SUMO_1345,axiom,
    s__instance(s__MechanicalDie__t,s__SetOrClass) ).

fof(kb_SUMO_1346,axiom,
    s__termFormat(s__EnglishLanguage,s__MechanicalDie,die) ).

fof(kb_SUMO_1347,axiom,
    s__documentation(s__MechanicalDie,s__EnglishLanguage,'A &%Device for creating a &%MechanicalNut out of a &%Rod.') ).

fof(kb_SUMO_1348,axiom,
    ! [V__MT] :
      ( s__instance(V__MT,s__Object)
     => ( s__instance(V__MT,s__MechanicalDie)
       => s__hasPurpose(V__MT,'(? [V__M,V__N] : (s__instance(V__M,s__Process) & s__instance(V__M,s__Making) & s__instance(V__N,s__MechanicalNut) & s__instrument(V__M,V__MT) & s__result(V__M,V__N)))') ) ) ).

fof(kb_SUMO_1349,axiom,
    s__subclass(s__UniversalJoint,s__MechanicalJoint) ).

fof(kb_SUMO_1350,axiom,
    s__instance(s__UniversalJoint__t,s__SetOrClass) ).

fof(kb_SUMO_1351,axiom,
    s__externalImage(s__UniversalJoint,'http://upload.wikimedia.org/wikipedia/commons/b/b5/Universal_joint.gif') ).

fof(kb_SUMO_1352,axiom,
    s__termFormat(s__EnglishLanguage,s__UniversalJoint,'universal joint') ).

fof(kb_SUMO_1353,axiom,
    s__documentation(s__UniversalJoint,s__EnglishLanguage,'A joint that couples two shafts at variables angles to one another. It is distinct from a &%CVJoint in that the shafts do not travel at a constant velocity with respect to one another. This causes vibration and wear. However, universal joints are simpler to make than CV joints.') ).

fof(kb_SUMO_1354,axiom,
    s__subclass(s__VacuumGauge,s__MeasuringDevice) ).

fof(kb_SUMO_1355,axiom,
    s__instance(s__VacuumGauge__t,s__SetOrClass) ).

fof(kb_SUMO_1356,axiom,
    s__termFormat(s__EnglishLanguage,s__VacuumGauge,'vacuum gauge') ).

fof(kb_SUMO_1357,axiom,
    s__documentation(s__VacuumGauge,s__EnglishLanguage,'A &%MeasuringDevice that measures the degree of &%Vacuum, relative to the surrounding air pressure.') ).

fof(kb_SUMO_1358,axiom,
    s__subclass(s__VacuumHose,s__Hose) ).

fof(kb_SUMO_1359,axiom,
    s__instance(s__VacuumHose__t,s__SetOrClass) ).

fof(kb_SUMO_1360,axiom,
    s__instance(s__Hose__t,s__SetOrClass) ).

fof(kb_SUMO_1361,axiom,
    s__termFormat(s__EnglishLanguage,s__VacuumHose,'vacuum hose') ).

fof(kb_SUMO_1362,axiom,
    s__documentation(s__VacuumHose,s__EnglishLanguage,'A &%Hose, typically found in modern &%Automobiles that link one area of &%PartialVacuum to another.') ).

fof(kb_SUMO_1363,axiom,
    ! [V__VH] :
      ( s__instance(V__VH,s__Physical)
     => ( s__instance(V__VH,s__VacuumHose)
       => s__hasPurpose(V__VH,'(? [V__H] : (s__instance(V__H,s__Hole) & (V__VH = s__HoleHostFn(V__H)) & s__attribute(V__H,s__PartialVacuum)))') ) ) ).

fof(kb_SUMO_1364,axiom,
    s__subclass(s__Hose,s__Tube) ).

fof(kb_SUMO_1365,axiom,
    s__termFormat(s__EnglishLanguage,s__Hose,hose) ).

fof(kb_SUMO_1366,axiom,
    s__documentation(s__Hose,s__EnglishLanguage,'A &%Tube that is &%Pliable. Note however that it may not be pliable outside its intended operating range, such as with a garden hose in freezing weather.') ).

%FOL fof(kb_SUMO_1367,axiom,(( (! [V__H] : (s__instance(V__H,s__Object) => (s__instance(V__H,s__Hose) => s__hasPurpose(V__H,'s__attribute(V__H,s__Pliable)')))) ))).

fof(kb_SUMO_1368,axiom,
    s__subclass(s__WheelChock,s__Device) ).

fof(kb_SUMO_1369,axiom,
    s__instance(s__WheelChock__t,s__SetOrClass) ).

fof(kb_SUMO_1370,axiom,
    s__termFormat(s__EnglishLanguage,s__WheelChock,'wheel chock') ).

fof(kb_SUMO_1371,axiom,
    s__documentation(s__WheelChock,s__EnglishLanguage,'A &%Device that is designed to keep a &%Vehicles &%Wheels, and thus the vehicle itself, from moving.') ).

fof(kb_SUMO_1372,axiom,
    ! [V__T,V__WC] :
      ( ( s__instance(V__WC,s__Object)
        & s__instance(V__T,s__TimePosition) )
     => ( s__instance(V__WC,s__WheelChock)
       => s__hasPurpose(V__WC,'(? [V__W] : (s__instance(V__W,s__Wheel) & s__holdsDuring(V__T,(s__meetsSpatially(V__WC,V__W) & (~ (? [V__R] : (s__instance(V__R,s__Process) & s__instance(V__W,s__Object) & s__instance(V__R,s__Rotating) & s__patient(V__R,V__W))))))))') ) ) ).

fof(kb_SUMO_1373,axiom,
    s__subclass(s__OutboardEngine,s__Engine) ).

fof(kb_SUMO_1374,axiom,
    s__instance(s__OutboardEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1375,axiom,
    s__documentation(s__OutboardEngine,s__EnglishLanguage,'An outboard motor is a propulsion system for boats, consisting of a self-contained unit that includes engine, gearbox and propeller or jet drive, designed to be affixed to the outside of the transom. They are the most common motorized method of propelling small watercraft. As well as providing propulsion, outboards provide steering control, as they are designed to pivot over their mountings and thus control the direction of thrust. The skeg also acts as a rudder when the engine is not running. Compared to inboard motors, outboard motors can be easily removed for storage or repairs. [from Wikipedia]') ).

fof(kb_SUMO_1376,axiom,
    s__termFormat(s__EnglishLanguage,s__OutboardEngine,'outboard engine') ).

fof(kb_SUMO_1377,axiom,
    s__termFormat(s__EnglishLanguage,s__OutboardEngine,'outboard motor') ).

fof(kb_SUMO_1378,axiom,
    s__externalImage(s__OutboardMotor,'http://upload.wikimedia.org/wikipedia/commons/c/c5/Trim_outboard_engine.jpg') ).

fof(kb_SUMO_1379,axiom,
    ! [V__OE] :
      ( s__instance(V__OE,s__Object)
     => ( s__instance(V__OE,s__OutboardEngine)
       => s__hasPurpose(V__OE,'(? [V__W] : (s__instance(V__W,s__Object) & s__instance(V__W,s__WaterVehicle) & s__meetsSpatially(V__OE,V__W) & s__orientation(V__OE,V__W,s__Outside)))') ) ) ).

fof(kb_SUMO_1380,axiom,
    s__instance(s__CoveringFn__m,s__UnaryFunction) ).

fof(kb_SUMO_1381,axiom,
    s__domainSubclass(s__CoveringFn__m,"1",s__BodyPart) ).

fof(kb_SUMO_1382,axiom,
    s__rangeSubclass(s__CoveringFn__m,s__WearableItem) ).

fof(kb_SUMO_1383,axiom,
    s__documentation(s__CoveringFn__m,s__EnglishLanguage,'A &%Function that produces the class of all things intended to be used in &%Covering a particular &%BodyPart.') ).

fof(kb_SUMO_1384,axiom,
    ! [V__B,V__C] :
      ( ( s__instance(V__C,s__SetOrClass)
        & s__instance(V__C,s__Physical)
        & s__subclass(V__B,s__BodyPart)
        & s__instance(V__B,s__SetOrClass) )
     => ( s__subclass(V__C,s__CoveringFn(V__B))
       => s__hasPurpose(V__C,'(? [V__P,V__BI,V__CI] : (s__instance(V__P,s__Process) & s__instance(V__P,s__Covering) & s__instance(V__BI,V__B) & s__instance(V__CI,V__C) & s__destination(V__P,V__BI) & s__patient(V__P,V__CI)))') ) ) ).

fof(kb_SUMO_1385,axiom,
    s__subclass(s__Helmet,s__SafetyDevice) ).

fof(kb_SUMO_1386,axiom,
    s__instance(s__Helmet__t,s__SetOrClass) ).

fof(kb_SUMO_1387,axiom,
    s__instance(s__SafetyDevice__t,s__SetOrClass) ).

fof(kb_SUMO_1388,axiom,
    s__subclass(s__Helmet,s__CoveringFn(s__Head)) ).

fof(kb_SUMO_1389,axiom,
    s__documentation(s__Helmet,s__EnglishLanguage,'Any &%WearableItem designed to protect the &%Head of the individual who &%wears it.') ).

fof(kb_SUMO_1390,axiom,
    s__subclass(s__MotorcycleHelmet,s__Helmet) ).

fof(kb_SUMO_1391,axiom,
    s__instance(s__MotorcycleHelmet__t,s__SetOrClass) ).

fof(kb_SUMO_1392,axiom,
    s__documentation(s__MotorcycleHelmet,s__EnglishLanguage,'A &%Helmet designed to be worn by the driver of a &%Motorcycle.') ).

fof(kb_SUMO_1393,axiom,
    s__termFormat(s__EnglishLanguage,s__MotorcycleHelmet,'motorcycle helmet') ).

fof(kb_SUMO_1394,axiom,
    ! [V__MH] :
      ( s__instance(V__MH,s__WearableItem)
     => ( s__instance(V__MH,s__MotorcycleHelmet)
       => s__hasPurpose(V__MH,'(? [V__P,V__D,V__M] : (s__instance(V__D,s__Process) & s__instance(V__P,s__Animal) & s__instance(V__D,s__Driving) & s__agent(V__D,V__P) & s__instance(V__M,s__Motorcycle) & s__patient(V__D,V__M) & s__instance(V__P,s__Human) & s__holdsDuring(s__WhenFn(V__D),s__wears(V__P,V__MH))))') ) ) ).

fof(kb_SUMO_1395,axiom,
    s__subclass(s__Chain,s__Artifact) ).

fof(kb_SUMO_1396,axiom,
    s__instance(s__Chain__t,s__SetOrClass) ).

fof(kb_SUMO_1397,axiom,
    s__termFormat(s__EnglishLanguage,s__Chain,chain) ).

fof(kb_SUMO_1398,axiom,
    s__documentation(s__Chain,s__EnglishLanguage,'A number of interconnected loops of metal that has strength in tension and is used like rope, although it often is much stronger. Note that this class does not include loops of metal not arranged in an interconnected line, such as chain mail armor or a chain link fence, which are connected in a plane. Chain may however be used to make up other artifacts, such as tire chains, in which sections of chain are joined into a grid or other arrangement.') ).

fof(kb_SUMO_1399,axiom,
    ! [V__C] :
      ( s__instance(V__C,s__Chain)
     => ? [V__CL1,V__CL2,V__CL3] :
          ( s__instance(V__CL3,s__Object)
          & s__instance(V__CL2,s__Object)
          & s__instance(V__CL1,s__Object)
          & s__instance(V__CL1,s__ChainLink)
          & s__instance(V__CL2,s__ChainLink)
          & s__instance(V__CL3,s__ChainLink)
          & ~ s__equals(V__CL1,V__CL2)
          & ~ s__equals(V__CL2,V__CL3)
          & ~ s__equals(V__CL3,V__CL1)
          & s__crosses(V__CL1,V__CL2)
          & s__crosses(V__CL2,V__CL3)
          & ~ s__crosses(V__CL1,V__CL3) ) ) ).

fof(kb_SUMO_1400,axiom,
    s__instance(s__RingTorus,s__ShapeAttribute) ).

fof(kb_SUMO_1401,axiom,
    s__termFormat(s__EnglishLanguage,s__RingTorus,'ring torus') ).

fof(kb_SUMO_1402,axiom,
    s__documentation(s__RingTorus,s__EnglishLanguage,'Informally, the shape of a donut. More formally, the shape described by the edge of an oval when its center follows a oval path perpendicular to the plane of the first oval, and when the axis of the moving oval in the plane of the fixed oval is smaller than the shorter axis of the fixed oval.') ).

fof(kb_SUMO_1403,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Object)
     => ( s__attribute(V__X,s__RingTorus)
       => ? [V__H] :
            ( s__instance(V__H,s__Hole)
            & s__equals(V__X,s__HoleHostFn(V__H)) ) ) ) ).

fof(kb_SUMO_1404,axiom,
    s__subclass(s__ChainLink,s__Artifact) ).

fof(kb_SUMO_1405,axiom,
    s__instance(s__ChainLink__t,s__SetOrClass) ).

fof(kb_SUMO_1406,axiom,
    s__termFormat(s__EnglishLanguage,s__ChainLink,'chain link') ).

fof(kb_SUMO_1407,axiom,
    s__documentation(s__ChainLink,s__EnglishLanguage,'Any closed form of metal rod or wire intended for use as part of a chain.') ).

fof(kb_SUMO_1408,axiom,
    ! [V__CL] :
      ( ( s__subclass(V__CL,s__Substance)
        & s__instance(V__CL,s__SetOrClass) )
     => ( s__instance(V__CL,s__ChainLink)
       => s__material(V__CL,s__Metal) ) ) ).

fof(kb_SUMO_1409,axiom,
    ! [V__CL] :
      ( s__instance(V__CL,s__Object)
     => ( s__instance(V__CL,s__ChainLink)
       => s__attribute(V__CL,s__RingTorus) ) ) ).

fof(kb_SUMO_1410,axiom,
    s__instance(s__covers__m,s__BinaryRelation) ).

fof(kb_SUMO_1411,axiom,
    s__instance(s__covers__m,s__TransitiveRelation) ).

fof(kb_SUMO_1412,axiom,
    s__instance(s__covers__m,s__SpatialRelation) ).

fof(kb_SUMO_1413,axiom,
    s__format(s__EnglishLanguage,s__covers__m,'%1 covers %2') ).

fof(kb_SUMO_1414,axiom,
    s__documentation(s__covers__m,s__EnglishLanguage,'A relationship of partial or complete physical covering, which may be the result of a &%Covering. To cover an object, the first object must at least roughly conform to the surface of the second object. ') ).

fof(kb_SUMO_1415,axiom,
    ! [V__B,V__A,V__S] :
      ( ( s__instance(V__S,s__Object)
        & s__instance(V__A,s__Object)
        & s__instance(V__B,s__Object) )
     => ( ( s__covers(V__A,V__B)
          & s__superficialPart(V__S,V__B) )
       => s__meetsSpatially(V__A,V__S) ) ) ).

%FOL fof(kb_SUMO_1416,axiom,(( (! [V__P,V__C,V__I] : ((s__instance(V__I,s__Object) & s__instance(V__C,s__Process)) => ((s__instance(V__C,s__Covering) & s__patient(V__C,V__P) & s__instrument(V__C,V__I)) => s__holdsDuring(s__ImmediateFutureFn(s__WhenFn(V__C)),'s__covers(V__I,V__P)')))) ))).

fof(kb_SUMO_1417,axiom,
    s__subclass(s__TireChain,s__Device) ).

fof(kb_SUMO_1418,axiom,
    s__instance(s__TireChain__t,s__SetOrClass) ).

fof(kb_SUMO_1419,axiom,
    s__termFormat(s__EnglishLanguage,s__TireChain,'tire chain') ).

fof(kb_SUMO_1420,axiom,
    s__termFormat(s__EnglishLanguage,s__TireChain,'snow chain') ).

fof(kb_SUMO_1421,axiom,
    s__documentation(s__TireChain,s__EnglishLanguage,'Any web of chains designed to be mounted covering a tire, to increase traction of the tire on soft surfaces. While primarily for use on snow in passenger vehicles, these devices can be used on any other soft surface for the same purpose.') ).

fof(kb_SUMO_1422,axiom,
    ! [V__TC] :
      ( s__instance(V__TC,s__Object)
     => ( s__instance(V__TC,s__TireChain)
       => ? [V__C] :
            ( s__instance(V__C,s__Object)
            & s__instance(V__C,s__Chain)
            & s__part(V__C,V__TC) ) ) ) ).

fof(kb_SUMO_1423,axiom,
    ! [V__TC] :
      ( s__instance(V__TC,s__Object)
     => ( s__instance(V__TC,s__TireChain)
       => s__hasPurpose(V__TC,'(? [V__V,V__W,V__F] : (s__instance(V__F,s__Process) & s__instance(V__W,s__Object) & s__instance(V__V,s__Object) & s__instance(V__V,s__RoadVehicle) & s__instance(V__W,s__Wheel) & s__part(V__W,V__V) & s__instance(V__F,s__Friction) & s__covers(V__TC,V__W) & s__instrument(V__F,V__TC)))') ) ) ).

fof(kb_SUMO_1424,axiom,
    s__instance(s__SnapOnTools,s__Corporation) ).

fof(kb_SUMO_1425,axiom,
    s__termFormat(s__EnglishLanguage,s__SnapOnTools,'Snap-on Tools') ).

fof(kb_SUMO_1426,axiom,
    s__instance(s__HarleyDavidson,s__Corporation) ).

fof(kb_SUMO_1427,axiom,
    s__termFormat(s__EnglishLanguage,s__HarleyDavidson,'Harley Davidson') ).

fof(kb_SUMO_1428,axiom,
    s__subclass(s__HandTool,s__UnpoweredDevice) ).

fof(kb_SUMO_1429,axiom,
    s__instance(s__HandTool__t,s__SetOrClass) ).

fof(kb_SUMO_1430,axiom,
    s__instance(s__UnpoweredDevice__t,s__SetOrClass) ).

fof(kb_SUMO_1431,axiom,
    s__termFormat(s__EnglishLanguage,s__HandTool,'hand tool') ).

fof(kb_SUMO_1432,axiom,
    s__documentation(s__HandTool,s__EnglishLanguage,'Any &%UnpoweredDevice that a &%Human is capable of &%Carrying and is designed for a particular purpose.') ).

fof(kb_SUMO_1433,axiom,
    ! [V__HT] :
      ( s__instance(V__HT,s__Object)
     => ( s__instance(V__HT,s__HandTool)
       => s__capability(s__Carrying,s__objectTransferred__m,V__HT) ) ) ).

fof(kb_SUMO_1434,axiom,
    s__subclass(s__UnpoweredDevice,s__Device) ).

fof(kb_SUMO_1435,axiom,
    s__disjoint(s__UnpoweredDevice,s__ElectricDevice) ).

fof(kb_SUMO_1436,axiom,
    s__documentation(s__UnpoweredDevice,s__EnglishLanguage,'Any &%Device that lacks a &%part that is a power source.') ).

fof(kb_SUMO_1437,axiom,
    ! [V__UD] :
      ( s__instance(V__UD,s__Object)
     => ( s__instance(V__UD,s__UnpoweredDevice)
       => ~ ? [V__E] :
              ( s__instance(V__E,s__Object)
              & s__instance(V__E,s__Engine)
              & s__part(V__E,V__UD) ) ) ) ).

fof(kb_SUMO_1438,axiom,
    s__instance(s__GeneralMotorsCorp,s__Corporation) ).

fof(kb_SUMO_1439,axiom,
    s__termFormat(s__EnglishLanguage,s__GeneralMotorsCorp,'General Motors') ).

fof(kb_SUMO_1440,axiom,
    s__headquartersOfOrganization(s__GeneralMotorsCorp,s__UnitedStates) ).

fof(kb_SUMO_1441,axiom,
    s__instance(s__HoldenCorporation,s__Corporation) ).

fof(kb_SUMO_1442,axiom,
    s__headquartersOfOrganization(s__HoldenCorporation,s__Austrailia) ).

fof(kb_SUMO_1443,axiom,
    s__termFormat(s__EnglishLanguage,s__HoldenCorporation,'Holden Corporation') ).

fof(kb_SUMO_1444,axiom,
    s__documentation(s__HoldenCorporation,s__EnglishLanguage,'A &%manufacturer of &%Automobiles in &%Austrailia that is a &%subOrganization of &%GeneralMotorsCorp and is the &%manufacturer of the &%CommodoreAutomobile.') ).

fof(kb_SUMO_1445,axiom,
    s__subOrganization(s__HoldenCorporation,s__GeneralMotorsCorp) ).

fof(kb_SUMO_1446,axiom,
    s__instance(s__manufacturer__m,s__BinaryPredicate) ).

fof(kb_SUMO_1447,axiom,
    s__documentation(s__manufacturer__m,s__EnglishLanguage,'A relation between a class of &%Objects and an &%Agent that is responsible for the &%Manufacture of that object.') ).

fof(kb_SUMO_1448,axiom,
    s__domainSubclass(s__manufacturer__m,"1",s__Object) ).

fof(kb_SUMO_1449,axiom,
    s__domain(s__manufacturer__m,"2",s__Agent) ).

fof(kb_SUMO_1450,axiom,
    s__format(s__EnglishLanguage,s__manufacturer__m,'the maker of %1 is %2') ).

fof(kb_SUMO_1451,axiom,
    s__subclass(s__CommodoreAutomobile,s__Automobile) ).

fof(kb_SUMO_1452,axiom,
    s__instance(s__CommodoreAutomobile__t,s__SetOrClass) ).

fof(kb_SUMO_1453,axiom,
    s__documentation(s__CommodoreAutomobile,s__EnglishLanguage,'A brand of &%Automobile that is the output of &%Manufacture by &%HoldenCorporation.') ).

fof(kb_SUMO_1454,axiom,
    s__manufacturer(s__CommodoreAutomobile,s__HoldenCorporation) ).

fof(kb_SUMO_1455,axiom,
    s__subclass(s__CommodoreWheel,s__Wheel) ).

fof(kb_SUMO_1456,axiom,
    s__instance(s__CommodoreWheel__t,s__SetOrClass) ).

fof(kb_SUMO_1457,axiom,
    s__documentation(s__CommodoreWheel,s__EnglishLanguage,'A wheel (timre rim) made for the &%CommodoreAutomobile.') ).

fof(kb_SUMO_1458,axiom,
    s__termFormat(s__EnglishLanguage,s__CommodoreWheel,'Commodore wheel') ).

fof(kb_SUMO_1459,axiom,
    s__manufacturer(s__CommodoreWheel,s__Holden) ).

fof(kb_SUMO_1460,axiom,
    ! [V__CW] :
      ( s__instance(V__CW,s__Object)
     => ( s__instance(V__CW,s__CommodoreWheel)
       => s__hasPurpose(V__CW,'(? [V__CA] : (s__instance(V__CA,s__Object) & s__instance(V__CA,s__CommodoreAutomobile) & s__part(V__CW,V__CA)))') ) ) ).

fof(kb_SUMO_1461,axiom,
    s__instance(s__engineCylinders__m,s__BinaryPredicate) ).

fof(kb_SUMO_1462,axiom,
    s__domain(s__engineCylinders__m,"1",s__Engine) ).

fof(kb_SUMO_1463,axiom,
    s__domain(s__engineCylinders__m,"2",s__NonNegativeInteger) ).

fof(kb_SUMO_1464,axiom,
    s__format(s__EnglishLanguage,s__engineCylinders__m,'engine %1 has %2 cylinders') ).

fof(kb_SUMO_1465,axiom,
    s__documentation(s__engineCylinders__m,s__EnglishLanguage,'The number of &%EngineCylinders in a particular &%Engine.') ).

fof(kb_SUMO_1466,axiom,
    ! [V__E,V__EC,V__N] :
      ( ( s__instance(V__N,s__NonNegativeInteger)
        & s__instance(V__N,s__NonnegativeInteger)
        & s__instance(V__EC,s__SelfConnectedObject)
        & s__instance(V__E,s__Engine) )
     => ( s__engineCylinders(V__E,V__N)
       => ? [V__G] :
            ( s__instance(V__G,s__Collection)
            & s__memberTypeCount(V__G,s__EngineCylinder,V__N)
            & s__member(V__EC,V__G)
            & s__part(V__EC,V__E) ) ) ) ).

fof(kb_SUMO_1467,axiom,
    s__subclass(s__TwoCylinderEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1468,axiom,
    s__instance(s__TwoCylinderEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1469,axiom,
    s__documentation(s__TwoCylinderEngine,s__EnglishLanguage,'An &%IntermittentCombustionEngine that has two &%EngineCylinders.') ).

fof(kb_SUMO_1470,axiom,
    s__termFormat(s__TwoCylinderEngine,s__EnglishLanguage,'two cylinder engine') ).

fof(kb_SUMO_1471,axiom,
    ! [V__TCE] :
      ( s__instance(V__TCE,s__Engine)
     => ( s__instance(V__TCE,s__TwoCylinderEngine)
       => s__engineCylinders(V__TCE,"2") ) ) ).

fof(kb_SUMO_1472,axiom,
    s__subclass(s__FourCylinderEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1473,axiom,
    s__instance(s__FourCylinderEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1474,axiom,
    s__documentation(s__FourCylinderEngine,s__EnglishLanguage,'An &%IntermittentCombustionEngine that has four &%EngineCylinders.') ).

fof(kb_SUMO_1475,axiom,
    s__termFormat(s__FourCylinderEngine,s__EnglishLanguage,'four cylinder engine') ).

fof(kb_SUMO_1476,axiom,
    ! [V__FCE] :
      ( s__instance(V__FCE,s__Engine)
     => ( s__instance(V__FCE,s__FourCylinderEngine)
       => s__engineCylinders(V__FCE,"2") ) ) ).

fof(kb_SUMO_1477,axiom,
    s__subclass(s__SixCylinderEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1478,axiom,
    s__instance(s__SixCylinderEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1479,axiom,
    s__documentation(s__SixCylinderEngine,s__EnglishLanguage,'An &%IntermittentCombustionEngine that has six &%EngineCylinders.') ).

fof(kb_SUMO_1480,axiom,
    s__termFormat(s__SixCylinderEngine,s__EnglishLanguage,'six cylinder engine') ).

fof(kb_SUMO_1481,axiom,
    ! [V__E] :
      ( s__instance(V__E,s__Engine)
     => ( s__instance(V__E,s__SixCylinderEngine)
       => s__engineCylinders(V__E,"6") ) ) ).

fof(kb_SUMO_1482,axiom,
    s__subclass(s__EightCylinderEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1483,axiom,
    s__documentation(s__EightCylinderEngine,s__EnglishLanguage,'An &%IntermittentCombustionEngine that has eight &%EngineCylinders.') ).

fof(kb_SUMO_1484,axiom,
    s__termFormat(s__EightCylinderEngine,s__EnglishLanguage,'eight cylinder engine') ).

fof(kb_SUMO_1485,axiom,
    ! [V__E] :
      ( s__instance(V__E,s__Engine)
     => ( s__instance(V__E,s__EightCylinderEngine)
       => s__engineCylinders(V__E,"8") ) ) ).

fof(kb_SUMO_1486,axiom,
    s__instance(s__HarleyDavidsonCorp,s__Corporation) ).

fof(kb_SUMO_1487,axiom,
    s__termFormat(s__EnglishLanguage,s__HarleyDavidsonCorp,'Harley Davidson') ).

fof(kb_SUMO_1488,axiom,
    s__documentation(s__HarleyDavidsonCorp,s__EnglishLanguage,'An iconic &%manufacturer of &%Motorcyles in the &%UnitedStates.') ).

fof(kb_SUMO_1489,axiom,
    s__headquartersOfOrganization(s__HarleyDavidsonCorp,s__UnitedStates) ).

fof(kb_SUMO_1490,axiom,
    s__subclass(s__HarleyDavidsonKnuckleheadEngine,s__TwoCylinderEngine) ).

fof(kb_SUMO_1491,axiom,
    s__instance(s__HarleyDavidsonKnuckleheadEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1492,axiom,
    s__externalImage(s__HarleyDavidsonKnuckleheadEngine,'http://en.wikipedia.org/wiki/File:Harley035.jpg') ).

fof(kb_SUMO_1493,axiom,
    s__termFormat(s__EnglishLanguage,s__HarleyDavidsonKnuckleheadEngine,knucklehead) ).

fof(kb_SUMO_1494,axiom,
    s__manufacturer(s__HarleyDavidsonKnuckleheadEngine,s__HarleyDavidsonCorp) ).

fof(kb_SUMO_1495,axiom,
    s__subclass(s__FourWheelDriveVehicle,s__LandVehicle) ).

fof(kb_SUMO_1496,axiom,
    s__instance(s__FourWheelDriveVehicle__t,s__SetOrClass) ).

fof(kb_SUMO_1497,axiom,
    s__termFormat(s__EnglishLanguage,s__FourWheelDriveVehicle,'four wheel drive') ).

fof(kb_SUMO_1498,axiom,
    s__documentation(s__FourWheelDriveVehicle,s__EnglishLanguage,'A &%LandVehicle that is capable of providing power to all four &%Wheels.') ).

fof(kb_SUMO_1499,axiom,
    ! [V__FWD] :
      ( s__instance(V__FWD,s__FourWheelDriveVehicle)
     => s__hasPurpose(V__FWD,'(! [V__W] : ((s__instance(V__W,s__Object) & s__instance(V__FWD,s__Object)) => (s__part(V__W,V__FWD) & (? [V__E,V__C,V__R1,V__R2] : (s__instance(V__R2,s__Process) & s__instance(V__R1,s__Process) & s__instance(V__C,s__Object) & s__instance(V__E,s__Object) & s__instance(V__E,s__Engine) & s__part(V__E,V__FWD) & s__instance(V__C,s__Crankshaft) & s__part(V__C,V__E) & s__instance(V__R1,s__Rotating) & s__patient(V__R1,V__C) & s__instance(V__R2,s__Rotating) & s__patient(V__R2,V__W) & s__causes(V__R1,V__R2))))))') ) ).

fof(kb_SUMO_1500,axiom,
    s__subclass(s__TwoWheelDriveVehicle,s__LandVehicle) ).

fof(kb_SUMO_1501,axiom,
    s__instance(s__TwoWheelDriveVehicle__t,s__SetOrClass) ).

fof(kb_SUMO_1502,axiom,
    s__termFormat(s__EnglishLanguage,s__TwoWheelDriveVehicle,'four wheel drive') ).

fof(kb_SUMO_1503,axiom,
    s__documentation(s__TwoWheelDriveVehicle,s__EnglishLanguage,'A &%LandVehicle that is capable of providing power to all four &%Wheels.') ).

fof(kb_SUMO_1504,axiom,
    ! [V__TWD] :
      ( s__instance(V__TWD,s__Object)
     => ( s__instance(V__TWD,s__TwoWheelDriveVehicle)
       => s__hasPurpose(V__TWD,'(? [V__W1,V__W2] : (s__part(V__W1,V__TWD) & s__part(V__W2,V__TWD) & (~ (V__W1 = V__W2)) & (? [V__E,V__C,V__R1,V__R2,V__R3] : (s__instance(V__E,s__Engine) & s__part(V__E,V__TWD) & s__instance(V__C,s__Crankshaft) & s__part(V__C,V__E) & s__instance(V__R1,s__Rotating) & s__patient(V__R1,V__C) & s__instance(V__R2,s__Rotating) & s__patient(V__R2,V__W1) & s__causes(V__R1,V__R2) & s__patient(V__R3,V__W2) & s__causes(V__R1,V__R3) & (~ (? [V__W3,V__R4] : (s__instance(V__R4,s__Process) & s__instance(V__W3,s__Object) & s__instance(V__R3,s__Process) & s__instance(V__R2,s__Process) & s__instance(V__R1,s__Process) & s__instance(V__C,s__Object) & s__instance(V__E,s__Object) & s__instance(V__W2,s__Object) & s__instance(V__W1,s__Object) & (~ (V__W1 = V__W3)) & (~ s__equals(V__W2,V__W3)) & s__part(V__W3,V__TWD) & s__instance(V__R4,s__Rotating) & s__patient(V__R4,V__W3) & s__causes(V__R1,V__R4))))))))') ) ) ).

fof(kb_SUMO_1505,axiom,
    s__termFormat(s__EnglishLanguage,s__FourByFourTire,'4x4 tire') ).

fof(kb_SUMO_1506,axiom,
    s__termFormat(s__EnglishLanguage,s__FourByFourTire,'4 by 4 tire') ).

fof(kb_SUMO_1507,axiom,
    s__termFormat(s__EnglishLanguage,s__FourByFourTire,'four wheel drive tire') ).

fof(kb_SUMO_1508,axiom,
    s__subclass(s__FourByFourTire,s__Tire) ).

fof(kb_SUMO_1509,axiom,
    s__instance(s__FourByFourTire__t,s__SetOrClass) ).

fof(kb_SUMO_1510,axiom,
    s__documentation(s__FourByFourTire,s__EnglishLanguage,'A &%VehicleTire that is intended for use on a &%FourWheelDriveVehicle, having increased traction compared to vehicle tires intended for use on Asphalt.') ).

fof(kb_SUMO_1511,axiom,
    ! [V__FFT] :
      ( s__instance(V__FFT,s__Object)
     => ( s__instance(V__FFT,s__FourByFourTire)
       => s__hasPurpose(V__FFT,'(? [V__FWDV] : (s__instance(V__FWDV,s__Object) & s__instance(V__FWDV,s__FourWheelDriveVehicle) & s__part(V__FFT,V__FWDV)))') ) ) ).

fof(kb_SUMO_1512,axiom,
    s__termFormat(s__EnglishLanguage,s__VehicleRoofRack,'roof bars') ).

fof(kb_SUMO_1513,axiom,
    s__termFormat(s__EnglishLanguage,s__VehicleRoofRack,'roof rack') ).

fof(kb_SUMO_1514,axiom,
    s__termFormat(s__EnglishLanguage,s__VehicleRoofRack,'cargo rack') ).

fof(kb_SUMO_1515,axiom,
    s__subclass(s__VehicleRoofRack,s__Device) ).

fof(kb_SUMO_1516,axiom,
    s__instance(s__VehicleRoofRack__t,s__SetOrClass) ).

fof(kb_SUMO_1517,axiom,
    s__documentation(s__VehicleRoofRack,s__EnglishLanguage,'A structure designed to be attached to, or made as part of a &%RoadVehicle, to which cargo, or cargo-carrying &%Containers may be temporarily attached.') ).

fof(kb_SUMO_1518,axiom,
    ! [V__VRR,V__C] :
      ( ( s__instance(V__C,s__Object)
        & s__instance(V__VRR,s__Object) )
     => ( s__instance(V__VRR,s__VehicleRoofRack)
       => s__hasPurpose(V__VRR,'(? [V__T,V__A] : (s__instance(V__A,s__Object) & s__instance(V__T,s__Process) & s__instance(V__T,s__Transfer) & s__patient(V__T,V__C) & s__instance(V__A,s__Automobile) & s__orientation(V__VRR,V__A,s__Outside) & s__meetsSpatially(V__C,V__VRR) & s__part(V__VRR,V__A) & s__instrument(V__T,V__A)))') ) ) ).

fof(kb_SUMO_1519,axiom,
    s__subclass(s__HarleyDavidsonPanheadEngine,s__TwoCylinderEngine) ).

fof(kb_SUMO_1520,axiom,
    s__instance(s__HarleyDavidsonPanheadEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1521,axiom,
    s__externalImage(s__HarleyDavidsonPanheadEngine,'http://upload.wikimedia.org/wikipedia/commons/d/d8/Panhead.jpg') ).

fof(kb_SUMO_1522,axiom,
    s__termFormat(s__EnglishLanguage,s__HarleyDavidsonPanheadEngine,panhead) ).

fof(kb_SUMO_1523,axiom,
    s__manufacturer(s__HarleyDavidsonPanheadEngine,s__HarleyDavidsonCorp) ).

fof(kb_SUMO_1524,axiom,
    s__termFormat(s__de__m,s__InteriorVehicleEquipment,fahrzeugeinrichtung) ).

fof(kb_SUMO_1525,axiom,
    s__termFormat(s__EnglishLanguage,s__InteriorVehicleEquipment,'vehicle interior') ).

fof(kb_SUMO_1526,axiom,
    s__subclass(s__InteriorVehicleEquipment,s__Artifact) ).

fof(kb_SUMO_1527,axiom,
    s__instance(s__InteriorVehicleEquipment__t,s__SetOrClass) ).

fof(kb_SUMO_1528,axiom,
    s__documentation(s__InteriorVehicleEquipment,s__EnglishLanguage,'The objects &%Inside the passenger compartment of a &%RoadVehicle, such as the seats, dashboard and radio.') ).

fof(kb_SUMO_1529,axiom,
    ! [V__IVE] :
      ( s__instance(V__IVE,s__Object)
     => ( s__instance(V__IVE,s__InteriorVehicleEquipment)
       => s__hasPurpose(V__IVE,'(? [V__V,V__E] : (s__instance(V__E,s__Object) & s__instance(V__V,s__Object) & s__instance(V__V,s__Automobile) & s__instance(V__E,s__Engine) & s__part(V__E,V__V) & (~ s__part(V__IVE,V__E)) & s__part(V__IVE,V__V) & s__orientation(V__IVE,V__V,s__Inside)))') ) ) ).

fof(kb_SUMO_1530,axiom,
    s__instance(s__RoverGroup,s__Corporation) ).

fof(kb_SUMO_1531,axiom,
    s__documentation(s__RoverGroup,s__EnglishLanguage,'A British motor car company that has gone through many different eras as a brand, independant corporation, and subsidiary.') ).

fof(kb_SUMO_1532,axiom,
    s__headquartersOfOrganization(s__RoverGroup,s__UnitedKingdom) ).

fof(kb_SUMO_1533,axiom,
    s__subclass(s__RoverV8Engine,s__EightCylinderEngine) ).

fof(kb_SUMO_1534,axiom,
    s__instance(s__RoverV8Engine__t,s__SetOrClass) ).

fof(kb_SUMO_1535,axiom,
    s__instance(s__EightCylinderEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1536,axiom,
    s__externalImage(s__RoverV8Engine,'http://upload.wikimedia.org/wikipedia/commons/4/45/Rover_V8_engine.jpg') ).

fof(kb_SUMO_1537,axiom,
    s__manufacturer(s__RoverV8Engine,s__RoverGroup) ).

fof(kb_SUMO_1538,axiom,
    s__termFormat(s__EnglishLanguage,s__RoverV8Engine,'Rover v8') ).

fof(kb_SUMO_1539,axiom,
    s__documentation(s__RoverV8Engine,s__EnglishLanguage,'The Rover V8 engine is a compact V8 internal combustion engine with aluminium cylinder heads and cylinder block, originally designed by General Motors and later re-designed and produced by Rover in the United Kingdom. It has been used in a wide range of vehicles from Rover and other manufacturers since its British debut in 1967. [from Wikipedia]') ).

fof(kb_SUMO_1540,axiom,
    ! [V__RV8] :
      ( ( s__subclass(V__RV8,s__Substance)
        & s__instance(V__RV8,s__SetOrClass) )
     => ( s__instance(V__RV8,s__RoverV8Engine)
       => s__material(V__RV8,s__Aluminum) ) ) ).

fof(kb_SUMO_1541,axiom,
    s__instance(s__BritishSeagullCorp,s__Corporation) ).

fof(kb_SUMO_1542,axiom,
    s__termFormat(s__EnglishLanguage,s__BritishSeagullCorp,'British Seagull corp') ).

fof(kb_SUMO_1543,axiom,
    s__headquartersOfOrganization(s__BritishSeagullCorp,s__UnitedKingdom) ).

fof(kb_SUMO_1544,axiom,
    s__documentation(s__BritishSeagullCorp,s__EnglishLanguage,'British Seagull was a British manufacturer of two-stroke outboard engines from the early 1930s until the mid 1990s. The company went out of business due to the motor design not being able to keep up with more modern boat engines and increasingly tight emissions regulations. British Seagull no longer produces new engines but still operates for parts.') ).

fof(kb_SUMO_1545,axiom,
    s__subclass(s__SeagullOutboard,s__OutboardMotor) ).

fof(kb_SUMO_1546,axiom,
    s__instance(s__SeagullOutboard__t,s__SetOrClass) ).

fof(kb_SUMO_1547,axiom,
    s__instance(s__OutboardMotor__t,s__SetOrClass) ).

fof(kb_SUMO_1548,axiom,
    s__subclass(s__SeagullOutboard,s__TwoStrokeEngine) ).

fof(kb_SUMO_1549,axiom,
    s__termFormat(s__EnglishLanguage,s__SeagullOutboard,'Seagull outboard') ).

fof(kb_SUMO_1550,axiom,
    s__manufacturer(s__SeagullOutboard,s__BritishSeagullCorp) ).

fof(kb_SUMO_1551,axiom,
    s__externalImage(s__BritishSeagullOutboardMotor,'http://upload.wikimedia.org/wikipedia/commons/1/1f/BritishSeagull.jpg') ).

fof(kb_SUMO_1552,axiom,
    s__subclass(s__MotorcycleGlove,s__Glove) ).

fof(kb_SUMO_1553,axiom,
    s__instance(s__MotorcycleGlove__t,s__SetOrClass) ).

fof(kb_SUMO_1554,axiom,
    s__subclass(s__MotorcycleGlove,s__SafetyDevice) ).

fof(kb_SUMO_1555,axiom,
    s__Glove = s__CoveringFn(s__Hand) ).

fof(kb_SUMO_1556,axiom,
    s__termFormat(s__EnglishLanguage,s__MotorcycleGlove,'motorcycle glove') ).

fof(kb_SUMO_1557,axiom,
    s__documentation(s__MotorcycleGlove,s__EnglishLanguage,'&%Gloves that are intended for use while riding a &%Motorcycle. They may include features such as special fabrics or armor to protect the hands in case of an accident.') ).

fof(kb_SUMO_1558,axiom,
    ! [V__MG] :
      ( s__instance(V__MG,s__WearableItem)
     => ( s__instance(V__MG,s__MotorcycleGlove)
       => s__hasPurpose(V__MG,'(? [V__M,V__D,V__T] : (s__instance(V__T,s__Process) & s__instance(V__D,s__Animal) & s__instance(V__M,s__Object) & s__instance(V__T,s__Driving) & s__agent(V__T,V__D) & s__instrument(V__T,V__M) & s__instance(V__M,s__Motorcycle) & s__holdsDuring(s__WhenFn(V__T),s__wears(V__D,V__MG))))') ) ) ).

fof(kb_SUMO_1559,axiom,
    s__subclass(s__AllTerrainVehicle,s__LandVehicle) ).

fof(kb_SUMO_1560,axiom,
    s__instance(s__AllTerrainVehicle__t,s__SetOrClass) ).

fof(kb_SUMO_1561,axiom,
    s__documentation(s__AllTerrainVehicle,s__EnglishLanguage,'A &%Vehicle that travels on low-pressure tires, with a seat that is straddled by the operator, along with handlebars for &%Steering control, that is designed to handle a wider variety of terrain than most &%RoadVehicles') ).

fof(kb_SUMO_1562,axiom,
    s__termFormat(s__EnglishLanguage,s__AllTerrainVehicle,'ATV') ).

fof(kb_SUMO_1563,axiom,
    s__termFormat(s__EnglishLanguage,s__AllTerrainVehicle,'all-terrain vehicle') ).

fof(kb_SUMO_1564,axiom,
    ! [V__ATV] :
      ( s__instance(V__ATV,s__Object)
     => ( s__instance(V__ATV,s__AllTerrainVehicle)
       => s__hasPurpose(V__ATV,'(? [V__D,V__L] : (s__instance(V__L,s__Object) & s__instance(V__D,s__Process) & s__instance(V__D,s__Transportation) & s__instrument(V__D,V__ATV) & s__holdsDuring(s__WhenFn(V__D),s__orientation(V__ATV,V__L,s__On)) & (~ s__instance(V__L,s__Roadway))))') ) ) ).

fof(kb_SUMO_1565,axiom,
    s__subclass(s__Tire,s__Device) ).

fof(kb_SUMO_1566,axiom,
    s__documentation(s__Tire,s__EnglishLanguage,'Any &%Pliable object with a &%RoundShape that is designed to cover the &%WheelRim, and provide a &$WearingFrictionSurface that can be replaced more cheaply and/or easily than the rim. It may also increase traction, and provide some shock absorbtion or act as a &%Damper, thus smoothing the ride of a &%Vehicle.') ).

fof(kb_SUMO_1567,axiom,
    s__termFormat(s__EnglishLanguage,s__Tire,tire) ).

fof(kb_SUMO_1568,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Tire)
       => s__hasPurpose(V__T,'(? [V__W,V__R] : (s__instance(V__R,s__Object) & s__instance(V__W,s__Object) & s__instance(V__W,s__Wheel) & s__instance(V__R,s__WheelRim) & s__part(V__T,V__W) & s__part(V__R,V__W) & s__covers(V__T,V__R)))') ) ) ).

fof(kb_SUMO_1569,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Tire)
       => s__attribute(V__T,s__Pliable) ) ) ).

fof(kb_SUMO_1570,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__Tire)
       => s__attribute(V__T,s__RoundShape) ) ) ).

fof(kb_SUMO_1571,axiom,
    s__subclass(s__WheelRim,s__Device) ).

fof(kb_SUMO_1572,axiom,
    s__documentation(s__WheelRim,s__EnglishLanguage,'The rigid portion of a &%Wheel on a &%RoadVehicle that is designed to have a &%Tire that &%covers it.') ).

fof(kb_SUMO_1573,axiom,
    s__termFormat(s__EnglishLanguage,s__WheelRim,rim) ).

fof(kb_SUMO_1574,axiom,
    ! [V__WR] :
      ( s__instance(V__WR,s__Object)
     => ( s__instance(V__WR,s__WheelRim)
       => s__attribute(V__WR,s__Rigid) ) ) ).

fof(kb_SUMO_1575,axiom,
    s__subclass(s__ATVTire,s__Tire) ).

fof(kb_SUMO_1576,axiom,
    s__instance(s__ATVTire__t,s__SetOrClass) ).

fof(kb_SUMO_1577,axiom,
    s__documentation(s__ATVTire,s__EnglishLanguage,'A &%Tire designed to fit the &%WheelRim on an &%AllTerrainVehicle.') ).

fof(kb_SUMO_1578,axiom,
    s__termFormat(s__EnglishLanguage,s__ATVTire,'atv tire') ).

fof(kb_SUMO_1579,axiom,
    s__subclass(s__HandToolBox,s__Box) ).

fof(kb_SUMO_1580,axiom,
    s__instance(s__HandToolBox__t,s__SetOrClass) ).

fof(kb_SUMO_1581,axiom,
    s__documentation(s__HandToolBox,s__EnglishLanguage,'A &%Box designed for &%Carrying &%HandTools, such as a &%Hammer or &%Wrench.') ).

fof(kb_SUMO_1582,axiom,
    s__termFormat(s__EnglishLanguage,s__HandToolBox,'tool box') ).

fof(kb_SUMO_1583,axiom,
    ! [V__HTB] :
      ( s__instance(V__HTB,s__SelfConnectedObject)
     => ( s__instance(V__HTB,s__HandToolBox)
       => s__hasPurpose(V__HTB,'(? [V__HT] : (s__instance(V__HT,s__Object) & s__instance(V__HT,s__HandTool) & s__contains(V__HTB,V__HT)))') ) ) ).

fof(kb_SUMO_1584,axiom,
    s__instance(s__SimmonsCorp,s__Corporation) ).

fof(kb_SUMO_1585,axiom,
    s__documentation(s__SimmonsCorp,s__EnglishLanguage,'An &%Australian manufacturer of custom alloy &%WheelRims.') ).

fof(kb_SUMO_1586,axiom,
    s__headquartersOfOrganization(s__SimmonsCorp,s__Australia) ).

fof(kb_SUMO_1587,axiom,
    s__subclass(s__SimmonsWheelRim,s__WheelRim) ).

fof(kb_SUMO_1588,axiom,
    s__instance(s__SimmonsWheelRim__t,s__SetOrClass) ).

fof(kb_SUMO_1589,axiom,
    s__documentation(s__SimmonWheelRim,s__EnglishLanguage,'A &%WheelRim &%Manufactured by &%SimmonsCorp.') ).

fof(kb_SUMO_1590,axiom,
    s__termFormat(s__EnglishLanguage,s__SimmonsWheelRim,'Simmons rim') ).

fof(kb_SUMO_1591,axiom,
    s__termFormat(s__EnglishLanguage,s__SimmonsWheelRim,'Simmons wheel') ).

fof(kb_SUMO_1592,axiom,
    s__manufacturer(s__SimmonsWheelRim,s__SimmonsCorp) ).

fof(kb_SUMO_1593,axiom,
    s__instance(s__BritishMotorCorp,s__Corporation) ).

fof(kb_SUMO_1594,axiom,
    s__termFormat(s__EnglishLanguage,s__BritishMotorCorp,'British Motors') ).

fof(kb_SUMO_1595,axiom,
    s__documentation(s__BritishMotorCorp,s__EnglishLanguage,'A company based in the &%UnitedKingdom that was responsible for &%Making the original iconic Mini car.') ).

fof(kb_SUMO_1596,axiom,
    s__subclass(s__MiniCooper,s__Automobile) ).

fof(kb_SUMO_1597,axiom,
    s__instance(s__MiniCooper__t,s__SetOrClass) ).

fof(kb_SUMO_1598,axiom,
    s__documentation(s__MiniCooper,s__EnglishLanguage,'A family of small &%Automobile models that is an iconic British vehicle. It has been revived by &%BMW.') ).

fof(kb_SUMO_1599,axiom,
    s__termFormat(s__EnglishLanguage,s__MiniCooper,'mini cooper') ).

fof(kb_SUMO_1600,axiom,
    s__manufacturer(s__MiniCooper,s__BritishMotorCorp) ).

fof(kb_SUMO_1601,axiom,
    s__subclass(s__MiniCooperEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1602,axiom,
    s__instance(s__MiniCooperEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1603,axiom,
    s__termFormat(s__EnglishLanguage,s__MiniCooperEngine,'mini cooper engine') ).

fof(kb_SUMO_1604,axiom,
    s__termFormat(s__EnglishLanguage,s__MiniCooperEngine,'mini engine') ).

fof(kb_SUMO_1605,axiom,
    s__typicalPart(s__MiniCooperEngine,s__MiniCooper) ).

fof(kb_SUMO_1606,axiom,
    s__typicallyContainsPart(s__MiniCooperEngine,s__MiniCooper) ).

fof(kb_SUMO_1607,axiom,
    s__subclass(s__HoldenToranaAutomobile,s__Automobile) ).

fof(kb_SUMO_1608,axiom,
    s__instance(s__HoldenToranaAutomobile__t,s__SetOrClass) ).

fof(kb_SUMO_1609,axiom,
    s__instance(s__Automobile__t,s__SetOrClass) ).

fof(kb_SUMO_1610,axiom,
    s__documentation(s__HoldenToranaAutomobile,s__EnglishLanguage,'A brand of &%Automobile that is the output of &%Manufacture by &%HoldenCorporation.') ).

fof(kb_SUMO_1611,axiom,
    s__termFormat(s__EnglishLanguage,s__HoldenToranaAutomobile,'Torana') ).

fof(kb_SUMO_1612,axiom,
    s__termFormat(s__EnglishLanguage,s__HoldenToranaAutomobile,'Holden Torana') ).

fof(kb_SUMO_1613,axiom,
    s__manufacturer(s__HoldenToranaAutomobile,s__HoldenCorporation) ).

fof(kb_SUMO_1614,axiom,
    s__subclass(s__TireChanger,s__Device) ).

fof(kb_SUMO_1615,axiom,
    s__instance(s__TireChanger__t,s__SetOrClass) ).

fof(kb_SUMO_1616,axiom,
    s__documentation(s__TireChanger,s__EnglishLanguage,'A &%Device for putting &%Tires on &%WheelRims, or removing them.') ).

fof(kb_SUMO_1617,axiom,
    s__termFormat(s__EnglishLanguage,s__TireChanger,'tire changer') ).

fof(kb_SUMO_1618,axiom,
    ! [V__TC] :
      ( s__instance(V__TC,s__Object)
     => ( s__instance(V__TC,s__TireChanger)
       => s__hasPurpose(V__TC,'(? [V__P,V__T,V__R] : (s__instance(V__T,s__Object) & s__instance(V__P,s__Transfer) & s__instance(V__P,s__Putting) & s__instance(V__T,s__Tire) & s__instance(V__R,s__WheelRim) & s__destination(V__P,V__R) & s__objectTransferred(V__P,V__T) & s__instrument(V__P,V__TC)))') ) ) ).

fof(kb_SUMO_1619,axiom,
    ! [V__TC] :
      ( s__instance(V__TC,s__Object)
     => ( s__instance(V__TC,s__TireChanger)
       => s__hasPurpose(V__TC,'(? [V__RE,V__T,V__R] : (s__instance(V__R,s__Object) & s__instance(V__T,s__Object) & s__instance(V__RE,s__Transfer) & s__instance(V__RE,s__Removing) & s__instance(V__T,s__Tire) & s__instance(V__R,s__WheelRim) & s__origin(V__RE,V__R) & s__objectTransferred(V__RE,V__T) & s__instrument(V__RE,V__TC)))') ) ) ).

fof(kb_SUMO_1620,axiom,
    s__termFormat(s__EnglishLanguage,s__RecreationalVehicle,caravan) ).

fof(kb_SUMO_1621,axiom,
    s__termFormat(s__EnglishLanguage,s__RecreationalVehicle,'RV') ).

fof(kb_SUMO_1622,axiom,
    s__termFormat(s__EnglishLanguage,s__RecreationalVehicle,camper) ).

fof(kb_SUMO_1623,axiom,
    s__subclass(s__FordWheelRim,s__WheelRim) ).

fof(kb_SUMO_1624,axiom,
    s__instance(s__FordWheelRim__t,s__SetOrClass) ).

fof(kb_SUMO_1625,axiom,
    s__instance(s__WheelRim__t,s__SetOrClass) ).

fof(kb_SUMO_1626,axiom,
    s__documentation(s__FordWheelRim,s__EnglishLanguage,'A &%WheelRim intended for a &%FordAutomobile.') ).

fof(kb_SUMO_1627,axiom,
    s__termFormat(s__EnglishLanguage,s__FordWheelRim,'Ford rim') ).

fof(kb_SUMO_1628,axiom,
    s__termFormat(s__EnglishLanguage,s__FordWheelRim,'Ford wheel') ).

fof(kb_SUMO_1629,axiom,
    s__subclass(s__FordAutomobile,s__Automobile) ).

fof(kb_SUMO_1630,axiom,
    s__instance(s__FordAutomobile__t,s__SetOrClass) ).

fof(kb_SUMO_1631,axiom,
    s__documentation(s__FordAutomobile,s__EnglishLanguage,'A brand of &%Automobile that is the output of &%Manufacture by &%FordCorporation.') ).

fof(kb_SUMO_1632,axiom,
    s__termFormat(s__EnglishLanguage,s__FordAutomobile,'Ford') ).

fof(kb_SUMO_1633,axiom,
    s__termFormat(s__EnglishLanguage,s__FordAutomobile,'Ford car') ).

fof(kb_SUMO_1634,axiom,
    s__manufacturer(s__FordAutomobile,s__FordCorporation) ).

fof(kb_SUMO_1635,axiom,
    s__instance(s__FordCorporation,s__Corporation) ).

fof(kb_SUMO_1636,axiom,
    s__termFormat(s__EnglishLanguage,s__FordCorporation,'Ford') ).

fof(kb_SUMO_1637,axiom,
    s__documentation(s__FordCorporation,s__EnglishLanguage,'A company based in the &%UnitedStates that is one of the oldest and largest existing passenger car makers.') ).

fof(kb_SUMO_1638,axiom,
    s__subclass(s__Ratchet,s__Wrench) ).

fof(kb_SUMO_1639,axiom,
    s__documentation(s__Ratchet,s__EnglishLanguage,'A &%Wrench that allows an engaged &%Bolt to exhibit &%Rotating freely in one direction but not another, with respect to the handle of the wrench. Some wrenches have a switch that allows selection of one of two directions of free rotation.') ).

fof(kb_SUMO_1640,axiom,
    ! [V__A,V__R,V__DIR2,V__RO2,V__RO1,V__DIR1] :
      ( ( s__instance(V__DIR1,s__Attribute)
        & s__instance(V__RO1,s__Object)
        & s__instance(V__RO1,s__Process)
        & s__instance(V__RO2,s__Object)
        & s__instance(V__RO2,s__Process)
        & s__instance(V__DIR2,s__Attribute) )
     => ( ( s__instance(V__R,s__Ratchet)
          & s__instance(V__A,s__AttachingDevice)
          & s__instance(V__RO1,s__Rotating)
          & s__attribute(V__RO1,V__DIR1)
          & s__instance(V__RO2,s__Rotating)
          & s__attribute(V__RO2,V__DIR2)
          & s__instance(V__DIR1,s__RotationalAttribute)
          & s__instance(V__DIR2,s__RotationalAttribute)
          & V__RO1 != V__RO2
          & s__causes(V__RO1,V__RO2)
          & s__patient(V__RO1,s__Ratchet)
          & s__patient(V__RO2,V__A) )
       => V__DIR1 = V__DIR2 ) ) ).

fof(kb_SUMO_1641,axiom,
    s__subclass(s__RotationalAttribute,s__DirectionAttribute) ).

fof(kb_SUMO_1642,axiom,
    s__instance(s__RotationalAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_1643,axiom,
    s__instance(s__DirectionAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_1644,axiom,
    s__instance(s__Clockwise,s__RotationalAttribute) ).

fof(kb_SUMO_1645,axiom,
    s__termFormat(s__EnglishLanguage,s__Clockwise,clockwise) ).

fof(kb_SUMO_1646,axiom,
    s__documentation(s__Clockwise,s__EnglishLanguage,'The &%direction in which the hands of a modern &%Clock move when reading the clock.') ).

fof(kb_SUMO_1647,axiom,
    s__instance(s__CounterClockwise,s__RotationalAttribute) ).

fof(kb_SUMO_1648,axiom,
    s__termFormat(s__EnglishLanguage,s__CounterClockwise,'counter-clockwise') ).

fof(kb_SUMO_1649,axiom,
    s__documentation(s__CounterClockwise,s__EnglishLanguage,'The opposite &%direction from which the hands of a modern &%Clock move when reading the clock.') ).

fof(kb_SUMO_1650,axiom,
    s__contraryAttribute_2(s__Clockwise,s__CounterClockwise) ).

fof(kb_SUMO_1651,axiom,
    s__subclass(s__SnapOnRatchet,s__Ratchet) ).

fof(kb_SUMO_1652,axiom,
    s__instance(s__SnapOnRatchet__t,s__SetOrClass) ).

fof(kb_SUMO_1653,axiom,
    s__instance(s__Ratchet__t,s__SetOrClass) ).

fof(kb_SUMO_1654,axiom,
    s__termFormat(s__EnglishLanguage,s__SnapOnRatchet,'Snap-On ratchet') ).

fof(kb_SUMO_1655,axiom,
    s__manufacturer(s__SnapOnRatchet,s__SnapOnTools) ).

fof(kb_SUMO_1656,axiom,
    s__subclass(s__ChevroletAutomobile,s__Automobile) ).

fof(kb_SUMO_1657,axiom,
    s__instance(s__ChevroletAutomobile__t,s__SetOrClass) ).

fof(kb_SUMO_1658,axiom,
    s__manufacturer(s__ChevroletAutomobile,s__GeneralMotorsCorp) ).

fof(kb_SUMO_1659,axiom,
    s__subclass(s__ChevroletEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1660,axiom,
    s__instance(s__ChevroletEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1661,axiom,
    s__typicalPart(s__ChevroletEngine,s__ChevroletAutomobile) ).

fof(kb_SUMO_1662,axiom,
    s__typicallyContainsPart(s__ChevroletEngine,s__ChevroletAutomobile) ).

fof(kb_SUMO_1663,axiom,
    s__subclass(s__Chevrolet350Engine,s__ChevroletEngine) ).

fof(kb_SUMO_1664,axiom,
    s__instance(s__Chevrolet350Engine__t,s__SetOrClass) ).

fof(kb_SUMO_1665,axiom,
    s__instance(s__engineDisplacement__m,s__BinaryRelation) ).

fof(kb_SUMO_1666,axiom,
    s__domain(s__engineDisplacement__m,"1",s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1667,axiom,
    s__domain(s__engineDisplacement__m,"2",s__VolumeMeasure) ).

fof(kb_SUMO_1668,axiom,
    s__documentation(s__engineDisplacement__m,s__EnglishLanguage,'The total &%VolumeMeasure of all the &%EngineCylinders.') ).

fof(kb_SUMO_1669,axiom,
    s__subclass(s__Mud,s__Soil) ).

fof(kb_SUMO_1670,axiom,
    s__instance(s__Mud__t,s__SetOrClass) ).

fof(kb_SUMO_1671,axiom,
    s__documentation(s__Mud,s__EnglishLanguage,'A &%Mixture of &%Soil and &%Water.') ).

fof(kb_SUMO_1672,axiom,
    s__termFormat(s__EnglishLanguage,s__Mud,mud) ).

fof(kb_SUMO_1673,axiom,
    ! [V__M] :
      ( s__instance(V__M,s__Object)
     => ( s__instance(V__M,s__Mud)
       => ? [V__W] :
            ( s__instance(V__W,s__Object)
            & s__instance(V__W,s__Water)
            & s__part(V__W,V__M) ) ) ) ).

fof(kb_SUMO_1674,axiom,
    s__subclass(s__MudTire,s__Tire) ).

fof(kb_SUMO_1675,axiom,
    s__instance(s__MudTire__t,s__SetOrClass) ).

fof(kb_SUMO_1676,axiom,
    s__instance(s__Tire__t,s__SetOrClass) ).

fof(kb_SUMO_1677,axiom,
    s__documentation(s__MudTire,s__EnglishLanguage,'A &%Tire designed to be used for &%Driving in &%Mud.') ).

fof(kb_SUMO_1678,axiom,
    s__termFormat(s__EnglishLanguage,s__MudTire,'mud tire') ).

fof(kb_SUMO_1679,axiom,
    s__termFormat(s__EnglishLanguage,s__MudTire,'mud tyre') ).

fof(kb_SUMO_1680,axiom,
    ! [V__MT] :
      ( s__instance(V__MT,s__Object)
     => ( s__instance(V__MT,s__MudTire)
       => s__hasPurpose(V__MT,'(? [V__M] : (s__instance(V__M,s__Object) & s__instance(V__M,s__Mud) & s__meetsSpatially(V__MT,V__M)))') ) ) ).

fof(kb_SUMO_1681,axiom,
    s__subclass(s__PeterbiltCorp,s__Corporation) ).

fof(kb_SUMO_1682,axiom,
    s__instance(s__PeterbiltCorp__t,s__SetOrClass) ).

fof(kb_SUMO_1683,axiom,
    s__headquartersOfOrganization(s__PeterbiltCorp,s__Texas) ).

fof(kb_SUMO_1684,axiom,
    s__termFormat(s__EnglishLanguage,s__PeterbiltCorp,'Peterbilt') ).

fof(kb_SUMO_1685,axiom,
    s__documentation(s__PeterbiltCorp,s__EnglishLanguage,'An American &%manufacturer of &%TruckTractors that was one of the first truck makers.') ).

fof(kb_SUMO_1686,axiom,
    s__subclass(s__PeterbiltTruck,s__TruckTractor) ).

fof(kb_SUMO_1687,axiom,
    s__instance(s__PeterbiltTruck__t,s__SetOrClass) ).

fof(kb_SUMO_1688,axiom,
    s__instance(s__TruckTractor__t,s__SetOrClass) ).

fof(kb_SUMO_1689,axiom,
    s__manufacturer(s__PeterbiltTruck,s__PeterbiltCorp) ).

fof(kb_SUMO_1690,axiom,
    s__termFormat(s__EnglishLanguage,s__PeterbiltTruck,'Peterbilt') ).

fof(kb_SUMO_1691,axiom,
    s__termFormat(s__EnglishLanguage,s__PeterbiltTruck,'Peterbilt truck') ).

fof(kb_SUMO_1692,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__instance(V__S,s__Seat)
       => s__hasPurpose(V__S,'(? [V__H,V__T] : (s__instance(V__T,s__TimePosition) & s__instance(V__H,s__Object) & s__instance(V__H,s__Human) & s__holdsDuring(V__T,(s__attribute(V__H,s__Sitting) & s__located(V__H,V__S)))))') ) ) ).

fof(kb_SUMO_1693,axiom,
    s__subclass(s__VehicleSeat,s__Artifact) ).

fof(kb_SUMO_1694,axiom,
    s__instance(s__VehicleSeat__t,s__SetOrClass) ).

fof(kb_SUMO_1695,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__instance(V__S,s__VehicleSeat)
       => s__hasPurpose(V__S,'(? [V__H,V__T,V__V] : (s__instance(V__V,s__Object) & s__instance(V__T,s__TimePosition) & s__instance(V__H,s__Object) & s__instance(V__H,s__Human) & s__instance(V__V,s__Vehicle) & s__holdsDuring(V__T,(s__attribute(V__H,s__Sitting) & s__located(V__H,V__S) & s__located(V__S,V__V)))))') ) ) ).

fof(kb_SUMO_1696,axiom,
    s__subclass(s__AutomobileSeat,s__VehicleSeat) ).

fof(kb_SUMO_1697,axiom,
    s__instance(s__AutomobileSeat__t,s__SetOrClass) ).

fof(kb_SUMO_1698,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileSeat,'car seat') ).

fof(kb_SUMO_1699,axiom,
    s__termFormat(s__EnglishLanguage,s__AutomobileSeat,'auto seat') ).

fof(kb_SUMO_1700,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__instance(V__S,s__AutomobileSeat)
       => s__hasPurpose(V__S,'(? [V__H,V__T,V__V] : (s__instance(V__V,s__Object) & s__instance(V__T,s__TimePosition) & s__instance(V__H,s__Object) & s__instance(V__H,s__Human) & s__instance(V__V,s__Automobile) & s__holdsDuring(V__T,(s__attribute(V__H,s__Sitting) & s__located(V__H,V__S) & s__located(V__S,V__V)))))') ) ) ).

fof(kb_SUMO_1701,axiom,
    s__subclass(s__BoatSeat,s__VehicleSeat) ).

fof(kb_SUMO_1702,axiom,
    s__instance(s__BoatSeat__t,s__SetOrClass) ).

fof(kb_SUMO_1703,axiom,
    s__termFormat(s__EnglishLanguage,s__BoatSeat,'boat seat') ).

fof(kb_SUMO_1704,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__instance(V__S,s__BoatSeat)
       => s__hasPurpose(V__S,'(? [V__H,V__T,V__V] : (s__instance(V__V,s__Object) & s__instance(V__T,s__TimePosition) & s__instance(V__H,s__Object) & s__instance(V__H,s__Human) & s__instance(V__V,s__WaterVehicle) & s__holdsDuring(V__T,(s__attribute(V__H,s__Sitting) & s__located(V__H,V__S) & s__located(V__S,V__V)))))') ) ) ).

fof(kb_SUMO_1705,axiom,
    s__subclass(s__ElectricLightFixture,s__LightFixture) ).

fof(kb_SUMO_1706,axiom,
    s__subclass(s__ElectricLightFixture,s__ElectricDevice) ).

fof(kb_SUMO_1707,axiom,
    s__instance(s__ElectricLightFixture__t,s__SetOrClass) ).

fof(kb_SUMO_1708,axiom,
    s__subclass(s__IncandescentLightFixture,s__ElectricLightFixture) ).

fof(kb_SUMO_1709,axiom,
    s__instance(s__IncandescentLightFixture__t,s__SetOrClass) ).

fof(kb_SUMO_1710,axiom,
    s__subclass(s__LEDLightFixture,s__ElectricLightFixture) ).

fof(kb_SUMO_1711,axiom,
    s__instance(s__LEDLightFixture__t,s__SetOrClass) ).

fof(kb_SUMO_1712,axiom,
    s__subclass(s__FluorescentLightFixture,s__ElectricLightFixture) ).

fof(kb_SUMO_1713,axiom,
    s__instance(s__FluorescentLightFixture__t,s__SetOrClass) ).

fof(kb_SUMO_1714,axiom,
    s__subclass(s__LightBulb,s__ElectricLightFixture) ).

fof(kb_SUMO_1715,axiom,
    s__termFormat(s__EnglishLanguage,s__LightBulb,'light bulb') ).

fof(kb_SUMO_1716,axiom,
    s__documentation(s__LightBulb,s__EnglishLanguage,'The smallest removable &%LightFixture that is the component that emits light.') ).

fof(kb_SUMO_1717,axiom,
    ! [V__F] :
      ( s__instance(V__F,s__Object)
     => ( s__instance(V__F,s__LightBulb)
       => s__capability(s__RadiatingLight,s__instrument__m,V__F) ) ) ).

fof(kb_SUMO_1718,axiom,
    s__typicalPart(s__LightBulb,s__LightFixture) ).

fof(kb_SUMO_1719,axiom,
    s__typicallyContainsPart(s__LightBulb,s__LightFixture) ).

fof(kb_SUMO_1720,axiom,
    s__subclass(s__LED,s__LightBulb) ).

fof(kb_SUMO_1721,axiom,
    s__instance(s__LED__t,s__SetOrClass) ).

fof(kb_SUMO_1722,axiom,
    s__termFormat(s__EnglishLanguage,s__LED,'LED') ).

fof(kb_SUMO_1723,axiom,
    s__termFormat(s__EnglishLanguage,s__LED,'LED light') ).

fof(kb_SUMO_1724,axiom,
    s__subclass(s__FluorescentLightBulb,s__LightBulb) ).

fof(kb_SUMO_1725,axiom,
    s__instance(s__FluorescentLightBulb__t,s__SetOrClass) ).

fof(kb_SUMO_1726,axiom,
    s__termFormat(s__EnglishLanguage,s__FluorescentLightBulb,'fluorescent light bulb') ).

fof(kb_SUMO_1727,axiom,
    s__subclass(s__IncandescentLightBulb,s__LightBulb) ).

fof(kb_SUMO_1728,axiom,
    s__instance(s__IncandescentLightBulb__t,s__SetOrClass) ).

fof(kb_SUMO_1729,axiom,
    s__instance(s__LightBulb__t,s__SetOrClass) ).

fof(kb_SUMO_1730,axiom,
    s__termFormat(s__EnglishLanguage,s__IncandescentLightBulb,'incandescent light bulb') ).

fof(kb_SUMO_1731,axiom,
    s__termFormat(s__EnglishLanguage,s__IncandescentLightBulb,'light bulb') ).

fof(kb_SUMO_1732,axiom,
    s__instance(s__SortimoCorp,s__Corporation) ).

fof(kb_SUMO_1733,axiom,
    s__termFormat(s__EnglishLanguage,s__SortimoCorp,'Sortimo Corporation') ).

fof(kb_SUMO_1734,axiom,
    s__headquartersOfOrganization(s__SortimoCorp,s__Germany) ).

fof(kb_SUMO_1735,axiom,
    ? [V__T] :
      ( s__instance(V__T,s__SetOrClass)
      & s__instance(V__T,s__Agent)
      & s__subclass(V__T,s__Toolbox)
      & s__manufacturer(s__SortimoCorp,V__T) ) ).

fof(kb_SUMO_1736,axiom,
    s__subclass(s__GMLs1V8engine,s__EightCylinderEngine) ).

fof(kb_SUMO_1737,axiom,
    s__instance(s__GMLs1V8engine__t,s__SetOrClass) ).

fof(kb_SUMO_1738,axiom,
    s__termFormat(s__EnglishLanguage,s__GMLs1V8engine,'ls1 engine') ).

fof(kb_SUMO_1739,axiom,
    s__manufacturer(s__GMLs1V8engine,s__GeneralMotorsCorp) ).

fof(kb_SUMO_1740,axiom,
    s__subclass(s__Corvette,s__Automobile) ).

fof(kb_SUMO_1741,axiom,
    s__instance(s__Corvette__t,s__SetOrClass) ).

fof(kb_SUMO_1742,axiom,
    s__termFormat(s__EnglishLanguage,s__Corvette,'Corvette') ).

fof(kb_SUMO_1743,axiom,
    s__manufacturer(s__Corvette,s__GeneralMotorsCorp) ).

fof(kb_SUMO_1744,axiom,
    s__typicalPart(s__GMLs1V8engine,s__Corvette) ).

fof(kb_SUMO_1745,axiom,
    s__instance(s__UsedItem,s__RelationalAttribute) ).

fof(kb_SUMO_1746,axiom,
    s__documentation(s__UsedItem,s__EnglishLanguage,'An item that is used in a retail sense, that it has been purchased by a customer. Note that it need not have actually been used for its intended purpose.') ).

fof(kb_SUMO_1747,axiom,
    s__termFormat(s__EnglishLanguage,s__UsedItem,used) ).

fof(kb_SUMO_1748,axiom,
    ! [V__O] :
      ( s__instance(V__O,s__Object)
     => ( s__attribute(V__O,s__UsedItem)
       => ? [V__B] :
            ( s__instance(V__B,s__Buying)
            & s__objectTransfered(V__B,V__O) ) ) ) ).

fof(kb_SUMO_1749,axiom,
    s__instance(s__NewItem,s__RelationalAttribute) ).

fof(kb_SUMO_1750,axiom,
    s__documentation(s__NewItem,s__EnglishLanguage,'An item that is new in a retail sense, that it has not been purchased by a customer.') ).

fof(kb_SUMO_1751,axiom,
    s__termFormat(s__EnglishLanguage,s__NewItem,new) ).

fof(kb_SUMO_1752,axiom,
    s__contraryAttribute_2(s__UsedItem,s__NewItem) ).

fof(kb_SUMO_1753,axiom,
    ! [V__O] :
      ( s__instance(V__O,s__Object)
     => ( s__attribute(V__O,s__NewItem)
       => ~ ? [V__B] :
              ( s__instance(V__B,s__Buying)
              & s__objectTransfered(V__B,V__O) ) ) ) ).

fof(kb_SUMO_1754,axiom,
    s__instance(s__IconMotorcyleEquipmentCorporation,s__Corporation) ).

fof(kb_SUMO_1755,axiom,
    s__termFormat(s__EnglishLanguage,s__IconMotorcyleEquipmentCorporation,'Icon') ).

fof(kb_SUMO_1756,axiom,
    s__termFormat(s__EnglishLanguage,s__IconMotorcyleEquipmentCorporation,'Icon Corporation') ).

fof(kb_SUMO_1757,axiom,
    s__subclass(s__IconHelmet,s__MotorcycleHelmet) ).

fof(kb_SUMO_1758,axiom,
    s__instance(s__IconHelmet__t,s__SetOrClass) ).

fof(kb_SUMO_1759,axiom,
    s__manufacturer(s__IconHelmet,s__IconMotorcyleEquipmentCorporation) ).

fof(kb_SUMO_1760,axiom,
    s__termFormat(s__EnglishLanguage,s__IconHelmet,'Icon helmet') ).

fof(kb_SUMO_1761,axiom,
    s__instance(s__CosworthCorp,s__Corporation) ).

fof(kb_SUMO_1762,axiom,
    s__headquartersOfOrganization(s__CosworthCorp,s__England) ).

fof(kb_SUMO_1763,axiom,
    s__termFormat(s__EnglishLanguage,s__CosworthCorp,'Cosworth Corporation') ).

fof(kb_SUMO_1764,axiom,
    s__documentation(s__CosworthCorp,s__EnglishLanguage,'A British &%manufacturer of high performance &%Automobile &%Engines and equipment.') ).

fof(kb_SUMO_1765,axiom,
    s__subclass(s__CosworthEngine,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1766,axiom,
    s__instance(s__CosworthEngine__t,s__SetOrClass) ).

fof(kb_SUMO_1767,axiom,
    s__manufacturer(s__CosworthEngine,s__CosworthCorp) ).

fof(kb_SUMO_1768,axiom,
    s__termFormat(s__EnglishLanguage,s__CosworthEngine,'Cosworth engine') ).

fof(kb_SUMO_1769,axiom,
    s__subclass(s__GasCompressor,s__Machine) ).

fof(kb_SUMO_1770,axiom,
    s__instance(s__GasCompressor__t,s__SetOrClass) ).

fof(kb_SUMO_1771,axiom,
    s__termFormat(s__EnglishLanguage,s__GasCompressor,compressor) ).

fof(kb_SUMO_1772,axiom,
    s__documentation(s__GasCompressor,s__EnglishLanguage,'Any device designed for &%Compressing a &%Gas. This includes compressors designed for refrigeration applications as well as air tools.') ).

fof(kb_SUMO_1773,axiom,
    ! [V__GC] :
      ( s__instance(V__GC,s__Object)
     => ( s__instance(V__GC,s__GasCompressor)
       => s__hasPurpose(V__GC,'(? [V__C,V__G] : (s__instance(V__G,s__Object) & s__instance(V__C,s__Process) & s__instance(V__C,s__Compressing) & s__attribute(V__G,s__Gas) & s__patient(V__C,V__G) & s__instrument(V__C,V__GC)))') ) ) ).

fof(kb_SUMO_1774,axiom,
    s__subclass(s__Supercharger,s__GasCompressor) ).

fof(kb_SUMO_1775,axiom,
    s__instance(s__Supercharger__t,s__SetOrClass) ).

fof(kb_SUMO_1776,axiom,
    s__typicalPart(s__Supercharger,s__IntermittentCombustionEngine) ).

fof(kb_SUMO_1777,axiom,
    s__documentation(s__Supercharger,s__EnglishLanguage,'A &%Device that injects compressed &%Air into the intake of a &%Vehicle &%Engine. By effectively increasing the amount of &%Oxygen in the &%CombustionChamber, it increases the power and efficiency and the engine.') ).

fof(kb_SUMO_1778,axiom,
    s__termFormat(s__EnglishLanguage,s__Supercharger,supercharger) ).

fof(kb_SUMO_1779,axiom,
    ! [V__S] :
      ( s__instance(V__S,s__Object)
     => ( s__instance(V__S,s__Supercharger)
       => s__hasPurpose(V__S,'(? [V__T,V__IV,V__A] : (s__instance(V__A,s__Object) & s__instance(V__T,s__Transfer) & s__instance(V__T,s__GasMotion) & s__origin(V__T,V__S) & s__instance(V__IV,s__IntakeValve) & s__destination(V__T,V__IV) & s__instance(V__A,s__Air) & s__objectTransferred(V__T,V__A) & s__holdsDuring(s__WhenFn(V__T),s__attribute(V__A,s__Pressurized))))') ) ) ).

fof(kb_SUMO_1780,axiom,
    s__subclass(s__Catalog,s__Proposition) ).

fof(kb_SUMO_1781,axiom,
    s__instance(s__Catalog__t,s__SetOrClass) ).

fof(kb_SUMO_1782,axiom,
    s__documentation(s__Catalog,s__EnglishLanguage,'a &%Catalog is a &%Proposition of the classes of resources that an agent provides or offers') ).

fof(kb_SUMO_1783,axiom,
    s__termFormat(s__EnglishLanguage,s__Catalog,catalog) ).

fof(kb_SUMO_1784,axiom,
    ! [V__CATALOG,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__CATALOG,s__Abstract) )
     => ( s__instance(V__CATALOG,s__Catalog)
       => ? [V__X] :
            ( s__instance(V__X,s__SetOrClass)
            & s__subclass(V__X,s__Agent)
            & s__offers(V__AGENT,V__CATALOG) ) ) ) ).

fof(kb_SUMO_1785,axiom,
    s__instance(s__catalogItem__m,s__BinaryRelation) ).

fof(kb_SUMO_1786,axiom,
    s__documentation(s__catalogItem__m,s__EnglishLanguage,'(&%catalogItem ?OBJ ?CATALOG) means that an instance of ?OBJ is a member of ?CATALOG') ).

fof(kb_SUMO_1787,axiom,
    s__domainSubclass(s__catalogItem__m,"1",s__Entity) ).

fof(kb_SUMO_1788,axiom,
    s__domain(s__catalogItem__m,"2",s__Catalog) ).

fof(kb_SUMO_1789,axiom,
    ! [V__OBJ,V__CATALOG,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__CATALOG,s__Catalog)
        & s__instance(V__OBJ,s__SetOrClass) )
     => ( ( s__offers(V__AGENT,V__CATALOG)
          & s__catalogItem(V__OBJ,V__CATALOG)
          & s__subclass(V__OBJ,s__Physical) )
       => s__modalAttribute('(? [V__S,V__X] : (s__instance(V__S,s__Process) & s__instance(V__X,V__OBJ) & s__instance(V__S,s__Selling) & s__agent(V__S,V__AGENT) & s__patient(V__S,V__X)))',s__Possibility) ) ) ).

fof(kb_SUMO_1790,axiom,
    ! [V__CATALOG,V__PROP,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__PROP,s__SetOrClass)
        & s__instance(V__PROP,s__Proposition)
        & s__instance(V__CATALOG,s__Catalog) )
     => ( ( s__offers(V__AGENT,V__CATALOG)
          & s__catalogItem(V__PROP,V__CATALOG)
          & s__subclass(V__PROP,s__Proposition) )
       => s__modalAttribute('(? [V__S,V__X] : (s__instance(V__X,s__Process) & s__instance(V__S,s__Process) & s__realization(V__X,V__PROP) & s__instance(V__S,s__Selling) & s__patient(V__S,V__X) & s__agent(V__S,V__AGENT)))',s__Possibility) ) ) ).

fof(kb_SUMO_1791,axiom,
    s__documentation(s__offers__m,s__EnglishLanguage,'(&%offers ?AGENT ?CATALOG) means that ?AGENT offers items of ?CATALOG to its customers') ).

fof(kb_SUMO_1792,axiom,
    s__instance(s__offers__m,s__BinaryPredicate) ).

fof(kb_SUMO_1793,axiom,
    s__domain(s__offers__m,"1",s__Agent) ).

fof(kb_SUMO_1794,axiom,
    s__domain(s__offers__m,"2",s__Abstract) ).

fof(kb_SUMO_1795,axiom,
    s__termFormat(s__EnglishLanguage,s__offers__m,offers) ).

fof(kb_SUMO_1796,axiom,
    ! [V__CLASS,V__CATALOG,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__CATALOG,s__Catalog)
        & s__instance(V__CLASS,s__SetOrClass) )
     => ( ( s__offers(V__AGENT,V__CATALOG)
          & s__catalogItem(V__CLASS,V__CATALOG)
          & s__subclass(V__CLASS,s__Process) )
       => s__capability(V__CLASS,s__agent__m,V__AGENT) ) ) ).

fof(kb_SUMO_1797,axiom,
    ! [V__OBJ,V__CLASS,V__PROCESSINST,V__PROCESS,V__CATALOG,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__CATALOG,s__Catalog)
        & s__instance(V__PROCESS,s__SetOrClass)
        & s__instance(V__PROCESSINST,s__Process)
        & s__instance(V__CLASS,s__SetOrClass) )
     => ( ( s__offers(V__AGENT,V__CATALOG)
          & s__catalogItem(V__CLASS,V__CATALOG)
          & s__subclass(V__CLASS,s__Object)
          & s__instance(V__PROCESSINST,V__PROCESS)
          & s__subclass(V__PROCESS,s__Process)
          & s__instance(V__OBJ,V__CLASS)
          & s__patient(V__PROCESSINST,V__OBJ) )
       => s__capability(V__PROCESS,s__agent__m,V__AGENT) ) ) ).

fof(kb_SUMO_1798,axiom,
    ! [V__ATTR,V__AGENT] :
      ( s__instance(V__AGENT,s__Agent)
     => ( ( s__offers(V__AGENT,V__ATTR)
          & s__instance(V__ATTR,s__Attribute) )
       => s__modalAttribute('(? [V__OBJ,V__SELL] : (s__instance(V__SELL,s__Process) & s__instance(V__OBJ,s__Object) & s__instance(V__SELL,s__Selling) & s__attribute(V__OBJ,V__ATTR) & s__patient(V__SELL,V__OBJ) & s__agent(V__SELL,V__AGENT)))',s__Possibility) ) ) ).

fof(kb_SUMO_1799,axiom,
    s__documentation(s__offersAtTime__m,s__EnglishLanguage,'(%&offersAtTime ?AGENT ?CATALOG ?TIMEINT) means that ?AGENT offers items of ?CATALOG to its customer only during the specified ?TIMEINT') ).

fof(kb_SUMO_1800,axiom,
    s__instance(s__offersAtTime__m,s__TernaryPredicate) ).

fof(kb_SUMO_1801,axiom,
    s__domain(s__offersAtTime__m,"1",s__Agent) ).

fof(kb_SUMO_1802,axiom,
    s__domain(s__offersAtTime__m,"2",s__Entity) ).

fof(kb_SUMO_1803,axiom,
    s__domain(s__offersAtTime__m,"3",s__TimeInterval) ).

fof(kb_SUMO_1804,axiom,
    ! [V__CLASS,V__CATALOG,V__AGENT,V__TIMEINT] :
      ( ( s__subclass(V__TIMEINT,s__TimeInterval)
        & s__instance(V__TIMEINT,s__TimeInterval)
        & s__instance(V__TIMEINT,s__SetOrClass)
        & s__instance(V__AGENT,s__Agent)
        & s__instance(V__CATALOG,s__Catalog)
        & s__instance(V__CLASS,s__SetOrClass) )
     => ( ( s__offersAtTime(V__AGENT,V__CATALOG,V__TIMEINT)
          & s__catalogItem(V__CLASS,V__CATALOG)
          & s__subclass(V__CLASS,s__Process) )
       => s__capabilityDuring(V__CLASS,s__agent__m,V__AGENT,V__TIMEINT) ) ) ).

fof(kb_SUMO_1805,axiom,
    ! [V__OBJ,V__CLASS,V__PROCESS,V__CATALOG,V__AGENT,V__PROCESSINSTANCE,V__TIMEINT] :
      ( ( s__subclass(V__TIMEINT,s__TimeInterval)
        & s__instance(V__TIMEINT,s__TimeInterval)
        & s__instance(V__TIMEINT,s__SetOrClass)
        & s__instance(V__PROCESSINSTANCE,s__Process)
        & s__instance(V__AGENT,s__Agent)
        & s__instance(V__CATALOG,s__Catalog)
        & s__instance(V__PROCESS,s__SetOrClass)
        & s__instance(V__CLASS,s__SetOrClass) )
     => ( ( s__offersAtTime(V__AGENT,V__CATALOG,V__TIMEINT)
          & s__catalogItem(V__CLASS,V__CATALOG)
          & s__subclass(V__CLASS,s__Object)
          & s__instance(V__PROCESSINSTANCE,V__PROCESS)
          & s__subclass(V__PROCESS,s__Process)
          & s__instance(V__OBJ,V__CLASS)
          & s__patient(V__PROCESSINSTANCE,V__OBJ) )
       => s__capabilityDuring(V__PROCESS,s__agent__m,V__AGENT,V__TIMEINT) ) ) ).

%FOL fof(kb_SUMO_1806,axiom,(( (! [V__ATTR,V__AGENT,V__TIMEINT] : ((s__instance(V__TIMEINT,s__TimeInterval) & s__instance(V__AGENT,s__Agent) & s__instance(V__ATTR,s__Abstract)) => ((s__offersAtTime(V__AGENT,V__ATTR,V__TIMEINT) & s__instance(V__ATTR,s__Attribute)) => s__holdsDuring(V__TIMEINT,'s__offers(V__AGENT,V__ATTR)')))) ))).

fof(kb_SUMO_1807,axiom,
    s__instance(s__buys__m,s__TernaryPredicate) ).

fof(kb_SUMO_1808,axiom,
    s__documentation(s__buys__m,s__EnglishLanguage,'(&%buys ?CUST ?AGENT ?ENT) means that &%Agent ?CUST performs &%Buying of &%Entity ?ENT from &%Agent ?AGENT') ).

fof(kb_SUMO_1809,axiom,
    s__termFormat(s__EnglishLanguage,s__buys__m,buys) ).

fof(kb_SUMO_1810,axiom,
    s__domain(s__buys__m,"1",s__CognitiveAgent) ).

fof(kb_SUMO_1811,axiom,
    s__domain(s__buys__m,"2",s__CognitiveAgent) ).

fof(kb_SUMO_1812,axiom,
    s__domain(s__buys__m,"3",s__Entity) ).

fof(kb_SUMO_1813,axiom,
    ! [V__ITEM,V__AGENT,V__CUST] :
      ( ( s__instance(V__CUST,s__CognitiveAgent)
        & s__instance(V__AGENT,s__CognitiveAgent) )
     => ( ( s__buys(V__CUST,V__AGENT,V__ITEM)
          & s__instance(V__ITEM,s__Physical) )
       => ? [V__TRANS] :
            ( s__instance(V__TRANS,s__Process)
            & s__instance(V__TRANS,s__Buying)
            & s__patient(V__TRANS,V__ITEM)
            & s__agent(V__TRANS,V__CUST)
            & s__origin(V__TRANS,V__AGENT) ) ) ) ).

fof(kb_SUMO_1814,axiom,
    ! [V__ITEM,V__AGENT,V__CUST] :
      ( ( s__instance(V__CUST,s__CognitiveAgent)
        & s__instance(V__AGENT,s__CognitiveAgent) )
     => ( ( s__buys(V__CUST,V__AGENT,V__ITEM)
          & s__instance(V__ITEM,s__Proposition) )
       => ? [V__TRANS,V__PROC] :
            ( s__instance(V__PROC,s__Process)
            & s__instance(V__TRANS,s__Process)
            & s__realization(V__PROC,V__ITEM)
            & s__instance(V__TRANS,s__Buying)
            & s__patient(V__TRANS,V__PROC)
            & s__origin(V__TRANS,V__AGENT) ) ) ) ).

fof(kb_SUMO_1815,axiom,
    s__instance(s__rents__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_1816,axiom,
    s__documentation(s__rents__m,s__EnglishLanguage,'(&%rents ?CUST ?AGENT ?OBJ ?TI) means that for &%TimeInterval ?TI, &%CognitiveAgent ?CUST is &%Renting &%Object ?OBJ from &%CognitiveAgent ?AGENT') ).

fof(kb_SUMO_1817,axiom,
    s__termFormat(s__EnglishLanguage,s__rents__m,rents) ).

fof(kb_SUMO_1818,axiom,
    s__domain(s__rents__m,"1",s__CognitiveAgent) ).

fof(kb_SUMO_1819,axiom,
    s__domain(s__rents__m,"2",s__CognitiveAgent) ).

fof(kb_SUMO_1820,axiom,
    s__domain(s__rents__m,"3",s__Object) ).

fof(kb_SUMO_1821,axiom,
    s__domain(s__rents__m,"4",s__TimeInterval) ).

fof(kb_SUMO_1822,axiom,
    ! [V__OBJ,V__TI,V__AGENT,V__CUST] :
      ( ( s__instance(V__CUST,s__CognitiveAgent)
        & s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__TI,s__TimeInterval)
        & s__instance(V__OBJ,s__Object) )
     => ( s__rents(V__CUST,V__AGENT,V__OBJ,V__TI)
       => s__holdsDuring(V__TI,'(? [V__RENT] : (s__instance(V__RENT,s__Process) & s__instance(V__RENT,s__Renting) & s__patient(V__RENT,V__OBJ) & s__agent(V__RENT,V__CUST) & s__possesses(V__AGENT,V__OBJ)))') ) ) ).

fof(kb_SUMO_1823,axiom,
    s__instance(s__propositionOwner__m,s__BinaryPredicate) ).

fof(kb_SUMO_1824,axiom,
    s__documentation(s__propositionOwner__m,s__EnglishLanguage,'(&%propositionOwner ?AGENT ?PROP) means that &%CognitiveAgent ?AGENT was the one who conceptualized or created the &%Proposition ?PROP') ).

fof(kb_SUMO_1825,axiom,
    s__termFormat(s__EnglishLanguage,s__propositionOwner__m,'proposition owner') ).

fof(kb_SUMO_1826,axiom,
    s__domain(s__propositionOwner__m,"1",s__CognitiveAgent) ).

fof(kb_SUMO_1827,axiom,
    s__domain(s__propositionOwner__m,"2",s__Proposition) ).

fof(kb_SUMO_1828,axiom,
    ! [V__AGENT,V__PROP,V__CREATE] :
      ( ( s__instance(V__CREATE,s__Process)
        & s__instance(V__AGENT,s__CognitiveAgent) )
     => ( ( s__instance(V__CREATE,s__Creation)
          & s__result(V__CREATE,V__PROP)
          & s__instance(V__PROP,s__Proposition)
          & s__agent(V__CREATE,V__AGENT) )
       => s__propositionOwner(V__AGENT,V__PROP) ) ) ).

fof(kb_SUMO_1829,axiom,
    s__subclass(s__PricingScheme,s__Proposition) ).

fof(kb_SUMO_1830,axiom,
    s__instance(s__PricingScheme__t,s__SetOrClass) ).

fof(kb_SUMO_1831,axiom,
    s__documentation(s__PricingScheme,s__EnglishLanguage,'&%PricingScheme refers to the conditions attached to the price of a product of service') ).

fof(kb_SUMO_1832,axiom,
    s__termFormat(s__EnglishLanguage,s__PricingScheme,'pricing scheme') ).

fof(kb_SUMO_1833,axiom,
    ! [V__PS] :
      ( s__instance(V__PS,s__PricingScheme)
     => ? [V__AGENT,V__CREATE] :
          ( s__instance(V__CREATE,s__Process)
          & s__instance(V__AGENT,s__Agent)
          & s__instance(V__CREATE,s__Creation)
          & s__result(V__CREATE,V__PS)
          & s__agent(V__CREATE,V__AGENT) ) ) ).

fof(kb_SUMO_1834,axiom,
    s__instance(s__priceRange__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_1835,axiom,
    s__documentation(s__priceRange__m,s__EnglishLanguage,'(&%priceRange ?OBJ ?MIN ?MAX ?AGENT) means that &%Agent ?AGENT attaches range of possible &%productPrice for ?OBJ with minimum ?MIN and maximum ?MAX') ).

fof(kb_SUMO_1836,axiom,
    s__termFormat(s__EnglishLanguage,s__priceRange__m,'price range') ).

fof(kb_SUMO_1837,axiom,
    s__domainSubclass(s__priceRange__m,"1",s__Entity) ).

fof(kb_SUMO_1838,axiom,
    s__domain(s__priceRange__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_1839,axiom,
    s__domain(s__priceRange__m,"3",s__CurrencyMeasure) ).

fof(kb_SUMO_1840,axiom,
    s__domain(s__priceRange__m,"4",s__Agent) ).

fof(kb_SUMO_1841,axiom,
    ! [V__MIN,V__MAX,V__AGENT,V__ENT] :
      ( ( s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__MAX,s__CurrencyMeasure)
        & s__instance(V__MIN,s__CurrencyMeasure) )
     => ( s__priceRange(V__ENT,V__MIN,V__MAX,V__AGENT)
       => ? [V__PRICE,V__PS] :
            ( s__instance(V__PS,s__PricingScheme)
            & s__instance(V__PRICE,s__CurrencyMeasure)
            & s__instance(V__PRICE,s__FunctionQuantity)
            & lesseq(V__PRICE,V__MAX)
            & greatereq(V__PRICE,V__MIN)
            & ( s__publishedPrice(V__ENT,V__PRICE,V__AGENT,V__PS)
              | s__productPrice(V__ENT,V__PRICE,V__AGENT)
              | s__unitPrice(V__ENT,V__PRICE,V__AGENT,V__PS) ) ) ) ) ).

fof(kb_SUMO_1842,axiom,
    s__instance(s__validFor__m,s__BinaryPredicate) ).

fof(kb_SUMO_1843,axiom,
    s__documentation(s__validFor__m,s__EnglishLanguage,'(&%validFor ?SCHEME ?AGENT) means that &%CurrencyMeasure that &%PricingScheme refers to applies to &%Agent ?AGENT') ).

fof(kb_SUMO_1844,axiom,
    s__termFormat(s__EnglishLanguage,s__validFor__m,'valid for') ).

fof(kb_SUMO_1845,axiom,
    s__domain(s__validFor__m,"1",s__PricingScheme) ).

fof(kb_SUMO_1846,axiom,
    s__domainSubclass(s__validFor__m,"2",s__Agent) ).

fof(kb_SUMO_1847,axiom,
    s__instance(s__validityPeriod__m,s__BinaryPredicate) ).

fof(kb_SUMO_1848,axiom,
    s__documentation(s__validityPeriod__m,s__EnglishLanguage,'(&%validityPeriod ?SCHEME ?TIMEINT) means that the &%CurrencyMeasure that &%PricingScheme refers to is valid for the given &%TimeInterval') ).

fof(kb_SUMO_1849,axiom,
    s__termFormat(s__EnglishLanguage,s__validityPeriod__m,'validity period') ).

fof(kb_SUMO_1850,axiom,
    s__domain(s__validityPeriod__m,"1",s__PricingScheme) ).

fof(kb_SUMO_1851,axiom,
    s__domain(s__validityPeriod__m,"2",s__TimeInterval) ).

fof(kb_SUMO_1852,axiom,
    s__instance(s__validPaymentType__m,s__BinaryPredicate) ).

fof(kb_SUMO_1853,axiom,
    s__documentation(s__validPaymentType__m,s__EnglishLanguage,'(&%validPaymentType ?SCHEME ?PAYMENT) means that the &%CurrencyMeasure that &%PricingScheme refers to is valid for the given &%Payment class') ).

fof(kb_SUMO_1854,axiom,
    s__termFormat(s__EnglishLanguage,s__validPaymentType__m,'valid payment type') ).

fof(kb_SUMO_1855,axiom,
    s__domain(s__validPaymentType__m,"1",s__PricingScheme) ).

fof(kb_SUMO_1856,axiom,
    s__domainSubclass(s__validPaymentType__m,"2",s__Payment) ).

fof(kb_SUMO_1857,axiom,
    s__instance(s__pricePolicy__m,s__BinaryPredicate) ).

fof(kb_SUMO_1858,axiom,
    s__documentation(s__pricePolicy__m,s__EnglishLanguage,'(&%pricePolicy ?SCHEME ?POLICY) describes the &%Policy ?POLICY attached to the given rate with the ?SCHEME') ).

fof(kb_SUMO_1859,axiom,
    s__termFormat(s__EnglishLanguage,s__pricePolicy__m,'rate policy') ).

fof(kb_SUMO_1860,axiom,
    s__domain(s__pricePolicy__m,"1",s__PricingScheme) ).

fof(kb_SUMO_1861,axiom,
    s__domain(s__pricePolicy__m,"2",s__Policy) ).

fof(kb_SUMO_1862,axiom,
    s__instance(s__negotiatedPrice__m,s__TernaryPredicate) ).

fof(kb_SUMO_1863,axiom,
    s__documentation(s__negotiatedPrice__m,s__EnglishLanguage,'(&%negotiatedPrice ?ENT ?PRICE ?AGREE) means that according to &%Agreement ?AGREE - which is agreed upon by seller and buyer - the &%CurrencyMeasure ?PRICE is given to &%Entity ?ENT') ).

fof(kb_SUMO_1864,axiom,
    s__domainSubclass(s__negotiatedPrice__m,"1",s__Entity) ).

fof(kb_SUMO_1865,axiom,
    s__domain(s__negotiatedPrice__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_1866,axiom,
    s__domain(s__negotiatedPrice__m,"3",s__Agreement) ).

fof(kb_SUMO_1867,axiom,
    ! [V__S,V__ITEM,V__AGREE,V__ENT,V__SELLER,V__PRICE,V__BUYER] :
      ( ( s__instance(V__BUYER,s__CognitiveAgent)
        & s__instance(V__PRICE,s__CurrencyMeasure)
        & s__instance(V__SELLER,s__CognitiveAgent)
        & s__instance(V__ENT,s__SetOrClass)
        & s__instance(V__AGREE,s__Agreement)
        & s__instance(V__S,s__FinancialTransaction) )
     => ( ( s__negotiatedPrice(V__ENT,V__PRICE,V__AGREE)
          & s__partyToAgreement(V__SELLER,V__AGREE)
          & s__partyToAgreement(V__BUYER,V__AGREE)
          & s__subclass(V__ENT,s__Physical) )
       => s__modalAttribute('((s__instance(V__S,s__Selling) & s__patient(V__S,V__ITEM) & s__immediateInstance(V__ITEM,V__ENT) & s__agent(V__S,V__SELLER) & s__destination(V__S,V__BUYER)) => s__transactionAmount(V__S,V__PRICE))',s__Promise) ) ) ).

fof(kb_SUMO_1868,axiom,
    ! [V__S,V__ITEM,V__PROCESS,V__AGREE,V__ENT,V__SELLER,V__PRICE,V__BUYER] :
      ( ( s__instance(V__BUYER,s__CognitiveAgent)
        & s__instance(V__PRICE,s__CurrencyMeasure)
        & s__instance(V__SELLER,s__CognitiveAgent)
        & s__instance(V__ENT,s__SetOrClass)
        & s__instance(V__AGREE,s__Agreement)
        & s__instance(V__PROCESS,s__Process)
        & s__instance(V__ITEM,s__Proposition)
        & s__instance(V__S,s__FinancialTransaction) )
     => ( ( s__negotiatedPrice(V__ENT,V__PRICE,V__AGREE)
          & s__partyToAgreement(V__SELLER,V__AGREE)
          & s__partyToAgreement(V__BUYER,V__AGREE)
          & s__subclass(V__ENT,s__Proposition) )
       => s__modalAttribute('((s__immediateInstance(V__ITEM,V__ENT) & s__realization(V__PROCESS,V__ITEM) & s__instance(V__S,s__Selling) & s__patient(V__S,V__PROCESS) & s__agent(V__S,V__SELLER) & s__destination(V__S,V__BUYER)) => s__transactionAmount(V__S,V__PRICE))',s__Promise) ) ) ).

fof(kb_SUMO_1869,axiom,
    ! [V__ITEM,V__AGREE,V__ENT,V__SELLER,V__PRICE,V__BUYER] :
      ( ( s__instance(V__BUYER,s__CognitiveAgent)
        & s__instance(V__PRICE,s__CurrencyMeasure)
        & s__instance(V__SELLER,s__CognitiveAgent)
        & s__instance(V__ENT,s__SetOrClass)
        & s__instance(V__AGREE,s__Agreement) )
     => ( ( s__negotiatedPrice(V__ENT,V__PRICE,V__AGREE)
          & s__partyToAgreement(V__SELLER,V__AGREE)
          & s__partyToAgreement(V__BUYER,V__AGREE) )
       => ? [V__B] :
            ( s__instance(V__B,s__FinancialTransaction)
            & s__agreementClause('((s__instance(V__B,s__Buying) & s__patient(V__B,V__ITEM) & s__immediateInstance(V__ITEM,V__ENT) & s__agent(V__B,V__BUYER) & s__origin(V__B,V__SELLER)) => s__transactionAmount(V__B,V__PRICE))',s__Obligation,V__AGREE,V__SELLER) ) ) ) ).

fof(kb_SUMO_1870,axiom,
    s__instance(s__publishedPrice__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_1871,axiom,
    s__documentation(s__publishedPrice__m,s__EnglishLanguage,'(&%publishedPrice ?ENT ?PRICE ?AGENT ?PS) means that the &%CurrencyMeasure ?PRICE is given by &%Agent ?AGENT to &%Entity ?ENT, based on conditions outlined in &%PricingScheme ?PS') ).

fof(kb_SUMO_1872,axiom,
    s__termFormat(s__EnglishLanguage,s__publishedPrice__m,'published price') ).

fof(kb_SUMO_1873,axiom,
    s__domainSubclass(s__publishedPrice__m,"1",s__Entity) ).

fof(kb_SUMO_1874,axiom,
    s__domain(s__publishedPrice__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_1875,axiom,
    s__domain(s__publishedPrice__m,"3",s__CognitiveAgent) ).

fof(kb_SUMO_1876,axiom,
    s__domain(s__publishedPrice__m,"4",s__PricingScheme) ).

fof(kb_SUMO_1877,axiom,
    ! [V__B,V__QUANT,V__PS,V__ITEM,V__PAY,V__ENT,V__AGENT,V__PRICE] :
      ( ( s__instance(V__PRICE,s__CurrencyMeasure)
        & s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__ENT,s__SetOrClass)
        & s__subclass(V__PAY,s__Payment)
        & s__instance(V__PAY,s__SetOrClass)
        & s__instance(V__PS,s__PricingScheme)
        & s__instance(V__QUANT,s__FunctionQuantity)
        & s__instance(V__B,s__Process) )
     => ( ( s__instance(V__B,s__Buying)
          & s__patient(V__B,V__ITEM)
          & s__origin(V__B,V__AGENT)
          & ( s__publishedPrice(V__ENT,V__PRICE,V__AGENT,V__PS)
            | s__unitPrice(V__ENT,V__QUANT,V__AGENT,V__PS) )
          & s__subclass(V__ENT,s__Physical)
          & s__immediateInstance(V__ITEM,V__ENT)
          & s__validPaymentType(V__PS,V__PAY) )
       => s__modalAttribute('(? [V__PAYMENT] : (s__instance(V__PAYMENT,s__Process) & s__instance(V__PAYMENT,V__PAY) & s__subProcess(V__PAYMENT,V__B)))',s__Likely) ) ) ).

fof(kb_SUMO_1878,axiom,
    ! [V__CUSTOMER,V__B,V__QUANT,V__CUSTCLASS,V__ITEM,V__PS,V__AGENT,V__ENT,V__PRICE] :
      ( ( s__instance(V__PRICE,s__CurrencyMeasure)
        & s__instance(V__ENT,s__SetOrClass)
        & s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__PS,s__PricingScheme)
        & s__subclass(V__CUSTCLASS,s__Agent)
        & s__instance(V__CUSTCLASS,s__SetOrClass)
        & s__instance(V__QUANT,s__FunctionQuantity)
        & s__instance(V__B,s__FinancialTransaction)
        & s__instance(V__CUSTOMER,s__Agent) )
     => ( ( ( s__publishedPrice(V__ENT,V__PRICE,V__AGENT,V__PS)
            | s__unitPrice(V__ENT,V__QUANT,V__AGENT,V__PS) )
          & s__subclass(V__ENT,s__Physical)
          & s__immediateInstance(V__ITEM,V__ENT)
          & s__validFor(V__PS,V__CUSTCLASS)
          & s__instance(V__CUSTOMER,V__CUSTCLASS) )
       => s__modalAttribute('((s__instance(V__B,s__Buying) & s__agent(V__B,V__CUSTOMER) & s__origin(V__B,V__AGENT) & s__patient(V__B,V__ITEM)) => s__transactionAmount(V__B,V__PRICE))',s__Likely) ) ) ).

%FOL fof(kb_SUMO_1879,axiom,(( (! [V__S,V__QUANT,V__ITEM,V__PS,V__SELLING,V__AGENT,V__ENT,V__TIMEINT,V__TIMTEINT,V__PRICE] : ((s__instance(V__PRICE,s__CurrencyMeasure) & s__instance(V__TIMTEINT,s__TimePosition) & s__instance(V__TIMEINT,s__TimeInterval) & s__instance(V__ENT,s__SetOrClass) & s__instance(V__AGENT,s__CognitiveAgent) & s__instance(V__SELLING,s__SetOrClass) & s__instance(V__PS,s__PricingScheme) & s__instance(V__QUANT,s__FunctionQuantity) & s__instance(V__S,s__FinancialTransaction)) => (((s__publishedPrice(V__ENT,V__PRICE,V__AGENT,V__PS) | s__unitPrice(V__ENT,V__QUANT,V__AGENT,V__PS)) & s__subclass(V__ENT,s__Physical) & s__immediateInstance(V__ITEM,V__ENT) & s__validityPeriod(V__PS,V__TIMEINT)) => s__holdsDuring(V__TIMTEINT,'s__modalAttribute(((s__instance(V__S,V__SELLING) & s__agent(V__S,V__AGENT) & s__patient(V__S,V__ITEM)) => s__transactionAmount(V__S,V__PRICE)),s__Likely)')))) ))).

fof(kb_SUMO_1880,axiom,
    s__instance(s__unitPrice__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_1881,axiom,
    s__documentation(s__unitPrice__m,s__EnglishLanguage,'(&%unitPrice ?ENT ?QUANT ?AGENT ?PS) is meant for objects that are not sold by the piece but by a certain unit of measure, for instance, vegetables that are sold by the pound. &%FunctionQuantity ?QUANT, in this case, refers to (&%PerFn &%CurrencyMeasure (&%MeasureFn &%RealNumber &%UnitOfMeasure)), which reads something like X amount of money per Y unit. This can be attached to a &%PricingScheme ?PS by &%CognitiveAgent ?AGENT') ).

fof(kb_SUMO_1882,axiom,
    s__domainSubclass(s__unitPrice__m,"1",s__Entity) ).

fof(kb_SUMO_1883,axiom,
    s__domain(s__unitPrice__m,"2",s__FunctionQuantity) ).

fof(kb_SUMO_1884,axiom,
    s__domain(s__unitPrice__m,"3",s__CognitiveAgent) ).

fof(kb_SUMO_1885,axiom,
    s__domain(s__unitPrice__m,"4",s__PricingScheme) ).

fof(kb_SUMO_1886,axiom,
    ! [V__QUANT,V__PS,V__AGENT,V__ENT] :
      ( ( s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__PS,s__PricingScheme)
        & s__instance(V__QUANT,s__FunctionQuantity) )
     => ( s__unitPrice(V__ENT,V__QUANT,V__AGENT,V__PS)
       => ? [V__MEAS,V__AMT,V__UOM] :
            ( s__instance(V__UOM,s__UnitOfMeasure)
            & s__instance(V__AMT,s__RealNumber)
            & s__instance(V__MEAS,s__PhysicalQuantity)
            & V__QUANT = s__PerFn(V__MEAS,s__MeasureFn(V__AMT,V__UOM))
            & s__instance(V__MEAS,s__CurrencyMeasure) ) ) ) ).

fof(kb_SUMO_1887,axiom,
    s__instance(s__productPrice__m,s__TernaryPredicate) ).

fof(kb_SUMO_1888,axiom,
    s__documentation(s__productPrice__m,s__EnglishLanguage,'(&%productPrice ?ENT ?QUANT ?AGENT) means that &%CognitiveAgent ?AGENT sells items of type &%Entity ?ENT for &%CurrencyMeasure ?QUANT') ).

fof(kb_SUMO_1889,axiom,
    s__termFormat(s__EnglishLanguage,s__productPrice__m,'product price') ).

fof(kb_SUMO_1890,axiom,
    s__domainSubclass(s__productPrice__m,"1",s__Entity) ).

fof(kb_SUMO_1891,axiom,
    s__domain(s__productPrice__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_1892,axiom,
    s__domain(s__productPrice__m,"3",s__CognitiveAgent) ).

fof(kb_SUMO_1893,axiom,
    ! [V__S,V__AGENT,V__ENT,V__I,V__PRICE] :
      ( ( s__instance(V__PRICE,s__CurrencyMeasure)
        & s__instance(V__ENT,s__SetOrClass)
        & s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__S,s__FinancialTransaction) )
     => ( s__productPrice(V__ENT,V__PRICE,V__AGENT)
       => s__modalAttribute('((s__instance(V__S,s__Selling) & s__immediateInstance(V__I,V__ENT) & s__patient(V__S,V__I) & s__agent(V__S,V__AGENT)) => s__transactionAmount(V__S,V__PRICE))',s__Likely) ) ) ).

%FOL fof(kb_SUMO_1894,axiom,(( (! [V__PRICE1,V__B,V__ITEM,V__CUSTCLASS,V__PS,V__CUST,V__AGENT,V__ENT,V__PRICE2] : ((s__instance(V__PRICE2,s__CurrencyMeasure) & s__instance(V__ENT,s__SetOrClass) & s__instance(V__AGENT,s__CognitiveAgent) & s__instance(V__CUST,s__Agent) & s__instance(V__PS,s__PricingScheme) & s__subclass(V__CUSTCLASS,s__Agent) & s__instance(V__CUSTCLASS,s__SetOrClass) & s__instance(V__B,s__FinancialTransaction) & s__instance(V__PRICE1,s__CurrencyMeasure)) => ((s__productPrice(V__ENT,V__PRICE1,V__AGENT) & s__publishedPrice(V__ENT,V__PRICE2,V__AGENT,V__PS) & s__validFor(V__PS,V__CUSTCLASS) & s__instance(V__ITEM,V__ENT) & s__instance(V__B,s__Buying) & s__immediateInstance(V__CUST,V__CUSTCLASS) & s__agent(V__B,V__CUST) & s__origin(V__B,V__AGENT) & less(V__PRICE2,V__PRICE1)) => s__modalAttribute('s__transactionAmount(V__B,V__PRICE1)',s__Likely)))) ))).

fof(kb_SUMO_1895,axiom,
    s__instance(s__rentalPrice__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_1896,axiom,
    s__documentation(s__rentalPrice__m,s__EnglishLanguage,'(&%rentalPrice ?OBJ ?PRICE ?AGENT ?PS) means that the &%CurrencyMeasure ?PRICE is paid for the use of &%Physical ?OBJ. &%CognitiveAgent ?AGENT sets this price with conditions stipulated in &%PricingScheme ?PS') ).

fof(kb_SUMO_1897,axiom,
    s__termFormat(s__EnglishLanguage,s__rentalPrice__m,'rental price') ).

fof(kb_SUMO_1898,axiom,
    s__domainSubclass(s__rentalPrice__m,"1",s__Physical) ).

fof(kb_SUMO_1899,axiom,
    s__domain(s__rentalPrice__m,"2",s__FunctionQuantity) ).

fof(kb_SUMO_1900,axiom,
    s__domain(s__rentalPrice__m,"3",s__CognitiveAgent) ).

fof(kb_SUMO_1901,axiom,
    s__domain(s__rentalPrice__m,"4",s__PricingScheme) ).

fof(kb_SUMO_1902,axiom,
    ! [V__OBJ,V__QUANT,V__PS,V__AGENT] :
      ( ( s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__PS,s__PricingScheme)
        & s__instance(V__QUANT,s__FunctionQuantity)
        & s__subclass(V__OBJ,s__Physical)
        & s__instance(V__OBJ,s__SetOrClass) )
     => ( s__rentalPrice(V__OBJ,V__QUANT,V__AGENT,V__PS)
       => ? [V__DURATION,V__CURR] :
            ( s__instance(V__CURR,s__PhysicalQuantity)
            & s__instance(V__DURATION,s__PhysicalQuantity)
            & s__instance(V__DURATION,s__TimeDuration)
            & s__instance(V__CURR,s__CurrencyMeasure)
            & V__QUANT = s__PerFn(V__CURR,V__DURATION) ) ) ) ).

fof(kb_SUMO_1903,axiom,
    ! [V__CUSTOMER,V__OBJ,V__R,V__TIME,V__QUANT,V__ITEM,V__PS,V__AGENT,V__DURATION,V__TIMEINT,V__PRICE] :
      ( ( s__rentalPrice(V__OBJ,V__QUANT,V__AGENT,V__PS)
        & V__QUANT = s__PerFn(V__PRICE,V__TIME)
        & s__immediateInstance(V__ITEM,V__OBJ)
        & s__instance(V__R,s__Renting)
        & s__patient(V__R,V__ITEM)
        & s__possesses(V__OBJ,V__AGENT)
        & s__agent(V__R,V__CUSTOMER)
        & s__time(V__R,V__TIMEINT) )
     => ! [V__X] :
          ( ( s__instance(V__PRICE,s__CurrencyMeasure)
            & s__instance(V__TIMEINT,s__TimeInterval)
            & s__instance(V__DURATION,s__TimeDuration)
            & s__instance(V__AGENT,s__CognitiveAgent)
            & s__instance(V__PS,s__PricingScheme)
            & s__instance(V__QUANT,s__FunctionQuantity)
            & s__instance(V__TIME,s__PhysicalQuantity)
            & s__instance(V__R,s__Process)
            & s__subclass(V__OBJ,s__Physical)
            & s__instance(V__OBJ,s__SetOrClass)
            & s__instance(V__OBJ,s__Agent)
            & s__instance(V__CUSTOMER,s__Agent) )
         => ( ( s__during(V__TIMEINT,V__X)
              & s__instance(V__X,s__TimeInterval)
              & s__duration(V__X,V__DURATION)
              & lesseq(V__DURATION,V__TIME) )
           => ? [V__P] :
                ( s__instance(V__P,s__FinancialTransaction)
                & s__instance(V__P,s__Payment)
                & s__destination(V__P,V__AGENT)
                & s__agent(V__P,V__CUSTOMER)
                & s__transactionAmount(V__P,V__PRICE) ) ) ) ) ).

fof(kb_SUMO_1904,axiom,
    s__instance(s__contractedRentalPrice__m,s__TernaryPredicate) ).

fof(kb_SUMO_1905,axiom,
    s__documentation(s__contractedRentalPrice__m,s__EnglishLanguage,'(&%contractedRentalPrice ?OBJ ?PRICE ?AGREEMENT) means that the conditions of rental of &%Physical ?OBJ is stipulated in &%Agreement ?AGREEMENT entered into by &%CognitiveAgent ?AGENT with a customer.') ).

fof(kb_SUMO_1906,axiom,
    s__termFormat(s__EnglishLanguage,s__contractedRentalPrice__m,'contracted rental price') ).

fof(kb_SUMO_1907,axiom,
    s__domainSubclass(s__contractedRentalPrice__m,"1",s__Physical) ).

fof(kb_SUMO_1908,axiom,
    s__domain(s__contractedRentalPrice__m,"2",s__FunctionQuantity) ).

fof(kb_SUMO_1909,axiom,
    s__domain(s__contractedRentalPrice__m,"3",s__Agreement) ).

fof(kb_SUMO_1910,axiom,
    ! [V__OBJ,V__QUANT,V__AGREE] :
      ( ( s__instance(V__AGREE,s__Agreement)
        & s__instance(V__QUANT,s__FunctionQuantity)
        & s__subclass(V__OBJ,s__Physical)
        & s__instance(V__OBJ,s__SetOrClass) )
     => ( s__contractedRentalPrice(V__OBJ,V__QUANT,V__AGREE)
       => ? [V__DURATION,V__CURR] :
            ( s__instance(V__CURR,s__PhysicalQuantity)
            & s__instance(V__DURATION,s__PhysicalQuantity)
            & s__instance(V__CURR,s__CurrencyMeasure)
            & s__instance(V__DURATION,s__TimeDuration)
            & V__QUANT = s__PerFn(V__CURR,V__DURATION) ) ) ) ).

fof(kb_SUMO_1911,axiom,
    ! [V__OBJ,V__QUANT,V__AGREE] :
      ( ( s__instance(V__AGREE,s__Agreement)
        & s__instance(V__QUANT,s__FunctionQuantity)
        & s__subclass(V__OBJ,s__Physical)
        & s__instance(V__OBJ,s__SetOrClass) )
     => ( s__contractedRentalPrice(V__OBJ,V__QUANT,V__AGREE)
       => ? [V__SELLER,V__CUSTOMER] :
            ( s__partyToAgreement(V__SELLER,V__AGREE)
            & s__partyToAgreement(V__CUSTOMER,V__AGREE)
            & s__modalAttribute('(? [V__R] : (s__instance(V__R,s__Process) & s__instance(V__CUSTOMER,s__CognitiveAgent) & s__instance(V__SELLER,s__CognitiveAgent) & s__instance(V__R,s__Renting) & s__patient(V__R,V__OBJ) & s__agent(V__R,V__SELLER) & s__destination(V__R,V__CUSTOMER)))',s__Obligation) ) ) ) ).

fof(kb_SUMO_1912,axiom,
    s__subclass(s__CommunicationRadio,s__CommunicationDevice) ).

fof(kb_SUMO_1913,axiom,
    s__instance(s__CommunicationRadio__t,s__SetOrClass) ).

fof(kb_SUMO_1914,axiom,
    s__documentation(s__CommunicationRadio,s__EnglishLanguage,'Relatively low power broadcasting devices designed for voice communication among specialized groups in which each receiver also has the power to transmit, unlike broadcast radio where most components transmitting or receiving on a given frequency or set of frequencies are receivers only. This includes unlicensed walkie-talkies, public safety radios, military communication systems and CB radios.') ).

fof(kb_SUMO_1915,axiom,
    s__subclass(s__TelephoneSystem,s__CommunicationSystem) ).

fof(kb_SUMO_1916,axiom,
    s__instance(s__TelephoneSystem__t,s__SetOrClass) ).

fof(kb_SUMO_1917,axiom,
    s__documentation(s__TelephoneSystem,s__EnglishLanguage,'A &%TelephoneSystem consists of a complete interconnection of &%Telephones, &%MainTelephoneLines, and other components that work together to make telephonic communication possible from point to point in a given area.') ).

fof(kb_SUMO_1918,axiom,
    s__synonymousExternalConcept(telephone,s__Telephone,s__EnglishLanguage) ).

fof(kb_SUMO_1919,axiom,
    ! [V__SYSTEM] :
      ( s__instance(V__SYSTEM,s__EngineeringComponent)
     => ( s__instance(V__SYSTEM,s__TelephoneSystem)
       => ? [V__PHONE] :
            ( s__instance(V__PHONE,s__EngineeringComponent)
            & s__instance(V__PHONE,s__Telephone)
            & s__engineeringSubcomponent(V__PHONE,V__SYSTEM) ) ) ) ).

fof(kb_SUMO_1920,axiom,
    s__subclass(s__MainTelephoneLine,s__CommunicationDevice) ).

fof(kb_SUMO_1921,axiom,
    s__instance(s__MainTelephoneLine__t,s__SetOrClass) ).

fof(kb_SUMO_1922,axiom,
    s__synonymousExternalConcept('main telephone line',s__MainTelephoneLine,s__EnglishLanguage) ).

fof(kb_SUMO_1923,axiom,
    s__documentation(s__MainTelephoneLine,s__EnglishLanguage,'A &%MainTelephoneLine is one &%engineeringSubcomponent of a &%TelephoneSystem used for voice communication or computer data transfer.') ).

fof(kb_SUMO_1924,axiom,
    ! [V__SYSTEM] :
      ( s__instance(V__SYSTEM,s__EngineeringComponent)
     => ( s__instance(V__SYSTEM,s__TelephoneSystem)
       => ? [V__LINE] :
            ( s__instance(V__LINE,s__EngineeringComponent)
            & s__instance(V__LINE,s__MainTelephoneLine)
            & s__engineeringSubcomponent(V__LINE,V__SYSTEM) ) ) ) ).

fof(kb_SUMO_1925,axiom,
    s__subclass(s__TelephoneCradle,s__Device) ).

fof(kb_SUMO_1926,axiom,
    s__instance(s__TelephoneCradle__t,s__SetOrClass) ).

fof(kb_SUMO_1927,axiom,
    s__documentation(s__TelephoneCradle,s__EnglishLanguage,'&%TelephoneCradle is the part of the &%Telephone that is connected to the &%TelephoneSystem through some wire.') ).

fof(kb_SUMO_1928,axiom,
    s__termFormat(s__EnglishLanguage,s__TelephoneCradle,'telephone cradle') ).

fof(kb_SUMO_1929,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__EngineeringComponent)
     => ( s__instance(V__X,s__TelephoneCradle)
       => s__hasPurpose(V__X,'(? [V__SYS,V__WIRE] : (s__instance(V__WIRE,s__EngineeringConnection) & s__instance(V__SYS,s__EngineeringComponent) & s__instance(V__SYS,s__TelephoneSystem) & s__instance(V__WIRE,s__WireLine) & s__connectsEngineeringComponents(V__WIRE,V__X,V__SYS)))') ) ) ).

fof(kb_SUMO_1930,axiom,
    s__subclass(s__CordedTelephone,s__FixedPhone) ).

fof(kb_SUMO_1931,axiom,
    s__instance(s__CordedTelephone__t,s__SetOrClass) ).

fof(kb_SUMO_1932,axiom,
    s__documentation(s__CordedTelephone,s__EnglishLanguage,'&%CordedTelephone is a type of &%FixedPhone whose &%TelephoneHandset is connected to its &%TelephoneCradle by a &%WireLine') ).

fof(kb_SUMO_1933,axiom,
    s__termFormat(s__EnglishLanguage,s__CordedTelephone,'corded telephone') ).

fof(kb_SUMO_1934,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Object)
     => ( s__instance(V__X,s__CordedTelephone)
       => ? [V__HANDSET,V__CRADLE,V__WIRE] :
            ( s__instance(V__WIRE,s__EngineeringConnection)
            & s__instance(V__CRADLE,s__EngineeringComponent)
            & s__instance(V__HANDSET,s__EngineeringComponent)
            & s__instance(V__HANDSET,s__TelephoneHandset)
            & s__instance(V__CRADLE,s__TelephoneCradle)
            & s__part(V__HANDSET,V__X)
            & s__part(V__CRADLE,V__X)
            & s__instance(V__WIRE,s__WireLine)
            & s__connectsEngineeringComponents(V__WIRE,V__HANDSET,V__CRADLE) ) ) ) ).

fof(kb_SUMO_1935,axiom,
    s__subclass(s__CordlessTelephone,s__FixedPhone) ).

fof(kb_SUMO_1936,axiom,
    s__instance(s__CordlessTelephone__t,s__SetOrClass) ).

fof(kb_SUMO_1937,axiom,
    s__documentation(s__CordlessTelephone,s__EnglishLanguage,'&%CordlessTelephone is a type of &%FixedPhone whose &%TelephoneHandset is not connected to its &%TelephoneCradle by a &%WireLine') ).

fof(kb_SUMO_1938,axiom,
    s__termFormat(s__EnglishLanguage,s__CordlessTelephone,'cordless telephone') ).

fof(kb_SUMO_1939,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Object)
     => ( s__instance(V__X,s__CordlessTelephone)
       => ? [V__HANDSET,V__CRADLE] :
            ( s__instance(V__HANDSET,s__TelephoneHandset)
            & s__instance(V__CRADLE,s__TelephoneCradle)
            & s__part(V__HANDSET,V__X)
            & s__part(V__CRADLE,V__X)
            & ~ ? [V__WIRE] :
                  ( s__instance(V__WIRE,s__EngineeringConnection)
                  & s__instance(V__CRADLE,s__EngineeringComponent)
                  & s__instance(V__HANDSET,s__EngineeringComponent)
                  & s__instance(V__WIRE,s__WireLine)
                  & s__connectsEngineeringComponents(V__WIRE,V__HANDSET,V__CRADLE) ) ) ) ) ).

fof(kb_SUMO_1940,axiom,
    s__subclass(s__ArtificialSatellite,s__Satellite) ).

fof(kb_SUMO_1941,axiom,
    s__instance(s__Satellite__t,s__SetOrClass) ).

fof(kb_SUMO_1942,axiom,
    s__subclass(s__ArtificialSatellite,s__EngineeringComponent) ).

fof(kb_SUMO_1943,axiom,
    s__synonymousExternalConcept(satellite,s__ArtificialSatellite,s__EnglishLanguage) ).

fof(kb_SUMO_1944,axiom,
    s__documentation(s__ArtificialSatellite,s__EnglishLanguage,'An &%ArtificialSatellite is a &%Device that orbits the earth in space and performs various functions such as aiding in communication, photographing the earths surface, and others.') ).

fof(kb_SUMO_1945,axiom,
    s__subclass(s__CommunicationSatellite,s__ArtificialSatellite) ).

fof(kb_SUMO_1946,axiom,
    s__instance(s__ArtificialSatellite__t,s__SetOrClass) ).

fof(kb_SUMO_1947,axiom,
    s__subclass(s__CommunicationSatellite,s__CommunicationDevice) ).

fof(kb_SUMO_1948,axiom,
    s__instance(s__CommunicationSatellite__t,s__SetOrClass) ).

fof(kb_SUMO_1949,axiom,
    s__synonymousExternalConcept('communications satellite',s__CommunicationSatellite,s__EnglishLanguage) ).

fof(kb_SUMO_1950,axiom,
    s__documentation(s__CommunicationSatellite,s__EnglishLanguage,'A &%CommunicationSatellite is an &%ArtificialSatellite that serves as one &%engineeringSubcomponent of a &%CommunicationSystem.') ).

fof(kb_SUMO_1951,axiom,
    ! [V__SAT] :
      ( s__instance(V__SAT,s__EngineeringComponent)
     => ( s__instance(V__SAT,s__CommunicationSatellite)
       => ? [V__SYSTEM] :
            ( s__instance(V__SYSTEM,s__EngineeringComponent)
            & s__instance(V__SYSTEM,s__CommunicationSystem)
            & s__engineeringSubcomponent(V__SAT,V__SYSTEM) ) ) ) ).

fof(kb_SUMO_1952,axiom,
    s__instance(s__communicationSatelliteForArea__m,s__TernaryPredicate) ).

fof(kb_SUMO_1953,axiom,
    s__domain(s__communicationSatelliteForArea__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_1954,axiom,
    s__domainSubclass(s__communicationSatelliteForArea__m,"2",s__Satellite) ).

fof(kb_SUMO_1955,axiom,
    s__domain(s__communicationSatelliteForArea__m,"3",s__Integer) ).

fof(kb_SUMO_1956,axiom,
    s__documentation(s__communicationSatelliteForArea__m,s__EnglishLanguage,'The expression (communicationSatelliteForArea ?AREA ?SATELLITE ?INTEGER) means that ?INTEGER number of &%CommunicationSatellites of the type ?SATELLITE serve as an &%engineeringSubcomponent of a &%TelephoneSystem of the GeopoliticalArea ?AREA.') ).

fof(kb_SUMO_1957,axiom,
    ! [V__SATELLITE,V__SYSTEM,V__INTEGER,V__AREA,V__SATELLITETYPE] :
      ( ( s__subclass(V__SATELLITETYPE,s__Satellite)
        & s__instance(V__SATELLITETYPE,s__SetOrClass)
        & s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__INTEGER,s__Integer)
        & s__instance(V__SYSTEM,s__EngineeringComponent) )
     => ( s__communicationSatelliteForArea(V__AREA,V__SATELLITETYPE,V__INTEGER)
       => V__INTEGER = s__CardinalityFn(s__KappaFn(V__SATELLITE,'(s__instance(V__SATELLITE,V__SATELLITETYPE) & s__instance(V__SYSTEM,s__CommunicationSystem) & s__located(V__SYSTEM,V__AREA) & s__engineeringSubcomponent(V__SATELLITE,V__SYSTEM))')) ) ) ).

fof(kb_SUMO_1958,axiom,
    s__subclass(s__Eutelsat,s__CommunicationSatellite) ).

fof(kb_SUMO_1959,axiom,
    s__instance(s__Eutelsat__t,s__SetOrClass) ).

fof(kb_SUMO_1960,axiom,
    s__documentation(s__Eutelsat,s__EnglishLanguage,'An &%Eutelsat is one type of &%CommunicationSatellite.') ).

fof(kb_SUMO_1961,axiom,
    s__subclass(s__Inmarsat,s__CommunicationSatellite) ).

fof(kb_SUMO_1962,axiom,
    s__instance(s__Inmarsat__t,s__SetOrClass) ).

fof(kb_SUMO_1963,axiom,
    s__documentation(s__Inmarsat,s__EnglishLanguage,'An &%Inmarsat is one type of &%CommunicationSatellite.') ).

fof(kb_SUMO_1964,axiom,
    s__subclass(s__Intelsat,s__CommunicationSatellite) ).

fof(kb_SUMO_1965,axiom,
    s__instance(s__Intelsat__t,s__SetOrClass) ).

fof(kb_SUMO_1966,axiom,
    s__documentation(s__Intelsat,s__EnglishLanguage,'An &%Intelsat is one type of &%CommunicationSatellite.') ).

fof(kb_SUMO_1967,axiom,
    s__subclass(s__Intersputnik,s__CommunicationSatellite) ).

fof(kb_SUMO_1968,axiom,
    s__instance(s__Intersputnik__t,s__SetOrClass) ).

fof(kb_SUMO_1969,axiom,
    s__documentation(s__Intersputnik,s__EnglishLanguage,'An &%Intersputnik is one type of &%CommunicationSatellite.') ).

fof(kb_SUMO_1970,axiom,
    s__subclass(s__Orbita,s__CommunicationSatellite) ).

fof(kb_SUMO_1971,axiom,
    s__instance(s__Orbita__t,s__SetOrClass) ).

fof(kb_SUMO_1972,axiom,
    s__documentation(s__Orbita,s__EnglishLanguage,'An &%Orbita is one type of &%CommunicationSatellite.') ).

fof(kb_SUMO_1973,axiom,
    s__subclass(s__Telex,s__CommunicationDevice) ).

fof(kb_SUMO_1974,axiom,
    s__instance(s__Telex__t,s__SetOrClass) ).

fof(kb_SUMO_1975,axiom,
    s__documentation(s__Telex,s__EnglishLanguage,'&%Telex is a &%Telegraph-like &%CommunicationDevice that is used to send messages over a &%TelephoneSystem.') ).

fof(kb_SUMO_1976,axiom,
    s__termFormat(s__EnglishLanguage,s__Telex,telex) ).

fof(kb_SUMO_1977,axiom,
    ! [V__TELEX] :
      ( s__instance(V__TELEX,s__Object)
     => ( s__instance(V__TELEX,s__Telex)
       => ? [V__PRINTER] :
            ( s__instance(V__PRINTER,s__Object)
            & s__instance(V__PRINTER,s__Printer)
            & s__part(V__PRINTER,V__TELEX) ) ) ) ).

fof(kb_SUMO_1978,axiom,
    ! [V__TELEX] :
      ( s__instance(V__TELEX,s__Object)
     => ( s__instance(V__TELEX,s__Telex)
       => s__hasPurpose(V__TELEX,'(? [V__SYS,V__TELEX2,V__MSG] : (s__instance(V__MSG,s__Motion) & s__instance(V__TELEX2,s__Object) & s__instance(V__SYS,s__Object) & s__instance(V__SYS,s__TelephoneSystem) & s__instance(V__TELEX2,s__Telex) & s__instance(V__MSG,s__Messaging) & ((s__origin(V__MSG,V__TELEX) & s__destination(V__MSG,V__TELEX2)) | (s__origin(V__MSG,V__TELEX2) & s__destination(V__MSG,V__TELEX))) & s__path(V__MSG,V__SYS)))') ) ) ).

fof(kb_SUMO_1979,axiom,
    ! [V__MSG,V__TELEX,V__M] :
      ( ( s__instance(V__TELEX,s__Object)
        & s__instance(V__MSG,s__Process) )
     => ( ( s__destination(V__MSG,V__TELEX)
          & s__instance(V__MSG,s__Messaging)
          & s__patient(V__MSG,V__M)
          & s__instance(V__TELEX,s__Telex) )
       => ? [V__PROC,V__TEXT] :
            ( s__instance(V__PROC,s__Process)
            & s__instrument(V__PROC,V__TELEX)
            & s__result(V__PROC,V__TEXT)
            & s__represents(V__TEXT,V__M)
            & s__instance(V__TEXT,s__Text)
            & s__before(s__BeginFn(s__WhenFn(V__MSG)),s__BeginFn(s__WhenFn(V__PROC))) ) ) ) ).

fof(kb_SUMO_1980,axiom,
    s__subclass(s__BroadcastingStation,s__StationaryArtifact) ).

fof(kb_SUMO_1981,axiom,
    s__subclass(s__BroadcastingStation,s__CommunicationDevice) ).

fof(kb_SUMO_1982,axiom,
    s__engineeringSubcomponent(s__BroadcastingStation,s__CommunicationSystem) ).

fof(kb_SUMO_1983,axiom,
    s__documentation(s__BroadcastingStation,s__EnglishLanguage,'A &%BroadcastingStation is an &%engineeringSubcomponent of either a &%TelevisionSystem or a &%RadioStation.') ).

fof(kb_SUMO_1984,axiom,
    ! [V__STATION] :
      ( s__instance(V__STATION,s__BroadcastingStation)
     => ( s__instance(V__STATION,s__TelevisionStation)
        | s__instance(V__STATION,s__RadioStation) ) ) ).

fof(kb_SUMO_1985,axiom,
    s__subclass(s__RadioSystem,s__CommunicationSystem) ).

fof(kb_SUMO_1986,axiom,
    s__documentation(s__RadioSystem,s__EnglishLanguage,'A &%RadioSystem consists of &%Radios, &%RadioStations, and other components that work together to make radio broadcasting possible in a given area.') ).

fof(kb_SUMO_1987,axiom,
    s__subclass(s__AMRadioSystem,s__RadioSystem) ).

fof(kb_SUMO_1988,axiom,
    s__instance(s__AMRadioSystem__t,s__SetOrClass) ).

fof(kb_SUMO_1989,axiom,
    s__documentation(s__AMRadioSystem,s__EnglishLanguage,'An &%AMRadioSystem consists of &%Radios, &%AMRadioStations, and other components that work together to make AM radio broadcasting possible in a given area.') ).

fof(kb_SUMO_1990,axiom,
    s__subclass(s__FMRadioSystem,s__RadioSystem) ).

fof(kb_SUMO_1991,axiom,
    s__instance(s__FMRadioSystem__t,s__SetOrClass) ).

fof(kb_SUMO_1992,axiom,
    s__instance(s__RadioSystem__t,s__SetOrClass) ).

fof(kb_SUMO_1993,axiom,
    s__documentation(s__FMRadioSystem,s__EnglishLanguage,'A &%FMRadioSystem consists of &%Radios, &%FMRadioStations, and other components that work together to make FM radio broadcasting possible in a given area.') ).

fof(kb_SUMO_1994,axiom,
    s__subclass(s__ShortwaveRadioSystem,s__RadioSystem) ).

fof(kb_SUMO_1995,axiom,
    s__instance(s__ShortwaveRadioSystem__t,s__SetOrClass) ).

fof(kb_SUMO_1996,axiom,
    s__documentation(s__ShortwaveRadioSystem,s__EnglishLanguage,'A &%ShortwaveRadioSystem consists of &%Radios, &%ShortwaveRadioStations, and other components that work together to make shortwave radio broadcasting possible in a given area.') ).

fof(kb_SUMO_1997,axiom,
    s__subclass(s__BabyMonitoringSystem,s__RadioSystem) ).

fof(kb_SUMO_1998,axiom,
    s__instance(s__BabyMonitoringSystem__t,s__SetOrClass) ).

fof(kb_SUMO_1999,axiom,
    s__documentation(s__BabyMonitoringSystem,s__EnglishLanguage,'&%BabyMonitoringSystem refers to the radio system that &%Broadcasting at 49Mhz, consisting of a transmitter and receiver, where the transmitter is kept where the baby is kept, and the receiver is kept with the person looking after the baby to be able to hear sounds and monitor the baby') ).

fof(kb_SUMO_2000,axiom,
    s__termFormat(s__EnglishLanguage,s__BabyMonitoringSystem,'baby monitor') ).

fof(kb_SUMO_2001,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__EngineeringComponent)
     => ( s__instance(V__X,s__BabyMonitoringSystem)
       => ? [V__TX,V__RX] :
            ( s__instance(V__RX,s__RadioReceiver)
            & s__instance(V__TX,s__Device)
            & s__engineeringSubcomponent(V__RX,V__X)
            & s__engineeringSubcomponent(V__TX,V__X)
            & s__hasPurpose(V__X,'(? [V__BABY,V__CARER,V__SOUND,V__LOC1,V__LOC2,V__PROC,V__RADIO] : (s__instance(V__RADIO,s__Process) & s__instance(V__PROC,s__Process) & s__instance(V__LOC2,s__Object) & s__instance(V__LOC1,s__Object) & s__instance(V__SOUND,s__Process) & s__instance(V__CARER,s__Agent) & s__instance(V__BABY,s__Physical) & s__instance(V__RX,s__EngineeringComponent) & s__instance(V__TX,s__EngineeringComponent) & s__instance(V__TX,s__Agent) & s__instance(V__BABY,s__HumanBaby) & s__instance(V__CARER,s__Human) & s__located(V__BABY,V__LOC1) & s__located(V__CARER,V__LOC2) & (~ (V__LOC1 = V__LOC2)) & s__instance(V__PROC,s__Maintaining) & s__patient(V__PROC,V__BABY) & s__agent(V__PROC,V__CARER) & s__located(V__TX,V__LOC1) & s__located(V__RX,V__LOC2) & s__instance(V__SOUND,s__RadiatingSound) & s__eventLocated(V__SOUND,V__LOC1) & s__instance(V__RADIO,s__RadioEmission) & s__patient(V__RADIO,V__SOUND) & s__destination(V__RADIO,V__RX) & s__agent(V__RADIO,V__TX)))') ) ) ) ).

fof(kb_SUMO_2002,axiom,
    s__subclass(s__RadioStation,s__BroadcastingStation) ).

fof(kb_SUMO_2003,axiom,
    s__subclass(s__BroadcastingStation,s__EngineeringComponent) ).

fof(kb_SUMO_2004,axiom,
    s__engineeringSubcomponent(s__RadioStation,s__RadioSystem) ).

fof(kb_SUMO_2005,axiom,
    s__documentation(s__RadioStation,s__EnglishLanguage,'A &%RadioStation is an &%engineeringSubcomponent of a &%RadioSystem.') ).

fof(kb_SUMO_2006,axiom,
    s__subclass(s__AMRadioStation,s__RadioStation) ).

fof(kb_SUMO_2007,axiom,
    s__instance(s__AMRadioStation__t,s__SetOrClass) ).

fof(kb_SUMO_2008,axiom,
    s__engineeringSubcomponent(s__AMRadioStation,s__RadioSystem) ).

fof(kb_SUMO_2009,axiom,
    s__documentation(s__AMRadioStation,s__EnglishLanguage,'An &%AMRadioStation is an &%engineeringSubcomponent of an &%AMRadioSystem.') ).

fof(kb_SUMO_2010,axiom,
    s__subclass(s__FMRadioStation,s__RadioStation) ).

fof(kb_SUMO_2011,axiom,
    s__instance(s__FMRadioStation__t,s__SetOrClass) ).

fof(kb_SUMO_2012,axiom,
    s__engineeringSubcomponent(s__FMRadioStation,s__RadioSystem) ).

fof(kb_SUMO_2013,axiom,
    s__documentation(s__FMRadioStation,s__EnglishLanguage,'A &%FMRadioStation is an &%engineeringSubcomponent of an &%FMRadioSystem.') ).

fof(kb_SUMO_2014,axiom,
    s__subclass(s__ShortwaveRadioStation,s__RadioStation) ).

fof(kb_SUMO_2015,axiom,
    s__instance(s__ShortwaveRadioStation__t,s__SetOrClass) ).

fof(kb_SUMO_2016,axiom,
    s__instance(s__RadioStation__t,s__SetOrClass) ).

fof(kb_SUMO_2017,axiom,
    s__engineeringSubcomponent(s__ShortwaveRadioStation,s__RadioSystem) ).

fof(kb_SUMO_2018,axiom,
    s__documentation(s__ShortwaveRadioStation,s__EnglishLanguage,'A &%ShortwaveRadioStation is an &%engineeringSubcomponent of a &%ShortwaveRadioSystem.') ).

fof(kb_SUMO_2019,axiom,
    ! [V__SYSTEM] :
      ( s__instance(V__SYSTEM,s__EngineeringComponent)
     => ( s__instance(V__SYSTEM,s__RadioSystem)
       => ? [V__DEVICE] :
            ( s__instance(V__DEVICE,s__EngineeringComponent)
            & s__instance(V__DEVICE,s__RadioReceiver)
            & s__engineeringSubcomponent(V__DEVICE,V__SYSTEM) ) ) ) ).

fof(kb_SUMO_2020,axiom,
    s__subclass(s__TelevisionSystem,s__CommunicationSystem) ).

fof(kb_SUMO_2021,axiom,
    s__instance(s__TelevisionSystem__t,s__SetOrClass) ).

fof(kb_SUMO_2022,axiom,
    s__documentation(s__TelevisionSystem,s__EnglishLanguage,'A system for &%Broadcasting and receiving television signals.') ).

fof(kb_SUMO_2023,axiom,
    s__subclass(s__TelevisionStation,s__BroadcastingStation) ).

fof(kb_SUMO_2024,axiom,
    s__instance(s__TelevisionStation__t,s__SetOrClass) ).

fof(kb_SUMO_2025,axiom,
    s__instance(s__BroadcastingStation__t,s__SetOrClass) ).

fof(kb_SUMO_2026,axiom,
    s__engineeringSubcomponent(s__TelevisionStation,s__TelevisionSystem) ).

fof(kb_SUMO_2027,axiom,
    s__documentation(s__TelevisionStation,s__EnglishLanguage,'A &%TelevisionStation is an &%engineeringSubcomponent of a &%TelevisionSystem.') ).

fof(kb_SUMO_2028,axiom,
    ! [V__SYSTEM] :
      ( s__instance(V__SYSTEM,s__EngineeringComponent)
     => ( s__instance(V__SYSTEM,s__TelevisionSystem)
       => ? [V__STATION] :
            ( s__instance(V__STATION,s__EngineeringComponent)
            & s__instance(V__STATION,s__TelevisionStation)
            & s__engineeringSubcomponent(V__STATION,V__SYSTEM) ) ) ) ).

fof(kb_SUMO_2029,axiom,
    s__subclass(s__CableTelevisionSystem,s__CommunicationSystem) ).

fof(kb_SUMO_2030,axiom,
    s__instance(s__CableTelevisionSystem__t,s__SetOrClass) ).

fof(kb_SUMO_2031,axiom,
    s__documentation(s__CableTelevisionSystem,s__EnglishLanguage,'A &%CableTelevisionSystem is a &%CommunicationSystem for cable television.') ).

fof(kb_SUMO_2032,axiom,
    ! [V__SYSTEM] :
      ( s__instance(V__SYSTEM,s__EngineeringComponent)
     => ( s__instance(V__SYSTEM,s__CableTelevisionSystem)
       => ? [V__DEVICE] :
            ( s__instance(V__DEVICE,s__EngineeringComponent)
            & s__instance(V__DEVICE,s__TelevisionReceiver)
            & s__engineeringSubcomponent(V__DEVICE,V__SYSTEM) ) ) ) ).

fof(kb_SUMO_2033,axiom,
    s__subclass(s__SatelliteTelevisionSystem,s__CommunicationSystem) ).

fof(kb_SUMO_2034,axiom,
    s__instance(s__SatelliteTelevisionSystem__t,s__SetOrClass) ).

fof(kb_SUMO_2035,axiom,
    s__documentation(s__SatelliteTelevisionSystem,s__EnglishLanguage,'&%SatelliteTelevisionSystem is a &%CommunicationSystem where &%ArtificialSatellite is used to transfer TV signals') ).

fof(kb_SUMO_2036,axiom,
    s__termFormat(s__EnglishLanguage,s__SatelliteTelevisionSystem,'satellite tv') ).

fof(kb_SUMO_2037,axiom,
    ! [V__TV] :
      ( s__instance(V__TV,s__Collection)
     => ( s__instance(V__TV,s__SatelliteTelevisionSystem)
       => ? [V__SAT,V__RECEIVE] :
            ( s__instance(V__RECEIVE,s__SelfConnectedObject)
            & s__instance(V__SAT,s__SelfConnectedObject)
            & s__instance(V__SAT,s__ArtificialSatellite)
            & s__member(V__SAT,V__TV)
            & s__instance(V__RECEIVE,s__TelevisionReceiver)
            & s__member(V__RECEIVE,V__TV) ) ) ) ).

fof(kb_SUMO_2038,axiom,
    s__subclass(s__BroadcastNetwork,s__CommunicationSystem) ).

fof(kb_SUMO_2039,axiom,
    s__instance(s__BroadcastNetwork__t,s__SetOrClass) ).

fof(kb_SUMO_2040,axiom,
    s__documentation(s__BroadcastNetwork,s__EnglishLanguage,'&%BroadcastNetwork is the subclass of &%CommunicationSystems consisting of &%BroadcastingStations that are linked electronically and managed or owned by one organization.') ).

fof(kb_SUMO_2041,axiom,
    ! [V__N] :
      ( s__instance(V__N,s__BroadcastNetwork)
     => ! [V__M] :
          ( ( s__instance(V__M,s__SelfConnectedObject)
            & s__instance(V__N,s__Collection) )
         => ( s__member(V__M,V__N)
           => s__instance(V__M,s__BroadcastingStation) ) ) ) ).

fof(kb_SUMO_2042,axiom,
    ! [V__N] :
      ( s__instance(V__N,s__BroadcastNetwork)
     => ? [V__O] :
          ( s__instance(V__O,s__Agent)
          & s__instance(V__O,s__Organization)
          & ! [V__M] :
              ( ( s__instance(V__M,s__SelfConnectedObject)
                & s__instance(V__N,s__Collection) )
             => ( s__member(V__M,V__N)
               => s__possesses(V__O,V__M) ) ) ) ) ).

fof(kb_SUMO_2043,axiom,
    s__subclass(s__TelevisionReceiver,s__ReceiverDevice) ).

fof(kb_SUMO_2044,axiom,
    s__instance(s__TelevisionReceiver__t,s__SetOrClass) ).

fof(kb_SUMO_2045,axiom,
    s__subclass(s__TelevisionReceiver,s__EngineeringComponent) ).

fof(kb_SUMO_2046,axiom,
    s__synonymousExternalConcept(television,s__TelevisionReceiver,s__EnglishLanguage) ).

fof(kb_SUMO_2047,axiom,
    s__synonymousExternalConcept('TV',s__TelevisionReceiver,s__EnglishLanguage) ).

fof(kb_SUMO_2048,axiom,
    s__documentation(s__TelevisionReceiver,s__EnglishLanguage,'A &%TelevisionReceiver is a &%Device for receiving television broadcast signals from a &%TelevisionStation or signals transmitted through a cable from a &%CableTelevisionSystem.') ).

fof(kb_SUMO_2049,axiom,
    ! [V__SYSTEM] :
      ( s__instance(V__SYSTEM,s__EngineeringComponent)
     => ( s__instance(V__SYSTEM,s__TelevisionSystem)
       => ? [V__DEVICE] :
            ( s__instance(V__DEVICE,s__EngineeringComponent)
            & s__instance(V__DEVICE,s__TelevisionReceiver)
            & s__engineeringSubcomponent(V__DEVICE,V__SYSTEM) ) ) ) ).

fof(kb_SUMO_2050,axiom,
    ! [V__T] :
      ( s__instance(V__T,s__Object)
     => ( s__instance(V__T,s__TelevisionReceiver)
       => s__capability(s__TelevisionBroadcasting,s__patient__m,V__T) ) ) ).

fof(kb_SUMO_2051,axiom,
    s__subclass(s__TelevisionSet,s__ElectricDevice) ).

fof(kb_SUMO_2052,axiom,
    s__instance(s__TelevisionSet__t,s__SetOrClass) ).

fof(kb_SUMO_2053,axiom,
    s__documentation(s__TelevisionSet,s__EnglishLanguage,'&%TelevisionSet is an &%ElectricDevice comprised of a &%TelevisionReceiver and some form of &%VideoDisplay and is part of a &%TelevisionSystem') ).

fof(kb_SUMO_2054,axiom,
    s__termFormat(s__EnglishLanguage,s__TelevisionSet,'television set') ).

fof(kb_SUMO_2055,axiom,
    ! [V__TV] :
      ( s__instance(V__TV,s__Object)
     => ( s__instance(V__TV,s__TelevisionSet)
       => ? [V__RECEIVER,V__DISPLAY] :
            ( s__instance(V__DISPLAY,s__Object)
            & s__instance(V__RECEIVER,s__Object)
            & s__instance(V__RECEIVER,s__TelevisionReceiver)
            & s__instance(V__DISPLAY,s__VideoDisplay)
            & s__part(V__RECEIVER,V__TV)
            & s__part(V__DISPLAY,V__TV) ) ) ) ).

fof(kb_SUMO_2056,axiom,
    s__subclass(s__TVRemoteControl,s__RemoteControl) ).

fof(kb_SUMO_2057,axiom,
    s__instance(s__TVRemoteControl__t,s__SetOrClass) ).

fof(kb_SUMO_2058,axiom,
    s__instance(s__RemoteControl__t,s__SetOrClass) ).

fof(kb_SUMO_2059,axiom,
    s__documentation(s__TVRemoteControl,s__EnglishLanguage,'&%TVRemoteControl is a type of &%RemoteControl that signals to a &%TelevisionReceiver') ).

fof(kb_SUMO_2060,axiom,
    s__termFormat(s__EnglishLanguage,s__TVRemoteControl,'tv remote') ).

fof(kb_SUMO_2061,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Agent)
     => ( s__instance(V__X,s__TVRemoteControl)
       => s__hasPurpose(V__X,'(? [V__SIGNAL,V__DEVICE] : (s__instance(V__SIGNAL,s__Process) & s__instance(V__SIGNAL,s__ElectronicSignalling) & s__agent(V__SIGNAL,V__X) & s__destination(V__SIGNAL,V__DEVICE) & s__instance(V__DEVICE,s__TelevisionReceiver)))') ) ) ).

fof(kb_SUMO_2062,axiom,
    s__instance(s__Internet,s__CommunicationSystem) ).

fof(kb_SUMO_2063,axiom,
    s__documentation(s__Internet,s__EnglishLanguage,'The &%Internet is a &%CommunicationSystem for the rapid delivery of information between computers.') ).

fof(kb_SUMO_2064,axiom,
    s__instance(s__internetCountryCode__m,s__BinaryPredicate) ).

fof(kb_SUMO_2065,axiom,
    s__domain(s__internetCountryCode__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_2066,axiom,
    s__domain(s__internetCountryCode__m,"2",s__SymbolicString) ).

fof(kb_SUMO_2067,axiom,
    s__documentation(s__internetCountryCode__m,s__EnglishLanguage,'(internetCountryCode ?AREA ?CODE) relates a &%GeopoliticalArea to the &%SymbolicString ?CODE used to identify the ?AREA on internet websites.') ).

fof(kb_SUMO_2068,axiom,
    s__subclass(s__InternetServiceProvider,s__CommunicationSystem) ).

fof(kb_SUMO_2069,axiom,
    s__instance(s__InternetServiceProvider__t,s__SetOrClass) ).

fof(kb_SUMO_2070,axiom,
    s__engineeringSubcomponent(s__InternetServiceProvider,s__Internet) ).

fof(kb_SUMO_2071,axiom,
    s__documentation(s__InternetServiceProvider,s__EnglishLanguage,'An &%InternetServiceProvider serves as an &%engineeringSubcomponent of the &%Internet for a given area.') ).

fof(kb_SUMO_2072,axiom,
    ! [V__PART] :
      ( s__instance(V__PART,s__EngineeringComponent)
     => ( s__instance(V__PART,s__InternetServiceProvider)
       => s__engineeringSubcomponent(V__PART,s__Internet) ) ) ).

fof(kb_SUMO_2073,axiom,
    s__instance(s__InternetUser,s__SocialRole) ).

fof(kb_SUMO_2074,axiom,
    s__documentation(s__InternetUser,s__EnglishLanguage,'An &%InternetUser is an individual who uses the &%Internet.') ).

fof(kb_SUMO_2075,axiom,
    ! [V__INDIVIDUAL] :
      ( s__instance(V__INDIVIDUAL,s__Agent)
     => ( s__attribute(V__INDIVIDUAL,s__InternetUser)
       => ? [V__PROCESS] :
            ( s__instance(V__PROCESS,s__Process)
            & s__agent(V__PROCESS,V__INDIVIDUAL)
            & s__instrument(V__PROCESS,s__Internet) ) ) ) ).

fof(kb_SUMO_2076,axiom,
    s__subclass(s__AmericanState,s__StateOrProvince) ).

fof(kb_SUMO_2077,axiom,
    s__documentation(s__AmericanState,s__EnglishLanguage,'The class of states that make up the &%UnitedStates.') ).

fof(kb_SUMO_2078,axiom,
    ! [V__STATE] :
      ( s__instance(V__STATE,s__Object)
     => ( s__instance(V__STATE,s__AmericanState)
       => s__part(V__STATE,s__UnitedStates) ) ) ).

fof(kb_SUMO_2079,axiom,
    s__instance(s__NewEngland,s__GeographicArea) ).

fof(kb_SUMO_2080,axiom,
    s__part(s__NewEngland,s__UnitedStates) ).

fof(kb_SUMO_2081,axiom,
    s__documentation(s__NewEngland,s__EnglishLanguage,'A &%GeographicArea in the &%UnitedStates that is made up of the states of Maine, New Hampshire, Vermont, Massachusetts, Rhode Island, and Connecticut.') ).

fof(kb_SUMO_2082,axiom,
    s__subclass(s__AmericanCity,s__City) ).

fof(kb_SUMO_2083,axiom,
    s__instance(s__AmericanCity__t,s__SetOrClass) ).

fof(kb_SUMO_2084,axiom,
    s__documentation(s__AmericanCity,s__EnglishLanguage,'The class of cities that are in the &%UnitedStates.') ).

fof(kb_SUMO_2085,axiom,
    ! [V__CITY] :
      ( s__instance(V__CITY,s__Object)
     => ( s__instance(V__CITY,s__AmericanCity)
       => s__part(V__CITY,s__UnitedStates) ) ) ).

fof(kb_SUMO_2086,axiom,
    s__instance(s__Europe,s__Continent) ).

fof(kb_SUMO_2087,axiom,
    s__documentation(s__Europe,s__EnglishLanguage,'The second smallest &%Continent.') ).

fof(kb_SUMO_2088,axiom,
    s__meetsSpatially(s__Europe,s__Asia) ).

fof(kb_SUMO_2089,axiom,
    s__subclass(s__EuropeanCity,s__City) ).

fof(kb_SUMO_2090,axiom,
    s__documentation(s__EuropeanCity,s__EnglishLanguage,'The class of cities that are in &%Europe.') ).

fof(kb_SUMO_2091,axiom,
    ! [V__CITY] :
      ( s__instance(V__CITY,s__Object)
     => ( s__instance(V__CITY,s__EuropeanCity)
       => s__part(V__CITY,s__Europe) ) ) ).

fof(kb_SUMO_2092,axiom,
    s__instance(s__Paris,s__EuropeanCity) ).

fof(kb_SUMO_2093,axiom,
    s__part(s__Paris,s__France) ).

fof(kb_SUMO_2094,axiom,
    s__documentation(s__Paris,s__EnglishLanguage,'The capital of &%France and the largest &%City of the country.') ).

fof(kb_SUMO_2095,axiom,
    ! [V__CITY] :
      ( s__instance(V__CITY,s__GeopoliticalArea)
     => ( ( s__instance(V__CITY,s__City)
          & s__part(V__CITY,s__France) )
       => lesseq(s__CardinalityFn(s__ResidentFn(V__CITY)),s__CardinalityFn(s__ResidentFn(s__Paris))) ) ) ).

fof(kb_SUMO_2096,axiom,
    s__instance(s__LondonUnitedKingdom,s__City) ).

fof(kb_SUMO_2097,axiom,
    s__capitalCity(s__LondonUnitedKingdom,s__UnitedKingdom) ).

fof(kb_SUMO_2098,axiom,
    s__instance(s__LondonUnitedKingdom,s__EuropeanCity) ).

fof(kb_SUMO_2099,axiom,
    s__documentation(s__LondonUnitedKingdom,s__EnglishLanguage,'The &%City of &%London in &%UnitedKingdom. The capital city and the largest city of the &%UnitedKingdom.') ).

fof(kb_SUMO_2100,axiom,
    s__subclass(s__EuropeanNation,s__Nation) ).

fof(kb_SUMO_2101,axiom,
    s__documentation(s__EuropeanNation,s__EnglishLanguage,'The class of nations that are in &%Europe.') ).

fof(kb_SUMO_2102,axiom,
    ! [V__N] :
      ( s__instance(V__N,s__Object)
     => ( s__instance(V__N,s__EuropeanNation)
       => s__part(V__N,s__Europe) ) ) ).

fof(kb_SUMO_2103,axiom,
    s__instance(s__SovietUnion,s__EuropeanNation) ).

fof(kb_SUMO_2104,axiom,
    s__documentation(s__SovietUnion,s__EnglishLanguage,'The former communist nation of the Soviet Union.') ).

fof(kb_SUMO_2105,axiom,
    s__geographicSubregion(s__Burundi,s__CentralAfrica) ).

fof(kb_SUMO_2106,axiom,
    s__instance(s__Burundi,s__Nation) ).

fof(kb_SUMO_2107,axiom,
    s__geographicSubregion(s__CentralAfricanRepublic,s__CentralAfrica) ).

fof(kb_SUMO_2108,axiom,
    s__instance(s__CentralAfricanRepublic,s__Nation) ).

fof(kb_SUMO_2109,axiom,
    s__geographicSubregion(s__Chad,s__CentralAfrica) ).

fof(kb_SUMO_2110,axiom,
    s__instance(s__Chad,s__Nation) ).

fof(kb_SUMO_2111,axiom,
    s__geographicSubregion(s__DemocraticRepublicOfTheCongo,s__CentralAfrica) ).

fof(kb_SUMO_2112,axiom,
    s__instance(s__DemocraticRepublicOfTheCongo,s__Nation) ).

fof(kb_SUMO_2113,axiom,
    s__geographicSubregion(s__Rwanda,s__CentralAfrica) ).

fof(kb_SUMO_2114,axiom,
    s__instance(s__Rwanda,s__Nation) ).

fof(kb_SUMO_2115,axiom,
    s__geographicSubregion(s__Djibouti,s__EasternAfrica) ).

fof(kb_SUMO_2116,axiom,
    s__instance(s__Djibouti,s__Nation) ).

fof(kb_SUMO_2117,axiom,
    s__geographicSubregion(s__Eritrea,s__EasternAfrica) ).

fof(kb_SUMO_2118,axiom,
    s__instance(s__Eritrea,s__Nation) ).

fof(kb_SUMO_2119,axiom,
    s__geographicSubregion(s__Ethiopia,s__EasternAfrica) ).

fof(kb_SUMO_2120,axiom,
    s__instance(s__Ethiopia,s__Nation) ).

fof(kb_SUMO_2121,axiom,
    s__geographicSubregion(s__Kenya,s__EasternAfrica) ).

fof(kb_SUMO_2122,axiom,
    s__instance(s__Kenya,s__Nation) ).

fof(kb_SUMO_2123,axiom,
    s__geographicSubregion(s__Seychelles,s__EasternAfrica) ).

fof(kb_SUMO_2124,axiom,
    s__instance(s__Seychelles,s__Nation) ).

fof(kb_SUMO_2125,axiom,
    s__geographicSubregion(s__Somalia,s__EasternAfrica) ).

fof(kb_SUMO_2126,axiom,
    s__instance(s__Somalia,s__Nation) ).

fof(kb_SUMO_2127,axiom,
    s__geographicSubregion(s__Tanzania,s__EasternAfrica) ).

fof(kb_SUMO_2128,axiom,
    s__instance(s__Tanzania,s__Nation) ).

fof(kb_SUMO_2129,axiom,
    s__geographicSubregion(s__Uganda,s__EasternAfrica) ).

fof(kb_SUMO_2130,axiom,
    s__instance(s__Uganda,s__Nation) ).

fof(kb_SUMO_2131,axiom,
    s__geographicSubregion(s__Algeria,s__NorthernAfrica) ).

fof(kb_SUMO_2132,axiom,
    s__instance(s__Algeria,s__Nation) ).

fof(kb_SUMO_2133,axiom,
    s__geographicSubregion(s__Egypt,s__NorthernAfrica) ).

fof(kb_SUMO_2134,axiom,
    s__instance(s__Egypt,s__Nation) ).

fof(kb_SUMO_2135,axiom,
    s__geographicSubregion(s__Libya,s__NorthernAfrica) ).

fof(kb_SUMO_2136,axiom,
    s__instance(s__Libya,s__Nation) ).

fof(kb_SUMO_2137,axiom,
    s__geographicSubregion(s__Mauritania,s__NorthernAfrica) ).

fof(kb_SUMO_2138,axiom,
    s__instance(s__Mauritania,s__Nation) ).

fof(kb_SUMO_2139,axiom,
    s__geographicSubregion(s__Morocco,s__NorthernAfrica) ).

fof(kb_SUMO_2140,axiom,
    s__instance(s__Morocco,s__Nation) ).

fof(kb_SUMO_2141,axiom,
    s__part(s__Morocco,s__Africa) ).

fof(kb_SUMO_2142,axiom,
    s__geographicSubregion(s__Sudan,s__NorthernAfrica) ).

fof(kb_SUMO_2143,axiom,
    s__instance(s__Sudan,s__Nation) ).

fof(kb_SUMO_2144,axiom,
    s__geographicSubregion(s__Tunisia,s__NorthernAfrica) ).

fof(kb_SUMO_2145,axiom,
    s__instance(s__Tunisia,s__Nation) ).

fof(kb_SUMO_2146,axiom,
    s__geographicSubregion(s__WesternSahara,s__NorthernAfrica) ).

fof(kb_SUMO_2147,axiom,
    s__instance(s__WesternSahara,s__Nation) ).

fof(kb_SUMO_2148,axiom,
    s__instance(s__BassasDaIndia,s__Island) ).

fof(kb_SUMO_2149,axiom,
    s__meetsSpatially(s__BassasDaIndia,s__IndianOcean) ).

fof(kb_SUMO_2150,axiom,
    s__instance(s__BouvetIsland,s__Island) ).

fof(kb_SUMO_2151,axiom,
    s__meetsSpatially(s__BouvetIsland,s__SouthAtlanticOcean) ).

fof(kb_SUMO_2152,axiom,
    s__instance(s__EuropaIsland,s__Island) ).

fof(kb_SUMO_2153,axiom,
    s__meetsSpatially(s__EuropaIsland,s__IndianOcean) ).

fof(kb_SUMO_2154,axiom,
    s__instance(s__GloriosoIslands,s__Island) ).

fof(kb_SUMO_2155,axiom,
    s__meetsSpatially(s__GloriosoIslands,s__IndianOcean) ).

fof(kb_SUMO_2156,axiom,
    s__instance(s__HeardIslandAndMcDonaldIslands,s__Island) ).

fof(kb_SUMO_2157,axiom,
    s__meetsSpatially(s__HeardIslandAndMcDonaldIslands,s__IndianOcean) ).

fof(kb_SUMO_2158,axiom,
    s__instance(s__JuanDeNovaIsland,s__Island) ).

fof(kb_SUMO_2159,axiom,
    s__meetsSpatially(s__JuanDeNovaIsland,s__IndianOcean) ).

fof(kb_SUMO_2160,axiom,
    s__instance(s__Mayotte,s__Island) ).

fof(kb_SUMO_2161,axiom,
    s__meetsSpatially(s__Mayotte,s__IndianOcean) ).

fof(kb_SUMO_2162,axiom,
    s__instance(s__TromelinIsland,s__Island) ).

fof(kb_SUMO_2163,axiom,
    s__meetsSpatially(s__TromelinIsland,s__IndianOcean) ).

fof(kb_SUMO_2164,axiom,
    s__geographicSubregion(s__Angola,s__SouthernAfrica) ).

fof(kb_SUMO_2165,axiom,
    s__instance(s__Angola,s__Nation) ).

fof(kb_SUMO_2166,axiom,
    s__geographicSubregion(s__BassasDaIndia,s__SouthernAfrica) ).

fof(kb_SUMO_2167,axiom,
    s__geographicSubregion(s__Botswana,s__SouthernAfrica) ).

fof(kb_SUMO_2168,axiom,
    s__instance(s__Botswana,s__Nation) ).

fof(kb_SUMO_2169,axiom,
    s__geographicSubregion(s__BouvetIsland,s__SouthernAfrica) ).

fof(kb_SUMO_2170,axiom,
    s__geographicSubregion(s__Comoros,s__SouthernAfrica) ).

fof(kb_SUMO_2171,axiom,
    s__instance(s__Comoros,s__Nation) ).

fof(kb_SUMO_2172,axiom,
    s__geographicSubregion(s__EuropaIsland,s__SouthernAfrica) ).

fof(kb_SUMO_2173,axiom,
    s__geographicSubregion(s__GloriosoIslands,s__SouthernAfrica) ).

fof(kb_SUMO_2174,axiom,
    s__geographicSubregion(s__HeardIslandAndMcDonaldIslands,s__SouthernAfrica) ).

fof(kb_SUMO_2175,axiom,
    s__geographicSubregion(s__JuanDeNovaIsland,s__SouthernAfrica) ).

fof(kb_SUMO_2176,axiom,
    s__geographicSubregion(s__Lesotho,s__SouthernAfrica) ).

fof(kb_SUMO_2177,axiom,
    s__instance(s__Lesotho,s__Nation) ).

fof(kb_SUMO_2178,axiom,
    s__geographicSubregion(s__Madagascar,s__SouthernAfrica) ).

fof(kb_SUMO_2179,axiom,
    s__instance(s__Madagascar,s__Nation) ).

fof(kb_SUMO_2180,axiom,
    s__geographicSubregion(s__Malawi,s__SouthernAfrica) ).

fof(kb_SUMO_2181,axiom,
    s__instance(s__Malawi,s__Nation) ).

fof(kb_SUMO_2182,axiom,
    s__geographicSubregion(s__Mauritius,s__SouthernAfrica) ).

fof(kb_SUMO_2183,axiom,
    s__instance(s__Mauritius,s__Nation) ).

fof(kb_SUMO_2184,axiom,
    s__geographicSubregion(s__Mayotte,s__SouthernAfrica) ).

fof(kb_SUMO_2185,axiom,
    s__geographicSubregion(s__Mozambique,s__SouthernAfrica) ).

fof(kb_SUMO_2186,axiom,
    s__instance(s__Mozambique,s__Nation) ).

fof(kb_SUMO_2187,axiom,
    s__geographicSubregion(s__Namibia,s__SouthernAfrica) ).

fof(kb_SUMO_2188,axiom,
    s__instance(s__Namibia,s__Nation) ).

fof(kb_SUMO_2189,axiom,
    s__geographicSubregion(s__Reunion,s__SouthernAfrica) ).

fof(kb_SUMO_2190,axiom,
    s__instance(s__Reunion,s__Nation) ).

fof(kb_SUMO_2191,axiom,
    s__geographicSubregion(s__SouthAfrica,s__SouthernAfrica) ).

fof(kb_SUMO_2192,axiom,
    s__instance(s__SouthAfrica,s__Nation) ).

fof(kb_SUMO_2193,axiom,
    s__geographicSubregion(s__Swaziland,s__SouthernAfrica) ).

fof(kb_SUMO_2194,axiom,
    s__instance(s__Swaziland,s__Nation) ).

fof(kb_SUMO_2195,axiom,
    s__geographicSubregion(s__TromelinIsland,s__SouthernAfrica) ).

fof(kb_SUMO_2196,axiom,
    s__geographicSubregion(s__Zambia,s__SouthernAfrica) ).

fof(kb_SUMO_2197,axiom,
    s__instance(s__Zambia,s__Nation) ).

fof(kb_SUMO_2198,axiom,
    s__geographicSubregion(s__Zimbabwe,s__SouthernAfrica) ).

fof(kb_SUMO_2199,axiom,
    s__instance(s__Zimbabwe,s__Nation) ).

fof(kb_SUMO_2200,axiom,
    s__geographicSubregion(s__Benin,s__WesternAfrica) ).

fof(kb_SUMO_2201,axiom,
    s__instance(s__Benin,s__Nation) ).

fof(kb_SUMO_2202,axiom,
    s__geographicSubregion(s__BurkinaFaso,s__WesternAfrica) ).

fof(kb_SUMO_2203,axiom,
    s__instance(s__BurkinaFaso,s__Nation) ).

fof(kb_SUMO_2204,axiom,
    s__geographicSubregion(s__Cameroon,s__WesternAfrica) ).

fof(kb_SUMO_2205,axiom,
    s__instance(s__Cameroon,s__Nation) ).

fof(kb_SUMO_2206,axiom,
    s__geographicSubregion(s__CapeVerde,s__WesternAfrica) ).

fof(kb_SUMO_2207,axiom,
    s__instance(s__CapeVerde,s__Nation) ).

fof(kb_SUMO_2208,axiom,
    s__geographicSubregion(s__CoteDIvoire,s__WesternAfrica) ).

fof(kb_SUMO_2209,axiom,
    s__instance(s__CoteDIvoire,s__Nation) ).

fof(kb_SUMO_2210,axiom,
    s__geographicSubregion(s__EquatorialGuinea,s__WesternAfrica) ).

fof(kb_SUMO_2211,axiom,
    s__instance(s__EquatorialGuinea,s__Nation) ).

fof(kb_SUMO_2212,axiom,
    s__geographicSubregion(s__Gabon,s__WesternAfrica) ).

fof(kb_SUMO_2213,axiom,
    s__instance(s__Gabon,s__Nation) ).

fof(kb_SUMO_2214,axiom,
    s__geographicSubregion(s__Gambia,s__WesternAfrica) ).

fof(kb_SUMO_2215,axiom,
    s__instance(s__Gambia,s__Nation) ).

fof(kb_SUMO_2216,axiom,
    s__geographicSubregion(s__Ghana,s__WesternAfrica) ).

fof(kb_SUMO_2217,axiom,
    s__instance(s__Ghana,s__Nation) ).

fof(kb_SUMO_2218,axiom,
    s__geographicSubregion(s__Guinea,s__WesternAfrica) ).

fof(kb_SUMO_2219,axiom,
    s__instance(s__Guinea,s__Nation) ).

fof(kb_SUMO_2220,axiom,
    s__geographicSubregion(s__GuineaBissau,s__WesternAfrica) ).

fof(kb_SUMO_2221,axiom,
    s__instance(s__GuineaBissau,s__Nation) ).

fof(kb_SUMO_2222,axiom,
    s__geographicSubregion(s__Liberia,s__WesternAfrica) ).

fof(kb_SUMO_2223,axiom,
    s__instance(s__Liberia,s__Nation) ).

fof(kb_SUMO_2224,axiom,
    s__geographicSubregion(s__Mali,s__WesternAfrica) ).

fof(kb_SUMO_2225,axiom,
    s__instance(s__Mali,s__Nation) ).

fof(kb_SUMO_2226,axiom,
    s__geographicSubregion(s__Niger,s__WesternAfrica) ).

fof(kb_SUMO_2227,axiom,
    s__instance(s__Niger,s__Nation) ).

fof(kb_SUMO_2228,axiom,
    s__geographicSubregion(s__Nigeria,s__WesternAfrica) ).

fof(kb_SUMO_2229,axiom,
    s__instance(s__Nigeria,s__Nation) ).

fof(kb_SUMO_2230,axiom,
    s__geographicSubregion(s__SaoTomeAndPrincipe,s__WesternAfrica) ).

fof(kb_SUMO_2231,axiom,
    s__instance(s__SaoTomeAndPrincipe,s__Nation) ).

fof(kb_SUMO_2232,axiom,
    s__geographicSubregion(s__Senegal,s__WesternAfrica) ).

fof(kb_SUMO_2233,axiom,
    s__instance(s__Senegal,s__Nation) ).

fof(kb_SUMO_2234,axiom,
    s__geographicSubregion(s__SierraLeone,s__WesternAfrica) ).

fof(kb_SUMO_2235,axiom,
    s__instance(s__SierraLeone,s__Nation) ).

fof(kb_SUMO_2236,axiom,
    s__geographicSubregion(s__Togo,s__WesternAfrica) ).

fof(kb_SUMO_2237,axiom,
    s__instance(s__Togo,s__Nation) ).

fof(kb_SUMO_2238,axiom,
    s__located(s__SaintHelena,s__SouthAtlanticOcean) ).

fof(kb_SUMO_2239,axiom,
    s__instance(s__SaintHelena,s__LandArea) ).

fof(kb_SUMO_2240,axiom,
    s__between(s__SouthAmerica,s__SaintHelena,s__WesternAfrica) ).

fof(kb_SUMO_2241,axiom,
    s__instance(s__GazaStrip,s__LandArea) ).

fof(kb_SUMO_2242,axiom,
    s__instance(s__WestBank,s__LandArea) ).

fof(kb_SUMO_2243,axiom,
    s__geographicSubregion(s__Bahrain,s__MiddleEastRegion) ).

fof(kb_SUMO_2244,axiom,
    s__instance(s__Bahrain,s__Nation) ).

fof(kb_SUMO_2245,axiom,
    s__geographicSubregion(s__Cyprus,s__MiddleEastRegion) ).

fof(kb_SUMO_2246,axiom,
    s__instance(s__Cyprus,s__Nation) ).

fof(kb_SUMO_2247,axiom,
    s__geographicSubregion(s__GazaStrip,s__MiddleEastRegion) ).

fof(kb_SUMO_2248,axiom,
    s__instance(s__GazaStrip,s__Nation) ).

fof(kb_SUMO_2249,axiom,
    s__geographicSubregion(s__Iran,s__MiddleEastRegion) ).

fof(kb_SUMO_2250,axiom,
    s__instance(s__Iran,s__Nation) ).

fof(kb_SUMO_2251,axiom,
    s__geographicSubregion(s__Iraq,s__MiddleEastRegion) ).

fof(kb_SUMO_2252,axiom,
    s__instance(s__Iraq,s__Nation) ).

fof(kb_SUMO_2253,axiom,
    s__geographicSubregion(s__Israel,s__MiddleEastRegion) ).

fof(kb_SUMO_2254,axiom,
    s__instance(s__Israel,s__Nation) ).

fof(kb_SUMO_2255,axiom,
    s__geographicSubregion(s__Jordan,s__MiddleEastRegion) ).

fof(kb_SUMO_2256,axiom,
    s__instance(s__Jordan,s__Nation) ).

fof(kb_SUMO_2257,axiom,
    s__geographicSubregion(s__Kuwait,s__MiddleEastRegion) ).

fof(kb_SUMO_2258,axiom,
    s__instance(s__Kuwait,s__Nation) ).

fof(kb_SUMO_2259,axiom,
    s__geographicSubregion(s__Lebanon,s__MiddleEastRegion) ).

fof(kb_SUMO_2260,axiom,
    s__instance(s__Lebanon,s__Nation) ).

fof(kb_SUMO_2261,axiom,
    s__geographicSubregion(s__Oman,s__MiddleEastRegion) ).

fof(kb_SUMO_2262,axiom,
    s__instance(s__Oman,s__Nation) ).

fof(kb_SUMO_2263,axiom,
    s__geographicSubregion(s__Qatar,s__MiddleEastRegion) ).

fof(kb_SUMO_2264,axiom,
    s__instance(s__Qatar,s__Nation) ).

fof(kb_SUMO_2265,axiom,
    s__geographicSubregion(s__SaudiArabia,s__MiddleEastRegion) ).

fof(kb_SUMO_2266,axiom,
    s__instance(s__SaudiArabia,s__Nation) ).

fof(kb_SUMO_2267,axiom,
    s__geographicSubregion(s__Syria,s__MiddleEastRegion) ).

fof(kb_SUMO_2268,axiom,
    s__instance(s__Syria,s__Nation) ).

fof(kb_SUMO_2269,axiom,
    s__geographicSubregion(s__UnitedArabEmirates,s__MiddleEastRegion) ).

fof(kb_SUMO_2270,axiom,
    s__instance(s__UnitedArabEmirates,s__Nation) ).

fof(kb_SUMO_2271,axiom,
    s__geographicSubregion(s__WestBank,s__MiddleEastRegion) ).

fof(kb_SUMO_2272,axiom,
    s__instance(s__WestBank,s__Nation) ).

fof(kb_SUMO_2273,axiom,
    s__geographicSubregion(s__Yemen,s__MiddleEastRegion) ).

fof(kb_SUMO_2274,axiom,
    s__instance(s__Yemen,s__Nation) ).

fof(kb_SUMO_2275,axiom,
    s__geographicSubregion(s__Austria,s__CentralEurope) ).

fof(kb_SUMO_2276,axiom,
    s__instance(s__Austria,s__Nation) ).

fof(kb_SUMO_2277,axiom,
    s__geographicSubregion(s__CzechRepublic,s__CentralEurope) ).

fof(kb_SUMO_2278,axiom,
    s__instance(s__CzechRepublic,s__Nation) ).

fof(kb_SUMO_2279,axiom,
    s__geographicSubregion(s__Germany,s__CentralEurope) ).

fof(kb_SUMO_2280,axiom,
    s__instance(s__Germany,s__EuropeanNation) ).

fof(kb_SUMO_2281,axiom,
    s__geographicSubregion(s__Hungary,s__CentralEurope) ).

fof(kb_SUMO_2282,axiom,
    s__instance(s__Hungary,s__Nation) ).

fof(kb_SUMO_2283,axiom,
    s__geographicSubregion(s__Liechtenstein,s__CentralEurope) ).

fof(kb_SUMO_2284,axiom,
    s__instance(s__Liechtenstein,s__Nation) ).

fof(kb_SUMO_2285,axiom,
    s__geographicSubregion(s__Poland,s__CentralEurope) ).

fof(kb_SUMO_2286,axiom,
    s__instance(s__Poland,s__EuropeanNation) ).

fof(kb_SUMO_2287,axiom,
    s__geographicSubregion(s__Slovakia,s__CentralEurope) ).

fof(kb_SUMO_2288,axiom,
    s__instance(s__Slovakia,s__Nation) ).

fof(kb_SUMO_2289,axiom,
    s__geographicSubregion(s__Slovenia,s__CentralEurope) ).

fof(kb_SUMO_2290,axiom,
    s__instance(s__Slovenia,s__Nation) ).

fof(kb_SUMO_2291,axiom,
    s__geographicSubregion(s__Switzerland,s__CentralEurope) ).

fof(kb_SUMO_2292,axiom,
    s__instance(s__Switzerland,s__EuropeanNation) ).

fof(kb_SUMO_2293,axiom,
    s__geographicSubregion(s__Belarus,s__EasternEurope) ).

fof(kb_SUMO_2294,axiom,
    s__instance(s__Belarus,s__Nation) ).

fof(kb_SUMO_2295,axiom,
    s__geographicSubregion(s__Estonia,s__EasternEurope) ).

fof(kb_SUMO_2296,axiom,
    s__instance(s__Estonia,s__Nation) ).

fof(kb_SUMO_2297,axiom,
    s__geographicSubregion(s__Latvia,s__EasternEurope) ).

fof(kb_SUMO_2298,axiom,
    s__instance(s__Latvia,s__Nation) ).

fof(kb_SUMO_2299,axiom,
    s__geographicSubregion(s__Lithuania,s__EasternEurope) ).

fof(kb_SUMO_2300,axiom,
    s__instance(s__Lithuania,s__Nation) ).

fof(kb_SUMO_2301,axiom,
    s__geographicSubregion(s__Moldova,s__EasternEurope) ).

fof(kb_SUMO_2302,axiom,
    s__instance(s__Moldova,s__Nation) ).

fof(kb_SUMO_2303,axiom,
    s__geographicSubregion(s__Ukraine,s__EasternEurope) ).

fof(kb_SUMO_2304,axiom,
    s__instance(s__Ukraine,s__Nation) ).

fof(kb_SUMO_2305,axiom,
    s__instance(s__FaroeIslands,s__LandArea) ).

fof(kb_SUMO_2306,axiom,
    s__instance(s__JanMayenIsland,s__LandArea) ).

fof(kb_SUMO_2307,axiom,
    s__instance(s__Svalbard,s__LandArea) ).

fof(kb_SUMO_2308,axiom,
    s__geographicSubregion(s__Denmark,s__NorthernEurope) ).

fof(kb_SUMO_2309,axiom,
    s__instance(s__Denmark,s__EuropeanNation) ).

fof(kb_SUMO_2310,axiom,
    s__geographicSubregion(s__FaroeIslands,s__NorthernEurope) ).

fof(kb_SUMO_2311,axiom,
    s__geographicSubregion(s__Finland,s__NorthernEurope) ).

fof(kb_SUMO_2312,axiom,
    s__instance(s__Finland,s__EuropeanNation) ).

fof(kb_SUMO_2313,axiom,
    s__geographicSubregion(s__Iceland,s__NorthernEurope) ).

fof(kb_SUMO_2314,axiom,
    s__instance(s__Iceland,s__EuropeanNation) ).

fof(kb_SUMO_2315,axiom,
    s__geographicSubregion(s__JanMayenIsland,s__NorthernEurope) ).

fof(kb_SUMO_2316,axiom,
    s__geographicSubregion(s__Norway,s__NorthernEurope) ).

fof(kb_SUMO_2317,axiom,
    s__instance(s__Norway,s__EuropeanNation) ).

fof(kb_SUMO_2318,axiom,
    s__geographicSubregion(s__Svalbard,s__NorthernEurope) ).

fof(kb_SUMO_2319,axiom,
    s__geographicSubregion(s__Sweden,s__NorthernEurope) ).

fof(kb_SUMO_2320,axiom,
    s__instance(s__Sweden,s__EuropeanNation) ).

fof(kb_SUMO_2321,axiom,
    s__geographicSubregion(s__Greece,s__SouthernEurope) ).

fof(kb_SUMO_2322,axiom,
    s__instance(s__Greece,s__EuropeanNation) ).

fof(kb_SUMO_2323,axiom,
    s__geographicSubregion(s__HolySee,s__SouthernEurope) ).

fof(kb_SUMO_2324,axiom,
    s__instance(s__HolySee,s__EuropeanNation) ).

fof(kb_SUMO_2325,axiom,
    s__geographicSubregion(s__Italy,s__SouthernEurope) ).

fof(kb_SUMO_2326,axiom,
    s__instance(s__Italy,s__EuropeanNation) ).

fof(kb_SUMO_2327,axiom,
    s__geographicSubregion(s__Malta,s__SouthernEurope) ).

fof(kb_SUMO_2328,axiom,
    s__instance(s__Malta,s__EuropeanNation) ).

fof(kb_SUMO_2329,axiom,
    s__geographicSubregion(s__SanMarino,s__SouthernEurope) ).

fof(kb_SUMO_2330,axiom,
    s__instance(s__SanMarino,s__EuropeanNation) ).

fof(kb_SUMO_2331,axiom,
    s__instance(s__Guernsey,s__LandArea) ).

fof(kb_SUMO_2332,axiom,
    s__instance(s__Jersey,s__LandArea) ).

fof(kb_SUMO_2333,axiom,
    s__instance(s__IsleOfMan,s__LandArea) ).

fof(kb_SUMO_2334,axiom,
    s__geographicSubregion(s__Belgium,s__WesternEurope) ).

fof(kb_SUMO_2335,axiom,
    s__instance(s__Belgium,s__EuropeanNation) ).

fof(kb_SUMO_2336,axiom,
    s__instance(s__EuropeanNation__t,s__SetOrClass) ).

fof(kb_SUMO_2337,axiom,
    s__geographicSubregion(s__France,s__WesternEurope) ).

fof(kb_SUMO_2338,axiom,
    s__instance(s__France,s__EuropeanNation) ).

fof(kb_SUMO_2339,axiom,
    s__geographicSubregion(s__Guernsey,s__WesternEurope) ).

fof(kb_SUMO_2340,axiom,
    s__geographicSubregion(s__Ireland,s__WesternEurope) ).

fof(kb_SUMO_2341,axiom,
    s__instance(s__Ireland,s__EuropeanNation) ).

fof(kb_SUMO_2342,axiom,
    s__geographicSubregion(s__Jersey,s__WesternEurope) ).

fof(kb_SUMO_2343,axiom,
    s__geographicSubregion(s__Luxembourg,s__WesternEurope) ).

fof(kb_SUMO_2344,axiom,
    s__instance(s__Luxembourg,s__Nation) ).

fof(kb_SUMO_2345,axiom,
    s__geographicSubregion(s__IsleOfMan,s__WesternEurope) ).

fof(kb_SUMO_2346,axiom,
    s__geographicSubregion(s__Monaco,s__WesternEurope) ).

fof(kb_SUMO_2347,axiom,
    s__instance(s__Monaco,s__EuropeanNation) ).

fof(kb_SUMO_2348,axiom,
    s__geographicSubregion(s__Netherlands,s__WesternEurope) ).

fof(kb_SUMO_2349,axiom,
    s__instance(s__Netherlands,s__EuropeanNation) ).

fof(kb_SUMO_2350,axiom,
    s__geographicSubregion(s__UnitedKingdom,s__WesternEurope) ).

fof(kb_SUMO_2351,axiom,
    s__instance(s__UnitedKingdom,s__EuropeanNation) ).

fof(kb_SUMO_2352,axiom,
    s__documentation(s__UnitedKingdom,s__EnglishLanguage,'The &%Nation comprising England, Scotland, Wales, and Northern Ireland.') ).

fof(kb_SUMO_2353,axiom,
    s__geographicSubregion(s__Albania,s__SoutheasternEurope) ).

fof(kb_SUMO_2354,axiom,
    s__instance(s__Albania,s__Nation) ).

fof(kb_SUMO_2355,axiom,
    s__geographicSubregion(s__BosniaAndHerzegovina,s__SoutheasternEurope) ).

fof(kb_SUMO_2356,axiom,
    s__instance(s__BosniaAndHerzegovina,s__Nation) ).

fof(kb_SUMO_2357,axiom,
    s__geographicSubregion(s__Bulgaria,s__SoutheasternEurope) ).

fof(kb_SUMO_2358,axiom,
    s__instance(s__Bulgaria,s__Nation) ).

fof(kb_SUMO_2359,axiom,
    s__geographicSubregion(s__Croatia,s__SoutheasternEurope) ).

fof(kb_SUMO_2360,axiom,
    s__instance(s__Croatia,s__Nation) ).

fof(kb_SUMO_2361,axiom,
    s__geographicSubregion(s__Macedonia,s__SoutheasternEurope) ).

fof(kb_SUMO_2362,axiom,
    s__instance(s__Macedonia,s__Nation) ).

fof(kb_SUMO_2363,axiom,
    s__geographicSubregion(s__Romania,s__SoutheasternEurope) ).

fof(kb_SUMO_2364,axiom,
    s__instance(s__Romania,s__Nation) ).

fof(kb_SUMO_2365,axiom,
    s__geographicSubregion(s__Turkey,s__SoutheasternEurope) ).

fof(kb_SUMO_2366,axiom,
    s__instance(s__Turkey,s__Nation) ).

fof(kb_SUMO_2367,axiom,
    s__geographicSubregion(s__SerbiaAndMontenegro,s__SoutheasternEurope) ).

fof(kb_SUMO_2368,axiom,
    s__instance(s__SerbiaAndMontenegro,s__Nation) ).

fof(kb_SUMO_2369,axiom,
    s__instance(s__Gibraltar,s__LandArea) ).

fof(kb_SUMO_2370,axiom,
    s__geographicSubregion(s__Andorra,s__SouthwesternEurope) ).

fof(kb_SUMO_2371,axiom,
    s__instance(s__Andorra,s__EuropeanNation) ).

fof(kb_SUMO_2372,axiom,
    s__geographicSubregion(s__Gibraltar,s__SouthwesternEurope) ).

fof(kb_SUMO_2373,axiom,
    s__geographicSubregion(s__Portugal,s__SouthwesternEurope) ).

fof(kb_SUMO_2374,axiom,
    s__instance(s__Portugal,s__EuropeanNation) ).

fof(kb_SUMO_2375,axiom,
    s__geographicSubregion(s__Spain,s__SouthwesternEurope) ).

fof(kb_SUMO_2376,axiom,
    s__instance(s__Spain,s__EuropeanNation) ).

fof(kb_SUMO_2377,axiom,
    s__instance(s__Bermuda,s__LandArea) ).

fof(kb_SUMO_2378,axiom,
    s__instance(s__Greenland,s__LandArea) ).

fof(kb_SUMO_2379,axiom,
    s__instance(s__SaintPierreAndMiquelon,s__LandArea) ).

fof(kb_SUMO_2380,axiom,
    s__geographicSubregion(s__Bermuda,s__NorthAmerica) ).

fof(kb_SUMO_2381,axiom,
    s__geographicSubregion(s__UnitedStates,s__NorthAmerica) ).

fof(kb_SUMO_2382,axiom,
    s__instance(s__UnitedStates,s__Nation) ).

fof(kb_SUMO_2383,axiom,
    s__geographicSubregion(s__Canada,s__NorthernNorthAmerica) ).

fof(kb_SUMO_2384,axiom,
    s__instance(s__Canada,s__Nation) ).

fof(kb_SUMO_2385,axiom,
    s__meetsSpatially(s__Canada,s__UnitedStates) ).

fof(kb_SUMO_2386,axiom,
    s__geographicSubregion(s__Greenland,s__NorthernNorthAmerica) ).

fof(kb_SUMO_2387,axiom,
    s__geographicSubregion(s__SaintPierreAndMiquelon,s__NorthernNorthAmerica) ).

fof(kb_SUMO_2388,axiom,
    s__instance(s__Anguilla,s__LandArea) ).

fof(kb_SUMO_2389,axiom,
    s__instance(s__Aruba,s__LandArea) ).

fof(kb_SUMO_2390,axiom,
    s__instance(s__BritishVirginIslands,s__LandArea) ).

fof(kb_SUMO_2391,axiom,
    s__instance(s__CaymanIslands,s__LandArea) ).

fof(kb_SUMO_2392,axiom,
    s__instance(s__Guadeloupe,s__LandArea) ).

fof(kb_SUMO_2393,axiom,
    s__instance(s__Martinique,s__LandArea) ).

fof(kb_SUMO_2394,axiom,
    s__instance(s__Montserrat,s__LandArea) ).

fof(kb_SUMO_2395,axiom,
    s__instance(s__NavassaIsland,s__LandArea) ).

fof(kb_SUMO_2396,axiom,
    s__instance(s__NetherlandsAntilles,s__LandArea) ).

fof(kb_SUMO_2397,axiom,
    s__instance(s__TurksAndCaicosIslands,s__LandArea) ).

fof(kb_SUMO_2398,axiom,
    s__geographicSubregion(s__Anguilla,s__CaribbeanRegion) ).

fof(kb_SUMO_2399,axiom,
    s__geographicSubregion(s__AntiguaAndBarbuda,s__CaribbeanRegion) ).

fof(kb_SUMO_2400,axiom,
    s__instance(s__AntiguaAndBarbuda,s__Nation) ).

fof(kb_SUMO_2401,axiom,
    s__geographicSubregion(s__Aruba,s__CaribbeanRegion) ).

fof(kb_SUMO_2402,axiom,
    s__geographicSubregion(s__TheBahamas,s__CaribbeanRegion) ).

fof(kb_SUMO_2403,axiom,
    s__instance(s__TheBahamas,s__Nation) ).

fof(kb_SUMO_2404,axiom,
    s__geographicSubregion(s__Barbados,s__CaribbeanRegion) ).

fof(kb_SUMO_2405,axiom,
    s__instance(s__Barbados,s__Nation) ).

fof(kb_SUMO_2406,axiom,
    s__geographicSubregion(s__BritishVirginIslands,s__CaribbeanRegion) ).

fof(kb_SUMO_2407,axiom,
    s__geographicSubregion(s__CaymanIslands,s__CaribbeanRegion) ).

fof(kb_SUMO_2408,axiom,
    s__geographicSubregion(s__Cuba,s__CaribbeanRegion) ).

fof(kb_SUMO_2409,axiom,
    s__instance(s__Cuba,s__Nation) ).

fof(kb_SUMO_2410,axiom,
    s__instance(s__Cuba,s__Island) ).

fof(kb_SUMO_2411,axiom,
    s__geographicSubregion(s__Dominica,s__CaribbeanRegion) ).

fof(kb_SUMO_2412,axiom,
    s__instance(s__Dominica,s__Nation) ).

fof(kb_SUMO_2413,axiom,
    s__geographicSubregion(s__DominicanRepublic,s__CaribbeanRegion) ).

fof(kb_SUMO_2414,axiom,
    s__instance(s__DominicanRepublic,s__Nation) ).

fof(kb_SUMO_2415,axiom,
    s__geographicSubregion(s__Grenada,s__CaribbeanRegion) ).

fof(kb_SUMO_2416,axiom,
    s__instance(s__Grenada,s__Nation) ).

fof(kb_SUMO_2417,axiom,
    s__geographicSubregion(s__Guadeloupe,s__CaribbeanRegion) ).

fof(kb_SUMO_2418,axiom,
    s__geographicSubregion(s__Haiti,s__CaribbeanRegion) ).

fof(kb_SUMO_2419,axiom,
    s__instance(s__Haiti,s__Nation) ).

fof(kb_SUMO_2420,axiom,
    s__geographicSubregion(s__Jamaica,s__CaribbeanRegion) ).

fof(kb_SUMO_2421,axiom,
    s__instance(s__Jamaica,s__Nation) ).

fof(kb_SUMO_2422,axiom,
    s__geographicSubregion(s__Martinique,s__CaribbeanRegion) ).

fof(kb_SUMO_2423,axiom,
    s__geographicSubregion(s__Montserrat,s__CaribbeanRegion) ).

fof(kb_SUMO_2424,axiom,
    s__geographicSubregion(s__NavassaIsland,s__CaribbeanRegion) ).

fof(kb_SUMO_2425,axiom,
    s__geographicSubregion(s__NetherlandsAntilles,s__CaribbeanRegion) ).

fof(kb_SUMO_2426,axiom,
    s__geographicSubregion(s__PuertoRico,s__CaribbeanRegion) ).

fof(kb_SUMO_2427,axiom,
    s__geographicSubregion(s__SaintKittsAndNevis,s__CaribbeanRegion) ).

fof(kb_SUMO_2428,axiom,
    s__instance(s__SaintKittsAndNevis,s__Nation) ).

fof(kb_SUMO_2429,axiom,
    s__geographicSubregion(s__SaintLucia,s__CaribbeanRegion) ).

fof(kb_SUMO_2430,axiom,
    s__instance(s__SaintLucia,s__Nation) ).

fof(kb_SUMO_2431,axiom,
    s__geographicSubregion(s__SaintVincentAndTheGrenadines,s__CaribbeanRegion) ).

fof(kb_SUMO_2432,axiom,
    s__instance(s__SaintVincentAndTheGrenadines,s__Nation) ).

fof(kb_SUMO_2433,axiom,
    s__geographicSubregion(s__TrinidadAndTobago,s__CaribbeanRegion) ).

fof(kb_SUMO_2434,axiom,
    s__instance(s__TrinidadAndTobago,s__Nation) ).

fof(kb_SUMO_2435,axiom,
    s__geographicSubregion(s__TurksAndCaicosIslands,s__CaribbeanRegion) ).

fof(kb_SUMO_2436,axiom,
    s__geographicSubregion(s__VirginIslands,s__CaribbeanRegion) ).

fof(kb_SUMO_2437,axiom,
    s__instance(s__ClippertonIsland,s__LandArea) ).

fof(kb_SUMO_2438,axiom,
    s__geographicSubregion(s__Belize,s__MiddleAmerica) ).

fof(kb_SUMO_2439,axiom,
    s__instance(s__Belize,s__Nation) ).

fof(kb_SUMO_2440,axiom,
    s__geographicSubregion(s__ClippertonIsland,s__MiddleAmerica) ).

fof(kb_SUMO_2441,axiom,
    s__geographicSubregion(s__CostaRica,s__MiddleAmerica) ).

fof(kb_SUMO_2442,axiom,
    s__instance(s__CostaRica,s__Nation) ).

fof(kb_SUMO_2443,axiom,
    s__geographicSubregion(s__ElSalvador,s__MiddleAmerica) ).

fof(kb_SUMO_2444,axiom,
    s__instance(s__ElSalvador,s__Nation) ).

fof(kb_SUMO_2445,axiom,
    s__geographicSubregion(s__Guatemala,s__MiddleAmerica) ).

fof(kb_SUMO_2446,axiom,
    s__instance(s__Guatemala,s__Nation) ).

fof(kb_SUMO_2447,axiom,
    s__geographicSubregion(s__Honduras,s__MiddleAmerica) ).

fof(kb_SUMO_2448,axiom,
    s__instance(s__Honduras,s__Nation) ).

fof(kb_SUMO_2449,axiom,
    s__geographicSubregion(s__Mexico,s__MiddleAmerica) ).

fof(kb_SUMO_2450,axiom,
    s__instance(s__Mexico,s__Nation) ).

fof(kb_SUMO_2451,axiom,
    s__geographicSubregion(s__Nicaragua,s__MiddleAmerica) ).

fof(kb_SUMO_2452,axiom,
    s__instance(s__Nicaragua,s__Nation) ).

fof(kb_SUMO_2453,axiom,
    s__geographicSubregion(s__Panama,s__MiddleAmerica) ).

fof(kb_SUMO_2454,axiom,
    s__instance(s__Panama,s__Nation) ).

fof(kb_SUMO_2455,axiom,
    s__instance(s__FrenchGuiana,s__LandArea) ).

fof(kb_SUMO_2456,axiom,
    s__instance(s__FalklandIslands,s__LandArea) ).

fof(kb_SUMO_2457,axiom,
    s__instance(s__SouthGeorgiaAndTheSouthSandwichIslands,s__LandArea) ).

fof(kb_SUMO_2458,axiom,
    s__geographicSubregion(s__Bolivia,s__CentralSouthAmerica) ).

fof(kb_SUMO_2459,axiom,
    s__instance(s__Bolivia,s__Nation) ).

fof(kb_SUMO_2460,axiom,
    s__geographicSubregion(s__Paraguay,s__CentralSouthAmerica) ).

fof(kb_SUMO_2461,axiom,
    s__instance(s__Paraguay,s__Nation) ).

fof(kb_SUMO_2462,axiom,
    s__geographicSubregion(s__Brazil,s__EasternSouthAmerica) ).

fof(kb_SUMO_2463,axiom,
    s__instance(s__Brazil,s__Nation) ).

fof(kb_SUMO_2464,axiom,
    s__geographicSubregion(s__Colombia,s__NorthernSouthAmerica) ).

fof(kb_SUMO_2465,axiom,
    s__instance(s__Colombia,s__Nation) ).

fof(kb_SUMO_2466,axiom,
    s__geographicSubregion(s__FrenchGuiana,s__NorthernSouthAmerica) ).

fof(kb_SUMO_2467,axiom,
    s__geographicSubregion(s__Guyana,s__NorthernSouthAmerica) ).

fof(kb_SUMO_2468,axiom,
    s__instance(s__Guyana,s__Nation) ).

fof(kb_SUMO_2469,axiom,
    s__geographicSubregion(s__Suriname,s__NorthernSouthAmerica) ).

fof(kb_SUMO_2470,axiom,
    s__instance(s__Suriname,s__Nation) ).

fof(kb_SUMO_2471,axiom,
    s__geographicSubregion(s__Venezuela,s__NorthernSouthAmerica) ).

fof(kb_SUMO_2472,axiom,
    s__instance(s__Venezuela,s__Nation) ).

fof(kb_SUMO_2473,axiom,
    s__geographicSubregion(s__Argentina,s__SouthernSouthAmerica) ).

fof(kb_SUMO_2474,axiom,
    s__instance(s__Argentina,s__Nation) ).

fof(kb_SUMO_2475,axiom,
    s__geographicSubregion(s__Chile,s__SouthernSouthAmerica) ).

fof(kb_SUMO_2476,axiom,
    s__instance(s__Chile,s__Nation) ).

fof(kb_SUMO_2477,axiom,
    s__geographicSubregion(s__FalklandIslands,s__SouthernSouthAmerica) ).

fof(kb_SUMO_2478,axiom,
    s__geographicSubregion(s__SouthGeorgiaAndTheSouthSandwichIslands,s__SouthernSouthAmerica) ).

fof(kb_SUMO_2479,axiom,
    s__geographicSubregion(s__Uruguay,s__SouthernSouthAmerica) ).

fof(kb_SUMO_2480,axiom,
    s__instance(s__Uruguay,s__Nation) ).

fof(kb_SUMO_2481,axiom,
    s__geographicSubregion(s__Ecuador,s__WesternSouthAmerica) ).

fof(kb_SUMO_2482,axiom,
    s__instance(s__Ecuador,s__Nation) ).

fof(kb_SUMO_2483,axiom,
    s__geographicSubregion(s__Peru,s__WesternSouthAmerica) ).

fof(kb_SUMO_2484,axiom,
    s__instance(s__Peru,s__Nation) ).

fof(kb_SUMO_2485,axiom,
    s__geographicSubregion(s__Kazakhstan,s__CentralAsia) ).

fof(kb_SUMO_2486,axiom,
    s__instance(s__Kazakhstan,s__Nation) ).

fof(kb_SUMO_2487,axiom,
    s__geographicSubregion(s__Kyrgyzstan,s__CentralAsia) ).

fof(kb_SUMO_2488,axiom,
    s__instance(s__Kyrgyzstan,s__Nation) ).

fof(kb_SUMO_2489,axiom,
    s__geographicSubregion(s__Tajikistan,s__CentralAsia) ).

fof(kb_SUMO_2490,axiom,
    s__instance(s__Tajikistan,s__Nation) ).

fof(kb_SUMO_2491,axiom,
    s__geographicSubregion(s__Turkmenistan,s__CentralAsia) ).

fof(kb_SUMO_2492,axiom,
    s__instance(s__Turkmenistan,s__Nation) ).

fof(kb_SUMO_2493,axiom,
    s__geographicSubregion(s__Uzbekistan,s__CentralAsia) ).

fof(kb_SUMO_2494,axiom,
    s__instance(s__Uzbekistan,s__Nation) ).

fof(kb_SUMO_2495,axiom,
    s__instance(s__HongKong,s__LandArea) ).

fof(kb_SUMO_2496,axiom,
    s__instance(s__Macau,s__LandArea) ).

fof(kb_SUMO_2497,axiom,
    s__geographicSubregion(s__China,s__EasternAsia) ).

fof(kb_SUMO_2498,axiom,
    s__instance(s__China,s__Nation) ).

fof(kb_SUMO_2499,axiom,
    s__geographicSubregion(s__HongKong,s__EasternAsia) ).

fof(kb_SUMO_2500,axiom,
    s__geographicSubregion(s__Japan,s__EasternAsia) ).

fof(kb_SUMO_2501,axiom,
    s__instance(s__Japan,s__Nation) ).

fof(kb_SUMO_2502,axiom,
    s__instance(s__Japan,s__Island) ).

fof(kb_SUMO_2503,axiom,
    s__geographicSubregion(s__NorthKorea,s__EasternAsia) ).

fof(kb_SUMO_2504,axiom,
    s__instance(s__NorthKorea,s__Nation) ).

fof(kb_SUMO_2505,axiom,
    s__geographicSubregion(s__SouthKorea,s__EasternAsia) ).

fof(kb_SUMO_2506,axiom,
    s__instance(s__SouthKorea,s__Nation) ).

fof(kb_SUMO_2507,axiom,
    s__geographicSubregion(s__Macau,s__EasternAsia) ).

fof(kb_SUMO_2508,axiom,
    s__geographicSubregion(s__Taiwan,s__EasternAsia) ).

fof(kb_SUMO_2509,axiom,
    s__instance(s__Taiwan,s__Nation) ).

fof(kb_SUMO_2510,axiom,
    s__geographicSubregion(s__Mongolia,s__NorthernAsia) ).

fof(kb_SUMO_2511,axiom,
    s__instance(s__Mongolia,s__Nation) ).

fof(kb_SUMO_2512,axiom,
    s__geographicSubregion(s__Russia,s__NorthernAsia) ).

fof(kb_SUMO_2513,axiom,
    s__instance(s__Russia,s__Nation) ).

fof(kb_SUMO_2514,axiom,
    s__instance(s__BritishIndianOceanTerritory,s__LandArea) ).

fof(kb_SUMO_2515,axiom,
    s__geographicSubregion(s__Afghanistan,s__SouthernAsia) ).

fof(kb_SUMO_2516,axiom,
    s__instance(s__Afghanistan,s__Nation) ).

fof(kb_SUMO_2517,axiom,
    s__geographicSubregion(s__Bangladesh,s__SouthernAsia) ).

fof(kb_SUMO_2518,axiom,
    s__instance(s__Bangladesh,s__Nation) ).

fof(kb_SUMO_2519,axiom,
    s__geographicSubregion(s__Bhutan,s__SouthernAsia) ).

fof(kb_SUMO_2520,axiom,
    s__instance(s__Bhutan,s__Nation) ).

fof(kb_SUMO_2521,axiom,
    s__geographicSubregion(s__BritishIndianOceanTerritory,s__SouthernAsia) ).

fof(kb_SUMO_2522,axiom,
    s__geographicSubregion(s__India,s__SouthernAsia) ).

fof(kb_SUMO_2523,axiom,
    s__instance(s__India,s__Nation) ).

fof(kb_SUMO_2524,axiom,
    s__geographicSubregion(s__Maldives,s__SouthernAsia) ).

fof(kb_SUMO_2525,axiom,
    s__instance(s__Maldives,s__Nation) ).

fof(kb_SUMO_2526,axiom,
    s__geographicSubregion(s__Nepal,s__SouthernAsia) ).

fof(kb_SUMO_2527,axiom,
    s__instance(s__Nepal,s__Nation) ).

fof(kb_SUMO_2528,axiom,
    s__geographicSubregion(s__Pakistan,s__SouthernAsia) ).

fof(kb_SUMO_2529,axiom,
    s__instance(s__Pakistan,s__Nation) ).

fof(kb_SUMO_2530,axiom,
    s__geographicSubregion(s__SriLanka,s__SouthernAsia) ).

fof(kb_SUMO_2531,axiom,
    s__instance(s__SriLanka,s__Nation) ).

fof(kb_SUMO_2532,axiom,
    s__located(s__FrenchSouthernAndAntarcticLands,s__IndianOcean) ).

fof(kb_SUMO_2533,axiom,
    s__instance(s__FrenchSouthernAndAntarcticLands,s__LandArea) ).

fof(kb_SUMO_2534,axiom,
    s__located(s__FrenchSouthernAndAntarcticLands,s__DirectionalSubregionFn(s__South,s__IndianOcean)) ).

fof(kb_SUMO_2535,axiom,
    s__instance(s__AshmoreAndCartierIslands,s__LandArea) ).

fof(kb_SUMO_2536,axiom,
    s__instance(s__ChristmasIsland,s__LandArea) ).

fof(kb_SUMO_2537,axiom,
    s__instance(s__CocosKeelingIslands,s__LandArea) ).

fof(kb_SUMO_2538,axiom,
    s__instance(s__ParacelIslands,s__LandArea) ).

fof(kb_SUMO_2539,axiom,
    s__instance(s__SpratlyIslands,s__LandArea) ).

fof(kb_SUMO_2540,axiom,
    s__geographicSubregion(s__AshmoreAndCartierIslands,s__SoutheasternAsia) ).

fof(kb_SUMO_2541,axiom,
    s__geographicSubregion(s__Brunei,s__SoutheasternAsia) ).

fof(kb_SUMO_2542,axiom,
    s__instance(s__Brunei,s__Nation) ).

fof(kb_SUMO_2543,axiom,
    s__geographicSubregion(s__Myanmar,s__SoutheasternAsia) ).

fof(kb_SUMO_2544,axiom,
    s__formerName('Burma',s__Myanmar) ).

fof(kb_SUMO_2545,axiom,
    s__instance(s__Myanmar,s__Nation) ).

fof(kb_SUMO_2546,axiom,
    s__geographicSubregion(s__Cambodia,s__SoutheasternAsia) ).

fof(kb_SUMO_2547,axiom,
    s__instance(s__Cambodia,s__Nation) ).

fof(kb_SUMO_2548,axiom,
    s__geographicSubregion(s__ChristmasIsland,s__SoutheasternAsia) ).

fof(kb_SUMO_2549,axiom,
    s__geographicSubregion(s__CocosKeelingIslands,s__SoutheasternAsia) ).

fof(kb_SUMO_2550,axiom,
    s__geographicSubregion(s__EastTimor,s__SoutheasternAsia) ).

fof(kb_SUMO_2551,axiom,
    s__instance(s__EastTimor,s__Nation) ).

fof(kb_SUMO_2552,axiom,
    s__geographicSubregion(s__Indonesia,s__SoutheasternAsia) ).

fof(kb_SUMO_2553,axiom,
    s__instance(s__Indonesia,s__Nation) ).

fof(kb_SUMO_2554,axiom,
    s__geographicSubregion(s__Laos,s__SoutheasternAsia) ).

fof(kb_SUMO_2555,axiom,
    s__instance(s__Laos,s__Nation) ).

fof(kb_SUMO_2556,axiom,
    s__geographicSubregion(s__Malaysia,s__SoutheasternAsia) ).

fof(kb_SUMO_2557,axiom,
    s__instance(s__Malaysia,s__Nation) ).

fof(kb_SUMO_2558,axiom,
    s__geographicSubregion(s__PapuaNewGuinea,s__SoutheasternAsia) ).

fof(kb_SUMO_2559,axiom,
    s__instance(s__PapuaNewGuinea,s__Nation) ).

fof(kb_SUMO_2560,axiom,
    s__geographicSubregion(s__ParacelIslands,s__SoutheasternAsia) ).

fof(kb_SUMO_2561,axiom,
    s__geographicSubregion(s__Philippines,s__SoutheasternAsia) ).

fof(kb_SUMO_2562,axiom,
    s__instance(s__Philippines,s__Nation) ).

fof(kb_SUMO_2563,axiom,
    s__geographicSubregion(s__Singapore,s__SoutheasternAsia) ).

fof(kb_SUMO_2564,axiom,
    s__instance(s__Singapore,s__Nation) ).

fof(kb_SUMO_2565,axiom,
    s__geographicSubregion(s__SpratlyIslands,s__SoutheasternAsia) ).

fof(kb_SUMO_2566,axiom,
    s__geographicSubregion(s__Thailand,s__SoutheasternAsia) ).

fof(kb_SUMO_2567,axiom,
    s__instance(s__Thailand,s__Nation) ).

fof(kb_SUMO_2568,axiom,
    s__geographicSubregion(s__Vietnam,s__SoutheasternAsia) ).

fof(kb_SUMO_2569,axiom,
    s__instance(s__Vietnam,s__Nation) ).

fof(kb_SUMO_2570,axiom,
    s__geographicSubregion(s__Armenia,s__SouthwesternAsia) ).

fof(kb_SUMO_2571,axiom,
    s__instance(s__Armenia,s__Nation) ).

fof(kb_SUMO_2572,axiom,
    s__geographicSubregion(s__Azerbaijan,s__SouthwesternAsia) ).

fof(kb_SUMO_2573,axiom,
    s__instance(s__Azerbaijan,s__Nation) ).

fof(kb_SUMO_2574,axiom,
    s__geographicSubregion(s__RepublicOfGeorgia,s__SouthwesternAsia) ).

fof(kb_SUMO_2575,axiom,
    s__instance(s__RepublicOfGeorgia,s__Nation) ).

fof(kb_SUMO_2576,axiom,
    s__instance(s__AmericanSamoa,s__LandArea) ).

fof(kb_SUMO_2577,axiom,
    s__instance(s__BakerIsland,s__LandArea) ).

fof(kb_SUMO_2578,axiom,
    s__instance(s__CookIslands,s__LandArea) ).

fof(kb_SUMO_2579,axiom,
    s__instance(s__CoralSeaIslands,s__LandArea) ).

fof(kb_SUMO_2580,axiom,
    s__instance(s__FrenchPolynesia,s__LandArea) ).

fof(kb_SUMO_2581,axiom,
    s__instance(s__HowlandIsland,s__LandArea) ).

fof(kb_SUMO_2582,axiom,
    s__instance(s__JarvisIsland,s__LandArea) ).

fof(kb_SUMO_2583,axiom,
    s__instance(s__JohnstonAtoll,s__LandArea) ).

fof(kb_SUMO_2584,axiom,
    s__instance(s__KingmanReef,s__LandArea) ).

fof(kb_SUMO_2585,axiom,
    s__instance(s__MidwayIslands,s__LandArea) ).

fof(kb_SUMO_2586,axiom,
    s__instance(s__NewCaledonia,s__LandArea) ).

fof(kb_SUMO_2587,axiom,
    s__instance(s__Niue,s__LandArea) ).

fof(kb_SUMO_2588,axiom,
    s__instance(s__NorfolkIsland,s__LandArea) ).

fof(kb_SUMO_2589,axiom,
    s__instance(s__NorthernMarianaIslands,s__LandArea) ).

fof(kb_SUMO_2590,axiom,
    s__instance(s__PalmyraAtoll,s__LandArea) ).

fof(kb_SUMO_2591,axiom,
    s__instance(s__PitcairnIslands,s__LandArea) ).

fof(kb_SUMO_2592,axiom,
    s__instance(s__Tokelau,s__LandArea) ).

fof(kb_SUMO_2593,axiom,
    s__instance(s__WakeIsland,s__LandArea) ).

fof(kb_SUMO_2594,axiom,
    s__instance(s__WallisAndFutuna,s__LandArea) ).

fof(kb_SUMO_2595,axiom,
    s__geographicSubregion(s__AmericanSamoa,s__Oceania) ).

fof(kb_SUMO_2596,axiom,
    s__geographicSubregion(s__Australia,s__Oceania) ).

fof(kb_SUMO_2597,axiom,
    s__instance(s__Australia,s__Nation) ).

fof(kb_SUMO_2598,axiom,
    s__part(s__Australia,s__Oceania) ).

fof(kb_SUMO_2599,axiom,
    s__geographicSubregion(s__BakerIsland,s__Oceania) ).

fof(kb_SUMO_2600,axiom,
    s__geographicSubregion(s__CookIslands,s__Oceania) ).

fof(kb_SUMO_2601,axiom,
    s__geographicSubregion(s__CoralSeaIslands,s__Oceania) ).

fof(kb_SUMO_2602,axiom,
    s__geographicSubregion(s__Fiji,s__Oceania) ).

fof(kb_SUMO_2603,axiom,
    s__instance(s__Fiji,s__Nation) ).

fof(kb_SUMO_2604,axiom,
    s__geographicSubregion(s__FrenchPolynesia,s__Oceania) ).

fof(kb_SUMO_2605,axiom,
    s__geographicSubregion(s__Guam,s__Oceania) ).

fof(kb_SUMO_2606,axiom,
    s__geographicSubregion(s__HowlandIsland,s__Oceania) ).

fof(kb_SUMO_2607,axiom,
    s__geographicSubregion(s__JarvisIsland,s__Oceania) ).

fof(kb_SUMO_2608,axiom,
    s__geographicSubregion(s__JohnstonAtoll,s__Oceania) ).

fof(kb_SUMO_2609,axiom,
    s__geographicSubregion(s__KingmanReef,s__Oceania) ).

fof(kb_SUMO_2610,axiom,
    s__geographicSubregion(s__Kiribati,s__Oceania) ).

fof(kb_SUMO_2611,axiom,
    s__instance(s__Kiribati,s__Nation) ).

fof(kb_SUMO_2612,axiom,
    s__geographicSubregion(s__MarshallIslands,s__Oceania) ).

fof(kb_SUMO_2613,axiom,
    s__instance(s__MarshallIslands,s__Nation) ).

fof(kb_SUMO_2614,axiom,
    s__geographicSubregion(s__Micronesia,s__Oceania) ).

fof(kb_SUMO_2615,axiom,
    s__instance(s__Micronesia,s__Nation) ).

fof(kb_SUMO_2616,axiom,
    s__geographicSubregion(s__MidwayIslands,s__Oceania) ).

fof(kb_SUMO_2617,axiom,
    s__geographicSubregion(s__Nauru,s__Oceania) ).

fof(kb_SUMO_2618,axiom,
    s__instance(s__Nauru,s__Nation) ).

fof(kb_SUMO_2619,axiom,
    s__geographicSubregion(s__NewCaledonia,s__Oceania) ).

fof(kb_SUMO_2620,axiom,
    s__geographicSubregion(s__NewZealand,s__Oceania) ).

fof(kb_SUMO_2621,axiom,
    s__instance(s__NewZealand,s__Nation) ).

fof(kb_SUMO_2622,axiom,
    s__geographicSubregion(s__Niue,s__Oceania) ).

fof(kb_SUMO_2623,axiom,
    s__geographicSubregion(s__NorfolkIsland,s__Oceania) ).

fof(kb_SUMO_2624,axiom,
    s__geographicSubregion(s__NorthernMarianaIslands,s__Oceania) ).

fof(kb_SUMO_2625,axiom,
    s__geographicSubregion(s__Palau,s__Oceania) ).

fof(kb_SUMO_2626,axiom,
    s__instance(s__Palau,s__Nation) ).

fof(kb_SUMO_2627,axiom,
    s__geographicSubregion(s__PalmyraAtoll,s__Oceania) ).

fof(kb_SUMO_2628,axiom,
    s__geographicSubregion(s__PitcairnIslands,s__Oceania) ).

fof(kb_SUMO_2629,axiom,
    s__geographicSubregion(s__Samoa,s__Oceania) ).

fof(kb_SUMO_2630,axiom,
    s__instance(s__Samoa,s__Nation) ).

fof(kb_SUMO_2631,axiom,
    s__geographicSubregion(s__SolomonIslands,s__Oceania) ).

fof(kb_SUMO_2632,axiom,
    s__instance(s__SolomonIslands,s__Nation) ).

fof(kb_SUMO_2633,axiom,
    s__geographicSubregion(s__Tokelau,s__Oceania) ).

fof(kb_SUMO_2634,axiom,
    s__geographicSubregion(s__Tonga,s__Oceania) ).

fof(kb_SUMO_2635,axiom,
    s__instance(s__Tonga,s__Nation) ).

fof(kb_SUMO_2636,axiom,
    s__geographicSubregion(s__Tuvalu,s__Oceania) ).

fof(kb_SUMO_2637,axiom,
    s__instance(s__Tuvalu,s__Nation) ).

fof(kb_SUMO_2638,axiom,
    s__geographicSubregion(s__Vanuatu,s__Oceania) ).

fof(kb_SUMO_2639,axiom,
    s__instance(s__Vanuatu,s__Nation) ).

fof(kb_SUMO_2640,axiom,
    s__geographicSubregion(s__WakeIsland,s__Oceania) ).

fof(kb_SUMO_2641,axiom,
    s__geographicSubregion(s__WallisAndFutuna,s__Oceania) ).

fof(kb_SUMO_2642,axiom,
    s__instance(s__AtlantaGeorgia,s__AmericanCity) ).

fof(kb_SUMO_2643,axiom,
    s__part(s__AtlantaGeorgia,s__Georgia) ).

fof(kb_SUMO_2644,axiom,
    s__documentation(s__AtlantaGeorgia,s__EnglishLanguage,'The largest City in &%Georgia.') ).

fof(kb_SUMO_2645,axiom,
    s__instance(s__BaltimoreMaryland,s__AmericanCity) ).

fof(kb_SUMO_2646,axiom,
    s__part(s__BaltimoreMaryland,s__Maryland) ).

fof(kb_SUMO_2647,axiom,
    s__documentation(s__BaltimoreMaryland,s__EnglishLanguage,'The largest City in &%Maryland.') ).

fof(kb_SUMO_2648,axiom,
    s__instance(s__BerlinGermany,s__EuropeanCity) ).

fof(kb_SUMO_2649,axiom,
    s__capitalCity(s__BerlinGermany,s__Germany) ).

fof(kb_SUMO_2650,axiom,
    s__documentation(s__BerlinGermany,s__EnglishLanguage,'The capital of &%Germany and the largest City of the country.') ).

fof(kb_SUMO_2651,axiom,
    s__instance(s__BernSwitzerland,s__EuropeanCity) ).

fof(kb_SUMO_2652,axiom,
    s__capitalCity(s__BernSwitzerland,s__Switzerland) ).

fof(kb_SUMO_2653,axiom,
    s__documentation(s__BernSwitzerland,s__EnglishLanguage,'The capital of &%Switzerland.') ).

fof(kb_SUMO_2654,axiom,
    s__instance(s__BostonMassachusetts,s__AmericanCity) ).

fof(kb_SUMO_2655,axiom,
    s__part(s__BostonMassachusetts,s__Massachusetts) ).

fof(kb_SUMO_2656,axiom,
    s__documentation(s__BostonMassachusetts,s__EnglishLanguage,'The largest &%City in &%Massachusetts.') ).

fof(kb_SUMO_2657,axiom,
    s__instance(s__KansasCityMissouri,s__AmericanCity) ).

fof(kb_SUMO_2658,axiom,
    s__documentation(s__KansasCityMissouri,s__EnglishLanguage,'A large &%City at the western edge of &%Missouri.') ).

fof(kb_SUMO_2659,axiom,
    s__part(s__KansasCityMissouri,s__Missouri) ).

fof(kb_SUMO_2660,axiom,
    s__instance(s__MemphisTennessee,s__AmericanCity) ).

fof(kb_SUMO_2661,axiom,
    s__instance(s__ManchesterNewHampshire,s__AmericanCity) ).

fof(kb_SUMO_2662,axiom,
    s__part(s__ManchesterNewHampshire,s__NewHampshire) ).

fof(kb_SUMO_2663,axiom,
    s__documentation(s__ManchesterNewHampshire,s__EnglishLanguage,'The largest &%City in &%NewHampshire.') ).

fof(kb_SUMO_2664,axiom,
    s__part(s__MemphisTennessee,s__Tennessee) ).

fof(kb_SUMO_2665,axiom,
    s__documentation(s__MemphisTennessee,s__EnglishLanguage,'The largest City in Tennessee, located on the MississippiRiver.') ).

fof(kb_SUMO_2666,axiom,
    s__instance(s__MinneapolisMinnesota,s__AmericanCity) ).

fof(kb_SUMO_2667,axiom,
    s__part(s__MinneapolisMinnesota,s__Minnesota) ).

fof(kb_SUMO_2668,axiom,
    s__documentation(s__MinneapolisMinnesota,s__EnglishLanguage,'The largest City in Minnesota.') ).

fof(kb_SUMO_2669,axiom,
    s__instance(s__MississippiRiver,s__River) ).

fof(kb_SUMO_2670,axiom,
    s__instance(s__River__t,s__SetOrClass) ).

fof(kb_SUMO_2671,axiom,
    s__part(s__MississippiRiver,s__UnitedStates) ).

fof(kb_SUMO_2672,axiom,
    s__documentation(s__MississippiRiver,s__EnglishLanguage,'The major River in the &%UnitedStates. It runs almost the entire width of the UnitedStates, from &%Minnesota to the &%GulfOfMexico.') ).

fof(kb_SUMO_2673,axiom,
    s__connected(s__MississippiRiver,s__GulfOfMexico) ).

fof(kb_SUMO_2674,axiom,
    s__instance(s__MontrealCanada,s__City) ).

fof(kb_SUMO_2675,axiom,
    s__part(s__MontrealCanada,s__Canada) ).

fof(kb_SUMO_2676,axiom,
    s__documentation(s__MontrealCanada,s__EnglishLanguage,'A large City in eastern Canada.') ).

fof(kb_SUMO_2677,axiom,
    s__instance(s__MoscowRussia,s__EuropeanCity) ).

fof(kb_SUMO_2678,axiom,
    s__capitalCity(s__MoscowRussia,s__Russia) ).

fof(kb_SUMO_2679,axiom,
    s__documentation(s__MoscowRussia,s__EnglishLanguage,'The capital of Russia and the largest City of the country.') ).

fof(kb_SUMO_2680,axiom,
    s__instance(s__NashvilleTennessee,s__AmericanCity) ).

fof(kb_SUMO_2681,axiom,
    s__part(s__NashvilleTennessee,s__Tennessee) ).

fof(kb_SUMO_2682,axiom,
    s__documentation(s__NashvilleTennessee,s__EnglishLanguage,'A large City in Tennessee.') ).

fof(kb_SUMO_2683,axiom,
    s__instance(s__Palestine,s__OverseasArea) ).

fof(kb_SUMO_2684,axiom,
    s__dependentGeopoliticalArea(s__Palestine,s__UnitedKingdom) ).

fof(kb_SUMO_2685,axiom,
    s__documentation(s__Palestine,s__EnglishLanguage,'A GeopoliticalArea that was divided by the UnitedKingdom into Israel and Jordan in 1948.') ).

fof(kb_SUMO_2686,axiom,
    s__instance(s__ParisFrance,s__EuropeanCity) ).

fof(kb_SUMO_2687,axiom,
    s__capitalCity(s__ParisFrance,s__France) ).

fof(kb_SUMO_2688,axiom,
    s__documentation(s__ParisFrance,s__EnglishLanguage,'The capital of &%France and the largest &%City of the country.') ).

fof(kb_SUMO_2689,axiom,
    s__instance(s__PhiladelphiaPennsylvania,s__AmericanCity) ).

fof(kb_SUMO_2690,axiom,
    s__part(s__PhiladelphiaPennsylvania,s__Pennsylvania) ).

fof(kb_SUMO_2691,axiom,
    s__documentation(s__PhiladelphiaPennsylvania,s__EnglishLanguage,'The largest City in Pennsylvania.') ).

fof(kb_SUMO_2692,axiom,
    s__instance(s__PittsburghPennsylvania,s__AmericanCity) ).

fof(kb_SUMO_2693,axiom,
    s__part(s__PittsburghPennsylvania,s__Pennsylvania) ).

fof(kb_SUMO_2694,axiom,
    s__documentation(s__PittsburghPennsylvania,s__EnglishLanguage,'The second largest City in Pennsylvania. It was once a center of steel production in the UnitedStates.') ).

fof(kb_SUMO_2695,axiom,
    s__instance(s__ProvidenceRhodeIsland,s__AmericanCity) ).

fof(kb_SUMO_2696,axiom,
    s__capitalCity(s__ProvidenceRhodeIsland,s__RhodeIsland) ).

fof(kb_SUMO_2697,axiom,
    s__documentation(s__ProvidenceRhodeIsland,s__EnglishLanguage,'The largest and capital city of RhodeIsland.') ).

fof(kb_SUMO_2698,axiom,
    s__instance(s__RichmondVirginia,s__AmericanCity) ).

fof(kb_SUMO_2699,axiom,
    s__capitalCity(s__RichmondVirginia,s__Virginia) ).

fof(kb_SUMO_2700,axiom,
    s__documentation(s__RichmondVirginia,s__EnglishLanguage,'The capital of Virginia, located in the east-central part of the state.') ).

fof(kb_SUMO_2701,axiom,
    s__instance(s__RomeItaly,s__EuropeanCity) ).

fof(kb_SUMO_2702,axiom,
    s__instance(s__EuropeanCity__t,s__SetOrClass) ).

fof(kb_SUMO_2703,axiom,
    s__capitalCity(s__RomeItaly,s__Italy) ).

fof(kb_SUMO_2704,axiom,
    s__documentation(s__RomeItaly,s__EnglishLanguage,'The capital of &%Italy and the largest &%City of the country.') ).

fof(kb_SUMO_2705,axiom,
    s__instance(s__SaintLouisMissouri,s__AmericanCity) ).

fof(kb_SUMO_2706,axiom,
    s__part(s__SaintLouisMissouri,s__Missouri) ).

fof(kb_SUMO_2707,axiom,
    s__documentation(s__SaintLouisMissouri,s__EnglishLanguage,'A large City in Missouri.') ).

fof(kb_SUMO_2708,axiom,
    s__instance(s__SaintPaulMinnesota,s__AmericanCity) ).

fof(kb_SUMO_2709,axiom,
    s__capitalCity(s__SaintPaulMinnesota,s__Minnesota) ).

fof(kb_SUMO_2710,axiom,
    s__meetsSpatially(s__SaintPaulMinnesota,s__MinneapolisMinnesota) ).

fof(kb_SUMO_2711,axiom,
    s__documentation(s__SaintPaulMinnesota,s__EnglishLanguage,'The capital of Minnesota, borders MinneapolisMinnesota.') ).

fof(kb_SUMO_2712,axiom,
    s__instance(s__SanFranciscoCalifornia,s__AmericanCity) ).

fof(kb_SUMO_2713,axiom,
    s__part(s__SanFranciscoCalifornia,s__California) ).

fof(kb_SUMO_2714,axiom,
    s__documentation(s__SanFranciscoCalifornia,s__EnglishLanguage,'A large City in &%California, located on the San Francisco Bay.') ).

fof(kb_SUMO_2715,axiom,
    s__instance(s__SavannahGeorgia,s__AmericanCity) ).

fof(kb_SUMO_2716,axiom,
    s__part(s__SavannahGeorgia,s__Georgia) ).

fof(kb_SUMO_2717,axiom,
    s__documentation(s__SavannahGeorgia,s__EnglishLanguage,'A City in Georgia near the mouth of the Savannah River.') ).

fof(kb_SUMO_2718,axiom,
    s__instance(s__Scotland,s__GeopoliticalArea) ).

fof(kb_SUMO_2719,axiom,
    s__part(s__Scotland,s__UnitedKingdom) ).

fof(kb_SUMO_2720,axiom,
    s__documentation(s__Scotland,s__EnglishLanguage,'A division of the &%UnitedKingdom.') ).

fof(kb_SUMO_2721,axiom,
    s__instance(s__WarsawPoland,s__EuropeanCity) ).

fof(kb_SUMO_2722,axiom,
    s__capitalCity(s__WarsawPoland,s__Poland) ).

fof(kb_SUMO_2723,axiom,
    s__documentation(s__WarsawPoland,s__EnglishLanguage,'The capital &%City and largest city in &%Poland.') ).

fof(kb_SUMO_2724,axiom,
    s__instance(s__LongIsland,s__Island) ).

fof(kb_SUMO_2725,axiom,
    s__part(s__LongIsland,s__NewYorkState) ).

fof(kb_SUMO_2726,axiom,
    s__documentation(s__LongIsland,s__EnglishLanguage,'A large Island off the coast of NewYorkState. The boroughs of Queens and Brooklyn make up the western end of this Island.') ).

fof(kb_SUMO_2727,axiom,
    s__instance(s__LosAngelesCalifornia,s__AmericanCity) ).

fof(kb_SUMO_2728,axiom,
    s__part(s__LosAngelesCalifornia,s__California) ).

fof(kb_SUMO_2729,axiom,
    s__documentation(s__LosAngelesCalifornia,s__EnglishLanguage,'The largest City in California.') ).

fof(kb_SUMO_2730,axiom,
    ! [V__CITY] :
      ( s__instance(V__CITY,s__GeopoliticalArea)
     => ( ( s__instance(V__CITY,s__AmericanCity)
          & s__part(V__CITY,s__California)
          & V__CITY != s__LosAngelesCalifornia )
       => greater(s__CardinalityFn(s__ResidentFn(s__LosAngelesCalifornia)),s__CardinalityFn(s__ResidentFn(V__CITY))) ) ) ).

fof(kb_SUMO_2731,axiom,
    s__instance(s__KoreanPeninsula,s__Peninsula) ).

fof(kb_SUMO_2732,axiom,
    s__instance(s__Peninsula__t,s__SetOrClass) ).

fof(kb_SUMO_2733,axiom,
    s__part(s__KoreanPeninsula,s__Asia) ).

fof(kb_SUMO_2734,axiom,
    s__documentation(s__KoreanPeninsula,s__EnglishLanguage,'A Peninsula in Asia that separates the Yellow Sea from the Sea of Japan. It is occupied by the nations of North and South Korea.') ).

fof(kb_SUMO_2735,axiom,
    s__instance(s__HonoluluHawaii,s__AmericanCity) ).

fof(kb_SUMO_2736,axiom,
    s__capitalCity(s__HonoluluHawaii,s__Hawaii) ).

fof(kb_SUMO_2737,axiom,
    s__documentation(s__HonoluluHawaii,s__EnglishLanguage,'The capital and largest City in Hawaii.') ).

fof(kb_SUMO_2738,axiom,
    s__instance(s__HoustonTexas,s__AmericanCity) ).

fof(kb_SUMO_2739,axiom,
    s__part(s__HoustonTexas,s__Texas) ).

fof(kb_SUMO_2740,axiom,
    s__documentation(s__HoustonTexas,s__EnglishLanguage,'Located in southeastern Texas, the largest City in the state.') ).

fof(kb_SUMO_2741,axiom,
    s__instance(s__HudsonRiver,s__River) ).

fof(kb_SUMO_2742,axiom,
    s__part(s__HudsonRiver,s__NewYorkState) ).

fof(kb_SUMO_2743,axiom,
    s__documentation(s__HudsonRiver,s__EnglishLanguage,'A large River in NewYorkState.') ).

fof(kb_SUMO_2744,axiom,
    s__instance(s__FargoNorthDakota,s__AmericanCity) ).

fof(kb_SUMO_2745,axiom,
    s__part(s__FargoNorthDakota,s__NorthDakota) ).

fof(kb_SUMO_2746,axiom,
    s__documentation(s__FargoNorthDakota,s__EnglishLanguage,'The largest City in NorthDakota.') ).

fof(kb_SUMO_2747,axiom,
    s__instance(s__DenverColorado,s__AmericanCity) ).

fof(kb_SUMO_2748,axiom,
    s__capitalCity(s__DenverColorado,s__Colorado) ).

fof(kb_SUMO_2749,axiom,
    s__documentation(s__DenverColorado,s__EnglishLanguage,'The capital and largest City in Colorado.') ).

fof(kb_SUMO_2750,axiom,
    s__instance(s__DetroitMichigan,s__AmericanCity) ).

fof(kb_SUMO_2751,axiom,
    s__part(s__DetroitMichigan,s__Michigan) ).

fof(kb_SUMO_2752,axiom,
    s__documentation(s__DetroitMichigan,s__EnglishLanguage,'The largest City in Michigan.') ).

fof(kb_SUMO_2753,axiom,
    s__instance(s__CopenhagenDenmark,s__EuropeanCity) ).

fof(kb_SUMO_2754,axiom,
    s__capitalCity(s__CopenhagenDenmark,s__Denmark) ).

fof(kb_SUMO_2755,axiom,
    s__documentation(s__CopenhagenDenmark,s__EnglishLanguage,'The capital of Denmark and the largest City of the country.') ).

fof(kb_SUMO_2756,axiom,
    s__instance(s__Czechoslovakia,s__EuropeanNation) ).

fof(kb_SUMO_2757,axiom,
    s__documentation(s__Czechoslovakia,s__EnglishLanguage,'The former eastern bloc nation. It is currently divided into two independent Nations, the Czech Republic and Slovakia.') ).

fof(kb_SUMO_2758,axiom,
    s__instance(s__DallasTexas,s__AmericanCity) ).

fof(kb_SUMO_2759,axiom,
    s__part(s__DallasTexas,s__Texas) ).

fof(kb_SUMO_2760,axiom,
    s__documentation(s__DallasTexas,s__EnglishLanguage,'A large City in northeastern Texas.') ).

fof(kb_SUMO_2761,axiom,
    s__instance(s__ClevelandOhio,s__AmericanCity) ).

fof(kb_SUMO_2762,axiom,
    s__part(s__ClevelandOhio,s__Ohio) ).

fof(kb_SUMO_2763,axiom,
    s__documentation(s__ClevelandOhio,s__EnglishLanguage,'Bordering Lake Erie, ClevelandOhio is the largest City in Ohio.') ).

fof(kb_SUMO_2764,axiom,
    s__instance(s__ColumbusOhio,s__AmericanCity) ).

fof(kb_SUMO_2765,axiom,
    s__capitalCity(s__ColumbusOhio,s__Ohio) ).

fof(kb_SUMO_2766,axiom,
    s__documentation(s__ColumbusOhio,s__EnglishLanguage,'The capital of Ohio, located in the middle of the state.') ).

fof(kb_SUMO_2767,axiom,
    s__instance(s__Alabama,s__AmericanState) ).

fof(kb_SUMO_2768,axiom,
    s__meetsSpatially(s__Alabama,s__Mississippi) ).

fof(kb_SUMO_2769,axiom,
    s__documentation(s__Alabama,s__EnglishLanguage,'A state in the southeastern &%UnitedStates that borders on the &%GulfOfMexico.') ).

fof(kb_SUMO_2770,axiom,
    s__instance(s__Alaska,s__AmericanState) ).

fof(kb_SUMO_2771,axiom,
    s__documentation(s__Alaska,s__EnglishLanguage,'The largest state in the &%UnitedStates.') ).

fof(kb_SUMO_2772,axiom,
    ! [V__NUMBER2,V__UNIT,V__STATE,V__NUMBER1] :
      ( ( s__instance(V__NUMBER1,s__RealNumber)
        & s__instance(V__STATE,s__Object)
        & s__instance(V__UNIT,s__SetOrClass)
        & s__instance(V__UNIT,s__UnitOfMeasure)
        & s__instance(V__NUMBER2,s__RealNumber) )
     => ( ( s__subclass(V__UNIT,s__AreaMeasure)
          & s__measure(s__Alaska,s__MeasureFn(V__NUMBER1,V__UNIT))
          & s__measure(V__STATE,s__MeasureFn(V__NUMBER2,V__UNIT))
          & s__instance(V__STATE,s__AmericanState)
          & s__Alaska != V__STATE )
       => less(V__NUMBER2,V__NUMBER1) ) ) ).

fof(kb_SUMO_2773,axiom,
    s__meetsSpatially(s__Alaska,s__Canada) ).

fof(kb_SUMO_2774,axiom,
    s__meetsSpatially(s__Alaska,s__PacificOcean) ).

fof(kb_SUMO_2775,axiom,
    s__meetsSpatially(s__Alaska,s__ArcticOcean) ).

fof(kb_SUMO_2776,axiom,
    s__instance(s__Arizona,s__AmericanState) ).

fof(kb_SUMO_2777,axiom,
    s__meetsSpatially(s__Arizona,s__Nevada) ).

fof(kb_SUMO_2778,axiom,
    s__meetsSpatially(s__Arizona,s__California) ).

fof(kb_SUMO_2779,axiom,
    s__meetsSpatially(s__Arizona,s__Mexico) ).

fof(kb_SUMO_2780,axiom,
    s__documentation(s__Arizona,s__EnglishLanguage,'A state in the southwestern &%UnitedStates that borders on &%Mexico.') ).

fof(kb_SUMO_2781,axiom,
    s__instance(s__Arkansas,s__AmericanState) ).

fof(kb_SUMO_2782,axiom,
    s__meetsSpatially(s__Arkansas,s__Oklahoma) ).

fof(kb_SUMO_2783,axiom,
    s__meetsSpatially(s__Arkansas,s__Texas) ).

fof(kb_SUMO_2784,axiom,
    s__meetsSpatially(s__Arkansas,s__Louisiana) ).

fof(kb_SUMO_2785,axiom,
    s__documentation(s__Arkansas,s__EnglishLanguage,'A state in the southeastern &%UnitedStates that was part of the Confederacy.') ).

fof(kb_SUMO_2786,axiom,
    s__instance(s__California,s__AmericanState) ).

fof(kb_SUMO_2787,axiom,
    s__documentation(s__California,s__EnglishLanguage,'The &%AmericanState with the highest population.') ).

fof(kb_SUMO_2788,axiom,
    ! [V__STATE] :
      ( s__instance(V__STATE,s__GeopoliticalArea)
     => ( ( s__instance(V__STATE,s__AmericanState)
          & V__STATE != s__California )
       => greater(s__CardinalityFn(s__ResidentFn(s__California)),s__CardinalityFn(s__ResidentFn(V__STATE))) ) ) ).

fof(kb_SUMO_2789,axiom,
    s__meetsSpatially(s__California,s__PacificOcean) ).

fof(kb_SUMO_2790,axiom,
    s__meetsSpatially(s__California,s__Mexico) ).

fof(kb_SUMO_2791,axiom,
    s__meetsSpatially(s__California,s__NewMexico) ).

fof(kb_SUMO_2792,axiom,
    s__meetsSpatially(s__California,s__Oregon) ).

fof(kb_SUMO_2793,axiom,
    s__meetsSpatially(s__California,s__Washington) ).

fof(kb_SUMO_2794,axiom,
    s__instance(s__Colorado,s__AmericanState) ).

fof(kb_SUMO_2795,axiom,
    s__meetsSpatially(s__Colorado,s__Utah) ).

fof(kb_SUMO_2796,axiom,
    s__meetsSpatially(s__Colorado,s__Arizona) ).

fof(kb_SUMO_2797,axiom,
    s__meetsSpatially(s__Colorado,s__NewMexico) ).

fof(kb_SUMO_2798,axiom,
    s__meetsSpatially(s__Colorado,s__Texas) ).

fof(kb_SUMO_2799,axiom,
    s__documentation(s__Colorado,s__EnglishLanguage,'A large western state in the &%UnitedStates.') ).

fof(kb_SUMO_2800,axiom,
    s__instance(s__Connecticut,s__AmericanState) ).

fof(kb_SUMO_2801,axiom,
    s__part(s__Connecticut,s__NewEngland) ).

fof(kb_SUMO_2802,axiom,
    s__documentation(s__Connecticut,s__EnglishLanguage,'A state in &%NewEngland, one of the original thirteen colonies.') ).

fof(kb_SUMO_2803,axiom,
    s__instance(s__Delaware,s__AmericanState) ).

fof(kb_SUMO_2804,axiom,
    s__meetsSpatially(s__Delaware,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2805,axiom,
    s__meetsSpatially(s__Delaware,s__Maryland) ).

fof(kb_SUMO_2806,axiom,
    s__meetsSpatially(s__Delaware,s__Pennsylvania) ).

fof(kb_SUMO_2807,axiom,
    s__documentation(s__Delaware,s__EnglishLanguage,'A state in &%NewEngland, one of the original thirteen colonies.') ).

fof(kb_SUMO_2808,axiom,
    s__instance(s__Florida,s__AmericanState) ).

fof(kb_SUMO_2809,axiom,
    s__meetsSpatially(s__Florida,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2810,axiom,
    s__meetsSpatially(s__Florida,s__Alabama) ).

fof(kb_SUMO_2811,axiom,
    s__meetsSpatially(s__Florida,s__GulfOfMexico) ).

fof(kb_SUMO_2812,axiom,
    s__documentation(s__Florida,s__EnglishLanguage,'A state in the southeastern &%UnitedStates between the &%GulfOfMexico and the &%AtlanticOcean.') ).

fof(kb_SUMO_2813,axiom,
    s__instance(s__Georgia,s__AmericanState) ).

fof(kb_SUMO_2814,axiom,
    s__meetsSpatially(s__Georgia,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2815,axiom,
    s__meetsSpatially(s__Georgia,s__Florida) ).

fof(kb_SUMO_2816,axiom,
    s__meetsSpatially(s__Georgia,s__Alabama) ).

fof(kb_SUMO_2817,axiom,
    s__documentation(s__Georgia,s__EnglishLanguage,'A state in the southeastern &%UnitedStates.') ).

fof(kb_SUMO_2818,axiom,
    s__instance(s__Hawaii,s__AmericanState) ).

fof(kb_SUMO_2819,axiom,
    s__meetsSpatially(s__Hawaii,s__PacificOcean) ).

fof(kb_SUMO_2820,axiom,
    s__documentation(s__Hawaii,s__EnglishLanguage,'An &%AmericanState that consists of several &%Islands in the central &%PacificOcean.') ).

fof(kb_SUMO_2821,axiom,
    s__instance(s__Idaho,s__AmericanState) ).

fof(kb_SUMO_2822,axiom,
    s__meetsSpatially(s__Idaho,s__Canada) ).

fof(kb_SUMO_2823,axiom,
    s__meetsSpatially(s__Idaho,s__Washington) ).

fof(kb_SUMO_2824,axiom,
    s__meetsSpatially(s__Idaho,s__Oregon) ).

fof(kb_SUMO_2825,axiom,
    s__meetsSpatially(s__Idaho,s__Nevada) ).

fof(kb_SUMO_2826,axiom,
    s__meetsSpatially(s__Idaho,s__Utah) ).

fof(kb_SUMO_2827,axiom,
    s__documentation(s__Idaho,s__EnglishLanguage,'A state known for potatoes in the northwestern &%UnitedStates.') ).

fof(kb_SUMO_2828,axiom,
    s__instance(s__Illinois,s__AmericanState) ).

fof(kb_SUMO_2829,axiom,
    s__meetsSpatially(s__Illinois,s__Iowa) ).

fof(kb_SUMO_2830,axiom,
    s__meetsSpatially(s__Illinois,s__Missouri) ).

fof(kb_SUMO_2831,axiom,
    s__documentation(s__Illinois,s__EnglishLanguage,'A populous and industrial state in the midwestern &%UnitedStates.') ).

fof(kb_SUMO_2832,axiom,
    s__instance(s__Indiana,s__AmericanState) ).

fof(kb_SUMO_2833,axiom,
    s__meetsSpatially(s__Indiana,s__Illinois) ).

fof(kb_SUMO_2834,axiom,
    s__documentation(s__Indiana,s__EnglishLanguage,'A state in the mideastern &%UnitedStates.') ).

fof(kb_SUMO_2835,axiom,
    s__instance(s__Iowa,s__AmericanState) ).

fof(kb_SUMO_2836,axiom,
    s__meetsSpatially(s__Iowa,s__SouthDakota) ).

fof(kb_SUMO_2837,axiom,
    s__meetsSpatially(s__Iowa,s__Nebraska) ).

fof(kb_SUMO_2838,axiom,
    s__meetsSpatially(s__Iowa,s__Missouri) ).

fof(kb_SUMO_2839,axiom,
    s__documentation(s__Iowa,s__EnglishLanguage,'A state in the midwestern &%UnitedStates.') ).

fof(kb_SUMO_2840,axiom,
    s__instance(s__Kansas,s__AmericanState) ).

fof(kb_SUMO_2841,axiom,
    s__meetsSpatially(s__Kansas,s__Colorado) ).

fof(kb_SUMO_2842,axiom,
    s__meetsSpatially(s__Kansas,s__Texas) ).

fof(kb_SUMO_2843,axiom,
    s__meetsSpatially(s__Kansas,s__Oklahoma) ).

fof(kb_SUMO_2844,axiom,
    s__documentation(s__Kansas,s__EnglishLanguage,'A state in the midwestern &%UnitedStates.') ).

fof(kb_SUMO_2845,axiom,
    s__instance(s__Kentucky,s__AmericanState) ).

fof(kb_SUMO_2846,axiom,
    s__meetsSpatially(s__Kentucky,s__Tennessee) ).

fof(kb_SUMO_2847,axiom,
    s__meetsSpatially(s__Kentucky,s__Missouri) ).

fof(kb_SUMO_2848,axiom,
    s__meetsSpatially(s__Kentucky,s__Illinois) ).

fof(kb_SUMO_2849,axiom,
    s__meetsSpatially(s__Kentucky,s__Indiana) ).

fof(kb_SUMO_2850,axiom,
    s__documentation(s__Kentucky,s__EnglishLanguage,'A state in the southeastern &%UnitedStates.') ).

fof(kb_SUMO_2851,axiom,
    s__instance(s__Louisiana,s__AmericanState) ).

fof(kb_SUMO_2852,axiom,
    s__meetsSpatially(s__Louisiana,s__Texas) ).

fof(kb_SUMO_2853,axiom,
    s__meetsSpatially(s__Louisiana,s__GulfOfMexico) ).

fof(kb_SUMO_2854,axiom,
    s__documentation(s__Louisiana,s__EnglishLanguage,'A state in the south-central part of the &%UnitedStates. It borders on the &%GulfOfMexico and is known for its bayous and cajun culture.') ).

fof(kb_SUMO_2855,axiom,
    s__instance(s__Maine,s__AmericanState) ).

fof(kb_SUMO_2856,axiom,
    s__meetsSpatially(s__Maine,s__NewHampshire) ).

fof(kb_SUMO_2857,axiom,
    s__meetsSpatially(s__Maine,s__Canada) ).

fof(kb_SUMO_2858,axiom,
    s__meetsSpatially(s__Maine,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2859,axiom,
    s__documentation(s__Maine,s__EnglishLanguage,'The most northeastern &%AmericanState.') ).

fof(kb_SUMO_2860,axiom,
    s__instance(s__Maryland,s__AmericanState) ).

fof(kb_SUMO_2861,axiom,
    s__meetsSpatially(s__Maryland,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2862,axiom,
    s__meetsSpatially(s__Maryland,s__Virginia) ).

fof(kb_SUMO_2863,axiom,
    s__meetsSpatially(s__Maryland,s__WestVirginia) ).

fof(kb_SUMO_2864,axiom,
    s__meetsSpatially(s__Maryland,s__WashingtonDCUnitedStates) ).

fof(kb_SUMO_2865,axiom,
    s__documentation(s__Maryland,s__EnglishLanguage,'A state in the eastern &%UnitedStates that borders on &%WashingtonDC.') ).

fof(kb_SUMO_2866,axiom,
    s__instance(s__Massachusetts,s__AmericanState) ).

fof(kb_SUMO_2867,axiom,
    s__part(s__Massachusetts,s__NewEngland) ).

fof(kb_SUMO_2868,axiom,
    s__meetsSpatially(s__Massachusetts,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2869,axiom,
    s__meetsSpatially(s__Massachusetts,s__NewYorkState) ).

fof(kb_SUMO_2870,axiom,
    s__meetsSpatially(s__Massachusetts,s__Connecticut) ).

fof(kb_SUMO_2871,axiom,
    s__meetsSpatially(s__Massachusetts,s__RhodeIsland) ).

fof(kb_SUMO_2872,axiom,
    s__documentation(s__Massachusetts,s__EnglishLanguage,'A northeastern &%AmericanState. Its largest &%City is &%BostonMassachusetts.') ).

fof(kb_SUMO_2873,axiom,
    s__instance(s__Michigan,s__AmericanState) ).

fof(kb_SUMO_2874,axiom,
    s__meetsSpatially(s__Michigan,s__Indiana) ).

fof(kb_SUMO_2875,axiom,
    s__meetsSpatially(s__Michigan,s__Illinois) ).

fof(kb_SUMO_2876,axiom,
    s__meetsSpatially(s__Michigan,s__Canada) ).

fof(kb_SUMO_2877,axiom,
    s__documentation(s__Michigan,s__EnglishLanguage,'A populous and industrial state in the midwestern &%UnitedStates.') ).

fof(kb_SUMO_2878,axiom,
    s__instance(s__Minnesota,s__AmericanState) ).

fof(kb_SUMO_2879,axiom,
    s__meetsSpatially(s__Minnesota,s__Canada) ).

fof(kb_SUMO_2880,axiom,
    s__meetsSpatially(s__Minnesota,s__NorthDakota) ).

fof(kb_SUMO_2881,axiom,
    s__meetsSpatially(s__Minnesota,s__SouthDakota) ).

fof(kb_SUMO_2882,axiom,
    s__meetsSpatially(s__Minnesota,s__Iowa) ).

fof(kb_SUMO_2883,axiom,
    s__documentation(s__Minnesota,s__EnglishLanguage,'A state in the northern midwest of the &%UnitedStates.') ).

fof(kb_SUMO_2884,axiom,
    s__instance(s__Mississippi,s__AmericanState) ).

fof(kb_SUMO_2885,axiom,
    s__meetsSpatially(s__Mississippi,s__Arkansas) ).

fof(kb_SUMO_2886,axiom,
    s__meetsSpatially(s__Mississippi,s__Louisiana) ).

fof(kb_SUMO_2887,axiom,
    s__meetsSpatially(s__Mississippi,s__GulfOfMexico) ).

fof(kb_SUMO_2888,axiom,
    s__documentation(s__Mississippi,s__EnglishLanguage,'A state in the southeastern &%UnitedStates that borders on the &%GulfOfMexico.') ).

fof(kb_SUMO_2889,axiom,
    s__instance(s__Missouri,s__AmericanState) ).

fof(kb_SUMO_2890,axiom,
    s__meetsSpatially(s__Missouri,s__Nebraska) ).

fof(kb_SUMO_2891,axiom,
    s__meetsSpatially(s__Missouri,s__Kansas) ).

fof(kb_SUMO_2892,axiom,
    s__meetsSpatially(s__Missouri,s__Oklahoma) ).

fof(kb_SUMO_2893,axiom,
    s__documentation(s__Missouri,s__EnglishLanguage,'A state in the central &%UnitedStates.') ).

fof(kb_SUMO_2894,axiom,
    s__instance(s__Montana,s__AmericanState) ).

fof(kb_SUMO_2895,axiom,
    s__meetsSpatially(s__Montana,s__Canada) ).

fof(kb_SUMO_2896,axiom,
    s__meetsSpatially(s__Montana,s__Idaho) ).

fof(kb_SUMO_2897,axiom,
    s__meetsSpatially(s__Montana,s__Wyoming) ).

fof(kb_SUMO_2898,axiom,
    s__documentation(s__Montana,s__EnglishLanguage,'A state in the northwestern &%UnitedStates.') ).

fof(kb_SUMO_2899,axiom,
    s__instance(s__Nebraska,s__AmericanState) ).

fof(kb_SUMO_2900,axiom,
    s__meetsSpatially(s__Nebraska,s__Wyoming) ).

fof(kb_SUMO_2901,axiom,
    s__meetsSpatially(s__Nebraska,s__Colorado) ).

fof(kb_SUMO_2902,axiom,
    s__meetsSpatially(s__Nebraska,s__Kansas) ).

fof(kb_SUMO_2903,axiom,
    s__documentation(s__Nebraska,s__EnglishLanguage,'A state in the midwestern &%UnitedStates.') ).

fof(kb_SUMO_2904,axiom,
    s__instance(s__Nevada,s__AmericanState) ).

fof(kb_SUMO_2905,axiom,
    s__meetsSpatially(s__Nevada,s__Oregon) ).

fof(kb_SUMO_2906,axiom,
    s__meetsSpatially(s__Nevada,s__California) ).

fof(kb_SUMO_2907,axiom,
    s__documentation(s__Nevada,s__EnglishLanguage,'A state in the western &%UnitedStates.') ).

fof(kb_SUMO_2908,axiom,
    s__instance(s__NewHampshire,s__AmericanState) ).

fof(kb_SUMO_2909,axiom,
    s__part(s__NewHampshire,s__NewEngland) ).

fof(kb_SUMO_2910,axiom,
    s__meetsSpatially(s__NewHampshire,s__Canada) ).

fof(kb_SUMO_2911,axiom,
    s__meetsSpatially(s__NewHampshire,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2912,axiom,
    s__meetsSpatially(s__NewHampshire,s__Vermont) ).

fof(kb_SUMO_2913,axiom,
    s__meetsSpatially(s__NewHampshire,s__Massachusetts) ).

fof(kb_SUMO_2914,axiom,
    s__documentation(s__NewHampshire,s__EnglishLanguage,'A northeastern &%AmericanState. Its largest &%City is &%ManchesterNewHampshire.') ).

fof(kb_SUMO_2915,axiom,
    s__instance(s__NewJersey,s__AmericanState) ).

fof(kb_SUMO_2916,axiom,
    s__meetsSpatially(s__NewJersey,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2917,axiom,
    s__meetsSpatially(s__NewJersey,s__Delaware) ).

fof(kb_SUMO_2918,axiom,
    s__meetsSpatially(s__NewJersey,s__Pennsylvania) ).

fof(kb_SUMO_2919,axiom,
    s__documentation(s__NewJersey,s__EnglishLanguage,'A state in the eastern &%UnitedStates.') ).

fof(kb_SUMO_2920,axiom,
    s__instance(s__NewMexico,s__AmericanState) ).

fof(kb_SUMO_2921,axiom,
    s__meetsSpatially(s__NewMexico,s__Arizona) ).

fof(kb_SUMO_2922,axiom,
    s__meetsSpatially(s__NewMexico,s__Mexico) ).

fof(kb_SUMO_2923,axiom,
    s__documentation(s__NewMexico,s__EnglishLanguage,'A southwestern state in the &%UnitedStates.') ).

fof(kb_SUMO_2924,axiom,
    s__capitalCity(s__WashingtonDCUnitedStates,s__UnitedStates) ).

fof(kb_SUMO_2925,axiom,
    s__geographicSubregion(s__NewJersey,s__UnitedStates) ).

fof(kb_SUMO_2926,axiom,
    s__names('New Jersey',s__NewJersey) ).

fof(kb_SUMO_2927,axiom,
    s__instance(s__NewYorkState,s__AmericanState) ).

fof(kb_SUMO_2928,axiom,
    s__documentation(s__NewYorkState,s__EnglishLanguage,'A populous state in the northeastern &%UnitedStates.') ).

fof(kb_SUMO_2929,axiom,
    s__geographicSubregion(s__NewYorkState,s__UnitedStates) ).

fof(kb_SUMO_2930,axiom,
    s__names('New York',s__NewYorkState) ).

fof(kb_SUMO_2931,axiom,
    s__geographicSubregion(s__NewYorkCityUnitedStates,s__UnitedStates) ).

fof(kb_SUMO_2932,axiom,
    s__meetsSpatially(s__NewYorkState,s__Canada) ).

fof(kb_SUMO_2933,axiom,
    s__meetsSpatially(s__NewYorkState,s__Pennsylvania) ).

fof(kb_SUMO_2934,axiom,
    s__meetsSpatially(s__NewYorkState,s__NewJersey) ).

fof(kb_SUMO_2935,axiom,
    s__meetsSpatially(s__NewYorkState,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2936,axiom,
    s__instance(s__NorthCarolina,s__AmericanState) ).

fof(kb_SUMO_2937,axiom,
    s__meetsSpatially(s__NorthCarolina,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2938,axiom,
    s__meetsSpatially(s__NorthCarolina,s__SouthCarolina) ).

fof(kb_SUMO_2939,axiom,
    s__meetsSpatially(s__NorthCarolina,s__Tennessee) ).

fof(kb_SUMO_2940,axiom,
    s__documentation(s__NorthCarolina,s__EnglishLanguage,'A state in the southeastern &%UnitedStates.') ).

fof(kb_SUMO_2941,axiom,
    s__instance(s__NorthDakota,s__AmericanState) ).

fof(kb_SUMO_2942,axiom,
    s__meetsSpatially(s__NorthDakota,s__Montana) ).

fof(kb_SUMO_2943,axiom,
    s__meetsSpatially(s__NorthDakota,s__SouthDakota) ).

fof(kb_SUMO_2944,axiom,
    s__meetsSpatially(s__NorthDakota,s__Canada) ).

fof(kb_SUMO_2945,axiom,
    s__documentation(s__NorthDakota,s__EnglishLanguage,'A state in the northern midwest of the &%UnitedStates.') ).

fof(kb_SUMO_2946,axiom,
    s__instance(s__Ohio,s__AmericanState) ).

fof(kb_SUMO_2947,axiom,
    s__meetsSpatially(s__Ohio,s__Kentucky) ).

fof(kb_SUMO_2948,axiom,
    s__meetsSpatially(s__Ohio,s__Indiana) ).

fof(kb_SUMO_2949,axiom,
    s__meetsSpatially(s__Ohio,s__Michigan) ).

fof(kb_SUMO_2950,axiom,
    s__meetsSpatially(s__Ohio,s__Canada) ).

fof(kb_SUMO_2951,axiom,
    s__documentation(s__Ohio,s__EnglishLanguage,'A populous and industrial state in the midwestern &%UnitedStates.') ).

fof(kb_SUMO_2952,axiom,
    s__instance(s__Oklahoma,s__AmericanState) ).

fof(kb_SUMO_2953,axiom,
    s__documentation(s__Oklahoma,s__EnglishLanguage,'A state in the southwestern &%UnitedStates.') ).

fof(kb_SUMO_2954,axiom,
    s__instance(s__Oregon,s__AmericanState) ).

fof(kb_SUMO_2955,axiom,
    s__meetsSpatially(s__Oregon,s__PacificOcean) ).

fof(kb_SUMO_2956,axiom,
    s__meetsSpatially(s__Oregon,s__California) ).

fof(kb_SUMO_2957,axiom,
    s__documentation(s__Oregon,s__EnglishLanguage,'An &%AmericanState on the &%PacificOcean.') ).

fof(kb_SUMO_2958,axiom,
    s__instance(s__Pennsylvania,s__AmericanState) ).

fof(kb_SUMO_2959,axiom,
    s__documentation(s__Pennsylvania,s__EnglishLanguage,'A mid-Atlantic &%AmericanState. Its two major cities are &%PhiladelphiaPennsylvania and &%PittsburghPennsylvania.') ).

fof(kb_SUMO_2960,axiom,
    s__meetsSpatially(s__Pennsylvania,s__WestVirginia) ).

fof(kb_SUMO_2961,axiom,
    s__meetsSpatially(s__Pennsylvania,s__Ohio) ).

fof(kb_SUMO_2962,axiom,
    s__meetsSpatially(s__Pennsylvania,s__Canada) ).

fof(kb_SUMO_2963,axiom,
    s__instance(s__RhodeIsland,s__AmericanState) ).

fof(kb_SUMO_2964,axiom,
    s__part(s__RhodeIsland,s__NewEngland) ).

fof(kb_SUMO_2965,axiom,
    s__documentation(s__RhodeIsland,s__EnglishLanguage,'A northeastern &%AmericanState. Its capital city is &%ProvidenceRhodeIsland. It is the smallest &%AmercianState') ).

fof(kb_SUMO_2966,axiom,
    s__instance(s__SouthCarolina,s__AmericanState) ).

fof(kb_SUMO_2967,axiom,
    s__meetsSpatially(s__SouthCarolina,s__NorthAtlanticOcean) ).

fof(kb_SUMO_2968,axiom,
    s__meetsSpatially(s__SouthCarolina,s__Georgia) ).

fof(kb_SUMO_2969,axiom,
    s__documentation(s__SouthCarolina,s__EnglishLanguage,'A state in the southeastern &%UnitedStates.') ).

fof(kb_SUMO_2970,axiom,
    s__instance(s__SouthDakota,s__AmericanState) ).

fof(kb_SUMO_2971,axiom,
    s__meetsSpatially(s__SouthDakota,s__Montana) ).

fof(kb_SUMO_2972,axiom,
    s__meetsSpatially(s__SouthDakota,s__Wyoming) ).

fof(kb_SUMO_2973,axiom,
    s__meetsSpatially(s__SouthDakota,s__Nebraska) ).

fof(kb_SUMO_2974,axiom,
    s__documentation(s__SouthDakota,s__EnglishLanguage,'A state in the northern midwest of the &%UnitedStates.') ).

fof(kb_SUMO_2975,axiom,
    s__instance(s__Tennessee,s__AmericanState) ).

fof(kb_SUMO_2976,axiom,
    s__meetsSpatially(s__Tennessee,s__Alabama) ).

fof(kb_SUMO_2977,axiom,
    s__meetsSpatially(s__Tennessee,s__Mississippi) ).

fof(kb_SUMO_2978,axiom,
    s__meetsSpatially(s__Tennessee,s__Arkansas) ).

fof(kb_SUMO_2979,axiom,
    s__meetsSpatially(s__Tennessee,s__Missouri) ).

fof(kb_SUMO_2980,axiom,
    s__documentation(s__Tennessee,s__EnglishLanguage,'A state in the southeastern &%UnitedStates.') ).

fof(kb_SUMO_2981,axiom,
    s__instance(s__Texas,s__AmericanState) ).

fof(kb_SUMO_2982,axiom,
    s__meetsSpatially(s__Texas,s__NewMexico) ).

fof(kb_SUMO_2983,axiom,
    s__meetsSpatially(s__Texas,s__Mexico) ).

fof(kb_SUMO_2984,axiom,
    s__meetsSpatially(s__Texas,s__GulfOfMexico) ).

fof(kb_SUMO_2985,axiom,
    s__documentation(s__Texas,s__EnglishLanguage,'The second largest &%AmericanState, located in the southwest on the &%GulfOfMexico.') ).

fof(kb_SUMO_2986,axiom,
    s__geographicSubregion(s__Texas,s__UnitedStates) ).

fof(kb_SUMO_2987,axiom,
    s__names('Texas',s__Texas) ).

fof(kb_SUMO_2988,axiom,
    s__instance(s__Utah,s__AmericanState) ).

fof(kb_SUMO_2989,axiom,
    s__meetsSpatially(s__Utah,s__Nevada) ).

fof(kb_SUMO_2990,axiom,
    s__meetsSpatially(s__Utah,s__Arizona) ).

fof(kb_SUMO_2991,axiom,
    s__meetsSpatially(s__Utah,s__NewMexico) ).

fof(kb_SUMO_2992,axiom,
    s__documentation(s__Utah,s__EnglishLanguage,'A state in the western &%UnitedStates.') ).

fof(kb_SUMO_2993,axiom,
    s__instance(s__Vermont,s__AmericanState) ).

fof(kb_SUMO_2994,axiom,
    s__part(s__Vermont,s__NewEngland) ).

fof(kb_SUMO_2995,axiom,
    s__meetsSpatially(s__Vermont,s__Canada) ).

fof(kb_SUMO_2996,axiom,
    s__meetsSpatially(s__Vermont,s__NewYorkState) ).

fof(kb_SUMO_2997,axiom,
    s__meetsSpatially(s__Vermont,s__Massachusetts) ).

fof(kb_SUMO_2998,axiom,
    s__documentation(s__Vermont,s__EnglishLanguage,'A northeastern &%AmericanState know for its small towns and rustic beauty.') ).

fof(kb_SUMO_2999,axiom,
    s__instance(s__Virginia,s__AmericanState) ).

fof(kb_SUMO_3000,axiom,
    s__documentation(s__Virginia,s__EnglishLanguage,'A state in the southeastern &%UnitedStates that borders on &%WashingtonDC.') ).

fof(kb_SUMO_3001,axiom,
    s__meetsSpatially(s__Virginia,s__WashingtonDCUnitedStates) ).

fof(kb_SUMO_3002,axiom,
    s__meetsSpatially(s__Virginia,s__NorthAtlanticOcean) ).

fof(kb_SUMO_3003,axiom,
    s__meetsSpatially(s__Virginia,s__NorthCarolina) ).

fof(kb_SUMO_3004,axiom,
    s__meetsSpatially(s__Virginia,s__Tennessee) ).

fof(kb_SUMO_3005,axiom,
    s__meetsSpatially(s__Virginia,s__Kentucky) ).

fof(kb_SUMO_3006,axiom,
    s__meetsSpatially(s__Virginia,s__WestVirginia) ).

fof(kb_SUMO_3007,axiom,
    s__instance(s__Washington,s__AmericanState) ).

fof(kb_SUMO_3008,axiom,
    s__meetsSpatially(s__Washington,s__Canada) ).

fof(kb_SUMO_3009,axiom,
    s__meetsSpatially(s__Washington,s__PacificOcean) ).

fof(kb_SUMO_3010,axiom,
    s__meetsSpatially(s__Washington,s__Oregon) ).

fof(kb_SUMO_3011,axiom,
    s__documentation(s__Washington,s__EnglishLanguage,'An &%AmericanState on the &%PacificOcean.') ).

fof(kb_SUMO_3012,axiom,
    s__instance(s__WestVirginia,s__AmericanState) ).

fof(kb_SUMO_3013,axiom,
    s__meetsSpatially(s__WestVirginia,s__Kentucky) ).

fof(kb_SUMO_3014,axiom,
    s__meetsSpatially(s__WestVirginia,s__Ohio) ).

fof(kb_SUMO_3015,axiom,
    s__documentation(s__WestVirginia,s__EnglishLanguage,'A state in the southeastern &%UnitedStates') ).

fof(kb_SUMO_3016,axiom,
    s__instance(s__Wisconsin,s__AmericanState) ).

fof(kb_SUMO_3017,axiom,
    s__meetsSpatially(s__Wisconsin,s__Illinois) ).

fof(kb_SUMO_3018,axiom,
    s__meetsSpatially(s__Wisconsin,s__Iowa) ).

fof(kb_SUMO_3019,axiom,
    s__meetsSpatially(s__Wisconsin,s__Minnesota) ).

fof(kb_SUMO_3020,axiom,
    s__documentation(s__Wisconsin,s__EnglishLanguage,'A state in the midnorthern &%UnitedStates.') ).

fof(kb_SUMO_3021,axiom,
    s__instance(s__Wyoming,s__AmericanState) ).

fof(kb_SUMO_3022,axiom,
    s__instance(s__AmericanState__t,s__SetOrClass) ).

fof(kb_SUMO_3023,axiom,
    s__meetsSpatially(s__Wyoming,s__Idaho) ).

fof(kb_SUMO_3024,axiom,
    s__meetsSpatially(s__Wyoming,s__Utah) ).

fof(kb_SUMO_3025,axiom,
    s__meetsSpatially(s__Wyoming,s__Colorado) ).

fof(kb_SUMO_3026,axiom,
    s__documentation(s__Wyoming,s__EnglishLanguage,'A large western state in the &%UnitedStates.') ).

fof(kb_SUMO_3027,axiom,
    s__instance(s__PuertoRico,s__Archipelago) ).

fof(kb_SUMO_3028,axiom,
    s__instance(s__Archipelago__t,s__SetOrClass) ).

fof(kb_SUMO_3029,axiom,
    s__part(s__PuertoRico,s__UnitedStates) ).

fof(kb_SUMO_3030,axiom,
    s__documentation(s__PuertoRico,s__EnglishLanguage,'An dependent part of the &%UnitedStates.') ).

fof(kb_SUMO_3031,axiom,
    s__instance(s__VirginIslands,s__Archipelago) ).

fof(kb_SUMO_3032,axiom,
    s__documentation(s__VirginIslands,s__EnglishLanguage,'The &%VirginIslands is an &%Archipelago in the West Indies that comprises both the &%BritishVirginIslands, administered by the &%UnitedKingdom, and the &%USVirginIslands, administered by the &%UnitedStates.') ).

fof(kb_SUMO_3033,axiom,
    ! [V__ISLAND] :
      ( s__instance(V__ISLAND,s__SelfConnectedObject)
     => ( s__member(V__ISLAND,s__VirginIslands)
       => s__instance(V__ISLAND,s__Island) ) ) ).

fof(kb_SUMO_3034,axiom,
    s__documentation(s__Albania,s__EnglishLanguage,'The &%Nation of Albania.') ).

fof(kb_SUMO_3035,axiom,
    s__documentation(s__Afghanistan,s__EnglishLanguage,'The &%Nation of Afghanistan.') ).

fof(kb_SUMO_3036,axiom,
    s__documentation(s__Algeria,s__EnglishLanguage,'The &%Nation of Algeria.') ).

fof(kb_SUMO_3037,axiom,
    s__documentation(s__Andorra,s__EnglishLanguage,'The &%Nation of Andorra.') ).

fof(kb_SUMO_3038,axiom,
    s__documentation(s__Angola,s__EnglishLanguage,'The &%Nation of Angola.') ).

fof(kb_SUMO_3039,axiom,
    s__documentation(s__AntiguaAndBarbuda,s__EnglishLanguage,'The &%Nation of AntiguaAndBarbuda.') ).

fof(kb_SUMO_3040,axiom,
    s__documentation(s__Argentina,s__EnglishLanguage,'The &%Nation of Argentina.') ).

fof(kb_SUMO_3041,axiom,
    s__documentation(s__Armenia,s__EnglishLanguage,'The &%Nation of Armenia.') ).

fof(kb_SUMO_3042,axiom,
    s__documentation(s__Australia,s__EnglishLanguage,'An industrialized &%Nation that occupies the entire continent of Oceania.') ).

fof(kb_SUMO_3043,axiom,
    s__documentation(s__Austria,s__EnglishLanguage,'The &%Nation of Austria.') ).

fof(kb_SUMO_3044,axiom,
    s__documentation(s__Azerbaijan,s__EnglishLanguage,'The &%Nation of Azerbaijan.') ).

fof(kb_SUMO_3045,axiom,
    s__documentation(s__Bahrain,s__EnglishLanguage,'The &%Nation of Bahrain.') ).

fof(kb_SUMO_3046,axiom,
    s__documentation(s__Bangladesh,s__EnglishLanguage,'The &%Nation of Bangladesh.') ).

fof(kb_SUMO_3047,axiom,
    s__documentation(s__Barbados,s__EnglishLanguage,'The &%Nation of Barbados.') ).

fof(kb_SUMO_3048,axiom,
    s__documentation(s__Belarus,s__EnglishLanguage,'The &%Nation of Belarus.') ).

fof(kb_SUMO_3049,axiom,
    s__documentation(s__Belgium,s__EnglishLanguage,'The &%Nation of Belgium.') ).

fof(kb_SUMO_3050,axiom,
    s__documentation(s__Belize,s__EnglishLanguage,'The &%Nation of Belize.') ).

fof(kb_SUMO_3051,axiom,
    s__documentation(s__Benin,s__EnglishLanguage,'The &%Nation of Benin.') ).

fof(kb_SUMO_3052,axiom,
    s__documentation(s__Bhutan,s__EnglishLanguage,'The &%Nation of Bhutan.') ).

fof(kb_SUMO_3053,axiom,
    s__documentation(s__Bolivia,s__EnglishLanguage,'The &%Nation of Bolivia.') ).

fof(kb_SUMO_3054,axiom,
    s__documentation(s__BosniaAndHerzegovina,s__EnglishLanguage,'The &%Nation of BosniaAndHerzegovina.') ).

fof(kb_SUMO_3055,axiom,
    s__documentation(s__Botswana,s__EnglishLanguage,'The &%Nation of Botswana.') ).

fof(kb_SUMO_3056,axiom,
    s__documentation(s__Brazil,s__EnglishLanguage,'The &%Nation of Brazil.') ).

fof(kb_SUMO_3057,axiom,
    s__documentation(s__Brunei,s__EnglishLanguage,'The &%Nation of Brunei.') ).

fof(kb_SUMO_3058,axiom,
    s__documentation(s__Bulgaria,s__EnglishLanguage,'The &%Nation of Bulgaria.') ).

fof(kb_SUMO_3059,axiom,
    s__documentation(s__BurkinaFaso,s__EnglishLanguage,'The &%Nation of BurkinaFaso.') ).

fof(kb_SUMO_3060,axiom,
    s__documentation(s__Burundi,s__EnglishLanguage,'The &%Nation of Burundi.') ).

fof(kb_SUMO_3061,axiom,
    s__documentation(s__Cambodia,s__EnglishLanguage,'The &%Nation of Cambodia.') ).

fof(kb_SUMO_3062,axiom,
    s__documentation(s__Cameroon,s__EnglishLanguage,'The &%Nation of Cameroon.') ).

fof(kb_SUMO_3063,axiom,
    s__documentation(s__Canada,s__EnglishLanguage,'A &%Nation in North America.') ).

fof(kb_SUMO_3064,axiom,
    s__documentation(s__CapeVerde,s__EnglishLanguage,'The &%Nation of CapeVerde.') ).

fof(kb_SUMO_3065,axiom,
    s__documentation(s__CentralAfricanRepublic,s__EnglishLanguage,'The &%Nation of CentralAfricanRepublic.') ).

fof(kb_SUMO_3066,axiom,
    s__documentation(s__Chad,s__EnglishLanguage,'The &%Nation of Chad.') ).

fof(kb_SUMO_3067,axiom,
    s__instance(s__Chechnya,s__Nation) ).

fof(kb_SUMO_3068,axiom,
    s__documentation(s__Chechnya,s__EnglishLanguage,'The &%Nation of Chechnya.') ).

fof(kb_SUMO_3069,axiom,
    s__documentation(s__Chile,s__EnglishLanguage,'The &%Nation of Chile.') ).

fof(kb_SUMO_3070,axiom,
    s__documentation(s__China,s__EnglishLanguage,'An Asian &%Nation, which is the most populous in the world.') ).

fof(kb_SUMO_3071,axiom,
    s__documentation(s__Colombia,s__EnglishLanguage,'The &%Nation of &%Colombia.') ).

fof(kb_SUMO_3072,axiom,
    s__documentation(s__Comoros,s__EnglishLanguage,'The &%Nation of Comoros.') ).

fof(kb_SUMO_3073,axiom,
    s__documentation(s__CostaRica,s__EnglishLanguage,'The &%Nation of CostaRica.') ).

fof(kb_SUMO_3074,axiom,
    s__documentation(s__CoteDIvoire,s__EnglishLanguage,'The &%Nation of CoteDIvoire.') ).

fof(kb_SUMO_3075,axiom,
    s__documentation(s__Croatia,s__EnglishLanguage,'The &%Nation of Croatia.') ).

fof(kb_SUMO_3076,axiom,
    s__documentation(s__Cuba,s__EnglishLanguage,'An &%Island &%Nation in the Carribbean.') ).

fof(kb_SUMO_3077,axiom,
    s__documentation(s__Cyprus,s__EnglishLanguage,'The &%Nation of Cyprus.') ).

fof(kb_SUMO_3078,axiom,
    s__documentation(s__CzechRepublic,s__EnglishLanguage,'The &%Nation of CzechRepublic.') ).

fof(kb_SUMO_3079,axiom,
    s__documentation(s__DemocraticRepublicOfTheCongo,s__EnglishLanguage,'The &%Nation of DemocraticRepublicOfTheCongo.') ).

fof(kb_SUMO_3080,axiom,
    s__documentation(s__Denmark,s__EnglishLanguage,'A Nation in scandinavian Europe.') ).

fof(kb_SUMO_3081,axiom,
    s__documentation(s__Djibouti,s__EnglishLanguage,'The &%Nation of Djibouti.') ).

fof(kb_SUMO_3082,axiom,
    s__documentation(s__Dominica,s__EnglishLanguage,'The &%Nation of Dominica.') ).

fof(kb_SUMO_3083,axiom,
    s__documentation(s__DominicanRepublic,s__EnglishLanguage,'The &%Nation of DominicanRepublic.') ).

fof(kb_SUMO_3084,axiom,
    s__documentation(s__EastTimor,s__EnglishLanguage,'The &%Nation of EastTimor.') ).

fof(kb_SUMO_3085,axiom,
    s__documentation(s__Ecuador,s__EnglishLanguage,'The &%Nation of Ecuador.') ).

fof(kb_SUMO_3086,axiom,
    s__documentation(s__Egypt,s__EnglishLanguage,'The &%Nation of Egypt.') ).

fof(kb_SUMO_3087,axiom,
    s__documentation(s__EquatorialGuinea,s__EnglishLanguage,'The &%Nation of EquatorialGuinea.') ).

fof(kb_SUMO_3088,axiom,
    s__documentation(s__ElSalvador,s__EnglishLanguage,'The &%Nation of ElSalvador.') ).

fof(kb_SUMO_3089,axiom,
    s__documentation(s__Eritrea,s__EnglishLanguage,'The &%Nation of Eritrea.') ).

fof(kb_SUMO_3090,axiom,
    s__documentation(s__Estonia,s__EnglishLanguage,'The &%Nation of Estonia.') ).

fof(kb_SUMO_3091,axiom,
    s__documentation(s__Ethiopia,s__EnglishLanguage,'The &%Nation of Ethiopia.') ).

fof(kb_SUMO_3092,axiom,
    s__documentation(s__Fiji,s__EnglishLanguage,'The &%Nation of Fiji.') ).

fof(kb_SUMO_3093,axiom,
    s__documentation(s__Finland,s__EnglishLanguage,'The &%Nation of Finland.') ).

fof(kb_SUMO_3094,axiom,
    s__documentation(s__France,s__EnglishLanguage,'A large, industrialized European &%Nation.') ).

fof(kb_SUMO_3095,axiom,
    s__documentation(s__RepublicOfGeorgia,s__EnglishLanguage,'The &%Nation of Georgia.') ).

fof(kb_SUMO_3096,axiom,
    s__documentation(s__Gabon,s__EnglishLanguage,'The &%Nation of Gabon.') ).

fof(kb_SUMO_3097,axiom,
    s__documentation(s__Gambia,s__EnglishLanguage,'The &%Nation of Gambia.') ).

fof(kb_SUMO_3098,axiom,
    s__part(s__Germany,s__Europe) ).

fof(kb_SUMO_3099,axiom,
    s__documentation(s__Germany,s__EnglishLanguage,'A large &%EuropeanNation.') ).

fof(kb_SUMO_3100,axiom,
    s__documentation(s__Ghana,s__EnglishLanguage,'The &%Nation of Ghana.') ).

fof(kb_SUMO_3101,axiom,
    s__part(s__Greece,s__Europe) ).

fof(kb_SUMO_3102,axiom,
    s__documentation(s__Greece,s__EnglishLanguage,'A small Balkan &%Nation that is known primarily for the literature, philosophy, and art produced there during the ancient period.') ).

fof(kb_SUMO_3103,axiom,
    s__documentation(s__Grenada,s__EnglishLanguage,'The &%Nation of Grenada.') ).

fof(kb_SUMO_3104,axiom,
    s__documentation(s__Guatemala,s__EnglishLanguage,'The &%Nation of Guatemala.') ).

fof(kb_SUMO_3105,axiom,
    s__documentation(s__Guinea,s__EnglishLanguage,'The &%Nation of Guinea.') ).

fof(kb_SUMO_3106,axiom,
    s__documentation(s__GuineaBissau,s__EnglishLanguage,'The &%Nation of GuineaBissau.') ).

fof(kb_SUMO_3107,axiom,
    s__documentation(s__Guyana,s__EnglishLanguage,'The &%Nation of Guyana.') ).

fof(kb_SUMO_3108,axiom,
    s__documentation(s__Haiti,s__EnglishLanguage,'The &%Nation of Haiti.') ).

fof(kb_SUMO_3109,axiom,
    s__documentation(s__HolySee,s__EnglishLanguage,'The &%Nation of HolySee.') ).

fof(kb_SUMO_3110,axiom,
    s__documentation(s__Honduras,s__EnglishLanguage,'The &%Nation of Honduras.') ).

fof(kb_SUMO_3111,axiom,
    s__documentation(s__Hungary,s__EnglishLanguage,'The &%Nation of Hungary.') ).

fof(kb_SUMO_3112,axiom,
    s__instance(s__Iceland,s__Island) ).

fof(kb_SUMO_3113,axiom,
    s__documentation(s__Iceland,s__EnglishLanguage,'The &%Nation of Iceland.') ).

fof(kb_SUMO_3114,axiom,
    s__documentation(s__India,s__EnglishLanguage,'A &%Nation in southern Asia which is the second most populous in the world.') ).

fof(kb_SUMO_3115,axiom,
    s__documentation(s__Indonesia,s__EnglishLanguage,'The &%Nation of Indonesia.') ).

fof(kb_SUMO_3116,axiom,
    s__documentation(s__Iran,s__EnglishLanguage,'The &%Nation of Iran.') ).

fof(kb_SUMO_3117,axiom,
    s__documentation(s__Iraq,s__EnglishLanguage,'The &%Nation of Iraq.') ).

fof(kb_SUMO_3118,axiom,
    s__documentation(s__Ireland,s__EnglishLanguage,'An independent &%Nation that borders on the Irish Sea.') ).

fof(kb_SUMO_3119,axiom,
    s__documentation(s__Israel,s__EnglishLanguage,'The &%Nation of Israel.') ).

fof(kb_SUMO_3120,axiom,
    s__documentation(s__Italy,s__EnglishLanguage,'A large, industrialized European Nation.') ).

fof(kb_SUMO_3121,axiom,
    s__documentation(s__Jamaica,s__EnglishLanguage,'The &%Nation of Jamaica.') ).

fof(kb_SUMO_3122,axiom,
    s__documentation(s__Japan,s__EnglishLanguage,'A large industrialized Asian &%Nation.') ).

fof(kb_SUMO_3123,axiom,
    s__documentation(s__Jordan,s__EnglishLanguage,'The &%Nation of Jordan.') ).

fof(kb_SUMO_3124,axiom,
    s__documentation(s__Kazakhstan,s__EnglishLanguage,'The &%Nation of Kazakhstan.') ).

fof(kb_SUMO_3125,axiom,
    s__documentation(s__Kenya,s__EnglishLanguage,'The &%Nation of Kenya.') ).

fof(kb_SUMO_3126,axiom,
    s__documentation(s__Kiribati,s__EnglishLanguage,'The &%Nation of Kiribati.') ).

fof(kb_SUMO_3127,axiom,
    s__documentation(s__Kyrgyzstan,s__EnglishLanguage,'The &%Nation of Kyrgyzstan.') ).

fof(kb_SUMO_3128,axiom,
    s__documentation(s__Kuwait,s__EnglishLanguage,'The &%Nation of Kuwait.') ).

fof(kb_SUMO_3129,axiom,
    s__documentation(s__Laos,s__EnglishLanguage,'A &%Nation in southeastern Asia.') ).

fof(kb_SUMO_3130,axiom,
    s__documentation(s__Latvia,s__EnglishLanguage,'The &%Nation of Latvia.') ).

fof(kb_SUMO_3131,axiom,
    s__documentation(s__Lebanon,s__EnglishLanguage,'The &%Nation of Lebanon.') ).

fof(kb_SUMO_3132,axiom,
    s__documentation(s__Lesotho,s__EnglishLanguage,'The &%Nation of Lesotho.') ).

fof(kb_SUMO_3133,axiom,
    s__documentation(s__Liberia,s__EnglishLanguage,'The &%Nation of Liberia.') ).

fof(kb_SUMO_3134,axiom,
    s__documentation(s__Libya,s__EnglishLanguage,'The &%Nation of Libya.') ).

fof(kb_SUMO_3135,axiom,
    s__documentation(s__Liechtenstein,s__EnglishLanguage,'The &%Nation of Liechtenstein.') ).

fof(kb_SUMO_3136,axiom,
    s__documentation(s__Lithuania,s__EnglishLanguage,'The &%Nation of Lithuania.') ).

fof(kb_SUMO_3137,axiom,
    s__documentation(s__Luxembourg,s__EnglishLanguage,'The &%Nation of Luxembourg.') ).

fof(kb_SUMO_3138,axiom,
    s__documentation(s__Macedonia,s__EnglishLanguage,'The &%Nation of Macedonia.') ).

fof(kb_SUMO_3139,axiom,
    s__documentation(s__Madagascar,s__EnglishLanguage,'The &%Nation of Madagascar.') ).

fof(kb_SUMO_3140,axiom,
    s__documentation(s__Malawi,s__EnglishLanguage,'The &%Nation of Malawi.') ).

fof(kb_SUMO_3141,axiom,
    s__documentation(s__Malaysia,s__EnglishLanguage,'The &%Nation of Malaysia.') ).

fof(kb_SUMO_3142,axiom,
    s__documentation(s__Maldives,s__EnglishLanguage,'The &%Nation of Maldives.') ).

fof(kb_SUMO_3143,axiom,
    s__documentation(s__Mali,s__EnglishLanguage,'The &%Nation of Mali.') ).

fof(kb_SUMO_3144,axiom,
    s__documentation(s__Malta,s__EnglishLanguage,'The &%Nation of Malta.') ).

fof(kb_SUMO_3145,axiom,
    s__documentation(s__MarshallIslands,s__EnglishLanguage,'The &%Nation of MarshallIslands.') ).

fof(kb_SUMO_3146,axiom,
    s__documentation(s__Mauritania,s__EnglishLanguage,'The &%Nation of Mauritania.') ).

fof(kb_SUMO_3147,axiom,
    s__documentation(s__Mauritius,s__EnglishLanguage,'The &%Nation of Mauritius.') ).

fof(kb_SUMO_3148,axiom,
    s__meetsSpatially(s__Mexico,s__UnitedStates) ).

fof(kb_SUMO_3149,axiom,
    s__documentation(s__Mexico,s__EnglishLanguage,'A large Spanish-speaking country that borders on the &%UnitedStates.') ).

fof(kb_SUMO_3150,axiom,
    s__documentation(s__Micronesia,s__EnglishLanguage,'The &%Nation of Micronesia.') ).

fof(kb_SUMO_3151,axiom,
    s__documentation(s__Moldova,s__EnglishLanguage,'The &%Nation of Moldova.') ).

fof(kb_SUMO_3152,axiom,
    s__documentation(s__Monaco,s__EnglishLanguage,'The &%Nation of Monaco.') ).

fof(kb_SUMO_3153,axiom,
    s__documentation(s__Mongolia,s__EnglishLanguage,'The &%Nation of Mongolia.') ).

fof(kb_SUMO_3154,axiom,
    s__documentation(s__Morocco,s__EnglishLanguage,'The &%Nation of Morocco, which is in northwestern Africa.') ).

fof(kb_SUMO_3155,axiom,
    s__documentation(s__Mozambique,s__EnglishLanguage,'The &%Nation of Mozambique.') ).

fof(kb_SUMO_3156,axiom,
    s__documentation(s__Myanmar,s__EnglishLanguage,'A &%Nation in southeastern Asia, formerly known as Burma.') ).

fof(kb_SUMO_3157,axiom,
    s__documentation(s__Namibia,s__EnglishLanguage,'The &%Nation of Namibia.') ).

fof(kb_SUMO_3158,axiom,
    s__documentation(s__Nauru,s__EnglishLanguage,'The &%Nation of Nauru.') ).

fof(kb_SUMO_3159,axiom,
    s__documentation(s__Nepal,s__EnglishLanguage,'The &%Nation of Nepal.') ).

fof(kb_SUMO_3160,axiom,
    s__documentation(s__Netherlands,s__EnglishLanguage,'A small &%Nation in western Europe.') ).

fof(kb_SUMO_3161,axiom,
    s__documentation(s__NewZealand,s__EnglishLanguage,'The &%Nation of NewZealand.') ).

fof(kb_SUMO_3162,axiom,
    s__documentation(s__Nicaragua,s__EnglishLanguage,'The &%Nation of Nicaragua.') ).

fof(kb_SUMO_3163,axiom,
    s__documentation(s__Niger,s__EnglishLanguage,'The &%Nation of Niger.') ).

fof(kb_SUMO_3164,axiom,
    s__documentation(s__Nigeria,s__EnglishLanguage,'The &%Nation of Nigeria.') ).

fof(kb_SUMO_3165,axiom,
    s__documentation(s__NorthernIreland,s__EnglishLanguage,'The region of NorthernIreland.') ).

fof(kb_SUMO_3166,axiom,
    s__instance(s__NorthernIreland,s__GeographicArea) ).

fof(kb_SUMO_3167,axiom,
    s__documentation(s__NorthKorea,s__EnglishLanguage,'The &%Nation of NorthKorea.') ).

fof(kb_SUMO_3168,axiom,
    s__documentation(s__Norway,s__EnglishLanguage,'The &%Nation of Norway.') ).

fof(kb_SUMO_3169,axiom,
    s__documentation(s__Oman,s__EnglishLanguage,'The &%Nation of Oman.') ).

fof(kb_SUMO_3170,axiom,
    s__documentation(s__Pakistan,s__EnglishLanguage,'The &%Nation of &%Pakistan.') ).

fof(kb_SUMO_3171,axiom,
    s__documentation(s__Palau,s__EnglishLanguage,'The &%Nation of Palau.') ).

fof(kb_SUMO_3172,axiom,
    s__documentation(s__Panama,s__EnglishLanguage,'The &%Nation of Panama.') ).

fof(kb_SUMO_3173,axiom,
    s__documentation(s__PapuaNewGuinea,s__EnglishLanguage,'The &%Nation of PapuaNewGuinea.') ).

fof(kb_SUMO_3174,axiom,
    s__documentation(s__Paraguay,s__EnglishLanguage,'The &%Nation of Paraguay.') ).

fof(kb_SUMO_3175,axiom,
    s__documentation(s__Peru,s__EnglishLanguage,'The &%Nation of Peru.') ).

fof(kb_SUMO_3176,axiom,
    s__documentation(s__Philippines,s__EnglishLanguage,'The &%Nation of Philippines.') ).

fof(kb_SUMO_3177,axiom,
    s__documentation(s__Poland,s__EnglishLanguage,'A &%EuropeanNation in central Europe.') ).

fof(kb_SUMO_3178,axiom,
    s__documentation(s__Portugal,s__EnglishLanguage,'The &%Nation of Portugal.') ).

fof(kb_SUMO_3179,axiom,
    s__documentation(s__Qatar,s__EnglishLanguage,'The &%Nation of Qatar.') ).

fof(kb_SUMO_3180,axiom,
    s__instance(s__Rhodes,s__Nation) ).

fof(kb_SUMO_3181,axiom,
    s__documentation(s__Rhodes,s__EnglishLanguage,'The &%Nation of Rhodes.') ).

fof(kb_SUMO_3182,axiom,
    s__documentation(s__Romania,s__EnglishLanguage,'The &%Nation of Romania.') ).

fof(kb_SUMO_3183,axiom,
    s__documentation(s__Russia,s__EnglishLanguage,'A &%Nation which is currently independent, but which was once part of the &%SovietUnion.') ).

fof(kb_SUMO_3184,axiom,
    s__documentation(s__Rwanda,s__EnglishLanguage,'The &%Nation of Rwanda.') ).

fof(kb_SUMO_3185,axiom,
    s__documentation(s__SaintKittsAndNevis,s__EnglishLanguage,'The &%Nation of SaintKittsAndNevis.') ).

fof(kb_SUMO_3186,axiom,
    s__documentation(s__SaintLucia,s__EnglishLanguage,'The &%Nation of SaintLucia.') ).

fof(kb_SUMO_3187,axiom,
    s__documentation(s__SaintVincentAndTheGrenadines,s__EnglishLanguage,'The &%Nation of SaintVincentAndTheGrenadines.') ).

fof(kb_SUMO_3188,axiom,
    s__documentation(s__Samoa,s__EnglishLanguage,'The &%Nation of Samoa.') ).

fof(kb_SUMO_3189,axiom,
    s__documentation(s__SanMarino,s__EnglishLanguage,'The &%Nation of SanMarino.') ).

fof(kb_SUMO_3190,axiom,
    s__documentation(s__SaoTomeAndPrincipe,s__EnglishLanguage,'The &%Nation of SaoTomeAndPrincipe.') ).

fof(kb_SUMO_3191,axiom,
    s__documentation(s__SaudiArabia,s__EnglishLanguage,'The &%Nation of SaudiArabia.') ).

fof(kb_SUMO_3192,axiom,
    s__documentation(s__Senegal,s__EnglishLanguage,'The &%Nation of Senegal.') ).

fof(kb_SUMO_3193,axiom,
    s__documentation(s__SerbiaAndMontenegro,s__EnglishLanguage,'The &%Nation of SerbiaAndMontenegro.') ).

fof(kb_SUMO_3194,axiom,
    s__documentation(s__Seychelles,s__EnglishLanguage,'The &%Nation of Seychelles.') ).

fof(kb_SUMO_3195,axiom,
    s__documentation(s__SierraLeone,s__EnglishLanguage,'The &%Nation of SierraLeone.') ).

fof(kb_SUMO_3196,axiom,
    s__documentation(s__Singapore,s__EnglishLanguage,'The &%Nation of Singapore.') ).

fof(kb_SUMO_3197,axiom,
    s__documentation(s__Slovakia,s__EnglishLanguage,'The &%Nation of Slovakia.') ).

fof(kb_SUMO_3198,axiom,
    s__documentation(s__Slovenia,s__EnglishLanguage,'The &%Nation of Slovenia.') ).

fof(kb_SUMO_3199,axiom,
    s__documentation(s__SolomonIslands,s__EnglishLanguage,'The &%Nation of SolomonIslands.') ).

fof(kb_SUMO_3200,axiom,
    s__documentation(s__Somalia,s__EnglishLanguage,'The &%Nation of Somalia.') ).

fof(kb_SUMO_3201,axiom,
    s__documentation(s__SouthAfrica,s__EnglishLanguage,'The &%Nation of SouthAfrica.') ).

fof(kb_SUMO_3202,axiom,
    s__documentation(s__SouthKorea,s__EnglishLanguage,'The &%Nation of SouthKorea.') ).

fof(kb_SUMO_3203,axiom,
    s__documentation(s__Spain,s__EnglishLanguage,'A large, industrialized &%EuropeanNation.') ).

fof(kb_SUMO_3204,axiom,
    s__documentation(s__SriLanka,s__EnglishLanguage,'The &%Nation of SriLanka.') ).

fof(kb_SUMO_3205,axiom,
    s__documentation(s__Sudan,s__EnglishLanguage,'The &%Nation of Sudan.') ).

fof(kb_SUMO_3206,axiom,
    s__documentation(s__Suriname,s__EnglishLanguage,'The &%Nation of Suriname.') ).

fof(kb_SUMO_3207,axiom,
    s__documentation(s__Swaziland,s__EnglishLanguage,'The &%Nation of Swaziland.') ).

fof(kb_SUMO_3208,axiom,
    s__documentation(s__Sweden,s__EnglishLanguage,'A &%Nation in scandinavian Europe.') ).

fof(kb_SUMO_3209,axiom,
    s__documentation(s__Switzerland,s__EnglishLanguage,'A small politically neutral &%Nation in central Europe.') ).

fof(kb_SUMO_3210,axiom,
    s__documentation(s__Syria,s__EnglishLanguage,'The &%Nation of Syria.') ).

fof(kb_SUMO_3211,axiom,
    s__documentation(s__Taiwan,s__EnglishLanguage,'The &%Nation of Taiwan, which is claimed by &%China.') ).

fof(kb_SUMO_3212,axiom,
    s__documentation(s__Tajikistan,s__EnglishLanguage,'The &%Nation of Tajikistan.') ).

fof(kb_SUMO_3213,axiom,
    s__documentation(s__Tanzania,s__EnglishLanguage,'The &%Nation of Tanzania.') ).

fof(kb_SUMO_3214,axiom,
    s__documentation(s__Thailand,s__EnglishLanguage,'The &%Nation of Thailand.') ).

fof(kb_SUMO_3215,axiom,
    s__documentation(s__TheBahamas,s__EnglishLanguage,'The &%Nation of TheBahamas.') ).

fof(kb_SUMO_3216,axiom,
    s__documentation(s__Togo,s__EnglishLanguage,'The &%Nation of Togo.') ).

fof(kb_SUMO_3217,axiom,
    s__documentation(s__Tonga,s__EnglishLanguage,'The &%Nation of Tonga.') ).

fof(kb_SUMO_3218,axiom,
    s__documentation(s__TrinidadAndTobago,s__EnglishLanguage,'The &%Nation of TrinidadAndTobago.') ).

fof(kb_SUMO_3219,axiom,
    s__documentation(s__Tunisia,s__EnglishLanguage,'The &%Nation of Tunisia.') ).

fof(kb_SUMO_3220,axiom,
    s__documentation(s__Turkey,s__EnglishLanguage,'The &%Nation of Turkey.') ).

fof(kb_SUMO_3221,axiom,
    s__documentation(s__Turkmenistan,s__EnglishLanguage,'The &%Nation of Turkmenistan.') ).

fof(kb_SUMO_3222,axiom,
    s__documentation(s__Tuvalu,s__EnglishLanguage,'The &%Nation of Tuvalu.') ).

fof(kb_SUMO_3223,axiom,
    s__documentation(s__Uganda,s__EnglishLanguage,'The &%Nation of Uganda.') ).

fof(kb_SUMO_3224,axiom,
    s__documentation(s__Ukraine,s__EnglishLanguage,'The &%Nation of Ukraine.') ).

fof(kb_SUMO_3225,axiom,
    s__documentation(s__UnitedArabEmirates,s__EnglishLanguage,'The &%Nation of UnitedArabEmirates.') ).

fof(kb_SUMO_3226,axiom,
    s__documentation(s__UnitedStates,s__EnglishLanguage,'The North American republic of 50 states.') ).

fof(kb_SUMO_3227,axiom,
    s__documentation(s__Uruguay,s__EnglishLanguage,'The &%Nation of Uruguay.') ).

fof(kb_SUMO_3228,axiom,
    s__documentation(s__Uzbekistan,s__EnglishLanguage,'The &%Nation of Uzbekistan.') ).

fof(kb_SUMO_3229,axiom,
    s__documentation(s__Vanuatu,s__EnglishLanguage,'The &%Nation of Vanuatu.') ).

fof(kb_SUMO_3230,axiom,
    s__documentation(s__Vietnam,s__EnglishLanguage,'The &%Nation of Vietnam.') ).

fof(kb_SUMO_3231,axiom,
    s__documentation(s__Venezuela,s__EnglishLanguage,'The &%Nation of Venezuela.') ).

fof(kb_SUMO_3232,axiom,
    s__documentation(s__Yemen,s__EnglishLanguage,'The &%Nation of Yemen.') ).

fof(kb_SUMO_3233,axiom,
    s__instance(s__WestBank,s__GeographicArea) ).

fof(kb_SUMO_3234,axiom,
    s__documentation(s__WestBank,s__EnglishLanguage,'A terroritory occupied by &%Israel.') ).

fof(kb_SUMO_3235,axiom,
    s__instance(s__GazaStrip,s__GeographicArea) ).

fof(kb_SUMO_3236,axiom,
    s__documentation(s__GazaStrip,s__EnglishLanguage,'A terroritory occupied by &%Israel.') ).

fof(kb_SUMO_3237,axiom,
    s__documentation(s__Zambia,s__EnglishLanguage,'The &%Nation of Zambia.') ).

fof(kb_SUMO_3238,axiom,
    s__instance(s__AdanaTurkey,s__City) ).

fof(kb_SUMO_3239,axiom,
    s__documentation(s__AdanaTurkey,s__EnglishLanguage,'The &%City of &%Adana in &%Turkey.') ).

fof(kb_SUMO_3240,axiom,
    s__instance(s__AddisAbabaEthiopia,s__City) ).

fof(kb_SUMO_3241,axiom,
    s__documentation(s__AddisAbabaEthiopia,s__EnglishLanguage,'The &%City of &%AddisAbaba in &%Ethiopia.') ).

fof(kb_SUMO_3242,axiom,
    s__instance(s__AdenYemen,s__City) ).

fof(kb_SUMO_3243,axiom,
    s__documentation(s__AdenYemen,s__EnglishLanguage,'The &%City of &%Aden in &%Yemen.') ).

fof(kb_SUMO_3244,axiom,
    s__instance(s__AdoraWestBank,s__City) ).

fof(kb_SUMO_3245,axiom,
    s__documentation(s__AdoraWestBank,s__EnglishLanguage,'The &%City of &%Adora in &%WestBank.') ).

fof(kb_SUMO_3246,axiom,
    s__instance(s__AfulaIsrael,s__City) ).

fof(kb_SUMO_3247,axiom,
    s__documentation(s__AfulaIsrael,s__EnglishLanguage,'The &%City of &%Afula in &%Israel.') ).

fof(kb_SUMO_3248,axiom,
    s__instance(s__AgriTurkey,s__City) ).

fof(kb_SUMO_3249,axiom,
    s__documentation(s__AgriTurkey,s__EnglishLanguage,'The &%City of &%Agri in &%Turkey.') ).

fof(kb_SUMO_3250,axiom,
    s__instance(s__AinDeflaAlgeria,s__City) ).

fof(kb_SUMO_3251,axiom,
    s__documentation(s__AinDeflaAlgeria,s__EnglishLanguage,'The &%City of &%AinDefla in &%Algeria.') ).

fof(kb_SUMO_3252,axiom,
    s__instance(s__AinElHajarAlgeria,s__City) ).

fof(kb_SUMO_3253,axiom,
    s__documentation(s__AinElHajarAlgeria,s__EnglishLanguage,'The &%City of &%AinElHajar in &%Algeria.') ).

fof(kb_SUMO_3254,axiom,
    s__instance(s__AjaccioFrance,s__City) ).

fof(kb_SUMO_3255,axiom,
    s__documentation(s__AjaccioFrance,s__EnglishLanguage,'The &%City of &%Ajaccio in &%France.') ).

fof(kb_SUMO_3256,axiom,
    s__instance(s__AlBalamandLebanon,s__City) ).

fof(kb_SUMO_3257,axiom,
    s__documentation(s__AlBalamandLebanon,s__EnglishLanguage,'The &%City of &%AlBalamand in &%Lebanon.') ).

fof(kb_SUMO_3258,axiom,
    s__instance(s__AleiSinaiGazaStrip,s__City) ).

fof(kb_SUMO_3259,axiom,
    s__documentation(s__AleiSinaiGazaStrip,s__EnglishLanguage,'The &%City of &%AleiSinai in &%GazaStrip.') ).

fof(kb_SUMO_3260,axiom,
    s__instance(s__AleiZahavWestBank,s__City) ).

fof(kb_SUMO_3261,axiom,
    s__documentation(s__AleiZahavWestBank,s__EnglishLanguage,'The &%City of &%AleiZahav in &%WestBank.') ).

fof(kb_SUMO_3262,axiom,
    s__instance(s__AleyLebanon,s__City) ).

fof(kb_SUMO_3263,axiom,
    s__documentation(s__AleyLebanon,s__EnglishLanguage,'The &%City of &%Aley in &%Lebanon.') ).

fof(kb_SUMO_3264,axiom,
    s__instance(s__AlgiersAlgeria,s__City) ).

fof(kb_SUMO_3265,axiom,
    s__documentation(s__AlgiersAlgeria,s__EnglishLanguage,'The &%City of &%Algiers in &%Algeria.') ).

fof(kb_SUMO_3266,axiom,
    s__instance(s__AlkhanYurtRussia,s__City) ).

fof(kb_SUMO_3267,axiom,
    s__documentation(s__AlkhanYurtRussia,s__EnglishLanguage,'The &%City of &%AlkhanYurt in &%Russia.') ).

fof(kb_SUMO_3268,axiom,
    s__instance(s__AlonMorehWestBank,s__City) ).

fof(kb_SUMO_3269,axiom,
    s__documentation(s__AlonMorehWestBank,s__EnglishLanguage,'The &%City of &%AlonMoreh in &%WestBank.') ).

fof(kb_SUMO_3270,axiom,
    s__instance(s__AmbonIndonesia,s__City) ).

fof(kb_SUMO_3271,axiom,
    s__documentation(s__AmbonIndonesia,s__EnglishLanguage,'The &%City of &%Ambon in &%Indonesia.') ).

fof(kb_SUMO_3272,axiom,
    s__instance(s__AmmanJordan,s__City) ).

fof(kb_SUMO_3273,axiom,
    s__documentation(s__AmmanJordan,s__EnglishLanguage,'The &%City of &%Amman in &%Jordan.') ).

fof(kb_SUMO_3274,axiom,
    s__instance(s__AnNuwaydiratBahrain,s__City) ).

fof(kb_SUMO_3275,axiom,
    s__documentation(s__AnNuwaydiratBahrain,s__EnglishLanguage,'The &%City of &%AnNuwaydirat in &%Bahrain.') ).

fof(kb_SUMO_3276,axiom,
    s__instance(s__AndeanSpain,s__City) ).

fof(kb_SUMO_3277,axiom,
    s__documentation(s__AndeanSpain,s__EnglishLanguage,'The &%City of &%Andean in &%Spain.') ).

fof(kb_SUMO_3278,axiom,
    s__instance(s__AngkorWatCambodia,s__City) ).

fof(kb_SUMO_3279,axiom,
    s__documentation(s__AngkorWatCambodia,s__EnglishLanguage,'The &%City of &%AngkorWat in &%Cambodia.') ).

fof(kb_SUMO_3280,axiom,
    s__instance(s__AnkaraTurkey,s__City) ).

fof(kb_SUMO_3281,axiom,
    s__documentation(s__AnkaraTurkey,s__EnglishLanguage,'The &%City of &%Ankara in &%Turkey.') ).

fof(kb_SUMO_3282,axiom,
    s__instance(s__AntalyaTurkey,s__City) ).

fof(kb_SUMO_3283,axiom,
    s__documentation(s__AntalyaTurkey,s__EnglishLanguage,'The &%City of &%Antalya in &%Turkey.') ).

fof(kb_SUMO_3284,axiom,
    s__instance(s__AntioquiaColombia,s__City) ).

fof(kb_SUMO_3285,axiom,
    s__documentation(s__AntioquiaColombia,s__EnglishLanguage,'The &%City of &%Antioquia in &%Colombia.') ).

fof(kb_SUMO_3286,axiom,
    s__instance(s__AntwerpBelgium,s__City) ).

fof(kb_SUMO_3287,axiom,
    s__documentation(s__AntwerpBelgium,s__EnglishLanguage,'The &%City of &%Antwerp in &%Belgium.') ).

fof(kb_SUMO_3288,axiom,
    s__instance(s__ApumiracPeru,s__City) ).

fof(kb_SUMO_3289,axiom,
    s__documentation(s__ApumiracPeru,s__EnglishLanguage,'The &%City of &%Apumirac in &%Peru.') ).

fof(kb_SUMO_3290,axiom,
    s__instance(s__ApureVenezuela,s__City) ).

fof(kb_SUMO_3291,axiom,
    s__documentation(s__ApureVenezuela,s__EnglishLanguage,'The &%City of &%Apure in &%Venezuela.') ).

fof(kb_SUMO_3292,axiom,
    s__instance(s__AraucaColombia,s__City) ).

fof(kb_SUMO_3293,axiom,
    s__documentation(s__AraucaColombia,s__EnglishLanguage,'The &%City of &%Arauca in &%Colombia.') ).

fof(kb_SUMO_3294,axiom,
    s__instance(s__ArgunRussia,s__City) ).

fof(kb_SUMO_3295,axiom,
    s__documentation(s__ArgunRussia,s__EnglishLanguage,'The &%City of &%Argun in &%Russia.') ).

fof(kb_SUMO_3296,axiom,
    s__instance(s__ArielWestBank,s__City) ).

fof(kb_SUMO_3297,axiom,
    s__documentation(s__ArielWestBank,s__EnglishLanguage,'The &%City of &%Ariel in &%WestBank.') ).

fof(kb_SUMO_3298,axiom,
    s__instance(s__ArmaghNorthernIreland,s__City) ).

fof(kb_SUMO_3299,axiom,
    s__documentation(s__ArmaghNorthernIreland,s__EnglishLanguage,'The &%City of &%Armagh in &%NorthernIreland.') ).

fof(kb_SUMO_3300,axiom,
    s__instance(s__ArzewAlgeria,s__City) ).

fof(kb_SUMO_3301,axiom,
    s__documentation(s__ArzewAlgeria,s__EnglishLanguage,'The &%City of &%Arzew in &%Algeria.') ).

fof(kb_SUMO_3302,axiom,
    s__instance(s__AshdodIsrael,s__City) ).

fof(kb_SUMO_3303,axiom,
    s__documentation(s__AshdodIsrael,s__EnglishLanguage,'The &%City of &%Ashdod in &%Israel.') ).

fof(kb_SUMO_3304,axiom,
    s__instance(s__AskelonIsrael,s__City) ).

fof(kb_SUMO_3305,axiom,
    s__documentation(s__AskelonIsrael,s__EnglishLanguage,'The &%City of &%Askelon in &%Israel.') ).

fof(kb_SUMO_3306,axiom,
    s__instance(s__AsmaraEritrea,s__City) ).

fof(kb_SUMO_3307,axiom,
    s__documentation(s__AsmaraEritrea,s__EnglishLanguage,'The &%City of &%Asmara in &%Eritrea.') ).

fof(kb_SUMO_3308,axiom,
    s__instance(s__AssamIndia,s__City) ).

fof(kb_SUMO_3309,axiom,
    s__documentation(s__AssamIndia,s__EnglishLanguage,'The &%City of &%Assam in &%India.') ).

fof(kb_SUMO_3310,axiom,
    s__instance(s__AswanEgypt,s__City) ).

fof(kb_SUMO_3311,axiom,
    s__documentation(s__AswanEgypt,s__EnglishLanguage,'The &%City of &%Aswan in &%Egypt.') ).

fof(kb_SUMO_3312,axiom,
    s__instance(s__AsyutEgypt,s__City) ).

fof(kb_SUMO_3313,axiom,
    s__documentation(s__AsyutEgypt,s__EnglishLanguage,'The &%City of &%Asyut in &%Egypt.') ).

fof(kb_SUMO_3314,axiom,
    s__instance(s__AthensGreece,s__City) ).

fof(kb_SUMO_3315,axiom,
    s__documentation(s__AthensGreece,s__EnglishLanguage,'The &%City of &%Athens in &%Greece.') ).

fof(kb_SUMO_3316,axiom,
    s__instance(s__AtrushIraq,s__City) ).

fof(kb_SUMO_3317,axiom,
    s__documentation(s__AtrushIraq,s__EnglishLanguage,'The &%City of &%Atrush in &%Iraq.') ).

fof(kb_SUMO_3318,axiom,
    s__instance(s__AtzmonaGazaStrip,s__City) ).

fof(kb_SUMO_3319,axiom,
    s__documentation(s__AtzmonaGazaStrip,s__EnglishLanguage,'The &%City of &%Atzmona in &%GazaStrip.') ).

fof(kb_SUMO_3320,axiom,
    s__instance(s__AvneiHefetzIsrael,s__City) ).

fof(kb_SUMO_3321,axiom,
    s__documentation(s__AvneiHefetzIsrael,s__EnglishLanguage,'The &%City of &%AvneiHefetz in &%Israel.') ).

fof(kb_SUMO_3322,axiom,
    s__instance(s__AyacuchoPeru,s__City) ).

fof(kb_SUMO_3323,axiom,
    s__documentation(s__AyacuchoPeru,s__EnglishLanguage,'The &%City of &%Ayacucho in &%Peru.') ).

fof(kb_SUMO_3324,axiom,
    s__instance(s__AzorIsrael,s__City) ).

fof(kb_SUMO_3325,axiom,
    s__documentation(s__AzorIsrael,s__EnglishLanguage,'The &%City of &%Azor in &%Israel.') ).

fof(kb_SUMO_3326,axiom,
    s__instance(s__BKaotWestBank,s__City) ).

fof(kb_SUMO_3327,axiom,
    s__documentation(s__BKaotWestBank,s__EnglishLanguage,'The &%City of &%BKaot in &%WestBank.') ).

fof(kb_SUMO_3328,axiom,
    s__instance(s__BadVilbelGermany,s__City) ).

fof(kb_SUMO_3329,axiom,
    s__documentation(s__BadVilbelGermany,s__EnglishLanguage,'The &%City of &%BadVilbel in &%Germany.') ).

fof(kb_SUMO_3330,axiom,
    s__instance(s__BaghdadIraq,s__City) ).

fof(kb_SUMO_3331,axiom,
    s__documentation(s__BaghdadIraq,s__EnglishLanguage,'The &%City of &%Baghdad in &%Iraq.') ).

fof(kb_SUMO_3332,axiom,
    s__instance(s__BagreColombia,s__City) ).

fof(kb_SUMO_3333,axiom,
    s__documentation(s__BagreColombia,s__EnglishLanguage,'The &%City of &%Bagre in &%Colombia.') ).

fof(kb_SUMO_3334,axiom,
    s__instance(s__BahawalpurPakistan,s__City) ).

fof(kb_SUMO_3335,axiom,
    s__documentation(s__BahawalpurPakistan,s__EnglishLanguage,'The &%City of &%Bahawalpur in &%Pakistan.') ).

fof(kb_SUMO_3336,axiom,
    s__instance(s__BakaAlGarbiyehIsrael,s__City) ).

fof(kb_SUMO_3337,axiom,
    s__documentation(s__BakaAlGarbiyehIsrael,s__EnglishLanguage,'The &%City of &%BakaAlGarbiyeh in &%Israel.') ).

fof(kb_SUMO_3338,axiom,
    s__instance(s__BakkaAlSharkiyaWestBank,s__City) ).

fof(kb_SUMO_3339,axiom,
    s__documentation(s__BakkaAlSharkiyaWestBank,s__EnglishLanguage,'The &%City of &%BakkaAlSharkiya in &%WestBank.') ).

fof(kb_SUMO_3340,axiom,
    s__instance(s__BakuAzerbaijan,s__City) ).

fof(kb_SUMO_3341,axiom,
    s__documentation(s__BakuAzerbaijan,s__EnglishLanguage,'The &%City of &%Baku in &%Azerbaijan.') ).

fof(kb_SUMO_3342,axiom,
    s__instance(s__BaleEthiopia,s__City) ).

fof(kb_SUMO_3343,axiom,
    s__documentation(s__BaleEthiopia,s__EnglishLanguage,'The &%City of &%Bale in &%Ethiopia.') ).

fof(kb_SUMO_3344,axiom,
    s__instance(s__BanbridgeNorthernIreland,s__City) ).

fof(kb_SUMO_3345,axiom,
    s__documentation(s__BanbridgeNorthernIreland,s__EnglishLanguage,'The &%City of &%Banbridge in &%NorthernIreland.') ).

fof(kb_SUMO_3346,axiom,
    s__instance(s__BangkokThailand,s__City) ).

fof(kb_SUMO_3347,axiom,
    s__documentation(s__BangkokThailand,s__EnglishLanguage,'The &%City of &%Bangkok in &%Thailand.') ).

fof(kb_SUMO_3348,axiom,
    s__instance(s__BangorNorthernIreland,s__City) ).

fof(kb_SUMO_3349,axiom,
    s__documentation(s__BangorNorthernIreland,s__EnglishLanguage,'The &%City of &%Bangor in &%NorthernIreland.') ).

fof(kb_SUMO_3350,axiom,
    s__instance(s__BanguiCentralAfricanRepublic,s__City) ).

fof(kb_SUMO_3351,axiom,
    s__documentation(s__BanguiCentralAfricanRepublic,s__EnglishLanguage,'The &%City of &%Bangui in &%CentralAfricanRepublic.') ).

fof(kb_SUMO_3352,axiom,
    s__instance(s__BarcelonaSpain,s__City) ).

fof(kb_SUMO_3353,axiom,
    s__documentation(s__BarcelonaSpain,s__EnglishLanguage,'The &%City of &%Barcelona in &%Spain.') ).

fof(kb_SUMO_3354,axiom,
    s__instance(s__BarkeoCambodia,s__City) ).

fof(kb_SUMO_3355,axiom,
    s__documentation(s__BarkeoCambodia,s__EnglishLanguage,'The &%City of &%Barkeo in &%Cambodia.') ).

fof(kb_SUMO_3356,axiom,
    s__instance(s__BarrancabermejaColombia,s__City) ).

fof(kb_SUMO_3357,axiom,
    s__documentation(s__BarrancabermejaColombia,s__EnglishLanguage,'The &%City of &%Barrancabermeja in &%Colombia.') ).

fof(kb_SUMO_3358,axiom,
    s__instance(s__BasraIsrael,s__City) ).

fof(kb_SUMO_3359,axiom,
    s__documentation(s__BasraIsrael,s__EnglishLanguage,'The &%City of &%Basra in &%Israel.') ).

fof(kb_SUMO_3360,axiom,
    s__instance(s__BatYamIsrael,s__City) ).

fof(kb_SUMO_3361,axiom,
    s__documentation(s__BatYamIsrael,s__EnglishLanguage,'The &%City of &%BatYam in &%Israel.') ).

fof(kb_SUMO_3362,axiom,
    s__instance(s__BatmanTurkey,s__City) ).

fof(kb_SUMO_3363,axiom,
    s__documentation(s__BatmanTurkey,s__EnglishLanguage,'The &%City of &%Batman in &%Turkey.') ).

fof(kb_SUMO_3364,axiom,
    s__instance(s__BeErShevaIsrael,s__City) ).

fof(kb_SUMO_3365,axiom,
    s__documentation(s__BeErShevaIsrael,s__EnglishLanguage,'The &%City of &%BeErSheva in &%Israel.') ).

fof(kb_SUMO_3366,axiom,
    s__instance(s__BeasainSpain,s__City) ).

fof(kb_SUMO_3367,axiom,
    s__documentation(s__BeasainSpain,s__EnglishLanguage,'The &%City of &%Beasain in &%Spain.') ).

fof(kb_SUMO_3368,axiom,
    s__instance(s__BeirutLebanon,s__City) ).

fof(kb_SUMO_3369,axiom,
    s__documentation(s__BeirutLebanon,s__EnglishLanguage,'The &%City of &%Beirut in &%Lebanon.') ).

fof(kb_SUMO_3370,axiom,
    s__instance(s__BeitElWestBank,s__City) ).

fof(kb_SUMO_3371,axiom,
    s__documentation(s__BeitElWestBank,s__EnglishLanguage,'The &%City of &%BeitEl in &%WestBank.') ).

fof(kb_SUMO_3372,axiom,
    s__instance(s__BeitHaggaiWestBank,s__City) ).

fof(kb_SUMO_3373,axiom,
    s__documentation(s__BeitHaggaiWestBank,s__EnglishLanguage,'The &%City of &%BeitHaggai in &%WestBank.') ).

fof(kb_SUMO_3374,axiom,
    s__instance(s__BeitHaninaWestBank,s__City) ).

fof(kb_SUMO_3375,axiom,
    s__documentation(s__BeitHaninaWestBank,s__EnglishLanguage,'The &%City of &%BeitHanina in &%WestBank.') ).

fof(kb_SUMO_3376,axiom,
    s__instance(s__BeitSahurWestBank,s__City) ).

fof(kb_SUMO_3377,axiom,
    s__documentation(s__BeitSahurWestBank,s__EnglishLanguage,'The &%City of &%BeitSahur in &%WestBank.') ).

fof(kb_SUMO_3378,axiom,
    s__instance(s__BeitSheAnIsrael,s__City) ).

fof(kb_SUMO_3379,axiom,
    s__documentation(s__BeitSheAnIsrael,s__EnglishLanguage,'The &%City of &%BeitSheAn in &%Israel.') ).

fof(kb_SUMO_3380,axiom,
    s__instance(s__BeitShemeshIsrael,s__City) ).

fof(kb_SUMO_3381,axiom,
    s__documentation(s__BeitShemeshIsrael,s__EnglishLanguage,'The &%City of &%BeitShemesh in &%Israel.') ).

fof(kb_SUMO_3382,axiom,
    s__instance(s__BeledweyneSomalia,s__City) ).

fof(kb_SUMO_3383,axiom,
    s__documentation(s__BeledweyneSomalia,s__EnglishLanguage,'The &%City of &%Beledweyne in &%Somalia.') ).

fof(kb_SUMO_3384,axiom,
    s__instance(s__BelfastNorthernIreland,s__City) ).

fof(kb_SUMO_3385,axiom,
    s__documentation(s__BelfastNorthernIreland,s__EnglishLanguage,'The &%City of &%Belfast in &%NorthernIreland.') ).

fof(kb_SUMO_3386,axiom,
    s__instance(s__BelgradeSerbiaAndMontenegro,s__City) ).

fof(kb_SUMO_3387,axiom,
    s__documentation(s__BelgradeSerbiaAndMontenegro,s__EnglishLanguage,'The &%City of &%Belgrade in &%SerbiaAndMontenegro.') ).

fof(kb_SUMO_3388,axiom,
    s__instance(s__BetLeHiyehGazaStrip,s__City) ).

fof(kb_SUMO_3389,axiom,
    s__documentation(s__BetLeHiyehGazaStrip,s__EnglishLanguage,'The &%City of &%BetLeHiyeh in &%GazaStrip.') ).

fof(kb_SUMO_3390,axiom,
    s__instance(s__BethElIsrael,s__City) ).

fof(kb_SUMO_3391,axiom,
    s__documentation(s__BethElIsrael,s__EnglishLanguage,'The &%City of &%BethEl in &%Israel.') ).

fof(kb_SUMO_3392,axiom,
    s__instance(s__BethlehemWestBank,s__City) ).

fof(kb_SUMO_3393,axiom,
    s__documentation(s__BethlehemWestBank,s__EnglishLanguage,'The &%City of &%Bethlehem in &%WestBank.') ).

fof(kb_SUMO_3394,axiom,
    s__instance(s__BidyaWestBank,s__City) ).

fof(kb_SUMO_3395,axiom,
    s__documentation(s__BidyaWestBank,s__EnglishLanguage,'The &%City of &%Bidya in &%WestBank.') ).

fof(kb_SUMO_3396,axiom,
    s__instance(s__BilbaoSpain,s__City) ).

fof(kb_SUMO_3397,axiom,
    s__documentation(s__BilbaoSpain,s__EnglishLanguage,'The &%City of &%Bilbao in &%Spain.') ).

fof(kb_SUMO_3398,axiom,
    s__instance(s__BillabonaSpain,s__City) ).

fof(kb_SUMO_3399,axiom,
    s__documentation(s__BillabonaSpain,s__EnglishLanguage,'The &%City of &%Billabona in &%Spain.') ).

fof(kb_SUMO_3400,axiom,
    s__instance(s__BinyaminaIsrael,s__City) ).

fof(kb_SUMO_3401,axiom,
    s__documentation(s__BinyaminaIsrael,s__EnglishLanguage,'The &%City of &%Binyamina in &%Israel.') ).

fof(kb_SUMO_3402,axiom,
    s__instance(s__BishkekKyrgyzstan,s__City) ).

fof(kb_SUMO_3403,axiom,
    s__documentation(s__BishkekKyrgyzstan,s__EnglishLanguage,'The &%City of &%Bishkek in &%Kyrgyzstan.') ).

fof(kb_SUMO_3404,axiom,
    s__instance(s__BneiAyishIsrael,s__City) ).

fof(kb_SUMO_3405,axiom,
    s__documentation(s__BneiAyishIsrael,s__EnglishLanguage,'The &%City of &%BneiAyish in &%Israel.') ).

fof(kb_SUMO_3406,axiom,
    s__instance(s__BogotaColombia,s__City) ).

fof(kb_SUMO_3407,axiom,
    s__documentation(s__BogotaColombia,s__EnglishLanguage,'The &%City of &%Bogota in &%Colombia.') ).

fof(kb_SUMO_3408,axiom,
    s__instance(s__BolognaItaly,s__City) ).

fof(kb_SUMO_3409,axiom,
    s__documentation(s__BolognaItaly,s__EnglishLanguage,'The &%City of &%Bologna in &%Italy.') ).

fof(kb_SUMO_3410,axiom,
    s__instance(s__BonnGermany,s__City) ).

fof(kb_SUMO_3411,axiom,
    s__documentation(s__BonnGermany,s__EnglishLanguage,'The &%City of &%Bonn in &%Germany.') ).

fof(kb_SUMO_3412,axiom,
    s__instance(s__BouiraAlgeria,s__City) ).

fof(kb_SUMO_3413,axiom,
    s__documentation(s__BouiraAlgeria,s__EnglishLanguage,'The &%City of &%Bouira in &%Algeria.') ).

fof(kb_SUMO_3414,axiom,
    s__instance(s__BouzeGueneAlgeria,s__City) ).

fof(kb_SUMO_3415,axiom,
    s__documentation(s__BouzeGueneAlgeria,s__EnglishLanguage,'The &%City of &%BouzeGuene in &%Algeria.') ).

fof(kb_SUMO_3416,axiom,
    s__instance(s__BrusselsBelgium,s__City) ).

fof(kb_SUMO_3417,axiom,
    s__documentation(s__BrusselsBelgium,s__EnglishLanguage,'The &%City of &%Brussels in &%Belgium.') ).

fof(kb_SUMO_3418,axiom,
    s__instance(s__BucaramangaColombia,s__City) ).

fof(kb_SUMO_3419,axiom,
    s__documentation(s__BucaramangaColombia,s__EnglishLanguage,'The &%City of &%Bucaramanga in &%Colombia.') ).

fof(kb_SUMO_3420,axiom,
    s__instance(s__BucharestRomania,s__City) ).

fof(kb_SUMO_3421,axiom,
    s__documentation(s__BucharestRomania,s__EnglishLanguage,'The &%City of &%Bucharest in &%Romania.') ).

fof(kb_SUMO_3422,axiom,
    s__instance(s__BuenosAiresArgentina,s__City) ).

fof(kb_SUMO_3423,axiom,
    s__documentation(s__BuenosAiresArgentina,s__EnglishLanguage,'The &%City of &%BuenosAires in &%Argentina.') ).

fof(kb_SUMO_3424,axiom,
    s__instance(s__BuinakskRussia,s__City) ).

fof(kb_SUMO_3425,axiom,
    s__documentation(s__BuinakskRussia,s__EnglishLanguage,'The &%City of &%Buinaksk in &%Russia.') ).

fof(kb_SUMO_3426,axiom,
    s__instance(s__CabindaAngola,s__City) ).

fof(kb_SUMO_3427,axiom,
    s__documentation(s__CabindaAngola,s__EnglishLanguage,'The &%City of &%Cabinda in &%Angola.') ).

fof(kb_SUMO_3428,axiom,
    s__instance(s__CaglayanTurkey,s__City) ).

fof(kb_SUMO_3429,axiom,
    s__documentation(s__CaglayanTurkey,s__EnglishLanguage,'The &%City of &%Caglayan in &%Turkey.') ).

fof(kb_SUMO_3430,axiom,
    s__instance(s__CairoEgypt,s__City) ).

fof(kb_SUMO_3431,axiom,
    s__documentation(s__CairoEgypt,s__EnglishLanguage,'The &%City of &%Cairo in &%Egypt.') ).

fof(kb_SUMO_3432,axiom,
    s__instance(s__CalcuttaIndia,s__City) ).

fof(kb_SUMO_3433,axiom,
    s__documentation(s__CalcuttaIndia,s__EnglishLanguage,'The &%City of &%Calcutta in &%India.') ).

fof(kb_SUMO_3434,axiom,
    s__instance(s__CaliColombia,s__City) ).

fof(kb_SUMO_3435,axiom,
    s__documentation(s__CaliColombia,s__EnglishLanguage,'The &%City of &%Cali in &%Colombia.') ).

fof(kb_SUMO_3436,axiom,
    s__instance(s__CampZamaJapan,s__City) ).

fof(kb_SUMO_3437,axiom,
    s__documentation(s__CampZamaJapan,s__EnglishLanguage,'The &%City of &%CampZama in &%Japan.') ).

fof(kb_SUMO_3438,axiom,
    s__instance(s__CankiriTurkey,s__City) ).

fof(kb_SUMO_3439,axiom,
    s__documentation(s__CankiriTurkey,s__EnglishLanguage,'The &%City of &%Cankiri in &%Turkey.') ).

fof(kb_SUMO_3440,axiom,
    s__instance(s__CapeTownSouthAfrica,s__City) ).

fof(kb_SUMO_3441,axiom,
    s__documentation(s__CapeTownSouthAfrica,s__EnglishLanguage,'The &%City of &%CapeTown in &%SouthAfrica.') ).

fof(kb_SUMO_3442,axiom,
    s__instance(s__CarmelIsrael,s__City) ).

fof(kb_SUMO_3443,axiom,
    s__documentation(s__CarmelIsrael,s__EnglishLanguage,'The &%City of &%Carmel in &%Israel.') ).

fof(kb_SUMO_3444,axiom,
    s__instance(s__CarmenDeBolivarColombia,s__City) ).

fof(kb_SUMO_3445,axiom,
    s__documentation(s__CarmenDeBolivarColombia,s__EnglishLanguage,'The &%City of &%CarmenDeBolivar in &%Colombia.') ).

fof(kb_SUMO_3446,axiom,
    s__instance(s__CarrejonColombia,s__City) ).

fof(kb_SUMO_3447,axiom,
    s__documentation(s__CarrejonColombia,s__EnglishLanguage,'The &%City of &%Carrejon in &%Colombia.') ).

fof(kb_SUMO_3448,axiom,
    s__instance(s__ChamanPakistan,s__City) ).

fof(kb_SUMO_3449,axiom,
    s__documentation(s__ChamanPakistan,s__EnglishLanguage,'The &%City of &%Chaman in &%Pakistan.') ).

fof(kb_SUMO_3450,axiom,
    s__instance(s__ChararESharifIndia,s__City) ).

fof(kb_SUMO_3451,axiom,
    s__documentation(s__ChararESharifIndia,s__EnglishLanguage,'The &%City of &%ChararESharif in &%India.') ).

fof(kb_SUMO_3452,axiom,
    s__instance(s__CharsaadaPakistan,s__City) ).

fof(kb_SUMO_3453,axiom,
    s__documentation(s__CharsaadaPakistan,s__EnglishLanguage,'The &%City of &%Charsaada in &%Pakistan.') ).

fof(kb_SUMO_3454,axiom,
    s__instance(s__ChernoRechyeRussia,s__City) ).

fof(kb_SUMO_3455,axiom,
    s__documentation(s__ChernoRechyeRussia,s__EnglishLanguage,'The &%City of &%ChernoRechye in &%Russia.') ).

fof(kb_SUMO_3456,axiom,
    s__instance(s__ChicagoUnitedStates,s__AmericanCity) ).

fof(kb_SUMO_3457,axiom,
    s__part(s__ChicagoUnitedStates,s__Illinois) ).

fof(kb_SUMO_3458,axiom,
    s__documentation(s__ChicagoUnitedStates,s__EnglishLanguage,'Often referred to as the second city, &%ChicagoUnitedStates is the largest city in the midwestern United States.') ).

fof(kb_SUMO_3459,axiom,
    s__instance(s__ChisimayuSomalia,s__City) ).

fof(kb_SUMO_3460,axiom,
    s__documentation(s__ChisimayuSomalia,s__EnglishLanguage,'The &%City of &%Chisimayu in &%Somalia.') ).

fof(kb_SUMO_3461,axiom,
    s__instance(s__ChittagongBangladesh,s__City) ).

fof(kb_SUMO_3462,axiom,
    s__documentation(s__ChittagongBangladesh,s__EnglishLanguage,'The &%City of &%Chittagong in &%Bangladesh.') ).

fof(kb_SUMO_3463,axiom,
    s__instance(s__ChobaAngola,s__City) ).

fof(kb_SUMO_3464,axiom,
    s__documentation(s__ChobaAngola,s__EnglishLanguage,'The &%City of &%Choba in &%Angola.') ).

fof(kb_SUMO_3465,axiom,
    s__instance(s__ChocoColombia,s__City) ).

fof(kb_SUMO_3466,axiom,
    s__documentation(s__ChocoColombia,s__EnglishLanguage,'The &%City of &%Choco in &%Colombia.') ).

fof(kb_SUMO_3467,axiom,
    s__instance(s__ChorrosQueroVenezuela,s__City) ).

fof(kb_SUMO_3468,axiom,
    s__documentation(s__ChorrosQueroVenezuela,s__EnglishLanguage,'The &%City of &%ChorrosQuero in &%Venezuela.') ).

fof(kb_SUMO_3469,axiom,
    s__instance(s__CoimbatoreIndia,s__City) ).

fof(kb_SUMO_3470,axiom,
    s__documentation(s__CoimbatoreIndia,s__EnglishLanguage,'The &%City of &%Coimbatore in &%India.') ).

fof(kb_SUMO_3471,axiom,
    s__instance(s__CologneGermany,s__City) ).

fof(kb_SUMO_3472,axiom,
    s__documentation(s__CologneGermany,s__EnglishLanguage,'The &%City of &%Cologne in &%Germany.') ).

fof(kb_SUMO_3473,axiom,
    s__instance(s__ColombiaCityColombia,s__City) ).

fof(kb_SUMO_3474,axiom,
    s__documentation(s__ColombiaCityColombia,s__EnglishLanguage,'The &%City of &%ColombiaCity in &%Colombia.') ).

fof(kb_SUMO_3475,axiom,
    s__instance(s__ColombiaPanama,s__City) ).

fof(kb_SUMO_3476,axiom,
    s__documentation(s__ColombiaPanama,s__EnglishLanguage,'The &%City of &%Colombia in &%Panama.') ).

fof(kb_SUMO_3477,axiom,
    s__instance(s__ColomboSriLanka,s__City) ).

fof(kb_SUMO_3478,axiom,
    s__documentation(s__ColomboSriLanka,s__EnglishLanguage,'The &%City of &%Colombo in &%SriLanka.') ).

fof(kb_SUMO_3479,axiom,
    s__instance(s__ComayaguaHonduras,s__City) ).

fof(kb_SUMO_3480,axiom,
    s__documentation(s__ComayaguaHonduras,s__EnglishLanguage,'The &%City of &%Comayagua in &%Honduras.') ).

fof(kb_SUMO_3481,axiom,
    s__instance(s__CopacaBanaCuba,s__City) ).

fof(kb_SUMO_3482,axiom,
    s__documentation(s__CopacaBanaCuba,s__EnglishLanguage,'The &%City of &%CopacaBana in &%Cuba.') ).

fof(kb_SUMO_3483,axiom,
    s__instance(s__CorsicaFrance,s__City) ).

fof(kb_SUMO_3484,axiom,
    s__documentation(s__CorsicaFrance,s__EnglishLanguage,'The &%City of &%Corsica in &%France.') ).

fof(kb_SUMO_3485,axiom,
    s__instance(s__CorteFrance,s__City) ).

fof(kb_SUMO_3486,axiom,
    s__documentation(s__CorteFrance,s__EnglishLanguage,'The &%City of &%Corte in &%France.') ).

fof(kb_SUMO_3487,axiom,
    s__instance(s__CorumTurkey,s__City) ).

fof(kb_SUMO_3488,axiom,
    s__documentation(s__CorumTurkey,s__EnglishLanguage,'The &%City of &%Corum in &%Turkey.') ).

fof(kb_SUMO_3489,axiom,
    s__instance(s__CundiNamarcaColombia,s__City) ).

fof(kb_SUMO_3490,axiom,
    s__documentation(s__CundiNamarcaColombia,s__EnglishLanguage,'The &%City of &%CundiNamarca in &%Colombia.') ).

fof(kb_SUMO_3491,axiom,
    s__instance(s__CupiaguaColombia,s__City) ).

fof(kb_SUMO_3492,axiom,
    s__documentation(s__CupiaguaColombia,s__EnglishLanguage,'The &%City of &%Cupiagua in &%Colombia.') ).

fof(kb_SUMO_3493,axiom,
    s__instance(s__CuzcoPeru,s__City) ).

fof(kb_SUMO_3494,axiom,
    s__documentation(s__CuzcoPeru,s__EnglishLanguage,'The &%City of &%Cuzco in &%Peru.') ).

fof(kb_SUMO_3495,axiom,
    s__instance(s__DagestanRussia,s__City) ).

fof(kb_SUMO_3496,axiom,
    s__documentation(s__DagestanRussia,s__EnglishLanguage,'The &%City of &%Dagestan in &%Russia.') ).

fof(kb_SUMO_3497,axiom,
    s__instance(s__DahukIraq,s__City) ).

fof(kb_SUMO_3498,axiom,
    s__documentation(s__DahukIraq,s__EnglishLanguage,'The &%City of &%Dahuk in &%Iraq.') ).

fof(kb_SUMO_3499,axiom,
    s__instance(s__DarEsSalaAmTanzania,s__City) ).

fof(kb_SUMO_3500,axiom,
    s__documentation(s__DarEsSalaAmTanzania,s__EnglishLanguage,'The &%City of &%DarEsSalaAm in &%Tanzania.') ).

fof(kb_SUMO_3501,axiom,
    s__instance(s__DarvazTajikistan,s__City) ).

fof(kb_SUMO_3502,axiom,
    s__documentation(s__DarvazTajikistan,s__EnglishLanguage,'The &%City of &%Darvaz in &%Tajikistan.') ).

fof(kb_SUMO_3503,axiom,
    s__instance(s__DebaSpain,s__City) ).

fof(kb_SUMO_3504,axiom,
    s__documentation(s__DebaSpain,s__EnglishLanguage,'The &%City of &%Deba in &%Spain.') ).

fof(kb_SUMO_3505,axiom,
    s__instance(s__DelhiIndia,s__City) ).

fof(kb_SUMO_3506,axiom,
    s__documentation(s__DelhiIndia,s__EnglishLanguage,'The &%City of &%Delhi in &%India.') ).

fof(kb_SUMO_3507,axiom,
    s__instance(s__DhahranSaudiArabia,s__City) ).

fof(kb_SUMO_3508,axiom,
    s__documentation(s__DhahranSaudiArabia,s__EnglishLanguage,'The &%City of &%Dhahran in &%SaudiArabia.') ).

fof(kb_SUMO_3509,axiom,
    s__instance(s__DhakaBangladesh,s__City) ).

fof(kb_SUMO_3510,axiom,
    s__documentation(s__DhakaBangladesh,s__EnglishLanguage,'The &%City of &%Dhaka in &%Bangladesh.') ).

fof(kb_SUMO_3511,axiom,
    s__instance(s__DinanFrance,s__City) ).

fof(kb_SUMO_3512,axiom,
    s__documentation(s__DinanFrance,s__EnglishLanguage,'The &%City of &%Dinan in &%France.') ).

fof(kb_SUMO_3513,axiom,
    s__instance(s__DirNaballahWestBank,s__City) ).

fof(kb_SUMO_3514,axiom,
    s__documentation(s__DirNaballahWestBank,s__EnglishLanguage,'The &%City of &%DirNaballah in &%WestBank.') ).

fof(kb_SUMO_3515,axiom,
    s__instance(s__DireDawaEthiopia,s__City) ).

fof(kb_SUMO_3516,axiom,
    s__documentation(s__DireDawaEthiopia,s__EnglishLanguage,'The &%City of &%DireDawa in &%Ethiopia.') ).

fof(kb_SUMO_3517,axiom,
    s__instance(s__DjerbaTunisia,s__City) ).

fof(kb_SUMO_3518,axiom,
    s__documentation(s__DjerbaTunisia,s__EnglishLanguage,'The &%City of &%Djerba in &%Tunisia.') ).

fof(kb_SUMO_3519,axiom,
    s__instance(s__DjakashariGeorgia,s__City) ).

fof(kb_SUMO_3520,axiom,
    s__documentation(s__DjakashariGeorgia,s__EnglishLanguage,'The &%City of &%Djakashari in &%RepublicOfGeorgia.') ).

fof(kb_SUMO_3521,axiom,
    s__instance(s__DodaIndia,s__City) ).

fof(kb_SUMO_3522,axiom,
    s__documentation(s__DodaIndia,s__EnglishLanguage,'The &%City of &%Doda in &%India.') ).

fof(kb_SUMO_3523,axiom,
    s__instance(s__DortmundGermany,s__City) ).

fof(kb_SUMO_3524,axiom,
    s__documentation(s__DortmundGermany,s__EnglishLanguage,'The &%City of &%Dortmund in &%Germany.') ).

fof(kb_SUMO_3525,axiom,
    s__instance(s__DublinIreland,s__City) ).

fof(kb_SUMO_3526,axiom,
    s__documentation(s__DublinIreland,s__EnglishLanguage,'The &%City of &%Dublin in &%Ireland.') ).

fof(kb_SUMO_3527,axiom,
    s__instance(s__DuesseldorfGermany,s__City) ).

fof(kb_SUMO_3528,axiom,
    s__documentation(s__DuesseldorfGermany,s__EnglishLanguage,'The &%City of &%Duesseldorf in &%Germany.') ).

fof(kb_SUMO_3529,axiom,
    s__instance(s__DugitGazaStrip,s__City) ).

fof(kb_SUMO_3530,axiom,
    s__documentation(s__DugitGazaStrip,s__EnglishLanguage,'The &%City of &%Dugit in &%GazaStrip.') ).

fof(kb_SUMO_3531,axiom,
    s__instance(s__DurangoSpain,s__City) ).

fof(kb_SUMO_3532,axiom,
    s__documentation(s__DurangoSpain,s__EnglishLanguage,'The &%City of &%Durango in &%Spain.') ).

fof(kb_SUMO_3533,axiom,
    s__instance(s__DushanbeTajikistan,s__City) ).

fof(kb_SUMO_3534,axiom,
    s__documentation(s__DushanbeTajikistan,s__EnglishLanguage,'The &%City of &%Dushanbe in &%Tajikistan.') ).

fof(kb_SUMO_3535,axiom,
    s__instance(s__DushanbeGarmTajikistan,s__City) ).

fof(kb_SUMO_3536,axiom,
    s__documentation(s__DushanbeGarmTajikistan,s__EnglishLanguage,'The &%City of &%DushanbeGarm in &%Tajikistan.') ).

fof(kb_SUMO_3537,axiom,
    s__instance(s__EastJerusalemIsrael,s__City) ).

fof(kb_SUMO_3538,axiom,
    s__documentation(s__EastJerusalemIsrael,s__EnglishLanguage,'The &%City of &%EastJerusalem in &%Israel.') ).

fof(kb_SUMO_3539,axiom,
    s__instance(s__EfratWestBank,s__City) ).

fof(kb_SUMO_3540,axiom,
    s__documentation(s__EfratWestBank,s__EnglishLanguage,'The &%City of &%Efrat in &%WestBank.') ).

fof(kb_SUMO_3541,axiom,
    s__instance(s__EilatIsrael,s__City) ).

fof(kb_SUMO_3542,axiom,
    s__documentation(s__EilatIsrael,s__EnglishLanguage,'The &%City of &%Eilat in &%Israel.') ).

fof(kb_SUMO_3543,axiom,
    s__instance(s__EinavWestBank,s__City) ).

fof(kb_SUMO_3544,axiom,
    s__documentation(s__EinavWestBank,s__EnglishLanguage,'The &%City of &%Einav in &%WestBank.') ).

fof(kb_SUMO_3545,axiom,
    s__instance(s__ElBagreColombia,s__City) ).

fof(kb_SUMO_3546,axiom,
    s__documentation(s__ElBagreColombia,s__EnglishLanguage,'The &%City of &%ElBagre in &%Colombia.') ).

fof(kb_SUMO_3547,axiom,
    s__instance(s__ElBirehWestBank,s__City) ).

fof(kb_SUMO_3548,axiom,
    s__documentation(s__ElBirehWestBank,s__EnglishLanguage,'The &%City of &%ElBireh in &%WestBank.') ).

fof(kb_SUMO_3549,axiom,
    s__instance(s__ElPlayonColombia,s__City) ).

fof(kb_SUMO_3550,axiom,
    s__documentation(s__ElPlayonColombia,s__EnglishLanguage,'The &%City of &%ElPlayon in &%Colombia.') ).

fof(kb_SUMO_3551,axiom,
    s__instance(s__ElRipialApureVenezuela,s__City) ).

fof(kb_SUMO_3552,axiom,
    s__documentation(s__ElRipialApureVenezuela,s__EnglishLanguage,'The &%City of &%ElRipialApure in &%Venezuela.') ).

fof(kb_SUMO_3553,axiom,
    s__instance(s__ElAzzariyaWestBank,s__City) ).

fof(kb_SUMO_3554,axiom,
    s__documentation(s__ElAzzariyaWestBank,s__EnglishLanguage,'The &%City of &%ElAzzariya in the &%WestBank.') ).

fof(kb_SUMO_3555,axiom,
    s__instance(s__ElayoSomalia,s__City) ).

fof(kb_SUMO_3556,axiom,
    s__documentation(s__ElayoSomalia,s__EnglishLanguage,'The &%City of &%Elayo in &%Somalia.') ).

fof(kb_SUMO_3557,axiom,
    s__instance(s__EleiSinaiGazaStrip,s__City) ).

fof(kb_SUMO_3558,axiom,
    s__documentation(s__EleiSinaiGazaStrip,s__EnglishLanguage,'The &%City of &%EleiSinai in &%GazaStrip.') ).

fof(kb_SUMO_3559,axiom,
    s__instance(s__EmmanuelWestBank,s__City) ).

fof(kb_SUMO_3560,axiom,
    s__documentation(s__EmmanuelWestBank,s__EnglishLanguage,'The &%City of &%Emmanuel in &%WestBank.') ).

fof(kb_SUMO_3561,axiom,
    s__instance(s__ErezGazaStrip,s__City) ).

fof(kb_SUMO_3562,axiom,
    s__documentation(s__ErezGazaStrip,s__EnglishLanguage,'The &%City of &%Erez in &%GazaStrip.') ).

fof(kb_SUMO_3563,axiom,
    s__instance(s__FormequeColombia,s__City) ).

fof(kb_SUMO_3564,axiom,
    s__documentation(s__FormequeColombia,s__EnglishLanguage,'The &%City of &%Formeque in &%Colombia.') ).

fof(kb_SUMO_3565,axiom,
    s__instance(s__FrankfurtGermany,s__City) ).

fof(kb_SUMO_3566,axiom,
    s__documentation(s__FrankfurtGermany,s__EnglishLanguage,'The &%City of &%Frankfurt in &%Germany.') ).

fof(kb_SUMO_3567,axiom,
    s__instance(s__FrenchHillIsrael,s__City) ).

fof(kb_SUMO_3568,axiom,
    s__documentation(s__FrenchHillIsrael,s__EnglishLanguage,'The &%City of &%FrenchHill in &%Israel.') ).

fof(kb_SUMO_3569,axiom,
    s__instance(s__FuengirolaSpain,s__City) ).

fof(kb_SUMO_3570,axiom,
    s__documentation(s__FuengirolaSpain,s__EnglishLanguage,'The &%City of &%Fuengirola in &%Spain.') ).

fof(kb_SUMO_3571,axiom,
    s__instance(s__FusagasusaColombia,s__City) ).

fof(kb_SUMO_3572,axiom,
    s__documentation(s__FusagasusaColombia,s__EnglishLanguage,'The &%City of &%Fusagasusa in &%Colombia.') ).

fof(kb_SUMO_3573,axiom,
    s__instance(s__GaliAbkhaziaGeorgia,s__City) ).

fof(kb_SUMO_3574,axiom,
    s__documentation(s__GaliAbkhaziaGeorgia,s__EnglishLanguage,'The &%City of &%GaliAbkhazia in &%RepublicOfGeorgia.') ).

fof(kb_SUMO_3575,axiom,
    s__instance(s__GanimWestBank,s__City) ).

fof(kb_SUMO_3576,axiom,
    s__documentation(s__GanimWestBank,s__EnglishLanguage,'The &%City of &%Ganim in &%WestBank.') ).

fof(kb_SUMO_3577,axiom,
    s__instance(s__GashuriIsrael,s__City) ).

fof(kb_SUMO_3578,axiom,
    s__documentation(s__GashuriIsrael,s__EnglishLanguage,'The &%City of &%Gashuri in &%Israel.') ).

fof(kb_SUMO_3579,axiom,
    s__instance(s__GeneralSantosPhilippines,s__City) ).

fof(kb_SUMO_3580,axiom,
    s__documentation(s__GeneralSantosPhilippines,s__EnglishLanguage,'The &%City of &%GeneralSantos in &%Philippines.') ).

fof(kb_SUMO_3581,axiom,
    s__instance(s__GenevaSwitzerland,s__City) ).

fof(kb_SUMO_3582,axiom,
    s__documentation(s__GenevaSwitzerland,s__EnglishLanguage,'The &%City of &%Geneva in &%Switzerland.') ).

fof(kb_SUMO_3583,axiom,
    s__instance(s__GetxoSpain,s__City) ).

fof(kb_SUMO_3584,axiom,
    s__documentation(s__GetxoSpain,s__EnglishLanguage,'The &%City of &%Getxo in &%Spain.') ).

fof(kb_SUMO_3585,axiom,
    s__instance(s__GhalebiehIraq,s__City) ).

fof(kb_SUMO_3586,axiom,
    s__documentation(s__GhalebiehIraq,s__EnglishLanguage,'The &%City of &%Ghalebieh in &%Iraq.') ).

fof(kb_SUMO_3587,axiom,
    s__instance(s__GhaziabadIndia,s__City) ).

fof(kb_SUMO_3588,axiom,
    s__documentation(s__GhaziabadIndia,s__EnglishLanguage,'The &%City of &%Ghaziabad in &%India.') ).

fof(kb_SUMO_3589,axiom,
    s__instance(s__GiloIsrael,s__City) ).

fof(kb_SUMO_3590,axiom,
    s__documentation(s__GiloIsrael,s__EnglishLanguage,'The &%City of &%Gilo in &%Israel.') ).

fof(kb_SUMO_3591,axiom,
    s__instance(s__GivatZeEvWestBank,s__City) ).

fof(kb_SUMO_3592,axiom,
    s__documentation(s__GivatZeEvWestBank,s__EnglishLanguage,'The &%City of &%GivatZeEv in &%WestBank.') ).

fof(kb_SUMO_3593,axiom,
    s__instance(s__GizaEgypt,s__City) ).

fof(kb_SUMO_3594,axiom,
    s__documentation(s__GizaEgypt,s__EnglishLanguage,'The &%City of &%Giza in &%Egypt.') ).

fof(kb_SUMO_3595,axiom,
    s__instance(s__GonegalleSriLanka,s__City) ).

fof(kb_SUMO_3596,axiom,
    s__documentation(s__GonegalleSriLanka,s__EnglishLanguage,'The &%City of &%Gonegalle in &%SriLanka.') ).

fof(kb_SUMO_3597,axiom,
    s__instance(s__GranadaSpain,s__City) ).

fof(kb_SUMO_3598,axiom,
    s__documentation(s__GranadaSpain,s__EnglishLanguage,'The &%City of &%Granada in &%Spain.') ).

fof(kb_SUMO_3599,axiom,
    s__instance(s__GrazAustria,s__City) ).

fof(kb_SUMO_3600,axiom,
    s__documentation(s__GrazAustria,s__EnglishLanguage,'The &%City of &%Graz in &%Austria.') ).

fof(kb_SUMO_3601,axiom,
    s__instance(s__GroznyChechnya,s__City) ).

fof(kb_SUMO_3602,axiom,
    s__documentation(s__GroznyChechnya,s__EnglishLanguage,'The &%City of &%Grozny in &%Chechnya.') ).

fof(kb_SUMO_3603,axiom,
    s__instance(s__GuilinChina,s__City) ).

fof(kb_SUMO_3604,axiom,
    s__documentation(s__GuilinChina,s__EnglishLanguage,'The &%City of &%Guilin in &%China.') ).

fof(kb_SUMO_3605,axiom,
    s__instance(s__GujaratIndia,s__City) ).

fof(kb_SUMO_3606,axiom,
    s__documentation(s__GujaratIndia,s__EnglishLanguage,'The &%City of &%Gujarat in &%India.') ).

fof(kb_SUMO_3607,axiom,
    s__instance(s__GushEtzionWestBank,s__City) ).

fof(kb_SUMO_3608,axiom,
    s__documentation(s__GushEtzionWestBank,s__EnglishLanguage,'The &%City of &%GushEtzion in &%WestBank.') ).

fof(kb_SUMO_3609,axiom,
    s__instance(s__GushKhatifGazaStrip,s__City) ).

fof(kb_SUMO_3610,axiom,
    s__documentation(s__GushKhatifGazaStrip,s__EnglishLanguage,'The &%City of &%GushKhatif in &%GazaStrip.') ).

fof(kb_SUMO_3611,axiom,
    s__instance(s__HaderaIsrael,s__City) ).

fof(kb_SUMO_3612,axiom,
    s__documentation(s__HaderaIsrael,s__EnglishLanguage,'The &%City of &%Hadera in &%Israel.') ).

fof(kb_SUMO_3613,axiom,
    s__instance(s__HaifaIsrael,s__PortCity) ).

fof(kb_SUMO_3614,axiom,
    s__instance(s__PortCity__t,s__SetOrClass) ).

fof(kb_SUMO_3615,axiom,
    s__documentation(s__HaifaIsrael,s__EnglishLanguage,'The &%City of &%Haifa in &%Israel.') ).

fof(kb_SUMO_3616,axiom,
    s__instance(s__HamburgGermany,s__City) ).

fof(kb_SUMO_3617,axiom,
    s__documentation(s__HamburgGermany,s__EnglishLanguage,'The &%City of &%Hamburg in &%Germany.') ).

fof(kb_SUMO_3618,axiom,
    s__instance(s__HamisMiliyanaAlgeria,s__City) ).

fof(kb_SUMO_3619,axiom,
    s__documentation(s__HamisMiliyanaAlgeria,s__EnglishLanguage,'The &%City of &%HamisMiliyana in &%Algeria.') ).

fof(kb_SUMO_3620,axiom,
    s__instance(s__HamraWestBank,s__City) ).

fof(kb_SUMO_3621,axiom,
    s__documentation(s__HamraWestBank,s__EnglishLanguage,'The &%City of &%Hamra in &%WestBank.') ).

fof(kb_SUMO_3622,axiom,
    s__instance(s__HannoverGermany,s__PortCity) ).

fof(kb_SUMO_3623,axiom,
    s__documentation(s__HannoverGermany,s__EnglishLanguage,'The &%City of &%Hannover in &%Germany.') ).

fof(kb_SUMO_3624,axiom,
    s__instance(s__HarBrachaWestBank,s__City) ).

fof(kb_SUMO_3625,axiom,
    s__documentation(s__HarBrachaWestBank,s__EnglishLanguage,'The &%City of &%HarBracha in &%WestBank.') ).

fof(kb_SUMO_3626,axiom,
    s__instance(s__HarerEthiopia,s__City) ).

fof(kb_SUMO_3627,axiom,
    s__documentation(s__HarerEthiopia,s__EnglishLanguage,'The &%City of &%Harer in &%Ethiopia.') ).

fof(kb_SUMO_3628,axiom,
    s__instance(s__HavanaCuba,s__City) ).

fof(kb_SUMO_3629,axiom,
    s__documentation(s__HavanaCuba,s__EnglishLanguage,'The &%City of &%Havana in &%Cuba.') ).

fof(kb_SUMO_3630,axiom,
    s__instance(s__HawanaIraq,s__City) ).

fof(kb_SUMO_3631,axiom,
    s__documentation(s__HawanaIraq,s__EnglishLanguage,'The &%City of &%Hawana in &%Iraq.') ).

fof(kb_SUMO_3632,axiom,
    s__instance(s__HeartAfghanistan,s__City) ).

fof(kb_SUMO_3633,axiom,
    s__documentation(s__HeartAfghanistan,s__EnglishLanguage,'The &%City of &%Heart in &%Afghanistan.') ).

fof(kb_SUMO_3634,axiom,
    s__instance(s__HebronWestBank,s__City) ).

fof(kb_SUMO_3635,axiom,
    s__documentation(s__HebronWestBank,s__EnglishLanguage,'The &%City of &%Hebron in &%WestBank.') ).

fof(kb_SUMO_3636,axiom,
    s__instance(s__HermeshIsrael,s__City) ).

fof(kb_SUMO_3637,axiom,
    s__documentation(s__HermeshIsrael,s__EnglishLanguage,'The &%City of &%Hermesh in &%Israel.') ).

fof(kb_SUMO_3638,axiom,
    s__instance(s__HernaniSpain,s__City) ).

fof(kb_SUMO_3639,axiom,
    s__documentation(s__HernaniSpain,s__EnglishLanguage,'The &%City of &%Hernani in &%Spain.') ).

fof(kb_SUMO_3640,axiom,
    s__instance(s__HerzliyaIsrael,s__City) ).

fof(kb_SUMO_3641,axiom,
    s__documentation(s__HerzliyaIsrael,s__EnglishLanguage,'The &%City of &%Herzliya in &%Israel.') ).

fof(kb_SUMO_3642,axiom,
    s__instance(s__HilversumNetherlands,s__City) ).

fof(kb_SUMO_3643,axiom,
    s__documentation(s__HilversumNetherlands,s__EnglishLanguage,'The &%City of &%Hilversum in &%Netherlands.') ).

fof(kb_SUMO_3644,axiom,
    s__instance(s__HizmaWestBank,s__City) ).

fof(kb_SUMO_3645,axiom,
    s__documentation(s__HizmaWestBank,s__EnglishLanguage,'The &%City of &%Hizma in &%WestBank.') ).

fof(kb_SUMO_3646,axiom,
    s__instance(s__HuallgaPeru,s__City) ).

fof(kb_SUMO_3647,axiom,
    s__documentation(s__HuallgaPeru,s__EnglishLanguage,'The &%City of &%Huallga in &%Peru.') ).

fof(kb_SUMO_3648,axiom,
    s__instance(s__HurghadaEgypt,s__City) ).

fof(kb_SUMO_3649,axiom,
    s__documentation(s__HurghadaEgypt,s__EnglishLanguage,'The &%City of &%Hurghada in &%Egypt.') ).

fof(kb_SUMO_3650,axiom,
    s__instance(s__HyderabadIndia,s__City) ).

fof(kb_SUMO_3651,axiom,
    s__documentation(s__HyderabadIndia,s__EnglishLanguage,'The &%City of &%Hyderabad in &%India.') ).

fof(kb_SUMO_3652,axiom,
    s__instance(s__IbsrilIraq,s__City) ).

fof(kb_SUMO_3653,axiom,
    s__documentation(s__IbsrilIraq,s__EnglishLanguage,'The &%City of &%Ibsril in &%Iraq.') ).

fof(kb_SUMO_3654,axiom,
    s__instance(s__IpilPhilippines,s__City) ).

fof(kb_SUMO_3655,axiom,
    s__documentation(s__IpilPhilippines,s__EnglishLanguage,'The &%City of &%Ipil in &%Philippines.') ).

fof(kb_SUMO_3656,axiom,
    s__instance(s__IrbilIraq,s__City) ).

fof(kb_SUMO_3657,axiom,
    s__documentation(s__IrbilIraq,s__EnglishLanguage,'The &%City of &%Irbil in &%Iraq.') ).

fof(kb_SUMO_3658,axiom,
    s__instance(s__IslamabadPakistan,s__City) ).

fof(kb_SUMO_3659,axiom,
    s__documentation(s__IslamabadPakistan,s__EnglishLanguage,'The &%City of &%Islamabad in &%Pakistan.') ).

fof(kb_SUMO_3660,axiom,
    s__instance(s__IstanbulTurkey,s__City) ).

fof(kb_SUMO_3661,axiom,
    s__documentation(s__IstanbulTurkey,s__EnglishLanguage,'The &%City of &%Istanbul in &%Turkey.') ).

fof(kb_SUMO_3662,axiom,
    s__instance(s__ItamarWestBank,s__City) ).

fof(kb_SUMO_3663,axiom,
    s__documentation(s__ItamarWestBank,s__EnglishLanguage,'The &%City of &%Itamar in &%WestBank.') ).

fof(kb_SUMO_3664,axiom,
    s__instance(s__IzmirTurkey,s__City) ).

fof(kb_SUMO_3665,axiom,
    s__documentation(s__IzmirTurkey,s__EnglishLanguage,'The &%City of &%Izmir in &%Turkey.') ).

fof(kb_SUMO_3666,axiom,
    s__instance(s__JMainWestBank,s__City) ).

fof(kb_SUMO_3667,axiom,
    s__documentation(s__JMainWestBank,s__EnglishLanguage,'The &%City of &%JMain in &%WestBank.') ).

fof(kb_SUMO_3668,axiom,
    s__instance(s__JaffaIsrael,s__City) ).

fof(kb_SUMO_3669,axiom,
    s__documentation(s__JaffaIsrael,s__EnglishLanguage,'The &%City of &%Jaffa in &%Israel.') ).

fof(kb_SUMO_3670,axiom,
    s__instance(s__JaffnaSriLanka,s__City) ).

fof(kb_SUMO_3671,axiom,
    s__documentation(s__JaffnaSriLanka,s__EnglishLanguage,'The &%City of &%Jaffna in &%SriLanka.') ).

fof(kb_SUMO_3672,axiom,
    s__instance(s__JakartaIndonesia,s__City) ).

fof(kb_SUMO_3673,axiom,
    s__documentation(s__JakartaIndonesia,s__EnglishLanguage,'The &%City of &%Jakarta in &%Indonesia.') ).

fof(kb_SUMO_3674,axiom,
    s__instance(s__JalahIndia,s__City) ).

fof(kb_SUMO_3675,axiom,
    s__documentation(s__JalahIndia,s__EnglishLanguage,'The &%City of &%Jalah in &%India.') ).

fof(kb_SUMO_3676,axiom,
    s__instance(s__JammuIndia,s__City) ).

fof(kb_SUMO_3677,axiom,
    s__documentation(s__JammuIndia,s__EnglishLanguage,'The &%City of &%Jammu in &%India.') ).

fof(kb_SUMO_3678,axiom,
    s__instance(s__JangasPeru,s__City) ).

fof(kb_SUMO_3679,axiom,
    s__documentation(s__JangasPeru,s__EnglishLanguage,'The &%City of &%Jangas in &%Peru.') ).

fof(kb_SUMO_3680,axiom,
    s__instance(s__JeninWestBank,s__City) ).

fof(kb_SUMO_3681,axiom,
    s__documentation(s__JeninWestBank,s__EnglishLanguage,'The &%City of &%Jenin in &%WestBank.') ).

fof(kb_SUMO_3682,axiom,
    s__instance(s__JerusalemIsrael,s__City) ).

fof(kb_SUMO_3683,axiom,
    s__capitalCity(s__JerusalemIsrael,s__Israel) ).

fof(kb_SUMO_3684,axiom,
    s__documentation(s__JerusalemIsrael,s__EnglishLanguage,'The capital and largest City in Israel. It is regarded as a holy city by Muslims, Jews, and Christians.') ).

fof(kb_SUMO_3685,axiom,
    s__instance(s__JerusalemHillsIsrael,s__City) ).

fof(kb_SUMO_3686,axiom,
    s__documentation(s__JerusalemHillsIsrael,s__EnglishLanguage,'The &%City of &%JerusalemHills in &%Israel.') ).

fof(kb_SUMO_3687,axiom,
    s__instance(s__JerusalemOldCityIsrael,s__City) ).

fof(kb_SUMO_3688,axiom,
    s__documentation(s__JerusalemOldCityIsrael,s__EnglishLanguage,'The &%City of &%JerusalemOldCity in &%Israel.') ).

fof(kb_SUMO_3689,axiom,
    s__instance(s__JohannesburgSouthAfrica,s__City) ).

fof(kb_SUMO_3690,axiom,
    s__documentation(s__JohannesburgSouthAfrica,s__EnglishLanguage,'The &%City of &%Johannesburg in &%SouthAfrica.') ).

fof(kb_SUMO_3691,axiom,
    s__instance(s__JoloPhilippines,s__City) ).

fof(kb_SUMO_3692,axiom,
    s__documentation(s__JoloPhilippines,s__EnglishLanguage,'The &%City of &%Jolo in &%Philippines.') ).

fof(kb_SUMO_3693,axiom,
    s__instance(s__JubialSaudiArabia,s__City) ).

fof(kb_SUMO_3694,axiom,
    s__documentation(s__JubialSaudiArabia,s__EnglishLanguage,'The &%City of &%Jubial in &%SaudiArabia.') ).

fof(kb_SUMO_3695,axiom,
    s__instance(s__JullundurIndia,s__City) ).

fof(kb_SUMO_3696,axiom,
    s__documentation(s__JullundurIndia,s__EnglishLanguage,'The &%City of &%Jullundur in &%India.') ).

fof(kb_SUMO_3697,axiom,
    s__instance(s__KabacanPhilippines,s__City) ).

fof(kb_SUMO_3698,axiom,
    s__documentation(s__KabacanPhilippines,s__EnglishLanguage,'The &%City of &%Kabacan in &%Philippines.') ).

fof(kb_SUMO_3699,axiom,
    s__instance(s__KabulAfghanistan,s__City) ).

fof(kb_SUMO_3700,axiom,
    s__documentation(s__KabulAfghanistan,s__EnglishLanguage,'The &%City of &%Kabul in &%Afghanistan.') ).

fof(kb_SUMO_3701,axiom,
    s__instance(s__KafrAkabWestBank,s__City) ).

fof(kb_SUMO_3702,axiom,
    s__documentation(s__KafrAkabWestBank,s__EnglishLanguage,'The &%City of &%KafrAkab in &%WestBank.') ).

fof(kb_SUMO_3703,axiom,
    s__instance(s__KafrIdnaWestBank,s__City) ).

fof(kb_SUMO_3704,axiom,
    s__documentation(s__KafrIdnaWestBank,s__EnglishLanguage,'The &%City of &%KafrIdna in &%WestBank.') ).

fof(kb_SUMO_3705,axiom,
    s__instance(s__KalkilyaWestBank,s__City) ).

fof(kb_SUMO_3706,axiom,
    s__documentation(s__KalkilyaWestBank,s__EnglishLanguage,'The &%City of &%Kalkilya in &%WestBank.') ).

fof(kb_SUMO_3707,axiom,
    s__instance(s__KalmunaiSriLanka,s__City) ).

fof(kb_SUMO_3708,axiom,
    s__documentation(s__KalmunaiSriLanka,s__EnglishLanguage,'The &%City of &%Kalmunai in &%SriLanka.') ).

fof(kb_SUMO_3709,axiom,
    s__instance(s__KampalaUganda,s__City) ).

fof(kb_SUMO_3710,axiom,
    s__documentation(s__KampalaUganda,s__EnglishLanguage,'The &%City of &%Kampala in &%Uganda.') ).

fof(kb_SUMO_3711,axiom,
    s__instance(s__KandySriLanka,s__City) ).

fof(kb_SUMO_3712,axiom,
    s__documentation(s__KandySriLanka,s__EnglishLanguage,'The &%City of &%Kandy in &%SriLanka.') ).

fof(kb_SUMO_3713,axiom,
    s__instance(s__KanihamaIndia,s__City) ).

fof(kb_SUMO_3714,axiom,
    s__documentation(s__KanihamaIndia,s__EnglishLanguage,'The &%City of &%Kanihama in &%India.') ).

fof(kb_SUMO_3715,axiom,
    s__instance(s__KarachiPakistan,s__City) ).

fof(kb_SUMO_3716,axiom,
    s__documentation(s__KarachiPakistan,s__EnglishLanguage,'The &%City of &%Karachi in &%Pakistan.') ).

fof(kb_SUMO_3717,axiom,
    s__instance(s__KarkurIsrael,s__City) ).

fof(kb_SUMO_3718,axiom,
    s__documentation(s__KarkurIsrael,s__EnglishLanguage,'The &%City of &%Karkur in &%Israel.') ).

fof(kb_SUMO_3719,axiom,
    s__instance(s__KarmeiTzurWestBank,s__City) ).

fof(kb_SUMO_3720,axiom,
    s__documentation(s__KarmeiTzurWestBank,s__EnglishLanguage,'The &%City of &%KarmeiTzur in &%WestBank.') ).

fof(kb_SUMO_3721,axiom,
    s__instance(s__KarneiShomronWestBank,s__City) ).

fof(kb_SUMO_3722,axiom,
    s__documentation(s__KarneiShomronWestBank,s__EnglishLanguage,'The &%City of &%KarneiShomron in &%WestBank.') ).

fof(kb_SUMO_3723,axiom,
    s__instance(s__KashmirIndia,s__City) ).

fof(kb_SUMO_3724,axiom,
    s__documentation(s__KashmirIndia,s__EnglishLanguage,'The &%City of &%Kashmir in &%India.') ).

fof(kb_SUMO_3725,axiom,
    s__instance(s__KedumimWestBank,s__City) ).

fof(kb_SUMO_3726,axiom,
    s__documentation(s__KedumimWestBank,s__EnglishLanguage,'The &%City of &%Kedumim in &%WestBank.') ).

fof(kb_SUMO_3727,axiom,
    s__instance(s__KfarBaAnehIsrael,s__City) ).

fof(kb_SUMO_3728,axiom,
    s__documentation(s__KfarBaAnehIsrael,s__EnglishLanguage,'The &%City of &%KfarBaAneh in &%Israel.') ).

fof(kb_SUMO_3729,axiom,
    s__instance(s__KfarDaromGazaStrip,s__City) ).

fof(kb_SUMO_3730,axiom,
    s__documentation(s__KfarDaromGazaStrip,s__EnglishLanguage,'The &%City of &%KfarDarom in &%GazaStrip.') ).

fof(kb_SUMO_3731,axiom,
    s__instance(s__KfarHessIsrael,s__City) ).

fof(kb_SUMO_3732,axiom,
    s__documentation(s__KfarHessIsrael,s__EnglishLanguage,'The &%City of &%KfarHess in &%Israel.') ).

fof(kb_SUMO_3733,axiom,
    s__instance(s__KfarSabaIsrael,s__City) ).

fof(kb_SUMO_3734,axiom,
    s__documentation(s__KfarSabaIsrael,s__EnglishLanguage,'The &%City of &%KfarSaba in &%Israel.') ).

fof(kb_SUMO_3735,axiom,
    s__instance(s__KfarTzurifWestBank,s__City) ).

fof(kb_SUMO_3736,axiom,
    s__documentation(s__KfarTzurifWestBank,s__EnglishLanguage,'The &%City of &%KfarTzurif in &%WestBank.') ).

fof(kb_SUMO_3737,axiom,
    s__instance(s__KfarYamGazaStrip,s__City) ).

fof(kb_SUMO_3738,axiom,
    s__documentation(s__KfarYamGazaStrip,s__EnglishLanguage,'The &%City of &%KfarYam in &%GazaStrip.') ).

fof(kb_SUMO_3739,axiom,
    s__instance(s__KfarDaromNetzarimIsrael,s__City) ).

fof(kb_SUMO_3740,axiom,
    s__documentation(s__KfarDaromNetzarimIsrael,s__EnglishLanguage,'The &%City of &%KfarDaromNetzarim in &%Israel.') ).

fof(kb_SUMO_3741,axiom,
    s__instance(s__KhankalaChechnya,s__City) ).

fof(kb_SUMO_3742,axiom,
    s__documentation(s__KhankalaChechnya,s__EnglishLanguage,'The &%City of &%Khankala in &%Chechnya.') ).

fof(kb_SUMO_3743,axiom,
    s__instance(s__KhartoumSudan,s__City) ).

fof(kb_SUMO_3744,axiom,
    s__documentation(s__KhartoumSudan,s__EnglishLanguage,'The &%City of &%Khartoum in &%Sudan.') ).

fof(kb_SUMO_3745,axiom,
    s__instance(s__KhelilAlgeria,s__City) ).

fof(kb_SUMO_3746,axiom,
    s__documentation(s__KhelilAlgeria,s__EnglishLanguage,'The &%City of &%Khelil in &%Algeria.') ).

fof(kb_SUMO_3747,axiom,
    s__instance(s__KhobarSaudiArabia,s__City) ).

fof(kb_SUMO_3748,axiom,
    s__documentation(s__KhobarSaudiArabia,s__EnglishLanguage,'The &%City of &%Khobar in &%SaudiArabia.') ).

fof(kb_SUMO_3749,axiom,
    s__instance(s__KibbutzGalEdIsrael,s__City) ).

fof(kb_SUMO_3750,axiom,
    s__documentation(s__KibbutzGalEdIsrael,s__EnglishLanguage,'The &%City of &%KibbutzGalEd in &%Israel.') ).

fof(kb_SUMO_3751,axiom,
    s__instance(s__KibbutzMeravIsrael,s__City) ).

fof(kb_SUMO_3752,axiom,
    s__documentation(s__KibbutzMeravIsrael,s__EnglishLanguage,'The &%City of &%KibbutzMerav in &%Israel.') ).

fof(kb_SUMO_3753,axiom,
    s__instance(s__KibbutzSheluhotIsrael,s__City) ).

fof(kb_SUMO_3754,axiom,
    s__documentation(s__KibbutzSheluhotIsrael,s__EnglishLanguage,'The &%City of &%KibbutzSheluhot in &%Israel.') ).

fof(kb_SUMO_3755,axiom,
    s__instance(s__KidapawanPhilippines,s__City) ).

fof(kb_SUMO_3756,axiom,
    s__documentation(s__KidapawanPhilippines,s__EnglishLanguage,'The &%City of &%Kidapawan in &%Philippines.') ).

fof(kb_SUMO_3757,axiom,
    s__instance(s__KigaliRwanda,s__City) ).

fof(kb_SUMO_3758,axiom,
    s__documentation(s__KigaliRwanda,s__EnglishLanguage,'The &%City of &%Kigali in &%Rwanda.') ).

fof(kb_SUMO_3759,axiom,
    s__instance(s__KirikkaleTurkey,s__City) ).

fof(kb_SUMO_3760,axiom,
    s__documentation(s__KirikkaleTurkey,s__EnglishLanguage,'The &%City of &%Kirikkale in &%Turkey.') ).

fof(kb_SUMO_3761,axiom,
    s__instance(s__KiryatArbaWestBank,s__City) ).

fof(kb_SUMO_3762,axiom,
    s__documentation(s__KiryatArbaWestBank,s__EnglishLanguage,'The &%City of &%KiryatArba in &%WestBank.') ).

fof(kb_SUMO_3763,axiom,
    s__instance(s__KiryatMotzkinIsrael,s__City) ).

fof(kb_SUMO_3764,axiom,
    s__documentation(s__KiryatMotzkinIsrael,s__EnglishLanguage,'The &%City of &%KiryatMotzkin in &%Israel.') ).

fof(kb_SUMO_3765,axiom,
    s__instance(s__KiryatNetafimWestBank,s__City) ).

fof(kb_SUMO_3766,axiom,
    s__documentation(s__KiryatNetafimWestBank,s__EnglishLanguage,'The &%City of &%KiryatNetafim in &%WestBank.') ).

fof(kb_SUMO_3767,axiom,
    s__instance(s__KissufimGazaStrip,s__City) ).

fof(kb_SUMO_3768,axiom,
    s__documentation(s__KissufimGazaStrip,s__EnglishLanguage,'The &%City of &%Kissufim in &%GazaStrip.') ).

fof(kb_SUMO_3769,axiom,
    s__instance(s__KiursehirBoztepTurkey,s__City) ).

fof(kb_SUMO_3770,axiom,
    s__documentation(s__KiursehirBoztepTurkey,s__EnglishLanguage,'The &%City of &%KiursehirBoztep in &%Turkey.') ).

fof(kb_SUMO_3771,axiom,
    s__instance(s__KlaiyatLebanon,s__City) ).

fof(kb_SUMO_3772,axiom,
    s__documentation(s__KlaiyatLebanon,s__EnglishLanguage,'The &%City of &%Klaiyat in &%Lebanon.') ).

fof(kb_SUMO_3773,axiom,
    s__instance(s__KohlanYemen,s__City) ).

fof(kb_SUMO_3774,axiom,
    s__documentation(s__KohlanYemen,s__EnglishLanguage,'The &%City of &%Kohlan in &%Yemen.') ).

fof(kb_SUMO_3775,axiom,
    s__instance(s__KomsomoLabadTajikistan,s__City) ).

fof(kb_SUMO_3776,axiom,
    s__documentation(s__KomsomoLabadTajikistan,s__EnglishLanguage,'The &%City of &%KomsomoLabad in &%Tajikistan.') ).

fof(kb_SUMO_3777,axiom,
    s__instance(s__KuwaitCityKuwait,s__City) ).

fof(kb_SUMO_3778,axiom,
    s__documentation(s__KuwaitCityKuwait,s__EnglishLanguage,'The &%City of &%KuwaitCity in &%Kuwait.') ).

fof(kb_SUMO_3779,axiom,
    s__instance(s__LIleRousseFrance,s__City) ).

fof(kb_SUMO_3780,axiom,
    s__documentation(s__LIleRousseFrance,s__EnglishLanguage,'The &%City of &%LIleRousse in &%France.') ).

fof(kb_SUMO_3781,axiom,
    s__instance(s__LaCeibaHonduras,s__City) ).

fof(kb_SUMO_3782,axiom,
    s__documentation(s__LaCeibaHonduras,s__EnglishLanguage,'The &%City of &%LaCeiba in &%Honduras.') ).

fof(kb_SUMO_3783,axiom,
    s__instance(s__LaGabarraVenezuela,s__City) ).

fof(kb_SUMO_3784,axiom,
    s__documentation(s__LaGabarraVenezuela,s__EnglishLanguage,'The &%City of &%LaGabarra in &%Venezuela.') ).

fof(kb_SUMO_3785,axiom,
    s__instance(s__LaGuajiraColombia,s__City) ).

fof(kb_SUMO_3786,axiom,
    s__documentation(s__LaGuajiraColombia,s__EnglishLanguage,'The &%City of &%LaGuajira in &%Colombia.') ).

fof(kb_SUMO_3787,axiom,
    s__instance(s__LaPazBolivia,s__City) ).

fof(kb_SUMO_3788,axiom,
    s__documentation(s__LaPazBolivia,s__EnglishLanguage,'The &%City of &%LaPaz in &%Bolivia.') ).

fof(kb_SUMO_3789,axiom,
    s__instance(s__LaVictoriaVenezuela,s__City) ).

fof(kb_SUMO_3790,axiom,
    s__documentation(s__LaVictoriaVenezuela,s__EnglishLanguage,'The &%City of &%LaVictoria in &%Venezuela.') ).

fof(kb_SUMO_3791,axiom,
    s__instance(s__LahorePakistan,s__City) ).

fof(kb_SUMO_3792,axiom,
    s__documentation(s__LahorePakistan,s__EnglishLanguage,'The &%City of &%Lahore in &%Pakistan.') ).

fof(kb_SUMO_3793,axiom,
    s__instance(s__LarbaAlgeria,s__City) ).

fof(kb_SUMO_3794,axiom,
    s__documentation(s__LarbaAlgeria,s__EnglishLanguage,'The &%City of &%Larba in &%Algeria.') ).

fof(kb_SUMO_3795,axiom,
    s__instance(s__LarnacaCyprus,s__City) ).

fof(kb_SUMO_3796,axiom,
    s__documentation(s__LarnacaCyprus,s__EnglishLanguage,'The &%City of &%Larnaca in &%Cyprus.') ).

fof(kb_SUMO_3797,axiom,
    s__instance(s__LasarteSpain,s__City) ).

fof(kb_SUMO_3798,axiom,
    s__documentation(s__LasarteSpain,s__EnglishLanguage,'The &%City of &%Lasarte in &%Spain.') ).

fof(kb_SUMO_3799,axiom,
    s__instance(s__LeizaSpain,s__City) ).

fof(kb_SUMO_3800,axiom,
    s__documentation(s__LeizaSpain,s__EnglishLanguage,'The &%City of &%Leiza in &%Spain.') ).

fof(kb_SUMO_3801,axiom,
    s__instance(s__LibertadorVenezuela,s__City) ).

fof(kb_SUMO_3802,axiom,
    s__documentation(s__LibertadorVenezuela,s__EnglishLanguage,'The &%City of &%Libertador in &%Venezuela.') ).

fof(kb_SUMO_3803,axiom,
    s__instance(s__LiceTurkey,s__City) ).

fof(kb_SUMO_3804,axiom,
    s__documentation(s__LiceTurkey,s__EnglishLanguage,'The &%City of &%Lice in &%Turkey.') ).

fof(kb_SUMO_3805,axiom,
    s__instance(s__LimaPeru,s__City) ).

fof(kb_SUMO_3806,axiom,
    s__documentation(s__LimaPeru,s__EnglishLanguage,'The &%City of &%Lima in &%Peru.') ).

fof(kb_SUMO_3807,axiom,
    s__instance(s__LindosRhodes,s__City) ).

fof(kb_SUMO_3808,axiom,
    s__documentation(s__LindosRhodes,s__EnglishLanguage,'The &%City of &%Lindos in &%Rhodes.') ).

fof(kb_SUMO_3809,axiom,
    s__instance(s__LinzAustralia,s__City) ).

fof(kb_SUMO_3810,axiom,
    s__documentation(s__LinzAustralia,s__EnglishLanguage,'The &%City of &%Linz in &%Australia.') ).

fof(kb_SUMO_3811,axiom,
    s__instance(s__LockerbieUnitedKingdom,s__City) ).

fof(kb_SUMO_3812,axiom,
    s__documentation(s__LockerbieUnitedKingdom,s__EnglishLanguage,'The &%City of &%Lockerbie in &%UnitedKingdom.') ).

fof(kb_SUMO_3813,axiom,
    s__instance(s__LogronoSpain,s__City) ).

fof(kb_SUMO_3814,axiom,
    s__documentation(s__LogronoSpain,s__EnglishLanguage,'The &%City of &%Logrono in &%Spain.') ).

fof(kb_SUMO_3815,axiom,
    s__instance(s__LondonberryNorthernIreland,s__City) ).

fof(kb_SUMO_3816,axiom,
    s__documentation(s__LondonberryNorthernIreland,s__EnglishLanguage,'The &%City of &%Londonberry in &%NorthernIreland.') ).

fof(kb_SUMO_3817,axiom,
    s__instance(s__LosBancosVenezuela,s__City) ).

fof(kb_SUMO_3818,axiom,
    s__documentation(s__LosBancosVenezuela,s__EnglishLanguage,'The &%City of &%LosBancos in &%Venezuela.') ).

fof(kb_SUMO_3819,axiom,
    s__instance(s__LuandaAngola,s__City) ).

fof(kb_SUMO_3820,axiom,
    s__documentation(s__LuandaAngola,s__EnglishLanguage,'The &%City of &%Luanda in &%Angola.') ).

fof(kb_SUMO_3821,axiom,
    s__instance(s__LuebeckGermany,s__City) ).

fof(kb_SUMO_3822,axiom,
    s__documentation(s__LuebeckGermany,s__EnglishLanguage,'The &%City of &%Luebeck in &%Germany.') ).

fof(kb_SUMO_3823,axiom,
    s__instance(s__LundaNorteAngola,s__City) ).

fof(kb_SUMO_3824,axiom,
    s__documentation(s__LundaNorteAngola,s__EnglishLanguage,'The &%City of &%LundaNorte in &%Angola.') ).

fof(kb_SUMO_3825,axiom,
    s__instance(s__LuxorEgypt,s__City) ).

fof(kb_SUMO_3826,axiom,
    s__documentation(s__LuxorEgypt,s__EnglishLanguage,'The &%City of &%Luxor in &%Egypt.') ).

fof(kb_SUMO_3827,axiom,
    s__instance(s__LyonsFrance,s__City) ).

fof(kb_SUMO_3828,axiom,
    s__documentation(s__LyonsFrance,s__EnglishLanguage,'The &%City of &%Lyons in &%France.') ).

fof(kb_SUMO_3829,axiom,
    s__instance(s__MaAlehMichmashWestBank,s__City) ).

fof(kb_SUMO_3830,axiom,
    s__documentation(s__MaAlehMichmashWestBank,s__EnglishLanguage,'The &%City of &%MaAlehMichmash in &%WestBank.') ).

fof(kb_SUMO_3831,axiom,
    s__instance(s__MaccabimIsrael,s__City) ).

fof(kb_SUMO_3832,axiom,
    s__documentation(s__MaccabimIsrael,s__EnglishLanguage,'The &%City of &%Maccabim in &%Israel.') ).

fof(kb_SUMO_3833,axiom,
    s__instance(s__MadhuSriLanka,s__City) ).

fof(kb_SUMO_3834,axiom,
    s__documentation(s__MadhuSriLanka,s__EnglishLanguage,'The &%City of &%Madhu in &%SriLanka.') ).

fof(kb_SUMO_3835,axiom,
    s__instance(s__MadrasIndia,s__City) ).

fof(kb_SUMO_3836,axiom,
    s__documentation(s__MadrasIndia,s__EnglishLanguage,'The &%City of &%Madras in &%India.') ).

fof(kb_SUMO_3837,axiom,
    s__instance(s__MadridSpain,s__City) ).

fof(kb_SUMO_3838,axiom,
    s__documentation(s__MadridSpain,s__EnglishLanguage,'The &%City of &%Madrid in &%Spain.') ).

fof(kb_SUMO_3839,axiom,
    s__instance(s__MagdalenaColombia,s__City) ).

fof(kb_SUMO_3840,axiom,
    s__documentation(s__MagdalenaColombia,s__EnglishLanguage,'The &%City of &%Magdalena in &%Colombia.') ).

fof(kb_SUMO_3841,axiom,
    s__instance(s__MaidanSharAfghanistan,s__City) ).

fof(kb_SUMO_3842,axiom,
    s__documentation(s__MaidanSharAfghanistan,s__EnglishLanguage,'The &%City of &%MaidanShar in &%Afghanistan.') ).

fof(kb_SUMO_3843,axiom,
    s__instance(s__MakhachkalaRussia,s__City) ).

fof(kb_SUMO_3844,axiom,
    s__documentation(s__MakhachkalaRussia,s__EnglishLanguage,'The &%City of &%Makhachkala in &%Russia.') ).

fof(kb_SUMO_3845,axiom,
    s__instance(s__MalagaSpain,s__City) ).

fof(kb_SUMO_3846,axiom,
    s__documentation(s__MalagaSpain,s__EnglishLanguage,'The &%City of &%Malaga in &%Spain.') ).

fof(kb_SUMO_3847,axiom,
    s__instance(s__ManaguaNigeria,s__City) ).

fof(kb_SUMO_3848,axiom,
    s__documentation(s__ManaguaNigeria,s__EnglishLanguage,'The &%City of &%Managua in &%Nigeria.') ).

fof(kb_SUMO_3849,axiom,
    s__instance(s__ManamaBahrain,s__City) ).

fof(kb_SUMO_3850,axiom,
    s__documentation(s__ManamaBahrain,s__EnglishLanguage,'The &%City of &%Manama in &%Bahrain.') ).

fof(kb_SUMO_3851,axiom,
    s__instance(s__ManchesterUnitedKingdom,s__City) ).

fof(kb_SUMO_3852,axiom,
    s__documentation(s__ManchesterUnitedKingdom,s__EnglishLanguage,'The &%City of &%Manchester in &%UnitedKingdom.') ).

fof(kb_SUMO_3853,axiom,
    s__instance(s__ManilaPhilippines,s__City) ).

fof(kb_SUMO_3854,axiom,
    s__documentation(s__ManilaPhilippines,s__EnglishLanguage,'The &%City of &%Manila in &%Philippines.') ).

fof(kb_SUMO_3855,axiom,
    s__instance(s__MaonIsrael,s__City) ).

fof(kb_SUMO_3856,axiom,
    s__documentation(s__MaonIsrael,s__EnglishLanguage,'The &%City of &%Maon in &%Israel.') ).

fof(kb_SUMO_3857,axiom,
    s__instance(s__MapourditSudan,s__City) ).

fof(kb_SUMO_3858,axiom,
    s__documentation(s__MapourditSudan,s__EnglishLanguage,'The &%City of &%Mapourdit in &%Sudan.') ).

fof(kb_SUMO_3859,axiom,
    s__instance(s__MarSabaWestBank,s__City) ).

fof(kb_SUMO_3860,axiom,
    s__documentation(s__MarSabaWestBank,s__EnglishLanguage,'The &%City of &%MarSaba in &%WestBank.') ).

fof(kb_SUMO_3861,axiom,
    s__instance(s__MarawiPhilippines,s__City) ).

fof(kb_SUMO_3862,axiom,
    s__documentation(s__MarawiPhilippines,s__EnglishLanguage,'The &%City of &%Marawi in &%Philippines.') ).

fof(kb_SUMO_3863,axiom,
    s__instance(s__MardanPakistan,s__City) ).

fof(kb_SUMO_3864,axiom,
    s__documentation(s__MardanPakistan,s__EnglishLanguage,'The &%City of &%Mardan in &%Pakistan.') ).

fof(kb_SUMO_3865,axiom,
    s__instance(s__MarmarisTurkey,s__City) ).

fof(kb_SUMO_3866,axiom,
    s__documentation(s__MarmarisTurkey,s__EnglishLanguage,'The &%City of &%Marmaris in &%Turkey.') ).

fof(kb_SUMO_3867,axiom,
    s__instance(s__MarseillesFrance,s__City) ).

fof(kb_SUMO_3868,axiom,
    s__documentation(s__MarseillesFrance,s__EnglishLanguage,'The &%City of &%Marseilles in &%France.') ).

fof(kb_SUMO_3869,axiom,
    s__instance(s__MashaWestBank,s__City) ).

fof(kb_SUMO_3870,axiom,
    s__documentation(s__MashaWestBank,s__EnglishLanguage,'The &%City of &%Masha in &%WestBank.') ).

fof(kb_SUMO_3871,axiom,
    s__instance(s__MatsumotoJapan,s__City) ).

fof(kb_SUMO_3872,axiom,
    s__documentation(s__MatsumotoJapan,s__EnglishLanguage,'The &%City of &%Matsumoto in &%Japan.') ).

fof(kb_SUMO_3873,axiom,
    s__instance(s__MawdiyahYemen,s__City) ).

fof(kb_SUMO_3874,axiom,
    s__documentation(s__MawdiyahYemen,s__EnglishLanguage,'The &%City of &%Mawdiyah in &%Yemen.') ).

fof(kb_SUMO_3875,axiom,
    s__instance(s__MeaShearimIsrael,s__City) ).

fof(kb_SUMO_3876,axiom,
    s__documentation(s__MeaShearimIsrael,s__EnglishLanguage,'The &%City of &%MeaShearim in &%Israel.') ).

fof(kb_SUMO_3877,axiom,
    s__instance(s__MeccaSaudiArabia,s__City) ).

fof(kb_SUMO_3878,axiom,
    s__documentation(s__MeccaSaudiArabia,s__EnglishLanguage,'The &%City of &%Mecca in &%SaudiArabia.') ).

fof(kb_SUMO_3879,axiom,
    s__instance(s__MechoraWestBank,s__City) ).

fof(kb_SUMO_3880,axiom,
    s__documentation(s__MechoraWestBank,s__EnglishLanguage,'The &%City of &%Mechora in &%WestBank.') ).

fof(kb_SUMO_3881,axiom,
    s__instance(s__MedanIndonesia,s__City) ).

fof(kb_SUMO_3882,axiom,
    s__documentation(s__MedanIndonesia,s__EnglishLanguage,'The &%City of &%Medan in &%Indonesia.') ).

fof(kb_SUMO_3883,axiom,
    s__instance(s__MedellinColombia,s__City) ).

fof(kb_SUMO_3884,axiom,
    s__documentation(s__MedellinColombia,s__EnglishLanguage,'The &%City of &%Medellin in &%Colombia.') ).

fof(kb_SUMO_3885,axiom,
    s__instance(s__MegidoIsrael,s__City) ).

fof(kb_SUMO_3886,axiom,
    s__documentation(s__MegidoIsrael,s__EnglishLanguage,'The &%City of &%Megido in &%Israel.') ).

fof(kb_SUMO_3887,axiom,
    s__instance(s__MeholaIsrael,s__City) ).

fof(kb_SUMO_3888,axiom,
    s__documentation(s__MeholaIsrael,s__EnglishLanguage,'The &%City of &%Mehola in &%Israel.') ).

fof(kb_SUMO_3889,axiom,
    s__instance(s__MekholahIsrael,s__City) ).

fof(kb_SUMO_3890,axiom,
    s__documentation(s__MekholahIsrael,s__EnglishLanguage,'The &%City of &%Mekholah in &%Israel.') ).

fof(kb_SUMO_3891,axiom,
    s__instance(s__MersinTurkey,s__City) ).

fof(kb_SUMO_3892,axiom,
    s__documentation(s__MersinTurkey,s__EnglishLanguage,'The &%City of &%Mersin in &%Turkey.') ).

fof(kb_SUMO_3893,axiom,
    s__instance(s__MetaColombia,s__City) ).

fof(kb_SUMO_3894,axiom,
    s__documentation(s__MetaColombia,s__EnglishLanguage,'The &%City of &%Meta in &%Colombia.') ).

fof(kb_SUMO_3895,axiom,
    s__instance(s__MetullaIsrael,s__City) ).

fof(kb_SUMO_3896,axiom,
    s__documentation(s__MetullaIsrael,s__EnglishLanguage,'The &%City of &%Metulla in &%Israel.') ).

fof(kb_SUMO_3897,axiom,
    s__instance(s__MetzerIsrael,s__City) ).

fof(kb_SUMO_3898,axiom,
    s__documentation(s__MetzerIsrael,s__EnglishLanguage,'The &%City of &%Metzer in &%Israel.') ).

fof(kb_SUMO_3899,axiom,
    s__instance(s__MilanItaly,s__City) ).

fof(kb_SUMO_3900,axiom,
    s__documentation(s__MilanItaly,s__EnglishLanguage,'The &%City of &%Milan in &%Italy.') ).

fof(kb_SUMO_3901,axiom,
    s__instance(s__MindanaoPhilippines,s__City) ).

fof(kb_SUMO_3902,axiom,
    s__documentation(s__MindanaoPhilippines,s__EnglishLanguage,'The &%City of &%Mindanao in &%Philippines.') ).

fof(kb_SUMO_3903,axiom,
    s__instance(s__MiranShahPakistan,s__City) ).

fof(kb_SUMO_3904,axiom,
    s__documentation(s__MiranShahPakistan,s__EnglishLanguage,'The &%City of &%MiranShah in &%Pakistan.') ).

fof(kb_SUMO_3905,axiom,
    s__instance(s__MituColombia,s__City) ).

fof(kb_SUMO_3906,axiom,
    s__documentation(s__MituColombia,s__EnglishLanguage,'The &%City of &%Mitu in &%Colombia.') ).

fof(kb_SUMO_3907,axiom,
    s__instance(s__ModiinIllitWestBank,s__City) ).

fof(kb_SUMO_3908,axiom,
    s__documentation(s__ModiinIllitWestBank,s__EnglishLanguage,'The &%City of &%ModiinIllit in &%WestBank.') ).

fof(kb_SUMO_3909,axiom,
    s__instance(s__MombassaKenya,s__City) ).

fof(kb_SUMO_3910,axiom,
    s__documentation(s__MombassaKenya,s__EnglishLanguage,'The &%City of &%Mombassa in &%Kenya.') ).

fof(kb_SUMO_3911,axiom,
    s__instance(s__MoshavHagorIsrael,s__City) ).

fof(kb_SUMO_3912,axiom,
    s__documentation(s__MoshavHagorIsrael,s__EnglishLanguage,'The &%City of &%MoshavHagor in &%Israel.') ).

fof(kb_SUMO_3913,axiom,
    s__instance(s__MoshavTomerWestBank,s__City) ).

fof(kb_SUMO_3914,axiom,
    s__documentation(s__MoshavTomerWestBank,s__EnglishLanguage,'The &%City of &%MoshavTomer in &%WestBank.') ).

fof(kb_SUMO_3915,axiom,
    s__instance(s__MukallahAdenYemen,s__City) ).

fof(kb_SUMO_3916,axiom,
    s__documentation(s__MukallahAdenYemen,s__EnglishLanguage,'The &%City of &%MukallahAden in &%Yemen.') ).

fof(kb_SUMO_3917,axiom,
    s__instance(s__MunchenGladbachGermany,s__City) ).

fof(kb_SUMO_3918,axiom,
    s__documentation(s__MunchenGladbachGermany,s__EnglishLanguage,'The &%City of &%MunchenGladbach in &%Germany.') ).

fof(kb_SUMO_3919,axiom,
    s__instance(s__MunsterGermany,s__City) ).

fof(kb_SUMO_3920,axiom,
    s__documentation(s__MunsterGermany,s__EnglishLanguage,'The &%City of &%Munster in &%Germany.') ).

fof(kb_SUMO_3921,axiom,
    s__instance(s__MurloughNorthernIreland,s__City) ).

fof(kb_SUMO_3922,axiom,
    s__documentation(s__MurloughNorthernIreland,s__EnglishLanguage,'The &%City of &%Murlough in &%NorthernIreland.') ).

fof(kb_SUMO_3923,axiom,
    s__instance(s__MusMusIsrael,s__City) ).

fof(kb_SUMO_3924,axiom,
    s__documentation(s__MusMusIsrael,s__EnglishLanguage,'The &%City of &%MusMus in &%Israel.') ).

fof(kb_SUMO_3925,axiom,
    s__instance(s__MutataColombia,s__City) ).

fof(kb_SUMO_3926,axiom,
    s__documentation(s__MutataColombia,s__EnglishLanguage,'The &%City of &%Mutata in &%Colombia.') ).

fof(kb_SUMO_3927,axiom,
    s__instance(s__MutturSriLanka,s__City) ).

fof(kb_SUMO_3928,axiom,
    s__documentation(s__MutturSriLanka,s__EnglishLanguage,'The &%City of &%Muttur in &%SriLanka.') ).

fof(kb_SUMO_3929,axiom,
    s__instance(s__NaAlinWestBank,s__City) ).

fof(kb_SUMO_3930,axiom,
    s__documentation(s__NaAlinWestBank,s__EnglishLanguage,'The &%City of &%NaAlin in &%WestBank.') ).

fof(kb_SUMO_3931,axiom,
    s__instance(s__NablusWestBank,s__City) ).

fof(kb_SUMO_3932,axiom,
    s__documentation(s__NablusWestBank,s__EnglishLanguage,'The &%City of &%Nablus in &%WestBank.') ).

fof(kb_SUMO_3933,axiom,
    s__instance(s__NahalOzGazaStrip,s__City) ).

fof(kb_SUMO_3934,axiom,
    s__documentation(s__NahalOzGazaStrip,s__EnglishLanguage,'The &%City of &%NahalOz in &%GazaStrip.') ).

fof(kb_SUMO_3935,axiom,
    s__instance(s__NaharaimIsrael,s__City) ).

fof(kb_SUMO_3936,axiom,
    s__documentation(s__NaharaimIsrael,s__EnglishLanguage,'The &%City of &%Naharaim in &%Israel.') ).

fof(kb_SUMO_3937,axiom,
    s__instance(s__NahariyaIsrael,s__City) ).

fof(kb_SUMO_3938,axiom,
    s__documentation(s__NahariyaIsrael,s__EnglishLanguage,'The &%City of &%Nahariya in &%Israel.') ).

fof(kb_SUMO_3939,axiom,
    s__instance(s__NairobiKenya,s__City) ).

fof(kb_SUMO_3940,axiom,
    s__documentation(s__NairobiKenya,s__EnglishLanguage,'The &%City of &%Nairobi in &%Kenya.') ).

fof(kb_SUMO_3941,axiom,
    s__instance(s__NajafIraq,s__City) ).

fof(kb_SUMO_3942,axiom,
    s__documentation(s__NajafIraq,s__EnglishLanguage,'The &%City of &%Najaf in &%Iraq.') ).

fof(kb_SUMO_3943,axiom,
    s__instance(s__NaquraLebanon,s__City) ).

fof(kb_SUMO_3944,axiom,
    s__documentation(s__NaquraLebanon,s__EnglishLanguage,'The &%City of &%Naqura in &%Lebanon.') ).

fof(kb_SUMO_3945,axiom,
    s__instance(s__NarayangangBangladesh,s__City) ).

fof(kb_SUMO_3946,axiom,
    s__documentation(s__NarayangangBangladesh,s__EnglishLanguage,'The &%City of &%Narayangang in &%Bangladesh.') ).

fof(kb_SUMO_3947,axiom,
    s__instance(s__NataniaIsrael,s__City) ).

fof(kb_SUMO_3948,axiom,
    s__documentation(s__NataniaIsrael,s__EnglishLanguage,'The &%City of &%Natania in &%Israel.') ).

fof(kb_SUMO_3949,axiom,
    s__instance(s__NearAdarim,s__City) ).

fof(kb_SUMO_3950,axiom,
    s__documentation(s__NearAdarim,s__EnglishLanguage,'The &%City of NearAdarim.') ).

fof(kb_SUMO_3951,axiom,
    s__instance(s__NearAleiZahav,s__City) ).

fof(kb_SUMO_3952,axiom,
    s__documentation(s__NearAleiZahav,s__EnglishLanguage,'The &%City of NearAleiZahav.') ).

fof(kb_SUMO_3953,axiom,
    s__instance(s__NearJenin,s__City) ).

fof(kb_SUMO_3954,axiom,
    s__documentation(s__NearJenin,s__EnglishLanguage,'The &%City of NearJenin.') ).

fof(kb_SUMO_3955,axiom,
    s__instance(s__NetanyaIsrael,s__City) ).

fof(kb_SUMO_3956,axiom,
    s__documentation(s__NetanyaIsrael,s__EnglishLanguage,'The &%City of &%Netanya in &%Israel.') ).

fof(kb_SUMO_3957,axiom,
    s__instance(s__NetzarimGazaStrip,s__City) ).

fof(kb_SUMO_3958,axiom,
    s__documentation(s__NetzarimGazaStrip,s__EnglishLanguage,'The &%City of &%Netzarim in &%GazaStrip.') ).

fof(kb_SUMO_3959,axiom,
    s__instance(s__NetzerHazaniGazaStrip,s__City) ).

fof(kb_SUMO_3960,axiom,
    s__documentation(s__NetzerHazaniGazaStrip,s__EnglishLanguage,'The &%City of &%NetzerHazani in &%GazaStrip.') ).

fof(kb_SUMO_3961,axiom,
    s__instance(s__NeveDanielWestBank,s__City) ).

fof(kb_SUMO_3962,axiom,
    s__documentation(s__NeveDanielWestBank,s__EnglishLanguage,'The &%City of &%NeveDaniel in &%WestBank.') ).

fof(kb_SUMO_3963,axiom,
    s__instance(s__NeveDekalim,s__City) ).

fof(kb_SUMO_3964,axiom,
    s__documentation(s__NeveDekalim,s__EnglishLanguage,'The &%City of NeveDekalim.') ).

fof(kb_SUMO_3965,axiom,
    s__instance(s__NeveYaminIsrael,s__City) ).

fof(kb_SUMO_3966,axiom,
    s__documentation(s__NeveYaminIsrael,s__EnglishLanguage,'The &%City of &%NeveYamin in &%Israel.') ).

fof(kb_SUMO_3967,axiom,
    s__instance(s__NewDelhiIndia,s__City) ).

fof(kb_SUMO_3968,axiom,
    s__documentation(s__NewDelhiIndia,s__EnglishLanguage,'The &%City of &%NewDelhi in &%India.') ).

fof(kb_SUMO_3969,axiom,
    s__instance(s__NewYorkCityUnitedStates,s__AmericanCity) ).

fof(kb_SUMO_3970,axiom,
    s__documentation(s__NewYorkCityUnitedStates,s__EnglishLanguage,'The largest &%City in the &%UnitedStates. A worldwide center of finance and culture, it is comprised of five boroughs.') ).

fof(kb_SUMO_3971,axiom,
    ! [V__CITY] :
      ( s__instance(V__CITY,s__GeopoliticalArea)
     => ( s__instance(V__CITY,s__AmericanCity)
       => lesseq(s__CardinalityFn(s__ResidentFn(V__CITY)),s__CardinalityFn(s__ResidentFn(s__NewYorkCityUnitedStates))) ) ) ).

fof(kb_SUMO_3972,axiom,
    s__instance(s__NiameyNiger,s__City) ).

fof(kb_SUMO_3973,axiom,
    s__documentation(s__NiameyNiger,s__EnglishLanguage,'The &%City of &%Niamey in &%Niger.') ).

fof(kb_SUMO_3974,axiom,
    s__instance(s__NissanitGazaStrip,s__City) ).

fof(kb_SUMO_3975,axiom,
    s__documentation(s__NissanitGazaStrip,s__EnglishLanguage,'The &%City of &%Nissanit in &%GazaStrip.') ).

fof(kb_SUMO_3976,axiom,
    s__instance(s__NitzaneiOzWestBank,s__City) ).

fof(kb_SUMO_3977,axiom,
    s__documentation(s__NitzaneiOzWestBank,s__EnglishLanguage,'The &%City of &%NitzaneiOz in &%WestBank.') ).

fof(kb_SUMO_3978,axiom,
    s__instance(s__NitzanimIsrael,s__City) ).

fof(kb_SUMO_3979,axiom,
    s__documentation(s__NitzanimIsrael,s__EnglishLanguage,'The &%City of &%Nitzanim in &%Israel.') ).

fof(kb_SUMO_3980,axiom,
    s__instance(s__NorteDeSantanderColombia,s__City) ).

fof(kb_SUMO_3981,axiom,
    s__documentation(s__NorteDeSantanderColombia,s__EnglishLanguage,'The &%City of &%NorteDeSantander in &%Colombia.') ).

fof(kb_SUMO_3982,axiom,
    s__instance(s__NovogroznyRussia,s__City) ).

fof(kb_SUMO_3983,axiom,
    s__documentation(s__NovogroznyRussia,s__EnglishLanguage,'The &%City of &%Novogrozny in &%Russia.') ).

fof(kb_SUMO_3984,axiom,
    s__instance(s__NovyyAtagiRussia,s__City) ).

fof(kb_SUMO_3985,axiom,
    s__documentation(s__NovyyAtagiRussia,s__EnglishLanguage,'The &%City of &%NovyyAtagi in &%Russia.') ).

fof(kb_SUMO_3986,axiom,
    s__instance(s__OberwartAustria,s__City) ).

fof(kb_SUMO_3987,axiom,
    s__documentation(s__OberwartAustria,s__EnglishLanguage,'The &%City of &%Oberwart in &%Austria.') ).

fof(kb_SUMO_3988,axiom,
    s__instance(s__OfraWestBank,s__City) ).

fof(kb_SUMO_3989,axiom,
    s__documentation(s__OfraWestBank,s__EnglishLanguage,'The &%City of &%Ofra in &%WestBank.') ).

fof(kb_SUMO_3990,axiom,
    s__instance(s__OkaraPakistan,s__City) ).

fof(kb_SUMO_3991,axiom,
    s__documentation(s__OkaraPakistan,s__EnglishLanguage,'The &%City of &%Okara in &%Pakistan.') ).

fof(kb_SUMO_3992,axiom,
    s__instance(s__OlayaHerreraColombia,s__City) ).

fof(kb_SUMO_3993,axiom,
    s__documentation(s__OlayaHerreraColombia,s__EnglishLanguage,'The &%City of &%OlayaHerrera in &%Colombia.') ).

fof(kb_SUMO_3994,axiom,
    s__instance(s__OmaghNorthernIreland,s__City) ).

fof(kb_SUMO_3995,axiom,
    s__documentation(s__OmaghNorthernIreland,s__EnglishLanguage,'The &%City of &%Omagh in &%NorthernIreland.') ).

fof(kb_SUMO_3996,axiom,
    s__instance(s__OrYehudaIsrael,s__City) ).

fof(kb_SUMO_3997,axiom,
    s__documentation(s__OrYehudaIsrael,s__EnglishLanguage,'The &%City of &%OrYehuda in &%Israel.') ).

fof(kb_SUMO_3998,axiom,
    s__instance(s__OranAlgeria,s__City) ).

fof(kb_SUMO_3999,axiom,
    s__documentation(s__OranAlgeria,s__EnglishLanguage,'The &%City of &%Oran in &%Algeria.') ).

fof(kb_SUMO_4000,axiom,
    s__instance(s__OsakaJapan,s__City) ).

fof(kb_SUMO_4001,axiom,
    s__documentation(s__OsakaJapan,s__EnglishLanguage,'The &%City of &%Osaka in &%Japan.') ).

fof(kb_SUMO_4002,axiom,
    s__instance(s__OsloNorway,s__City) ).

fof(kb_SUMO_4003,axiom,
    s__documentation(s__OsloNorway,s__EnglishLanguage,'The &%City of &%Oslo in &%Norway.') ).

fof(kb_SUMO_4004,axiom,
    s__instance(s__OssnabruckGermany,s__City) ).

fof(kb_SUMO_4005,axiom,
    s__documentation(s__OssnabruckGermany,s__EnglishLanguage,'The &%City of &%Ossnabruck in &%Germany.') ).

fof(kb_SUMO_4006,axiom,
    s__instance(s__OtnielWestBank,s__City) ).

fof(kb_SUMO_4007,axiom,
    s__documentation(s__OtnielWestBank,s__EnglishLanguage,'The &%City of &%Otniel in &%WestBank.') ).

fof(kb_SUMO_4008,axiom,
    s__instance(s__OtzarinWestBank,s__City) ).

fof(kb_SUMO_4009,axiom,
    s__documentation(s__OtzarinWestBank,s__EnglishLanguage,'The &%City of &%Otzarin in &%WestBank.') ).

fof(kb_SUMO_4010,axiom,
    s__instance(s__OzamisPhilippines,s__City) ).

fof(kb_SUMO_4011,axiom,
    s__documentation(s__OzamisPhilippines,s__EnglishLanguage,'The &%City of &%Ozamis in &%Philippines.') ).

fof(kb_SUMO_4012,axiom,
    s__instance(s__PahalgamIndia,s__City) ).

fof(kb_SUMO_4013,axiom,
    s__documentation(s__PahalgamIndia,s__EnglishLanguage,'The &%City of &%Pahalgam in &%India.') ).

fof(kb_SUMO_4014,axiom,
    s__instance(s__PalorinyaUganda,s__City) ).

fof(kb_SUMO_4015,axiom,
    s__documentation(s__PalorinyaUganda,s__EnglishLanguage,'The &%City of &%Palorinya in &%Uganda.') ).

fof(kb_SUMO_4016,axiom,
    s__instance(s__PamplonaSpain,s__City) ).

fof(kb_SUMO_4017,axiom,
    s__documentation(s__PamplonaSpain,s__EnglishLanguage,'The &%City of &%Pamplona in &%Spain.') ).

fof(kb_SUMO_4018,axiom,
    s__instance(s__PanamaCityPanama,s__City) ).

fof(kb_SUMO_4019,axiom,
    s__documentation(s__PanamaCityPanama,s__EnglishLanguage,'The &%City of &%PanamaCity in &%Panama.') ).

fof(kb_SUMO_4020,axiom,
    s__instance(s__PantrasGreece,s__City) ).

fof(kb_SUMO_4021,axiom,
    s__documentation(s__PantrasGreece,s__EnglishLanguage,'The &%City of &%Pantras in &%Greece.') ).

fof(kb_SUMO_4022,axiom,
    s__instance(s__PapayinColombia,s__City) ).

fof(kb_SUMO_4023,axiom,
    s__documentation(s__PapayinColombia,s__EnglishLanguage,'The &%City of &%Papayin in &%Colombia.') ).

fof(kb_SUMO_4024,axiom,
    s__instance(s__PapuaIndonesia,s__City) ).

fof(kb_SUMO_4025,axiom,
    s__documentation(s__PapuaIndonesia,s__EnglishLanguage,'The &%City of &%Papua in &%Indonesia.') ).

fof(kb_SUMO_4026,axiom,
    s__instance(s__PatikulPhilippines,s__City) ).

fof(kb_SUMO_4027,axiom,
    s__documentation(s__PatikulPhilippines,s__EnglishLanguage,'The &%City of &%Patikul in &%Philippines.') ).

fof(kb_SUMO_4028,axiom,
    s__instance(s__PauFrance,s__City) ).

fof(kb_SUMO_4029,axiom,
    s__documentation(s__PauFrance,s__EnglishLanguage,'The &%City of &%Pau in &%France.') ).

fof(kb_SUMO_4030,axiom,
    s__instance(s__PeAtSadehGazaStrip,s__City) ).

fof(kb_SUMO_4031,axiom,
    s__documentation(s__PeAtSadehGazaStrip,s__EnglishLanguage,'The &%City of &%PeAtSadeh in &%GazaStrip.') ).

fof(kb_SUMO_4032,axiom,
    s__instance(s__PeshawarPakistan,s__City) ).

fof(kb_SUMO_4033,axiom,
    s__documentation(s__PeshawarPakistan,s__EnglishLanguage,'The &%City of &%Peshawar in &%Pakistan.') ).

fof(kb_SUMO_4034,axiom,
    s__instance(s__PetahTikva,s__City) ).

fof(kb_SUMO_4035,axiom,
    s__documentation(s__PetahTikva,s__EnglishLanguage,'The &%City of PetahTikva.') ).

fof(kb_SUMO_4036,axiom,
    s__instance(s__PetahTikvahIsrael,s__City) ).

fof(kb_SUMO_4037,axiom,
    s__documentation(s__PetahTikvahIsrael,s__EnglishLanguage,'The &%City of &%PetahTikvah in &%Israel.') ).

fof(kb_SUMO_4038,axiom,
    s__instance(s__PhnomPenhCambodia,s__City) ).

fof(kb_SUMO_4039,axiom,
    s__documentation(s__PhnomPenhCambodia,s__EnglishLanguage,'The &%City of &%PhnomPenh in &%Cambodia.') ).

fof(kb_SUMO_4040,axiom,
    s__instance(s__PortadownIreland,s__City) ).

fof(kb_SUMO_4041,axiom,
    s__documentation(s__PortadownIreland,s__EnglishLanguage,'The &%City of &%Portadown in &%Ireland.') ).

fof(kb_SUMO_4042,axiom,
    s__instance(s__PragueCzechRepublic,s__City) ).

fof(kb_SUMO_4043,axiom,
    s__documentation(s__PragueCzechRepublic,s__EnglishLanguage,'The &%City of &%Prague in &%CzechRepublic.') ).

fof(kb_SUMO_4044,axiom,
    s__instance(s__PuertoAlviraColombia,s__City) ).

fof(kb_SUMO_4045,axiom,
    s__documentation(s__PuertoAlviraColombia,s__EnglishLanguage,'The &%City of &%PuertoAlvira in &%Colombia.') ).

fof(kb_SUMO_4046,axiom,
    s__instance(s__PuertoLlerasColombia,s__City) ).

fof(kb_SUMO_4047,axiom,
    s__documentation(s__PuertoLlerasColombia,s__EnglishLanguage,'The &%City of &%PuertoLleras in &%Colombia.') ).

fof(kb_SUMO_4048,axiom,
    s__instance(s__PunjabPakistan,s__City) ).

fof(kb_SUMO_4049,axiom,
    s__documentation(s__PunjabPakistan,s__EnglishLanguage,'The &%City of &%Punjab in &%Pakistan.') ).

fof(kb_SUMO_4050,axiom,
    s__instance(s__QuettaPakistan,s__City) ).

fof(kb_SUMO_4051,axiom,
    s__documentation(s__QuettaPakistan,s__EnglishLanguage,'The &%City of &%Quetta in &%Pakistan.') ).

fof(kb_SUMO_4052,axiom,
    s__instance(s__QuitoEcuador,s__City) ).

fof(kb_SUMO_4053,axiom,
    s__documentation(s__QuitoEcuador,s__EnglishLanguage,'The &%City of &%Quito in &%Ecuador.') ).

fof(kb_SUMO_4054,axiom,
    s__instance(s__RadaAmanYemen,s__City) ).

fof(kb_SUMO_4055,axiom,
    s__documentation(s__RadaAmanYemen,s__EnglishLanguage,'The &%City of &%RadaAman in &%Yemen.') ).

fof(kb_SUMO_4056,axiom,
    s__instance(s__RafahGazaStrip,s__City) ).

fof(kb_SUMO_4057,axiom,
    s__documentation(s__RafahGazaStrip,s__EnglishLanguage,'The &%City of &%Rafah in &%GazaStrip.') ).

fof(kb_SUMO_4058,axiom,
    s__instance(s__RamaJunctionWestBank,s__City) ).

fof(kb_SUMO_4059,axiom,
    s__documentation(s__RamaJunctionWestBank,s__EnglishLanguage,'The &%City of &%RamaJunction in &%WestBank.') ).

fof(kb_SUMO_4060,axiom,
    s__instance(s__RamalDeAspusanaPeru,s__City) ).

fof(kb_SUMO_4061,axiom,
    s__documentation(s__RamalDeAspusanaPeru,s__EnglishLanguage,'The &%City of &%RamalDeAspusana in &%Peru.') ).

fof(kb_SUMO_4062,axiom,
    s__instance(s__RamallahWestBank,s__City) ).

fof(kb_SUMO_4063,axiom,
    s__documentation(s__RamallahWestBank,s__EnglishLanguage,'The &%City of &%Ramallah in &%WestBank.') ).

fof(kb_SUMO_4064,axiom,
    s__instance(s__RamatGanIsrael,s__City) ).

fof(kb_SUMO_4065,axiom,
    s__documentation(s__RamatGanIsrael,s__EnglishLanguage,'The &%City of &%RamatGan in &%Israel.') ).

fof(kb_SUMO_4066,axiom,
    s__instance(s__RaminWestBank,s__City) ).

fof(kb_SUMO_4067,axiom,
    s__documentation(s__RaminWestBank,s__EnglishLanguage,'The &%City of &%Ramin in &%WestBank.') ).

fof(kb_SUMO_4068,axiom,
    s__instance(s__RamleIsrael,s__City) ).

fof(kb_SUMO_4069,axiom,
    s__documentation(s__RamleIsrael,s__EnglishLanguage,'The &%City of &%Ramle in &%Israel.') ).

fof(kb_SUMO_4070,axiom,
    s__instance(s__RawalpindiPakistan,s__City) ).

fof(kb_SUMO_4071,axiom,
    s__documentation(s__RawalpindiPakistan,s__EnglishLanguage,'The &%City of &%Rawalpindi in &%Pakistan.') ).

fof(kb_SUMO_4072,axiom,
    s__instance(s__ReusSpain,s__City) ).

fof(kb_SUMO_4073,axiom,
    s__documentation(s__ReusSpain,s__EnglishLanguage,'The &%City of &%Reus in &%Spain.') ).

fof(kb_SUMO_4074,axiom,
    s__instance(s__RigaLatvia,s__City) ).

fof(kb_SUMO_4075,axiom,
    s__documentation(s__RigaLatvia,s__EnglishLanguage,'The &%City of &%Riga in &%Latvia.') ).

fof(kb_SUMO_4076,axiom,
    s__instance(s__RijekaCroatia,s__City) ).

fof(kb_SUMO_4077,axiom,
    s__documentation(s__RijekaCroatia,s__EnglishLanguage,'The &%City of &%Rijeka in &%Croatia.') ).

fof(kb_SUMO_4078,axiom,
    s__instance(s__RishonLeZionIsrael,s__City) ).

fof(kb_SUMO_4079,axiom,
    s__documentation(s__RishonLeZionIsrael,s__EnglishLanguage,'The &%City of &%RishonLeZion in &%Israel.') ).

fof(kb_SUMO_4080,axiom,
    s__instance(s__RiyadhSaudiArabia,s__City) ).

fof(kb_SUMO_4081,axiom,
    s__documentation(s__RiyadhSaudiArabia,s__EnglishLanguage,'The &%City of &%Riyadh in &%SaudiArabia.') ).

fof(kb_SUMO_4082,axiom,
    s__instance(s__RoermondNetherlands,s__City) ).

fof(kb_SUMO_4083,axiom,
    s__documentation(s__RoermondNetherlands,s__EnglishLanguage,'The &%City of &%Roermond in &%Netherlands.') ).

fof(kb_SUMO_4084,axiom,
    s__instance(s__RosasSpain,s__City) ).

fof(kb_SUMO_4085,axiom,
    s__documentation(s__RosasSpain,s__EnglishLanguage,'The &%City of &%Rosas in &%Spain.') ).

fof(kb_SUMO_4086,axiom,
    s__instance(s__RostovOnDonRussia,s__City) ).

fof(kb_SUMO_4087,axiom,
    s__documentation(s__RostovOnDonRussia,s__EnglishLanguage,'The &%City of &%RostovOnDon in &%Russia.') ).

fof(kb_SUMO_4088,axiom,
    s__instance(s__RuhengeriRwanda,s__City) ).

fof(kb_SUMO_4089,axiom,
    s__documentation(s__RuhengeriRwanda,s__EnglishLanguage,'The &%City of &%Ruhengeri in &%Rwanda.') ).

fof(kb_SUMO_4090,axiom,
    s__instance(s__SaadaYemen,s__City) ).

fof(kb_SUMO_4091,axiom,
    s__documentation(s__SaadaYemen,s__EnglishLanguage,'The &%City of &%Saada in &%Yemen.') ).

fof(kb_SUMO_4092,axiom,
    s__instance(s__SabatenaColombia,s__City) ).

fof(kb_SUMO_4093,axiom,
    s__documentation(s__SabatenaColombia,s__EnglishLanguage,'The &%City of &%Sabatena in &%Colombia.') ).

fof(kb_SUMO_4094,axiom,
    s__instance(s__SacramentoUnitedStates,s__City) ).

fof(kb_SUMO_4095,axiom,
    s__documentation(s__SacramentoUnitedStates,s__EnglishLanguage,'The &%City of &%Sacramento in &%UnitedStates.') ).

fof(kb_SUMO_4096,axiom,
    s__instance(s__SaintAvoldFrance,s__City) ).

fof(kb_SUMO_4097,axiom,
    s__documentation(s__SaintAvoldFrance,s__EnglishLanguage,'The &%City of &%SaintAvold in &%France.') ).

fof(kb_SUMO_4098,axiom,
    s__instance(s__SaintSebastianSpain,s__City) ).

fof(kb_SUMO_4099,axiom,
    s__documentation(s__SaintSebastianSpain,s__EnglishLanguage,'The &%City of &%SaintSebastian in &%Spain.') ).

fof(kb_SUMO_4100,axiom,
    s__instance(s__SaintJeanDeLuzFrance,s__City) ).

fof(kb_SUMO_4101,axiom,
    s__documentation(s__SaintJeanDeLuzFrance,s__EnglishLanguage,'The &%City of &%SaintJeanDeLuz in &%France.') ).

fof(kb_SUMO_4102,axiom,
    s__instance(s__SairanbarIraq,s__City) ).

fof(kb_SUMO_4103,axiom,
    s__documentation(s__SairanbarIraq,s__EnglishLanguage,'The &%City of &%Sairanbar in &%Iraq.') ).

fof(kb_SUMO_4104,axiom,
    s__instance(s__SajaIAGazaStrip,s__City) ).

fof(kb_SUMO_4105,axiom,
    s__documentation(s__SajaIAGazaStrip,s__EnglishLanguage,'The &%City of &%SajaIA in &%GazaStrip.') ).

fof(kb_SUMO_4106,axiom,
    s__instance(s__SallentDeGallegoSpain,s__City) ).

fof(kb_SUMO_4107,axiom,
    s__documentation(s__SallentDeGallegoSpain,s__EnglishLanguage,'The &%City of &%SallentDeGallego in &%Spain.') ).

fof(kb_SUMO_4108,axiom,
    s__instance(s__SamariaWestBank,s__City) ).

fof(kb_SUMO_4109,axiom,
    s__documentation(s__SamariaWestBank,s__EnglishLanguage,'The &%City of &%Samaria in &%WestBank.') ).

fof(kb_SUMO_4110,axiom,
    s__instance(s__SamashkiRussia,s__City) ).

fof(kb_SUMO_4111,axiom,
    s__documentation(s__SamashkiRussia,s__EnglishLanguage,'The &%City of &%Samashki in &%Russia.') ).

fof(kb_SUMO_4112,axiom,
    s__instance(s__SanDiegoColombia,s__City) ).

fof(kb_SUMO_4113,axiom,
    s__documentation(s__SanDiegoColombia,s__EnglishLanguage,'The &%City of &%SanDiego in &%Colombia.') ).

fof(kb_SUMO_4114,axiom,
    s__instance(s__SanJoseCostaRica,s__City) ).

fof(kb_SUMO_4115,axiom,
    s__documentation(s__SanJoseCostaRica,s__EnglishLanguage,'The &%City of &%SanJose in &%CostaRica.') ).

fof(kb_SUMO_4116,axiom,
    s__instance(s__SanLuisColombia,s__City) ).

fof(kb_SUMO_4117,axiom,
    s__documentation(s__SanLuisColombia,s__EnglishLanguage,'The &%City of &%SanLuis in &%Colombia.') ).

fof(kb_SUMO_4118,axiom,
    s__instance(s__SanMiguelElSalvador,s__City) ).

fof(kb_SUMO_4119,axiom,
    s__documentation(s__SanMiguelElSalvador,s__EnglishLanguage,'The &%City of &%SanMiguel in &%ElSalvador.') ).

fof(kb_SUMO_4120,axiom,
    s__instance(s__SanPabloColombia,s__City) ).

fof(kb_SUMO_4121,axiom,
    s__documentation(s__SanPabloColombia,s__EnglishLanguage,'The &%City of &%SanPablo in &%Colombia.') ).

fof(kb_SUMO_4122,axiom,
    s__instance(s__SanSebastianSpain,s__City) ).

fof(kb_SUMO_4123,axiom,
    s__documentation(s__SanSebastianSpain,s__EnglishLanguage,'The &%City of &%SanSebastian in &%Spain.') ).

fof(kb_SUMO_4124,axiom,
    s__instance(s__SanaaYemen,s__City) ).

fof(kb_SUMO_4125,axiom,
    s__documentation(s__SanaaYemen,s__EnglishLanguage,'The &%City of &%Sanaa in &%Yemen.') ).

fof(kb_SUMO_4126,axiom,
    s__instance(s__SangaldanIndia,s__City) ).

fof(kb_SUMO_4127,axiom,
    s__documentation(s__SangaldanIndia,s__EnglishLanguage,'The &%City of &%Sangaldan in &%India.') ).

fof(kb_SUMO_4128,axiom,
    s__instance(s__SantaMartaColombia,s__City) ).

fof(kb_SUMO_4129,axiom,
    s__documentation(s__SantaMartaColombia,s__EnglishLanguage,'The &%City of &%SantaMarta in &%Colombia.') ).

fof(kb_SUMO_4130,axiom,
    s__instance(s__SantaPolaSpain,s__City) ).

fof(kb_SUMO_4131,axiom,
    s__documentation(s__SantaPolaSpain,s__EnglishLanguage,'The &%City of &%SantaPola in &%Spain.') ).

fof(kb_SUMO_4132,axiom,
    s__instance(s__SantiagoChile,s__City) ).

fof(kb_SUMO_4133,axiom,
    s__documentation(s__SantiagoChile,s__EnglishLanguage,'The &%City of &%Santiago in &%Chile.') ).

fof(kb_SUMO_4134,axiom,
    s__instance(s__SanurIsrael,s__City) ).

fof(kb_SUMO_4135,axiom,
    s__documentation(s__SanurIsrael,s__EnglishLanguage,'The &%City of &%Sanur in &%Israel.') ).

fof(kb_SUMO_4136,axiom,
    s__instance(s__SarajevoBosniaAndHerzegovina,s__City) ).

fof(kb_SUMO_4137,axiom,
    s__documentation(s__SarajevoBosniaAndHerzegovina,s__EnglishLanguage,'The &%City of &%Sarajevo in &%BosniaAndHerzegovina.') ).

fof(kb_SUMO_4138,axiom,
    s__instance(s__SatkhiraBangladesh,s__City) ).

fof(kb_SUMO_4139,axiom,
    s__documentation(s__SatkhiraBangladesh,s__EnglishLanguage,'The &%City of &%Satkhira in &%Bangladesh.') ).

fof(kb_SUMO_4140,axiom,
    s__instance(s__SegoviaColombia,s__City) ).

fof(kb_SUMO_4141,axiom,
    s__documentation(s__SegoviaColombia,s__EnglishLanguage,'The &%City of &%Segovia in &%Colombia.') ).

fof(kb_SUMO_4142,axiom,
    s__instance(s__SeoulSouthKorea,s__City) ).

fof(kb_SUMO_4143,axiom,
    s__documentation(s__SeoulSouthKorea,s__EnglishLanguage,'The &%City of &%Seoul in &%SouthKorea.') ).

fof(kb_SUMO_4144,axiom,
    s__instance(s__SevilleSpain,s__City) ).

fof(kb_SUMO_4145,axiom,
    s__documentation(s__SevilleSpain,s__EnglishLanguage,'The &%City of &%Seville in &%Spain.') ).

fof(kb_SUMO_4146,axiom,
    s__instance(s__ShadmotMeholaWestBank,s__City) ).

fof(kb_SUMO_4147,axiom,
    s__documentation(s__ShadmotMeholaWestBank,s__EnglishLanguage,'The &%City of &%ShadmotMehola in &%WestBank.') ).

fof(kb_SUMO_4148,axiom,
    s__instance(s__ShaveiShomronWestBank,s__City) ).

fof(kb_SUMO_4149,axiom,
    s__documentation(s__ShaveiShomronWestBank,s__EnglishLanguage,'The &%City of &%ShaveiShomron in &%WestBank.') ).

fof(kb_SUMO_4150,axiom,
    s__instance(s__SheikhAjlunGazaStrip,s__City) ).

fof(kb_SUMO_4151,axiom,
    s__documentation(s__SheikhAjlunGazaStrip,s__EnglishLanguage,'The &%City of &%SheikhAjlun in &%GazaStrip.') ).

fof(kb_SUMO_4152,axiom,
    s__instance(s__ShiloWestBank,s__City) ).

fof(kb_SUMO_4153,axiom,
    s__documentation(s__ShiloWestBank,s__EnglishLanguage,'The &%City of &%Shilo in &%WestBank.') ).

fof(kb_SUMO_4154,axiom,
    s__instance(s__ShimiEcuador,s__City) ).

fof(kb_SUMO_4155,axiom,
    s__documentation(s__ShimiEcuador,s__EnglishLanguage,'The &%City of &%Shimi in &%Ecuador.') ).

fof(kb_SUMO_4156,axiom,
    s__instance(s__ShlomiIsrael,s__City) ).

fof(kb_SUMO_4157,axiom,
    s__documentation(s__ShlomiIsrael,s__EnglishLanguage,'The &%City of &%Shlomi in &%Israel.') ).

fof(kb_SUMO_4158,axiom,
    s__instance(s__SidiHalifahLibya,s__City) ).

fof(kb_SUMO_4159,axiom,
    s__documentation(s__SidiHalifahLibya,s__EnglishLanguage,'The &%City of &%SidiHalifah in &%Libya.') ).

fof(kb_SUMO_4160,axiom,
    s__instance(s__SidonLebanon,s__City) ).

fof(kb_SUMO_4161,axiom,
    s__documentation(s__SidonLebanon,s__EnglishLanguage,'The &%City of &%Sidon in &%Lebanon.') ).

fof(kb_SUMO_4162,axiom,
    s__instance(s__SiirtTurkey,s__City) ).

fof(kb_SUMO_4163,axiom,
    s__documentation(s__SiirtTurkey,s__EnglishLanguage,'The &%City of &%Siirt in &%Turkey.') ).

fof(kb_SUMO_4164,axiom,
    s__instance(s__SilatADaharWestBank,s__City) ).

fof(kb_SUMO_4165,axiom,
    s__documentation(s__SilatADaharWestBank,s__EnglishLanguage,'The &%City of &%SilatADahar in &%WestBank.') ).

fof(kb_SUMO_4166,axiom,
    s__instance(s__Sitra,s__City) ).

fof(kb_SUMO_4167,axiom,
    s__documentation(s__Sitra,s__EnglishLanguage,'The &%City of Sitra.') ).

fof(kb_SUMO_4168,axiom,
    s__instance(s__SitrahBahrain,s__City) ).

fof(kb_SUMO_4169,axiom,
    s__documentation(s__SitrahBahrain,s__EnglishLanguage,'The &%City of &%Sitrah in &%Bahrain.') ).

fof(kb_SUMO_4170,axiom,
    s__instance(s__SoporeIndia,s__City) ).

fof(kb_SUMO_4171,axiom,
    s__documentation(s__SoporeIndia,s__EnglishLanguage,'The &%City of &%Sopore in &%India.') ).

fof(kb_SUMO_4172,axiom,
    s__instance(s__SrinagarIndia,s__City) ).

fof(kb_SUMO_4173,axiom,
    s__documentation(s__SrinagarIndia,s__EnglishLanguage,'The &%City of &%Srinagar in &%India.') ).

fof(kb_SUMO_4174,axiom,
    s__instance(s__SrinigarIndia,s__City) ).

fof(kb_SUMO_4175,axiom,
    s__documentation(s__SrinigarIndia,s__EnglishLanguage,'The &%City of &%Srinigar in &%India.') ).

fof(kb_SUMO_4176,axiom,
    s__instance(s__SriperumbudurIndia,s__City) ).

fof(kb_SUMO_4177,axiom,
    s__documentation(s__SriperumbudurIndia,s__EnglishLanguage,'The &%City of &%Sriperumbudur in &%India.') ).

fof(kb_SUMO_4178,axiom,
    s__instance(s__StewartstownNorthernIreland,s__City) ).

fof(kb_SUMO_4179,axiom,
    s__documentation(s__StewartstownNorthernIreland,s__EnglishLanguage,'The &%City of &%Stewartstown in &%NorthernIreland.') ).

fof(kb_SUMO_4180,axiom,
    s__instance(s__StockholmSweden,s__City) ).

fof(kb_SUMO_4181,axiom,
    s__documentation(s__StockholmSweden,s__EnglishLanguage,'The &%City of &%Stockholm in &%Sweden.') ).

fof(kb_SUMO_4182,axiom,
    s__instance(s__StrasbourgFrance,s__City) ).

fof(kb_SUMO_4183,axiom,
    s__documentation(s__StrasbourgFrance,s__EnglishLanguage,'The &%City of &%Strasbourg in &%France.') ).

fof(kb_SUMO_4184,axiom,
    s__instance(s__SukaiManiyah,s__City) ).

fof(kb_SUMO_4185,axiom,
    s__documentation(s__SukaiManiyah,s__EnglishLanguage,'The &%City of SukaiManiyah.') ).

fof(kb_SUMO_4186,axiom,
    s__instance(s__SulawesiIndonesia,s__City) ).

fof(kb_SUMO_4187,axiom,
    s__documentation(s__SulawesiIndonesia,s__EnglishLanguage,'The &%City of &%Sulawesi in &%Indonesia.') ).

fof(kb_SUMO_4188,axiom,
    s__instance(s__SulaymaniyahIraq,s__City) ).

fof(kb_SUMO_4189,axiom,
    s__documentation(s__SulaymaniyahIraq,s__EnglishLanguage,'The &%City of &%Sulaymaniyah in &%Iraq.') ).

fof(kb_SUMO_4190,axiom,
    s__instance(s__SumayrYemen,s__City) ).

fof(kb_SUMO_4191,axiom,
    s__documentation(s__SumayrYemen,s__EnglishLanguage,'The &%City of &%Sumayr in &%Yemen.') ).

fof(kb_SUMO_4192,axiom,
    s__instance(s__SusiyaWestBank,s__City) ).

fof(kb_SUMO_4193,axiom,
    s__documentation(s__SusiyaWestBank,s__EnglishLanguage,'The &%City of &%Susiya in &%WestBank.') ).

fof(kb_SUMO_4194,axiom,
    s__instance(s__TBilisiGeorgia,s__City) ).

fof(kb_SUMO_4195,axiom,
    s__documentation(s__TBilisiGeorgia,s__EnglishLanguage,'The &%City of &%TBilisi in &%RepublicOfGeorgia.') ).

fof(kb_SUMO_4196,axiom,
    s__instance(s__TailaPakistan,s__City) ).

fof(kb_SUMO_4197,axiom,
    s__documentation(s__TailaPakistan,s__EnglishLanguage,'The &%City of &%Taila in &%Pakistan.') ).

fof(kb_SUMO_4198,axiom,
    s__instance(s__TamezGuidaAlgeria,s__City) ).

fof(kb_SUMO_4199,axiom,
    s__documentation(s__TamezGuidaAlgeria,s__EnglishLanguage,'The &%City of &%TamezGuida in &%Algeria.') ).

fof(kb_SUMO_4200,axiom,
    s__instance(s__TandySriLanka,s__City) ).

fof(kb_SUMO_4201,axiom,
    s__documentation(s__TandySriLanka,s__EnglishLanguage,'The &%City of &%Tandy in &%SriLanka.') ).

fof(kb_SUMO_4202,axiom,
    s__instance(s__TaxilaPakistan,s__City) ).

fof(kb_SUMO_4203,axiom,
    s__documentation(s__TaxilaPakistan,s__EnglishLanguage,'The &%City of &%Taxila in &%Pakistan.') ).

fof(kb_SUMO_4204,axiom,
    s__instance(s__TegucigalpaHonduras,s__City) ).

fof(kb_SUMO_4205,axiom,
    s__documentation(s__TegucigalpaHonduras,s__EnglishLanguage,'The &%City of &%Tegucigalpa in &%Honduras.') ).

fof(kb_SUMO_4206,axiom,
    s__instance(s__TeheranIran,s__City) ).

fof(kb_SUMO_4207,axiom,
    s__documentation(s__TeheranIran,s__EnglishLanguage,'The &%City of &%Teheran in &%Iran.') ).

fof(kb_SUMO_4208,axiom,
    s__instance(s__Tehran,s__City) ).

fof(kb_SUMO_4209,axiom,
    s__documentation(s__Tehran,s__EnglishLanguage,'The &%City of Tehran.') ).

fof(kb_SUMO_4210,axiom,
    s__instance(s__TekoaWestBank,s__City) ).

fof(kb_SUMO_4211,axiom,
    s__documentation(s__TekoaWestBank,s__EnglishLanguage,'The &%City of &%Tekoa in &%WestBank.') ).

fof(kb_SUMO_4212,axiom,
    s__instance(s__TelAvivIsrael,s__City) ).

fof(kb_SUMO_4213,axiom,
    s__documentation(s__TelAvivIsrael,s__EnglishLanguage,'The &%City of &%TelAviv in &%Israel.') ).

fof(kb_SUMO_4214,axiom,
    s__instance(s__TelQateifaGazaStrip,s__City) ).

fof(kb_SUMO_4215,axiom,
    s__documentation(s__TelQateifaGazaStrip,s__EnglishLanguage,'The &%City of &%TelQateifa in &%GazaStrip.') ).

fof(kb_SUMO_4216,axiom,
    s__instance(s__TelRumeiydaIsrael,s__City) ).

fof(kb_SUMO_4217,axiom,
    s__documentation(s__TelRumeiydaIsrael,s__EnglishLanguage,'The &%City of &%TelRumeiyda in &%Israel.') ).

fof(kb_SUMO_4218,axiom,
    s__instance(s__TelemIsrael,s__City) ).

fof(kb_SUMO_4219,axiom,
    s__documentation(s__TelemIsrael,s__EnglishLanguage,'The &%City of &%Telem in &%Israel.') ).

fof(kb_SUMO_4220,axiom,
    s__instance(s__TenaWestBank,s__City) ).

fof(kb_SUMO_4221,axiom,
    s__documentation(s__TenaWestBank,s__EnglishLanguage,'The &%City of &%Tena in &%WestBank.') ).

fof(kb_SUMO_4222,axiom,
    s__instance(s__TheHagueNetherlands,s__City) ).

fof(kb_SUMO_4223,axiom,
    s__documentation(s__TheHagueNetherlands,s__EnglishLanguage,'The &%City of &%TheHague in &%Netherlands.') ).

fof(kb_SUMO_4224,axiom,
    s__instance(s__ThekraguriIndia,s__City) ).

fof(kb_SUMO_4225,axiom,
    s__documentation(s__ThekraguriIndia,s__EnglishLanguage,'The &%City of &%Thekraguri in &%India.') ).

fof(kb_SUMO_4226,axiom,
    s__instance(s__TiaretAlgeria,s__City) ).

fof(kb_SUMO_4227,axiom,
    s__documentation(s__TiaretAlgeria,s__EnglishLanguage,'The &%City of &%Tiaret in &%Algeria.') ).

fof(kb_SUMO_4228,axiom,
    s__instance(s__TiratAlgeria,s__City) ).

fof(kb_SUMO_4229,axiom,
    s__documentation(s__TiratAlgeria,s__EnglishLanguage,'The &%City of &%Tirat in &%Algeria.') ).

fof(kb_SUMO_4230,axiom,
    s__instance(s__TokyoJapan,s__City) ).

fof(kb_SUMO_4231,axiom,
    s__capitalCity(s__TokyoJapan,s__Japan) ).

fof(kb_SUMO_4232,axiom,
    s__documentation(s__TokyoJapan,s__EnglishLanguage,'The capital and largest City in Japan.') ).

fof(kb_SUMO_4233,axiom,
    s__instance(s__TolosaSpain,s__City) ).

fof(kb_SUMO_4234,axiom,
    s__documentation(s__TolosaSpain,s__EnglishLanguage,'The &%City of &%Tolosa in &%Spain.') ).

fof(kb_SUMO_4235,axiom,
    s__instance(s__TopkakiTurkey,s__City) ).

fof(kb_SUMO_4236,axiom,
    s__documentation(s__TopkakiTurkey,s__EnglishLanguage,'The &%City of &%Topkaki in &%Turkey.') ).

fof(kb_SUMO_4237,axiom,
    s__instance(s__TrabzonTurkey,s__City) ).

fof(kb_SUMO_4238,axiom,
    s__documentation(s__TrabzonTurkey,s__EnglishLanguage,'The &%City of &%Trabzon in &%Turkey.') ).

fof(kb_SUMO_4239,axiom,
    s__instance(s__TripoliLibya,s__City) ).

fof(kb_SUMO_4240,axiom,
    s__documentation(s__TripoliLibya,s__EnglishLanguage,'The &%City of &%Tripoli in &%Libya.') ).

fof(kb_SUMO_4241,axiom,
    s__instance(s__TulkaremWestBank,s__City) ).

fof(kb_SUMO_4242,axiom,
    s__documentation(s__TulkaremWestBank,s__EnglishLanguage,'The &%City of &%Tulkarem in &%WestBank.') ).

fof(kb_SUMO_4243,axiom,
    s__instance(s__TulkarmWestBank,s__City) ).

fof(kb_SUMO_4244,axiom,
    s__documentation(s__TulkarmWestBank,s__EnglishLanguage,'The &%City of &%Tulkarm in &%WestBank.') ).

fof(kb_SUMO_4245,axiom,
    s__instance(s__TunceliTurkey,s__City) ).

fof(kb_SUMO_4246,axiom,
    s__documentation(s__TunceliTurkey,s__EnglishLanguage,'The &%City of &%Tunceli in &%Turkey.') ).

fof(kb_SUMO_4247,axiom,
    s__instance(s__TurbatPakistan,s__City) ).

fof(kb_SUMO_4248,axiom,
    s__documentation(s__TurbatPakistan,s__EnglishLanguage,'The &%City of &%Turbat in &%Pakistan.') ).

fof(kb_SUMO_4249,axiom,
    s__instance(s__UmAlFahmIsrael,s__City) ).

fof(kb_SUMO_4250,axiom,
    s__documentation(s__UmAlFahmIsrael,s__EnglishLanguage,'The &%City of &%UmAlFahm in &%Israel.') ).

fof(kb_SUMO_4251,axiom,
    s__instance(s__UmmQasrIraq,s__City) ).

fof(kb_SUMO_4252,axiom,
    s__documentation(s__UmmQasrIraq,s__EnglishLanguage,'The &%City of &%UmmQasr in &%Iraq.') ).

fof(kb_SUMO_4253,axiom,
    s__instance(s__UrenaVenezuela,s__City) ).

fof(kb_SUMO_4254,axiom,
    s__documentation(s__UrenaVenezuela,s__EnglishLanguage,'The &%City of &%Urena in &%Venezuela.') ).

fof(kb_SUMO_4255,axiom,
    s__instance(s__UrraColombia,s__City) ).

fof(kb_SUMO_4256,axiom,
    s__documentation(s__UrraColombia,s__EnglishLanguage,'The &%City of &%Urra in &%Colombia.') ).

fof(kb_SUMO_4257,axiom,
    s__instance(s__UrsMartanRussia,s__City) ).

fof(kb_SUMO_4258,axiom,
    s__documentation(s__UrsMartanRussia,s__EnglishLanguage,'The &%City of &%UrsMartan in &%Russia.') ).

fof(kb_SUMO_4259,axiom,
    s__instance(s__ValenciaSpain,s__City) ).

fof(kb_SUMO_4260,axiom,
    s__documentation(s__ValenciaSpain,s__EnglishLanguage,'The &%City of &%Valencia in &%Spain.') ).

fof(kb_SUMO_4261,axiom,
    s__instance(s__ValleduparColombia,s__City) ).

fof(kb_SUMO_4262,axiom,
    s__documentation(s__ValleduparColombia,s__EnglishLanguage,'The &%City of &%Valledupar in &%Colombia.') ).

fof(kb_SUMO_4263,axiom,
    s__instance(s__VanTurkey,s__City) ).

fof(kb_SUMO_4264,axiom,
    s__documentation(s__VanTurkey,s__EnglishLanguage,'The &%City of &%Van in &%Turkey.') ).

fof(kb_SUMO_4265,axiom,
    s__instance(s__VavuniyaSriLanka,s__City) ).

fof(kb_SUMO_4266,axiom,
    s__documentation(s__VavuniyaSriLanka,s__EnglishLanguage,'The &%City of &%Vavuniya in &%SriLanka.') ).

fof(kb_SUMO_4267,axiom,
    s__instance(s__ViennaAustria,s__City) ).

fof(kb_SUMO_4268,axiom,
    s__documentation(s__ViennaAustria,s__EnglishLanguage,'The &%City of &%Vienna in &%Austria.') ).

fof(kb_SUMO_4269,axiom,
    s__instance(s__VientianeLaos,s__City) ).

fof(kb_SUMO_4270,axiom,
    s__documentation(s__VientianeLaos,s__EnglishLanguage,'The &%City of &%Vientiane in &%Laos.') ).

fof(kb_SUMO_4271,axiom,
    s__instance(s__VillavicencioColombia,s__City) ).

fof(kb_SUMO_4272,axiom,
    s__documentation(s__VillavicencioColombia,s__EnglishLanguage,'The &%City of &%Villavicencio in &%Colombia.') ).

fof(kb_SUMO_4273,axiom,
    s__instance(s__VitoriaSpain,s__City) ).

fof(kb_SUMO_4274,axiom,
    s__documentation(s__VitoriaSpain,s__EnglishLanguage,'The &%City of &%Vitoria in &%Spain.') ).

fof(kb_SUMO_4275,axiom,
    s__instance(s__VitrollesFrance,s__City) ).

fof(kb_SUMO_4276,axiom,
    s__documentation(s__VitrollesFrance,s__EnglishLanguage,'The &%City of &%Vitrolles in &%France.') ).

fof(kb_SUMO_4277,axiom,
    s__instance(s__VladikavkazRussia,s__City) ).

fof(kb_SUMO_4278,axiom,
    s__documentation(s__VladikavkazRussia,s__EnglishLanguage,'The &%City of &%Vladikavkaz in &%Russia.') ).

fof(kb_SUMO_4279,axiom,
    s__instance(s__VladivostokRussia,s__City) ).

fof(kb_SUMO_4280,axiom,
    s__documentation(s__VladivostokRussia,s__EnglishLanguage,'The &%City of &%Vladivostok in &%Russia.') ).

fof(kb_SUMO_4281,axiom,
    s__instance(s__VolgodonskRussia,s__City) ).

fof(kb_SUMO_4282,axiom,
    s__documentation(s__VolgodonskRussia,s__EnglishLanguage,'The &%City of &%Volgodonsk in &%Russia.') ).

fof(kb_SUMO_4283,axiom,
    s__instance(s__WadiAlDabaatYemen,s__City) ).

fof(kb_SUMO_4284,axiom,
    s__documentation(s__WadiAlDabaatYemen,s__EnglishLanguage,'The &%City of &%WadiAlDabaat in &%Yemen.') ).

fof(kb_SUMO_4285,axiom,
    s__instance(s__WadiAraIsrael,s__City) ).

fof(kb_SUMO_4286,axiom,
    s__documentation(s__WadiAraIsrael,s__EnglishLanguage,'The &%City of &%WadiAra in &%Israel.') ).

fof(kb_SUMO_4287,axiom,
    s__instance(s__WadiKeltWestBank,s__City) ).

fof(kb_SUMO_4288,axiom,
    s__documentation(s__WadiKeltWestBank,s__EnglishLanguage,'The &%City of &%WadiKelt in &%WestBank.') ).

fof(kb_SUMO_4289,axiom,
    s__instance(s__WashingtonDCUnitedStates,s__AmericanCity) ).

fof(kb_SUMO_4290,axiom,
    s__documentation(s__WashingtonDCUnitedStates,s__EnglishLanguage,'The &%capitalCity of the &%UnitedStates.') ).

fof(kb_SUMO_4291,axiom,
    s__instance(s__WattyanBahrain,s__City) ).

fof(kb_SUMO_4292,axiom,
    s__documentation(s__WattyanBahrain,s__EnglishLanguage,'The &%City of &%Wattyan in &%Bahrain.') ).

fof(kb_SUMO_4293,axiom,
    s__instance(s__WestBeirutLebanon,s__City) ).

fof(kb_SUMO_4294,axiom,
    s__documentation(s__WestBeirutLebanon,s__EnglishLanguage,'The &%City of &%WestBeirut in &%Lebanon.') ).

fof(kb_SUMO_4295,axiom,
    s__instance(s__XiAnChina,s__City) ).

fof(kb_SUMO_4296,axiom,
    s__documentation(s__XiAnChina,s__EnglishLanguage,'The &%City of &%XiAn in &%China.') ).

fof(kb_SUMO_4297,axiom,
    s__instance(s__YaAbadWestBank,s__City) ).

fof(kb_SUMO_4298,axiom,
    s__documentation(s__YaAbadWestBank,s__EnglishLanguage,'The &%City of &%YaAbad in &%WestBank.') ).

fof(kb_SUMO_4299,axiom,
    s__instance(s__YagurJunctionIsrael,s__City) ).

fof(kb_SUMO_4300,axiom,
    s__documentation(s__YagurJunctionIsrael,s__EnglishLanguage,'The &%City of &%YagurJunction in &%Israel.') ).

fof(kb_SUMO_4301,axiom,
    s__instance(s__YehudIsrael,s__City) ).

fof(kb_SUMO_4302,axiom,
    s__documentation(s__YehudIsrael,s__EnglishLanguage,'The &%City of &%Yehud in &%Israel.') ).

fof(kb_SUMO_4303,axiom,
    s__instance(s__YerevanArmenia,s__City) ).

fof(kb_SUMO_4304,axiom,
    s__documentation(s__YerevanArmenia,s__EnglishLanguage,'The &%City of &%Yerevan in &%Armenia.') ).

fof(kb_SUMO_4305,axiom,
    s__instance(s__YitzharWestBank,s__City) ).

fof(kb_SUMO_4306,axiom,
    s__documentation(s__YitzharWestBank,s__EnglishLanguage,'The &%City of &%Yitzhar in &%WestBank.') ).

fof(kb_SUMO_4307,axiom,
    s__instance(s__YokotaJapan,s__City) ).

fof(kb_SUMO_4308,axiom,
    s__documentation(s__YokotaJapan,s__EnglishLanguage,'The &%City of &%Yokota in &%Japan.') ).

fof(kb_SUMO_4309,axiom,
    s__instance(s__YopalColombia,s__City) ).

fof(kb_SUMO_4310,axiom,
    s__documentation(s__YopalColombia,s__EnglishLanguage,'The &%City of &%Yopal in &%Colombia.') ).

fof(kb_SUMO_4311,axiom,
    s__instance(s__YuksekovaTurkey,s__City) ).

fof(kb_SUMO_4312,axiom,
    s__documentation(s__YuksekovaTurkey,s__EnglishLanguage,'The &%City of &%Yuksekova in &%Turkey.') ).

fof(kb_SUMO_4313,axiom,
    s__instance(s__ZaitaIsrael,s__City) ).

fof(kb_SUMO_4314,axiom,
    s__documentation(s__ZaitaIsrael,s__EnglishLanguage,'The &%City of &%Zaita in &%Israel.') ).

fof(kb_SUMO_4315,axiom,
    s__instance(s__ZamarYemen,s__City) ).

fof(kb_SUMO_4316,axiom,
    s__documentation(s__ZamarYemen,s__EnglishLanguage,'The &%City of &%Zamar in &%Yemen.') ).

fof(kb_SUMO_4317,axiom,
    s__instance(s__ZamboangaPhilippines,s__City) ).

fof(kb_SUMO_4318,axiom,
    s__documentation(s__ZamboangaPhilippines,s__EnglishLanguage,'The &%City of &%Zamboanga in &%Philippines.') ).

fof(kb_SUMO_4319,axiom,
    s__instance(s__ZamboangoPhilippines,s__City) ).

fof(kb_SUMO_4320,axiom,
    s__documentation(s__ZamboangoPhilippines,s__EnglishLanguage,'The &%City of &%Zamboango in &%Philippines.') ).

fof(kb_SUMO_4321,axiom,
    s__instance(s__ZaragozaSpain,s__City) ).

fof(kb_SUMO_4322,axiom,
    s__documentation(s__ZaragozaSpain,s__EnglishLanguage,'The &%City of &%Zaragoza in &%Spain.') ).

fof(kb_SUMO_4323,axiom,
    s__instance(s__ZarauzSpain,s__City) ).

fof(kb_SUMO_4324,axiom,
    s__documentation(s__ZarauzSpain,s__EnglishLanguage,'The &%City of &%Zarauz in &%Spain.') ).

fof(kb_SUMO_4325,axiom,
    s__instance(s__ZekharyaIsrael,s__City) ).

fof(kb_SUMO_4326,axiom,
    s__documentation(s__ZekharyaIsrael,s__EnglishLanguage,'The &%City of &%Zekharya in &%Israel.') ).

fof(kb_SUMO_4327,axiom,
    s__instance(s__ZuliaColombia,s__City) ).

fof(kb_SUMO_4328,axiom,
    s__documentation(s__ZuliaColombia,s__EnglishLanguage,'The &%City of &%Zulia in &%Colombia.') ).

fof(kb_SUMO_4329,axiom,
    s__instance(s__ZumaiaSpain,s__City) ).

fof(kb_SUMO_4330,axiom,
    s__documentation(s__ZumaiaSpain,s__EnglishLanguage,'The &%City of &%Zumaia in &%Spain.') ).

fof(kb_SUMO_4331,axiom,
    s__instance(s__ZumarragaSpain,s__City) ).

fof(kb_SUMO_4332,axiom,
    s__documentation(s__ZumarragaSpain,s__EnglishLanguage,'The &%City of &%Zumarraga in &%Spain.') ).

fof(kb_SUMO_4333,axiom,
    s__instance(s__ZvornikBosniaAndHerzegovina,s__City) ).

fof(kb_SUMO_4334,axiom,
    s__documentation(s__ZvornikBosniaAndHerzegovina,s__EnglishLanguage,'The &%City of &%Zvornik in &%BosniaAndHerzegovina.') ).

fof(kb_SUMO_4335,axiom,
    s__geographicSubregion(s__AdanaTurkey,s__Turkey) ).

fof(kb_SUMO_4336,axiom,
    s__names('Adana',s__AdanaTurkey) ).

fof(kb_SUMO_4337,axiom,
    s__geographicSubregion(s__AddisAbabaEthiopia,s__Ethiopia) ).

fof(kb_SUMO_4338,axiom,
    s__names('Addis Ababa',s__AddisAbabaEthiopia) ).

fof(kb_SUMO_4339,axiom,
    s__geographicSubregion(s__AdenYemen,s__Yemen) ).

fof(kb_SUMO_4340,axiom,
    s__names('Aden',s__AdenYemen) ).

fof(kb_SUMO_4341,axiom,
    s__geographicSubregion(s__AdoraWestBank,s__WestBank) ).

fof(kb_SUMO_4342,axiom,
    s__names('Adora',s__AdoraWestBank) ).

fof(kb_SUMO_4343,axiom,
    s__geographicSubregion(s__AfulaIsrael,s__Israel) ).

fof(kb_SUMO_4344,axiom,
    s__names('Afula',s__AfulaIsrael) ).

fof(kb_SUMO_4345,axiom,
    s__geographicSubregion(s__AgriTurkey,s__Turkey) ).

fof(kb_SUMO_4346,axiom,
    s__names('Agri',s__AgriTurkey) ).

fof(kb_SUMO_4347,axiom,
    s__geographicSubregion(s__AinDeflaAlgeria,s__Algeria) ).

fof(kb_SUMO_4348,axiom,
    s__names('Ain Defla',s__AinDeflaAlgeria) ).

fof(kb_SUMO_4349,axiom,
    s__geographicSubregion(s__AinElHajarAlgeria,s__Algeria) ).

fof(kb_SUMO_4350,axiom,
    s__names('Ain el Hajar',s__AinElHajarAlgeria) ).

fof(kb_SUMO_4351,axiom,
    s__geographicSubregion(s__AjaccioFrance,s__France) ).

fof(kb_SUMO_4352,axiom,
    s__names('Ajaccio',s__AjaccioFrance) ).

fof(kb_SUMO_4353,axiom,
    s__geographicSubregion(s__AlBalamandLebanon,s__Lebanon) ).

fof(kb_SUMO_4354,axiom,
    s__names('Al-Balamand ',s__AlBalamandLebanon) ).

fof(kb_SUMO_4355,axiom,
    s__geographicSubregion(s__AleiSinaiGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4356,axiom,
    s__names('Alei Sinai',s__AleiSinaiGazaStrip) ).

fof(kb_SUMO_4357,axiom,
    s__geographicSubregion(s__AleiZahavWestBank,s__WestBank) ).

fof(kb_SUMO_4358,axiom,
    s__names('Alei Zahav',s__AleiZahavWestBank) ).

fof(kb_SUMO_4359,axiom,
    s__geographicSubregion(s__AleyLebanon,s__Lebanon) ).

fof(kb_SUMO_4360,axiom,
    s__names('Aley',s__AleyLebanon) ).

fof(kb_SUMO_4361,axiom,
    s__geographicSubregion(s__AlgiersAlgeria,s__Algeria) ).

fof(kb_SUMO_4362,axiom,
    s__names('Algiers',s__AlgiersAlgeria) ).

fof(kb_SUMO_4363,axiom,
    s__geographicSubregion(s__AlkhanYurtRussia,s__Russia) ).

fof(kb_SUMO_4364,axiom,
    s__names('Alkhan-Yurt',s__AlkhanYurtRussia) ).

fof(kb_SUMO_4365,axiom,
    s__geographicSubregion(s__AlonMorehWestBank,s__WestBank) ).

fof(kb_SUMO_4366,axiom,
    s__names('Alon Moreh',s__AlonMorehWestBank) ).

fof(kb_SUMO_4367,axiom,
    s__geographicSubregion(s__AmbonIndonesia,s__Indonesia) ).

fof(kb_SUMO_4368,axiom,
    s__names('Ambon',s__AmbonIndonesia) ).

fof(kb_SUMO_4369,axiom,
    s__geographicSubregion(s__AmmanJordan,s__Jordan) ).

fof(kb_SUMO_4370,axiom,
    s__names('Amman',s__AmmanJordan) ).

fof(kb_SUMO_4371,axiom,
    s__geographicSubregion(s__AnNuwaydiratBahrain,s__Bahrain) ).

fof(kb_SUMO_4372,axiom,
    s__names('An Nuwaydirat',s__AnNuwaydiratBahrain) ).

fof(kb_SUMO_4373,axiom,
    s__geographicSubregion(s__AndeanSpain,s__Spain) ).

fof(kb_SUMO_4374,axiom,
    s__names('Andean',s__AndeanSpain) ).

fof(kb_SUMO_4375,axiom,
    s__geographicSubregion(s__AngkorWatCambodia,s__Cambodia) ).

fof(kb_SUMO_4376,axiom,
    s__names('Angkor Wat ',s__AngkorWatCambodia) ).

fof(kb_SUMO_4377,axiom,
    s__geographicSubregion(s__AnkaraTurkey,s__Turkey) ).

fof(kb_SUMO_4378,axiom,
    s__names('Ankara',s__AnkaraTurkey) ).

fof(kb_SUMO_4379,axiom,
    s__geographicSubregion(s__AntalyaTurkey,s__Turkey) ).

fof(kb_SUMO_4380,axiom,
    s__names('Antalya',s__AntalyaTurkey) ).

fof(kb_SUMO_4381,axiom,
    s__geographicSubregion(s__AntioquiaColombia,s__ColombiaPanama) ).

fof(kb_SUMO_4382,axiom,
    s__names('Antioquia',s__AntioquiaColombia) ).

fof(kb_SUMO_4383,axiom,
    s__geographicSubregion(s__AntwerpBelgium,s__Belgium) ).

fof(kb_SUMO_4384,axiom,
    s__names('Antwerp',s__AntwerpBelgium) ).

fof(kb_SUMO_4385,axiom,
    s__geographicSubregion(s__ApumiracPeru,s__Peru) ).

fof(kb_SUMO_4386,axiom,
    s__names('Apumirac',s__ApumiracPeru) ).

fof(kb_SUMO_4387,axiom,
    s__geographicSubregion(s__ApureVenezuela,s__Venezuela) ).

fof(kb_SUMO_4388,axiom,
    s__names('Apure',s__ApureVenezuela) ).

fof(kb_SUMO_4389,axiom,
    s__geographicSubregion(s__AraucaColombia,s__ColombiaPanama) ).

fof(kb_SUMO_4390,axiom,
    s__names('Arauca',s__AraucaColombia) ).

fof(kb_SUMO_4391,axiom,
    s__geographicSubregion(s__ArgunRussia,s__Russia) ).

fof(kb_SUMO_4392,axiom,
    s__names('Argun',s__ArgunRussia) ).

fof(kb_SUMO_4393,axiom,
    s__geographicSubregion(s__ArielWestBank,s__WestBank) ).

fof(kb_SUMO_4394,axiom,
    s__names('Ariel',s__ArielWestBank) ).

fof(kb_SUMO_4395,axiom,
    s__geographicSubregion(s__ArmaghNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_4396,axiom,
    s__names('Armagh',s__ArmaghNorthernIreland) ).

fof(kb_SUMO_4397,axiom,
    s__geographicSubregion(s__ArzewAlgeria,s__Algeria) ).

fof(kb_SUMO_4398,axiom,
    s__names('Arzew',s__ArzewAlgeria) ).

fof(kb_SUMO_4399,axiom,
    s__geographicSubregion(s__AshdodIsrael,s__Israel) ).

fof(kb_SUMO_4400,axiom,
    s__names('Ashdod',s__AshdodIsrael) ).

fof(kb_SUMO_4401,axiom,
    s__geographicSubregion(s__AskelonIsrael,s__Israel) ).

fof(kb_SUMO_4402,axiom,
    s__names('Askelon',s__AskelonIsrael) ).

fof(kb_SUMO_4403,axiom,
    s__geographicSubregion(s__AsmaraEritrea,s__Eritrea) ).

fof(kb_SUMO_4404,axiom,
    s__names('Asmara',s__AsmaraEritrea) ).

fof(kb_SUMO_4405,axiom,
    s__geographicSubregion(s__AssamIndia,s__India) ).

fof(kb_SUMO_4406,axiom,
    s__names('Assam',s__AssamIndia) ).

fof(kb_SUMO_4407,axiom,
    s__geographicSubregion(s__AswanEgypt,s__Egypt) ).

fof(kb_SUMO_4408,axiom,
    s__names('Aswan',s__AswanEgypt) ).

fof(kb_SUMO_4409,axiom,
    s__geographicSubregion(s__AsyutEgypt,s__Egypt) ).

fof(kb_SUMO_4410,axiom,
    s__names('Asyut',s__AsyutEgypt) ).

fof(kb_SUMO_4411,axiom,
    s__geographicSubregion(s__AthensGreece,s__Greece) ).

fof(kb_SUMO_4412,axiom,
    s__names('Athens',s__AthensGreece) ).

fof(kb_SUMO_4413,axiom,
    s__geographicSubregion(s__AtrushIraq,s__Iraq) ).

fof(kb_SUMO_4414,axiom,
    s__names('Atrush',s__AtrushIraq) ).

fof(kb_SUMO_4415,axiom,
    s__geographicSubregion(s__AtzmonaGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4416,axiom,
    s__names('Atzmona',s__AtzmonaGazaStrip) ).

fof(kb_SUMO_4417,axiom,
    s__geographicSubregion(s__AvneiHefetzIsrael,s__Israel) ).

fof(kb_SUMO_4418,axiom,
    s__names('Avnei Hefetz',s__AvneiHefetzIsrael) ).

fof(kb_SUMO_4419,axiom,
    s__geographicSubregion(s__AyacuchoPeru,s__Peru) ).

fof(kb_SUMO_4420,axiom,
    s__names('Ayacucho',s__AyacuchoPeru) ).

fof(kb_SUMO_4421,axiom,
    s__geographicSubregion(s__AzorIsrael,s__Israel) ).

fof(kb_SUMO_4422,axiom,
    s__names('Azor',s__AzorIsrael) ).

fof(kb_SUMO_4423,axiom,
    s__geographicSubregion(s__BadVilbelGermany,s__Germany) ).

fof(kb_SUMO_4424,axiom,
    s__names('Bad Vilbel',s__BadVilbelGermany) ).

fof(kb_SUMO_4425,axiom,
    s__geographicSubregion(s__BaghdadIraq,s__Iraq) ).

fof(kb_SUMO_4426,axiom,
    s__names('Baghdad',s__BaghdadIraq) ).

fof(kb_SUMO_4427,axiom,
    s__geographicSubregion(s__BagreColombia,s__ColombiaPanama) ).

fof(kb_SUMO_4428,axiom,
    s__names('Bagre',s__BagreColombia) ).

fof(kb_SUMO_4429,axiom,
    s__geographicSubregion(s__BahawalpurPakistan,s__Pakistan) ).

fof(kb_SUMO_4430,axiom,
    s__names('Bahawalpur',s__BahawalpurPakistan) ).

fof(kb_SUMO_4431,axiom,
    s__geographicSubregion(s__BakaAlGarbiyehIsrael,s__Israel) ).

fof(kb_SUMO_4432,axiom,
    s__names('Baka al-Garbiyeh',s__BakaAlGarbiyehIsrael) ).

fof(kb_SUMO_4433,axiom,
    s__geographicSubregion(s__BakkaAlSharkiyaWestBank,s__WestBank) ).

fof(kb_SUMO_4434,axiom,
    s__names('Bakka al-Sharkiya',s__BakkaAlSharkiyaWestBank) ).

fof(kb_SUMO_4435,axiom,
    s__geographicSubregion(s__BakuAzerbaijan,s__Azerbaijan) ).

fof(kb_SUMO_4436,axiom,
    s__names('Baku',s__BakuAzerbaijan) ).

fof(kb_SUMO_4437,axiom,
    s__geographicSubregion(s__BaleEthiopia,s__Ethiopia) ).

fof(kb_SUMO_4438,axiom,
    s__names('Bale',s__BaleEthiopia) ).

fof(kb_SUMO_4439,axiom,
    s__geographicSubregion(s__BanbridgeNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_4440,axiom,
    s__names('Banbridge',s__BanbridgeNorthernIreland) ).

fof(kb_SUMO_4441,axiom,
    s__geographicSubregion(s__BangkokThailand,s__Thailand) ).

fof(kb_SUMO_4442,axiom,
    s__names('Bangkok',s__BangkokThailand) ).

fof(kb_SUMO_4443,axiom,
    s__geographicSubregion(s__BangorNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_4444,axiom,
    s__names('Bangor',s__BangorNorthernIreland) ).

fof(kb_SUMO_4445,axiom,
    s__geographicSubregion(s__BanguiCentralAfricanRepublic,s__CentralAfricanRepublic) ).

fof(kb_SUMO_4446,axiom,
    s__names('Bangui',s__BanguiCentralAfricanRepublic) ).

fof(kb_SUMO_4447,axiom,
    s__geographicSubregion(s__BarcelonaSpain,s__Spain) ).

fof(kb_SUMO_4448,axiom,
    s__names('Barcelona',s__BarcelonaSpain) ).

fof(kb_SUMO_4449,axiom,
    s__geographicSubregion(s__BarkeoCambodia,s__Cambodia) ).

fof(kb_SUMO_4450,axiom,
    s__names('Barkeo',s__BarkeoCambodia) ).

fof(kb_SUMO_4451,axiom,
    s__geographicSubregion(s__BarrancabermejaColombia,s__Colombia) ).

fof(kb_SUMO_4452,axiom,
    s__names('Barrancabermeja',s__BarrancabermejaColombia) ).

fof(kb_SUMO_4453,axiom,
    s__geographicSubregion(s__BasraIsrael,s__Israel) ).

fof(kb_SUMO_4454,axiom,
    s__names('Basra',s__BasraIsrael) ).

fof(kb_SUMO_4455,axiom,
    s__geographicSubregion(s__BatYamIsrael,s__Israel) ).

fof(kb_SUMO_4456,axiom,
    s__names('Bat Yam',s__BatYamIsrael) ).

fof(kb_SUMO_4457,axiom,
    s__geographicSubregion(s__BatmanTurkey,s__Turkey) ).

fof(kb_SUMO_4458,axiom,
    s__names('Batman',s__BatmanTurkey) ).

fof(kb_SUMO_4459,axiom,
    s__geographicSubregion(s__BeasainSpain,s__Spain) ).

fof(kb_SUMO_4460,axiom,
    s__names('Beasain',s__BeasainSpain) ).

fof(kb_SUMO_4461,axiom,
    s__geographicSubregion(s__BeErShevaIsrael,s__Israel) ).

fof(kb_SUMO_4462,axiom,
    s__names('Beer Sheva',s__BeErShevaIsrael) ).

fof(kb_SUMO_4463,axiom,
    s__geographicSubregion(s__BeirutLebanon,s__Lebanon) ).

fof(kb_SUMO_4464,axiom,
    s__names('Beirut',s__BeirutLebanon) ).

fof(kb_SUMO_4465,axiom,
    s__geographicSubregion(s__BeitElWestBank,s__WestBank) ).

fof(kb_SUMO_4466,axiom,
    s__names('Beit El',s__BeitElWestBank) ).

fof(kb_SUMO_4467,axiom,
    s__geographicSubregion(s__BeitHaggaiWestBank,s__WestBank) ).

fof(kb_SUMO_4468,axiom,
    s__names('Beit Haggai',s__BeitHaggaiWestBank) ).

fof(kb_SUMO_4469,axiom,
    s__geographicSubregion(s__BeitSahurWestBank,s__WestBank) ).

fof(kb_SUMO_4470,axiom,
    s__names('Beit Sahur',s__BeitSahurWestBank) ).

fof(kb_SUMO_4471,axiom,
    s__geographicSubregion(s__BeitSheAnIsrael,s__Israel) ).

fof(kb_SUMO_4472,axiom,
    s__names('Beit Shean',s__BeitSheAnIsrael) ).

fof(kb_SUMO_4473,axiom,
    s__geographicSubregion(s__BeitShemeshIsrael,s__Israel) ).

fof(kb_SUMO_4474,axiom,
    s__names('Beit Shemesh',s__BeitShemeshIsrael) ).

fof(kb_SUMO_4475,axiom,
    s__geographicSubregion(s__BeledweyneSomalia,s__Somalia) ).

fof(kb_SUMO_4476,axiom,
    s__names('Beledweyne',s__BeledweyneSomalia) ).

fof(kb_SUMO_4477,axiom,
    s__geographicSubregion(s__BelfastNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_4478,axiom,
    s__names('Belfast',s__BelfastNorthernIreland) ).

fof(kb_SUMO_4479,axiom,
    s__geographicSubregion(s__BelgradeSerbiaAndMontenegro,s__SerbiaAndMontenegro) ).

fof(kb_SUMO_4480,axiom,
    s__names('Belgrade',s__BelgradeSerbiaAndMontenegro) ).

fof(kb_SUMO_4481,axiom,
    s__geographicSubregion(s__BerlinGermany,s__Germany) ).

fof(kb_SUMO_4482,axiom,
    s__names('Berlin',s__BerlinGermany) ).

fof(kb_SUMO_4483,axiom,
    s__geographicSubregion(s__BetLeHiyehGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4484,axiom,
    s__names('Bet LeHiyeh',s__BetLeHiyehGazaStrip) ).

fof(kb_SUMO_4485,axiom,
    s__instance(s__BetLidJunctionIsrael,s__GeographicArea) ).

fof(kb_SUMO_4486,axiom,
    s__geographicSubregion(s__BetLidJunctionIsrael,s__Israel) ).

fof(kb_SUMO_4487,axiom,
    s__names('Bet Lid Junction',s__BetLidJunctionIsrael) ).

fof(kb_SUMO_4488,axiom,
    s__geographicSubregion(s__BethElIsrael,s__Israel) ).

fof(kb_SUMO_4489,axiom,
    s__names('Beth El',s__BethElIsrael) ).

fof(kb_SUMO_4490,axiom,
    s__geographicSubregion(s__BethlehemWestBank,s__WestBank) ).

fof(kb_SUMO_4491,axiom,
    s__names('Bethlehem',s__BethlehemWestBank) ).

fof(kb_SUMO_4492,axiom,
    s__geographicSubregion(s__BidyaWestBank,s__WestBank) ).

fof(kb_SUMO_4493,axiom,
    s__names('Bidya',s__BidyaWestBank) ).

fof(kb_SUMO_4494,axiom,
    s__geographicSubregion(s__BilbaoSpain,s__Spain) ).

fof(kb_SUMO_4495,axiom,
    s__names('Bilbao',s__BilbaoSpain) ).

fof(kb_SUMO_4496,axiom,
    s__geographicSubregion(s__BillabonaSpain,s__Spain) ).

fof(kb_SUMO_4497,axiom,
    s__names('Billabona',s__BillabonaSpain) ).

fof(kb_SUMO_4498,axiom,
    s__geographicSubregion(s__BinyaminaIsrael,s__Israel) ).

fof(kb_SUMO_4499,axiom,
    s__names('Binyamina',s__BinyaminaIsrael) ).

fof(kb_SUMO_4500,axiom,
    s__geographicSubregion(s__BKaotWestBank,s__WestBank) ).

fof(kb_SUMO_4501,axiom,
    s__names('Bkaot',s__BKaotWestBank) ).

fof(kb_SUMO_4502,axiom,
    s__geographicSubregion(s__BneiAyishIsrael,s__Israel) ).

fof(kb_SUMO_4503,axiom,
    s__names('Bnei Ayish',s__BneiAyishIsrael) ).

fof(kb_SUMO_4504,axiom,
    s__geographicSubregion(s__BogotaColombia,s__Colombia) ).

fof(kb_SUMO_4505,axiom,
    s__names('Bogota',s__BogotaColombia) ).

fof(kb_SUMO_4506,axiom,
    s__geographicSubregion(s__BolognaItaly,s__Italy) ).

fof(kb_SUMO_4507,axiom,
    s__names('Bologna',s__BolognaItaly) ).

fof(kb_SUMO_4508,axiom,
    s__geographicSubregion(s__BonnGermany,s__Germany) ).

fof(kb_SUMO_4509,axiom,
    s__names('Bonn',s__BonnGermany) ).

fof(kb_SUMO_4510,axiom,
    s__instance(s__BosphorousStraitsTurkey,s__GeographicArea) ).

fof(kb_SUMO_4511,axiom,
    s__geographicSubregion(s__BosphorousStraitsTurkey,s__Turkey) ).

fof(kb_SUMO_4512,axiom,
    s__names('BosphorousStraits',s__BosphorousStraitsTurkey) ).

fof(kb_SUMO_4513,axiom,
    s__geographicSubregion(s__BouiraAlgeria,s__Algeria) ).

fof(kb_SUMO_4514,axiom,
    s__names('Bouira',s__BouiraAlgeria) ).

fof(kb_SUMO_4515,axiom,
    s__geographicSubregion(s__BouzeGueneAlgeria,s__Algeria) ).

fof(kb_SUMO_4516,axiom,
    s__names('Bouze-guene',s__BouzeGueneAlgeria) ).

fof(kb_SUMO_4517,axiom,
    s__geographicSubregion(s__BrusselsBelgium,s__Belgium) ).

fof(kb_SUMO_4518,axiom,
    s__names('Brussels',s__BrusselsBelgium) ).

fof(kb_SUMO_4519,axiom,
    s__geographicSubregion(s__BucaramangaColombia,s__Colombia) ).

fof(kb_SUMO_4520,axiom,
    s__names('Bucaramanga',s__BucaramangaColombia) ).

fof(kb_SUMO_4521,axiom,
    s__geographicSubregion(s__BucharestRomania,s__Romania) ).

fof(kb_SUMO_4522,axiom,
    s__names('Bucharest',s__BucharestRomania) ).

fof(kb_SUMO_4523,axiom,
    s__geographicSubregion(s__BuenosAiresArgentina,s__Argentina) ).

fof(kb_SUMO_4524,axiom,
    s__names('Buenos Aires',s__BuenosAiresArgentina) ).

fof(kb_SUMO_4525,axiom,
    s__geographicSubregion(s__BuinakskRussia,s__Russia) ).

fof(kb_SUMO_4526,axiom,
    s__names('Buinaksk',s__BuinakskRussia) ).

fof(kb_SUMO_4527,axiom,
    s__instance(s__BwindiforestUganda,s__GeographicArea) ).

fof(kb_SUMO_4528,axiom,
    s__geographicSubregion(s__BwindiforestUganda,s__Uganda) ).

fof(kb_SUMO_4529,axiom,
    s__names('Bwindi forest',s__BwindiforestUganda) ).

fof(kb_SUMO_4530,axiom,
    s__geographicSubregion(s__CabindaAngola,s__Angola) ).

fof(kb_SUMO_4531,axiom,
    s__names('Cabinda',s__CabindaAngola) ).

fof(kb_SUMO_4532,axiom,
    s__geographicSubregion(s__CaglayanTurkey,s__Turkey) ).

fof(kb_SUMO_4533,axiom,
    s__names('Caglayan',s__CaglayanTurkey) ).

fof(kb_SUMO_4534,axiom,
    s__geographicSubregion(s__CairoEgypt,s__Egypt) ).

fof(kb_SUMO_4535,axiom,
    s__names('Cairo',s__CairoEgypt) ).

fof(kb_SUMO_4536,axiom,
    s__geographicSubregion(s__CalcuttaIndia,s__India) ).

fof(kb_SUMO_4537,axiom,
    s__names('Calcutta',s__CalcuttaIndia) ).

fof(kb_SUMO_4538,axiom,
    s__geographicSubregion(s__CaliColombia,s__Colombia) ).

fof(kb_SUMO_4539,axiom,
    s__names('Cali',s__CaliColombia) ).

fof(kb_SUMO_4540,axiom,
    s__geographicSubregion(s__CampZamaJapan,s__Japan) ).

fof(kb_SUMO_4541,axiom,
    s__names('Camp Zama',s__CampZamaJapan) ).

fof(kb_SUMO_4542,axiom,
    s__geographicSubregion(s__CankiriTurkey,s__Turkey) ).

fof(kb_SUMO_4543,axiom,
    s__names('Cankiri',s__CankiriTurkey) ).

fof(kb_SUMO_4544,axiom,
    s__geographicSubregion(s__CapeTownSouthAfrica,s__SouthAfrica) ).

fof(kb_SUMO_4545,axiom,
    s__names('Cape Town',s__CapeTownSouthAfrica) ).

fof(kb_SUMO_4546,axiom,
    s__instance(s__CaritasPolandChechnya,s__GeographicArea) ).

fof(kb_SUMO_4547,axiom,
    s__geographicSubregion(s__CaritasPolandChechnya,s__Chechnya) ).

fof(kb_SUMO_4548,axiom,
    s__names('Caritas Poland',s__CaritasPolandChechnya) ).

fof(kb_SUMO_4549,axiom,
    s__geographicSubregion(s__CarmelIsrael,s__Israel) ).

fof(kb_SUMO_4550,axiom,
    s__names('Carmel',s__CarmelIsrael) ).

fof(kb_SUMO_4551,axiom,
    s__geographicSubregion(s__CarmenDeBolivarColombia,s__Colombia) ).

fof(kb_SUMO_4552,axiom,
    s__names('Carmen de Bolivar',s__CarmenDeBolivarColombia) ).

fof(kb_SUMO_4553,axiom,
    s__geographicSubregion(s__CarrejonColombia,s__Colombia) ).

fof(kb_SUMO_4554,axiom,
    s__names('Carrejon',s__CarrejonColombia) ).

fof(kb_SUMO_4555,axiom,
    s__geographicSubregion(s__ChamanPakistan,s__Pakistan) ).

fof(kb_SUMO_4556,axiom,
    s__names('Chaman',s__ChamanPakistan) ).

fof(kb_SUMO_4557,axiom,
    s__geographicSubregion(s__ChararESharifIndia,s__India) ).

fof(kb_SUMO_4558,axiom,
    s__names('Charar-e-Sharif ',s__ChararESharifIndia) ).

fof(kb_SUMO_4559,axiom,
    s__geographicSubregion(s__CharsaadaPakistan,s__Pakistan) ).

fof(kb_SUMO_4560,axiom,
    s__names('Charsaada',s__CharsaadaPakistan) ).

fof(kb_SUMO_4561,axiom,
    s__geographicSubregion(s__ChernoRechyeRussia,s__Russia) ).

fof(kb_SUMO_4562,axiom,
    s__names('Cherno-rechye',s__ChernoRechyeRussia) ).

fof(kb_SUMO_4563,axiom,
    s__geographicSubregion(s__ChicagoUnitedStates,s__UnitedStates) ).

fof(kb_SUMO_4564,axiom,
    s__names('Chicago',s__ChicagoUnitedStates) ).

fof(kb_SUMO_4565,axiom,
    s__geographicSubregion(s__ChisimayuSomalia,s__Somalia) ).

fof(kb_SUMO_4566,axiom,
    s__names('Chisimayu',s__ChisimayuSomalia) ).

fof(kb_SUMO_4567,axiom,
    s__geographicSubregion(s__ChittagongBangladesh,s__Bangladesh) ).

fof(kb_SUMO_4568,axiom,
    s__names('Chittagong',s__ChittagongBangladesh) ).

fof(kb_SUMO_4569,axiom,
    s__geographicSubregion(s__ChobaAngola,s__Angola) ).

fof(kb_SUMO_4570,axiom,
    s__names('Choba',s__ChobaAngola) ).

fof(kb_SUMO_4571,axiom,
    s__geographicSubregion(s__ChocoColombia,s__Colombia) ).

fof(kb_SUMO_4572,axiom,
    s__names('Choco',s__ChocoColombia) ).

fof(kb_SUMO_4573,axiom,
    s__geographicSubregion(s__ChorrosQueroVenezuela,s__Venezuela) ).

fof(kb_SUMO_4574,axiom,
    s__names('Chorros-quero',s__ChorrosQueroVenezuela) ).

fof(kb_SUMO_4575,axiom,
    s__instance(s__ClarkAirbasePhilippines,s__GeographicArea) ).

fof(kb_SUMO_4576,axiom,
    s__geographicSubregion(s__ClarkAirbasePhilippines,s__Philippines) ).

fof(kb_SUMO_4577,axiom,
    s__names('Clark Airbase',s__ClarkAirbasePhilippines) ).

fof(kb_SUMO_4578,axiom,
    s__geographicSubregion(s__CoimbatoreIndia,s__India) ).

fof(kb_SUMO_4579,axiom,
    s__names('Coimbatore',s__CoimbatoreIndia) ).

fof(kb_SUMO_4580,axiom,
    s__geographicSubregion(s__CologneGermany,s__Germany) ).

fof(kb_SUMO_4581,axiom,
    s__names('Cologne',s__CologneGermany) ).

fof(kb_SUMO_4582,axiom,
    s__geographicSubregion(s__ColombiaCityColombia,s__Colombia) ).

fof(kb_SUMO_4583,axiom,
    s__names('Colombia City',s__ColombiaCityColombia) ).

fof(kb_SUMO_4584,axiom,
    s__geographicSubregion(s__ColombiaPanama,s__Panama) ).

fof(kb_SUMO_4585,axiom,
    s__names('Colombia',s__ColombiaPanama) ).

fof(kb_SUMO_4586,axiom,
    s__geographicSubregion(s__ColomboSriLanka,s__SriLanka) ).

fof(kb_SUMO_4587,axiom,
    s__names('Colombo',s__ColomboSriLanka) ).

fof(kb_SUMO_4588,axiom,
    s__geographicSubregion(s__ComayaguaHonduras,s__Honduras) ).

fof(kb_SUMO_4589,axiom,
    s__names('Comayagua',s__ComayaguaHonduras) ).

fof(kb_SUMO_4590,axiom,
    s__geographicSubregion(s__CopacaBanaCuba,s__Cuba) ).

fof(kb_SUMO_4591,axiom,
    s__names('Copaca-bana',s__CopacaBanaCuba) ).

fof(kb_SUMO_4592,axiom,
    s__geographicSubregion(s__CopenhagenDenmark,s__Denmark) ).

fof(kb_SUMO_4593,axiom,
    s__names('Copenhagen',s__CopenhagenDenmark) ).

fof(kb_SUMO_4594,axiom,
    s__geographicSubregion(s__CorsicaFrance,s__France) ).

fof(kb_SUMO_4595,axiom,
    s__names('Corsica',s__CorsicaFrance) ).

fof(kb_SUMO_4596,axiom,
    s__geographicSubregion(s__CorteFrance,s__France) ).

fof(kb_SUMO_4597,axiom,
    s__names('Corte',s__CorteFrance) ).

fof(kb_SUMO_4598,axiom,
    s__geographicSubregion(s__CorumTurkey,s__Turkey) ).

fof(kb_SUMO_4599,axiom,
    s__names('Corum',s__CorumTurkey) ).

fof(kb_SUMO_4600,axiom,
    s__geographicSubregion(s__CundiNamarcaColombia,s__Colombia) ).

fof(kb_SUMO_4601,axiom,
    s__names('Cundi-namarca',s__CundiNamarcaColombia) ).

fof(kb_SUMO_4602,axiom,
    s__geographicSubregion(s__CupiaguaColombia,s__Colombia) ).

fof(kb_SUMO_4603,axiom,
    s__names('Cupiagua',s__CupiaguaColombia) ).

fof(kb_SUMO_4604,axiom,
    s__geographicSubregion(s__CuzcoPeru,s__Peru) ).

fof(kb_SUMO_4605,axiom,
    s__names('Cuzco',s__CuzcoPeru) ).

fof(kb_SUMO_4606,axiom,
    s__geographicSubregion(s__DagestanRussia,s__Russia) ).

fof(kb_SUMO_4607,axiom,
    s__names('Dagestan',s__DagestanRussia) ).

fof(kb_SUMO_4608,axiom,
    s__geographicSubregion(s__DahukIraq,s__Iraq) ).

fof(kb_SUMO_4609,axiom,
    s__names('Dahuk',s__DahukIraq) ).

fof(kb_SUMO_4610,axiom,
    s__instance(s__DangDistrictNepal,s__GeographicArea) ).

fof(kb_SUMO_4611,axiom,
    s__geographicSubregion(s__DangDistrictNepal,s__Nepal) ).

fof(kb_SUMO_4612,axiom,
    s__names('Dang district',s__DangDistrictNepal) ).

fof(kb_SUMO_4613,axiom,
    s__geographicSubregion(s__DarEsSalaAmTanzania,s__Tanzania) ).

fof(kb_SUMO_4614,axiom,
    s__names('Dar es Salaam',s__DarEsSalaAmTanzania) ).

fof(kb_SUMO_4615,axiom,
    s__geographicSubregion(s__DarvazTajikistan,s__Tajikistan) ).

fof(kb_SUMO_4616,axiom,
    s__names('Darvaz',s__DarvazTajikistan) ).

fof(kb_SUMO_4617,axiom,
    s__geographicSubregion(s__DebaSpain,s__Spain) ).

fof(kb_SUMO_4618,axiom,
    s__names('Deba',s__DebaSpain) ).

fof(kb_SUMO_4619,axiom,
    s__geographicSubregion(s__DelhiIndia,s__India) ).

fof(kb_SUMO_4620,axiom,
    s__names('Delhi',s__DelhiIndia) ).

fof(kb_SUMO_4621,axiom,
    s__geographicSubregion(s__DhahranSaudiArabia,s__SaudiArabia) ).

fof(kb_SUMO_4622,axiom,
    s__names('Dhahran',s__DhahranSaudiArabia) ).

fof(kb_SUMO_4623,axiom,
    s__geographicSubregion(s__DhakaBangladesh,s__Bangladesh) ).

fof(kb_SUMO_4624,axiom,
    s__names('Dhaka',s__DhakaBangladesh) ).

fof(kb_SUMO_4625,axiom,
    s__geographicSubregion(s__DinanFrance,s__France) ).

fof(kb_SUMO_4626,axiom,
    s__names('Dinan',s__DinanFrance) ).

fof(kb_SUMO_4627,axiom,
    s__geographicSubregion(s__DirNaballahWestBank,s__WestBank) ).

fof(kb_SUMO_4628,axiom,
    s__names('Dir Naballah',s__DirNaballahWestBank) ).

fof(kb_SUMO_4629,axiom,
    s__geographicSubregion(s__DireDawaEthiopia,s__Ethiopia) ).

fof(kb_SUMO_4630,axiom,
    s__names('Dire Dawa',s__DireDawaEthiopia) ).

fof(kb_SUMO_4631,axiom,
    s__instance(s__DistrictOfMansehraPakistan,s__GeographicArea) ).

fof(kb_SUMO_4632,axiom,
    s__geographicSubregion(s__DistrictOfMansehraPakistan,s__Pakistan) ).

fof(kb_SUMO_4633,axiom,
    s__names('district of Mansehra',s__DistrictOfMansehraPakistan) ).

fof(kb_SUMO_4634,axiom,
    s__geographicSubregion(s__DjakashariGeorgia,s__RepublicOfGeorgia) ).

fof(kb_SUMO_4635,axiom,
    s__names('Djakashari',s__DjakashariGeorgia) ).

fof(kb_SUMO_4636,axiom,
    s__geographicSubregion(s__DjerbaTunisia,s__Tunisia) ).

fof(kb_SUMO_4637,axiom,
    s__names('Djerba',s__DjerbaTunisia) ).

fof(kb_SUMO_4638,axiom,
    s__geographicSubregion(s__DodaIndia,s__India) ).

fof(kb_SUMO_4639,axiom,
    s__names('Doda',s__DodaIndia) ).

fof(kb_SUMO_4640,axiom,
    s__geographicSubregion(s__DortmundGermany,s__Germany) ).

fof(kb_SUMO_4641,axiom,
    s__names('Dortmund',s__DortmundGermany) ).

fof(kb_SUMO_4642,axiom,
    s__geographicSubregion(s__DublinIreland,s__Ireland) ).

fof(kb_SUMO_4643,axiom,
    s__names('Dublin',s__DublinIreland) ).

fof(kb_SUMO_4644,axiom,
    s__geographicSubregion(s__DuesseldorfGermany,s__Germany) ).

fof(kb_SUMO_4645,axiom,
    s__names('Duesseldorf',s__DuesseldorfGermany) ).

fof(kb_SUMO_4646,axiom,
    s__geographicSubregion(s__DugitGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4647,axiom,
    s__names('Dugit',s__DugitGazaStrip) ).

fof(kb_SUMO_4648,axiom,
    s__geographicSubregion(s__DurangoSpain,s__Spain) ).

fof(kb_SUMO_4649,axiom,
    s__names('Durango',s__DurangoSpain) ).

fof(kb_SUMO_4650,axiom,
    s__geographicSubregion(s__DushanbeTajikistan,s__Tajikistan) ).

fof(kb_SUMO_4651,axiom,
    s__names('Dushanbe',s__DushanbeTajikistan) ).

fof(kb_SUMO_4652,axiom,
    s__instance(s__DushanbeAirportTajikistan,s__GeographicArea) ).

fof(kb_SUMO_4653,axiom,
    s__geographicSubregion(s__DushanbeAirportTajikistan,s__Tajikistan) ).

fof(kb_SUMO_4654,axiom,
    s__names('Dushanbe airport',s__DushanbeAirportTajikistan) ).

fof(kb_SUMO_4655,axiom,
    s__geographicSubregion(s__DushanbeGarmTajikistan,s__Tajikistan) ).

fof(kb_SUMO_4656,axiom,
    s__names('Dushanbe Garm',s__DushanbeGarmTajikistan) ).

fof(kb_SUMO_4657,axiom,
    s__geographicSubregion(s__EastJerusalemIsrael,s__Israel) ).

fof(kb_SUMO_4658,axiom,
    s__names('East Jerusalem',s__EastJerusalemIsrael) ).

fof(kb_SUMO_4659,axiom,
    s__geographicSubregion(s__EfratWestBank,s__WestBank) ).

fof(kb_SUMO_4660,axiom,
    s__names('Efrat',s__EfratWestBank) ).

fof(kb_SUMO_4661,axiom,
    s__geographicSubregion(s__EilatIsrael,s__Israel) ).

fof(kb_SUMO_4662,axiom,
    s__names('Eilat',s__EilatIsrael) ).

fof(kb_SUMO_4663,axiom,
    s__geographicSubregion(s__EinavWestBank,s__WestBank) ).

fof(kb_SUMO_4664,axiom,
    s__names('Einav',s__EinavWestBank) ).

fof(kb_SUMO_4665,axiom,
    s__geographicSubregion(s__ElBagreColombia,s__Colombia) ).

fof(kb_SUMO_4666,axiom,
    s__names('El Bagre',s__ElBagreColombia) ).

fof(kb_SUMO_4667,axiom,
    s__geographicSubregion(s__ElBirehWestBank,s__WestBank) ).

fof(kb_SUMO_4668,axiom,
    s__names('El Bireh',s__ElBirehWestBank) ).

fof(kb_SUMO_4669,axiom,
    s__geographicSubregion(s__ElPlayonColombia,s__Colombia) ).

fof(kb_SUMO_4670,axiom,
    s__names('El Playon',s__ElPlayonColombia) ).

fof(kb_SUMO_4671,axiom,
    s__geographicSubregion(s__ElRipialApureVenezuela,s__Venezuela) ).

fof(kb_SUMO_4672,axiom,
    s__names('El Ripial Apure',s__ElRipialApureVenezuela) ).

fof(kb_SUMO_4673,axiom,
    s__geographicSubregion(s__ElayoSomalia,s__Somalia) ).

fof(kb_SUMO_4674,axiom,
    s__names('Elayo',s__ElayoSomalia) ).

fof(kb_SUMO_4675,axiom,
    s__geographicSubregion(s__ElAzzariyaWestBank,s__WestBank) ).

fof(kb_SUMO_4676,axiom,
    s__names('el-Azzariya',s__ElAzzariyaWestBank) ).

fof(kb_SUMO_4677,axiom,
    s__geographicSubregion(s__EleiSinaiGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4678,axiom,
    s__names('Elei Sinai',s__EleiSinaiGazaStrip) ).

fof(kb_SUMO_4679,axiom,
    s__geographicSubregion(s__EmmanuelWestBank,s__WestBank) ).

fof(kb_SUMO_4680,axiom,
    s__names('Emmanuel',s__EmmanuelWestBank) ).

fof(kb_SUMO_4681,axiom,
    s__geographicSubregion(s__ErezGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4682,axiom,
    s__names('Erez',s__ErezGazaStrip) ).

fof(kb_SUMO_4683,axiom,
    s__instance(s__FethiyeAndMarmarisTurkey,s__GeographicArea) ).

fof(kb_SUMO_4684,axiom,
    s__geographicSubregion(s__FethiyeAndMarmarisTurkey,s__Turkey) ).

fof(kb_SUMO_4685,axiom,
    s__names('Fethiye and Marmaris',s__FethiyeAndMarmarisTurkey) ).

fof(kb_SUMO_4686,axiom,
    s__instance(s__FloridaUnitedStates,s__GeographicArea) ).

fof(kb_SUMO_4687,axiom,
    s__geographicSubregion(s__FloridaUnitedStates,s__UnitedStates) ).

fof(kb_SUMO_4688,axiom,
    s__names('Florida',s__FloridaUnitedStates) ).

fof(kb_SUMO_4689,axiom,
    s__geographicSubregion(s__FormequeColombia,s__Colombia) ).

fof(kb_SUMO_4690,axiom,
    s__names('Formeque',s__FormequeColombia) ).

fof(kb_SUMO_4691,axiom,
    s__geographicSubregion(s__FrankfurtGermany,s__Germany) ).

fof(kb_SUMO_4692,axiom,
    s__names('Frankfurt',s__FrankfurtGermany) ).

fof(kb_SUMO_4693,axiom,
    s__geographicSubregion(s__FrenchHillIsrael,s__Israel) ).

fof(kb_SUMO_4694,axiom,
    s__names('French Hill',s__FrenchHillIsrael) ).

fof(kb_SUMO_4695,axiom,
    s__geographicSubregion(s__FuengirolaSpain,s__Spain) ).

fof(kb_SUMO_4696,axiom,
    s__names('Fuengirola',s__FuengirolaSpain) ).

fof(kb_SUMO_4697,axiom,
    s__geographicSubregion(s__FusagasusaColombia,s__Colombia) ).

fof(kb_SUMO_4698,axiom,
    s__names('Fusagasusa',s__FusagasusaColombia) ).

fof(kb_SUMO_4699,axiom,
    s__geographicSubregion(s__GaliAbkhaziaGeorgia,s__RepublicOfGeorgia) ).

fof(kb_SUMO_4700,axiom,
    s__names('Gali Abkhazia',s__GaliAbkhaziaGeorgia) ).

fof(kb_SUMO_4701,axiom,
    s__geographicSubregion(s__GanimWestBank,s__WestBank) ).

fof(kb_SUMO_4702,axiom,
    s__names('Ganim',s__GanimWestBank) ).

fof(kb_SUMO_4703,axiom,
    s__geographicSubregion(s__GashuriIsrael,s__Israel) ).

fof(kb_SUMO_4704,axiom,
    s__names('Gashuri ',s__GashuriIsrael) ).

fof(kb_SUMO_4705,axiom,
    s__geographicSubregion(s__GeneralSantosPhilippines,s__Philippines) ).

fof(kb_SUMO_4706,axiom,
    s__names('General Santos',s__GeneralSantosPhilippines) ).

fof(kb_SUMO_4707,axiom,
    s__geographicSubregion(s__GenevaSwitzerland,s__Switzerland) ).

fof(kb_SUMO_4708,axiom,
    s__names('Geneva',s__GenevaSwitzerland) ).

fof(kb_SUMO_4709,axiom,
    s__geographicSubregion(s__GetxoSpain,s__Spain) ).

fof(kb_SUMO_4710,axiom,
    s__names('Getxo',s__GetxoSpain) ).

fof(kb_SUMO_4711,axiom,
    s__geographicSubregion(s__GhalebiehIraq,s__Iraq) ).

fof(kb_SUMO_4712,axiom,
    s__names('Ghalebieh',s__GhalebiehIraq) ).

fof(kb_SUMO_4713,axiom,
    s__instance(s__GhaziabadUttarPradeshIndia,s__GeographicArea) ).

fof(kb_SUMO_4714,axiom,
    s__geographicSubregion(s__GhaziabadUttarPradeshIndia,s__India) ).

fof(kb_SUMO_4715,axiom,
    s__names('Ghaziabad Uttar Pradesh',s__GhaziabadUttarPradeshIndia) ).

fof(kb_SUMO_4716,axiom,
    s__geographicSubregion(s__GiloIsrael,s__Israel) ).

fof(kb_SUMO_4717,axiom,
    s__names('Gilo',s__GiloIsrael) ).

fof(kb_SUMO_4718,axiom,
    s__geographicSubregion(s__GivatZeEvWestBank,s__WestBank) ).

fof(kb_SUMO_4719,axiom,
    s__names('Givat Zeev',s__GivatZeEvWestBank) ).

fof(kb_SUMO_4720,axiom,
    s__geographicSubregion(s__GizaEgypt,s__Egypt) ).

fof(kb_SUMO_4721,axiom,
    s__names('Giza',s__GizaEgypt) ).

fof(kb_SUMO_4722,axiom,
    s__geographicSubregion(s__GonegalleSriLanka,s__SriLanka) ).

fof(kb_SUMO_4723,axiom,
    s__names('Gonegalle',s__GonegalleSriLanka) ).

fof(kb_SUMO_4724,axiom,
    s__geographicSubregion(s__GranadaSpain,s__Spain) ).

fof(kb_SUMO_4725,axiom,
    s__names('Granada',s__GranadaSpain) ).

fof(kb_SUMO_4726,axiom,
    s__geographicSubregion(s__GrazAustria,s__Austria) ).

fof(kb_SUMO_4727,axiom,
    s__names('Graz',s__GrazAustria) ).

fof(kb_SUMO_4728,axiom,
    s__geographicSubregion(s__GroznyChechnya,s__Chechnya) ).

fof(kb_SUMO_4729,axiom,
    s__names('Grozny',s__GroznyChechnya) ).

fof(kb_SUMO_4730,axiom,
    s__geographicSubregion(s__GuilinChina,s__China) ).

fof(kb_SUMO_4731,axiom,
    s__names('Guilin',s__GuilinChina) ).

fof(kb_SUMO_4732,axiom,
    s__geographicSubregion(s__GujaratIndia,s__India) ).

fof(kb_SUMO_4733,axiom,
    s__names('Gujarat',s__GujaratIndia) ).

fof(kb_SUMO_4734,axiom,
    s__geographicSubregion(s__GushEtzionWestBank,s__WestBank) ).

fof(kb_SUMO_4735,axiom,
    s__names('Gush Etzion',s__GushEtzionWestBank) ).

fof(kb_SUMO_4736,axiom,
    s__instance(s__GushKatifGazaStrip,s__GeographicArea) ).

fof(kb_SUMO_4737,axiom,
    s__geographicSubregion(s__GushKatifGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4738,axiom,
    s__names('Gush Katif',s__GushKatifGazaStrip) ).

fof(kb_SUMO_4739,axiom,
    s__geographicSubregion(s__HaderaIsrael,s__Israel) ).

fof(kb_SUMO_4740,axiom,
    s__names('Hadera',s__HaderaIsrael) ).

fof(kb_SUMO_4741,axiom,
    s__geographicSubregion(s__HaifaIsrael,s__Israel) ).

fof(kb_SUMO_4742,axiom,
    s__names('Haifa',s__HaifaIsrael) ).

fof(kb_SUMO_4743,axiom,
    s__geographicSubregion(s__HamburgGermany,s__Germany) ).

fof(kb_SUMO_4744,axiom,
    s__names('Hamburg',s__HamburgGermany) ).

fof(kb_SUMO_4745,axiom,
    s__geographicSubregion(s__HamisMiliyanaAlgeria,s__Algeria) ).

fof(kb_SUMO_4746,axiom,
    s__names('Hamis Miliyana',s__HamisMiliyanaAlgeria) ).

fof(kb_SUMO_4747,axiom,
    s__geographicSubregion(s__HamraWestBank,s__WestBank) ).

fof(kb_SUMO_4748,axiom,
    s__names('Hamra',s__HamraWestBank) ).

fof(kb_SUMO_4749,axiom,
    s__geographicSubregion(s__HannoverGermany,s__Germany) ).

fof(kb_SUMO_4750,axiom,
    s__names('Hannover',s__HannoverGermany) ).

fof(kb_SUMO_4751,axiom,
    s__geographicSubregion(s__HarBrachaWestBank,s__WestBank) ).

fof(kb_SUMO_4752,axiom,
    s__names('Har Bracha',s__HarBrachaWestBank) ).

fof(kb_SUMO_4753,axiom,
    s__geographicSubregion(s__HarerEthiopia,s__Ethiopia) ).

fof(kb_SUMO_4754,axiom,
    s__names('Harer',s__HarerEthiopia) ).

fof(kb_SUMO_4755,axiom,
    s__geographicSubregion(s__HavanaCuba,s__Cuba) ).

fof(kb_SUMO_4756,axiom,
    s__names('Havana',s__HavanaCuba) ).

fof(kb_SUMO_4757,axiom,
    s__geographicSubregion(s__HawanaIraq,s__Iraq) ).

fof(kb_SUMO_4758,axiom,
    s__names('Hawana',s__HawanaIraq) ).

fof(kb_SUMO_4759,axiom,
    s__geographicSubregion(s__HeartAfghanistan,s__Afghanistan) ).

fof(kb_SUMO_4760,axiom,
    s__names('Heart',s__HeartAfghanistan) ).

fof(kb_SUMO_4761,axiom,
    s__geographicSubregion(s__HebronWestBank,s__WestBank) ).

fof(kb_SUMO_4762,axiom,
    s__names('Hebron',s__HebronWestBank) ).

fof(kb_SUMO_4763,axiom,
    s__geographicSubregion(s__HermeshIsrael,s__Israel) ).

fof(kb_SUMO_4764,axiom,
    s__names('Hermesh',s__HermeshIsrael) ).

fof(kb_SUMO_4765,axiom,
    s__geographicSubregion(s__HernaniSpain,s__Spain) ).

fof(kb_SUMO_4766,axiom,
    s__names('Hernani',s__HernaniSpain) ).

fof(kb_SUMO_4767,axiom,
    s__geographicSubregion(s__HerzliyaIsrael,s__Israel) ).

fof(kb_SUMO_4768,axiom,
    s__names('Herzliya',s__HerzliyaIsrael) ).

fof(kb_SUMO_4769,axiom,
    s__geographicSubregion(s__HilversumNetherlands,s__Netherlands) ).

fof(kb_SUMO_4770,axiom,
    s__names('Hilversum',s__HilversumNetherlands) ).

fof(kb_SUMO_4771,axiom,
    s__geographicSubregion(s__HizmaWestBank,s__WestBank) ).

fof(kb_SUMO_4772,axiom,
    s__names('Hizma',s__HizmaWestBank) ).

fof(kb_SUMO_4773,axiom,
    s__instance(s__HodayaJunctionIsrael,s__GeographicArea) ).

fof(kb_SUMO_4774,axiom,
    s__geographicSubregion(s__HodayaJunctionIsrael,s__Israel) ).

fof(kb_SUMO_4775,axiom,
    s__names('Hodaya Junction',s__HodayaJunctionIsrael) ).

fof(kb_SUMO_4776,axiom,
    s__instance(s__HolonJunctionIsrael,s__GeographicArea) ).

fof(kb_SUMO_4777,axiom,
    s__geographicSubregion(s__HolonJunctionIsrael,s__Israel) ).

fof(kb_SUMO_4778,axiom,
    s__names('Holon Junction',s__HolonJunctionIsrael) ).

fof(kb_SUMO_4779,axiom,
    s__geographicSubregion(s__HuallgaPeru,s__Peru) ).

fof(kb_SUMO_4780,axiom,
    s__names('Huallga',s__HuallgaPeru) ).

fof(kb_SUMO_4781,axiom,
    s__geographicSubregion(s__HurghadaEgypt,s__Egypt) ).

fof(kb_SUMO_4782,axiom,
    s__names('Hurghada',s__HurghadaEgypt) ).

fof(kb_SUMO_4783,axiom,
    s__geographicSubregion(s__HyderabadIndia,s__India) ).

fof(kb_SUMO_4784,axiom,
    s__names('Hyderabad',s__HyderabadIndia) ).

fof(kb_SUMO_4785,axiom,
    s__geographicSubregion(s__IbsrilIraq,s__Iraq) ).

fof(kb_SUMO_4786,axiom,
    s__names('Ibsril',s__IbsrilIraq) ).

fof(kb_SUMO_4787,axiom,
    s__instance(s__IncirlikAirbaseTurkey,s__GeographicArea) ).

fof(kb_SUMO_4788,axiom,
    s__geographicSubregion(s__IncirlikAirbaseTurkey,s__Turkey) ).

fof(kb_SUMO_4789,axiom,
    s__names('Incirlik Airbase',s__IncirlikAirbaseTurkey) ).

fof(kb_SUMO_4790,axiom,
    s__geographicSubregion(s__IpilPhilippines,s__Philippines) ).

fof(kb_SUMO_4791,axiom,
    s__names('Ipil',s__IpilPhilippines) ).

fof(kb_SUMO_4792,axiom,
    s__geographicSubregion(s__IrbilIraq,s__Iraq) ).

fof(kb_SUMO_4793,axiom,
    s__names('Irbil',s__IrbilIraq) ).

fof(kb_SUMO_4794,axiom,
    s__geographicSubregion(s__IslamabadPakistan,s__Pakistan) ).

fof(kb_SUMO_4795,axiom,
    s__names('Islamabad',s__IslamabadPakistan) ).

fof(kb_SUMO_4796,axiom,
    s__instance(s__IslandOfBaliIndonesia,s__GeographicArea) ).

fof(kb_SUMO_4797,axiom,
    s__geographicSubregion(s__IslandOfBaliIndonesia,s__Indonesia) ).

fof(kb_SUMO_4798,axiom,
    s__names('Island of Bali',s__IslandOfBaliIndonesia) ).

fof(kb_SUMO_4799,axiom,
    s__geographicSubregion(s__IstanbulTurkey,s__Turkey) ).

fof(kb_SUMO_4800,axiom,
    s__names('Istanbul',s__IstanbulTurkey) ).

fof(kb_SUMO_4801,axiom,
    s__geographicSubregion(s__ItamarWestBank,s__WestBank) ).

fof(kb_SUMO_4802,axiom,
    s__names('Itamar',s__ItamarWestBank) ).

fof(kb_SUMO_4803,axiom,
    s__geographicSubregion(s__IzmirTurkey,s__Turkey) ).

fof(kb_SUMO_4804,axiom,
    s__names('Izmir',s__IzmirTurkey) ).

fof(kb_SUMO_4805,axiom,
    s__geographicSubregion(s__JaffaIsrael,s__Israel) ).

fof(kb_SUMO_4806,axiom,
    s__names('Jaffa',s__JaffaIsrael) ).

fof(kb_SUMO_4807,axiom,
    s__geographicSubregion(s__JaffnaSriLanka,s__SriLanka) ).

fof(kb_SUMO_4808,axiom,
    s__names('Jaffna',s__JaffnaSriLanka) ).

fof(kb_SUMO_4809,axiom,
    s__geographicSubregion(s__JakartaIndonesia,s__Indonesia) ).

fof(kb_SUMO_4810,axiom,
    s__names('Jakarta',s__JakartaIndonesia) ).

fof(kb_SUMO_4811,axiom,
    s__geographicSubregion(s__JalahIndia,s__India) ).

fof(kb_SUMO_4812,axiom,
    s__names('Jalah',s__JalahIndia) ).

fof(kb_SUMO_4813,axiom,
    s__instance(s__JalpaiguriRailwayStationIndia,s__GeographicArea) ).

fof(kb_SUMO_4814,axiom,
    s__geographicSubregion(s__JalpaiguriRailwayStationIndia,s__India) ).

fof(kb_SUMO_4815,axiom,
    s__names('Jalpaiguri Railway Station',s__JalpaiguriRailwayStationIndia) ).

fof(kb_SUMO_4816,axiom,
    s__geographicSubregion(s__JammuIndia,s__India) ).

fof(kb_SUMO_4817,axiom,
    s__names('Jammu',s__JammuIndia) ).

fof(kb_SUMO_4818,axiom,
    s__geographicSubregion(s__JangasPeru,s__Peru) ).

fof(kb_SUMO_4819,axiom,
    s__names('Jangas',s__JangasPeru) ).

fof(kb_SUMO_4820,axiom,
    s__geographicSubregion(s__JeninWestBank,s__WestBank) ).

fof(kb_SUMO_4821,axiom,
    s__names('Jenin',s__JeninWestBank) ).

fof(kb_SUMO_4822,axiom,
    s__geographicSubregion(s__JerusalemIsrael,s__Israel) ).

fof(kb_SUMO_4823,axiom,
    s__geographicSubregion(s__JerusalemIsrael,s__WestBank) ).

fof(kb_SUMO_4824,axiom,
    s__names('Jerusalem',s__JerusalemIsrael) ).

fof(kb_SUMO_4825,axiom,
    s__geographicSubregion(s__JMainWestBank,s__WestBank) ).

fof(kb_SUMO_4826,axiom,
    s__names('Jmain',s__JMainWestBank) ).

fof(kb_SUMO_4827,axiom,
    s__geographicSubregion(s__JohannesburgSouthAfrica,s__SouthAfrica) ).

fof(kb_SUMO_4828,axiom,
    s__names('Johannesburg',s__JohannesburgSouthAfrica) ).

fof(kb_SUMO_4829,axiom,
    s__geographicSubregion(s__JoloPhilippines,s__Philippines) ).

fof(kb_SUMO_4830,axiom,
    s__names('Jolo',s__JoloPhilippines) ).

fof(kb_SUMO_4831,axiom,
    s__geographicSubregion(s__JubialSaudiArabia,s__SaudiArabia) ).

fof(kb_SUMO_4832,axiom,
    s__names('Jubial',s__JubialSaudiArabia) ).

fof(kb_SUMO_4833,axiom,
    s__geographicSubregion(s__JullundurIndia,s__India) ).

fof(kb_SUMO_4834,axiom,
    s__names('Jullundur',s__JullundurIndia) ).

fof(kb_SUMO_4835,axiom,
    s__geographicSubregion(s__KabacanPhilippines,s__Philippines) ).

fof(kb_SUMO_4836,axiom,
    s__names('Kabacan',s__KabacanPhilippines) ).

fof(kb_SUMO_4837,axiom,
    s__geographicSubregion(s__KabulAfghanistan,s__Afghanistan) ).

fof(kb_SUMO_4838,axiom,
    s__names('Kabul',s__KabulAfghanistan) ).

fof(kb_SUMO_4839,axiom,
    s__geographicSubregion(s__KafrAkabWestBank,s__WestBank) ).

fof(kb_SUMO_4840,axiom,
    s__names('Kafr Akab',s__KafrAkabWestBank) ).

fof(kb_SUMO_4841,axiom,
    s__geographicSubregion(s__KafrIdnaWestBank,s__WestBank) ).

fof(kb_SUMO_4842,axiom,
    s__names('Kafr Idna',s__KafrIdnaWestBank) ).

fof(kb_SUMO_4843,axiom,
    s__geographicSubregion(s__KalkilyaWestBank,s__WestBank) ).

fof(kb_SUMO_4844,axiom,
    s__names('Kalkilya',s__KalkilyaWestBank) ).

fof(kb_SUMO_4845,axiom,
    s__geographicSubregion(s__KalmunaiSriLanka,s__SriLanka) ).

fof(kb_SUMO_4846,axiom,
    s__names('Kalmunai',s__KalmunaiSriLanka) ).

fof(kb_SUMO_4847,axiom,
    s__geographicSubregion(s__KampalaUganda,s__Uganda) ).

fof(kb_SUMO_4848,axiom,
    s__names('Kampala',s__KampalaUganda) ).

fof(kb_SUMO_4849,axiom,
    s__geographicSubregion(s__KandySriLanka,s__SriLanka) ).

fof(kb_SUMO_4850,axiom,
    s__names('Kandy',s__KandySriLanka) ).

fof(kb_SUMO_4851,axiom,
    s__geographicSubregion(s__KanihamaIndia,s__India) ).

fof(kb_SUMO_4852,axiom,
    s__names('Kanihama',s__KanihamaIndia) ).

fof(kb_SUMO_4853,axiom,
    s__geographicSubregion(s__KarachiPakistan,s__Pakistan) ).

fof(kb_SUMO_4854,axiom,
    s__names('Karachi',s__KarachiPakistan) ).

fof(kb_SUMO_4855,axiom,
    s__geographicSubregion(s__KarkurIsrael,s__Israel) ).

fof(kb_SUMO_4856,axiom,
    s__names('Karkur',s__KarkurIsrael) ).

fof(kb_SUMO_4857,axiom,
    s__geographicSubregion(s__KarmeiTzurWestBank,s__WestBank) ).

fof(kb_SUMO_4858,axiom,
    s__names('Karmei Tzur',s__KarmeiTzurWestBank) ).

fof(kb_SUMO_4859,axiom,
    s__geographicSubregion(s__KarneiShomronWestBank,s__WestBank) ).

fof(kb_SUMO_4860,axiom,
    s__names('Karnei Shomron',s__KarneiShomronWestBank) ).

fof(kb_SUMO_4861,axiom,
    s__geographicSubregion(s__KashmirIndia,s__India) ).

fof(kb_SUMO_4862,axiom,
    s__names('Kashmir',s__KashmirIndia) ).

fof(kb_SUMO_4863,axiom,
    s__instance(s__KatmanduAirportNepal,s__GeographicArea) ).

fof(kb_SUMO_4864,axiom,
    s__geographicSubregion(s__KatmanduAirportNepal,s__Nepal) ).

fof(kb_SUMO_4865,axiom,
    s__names('Katmandu Airport',s__KatmanduAirportNepal) ).

fof(kb_SUMO_4866,axiom,
    s__geographicSubregion(s__KedumimWestBank,s__WestBank) ).

fof(kb_SUMO_4867,axiom,
    s__names('Kedumim',s__KedumimWestBank) ).

fof(kb_SUMO_4868,axiom,
    s__instance(s__KedumimSettlementWestBank,s__GeographicArea) ).

fof(kb_SUMO_4869,axiom,
    s__geographicSubregion(s__KedumimSettlementWestBank,s__WestBank) ).

fof(kb_SUMO_4870,axiom,
    s__names('Kedumim Settlement',s__KedumimSettlementWestBank) ).

fof(kb_SUMO_4871,axiom,
    s__geographicSubregion(s__KfarBaAnehIsrael,s__Israel) ).

fof(kb_SUMO_4872,axiom,
    s__names('Kfar Baaneh',s__KfarBaAnehIsrael) ).

fof(kb_SUMO_4873,axiom,
    s__geographicSubregion(s__KfarDaromGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4874,axiom,
    s__names('Kfar Darom',s__KfarDaromGazaStrip) ).

fof(kb_SUMO_4875,axiom,
    s__geographicSubregion(s__KfarHessIsrael,s__Israel) ).

fof(kb_SUMO_4876,axiom,
    s__names('Kfar Hess',s__KfarHessIsrael) ).

fof(kb_SUMO_4877,axiom,
    s__geographicSubregion(s__KfarSabaIsrael,s__Israel) ).

fof(kb_SUMO_4878,axiom,
    s__names('Kfar Saba',s__KfarSabaIsrael) ).

fof(kb_SUMO_4879,axiom,
    s__geographicSubregion(s__KfarTzurifWestBank,s__WestBank) ).

fof(kb_SUMO_4880,axiom,
    s__names('Kfar Tzurif',s__KfarTzurifWestBank) ).

fof(kb_SUMO_4881,axiom,
    s__geographicSubregion(s__KfarYamGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4882,axiom,
    s__names('Kfar Yam',s__KfarYamGazaStrip) ).

fof(kb_SUMO_4883,axiom,
    s__geographicSubregion(s__KfarDaromNetzarimIsrael,s__Israel) ).

fof(kb_SUMO_4884,axiom,
    s__names('Kfar-Darom Netzarim',s__KfarDaromNetzarimIsrael) ).

fof(kb_SUMO_4885,axiom,
    s__geographicSubregion(s__KhankalaChechnya,s__Chechnya) ).

fof(kb_SUMO_4886,axiom,
    s__names('Khankala',s__KhankalaChechnya) ).

fof(kb_SUMO_4887,axiom,
    s__geographicSubregion(s__KhartoumSudan,s__Sudan) ).

fof(kb_SUMO_4888,axiom,
    s__names('Khartoum',s__KhartoumSudan) ).

fof(kb_SUMO_4889,axiom,
    s__geographicSubregion(s__KhelilAlgeria,s__Algeria) ).

fof(kb_SUMO_4890,axiom,
    s__names('Khelil',s__KhelilAlgeria) ).

fof(kb_SUMO_4891,axiom,
    s__geographicSubregion(s__KhobarSaudiArabia,s__SaudiArabia) ).

fof(kb_SUMO_4892,axiom,
    s__names('Khobar',s__KhobarSaudiArabia) ).

fof(kb_SUMO_4893,axiom,
    s__geographicSubregion(s__KibbutzGalEdIsrael,s__Israel) ).

fof(kb_SUMO_4894,axiom,
    s__names('Kibbutz Gal Ed',s__KibbutzGalEdIsrael) ).

fof(kb_SUMO_4895,axiom,
    s__geographicSubregion(s__KibbutzMeravIsrael,s__Israel) ).

fof(kb_SUMO_4896,axiom,
    s__names('Kibbutz Merav',s__KibbutzMeravIsrael) ).

fof(kb_SUMO_4897,axiom,
    s__geographicSubregion(s__KibbutzSheluhotIsrael,s__Israel) ).

fof(kb_SUMO_4898,axiom,
    s__names('Kibbutz Sheluhot',s__KibbutzSheluhotIsrael) ).

fof(kb_SUMO_4899,axiom,
    s__geographicSubregion(s__KidapawanPhilippines,s__Philippines) ).

fof(kb_SUMO_4900,axiom,
    s__names('Kidapawan',s__KidapawanPhilippines) ).

fof(kb_SUMO_4901,axiom,
    s__geographicSubregion(s__KigaliRwanda,s__Rwanda) ).

fof(kb_SUMO_4902,axiom,
    s__names('Kigali',s__KigaliRwanda) ).

fof(kb_SUMO_4903,axiom,
    s__geographicSubregion(s__KirikkaleTurkey,s__Turkey) ).

fof(kb_SUMO_4904,axiom,
    s__names('Kirikkale',s__KirikkaleTurkey) ).

fof(kb_SUMO_4905,axiom,
    s__geographicSubregion(s__KiryatArbaWestBank,s__WestBank) ).

fof(kb_SUMO_4906,axiom,
    s__names('Kiryat Arba',s__KiryatArbaWestBank) ).

fof(kb_SUMO_4907,axiom,
    s__geographicSubregion(s__KiryatMotzkinIsrael,s__Israel) ).

fof(kb_SUMO_4908,axiom,
    s__names('Kiryat Motzkin',s__KiryatMotzkinIsrael) ).

fof(kb_SUMO_4909,axiom,
    s__geographicSubregion(s__KiryatNetafimWestBank,s__WestBank) ).

fof(kb_SUMO_4910,axiom,
    s__names('Kiryat Netafim',s__KiryatNetafimWestBank) ).

fof(kb_SUMO_4911,axiom,
    s__geographicSubregion(s__KissufimGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_4912,axiom,
    s__names('Kissufim',s__KissufimGazaStrip) ).

fof(kb_SUMO_4913,axiom,
    s__geographicSubregion(s__KiursehirBoztepTurkey,s__Turkey) ).

fof(kb_SUMO_4914,axiom,
    s__names('Kiursehir-Boztep',s__KiursehirBoztepTurkey) ).

fof(kb_SUMO_4915,axiom,
    s__geographicSubregion(s__KlaiyatLebanon,s__Lebanon) ).

fof(kb_SUMO_4916,axiom,
    s__names('Klaiyat',s__KlaiyatLebanon) ).

fof(kb_SUMO_4917,axiom,
    s__geographicSubregion(s__KohlanYemen,s__Yemen) ).

fof(kb_SUMO_4918,axiom,
    s__names('Kohlan',s__KohlanYemen) ).

fof(kb_SUMO_4919,axiom,
    s__geographicSubregion(s__KomsomoLabadTajikistan,s__Tajikistan) ).

fof(kb_SUMO_4920,axiom,
    s__names('Komsomo-labad',s__KomsomoLabadTajikistan) ).

fof(kb_SUMO_4921,axiom,
    s__geographicSubregion(s__KuwaitCityKuwait,s__Kuwait) ).

fof(kb_SUMO_4922,axiom,
    s__names('Kuwait City',s__KuwaitCityKuwait) ).

fof(kb_SUMO_4923,axiom,
    s__geographicSubregion(s__LaCeibaHonduras,s__Honduras) ).

fof(kb_SUMO_4924,axiom,
    s__names('La Ceiba',s__LaCeibaHonduras) ).

fof(kb_SUMO_4925,axiom,
    s__geographicSubregion(s__LaGabarraVenezuela,s__Venezuela) ).

fof(kb_SUMO_4926,axiom,
    s__names('La Gabarra',s__LaGabarraVenezuela) ).

fof(kb_SUMO_4927,axiom,
    s__geographicSubregion(s__LaGuajiraColombia,s__Colombia) ).

fof(kb_SUMO_4928,axiom,
    s__names('La Guajira',s__LaGuajiraColombia) ).

fof(kb_SUMO_4929,axiom,
    s__geographicSubregion(s__LaPazBolivia,s__Bolivia) ).

fof(kb_SUMO_4930,axiom,
    s__names('La Paz',s__LaPazBolivia) ).

fof(kb_SUMO_4931,axiom,
    s__geographicSubregion(s__LaVictoriaVenezuela,s__Venezuela) ).

fof(kb_SUMO_4932,axiom,
    s__names('La Victoria',s__LaVictoriaVenezuela) ).

fof(kb_SUMO_4933,axiom,
    s__geographicSubregion(s__LahorePakistan,s__Pakistan) ).

fof(kb_SUMO_4934,axiom,
    s__names('Lahore',s__LahorePakistan) ).

fof(kb_SUMO_4935,axiom,
    s__geographicSubregion(s__LarbaAlgeria,s__Algeria) ).

fof(kb_SUMO_4936,axiom,
    s__names('Larba',s__LarbaAlgeria) ).

fof(kb_SUMO_4937,axiom,
    s__geographicSubregion(s__LarnacaCyprus,s__Cyprus) ).

fof(kb_SUMO_4938,axiom,
    s__names('Larnaca',s__LarnacaCyprus) ).

fof(kb_SUMO_4939,axiom,
    s__geographicSubregion(s__LasarteSpain,s__Spain) ).

fof(kb_SUMO_4940,axiom,
    s__names('Lasarte',s__LasarteSpain) ).

fof(kb_SUMO_4941,axiom,
    s__geographicSubregion(s__LeizaSpain,s__Spain) ).

fof(kb_SUMO_4942,axiom,
    s__names('Leiza',s__LeizaSpain) ).

fof(kb_SUMO_4943,axiom,
    s__instance(s__LesEucalyptusDistrictAlgeria,s__GeographicArea) ).

fof(kb_SUMO_4944,axiom,
    s__geographicSubregion(s__LesEucalyptusDistrictAlgeria,s__Algeria) ).

fof(kb_SUMO_4945,axiom,
    s__names('Les Eucalyptus district',s__LesEucalyptusDistrictAlgeria) ).

fof(kb_SUMO_4946,axiom,
    s__geographicSubregion(s__LibertadorVenezuela,s__Venezuela) ).

fof(kb_SUMO_4947,axiom,
    s__names('Libertador',s__LibertadorVenezuela) ).

fof(kb_SUMO_4948,axiom,
    s__geographicSubregion(s__LiceTurkey,s__Turkey) ).

fof(kb_SUMO_4949,axiom,
    s__names('Lice',s__LiceTurkey) ).

fof(kb_SUMO_4950,axiom,
    s__geographicSubregion(s__LIleRousseFrance,s__France) ).

fof(kb_SUMO_4951,axiom,
    s__names('LIle-Rousse',s__LIleRousseFrance) ).

fof(kb_SUMO_4952,axiom,
    s__geographicSubregion(s__LimaPeru,s__Peru) ).

fof(kb_SUMO_4953,axiom,
    s__names('Lima',s__LimaPeru) ).

fof(kb_SUMO_4954,axiom,
    s__geographicSubregion(s__LindosRhodes,s__Rhodes) ).

fof(kb_SUMO_4955,axiom,
    s__names('Lindos',s__LindosRhodes) ).

fof(kb_SUMO_4956,axiom,
    s__geographicSubregion(s__LinzAustralia,s__Australia) ).

fof(kb_SUMO_4957,axiom,
    s__names('Linz',s__LinzAustralia) ).

fof(kb_SUMO_4958,axiom,
    s__geographicSubregion(s__LockerbieUnitedKingdom,s__UnitedKingdom) ).

fof(kb_SUMO_4959,axiom,
    s__names('Lockerbie',s__LockerbieUnitedKingdom) ).

fof(kb_SUMO_4960,axiom,
    s__geographicSubregion(s__LogronoSpain,s__Spain) ).

fof(kb_SUMO_4961,axiom,
    s__names('Logorno',s__LogronoSpain) ).

fof(kb_SUMO_4962,axiom,
    s__geographicSubregion(s__LondonUnitedKingdom,s__UnitedKingdom) ).

fof(kb_SUMO_4963,axiom,
    s__names('London',s__LondonUnitedKingdom) ).

fof(kb_SUMO_4964,axiom,
    s__geographicSubregion(s__LondonberryNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_4965,axiom,
    s__names('Londonberry',s__LondonberryNorthernIreland) ).

fof(kb_SUMO_4966,axiom,
    s__geographicSubregion(s__LosAngelesCalifornia,s__UnitedStates) ).

fof(kb_SUMO_4967,axiom,
    s__names('Los Angeles',s__LosAngelesCalifornia) ).

fof(kb_SUMO_4968,axiom,
    s__instance(s__LosAngelesInternationalAirportUnitedStates,s__GeographicArea) ).

fof(kb_SUMO_4969,axiom,
    s__geographicSubregion(s__LosAngelesInternationalAirportUnitedStates,s__UnitedStates) ).

fof(kb_SUMO_4970,axiom,
    s__names('Los Angeles International Airport',s__LosAngelesInternationalAirportUnitedStates) ).

fof(kb_SUMO_4971,axiom,
    s__geographicSubregion(s__LosBancosVenezuela,s__Venezuela) ).

fof(kb_SUMO_4972,axiom,
    s__names('Los Bancos',s__LosBancosVenezuela) ).

fof(kb_SUMO_4973,axiom,
    s__instance(s__LosKatiosNationalParkColombia,s__GeographicArea) ).

fof(kb_SUMO_4974,axiom,
    s__geographicSubregion(s__LosKatiosNationalParkColombia,s__Colombia) ).

fof(kb_SUMO_4975,axiom,
    s__names('Los Katios National Park',s__LosKatiosNationalParkColombia) ).

fof(kb_SUMO_4976,axiom,
    s__geographicSubregion(s__LuandaAngola,s__Angola) ).

fof(kb_SUMO_4977,axiom,
    s__names('Luanda',s__LuandaAngola) ).

fof(kb_SUMO_4978,axiom,
    s__geographicSubregion(s__LuebeckGermany,s__Germany) ).

fof(kb_SUMO_4979,axiom,
    s__names('Luebeck',s__LuebeckGermany) ).

fof(kb_SUMO_4980,axiom,
    s__geographicSubregion(s__LundaNorteAngola,s__Angola) ).

fof(kb_SUMO_4981,axiom,
    s__names('Lunda Norte',s__LundaNorteAngola) ).

fof(kb_SUMO_4982,axiom,
    s__geographicSubregion(s__LuxorEgypt,s__Egypt) ).

fof(kb_SUMO_4983,axiom,
    s__names('Luxor',s__LuxorEgypt) ).

fof(kb_SUMO_4984,axiom,
    s__geographicSubregion(s__LyonsFrance,s__France) ).

fof(kb_SUMO_4985,axiom,
    s__names('Lyons',s__LyonsFrance) ).

fof(kb_SUMO_4986,axiom,
    s__geographicSubregion(s__MaAlehMichmashWestBank,s__WestBank) ).

fof(kb_SUMO_4987,axiom,
    s__names('Maaleh Michmash',s__MaAlehMichmashWestBank) ).

fof(kb_SUMO_4988,axiom,
    s__geographicSubregion(s__MaccabimIsrael,s__Israel) ).

fof(kb_SUMO_4989,axiom,
    s__names('Maccabim ',s__MaccabimIsrael) ).

fof(kb_SUMO_4990,axiom,
    s__geographicSubregion(s__MadhuSriLanka,s__SriLanka) ).

fof(kb_SUMO_4991,axiom,
    s__names('Madhu',s__MadhuSriLanka) ).

fof(kb_SUMO_4992,axiom,
    s__geographicSubregion(s__MadrasIndia,s__India) ).

fof(kb_SUMO_4993,axiom,
    s__names('Madras',s__MadrasIndia) ).

fof(kb_SUMO_4994,axiom,
    s__geographicSubregion(s__MadridSpain,s__Spain) ).

fof(kb_SUMO_4995,axiom,
    s__names('Madrid',s__MadridSpain) ).

fof(kb_SUMO_4996,axiom,
    s__geographicSubregion(s__MagdalenaColombia,s__Colombia) ).

fof(kb_SUMO_4997,axiom,
    s__names('Magdalena',s__MagdalenaColombia) ).

fof(kb_SUMO_4998,axiom,
    s__geographicSubregion(s__MaidanSharAfghanistan,s__Afghanistan) ).

fof(kb_SUMO_4999,axiom,
    s__names('Maidan Shar',s__MaidanSharAfghanistan) ).

fof(kb_SUMO_5000,axiom,
    s__geographicSubregion(s__MakhachkalaRussia,s__Russia) ).

fof(kb_SUMO_5001,axiom,
    s__names('Makhachkala',s__MakhachkalaRussia) ).

fof(kb_SUMO_5002,axiom,
    s__geographicSubregion(s__MalagaSpain,s__Spain) ).

fof(kb_SUMO_5003,axiom,
    s__names('Malaga',s__MalagaSpain) ).

fof(kb_SUMO_5004,axiom,
    s__instance(s__MalukkaIslandsIndonesia,s__GeographicArea) ).

fof(kb_SUMO_5005,axiom,
    s__geographicSubregion(s__MalukkaIslandsIndonesia,s__Indonesia) ).

fof(kb_SUMO_5006,axiom,
    s__names('Malukka islands',s__MalukkaIslandsIndonesia) ).

fof(kb_SUMO_5007,axiom,
    s__geographicSubregion(s__ManaguaNigeria,s__Nigeria) ).

fof(kb_SUMO_5008,axiom,
    s__names('Managua',s__ManaguaNigeria) ).

fof(kb_SUMO_5009,axiom,
    s__geographicSubregion(s__ManamaBahrain,s__Bahrain) ).

fof(kb_SUMO_5010,axiom,
    s__names('Manama',s__ManamaBahrain) ).

fof(kb_SUMO_5011,axiom,
    s__geographicSubregion(s__ManchesterUnitedKingdom,s__UnitedKingdom) ).

fof(kb_SUMO_5012,axiom,
    s__names('Manchester',s__ManchesterUnitedKingdom) ).

fof(kb_SUMO_5013,axiom,
    s__instance(s__MangalsenAndSanpheBagarNepal,s__GeographicArea) ).

fof(kb_SUMO_5014,axiom,
    s__geographicSubregion(s__MangalsenAndSanpheBagarNepal,s__Nepal) ).

fof(kb_SUMO_5015,axiom,
    s__names('Mangalsen and Sanphe Bagar ',s__MangalsenAndSanpheBagarNepal) ).

fof(kb_SUMO_5016,axiom,
    s__geographicSubregion(s__ManilaPhilippines,s__Philippines) ).

fof(kb_SUMO_5017,axiom,
    s__names('Manila',s__ManilaPhilippines) ).

fof(kb_SUMO_5018,axiom,
    s__geographicSubregion(s__MaonIsrael,s__Israel) ).

fof(kb_SUMO_5019,axiom,
    s__names('Maon',s__MaonIsrael) ).

fof(kb_SUMO_5020,axiom,
    s__geographicSubregion(s__MapourditSudan,s__Sudan) ).

fof(kb_SUMO_5021,axiom,
    s__names('Mapourdit',s__MapourditSudan) ).

fof(kb_SUMO_5022,axiom,
    s__geographicSubregion(s__MarSabaWestBank,s__WestBank) ).

fof(kb_SUMO_5023,axiom,
    s__names('Mar Saba',s__MarSabaWestBank) ).

fof(kb_SUMO_5024,axiom,
    s__geographicSubregion(s__MarawiPhilippines,s__Philippines) ).

fof(kb_SUMO_5025,axiom,
    s__names('Marawi',s__MarawiPhilippines) ).

fof(kb_SUMO_5026,axiom,
    s__geographicSubregion(s__MardanPakistan,s__Pakistan) ).

fof(kb_SUMO_5027,axiom,
    s__names('Mardan',s__MardanPakistan) ).

fof(kb_SUMO_5028,axiom,
    s__geographicSubregion(s__MarmarisTurkey,s__Turkey) ).

fof(kb_SUMO_5029,axiom,
    s__names('Marmaris',s__MarmarisTurkey) ).

fof(kb_SUMO_5030,axiom,
    s__geographicSubregion(s__MarseillesFrance,s__France) ).

fof(kb_SUMO_5031,axiom,
    s__names('Marseilles',s__MarseillesFrance) ).

fof(kb_SUMO_5032,axiom,
    s__geographicSubregion(s__MashaWestBank,s__WestBank) ).

fof(kb_SUMO_5033,axiom,
    s__names('Masha',s__MashaWestBank) ).

fof(kb_SUMO_5034,axiom,
    s__geographicSubregion(s__MatsumotoJapan,s__Japan) ).

fof(kb_SUMO_5035,axiom,
    s__names('Matsumoto',s__MatsumotoJapan) ).

fof(kb_SUMO_5036,axiom,
    s__geographicSubregion(s__MawdiyahYemen,s__Yemen) ).

fof(kb_SUMO_5037,axiom,
    s__names('Mawdiyah',s__MawdiyahYemen) ).

fof(kb_SUMO_5038,axiom,
    s__geographicSubregion(s__MeaShearimIsrael,s__Israel) ).

fof(kb_SUMO_5039,axiom,
    s__names('Mea Shearim',s__MeaShearimIsrael) ).

fof(kb_SUMO_5040,axiom,
    s__geographicSubregion(s__MeccaSaudiArabia,s__SaudiArabia) ).

fof(kb_SUMO_5041,axiom,
    s__names('Mecca',s__MeccaSaudiArabia) ).

fof(kb_SUMO_5042,axiom,
    s__geographicSubregion(s__MechoraWestBank,s__WestBank) ).

fof(kb_SUMO_5043,axiom,
    s__names('Mechora',s__MechoraWestBank) ).

fof(kb_SUMO_5044,axiom,
    s__geographicSubregion(s__MedanIndonesia,s__Indonesia) ).

fof(kb_SUMO_5045,axiom,
    s__names('Medan',s__MedanIndonesia) ).

fof(kb_SUMO_5046,axiom,
    s__geographicSubregion(s__MedellinColombia,s__Colombia) ).

fof(kb_SUMO_5047,axiom,
    s__names('Medellin',s__MedellinColombia) ).

fof(kb_SUMO_5048,axiom,
    s__geographicSubregion(s__MegidoIsrael,s__Israel) ).

fof(kb_SUMO_5049,axiom,
    s__names('Megido',s__MegidoIsrael) ).

fof(kb_SUMO_5050,axiom,
    s__geographicSubregion(s__MeholaIsrael,s__Israel) ).

fof(kb_SUMO_5051,axiom,
    s__names('Mehola',s__MeholaIsrael) ).

fof(kb_SUMO_5052,axiom,
    s__geographicSubregion(s__MekholahIsrael,s__Israel) ).

fof(kb_SUMO_5053,axiom,
    s__names('Mekholah',s__MekholahIsrael) ).

fof(kb_SUMO_5054,axiom,
    s__geographicSubregion(s__MersinTurkey,s__Turkey) ).

fof(kb_SUMO_5055,axiom,
    s__names('Mersin',s__MersinTurkey) ).

fof(kb_SUMO_5056,axiom,
    s__geographicSubregion(s__MetaColombia,s__Colombia) ).

fof(kb_SUMO_5057,axiom,
    s__names('Meta',s__MetaColombia) ).

fof(kb_SUMO_5058,axiom,
    s__geographicSubregion(s__MetullaIsrael,s__Israel) ).

fof(kb_SUMO_5059,axiom,
    s__names('Metulla',s__MetullaIsrael) ).

fof(kb_SUMO_5060,axiom,
    s__geographicSubregion(s__MetzerIsrael,s__Israel) ).

fof(kb_SUMO_5061,axiom,
    s__names('Metzer',s__MetzerIsrael) ).

fof(kb_SUMO_5062,axiom,
    s__geographicSubregion(s__MilanItaly,s__Italy) ).

fof(kb_SUMO_5063,axiom,
    s__names('Milan',s__MilanItaly) ).

fof(kb_SUMO_5064,axiom,
    s__geographicSubregion(s__MindanaoPhilippines,s__Philippines) ).

fof(kb_SUMO_5065,axiom,
    s__names('Mindanao',s__MindanaoPhilippines) ).

fof(kb_SUMO_5066,axiom,
    s__instance(s__MinharotRoadWestBank,s__GeographicArea) ).

fof(kb_SUMO_5067,axiom,
    s__geographicSubregion(s__MinharotRoadWestBank,s__WestBank) ).

fof(kb_SUMO_5068,axiom,
    s__names('Minharot Road',s__MinharotRoadWestBank) ).

fof(kb_SUMO_5069,axiom,
    s__geographicSubregion(s__MiranShahPakistan,s__Pakistan) ).

fof(kb_SUMO_5070,axiom,
    s__names('Miran Shah ',s__MiranShahPakistan) ).

fof(kb_SUMO_5071,axiom,
    s__geographicSubregion(s__MituColombia,s__Colombia) ).

fof(kb_SUMO_5072,axiom,
    s__names('Mitu',s__MituColombia) ).

fof(kb_SUMO_5073,axiom,
    s__geographicSubregion(s__ModiinIllitWestBank,s__WestBank) ).

fof(kb_SUMO_5074,axiom,
    s__names('Modiin Illit',s__ModiinIllitWestBank) ).

fof(kb_SUMO_5075,axiom,
    s__geographicSubregion(s__MombassaKenya,s__Kenya) ).

fof(kb_SUMO_5076,axiom,
    s__names('Mombassa',s__MombassaKenya) ).

fof(kb_SUMO_5077,axiom,
    s__instance(s__MoragJunctionGazaStrip,s__GeographicArea) ).

fof(kb_SUMO_5078,axiom,
    s__geographicSubregion(s__MoragJunctionGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5079,axiom,
    s__names('Morag Junction',s__MoragJunctionGazaStrip) ).

fof(kb_SUMO_5080,axiom,
    s__geographicSubregion(s__MoscowRussia,s__Russia) ).

fof(kb_SUMO_5081,axiom,
    s__names('Moscow',s__MoscowRussia) ).

fof(kb_SUMO_5082,axiom,
    s__geographicSubregion(s__MoshavHagorIsrael,s__Israel) ).

fof(kb_SUMO_5083,axiom,
    s__names('Moshav Hagor',s__MoshavHagorIsrael) ).

fof(kb_SUMO_5084,axiom,
    s__geographicSubregion(s__MoshavTomerWestBank,s__WestBank) ).

fof(kb_SUMO_5085,axiom,
    s__names('Moshav Tomer',s__MoshavTomerWestBank) ).

fof(kb_SUMO_5086,axiom,
    s__geographicSubregion(s__MukallahAdenYemen,s__Yemen) ).

fof(kb_SUMO_5087,axiom,
    s__names('Mukallah-Aden',s__MukallahAdenYemen) ).

fof(kb_SUMO_5088,axiom,
    s__geographicSubregion(s__MunchenGladbachGermany,s__Germany) ).

fof(kb_SUMO_5089,axiom,
    s__names('Munchen-Gladbach',s__MunchenGladbachGermany) ).

fof(kb_SUMO_5090,axiom,
    s__names('Munchen',s__MunchenGladbachGermany) ).

fof(kb_SUMO_5091,axiom,
    s__names('Munich',s__MunchenGladbachGermany) ).

fof(kb_SUMO_5092,axiom,
    s__geographicSubregion(s__MunsterGermany,s__Germany) ).

fof(kb_SUMO_5093,axiom,
    s__names('Munster',s__MunsterGermany) ).

fof(kb_SUMO_5094,axiom,
    s__geographicSubregion(s__MurloughNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_5095,axiom,
    s__names('Murlough',s__MurloughNorthernIreland) ).

fof(kb_SUMO_5096,axiom,
    s__geographicSubregion(s__MusMusIsrael,s__Israel) ).

fof(kb_SUMO_5097,axiom,
    s__names('Mus Mus',s__MusMusIsrael) ).

fof(kb_SUMO_5098,axiom,
    s__geographicSubregion(s__MutataColombia,s__Colombia) ).

fof(kb_SUMO_5099,axiom,
    s__names('Mutata',s__MutataColombia) ).

fof(kb_SUMO_5100,axiom,
    s__geographicSubregion(s__MutturSriLanka,s__SriLanka) ).

fof(kb_SUMO_5101,axiom,
    s__names('Muttur',s__MutturSriLanka) ).

fof(kb_SUMO_5102,axiom,
    s__geographicSubregion(s__NaAlinWestBank,s__WestBank) ).

fof(kb_SUMO_5103,axiom,
    s__names('Naalin',s__NaAlinWestBank) ).

fof(kb_SUMO_5104,axiom,
    s__geographicSubregion(s__NablusWestBank,s__WestBank) ).

fof(kb_SUMO_5105,axiom,
    s__names('Nablus',s__NablusWestBank) ).

fof(kb_SUMO_5106,axiom,
    s__geographicSubregion(s__NahalOzGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5107,axiom,
    s__names('Nahal Oz',s__NahalOzGazaStrip) ).

fof(kb_SUMO_5108,axiom,
    s__geographicSubregion(s__NaharaimIsrael,s__Israel) ).

fof(kb_SUMO_5109,axiom,
    s__names('Naharaim',s__NaharaimIsrael) ).

fof(kb_SUMO_5110,axiom,
    s__geographicSubregion(s__NahariyaIsrael,s__Israel) ).

fof(kb_SUMO_5111,axiom,
    s__names('Nahariya',s__NahariyaIsrael) ).

fof(kb_SUMO_5112,axiom,
    s__geographicSubregion(s__NairobiKenya,s__Kenya) ).

fof(kb_SUMO_5113,axiom,
    s__names('Nairobi',s__NairobiKenya) ).

fof(kb_SUMO_5114,axiom,
    s__geographicSubregion(s__NajafIraq,s__Iraq) ).

fof(kb_SUMO_5115,axiom,
    s__names('Najaf',s__NajafIraq) ).

fof(kb_SUMO_5116,axiom,
    s__instance(s__NallurAreaSriLanka,s__GeographicArea) ).

fof(kb_SUMO_5117,axiom,
    s__geographicSubregion(s__NallurAreaSriLanka,s__SriLanka) ).

fof(kb_SUMO_5118,axiom,
    s__names('Nallur Area',s__NallurAreaSriLanka) ).

fof(kb_SUMO_5119,axiom,
    s__geographicSubregion(s__NaquraLebanon,s__Lebanon) ).

fof(kb_SUMO_5120,axiom,
    s__names('Naqura',s__NaquraLebanon) ).

fof(kb_SUMO_5121,axiom,
    s__geographicSubregion(s__NarayangangBangladesh,s__Bangladesh) ).

fof(kb_SUMO_5122,axiom,
    s__names('Narayangang',s__NarayangangBangladesh) ).

fof(kb_SUMO_5123,axiom,
    s__geographicSubregion(s__NetanyaIsrael,s__Israel) ).

fof(kb_SUMO_5124,axiom,
    s__names('Netanya',s__NetanyaIsrael) ).

fof(kb_SUMO_5125,axiom,
    s__geographicSubregion(s__NetzarimGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5126,axiom,
    s__names('Netzarim',s__NetzarimGazaStrip) ).

fof(kb_SUMO_5127,axiom,
    s__geographicSubregion(s__NetzerHazaniGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5128,axiom,
    s__names('Netzer Hazani',s__NetzerHazaniGazaStrip) ).

fof(kb_SUMO_5129,axiom,
    s__geographicSubregion(s__NeveDanielWestBank,s__WestBank) ).

fof(kb_SUMO_5130,axiom,
    s__names('Neve Daniel',s__NeveDanielWestBank) ).

fof(kb_SUMO_5131,axiom,
    s__geographicSubregion(s__NeveYaminIsrael,s__Israel) ).

fof(kb_SUMO_5132,axiom,
    s__names('Neve Yamin',s__NeveYaminIsrael) ).

fof(kb_SUMO_5133,axiom,
    s__geographicSubregion(s__NewDelhiIndia,s__India) ).

fof(kb_SUMO_5134,axiom,
    s__names('New Delhi',s__NewDelhiIndia) ).

fof(kb_SUMO_5135,axiom,
    s__names('New York City',s__NewYorkCityUnitedStates) ).

fof(kb_SUMO_5136,axiom,
    s__instance(s__NeztarimSettlementGazaStrip,s__GeographicArea) ).

fof(kb_SUMO_5137,axiom,
    s__geographicSubregion(s__NeztarimSettlementGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5138,axiom,
    s__names('Neztarim Settlement',s__NeztarimSettlementGazaStrip) ).

fof(kb_SUMO_5139,axiom,
    s__geographicSubregion(s__NiameyNiger,s__Niger) ).

fof(kb_SUMO_5140,axiom,
    s__names('Niamey',s__NiameyNiger) ).

fof(kb_SUMO_5141,axiom,
    s__geographicSubregion(s__NissanitGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5142,axiom,
    s__names('Nissanit',s__NissanitGazaStrip) ).

fof(kb_SUMO_5143,axiom,
    s__geographicSubregion(s__NitzaneiOzWestBank,s__WestBank) ).

fof(kb_SUMO_5144,axiom,
    s__names('Nitzanei Oz',s__NitzaneiOzWestBank) ).

fof(kb_SUMO_5145,axiom,
    s__geographicSubregion(s__NitzanimIsrael,s__Israel) ).

fof(kb_SUMO_5146,axiom,
    s__names('Nitzanim',s__NitzanimIsrael) ).

fof(kb_SUMO_5147,axiom,
    s__instance(s__NokdimTekoaRdWestBank,s__GeographicArea) ).

fof(kb_SUMO_5148,axiom,
    s__geographicSubregion(s__NokdimTekoaRdWestBank,s__WestBank) ).

fof(kb_SUMO_5149,axiom,
    s__names('Nokdim-Tekoa Rd.',s__NokdimTekoaRdWestBank) ).

fof(kb_SUMO_5150,axiom,
    s__geographicSubregion(s__NorteDeSantanderColombia,s__Colombia) ).

fof(kb_SUMO_5151,axiom,
    s__names('Norte de Santander',s__NorteDeSantanderColombia) ).

fof(kb_SUMO_5152,axiom,
    s__instance(s__NorthernCaucasiusChechnya,s__GeographicArea) ).

fof(kb_SUMO_5153,axiom,
    s__geographicSubregion(s__NorthernCaucasiusChechnya,s__Chechnya) ).

fof(kb_SUMO_5154,axiom,
    s__names('Northern Caucasius',s__NorthernCaucasiusChechnya) ).

fof(kb_SUMO_5155,axiom,
    s__geographicSubregion(s__NovogroznyRussia,s__Russia) ).

fof(kb_SUMO_5156,axiom,
    s__names('Novogrozny',s__NovogroznyRussia) ).

fof(kb_SUMO_5157,axiom,
    s__geographicSubregion(s__NovyyAtagiRussia,s__Russia) ).

fof(kb_SUMO_5158,axiom,
    s__names('Novyy Atagi ',s__NovyyAtagiRussia) ).

fof(kb_SUMO_5159,axiom,
    s__geographicSubregion(s__OberwartAustria,s__Austria) ).

fof(kb_SUMO_5160,axiom,
    s__names('Nuremburg',s__NuremburgGermany) ).

fof(kb_SUMO_5161,axiom,
    s__geographicSubregion(s__NuremburgGermany,s__Germany) ).

fof(kb_SUMO_5162,axiom,
    s__instance(s__NuremburgGermany,s__City) ).

fof(kb_SUMO_5163,axiom,
    s__names('Oberwart',s__OberwartAustria) ).

fof(kb_SUMO_5164,axiom,
    s__geographicSubregion(s__OfraWestBank,s__WestBank) ).

fof(kb_SUMO_5165,axiom,
    s__names('Ofra',s__OfraWestBank) ).

fof(kb_SUMO_5166,axiom,
    s__instance(s__OilbaseAlgeria,s__GeographicArea) ).

fof(kb_SUMO_5167,axiom,
    s__geographicSubregion(s__OilbaseAlgeria,s__Algeria) ).

fof(kb_SUMO_5168,axiom,
    s__names('Oil base',s__OilbaseAlgeria) ).

fof(kb_SUMO_5169,axiom,
    s__instance(s__oilfieldsVenezuela__m,s__GeographicArea) ).

fof(kb_SUMO_5170,axiom,
    s__geographicSubregion(s__oilfieldsVenezuela__m,s__Venezuela) ).

fof(kb_SUMO_5171,axiom,
    s__names(oilfields,s__oilfieldsVenezuela__m) ).

fof(kb_SUMO_5172,axiom,
    s__geographicSubregion(s__OkaraPakistan,s__Pakistan) ).

fof(kb_SUMO_5173,axiom,
    s__names('Okara',s__OkaraPakistan) ).

fof(kb_SUMO_5174,axiom,
    s__geographicSubregion(s__OlayaHerreraColombia,s__Colombia) ).

fof(kb_SUMO_5175,axiom,
    s__names('Olaya Herrera',s__OlayaHerreraColombia) ).

fof(kb_SUMO_5176,axiom,
    s__geographicSubregion(s__OmaghNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_5177,axiom,
    s__names('Omagh',s__OmaghNorthernIreland) ).

fof(kb_SUMO_5178,axiom,
    s__geographicSubregion(s__OrYehudaIsrael,s__Israel) ).

fof(kb_SUMO_5179,axiom,
    s__names('Or Yehuda',s__OrYehudaIsrael) ).

fof(kb_SUMO_5180,axiom,
    s__geographicSubregion(s__OranAlgeria,s__Algeria) ).

fof(kb_SUMO_5181,axiom,
    s__names('Oran',s__OranAlgeria) ).

fof(kb_SUMO_5182,axiom,
    s__geographicSubregion(s__OsakaJapan,s__Japan) ).

fof(kb_SUMO_5183,axiom,
    s__names('Osaka',s__OsakaJapan) ).

fof(kb_SUMO_5184,axiom,
    s__geographicSubregion(s__OsloNorway,s__Norway) ).

fof(kb_SUMO_5185,axiom,
    s__names('Oslo',s__OsloNorway) ).

fof(kb_SUMO_5186,axiom,
    s__geographicSubregion(s__OssnabruckGermany,s__Germany) ).

fof(kb_SUMO_5187,axiom,
    s__names('Ossnabruck',s__OssnabruckGermany) ).

fof(kb_SUMO_5188,axiom,
    s__instance(s__OthnielJunctionIsrael,s__GeographicArea) ).

fof(kb_SUMO_5189,axiom,
    s__geographicSubregion(s__OthnielJunctionIsrael,s__Israel) ).

fof(kb_SUMO_5190,axiom,
    s__names('Othniel Junction',s__OthnielJunctionIsrael) ).

fof(kb_SUMO_5191,axiom,
    s__geographicSubregion(s__OtnielWestBank,s__WestBank) ).

fof(kb_SUMO_5192,axiom,
    s__names('Otniel',s__OtnielWestBank) ).

fof(kb_SUMO_5193,axiom,
    s__geographicSubregion(s__OtzarinWestBank,s__WestBank) ).

fof(kb_SUMO_5194,axiom,
    s__names('Otzarin',s__OtzarinWestBank) ).

fof(kb_SUMO_5195,axiom,
    s__geographicSubregion(s__OzamisPhilippines,s__Philippines) ).

fof(kb_SUMO_5196,axiom,
    s__names('Ozamis',s__OzamisPhilippines) ).

fof(kb_SUMO_5197,axiom,
    s__geographicSubregion(s__PahalgamIndia,s__India) ).

fof(kb_SUMO_5198,axiom,
    s__names('Pahalgam',s__PahalgamIndia) ).

fof(kb_SUMO_5199,axiom,
    s__geographicSubregion(s__PalorinyaUganda,s__Uganda) ).

fof(kb_SUMO_5200,axiom,
    s__names('Palorinya',s__PalorinyaUganda) ).

fof(kb_SUMO_5201,axiom,
    s__geographicSubregion(s__PamplonaSpain,s__Spain) ).

fof(kb_SUMO_5202,axiom,
    s__names('Pamplona',s__PamplonaSpain) ).

fof(kb_SUMO_5203,axiom,
    s__geographicSubregion(s__PanamaCityPanama,s__Panama) ).

fof(kb_SUMO_5204,axiom,
    s__names('Panama City',s__PanamaCityPanama) ).

fof(kb_SUMO_5205,axiom,
    s__geographicSubregion(s__PantrasGreece,s__Greece) ).

fof(kb_SUMO_5206,axiom,
    s__names('Pantras',s__PantrasGreece) ).

fof(kb_SUMO_5207,axiom,
    s__geographicSubregion(s__PapayinColombia,s__Colombia) ).

fof(kb_SUMO_5208,axiom,
    s__names('Papayin',s__PapayinColombia) ).

fof(kb_SUMO_5209,axiom,
    s__geographicSubregion(s__PapuaIndonesia,s__Indonesia) ).

fof(kb_SUMO_5210,axiom,
    s__names('Papua',s__PapuaIndonesia) ).

fof(kb_SUMO_5211,axiom,
    s__geographicSubregion(s__ParisFrance,s__France) ).

fof(kb_SUMO_5212,axiom,
    s__names('Paris',s__ParisFrance) ).

fof(kb_SUMO_5213,axiom,
    s__geographicSubregion(s__PatikulPhilippines,s__Philippines) ).

fof(kb_SUMO_5214,axiom,
    s__names('Patikul',s__PatikulPhilippines) ).

fof(kb_SUMO_5215,axiom,
    s__geographicSubregion(s__PauFrance,s__France) ).

fof(kb_SUMO_5216,axiom,
    s__names('Pau',s__PauFrance) ).

fof(kb_SUMO_5217,axiom,
    s__geographicSubregion(s__PeAtSadehGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5218,axiom,
    s__names('Peat Sadeh',s__PeAtSadehGazaStrip) ).

fof(kb_SUMO_5219,axiom,
    s__geographicSubregion(s__PeshawarPakistan,s__Pakistan) ).

fof(kb_SUMO_5220,axiom,
    s__names('Peshawar',s__PeshawarPakistan) ).

fof(kb_SUMO_5221,axiom,
    s__geographicSubregion(s__PetahTikvahIsrael,s__Israel) ).

fof(kb_SUMO_5222,axiom,
    s__names('Petah Tikvah',s__PetahTikvahIsrael) ).

fof(kb_SUMO_5223,axiom,
    s__geographicSubregion(s__PhnomPenhCambodia,s__Cambodia) ).

fof(kb_SUMO_5224,axiom,
    s__names('Phnom Penh',s__PhnomPenhCambodia) ).

fof(kb_SUMO_5225,axiom,
    s__geographicSubregion(s__PortadownIreland,s__Ireland) ).

fof(kb_SUMO_5226,axiom,
    s__names('Portadown',s__PortadownIreland) ).

fof(kb_SUMO_5227,axiom,
    s__geographicSubregion(s__PragueCzechRepublic,s__CzechRepublic) ).

fof(kb_SUMO_5228,axiom,
    s__names('Prague',s__PragueCzechRepublic) ).

fof(kb_SUMO_5229,axiom,
    s__geographicSubregion(s__PuertoAlviraColombia,s__Colombia) ).

fof(kb_SUMO_5230,axiom,
    s__names('Puerto Alvira',s__PuertoAlviraColombia) ).

fof(kb_SUMO_5231,axiom,
    s__geographicSubregion(s__PuertoLlerasColombia,s__Colombia) ).

fof(kb_SUMO_5232,axiom,
    s__names('Puerto Lleras',s__PuertoLlerasColombia) ).

fof(kb_SUMO_5233,axiom,
    s__geographicSubregion(s__PunjabPakistan,s__Pakistan) ).

fof(kb_SUMO_5234,axiom,
    s__names('Punjab',s__PunjabPakistan) ).

fof(kb_SUMO_5235,axiom,
    s__geographicSubregion(s__QuettaPakistan,s__Pakistan) ).

fof(kb_SUMO_5236,axiom,
    s__names('Quetta',s__QuettaPakistan) ).

fof(kb_SUMO_5237,axiom,
    s__geographicSubregion(s__QuitoEcuador,s__Ecuador) ).

fof(kb_SUMO_5238,axiom,
    s__names('Quito',s__QuitoEcuador) ).

fof(kb_SUMO_5239,axiom,
    s__geographicSubregion(s__RadaAmanYemen,s__Yemen) ).

fof(kb_SUMO_5240,axiom,
    s__names('Rada-Aman',s__RadaAmanYemen) ).

fof(kb_SUMO_5241,axiom,
    s__geographicSubregion(s__RafahGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5242,axiom,
    s__names('Rafah',s__RafahGazaStrip) ).

fof(kb_SUMO_5243,axiom,
    s__geographicSubregion(s__RamaJunctionWestBank,s__WestBank) ).

fof(kb_SUMO_5244,axiom,
    s__names('Rama Junction',s__RamaJunctionWestBank) ).

fof(kb_SUMO_5245,axiom,
    s__geographicSubregion(s__RamalDeAspusanaPeru,s__Peru) ).

fof(kb_SUMO_5246,axiom,
    s__names('Ramal de Aspusana',s__RamalDeAspusanaPeru) ).

fof(kb_SUMO_5247,axiom,
    s__geographicSubregion(s__RamallahWestBank,s__WestBank) ).

fof(kb_SUMO_5248,axiom,
    s__names('Ramallah',s__RamallahWestBank) ).

fof(kb_SUMO_5249,axiom,
    s__geographicSubregion(s__RamatGanIsrael,s__Israel) ).

fof(kb_SUMO_5250,axiom,
    s__names('Ramat Gan',s__RamatGanIsrael) ).

fof(kb_SUMO_5251,axiom,
    s__geographicSubregion(s__RaminWestBank,s__WestBank) ).

fof(kb_SUMO_5252,axiom,
    s__names('Ramin',s__RaminWestBank) ).

fof(kb_SUMO_5253,axiom,
    s__geographicSubregion(s__RamleIsrael,s__Israel) ).

fof(kb_SUMO_5254,axiom,
    s__names('Ramle',s__RamleIsrael) ).

fof(kb_SUMO_5255,axiom,
    s__geographicSubregion(s__RawalpindiPakistan,s__Pakistan) ).

fof(kb_SUMO_5256,axiom,
    s__names('Rawalpindi',s__RawalpindiPakistan) ).

fof(kb_SUMO_5257,axiom,
    s__geographicSubregion(s__ReusSpain,s__Spain) ).

fof(kb_SUMO_5258,axiom,
    s__names('Reus',s__ReusSpain) ).

fof(kb_SUMO_5259,axiom,
    s__geographicSubregion(s__RigaLatvia,s__Latvia) ).

fof(kb_SUMO_5260,axiom,
    s__names('Riga',s__RigaLatvia) ).

fof(kb_SUMO_5261,axiom,
    s__geographicSubregion(s__RijekaCroatia,s__Croatia) ).

fof(kb_SUMO_5262,axiom,
    s__names('Rijeka',s__RijekaCroatia) ).

fof(kb_SUMO_5263,axiom,
    s__instance(s__RimalDistrictGazaStrip,s__GeographicArea) ).

fof(kb_SUMO_5264,axiom,
    s__geographicSubregion(s__RimalDistrictGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5265,axiom,
    s__names('Rimal district',s__RimalDistrictGazaStrip) ).

fof(kb_SUMO_5266,axiom,
    s__geographicSubregion(s__RishonLeZionIsrael,s__Israel) ).

fof(kb_SUMO_5267,axiom,
    s__names('Rishon Le Zion',s__RishonLeZionIsrael) ).

fof(kb_SUMO_5268,axiom,
    s__geographicSubregion(s__RiyadhSaudiArabia,s__SaudiArabia) ).

fof(kb_SUMO_5269,axiom,
    s__names('Riyadh',s__RiyadhSaudiArabia) ).

fof(kb_SUMO_5270,axiom,
    s__geographicSubregion(s__RoermondNetherlands,s__Netherlands) ).

fof(kb_SUMO_5271,axiom,
    s__names('Roermond',s__RoermondNetherlands) ).

fof(kb_SUMO_5272,axiom,
    s__geographicSubregion(s__RomeItaly,s__Italy) ).

fof(kb_SUMO_5273,axiom,
    s__names('Rome',s__RomeItaly) ).

fof(kb_SUMO_5274,axiom,
    s__geographicSubregion(s__RosasSpain,s__Spain) ).

fof(kb_SUMO_5275,axiom,
    s__names('Rosas',s__RosasSpain) ).

fof(kb_SUMO_5276,axiom,
    s__geographicSubregion(s__RostovOnDonRussia,s__Russia) ).

fof(kb_SUMO_5277,axiom,
    s__names('Rostov-on-Don',s__RostovOnDonRussia) ).

fof(kb_SUMO_5278,axiom,
    s__geographicSubregion(s__RuhengeriRwanda,s__Rwanda) ).

fof(kb_SUMO_5279,axiom,
    s__names('Ruhengeri',s__RuhengeriRwanda) ).

fof(kb_SUMO_5280,axiom,
    s__geographicSubregion(s__SaadaYemen,s__Yemen) ).

fof(kb_SUMO_5281,axiom,
    s__names('Saada',s__SaadaYemen) ).

fof(kb_SUMO_5282,axiom,
    s__instance(s__SaadaPakistan,s__GeographicArea) ).

fof(kb_SUMO_5283,axiom,
    s__geographicSubregion(s__SaadaPakistan,s__Pakistan) ).

fof(kb_SUMO_5284,axiom,
    s__geographicSubregion(s__SabatenaColombia,s__Colombia) ).

fof(kb_SUMO_5285,axiom,
    s__names('Sabatena',s__SabatenaColombia) ).

fof(kb_SUMO_5286,axiom,
    s__geographicSubregion(s__SacramentoUnitedStates,s__UnitedStates) ).

fof(kb_SUMO_5287,axiom,
    s__names('Sacramento',s__SacramentoUnitedStates) ).

fof(kb_SUMO_5288,axiom,
    s__geographicSubregion(s__SaintAvoldFrance,s__France) ).

fof(kb_SUMO_5289,axiom,
    s__names('Saint Avold',s__SaintAvoldFrance) ).

fof(kb_SUMO_5290,axiom,
    s__geographicSubregion(s__SaintSebastianSpain,s__Spain) ).

fof(kb_SUMO_5291,axiom,
    s__names('Saint Sebastian',s__SaintSebastianSpain) ).

fof(kb_SUMO_5292,axiom,
    s__geographicSubregion(s__SaintJeanDeLuzFrance,s__France) ).

fof(kb_SUMO_5293,axiom,
    s__names('Saint-Jean-de-Luz',s__SaintJeanDeLuzFrance) ).

fof(kb_SUMO_5294,axiom,
    s__geographicSubregion(s__SairanbarIraq,s__Iraq) ).

fof(kb_SUMO_5295,axiom,
    s__names('Sairanbar',s__SairanbarIraq) ).

fof(kb_SUMO_5296,axiom,
    s__geographicSubregion(s__SajaIAGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5297,axiom,
    s__names('Sajaia ',s__SajaIAGazaStrip) ).

fof(kb_SUMO_5298,axiom,
    s__geographicSubregion(s__SallentDeGallegoSpain,s__Spain) ).

fof(kb_SUMO_5299,axiom,
    s__names('Sallent de Gallego',s__SallentDeGallegoSpain) ).

fof(kb_SUMO_5300,axiom,
    s__geographicSubregion(s__SamariaWestBank,s__WestBank) ).

fof(kb_SUMO_5301,axiom,
    s__names('Samaria',s__SamariaWestBank) ).

fof(kb_SUMO_5302,axiom,
    s__geographicSubregion(s__SamashkiRussia,s__Russia) ).

fof(kb_SUMO_5303,axiom,
    s__names('Samashki',s__SamashkiRussia) ).

fof(kb_SUMO_5304,axiom,
    s__geographicSubregion(s__SanDiegoColombia,s__Colombia) ).

fof(kb_SUMO_5305,axiom,
    s__names('San Diego',s__SanDiegoColombia) ).

fof(kb_SUMO_5306,axiom,
    s__geographicSubregion(s__SanJoseCostaRica,s__CostaRica) ).

fof(kb_SUMO_5307,axiom,
    s__names('San Jose',s__SanJoseCostaRica) ).

fof(kb_SUMO_5308,axiom,
    s__geographicSubregion(s__SanLuisColombia,s__Colombia) ).

fof(kb_SUMO_5309,axiom,
    s__names('San Luis',s__SanLuisColombia) ).

fof(kb_SUMO_5310,axiom,
    s__geographicSubregion(s__SanMiguelElSalvador,s__ElSalvador) ).

fof(kb_SUMO_5311,axiom,
    s__names('San Miguel',s__SanMiguelElSalvador) ).

fof(kb_SUMO_5312,axiom,
    s__geographicSubregion(s__SanPabloColombia,s__Colombia) ).

fof(kb_SUMO_5313,axiom,
    s__names('San Pablo',s__SanPabloColombia) ).

fof(kb_SUMO_5314,axiom,
    s__geographicSubregion(s__SanSebastianSpain,s__Spain) ).

fof(kb_SUMO_5315,axiom,
    s__names('San Sebastian',s__SanSebastianSpain) ).

fof(kb_SUMO_5316,axiom,
    s__geographicSubregion(s__SanaaYemen,s__Yemen) ).

fof(kb_SUMO_5317,axiom,
    s__names('Sanaa',s__SanaaYemen) ).

fof(kb_SUMO_5318,axiom,
    s__geographicSubregion(s__SangaldanIndia,s__India) ).

fof(kb_SUMO_5319,axiom,
    s__names('Sangaldan',s__SangaldanIndia) ).

fof(kb_SUMO_5320,axiom,
    s__geographicSubregion(s__SantaMartaColombia,s__Colombia) ).

fof(kb_SUMO_5321,axiom,
    s__names('Santa Marta',s__SantaMartaColombia) ).

fof(kb_SUMO_5322,axiom,
    s__geographicSubregion(s__SantaPolaSpain,s__Spain) ).

fof(kb_SUMO_5323,axiom,
    s__names('Santa Pola',s__SantaPolaSpain) ).

fof(kb_SUMO_5324,axiom,
    s__instance(s__SantaRitaMountainsPanama,s__GeographicArea) ).

fof(kb_SUMO_5325,axiom,
    s__geographicSubregion(s__SantaRitaMountainsPanama,s__Panama) ).

fof(kb_SUMO_5326,axiom,
    s__names('Santa Rita Mountains',s__SantaRitaMountainsPanama) ).

fof(kb_SUMO_5327,axiom,
    s__geographicSubregion(s__SantiagoChile,s__Chile) ).

fof(kb_SUMO_5328,axiom,
    s__names('Santiago',s__SantiagoChile) ).

fof(kb_SUMO_5329,axiom,
    s__geographicSubregion(s__SanurIsrael,s__Israel) ).

fof(kb_SUMO_5330,axiom,
    s__names('Sanur',s__SanurIsrael) ).

fof(kb_SUMO_5331,axiom,
    s__geographicSubregion(s__SarajevoBosniaAndHerzegovina,s__BosniaAndHerzegovina) ).

fof(kb_SUMO_5332,axiom,
    s__names('Sarajevo',s__SarajevoBosniaAndHerzegovina) ).

fof(kb_SUMO_5333,axiom,
    s__geographicSubregion(s__SatkhiraBangladesh,s__Bangladesh) ).

fof(kb_SUMO_5334,axiom,
    s__names('Satkhira',s__SatkhiraBangladesh) ).

fof(kb_SUMO_5335,axiom,
    s__geographicSubregion(s__SegoviaColombia,s__Colombia) ).

fof(kb_SUMO_5336,axiom,
    s__names('Segovia',s__SegoviaColombia) ).

fof(kb_SUMO_5337,axiom,
    s__geographicSubregion(s__SeoulSouthKorea,s__SouthKorea) ).

fof(kb_SUMO_5338,axiom,
    s__names('Seoul',s__SeoulSouthKorea) ).

fof(kb_SUMO_5339,axiom,
    s__geographicSubregion(s__SevilleSpain,s__Spain) ).

fof(kb_SUMO_5340,axiom,
    s__names('Seville',s__SevilleSpain) ).

fof(kb_SUMO_5341,axiom,
    s__geographicSubregion(s__ShadmotMeholaWestBank,s__WestBank) ).

fof(kb_SUMO_5342,axiom,
    s__names('Shadmot Mehola',s__ShadmotMeholaWestBank) ).

fof(kb_SUMO_5343,axiom,
    s__geographicSubregion(s__ShaveiShomronWestBank,s__WestBank) ).

fof(kb_SUMO_5344,axiom,
    s__names('Shavei Shomron',s__ShaveiShomronWestBank) ).

fof(kb_SUMO_5345,axiom,
    s__geographicSubregion(s__SheikhAjlunGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5346,axiom,
    s__names('Sheikh Ajlun',s__SheikhAjlunGazaStrip) ).

fof(kb_SUMO_5347,axiom,
    s__geographicSubregion(s__ShiloWestBank,s__WestBank) ).

fof(kb_SUMO_5348,axiom,
    s__names('Shilo',s__ShiloWestBank) ).

fof(kb_SUMO_5349,axiom,
    s__geographicSubregion(s__ShimiEcuador,s__Ecuador) ).

fof(kb_SUMO_5350,axiom,
    s__names('Shimi',s__ShimiEcuador) ).

fof(kb_SUMO_5351,axiom,
    s__geographicSubregion(s__ShlomiIsrael,s__Israel) ).

fof(kb_SUMO_5352,axiom,
    s__names('Shlomi',s__ShlomiIsrael) ).

fof(kb_SUMO_5353,axiom,
    s__geographicSubregion(s__SidiHalifahLibya,s__Libya) ).

fof(kb_SUMO_5354,axiom,
    s__names('Sidi Halifah',s__SidiHalifahLibya) ).

fof(kb_SUMO_5355,axiom,
    s__geographicSubregion(s__SidonLebanon,s__Lebanon) ).

fof(kb_SUMO_5356,axiom,
    s__names('Sidon',s__SidonLebanon) ).

fof(kb_SUMO_5357,axiom,
    s__geographicSubregion(s__SiirtTurkey,s__Turkey) ).

fof(kb_SUMO_5358,axiom,
    s__names('Siirt',s__SiirtTurkey) ).

fof(kb_SUMO_5359,axiom,
    s__geographicSubregion(s__SilatADaharWestBank,s__WestBank) ).

fof(kb_SUMO_5360,axiom,
    s__names('Silat a-Dahar',s__SilatADaharWestBank) ).

fof(kb_SUMO_5361,axiom,
    s__instance(s__SipadanIslandMalaysia,s__GeographicArea) ).

fof(kb_SUMO_5362,axiom,
    s__geographicSubregion(s__SipadanIslandMalaysia,s__Malaysia) ).

fof(kb_SUMO_5363,axiom,
    s__names('Sipadan Island',s__SipadanIslandMalaysia) ).

fof(kb_SUMO_5364,axiom,
    s__geographicSubregion(s__SitrahBahrain,s__Bahrain) ).

fof(kb_SUMO_5365,axiom,
    s__names('Sitrah',s__SitrahBahrain) ).

fof(kb_SUMO_5366,axiom,
    s__geographicSubregion(s__SoporeIndia,s__India) ).

fof(kb_SUMO_5367,axiom,
    s__names('Sopore',s__SoporeIndia) ).

fof(kb_SUMO_5368,axiom,
    s__geographicSubregion(s__SrinagarIndia,s__India) ).

fof(kb_SUMO_5369,axiom,
    s__names('Srinagar',s__SrinagarIndia) ).

fof(kb_SUMO_5370,axiom,
    s__geographicSubregion(s__SrinigarIndia,s__India) ).

fof(kb_SUMO_5371,axiom,
    s__names('Srinigar',s__SrinigarIndia) ).

fof(kb_SUMO_5372,axiom,
    s__geographicSubregion(s__SriperumbudurIndia,s__India) ).

fof(kb_SUMO_5373,axiom,
    s__names('Sriperumbudur',s__SriperumbudurIndia) ).

fof(kb_SUMO_5374,axiom,
    s__geographicSubregion(s__StewartstownNorthernIreland,s__NorthernIreland) ).

fof(kb_SUMO_5375,axiom,
    s__names('Stewartstown',s__StewartstownNorthernIreland) ).

fof(kb_SUMO_5376,axiom,
    s__geographicSubregion(s__StockholmSweden,s__Sweden) ).

fof(kb_SUMO_5377,axiom,
    s__names('Stockholm',s__StockholmSweden) ).

fof(kb_SUMO_5378,axiom,
    s__geographicSubregion(s__StrasbourgFrance,s__France) ).

fof(kb_SUMO_5379,axiom,
    s__names('Strasbourg',s__StrasbourgFrance) ).

fof(kb_SUMO_5380,axiom,
    s__instance(s__SukaimaniyahIraq,s__GeographicArea) ).

fof(kb_SUMO_5381,axiom,
    s__geographicSubregion(s__SukaimaniyahIraq,s__Iraq) ).

fof(kb_SUMO_5382,axiom,
    s__names('Sukai-maniyah',s__SukaimaniyahIraq) ).

fof(kb_SUMO_5383,axiom,
    s__geographicSubregion(s__SulawesiIndonesia,s__Indonesia) ).

fof(kb_SUMO_5384,axiom,
    s__names('Sulawesi',s__SulawesiIndonesia) ).

fof(kb_SUMO_5385,axiom,
    s__geographicSubregion(s__SulaymaniyahIraq,s__Iraq) ).

fof(kb_SUMO_5386,axiom,
    s__names('Sulaymaniyah',s__SulaymaniyahIraq) ).

fof(kb_SUMO_5387,axiom,
    s__geographicSubregion(s__SumayrYemen,s__Yemen) ).

fof(kb_SUMO_5388,axiom,
    s__names('Sumayr',s__SumayrYemen) ).

fof(kb_SUMO_5389,axiom,
    s__geographicSubregion(s__SusiyaWestBank,s__WestBank) ).

fof(kb_SUMO_5390,axiom,
    s__names('Susiya',s__SusiyaWestBank) ).

fof(kb_SUMO_5391,axiom,
    s__geographicSubregion(s__TailaPakistan,s__Pakistan) ).

fof(kb_SUMO_5392,axiom,
    s__names('Taila',s__TailaPakistan) ).

fof(kb_SUMO_5393,axiom,
    s__geographicSubregion(s__TamezGuidaAlgeria,s__Algeria) ).

fof(kb_SUMO_5394,axiom,
    s__names('Tamez-guida',s__TamezGuidaAlgeria) ).

fof(kb_SUMO_5395,axiom,
    s__geographicSubregion(s__TandySriLanka,s__SriLanka) ).

fof(kb_SUMO_5396,axiom,
    s__names('Tandy',s__TandySriLanka) ).

fof(kb_SUMO_5397,axiom,
    s__geographicSubregion(s__TaxilaPakistan,s__Pakistan) ).

fof(kb_SUMO_5398,axiom,
    s__names('Taxila',s__TaxilaPakistan) ).

fof(kb_SUMO_5399,axiom,
    s__geographicSubregion(s__TBilisiGeorgia,s__RepublicOfGeorgia) ).

fof(kb_SUMO_5400,axiom,
    s__names('Tbilisi',s__TBilisiGeorgia) ).

fof(kb_SUMO_5401,axiom,
    s__geographicSubregion(s__TegucigalpaHonduras,s__Honduras) ).

fof(kb_SUMO_5402,axiom,
    s__names('Tegucigalpa',s__TegucigalpaHonduras) ).

fof(kb_SUMO_5403,axiom,
    s__geographicSubregion(s__TeheranIran,s__Iran) ).

fof(kb_SUMO_5404,axiom,
    s__names('Teheran',s__TeheranIran) ).

fof(kb_SUMO_5405,axiom,
    s__geographicSubregion(s__TekoaWestBank,s__WestBank) ).

fof(kb_SUMO_5406,axiom,
    s__names('Tekoa',s__TekoaWestBank) ).

fof(kb_SUMO_5407,axiom,
    s__geographicSubregion(s__TelAvivIsrael,s__Israel) ).

fof(kb_SUMO_5408,axiom,
    s__names('Tel Aviv',s__TelAvivIsrael) ).

fof(kb_SUMO_5409,axiom,
    s__names('Tel-Aviv',s__TelAvivIsrael) ).

fof(kb_SUMO_5410,axiom,
    s__instance(s__TelHaShomerJunctionIsrael,s__GeographicArea) ).

fof(kb_SUMO_5411,axiom,
    s__geographicSubregion(s__TelHaShomerJunctionIsrael,s__Israel) ).

fof(kb_SUMO_5412,axiom,
    s__names('Tel HaShomer Junction',s__TelHaShomerJunctionIsrael) ).

fof(kb_SUMO_5413,axiom,
    s__geographicSubregion(s__TelQateifaGazaStrip,s__GazaStrip) ).

fof(kb_SUMO_5414,axiom,
    s__names('Tel Qateifa',s__TelQateifaGazaStrip) ).

fof(kb_SUMO_5415,axiom,
    s__geographicSubregion(s__TelRumeiydaIsrael,s__Israel) ).

fof(kb_SUMO_5416,axiom,
    s__names('Tel Rumeiyda',s__TelRumeiydaIsrael) ).

fof(kb_SUMO_5417,axiom,
    s__geographicSubregion(s__TelemIsrael,s__Israel) ).

fof(kb_SUMO_5418,axiom,
    s__names('Telem',s__TelemIsrael) ).

fof(kb_SUMO_5419,axiom,
    s__geographicSubregion(s__TenaWestBank,s__WestBank) ).

fof(kb_SUMO_5420,axiom,
    s__names('Tena',s__TenaWestBank) ).

fof(kb_SUMO_5421,axiom,
    s__geographicSubregion(s__TheHagueNetherlands,s__Netherlands) ).

fof(kb_SUMO_5422,axiom,
    s__names('The Hague',s__TheHagueNetherlands) ).

fof(kb_SUMO_5423,axiom,
    s__instance(s__TheKyrgyzCapitalBishkekChina,s__GeographicArea) ).

fof(kb_SUMO_5424,axiom,
    s__geographicSubregion(s__TheKyrgyzCapitalBishkekChina,s__China) ).

fof(kb_SUMO_5425,axiom,
    s__names('The Kyrgyz capital Bishkek.',s__TheKyrgyzCapitalBishkekChina) ).

fof(kb_SUMO_5426,axiom,
    s__geographicSubregion(s__ThekraguriIndia,s__India) ).

fof(kb_SUMO_5427,axiom,
    s__names('Thekraguri',s__ThekraguriIndia) ).

fof(kb_SUMO_5428,axiom,
    s__geographicSubregion(s__TiaretAlgeria,s__Algeria) ).

fof(kb_SUMO_5429,axiom,
    s__names('Tiaret',s__TiaretAlgeria) ).

fof(kb_SUMO_5430,axiom,
    s__geographicSubregion(s__TiratAlgeria,s__Algeria) ).

fof(kb_SUMO_5431,axiom,
    s__names('Tirat',s__TiratAlgeria) ).

fof(kb_SUMO_5432,axiom,
    s__geographicSubregion(s__TokyoJapan,s__Japan) ).

fof(kb_SUMO_5433,axiom,
    s__names('Tokyo',s__TokyoJapan) ).

fof(kb_SUMO_5434,axiom,
    s__geographicSubregion(s__TolosaSpain,s__Spain) ).

fof(kb_SUMO_5435,axiom,
    s__names('Tolosa',s__TolosaSpain) ).

fof(kb_SUMO_5436,axiom,
    s__geographicSubregion(s__TopkakiTurkey,s__Turkey) ).

fof(kb_SUMO_5437,axiom,
    s__names('Topkaki',s__TopkakiTurkey) ).

fof(kb_SUMO_5438,axiom,
    s__geographicSubregion(s__TrabzonTurkey,s__Turkey) ).

fof(kb_SUMO_5439,axiom,
    s__names('Trabzon',s__TrabzonTurkey) ).

fof(kb_SUMO_5440,axiom,
    s__instance(s__TrincomaleeHarborSriLanka,s__GeographicArea) ).

fof(kb_SUMO_5441,axiom,
    s__geographicSubregion(s__TrincomaleeHarborSriLanka,s__SriLanka) ).

fof(kb_SUMO_5442,axiom,
    s__names('Trincomalee Harbor',s__TrincomaleeHarborSriLanka) ).

fof(kb_SUMO_5443,axiom,
    s__geographicSubregion(s__TripoliLibya,s__Libya) ).

fof(kb_SUMO_5444,axiom,
    s__names('Tripoli',s__TripoliLibya) ).

fof(kb_SUMO_5445,axiom,
    s__geographicSubregion(s__TulkaremWestBank,s__WestBank) ).

fof(kb_SUMO_5446,axiom,
    s__names('Tulkarem',s__TulkaremWestBank) ).

fof(kb_SUMO_5447,axiom,
    s__geographicSubregion(s__TulkarmWestBank,s__WestBank) ).

fof(kb_SUMO_5448,axiom,
    s__names('Tulkarm',s__TulkarmWestBank) ).

fof(kb_SUMO_5449,axiom,
    s__geographicSubregion(s__TunceliTurkey,s__Turkey) ).

fof(kb_SUMO_5450,axiom,
    s__names('Tunceli',s__TunceliTurkey) ).

fof(kb_SUMO_5451,axiom,
    s__geographicSubregion(s__TurbatPakistan,s__Pakistan) ).

fof(kb_SUMO_5452,axiom,
    s__names('Turbat',s__TurbatPakistan) ).

fof(kb_SUMO_5453,axiom,
    s__geographicSubregion(s__UmAlFahmIsrael,s__Israel) ).

fof(kb_SUMO_5454,axiom,
    s__names('Um al-Fahm',s__UmAlFahmIsrael) ).

fof(kb_SUMO_5455,axiom,
    s__geographicSubregion(s__UmmQasrIraq,s__Iraq) ).

fof(kb_SUMO_5456,axiom,
    s__names('Umm Qasr',s__UmmQasrIraq) ).

fof(kb_SUMO_5457,axiom,
    s__geographicSubregion(s__UrenaVenezuela,s__Venezuela) ).

fof(kb_SUMO_5458,axiom,
    s__names('Urena',s__UrenaVenezuela) ).

fof(kb_SUMO_5459,axiom,
    s__geographicSubregion(s__UrraColombia,s__Colombia) ).

fof(kb_SUMO_5460,axiom,
    s__names('Urra',s__UrraColombia) ).

fof(kb_SUMO_5461,axiom,
    s__geographicSubregion(s__UrsMartanRussia,s__Russia) ).

fof(kb_SUMO_5462,axiom,
    s__names('Urs-Martan',s__UrsMartanRussia) ).

fof(kb_SUMO_5463,axiom,
    s__instance(s__UWaIndianReservationColombia,s__GeographicArea) ).

fof(kb_SUMO_5464,axiom,
    s__geographicSubregion(s__UWaIndianReservationColombia,s__Colombia) ).

fof(kb_SUMO_5465,axiom,
    s__names('Uwa Indian reservation',s__UWaIndianReservationColombia) ).

fof(kb_SUMO_5466,axiom,
    s__geographicSubregion(s__ValenciaSpain,s__Spain) ).

fof(kb_SUMO_5467,axiom,
    s__names('Valencia',s__ValenciaSpain) ).

fof(kb_SUMO_5468,axiom,
    s__geographicSubregion(s__ValleduparColombia,s__Colombia) ).

fof(kb_SUMO_5469,axiom,
    s__names('Valledupar',s__ValleduparColombia) ).

fof(kb_SUMO_5470,axiom,
    s__geographicSubregion(s__VanTurkey,s__Turkey) ).

fof(kb_SUMO_5471,axiom,
    s__names('Van',s__VanTurkey) ).

fof(kb_SUMO_5472,axiom,
    s__geographicSubregion(s__VavuniyaSriLanka,s__SriLanka) ).

fof(kb_SUMO_5473,axiom,
    s__names('Vavuniya',s__VavuniyaSriLanka) ).

fof(kb_SUMO_5474,axiom,
    s__geographicSubregion(s__ViennaAustria,s__Austria) ).

fof(kb_SUMO_5475,axiom,
    s__names('Vienna',s__ViennaAustria) ).

fof(kb_SUMO_5476,axiom,
    s__geographicSubregion(s__VientianeLaos,s__Laos) ).

fof(kb_SUMO_5477,axiom,
    s__names('Vientiane',s__VientianeLaos) ).

fof(kb_SUMO_5478,axiom,
    s__geographicSubregion(s__VillavicencioColombia,s__Colombia) ).

fof(kb_SUMO_5479,axiom,
    s__names('Villavicencio',s__VillavicencioColombia) ).

fof(kb_SUMO_5480,axiom,
    s__geographicSubregion(s__VitoriaSpain,s__Spain) ).

fof(kb_SUMO_5481,axiom,
    s__names('Vitoria',s__VitoriaSpain) ).

fof(kb_SUMO_5482,axiom,
    s__geographicSubregion(s__VitrollesFrance,s__France) ).

fof(kb_SUMO_5483,axiom,
    s__names('Vitrolles',s__VitrollesFrance) ).

fof(kb_SUMO_5484,axiom,
    s__geographicSubregion(s__VladikavkazRussia,s__Russia) ).

fof(kb_SUMO_5485,axiom,
    s__names('Vladikavkaz',s__VladikavkazRussia) ).

fof(kb_SUMO_5486,axiom,
    s__geographicSubregion(s__VladivostokRussia,s__Russia) ).

fof(kb_SUMO_5487,axiom,
    s__names('Vladivostok',s__VladivostokRussia) ).

fof(kb_SUMO_5488,axiom,
    s__geographicSubregion(s__VolgodonskRussia,s__Russia) ).

fof(kb_SUMO_5489,axiom,
    s__names('Volgodonsk',s__VolgodonskRussia) ).

fof(kb_SUMO_5490,axiom,
    s__geographicSubregion(s__WadiAlDabaatYemen,s__Yemen) ).

fof(kb_SUMO_5491,axiom,
    s__names('Wadi al-Dabaat',s__WadiAlDabaatYemen) ).

fof(kb_SUMO_5492,axiom,
    s__geographicSubregion(s__WadiAraIsrael,s__Israel) ).

fof(kb_SUMO_5493,axiom,
    s__names('Wadi Ara',s__WadiAraIsrael) ).

fof(kb_SUMO_5494,axiom,
    s__geographicSubregion(s__WadiKeltWestBank,s__WestBank) ).

fof(kb_SUMO_5495,axiom,
    s__names('Wadi Kelt',s__WadiKeltWestBank) ).

fof(kb_SUMO_5496,axiom,
    s__geographicSubregion(s__WarsawPoland,s__Poland) ).

fof(kb_SUMO_5497,axiom,
    s__names('Warsaw',s__WarsawPoland) ).

fof(kb_SUMO_5498,axiom,
    s__geographicSubregion(s__WashingtonDCUnitedStates,s__UnitedStates) ).

fof(kb_SUMO_5499,axiom,
    s__names('Washington DC.',s__WashingtonDCUnitedStates) ).

fof(kb_SUMO_5500,axiom,
    s__geographicSubregion(s__WattyanBahrain,s__Bahrain) ).

fof(kb_SUMO_5501,axiom,
    s__names('Wattyan',s__WattyanBahrain) ).

fof(kb_SUMO_5502,axiom,
    s__geographicSubregion(s__WestBeirutLebanon,s__Lebanon) ).

fof(kb_SUMO_5503,axiom,
    s__names('West Beirut',s__WestBeirutLebanon) ).

fof(kb_SUMO_5504,axiom,
    s__geographicSubregion(s__XiAnChina,s__China) ).

fof(kb_SUMO_5505,axiom,
    s__names('Xian',s__XiAnChina) ).

fof(kb_SUMO_5506,axiom,
    s__geographicSubregion(s__YaAbadWestBank,s__WestBank) ).

fof(kb_SUMO_5507,axiom,
    s__names('Yaabad',s__YaAbadWestBank) ).

fof(kb_SUMO_5508,axiom,
    s__geographicSubregion(s__YagurJunctionIsrael,s__Israel) ).

fof(kb_SUMO_5509,axiom,
    s__names('Yagur Junction',s__YagurJunctionIsrael) ).

fof(kb_SUMO_5510,axiom,
    s__geographicSubregion(s__YehudIsrael,s__Israel) ).

fof(kb_SUMO_5511,axiom,
    s__names('Yehud',s__YehudIsrael) ).

fof(kb_SUMO_5512,axiom,
    s__geographicSubregion(s__YerevanArmenia,s__Armenia) ).

fof(kb_SUMO_5513,axiom,
    s__names('Yerevan',s__YerevanArmenia) ).

fof(kb_SUMO_5514,axiom,
    s__geographicSubregion(s__YitzharWestBank,s__WestBank) ).

fof(kb_SUMO_5515,axiom,
    s__names('Yitzhar',s__YitzharWestBank) ).

fof(kb_SUMO_5516,axiom,
    s__geographicSubregion(s__YokotaJapan,s__Japan) ).

fof(kb_SUMO_5517,axiom,
    s__names('Yokota',s__YokotaJapan) ).

fof(kb_SUMO_5518,axiom,
    s__geographicSubregion(s__YopalColombia,s__Colombia) ).

fof(kb_SUMO_5519,axiom,
    s__names('Yopal',s__YopalColombia) ).

fof(kb_SUMO_5520,axiom,
    s__geographicSubregion(s__YuksekovaTurkey,s__Turkey) ).

fof(kb_SUMO_5521,axiom,
    s__names('Yuksekova',s__YuksekovaTurkey) ).

fof(kb_SUMO_5522,axiom,
    s__geographicSubregion(s__ZaitaIsrael,s__Israel) ).

fof(kb_SUMO_5523,axiom,
    s__names('Zaita',s__ZaitaIsrael) ).

fof(kb_SUMO_5524,axiom,
    s__geographicSubregion(s__ZamarYemen,s__Yemen) ).

fof(kb_SUMO_5525,axiom,
    s__names('Zamar',s__ZamarYemen) ).

fof(kb_SUMO_5526,axiom,
    s__geographicSubregion(s__ZamboangaPhilippines,s__Philippines) ).

fof(kb_SUMO_5527,axiom,
    s__names('Zamboanga',s__ZamboangaPhilippines) ).

fof(kb_SUMO_5528,axiom,
    s__geographicSubregion(s__ZaragozaSpain,s__Spain) ).

fof(kb_SUMO_5529,axiom,
    s__names('Zaragoza',s__ZaragozaSpain) ).

fof(kb_SUMO_5530,axiom,
    s__geographicSubregion(s__ZarauzSpain,s__Spain) ).

fof(kb_SUMO_5531,axiom,
    s__names('Zarauz',s__ZarauzSpain) ).

fof(kb_SUMO_5532,axiom,
    s__instance(s__ZeifIntersectionWestBank,s__GeographicArea) ).

fof(kb_SUMO_5533,axiom,
    s__geographicSubregion(s__ZeifIntersectionWestBank,s__WestBank) ).

fof(kb_SUMO_5534,axiom,
    s__names('Zeif intersection',s__ZeifIntersectionWestBank) ).

fof(kb_SUMO_5535,axiom,
    s__geographicSubregion(s__ZekharyaIsrael,s__Israel) ).

fof(kb_SUMO_5536,axiom,
    s__names('Zekharya',s__ZekharyaIsrael) ).

fof(kb_SUMO_5537,axiom,
    s__geographicSubregion(s__ZuliaColombia,s__Colombia) ).

fof(kb_SUMO_5538,axiom,
    s__names('Zulia',s__ZuliaColombia) ).

fof(kb_SUMO_5539,axiom,
    s__geographicSubregion(s__ZumaiaSpain,s__Spain) ).

fof(kb_SUMO_5540,axiom,
    s__names('Zumaia',s__ZumaiaSpain) ).

fof(kb_SUMO_5541,axiom,
    s__geographicSubregion(s__ZumarragaSpain,s__Spain) ).

fof(kb_SUMO_5542,axiom,
    s__names('Zumarraga',s__ZumarragaSpain) ).

fof(kb_SUMO_5543,axiom,
    s__claimedTerritory(s__GazaStrip,s__Israel) ).

fof(kb_SUMO_5544,axiom,
    s__claimedTerritory(s__GazaStrip,s__PalestinianLiberationOrganization) ).

fof(kb_SUMO_5545,axiom,
    s__claimedTerritory(s__ParacelIslands,s__China) ).

fof(kb_SUMO_5546,axiom,
    s__claimedTerritory(s__ParacelIslands,s__Taiwan) ).

fof(kb_SUMO_5547,axiom,
    s__claimedTerritory(s__ParacelIslands,s__Vietnam) ).

fof(kb_SUMO_5548,axiom,
    s__claimedTerritory(s__SpratlyIslands,s__China) ).

fof(kb_SUMO_5549,axiom,
    s__claimedTerritory(s__SpratlyIslands,s__Taiwan) ).

fof(kb_SUMO_5550,axiom,
    s__claimedTerritory(s__SpratlyIslands,s__Vietnam) ).

fof(kb_SUMO_5551,axiom,
    s__claimedTerritory(s__WestBank,s__Israel) ).

fof(kb_SUMO_5552,axiom,
    s__claimedTerritory(s__WestBank,s__PalestinianLiberationOrganization) ).

fof(kb_SUMO_5553,axiom,
    s__claimedTerritory(s__WesternSahara,s__Morocco) ).

fof(kb_SUMO_5554,axiom,
    s__dependentGeopoliticalArea(s__AmericanSamoa,s__UnitedStates) ).

fof(kb_SUMO_5555,axiom,
    s__documentation(s__AmericanSamoa,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5556,axiom,
    s__dependentGeopoliticalArea(s__Anguilla,s__UnitedKingdom) ).

fof(kb_SUMO_5557,axiom,
    s__documentation(s__Anguilla,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5558,axiom,
    s__dependentGeopoliticalArea(s__Aruba,s__Netherlands) ).

fof(kb_SUMO_5559,axiom,
    s__documentation(s__Aruba,s__EnglishLanguage,'A dependency of the &%Netherlands') ).

fof(kb_SUMO_5560,axiom,
    s__dependentGeopoliticalArea(s__AshmoreAndCartierIslands,s__Australia) ).

fof(kb_SUMO_5561,axiom,
    s__documentation(s__AshmoreAndCartierIslands,s__EnglishLanguage,'A dependency of &%Australia') ).

fof(kb_SUMO_5562,axiom,
    s__dependentGeopoliticalArea(s__BakerIsland,s__UnitedStates) ).

fof(kb_SUMO_5563,axiom,
    s__documentation(s__BakerIsland,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5564,axiom,
    s__dependentGeopoliticalArea(s__BassasDaIndia,s__France) ).

fof(kb_SUMO_5565,axiom,
    s__documentation(s__BassasDaIndia,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5566,axiom,
    s__dependentGeopoliticalArea(s__Bermuda,s__UnitedKingdom) ).

fof(kb_SUMO_5567,axiom,
    s__documentation(s__Bermuda,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5568,axiom,
    s__dependentGeopoliticalArea(s__BouvetIsland,s__Norway) ).

fof(kb_SUMO_5569,axiom,
    s__documentation(s__BouvetIsland,s__EnglishLanguage,'A dependency of &%Norway') ).

fof(kb_SUMO_5570,axiom,
    s__dependentGeopoliticalArea(s__BritishIndianOceanTerritory,s__UnitedKingdom) ).

fof(kb_SUMO_5571,axiom,
    s__documentation(s__BritishIndianOceanTerritory,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5572,axiom,
    s__documentation(s__BritishVirginIslands,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5573,axiom,
    s__dependentGeopoliticalArea(s__CaymanIslands,s__UnitedKingdom) ).

fof(kb_SUMO_5574,axiom,
    s__documentation(s__CaymanIslands,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5575,axiom,
    s__dependentGeopoliticalArea(s__ChannelIslands,s__UnitedKingdom) ).

fof(kb_SUMO_5576,axiom,
    s__documentation(s__ChannelIslands,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5577,axiom,
    s__instance(s__ChannelIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5578,axiom,
    s__dependentGeopoliticalArea(s__ChristmasIsland,s__Australia) ).

fof(kb_SUMO_5579,axiom,
    s__documentation(s__ChristmasIsland,s__EnglishLanguage,'A dependency of &%Australia') ).

fof(kb_SUMO_5580,axiom,
    s__dependentGeopoliticalArea(s__ClippertonIsland,s__France) ).

fof(kb_SUMO_5581,axiom,
    s__documentation(s__ClippertonIsland,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5582,axiom,
    s__dependentGeopoliticalArea(s__CocosKeelingIslands,s__Australia) ).

fof(kb_SUMO_5583,axiom,
    s__documentation(s__CocosKeelingIslands,s__EnglishLanguage,'A dependency of &%Australia') ).

fof(kb_SUMO_5584,axiom,
    s__dependentGeopoliticalArea(s__CookIslands,s__NewZealand) ).

fof(kb_SUMO_5585,axiom,
    s__documentation(s__CookIslands,s__EnglishLanguage,'A dependency of &%NewZealand') ).

fof(kb_SUMO_5586,axiom,
    s__dependentGeopoliticalArea(s__CoralSeaIslands,s__Australia) ).

fof(kb_SUMO_5587,axiom,
    s__documentation(s__CoralSeaIslands,s__EnglishLanguage,'A dependency of &%Australia') ).

fof(kb_SUMO_5588,axiom,
    s__dependentGeopoliticalArea(s__EuropaIsland,s__France) ).

fof(kb_SUMO_5589,axiom,
    s__documentation(s__EuropaIsland,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5590,axiom,
    s__dependentGeopoliticalArea(s__FalklandIslands,s__UnitedKingdom) ).

fof(kb_SUMO_5591,axiom,
    s__documentation(s__FalklandIslands,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5592,axiom,
    s__dependentGeopoliticalArea(s__FaroeIslands,s__Denmark) ).

fof(kb_SUMO_5593,axiom,
    s__documentation(s__FaroeIslands,s__EnglishLanguage,'A dependency of &%Denmark') ).

fof(kb_SUMO_5594,axiom,
    s__dependentGeopoliticalArea(s__FrenchGuiana,s__France) ).

fof(kb_SUMO_5595,axiom,
    s__documentation(s__FrenchGuiana,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5596,axiom,
    s__dependentGeopoliticalArea(s__FrenchPolynesia,s__France) ).

fof(kb_SUMO_5597,axiom,
    s__documentation(s__FrenchPolynesia,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5598,axiom,
    s__dependentGeopoliticalArea(s__FrenchSouthernAndAntarcticLands,s__France) ).

fof(kb_SUMO_5599,axiom,
    s__documentation(s__FrenchSouthernAndAntarcticLands,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5600,axiom,
    s__dependentGeopoliticalArea(s__Gibraltar,s__UnitedKingdom) ).

fof(kb_SUMO_5601,axiom,
    s__documentation(s__Gibraltar,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5602,axiom,
    s__dependentGeopoliticalArea(s__GloriosoIslands,s__France) ).

fof(kb_SUMO_5603,axiom,
    s__documentation(s__GloriosoIslands,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5604,axiom,
    s__dependentGeopoliticalArea(s__Greenland,s__Denmark) ).

fof(kb_SUMO_5605,axiom,
    s__documentation(s__Greenland,s__EnglishLanguage,'A dependency of &%Denmark') ).

fof(kb_SUMO_5606,axiom,
    s__dependentGeopoliticalArea(s__Guadeloupe,s__France) ).

fof(kb_SUMO_5607,axiom,
    s__documentation(s__Guadeloupe,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5608,axiom,
    s__dependentGeopoliticalArea(s__Guam,s__UnitedStates) ).

fof(kb_SUMO_5609,axiom,
    s__dependentGeopoliticalArea(s__Guernsey,s__UnitedKingdom) ).

fof(kb_SUMO_5610,axiom,
    s__documentation(s__Guernsey,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5611,axiom,
    s__dependentGeopoliticalArea(s__HeardIslandAndMcDonaldIslands,s__Australia) ).

fof(kb_SUMO_5612,axiom,
    s__documentation(s__HeardIslandAndMcDonaldIslands,s__EnglishLanguage,'A dependency of &%Australia') ).

fof(kb_SUMO_5613,axiom,
    s__dependentGeopoliticalArea(s__HongKong,s__China) ).

fof(kb_SUMO_5614,axiom,
    s__documentation(s__HongKong,s__EnglishLanguage,'A dependency of &%China') ).

fof(kb_SUMO_5615,axiom,
    s__dependentGeopoliticalArea(s__HowlandIsland,s__UnitedStates) ).

fof(kb_SUMO_5616,axiom,
    s__documentation(s__HowlandIsland,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5617,axiom,
    s__dependentGeopoliticalArea(s__IsleOfMan,s__UnitedKingdom) ).

fof(kb_SUMO_5618,axiom,
    s__documentation(s__IsleOfMan,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5619,axiom,
    s__dependentGeopoliticalArea(s__JanMayenIsland,s__Norway) ).

fof(kb_SUMO_5620,axiom,
    s__documentation(s__JanMayenIsland,s__EnglishLanguage,'A dependency of &%Norway') ).

fof(kb_SUMO_5621,axiom,
    s__dependentGeopoliticalArea(s__JarvisIsland,s__UnitedStates) ).

fof(kb_SUMO_5622,axiom,
    s__documentation(s__JarvisIsland,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5623,axiom,
    s__dependentGeopoliticalArea(s__Jersey,s__UnitedKingdom) ).

fof(kb_SUMO_5624,axiom,
    s__documentation(s__Jersey,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5625,axiom,
    s__dependentGeopoliticalArea(s__JohnstonAtoll,s__UnitedStates) ).

fof(kb_SUMO_5626,axiom,
    s__documentation(s__JohnstonAtoll,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5627,axiom,
    s__dependentGeopoliticalArea(s__JuanDeNovaIsland,s__France) ).

fof(kb_SUMO_5628,axiom,
    s__documentation(s__JuanDeNovaIsland,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5629,axiom,
    s__dependentGeopoliticalArea(s__KingmanReef,s__UnitedStates) ).

fof(kb_SUMO_5630,axiom,
    s__documentation(s__KingmanReef,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5631,axiom,
    s__dependentGeopoliticalArea(s__Macau,s__China) ).

fof(kb_SUMO_5632,axiom,
    s__documentation(s__Macau,s__EnglishLanguage,'A dependency of &%China') ).

fof(kb_SUMO_5633,axiom,
    s__dependentGeopoliticalArea(s__Martinique,s__France) ).

fof(kb_SUMO_5634,axiom,
    s__documentation(s__Martinique,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5635,axiom,
    s__dependentGeopoliticalArea(s__Mayotte,s__France) ).

fof(kb_SUMO_5636,axiom,
    s__documentation(s__Mayotte,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5637,axiom,
    s__dependentGeopoliticalArea(s__MidwayIslands,s__UnitedStates) ).

fof(kb_SUMO_5638,axiom,
    s__documentation(s__MidwayIslands,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5639,axiom,
    s__dependentGeopoliticalArea(s__Montserrat,s__UnitedKingdom) ).

fof(kb_SUMO_5640,axiom,
    s__documentation(s__Montserrat,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5641,axiom,
    s__dependentGeopoliticalArea(s__NavassaIsland,s__UnitedStates) ).

fof(kb_SUMO_5642,axiom,
    s__documentation(s__NavassaIsland,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5643,axiom,
    s__dependentGeopoliticalArea(s__NetherlandsAntilles,s__Netherlands) ).

fof(kb_SUMO_5644,axiom,
    s__documentation(s__NetherlandsAntilles,s__EnglishLanguage,'A dependency of the &%Netherlands') ).

fof(kb_SUMO_5645,axiom,
    s__dependentGeopoliticalArea(s__NewCaledonia,s__France) ).

fof(kb_SUMO_5646,axiom,
    s__documentation(s__NewCaledonia,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5647,axiom,
    s__dependentGeopoliticalArea(s__Niue,s__NewZealand) ).

fof(kb_SUMO_5648,axiom,
    s__documentation(s__Niue,s__EnglishLanguage,'A dependency of &%NewZealand') ).

fof(kb_SUMO_5649,axiom,
    s__dependentGeopoliticalArea(s__NorfolkIsland,s__Australia) ).

fof(kb_SUMO_5650,axiom,
    s__documentation(s__NorfolkIsland,s__EnglishLanguage,'A dependency of &%Australia') ).

fof(kb_SUMO_5651,axiom,
    s__dependentGeopoliticalArea(s__NorthernMarianaIslands,s__UnitedStates) ).

fof(kb_SUMO_5652,axiom,
    s__documentation(s__NorthernMarianaIslands,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5653,axiom,
    s__dependentGeopoliticalArea(s__PalmyraAtoll,s__UnitedStates) ).

fof(kb_SUMO_5654,axiom,
    s__documentation(s__PalmyraAtoll,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5655,axiom,
    s__dependentGeopoliticalArea(s__PitcairnIslands,s__UnitedKingdom) ).

fof(kb_SUMO_5656,axiom,
    s__documentation(s__PitcairnIslands,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5657,axiom,
    s__dependentGeopoliticalArea(s__PuertoRico,s__UnitedStates) ).

fof(kb_SUMO_5658,axiom,
    s__dependentGeopoliticalArea(s__Reunion,s__France) ).

fof(kb_SUMO_5659,axiom,
    s__documentation(s__Reunion,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5660,axiom,
    s__dependentGeopoliticalArea(s__SaintHelena,s__UnitedKingdom) ).

fof(kb_SUMO_5661,axiom,
    s__documentation(s__SaintHelena,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5662,axiom,
    s__dependentGeopoliticalArea(s__SaintPierreAndMiquelon,s__France) ).

fof(kb_SUMO_5663,axiom,
    s__documentation(s__SaintPierreAndMiquelon,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5664,axiom,
    s__dependentGeopoliticalArea(s__SouthGeorgiaAndTheSouthSandwichIslands,s__UnitedKingdom) ).

fof(kb_SUMO_5665,axiom,
    s__documentation(s__SouthGeorgiaAndTheSouthSandwichIslands,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5666,axiom,
    s__dependentGeopoliticalArea(s__Svalbard,s__Norway) ).

fof(kb_SUMO_5667,axiom,
    s__documentation(s__Svalbard,s__EnglishLanguage,'A dependency of &%Norway') ).

fof(kb_SUMO_5668,axiom,
    s__dependentGeopoliticalArea(s__Tokelau,s__NewZealand) ).

fof(kb_SUMO_5669,axiom,
    s__documentation(s__Tokelau,s__EnglishLanguage,'A dependency of &%NewZealand') ).

fof(kb_SUMO_5670,axiom,
    s__dependentGeopoliticalArea(s__TromelinIsland,s__France) ).

fof(kb_SUMO_5671,axiom,
    s__documentation(s__TromelinIsland,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5672,axiom,
    s__dependentGeopoliticalArea(s__TurksAndCaicosIslands,s__UnitedKingdom) ).

fof(kb_SUMO_5673,axiom,
    s__documentation(s__TurksAndCaicosIslands,s__EnglishLanguage,'A dependency of the &%UnitedKingdom') ).

fof(kb_SUMO_5674,axiom,
    s__documentation(s__USVirginIslands,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5675,axiom,
    s__dependentGeopoliticalArea(s__WakeIsland,s__UnitedStates) ).

fof(kb_SUMO_5676,axiom,
    s__documentation(s__WakeIsland,s__EnglishLanguage,'A dependency of the &%UnitedStates') ).

fof(kb_SUMO_5677,axiom,
    s__dependentGeopoliticalArea(s__WallisAndFutuna,s__France) ).

fof(kb_SUMO_5678,axiom,
    s__documentation(s__WallisAndFutuna,s__EnglishLanguage,'A dependency of &%France') ).

fof(kb_SUMO_5679,axiom,
    s__instance(s__AmericanSamoa,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5680,axiom,
    s__instance(s__Anguilla,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5681,axiom,
    s__instance(s__Aruba,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5682,axiom,
    s__instance(s__AshmoreAndCartierIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5683,axiom,
    s__instance(s__BakerIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5684,axiom,
    s__instance(s__BassasDaIndia,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5685,axiom,
    s__instance(s__Bermuda,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5686,axiom,
    s__instance(s__BouvetIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5687,axiom,
    s__instance(s__BritishIndianOceanTerritory,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5688,axiom,
    s__instance(s__BritishVirginIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5689,axiom,
    s__instance(s__CaymanIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5690,axiom,
    s__instance(s__ChristmasIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5691,axiom,
    s__instance(s__ClippertonIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5692,axiom,
    s__instance(s__CocosKeelingIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5693,axiom,
    s__instance(s__CookIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5694,axiom,
    s__instance(s__CoralSeaIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5695,axiom,
    s__instance(s__EuropaIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5696,axiom,
    s__instance(s__FalklandIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5697,axiom,
    s__instance(s__FaroeIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5698,axiom,
    s__instance(s__FrenchGuiana,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5699,axiom,
    s__instance(s__FrenchPolynesia,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5700,axiom,
    s__instance(s__FrenchSouthernAndAntarcticLands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5701,axiom,
    s__instance(s__Gibraltar,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5702,axiom,
    s__instance(s__GloriosoIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5703,axiom,
    s__instance(s__Greenland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5704,axiom,
    s__instance(s__Guadeloupe,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5705,axiom,
    s__instance(s__Guam,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5706,axiom,
    s__instance(s__Guernsey,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5707,axiom,
    s__instance(s__HeardIslandAndMcDonaldIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5708,axiom,
    s__instance(s__HongKong,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5709,axiom,
    s__instance(s__HowlandIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5710,axiom,
    s__instance(s__IsleOfMan,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5711,axiom,
    s__instance(s__JanMayenIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5712,axiom,
    s__instance(s__JarvisIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5713,axiom,
    s__instance(s__Jersey,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5714,axiom,
    s__instance(s__JohnstonAtoll,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5715,axiom,
    s__instance(s__JuanDeNovaIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5716,axiom,
    s__instance(s__KingmanReef,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5717,axiom,
    s__instance(s__Macau,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5718,axiom,
    s__instance(s__Martinique,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5719,axiom,
    s__instance(s__Mayotte,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5720,axiom,
    s__instance(s__MidwayIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5721,axiom,
    s__instance(s__Montserrat,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5722,axiom,
    s__instance(s__NavassaIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5723,axiom,
    s__instance(s__NetherlandsAntilles,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5724,axiom,
    s__instance(s__NewCaledonia,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5725,axiom,
    s__instance(s__Niue,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5726,axiom,
    s__instance(s__NorfolkIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5727,axiom,
    s__instance(s__NorthernMarianaIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5728,axiom,
    s__instance(s__PalestinianLiberationOrganization,s__PoliticalOrganization) ).

fof(kb_SUMO_5729,axiom,
    s__instance(s__PalmyraAtoll,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5730,axiom,
    s__instance(s__PitcairnIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5731,axiom,
    s__instance(s__PuertoRico,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5732,axiom,
    s__instance(s__Reunion,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5733,axiom,
    s__instance(s__SaintHelena,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5734,axiom,
    s__instance(s__SaintPierreAndMiquelon,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5735,axiom,
    s__instance(s__SouthGeorgiaAndTheSouthSandwichIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5736,axiom,
    s__instance(s__Svalbard,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5737,axiom,
    s__instance(s__Tokelau,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5738,axiom,
    s__instance(s__TromelinIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5739,axiom,
    s__instance(s__TurksAndCaicosIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5740,axiom,
    s__instance(s__VirginIslands,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5741,axiom,
    s__instance(s__WakeIsland,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5742,axiom,
    s__instance(s__WallisAndFutuna,s__DependencyOrSpecialSovereigntyArea) ).

fof(kb_SUMO_5743,axiom,
    s__claimedTerritory(s__Antarctica,s__Argentina) ).

fof(kb_SUMO_5744,axiom,
    s__claimedTerritory(s__Antarctica,s__Australia) ).

fof(kb_SUMO_5745,axiom,
    s__claimedTerritory(s__Antarctica,s__Chile) ).

fof(kb_SUMO_5746,axiom,
    s__claimedTerritory(s__Antarctica,s__France) ).

fof(kb_SUMO_5747,axiom,
    s__claimedTerritory(s__Antarctica,s__NewZealand) ).

fof(kb_SUMO_5748,axiom,
    s__claimedTerritory(s__Antarctica,s__Norway) ).

fof(kb_SUMO_5749,axiom,
    s__claimedTerritory(s__Antarctica,s__UnitedKingdom) ).

fof(kb_SUMO_5750,axiom,
    s__names('Burundi',s__Burundi) ).

fof(kb_SUMO_5751,axiom,
    s__names('Central African Republic',s__CentralAfricanRepublic) ).

fof(kb_SUMO_5752,axiom,
    s__names('Chad',s__Chad) ).

fof(kb_SUMO_5753,axiom,
    s__names('Democratic Republic of the Congo',s__DemocraticRepublicOfTheCongo) ).

fof(kb_SUMO_5754,axiom,
    s__names('Rwanda',s__Rwanda) ).

fof(kb_SUMO_5755,axiom,
    s__names('Djibouti',s__Djibouti) ).

fof(kb_SUMO_5756,axiom,
    s__names('Eritrea',s__Eritrea) ).

fof(kb_SUMO_5757,axiom,
    s__names('Ethiopia',s__Ethiopia) ).

fof(kb_SUMO_5758,axiom,
    s__names('Kenya',s__Kenya) ).

fof(kb_SUMO_5759,axiom,
    s__names('Seychelles',s__Seychelles) ).

fof(kb_SUMO_5760,axiom,
    s__names('Somalia',s__Somalia) ).

fof(kb_SUMO_5761,axiom,
    s__names('Tanzania',s__Tanzania) ).

fof(kb_SUMO_5762,axiom,
    s__names('Uganda',s__Uganda) ).

fof(kb_SUMO_5763,axiom,
    s__names('Algeria',s__Algeria) ).

fof(kb_SUMO_5764,axiom,
    s__names('Egypt',s__Egypt) ).

fof(kb_SUMO_5765,axiom,
    s__names('Libya',s__Libya) ).

fof(kb_SUMO_5766,axiom,
    s__names('Mauritania',s__Mauritania) ).

fof(kb_SUMO_5767,axiom,
    s__names('Morocco',s__Morocco) ).

fof(kb_SUMO_5768,axiom,
    s__names('Sudan',s__Sudan) ).

fof(kb_SUMO_5769,axiom,
    s__names('Tunisia',s__Tunisia) ).

fof(kb_SUMO_5770,axiom,
    s__names('Western Sahara',s__WesternSahara) ).

fof(kb_SUMO_5771,axiom,
    s__names('Angola',s__Angola) ).

fof(kb_SUMO_5772,axiom,
    s__names('Bassas da India',s__BassasDaIndia) ).

fof(kb_SUMO_5773,axiom,
    s__names('Botswana',s__Botswana) ).

fof(kb_SUMO_5774,axiom,
    s__names('Bouvet Island',s__BouvetIsland) ).

fof(kb_SUMO_5775,axiom,
    s__names('Comoros',s__Comoros) ).

fof(kb_SUMO_5776,axiom,
    s__names('Europa Island',s__EuropaIsland) ).

fof(kb_SUMO_5777,axiom,
    s__names('Glorioso Islands',s__GloriosoIslands) ).

fof(kb_SUMO_5778,axiom,
    s__names('Heard Island and McDonald Islands',s__HeardIslandAndMcDonaldIslands) ).

fof(kb_SUMO_5779,axiom,
    s__names('Juan de Nova Island',s__JuanDeNovaIsland) ).

fof(kb_SUMO_5780,axiom,
    s__names('Lesotho',s__Lesotho) ).

fof(kb_SUMO_5781,axiom,
    s__names('Basutoland',s__Lesotho) ).

fof(kb_SUMO_5782,axiom,
    s__names('Madagascar',s__Madagascar) ).

fof(kb_SUMO_5783,axiom,
    s__names('Malawi',s__Malawi) ).

fof(kb_SUMO_5784,axiom,
    s__names('Mauritius',s__Mauritius) ).

fof(kb_SUMO_5785,axiom,
    s__names('Mayotte',s__Mayotte) ).

fof(kb_SUMO_5786,axiom,
    s__names('Mozambique',s__Mozambique) ).

fof(kb_SUMO_5787,axiom,
    s__names('Namibia',s__Namibia) ).

fof(kb_SUMO_5788,axiom,
    s__names('Reunion',s__Reunion) ).

fof(kb_SUMO_5789,axiom,
    s__names('South Africa',s__SouthAfrica) ).

fof(kb_SUMO_5790,axiom,
    s__names('Swaziland',s__Swaziland) ).

fof(kb_SUMO_5791,axiom,
    s__names('Tromelin Island',s__TromelinIsland) ).

fof(kb_SUMO_5792,axiom,
    s__names('Zambia',s__Zambia) ).

fof(kb_SUMO_5793,axiom,
    s__names('Zimbabwe',s__Zimbabwe) ).

fof(kb_SUMO_5794,axiom,
    s__names('Benin',s__Benin) ).

fof(kb_SUMO_5795,axiom,
    s__names('Burkina Faso',s__BurkinaFaso) ).

fof(kb_SUMO_5796,axiom,
    s__names('Cameroon',s__Cameroon) ).

fof(kb_SUMO_5797,axiom,
    s__names('Cape Verde',s__CapeVerde) ).

fof(kb_SUMO_5798,axiom,
    s__names('Cote dIvoire',s__CoteDIvoire) ).

fof(kb_SUMO_5799,axiom,
    s__names('Equatorial Guinea',s__EquatorialGuinea) ).

fof(kb_SUMO_5800,axiom,
    s__names('Gabon',s__Gabon) ).

fof(kb_SUMO_5801,axiom,
    s__names('Gambia',s__Gambia) ).

fof(kb_SUMO_5802,axiom,
    s__names('Ghana',s__Ghana) ).

fof(kb_SUMO_5803,axiom,
    s__names('Guinea',s__Guinea) ).

fof(kb_SUMO_5804,axiom,
    s__names('Guinea Bissau',s__GuineaBissau) ).

fof(kb_SUMO_5805,axiom,
    s__names('Liberia',s__Liberia) ).

fof(kb_SUMO_5806,axiom,
    s__names('Mali',s__Mali) ).

fof(kb_SUMO_5807,axiom,
    s__names('Niger',s__Niger) ).

fof(kb_SUMO_5808,axiom,
    s__names('Nigeria',s__Nigeria) ).

fof(kb_SUMO_5809,axiom,
    s__names('Sao Tome and Principe',s__SaoTomeAndPrincipe) ).

fof(kb_SUMO_5810,axiom,
    s__names('Senegal',s__Senegal) ).

fof(kb_SUMO_5811,axiom,
    s__names('Sierra Leone',s__SierraLeone) ).

fof(kb_SUMO_5812,axiom,
    s__names('Togo',s__Togo) ).

fof(kb_SUMO_5813,axiom,
    s__names('Saint Helena',s__SaintHelena) ).

fof(kb_SUMO_5814,axiom,
    s__names('Bahrain',s__Bahrain) ).

fof(kb_SUMO_5815,axiom,
    s__names('Cyprus',s__Cyprus) ).

fof(kb_SUMO_5816,axiom,
    s__names('Gaza Strip',s__GazaStrip) ).

fof(kb_SUMO_5817,axiom,
    s__names('Iran',s__Iran) ).

fof(kb_SUMO_5818,axiom,
    s__names('Iraq',s__Iraq) ).

fof(kb_SUMO_5819,axiom,
    s__names('Israel',s__Israel) ).

fof(kb_SUMO_5820,axiom,
    s__names('Jordan',s__Jordan) ).

fof(kb_SUMO_5821,axiom,
    s__names('Kuwait',s__Kuwait) ).

fof(kb_SUMO_5822,axiom,
    s__names('Lebanon',s__Lebanon) ).

fof(kb_SUMO_5823,axiom,
    s__names('Oman',s__Oman) ).

fof(kb_SUMO_5824,axiom,
    s__names('Qatar',s__Qatar) ).

fof(kb_SUMO_5825,axiom,
    s__names('Saudi Arabia',s__SaudiArabia) ).

fof(kb_SUMO_5826,axiom,
    s__names('Syria',s__Syria) ).

fof(kb_SUMO_5827,axiom,
    s__names('United Arab Emirates',s__UnitedArabEmirates) ).

fof(kb_SUMO_5828,axiom,
    s__names('West Bank',s__WestBank) ).

fof(kb_SUMO_5829,axiom,
    s__names('Yemen',s__Yemen) ).

fof(kb_SUMO_5830,axiom,
    s__names('Austria',s__Austria) ).

fof(kb_SUMO_5831,axiom,
    s__names('Czech Republic',s__CzechRepublic) ).

fof(kb_SUMO_5832,axiom,
    s__names('Germany',s__Germany) ).

fof(kb_SUMO_5833,axiom,
    s__names('Hungary',s__Hungary) ).

fof(kb_SUMO_5834,axiom,
    s__names('Liechtenstein',s__Liechtenstein) ).

fof(kb_SUMO_5835,axiom,
    s__names('Poland',s__Poland) ).

fof(kb_SUMO_5836,axiom,
    s__names('Slovakia',s__Slovakia) ).

fof(kb_SUMO_5837,axiom,
    s__names('Slovenia',s__Slovenia) ).

fof(kb_SUMO_5838,axiom,
    s__names('Switzerland',s__Switzerland) ).

fof(kb_SUMO_5839,axiom,
    s__names('Belarus',s__Belarus) ).

fof(kb_SUMO_5840,axiom,
    s__names('Estonia',s__Estonia) ).

fof(kb_SUMO_5841,axiom,
    s__names('Latvia',s__Latvia) ).

fof(kb_SUMO_5842,axiom,
    s__names('Lithuania',s__Lithuania) ).

fof(kb_SUMO_5843,axiom,
    s__names('Moldova',s__Moldova) ).

fof(kb_SUMO_5844,axiom,
    s__names('Ukraine',s__Ukraine) ).

fof(kb_SUMO_5845,axiom,
    s__names('Denmark',s__Denmark) ).

fof(kb_SUMO_5846,axiom,
    s__names('Faroe Islands',s__FaroeIslands) ).

fof(kb_SUMO_5847,axiom,
    s__names('Finland',s__Finland) ).

fof(kb_SUMO_5848,axiom,
    s__names('Iceland',s__Iceland) ).

fof(kb_SUMO_5849,axiom,
    s__names('Jan Mayen Island',s__JanMayenIsland) ).

fof(kb_SUMO_5850,axiom,
    s__names('Norway',s__Norway) ).

fof(kb_SUMO_5851,axiom,
    s__names('Svalbard',s__Svalbard) ).

fof(kb_SUMO_5852,axiom,
    s__names('Sweden',s__Sweden) ).

fof(kb_SUMO_5853,axiom,
    s__names('Greece',s__Greece) ).

fof(kb_SUMO_5854,axiom,
    s__names('Holy See',s__HolySee) ).

fof(kb_SUMO_5855,axiom,
    s__names('Italy',s__Italy) ).

fof(kb_SUMO_5856,axiom,
    s__names('Malta',s__Malta) ).

fof(kb_SUMO_5857,axiom,
    s__names('San Marino',s__SanMarino) ).

fof(kb_SUMO_5858,axiom,
    s__names('Belgium',s__Belgium) ).

fof(kb_SUMO_5859,axiom,
    s__names('France',s__France) ).

fof(kb_SUMO_5860,axiom,
    s__names('Guernsey',s__Guernsey) ).

fof(kb_SUMO_5861,axiom,
    s__names('Ireland',s__Ireland) ).

fof(kb_SUMO_5862,axiom,
    s__names('Jersey',s__Jersey) ).

fof(kb_SUMO_5863,axiom,
    s__names('Luxembourg',s__Luxembourg) ).

fof(kb_SUMO_5864,axiom,
    s__names('Isle of Man',s__IsleOfMan) ).

fof(kb_SUMO_5865,axiom,
    s__names('Monaco',s__Monaco) ).

fof(kb_SUMO_5866,axiom,
    s__names('Netherlands',s__Netherlands) ).

fof(kb_SUMO_5867,axiom,
    s__names('United Kingdom of Great Britain and Northern Ireland',s__UnitedKingdom) ).

fof(kb_SUMO_5868,axiom,
    s__names('United Kingdom',s__UnitedKingdom) ).

fof(kb_SUMO_5869,axiom,
    s__names('Great Britain',s__UnitedKingdom) ).

fof(kb_SUMO_5870,axiom,
    s__abbreviation('UK',s__UnitedKingdom) ).

fof(kb_SUMO_5871,axiom,
    s__names('Albania',s__Albania) ).

fof(kb_SUMO_5872,axiom,
    s__names('Bosnia and Herzegovina',s__BosniaAndHerzegovina) ).

fof(kb_SUMO_5873,axiom,
    s__names('Bulgaria',s__Bulgaria) ).

fof(kb_SUMO_5874,axiom,
    s__names('Croatia',s__Croatia) ).

fof(kb_SUMO_5875,axiom,
    s__names('Macedonia',s__Macedonia) ).

fof(kb_SUMO_5876,axiom,
    s__names('Romania',s__Romania) ).

fof(kb_SUMO_5877,axiom,
    s__names('Turkey',s__Turkey) ).

fof(kb_SUMO_5878,axiom,
    s__names('Serbia and Montenegro',s__SerbiaAndMontenegro) ).

fof(kb_SUMO_5879,axiom,
    s__names('Andorra',s__Andorra) ).

fof(kb_SUMO_5880,axiom,
    s__names('Gibraltar',s__Gibraltar) ).

fof(kb_SUMO_5881,axiom,
    s__names('Portugal',s__Portugal) ).

fof(kb_SUMO_5882,axiom,
    s__names('Spain',s__Spain) ).

fof(kb_SUMO_5883,axiom,
    s__names('Bermuda',s__Bermuda) ).

fof(kb_SUMO_5884,axiom,
    s__names('United States',s__UnitedStates) ).

fof(kb_SUMO_5885,axiom,
    s__names('Canada',s__Canada) ).

fof(kb_SUMO_5886,axiom,
    s__names('Greenland',s__Greenland) ).

fof(kb_SUMO_5887,axiom,
    s__names('Saint Pierre and Miquelon',s__SaintPierreAndMiquelon) ).

fof(kb_SUMO_5888,axiom,
    s__names('Anguilla',s__Anguilla) ).

fof(kb_SUMO_5889,axiom,
    s__names('Antigua and Barbuda',s__AntiguaAndBarbuda) ).

fof(kb_SUMO_5890,axiom,
    s__names('Aruba',s__Aruba) ).

fof(kb_SUMO_5891,axiom,
    s__names('Bahamas',s__TheBahamas) ).

fof(kb_SUMO_5892,axiom,
    s__names('Barbados',s__Barbados) ).

fof(kb_SUMO_5893,axiom,
    s__names('British Virgin Islands',s__BritishVirginIslands) ).

fof(kb_SUMO_5894,axiom,
    s__abbreviation('BVI',s__BritishVirginIslands) ).

fof(kb_SUMO_5895,axiom,
    s__names('Cayman Islands',s__CaymanIslands) ).

fof(kb_SUMO_5896,axiom,
    s__names('Cuba',s__Cuba) ).

fof(kb_SUMO_5897,axiom,
    s__names('Dominica',s__Dominica) ).

fof(kb_SUMO_5898,axiom,
    s__names('Dominican Republic',s__DominicanRepublic) ).

fof(kb_SUMO_5899,axiom,
    s__names('Grenada',s__Grenada) ).

fof(kb_SUMO_5900,axiom,
    s__names('Guadeloupe',s__Guadeloupe) ).

fof(kb_SUMO_5901,axiom,
    s__names('Haiti',s__Haiti) ).

fof(kb_SUMO_5902,axiom,
    s__names('Jamaica',s__Jamaica) ).

fof(kb_SUMO_5903,axiom,
    s__names('Martinique',s__Martinique) ).

fof(kb_SUMO_5904,axiom,
    s__names('Montserrat',s__Montserrat) ).

fof(kb_SUMO_5905,axiom,
    s__names('Navassa Island',s__NavassaIsland) ).

fof(kb_SUMO_5906,axiom,
    s__names('Netherlands Antilles',s__NetherlandsAntilles) ).

fof(kb_SUMO_5907,axiom,
    s__names('Puerto Rico',s__PuertoRico) ).

fof(kb_SUMO_5908,axiom,
    s__names('Saint Kitts and Nevis',s__SaintKittsAndNevis) ).

fof(kb_SUMO_5909,axiom,
    s__names('Saint Lucia',s__SaintLucia) ).

fof(kb_SUMO_5910,axiom,
    s__names('Saint Vincent and the Grenadines',s__SaintVincentAndTheGrenadines) ).

fof(kb_SUMO_5911,axiom,
    s__names('Trinidad and Tobago',s__TrinidadAndTobago) ).

fof(kb_SUMO_5912,axiom,
    s__names('Turks and Caicos Islands',s__TurksAndCaicosIslands) ).

fof(kb_SUMO_5913,axiom,
    s__names('Virgin Islands',s__VirginIslands) ).

fof(kb_SUMO_5914,axiom,
    s__names('Belize',s__Belize) ).

fof(kb_SUMO_5915,axiom,
    s__names('Clipperton Island',s__ClippertonIsland) ).

fof(kb_SUMO_5916,axiom,
    s__names('Costa Rica',s__CostaRica) ).

fof(kb_SUMO_5917,axiom,
    s__names('El Salvador',s__ElSalvador) ).

fof(kb_SUMO_5918,axiom,
    s__names('Guatemala',s__Guatemala) ).

fof(kb_SUMO_5919,axiom,
    s__names('Honduras',s__Honduras) ).

fof(kb_SUMO_5920,axiom,
    s__names('Mexico',s__Mexico) ).

fof(kb_SUMO_5921,axiom,
    s__names('Nicaragua',s__Nicaragua) ).

fof(kb_SUMO_5922,axiom,
    s__names('Panama',s__Panama) ).

fof(kb_SUMO_5923,axiom,
    s__names('Bolivia',s__Bolivia) ).

fof(kb_SUMO_5924,axiom,
    s__names('Paraguay',s__Paraguay) ).

fof(kb_SUMO_5925,axiom,
    s__names('Brazil',s__Brazil) ).

fof(kb_SUMO_5926,axiom,
    s__names('Colombia',s__Colombia) ).

fof(kb_SUMO_5927,axiom,
    s__names('French Guiana',s__FrenchGuiana) ).

fof(kb_SUMO_5928,axiom,
    s__names('Guyana',s__Guyana) ).

fof(kb_SUMO_5929,axiom,
    s__names('Suriname',s__Suriname) ).

fof(kb_SUMO_5930,axiom,
    s__names('Venezuela',s__Venezuela) ).

fof(kb_SUMO_5931,axiom,
    s__names('Argentina',s__Argentina) ).

fof(kb_SUMO_5932,axiom,
    s__names('Chile',s__Chile) ).

fof(kb_SUMO_5933,axiom,
    s__names('Falkland Islands',s__FalklandIslands) ).

fof(kb_SUMO_5934,axiom,
    s__names('South Georgia and the South Sandwich Islands',s__SouthGeorgiaAndTheSouthSandwichIslands) ).

fof(kb_SUMO_5935,axiom,
    s__names('Uruguay',s__Uruguay) ).

fof(kb_SUMO_5936,axiom,
    s__names('Ecuador',s__Ecuador) ).

fof(kb_SUMO_5937,axiom,
    s__names('Peru',s__Peru) ).

fof(kb_SUMO_5938,axiom,
    s__names('Kazakhstan',s__Kazakhstan) ).

fof(kb_SUMO_5939,axiom,
    s__names('Kyrgyzstan',s__Kyrgyzstan) ).

fof(kb_SUMO_5940,axiom,
    s__names('Tajikistan',s__Tajikistan) ).

fof(kb_SUMO_5941,axiom,
    s__names('Turkmenistan',s__Turkmenistan) ).

fof(kb_SUMO_5942,axiom,
    s__names('Uzbekistan',s__Uzbekistan) ).

fof(kb_SUMO_5943,axiom,
    s__names('China',s__China) ).

fof(kb_SUMO_5944,axiom,
    s__names('Hong Kong',s__HongKong) ).

fof(kb_SUMO_5945,axiom,
    s__names('Japan',s__Japan) ).

fof(kb_SUMO_5946,axiom,
    s__names('NorthKorea',s__NorthKorea) ).

fof(kb_SUMO_5947,axiom,
    s__names('SouthKorea',s__SouthKorea) ).

fof(kb_SUMO_5948,axiom,
    s__names('Macau',s__Macau) ).

fof(kb_SUMO_5949,axiom,
    s__names('Taiwan',s__Taiwan) ).

fof(kb_SUMO_5950,axiom,
    s__names('Republic of China',s__Taiwan) ).

fof(kb_SUMO_5951,axiom,
    s__abbreviation('ROC',s__Taiwan) ).

fof(kb_SUMO_5952,axiom,
    s__names('Mongolia',s__Mongolia) ).

fof(kb_SUMO_5953,axiom,
    s__names('Russia',s__Russia) ).

fof(kb_SUMO_5954,axiom,
    s__names('Afghanistan',s__Afghanistan) ).

fof(kb_SUMO_5955,axiom,
    s__names('Bangladesh',s__Bangladesh) ).

fof(kb_SUMO_5956,axiom,
    s__names('Bhutan',s__Bhutan) ).

fof(kb_SUMO_5957,axiom,
    s__names('British Indian Ocean Territory',s__BritishIndianOceanTerritory) ).

fof(kb_SUMO_5958,axiom,
    s__names('India',s__India) ).

fof(kb_SUMO_5959,axiom,
    s__names('Maldives',s__Maldives) ).

fof(kb_SUMO_5960,axiom,
    s__names('Nepal',s__Nepal) ).

fof(kb_SUMO_5961,axiom,
    s__names('Pakistan',s__Pakistan) ).

fof(kb_SUMO_5962,axiom,
    s__names('Sri Lanka',s__SriLanka) ).

fof(kb_SUMO_5963,axiom,
    s__names('French Southern and Antarctic Lands',s__FrenchSouthernAndAntarcticLands) ).

fof(kb_SUMO_5964,axiom,
    s__names('Ashmore and Cartier Islands',s__AshmoreAndCartierIslands) ).

fof(kb_SUMO_5965,axiom,
    s__names('Brunei',s__Brunei) ).

fof(kb_SUMO_5966,axiom,
    s__names('Cambodia',s__Cambodia) ).

fof(kb_SUMO_5967,axiom,
    s__names('Christmas Island',s__ChristmasIsland) ).

fof(kb_SUMO_5968,axiom,
    s__names('Cocos Keeling Islands',s__CocosKeelingIslands) ).

fof(kb_SUMO_5969,axiom,
    s__names('East Timor',s__EastTimor) ).

fof(kb_SUMO_5970,axiom,
    s__names('Indonesia',s__Indonesia) ).

fof(kb_SUMO_5971,axiom,
    s__names('Laos',s__Laos) ).

fof(kb_SUMO_5972,axiom,
    s__names('Malaysia',s__Malaysia) ).

fof(kb_SUMO_5973,axiom,
    s__names('Myanmar',s__Myanmar) ).

fof(kb_SUMO_5974,axiom,
    s__names('Papua New Guinea',s__PapuaNewGuinea) ).

fof(kb_SUMO_5975,axiom,
    s__names('Paracel Islands',s__ParacelIslands) ).

fof(kb_SUMO_5976,axiom,
    s__names('Philippines',s__Philippines) ).

fof(kb_SUMO_5977,axiom,
    s__names('Singapore',s__Singapore) ).

fof(kb_SUMO_5978,axiom,
    s__names('Spratly Islands',s__SpratlyIslands) ).

fof(kb_SUMO_5979,axiom,
    s__names('Thailand',s__Thailand) ).

fof(kb_SUMO_5980,axiom,
    s__names('Vietnam',s__Vietnam) ).

fof(kb_SUMO_5981,axiom,
    s__names('Armenia',s__Armenia) ).

fof(kb_SUMO_5982,axiom,
    s__names('Azerbaijan',s__Azerbaijan) ).

fof(kb_SUMO_5983,axiom,
    s__names('Republic Of Georgia',s__RepublicOfGeorgia) ).

fof(kb_SUMO_5984,axiom,
    s__names('American Samoa',s__AmericanSamoa) ).

fof(kb_SUMO_5985,axiom,
    s__names('Australia',s__Australia) ).

fof(kb_SUMO_5986,axiom,
    s__names('Baker Island',s__BakerIsland) ).

fof(kb_SUMO_5987,axiom,
    s__names('Cook Islands',s__CookIslands) ).

fof(kb_SUMO_5988,axiom,
    s__names('Coral Sea Islands',s__CoralSeaIslands) ).

fof(kb_SUMO_5989,axiom,
    s__names('Fiji',s__Fiji) ).

fof(kb_SUMO_5990,axiom,
    s__names('French Polynesia',s__FrenchPolynesia) ).

fof(kb_SUMO_5991,axiom,
    s__names('Guam',s__Guam) ).

fof(kb_SUMO_5992,axiom,
    s__names('Howland Island',s__HowlandIsland) ).

fof(kb_SUMO_5993,axiom,
    s__names('Jarvis Island',s__JarvisIsland) ).

fof(kb_SUMO_5994,axiom,
    s__names('Johnston Atoll',s__JohnstonAtoll) ).

fof(kb_SUMO_5995,axiom,
    s__names('Kingman Reef',s__KingmanReef) ).

fof(kb_SUMO_5996,axiom,
    s__names('Kiribati',s__Kiribati) ).

fof(kb_SUMO_5997,axiom,
    s__formerName('Gilbert Islands',s__Kiribati) ).

fof(kb_SUMO_5998,axiom,
    s__names('Marshall Islands',s__MarshallIslands) ).

fof(kb_SUMO_5999,axiom,
    s__names('Micronesia',s__Micronesia) ).

fof(kb_SUMO_6000,axiom,
    s__conventionalLongName('Federated States of Micronesia',s__Micronesia) ).

fof(kb_SUMO_6001,axiom,
    s__names('Midway Islands',s__MidwayIslands) ).

fof(kb_SUMO_6002,axiom,
    s__names('Nauru',s__Nauru) ).

fof(kb_SUMO_6003,axiom,
    s__names('New Caledonia',s__NewCaledonia) ).

fof(kb_SUMO_6004,axiom,
    s__names('New Zealand',s__NewZealand) ).

fof(kb_SUMO_6005,axiom,
    s__names('Niue',s__Niue) ).

fof(kb_SUMO_6006,axiom,
    s__names('Norfolk Island',s__NorfolkIsland) ).

fof(kb_SUMO_6007,axiom,
    s__names('Northern Mariana Islands',s__NorthernMarianaIslands) ).

fof(kb_SUMO_6008,axiom,
    s__names('Palau',s__Palau) ).

fof(kb_SUMO_6009,axiom,
    s__names('Palmyra Atoll',s__PalmyraAtoll) ).

fof(kb_SUMO_6010,axiom,
    s__names('Pitcairn Islands',s__PitcairnIslands) ).

fof(kb_SUMO_6011,axiom,
    s__names('Samoa',s__Samoa) ).

fof(kb_SUMO_6012,axiom,
    s__names('Solomon Islands',s__SolomonIslands) ).

fof(kb_SUMO_6013,axiom,
    s__names('Tokelau',s__Tokelau) ).

fof(kb_SUMO_6014,axiom,
    s__names('Tonga',s__Tonga) ).

fof(kb_SUMO_6015,axiom,
    s__names('Tuvalu',s__Tuvalu) ).

fof(kb_SUMO_6016,axiom,
    s__formerName('Ellice Islands',s__Tuvalu) ).

fof(kb_SUMO_6017,axiom,
    s__names('Vanuatu',s__Vanuatu) ).

fof(kb_SUMO_6018,axiom,
    s__formerName('New Hebrides',s__Vanuatu) ).

fof(kb_SUMO_6019,axiom,
    s__names('Wake Island',s__WakeIsland) ).

fof(kb_SUMO_6020,axiom,
    s__names('Wallis and Futuna',s__WallisAndFutuna) ).

fof(kb_SUMO_6021,axiom,
    s__instance(s__GazaStrip,s__GeopoliticalArea) ).

fof(kb_SUMO_6022,axiom,
    s__instance(s__ParacelIslands,s__GeopoliticalArea) ).

fof(kb_SUMO_6023,axiom,
    s__instance(s__SpratlyIslands,s__GeopoliticalArea) ).

fof(kb_SUMO_6024,axiom,
    s__instance(s__WestBank,s__GeopoliticalArea) ).

fof(kb_SUMO_6025,axiom,
    s__instance(s__WesternSahara,s__GeopoliticalArea) ).

fof(kb_SUMO_6026,axiom,
    s__instance(s__Antarctica,s__GeopoliticalArea) ).

fof(kb_SUMO_6027,axiom,
    s__instance(s__RedRiver,s__River) ).

fof(kb_SUMO_6028,axiom,
    s__part(s__RedRiver,s__MississippiRiver) ).

fof(kb_SUMO_6029,axiom,
    s__part(s__RedRiver,s__UnitedStates) ).

fof(kb_SUMO_6030,axiom,
    s__documentation(s__RedRiver,s__EnglishLanguage,'A tributary of the Mississippi River.') ).

fof(kb_SUMO_6031,axiom,
    s__instance(s__Guam,s__Island) ).

fof(kb_SUMO_6032,axiom,
    s__documentation(s__Guam,s__EnglishLanguage,'An &%Island in the &%PacificOcean that is a protectorate of the &%UnitedStates.') ).

fof(kb_SUMO_6033,axiom,
    s__subclass(s__Coffeeshop,s__Cafeteria) ).

fof(kb_SUMO_6034,axiom,
    s__instance(s__Coffeeshop__t,s__SetOrClass) ).

fof(kb_SUMO_6035,axiom,
    s__documentation(s__Coffeeshop,s__EnglishLanguage,'a type of &%Cafeteria that specializes in serving &%Coffee') ).

fof(kb_SUMO_6036,axiom,
    s__termFormat(s__EnglishLanguage,s__Coffeeshop,'coffee shop') ).

fof(kb_SUMO_6037,axiom,
    ! [V__COMPANY] :
      ( s__instance(V__COMPANY,s__Agent)
     => ( s__instance(V__COMPANY,s__Coffeeshop)
       => ? [V__SERVICE,V__BEVERAGE] :
            ( s__instance(V__SERVICE,s__Process)
            & s__instance(V__SERVICE,s__CommercialService)
            & s__agent(V__SERVICE,V__COMPANY)
            & s__instance(V__SERVICE,s__Selling)
            & s__patient(V__SERVICE,V__BEVERAGE)
            & s__instance(V__BEVERAGE,s__Coffee) ) ) ) ).

fof(kb_SUMO_6038,axiom,
    s__subclass(s__Brewpub,s__Tavern) ).

fof(kb_SUMO_6039,axiom,
    s__instance(s__Brewpub__t,s__SetOrClass) ).

fof(kb_SUMO_6040,axiom,
    s__documentation(s__Brewpub,s__EnglishLanguage,'a type of &%Tavern that brews &%Beer and whose primary service is selling that &%Beer to customers') ).

fof(kb_SUMO_6041,axiom,
    s__termFormat(s__EnglishLanguage,s__Brewpub,'Brewpub') ).

fof(kb_SUMO_6042,axiom,
    ! [V__PUB] :
      ( s__instance(V__PUB,s__Agent)
     => ( s__instance(V__PUB,s__Brewpub)
       => ? [V__SERVICE,V__BEER,V__BREW] :
            ( s__instance(V__BREW,s__Process)
            & s__instance(V__SERVICE,s__Process)
            & s__instance(V__BREW,s__Making)
            & s__result(V__BREW,V__BEER)
            & s__instance(V__BEER,s__Beer)
            & s__agent(V__BREW,V__PUB)
            & s__instance(V__SERVICE,s__CommercialService)
            & s__agent(V__SERVICE,V__PUB)
            & s__instance(V__SERVICE,s__Selling)
            & s__patient(V__SERVICE,V__BEER) ) ) ) ).

fof(kb_SUMO_6043,axiom,
    s__subclass(s__Bakery,s__Business) ).

fof(kb_SUMO_6044,axiom,
    s__instance(s__Bakery__t,s__SetOrClass) ).

fof(kb_SUMO_6045,axiom,
    s__documentation(s__Bakery,s__EnglishLanguage,'a type of &%Business that specializes in the production and selling of the &%result of the process &%Baking') ).

fof(kb_SUMO_6046,axiom,
    s__termFormat(s__EnglishLanguage,s__Bakery,bakery) ).

fof(kb_SUMO_6047,axiom,
    ! [V__BAKERY] :
      ( s__instance(V__BAKERY,s__Agent)
     => ( s__instance(V__BAKERY,s__Bakery)
       => ? [V__SERVICE,V__FOOD,V__BAKE] :
            ( s__instance(V__BAKE,s__Process)
            & s__instance(V__SERVICE,s__Process)
            & s__instance(V__BAKE,s__Baking)
            & s__result(V__BAKE,V__FOOD)
            & s__instance(V__FOOD,s__FoodForFn(s__Human))
            & s__agent(V__BAKE,V__BAKERY)
            & s__instance(V__SERVICE,s__CommercialService)
            & s__agent(V__SERVICE,V__BAKERY)
            & s__instance(V__SERVICE,s__Selling)
            & s__patient(V__SERVICE,V__FOOD) ) ) ) ).

fof(kb_SUMO_6048,axiom,
    s__subclass(s__Steakhouse,s__Restaurant) ).

fof(kb_SUMO_6049,axiom,
    s__instance(s__Steakhouse__t,s__SetOrClass) ).

fof(kb_SUMO_6050,axiom,
    s__documentation(s__Steakhouse,s__EnglishLanguage,'a type of &%Restaurant that specializes in serving steak, which is cooked &%Beef') ).

fof(kb_SUMO_6051,axiom,
    s__termFormat(s__EnglishLanguage,s__Steakhouse,steakhouse) ).

fof(kb_SUMO_6052,axiom,
    ! [V__STEAKHOUSE,V__COOK] :
      ( ( s__instance(V__COOK,s__Process)
        & s__instance(V__STEAKHOUSE,s__Agent) )
     => ( s__instance(V__STEAKHOUSE,s__Steakhouse)
       => ? [V__SERVICE,V__STEAK,V__BEEF] :
            ( s__instance(V__BEEF,s__Object)
            & s__instance(V__SERVICE,s__Process)
            & s__instance(V__COOK,s__Cooking)
            & s__instance(V__BEEF,s__Beef)
            & s__resource(V__COOK,V__BEEF)
            & s__result(V__COOK,V__STEAK)
            & s__instance(V__SERVICE,s__CommercialService)
            & s__agent(V__SERVICE,V__STEAKHOUSE)
            & s__instance(V__SERVICE,s__Selling)
            & s__patient(V__SERVICE,V__STEAK) ) ) ) ).

fof(kb_SUMO_6053,axiom,
    s__subclass(s__Corkage,s__ChargingAFee) ).

fof(kb_SUMO_6054,axiom,
    s__instance(s__Corkage__t,s__SetOrClass) ).

fof(kb_SUMO_6055,axiom,
    s__instance(s__ChargingAFee__t,s__SetOrClass) ).

fof(kb_SUMO_6056,axiom,
    s__documentation(s__Corkage,s__EnglishLanguage,'&%Corkage is a &%FinancialTransaction imposed by an &%Agent to a customer for bringing items not purchased from &%Agent') ).

fof(kb_SUMO_6057,axiom,
    s__termFormat(s__EnglishLanguage,s__Corkage,corkage) ).

fof(kb_SUMO_6058,axiom,
    ! [V__C] :
      ( s__instance(V__C,s__ChargingAFee)
     => ( s__instance(V__C,s__Corkage)
       => ? [V__AMT] :
            ( s__instance(V__AMT,s__CurrencyMeasure)
            & s__amountCharged(V__C,V__AMT) ) ) ) ).

fof(kb_SUMO_6059,axiom,
    s__instance(s__corkageFee__m,s__TernaryPredicate) ).

fof(kb_SUMO_6060,axiom,
    s__documentation(s__corkageFee__m,s__EnglishLanguage,'(&%corkageFee ?AMT ?ITEM ?AGENT) refers to the amount ?AMT that ?AGENT charges during a &%Corkage when a customer brings in ?ITEM') ).

fof(kb_SUMO_6061,axiom,
    s__termFormat(s__EnglishLanguage,s__corkageFee__m,'corkage fee') ).

fof(kb_SUMO_6062,axiom,
    s__domain(s__corkageFee__m,"1",s__CurrencyMeasure) ).

fof(kb_SUMO_6063,axiom,
    s__domainSubclass(s__corkageFee__m,"2",s__Object) ).

fof(kb_SUMO_6064,axiom,
    s__domain(s__corkageFee__m,"3",s__Agent) ).

%FOL fof(kb_SUMO_6065,axiom,(( (! [V__P,V__ITEM,V__X,V__AGENT,V__CUST,V__AMT,V__LOC] : ((s__instance(V__LOC,s__Object) & s__instance(V__AMT,s__CurrencyMeasure) & s__instance(V__CUST,s__CognitiveAgent) & s__instance(V__AGENT,s__CognitiveAgent) & s__instance(V__X,s__Object) & s__subclass(V__ITEM,s__Object) & s__instance(V__ITEM,s__SetOrClass) & s__instance(V__P,s__Process)) => ((s__customer(V__CUST,V__AGENT) & s__corkageFee(V__AMT,V__ITEM,V__AGENT) & s__instance(V__X,V__ITEM) & (~ (? [V__B] : (s__instance(V__B,s__Process) & s__instance(V__B,s__Buying) & s__patient(V__B,V__X) & s__destination(V__B,V__CUST) & s__origin(V__B,V__AGENT)))) & s__holdsDuring(s__WhenFn('s__located(V__CUST,V__LOC)'),'(s__instance(V__P,s__IntentionalProcess) & (s__patient(V__P,V__X) | s__resource(V__P,V__X) | s__instrument(V__P,V__X)) & s__agent(V__P,V__CUST))')) => (? [V__C] : (s__instance(V__C,s__Process) & s__instance(V__C,s__Corkage) & s__agent(V__C,V__CUST) & s__destination(V__C,V__AGENT)))))) ))).

fof(kb_SUMO_6066,axiom,
    s__subclass(s__OutdoorDiningArea,s__DiningArea) ).

fof(kb_SUMO_6067,axiom,
    s__instance(s__OutdoorDiningArea__t,s__SetOrClass) ).

fof(kb_SUMO_6068,axiom,
    s__documentation(s__OutdoorDiningArea,s__EnglishLanguage,'&%OutdoorDiningArea refers to a place for eating that is not inside a building') ).

fof(kb_SUMO_6069,axiom,
    s__termFormat(s__EnglishLanguage,s__OutdoorDiningArea,'outdoor dining') ).

fof(kb_SUMO_6070,axiom,
    s__disjoint(s__OutdoorDiningArea,s__DiningRoom) ).

fof(kb_SUMO_6071,axiom,
    ! [V__D] :
      ( s__instance(V__D,s__Physical)
     => ( s__instance(V__D,s__OutdoorDiningArea)
       => ? [V__O] :
            ( s__instance(V__O,s__Object)
            & s__instance(V__O,s__Outdoors)
            & s__located(V__D,V__O) ) ) ) ).

fof(kb_SUMO_6072,axiom,
    s__subclass(s__Menu,s__Catalog) ).

fof(kb_SUMO_6073,axiom,
    s__documentation(s__Menu,s__EnglishLanguage,'a &%Menu is a type of &%Catalog that specifically contains the classes of food that is expected to be or proposed to be cooked and served') ).

fof(kb_SUMO_6074,axiom,
    s__termFormat(s__EnglishLanguage,s__Menu,menu) ).

fof(kb_SUMO_6075,axiom,
    ! [V__MENU] :
      ( s__instance(V__MENU,s__Menu)
     => ! [V__X] :
          ( ( s__instance(V__X,s__SetOrClass)
            & s__instance(V__MENU,s__Catalog) )
         => ( s__catalogItem(V__X,V__MENU)
           => s__subclass(V__X,s__FoodForFn(s__Human)) ) ) ) ).

fof(kb_SUMO_6076,axiom,
    s__subclass(s__SetMenu,s__Menu) ).

fof(kb_SUMO_6077,axiom,
    s__instance(s__SetMenu__t,s__SetOrClass) ).

fof(kb_SUMO_6078,axiom,
    s__documentation(s__SetMenu,s__EnglishLanguage,'a &%SetMenu is a type of &%Menu that contains a specific set of prepared food which is all served and is given one price') ).

fof(kb_SUMO_6079,axiom,
    s__termFormat(s__EnglishLanguage,s__SetMenu,'set menu') ).

fof(kb_SUMO_6080,axiom,
    ! [V__AGENT,V__MENU,V__PRICE] :
      ( ( s__instance(V__PRICE,s__CurrencyMeasure)
        & s__instance(V__MENU,s__Abstract)
        & s__instance(V__MENU,s__Physical)
        & s__instance(V__AGENT,s__Agent) )
     => ( ( s__instance(V__MENU,s__SetMenu)
          & s__offers(V__AGENT,V__MENU) )
       => s__price(V__MENU,V__PRICE,V__AGENT) ) ) ).

fof(kb_SUMO_6081,axiom,
    s__subclass(s__BeverageMenu,s__Menu) ).

fof(kb_SUMO_6082,axiom,
    s__instance(s__BeverageMenu__t,s__SetOrClass) ).

fof(kb_SUMO_6083,axiom,
    s__instance(s__Menu__t,s__SetOrClass) ).

fof(kb_SUMO_6084,axiom,
    s__documentation(s__BeverageMenu,s__EnglishLanguage,'a &%BeverageMenu is a &%Menu of &%Beverages') ).

fof(kb_SUMO_6085,axiom,
    s__termFormat(s__EnglishLanguage,s__BeverageMenu,'drinks menu') ).

fof(kb_SUMO_6086,axiom,
    ! [V__MEMB,V__MENU] :
      ( s__instance(V__MENU,s__BeverageMenu)
     => ! [V__X] :
          ( ( s__instance(V__MENU,s__Catalog)
            & s__instance(V__MEMB,s__SetOrClass) )
         => ( s__catalogItem(V__X,V__MENU)
           => s__subclass(V__MEMB,s__Beverage) ) ) ) ).

fof(kb_SUMO_6087,axiom,
    s__subclass(s__AlcoholMenu,s__BeverageMenu) ).

fof(kb_SUMO_6088,axiom,
    s__instance(s__AlcoholMenu__t,s__SetOrClass) ).

fof(kb_SUMO_6089,axiom,
    s__documentation(s__AlcoholMenu,s__EnglishLanguage,'an &%AlcoholMenu is a &%Menu of &%AlcoholicBeverage') ).

fof(kb_SUMO_6090,axiom,
    s__termFormat(s__EnglishLanguage,s__AlcoholMenu,'cocktail menu') ).

fof(kb_SUMO_6091,axiom,
    ! [V__MEMB,V__MENU] :
      ( s__instance(V__MENU,s__AlcoholMenu)
     => ! [V__X] :
          ( ( s__instance(V__MENU,s__Catalog)
            & s__instance(V__MEMB,s__SetOrClass) )
         => ( s__catalogItem(V__X,V__MENU)
           => s__subclass(V__MEMB,s__AlcoholicBeverage) ) ) ) ).

fof(kb_SUMO_6092,axiom,
    s__subclass(s__WineMenu,s__AlcoholMenu) ).

fof(kb_SUMO_6093,axiom,
    s__instance(s__WineMenu__t,s__SetOrClass) ).

fof(kb_SUMO_6094,axiom,
    s__documentation(s__WineMenu,s__EnglishLanguage,'a &%WineMenu is a &%Menu of &%Wine') ).

fof(kb_SUMO_6095,axiom,
    s__termFormat(s__EnglishLanguage,s__WineMenu,'wine list') ).

fof(kb_SUMO_6096,axiom,
    ! [V__MEMB,V__MENU] :
      ( s__instance(V__MENU,s__WineMenu)
     => ! [V__X] :
          ( ( s__instance(V__MENU,s__Catalog)
            & s__instance(V__MEMB,s__SetOrClass) )
         => ( s__catalogItem(V__X,V__MENU)
           => s__subclass(V__MEMB,s__WineMenu) ) ) ) ).

fof(kb_SUMO_6097,axiom,
    s__instance(s__Braille,s__PerceptualAttribute) ).

fof(kb_SUMO_6098,axiom,
    s__documentation(s__Braille,s__EnglishLanguage,'&%Braille is an &%Attribute that describes &%ContentBearingObject that can be interpreted by a &%Blind &%Human') ).

fof(kb_SUMO_6099,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Object)
     => ( s__attribute(V__X,s__Braille)
       => s__instance(V__X,s__ContentBearingObject) ) ) ).

fof(kb_SUMO_6100,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Object)
     => ( ( s__instance(V__X,s__ContentBearingObject)
          & s__attribute(V__X,s__Braille) )
       => ? [V__H] :
            ( s__instance(V__H,s__Object)
            & s__instance(V__H,s__Human)
            & s__attribute(V__H,s__Blind)
            & s__capability(s__Interpreting,s__agent__m,V__H)
            & s__capability(s__Interpreting,s__patient__m,V__X) ) ) ) ).

fof(kb_SUMO_6101,axiom,
    s__subclass(s__Buffet,s__Collection) ).

fof(kb_SUMO_6102,axiom,
    s__instance(s__Buffet__t,s__SetOrClass) ).

fof(kb_SUMO_6103,axiom,
    s__documentation(s__Buffet,s__EnglishLanguage,'&%Buffet refers to a &%Collection of food that is served in a central location where guests can get their own servings') ).

fof(kb_SUMO_6104,axiom,
    s__termFormat(s__EnglishLanguage,s__Buffet,buffet) ).

fof(kb_SUMO_6105,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Buffet)
     => ! [V__ITEM] :
          ( ( s__instance(V__ITEM,s__SelfConnectedObject)
            & s__instance(V__X,s__Collection) )
         => ( s__member(V__ITEM,V__X)
           => s__instance(V__ITEM,s__FoodForFn(s__Human)) ) ) ) ).

fof(kb_SUMO_6106,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Object)
     => ( s__instance(V__X,s__Buffet)
       => s__attribute(V__X,s__CommunalAttribute) ) ) ).

fof(kb_SUMO_6107,axiom,
    ! [V__E,V__ITEM,V__X,V__AGENT,V__LOC1,V__LOC2] :
      ( ( s__instance(V__LOC2,s__Object)
        & s__instance(V__LOC1,s__Object)
        & s__instance(V__AGENT,s__Agent)
        & s__instance(V__X,s__Collection)
        & s__instance(V__ITEM,s__SelfConnectedObject)
        & s__instance(V__E,s__Process) )
     => ( ( s__instance(V__X,s__Buffet)
          & s__member(V__ITEM,V__X)
          & s__located(V__X,V__LOC1)
          & s__instance(V__E,s__Eating)
          & s__agent(V__E,V__AGENT)
          & s__eventLocated(V__E,V__LOC2)
          & s__patient(V__E,V__ITEM) )
       => ( V__LOC1 != V__LOC2
          & ? [V__G] :
              ( s__instance(V__G,s__Process)
              & s__instance(V__G,s__Getting)
              & s__patient(V__G,V__ITEM)
              & s__origin(V__G,V__LOC1)
              & s__agent(V__G,V__AGENT)
              & s__before(s__WhenFn(V__G),s__WhenFn(V__E)) ) ) ) ) ).

fof(kb_SUMO_6108,axiom,
    ! [V__X] :
      ( ( s__instance(V__X,s__Buffet)
        & s__attribute(V__X,s__Breakfast) )
     => s__modalAttribute('(! [V__FOOD] : ((s__instance(V__FOOD,s__SelfConnectedObject) & s__instance(V__X,s__Collection)) => (s__member(V__FOOD,V__X) => s__attribute(V__FOOD,s__Breakfast))))',s__Likely) ) ).

fof(kb_SUMO_6109,axiom,
    s__documentation(s__subjectiveAttribute__m,s__EnglishLanguage,'(&%subjectiveAttribute ?ENTITY ?ATTR ?AGENT) means that ?AGENT attaches ?ATTR to ?ENTITY') ).

fof(kb_SUMO_6110,axiom,
    s__instance(s__subjectiveAttribute__m,s__TernaryPredicate) ).

fof(kb_SUMO_6111,axiom,
    s__domain(s__subjectiveAttribute__m,"1",s__Entity) ).

fof(kb_SUMO_6112,axiom,
    s__domain(s__subjectiveAttribute__m,"2",s__Attribute) ).

fof(kb_SUMO_6113,axiom,
    s__domain(s__subjectiveAttribute__m,"3",s__Agent) ).

fof(kb_SUMO_6114,axiom,
    s__termFormat(s__EnglishLanguage,s__subjectiveAttribute__m,'subjective attribute') ).

fof(kb_SUMO_6115,axiom,
    ! [V__ATTR,V__AGENT,V__ENTITY] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__ATTR,s__Attribute) )
     => ( s__subjectiveAttribute(V__ENTITY,V__ATTR,V__AGENT)
       => ? [V__RATE] :
            ( s__instance(V__RATE,s__Process)
            & s__instance(V__RATE,s__Classifying)
            & s__agent(V__RATE,V__AGENT)
            & s__patient(V__RATE,V__ATTR)
            & s__destination(V__RATE,V__ENTITY) ) ) ) ).

fof(kb_SUMO_6116,axiom,
    s__instance(s__facility__m,s__BinaryPredicate) ).

fof(kb_SUMO_6117,axiom,
    s__documentation(s__facility__m,s__EnglishLanguage,'(&%facility ?AGENT ?OBJ) means that an ?AGENT provides some ?OBJ to fulfill some goal or need') ).

fof(kb_SUMO_6118,axiom,
    s__domain(s__facility__m,"2",s__Object) ).

fof(kb_SUMO_6119,axiom,
    s__domain(s__facility__m,"1",s__Agent) ).

fof(kb_SUMO_6120,axiom,
    s__termFormat(s__EnglishLanguage,s__facility__m,facility) ).

%FOL fof(kb_SUMO_6121,axiom,(( (! [V__OBJ,V__X,V__CUST,V__AGENT] : ((s__instance(V__AGENT,s__CognitiveAgent) & s__instance(V__CUST,s__CognitiveAgent) & s__instance(V__X,s__Agent) & s__instance(V__OBJ,s__Object) & s__instance(V__OBJ,s__SetOrClass)) => ((s__facility(V__AGENT,V__OBJ) & s__customer(V__CUST,V__AGENT) & s__instance(V__X,V__OBJ) & (? [V__PROC] : (s__instance(V__PROC,s__Process) & s__instance(V__PROC,s__IntentionalProcess) & s__patient(V__PROC,V__X) & s__agent(V__PROC,V__CUST)))) => s__confersRight('s__uses(V__CUST,V__X)',V__AGENT,V__CUST)))) ))).

fof(kb_SUMO_6122,axiom,
    ! [V__AGENT,V__TIMEINT] :
      ( ( s__subclass(V__TIMEINT,s__TimeInterval)
        & s__instance(V__TIMEINT,s__SetOrClass)
        & s__instance(V__AGENT,s__Agent) )
     => s__businessHours(V__TIMEINT,V__AGENT) ) ).

fof(kb_SUMO_6123,axiom,
    s__instance(s__businessHours__m,s__BinaryPredicate) ).

fof(kb_SUMO_6124,axiom,
    s__documentation(s__businessHours__m,s__EnglishLanguage,'(&%businessHours ?TIMEINT ?AGENT) means that an ?AGENT conducts business-related activities during ?TIMEINT') ).

fof(kb_SUMO_6125,axiom,
    s__domainSubclass(s__businessHours__m,"1",s__TimeInterval) ).

fof(kb_SUMO_6126,axiom,
    s__domain(s__businessHours__m,"2",s__Agent) ).

fof(kb_SUMO_6127,axiom,
    s__termFormat(s__EnglishLanguage,s__businessHours__m,'business hours') ).

fof(kb_SUMO_6128,axiom,
    s__subrelation(s__standardRetailHours__m,s__businessHours__m) ).

fof(kb_SUMO_6129,axiom,
    s__documentation(s__standardRetailHours__m,s__EnglishLanguage,'(%&standardRetailHours ?TIMEINT ?AGENT) means that an ?AGENT initiates face-to-face processes with customers only within the time specified by ?TIMEINT') ).

fof(kb_SUMO_6130,axiom,
    s__domainSubclass(s__standardRetailHours__m,"1",s__TimeInterval) ).

fof(kb_SUMO_6131,axiom,
    s__domain(s__standardRetailHours__m,"2",s__Agent) ).

fof(kb_SUMO_6132,axiom,
    s__termFormat(s__EnglishLanguage,s__standardRetailHours__m,'standard retail hours') ).

%FOL fof(kb_SUMO_6133,axiom,(( (! [V__P,V__START,V__C,V__AGENT,V__NUMBER2,V__TIMEINT,V__NUMBER1] : ((s__instance(V__NUMBER1,s__RealNumber) & s__subclass(V__TIMEINT,s__TimeInterval) & s__instance(V__TIMEINT,s__TimeInterval) & s__instance(V__TIMEINT,s__SetOrClass) & s__instance(V__NUMBER2,s__RealNumber) & s__instance(V__AGENT,s__Agent) & s__instance(V__C,s__CognitiveAgent) & s__instance(V__START,s__Physical) & s__instance(V__P,s__Process)) => ((s__standardRetailHours(V__TIMEINT,V__AGENT) & s__potentialCustomer(V__C,V__AGENT) & s__instance(V__P,s__IntentionalProcess) & s__destination(V__P,V__C) & s__instance(V__START,s__StartFn(V__P)) & s__conditionalProbability('s__during(s__WhenFn(V__START),V__TIMEINT)','s__agent(V__P,V__AGENT)',V__NUMBER1) & s__conditionalProbability('(~ s__during(s__WhenFn(V__START),V__TIMEINT))','s__agent(V__P,V__AGENT)',V__NUMBER2)) => less(V__NUMBER2,V__NUMBER1)))) ))).

fof(kb_SUMO_6134,axiom,
    ! [V__X] :
      ( ( s__subclass(V__X,s__TimeInterval)
        & s__instance(V__X,s__SetOrClass) )
     => ( s__instance(V__X,s__NightClub)
       => ? [V__TIME] :
            ( s__instance(V__TIME,s__Agent)
            & s__instance(V__TIME,s__TimeInterval)
            & s__standardRetailHours(V__X,V__TIME)
            & s__during(s__BeginFn(V__TIME),s__NightTime) ) ) ) ).

fof(kb_SUMO_6135,axiom,
    s__subclass(s__BankCardPayment,s__Payment) ).

fof(kb_SUMO_6136,axiom,
    s__instance(s__BankCardPayment__t,s__SetOrClass) ).

fof(kb_SUMO_6137,axiom,
    s__documentation(s__BankCardPayment,s__EnglishLanguage,'a &%BankCardPayment is a type of &%Payment where a &%CreditCard or a &%DebitCard is used as the &%FinancialInstrument in the transaction.') ).

fof(kb_SUMO_6138,axiom,
    s__termFormat(s__EnglishLanguage,s__BankCardPayment,'bank card payment') ).

fof(kb_SUMO_6139,axiom,
    ! [V__P,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Object)
        & s__instance(V__P,s__Process) )
     => ( ( s__instance(V__P,s__BankCardPayment)
          & s__destination(V__P,V__AGENT) )
       => s__capability(s__BankCardPayment,s__destination__m,V__AGENT) ) ) ).

fof(kb_SUMO_6140,axiom,
    ! [V__P,V__C] :
      ( ( s__instance(V__C,s__Object)
        & s__instance(V__P,s__Process) )
     => ( s__instance(V__P,s__BankCardPayment)
       => ( s__instrument(V__P,V__C)
          & s__instance(V__C,s__BankCard) ) ) ) ).

fof(kb_SUMO_6141,axiom,
    s__subclass(s__CashPayment,s__Payment) ).

fof(kb_SUMO_6142,axiom,
    s__instance(s__CashPayment__t,s__SetOrClass) ).

fof(kb_SUMO_6143,axiom,
    s__instance(s__Payment__t,s__SetOrClass) ).

fof(kb_SUMO_6144,axiom,
    s__documentation(s__CashPayment,s__EnglishLanguage,'a &%CashPayment is a type of &%Payment where &%Cash is used as the &%FinancialInstrument in the transaction') ).

fof(kb_SUMO_6145,axiom,
    s__termFormat(s__EnglishLanguage,s__CashPayment,'cash payment') ).

fof(kb_SUMO_6146,axiom,
    ! [V__P,V__C] :
      ( ( s__instance(V__C,s__Object)
        & s__instance(V__P,s__Process) )
     => ( s__instance(V__P,s__CashPayment)
       => ( s__instrument(V__P,V__C)
          & s__instance(V__C,s__Cash) ) ) ) ).

fof(kb_SUMO_6147,axiom,
    s__subclass(s__Outfit,s__Collection) ).

fof(kb_SUMO_6148,axiom,
    s__instance(s__Outfit__t,s__SetOrClass) ).

fof(kb_SUMO_6149,axiom,
    s__documentation(s__Outfit,s__EnglishLanguage,'&%Outfit describes the set of clothes worn by a person') ).

fof(kb_SUMO_6150,axiom,
    s__termFormat(s__EnglishLanguage,s__Outfit,outfit) ).

%FOL fof(kb_SUMO_6151,axiom,(( (! [V__TIME,V__PERSON,V__ITEM1,V__X] : ((s__instance(V__X,s__Outfit) & s__member(V__ITEM1,V__X) & s__holdsDuring(V__TIME,'s__wears(V__PERSON,V__ITEM1)')) => (! [V__ITEM2] : ((s__instance(V__ITEM2,s__SelfConnectedObject) & s__instance(V__ITEM2,s__WearableItem) & s__instance(V__X,s__Collection) & s__instance(V__ITEM1,s__SelfConnectedObject) & s__instance(V__ITEM1,s__WearableItem) & s__instance(V__PERSON,s__Animal) & s__instance(V__TIME,s__TimePosition)) => (s__member(V__ITEM2,V__X) => s__holdsDuring(V__TIME,'s__wears(V__PERSON,V__ITEM2)')))))) ))).

fof(kb_SUMO_6152,axiom,
    s__instance(s__dressCode__m,s__BinaryPredicate) ).

fof(kb_SUMO_6153,axiom,
    s__documentation(s__dressCode__m,s__EnglishLanguage,'(&%dressCode ?CODE ?AGENT) means that ?AGENT obligates his customers to wear at the minimum clothes that fulfill ?CODE') ).

fof(kb_SUMO_6154,axiom,
    s__domain(s__dressCode__m,"1",s__AmbienceAttribute) ).

fof(kb_SUMO_6155,axiom,
    s__domain(s__dressCode__m,"2",s__Agent) ).

fof(kb_SUMO_6156,axiom,
    ! [V__OUTFIT,V__CODE,V__CUST,V__AGENT] :
      ( s__dressCode(V__CODE,V__AGENT)
     => s__modalAttribute('(s__subjectiveAttribute(V__OUTFIT,V__CODE,V__AGENT) & s__instance(V__OUTFIT,s__Outfit) & s__customer(V__CUST,V__AGENT) & s__holdsDuring(s__WhenFn(s__located(V__CUST,V__AGENT)),(! [V__ITEM] : ((s__instance(V__ITEM,s__SelfConnectedObject) & s__instance(V__ITEM,s__WearableItem) & s__instance(V__AGENT,s__CognitiveAgent) & s__instance(V__CUST,s__CognitiveAgent) & s__instance(V__CUST,s__Animal) & s__instance(V__CODE,s__AmbienceAttribute) & s__instance(V__OUTFIT,s__Collection)) => (s__member(V__ITEM,V__OUTFIT) => s__wears(V__CUST,V__ITEM))))))',s__Obligation) ) ).

fof(kb_SUMO_6157,axiom,
    s__subclass(s__DeliveryService,s__Transfer) ).

fof(kb_SUMO_6158,axiom,
    s__instance(s__DeliveryService__t,s__SetOrClass) ).

fof(kb_SUMO_6159,axiom,
    s__documentation(s__DeliveryService,s__EnglishLanguage,'&%DeliveryService refers to the &%Transfer of an &%Agent bringing objects purchased from &%Agent to a location indicated by the customer') ).

fof(kb_SUMO_6160,axiom,
    s__termFormat(s__EnglishLanguage,s__DeliveryService,'delivery service') ).

fof(kb_SUMO_6161,axiom,
    ! [V__D,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__D,s__Process) )
     => ( ( s__instance(V__D,s__DeliveryService)
          & s__agent(V__D,V__AGENT) )
       => s__capability(s__DeliveryService,s__agent__m,V__AGENT) ) ) ).

fof(kb_SUMO_6162,axiom,
    s__instance(s__deliveryRegion__m,s__BinaryPredicate) ).

fof(kb_SUMO_6163,axiom,
    s__documentation(s__deliveryRegion__m,s__EnglishLanguage,'(&%deliveryRegion ?AGENT ?REGION ?DELIVERY) means that ?AGENT only does a &%DeliveryService if the destination is within ?REGION') ).

fof(kb_SUMO_6164,axiom,
    s__domain(s__deliveryRegion__m,"1",s__Agent) ).

fof(kb_SUMO_6165,axiom,
    s__domain(s__deliveryRegion__m,"2",s__GeographicArea) ).

fof(kb_SUMO_6166,axiom,
    ! [V__REGION,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__REGION,s__GeographicArea) )
     => ( s__deliveryRegion(V__AGENT,V__REGION)
       => s__capability(s__DeliveryService,s__agent__m,V__AGENT) ) ) ).

%FOL fof(kb_SUMO_6167,axiom,(( (! [V__REGION,V__D,V__AGENT,V__NUMBER2,V__LOC1,V__NUMBER1] : ((s__instance(V__NUMBER1,s__RealNumber) & s__instance(V__LOC1,s__Physical) & s__instance(V__NUMBER2,s__RealNumber) & s__instance(V__AGENT,s__Agent) & s__instance(V__D,s__Process) & s__instance(V__REGION,s__GeographicArea)) => ((s__instance(V__D,s__DeliveryService) & s__destination(V__D,V__LOC1) & s__deliveryRegion(V__AGENT,V__REGION) & s__conditionalProbability('s__located(V__LOC1,V__REGION)','s__agent(V__D,V__AGENT)',V__NUMBER1) & s__conditionalProbability('(~ s__located(V__LOC1,V__REGION))','s__agent(V__D,V__AGENT)',V__NUMBER2)) => less(V__NUMBER2,V__NUMBER1)))) ))).

fof(kb_SUMO_6168,axiom,
    ! [V__D,V__LOC1,V__LOC2] :
      ( ( s__instance(V__LOC1,s__Object)
        & s__instance(V__D,s__Process) )
     => ( ( s__instance(V__D,s__DeliveryService)
          & s__origin(V__D,V__LOC1)
          & s__destination(V__D,V__LOC2) )
       => V__LOC1 != V__LOC2 ) ) ).

fof(kb_SUMO_6169,axiom,
    s__subclass(s__CateringService,s__ServiceProcess) ).

fof(kb_SUMO_6170,axiom,
    s__instance(s__CateringService__t,s__SetOrClass) ).

fof(kb_SUMO_6171,axiom,
    s__documentation(s__CateringService,s__EnglishLanguage,'&%CateringService refers to the &%ServiceProcess of an &%Agent to prepare food and beverage for consumption in a location away from where the agent is located') ).

fof(kb_SUMO_6172,axiom,
    s__termFormat(s__EnglishLanguage,s__CateringService,catering) ).

fof(kb_SUMO_6173,axiom,
    ! [V__P,V__REST] :
      ( ( s__instance(V__REST,s__Agent)
        & s__subclass(V__P,s__Process)
        & s__instance(V__P,s__Process)
        & s__instance(V__P,s__SetOrClass) )
     => ( ( s__instance(V__P,s__CateringService)
          & s__agent(V__P,V__REST) )
       => s__capability(V__P,s__agent__m,V__REST) ) ) ).

fof(kb_SUMO_6174,axiom,
    ! [V__C,V__CUST,V__AGENT,V__LOC1,V__LOC2] :
      ( ( s__instance(V__LOC2,s__Object)
        & s__instance(V__LOC1,s__Object)
        & s__instance(V__AGENT,s__CognitiveAgent)
        & s__instance(V__CUST,s__CognitiveAgent)
        & s__instance(V__C,s__Process) )
     => ( ( s__instance(V__C,s__CateringService)
          & s__agent(V__C,V__AGENT)
          & s__destination(V__C,V__CUST)
          & s__located(V__AGENT,V__LOC1)
          & s__customer(V__CUST,V__AGENT)
          & ? [V__S,V__FOOD,V__E] :
              ( s__instance(V__E,s__Process)
              & s__instance(V__S,s__Process)
              & s__instance(V__S,s__Cooking)
              & s__agent(V__S,V__AGENT)
              & s__result(V__S,V__FOOD)
              & s__patient(V__C,V__FOOD)
              & s__instance(V__E,s__Eating)
              & s__agent(V__E,V__CUST)
              & s__eventLocated(V__E,V__LOC2) ) )
       => V__LOC1 != V__LOC2 ) ) ).

fof(kb_SUMO_6175,axiom,
    s__subclass(s__FoodPickup,s__CateringService) ).

fof(kb_SUMO_6176,axiom,
    s__documentation(s__FoodPickup,s__EnglishLanguage,'&%FoodPickup is a type of &%CateringService where the customer has to pick up the food from the agents location with the intent of eating it somewhere else.') ).

fof(kb_SUMO_6177,axiom,
    s__termFormat(s__EnglishLanguage,s__FoodPickup,'food pickup') ).

fof(kb_SUMO_6178,axiom,
    ! [V__P,V__CUST,V__AGENT,V__FOOD] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__CUST,s__Agent)
        & s__instance(V__P,s__Process) )
     => ( ( s__instance(V__P,s__FoodPickup)
          & s__agent(V__P,V__AGENT)
          & s__destination(V__P,V__CUST)
          & s__patient(V__P,V__FOOD) )
       => ( s__instance(V__FOOD,s__FoodForFn(s__Human))
          & ? [V__LOC,V__T,V__G] :
              ( s__instance(V__G,s__Process)
              & s__instance(V__T,s__Process)
              & s__instance(V__LOC,s__Object)
              & s__located(V__AGENT,V__LOC)
              & s__instance(V__T,s__Translocation)
              & s__agent(V__T,V__CUST)
              & s__destination(V__T,V__LOC)
              & s__instance(V__G,s__Getting)
              & s__origin(V__G,V__AGENT)
              & s__destination(V__G,V__CUST)
              & s__patient(V__G,V__FOOD) ) ) ) ) ).

fof(kb_SUMO_6179,axiom,
    s__subclass(s__DriveThru,s__FoodPickup) ).

fof(kb_SUMO_6180,axiom,
    s__instance(s__DriveThru__t,s__SetOrClass) ).

fof(kb_SUMO_6181,axiom,
    s__instance(s__FoodPickup__t,s__SetOrClass) ).

fof(kb_SUMO_6182,axiom,
    s__documentation(s__DriveThru,s__EnglishLanguage,'&%DriveThru is a type of &%FoodPickup where the customer uses a vehicle to drive thru a driveway and take the food from a window') ).

fof(kb_SUMO_6183,axiom,
    s__termFormat(s__EnglishLanguage,s__DriveThru,'Drive-thru') ).

fof(kb_SUMO_6184,axiom,
    s__subclass(s__Reservation,s__Agreement) ).

fof(kb_SUMO_6185,axiom,
    s__instance(s__Reservation__t,s__SetOrClass) ).

fof(kb_SUMO_6186,axiom,
    s__documentation(s__Reservation,s__EnglishLanguage,'a &%Reservation is a type of &%Agreement between 2 agents that some resource offered by the one agent is allotted for use or consumption by another at a specific bounded time') ).

fof(kb_SUMO_6187,axiom,
    s__termFormat(s__EnglishLanguage,s__Reservation,reservation) ).

fof(kb_SUMO_6188,axiom,
    ! [V__R] :
      ( s__instance(V__R,s__Reservation)
     => ? [V__P] :
          ( s__instance(V__P,s__Process)
          & s__instance(V__P,s__Reserving)
          & s__result(V__P,V__R) ) ) ).

fof(kb_SUMO_6189,axiom,
    s__instance(s__reservingEntity__m,s__BinaryPredicate) ).

fof(kb_SUMO_6190,axiom,
    s__documentation(s__reservingEntity__m,s__EnglishLanguage,'(&%reservingEntity ?ENTITY ?RESERVE) means that ?ENTITY is the &%Agent reserving a particular resource indicated by ?RESERVE') ).

fof(kb_SUMO_6191,axiom,
    s__domain(s__reservingEntity__m,"1",s__Agent) ).

fof(kb_SUMO_6192,axiom,
    s__domain(s__reservingEntity__m,"2",s__Reservation) ).

fof(kb_SUMO_6193,axiom,
    ! [V__RESERVE,V__ENTITY] :
      ( ( s__instance(V__ENTITY,s__Agent)
        & s__instance(V__RESERVE,s__Reservation) )
     => ( s__reservingEntity(V__ENTITY,V__RESERVE)
       => ? [V__P] :
            ( s__instance(V__P,s__Process)
            & s__instance(V__P,s__Reserving)
            & s__agent(V__P,V__ENTITY)
            & s__result(V__P,V__RESERVE) ) ) ) ).

fof(kb_SUMO_6194,axiom,
    s__instance(s__reservationChannel__m,s__BinaryPredicate) ).

fof(kb_SUMO_6195,axiom,
    s__documentation(s__reservationChannel__m,s__EnglishLanguage,'(&%reservationChannel ?ENTITY ?RESERVE) means that ?ENTITY was used by the &%reservingEntity in order to create the reservation, like an intermediary agent.') ).

fof(kb_SUMO_6196,axiom,
    s__domain(s__reservationChannel__m,"1",s__Physical) ).

fof(kb_SUMO_6197,axiom,
    s__domain(s__reservationChannel__m,"2",s__Reservation) ).

fof(kb_SUMO_6198,axiom,
    ! [V__RESERVE,V__ENTITY] :
      ( ( s__instance(V__ENTITY,s__Object)
        & s__instance(V__RESERVE,s__Reservation) )
     => ( s__reservationChannel(V__ENTITY,V__RESERVE)
       => ? [V__P] :
            ( s__instance(V__P,s__Process)
            & s__instance(V__P,s__Reserving)
            & s__instrument(V__P,V__ENTITY)
            & s__result(V__P,V__RESERVE) ) ) ) ).

fof(kb_SUMO_6199,axiom,
    s__instance(s__fulfillingEntity__m,s__BinaryPredicate) ).

fof(kb_SUMO_6200,axiom,
    s__documentation(s__fulfillingEntity__m,s__EnglishLanguage,'(&%fulfillingEntity ?ENTITY ?RESERVE) means that ?ENTITY is the &%Agent who will execute the agreement') ).

fof(kb_SUMO_6201,axiom,
    s__domain(s__fulfillingEntity__m,"1",s__Agent) ).

fof(kb_SUMO_6202,axiom,
    s__domain(s__fulfillingEntity__m,"2",s__Reservation) ).

fof(kb_SUMO_6203,axiom,
    ! [V__RESERVE,V__ENTITY] :
      ( ( s__instance(V__ENTITY,s__Agent)
        & s__instance(V__RESERVE,s__Reservation) )
     => ( s__fulfillingEntity(V__ENTITY,V__RESERVE)
       => ? [V__P] :
            ( s__instance(V__P,s__Process)
            & s__instance(V__P,s__Reserving)
            & s__destination(V__P,V__ENTITY)
            & s__result(V__P,V__RESERVE) ) ) ) ).

fof(kb_SUMO_6204,axiom,
    s__instance(s__reservationStart__m,s__BinaryPredicate) ).

fof(kb_SUMO_6205,axiom,
    s__documentation(s__reservationStart__m,s__EnglishLanguage,'(&%reservationStart ?TIME ?RESERVE) means that the use of a resource or consumption of a service which is the object of ?RESERVE starts at ?TIME') ).

fof(kb_SUMO_6206,axiom,
    s__domain(s__reservationStart__m,"1",s__TimePoint) ).

fof(kb_SUMO_6207,axiom,
    s__domain(s__reservationStart__m,"2",s__Reservation) ).

fof(kb_SUMO_6208,axiom,
    s__instance(s__reservationEnd__m,s__BinaryPredicate) ).

fof(kb_SUMO_6209,axiom,
    s__documentation(s__reservationEnd__m,s__EnglishLanguage,'(&%reservationEnd ?TIME ?RESERVE) means that the use of a resource or consumption of a service which is the object of ?RESERVE is expected to end at ?TIME') ).

fof(kb_SUMO_6210,axiom,
    s__domain(s__reservationEnd__m,"1",s__TimePoint) ).

fof(kb_SUMO_6211,axiom,
    s__domain(s__reservationEnd__m,"2",s__Reservation) ).

%FOL fof(kb_SUMO_6212,axiom,(( (! [V__R,V__AGENT,V__CUST,V__TIME2,V__TIME1] : ((s__instance(V__TIME1,s__TimePoint) & s__instance(V__TIME2,s__TimePoint) & s__instance(V__CUST,s__Agent) & s__instance(V__AGENT,s__Agent) & s__instance(V__R,s__Reservation)) => ((s__reservationStart(V__TIME1,V__R) & s__reservationEnd(V__TIME2,V__R) & s__reservingEntity(V__CUST,V__R) & s__fulfillingEntity(V__AGENT,V__R)) => s__modalAttribute('s__holdsDuring(s__TimeIntervalFn(V__TIME1,V__TIME2),(? [V__P] : (s__instance(V__P,s__Process) & s__instance(V__P,s__IntentionalProcess) & s__agent(V__P,V__AGENT) & s__destination(V__P,V__CUST))))',s__Likely)))) ))).

fof(kb_SUMO_6213,axiom,
    s__instance(s__numberOfCustomers__m,s__BinaryPredicate) ).

fof(kb_SUMO_6214,axiom,
    s__documentation(s__numberOfCustomers__m,s__EnglishLanguage,'(&%numberOfCustomers ?NUM ?RESERVE) refers to the number of patrons the reservation is for.') ).

fof(kb_SUMO_6215,axiom,
    s__domain(s__numberOfCustomers__m,"1",s__PositiveInteger) ).

fof(kb_SUMO_6216,axiom,
    s__domain(s__numberOfCustomers__m,"2",s__Reservation) ).

fof(kb_SUMO_6217,axiom,
    ! [V__RESERVE,V__CUST,V__AGENT,V__NUM] :
      ( ( s__instance(V__NUM,s__PositiveInteger)
        & s__instance(V__AGENT,s__Agent)
        & s__instance(V__CUST,s__Agent)
        & s__instance(V__CUST,s__SelfConnectedObject)
        & s__instance(V__RESERVE,s__Reservation) )
     => ( ( s__numberOfCustomers(V__NUM,V__RESERVE)
          & s__fulfillingEntity(V__AGENT,V__RESERVE)
          & s__reservingEntity(V__CUST,V__RESERVE) )
       => ? [V__GRP] :
            ( s__instance(V__GRP,s__CognitiveAgent)
            & s__instance(V__GRP,s__Collection)
            & s__potentialCustomer(V__GRP,V__AGENT)
            & s__instance(V__GRP,s__GroupOfPeople)
            & s__member(V__CUST,V__GRP)
            & s__memberCount(V__GRP,"2") ) ) ) ).

fof(kb_SUMO_6218,axiom,
    s__subclass(s__DiningReservation,s__Reservation) ).

fof(kb_SUMO_6219,axiom,
    s__instance(s__DiningReservation__t,s__SetOrClass) ).

fof(kb_SUMO_6220,axiom,
    s__documentation(s__DiningReservation,s__EnglishLanguage,'a &%DiningReservation is a type of &%Reservation intended to reserve seats at a &%Restaurant') ).

fof(kb_SUMO_6221,axiom,
    s__termFormat(s__EnglishLanguage,s__DiningReservation,'dining reservation') ).

fof(kb_SUMO_6222,axiom,
    ! [V__R,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__R,s__Reservation) )
     => ( s__instance(V__R,s__DiningReservation)
       => ( s__fulfillingEntity(V__AGENT,V__R)
          & s__instance(V__AGENT,s__Restaurant) ) ) ) ).

fof(kb_SUMO_6223,axiom,
    s__subclass(s__Reserving,s__Committing) ).

fof(kb_SUMO_6224,axiom,
    s__instance(s__Reserving__t,s__SetOrClass) ).

fof(kb_SUMO_6225,axiom,
    s__documentation(s__Reserving,s__EnglishLanguage,'&%Reserving is a type of &%Committing that dedicates a specific object or service to a destination resource or service for a specific time interval') ).

fof(kb_SUMO_6226,axiom,
    s__termFormat(s__EnglishLanguage,s__Reserving,reserving) ).

fof(kb_SUMO_6227,axiom,
    ! [V__R,V__AGENT,V__CUST] :
      ( ( s__instance(V__CUST,s__CognitiveAgent)
        & s__instance(V__AGENT,s__Agent)
        & s__instance(V__R,s__Process) )
     => ( ( s__instance(V__R,s__Reserving)
          & s__agent(V__R,V__CUST)
          & s__destination(V__R,V__AGENT) )
       => s__potentialCustomer(V__CUST,V__AGENT) ) ) ).

%FOL fof(kb_SUMO_6228,axiom,(( (! [V__R,V__CUST,V__AGENT,V__NUM2,V__NUM1] : ((s__instance(V__NUM1,s__RealNumber) & s__instance(V__NUM2,s__RealNumber) & s__instance(V__AGENT,s__CognitiveAgent) & s__instance(V__CUST,s__CognitiveAgent) & s__instance(V__R,s__Process)) => ((s__instance(V__AGENT,s__Agent) & s__potentialCustomer(V__CUST,V__AGENT) & s__modalAttribute('(s__instance(V__R,s__Reserving) & s__destination(V__R,V__AGENT))',s__Necessity) & s__conditionalProbability('(? [V__RES1] : (s__instance(V__RES1,s__Reservation) & s__reservingEntity(V__CUST,V__RES1) & s__fulfillingEntity(V__AGENT,V__RES1)))','s__customer(V__CUST,V__AGENT)',V__NUM1) & s__conditionalProbability('(~ (? [V__RES2] : (s__instance(V__RES2,s__Reservation) & s__reservingEntity(V__CUST,V__RES2) & s__fulfillingEntity(V__AGENT,V__RES2))))','s__customer(V__CUST,V__AGENT)',V__NUM2)) => less(V__NUM2,V__NUM1)))) ))).

fof(kb_SUMO_6229,axiom,
    s__instance(s__potentialCustomer__m,s__BinaryPredicate) ).

fof(kb_SUMO_6230,axiom,
    s__documentation(s__potentialCustomer__m,s__EnglishLanguage,'(&%potentialCustomer ?CUST ?AGENT) means that it is a possibility for ?CUST to participate in a financial transaction with ?AGENT in exchange for goods or services') ).

fof(kb_SUMO_6231,axiom,
    s__domain(s__potentialCustomer__m,"1",s__CognitiveAgent) ).

fof(kb_SUMO_6232,axiom,
    s__domain(s__potentialCustomer__m,"2",s__Agent) ).

fof(kb_SUMO_6233,axiom,
    ! [V__AGENT,V__CUST] :
      ( ( s__instance(V__CUST,s__CognitiveAgent)
        & s__instance(V__AGENT,s__Agent) )
     => ( s__potentialCustomer(V__CUST,V__AGENT)
       => ? [V__P,V__SELLING] :
            ( s__instance(V__SELLING,s__Process)
            & s__instance(V__SELLING,s__Selling)
            & s__agent(V__SELLING,V__AGENT)
            & s__patient(V__SELLING,V__P)
            & s__inScopeOfInterest(V__CUST,V__P) ) ) ) ).

%FOL fof(kb_SUMO_6234,axiom,(( (! [V__AGENT,V__CUST] : ((s__instance(V__CUST,s__CognitiveAgent) & s__instance(V__AGENT,s__CognitiveAgent)) => (s__potentialCustomer(V__CUST,V__AGENT) => s__modalAttribute('s__customer(V__CUST,V__AGENT)',s__Possibility)))) ))).

fof(kb_SUMO_6235,axiom,
    s__instance(s__Chef,s__Profession) ).

fof(kb_SUMO_6236,axiom,
    s__documentation(s__Chef,s__EnglishLanguage,'&%Chef refers to the &%Profession of cooking food') ).

fof(kb_SUMO_6237,axiom,
    s__termFormat(s__EnglishLanguage,s__Chef,chef) ).

fof(kb_SUMO_6238,axiom,
    ! [V__X] :
      ( s__instance(V__X,s__Human)
     => ( s__attribute(V__X,s__Chef)
       => s__occupation(V__X,s__OccupationFn(s__Cooking)) ) ) ).

fof(kb_SUMO_6239,axiom,
    s__subclass(s__BoosterChair,s__Chair) ).

fof(kb_SUMO_6240,axiom,
    s__instance(s__BoosterChair__t,s__SetOrClass) ).

fof(kb_SUMO_6241,axiom,
    s__documentation(s__BoosterChair,s__EnglishLanguage,'&%BoosterChair is a &%Chair that is made for children') ).

fof(kb_SUMO_6242,axiom,
    s__termFormat(s__EnglishLanguage,s__BoosterChair,'booster chair') ).

fof(kb_SUMO_6243,axiom,
    ! [V__H,V__BC] :
      ( ( s__instance(V__BC,s__Object)
        & s__instance(V__H,s__Process)
        & s__instance(V__H,s__CognitiveAgent) )
     => ( ( s__instance(V__BC,s__BoosterChair)
          & s__instance(V__H,s__HumanChild) )
       => s__hasPurposeForAgent(V__BC,'(s__attribute(V__H,s__Sitting) & s__eventLocated(V__H,V__BC))',V__H) ) ) ).

fof(kb_SUMO_6244,axiom,
    s__instance(s__contestObject__m,s__TernaryPredicate) ).

fof(kb_SUMO_6245,axiom,
    s__documentation(s__contestObject__m,s__EnglishLanguage,'(&%contestObject ?CONTEST ?OBJ ?AGENT) refers to the ?OBJ entered by ?AGENT in a ?CONTEST in cases where winning is based on judging an &%Object instead of some physical process between opponents') ).

fof(kb_SUMO_6246,axiom,
    s__domain(s__contestObject__m,"1",s__Contest) ).

fof(kb_SUMO_6247,axiom,
    s__domain(s__contestObject__m,"2",s__Object) ).

fof(kb_SUMO_6248,axiom,
    s__domain(s__contestObject__m,"3",s__Agent) ).

%FOL fof(kb_SUMO_6249,axiom,(( (! [V__OBJ,V__CONTEST,V__ATTR,V__AGENT] : ((s__instance(V__AGENT,s__Agent) & s__instance(V__ATTR,s__Attribute) & s__instance(V__CONTEST,s__Contest) & s__instance(V__OBJ,s__Object)) => (s__contestObject(V__CONTEST,V__OBJ,V__AGENT) => (s__contestParticipant(V__CONTEST,V__AGENT) & (? [V__MAKE,V__JUDGE,V__PROC] : (s__instance(V__PROC,s__Process) & s__instance(V__JUDGE,s__Agent) & s__instance(V__MAKE,s__Process) & s__instance(V__MAKE,s__Making) & s__result(V__MAKE,V__OBJ) & s__agent(V__MAKE,V__AGENT) & s__instance(V__PROC,s__Judging) & s__agent(V__PROC,V__JUDGE) & s__patient(V__PROC,V__OBJ) & s__result(V__PROC,'s__subjectiveAttribute(V__OBJ,V__ATTR,V__JUDGE)') & s__subProcess(V__PROC,V__CONTEST))))))) ))).

fof(kb_SUMO_6250,axiom,
    ! [V__X,V__JUDGE] :
      ( ( s__instance(V__JUDGE,s__Agent)
        & s__instance(V__X,s__Object) )
     => ( ( s__subjectiveAttribute(V__X,s__Won,V__JUDGE)
          & s__instance(V__X,s__FoodForFn(s__Human)) )
       => ? [V__CONTEST,V__AGENT,V__PROC] :
            ( s__instance(V__PROC,s__Process)
            & s__instance(V__AGENT,s__Agent)
            & s__instance(V__CONTEST,s__Contest)
            & s__contestObject(V__CONTEST,V__X,V__AGENT)
            & s__instance(V__PROC,s__Judging)
            & s__agent(V__PROC,V__JUDGE)
            & s__subProcess(V__PROC,V__CONTEST) ) ) ) ).

fof(kb_SUMO_6251,axiom,
    s__instance(s__capabilityDuring__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_6252,axiom,
    s__documentation(s__capabilityDuring__m,s__EnglishLanguage,'(&%capabilityDuring ?PROCESS ?ROLE ?OBJ ?TIMEINT) means that ?OBJ has the ability to play the role of ?ROLE in the process ?PROCESS during the time indicated by ?TIMEINT') ).

fof(kb_SUMO_6253,axiom,
    s__termFormat(s__EnglishLanguage,s__capabilityDuring__m,'capable during') ).

fof(kb_SUMO_6254,axiom,
    s__domainSubclass(s__capabilityDuring__m,"1",s__Process) ).

fof(kb_SUMO_6255,axiom,
    s__domain(s__capabilityDuring__m,"2",s__CaseRole) ).

fof(kb_SUMO_6256,axiom,
    s__domain(s__capabilityDuring__m,"3",s__Object) ).

fof(kb_SUMO_6257,axiom,
    s__domainSubclass(s__capabilityDuring__m,"4",s__TimeInterval) ).

%FOL fof(kb_SUMO_6258,axiom,(( (! [V__OBJ,V__ROLE,V__PROCESS,V__TIMEINT] : ((s__subclass(V__TIMEINT,s__TimeInterval) & s__instance(V__TIMEINT,s__SetOrClass) & s__instance(V__TIMEINT,s__TimePosition) & s__subclass(V__PROCESS,s__Process) & s__instance(V__PROCESS,s__SetOrClass) & s__instance(V__ROLE,s__CaseRole) & s__instance(V__OBJ,s__Object)) => (s__capabilityDuring(V__PROCESS,V__ROLE,V__OBJ,V__TIMEINT) => (? [V__TIME] : (s__instance(V__TIME,V__TIMEINT) & s__holdsDuring(V__TIMEINT,'s__capability(V__PROCESS,V__ROLE,V__OBJ)')))))) ))).

fof(kb_SUMO_6259,axiom,
    s__subclass(s__View,s__VisualContentBearingPhysical) ).

fof(kb_SUMO_6260,axiom,
    s__instance(s__View__t,s__SetOrClass) ).

fof(kb_SUMO_6261,axiom,
    s__documentation(s__View,s__EnglishLanguage,'&%View refers to the patient of a &%Seeing process') ).

fof(kb_SUMO_6262,axiom,
    s__termFormat(s__EnglishLanguage,s__View,view) ).

fof(kb_SUMO_6263,axiom,
    ! [V__VIEW] :
      ( s__instance(V__VIEW,s__View)
     => ? [V__ENTITY] :
          ( s__instance(V__ENTITY,s__Physical)
          & s__represents(V__VIEW,V__ENTITY) ) ) ).

fof(kb_SUMO_6264,axiom,
    s__instance(s__OpenLayout,s__RelationalAttribute) ).

fof(kb_SUMO_6265,axiom,
    s__documentation(s__OpenLayout,s__EnglishLanguage,'&%OpenLayout refers to different functional areas that are adjacent to each other and are visible from one area to another') ).

fof(kb_SUMO_6266,axiom,
    s__termFormat(s__EnglishLanguage,s__OpenLayout,'open layout') ).

fof(kb_SUMO_6267,axiom,
    ! [V__ROOM,V__H] :
      ( ( s__instance(V__H,s__Object)
        & s__instance(V__ROOM,s__Object) )
     => ( s__attribute(V__ROOM,s__OpenLayout)
       => ( s__instance(V__ROOM,s__Room)
          & ? [V__R1,V__R2] :
              ( s__instance(V__R1,s__Region)
              & s__instance(V__R2,s__Region)
              & s__located(V__R1,V__ROOM)
              & s__located(V__R2,V__ROOM)
              & V__R1 != V__R2
              & s__orientation(V__R1,V__R2,s__Adjacent)
              & ? [V__P1,V__P2] :
                  ( s__instance(V__P2,s__Formula)
                  & s__instance(V__P1,s__Formula)
                  & s__instance(V__R2,s__Object)
                  & s__instance(V__R1,s__Object)
                  & s__instance(V__P1,s__Process)
                  & s__instance(V__P2,s__Process)
                  & s__hasPurpose(V__R1,V__P1)
                  & s__hasPurpose(V__R2,V__P2) )
              & ( ( s__instance(V__H,s__Agent)
                  & s__located(V__H,V__R2) )
               => ( s__capability(s__Seeing,s__agent__m,V__H)
                  & s__capability(s__Seeing,s__patient__m,V__R1) ) ) ) ) ) ) ).

fof(kb_SUMO_6268,axiom,
    s__subclass(s__PlayArea,s__Region) ).

fof(kb_SUMO_6269,axiom,
    s__instance(s__PlayArea__t,s__SetOrClass) ).

fof(kb_SUMO_6270,axiom,
    s__documentation(s__PlayArea,s__EnglishLanguage,'&%PlayArea refers to a &%Region where children engage in recreational activities') ).

fof(kb_SUMO_6271,axiom,
    s__termFormat(s__EnglishLanguage,s__PlayArea,playground) ).

fof(kb_SUMO_6272,axiom,
    ! [V__P] :
      ( s__instance(V__P,s__Object)
     => ( s__instance(V__P,s__PlayArea)
       => s__hasPurpose(V__P,'(? [V__K,V__REC] : (s__instance(V__REC,s__Process) & s__instance(V__K,s__Agent) & s__instance(V__REC,s__RecreationOrExercise) & s__eventLocated(V__REC,V__P) & s__instance(V__K,s__HumanChild) & s__agent(V__REC,V__K)))') ) ) ).

fof(kb_SUMO_6273,axiom,
    s__instance(s__Organic,s__NormativeAttribute) ).

fof(kb_SUMO_6274,axiom,
    s__documentation(s__Organic,s__EnglishLanguage,'&%Organic describes the minimal use of chemicals in the production of an object') ).

fof(kb_SUMO_6275,axiom,
    s__termFormat(s__EnglishLanguage,s__Organic,organic) ).

fof(kb_SUMO_6276,axiom,
    s__instance(s__Favorite,s__NormativeAttribute) ).

fof(kb_SUMO_6277,axiom,
    s__documentation(s__Favorite,s__EnglishLanguage,'&%Favorite is an attribute that describes how an agent prefers one thing over another') ).

fof(kb_SUMO_6278,axiom,
    s__termFormat(s__EnglishLanguage,s__Favorite,favorite) ).

%FOL fof(kb_SUMO_6279,axiom,(( (! [V__CLASS,V__X,V__AGENT] : ((s__instance(V__AGENT,s__CognitiveAgent) & s__instance(V__X,s__Physical) & s__instance(V__CLASS,s__SetOrClass)) => ((s__subjectiveAttribute(V__X,s__Favorite,V__AGENT) & s__instance(V__X,V__CLASS)) => (? [V__Y] : (s__instance(V__Y,s__Physical) & (~ s__subjectiveAttribute(V__Y,s__Favorite,V__AGENT)) & s__instance(V__Y,V__CLASS) & s__prefers(V__AGENT,'s__wants(V__AGENT,V__X)','s__wants(V__AGENT,V__Y)')))))) ))).

fof(kb_SUMO_6280,axiom,
    s__subclass(s__TimeAttribute,s__SubjectiveAssessmentAttribute) ).

fof(kb_SUMO_6281,axiom,
    s__documentation(s__TimeAttribute,s__EnglishLanguage,'&%TimeAttribute refers to the class of attributes that include and assessment of how long it takes an agent to do something') ).

fof(kb_SUMO_6282,axiom,
    ! [V__OBJ,V__ATTR,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__ATTR,s__Attribute) )
     => ( ( s__subjectiveAttribute(V__OBJ,V__ATTR,V__AGENT)
          & s__instance(V__ATTR,s__TimeAttribute) )
       => s__instance(V__OBJ,s__Agent) ) ) ).

fof(kb_SUMO_6283,axiom,
    s__instance(s__Quick,s__TimeAttribute) ).

fof(kb_SUMO_6284,axiom,
    s__instance(s__TimeAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_6285,axiom,
    s__documentation(s__Quick,s__EnglishLanguage,'&%Quick describes how a process takes less time than expected') ).

fof(kb_SUMO_6286,axiom,
    s__termFormat(s__EnglishLanguage,s__Quick,quick) ).

fof(kb_SUMO_6287,axiom,
    s__instance(s__Slow,s__TimeAttribute) ).

fof(kb_SUMO_6288,axiom,
    s__documentation(s__Slow,s__EnglishLanguage,'&%Slow describes how a process takes more time than expected') ).

fof(kb_SUMO_6289,axiom,
    s__termFormat(s__EnglishLanguage,s__Slow,slow) ).

fof(kb_SUMO_6290,axiom,
    ! [V__PROCESS2,V__PERSON,V__CLASS,V__PROCESS1,V__AGENT2,V__TIME2,V__AGENT1,V__TIME1] :
      ( ( s__instance(V__TIME1,s__TimeDuration)
        & s__instance(V__AGENT1,s__Agent)
        & s__instance(V__TIME2,s__TimeDuration)
        & s__instance(V__AGENT2,s__Agent)
        & s__instance(V__PROCESS1,s__Process)
        & s__instance(V__CLASS,s__SetOrClass)
        & s__instance(V__PERSON,s__Agent)
        & s__instance(V__PROCESS2,s__Process) )
     => ( ( s__subjectiveAttribute(V__AGENT1,s__Quick,V__PERSON)
          & s__subjectiveAttribute(V__AGENT2,s__Slow,V__PERSON)
          & s__instance(V__PROCESS1,V__CLASS)
          & s__instance(V__PROCESS2,V__CLASS)
          & s__subclass(V__CLASS,s__Process)
          & s__agent(V__PROCESS1,V__AGENT1)
          & s__agent(V__PROCESS2,V__AGENT2) )
       => ( s__duration(s__WhenFn(V__PROCESS1),V__TIME1)
          & s__duration(s__WhenFn(V__PROCESS2),V__TIME2)
          & greater(V__TIME2,V__TIME1) ) ) ) ).

fof(kb_SUMO_6291,axiom,
    s__subclass(s__AmbienceAttribute,s__SubjectiveAssessmentAttribute) ).

fof(kb_SUMO_6292,axiom,
    s__documentation(s__AmbienceAttribute,s__EnglishLanguage,'&%AmbienceAttribute describes the atmosphere or general feeling that something evokes') ).

fof(kb_SUMO_6293,axiom,
    s__termFormat(s__EnglishLanguage,s__AmbienceAttribute,ambience) ).

fof(kb_SUMO_6294,axiom,
    ! [V__ATTR,V__X] :
      ( ( s__instance(V__X,s__Object)
        & s__instance(V__ATTR,s__Attribute) )
     => ( ( s__attribute(V__X,V__ATTR)
          & s__instance(V__ATTR,s__AmbienceAttribute) )
       => s__instance(V__X,s__Physical) ) ) ).

fof(kb_SUMO_6295,axiom,
    s__instance(s__RomanticAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6296,axiom,
    s__documentation(s__RomanticAttribute,s__EnglishLanguage,'&%RomanticAttribute describes that something is of an amorous or non-platonic nature') ).

fof(kb_SUMO_6297,axiom,
    s__termFormat(s__EnglishLanguage,s__RomanticAttribute,romantic) ).

fof(kb_SUMO_6298,axiom,
    s__instance(s__UnconventionalAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6299,axiom,
    s__documentation(s__UnconventionalAttribute,s__EnglishLanguage,'&%UnconventionalAttribute describes that something does not conform to the ordinary or the usual') ).

fof(kb_SUMO_6300,axiom,
    s__termFormat(s__EnglishLanguage,s__UnconventionalAttribute,unconventional) ).

fof(kb_SUMO_6301,axiom,
    s__instance(s__TrendyAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6302,axiom,
    s__documentation(s__TrendyAttribute,s__EnglishLanguage,'&%TrendyAttribute describes that something is in accord with the latest fad') ).

fof(kb_SUMO_6303,axiom,
    s__termFormat(s__EnglishLanguage,s__TrendyAttribute,trendy) ).

fof(kb_SUMO_6304,axiom,
    s__instance(s__ConventionalAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6305,axiom,
    s__documentation(s__ConventionalAttribute,s__EnglishLanguage,'&%ConventionalAttribute describes that something conforms to norms and expectations') ).

fof(kb_SUMO_6306,axiom,
    s__termFormat(s__EnglishLanguage,s__ConventionalAttribute,conventional) ).

fof(kb_SUMO_6307,axiom,
    s__successorAttributeClosure(s__ConventionalAttribute,s__UnconventionalAttribute) ).

fof(kb_SUMO_6308,axiom,
    s__instance(s__CasualAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6309,axiom,
    s__documentation(s__CasualAttribute,s__EnglishLanguage,'&%CasualAttribute describes that something is appropriate for ordinary or routine occasions') ).

fof(kb_SUMO_6310,axiom,
    s__termFormat(s__EnglishLanguage,s__CasualAttribute,casual) ).

fof(kb_SUMO_6311,axiom,
    s__instance(s__FormalAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6312,axiom,
    s__documentation(s__FormalAttribute,s__EnglishLanguage,'&%FormalAttribute describes that something is refined or meets a certain standard') ).

fof(kb_SUMO_6313,axiom,
    s__termFormat(s__EnglishLanguage,s__FormalAttribute,formal) ).

fof(kb_SUMO_6314,axiom,
    s__instance(s__BusinessCasualAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6315,axiom,
    s__documentation(s__BusinessCasualAttribute,s__EnglishLanguage,'&%BusinessCasualAttribute describes that something is appropriate for a normal business setting') ).

fof(kb_SUMO_6316,axiom,
    s__termFormat(s__EnglishLanguage,s__BusinessCasualAttribute,'business casual') ).

fof(kb_SUMO_6317,axiom,
    s__instance(s__BusinessFormalAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6318,axiom,
    s__instance(s__AmbienceAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_6319,axiom,
    s__documentation(s__BusinessFormalAttribute,s__EnglishLanguage,'&%BusinessFormalAttribute describes that something is appropriate for a stricter or more refined business setting') ).

fof(kb_SUMO_6320,axiom,
    s__termFormat(s__EnglishLanguage,s__BusinessFormalAttribute,'business formal') ).

fof(kb_SUMO_6321,axiom,
    s__instance(s__CasualDressyAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6322,axiom,
    s__documentation(s__CasualDressyAttribute,s__EnglishLanguage,'&%CasualDressyAttribute describes that something is fancier than &%CasualAttribute, normally applied to clothing but can also be applied to things like the ambience of a club or bar') ).

fof(kb_SUMO_6323,axiom,
    s__termFormat(s__EnglishLanguage,s__CasualDressyAttribute,'casual dressy') ).

fof(kb_SUMO_6324,axiom,
    s__instance(s__DressyAttribute,s__AmbienceAttribute) ).

fof(kb_SUMO_6325,axiom,
    s__documentation(s__DressyAttribute,s__EnglishLanguage,'&%DressyAttribute describes a less laid-back and fancier atmosphere, normally applied to clothing but can also be applied to things like the ambience of a club, bar or event') ).

fof(kb_SUMO_6326,axiom,
    s__termFormat(s__EnglishLanguage,s__DressyAttribute,dressy) ).

fof(kb_SUMO_6327,axiom,
    s__subclass(s__FoodAttribute,s__SubjectiveAssessmentAttribute) ).

fof(kb_SUMO_6328,axiom,
    s__documentation(s__FoodAttribute,s__EnglishLanguage,'&%FoodAttribute are descriptors that apply to &%Food but are highly subjective') ).

fof(kb_SUMO_6329,axiom,
    s__termFormat(s__EnglishLanguage,s__FoodAttribute,'food attribute') ).

fof(kb_SUMO_6330,axiom,
    ! [V__OBJ,V__ATTR] :
      ( ( s__instance(V__ATTR,s__Attribute)
        & s__instance(V__OBJ,s__Object) )
     => ( ( s__attribute(V__OBJ,V__ATTR)
          & s__instance(V__ATTR,s__FoodAttribute) )
       => s__instance(V__OBJ,s__PreparedFood) ) ) ).

fof(kb_SUMO_6331,axiom,
    s__instance(s__ComfortFood,s__FoodAttribute) ).

fof(kb_SUMO_6332,axiom,
    s__documentation(s__ComfortFood,s__EnglishLanguage,'&%ComfortFood describes &%PreparedFood that gives a sense of well-being, typically associated with childhood or with home cooking') ).

fof(kb_SUMO_6333,axiom,
    s__termFormat(s__EnglishLanguage,s__ComfortFood,'comfort food') ).

fof(kb_SUMO_6334,axiom,
    s__instance(s__HeartHealthyFood,s__FoodAttribute) ).

fof(kb_SUMO_6335,axiom,
    s__instance(s__FoodAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_6336,axiom,
    s__documentation(s__HeartHealthyFood,s__EnglishLanguage,'&%HeartHealthyFood describes &%PreparedFood that has is low in sodium and other ingredients that may foster heart disease') ).

fof(kb_SUMO_6337,axiom,
    s__termFormat(s__EnglishLanguage,s__HeartHealthyFood,'heart-healthy food') ).

%FOL fof(kb_SUMO_6338,axiom,(( (! [V__X,V__NUMBER2,V__NUMBER1] : ((s__instance(V__NUMBER1,s__RealNumber) & s__instance(V__NUMBER2,s__RealNumber) & s__instance(V__X,s__Object)) => ((s__conditionalProbability('s__attribute(V__X,s__ComfortFood)','s__attribute(V__X,s__HeartHealthyFood)',V__NUMBER1) & s__conditionalProbability('s__attribute(V__X,s__ComfortFood)','(~ s__attribute(V__X,s__HeartHealthyFood))',V__NUMBER2)) => less(V__NUMBER1,V__NUMBER2)))) ))).

fof(kb_SUMO_6339,axiom,
    s__instance(s__FamilyStylePortion,s__FoodAttribute) ).

fof(kb_SUMO_6340,axiom,
    s__documentation(s__FamilyStylePortion,s__EnglishLanguage,'&%FamilyStylePortion means that an instance of food can be shared by 3 or more people') ).

fof(kb_SUMO_6341,axiom,
    s__termFormat(s__EnglishLanguage,s__FamilyStylePortion,'family-style portions') ).

fof(kb_SUMO_6342,axiom,
    ! [V__FOOD2,V__FOOD1,V__CLASS,V__MEAS1,V__MEAS2] :
      ( ( s__instance(V__MEAS2,s__PhysicalQuantity)
        & s__instance(V__MEAS1,s__PhysicalQuantity)
        & s__instance(V__CLASS,s__SetOrClass)
        & s__instance(V__FOOD1,s__Object)
        & s__instance(V__FOOD2,s__Object) )
     => ( ( s__attribute(V__FOOD1,s__FamilyStylePortion)
          & s__measure(V__FOOD1,V__MEAS1)
          & ~ s__attribute(V__FOOD2,s__FamilyStylePortion)
          & s__measure(V__FOOD2,V__MEAS2)
          & s__instance(V__FOOD1,V__CLASS)
          & s__instance(V__FOOD2,V__CLASS) )
       => greater(V__MEAS1,V__MEAS2) ) ) ).

fof(kb_SUMO_6343,axiom,
    ! [V__X,V__GRP1,V__X2,V__E1] :
      ( ( s__instance(V__E1,s__Process)
        & s__instance(V__X2,s__Object)
        & s__instance(V__GRP1,s__Agent)
        & s__instance(V__X,s__Object) )
     => ( ( s__attribute(V__X,s__CommunalAttribute)
          & s__instance(V__X,s__Table)
          & s__instance(V__E1,s__Eating)
          & s__agent(V__E1,V__GRP1)
          & s__instance(V__GRP1,s__GroupOfPeople)
          & s__eventLocated(V__E1,V__X) )
       => s__modalAttribute('(? [V__GRP2,V__E2] : (s__instance(V__E2,s__Process) & s__instance(V__GRP2,s__Agent) & s__instance(V__E2,s__Eating) & s__agent(V__E2,V__GRP2) & (~ (V__GRP1 = V__GRP2)) & s__instance(V__GRP2,s__GroupOfPeople) & s__eventLocated(V__E2,V__X2) & s__meetsTemporally(s__WhenFn(V__E1),s__WhenFn(V__E2)) & (V__X = V__X2)))',s__Possibility) ) ) ).

fof(kb_SUMO_6344,axiom,
    ! [V__REST,V__DR,V__E2,V__GRP1,V__E1] :
      ( ( s__instance(V__E1,s__Process)
        & s__instance(V__GRP1,s__CognitiveAgent)
        & s__instance(V__E2,s__Process)
        & s__instance(V__DR,s__Object)
        & s__instance(V__REST,s__CognitiveAgent) )
     => ( ( s__instance(V__REST,s__Restaurant)
          & s__instance(V__DR,s__DiningRoom)
          & s__attribute(V__DR,s__PrivateAttribute)
          & s__possesses(V__REST,V__DR)
          & s__customer(V__GRP1,V__REST)
          & s__instance(V__E1,s__Eating)
          & s__agent(V__E1,V__GRP1)
          & s__instance(V__GRP1,s__GroupOfPeople) )
       => s__modalAttribute('(~ (? [V__GRP2] : (s__instance(V__GRP2,s__CognitiveAgent) & s__customer(V__GRP2,V__REST) & (~ (V__GRP1 = V__GRP2)) & s__instance(V__E2,s__Eating) & s__agent(V__E2,V__GRP2) & s__holdsDuring(s__WhenFn(V__E1),s__eventLocated(V__E2,V__DR)))))',s__Likely) ) ) ).

fof(kb_SUMO_6345,axiom,
    s__subclass(s__Cuisine,s__RelationalAttribute) ).

fof(kb_SUMO_6346,axiom,
    s__instance(s__Cuisine__t,s__SetOrClass) ).

fof(kb_SUMO_6347,axiom,
    s__documentation(s__Cuisine,s__EnglishLanguage,'Cuisine is an attribute applied to classes of PreparedFood to specify that it is typical of a particular region or culture. Note that it cannot be applied to a single Animal or Plant, even if a particular such entity is endemic to a particular region. It captures not just the reality of a particular combination of ingredients, but also the intent of the preparer to conform to a particular style of food and food preparation.') ).

fof(kb_SUMO_6348,axiom,
    ! [V__X,V__Y] :
      ( ( s__instance(V__Y,s__Attribute)
        & s__instance(V__X,s__Object) )
     => ( ( s__attribute(V__X,V__Y)
          & s__instance(V__Y,s__Cuisine) )
       => s__instance(V__X,s__PreparedFood) ) ) ).

fof(kb_SUMO_6349,axiom,
    s__instance(s__AsianCuisine,s__Cuisine) ).

fof(kb_SUMO_6350,axiom,
    s__termFormat(s__EnglishLanguage,s__AsianCuisine,'Asian Cuisine') ).

fof(kb_SUMO_6351,axiom,
    s__instance(s__CaribbeanCuisine,s__Cuisine) ).

fof(kb_SUMO_6352,axiom,
    s__termFormat(s__EnglishLanguage,s__CaribbeanCuisine,'Caribbean Cuisine') ).

fof(kb_SUMO_6353,axiom,
    s__instance(s__EuropeanCuisine,s__Cuisine) ).

fof(kb_SUMO_6354,axiom,
    s__termFormat(s__EnglishLanguage,s__EuropeanCuisine,'European Cuisine') ).

fof(kb_SUMO_6355,axiom,
    s__instance(s__LatinAmericanCuisine,s__Cuisine) ).

fof(kb_SUMO_6356,axiom,
    s__termFormat(s__EnglishLanguage,s__LatinAmericanCuisine,'Latin American Cuisine') ).

fof(kb_SUMO_6357,axiom,
    s__instance(s__AfricanCuisine,s__Cuisine) ).

fof(kb_SUMO_6358,axiom,
    s__termFormat(s__EnglishLanguage,s__AfricanCuisine,'African Cuisine') ).

fof(kb_SUMO_6359,axiom,
    s__instance(s__AmericanCuisine,s__Cuisine) ).

fof(kb_SUMO_6360,axiom,
    s__termFormat(s__EnglishLanguage,s__AmericanCuisine,'American Cuisine') ).

fof(kb_SUMO_6361,axiom,
    s__instance(s__AustralianCuisine,s__Cuisine) ).

fof(kb_SUMO_6362,axiom,
    s__termFormat(s__EnglishLanguage,s__AustralianCuisine,'Australian Cuisine') ).

fof(kb_SUMO_6363,axiom,
    s__instance(s__CanadianCuisine,s__Cuisine) ).

fof(kb_SUMO_6364,axiom,
    s__termFormat(s__EnglishLanguage,s__CanadianCuisine,'Canadian Cuisine') ).

fof(kb_SUMO_6365,axiom,
    s__instance(s__FusionCuisine,s__Cuisine) ).

fof(kb_SUMO_6366,axiom,
    s__termFormat(s__EnglishLanguage,s__FusionCuisine,'Fusion Cuisine') ).

fof(kb_SUMO_6367,axiom,
    s__instance(s__JewishCuisine,s__Cuisine) ).

fof(kb_SUMO_6368,axiom,
    s__termFormat(s__EnglishLanguage,s__JewishCuisine,'Jewish Cuisine') ).

fof(kb_SUMO_6369,axiom,
    s__instance(s__HealthFoodCuisine,s__Cuisine) ).

fof(kb_SUMO_6370,axiom,
    s__termFormat(s__EnglishLanguage,s__HealthFoodCuisine,'Health Food Cuisine') ).

fof(kb_SUMO_6371,axiom,
    s__subAttribute(s__CentralAfricanCuisine,s__AfricanCuisine) ).

fof(kb_SUMO_6372,axiom,
    s__termFormat(s__EnglishLanguage,s__CentralAfricanCuisine,'Central African Cuisine') ).

fof(kb_SUMO_6373,axiom,
    s__subAttribute(s__EastAfricanCuisine,s__AfricanCuisine) ).

fof(kb_SUMO_6374,axiom,
    s__termFormat(s__EnglishLanguage,s__EastAfricanCuisine,'East African Cuisine') ).

fof(kb_SUMO_6375,axiom,
    s__subAttribute(s__HornOfAfricaCuisine,s__AfricanCuisine) ).

fof(kb_SUMO_6376,axiom,
    s__termFormat(s__EnglishLanguage,s__HornOfAfricaCuisine,'Horn of Africa Cuisine') ).

fof(kb_SUMO_6377,axiom,
    s__subAttribute(s__NorthAfricanCuisine,s__AfricanCuisine) ).

fof(kb_SUMO_6378,axiom,
    s__termFormat(s__EnglishLanguage,s__NorthAfricanCuisine,'North African Cuisine') ).

fof(kb_SUMO_6379,axiom,
    s__subAttribute(s__SouthernAfricanCuisine,s__AfricanCuisine) ).

fof(kb_SUMO_6380,axiom,
    s__termFormat(s__EnglishLanguage,s__SouthernAfricanCuisine,'Southern African Cuisine') ).

fof(kb_SUMO_6381,axiom,
    s__subAttribute(s__WestAfricanCuisine,s__AfricanCuisine) ).

fof(kb_SUMO_6382,axiom,
    s__termFormat(s__EnglishLanguage,s__WestAfricanCuisine,'West African Cuisine') ).

fof(kb_SUMO_6383,axiom,
    s__subAttribute(s__IndianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6384,axiom,
    s__termFormat(s__EnglishLanguage,s__IndianCuisine,'Indian Cuisine') ).

fof(kb_SUMO_6385,axiom,
    s__subAttribute(s__SouthAsianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6386,axiom,
    s__termFormat(s__EnglishLanguage,s__SouthAsianCuisine,'South Asian Cuisine') ).

fof(kb_SUMO_6387,axiom,
    s__subAttribute(s__SoutheastAsianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6388,axiom,
    s__termFormat(s__EnglishLanguage,s__SoutheastAsianCuisine,'Southeast Asian Cuisine') ).

fof(kb_SUMO_6389,axiom,
    s__subAttribute(s__EastAsianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6390,axiom,
    s__termFormat(s__EnglishLanguage,s__EastAsianCuisine,'East Asian Cuisine') ).

fof(kb_SUMO_6391,axiom,
    s__subAttribute(s__WestAsianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6392,axiom,
    s__termFormat(s__EnglishLanguage,s__WestAsianCuisine,'West Asian Cuisine') ).

fof(kb_SUMO_6393,axiom,
    s__subAttribute(s__ChineseCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6394,axiom,
    s__termFormat(s__EnglishLanguage,s__ChineseCuisine,'Chinese Cuisine') ).

fof(kb_SUMO_6395,axiom,
    s__subAttribute(s__PanAsianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6396,axiom,
    s__termFormat(s__EnglishLanguage,s__PanAsianCuisine,'Pan-Asian Cuisine') ).

fof(kb_SUMO_6397,axiom,
    s__subAttribute(s__JapaneseCuisine,s__EastAsianCuisine) ).

fof(kb_SUMO_6398,axiom,
    s__termFormat(s__EnglishLanguage,s__JapaneseCuisine,'Japanese Cuisine') ).

fof(kb_SUMO_6399,axiom,
    s__subAttribute(s__EasternEuropeanCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6400,axiom,
    s__termFormat(s__EnglishLanguage,s__EasternEuropeanCuisine,'Eastern European Cuisine') ).

fof(kb_SUMO_6401,axiom,
    s__subAttribute(s__MediterraneanCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6402,axiom,
    s__termFormat(s__EnglishLanguage,s__MediterraneanCuisine,'Mediterranean Cuisine') ).

fof(kb_SUMO_6403,axiom,
    s__subAttribute(s__NorthernEuropeanCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6404,axiom,
    s__termFormat(s__EnglishLanguage,s__NorthernEuropeanCuisine,'Northern European Cuisine') ).

fof(kb_SUMO_6405,axiom,
    s__subAttribute(s__WesternEuropeanCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6406,axiom,
    s__termFormat(s__EnglishLanguage,s__WesternEuropeanCuisine,'Western European Cuisine') ).

fof(kb_SUMO_6407,axiom,
    s__subAttribute(s__AlpineCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6408,axiom,
    s__termFormat(s__EnglishLanguage,s__AlpineCuisine,'Alpine Cuisine') ).

fof(kb_SUMO_6409,axiom,
    s__subAttribute(s__ContinentalCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6410,axiom,
    s__termFormat(s__EnglishLanguage,s__ContinentalCuisine,'Continental Cuisine') ).

fof(kb_SUMO_6411,axiom,
    s__subAttribute(s__ArabCuisine,s__WestAsianCuisine) ).

fof(kb_SUMO_6412,axiom,
    s__termFormat(s__EnglishLanguage,s__ArabCuisine,'Arab Cuisine') ).

fof(kb_SUMO_6413,axiom,
    s__subAttribute(s__BritishCuisine,s__NorthernEuropeanCuisine) ).

fof(kb_SUMO_6414,axiom,
    s__termFormat(s__EnglishLanguage,s__BritishCuisine,'British Cuisine') ).

fof(kb_SUMO_6415,axiom,
    s__subAttribute(s__NordicCuisine,s__NorthernEuropeanCuisine) ).

fof(kb_SUMO_6416,axiom,
    s__termFormat(s__EnglishLanguage,s__NordicCuisine,'Nordic Cuisine') ).

fof(kb_SUMO_6417,axiom,
    s__subAttribute(s__IrishCuisine,s__NorthernEuropeanCuisine) ).

fof(kb_SUMO_6418,axiom,
    s__termFormat(s__EnglishLanguage,s__IrishCuisine,'Irish Cuisine') ).

fof(kb_SUMO_6419,axiom,
    s__subAttribute(s__ScottishCuisine,s__NorthernEuropeanCuisine) ).

fof(kb_SUMO_6420,axiom,
    s__termFormat(s__EnglishLanguage,s__ScottishCuisine,'Scottish Cuisine') ).

fof(kb_SUMO_6421,axiom,
    s__subAttribute(s__IndonesianCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6422,axiom,
    s__termFormat(s__EnglishLanguage,s__IndonesianCuisine,'Indonesian Cuisine') ).

fof(kb_SUMO_6423,axiom,
    s__subAttribute(s__SpanishCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6424,axiom,
    s__termFormat(s__EnglishLanguage,s__SpanishCuisine,'Spanish Cuisine') ).

fof(kb_SUMO_6425,axiom,
    s__subAttribute(s__AustrianCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6426,axiom,
    s__termFormat(s__EnglishLanguage,s__AustrianCuisine,'Austrian Cuisine') ).

fof(kb_SUMO_6427,axiom,
    s__subAttribute(s__GermanCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6428,axiom,
    s__termFormat(s__EnglishLanguage,s__GermanCuisine,'German Cuisine') ).

fof(kb_SUMO_6429,axiom,
    s__subAttribute(s__FrenchCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6430,axiom,
    s__termFormat(s__EnglishLanguage,s__FrenchCuisine,'French Cuisine') ).

fof(kb_SUMO_6431,axiom,
    s__subAttribute(s__DutchCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6432,axiom,
    s__termFormat(s__EnglishLanguage,s__DutchCuisine,'Dutch Cuisine') ).

fof(kb_SUMO_6433,axiom,
    s__subAttribute(s__SwissCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6434,axiom,
    s__termFormat(s__EnglishLanguage,s__SwissCuisine,'Swiss Cuisine') ).

fof(kb_SUMO_6435,axiom,
    s__subAttribute(s__VienneseCuisine,s__AustrianCuisine) ).

fof(kb_SUMO_6436,axiom,
    s__termFormat(s__EnglishLanguage,s__VienneseCuisine,'Viennese Cuisine') ).

fof(kb_SUMO_6437,axiom,
    s__subAttribute(s__BosnianCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6438,axiom,
    s__termFormat(s__EnglishLanguage,s__BosnianCuisine,'Bosnian Cuisine') ).

fof(kb_SUMO_6439,axiom,
    s__subAttribute(s__BolivianCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6440,axiom,
    s__termFormat(s__EnglishLanguage,s__BolivianCuisine,'Bolivian Cuisine') ).

fof(kb_SUMO_6441,axiom,
    s__subAttribute(s__BelgianCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6442,axiom,
    s__termFormat(s__EnglishLanguage,s__BelgianCuisine,'Belgian Cuisine') ).

fof(kb_SUMO_6443,axiom,
    s__subAttribute(s__NativeAmericanCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6444,axiom,
    s__termFormat(s__EnglishLanguage,s__NativeAmericanCuisine,'Native American Cuisine') ).

fof(kb_SUMO_6445,axiom,
    s__subAttribute(s__NorthAmericanCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6446,axiom,
    s__termFormat(s__EnglishLanguage,s__NorthAmericanCuisine,'North American Cuisine') ).

fof(kb_SUMO_6447,axiom,
    s__subAttribute(s__MidwesternCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6448,axiom,
    s__termFormat(s__EnglishLanguage,s__MidwesternCuisine,'Midwestern Cuisine') ).

fof(kb_SUMO_6449,axiom,
    s__subAttribute(s__AmishCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6450,axiom,
    s__termFormat(s__EnglishLanguage,s__AmishCuisine,'Amish Cuisine') ).

fof(kb_SUMO_6451,axiom,
    s__subAttribute(s__CreoleCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6452,axiom,
    s__termFormat(s__EnglishLanguage,s__CreoleCuisine,'Creole Cuisine') ).

fof(kb_SUMO_6453,axiom,
    s__subAttribute(s__SouthernCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6454,axiom,
    s__termFormat(s__EnglishLanguage,s__SouthernCuisine,'Southern Cuisine') ).

fof(kb_SUMO_6455,axiom,
    s__subAttribute(s__CalifornianCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6456,axiom,
    s__termFormat(s__EnglishLanguage,s__CalifornianCuisine,'Californian Cuisine') ).

fof(kb_SUMO_6457,axiom,
    s__subAttribute(s__ChesapeakeCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6458,axiom,
    s__termFormat(s__EnglishLanguage,s__ChesapeakeCuisine,'Chesapeake Cuisine') ).

fof(kb_SUMO_6459,axiom,
    s__subAttribute(s__SouthwesternCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6460,axiom,
    s__termFormat(s__EnglishLanguage,s__SouthwesternCuisine,'Southwestern Cuisine') ).

fof(kb_SUMO_6461,axiom,
    s__subAttribute(s__FloridianCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6462,axiom,
    s__termFormat(s__EnglishLanguage,s__FloridianCuisine,'Floridian Cuisine') ).

fof(kb_SUMO_6463,axiom,
    s__subAttribute(s__HawaiianCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6464,axiom,
    s__termFormat(s__EnglishLanguage,s__HawaiianCuisine,'Hawaiian Cuisine') ).

fof(kb_SUMO_6465,axiom,
    s__subAttribute(s__NewEnglandCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6466,axiom,
    s__termFormat(s__EnglishLanguage,s__NewEnglandCuisine,'New England Cuisine') ).

fof(kb_SUMO_6467,axiom,
    s__subAttribute(s__NewMexicanCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6468,axiom,
    s__termFormat(s__EnglishLanguage,s__NewMexicanCuisine,'New Mexican Cuisine') ).

fof(kb_SUMO_6469,axiom,
    s__subAttribute(s__PennsylvaniaDutchCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6470,axiom,
    s__termFormat(s__EnglishLanguage,s__PennsylvaniaDutchCuisine,'Pennsylvania Dutch Cuisine') ).

fof(kb_SUMO_6471,axiom,
    s__subAttribute(s__YemeniCuisine,s__ArabCuisine) ).

fof(kb_SUMO_6472,axiom,
    s__termFormat(s__EnglishLanguage,s__YemeniCuisine,'Yemeni Cuisine') ).

fof(kb_SUMO_6473,axiom,
    s__subAttribute(s__NewZealandCuisine,s__AustralianCuisine) ).

fof(kb_SUMO_6474,axiom,
    s__termFormat(s__EnglishLanguage,s__NewZealandCuisine,'New Zealand Cuisine') ).

fof(kb_SUMO_6475,axiom,
    s__subAttribute(s__BajanCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6476,axiom,
    s__termFormat(s__EnglishLanguage,s__BajanCuisine,'Bajan Cuisine') ).

fof(kb_SUMO_6477,axiom,
    s__subAttribute(s__CubanCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6478,axiom,
    s__termFormat(s__EnglishLanguage,s__CubanCuisine,'Cuban Cuisine') ).

fof(kb_SUMO_6479,axiom,
    s__subAttribute(s__DominicanCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6480,axiom,
    s__termFormat(s__EnglishLanguage,s__DominicanCuisine,'Dominican Cuisine') ).

fof(kb_SUMO_6481,axiom,
    s__subAttribute(s__HaitianCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6482,axiom,
    s__termFormat(s__EnglishLanguage,s__HaitianCuisine,'Haitian Cuisine') ).

fof(kb_SUMO_6483,axiom,
    s__subAttribute(s__JamaicanCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6484,axiom,
    s__termFormat(s__EnglishLanguage,s__JamaicanCuisine,'Jamaican Cuisine') ).

fof(kb_SUMO_6485,axiom,
    s__subAttribute(s__TinidadianCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6486,axiom,
    s__termFormat(s__EnglishLanguage,s__TinidadianCuisine,'Trinidadian Cuisine') ).

fof(kb_SUMO_6487,axiom,
    s__subAttribute(s__CentralAsianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6488,axiom,
    s__subAttribute(s__AfghanCuisine,s__CentralAsianCuisine) ).

fof(kb_SUMO_6489,axiom,
    s__termFormat(s__EnglishLanguage,s__AfghanCuisine,'Afghan Cuisine') ).

fof(kb_SUMO_6490,axiom,
    s__subAttribute(s__MongolianCuisine,s__CentralAsianCuisine) ).

fof(kb_SUMO_6491,axiom,
    s__termFormat(s__EnglishLanguage,s__MongolianCuisine,'Mongolian Cuisine') ).

fof(kb_SUMO_6492,axiom,
    s__subAttribute(s__TibetanCuisine,s__CentralAsianCuisine) ).

fof(kb_SUMO_6493,axiom,
    s__termFormat(s__EnglishLanguage,s__TibetanCuisine,'Tibetan Cuisine') ).

fof(kb_SUMO_6494,axiom,
    s__subAttribute(s__UzbekiCuisine,s__CentralAsianCuisine) ).

fof(kb_SUMO_6495,axiom,
    s__termFormat(s__EnglishLanguage,s__UzbekiCuisine,'Uzbeki Cuisine') ).

fof(kb_SUMO_6496,axiom,
    s__subAttribute(s__CantoneseCuisine,s__ChineseCuisine) ).

fof(kb_SUMO_6497,axiom,
    s__termFormat(s__EnglishLanguage,s__CantoneseCuisine,'Cantonese Cuisine') ).

fof(kb_SUMO_6498,axiom,
    s__subAttribute(s__HunanCuisine,s__ChineseCuisine) ).

fof(kb_SUMO_6499,axiom,
    s__termFormat(s__EnglishLanguage,s__HunanCuisine,'Hunan Cuisine') ).

fof(kb_SUMO_6500,axiom,
    s__subAttribute(s__MandarinCuisine,s__ChineseCuisine) ).

fof(kb_SUMO_6501,axiom,
    s__termFormat(s__EnglishLanguage,s__MandarinCuisine,'Mandarin Cuisine') ).

fof(kb_SUMO_6502,axiom,
    s__subAttribute(s__PekingeseCuisine,s__ChineseCuisine) ).

fof(kb_SUMO_6503,axiom,
    s__termFormat(s__EnglishLanguage,s__PekingeseCuisine,'Pekingese Cuisine') ).

fof(kb_SUMO_6504,axiom,
    s__subAttribute(s__SichuanCuisine,s__ChineseCuisine) ).

fof(kb_SUMO_6505,axiom,
    s__termFormat(s__EnglishLanguage,s__SichuanCuisine,'Sichuan Cuisine') ).

fof(kb_SUMO_6506,axiom,
    s__subAttribute(s__SzechuanCuisine,s__ChineseCuisine) ).

fof(kb_SUMO_6507,axiom,
    s__termFormat(s__EnglishLanguage,s__SzechuanCuisine,'Szechuan Cuisine') ).

fof(kb_SUMO_6508,axiom,
    s__subAttribute(s__KoreanCuisine,s__EastAsianCuisine) ).

fof(kb_SUMO_6509,axiom,
    s__termFormat(s__EnglishLanguage,s__KoreanCuisine,'Korean Cuisine') ).

fof(kb_SUMO_6510,axiom,
    s__subAttribute(s__TaiwaneseCuisine,s__EastAsianCuisine) ).

fof(kb_SUMO_6511,axiom,
    s__termFormat(s__EnglishLanguage,s__TaiwaneseCuisine,'Taiwanese Cuisine') ).

fof(kb_SUMO_6512,axiom,
    s__subAttribute(s__CzechCuisine,s__EasternEuropeanCuisine) ).

fof(kb_SUMO_6513,axiom,
    s__termFormat(s__EnglishLanguage,s__CzechCuisine,'Czech Cuisine') ).

fof(kb_SUMO_6514,axiom,
    s__subAttribute(s__HungarianCuisine,s__EasternEuropeanCuisine) ).

fof(kb_SUMO_6515,axiom,
    s__termFormat(s__EnglishLanguage,s__HungarianCuisine,'Hungarian Cuisine') ).

fof(kb_SUMO_6516,axiom,
    s__subAttribute(s__PolishCuisine,s__EasternEuropeanCuisine) ).

fof(kb_SUMO_6517,axiom,
    s__termFormat(s__EnglishLanguage,s__PolishCuisine,'Polish Cuisine') ).

fof(kb_SUMO_6518,axiom,
    s__subAttribute(s__RomanianCuisine,s__EasternEuropeanCuisine) ).

fof(kb_SUMO_6519,axiom,
    s__termFormat(s__EnglishLanguage,s__RomanianCuisine,'Romanian Cuisine') ).

fof(kb_SUMO_6520,axiom,
    s__subAttribute(s__RussianCuisine,s__EasternEuropeanCuisine) ).

fof(kb_SUMO_6521,axiom,
    s__termFormat(s__EnglishLanguage,s__RussianCuisine,'Russian Cuisine') ).

fof(kb_SUMO_6522,axiom,
    s__subAttribute(s__UkrainianCuisine,s__EasternEuropeanCuisine) ).

fof(kb_SUMO_6523,axiom,
    s__termFormat(s__EnglishLanguage,s__UkrainianCuisine,'Ukrainian Cuisine') ).

fof(kb_SUMO_6524,axiom,
    s__subAttribute(s__AlsatianCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6525,axiom,
    s__termFormat(s__EnglishLanguage,s__AlsatianCuisine,'Alsatian Cuisine') ).

fof(kb_SUMO_6526,axiom,
    s__subAttribute(s__AuvergneCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6527,axiom,
    s__termFormat(s__EnglishLanguage,s__AuvergneCuisine,'Auvergne Cuisine') ).

fof(kb_SUMO_6528,axiom,
    s__subAttribute(s__AveyronCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6529,axiom,
    s__termFormat(s__EnglishLanguage,s__AveyronCuisine,'Aveyron Cuisine') ).

fof(kb_SUMO_6530,axiom,
    s__subAttribute(s__CorsicaCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6531,axiom,
    s__termFormat(s__EnglishLanguage,s__CorsicaCuisine,'Corsica Cuisine') ).

fof(kb_SUMO_6532,axiom,
    s__subAttribute(s__BrittanyCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6533,axiom,
    s__termFormat(s__EnglishLanguage,s__BrittanyCuisine,'Brittany Cuisine') ).

fof(kb_SUMO_6534,axiom,
    s__subAttribute(s__BurgundyCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6535,axiom,
    s__termFormat(s__EnglishLanguage,s__BurgundyCuisine,'Burgundy Cuisine') ).

fof(kb_SUMO_6536,axiom,
    s__subAttribute(s__GasconyCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6537,axiom,
    s__termFormat(s__EnglishLanguage,s__GasconyCuisine,'Gascony Cuisine') ).

fof(kb_SUMO_6538,axiom,
    s__subAttribute(s__HauteCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6539,axiom,
    s__termFormat(s__EnglishLanguage,s__HauteCuisine,'Haute Cuisine') ).

fof(kb_SUMO_6540,axiom,
    s__subAttribute(s__LyonCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6541,axiom,
    s__termFormat(s__EnglishLanguage,s__LyonCuisine,'Lyon Cuisine') ).

fof(kb_SUMO_6542,axiom,
    s__subAttribute(s__ProvencalCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6543,axiom,
    s__termFormat(s__EnglishLanguage,s__ProvencalCuisine,'Provencal Cuisine') ).

fof(kb_SUMO_6544,axiom,
    s__subAttribute(s__EurasianCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6545,axiom,
    s__termFormat(s__EnglishLanguage,s__EurasianCuisine,'Eurasian Cuisine') ).

fof(kb_SUMO_6546,axiom,
    s__subAttribute(s__EurasianCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6547,axiom,
    s__subAttribute(s__EurasianCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6548,axiom,
    s__subAttribute(s__AsianFusionCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6549,axiom,
    s__termFormat(s__EnglishLanguage,s__AsianFusionCuisine,'Asian Fusion Cuisine') ).

fof(kb_SUMO_6550,axiom,
    s__subAttribute(s__AsianFusionCuisine,s__AsianCuisine) ).

fof(kb_SUMO_6551,axiom,
    s__subAttribute(s__EuropeanFusionCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6552,axiom,
    s__termFormat(s__EnglishLanguage,s__EuropeanFusionCuisine,'European Fusion Cuisine') ).

fof(kb_SUMO_6553,axiom,
    s__subAttribute(s__EuropeanFusionCuisine,s__EuropeanCuisine) ).

fof(kb_SUMO_6554,axiom,
    s__subAttribute(s__FloribbeanCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6555,axiom,
    s__termFormat(s__EnglishLanguage,s__FloribbeanCuisine,'Floribbean Cuisine') ).

fof(kb_SUMO_6556,axiom,
    s__subAttribute(s__FloribbeanCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6557,axiom,
    s__subAttribute(s__FloribbeanCuisine,s__AmericanCuisine) ).

fof(kb_SUMO_6558,axiom,
    s__subAttribute(s__FrenchIndianCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6559,axiom,
    s__termFormat(s__EnglishLanguage,s__FrenchIndianCuisine,'French Indian Cuisine') ).

fof(kb_SUMO_6560,axiom,
    s__subAttribute(s__FrenchIndianCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6561,axiom,
    s__subAttribute(s__FrenchIndianCuisine,s__IndianCuisine) ).

fof(kb_SUMO_6562,axiom,
    s__subAttribute(s__InternationalCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6563,axiom,
    s__termFormat(s__EnglishLanguage,s__InternationalCuisine,'International Cuisine') ).

fof(kb_SUMO_6564,axiom,
    s__subAttribute(s__GlobalCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6565,axiom,
    s__termFormat(s__EnglishLanguage,s__GlobalCuisine,'Global Cuisine') ).

fof(kb_SUMO_6566,axiom,
    s__subAttribute(s__IslandCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6567,axiom,
    s__termFormat(s__EnglishLanguage,s__IslandCuisine,'Island Cuisine') ).

fof(kb_SUMO_6568,axiom,
    s__subAttribute(s__NewWorldCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6569,axiom,
    s__termFormat(s__EnglishLanguage,s__NewWorldCuisine,'New World Cuisine') ).

fof(kb_SUMO_6570,axiom,
    s__subAttribute(s__PacificRimCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6571,axiom,
    s__termFormat(s__EnglishLanguage,s__PacificRimCuisine,'Pacific Rim Cuisine') ).

fof(kb_SUMO_6572,axiom,
    s__subAttribute(s__SenegambianCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6573,axiom,
    s__termFormat(s__EnglishLanguage,s__SenegambianCuisine,'Senegambian Cuisine') ).

fof(kb_SUMO_6574,axiom,
    s__subAttribute(s__SenegambianCuisine,s__SenegaleseCuisine) ).

fof(kb_SUMO_6575,axiom,
    s__subAttribute(s__SenegambianCuisine,s__GambianCuisine) ).

fof(kb_SUMO_6576,axiom,
    s__subAttribute(s__SeychellesCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6577,axiom,
    s__termFormat(s__EnglishLanguage,s__SeychellesCuisine,'Seychelles Cuisine') ).

fof(kb_SUMO_6578,axiom,
    s__subAttribute(s__SeychellesCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6579,axiom,
    s__subAttribute(s__SouthPacificCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6580,axiom,
    s__termFormat(s__EnglishLanguage,s__SouthPacificCuisine,'South Pacific Cuisine') ).

fof(kb_SUMO_6581,axiom,
    s__subAttribute(s__ThaiFrenchCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6582,axiom,
    s__termFormat(s__EnglishLanguage,s__ThaiFrenchCuisine,'Thai French Cuisine') ).

fof(kb_SUMO_6583,axiom,
    s__subAttribute(s__ThaiFrenchCuisine,s__ThaiCuisine) ).

fof(kb_SUMO_6584,axiom,
    s__subAttribute(s__ThaiFrenchCuisine,s__FrenchCuisine) ).

fof(kb_SUMO_6585,axiom,
    s__subAttribute(s__BavarianCuisine,s__GermanCuisine) ).

fof(kb_SUMO_6586,axiom,
    s__termFormat(s__EnglishLanguage,s__BavarianCuisine,'Bavarian Cuisine') ).

fof(kb_SUMO_6587,axiom,
    s__subAttribute(s__EritreanCuisine,s__HornOfAfricaCuisine) ).

fof(kb_SUMO_6588,axiom,
    s__termFormat(s__EnglishLanguage,s__EritreanCuisine,'Eritrean Cuisine') ).

fof(kb_SUMO_6589,axiom,
    s__subAttribute(s__EthiopianCuisine,s__HornOfAfricaCuisine) ).

fof(kb_SUMO_6590,axiom,
    s__termFormat(s__EnglishLanguage,s__EthiopianCuisine,'Ethiopian Cuisine') ).

fof(kb_SUMO_6591,axiom,
    s__subAttribute(s__EastIndianCuisine,s__IndianCuisine) ).

fof(kb_SUMO_6592,axiom,
    s__termFormat(s__EnglishLanguage,s__EastIndianCuisine,'East Indian Cuisine') ).

fof(kb_SUMO_6593,axiom,
    s__subAttribute(s__NorthIndianCuisine,s__IndianCuisine) ).

fof(kb_SUMO_6594,axiom,
    s__termFormat(s__EnglishLanguage,s__NorthIndianCuisine,'North Indian Cuisine') ).

fof(kb_SUMO_6595,axiom,
    s__subAttribute(s__NortheastIndianCuisine,s__IndianCuisine) ).

fof(kb_SUMO_6596,axiom,
    s__termFormat(s__EnglishLanguage,s__NortheastIndianCuisine,'Northeast Indian Cuisine') ).

fof(kb_SUMO_6597,axiom,
    s__subAttribute(s__SouthIndianCuisine,s__IndianCuisine) ).

fof(kb_SUMO_6598,axiom,
    s__termFormat(s__EnglishLanguage,s__SouthIndianCuisine,'South Indian Cuisine') ).

fof(kb_SUMO_6599,axiom,
    s__subAttribute(s__WestIndianCuisine,s__IndianCuisine) ).

fof(kb_SUMO_6600,axiom,
    s__termFormat(s__EnglishLanguage,s__WestIndianCuisine,'West Indian Cuisine') ).

fof(kb_SUMO_6601,axiom,
    s__subAttribute(s__HimalayanCuisine,s__IndianCuisine) ).

fof(kb_SUMO_6602,axiom,
    s__termFormat(s__EnglishLanguage,s__HimalayanCuisine,'Himalayan Cuisine') ).

fof(kb_SUMO_6603,axiom,
    s__subAttribute(s__JavaneseCuisine,s__IndonesianCuisine) ).

fof(kb_SUMO_6604,axiom,
    s__termFormat(s__EnglishLanguage,s__JavaneseCuisine,'Javanese Cuisine') ).

fof(kb_SUMO_6605,axiom,
    s__subAttribute(s__AbruzzeseCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6606,axiom,
    s__termFormat(s__EnglishLanguage,s__AbruzzeseCuisine,'Abruzzese Cuisine') ).

fof(kb_SUMO_6607,axiom,
    s__subAttribute(s__EmilianCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6608,axiom,
    s__termFormat(s__EnglishLanguage,s__EmilianCuisine,'Emilian Cuisine') ).

fof(kb_SUMO_6609,axiom,
    s__subAttribute(s__FlorentineCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6610,axiom,
    s__termFormat(s__EnglishLanguage,s__FlorentineCuisine,'Florentine Cuisine') ).

fof(kb_SUMO_6611,axiom,
    s__subAttribute(s__LigurianCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6612,axiom,
    s__termFormat(s__EnglishLanguage,s__LigurianCuisine,'Ligurian Cuisine') ).

fof(kb_SUMO_6613,axiom,
    s__subAttribute(s__LombardianCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6614,axiom,
    s__termFormat(s__EnglishLanguage,s__LombardianCuisine,'Lombardian Cuisine') ).

fof(kb_SUMO_6615,axiom,
    s__subAttribute(s__MarchigianaCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6616,axiom,
    s__termFormat(s__EnglishLanguage,s__MarchigianaCuisine,'Marchigiana Cuisine') ).

fof(kb_SUMO_6617,axiom,
    s__subAttribute(s__MilaneseCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6618,axiom,
    s__termFormat(s__EnglishLanguage,s__MilaneseCuisine,'Milanese Cuisine') ).

fof(kb_SUMO_6619,axiom,
    s__subAttribute(s__NeapolitanCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6620,axiom,
    s__termFormat(s__EnglishLanguage,s__NeapolitanCuisine,'Neapolitan Cuisine') ).

fof(kb_SUMO_6621,axiom,
    s__subAttribute(s__RomanCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6622,axiom,
    s__termFormat(s__EnglishLanguage,s__RomanCuisine,'Roman Cuisine') ).

fof(kb_SUMO_6623,axiom,
    s__subAttribute(s__PiedmonteseCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6624,axiom,
    s__termFormat(s__EnglishLanguage,s__PiedmonteseCuisine,'Piedmontese Cuisine') ).

fof(kb_SUMO_6625,axiom,
    s__subAttribute(s__SardinianCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6626,axiom,
    s__termFormat(s__EnglishLanguage,s__SardinianCuisine,'Sardinian Cuisine') ).

fof(kb_SUMO_6627,axiom,
    s__subAttribute(s__SicilianCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6628,axiom,
    s__termFormat(s__EnglishLanguage,s__SicilianCuisine,'Sicilian Cuisine') ).

fof(kb_SUMO_6629,axiom,
    s__subAttribute(s__TuscanCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6630,axiom,
    s__termFormat(s__EnglishLanguage,s__TuscanCuisine,'Tuscan Cuisine') ).

fof(kb_SUMO_6631,axiom,
    s__subAttribute(s__VenetianCuisine,s__ItalianCuisine) ).

fof(kb_SUMO_6632,axiom,
    s__termFormat(s__EnglishLanguage,s__VenetianCuisine,'Venetian Cuisine') ).

fof(kb_SUMO_6633,axiom,
    s__subAttribute(s__ArgentineanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6634,axiom,
    s__termFormat(s__EnglishLanguage,s__ArgentineanCuisine,'Argentinean Cuisine') ).

fof(kb_SUMO_6635,axiom,
    s__subAttribute(s__BrazilianCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6636,axiom,
    s__termFormat(s__EnglishLanguage,s__BrazilianCuisine,'Brazilian Cuisine') ).

fof(kb_SUMO_6637,axiom,
    s__subAttribute(s__CapeVerdeanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6638,axiom,
    s__termFormat(s__EnglishLanguage,s__CapeVerdeanCuisine,'CapeVerdean Cuisine') ).

fof(kb_SUMO_6639,axiom,
    s__subAttribute(s__CentralAmericanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6640,axiom,
    s__termFormat(s__EnglishLanguage,s__CentralAmericanCuisine,'Central American Cuisine') ).

fof(kb_SUMO_6641,axiom,
    s__subAttribute(s__ChileanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6642,axiom,
    s__termFormat(s__EnglishLanguage,s__ChileanCuisine,'Chilean Cuisine') ).

fof(kb_SUMO_6643,axiom,
    s__subAttribute(s__ColombianCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6644,axiom,
    s__termFormat(s__EnglishLanguage,s__ColombianCuisine,'Colombian Cuisine') ).

fof(kb_SUMO_6645,axiom,
    s__subAttribute(s__MexicanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6646,axiom,
    s__termFormat(s__EnglishLanguage,s__MexicanCuisine,'Mexican Cuisine') ).

fof(kb_SUMO_6647,axiom,
    s__subAttribute(s__CostaRicanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6648,axiom,
    s__termFormat(s__EnglishLanguage,s__CostaRicanCuisine,'Costa Rican Cuisine') ).

fof(kb_SUMO_6649,axiom,
    s__subAttribute(s__EcuadorianCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6650,axiom,
    s__termFormat(s__EnglishLanguage,s__EcuadorianCuisine,'Ecuadorian Cuisine') ).

fof(kb_SUMO_6651,axiom,
    s__subAttribute(s__GuatemalanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6652,axiom,
    s__termFormat(s__EnglishLanguage,s__GuatemalanCuisine,'Guatemalan Cuisine') ).

fof(kb_SUMO_6653,axiom,
    s__subAttribute(s__GuyaneseCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6654,axiom,
    s__termFormat(s__EnglishLanguage,s__GuyaneseCuisine,'Guyanese Cuisine') ).

fof(kb_SUMO_6655,axiom,
    s__subAttribute(s__HonduranCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6656,axiom,
    s__termFormat(s__EnglishLanguage,s__HonduranCuisine,'Honduran Cuisine') ).

fof(kb_SUMO_6657,axiom,
    s__subAttribute(s__NicaraguanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6658,axiom,
    s__termFormat(s__EnglishLanguage,s__NicaraguanCuisine,'Nicaraguan Cuisine') ).

fof(kb_SUMO_6659,axiom,
    s__subAttribute(s__PanLatinCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6660,axiom,
    s__termFormat(s__EnglishLanguage,s__PanLatinCuisine,'Pan Latin Cuisine') ).

fof(kb_SUMO_6661,axiom,
    s__subAttribute(s__ParaguayanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6662,axiom,
    s__termFormat(s__EnglishLanguage,s__ParaguayanCuisine,'Paraguayan Cuisine') ).

fof(kb_SUMO_6663,axiom,
    s__subAttribute(s__PeruvianCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6664,axiom,
    s__termFormat(s__EnglishLanguage,s__PeruvianCuisine,'Peruvian Cuisine') ).

fof(kb_SUMO_6665,axiom,
    s__subAttribute(s__PuertoRicanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6666,axiom,
    s__termFormat(s__EnglishLanguage,s__PuertoRicanCuisine,'Puerto Rican Cuisine') ).

fof(kb_SUMO_6667,axiom,
    s__subAttribute(s__SalvadoranCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6668,axiom,
    s__termFormat(s__EnglishLanguage,s__SalvadoranCuisine,'Salvadoran Cuisine') ).

fof(kb_SUMO_6669,axiom,
    s__subAttribute(s__UruguayanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6670,axiom,
    s__termFormat(s__EnglishLanguage,s__UruguayanCuisine,'Uruguayan Cuisine') ).

fof(kb_SUMO_6671,axiom,
    s__subAttribute(s__VenezuelanCuisine,s__LatinAmericanCuisine) ).

fof(kb_SUMO_6672,axiom,
    s__termFormat(s__EnglishLanguage,s__VenezuelanCuisine,'Venezuelan Cuisine') ).

fof(kb_SUMO_6673,axiom,
    s__subAttribute(s__PalestinianCuisine,s__LevantineCuisine) ).

fof(kb_SUMO_6674,axiom,
    s__termFormat(s__EnglishLanguage,s__PalestinianCuisine,'Palestinian Cuisine') ).

fof(kb_SUMO_6675,axiom,
    s__subAttribute(s__ItalianCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6676,axiom,
    s__termFormat(s__EnglishLanguage,s__ItalianCuisine,'Italian Cuisine') ).

fof(kb_SUMO_6677,axiom,
    s__subAttribute(s__CypriotCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6678,axiom,
    s__termFormat(s__EnglishLanguage,s__CypriotCuisine,'Greek Cypriot Cuisine') ).

fof(kb_SUMO_6679,axiom,
    s__subAttribute(s__CroatianCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6680,axiom,
    s__termFormat(s__EnglishLanguage,s__CroatianCuisine,'Croatian Cuisine') ).

fof(kb_SUMO_6681,axiom,
    s__subAttribute(s__GreekCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6682,axiom,
    s__termFormat(s__EnglishLanguage,s__GreekCuisine,'Greek Cuisine') ).

fof(kb_SUMO_6683,axiom,
    s__subAttribute(s__SerbianCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6684,axiom,
    s__termFormat(s__EnglishLanguage,s__SerbianCuisine,'Serbian Cuisine') ).

fof(kb_SUMO_6685,axiom,
    s__subAttribute(s__SlavicCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6686,axiom,
    s__termFormat(s__EnglishLanguage,s__SlavicCuisine,'Slavic Cuisine') ).

fof(kb_SUMO_6687,axiom,
    s__subAttribute(s__TurkishCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6688,axiom,
    s__termFormat(s__EnglishLanguage,s__TurkishCuisine,'Turkish Cuisine') ).

fof(kb_SUMO_6689,axiom,
    s__subAttribute(s__MayanCuisine,s__MexicanCuisine) ).

fof(kb_SUMO_6690,axiom,
    s__termFormat(s__EnglishLanguage,s__MayanCuisine,'Mayan Cuisine') ).

fof(kb_SUMO_6691,axiom,
    s__subAttribute(s__ArmenianCuisine,s__EasternEuropeanCuisine) ).

fof(kb_SUMO_6692,axiom,
    s__termFormat(s__EnglishLanguage,s__ArmenianCuisine,'Armenian Cuisine') ).

fof(kb_SUMO_6693,axiom,
    s__subAttribute(s__CaspianCuisine,s__PersianCuisine) ).

fof(kb_SUMO_6694,axiom,
    s__termFormat(s__EnglishLanguage,s__CaspianCuisine,'Caspian Cuisine') ).

fof(kb_SUMO_6695,axiom,
    s__subAttribute(s__IranianCuisine,s__MiddleEasternCuisine) ).

fof(kb_SUMO_6696,axiom,
    s__termFormat(s__EnglishLanguage,s__IranianCuisine,'Iranian Cuisine') ).

fof(kb_SUMO_6697,axiom,
    s__subAttribute(s__IraqiCuisine,s__MiddleEasternCuisine) ).

fof(kb_SUMO_6698,axiom,
    s__termFormat(s__EnglishLanguage,s__IraqiCuisine,'Iraqi Cuisine') ).

fof(kb_SUMO_6699,axiom,
    s__subAttribute(s__IsraeliCuisine,s__LevantineCuisine) ).

fof(kb_SUMO_6700,axiom,
    s__termFormat(s__EnglishLanguage,s__IsraeliCuisine,'Israeli Cuisine') ).

fof(kb_SUMO_6701,axiom,
    s__subAttribute(s__LebaneseCuisine,s__LevantineCuisine) ).

fof(kb_SUMO_6702,axiom,
    s__termFormat(s__EnglishLanguage,s__LebaneseCuisine,'Lebanese Cuisine') ).

fof(kb_SUMO_6703,axiom,
    s__subAttribute(s__MesopotamianCuisine,s__MiddleEasternCuisine) ).

fof(kb_SUMO_6704,axiom,
    s__termFormat(s__EnglishLanguage,s__MesopotamianCuisine,'Mesopotamian Cuisine') ).

fof(kb_SUMO_6705,axiom,
    s__subAttribute(s__PersianCuisine,s__MiddleEasternCuisine) ).

fof(kb_SUMO_6706,axiom,
    s__termFormat(s__EnglishLanguage,s__PersianCuisine,'Persian Cuisine') ).

fof(kb_SUMO_6707,axiom,
    s__subAttribute(s__SyrianCuisine,s__LevantineCuisine) ).

fof(kb_SUMO_6708,axiom,
    s__termFormat(s__EnglishLanguage,s__SyrianCuisine,'Syrian Cuisine') ).

fof(kb_SUMO_6709,axiom,
    s__subAttribute(s__TunisianCuisine,s__MediterraneanCuisine) ).

fof(kb_SUMO_6710,axiom,
    s__termFormat(s__EnglishLanguage,s__TunisianCuisine,'Tunisian Cuisine') ).

fof(kb_SUMO_6711,axiom,
    s__subAttribute(s__DanishCuisine,s__NordicCuisine) ).

fof(kb_SUMO_6712,axiom,
    s__termFormat(s__EnglishLanguage,s__DanishCuisine,'Danish Cuisine') ).

fof(kb_SUMO_6713,axiom,
    s__subAttribute(s__FinnishCuisine,s__NordicCuisine) ).

fof(kb_SUMO_6714,axiom,
    s__termFormat(s__EnglishLanguage,s__FinnishCuisine,'Finnish Cuisine') ).

fof(kb_SUMO_6715,axiom,
    s__subAttribute(s__IcelandicCuisine,s__NordicCuisine) ).

fof(kb_SUMO_6716,axiom,
    s__termFormat(s__EnglishLanguage,s__IcelandicCuisine,'Icelandic Cuisine') ).

fof(kb_SUMO_6717,axiom,
    s__subAttribute(s__NorwegianCuisine,s__NordicCuisine) ).

fof(kb_SUMO_6718,axiom,
    s__termFormat(s__EnglishLanguage,s__NorwegianCuisine,'Norwegian Cuisine') ).

fof(kb_SUMO_6719,axiom,
    s__subAttribute(s__SwedishCuisine,s__NordicCuisine) ).

fof(kb_SUMO_6720,axiom,
    s__termFormat(s__EnglishLanguage,s__SwedishCuisine,'Swedish Cuisine') ).

fof(kb_SUMO_6721,axiom,
    s__subAttribute(s__EgyptianCuisine,s__NorthAfricanCuisine) ).

fof(kb_SUMO_6722,axiom,
    s__termFormat(s__EnglishLanguage,s__EgyptianCuisine,'Egyptian Cuisine') ).

fof(kb_SUMO_6723,axiom,
    s__subAttribute(s__MoroccanCuisine,s__NorthAfricanCuisine) ).

fof(kb_SUMO_6724,axiom,
    s__termFormat(s__EnglishLanguage,s__MoroccanCuisine,'Moroccan Cuisine') ).

fof(kb_SUMO_6725,axiom,
    s__subAttribute(s__BangladeshiCuisine,s__SouthAsianCuisine) ).

fof(kb_SUMO_6726,axiom,
    s__termFormat(s__EnglishLanguage,s__BangladeshiCuisine,'Bangladeshi Cuisine') ).

fof(kb_SUMO_6727,axiom,
    s__subAttribute(s__NepaleseCuisine,s__SouthAsianCuisine) ).

fof(kb_SUMO_6728,axiom,
    s__termFormat(s__EnglishLanguage,s__NepaleseCuisine,'Nepalese Cuisine') ).

fof(kb_SUMO_6729,axiom,
    s__subAttribute(s__PakistaniCuisine,s__SouthAsianCuisine) ).

fof(kb_SUMO_6730,axiom,
    s__termFormat(s__EnglishLanguage,s__PakistaniCuisine,'Pakistani Cuisine') ).

fof(kb_SUMO_6731,axiom,
    s__subAttribute(s__SriLankanCuisine,s__SouthAsianCuisine) ).

fof(kb_SUMO_6732,axiom,
    s__termFormat(s__EnglishLanguage,s__SriLankanCuisine,'Sri Lankan Cuisine') ).

fof(kb_SUMO_6733,axiom,
    s__subAttribute(s__BurmeseCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6734,axiom,
    s__termFormat(s__EnglishLanguage,s__BurmeseCuisine,'Burmese Cuisine') ).

fof(kb_SUMO_6735,axiom,
    s__subAttribute(s__CambodianCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6736,axiom,
    s__termFormat(s__EnglishLanguage,s__CambodianCuisine,'Cambodian Cuisine') ).

fof(kb_SUMO_6737,axiom,
    s__subAttribute(s__FilipinoCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6738,axiom,
    s__termFormat(s__EnglishLanguage,s__FilipinoCuisine,'Filipino Cuisine') ).

fof(kb_SUMO_6739,axiom,
    s__subAttribute(s__MalaysianCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6740,axiom,
    s__termFormat(s__EnglishLanguage,s__MalaysianCuisine,'Malaysian Cuisine') ).

fof(kb_SUMO_6741,axiom,
    s__subAttribute(s__LaotianCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6742,axiom,
    s__termFormat(s__EnglishLanguage,s__LaotianCuisine,'Laotian Cuisine') ).

fof(kb_SUMO_6743,axiom,
    s__subAttribute(s__SingaporeanCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6744,axiom,
    s__termFormat(s__EnglishLanguage,s__SingaporeanCuisine,'Singaporean Cuisine') ).

fof(kb_SUMO_6745,axiom,
    s__subAttribute(s__ThaiCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6746,axiom,
    s__termFormat(s__EnglishLanguage,s__ThaiCuisine,'Thai Cuisine') ).

fof(kb_SUMO_6747,axiom,
    s__subAttribute(s__VietnameseCuisine,s__SoutheastAsianCuisine) ).

fof(kb_SUMO_6748,axiom,
    s__termFormat(s__EnglishLanguage,s__VietnameseCuisine,'Vietnamese Cuisine') ).

fof(kb_SUMO_6749,axiom,
    s__subAttribute(s__SouthAfricanCuisine,s__SouthernAfricanCuisine) ).

fof(kb_SUMO_6750,axiom,
    s__termFormat(s__EnglishLanguage,s__SouthAfricanCuisine,'South African Cuisine') ).

fof(kb_SUMO_6751,axiom,
    s__subAttribute(s__TexMexCuisine,s__SouthwesternCuisine) ).

fof(kb_SUMO_6752,axiom,
    s__termFormat(s__EnglishLanguage,s__TexMexCuisine,'Tex Mex Cuisine') ).

fof(kb_SUMO_6753,axiom,
    s__subAttribute(s__BasqueCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6754,axiom,
    s__termFormat(s__EnglishLanguage,s__BasqueCuisine,'Basque Cuisine') ).

fof(kb_SUMO_6755,axiom,
    s__subAttribute(s__IberianCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6756,axiom,
    s__termFormat(s__EnglishLanguage,s__IberianCuisine,'Iberian Cuisine') ).

fof(kb_SUMO_6757,axiom,
    s__subAttribute(s__ValencianCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6758,axiom,
    s__termFormat(s__EnglishLanguage,s__ValencianCuisine,'Valencian Cuisine') ).

fof(kb_SUMO_6759,axiom,
    s__subAttribute(s__AndalusianCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6760,axiom,
    s__termFormat(s__EnglishLanguage,s__AndalusianCuisine,'Andalusian Cuisine') ).

fof(kb_SUMO_6761,axiom,
    s__subAttribute(s__CantabrianCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6762,axiom,
    s__termFormat(s__EnglishLanguage,s__CantabrianCuisine,'Cantabrian Cuisine') ).

fof(kb_SUMO_6763,axiom,
    s__subAttribute(s__CastilianCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6764,axiom,
    s__termFormat(s__EnglishLanguage,s__CastilianCuisine,'Castillan Cuisine') ).

fof(kb_SUMO_6765,axiom,
    s__subAttribute(s__CatalanCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6766,axiom,
    s__termFormat(s__EnglishLanguage,s__CatalanCuisine,'Catalan Cuisine') ).

fof(kb_SUMO_6767,axiom,
    s__subAttribute(s__GalicianCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6768,axiom,
    s__termFormat(s__EnglishLanguage,s__GalicianCuisine,'Galician Cuisine') ).

fof(kb_SUMO_6769,axiom,
    s__subAttribute(s__MadrilianCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6770,axiom,
    s__termFormat(s__EnglishLanguage,s__MadrilianCuisine,'Madrilian Cuisine') ).

fof(kb_SUMO_6771,axiom,
    s__subAttribute(s__NavarraiseCuisine,s__SpanishCuisine) ).

fof(kb_SUMO_6772,axiom,
    s__termFormat(s__EnglishLanguage,s__NavarraiseCuisine,'Navarraise Cuisine') ).

fof(kb_SUMO_6773,axiom,
    s__subAttribute(s__GhanianCuisine,s__WestAfricanCuisine) ).

fof(kb_SUMO_6774,axiom,
    s__termFormat(s__EnglishLanguage,s__GhanianCuisine,'Ghanian Cuisine') ).

fof(kb_SUMO_6775,axiom,
    s__subAttribute(s__SenegaleseCuisine,s__WestAfricanCuisine) ).

fof(kb_SUMO_6776,axiom,
    s__termFormat(s__EnglishLanguage,s__SenegaleseCuisine,'Senegalese Cuisine') ).

fof(kb_SUMO_6777,axiom,
    s__subAttribute(s__GambianCuisine,s__WestAfricanCuisine) ).

fof(kb_SUMO_6778,axiom,
    s__termFormat(s__EnglishLanguage,s__GambianCuisine,'Gambian Cuisine') ).

fof(kb_SUMO_6779,axiom,
    s__subAttribute(s__LevantineCuisine,s__WestAsianCuisine) ).

fof(kb_SUMO_6780,axiom,
    s__termFormat(s__EnglishLanguage,s__LevantineCuisine,'Levantine Cuisine') ).

fof(kb_SUMO_6781,axiom,
    s__subAttribute(s__MiddleEasternCuisine,s__WestAsianCuisine) ).

fof(kb_SUMO_6782,axiom,
    s__termFormat(s__EnglishLanguage,s__MiddleEasternCuisine,'Middle Eastern Cuisine') ).

fof(kb_SUMO_6783,axiom,
    s__subAttribute(s__CajunCuisine,s__CaribbeanCuisine) ).

fof(kb_SUMO_6784,axiom,
    s__termFormat(s__EnglishLanguage,s__CajunCuisine,'Cajun Cuisine') ).

fof(kb_SUMO_6785,axiom,
    s__subAttribute(s__PortugueseCuisine,s__WesternEuropeanCuisine) ).

fof(kb_SUMO_6786,axiom,
    s__termFormat(s__EnglishLanguage,s__PortugueseCuisine,'Portuguese Cuisine') ).

fof(kb_SUMO_6787,axiom,
    s__subAttribute(s__PolynesianCuisine,s__FusionCuisine) ).

fof(kb_SUMO_6788,axiom,
    s__termFormat(s__EnglishLanguage,s__PolynesianCuisine,'Polynesian Cuisine') ).

fof(kb_SUMO_6789,axiom,
    s__subAttribute(s__ShanghaineseCuisine,s__ChineseCuisine) ).

fof(kb_SUMO_6790,axiom,
    s__termFormat(s__EnglishLanguage,s__ShanghaineseCuisine,'Shanghainese Cuisine') ).

fof(kb_SUMO_6791,axiom,
    s__instance(s__economyType__m,s__BinaryPredicate) ).

fof(kb_SUMO_6792,axiom,
    s__domain(s__economyType__m,"1",s__Agent) ).

fof(kb_SUMO_6793,axiom,
    s__domain(s__economyType__m,"2",s__EconomicAttribute) ).

fof(kb_SUMO_6794,axiom,
    s__subrelation(s__economyType__m,s__attribute__m) ).

fof(kb_SUMO_6795,axiom,
    s__documentation(s__economyType__m,s__EnglishLanguage,'(&%economyType ?POLITY ?TYPE) means that the &%GeopoliticalArea ?POLITY has an economic system of &%TYPE.') ).

fof(kb_SUMO_6796,axiom,
    ! [V__ATTRIBUTE,V__AGENT] :
      ( ( s__instance(V__AGENT,s__Agent)
        & s__instance(V__ATTRIBUTE,s__EconomicAttribute) )
     => ( s__economyType(V__AGENT,V__ATTRIBUTE)
       => ( s__instance(V__AGENT,s__GeopoliticalArea)
          | s__instance(V__AGENT,s__Organization) ) ) ) ).

fof(kb_SUMO_6797,axiom,
    s__subclass(s__EconomicDevelopmentLevel,s__EconomicAttribute) ).

fof(kb_SUMO_6798,axiom,
    s__documentation(s__EconomicDevelopmentLevel,s__EnglishLanguage,'&%EconomicDevelopmentLevel is a subclass of &%EconomicAttribute containing terms used to describe the economic development level of a &%Nation or &%GeopoliticalArea. This class is further subdivided into different scales devised or used by different agencies.') ).

fof(kb_SUMO_6799,axiom,
    s__subclass(s__UNEconomicDevelopmentLevel,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_6800,axiom,
    s__documentation(s__UNEconomicDevelopmentLevel,s__EnglishLanguage,'&%UNEconomicDevelopmentLevel is a subclass of &%EconomicDevelopmentLevel containing terms used to represent economic development classifications used by &%UnitedNations agencies. The top level of this classification scheme includes the concepts of &%DevelopedCountry, &%FormerSovietOrEasternEuropeanCountry, and &%LessDevelopedCountry.') ).

fof(kb_SUMO_6801,axiom,
    s__instance(s__DevelopedCountry,s__UNEconomicDevelopmentLevel) ).

fof(kb_SUMO_6802,axiom,
    s__instance(s__UNEconomicDevelopmentLevel__t,s__SetOrClass) ).

fof(kb_SUMO_6803,axiom,
    s__formerName('First World',s__DevelopedCountry) ).

fof(kb_SUMO_6804,axiom,
    s__conventionalLongName('Developed Country',s__DevelopedCountry) ).

fof(kb_SUMO_6805,axiom,
    s__names('industrial country',s__DevelopedCountry) ).

fof(kb_SUMO_6806,axiom,
    s__conventionalShortName('the North',s__DevelopedCountry) ).

fof(kb_SUMO_6807,axiom,
    s__documentation(s__DevelopedCountry,s__EnglishLanguage,'&%DevelopedCountry (DC) is a term used to describe members of the top group in the &%UNEconomicDevelopmentLevels. &%DevelopedCountry includes market-oriented economies of mainly democratic nations, including members of the &%OrganizationForEconomicCooperationAndDevelopment (OECD). DCs are also known as First World countries, the North, and industrial countries. Developed countries generally have high incomes (high per capita GDP or GNI), but there are exceptions to DC membership both above and below that standard. There is significant overlap, but not perfect congruence, between the UN category &%DevelopedCountry and the IMF category &%AdvancedEconomy.') ).

fof(kb_SUMO_6808,axiom,
    s__cardinality(s__ExtensionFn(s__DevelopedCountry),"35") ).

fof(kb_SUMO_6809,axiom,
    s__economyType(s__Andorra,s__DevelopedCountry) ).

fof(kb_SUMO_6810,axiom,
    s__economyType(s__Australia,s__DevelopedCountry) ).

fof(kb_SUMO_6811,axiom,
    s__economyType(s__Austria,s__DevelopedCountry) ).

fof(kb_SUMO_6812,axiom,
    s__economyType(s__Belgium,s__DevelopedCountry) ).

fof(kb_SUMO_6813,axiom,
    s__economyType(s__Bermuda,s__DevelopedCountry) ).

fof(kb_SUMO_6814,axiom,
    s__economyType(s__Canada,s__DevelopedCountry) ).

fof(kb_SUMO_6815,axiom,
    s__economyType(s__Denmark,s__DevelopedCountry) ).

fof(kb_SUMO_6816,axiom,
    s__economyType(s__FaroeIslands,s__DevelopedCountry) ).

fof(kb_SUMO_6817,axiom,
    s__economyType(s__Finland,s__DevelopedCountry) ).

fof(kb_SUMO_6818,axiom,
    s__economyType(s__France,s__DevelopedCountry) ).

fof(kb_SUMO_6819,axiom,
    s__economyType(s__Germany,s__DevelopedCountry) ).

fof(kb_SUMO_6820,axiom,
    s__economyType(s__Greece,s__DevelopedCountry) ).

fof(kb_SUMO_6821,axiom,
    s__economyType(s__HolySee,s__DevelopedCountry) ).

fof(kb_SUMO_6822,axiom,
    s__economyType(s__Iceland,s__DevelopedCountry) ).

fof(kb_SUMO_6823,axiom,
    s__economyType(s__Ireland,s__DevelopedCountry) ).

fof(kb_SUMO_6824,axiom,
    s__economyType(s__Israel,s__DevelopedCountry) ).

fof(kb_SUMO_6825,axiom,
    s__economyType(s__Italy,s__DevelopedCountry) ).

fof(kb_SUMO_6826,axiom,
    s__economyType(s__Japan,s__DevelopedCountry) ).

fof(kb_SUMO_6827,axiom,
    s__economyType(s__Liechtenstein,s__DevelopedCountry) ).

fof(kb_SUMO_6828,axiom,
    s__economyType(s__Luxembourg,s__DevelopedCountry) ).

fof(kb_SUMO_6829,axiom,
    s__economyType(s__Malta,s__DevelopedCountry) ).

fof(kb_SUMO_6830,axiom,
    s__economyType(s__Mexico,s__DevelopedCountry) ).

fof(kb_SUMO_6831,axiom,
    s__economyType(s__Monaco,s__DevelopedCountry) ).

fof(kb_SUMO_6832,axiom,
    s__economyType(s__Netherlands,s__DevelopedCountry) ).

fof(kb_SUMO_6833,axiom,
    s__economyType(s__NewZealand,s__DevelopedCountry) ).

fof(kb_SUMO_6834,axiom,
    s__economyType(s__Norway,s__DevelopedCountry) ).

fof(kb_SUMO_6835,axiom,
    s__economyType(s__Portugal,s__DevelopedCountry) ).

fof(kb_SUMO_6836,axiom,
    s__economyType(s__SanMarino,s__DevelopedCountry) ).

fof(kb_SUMO_6837,axiom,
    s__economyType(s__SouthAfrica,s__DevelopedCountry) ).

fof(kb_SUMO_6838,axiom,
    s__economyType(s__Spain,s__DevelopedCountry) ).

fof(kb_SUMO_6839,axiom,
    s__economyType(s__Sweden,s__DevelopedCountry) ).

fof(kb_SUMO_6840,axiom,
    s__economyType(s__Switzerland,s__DevelopedCountry) ).

fof(kb_SUMO_6841,axiom,
    s__economyType(s__Turkey,s__DevelopedCountry) ).

fof(kb_SUMO_6842,axiom,
    s__economyType(s__UnitedKingdom,s__DevelopedCountry) ).

fof(kb_SUMO_6843,axiom,
    s__economyType(s__UnitedStates,s__DevelopedCountry) ).

fof(kb_SUMO_6844,axiom,
    s__instance(s__FormerSovietOrEasternEuropeanCountry,s__UNEconomicDevelopmentLevel) ).

fof(kb_SUMO_6845,axiom,
    s__names('Former Soviet or Eastern European Country',s__FormerSovietOrEasternEuropeanCountry) ).

fof(kb_SUMO_6846,axiom,
    s__names('Former Soviet',s__FormerSovietOrEasternEuropeanCountry) ).

fof(kb_SUMO_6847,axiom,
    s__names('Former Eastern European',s__FormerSovietOrEasternEuropeanCountry) ).

fof(kb_SUMO_6848,axiom,
    s__formerName('Second World',s__FormerSovietOrEasternEuropeanCountry) ).

fof(kb_SUMO_6849,axiom,
    s__successorAttribute(s__FormerSovietOrEasternEuropeanCountry,s__DevelopedCountry) ).

fof(kb_SUMO_6850,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__FormerSovietOrEasternEuropeanCountry)
       => s__economyType(V__AREA,s__CountryInTransition) ) ) ).

fof(kb_SUMO_6851,axiom,
    s__documentation(s__FormerSovietOrEasternEuropeanCountry,s__EnglishLanguage,'&%FormerSovietOrEasternEuropeanCountry (former USSR-EE) is an &%Attribute that characterizes countries that were part of the former Soviet Union or its sphere of influence in Eastern Europe. This level occupies a middle position between &%DevelopedCountry (DC) and &%LessDevelopedCountry (LDC) in &%UNEconomicDevelopmentLevels. Previously, former USSR-EE countries had a &%CentrallyPlannedEconomy and were Marxist-Leninist states. Many are now evolving away from command economies to market economic systems. During the 1980s, the group included Albania, Bulgaria, Cambodia, China, Cuba, Czechoslovakia, the German Democratic Republic (East Germany), Hungary, North Korea, Laos, Mongolia, Poland, Romania, the USSR, Vietnam and Yugoslavia.') ).

fof(kb_SUMO_6852,axiom,
    s__instance(s__LessDevelopedCountry,s__UNEconomicDevelopmentLevel) ).

fof(kb_SUMO_6853,axiom,
    s__conventionalLongName('Less Developed Country',s__LessDevelopedCountry) ).

fof(kb_SUMO_6854,axiom,
    s__formerName('Third World',s__LessDevelopedCountry) ).

fof(kb_SUMO_6855,axiom,
    s__successorAttribute(s__LessDevelopedCountry,s__FormerSovietOrEasternEuropeanCountry) ).

fof(kb_SUMO_6856,axiom,
    s__documentation(s__LessDevelopedCountry,s__EnglishLanguage,'&%LessDevelopedCountry (LDC) is the &%Attribute used to describe the bottom group in the hierarchy of &%UNEconomicDevelopmentLevels. Less developed countries are countries or dependent areas with low levels of production, living standards, and technology. Per capita GDP (&%perCapitaGDPInPeriod), or GDI (Gross Domestic Income), is generally less than $5,000 and often below $1,500. Subgroups of LDC, however, include countries that have higher per capita incomes, as well as advanced technology, and rapid rates of growth. Subgroups of LDC include: advanced developing countries, the Four Dragons (also known as Four Tigers), &%LeastDevelopedCountry (LLDCs), low-income countries, middle-income countries, newly industrializing economies (NIEs), the South (from the location of most LDC countries, relative to Northern developed countries), Third World (obsolete), &%UnderdevelopedCountry, &%UndevelopedCountry.') ).

fof(kb_SUMO_6857,axiom,
    s__conventionalShortName('the South',s__LessDevelopedCountry) ).

fof(kb_SUMO_6858,axiom,
    s__abbreviation('LDC',s__LessDevelopedCountry) ).

fof(kb_SUMO_6859,axiom,
    s__cardinality(s__ExtensionFn(s__LessDevelopedCountry),"172") ).

fof(kb_SUMO_6860,axiom,
    s__economyType(s__Afghanistan,s__LessDevelopedCountry) ).

fof(kb_SUMO_6861,axiom,
    s__economyType(s__Algeria,s__LessDevelopedCountry) ).

fof(kb_SUMO_6862,axiom,
    s__economyType(s__Angola,s__LessDevelopedCountry) ).

fof(kb_SUMO_6863,axiom,
    s__economyType(s__AntiguaAndBarbuda,s__LessDevelopedCountry) ).

fof(kb_SUMO_6864,axiom,
    s__economyType(s__Argentina,s__LessDevelopedCountry) ).

fof(kb_SUMO_6865,axiom,
    s__economyType(s__Aruba,s__LessDevelopedCountry) ).

fof(kb_SUMO_6866,axiom,
    s__economyType(s__TheBahamas,s__LessDevelopedCountry) ).

fof(kb_SUMO_6867,axiom,
    s__economyType(s__Bahrain,s__LessDevelopedCountry) ).

fof(kb_SUMO_6868,axiom,
    s__economyType(s__Bangladesh,s__LessDevelopedCountry) ).

fof(kb_SUMO_6869,axiom,
    s__economyType(s__Barbados,s__LessDevelopedCountry) ).

fof(kb_SUMO_6870,axiom,
    s__economyType(s__Belize,s__LessDevelopedCountry) ).

fof(kb_SUMO_6871,axiom,
    s__economyType(s__Burundi,s__LessDevelopedCountry) ).

fof(kb_SUMO_6872,axiom,
    s__economyType(s__Cambodia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6873,axiom,
    s__economyType(s__Cameroon,s__LessDevelopedCountry) ).

fof(kb_SUMO_6874,axiom,
    s__economyType(s__CapeVerde,s__LessDevelopedCountry) ).

fof(kb_SUMO_6875,axiom,
    s__economyType(s__CentralAfricanRepublic,s__LessDevelopedCountry) ).

fof(kb_SUMO_6876,axiom,
    s__economyType(s__Chad,s__LessDevelopedCountry) ).

fof(kb_SUMO_6877,axiom,
    s__economyType(s__Chile,s__LessDevelopedCountry) ).

fof(kb_SUMO_6878,axiom,
    s__economyType(s__China,s__LessDevelopedCountry) ).

fof(kb_SUMO_6879,axiom,
    s__economyType(s__Colombia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6880,axiom,
    s__economyType(s__Comoros,s__LessDevelopedCountry) ).

fof(kb_SUMO_6881,axiom,
    s__economyType(s__DemocraticRepublicOfTheCongo,s__LessDevelopedCountry) ).

fof(kb_SUMO_6882,axiom,
    s__economyType(s__CostaRica,s__LessDevelopedCountry) ).

fof(kb_SUMO_6883,axiom,
    s__economyType(s__CoteDIvoire,s__LessDevelopedCountry) ).

fof(kb_SUMO_6884,axiom,
    s__economyType(s__Cyprus,s__LessDevelopedCountry) ).

fof(kb_SUMO_6885,axiom,
    s__economyType(s__Djibouti,s__LessDevelopedCountry) ).

fof(kb_SUMO_6886,axiom,
    s__economyType(s__Dominica,s__LessDevelopedCountry) ).

fof(kb_SUMO_6887,axiom,
    s__economyType(s__DominicanRepublic,s__LessDevelopedCountry) ).

fof(kb_SUMO_6888,axiom,
    s__economyType(s__Ecuador,s__LessDevelopedCountry) ).

fof(kb_SUMO_6889,axiom,
    s__economyType(s__Egypt,s__LessDevelopedCountry) ).

fof(kb_SUMO_6890,axiom,
    s__economyType(s__ElSalvador,s__LessDevelopedCountry) ).

fof(kb_SUMO_6891,axiom,
    s__economyType(s__EquatorialGuinea,s__LessDevelopedCountry) ).

fof(kb_SUMO_6892,axiom,
    s__economyType(s__Ethiopia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6893,axiom,
    s__economyType(s__Fiji,s__LessDevelopedCountry) ).

fof(kb_SUMO_6894,axiom,
    s__economyType(s__Gabon,s__LessDevelopedCountry) ).

fof(kb_SUMO_6895,axiom,
    s__economyType(s__Gambia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6896,axiom,
    s__economyType(s__Ghana,s__LessDevelopedCountry) ).

fof(kb_SUMO_6897,axiom,
    s__economyType(s__Grenada,s__LessDevelopedCountry) ).

fof(kb_SUMO_6898,axiom,
    s__economyType(s__Guatemala,s__LessDevelopedCountry) ).

fof(kb_SUMO_6899,axiom,
    s__economyType(s__Guinea,s__LessDevelopedCountry) ).

fof(kb_SUMO_6900,axiom,
    s__economyType(s__GuineaBissau,s__LessDevelopedCountry) ).

fof(kb_SUMO_6901,axiom,
    s__economyType(s__Guyana,s__LessDevelopedCountry) ).

fof(kb_SUMO_6902,axiom,
    s__economyType(s__Haiti,s__LessDevelopedCountry) ).

fof(kb_SUMO_6903,axiom,
    s__economyType(s__Honduras,s__LessDevelopedCountry) ).

fof(kb_SUMO_6904,axiom,
    s__economyType(s__India,s__LessDevelopedCountry) ).

fof(kb_SUMO_6905,axiom,
    s__economyType(s__Indonesia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6906,axiom,
    s__economyType(s__Iran,s__LessDevelopedCountry) ).

fof(kb_SUMO_6907,axiom,
    s__economyType(s__Iraq,s__LessDevelopedCountry) ).

fof(kb_SUMO_6908,axiom,
    s__economyType(s__Jamaica,s__LessDevelopedCountry) ).

fof(kb_SUMO_6909,axiom,
    s__economyType(s__Jordan,s__LessDevelopedCountry) ).

fof(kb_SUMO_6910,axiom,
    s__economyType(s__Kenya,s__LessDevelopedCountry) ).

fof(kb_SUMO_6911,axiom,
    s__economyType(s__Kiribati,s__LessDevelopedCountry) ).

fof(kb_SUMO_6912,axiom,
    s__economyType(s__Kuwait,s__LessDevelopedCountry) ).

fof(kb_SUMO_6913,axiom,
    s__economyType(s__Laos,s__LessDevelopedCountry) ).

fof(kb_SUMO_6914,axiom,
    s__economyType(s__Lebanon,s__LessDevelopedCountry) ).

fof(kb_SUMO_6915,axiom,
    s__economyType(s__Lesotho,s__LessDevelopedCountry) ).

fof(kb_SUMO_6916,axiom,
    s__economyType(s__Liberia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6917,axiom,
    s__economyType(s__Libya,s__LessDevelopedCountry) ).

fof(kb_SUMO_6918,axiom,
    s__economyType(s__Madagascar,s__LessDevelopedCountry) ).

fof(kb_SUMO_6919,axiom,
    s__economyType(s__Malawi,s__LessDevelopedCountry) ).

fof(kb_SUMO_6920,axiom,
    s__economyType(s__Malaysia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6921,axiom,
    s__economyType(s__Maldives,s__LessDevelopedCountry) ).

fof(kb_SUMO_6922,axiom,
    s__economyType(s__Mali,s__LessDevelopedCountry) ).

fof(kb_SUMO_6923,axiom,
    s__economyType(s__Malta,s__LessDevelopedCountry) ).

fof(kb_SUMO_6924,axiom,
    s__economyType(s__MarshallIslands,s__LessDevelopedCountry) ).

fof(kb_SUMO_6925,axiom,
    s__economyType(s__Mauritania,s__LessDevelopedCountry) ).

fof(kb_SUMO_6926,axiom,
    s__economyType(s__Mauritius,s__LessDevelopedCountry) ).

fof(kb_SUMO_6927,axiom,
    s__economyType(s__Mexico,s__LessDevelopedCountry) ).

fof(kb_SUMO_6928,axiom,
    s__economyType(s__Micronesia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6929,axiom,
    s__economyType(s__Morocco,s__LessDevelopedCountry) ).

fof(kb_SUMO_6930,axiom,
    s__economyType(s__Mozambique,s__LessDevelopedCountry) ).

fof(kb_SUMO_6931,axiom,
    s__economyType(s__Namibia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6932,axiom,
    s__economyType(s__Nepal,s__LessDevelopedCountry) ).

fof(kb_SUMO_6933,axiom,
    s__economyType(s__NetherlandsAntilles,s__LessDevelopedCountry) ).

fof(kb_SUMO_6934,axiom,
    s__economyType(s__Nicaragua,s__LessDevelopedCountry) ).

fof(kb_SUMO_6935,axiom,
    s__economyType(s__Niger,s__LessDevelopedCountry) ).

fof(kb_SUMO_6936,axiom,
    s__economyType(s__Nigeria,s__LessDevelopedCountry) ).

fof(kb_SUMO_6937,axiom,
    s__economyType(s__Oman,s__LessDevelopedCountry) ).

fof(kb_SUMO_6938,axiom,
    s__economyType(s__Pakistan,s__LessDevelopedCountry) ).

fof(kb_SUMO_6939,axiom,
    s__economyType(s__Panama,s__LessDevelopedCountry) ).

fof(kb_SUMO_6940,axiom,
    s__economyType(s__PapuaNewGuinea,s__LessDevelopedCountry) ).

fof(kb_SUMO_6941,axiom,
    s__economyType(s__Paraguay,s__LessDevelopedCountry) ).

fof(kb_SUMO_6942,axiom,
    s__economyType(s__Peru,s__LessDevelopedCountry) ).

fof(kb_SUMO_6943,axiom,
    s__economyType(s__Philippines,s__LessDevelopedCountry) ).

fof(kb_SUMO_6944,axiom,
    s__economyType(s__Qatar,s__LessDevelopedCountry) ).

fof(kb_SUMO_6945,axiom,
    s__economyType(s__Rwanda,s__LessDevelopedCountry) ).

fof(kb_SUMO_6946,axiom,
    s__economyType(s__SaintKittsAndNevis,s__LessDevelopedCountry) ).

fof(kb_SUMO_6947,axiom,
    s__economyType(s__SaintLucia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6948,axiom,
    s__economyType(s__SaintVincentAndTheGrenadines,s__LessDevelopedCountry) ).

fof(kb_SUMO_6949,axiom,
    s__economyType(s__Samoa,s__LessDevelopedCountry) ).

fof(kb_SUMO_6950,axiom,
    s__economyType(s__SaoTomeAndPrincipe,s__LessDevelopedCountry) ).

fof(kb_SUMO_6951,axiom,
    s__economyType(s__SaudiArabia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6952,axiom,
    s__economyType(s__Senegal,s__LessDevelopedCountry) ).

fof(kb_SUMO_6953,axiom,
    s__economyType(s__Seychelles,s__LessDevelopedCountry) ).

fof(kb_SUMO_6954,axiom,
    s__economyType(s__SierraLeone,s__LessDevelopedCountry) ).

fof(kb_SUMO_6955,axiom,
    s__economyType(s__SolomonIslands,s__LessDevelopedCountry) ).

fof(kb_SUMO_6956,axiom,
    s__economyType(s__Somalia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6957,axiom,
    s__economyType(s__SouthAfrica,s__LessDevelopedCountry) ).

fof(kb_SUMO_6958,axiom,
    s__economyType(s__SriLanka,s__LessDevelopedCountry) ).

fof(kb_SUMO_6959,axiom,
    s__economyType(s__Sudan,s__LessDevelopedCountry) ).

fof(kb_SUMO_6960,axiom,
    s__economyType(s__Suriname,s__LessDevelopedCountry) ).

fof(kb_SUMO_6961,axiom,
    s__economyType(s__Swaziland,s__LessDevelopedCountry) ).

fof(kb_SUMO_6962,axiom,
    s__economyType(s__Syria,s__LessDevelopedCountry) ).

fof(kb_SUMO_6963,axiom,
    s__economyType(s__Tanzania,s__LessDevelopedCountry) ).

fof(kb_SUMO_6964,axiom,
    s__economyType(s__Thailand,s__LessDevelopedCountry) ).

fof(kb_SUMO_6965,axiom,
    s__economyType(s__Togo,s__LessDevelopedCountry) ).

fof(kb_SUMO_6966,axiom,
    s__economyType(s__TrinidadAndTobago,s__LessDevelopedCountry) ).

fof(kb_SUMO_6967,axiom,
    s__economyType(s__Tunisia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6968,axiom,
    s__economyType(s__Turkey,s__LessDevelopedCountry) ).

fof(kb_SUMO_6969,axiom,
    s__economyType(s__UnitedArabEmirates,s__LessDevelopedCountry) ).

fof(kb_SUMO_6970,axiom,
    s__economyType(s__Uganda,s__LessDevelopedCountry) ).

fof(kb_SUMO_6971,axiom,
    s__economyType(s__Uruguay,s__LessDevelopedCountry) ).

fof(kb_SUMO_6972,axiom,
    s__economyType(s__Vanuatu,s__LessDevelopedCountry) ).

fof(kb_SUMO_6973,axiom,
    s__economyType(s__Venezuela,s__LessDevelopedCountry) ).

fof(kb_SUMO_6974,axiom,
    s__economyType(s__Vietnam,s__LessDevelopedCountry) ).

fof(kb_SUMO_6975,axiom,
    s__economyType(s__Yemen,s__LessDevelopedCountry) ).

fof(kb_SUMO_6976,axiom,
    s__economyType(s__Zambia,s__LessDevelopedCountry) ).

fof(kb_SUMO_6977,axiom,
    s__economyType(s__Zimbabwe,s__LessDevelopedCountry) ).

fof(kb_SUMO_6978,axiom,
    s__instance(s__AdvancedDevelopingCountry,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_6979,axiom,
    s__instance(s__EconomicDevelopmentLevel__t,s__SetOrClass) ).

fof(kb_SUMO_6980,axiom,
    s__subAttribute(s__AdvancedDevelopingCountry,s__LessDevelopedCountry) ).

fof(kb_SUMO_6981,axiom,
    s__names('Advanced Developing Country',s__AdvancedDevelopingCountry) ).

fof(kb_SUMO_6982,axiom,
    s__documentation(s__AdvancedDevelopingCountry,s__EnglishLanguage,'&%AdvancedDevelopingCountry is an &%Attribute used to describe a &%LessDevelopedCountry (LDC) that is undergoing rapid industrial development. Also called newly industrializing economy (or country).') ).

fof(kb_SUMO_6983,axiom,
    s__instance(s__NewlyIndustrializingEconomy,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_6984,axiom,
    s__names('Newly Industrializing Economies',s__NewlyIndustrializingEconomy) ).

fof(kb_SUMO_6985,axiom,
    s__abbreviation('NIE',s__NewlyIndustrializingEconomy) ).

fof(kb_SUMO_6986,axiom,
    s__formerName('Newly Industrializing Countries',s__NewlyIndustrializingEconomy) ).

fof(kb_SUMO_6987,axiom,
    s__formerName('NIC',s__NewlyIndustrializingEconomy) ).

fof(kb_SUMO_6988,axiom,
    s__documentation(s__NewlyIndustrializingEconomy,s__EnglishLanguage,'&%NewlyIndustrializingEconomy is an &%Attribute used to describe a &%LessDevelopedCountry (LDC) that is undergoing rapid industrial development. Also called newly industrializing economy (or country).') ).

fof(kb_SUMO_6989,axiom,
    s__instance(s__FourDragonsEconomy,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_6990,axiom,
    s__names('Four Dragons',s__FourDragonsEconomy) ).

fof(kb_SUMO_6991,axiom,
    s__names('Four Tigers',s__FourDragonsEconomy) ).

fof(kb_SUMO_6992,axiom,
    s__economyType(s__HongKong,s__FourDragonsEconomy) ).

fof(kb_SUMO_6993,axiom,
    s__economyType(s__Singapore,s__FourDragonsEconomy) ).

fof(kb_SUMO_6994,axiom,
    s__economyType(s__SouthKorea,s__FourDragonsEconomy) ).

fof(kb_SUMO_6995,axiom,
    s__economyType(s__Taiwan,s__FourDragonsEconomy) ).

fof(kb_SUMO_6996,axiom,
    s__documentation(s__FourDragonsEconomy,s__EnglishLanguage,'&%FourDragonsEconomy describes four small Asian countries that achieved rapid economic growth in the 1990s. Some systems of &%EconomicDevelopmentLevel place them as a &%LessDevelopedCountry, but the IMF includes them in &%AdvancedEconomy.') ).

fof(kb_SUMO_6997,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__FourDragonsEconomy)
       => s__economyType(V__AREA,s__LessDevelopedCountry) ) ) ).

fof(kb_SUMO_6998,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__FourDragonsEconomy)
       => s__economyType(V__AREA,s__AdvancedEconomy) ) ) ).

fof(kb_SUMO_6999,axiom,
    s__instance(s__UnderdevelopedCountry,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_7000,axiom,
    s__subAttribute(s__UnderdevelopedCountry,s__LessDevelopedCountry) ).

fof(kb_SUMO_7001,axiom,
    s__documentation(s__UnderdevelopedCountry,s__EnglishLanguage,'&%UnderdevelopedCountry is an &%Attribute describing less developed countries that have potential for above-average economic growth. See also &%LessDevelopedCountry.') ).

fof(kb_SUMO_7002,axiom,
    s__instance(s__LeastDevelopedCountry,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_7003,axiom,
    s__subAttribute(s__LeastDevelopedCountry,s__LessDevelopedCountry) ).

fof(kb_SUMO_7004,axiom,
    s__conventionalLongName('Least Developed Countries',s__LeastDevelopedCountry) ).

fof(kb_SUMO_7005,axiom,
    s__names('Undeveloped Country',s__LeastDevelopedCountry) ).

fof(kb_SUMO_7006,axiom,
    s__names('Undeveloped Economy',s__LeastDevelopedCountry) ).

fof(kb_SUMO_7007,axiom,
    s__abbreviation('LLDC',s__LeastDevelopedCountry) ).

fof(kb_SUMO_7008,axiom,
    s__cardinality(s__ExtensionFn(s__LeastDevelopedCountry),"42") ).

fof(kb_SUMO_7009,axiom,
    s__documentation(s__LeastDevelopedCountry,s__EnglishLanguage,'&%LeastDevelopedCountry is a sub-classification of &%LessDevelopedCountry characterizing those countries that have no significant economic growth, a per capita GDP of less than $1,000 &%UnitedStatesDollars, and low literacy. Also known as undeveloped countries.') ).

fof(kb_SUMO_7010,axiom,
    s__subclass(s__WorldBankGNIPerCapitaLevel,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_7011,axiom,
    s__names('GNI per capita',s__WorldBankGNIPerCapitaLevel) ).

fof(kb_SUMO_7012,axiom,
    s__names('gross national income per capita',s__WorldBankGNIPerCapitaLevel) ).

fof(kb_SUMO_7013,axiom,
    s__documentation(s__WorldBankGNIPerCapitaLevel,s__EnglishLanguage,'&%WorldBankGNIPerCapitaLevel is the subclass of &%EconomicDevelopmentLevel containing attributes that characterize countries according to their per capita gross national income (GNI), as determined by the &%WorldBankGroup. The World Bank uses the Atlas method for making cross-country comparisons of national income.') ).

fof(kb_SUMO_7014,axiom,
    s__successorAttribute(s__LowIncomeCountry,s__LowerMiddleIncomeCountry) ).

fof(kb_SUMO_7015,axiom,
    s__successorAttribute(s__LowerMiddleIncomeCountry,s__UpperMiddleIncomeCountry) ).

fof(kb_SUMO_7016,axiom,
    s__successorAttribute(s__UpperMiddleIncomeCountry,s__HighIncomeCountry) ).

fof(kb_SUMO_7017,axiom,
    s__instance(s__LowIncomeCountry,s__WorldBankGNIPerCapitaLevel) ).

fof(kb_SUMO_7018,axiom,
    s__instance(s__WorldBankGNIPerCapitaLevel__t,s__SetOrClass) ).

fof(kb_SUMO_7019,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__LowIncomeCountry)
       => s__economyType(V__AREA,s__LeastDevelopedCountry) ) ) ).

fof(kb_SUMO_7020,axiom,
    s__documentation(s__LowIncomeCountry,s__EnglishLanguage,'&%LowIncomeCountry is an &%Attribute representing the World Bank classification for any country where the per capita GNI is $755 or below in &%UnitedStatesDollars.') ).

%FOL fof(kb_SUMO_7021,axiom,(( (! [V__AMOUNT,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__YEAR,s__TimeInterval) & s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,s__SetOrClass) & s__instance(V__AMOUNT,s__RealNumber)) => ((s__instance(V__YEAR,s__TimeInterval) & s__holdsDuring(V__YEAR,'s__economyType(V__AREA,s__LowIncomeCountry)')) => (s__perCapitaGDPInPeriod(V__AREA,s__MeasureFn(V__AMOUNT,s__UnitedStatesDollar),V__YEAR) & less(V__AMOUNT,756))))) ))).

fof(kb_SUMO_7022,axiom,
    s__instance(s__LowerMiddleIncomeCountry,s__WorldBankGNIPerCapitaLevel) ).

fof(kb_SUMO_7023,axiom,
    s__documentation(s__LowerMiddleIncomeCountry,s__EnglishLanguage,'&%LowerMiddleIncomeCountry is an &%Attribute representing the World Bank classification for any country where the per capita GNI is between $756 and $2,995 (inclusive) in &%UnitedStatesDollars.') ).

%FOL fof(kb_SUMO_7024,axiom,(( (! [V__AMOUNT,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__YEAR,s__TimeInterval) & s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,s__SetOrClass) & s__instance(V__AMOUNT,s__RealNumber)) => ((s__instance(V__YEAR,s__TimeInterval) & s__holdsDuring(V__YEAR,'s__economyType(V__AREA,s__LowerMiddleIncomeCountry)')) => (s__perCapitaGDPInPeriod(V__AREA,s__MeasureFn(V__AMOUNT,s__UnitedStatesDollar),V__YEAR) & greatereq(V__AMOUNT,756))))) ))).

%FOL fof(kb_SUMO_7025,axiom,(( (! [V__AMOUNT,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__YEAR,s__TimeInterval) & s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,s__SetOrClass) & s__instance(V__AMOUNT,s__RealNumber)) => ((s__instance(V__YEAR,s__TimeInterval) & s__holdsDuring(V__YEAR,'s__economyType(V__AREA,s__LowerMiddleIncomeCountry)')) => (s__perCapitaGDPInPeriod(V__AREA,s__MeasureFn(V__AMOUNT,s__UnitedStatesDollar),V__YEAR) & less(V__AMOUNT,2996))))) ))).

fof(kb_SUMO_7026,axiom,
    s__instance(s__UpperMiddleIncomeCountry,s__WorldBankGNIPerCapitaLevel) ).

fof(kb_SUMO_7027,axiom,
    s__documentation(s__UpperMiddleIncomeCountry,s__EnglishLanguage,'&%LowerMiddleIncomeCountry is an &%Attribute representing the World Bank classification for any country where the per capita GNI is between $2,996 and $9,266 (inclusive) in &%UnitedStatesDollars.') ).

%FOL fof(kb_SUMO_7028,axiom,(( (! [V__AMOUNT,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__YEAR,s__TimeInterval) & s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,s__SetOrClass) & s__instance(V__AMOUNT,s__RealNumber)) => ((s__instance(V__YEAR,s__TimeInterval) & s__holdsDuring(V__YEAR,'s__economyType(V__AREA,s__UpperMiddleIncomeCountry)')) => (s__perCapitaGDPInPeriod(V__AREA,s__MeasureFn(V__AMOUNT,s__UnitedStatesDollar),V__YEAR) & greatereq(V__AMOUNT,2996))))) ))).

%FOL fof(kb_SUMO_7029,axiom,(( (! [V__AMOUNT,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__YEAR,s__TimeInterval) & s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,s__SetOrClass) & s__instance(V__AMOUNT,s__RealNumber)) => ((s__instance(V__YEAR,s__TimeInterval) & s__holdsDuring(V__YEAR,'s__economyType(V__AREA,s__UpperMiddleIncomeCountry)')) => (s__perCapitaGDPInPeriod(V__AREA,s__MeasureFn(V__AMOUNT,s__UnitedStatesDollar),V__YEAR) & less(V__AMOUNT,9267))))) ))).

fof(kb_SUMO_7030,axiom,
    s__instance(s__HighIncomeCountry,s__WorldBankGNIPerCapitaLevel) ).

fof(kb_SUMO_7031,axiom,
    s__documentation(s__HighIncomeCountry,s__EnglishLanguage,'&%HighIncomeCountry is an &%Attribute representing the World Bank classification for any country where the per capita GNI is equal to or greater than &9,266 in &%UnitedStatesDollars.') ).

fof(kb_SUMO_7032,axiom,
    ! [V__AREA] :
      ( ( s__instance(V__AREA,s__SelfConnectedObject)
        & s__instance(V__AREA,s__Agent) )
     => ( ( s__attribute(V__AREA,s__HighIncomeCountry)
          & ~ s__member(V__AREA,s__OrganizationOfPetroleumExportingCountries) )
       => s__economyType(V__AREA,s__DevelopedCountry) ) ) ).

fof(kb_SUMO_7033,axiom,
    s__subclass(s__IMFDevelopmentLevel,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_7034,axiom,
    s__successorAttribute(s__DevelopingCountry,s__CountryInTransition) ).

fof(kb_SUMO_7035,axiom,
    s__successorAttribute(s__CountryInTransition,s__AdvancedEconomy) ).

fof(kb_SUMO_7036,axiom,
    s__documentation(s__IMFDevelopmentLevel,s__EnglishLanguage,'&%IMFDevelopmentLevel is a collection of &%Attributes representing economic development levels used by the &%InternationalMonetaryFund (IMF) to characterize national economies. The hierarchy of IMF levels includes: &%AdvancedEconomy, &%CountryInTransition, and &%DevelopingCountry. There is some, but not complete, overlap with concepts used by &%UnitedNations agencies. See ') ).

fof(kb_SUMO_7037,axiom,
    s__instance(s__AdvancedEconomy,s__IMFDevelopmentLevel) ).

fof(kb_SUMO_7038,axiom,
    s__instance(s__IMFDevelopmentLevel__t,s__SetOrClass) ).

fof(kb_SUMO_7039,axiom,
    s__documentation(s__AdvancedEconomy,s__EnglishLanguage,'&%AdvancedEconomy is an &%Attribute used to represent the &%InternationalMonetaryFunds top category of development levels (&%AdvancedEconomy,, countries in transition, and developing countries. Generally (but not exactly) corresponds with &%DevelopedCountry classification used by &%UnitedNations agencies.') ).

fof(kb_SUMO_7040,axiom,
    s__economyType(s__Australia,s__AdvancedEconomy) ).

fof(kb_SUMO_7041,axiom,
    s__economyType(s__Austria,s__AdvancedEconomy) ).

fof(kb_SUMO_7042,axiom,
    s__economyType(s__Belgium,s__AdvancedEconomy) ).

fof(kb_SUMO_7043,axiom,
    s__economyType(s__Canada,s__AdvancedEconomy) ).

fof(kb_SUMO_7044,axiom,
    s__economyType(s__Denmark,s__AdvancedEconomy) ).

fof(kb_SUMO_7045,axiom,
    s__economyType(s__Finland,s__AdvancedEconomy) ).

fof(kb_SUMO_7046,axiom,
    s__economyType(s__France,s__AdvancedEconomy) ).

fof(kb_SUMO_7047,axiom,
    s__economyType(s__Germany,s__AdvancedEconomy) ).

fof(kb_SUMO_7048,axiom,
    s__economyType(s__Greece,s__AdvancedEconomy) ).

fof(kb_SUMO_7049,axiom,
    s__economyType(s__HongKong,s__AdvancedEconomy) ).

fof(kb_SUMO_7050,axiom,
    s__economyType(s__Iceland,s__AdvancedEconomy) ).

fof(kb_SUMO_7051,axiom,
    s__economyType(s__Ireland,s__AdvancedEconomy) ).

fof(kb_SUMO_7052,axiom,
    s__economyType(s__Israel,s__AdvancedEconomy) ).

fof(kb_SUMO_7053,axiom,
    s__economyType(s__Italy,s__AdvancedEconomy) ).

fof(kb_SUMO_7054,axiom,
    s__economyType(s__Japan,s__AdvancedEconomy) ).

fof(kb_SUMO_7055,axiom,
    s__economyType(s__SouthKorea,s__AdvancedEconomy) ).

fof(kb_SUMO_7056,axiom,
    s__economyType(s__Luxembourg,s__AdvancedEconomy) ).

fof(kb_SUMO_7057,axiom,
    s__economyType(s__Netherlands,s__AdvancedEconomy) ).

fof(kb_SUMO_7058,axiom,
    s__economyType(s__NewZealand,s__AdvancedEconomy) ).

fof(kb_SUMO_7059,axiom,
    s__economyType(s__Norway,s__AdvancedEconomy) ).

fof(kb_SUMO_7060,axiom,
    s__economyType(s__Portugal,s__AdvancedEconomy) ).

fof(kb_SUMO_7061,axiom,
    s__economyType(s__Singapore,s__AdvancedEconomy) ).

fof(kb_SUMO_7062,axiom,
    s__economyType(s__Spain,s__AdvancedEconomy) ).

fof(kb_SUMO_7063,axiom,
    s__economyType(s__Sweden,s__AdvancedEconomy) ).

fof(kb_SUMO_7064,axiom,
    s__economyType(s__Switzerland,s__AdvancedEconomy) ).

fof(kb_SUMO_7065,axiom,
    s__economyType(s__Taiwan,s__AdvancedEconomy) ).

fof(kb_SUMO_7066,axiom,
    s__economyType(s__UnitedKingdom,s__AdvancedEconomy) ).

fof(kb_SUMO_7067,axiom,
    s__economyType(s__UnitedStates,s__AdvancedEconomy) ).

fof(kb_SUMO_7068,axiom,
    s__instance(s__CountryInTransition,s__IMFDevelopmentLevel) ).

fof(kb_SUMO_7069,axiom,
    s__documentation(s__CountryInTransition,s__EnglishLanguage,'&%CountryInTransition is a term used by the &%InternationalMonetaryFund (IMF) to describe the middle group in its hierarchy of advanced countries, countries in transition, and developing countries. Most of the countries with this attribute are former USSR or Eastern European countries. Generally corresponds with &%FormerSovietOrEasternEuropeanCountry classification used by &%UnitedNations agencies.') ).

fof(kb_SUMO_7070,axiom,
    s__economyType(s__Albania,s__CountryInTransition) ).

fof(kb_SUMO_7071,axiom,
    s__economyType(s__Armenia,s__CountryInTransition) ).

fof(kb_SUMO_7072,axiom,
    s__economyType(s__Azerbaijan,s__CountryInTransition) ).

fof(kb_SUMO_7073,axiom,
    s__economyType(s__Belarus,s__CountryInTransition) ).

fof(kb_SUMO_7074,axiom,
    s__economyType(s__BosniaAndHerzegovina,s__CountryInTransition) ).

fof(kb_SUMO_7075,axiom,
    s__economyType(s__Bulgaria,s__CountryInTransition) ).

fof(kb_SUMO_7076,axiom,
    s__economyType(s__Croatia,s__CountryInTransition) ).

fof(kb_SUMO_7077,axiom,
    s__economyType(s__CzechRepublic,s__CountryInTransition) ).

fof(kb_SUMO_7078,axiom,
    s__economyType(s__Estonia,s__CountryInTransition) ).

fof(kb_SUMO_7079,axiom,
    s__economyType(s__RepublicOfGeorgia,s__CountryInTransition) ).

fof(kb_SUMO_7080,axiom,
    s__economyType(s__Hungary,s__CountryInTransition) ).

fof(kb_SUMO_7081,axiom,
    s__economyType(s__Kazakhstan,s__CountryInTransition) ).

fof(kb_SUMO_7082,axiom,
    s__economyType(s__Kyrgyzstan,s__CountryInTransition) ).

fof(kb_SUMO_7083,axiom,
    s__economyType(s__Latvia,s__CountryInTransition) ).

fof(kb_SUMO_7084,axiom,
    s__economyType(s__Lithuania,s__CountryInTransition) ).

fof(kb_SUMO_7085,axiom,
    s__economyType(s__Macedonia,s__CountryInTransition) ).

fof(kb_SUMO_7086,axiom,
    s__economyType(s__Moldova,s__CountryInTransition) ).

fof(kb_SUMO_7087,axiom,
    s__economyType(s__Mongolia,s__CountryInTransition) ).

fof(kb_SUMO_7088,axiom,
    s__economyType(s__Poland,s__CountryInTransition) ).

fof(kb_SUMO_7089,axiom,
    s__economyType(s__Romania,s__CountryInTransition) ).

fof(kb_SUMO_7090,axiom,
    s__economyType(s__Russia,s__CountryInTransition) ).

fof(kb_SUMO_7091,axiom,
    s__economyType(s__Slovakia,s__CountryInTransition) ).

fof(kb_SUMO_7092,axiom,
    s__economyType(s__Slovenia,s__CountryInTransition) ).

fof(kb_SUMO_7093,axiom,
    s__economyType(s__Tajikistan,s__CountryInTransition) ).

fof(kb_SUMO_7094,axiom,
    s__economyType(s__Turkmenistan,s__CountryInTransition) ).

fof(kb_SUMO_7095,axiom,
    s__economyType(s__Ukraine,s__CountryInTransition) ).

fof(kb_SUMO_7096,axiom,
    s__economyType(s__Uzbekistan,s__CountryInTransition) ).

fof(kb_SUMO_7097,axiom,
    s__economyType(s__Yugoslavia,s__CountryInTransition) ).

fof(kb_SUMO_7098,axiom,
    s__instance(s__Yugoslavia,s__Nation) ).

fof(kb_SUMO_7099,axiom,
    s__instance(s__DevelopingCountry,s__IMFDevelopmentLevel) ).

fof(kb_SUMO_7100,axiom,
    s__documentation(s__DevelopingCountry,s__EnglishLanguage,'&%DevelopingCountry is a term used by the &%InternationalMonetaryFund (IMF) for the bottom group in its hierarchy of advanced countries, countries in transition, and developing countries. Generally corresponds to the attribute &%LessDevelopedCountry used by &%UnitedNations agencies. Not to be confused with &%DevelopedCountry.') ).

fof(kb_SUMO_7101,axiom,
    s__cardinality(s__ExtensionFn(s__DevelopingCountry),"126") ).

fof(kb_SUMO_7102,axiom,
    s__economyType(s__Afghanistan,s__DevelopingCountry) ).

fof(kb_SUMO_7103,axiom,
    s__economyType(s__Algeria,s__DevelopingCountry) ).

fof(kb_SUMO_7104,axiom,
    s__economyType(s__Angola,s__DevelopingCountry) ).

fof(kb_SUMO_7105,axiom,
    s__economyType(s__AntiguaAndBarbuda,s__DevelopingCountry) ).

fof(kb_SUMO_7106,axiom,
    s__economyType(s__Argentina,s__DevelopingCountry) ).

fof(kb_SUMO_7107,axiom,
    s__economyType(s__Aruba,s__DevelopingCountry) ).

fof(kb_SUMO_7108,axiom,
    s__economyType(s__TheBahamas,s__DevelopingCountry) ).

fof(kb_SUMO_7109,axiom,
    s__economyType(s__Bahrain,s__DevelopingCountry) ).

fof(kb_SUMO_7110,axiom,
    s__economyType(s__Bangladesh,s__DevelopingCountry) ).

fof(kb_SUMO_7111,axiom,
    s__economyType(s__Barbados,s__DevelopingCountry) ).

fof(kb_SUMO_7112,axiom,
    s__economyType(s__Belize,s__DevelopingCountry) ).

fof(kb_SUMO_7113,axiom,
    s__economyType(s__Burundi,s__DevelopingCountry) ).

fof(kb_SUMO_7114,axiom,
    s__economyType(s__Cambodia,s__DevelopingCountry) ).

fof(kb_SUMO_7115,axiom,
    s__economyType(s__Cameroon,s__DevelopingCountry) ).

fof(kb_SUMO_7116,axiom,
    s__economyType(s__CapeVerde,s__DevelopingCountry) ).

fof(kb_SUMO_7117,axiom,
    s__economyType(s__CentralAfricanRepublic,s__DevelopingCountry) ).

fof(kb_SUMO_7118,axiom,
    s__economyType(s__Chad,s__DevelopingCountry) ).

fof(kb_SUMO_7119,axiom,
    s__economyType(s__Chile,s__DevelopingCountry) ).

fof(kb_SUMO_7120,axiom,
    s__economyType(s__China,s__DevelopingCountry) ).

fof(kb_SUMO_7121,axiom,
    s__economyType(s__Colombia,s__DevelopingCountry) ).

fof(kb_SUMO_7122,axiom,
    s__economyType(s__Comoros,s__DevelopingCountry) ).

fof(kb_SUMO_7123,axiom,
    s__economyType(s__DemocraticRepublicOfTheCongo,s__DevelopingCountry) ).

fof(kb_SUMO_7124,axiom,
    s__economyType(s__CostaRica,s__DevelopingCountry) ).

fof(kb_SUMO_7125,axiom,
    s__economyType(s__CoteDIvoire,s__DevelopingCountry) ).

fof(kb_SUMO_7126,axiom,
    s__economyType(s__Cyprus,s__DevelopingCountry) ).

fof(kb_SUMO_7127,axiom,
    s__economyType(s__Djibouti,s__DevelopingCountry) ).

fof(kb_SUMO_7128,axiom,
    s__economyType(s__Dominica,s__DevelopingCountry) ).

fof(kb_SUMO_7129,axiom,
    s__economyType(s__DominicanRepublic,s__DevelopingCountry) ).

fof(kb_SUMO_7130,axiom,
    s__economyType(s__Ecuador,s__DevelopingCountry) ).

fof(kb_SUMO_7131,axiom,
    s__economyType(s__Egypt,s__DevelopingCountry) ).

fof(kb_SUMO_7132,axiom,
    s__economyType(s__ElSalvador,s__DevelopingCountry) ).

fof(kb_SUMO_7133,axiom,
    s__economyType(s__EquatorialGuinea,s__DevelopingCountry) ).

fof(kb_SUMO_7134,axiom,
    s__economyType(s__Ethiopia,s__DevelopingCountry) ).

fof(kb_SUMO_7135,axiom,
    s__economyType(s__Fiji,s__DevelopingCountry) ).

fof(kb_SUMO_7136,axiom,
    s__economyType(s__Gabon,s__DevelopingCountry) ).

fof(kb_SUMO_7137,axiom,
    s__economyType(s__Gambia,s__DevelopingCountry) ).

fof(kb_SUMO_7138,axiom,
    s__economyType(s__Ghana,s__DevelopingCountry) ).

fof(kb_SUMO_7139,axiom,
    s__economyType(s__Grenada,s__DevelopingCountry) ).

fof(kb_SUMO_7140,axiom,
    s__economyType(s__Guatemala,s__DevelopingCountry) ).

fof(kb_SUMO_7141,axiom,
    s__economyType(s__Guinea,s__DevelopingCountry) ).

fof(kb_SUMO_7142,axiom,
    s__economyType(s__GuineaBissau,s__DevelopingCountry) ).

fof(kb_SUMO_7143,axiom,
    s__economyType(s__Guyana,s__DevelopingCountry) ).

fof(kb_SUMO_7144,axiom,
    s__economyType(s__Haiti,s__DevelopingCountry) ).

fof(kb_SUMO_7145,axiom,
    s__economyType(s__Honduras,s__DevelopingCountry) ).

fof(kb_SUMO_7146,axiom,
    s__economyType(s__India,s__DevelopingCountry) ).

fof(kb_SUMO_7147,axiom,
    s__economyType(s__Indonesia,s__DevelopingCountry) ).

fof(kb_SUMO_7148,axiom,
    s__economyType(s__Iran,s__DevelopingCountry) ).

fof(kb_SUMO_7149,axiom,
    s__economyType(s__Iraq,s__DevelopingCountry) ).

fof(kb_SUMO_7150,axiom,
    s__economyType(s__Jamaica,s__DevelopingCountry) ).

fof(kb_SUMO_7151,axiom,
    s__economyType(s__Jordan,s__DevelopingCountry) ).

fof(kb_SUMO_7152,axiom,
    s__economyType(s__Kenya,s__DevelopingCountry) ).

fof(kb_SUMO_7153,axiom,
    s__economyType(s__Kiribati,s__DevelopingCountry) ).

fof(kb_SUMO_7154,axiom,
    s__economyType(s__Kuwait,s__DevelopingCountry) ).

fof(kb_SUMO_7155,axiom,
    s__economyType(s__Laos,s__DevelopingCountry) ).

fof(kb_SUMO_7156,axiom,
    s__economyType(s__Lebanon,s__DevelopingCountry) ).

fof(kb_SUMO_7157,axiom,
    s__economyType(s__Lesotho,s__DevelopingCountry) ).

fof(kb_SUMO_7158,axiom,
    s__economyType(s__Liberia,s__DevelopingCountry) ).

fof(kb_SUMO_7159,axiom,
    s__economyType(s__Libya,s__DevelopingCountry) ).

fof(kb_SUMO_7160,axiom,
    s__economyType(s__Madagascar,s__DevelopingCountry) ).

fof(kb_SUMO_7161,axiom,
    s__economyType(s__Malawi,s__DevelopingCountry) ).

fof(kb_SUMO_7162,axiom,
    s__economyType(s__Malaysia,s__DevelopingCountry) ).

fof(kb_SUMO_7163,axiom,
    s__economyType(s__Maldives,s__DevelopingCountry) ).

fof(kb_SUMO_7164,axiom,
    s__economyType(s__Mali,s__DevelopingCountry) ).

fof(kb_SUMO_7165,axiom,
    s__economyType(s__Malta,s__DevelopingCountry) ).

fof(kb_SUMO_7166,axiom,
    s__economyType(s__MarshallIslands,s__DevelopingCountry) ).

fof(kb_SUMO_7167,axiom,
    s__economyType(s__Mauritania,s__DevelopingCountry) ).

fof(kb_SUMO_7168,axiom,
    s__economyType(s__Mauritius,s__DevelopingCountry) ).

fof(kb_SUMO_7169,axiom,
    s__economyType(s__Mexico,s__DevelopingCountry) ).

fof(kb_SUMO_7170,axiom,
    s__economyType(s__Micronesia,s__DevelopingCountry) ).

fof(kb_SUMO_7171,axiom,
    s__economyType(s__Morocco,s__DevelopingCountry) ).

fof(kb_SUMO_7172,axiom,
    s__economyType(s__Mozambique,s__DevelopingCountry) ).

fof(kb_SUMO_7173,axiom,
    s__economyType(s__Namibia,s__DevelopingCountry) ).

fof(kb_SUMO_7174,axiom,
    s__economyType(s__Nepal,s__DevelopingCountry) ).

fof(kb_SUMO_7175,axiom,
    s__economyType(s__NetherlandsAntilles,s__DevelopingCountry) ).

fof(kb_SUMO_7176,axiom,
    s__economyType(s__Nicaragua,s__DevelopingCountry) ).

fof(kb_SUMO_7177,axiom,
    s__economyType(s__Niger,s__DevelopingCountry) ).

fof(kb_SUMO_7178,axiom,
    s__economyType(s__Nigeria,s__DevelopingCountry) ).

fof(kb_SUMO_7179,axiom,
    s__economyType(s__Oman,s__DevelopingCountry) ).

fof(kb_SUMO_7180,axiom,
    s__economyType(s__Pakistan,s__DevelopingCountry) ).

fof(kb_SUMO_7181,axiom,
    s__economyType(s__Panama,s__DevelopingCountry) ).

fof(kb_SUMO_7182,axiom,
    s__economyType(s__PapuaNewGuinea,s__DevelopingCountry) ).

fof(kb_SUMO_7183,axiom,
    s__economyType(s__Paraguay,s__DevelopingCountry) ).

fof(kb_SUMO_7184,axiom,
    s__economyType(s__Peru,s__DevelopingCountry) ).

fof(kb_SUMO_7185,axiom,
    s__economyType(s__Philippines,s__DevelopingCountry) ).

fof(kb_SUMO_7186,axiom,
    s__economyType(s__Qatar,s__DevelopingCountry) ).

fof(kb_SUMO_7187,axiom,
    s__economyType(s__Rwanda,s__DevelopingCountry) ).

fof(kb_SUMO_7188,axiom,
    s__economyType(s__SaintKittsAndNevis,s__DevelopingCountry) ).

fof(kb_SUMO_7189,axiom,
    s__economyType(s__SaintLucia,s__DevelopingCountry) ).

fof(kb_SUMO_7190,axiom,
    s__economyType(s__SaintVincentAndTheGrenadines,s__DevelopingCountry) ).

fof(kb_SUMO_7191,axiom,
    s__economyType(s__Samoa,s__DevelopingCountry) ).

fof(kb_SUMO_7192,axiom,
    s__economyType(s__SaoTomeAndPrincipe,s__DevelopingCountry) ).

fof(kb_SUMO_7193,axiom,
    s__economyType(s__SaudiArabia,s__DevelopingCountry) ).

fof(kb_SUMO_7194,axiom,
    s__economyType(s__Senegal,s__DevelopingCountry) ).

fof(kb_SUMO_7195,axiom,
    s__economyType(s__Seychelles,s__DevelopingCountry) ).

fof(kb_SUMO_7196,axiom,
    s__economyType(s__SierraLeone,s__DevelopingCountry) ).

fof(kb_SUMO_7197,axiom,
    s__economyType(s__SolomonIslands,s__DevelopingCountry) ).

fof(kb_SUMO_7198,axiom,
    s__economyType(s__Somalia,s__DevelopingCountry) ).

fof(kb_SUMO_7199,axiom,
    s__economyType(s__SouthAfrica,s__DevelopingCountry) ).

fof(kb_SUMO_7200,axiom,
    s__economyType(s__SriLanka,s__DevelopingCountry) ).

fof(kb_SUMO_7201,axiom,
    s__economyType(s__Sudan,s__DevelopingCountry) ).

fof(kb_SUMO_7202,axiom,
    s__economyType(s__Suriname,s__DevelopingCountry) ).

fof(kb_SUMO_7203,axiom,
    s__economyType(s__Swaziland,s__DevelopingCountry) ).

fof(kb_SUMO_7204,axiom,
    s__economyType(s__Syria,s__DevelopingCountry) ).

fof(kb_SUMO_7205,axiom,
    s__economyType(s__Tanzania,s__DevelopingCountry) ).

fof(kb_SUMO_7206,axiom,
    s__economyType(s__Thailand,s__DevelopingCountry) ).

fof(kb_SUMO_7207,axiom,
    s__economyType(s__Togo,s__DevelopingCountry) ).

fof(kb_SUMO_7208,axiom,
    s__economyType(s__TrinidadAndTobago,s__DevelopingCountry) ).

fof(kb_SUMO_7209,axiom,
    s__economyType(s__Tunisia,s__DevelopingCountry) ).

fof(kb_SUMO_7210,axiom,
    s__economyType(s__Turkey,s__DevelopingCountry) ).

fof(kb_SUMO_7211,axiom,
    s__economyType(s__UnitedArabEmirates,s__DevelopingCountry) ).

fof(kb_SUMO_7212,axiom,
    s__economyType(s__Uganda,s__DevelopingCountry) ).

fof(kb_SUMO_7213,axiom,
    s__economyType(s__Uruguay,s__DevelopingCountry) ).

fof(kb_SUMO_7214,axiom,
    s__economyType(s__Vanuatu,s__DevelopingCountry) ).

fof(kb_SUMO_7215,axiom,
    s__economyType(s__Venezuela,s__DevelopingCountry) ).

fof(kb_SUMO_7216,axiom,
    s__economyType(s__Vietnam,s__DevelopingCountry) ).

fof(kb_SUMO_7217,axiom,
    s__economyType(s__Yemen,s__DevelopingCountry) ).

fof(kb_SUMO_7218,axiom,
    s__economyType(s__Zambia,s__DevelopingCountry) ).

fof(kb_SUMO_7219,axiom,
    s__economyType(s__Zimbabwe,s__DevelopingCountry) ).

fof(kb_SUMO_7220,axiom,
    s__instance(s__MajorIndustrialEconomy,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_7221,axiom,
    s__documentation(s__MajorIndustrialEconomy,s__EnglishLanguage,'&%MajorIndustrialEconomy is an &%Attribute used to describe countries with the largest, industrialized, non-communist economies in the world.') ).

fof(kb_SUMO_7222,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__MajorIndustrialEconomy)
       => s__economyType(V__AREA,s__DevelopedCountry) ) ) ).

fof(kb_SUMO_7223,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__MajorIndustrialEconomy)
       => s__economyType(V__AREA,s__AdvancedEconomy) ) ) ).

fof(kb_SUMO_7224,axiom,
    ! [V__STATE] :
      ( s__instance(V__STATE,s__SelfConnectedObject)
     => ( s__member(V__STATE,s__GroupOf7)
       => s__attribute(V__STATE,s__MajorIndustrialEconomy) ) ) ).

fof(kb_SUMO_7225,axiom,
    s__instance(s__HighTechIndustrialEconomy,s__EconomicDevelopmentLevel) ).

fof(kb_SUMO_7226,axiom,
    s__documentation(s__HighTechIndustrialEconomy,s__EnglishLanguage,'&%HighTechIndustrialEconomy is an &%Attribute used to describe industrialized countries whose infrastructure uses the most advanced kinds of technology.') ).

fof(kb_SUMO_7227,axiom,
    s__subclass(s__EconomicSystemAttribute,s__EconomicAttribute) ).

fof(kb_SUMO_7228,axiom,
    s__documentation(s__EconomicSystemAttribute,s__EnglishLanguage,'&%EconomicSystemAttribute is the class of &%Attributes that describe the type of economic system that a country or area has. For example, &%CapitalistEconomy or &%SocialistEconomy.') ).

fof(kb_SUMO_7229,axiom,
    s__instance(s__CapitalistEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7230,axiom,
    s__instance(s__EconomicSystemAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_7231,axiom,
    s__subAttribute(s__CapitalistEconomy,s__PrivateEnterpriseEconomy) ).

fof(kb_SUMO_7232,axiom,
    s__documentation(s__CapitalistEconomy,s__EnglishLanguage,'&%CapitalistEconomy is the &%Attribute used to characterize a country whose economy is based on private ownership of the means of production and distribution, and on private accumulation of capital.') ).

fof(kb_SUMO_7233,axiom,
    s__instance(s__PureCapitalistEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7234,axiom,
    s__subAttribute(s__PureCapitalistEconomy,s__CapitalistEconomy) ).

fof(kb_SUMO_7235,axiom,
    s__contraryAttribute_2(s__PureCapitalistEconomy,s__MixedEconomy) ).

fof(kb_SUMO_7236,axiom,
    s__documentation(s__PureCapitalistEconomy,s__EnglishLanguage,'&%PureCapitalistEconomy is an &%Attribute representing a capitalist economy that has no admixture of socialism.') ).

fof(kb_SUMO_7237,axiom,
    s__instance(s__PrivateEnterpriseEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7238,axiom,
    s__subAttribute(s__PrivateEnterpriseEconomy,s__CapitalistEconomy) ).

fof(kb_SUMO_7239,axiom,
    s__documentation(s__PrivateEnterpriseEconomy,s__EnglishLanguage,'&%PrivateEnterpriseEconomy is the &%Attribute used to characterize a country in which private enterprise is the main source of economic wealth.') ).

fof(kb_SUMO_7240,axiom,
    s__instance(s__MarketEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7241,axiom,
    s__documentation(s__MarketEconomy,s__EnglishLanguage,'&%MarketEconomy is an &%Attribute that describes an economy in which market forces, specifically supply and demand, provide input for privately managed decisions about pricing and production of goods.') ).

fof(kb_SUMO_7242,axiom,
    s__instance(s__SocialistEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7243,axiom,
    s__documentation(s__SocialistEconomy,s__EnglishLanguage,'&%SocialistEconomy is the &%Attribute used to characterize a country in which there is government ownership or direction of the means of production and distribution.') ).

fof(kb_SUMO_7244,axiom,
    s__instance(s__PureSocialistEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7245,axiom,
    s__subAttribute(s__PureSocialistEconomy,s__SocialistEconomy) ).

fof(kb_SUMO_7246,axiom,
    s__contraryAttribute_2(s__PureSocialistEconomy,s__MixedEconomy) ).

fof(kb_SUMO_7247,axiom,
    s__contraryAttribute_2(s__PureSocialistEconomy,s__PureCapitalistEconomy) ).

fof(kb_SUMO_7248,axiom,
    s__documentation(s__PureSocialistEconomy,s__EnglishLanguage,'&%PureSocialistEconomy is an &%Attribute representing a socialist economy that has no admixture of capitalism.') ).

fof(kb_SUMO_7249,axiom,
    s__instance(s__DemocraticSocialism,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7250,axiom,
    s__subAttribute(s__DemocraticSocialism,s__SocialistEconomy) ).

fof(kb_SUMO_7251,axiom,
    s__documentation(s__DemocraticSocialism,s__EnglishLanguage,'&%DemocraticSocialism is an &%Attribute that describes a country in which socialism is promoted by a political party or parties within a democratic government. Under &%DemocraticSocialism, the government participates in central planning of the economy and may also manage nationalized industries.') ).

fof(kb_SUMO_7252,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__DemocraticSocialism)
       => s__governmentType(V__AREA,s__Democracy) ) ) ).

fof(kb_SUMO_7253,axiom,
    s__instance(s__MarketSocialism,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7254,axiom,
    s__subAttribute(s__MarketSocialism,s__PartialMarketEconomy) ).

fof(kb_SUMO_7255,axiom,
    s__instance(s__CommunalLandOwnershipEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7256,axiom,
    s__subAttribute(s__CommunalLandOwnershipEconomy,s__SocialistEconomy) ).

fof(kb_SUMO_7257,axiom,
    s__instance(s__MixedEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7258,axiom,
    s__documentation(s__MixedEconomy,s__EnglishLanguage,'&%MixedEconomy is the &%Attribute of a country whose economy has elements of more than one pure economic system, e.g., a market economy with government welfare for unemployed workers. A mixed-economy country may be a &%CountryInTransition, as from a prior communist economy to capitalism, but a mixed economy may also be a stable combination of different economic approaches in different areas of a national economy, e.g., nationally managed health care and education systems in an otherwise private-enterprise economy.') ).

fof(kb_SUMO_7259,axiom,
    s__instance(s__PartialMarketEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7260,axiom,
    s__subAttribute(s__PartialMarketEconomy,s__MixedEconomy) ).

fof(kb_SUMO_7261,axiom,
    s__instance(s__GovernmentRegulatedEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7262,axiom,
    s__documentation(s__GovernmentRegulatedEconomy,s__EnglishLanguage,'&%GovernmentRegulatedEconomy is an &%Attribute that describes the economy of a country in which the government determines prices, production, wages, allocation of resources, or other economic factors. An economy that is wholly government planned is a &%CentrallyPlannedEconomy.') ).

fof(kb_SUMO_7263,axiom,
    s__instance(s__CentrallyPlannedEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7264,axiom,
    s__subAttribute(s__CentrallyPlannedEconomy,s__GovernmentRegulatedEconomy) ).

fof(kb_SUMO_7265,axiom,
    s__documentation(s__CentrallyPlannedEconomy,s__EnglishLanguage,'&%CentrallyPlannedEconomy is a term used mainly to describe communist or formerly communist states, many of which are now evolving away from command economies towards market-oriented systems. Also known as a command economy.') ).

fof(kb_SUMO_7266,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( ( s__attribute(V__AREA,s__CommunistState)
          & s__instance(V__AREA,s__Nation) )
       => s__economyType(V__AREA,s__CentrallyPlannedEconomy) ) ) ).

fof(kb_SUMO_7267,axiom,
    s__instance(s__PrivatizingEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7268,axiom,
    s__subAttribute(s__PrivatizingEconomy,s__MixedEconomy) ).

fof(kb_SUMO_7269,axiom,
    s__documentation(s__PrivatizingEconomy,s__EnglishLanguage,'&%PrivatizingEconomy is an &%Attribute that describes a country in which formerly government- owned industries are being transferred into private holdings.') ).

fof(kb_SUMO_7270,axiom,
    ! [V__AREA] :
      ( s__instance(V__AREA,s__Agent)
     => ( s__attribute(V__AREA,s__PrivatizingEconomy)
       => s__economyType(V__AREA,s__CountryInTransition) ) ) ).

fof(kb_SUMO_7271,axiom,
    s__instance(s__NationalizedIndustryEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7272,axiom,
    s__subAttribute(s__NationalizedIndustryEconomy,s__GovernmentRegulatedEconomy) ).

fof(kb_SUMO_7273,axiom,
    s__documentation(s__NationalizedIndustryEconomy,s__EnglishLanguage,'&%NationalizedIndustryEconomy is an &%Attribute describing an economy in which the major industries, such as energy and transportation, are owned by the national government.') ).

fof(kb_SUMO_7274,axiom,
    s__instance(s__GovernmentSubsidizedEconomy,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7275,axiom,
    s__documentation(s__GovernmentSubsidizedEconomy,s__EnglishLanguage,'&%GovernmentSubsidizedEconomy is an &%Attribute describing an economy in which the government provides subsidies to various industries, workers, or other groups as part of its economic policy.') ).

fof(kb_SUMO_7276,axiom,
    s__instance(s__WelfareCapitalism,s__EconomicSystemAttribute) ).

fof(kb_SUMO_7277,axiom,
    s__subAttribute(s__WelfareCapitalism,s__MixedEconomy) ).

fof(kb_SUMO_7278,axiom,
    s__subAttribute(s__WelfareCapitalism,s__GovernmentSubsidizedEconomy) ).

fof(kb_SUMO_7279,axiom,
    s__documentation(s__WelfareCapitalism,s__EnglishLanguage,'&%WelfareCapitalism is an &%Attribute describing an economy in which the government provides economic subsidies to unemployed or disabled individuals.') ).

fof(kb_SUMO_7280,axiom,
    s__subclass(s__FinancialSectorAttribute,s__EconomicAttribute) ).

fof(kb_SUMO_7281,axiom,
    s__documentation(s__FinancialSectorAttribute,s__EnglishLanguage,'&%FinancialSectorAttribute is a class of &%Attributes that are used to indicate which financial sectors are most important in the economy of a &%Nation or &%GeopoliticalArea.') ).

fof(kb_SUMO_7282,axiom,
    s__instance(s__DiversifiedEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7283,axiom,
    s__instance(s__FinancialSectorAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_7284,axiom,
    s__instance(s__ManufacturingBasedEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7285,axiom,
    s__instance(s__TradeBasedEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7286,axiom,
    s__instance(s__PetroleumBasedEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7287,axiom,
    s__instance(s__TourismBasedEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7288,axiom,
    s__instance(s__ServiceBasedEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7289,axiom,
    s__instance(s__AgricultureBasedEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7290,axiom,
    s__instance(s__SubsistenceAgricultureEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7291,axiom,
    s__subAttribute(s__SubsistenceAgricultureEconomy,s__AgricultureBasedEconomy) ).

fof(kb_SUMO_7292,axiom,
    s__instance(s__TwoTierLaborMarketEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7293,axiom,
    s__instance(s__ControlledLaborMarketEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7294,axiom,
    s__instance(s__OffshoreFinancialSectorEconomy,s__FinancialSectorAttribute) ).

fof(kb_SUMO_7295,axiom,
    s__subAttribute(s__TaxHavenEconomy,s__OffshoreFinancialSectorEconomy) ).

fof(kb_SUMO_7296,axiom,
    s__subAttribute(s__OffshoreBankingSectorEconomy,s__OffshoreFinancialSectorEconomy) ).

fof(kb_SUMO_7297,axiom,
    s__instance(s__totalGDPInPeriod__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7298,axiom,
    s__instance(s__totalGDPInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7299,axiom,
    s__domain(s__totalGDPInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7300,axiom,
    s__domain(s__totalGDPInPeriod__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7301,axiom,
    s__domainSubclass(s__totalGDPInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7302,axiom,
    s__documentation(s__totalGDPInPeriod__m,s__EnglishLanguage,'(&%totalGDPInPeriod ?AREA ?AMOUNT ?PERIOD) means that the value of all final goods and services produced within the &%GeopoliticalArea ?AREA is ?AMOUNT in the period indicated by ?PERIOD, measured in U.S. dollars calculated on a purchasing power parity basis. (See &%PPPBasedEconomicValuation.) This is the Gross Domestic Product for ?AREA for a specified period.') ).

fof(kb_SUMO_7303,axiom,
    s__instance(s__totalGDP__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7304,axiom,
    s__instance(s__totalGDP__m,s__BinaryPredicate) ).

fof(kb_SUMO_7305,axiom,
    s__domain(s__totalGDP__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7306,axiom,
    s__domain(s__totalGDP__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7307,axiom,
    s__documentation(s__totalGDP__m,s__EnglishLanguage,'(&%totalGDP ?AREA ?AMOUNT) means that the value of all final goods and services produced within the &%GeopoliticalArea ?AREA is ?AMOUNT, in U.S. dollars, calculated on a purchasing power parity basis. This represents Gross Domestic Product (GDP). See &%PPPBasedEconomicValuation.') ).

%FOL fof(kb_SUMO_7308,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => (s__totalGDPInPeriod(V__AREA,V__AMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__totalGDP(V__AREA,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7309,axiom,
    s__subclass(s__PPPBasedEconomicValuation,s__Relation) ).

fof(kb_SUMO_7310,axiom,
    s__documentation(s__PPPBasedEconomicValuation,s__EnglishLanguage,'&%PPPBasedEconomicValuation is a class of relations used to state international economic information in U.S. dollar amounts. The U.S. dollar amounts are derived from Purchasing Power Parity conversions of economic totals (e.g., GDP) given in local currency. This contrasts with a method of conversion based on currency exchange rates. The PPP method is used by the CIA World Fact Book for the purpose of presenting economic data for all countries covered. Their basis for PPP dollar price weights is the UN International Comparison Program (UNICP) and the work of Professors Robert Summers and Alan Heston of the University of Pennsylvania.') ).

fof(kb_SUMO_7311,axiom,
    s__instance(s__realGrowthRateOfGDPInPeriod__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7312,axiom,
    s__instance(s__realGrowthRateOfGDPInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7313,axiom,
    s__domain(s__realGrowthRateOfGDPInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7314,axiom,
    s__domain(s__realGrowthRateOfGDPInPeriod__m,"2",s__RealNumber) ).

fof(kb_SUMO_7315,axiom,
    s__domainSubclass(s__realGrowthRateOfGDPInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7316,axiom,
    s__documentation(s__realGrowthRateOfGDPInPeriod__m,s__EnglishLanguage,'(&%realGrowthRateOfGDPInPeriod ?AREA ?RATE ?PERIOD) means that the annual rate of growth in the Gross Domestic Product (GDP) for the &%GeopoliticalArea ?AREA is the fraction ?RATE in the period ?PERIOD, adjusted for inflation, with GDP calculated on a purchasing power parity basis. See &%PPPBasedEconomicValuation.') ).

fof(kb_SUMO_7317,axiom,
    s__instance(s__realGrowthRateOfGDP__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7318,axiom,
    s__instance(s__realGrowthRateOfGDP__m,s__BinaryPredicate) ).

fof(kb_SUMO_7319,axiom,
    s__domain(s__realGrowthRateOfGDP__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7320,axiom,
    s__domain(s__realGrowthRateOfGDP__m,"2",s__RealNumber) ).

fof(kb_SUMO_7321,axiom,
    s__documentation(s__realGrowthRateOfGDP__m,s__EnglishLanguage,'(&%realGrowthRateOfGDP ?AREA ?RATE) means that the annual rate of growth in the Gross Domestic Product (GDP) for the &%GeopoliticalArea ?AREA is the fraction ?RATE, adjusted for inflation, with GDP calculated on a purchasing power parity basis. See &%PPPBasedEconomicValuation.') ).

%FOL fof(kb_SUMO_7322,axiom,(( (! [V__PERIOD,V__RATE,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__RATE,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__realGrowthRateOfGDPInPeriod(V__AREA,V__RATE,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__realGrowthRateOfGDP(V__AREA,V__RATE)')))))) ))).

fof(kb_SUMO_7323,axiom,
    s__instance(s__perCapitaGDPInPeriod__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7324,axiom,
    s__instance(s__perCapitaGDPInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7325,axiom,
    s__domain(s__perCapitaGDPInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7326,axiom,
    s__domain(s__perCapitaGDPInPeriod__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7327,axiom,
    s__domainSubclass(s__perCapitaGDPInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7328,axiom,
    s__documentation(s__perCapitaGDPInPeriod__m,s__EnglishLanguage,'(&%perCapitaGDPInPeriod ?AREA ?AMOUNT ?PERIOD) means that the Gross Domestic Product, on a per capita basis, for the &%GeopoliticalArea ?AREA is ?AMOUNT during the period indicated by ?PERIOD, calculated in U.S. dollars on a purchasing power parity basis. See &%PPPBasedEconomicValuation.') ).

fof(kb_SUMO_7329,axiom,
    s__instance(s__perCapitaGDP__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7330,axiom,
    s__instance(s__perCapitaGDP__m,s__BinaryPredicate) ).

fof(kb_SUMO_7331,axiom,
    s__domain(s__perCapitaGDP__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7332,axiom,
    s__domain(s__perCapitaGDP__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7333,axiom,
    s__documentation(s__perCapitaGDP__m,s__EnglishLanguage,'(&%perCapitaGDP ?AREA ?AMOUNT) means that the Gross Domestic Product, on a per capita basis, for the &%GeopoliticalArea ?AREA is ?AMOUNT, calculated in U.S. dollars on a purchasing power parity basis. See &%PPPBasedEconomicValuation.') ).

%FOL fof(kb_SUMO_7334,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => (s__perCapitaGDPInPeriod(V__AREA,V__AMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__perCapitaGDP(V__AREA,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7335,axiom,
    s__instance(s__sectorCompositionOfGDPInPeriod__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7336,axiom,
    s__instance(s__PPPBasedEconomicValuation__t,s__SetOrClass) ).

fof(kb_SUMO_7337,axiom,
    s__instance(s__sectorCompositionOfGDPInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7338,axiom,
    s__domain(s__sectorCompositionOfGDPInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7339,axiom,
    s__domain(s__sectorCompositionOfGDPInPeriod__m,"2",s__IndustryAttribute) ).

fof(kb_SUMO_7340,axiom,
    s__domain(s__sectorCompositionOfGDPInPeriod__m,"3",s__RealNumber) ).

fof(kb_SUMO_7341,axiom,
    s__domainSubclass(s__sectorCompositionOfGDPInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7342,axiom,
    s__documentation(s__sectorCompositionOfGDPInPeriod__m,s__EnglishLanguage,'(&%sectorCompositionOfGDPInPeriod ?AREA ?SECTOR ?FRACTION ?PERIOD) means that in the &%GeopoliticalArea ?AREA, the economic sector ?SECTOR contributes the amount ?FRACTION to the Gross National Product during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7343,axiom,
    ! [V__PERIOD,V__FRACTION,V__SECTOR,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__SECTOR,s__IndustryAttribute)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__sectorCompositionOfGDPInPeriod(V__AREA,V__SECTOR,V__FRACTION,V__PERIOD)
       => lesseq(V__FRACTION,"1.0") ) ) ).

fof(kb_SUMO_7344,axiom,
    s__instance(s__sectorCompositionOfGDP__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7345,axiom,
    s__instance(s__sectorCompositionOfGDP__m,s__TernaryPredicate) ).

fof(kb_SUMO_7346,axiom,
    s__domain(s__sectorCompositionOfGDP__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7347,axiom,
    s__domain(s__sectorCompositionOfGDP__m,"2",s__IndustryAttribute) ).

fof(kb_SUMO_7348,axiom,
    s__domain(s__sectorCompositionOfGDP__m,"3",s__RealNumber) ).

fof(kb_SUMO_7349,axiom,
    s__documentation(s__sectorCompositionOfGDP__m,s__EnglishLanguage,'(&%sectorCompositionOfGDP ?AREA ?SECTOR ?FRACTION) means that in the &%GeopoliticalArea ?AREA, the economic sector ?SECTOR contributes the amount ?FRACTION to the Gross National Product.') ).

fof(kb_SUMO_7350,axiom,
    ! [V__FRACTION,V__SECTOR,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__SECTOR,s__IndustryAttribute)
        & s__instance(V__FRACTION,s__RealNumber) )
     => ( s__sectorCompositionOfGDP(V__AREA,V__SECTOR,V__FRACTION)
       => lesseq(V__FRACTION,"1.0") ) ) ).

%FOL fof(kb_SUMO_7351,axiom,(( (! [V__AMOUNT,V__PERIOD,V__SECTOR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__SECTOR,s__IndustryAttribute) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__RealNumber)) => (s__sectorCompositionOfGDPInPeriod(V__AREA,V__SECTOR,V__AMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__sectorCompositionOfGDP(V__AREA,V__SECTOR,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7352,axiom,
    s__instance(s__sectorValueOfGDPInPeriod__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7353,axiom,
    s__instance(s__sectorValueOfGDPInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7354,axiom,
    s__domain(s__sectorValueOfGDPInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7355,axiom,
    s__domain(s__sectorValueOfGDPInPeriod__m,"2",s__IndustryAttribute) ).

fof(kb_SUMO_7356,axiom,
    s__domain(s__sectorValueOfGDPInPeriod__m,"3",s__CurrencyMeasure) ).

fof(kb_SUMO_7357,axiom,
    s__domainSubclass(s__sectorValueOfGDPInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7358,axiom,
    s__documentation(s__sectorValueOfGDPInPeriod__m,s__EnglishLanguage,'(&%sectorValueOfGDPInPeriod ?AREA ?SECTOR ?AMOUNT ?PERIOD) means that for the &%GeopoliticalArea ?AREA, the economic sector ?SECTOR contributes ?AMOUNT to the Gross National Product during the &%TimeInterval indicated by ?PERIOD, evaluated in U.S. dollars on a purchasing power parity basis. See &%PPPBasedEconomicValuation.') ).

fof(kb_SUMO_7359,axiom,
    ! [V__AMOUNT,V__PERIOD,V__GDPAMOUNT,V__FRACTION,V__SECTOR,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__SECTOR,s__IndustryAttribute)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__instance(V__GDPAMOUNT,s__CurrencyMeasure)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass)
        & s__instance(V__AMOUNT,s__CurrencyMeasure) )
     => ( ( s__sectorCompositionOfGDPInPeriod(V__AREA,V__SECTOR,V__FRACTION,V__PERIOD)
          & s__totalGDPInPeriod(V__AREA,V__GDPAMOUNT,V__PERIOD)
          & V__AMOUNT = times(V__FRACTION,V__GDPAMOUNT) )
       => s__sectorValueOfGDPInPeriod(V__AREA,V__SECTOR,V__AMOUNT,V__PERIOD) ) ) ).

fof(kb_SUMO_7360,axiom,
    s__instance(s__sectorValueOfGDP__m,s__PPPBasedEconomicValuation) ).

fof(kb_SUMO_7361,axiom,
    s__instance(s__sectorValueOfGDP__m,s__TernaryPredicate) ).

fof(kb_SUMO_7362,axiom,
    s__domain(s__sectorValueOfGDP__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7363,axiom,
    s__domain(s__sectorValueOfGDP__m,"2",s__IndustryAttribute) ).

fof(kb_SUMO_7364,axiom,
    s__domain(s__sectorValueOfGDP__m,"3",s__CurrencyMeasure) ).

fof(kb_SUMO_7365,axiom,
    s__documentation(s__sectorValueOfGDP__m,s__EnglishLanguage,'(&%sectorValueOfGDP ?AREA ?SECTOR ?AMOUNT) means that for the &%GeopoliticalArea ?AREA, the economic sector ?SECTOR contributes ?AMOUNT to the Gross National Product, evaluated in U.S. dollars on a purchasing power parity basis. See &%PPPBasedEconomicValuation.') ).

%FOL fof(kb_SUMO_7366,axiom,(( (! [V__AMOUNT,V__PERIOD,V__SECTOR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__SECTOR,s__IndustryAttribute) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => (s__sectorValueOfGDPInPeriod(V__AREA,V__SECTOR,V__AMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__sectorValueOfGDP(V__AREA,V__SECTOR,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7367,axiom,
    s__instance(s__AgriculturalSector,s__IndustryAttribute) ).

fof(kb_SUMO_7368,axiom,
    s__instance(s__IndustrialSector,s__IndustryAttribute) ).

fof(kb_SUMO_7369,axiom,
    s__instance(s__ServiceSector,s__IndustryAttribute) ).

fof(kb_SUMO_7370,axiom,
    s__subAttribute(s__AgricultureForestryFishingAndHunting,s__AgriculturalSector) ).

fof(kb_SUMO_7371,axiom,
    s__instance(s__populationFractionBelowPovertyLineInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7372,axiom,
    s__domain(s__populationFractionBelowPovertyLineInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7373,axiom,
    s__domain(s__populationFractionBelowPovertyLineInPeriod__m,"2",s__RealNumber) ).

fof(kb_SUMO_7374,axiom,
    s__domainSubclass(s__populationFractionBelowPovertyLineInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7375,axiom,
    s__documentation(s__populationFractionBelowPovertyLineInPeriod__m,s__EnglishLanguage,'(&%populationFractionBelowPovertyLineInPeriod ?AREA ?FRACTION ?PERIOD) means that in the &%GeopoliticalArea ?AREA, the segment of the population living below the (locally defined) poverty line is ?FRACTION during the &%TimeInterval indicated by ?PERIOD. Note that the definition of the poverty line varies internationally.') ).

fof(kb_SUMO_7376,axiom,
    ! [V__PERIOD,V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__populationFractionBelowPovertyLineInPeriod(V__AREA,V__FRACTION,V__PERIOD)
       => lesseq(V__FRACTION,"1.0") ) ) ).

fof(kb_SUMO_7377,axiom,
    s__instance(s__populationFractionBelowPovertyLine__m,s__BinaryPredicate) ).

fof(kb_SUMO_7378,axiom,
    s__domain(s__populationFractionBelowPovertyLine__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7379,axiom,
    s__domain(s__populationFractionBelowPovertyLine__m,"2",s__RealNumber) ).

fof(kb_SUMO_7380,axiom,
    s__documentation(s__populationFractionBelowPovertyLine__m,s__EnglishLanguage,'(&%populationFractionBelowPovertyLine ?AREA ?FRACTION) means that in the &%GeopoliticalArea ?AREA, the segment of the population living below the (locally defined) poverty line is ?FRACTION. Note that the definition of the poverty line varies internationally.') ).

fof(kb_SUMO_7381,axiom,
    ! [V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber) )
     => ( s__populationFractionBelowPovertyLine(V__AREA,V__FRACTION)
       => lesseq(V__FRACTION,"1.0") ) ) ).

%FOL fof(kb_SUMO_7382,axiom,(( (! [V__PERIOD,V__FRACTION,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__FRACTION,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__populationFractionBelowPovertyLineInPeriod(V__AREA,V__FRACTION,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__populationFractionBelowPovertyLine(V__AREA,V__FRACTION)')))))) ))).

fof(kb_SUMO_7383,axiom,
    s__instance(s__lowestDecileShareOfHouseholdIncomeInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7384,axiom,
    s__domain(s__lowestDecileShareOfHouseholdIncomeInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7385,axiom,
    s__domain(s__lowestDecileShareOfHouseholdIncomeInPeriod__m,"2",s__RealNumber) ).

fof(kb_SUMO_7386,axiom,
    s__domainSubclass(s__lowestDecileShareOfHouseholdIncomeInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7387,axiom,
    s__documentation(s__lowestDecileShareOfHouseholdIncomeInPeriod__m,s__EnglishLanguage,'(&%lowestDecileShareOfHouseholdIncomeInPeriod ?AREA ?FRACTION ?PERIOD) means that in the &%GeopoliticalArea ?AREA, the lowest decile (0-10%) of households with respect to household income (or consumption) had ?FRACTION amount of the total household income (or consumption), during the &%TimeInterval indicated by ?PERIOD. Data from different countries may not be directly comparable due to variation in the basis of the data (e.g., based on household income versus based on household consumption).') ).

fof(kb_SUMO_7388,axiom,
    ! [V__PERIOD,V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__lowestDecileShareOfHouseholdIncomeInPeriod(V__AREA,V__FRACTION,V__PERIOD)
       => lesseq(V__FRACTION,"1.0") ) ) ).

fof(kb_SUMO_7389,axiom,
    s__instance(s__lowestDecileShareOfHouseholdIncome__m,s__BinaryPredicate) ).

fof(kb_SUMO_7390,axiom,
    s__domain(s__lowestDecileShareOfHouseholdIncome__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7391,axiom,
    s__domain(s__lowestDecileShareOfHouseholdIncome__m,"2",s__RealNumber) ).

fof(kb_SUMO_7392,axiom,
    s__documentation(s__lowestDecileShareOfHouseholdIncome__m,s__EnglishLanguage,'(&%lowestDecileShareOfHouseholdIncome ?AREA ?FRACTION) means that in the &%GeopoliticalArea ?AREA, the lowest decile (0-10%) of households with respect to household income (or consumption) had ?FRACTION amount of the total household income (or consumption). Data from different countries may not be directly comparable due to variation in the basis of the data (e.g., based on income versus based on consumption).') ).

fof(kb_SUMO_7393,axiom,
    ! [V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber) )
     => ( s__lowestDecileShareOfHouseholdIncome(V__AREA,V__FRACTION)
       => lesseq(V__FRACTION,"1.0") ) ) ).

%FOL fof(kb_SUMO_7394,axiom,(( (! [V__PERIOD,V__FRACTION,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__FRACTION,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__lowestDecileShareOfHouseholdIncomeInPeriod(V__AREA,V__FRACTION,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__lowestDecileShareOfHouseholdIncome(V__AREA,V__FRACTION)')))))) ))).

fof(kb_SUMO_7395,axiom,
    s__instance(s__highestDecileShareOfHouseholdIncomeInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7396,axiom,
    s__domain(s__highestDecileShareOfHouseholdIncomeInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7397,axiom,
    s__domain(s__highestDecileShareOfHouseholdIncomeInPeriod__m,"2",s__RealNumber) ).

fof(kb_SUMO_7398,axiom,
    s__domainSubclass(s__highestDecileShareOfHouseholdIncomeInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7399,axiom,
    s__documentation(s__highestDecileShareOfHouseholdIncomeInPeriod__m,s__EnglishLanguage,'(&%highestDecileShareOfHouseholdIncomeInPeriod ?AREA ?FRACTION ?PERIOD) means that in the &%GeopoliticalArea ?AREA, the highest decile (90-100%) of households with respect to household income (or consumption) had ?FRACTION amount of the total household income (or consumption), during the &%TimeInterval indicated by ?PERIOD. Data from different countries may not be directly comparable due to variation in the basis of the data (e.g., based on household income versus based on household consumption).') ).

fof(kb_SUMO_7400,axiom,
    ! [V__PERIOD,V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__highestDecileShareOfHouseholdIncomeInPeriod(V__AREA,V__FRACTION,V__PERIOD)
       => lesseq(V__FRACTION,"1.0") ) ) ).

fof(kb_SUMO_7401,axiom,
    s__instance(s__highestDecileShareOfHouseholdIncome__m,s__BinaryPredicate) ).

fof(kb_SUMO_7402,axiom,
    s__domain(s__highestDecileShareOfHouseholdIncome__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7403,axiom,
    s__domain(s__highestDecileShareOfHouseholdIncome__m,"2",s__RealNumber) ).

fof(kb_SUMO_7404,axiom,
    s__documentation(s__highestDecileShareOfHouseholdIncome__m,s__EnglishLanguage,'(&%highestDecileShareOfHouseholdIncome ?AREA ?FRACTION) means that in the &%GeopoliticalArea ?AREA, the highest decile (90-100%) of households with respect to household income (or consumption) had ?FRACTION amount of the total household income (or consumption). Data from different countries may not be directly comparable due to variation in the basis of the data (e.g., based on income versus based on consumption).') ).

fof(kb_SUMO_7405,axiom,
    ! [V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber) )
     => ( s__highestDecileShareOfHouseholdIncome(V__AREA,V__FRACTION)
       => lesseq(V__FRACTION,"1.0") ) ) ).

%FOL fof(kb_SUMO_7406,axiom,(( (! [V__PERIOD,V__FRACTION,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__FRACTION,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__PERIOD,s__TimePosition)) => (s__highestDecileShareOfHouseholdIncomeInPeriod(V__AREA,V__FRACTION,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__PERIOD,'s__highestDecileShareOfHouseholdIncome(V__AREA,V__FRACTION)')))))) ))).

fof(kb_SUMO_7407,axiom,
    s__instance(s__incomeDistributionByGiniIndexInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7408,axiom,
    s__domain(s__incomeDistributionByGiniIndexInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7409,axiom,
    s__domain(s__incomeDistributionByGiniIndexInPeriod__m,"2",s__NonnegativeRealNumber) ).

fof(kb_SUMO_7410,axiom,
    s__domainSubclass(s__incomeDistributionByGiniIndexInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7411,axiom,
    s__documentation(s__incomeDistributionByGiniIndexInPeriod__m,s__EnglishLanguage,'(&%incomeDistributionByGiniIndexInPeriod ?AREA ?INDEX ?PERIOD) means that in the &%GeopoliticalArea ?AREA, the distribution of family income is ?INDEX, as measured by the Gini index, during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7412,axiom,
    ! [V__PERIOD,V__INDEX,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__INDEX,s__NonnegativeRealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__incomeDistributionByGiniIndexInPeriod(V__AREA,V__INDEX,V__PERIOD)
       => lesseq(V__INDEX,"100") ) ) ).

fof(kb_SUMO_7413,axiom,
    s__instance(s__incomeDistributionByGiniIndex__m,s__BinaryPredicate) ).

fof(kb_SUMO_7414,axiom,
    s__domain(s__incomeDistributionByGiniIndex__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7415,axiom,
    s__domain(s__incomeDistributionByGiniIndex__m,"2",s__NonnegativeRealNumber) ).

fof(kb_SUMO_7416,axiom,
    s__documentation(s__incomeDistributionByGiniIndex__m,s__EnglishLanguage,'(&%incomeDistributionByGiniIndex ?AREA ?INDEX) means that in the &%GeopoliticalArea ?AREA, the distribution of family income is ?INDEX, as measured by the Gini index for family income distribution.') ).

fof(kb_SUMO_7417,axiom,
    ! [V__INDEX,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__INDEX,s__NonnegativeRealNumber) )
     => ( s__incomeDistributionByGiniIndex(V__AREA,V__INDEX)
       => lesseq(V__INDEX,"100") ) ) ).

%FOL fof(kb_SUMO_7418,axiom,(( (! [V__PERIOD,V__INDEX,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__INDEX,s__NonnegativeRealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__incomeDistributionByGiniIndexInPeriod(V__AREA,V__INDEX,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__incomeDistributionByGiniIndex(V__AREA,V__INDEX)')))))) ))).

fof(kb_SUMO_7419,axiom,
    s__instance(s__inflationRateOfConsumerPricesInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7420,axiom,
    s__domain(s__inflationRateOfConsumerPricesInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7421,axiom,
    s__domain(s__inflationRateOfConsumerPricesInPeriod__m,"2",s__RealNumber) ).

fof(kb_SUMO_7422,axiom,
    s__domainSubclass(s__inflationRateOfConsumerPricesInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7423,axiom,
    s__documentation(s__inflationRateOfConsumerPricesInPeriod__m,s__EnglishLanguage,'(&%inflationRateOfConsumerPricesInPeriod ?AREA ?FRACTION ?PERIOD) means that in the &%GeopoliticalArea ?AREA, the annual change in consumer prices was ?FRACTION, for the &%TimeInterval indicated by ?PERIOD, compared with prices from the prior period.') ).

fof(kb_SUMO_7424,axiom,
    ! [V__PERIOD,V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__inflationRateOfConsumerPricesInPeriod(V__AREA,V__FRACTION,V__PERIOD)
       => lesseq(V__FRACTION,"1.0") ) ) ).

fof(kb_SUMO_7425,axiom,
    s__instance(s__inflationRateOfConsumerPrices__m,s__BinaryPredicate) ).

fof(kb_SUMO_7426,axiom,
    s__domain(s__inflationRateOfConsumerPrices__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7427,axiom,
    s__domain(s__inflationRateOfConsumerPrices__m,"2",s__RealNumber) ).

fof(kb_SUMO_7428,axiom,
    s__documentation(s__inflationRateOfConsumerPrices__m,s__EnglishLanguage,'(&%inflationRateOfConsumerPrices ?AREA ?FRACTION) means that in the &%GeopoliticalArea ?AREA, the annual change in consumer prices was ?FRACTION, compared with prices from the previous year.') ).

fof(kb_SUMO_7429,axiom,
    ! [V__FRACTION,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__FRACTION,s__RealNumber) )
     => ( s__inflationRateOfConsumerPrices(V__AREA,V__FRACTION)
       => lesseq(V__FRACTION,"1.0") ) ) ).

%FOL fof(kb_SUMO_7430,axiom,(( (! [V__PERIOD,V__FRACTION,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__FRACTION,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__inflationRateOfConsumerPricesInPeriod(V__AREA,V__FRACTION,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__inflationRateOfConsumerPrices(V__AREA,V__FRACTION)')))))) ))).

fof(kb_SUMO_7431,axiom,
    s__instance(s__laborForceTotalInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7432,axiom,
    s__domain(s__laborForceTotalInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7433,axiom,
    s__domain(s__laborForceTotalInPeriod__m,"2",s__NonnegativeRealNumber) ).

fof(kb_SUMO_7434,axiom,
    s__domainSubclass(s__laborForceTotalInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7435,axiom,
    s__documentation(s__laborForceTotalInPeriod__m,s__EnglishLanguage,'(&%laborForceTotalInPeriod ?AREA ?AMOUNT ?PERIOD) means that the total labor force of the &%GeopoliticalArea ?AREA is ?AMOUNT during the &%TimeInterval indicated by ?PERIOD. This includes unemployed workers.') ).

fof(kb_SUMO_7436,axiom,
    s__instance(s__laborForceTotal__m,s__BinaryPredicate) ).

fof(kb_SUMO_7437,axiom,
    s__domain(s__laborForceTotal__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7438,axiom,
    s__domain(s__laborForceTotal__m,"2",s__NonnegativeRealNumber) ).

fof(kb_SUMO_7439,axiom,
    s__documentation(s__laborForceTotal__m,s__EnglishLanguage,'(&%laborForceTotal ?AREA ?AMOUNT) means that the total labor force of the &%GeopoliticalArea ?AREA is ?AMOUNT. This includes unemployed workers.') ).

%FOL fof(kb_SUMO_7440,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__NonnegativeRealNumber)) => (s__laborForceTotalInPeriod(V__AREA,V__AMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__laborForceTotal(V__AREA,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7441,axiom,
    s__instance(s__laborForceFractionByOccupationInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7442,axiom,
    s__domain(s__laborForceFractionByOccupationInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7443,axiom,
    s__domain(s__laborForceFractionByOccupationInPeriod__m,"2",s__Attribute) ).

fof(kb_SUMO_7444,axiom,
    s__domain(s__laborForceFractionByOccupationInPeriod__m,"3",s__RealNumber) ).

fof(kb_SUMO_7445,axiom,
    s__domainSubclass(s__laborForceFractionByOccupationInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7446,axiom,
    s__documentation(s__laborForceFractionByOccupationInPeriod__m,s__EnglishLanguage,'(&%laborForceFractionByOccupationInPeriod ?AREA ?SECTOR ?FRACTION ?PERIOD) means that in the &%GeopoliticalArea ?AREA, workers in the job area ?SECTOR make up ?FRACTION of the labor force, during the &%TimeInterval indicated by ?PERIOD. The unemployed are not included in these figures. Occupation may be indicated by an &%OccupationalRole or an &%IndustryAttribute.') ).

fof(kb_SUMO_7447,axiom,
    ! [V__PERIOD,V__FRACTION,V__SECTOR,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__SECTOR,s__Attribute)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__laborForceFractionByOccupationInPeriod(V__AREA,V__SECTOR,V__FRACTION,V__PERIOD)
       => lesseq(V__FRACTION,"1.0") ) ) ).

fof(kb_SUMO_7448,axiom,
    s__instance(s__laborForceFractionByOccupation__m,s__TernaryPredicate) ).

fof(kb_SUMO_7449,axiom,
    s__domain(s__laborForceFractionByOccupation__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7450,axiom,
    s__domain(s__laborForceFractionByOccupation__m,"2",s__Attribute) ).

fof(kb_SUMO_7451,axiom,
    s__domain(s__laborForceFractionByOccupation__m,"3",s__RealNumber) ).

fof(kb_SUMO_7452,axiom,
    s__documentation(s__laborForceFractionByOccupation__m,s__EnglishLanguage,'(&%laborForceFractionByOccupation ?AREA ?SECTOR ?FRACTION) means that in the &%GeopoliticalArea ?AREA, workers in the job area ?SECTOR make up ?FRACTION of the labor force. The unemployed are not included in these figures. Occupation may be indicated by an &%OccupationalRole or an &%IndustryAttribute.') ).

fof(kb_SUMO_7453,axiom,
    ! [V__FRACTION,V__SECTOR,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__SECTOR,s__Attribute)
        & s__instance(V__FRACTION,s__RealNumber) )
     => ( s__laborForceFractionByOccupation(V__AREA,V__SECTOR,V__FRACTION)
       => lesseq(V__FRACTION,"1.0") ) ) ).

%FOL fof(kb_SUMO_7454,axiom,(( (! [V__PERIOD,V__FRACTION,V__SECTOR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__SECTOR,s__Attribute) & s__instance(V__FRACTION,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__laborForceFractionByOccupationInPeriod(V__AREA,V__SECTOR,V__FRACTION,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__laborForceFractionByOccupation(V__AREA,V__SECTOR,V__FRACTION)')))))) ))).

fof(kb_SUMO_7455,axiom,
    s__instance(s__unemploymentRateOfAreaInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7456,axiom,
    s__domain(s__unemploymentRateOfAreaInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7457,axiom,
    s__domain(s__unemploymentRateOfAreaInPeriod__m,"2",s__RealNumber) ).

fof(kb_SUMO_7458,axiom,
    s__domainSubclass(s__unemploymentRateOfAreaInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7459,axiom,
    s__documentation(s__unemploymentRateOfAreaInPeriod__m,s__EnglishLanguage,'(&%unemploymentRateOfAreaInPeriod ?AREA ?RATE ?PERIOD) means that the unemployment rate in the &%GeographicalArea ?AREA is ?RATE, during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7460,axiom,
    ! [V__PERIOD,V__RATE,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__RATE,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__unemploymentRateOfAreaInPeriod(V__AREA,V__RATE,V__PERIOD)
       => lesseq(V__RATE,"1.0") ) ) ).

fof(kb_SUMO_7461,axiom,
    s__instance(s__unemploymentRateOfArea__m,s__BinaryPredicate) ).

fof(kb_SUMO_7462,axiom,
    s__domain(s__unemploymentRateOfArea__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7463,axiom,
    s__domain(s__unemploymentRateOfArea__m,"2",s__RealNumber) ).

fof(kb_SUMO_7464,axiom,
    s__documentation(s__unemploymentRateOfArea__m,s__EnglishLanguage,'(&%unemploymentRateOfArea ?AREA ?RATE) means that the unemployment rate in the &%GeographicalArea ?AREA is ?RATE.') ).

fof(kb_SUMO_7465,axiom,
    ! [V__RATE,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__RATE,s__RealNumber) )
     => ( s__unemploymentRateOfArea(V__AREA,V__RATE)
       => lesseq(V__RATE,"1.0") ) ) ).

%FOL fof(kb_SUMO_7466,axiom,(( (! [V__PERIOD,V__RATE,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__RATE,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__unemploymentRateOfAreaInPeriod(V__AREA,V__RATE,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__unemploymentRateOfArea(V__AREA,V__RATE)')))))) ))).

fof(kb_SUMO_7467,axiom,
    s__instance(s__annualRevenuesOfAreaInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7468,axiom,
    s__domain(s__annualRevenuesOfAreaInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7469,axiom,
    s__domain(s__annualRevenuesOfAreaInPeriod__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7470,axiom,
    s__domainSubclass(s__annualRevenuesOfAreaInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7471,axiom,
    s__documentation(s__annualRevenuesOfAreaInPeriod__m,s__EnglishLanguage,'(&%annualRevenuesOfAreaInPeriod ?AREA ?AMOUNT ?PERIOD) means that the annual budgetary revenues of the &%GeopoliticalArea ?AREA are ?AMOUNT for the annual &%TimeInterval indicated by ?PERIOD, calculated in U.S. dollars according to the currency exchange rate method.') ).

fof(kb_SUMO_7472,axiom,
    s__instance(s__annualRevenuesOfArea__m,s__BinaryPredicate) ).

fof(kb_SUMO_7473,axiom,
    s__domain(s__annualRevenuesOfArea__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7474,axiom,
    s__domain(s__annualRevenuesOfArea__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7475,axiom,
    s__documentation(s__annualRevenuesOfArea__m,s__EnglishLanguage,'(&%annualRevenuesOfArea ?AREA ?AMOUNT) means that the annual budgetary revenues of the &%GeopoliticalArea ?AREA are ?AMOUNT, calculated in U.S. dollars according to the currency exchange rate method.') ).

%FOL fof(kb_SUMO_7476,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => (s__annualRevenuesOfAreaInPeriod(V__AREA,V__AMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__annualRevenuesOfArea(V__AREA,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7477,axiom,
    s__instance(s__annualExpendituresOfAreaInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7478,axiom,
    s__domain(s__annualExpendituresOfAreaInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7479,axiom,
    s__domain(s__annualExpendituresOfAreaInPeriod__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7480,axiom,
    s__domainSubclass(s__annualExpendituresOfAreaInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7481,axiom,
    s__documentation(s__annualExpendituresOfAreaInPeriod__m,s__EnglishLanguage,'(&%annualExpendituresOfAreaInPeriod ?AREA ?AMOUNT ?PERIOD) means that the annual budgetary expenditures of the &%GeopoliticalArea ?AREA are ?AMOUNT for the annual &%TimeInterval indicated by ?PERIOD, calculated in U.S. dollars according to the currency exchange rate method.') ).

fof(kb_SUMO_7482,axiom,
    s__instance(s__annualExpendituresOfArea__m,s__BinaryPredicate) ).

fof(kb_SUMO_7483,axiom,
    s__domain(s__annualExpendituresOfArea__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7484,axiom,
    s__domain(s__annualExpendituresOfArea__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7485,axiom,
    s__documentation(s__annualExpendituresOfArea__m,s__EnglishLanguage,'(&%annualExpendituresOfArea ?AREA ?AMOUNT) means that the annual budgetary expenditures of the &%GeopoliticalArea ?AREA are ?AMOUNT, calculated in U.S. dollars according to the currency exchange rate method.') ).

%FOL fof(kb_SUMO_7486,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => (s__annualExpendituresOfAreaInPeriod(V__AREA,V__AMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__annualExpendituresOfArea(V__AREA,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7487,axiom,
    s__instance(s__capitalExpendituresOfAreaInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7488,axiom,
    s__domain(s__capitalExpendituresOfAreaInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7489,axiom,
    s__domain(s__capitalExpendituresOfAreaInPeriod__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7490,axiom,
    s__domainSubclass(s__capitalExpendituresOfAreaInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7491,axiom,
    s__documentation(s__capitalExpendituresOfAreaInPeriod__m,s__EnglishLanguage,'(&%capitalExpendituresOfAreaInPeriod ?AREA ?AMOUNT ?PERIOD) means that the annual capital expenditures of the &%GeopoliticalArea ?AREA are ?AMOUNT for the annual &%TimeInterval indicated by ?PERIOD, calculated in U.S. dollars according to the currency exchange rate method. This figure is a portion of the &%annualExpendituresOfArea for ?AREA in ?PERIOD.') ).

fof(kb_SUMO_7492,axiom,
    ! [V__PERIOD,V__CAPAMOUNT,V__TOTALAMOUNT,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__TOTALAMOUNT,s__CurrencyMeasure)
        & s__instance(V__CAPAMOUNT,s__CurrencyMeasure)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( ( s__capitalExpendituresOfAreaInPeriod(V__AREA,V__CAPAMOUNT,V__PERIOD)
          & s__annualExpendituresOfAreaInPeriod(V__AREA,V__TOTALAMOUNT,V__PERIOD) )
       => greater(V__TOTALAMOUNT,V__CAPAMOUNT) ) ) ).

fof(kb_SUMO_7493,axiom,
    s__instance(s__capitalExpendituresOfArea__m,s__BinaryPredicate) ).

fof(kb_SUMO_7494,axiom,
    s__domain(s__capitalExpendituresOfArea__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7495,axiom,
    s__domain(s__capitalExpendituresOfArea__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7496,axiom,
    s__documentation(s__capitalExpendituresOfArea__m,s__EnglishLanguage,'(&%capitalExpendituresOfArea ?AREA ?AMOUNT) means that the annual capital expenditures of the &%GeopoliticalArea ?AREA are ?AMOUNT, calculated in U.S. dollars according to the currency exchange rate method. This figure is a portion of the &%annualExpendituresOfArea for ?AREA.') ).

%FOL fof(kb_SUMO_7497,axiom,(( (! [V__TIME,V__CAPAMOUNT,V__TOTALAMOUNT,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__TOTALAMOUNT,s__CurrencyMeasure) & s__instance(V__CAPAMOUNT,s__CurrencyMeasure) & s__instance(V__TIME,s__TimePosition)) => ((s__holdsDuring(V__TIME,'s__capitalExpendituresOfArea(V__AREA,V__CAPAMOUNT)') & s__holdsDuring(V__TIME,'s__annualExpendituresOfArea(V__AREA,V__TOTALAMOUNT)')) => greater(V__TOTALAMOUNT,V__CAPAMOUNT)))) ))).

%FOL fof(kb_SUMO_7498,axiom,(( (! [V__AMOUNT,V__PERIOD,V__CAPAMOUNT,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__CAPAMOUNT,s__CurrencyMeasure) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => (s__capitalExpendituresOfAreaInPeriod(V__AREA,V__CAPAMOUNT,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__capitalExpendituresOfArea(V__AREA,V__AMOUNT)')))))) ))).

fof(kb_SUMO_7499,axiom,
    s__instance(s__industryOfArea__m,s__BinaryPredicate) ).

fof(kb_SUMO_7500,axiom,
    s__domain(s__industryOfArea__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7501,axiom,
    s__domain(s__industryOfArea__m,"2",s__IndustryAttribute) ).

fof(kb_SUMO_7502,axiom,
    s__documentation(s__industryOfArea__m,s__EnglishLanguage,'(&%industryOfArea ?AREA ?SECTOR) means that the &%GeopoliticalArea ?AREA produces goods or services in the economic area ?SECTOR.') ).

fof(kb_SUMO_7503,axiom,
    s__instance(s__industryRankByOutput__m,s__TernaryPredicate) ).

fof(kb_SUMO_7504,axiom,
    s__domain(s__industryRankByOutput__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7505,axiom,
    s__domain(s__industryRankByOutput__m,"2",s__IndustryAttribute) ).

fof(kb_SUMO_7506,axiom,
    s__domain(s__industryRankByOutput__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7507,axiom,
    s__documentation(s__industryRankByOutput__m,s__EnglishLanguage,'(&%industryRankByOutput ?AREA ?SECTOR ?NTH) means that in the &%GeopoliticalArea ?AREA, the economic area ?SECTOR is ?NTH with respect to the value of its annual output.') ).

fof(kb_SUMO_7508,axiom,
    ! [V__SECTOR,V__AREA,V__NTH] :
      ( ( s__instance(V__NTH,s__PositiveInteger)
        & s__instance(V__AREA,s__GeopoliticalArea)
        & s__instance(V__SECTOR,s__IndustryAttribute) )
     => ( s__industryRankByOutput(V__AREA,V__SECTOR,V__NTH)
       => s__industryOfArea(V__AREA,V__SECTOR) ) ) ).

fof(kb_SUMO_7509,axiom,
    s__instance(s__industryProductType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7510,axiom,
    s__domain(s__industryProductType__m,"1",s__IndustryAttribute) ).

fof(kb_SUMO_7511,axiom,
    s__domainSubclass(s__industryProductType__m,"2",s__Object) ).

fof(kb_SUMO_7512,axiom,
    s__documentation(s__industryProductType__m,s__EnglishLanguage,'(&%industryProductType ?INDUSTRY ?TYPE) means that organizations with the &%IndustryAttribute ?INDUSTRY produce products of the kind ?TYPE.') ).

fof(kb_SUMO_7513,axiom,
    ! [V__INDUSTRY,V__ORG,V__TYPE] :
      ( ( s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__instance(V__ORG,s__Agent)
        & s__instance(V__INDUSTRY,s__IndustryAttribute) )
     => ( ( s__instance(V__ORG,s__Organization)
          & s__attribute(V__ORG,V__INDUSTRY)
          & s__industryProductType(V__INDUSTRY,V__TYPE) )
       => ? [V__EVENT,V__ITEM] :
            ( s__instance(V__EVENT,s__Process)
            & s__instance(V__EVENT,s__Making)
            & s__instance(V__ITEM,V__TYPE)
            & s__agent(V__EVENT,V__ORG)
            & s__result(V__EVENT,V__ITEM) ) ) ) ).

fof(kb_SUMO_7514,axiom,
    s__instance(s__organizationProductType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7515,axiom,
    s__domain(s__organizationProductType__m,"1",s__Organization) ).

fof(kb_SUMO_7516,axiom,
    s__domainSubclass(s__organizationProductType__m,"2",s__Object) ).

fof(kb_SUMO_7517,axiom,
    s__documentation(s__organizationProductType__m,s__EnglishLanguage,'(&%organizationProductType ?BUSINESS ?TYPE) means that the &%Organization ?BUSINESS produces products of the kind ?TYPE.') ).

fof(kb_SUMO_7518,axiom,
    ! [V__GENUS,V__TYPE,V__BUSINESS] :
      ( ( s__instance(V__BUSINESS,s__Organization)
        & s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__subclass(V__GENUS,s__Object)
        & s__instance(V__GENUS,s__SetOrClass) )
     => ( ( s__organizationProductType(V__BUSINESS,V__TYPE)
          & s__subclass(V__TYPE,V__GENUS) )
       => s__organizationProductType(V__BUSINESS,V__GENUS) ) ) ).

fof(kb_SUMO_7519,axiom,
    ! [V__INDUSTRY,V__TYPE,V__BUSINESS] :
      ( ( s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass) )
     => ( ( s__industryProductType(V__INDUSTRY,V__TYPE)
          & s__instance(V__INDUSTRY,s__IndustryAttribute)
          & s__instance(V__BUSINESS,s__Organization)
          & s__attribute(V__BUSINESS,V__INDUSTRY) )
       => s__organizationProductType(V__BUSINESS,V__TYPE) ) ) ).

fof(kb_SUMO_7520,axiom,
    s__instance(s__industryServiceType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7521,axiom,
    s__domain(s__industryServiceType__m,"1",s__IndustryAttribute) ).

fof(kb_SUMO_7522,axiom,
    s__domainSubclass(s__industryServiceType__m,"2",s__IntentionalProcess) ).

fof(kb_SUMO_7523,axiom,
    s__documentation(s__industryServiceType__m,s__EnglishLanguage,'(&%industryServiceType ?INDUSTRY ?TYPE) means that organizations with the &%IndustryAttribute ?INDUSTRY provide services of the kind ?TYPE.') ).

fof(kb_SUMO_7524,axiom,
    ! [V__INDUSTRY,V__ORG,V__TYPE] :
      ( ( s__subclass(V__TYPE,s__IntentionalProcess)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__instance(V__ORG,s__Agent)
        & s__instance(V__INDUSTRY,s__IndustryAttribute) )
     => ( ( s__instance(V__ORG,s__Organization)
          & s__attribute(V__ORG,V__INDUSTRY)
          & s__industryServiceType(V__INDUSTRY,V__TYPE) )
       => ? [V__EVENT] :
            ( s__instance(V__EVENT,s__Process)
            & s__instance(V__EVENT,V__TYPE)
            & s__agent(V__EVENT,V__ORG) ) ) ) ).

fof(kb_SUMO_7525,axiom,
    s__instance(s__organizationServiceType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7526,axiom,
    s__domain(s__organizationServiceType__m,"1",s__Organization) ).

fof(kb_SUMO_7527,axiom,
    s__domainSubclass(s__organizationServiceType__m,"2",s__IntentionalProcess) ).

fof(kb_SUMO_7528,axiom,
    s__documentation(s__organizationServiceType__m,s__EnglishLanguage,'(&%organizationServiceType ?BUSINESS ?TYPE) means that the &%Organization ?BUSINESS provides services of the kind ?TYPE.') ).

fof(kb_SUMO_7529,axiom,
    ! [V__GENUS,V__TYPE,V__BUSINESS] :
      ( ( s__instance(V__BUSINESS,s__Organization)
        & s__subclass(V__TYPE,s__IntentionalProcess)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__subclass(V__GENUS,s__IntentionalProcess)
        & s__instance(V__GENUS,s__SetOrClass) )
     => ( ( s__organizationServiceType(V__BUSINESS,V__TYPE)
          & s__subclass(V__TYPE,V__GENUS) )
       => s__organizationServiceType(V__BUSINESS,V__GENUS) ) ) ).

fof(kb_SUMO_7530,axiom,
    ! [V__INDUSTRY,V__TYPE,V__BUSINESS] :
      ( ( s__subclass(V__TYPE,s__IntentionalProcess)
        & s__instance(V__TYPE,s__SetOrClass) )
     => ( ( s__industryServiceType(V__INDUSTRY,V__TYPE)
          & s__instance(V__INDUSTRY,s__IndustryAttribute)
          & s__instance(V__BUSINESS,s__Organization)
          & s__attribute(V__BUSINESS,V__INDUSTRY) )
       => s__organizationServiceType(V__BUSINESS,V__TYPE) ) ) ).

fof(kb_SUMO_7531,axiom,
    s__instance(s__resultType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7532,axiom,
    s__domain(s__resultType__m,"1",s__Process) ).

fof(kb_SUMO_7533,axiom,
    s__domainSubclass(s__resultType__m,"2",s__Object) ).

fof(kb_SUMO_7534,axiom,
    s__documentation(s__resultType__m,s__EnglishLanguage,'(&%resultType ?PROCESS ?TYPE) means that the &%Process ?PROCESS produces some result(s) of the type ?TYPE.') ).

fof(kb_SUMO_7535,axiom,
    ! [V__PROCESS,V__TYPE] :
      ( ( s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__instance(V__PROCESS,s__Process) )
     => ( s__resultType(V__PROCESS,V__TYPE)
       => ? [V__ITEM] :
            ( s__instance(V__ITEM,V__TYPE)
            & s__result(V__PROCESS,V__ITEM) ) ) ) ).

fof(kb_SUMO_7536,axiom,
    s__industryProductType(s__AircraftManufacturing,s__Aircraft) ).

fof(kb_SUMO_7537,axiom,
    s__industryProductType(s__AluminaRefining,s__Alumina) ).

fof(kb_SUMO_7538,axiom,
    s__industryProductType(s__AutomobileManufacturing,s__Automobile) ).

fof(kb_SUMO_7539,axiom,
    s__industryProductType(s__CementManufacturing,s__Cement) ).

fof(kb_SUMO_7540,axiom,
    s__instance(s__CoalIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7541,axiom,
    s__subAttribute(s__CoalMining,s__CoalIndustry) ).

fof(kb_SUMO_7542,axiom,
    s__subAttribute(s__CoalProductsManufacturing,s__CoalIndustry) ).

fof(kb_SUMO_7543,axiom,
    s__industryProductType(s__CoalMining,s__Coal) ).

fof(kb_SUMO_7544,axiom,
    s__subAttribute(s__CoalProductsManufacturing,s__PetroleumAndCoalProductsManufacturing) ).

fof(kb_SUMO_7545,axiom,
    s__instance(s__ConsumerGoodsIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7546,axiom,
    s__instance(s__CopperIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7547,axiom,
    s__subAttribute(s__CopperOreMining,s__CopperIndustry) ).

fof(kb_SUMO_7548,axiom,
    s__subAttribute(s__PrimarySmeltingAndRefiningOfCopper,s__CopperIndustry) ).

fof(kb_SUMO_7549,axiom,
    s__subAttribute(s__CopperRollingDrawingExtrudingAndAlloying,s__CopperIndustry) ).

fof(kb_SUMO_7550,axiom,
    s__subAttribute(s__CopperFoundriesExceptDieCasting,s__CopperIndustry) ).

fof(kb_SUMO_7551,axiom,
    s__industryProductType(s__CopperOreMining,s__CopperOre) ).

fof(kb_SUMO_7552,axiom,
    s__subAttribute(s__CopperOreMining,s__CopperOreAndNickelOreMining) ).

fof(kb_SUMO_7553,axiom,
    s__instance(s__FertilizerIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7554,axiom,
    s__subAttribute(s__FertilizerManufacturing,s__FertilizerIndustry) ).

fof(kb_SUMO_7555,axiom,
    s__subAttribute(s__FertilizerMineralMining,s__FertilizerIndustry) ).

fof(kb_SUMO_7556,axiom,
    s__subAttribute(s__FertilizerMineralMining,s__OtherChemicalAndFertilizerMineralMining) ).

fof(kb_SUMO_7557,axiom,
    s__industryProductType(s__FertilizerMineralMining,s__Fertilizer) ).

fof(kb_SUMO_7558,axiom,
    s__industryProductType(s__FoodManufacturing,s__FoodForFn(s__Animal)) ).

fof(kb_SUMO_7559,axiom,
    s__subclass(s__Footwear,s__Clothing) ).

fof(kb_SUMO_7560,axiom,
    s__instance(s__Footwear__t,s__SetOrClass) ).

fof(kb_SUMO_7561,axiom,
    s__industryProductType(s__FootwearManufacturing,s__Footwear) ).

fof(kb_SUMO_7562,axiom,
    s__instance(s__FurnitureIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7563,axiom,
    s__subAttribute(s__FurnitureAndRelatedProductManufacturing,s__FurnitureIndustry) ).

fof(kb_SUMO_7564,axiom,
    s__subAttribute(s__FurnitureAndHomeFurnishingWholesalers,s__FurnitureIndustry) ).

fof(kb_SUMO_7565,axiom,
    s__subAttribute(s__FurnitureAndHomeFurnishingsStores,s__FurnitureIndustry) ).

fof(kb_SUMO_7566,axiom,
    s__subAttribute(s__FurnitureManufacturing,s__FurnitureAndRelatedProductManufacturing) ).

fof(kb_SUMO_7567,axiom,
    s__industryProductType(s__FurnitureManufacturing,s__Furniture) ).

fof(kb_SUMO_7568,axiom,
    s__instance(s__HandicraftIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7569,axiom,
    s__subAttribute(s__HandwovenCarpetManufacturing,s__HandicraftIndustry) ).

fof(kb_SUMO_7570,axiom,
    s__instance(s__LeadIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7571,axiom,
    s__subAttribute(s__LeadOreMining,s__LeadIndustry) ).

fof(kb_SUMO_7572,axiom,
    s__subAttribute(s__LeadManufacturing,s__LeadIndustry) ).

fof(kb_SUMO_7573,axiom,
    s__subAttribute(s__LeadOreMining,s__LeadOreAndZincOreMining) ).

fof(kb_SUMO_7574,axiom,
    s__industryProductType(s__LeadOreMining,s__LeadOre) ).

fof(kb_SUMO_7575,axiom,
    s__instance(s__LeadManufacturing,s__IndustryAttribute) ).

fof(kb_SUMO_7576,axiom,
    s__instance(s__LumberIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7577,axiom,
    s__subAttribute(s__ForestryAndLogging,s__LumberIndustry) ).

fof(kb_SUMO_7578,axiom,
    s__subAttribute(s__WoodProductManufacturing,s__LumberIndustry) ).

fof(kb_SUMO_7579,axiom,
    s__subAttribute(s__Millwork,s__LumberIndustry) ).

fof(kb_SUMO_7580,axiom,
    s__subAttribute(s__LumberPlywoodMillworkAndWoodPanelWholesalers,s__LumberIndustry) ).

fof(kb_SUMO_7581,axiom,
    s__industryProductType(s__ForestryAndLogging,s__Timber) ).

fof(kb_SUMO_7582,axiom,
    s__industryProductType(s__MachineryManufacturing,s__Machinery) ).

fof(kb_SUMO_7583,axiom,
    s__instance(s__MetallurgyIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7584,axiom,
    s__instance(s__IndustryAttribute__t,s__SetOrClass) ).

fof(kb_SUMO_7585,axiom,
    s__industryProductType(s__MetallurgyIndustry,s__Metal) ).

fof(kb_SUMO_7586,axiom,
    ! [V__ORG] :
      ( s__instance(V__ORG,s__Object)
     => ( s__instance(V__ORG,s__MetallurgicalPlant)
       => s__attribute(V__ORG,s__MetallurgyIndustry) ) ) ).

fof(kb_SUMO_7587,axiom,
    s__industryProductType(s__MetalworkingMachineryManufacturing,s__MachineTool) ).

fof(kb_SUMO_7588,axiom,
    s__instance(s__MiningIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7589,axiom,
    s__subAttribute(s__MiningExceptOilAndGas,s__MiningIndustry) ).

fof(kb_SUMO_7590,axiom,
    s__subAttribute(s__SupportActivitiesForMetalMining,s__MiningIndustry) ).

fof(kb_SUMO_7591,axiom,
    s__subAttribute(s__SupportActivitiesForNonmetallicMineralsExceptFuels,s__MiningIndustry) ).

fof(kb_SUMO_7592,axiom,
    s__subAttribute(s__NickelOreMining,s__CopperOreAndNickelOreMining) ).

fof(kb_SUMO_7593,axiom,
    s__industryProductType(s__IndustrialSandMining,s__Sand) ).

fof(kb_SUMO_7594,axiom,
    s__industryProductType(s__IronOreMining,s__IronOre) ).

fof(kb_SUMO_7595,axiom,
    s__industryProductType(s__KaolinAndBallClayMining,s__Clay) ).

fof(kb_SUMO_7596,axiom,
    s__industryProductType(s__NickelOreMining,s__NickelOre) ).

fof(kb_SUMO_7597,axiom,
    s__industryProductType(s__StoneMiningAndQuarrying,s__Rock) ).

fof(kb_SUMO_7598,axiom,
    s__instance(s__MotorVehicleIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7599,axiom,
    s__subAttribute(s__MotorVehicleManufacturing,s__MotorVehicleIndustry) ).

fof(kb_SUMO_7600,axiom,
    s__subAttribute(s__MotorVehiclePartsManufacturing,s__MotorVehicleIndustry) ).

fof(kb_SUMO_7601,axiom,
    s__subAttribute(s__MotorVehicleBodyAndTrailerManufacturing,s__MotorVehicleIndustry) ).

fof(kb_SUMO_7602,axiom,
    s__subAttribute(s__MotorVehicleAndMotorVehiclePartsAndSuppliesWholesalers,s__MotorVehicleIndustry) ).

fof(kb_SUMO_7603,axiom,
    s__subAttribute(s__MotorVehicleAndPartsDealers,s__MotorVehicleIndustry) ).

fof(kb_SUMO_7604,axiom,
    s__industryProductType(s__MotorVehicleManufacturing,s__RoadVehicle) ).

fof(kb_SUMO_7605,axiom,
    s__industryProductType(s__TruckTrailerManufacturing,s__Wagon) ).

fof(kb_SUMO_7606,axiom,
    s__instance(s__NaturalGasIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7607,axiom,
    s__subAttribute(s__NaturalGasLiquidExtraction,s__NaturalGasIndustry) ).

fof(kb_SUMO_7608,axiom,
    s__subAttribute(s__NaturalGasDistribution,s__NaturalGasIndustry) ).

fof(kb_SUMO_7609,axiom,
    s__subAttribute(s__PipelineTransportationOfNaturalGas,s__NaturalGasIndustry) ).

fof(kb_SUMO_7610,axiom,
    s__industryProductType(s__NaturalGasIndustry,s__NaturalGas) ).

fof(kb_SUMO_7611,axiom,
    s__instance(s__PetroleumIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7612,axiom,
    s__subAttribute(s__PetroleumProductsManufacturing,s__PetroleumIndustry) ).

fof(kb_SUMO_7613,axiom,
    s__subAttribute(s__PetroleumRefineries,s__PetroleumIndustry) ).

fof(kb_SUMO_7614,axiom,
    s__subAttribute(s__CrudePetroleumExtraction,s__PetroleumIndustry) ).

fof(kb_SUMO_7615,axiom,
    s__subAttribute(s__DrillingOilAndGasWells,s__PetroleumIndustry) ).

fof(kb_SUMO_7616,axiom,
    s__subAttribute(s__SupportActivitiesForOilOperations,s__PetroleumIndustry) ).

fof(kb_SUMO_7617,axiom,
    s__subAttribute(s__AsphaltPavingRoofingAndSaturatedMaterialsManufacturing,s__PetroleumIndustry) ).

fof(kb_SUMO_7618,axiom,
    s__subAttribute(s__SupportActivitiesForOilOperations,s__SupportActivitiesForOilAndGasOperations) ).

fof(kb_SUMO_7619,axiom,
    s__subAttribute(s__PetroleumProductsManufacturing,s__PetroleumAndCoalProductsManufacturing) ).

fof(kb_SUMO_7620,axiom,
    s__subAttribute(s__PetroleumLubricatingOilAndGreaseManufacturing,s__PetroleumProductsManufacturing) ).

fof(kb_SUMO_7621,axiom,
    s__subAttribute(s__CrudePetroleumExtraction,s__CrudePetroleumAndNaturalGasExtraction) ).

fof(kb_SUMO_7622,axiom,
    s__industryProductType(s__CrudePetroleumExtraction,s__Petroleum) ).

fof(kb_SUMO_7623,axiom,
    s__industryProductType(s__PetroleumRefineries,s__RefinedPetroleumProduct) ).

fof(kb_SUMO_7624,axiom,
    s__industryProductType(s__PetroleumLubricatingOilAndGreaseManufacturing,s__PetroleumLubricant) ).

fof(kb_SUMO_7625,axiom,
    s__industryProductType(s__AsphaltPavingRoofingAndSaturatedMaterialsManufacturing,s__Asphalt) ).

fof(kb_SUMO_7626,axiom,
    s__instance(s__RefrigeratorAndFreezerIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7627,axiom,
    s__subAttribute(s__RefrigerationEquipmentManufacturing,s__RefrigeratorAndFreezerIndustry) ).

fof(kb_SUMO_7628,axiom,
    s__subAttribute(s__RefrigerationEquipmentAndSuppliesWholesalers,s__RefrigeratorAndFreezerIndustry) ).

fof(kb_SUMO_7629,axiom,
    s__subAttribute(s__RefrigeratedWarehousingAndStorage,s__RefrigeratorAndFreezerIndustry) ).

fof(kb_SUMO_7630,axiom,
    s__subAttribute(s__CommercialAndIndustrialRefrigerationAndEquipmentManufacturing,s__AirConditioningAndWarmAirHeatingEquipmentAndCommercialAndIndustrialRefrigerationEquipmentManufacturing) ).

fof(kb_SUMO_7631,axiom,
    s__instance(s__RefrigerationEquipmentManufacturing,s__IndustryAttribute) ).

fof(kb_SUMO_7632,axiom,
    s__subAttribute(s__HouseholdRefrigeratorAndHomeFreezerManufacturing,s__RefrigeratorAndFreezerIndustry) ).

fof(kb_SUMO_7633,axiom,
    s__subAttribute(s__CommercialAndIndustrialRefrigerationAndEquipmentManufacturing,s__RefrigeratorAndFreezerIndustry) ).

fof(kb_SUMO_7634,axiom,
    s__industryProductType(s__SoapAndOtherDetergentManufacturing,s__Detergent) ).

fof(kb_SUMO_7635,axiom,
    s__instance(s__SteelIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7636,axiom,
    s__subAttribute(s__SteelMills,s__SteelIndustry) ).

fof(kb_SUMO_7637,axiom,
    s__subAttribute(s__SteelForging,s__SteelIndustry) ).

fof(kb_SUMO_7638,axiom,
    s__subAttribute(s__SteelFoundriesExceptInvestment,s__SteelIndustry) ).

fof(kb_SUMO_7639,axiom,
    s__subAttribute(s__SteelInvestmentFoundries,s__SteelIndustry) ).

fof(kb_SUMO_7640,axiom,
    s__subAttribute(s__SteelProductManufacturingFromPurchasedSteel,s__SteelIndustry) ).

fof(kb_SUMO_7641,axiom,
    s__subAttribute(s__SteelMills,s__IronAndSteelMills) ).

fof(kb_SUMO_7642,axiom,
    s__subAttribute(s__IronMills,s__IronAndSteelMills) ).

fof(kb_SUMO_7643,axiom,
    s__subAttribute(s__SteelForging,s__IronAndSteelForging) ).

fof(kb_SUMO_7644,axiom,
    s__subAttribute(s__IronForging,s__IronAndSteelForging) ).

fof(kb_SUMO_7645,axiom,
    s__instance(s__TextileIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7646,axiom,
    s__subAttribute(s__TextileMills,s__TextileIndustry) ).

fof(kb_SUMO_7647,axiom,
    s__subAttribute(s__TextileProductMills,s__TextileIndustry) ).

fof(kb_SUMO_7648,axiom,
    s__industryProductType(s__FabricMills,s__Fabric) ).

fof(kb_SUMO_7649,axiom,
    s__instance(s__TourismIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7650,axiom,
    s__documentation(s__TourismIndustry,s__EnglishLanguage,'&%TourismIndustry is an &%Attribute that describes organizations that provide services or products for travellers who stay temporarily in a region to experience local attractions. There is an overlap between &%TourismIndustry and each of the following industries: &%TravelArrangementAndReservationServices, &%TravelerAccommodation, &%MuseumsHistoricalSitesAndSimilarInstitutions, &%AmusementGamblingAndRecreationIndustries, and &%ArtsEntertainmentAndRecreation.') ).

fof(kb_SUMO_7651,axiom,
    s__relatedInternalConcept(s__TravelArrangementAndReservationServices,s__TourismIndustry) ).

fof(kb_SUMO_7652,axiom,
    s__relatedInternalConcept(s__TravelerAccommodation,s__TourismIndustry) ).

fof(kb_SUMO_7653,axiom,
    s__relatedInternalConcept(s__MuseumsHistoricalSitesAndSimilarInstitutions,s__TourismIndustry) ).

fof(kb_SUMO_7654,axiom,
    s__relatedInternalConcept(s__AmusementGamblingAndRecreationIndustries,s__TourismIndustry) ).

fof(kb_SUMO_7655,axiom,
    s__relatedInternalConcept(s__ArtsEntertainmentAndRecreation,s__TourismIndustry) ).

fof(kb_SUMO_7656,axiom,
    s__instance(s__VegetableOilIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7657,axiom,
    s__subAttribute(s__GrainAndOilseedMilling,s__VegetableOilIndustry) ).

fof(kb_SUMO_7658,axiom,
    s__instance(s__ZincIndustry,s__IndustryAttribute) ).

fof(kb_SUMO_7659,axiom,
    s__subAttribute(s__ZincOreMining,s__ZincIndustry) ).

fof(kb_SUMO_7660,axiom,
    s__subAttribute(s__ZincOreMining,s__LeadOreAndZincOreMining) ).

fof(kb_SUMO_7661,axiom,
    s__industryProductType(s__ZincOreMining,s__ZincOre) ).

fof(kb_SUMO_7662,axiom,
    s__instance(s__ZincManufacturing,s__IndustryAttribute) ).

fof(kb_SUMO_7663,axiom,
    s__instance(s__industrialProductionGrowthRateInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7664,axiom,
    s__domain(s__industrialProductionGrowthRateInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7665,axiom,
    s__domain(s__industrialProductionGrowthRateInPeriod__m,"2",s__RealNumber) ).

fof(kb_SUMO_7666,axiom,
    s__domainSubclass(s__industrialProductionGrowthRateInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7667,axiom,
    s__documentation(s__industrialProductionGrowthRateInPeriod__m,s__EnglishLanguage,'(&%industrialProductionGrowthRateInPeriod ?AREA ?RATE ?PERIOD) means that in the &%GeopoliticalArea ?AREA, the annual percentage increase in industrial production is ?RATE, for the &%TimeInterval ?PERIOD.') ).

fof(kb_SUMO_7668,axiom,
    s__instance(s__industrialProductionGrowthRate__m,s__BinaryPredicate) ).

fof(kb_SUMO_7669,axiom,
    s__domain(s__industrialProductionGrowthRate__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7670,axiom,
    s__domain(s__industrialProductionGrowthRate__m,"2",s__RealNumber) ).

fof(kb_SUMO_7671,axiom,
    s__documentation(s__industrialProductionGrowthRate__m,s__EnglishLanguage,'(&%industrialProductionGrowthRate ?AREA ?RATE) means that in the &%GeopoliticalArea ?AREA, the annual percentage increase in industrial production is ?RATE.') ).

%FOL fof(kb_SUMO_7672,axiom,(( (! [V__PERIOD,V__RATE,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__RATE,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__industrialProductionGrowthRateInPeriod(V__AREA,V__RATE,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__industrialProductionGrowthRate(V__AREA,V__RATE)')))))) ))).

fof(kb_SUMO_7673,axiom,
    s__instance(s__electricityProductionInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7674,axiom,
    s__domain(s__electricityProductionInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7675,axiom,
    s__domain(s__electricityProductionInPeriod__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7676,axiom,
    s__domainSubclass(s__electricityProductionInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7677,axiom,
    s__documentation(s__electricityProductionInPeriod__m,s__EnglishLanguage,'(&%electricityProductionInPeriod ?AREA ?AMOUNT ?PERIOD) means that the &%GeopoliticalArea ?AREA generates ?AMOUNT of electricity, measured in &%KilowattHours, during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7678,axiom,
    s__instance(s__annualElectricityProduction__m,s__BinaryPredicate) ).

fof(kb_SUMO_7679,axiom,
    s__domain(s__annualElectricityProduction__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7680,axiom,
    s__domain(s__annualElectricityProduction__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7681,axiom,
    s__documentation(s__annualElectricityProduction__m,s__EnglishLanguage,'(&%annualElectricityProduction ?AREA ?AMOUNT) means that the amount of electricity generated annually in the &%GeographicalArea ?AREA is ?AMOUNT, measured in &%KilowattHours.') ).

%FOL fof(kb_SUMO_7682,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__electricityProductionInPeriod(V__AREA,V__AMOUNT,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => (? [V__YEAR] : (s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,V__PERIOD) & s__holdsDuring(V__YEAR,'s__annualElectricityProduction(V__AREA,V__AMOUNT)')))))) ))).

%FOL fof(kb_SUMO_7683,axiom,(( (! [V__AMOUNT,V__PERIOD,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__YEAR,s__TimePosition) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__holdsDuring(V__YEAR,'s__annualElectricityProduction(V__AREA,V__AMOUNT)') & s__instance(V__YEAR,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => s__electricityProductionInPeriod(V__AREA,V__AMOUNT,V__PERIOD)))) ))).

fof(kb_SUMO_7684,axiom,
    s__instance(s__KilowattHour,s__CompositeUnitOfMeasure) ).

fof(kb_SUMO_7685,axiom,
    s__abbreviation(kWh,s__KilowattHour) ).

fof(kb_SUMO_7686,axiom,
    s__documentation(s__KilowattHour,s__EnglishLanguage,'&%KilowattHour is a &%UnitOfMeasure for energy that represents 1000 &%Watts (1 kW) of power expended over one hour (1 h) of time. This is the unit commonly used in commercial power contexts. It is equivalent to 3,600,000 &%Joules.') ).

fof(kb_SUMO_7687,axiom,
    s__MeasureFn("1",s__KilowattHour) = s__MeasureFn("3.6",s__MegaFn(s__Joule)) ).

fof(kb_SUMO_7688,axiom,
    s__MeasureFn("1",s__KilowattHour) = s__MeasureFn("3600000",s__Joule) ).

fof(kb_SUMO_7689,axiom,
    ! [V__AMOUNT,V__X] :
      ( s__instance(V__X,s__RealNumber)
     => ( V__AMOUNT = s__MeasureFn(V__X,s__KilowattHour)
       => V__AMOUNT = s__MeasureFn(times("3600000",V__X),s__Joule) ) ) ).

fof(kb_SUMO_7690,axiom,
    ! [V__AMOUNT,V__X] :
      ( s__instance(V__X,s__RealNumber)
     => ( V__AMOUNT = s__MeasureFn(V__X,s__Joule)
       => V__AMOUNT = s__MeasureFn(times("0.0002778",V__X),s__Watt) ) ) ).

fof(kb_SUMO_7691,axiom,
    s__instance(s__electricityFractionFromSourceInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7692,axiom,
    s__domain(s__electricityFractionFromSourceInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7693,axiom,
    s__domainSubclass(s__electricityFractionFromSourceInPeriod__m,"2",s__PowerGeneration) ).

fof(kb_SUMO_7694,axiom,
    s__domain(s__electricityFractionFromSourceInPeriod__m,"3",s__RealNumber) ).

fof(kb_SUMO_7695,axiom,
    s__domainSubclass(s__electricityFractionFromSourceInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7696,axiom,
    s__documentation(s__electricityFractionFromSourceInPeriod__m,s__EnglishLanguage,'(&%electricityFractionFromSourceInPeriod ?AREA ?SOURCE ?FRACTION ?PERIOD) means that in the &%GeopoliticalArea ?AREA, ?SOURCE provides ?FRACTION of the total electricity production during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7697,axiom,
    ! [V__PERIOD,V__FRACTION,V__SOURCE,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__subclass(V__SOURCE,s__PowerGeneration)
        & s__instance(V__SOURCE,s__SetOrClass)
        & s__instance(V__FRACTION,s__RealNumber)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__electricityFractionFromSourceInPeriod(V__AREA,V__SOURCE,V__FRACTION,V__PERIOD)
       => lesseq(V__FRACTION,"1.0") ) ) ).

fof(kb_SUMO_7698,axiom,
    s__instance(s__electricityFractionFromSource__m,s__TernaryPredicate) ).

fof(kb_SUMO_7699,axiom,
    s__domain(s__electricityFractionFromSource__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7700,axiom,
    s__domainSubclass(s__electricityFractionFromSource__m,"2",s__PowerGeneration) ).

fof(kb_SUMO_7701,axiom,
    s__domain(s__electricityFractionFromSource__m,"3",s__RealNumber) ).

fof(kb_SUMO_7702,axiom,
    s__documentation(s__electricityFractionFromSource__m,s__EnglishLanguage,'(&%electricityFractionFromSource ?AREA ?SOURCE ?FRACTION) means that in the &%GeopoliticalArea ?AREA, ?SOURCE provides ?FRACTION of the total electricity production.') ).

fof(kb_SUMO_7703,axiom,
    ! [V__FRACTION,V__SOURCE,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__subclass(V__SOURCE,s__PowerGeneration)
        & s__instance(V__SOURCE,s__SetOrClass)
        & s__instance(V__FRACTION,s__RealNumber) )
     => ( s__electricityFractionFromSource(V__AREA,V__SOURCE,V__FRACTION)
       => lesseq(V__FRACTION,"1.0") ) ) ).

%FOL fof(kb_SUMO_7704,axiom,(( (! [V__PERIOD,V__FRACTION,V__SOURCE,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__SOURCE,s__PowerGeneration) & s__instance(V__SOURCE,s__SetOrClass) & s__instance(V__FRACTION,s__RealNumber) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__electricityFractionFromSourceInPeriod(V__AREA,V__SOURCE,V__FRACTION,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__electricityFractionFromSource(V__AREA,V__SOURCE,V__FRACTION)')))))) ))).

fof(kb_SUMO_7705,axiom,
    s__subclass(s__PowerGeneration,s__Process) ).

fof(kb_SUMO_7706,axiom,
    s__documentation(s__PowerGeneration,s__EnglishLanguage,'&%PowerGeneration is the class of &%Processes in which some kind of power is generated either for immediate use in a &%Device or to be stored for future use.') ).

fof(kb_SUMO_7707,axiom,
    s__subclass(s__ElectricalPowerGeneration,s__PowerGeneration) ).

fof(kb_SUMO_7708,axiom,
    s__documentation(s__ElectricalPowerGeneration,s__EnglishLanguage,'&%ElectricalPowerGeneration is the subclass of &%PowerGeneration processes in which electricity is generated.') ).

fof(kb_SUMO_7709,axiom,
    s__instance(s__FossilFuelPowerGeneration,s__PowerGeneration) ).

fof(kb_SUMO_7710,axiom,
    s__instance(s__PowerGeneration__t,s__SetOrClass) ).

fof(kb_SUMO_7711,axiom,
    s__instance(s__HydroElectricPowerGeneration,s__ElectricalPowerGeneration) ).

fof(kb_SUMO_7712,axiom,
    s__instance(s__ElectricalPowerGeneration__t,s__SetOrClass) ).

fof(kb_SUMO_7713,axiom,
    s__instance(s__NuclearPowerGeneration,s__PowerGeneration) ).

fof(kb_SUMO_7714,axiom,
    s__instance(s__OtherSourcePowerGeneration,s__PowerGeneration) ).

fof(kb_SUMO_7715,axiom,
    s__documentation(s__OtherSourcePowerGeneration,s__EnglishLanguage,'&%OtherSourcePowerGeneration represents all non-fossil fuel, non-hydroelectric, and non-nuclear power generation processes, e.g., wind power generation.') ).

fof(kb_SUMO_7716,axiom,
    s__disjointDecomposition_5(s__PowerGeneration,s__FossilFuelPowerGeneration,s__HydroElectricPowerGeneration,s__NuclearPowerGeneration,s__OtherSourcePowerGeneration) ).

fof(kb_SUMO_7717,axiom,
    s__instance(s__electricityConsumptionInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7718,axiom,
    s__domain(s__electricityConsumptionInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7719,axiom,
    s__domain(s__electricityConsumptionInPeriod__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7720,axiom,
    s__domainSubclass(s__electricityConsumptionInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7721,axiom,
    s__documentation(s__electricityConsumptionInPeriod__m,s__EnglishLanguage,'(&%electricityConsumptionInPeriod ?AREA ?AMOUNT ?YEAR) means that the &%GeopoliticalArea ?AREA used ?AMOUNT of electricity (measured in &%KilowattHours) during the &%TimeInterval indicated by ?YEAR.') ).

fof(kb_SUMO_7722,axiom,
    s__instance(s__annualElectricityConsumption__m,s__BinaryPredicate) ).

fof(kb_SUMO_7723,axiom,
    s__domain(s__annualElectricityConsumption__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7724,axiom,
    s__domain(s__annualElectricityConsumption__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7725,axiom,
    s__documentation(s__annualElectricityConsumption__m,s__EnglishLanguage,'(&%annualElectricityConsumption ?AREA ?AMOUNT) means that the &%GeopoliticalArea ?AREA uses ?AMOUNT of electricity (measured in &%KilowattHours) annually.') ).

%FOL fof(kb_SUMO_7726,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__electricityConsumptionInPeriod(V__AREA,V__AMOUNT,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => (? [V__YEAR] : (s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,V__PERIOD) & s__holdsDuring(V__YEAR,'s__annualElectricityConsumption(V__AREA,V__AMOUNT)')))))) ))).

%FOL fof(kb_SUMO_7727,axiom,(( (! [V__AMOUNT,V__PERIOD,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__YEAR,s__TimePosition) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__holdsDuring(V__YEAR,'s__annualElectricityConsumption(V__AREA,V__AMOUNT)') & s__instance(V__YEAR,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => s__electricityConsumptionInPeriod(V__AREA,V__AMOUNT,V__PERIOD)))) ))).

fof(kb_SUMO_7728,axiom,
    s__instance(s__electricityExportInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7729,axiom,
    s__domain(s__electricityExportInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7730,axiom,
    s__domain(s__electricityExportInPeriod__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7731,axiom,
    s__domainSubclass(s__electricityExportInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7732,axiom,
    s__documentation(s__electricityExportInPeriod__m,s__EnglishLanguage,'(&%electricityExportInPeriod ?AREA ?AMOUNT ?PERIOD) means that the &%GeopoliticalArea ?AREA exported the total ?AMOUNT of electricity (measured in &%KilowattHours) during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7733,axiom,
    s__instance(s__annualElectricityExport__m,s__BinaryPredicate) ).

fof(kb_SUMO_7734,axiom,
    s__domain(s__annualElectricityExport__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7735,axiom,
    s__domain(s__annualElectricityExport__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7736,axiom,
    s__documentation(s__annualElectricityExport__m,s__EnglishLanguage,'(&%annualElectricityExport ?AREA ?AMOUNT) means that the &%GeopoliticalArea ?AREA exported the total ?AMOUNT of electricity (measured in &%KilowattHours) annually.') ).

%FOL fof(kb_SUMO_7737,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__electricityExportInPeriod(V__AREA,V__AMOUNT,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => (? [V__YEAR] : (s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,V__PERIOD) & s__holdsDuring(V__YEAR,'s__annualElectricityExport(V__AREA,V__AMOUNT)')))))) ))).

%FOL fof(kb_SUMO_7738,axiom,(( (! [V__AMOUNT,V__PERIOD,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__YEAR,s__TimePosition) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__holdsDuring(V__YEAR,'s__annualElectricityExport(V__AREA,V__AMOUNT)') & s__instance(V__YEAR,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => s__electricityExportInPeriod(V__AREA,V__AMOUNT,V__PERIOD)))) ))).

fof(kb_SUMO_7739,axiom,
    s__instance(s__electricityImportInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7740,axiom,
    s__domain(s__electricityImportInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7741,axiom,
    s__domain(s__electricityImportInPeriod__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7742,axiom,
    s__domainSubclass(s__electricityImportInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7743,axiom,
    s__documentation(s__electricityImportInPeriod__m,s__EnglishLanguage,'(&%electricityImportInPeriod ?AREA ?AMOUNT ?PERIOD) means that the &%GeopoliticalArea ?AREA imported the total ?AMOUNT of electricity (measured in &%KilowattHours) during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7744,axiom,
    s__instance(s__annualElectricityImport__m,s__BinaryPredicate) ).

fof(kb_SUMO_7745,axiom,
    s__domain(s__annualElectricityImport__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7746,axiom,
    s__domain(s__annualElectricityImport__m,"2",s__PhysicalQuantity) ).

fof(kb_SUMO_7747,axiom,
    s__documentation(s__annualElectricityImport__m,s__EnglishLanguage,'(&%annualElectricityImport ?AREA ?AMOUNT) means that the &%GeopoliticalArea ?AREA imported the total ?AMOUNT of electricity (measured in &%KilowattHours) annually.') ).

%FOL fof(kb_SUMO_7748,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__electricityImportInPeriod(V__AREA,V__AMOUNT,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => (? [V__YEAR] : (s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,V__PERIOD) & s__holdsDuring(V__YEAR,'s__annualElectricityImport(V__AREA,V__AMOUNT)')))))) ))).

%FOL fof(kb_SUMO_7749,axiom,(( (! [V__AMOUNT,V__PERIOD,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__YEAR,s__TimePosition) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__PhysicalQuantity)) => ((s__holdsDuring(V__YEAR,'s__annualElectricityImport(V__AREA,V__AMOUNT)') & s__instance(V__YEAR,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => s__electricityImportInPeriod(V__AREA,V__AMOUNT,V__PERIOD)))) ))).

fof(kb_SUMO_7750,axiom,
    s__instance(s__agriculturalProductType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7751,axiom,
    s__domain(s__agriculturalProductType__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7752,axiom,
    s__domainSubclass(s__agriculturalProductType__m,"2",s__Object) ).

fof(kb_SUMO_7753,axiom,
    s__documentation(s__agriculturalProductType__m,s__EnglishLanguage,'(&%agriculturalProductType ?AREA ?TYPE) means that the &%GeopoliticalArea ?AREA produces a crop or other agricultural product of ?TYPE.') ).

fof(kb_SUMO_7754,axiom,
    s__instance(s__agriculturalProductTypeByRank__m,s__TernaryPredicate) ).

fof(kb_SUMO_7755,axiom,
    s__domain(s__agriculturalProductTypeByRank__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7756,axiom,
    s__domainSubclass(s__agriculturalProductTypeByRank__m,"2",s__Object) ).

fof(kb_SUMO_7757,axiom,
    s__domainSubclass(s__agriculturalProductTypeByRank__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7758,axiom,
    s__documentation(s__agriculturalProductTypeByRank__m,s__EnglishLanguage,'(&%agriculturalProductTypeByRank ?AREA ?TYPE ?NTH) means that the &%GeopoliticalArea ?AREA produces a crop or other agricultural product of ?TYPE, which is its ?NTH most important crop.') ).

fof(kb_SUMO_7759,axiom,
    s__instance(s__exportTotalInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7760,axiom,
    s__domain(s__exportTotalInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7761,axiom,
    s__domain(s__exportTotalInPeriod__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7762,axiom,
    s__domainSubclass(s__exportTotalInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7763,axiom,
    s__documentation(s__exportTotalInPeriod__m,s__EnglishLanguage,'(&%exportTotalInPeriod ?AREA ?AMOUNT ?PERIOD) means that the total value of exports from the &%GeopoliticalArea ?AREA is ?AMOUNT (in &%UnitedStatesDollars) for the &%TimeInterval indicated by ?PERIOD. Export value is calculated on a Free on Board (F.O.B.) basis.') ).

fof(kb_SUMO_7764,axiom,
    s__instance(s__annualExportTotal__m,s__BinaryPredicate) ).

fof(kb_SUMO_7765,axiom,
    s__domain(s__annualExportTotal__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7766,axiom,
    s__domain(s__annualExportTotal__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7767,axiom,
    s__documentation(s__annualExportTotal__m,s__EnglishLanguage,'(&%annualExportTotal ?AREA ?AMOUNT) means that the total value of exports from the &%GeopoliticalArea ?AREA is ?AMOUNT (in &%UnitedStatesDollars) annually. Export value is calculated on a Free on Board (F.O.B.) basis.') ).

%FOL fof(kb_SUMO_7768,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => ((s__exportTotalInPeriod(V__AREA,V__AMOUNT,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => (? [V__YEAR] : (s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,V__PERIOD) & s__holdsDuring(V__YEAR,'s__annualExportTotal(V__AREA,V__AMOUNT)')))))) ))).

%FOL fof(kb_SUMO_7769,axiom,(( (! [V__AMOUNT,V__PERIOD,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__YEAR,s__TimePosition) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => ((s__holdsDuring(V__YEAR,'s__annualExportTotal(V__AREA,V__AMOUNT)') & s__instance(V__YEAR,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => s__exportTotalInPeriod(V__AREA,V__AMOUNT,V__PERIOD)))) ))).

fof(kb_SUMO_7770,axiom,
    s__instance(s__exportCommodityType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7771,axiom,
    s__domain(s__exportCommodityType__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7772,axiom,
    s__domainSubclass(s__exportCommodityType__m,"2",s__Object) ).

fof(kb_SUMO_7773,axiom,
    s__documentation(s__exportCommodityType__m,s__EnglishLanguage,'(&%exportCommodityType ?AREA ?TYPE) means that the &%GeopoliticalArea ?AREA exports the commodity ?TYPE.') ).

fof(kb_SUMO_7774,axiom,
    ! [V__AGENT,V__TYPE] :
      ( ( s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__instance(V__AGENT,s__GeopoliticalArea) )
     => ( s__exportCommodityType(V__AGENT,V__TYPE)
       => ? [V__EXPORT,V__OBJECT] :
            ( s__instance(V__EXPORT,s__Process)
            & s__instance(V__EXPORT,s__Exporting)
            & s__agent(V__EXPORT,V__AGENT)
            & s__instance(V__OBJECT,V__TYPE)
            & s__patient(V__EXPORT,V__OBJECT) ) ) ) ).

fof(kb_SUMO_7775,axiom,
    s__instance(s__exportCommodityTypeByRank__m,s__TernaryPredicate) ).

fof(kb_SUMO_7776,axiom,
    s__domain(s__exportCommodityTypeByRank__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7777,axiom,
    s__domainSubclass(s__exportCommodityTypeByRank__m,"2",s__Object) ).

fof(kb_SUMO_7778,axiom,
    s__domain(s__exportCommodityTypeByRank__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7779,axiom,
    s__documentation(s__exportCommodityTypeByRank__m,s__EnglishLanguage,'(&%exportCommodityTypeByRank ?AREA ?TYPE ?NTH) means that the &%GeopoliticalArea ?AREA has the commodity ?TYPE as its ?NTH most valuable export.') ).

fof(kb_SUMO_7780,axiom,
    ! [V__RANK,V__TYPE,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__instance(V__RANK,s__PositiveInteger) )
     => ( s__exportCommodityTypeByRank(V__AREA,V__TYPE,V__RANK)
       => s__exportCommodityType(V__AREA,V__TYPE) ) ) ).

fof(kb_SUMO_7781,axiom,
    ! [V__TYPE,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass) )
     => ( s__exportCommodityType(V__AREA,V__TYPE)
       => ? [V__TRANSFER,V__OBJECT] :
            ( s__instance(V__TRANSFER,s__Process)
            & s__instance(V__TRANSFER,s__Exporting)
            & s__agent(V__TRANSFER,V__AREA)
            & s__patient(V__TRANSFER,V__OBJECT)
            & s__instance(V__OBJECT,V__TYPE) ) ) ) ).

fof(kb_SUMO_7782,axiom,
    s__instance(s__exportPartnerInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7783,axiom,
    s__domain(s__exportPartnerInPeriod__m,"1",s__Agent) ).

fof(kb_SUMO_7784,axiom,
    s__domain(s__exportPartnerInPeriod__m,"2",s__Agent) ).

fof(kb_SUMO_7785,axiom,
    s__domainSubclass(s__exportPartnerInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7786,axiom,
    s__documentation(s__exportPartnerInPeriod__m,s__EnglishLanguage,'(&%exportPartnerInPeriod ?AGENT1 ?AGENT2 ?PERIOD) means that the &%Agent ?AGENT1 exports goods to the &%Agent ?AGENT2 during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7787,axiom,
    ! [V__PERIOD,V__AGENT2,V__AGENT1] :
      ( ( s__instance(V__AGENT1,s__Agent)
        & s__instance(V__AGENT2,s__Agent)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__exportPartnerInPeriod(V__AGENT1,V__AGENT2,V__PERIOD)
       => ? [V__TIME,V__EXPORT] :
            ( s__instance(V__EXPORT,s__Process)
            & s__instance(V__TIME,s__TimeInterval)
            & s__instance(V__TIME,V__PERIOD)
            & s__instance(V__EXPORT,s__Exporting)
            & s__overlapsTemporally(V__TIME,s__WhenFn(V__EXPORT))
            & s__origin(V__EXPORT,V__AGENT1)
            & s__destination(V__EXPORT,V__AGENT2) ) ) ) ).

fof(kb_SUMO_7788,axiom,
    s__instance(s__exportPartner__m,s__BinaryPredicate) ).

fof(kb_SUMO_7789,axiom,
    s__instance(s__exportPartner__m,s__IrreflexiveRelation) ).

fof(kb_SUMO_7790,axiom,
    s__domain(s__exportPartner__m,"1",s__Agent) ).

fof(kb_SUMO_7791,axiom,
    s__domain(s__exportPartner__m,"2",s__Agent) ).

fof(kb_SUMO_7792,axiom,
    s__documentation(s__exportPartner__m,s__EnglishLanguage,'(&%exportPartner ?AGENT1 ?AGENT2) means that the &%Agent ?AGENT1 exports goods to the &%Agent ?AGENT2.') ).

fof(kb_SUMO_7793,axiom,
    ! [V__AGENT2,V__AGENT1] :
      ( ( s__instance(V__AGENT1,s__Agent)
        & s__instance(V__AGENT2,s__Agent) )
     => ( s__exportPartner(V__AGENT1,V__AGENT2)
       => ? [V__EXPORT] :
            ( s__instance(V__EXPORT,s__Process)
            & s__instance(V__EXPORT,s__Exporting)
            & s__origin(V__EXPORT,V__AGENT1)
            & s__destination(V__EXPORT,V__AGENT2) ) ) ) ).

%FOL fof(kb_SUMO_7794,axiom,(( (! [V__PERIOD,V__AGENT2,V__AGENT1] : ((s__instance(V__AGENT1,s__Agent) & s__instance(V__AGENT2,s__Agent) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__exportPartnerInPeriod(V__AGENT1,V__AGENT2,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__exportPartner(V__AGENT1,V__AGENT2)')))))) ))).

fof(kb_SUMO_7795,axiom,
    s__subclass(s__Exporting,s__ChangeOfPossession) ).

fof(kb_SUMO_7796,axiom,
    s__instance(s__Exporting__t,s__SetOrClass) ).

fof(kb_SUMO_7797,axiom,
    s__subclass(s__Exporting,s__FinancialTransaction) ).

fof(kb_SUMO_7798,axiom,
    s__documentation(s__Exporting,s__EnglishLanguage,'&%Exporting is the class of actions in which there is a &%ChangeOfPossession of goods shipped from a provider in one &%Nation to a destination in another &%Nation. Typically, there are &%Selling and &%Buying events associated with an &%Exporting. Either the seller or the exporting country may be considered the &%origin of &%Exporting.') ).

fof(kb_SUMO_7799,axiom,
    ! [V__EXPORT] :
      ( s__instance(V__EXPORT,s__Process)
     => ( s__instance(V__EXPORT,s__Exporting)
       => ? [V__ITEM] :
            ( s__instance(V__ITEM,s__Object)
            & s__patient(V__EXPORT,V__ITEM) ) ) ) ).

%FOL fof(kb_SUMO_7800,axiom,(( (! [V__EXPORT,V__ITEM,V__AREA] : ((s__instance(V__AREA,s__Object) & s__instance(V__ITEM,s__Physical) & s__instance(V__EXPORT,s__Process)) => ((s__instance(V__EXPORT,s__Exporting) & s__patient(V__EXPORT,V__ITEM) & s__instance(V__AREA,s__GeopoliticalArea) & s__origin(V__EXPORT,V__AREA)) => s__holdsDuring(s__BeginFn(s__WhenFn(V__EXPORT)),'s__located(V__ITEM,V__AREA)')))) ))).

%FOL fof(kb_SUMO_7801,axiom,(( (! [V__EXPORT,V__ITEM,V__AREA] : ((s__instance(V__AREA,s__Object) & s__instance(V__ITEM,s__Physical) & s__instance(V__EXPORT,s__Process)) => ((s__instance(V__EXPORT,s__Exporting) & s__patient(V__EXPORT,V__ITEM) & s__instance(V__AREA,s__GeopoliticalArea) & s__holdsDuring(s__BeginFn(s__WhenFn(V__EXPORT)),'s__located(V__ITEM,V__AREA)')) => s__holdsDuring(s__EndFn(s__WhenFn(V__EXPORT)),'(~ s__located(V__ITEM,V__AREA))')))) ))).

%FOL fof(kb_SUMO_7802,axiom,(( (! [V__EXPORT,V__AREA1,V__ITEM,V__AREA] : ((s__instance(V__AREA,s__Object) & s__instance(V__ITEM,s__Physical) & s__instance(V__AREA1,s__GeopoliticalArea) & s__instance(V__EXPORT,s__Process)) => ((s__instance(V__EXPORT,s__Exporting) & s__patient(V__EXPORT,V__ITEM) & s__instance(V__AREA,s__GeopoliticalArea) & s__holdsDuring(s__BeginFn(s__WhenFn(V__EXPORT)),'s__located(V__ITEM,V__AREA)')) => (? [V__AREA2] : (s__instance(V__AREA2,s__GeopoliticalArea) & (~ s__geopoliticalSubdivision(V__AREA1,V__AREA2)) & (~ s__geopoliticalSubdivision(V__AREA2,V__AREA1)) & s__holdsDuring(s__EndFn(s__WhenFn(V__EXPORT)),'s__located(V__ITEM,V__AREA2)')))))) ))).

%FOL fof(kb_SUMO_7803,axiom,(( (! [V__EXPORT,V__ITEM,V__AREA] : ((s__instance(V__AREA,s__Object) & s__instance(V__ITEM,s__Physical) & s__instance(V__EXPORT,s__Process)) => ((s__instance(V__EXPORT,s__Exporting) & s__patient(V__EXPORT,V__ITEM) & s__instance(V__AREA,s__GeopoliticalArea) & s__destination(V__EXPORT,V__AREA)) => s__holdsDuring(s__EndFn(s__WhenFn(V__EXPORT)),'s__located(V__ITEM,V__AREA)')))) ))).

%FOL fof(kb_SUMO_7804,axiom,(( (! [V__AREA2,V__EXPORT,V__AREA1,V__ITEM] : ((s__instance(V__ITEM,s__Physical) & s__instance(V__AREA1,s__Object) & s__instance(V__EXPORT,s__Process) & s__instance(V__AREA2,s__Object)) => ((s__instance(V__EXPORT,s__Exporting) & s__patient(V__EXPORT,V__ITEM) & s__instance(V__AREA1,s__GeopoliticalArea) & s__instance(V__AREA2,s__GeopoliticalArea) & s__holdsDuring(s__BeginFn(s__WhenFn(V__EXPORT)),'s__located(V__ITEM,V__AREA1)') & s__holdsDuring(s__EndFn(s__WhenFn(V__EXPORT)),'s__located(V__ITEM,V__AREA2)')) => (~ s__located(V__AREA2,V__AREA1))))) ))).

fof(kb_SUMO_7805,axiom,
    ! [V__AREA2,V__EXPORT,V__AREA1,V__ITEM] :
      ( ( s__instance(V__AREA1,s__Object)
        & s__instance(V__EXPORT,s__Process) )
     => ( ( s__instance(V__EXPORT,s__Exporting)
          & s__patient(V__EXPORT,V__ITEM)
          & s__instance(V__AREA1,s__GeopoliticalArea)
          & s__origin(V__EXPORT,V__AREA1)
          & s__instance(V__AREA2,s__GeopoliticalArea)
          & s__destination(V__EXPORT,V__AREA2) )
       => V__AREA1 != V__AREA2 ) ) ).

fof(kb_SUMO_7806,axiom,
    ! [V__AREA2,V__EXPORT,V__AREA1,V__ITEM] :
      ( ( s__instance(V__AREA1,s__Object)
        & s__instance(V__EXPORT,s__Process)
        & s__instance(V__AREA2,s__Physical) )
     => ( ( s__instance(V__EXPORT,s__Exporting)
          & s__patient(V__EXPORT,V__ITEM)
          & s__instance(V__AREA1,s__GeopoliticalArea)
          & s__origin(V__EXPORT,V__AREA1)
          & s__instance(V__AREA2,s__GeopoliticalArea)
          & s__destination(V__EXPORT,V__AREA2) )
       => ~ s__located(V__AREA2,V__AREA1) ) ) ).

fof(kb_SUMO_7807,axiom,
    s__instance(s__exportPartnerByRankInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7808,axiom,
    s__domain(s__exportPartnerByRankInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7809,axiom,
    s__domain(s__exportPartnerByRankInPeriod__m,"2",s__GeopoliticalArea) ).

fof(kb_SUMO_7810,axiom,
    s__domain(s__exportPartnerByRankInPeriod__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7811,axiom,
    s__domainSubclass(s__exportPartnerByRankInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7812,axiom,
    s__documentation(s__exportPartnerByRankInPeriod__m,s__EnglishLanguage,'(&%exportPartnerByRankInPeriod ?AREA1 ?AREA2 ?NTH ?PERIOD) means that the &%GeopoliticalArea ?AREA1 exports goods to &%GeopoliticalArea ?AREA2 and is the ?NTH most important export partner of ?AREA1, in the &%TimeInterval ?PERIOD, based on U.S. dollar value of exports.') ).

fof(kb_SUMO_7813,axiom,
    s__instance(s__exportPartnerByRank__m,s__TernaryPredicate) ).

fof(kb_SUMO_7814,axiom,
    s__domain(s__exportPartnerByRank__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7815,axiom,
    s__domain(s__exportPartnerByRank__m,"2",s__GeopoliticalArea) ).

fof(kb_SUMO_7816,axiom,
    s__domain(s__exportPartnerByRank__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7817,axiom,
    s__documentation(s__exportPartnerByRank__m,s__EnglishLanguage,'(&%exportPartnerByRank ?AREA1 ?AREA2 ?NTH) means that the &%GeopoliticalArea ?AREA1 exports goods to &%GeopoliticalArea ?AREA2 and is the ?NTH most important export partner of ?AREA1, based on U.S. dollar value of exports.') ).

%FOL fof(kb_SUMO_7818,axiom,(( (! [V__PERIOD,V__AREA2,V__AREA1,V__NTH] : ((s__instance(V__NTH,s__PositiveInteger) & s__instance(V__AREA1,s__GeopoliticalArea) & s__instance(V__AREA2,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__exportPartnerByRankInPeriod(V__AREA1,V__AREA2,V__NTH,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__exportPartnerByRank(V__AREA1,V__AREA2,V__NTH)')))))) ))).

fof(kb_SUMO_7819,axiom,
    s__instance(s__exportPartnerByFractionInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7820,axiom,
    s__domain(s__exportPartnerByFractionInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7821,axiom,
    s__domain(s__exportPartnerByFractionInPeriod__m,"2",s__GeopoliticalArea) ).

fof(kb_SUMO_7822,axiom,
    s__domain(s__exportPartnerByFractionInPeriod__m,"3",s__PositiveRealNumber) ).

fof(kb_SUMO_7823,axiom,
    s__domainSubclass(s__exportPartnerByFractionInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7824,axiom,
    s__documentation(s__exportPartnerByFractionInPeriod__m,s__EnglishLanguage,'(&%exportPartnerByFractionInPeriod ?AREA1 ?AREA2 ?FRACTION ?PERIOD) means that the &%GeopoliticalArea ?AREA1 exports goods to &%GeopoliticalArea ?AREA2 and receives ?FRACTION of the &%exportTotalInPeriod of ?AREA1 in the &%TimeInterval ?PERIOD, based on U.S. dollar value of exports.') ).

fof(kb_SUMO_7825,axiom,
    ! [V__PERIOD,V__AREA2,V__AREA1,V__YEAR,V__FRACTION] :
      ( ( s__instance(V__FRACTION,s__PositiveRealNumber)
        & s__instance(V__YEAR,s__Quantity)
        & s__instance(V__AREA1,s__GeopoliticalArea)
        & s__instance(V__AREA2,s__GeopoliticalArea)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__exportPartnerByFractionInPeriod(V__AREA1,V__AREA2,V__FRACTION,V__PERIOD)
       => lesseq(V__YEAR,"1.0") ) ) ).

fof(kb_SUMO_7826,axiom,
    s__instance(s__exportPartnerByFraction__m,s__TernaryPredicate) ).

fof(kb_SUMO_7827,axiom,
    s__domain(s__exportPartnerByFraction__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7828,axiom,
    s__domain(s__exportPartnerByFraction__m,"2",s__GeopoliticalArea) ).

fof(kb_SUMO_7829,axiom,
    s__domain(s__exportPartnerByFraction__m,"3",s__PositiveRealNumber) ).

fof(kb_SUMO_7830,axiom,
    s__documentation(s__exportPartnerByFraction__m,s__EnglishLanguage,'(&%exportPartnerByFraction ?AREA1 ?AREA2 ?FRACTION) means that the &%GeopoliticalArea ?AREA1 exports goods to &%GeopoliticalArea ?AREA2 and receives ?FRACTION of the &%exportTotalInPeriod of ?AREA1, based on U.S. dollar value of exports.') ).

fof(kb_SUMO_7831,axiom,
    ! [V__AREA2,V__AREA1,V__YEAR,V__FRACTION] :
      ( ( s__instance(V__FRACTION,s__PositiveRealNumber)
        & s__instance(V__YEAR,s__Quantity)
        & s__instance(V__AREA1,s__GeopoliticalArea)
        & s__instance(V__AREA2,s__GeopoliticalArea) )
     => ( s__exportPartnerByFraction(V__AREA1,V__AREA2,V__FRACTION)
       => lesseq(V__YEAR,"1.0") ) ) ).

%FOL fof(kb_SUMO_7832,axiom,(( (! [V__PERIOD,V__AREA2,V__AREA1,V__FRACTION] : ((s__instance(V__FRACTION,s__PositiveRealNumber) & s__instance(V__AREA1,s__GeopoliticalArea) & s__instance(V__AREA2,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__exportPartnerByFractionInPeriod(V__AREA1,V__AREA2,V__FRACTION,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__exportPartnerByFraction(V__AREA1,V__AREA2,V__FRACTION)')))))) ))).

fof(kb_SUMO_7833,axiom,
    s__instance(s__importTotalInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7834,axiom,
    s__domain(s__importTotalInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7835,axiom,
    s__domain(s__importTotalInPeriod__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7836,axiom,
    s__domainSubclass(s__importTotalInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7837,axiom,
    s__documentation(s__importTotalInPeriod__m,s__EnglishLanguage,'(&%importTotalInPeriod ?AREA ?AMOUNT ?PERIOD) means that the total value of imports to the &%GeopoliticalArea ?AREA is ?AMOUNT (in &%UnitedStatesDollars) for the &%TimeInterval indicated by ?PERIOD. Import value is calculated on a Cost, Insurance, and Freight (C.I.F.) or a Free on Board (F.O.B.) basis.') ).

fof(kb_SUMO_7838,axiom,
    s__instance(s__annualImportTotal__m,s__BinaryPredicate) ).

fof(kb_SUMO_7839,axiom,
    s__domain(s__annualImportTotal__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7840,axiom,
    s__domain(s__annualImportTotal__m,"2",s__CurrencyMeasure) ).

fof(kb_SUMO_7841,axiom,
    s__documentation(s__annualImportTotal__m,s__EnglishLanguage,'(&%annualImportTotal ?AREA ?AMOUNT) means that the total value of imports to the &%GeopoliticalArea ?AREA is ?AMOUNT (in &%UnitedStatesDollars) annually. Import value is calculated on a Cost, Insurance, and Freight (C.I.F.) or a Free on Board (F.O.B.) basis.') ).

%FOL fof(kb_SUMO_7842,axiom,(( (! [V__AMOUNT,V__PERIOD,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => ((s__importTotalInPeriod(V__AREA,V__AMOUNT,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => (? [V__YEAR] : (s__instance(V__YEAR,s__TimePosition) & s__instance(V__YEAR,V__PERIOD) & s__holdsDuring(V__YEAR,'s__annualImportTotal(V__AREA,V__AMOUNT)')))))) ))).

%FOL fof(kb_SUMO_7843,axiom,(( (! [V__AMOUNT,V__PERIOD,V__YEAR,V__AREA] : ((s__instance(V__AREA,s__GeopoliticalArea) & s__instance(V__YEAR,s__TimePosition) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass) & s__instance(V__AMOUNT,s__CurrencyMeasure)) => ((s__holdsDuring(V__YEAR,'s__annualImportTotal(V__AREA,V__AMOUNT)') & s__instance(V__YEAR,V__PERIOD) & (s__subclass(V__PERIOD,s__Year) | s__subclass(V__PERIOD,s__FiscalYearFn(V__AREA)))) => s__importTotalInPeriod(V__AREA,V__AMOUNT,V__PERIOD)))) ))).

fof(kb_SUMO_7844,axiom,
    s__instance(s__importCommodityType__m,s__BinaryPredicate) ).

fof(kb_SUMO_7845,axiom,
    s__domain(s__importCommodityType__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7846,axiom,
    s__domainSubclass(s__importCommodityType__m,"2",s__Object) ).

fof(kb_SUMO_7847,axiom,
    s__documentation(s__importCommodityType__m,s__EnglishLanguage,'(&%importCommodityType ?AREA ?TYPE) means that the &%GeopoliticalArea ?AREA imports the commodity ?TYPE.') ).

fof(kb_SUMO_7848,axiom,
    s__instance(s__importCommodityTypeByRank__m,s__TernaryPredicate) ).

fof(kb_SUMO_7849,axiom,
    s__domain(s__importCommodityTypeByRank__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7850,axiom,
    s__domainSubclass(s__importCommodityTypeByRank__m,"2",s__Object) ).

fof(kb_SUMO_7851,axiom,
    s__domain(s__importCommodityTypeByRank__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7852,axiom,
    s__documentation(s__importCommodityTypeByRank__m,s__EnglishLanguage,'(&%importCommodityTypeByRank ?AREA ?TYPE ?NTH) means that the &%GeopoliticalArea ?AREA has the commodity ?TYPE as its ?NTH most valuable import.') ).

fof(kb_SUMO_7853,axiom,
    ! [V__RANK,V__TYPE,V__AREA] :
      ( ( s__instance(V__AREA,s__GeopoliticalArea)
        & s__subclass(V__TYPE,s__Object)
        & s__instance(V__TYPE,s__SetOrClass)
        & s__instance(V__RANK,s__PositiveInteger) )
     => ( s__importCommodityTypeByRank(V__AREA,V__TYPE,V__RANK)
       => s__importCommodityType(V__AREA,V__TYPE) ) ) ).

fof(kb_SUMO_7854,axiom,
    s__instance(s__importPartnerInPeriod__m,s__TernaryPredicate) ).

fof(kb_SUMO_7855,axiom,
    s__domain(s__importPartnerInPeriod__m,"1",s__Agent) ).

fof(kb_SUMO_7856,axiom,
    s__domain(s__importPartnerInPeriod__m,"2",s__Agent) ).

fof(kb_SUMO_7857,axiom,
    s__domainSubclass(s__importPartnerInPeriod__m,"3",s__TimeInterval) ).

fof(kb_SUMO_7858,axiom,
    s__documentation(s__importPartnerInPeriod__m,s__EnglishLanguage,'(&%importPartnerInPeriod ?AGENT1 ?AGENT2 ?PERIOD) means that the &%Agent ?AGENT1 imports goods from the &%Agent ?AGENT2 during the &%TimeInterval indicated by ?PERIOD.') ).

fof(kb_SUMO_7859,axiom,
    ! [V__PERIOD,V__AGENT2,V__AGENT1] :
      ( ( s__instance(V__AGENT1,s__Agent)
        & s__instance(V__AGENT2,s__Agent)
        & s__subclass(V__PERIOD,s__TimeInterval)
        & s__instance(V__PERIOD,s__SetOrClass) )
     => ( s__importPartnerInPeriod(V__AGENT1,V__AGENT2,V__PERIOD)
       => ? [V__TIME,V__EXPORT] :
            ( s__instance(V__EXPORT,s__TimeInterval)
            & s__instance(V__EXPORT,s__Process)
            & s__instance(V__TIME,s__TimeInterval)
            & s__instance(V__TIME,V__PERIOD)
            & s__instance(V__EXPORT,s__Exporting)
            & s__overlapsTemporally(V__TIME,V__EXPORT)
            & s__origin(V__EXPORT,V__AGENT2)
            & s__destination(V__EXPORT,V__AGENT1) ) ) ) ).

fof(kb_SUMO_7860,axiom,
    s__instance(s__importPartner__m,s__BinaryPredicate) ).

fof(kb_SUMO_7861,axiom,
    s__instance(s__importPartner__m,s__IrreflexiveRelation) ).

fof(kb_SUMO_7862,axiom,
    s__domain(s__importPartner__m,"1",s__Agent) ).

fof(kb_SUMO_7863,axiom,
    s__domain(s__importPartner__m,"2",s__Agent) ).

fof(kb_SUMO_7864,axiom,
    s__documentation(s__importPartner__m,s__EnglishLanguage,'(&%importPartner ?AGENT1 ?AGENT2) means that the &%Agent ?AGENT1 imports goods from the &%Agent ?AGENT2.') ).

fof(kb_SUMO_7865,axiom,
    ! [V__AGENT2,V__AGENT1] :
      ( ( s__instance(V__AGENT1,s__Agent)
        & s__instance(V__AGENT2,s__Agent) )
     => ( s__importPartner(V__AGENT1,V__AGENT2)
       => ? [V__EXPORT] :
            ( s__instance(V__EXPORT,s__Process)
            & s__instance(V__EXPORT,s__Exporting)
            & s__origin(V__EXPORT,V__AGENT2)
            & s__destination(V__EXPORT,V__AGENT1) ) ) ) ).

%FOL fof(kb_SUMO_7866,axiom,(( (! [V__PERIOD,V__AGENT2,V__AGENT1] : ((s__instance(V__AGENT1,s__Agent) & s__instance(V__AGENT2,s__Agent) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__importPartnerInPeriod(V__AGENT1,V__AGENT2,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__importPartner(V__AGENT1,V__AGENT2)')))))) ))).

fof(kb_SUMO_7867,axiom,
    s__instance(s__importPartnerByRankInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7868,axiom,
    s__domain(s__importPartnerByRankInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7869,axiom,
    s__domain(s__importPartnerByRankInPeriod__m,"2",s__GeopoliticalArea) ).

fof(kb_SUMO_7870,axiom,
    s__domain(s__importPartnerByRankInPeriod__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7871,axiom,
    s__domainSubclass(s__importPartnerByRankInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7872,axiom,
    s__documentation(s__importPartnerByRankInPeriod__m,s__EnglishLanguage,'(&%importPartnerByRankInPeriod ?AREA1 ?AREA2 ?NTH ?PERIOD) means that the &%GeopoliticalArea ?AREA1 imports goods from &%GeopoliticalArea ?AREA2 is the ?NTH most important import partner of ?AREA1 during the &%TimeInterval ?PERIOD, based on U.S. dollar value of imports.') ).

fof(kb_SUMO_7873,axiom,
    s__instance(s__importPartnerByRank__m,s__TernaryPredicate) ).

fof(kb_SUMO_7874,axiom,
    s__domain(s__importPartnerByRank__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7875,axiom,
    s__domain(s__importPartnerByRank__m,"2",s__GeopoliticalArea) ).

fof(kb_SUMO_7876,axiom,
    s__domain(s__importPartnerByRank__m,"3",s__PositiveInteger) ).

fof(kb_SUMO_7877,axiom,
    s__documentation(s__importPartnerByRank__m,s__EnglishLanguage,'(&%importPartnerByRank ?AREA1 ?AREA2 ?NTH) means that the &%GeopoliticalArea ?AREA1 imports goods from &%GeopoliticalArea ?AREA2 is the ?NTH most important import partner of ?AREA1, based on U.S. dollar value of imports.') ).

%FOL fof(kb_SUMO_7878,axiom,(( (! [V__PERIOD,V__AREA2,V__AREA1,V__NTH] : ((s__instance(V__NTH,s__PositiveInteger) & s__instance(V__AREA1,s__GeopoliticalArea) & s__instance(V__AREA2,s__GeopoliticalArea) & s__subclass(V__PERIOD,s__TimeInterval) & s__instance(V__PERIOD,s__SetOrClass)) => (s__importPartnerByRankInPeriod(V__AREA1,V__AREA2,V__NTH,V__PERIOD) <=> (? [V__TIME] : (s__instance(V__TIME,s__TimePosition) & s__instance(V__TIME,V__PERIOD) & s__holdsDuring(V__TIME,'s__importPartnerByRank(V__AREA1,V__AREA2,V__NTH)')))))) ))).

fof(kb_SUMO_7879,axiom,
    s__instance(s__importPartnerByFractionInPeriod__m,s__QuaternaryPredicate) ).

fof(kb_SUMO_7880,axiom,
    s__domain(s__importPartnerByFractionInPeriod__m,"1",s__GeopoliticalArea) ).

fof(kb_SUMO_7881,axiom,
    s__domain(s__importPartnerByFractionInPeriod__m,"2",s__GeopoliticalArea) ).

fof(kb_SUMO_7882,axiom,
    s__domain(s__importPartnerByFractionInPeriod__m,"3",s__PositiveRealNumber) ).

fof(kb_SUMO_7883,axiom,
    s__domainSubclass(s__importPartnerByFractionInPeriod__m,"4",s__TimeInterval) ).

fof(kb_SUMO_7884,axiom,
    s__documentation(s__importPartnerByFractionInPeriod__m,s__EnglishLanguage,'(&%i