%------------------------------------------------------------------------------
% File     : ALG233+4 : TPTP v9.1.0. Released v3.4.0.
% Domain   : General Algebra
% Problem  : Algebraic Operation on Subsets of Many Sorted Sets T14
% Version  : [Urb08] axioms : Especial.
% English  :

% Refs     : [Mar97] Marasik (1997), Algebraic Operation on Subsets of Many
%          : [Urb07] Urban (2007), MPTP 0.2: Design, Implementation, and In
%          : [Urb08] Urban (2006), Email to G. Sutcliffe
% Source   : [Urb08]
% Names    : t14_closure3 [Urb08]

% Status   : Unknown
% Rating   : 1.00 v3.4.0
% Syntax   : Number of formulae    : 42823 (6323 unt;   0 def)
%            Number of atoms       : 313751 (35229 equ)
%            Maximal formula atoms :  208 (   7 avg)
%            Number of connectives : 315431 (44503   ~;3334   |;153685   &)
%                                         (7377 <=>;106532  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  150 (   8 avg)
%            Maximal term depth    :   12 (   1 avg)
%            Number of predicates  : 2353 (2351 usr;   3 prp; 0-8 aty)
%            Number of functors    : 5947 (5947 usr;1283 con; 0-10 aty)
%            Number of variables   : 120530 (114704   !;5826   ?)
% SPC      : FOF_UNK_RFO_SEQ

% Comments : Chainy large version: includes all preceding MML articles.
%          : Translated by MPTP from the Mizar Mathematical Library 4.48.930.
%          : The problem encoding is based on set theory.
%          : Infinox says this has no finite (counter-) models.
%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(antisymmetry_r2_hidden,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => ~ r2_hidden(B,A) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_tarski,axiom,
    $true ).

fof(t2_tarski,axiom,
    ! [A,B] :
      ( ! [C] :
          ( r2_hidden(C,A)
        <=> r2_hidden(C,B) )
     => A = B ) ).

fof(d1_tarski,axiom,
    ! [A,B] :
      ( B = k1_tarski(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> C = A ) ) ).

fof(d2_tarski,axiom,
    ! [A,B,C] :
      ( C = k2_tarski(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( D = A
            | D = B ) ) ) ).

fof(t3_tarski,axiom,
    $true ).

fof(t4_tarski,axiom,
    $true ).

fof(d3_tarski,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
    <=> ! [C] :
          ( r2_hidden(C,A)
         => r2_hidden(C,B) ) ) ).

fof(d4_tarski,axiom,
    ! [A,B] :
      ( B = k3_tarski(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> ? [D] :
              ( r2_hidden(C,D)
              & r2_hidden(D,A) ) ) ) ).

fof(t5_tarski,axiom,
    $true ).

fof(t6_tarski,axiom,
    $true ).

fof(t7_tarski,axiom,
    ! [A,B] :
      ~ ( r2_hidden(A,B)
        & ! [C] :
            ~ ( r2_hidden(C,B)
              & ! [D] :
                  ~ ( r2_hidden(D,B)
                    & r2_hidden(D,C) ) ) ) ).

fof(d5_tarski,axiom,
    ! [A,B] : k4_tarski(A,B) = k2_tarski(k2_tarski(A,B),k1_tarski(A)) ).

fof(t8_tarski,axiom,
    $true ).

fof(d6_tarski,axiom,
    ! [A,B] :
      ( r2_tarski(A,B)
    <=> ? [C] :
          ( ! [D] :
              ~ ( r2_hidden(D,A)
                & ! [E] :
                    ~ ( r2_hidden(E,B)
                      & r2_hidden(k4_tarski(D,E),C) ) )
          & ! [D] :
              ~ ( r2_hidden(D,B)
                & ! [E] :
                    ~ ( r2_hidden(E,A)
                      & r2_hidden(k4_tarski(E,D),C) ) )
          & ! [D,E,F,G] :
              ( ( r2_hidden(k4_tarski(D,E),C)
                & r2_hidden(k4_tarski(F,G),C) )
             => ( D = F
              <=> E = G ) ) ) ) ).

fof(t9_tarski,axiom,
    ! [A] :
    ? [B] :
      ( r2_hidden(A,B)
      & ! [C,D] :
          ( ( r2_hidden(C,B)
            & r1_tarski(D,C) )
         => r2_hidden(D,B) )
      & ! [C] :
          ~ ( r2_hidden(C,B)
            & ! [D] :
                ~ ( r2_hidden(D,B)
                  & ! [E] :
                      ( r1_tarski(E,C)
                     => r2_hidden(E,D) ) ) )
      & ! [C] :
          ~ ( r1_tarski(C,B)
            & ~ r2_tarski(C,B)
            & ~ r2_hidden(C,B) ) ) ).

fof(s1_tarski,axiom,
    ( ! [A,B,C] :
        ( ( p1_s1_tarski(A,B)
          & p1_s1_tarski(A,C) )
       => B = C )
   => ? [A] :
      ! [B] :
        ( r2_hidden(B,A)
      <=> ? [C] :
            ( r2_hidden(C,f1_s1_tarski)
            & p1_s1_tarski(C,B) ) ) ) ).

fof(reflexivity_r1_tarski,axiom,
    ! [A,B] : r1_tarski(A,A) ).

fof(dt_k1_tarski,axiom,
    $true ).

fof(dt_k2_tarski,axiom,
    $true ).

fof(commutativity_k2_tarski,axiom,
    ! [A,B] : k2_tarski(A,B) = k2_tarski(B,A) ).

fof(dt_k3_tarski,axiom,
    $true ).

fof(dt_k4_tarski,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_xboole_0,axiom,
    v1_xboole_0(k1_xboole_0) ).

fof(rc1_xboole_0,axiom,
    ? [A] : v1_xboole_0(A) ).

fof(rc2_xboole_0,axiom,
    ? [A] : ~ v1_xboole_0(A) ).

fof(fc2_xboole_0,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(A)
     => ~ v1_xboole_0(k2_xboole_0(A,B)) ) ).

fof(fc3_xboole_0,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(A)
     => ~ v1_xboole_0(k2_xboole_0(B,A)) ) ).

fof(d1_xboole_0,axiom,
    ! [A] :
      ( A = k1_xboole_0
    <=> ! [B] : ~ r2_hidden(B,A) ) ).

fof(d2_xboole_0,axiom,
    ! [A,B,C] :
      ( C = k2_xboole_0(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( r2_hidden(D,A)
            | r2_hidden(D,B) ) ) ) ).

fof(d3_xboole_0,axiom,
    ! [A,B,C] :
      ( C = k3_xboole_0(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( r2_hidden(D,A)
            & r2_hidden(D,B) ) ) ) ).

fof(d4_xboole_0,axiom,
    ! [A,B,C] :
      ( C = k4_xboole_0(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( r2_hidden(D,A)
            & ~ r2_hidden(D,B) ) ) ) ).

fof(d5_xboole_0,axiom,
    ! [A] :
      ( v1_xboole_0(A)
    <=> A = k1_xboole_0 ) ).

fof(d6_xboole_0,axiom,
    ! [A,B] : k5_xboole_0(A,B) = k2_xboole_0(k4_xboole_0(A,B),k4_xboole_0(B,A)) ).

fof(d7_xboole_0,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
    <=> k3_xboole_0(A,B) = k1_xboole_0 ) ).

fof(d8_xboole_0,axiom,
    ! [A,B] :
      ( r2_xboole_0(A,B)
    <=> ( r1_tarski(A,B)
        & A != B ) ) ).

fof(d9_xboole_0,axiom,
    ! [A,B] :
      ( r3_xboole_0(A,B)
    <=> ( r1_tarski(A,B)
        | r1_tarski(B,A) ) ) ).

fof(d10_xboole_0,axiom,
    ! [A,B] :
      ( A = B
    <=> ( r1_tarski(A,B)
        & r1_tarski(B,A) ) ) ).

fof(t1_xboole_0,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k5_xboole_0(B,C))
    <=> ~ ( r2_hidden(A,B)
        <=> r2_hidden(A,C) ) ) ).

fof(t2_xboole_0,axiom,
    ! [A,B,C] :
      ( ! [D] :
          ( ~ r2_hidden(D,A)
        <=> ( r2_hidden(D,B)
          <=> r2_hidden(D,C) ) )
     => A = k5_xboole_0(B,C) ) ).

fof(t3_xboole_0,axiom,
    ! [A,B] :
      ( ~ ( ~ r1_xboole_0(A,B)
          & ! [C] :
              ~ ( r2_hidden(C,A)
                & r2_hidden(C,B) ) )
      & ~ ( ? [C] :
              ( r2_hidden(C,A)
              & r2_hidden(C,B) )
          & r1_xboole_0(A,B) ) ) ).

fof(t4_xboole_0,axiom,
    ! [A,B] :
      ( ~ ( ~ r1_xboole_0(A,B)
          & ! [C] : ~ r2_hidden(C,k3_xboole_0(A,B)) )
      & ~ ( ? [C] : r2_hidden(C,k3_xboole_0(A,B))
          & r1_xboole_0(A,B) ) ) ).

fof(t5_xboole_0,axiom,
    ! [A,B,C] :
      ~ ( r1_xboole_0(A,B)
        & r2_hidden(C,k2_xboole_0(A,B))
        & ~ ( r2_hidden(C,A)
            & ~ r2_hidden(C,B) )
        & ~ ( r2_hidden(C,B)
            & ~ r2_hidden(C,A) ) ) ).

fof(s1_xboole_0,axiom,
    ? [A] :
    ! [B] :
      ( r2_hidden(B,A)
    <=> ( r2_hidden(B,f1_s1_xboole_0)
        & p1_s1_xboole_0(B) ) ) ).

fof(s2_xboole_0,axiom,
    ( ( ! [A] :
          ( r2_hidden(A,f1_s2_xboole_0)
        <=> p1_s2_xboole_0(A) )
      & ! [A] :
          ( r2_hidden(A,f2_s2_xboole_0)
        <=> p1_s2_xboole_0(A) ) )
   => f1_s2_xboole_0 = f2_s2_xboole_0 ) ).

fof(s3_xboole_0,axiom,
    ! [A,B] :
      ( ( ! [C] :
            ( r2_hidden(C,A)
          <=> p1_s3_xboole_0(C) )
        & ! [C] :
            ( r2_hidden(C,B)
          <=> p1_s3_xboole_0(C) ) )
     => A = B ) ).

fof(symmetry_r1_xboole_0,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
     => r1_xboole_0(B,A) ) ).

fof(irreflexivity_r2_xboole_0,axiom,
    ! [A,B] : ~ r2_xboole_0(A,A) ).

fof(antisymmetry_r2_xboole_0,axiom,
    ! [A,B] :
      ( r2_xboole_0(A,B)
     => ~ r2_xboole_0(B,A) ) ).

fof(symmetry_r3_xboole_0,axiom,
    ! [A,B] :
      ( r3_xboole_0(A,B)
     => r3_xboole_0(B,A) ) ).

fof(reflexivity_r3_xboole_0,axiom,
    ! [A,B] : r3_xboole_0(A,A) ).

fof(dt_k1_xboole_0,axiom,
    $true ).

fof(dt_k2_xboole_0,axiom,
    $true ).

fof(commutativity_k2_xboole_0,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k2_xboole_0(B,A) ).

fof(idempotence_k2_xboole_0,axiom,
    ! [A,B] : k2_xboole_0(A,A) = A ).

fof(dt_k3_xboole_0,axiom,
    $true ).

fof(commutativity_k3_xboole_0,axiom,
    ! [A,B] : k3_xboole_0(A,B) = k3_xboole_0(B,A) ).

fof(idempotence_k3_xboole_0,axiom,
    ! [A,B] : k3_xboole_0(A,A) = A ).

fof(dt_k4_xboole_0,axiom,
    $true ).

fof(dt_k5_xboole_0,axiom,
    $true ).

fof(commutativity_k5_xboole_0,axiom,
    ! [A,B] : k5_xboole_0(A,B) = k5_xboole_0(B,A) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_boole,axiom,
    ! [A] : k2_xboole_0(A,k1_xboole_0) = A ).

fof(t2_boole,axiom,
    ! [A] : k3_xboole_0(A,k1_xboole_0) = k1_xboole_0 ).

fof(t3_boole,axiom,
    ! [A] : k4_xboole_0(A,k1_xboole_0) = A ).

fof(t4_boole,axiom,
    ! [A] : k4_xboole_0(k1_xboole_0,A) = k1_xboole_0 ).

fof(t5_boole,axiom,
    ! [A] : k5_xboole_0(A,k1_xboole_0) = A ).

fof(t6_boole,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => A = k1_xboole_0 ) ).

fof(t7_boole,axiom,
    ! [A,B] :
      ~ ( r2_hidden(A,B)
        & v1_xboole_0(B) ) ).

fof(t8_boole,axiom,
    ! [A,B] :
      ~ ( v1_xboole_0(A)
        & A != B
        & v1_xboole_0(B) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(B,C) )
     => r1_tarski(A,C) ) ).

fof(t2_xboole_1,axiom,
    ! [A] : r1_tarski(k1_xboole_0,A) ).

fof(t3_xboole_1,axiom,
    ! [A] :
      ( r1_tarski(A,k1_xboole_0)
     => A = k1_xboole_0 ) ).

fof(t4_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_xboole_0(A,B),C) = k2_xboole_0(A,k2_xboole_0(B,C)) ).

fof(t5_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_xboole_0(A,B),C) = k2_xboole_0(k2_xboole_0(A,C),k2_xboole_0(B,C)) ).

fof(t6_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,k2_xboole_0(A,B)) = k2_xboole_0(A,B) ).

fof(t7_xboole_1,axiom,
    ! [A,B] : r1_tarski(A,k2_xboole_0(A,B)) ).

fof(t8_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,B) )
     => r1_tarski(k2_xboole_0(A,C),B) ) ).

fof(t9_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k2_xboole_0(A,C),k2_xboole_0(B,C)) ) ).

fof(t10_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(A,k2_xboole_0(C,B)) ) ).

fof(t11_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_xboole_0(A,B),C)
     => r1_tarski(A,C) ) ).

fof(t12_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => k2_xboole_0(A,B) = B ) ).

fof(t13_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k2_xboole_0(A,C),k2_xboole_0(B,D)) ) ).

fof(t14_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,B)
        & ! [D] :
            ( ( r1_tarski(A,D)
              & r1_tarski(C,D) )
           => r1_tarski(B,D) ) )
     => B = k2_xboole_0(A,C) ) ).

fof(t15_xboole_1,axiom,
    ! [A,B] :
      ( k2_xboole_0(A,B) = k1_xboole_0
     => A = k1_xboole_0 ) ).

fof(t16_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(k3_xboole_0(A,B),C) = k3_xboole_0(A,k3_xboole_0(B,C)) ).

fof(t17_xboole_1,axiom,
    ! [A,B] : r1_tarski(k3_xboole_0(A,B),A) ).

fof(t18_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k3_xboole_0(B,C))
     => r1_tarski(A,B) ) ).

fof(t19_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(A,C) )
     => r1_tarski(A,k3_xboole_0(B,C)) ) ).

fof(t20_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(A,C)
        & ! [D] :
            ( ( r1_tarski(D,B)
              & r1_tarski(D,C) )
           => r1_tarski(D,A) ) )
     => A = k3_xboole_0(B,C) ) ).

fof(t21_xboole_1,axiom,
    ! [A,B] : k3_xboole_0(A,k2_xboole_0(A,B)) = A ).

fof(t22_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,k3_xboole_0(A,B)) = A ).

fof(t23_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(A,k2_xboole_0(B,C)) = k2_xboole_0(k3_xboole_0(A,B),k3_xboole_0(A,C)) ).

fof(t24_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(A,k3_xboole_0(B,C)) = k3_xboole_0(k2_xboole_0(A,B),k2_xboole_0(A,C)) ).

fof(t25_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_xboole_0(k3_xboole_0(A,B),k3_xboole_0(B,C)),k3_xboole_0(C,A)) = k3_xboole_0(k3_xboole_0(k2_xboole_0(A,B),k2_xboole_0(B,C)),k2_xboole_0(C,A)) ).

fof(t26_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_xboole_0(A,C),k3_xboole_0(B,C)) ) ).

fof(t27_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k3_xboole_0(A,C),k3_xboole_0(B,D)) ) ).

fof(t28_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => k3_xboole_0(A,B) = A ) ).

fof(t29_xboole_1,axiom,
    ! [A,B,C] : r1_tarski(k3_xboole_0(A,B),k2_xboole_0(A,C)) ).

fof(t30_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => k2_xboole_0(A,k3_xboole_0(C,B)) = k3_xboole_0(k2_xboole_0(A,C),B) ) ).

fof(t31_xboole_1,axiom,
    ! [A,B,C] : r1_tarski(k2_xboole_0(k3_xboole_0(A,B),k3_xboole_0(A,C)),k2_xboole_0(B,C)) ).

fof(t32_xboole_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(A,B) = k4_xboole_0(B,A)
     => A = B ) ).

fof(t33_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_xboole_0(A,C),k4_xboole_0(B,C)) ) ).

fof(t34_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_xboole_0(C,B),k4_xboole_0(C,A)) ) ).

fof(t35_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k4_xboole_0(A,D),k4_xboole_0(B,C)) ) ).

fof(t36_xboole_1,axiom,
    ! [A,B] : r1_tarski(k4_xboole_0(A,B),A) ).

fof(t37_xboole_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(A,B) = k1_xboole_0
    <=> r1_tarski(A,B) ) ).

fof(t38_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,k4_xboole_0(B,A))
     => A = k1_xboole_0 ) ).

fof(t39_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,k4_xboole_0(B,A)) = k2_xboole_0(A,B) ).

fof(t40_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(k2_xboole_0(A,B),B) = k4_xboole_0(A,B) ).

fof(t41_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k4_xboole_0(A,B),C) = k4_xboole_0(A,k2_xboole_0(B,C)) ).

fof(t42_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k2_xboole_0(A,B),C) = k2_xboole_0(k4_xboole_0(A,C),k4_xboole_0(B,C)) ).

fof(t43_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k2_xboole_0(B,C))
     => r1_tarski(k4_xboole_0(A,B),C) ) ).

fof(t44_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k4_xboole_0(A,B),C)
     => r1_tarski(A,k2_xboole_0(B,C)) ) ).

fof(t45_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => B = k2_xboole_0(A,k4_xboole_0(B,A)) ) ).

fof(t46_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,k2_xboole_0(A,B)) = k1_xboole_0 ).

fof(t47_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,k3_xboole_0(A,B)) = k4_xboole_0(A,B) ).

fof(t48_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,k4_xboole_0(A,B)) = k3_xboole_0(A,B) ).

fof(t49_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(A,k4_xboole_0(B,C)) = k4_xboole_0(k3_xboole_0(A,B),C) ).

fof(t50_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(A,k4_xboole_0(B,C)) = k4_xboole_0(k3_xboole_0(A,B),k3_xboole_0(A,C)) ).

fof(t51_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(k3_xboole_0(A,B),k4_xboole_0(A,B)) = A ).

fof(t52_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k4_xboole_0(B,C)) = k2_xboole_0(k4_xboole_0(A,B),k3_xboole_0(A,C)) ).

fof(t53_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k2_xboole_0(B,C)) = k3_xboole_0(k4_xboole_0(A,B),k4_xboole_0(A,C)) ).

fof(t54_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k3_xboole_0(B,C)) = k2_xboole_0(k4_xboole_0(A,B),k4_xboole_0(A,C)) ).

fof(t55_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(k2_xboole_0(A,B),k3_xboole_0(A,B)) = k2_xboole_0(k4_xboole_0(A,B),k4_xboole_0(B,A)) ).

fof(t56_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r2_xboole_0(A,B)
        & r2_xboole_0(B,C) )
     => r2_xboole_0(A,C) ) ).

fof(t57_xboole_1,axiom,
    ! [A,B] :
      ~ ( r2_xboole_0(A,B)
        & r2_xboole_0(B,A) ) ).

fof(t58_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r2_xboole_0(A,B)
        & r1_tarski(B,C) )
     => r2_xboole_0(A,C) ) ).

fof(t59_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r2_xboole_0(B,C) )
     => r2_xboole_0(A,C) ) ).

fof(t60_xboole_1,axiom,
    ! [A,B] :
      ~ ( r1_tarski(A,B)
        & r2_xboole_0(B,A) ) ).

fof(t61_xboole_1,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => r2_xboole_0(k1_xboole_0,A) ) ).

fof(t62_xboole_1,axiom,
    ! [A] : ~ r2_xboole_0(A,k1_xboole_0) ).

fof(t63_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_xboole_0(B,C) )
     => r1_xboole_0(A,C) ) ).

fof(t64_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D)
        & r1_xboole_0(B,D) )
     => r1_xboole_0(A,C) ) ).

fof(t65_xboole_1,axiom,
    ! [A] : r1_xboole_0(A,k1_xboole_0) ).

fof(t66_xboole_1,axiom,
    ! [A] :
      ( ~ ( ~ r1_xboole_0(A,A)
          & A = k1_xboole_0 )
      & ~ ( A != k1_xboole_0
          & r1_xboole_0(A,A) ) ) ).

fof(t67_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(A,C)
        & r1_xboole_0(B,C) )
     => A = k1_xboole_0 ) ).

fof(t68_xboole_1,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ~ ( r1_tarski(C,A)
          & r1_tarski(C,B)
          & r1_xboole_0(A,B) ) ) ).

fof(t69_xboole_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ~ ( r1_tarski(B,A)
          & r1_xboole_0(B,A) ) ) ).

fof(t70_xboole_1,axiom,
    ! [A,B,C] :
      ( ~ ( ~ r1_xboole_0(A,k2_xboole_0(B,C))
          & r1_xboole_0(A,B)
          & r1_xboole_0(A,C) )
      & ~ ( ~ ( r1_xboole_0(A,B)
              & r1_xboole_0(A,C) )
          & r1_xboole_0(A,k2_xboole_0(B,C)) ) ) ).

fof(t71_xboole_1,axiom,
    ! [A,B,C] :
      ( ( k2_xboole_0(A,B) = k2_xboole_0(C,B)
        & r1_xboole_0(A,B)
        & r1_xboole_0(C,B) )
     => A = C ) ).

fof(t72_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( k2_xboole_0(A,B) = k2_xboole_0(C,D)
        & r1_xboole_0(C,A)
        & r1_xboole_0(D,B) )
     => C = B ) ).

fof(t73_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,k2_xboole_0(B,C))
        & r1_xboole_0(A,C) )
     => r1_tarski(A,B) ) ).

fof(t74_xboole_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r1_xboole_0(A,k3_xboole_0(B,C))
        & r1_xboole_0(A,B) ) ).

fof(t75_xboole_1,axiom,
    ! [A,B] :
      ~ ( ~ r1_xboole_0(A,B)
        & r1_xboole_0(k3_xboole_0(A,B),B) ) ).

fof(t76_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => r1_xboole_0(k3_xboole_0(C,A),k3_xboole_0(C,B)) ) ).

fof(t77_xboole_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r1_xboole_0(A,B)
        & r1_tarski(A,C)
        & r1_xboole_0(A,k3_xboole_0(B,C)) ) ).

fof(t78_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => k3_xboole_0(A,k2_xboole_0(B,C)) = k3_xboole_0(A,C) ) ).

fof(t79_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k4_xboole_0(A,B),B) ).

fof(t80_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => r1_xboole_0(A,k4_xboole_0(B,C)) ) ).

fof(t81_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,k4_xboole_0(B,C))
     => r1_xboole_0(B,k4_xboole_0(A,C)) ) ).

fof(t82_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k4_xboole_0(A,B),k4_xboole_0(B,A)) ).

fof(t83_xboole_1,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
    <=> k4_xboole_0(A,B) = A ) ).

fof(t84_xboole_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r1_xboole_0(A,B)
        & r1_xboole_0(A,C)
        & r1_xboole_0(A,k4_xboole_0(B,C)) ) ).

fof(t85_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_xboole_0(A,k4_xboole_0(C,B)) ) ).

fof(t86_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_xboole_0(A,C) )
     => r1_tarski(A,k4_xboole_0(B,C)) ) ).

fof(t87_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => k2_xboole_0(k4_xboole_0(C,A),B) = k4_xboole_0(k2_xboole_0(C,B),A) ) ).

fof(t88_xboole_1,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
     => k4_xboole_0(k2_xboole_0(A,B),B) = A ) ).

fof(t89_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k3_xboole_0(A,B),k4_xboole_0(A,B)) ).

fof(t90_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k4_xboole_0(A,k3_xboole_0(A,B)),B) ).

fof(t91_xboole_1,axiom,
    ! [A,B,C] : k5_xboole_0(k5_xboole_0(A,B),C) = k5_xboole_0(A,k5_xboole_0(B,C)) ).

fof(t92_xboole_1,axiom,
    ! [A] : k5_xboole_0(A,A) = k1_xboole_0 ).

fof(t93_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k2_xboole_0(k5_xboole_0(A,B),k3_xboole_0(A,B)) ).

fof(t94_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k5_xboole_0(k5_xboole_0(A,B),k3_xboole_0(A,B)) ).

fof(t95_xboole_1,axiom,
    ! [A,B] : k3_xboole_0(A,B) = k5_xboole_0(k5_xboole_0(A,B),k2_xboole_0(A,B)) ).

fof(t96_xboole_1,axiom,
    ! [A,B] : r1_tarski(k4_xboole_0(A,B),k5_xboole_0(A,B)) ).

fof(t97_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(k4_xboole_0(A,B),C)
        & r1_tarski(k4_xboole_0(B,A),C) )
     => r1_tarski(k5_xboole_0(A,B),C) ) ).

fof(t98_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k5_xboole_0(A,k4_xboole_0(B,A)) ).

fof(t99_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k5_xboole_0(A,B),C) = k2_xboole_0(k4_xboole_0(A,k2_xboole_0(B,C)),k4_xboole_0(B,k2_xboole_0(A,C))) ).

fof(t100_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,B) = k5_xboole_0(A,k3_xboole_0(A,B)) ).

fof(t101_xboole_1,axiom,
    ! [A,B] : k5_xboole_0(A,B) = k4_xboole_0(k2_xboole_0(A,B),k3_xboole_0(A,B)) ).

fof(t102_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k5_xboole_0(B,C)) = k2_xboole_0(k4_xboole_0(A,k2_xboole_0(B,C)),k3_xboole_0(k3_xboole_0(A,B),C)) ).

fof(t103_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k3_xboole_0(A,B),k5_xboole_0(A,B)) ).

fof(t104_xboole_1,axiom,
    ! [A,B] :
      ( ~ ( ~ r2_xboole_0(A,B)
          & A != B
          & ~ r2_xboole_0(B,A) )
    <=> r3_xboole_0(A,B) ) ).

fof(t105_xboole_1,axiom,
    ! [A,B] :
      ~ ( r2_xboole_0(A,B)
        & k4_xboole_0(B,A) = k1_xboole_0 ) ).

fof(t106_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k4_xboole_0(B,C))
     => ( r1_tarski(A,B)
        & r1_xboole_0(A,C) ) ) ).

fof(t107_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k5_xboole_0(B,C))
    <=> ( r1_tarski(A,k2_xboole_0(B,C))
        & r1_xboole_0(A,k3_xboole_0(B,C)) ) ) ).

fof(t108_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_xboole_0(A,C),B) ) ).

fof(t109_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_xboole_0(A,C),B) ) ).

fof(t110_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,B) )
     => r1_tarski(k5_xboole_0(A,C),B) ) ).

fof(t111_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k3_xboole_0(A,B),k3_xboole_0(C,B)) = k3_xboole_0(k4_xboole_0(A,C),B) ).

fof(t112_xboole_1,axiom,
    ! [A,B,C] : k5_xboole_0(k3_xboole_0(A,B),k3_xboole_0(C,B)) = k3_xboole_0(k5_xboole_0(A,C),B) ).

fof(t113_xboole_1,axiom,
    ! [A,B,C,D] : k2_xboole_0(k2_xboole_0(k2_xboole_0(A,B),C),D) = k2_xboole_0(A,k2_xboole_0(k2_xboole_0(B,C),D)) ).

fof(t114_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_xboole_0(A,D)
        & r1_xboole_0(B,D)
        & r1_xboole_0(C,D) )
     => r1_xboole_0(k2_xboole_0(k2_xboole_0(A,B),C),D) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(d1_enumset1,axiom,
    ! [A,B,C,D] :
      ( D = k1_enumset1(A,B,C)
    <=> ! [E] :
          ( r2_hidden(E,D)
        <=> ~ ( E != A
              & E != B
              & E != C ) ) ) ).

fof(d2_enumset1,axiom,
    ! [A,B,C,D,E] :
      ( E = k2_enumset1(A,B,C,D)
    <=> ! [F] :
          ( r2_hidden(F,E)
        <=> ~ ( F != A
              & F != B
              & F != C
              & F != D ) ) ) ).

fof(d3_enumset1,axiom,
    ! [A,B,C,D,E,F] :
      ( F = k3_enumset1(A,B,C,D,E)
    <=> ! [G] :
          ( r2_hidden(G,F)
        <=> ~ ( G != A
              & G != B
              & G != C
              & G != D
              & G != E ) ) ) ).

fof(d4_enumset1,axiom,
    ! [A,B,C,D,E,F,G] :
      ( G = k4_enumset1(A,B,C,D,E,F)
    <=> ! [H] :
          ( r2_hidden(H,G)
        <=> ~ ( H != A
              & H != B
              & H != C
              & H != D
              & H != E
              & H != F ) ) ) ).

fof(d5_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( H = k5_enumset1(A,B,C,D,E,F,G)
    <=> ! [I] :
          ( r2_hidden(I,H)
        <=> ~ ( I != A
              & I != B
              & I != C
              & I != D
              & I != E
              & I != F
              & I != G ) ) ) ).

fof(d6_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H,I] :
      ( I = k6_enumset1(A,B,C,D,E,F,G,H)
    <=> ! [J] :
          ( r2_hidden(J,I)
        <=> ~ ( J != A
              & J != B
              & J != C
              & J != D
              & J != E
              & J != F
              & J != G
              & J != H ) ) ) ).

fof(t1_enumset1,axiom,
    $true ).

fof(t2_enumset1,axiom,
    $true ).

fof(t3_enumset1,axiom,
    $true ).

fof(t4_enumset1,axiom,
    $true ).

fof(t5_enumset1,axiom,
    $true ).

fof(t6_enumset1,axiom,
    $true ).

fof(t7_enumset1,axiom,
    $true ).

fof(t8_enumset1,axiom,
    $true ).

fof(t9_enumset1,axiom,
    $true ).

fof(t10_enumset1,axiom,
    $true ).

fof(t11_enumset1,axiom,
    $true ).

fof(t12_enumset1,axiom,
    $true ).

fof(t13_enumset1,axiom,
    $true ).

fof(t14_enumset1,axiom,
    $true ).

fof(t15_enumset1,axiom,
    $true ).

fof(t16_enumset1,axiom,
    $true ).

fof(t17_enumset1,axiom,
    $true ).

fof(t18_enumset1,axiom,
    $true ).

fof(t19_enumset1,axiom,
    $true ).

fof(t20_enumset1,axiom,
    $true ).

fof(t21_enumset1,axiom,
    $true ).

fof(t22_enumset1,axiom,
    $true ).

fof(t23_enumset1,axiom,
    $true ).

fof(t24_enumset1,axiom,
    $true ).

fof(t25_enumset1,axiom,
    $true ).

fof(t26_enumset1,axiom,
    $true ).

fof(t27_enumset1,axiom,
    $true ).

fof(t28_enumset1,axiom,
    $true ).

fof(t29_enumset1,axiom,
    $true ).

fof(t30_enumset1,axiom,
    $true ).

fof(t31_enumset1,axiom,
    $true ).

fof(t32_enumset1,axiom,
    $true ).

fof(t33_enumset1,axiom,
    $true ).

fof(t34_enumset1,axiom,
    $true ).

fof(t35_enumset1,axiom,
    $true ).

fof(t36_enumset1,axiom,
    $true ).

fof(t37_enumset1,axiom,
    $true ).

fof(t38_enumset1,axiom,
    $true ).

fof(t39_enumset1,axiom,
    $true ).

fof(t40_enumset1,axiom,
    $true ).

fof(t41_enumset1,axiom,
    ! [A,B] : k2_tarski(A,B) = k2_xboole_0(k1_tarski(A),k1_tarski(B)) ).

fof(t42_enumset1,axiom,
    ! [A,B,C] : k1_enumset1(A,B,C) = k2_xboole_0(k1_tarski(A),k2_tarski(B,C)) ).

fof(t43_enumset1,axiom,
    ! [A,B,C] : k1_enumset1(A,B,C) = k2_xboole_0(k2_tarski(A,B),k1_tarski(C)) ).

fof(t44_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_xboole_0(k1_tarski(A),k1_enumset1(B,C,D)) ).

fof(t45_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_xboole_0(k2_tarski(A,B),k2_tarski(C,D)) ).

fof(t46_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_xboole_0(k1_enumset1(A,B,C),k1_tarski(D)) ).

fof(t47_enumset1,axiom,
    ! [A,B,C,D,E] : k3_enumset1(A,B,C,D,E) = k2_xboole_0(k1_tarski(A),k2_enumset1(B,C,D,E)) ).

fof(t48_enumset1,axiom,
    ! [A,B,C,D,E] : k3_enumset1(A,B,C,D,E) = k2_xboole_0(k2_tarski(A,B),k1_enumset1(C,D,E)) ).

fof(t49_enumset1,axiom,
    ! [A,B,C,D,E] : k3_enumset1(A,B,C,D,E) = k2_xboole_0(k1_enumset1(A,B,C),k2_tarski(D,E)) ).

fof(t50_enumset1,axiom,
    ! [A,B,C,D,E] : k3_enumset1(A,B,C,D,E) = k2_xboole_0(k2_enumset1(A,B,C,D),k1_tarski(E)) ).

fof(t51_enumset1,axiom,
    ! [A,B,C,D,E,F] : k4_enumset1(A,B,C,D,E,F) = k2_xboole_0(k1_tarski(A),k3_enumset1(B,C,D,E,F)) ).

fof(t52_enumset1,axiom,
    ! [A,B,C,D,E,F] : k4_enumset1(A,B,C,D,E,F) = k2_xboole_0(k2_tarski(A,B),k2_enumset1(C,D,E,F)) ).

fof(t53_enumset1,axiom,
    ! [A,B,C,D,E,F] : k4_enumset1(A,B,C,D,E,F) = k2_xboole_0(k1_enumset1(A,B,C),k1_enumset1(D,E,F)) ).

fof(t54_enumset1,axiom,
    ! [A,B,C,D,E,F] : k4_enumset1(A,B,C,D,E,F) = k2_xboole_0(k2_enumset1(A,B,C,D),k2_tarski(E,F)) ).

fof(t55_enumset1,axiom,
    ! [A,B,C,D,E,F] : k4_enumset1(A,B,C,D,E,F) = k2_xboole_0(k3_enumset1(A,B,C,D,E),k1_tarski(F)) ).

fof(t56_enumset1,axiom,
    ! [A,B,C,D,E,F,G] : k5_enumset1(A,B,C,D,E,F,G) = k2_xboole_0(k1_tarski(A),k4_enumset1(B,C,D,E,F,G)) ).

fof(t57_enumset1,axiom,
    ! [A,B,C,D,E,F,G] : k5_enumset1(A,B,C,D,E,F,G) = k2_xboole_0(k2_tarski(A,B),k3_enumset1(C,D,E,F,G)) ).

fof(t58_enumset1,axiom,
    ! [A,B,C,D,E,F,G] : k5_enumset1(A,B,C,D,E,F,G) = k2_xboole_0(k1_enumset1(A,B,C),k2_enumset1(D,E,F,G)) ).

fof(t59_enumset1,axiom,
    ! [A,B,C,D,E,F,G] : k5_enumset1(A,B,C,D,E,F,G) = k2_xboole_0(k2_enumset1(A,B,C,D),k1_enumset1(E,F,G)) ).

fof(t60_enumset1,axiom,
    ! [A,B,C,D,E,F,G] : k5_enumset1(A,B,C,D,E,F,G) = k2_xboole_0(k3_enumset1(A,B,C,D,E),k2_tarski(F,G)) ).

fof(t61_enumset1,axiom,
    ! [A,B,C,D,E,F,G] : k5_enumset1(A,B,C,D,E,F,G) = k2_xboole_0(k4_enumset1(A,B,C,D,E,F),k1_tarski(G)) ).

fof(t62_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] : k6_enumset1(A,B,C,D,E,F,G,H) = k2_xboole_0(k1_tarski(A),k5_enumset1(B,C,D,E,F,G,H)) ).

fof(t63_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] : k6_enumset1(A,B,C,D,E,F,G,H) = k2_xboole_0(k2_tarski(A,B),k4_enumset1(C,D,E,F,G,H)) ).

fof(t64_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] : k6_enumset1(A,B,C,D,E,F,G,H) = k2_xboole_0(k1_enumset1(A,B,C),k3_enumset1(D,E,F,G,H)) ).

fof(t65_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] : k6_enumset1(A,B,C,D,E,F,G,H) = k2_xboole_0(k2_enumset1(A,B,C,D),k2_enumset1(E,F,G,H)) ).

fof(t66_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] : k6_enumset1(A,B,C,D,E,F,G,H) = k2_xboole_0(k3_enumset1(A,B,C,D,E),k1_enumset1(F,G,H)) ).

fof(t67_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] : k6_enumset1(A,B,C,D,E,F,G,H) = k2_xboole_0(k4_enumset1(A,B,C,D,E,F),k2_tarski(G,H)) ).

fof(t68_enumset1,axiom,
    ! [A,B,C,D,E,F,G,H] : k6_enumset1(A,B,C,D,E,F,G,H) = k2_xboole_0(k5_enumset1(A,B,C,D,E,F,G),k1_tarski(H)) ).

fof(t69_enumset1,axiom,
    ! [A] : k2_tarski(A,A) = k1_tarski(A) ).

fof(t70_enumset1,axiom,
    ! [A,B] : k1_enumset1(A,A,B) = k2_tarski(A,B) ).

fof(t71_enumset1,axiom,
    ! [A,B,C] : k2_enumset1(A,A,B,C) = k1_enumset1(A,B,C) ).

fof(t72_enumset1,axiom,
    ! [A,B,C,D] : k3_enumset1(A,A,B,C,D) = k2_enumset1(A,B,C,D) ).

fof(t73_enumset1,axiom,
    ! [A,B,C,D,E] : k4_enumset1(A,A,B,C,D,E) = k3_enumset1(A,B,C,D,E) ).

fof(t74_enumset1,axiom,
    ! [A,B,C,D,E,F] : k5_enumset1(A,A,B,C,D,E,F) = k4_enumset1(A,B,C,D,E,F) ).

fof(t75_enumset1,axiom,
    ! [A,B,C,D,E,F,G] : k6_enumset1(A,A,B,C,D,E,F,G) = k5_enumset1(A,B,C,D,E,F,G) ).

fof(t76_enumset1,axiom,
    ! [A] : k1_enumset1(A,A,A) = k1_tarski(A) ).

fof(t77_enumset1,axiom,
    ! [A,B] : k2_enumset1(A,A,A,B) = k2_tarski(A,B) ).

fof(t78_enumset1,axiom,
    ! [A,B,C] : k3_enumset1(A,A,A,B,C) = k1_enumset1(A,B,C) ).

fof(t79_enumset1,axiom,
    ! [A,B,C,D] : k4_enumset1(A,A,A,B,C,D) = k2_enumset1(A,B,C,D) ).

fof(t80_enumset1,axiom,
    ! [A,B,C,D,E] : k5_enumset1(A,A,A,B,C,D,E) = k3_enumset1(A,B,C,D,E) ).

fof(t81_enumset1,axiom,
    ! [A,B,C,D,E,F] : k6_enumset1(A,A,A,B,C,D,E,F) = k4_enumset1(A,B,C,D,E,F) ).

fof(t82_enumset1,axiom,
    ! [A] : k2_enumset1(A,A,A,A) = k1_tarski(A) ).

fof(t83_enumset1,axiom,
    ! [A,B] : k3_enumset1(A,A,A,A,B) = k2_tarski(A,B) ).

fof(t84_enumset1,axiom,
    ! [A,B,C] : k4_enumset1(A,A,A,A,B,C) = k1_enumset1(A,B,C) ).

fof(t85_enumset1,axiom,
    ! [A,B,C,D] : k5_enumset1(A,A,A,A,B,C,D) = k2_enumset1(A,B,C,D) ).

fof(t86_enumset1,axiom,
    ! [A,B,C,D,E] : k6_enumset1(A,A,A,A,B,C,D,E) = k3_enumset1(A,B,C,D,E) ).

fof(t87_enumset1,axiom,
    ! [A] : k3_enumset1(A,A,A,A,A) = k1_tarski(A) ).

fof(t88_enumset1,axiom,
    ! [A,B] : k4_enumset1(A,A,A,A,A,B) = k2_tarski(A,B) ).

fof(t89_enumset1,axiom,
    ! [A,B,C] : k5_enumset1(A,A,A,A,A,B,C) = k1_enumset1(A,B,C) ).

fof(t90_enumset1,axiom,
    ! [A,B,C,D] : k6_enumset1(A,A,A,A,A,B,C,D) = k2_enumset1(A,B,C,D) ).

fof(t91_enumset1,axiom,
    ! [A] : k4_enumset1(A,A,A,A,A,A) = k1_tarski(A) ).

fof(t92_enumset1,axiom,
    ! [A,B] : k5_enumset1(A,A,A,A,A,A,B) = k2_tarski(A,B) ).

fof(t93_enumset1,axiom,
    ! [A,B,C] : k6_enumset1(A,A,A,A,A,A,B,C) = k1_enumset1(A,B,C) ).

fof(t94_enumset1,axiom,
    ! [A] : k5_enumset1(A,A,A,A,A,A,A) = k1_tarski(A) ).

fof(t95_enumset1,axiom,
    ! [A,B] : k6_enumset1(A,A,A,A,A,A,A,B) = k2_tarski(A,B) ).

fof(t96_enumset1,axiom,
    ! [A] : k6_enumset1(A,A,A,A,A,A,A,A) = k1_tarski(A) ).

fof(t97_enumset1,axiom,
    $true ).

fof(t98_enumset1,axiom,
    ! [A,B,C] : k1_enumset1(A,B,C) = k1_enumset1(A,C,B) ).

fof(t99_enumset1,axiom,
    ! [A,B,C] : k1_enumset1(A,B,C) = k1_enumset1(B,A,C) ).

fof(t100_enumset1,axiom,
    ! [A,B,C] : k1_enumset1(A,B,C) = k1_enumset1(B,C,A) ).

fof(t101_enumset1,axiom,
    $true ).

fof(t102_enumset1,axiom,
    ! [A,B,C] : k1_enumset1(A,B,C) = k1_enumset1(C,B,A) ).

fof(t103_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(A,B,D,C) ).

fof(t104_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(A,C,B,D) ).

fof(t105_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(A,C,D,B) ).

fof(t106_enumset1,axiom,
    $true ).

fof(t107_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(A,D,C,B) ).

fof(t108_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(B,A,C,D) ).

fof(t109_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(B,A,D,C) ).

fof(t110_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(B,C,A,D) ).

fof(t111_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(B,C,D,A) ).

fof(t112_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(B,D,A,C) ).

fof(t113_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(B,D,C,A) ).

fof(t114_enumset1,axiom,
    $true ).

fof(t115_enumset1,axiom,
    $true ).

fof(t116_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(C,B,A,D) ).

fof(t117_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(C,B,D,A) ).

fof(t118_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(C,D,A,B) ).

fof(t119_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(C,D,B,A) ).

fof(t120_enumset1,axiom,
    $true ).

fof(t121_enumset1,axiom,
    $true ).

fof(t122_enumset1,axiom,
    $true ).

fof(t123_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(D,B,C,A) ).

fof(t124_enumset1,axiom,
    $true ).

fof(t125_enumset1,axiom,
    ! [A,B,C,D] : k2_enumset1(A,B,C,D) = k2_enumset1(D,C,B,A) ).

fof(dt_k1_enumset1,axiom,
    $true ).

fof(dt_k2_enumset1,axiom,
    $true ).

fof(dt_k3_enumset1,axiom,
    $true ).

fof(dt_k4_enumset1,axiom,
    $true ).

fof(dt_k5_enumset1,axiom,
    $true ).

fof(dt_k6_enumset1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_zfmisc_1,axiom,
    ! [A,B] : ~ v1_xboole_0(k4_tarski(A,B)) ).

fof(d1_zfmisc_1,axiom,
    ! [A,B] :
      ( B = k1_zfmisc_1(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> r1_tarski(C,A) ) ) ).

fof(d2_zfmisc_1,axiom,
    ! [A,B,C] :
      ( C = k2_zfmisc_1(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E,F] :
              ( r2_hidden(E,A)
              & r2_hidden(F,B)
              & D = k4_tarski(E,F) ) ) ) ).

fof(d3_zfmisc_1,axiom,
    ! [A,B,C] : k3_zfmisc_1(A,B,C) = k2_zfmisc_1(k2_zfmisc_1(A,B),C) ).

fof(d4_zfmisc_1,axiom,
    ! [A,B,C,D] : k4_zfmisc_1(A,B,C,D) = k2_zfmisc_1(k3_zfmisc_1(A,B,C),D) ).

fof(t1_zfmisc_1,axiom,
    k1_zfmisc_1(k1_xboole_0) = k1_tarski(k1_xboole_0) ).

fof(t2_zfmisc_1,axiom,
    k3_tarski(k1_xboole_0) = k1_xboole_0 ).

fof(t3_zfmisc_1,axiom,
    $true ).

fof(t4_zfmisc_1,axiom,
    $true ).

fof(t5_zfmisc_1,axiom,
    $true ).

fof(t6_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_tarski(A),k1_tarski(B))
     => A = B ) ).

fof(t7_zfmisc_1,axiom,
    $true ).

fof(t8_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k1_tarski(A) = k2_tarski(B,C)
     => A = B ) ).

fof(t9_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k1_tarski(A) = k2_tarski(B,C)
     => B = C ) ).

fof(t10_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ~ ( k2_tarski(A,B) = k2_tarski(C,D)
        & A != C
        & A != D ) ).

fof(t11_zfmisc_1,axiom,
    $true ).

fof(t12_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k1_tarski(A),k2_tarski(A,B)) ).

fof(t13_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_tarski(A)
     => A = B ) ).

fof(t14_zfmisc_1,axiom,
    ! [A,B] : k2_xboole_0(k1_tarski(A),k2_tarski(A,B)) = k2_tarski(A,B) ).

fof(t15_zfmisc_1,axiom,
    $true ).

fof(t16_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( r1_xboole_0(k1_tarski(A),k1_tarski(B))
        & A = B ) ).

fof(t17_zfmisc_1,axiom,
    ! [A,B] :
      ( A != B
     => r1_xboole_0(k1_tarski(A),k1_tarski(B)) ) ).

fof(t18_zfmisc_1,axiom,
    ! [A,B] :
      ( k3_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_tarski(A)
     => A = B ) ).

fof(t19_zfmisc_1,axiom,
    ! [A,B] : k3_xboole_0(k1_tarski(A),k2_tarski(A,B)) = k1_tarski(A) ).

fof(t20_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_tarski(A)
    <=> A != B ) ).

fof(t21_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_xboole_0
     => A = B ) ).

fof(t22_zfmisc_1,axiom,
    ! [A,B] : k4_xboole_0(k1_tarski(A),k2_tarski(A,B)) = k1_xboole_0 ).

fof(t23_zfmisc_1,axiom,
    ! [A,B] :
      ( A != B
     => k4_xboole_0(k2_tarski(A,B),k1_tarski(B)) = k1_tarski(A) ) ).

fof(t24_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_tarski(A),k1_tarski(B))
     => A = B ) ).

fof(t25_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( r1_tarski(k1_tarski(A),k2_tarski(B,C))
        & A != B
        & A != C ) ).

fof(t26_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_tarski(A,B),k1_tarski(C))
     => A = C ) ).

fof(t27_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_tarski(A,B),k1_tarski(C))
     => k2_tarski(A,B) = k1_tarski(C) ) ).

fof(t28_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ~ ( r1_tarski(k2_tarski(A,B),k2_tarski(C,D))
        & A != C
        & A != D ) ).

fof(t29_zfmisc_1,axiom,
    ! [A,B] :
      ( A != B
     => k5_xboole_0(k1_tarski(A),k1_tarski(B)) = k2_tarski(A,B) ) ).

fof(t30_zfmisc_1,axiom,
    ! [A] : k1_zfmisc_1(k1_tarski(A)) = k2_tarski(k1_xboole_0,k1_tarski(A)) ).

fof(t31_zfmisc_1,axiom,
    ! [A] : k3_tarski(k1_tarski(A)) = A ).

fof(t32_zfmisc_1,axiom,
    ! [A,B] : k3_tarski(k2_tarski(k1_tarski(A),k1_tarski(B))) = k2_tarski(A,B) ).

fof(t33_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( k4_tarski(A,B) = k4_tarski(C,D)
     => ( A = C
        & B = D ) ) ).

fof(t34_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(k1_tarski(C),k1_tarski(D)))
    <=> ( A = C
        & B = D ) ) ).

fof(t35_zfmisc_1,axiom,
    ! [A,B] : k2_zfmisc_1(k1_tarski(A),k1_tarski(B)) = k1_tarski(k4_tarski(A,B)) ).

fof(t36_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k1_tarski(A),k2_tarski(B,C)) = k2_tarski(k4_tarski(A,B),k4_tarski(A,C))
      & k2_zfmisc_1(k2_tarski(A,B),k1_tarski(C)) = k2_tarski(k4_tarski(A,C),k4_tarski(B,C)) ) ).

fof(t37_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_tarski(A),B)
    <=> r2_hidden(A,B) ) ).

fof(t38_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_tarski(A,B),C)
    <=> ( r2_hidden(A,C)
        & r2_hidden(B,C) ) ) ).

fof(t39_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,k1_tarski(B))
    <=> ( A = k1_xboole_0
        | A = k1_tarski(B) ) ) ).

fof(t40_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => ( r2_hidden(C,A)
        | r1_tarski(A,k4_xboole_0(B,k1_tarski(C))) ) ) ).

fof(t41_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( A != k1_tarski(B)
        & A != k1_xboole_0
        & ! [C] :
            ~ ( r2_hidden(C,A)
              & C != B ) ) ).

fof(t42_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k2_tarski(B,C))
    <=> ~ ( A != k1_xboole_0
          & A != k1_tarski(B)
          & A != k1_tarski(C)
          & A != k2_tarski(B,C) ) ) ).

fof(t43_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k1_tarski(A) = k2_xboole_0(B,C)
        & ~ ( B = k1_tarski(A)
            & C = k1_tarski(A) )
        & ~ ( B = k1_xboole_0
            & C = k1_tarski(A) )
        & ~ ( B = k1_tarski(A)
            & C = k1_xboole_0 ) ) ).

fof(t44_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k1_tarski(A) = k2_xboole_0(B,C)
        & B != C
        & B != k1_xboole_0
        & C != k1_xboole_0 ) ).

fof(t45_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k2_xboole_0(k1_tarski(A),B),B)
     => r2_hidden(A,B) ) ).

fof(t46_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => k2_xboole_0(k1_tarski(A),B) = B ) ).

fof(t47_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_xboole_0(k2_tarski(A,B),C),C)
     => r2_hidden(A,C) ) ).

fof(t48_zfmisc_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & r2_hidden(C,B) )
     => k2_xboole_0(k2_tarski(A,C),B) = B ) ).

fof(t49_zfmisc_1,axiom,
    ! [A,B] : k2_xboole_0(k1_tarski(A),B) != k1_xboole_0 ).

fof(t50_zfmisc_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_tarski(A,B),C) != k1_xboole_0 ).

fof(t51_zfmisc_1,axiom,
    ! [A,B] :
      ( k3_xboole_0(A,k1_tarski(B)) = k1_tarski(B)
     => r2_hidden(B,A) ) ).

fof(t52_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => k3_xboole_0(B,k1_tarski(A)) = k1_tarski(A) ) ).

fof(t53_zfmisc_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & r2_hidden(C,B) )
     => k3_xboole_0(k2_tarski(A,C),B) = k2_tarski(A,C) ) ).

fof(t54_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( r1_xboole_0(k1_tarski(A),B)
        & r2_hidden(A,B) ) ).

fof(t55_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( r1_xboole_0(k2_tarski(A,B),C)
        & r2_hidden(A,C) ) ).

fof(t56_zfmisc_1,axiom,
    ! [A,B] :
      ( ~ r2_hidden(A,B)
     => r1_xboole_0(k1_tarski(A),B) ) ).

fof(t57_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r2_hidden(A,B)
        & ~ r2_hidden(C,B)
        & ~ r1_xboole_0(k2_tarski(A,C),B) ) ).

fof(t58_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_xboole_0(k1_tarski(A),B)
      | k3_xboole_0(k1_tarski(A),B) = k1_tarski(A) ) ).

fof(t59_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k3_xboole_0(k2_tarski(A,B),C) = k1_tarski(A)
        & r2_hidden(B,C)
        & A != B ) ).

fof(t60_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,B)
     => ( ( r2_hidden(C,B)
          & A != C )
        | k3_xboole_0(k2_tarski(A,C),B) = k1_tarski(A) ) ) ).

fof(t61_zfmisc_1,axiom,
    $true ).

fof(t62_zfmisc_1,axiom,
    $true ).

fof(t63_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k3_xboole_0(k2_tarski(A,B),C) = k2_tarski(A,B)
     => r2_hidden(A,C) ) ).

fof(t64_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k4_xboole_0(B,k1_tarski(C)))
    <=> ( r2_hidden(A,B)
        & A != C ) ) ).

fof(t65_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(A,k1_tarski(B)) = A
    <=> ~ r2_hidden(B,A) ) ).

fof(t66_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( k4_xboole_0(A,k1_tarski(B)) = k1_xboole_0
        & A != k1_xboole_0
        & A != k1_tarski(B) ) ).

fof(t67_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),B) = k1_tarski(A)
    <=> ~ r2_hidden(A,B) ) ).

fof(t68_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),B) = k1_xboole_0
    <=> r2_hidden(A,B) ) ).

fof(t69_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),B) = k1_xboole_0
      | k4_xboole_0(k1_tarski(A),B) = k1_tarski(A) ) ).

fof(t70_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(k2_tarski(A,B),C) = k1_tarski(A)
    <=> ( ~ r2_hidden(A,C)
        & ( r2_hidden(B,C)
          | A = B ) ) ) ).

fof(t71_zfmisc_1,axiom,
    $true ).

fof(t72_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(k2_tarski(A,B),C) = k2_tarski(A,B)
    <=> ( ~ r2_hidden(A,C)
        & ~ r2_hidden(B,C) ) ) ).

fof(t73_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(k2_tarski(A,B),C) = k1_xboole_0
    <=> ( r2_hidden(A,C)
        & r2_hidden(B,C) ) ) ).

fof(t74_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k4_xboole_0(k2_tarski(A,B),C) != k1_xboole_0
        & k4_xboole_0(k2_tarski(A,B),C) != k1_tarski(A)
        & k4_xboole_0(k2_tarski(A,B),C) != k1_tarski(B)
        & k4_xboole_0(k2_tarski(A,B),C) != k2_tarski(A,B) ) ).

fof(t75_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(A,k2_tarski(B,C)) = k1_xboole_0
    <=> ~ ( A != k1_xboole_0
          & A != k1_tarski(B)
          & A != k1_tarski(C)
          & A != k2_tarski(B,C) ) ) ).

fof(t76_zfmisc_1,axiom,
    $true ).

fof(t77_zfmisc_1,axiom,
    $true ).

fof(t78_zfmisc_1,axiom,
    $true ).

fof(t79_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k1_zfmisc_1(A),k1_zfmisc_1(B)) ) ).

fof(t80_zfmisc_1,axiom,
    ! [A] : r1_tarski(k1_tarski(A),k1_zfmisc_1(A)) ).

fof(t81_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k2_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)),k1_zfmisc_1(k2_xboole_0(A,B))) ).

fof(t82_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)) = k1_zfmisc_1(k2_xboole_0(A,B))
     => r3_xboole_0(A,B) ) ).

fof(t83_zfmisc_1,axiom,
    ! [A,B] : k1_zfmisc_1(k3_xboole_0(A,B)) = k3_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)) ).

fof(t84_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k1_zfmisc_1(k4_xboole_0(A,B)),k2_xboole_0(k1_tarski(k1_xboole_0),k4_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)))) ).

fof(t85_zfmisc_1,axiom,
    $true ).

fof(t86_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k2_xboole_0(k1_zfmisc_1(k4_xboole_0(A,B)),k1_zfmisc_1(k4_xboole_0(B,A))),k1_zfmisc_1(k5_xboole_0(A,B))) ).

fof(t87_zfmisc_1,axiom,
    $true ).

fof(t88_zfmisc_1,axiom,
    $true ).

fof(t89_zfmisc_1,axiom,
    $true ).

fof(t90_zfmisc_1,axiom,
    $true ).

fof(t91_zfmisc_1,axiom,
    $true ).

fof(t92_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => r1_tarski(A,k3_tarski(B)) ) ).

fof(t93_zfmisc_1,axiom,
    ! [A,B] : k3_tarski(k2_tarski(A,B)) = k2_xboole_0(A,B) ).

fof(t94_zfmisc_1,axiom,
    ! [A,B] :
      ( ! [C] :
          ( r2_hidden(C,A)
         => r1_tarski(C,B) )
     => r1_tarski(k3_tarski(A),B) ) ).

fof(t95_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_tarski(A),k3_tarski(B)) ) ).

fof(t96_zfmisc_1,axiom,
    ! [A,B] : k3_tarski(k2_xboole_0(A,B)) = k2_xboole_0(k3_tarski(A),k3_tarski(B)) ).

fof(t97_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k3_tarski(k3_xboole_0(A,B)),k3_xboole_0(k3_tarski(A),k3_tarski(B))) ).

fof(t98_zfmisc_1,axiom,
    ! [A,B] :
      ( ! [C] :
          ( r2_hidden(C,A)
         => r1_xboole_0(C,B) )
     => r1_xboole_0(k3_tarski(A),B) ) ).

fof(t99_zfmisc_1,axiom,
    ! [A] : k3_tarski(k1_zfmisc_1(A)) = A ).

fof(t100_zfmisc_1,axiom,
    ! [A] : r1_tarski(A,k1_zfmisc_1(k3_tarski(A))) ).

fof(t101_zfmisc_1,axiom,
    ! [A,B] :
      ( ! [C,D] :
          ( ( r2_hidden(C,k2_xboole_0(A,B))
            & r2_hidden(D,k2_xboole_0(A,B)) )
         => ( C = D
            | r1_xboole_0(C,D) ) )
     => k3_tarski(k3_xboole_0(A,B)) = k3_xboole_0(k3_tarski(A),k3_tarski(B)) ) ).

fof(t102_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( r2_hidden(A,k2_zfmisc_1(B,C))
        & ! [D,E] : k4_tarski(D,E) != A ) ).

fof(t103_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ~ ( r1_tarski(A,k2_zfmisc_1(B,C))
        & r2_hidden(D,A)
        & ! [E,F] :
            ~ ( r2_hidden(E,B)
              & r2_hidden(F,C)
              & D = k4_tarski(E,F) ) ) ).

fof(t104_zfmisc_1,axiom,
    ! [A,B,C,D,E] :
      ~ ( r2_hidden(A,k3_xboole_0(k2_zfmisc_1(B,C),k2_zfmisc_1(D,E)))
        & ! [F,G] :
            ~ ( A = k4_tarski(F,G)
              & r2_hidden(F,k3_xboole_0(B,D))
              & r2_hidden(G,k3_xboole_0(C,E)) ) ) ).

fof(t105_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k2_zfmisc_1(A,B),k1_zfmisc_1(k1_zfmisc_1(k2_xboole_0(A,B)))) ).

fof(t106_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(C,D))
    <=> ( r2_hidden(A,C)
        & r2_hidden(B,D) ) ) ).

fof(t107_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(C,D))
     => r2_hidden(k4_tarski(B,A),k2_zfmisc_1(D,C)) ) ).

fof(t108_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ! [E,F] :
          ( r2_hidden(k4_tarski(E,F),k2_zfmisc_1(A,B))
        <=> r2_hidden(k4_tarski(E,F),k2_zfmisc_1(C,D)) )
     => k2_zfmisc_1(A,B) = k2_zfmisc_1(C,D) ) ).

fof(t109_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,k2_zfmisc_1(B,C))
        & ! [E,F] :
            ( r2_hidden(k4_tarski(E,F),A)
           => r2_hidden(k4_tarski(E,F),D) ) )
     => r1_tarski(A,D) ) ).

fof(t110_zfmisc_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( r1_tarski(A,k2_zfmisc_1(B,C))
        & r1_tarski(D,k2_zfmisc_1(E,F))
        & ! [G,H] :
            ( r2_hidden(k4_tarski(G,H),A)
          <=> r2_hidden(k4_tarski(G,H),D) ) )
     => A = D ) ).

fof(t111_zfmisc_1,axiom,
    ! [A,B] :
      ( ( ! [C] :
            ~ ( r2_hidden(C,A)
              & ! [D,E] : C != k4_tarski(D,E) )
        & ! [C,D] :
            ( r2_hidden(k4_tarski(C,D),A)
           => r2_hidden(k4_tarski(C,D),B) ) )
     => r1_tarski(A,B) ) ).

fof(t112_zfmisc_1,axiom,
    ! [A,B] :
      ( ( ! [C] :
            ~ ( r2_hidden(C,A)
              & ! [D,E] : C != k4_tarski(D,E) )
        & ! [C] :
            ~ ( r2_hidden(C,B)
              & ! [D,E] : C != k4_tarski(D,E) )
        & ! [C,D] :
            ( r2_hidden(k4_tarski(C,D),A)
          <=> r2_hidden(k4_tarski(C,D),B) ) )
     => A = B ) ).

fof(t113_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_zfmisc_1(A,B) = k1_xboole_0
    <=> ( A = k1_xboole_0
        | B = k1_xboole_0 ) ) ).

fof(t114_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_zfmisc_1(A,B) = k2_zfmisc_1(B,A)
     => ( A = k1_xboole_0
        | B = k1_xboole_0
        | A = B ) ) ).

fof(t115_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_zfmisc_1(A,A) = k2_zfmisc_1(B,B)
     => A = B ) ).

fof(t116_zfmisc_1,axiom,
    ! [A] :
      ( r1_tarski(A,k2_zfmisc_1(A,A))
     => A = k1_xboole_0 ) ).

fof(t117_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & ( r1_tarski(k2_zfmisc_1(B,A),k2_zfmisc_1(C,A))
          | r1_tarski(k2_zfmisc_1(A,B),k2_zfmisc_1(A,C)) )
        & ~ r1_tarski(B,C) ) ).

fof(t118_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => ( r1_tarski(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
        & r1_tarski(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ) ).

fof(t119_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ) ).

fof(t120_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k2_xboole_0(A,B),C) = k2_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
      & k2_zfmisc_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ).

fof(t121_zfmisc_1,axiom,
    ! [A,B,C,D] : k2_zfmisc_1(k2_xboole_0(A,B),k2_xboole_0(C,D)) = k2_xboole_0(k2_xboole_0(k2_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(A,D)),k2_zfmisc_1(B,C)),k2_zfmisc_1(B,D)) ).

fof(t122_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k3_xboole_0(A,B),C) = k3_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
      & k2_zfmisc_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ).

fof(t123_zfmisc_1,axiom,
    ! [A,B,C,D] : k2_zfmisc_1(k3_xboole_0(A,B),k3_xboole_0(C,D)) = k3_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ).

fof(t124_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => k3_xboole_0(k2_zfmisc_1(A,D),k2_zfmisc_1(B,C)) = k2_zfmisc_1(A,C) ) ).

fof(t125_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k4_xboole_0(A,B),C) = k4_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
      & k2_zfmisc_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ).

fof(t126_zfmisc_1,axiom,
    ! [A,B,C,D] : k4_xboole_0(k2_zfmisc_1(A,B),k2_zfmisc_1(C,D)) = k2_xboole_0(k2_zfmisc_1(k4_xboole_0(A,C),B),k2_zfmisc_1(A,k4_xboole_0(B,D))) ).

fof(t127_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_xboole_0(A,B)
        | r1_xboole_0(C,D) )
     => r1_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ) ).

fof(t128_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(k1_tarski(C),D))
    <=> ( A = C
        & r2_hidden(B,D) ) ) ).

fof(t129_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(C,k1_tarski(D)))
    <=> ( r2_hidden(A,C)
        & B = D ) ) ).

fof(t130_zfmisc_1,axiom,
    ! [A,B] :
      ( A != k1_xboole_0
     => ( k2_zfmisc_1(k1_tarski(B),A) != k1_xboole_0
        & k2_zfmisc_1(A,k1_tarski(B)) != k1_xboole_0 ) ) ).

fof(t131_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( A != B
     => ( r1_xboole_0(k2_zfmisc_1(k1_tarski(A),C),k2_zfmisc_1(k1_tarski(B),D))
        & r1_xboole_0(k2_zfmisc_1(C,k1_tarski(A)),k2_zfmisc_1(D,k1_tarski(B))) ) ) ).

fof(t132_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k2_tarski(A,B),C) = k2_xboole_0(k2_zfmisc_1(k1_tarski(A),C),k2_zfmisc_1(k1_tarski(B),C))
      & k2_zfmisc_1(C,k2_tarski(A,B)) = k2_xboole_0(k2_zfmisc_1(C,k1_tarski(A)),k2_zfmisc_1(C,k1_tarski(B))) ) ).

fof(t133_zfmisc_1,axiom,
    $true ).

fof(t134_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( k2_zfmisc_1(A,B) = k2_zfmisc_1(C,D)
     => ( A = k1_xboole_0
        | B = k1_xboole_0
        | ( A = C
          & B = D ) ) ) ).

fof(t135_zfmisc_1,axiom,
    ! [A,B] :
      ( ( r1_tarski(A,k2_zfmisc_1(A,B))
        | r1_tarski(A,k2_zfmisc_1(B,A)) )
     => A = k1_xboole_0 ) ).

fof(t136_zfmisc_1,axiom,
    ! [A] :
    ? [B] :
      ( r2_hidden(A,B)
      & ! [C,D] :
          ( ( r2_hidden(C,B)
            & r1_tarski(D,C) )
         => r2_hidden(D,B) )
      & ! [C] :
          ( r2_hidden(C,B)
         => r2_hidden(k1_zfmisc_1(C),B) )
      & ! [C] :
          ~ ( r1_tarski(C,B)
            & ~ r2_tarski(C,B)
            & ~ r2_hidden(C,B) ) ) ).

fof(t137_zfmisc_1,axiom,
    ! [A,B,C,D,E] :
      ( ( r2_hidden(A,k2_zfmisc_1(B,C))
        & r2_hidden(A,k2_zfmisc_1(D,E)) )
     => r2_hidden(A,k2_zfmisc_1(k3_xboole_0(B,D),k3_xboole_0(C,E))) ) ).

fof(t138_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r1_tarski(k2_zfmisc_1(A,B),k2_zfmisc_1(C,D))
     => ( k2_zfmisc_1(A,B) = k1_xboole_0
        | ( r1_tarski(A,C)
          & r1_tarski(B,D) ) ) ) ).

fof(t139_zfmisc_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C,D] :
          ( ( r1_tarski(k2_zfmisc_1(A,B),k2_zfmisc_1(C,D))
            | r1_tarski(k2_zfmisc_1(B,A),k2_zfmisc_1(D,C)) )
         => r1_tarski(B,D) ) ) ).

fof(t140_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => k2_xboole_0(k4_xboole_0(B,k1_tarski(A)),k1_tarski(A)) = B ) ).

fof(t141_zfmisc_1,axiom,
    ! [A,B] :
      ( ~ r2_hidden(A,B)
     => k4_xboole_0(k2_xboole_0(B,k1_tarski(A)),k1_tarski(A)) = B ) ).

fof(dt_k1_zfmisc_1,axiom,
    $true ).

fof(dt_k2_zfmisc_1,axiom,
    $true ).

fof(dt_k3_zfmisc_1,axiom,
    $true ).

fof(dt_k4_zfmisc_1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_subset_1,axiom,
    ! [A] : ~ v1_xboole_0(k1_zfmisc_1(A)) ).

fof(fc2_subset_1,axiom,
    ! [A] : ~ v1_xboole_0(k1_tarski(A)) ).

fof(fc3_subset_1,axiom,
    ! [A,B] : ~ v1_xboole_0(k2_tarski(A,B)) ).

fof(rc1_subset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
          & ~ v1_xboole_0(B) ) ) ).

fof(fc4_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ~ v1_xboole_0(k2_zfmisc_1(A,B)) ) ).

fof(fc5_subset_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C) )
     => ~ v1_xboole_0(k3_zfmisc_1(A,B,C)) ) ).

fof(fc6_subset_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D) )
     => ~ v1_xboole_0(k4_zfmisc_1(A,B,C,D)) ) ).

fof(rc2_subset_1,axiom,
    ! [A] :
    ? [B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
      & v1_xboole_0(B) ) ).

fof(d1_subset_1,axiom,
    $true ).

fof(d2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
       => ( m1_subset_1(B,A)
        <=> r2_hidden(B,A) ) )
      & ( v1_xboole_0(A)
       => ( m1_subset_1(B,A)
        <=> v1_xboole_0(B) ) ) ) ).

fof(d3_subset_1,axiom,
    ! [A] : k1_subset_1(A) = k1_xboole_0 ).

fof(d4_subset_1,axiom,
    ! [A] : k2_subset_1(A) = A ).

fof(t1_subset_1,axiom,
    $true ).

fof(t2_subset_1,axiom,
    $true ).

fof(t3_subset_1,axiom,
    $true ).

fof(t4_subset_1,axiom,
    ! [A] : m1_subset_1(k1_xboole_0,k1_zfmisc_1(A)) ).

fof(t5_subset_1,axiom,
    $true ).

fof(t6_subset_1,axiom,
    $true ).

fof(t7_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( r2_hidden(D,B)
                 => r2_hidden(D,C) ) )
           => r1_tarski(B,C) ) ) ) ).

fof(t8_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( r2_hidden(D,B)
                <=> r2_hidden(D,C) ) )
           => B = C ) ) ) ).

fof(t9_subset_1,axiom,
    $true ).

fof(t10_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ~ ( B != k1_xboole_0
          & ! [C] :
              ( m1_subset_1(C,A)
             => ~ r2_hidden(C,B) ) ) ) ).

fof(d5_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k3_subset_1(A,B) = k4_xboole_0(A,B) ) ).

fof(t11_subset_1,axiom,
    $true ).

fof(t12_subset_1,axiom,
    $true ).

fof(t13_subset_1,axiom,
    $true ).

fof(t14_subset_1,axiom,
    $true ).

fof(t15_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ( r2_hidden(E,C)
                        | r2_hidden(E,D) ) ) )
               => B = k4_subset_1(A,C,D) ) ) ) ) ).

fof(t16_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ( r2_hidden(E,C)
                        & r2_hidden(E,D) ) ) )
               => B = k5_subset_1(A,C,D) ) ) ) ) ).

fof(t17_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ( r2_hidden(E,C)
                        & ~ r2_hidden(E,D) ) ) )
               => B = k6_subset_1(A,C,D) ) ) ) ) ).

fof(t18_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ~ ( r2_hidden(E,C)
                        <=> r2_hidden(E,D) ) ) )
               => B = k7_subset_1(A,C,D) ) ) ) ) ).

fof(t19_subset_1,axiom,
    $true ).

fof(t20_subset_1,axiom,
    $true ).

fof(t21_subset_1,axiom,
    ! [A] : k1_subset_1(A) = k3_subset_1(A,k2_subset_1(A)) ).

fof(t22_subset_1,axiom,
    ! [A] : k2_subset_1(A) = k3_subset_1(A,k1_subset_1(A)) ).

fof(t23_subset_1,axiom,
    $true ).

fof(t24_subset_1,axiom,
    $true ).

fof(t25_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k4_subset_1(A,B,k3_subset_1(A,B)) = k2_subset_1(A) ) ).

fof(t26_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => r1_xboole_0(B,k3_subset_1(A,B)) ) ).

fof(t27_subset_1,axiom,
    $true ).

fof(t28_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k4_subset_1(A,B,k2_subset_1(A)) = k2_subset_1(A) ) ).

fof(t29_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k4_subset_1(A,B,C)) = k5_subset_1(A,k3_subset_1(A,B),k3_subset_1(A,C)) ) ) ).

fof(t30_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k5_subset_1(A,B,C)) = k4_subset_1(A,k3_subset_1(A,B),k3_subset_1(A,C)) ) ) ).

fof(t31_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_tarski(B,C)
          <=> r1_tarski(k3_subset_1(A,C),k3_subset_1(A,B)) ) ) ) ).

fof(t32_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k6_subset_1(A,B,C) = k5_subset_1(A,B,k3_subset_1(A,C)) ) ) ).

fof(t33_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k6_subset_1(A,B,C)) = k4_subset_1(A,k3_subset_1(A,B),C) ) ) ).

fof(t34_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k7_subset_1(A,B,C)) = k4_subset_1(A,k5_subset_1(A,B,C),k5_subset_1(A,k3_subset_1(A,B),k3_subset_1(A,C))) ) ) ).

fof(t35_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_tarski(B,k3_subset_1(A,C))
           => r1_tarski(C,k3_subset_1(A,B)) ) ) ) ).

fof(t36_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_tarski(k3_subset_1(A,B),C)
           => r1_tarski(k3_subset_1(A,C),B) ) ) ) ).

fof(t37_subset_1,axiom,
    $true ).

fof(t38_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( r1_tarski(B,k3_subset_1(A,B))
      <=> B = k1_subset_1(A) ) ) ).

fof(t39_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( r1_tarski(k3_subset_1(A,B),B)
      <=> B = k2_subset_1(A) ) ) ).

fof(t40_subset_1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(A))
     => ( ( r1_tarski(B,C)
          & r1_tarski(B,k3_subset_1(A,C)) )
       => B = k1_xboole_0 ) ) ).

fof(t41_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => r1_tarski(k3_subset_1(A,k4_subset_1(A,B,C)),k3_subset_1(A,B)) ) ) ).

fof(t42_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => r1_tarski(k3_subset_1(A,B),k3_subset_1(A,k5_subset_1(A,B,C))) ) ) ).

fof(t43_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_xboole_0(B,C)
          <=> r1_tarski(B,k3_subset_1(A,C)) ) ) ) ).

fof(t44_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_xboole_0(B,k3_subset_1(A,C))
          <=> r1_tarski(B,C) ) ) ) ).

fof(t45_subset_1,axiom,
    $true ).

fof(t46_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ( r1_xboole_0(B,C)
              & r1_xboole_0(k3_subset_1(A,B),k3_subset_1(A,C)) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t47_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ( r1_tarski(B,C)
                  & r1_xboole_0(D,C) )
               => r1_tarski(B,k3_subset_1(A,D)) ) ) ) ) ).

fof(t48_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,B)
               => r2_hidden(D,C) )
           => r1_tarski(B,C) ) ) ) ).

fof(t49_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( ! [C] :
            ( m1_subset_1(C,A)
           => r2_hidden(C,B) )
       => A = B ) ) ).

fof(t50_subset_1,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,A)
             => ( ~ r2_hidden(C,B)
               => r2_hidden(C,k3_subset_1(A,B)) ) ) ) ) ).

fof(t51_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( r2_hidden(D,B)
                <=> ~ r2_hidden(D,C) ) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t52_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( ~ r2_hidden(D,B)
                <=> r2_hidden(D,C) ) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t53_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ~ ( r2_hidden(D,B)
                  <=> r2_hidden(D,C) ) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t54_subset_1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(A))
     => ~ ( r2_hidden(B,k3_subset_1(A,C))
          & r2_hidden(B,C) ) ) ).

fof(t55_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ( A != k1_xboole_0
       => m1_subset_1(k1_tarski(B),k1_zfmisc_1(A)) ) ) ).

fof(t56_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( A != k1_xboole_0
           => m1_subset_1(k2_tarski(B,C),k1_zfmisc_1(A)) ) ) ) ).

fof(t57_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ( A != k1_xboole_0
               => m1_subset_1(k1_enumset1(B,C,D),k1_zfmisc_1(A)) ) ) ) ) ).

fof(t58_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ( A != k1_xboole_0
                   => m1_subset_1(k2_enumset1(B,C,D,E),k1_zfmisc_1(A)) ) ) ) ) ) ).

fof(t59_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ( A != k1_xboole_0
                       => m1_subset_1(k3_enumset1(B,C,D,E,F),k1_zfmisc_1(A)) ) ) ) ) ) ) ).

fof(t60_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ! [G] :
                          ( m1_subset_1(G,A)
                         => ( A != k1_xboole_0
                           => m1_subset_1(k4_enumset1(B,C,D,E,F,G),k1_zfmisc_1(A)) ) ) ) ) ) ) ) ).

fof(t61_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ! [G] :
                          ( m1_subset_1(G,A)
                         => ! [H] :
                              ( m1_subset_1(H,A)
                             => ( A != k1_xboole_0
                               => m1_subset_1(k5_enumset1(B,C,D,E,F,G,H),k1_zfmisc_1(A)) ) ) ) ) ) ) ) ) ).

fof(t62_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ! [G] :
                          ( m1_subset_1(G,A)
                         => ! [H] :
                              ( m1_subset_1(H,A)
                             => ! [I] :
                                  ( m1_subset_1(I,A)
                                 => ( A != k1_xboole_0
                                   => m1_subset_1(k6_enumset1(B,C,D,E,F,G,H,I),k1_zfmisc_1(A)) ) ) ) ) ) ) ) ) ) ).

fof(t63_subset_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => m1_subset_1(k1_tarski(A),k1_zfmisc_1(B)) ) ).

fof(d6_subset_1,axiom,
    ! [A] :
      ( ~ $true
     => ! [B] :
          ( m1_subset_1(B,A)
         => B = k8_subset_1(A) ) ) ).

fof(s1_subset_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_zfmisc_1(f1_s1_subset_1))
      & ! [B] :
          ( r2_hidden(B,A)
        <=> ( r2_hidden(B,f1_s1_subset_1)
            & p1_s1_subset_1(B) ) ) ) ).

fof(s2_subset_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(f1_s2_subset_1))
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(f1_s2_subset_1))
         => ( ( ! [C] :
                  ( m1_subset_1(C,f1_s2_subset_1)
                 => ( r2_hidden(C,A)
                  <=> p1_s2_subset_1(C) ) )
              & ! [C] :
                  ( m1_subset_1(C,f1_s2_subset_1)
                 => ( r2_hidden(C,B)
                  <=> p1_s2_subset_1(C) ) ) )
           => A = B ) ) ) ).

fof(s3_subset_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_zfmisc_1(f1_s3_subset_1))
      & ! [B] :
          ( m1_subset_1(B,f1_s3_subset_1)
         => ( r2_hidden(B,A)
          <=> p1_s3_subset_1(B) ) ) ) ).

fof(s4_subset_1,axiom,
    ( ( ! [A] :
          ( m1_subset_1(A,f1_s4_subset_1)
         => ( r2_hidden(A,f2_s4_subset_1)
          <=> p1_s4_subset_1(A) ) )
      & ! [A] :
          ( m1_subset_1(A,f1_s4_subset_1)
         => ( r2_hidden(A,f3_s4_subset_1)
          <=> p1_s4_subset_1(A) ) ) )
   => f2_s4_subset_1 = f3_s4_subset_1 ) ).

fof(dt_m1_subset_1,axiom,
    $true ).

fof(existence_m1_subset_1,axiom,
    ! [A] :
    ? [B] : m1_subset_1(B,A) ).

fof(dt_m2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(A)) )
     => ! [C] :
          ( m2_subset_1(C,A,B)
         => m1_subset_1(C,A) ) ) ).

fof(existence_m2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(A)) )
     => ? [C] : m2_subset_1(C,A,B) ) ).

fof(redefinition_m2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(A)) )
     => ! [C] :
          ( m2_subset_1(C,A,B)
        <=> m1_subset_1(C,B) ) ) ).

fof(symmetry_r1_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r1_subset_1(A,B)
       => r1_subset_1(B,A) ) ) ).

fof(irreflexivity_r1_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ~ r1_subset_1(A,A) ) ).

fof(redefinition_r1_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r1_subset_1(A,B)
      <=> r1_xboole_0(A,B) ) ) ).

fof(symmetry_r2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r2_subset_1(A,B)
       => r2_subset_1(B,A) ) ) ).

fof(irreflexivity_r2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ~ r2_subset_1(A,A) ) ).

fof(redefinition_r2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r2_subset_1(A,B)
      <=> r1_xboole_0(A,B) ) ) ).

fof(dt_k1_subset_1,axiom,
    ! [A] :
      ( v1_xboole_0(k1_subset_1(A))
      & m1_subset_1(k1_subset_1(A),k1_zfmisc_1(A)) ) ).

fof(dt_k2_subset_1,axiom,
    ! [A] : m1_subset_1(k2_subset_1(A),k1_zfmisc_1(A)) ).

fof(dt_k3_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => m1_subset_1(k3_subset_1(A,B),k1_zfmisc_1(A)) ) ).

fof(involutiveness_k3_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k3_subset_1(A,k3_subset_1(A,B)) = B ) ).

fof(dt_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k4_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(commutativity_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k4_subset_1(A,B,C) = k4_subset_1(A,C,B) ) ).

fof(idempotence_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k4_subset_1(A,B,B) = B ) ).

fof(redefinition_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k4_subset_1(A,B,C) = k2_xboole_0(B,C) ) ).

fof(dt_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k5_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(commutativity_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k5_subset_1(A,B,C) = k5_subset_1(A,C,B) ) ).

fof(idempotence_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k5_subset_1(A,B,B) = B ) ).

fof(redefinition_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k5_subset_1(A,B,C) = k3_xboole_0(B,C) ) ).

fof(dt_k6_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k6_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(redefinition_k6_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k6_subset_1(A,B,C) = k4_xboole_0(B,C) ) ).

fof(dt_k7_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k7_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(commutativity_k7_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k7_subset_1(A,B,C) = k7_subset_1(A,C,B) ) ).

fof(redefinition_k7_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k7_subset_1(A,B,C) = k5_xboole_0(B,C) ) ).

fof(dt_k8_subset_1,axiom,
    ! [A] : m1_subset_1(k8_subset_1(A),A) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_setfam_1,axiom,
    ! [A,B] :
      ( ( v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A))) )
     => v1_xboole_0(k7_setfam_1(A,B)) ) ).

fof(rc1_setfam_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_setfam_1(A) ) ).

fof(fc2_setfam_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ~ v1_xboole_0(k1_tarski(A))
        & v1_setfam_1(k1_tarski(A)) ) ) ).

fof(fc3_setfam_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( ~ v1_xboole_0(k2_tarski(A,B))
        & v1_setfam_1(k2_tarski(A,B)) ) ) ).

fof(fc4_setfam_1,axiom,
    ! [A,B] :
      ( ( v1_setfam_1(A)
        & v1_setfam_1(B) )
     => v1_setfam_1(k2_xboole_0(A,B)) ) ).

fof(cc1_setfam_1,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_setfam_1(A) )
     => ! [B] :
          ( m1_subset_1(B,A)
         => ~ v1_xboole_0(B) ) ) ).

fof(rc2_setfam_1,axiom,
    ? [A] : ~ v2_setfam_1(A) ).

fof(cc2_setfam_1,axiom,
    ! [A] :
      ( ~ v2_setfam_1(A)
     => ~ v1_xboole_0(A) ) ).

fof(rc3_setfam_1,axiom,
    ! [A] :
      ( ~ v2_setfam_1(A)
     => ? [B] :
          ( m1_subset_1(B,A)
          & ~ v1_xboole_0(B) ) ) ).

fof(d1_setfam_1,axiom,
    ! [A,B] :
      ( ( A != k1_xboole_0
       => ( B = k1_setfam_1(A)
        <=> ! [C] :
              ( r2_hidden(C,B)
            <=> ! [D] :
                  ( r2_hidden(D,A)
                 => r2_hidden(C,D) ) ) ) )
      & ( A = k1_xboole_0
       => ( B = k1_setfam_1(A)
        <=> B = k1_xboole_0 ) ) ) ).

fof(t1_setfam_1,axiom,
    $true ).

fof(t2_setfam_1,axiom,
    k1_setfam_1(k1_xboole_0) = k1_xboole_0 ).

fof(t3_setfam_1,axiom,
    ! [A] : r1_tarski(k1_setfam_1(A),k3_tarski(A)) ).

fof(t4_setfam_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => r1_tarski(k1_setfam_1(B),A) ) ).

fof(t5_setfam_1,axiom,
    ! [A] :
      ( r2_hidden(k1_xboole_0,A)
     => k1_setfam_1(A) = k1_xboole_0 ) ).

fof(t6_setfam_1,axiom,
    ! [A,B] :
      ( ! [C] :
          ( r2_hidden(C,A)
         => r1_tarski(B,C) )
     => ( A = k1_xboole_0
        | r1_tarski(B,k1_setfam_1(A)) ) ) ).

fof(t7_setfam_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => ( A = k1_xboole_0
        | r1_tarski(k1_setfam_1(B),k1_setfam_1(A)) ) ) ).

fof(t8_setfam_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & r1_tarski(A,C) )
     => r1_tarski(k1_setfam_1(B),C) ) ).

fof(t9_setfam_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & r1_xboole_0(A,C) )
     => r1_xboole_0(k1_setfam_1(B),C) ) ).

fof(t10_setfam_1,axiom,
    ! [A,B] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & k1_setfam_1(k2_xboole_0(A,B)) != k3_xboole_0(k1_setfam_1(A),k1_setfam_1(B)) ) ).

fof(t11_setfam_1,axiom,
    ! [A] : k1_setfam_1(k1_tarski(A)) = A ).

fof(t12_setfam_1,axiom,
    ! [A,B] : k1_setfam_1(k2_tarski(A,B)) = k3_xboole_0(A,B) ).

fof(d2_setfam_1,axiom,
    ! [A,B] :
      ( r1_setfam_1(A,B)
    <=> ! [C] :
          ~ ( r2_hidden(C,A)
            & ! [D] :
                ~ ( r2_hidden(D,B)
                  & r1_tarski(C,D) ) ) ) ).

fof(d3_setfam_1,axiom,
    ! [A,B] :
      ( r2_setfam_1(A,B)
    <=> ! [C] :
          ~ ( r2_hidden(C,B)
            & ! [D] :
                ~ ( r2_hidden(D,A)
                  & r1_tarski(D,C) ) ) ) ).

fof(t13_setfam_1,axiom,
    $true ).

fof(t14_setfam_1,axiom,
    $true ).

fof(t15_setfam_1,axiom,
    $true ).

fof(t16_setfam_1,axiom,
    $true ).

fof(t17_setfam_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_setfam_1(A,B) ) ).

fof(t18_setfam_1,axiom,
    ! [A,B] :
      ( r1_setfam_1(A,B)
     => r1_tarski(k3_tarski(A),k3_tarski(B)) ) ).

fof(t19_setfam_1,axiom,
    ! [A,B] :
      ( r2_setfam_1(B,A)
     => ( A = k1_xboole_0
        | r1_tarski(k1_setfam_1(B),k1_setfam_1(A)) ) ) ).

fof(t20_setfam_1,axiom,
    ! [A] : r1_setfam_1(k1_xboole_0,A) ).

fof(t21_setfam_1,axiom,
    ! [A] :
      ( r1_setfam_1(A,k1_xboole_0)
     => A = k1_xboole_0 ) ).

fof(t22_setfam_1,axiom,
    $true ).

fof(t23_setfam_1,axiom,
    ! [A,B,C] :
      ( ( r1_setfam_1(A,B)
        & r1_setfam_1(B,C) )
     => r1_setfam_1(A,C) ) ).

fof(t24_setfam_1,axiom,
    ! [A,B] :
      ( r1_setfam_1(B,k1_tarski(A))
     => ! [C] :
          ( r2_hidden(C,B)
         => r1_tarski(C,A) ) ) ).

fof(t25_setfam_1,axiom,
    ! [A,B,C] :
      ( r1_setfam_1(C,k2_tarski(A,B))
     => ! [D] :
          ~ ( r2_hidden(D,C)
            & ~ r1_tarski(D,A)
            & ~ r1_tarski(D,B) ) ) ).

fof(d4_setfam_1,axiom,
    ! [A,B,C] :
      ( C = k2_setfam_1(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E,F] :
              ( r2_hidden(E,A)
              & r2_hidden(F,B)
              & D = k2_xboole_0(E,F) ) ) ) ).

fof(d5_setfam_1,axiom,
    ! [A,B,C] :
      ( C = k3_setfam_1(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E,F] :
              ( r2_hidden(E,A)
              & r2_hidden(F,B)
              & D = k3_xboole_0(E,F) ) ) ) ).

fof(d6_setfam_1,axiom,
    ! [A,B,C] :
      ( C = k4_setfam_1(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E,F] :
              ( r2_hidden(E,A)
              & r2_hidden(F,B)
              & D = k4_xboole_0(E,F) ) ) ) ).

fof(t26_setfam_1,axiom,
    $true ).

fof(t27_setfam_1,axiom,
    $true ).

fof(t28_setfam_1,axiom,
    $true ).

fof(t29_setfam_1,axiom,
    ! [A] : r1_setfam_1(A,k2_setfam_1(A,A)) ).

fof(t30_setfam_1,axiom,
    ! [A] : r1_setfam_1(k3_setfam_1(A,A),A) ).

fof(t31_setfam_1,axiom,
    ! [A] : r1_setfam_1(k4_setfam_1(A,A),A) ).

fof(t32_setfam_1,axiom,
    $true ).

fof(t33_setfam_1,axiom,
    $true ).

fof(t34_setfam_1,axiom,
    ! [A,B] :
      ( ~ r1_xboole_0(A,B)
     => k3_xboole_0(k1_setfam_1(A),k1_setfam_1(B)) = k1_setfam_1(k3_setfam_1(A,B)) ) ).

fof(t35_setfam_1,axiom,
    ! [A,B] :
      ( B != k1_xboole_0
     => k2_xboole_0(A,k1_setfam_1(B)) = k1_setfam_1(k2_setfam_1(k1_tarski(A),B)) ) ).

fof(t36_setfam_1,axiom,
    ! [A,B] : k3_xboole_0(A,k3_tarski(B)) = k3_tarski(k3_setfam_1(k1_tarski(A),B)) ).

fof(t37_setfam_1,axiom,
    ! [A,B] :
      ( B != k1_xboole_0
     => k4_xboole_0(A,k3_tarski(B)) = k1_setfam_1(k4_setfam_1(k1_tarski(A),B)) ) ).

fof(t38_setfam_1,axiom,
    ! [A,B] :
      ( B != k1_xboole_0
     => k4_xboole_0(A,k1_setfam_1(B)) = k3_tarski(k4_setfam_1(k1_tarski(A),B)) ) ).

fof(t39_setfam_1,axiom,
    ! [A,B] : k3_tarski(k3_setfam_1(A,B)) = k3_xboole_0(k3_tarski(A),k3_tarski(B)) ).

fof(t40_setfam_1,axiom,
    ! [A,B] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & ~ r1_tarski(k2_xboole_0(k1_setfam_1(A),k1_setfam_1(B)),k1_setfam_1(k2_setfam_1(A,B))) ) ).

fof(t41_setfam_1,axiom,
    ! [A,B] : r1_tarski(k1_setfam_1(k4_setfam_1(A,B)),k4_xboole_0(k1_setfam_1(A),k1_setfam_1(B))) ).

fof(t42_setfam_1,axiom,
    $true ).

fof(t43_setfam_1,axiom,
    $true ).

fof(t44_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ( ! [D] :
                ( m1_subset_1(D,k1_zfmisc_1(A))
               => ( r2_hidden(D,B)
                <=> r2_hidden(D,C) ) )
           => B = C ) ) ) ).

fof(d7_setfam_1,axiom,
    $true ).

fof(d8_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ( C = k7_setfam_1(A,B)
          <=> ! [D] :
                ( m1_subset_1(D,k1_zfmisc_1(A))
               => ( r2_hidden(D,C)
                <=> r2_hidden(k3_subset_1(A,D),B) ) ) ) ) ) ).

fof(t45_setfam_1,axiom,
    $true ).

fof(t46_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ~ ( B != k1_xboole_0
          & k7_setfam_1(A,B) = k1_xboole_0 ) ) ).

fof(t47_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ( B != k1_xboole_0
       => k6_subset_1(A,k2_subset_1(A),k5_setfam_1(A,B)) = k6_setfam_1(A,k7_setfam_1(A,B)) ) ) ).

fof(t48_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ( B != k1_xboole_0
       => k5_setfam_1(A,k7_setfam_1(A,B)) = k6_subset_1(A,k2_subset_1(A),k6_setfam_1(A,B)) ) ) ).

fof(t49_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r2_hidden(k3_subset_1(A,C),k7_setfam_1(A,B))
          <=> r2_hidden(C,B) ) ) ) ).

fof(t50_setfam_1,axiom,
    $true ).

fof(t51_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ( r1_tarski(k7_setfam_1(A,B),k7_setfam_1(A,C))
           => r1_tarski(B,C) ) ) ) ).

fof(t52_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ( r1_tarski(k7_setfam_1(A,B),C)
          <=> r1_tarski(B,k7_setfam_1(A,C)) ) ) ) ).

fof(t53_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ( k7_setfam_1(A,B) = k7_setfam_1(A,C)
           => B = C ) ) ) ).

fof(t54_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => k7_setfam_1(A,k4_subset_1(k1_zfmisc_1(A),B,C)) = k4_subset_1(k1_zfmisc_1(A),k7_setfam_1(A,B),k7_setfam_1(A,C)) ) ) ).

fof(t55_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ( B = k1_tarski(A)
       => k7_setfam_1(A,B) = k1_tarski(k1_xboole_0) ) ) ).

fof(d9_setfam_1,axiom,
    ! [A] :
      ( v1_setfam_1(A)
    <=> ~ r2_hidden(k1_xboole_0,A) ) ).

fof(t56_setfam_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(k3_tarski(A),B)
        & r2_hidden(C,A) )
     => r1_tarski(C,B) ) ).

fof(t57_setfam_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(C,k3_tarski(k2_xboole_0(A,B)))
        & ! [D] :
            ( r2_hidden(D,B)
           => r1_xboole_0(D,C) ) )
     => r1_tarski(C,k3_tarski(A)) ) ).

fof(d10_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ( ( B != k1_xboole_0
         => k8_setfam_1(A,B) = k6_setfam_1(A,B) )
        & ( B = k1_xboole_0
         => k8_setfam_1(A,B) = A ) ) ) ).

fof(t58_setfam_1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ( r2_hidden(B,A)
       => ( r2_hidden(B,k8_setfam_1(A,C))
        <=> ! [D] :
              ( r2_hidden(D,C)
             => r2_hidden(B,D) ) ) ) ) ).

fof(t59_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ( r1_tarski(B,C)
           => r1_tarski(k8_setfam_1(A,C),k8_setfam_1(A,B)) ) ) ) ).

fof(d11_setfam_1,axiom,
    ! [A] :
      ( v2_setfam_1(A)
    <=> ! [B] :
          ( ~ v1_xboole_0(B)
         => ~ r2_hidden(B,A) ) ) ).

fof(reflexivity_r1_setfam_1,axiom,
    ! [A,B] : r1_setfam_1(A,A) ).

fof(reflexivity_r2_setfam_1,axiom,
    ! [A,B] : r2_setfam_1(B,B) ).

fof(dt_k1_setfam_1,axiom,
    $true ).

fof(dt_k2_setfam_1,axiom,
    $true ).

fof(commutativity_k2_setfam_1,axiom,
    ! [A,B] : k2_setfam_1(A,B) = k2_setfam_1(B,A) ).

fof(dt_k3_setfam_1,axiom,
    $true ).

fof(commutativity_k3_setfam_1,axiom,
    ! [A,B] : k3_setfam_1(A,B) = k3_setfam_1(B,A) ).

fof(dt_k4_setfam_1,axiom,
    $true ).

fof(dt_k5_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => m1_subset_1(k5_setfam_1(A,B),k1_zfmisc_1(A)) ) ).

fof(redefinition_k5_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => k5_setfam_1(A,B) = k3_tarski(B) ) ).

fof(dt_k6_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => m1_subset_1(k6_setfam_1(A,B),k1_zfmisc_1(A)) ) ).

fof(redefinition_k6_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => k6_setfam_1(A,B) = k1_setfam_1(B) ) ).

fof(dt_k7_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => m1_subset_1(k7_setfam_1(A,B),k1_zfmisc_1(k1_zfmisc_1(A))) ) ).

fof(involutiveness_k7_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => k7_setfam_1(A,k7_setfam_1(A,B)) = B ) ).

fof(dt_k8_setfam_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => m1_subset_1(k8_setfam_1(A,B),k1_zfmisc_1(A)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_subset,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => m1_subset_1(A,B) ) ).

fof(t2_subset,axiom,
    ! [A,B] :
      ( m1_subset_1(A,B)
     => ( v1_xboole_0(B)
        | r2_hidden(A,B) ) ) ).

fof(t3_subset,axiom,
    ! [A,B] :
      ( m1_subset_1(A,k1_zfmisc_1(B))
    <=> r1_tarski(A,B) ) ).

fof(t4_subset,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & m1_subset_1(B,k1_zfmisc_1(C)) )
     => m1_subset_1(A,C) ) ).

fof(t5_subset,axiom,
    ! [A,B,C] :
      ~ ( r2_hidden(A,B)
        & m1_subset_1(B,k1_zfmisc_1(C))
        & v1_xboole_0(C) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_relat_1,axiom,
    ? [A] :
      ( v1_xboole_0(A)
      & v1_relat_1(A) ) ).

fof(fc1_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k3_xboole_0(A,B)) ) ).

fof(fc2_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k2_xboole_0(A,B)) ) ).

fof(fc3_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k4_xboole_0(A,B)) ) ).

fof(cc1_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => v1_relat_1(A) ) ).

fof(fc4_relat_1,axiom,
    ( v1_xboole_0(k1_xboole_0)
    & v1_relat_1(k1_xboole_0) ) ).

fof(rc2_relat_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_relat_1(A) ) ).

fof(fc5_relat_1,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(A) )
     => ~ v1_xboole_0(k1_relat_1(A)) ) ).

fof(fc6_relat_1,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(A) )
     => ~ v1_xboole_0(k2_relat_1(A)) ) ).

fof(fc7_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_xboole_0(k1_relat_1(A))
        & v1_relat_1(k1_relat_1(A)) ) ) ).

fof(fc8_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_xboole_0(k2_relat_1(A))
        & v1_relat_1(k2_relat_1(A)) ) ) ).

fof(fc9_relat_1,axiom,
    ! [A,B] :
      ( ( v1_xboole_0(A)
        & v1_relat_1(B) )
     => ( v1_xboole_0(k5_relat_1(A,B))
        & v1_relat_1(k5_relat_1(A,B)) ) ) ).

fof(fc10_relat_1,axiom,
    ! [A,B] :
      ( ( v1_xboole_0(A)
        & v1_relat_1(B) )
     => ( v1_xboole_0(k5_relat_1(B,A))
        & v1_relat_1(k5_relat_1(B,A)) ) ) ).

fof(fc11_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_xboole_0(k4_relat_1(A))
        & v1_relat_1(k4_relat_1(A)) ) ) ).

fof(fc12_relat_1,axiom,
    ( v1_xboole_0(k1_xboole_0)
    & v1_relat_1(k1_xboole_0)
    & v3_relat_1(k1_xboole_0) ) ).

fof(rc3_relat_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v3_relat_1(A) ) ).

fof(fc13_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v3_relat_1(A) )
     => ( v1_relat_1(k7_relat_1(A,B))
        & v3_relat_1(k7_relat_1(A,B)) ) ) ).

fof(d1_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
    <=> ! [B] :
          ~ ( r2_hidden(B,A)
            & ! [C,D] : B != k4_tarski(C,D) ) ) ).

fof(t1_relat_1,axiom,
    $true ).

fof(t2_relat_1,axiom,
    $true ).

fof(t3_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,B)
       => v1_relat_1(A) ) ) ).

fof(t4_relat_1,axiom,
    ! [A,B] : v1_relat_1(k1_tarski(k4_tarski(A,B))) ).

fof(t5_relat_1,axiom,
    ! [A,B,C,D] : v1_relat_1(k2_tarski(k4_tarski(A,B),k4_tarski(C,D))) ).

fof(t6_relat_1,axiom,
    ! [A,B] : v1_relat_1(k2_zfmisc_1(A,B)) ).

fof(d2_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( A = B
          <=> ! [C,D] :
                ( r2_hidden(k4_tarski(C,D),A)
              <=> r2_hidden(k4_tarski(C,D),B) ) ) ) ) ).

fof(d3_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(A,B)
          <=> ! [C,D] :
                ( r2_hidden(k4_tarski(C,D),A)
               => r2_hidden(k4_tarski(C,D),B) ) ) ) ) ).

fof(t7_relat_1,axiom,
    $true ).

fof(t8_relat_1,axiom,
    $true ).

fof(t9_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => v1_relat_1(k3_xboole_0(A,B)) ) ).

fof(t10_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => v1_relat_1(k4_xboole_0(B,A)) ) ).

fof(d4_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( B = k1_relat_1(A)
        <=> ! [C] :
              ( r2_hidden(C,B)
            <=> ? [D] : r2_hidden(k4_tarski(C,D),A) ) ) ) ).

fof(t11_relat_1,axiom,
    $true ).

fof(t12_relat_1,axiom,
    $true ).

fof(t13_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k1_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k1_relat_1(A),k1_relat_1(B)) ) ) ).

fof(t14_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k1_relat_1(k3_xboole_0(A,B)),k3_xboole_0(k1_relat_1(A),k1_relat_1(B))) ) ) ).

fof(t15_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k4_xboole_0(k1_relat_1(A),k1_relat_1(B)),k1_relat_1(k4_xboole_0(A,B))) ) ) ).

fof(d5_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( B = k2_relat_1(A)
        <=> ! [C] :
              ( r2_hidden(C,B)
            <=> ? [D] : r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(t16_relat_1,axiom,
    $true ).

fof(t17_relat_1,axiom,
    $true ).

fof(t18_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( r2_hidden(A,k1_relat_1(B))
          & ! [C] : ~ r2_hidden(C,k2_relat_1(B)) ) ) ).

fof(t19_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( r2_hidden(A,k2_relat_1(B))
          & ! [C] : ~ r2_hidden(C,k1_relat_1(B)) ) ) ).

fof(t20_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(k4_tarski(A,B),C)
       => ( r2_hidden(A,k1_relat_1(C))
          & r2_hidden(B,k2_relat_1(C)) ) ) ) ).

fof(t21_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => r1_tarski(A,k2_zfmisc_1(k1_relat_1(A),k2_relat_1(A))) ) ).

fof(t22_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k3_xboole_0(A,k2_zfmisc_1(k1_relat_1(A),k2_relat_1(A))) = A ) ).

fof(t23_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( C = k1_tarski(k4_tarski(A,B))
       => ( k1_relat_1(C) = k1_tarski(A)
          & k2_relat_1(C) = k1_tarski(B) ) ) ) ).

fof(t24_relat_1,axiom,
    ! [A,B,C,D,E] :
      ( v1_relat_1(E)
     => ( E = k2_tarski(k4_tarski(A,B),k4_tarski(C,D))
       => ( k1_relat_1(E) = k2_tarski(A,C)
          & k2_relat_1(E) = k2_tarski(B,D) ) ) ) ).

fof(t25_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(A,B)
           => ( r1_tarski(k1_relat_1(A),k1_relat_1(B))
              & r1_tarski(k2_relat_1(A),k2_relat_1(B)) ) ) ) ) ).

fof(t26_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k2_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k2_relat_1(A),k2_relat_1(B)) ) ) ).

fof(t27_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k2_relat_1(k3_xboole_0(A,B)),k3_xboole_0(k2_relat_1(A),k2_relat_1(B))) ) ) ).

fof(t28_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k4_xboole_0(k2_relat_1(A),k2_relat_1(B)),k2_relat_1(k4_xboole_0(A,B))) ) ) ).

fof(d6_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k3_relat_1(A) = k2_xboole_0(k1_relat_1(A),k2_relat_1(A)) ) ).

fof(t29_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( r1_tarski(k1_relat_1(A),k3_relat_1(A))
        & r1_tarski(k2_relat_1(A),k3_relat_1(A)) ) ) ).

fof(t30_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(k4_tarski(A,B),C)
       => ( r2_hidden(A,k3_relat_1(C))
          & r2_hidden(B,k3_relat_1(C)) ) ) ) ).

fof(t31_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(A,B)
           => r1_tarski(k3_relat_1(A),k3_relat_1(B)) ) ) ) ).

fof(t32_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( C = k1_tarski(k4_tarski(A,B))
       => k3_relat_1(C) = k2_tarski(A,B) ) ) ).

fof(t33_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k3_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k3_relat_1(A),k3_relat_1(B)) ) ) ).

fof(t34_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k3_relat_1(k3_xboole_0(A,B)),k3_xboole_0(k3_relat_1(A),k3_relat_1(B))) ) ) ).

fof(d7_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( B = k4_relat_1(A)
          <=> ! [C,D] :
                ( r2_hidden(k4_tarski(C,D),B)
              <=> r2_hidden(k4_tarski(D,C),A) ) ) ) ) ).

fof(t35_relat_1,axiom,
    $true ).

fof(t36_relat_1,axiom,
    $true ).

fof(t37_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( k2_relat_1(A) = k1_relat_1(k4_relat_1(A))
        & k1_relat_1(A) = k2_relat_1(k4_relat_1(A)) ) ) ).

fof(t38_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k3_relat_1(A) = k3_relat_1(k4_relat_1(A)) ) ).

fof(t39_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k3_xboole_0(A,B)) = k3_xboole_0(k4_relat_1(A),k4_relat_1(B)) ) ) ).

fof(t40_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k4_relat_1(A),k4_relat_1(B)) ) ) ).

fof(t41_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k4_xboole_0(A,B)) = k4_xboole_0(k4_relat_1(A),k4_relat_1(B)) ) ) ).

fof(d8_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ( C = k5_relat_1(A,B)
              <=> ! [D,E] :
                    ( r2_hidden(k4_tarski(D,E),C)
                  <=> ? [F] :
                        ( r2_hidden(k4_tarski(D,F),A)
                        & r2_hidden(k4_tarski(F,E),B) ) ) ) ) ) ) ).

fof(t42_relat_1,axiom,
    $true ).

fof(t43_relat_1,axiom,
    $true ).

fof(t44_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k1_relat_1(k5_relat_1(A,B)),k1_relat_1(A)) ) ) ).

fof(t45_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k2_relat_1(k5_relat_1(A,B)),k2_relat_1(B)) ) ) ).

fof(t46_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(k2_relat_1(A),k1_relat_1(B))
           => k1_relat_1(k5_relat_1(A,B)) = k1_relat_1(A) ) ) ) ).

fof(t47_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(k1_relat_1(A),k2_relat_1(B))
           => k2_relat_1(k5_relat_1(B,A)) = k2_relat_1(A) ) ) ) ).

fof(t48_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ( r1_tarski(A,B)
               => r1_tarski(k5_relat_1(C,A),k5_relat_1(C,B)) ) ) ) ) ).

fof(t49_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ( r1_tarski(A,B)
               => r1_tarski(k5_relat_1(A,C),k5_relat_1(B,C)) ) ) ) ) ).

fof(t50_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ! [D] :
                  ( v1_relat_1(D)
                 => ( ( r1_tarski(A,B)
                      & r1_tarski(C,D) )
                   => r1_tarski(k5_relat_1(A,C),k5_relat_1(B,D)) ) ) ) ) ) ).

fof(t51_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => k5_relat_1(A,k2_xboole_0(B,C)) = k2_xboole_0(k5_relat_1(A,B),k5_relat_1(A,C)) ) ) ) ).

fof(t52_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => r1_tarski(k5_relat_1(A,k3_xboole_0(B,C)),k3_xboole_0(k5_relat_1(A,B),k5_relat_1(A,C))) ) ) ) ).

fof(t53_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => r1_tarski(k4_xboole_0(k5_relat_1(A,B),k5_relat_1(A,C)),k5_relat_1(A,k4_xboole_0(B,C))) ) ) ) ).

fof(t54_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k5_relat_1(A,B)) = k5_relat_1(k4_relat_1(B),k4_relat_1(A)) ) ) ).

fof(t55_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => k5_relat_1(k5_relat_1(A,B),C) = k5_relat_1(A,k5_relat_1(B,C)) ) ) ) ).

fof(t56_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ! [B,C] : ~ r2_hidden(k4_tarski(B,C),A)
       => A = k1_xboole_0 ) ) ).

fof(t57_relat_1,axiom,
    $true ).

fof(t58_relat_1,axiom,
    $true ).

fof(t59_relat_1,axiom,
    $true ).

fof(t60_relat_1,axiom,
    ( k1_relat_1(k1_xboole_0) = k1_xboole_0
    & k2_relat_1(k1_xboole_0) = k1_xboole_0 ) ).

fof(t61_relat_1,axiom,
    $true ).

fof(t62_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( k5_relat_1(k1_xboole_0,A) = k1_xboole_0
        & k5_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ) ).

fof(t63_relat_1,axiom,
    $true ).

fof(t64_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ( k1_relat_1(A) = k1_xboole_0
          | k2_relat_1(A) = k1_xboole_0 )
       => A = k1_xboole_0 ) ) ).

fof(t65_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( k1_relat_1(A) = k1_xboole_0
      <=> k2_relat_1(A) = k1_xboole_0 ) ) ).

fof(t66_relat_1,axiom,
    k4_relat_1(k1_xboole_0) = k1_xboole_0 ).

fof(t67_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_xboole_0(k2_relat_1(A),k1_relat_1(B))
           => k5_relat_1(A,B) = k1_xboole_0 ) ) ) ).

fof(d9_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_1(A)
      <=> ~ r2_hidden(k1_xboole_0,k2_relat_1(A)) ) ) ).

fof(d10_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( B = k6_relat_1(A)
      <=> ! [C,D] :
            ( r2_hidden(k4_tarski(C,D),B)
          <=> ( r2_hidden(C,A)
              & C = D ) ) ) ) ).

fof(t68_relat_1,axiom,
    $true ).

fof(t69_relat_1,axiom,
    $true ).

fof(t70_relat_1,axiom,
    $true ).

fof(t71_relat_1,axiom,
    ! [A] :
      ( k1_relat_1(k6_relat_1(A)) = A
      & k2_relat_1(k6_relat_1(A)) = A ) ).

fof(t72_relat_1,axiom,
    ! [A] : k4_relat_1(k6_relat_1(A)) = k6_relat_1(A) ).

fof(t73_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( ! [C] :
            ( r2_hidden(C,A)
           => r2_hidden(k4_tarski(C,C),B) )
       => r1_tarski(k6_relat_1(A),B) ) ) ).

fof(t74_relat_1,axiom,
    ! [A,B,C,D] :
      ( v1_relat_1(D)
     => ( r2_hidden(k4_tarski(A,B),k5_relat_1(k6_relat_1(C),D))
      <=> ( r2_hidden(A,C)
          & r2_hidden(k4_tarski(A,B),D) ) ) ) ).

fof(t75_relat_1,axiom,
    ! [A,B,C,D] :
      ( v1_relat_1(D)
     => ( r2_hidden(k4_tarski(A,B),k5_relat_1(D,k6_relat_1(C)))
      <=> ( r2_hidden(B,C)
          & r2_hidden(k4_tarski(A,B),D) ) ) ) ).

fof(t76_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k5_relat_1(B,k6_relat_1(A)),B)
        & r1_tarski(k5_relat_1(k6_relat_1(A),B),B) ) ) ).

fof(t77_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k1_relat_1(B),A)
       => k5_relat_1(k6_relat_1(A),B) = B ) ) ).

fof(t78_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k5_relat_1(k6_relat_1(k1_relat_1(A)),A) = A ) ).

fof(t79_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k2_relat_1(B),A)
       => k5_relat_1(B,k6_relat_1(A)) = B ) ) ).

fof(t80_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k5_relat_1(A,k6_relat_1(k2_relat_1(A))) = A ) ).

fof(t81_relat_1,axiom,
    k6_relat_1(k1_xboole_0) = k1_xboole_0 ).

fof(t82_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ! [D] :
              ( v1_relat_1(D)
             => ( ( k1_relat_1(B) = A
                  & r1_tarski(k2_relat_1(C),A)
                  & k5_relat_1(C,B) = k6_relat_1(k1_relat_1(D))
                  & k5_relat_1(B,D) = k6_relat_1(A) )
               => D = C ) ) ) ) ).

fof(d11_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( v1_relat_1(C)
         => ( C = k7_relat_1(A,B)
          <=> ! [D,E] :
                ( r2_hidden(k4_tarski(D,E),C)
              <=> ( r2_hidden(D,B)
                  & r2_hidden(k4_tarski(D,E),A) ) ) ) ) ) ).

fof(t83_relat_1,axiom,
    $true ).

fof(t84_relat_1,axiom,
    $true ).

fof(t85_relat_1,axiom,
    $true ).

fof(t86_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k1_relat_1(k7_relat_1(C,B)))
      <=> ( r2_hidden(A,B)
          & r2_hidden(A,k1_relat_1(C)) ) ) ) ).

fof(t87_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k1_relat_1(k7_relat_1(B,A)),A) ) ).

fof(t88_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k7_relat_1(B,A),B) ) ).

fof(t89_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k1_relat_1(k7_relat_1(B,A)),k1_relat_1(B)) ) ).

fof(t90_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k1_relat_1(k7_relat_1(B,A)) = k3_xboole_0(k1_relat_1(B),A) ) ).

fof(t91_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,k1_relat_1(B))
       => k1_relat_1(k7_relat_1(B,A)) = A ) ) ).

fof(t92_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(k7_relat_1(B,A),C),k5_relat_1(B,C)) ) ) ).

fof(t93_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(B,k7_relat_1(C,A)),k5_relat_1(B,C)) ) ) ).

fof(t94_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k7_relat_1(B,A) = k5_relat_1(k6_relat_1(A),B) ) ).

fof(t95_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( k7_relat_1(B,A) = k1_xboole_0
      <=> r1_xboole_0(k1_relat_1(B),A) ) ) ).

fof(t96_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k7_relat_1(B,A) = k3_xboole_0(B,k2_zfmisc_1(A,k2_relat_1(B))) ) ).

fof(t97_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k1_relat_1(B),A)
       => k7_relat_1(B,A) = B ) ) ).

fof(t98_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k7_relat_1(A,k1_relat_1(A)) = A ) ).

fof(t99_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k2_relat_1(k7_relat_1(B,A)),k2_relat_1(B)) ) ).

fof(t100_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(k7_relat_1(C,A),B) = k7_relat_1(C,k3_xboole_0(A,B)) ) ).

fof(t101_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k7_relat_1(k7_relat_1(B,A),A) = k7_relat_1(B,A) ) ).

fof(t102_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k7_relat_1(k7_relat_1(C,A),B) = k7_relat_1(C,A) ) ) ).

fof(t103_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k7_relat_1(k7_relat_1(C,B),A) = k7_relat_1(C,A) ) ) ).

fof(t104_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k7_relat_1(C,A),k7_relat_1(C,B)) ) ) ).

fof(t105_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k7_relat_1(B,A),k7_relat_1(C,A)) ) ) ) ).

fof(t106_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k7_relat_1(C,A),k7_relat_1(D,B)) ) ) ) ).

fof(t107_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k7_relat_1(C,A),k7_relat_1(C,B)) ) ).

fof(t108_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k7_relat_1(C,A),k7_relat_1(C,B)) ) ).

fof(t109_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k7_relat_1(C,A),k7_relat_1(C,B)) ) ).

fof(t110_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k7_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t111_relat_1,axiom,
    ! [A] : k7_relat_1(k1_xboole_0,A) = k1_xboole_0 ).

fof(t112_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k7_relat_1(k5_relat_1(B,C),A) = k5_relat_1(k7_relat_1(B,A),C) ) ) ).

fof(d12_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( C = k8_relat_1(A,B)
          <=> ! [D,E] :
                ( r2_hidden(k4_tarski(D,E),C)
              <=> ( r2_hidden(E,A)
                  & r2_hidden(k4_tarski(D,E),B) ) ) ) ) ) ).

fof(t113_relat_1,axiom,
    $true ).

fof(t114_relat_1,axiom,
    $true ).

fof(t115_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k2_relat_1(k8_relat_1(B,C)))
      <=> ( r2_hidden(A,B)
          & r2_hidden(A,k2_relat_1(C)) ) ) ) ).

fof(t116_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k2_relat_1(k8_relat_1(A,B)),A) ) ).

fof(t117_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k8_relat_1(A,B),B) ) ).

fof(t118_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k2_relat_1(k8_relat_1(A,B)),k2_relat_1(B)) ) ).

fof(t119_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k2_relat_1(k8_relat_1(A,B)) = k3_xboole_0(k2_relat_1(B),A) ) ).

fof(t120_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,k2_relat_1(B))
       => k2_relat_1(k8_relat_1(A,B)) = A ) ) ).

fof(t121_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(k8_relat_1(A,B),C),k5_relat_1(B,C)) ) ) ).

fof(t122_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(B,k8_relat_1(A,C)),k5_relat_1(B,C)) ) ) ).

fof(t123_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k8_relat_1(A,B) = k5_relat_1(B,k6_relat_1(A)) ) ).

fof(t124_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k8_relat_1(A,B) = k3_xboole_0(B,k2_zfmisc_1(k1_relat_1(B),A)) ) ).

fof(t125_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k2_relat_1(B),A)
       => k8_relat_1(A,B) = B ) ) ).

fof(t126_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k8_relat_1(k2_relat_1(A),A) = A ) ).

fof(t127_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(A,k8_relat_1(B,C)) = k8_relat_1(k3_xboole_0(A,B),C) ) ).

fof(t128_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k8_relat_1(A,k8_relat_1(A,B)) = k8_relat_1(A,B) ) ).

fof(t129_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k8_relat_1(B,k8_relat_1(A,C)) = k8_relat_1(A,C) ) ) ).

fof(t130_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k8_relat_1(A,k8_relat_1(B,C)) = k8_relat_1(A,C) ) ) ).

fof(t131_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k8_relat_1(A,C),k8_relat_1(B,C)) ) ) ).

fof(t132_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k8_relat_1(A,B),k8_relat_1(A,C)) ) ) ) ).

fof(t133_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k8_relat_1(A,C),k8_relat_1(B,D)) ) ) ) ).

fof(t134_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(k2_xboole_0(A,B),C) = k2_xboole_0(k8_relat_1(A,C),k8_relat_1(B,C)) ) ).

fof(t135_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(k3_xboole_0(A,B),C) = k3_xboole_0(k8_relat_1(A,C),k8_relat_1(B,C)) ) ).

fof(t136_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(k4_xboole_0(A,B),C) = k4_xboole_0(k8_relat_1(A,C),k8_relat_1(B,C)) ) ).

fof(t137_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k8_relat_1(k1_xboole_0,A) = k1_xboole_0 ) ).

fof(t138_relat_1,axiom,
    ! [A] : k8_relat_1(A,k1_xboole_0) = k1_xboole_0 ).

fof(t139_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k8_relat_1(A,k5_relat_1(B,C)) = k5_relat_1(B,k8_relat_1(A,C)) ) ) ).

fof(t140_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(k8_relat_1(A,C),B) = k8_relat_1(A,k7_relat_1(C,B)) ) ).

fof(d13_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( C = k9_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ? [E] :
                  ( r2_hidden(k4_tarski(E,D),A)
                  & r2_hidden(E,B) ) ) ) ) ).

fof(t141_relat_1,axiom,
    $true ).

fof(t142_relat_1,axiom,
    $true ).

fof(t143_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k9_relat_1(C,B))
      <=> ? [D] :
            ( r2_hidden(D,k1_relat_1(C))
            & r2_hidden(k4_tarski(D,A),C)
            & r2_hidden(D,B) ) ) ) ).

fof(t144_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k9_relat_1(B,A),k2_relat_1(B)) ) ).

fof(t145_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k9_relat_1(B,A) = k9_relat_1(B,k3_xboole_0(k1_relat_1(B),A)) ) ).

fof(t146_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k9_relat_1(A,k1_relat_1(A)) = k2_relat_1(A) ) ).

fof(t147_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k9_relat_1(B,A),k9_relat_1(B,k1_relat_1(B))) ) ).

fof(t148_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k2_relat_1(k7_relat_1(B,A)) = k9_relat_1(B,A) ) ).

fof(t149_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k9_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t150_relat_1,axiom,
    ! [A] : k9_relat_1(k1_xboole_0,A) = k1_xboole_0 ).

fof(t151_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( k9_relat_1(B,A) = k1_xboole_0
      <=> r1_xboole_0(k1_relat_1(B),A) ) ) ).

fof(t152_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( A != k1_xboole_0
          & r1_tarski(A,k1_relat_1(B))
          & k9_relat_1(B,A) = k1_xboole_0 ) ) ).

fof(t153_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k9_relat_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ).

fof(t154_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k9_relat_1(C,k3_xboole_0(A,B)),k3_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B))) ) ).

fof(t155_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k4_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)),k9_relat_1(C,k4_xboole_0(A,B))) ) ).

fof(t156_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t157_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k9_relat_1(B,A),k9_relat_1(C,A)) ) ) ) ).

fof(t158_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k9_relat_1(C,A),k9_relat_1(D,B)) ) ) ) ).

fof(t159_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k9_relat_1(k5_relat_1(B,C),A) = k9_relat_1(C,k9_relat_1(B,A)) ) ) ).

fof(t160_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k2_relat_1(k5_relat_1(A,B)) = k9_relat_1(B,k2_relat_1(A)) ) ) ).

fof(t161_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k9_relat_1(k7_relat_1(C,A),B),k9_relat_1(C,B)) ) ).

fof(t162_relat_1,axiom,
    $true ).

fof(t163_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k3_xboole_0(k1_relat_1(B),A),k9_relat_1(k4_relat_1(B),k9_relat_1(B,A))) ) ).

fof(d14_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( C = k10_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ? [E] :
                  ( r2_hidden(k4_tarski(D,E),A)
                  & r2_hidden(E,B) ) ) ) ) ).

fof(t164_relat_1,axiom,
    $true ).

fof(t165_relat_1,axiom,
    $true ).

fof(t166_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k10_relat_1(C,B))
      <=> ? [D] :
            ( r2_hidden(D,k2_relat_1(C))
            & r2_hidden(k4_tarski(A,D),C)
            & r2_hidden(D,B) ) ) ) ).

fof(t167_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k10_relat_1(B,A),k1_relat_1(B)) ) ).

fof(t168_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k10_relat_1(B,A) = k10_relat_1(B,k3_xboole_0(k2_relat_1(B),A)) ) ).

fof(t169_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k10_relat_1(A,k2_relat_1(A)) = k1_relat_1(A) ) ).

fof(t170_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k10_relat_1(B,A),k10_relat_1(B,k2_relat_1(B))) ) ).

fof(t171_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k10_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t172_relat_1,axiom,
    ! [A] : k10_relat_1(k1_xboole_0,A) = k1_xboole_0 ).

fof(t173_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( k10_relat_1(B,A) = k1_xboole_0
      <=> r1_xboole_0(k2_relat_1(B),A) ) ) ).

fof(t174_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( A != k1_xboole_0
          & r1_tarski(A,k2_relat_1(B))
          & k10_relat_1(B,A) = k1_xboole_0 ) ) ).

fof(t175_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k10_relat_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)) ) ).

fof(t176_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k10_relat_1(C,k3_xboole_0(A,B)),k3_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B))) ) ).

fof(t177_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k4_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)),k10_relat_1(C,k4_xboole_0(A,B))) ) ).

fof(t178_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k10_relat_1(C,A),k10_relat_1(C,B)) ) ) ).

fof(t179_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k10_relat_1(B,A),k10_relat_1(C,A)) ) ) ) ).

fof(t180_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k10_relat_1(C,A),k10_relat_1(D,B)) ) ) ) ).

fof(t181_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k10_relat_1(k5_relat_1(B,C),A) = k10_relat_1(B,k10_relat_1(C,A)) ) ) ).

fof(t182_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k1_relat_1(k5_relat_1(A,B)) = k10_relat_1(A,k1_relat_1(B)) ) ) ).

fof(t183_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k3_xboole_0(k2_relat_1(B),A),k10_relat_1(k4_relat_1(B),k10_relat_1(B,A))) ) ).

fof(d15_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_1(A)
      <=> r1_tarski(k2_relat_1(A),k1_tarski(k1_xboole_0)) ) ) ).

fof(t184_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_1(A)
      <=> ! [B] :
            ( r2_hidden(B,k2_relat_1(A))
           => B = k1_xboole_0 ) ) ) ).

fof(t185_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C,D] :
              ( ( k7_relat_1(A,C) = k7_relat_1(B,C)
                & k7_relat_1(A,D) = k7_relat_1(B,D) )
             => k7_relat_1(A,k2_xboole_0(C,D)) = k7_relat_1(B,k2_xboole_0(C,D)) ) ) ) ).

fof(t186_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( ( r1_tarski(k1_relat_1(C),A)
              & r1_tarski(C,B) )
           => r1_tarski(C,k7_relat_1(B,A)) ) ) ) ).

fof(t187_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_xboole_0(B,k1_relat_1(A))
         => k7_relat_1(A,B) = k1_xboole_0 ) ) ).

fof(t188_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C,D] :
              ( ( r1_tarski(C,D)
                & k7_relat_1(A,D) = k7_relat_1(B,D) )
             => k7_relat_1(A,C) = k7_relat_1(B,C) ) ) ) ).

fof(t189_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k7_relat_1(A,k1_relat_1(B)) = k7_relat_1(A,k1_relat_1(k7_relat_1(B,k1_relat_1(A)))) ) ) ).

fof(t190_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( ~ v3_relat_1(k7_relat_1(B,A))
          & v3_relat_1(B) ) ) ).

fof(s1_relat_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & ! [B,C] :
          ( r2_hidden(k4_tarski(B,C),A)
        <=> ( r2_hidden(B,f1_s1_relat_1)
            & r2_hidden(C,f2_s1_relat_1)
            & p1_s1_relat_1(B,C) ) ) ) ).

fof(dt_k1_relat_1,axiom,
    $true ).

fof(dt_k2_relat_1,axiom,
    $true ).

fof(dt_k3_relat_1,axiom,
    $true ).

fof(dt_k4_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => v1_relat_1(k4_relat_1(A)) ) ).

fof(involutiveness_k4_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k4_relat_1(k4_relat_1(A)) = A ) ).

fof(dt_k5_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k5_relat_1(A,B)) ) ).

fof(dt_k6_relat_1,axiom,
    ! [A] : v1_relat_1(k6_relat_1(A)) ).

fof(dt_k7_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(A)
     => v1_relat_1(k7_relat_1(A,B)) ) ).

fof(dt_k8_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => v1_relat_1(k8_relat_1(A,B)) ) ).

fof(dt_k9_relat_1,axiom,
    $true ).

fof(dt_k10_relat_1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A) ) ).

fof(cc1_funct_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => v1_funct_1(A) ) ).

fof(fc1_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k5_relat_1(A,B))
        & v1_funct_1(k5_relat_1(A,B)) ) ) ).

fof(fc2_funct_1,axiom,
    ! [A] :
      ( v1_relat_1(k6_relat_1(A))
      & v1_funct_1(k6_relat_1(A)) ) ).

fof(rc2_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_xboole_0(A)
      & v1_funct_1(A) ) ).

fof(cc2_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_xboole_0(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_funct_1(A) ) ) ).

fof(rc3_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A) ) ).

fof(fc3_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_funct_1(A) )
     => ( v1_relat_1(k4_relat_1(A))
        & v1_funct_1(k4_relat_1(A)) ) ) ).

fof(fc4_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k7_relat_1(A,B))
        & v1_funct_1(k7_relat_1(A,B)) ) ) ).

fof(fc5_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k8_relat_1(A,B))
        & v1_funct_1(k8_relat_1(A,B)) ) ) ).

fof(rc4_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v3_relat_1(A)
      & v1_funct_1(A) ) ).

fof(rc5_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v2_relat_1(A)
      & v1_funct_1(A) ) ).

fof(fc6_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v2_relat_1(A)
        & v1_funct_1(A) )
     => v1_setfam_1(k2_relat_1(A)) ) ).

fof(d1_funct_1,axiom,
    ! [A] :
      ( v1_funct_1(A)
    <=> ! [B,C,D] :
          ( ( r2_hidden(k4_tarski(B,C),A)
            & r2_hidden(k4_tarski(B,D),A) )
         => C = D ) ) ).

fof(t1_funct_1,axiom,
    $true ).

fof(t2_funct_1,axiom,
    ! [A] :
      ( ( ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D] : k4_tarski(C,D) != B )
        & ! [B,C,D] :
            ( ( r2_hidden(k4_tarski(B,C),A)
              & r2_hidden(k4_tarski(B,D),A) )
           => C = D ) )
     => ( v1_relat_1(A)
        & v1_funct_1(A) ) ) ).

fof(d2_funct_1,axiom,
    $true ).

fof(d3_funct_1,axiom,
    $true ).

fof(d4_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( r2_hidden(B,k1_relat_1(A))
           => ( C = k1_funct_1(A,B)
            <=> r2_hidden(k4_tarski(B,C),A) ) )
          & ( ~ r2_hidden(B,k1_relat_1(A))
           => ( C = k1_funct_1(A,B)
            <=> C = k1_xboole_0 ) ) ) ) ).

fof(t3_funct_1,axiom,
    $true ).

fof(t4_funct_1,axiom,
    $true ).

fof(t5_funct_1,axiom,
    $true ).

fof(t6_funct_1,axiom,
    $true ).

fof(t7_funct_1,axiom,
    $true ).

fof(t8_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(k4_tarski(A,B),C)
      <=> ( r2_hidden(A,k1_relat_1(C))
          & B = k1_funct_1(C,A) ) ) ) ).

fof(t9_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k1_relat_1(A) = k1_relat_1(B)
              & ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => k1_funct_1(A,C) = k1_funct_1(B,C) ) )
           => A = B ) ) ) ).

fof(d5_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( B = k2_relat_1(A)
        <=> ! [C] :
              ( r2_hidden(C,B)
            <=> ? [D] :
                  ( r2_hidden(D,k1_relat_1(A))
                  & C = k1_funct_1(A,D) ) ) ) ) ).

fof(t10_funct_1,axiom,
    $true ).

fof(t11_funct_1,axiom,
    $true ).

fof(t12_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(B))
       => r2_hidden(k1_funct_1(B,A),k2_relat_1(B)) ) ) ).

fof(t13_funct_1,axiom,
    $true ).

fof(t14_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( k1_relat_1(B) = k1_tarski(A)
       => k2_relat_1(B) = k1_tarski(k1_funct_1(B,A)) ) ) ).

fof(t15_funct_1,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => ! [B] :
        ? [C] :
          ( v1_relat_1(C)
          & v1_funct_1(C)
          & k1_relat_1(C) = A
          & k2_relat_1(C) = k1_tarski(B) ) ) ).

fof(t16_funct_1,axiom,
    ! [A] :
      ( ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( k1_relat_1(B) = A
                  & k1_relat_1(C) = A )
               => B = C ) ) )
     => A = k1_xboole_0 ) ).

fof(t17_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( k1_relat_1(B) = k1_relat_1(C)
              & k2_relat_1(B) = k1_tarski(A)
              & k2_relat_1(C) = k1_tarski(A) )
           => B = C ) ) ) ).

fof(t18_funct_1,axiom,
    ! [A,B] :
      ~ ( ~ ( A = k1_xboole_0
            & B != k1_xboole_0 )
        & ! [C] :
            ( ( v1_relat_1(C)
              & v1_funct_1(C) )
           => ~ ( B = k1_relat_1(C)
                & r1_tarski(k2_relat_1(C),A) ) ) ) ).

fof(t19_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ! [C] :
            ~ ( r2_hidden(C,A)
              & ! [D] :
                  ~ ( r2_hidden(D,k1_relat_1(B))
                    & C = k1_funct_1(B,D) ) )
       => r1_tarski(A,k2_relat_1(B)) ) ) ).

fof(t20_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                    <=> ( r2_hidden(D,k1_relat_1(A))
                        & r2_hidden(k1_funct_1(A,D),k1_relat_1(B)) ) )
                  & ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                     => k1_funct_1(C,D) = k1_funct_1(B,k1_funct_1(A,D)) ) )
               => C = k5_relat_1(A,B) ) ) ) ) ).

fof(t21_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(k5_relat_1(C,B)))
          <=> ( r2_hidden(A,k1_relat_1(C))
              & r2_hidden(k1_funct_1(C,A),k1_relat_1(B)) ) ) ) ) ).

fof(t22_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(k5_relat_1(C,B)))
           => k1_funct_1(k5_relat_1(C,B),A) = k1_funct_1(B,k1_funct_1(C,A)) ) ) ) ).

fof(t23_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(B))
           => k1_funct_1(k5_relat_1(B,C),A) = k1_funct_1(C,k1_funct_1(B,A)) ) ) ) ).

fof(t24_funct_1,axiom,
    $true ).

fof(t25_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k2_relat_1(k5_relat_1(C,B)))
           => r2_hidden(A,k2_relat_1(B)) ) ) ) ).

fof(t26_funct_1,axiom,
    $true ).

fof(t27_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( k1_relat_1(k5_relat_1(B,A)) = k1_relat_1(B)
           => r1_tarski(k2_relat_1(B),k1_relat_1(A)) ) ) ) ).

fof(t28_funct_1,axiom,
    $true ).

fof(t29_funct_1,axiom,
    $true ).

fof(t30_funct_1,axiom,
    $true ).

fof(t31_funct_1,axiom,
    $true ).

fof(t32_funct_1,axiom,
    $true ).

fof(t33_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( r1_tarski(k2_relat_1(B),A)
          & ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( k1_relat_1(C) = A
                      & k1_relat_1(D) = A
                      & k5_relat_1(B,C) = k5_relat_1(B,D) )
                   => C = D ) ) ) )
       => A = k2_relat_1(B) ) ) ).

fof(t34_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( B = k6_relat_1(A)
      <=> ( k1_relat_1(B) = A
          & ! [C] :
              ( r2_hidden(C,A)
             => k1_funct_1(B,C) = C ) ) ) ) ).

fof(t35_funct_1,axiom,
    ! [A,B] :
      ( r2_hidden(B,A)
     => k1_funct_1(k6_relat_1(A),B) = B ) ).

fof(t36_funct_1,axiom,
    $true ).

fof(t37_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => k1_relat_1(k5_relat_1(k6_relat_1(A),B)) = k3_xboole_0(k1_relat_1(B),A) ) ).

fof(t38_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k3_xboole_0(k1_relat_1(C),A))
       => k1_funct_1(C,B) = k1_funct_1(k5_relat_1(k6_relat_1(A),C),B) ) ) ).

fof(t39_funct_1,axiom,
    $true ).

fof(t40_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k5_relat_1(C,k6_relat_1(A))))
      <=> ( r2_hidden(B,k1_relat_1(C))
          & r2_hidden(k1_funct_1(C,B),A) ) ) ) ).

fof(t41_funct_1,axiom,
    $true ).

fof(t42_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( k5_relat_1(k6_relat_1(k1_relat_1(A)),A) = A
        & k5_relat_1(A,k6_relat_1(k2_relat_1(A))) = A ) ) ).

fof(t43_funct_1,axiom,
    ! [A,B] : k5_relat_1(k6_relat_1(B),k6_relat_1(A)) = k6_relat_1(k3_xboole_0(A,B)) ).

fof(t44_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k2_relat_1(A) = k1_relat_1(B)
              & k5_relat_1(A,B) = A )
           => B = k6_relat_1(k1_relat_1(B)) ) ) ) ).

fof(d6_funct_1,axiom,
    $true ).

fof(d7_funct_1,axiom,
    $true ).

fof(d8_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
      <=> ! [B,C] :
            ( ( r2_hidden(B,k1_relat_1(A))
              & r2_hidden(C,k1_relat_1(A))
              & k1_funct_1(A,B) = k1_funct_1(A,C) )
           => B = C ) ) ) ).

fof(t45_funct_1,axiom,
    $true ).

fof(t46_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & v2_funct_1(B) )
           => v2_funct_1(k5_relat_1(A,B)) ) ) ) ).

fof(t47_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(k5_relat_1(B,A))
              & r1_tarski(k2_relat_1(B),k1_relat_1(A)) )
           => v2_funct_1(B) ) ) ) ).

fof(t48_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(k5_relat_1(B,A))
              & k2_relat_1(B) = k1_relat_1(A) )
           => ( v2_funct_1(B)
              & v2_funct_1(A) ) ) ) ) ).

fof(t49_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
      <=> ! [B] :
            ( ( v1_relat_1(B)
              & v1_funct_1(B) )
           => ! [C] :
                ( ( v1_relat_1(C)
                  & v1_funct_1(C) )
               => ( ( r1_tarski(k2_relat_1(B),k1_relat_1(A))
                    & r1_tarski(k2_relat_1(C),k1_relat_1(A))
                    & k1_relat_1(B) = k1_relat_1(C)
                    & k5_relat_1(B,A) = k5_relat_1(C,A) )
                 => B = C ) ) ) ) ) ).

fof(t50_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( k1_relat_1(B) = A
              & k1_relat_1(C) = A
              & r1_tarski(k2_relat_1(C),A)
              & v2_funct_1(B)
              & k5_relat_1(C,B) = B )
           => C = k6_relat_1(A) ) ) ) ).

fof(t51_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k2_relat_1(k5_relat_1(B,A)) = k2_relat_1(A)
              & v2_funct_1(A) )
           => r1_tarski(k1_relat_1(A),k2_relat_1(B)) ) ) ) ).

fof(t52_funct_1,axiom,
    ! [A] : v2_funct_1(k6_relat_1(A)) ).

fof(t53_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ? [B] :
            ( v1_relat_1(B)
            & v1_funct_1(B)
            & k5_relat_1(A,B) = k6_relat_1(k1_relat_1(A)) )
       => v2_funct_1(A) ) ) ).

fof(d9_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => k2_funct_1(A) = k4_relat_1(A) ) ) ).

fof(t54_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ! [B] :
            ( ( v1_relat_1(B)
              & v1_funct_1(B) )
           => ( B = k2_funct_1(A)
            <=> ( k1_relat_1(B) = k2_relat_1(A)
                & ! [C,D] :
                    ( ( ( r2_hidden(C,k2_relat_1(A))
                        & D = k1_funct_1(B,C) )
                     => ( r2_hidden(D,k1_relat_1(A))
                        & C = k1_funct_1(A,D) ) )
                    & ( ( r2_hidden(D,k1_relat_1(A))
                        & C = k1_funct_1(A,D) )
                     => ( r2_hidden(C,k2_relat_1(A))
                        & D = k1_funct_1(B,C) ) ) ) ) ) ) ) ) ).

fof(t55_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k2_relat_1(A) = k1_relat_1(k2_funct_1(A))
          & k1_relat_1(A) = k2_relat_1(k2_funct_1(A)) ) ) ) ).

fof(t56_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( v2_funct_1(B)
          & r2_hidden(A,k1_relat_1(B)) )
       => ( A = k1_funct_1(k2_funct_1(B),k1_funct_1(B,A))
          & A = k1_funct_1(k5_relat_1(B,k2_funct_1(B)),A) ) ) ) ).

fof(t57_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( v2_funct_1(B)
          & r2_hidden(A,k2_relat_1(B)) )
       => ( A = k1_funct_1(B,k1_funct_1(k2_funct_1(B),A))
          & A = k1_funct_1(k5_relat_1(k2_funct_1(B),B),A) ) ) ) ).

fof(t58_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k1_relat_1(k5_relat_1(A,k2_funct_1(A))) = k1_relat_1(A)
          & k2_relat_1(k5_relat_1(A,k2_funct_1(A))) = k1_relat_1(A) ) ) ) ).

fof(t59_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k1_relat_1(k5_relat_1(k2_funct_1(A),A)) = k2_relat_1(A)
          & k2_relat_1(k5_relat_1(k2_funct_1(A),A)) = k2_relat_1(A) ) ) ) ).

fof(t60_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & k1_relat_1(A) = k2_relat_1(B)
              & k2_relat_1(A) = k1_relat_1(B)
              & ! [C,D] :
                  ( ( r2_hidden(C,k1_relat_1(A))
                    & r2_hidden(D,k1_relat_1(B)) )
                 => ( k1_funct_1(A,C) = D
                  <=> k1_funct_1(B,D) = C ) ) )
           => B = k2_funct_1(A) ) ) ) ).

fof(t61_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k5_relat_1(A,k2_funct_1(A)) = k6_relat_1(k1_relat_1(A))
          & k5_relat_1(k2_funct_1(A),A) = k6_relat_1(k2_relat_1(A)) ) ) ) ).

fof(t62_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => v2_funct_1(k2_funct_1(A)) ) ) ).

fof(t63_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & k2_relat_1(A) = k1_relat_1(B)
              & k5_relat_1(A,B) = k6_relat_1(k1_relat_1(A)) )
           => B = k2_funct_1(A) ) ) ) ).

fof(t64_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & k2_relat_1(B) = k1_relat_1(A)
              & k5_relat_1(B,A) = k6_relat_1(k2_relat_1(A)) )
           => B = k2_funct_1(A) ) ) ) ).

fof(t65_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => k2_funct_1(k2_funct_1(A)) = A ) ) ).

fof(t66_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & v2_funct_1(B) )
           => k2_funct_1(k5_relat_1(A,B)) = k5_relat_1(k2_funct_1(B),k2_funct_1(A)) ) ) ) ).

fof(t67_funct_1,axiom,
    ! [A] : k2_funct_1(k6_relat_1(A)) = k6_relat_1(A) ).

fof(t68_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( B = k7_relat_1(C,A)
          <=> ( k1_relat_1(B) = k3_xboole_0(k1_relat_1(C),A)
              & ! [D] :
                  ( r2_hidden(D,k1_relat_1(B))
                 => k1_funct_1(B,D) = k1_funct_1(C,D) ) ) ) ) ) ).

fof(t69_funct_1,axiom,
    $true ).

fof(t70_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k7_relat_1(C,A)))
       => k1_funct_1(k7_relat_1(C,A),B) = k1_funct_1(C,B) ) ) ).

fof(t71_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k3_xboole_0(k1_relat_1(C),A))
       => k1_funct_1(k7_relat_1(C,A),B) = k1_funct_1(C,B) ) ) ).

fof(t72_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,A)
       => k1_funct_1(k7_relat_1(C,A),B) = k1_funct_1(C,B) ) ) ).

fof(t73_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r2_hidden(B,k1_relat_1(C))
          & r2_hidden(B,A) )
       => r2_hidden(k1_funct_1(C,B),k2_relat_1(k7_relat_1(C,A))) ) ) ).

fof(t74_funct_1,axiom,
    $true ).

fof(t75_funct_1,axiom,
    $true ).

fof(t76_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k1_relat_1(k7_relat_1(B,A)),k1_relat_1(B))
        & r1_tarski(k2_relat_1(k7_relat_1(B,A)),k2_relat_1(B)) ) ) ).

fof(t77_funct_1,axiom,
    $true ).

fof(t78_funct_1,axiom,
    $true ).

fof(t79_funct_1,axiom,
    $true ).

fof(t80_funct_1,axiom,
    $true ).

fof(t81_funct_1,axiom,
    $true ).

fof(t82_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(A,B)
       => ( k7_relat_1(k7_relat_1(C,A),B) = k7_relat_1(C,A)
          & k7_relat_1(k7_relat_1(C,B),A) = k7_relat_1(C,A) ) ) ) ).

fof(t83_funct_1,axiom,
    $true ).

fof(t84_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => v2_funct_1(k7_relat_1(B,A)) ) ) ).

fof(t85_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( B = k8_relat_1(A,C)
          <=> ( ! [D] :
                  ( r2_hidden(D,k1_relat_1(B))
                <=> ( r2_hidden(D,k1_relat_1(C))
                    & r2_hidden(k1_funct_1(C,D),A) ) )
              & ! [D] :
                  ( r2_hidden(D,k1_relat_1(B))
                 => k1_funct_1(B,D) = k1_funct_1(C,D) ) ) ) ) ) ).

fof(t86_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k8_relat_1(A,C)))
      <=> ( r2_hidden(B,k1_relat_1(C))
          & r2_hidden(k1_funct_1(C,B),A) ) ) ) ).

fof(t87_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k8_relat_1(A,C)))
       => k1_funct_1(k8_relat_1(A,C),B) = k1_funct_1(C,B) ) ) ).

fof(t88_funct_1,axiom,
    $true ).

fof(t89_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k1_relat_1(k8_relat_1(A,B)),k1_relat_1(B))
        & r1_tarski(k2_relat_1(k8_relat_1(A,B)),k2_relat_1(B)) ) ) ).

fof(t90_funct_1,axiom,
    $true ).

fof(t91_funct_1,axiom,
    $true ).

fof(t92_funct_1,axiom,
    $true ).

fof(t93_funct_1,axiom,
    $true ).

fof(t94_funct_1,axiom,
    $true ).

fof(t95_funct_1,axiom,
    $true ).

fof(t96_funct_1,axiom,
    $true ).

fof(t97_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(A,B)
       => ( k8_relat_1(B,k8_relat_1(A,C)) = k8_relat_1(A,C)
          & k8_relat_1(A,k8_relat_1(B,C)) = k8_relat_1(A,C) ) ) ) ).

fof(t98_funct_1,axiom,
    $true ).

fof(t99_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => v2_funct_1(k8_relat_1(A,B)) ) ) ).

fof(d10_funct_1,axiom,
    $true ).

fof(d11_funct_1,axiom,
    $true ).

fof(d12_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( C = k9_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ? [E] :
                  ( r2_hidden(E,k1_relat_1(A))
                  & r2_hidden(E,B)
                  & D = k1_funct_1(A,E) ) ) ) ) ).

fof(t100_funct_1,axiom,
    $true ).

fof(t101_funct_1,axiom,
    $true ).

fof(t102_funct_1,axiom,
    $true ).

fof(t103_funct_1,axiom,
    $true ).

fof(t104_funct_1,axiom,
    $true ).

fof(t105_funct_1,axiom,
    $true ).

fof(t106_funct_1,axiom,
    $true ).

fof(t107_funct_1,axiom,
    $true ).

fof(t108_funct_1,axiom,
    $true ).

fof(t109_funct_1,axiom,
    $true ).

fof(t110_funct_1,axiom,
    $true ).

fof(t111_funct_1,axiom,
    $true ).

fof(t112_funct_1,axiom,
    $true ).

fof(t113_funct_1,axiom,
    $true ).

fof(t114_funct_1,axiom,
    $true ).

fof(t115_funct_1,axiom,
    $true ).

fof(t116_funct_1,axiom,
    $true ).

fof(t117_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(B))
       => k9_relat_1(B,k1_tarski(A)) = k1_tarski(k1_funct_1(B,A)) ) ) ).

fof(t118_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r2_hidden(A,k1_relat_1(C))
          & r2_hidden(B,k1_relat_1(C)) )
       => k9_relat_1(C,k2_tarski(A,B)) = k2_tarski(k1_funct_1(C,A),k1_funct_1(C,B)) ) ) ).

fof(t119_funct_1,axiom,
    $true ).

fof(t120_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k9_relat_1(k8_relat_1(A,C),B),k9_relat_1(C,B)) ) ).

fof(t121_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => k9_relat_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t122_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B,C] : k9_relat_1(A,k3_xboole_0(B,C)) = k3_xboole_0(k9_relat_1(A,B),k9_relat_1(A,C))
       => v2_funct_1(A) ) ) ).

fof(t123_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => k9_relat_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t124_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B,C] : k9_relat_1(A,k4_xboole_0(B,C)) = k4_xboole_0(k9_relat_1(A,B),k9_relat_1(A,C))
       => v2_funct_1(A) ) ) ).

fof(t125_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_xboole_0(A,B)
          & v2_funct_1(C) )
       => r1_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t126_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k9_relat_1(k8_relat_1(A,C),B) = k3_xboole_0(A,k9_relat_1(C,B)) ) ).

fof(d13_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( C = k10_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ( r2_hidden(D,k1_relat_1(A))
                & r2_hidden(k1_funct_1(A,D),B) ) ) ) ) ).

fof(t127_funct_1,axiom,
    $true ).

fof(t128_funct_1,axiom,
    $true ).

fof(t129_funct_1,axiom,
    $true ).

fof(t130_funct_1,axiom,
    $true ).

fof(t131_funct_1,axiom,
    $true ).

fof(t132_funct_1,axiom,
    $true ).

fof(t133_funct_1,axiom,
    $true ).

fof(t134_funct_1,axiom,
    $true ).

fof(t135_funct_1,axiom,
    $true ).

fof(t136_funct_1,axiom,
    $true ).

fof(t137_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k10_relat_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)) ) ).

fof(t138_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k10_relat_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)) ) ).

fof(t139_funct_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k10_relat_1(k7_relat_1(C,A),B) = k3_xboole_0(A,k10_relat_1(C,B)) ) ).

fof(t140_funct_1,axiom,
    $true ).

fof(t141_funct_1,axiom,
    $true ).

fof(t142_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r2_hidden(A,k2_relat_1(B))
      <=> k10_relat_1(B,k1_tarski(A)) != k1_xboole_0 ) ) ).

fof(t143_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( ! [C] :
            ~ ( r2_hidden(C,A)
              & k10_relat_1(B,k1_tarski(C)) = k1_xboole_0 )
       => r1_tarski(A,k2_relat_1(B)) ) ) ).

fof(t144_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B] :
            ~ ( r2_hidden(B,k2_relat_1(A))
              & ! [C] : k10_relat_1(A,k1_tarski(B)) != k1_tarski(C) )
      <=> v2_funct_1(A) ) ) ).

fof(t145_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k9_relat_1(B,k10_relat_1(B,A)),A) ) ).

fof(t146_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,k1_relat_1(B))
       => r1_tarski(A,k10_relat_1(B,k9_relat_1(B,A))) ) ) ).

fof(t147_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(A,k2_relat_1(B))
       => k9_relat_1(B,k10_relat_1(B,A)) = A ) ) ).

fof(t148_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => k9_relat_1(B,k10_relat_1(B,A)) = k3_xboole_0(A,k9_relat_1(B,k1_relat_1(B))) ) ).

fof(t149_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k9_relat_1(C,k3_xboole_0(A,k10_relat_1(C,B))),k3_xboole_0(k9_relat_1(C,A),B)) ) ).

fof(t150_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k9_relat_1(C,k3_xboole_0(A,k10_relat_1(C,B))) = k3_xboole_0(k9_relat_1(C,A),B) ) ).

fof(t151_funct_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k3_xboole_0(A,k10_relat_1(C,B)),k10_relat_1(C,k3_xboole_0(k9_relat_1(C,A),B))) ) ).

fof(t152_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => r1_tarski(k10_relat_1(B,k9_relat_1(B,A)),A) ) ) ).

fof(t153_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B] : r1_tarski(k10_relat_1(A,k9_relat_1(A,B)),B)
       => v2_funct_1(A) ) ) ).

fof(t154_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => k9_relat_1(B,A) = k10_relat_1(k2_funct_1(B),A) ) ) ).

fof(t155_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => k10_relat_1(B,A) = k9_relat_1(k2_funct_1(B),A) ) ) ).

fof(t156_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( A = k2_relat_1(B)
                  & k1_relat_1(C) = A
                  & k1_relat_1(D) = A
                  & k5_relat_1(B,C) = k5_relat_1(B,D) )
               => C = D ) ) ) ) ).

fof(t157_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(k9_relat_1(C,A),k9_relat_1(C,B))
          & r1_tarski(A,k1_relat_1(C))
          & v2_funct_1(C) )
       => r1_tarski(A,B) ) ) ).

fof(t158_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(k10_relat_1(C,A),k10_relat_1(C,B))
          & r1_tarski(A,k2_relat_1(C)) )
       => r1_tarski(A,B) ) ) ).

fof(t159_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
      <=> ! [B] :
          ? [C] : r1_tarski(k10_relat_1(A,k1_tarski(B)),k1_tarski(C)) ) ) ).

fof(t160_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(k2_relat_1(B),k1_relat_1(C))
           => r1_tarski(k10_relat_1(B,A),k10_relat_1(k5_relat_1(B,C),k9_relat_1(C,A))) ) ) ) ).

fof(t161_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( k10_relat_1(C,A) = k10_relat_1(C,B)
          & r1_tarski(A,k2_relat_1(C))
          & r1_tarski(B,k2_relat_1(C)) )
       => A = B ) ) ).

fof(t162_funct_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k9_relat_1(k6_relat_1(A),B) = B ) ).

fof(d14_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v3_relat_1(A)
      <=> ! [B] :
            ( r2_hidden(B,k1_relat_1(A))
           => v1_xboole_0(k1_funct_1(A,B)) ) ) ) ).

fof(d15_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_relat_1(A)
      <=> ! [B] :
            ~ ( r2_hidden(B,k1_relat_1(A))
              & v1_xboole_0(k1_funct_1(A,B)) ) ) ) ).

fof(s1_funct_1,axiom,
    ( ! [A,B,C] :
        ( ( p1_s1_funct_1(A,B)
          & p1_s1_funct_1(A,C) )
       => B = C )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),A)
          <=> ( r2_hidden(B,f1_s1_funct_1)
              & p1_s1_funct_1(B,C) ) ) ) ) ).

fof(s2_funct_1,axiom,
    ( ( ! [A,B,C] :
          ( ( r2_hidden(A,f1_s2_funct_1)
            & p1_s2_funct_1(A,B)
            & p1_s2_funct_1(A,C) )
         => B = C )
      & ! [A] :
          ~ ( r2_hidden(A,f1_s2_funct_1)
            & ! [B] : ~ p1_s2_funct_1(A,B) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & k1_relat_1(A) = f1_s2_funct_1
        & ! [B] :
            ( r2_hidden(B,f1_s2_funct_1)
           => p1_s2_funct_1(B,k1_funct_1(A,B)) ) ) ) ).

fof(s3_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s3_funct_1
      & ! [B] :
          ( r2_hidden(B,f1_s3_funct_1)
         => k1_funct_1(A,B) = f2_s3_funct_1(B) ) ) ).

fof(s4_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s4_funct_1
      & ! [B] :
          ( m1_subset_1(B,f1_s4_funct_1)
         => k1_funct_1(A,B) = f2_s4_funct_1(B) ) ) ).

fof(dt_k1_funct_1,axiom,
    $true ).

fof(dt_k2_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k2_funct_1(A))
        & v1_funct_1(k2_funct_1(A)) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_grfunc_1,axiom,
    $true ).

fof(t2_grfunc_1,axiom,
    $true ).

fof(t3_grfunc_1,axiom,
    $true ).

fof(t4_grfunc_1,axiom,
    $true ).

fof(t5_grfunc_1,axiom,
    $true ).

fof(t6_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( r1_tarski(B,A)
         => ( v1_relat_1(B)
            & v1_funct_1(B) ) ) ) ).

fof(t7_grfunc_1,axiom,
    $true ).

fof(t8_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(A,B)
          <=> ( r1_tarski(k1_relat_1(A),k1_relat_1(B))
              & ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => k1_funct_1(A,C) = k1_funct_1(B,C) ) ) ) ) ) ).

fof(t9_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k1_relat_1(A) = k1_relat_1(B)
              & r1_tarski(A,B) )
           => A = B ) ) ) ).

fof(t10_grfunc_1,axiom,
    $true ).

fof(t11_grfunc_1,axiom,
    $true ).

fof(t12_grfunc_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r2_hidden(k4_tarski(A,B),k5_relat_1(D,C))
           => ( r2_hidden(k4_tarski(A,k1_funct_1(D,A)),D)
              & r2_hidden(k4_tarski(k1_funct_1(D,A),B),C) ) ) ) ) ).

fof(t13_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_tarski(A,B)
               => ( r1_tarski(k5_relat_1(A,C),k5_relat_1(B,C))
                  & r1_tarski(k5_relat_1(C,A),k5_relat_1(C,B)) ) ) ) ) ) ).

fof(t14_grfunc_1,axiom,
    $true ).

fof(t15_grfunc_1,axiom,
    ! [A,B] :
      ( v1_relat_1(k1_tarski(k4_tarski(A,B)))
      & v1_funct_1(k1_tarski(k4_tarski(A,B))) ) ).

fof(t16_grfunc_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( C = k1_tarski(k4_tarski(A,B))
       => k1_funct_1(C,A) = B ) ) ).

fof(t17_grfunc_1,axiom,
    $true ).

fof(t18_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( k1_relat_1(B) = k1_tarski(A)
       => B = k1_tarski(k4_tarski(A,k1_funct_1(B,A))) ) ) ).

fof(t19_grfunc_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(k2_tarski(k4_tarski(A,B),k4_tarski(C,D)))
        & v1_funct_1(k2_tarski(k4_tarski(A,B),k4_tarski(C,D))) )
    <=> ( A = C
       => B = D ) ) ).

fof(t20_grfunc_1,axiom,
    $true ).

fof(t21_grfunc_1,axiom,
    $true ).

fof(t22_grfunc_1,axiom,
    $true ).

fof(t23_grfunc_1,axiom,
    $true ).

fof(t24_grfunc_1,axiom,
    $true ).

fof(t25_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
      <=> ! [B,C,D] :
            ( ( r2_hidden(k4_tarski(B,D),A)
              & r2_hidden(k4_tarski(C,D),A) )
           => B = C ) ) ) ).

fof(t26_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( r1_tarski(A,B)
              & v2_funct_1(B) )
           => v2_funct_1(A) ) ) ) ).

fof(t27_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k3_xboole_0(B,A))
        & v1_funct_1(k3_xboole_0(B,A)) ) ) ).

fof(t28_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( A = k3_xboole_0(B,C)
               => ( r1_tarski(k1_relat_1(A),k3_xboole_0(k1_relat_1(B),k1_relat_1(C)))
                  & r1_tarski(k2_relat_1(A),k3_xboole_0(k2_relat_1(B),k2_relat_1(C))) ) ) ) ) ) ).

fof(t29_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( B = k3_xboole_0(C,D)
                  & r2_hidden(A,k1_relat_1(B)) )
               => ( k1_funct_1(B,A) = k1_funct_1(C,A)
                  & k1_funct_1(B,A) = k1_funct_1(D,A) ) ) ) ) ) ).

fof(t30_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( C = k3_xboole_0(A,B)
               => ( ( ~ v2_funct_1(A)
                    & ~ v2_funct_1(B) )
                  | v2_funct_1(C) ) ) ) ) ) ).

fof(t31_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => ( v1_relat_1(k2_xboole_0(A,B))
              & v1_funct_1(k2_xboole_0(A,B)) ) ) ) ) ).

fof(t32_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( r1_tarski(A,B)
                  & r1_tarski(C,B) )
               => ( v1_relat_1(k2_xboole_0(A,C))
                  & v1_funct_1(k2_xboole_0(A,C)) ) ) ) ) ) ).

fof(t33_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( A = k2_xboole_0(B,C)
               => ( k1_relat_1(A) = k2_xboole_0(k1_relat_1(B),k1_relat_1(C))
                  & k2_relat_1(A) = k2_xboole_0(k2_relat_1(B),k2_relat_1(C)) ) ) ) ) ) ).

fof(t34_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( r2_hidden(A,k1_relat_1(B))
                  & C = k2_xboole_0(B,D) )
               => k1_funct_1(C,A) = k1_funct_1(B,A) ) ) ) ) ).

fof(t35_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( r2_hidden(A,k1_relat_1(B))
                  & C = k2_xboole_0(D,B) )
               => k1_funct_1(C,A) = k1_funct_1(B,A) ) ) ) ) ).

fof(t36_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ~ ( r2_hidden(A,k1_relat_1(B))
                  & B = k2_xboole_0(C,D)
                  & k1_funct_1(B,A) != k1_funct_1(C,A)
                  & k1_funct_1(B,A) != k1_funct_1(D,A) ) ) ) ) ).

fof(t37_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( v2_funct_1(A)
                  & v2_funct_1(B)
                  & C = k2_xboole_0(A,B)
                  & r1_xboole_0(k2_relat_1(A),k2_relat_1(B)) )
               => v2_funct_1(C) ) ) ) ) ).

fof(t38_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k4_xboole_0(B,A))
        & v1_funct_1(k4_xboole_0(B,A)) ) ) ).

fof(t39_grfunc_1,axiom,
    $true ).

fof(t40_grfunc_1,axiom,
    $true ).

fof(t41_grfunc_1,axiom,
    $true ).

fof(t42_grfunc_1,axiom,
    $true ).

fof(t43_grfunc_1,axiom,
    $true ).

fof(t44_grfunc_1,axiom,
    $true ).

fof(t45_grfunc_1,axiom,
    $true ).

fof(t46_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( A = k1_xboole_0
       => v2_funct_1(A) ) ) ).

fof(t47_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ! [B,C] :
            ( r2_hidden(k4_tarski(C,B),k2_funct_1(A))
          <=> r2_hidden(k4_tarski(B,C),A) ) ) ) ).

fof(t48_grfunc_1,axiom,
    $true ).

fof(t49_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( A = k1_xboole_0
       => k2_funct_1(A) = k1_xboole_0 ) ) ).

fof(t50_grfunc_1,axiom,
    $true ).

fof(t51_grfunc_1,axiom,
    $true ).

fof(t52_grfunc_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r2_hidden(A,k1_relat_1(C))
          & r2_hidden(A,B) )
      <=> r2_hidden(k4_tarski(A,k1_funct_1(C,A)),k7_relat_1(C,B)) ) ) ).

fof(t53_grfunc_1,axiom,
    $true ).

fof(t54_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( r1_tarski(k5_relat_1(C,k7_relat_1(B,A)),k5_relat_1(C,B))
                & r1_tarski(k5_relat_1(k7_relat_1(B,A),D),k5_relat_1(B,D)) ) ) ) ) ).

fof(t55_grfunc_1,axiom,
    $true ).

fof(t56_grfunc_1,axiom,
    $true ).

fof(t57_grfunc_1,axiom,
    $true ).

fof(t58_grfunc_1,axiom,
    $true ).

fof(t59_grfunc_1,axiom,
    $true ).

fof(t60_grfunc_1,axiom,
    $true ).

fof(t61_grfunc_1,axiom,
    $true ).

fof(t62_grfunc_1,axiom,
    $true ).

fof(t63_grfunc_1,axiom,
    $true ).

fof(t64_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(A,B)
           => k7_relat_1(B,k1_relat_1(A)) = A ) ) ) ).

fof(t65_grfunc_1,axiom,
    $true ).

fof(t66_grfunc_1,axiom,
    $true ).

fof(t67_grfunc_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r2_hidden(A,k1_relat_1(C))
          & r2_hidden(k1_funct_1(C,A),B) )
      <=> r2_hidden(k4_tarski(A,k1_funct_1(C,A)),k8_relat_1(B,C)) ) ) ).

fof(t68_grfunc_1,axiom,
    $true ).

fof(t69_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( r1_tarski(k5_relat_1(C,k8_relat_1(A,B)),k5_relat_1(C,B))
                & r1_tarski(k5_relat_1(k8_relat_1(A,B),D),k5_relat_1(B,D)) ) ) ) ) ).

fof(t70_grfunc_1,axiom,
    $true ).

fof(t71_grfunc_1,axiom,
    $true ).

fof(t72_grfunc_1,axiom,
    $true ).

fof(t73_grfunc_1,axiom,
    $true ).

fof(t74_grfunc_1,axiom,
    $true ).

fof(t75_grfunc_1,axiom,
    $true ).

fof(t76_grfunc_1,axiom,
    $true ).

fof(t77_grfunc_1,axiom,
    $true ).

fof(t78_grfunc_1,axiom,
    $true ).

fof(t79_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( r1_tarski(A,B)
              & v2_funct_1(B) )
           => k8_relat_1(k2_relat_1(A),B) = A ) ) ) ).

fof(t80_grfunc_1,axiom,
    $true ).

fof(t81_grfunc_1,axiom,
    $true ).

fof(t82_grfunc_1,axiom,
    $true ).

fof(t83_grfunc_1,axiom,
    $true ).

fof(t84_grfunc_1,axiom,
    $true ).

fof(t85_grfunc_1,axiom,
    $true ).

fof(t86_grfunc_1,axiom,
    $true ).

fof(t87_grfunc_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(A,k10_relat_1(C,B))
      <=> ( r2_hidden(k4_tarski(A,k1_funct_1(C,A)),C)
          & r2_hidden(k1_funct_1(C,A),B) ) ) ) ).

fof(t88_grfunc_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_tarski(A,k1_relat_1(B))
              & r1_tarski(B,C) )
           => k7_relat_1(B,A) = k7_relat_1(C,A) ) ) ) ).

fof(t89_grfunc_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( r2_hidden(B,k1_relat_1(A))
         => k7_relat_1(A,k1_tarski(B)) = k1_tarski(k4_tarski(B,k1_funct_1(A,B))) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(d1_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_relat_2(A,B)
        <=> ! [C] :
              ( r2_hidden(C,B)
             => r2_hidden(k4_tarski(C,C),A) ) ) ) ).

fof(d2_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_relat_2(A,B)
        <=> ! [C] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(k4_tarski(C,C),A) ) ) ) ).

fof(d3_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r3_relat_2(A,B)
        <=> ! [C,D] :
              ( ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(k4_tarski(C,D),A) )
             => r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d4_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r4_relat_2(A,B)
        <=> ! [C,D] :
              ( ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(k4_tarski(C,D),A)
                & r2_hidden(k4_tarski(D,C),A) )
             => C = D ) ) ) ).

fof(d5_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r5_relat_2(A,B)
        <=> ! [C,D] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(k4_tarski(C,D),A)
                & r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d6_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r6_relat_2(A,B)
        <=> ! [C,D] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & C != D
                & ~ r2_hidden(k4_tarski(C,D),A)
                & ~ r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d7_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r7_relat_2(A,B)
        <=> ! [C,D] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & ~ r2_hidden(k4_tarski(C,D),A)
                & ~ r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d8_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r8_relat_2(A,B)
        <=> ! [C,D,E] :
              ( ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(E,B)
                & r2_hidden(k4_tarski(C,D),A)
                & r2_hidden(k4_tarski(D,E),A) )
             => r2_hidden(k4_tarski(C,E),A) ) ) ) ).

fof(d9_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
      <=> r1_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d10_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_2(A)
      <=> r2_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d11_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_2(A)
      <=> r3_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d12_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v4_relat_2(A)
      <=> r4_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d13_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v5_relat_2(A)
      <=> r5_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d14_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v6_relat_2(A)
      <=> r6_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d15_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v7_relat_2(A)
      <=> r7_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d16_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v8_relat_2(A)
      <=> r8_relat_2(A,k3_relat_1(A)) ) ) ).

fof(t1_relat_2,axiom,
    $true ).

fof(t2_relat_2,axiom,
    $true ).

fof(t3_relat_2,axiom,
    $true ).

fof(t4_relat_2,axiom,
    $true ).

fof(t5_relat_2,axiom,
    $true ).

fof(t6_relat_2,axiom,
    $true ).

fof(t7_relat_2,axiom,
    $true ).

fof(t8_relat_2,axiom,
    $true ).

fof(t9_relat_2,axiom,
    $true ).

fof(t10_relat_2,axiom,
    $true ).

fof(t11_relat_2,axiom,
    $true ).

fof(t12_relat_2,axiom,
    $true ).

fof(t13_relat_2,axiom,
    $true ).

fof(t14_relat_2,axiom,
    $true ).

fof(t15_relat_2,axiom,
    $true ).

fof(t16_relat_2,axiom,
    $true ).

fof(t17_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
      <=> r1_tarski(k6_relat_1(k3_relat_1(A)),A) ) ) ).

fof(t18_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_2(A)
      <=> r1_xboole_0(k6_relat_1(k3_relat_1(A)),A) ) ) ).

fof(t19_relat_2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r4_relat_2(B,A)
      <=> r5_relat_2(k4_xboole_0(B,k6_relat_1(A)),A) ) ) ).

fof(t20_relat_2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r5_relat_2(B,A)
       => r4_relat_2(k2_xboole_0(B,k6_relat_1(A)),A) ) ) ).

fof(t21_relat_2,axiom,
    $true ).

fof(t22_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ( v3_relat_2(A)
          & v8_relat_2(A) )
       => v1_relat_2(A) ) ) ).

fof(t23_relat_2,axiom,
    ! [A] :
      ( v3_relat_2(k6_relat_1(A))
      & v8_relat_2(k6_relat_1(A)) ) ).

fof(t24_relat_2,axiom,
    ! [A] :
      ( v4_relat_2(k6_relat_1(A))
      & v1_relat_2(k6_relat_1(A)) ) ).

fof(t25_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ( v2_relat_2(A)
          & v8_relat_2(A) )
       => v5_relat_2(A) ) ) ).

fof(t26_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v5_relat_2(A)
       => ( v2_relat_2(A)
          & v4_relat_2(A) ) ) ) ).

fof(t27_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
       => v1_relat_2(k4_relat_1(A)) ) ) ).

fof(t28_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_2(A)
       => v2_relat_2(k4_relat_1(A)) ) ) ).

fof(t29_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
       => ( k1_relat_1(A) = k1_relat_1(k4_relat_1(A))
          & k2_relat_1(A) = k2_relat_1(k4_relat_1(A)) ) ) ) ).

fof(t30_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_2(A)
      <=> A = k4_relat_1(A) ) ) ).

fof(t31_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v1_relat_2(A)
              & v1_relat_2(B) )
           => ( v1_relat_2(k2_xboole_0(A,B))
              & v1_relat_2(k3_xboole_0(A,B)) ) ) ) ) ).

fof(t32_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v2_relat_2(A)
              & v2_relat_2(B) )
           => ( v2_relat_2(k2_xboole_0(A,B))
              & v2_relat_2(k3_xboole_0(A,B)) ) ) ) ) ).

fof(t33_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( v2_relat_2(A)
           => v2_relat_2(k4_xboole_0(A,B)) ) ) ) ).

fof(t34_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_2(A)
       => v3_relat_2(k4_relat_1(A)) ) ) ).

fof(t35_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v3_relat_2(A)
              & v3_relat_2(B) )
           => ( v3_relat_2(k2_xboole_0(A,B))
              & v3_relat_2(k3_xboole_0(A,B))
              & v3_relat_2(k4_xboole_0(A,B)) ) ) ) ) ).

fof(t36_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v5_relat_2(A)
       => v5_relat_2(k4_relat_1(A)) ) ) ).

fof(t37_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v5_relat_2(A)
              & v5_relat_2(B) )
           => v5_relat_2(k3_xboole_0(A,B)) ) ) ) ).

fof(t38_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( v5_relat_2(A)
           => v5_relat_2(k4_xboole_0(A,B)) ) ) ) ).

fof(t39_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v4_relat_2(A)
      <=> r1_tarski(k3_xboole_0(A,k4_relat_1(A)),k6_relat_1(k1_relat_1(A))) ) ) ).

fof(t40_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v4_relat_2(A)
       => v4_relat_2(k4_relat_1(A)) ) ) ).

fof(t41_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( v4_relat_2(A)
           => ( v4_relat_2(k3_xboole_0(A,B))
              & v4_relat_2(k4_xboole_0(A,B)) ) ) ) ) ).

fof(t42_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v8_relat_2(A)
       => v8_relat_2(k4_relat_1(A)) ) ) ).

fof(t43_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v8_relat_2(A)
              & v8_relat_2(B) )
           => v8_relat_2(k3_xboole_0(A,B)) ) ) ) ).

fof(t44_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v8_relat_2(A)
      <=> r1_tarski(k5_relat_1(A,A),A) ) ) ).

fof(t45_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v6_relat_2(A)
      <=> r1_tarski(k4_xboole_0(k2_zfmisc_1(k3_relat_1(A),k3_relat_1(A)),k6_relat_1(k3_relat_1(A))),k2_xboole_0(A,k4_relat_1(A))) ) ) ).

fof(t46_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v7_relat_2(A)
       => ( v6_relat_2(A)
          & v1_relat_2(A) ) ) ) ).

fof(t47_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v7_relat_2(A)
      <=> k2_zfmisc_1(k3_relat_1(A),k3_relat_1(A)) = k2_xboole_0(A,k4_relat_1(A)) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_ordinal1,axiom,
    ! [A] : ~ v1_xboole_0(k1_ordinal1(A)) ).

fof(cc1_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A) ) ) ).

fof(cc2_ordinal1,axiom,
    ! [A] :
      ( ( v1_ordinal1(A)
        & v2_ordinal1(A) )
     => v3_ordinal1(A) ) ).

fof(rc1_ordinal1,axiom,
    ? [A] :
      ( v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A) ) ).

fof(rc2_ordinal1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A)
      & v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A) ) ).

fof(cc3_ordinal1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A) ) ) ).

fof(fc2_ordinal1,axiom,
    ( v1_relat_1(k1_xboole_0)
    & v3_relat_1(k1_xboole_0)
    & v1_funct_1(k1_xboole_0)
    & v2_funct_1(k1_xboole_0)
    & v1_xboole_0(k1_xboole_0)
    & v1_ordinal1(k1_xboole_0)
    & v2_ordinal1(k1_xboole_0)
    & v3_ordinal1(k1_xboole_0) ) ).

fof(rc3_ordinal1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A) ) ).

fof(fc3_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( ~ v1_xboole_0(k1_ordinal1(A))
        & v1_ordinal1(k1_ordinal1(A))
        & v2_ordinal1(k1_ordinal1(A))
        & v3_ordinal1(k1_ordinal1(A)) ) ) ).

fof(fc4_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v1_ordinal1(k3_tarski(A))
        & v2_ordinal1(k3_tarski(A))
        & v3_ordinal1(k3_tarski(A)) ) ) ).

fof(rc4_ordinal1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A) ) ).

fof(fc5_ordinal1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ( v1_ordinal1(k1_relat_1(A))
        & v2_ordinal1(k1_relat_1(A))
        & v3_ordinal1(k1_relat_1(A)) ) ) ).

fof(t1_ordinal1,axiom,
    $true ).

fof(t2_ordinal1,axiom,
    $true ).

fof(t3_ordinal1,axiom,
    ! [A,B,C] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,A) ) ).

fof(t4_ordinal1,axiom,
    ! [A,B,C,D] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,D)
        & r2_hidden(D,A) ) ).

fof(t5_ordinal1,axiom,
    ! [A,B,C,D,E] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,D)
        & r2_hidden(D,E)
        & r2_hidden(E,A) ) ).

fof(t6_ordinal1,axiom,
    ! [A,B,C,D,E,F] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,D)
        & r2_hidden(D,E)
        & r2_hidden(E,F)
        & r2_hidden(F,A) ) ).

fof(t7_ordinal1,axiom,
    ! [A,B] :
      ~ ( r2_hidden(A,B)
        & r1_tarski(B,A) ) ).

fof(d1_ordinal1,axiom,
    ! [A] : k1_ordinal1(A) = k2_xboole_0(A,k1_tarski(A)) ).

fof(t8_ordinal1,axiom,
    $true ).

fof(t9_ordinal1,axiom,
    $true ).

fof(t10_ordinal1,axiom,
    ! [A] : r2_hidden(A,k1_ordinal1(A)) ).

fof(t11_ordinal1,axiom,
    $true ).

fof(t12_ordinal1,axiom,
    ! [A,B] :
      ( k1_ordinal1(A) = k1_ordinal1(B)
     => A = B ) ).

fof(t13_ordinal1,axiom,
    ! [A,B] :
      ( r2_hidden(A,k1_ordinal1(B))
    <=> ( r2_hidden(A,B)
        | A = B ) ) ).

fof(t14_ordinal1,axiom,
    ! [A] : A != k1_ordinal1(A) ).

fof(d2_ordinal1,axiom,
    ! [A] :
      ( v1_ordinal1(A)
    <=> ! [B] :
          ( r2_hidden(B,A)
         => r1_tarski(B,A) ) ) ).

fof(d3_ordinal1,axiom,
    ! [A] :
      ( v2_ordinal1(A)
    <=> ! [B,C] :
          ~ ( r2_hidden(B,A)
            & r2_hidden(C,A)
            & ~ r2_hidden(B,C)
            & B != C
            & ~ r2_hidden(C,B) ) ) ).

fof(d4_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
    <=> ( v1_ordinal1(A)
        & v2_ordinal1(A) ) ) ).

fof(t15_ordinal1,axiom,
    $true ).

fof(t16_ordinal1,axiom,
    $true ).

fof(t17_ordinal1,axiom,
    $true ).

fof(t18_ordinal1,axiom,
    $true ).

fof(t19_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v1_ordinal1(C)
             => ( ( r2_hidden(C,A)
                  & r2_hidden(A,B) )
               => r2_hidden(C,B) ) ) ) ) ).

fof(t20_ordinal1,axiom,
    $true ).

fof(t21_ordinal1,axiom,
    ! [A] :
      ( v1_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_xboole_0(A,B)
           => r2_hidden(A,B) ) ) ) ).

fof(t22_ordinal1,axiom,
    ! [A] :
      ( v1_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( r1_tarski(A,B)
                  & r2_hidden(B,C) )
               => r2_hidden(A,C) ) ) ) ) ).

fof(t23_ordinal1,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( r2_hidden(A,B)
       => v3_ordinal1(A) ) ) ).

fof(t24_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( ~ r2_hidden(A,B)
              & A != B
              & ~ r2_hidden(B,A) ) ) ) ).

fof(t25_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => r3_xboole_0(A,B) ) ) ).

fof(t26_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r1_ordinal1(A,B)
            | r2_hidden(B,A) ) ) ) ).

fof(t27_ordinal1,axiom,
    v3_ordinal1(k1_xboole_0) ).

fof(t28_ordinal1,axiom,
    $true ).

fof(t29_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v3_ordinal1(k1_ordinal1(A)) ) ).

fof(t30_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v3_ordinal1(k3_tarski(A)) ) ).

fof(t31_ordinal1,axiom,
    ! [A] :
      ( ! [B] :
          ( r2_hidden(B,A)
         => ( v3_ordinal1(B)
            & r1_tarski(B,A) ) )
     => v3_ordinal1(A) ) ).

fof(t32_ordinal1,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ~ ( r1_tarski(A,B)
          & A != k1_xboole_0
          & ! [C] :
              ( v3_ordinal1(C)
             => ~ ( r2_hidden(C,A)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,A)
                       => r1_ordinal1(C,D) ) ) ) ) ) ) ).

fof(t33_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
          <=> r1_ordinal1(k1_ordinal1(A),B) ) ) ) ).

fof(t34_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,k1_ordinal1(B))
          <=> r1_ordinal1(A,B) ) ) ) ).

fof(t35_ordinal1,axiom,
    ! [A] :
      ( ! [B] :
          ( r2_hidden(B,A)
         => v3_ordinal1(B) )
     => v3_ordinal1(k3_tarski(A)) ) ).

fof(t36_ordinal1,axiom,
    ! [A] :
      ~ ( ! [B] :
            ( r2_hidden(B,A)
           => v3_ordinal1(B) )
        & ! [B] :
            ( v3_ordinal1(B)
           => ~ r1_tarski(A,B) ) ) ).

fof(t37_ordinal1,axiom,
    ! [A] :
      ~ ! [B] :
          ( r2_hidden(B,A)
        <=> v3_ordinal1(B) ) ).

fof(t38_ordinal1,axiom,
    ! [A] :
      ~ ! [B] :
          ( v3_ordinal1(B)
         => r2_hidden(B,A) ) ).

fof(t39_ordinal1,axiom,
    ! [A] :
    ? [B] :
      ( v3_ordinal1(B)
      & ~ r2_hidden(B,A)
      & ! [C] :
          ( v3_ordinal1(C)
         => ( ~ r2_hidden(C,A)
           => r1_ordinal1(B,C) ) ) ) ).

fof(d5_ordinal1,axiom,
    $true ).

fof(d6_ordinal1,axiom,
    ! [A] :
      ( v4_ordinal1(A)
    <=> A = k3_tarski(A) ) ).

fof(t40_ordinal1,axiom,
    $true ).

fof(t41_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v4_ordinal1(A)
      <=> ! [B] :
            ( v3_ordinal1(B)
           => ( r2_hidden(B,A)
             => r2_hidden(k1_ordinal1(B),A) ) ) ) ) ).

fof(t42_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( ~ ( ~ v4_ordinal1(A)
            & ! [B] :
                ( v3_ordinal1(B)
               => A != k1_ordinal1(B) ) )
        & ~ ( ? [B] :
                ( v3_ordinal1(B)
                & A = k1_ordinal1(B) )
            & v4_ordinal1(A) ) ) ) ).

fof(d7_ordinal1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v5_ordinal1(A)
      <=> v3_ordinal1(k1_relat_1(A)) ) ) ).

fof(d8_ordinal1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B) )
     => ( m1_ordinal1(B,A)
      <=> r1_tarski(k2_relat_1(B),A) ) ) ).

fof(t43_ordinal1,axiom,
    $true ).

fof(t44_ordinal1,axiom,
    $true ).

fof(t45_ordinal1,axiom,
    ! [A] : m1_ordinal1(k1_xboole_0,A) ).

fof(t46_ordinal1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v3_ordinal1(k1_relat_1(A))
       => m1_ordinal1(A,k2_relat_1(A)) ) ) ).

fof(t47_ordinal1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => ! [C] :
          ( m1_ordinal1(C,A)
         => m1_ordinal1(C,B) ) ) ).

fof(t48_ordinal1,axiom,
    ! [A,B] :
      ( m1_ordinal1(B,A)
     => ! [C] :
          ( v3_ordinal1(C)
         => m1_ordinal1(k2_ordinal1(B,C),A) ) ) ).

fof(d9_ordinal1,axiom,
    ! [A] :
      ( v6_ordinal1(A)
    <=> ! [B,C] :
          ( ( r2_hidden(B,A)
            & r2_hidden(C,A) )
         => r3_xboole_0(B,C) ) ) ).

fof(t49_ordinal1,axiom,
    ! [A] :
      ( ( ! [B] :
            ( r2_hidden(B,A)
           => ( v1_relat_1(B)
              & v1_funct_1(B)
              & v5_ordinal1(B) ) )
        & v6_ordinal1(A) )
     => ( v1_relat_1(k3_tarski(A))
        & v1_funct_1(k3_tarski(A))
        & v5_ordinal1(k3_tarski(A)) ) ) ).

fof(t50_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( ~ r2_xboole_0(A,B)
              & A != B
              & ~ r2_xboole_0(B,A) ) ) ) ).

fof(s1_ordinal1,axiom,
    ( ? [A] :
        ( v3_ordinal1(A)
        & p1_s1_ordinal1(A) )
   => ? [A] :
        ( v3_ordinal1(A)
        & p1_s1_ordinal1(A)
        & ! [B] :
            ( v3_ordinal1(B)
           => ( p1_s1_ordinal1(B)
             => r1_ordinal1(A,B) ) ) ) ) ).

fof(s2_ordinal1,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ( ! [B] :
              ( v3_ordinal1(B)
             => ( r2_hidden(B,A)
               => p1_s2_ordinal1(B) ) )
         => p1_s2_ordinal1(A) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => p1_s2_ordinal1(A) ) ) ).

fof(s3_ordinal1,axiom,
    ( ( k1_relat_1(f3_s3_ordinal1) = f1_s3_ordinal1
      & ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B)
                & v5_ordinal1(B) )
             => ( ( r2_hidden(A,f1_s3_ordinal1)
                  & B = k2_ordinal1(f3_s3_ordinal1,A) )
               => k1_funct_1(f3_s3_ordinal1,A) = f2_s3_ordinal1(B) ) ) )
      & k1_relat_1(f4_s3_ordinal1) = f1_s3_ordinal1
      & ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B)
                & v5_ordinal1(B) )
             => ( ( r2_hidden(A,f1_s3_ordinal1)
                  & B = k2_ordinal1(f4_s3_ordinal1,A) )
               => k1_funct_1(f4_s3_ordinal1,A) = f2_s3_ordinal1(B) ) ) ) )
   => f3_s3_ordinal1 = f4_s3_ordinal1 ) ).

fof(s4_ordinal1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & k1_relat_1(A) = f1_s4_ordinal1
      & ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C) )
             => ( ( r2_hidden(B,f1_s4_ordinal1)
                  & C = k2_ordinal1(A,B) )
               => k1_funct_1(A,B) = f2_s4_ordinal1(C) ) ) ) ) ).

fof(s5_ordinal1,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( B = f2_s5_ordinal1(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & B = f3_s5_ordinal1(C)
                  & k1_relat_1(C) = A
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,A)
                       => k1_funct_1(C,D) = f3_s5_ordinal1(k2_ordinal1(C,D)) ) ) ) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(A,k1_relat_1(f1_s5_ordinal1))
           => k1_funct_1(f1_s5_ordinal1,A) = f2_s5_ordinal1(A) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => ( r2_hidden(A,k1_relat_1(f1_s5_ordinal1))
         => k1_funct_1(f1_s5_ordinal1,A) = f3_s5_ordinal1(k2_ordinal1(f1_s5_ordinal1,A)) ) ) ) ).

fof(dt_m1_ordinal1,axiom,
    ! [A,B] :
      ( m1_ordinal1(B,A)
     => ( v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B) ) ) ).

fof(existence_m1_ordinal1,axiom,
    ! [A] :
    ? [B] : m1_ordinal1(B,A) ).

fof(reflexivity_r1_ordinal1,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => r1_ordinal1(A,A) ) ).

fof(connectedness_r1_ordinal1,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => ( r1_ordinal1(A,B)
        | r1_ordinal1(B,A) ) ) ).

fof(redefinition_r1_ordinal1,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => ( r1_ordinal1(A,B)
      <=> r1_tarski(A,B) ) ) ).

fof(dt_k1_ordinal1,axiom,
    $true ).

fof(dt_k2_ordinal1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v3_ordinal1(B) )
     => m1_ordinal1(k2_ordinal1(A,B),k2_relat_1(A)) ) ).

fof(redefinition_k2_ordinal1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v3_ordinal1(B) )
     => k2_ordinal1(A,B) = k7_relat_1(A,B) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(d1_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( C = k1_wellord1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ( D != B
                & r2_hidden(k4_tarski(D,B),A) ) ) ) ) ).

fof(t1_wellord1,axiom,
    $true ).

fof(t2_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r2_hidden(A,k3_relat_1(B))
        | k1_wellord1(B,A) = k1_xboole_0 ) ) ).

fof(d2_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_wellord1(A)
      <=> ! [B] :
            ~ ( r1_tarski(B,k3_relat_1(A))
              & B != k1_xboole_0
              & ! [C] :
                  ~ ( r2_hidden(C,B)
                    & r1_xboole_0(k1_wellord1(A,C),B) ) ) ) ) ).

fof(d3_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_wellord1(A,B)
        <=> ! [C] :
              ~ ( r1_tarski(C,B)
                & C != k1_xboole_0
                & ! [D] :
                    ~ ( r2_hidden(D,C)
                      & r1_xboole_0(k1_wellord1(A,D),C) ) ) ) ) ).

fof(t3_wellord1,axiom,
    $true ).

fof(t4_wellord1,axiom,
    $true ).

fof(t5_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_wellord1(A)
      <=> r1_wellord1(A,k3_relat_1(A)) ) ) ).

fof(d4_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
      <=> ( v1_relat_2(A)
          & v8_relat_2(A)
          & v4_relat_2(A)
          & v6_relat_2(A)
          & v1_wellord1(A) ) ) ) ).

fof(d5_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_wellord1(A,B)
        <=> ( r1_relat_2(A,B)
            & r8_relat_2(A,B)
            & r4_relat_2(A,B)
            & r6_relat_2(A,B)
            & r1_wellord1(A,B) ) ) ) ).

fof(t6_wellord1,axiom,
    $true ).

fof(t7_wellord1,axiom,
    $true ).

fof(t8_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( r2_wellord1(A,k3_relat_1(A))
      <=> v2_wellord1(A) ) ) ).

fof(t9_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r2_wellord1(B,A)
       => ! [C] :
            ~ ( r1_tarski(C,A)
              & C != k1_xboole_0
              & ! [D] :
                  ~ ( r2_hidden(D,C)
                    & ! [E] :
                        ( r2_hidden(E,C)
                       => r2_hidden(k4_tarski(D,E),B) ) ) ) ) ) ).

fof(t10_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => ! [B] :
            ~ ( r1_tarski(B,k3_relat_1(A))
              & B != k1_xboole_0
              & ! [C] :
                  ~ ( r2_hidden(C,B)
                    & ! [D] :
                        ( r2_hidden(D,B)
                       => r2_hidden(k4_tarski(C,D),A) ) ) ) ) ) ).

fof(t11_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ~ ( v2_wellord1(A)
          & k3_relat_1(A) != k1_xboole_0
          & ! [B] :
              ~ ( r2_hidden(B,k3_relat_1(A))
                & ! [C] :
                    ( r2_hidden(C,k3_relat_1(A))
                   => r2_hidden(k4_tarski(B,C),A) ) ) ) ) ).

fof(t12_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => ( k3_relat_1(A) = k1_xboole_0
          | ! [B] :
              ~ ( r2_hidden(B,k3_relat_1(A))
                & ? [C] :
                    ( r2_hidden(C,k3_relat_1(A))
                    & ~ r2_hidden(k4_tarski(C,B),A) )
                & ! [C] :
                    ~ ( r2_hidden(C,k3_relat_1(A))
                      & r2_hidden(k4_tarski(B,C),A)
                      & ! [D] :
                          ~ ( r2_hidden(D,k3_relat_1(A))
                            & r2_hidden(k4_tarski(B,D),A)
                            & D != B
                            & ~ r2_hidden(k4_tarski(C,D),A) ) ) ) ) ) ) ).

fof(t13_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k1_wellord1(B,A),k3_relat_1(B)) ) ).

fof(d6_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] : k2_wellord1(A,B) = k3_xboole_0(A,k2_zfmisc_1(B,B)) ) ).

fof(t14_wellord1,axiom,
    $true ).

fof(t15_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k2_wellord1(B,A),B)
        & r1_tarski(k2_wellord1(B,A),k2_zfmisc_1(A,A)) ) ) ).

fof(t16_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k2_wellord1(C,B))
      <=> ( r2_hidden(A,C)
          & r2_hidden(A,k2_zfmisc_1(B,B)) ) ) ) ).

fof(t17_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k2_wellord1(B,A) = k7_relat_1(k8_relat_1(A,B),A) ) ).

fof(t18_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k2_wellord1(B,A) = k8_relat_1(A,k7_relat_1(B,A)) ) ).

fof(t19_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k3_relat_1(k2_wellord1(C,B)))
       => ( r2_hidden(A,k3_relat_1(C))
          & r2_hidden(A,B) ) ) ) ).

fof(t20_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k3_relat_1(k2_wellord1(B,A)),k3_relat_1(B))
        & r1_tarski(k3_relat_1(k2_wellord1(B,A)),A) ) ) ).

fof(t21_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k1_wellord1(k2_wellord1(C,A),B),k1_wellord1(C,B)) ) ).

fof(t22_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( v1_relat_2(B)
       => v1_relat_2(k2_wellord1(B,A)) ) ) ).

fof(t23_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( v6_relat_2(B)
       => v6_relat_2(k2_wellord1(B,A)) ) ) ).

fof(t24_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( v8_relat_2(B)
       => v8_relat_2(k2_wellord1(B,A)) ) ) ).

fof(t25_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( v4_relat_2(B)
       => v4_relat_2(k2_wellord1(B,A)) ) ) ).

fof(t26_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k2_wellord1(k2_wellord1(C,A),B) = k2_wellord1(C,k3_xboole_0(A,B)) ) ).

fof(t27_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k2_wellord1(k2_wellord1(C,A),B) = k2_wellord1(k2_wellord1(C,B),A) ) ).

fof(t28_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k2_wellord1(k2_wellord1(B,A),A) = k2_wellord1(B,A) ) ).

fof(t29_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k2_wellord1(k2_wellord1(C,B),A) = k2_wellord1(C,A) ) ) ).

fof(t30_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k2_wellord1(A,k3_relat_1(A)) = A ) ).

fof(t31_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( v1_wellord1(B)
       => v1_wellord1(k2_wellord1(B,A)) ) ) ).

fof(t32_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( v2_wellord1(B)
       => v2_wellord1(k2_wellord1(B,A)) ) ) ).

fof(t33_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( v2_wellord1(C)
       => r3_xboole_0(k1_wellord1(C,A),k1_wellord1(C,B)) ) ) ).

fof(t34_wellord1,axiom,
    $true ).

fof(t35_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( v2_wellord1(C)
          & r2_hidden(A,k3_relat_1(C))
          & r2_hidden(B,k1_wellord1(C,A)) )
       => k1_wellord1(k2_wellord1(C,k1_wellord1(C,A)),B) = k1_wellord1(C,B) ) ) ).

fof(t36_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( ( v2_wellord1(B)
          & r1_tarski(A,k3_relat_1(B)) )
       => ( ~ ( A != k3_relat_1(B)
              & ! [C] :
                  ~ ( r2_hidden(C,k3_relat_1(B))
                    & A = k1_wellord1(B,C) ) )
        <=> ! [C] :
              ( r2_hidden(C,A)
             => ! [D] :
                  ( r2_hidden(k4_tarski(D,C),B)
                 => r2_hidden(D,A) ) ) ) ) ) ).

fof(t37_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( v2_wellord1(C)
          & r2_hidden(A,k3_relat_1(C))
          & r2_hidden(B,k3_relat_1(C)) )
       => ( r2_hidden(k4_tarski(A,B),C)
        <=> r1_tarski(k1_wellord1(C,A),k1_wellord1(C,B)) ) ) ) ).

fof(t38_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( v2_wellord1(C)
          & r2_hidden(A,k3_relat_1(C))
          & r2_hidden(B,k3_relat_1(C)) )
       => ( r1_tarski(k1_wellord1(C,A),k1_wellord1(C,B))
        <=> ( A = B
            | r2_hidden(A,k1_wellord1(C,B)) ) ) ) ) ).

fof(t39_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( ( v2_wellord1(B)
          & r1_tarski(A,k3_relat_1(B)) )
       => k3_relat_1(k2_wellord1(B,A)) = A ) ) ).

fof(t40_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( v2_wellord1(B)
       => k3_relat_1(k2_wellord1(B,k1_wellord1(B,A))) = k1_wellord1(B,A) ) ) ).

fof(t41_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => ! [B] :
            ( ! [C] :
                ( ( r2_hidden(C,k3_relat_1(A))
                  & r1_tarski(k1_wellord1(A,C),B) )
               => r2_hidden(C,B) )
           => r1_tarski(k3_relat_1(A),B) ) ) ) ).

fof(t42_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( v2_wellord1(C)
          & r2_hidden(A,k3_relat_1(C))
          & r2_hidden(B,k3_relat_1(C))
          & ! [D] :
              ( r2_hidden(D,k1_wellord1(C,A))
             => ( r2_hidden(k4_tarski(D,B),C)
                & D != B ) ) )
       => r2_hidden(k4_tarski(A,B),C) ) ) ).

fof(t43_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_wellord1(A)
              & k1_relat_1(B) = k3_relat_1(A)
              & r1_tarski(k2_relat_1(B),k3_relat_1(A))
              & ! [C,D] :
                  ( r2_hidden(k4_tarski(C,D),A)
                 => ( C = D
                    | ( r2_hidden(k4_tarski(k1_funct_1(B,C),k1_funct_1(B,D)),A)
                      & k1_funct_1(B,C) != k1_funct_1(B,D) ) ) ) )
           => ! [C] :
                ( r2_hidden(C,k3_relat_1(A))
               => r2_hidden(k4_tarski(C,k1_funct_1(B,C)),A) ) ) ) ) ).

fof(d7_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r3_wellord1(A,B,C)
              <=> ( k1_relat_1(C) = k3_relat_1(A)
                  & k2_relat_1(C) = k3_relat_1(B)
                  & v2_funct_1(C)
                  & ! [D,E] :
                      ( r2_hidden(k4_tarski(D,E),A)
                    <=> ( r2_hidden(D,k3_relat_1(A))
                        & r2_hidden(E,k3_relat_1(A))
                        & r2_hidden(k4_tarski(k1_funct_1(C,D),k1_funct_1(C,E)),B) ) ) ) ) ) ) ) ).

fof(t44_wellord1,axiom,
    $true ).

fof(t45_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r3_wellord1(A,B,C)
               => ! [D,E] :
                    ( r2_hidden(k4_tarski(D,E),A)
                   => ( D = E
                      | ( r2_hidden(k4_tarski(k1_funct_1(C,D),k1_funct_1(C,E)),B)
                        & k1_funct_1(C,D) != k1_funct_1(C,E) ) ) ) ) ) ) ) ).

fof(d8_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r4_wellord1(A,B)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & r3_wellord1(A,B,C) ) ) ) ) ).

fof(t46_wellord1,axiom,
    $true ).

fof(t47_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => r3_wellord1(A,A,k6_relat_1(k3_relat_1(A))) ) ).

fof(t48_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => r4_wellord1(A,A) ) ).

fof(t49_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r3_wellord1(A,B,C)
               => r3_wellord1(B,A,k2_funct_1(C)) ) ) ) ) ).

fof(t50_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r4_wellord1(A,B)
           => r4_wellord1(B,A) ) ) ) ).

fof(t51_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ! [E] :
                      ( ( v1_relat_1(E)
                        & v1_funct_1(E) )
                     => ( ( r3_wellord1(A,B,D)
                          & r3_wellord1(B,C,E) )
                       => r3_wellord1(A,C,k5_relat_1(D,E)) ) ) ) ) ) ) ).

fof(t52_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ( ( r4_wellord1(A,B)
                  & r4_wellord1(B,C) )
               => r4_wellord1(A,C) ) ) ) ) ).

fof(t53_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r3_wellord1(A,B,C)
               => ( ( v1_relat_2(A)
                   => v1_relat_2(B) )
                  & ( v8_relat_2(A)
                   => v8_relat_2(B) )
                  & ( v6_relat_2(A)
                   => v6_relat_2(B) )
                  & ( v4_relat_2(A)
                   => v4_relat_2(B) )
                  & ( v1_wellord1(A)
                   => v1_wellord1(B) ) ) ) ) ) ) ).

fof(t54_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( v2_wellord1(A)
                  & r3_wellord1(A,B,C) )
               => v2_wellord1(B) ) ) ) ) ).

fof(t55_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( v2_wellord1(A)
           => ! [C] :
                ( ( v1_relat_1(C)
                  & v1_funct_1(C) )
               => ! [D] :
                    ( ( v1_relat_1(D)
                      & v1_funct_1(D) )
                   => ( ( r3_wellord1(A,B,C)
                        & r3_wellord1(A,B,D) )
                     => C = D ) ) ) ) ) ) ).

fof(d9_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v2_wellord1(A)
              & r4_wellord1(A,B) )
           => ! [C] :
                ( ( v1_relat_1(C)
                  & v1_funct_1(C) )
               => ( C = k3_wellord1(A,B)
                <=> r3_wellord1(A,B,C) ) ) ) ) ) ).

fof(t56_wellord1,axiom,
    $true ).

fof(t57_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => ! [B] :
            ~ ( r2_hidden(B,k3_relat_1(A))
              & r4_wellord1(A,k2_wellord1(A,k1_wellord1(A,B))) ) ) ) ).

fof(t58_wellord1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ~ ( v2_wellord1(C)
          & r2_hidden(A,k3_relat_1(C))
          & r2_hidden(B,k3_relat_1(C))
          & A != B
          & r4_wellord1(k2_wellord1(C,k1_wellord1(C,A)),k2_wellord1(C,k1_wellord1(C,B))) ) ) ).

fof(t59_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( v2_wellord1(B)
                  & r1_tarski(A,k3_relat_1(B))
                  & r3_wellord1(B,C,D) )
               => ( r3_wellord1(k2_wellord1(B,A),k2_wellord1(C,k9_relat_1(D,A)),k7_relat_1(D,A))
                  & r4_wellord1(k2_wellord1(B,A),k2_wellord1(C,k9_relat_1(D,A))) ) ) ) ) ) ).

fof(t60_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( v2_wellord1(A)
                  & r3_wellord1(A,B,C) )
               => ! [D] :
                    ~ ( r2_hidden(D,k3_relat_1(A))
                      & ! [E] :
                          ~ ( r2_hidden(E,k3_relat_1(B))
                            & k9_relat_1(C,k1_wellord1(A,D)) = k1_wellord1(B,E) ) ) ) ) ) ) ).

fof(t61_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( v2_wellord1(A)
                  & r3_wellord1(A,B,C) )
               => ! [D] :
                    ~ ( r2_hidden(D,k3_relat_1(A))
                      & ! [E] :
                          ~ ( r2_hidden(E,k3_relat_1(B))
                            & r4_wellord1(k2_wellord1(A,k1_wellord1(A,D)),k2_wellord1(B,k1_wellord1(B,E))) ) ) ) ) ) ) ).

fof(t62_wellord1,axiom,
    ! [A,B,C,D] :
      ( v1_relat_1(D)
     => ! [E] :
          ( v1_relat_1(E)
         => ( ( v2_wellord1(D)
              & v2_wellord1(E)
              & r2_hidden(A,k3_relat_1(D))
              & r2_hidden(B,k3_relat_1(E))
              & r2_hidden(C,k3_relat_1(E))
              & r4_wellord1(D,k2_wellord1(E,k1_wellord1(E,B)))
              & r4_wellord1(k2_wellord1(D,k1_wellord1(D,A)),k2_wellord1(E,k1_wellord1(E,C))) )
           => ( r1_tarski(k1_wellord1(E,C),k1_wellord1(E,B))
              & r2_hidden(k4_tarski(C,B),E) ) ) ) ) ).

fof(t63_wellord1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ~ ( v2_wellord1(A)
              & v2_wellord1(B)
              & ~ r4_wellord1(A,B)
              & ! [C] :
                  ~ ( r2_hidden(C,k3_relat_1(A))
                    & r4_wellord1(k2_wellord1(A,k1_wellord1(A,C)),B) )
              & ! [C] :
                  ~ ( r2_hidden(C,k3_relat_1(B))
                    & r4_wellord1(A,k2_wellord1(B,k1_wellord1(B,C))) ) ) ) ) ).

fof(t64_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( r1_tarski(A,k3_relat_1(B))
          & v2_wellord1(B)
          & ~ r4_wellord1(B,k2_wellord1(B,A))
          & ! [C] :
              ~ ( r2_hidden(C,k3_relat_1(B))
                & r4_wellord1(k2_wellord1(B,k1_wellord1(B,C)),k2_wellord1(B,A)) ) ) ) ).

fof(dt_k1_wellord1,axiom,
    $true ).

fof(dt_k2_wellord1,axiom,
    ! [A,B] :
      ( v1_relat_1(A)
     => v1_relat_1(k2_wellord1(A,B)) ) ).

fof(dt_k3_wellord1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => ( v1_relat_1(k3_wellord1(A,B))
        & v1_funct_1(k3_wellord1(A,B)) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_relset_1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(k2_zfmisc_1(A,B)))
     => v1_relat_1(C) ) ).

fof(d1_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
    <=> r1_tarski(C,k2_zfmisc_1(A,B)) ) ).

fof(t1_relset_1,axiom,
    $true ).

fof(t2_relset_1,axiom,
    $true ).

fof(t3_relset_1,axiom,
    $true ).

fof(t4_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,B,C)
     => ( r1_tarski(A,D)
       => m2_relset_1(A,B,C) ) ) ).

fof(t5_relset_1,axiom,
    $true ).

fof(t6_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,B)
     => ~ ( r2_hidden(C,D)
          & ! [E,F] :
              ~ ( C = k4_tarski(E,F)
                & r2_hidden(E,A)
                & r2_hidden(F,B) ) ) ) ).

fof(t7_relset_1,axiom,
    $true ).

fof(t8_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( r2_hidden(C,A)
        & r2_hidden(D,B) )
     => m2_relset_1(k1_tarski(k4_tarski(C,D)),A,B) ) ).

fof(t9_relset_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k1_relat_1(B),A)
       => m2_relset_1(B,A,k2_relat_1(B)) ) ) ).

fof(t10_relset_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k2_relat_1(B),A)
       => m2_relset_1(B,k1_relat_1(B),A) ) ) ).

fof(t11_relset_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( r1_tarski(k1_relat_1(C),A)
          & r1_tarski(k2_relat_1(C),B) )
       => m2_relset_1(C,A,B) ) ) ).

fof(t12_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( r1_tarski(k1_relat_1(C),A)
        & r1_tarski(k2_relat_1(C),B) ) ) ).

fof(t13_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,C)
     => ( r1_tarski(k1_relat_1(D),B)
       => m2_relset_1(D,B,C) ) ) ).

fof(t14_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,C,A)
     => ( r1_tarski(k2_relat_1(D),B)
       => m2_relset_1(D,C,B) ) ) ).

fof(t15_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,C)
     => ( r1_tarski(A,B)
       => m2_relset_1(D,B,C) ) ) ).

fof(t16_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,C,A)
     => ( r1_tarski(A,B)
       => m2_relset_1(D,C,B) ) ) ).

fof(t17_relset_1,axiom,
    ! [A,B,C,D,E] :
      ( m2_relset_1(E,A,C)
     => ( ( r1_tarski(A,B)
          & r1_tarski(C,D) )
       => m2_relset_1(E,B,D) ) ) ).

fof(t18_relset_1,axiom,
    $true ).

fof(t19_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => r1_tarski(k3_relat_1(C),k2_xboole_0(A,B)) ) ).

fof(t20_relset_1,axiom,
    $true ).

fof(t21_relset_1,axiom,
    $true ).

fof(t22_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & ! [E] : ~ r2_hidden(k4_tarski(D,E),C) )
      <=> k4_relset_1(B,A,C) = B ) ) ).

fof(t23_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & ! [E] : ~ r2_hidden(k4_tarski(E,D),C) )
      <=> k5_relset_1(A,B,C) = B ) ) ).

fof(t24_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( k4_relset_1(B,A,k6_relset_1(A,B,C)) = k5_relset_1(A,B,C)
        & k5_relset_1(B,A,k6_relset_1(A,B,C)) = k4_relset_1(A,B,C) ) ) ).

fof(t25_relset_1,axiom,
    ! [A,B] : m2_relset_1(k1_xboole_0,A,B) ).

fof(t26_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( m2_relset_1(C,k1_xboole_0,B)
       => C = k1_xboole_0 ) ) ).

fof(t27_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( m2_relset_1(C,B,k1_xboole_0)
       => C = k1_xboole_0 ) ) ).

fof(t28_relset_1,axiom,
    ! [A] : r1_tarski(k6_relat_1(A),k2_zfmisc_1(A,A)) ).

fof(t29_relset_1,axiom,
    ! [A] : m2_relset_1(k6_relat_1(A),A,A) ).

fof(t30_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,B)
     => ( r1_tarski(k6_relat_1(C),D)
       => ( r1_tarski(C,k4_relset_1(A,B,D))
          & r1_tarski(C,k5_relset_1(A,B,D)) ) ) ) ).

fof(t31_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( r1_tarski(k6_relat_1(B),C)
       => ( B = k4_relset_1(B,A,C)
          & r1_tarski(B,k5_relset_1(B,A,C)) ) ) ) ).

fof(t32_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( r1_tarski(k6_relat_1(B),C)
       => ( r1_tarski(B,k4_relset_1(A,B,C))
          & B = k5_relset_1(A,B,C) ) ) ) ).

fof(t33_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,C)
     => m2_relset_1(k8_relset_1(A,C,D,B),B,C) ) ).

fof(t34_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,B,A)
     => ( r1_tarski(B,C)
       => k8_relset_1(B,A,D,C) = D ) ) ).

fof(t35_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,C,A)
     => m2_relset_1(k9_relset_1(C,A,B,D),C,B) ) ).

fof(t36_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,B)
     => ( r1_tarski(B,C)
       => k9_relset_1(A,B,C,D) = D ) ) ).

fof(t37_relset_1,axiom,
    $true ).

fof(t38_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( k10_relset_1(A,B,C,A) = k5_relset_1(A,B,C)
        & k11_relset_1(A,B,C,B) = k4_relset_1(A,B,C) ) ) ).

fof(t39_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( k10_relset_1(B,A,C,k11_relset_1(B,A,C,A)) = k5_relset_1(B,A,C)
        & k11_relset_1(B,A,C,k10_relset_1(B,A,C,B)) = k4_relset_1(B,A,C) ) ) ).

fof(t40_relset_1,axiom,
    $true ).

fof(t41_relset_1,axiom,
    $true ).

fof(t42_relset_1,axiom,
    $true ).

fof(t43_relset_1,axiom,
    $true ).

fof(t44_relset_1,axiom,
    $true ).

fof(t45_relset_1,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => ( k5_relat_1(B,k6_relat_1(A)) = B
        & k5_relat_1(k6_relat_1(A),B) = B ) ) ).

fof(t46_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => k6_relat_1(A) != k1_xboole_0 ) ).

fof(t47_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,A,B)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ( r2_hidden(D,k4_relset_1(A,B,C))
                  <=> ? [E] :
                        ( m1_subset_1(E,B)
                        & r2_hidden(k4_tarski(D,E),C) ) ) ) ) ) ) ).

fof(t48_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,B,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ( r2_hidden(D,k5_relset_1(B,A,C))
                  <=> ? [E] :
                        ( m1_subset_1(E,B)
                        & r2_hidden(k4_tarski(E,D),C) ) ) ) ) ) ) ).

fof(t49_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,A,B)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ~ ( r2_hidden(D,k4_relset_1(A,B,C))
                      & ! [E] :
                          ( m1_subset_1(E,B)
                         => ~ r2_hidden(E,k5_relset_1(A,B,C)) ) ) ) ) ) ) ).

fof(t50_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,B,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ~ ( r2_hidden(D,k5_relset_1(B,A,C))
                      & ! [E] :
                          ( m1_subset_1(E,B)
                         => ~ r2_hidden(E,k4_relset_1(B,A,C)) ) ) ) ) ) ) ).

fof(t51_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_relset_1(D,A,B)
                 => ! [E] :
                      ( m2_relset_1(E,B,C)
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ! [G] :
                              ( m1_subset_1(G,C)
                             => ( r2_hidden(k4_tarski(F,G),k7_relset_1(A,B,B,C,D,E))
                              <=> ? [H] :
                                    ( m1_subset_1(H,B)
                                    & r2_hidden(k4_tarski(F,H),D)
                                    & r2_hidden(k4_tarski(H,G),E) ) ) ) ) ) ) ) ) ) ).

fof(t52_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_relset_1(D,C,A)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ( r2_hidden(E,k10_relset_1(C,A,D,B))
                      <=> ? [F] :
                            ( m1_subset_1(F,C)
                            & r2_hidden(k4_tarski(F,E),D)
                            & r2_hidden(F,B) ) ) ) ) ) ) ) ).

fof(t53_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_relset_1(D,A,C)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ( r2_hidden(E,k11_relset_1(A,C,D,B))
                      <=> ? [F] :
                            ( m1_subset_1(F,C)
                            & r2_hidden(k4_tarski(E,F),D)
                            & r2_hidden(F,B) ) ) ) ) ) ) ) ).

fof(s1_relset_1,axiom,
    ? [A] :
      ( m2_relset_1(A,f1_s1_relset_1,f2_s1_relset_1)
      & ! [B,C] :
          ( r2_hidden(k4_tarski(B,C),A)
        <=> ( r2_hidden(B,f1_s1_relset_1)
            & r2_hidden(C,f2_s1_relset_1)
            & p1_s1_relset_1(B,C) ) ) ) ).

fof(s2_relset_1,axiom,
    ? [A] :
      ( m2_relset_1(A,f1_s2_relset_1,f2_s2_relset_1)
      & ! [B] :
          ( m1_subset_1(B,f1_s2_relset_1)
         => ! [C] :
              ( m1_subset_1(C,f2_s2_relset_1)
             => ( r2_hidden(k4_tarski(B,C),A)
              <=> p1_s2_relset_1(B,C) ) ) ) ) ).

fof(dt_m1_relset_1,axiom,
    $true ).

fof(existence_m1_relset_1,axiom,
    ! [A,B] :
    ? [C] : m1_relset_1(C,A,B) ).

fof(dt_m2_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => m1_subset_1(C,k1_zfmisc_1(k2_zfmisc_1(A,B))) ) ).

fof(existence_m2_relset_1,axiom,
    ! [A,B] :
    ? [C] : m2_relset_1(C,A,B) ).

fof(redefinition_m2_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
    <=> m1_relset_1(C,A,B) ) ).

fof(dt_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => m2_relset_1(k1_relset_1(A,B,C,D),A,B) ) ).

fof(commutativity_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k1_relset_1(A,B,C,D) = k1_relset_1(A,B,D,C) ) ).

fof(idempotence_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k1_relset_1(A,B,C,C) = C ) ).

fof(redefinition_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k1_relset_1(A,B,C,D) = k2_xboole_0(C,D) ) ).

fof(dt_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => m2_relset_1(k2_relset_1(A,B,C,D),A,B) ) ).

fof(commutativity_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k2_relset_1(A,B,C,D) = k2_relset_1(A,B,D,C) ) ).

fof(idempotence_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k2_relset_1(A,B,C,C) = C ) ).

fof(redefinition_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k2_relset_1(A,B,C,D) = k3_xboole_0(C,D) ) ).

fof(dt_k3_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => m2_relset_1(k3_relset_1(A,B,C,D),A,B) ) ).

fof(redefinition_k3_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k3_relset_1(A,B,C,D) = k4_xboole_0(C,D) ) ).

fof(dt_k4_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k4_relset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(redefinition_k4_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k4_relset_1(A,B,C) = k1_relat_1(C) ) ).

fof(dt_k5_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k5_relset_1(A,B,C),k1_zfmisc_1(B)) ) ).

fof(redefinition_k5_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k5_relset_1(A,B,C) = k2_relat_1(C) ) ).

fof(dt_k6_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => m2_relset_1(k6_relset_1(A,B,C),B,A) ) ).

fof(involutiveness_k6_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k6_relset_1(A,B,k6_relset_1(A,B,C)) = C ) ).

fof(redefinition_k6_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k6_relset_1(A,B,C) = k4_relat_1(C) ) ).

fof(dt_k7_relset_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( m1_relset_1(E,A,B)
        & m1_relset_1(F,C,D) )
     => m2_relset_1(k7_relset_1(A,B,C,D,E,F),A,D) ) ).

fof(redefinition_k7_relset_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( m1_relset_1(E,A,B)
        & m1_relset_1(F,C,D) )
     => k7_relset_1(A,B,C,D,E,F) = k5_relat_1(E,F) ) ).

fof(dt_k8_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => m2_relset_1(k8_relset_1(A,B,C,D),A,B) ) ).

fof(redefinition_k8_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => k8_relset_1(A,B,C,D) = k7_relat_1(C,D) ) ).

fof(dt_k9_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(D,A,B)
     => m2_relset_1(k9_relset_1(A,B,C,D),A,B) ) ).

fof(redefinition_k9_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(D,A,B)
     => k9_relset_1(A,B,C,D) = k8_relat_1(C,D) ) ).

fof(dt_k10_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k10_relset_1(A,B,C,D),k1_zfmisc_1(B)) ) ).

fof(redefinition_k10_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => k10_relset_1(A,B,C,D) = k9_relat_1(C,D) ) ).

fof(dt_k11_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k11_relset_1(A,B,C,D),k1_zfmisc_1(A)) ) ).

fof(redefinition_k11_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => k11_relset_1(A,B,C,D) = k10_relat_1(C,D) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_partfun1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A)
      & v1_xboole_0(A) ) ).

fof(rc2_partfun1,axiom,
    ! [A,B] :
    ? [C] :
      ( m1_relset_1(C,A,B)
      & v1_relat_1(C)
      & v1_funct_1(C) ) ).

fof(fc1_partfun1,axiom,
    ! [A,B] : ~ v1_xboole_0(k4_partfun1(A,B)) ).

fof(rc3_partfun1,axiom,
    ! [A] :
    ? [B] :
      ( m1_relset_1(B,A,A)
      & v1_relat_1(B)
      & v1_relat_2(B)
      & v3_relat_2(B)
      & v4_relat_2(B)
      & v8_relat_2(B)
      & v1_partfun1(B,A,A) ) ).

fof(cc1_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v3_relat_2(A)
        & v8_relat_2(A) )
     => ( v1_relat_1(A)
        & v1_relat_2(A) ) ) ).

fof(fc2_partfun1,axiom,
    ! [A] :
      ( v1_relat_1(k6_relat_1(A))
      & v1_funct_1(k6_relat_1(A))
      & v1_relat_2(k6_relat_1(A))
      & v3_relat_2(k6_relat_1(A))
      & v4_relat_2(k6_relat_1(A))
      & v8_relat_2(k6_relat_1(A)) ) ).

fof(t1_partfun1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( r1_tarski(A,k2_zfmisc_1(B,C))
        & r1_tarski(D,k2_zfmisc_1(E,F)) )
     => r1_tarski(k2_xboole_0(A,D),k2_zfmisc_1(k2_xboole_0(B,E),k2_xboole_0(C,F))) ) ).

fof(t2_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ~ ( ! [C] :
                  ( r2_hidden(C,k3_xboole_0(k1_relat_1(A),k1_relat_1(B)))
                 => k1_funct_1(A,C) = k1_funct_1(B,C) )
              & ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C) )
                 => k2_xboole_0(A,B) != C ) ) ) ) ).

fof(t3_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( k2_xboole_0(A,B) = C
               => ! [D] :
                    ( r2_hidden(D,k3_xboole_0(k1_relat_1(A),k1_relat_1(B)))
                   => k1_funct_1(A,D) = k1_funct_1(B,D) ) ) ) ) ) ).

fof(t4_partfun1,axiom,
    $true ).

fof(t5_partfun1,axiom,
    $true ).

fof(t6_partfun1,axiom,
    $true ).

fof(t7_partfun1,axiom,
    $true ).

fof(t8_partfun1,axiom,
    $true ).

fof(t9_partfun1,axiom,
    $true ).

fof(t10_partfun1,axiom,
    k2_relat_1(k1_xboole_0) = k1_xboole_0 ).

fof(t11_partfun1,axiom,
    $true ).

fof(t12_partfun1,axiom,
    $true ).

fof(t13_partfun1,axiom,
    $true ).

fof(t14_partfun1,axiom,
    $true ).

fof(t15_partfun1,axiom,
    $true ).

fof(t16_partfun1,axiom,
    $true ).

fof(t17_partfun1,axiom,
    $true ).

fof(t18_partfun1,axiom,
    $true ).

fof(t19_partfun1,axiom,
    $true ).

fof(t20_partfun1,axiom,
    $true ).

fof(t21_partfun1,axiom,
    $true ).

fof(t22_partfun1,axiom,
    $true ).

fof(t23_partfun1,axiom,
    $true ).

fof(t24_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(A)
        & m2_relset_1(A,k1_relat_1(A),k2_relat_1(A)) ) ) ).

fof(t25_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k2_relat_1(B),A)
       => ( v1_funct_1(B)
          & m2_relset_1(B,k1_relat_1(B),A) ) ) ) ).

fof(t26_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ~ ( r2_hidden(C,k2_relat_1(D))
          & ! [E] :
              ( m1_subset_1(E,A)
             => ~ ( r2_hidden(E,k4_relset_1(A,B,D))
                  & C = k1_funct_1(D,E) ) ) ) ) ).

fof(t27_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r2_hidden(C,k4_relset_1(A,B,D))
       => r2_hidden(k1_funct_1(D,C),B) ) ) ).

fof(t28_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(k4_relset_1(A,B,D),C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,C,B) ) ) ) ).

fof(t29_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(k2_relat_1(D),C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,A,C) ) ) ) ).

fof(t30_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(A,C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,C,B) ) ) ) ).

fof(t31_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(B,C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,A,C) ) ) ) ).

fof(t32_partfun1,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & m2_relset_1(E,A,B) )
     => ( ( r1_tarski(A,C)
          & r1_tarski(B,D) )
       => ( v1_funct_1(E)
          & m2_relset_1(E,C,D) ) ) ) ).

fof(t33_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( r1_tarski(C,D)
           => ( v1_funct_1(C)
              & m2_relset_1(C,A,B) ) ) ) ) ).

fof(t34_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( k4_relset_1(A,B,C) = k4_relset_1(A,B,D)
              & ! [E] :
                  ( m1_subset_1(E,A)
                 => ( r2_hidden(E,k4_relset_1(A,B,C))
                   => k1_funct_1(C,E) = k1_funct_1(D,E) ) ) )
           => C = D ) ) ) ).

fof(t35_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
         => ( ( k4_relset_1(k2_zfmisc_1(A,B),C,D) = k4_relset_1(k2_zfmisc_1(A,B),C,E)
              & ! [F,G] :
                  ( r2_hidden(k4_tarski(F,G),k4_relset_1(k2_zfmisc_1(A,B),C,D))
                 => k1_funct_1(D,k4_tarski(F,G)) = k1_funct_1(E,k4_tarski(F,G)) ) )
           => D = E ) ) ) ).

fof(t36_partfun1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => k5_relat_1(k6_relat_1(A),C) = C ) ).

fof(t37_partfun1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => k5_relat_1(C,k6_relat_1(B)) = C ) ).

fof(t38_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( ! [D] :
            ( m1_subset_1(D,A)
           => ! [E] :
                ( m1_subset_1(E,A)
               => ( ( r2_hidden(D,k4_relset_1(A,B,C))
                    & r2_hidden(E,k4_relset_1(A,B,C))
                    & k1_funct_1(C,D) = k1_funct_1(C,E) )
                 => D = E ) ) )
       => v2_funct_1(C) ) ) ).

fof(t39_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( v2_funct_1(C)
       => ( v1_funct_1(k2_funct_1(C))
          & m2_relset_1(k2_funct_1(C),B,A) ) ) ) ).

fof(t40_partfun1,axiom,
    $true ).

fof(t41_partfun1,axiom,
    $true ).

fof(t42_partfun1,axiom,
    $true ).

fof(t43_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k8_relset_1(A,B,D,C))
        & m2_relset_1(k8_relset_1(A,B,D,C),C,B) ) ) ).

fof(t44_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k8_relset_1(A,B,D,C))
        & m2_relset_1(k8_relset_1(A,B,D,C),A,B) ) ) ).

fof(t45_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k9_relset_1(A,B,C,D))
        & m2_relset_1(k9_relset_1(A,B,C,D),A,C) ) ) ).

fof(t46_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k9_relset_1(A,B,C,D))
        & m2_relset_1(k9_relset_1(A,B,C,D),A,B) ) ) ).

fof(t47_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_funct_1(k7_relat_1(k8_relat_1(A,C),B))
        & m2_relset_1(k7_relat_1(k8_relat_1(A,C),B),B,A) ) ) ).

fof(t48_partfun1,axiom,
    $true ).

fof(t49_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ~ ( r2_hidden(C,k9_relat_1(D,A))
          & ! [E] :
              ( m1_subset_1(E,A)
             => ~ ( r2_hidden(E,k4_relset_1(A,B,D))
                  & C = k1_funct_1(D,E) ) ) ) ) ).

fof(t50_partfun1,axiom,
    $true ).

fof(t51_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => k9_relat_1(C,A) = k2_relat_1(C) ) ).

fof(t52_partfun1,axiom,
    $true ).

fof(t53_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => k10_relat_1(C,B) = k4_relset_1(A,B,C) ) ).

fof(t54_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => ( k4_relset_1(k1_xboole_0,A,B) = k1_xboole_0
        & k2_relat_1(B) = k1_xboole_0 ) ) ).

fof(t55_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( k1_relat_1(C) = k1_xboole_0
       => ( v1_funct_1(C)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t56_partfun1,axiom,
    ! [A,B] :
      ( v1_funct_1(k1_xboole_0)
      & m2_relset_1(k1_xboole_0,A,B) ) ).

fof(t57_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => B = k1_xboole_0 ) ).

fof(t58_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_xboole_0,A) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,k1_xboole_0,B) )
         => C = D ) ) ).

fof(t59_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => v2_funct_1(B) ) ).

fof(t60_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k9_relat_1(C,B) = k1_xboole_0 ) ).

fof(t61_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k10_relat_1(C,B) = k1_xboole_0 ) ).

fof(t62_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => ( k4_relset_1(A,k1_xboole_0,B) = k1_xboole_0
        & k2_relat_1(B) = k1_xboole_0 ) ) ).

fof(t63_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( k2_relat_1(C) = k1_xboole_0
       => ( v1_funct_1(C)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t64_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => B = k1_xboole_0 ) ).

fof(t65_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_xboole_0) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,B,k1_xboole_0) )
         => C = D ) ) ).

fof(t66_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => v2_funct_1(B) ) ).

fof(t67_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_xboole_0) )
     => k9_relat_1(C,B) = k1_xboole_0 ) ).

fof(t68_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_xboole_0) )
     => k10_relat_1(C,B) = k1_xboole_0 ) ).

fof(t69_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_tarski(A),B) )
     => r1_tarski(k2_relat_1(C),k1_tarski(k1_funct_1(C,A))) ) ).

fof(t70_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_tarski(A),B) )
     => v2_funct_1(C) ) ).

fof(t71_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k1_tarski(A),B) )
     => r1_tarski(k9_relat_1(D,C),k1_tarski(k1_funct_1(D,A))) ) ).

fof(t72_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( ( k1_relat_1(D) = k1_tarski(A)
          & r2_hidden(A,B)
          & r2_hidden(k1_funct_1(D,A),C) )
       => ( v1_funct_1(D)
          & m2_relset_1(D,B,C) ) ) ) ).

fof(t73_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,k1_tarski(B)) )
     => ( r2_hidden(C,k4_relset_1(A,k1_tarski(B),D))
       => k1_funct_1(D,C) = B ) ) ).

fof(t74_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,k1_tarski(B)) )
         => ( k4_relset_1(A,k1_tarski(B),C) = k4_relset_1(A,k1_tarski(B),D)
           => C = D ) ) ) ).

fof(d1_partfun1,axiom,
    $true ).

fof(d2_partfun1,axiom,
    $true ).

fof(d3_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] : k3_partfun1(A,B,C) = k7_relat_1(k8_relat_1(C,A),B) ) ).

fof(t75_partfun1,axiom,
    $true ).

fof(t76_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k3_partfun1(C,A,B),C) ) ).

fof(t77_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k4_relset_1(A,B,k3_partfun1(C,A,B)),k1_relat_1(C))
        & r1_tarski(k2_relat_1(k3_partfun1(C,A,B)),k2_relat_1(C)) ) ) ).

fof(t78_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r2_hidden(A,k4_relset_1(B,C,k3_partfun1(D,B,C)))
      <=> ( r2_hidden(A,k1_relat_1(D))
          & r2_hidden(A,B)
          & r2_hidden(k1_funct_1(D,A),C) ) ) ) ).

fof(t79_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( ( r2_hidden(A,k1_relat_1(D))
          & r2_hidden(A,B)
          & r2_hidden(k1_funct_1(D,A),C) )
       => k1_funct_1(k3_partfun1(D,B,C),A) = k1_funct_1(D,A) ) ) ).

fof(t80_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r2_hidden(A,k4_relset_1(B,C,k3_partfun1(D,B,C)))
       => k1_funct_1(k3_partfun1(D,B,C),A) = k1_funct_1(D,A) ) ) ).

fof(t81_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r1_tarski(C,D)
           => r1_tarski(k3_partfun1(C,A,B),k3_partfun1(D,A,B)) ) ) ) ).

fof(t82_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r1_tarski(A,B)
       => r1_tarski(k3_partfun1(D,A,C),k3_partfun1(D,B,C)) ) ) ).

fof(t83_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r1_tarski(A,B)
       => r1_tarski(k3_partfun1(D,C,A),k3_partfun1(D,C,B)) ) ) ).

fof(t84_partfun1,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ( ( r1_tarski(A,B)
          & r1_tarski(C,D) )
       => r1_tarski(k3_partfun1(E,A,C),k3_partfun1(E,B,D)) ) ) ).

fof(t85_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(k1_relat_1(C),A)
          & r1_tarski(k2_relat_1(C),B) )
       => C = k3_partfun1(C,A,B) ) ) ).

fof(t86_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => A = k3_partfun1(A,k1_relat_1(A),k2_relat_1(A)) ) ).

fof(t87_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => k3_partfun1(C,A,B) = C ) ).

fof(t88_partfun1,axiom,
    $true ).

fof(t89_partfun1,axiom,
    $true ).

fof(t90_partfun1,axiom,
    $true ).

fof(t91_partfun1,axiom,
    ! [A,B] : k3_partfun1(k1_xboole_0,A,B) = k1_xboole_0 ).

fof(t92_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ! [E] :
          ( ( v1_relat_1(E)
            & v1_funct_1(E) )
         => r1_tarski(k1_partfun1(C,A,A,B,k3_partfun1(D,C,A),k3_partfun1(E,A,B)),k3_partfun1(k5_relat_1(D,E),C,B)) ) ) ).

fof(t93_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ! [E] :
          ( ( v1_relat_1(E)
            & v1_funct_1(E) )
         => ( r1_tarski(k3_xboole_0(k2_relat_1(D),k1_relat_1(E)),A)
           => k1_partfun1(C,A,A,B,k3_partfun1(D,C,A),k3_partfun1(E,A,B)) = k3_partfun1(k5_relat_1(D,E),C,B) ) ) ) ).

fof(t94_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => v2_funct_1(k3_partfun1(C,A,B)) ) ) ).

fof(t95_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => k2_funct_1(k3_partfun1(C,A,B)) = k3_partfun1(k2_funct_1(C),B,A) ) ) ).

fof(t96_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => k2_partfun1(A,B,k3_partfun1(D,A,B),C) = k3_partfun1(D,k3_xboole_0(A,C),B) ) ).

fof(t97_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => k9_relset_1(B,C,A,k3_partfun1(D,B,C)) = k3_partfun1(D,B,k3_xboole_0(A,C)) ) ).

fof(d4_partfun1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( v1_partfun1(C,A,B)
      <=> k4_relset_1(A,B,C) = A ) ) ).

fof(t98_partfun1,axiom,
    $true ).

fof(t99_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( ( v1_partfun1(C,A,B)
          & B = k1_xboole_0 )
       => A = k1_xboole_0 ) ) ).

fof(t100_partfun1,axiom,
    $true ).

fof(t101_partfun1,axiom,
    $true ).

fof(t102_partfun1,axiom,
    $true ).

fof(t103_partfun1,axiom,
    $true ).

fof(t104_partfun1,axiom,
    $true ).

fof(t105_partfun1,axiom,
    $true ).

fof(t106_partfun1,axiom,
    $true ).

fof(t107_partfun1,axiom,
    $true ).

fof(t108_partfun1,axiom,
    $true ).

fof(t109_partfun1,axiom,
    $true ).

fof(t110_partfun1,axiom,
    $true ).

fof(t111_partfun1,axiom,
    $true ).

fof(t112_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => v1_partfun1(B,k1_xboole_0,A) ) ).

fof(t113_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_partfun1(k3_partfun1(C,A,B),A,B)
       => r1_tarski(A,k1_relat_1(C)) ) ) ).

fof(t114_partfun1,axiom,
    ! [A,B] :
      ( v1_partfun1(k3_partfun1(k1_xboole_0,A,B),A,B)
     => A = k1_xboole_0 ) ).

fof(t115_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(A,k1_relat_1(C))
          & r1_tarski(k2_relat_1(C),B) )
       => v1_partfun1(k3_partfun1(C,A,B),A,B) ) ) ).

fof(t116_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_partfun1(k3_partfun1(C,A,B),A,B)
       => r1_tarski(k9_relat_1(C,A),B) ) ) ).

fof(t117_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(A,k1_relat_1(C))
          & r1_tarski(k9_relat_1(C,A),B) )
       => v1_partfun1(k3_partfun1(C,A,B),A,B) ) ) ).

fof(d5_partfun1,axiom,
    ! [A,B,C] :
      ( C = k4_partfun1(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E] :
              ( v1_relat_1(E)
              & v1_funct_1(E)
              & D = E
              & r1_tarski(k1_relat_1(E),A)
              & r1_tarski(k2_relat_1(E),B) ) ) ) ).

fof(t118_partfun1,axiom,
    $true ).

fof(t119_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => r2_hidden(C,k4_partfun1(A,B)) ) ).

fof(t120_partfun1,axiom,
    ! [A,B,C] :
      ( r2_hidden(C,k4_partfun1(A,B))
     => ( v1_funct_1(C)
        & m2_relset_1(C,A,B) ) ) ).

fof(t121_partfun1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k4_partfun1(A,B))
     => ( v1_funct_1(C)
        & m2_relset_1(C,A,B) ) ) ).

fof(t122_partfun1,axiom,
    ! [A] : k4_partfun1(k1_xboole_0,A) = k1_tarski(k1_xboole_0) ).

fof(t123_partfun1,axiom,
    ! [A] : k4_partfun1(A,k1_xboole_0) = k1_tarski(k1_xboole_0) ).

fof(t124_partfun1,axiom,
    $true ).

fof(t125_partfun1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_partfun1(A,C),k4_partfun1(B,C)) ) ).

fof(t126_partfun1,axiom,
    ! [A,B] : r1_tarski(k4_partfun1(k1_xboole_0,A),k4_partfun1(B,A)) ).

fof(t127_partfun1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_partfun1(C,A),k4_partfun1(C,B)) ) ).

fof(t128_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k4_partfun1(A,C),k4_partfun1(B,D)) ) ).

fof(d6_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> ! [C] :
                ( r2_hidden(C,k3_xboole_0(k1_relat_1(A),k1_relat_1(B)))
               => k1_funct_1(A,C) = k1_funct_1(B,C) ) ) ) ) ).

fof(t129_partfun1,axiom,
    $true ).

fof(t130_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & k2_xboole_0(A,B) = C ) ) ) ) ).

fof(t131_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & r1_tarski(A,C)
                & r1_tarski(B,C) ) ) ) ) ).

fof(t132_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(k1_relat_1(A),k1_relat_1(B))
           => ( r1_partfun1(A,B)
            <=> ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => k1_funct_1(A,C) = k1_funct_1(B,C) ) ) ) ) ) ).

fof(t133_partfun1,axiom,
    $true ).

fof(t134_partfun1,axiom,
    $true ).

fof(t135_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(A,B)
           => r1_partfun1(A,B) ) ) ) ).

fof(t136_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k1_relat_1(A) = k1_relat_1(B)
              & r1_partfun1(A,B) )
           => A = B ) ) ) ).

fof(t137_partfun1,axiom,
    $true ).

fof(t138_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => r1_partfun1(A,B) ) ) ) ).

fof(t139_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( r1_tarski(A,C)
                  & r1_tarski(B,C) )
               => r1_partfun1(A,B) ) ) ) ) ).

fof(t140_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ! [E] :
              ( ( v1_relat_1(E)
                & v1_funct_1(E) )
             => ( ( r1_partfun1(C,E)
                  & r1_tarski(D,C) )
               => r1_partfun1(D,E) ) ) ) ) ).

fof(t141_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_partfun1(k1_xboole_0,A) ) ).

fof(t142_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_partfun1(k3_partfun1(k1_xboole_0,A,B),C) ) ).

fof(t143_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,k1_tarski(B)) )
         => r1_partfun1(C,D) ) ) ).

fof(t144_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_partfun1(k7_relat_1(B,A),B) ) ).

fof(t145_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_partfun1(k8_relat_1(A,B),B) ) ).

fof(t146_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_partfun1(k7_relat_1(k8_relat_1(A,C),B),C) ) ).

fof(t147_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_partfun1(k3_partfun1(C,A,B),C) ) ).

fof(t148_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( v1_partfun1(C,A,B)
              & v1_partfun1(D,A,B)
              & r1_partfun1(C,D) )
           => C = D ) ) ) ).

fof(t149_partfun1,axiom,
    $true ).

fof(t150_partfun1,axiom,
    $true ).

fof(t151_partfun1,axiom,
    $true ).

fof(t152_partfun1,axiom,
    $true ).

fof(t153_partfun1,axiom,
    $true ).

fof(t154_partfun1,axiom,
    $true ).

fof(t155_partfun1,axiom,
    $true ).

fof(t156_partfun1,axiom,
    $true ).

fof(t157_partfun1,axiom,
    $true ).

fof(t158_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ! [E] :
              ( ( v1_funct_1(E)
                & m2_relset_1(E,A,B) )
             => ( ( r1_partfun1(C,E)
                  & r1_partfun1(D,E)
                  & v1_partfun1(E,A,B) )
               => r1_partfun1(C,D) ) ) ) ) ).

fof(t159_partfun1,axiom,
    $true ).

fof(t160_partfun1,axiom,
    $true ).

fof(t161_partfun1,axiom,
    $true ).

fof(t162_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & r1_partfun1(C,D)
              & ! [E] :
                  ( ( v1_funct_1(E)
                    & m2_relset_1(E,A,B) )
                 => ~ ( v1_partfun1(E,A,B)
                      & r1_partfun1(C,E)
                      & r1_partfun1(D,E) ) ) ) ) ) ).

fof(d7_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( D = k5_partfun1(A,B,C)
        <=> ! [E] :
              ( r2_hidden(E,D)
            <=> ? [F] :
                  ( v1_funct_1(F)
                  & m2_relset_1(F,A,B)
                  & F = E
                  & v1_partfun1(F,A,B)
                  & r1_partfun1(C,F) ) ) ) ) ).

fof(t163_partfun1,axiom,
    $true ).

fof(t164_partfun1,axiom,
    $true ).

fof(t165_partfun1,axiom,
    $true ).

fof(t166_partfun1,axiom,
    $true ).

fof(t167_partfun1,axiom,
    $true ).

fof(t168_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( r2_hidden(D,k5_partfun1(A,B,C))
         => ( v1_funct_1(D)
            & m2_relset_1(D,A,B) ) ) ) ).

fof(t169_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( r2_hidden(D,k5_partfun1(A,B,C))
           => v1_partfun1(D,A,B) ) ) ) ).

fof(t170_partfun1,axiom,
    $true ).

fof(t171_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r2_hidden(D,k5_partfun1(A,B,C))
           => r1_partfun1(C,D) ) ) ) ).

fof(t172_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => ( A != k1_xboole_0
       => k5_partfun1(A,k1_xboole_0,B) = k1_xboole_0 ) ) ).

fof(t173_partfun1,axiom,
    $true ).

fof(t174_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( v1_partfun1(C,A,B)
      <=> k5_partfun1(A,B,C) = k1_tarski(C) ) ) ).

fof(t175_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => k5_partfun1(k1_xboole_0,A,B) = k1_tarski(B) ) ).

fof(t176_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => k5_partfun1(k1_xboole_0,A,B) = k1_tarski(k1_xboole_0) ) ).

fof(t177_partfun1,axiom,
    $true ).

fof(t178_partfun1,axiom,
    $true ).

fof(t179_partfun1,axiom,
    $true ).

fof(t180_partfun1,axiom,
    $true ).

fof(t181_partfun1,axiom,
    $true ).

fof(t182_partfun1,axiom,
    $true ).

fof(t183_partfun1,axiom,
    $true ).

fof(t184_partfun1,axiom,
    $true ).

fof(t185_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ~ r1_xboole_0(k5_partfun1(A,B,C),k5_partfun1(A,B,D))
           => r1_partfun1(C,D) ) ) ) ).

fof(t186_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & r1_partfun1(C,D)
              & r1_xboole_0(k5_partfun1(A,B,C),k5_partfun1(A,B,D)) ) ) ) ).

fof(s1_partfun1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s1_partfun1
      & ! [B] :
          ( r2_hidden(B,f1_s1_partfun1)
         => ( ( p1_s1_partfun1(B)
             => k1_funct_1(A,B) = f2_s1_partfun1(B) )
            & ( ~ p1_s1_partfun1(B)
             => k1_funct_1(A,B) = f3_s1_partfun1(B) ) ) ) ) ).

fof(s2_partfun1,axiom,
    ( ( ! [A,B] :
          ( ( r2_hidden(A,f1_s2_partfun1)
            & p1_s2_partfun1(A,B) )
         => r2_hidden(B,f2_s2_partfun1) )
      & ! [A,B,C] :
          ( ( r2_hidden(A,f1_s2_partfun1)
            & p1_s2_partfun1(A,B)
            & p1_s2_partfun1(A,C) )
         => B = C ) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,f1_s2_partfun1,f2_s2_partfun1)
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s2_partfun1,f2_s2_partfun1,A))
          <=> ( r2_hidden(B,f1_s2_partfun1)
              & ? [C] : p1_s2_partfun1(B,C) ) )
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s2_partfun1,f2_s2_partfun1,A))
           => p1_s2_partfun1(B,k1_funct_1(A,B)) ) ) ) ).

fof(s3_partfun1,axiom,
    ( ! [A] :
        ( p1_s3_partfun1(A)
       => r2_hidden(f3_s3_partfun1(A),f2_s3_partfun1) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,f1_s3_partfun1,f2_s3_partfun1)
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s3_partfun1,f2_s3_partfun1,A))
          <=> ( r2_hidden(B,f1_s3_partfun1)
              & p1_s3_partfun1(B) ) )
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s3_partfun1,f2_s3_partfun1,A))
           => k1_funct_1(A,B) = f3_s3_partfun1(B) ) ) ) ).

fof(s4_partfun1,axiom,
    ( ( ! [A,B,C] :
          ( ( r2_hidden(A,f1_s4_partfun1)
            & r2_hidden(B,f2_s4_partfun1)
            & p1_s4_partfun1(A,B,C) )
         => r2_hidden(C,f3_s4_partfun1) )
      & ! [A,B,C,D] :
          ( ( r2_hidden(A,f1_s4_partfun1)
            & r2_hidden(B,f2_s4_partfun1)
            & p1_s4_partfun1(A,B,C)
            & p1_s4_partfun1(A,B,D) )
         => C = D ) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,k2_zfmisc_1(f1_s4_partfun1,f2_s4_partfun1),f3_s4_partfun1)
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s4_partfun1,f2_s4_partfun1),f3_s4_partfun1,A))
          <=> ( r2_hidden(B,f1_s4_partfun1)
              & r2_hidden(C,f2_s4_partfun1)
              & ? [D] : p1_s4_partfun1(B,C,D) ) )
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s4_partfun1,f2_s4_partfun1),f3_s4_partfun1,A))
           => p1_s4_partfun1(B,C,k1_funct_1(A,k4_tarski(B,C))) ) ) ) ).

fof(s5_partfun1,axiom,
    ( ! [A,B] :
        ( p1_s5_partfun1(A,B)
       => r2_hidden(f4_s5_partfun1(A,B),f3_s5_partfun1) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,k2_zfmisc_1(f1_s5_partfun1,f2_s5_partfun1),f3_s5_partfun1)
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s5_partfun1,f2_s5_partfun1),f3_s5_partfun1,A))
          <=> ( r2_hidden(B,f1_s5_partfun1)
              & r2_hidden(C,f2_s5_partfun1)
              & p1_s5_partfun1(B,C) ) )
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s5_partfun1,f2_s5_partfun1),f3_s5_partfun1,A))
           => k1_funct_1(A,k4_tarski(B,C)) = f4_s5_partfun1(B,C) ) ) ) ).

fof(symmetry_r1_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_partfun1(A,B)
       => r1_partfun1(B,A) ) ) ).

fof(reflexivity_r1_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_partfun1(A,A) ) ).

fof(dt_k1_partfun1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(E)
        & m1_relset_1(E,A,B)
        & v1_funct_1(F)
        & m1_relset_1(F,C,D) )
     => ( v1_funct_1(k1_partfun1(A,B,C,D,E,F))
        & m2_relset_1(k1_partfun1(A,B,C,D,E,F),A,D) ) ) ).

fof(redefinition_k1_partfun1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(E)
        & m1_relset_1(E,A,B)
        & v1_funct_1(F)
        & m1_relset_1(F,C,D) )
     => k1_partfun1(A,B,C,D,E,F) = k5_relat_1(E,F) ) ).

fof(dt_k2_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => ( v1_funct_1(k2_partfun1(A,B,C,D))
        & m2_relset_1(k2_partfun1(A,B,C,D),A,B) ) ) ).

fof(redefinition_k2_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => k2_partfun1(A,B,C,D) = k7_relat_1(C,D) ) ).

fof(dt_k3_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(k3_partfun1(A,B,C))
        & m2_relset_1(k3_partfun1(A,B,C),B,C) ) ) ).

fof(dt_k4_partfun1,axiom,
    $true ).

fof(dt_k5_partfun1,axiom,
    $true ).

fof(dt_k6_partfun1,axiom,
    ! [A] :
      ( v1_partfun1(k6_partfun1(A),A,A)
      & m2_relset_1(k6_partfun1(A),A,A) ) ).

fof(redefinition_k6_partfun1,axiom,
    ! [A] : k6_partfun1(A) = k6_relat_1(A) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & r1_xboole_0(B,A) ) ) ).

fof(t2_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ( r2_hidden(C,B)
                 => r1_xboole_0(C,A) ) ) ) ).

fof(t3_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D] :
                  ( ( r2_hidden(C,D)
                    & r2_hidden(D,B) )
                 => r1_xboole_0(C,A) ) ) ) ).

fof(t4_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D,E] :
                  ( ( r2_hidden(C,D)
                    & r2_hidden(D,E)
                    & r2_hidden(E,B) )
                 => r1_xboole_0(C,A) ) ) ) ).

fof(t5_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D,E,F] :
                  ( ( r2_hidden(C,D)
                    & r2_hidden(D,E)
                    & r2_hidden(E,F)
                    & r2_hidden(F,B) )
                 => r1_xboole_0(C,A) ) ) ) ).

fof(t6_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D,E,F,G] :
                  ( ( r2_hidden(C,D)
                    & r2_hidden(D,E)
                    & r2_hidden(E,F)
                    & r2_hidden(F,G)
                    & r2_hidden(G,B) )
                 => r1_xboole_0(C,A) ) ) ) ).

fof(d1_mcart_1,axiom,
    ! [A] :
      ( ? [B,C] : A = k4_tarski(B,C)
     => ! [B] :
          ( B = k1_mcart_1(A)
        <=> ! [C,D] :
              ( A = k4_tarski(C,D)
             => B = C ) ) ) ).

fof(d2_mcart_1,axiom,
    ! [A] :
      ( ? [B,C] : A = k4_tarski(B,C)
     => ! [B] :
          ( B = k2_mcart_1(A)
        <=> ! [C,D] :
              ( A = k4_tarski(C,D)
             => B = D ) ) ) ).

fof(t7_mcart_1,axiom,
    ! [A,B] :
      ( k1_mcart_1(k4_tarski(A,B)) = A
      & k2_mcart_1(k4_tarski(A,B)) = B ) ).

fof(t8_mcart_1,axiom,
    ! [A] :
      ( ? [B,C] : A = k4_tarski(B,C)
     => k4_tarski(k1_mcart_1(A),k2_mcart_1(A)) = A ) ).

fof(t9_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D] :
                  ~ ( ( r2_hidden(C,A)
                      | r2_hidden(D,A) )
                    & B = k4_tarski(C,D) ) ) ) ).

fof(t10_mcart_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k2_zfmisc_1(B,C))
     => ( r2_hidden(k1_mcart_1(A),B)
        & r2_hidden(k2_mcart_1(A),C) ) ) ).

fof(t11_mcart_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(k1_mcart_1(A),B)
        & r2_hidden(k2_mcart_1(A),C) )
     => ( ! [D,E] : A != k4_tarski(D,E)
        | r2_hidden(A,k2_zfmisc_1(B,C)) ) ) ).

fof(t12_mcart_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k2_zfmisc_1(k1_tarski(B),C))
     => ( k1_mcart_1(A) = B
        & r2_hidden(k2_mcart_1(A),C) ) ) ).

fof(t13_mcart_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k2_zfmisc_1(B,k1_tarski(C)))
     => ( r2_hidden(k1_mcart_1(A),B)
        & k2_mcart_1(A) = C ) ) ).

fof(t14_mcart_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k2_zfmisc_1(k1_tarski(B),k1_tarski(C)))
     => ( k1_mcart_1(A) = B
        & k2_mcart_1(A) = C ) ) ).

fof(t15_mcart_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(A,k2_zfmisc_1(k2_tarski(B,C),D))
     => ( ( k1_mcart_1(A) = B
          | k1_mcart_1(A) = C )
        & r2_hidden(k2_mcart_1(A),D) ) ) ).

fof(t16_mcart_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(A,k2_zfmisc_1(B,k2_tarski(C,D)))
     => ( r2_hidden(k1_mcart_1(A),B)
        & ( k2_mcart_1(A) = C
          | k2_mcart_1(A) = D ) ) ) ).

fof(t17_mcart_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(A,k2_zfmisc_1(k2_tarski(B,C),k1_tarski(D)))
     => ( ( k1_mcart_1(A) = B
          | k1_mcart_1(A) = C )
        & k2_mcart_1(A) = D ) ) ).

fof(t18_mcart_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(A,k2_zfmisc_1(k1_tarski(B),k2_tarski(C,D)))
     => ( k1_mcart_1(A) = B
        & ( k2_mcart_1(A) = C
          | k2_mcart_1(A) = D ) ) ) ).

fof(t19_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( r2_hidden(A,k2_zfmisc_1(k2_tarski(B,C),k2_tarski(D,E)))
     => ( ( k1_mcart_1(A) = B
          | k1_mcart_1(A) = C )
        & ( k2_mcart_1(A) = D
          | k2_mcart_1(A) = E ) ) ) ).

fof(t20_mcart_1,axiom,
    ! [A] :
      ( ? [B,C] : A = k4_tarski(B,C)
     => ( A != k1_mcart_1(A)
        & A != k2_mcart_1(A) ) ) ).

fof(t21_mcart_1,axiom,
    $true ).

fof(t22_mcart_1,axiom,
    $true ).

fof(t23_mcart_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k2_zfmisc_1(B,C))
     => A = k4_tarski(k1_mcart_1(A),k2_mcart_1(A)) ) ).

fof(t24_mcart_1,axiom,
    ! [A,B] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & ~ ! [C] :
              ( m1_subset_1(C,k2_zfmisc_1(A,B))
             => C = k4_tarski(k1_mcart_1(C),k2_mcart_1(C)) ) ) ).

fof(t25_mcart_1,axiom,
    ! [A,B,C,D] : k2_zfmisc_1(k2_tarski(A,B),k2_tarski(C,D)) = k2_enumset1(k4_tarski(A,C),k4_tarski(A,D),k4_tarski(B,C),k4_tarski(B,D)) ).

fof(t26_mcart_1,axiom,
    ! [A,B] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & ~ ! [C] :
              ( m1_subset_1(C,k2_zfmisc_1(A,B))
             => ( C != k1_mcart_1(C)
                & C != k2_mcart_1(C) ) ) ) ).

fof(d3_mcart_1,axiom,
    ! [A,B,C] : k3_mcart_1(A,B,C) = k4_tarski(k4_tarski(A,B),C) ).

fof(t27_mcart_1,axiom,
    $true ).

fof(t28_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( k3_mcart_1(A,B,C) = k3_mcart_1(D,E,F)
     => ( A = D
        & B = E
        & C = F ) ) ).

fof(t29_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D,E] :
                  ~ ( ( r2_hidden(C,A)
                      | r2_hidden(D,A) )
                    & B = k3_mcart_1(C,D,E) ) ) ) ).

fof(d4_mcart_1,axiom,
    ! [A,B,C,D] : k4_mcart_1(A,B,C,D) = k4_tarski(k3_mcart_1(A,B,C),D) ).

fof(t30_mcart_1,axiom,
    $true ).

fof(t31_mcart_1,axiom,
    ! [A,B,C,D] : k4_mcart_1(A,B,C,D) = k4_tarski(k4_tarski(k4_tarski(A,B),C),D) ).

fof(t32_mcart_1,axiom,
    ! [A,B,C,D] : k4_mcart_1(A,B,C,D) = k3_mcart_1(k4_tarski(A,B),C,D) ).

fof(t33_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( k4_mcart_1(A,B,C,D) = k4_mcart_1(E,F,G,H)
     => ( A = E
        & B = F
        & C = G
        & D = H ) ) ).

fof(t34_mcart_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D,E,F] :
                  ~ ( ( r2_hidden(C,A)
                      | r2_hidden(D,A) )
                    & B = k4_mcart_1(C,D,E,F) ) ) ) ).

fof(t35_mcart_1,axiom,
    ! [A,B,C] :
      ( ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0 )
    <=> k3_zfmisc_1(A,B,C) != k1_xboole_0 ) ).

fof(t36_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( k3_zfmisc_1(A,B,C) = k3_zfmisc_1(D,E,F)
     => ( A = k1_xboole_0
        | B = k1_xboole_0
        | C = k1_xboole_0
        | ( A = D
          & B = E
          & C = F ) ) ) ).

fof(t37_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( k3_zfmisc_1(A,B,C) = k3_zfmisc_1(D,E,F)
     => ( k3_zfmisc_1(A,B,C) = k1_xboole_0
        | ( A = D
          & B = E
          & C = F ) ) ) ).

fof(t38_mcart_1,axiom,
    ! [A,B] :
      ( k3_zfmisc_1(A,A,A) = k3_zfmisc_1(B,B,B)
     => A = B ) ).

fof(t39_mcart_1,axiom,
    ! [A,B,C] : k3_zfmisc_1(k1_tarski(A),k1_tarski(B),k1_tarski(C)) = k1_tarski(k3_mcart_1(A,B,C)) ).

fof(t40_mcart_1,axiom,
    ! [A,B,C,D] : k3_zfmisc_1(k2_tarski(A,B),k1_tarski(C),k1_tarski(D)) = k2_tarski(k3_mcart_1(A,C,D),k3_mcart_1(B,C,D)) ).

fof(t41_mcart_1,axiom,
    ! [A,B,C,D] : k3_zfmisc_1(k1_tarski(A),k2_tarski(B,C),k1_tarski(D)) = k2_tarski(k3_mcart_1(A,B,D),k3_mcart_1(A,C,D)) ).

fof(t42_mcart_1,axiom,
    ! [A,B,C,D] : k3_zfmisc_1(k1_tarski(A),k1_tarski(B),k2_tarski(C,D)) = k2_tarski(k3_mcart_1(A,B,C),k3_mcart_1(A,B,D)) ).

fof(t43_mcart_1,axiom,
    ! [A,B,C,D,E] : k3_zfmisc_1(k2_tarski(A,B),k2_tarski(C,D),k1_tarski(E)) = k2_enumset1(k3_mcart_1(A,C,E),k3_mcart_1(B,C,E),k3_mcart_1(A,D,E),k3_mcart_1(B,D,E)) ).

fof(t44_mcart_1,axiom,
    ! [A,B,C,D,E] : k3_zfmisc_1(k2_tarski(A,B),k1_tarski(C),k2_tarski(D,E)) = k2_enumset1(k3_mcart_1(A,C,D),k3_mcart_1(B,C,D),k3_mcart_1(A,C,E),k3_mcart_1(B,C,E)) ).

fof(t45_mcart_1,axiom,
    ! [A,B,C,D,E] : k3_zfmisc_1(k1_tarski(A),k2_tarski(B,C),k2_tarski(D,E)) = k2_enumset1(k3_mcart_1(A,B,D),k3_mcart_1(A,C,D),k3_mcart_1(A,B,E),k3_mcart_1(A,C,E)) ).

fof(t46_mcart_1,axiom,
    ! [A,B,C,D,E,F] : k3_zfmisc_1(k2_tarski(A,B),k2_tarski(C,D),k2_tarski(E,F)) = k6_enumset1(k3_mcart_1(A,C,E),k3_mcart_1(A,D,E),k3_mcart_1(A,C,F),k3_mcart_1(A,D,F),k3_mcart_1(B,C,E),k3_mcart_1(B,D,E),k3_mcart_1(B,C,F),k3_mcart_1(B,D,F)) ).

fof(d5_mcart_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & ~ ! [D] :
              ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ( E = k5_mcart_1(A,B,C,D)
                  <=> ! [F,G,H] :
                        ( D = k3_mcart_1(F,G,H)
                       => E = F ) ) ) ) ) ).

fof(d6_mcart_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & ~ ! [D] :
              ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
             => ! [E] :
                  ( m1_subset_1(E,B)
                 => ( E = k6_mcart_1(A,B,C,D)
                  <=> ! [F,G,H] :
                        ( D = k3_mcart_1(F,G,H)
                       => E = G ) ) ) ) ) ).

fof(d7_mcart_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & ~ ! [D] :
              ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
             => ! [E] :
                  ( m1_subset_1(E,C)
                 => ( E = k7_mcart_1(A,B,C,D)
                  <=> ! [F,G,H] :
                        ( D = k3_mcart_1(F,G,H)
                       => E = H ) ) ) ) ) ).

fof(t47_mcart_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & ? [D] :
            ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
            & ? [E,F,G] :
                ( D = k3_mcart_1(E,F,G)
                & ~ ( k5_mcart_1(A,B,C,D) = E
                    & k6_mcart_1(A,B,C,D) = F
                    & k7_mcart_1(A,B,C,D) = G ) ) ) ) ).

fof(t48_mcart_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & ~ ! [D] :
              ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
             => D = k3_mcart_1(k5_mcart_1(A,B,C,D),k6_mcart_1(A,B,C,D),k7_mcart_1(A,B,C,D)) ) ) ).

fof(t49_mcart_1,axiom,
    ! [A,B,C] :
      ( ~ ( ~ r1_tarski(A,k3_zfmisc_1(A,B,C))
          & ~ r1_tarski(A,k3_zfmisc_1(B,C,A))
          & ~ r1_tarski(A,k3_zfmisc_1(C,A,B)) )
     => A = k1_xboole_0 ) ).

fof(t50_mcart_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & ~ ! [D] :
              ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
             => ( k5_mcart_1(A,B,C,D) = k1_mcart_1(k1_mcart_1(D))
                & k6_mcart_1(A,B,C,D) = k2_mcart_1(k1_mcart_1(D))
                & k7_mcart_1(A,B,C,D) = k2_mcart_1(D) ) ) ) ).

fof(t51_mcart_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & ~ ! [D] :
              ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
             => ( D != k5_mcart_1(A,B,C,D)
                & D != k6_mcart_1(A,B,C,D)
                & D != k7_mcart_1(A,B,C,D) ) ) ) ).

fof(t52_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ~ r1_xboole_0(k3_zfmisc_1(A,B,C),k3_zfmisc_1(D,E,F))
     => ( ~ r1_xboole_0(A,D)
        & ~ r1_xboole_0(B,E)
        & ~ r1_xboole_0(C,F) ) ) ).

fof(t53_mcart_1,axiom,
    ! [A,B,C,D] : k4_zfmisc_1(A,B,C,D) = k2_zfmisc_1(k2_zfmisc_1(k2_zfmisc_1(A,B),C),D) ).

fof(t54_mcart_1,axiom,
    ! [A,B,C,D] : k3_zfmisc_1(k2_zfmisc_1(A,B),C,D) = k4_zfmisc_1(A,B,C,D) ).

fof(t55_mcart_1,axiom,
    ! [A,B,C,D] :
      ( ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0 )
    <=> k4_zfmisc_1(A,B,C,D) != k1_xboole_0 ) ).

fof(t56_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( k4_zfmisc_1(A,B,C,D) = k4_zfmisc_1(E,F,G,H)
     => ( A = k1_xboole_0
        | B = k1_xboole_0
        | C = k1_xboole_0
        | D = k1_xboole_0
        | ( A = E
          & B = F
          & C = G
          & D = H ) ) ) ).

fof(t57_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( k4_zfmisc_1(A,B,C,D) = k4_zfmisc_1(E,F,G,H)
     => ( k4_zfmisc_1(A,B,C,D) = k1_xboole_0
        | ( A = E
          & B = F
          & C = G
          & D = H ) ) ) ).

fof(t58_mcart_1,axiom,
    ! [A,B] :
      ( k4_zfmisc_1(A,A,A,A) = k4_zfmisc_1(B,B,B,B)
     => A = B ) ).

fof(d8_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ~ ! [E] :
              ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
             => ! [F] :
                  ( m1_subset_1(F,A)
                 => ( F = k8_mcart_1(A,B,C,D,E)
                  <=> ! [G,H,I,J] :
                        ( E = k4_mcart_1(G,H,I,J)
                       => F = G ) ) ) ) ) ).

fof(d9_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ~ ! [E] :
              ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
             => ! [F] :
                  ( m1_subset_1(F,B)
                 => ( F = k9_mcart_1(A,B,C,D,E)
                  <=> ! [G,H,I,J] :
                        ( E = k4_mcart_1(G,H,I,J)
                       => F = H ) ) ) ) ) ).

fof(d10_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ~ ! [E] :
              ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
             => ! [F] :
                  ( m1_subset_1(F,C)
                 => ( F = k10_mcart_1(A,B,C,D,E)
                  <=> ! [G,H,I,J] :
                        ( E = k4_mcart_1(G,H,I,J)
                       => F = I ) ) ) ) ) ).

fof(d11_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ~ ! [E] :
              ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
             => ! [F] :
                  ( m1_subset_1(F,D)
                 => ( F = k11_mcart_1(A,B,C,D,E)
                  <=> ! [G,H,I,J] :
                        ( E = k4_mcart_1(G,H,I,J)
                       => F = J ) ) ) ) ) ).

fof(t59_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ? [E] :
            ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
            & ? [F,G,H,I] :
                ( E = k4_mcart_1(F,G,H,I)
                & ~ ( k8_mcart_1(A,B,C,D,E) = F
                    & k9_mcart_1(A,B,C,D,E) = G
                    & k10_mcart_1(A,B,C,D,E) = H
                    & k11_mcart_1(A,B,C,D,E) = I ) ) ) ) ).

fof(t60_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ~ ! [E] :
              ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
             => E = k4_mcart_1(k8_mcart_1(A,B,C,D,E),k9_mcart_1(A,B,C,D,E),k10_mcart_1(A,B,C,D,E),k11_mcart_1(A,B,C,D,E)) ) ) ).

fof(t61_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ~ ! [E] :
              ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
             => ( k8_mcart_1(A,B,C,D,E) = k1_mcart_1(k1_mcart_1(k1_mcart_1(E)))
                & k9_mcart_1(A,B,C,D,E) = k2_mcart_1(k1_mcart_1(k1_mcart_1(E)))
                & k10_mcart_1(A,B,C,D,E) = k2_mcart_1(k1_mcart_1(E))
                & k11_mcart_1(A,B,C,D,E) = k2_mcart_1(E) ) ) ) ).

fof(t62_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & ~ ! [E] :
              ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
             => ( E != k8_mcart_1(A,B,C,D,E)
                & E != k9_mcart_1(A,B,C,D,E)
                & E != k10_mcart_1(A,B,C,D,E)
                & E != k11_mcart_1(A,B,C,D,E) ) ) ) ).

fof(t63_mcart_1,axiom,
    ! [A,B,C,D] :
      ( ~ ( ~ r1_tarski(A,k4_zfmisc_1(A,B,C,D))
          & ~ r1_tarski(A,k4_zfmisc_1(B,C,D,A))
          & ~ r1_tarski(A,k4_zfmisc_1(C,D,A,B))
          & ~ r1_tarski(A,k4_zfmisc_1(D,A,B,C)) )
     => A = k1_xboole_0 ) ).

fof(t64_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ~ r1_xboole_0(k4_zfmisc_1(A,B,C,D),k4_zfmisc_1(E,F,G,H))
     => ( ~ r1_xboole_0(A,E)
        & ~ r1_xboole_0(B,F)
        & ~ r1_xboole_0(C,G)
        & ~ r1_xboole_0(D,H) ) ) ).

fof(t65_mcart_1,axiom,
    ! [A,B,C,D] : k4_zfmisc_1(k1_tarski(A),k1_tarski(B),k1_tarski(C),k1_tarski(D)) = k1_tarski(k4_mcart_1(A,B,C,D)) ).

fof(t66_mcart_1,axiom,
    ! [A,B] :
      ( k2_zfmisc_1(A,B) != k1_xboole_0
     => ! [C] :
          ( m1_subset_1(C,k2_zfmisc_1(A,B))
         => ( C != k1_mcart_1(C)
            & C != k2_mcart_1(C) ) ) ) ).

fof(t67_mcart_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k2_zfmisc_1(B,C))
     => ( A != k1_mcart_1(A)
        & A != k2_mcart_1(A) ) ) ).

fof(t68_mcart_1,axiom,
    ! [A,B,C,D] :
      ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
     => ~ ( A != k1_xboole_0
          & B != k1_xboole_0
          & C != k1_xboole_0
          & ? [E,F,G] :
              ( D = k3_mcart_1(E,F,G)
              & ~ ( k5_mcart_1(A,B,C,D) = E
                  & k6_mcart_1(A,B,C,D) = F
                  & k7_mcart_1(A,B,C,D) = G ) ) ) ) ).

fof(t69_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k3_zfmisc_1(A,B,C))
     => ( ! [F] :
            ( m1_subset_1(F,A)
           => ! [G] :
                ( m1_subset_1(G,B)
               => ! [H] :
                    ( m1_subset_1(H,C)
                   => ( E = k3_mcart_1(F,G,H)
                     => D = F ) ) ) )
       => ( A = k1_xboole_0
          | B = k1_xboole_0
          | C = k1_xboole_0
          | D = k5_mcart_1(A,B,C,E) ) ) ) ).

fof(t70_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k3_zfmisc_1(A,B,C))
     => ( ! [F] :
            ( m1_subset_1(F,A)
           => ! [G] :
                ( m1_subset_1(G,B)
               => ! [H] :
                    ( m1_subset_1(H,C)
                   => ( E = k3_mcart_1(F,G,H)
                     => D = G ) ) ) )
       => ( A = k1_xboole_0
          | B = k1_xboole_0
          | C = k1_xboole_0
          | D = k6_mcart_1(A,B,C,E) ) ) ) ).

fof(t71_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k3_zfmisc_1(A,B,C))
     => ( ! [F] :
            ( m1_subset_1(F,A)
           => ! [G] :
                ( m1_subset_1(G,B)
               => ! [H] :
                    ( m1_subset_1(H,C)
                   => ( E = k3_mcart_1(F,G,H)
                     => D = H ) ) ) )
       => ( A = k1_xboole_0
          | B = k1_xboole_0
          | C = k1_xboole_0
          | D = k7_mcart_1(A,B,C,E) ) ) ) ).

fof(t72_mcart_1,axiom,
    ! [A,B,C,D] :
      ~ ( r2_hidden(A,k3_zfmisc_1(B,C,D))
        & ! [E,F,G] :
            ~ ( r2_hidden(E,B)
              & r2_hidden(F,C)
              & r2_hidden(G,D)
              & A = k3_mcart_1(E,F,G) ) ) ).

fof(t73_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( r2_hidden(k3_mcart_1(A,B,C),k3_zfmisc_1(D,E,F))
    <=> ( r2_hidden(A,D)
        & r2_hidden(B,E)
        & r2_hidden(C,F) ) ) ).

fof(t74_mcart_1,axiom,
    ! [A,B,C,D] :
      ( ! [E] :
          ( r2_hidden(E,A)
        <=> ? [F,G,H] :
              ( r2_hidden(F,B)
              & r2_hidden(G,C)
              & r2_hidden(H,D)
              & E = k3_mcart_1(F,G,H) ) )
     => A = k3_zfmisc_1(B,C,D) ) ).

fof(t75_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & E != k1_xboole_0
        & F != k1_xboole_0
        & ? [G] :
            ( m1_subset_1(G,k3_zfmisc_1(A,B,C))
            & ? [H] :
                ( m1_subset_1(H,k3_zfmisc_1(D,E,F))
                & G = H
                & ~ ( k5_mcart_1(A,B,C,G) = k5_mcart_1(D,E,F,H)
                    & k6_mcart_1(A,B,C,G) = k6_mcart_1(D,E,F,H)
                    & k7_mcart_1(A,B,C,G) = k7_mcart_1(D,E,F,H) ) ) ) ) ).

fof(t76_mcart_1,axiom,
    ! [A,B,C,D] :
      ( m1_subset_1(D,k1_zfmisc_1(A))
     => ! [E] :
          ( m1_subset_1(E,k1_zfmisc_1(B))
         => ! [F] :
              ( m1_subset_1(F,k1_zfmisc_1(C))
             => ! [G] :
                  ( m1_subset_1(G,k3_zfmisc_1(A,B,C))
                 => ( r2_hidden(G,k3_zfmisc_1(D,E,F))
                   => ( r2_hidden(k5_mcart_1(A,B,C,G),D)
                      & r2_hidden(k6_mcart_1(A,B,C,G),E)
                      & r2_hidden(k7_mcart_1(A,B,C,G),F) ) ) ) ) ) ) ).

fof(t77_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D)
        & r1_tarski(E,F) )
     => r1_tarski(k3_zfmisc_1(A,C,E),k3_zfmisc_1(B,D,F)) ) ).

fof(t78_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
     => ~ ( A != k1_xboole_0
          & B != k1_xboole_0
          & C != k1_xboole_0
          & D != k1_xboole_0
          & ? [F,G,H,I] :
              ( E = k4_mcart_1(F,G,H,I)
              & ~ ( k8_mcart_1(A,B,C,D,E) = F
                  & k9_mcart_1(A,B,C,D,E) = G
                  & k10_mcart_1(A,B,C,D,E) = H
                  & k11_mcart_1(A,B,C,D,E) = I ) ) ) ) ).

fof(t79_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( m1_subset_1(F,k4_zfmisc_1(A,B,C,D))
     => ( ! [G] :
            ( m1_subset_1(G,A)
           => ! [H] :
                ( m1_subset_1(H,B)
               => ! [I] :
                    ( m1_subset_1(I,C)
                   => ! [J] :
                        ( m1_subset_1(J,D)
                       => ( F = k4_mcart_1(G,H,I,J)
                         => E = G ) ) ) ) )
       => ( A = k1_xboole_0
          | B = k1_xboole_0
          | C = k1_xboole_0
          | D = k1_xboole_0
          | E = k8_mcart_1(A,B,C,D,F) ) ) ) ).

fof(t80_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( m1_subset_1(F,k4_zfmisc_1(A,B,C,D))
     => ( ! [G] :
            ( m1_subset_1(G,A)
           => ! [H] :
                ( m1_subset_1(H,B)
               => ! [I] :
                    ( m1_subset_1(I,C)
                   => ! [J] :
                        ( m1_subset_1(J,D)
                       => ( F = k4_mcart_1(G,H,I,J)
                         => E = H ) ) ) ) )
       => ( A = k1_xboole_0
          | B = k1_xboole_0
          | C = k1_xboole_0
          | D = k1_xboole_0
          | E = k9_mcart_1(A,B,C,D,F) ) ) ) ).

fof(t81_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( m1_subset_1(F,k4_zfmisc_1(A,B,C,D))
     => ( ! [G] :
            ( m1_subset_1(G,A)
           => ! [H] :
                ( m1_subset_1(H,B)
               => ! [I] :
                    ( m1_subset_1(I,C)
                   => ! [J] :
                        ( m1_subset_1(J,D)
                       => ( F = k4_mcart_1(G,H,I,J)
                         => E = I ) ) ) ) )
       => ( A = k1_xboole_0
          | B = k1_xboole_0
          | C = k1_xboole_0
          | D = k1_xboole_0
          | E = k10_mcart_1(A,B,C,D,F) ) ) ) ).

fof(t82_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( m1_subset_1(F,k4_zfmisc_1(A,B,C,D))
     => ( ! [G] :
            ( m1_subset_1(G,A)
           => ! [H] :
                ( m1_subset_1(H,B)
               => ! [I] :
                    ( m1_subset_1(I,C)
                   => ! [J] :
                        ( m1_subset_1(J,D)
                       => ( F = k4_mcart_1(G,H,I,J)
                         => E = J ) ) ) ) )
       => ( A = k1_xboole_0
          | B = k1_xboole_0
          | C = k1_xboole_0
          | D = k1_xboole_0
          | E = k11_mcart_1(A,B,C,D,F) ) ) ) ).

fof(t83_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ~ ( r2_hidden(A,k4_zfmisc_1(B,C,D,E))
        & ! [F,G,H,I] :
            ~ ( r2_hidden(F,B)
              & r2_hidden(G,C)
              & r2_hidden(H,D)
              & r2_hidden(I,E)
              & A = k4_mcart_1(F,G,H,I) ) ) ).

fof(t84_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( r2_hidden(k4_mcart_1(A,B,C,D),k4_zfmisc_1(E,F,G,H))
    <=> ( r2_hidden(A,E)
        & r2_hidden(B,F)
        & r2_hidden(C,G)
        & r2_hidden(D,H) ) ) ).

fof(t85_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( ! [F] :
          ( r2_hidden(F,A)
        <=> ? [G,H,I,J] :
              ( r2_hidden(G,B)
              & r2_hidden(H,C)
              & r2_hidden(I,D)
              & r2_hidden(J,E)
              & F = k4_mcart_1(G,H,I,J) ) )
     => A = k4_zfmisc_1(B,C,D,E) ) ).

fof(t86_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ~ ( A != k1_xboole_0
        & B != k1_xboole_0
        & C != k1_xboole_0
        & D != k1_xboole_0
        & E != k1_xboole_0
        & F != k1_xboole_0
        & G != k1_xboole_0
        & H != k1_xboole_0
        & ? [I] :
            ( m1_subset_1(I,k4_zfmisc_1(A,B,C,D))
            & ? [J] :
                ( m1_subset_1(J,k4_zfmisc_1(E,F,G,H))
                & I = J
                & ~ ( k8_mcart_1(A,B,C,D,I) = k8_mcart_1(E,F,G,H,J)
                    & k9_mcart_1(A,B,C,D,I) = k9_mcart_1(E,F,G,H,J)
                    & k10_mcart_1(A,B,C,D,I) = k10_mcart_1(E,F,G,H,J)
                    & k11_mcart_1(A,B,C,D,I) = k11_mcart_1(E,F,G,H,J) ) ) ) ) ).

fof(t87_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k1_zfmisc_1(A))
     => ! [F] :
          ( m1_subset_1(F,k1_zfmisc_1(B))
         => ! [G] :
              ( m1_subset_1(G,k1_zfmisc_1(C))
             => ! [H] :
                  ( m1_subset_1(H,k1_zfmisc_1(D))
                 => ! [I] :
                      ( m1_subset_1(I,k4_zfmisc_1(A,B,C,D))
                     => ( r2_hidden(I,k4_zfmisc_1(E,F,G,H))
                       => ( r2_hidden(k8_mcart_1(A,B,C,D,I),E)
                          & r2_hidden(k9_mcart_1(A,B,C,D,I),F)
                          & r2_hidden(k10_mcart_1(A,B,C,D,I),G)
                          & r2_hidden(k11_mcart_1(A,B,C,D,I),H) ) ) ) ) ) ) ) ).

fof(t88_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D)
        & r1_tarski(E,F)
        & r1_tarski(G,H) )
     => r1_tarski(k4_zfmisc_1(A,C,E,G),k4_zfmisc_1(B,D,F,H)) ) ).

fof(d12_mcart_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k15_mcart_1(A)
          <=> ( k1_relat_1(B) = k1_relat_1(A)
              & ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => k1_funct_1(B,C) = k1_mcart_1(k1_funct_1(A,C)) ) ) ) ) ) ).

fof(d13_mcart_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k16_mcart_1(A)
          <=> ( k1_relat_1(B) = k1_relat_1(A)
              & ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => k1_funct_1(B,C) = k2_mcart_1(k1_funct_1(A,C)) ) ) ) ) ) ).

fof(d14_mcart_1,axiom,
    ! [A] : k17_mcart_1(A) = k1_mcart_1(k1_mcart_1(A)) ).

fof(d15_mcart_1,axiom,
    ! [A] : k18_mcart_1(A) = k2_mcart_1(k1_mcart_1(A)) ).

fof(d16_mcart_1,axiom,
    ! [A] : k19_mcart_1(A) = k1_mcart_1(k2_mcart_1(A)) ).

fof(d17_mcart_1,axiom,
    ! [A] : k20_mcart_1(A) = k2_mcart_1(k2_mcart_1(A)) ).

fof(t89_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( k17_mcart_1(k4_tarski(k4_tarski(A,B),C)) = A
      & k18_mcart_1(k4_tarski(k4_tarski(A,B),C)) = B
      & k19_mcart_1(k4_tarski(F,k4_tarski(D,E))) = D
      & k20_mcart_1(k4_tarski(F,k4_tarski(D,E))) = E ) ).

fof(dt_k1_mcart_1,axiom,
    $true ).

fof(dt_k2_mcart_1,axiom,
    $true ).

fof(dt_k3_mcart_1,axiom,
    $true ).

fof(dt_k4_mcart_1,axiom,
    $true ).

fof(dt_k5_mcart_1,axiom,
    ! [A,B,C,D] :
      ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
     => m1_subset_1(k5_mcart_1(A,B,C,D),A) ) ).

fof(dt_k6_mcart_1,axiom,
    ! [A,B,C,D] :
      ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
     => m1_subset_1(k6_mcart_1(A,B,C,D),B) ) ).

fof(dt_k7_mcart_1,axiom,
    ! [A,B,C,D] :
      ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
     => m1_subset_1(k7_mcart_1(A,B,C,D),C) ) ).

fof(dt_k8_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
     => m1_subset_1(k8_mcart_1(A,B,C,D,E),A) ) ).

fof(dt_k9_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
     => m1_subset_1(k9_mcart_1(A,B,C,D,E),B) ) ).

fof(dt_k10_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
     => m1_subset_1(k10_mcart_1(A,B,C,D,E),C) ) ).

fof(dt_k11_mcart_1,axiom,
    ! [A,B,C,D,E] :
      ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
     => m1_subset_1(k11_mcart_1(A,B,C,D,E),D) ) ).

fof(dt_k12_mcart_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_subset_1(C,k1_zfmisc_1(A))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => m1_subset_1(k12_mcart_1(A,B,C,D),k1_zfmisc_1(k2_zfmisc_1(A,B))) ) ).

fof(redefinition_k12_mcart_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_subset_1(C,k1_zfmisc_1(A))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => k12_mcart_1(A,B,C,D) = k2_zfmisc_1(C,D) ) ).

fof(dt_k13_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( m1_subset_1(D,k1_zfmisc_1(A))
        & m1_subset_1(E,k1_zfmisc_1(B))
        & m1_subset_1(F,k1_zfmisc_1(C)) )
     => m1_subset_1(k13_mcart_1(A,B,C,D,E,F),k1_zfmisc_1(k3_zfmisc_1(A,B,C))) ) ).

fof(redefinition_k13_mcart_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( m1_subset_1(D,k1_zfmisc_1(A))
        & m1_subset_1(E,k1_zfmisc_1(B))
        & m1_subset_1(F,k1_zfmisc_1(C)) )
     => k13_mcart_1(A,B,C,D,E,F) = k3_zfmisc_1(D,E,F) ) ).

fof(dt_k14_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ( m1_subset_1(E,k1_zfmisc_1(A))
        & m1_subset_1(F,k1_zfmisc_1(B))
        & m1_subset_1(G,k1_zfmisc_1(C))
        & m1_subset_1(H,k1_zfmisc_1(D)) )
     => m1_subset_1(k14_mcart_1(A,B,C,D,E,F,G,H),k1_zfmisc_1(k4_zfmisc_1(A,B,C,D))) ) ).

fof(redefinition_k14_mcart_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ( m1_subset_1(E,k1_zfmisc_1(A))
        & m1_subset_1(F,k1_zfmisc_1(B))
        & m1_subset_1(G,k1_zfmisc_1(C))
        & m1_subset_1(H,k1_zfmisc_1(D)) )
     => k14_mcart_1(A,B,C,D,E,F,G,H) = k4_zfmisc_1(E,F,G,H) ) ).

fof(dt_k15_mcart_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k15_mcart_1(A))
        & v1_funct_1(k15_mcart_1(A)) ) ) ).

fof(dt_k16_mcart_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k16_mcart_1(A))
        & v1_funct_1(k16_mcart_1(A)) ) ) ).

fof(dt_k17_mcart_1,axiom,
    $true ).

fof(dt_k18_mcart_1,axiom,
    $true ).

fof(dt_k19_mcart_1,axiom,
    $true ).

fof(dt_k20_mcart_1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(d1_wellord2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( B = k1_wellord2(A)
      <=> ( k3_relat_1(B) = A
          & ! [C,D] :
              ( ( r2_hidden(C,A)
                & r2_hidden(D,A) )
             => ( r2_hidden(k4_tarski(C,D),B)
              <=> r1_tarski(C,D) ) ) ) ) ) ).

fof(t1_wellord2,axiom,
    $true ).

fof(t2_wellord2,axiom,
    ! [A] : v1_relat_2(k1_wellord2(A)) ).

fof(t3_wellord2,axiom,
    ! [A] : v8_relat_2(k1_wellord2(A)) ).

fof(t4_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v6_relat_2(k1_wellord2(A)) ) ).

fof(t5_wellord2,axiom,
    ! [A] : v4_relat_2(k1_wellord2(A)) ).

fof(t6_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v1_wellord1(k1_wellord2(A)) ) ).

fof(t7_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v2_wellord1(k1_wellord2(A)) ) ).

fof(t8_wellord2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => k2_wellord1(k1_wellord2(B),A) = k1_wellord2(A) ) ).

fof(t9_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r1_tarski(B,A)
         => v2_wellord1(k1_wellord2(B)) ) ) ).

fof(t10_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
           => A = k1_wellord1(k1_wellord2(B),A) ) ) ) ).

fof(t11_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r4_wellord1(k1_wellord2(A),k1_wellord2(B))
           => A = B ) ) ) ).

fof(t12_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( r4_wellord1(A,k1_wellord2(B))
                  & r4_wellord1(A,k1_wellord2(C)) )
               => B = C ) ) ) ) ).

fof(t13_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ~ ( v2_wellord1(A)
          & ! [B] :
              ~ ( r2_hidden(B,k3_relat_1(A))
                & ! [C] :
                    ( v3_ordinal1(C)
                   => ~ r4_wellord1(k2_wellord1(A,k1_wellord1(A,B)),k1_wellord2(C)) ) )
          & ! [B] :
              ( v3_ordinal1(B)
             => ~ r4_wellord1(A,k1_wellord2(B)) ) ) ) ).

fof(t14_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ~ ( v2_wellord1(A)
          & ! [B] :
              ( v3_ordinal1(B)
             => ~ r4_wellord1(A,k1_wellord2(B)) ) ) ) ).

fof(d2_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = k2_wellord2(A)
            <=> r4_wellord1(A,k1_wellord2(B)) ) ) ) ) ).

fof(d3_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_wellord2(A,B)
          <=> A = k2_wellord2(B) ) ) ) ).

fof(t15_wellord2,axiom,
    $true ).

fof(t16_wellord2,axiom,
    $true ).

fof(t17_wellord2,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( r1_tarski(A,B)
       => r1_ordinal1(k2_wellord2(k1_wellord2(A)),B) ) ) ).

fof(d4_wellord2,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
    <=> ? [C] :
          ( v1_relat_1(C)
          & v1_funct_1(C)
          & v2_funct_1(C)
          & k1_relat_1(C) = A
          & k2_relat_1(C) = B ) ) ).

fof(t18_wellord2,axiom,
    $true ).

fof(t19_wellord2,axiom,
    $true ).

fof(t20_wellord2,axiom,
    $true ).

fof(t21_wellord2,axiom,
    $true ).

fof(t22_wellord2,axiom,
    ! [A,B,C] :
      ( ( r2_wellord2(A,B)
        & r2_wellord2(B,C) )
     => r2_wellord2(A,C) ) ).

fof(t23_wellord2,axiom,
    $true ).

fof(t24_wellord2,axiom,
    $true ).

fof(t25_wellord2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r2_wellord1(B,A)
       => ( k3_relat_1(k2_wellord1(B,A)) = A
          & v2_wellord1(k2_wellord1(B,A)) ) ) ) ).

fof(t26_wellord2,axiom,
    ! [A] :
    ? [B] :
      ( v1_relat_1(B)
      & r2_wellord1(B,A) ) ).

fof(t27_wellord2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ~ ( ! [B] :
              ~ ( r2_hidden(B,A)
                & B = k1_xboole_0 )
          & ! [B,C] :
              ( ( r2_hidden(B,A)
                & r2_hidden(C,A) )
             => ( B = C
                | r1_xboole_0(B,C) ) )
          & ! [B] :
            ? [C] :
              ( r2_hidden(C,A)
              & ! [D] : k3_xboole_0(B,C) != k1_tarski(D) ) ) ) ).

fof(t28_wellord2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ~ ( ! [B] :
              ~ ( r2_hidden(B,A)
                & B = k1_xboole_0 )
          & ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B) )
             => ~ ( k1_relat_1(B) = A
                  & ! [C] :
                      ( r2_hidden(C,A)
                     => r2_hidden(k1_funct_1(B,C),C) ) ) ) ) ) ).

fof(s1_wellord2,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s1_wellord2)
          & ! [B] :
              ~ ( r2_hidden(B,f2_s1_wellord2)
                & p1_s1_wellord2(A,B) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & k1_relat_1(A) = f1_s1_wellord2
        & r1_tarski(k2_relat_1(A),f2_s1_wellord2)
        & ! [B] :
            ( r2_hidden(B,f1_s1_wellord2)
           => p1_s1_wellord2(B,k1_funct_1(A,B)) ) ) ) ).

fof(s2_wellord2,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s2_wellord2)
          & ! [B,C] :
              ~ ( r2_hidden(B,f2_s2_wellord2)
                & r2_hidden(C,f3_s2_wellord2)
                & p1_s2_wellord2(A,B,C) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & ? [B] :
            ( v1_relat_1(B)
            & v1_funct_1(B)
            & k1_relat_1(A) = f1_s2_wellord2
            & k1_relat_1(B) = f1_s2_wellord2
            & ! [C] :
                ( r2_hidden(C,f1_s2_wellord2)
               => p1_s2_wellord2(C,k1_funct_1(A,C),k1_funct_1(B,C)) ) ) ) ) ).

fof(symmetry_r2_wellord2,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
     => r2_wellord2(B,A) ) ).

fof(reflexivity_r2_wellord2,axiom,
    ! [A,B] : r2_wellord2(A,A) ).

fof(redefinition_r2_wellord2,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
    <=> r2_tarski(A,B) ) ).

fof(dt_k1_wellord2,axiom,
    ! [A] : v1_relat_1(k1_wellord2(A)) ).

fof(dt_k2_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => v3_ordinal1(k2_wellord2(A)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_funct_2,axiom,
    ! [A,B] :
    ? [C] :
      ( m1_relset_1(C,A,B)
      & v1_relat_1(C)
      & v1_funct_1(C)
      & v1_funct_2(C,A,B) ) ).

fof(cc1_funct_2,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => ( ( v1_funct_1(C)
          & v1_partfun1(C,A,B) )
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B) ) ) ) ).

fof(fc1_funct_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ~ v1_xboole_0(k1_funct_2(A,B)) ) ).

fof(fc2_funct_2,axiom,
    ! [A] : ~ v1_xboole_0(k1_funct_2(A,A)) ).

fof(cc2_funct_2,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => ( ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & v3_funct_2(C,A,B) )
       => ( v1_funct_1(C)
          & v2_funct_1(C)
          & v1_funct_2(C,A,B)
          & v2_funct_2(C,A,B) ) ) ) ).

fof(cc3_funct_2,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => ( ( v1_funct_1(C)
          & v2_funct_1(C)
          & v1_funct_2(C,A,B)
          & v2_funct_2(C,A,B) )
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & v3_funct_2(C,A,B) ) ) ) ).

fof(rc2_funct_2,axiom,
    ! [A] :
    ? [B] :
      ( m1_relset_1(B,A,A)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v2_funct_1(B)
      & v1_funct_2(B,A,A)
      & v2_funct_2(B,A,A)
      & v3_funct_2(B,A,A) ) ).

fof(cc4_funct_2,axiom,
    ! [A,B] :
      ( m1_relset_1(B,A,A)
     => ( ( v1_funct_1(B)
          & v1_partfun1(B,A,A)
          & v1_relat_2(B)
          & v1_funct_2(B,A,A) )
       => ( v1_funct_1(B)
          & v2_funct_1(B)
          & v1_funct_2(B,A,A)
          & v2_funct_2(B,A,A)
          & v3_funct_2(B,A,A) ) ) ) ).

fof(cc5_funct_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( m1_relset_1(C,A,B)
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,A,B) )
           => ( v1_funct_1(C)
              & v1_partfun1(C,A,B)
              & v1_funct_2(C,A,B) ) ) ) ) ).

fof(cc6_funct_2,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ! [C] :
          ( m1_relset_1(C,A,B)
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,A,B) )
           => ( v1_funct_1(C)
              & ~ v1_xboole_0(C)
              & v1_partfun1(C,A,B)
              & v1_funct_2(C,A,B) ) ) ) ) ).

fof(d1_funct_2,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( ( ( B = k1_xboole_0
           => A = k1_xboole_0 )
         => ( v1_funct_2(C,A,B)
          <=> A = k4_relset_1(A,B,C) ) )
        & ( B = k1_xboole_0
         => ( A = k1_xboole_0
            | ( v1_funct_2(C,A,B)
            <=> C = k1_xboole_0 ) ) ) ) ) ).

fof(t1_funct_2,axiom,
    $true ).

fof(t2_funct_2,axiom,
    $true ).

fof(t3_funct_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(A)
        & v1_funct_2(A,k1_relat_1(A),k2_relat_1(A))
        & m2_relset_1(A,k1_relat_1(A),k2_relat_1(A)) ) ) ).

fof(t4_funct_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k2_relat_1(B),A)
       => ( v1_funct_1(B)
          & v1_funct_2(B,k1_relat_1(B),A)
          & m2_relset_1(B,k1_relat_1(B),A) ) ) ) ).

fof(t5_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( k1_relat_1(C) = A
          & ! [D] :
              ( r2_hidden(D,A)
             => r2_hidden(k1_funct_1(C,D),B) ) )
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t6_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r2_hidden(C,A)
       => ( B = k1_xboole_0
          | r2_hidden(k1_funct_1(D,C),k2_relat_1(D)) ) ) ) ).

fof(t7_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r2_hidden(C,A)
       => ( B = k1_xboole_0
          | r2_hidden(k1_funct_1(D,C),B) ) ) ) ).

fof(t8_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(k2_relat_1(D),C)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | ( v1_funct_1(D)
            & v1_funct_2(D,A,C)
            & m2_relset_1(D,A,C) ) ) ) ) ).

fof(t9_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(B,C)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | ( v1_funct_1(D)
            & v1_funct_2(D,A,C)
            & m2_relset_1(D,A,C) ) ) ) ) ).

fof(d2_funct_2,axiom,
    ! [A,B,C] :
      ( C = k1_funct_2(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E] :
              ( v1_relat_1(E)
              & v1_funct_1(E)
              & D = E
              & k1_relat_1(E) = A
              & r1_tarski(k2_relat_1(E),B) ) ) ) ).

fof(t10_funct_2,axiom,
    $true ).

fof(t11_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => r2_hidden(C,k1_funct_2(A,B)) ) ) ).

fof(t12_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => r2_hidden(B,k1_funct_2(A,A)) ) ).

fof(t13_funct_2,axiom,
    $true ).

fof(t14_funct_2,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => k1_funct_2(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t15_funct_2,axiom,
    $true ).

fof(t16_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & ! [E] :
                  ~ ( r2_hidden(E,A)
                    & D = k1_funct_1(C,E) ) )
       => ( B = k1_xboole_0
          | k2_relat_1(C) = B ) ) ) ).

fof(t17_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ~ ( r2_hidden(C,B)
          & k2_relat_1(D) = B
          & ! [E] :
              ~ ( r2_hidden(E,A)
                & k1_funct_1(D,E) = C ) ) ) ).

fof(t18_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ! [E] :
                ( r2_hidden(E,A)
               => k1_funct_1(C,E) = k1_funct_1(D,E) )
           => C = D ) ) ) ).

fof(t19_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ~ ( B = k1_xboole_0
                & C != k1_xboole_0
                & A != k1_xboole_0 )
           => ( v1_funct_1(k1_partfun1(A,B,B,C,D,E))
              & v1_funct_2(k1_partfun1(A,B,B,C,D,E),A,C)
              & m2_relset_1(k1_partfun1(A,B,B,C,D,E),A,C) ) ) ) ) ).

fof(t20_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ( k2_relat_1(D) = B
              & k2_relat_1(E) = C )
           => ( B = k1_xboole_0
              | C = k1_xboole_0
              | k2_relat_1(k1_partfun1(A,B,B,C,D,E)) = C ) ) ) ) ).

fof(t21_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_relat_1(E)
            & v1_funct_1(E) )
         => ( r2_hidden(C,A)
           => ( B = k1_xboole_0
              | k1_funct_1(k5_relat_1(D,E),C) = k1_funct_1(E,k1_funct_1(D,C)) ) ) ) ) ).

fof(t22_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( B != k1_xboole_0
       => ( k2_relat_1(C) = B
        <=> ! [D] :
              ( D != k1_xboole_0
             => ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,B,D)
                    & m2_relset_1(E,B,D) )
                 => ! [F] :
                      ( ( v1_funct_1(F)
                        & v1_funct_2(F,B,D)
                        & m2_relset_1(F,B,D) )
                     => ( k1_partfun1(A,B,B,D,C,E) = k1_partfun1(A,B,B,D,C,F)
                       => E = F ) ) ) ) ) ) ) ).

fof(t23_funct_2,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( k7_relset_1(A,A,A,B,k6_partfun1(A),C) = C
        & k7_relset_1(A,B,B,B,C,k6_partfun1(B)) = C ) ) ).

fof(t24_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( k1_partfun1(B,A,A,B,D,C) = k6_partfun1(B)
           => k2_relat_1(C) = B ) ) ) ).

fof(t25_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => ( v2_funct_1(C)
        <=> ! [D,E] :
              ( ( r2_hidden(D,A)
                & r2_hidden(E,A)
                & k1_funct_1(C,D) = k1_funct_1(C,E) )
             => D = E ) ) ) ) ).

fof(t26_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( v2_funct_1(k1_partfun1(A,B,B,C,D,E))
           => ( ( C = k1_xboole_0
                & B != k1_xboole_0 )
              | ( B = k1_xboole_0
                & A != k1_xboole_0 )
              | v2_funct_1(D) ) ) ) ) ).

fof(t27_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ~ ( A != k1_xboole_0
          & B != k1_xboole_0
          & ~ ( v2_funct_1(C)
            <=> ! [D,E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,D,A)
                    & m2_relset_1(E,D,A) )
                 => ! [F] :
                      ( ( v1_funct_1(F)
                        & v1_funct_2(F,D,A)
                        & m2_relset_1(F,D,A) )
                     => ( k1_partfun1(D,A,A,B,E,C) = k1_partfun1(D,A,A,B,F,C)
                       => E = F ) ) ) ) ) ) ).

fof(t28_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ( k2_relat_1(k1_partfun1(A,B,B,C,D,E)) = C
              & v2_funct_1(E) )
           => ( C = k1_xboole_0
              | k2_relat_1(D) = B ) ) ) ) ).

fof(t29_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( k1_partfun1(A,B,B,A,C,D) = k6_partfun1(A)
           => ( B = k1_xboole_0
              | ( v2_funct_1(C)
                & k2_relat_1(D) = A ) ) ) ) ) ).

fof(t30_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ( v2_funct_1(k1_partfun1(A,B,B,C,D,E))
              & k2_relat_1(D) = B )
           => ( ( C = k1_xboole_0
                & B != k1_xboole_0 )
              | ( v2_funct_1(D)
                & v2_funct_1(E) ) ) ) ) ) ).

fof(t31_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( v2_funct_1(C)
          & k2_relat_1(C) = B )
       => ( v1_funct_1(k2_funct_1(C))
          & v1_funct_2(k2_funct_1(C),B,A)
          & m2_relset_1(k2_funct_1(C),B,A) ) ) ) ).

fof(t32_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( ( v2_funct_1(D)
          & r2_hidden(C,A) )
       => ( B = k1_xboole_0
          | k1_funct_1(k2_funct_1(D),k1_funct_1(D,C)) = C ) ) ) ).

fof(t33_funct_2,axiom,
    $true ).

fof(t34_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( ( k2_relat_1(C) = B
              & v2_funct_1(C)
              & ! [E,F] :
                  ( ( ( r2_hidden(E,B)
                      & k1_funct_1(D,E) = F )
                   => ( r2_hidden(F,A)
                      & k1_funct_1(C,F) = E ) )
                  & ( ( r2_hidden(F,A)
                      & k1_funct_1(C,F) = E )
                   => ( r2_hidden(E,B)
                      & k1_funct_1(D,E) = F ) ) ) )
           => ( A = k1_xboole_0
              | B = k1_xboole_0
              | D = k2_funct_1(C) ) ) ) ) ).

fof(t35_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( k2_relat_1(C) = B
          & v2_funct_1(C) )
       => ( B = k1_xboole_0
          | ( k5_relat_1(C,k2_funct_1(C)) = k6_partfun1(A)
            & k5_relat_1(k2_funct_1(C),C) = k6_partfun1(B) ) ) ) ) ).

fof(t36_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( ( k2_relat_1(C) = B
              & k1_partfun1(A,B,B,A,C,D) = k6_partfun1(A)
              & v2_funct_1(C) )
           => ( A = k1_xboole_0
              | B = k1_xboole_0
              | D = k2_funct_1(C) ) ) ) ) ).

fof(t37_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ~ ( B != k1_xboole_0
          & ? [D] :
              ( v1_funct_1(D)
              & v1_funct_2(D,B,A)
              & m2_relset_1(D,B,A)
              & k1_partfun1(A,B,B,A,C,D) = k6_partfun1(A) )
          & ~ v2_funct_1(C) ) ) ).

fof(t38_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(C,A)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | ( v1_funct_1(k2_partfun1(A,B,D,C))
            & v1_funct_2(k2_partfun1(A,B,D,C),C,B)
            & m2_relset_1(k2_partfun1(A,B,D,C),C,B) ) ) ) ) ).

fof(t39_funct_2,axiom,
    $true ).

fof(t40_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(A,C)
       => k2_partfun1(A,B,D,C) = D ) ) ).

fof(t41_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,B)
        & m2_relset_1(E,A,B) )
     => ( ( r2_hidden(C,A)
          & r2_hidden(k1_funct_1(E,C),D) )
       => ( B = k1_xboole_0
          | k1_funct_1(k9_relset_1(A,B,D,E),C) = k1_funct_1(E,C) ) ) ) ).

fof(t42_funct_2,axiom,
    $true ).

fof(t43_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( B != k1_xboole_0
       => ! [E] :
            ( ? [F] :
                ( r2_hidden(F,A)
                & r2_hidden(F,C)
                & E = k1_funct_1(D,F) )
           => r2_hidden(E,k9_relat_1(D,C)) ) ) ) ).

fof(t44_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => r1_tarski(k9_relat_1(D,C),B) ) ).

fof(t45_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k2_funct_2(A,B,C,A) = k2_relat_1(C) ) ) ).

fof(t46_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( B != k1_xboole_0
       => ! [E] :
            ( r2_hidden(E,k10_relat_1(D,C))
          <=> ( r2_hidden(E,A)
              & r2_hidden(k1_funct_1(D,E),C) ) ) ) ) ).

fof(t47_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => r1_tarski(k10_relat_1(D,C),A) ) ).

fof(t48_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k3_funct_2(A,B,C,B) = A ) ) ).

fof(t49_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & k3_funct_2(A,B,C,k1_tarski(D)) = k1_xboole_0 )
      <=> k2_relat_1(C) = B ) ) ).

fof(t50_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(C,A)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | r1_tarski(C,k3_funct_2(A,B,D,k2_funct_2(A,B,D,C))) ) ) ) ).

fof(t51_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k3_funct_2(A,B,C,k2_funct_2(A,B,C,A)) = A ) ) ).

fof(t52_funct_2,axiom,
    $true ).

fof(t53_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,B)
        & m2_relset_1(E,A,B) )
     => ! [F] :
          ( ( v1_funct_1(F)
            & v1_funct_2(F,B,C)
            & m2_relset_1(F,B,C) )
         => ~ ( ( C = k1_xboole_0
               => B = k1_xboole_0 )
              & ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & ~ r1_tarski(k3_funct_2(A,B,E,D),k3_funct_2(A,C,k1_partfun1(A,B,B,C,E,F),k2_funct_2(B,C,F,D))) ) ) ) ).

fof(t54_funct_2,axiom,
    $true ).

fof(t55_funct_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( k1_relat_1(B) = k1_xboole_0
       => ( v1_funct_1(B)
          & v1_funct_2(B,k1_xboole_0,A)
          & m2_relset_1(B,k1_xboole_0,A) ) ) ) ).

fof(t56_funct_2,axiom,
    $true ).

fof(t57_funct_2,axiom,
    $true ).

fof(t58_funct_2,axiom,
    $true ).

fof(t59_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_xboole_0,A)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k2_funct_2(k1_xboole_0,A,C,B) = k1_xboole_0 ) ).

fof(t60_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_xboole_0,A)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k3_funct_2(k1_xboole_0,A,C,B) = k1_xboole_0 ) ).

fof(t61_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_tarski(A),B)
        & m2_relset_1(C,k1_tarski(A),B) )
     => ( B != k1_xboole_0
       => r2_hidden(k1_funct_1(C,A),B) ) ) ).

fof(t62_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_tarski(A),B)
        & m2_relset_1(C,k1_tarski(A),B) )
     => ( B != k1_xboole_0
       => k2_relat_1(C) = k1_tarski(k1_funct_1(C,A)) ) ) ).

fof(t63_funct_2,axiom,
    $true ).

fof(t64_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k1_tarski(A),B)
        & m2_relset_1(D,k1_tarski(A),B) )
     => ( B != k1_xboole_0
       => r1_tarski(k2_funct_2(k1_tarski(A),B,D,C),k1_tarski(k1_funct_1(D,A))) ) ) ).

fof(t65_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,k1_tarski(B))
        & m2_relset_1(D,A,k1_tarski(B)) )
     => ( r2_hidden(C,A)
       => k1_funct_1(D,C) = B ) ) ).

fof(t66_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,k1_tarski(B))
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,k1_tarski(B))
            & m2_relset_1(D,A,k1_tarski(B)) )
         => C = D ) ) ).

fof(t67_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( k4_relset_1(A,A,B) = A
        & r1_tarski(k2_relat_1(B),A) ) ) ).

fof(t68_funct_2,axiom,
    $true ).

fof(t69_funct_2,axiom,
    $true ).

fof(t70_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & m2_relset_1(C,A,A) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r2_hidden(B,A)
           => k1_funct_1(k5_relat_1(C,D),B) = k1_funct_1(D,k1_funct_1(C,B)) ) ) ) ).

fof(t71_funct_2,axiom,
    $true ).

fof(t72_funct_2,axiom,
    $true ).

fof(t73_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( ( k2_relat_1(B) = A
              & k2_relat_1(C) = A )
           => k2_relat_1(k4_funct_2(A,B,C)) = A ) ) ) ).

fof(t74_funct_2,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => ( k7_relset_1(A,A,A,A,B,k6_partfun1(A)) = B
        & k7_relset_1(A,A,A,A,k6_partfun1(A),B) = B ) ) ).

fof(t75_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( ( k4_funct_2(A,B,C) = B
              & k2_relat_1(B) = A )
           => C = k6_partfun1(A) ) ) ) ).

fof(t76_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( ( k4_funct_2(A,C,B) = B
              & v2_funct_1(B) )
           => C = k6_partfun1(A) ) ) ) ).

fof(t77_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( v2_funct_1(B)
      <=> ! [C,D] :
            ( ( r2_hidden(C,A)
              & r2_hidden(D,A)
              & k1_funct_1(B,C) = k1_funct_1(B,D) )
           => C = D ) ) ) ).

fof(t78_funct_2,axiom,
    $true ).

fof(t79_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => k2_funct_2(A,A,B,A) = k2_relat_1(B) ) ).

fof(t80_funct_2,axiom,
    $true ).

fof(t81_funct_2,axiom,
    $true ).

fof(t82_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => k3_funct_2(A,A,B,k2_funct_2(A,A,B,A)) = A ) ).

fof(d3_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( v2_funct_2(C,A,B)
      <=> k2_relat_1(C) = B ) ) ).

fof(d4_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( v3_funct_2(C,A,B)
      <=> ( v2_funct_1(C)
          & v2_funct_2(C,A,B) ) ) ) ).

fof(t83_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( ( v2_funct_1(B)
          & k2_relat_1(B) = A )
       => ( v1_funct_1(B)
          & v1_funct_2(B,A,A)
          & v3_funct_2(B,A,A)
          & m2_relset_1(B,A,A) ) ) ) ).

fof(t84_funct_2,axiom,
    $true ).

fof(t85_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( v2_funct_1(B)
       => ! [C,D] :
            ( ( r2_hidden(C,A)
              & r2_hidden(D,A)
              & k1_funct_1(B,C) = k1_funct_1(B,D) )
           => C = D ) ) ) ).

fof(t86_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & v3_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( k5_funct_2(A,B,C) = C
           => B = k6_partfun1(A) ) ) ) ).

fof(t87_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & v3_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( k5_funct_2(A,B,C) = k6_partfun1(A)
           => C = k6_funct_2(A,B) ) ) ) ).

fof(t88_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( k5_funct_2(A,B,k6_funct_2(A,B)) = k6_partfun1(A)
        & k5_funct_2(A,k6_funct_2(A,B),B) = k6_partfun1(A) ) ) ).

fof(t89_funct_2,axiom,
    $true ).

fof(t90_funct_2,axiom,
    $true ).

fof(t91_funct_2,axiom,
    $true ).

fof(t92_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & v3_funct_2(C,A,A)
        & m2_relset_1(C,A,A) )
     => ( r1_tarski(B,A)
       => ( k2_funct_2(A,A,C,k3_funct_2(A,A,C,B)) = B
          & k3_funct_2(A,A,C,k2_funct_2(A,A,C,B)) = B ) ) ) ).

fof(t93_funct_2,axiom,
    $true ).

fof(t94_funct_2,axiom,
    $true ).

fof(t95_funct_2,axiom,
    $true ).

fof(t96_funct_2,axiom,
    $true ).

fof(t97_funct_2,axiom,
    $true ).

fof(t98_funct_2,axiom,
    $true ).

fof(t99_funct_2,axiom,
    $true ).

fof(t100_funct_2,axiom,
    $true ).

fof(t101_funct_2,axiom,
    $true ).

fof(t102_funct_2,axiom,
    $true ).

fof(t103_funct_2,axiom,
    $true ).

fof(t104_funct_2,axiom,
    $true ).

fof(t105_funct_2,axiom,
    $true ).

fof(t106_funct_2,axiom,
    $true ).

fof(t107_funct_2,axiom,
    $true ).

fof(t108_funct_2,axiom,
    $true ).

fof(t109_funct_2,axiom,
    $true ).

fof(t110_funct_2,axiom,
    $true ).

fof(t111_funct_2,axiom,
    $true ).

fof(t112_funct_2,axiom,
    $true ).

fof(t113_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ! [E] :
                ( m1_subset_1(E,A)
               => k1_funct_1(C,E) = k1_funct_1(D,E) )
           => C = D ) ) ) ).

fof(t114_funct_2,axiom,
    $true ).

fof(t115_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ~ ( r2_hidden(E,k2_funct_2(A,B,D,C))
            & ! [F] :
                ~ ( r2_hidden(F,A)
                  & r2_hidden(F,C)
                  & E = k1_funct_1(D,F) ) ) ) ).

fof(t116_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ~ ( r2_hidden(E,k2_funct_2(A,B,D,C))
            & ! [F] :
                ( m1_subset_1(F,A)
               => ~ ( r2_hidden(F,C)
                    & E = k1_funct_1(D,F) ) ) ) ) ).

fof(t117_funct_2,axiom,
    $true ).

fof(t118_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,k2_zfmisc_1(A,B),C)
            & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
         => ( ! [F,G] :
                ( ( r2_hidden(F,A)
                  & r2_hidden(G,B) )
               => k1_funct_1(D,k4_tarski(F,G)) = k1_funct_1(E,k4_tarski(F,G)) )
           => D = E ) ) ) ).

fof(t119_funct_2,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(F)
        & v1_funct_2(F,k2_zfmisc_1(A,B),C)
        & m2_relset_1(F,k2_zfmisc_1(A,B),C) )
     => ( ( r2_hidden(D,A)
          & r2_hidden(E,B) )
       => ( C = k1_xboole_0
          | r2_hidden(k1_funct_1(F,k4_tarski(D,E)),C) ) ) ) ).

fof(t120_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,k2_zfmisc_1(A,B),C)
            & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
         => ( ! [F] :
                ( m1_subset_1(F,A)
               => ! [G] :
                    ( m1_subset_1(G,B)
                   => k1_funct_1(D,k4_tarski(F,G)) = k1_funct_1(E,k4_tarski(F,G)) ) )
           => D = E ) ) ) ).

fof(t121_funct_2,axiom,
    ! [A,B,C] :
      ( r2_hidden(C,k1_funct_2(A,B))
     => ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) ) ) ).

fof(t122_funct_2,axiom,
    $true ).

fof(t123_funct_2,axiom,
    $true ).

fof(t124_funct_2,axiom,
    $true ).

fof(t125_funct_2,axiom,
    $true ).

fof(t126_funct_2,axiom,
    $true ).

fof(t127_funct_2,axiom,
    $true ).

fof(t128_funct_2,axiom,
    $true ).

fof(t129_funct_2,axiom,
    $true ).

fof(t130_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( k4_relset_1(A,B,C) = A
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t131_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( v1_partfun1(C,A,B)
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t132_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) )
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | v1_partfun1(C,A,B) ) ) ) ).

fof(t133_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => v1_partfun1(k3_partfun1(C,A,B),A,B) ) ) ).

fof(t134_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => v1_partfun1(k3_partfun1(B,A,A),A,A) ) ).

fof(t135_funct_2,axiom,
    $true ).

fof(t136_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ~ ( ( B = k1_xboole_0
           => A = k1_xboole_0 )
          & ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => ? [E] :
                  ( r2_hidden(E,k4_relset_1(A,B,C))
                  & k1_funct_1(D,E) != k1_funct_1(C,E) ) ) ) ) ).

fof(t137_funct_2,axiom,
    $true ).

fof(t138_funct_2,axiom,
    $true ).

fof(t139_funct_2,axiom,
    $true ).

fof(t140_funct_2,axiom,
    $true ).

fof(t141_funct_2,axiom,
    ! [A,B] : r1_tarski(k1_funct_2(A,B),k4_partfun1(A,B)) ).

fof(t142_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( r1_partfun1(C,D)
           => ( ( B = k1_xboole_0
                & A != k1_xboole_0 )
              | C = D ) ) ) ) ).

fof(t143_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( r1_partfun1(B,C)
           => B = C ) ) ) ).

fof(t144_funct_2,axiom,
    $true ).

fof(t145_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ( B = k1_xboole_0
             => A = k1_xboole_0 )
           => ( r1_partfun1(C,D)
            <=> ! [E] :
                  ( r2_hidden(E,k4_relset_1(A,B,C))
                 => k1_funct_1(C,E) = k1_funct_1(D,E) ) ) ) ) ) ).

fof(t146_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( r1_partfun1(B,C)
          <=> ! [D] :
                ( r2_hidden(D,k4_relset_1(A,A,B))
               => k1_funct_1(B,D) = k1_funct_1(C,D) ) ) ) ) ).

fof(t147_funct_2,axiom,
    $true ).

fof(t148_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ~ ( ( B = k1_xboole_0
           => A = k1_xboole_0 )
          & ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => ~ r1_partfun1(C,D) ) ) ) ).

fof(t149_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ? [C] :
          ( v1_funct_1(C)
          & v1_funct_2(C,A,A)
          & m2_relset_1(C,A,A)
          & r1_partfun1(B,C) ) ) ).

fof(t150_funct_2,axiom,
    $true ).

fof(t151_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ! [E] :
              ( ( v1_funct_1(E)
                & v1_funct_2(E,A,B)
                & m2_relset_1(E,A,B) )
             => ( ( r1_partfun1(C,E)
                  & r1_partfun1(D,E) )
               => ( ( B = k1_xboole_0
                    & A != k1_xboole_0 )
                  | r1_partfun1(C,D) ) ) ) ) ) ).

fof(t152_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & m2_relset_1(C,A,A) )
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,A)
                & m2_relset_1(D,A,A) )
             => ( ( r1_partfun1(B,D)
                  & r1_partfun1(C,D) )
               => r1_partfun1(B,C) ) ) ) ) ).

fof(t153_funct_2,axiom,
    $true ).

fof(t154_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & r1_partfun1(C,D)
              & ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,A,B)
                    & m2_relset_1(E,A,B) )
                 => ~ ( r1_partfun1(C,E)
                      & r1_partfun1(D,E) ) ) ) ) ) ).

fof(t155_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( r1_partfun1(C,D)
           => ( ( B = k1_xboole_0
                & A != k1_xboole_0 )
              | r2_hidden(D,k5_partfun1(A,B,C)) ) ) ) ) ).

fof(t156_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( r1_partfun1(B,C)
           => r2_hidden(C,k5_partfun1(A,A,B)) ) ) ) ).

fof(t157_funct_2,axiom,
    $true ).

fof(t158_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( r2_hidden(D,k5_partfun1(A,B,C))
         => ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) ) ) ) ).

fof(t159_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => r1_tarski(k5_partfun1(A,B,C),k1_funct_2(A,B)) ) ).

fof(t160_funct_2,axiom,
    ! [A,B] : k5_partfun1(A,B,k3_partfun1(k1_xboole_0,A,B)) = k1_funct_2(A,B) ).

fof(t161_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k5_partfun1(A,B,k3_partfun1(C,A,B)) = k1_tarski(C) ) ) ).

fof(t162_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => k5_partfun1(A,A,k3_partfun1(B,A,A)) = k1_tarski(B) ) ).

fof(t163_funct_2,axiom,
    $true ).

fof(t164_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,k1_tarski(B))
            & m2_relset_1(D,A,k1_tarski(B)) )
         => k5_partfun1(A,k1_tarski(B),C) = k1_tarski(D) ) ) ).

fof(t165_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( r1_tarski(D,C)
           => r1_tarski(k5_partfun1(A,B,C),k5_partfun1(A,B,D)) ) ) ) ).

fof(t166_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( r1_tarski(k4_relset_1(A,B,D),k4_relset_1(A,B,C))
              & r1_tarski(k5_partfun1(A,B,C),k5_partfun1(A,B,D)) )
           => r1_tarski(D,C) ) ) ) ).

fof(t167_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( r1_tarski(k5_partfun1(A,B,C),k5_partfun1(A,B,D))
              & ! [E] : B != k1_tarski(E) )
           => r1_tarski(D,C) ) ) ) ).

fof(t168_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( ! [E] : B != k1_tarski(E)
              & k5_partfun1(A,B,C) = k5_partfun1(A,B,D) )
           => C = D ) ) ) ).

fof(d5_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C))
        & m2_relset_1(D,k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C)) )
     => D = k9_funct_2(A,B,C) ) ).

fof(t169_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(C,k1_funct_2(A,B))
       => ( k1_relat_1(C) = A
          & r1_tarski(k2_relat_1(C),B) ) ) ) ).

fof(s1_funct_2,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s1_funct_2)
          & ! [B] :
              ~ ( r2_hidden(B,f2_s1_funct_2)
                & p1_s1_funct_2(A,B) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s1_funct_2,f2_s1_funct_2)
        & m2_relset_1(A,f1_s1_funct_2,f2_s1_funct_2)
        & ! [B] :
            ( r2_hidden(B,f1_s1_funct_2)
           => p1_s1_funct_2(B,k1_funct_1(A,B)) ) ) ) ).

fof(s2_funct_2,axiom,
    ( ! [A] :
        ( r2_hidden(A,f1_s2_funct_2)
       => r2_hidden(f3_s2_funct_2(A),f2_s2_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s2_funct_2,f2_s2_funct_2)
        & m2_relset_1(A,f1_s2_funct_2,f2_s2_funct_2)
        & ! [B] :
            ( r2_hidden(B,f1_s2_funct_2)
           => k1_funct_1(A,B) = f3_s2_funct_2(B) ) ) ) ).

fof(s3_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s3_funct_2)
       => ? [B] :
            ( m1_subset_1(B,f2_s3_funct_2)
            & p1_s3_funct_2(A,B) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s3_funct_2,f2_s3_funct_2)
        & m2_relset_1(A,f1_s3_funct_2,f2_s3_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s3_funct_2)
           => p1_s3_funct_2(B,k8_funct_2(f1_s3_funct_2,f2_s3_funct_2,A,B)) ) ) ) ).

fof(s4_funct_2,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,f1_s4_funct_2,f2_s4_funct_2)
      & m2_relset_1(A,f1_s4_funct_2,f2_s4_funct_2)
      & ! [B] :
          ( m1_subset_1(B,f1_s4_funct_2)
         => k8_funct_2(f1_s4_funct_2,f2_s4_funct_2,A,B) = f3_s4_funct_2(B) ) ) ).

fof(s5_funct_2,axiom,
    ( ! [A,B] :
        ~ ( r2_hidden(A,f1_s5_funct_2)
          & r2_hidden(B,f2_s5_funct_2)
          & ! [C] :
              ~ ( r2_hidden(C,f3_s5_funct_2)
                & p1_s5_funct_2(A,B,C) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s5_funct_2,f2_s5_funct_2),f3_s5_funct_2)
        & m2_relset_1(A,k2_zfmisc_1(f1_s5_funct_2,f2_s5_funct_2),f3_s5_funct_2)
        & ! [B,C] :
            ( ( r2_hidden(B,f1_s5_funct_2)
              & r2_hidden(C,f2_s5_funct_2) )
           => p1_s5_funct_2(B,C,k1_funct_1(A,k4_tarski(B,C))) ) ) ) ).

fof(s6_funct_2,axiom,
    ( ! [A,B] :
        ( ( r2_hidden(A,f1_s6_funct_2)
          & r2_hidden(B,f2_s6_funct_2) )
       => r2_hidden(f4_s6_funct_2(A,B),f3_s6_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s6_funct_2,f2_s6_funct_2),f3_s6_funct_2)
        & m2_relset_1(A,k2_zfmisc_1(f1_s6_funct_2,f2_s6_funct_2),f3_s6_funct_2)
        & ! [B,C] :
            ( ( r2_hidden(B,f1_s6_funct_2)
              & r2_hidden(C,f2_s6_funct_2) )
           => k1_funct_1(A,k4_tarski(B,C)) = f4_s6_funct_2(B,C) ) ) ) ).

fof(s7_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s7_funct_2)
       => ! [B] :
            ( m1_subset_1(B,f2_s7_funct_2)
           => ? [C] :
                ( m1_subset_1(C,f3_s7_funct_2)
                & p1_s7_funct_2(A,B,C) ) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s7_funct_2,f2_s7_funct_2),f3_s7_funct_2)
        & m2_relset_1(A,k2_zfmisc_1(f1_s7_funct_2,f2_s7_funct_2),f3_s7_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s7_funct_2)
           => ! [C] :
                ( m1_subset_1(C,f2_s7_funct_2)
               => p1_s7_funct_2(B,C,k1_funct_1(A,k4_tarski(B,C))) ) ) ) ) ).

fof(s8_funct_2,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,k2_zfmisc_1(f1_s8_funct_2,f2_s8_funct_2),f3_s8_funct_2)
      & m2_relset_1(A,k2_zfmisc_1(f1_s8_funct_2,f2_s8_funct_2),f3_s8_funct_2)
      & ! [B] :
          ( m1_subset_1(B,f1_s8_funct_2)
         => ! [C] :
              ( m1_subset_1(C,f2_s8_funct_2)
             => k1_funct_1(A,k4_tarski(B,C)) = f4_s8_funct_2(B,C) ) ) ) ).

fof(s9_funct_2,axiom,
    ( ! [A] :
        ( r2_hidden(A,f1_s9_funct_2)
       => ( ( p1_s9_funct_2(A)
           => r2_hidden(f3_s9_funct_2(A),f2_s9_funct_2) )
          & ( ~ p1_s9_funct_2(A)
           => r2_hidden(f4_s9_funct_2(A),f2_s9_funct_2) ) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s9_funct_2,f2_s9_funct_2)
        & m2_relset_1(A,f1_s9_funct_2,f2_s9_funct_2)
        & ! [B] :
            ( r2_hidden(B,f1_s9_funct_2)
           => ( ( p1_s9_funct_2(B)
               => k1_funct_1(A,B) = f3_s9_funct_2(B) )
              & ( ~ p1_s9_funct_2(B)
               => k1_funct_1(A,B) = f4_s9_funct_2(B) ) ) ) ) ) ).

fof(s10_funct_2,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,f1_s10_funct_2,f2_s10_funct_2)
      & m2_relset_1(A,f1_s10_funct_2,f2_s10_funct_2)
      & k8_funct_2(f1_s10_funct_2,f2_s10_funct_2,A,f3_s10_funct_2) = f4_s10_funct_2
      & ! [B] :
          ( m1_subset_1(B,f1_s10_funct_2)
         => ( B != f3_s10_funct_2
           => k8_funct_2(f1_s10_funct_2,f2_s10_funct_2,A,B) = f5_s10_funct_2(B) ) ) ) ).

fof(s11_funct_2,axiom,
    ( f3_s11_funct_2 != f4_s11_funct_2
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s11_funct_2,f2_s11_funct_2)
        & m2_relset_1(A,f1_s11_funct_2,f2_s11_funct_2)
        & k8_funct_2(f1_s11_funct_2,f2_s11_funct_2,A,f3_s11_funct_2) = f5_s11_funct_2
        & k8_funct_2(f1_s11_funct_2,f2_s11_funct_2,A,f4_s11_funct_2) = f6_s11_funct_2
        & ! [B] :
            ( m1_subset_1(B,f1_s11_funct_2)
           => ~ ( B != f3_s11_funct_2
                & B != f4_s11_funct_2
                & k8_funct_2(f1_s11_funct_2,f2_s11_funct_2,A,B) != f7_s11_funct_2(B) ) ) ) ) ).

fof(s12_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s12_funct_2)
       => r2_hidden(f3_s12_funct_2(A),f2_s12_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s12_funct_2,f2_s12_funct_2)
        & m2_relset_1(A,f1_s12_funct_2,f2_s12_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s12_funct_2)
           => k8_funct_2(f1_s12_funct_2,f2_s12_funct_2,A,B) = f3_s12_funct_2(B) ) ) ) ).

fof(s13_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s13_funct_2)
       => m1_subset_1(f3_s13_funct_2(A),f2_s13_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s13_funct_2,f2_s13_funct_2)
        & m2_relset_1(A,f1_s13_funct_2,f2_s13_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s13_funct_2)
           => k8_funct_2(f1_s13_funct_2,f2_s13_funct_2,A,B) = f3_s13_funct_2(B) ) ) ) ).

fof(s14_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s14_funct_2)
       => ? [B] :
            ( m1_subset_1(B,f2_s14_funct_2)
            & p1_s14_funct_2(A,B) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s14_funct_2,f2_s14_funct_2)
        & m2_relset_1(A,f1_s14_funct_2,f2_s14_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s14_funct_2)
           => p1_s14_funct_2(B,k8_funct_2(f1_s14_funct_2,f2_s14_funct_2,A,B)) ) ) ) ).

fof(dt_k1_funct_2,axiom,
    $true ).

fof(dt_k2_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B) )
     => m1_subset_1(k2_funct_2(A,B,C,D),k1_zfmisc_1(B)) ) ).

fof(redefinition_k2_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B) )
     => k2_funct_2(A,B,C,D) = k9_relat_1(C,D) ) ).

fof(dt_k3_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => m1_subset_1(k3_funct_2(A,B,C,D),k1_zfmisc_1(A)) ) ).

fof(redefinition_k3_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => k3_funct_2(A,B,C,D) = k10_relat_1(C,D) ) ).

fof(dt_k4_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => ( v1_funct_1(k4_funct_2(A,B,C))
        & v1_funct_2(k4_funct_2(A,B,C),A,A)
        & m2_relset_1(k4_funct_2(A,B,C),A,A) ) ) ).

fof(redefinition_k4_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => k4_funct_2(A,B,C) = k5_relat_1(B,C) ) ).

fof(dt_k5_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & v3_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => ( v1_funct_1(k5_funct_2(A,B,C))
        & v1_funct_2(k5_funct_2(A,B,C),A,A)
        & v3_funct_2(k5_funct_2(A,B,C),A,A)
        & m2_relset_1(k5_funct_2(A,B,C),A,A) ) ) ).

fof(redefinition_k5_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & v3_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => k5_funct_2(A,B,C) = k5_relat_1(B,C) ) ).

fof(dt_k6_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A) )
     => ( v1_funct_1(k6_funct_2(A,B))
        & v1_funct_2(k6_funct_2(A,B),A,A)
        & v3_funct_2(k6_funct_2(A,B),A,A)
        & m2_relset_1(k6_funct_2(A,B),A,A) ) ) ).

fof(redefinition_k6_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A) )
     => k6_funct_2(A,B) = k2_funct_1(B) ) ).

fof(dt_k7_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m1_relset_1(D,A,B)
        & v1_funct_1(E)
        & v1_funct_2(E,B,C)
        & m1_relset_1(E,B,C) )
     => ( v1_funct_1(k7_funct_2(A,B,C,D,E))
        & v1_funct_2(k7_funct_2(A,B,C,D,E),A,C)
        & m2_relset_1(k7_funct_2(A,B,C,D,E),A,C) ) ) ).

fof(redefinition_k7_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m1_relset_1(D,A,B)
        & v1_funct_1(E)
        & v1_funct_2(E,B,C)
        & m1_relset_1(E,B,C) )
     => k7_funct_2(A,B,C,D,E) = k5_relat_1(D,E) ) ).

fof(dt_k8_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_subset_1(D,A) )
     => m1_subset_1(k8_funct_2(A,B,C,D),B) ) ).

fof(redefinition_k8_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_subset_1(D,A) )
     => k8_funct_2(A,B,C,D) = k1_funct_1(C,D) ) ).

fof(dt_k9_funct_2,axiom,
    ! [A,B,C] :
      ( v1_funct_1(k9_funct_2(A,B,C))
      & v1_funct_2(k9_funct_2(A,B,C),k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C))
      & m2_relset_1(k9_funct_2(A,B,C),k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_funct_3,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => k6_relat_1(A) = k7_relat_1(k6_relat_1(B),A) ) ).

fof(t2_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r1_tarski(A,k1_relat_1(k5_relat_1(B,C)))
           => r1_tarski(k9_relat_1(B,A),k1_relat_1(C)) ) ) ) ).

fof(t3_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_tarski(A,k1_relat_1(B))
              & r1_tarski(k9_relat_1(B,A),k1_relat_1(C)) )
           => r1_tarski(A,k1_relat_1(k5_relat_1(B,C))) ) ) ) ).

fof(t4_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_tarski(A,k2_relat_1(k5_relat_1(B,C)))
              & v2_funct_1(C) )
           => r1_tarski(k10_relat_1(C,A),k2_relat_1(B)) ) ) ) ).

fof(t5_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_tarski(A,k2_relat_1(C))
              & r1_tarski(k10_relat_1(C,A),k2_relat_1(B)) )
           => r1_tarski(A,k2_relat_1(k5_relat_1(B,C))) ) ) ) ).

fof(t6_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( ( k1_relat_1(C) = k2_zfmisc_1(A,B)
              & k1_relat_1(D) = k2_zfmisc_1(A,B)
              & ! [E,F] :
                  ( ( r2_hidden(E,A)
                    & r2_hidden(F,B) )
                 => k1_funct_1(C,k4_tarski(E,F)) = k1_funct_1(D,k4_tarski(E,F)) ) )
           => C = D ) ) ) ).

fof(d1_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k1_funct_3(A)
          <=> ( k1_relat_1(B) = k1_zfmisc_1(k1_relat_1(A))
              & ! [C] :
                  ( r1_tarski(C,k1_relat_1(A))
                 => k1_funct_1(B,C) = k9_relat_1(A,C) ) ) ) ) ) ).

fof(t7_funct_3,axiom,
    $true ).

fof(t8_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(k1_funct_3(B)))
       => k1_funct_1(k1_funct_3(B),A) = k9_relat_1(B,A) ) ) ).

fof(t9_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k1_funct_1(k1_funct_3(A),k1_xboole_0) = k1_xboole_0 ) ).

fof(t10_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_tarski(k2_relat_1(k1_funct_3(A)),k1_zfmisc_1(k2_relat_1(A))) ) ).

fof(t11_funct_3,axiom,
    $true ).

fof(t12_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k9_relat_1(k1_funct_3(B),A),k1_zfmisc_1(k2_relat_1(B))) ) ).

fof(t13_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k10_relat_1(k1_funct_3(B),A),k1_zfmisc_1(k1_relat_1(B))) ) ).

fof(t14_funct_3,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,C)
            & m2_relset_1(D,A,C) )
         => r1_tarski(k10_relat_1(k1_funct_3(D),B),k1_zfmisc_1(A)) ) ) ).

fof(t15_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k3_tarski(k9_relat_1(k1_funct_3(B),A)),k9_relat_1(B,k3_tarski(A))) ) ).

fof(t16_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(A,k1_zfmisc_1(k1_relat_1(B)))
       => k9_relat_1(B,k3_tarski(A)) = k3_tarski(k9_relat_1(k1_funct_3(B),A)) ) ) ).

fof(t17_funct_3,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,C)
            & m2_relset_1(D,A,C) )
         => ( r1_tarski(B,k1_zfmisc_1(A))
           => k2_funct_2(A,C,D,k3_tarski(B)) = k3_tarski(k9_relat_1(k1_funct_3(D),B)) ) ) ) ).

fof(t18_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k3_tarski(k10_relat_1(k1_funct_3(B),A)),k10_relat_1(B,k3_tarski(A))) ) ).

fof(t19_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(A,k1_zfmisc_1(k2_relat_1(B)))
       => k10_relat_1(B,k3_tarski(A)) = k3_tarski(k10_relat_1(k1_funct_3(B),A)) ) ) ).

fof(t20_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k1_funct_3(k5_relat_1(A,B)) = k5_relat_1(k1_funct_3(A),k1_funct_3(B)) ) ) ).

fof(t21_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(k1_funct_3(A))
        & v1_funct_2(k1_funct_3(A),k1_zfmisc_1(k1_relat_1(A)),k1_zfmisc_1(k2_relat_1(A)))
        & m2_relset_1(k1_funct_3(A),k1_zfmisc_1(k1_relat_1(A)),k1_zfmisc_1(k2_relat_1(A))) ) ) ).

fof(t22_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => ( v1_funct_1(k1_funct_3(C))
          & v1_funct_2(k1_funct_3(C),k1_zfmisc_1(A),k1_zfmisc_1(B))
          & m2_relset_1(k1_funct_3(C),k1_zfmisc_1(A),k1_zfmisc_1(B)) ) ) ) ).

fof(d2_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k3_funct_3(A)
          <=> ( k1_relat_1(B) = k1_zfmisc_1(k2_relat_1(A))
              & ! [C] :
                  ( r1_tarski(C,k2_relat_1(A))
                 => k1_funct_1(B,C) = k10_relat_1(A,C) ) ) ) ) ) ).

fof(t23_funct_3,axiom,
    $true ).

fof(t24_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(k3_funct_3(B)))
       => k1_funct_1(k3_funct_3(B),A) = k10_relat_1(B,A) ) ) ).

fof(t25_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_tarski(k2_relat_1(k3_funct_3(A)),k1_zfmisc_1(k1_relat_1(A))) ) ).

fof(t26_funct_3,axiom,
    $true ).

fof(t27_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k9_relat_1(k3_funct_3(B),A),k1_zfmisc_1(k1_relat_1(B))) ) ).

fof(t28_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k10_relat_1(k3_funct_3(B),A),k1_zfmisc_1(k2_relat_1(B))) ) ).

fof(t29_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k3_tarski(k9_relat_1(k3_funct_3(B),A)),k10_relat_1(B,k3_tarski(A))) ) ).

fof(t30_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(A,k1_zfmisc_1(k2_relat_1(B)))
       => k3_tarski(k9_relat_1(k3_funct_3(B),A)) = k10_relat_1(B,k3_tarski(A)) ) ) ).

fof(t31_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k3_tarski(k10_relat_1(k3_funct_3(B),A)),k9_relat_1(B,k3_tarski(A))) ) ).

fof(t32_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( r1_tarski(A,k1_zfmisc_1(k1_relat_1(B)))
          & v2_funct_1(B) )
       => k3_tarski(k10_relat_1(k3_funct_3(B),A)) = k9_relat_1(B,k3_tarski(A)) ) ) ).

fof(t33_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k9_relat_1(k3_funct_3(B),A),k10_relat_1(k1_funct_3(B),A)) ) ).

fof(t34_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => k9_relat_1(k3_funct_3(B),A) = k10_relat_1(k1_funct_3(B),A) ) ) ).

fof(t35_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( r1_tarski(B,k1_zfmisc_1(k1_relat_1(A)))
         => r1_tarski(k10_relat_1(k3_funct_3(A),B),k9_relat_1(k1_funct_3(A),B)) ) ) ).

fof(t36_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( v2_funct_1(A)
         => r1_tarski(k9_relat_1(k1_funct_3(A),B),k10_relat_1(k3_funct_3(A),B)) ) ) ).

fof(t37_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v2_funct_1(A)
            & r1_tarski(B,k1_zfmisc_1(k1_relat_1(A))) )
         => k10_relat_1(k3_funct_3(A),B) = k9_relat_1(k1_funct_3(A),B) ) ) ).

fof(t38_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( v2_funct_1(B)
           => k3_funct_3(k5_relat_1(A,B)) = k5_relat_1(k3_funct_3(B),k3_funct_3(A)) ) ) ) ).

fof(t39_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(k3_funct_3(A))
        & v1_funct_2(k3_funct_3(A),k1_zfmisc_1(k2_relat_1(A)),k1_zfmisc_1(k1_relat_1(A)))
        & m2_relset_1(k3_funct_3(A),k1_zfmisc_1(k2_relat_1(A)),k1_zfmisc_1(k1_relat_1(A))) ) ) ).

fof(d3_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( C = k4_funct_3(A,B)
      <=> ( k1_relat_1(C) = B
          & ! [D] :
              ( r2_hidden(D,B)
             => ( ( r2_hidden(D,A)
                 => k1_funct_1(C,D) = np__1 )
                & ( ~ r2_hidden(D,A)
                 => k1_funct_1(C,D) = np__0 ) ) ) ) ) ) ).

fof(t40_funct_3,axiom,
    $true ).

fof(t41_funct_3,axiom,
    $true ).

fof(t42_funct_3,axiom,
    ! [A,B,C] :
      ( k1_funct_1(k4_funct_3(B,C),A) = np__1
     => r2_hidden(A,B) ) ).

fof(t43_funct_3,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k4_xboole_0(B,C))
     => k1_funct_1(k4_funct_3(C,B),A) = np__0 ) ).

fof(t44_funct_3,axiom,
    $true ).

fof(t45_funct_3,axiom,
    $true ).

fof(t46_funct_3,axiom,
    $true ).

fof(t47_funct_3,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,B)
        & k4_funct_3(A,B) = k4_funct_3(C,B) )
     => A = C ) ).

fof(t48_funct_3,axiom,
    ! [A,B] : r1_tarski(k2_relat_1(k4_funct_3(A,B)),k2_tarski(np__0,np__1)) ).

fof(t49_funct_3,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,k2_tarski(np__0,np__1))
        & m2_relset_1(B,A,k2_tarski(np__0,np__1)) )
     => B = k4_funct_3(k3_funct_2(A,k2_tarski(np__0,np__1),B,k1_tarski(np__1)),A) ) ).

fof(t50_funct_3,axiom,
    $true ).

fof(t51_funct_3,axiom,
    $true ).

fof(t52_funct_3,axiom,
    $true ).

fof(t53_funct_3,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k6_funct_3(A,B) = k7_relat_1(k6_relat_1(A),B) ) ).

fof(t54_funct_3,axiom,
    $true ).

fof(t55_funct_3,axiom,
    $true ).

fof(t56_funct_3,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(B))
     => ( r2_hidden(A,C)
       => r2_hidden(k1_funct_1(k6_funct_3(B,C),A),B) ) ) ).

fof(d4_funct_3,axiom,
    $true ).

fof(d5_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( C = k7_funct_3(A,B)
      <=> ( k1_relat_1(C) = k2_zfmisc_1(A,B)
          & ! [D,E] :
              ( ( r2_hidden(D,A)
                & r2_hidden(E,B) )
             => k1_funct_1(C,k4_tarski(D,E)) = D ) ) ) ) ).

fof(d6_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( C = k8_funct_3(A,B)
      <=> ( k1_relat_1(C) = k2_zfmisc_1(A,B)
          & ! [D,E] :
              ( ( r2_hidden(D,A)
                & r2_hidden(E,B) )
             => k1_funct_1(C,k4_tarski(D,E)) = E ) ) ) ) ).

fof(t57_funct_3,axiom,
    $true ).

fof(t58_funct_3,axiom,
    $true ).

fof(t59_funct_3,axiom,
    ! [A,B] : r1_tarski(k2_relat_1(k7_funct_3(A,B)),A) ).

fof(t60_funct_3,axiom,
    ! [A,B] :
      ( A != k1_xboole_0
     => k2_relat_1(k7_funct_3(B,A)) = B ) ).

fof(t61_funct_3,axiom,
    ! [A,B] : r1_tarski(k2_relat_1(k8_funct_3(A,B)),B) ).

fof(t62_funct_3,axiom,
    ! [A,B] :
      ( A != k1_xboole_0
     => k2_relat_1(k8_funct_3(A,B)) = B ) ).

fof(d7_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( B = k11_funct_3(A)
      <=> ( k1_relat_1(B) = A
          & ! [C] :
              ( r2_hidden(C,A)
             => k1_funct_1(B,C) = k4_tarski(C,C) ) ) ) ) ).

fof(t63_funct_3,axiom,
    $true ).

fof(t64_funct_3,axiom,
    $true ).

fof(t65_funct_3,axiom,
    $true ).

fof(t66_funct_3,axiom,
    ! [A] : r1_tarski(k2_relat_1(k11_funct_3(A)),k2_zfmisc_1(A,A)) ).

fof(d8_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( C = k13_funct_3(A,B)
              <=> ( k1_relat_1(C) = k3_xboole_0(k1_relat_1(A),k1_relat_1(B))
                  & ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                     => k1_funct_1(C,D) = k4_tarski(k1_funct_1(A,D),k1_funct_1(B,D)) ) ) ) ) ) ) ).

fof(t67_funct_3,axiom,
    $true ).

fof(t68_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k3_xboole_0(k1_relat_1(B),k1_relat_1(C)))
           => k1_funct_1(k13_funct_3(B,C),A) = k4_tarski(k1_funct_1(B,A),k1_funct_1(C,A)) ) ) ) ).

fof(t69_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( ( k1_relat_1(C) = B
              & k1_relat_1(D) = B
              & r2_hidden(A,B) )
           => k1_funct_1(k13_funct_3(C,D),A) = k4_tarski(k1_funct_1(C,A),k1_funct_1(D,A)) ) ) ) ).

fof(t70_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( k1_relat_1(B) = A
              & k1_relat_1(C) = A )
           => k1_relat_1(k13_funct_3(B,C)) = A ) ) ) ).

fof(t71_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k2_relat_1(k13_funct_3(A,B)),k2_zfmisc_1(k2_relat_1(A),k2_relat_1(B))) ) ) ).

fof(t72_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( ( k1_relat_1(C) = k1_relat_1(D)
              & r1_tarski(k2_relat_1(C),A)
              & r1_tarski(k2_relat_1(D),B) )
           => ( k5_relat_1(k13_funct_3(C,D),k9_funct_3(A,B)) = C
              & k5_relat_1(k13_funct_3(C,D),k10_funct_3(A,B)) = D ) ) ) ) ).

fof(t73_funct_3,axiom,
    ! [A,B] : k13_funct_3(k9_funct_3(A,B),k10_funct_3(A,B)) = k6_relat_1(k2_zfmisc_1(A,B)) ).

fof(t74_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( k1_relat_1(A) = k1_relat_1(B)
                      & k1_relat_1(D) = k1_relat_1(C)
                      & k13_funct_3(A,B) = k13_funct_3(D,C) )
                   => ( A = D
                      & B = C ) ) ) ) ) ) ).

fof(t75_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => k13_funct_3(k5_relat_1(C,A),k5_relat_1(C,B)) = k5_relat_1(C,k13_funct_3(A,B)) ) ) ) ).

fof(t76_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => r1_tarski(k9_relat_1(k13_funct_3(B,C),A),k2_zfmisc_1(k9_relat_1(B,A),k9_relat_1(C,A))) ) ) ).

fof(t77_funct_3,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => k10_relat_1(k13_funct_3(C,D),k2_zfmisc_1(A,B)) = k3_xboole_0(k10_relat_1(C,A),k10_relat_1(D,B)) ) ) ) ).

fof(t78_funct_3,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,A,C)
            & m2_relset_1(E,A,C) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & ( C = k1_xboole_0
               => A = k1_xboole_0 )
              & ~ ( v1_funct_1(k13_funct_3(D,E))
                  & v1_funct_2(k13_funct_3(D,E),A,k2_zfmisc_1(B,C))
                  & m2_relset_1(k13_funct_3(D,E),A,k2_zfmisc_1(B,C)) ) ) ) ) ).

fof(t79_funct_3,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,C)
                        & m2_relset_1(E,A,C) )
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => k8_funct_2(A,k2_zfmisc_1(B,C),k14_funct_3(A,B,C,D,E),F) = k4_tarski(k8_funct_2(A,B,D,F),k8_funct_2(A,C,E,F)) ) ) ) ) ) ) ).

fof(t80_funct_3,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,A,C)
            & m2_relset_1(E,A,C) )
         => r1_tarski(k2_relat_1(k13_funct_3(D,E)),k2_zfmisc_1(B,C)) ) ) ).

fof(t81_funct_3,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,A,C)
            & m2_relset_1(E,A,C) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & ( C = k1_xboole_0
               => A = k1_xboole_0 )
              & ~ ( k5_relat_1(k13_funct_3(D,E),k9_funct_3(B,C)) = D
                  & k5_relat_1(k13_funct_3(D,E),k10_funct_3(B,C)) = E ) ) ) ) ).

fof(t82_funct_3,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,A,C)
                    & m2_relset_1(E,A,C) )
                 => ( k7_funct_2(A,k2_zfmisc_1(B,C),B,k14_funct_3(A,B,C,D,E),k9_funct_3(B,C)) = D
                    & k7_funct_2(A,k2_zfmisc_1(B,C),C,k14_funct_3(A,B,C,D,E),k10_funct_3(B,C)) = E ) ) ) ) ) ).

fof(t83_funct_3,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,A,B)
            & m2_relset_1(E,A,B) )
         => ! [F] :
              ( ( v1_funct_1(F)
                & v1_funct_2(F,A,C)
                & m2_relset_1(F,A,C) )
             => ! [G] :
                  ( ( v1_funct_1(G)
                    & v1_funct_2(G,A,C)
                    & m2_relset_1(G,A,C) )
                 => ( k13_funct_3(D,F) = k13_funct_3(E,G)
                   => ( ( B = k1_xboole_0
                        & A != k1_xboole_0 )
                      | ( C = k1_xboole_0
                        & A != k1_xboole_0 )
                      | ( D = E
                        & F = G ) ) ) ) ) ) ) ).

fof(t84_funct_3,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,A,B)
                    & m2_relset_1(E,A,B) )
                 => ! [F] :
                      ( ( v1_funct_1(F)
                        & v1_funct_2(F,A,C)
                        & m2_relset_1(F,A,C) )
                     => ! [G] :
                          ( ( v1_funct_1(G)
                            & v1_funct_2(G,A,C)
                            & m2_relset_1(G,A,C) )
                         => ( k14_funct_3(A,B,C,D,F) = k14_funct_3(A,B,C,E,G)
                           => ( D = E
                              & F = G ) ) ) ) ) ) ) ) ).

fof(d9_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( C = k15_funct_3(A,B)
              <=> ( k1_relat_1(C) = k2_zfmisc_1(k1_relat_1(A),k1_relat_1(B))
                  & ! [D,E] :
                      ( ( r2_hidden(D,k1_relat_1(A))
                        & r2_hidden(E,k1_relat_1(B)) )
                     => k1_funct_1(C,k4_tarski(D,E)) = k4_tarski(k1_funct_1(A,D),k1_funct_1(B,E)) ) ) ) ) ) ) ).

fof(t85_funct_3,axiom,
    $true ).

fof(t86_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( r2_hidden(k4_tarski(C,D),k2_zfmisc_1(k1_relat_1(A),k1_relat_1(B)))
             => k1_funct_1(k15_funct_3(A,B),k4_tarski(C,D)) = k4_tarski(k1_funct_1(A,C),k1_funct_1(B,D)) ) ) ) ).

fof(t87_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k15_funct_3(A,B) = k13_funct_3(k5_relat_1(k9_funct_3(k1_relat_1(A),k1_relat_1(B)),A),k5_relat_1(k10_funct_3(k1_relat_1(A),k1_relat_1(B)),B)) ) ) ).

fof(t88_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k2_relat_1(k15_funct_3(A,B)) = k2_zfmisc_1(k2_relat_1(A),k2_relat_1(B)) ) ) ).

fof(t89_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( k1_relat_1(B) = A
              & k1_relat_1(C) = A )
           => k13_funct_3(B,C) = k5_relat_1(k12_funct_3(A),k15_funct_3(B,C)) ) ) ) ).

fof(t90_funct_3,axiom,
    ! [A,B] : k15_funct_3(k6_relat_1(A),k6_relat_1(B)) = k6_relat_1(k2_zfmisc_1(A,B)) ).

fof(t91_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => k5_relat_1(k13_funct_3(B,D),k15_funct_3(A,C)) = k13_funct_3(k5_relat_1(B,A),k5_relat_1(D,C)) ) ) ) ) ).

fof(t92_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => k5_relat_1(k15_funct_3(B,D),k15_funct_3(A,C)) = k15_funct_3(k5_relat_1(B,A),k5_relat_1(D,C)) ) ) ) ) ).

fof(t93_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => k9_relat_1(k15_funct_3(C,D),k2_zfmisc_1(A,B)) = k2_zfmisc_1(k9_relat_1(C,A),k9_relat_1(D,B)) ) ) ).

fof(t94_funct_3,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => k10_relat_1(k15_funct_3(C,D),k2_zfmisc_1(A,B)) = k2_zfmisc_1(k10_relat_1(C,A),k10_relat_1(D,B)) ) ) ).

fof(t95_funct_3,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,B)
        & m2_relset_1(E,A,B) )
     => ! [F] :
          ( ( v1_funct_1(F)
            & v1_funct_2(F,C,D)
            & m2_relset_1(F,C,D) )
         => ( v1_funct_1(k15_funct_3(E,F))
            & v1_funct_2(k15_funct_3(E,F),k2_zfmisc_1(A,C),k2_zfmisc_1(B,D))
            & m2_relset_1(k15_funct_3(E,F),k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ) ) ) ).

fof(t96_funct_3,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,C,D)
                            & m2_relset_1(F,C,D) )
                         => ! [G] :
                              ( m1_subset_1(G,A)
                             => ! [H] :
                                  ( m1_subset_1(H,C)
                                 => k1_funct_1(k16_funct_3(A,C,B,D,E,F),k4_tarski(G,H)) = k4_tarski(k8_funct_2(A,B,E,G),k8_funct_2(C,D,F,H)) ) ) ) ) ) ) ) ) ).

fof(t97_funct_3,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,B)
        & m2_relset_1(E,A,B) )
     => ! [F] :
          ( ( v1_funct_1(F)
            & v1_funct_2(F,C,D)
            & m2_relset_1(F,C,D) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & ( D = k1_xboole_0
               => C = k1_xboole_0 )
              & k16_funct_3(A,C,B,D,E,F) != k13_funct_3(k5_relat_1(k9_funct_3(A,C),E),k5_relat_1(k10_funct_3(A,C),F)) ) ) ) ).

fof(t98_funct_3,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ~ v1_xboole_0(D)
         => ! [E] :
              ( ( v1_funct_1(E)
                & v1_funct_2(E,A,C)
                & m2_relset_1(E,A,C) )
             => ! [F] :
                  ( ( v1_funct_1(F)
                    & v1_funct_2(F,B,D)
                    & m2_relset_1(F,B,D) )
                 => k16_funct_3(A,B,C,D,E,F) = k13_funct_3(k5_relat_1(k9_funct_3(A,B),E),k5_relat_1(k10_funct_3(A,B),F)) ) ) ) ) ).

fof(t99_funct_3,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,A,C)
            & m2_relset_1(E,A,C) )
         => k13_funct_3(D,E) = k5_relat_1(k12_funct_3(A),k16_funct_3(A,A,B,C,D,E)) ) ) ).

fof(t100_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k2_funct_2(k2_zfmisc_1(k1_relat_1(A),k2_relat_1(A)),k1_relat_1(A),k9_funct_3(k1_relat_1(A),k2_relat_1(A)),A) = k1_relat_1(A) ) ).

fof(s1_funct_3,axiom,
    ( ( ! [A,B,C,D] :
          ( ( r2_hidden(A,f1_s1_funct_3)
            & r2_hidden(B,f2_s1_funct_3)
            & p1_s1_funct_3(A,B,C)
            & p1_s1_funct_3(A,B,D) )
         => C = D )
      & ! [A,B] :
          ~ ( r2_hidden(A,f1_s1_funct_3)
            & r2_hidden(B,f2_s1_funct_3)
            & ! [C] : ~ p1_s1_funct_3(A,B,C) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & k1_relat_1(A) = k2_zfmisc_1(f1_s1_funct_3,f2_s1_funct_3)
        & ! [B,C] :
            ( ( r2_hidden(B,f1_s1_funct_3)
              & r2_hidden(C,f2_s1_funct_3) )
           => p1_s1_funct_3(B,C,k1_funct_1(A,k4_tarski(B,C))) ) ) ) ).

fof(s2_funct_3,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = k2_zfmisc_1(f1_s2_funct_3,f2_s2_funct_3)
      & ! [B,C] :
          ( ( r2_hidden(B,f1_s2_funct_3)
            & r2_hidden(C,f2_s2_funct_3) )
         => k1_funct_1(A,k4_tarski(B,C)) = f3_s2_funct_3(B,C) ) ) ).

fof(dt_k1_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k1_funct_3(A))
        & v1_funct_1(k1_funct_3(A)) ) ) ).

fof(dt_k2_funct_3,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B) )
     => ( v1_funct_1(k2_funct_3(A,B,C))
        & v1_funct_2(k2_funct_3(A,B,C),k1_zfmisc_1(A),k1_zfmisc_1(B))
        & m2_relset_1(k2_funct_3(A,B,C),k1_zfmisc_1(A),k1_zfmisc_1(B)) ) ) ).

fof(redefinition_k2_funct_3,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B) )
     => k2_funct_3(A,B,C) = k1_funct_3(C) ) ).

fof(dt_k3_funct_3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k3_funct_3(A))
        & v1_funct_1(k3_funct_3(A)) ) ) ).

fof(dt_k4_funct_3,axiom,
    ! [A,B] :
      ( v1_relat_1(k4_funct_3(A,B))
      & v1_funct_1(k4_funct_3(A,B)) ) ).

fof(dt_k5_funct_3,axiom,
    ! [A,B] :
      ( v1_funct_1(k5_funct_3(A,B))
      & v1_funct_2(k5_funct_3(A,B),B,k2_tarski(np__0,np__1))
      & m2_relset_1(k5_funct_3(A,B),B,k2_tarski(np__0,np__1)) ) ).

fof(redefinition_k5_funct_3,axiom,
    ! [A,B] : k5_funct_3(A,B) = k4_funct_3(A,B) ).

fof(dt_k6_funct_3,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( v1_funct_1(k6_funct_3(A,B))
        & v1_funct_2(k6_funct_3(A,B),B,A)
        & m2_relset_1(k6_funct_3(A,B),B,A) ) ) ).

fof(redefinition_k6_funct_3,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k6_funct_3(A,B) = k6_relat_1(B) ) ).

fof(dt_k7_funct_3,axiom,
    ! [A,B] :
      ( v1_relat_1(k7_funct_3(A,B))
      & v1_funct_1(k7_funct_3(A,B)) ) ).

fof(dt_k8_funct_3,axiom,
    ! [A,B] :
      ( v1_relat_1(k8_funct_3(A,B))
      & v1_funct_1(k8_funct_3(A,B)) ) ).

fof(dt_k9_funct_3,axiom,
    ! [A,B] :
      ( v1_funct_1(k9_funct_3(A,B))
      & v1_funct_2(k9_funct_3(A,B),k2_zfmisc_1(A,B),A)
      & m2_relset_1(k9_funct_3(A,B),k2_zfmisc_1(A,B),A) ) ).

fof(redefinition_k9_funct_3,axiom,
    ! [A,B] : k9_funct_3(A,B) = k7_funct_3(A,B) ).

fof(dt_k10_funct_3,axiom,
    ! [A,B] :
      ( v1_funct_1(k10_funct_3(A,B))
      & v1_funct_2(k10_funct_3(A,B),k2_zfmisc_1(A,B),B)
      & m2_relset_1(k10_funct_3(A,B),k2_zfmisc_1(A,B),B) ) ).

fof(redefinition_k10_funct_3,axiom,
    ! [A,B] : k10_funct_3(A,B) = k8_funct_3(A,B) ).

fof(dt_k11_funct_3,axiom,
    ! [A] :
      ( v1_relat_1(k11_funct_3(A))
      & v1_funct_1(k11_funct_3(A)) ) ).

fof(dt_k12_funct_3,axiom,
    ! [A] :
      ( v1_funct_1(k12_funct_3(A))
      & v1_funct_2(k12_funct_3(A),A,k2_zfmisc_1(A,A))
      & m2_relset_1(k12_funct_3(A),A,k2_zfmisc_1(A,A)) ) ).

fof(redefinition_k12_funct_3,axiom,
    ! [A] : k12_funct_3(A) = k11_funct_3(A) ).

fof(dt_k13_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k13_funct_3(A,B))
        & v1_funct_1(k13_funct_3(A,B)) ) ) ).

fof(dt_k14_funct_3,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m1_relset_1(D,A,B)
        & v1_funct_1(E)
        & v1_funct_2(E,A,C)
        & m1_relset_1(E,A,C) )
     => ( v1_funct_1(k14_funct_3(A,B,C,D,E))
        & v1_funct_2(k14_funct_3(A,B,C,D,E),A,k2_zfmisc_1(B,C))
        & m2_relset_1(k14_funct_3(A,B,C,D,E),A,k2_zfmisc_1(B,C)) ) ) ).

fof(redefinition_k14_funct_3,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m1_relset_1(D,A,B)
        & v1_funct_1(E)
        & v1_funct_2(E,A,C)
        & m1_relset_1(E,A,C) )
     => k14_funct_3(A,B,C,D,E) = k13_funct_3(D,E) ) ).

fof(dt_k15_funct_3,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k15_funct_3(A,B))
        & v1_funct_1(k15_funct_3(A,B)) ) ) ).

fof(dt_k16_funct_3,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,C)
        & m1_relset_1(E,A,C)
        & v1_funct_1(F)
        & v1_funct_2(F,B,D)
        & m1_relset_1(F,B,D) )
     => ( v1_funct_1(k16_funct_3(A,B,C,D,E,F))
        & v1_funct_2(k16_funct_3(A,B,C,D,E,F),k2_zfmisc_1(A,B),k2_zfmisc_1(C,D))
        & m2_relset_1(k16_funct_3(A,B,C,D,E,F),k2_zfmisc_1(A,B),k2_zfmisc_1(C,D)) ) ) ).

fof(redefinition_k16_funct_3,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,C)
        & m1_relset_1(E,A,C)
        & v1_funct_1(F)
        & v1_funct_2(F,B,D)
        & m1_relset_1(F,B,D) )
     => k16_funct_3(A,B,C,D,E,F) = k15_funct_3(E,F) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_domain_1,axiom,
    $true ).

fof(t2_domain_1,axiom,
    $true ).

fof(t3_domain_1,axiom,
    $true ).

fof(t4_domain_1,axiom,
    $true ).

fof(t5_domain_1,axiom,
    $true ).

fof(t6_domain_1,axiom,
    $true ).

fof(t7_domain_1,axiom,
    $true ).

fof(t8_domain_1,axiom,
    $true ).

fof(t9_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ~ ( r2_hidden(A,k2_zfmisc_1(B,C))
              & ! [D] :
                  ( m1_subset_1(D,B)
                 => ! [E] :
                      ( m1_subset_1(E,C)
                     => A != k4_tarski(D,E) ) ) ) ) ) ).

fof(t10_domain_1,axiom,
    $true ).

fof(t11_domain_1,axiom,
    $true ).

fof(t12_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,k2_zfmisc_1(A,B))
             => ! [D] :
                  ( m1_subset_1(D,k2_zfmisc_1(A,B))
                 => ( ( k1_mcart_1(C) = k1_mcart_1(D)
                      & k2_mcart_1(C) = k2_mcart_1(D) )
                   => C = D ) ) ) ) ) ).

fof(t13_domain_1,axiom,
    $true ).

fof(t14_domain_1,axiom,
    $true ).

fof(t15_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ( r2_hidden(A,k3_zfmisc_1(B,C,D))
              <=> ? [E] :
                    ( m1_subset_1(E,B)
                    & ? [F] :
                        ( m1_subset_1(F,C)
                        & ? [G] :
                            ( m1_subset_1(G,D)
                            & A = k3_mcart_1(E,F,G) ) ) ) ) ) ) ) ).

fof(t16_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ( ! [E] :
                        ( r2_hidden(E,A)
                      <=> ? [F] :
                            ( m1_subset_1(F,B)
                            & ? [G] :
                                ( m1_subset_1(G,C)
                                & ? [H] :
                                    ( m1_subset_1(H,D)
                                    & E = k3_mcart_1(F,G,H) ) ) ) )
                   => A = k3_zfmisc_1(B,C,D) ) ) ) ) ) ).

fof(t17_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ( A = k3_zfmisc_1(B,C,D)
                  <=> ! [E] :
                        ( r2_hidden(E,A)
                      <=> ? [F] :
                            ( m1_subset_1(F,B)
                            & ? [G] :
                                ( m1_subset_1(G,C)
                                & ? [H] :
                                    ( m1_subset_1(H,D)
                                    & E = k3_mcart_1(F,G,H) ) ) ) ) ) ) ) ) ) ).

fof(t18_domain_1,axiom,
    $true ).

fof(t19_domain_1,axiom,
    $true ).

fof(t20_domain_1,axiom,
    $true ).

fof(t21_domain_1,axiom,
    $true ).

fof(t22_domain_1,axiom,
    $true ).

fof(t23_domain_1,axiom,
    $true ).

fof(t24_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( m1_subset_1(E,k3_zfmisc_1(B,C,D))
                 => ( A = k5_mcart_1(B,C,D,E)
                  <=> ! [F] :
                        ( m1_subset_1(F,B)
                       => ! [G] :
                            ( m1_subset_1(G,C)
                           => ! [H] :
                                ( m1_subset_1(H,D)
                               => ( E = k4_domain_1(B,C,D,F,G,H)
                                 => A = F ) ) ) ) ) ) ) ) ) ).

fof(t25_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( m1_subset_1(E,k3_zfmisc_1(B,C,D))
                 => ( A = k6_mcart_1(B,C,D,E)
                  <=> ! [F] :
                        ( m1_subset_1(F,B)
                       => ! [G] :
                            ( m1_subset_1(G,C)
                           => ! [H] :
                                ( m1_subset_1(H,D)
                               => ( E = k4_domain_1(B,C,D,F,G,H)
                                 => A = G ) ) ) ) ) ) ) ) ) ).

fof(t26_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( m1_subset_1(E,k3_zfmisc_1(B,C,D))
                 => ( A = k7_mcart_1(B,C,D,E)
                  <=> ! [F] :
                        ( m1_subset_1(F,B)
                       => ! [G] :
                            ( m1_subset_1(G,C)
                           => ! [H] :
                                ( m1_subset_1(H,D)
                               => ( E = k4_domain_1(B,C,D,F,G,H)
                                 => A = H ) ) ) ) ) ) ) ) ) ).

fof(t27_domain_1,axiom,
    $true ).

fof(t28_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,k3_zfmisc_1(A,B,C))
                 => ! [E] :
                      ( m1_subset_1(E,k3_zfmisc_1(A,B,C))
                     => ( ( k5_mcart_1(A,B,C,D) = k5_mcart_1(A,B,C,E)
                          & k6_mcart_1(A,B,C,D) = k6_mcart_1(A,B,C,E)
                          & k7_mcart_1(A,B,C,D) = k7_mcart_1(A,B,C,E) )
                       => D = E ) ) ) ) ) ) ).

fof(t29_domain_1,axiom,
    $true ).

fof(t30_domain_1,axiom,
    $true ).

fof(t31_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( ~ v1_xboole_0(E)
                 => ( r2_hidden(A,k4_zfmisc_1(B,C,D,E))
                  <=> ? [F] :
                        ( m1_subset_1(F,B)
                        & ? [G] :
                            ( m1_subset_1(G,C)
                            & ? [H] :
                                ( m1_subset_1(H,D)
                                & ? [I] :
                                    ( m1_subset_1(I,E)
                                    & A = k4_mcart_1(F,G,H,I) ) ) ) ) ) ) ) ) ) ).

fof(t32_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( ~ v1_xboole_0(E)
                     => ( ! [F] :
                            ( r2_hidden(F,A)
                          <=> ? [G] :
                                ( m1_subset_1(G,B)
                                & ? [H] :
                                    ( m1_subset_1(H,C)
                                    & ? [I] :
                                        ( m1_subset_1(I,D)
                                        & ? [J] :
                                            ( m1_subset_1(J,E)
                                            & F = k4_mcart_1(G,H,I,J) ) ) ) ) )
                       => A = k4_zfmisc_1(B,C,D,E) ) ) ) ) ) ) ).

fof(t33_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( ~ v1_xboole_0(E)
                     => ( A = k4_zfmisc_1(B,C,D,E)
                      <=> ! [F] :
                            ( r2_hidden(F,A)
                          <=> ? [G] :
                                ( m1_subset_1(G,B)
                                & ? [H] :
                                    ( m1_subset_1(H,C)
                                    & ? [I] :
                                        ( m1_subset_1(I,D)
                                        & ? [J] :
                                            ( m1_subset_1(J,E)
                                            & F = k4_mcart_1(G,H,I,J) ) ) ) ) ) ) ) ) ) ) ) ).

fof(t34_domain_1,axiom,
    $true ).

fof(t35_domain_1,axiom,
    $true ).

fof(t36_domain_1,axiom,
    $true ).

fof(t37_domain_1,axiom,
    $true ).

fof(t38_domain_1,axiom,
    $true ).

fof(t39_domain_1,axiom,
    $true ).

fof(t40_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( ~ v1_xboole_0(E)
                 => ! [F] :
                      ( m1_subset_1(F,k4_zfmisc_1(B,C,D,E))
                     => ( A = k8_mcart_1(B,C,D,E,F)
                      <=> ! [G] :
                            ( m1_subset_1(G,B)
                           => ! [H] :
                                ( m1_subset_1(H,C)
                               => ! [I] :
                                    ( m1_subset_1(I,D)
                                   => ! [J] :
                                        ( m1_subset_1(J,E)
                                       => ( F = k5_domain_1(B,C,D,E,G,H,I,J)
                                         => A = G ) ) ) ) ) ) ) ) ) ) ) ).

fof(t41_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( ~ v1_xboole_0(E)
                 => ! [F] :
                      ( m1_subset_1(F,k4_zfmisc_1(B,C,D,E))
                     => ( A = k9_mcart_1(B,C,D,E,F)
                      <=> ! [G] :
                            ( m1_subset_1(G,B)
                           => ! [H] :
                                ( m1_subset_1(H,C)
                               => ! [I] :
                                    ( m1_subset_1(I,D)
                                   => ! [J] :
                                        ( m1_subset_1(J,E)
                                       => ( F = k5_domain_1(B,C,D,E,G,H,I,J)
                                         => A = H ) ) ) ) ) ) ) ) ) ) ) ).

fof(t42_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( ~ v1_xboole_0(E)
                 => ! [F] :
                      ( m1_subset_1(F,k4_zfmisc_1(B,C,D,E))
                     => ( A = k10_mcart_1(B,C,D,E,F)
                      <=> ! [G] :
                            ( m1_subset_1(G,B)
                           => ! [H] :
                                ( m1_subset_1(H,C)
                               => ! [I] :
                                    ( m1_subset_1(I,D)
                                   => ! [J] :
                                        ( m1_subset_1(J,E)
                                       => ( F = k5_domain_1(B,C,D,E,G,H,I,J)
                                         => A = I ) ) ) ) ) ) ) ) ) ) ) ).

fof(t43_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( ~ v1_xboole_0(D)
             => ! [E] :
                  ( ~ v1_xboole_0(E)
                 => ! [F] :
                      ( m1_subset_1(F,k4_zfmisc_1(B,C,D,E))
                     => ( A = k11_mcart_1(B,C,D,E,F)
                      <=> ! [G] :
                            ( m1_subset_1(G,B)
                           => ! [H] :
                                ( m1_subset_1(H,C)
                               => ! [I] :
                                    ( m1_subset_1(I,D)
                                   => ! [J] :
                                        ( m1_subset_1(J,E)
                                       => ( F = k5_domain_1(B,C,D,E,G,H,I,J)
                                         => A = J ) ) ) ) ) ) ) ) ) ) ) ).

fof(t44_domain_1,axiom,
    $true ).

fof(t45_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( m1_subset_1(E,k4_zfmisc_1(A,B,C,D))
                     => ! [F] :
                          ( m1_subset_1(F,k4_zfmisc_1(A,B,C,D))
                         => ( ( k8_mcart_1(A,B,C,D,E) = k8_mcart_1(A,B,C,D,F)
                              & k9_mcart_1(A,B,C,D,E) = k9_mcart_1(A,B,C,D,F)
                              & k10_mcart_1(A,B,C,D,E) = k10_mcart_1(A,B,C,D,F)
                              & k11_mcart_1(A,B,C,D,E) = k11_mcart_1(A,B,C,D,F) )
                           => E = F ) ) ) ) ) ) ) ).

fof(t46_domain_1,axiom,
    $true ).

fof(t47_domain_1,axiom,
    $true ).

fof(dt_k1_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(C,A)
        & m1_subset_1(D,B) )
     => m1_subset_1(k1_domain_1(A,B,C,D),k2_zfmisc_1(A,B)) ) ).

fof(redefinition_k1_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(C,A)
        & m1_subset_1(D,B) )
     => k1_domain_1(A,B,C,D) = k4_tarski(C,D) ) ).

fof(dt_k2_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(C,k2_zfmisc_1(A,B)) )
     => m1_subset_1(k2_domain_1(A,B,C),A) ) ).

fof(redefinition_k2_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(C,k2_zfmisc_1(A,B)) )
     => k2_domain_1(A,B,C) = k1_mcart_1(C) ) ).

fof(dt_k3_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(C,k2_zfmisc_1(A,B)) )
     => m1_subset_1(k3_domain_1(A,B,C),B) ) ).

fof(redefinition_k3_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(C,k2_zfmisc_1(A,B)) )
     => k3_domain_1(A,B,C) = k2_mcart_1(C) ) ).

fof(dt_k4_domain_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,A)
        & m1_subset_1(E,B)
        & m1_subset_1(F,C) )
     => m1_subset_1(k4_domain_1(A,B,C,D,E,F),k3_zfmisc_1(A,B,C)) ) ).

fof(redefinition_k4_domain_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,A)
        & m1_subset_1(E,B)
        & m1_subset_1(F,C) )
     => k4_domain_1(A,B,C,D,E,F) = k3_mcart_1(D,E,F) ) ).

fof(dt_k5_domain_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D)
        & m1_subset_1(E,A)
        & m1_subset_1(F,B)
        & m1_subset_1(G,C)
        & m1_subset_1(H,D) )
     => m1_subset_1(k5_domain_1(A,B,C,D,E,F,G,H),k4_zfmisc_1(A,B,C,D)) ) ).

fof(redefinition_k5_domain_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D)
        & m1_subset_1(E,A)
        & m1_subset_1(F,B)
        & m1_subset_1(G,C)
        & m1_subset_1(H,D) )
     => k5_domain_1(A,B,C,D,E,F,G,H) = k4_mcart_1(E,F,G,H) ) ).

fof(dt_k6_domain_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A) )
     => m1_subset_1(k6_domain_1(A,B),k1_zfmisc_1(A)) ) ).

fof(redefinition_k6_domain_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A) )
     => k6_domain_1(A,B) = k1_tarski(B) ) ).

fof(dt_k7_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => m1_subset_1(k7_domain_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(commutativity_k7_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k7_domain_1(A,B,C) = k7_domain_1(A,C,B) ) ).

fof(redefinition_k7_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k7_domain_1(A,B,C) = k2_tarski(B,C) ) ).

fof(dt_k8_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A) )
     => m1_subset_1(k8_domain_1(A,B,C,D),k1_zfmisc_1(A)) ) ).

fof(redefinition_k8_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A) )
     => k8_domain_1(A,B,C,D) = k1_enumset1(B,C,D) ) ).

fof(dt_k9_domain_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A) )
     => m1_subset_1(k9_domain_1(A,B,C,D,E),k1_zfmisc_1(A)) ) ).

fof(redefinition_k9_domain_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A) )
     => k9_domain_1(A,B,C,D,E) = k2_enumset1(B,C,D,E) ) ).

fof(dt_k10_domain_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A) )
     => m1_subset_1(k10_domain_1(A,B,C,D,E,F),k1_zfmisc_1(A)) ) ).

fof(redefinition_k10_domain_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A) )
     => k10_domain_1(A,B,C,D,E,F) = k3_enumset1(B,C,D,E,F) ) ).

fof(dt_k11_domain_1,axiom,
    ! [A,B,C,D,E,F,G] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A)
        & m1_subset_1(G,A) )
     => m1_subset_1(k11_domain_1(A,B,C,D,E,F,G),k1_zfmisc_1(A)) ) ).

fof(redefinition_k11_domain_1,axiom,
    ! [A,B,C,D,E,F,G] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A)
        & m1_subset_1(G,A) )
     => k11_domain_1(A,B,C,D,E,F,G) = k4_enumset1(B,C,D,E,F,G) ) ).

fof(dt_k12_domain_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A)
        & m1_subset_1(G,A)
        & m1_subset_1(H,A) )
     => m1_subset_1(k12_domain_1(A,B,C,D,E,F,G,H),k1_zfmisc_1(A)) ) ).

fof(redefinition_k12_domain_1,axiom,
    ! [A,B,C,D,E,F,G,H] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A)
        & m1_subset_1(G,A)
        & m1_subset_1(H,A) )
     => k12_domain_1(A,B,C,D,E,F,G,H) = k5_enumset1(B,C,D,E,F,G,H) ) ).

fof(dt_k13_domain_1,axiom,
    ! [A,B,C,D,E,F,G,H,I] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A)
        & m1_subset_1(G,A)
        & m1_subset_1(H,A)
        & m1_subset_1(I,A) )
     => m1_subset_1(k13_domain_1(A,B,C,D,E,F,G,H,I),k1_zfmisc_1(A)) ) ).

fof(redefinition_k13_domain_1,axiom,
    ! [A,B,C,D,E,F,G,H,I] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A)
        & m1_subset_1(F,A)
        & m1_subset_1(G,A)
        & m1_subset_1(H,A)
        & m1_subset_1(I,A) )
     => k13_domain_1(A,B,C,D,E,F,G,H,I) = k6_enumset1(B,C,D,E,F,G,H,I) ) ).

fof(dt_k14_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(k2_zfmisc_1(A,B),C)) )
     => m1_subset_1(k14_domain_1(A,B,C,D),A) ) ).

fof(redefinition_k14_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(k2_zfmisc_1(A,B),C)) )
     => k14_domain_1(A,B,C,D) = k17_mcart_1(D) ) ).

fof(dt_k15_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(k2_zfmisc_1(A,B),C)) )
     => m1_subset_1(k15_domain_1(A,B,C,D),B) ) ).

fof(redefinition_k15_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(k2_zfmisc_1(A,B),C)) )
     => k15_domain_1(A,B,C,D) = k18_mcart_1(D) ) ).

fof(dt_k16_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(A,k2_zfmisc_1(B,C))) )
     => m1_subset_1(k16_domain_1(A,B,C,D),B) ) ).

fof(redefinition_k16_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(A,k2_zfmisc_1(B,C))) )
     => k16_domain_1(A,B,C,D) = k19_mcart_1(D) ) ).

fof(dt_k17_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(A,k2_zfmisc_1(B,C))) )
     => m1_subset_1(k17_domain_1(A,B,C,D),C) ) ).

fof(redefinition_k17_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k2_zfmisc_1(A,k2_zfmisc_1(B,C))) )
     => k17_domain_1(A,B,C,D) = k20_mcart_1(D) ) ).

fof(t48_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => A = a_1_0_domain_1(A) ) ).

fof(t49_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => k2_zfmisc_1(A,B) = a_2_0_domain_1(A,B) ) ) ).

fof(t50_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => k3_zfmisc_1(A,B,C) = a_3_0_domain_1(A,B,C) ) ) ) ).

fof(t51_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => k4_zfmisc_1(A,B,C,D) = a_4_0_domain_1(A,B,C,D) ) ) ) ) ).

fof(t52_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => B = a_2_1_domain_1(A,B) ) ) ).

fof(t53_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(B))
                 => k12_mcart_1(A,B,C,D) = a_4_1_domain_1(A,B,C,D) ) ) ) ) ).

fof(t54_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(A))
                 => ! [E] :
                      ( m1_subset_1(E,k1_zfmisc_1(B))
                     => ! [F] :
                          ( m1_subset_1(F,k1_zfmisc_1(C))
                         => k13_mcart_1(A,B,C,D,E,F) = a_6_0_domain_1(A,B,C,D,E,F) ) ) ) ) ) ) ).

fof(t55_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( m1_subset_1(E,k1_zfmisc_1(A))
                     => ! [F] :
                          ( m1_subset_1(F,k1_zfmisc_1(B))
                         => ! [G] :
                              ( m1_subset_1(G,k1_zfmisc_1(C))
                             => ! [H] :
                                  ( m1_subset_1(H,k1_zfmisc_1(D))
                                 => k14_mcart_1(A,B,C,D,E,F,G,H) = a_8_0_domain_1(A,B,C,D,E,F,G,H) ) ) ) ) ) ) ) ) ).

fof(t56_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => k1_subset_1(A) = a_1_1_domain_1(A) ) ).

fof(t57_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => k3_subset_1(A,B) = a_2_2_domain_1(A,B) ) ) ).

fof(t58_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => k5_subset_1(A,B,C) = a_3_1_domain_1(A,B,C) ) ) ) ).

fof(t59_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => k4_subset_1(A,B,C) = a_3_2_domain_1(A,B,C) ) ) ) ).

fof(t60_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => k6_subset_1(A,B,C) = a_3_3_domain_1(A,B,C) ) ) ) ).

fof(t61_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => k7_subset_1(A,B,C) = a_3_4_domain_1(A,B,C) ) ) ) ).

fof(t62_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => k7_subset_1(A,B,C) = a_3_5_domain_1(A,B,C) ) ) ) ).

fof(t63_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => k7_subset_1(A,B,C) = a_3_6_domain_1(A,B,C) ) ) ) ).

fof(t64_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => k7_subset_1(A,B,C) = a_3_7_domain_1(A,B,C) ) ) ) ).

fof(s1_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => m1_subset_1(a_1_2_domain_1(A),k1_zfmisc_1(A)) ) ).

fof(s2_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => m1_subset_1(a_2_3_domain_1(A,B),k1_zfmisc_1(k2_zfmisc_1(A,B))) ) ) ).

fof(s3_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => m1_subset_1(a_3_8_domain_1(A,B,C),k1_zfmisc_1(k3_zfmisc_1(A,B,C))) ) ) ) ).

fof(s4_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => m1_subset_1(a_4_2_domain_1(A,B,C,D),k1_zfmisc_1(k4_zfmisc_1(A,B,C,D))) ) ) ) ) ).

fof(s5_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ! [B] :
            ( m1_subset_1(B,A)
           => ( p1_s5_domain_1(B)
             => p2_s5_domain_1(B) ) )
       => r1_tarski(a_1_3_domain_1(A),a_1_4_domain_1(A)) ) ) ).

fof(s6_domain_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ! [B] :
            ( m1_subset_1(B,A)
           => ( p1_s6_domain_1(B)
            <=> p2_s6_domain_1(B) ) )
       => a_1_5_domain_1(A) = a_1_6_domain_1(A) ) ) ).

fof(s7_domain_1,axiom,
    m1_subset_1(a_0_0_domain_1,k1_zfmisc_1(f1_s7_domain_1)) ).

fof(s8_domain_1,axiom,
    m1_subset_1(a_0_1_domain_1,k1_zfmisc_1(f2_s8_domain_1)) ).

fof(s9_domain_1,axiom,
    m1_subset_1(a_0_2_domain_1,k1_zfmisc_1(f3_s9_domain_1)) ).

fof(s10_domain_1,axiom,
    a_0_3_domain_1 = k3_xboole_0(a_0_4_domain_1,a_0_5_domain_1) ).

fof(fraenkel_a_1_0_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_0_domain_1(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = C ) ) ) ).

fof(fraenkel_a_2_0_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C) )
     => ( r2_hidden(A,a_2_0_domain_1(B,C))
      <=> ? [D,E] :
            ( m1_subset_1(D,B)
            & m1_subset_1(E,C)
            & A = k1_domain_1(B,C,D,E) ) ) ) ).

fof(fraenkel_a_3_0_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D) )
     => ( r2_hidden(A,a_3_0_domain_1(B,C,D))
      <=> ? [E,F,G] :
            ( m1_subset_1(E,B)
            & m1_subset_1(F,C)
            & m1_subset_1(G,D)
            & A = k4_domain_1(B,C,D,E,F,G) ) ) ) ).

fof(fraenkel_a_4_0_domain_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D)
        & ~ v1_xboole_0(E) )
     => ( r2_hidden(A,a_4_0_domain_1(B,C,D,E))
      <=> ? [F,G,H,I] :
            ( m1_subset_1(F,B)
            & m1_subset_1(G,C)
            & m1_subset_1(H,D)
            & m1_subset_1(I,E)
            & A = k5_domain_1(B,C,D,E,F,G,H,I) ) ) ) ).

fof(fraenkel_a_2_1_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_2_1_domain_1(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,B)
            & A = D
            & r2_hidden(D,C) ) ) ) ).

fof(fraenkel_a_4_1_domain_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(D,k1_zfmisc_1(B))
        & m1_subset_1(E,k1_zfmisc_1(C)) )
     => ( r2_hidden(A,a_4_1_domain_1(B,C,D,E))
      <=> ? [F,G] :
            ( m1_subset_1(F,B)
            & m1_subset_1(G,C)
            & A = k1_domain_1(B,C,F,G)
            & r2_hidden(F,D)
            & r2_hidden(G,E) ) ) ) ).

fof(fraenkel_a_6_0_domain_1,axiom,
    ! [A,B,C,D,E,F,G] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D)
        & m1_subset_1(E,k1_zfmisc_1(B))
        & m1_subset_1(F,k1_zfmisc_1(C))
        & m1_subset_1(G,k1_zfmisc_1(D)) )
     => ( r2_hidden(A,a_6_0_domain_1(B,C,D,E,F,G))
      <=> ? [H,I,J] :
            ( m1_subset_1(H,B)
            & m1_subset_1(I,C)
            & m1_subset_1(J,D)
            & A = k4_domain_1(B,C,D,H,I,J)
            & r2_hidden(H,E)
            & r2_hidden(I,F)
            & r2_hidden(J,G) ) ) ) ).

fof(fraenkel_a_8_0_domain_1,axiom,
    ! [A,B,C,D,E,F,G,H,I] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D)
        & ~ v1_xboole_0(E)
        & m1_subset_1(F,k1_zfmisc_1(B))
        & m1_subset_1(G,k1_zfmisc_1(C))
        & m1_subset_1(H,k1_zfmisc_1(D))
        & m1_subset_1(I,k1_zfmisc_1(E)) )
     => ( r2_hidden(A,a_8_0_domain_1(B,C,D,E,F,G,H,I))
      <=> ? [J,K,L,M] :
            ( m1_subset_1(J,B)
            & m1_subset_1(K,C)
            & m1_subset_1(L,D)
            & m1_subset_1(M,E)
            & A = k5_domain_1(B,C,D,E,J,K,L,M)
            & r2_hidden(J,F)
            & r2_hidden(K,G)
            & r2_hidden(L,H)
            & r2_hidden(M,I) ) ) ) ).

fof(fraenkel_a_1_1_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_1_domain_1(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = C
            & ~ $true ) ) ) ).

fof(fraenkel_a_2_2_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_2_2_domain_1(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,B)
            & A = D
            & ~ r2_hidden(D,C) ) ) ) ).

fof(fraenkel_a_3_1_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_3_1_domain_1(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,B)
            & A = E
            & r2_hidden(E,C)
            & r2_hidden(E,D) ) ) ) ).

fof(fraenkel_a_3_2_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_3_2_domain_1(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,B)
            & A = E
            & ( r2_hidden(E,C)
              | r2_hidden(E,D) ) ) ) ) ).

fof(fraenkel_a_3_3_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_3_3_domain_1(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,B)
            & A = E
            & r2_hidden(E,C)
            & ~ r2_hidden(E,D) ) ) ) ).

fof(fraenkel_a_3_4_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_3_4_domain_1(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,B)
            & A = E
            & ( ( r2_hidden(E,C)
                & ~ r2_hidden(E,D) )
              | ( ~ r2_hidden(E,C)
                & r2_hidden(E,D) ) ) ) ) ) ).

fof(fraenkel_a_3_5_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_3_5_domain_1(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,B)
            & A = E
            & ( ~ r2_hidden(E,C)
            <=> r2_hidden(E,D) ) ) ) ) ).

fof(fraenkel_a_3_6_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_3_6_domain_1(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,B)
            & A = E
            & ( r2_hidden(E,C)
            <=> ~ r2_hidden(E,D) ) ) ) ) ).

fof(fraenkel_a_3_7_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(C,k1_zfmisc_1(B))
        & m1_subset_1(D,k1_zfmisc_1(B)) )
     => ( r2_hidden(A,a_3_7_domain_1(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,B)
            & A = E
            & ~ ( r2_hidden(E,C)
              <=> r2_hidden(E,D) ) ) ) ) ).

fof(fraenkel_a_1_2_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_2_domain_1(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = C
            & p1_s1_domain_1(C) ) ) ) ).

fof(fraenkel_a_2_3_domain_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C) )
     => ( r2_hidden(A,a_2_3_domain_1(B,C))
      <=> ? [D,E] :
            ( m1_subset_1(D,B)
            & m1_subset_1(E,C)
            & A = k1_domain_1(B,C,D,E)
            & p1_s2_domain_1(D,E) ) ) ) ).

fof(fraenkel_a_3_8_domain_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D) )
     => ( r2_hidden(A,a_3_8_domain_1(B,C,D))
      <=> ? [E,F,G] :
            ( m1_subset_1(E,B)
            & m1_subset_1(F,C)
            & m1_subset_1(G,D)
            & A = k4_domain_1(B,C,D,E,F,G)
            & p1_s3_domain_1(E,F,G) ) ) ) ).

fof(fraenkel_a_4_2_domain_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D)
        & ~ v1_xboole_0(E) )
     => ( r2_hidden(A,a_4_2_domain_1(B,C,D,E))
      <=> ? [F,G,H,I] :
            ( m1_subset_1(F,B)
            & m1_subset_1(G,C)
            & m1_subset_1(H,D)
            & m1_subset_1(I,E)
            & A = k5_domain_1(B,C,D,E,F,G,H,I)
            & p1_s4_domain_1(F,G,H,I) ) ) ) ).

fof(fraenkel_a_1_3_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_3_domain_1(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = C
            & p1_s5_domain_1(C) ) ) ) ).

fof(fraenkel_a_1_4_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_4_domain_1(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = C
            & p2_s5_domain_1(C) ) ) ) ).

fof(fraenkel_a_1_5_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_5_domain_1(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = C
            & p1_s6_domain_1(C) ) ) ) ).

fof(fraenkel_a_1_6_domain_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_6_domain_1(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = C
            & p2_s6_domain_1(C) ) ) ) ).

fof(fraenkel_a_0_0_domain_1,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_domain_1)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s7_domain_1)
          & A = B
          & p1_s7_domain_1(B) ) ) ).

fof(fraenkel_a_0_1_domain_1,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_1_domain_1)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s8_domain_1)
          & A = f3_s8_domain_1(B)
          & p1_s8_domain_1(B) ) ) ).

fof(fraenkel_a_0_2_domain_1,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_2_domain_1)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s9_domain_1)
          & m1_subset_1(C,f2_s9_domain_1)
          & A = f4_s9_domain_1(B,C)
          & p1_s9_domain_1(B,C) ) ) ).

fof(fraenkel_a_0_3_domain_1,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_3_domain_1)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s10_domain_1)
          & A = B
          & p1_s10_domain_1(B)
          & p2_s10_domain_1(B) ) ) ).

fof(fraenkel_a_0_4_domain_1,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_4_domain_1)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s10_domain_1)
          & A = B
          & p1_s10_domain_1(B) ) ) ).

fof(fraenkel_a_0_5_domain_1,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_5_domain_1)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s10_domain_1)
          & A = B
          & p2_s10_domain_1(B) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_binop_1,axiom,
    ! [A] :
      ( m1_relset_1(A,k2_zfmisc_1(k1_xboole_0,k1_xboole_0),k1_xboole_0)
     => ( ( v1_funct_1(A)
          & v1_funct_2(A,k2_zfmisc_1(k1_xboole_0,k1_xboole_0),k1_xboole_0) )
       => ( v1_funct_1(A)
          & v1_xboole_0(A)
          & v1_funct_2(A,k2_zfmisc_1(k1_xboole_0,k1_xboole_0),k1_xboole_0)
          & v1_binop_1(A,k1_xboole_0)
          & v2_binop_1(A,k1_xboole_0) ) ) ) ).

fof(d1_binop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] : k1_binop_1(A,B,C) = k1_funct_1(A,k4_tarski(B,C)) ) ).

fof(t1_binop_1,axiom,
    $true ).

fof(t2_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,B),C)
                    & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,B),C)
                        & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
                     => ( ! [F] :
                            ( m1_subset_1(F,A)
                           => ! [G] :
                                ( m1_subset_1(G,B)
                               => k2_binop_1(A,B,C,D,F,G) = k2_binop_1(A,B,C,E,F,G) ) )
                       => D = E ) ) ) ) ) ) ).

fof(d2_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( v1_binop_1(B,A)
      <=> ! [C] :
            ( m1_subset_1(C,A)
           => ! [D] :
                ( m1_subset_1(D,A)
               => k1_binop_1(B,C,D) = k1_binop_1(B,D,C) ) ) ) ) ).

fof(d3_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( v2_binop_1(B,A)
      <=> ! [C] :
            ( m1_subset_1(C,A)
           => ! [D] :
                ( m1_subset_1(D,A)
               => ! [E] :
                    ( m1_subset_1(E,A)
                   => k1_binop_1(B,C,k1_binop_1(B,D,E)) = k1_binop_1(B,k1_binop_1(B,C,D),E) ) ) ) ) ) ).

fof(d4_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( v3_binop_1(B,A)
      <=> ! [C] :
            ( m1_subset_1(C,A)
           => k1_binop_1(B,C,C) = C ) ) ) ).

fof(d5_binop_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r1_binop_1(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,A)
               => k1_binop_1(C,B,D) = D ) ) ) ) ).

fof(d6_binop_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r2_binop_1(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,A)
               => k1_binop_1(C,D,B) = D ) ) ) ) ).

fof(d7_binop_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r3_binop_1(A,B,C)
          <=> ( r1_binop_1(A,B,C)
              & r2_binop_1(A,B,C) ) ) ) ) ).

fof(t3_binop_1,axiom,
    $true ).

fof(t4_binop_1,axiom,
    $true ).

fof(t5_binop_1,axiom,
    $true ).

fof(t6_binop_1,axiom,
    $true ).

fof(t7_binop_1,axiom,
    $true ).

fof(t8_binop_1,axiom,
    $true ).

fof(t9_binop_1,axiom,
    $true ).

fof(t10_binop_1,axiom,
    $true ).

fof(t11_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( r3_binop_1(A,C,B)
          <=> ! [D] :
                ( m1_subset_1(D,A)
               => ( k1_binop_1(B,C,D) = D
                  & k1_binop_1(B,D,C) = D ) ) ) ) ) ).

fof(t12_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( v1_binop_1(B,A)
           => ( r3_binop_1(A,C,B)
            <=> ! [D] :
                  ( m1_subset_1(D,A)
                 => k1_binop_1(B,C,D) = D ) ) ) ) ) ).

fof(t13_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( v1_binop_1(B,A)
           => ( r3_binop_1(A,C,B)
            <=> ! [D] :
                  ( m1_subset_1(D,A)
                 => k1_binop_1(B,D,C) = D ) ) ) ) ) ).

fof(t14_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( v1_binop_1(B,A)
           => ( r3_binop_1(A,C,B)
            <=> r1_binop_1(A,C,B) ) ) ) ) ).

fof(t15_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( v1_binop_1(B,A)
           => ( r3_binop_1(A,C,B)
            <=> r2_binop_1(A,C,B) ) ) ) ) ).

fof(t16_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( v1_binop_1(B,A)
           => ( r1_binop_1(A,C,B)
            <=> r2_binop_1(A,C,B) ) ) ) ) ).

fof(t17_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ( ( r1_binop_1(A,C,B)
                  & r2_binop_1(A,D,B) )
               => C = D ) ) ) ) ).

fof(t18_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ( ( r3_binop_1(A,C,B)
                  & r3_binop_1(A,D,B) )
               => C = D ) ) ) ) ).

fof(d8_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( ? [C] :
            ( m1_subset_1(C,A)
            & r3_binop_1(A,C,B) )
       => ! [C] :
            ( m1_subset_1(C,A)
           => ( C = k3_binop_1(A,B)
            <=> r3_binop_1(A,C,B) ) ) ) ) ).

fof(d9_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r4_binop_1(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,A)
               => ! [E] :
                    ( m1_subset_1(E,A)
                   => ! [F] :
                        ( m1_subset_1(F,A)
                       => k1_binop_1(B,D,k1_binop_1(C,E,F)) = k1_binop_1(C,k1_binop_1(B,D,E),k1_binop_1(B,D,F)) ) ) ) ) ) ) ).

fof(d10_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r5_binop_1(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,A)
               => ! [E] :
                    ( m1_subset_1(E,A)
                   => ! [F] :
                        ( m1_subset_1(F,A)
                       => k1_binop_1(B,k1_binop_1(C,D,E),F) = k1_binop_1(C,k1_binop_1(B,D,F),k1_binop_1(B,E,F)) ) ) ) ) ) ) ).

fof(d11_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r6_binop_1(A,B,C)
          <=> ( r4_binop_1(A,B,C)
              & r5_binop_1(A,B,C) ) ) ) ) ).

fof(t19_binop_1,axiom,
    $true ).

fof(t20_binop_1,axiom,
    $true ).

fof(t21_binop_1,axiom,
    $true ).

fof(t22_binop_1,axiom,
    $true ).

fof(t23_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r6_binop_1(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,A)
               => ! [E] :
                    ( m1_subset_1(E,A)
                   => ! [F] :
                        ( m1_subset_1(F,A)
                       => ( k1_binop_1(B,D,k1_binop_1(C,E,F)) = k1_binop_1(C,k1_binop_1(B,D,E),k1_binop_1(B,D,F))
                          & k1_binop_1(B,k1_binop_1(C,D,E),F) = k1_binop_1(C,k1_binop_1(B,D,F),k1_binop_1(B,E,F)) ) ) ) ) ) ) ) ).

fof(t24_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( v1_binop_1(C,A)
               => ( r6_binop_1(A,C,B)
                <=> ! [D] :
                      ( m1_subset_1(D,A)
                     => ! [E] :
                          ( m1_subset_1(E,A)
                         => ! [F] :
                              ( m1_subset_1(F,A)
                             => k2_binop_1(A,A,A,C,D,k2_binop_1(A,A,A,B,E,F)) = k2_binop_1(A,A,A,B,k2_binop_1(A,A,A,C,D,E),k2_binop_1(A,A,A,C,D,F)) ) ) ) ) ) ) ) ) ).

fof(t25_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( v1_binop_1(C,A)
               => ( r6_binop_1(A,C,B)
                <=> ! [D] :
                      ( m1_subset_1(D,A)
                     => ! [E] :
                          ( m1_subset_1(E,A)
                         => ! [F] :
                              ( m1_subset_1(F,A)
                             => k2_binop_1(A,A,A,C,k2_binop_1(A,A,A,B,D,E),F) = k2_binop_1(A,A,A,B,k2_binop_1(A,A,A,C,D,F),k2_binop_1(A,A,A,C,E,F)) ) ) ) ) ) ) ) ) ).

fof(t26_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( v1_binop_1(C,A)
               => ( r6_binop_1(A,C,B)
                <=> r4_binop_1(A,C,B) ) ) ) ) ) ).

fof(t27_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( v1_binop_1(C,A)
               => ( r6_binop_1(A,C,B)
                <=> r5_binop_1(A,C,B) ) ) ) ) ) ).

fof(t28_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( v1_binop_1(C,A)
               => ( r5_binop_1(A,C,B)
                <=> r4_binop_1(A,C,B) ) ) ) ) ) ).

fof(d12_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
         => ( r7_binop_1(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,A)
               => ! [E] :
                    ( m1_subset_1(E,A)
                   => k1_funct_1(B,k1_binop_1(C,D,E)) = k1_binop_1(C,k1_funct_1(B,D),k1_funct_1(B,E)) ) ) ) ) ) ).

fof(d13_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ( v1_binop_1(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,A)
               => ! [D] :
                    ( m1_subset_1(D,A)
                   => k2_binop_1(A,A,A,B,C,D) = k2_binop_1(A,A,A,B,D,C) ) ) ) ) ) ).

fof(d14_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ( v2_binop_1(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,A)
               => ! [D] :
                    ( m1_subset_1(D,A)
                   => ! [E] :
                        ( m1_subset_1(E,A)
                       => k2_binop_1(A,A,A,B,C,k2_binop_1(A,A,A,B,D,E)) = k2_binop_1(A,A,A,B,k2_binop_1(A,A,A,B,C,D),E) ) ) ) ) ) ) ).

fof(d15_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ( v3_binop_1(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,A)
               => k2_binop_1(A,A,A,B,C,C) = C ) ) ) ) ).

fof(d16_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( r1_binop_1(A,B,C)
              <=> ! [D] :
                    ( m1_subset_1(D,A)
                   => k2_binop_1(A,A,A,C,B,D) = D ) ) ) ) ) ).

fof(d17_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( r2_binop_1(A,B,C)
              <=> ! [D] :
                    ( m1_subset_1(D,A)
                   => k2_binop_1(A,A,A,C,D,B) = D ) ) ) ) ) ).

fof(d18_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( r4_binop_1(A,B,C)
              <=> ! [D] :
                    ( m1_subset_1(D,A)
                   => ! [E] :
                        ( m1_subset_1(E,A)
                       => ! [F] :
                            ( m1_subset_1(F,A)
                           => k2_binop_1(A,A,A,B,D,k2_binop_1(A,A,A,C,E,F)) = k2_binop_1(A,A,A,C,k2_binop_1(A,A,A,B,D,E),k2_binop_1(A,A,A,B,D,F)) ) ) ) ) ) ) ) ).

fof(d19_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( r5_binop_1(A,B,C)
              <=> ! [D] :
                    ( m1_subset_1(D,A)
                   => ! [E] :
                        ( m1_subset_1(E,A)
                       => ! [F] :
                            ( m1_subset_1(F,A)
                           => k2_binop_1(A,A,A,B,k2_binop_1(A,A,A,C,D,E),F) = k2_binop_1(A,A,A,C,k2_binop_1(A,A,A,B,D,F),k2_binop_1(A,A,A,B,E,F)) ) ) ) ) ) ) ) ).

fof(d20_binop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( r7_binop_1(A,B,C)
              <=> ! [D] :
                    ( m1_subset_1(D,A)
                   => ! [E] :
                        ( m1_subset_1(E,A)
                       => k8_funct_2(A,A,B,k2_binop_1(A,A,A,C,D,E)) = k2_binop_1(A,A,A,C,k8_funct_2(A,A,B,D),k8_funct_2(A,A,B,E)) ) ) ) ) ) ) ).

fof(s1_binop_1,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s1_binop_1)
       => ! [B] :
            ( m1_subset_1(B,f1_s1_binop_1)
           => ? [C] :
                ( m1_subset_1(C,f1_s1_binop_1)
                & p1_s1_binop_1(A,B,C) ) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s1_binop_1,f1_s1_binop_1),f1_s1_binop_1)
        & m2_relset_1(A,k2_zfmisc_1(f1_s1_binop_1,f1_s1_binop_1),f1_s1_binop_1)
        & ! [B] :
            ( m1_subset_1(B,f1_s1_binop_1)
           => ! [C] :
                ( m1_subset_1(C,f1_s1_binop_1)
               => p1_s1_binop_1(B,C,k2_binop_1(f1_s1_binop_1,f1_s1_binop_1,f1_s1_binop_1,A,B,C)) ) ) ) ) ).

fof(s2_binop_1,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,k2_zfmisc_1(f1_s2_binop_1,f1_s2_binop_1),f1_s2_binop_1)
      & m2_relset_1(A,k2_zfmisc_1(f1_s2_binop_1,f1_s2_binop_1),f1_s2_binop_1)
      & ! [B] :
          ( m1_subset_1(B,f1_s2_binop_1)
         => ! [C] :
              ( m1_subset_1(C,f1_s2_binop_1)
             => k2_binop_1(f1_s2_binop_1,f1_s2_binop_1,f1_s2_binop_1,A,B,C) = f2_s2_binop_1(B,C) ) ) ) ).

fof(dt_k1_binop_1,axiom,
    $true ).

fof(dt_k2_binop_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m1_relset_1(D,k2_zfmisc_1(A,B),C)
        & m1_subset_1(E,A)
        & m1_subset_1(F,B) )
     => m1_subset_1(k2_binop_1(A,B,C,D,E,F),C) ) ).

fof(redefinition_k2_binop_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m1_relset_1(D,k2_zfmisc_1(A,B),C)
        & m1_subset_1(E,A)
        & m1_subset_1(F,B) )
     => k2_binop_1(A,B,C,D,E,F) = k1_binop_1(D,E,F) ) ).

fof(dt_k3_binop_1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A) )
     => m1_subset_1(k3_binop_1(A,B),A) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_funcop_1,axiom,
    ! [A,B] :
      ( v1_relat_1(k2_funcop_1(A,B))
      & v1_funct_1(k2_funcop_1(A,B)) ) ).

fof(fc2_funcop_1,axiom,
    ! [A] :
      ( v1_xboole_0(k2_funcop_1(k1_xboole_0,A))
      & v1_relat_1(k2_funcop_1(k1_xboole_0,A))
      & v1_funct_1(k2_funcop_1(k1_xboole_0,A))
      & v2_funct_1(k2_funcop_1(k1_xboole_0,A)) ) ).

fof(fc3_funcop_1,axiom,
    ! [A,B] :
      ( v1_xboole_0(B)
     => ( v1_xboole_0(k2_funcop_1(B,A))
        & v1_relat_1(k2_funcop_1(B,A))
        & v1_funct_1(k2_funcop_1(B,A))
        & v2_funct_1(k2_funcop_1(B,A)) ) ) ).

fof(fc4_funcop_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_relat_1(k3_funcop_1(A,B,C))
        & v1_funct_1(k3_funcop_1(A,B,C)) ) ) ).

fof(fc5_funcop_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k4_funcop_1(A,B,C))
        & v1_funct_1(k4_funcop_1(A,B,C)) ) ) ).

fof(fc6_funcop_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_relat_1(k5_funcop_1(A,B,C))
        & v1_funct_1(k5_funcop_1(A,B,C)) ) ) ).

fof(rc1_funcop_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v1_funcop_1(A) ) ).

fof(fc7_funcop_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_funcop_1(A) )
     => ( v1_relat_1(k1_funct_1(A,B))
        & v1_funct_1(k1_funct_1(A,B)) ) ) ).

fof(fc8_funcop_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_funcop_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k5_relat_1(B,A))
        & v1_funct_1(k5_relat_1(B,A))
        & v1_funcop_1(k5_relat_1(B,A)) ) ) ).

fof(fc9_funcop_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( v1_relat_1(k2_funcop_1(A,B))
        & v2_relat_1(k2_funcop_1(A,B))
        & v1_funct_1(k2_funcop_1(A,B)) ) ) ).

fof(t1_funcop_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( A = k2_zfmisc_1(B,C)
         => ( B = k1_xboole_0
            | C = k1_xboole_0
            | ( k1_relat_1(A) = B
              & k2_relat_1(A) = C ) ) ) ) ).

fof(t2_funcop_1,axiom,
    ! [A] : k12_funct_3(A) = k13_funct_3(k6_partfun1(A),k6_partfun1(A)) ).

fof(t3_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( k1_relat_1(A) = k1_relat_1(B)
               => k1_relat_1(k5_relat_1(C,A)) = k1_relat_1(k5_relat_1(C,B)) ) ) ) ) ).

fof(t4_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k1_relat_1(A) = k1_xboole_0
              & k1_relat_1(B) = k1_xboole_0 )
           => A = B ) ) ) ).

fof(d1_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k1_funcop_1(A)
          <=> ( k1_relat_1(B) = k1_relat_1(A)
              & ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => ( ! [D,E] :
                        ( k1_funct_1(A,C) = k4_tarski(D,E)
                       => k1_funct_1(B,C) = k4_tarski(E,D) )
                    & ~ ( k1_funct_1(A,C) != k1_funct_1(B,C)
                        & ! [D,E] : k1_funct_1(A,C) != k4_tarski(D,E) ) ) ) ) ) ) ) ).

fof(t5_funcop_1,axiom,
    $true ).

fof(t6_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k13_funct_3(A,B) = k1_funcop_1(k13_funct_3(B,A)) ) ) ).

fof(t7_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] : k1_funcop_1(k7_relat_1(A,B)) = k7_relat_1(k1_funcop_1(A),B) ) ).

fof(t8_funcop_1,axiom,
    $true ).

fof(t9_funcop_1,axiom,
    ! [A] : k1_funcop_1(k12_funct_3(A)) = k12_funct_3(A) ).

fof(t10_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k7_relat_1(k13_funct_3(A,B),C) = k13_funct_3(k7_relat_1(A,C),B) ) ) ).

fof(t11_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k7_relat_1(k13_funct_3(A,B),C) = k13_funct_3(A,k7_relat_1(B,C)) ) ) ).

fof(d2_funcop_1,axiom,
    ! [A,B] : k2_funcop_1(A,B) = k2_zfmisc_1(A,k1_tarski(B)) ).

fof(t12_funcop_1,axiom,
    $true ).

fof(t13_funcop_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(B,A)
     => k1_funct_1(k2_funcop_1(A,C),B) = C ) ).

fof(t14_funcop_1,axiom,
    ! [A,B] :
      ( A != k1_xboole_0
     => k2_relat_1(k2_funcop_1(A,B)) = k1_tarski(B) ) ).

fof(t15_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( k2_relat_1(A) = k1_tarski(B)
         => A = k2_funcop_1(k1_relat_1(A),B) ) ) ).

fof(t16_funcop_1,axiom,
    ! [A] :
      ( k1_relat_1(k2_funcop_1(k1_xboole_0,A)) = k1_xboole_0
      & k2_relat_1(k2_funcop_1(k1_xboole_0,A)) = k1_xboole_0 ) ).

fof(t17_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ! [C] :
              ( r2_hidden(C,k1_relat_1(A))
             => k1_funct_1(A,C) = B )
         => A = k2_funcop_1(k1_relat_1(A),B) ) ) ).

fof(t18_funcop_1,axiom,
    ! [A,B,C] : k7_relat_1(k2_funcop_1(A,B),C) = k2_funcop_1(k3_xboole_0(A,C),B) ).

fof(t19_funcop_1,axiom,
    ! [A,B] :
      ( k1_relat_1(k2_funcop_1(A,B)) = A
      & r1_tarski(k2_relat_1(k2_funcop_1(A,B)),k1_tarski(B)) ) ).

fof(t20_funcop_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(B,C)
     => k10_relat_1(k2_funcop_1(A,B),C) = A ) ).

fof(t21_funcop_1,axiom,
    ! [A,B] : k10_relat_1(k2_funcop_1(A,B),k1_tarski(B)) = A ).

fof(t22_funcop_1,axiom,
    ! [A,B,C] :
      ( ~ r2_hidden(B,C)
     => k10_relat_1(k2_funcop_1(A,B),C) = k1_xboole_0 ) ).

fof(t23_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( r2_hidden(C,k1_relat_1(A))
         => k5_relat_1(k2_funcop_1(B,C),A) = k2_funcop_1(B,k1_funct_1(A,C)) ) ) ).

fof(t24_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ~ ( B != k1_xboole_0
            & r2_hidden(C,k1_relat_1(A))
            & k1_relat_1(k5_relat_1(k2_funcop_1(B,C),A)) = k1_xboole_0 ) ) ).

fof(t25_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] : k5_relat_1(A,k2_funcop_1(B,C)) = k2_funcop_1(k10_relat_1(A,B),C) ) ).

fof(t26_funcop_1,axiom,
    ! [A,B,C] : k1_funcop_1(k2_funcop_1(A,k4_tarski(B,C))) = k2_funcop_1(A,k4_tarski(C,B)) ).

fof(d3_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => k3_funcop_1(A,B,C) = k5_relat_1(k13_funct_3(B,C),A) ) ) ) ).

fof(t27_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( k1_relat_1(D) = k1_relat_1(k3_funcop_1(C,A,B))
                      & ! [E] :
                          ( r2_hidden(E,k1_relat_1(k3_funcop_1(C,A,B)))
                         => k1_funct_1(D,E) = k1_binop_1(C,k1_funct_1(A,E),k1_funct_1(B,E)) ) )
                   => D = k3_funcop_1(C,A,B) ) ) ) ) ) ).

fof(t28_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( r2_hidden(D,k1_relat_1(k3_funcop_1(C,A,B)))
                 => k1_funct_1(k3_funcop_1(C,A,B),D) = k1_binop_1(C,k1_funct_1(A,D),k1_funct_1(B,D)) ) ) ) ) ).

fof(t29_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D,E] :
                  ( ( v1_relat_1(E)
                    & v1_funct_1(E) )
                 => ( k7_relat_1(A,D) = k7_relat_1(B,D)
                   => k7_relat_1(k3_funcop_1(E,A,C),D) = k7_relat_1(k3_funcop_1(E,B,C),D) ) ) ) ) ) ).

fof(t30_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D,E] :
                  ( ( v1_relat_1(E)
                    & v1_funct_1(E) )
                 => ( k7_relat_1(A,D) = k7_relat_1(B,D)
                   => k7_relat_1(k3_funcop_1(E,C,A),D) = k7_relat_1(k3_funcop_1(E,C,B),D) ) ) ) ) ) ).

fof(t31_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => k5_relat_1(C,k3_funcop_1(D,A,B)) = k3_funcop_1(D,k5_relat_1(C,A),k5_relat_1(C,B)) ) ) ) ) ).

fof(t32_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => k5_relat_1(k3_funcop_1(D,B,C),A) = k3_funcop_1(k5_relat_1(D,A),B,C) ) ) ) ) ).

fof(d4_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k4_funcop_1(A,B,C) = k5_relat_1(k13_funct_3(B,k2_funcop_1(k1_relat_1(B),C)),A) ) ) ).

fof(t33_funcop_1,axiom,
    $true ).

fof(t34_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k4_funcop_1(B,A,C) = k3_funcop_1(B,A,k2_funcop_1(k1_relat_1(A),C)) ) ) ).

fof(t35_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( r2_hidden(C,k1_relat_1(k4_funcop_1(B,A,D)))
             => k1_funct_1(k4_funcop_1(B,A,D),C) = k1_binop_1(B,k1_funct_1(A,C),D) ) ) ) ).

fof(t36_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ! [E] :
                  ( k7_relat_1(A,C) = k7_relat_1(B,C)
                 => k7_relat_1(k4_funcop_1(D,A,E),C) = k7_relat_1(k4_funcop_1(D,B,E),C) ) ) ) ) ).

fof(t37_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(B,k4_funcop_1(C,A,D)) = k4_funcop_1(C,k5_relat_1(B,A),D) ) ) ) ).

fof(t38_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(k4_funcop_1(C,B,D),A) = k4_funcop_1(k5_relat_1(C,A),B,D) ) ) ) ).

fof(t39_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] : k5_relat_1(k6_partfun1(B),k4_funcop_1(C,A,D)) = k4_funcop_1(C,k7_relat_1(A,B),D) ) ) ).

fof(d5_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => k5_funcop_1(A,B,C) = k5_relat_1(k13_funct_3(k2_funcop_1(k1_relat_1(C),B),C),A) ) ) ).

fof(t40_funcop_1,axiom,
    $true ).

fof(t41_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k5_funcop_1(B,C,A) = k3_funcop_1(B,k2_funcop_1(k1_relat_1(A),C),A) ) ) ).

fof(t42_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( r2_hidden(C,k1_relat_1(k5_funcop_1(B,D,A)))
             => k1_funct_1(k5_funcop_1(B,D,A),C) = k1_binop_1(B,D,k1_funct_1(A,C)) ) ) ) ).

fof(t43_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ! [E] :
                  ( k7_relat_1(A,C) = k7_relat_1(B,C)
                 => k7_relat_1(k5_funcop_1(D,E,A),C) = k7_relat_1(k5_funcop_1(D,E,B),C) ) ) ) ) ).

fof(t44_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(B,k5_funcop_1(C,D,A)) = k5_funcop_1(C,D,k5_relat_1(B,A)) ) ) ) ).

fof(t45_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(k5_funcop_1(C,D,B),A) = k5_funcop_1(k5_relat_1(C,A),D,B) ) ) ) ).

fof(t46_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] : k5_relat_1(k6_partfun1(B),k5_funcop_1(C,D,A)) = k5_funcop_1(C,D,k7_relat_1(A,B)) ) ) ).

fof(t47_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ( v1_funct_1(k3_funcop_1(C,D,E))
                        & v1_funct_2(k3_funcop_1(C,D,E),A,B)
                        & m2_relset_1(k3_funcop_1(C,D,E),A,B) ) ) ) ) ) ) ).

fof(t48_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => k8_funct_2(B,A,k6_funcop_1(A,B,C,D,E),F) = k2_binop_1(A,A,A,C,k8_funct_2(B,A,D,F),k8_funct_2(B,A,E,F)) ) ) ) ) ) ) ).

fof(t49_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,A,B)
                            & m2_relset_1(F,A,B) )
                         => ( ! [G] :
                                ( m1_subset_1(G,A)
                               => k8_funct_2(A,B,F,G) = k2_binop_1(B,B,B,C,k8_funct_2(A,B,D,G),k8_funct_2(A,B,E,G)) )
                           => F = k6_funcop_1(B,A,C,D,E) ) ) ) ) ) ) ) ).

fof(t50_funcop_1,axiom,
    $true ).

fof(t51_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,B)
                        & m2_relset_1(E,B,B) )
                     => k7_funct_2(A,B,B,D,k6_funcop_1(B,B,C,k6_partfun1(B),E)) = k6_funcop_1(B,A,C,D,k7_funct_2(A,B,B,D,E)) ) ) ) ) ) ).

fof(t52_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,B)
                        & m2_relset_1(E,B,B) )
                     => k7_funct_2(A,B,B,D,k6_funcop_1(B,B,C,E,k6_partfun1(B))) = k6_funcop_1(B,A,C,k7_funct_2(A,B,B,D,E),D) ) ) ) ) ) ).

fof(t53_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => k7_funct_2(A,B,B,D,k6_funcop_1(B,B,C,k6_partfun1(B),k6_partfun1(B))) = k6_funcop_1(B,A,C,D,D) ) ) ) ) ).

fof(t54_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,A)
                    & m2_relset_1(D,A,A) )
                 => k8_funct_2(A,A,k6_funcop_1(A,A,B,k6_partfun1(A),D),C) = k2_binop_1(A,A,A,B,C,k8_funct_2(A,A,D,C)) ) ) ) ) ).

fof(t55_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,A)
                    & m2_relset_1(D,A,A) )
                 => k8_funct_2(A,A,k6_funcop_1(A,A,B,D,k6_partfun1(A)),C) = k2_binop_1(A,A,A,B,k8_funct_2(A,A,D,C),C) ) ) ) ) ).

fof(t56_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => k8_funct_2(A,A,k6_funcop_1(A,A,B,k6_partfun1(A),k6_partfun1(A)),C) = k2_binop_1(A,A,A,B,C,C) ) ) ) ).

fof(t57_funcop_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(C,B)
     => ( v1_funct_1(k2_funcop_1(A,C))
        & v1_funct_2(k2_funcop_1(A,C),A,B)
        & m2_relset_1(k2_funcop_1(A,C),A,B) ) ) ).

fof(t58_funcop_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( m1_subset_1(C,B)
         => ( v1_funct_1(k2_funcop_1(A,C))
            & v1_funct_2(k2_funcop_1(A,C),A,B)
            & m2_relset_1(k2_funcop_1(A,C),A,B) ) ) ) ).

fof(t59_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v1_funct_1(k4_funcop_1(C,D,E))
                        & v1_funct_2(k4_funcop_1(C,D,E),A,B)
                        & m2_relset_1(k4_funcop_1(C,D,E),A,B) ) ) ) ) ) ) ).

fof(t60_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => k8_funct_2(B,A,k7_funcop_1(A,B,C,D,E),F) = k2_binop_1(A,A,A,C,k8_funct_2(B,A,D,F),E) ) ) ) ) ) ) ).

fof(t61_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ( ! [G] :
                                ( m1_subset_1(G,B)
                               => k8_funct_2(B,A,D,G) = k2_binop_1(A,A,A,C,k8_funct_2(B,A,E,G),F) )
                           => D = k7_funcop_1(A,B,C,E,F) ) ) ) ) ) ) ) ).

fof(t62_funcop_1,axiom,
    $true ).

fof(t63_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => k7_funct_2(A,B,B,D,k7_funcop_1(B,B,C,k6_partfun1(B),E)) = k7_funcop_1(B,A,C,D,E) ) ) ) ) ) ).

fof(t64_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => k8_funct_2(A,A,k7_funcop_1(A,A,B,k6_partfun1(A),C),C) = k2_binop_1(A,A,A,B,C,C) ) ) ) ).

fof(t65_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v1_funct_1(k5_funcop_1(C,E,D))
                        & v1_funct_2(k5_funcop_1(C,E,D),A,B)
                        & m2_relset_1(k5_funcop_1(C,E,D),A,B) ) ) ) ) ) ) ).

fof(t66_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => k8_funct_2(B,A,k8_funcop_1(A,B,C,E,D),F) = k2_binop_1(A,A,A,C,E,k8_funct_2(B,A,D,F)) ) ) ) ) ) ) ).

fof(t67_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ( ! [G] :
                                ( m1_subset_1(G,B)
                               => k8_funct_2(B,A,D,G) = k2_binop_1(A,A,A,C,F,k8_funct_2(B,A,E,G)) )
                           => D = k8_funcop_1(A,B,C,F,E) ) ) ) ) ) ) ) ).

fof(t68_funcop_1,axiom,
    $true ).

fof(t69_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => k7_funct_2(A,B,B,D,k8_funcop_1(B,B,C,E,k6_partfun1(B))) = k8_funcop_1(B,A,C,E,D) ) ) ) ) ) ).

fof(t70_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => k8_funct_2(A,A,k8_funcop_1(A,A,B,C,k6_partfun1(A)),C) = k2_binop_1(A,A,A,B,C,C) ) ) ) ).

fof(t71_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,k2_zfmisc_1(B,C))
                    & m2_relset_1(D,A,k2_zfmisc_1(B,C)) )
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => k1_funct_1(k1_funcop_1(D),E) = k4_tarski(k2_mcart_1(k8_funct_2(A,k2_zfmisc_1(B,C),D,E)),k1_mcart_1(k8_funct_2(A,k2_zfmisc_1(B,C),D,E))) ) ) ) ) ) ).

fof(t72_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,k2_zfmisc_1(B,C))
                    & m2_relset_1(D,A,k2_zfmisc_1(B,C)) )
                 => m2_relset_1(k2_relat_1(D),B,C) ) ) ) ) ).

fof(t73_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,k2_zfmisc_1(B,C))
                    & m2_relset_1(D,A,k2_zfmisc_1(B,C)) )
                 => k9_funcop_1(A,C,B,k10_funcop_1(A,B,C,D)) = k4_relat_1(k9_funcop_1(A,B,C,D)) ) ) ) ) ).

fof(t74_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k7_funcop_1(B,A,C,k8_funcop_1(B,A,C,E,D),F) = k8_funcop_1(B,A,C,E,k7_funcop_1(B,A,C,D,F)) ) ) ) ) ) ) ) ).

fof(t75_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k6_funcop_1(B,A,C,k7_funcop_1(B,A,C,D,F),E) = k6_funcop_1(B,A,C,D,k8_funcop_1(B,A,C,F,E)) ) ) ) ) ) ) ) ).

fof(t76_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,A,B)
                            & m2_relset_1(F,A,B) )
                         => ( v2_binop_1(C,B)
                           => k6_funcop_1(B,A,C,k6_funcop_1(B,A,C,D,E),F) = k6_funcop_1(B,A,C,D,k6_funcop_1(B,A,C,E,F)) ) ) ) ) ) ) ) ).

fof(t77_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k8_funcop_1(B,A,C,k2_binop_1(B,B,B,C,E,F),D) = k8_funcop_1(B,A,C,E,k8_funcop_1(B,A,C,F,D)) ) ) ) ) ) ) ) ).

fof(t78_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k7_funcop_1(B,A,C,D,k2_binop_1(B,B,B,C,E,F)) = k7_funcop_1(B,A,C,k7_funcop_1(B,A,C,D,E),F) ) ) ) ) ) ) ) ).

fof(t79_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v1_binop_1(C,B)
                       => k8_funcop_1(B,A,C,E,D) = k7_funcop_1(B,A,C,D,E) ) ) ) ) ) ) ).

fof(t80_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ( v1_binop_1(C,B)
                       => k6_funcop_1(B,A,C,D,E) = k6_funcop_1(B,A,C,E,D) ) ) ) ) ) ) ).

fof(t81_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ( v3_binop_1(C,B)
                   => k6_funcop_1(B,A,C,D,D) = D ) ) ) ) ) ).

fof(t82_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v3_binop_1(C,A)
                       => k8_funct_2(B,A,k8_funcop_1(A,B,C,k8_funct_2(B,A,D,E),D),E) = k8_funct_2(B,A,D,E) ) ) ) ) ) ) ).

fof(t83_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v3_binop_1(C,A)
                       => k8_funct_2(B,A,k7_funcop_1(A,B,C,D,k8_funct_2(B,A,D,E)),E) = k8_funct_2(B,A,D,E) ) ) ) ) ) ) ).

fof(t84_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_tarski(k2_zfmisc_1(k2_relat_1(B),k2_relat_1(C)),k1_relat_1(A))
               => k1_relat_1(k3_funcop_1(A,B,C)) = k3_xboole_0(k1_relat_1(B),k1_relat_1(C)) ) ) ) ) ).

fof(d6_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funcop_1(A)
      <=> ! [B] :
            ( r2_hidden(B,k1_relat_1(A))
           => ( v1_relat_1(k1_funct_1(A,B))
              & v1_funct_1(k1_funct_1(A,B)) ) ) ) ) ).

fof(dt_k1_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k1_funcop_1(A))
        & v1_funct_1(k1_funcop_1(A)) ) ) ).

fof(involutiveness_k1_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k1_funcop_1(k1_funcop_1(A)) = A ) ).

fof(dt_k2_funcop_1,axiom,
    $true ).

fof(dt_k3_funcop_1,axiom,
    $true ).

fof(dt_k4_funcop_1,axiom,
    $true ).

fof(dt_k5_funcop_1,axiom,
    $true ).

fof(dt_k6_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => ( v1_funct_1(k6_funcop_1(A,B,C,D,E))
        & v1_funct_2(k6_funcop_1(A,B,C,D,E),B,A)
        & m2_relset_1(k6_funcop_1(A,B,C,D,E),B,A) ) ) ).

fof(redefinition_k6_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => k6_funcop_1(A,B,C,D,E) = k3_funcop_1(C,D,E) ) ).

fof(dt_k7_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & m1_subset_1(E,A) )
     => ( v1_funct_1(k7_funcop_1(A,B,C,D,E))
        & v1_funct_2(k7_funcop_1(A,B,C,D,E),B,A)
        & m2_relset_1(k7_funcop_1(A,B,C,D,E),B,A) ) ) ).

fof(redefinition_k7_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & m1_subset_1(E,A) )
     => k7_funcop_1(A,B,C,D,E) = k4_funcop_1(C,D,E) ) ).

fof(dt_k8_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & m1_subset_1(D,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => ( v1_funct_1(k8_funcop_1(A,B,C,D,E))
        & v1_funct_2(k8_funcop_1(A,B,C,D,E),B,A)
        & m2_relset_1(k8_funcop_1(A,B,C,D,E),B,A) ) ) ).

fof(redefinition_k8_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & m1_subset_1(D,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => k8_funcop_1(A,B,C,D,E) = k5_funcop_1(C,D,E) ) ).

fof(dt_k9_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => m2_relset_1(k9_funcop_1(A,B,C,D),B,C) ) ).

fof(redefinition_k9_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => k9_funcop_1(A,B,C,D) = k2_relat_1(D) ) ).

fof(dt_k10_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => ( v1_funct_1(k10_funcop_1(A,B,C,D))
        & v1_funct_2(k10_funcop_1(A,B,C,D),A,k2_zfmisc_1(C,B))
        & m2_relset_1(k10_funcop_1(A,B,C,D),A,k2_zfmisc_1(C,B)) ) ) ).

fof(involutiveness_k10_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => k10_funcop_1(A,B,C,k10_funcop_1(A,B,C,D)) = D ) ).

fof(redefinition_k10_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => k10_funcop_1(A,B,C,D) = k1_funcop_1(D) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_funct_4,axiom,
    ! [A,B,C,D] :
      ( v1_relat_1(k4_funct_4(A,B,C,D))
      & v1_funct_1(k4_funct_4(A,B,C,D)) ) ).

fof(t1_funct_4,axiom,
    ! [A] :
      ~ ( ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D] : B != k4_tarski(C,D) )
        & ! [B,C] : ~ r1_tarski(A,k2_zfmisc_1(B,C)) ) ).

fof(t2_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k5_relat_1(B,A) = k5_relat_1(B,k7_relat_1(A,k2_relat_1(B))) ) ) ).

fof(t3_funct_4,axiom,
    $true ).

fof(t4_funct_4,axiom,
    ! [A,B] :
      ( r1_tarski(k6_partfun1(A),k6_partfun1(B))
    <=> r1_tarski(A,B) ) ).

fof(t5_funct_4,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k2_funcop_1(A,C),k2_funcop_1(B,C)) ) ).

fof(t6_funct_4,axiom,
    ! [A,B,C,D] :
      ( r1_tarski(k2_funcop_1(A,B),k2_funcop_1(C,D))
     => r1_tarski(A,C) ) ).

fof(t7_funct_4,axiom,
    ! [A,B,C,D] :
      ( r1_tarski(k2_funcop_1(A,B),k2_funcop_1(C,D))
     => ( A = k1_xboole_0
        | B = D ) ) ).

fof(t8_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(B))
       => r1_tarski(k2_funcop_1(k1_tarski(A),k1_funct_1(B,A)),B) ) ) ).

fof(t9_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k7_relat_1(k8_relat_1(A,C),B),C) ) ).

fof(t10_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r1_tarski(C,D)
           => r1_tarski(k7_relat_1(k8_relat_1(A,C),B),k7_relat_1(k8_relat_1(A,D),B)) ) ) ) ).

fof(d1_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( C = k1_funct_4(A,B)
              <=> ( k1_relat_1(C) = k2_xboole_0(k1_relat_1(A),k1_relat_1(B))
                  & ! [D] :
                      ( r2_hidden(D,k2_xboole_0(k1_relat_1(A),k1_relat_1(B)))
                     => ( ( r2_hidden(D,k1_relat_1(B))
                         => k1_funct_1(C,D) = k1_funct_1(B,D) )
                        & ( ~ r2_hidden(D,k1_relat_1(B))
                         => k1_funct_1(C,D) = k1_funct_1(A,D) ) ) ) ) ) ) ) ) ).

fof(t11_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(k1_relat_1(A),k1_relat_1(k1_funct_4(A,B)))
            & r1_tarski(k1_relat_1(B),k1_relat_1(k1_funct_4(A,B))) ) ) ) ).

fof(t12_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ~ r2_hidden(A,k1_relat_1(B))
           => k1_funct_1(k1_funct_4(C,B),A) = k1_funct_1(C,A) ) ) ) ).

fof(t13_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(k1_funct_4(B,C)))
          <=> ( r2_hidden(A,k1_relat_1(B))
              | r2_hidden(A,k1_relat_1(C)) ) ) ) ) ).

fof(t14_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(B))
           => k1_funct_1(k1_funct_4(C,B),A) = k1_funct_1(B,A) ) ) ) ).

fof(t15_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => k1_funct_4(k1_funct_4(A,B),C) = k1_funct_4(A,k1_funct_4(B,C)) ) ) ) ).

fof(t16_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_partfun1(B,C)
              & r2_hidden(A,k1_relat_1(B)) )
           => k1_funct_1(k1_funct_4(B,C),A) = k1_funct_1(B,A) ) ) ) ).

fof(t17_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_xboole_0(k1_relat_1(B),k1_relat_1(C))
              & r2_hidden(A,k1_relat_1(B)) )
           => k1_funct_1(k1_funct_4(B,C),A) = k1_funct_1(B,A) ) ) ) ).

fof(t18_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k2_relat_1(k1_funct_4(A,B)),k2_xboole_0(k2_relat_1(A),k2_relat_1(B))) ) ) ).

fof(t19_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k2_relat_1(A),k2_relat_1(k1_funct_4(B,A))) ) ) ).

fof(t20_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(k1_relat_1(A),k1_relat_1(B))
           => k1_funct_4(A,B) = B ) ) ) ).

fof(t21_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k1_funct_4(k1_xboole_0,A) = A ) ).

fof(t22_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k1_funct_4(A,k1_xboole_0) = A ) ).

fof(t23_funct_4,axiom,
    ! [A,B] : k1_funct_4(k6_partfun1(A),k6_partfun1(B)) = k6_partfun1(k2_xboole_0(A,B)) ).

fof(t24_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k7_relat_1(k1_funct_4(A,B),k1_relat_1(B)) = B ) ) ).

fof(t25_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k7_relat_1(k1_funct_4(A,B),k4_xboole_0(k1_relat_1(A),k1_relat_1(B))),A) ) ) ).

fof(t26_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(A,k1_funct_4(B,A)) ) ) ).

fof(t27_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_partfun1(A,k1_funct_4(B,C))
               => r1_partfun1(k7_relat_1(A,k4_xboole_0(k1_relat_1(A),k1_relat_1(C))),B) ) ) ) ) ).

fof(t28_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_partfun1(A,k1_funct_4(B,C))
               => r1_partfun1(A,C) ) ) ) ) ).

fof(t29_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> r1_tarski(A,k1_funct_4(A,B)) ) ) ) ).

fof(t30_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k1_funct_4(A,B),k2_xboole_0(A,B)) ) ) ).

fof(t31_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> k2_xboole_0(A,B) = k1_funct_4(A,B) ) ) ) ).

fof(t32_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => k2_xboole_0(A,B) = k1_funct_4(A,B) ) ) ) ).

fof(t33_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => r1_tarski(A,k1_funct_4(A,B)) ) ) ) ).

fof(t34_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => k7_relat_1(k1_funct_4(A,B),k1_relat_1(A)) = A ) ) ) ).

fof(t35_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> k1_funct_4(A,B) = k1_funct_4(B,A) ) ) ) ).

fof(t36_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => k1_funct_4(A,B) = k1_funct_4(B,A) ) ) ) ).

fof(t37_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( v1_partfun1(D,A,B)
           => k1_funct_4(C,D) = D ) ) ) ).

fof(t38_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ( B = k1_xboole_0
             => A = k1_xboole_0 )
           => k1_funct_4(C,D) = D ) ) ) ).

fof(t39_funct_4,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => k1_funct_4(B,C) = C ) ) ).

fof(t40_funct_4,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,B)
            & m2_relset_1(C,A,B) )
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => k1_funct_4(C,D) = D ) ) ) ).

fof(t41_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( v1_funct_1(k1_funct_4(C,D))
            & m2_relset_1(k1_funct_4(C,D),A,B) ) ) ) ).

fof(d2_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k2_funct_4(A)
          <=> ( ! [C] :
                  ( r2_hidden(C,k1_relat_1(B))
                <=> ? [D,E] :
                      ( C = k4_tarski(E,D)
                      & r2_hidden(k4_tarski(D,E),k1_relat_1(A)) ) )
              & ! [C,D] :
                  ( r2_hidden(k4_tarski(C,D),k1_relat_1(A))
                 => k1_funct_1(B,k4_tarski(D,C)) = k1_funct_1(A,k4_tarski(C,D)) ) ) ) ) ) ).

fof(t42_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_tarski(k2_relat_1(k2_funct_4(A)),k2_relat_1(A)) ) ).

fof(t43_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(k4_tarski(A,B),k1_relat_1(C))
      <=> r2_hidden(k4_tarski(B,A),k1_relat_1(k2_funct_4(C))) ) ) ).

fof(t44_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(k4_tarski(A,B),k1_relat_1(k2_funct_4(C)))
       => k1_funct_1(k2_funct_4(C),k4_tarski(A,B)) = k1_funct_1(C,k4_tarski(B,A)) ) ) ).

fof(t45_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ? [B,C] : r1_tarski(k1_relat_1(k2_funct_4(A)),k2_zfmisc_1(B,C)) ) ).

fof(t46_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k1_relat_1(C),k2_zfmisc_1(A,B))
       => r1_tarski(k1_relat_1(k2_funct_4(C)),k2_zfmisc_1(B,A)) ) ) ).

fof(t47_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( k1_relat_1(C) = k2_zfmisc_1(A,B)
       => k1_relat_1(k2_funct_4(C)) = k2_zfmisc_1(B,A) ) ) ).

fof(t48_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k1_relat_1(C),k2_zfmisc_1(A,B))
       => k2_relat_1(k2_funct_4(C)) = k2_relat_1(C) ) ) ).

fof(t49_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ( v1_funct_1(k2_funct_4(D))
        & m2_relset_1(k2_funct_4(D),k2_zfmisc_1(B,A),C) ) ) ).

fof(t50_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ( C != k1_xboole_0
       => ( v1_funct_1(k2_funct_4(D))
          & v1_funct_2(k2_funct_4(D),k2_zfmisc_1(B,A),C)
          & m2_relset_1(k2_funct_4(D),k2_zfmisc_1(B,A),C) ) ) ) ).

fof(t51_funct_4,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,k2_zfmisc_1(A,B),C)
            & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
         => ( v1_funct_1(k2_funct_4(D))
            & v1_funct_2(k2_funct_4(D),k2_zfmisc_1(B,A),C)
            & m2_relset_1(k2_funct_4(D),k2_zfmisc_1(B,A),C) ) ) ) ).

fof(t52_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_tarski(k2_funct_4(k2_funct_4(A)),A) ) ).

fof(t53_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k1_relat_1(C),k2_zfmisc_1(A,B))
       => k2_funct_4(k2_funct_4(C)) = C ) ) ).

fof(t54_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => k2_funct_4(k2_funct_4(D)) = D ) ).

fof(t55_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ( C != k1_xboole_0
       => k2_funct_4(k2_funct_4(D)) = D ) ) ).

fof(t56_funct_4,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,k2_zfmisc_1(A,B),C)
            & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
         => k2_funct_4(k2_funct_4(D)) = D ) ) ).

fof(d3_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( C = k3_funct_4(A,B)
              <=> ( ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                    <=> ? [E,F,G,H] :
                          ( D = k4_tarski(k4_tarski(E,G),k4_tarski(F,H))
                          & r2_hidden(k4_tarski(E,F),k1_relat_1(A))
                          & r2_hidden(k4_tarski(G,H),k1_relat_1(B)) ) )
                  & ! [D,E,F,G] :
                      ( ( r2_hidden(k4_tarski(D,E),k1_relat_1(A))
                        & r2_hidden(k4_tarski(F,G),k1_relat_1(B)) )
                     => k1_funct_1(C,k4_tarski(k4_tarski(D,F),k4_tarski(E,G))) = k4_tarski(k1_funct_1(A,k4_tarski(D,E)),k1_funct_1(B,k4_tarski(F,G))) ) ) ) ) ) ) ).

fof(t57_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( r2_hidden(k4_tarski(k4_tarski(A,B),k4_tarski(C,D)),k1_relat_1(k3_funct_4(E,F)))
          <=> ( r2_hidden(k4_tarski(A,C),k1_relat_1(E))
              & r2_hidden(k4_tarski(B,D),k1_relat_1(F)) ) ) ) ) ).

fof(t58_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( r2_hidden(k4_tarski(k4_tarski(A,B),k4_tarski(C,D)),k1_relat_1(k3_funct_4(E,F)))
           => k1_funct_1(k3_funct_4(E,F),k4_tarski(k4_tarski(A,B),k4_tarski(C,D))) = k4_tarski(k1_funct_1(E,k4_tarski(A,C)),k1_funct_1(F,k4_tarski(B,D))) ) ) ) ).

fof(t59_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k2_relat_1(k3_funct_4(A,B)),k2_zfmisc_1(k2_relat_1(A),k2_relat_1(B))) ) ) ).

fof(t60_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( ( r1_tarski(k1_relat_1(E),k2_zfmisc_1(A,B))
              & r1_tarski(k1_relat_1(F),k2_zfmisc_1(C,D)) )
           => r1_tarski(k1_relat_1(k3_funct_4(E,F)),k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D))) ) ) ) ).

fof(t61_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( ( k1_relat_1(E) = k2_zfmisc_1(A,B)
              & k1_relat_1(F) = k2_zfmisc_1(C,D) )
           => k1_relat_1(k3_funct_4(E,F)) = k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ) ) ) ).

fof(t62_funct_4,axiom,
    ! [A,B,C,D,E,F,G] :
      ( ( v1_funct_1(G)
        & m2_relset_1(G,k2_zfmisc_1(A,B),C) )
     => ! [H] :
          ( ( v1_funct_1(H)
            & m2_relset_1(H,k2_zfmisc_1(D,E),F) )
         => ( v1_funct_1(k3_funct_4(G,H))
            & m2_relset_1(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,D),k2_zfmisc_1(B,E)),k2_zfmisc_1(C,F)) ) ) ) ).

fof(t63_funct_4,axiom,
    ! [A,B,C,D,E,F,G] :
      ( ( v1_funct_1(G)
        & v1_funct_2(G,k2_zfmisc_1(A,B),C)
        & m2_relset_1(G,k2_zfmisc_1(A,B),C) )
     => ! [H] :
          ( ( v1_funct_1(H)
            & v1_funct_2(H,k2_zfmisc_1(D,E),F)
            & m2_relset_1(H,k2_zfmisc_1(D,E),F) )
         => ~ ( C != k1_xboole_0
              & F != k1_xboole_0
              & ~ ( v1_funct_1(k3_funct_4(G,H))
                  & v1_funct_2(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,D),k2_zfmisc_1(B,E)),k2_zfmisc_1(C,F))
                  & m2_relset_1(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,D),k2_zfmisc_1(B,E)),k2_zfmisc_1(C,F)) ) ) ) ) ).

fof(t64_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ~ v1_xboole_0(E)
     => ! [F] :
          ( ~ v1_xboole_0(F)
         => ! [G] :
              ( ( v1_funct_1(G)
                & v1_funct_2(G,k2_zfmisc_1(A,B),E)
                & m2_relset_1(G,k2_zfmisc_1(A,B),E) )
             => ! [H] :
                  ( ( v1_funct_1(H)
                    & v1_funct_2(H,k2_zfmisc_1(C,D),F)
                    & m2_relset_1(H,k2_zfmisc_1(C,D),F) )
                 => ( v1_funct_1(k3_funct_4(G,H))
                    & v1_funct_2(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)),k2_zfmisc_1(E,F))
                    & m2_relset_1(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)),k2_zfmisc_1(E,F)) ) ) ) ) ) ).

fof(d4_funct_4,axiom,
    ! [A,B,C,D] : k4_funct_4(A,B,C,D) = k1_funct_4(k2_funcop_1(k1_tarski(A),C),k2_funcop_1(k1_tarski(B),D)) ).

fof(t65_funct_4,axiom,
    ! [A,B,C,D] :
      ( k1_relat_1(k4_funct_4(A,B,C,D)) = k2_tarski(A,B)
      & r1_tarski(k2_relat_1(k4_funct_4(A,B,C,D)),k2_tarski(C,D)) ) ).

fof(t66_funct_4,axiom,
    ! [A,B,C,D] :
      ( A != B
     => ( k1_funct_1(k4_funct_4(A,B,C,D),A) = C
        & k1_funct_1(k4_funct_4(A,B,C,D),B) = D ) ) ).

fof(t67_funct_4,axiom,
    ! [A,B,C,D] :
      ( A != B
     => k2_relat_1(k4_funct_4(A,B,C,D)) = k2_tarski(C,D) ) ).

fof(t68_funct_4,axiom,
    ! [A,B,C] : k4_funct_4(A,B,C,C) = k2_funcop_1(k2_tarski(A,B),C) ).

fof(t69_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ( ( k1_relat_1(E) = k2_tarski(A,B)
          & k1_funct_1(E,A) = C
          & k1_funct_1(E,B) = D )
       => E = k4_funct_4(A,B,C,D) ) ) ).

fof(t70_funct_4,axiom,
    ! [A,B] : k2_funcop_1(k1_tarski(A),B) = k1_tarski(k4_tarski(A,B)) ).

fof(t71_funct_4,axiom,
    ! [A,B,C,D] :
      ( A != C
     => k4_funct_4(A,C,B,D) = k2_tarski(k4_tarski(A,B),k4_tarski(C,D)) ) ).

fof(t72_funct_4,axiom,
    ! [A,B,C,D,E,F] :
      ( k4_funct_4(A,B,C,D) = k4_funct_4(A,B,E,F)
     => ( A = B
        | ( C = E
          & D = F ) ) ) ).

fof(t73_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( r1_tarski(k2_relat_1(C),k1_relat_1(A))
                      & r1_tarski(k2_relat_1(D),k1_relat_1(B))
                      & r1_partfun1(A,B) )
                   => k5_relat_1(k1_funct_4(C,D),k1_funct_4(A,B)) = k1_funct_4(k5_relat_1(C,A),k5_relat_1(D,B)) ) ) ) ) ) ).

fof(t74_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( r1_tarski(k1_relat_1(A),k2_xboole_0(B,C))
         => k1_funct_4(k7_relat_1(A,B),k7_relat_1(A,C)) = A ) ) ).

fof(t75_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k7_relat_1(k1_funct_4(A,B),C) = k1_funct_4(k7_relat_1(A,C),k7_relat_1(B,C)) ) ) ).

fof(t76_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( r1_xboole_0(C,k1_relat_1(B))
             => k7_relat_1(k1_funct_4(A,B),C) = k7_relat_1(A,C) ) ) ) ).

fof(t77_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( r1_xboole_0(k1_relat_1(A),C)
             => k7_relat_1(k1_funct_4(A,B),C) = k7_relat_1(B,C) ) ) ) ).

fof(t78_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( k1_relat_1(B) = k1_relat_1(C)
               => k1_funct_4(k1_funct_4(A,B),C) = k1_funct_4(A,C) ) ) ) ) ).

fof(t79_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(A,B)
           => ( k1_funct_4(A,B) = B
              & k1_funct_4(B,A) = B ) ) ) ) ).

fof(t80_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] : k1_funct_4(A,k7_relat_1(A,B)) = A ) ).

fof(t81_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( ( r1_tarski(k1_relat_1(A),C)
                & r1_tarski(k1_relat_1(B),D)
                & r1_xboole_0(C,D) )
             => ( k7_relat_1(k1_funct_4(A,B),C) = A
                & k7_relat_1(k1_funct_4(A,B),D) = B ) ) ) ) ).

fof(t82_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( r1_tarski(k1_relat_1(A),C)
                & r1_xboole_0(k1_relat_1(B),C) )
             => k7_relat_1(k1_funct_4(A,B),C) = A ) ) ) ).

fof(t83_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] : k7_relat_1(A,k2_xboole_0(B,C)) = k1_funct_4(k7_relat_1(A,B),k7_relat_1(A,C)) ) ).

fof(dt_k1_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k1_funct_4(A,B))
        & v1_funct_1(k1_funct_4(A,B)) ) ) ).

fof(idempotence_k1_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => k1_funct_4(A,A) = A ) ).

fof(dt_k2_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k2_funct_4(A))
        & v1_funct_1(k2_funct_4(A)) ) ) ).

fof(dt_k3_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k3_funct_4(A,B))
        & v1_funct_1(k3_funct_4(A,B)) ) ) ).

fof(dt_k4_funct_4,axiom,
    $true ).

fof(dt_k5_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A) )
     => ( v1_funct_1(k5_funct_4(A,B,C,D,E))
        & v1_funct_2(k5_funct_4(A,B,C,D,E),k2_tarski(B,C),A)
        & m2_relset_1(k5_funct_4(A,B,C,D,E),k2_tarski(B,C),A) ) ) ).

fof(redefinition_k5_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A) )
     => k5_funct_4(A,B,C,D,E) = k4_funct_4(B,C,D,E) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_ordinal2,axiom,
    ( v1_ordinal1(k5_ordinal2)
    & v2_ordinal1(k5_ordinal2)
    & v3_ordinal1(k5_ordinal2)
    & ~ v1_xboole_0(k5_ordinal2) ) ).

fof(rc1_ordinal2,axiom,
    ? [A] :
      ( v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A)
      & v4_ordinal1(A) ) ).

fof(rc2_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & v1_ordinal2(A) ) ).

fof(cc1_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( m1_ordinal1(B,A)
         => v1_ordinal2(B) ) ) ).

fof(fc2_ordinal2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A)
        & v3_ordinal1(B) )
     => ( v1_relat_1(k7_relat_1(A,B))
        & v1_funct_1(k7_relat_1(A,B))
        & v1_ordinal2(k7_relat_1(A,B)) ) ) ).

fof(fc3_ordinal2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A)
        & v3_ordinal1(B) )
     => ( v1_ordinal1(k1_funct_1(A,B))
        & v2_ordinal1(k1_funct_1(A,B))
        & v3_ordinal1(k1_funct_1(A,B)) ) ) ).

fof(fc4_ordinal2,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( v1_relat_1(k2_funcop_1(A,B))
        & v1_funct_1(k2_funcop_1(A,B))
        & v1_ordinal2(k2_funcop_1(A,B)) ) ) ).

fof(t1_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r1_ordinal1(A,B)
          <=> r1_ordinal1(k1_ordinal1(A),k1_ordinal1(B)) ) ) ) ).

fof(t2_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k3_tarski(k1_ordinal1(A)) = A ) ).

fof(t3_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => r1_tarski(k1_ordinal1(A),k1_zfmisc_1(A)) ) ).

fof(t4_ordinal2,axiom,
    v4_ordinal1(k1_xboole_0) ).

fof(t5_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => r1_ordinal1(k3_tarski(A),A) ) ).

fof(d1_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => k1_ordinal2(A) = k1_funct_1(A,k3_tarski(k1_relat_1(A))) ) ).

fof(t6_ordinal2,axiom,
    $true ).

fof(t7_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B) )
         => ( k1_relat_1(B) = k1_ordinal1(A)
           => k1_ordinal2(B) = k1_funct_1(B,A) ) ) ) ).

fof(d2_ordinal2,axiom,
    ! [A,B] :
      ( B = k2_ordinal2(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> ( r2_hidden(C,A)
            & v3_ordinal1(C) ) ) ) ).

fof(d3_ordinal2,axiom,
    ! [A,B] :
      ( B = k3_ordinal2(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> ( r2_hidden(C,A)
            & ? [D] :
                ( v3_ordinal1(D)
                & C = D
                & v4_ordinal1(D) ) ) ) ) ).

fof(t8_ordinal2,axiom,
    $true ).

fof(t9_ordinal2,axiom,
    ! [A] : r1_tarski(k2_ordinal2(A),A) ).

fof(t10_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k2_ordinal2(A) = A ) ).

fof(t11_ordinal2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k2_ordinal2(A),k2_ordinal2(B)) ) ).

fof(t12_ordinal2,axiom,
    $true ).

fof(t13_ordinal2,axiom,
    ! [A] : r1_tarski(k3_ordinal2(A),A) ).

fof(t14_ordinal2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_ordinal2(A),k3_ordinal2(B)) ) ).

fof(t15_ordinal2,axiom,
    ! [A] : r1_tarski(k3_ordinal2(A),k2_ordinal2(A)) ).

fof(t16_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ? [B] :
          ( v3_ordinal1(B)
          & r2_hidden(A,B)
          & v4_ordinal1(B) ) ) ).

fof(t17_ordinal2,axiom,
    ! [A] :
      ( ! [B] :
          ( r2_hidden(B,A)
         => v3_ordinal1(B) )
     => v3_ordinal1(k1_setfam_1(A)) ) ).

fof(d4_ordinal2,axiom,
    k4_ordinal2 = k1_ordinal1(k1_xboole_0) ).

fof(d5_ordinal2,axiom,
    ! [A] :
      ( A = k5_ordinal2
    <=> ( r2_hidden(k1_xboole_0,A)
        & v4_ordinal1(A)
        & v3_ordinal1(A)
        & ! [B] :
            ( v3_ordinal1(B)
           => ( ( r2_hidden(k1_xboole_0,B)
                & v4_ordinal1(B) )
             => r1_tarski(A,B) ) ) ) ) ).

fof(d6_ordinal2,axiom,
    ! [A] : k6_ordinal2(A) = k1_setfam_1(k2_ordinal2(A)) ).

fof(d7_ordinal2,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( B = k7_ordinal2(A)
      <=> ( r1_tarski(k2_ordinal2(A),B)
          & ! [C] :
              ( v3_ordinal1(C)
             => ( r1_tarski(k2_ordinal2(A),C)
               => r1_ordinal1(B,C) ) ) ) ) ) ).

fof(t18_ordinal2,axiom,
    $true ).

fof(t19_ordinal2,axiom,
    ( r2_hidden(k1_xboole_0,k5_ordinal2)
    & v4_ordinal1(k5_ordinal2)
    & ! [A] :
        ( v3_ordinal1(A)
       => ( ( r2_hidden(k1_xboole_0,A)
            & v4_ordinal1(A) )
         => r1_ordinal1(k5_ordinal2,A) ) ) ) ).

fof(t20_ordinal2,axiom,
    $true ).

fof(t21_ordinal2,axiom,
    $true ).

fof(t22_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r2_hidden(A,B)
         => r1_ordinal1(k6_ordinal2(B),A) ) ) ).

fof(t23_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(C,B)
               => r1_ordinal1(A,C) ) )
         => ( k2_ordinal2(B) = k1_xboole_0
            | r1_ordinal1(A,k6_ordinal2(B)) ) ) ) ).

fof(t24_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B,C] :
          ( ( r2_hidden(A,B)
            & r1_tarski(B,C) )
         => r1_ordinal1(k6_ordinal2(C),k6_ordinal2(B)) ) ) ).

fof(t25_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r2_hidden(A,B)
         => r2_hidden(k6_ordinal2(B),B) ) ) ).

fof(t26_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k7_ordinal2(A) = A ) ).

fof(t27_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r2_hidden(A,B)
         => r2_hidden(A,k7_ordinal2(B)) ) ) ).

fof(t28_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(C,B)
               => r2_hidden(C,A) ) )
         => r1_ordinal1(k7_ordinal2(B),A) ) ) ).

fof(t29_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ~ ( r2_hidden(A,k7_ordinal2(B))
            & ! [C] :
                ( v3_ordinal1(C)
               => ~ ( r2_hidden(C,B)
                    & r1_ordinal1(A,C) ) ) ) ) ).

fof(t30_ordinal2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_ordinal1(k7_ordinal2(A),k7_ordinal2(B)) ) ).

fof(t31_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k7_ordinal2(k1_tarski(A)) = k1_ordinal1(A) ) ).

fof(t32_ordinal2,axiom,
    ! [A] : r1_ordinal1(k6_ordinal2(A),k7_ordinal2(A)) ).

fof(d8_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_ordinal2(A)
      <=> ? [B] :
            ( v3_ordinal1(B)
            & r1_tarski(k2_relat_1(A),B) ) ) ) ).

fof(t33_ordinal2,axiom,
    $true ).

fof(t34_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ( r2_hidden(A,k1_relat_1(B))
           => v3_ordinal1(k1_funct_1(B,A)) ) ) ) ).

fof(d9_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => k8_ordinal2(A) = k7_ordinal2(k2_relat_1(A)) ) ).

fof(d10_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => k9_ordinal2(A) = k6_ordinal2(k2_relat_1(A)) ) ).

fof(t35_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ( k8_ordinal2(A) = k7_ordinal2(k2_relat_1(A))
        & k9_ordinal2(A) = k6_ordinal2(k2_relat_1(A)) ) ) ).

fof(d11_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ! [B] :
          ( v3_ordinal1(B)
         => ( B = k10_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C)
                & B = k9_ordinal2(C)
                & k1_relat_1(C) = k1_relat_1(A)
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(D,k1_relat_1(A))
                     => k1_funct_1(C,D) = k7_ordinal2(k2_relat_1(k7_relat_1(A,k4_xboole_0(k1_relat_1(A),D)))) ) ) ) ) ) ) ).

fof(d12_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ! [B] :
          ( v3_ordinal1(B)
         => ( B = k11_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C)
                & B = k8_ordinal2(C)
                & k1_relat_1(C) = k1_relat_1(A)
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(D,k1_relat_1(A))
                     => k1_funct_1(C,D) = k6_ordinal2(k2_relat_1(k7_relat_1(A,k4_xboole_0(k1_relat_1(A),D)))) ) ) ) ) ) ) ).

fof(d13_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ( ( A = k1_xboole_0
             => ( r1_ordinal2(A,B)
              <=> ? [C] :
                    ( v3_ordinal1(C)
                    & r2_hidden(C,k1_relat_1(B))
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r1_ordinal1(C,D)
                            & r2_hidden(D,k1_relat_1(B)) )
                         => k1_funct_1(B,D) = k1_xboole_0 ) ) ) ) )
            & ( A != k1_xboole_0
             => ( r1_ordinal2(A,B)
              <=> ! [C] :
                    ( v3_ordinal1(C)
                   => ! [D] :
                        ( v3_ordinal1(D)
                       => ~ ( r2_hidden(C,A)
                            & r2_hidden(A,D)
                            & ! [E] :
                                ( v3_ordinal1(E)
                               => ~ ( r2_hidden(E,k1_relat_1(B))
                                    & ! [F] :
                                        ( v3_ordinal1(F)
                                       => ( ( r1_ordinal1(E,F)
                                            & r2_hidden(F,k1_relat_1(B)) )
                                         => ( r2_hidden(C,k1_funct_1(B,F))
                                            & r2_hidden(k1_funct_1(B,F),D) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(d14_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ( ? [B] :
            ( v3_ordinal1(B)
            & r1_ordinal2(B,A) )
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = k12_ordinal2(A)
            <=> r1_ordinal2(B,A) ) ) ) ) ).

fof(d15_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => k13_ordinal2(A,B) = k12_ordinal2(k2_ordinal1(B,A)) ) ) ).

fof(d16_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ( v2_ordinal2(A)
      <=> ! [B] :
            ( v3_ordinal1(B)
           => ! [C] :
                ( v3_ordinal1(C)
               => ( ( r2_hidden(B,C)
                    & r2_hidden(C,k1_relat_1(A)) )
                 => r2_hidden(k1_funct_1(A,B),k1_funct_1(A,C)) ) ) ) ) ) ).

fof(d17_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ( v3_ordinal2(A)
      <=> ! [B] :
            ( v3_ordinal1(B)
           => ! [C] :
                ( v3_ordinal1(C)
               => ( ( r2_hidden(B,k1_relat_1(A))
                    & v4_ordinal1(B)
                    & C = k1_funct_1(A,B) )
                 => ( B = k1_xboole_0
                    | r1_ordinal2(C,k2_ordinal1(A,B)) ) ) ) ) ) ) ).

fof(d18_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( C = k14_ordinal2(A,B)
              <=> ? [D] :
                    ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v5_ordinal1(D)
                    & v1_ordinal2(D)
                    & C = k1_ordinal2(D)
                    & k1_relat_1(D) = k1_ordinal1(B)
                    & k1_funct_1(D,k1_xboole_0) = A
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( r2_hidden(k1_ordinal1(E),k1_ordinal1(B))
                         => k1_funct_1(D,k1_ordinal1(E)) = k1_ordinal1(k1_funct_1(D,E)) ) )
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( ( r2_hidden(E,k1_ordinal1(B))
                            & v4_ordinal1(E) )
                         => ( E = k1_xboole_0
                            | k1_funct_1(D,E) = k8_ordinal2(k2_ordinal1(D,E)) ) ) ) ) ) ) ) ) ).

fof(d19_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( C = k15_ordinal2(A,B)
              <=> ? [D] :
                    ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v5_ordinal1(D)
                    & v1_ordinal2(D)
                    & C = k1_ordinal2(D)
                    & k1_relat_1(D) = k1_ordinal1(A)
                    & k1_funct_1(D,k1_xboole_0) = k1_xboole_0
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( r2_hidden(k1_ordinal1(E),k1_ordinal1(A))
                         => k1_funct_1(D,k1_ordinal1(E)) = k14_ordinal2(k1_funct_1(D,E),B) ) )
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( ( r2_hidden(E,k1_ordinal1(A))
                            & v4_ordinal1(E) )
                         => ( E = k1_xboole_0
                            | k1_funct_1(D,E) = k3_tarski(k8_ordinal2(k2_ordinal1(D,E))) ) ) ) ) ) ) ) ) ).

fof(d20_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( C = k16_ordinal2(A,B)
              <=> ? [D] :
                    ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v5_ordinal1(D)
                    & v1_ordinal2(D)
                    & C = k1_ordinal2(D)
                    & k1_relat_1(D) = k1_ordinal1(B)
                    & k1_funct_1(D,k1_xboole_0) = k4_ordinal2
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( r2_hidden(k1_ordinal1(E),k1_ordinal1(B))
                         => k1_funct_1(D,k1_ordinal1(E)) = k15_ordinal2(A,k1_funct_1(D,E)) ) )
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( ( r2_hidden(E,k1_ordinal1(B))
                            & v4_ordinal1(E) )
                         => ( E = k1_xboole_0
                            | k1_funct_1(D,E) = k12_ordinal2(k2_ordinal1(D,E)) ) ) ) ) ) ) ) ) ).

fof(t36_ordinal2,axiom,
    $true ).

fof(t37_ordinal2,axiom,
    $true ).

fof(t38_ordinal2,axiom,
    $true ).

fof(t39_ordinal2,axiom,
    $true ).

fof(t40_ordinal2,axiom,
    $true ).

fof(t41_ordinal2,axiom,
    $true ).

fof(t42_ordinal2,axiom,
    $true ).

fof(t43_ordinal2,axiom,
    $true ).

fof(t44_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k14_ordinal2(A,k1_xboole_0) = A ) ).

fof(t45_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k14_ordinal2(A,k1_ordinal1(B)) = k1_ordinal1(k14_ordinal2(A,B)) ) ) ).

fof(t46_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => ( A = k1_xboole_0
              | ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C) )
                 => ( ( k1_relat_1(C) = A
                      & ! [D] :
                          ( v3_ordinal1(D)
                         => ( r2_hidden(D,A)
                           => k1_funct_1(C,D) = k14_ordinal2(B,D) ) ) )
                   => k14_ordinal2(B,A) = k8_ordinal2(C) ) ) ) ) ) ) ).

fof(t47_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k14_ordinal2(k1_xboole_0,A) = A ) ).

fof(t48_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k14_ordinal2(A,k4_ordinal2) = k1_ordinal1(A) ) ).

fof(t49_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(A,B)
               => r2_hidden(k14_ordinal2(C,A),k14_ordinal2(C,B)) ) ) ) ) ).

fof(t50_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k14_ordinal2(C,A),k14_ordinal2(C,B)) ) ) ) ) ).

fof(t51_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k14_ordinal2(A,C),k14_ordinal2(B,C)) ) ) ) ) ).

fof(t52_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k15_ordinal2(k1_xboole_0,A) = k1_xboole_0 ) ).

fof(t53_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k15_ordinal2(k1_ordinal1(A),B) = k14_ordinal2(k15_ordinal2(A,B),B) ) ) ).

fof(t54_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => ( A = k1_xboole_0
              | ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C) )
                 => ( ( k1_relat_1(C) = A
                      & ! [D] :
                          ( v3_ordinal1(D)
                         => ( r2_hidden(D,A)
                           => k1_funct_1(C,D) = k15_ordinal2(D,B) ) ) )
                   => k15_ordinal2(A,B) = k3_tarski(k8_ordinal2(C)) ) ) ) ) ) ) ).

fof(t55_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k15_ordinal2(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t56_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( k15_ordinal2(k4_ordinal2,A) = A
        & k15_ordinal2(A,k4_ordinal2) = A ) ) ).

fof(t57_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(B,C)
               => ( A = k1_xboole_0
                  | r2_hidden(k15_ordinal2(B,A),k15_ordinal2(C,A)) ) ) ) ) ) ).

fof(t58_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k15_ordinal2(A,C),k15_ordinal2(B,C)) ) ) ) ) ).

fof(t59_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k15_ordinal2(C,A),k15_ordinal2(C,B)) ) ) ) ) ).

fof(t60_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k16_ordinal2(A,k1_xboole_0) = k4_ordinal2 ) ).

fof(t61_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k16_ordinal2(A,k1_ordinal1(B)) = k15_ordinal2(A,k16_ordinal2(A,B)) ) ) ).

fof(t62_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => ( A = k1_xboole_0
              | ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C) )
                 => ( ( k1_relat_1(C) = A
                      & ! [D] :
                          ( v3_ordinal1(D)
                         => ( r2_hidden(D,A)
                           => k1_funct_1(C,D) = k16_ordinal2(B,D) ) ) )
                   => k16_ordinal2(B,A) = k12_ordinal2(C) ) ) ) ) ) ) ).

fof(t63_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( k16_ordinal2(A,k4_ordinal2) = A
        & k16_ordinal2(k4_ordinal2,A) = k4_ordinal2 ) ) ).

fof(d21_ordinal2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
    <=> r2_hidden(A,k5_ordinal2) ) ).

fof(t64_ordinal2,axiom,
    $true ).

fof(t65_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ? [B] :
          ( v3_ordinal1(B)
          & ? [C] :
              ( v3_ordinal1(C)
              & v4_ordinal1(B)
              & v4_ordinal2(C)
              & A = k14_ordinal2(B,C) ) ) ) ).

fof(s1_ordinal2,axiom,
    ( ( p1_s1_ordinal2(k1_xboole_0)
      & ! [A] :
          ( v3_ordinal1(A)
         => ( p1_s1_ordinal2(A)
           => p1_s1_ordinal2(k1_ordinal1(A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( v4_ordinal1(A)
              & ! [B] :
                  ( v3_ordinal1(B)
                 => ( r2_hidden(B,A)
                   => p1_s1_ordinal2(B) ) ) )
           => ( A = k1_xboole_0
              | p1_s1_ordinal2(A) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => p1_s1_ordinal2(A) ) ) ).

fof(s2_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & k1_relat_1(A) = f1_s2_ordinal2
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(B,f1_s2_ordinal2)
           => k1_funct_1(A,B) = f2_s2_ordinal2(B) ) ) ) ).

fof(s3_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & v1_ordinal2(A)
      & k1_relat_1(A) = f1_s3_ordinal2
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(B,f1_s3_ordinal2)
           => k1_funct_1(A,B) = f2_s3_ordinal2(B) ) ) ) ).

fof(s4_ordinal2,axiom,
    ( ( k1_relat_1(f5_s4_ordinal2) = f1_s4_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s4_ordinal2)
       => k1_funct_1(f5_s4_ordinal2,k1_xboole_0) = f2_s4_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f1_s4_ordinal2)
           => k1_funct_1(f5_s4_ordinal2,k1_ordinal1(A)) = f3_s4_ordinal2(A,k1_funct_1(f5_s4_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f1_s4_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f5_s4_ordinal2,A) = f4_s4_ordinal2(A,k2_ordinal1(f5_s4_ordinal2,A)) ) ) )
      & k1_relat_1(f6_s4_ordinal2) = f1_s4_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s4_ordinal2)
       => k1_funct_1(f6_s4_ordinal2,k1_xboole_0) = f2_s4_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f1_s4_ordinal2)
           => k1_funct_1(f6_s4_ordinal2,k1_ordinal1(A)) = f3_s4_ordinal2(A,k1_funct_1(f6_s4_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f1_s4_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f6_s4_ordinal2,A) = f4_s4_ordinal2(A,k2_ordinal1(f6_s4_ordinal2,A)) ) ) ) )
   => f5_s4_ordinal2 = f6_s4_ordinal2 ) ).

fof(s5_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & k1_relat_1(A) = f1_s5_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s5_ordinal2)
       => k1_funct_1(A,k1_xboole_0) = f2_s5_ordinal2 )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(k1_ordinal1(B),f1_s5_ordinal2)
           => k1_funct_1(A,k1_ordinal1(B)) = f3_s5_ordinal2(B,k1_funct_1(A,B)) ) )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( ( r2_hidden(B,f1_s5_ordinal2)
              & v4_ordinal1(B) )
           => ( B = k1_xboole_0
              | k1_funct_1(A,B) = f4_s5_ordinal2(B,k2_ordinal1(A,B)) ) ) ) ) ).

fof(s6_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( B = f2_s6_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f4_s6_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f5_s6_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f6_s6_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
      & k1_relat_1(f1_s6_ordinal2) = f3_s6_ordinal2
      & ( r2_hidden(k1_xboole_0,f3_s6_ordinal2)
       => k1_funct_1(f1_s6_ordinal2,k1_xboole_0) = f4_s6_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f3_s6_ordinal2)
           => k1_funct_1(f1_s6_ordinal2,k1_ordinal1(A)) = f5_s6_ordinal2(A,k1_funct_1(f1_s6_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f3_s6_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f1_s6_ordinal2,A) = f6_s6_ordinal2(A,k2_ordinal1(f1_s6_ordinal2,A)) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => ( r2_hidden(A,k1_relat_1(f1_s6_ordinal2))
         => k1_funct_1(f1_s6_ordinal2,A) = f2_s6_ordinal2(A) ) ) ) ).

fof(s7_ordinal2,axiom,
    ( ? [A,B] :
        ( v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & A = k1_ordinal2(B)
        & k1_relat_1(B) = k1_ordinal1(f1_s7_ordinal2)
        & k1_funct_1(B,k1_xboole_0) = f2_s7_ordinal2
        & ! [C] :
            ( v3_ordinal1(C)
           => ( r2_hidden(k1_ordinal1(C),k1_ordinal1(f1_s7_ordinal2))
             => k1_funct_1(B,k1_ordinal1(C)) = f3_s7_ordinal2(C,k1_funct_1(B,C)) ) )
        & ! [C] :
            ( v3_ordinal1(C)
           => ( ( r2_hidden(C,k1_ordinal1(f1_s7_ordinal2))
                & v4_ordinal1(C) )
             => ( C = k1_xboole_0
                | k1_funct_1(B,C) = f4_s7_ordinal2(C,k2_ordinal1(B,C)) ) ) ) )
    & ! [A,B] :
        ~ ( ? [C] :
              ( v1_relat_1(C)
              & v1_funct_1(C)
              & v5_ordinal1(C)
              & A = k1_ordinal2(C)
              & k1_relat_1(C) = k1_ordinal1(f1_s7_ordinal2)
              & k1_funct_1(C,k1_xboole_0) = f2_s7_ordinal2
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s7_ordinal2))
                   => k1_funct_1(C,k1_ordinal1(D)) = f3_s7_ordinal2(D,k1_funct_1(C,D)) ) )
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( r2_hidden(D,k1_ordinal1(f1_s7_ordinal2))
                      & v4_ordinal1(D) )
                   => ( D = k1_xboole_0
                      | k1_funct_1(C,D) = f4_s7_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
          & ? [C] :
              ( v1_relat_1(C)
              & v1_funct_1(C)
              & v5_ordinal1(C)
              & B = k1_ordinal2(C)
              & k1_relat_1(C) = k1_ordinal1(f1_s7_ordinal2)
              & k1_funct_1(C,k1_xboole_0) = f2_s7_ordinal2
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s7_ordinal2))
                   => k1_funct_1(C,k1_ordinal1(D)) = f3_s7_ordinal2(D,k1_funct_1(C,D)) ) )
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( r2_hidden(D,k1_ordinal1(f1_s7_ordinal2))
                      & v4_ordinal1(D) )
                   => ( D = k1_xboole_0
                      | k1_funct_1(C,D) = f4_s7_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
          & A != B ) ) ).

fof(s8_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( B = f1_s8_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & B = k1_ordinal2(C)
                & k1_relat_1(C) = k1_ordinal1(A)
                & k1_funct_1(C,k1_xboole_0) = f2_s8_ordinal2
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                     => k1_funct_1(C,k1_ordinal1(D)) = f3_s8_ordinal2(D,k1_funct_1(C,D)) ) )
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( ( r2_hidden(D,k1_ordinal1(A))
                        & v4_ordinal1(D) )
                     => ( D = k1_xboole_0
                        | k1_funct_1(C,D) = f4_s8_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
   => f1_s8_ordinal2(k1_xboole_0) = f2_s8_ordinal2 ) ).

fof(s9_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( B = f4_s9_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & B = k1_ordinal2(C)
                & k1_relat_1(C) = k1_ordinal1(A)
                & k1_funct_1(C,k1_xboole_0) = f1_s9_ordinal2
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                     => k1_funct_1(C,k1_ordinal1(D)) = f2_s9_ordinal2(D,k1_funct_1(C,D)) ) )
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( ( r2_hidden(D,k1_ordinal1(A))
                        & v4_ordinal1(D) )
                     => ( D = k1_xboole_0
                        | k1_funct_1(C,D) = f3_s9_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => f4_s9_ordinal2(k1_ordinal1(A)) = f2_s9_ordinal2(A,f4_s9_ordinal2(A)) ) ) ).

fof(s10_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( B = f3_s10_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f4_s10_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f5_s10_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f6_s10_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
      & f2_s10_ordinal2 != k1_xboole_0
      & v4_ordinal1(f2_s10_ordinal2)
      & k1_relat_1(f1_s10_ordinal2) = f2_s10_ordinal2
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(A,f2_s10_ordinal2)
           => k1_funct_1(f1_s10_ordinal2,A) = f3_s10_ordinal2(A) ) ) )
   => f3_s10_ordinal2(f2_s10_ordinal2) = f6_s10_ordinal2(f2_s10_ordinal2,f1_s10_ordinal2) ) ).

fof(s11_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & v1_ordinal2(A)
      & k1_relat_1(A) = f1_s11_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s11_ordinal2)
       => k1_funct_1(A,k1_xboole_0) = f2_s11_ordinal2 )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(k1_ordinal1(B),f1_s11_ordinal2)
           => k1_funct_1(A,k1_ordinal1(B)) = f3_s11_ordinal2(B,k1_funct_1(A,B)) ) )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( ( r2_hidden(B,f1_s11_ordinal2)
              & v4_ordinal1(B) )
           => ( B = k1_xboole_0
              | k1_funct_1(A,B) = f4_s11_ordinal2(B,k2_ordinal1(A,B)) ) ) ) ) ).

fof(s12_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( v3_ordinal1(B)
             => ( B = f2_s12_ordinal2(A)
              <=> ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & B = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(A)
                    & k1_funct_1(C,k1_xboole_0) = f4_s12_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                         => k1_funct_1(C,k1_ordinal1(D)) = f5_s12_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(A))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f6_s12_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
      & k1_relat_1(f1_s12_ordinal2) = f3_s12_ordinal2
      & ( r2_hidden(k1_xboole_0,f3_s12_ordinal2)
       => k1_funct_1(f1_s12_ordinal2,k1_xboole_0) = f4_s12_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f3_s12_ordinal2)
           => k1_funct_1(f1_s12_ordinal2,k1_ordinal1(A)) = f5_s12_ordinal2(A,k1_funct_1(f1_s12_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f3_s12_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f1_s12_ordinal2,A) = f6_s12_ordinal2(A,k2_ordinal1(f1_s12_ordinal2,A)) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => ( r2_hidden(A,k1_relat_1(f1_s12_ordinal2))
         => k1_funct_1(f1_s12_ordinal2,A) = f2_s12_ordinal2(A) ) ) ) ).

fof(s13_ordinal2,axiom,
    ( ? [A] :
        ( v3_ordinal1(A)
        & ? [B] :
            ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B)
            & A = k1_ordinal2(B)
            & k1_relat_1(B) = k1_ordinal1(f1_s13_ordinal2)
            & k1_funct_1(B,k1_xboole_0) = f2_s13_ordinal2
            & ! [C] :
                ( v3_ordinal1(C)
               => ( r2_hidden(k1_ordinal1(C),k1_ordinal1(f1_s13_ordinal2))
                 => k1_funct_1(B,k1_ordinal1(C)) = f3_s13_ordinal2(C,k1_funct_1(B,C)) ) )
            & ! [C] :
                ( v3_ordinal1(C)
               => ( ( r2_hidden(C,k1_ordinal1(f1_s13_ordinal2))
                    & v4_ordinal1(C) )
                 => ( C = k1_xboole_0
                    | k1_funct_1(B,C) = f4_s13_ordinal2(C,k2_ordinal1(B,C)) ) ) ) ) )
    & ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ~ ( ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & A = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(f1_s13_ordinal2)
                    & k1_funct_1(C,k1_xboole_0) = f2_s13_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s13_ordinal2))
                         => k1_funct_1(C,k1_ordinal1(D)) = f3_s13_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(f1_s13_ordinal2))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f4_s13_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
                & ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & B = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(f1_s13_ordinal2)
                    & k1_funct_1(C,k1_xboole_0) = f2_s13_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s13_ordinal2))
                         => k1_funct_1(C,k1_ordinal1(D)) = f3_s13_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(f1_s13_ordinal2))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f4_s13_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
                & A != B ) ) ) ) ).

fof(s14_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = f1_s14_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & v1_ordinal2(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f2_s14_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f3_s14_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f4_s14_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
   => f1_s14_ordinal2(k1_xboole_0) = f2_s14_ordinal2 ) ).

fof(s15_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = f4_s15_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & v1_ordinal2(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f1_s15_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f2_s15_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f3_s15_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => f4_s15_ordinal2(k1_ordinal1(A)) = f2_s15_ordinal2(A,f4_s15_ordinal2(A)) ) ) ).

fof(s16_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( v3_ordinal1(B)
             => ( B = f3_s16_ordinal2(A)
              <=> ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & B = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(A)
                    & k1_funct_1(C,k1_xboole_0) = f4_s16_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                         => k1_funct_1(C,k1_ordinal1(D)) = f5_s16_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(A))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f6_s16_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
      & f2_s16_ordinal2 != k1_xboole_0
      & v4_ordinal1(f2_s16_ordinal2)
      & k1_relat_1(f1_s16_ordinal2) = f2_s16_ordinal2
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(A,f2_s16_ordinal2)
           => k1_funct_1(f1_s16_ordinal2,A) = f3_s16_ordinal2(A) ) ) )
   => f3_s16_ordinal2(f2_s16_ordinal2) = f6_s16_ordinal2(f2_s16_ordinal2,f1_s16_ordinal2) ) ).

fof(dt_k1_ordinal2,axiom,
    $true ).

fof(dt_k2_ordinal2,axiom,
    $true ).

fof(dt_k3_ordinal2,axiom,
    $true ).

fof(dt_k4_ordinal2,axiom,
    ( v3_ordinal1(k4_ordinal2)
    & ~ v1_xboole_0(k4_ordinal2) ) ).

fof(dt_k5_ordinal2,axiom,
    $true ).

fof(dt_k6_ordinal2,axiom,
    ! [A] : v3_ordinal1(k6_ordinal2(A)) ).

fof(dt_k7_ordinal2,axiom,
    ! [A] : v3_ordinal1(k7_ordinal2(A)) ).

fof(dt_k8_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k8_ordinal2(A)) ) ).

fof(dt_k9_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k9_ordinal2(A)) ) ).

fof(dt_k10_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k10_ordinal2(A)) ) ).

fof(dt_k11_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k11_ordinal2(A)) ) ).

fof(dt_k12_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => v3_ordinal1(k12_ordinal2(A)) ) ).

fof(dt_k13_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & v1_ordinal2(B) )
     => v3_ordinal1(k13_ordinal2(A,B)) ) ).

fof(dt_k14_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k14_ordinal2(A,B)) ) ).

fof(dt_k15_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k15_ordinal2(A,B)) ) ).

fof(dt_k16_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k16_ordinal2(A,B)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => ( v1_ordinal1(k2_xboole_0(A,B))
        & v2_ordinal1(k2_xboole_0(A,B))
        & v3_ordinal1(k2_xboole_0(A,B)) ) ) ).

fof(fc2_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => ( v1_ordinal1(k3_xboole_0(A,B))
        & v2_ordinal1(k3_xboole_0(A,B))
        & v3_ordinal1(k3_xboole_0(A,B)) ) ) ).

fof(t1_ordinal3,axiom,
    ! [A] : r1_tarski(A,k1_ordinal1(A)) ).

fof(t2_ordinal3,axiom,
    ! [A,B] :
      ( r1_tarski(k1_ordinal1(A),B)
     => r1_tarski(A,B) ) ).

fof(t3_ordinal3,axiom,
    $true ).

fof(t4_ordinal3,axiom,
    $true ).

fof(t5_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
          <=> r2_hidden(k1_ordinal1(A),k1_ordinal1(B)) ) ) ) ).

fof(t6_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r1_tarski(B,A)
         => v3_ordinal1(k3_tarski(B)) ) ) ).

fof(t7_ordinal3,axiom,
    ! [A] : v3_ordinal1(k3_tarski(k2_ordinal2(A))) ).

fof(t8_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r1_tarski(B,A)
         => k2_ordinal2(B) = B ) ) ).

fof(t9_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k2_ordinal2(k1_tarski(A)) = k1_tarski(A) ) ).

fof(t10_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( A != k1_xboole_0
       => r2_hidden(k1_xboole_0,A) ) ) ).

fof(t11_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k6_ordinal2(A) = k1_xboole_0 ) ).

fof(t12_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k6_ordinal2(k1_tarski(A)) = A ) ).

fof(t13_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r1_tarski(B,A)
         => v3_ordinal1(k1_setfam_1(B)) ) ) ).

fof(t14_ordinal3,axiom,
    $true ).

fof(t15_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( k2_xboole_0(A,B) = A
            | k2_xboole_0(A,B) = B ) ) ) ).

fof(t16_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( k3_xboole_0(A,B) = A
            | k3_xboole_0(A,B) = B ) ) ) ).

fof(t17_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( r2_hidden(A,k4_ordinal2)
       => A = k1_xboole_0 ) ) ).

fof(t18_ordinal3,axiom,
    k4_ordinal2 = k1_tarski(k1_xboole_0) ).

fof(t19_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ~ ( r1_ordinal1(A,k4_ordinal2)
          & A != k1_xboole_0
          & A != k4_ordinal2 ) ) ).

fof(t20_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ! [D] :
                  ( v3_ordinal1(D)
                 => ( r2_hidden(C,D)
                   => ( ( ~ r1_ordinal1(A,B)
                        & ~ r2_hidden(A,B) )
                      | r2_hidden(k14_ordinal2(A,C),k14_ordinal2(B,D)) ) ) ) ) ) ) ).

fof(t21_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( r1_ordinal1(A,B)
                      & r1_ordinal1(C,D) )
                   => r1_ordinal1(k14_ordinal2(A,C),k14_ordinal2(B,D)) ) ) ) ) ) ).

fof(t22_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ! [D] :
                  ( v3_ordinal1(D)
                 => ( r2_hidden(A,B)
                   => ( ( ~ ( r1_ordinal1(C,D)
                            & D != k1_xboole_0 )
                        & ~ r2_hidden(C,D) )
                      | r2_hidden(k15_ordinal2(A,C),k15_ordinal2(B,D)) ) ) ) ) ) ) ).

fof(t23_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( r1_ordinal1(A,B)
                      & r1_ordinal1(C,D) )
                   => r1_ordinal1(k15_ordinal2(A,C),k15_ordinal2(B,D)) ) ) ) ) ) ).

fof(t24_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( k14_ordinal2(A,B) = k14_ordinal2(A,C)
               => B = C ) ) ) ) ).

fof(t25_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(k14_ordinal2(A,B),k14_ordinal2(A,C))
               => r2_hidden(B,C) ) ) ) ) ).

fof(t26_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(k14_ordinal2(A,B),k14_ordinal2(A,C))
               => r1_ordinal1(B,C) ) ) ) ) ).

fof(t27_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r1_ordinal1(A,k14_ordinal2(A,B))
            & r1_ordinal1(B,k14_ordinal2(A,B)) ) ) ) ).

fof(t28_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(A,B)
               => ( r2_hidden(A,k14_ordinal2(B,C))
                  & r2_hidden(A,k14_ordinal2(C,B)) ) ) ) ) ) ).

fof(t29_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( k14_ordinal2(A,B) = k1_xboole_0
           => ( A = k1_xboole_0
              & B = k1_xboole_0 ) ) ) ) ).

fof(t30_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( r1_ordinal1(A,B)
              & ! [C] :
                  ( v3_ordinal1(C)
                 => B != k14_ordinal2(A,C) ) ) ) ) ).

fof(t31_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( r2_hidden(A,B)
              & ! [C] :
                  ( v3_ordinal1(C)
                 => ~ ( B = k14_ordinal2(A,C)
                      & C != k1_xboole_0 ) ) ) ) ) ).

fof(t32_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => ( A = k1_xboole_0
              | v4_ordinal1(k14_ordinal2(B,A)) ) ) ) ) ).

fof(t33_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => k14_ordinal2(k14_ordinal2(A,B),C) = k14_ordinal2(A,k14_ordinal2(B,C)) ) ) ) ).

fof(t34_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( k15_ordinal2(A,B) = k1_xboole_0
              & A != k1_xboole_0
              & B != k1_xboole_0 ) ) ) ).

fof(t35_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(A,B)
               => ( C = k1_xboole_0
                  | ( r2_hidden(A,k15_ordinal2(B,C))
                    & r2_hidden(A,k15_ordinal2(C,B)) ) ) ) ) ) ) ).

fof(t36_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( k15_ordinal2(A,B) = k15_ordinal2(C,B)
               => ( B = k1_xboole_0
                  | A = C ) ) ) ) ) ).

fof(t37_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(k15_ordinal2(A,B),k15_ordinal2(C,B))
               => r2_hidden(A,C) ) ) ) ) ).

fof(t38_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(k15_ordinal2(A,B),k15_ordinal2(C,B))
               => ( B = k1_xboole_0
                  | r1_ordinal1(A,C) ) ) ) ) ) ).

fof(t39_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( A != k1_xboole_0
           => ( r1_ordinal1(B,k15_ordinal2(B,A))
              & r1_ordinal1(B,k15_ordinal2(A,B)) ) ) ) ) ).

fof(t40_ordinal3,axiom,
    $true ).

fof(t41_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( k15_ordinal2(A,B) = k4_ordinal2
           => ( A = k4_ordinal2
              & B = k4_ordinal2 ) ) ) ) ).

fof(t42_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ~ ( r2_hidden(A,k14_ordinal2(B,C))
                  & ~ r2_hidden(A,B)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ~ ( r2_hidden(D,C)
                          & A = k14_ordinal2(B,D) ) ) ) ) ) ) ).

fof(d1_ordinal3,axiom,
    $true ).

fof(d2_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C) )
             => ( C = k1_ordinal3(A,B)
              <=> ( k1_relat_1(C) = k1_relat_1(B)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,k1_relat_1(B))
                       => k1_funct_1(C,D) = k14_ordinal2(A,k1_funct_1(B,D)) ) ) ) ) ) ) ) ).

fof(d3_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C) )
             => ( C = k2_ordinal3(A,B)
              <=> ( k1_relat_1(C) = k1_relat_1(B)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,k1_relat_1(B))
                       => k1_funct_1(C,D) = k14_ordinal2(k1_funct_1(B,D),A) ) ) ) ) ) ) ) ).

fof(d4_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C) )
             => ( C = k3_ordinal3(A,B)
              <=> ( k1_relat_1(C) = k1_relat_1(B)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,k1_relat_1(B))
                       => k1_funct_1(C,D) = k15_ordinal2(A,k1_funct_1(B,D)) ) ) ) ) ) ) ) ).

fof(d5_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C) )
             => ( C = k4_ordinal3(A,B)
              <=> ( k1_relat_1(C) = k1_relat_1(B)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,k1_relat_1(B))
                       => k1_funct_1(C,D) = k15_ordinal2(k1_funct_1(B,D),A) ) ) ) ) ) ) ) ).

fof(t43_ordinal3,axiom,
    $true ).

fof(t44_ordinal3,axiom,
    $true ).

fof(t45_ordinal3,axiom,
    $true ).

fof(t46_ordinal3,axiom,
    $true ).

fof(t47_ordinal3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( k1_relat_1(A) = k1_relat_1(B)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ! [E] :
                          ( v3_ordinal1(E)
                         => ( ( r2_hidden(D,k1_relat_1(A))
                              & E = k1_funct_1(A,D) )
                           => k1_funct_1(B,D) = k14_ordinal2(C,E) ) ) ) )
               => ( k1_xboole_0 = k1_relat_1(A)
                  | k8_ordinal2(B) = k14_ordinal2(C,k8_ordinal2(A)) ) ) ) ) ) ).

fof(t48_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => v4_ordinal1(k15_ordinal2(A,B)) ) ) ) ).

fof(t49_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ~ ( r2_hidden(A,k15_ordinal2(B,C))
                  & v4_ordinal1(B)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ~ ( r2_hidden(D,B)
                          & r2_hidden(A,k15_ordinal2(D,C)) ) ) ) ) ) ) ).

fof(t50_ordinal3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( k1_relat_1(A) = k1_relat_1(B)
                  & v4_ordinal1(k8_ordinal2(A))
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ! [E] :
                          ( v3_ordinal1(E)
                         => ( ( r2_hidden(D,k1_relat_1(A))
                              & E = k1_funct_1(A,D) )
                           => k1_funct_1(B,D) = k15_ordinal2(E,C) ) ) ) )
               => ( k1_xboole_0 = k1_relat_1(A)
                  | C = k1_xboole_0
                  | k8_ordinal2(B) = k15_ordinal2(k8_ordinal2(A),C) ) ) ) ) ) ).

fof(t51_ordinal3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ! [B] :
          ( v3_ordinal1(B)
         => ( k1_xboole_0 != k1_relat_1(A)
           => k8_ordinal2(k1_ordinal3(B,A)) = k14_ordinal2(B,k8_ordinal2(A)) ) ) ) ).

fof(t52_ordinal3,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(k8_ordinal2(A))
           => ( k1_xboole_0 = k1_relat_1(A)
              | B = k1_xboole_0
              | k8_ordinal2(k4_ordinal3(B,A)) = k15_ordinal2(k8_ordinal2(A),B) ) ) ) ) ).

fof(t53_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( A != k1_xboole_0
           => k3_tarski(k14_ordinal2(B,A)) = k14_ordinal2(B,k3_tarski(A)) ) ) ) ).

fof(t54_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => k15_ordinal2(k14_ordinal2(A,B),C) = k14_ordinal2(k15_ordinal2(A,C),k15_ordinal2(B,C)) ) ) ) ).

fof(t55_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( A != k1_xboole_0
              & ! [C] :
                  ( v3_ordinal1(C)
                 => ! [D] :
                      ( v3_ordinal1(D)
                     => ~ ( B = k14_ordinal2(k15_ordinal2(C,A),D)
                          & r2_hidden(D,A) ) ) ) ) ) ) ).

fof(t56_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ! [D] :
                  ( v3_ordinal1(D)
                 => ! [E] :
                      ( v3_ordinal1(E)
                     => ( ( k14_ordinal2(k15_ordinal2(B,A),C) = k14_ordinal2(k15_ordinal2(D,A),E)
                          & r2_hidden(C,A)
                          & r2_hidden(E,A) )
                       => ( B = D
                          & C = E ) ) ) ) ) ) ) ).

fof(t57_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( ( r2_hidden(k4_ordinal2,A)
              & v4_ordinal1(B) )
           => ( B = k1_xboole_0
              | ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C) )
                 => ( ( k1_relat_1(C) = B
                      & ! [D] :
                          ( v3_ordinal1(D)
                         => ( r2_hidden(D,B)
                           => k1_funct_1(C,D) = k15_ordinal2(D,A) ) ) )
                   => k15_ordinal2(B,A) = k8_ordinal2(C) ) ) ) ) ) ) ).

fof(t58_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => k15_ordinal2(k15_ordinal2(A,B),C) = k15_ordinal2(A,k15_ordinal2(B,C)) ) ) ) ).

fof(d6_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( r1_ordinal1(B,A)
                 => ( C = k5_ordinal3(A,B)
                  <=> A = k14_ordinal2(B,C) ) )
                & ( ~ r1_ordinal1(B,A)
                 => ( C = k5_ordinal3(A,B)
                  <=> C = k1_xboole_0 ) ) ) ) ) ) ).

fof(d7_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( B != k1_xboole_0
                 => ( C = k6_ordinal3(A,B)
                  <=> ? [D] :
                        ( v3_ordinal1(D)
                        & A = k14_ordinal2(k15_ordinal2(C,B),D)
                        & r2_hidden(D,B) ) ) )
                & ( B = k1_xboole_0
                 => ( C = k6_ordinal3(A,B)
                  <=> C = k1_xboole_0 ) ) ) ) ) ) ).

fof(d8_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k7_ordinal3(A,B) = k5_ordinal3(A,k15_ordinal2(k6_ordinal3(A,B),B)) ) ) ).

fof(t59_ordinal3,axiom,
    $true ).

fof(t60_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
           => B = k14_ordinal2(A,k5_ordinal3(B,A)) ) ) ) ).

fof(t61_ordinal3,axiom,
    $true ).

fof(t62_ordinal3,axiom,
    $true ).

fof(t63_ordinal3,axiom,
    $true ).

fof(t64_ordinal3,axiom,
    $true ).

fof(t65_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k5_ordinal3(k14_ordinal2(A,B),A) = B ) ) ).

fof(t66_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(A,B)
               => ( ( ~ r1_ordinal1(C,A)
                    & ~ r2_hidden(C,A) )
                  | r2_hidden(k5_ordinal3(A,C),k5_ordinal3(B,C)) ) ) ) ) ) ).

fof(t67_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k5_ordinal3(A,A) = k1_xboole_0 ) ).

fof(t68_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
           => ( k5_ordinal3(B,A) != k1_xboole_0
              & r2_hidden(k1_xboole_0,k5_ordinal3(B,A)) ) ) ) ) ).

fof(t69_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( k5_ordinal3(A,k1_xboole_0) = A
        & k5_ordinal3(k1_xboole_0,A) = k1_xboole_0 ) ) ).

fof(t70_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => k5_ordinal3(A,k14_ordinal2(B,C)) = k5_ordinal3(k5_ordinal3(A,B),C) ) ) ) ).

fof(t71_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k5_ordinal3(C,B),k5_ordinal3(C,A)) ) ) ) ) ).

fof(t72_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k5_ordinal3(A,C),k5_ordinal3(B,C)) ) ) ) ) ).

fof(t73_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(B,k14_ordinal2(C,A))
               => ( A = k1_xboole_0
                  | r2_hidden(k5_ordinal3(B,C),A) ) ) ) ) ) ).

fof(t74_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(k14_ordinal2(A,B),C)
               => r2_hidden(B,k5_ordinal3(C,A)) ) ) ) ) ).

fof(t75_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => r1_ordinal1(A,k14_ordinal2(B,k5_ordinal3(A,B))) ) ) ).

fof(t76_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => k5_ordinal3(k15_ordinal2(A,B),k15_ordinal2(C,B)) = k15_ordinal2(k5_ordinal3(A,C),B) ) ) ) ).

fof(t77_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => r1_ordinal1(k15_ordinal2(k6_ordinal3(A,B),B),A) ) ) ).

fof(t78_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => A = k14_ordinal2(k15_ordinal2(k6_ordinal3(A,B),B),k7_ordinal3(A,B)) ) ) ).

fof(t79_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( A = k14_ordinal2(k15_ordinal2(B,C),D)
                      & r2_hidden(D,C) )
                   => ( B = k6_ordinal3(A,C)
                      & D = k7_ordinal3(A,C) ) ) ) ) ) ) ).

fof(t80_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(A,k15_ordinal2(B,C))
               => ( r2_hidden(k6_ordinal3(A,C),B)
                  & r2_hidden(k7_ordinal3(A,C),C) ) ) ) ) ) ).

fof(t81_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( A != k1_xboole_0
           => k6_ordinal3(k15_ordinal2(B,A),A) = B ) ) ) ).

fof(t82_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k7_ordinal3(k15_ordinal2(A,B),B) = k1_xboole_0 ) ) ).

fof(t83_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( k6_ordinal3(k1_xboole_0,A) = k1_xboole_0
        & k7_ordinal3(k1_xboole_0,A) = k1_xboole_0
        & k7_ordinal3(A,k1_xboole_0) = A ) ) ).

fof(t84_ordinal3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( k6_ordinal3(A,k4_ordinal2) = A
        & k7_ordinal3(A,k4_ordinal2) = k1_xboole_0 ) ) ).

fof(dt_k1_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & v1_ordinal2(B) )
     => ( v1_relat_1(k1_ordinal3(A,B))
        & v1_funct_1(k1_ordinal3(A,B))
        & v5_ordinal1(k1_ordinal3(A,B))
        & v1_ordinal2(k1_ordinal3(A,B)) ) ) ).

fof(dt_k2_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & v1_ordinal2(B) )
     => ( v1_relat_1(k2_ordinal3(A,B))
        & v1_funct_1(k2_ordinal3(A,B))
        & v5_ordinal1(k2_ordinal3(A,B))
        & v1_ordinal2(k2_ordinal3(A,B)) ) ) ).

fof(dt_k3_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & v1_ordinal2(B) )
     => ( v1_relat_1(k3_ordinal3(A,B))
        & v1_funct_1(k3_ordinal3(A,B))
        & v5_ordinal1(k3_ordinal3(A,B))
        & v1_ordinal2(k3_ordinal3(A,B)) ) ) ).

fof(dt_k4_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & v1_ordinal2(B) )
     => ( v1_relat_1(k4_ordinal3(A,B))
        & v1_funct_1(k4_ordinal3(A,B))
        & v5_ordinal1(k4_ordinal3(A,B))
        & v1_ordinal2(k4_ordinal3(A,B)) ) ) ).

fof(dt_k5_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k5_ordinal3(A,B)) ) ).

fof(dt_k6_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k6_ordinal3(A,B)) ) ).

fof(dt_k7_ordinal3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k7_ordinal3(A,B)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ( v1_ordinal1(B)
            & v2_ordinal1(B)
            & v3_ordinal1(B) ) ) ) ).

fof(cc2_arytm_3,axiom,
    ! [A] :
      ( ( v1_xboole_0(A)
        & v3_ordinal1(A) )
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A)
        & v4_ordinal2(A) ) ) ).

fof(fc1_arytm_3,axiom,
    ( ~ v1_xboole_0(k4_ordinal2)
    & v1_ordinal1(k4_ordinal2)
    & v2_ordinal1(k4_ordinal2)
    & v3_ordinal1(k4_ordinal2)
    & v4_ordinal2(k4_ordinal2) ) ).

fof(cc3_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_ordinal2)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A)
        & v4_ordinal2(A) ) ) ).

fof(rc1_arytm_3,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A)
      & v4_ordinal2(A) ) ).

fof(fc2_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( ~ v1_xboole_0(k1_ordinal1(A))
        & v1_ordinal1(k1_ordinal1(A))
        & v2_ordinal1(k1_ordinal1(A))
        & v3_ordinal1(k1_ordinal1(A))
        & v4_ordinal2(k1_ordinal1(A)) ) ) ).

fof(fc3_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => ( v1_ordinal1(k14_ordinal2(A,B))
        & v2_ordinal1(k14_ordinal2(A,B))
        & v3_ordinal1(k14_ordinal2(A,B))
        & v4_ordinal2(k14_ordinal2(A,B)) ) ) ).

fof(fc4_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => ( v1_ordinal1(k5_ordinal3(A,B))
        & v2_ordinal1(k5_ordinal3(A,B))
        & v3_ordinal1(k5_ordinal3(A,B))
        & v4_ordinal2(k5_ordinal3(A,B)) ) ) ).

fof(fc5_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => ( v1_ordinal1(k15_ordinal2(A,B))
        & v2_ordinal1(k15_ordinal2(A,B))
        & v3_ordinal1(k15_ordinal2(A,B))
        & v4_ordinal2(k15_ordinal2(A,B)) ) ) ).

fof(fc6_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => ( v1_ordinal1(k6_ordinal3(A,B))
        & v2_ordinal1(k6_ordinal3(A,B))
        & v3_ordinal1(k6_ordinal3(A,B))
        & v4_ordinal2(k6_ordinal3(A,B)) ) ) ).

fof(fc7_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => ( v1_ordinal1(k7_ordinal3(A,B))
        & v2_ordinal1(k7_ordinal3(A,B))
        & v3_ordinal1(k7_ordinal3(A,B))
        & v4_ordinal2(k7_ordinal3(A,B)) ) ) ).

fof(fc8_arytm_3,axiom,
    ~ v1_xboole_0(k6_arytm_3) ).

fof(rc2_arytm_3,axiom,
    ? [A] :
      ( m1_subset_1(A,k6_arytm_3)
      & ~ v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A) ) ).

fof(cc4_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ( v3_ordinal1(A)
       => ( v1_ordinal1(A)
          & v2_ordinal1(A)
          & v3_ordinal1(A)
          & v4_ordinal2(A) ) ) ) ).

fof(rc3_arytm_3,axiom,
    ? [A] :
      ( m1_subset_1(A,k6_arytm_3)
      & v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A)
      & v4_ordinal2(A) ) ).

fof(t1_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal2(k14_ordinal2(A,B))
           => ( r2_hidden(A,k5_ordinal2)
              & r2_hidden(B,k5_ordinal2) ) ) ) ) ).

fof(t2_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal2(k15_ordinal2(A,B))
           => ( v1_xboole_0(k15_ordinal2(A,B))
              | ( r2_hidden(A,k5_ordinal2)
                & r2_hidden(B,k5_ordinal2) ) ) ) ) ) ).

fof(t3_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => k14_ordinal2(A,B) = k14_ordinal2(B,A) ) ) ).

fof(t4_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => k15_ordinal2(A,B) = k15_ordinal2(B,A) ) ) ).

fof(d1_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r1_arytm_3(A,B)
          <=> ! [C] :
                ( v3_ordinal1(C)
               => ! [D] :
                    ( v3_ordinal1(D)
                   => ! [E] :
                        ( v3_ordinal1(E)
                       => ( ( A = k15_ordinal2(C,D)
                            & B = k15_ordinal2(C,E) )
                         => C = k4_ordinal2 ) ) ) ) ) ) ) ).

fof(t5_arytm_3,axiom,
    ~ r1_arytm_3(k1_xboole_0,k1_xboole_0) ).

fof(t6_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => r1_arytm_3(k4_ordinal2,A) ) ).

fof(t7_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( r1_arytm_3(k1_xboole_0,A)
       => A = k4_ordinal2 ) ) ).

fof(t8_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ~ ( ~ ( A = k1_xboole_0
                  & B = k1_xboole_0 )
              & ! [C] :
                  ( ( v3_ordinal1(C)
                    & v4_ordinal2(C) )
                 => ! [D] :
                      ( ( v3_ordinal1(D)
                        & v4_ordinal2(D) )
                     => ! [E] :
                          ( ( v3_ordinal1(E)
                            & v4_ordinal2(E) )
                         => ~ ( r1_arytm_3(D,E)
                              & A = k2_arytm_3(C,D)
                              & B = k2_arytm_3(C,E) ) ) ) ) ) ) ) ).

fof(d2_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_arytm_3(A,B)
          <=> ? [C] :
                ( v3_ordinal1(C)
                & B = k15_ordinal2(A,C) ) ) ) ) ).

fof(t9_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( r2_arytm_3(A,B)
          <=> ? [C] :
                ( v3_ordinal1(C)
                & v4_ordinal2(C)
                & B = k2_arytm_3(A,C) ) ) ) ) ).

fof(t10_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( r2_hidden(k1_xboole_0,A)
           => r2_hidden(k7_ordinal3(B,A),A) ) ) ) ).

fof(t11_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( r2_arytm_3(B,A)
          <=> A = k2_arytm_3(B,k6_ordinal3(A,B)) ) ) ) ).

fof(t12_arytm_3,axiom,
    $true ).

fof(t13_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( ( r2_arytm_3(A,B)
              & r2_arytm_3(B,A) )
           => A = B ) ) ) ).

fof(t14_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( r2_arytm_3(A,k1_xboole_0)
        & r2_arytm_3(k4_ordinal2,A) ) ) ).

fof(t15_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( ( r2_hidden(k1_xboole_0,B)
              & r2_arytm_3(A,B) )
           => r1_ordinal1(A,B) ) ) ) ).

fof(t16_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => ( ( r2_arytm_3(A,B)
                  & r2_arytm_3(A,k1_arytm_3(B,C)) )
               => r2_arytm_3(A,C) ) ) ) ) ).

fof(d3_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( m1_subset_1(C,k5_ordinal2)
             => ( C = k3_arytm_3(A,B)
              <=> ( r2_arytm_3(A,C)
                  & r2_arytm_3(B,C)
                  & ! [D] :
                      ( ( v3_ordinal1(D)
                        & v4_ordinal2(D) )
                     => ( ( r2_arytm_3(A,D)
                          & r2_arytm_3(B,D) )
                       => r2_arytm_3(C,D) ) ) ) ) ) ) ) ).

fof(t17_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => r2_arytm_3(k3_arytm_3(A,B),k2_arytm_3(A,B)) ) ) ).

fof(t18_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( A != k1_xboole_0
           => r2_arytm_3(k6_ordinal3(k2_arytm_3(B,A),k3_arytm_3(B,A)),B) ) ) ) ).

fof(d4_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( m1_subset_1(C,k5_ordinal2)
             => ( C = k4_arytm_3(A,B)
              <=> ( r2_arytm_3(C,A)
                  & r2_arytm_3(C,B)
                  & ! [D] :
                      ( ( v3_ordinal1(D)
                        & v4_ordinal2(D) )
                     => ( ( r2_arytm_3(D,A)
                          & r2_arytm_3(D,B) )
                       => r2_arytm_3(D,C) ) ) ) ) ) ) ) ).

fof(t19_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( k4_arytm_3(A,k1_xboole_0) = A
        & k3_arytm_3(A,k1_xboole_0) = k1_xboole_0 ) ) ).

fof(t20_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( k4_arytm_3(A,B) = k1_xboole_0
           => A = k1_xboole_0 ) ) ) ).

fof(t21_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( k4_arytm_3(A,A) = A
        & k3_arytm_3(A,A) = A ) ) ).

fof(t22_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => k4_arytm_3(k2_arytm_3(A,B),k2_arytm_3(C,B)) = k2_arytm_3(k4_arytm_3(A,C),B) ) ) ) ).

fof(t23_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( A != k1_xboole_0
           => ( k4_arytm_3(B,A) != k1_xboole_0
              & k6_ordinal3(A,k4_arytm_3(B,A)) != k1_xboole_0 ) ) ) ) ).

fof(t24_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( ~ ( A = k1_xboole_0
                & B = k1_xboole_0 )
           => r1_arytm_3(k6_ordinal3(A,k4_arytm_3(A,B)),k6_ordinal3(B,k4_arytm_3(A,B))) ) ) ) ).

fof(t25_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( r1_arytm_3(A,B)
          <=> k4_arytm_3(A,B) = k4_ordinal2 ) ) ) ).

fof(d5_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => k5_arytm_3(A,B) = k6_ordinal3(A,k4_arytm_3(A,B)) ) ) ).

fof(t26_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => k2_arytm_3(k5_arytm_3(A,B),k4_arytm_3(A,B)) = A ) ) ).

fof(t27_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( ~ ( A = k1_xboole_0
                & B = k1_xboole_0 )
           => r1_arytm_3(k5_arytm_3(A,B),k5_arytm_3(B,A)) ) ) ) ).

fof(t28_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( r1_arytm_3(A,B)
           => k5_arytm_3(A,B) = A ) ) ) ).

fof(t29_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( k5_arytm_3(A,k4_ordinal2) = A
        & k5_arytm_3(k4_ordinal2,A) = k4_ordinal2 ) ) ).

fof(t30_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ~ ( A != k1_xboole_0
              & k5_arytm_3(A,B) = k1_xboole_0 ) ) ) ).

fof(t31_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( k5_arytm_3(k1_xboole_0,A) = k1_xboole_0
        & ( A != k1_xboole_0
         => k5_arytm_3(A,k1_xboole_0) = k4_ordinal2 ) ) ) ).

fof(t32_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( A != k1_xboole_0
       => k5_arytm_3(A,A) = k4_ordinal2 ) ) ).

fof(t33_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => ( A != k1_xboole_0
               => k5_arytm_3(k2_arytm_3(B,A),k2_arytm_3(C,A)) = k5_arytm_3(B,C) ) ) ) ) ).

fof(t34_arytm_3,axiom,
    r1_tarski(k5_ordinal2,k6_arytm_3) ).

fof(t35_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ~ ( ~ r2_hidden(A,k5_ordinal2)
          & ! [B] :
              ( m1_subset_1(B,k5_ordinal2)
             => ! [C] :
                  ( m1_subset_1(C,k5_ordinal2)
                 => ~ ( A = k4_tarski(B,C)
                      & r1_arytm_3(B,C)
                      & C != k1_xboole_0
                      & C != k4_ordinal2 ) ) ) ) ) ).

fof(t36_arytm_3,axiom,
    ! [A,B] : ~ v3_ordinal1(k4_tarski(A,B)) ).

fof(t37_arytm_3,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( r2_hidden(A,k6_arytm_3)
       => r2_hidden(A,k5_ordinal2) ) ) ).

fof(t38_arytm_3,axiom,
    ! [A,B] : ~ r2_hidden(k4_tarski(A,B),k5_ordinal2) ).

fof(t39_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_ordinal2)
     => ! [B] :
          ( m1_subset_1(B,k5_ordinal2)
         => ( r2_hidden(k4_tarski(A,B),k6_arytm_3)
          <=> ( r1_arytm_3(A,B)
              & B != k1_xboole_0
              & B != k4_ordinal2 ) ) ) ) ).

fof(d7_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k5_ordinal2)
         => ( ( r2_hidden(A,k5_ordinal2)
             => ( B = k7_arytm_3(A)
              <=> B = A ) )
            & ( ~ r2_hidden(A,k5_ordinal2)
             => ( B = k7_arytm_3(A)
              <=> ? [C] :
                    ( v3_ordinal1(C)
                    & v4_ordinal2(C)
                    & A = k4_tarski(B,C) ) ) ) ) ) ) ).

fof(d8_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k5_ordinal2)
         => ( ( r2_hidden(A,k5_ordinal2)
             => ( B = k8_arytm_3(A)
              <=> B = k4_ordinal2 ) )
            & ( ~ r2_hidden(A,k5_ordinal2)
             => ( B = k8_arytm_3(A)
              <=> ? [C] :
                    ( v3_ordinal1(C)
                    & v4_ordinal2(C)
                    & A = k4_tarski(C,B) ) ) ) ) ) ) ).

fof(t40_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => r1_arytm_3(k7_arytm_3(A),k8_arytm_3(A)) ) ).

fof(t41_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => k8_arytm_3(A) != k1_xboole_0 ) ).

fof(t42_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ( ~ r2_hidden(A,k5_ordinal2)
       => ( A = k4_tarski(k7_arytm_3(A),k8_arytm_3(A))
          & k8_arytm_3(A) != k4_ordinal2 ) ) ) ).

fof(t43_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ( ~ ( A != k1_xboole_0
            & k7_arytm_3(A) = k1_xboole_0 )
        & ~ ( k7_arytm_3(A) != k1_xboole_0
            & A = k1_xboole_0 ) ) ) ).

fof(t44_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ( r2_hidden(A,k5_ordinal2)
      <=> k8_arytm_3(A) = k4_ordinal2 ) ) ).

fof(d9_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( ( B = k1_xboole_0
             => k9_arytm_3(A,B) = k1_xboole_0 )
            & ( k5_arytm_3(B,A) = k4_ordinal2
             => k9_arytm_3(A,B) = k5_arytm_3(A,B) )
            & ~ ( B != k1_xboole_0
                & k5_arytm_3(B,A) != k4_ordinal2
                & k9_arytm_3(A,B) != k4_tarski(k5_arytm_3(A,B),k5_arytm_3(B,A)) ) ) ) ) ).

fof(t45_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => k9_arytm_3(k7_arytm_3(A),k8_arytm_3(A)) = A ) ).

fof(t46_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( k9_arytm_3(k1_xboole_0,A) = k1_xboole_0
            & k9_arytm_3(B,k4_ordinal2) = B ) ) ) ).

fof(t47_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ( A != k1_xboole_0
       => k9_arytm_3(A,A) = k4_ordinal2 ) ) ).

fof(t48_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ( A != k1_xboole_0
           => ( k7_arytm_3(k9_arytm_3(B,A)) = k5_arytm_3(B,A)
              & k8_arytm_3(k9_arytm_3(B,A)) = k5_arytm_3(A,B) ) ) ) ) ).

fof(t49_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_ordinal2)
     => ! [B] :
          ( m1_subset_1(B,k5_ordinal2)
         => ( r1_arytm_3(A,B)
           => ( B = k1_xboole_0
              | ( k7_arytm_3(k9_arytm_3(A,B)) = A
                & k8_arytm_3(k9_arytm_3(A,B)) = B ) ) ) ) ) ).

fof(t50_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => ( A != k1_xboole_0
               => k9_arytm_3(k2_arytm_3(B,A),k2_arytm_3(C,A)) = k9_arytm_3(B,C) ) ) ) ) ).

fof(t51_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => ! [D] :
                  ( ( v3_ordinal1(D)
                    & v4_ordinal2(D) )
                 => ~ ( B != k1_xboole_0
                      & A != k1_xboole_0
                      & ~ ( k9_arytm_3(C,B) = k9_arytm_3(D,A)
                        <=> k2_arytm_3(C,A) = k2_arytm_3(B,D) ) ) ) ) ) ) ).

fof(d10_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => k10_arytm_3(A,B) = k9_arytm_3(k1_arytm_3(k2_arytm_3(k7_arytm_3(A),k8_arytm_3(B)),k2_arytm_3(k7_arytm_3(B),k8_arytm_3(A))),k2_arytm_3(k8_arytm_3(A),k8_arytm_3(B))) ) ) ).

fof(d11_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => k11_arytm_3(A,B) = k9_arytm_3(k2_arytm_3(k7_arytm_3(A),k7_arytm_3(B)),k2_arytm_3(k8_arytm_3(A),k8_arytm_3(B))) ) ) ).

fof(t52_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => ! [D] :
                  ( ( v3_ordinal1(D)
                    & v4_ordinal2(D) )
                 => ~ ( B != k1_xboole_0
                      & A != k1_xboole_0
                      & k10_arytm_3(k9_arytm_3(C,B),k9_arytm_3(D,A)) != k9_arytm_3(k1_arytm_3(k2_arytm_3(C,A),k2_arytm_3(B,D)),k2_arytm_3(B,A)) ) ) ) ) ) ).

fof(t53_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => ( A != k1_xboole_0
               => k10_arytm_3(k9_arytm_3(B,A),k9_arytm_3(C,A)) = k9_arytm_3(k1_arytm_3(B,C),A) ) ) ) ) ).

fof(t54_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => k11_arytm_3(A,k12_arytm_3) = k12_arytm_3 ) ).

fof(t55_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & v4_ordinal2(B) )
         => ! [C] :
              ( ( v3_ordinal1(C)
                & v4_ordinal2(C) )
             => ! [D] :
                  ( ( v3_ordinal1(D)
                    & v4_ordinal2(D) )
                 => k11_arytm_3(k9_arytm_3(B,C),k9_arytm_3(D,A)) = k9_arytm_3(k2_arytm_3(B,D),k2_arytm_3(C,A)) ) ) ) ) ).

fof(t56_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => k10_arytm_3(A,k12_arytm_3) = A ) ).

fof(t57_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => k10_arytm_3(k10_arytm_3(A,B),C) = k10_arytm_3(A,k10_arytm_3(B,C)) ) ) ) ).

fof(t58_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => k11_arytm_3(k11_arytm_3(A,B),C) = k11_arytm_3(A,k11_arytm_3(B,C)) ) ) ) ).

fof(t59_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => k11_arytm_3(A,k13_arytm_3) = A ) ).

fof(t60_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ~ ( A != k12_arytm_3
          & ! [B] :
              ( m1_subset_1(B,k6_arytm_3)
             => k11_arytm_3(A,B) != k13_arytm_3 ) ) ) ).

fof(t61_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ~ ( A != k12_arytm_3
              & ! [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                 => B != k11_arytm_3(A,C) ) ) ) ) ).

fof(t62_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ( k11_arytm_3(A,B) = k11_arytm_3(A,C)
               => ( A = k12_arytm_3
                  | B = C ) ) ) ) ) ).

fof(t63_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => k11_arytm_3(A,k10_arytm_3(B,C)) = k10_arytm_3(k11_arytm_3(A,B),k11_arytm_3(A,C)) ) ) ) ).

fof(t64_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & m1_subset_1(A,k6_arytm_3) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & m1_subset_1(B,k6_arytm_3) )
         => k10_arytm_3(A,B) = k1_arytm_3(A,B) ) ) ).

fof(t65_arytm_3,axiom,
    ! [A] :
      ( ( v3_ordinal1(A)
        & m1_subset_1(A,k6_arytm_3) )
     => ! [B] :
          ( ( v3_ordinal1(B)
            & m1_subset_1(B,k6_arytm_3) )
         => k11_arytm_3(A,B) = k2_arytm_3(A,B) ) ) ).

fof(t66_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ? [B] :
          ( m1_subset_1(B,k6_arytm_3)
          & A = k10_arytm_3(B,B) ) ) ).

fof(d12_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ( r3_arytm_3(A,B)
          <=> ? [C] :
                ( m1_subset_1(C,k6_arytm_3)
                & B = k10_arytm_3(A,C) ) ) ) ) ).

fof(t67_arytm_3,axiom,
    $true ).

fof(t68_arytm_3,axiom,
    ! [A] : ~ r2_hidden(k4_tarski(k12_arytm_3,A),k6_arytm_3) ).

fof(t69_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ( k10_arytm_3(A,B) = k10_arytm_3(C,B)
               => A = C ) ) ) ) ).

fof(t70_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ( k10_arytm_3(A,B) = k12_arytm_3
           => A = k12_arytm_3 ) ) ) ).

fof(t71_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => r3_arytm_3(k12_arytm_3,A) ) ).

fof(t72_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ( r3_arytm_3(A,k12_arytm_3)
       => A = k12_arytm_3 ) ) ).

fof(t73_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ( ( r3_arytm_3(A,B)
              & r3_arytm_3(B,A) )
           => A = B ) ) ) ).

fof(t74_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ( ( r3_arytm_3(A,B)
                  & r3_arytm_3(B,C) )
               => r3_arytm_3(A,C) ) ) ) ) ).

fof(t75_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ( ~ r3_arytm_3(B,A)
          <=> ( r3_arytm_3(A,B)
              & A != B ) ) ) ) ).

fof(t76_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( ( ( ~ r3_arytm_3(B,A)
                      & r3_arytm_3(B,C) )
                    | ( r3_arytm_3(A,B)
                      & ~ r3_arytm_3(C,B) ) )
                  & r3_arytm_3(C,A) ) ) ) ) ).

fof(t77_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( ~ r3_arytm_3(B,A)
                  & ~ r3_arytm_3(C,B)
                  & r3_arytm_3(C,A) ) ) ) ) ).

fof(t78_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ( ( r2_hidden(A,k5_ordinal2)
              & r2_hidden(k10_arytm_3(A,B),k5_ordinal2) )
           => r2_hidden(B,k5_ordinal2) ) ) ) ).

fof(t79_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( ( v3_ordinal1(B)
            & m1_subset_1(B,k6_arytm_3) )
         => ~ ( ~ r3_arytm_3(A,B)
              & ~ r3_arytm_3(k10_arytm_3(B,k13_arytm_3),A)
              & r2_hidden(A,k5_ordinal2) ) ) ) ).

fof(t80_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ~ ( A != k12_arytm_3
          & ! [B] :
              ( m1_subset_1(B,k6_arytm_3)
             => ~ ( ~ r3_arytm_3(A,B)
                  & ~ r2_hidden(B,k5_ordinal2) ) ) ) ) ).

fof(t82_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k6_arytm_3))
     => ~ ( ? [B] :
              ( m1_subset_1(B,k6_arytm_3)
              & r2_hidden(B,A)
              & B != k12_arytm_3 )
          & ! [B] :
              ( m1_subset_1(B,k6_arytm_3)
             => ! [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                 => ( ( r2_hidden(B,A)
                      & r3_arytm_3(C,B) )
                   => r2_hidden(C,A) ) ) )
          & ! [B] :
              ( m1_subset_1(B,k6_arytm_3)
             => ! [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                 => ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ~ ( r2_hidden(B,A)
                          & r2_hidden(C,A)
                          & r2_hidden(D,A)
                          & B != C
                          & C != D
                          & D != B ) ) ) ) ) ) ).

fof(t83_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ( r3_arytm_3(k10_arytm_3(A,B),k10_arytm_3(C,B))
              <=> r3_arytm_3(A,C) ) ) ) ) ).

fof(t84_arytm_3,axiom,
    $true ).

fof(t85_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => r3_arytm_3(A,k10_arytm_3(A,B)) ) ) ).

fof(t86_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ~ ( k11_arytm_3(A,B) = k12_arytm_3
              & A != k12_arytm_3
              & B != k12_arytm_3 ) ) ) ).

fof(t87_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( r3_arytm_3(A,k11_arytm_3(B,C))
                  & ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ~ ( A = k11_arytm_3(B,D)
                          & r3_arytm_3(D,C) ) ) ) ) ) ) ).

fof(t88_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ( r3_arytm_3(k11_arytm_3(B,A),k11_arytm_3(C,A))
               => ( A = k12_arytm_3
                  | r3_arytm_3(B,C) ) ) ) ) ) ).

fof(t89_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ! [D] :
                  ( m1_subset_1(D,k6_arytm_3)
                 => ~ ( k10_arytm_3(A,B) = k10_arytm_3(C,D)
                      & ~ r3_arytm_3(A,C)
                      & ~ r3_arytm_3(B,D) ) ) ) ) ) ).

fof(t90_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ( r3_arytm_3(A,B)
               => r3_arytm_3(k11_arytm_3(A,C),k11_arytm_3(B,C)) ) ) ) ) ).

fof(t91_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ! [D] :
                  ( m1_subset_1(D,k6_arytm_3)
                 => ~ ( k11_arytm_3(A,B) = k11_arytm_3(C,D)
                      & ~ r3_arytm_3(A,C)
                      & ~ r3_arytm_3(B,D) ) ) ) ) ) ).

fof(t92_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ( A = k12_arytm_3
          <=> k10_arytm_3(A,B) = B ) ) ) ).

fof(t93_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ! [D] :
                  ( m1_subset_1(D,k6_arytm_3)
                 => ( ( k10_arytm_3(A,B) = k10_arytm_3(C,D)
                      & r3_arytm_3(A,C) )
                   => r3_arytm_3(D,B) ) ) ) ) ) ).

fof(t94_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( r3_arytm_3(A,B)
                  & r3_arytm_3(B,k10_arytm_3(A,C))
                  & ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ~ ( B = k10_arytm_3(A,D)
                          & r3_arytm_3(D,C) ) ) ) ) ) ) ).

fof(t95_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( r3_arytm_3(A,k10_arytm_3(B,C))
                  & ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ! [E] :
                          ( m1_subset_1(E,k6_arytm_3)
                         => ~ ( A = k10_arytm_3(D,E)
                              & r3_arytm_3(D,B)
                              & r3_arytm_3(E,C) ) ) ) ) ) ) ) ).

fof(t96_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( ~ r3_arytm_3(B,A)
                  & ~ r3_arytm_3(C,A)
                  & ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ~ ( r3_arytm_3(D,B)
                          & r3_arytm_3(D,C)
                          & ~ r3_arytm_3(D,A) ) ) ) ) ) ) ).

fof(t97_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( r3_arytm_3(A,B)
                  & r3_arytm_3(B,C)
                  & B != C
                  & A = C ) ) ) ) ).

fof(t98_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ~ ( ~ r3_arytm_3(k10_arytm_3(B,C),A)
                  & C != k12_arytm_3
                  & ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ! [E] :
                          ( m1_subset_1(E,k6_arytm_3)
                         => ~ ( A = k10_arytm_3(D,E)
                              & r3_arytm_3(D,B)
                              & r3_arytm_3(E,C)
                              & E != C ) ) ) ) ) ) ) ).

fof(t99_arytm_3,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(A,k1_zfmisc_1(k6_arytm_3)) )
     => ~ ( r2_hidden(A,k6_arytm_3)
          & ! [B] :
              ( m1_subset_1(B,k6_arytm_3)
             => ~ ( r2_hidden(B,A)
                  & ! [C] :
                      ( m1_subset_1(C,k6_arytm_3)
                     => ( r2_hidden(C,A)
                       => r3_arytm_3(C,B) ) ) ) ) ) ) ).

fof(t100_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ~ ! [C] :
                ( m1_subset_1(C,k6_arytm_3)
               => ( k10_arytm_3(A,C) != B
                  & k10_arytm_3(B,C) != A ) ) ) ) ).

fof(t101_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ~ ( ~ r3_arytm_3(B,A)
              & ! [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                 => ~ ( ~ r3_arytm_3(C,A)
                      & ~ r3_arytm_3(B,C) ) ) ) ) ) ).

fof(t102_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ~ ! [B] :
            ( m1_subset_1(B,k6_arytm_3)
           => r3_arytm_3(B,A) ) ) ).

fof(t103_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ! [B] :
          ( m1_subset_1(B,k6_arytm_3)
         => ~ ( A != k12_arytm_3
              & ! [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                 => ~ ( r2_hidden(C,k5_ordinal2)
                      & r3_arytm_3(B,k11_arytm_3(C,A)) ) ) ) ) ) ).

fof(s1_arytm_3,axiom,
    ( ( p1_s1_arytm_3(k1_xboole_0)
      & ! [A] :
          ( ( v3_ordinal1(A)
            & v4_ordinal2(A) )
         => ( p1_s1_arytm_3(A)
           => p1_s1_arytm_3(k1_ordinal1(A)) ) ) )
   => ! [A] :
        ( ( v3_ordinal1(A)
          & v4_ordinal2(A) )
       => p1_s1_arytm_3(A) ) ) ).

fof(s2_arytm_3,axiom,
    ( ( f2_s2_arytm_3 = k13_arytm_3
      & f1_s2_arytm_3 = k12_arytm_3
      & r2_hidden(f3_s2_arytm_3,k5_ordinal2)
      & p1_s2_arytm_3(f1_s2_arytm_3)
      & ~ p1_s2_arytm_3(f3_s2_arytm_3) )
   => ? [A] :
        ( m1_subset_1(A,k6_arytm_3)
        & r2_hidden(A,k5_ordinal2)
        & p1_s2_arytm_3(A)
        & ~ p1_s2_arytm_3(k10_arytm_3(A,f2_s2_arytm_3)) ) ) ).

fof(symmetry_r1_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => ( r1_arytm_3(A,B)
       => r1_arytm_3(B,A) ) ) ).

fof(reflexivity_r2_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => r2_arytm_3(A,A) ) ).

fof(connectedness_r3_arytm_3,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k6_arytm_3)
        & m1_subset_1(B,k6_arytm_3) )
     => ( r3_arytm_3(A,B)
        | r3_arytm_3(B,A) ) ) ).

fof(dt_k1_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => v3_ordinal1(k1_arytm_3(A,B)) ) ).

fof(commutativity_k1_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => k1_arytm_3(A,B) = k1_arytm_3(B,A) ) ).

fof(redefinition_k1_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => k1_arytm_3(A,B) = k14_ordinal2(A,B) ) ).

fof(dt_k2_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => v3_ordinal1(k2_arytm_3(A,B)) ) ).

fof(commutativity_k2_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => k2_arytm_3(A,B) = k2_arytm_3(B,A) ) ).

fof(redefinition_k2_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => k2_arytm_3(A,B) = k15_ordinal2(A,B) ) ).

fof(dt_k3_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => m1_subset_1(k3_arytm_3(A,B),k5_ordinal2) ) ).

fof(commutativity_k3_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => k3_arytm_3(A,B) = k3_arytm_3(B,A) ) ).

fof(dt_k4_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => m1_subset_1(k4_arytm_3(A,B),k5_ordinal2) ) ).

fof(commutativity_k4_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => k4_arytm_3(A,B) = k4_arytm_3(B,A) ) ).

fof(dt_k5_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => m1_subset_1(k5_arytm_3(A,B),k5_ordinal2) ) ).

fof(dt_k6_arytm_3,axiom,
    $true ).

fof(dt_k7_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => m1_subset_1(k7_arytm_3(A),k5_ordinal2) ) ).

fof(dt_k8_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => m1_subset_1(k8_arytm_3(A),k5_ordinal2) ) ).

fof(dt_k9_arytm_3,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v4_ordinal2(A)
        & v3_ordinal1(B)
        & v4_ordinal2(B) )
     => m1_subset_1(k9_arytm_3(A,B),k6_arytm_3) ) ).

fof(dt_k10_arytm_3,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k6_arytm_3)
        & m1_subset_1(B,k6_arytm_3) )
     => m1_subset_1(k10_arytm_3(A,B),k6_arytm_3) ) ).

fof(commutativity_k10_arytm_3,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k6_arytm_3)
        & m1_subset_1(B,k6_arytm_3) )
     => k10_arytm_3(A,B) = k10_arytm_3(B,A) ) ).

fof(dt_k11_arytm_3,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k6_arytm_3)
        & m1_subset_1(B,k6_arytm_3) )
     => m1_subset_1(k11_arytm_3(A,B),k6_arytm_3) ) ).

fof(commutativity_k11_arytm_3,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k6_arytm_3)
        & m1_subset_1(B,k6_arytm_3) )
     => k11_arytm_3(A,B) = k11_arytm_3(B,A) ) ).

fof(dt_k12_arytm_3,axiom,
    ( v1_xboole_0(k12_arytm_3)
    & m1_subset_1(k12_arytm_3,k6_arytm_3) ) ).

fof(redefinition_k12_arytm_3,axiom,
    k12_arytm_3 = k1_xboole_0 ).

fof(dt_k13_arytm_3,axiom,
    ( ~ v1_xboole_0(k13_arytm_3)
    & v3_ordinal1(k13_arytm_3)
    & m1_subset_1(k13_arytm_3,k6_arytm_3) ) ).

fof(redefinition_k13_arytm_3,axiom,
    k13_arytm_3 = k4_ordinal2 ).

fof(d6_arytm_3,axiom,
    k6_arytm_3 = k2_xboole_0(k4_xboole_0(a_0_0_arytm_3,a_0_1_arytm_3),k5_ordinal2) ).

fof(t81_arytm_3,axiom,
    ! [A] :
      ( m1_subset_1(A,k6_arytm_3)
     => ( r2_hidden(a_1_0_arytm_3(A),k6_arytm_3)
      <=> A = k12_arytm_3 ) ) ).

fof(fraenkel_a_0_0_arytm_3,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_arytm_3)
    <=> ? [B,C] :
          ( m1_subset_1(B,k5_ordinal2)
          & m1_subset_1(C,k5_ordinal2)
          & A = k4_tarski(B,C)
          & r1_arytm_3(B,C)
          & C != k1_xboole_0 ) ) ).

fof(fraenkel_a_0_1_arytm_3,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_1_arytm_3)
    <=> ? [B] :
          ( m1_subset_1(B,k5_ordinal2)
          & A = k4_tarski(B,k4_ordinal2) ) ) ).

fof(fraenkel_a_1_0_arytm_3,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k6_arytm_3)
     => ( r2_hidden(A,a_1_0_arytm_3(B))
      <=> ? [C] :
            ( m1_subset_1(C,k6_arytm_3)
            & A = C
            & ~ r3_arytm_3(B,C) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_arytm_2,axiom,
    ~ v1_xboole_0(k1_arytm_2) ).

fof(fc2_arytm_2,axiom,
    ~ v1_xboole_0(k2_arytm_2) ).

fof(t1_arytm_2,axiom,
    r1_tarski(k6_arytm_3,k2_arytm_2) ).

fof(t2_arytm_2,axiom,
    r1_tarski(k5_ordinal2,k2_arytm_2) ).

fof(t3_arytm_2,axiom,
    ! [A] : ~ r2_hidden(k4_tarski(k12_arytm_3,A),k2_arytm_2) ).

fof(d4_arytm_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( ? [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                  & ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ( r2_hidden(D,A)
                      <=> ~ r3_arytm_3(C,D) ) ) )
             => ( B = k4_arytm_2(A)
              <=> ? [C] :
                    ( m1_subset_1(C,k6_arytm_3)
                    & B = C
                    & ! [D] :
                        ( m1_subset_1(D,k6_arytm_3)
                       => ( r2_hidden(D,A)
                        <=> ~ r3_arytm_3(C,D) ) ) ) ) )
            & ( ! [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                 => ~ ! [D] :
                        ( m1_subset_1(D,k6_arytm_3)
                       => ( r2_hidden(D,A)
                        <=> ~ r3_arytm_3(C,D) ) ) )
             => ( B = k4_arytm_2(A)
              <=> B = A ) ) ) ) ) ).

fof(d5_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( ( r2_hidden(A,k6_arytm_3)
                & r2_hidden(B,k6_arytm_3) )
             => ( r1_arytm_2(A,B)
              <=> ? [C] :
                    ( m1_subset_1(C,k6_arytm_3)
                    & ? [D] :
                        ( m1_subset_1(D,k6_arytm_3)
                        & A = C
                        & B = D
                        & r3_arytm_3(C,D) ) ) ) )
            & ( r2_hidden(A,k6_arytm_3)
             => ( r2_hidden(B,k6_arytm_3)
                | ( r1_arytm_2(A,B)
                <=> r2_hidden(A,B) ) ) )
            & ( r2_hidden(B,k6_arytm_3)
             => ( r2_hidden(A,k6_arytm_3)
                | ( r1_arytm_2(A,B)
                <=> ~ r2_hidden(B,A) ) ) )
            & ~ ( ~ ( r2_hidden(A,k6_arytm_3)
                    & r2_hidden(B,k6_arytm_3) )
                & ~ ( r2_hidden(A,k6_arytm_3)
                    & ~ r2_hidden(B,k6_arytm_3) )
                & ~ ( ~ r2_hidden(A,k6_arytm_3)
                    & r2_hidden(B,k6_arytm_3) )
                & ~ ( r1_arytm_2(A,B)
                  <=> r1_tarski(A,B) ) ) ) ) ) ).

fof(d8_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( B = k12_arytm_3
             => k7_arytm_2(A,B) = A )
            & ( A = k12_arytm_3
             => k7_arytm_2(A,B) = B )
            & ~ ( B != k12_arytm_3
                & A != k12_arytm_3
                & k7_arytm_2(A,B) != k4_arytm_2(k5_arytm_2(k3_arytm_2(A),k3_arytm_2(B))) ) ) ) ) ).

fof(d9_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => k8_arytm_2(A,B) = k4_arytm_2(k6_arytm_2(k3_arytm_2(A),k3_arytm_2(B))) ) ) ).

fof(t4_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( A = k12_arytm_3
           => k8_arytm_2(A,B) = k12_arytm_3 ) ) ) ).

fof(t5_arytm_2,axiom,
    $true ).

fof(t6_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( k7_arytm_2(A,B) = k12_arytm_3
           => A = k12_arytm_3 ) ) ) ).

fof(t7_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => k7_arytm_2(A,k7_arytm_2(B,C)) = k7_arytm_2(k7_arytm_2(A,B),C) ) ) ) ).

fof(t9_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k2_arytm_2))
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k2_arytm_2))
         => ~ ( ? [C] :
                  ( m1_subset_1(C,k2_arytm_2)
                  & r2_hidden(C,A) )
              & ? [C] :
                  ( m1_subset_1(C,k2_arytm_2)
                  & r2_hidden(C,B) )
              & ! [C] :
                  ( m1_subset_1(C,k2_arytm_2)
                 => ! [D] :
                      ( m1_subset_1(D,k2_arytm_2)
                     => ( ( r2_hidden(C,A)
                          & r2_hidden(D,B) )
                       => r1_arytm_2(C,D) ) ) )
              & ! [C] :
                  ( m1_subset_1(C,k2_arytm_2)
                 => ? [D] :
                      ( m1_subset_1(D,k2_arytm_2)
                      & ? [E] :
                          ( m1_subset_1(E,k2_arytm_2)
                          & r2_hidden(D,A)
                          & r2_hidden(E,B)
                          & ~ ( r1_arytm_2(D,C)
                              & r1_arytm_2(C,E) ) ) ) ) ) ) ) ).

fof(t10_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ~ ( r1_arytm_2(A,B)
              & ! [C] :
                  ( m1_subset_1(C,k2_arytm_2)
                 => k7_arytm_2(A,C) != B ) ) ) ) ).

fof(t11_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ~ ! [C] :
                ( m1_subset_1(C,k2_arytm_2)
               => ( k7_arytm_2(A,C) != B
                  & k7_arytm_2(B,C) != A ) ) ) ) ).

fof(t12_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( k7_arytm_2(A,B) = k7_arytm_2(A,C)
               => B = C ) ) ) ) ).

fof(t13_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => k8_arytm_2(A,k8_arytm_2(B,C)) = k8_arytm_2(k8_arytm_2(A,B),C) ) ) ) ).

fof(t14_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => k8_arytm_2(A,k7_arytm_2(B,C)) = k7_arytm_2(k8_arytm_2(A,B),k8_arytm_2(A,C)) ) ) ) ).

fof(t15_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ~ ( A != k12_arytm_3
          & ! [B] :
              ( m1_subset_1(B,k2_arytm_2)
             => k8_arytm_2(A,B) != k13_arytm_3 ) ) ) ).

fof(t16_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( A = k13_arytm_3
           => k8_arytm_2(A,B) = B ) ) ) ).

fof(t17_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( r2_hidden(A,k5_ordinal2)
              & r2_hidden(B,k5_ordinal2) )
           => r2_hidden(k7_arytm_2(B,A),k5_ordinal2) ) ) ) ).

fof(t18_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k2_arytm_2))
     => ( ( r2_hidden(k12_arytm_3,A)
          & ! [B] :
              ( m1_subset_1(B,k2_arytm_2)
             => ! [C] :
                  ( m1_subset_1(C,k2_arytm_2)
                 => ( ( r2_hidden(B,A)
                      & C = k13_arytm_3 )
                   => r2_hidden(k7_arytm_2(B,C),A) ) ) ) )
       => r1_tarski(k5_ordinal2,A) ) ) ).

fof(t19_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ( r2_hidden(A,k5_ordinal2)
       => ! [B] :
            ( m1_subset_1(B,k2_arytm_2)
           => ( r2_hidden(B,A)
            <=> ( r2_hidden(B,k5_ordinal2)
                & B != A
                & r1_arytm_2(B,A) ) ) ) ) ) ).

fof(t20_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( A = k7_arytm_2(B,C)
               => r1_arytm_2(C,A) ) ) ) ) ).

fof(t21_arytm_2,axiom,
    ( r2_hidden(k12_arytm_3,k2_arytm_2)
    & r2_hidden(k13_arytm_3,k2_arytm_2) ) ).

fof(t22_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ~ ( r2_hidden(A,k6_arytm_3)
              & r2_hidden(B,k6_arytm_3)
              & ! [C] :
                  ( m1_subset_1(C,k6_arytm_3)
                 => ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ~ ( A = C
                          & B = D
                          & k8_arytm_2(A,B) = k11_arytm_3(C,D) ) ) ) ) ) ) ).

fof(connectedness_r1_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_arytm_2)
        & m1_subset_1(B,k2_arytm_2) )
     => ( r1_arytm_2(A,B)
        | r1_arytm_2(B,A) ) ) ).

fof(dt_k1_arytm_2,axiom,
    m1_subset_1(k1_arytm_2,k1_zfmisc_1(k1_zfmisc_1(k6_arytm_3))) ).

fof(dt_k2_arytm_2,axiom,
    $true ).

fof(dt_k3_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => m2_subset_1(k3_arytm_2(A),k1_zfmisc_1(k6_arytm_3),k1_arytm_2) ) ).

fof(dt_k4_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_arytm_2)
     => m1_subset_1(k4_arytm_2(A),k2_arytm_2) ) ).

fof(dt_k5_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_arytm_2)
        & m1_subset_1(B,k1_arytm_2) )
     => m2_subset_1(k5_arytm_2(A,B),k1_zfmisc_1(k6_arytm_3),k1_arytm_2) ) ).

fof(commutativity_k5_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_arytm_2)
        & m1_subset_1(B,k1_arytm_2) )
     => k5_arytm_2(A,B) = k5_arytm_2(B,A) ) ).

fof(dt_k6_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_arytm_2)
        & m1_subset_1(B,k1_arytm_2) )
     => m2_subset_1(k6_arytm_2(A,B),k1_zfmisc_1(k6_arytm_3),k1_arytm_2) ) ).

fof(commutativity_k6_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_arytm_2)
        & m1_subset_1(B,k1_arytm_2) )
     => k6_arytm_2(A,B) = k6_arytm_2(B,A) ) ).

fof(dt_k7_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_arytm_2)
        & m1_subset_1(B,k2_arytm_2) )
     => m1_subset_1(k7_arytm_2(A,B),k2_arytm_2) ) ).

fof(commutativity_k7_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_arytm_2)
        & m1_subset_1(B,k2_arytm_2) )
     => k7_arytm_2(A,B) = k7_arytm_2(B,A) ) ).

fof(dt_k8_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_arytm_2)
        & m1_subset_1(B,k2_arytm_2) )
     => m1_subset_1(k8_arytm_2(A,B),k2_arytm_2) ) ).

fof(commutativity_k8_arytm_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_arytm_2)
        & m1_subset_1(B,k2_arytm_2) )
     => k8_arytm_2(A,B) = k8_arytm_2(B,A) ) ).

fof(d1_arytm_2,axiom,
    k1_arytm_2 = k4_xboole_0(a_0_0_arytm_2,k1_tarski(k6_arytm_3)) ).

fof(d2_arytm_2,axiom,
    k2_arytm_2 = k4_xboole_0(k2_xboole_0(k6_arytm_3,k1_arytm_2),a_0_1_arytm_2) ).

fof(d3_arytm_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m2_subset_1(B,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
         => ( ( r2_hidden(A,k6_arytm_3)
             => ( B = k3_arytm_2(A)
              <=> ? [C] :
                    ( m1_subset_1(C,k6_arytm_3)
                    & A = C
                    & B = a_1_0_arytm_2(C) ) ) )
            & ( ~ r2_hidden(A,k6_arytm_3)
             => ( B = k3_arytm_2(A)
              <=> B = A ) ) ) ) ) ).

fof(d6_arytm_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
     => ! [B] :
          ( m2_subset_1(B,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
         => k5_arytm_2(A,B) = a_2_0_arytm_2(A,B) ) ) ).

fof(d7_arytm_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
     => ! [B] :
          ( m2_subset_1(B,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
         => k6_arytm_2(A,B) = a_2_1_arytm_2(A,B) ) ) ).

fof(t8_arytm_2,axiom,
    v6_ordinal1(a_0_0_arytm_2) ).

fof(fraenkel_a_0_0_arytm_2,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_arytm_2)
    <=> ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k6_arytm_3))
          & A = B
          & ! [C] :
              ( m1_subset_1(C,k6_arytm_3)
             => ( r2_hidden(C,B)
               => ( ! [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                     => ( r3_arytm_3(D,C)
                       => r2_hidden(D,B) ) )
                  & ? [D] :
                      ( m1_subset_1(D,k6_arytm_3)
                      & r2_hidden(D,B)
                      & ~ r3_arytm_3(D,C) ) ) ) ) ) ) ).

fof(fraenkel_a_0_1_arytm_2,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_1_arytm_2)
    <=> ? [B] :
          ( m1_subset_1(B,k6_arytm_3)
          & A = a_1_0_arytm_2(B)
          & B != k12_arytm_3 ) ) ).

fof(fraenkel_a_1_0_arytm_2,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k6_arytm_3)
     => ( r2_hidden(A,a_1_0_arytm_2(B))
      <=> ? [C] :
            ( m1_subset_1(C,k6_arytm_3)
            & A = C
            & ~ r3_arytm_3(B,C) ) ) ) ).

fof(fraenkel_a_2_0_arytm_2,axiom,
    ! [A,B,C] :
      ( ( m2_subset_1(B,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
        & m2_subset_1(C,k1_zfmisc_1(k6_arytm_3),k1_arytm_2) )
     => ( r2_hidden(A,a_2_0_arytm_2(B,C))
      <=> ? [D,E] :
            ( m1_subset_1(D,k6_arytm_3)
            & m1_subset_1(E,k6_arytm_3)
            & A = k10_arytm_3(D,E)
            & r2_hidden(D,B)
            & r2_hidden(E,C) ) ) ) ).

fof(fraenkel_a_2_1_arytm_2,axiom,
    ! [A,B,C] :
      ( ( m2_subset_1(B,k1_zfmisc_1(k6_arytm_3),k1_arytm_2)
        & m2_subset_1(C,k1_zfmisc_1(k6_arytm_3),k1_arytm_2) )
     => ( r2_hidden(A,a_2_1_arytm_2(B,C))
      <=> ? [D,E] :
            ( m1_subset_1(D,k6_arytm_3)
            & m1_subset_1(E,k6_arytm_3)
            & A = k11_arytm_3(D,E)
            & r2_hidden(D,B)
            & r2_hidden(E,C) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( k7_arytm_2(A,B) = B
           => A = k1_xboole_0 ) ) ) ).

fof(t2_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ~ ( k8_arytm_2(A,B) = k1_xboole_0
              & A != k1_xboole_0
              & B != k1_xboole_0 ) ) ) ).

fof(t3_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( ( r1_arytm_2(A,B)
                  & r1_arytm_2(B,C) )
               => r1_arytm_2(A,C) ) ) ) ) ).

fof(t4_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( r1_arytm_2(A,B)
              & r1_arytm_2(B,A) )
           => A = B ) ) ) ).

fof(t5_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( r1_arytm_2(A,B)
              & B = k1_xboole_0 )
           => A = k1_xboole_0 ) ) ) ).

fof(t6_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( A = k1_xboole_0
           => r1_arytm_2(A,B) ) ) ) ).

fof(t7_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
              <=> r1_arytm_2(k7_arytm_2(A,C),k7_arytm_2(B,C)) ) ) ) ) ).

fof(t8_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => r1_arytm_2(k8_arytm_2(A,C),k8_arytm_2(B,C)) ) ) ) ) ).

fof(d1_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( ( r1_arytm_2(B,A)
                 => ( C = k1_arytm_1(A,B)
                  <=> k7_arytm_2(C,B) = A ) )
                & ( ~ r1_arytm_2(B,A)
                 => ( C = k1_arytm_1(A,B)
                  <=> C = k1_xboole_0 ) ) ) ) ) ) ).

fof(t9_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ~ ( ~ r1_arytm_2(A,B)
              & k1_arytm_1(A,B) = k1_xboole_0 ) ) ) ).

fof(t10_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( r1_arytm_2(A,B)
              & k1_arytm_1(B,A) = k1_xboole_0 )
           => A = B ) ) ) ).

fof(t11_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => r1_arytm_2(k1_arytm_1(A,B),A) ) ) ).

fof(t12_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( ( r1_arytm_2(A,B)
                  & r1_arytm_2(A,C) )
               => k7_arytm_2(B,k1_arytm_1(C,A)) = k7_arytm_2(k1_arytm_1(B,A),C) ) ) ) ) ).

fof(t13_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => k7_arytm_2(C,k1_arytm_1(B,A)) = k1_arytm_1(k7_arytm_2(C,B),A) ) ) ) ) ).

fof(t14_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( ( r1_arytm_2(A,B)
                  & r1_arytm_2(C,A) )
               => k7_arytm_2(k1_arytm_1(B,A),C) = k1_arytm_1(B,k1_arytm_1(A,C)) ) ) ) ) ).

fof(t15_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( ( r1_arytm_2(A,B)
                  & r1_arytm_2(A,C) )
               => k7_arytm_2(k1_arytm_1(C,A),B) = k7_arytm_2(k1_arytm_1(B,A),C) ) ) ) ) ).

fof(t16_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => r1_arytm_2(k1_arytm_1(C,B),k1_arytm_1(C,A)) ) ) ) ) ).

fof(t17_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => r1_arytm_2(k1_arytm_1(A,C),k1_arytm_1(B,C)) ) ) ) ) ).

fof(d2_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( ( r1_arytm_2(B,A)
             => k2_arytm_1(A,B) = k1_arytm_1(A,B) )
            & ( ~ r1_arytm_2(B,A)
             => k2_arytm_1(A,B) = k4_tarski(k1_xboole_0,k1_arytm_1(B,A)) ) ) ) ) ).

fof(t18_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => k2_arytm_1(A,A) = k1_xboole_0 ) ).

fof(t19_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( A = k1_xboole_0
           => ( B = k1_xboole_0
              | k2_arytm_1(A,B) = k4_tarski(k1_xboole_0,B) ) ) ) ) ).

fof(t20_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => k7_arytm_2(C,k1_arytm_1(B,A)) = k2_arytm_1(k7_arytm_2(C,B),A) ) ) ) ) ).

fof(t21_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( ~ r1_arytm_2(A,B)
               => k2_arytm_1(C,k1_arytm_1(A,B)) = k2_arytm_1(k7_arytm_2(C,B),A) ) ) ) ) ).

fof(t22_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => ( r1_arytm_2(A,C)
                  | k2_arytm_1(B,k1_arytm_1(A,C)) = k7_arytm_2(k1_arytm_1(B,A),C) ) ) ) ) ) ).

fof(t23_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ~ ( ~ r1_arytm_2(A,B)
                  & ~ r1_arytm_2(A,C)
                  & k2_arytm_1(B,k1_arytm_1(A,C)) != k2_arytm_1(C,k1_arytm_1(A,B)) ) ) ) ) ).

fof(t24_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => k2_arytm_1(B,k7_arytm_2(A,C)) = k2_arytm_1(k1_arytm_1(B,A),C) ) ) ) ) ).

fof(t25_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( ( r1_arytm_2(A,B)
                  & r1_arytm_2(C,B) )
               => k2_arytm_1(k1_arytm_1(B,C),A) = k2_arytm_1(k1_arytm_1(B,A),C) ) ) ) ) ).

fof(t26_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(A,B)
               => k8_arytm_2(C,k1_arytm_1(B,A)) = k2_arytm_1(k8_arytm_2(C,B),k8_arytm_2(C,A)) ) ) ) ) ).

fof(t27_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ~ ( ~ r1_arytm_2(A,B)
                  & C != k1_xboole_0
                  & k4_tarski(k1_xboole_0,k8_arytm_2(C,k1_arytm_1(A,B))) != k2_arytm_1(k8_arytm_2(C,B),k8_arytm_2(C,A)) ) ) ) ) ).

fof(t28_arytm_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( r1_arytm_2(B,A)
               => ( k1_arytm_1(A,B) = k1_xboole_0
                  | C = k1_xboole_0
                  | k2_arytm_1(k8_arytm_2(C,B),k8_arytm_2(C,A)) = k4_tarski(k1_xboole_0,k8_arytm_2(C,k1_arytm_1(A,B))) ) ) ) ) ) ).

fof(dt_k1_arytm_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_arytm_2)
        & m1_subset_1(B,k2_arytm_2) )
     => m1_subset_1(k1_arytm_1(A,B),k2_arytm_2) ) ).

fof(dt_k2_arytm_1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_finset_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_finset_1(A) ) ).

fof(cc1_finset_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => v1_finset_1(A) ) ).

fof(rc2_finset_1,axiom,
    ! [A] :
    ? [B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
      & v1_xboole_0(B)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v2_funct_1(B)
      & v1_ordinal1(B)
      & v2_ordinal1(B)
      & v3_ordinal1(B)
      & v4_ordinal2(B)
      & v1_finset_1(B) ) ).

fof(fc1_finset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k1_tarski(A))
      & v1_finset_1(k1_tarski(A)) ) ).

fof(rc3_finset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
          & ~ v1_xboole_0(B)
          & v1_finset_1(B) ) ) ).

fof(fc2_finset_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(k2_tarski(A,B))
      & v1_finset_1(k2_tarski(A,B)) ) ).

fof(fc3_finset_1,axiom,
    ! [A,B,C] : v1_finset_1(k1_enumset1(A,B,C)) ).

fof(fc4_finset_1,axiom,
    ! [A,B,C,D] : v1_finset_1(k2_enumset1(A,B,C,D)) ).

fof(fc5_finset_1,axiom,
    ! [A,B,C,D,E] : v1_finset_1(k3_enumset1(A,B,C,D,E)) ).

fof(fc6_finset_1,axiom,
    ! [A,B,C,D,E,F] : v1_finset_1(k4_enumset1(A,B,C,D,E,F)) ).

fof(fc7_finset_1,axiom,
    ! [A,B,C,D,E,F,G] : v1_finset_1(k5_enumset1(A,B,C,D,E,F,G)) ).

fof(fc8_finset_1,axiom,
    ! [A,B,C,D,E,F,G,H] : v1_finset_1(k6_enumset1(A,B,C,D,E,F,G,H)) ).

fof(cc2_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => v1_finset_1(B) ) ) ).

fof(fc9_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_xboole_0(A,B)) ) ).

fof(fc10_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(B)
     => v1_finset_1(k3_xboole_0(A,B)) ) ).

fof(fc11_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k3_xboole_0(A,B)) ) ).

fof(fc12_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k4_xboole_0(A,B)) ) ).

fof(fc13_finset_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k9_relat_1(A,B)) ) ).

fof(fc14_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_zfmisc_1(A,B)) ) ).

fof(fc15_finset_1,axiom,
    ! [A,B,C] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C) )
     => v1_finset_1(k3_zfmisc_1(A,B,C)) ) ).

fof(fc16_finset_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C)
        & v1_finset_1(D) )
     => v1_finset_1(k4_zfmisc_1(A,B,C,D)) ) ).

fof(fc17_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k5_xboole_0(A,B)) ) ).

fof(rc4_finset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
          & ~ v1_xboole_0(B)
          & v1_finset_1(B) ) ) ).

fof(d1_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
    <=> ? [B] :
          ( v1_relat_1(B)
          & v1_funct_1(B)
          & k2_relat_1(B) = A
          & r2_hidden(k1_relat_1(B),k5_ordinal2) ) ) ).

fof(t1_finset_1,axiom,
    $true ).

fof(t2_finset_1,axiom,
    $true ).

fof(t3_finset_1,axiom,
    $true ).

fof(t4_finset_1,axiom,
    $true ).

fof(t5_finset_1,axiom,
    $true ).

fof(t6_finset_1,axiom,
    $true ).

fof(t7_finset_1,axiom,
    $true ).

fof(t8_finset_1,axiom,
    $true ).

fof(t9_finset_1,axiom,
    $true ).

fof(t10_finset_1,axiom,
    $true ).

fof(t11_finset_1,axiom,
    $true ).

fof(t12_finset_1,axiom,
    $true ).

fof(t13_finset_1,axiom,
    ! [A,B] :
      ( ( r1_tarski(A,B)
        & v1_finset_1(B) )
     => v1_finset_1(A) ) ).

fof(t14_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_xboole_0(A,B)) ) ).

fof(t15_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k3_xboole_0(A,B)) ) ).

fof(t16_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k4_xboole_0(A,B)) ) ).

fof(t17_finset_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_finset_1(A)
       => v1_finset_1(k9_relat_1(B,A)) ) ) ).

fof(t18_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ~ ( B != k1_xboole_0
              & ! [C] :
                  ~ ( r2_hidden(C,B)
                    & ! [D] :
                        ( ( r2_hidden(D,B)
                          & r1_tarski(C,D) )
                       => D = C ) ) ) ) ) ).

fof(t19_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_zfmisc_1(A,B)) ) ).

fof(t20_finset_1,axiom,
    ! [A,B,C] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C) )
     => v1_finset_1(k3_zfmisc_1(A,B,C)) ) ).

fof(t21_finset_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C)
        & v1_finset_1(D) )
     => v1_finset_1(k4_zfmisc_1(A,B,C,D)) ) ).

fof(t22_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(k2_zfmisc_1(B,A))
     => ( A = k1_xboole_0
        | v1_finset_1(B) ) ) ).

fof(t23_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(k2_zfmisc_1(A,B))
     => ( A = k1_xboole_0
        | v1_finset_1(B) ) ) ).

fof(t24_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
    <=> v1_finset_1(k1_zfmisc_1(A)) ) ).

fof(t25_finset_1,axiom,
    ! [A] :
      ( ( v1_finset_1(A)
        & ! [B] :
            ( r2_hidden(B,A)
           => v1_finset_1(B) ) )
    <=> v1_finset_1(k3_tarski(A)) ) ).

fof(t26_finset_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_finset_1(k1_relat_1(A))
       => v1_finset_1(k2_relat_1(A)) ) ) ).

fof(t27_finset_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( r1_tarski(A,k2_relat_1(B))
          & v1_finset_1(k10_relat_1(B,A)) )
       => v1_finset_1(A) ) ) ).

fof(t28_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k5_xboole_0(A,B)) ) ).

fof(t29_finset_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_finset_1(k1_relat_1(A))
      <=> v1_finset_1(A) ) ) ).

fof(t30_finset_1,axiom,
    ! [A] :
      ~ ( v1_finset_1(A)
        & A != k1_xboole_0
        & v6_ordinal1(A)
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ( r2_hidden(C,A)
                 => r1_tarski(B,C) ) ) ) ).

fof(t31_finset_1,axiom,
    ! [A] :
      ~ ( v1_finset_1(A)
        & A != k1_xboole_0
        & v6_ordinal1(A)
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ( r2_hidden(C,A)
                 => r1_tarski(C,B) ) ) ) ).

fof(s1_finset_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s1_finset_1
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(B,f1_s1_finset_1)
           => ( ( p1_s1_finset_1(B)
               => k1_funct_1(A,B) = f2_s1_finset_1(B) )
              & ( ~ p1_s1_finset_1(B)
               => k1_funct_1(A,B) = f3_s1_finset_1(B) ) ) ) ) ) ).

fof(s2_finset_1,axiom,
    ( ( v1_finset_1(f1_s2_finset_1)
      & p1_s2_finset_1(k1_xboole_0)
      & ! [A,B] :
          ( ( r2_hidden(A,f1_s2_finset_1)
            & r1_tarski(B,f1_s2_finset_1)
            & p1_s2_finset_1(B) )
         => p1_s2_finset_1(k2_xboole_0(B,k1_tarski(A))) ) )
   => p1_s2_finset_1(f1_s2_finset_1) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_finsub_1,axiom,
    ! [A] :
      ( v4_finsub_1(A)
     => ( v1_finsub_1(A)
        & v3_finsub_1(A) ) ) ).

fof(cc2_finsub_1,axiom,
    ! [A] :
      ( ( v1_finsub_1(A)
        & v3_finsub_1(A) )
     => v4_finsub_1(A) ) ).

fof(rc1_finsub_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_finsub_1(A)
      & v2_finsub_1(A)
      & v3_finsub_1(A)
      & v4_finsub_1(A) ) ).

fof(fc1_finsub_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k1_zfmisc_1(A))
      & v1_finsub_1(k1_zfmisc_1(A))
      & v3_finsub_1(k1_zfmisc_1(A))
      & v4_finsub_1(k1_zfmisc_1(A)) ) ).

fof(fc2_finsub_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k5_finsub_1(A))
      & v1_finsub_1(k5_finsub_1(A))
      & v3_finsub_1(k5_finsub_1(A))
      & v4_finsub_1(k5_finsub_1(A)) ) ).

fof(cc3_finsub_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k5_finsub_1(A))
     => v1_finset_1(B) ) ).

fof(d1_finsub_1,axiom,
    ! [A] :
      ( v1_finsub_1(A)
    <=> ! [B,C] :
          ( ( r2_hidden(B,A)
            & r2_hidden(C,A) )
         => r2_hidden(k2_xboole_0(B,C),A) ) ) ).

fof(d2_finsub_1,axiom,
    ! [A] :
      ( v2_finsub_1(A)
    <=> ! [B,C] :
          ( ( r2_hidden(B,A)
            & r2_hidden(C,A) )
         => r2_hidden(k3_xboole_0(B,C),A) ) ) ).

fof(d3_finsub_1,axiom,
    ! [A] :
      ( v3_finsub_1(A)
    <=> ! [B,C] :
          ( ( r2_hidden(B,A)
            & r2_hidden(C,A) )
         => r2_hidden(k4_xboole_0(B,C),A) ) ) ).

fof(d4_finsub_1,axiom,
    ! [A] :
      ( v4_finsub_1(A)
    <=> ( v1_finsub_1(A)
        & v3_finsub_1(A) ) ) ).

fof(t1_finsub_1,axiom,
    $true ).

fof(t2_finsub_1,axiom,
    $true ).

fof(t3_finsub_1,axiom,
    $true ).

fof(t4_finsub_1,axiom,
    $true ).

fof(t5_finsub_1,axiom,
    $true ).

fof(t6_finsub_1,axiom,
    $true ).

fof(t7_finsub_1,axiom,
    $true ).

fof(t8_finsub_1,axiom,
    $true ).

fof(t9_finsub_1,axiom,
    $true ).

fof(t10_finsub_1,axiom,
    ! [A] :
      ( v4_finsub_1(A)
    <=> ! [B,C] :
          ( ( r2_hidden(B,A)
            & r2_hidden(C,A) )
         => ( r2_hidden(k2_xboole_0(B,C),A)
            & r2_hidden(k4_xboole_0(B,C),A) ) ) ) ).

fof(t11_finsub_1,axiom,
    $true ).

fof(t12_finsub_1,axiom,
    $true ).

fof(t13_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(C)
        & v4_finsub_1(C) )
     => ( ( m1_subset_1(A,C)
          & m1_subset_1(B,C) )
       => m1_subset_1(k3_xboole_0(A,B),C) ) ) ).

fof(t14_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(C)
        & v4_finsub_1(C) )
     => ( ( m1_subset_1(A,C)
          & m1_subset_1(B,C) )
       => m1_subset_1(k5_xboole_0(A,B),C) ) ) ).

fof(t15_finsub_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ! [B] :
            ( m1_subset_1(B,A)
           => ! [C] :
                ( m1_subset_1(C,A)
               => ( r2_hidden(k5_xboole_0(B,C),A)
                  & r2_hidden(k4_xboole_0(B,C),A) ) ) )
       => v4_finsub_1(A) ) ) ).

fof(t16_finsub_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ! [B] :
            ( m1_subset_1(B,A)
           => ! [C] :
                ( m1_subset_1(C,A)
               => ( r2_hidden(k5_xboole_0(B,C),A)
                  & r2_hidden(k3_xboole_0(B,C),A) ) ) )
       => v4_finsub_1(A) ) ) ).

fof(t17_finsub_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ! [B] :
            ( m1_subset_1(B,A)
           => ! [C] :
                ( m1_subset_1(C,A)
               => ( r2_hidden(k5_xboole_0(B,C),A)
                  & r2_hidden(k2_xboole_0(B,C),A) ) ) )
       => v4_finsub_1(A) ) ) ).

fof(t18_finsub_1,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A) )
     => r2_hidden(k1_xboole_0,A) ) ).

fof(t19_finsub_1,axiom,
    $true ).

fof(t20_finsub_1,axiom,
    ! [A] : v4_finsub_1(k1_zfmisc_1(A)) ).

fof(t21_finsub_1,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v4_finsub_1(B) )
         => ( ~ v1_xboole_0(k3_xboole_0(A,B))
            & v4_finsub_1(k3_xboole_0(A,B)) ) ) ) ).

fof(d5_finsub_1,axiom,
    ! [A,B] :
      ( v4_finsub_1(B)
     => ( B = k5_finsub_1(A)
      <=> ! [C] :
            ( r2_hidden(C,B)
          <=> ( r1_tarski(C,A)
              & v1_finset_1(C) ) ) ) ) ).

fof(t22_finsub_1,axiom,
    $true ).

fof(t23_finsub_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k5_finsub_1(A),k5_finsub_1(B)) ) ).

fof(t24_finsub_1,axiom,
    ! [A,B] : k5_finsub_1(k3_xboole_0(A,B)) = k3_xboole_0(k5_finsub_1(A),k5_finsub_1(B)) ).

fof(t25_finsub_1,axiom,
    ! [A,B] : r1_tarski(k2_xboole_0(k5_finsub_1(A),k5_finsub_1(B)),k5_finsub_1(k2_xboole_0(A,B))) ).

fof(t26_finsub_1,axiom,
    ! [A] : r1_tarski(k5_finsub_1(A),k1_zfmisc_1(A)) ).

fof(t27_finsub_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => k5_finsub_1(A) = k1_zfmisc_1(A) ) ).

fof(t28_finsub_1,axiom,
    k5_finsub_1(k1_xboole_0) = k1_tarski(k1_xboole_0) ).

fof(t29_finsub_1,axiom,
    $true ).

fof(t30_finsub_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k5_finsub_1(A))
     => v1_finset_1(B) ) ).

fof(t31_finsub_1,axiom,
    $true ).

fof(t32_finsub_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k5_finsub_1(A))
     => m1_subset_1(B,k1_zfmisc_1(A)) ) ).

fof(t33_finsub_1,axiom,
    $true ).

fof(t34_finsub_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( v1_finset_1(A)
       => m1_subset_1(B,k5_finsub_1(A)) ) ) ).

fof(dt_k1_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => m1_subset_1(k1_finsub_1(A,B,C),A) ) ).

fof(commutativity_k1_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k1_finsub_1(A,B,C) = k1_finsub_1(A,C,B) ) ).

fof(idempotence_k1_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k1_finsub_1(A,B,B) = B ) ).

fof(redefinition_k1_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k1_finsub_1(A,B,C) = k2_xboole_0(B,C) ) ).

fof(dt_k2_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => m1_subset_1(k2_finsub_1(A,B,C),A) ) ).

fof(redefinition_k2_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k2_finsub_1(A,B,C) = k4_xboole_0(B,C) ) ).

fof(dt_k3_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => m1_subset_1(k3_finsub_1(A,B,C),A) ) ).

fof(commutativity_k3_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k3_finsub_1(A,B,C) = k3_finsub_1(A,C,B) ) ).

fof(idempotence_k3_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k3_finsub_1(A,B,B) = B ) ).

fof(redefinition_k3_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k3_finsub_1(A,B,C) = k3_xboole_0(B,C) ) ).

fof(dt_k4_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => m1_subset_1(k4_finsub_1(A,B,C),A) ) ).

fof(commutativity_k4_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k4_finsub_1(A,B,C) = k4_finsub_1(A,C,B) ) ).

fof(redefinition_k4_finsub_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v4_finsub_1(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k4_finsub_1(A,B,C) = k5_xboole_0(B,C) ) ).

fof(dt_k5_finsub_1,axiom,
    ! [A] : v4_finsub_1(k5_finsub_1(A)) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_setwiseo,axiom,
    ! [A] :
    ? [B] :
      ( m1_subset_1(B,k5_finsub_1(A))
      & v1_xboole_0(B)
      & v1_finset_1(B) ) ).

fof(rc2_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] :
          ( m1_subset_1(B,k5_finsub_1(A))
          & ~ v1_xboole_0(B)
          & v1_finset_1(B) ) ) ).

fof(t1_setwiseo,axiom,
    $true ).

fof(t2_setwiseo,axiom,
    $true ).

fof(t3_setwiseo,axiom,
    ! [A,B,C] : r1_tarski(k1_tarski(A),k1_enumset1(A,B,C)) ).

fof(t4_setwiseo,axiom,
    ! [A,B,C] : r1_tarski(k2_tarski(A,B),k1_enumset1(A,B,C)) ).

fof(t5_setwiseo,axiom,
    ! [A,B,C] :
      ~ ( r1_tarski(A,k2_xboole_0(B,k1_tarski(C)))
        & ~ r2_hidden(C,A)
        & ~ r1_tarski(A,B) ) ).

fof(t6_setwiseo,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k2_xboole_0(B,k1_tarski(C)))
    <=> ( r2_hidden(A,B)
        | A = C ) ) ).

fof(t7_setwiseo,axiom,
    $true ).

fof(t8_setwiseo,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_xboole_0(A,k1_tarski(B)),C)
    <=> ( r2_hidden(B,C)
        & r1_tarski(A,C) ) ) ).

fof(t9_setwiseo,axiom,
    $true ).

fof(t10_setwiseo,axiom,
    $true ).

fof(t11_setwiseo,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k9_relat_1(C,k4_xboole_0(B,k10_relat_1(C,A))) = k4_xboole_0(k9_relat_1(C,B),A) ) ).

fof(t12_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,B,A)
                & m2_relset_1(C,B,A) )
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => r2_hidden(D,k3_funct_2(B,A,C,k1_tarski(k8_funct_2(B,A,C,D)))) ) ) ) ) ).

fof(t13_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,B,A)
                & m2_relset_1(C,B,A) )
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => k2_funct_2(B,A,C,k1_tarski(D)) = k1_tarski(k8_funct_2(B,A,C,D)) ) ) ) ) ).

fof(t14_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k5_finsub_1(A))
         => ! [C] :
              ( r2_hidden(C,B)
             => m1_subset_1(C,A) ) ) ) ).

fof(t15_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,k5_finsub_1(A))
             => ! [D,E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,A,B)
                    & m2_relset_1(E,A,B) )
                 => ( ! [F] :
                        ( m1_subset_1(F,A)
                       => ( r2_hidden(F,C)
                         => r2_hidden(k8_funct_2(A,B,E,F),D) ) )
                   => r1_tarski(k2_funct_2(A,B,E,C),D) ) ) ) ) ) ).

fof(t16_setwiseo,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k5_finsub_1(A))
     => ! [C] :
          ( r1_tarski(C,B)
         => m1_subset_1(C,k5_finsub_1(A)) ) ) ).

fof(t17_setwiseo,axiom,
    $true ).

fof(t18_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k5_finsub_1(A))
         => ~ ( B != k1_xboole_0
              & ! [C] :
                  ( m1_subset_1(C,A)
                 => ~ r2_hidden(C,B) ) ) ) ) ).

fof(t19_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,B,A)
                & m2_relset_1(C,B,A) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(B))
                 => ( k2_funct_2(B,A,C,D) = k1_xboole_0
                   => D = k1_xboole_0 ) ) ) ) ) ).

fof(d1_setwiseo,axiom,
    ! [A] : k1_setwiseo(A) = k1_xboole_0 ).

fof(d2_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ( v1_setwiseo(B,A)
          <=> ? [C] :
                ( m1_subset_1(C,A)
                & r3_binop_1(A,C,B) ) ) ) ) ).

fof(t20_setwiseo,axiom,
    $true ).

fof(t21_setwiseo,axiom,
    $true ).

fof(t22_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ( v1_setwiseo(B,A)
          <=> r3_binop_1(A,k3_binop_1(A,B),B) ) ) ) ).

fof(t23_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ( v1_setwiseo(B,A)
           => ! [C] :
                ( m1_subset_1(C,A)
               => ( k2_binop_1(A,A,A,B,k3_binop_1(A,B),C) = C
                  & k2_binop_1(A,A,A,B,C,k3_binop_1(A,B)) = C ) ) ) ) ) ).

fof(d3_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(A))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ( ( v1_binop_1(C,B)
                          & v2_binop_1(C,B) )
                       => ( ( D = k1_xboole_0
                            & ~ v1_setwiseo(C,B) )
                          | ! [F] :
                              ( m1_subset_1(F,B)
                             => ( F = k7_setwiseo(A,B,C,D,E)
                              <=> ? [G] :
                                    ( v1_funct_1(G)
                                    & v1_funct_2(G,k5_finsub_1(A),B)
                                    & m2_relset_1(G,k5_finsub_1(A),B)
                                    & F = k8_funct_2(k5_finsub_1(A),B,G,D)
                                    & ! [H] :
                                        ( m1_subset_1(H,B)
                                       => ( r3_binop_1(B,H,C)
                                         => k1_funct_1(G,k1_xboole_0) = H ) )
                                    & ! [H] :
                                        ( m1_subset_1(H,A)
                                       => k8_funct_2(k5_finsub_1(A),B,G,k2_setwiseo(A,H)) = k8_funct_2(A,B,E,H) )
                                    & ! [H] :
                                        ( m1_subset_1(H,k5_finsub_1(A))
                                       => ( r1_tarski(H,D)
                                         => ( H = k1_xboole_0
                                            | ! [I] :
                                                ( m1_subset_1(I,A)
                                               => ( r2_hidden(I,k6_setwiseo(A,D,H))
                                                 => k8_funct_2(k5_finsub_1(A),B,G,k5_setwiseo(A,H,k2_setwiseo(A,I))) = k2_binop_1(B,B,B,C,k8_funct_2(k5_finsub_1(A),B,G,H),k8_funct_2(A,B,E,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(t24_setwiseo,axiom,
    $true ).

fof(t25_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(A))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ( ( v3_binop_1(C,B)
                          & v1_binop_1(C,B)
                          & v2_binop_1(C,B) )
                       => ( ( D = k1_xboole_0
                            & ~ v1_setwiseo(C,B) )
                          | ! [F] :
                              ( m1_subset_1(F,B)
                             => ( F = k7_setwiseo(A,B,C,D,E)
                              <=> ? [G] :
                                    ( v1_funct_1(G)
                                    & v1_funct_2(G,k5_finsub_1(A),B)
                                    & m2_relset_1(G,k5_finsub_1(A),B)
                                    & F = k8_funct_2(k5_finsub_1(A),B,G,D)
                                    & ! [H] :
                                        ( m1_subset_1(H,B)
                                       => ( r3_binop_1(B,H,C)
                                         => k1_funct_1(G,k1_xboole_0) = H ) )
                                    & ! [H] :
                                        ( m1_subset_1(H,A)
                                       => k8_funct_2(k5_finsub_1(A),B,G,k2_setwiseo(A,H)) = k8_funct_2(A,B,E,H) )
                                    & ! [H] :
                                        ( m1_subset_1(H,k5_finsub_1(A))
                                       => ( r1_tarski(H,D)
                                         => ( H = k1_xboole_0
                                            | ! [I] :
                                                ( m1_subset_1(I,A)
                                               => ( r2_hidden(I,D)
                                                 => k8_funct_2(k5_finsub_1(A),B,G,k5_setwiseo(A,H,k2_setwiseo(A,I))) = k2_binop_1(B,B,B,C,k8_funct_2(k5_finsub_1(A),B,G,H),k8_funct_2(A,B,E,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(t26_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ( ( v1_binop_1(C,A)
                      & v2_binop_1(C,A) )
                   => ! [E] :
                        ( m1_subset_1(E,B)
                       => k7_setwiseo(B,A,C,k2_setwiseo(B,E),D) = k8_funct_2(B,A,D,E) ) ) ) ) ) ) ).

fof(t27_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ( ( v3_binop_1(C,A)
                      & v1_binop_1(C,A)
                      & v2_binop_1(C,A) )
                   => ! [E] :
                        ( m1_subset_1(E,B)
                       => ! [F] :
                            ( m1_subset_1(F,B)
                           => k7_setwiseo(B,A,C,k3_setwiseo(B,E,F),D) = k2_binop_1(A,A,A,C,k8_funct_2(B,A,D,E),k8_funct_2(B,A,D,F)) ) ) ) ) ) ) ) ).

fof(t28_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ( ( v3_binop_1(C,A)
                      & v1_binop_1(C,A)
                      & v2_binop_1(C,A) )
                   => ! [E] :
                        ( m1_subset_1(E,B)
                       => ! [F] :
                            ( m1_subset_1(F,B)
                           => ! [G] :
                                ( m1_subset_1(G,B)
                               => k7_setwiseo(B,A,C,k4_setwiseo(B,E,F,G),D) = k2_binop_1(A,A,A,C,k2_binop_1(A,A,A,C,k8_funct_2(B,A,D,E),k8_funct_2(B,A,D,F)),k8_funct_2(B,A,D,G)) ) ) ) ) ) ) ) ) ).

fof(t29_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(B))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ( ( v3_binop_1(C,A)
                          & v1_binop_1(C,A)
                          & v2_binop_1(C,A) )
                       => ( D = k1_xboole_0
                          | ! [F] :
                              ( m1_subset_1(F,B)
                             => k7_setwiseo(B,A,C,k5_setwiseo(B,D,k2_setwiseo(B,F)),E) = k2_binop_1(A,A,A,C,k7_setwiseo(B,A,C,D,E),k8_funct_2(B,A,E,F)) ) ) ) ) ) ) ) ) ).

fof(t30_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ( ( v3_binop_1(C,A)
                      & v1_binop_1(C,A)
                      & v2_binop_1(C,A) )
                   => ! [E] :
                        ( m1_subset_1(E,k5_finsub_1(B))
                       => ! [F] :
                            ( m1_subset_1(F,k5_finsub_1(B))
                           => ~ ( E != k1_xboole_0
                                & F != k1_xboole_0
                                & k7_setwiseo(B,A,C,k5_setwiseo(B,E,F),D) != k2_binop_1(A,A,A,C,k7_setwiseo(B,A,C,E,D),k7_setwiseo(B,A,C,F,D)) ) ) ) ) ) ) ) ) ).

fof(t31_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(B))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ( ( v1_binop_1(C,A)
                          & v2_binop_1(C,A)
                          & v3_binop_1(C,A) )
                       => ! [F] :
                            ( m1_subset_1(F,B)
                           => ( r2_hidden(F,D)
                             => k2_binop_1(A,A,A,C,k8_funct_2(B,A,E,F),k7_setwiseo(B,A,C,D,E)) = k7_setwiseo(B,A,C,D,E) ) ) ) ) ) ) ) ) ).

fof(t32_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ( ( v1_binop_1(C,A)
                      & v2_binop_1(C,A)
                      & v3_binop_1(C,A) )
                   => ! [E] :
                        ( m1_subset_1(E,k5_finsub_1(B))
                       => ! [F] :
                            ( m1_subset_1(F,k5_finsub_1(B))
                           => ( r1_tarski(E,F)
                             => ( E = k1_xboole_0
                                | k2_binop_1(A,A,A,C,k7_setwiseo(B,A,C,E,D),k7_setwiseo(B,A,C,F,D)) = k7_setwiseo(B,A,C,F,D) ) ) ) ) ) ) ) ) ) ).

fof(t33_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(B))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ( ( v1_binop_1(C,A)
                          & v2_binop_1(C,A)
                          & v3_binop_1(C,A) )
                       => ( D = k1_xboole_0
                          | ! [F] :
                              ( m1_subset_1(F,A)
                             => ( ! [G] :
                                    ( m1_subset_1(G,B)
                                   => ( r2_hidden(G,D)
                                     => k8_funct_2(B,A,E,G) = F ) )
                               => k7_setwiseo(B,A,C,D,E) = F ) ) ) ) ) ) ) ) ) ).

fof(t34_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(A))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ( ( v1_binop_1(C,B)
                          & v2_binop_1(C,B)
                          & v3_binop_1(C,B) )
                       => ! [F] :
                            ( m1_subset_1(F,B)
                           => ( k2_funct_2(A,B,E,D) = k2_setwiseo(B,F)
                             => k7_setwiseo(A,B,C,D,E) = F ) ) ) ) ) ) ) ) ).

fof(t35_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ( ( v1_binop_1(C,B)
                  & v2_binop_1(C,B)
                  & v3_binop_1(C,B) )
               => ! [D] :
                    ( ( v1_funct_1(D)
                      & v1_funct_2(D,A,B)
                      & m2_relset_1(D,A,B) )
                   => ! [E] :
                        ( ( v1_funct_1(E)
                          & v1_funct_2(E,A,B)
                          & m2_relset_1(E,A,B) )
                       => ! [F] :
                            ( m1_subset_1(F,k5_finsub_1(A))
                           => ! [G] :
                                ( m1_subset_1(G,k5_finsub_1(A))
                               => ( k2_funct_2(A,B,D,F) = k2_funct_2(A,B,E,G)
                                 => ( F = k1_xboole_0
                                    | k7_setwiseo(A,B,C,F,D) = k7_setwiseo(A,B,C,G,E) ) ) ) ) ) ) ) ) ) ) ).

fof(t36_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ( ( v3_binop_1(C,A)
                      & v1_binop_1(C,A)
                      & v2_binop_1(C,A)
                      & r6_binop_1(A,D,C) )
                   => ! [E] :
                        ( m1_subset_1(E,k5_finsub_1(B))
                       => ( E != k1_xboole_0
                         => ! [F] :
                              ( ( v1_funct_1(F)
                                & v1_funct_2(F,B,A)
                                & m2_relset_1(F,B,A) )
                             => ! [G] :
                                  ( m1_subset_1(G,A)
                                 => k2_binop_1(A,A,A,D,G,k7_setwiseo(B,A,C,E,F)) = k7_setwiseo(B,A,C,E,k8_funcop_1(A,B,D,G,F)) ) ) ) ) ) ) ) ) ) ).

fof(t37_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ( ( v3_binop_1(C,A)
                      & v1_binop_1(C,A)
                      & v2_binop_1(C,A)
                      & r6_binop_1(A,D,C) )
                   => ! [E] :
                        ( m1_subset_1(E,k5_finsub_1(B))
                       => ( E != k1_xboole_0
                         => ! [F] :
                              ( ( v1_funct_1(F)
                                & v1_funct_2(F,B,A)
                                & m2_relset_1(F,B,A) )
                             => ! [G] :
                                  ( m1_subset_1(G,A)
                                 => k2_binop_1(A,A,A,D,k7_setwiseo(B,A,C,E,F),G) = k7_setwiseo(B,A,C,E,k7_funcop_1(A,B,D,F,G)) ) ) ) ) ) ) ) ) ) ).

fof(t38_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ( ( v3_binop_1(D,A)
                      & v1_binop_1(D,A)
                      & v2_binop_1(D,A) )
                   => ! [E] :
                        ( m1_subset_1(E,k5_finsub_1(B))
                       => ( E != k1_xboole_0
                         => ! [F] :
                              ( ( v1_funct_1(F)
                                & v1_funct_2(F,B,C)
                                & m2_relset_1(F,B,C) )
                             => ! [G] :
                                  ( ( v1_funct_1(G)
                                    & v1_funct_2(G,C,A)
                                    & m2_relset_1(G,C,A) )
                                 => k7_setwiseo(C,A,D,k8_setwiseo(B,C,F,E),G) = k7_setwiseo(B,A,D,E,k7_funct_2(B,C,A,F,G)) ) ) ) ) ) ) ) ) ) ).

fof(t39_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ( ( v1_binop_1(C,B)
                  & v2_binop_1(C,B)
                  & v3_binop_1(C,B) )
               => ! [D] :
                    ( ~ v1_xboole_0(D)
                   => ! [E] :
                        ( ( v1_funct_1(E)
                          & v1_funct_2(E,k2_zfmisc_1(D,D),D)
                          & m2_relset_1(E,k2_zfmisc_1(D,D),D) )
                       => ( ( v1_binop_1(E,D)
                            & v2_binop_1(E,D)
                            & v3_binop_1(E,D) )
                         => ! [F] :
                              ( ( v1_funct_1(F)
                                & v1_funct_2(F,A,B)
                                & m2_relset_1(F,A,B) )
                             => ! [G] :
                                  ( ( v1_funct_1(G)
                                    & v1_funct_2(G,B,D)
                                    & m2_relset_1(G,B,D) )
                                 => ( ! [H] :
                                        ( m1_subset_1(H,B)
                                       => ! [I] :
                                            ( m1_subset_1(I,B)
                                           => k8_funct_2(B,D,G,k2_binop_1(B,B,B,C,H,I)) = k2_binop_1(D,D,D,E,k8_funct_2(B,D,G,H),k8_funct_2(B,D,G,I)) ) )
                                   => ! [H] :
                                        ( m1_subset_1(H,k5_finsub_1(A))
                                       => ( H != k1_xboole_0
                                         => k8_funct_2(B,D,G,k7_setwiseo(A,B,C,H,F)) = k7_setwiseo(A,D,E,H,k7_funct_2(A,B,D,F,G)) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(t40_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( ( v1_binop_1(C,A)
                  & v2_binop_1(C,A)
                  & v1_setwiseo(C,A) )
               => ! [D] :
                    ( ( v1_funct_1(D)
                      & v1_funct_2(D,B,A)
                      & m2_relset_1(D,B,A) )
                   => k7_setwiseo(B,A,C,k1_setwiseo(B),D) = k3_binop_1(A,C) ) ) ) ) ) ).

fof(t41_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( m1_subset_1(D,k5_finsub_1(B))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ( ( v3_binop_1(C,A)
                          & v1_binop_1(C,A)
                          & v2_binop_1(C,A)
                          & v1_setwiseo(C,A) )
                       => ! [F] :
                            ( m1_subset_1(F,B)
                           => k7_setwiseo(B,A,C,k5_setwiseo(B,D,k2_setwiseo(B,F)),E) = k2_binop_1(A,A,A,C,k7_setwiseo(B,A,C,D,E),k8_funct_2(B,A,E,F)) ) ) ) ) ) ) ) ).

fof(t42_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ( ( v3_binop_1(C,A)
                      & v1_binop_1(C,A)
                      & v2_binop_1(C,A)
                      & v1_setwiseo(C,A) )
                   => ! [E] :
                        ( m1_subset_1(E,k5_finsub_1(B))
                       => ! [F] :
                            ( m1_subset_1(F,k5_finsub_1(B))
                           => k7_setwiseo(B,A,C,k5_setwiseo(B,E,F),D) = k2_binop_1(A,A,A,C,k7_setwiseo(B,A,C,E,D),k7_setwiseo(B,A,C,F,D)) ) ) ) ) ) ) ) ).

fof(t43_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ( ( v1_binop_1(C,B)
                  & v2_binop_1(C,B)
                  & v3_binop_1(C,B)
                  & v1_setwiseo(C,B) )
               => ! [D] :
                    ( ( v1_funct_1(D)
                      & v1_funct_2(D,A,B)
                      & m2_relset_1(D,A,B) )
                   => ! [E] :
                        ( ( v1_funct_1(E)
                          & v1_funct_2(E,A,B)
                          & m2_relset_1(E,A,B) )
                       => ! [F] :
                            ( m1_subset_1(F,k5_finsub_1(A))
                           => ! [G] :
                                ( m1_subset_1(G,k5_finsub_1(A))
                               => ( k8_setwiseo(A,B,D,F) = k8_setwiseo(A,B,E,G)
                                 => k7_setwiseo(A,B,C,F,D) = k7_setwiseo(A,B,C,G,E) ) ) ) ) ) ) ) ) ) ).

fof(t44_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ( ( v3_binop_1(D,A)
                      & v1_binop_1(D,A)
                      & v2_binop_1(D,A)
                      & v1_setwiseo(D,A) )
                   => ! [E] :
                        ( m1_subset_1(E,k5_finsub_1(B))
                       => ! [F] :
                            ( ( v1_funct_1(F)
                              & v1_funct_2(F,B,C)
                              & m2_relset_1(F,B,C) )
                           => ! [G] :
                                ( ( v1_funct_1(G)
                                  & v1_funct_2(G,C,A)
                                  & m2_relset_1(G,C,A) )
                               => k7_setwiseo(C,A,D,k8_setwiseo(B,C,F,E),G) = k7_setwiseo(B,A,D,E,k7_funct_2(B,C,A,F,G)) ) ) ) ) ) ) ) ) ).

fof(t45_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ( ( v1_binop_1(C,B)
                  & v2_binop_1(C,B)
                  & v3_binop_1(C,B)
                  & v1_setwiseo(C,B) )
               => ! [D] :
                    ( ~ v1_xboole_0(D)
                   => ! [E] :
                        ( ( v1_funct_1(E)
                          & v1_funct_2(E,k2_zfmisc_1(D,D),D)
                          & m2_relset_1(E,k2_zfmisc_1(D,D),D) )
                       => ( ( v1_binop_1(E,D)
                            & v2_binop_1(E,D)
                            & v3_binop_1(E,D)
                            & v1_setwiseo(E,D) )
                         => ! [F] :
                              ( ( v1_funct_1(F)
                                & v1_funct_2(F,A,B)
                                & m2_relset_1(F,A,B) )
                             => ! [G] :
                                  ( ( v1_funct_1(G)
                                    & v1_funct_2(G,B,D)
                                    & m2_relset_1(G,B,D) )
                                 => ( ( k8_funct_2(B,D,G,k3_binop_1(B,C)) = k3_binop_1(D,E)
                                      & ! [H] :
                                          ( m1_subset_1(H,B)
                                         => ! [I] :
                                              ( m1_subset_1(I,B)
                                             => k8_funct_2(B,D,G,k2_binop_1(B,B,B,C,H,I)) = k2_binop_1(D,D,D,E,k8_funct_2(B,D,G,H),k8_funct_2(B,D,G,I)) ) ) )
                                   => ! [H] :
                                        ( m1_subset_1(H,k5_finsub_1(A))
                                       => k8_funct_2(B,D,G,k7_setwiseo(A,B,C,H,F)) = k7_setwiseo(A,D,E,H,k7_funct_2(A,B,D,F,G)) ) ) ) ) ) ) ) ) ) ) ) ).

fof(d4_setwiseo,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(k5_finsub_1(A),k5_finsub_1(A)),k5_finsub_1(A))
        & m2_relset_1(B,k2_zfmisc_1(k5_finsub_1(A),k5_finsub_1(A)),k5_finsub_1(A)) )
     => ( B = k9_setwiseo(A)
      <=> ! [C] :
            ( m1_subset_1(C,k5_finsub_1(A))
           => ! [D] :
                ( m1_subset_1(D,k5_finsub_1(A))
               => k2_binop_1(k5_finsub_1(A),k5_finsub_1(A),k5_finsub_1(A),B,C,D) = k5_setwiseo(A,C,D) ) ) ) ) ).

fof(t46_setwiseo,axiom,
    $true ).

fof(t47_setwiseo,axiom,
    $true ).

fof(t48_setwiseo,axiom,
    $true ).

fof(t49_setwiseo,axiom,
    ! [A] : v3_binop_1(k9_setwiseo(A),k5_finsub_1(A)) ).

fof(t50_setwiseo,axiom,
    ! [A] : v1_binop_1(k9_setwiseo(A),k5_finsub_1(A)) ).

fof(t51_setwiseo,axiom,
    ! [A] : v2_binop_1(k9_setwiseo(A),k5_finsub_1(A)) ).

fof(t52_setwiseo,axiom,
    ! [A] : r3_binop_1(k5_finsub_1(A),k1_setwiseo(A),k9_setwiseo(A)) ).

fof(t53_setwiseo,axiom,
    ! [A] : v1_setwiseo(k9_setwiseo(A),k5_finsub_1(A)) ).

fof(t54_setwiseo,axiom,
    ! [A] : r3_binop_1(k5_finsub_1(A),k3_binop_1(k5_finsub_1(A),k9_setwiseo(A)),k9_setwiseo(A)) ).

fof(t55_setwiseo,axiom,
    ! [A] : k3_binop_1(k5_finsub_1(A),k9_setwiseo(A)) = k1_xboole_0 ).

fof(d5_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( m1_subset_1(C,k5_finsub_1(A))
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,k5_finsub_1(B))
                & m2_relset_1(D,A,k5_finsub_1(B)) )
             => k10_setwiseo(A,B,C,D) = k7_setwiseo(A,k5_finsub_1(B),k9_setwiseo(B),C,D) ) ) ) ).

fof(t56_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => ! [D] :
              ( m1_subset_1(D,A)
             => k10_setwiseo(A,B,k2_setwiseo(A,D),C) = k8_funct_2(A,k5_finsub_1(B),C,D) ) ) ) ).

fof(t57_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => k10_setwiseo(A,B,k3_setwiseo(A,D,E),C) = k5_setwiseo(B,k8_funct_2(A,k5_finsub_1(B),C,D),k8_funct_2(A,k5_finsub_1(B),C,E)) ) ) ) ) ).

fof(t58_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => k10_setwiseo(A,B,k4_setwiseo(A,D,E,F),C) = k5_setwiseo(B,k5_setwiseo(B,k8_funct_2(A,k5_finsub_1(B),C,D),k8_funct_2(A,k5_finsub_1(B),C,E)),k8_funct_2(A,k5_finsub_1(B),C,F)) ) ) ) ) ) ).

fof(t59_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => k10_setwiseo(A,B,k1_setwiseo(A),C) = k1_xboole_0 ) ) ).

fof(t60_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,k5_finsub_1(A))
                 => k10_setwiseo(A,B,k5_setwiseo(A,E,k2_setwiseo(A,D)),C) = k5_setwiseo(B,k10_setwiseo(A,B,E,C),k8_funct_2(A,k5_finsub_1(B),C,D)) ) ) ) ) ).

fof(t61_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => ! [D] :
              ( m1_subset_1(D,k5_finsub_1(A))
             => k10_setwiseo(A,B,D,C) = k3_tarski(k8_setwiseo(A,k5_finsub_1(B),C,D)) ) ) ) ).

fof(t62_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => ! [D] :
              ( m1_subset_1(D,k5_finsub_1(A))
             => ! [E] :
                  ( m1_subset_1(E,k5_finsub_1(A))
                 => k10_setwiseo(A,B,k5_setwiseo(A,D,E),C) = k5_setwiseo(B,k10_setwiseo(A,B,D,C),k10_setwiseo(A,B,E,C)) ) ) ) ) ).

fof(t63_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C,D] :
              ( m1_subset_1(D,k5_finsub_1(A))
             => ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,A,B)
                    & m2_relset_1(E,A,B) )
                 => ! [F] :
                      ( ( v1_funct_1(F)
                        & v1_funct_2(F,B,k5_finsub_1(C))
                        & m2_relset_1(F,B,k5_finsub_1(C)) )
                     => k10_setwiseo(B,C,k8_setwiseo(A,B,E,D),F) = k10_setwiseo(A,C,D,k7_funct_2(A,B,k5_finsub_1(C),E,F)) ) ) ) ) ) ).

fof(t64_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C,D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
             => ( ( v1_binop_1(D,A)
                  & v2_binop_1(D,A)
                  & v3_binop_1(D,A) )
               => ! [E] :
                    ( m1_subset_1(E,k5_finsub_1(B))
                   => ( E != k1_xboole_0
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,B,k5_finsub_1(C))
                            & m2_relset_1(F,B,k5_finsub_1(C)) )
                         => ! [G] :
                              ( ( v1_funct_1(G)
                                & v1_funct_2(G,k5_finsub_1(C),A)
                                & m2_relset_1(G,k5_finsub_1(C),A) )
                             => ( ! [H] :
                                    ( m1_subset_1(H,k5_finsub_1(C))
                                   => ! [I] :
                                        ( m1_subset_1(I,k5_finsub_1(C))
                                       => k8_funct_2(k5_finsub_1(C),A,G,k5_setwiseo(C,H,I)) = k2_binop_1(A,A,A,D,k8_funct_2(k5_finsub_1(C),A,G,H),k8_funct_2(k5_finsub_1(C),A,G,I)) ) )
                               => k8_funct_2(k5_finsub_1(C),A,G,k10_setwiseo(B,C,E,F)) = k7_setwiseo(B,A,D,E,k7_funct_2(B,k5_finsub_1(C),A,F,G)) ) ) ) ) ) ) ) ) ) ).

fof(t65_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C,D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,k2_zfmisc_1(B,B),B)
                & m2_relset_1(D,k2_zfmisc_1(B,B),B) )
             => ( ( v1_binop_1(D,B)
                  & v2_binop_1(D,B)
                  & v3_binop_1(D,B)
                  & v1_setwiseo(D,B) )
               => ! [E] :
                    ( ( v1_funct_1(E)
                      & v1_funct_2(E,A,k5_finsub_1(C))
                      & m2_relset_1(E,A,k5_finsub_1(C)) )
                   => ! [F] :
                        ( ( v1_funct_1(F)
                          & v1_funct_2(F,k5_finsub_1(C),B)
                          & m2_relset_1(F,k5_finsub_1(C),B) )
                       => ( ( k8_funct_2(k5_finsub_1(C),B,F,k1_setwiseo(C)) = k3_binop_1(B,D)
                            & ! [G] :
                                ( m1_subset_1(G,k5_finsub_1(C))
                               => ! [H] :
                                    ( m1_subset_1(H,k5_finsub_1(C))
                                   => k8_funct_2(k5_finsub_1(C),B,F,k5_setwiseo(C,G,H)) = k2_binop_1(B,B,B,D,k8_funct_2(k5_finsub_1(C),B,F,G),k8_funct_2(k5_finsub_1(C),B,F,H)) ) ) )
                         => ! [G] :
                              ( m1_subset_1(G,k5_finsub_1(A))
                             => k8_funct_2(k5_finsub_1(C),B,F,k10_setwiseo(A,C,G,E)) = k7_setwiseo(A,B,D,G,k7_funct_2(A,k5_finsub_1(C),B,E,F)) ) ) ) ) ) ) ) ) ).

fof(d6_setwiseo,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,k5_finsub_1(A))
        & m2_relset_1(B,A,k5_finsub_1(A)) )
     => ( B = k11_setwiseo(A)
      <=> ! [C] :
            ( r2_hidden(C,A)
           => k1_funct_1(B,C) = k1_tarski(C) ) ) ) ).

fof(t66_setwiseo,axiom,
    $true ).

fof(t67_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,A,k5_finsub_1(A))
            & m2_relset_1(B,A,k5_finsub_1(A)) )
         => ( B = k11_setwiseo(A)
          <=> ! [C] :
                ( m1_subset_1(C,A)
               => k8_funct_2(A,k5_finsub_1(A),B,C) = k2_setwiseo(A,C) ) ) ) ) ).

fof(t68_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( m1_subset_1(C,A)
         => ( r2_hidden(B,k8_funct_2(A,k5_finsub_1(A),k11_setwiseo(A),C))
          <=> B = C ) ) ) ).

fof(t69_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ( ( r2_hidden(B,k8_funct_2(A,k5_finsub_1(A),k11_setwiseo(A),D))
                      & r2_hidden(C,k8_funct_2(A,k5_finsub_1(A),k11_setwiseo(A),D)) )
                   => B = C ) ) ) ) ) ).

fof(t70_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,k5_finsub_1(B))
            & m2_relset_1(C,A,k5_finsub_1(B)) )
         => ! [D] :
              ( m1_subset_1(D,k5_finsub_1(A))
             => ! [E] :
                  ( r2_hidden(E,k10_setwiseo(A,B,D,C))
                <=> ? [F] :
                      ( m1_subset_1(F,A)
                      & r2_hidden(F,D)
                      & r2_hidden(E,k8_funct_2(A,k5_finsub_1(B),C,F)) ) ) ) ) ) ).

fof(t71_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,k5_finsub_1(A))
         => k10_setwiseo(A,A,B,k11_setwiseo(A)) = B ) ) ).

fof(t72_setwiseo,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C,D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,k5_finsub_1(B))
            & m2_relset_1(D,A,k5_finsub_1(B)) )
         => ! [E] :
              ( ( v1_funct_1(E)
                & v1_funct_2(E,k5_finsub_1(B),k5_finsub_1(C))
                & m2_relset_1(E,k5_finsub_1(B),k5_finsub_1(C)) )
             => ( ( k8_funct_2(k5_finsub_1(B),k5_finsub_1(C),E,k1_setwiseo(B)) = k1_setwiseo(C)
                  & ! [F] :
                      ( m1_subset_1(F,k5_finsub_1(B))
                     => ! [G] :
                          ( m1_subset_1(G,k5_finsub_1(B))
                         => k8_funct_2(k5_finsub_1(B),k5_finsub_1(C),E,k5_setwiseo(B,F,G)) = k5_setwiseo(C,k8_funct_2(k5_finsub_1(B),k5_finsub_1(C),E,F),k8_funct_2(k5_finsub_1(B),k5_finsub_1(C),E,G)) ) ) )
               => ! [F] :
                    ( m1_subset_1(F,k5_finsub_1(A))
                   => k8_funct_2(k5_finsub_1(B),k5_finsub_1(C),E,k10_setwiseo(A,B,F,D)) = k10_setwiseo(A,C,F,k7_funct_2(A,k5_finsub_1(B),k5_finsub_1(C),D,E)) ) ) ) ) ) ).

fof(s1_setwiseo,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,f1_s1_setwiseo,k5_finsub_1(f1_s1_setwiseo))
      & m2_relset_1(A,f1_s1_setwiseo,k5_finsub_1(f1_s1_setwiseo))
      & ! [B] :
          ( m1_subset_1(B,f1_s1_setwiseo)
         => ! [C] :
              ( m1_subset_1(C,f1_s1_setwiseo)
             => ( r2_hidden(C,k8_funct_2(f1_s1_setwiseo,k5_finsub_1(f1_s1_setwiseo),A,B))
              <=> ( r2_hidden(C,f2_s1_setwiseo)
                  & p1_s1_setwiseo(C,B) ) ) ) ) ) ).

fof(s2_setwiseo,axiom,
    ( ( p1_s2_setwiseo(k1_setwiseo(f1_s2_setwiseo))
      & ! [A] :
          ( m1_subset_1(A,k5_finsub_1(f1_s2_setwiseo))
         => ! [B] :
              ( m1_subset_1(B,f1_s2_setwiseo)
             => ( p1_s2_setwiseo(A)
               => ( r2_hidden(B,A)
                  | p1_s2_setwiseo(k5_setwiseo(f1_s2_setwiseo,A,k2_setwiseo(f1_s2_setwiseo,B))) ) ) ) ) )
   => ! [A] :
        ( m1_subset_1(A,k5_finsub_1(f1_s2_setwiseo))
       => p1_s2_setwiseo(A) ) ) ).

fof(s3_setwiseo,axiom,
    ( ( ! [A] :
          ( m1_subset_1(A,f1_s3_setwiseo)
         => p1_s3_setwiseo(k2_setwiseo(f1_s3_setwiseo,A)) )
      & ! [A] :
          ( m1_subset_1(A,k5_finsub_1(f1_s3_setwiseo))
         => ! [B] :
              ( m1_subset_1(B,k5_finsub_1(f1_s3_setwiseo))
             => ( ( p1_s3_setwiseo(A)
                  & p1_s3_setwiseo(B) )
               => ( A = k1_xboole_0
                  | B = k1_xboole_0
                  | p1_s3_setwiseo(k5_setwiseo(f1_s3_setwiseo,A,B)) ) ) ) ) )
   => ! [A] :
        ( m1_subset_1(A,k5_finsub_1(f1_s3_setwiseo))
       => ( A != k1_xboole_0
         => p1_s3_setwiseo(A) ) ) ) ).

fof(s4_setwiseo,axiom,
    ( ( p1_s4_setwiseo(k1_setwiseo(f1_s4_setwiseo))
      & ! [A] :
          ( m1_subset_1(A,k5_finsub_1(f1_s4_setwiseo))
         => ! [B] :
              ( m1_subset_1(B,f1_s4_setwiseo)
             => ( p1_s4_setwiseo(A)
               => p1_s4_setwiseo(k5_setwiseo(f1_s4_setwiseo,A,k2_setwiseo(f1_s4_setwiseo,B))) ) ) ) )
   => ! [A] :
        ( m1_subset_1(A,k5_finsub_1(f1_s4_setwiseo))
       => p1_s4_setwiseo(A) ) ) ).

fof(dt_k1_setwiseo,axiom,
    ! [A] :
      ( v1_xboole_0(k1_setwiseo(A))
      & m1_subset_1(k1_setwiseo(A),k5_finsub_1(A)) ) ).

fof(dt_k2_setwiseo,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A) )
     => m1_subset_1(k2_setwiseo(A,B),k5_finsub_1(A)) ) ).

fof(redefinition_k2_setwiseo,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A) )
     => k2_setwiseo(A,B) = k1_tarski(B) ) ).

fof(dt_k3_setwiseo,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => m1_subset_1(k3_setwiseo(A,B,C),k5_finsub_1(A)) ) ).

fof(commutativity_k3_setwiseo,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k3_setwiseo(A,B,C) = k3_setwiseo(A,C,B) ) ).

fof(redefinition_k3_setwiseo,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A) )
     => k3_setwiseo(A,B,C) = k2_tarski(B,C) ) ).

fof(dt_k4_setwiseo,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A) )
     => m1_subset_1(k4_setwiseo(A,B,C,D),k5_finsub_1(A)) ) ).

fof(redefinition_k4_setwiseo,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A)
        & m1_subset_1(C,A)
        & m1_subset_1(D,A) )
     => k4_setwiseo(A,B,C,D) = k1_enumset1(B,C,D) ) ).

fof(dt_k5_setwiseo,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k5_finsub_1(A))
        & m1_subset_1(C,k5_finsub_1(A)) )
     => m1_subset_1(k5_setwiseo(A,B,C),k5_finsub_1(A)) ) ).

fof(commutativity_k5_setwiseo,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k5_finsub_1(A))
        & m1_subset_1(C,k5_finsub_1(A)) )
     => k5_setwiseo(A,B,C) = k5_setwiseo(A,C,B) ) ).

fof(idempotence_k5_setwiseo,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k5_finsub_1(A))
        & m1_subset_1(C,k5_finsub_1(A)) )
     => k5_setwiseo(A,B,B) = B ) ).

fof(redefinition_k5_setwiseo,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k5_finsub_1(A))
        & m1_subset_1(C,k5_finsub_1(A)) )
     => k5_setwiseo(A,B,C) = k2_xboole_0(B,C) ) ).

fof(dt_k6_setwiseo,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k5_finsub_1(A))
        & m1_subset_1(C,k5_finsub_1(A)) )
     => m1_subset_1(k6_setwiseo(A,B,C),k5_finsub_1(A)) ) ).

fof(redefinition_k6_setwiseo,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k5_finsub_1(A))
        & m1_subset_1(C,k5_finsub_1(A)) )
     => k6_setwiseo(A,B,C) = k4_xboole_0(B,C) ) ).

fof(dt_k7_setwiseo,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(B,B),B)
        & m1_relset_1(C,k2_zfmisc_1(B,B),B)
        & m1_subset_1(D,k5_finsub_1(A))
        & v1_funct_1(E)
        & v1_funct_2(E,A,B)
        & m1_relset_1(E,A,B) )
     => m1_subset_1(k7_setwiseo(A,B,C,D,E),B) ) ).

fof(dt_k8_setwiseo,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_subset_1(D,k5_finsub_1(A)) )
     => m1_subset_1(k8_setwiseo(A,B,C,D),k5_finsub_1(B)) ) ).

fof(redefinition_k8_setwiseo,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_subset_1(D,k5_finsub_1(A)) )
     => k8_setwiseo(A,B,C,D) = k9_relat_1(C,D) ) ).

fof(dt_k9_setwiseo,axiom,
    ! [A] :
      ( v1_funct_1(k9_setwiseo(A))
      & v1_funct_2(k9_setwiseo(A),k2_zfmisc_1(k5_finsub_1(A),k5_finsub_1(A)),k5_finsub_1(A))
      & m2_relset_1(k9_setwiseo(A),k2_zfmisc_1(k5_finsub_1(A),k5_finsub_1(A)),k5_finsub_1(A)) ) ).

fof(dt_k10_setwiseo,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(C,k5_finsub_1(A))
        & v1_funct_1(D)
        & v1_funct_2(D,A,k5_finsub_1(B))
        & m1_relset_1(D,A,k5_finsub_1(B)) )
     => m1_subset_1(k10_setwiseo(A,B,C,D),k5_finsub_1(B)) ) ).

fof(dt_k11_setwiseo,axiom,
    ! [A] :
      ( v1_funct_1(k11_setwiseo(A))
      & v1_funct_2(k11_setwiseo(A),A,k5_finsub_1(A))
      & m2_relset_1(k11_setwiseo(A),A,k5_finsub_1(A)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_fraenkel,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_fraenkel(A) ) ).

fof(cc1_fraenkel,axiom,
    ! [A] :
      ( v1_fraenkel(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ( v1_relat_1(B)
            & v1_funct_1(B) ) ) ) ).

fof(fc1_fraenkel,axiom,
    ! [A,B] : v1_fraenkel(k1_funct_2(A,B)) ).

fof(fc2_fraenkel,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => ( v1_finset_1(k1_funct_2(A,B))
        & v1_fraenkel(k1_funct_2(A,B)) ) ) ).

fof(t1_fraenkel,axiom,
    $true ).

fof(t2_fraenkel,axiom,
    $true ).

fof(t3_fraenkel,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,A,B)
                & m2_relset_1(C,A,B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( k7_relat_1(C,E) = k7_relat_1(D,E)
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ( r2_hidden(F,E)
                           => k8_funct_2(A,B,C,F) = k8_funct_2(A,B,D,F) ) ) ) ) ) ) ) ).

fof(t4_fraenkel,axiom,
    $true ).

fof(t5_fraenkel,axiom,
    ! [A,B] : r1_tarski(k1_funct_2(A,B),k1_zfmisc_1(k2_zfmisc_1(A,B))) ).

fof(t6_fraenkel,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C,D] :
          ( ( r1_tarski(C,B)
            & r1_tarski(D,A) )
         => ( k1_funct_2(C,D) = k1_xboole_0
            | ! [E] :
                ( m1_subset_1(E,k1_funct_2(C,D))
               => ( v1_funct_1(E)
                  & m2_relset_1(E,B,A) ) ) ) ) ) ).

fof(d1_fraenkel,axiom,
    ! [A] :
      ( v1_fraenkel(A)
    <=> ! [B] :
          ( r2_hidden(B,A)
         => ( v1_relat_1(B)
            & v1_funct_1(B) ) ) ) ).

fof(t7_fraenkel,axiom,
    $true ).

fof(t8_fraenkel,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => v1_fraenkel(k1_tarski(A)) ) ).

fof(d2_fraenkel,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(C)
        & v1_fraenkel(C) )
     => ( m1_fraenkel(C,A,B)
      <=> ! [D] :
            ( m1_subset_1(D,C)
           => ( v1_funct_1(D)
              & v1_funct_2(D,A,B)
              & m2_relset_1(D,A,B) ) ) ) ) ).

fof(t9_fraenkel,axiom,
    $true ).

fof(t10_fraenkel,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => m1_fraenkel(k2_setwiseo(k1_zfmisc_1(k2_zfmisc_1(A,B)),C),A,B) ) ).

fof(t11_fraenkel,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] : m1_fraenkel(k1_funct_2(B,A),B,A) ) ).

fof(t12_fraenkel,axiom,
    $true ).

fof(t13_fraenkel,axiom,
    $true ).

fof(t14_fraenkel,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C,D] :
          ( ( r1_tarski(C,B)
            & r1_tarski(D,A) )
         => ( k1_funct_2(C,D) = k1_xboole_0
            | ! [E] :
                ( m1_subset_1(E,k1_funct_2(C,D))
               => ? [F] :
                    ( m2_fraenkel(F,B,A,k1_fraenkel(B,A))
                    & k7_relat_1(F,C) = E ) ) ) ) ) ).

fof(t15_fraenkel,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C,D] :
          ( m2_fraenkel(D,B,A,k1_fraenkel(B,A))
         => k7_relat_1(D,C) = k7_relat_1(D,k3_xboole_0(B,C)) ) ) ).

fof(t16_fraenkel,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k1_funct_2(A,B)) ) ).

fof(t17_fraenkel,axiom,
    ! [A] :
      ( v1_fraenkel(A)
     => ! [B] :
          ( r1_tarski(B,A)
         => v1_fraenkel(B) ) ) ).

fof(s23_fraenkel,axiom,
    ( ( ! [A] :
          ( m1_subset_1(A,f1_s23_fraenkel)
         => p1_s23_fraenkel(A,A) )
      & ! [A] :
          ( m1_subset_1(A,f1_s23_fraenkel)
         => ! [B] :
              ( m1_subset_1(B,f1_s23_fraenkel)
             => ! [C] :
                  ( m1_subset_1(C,f1_s23_fraenkel)
                 => ( ( p1_s23_fraenkel(A,B)
                      & p1_s23_fraenkel(B,C) )
                   => p1_s23_fraenkel(A,C) ) ) ) ) )
   => ! [A] :
        ( m1_subset_1(A,f1_s23_fraenkel)
       => ~ ( r2_hidden(A,f2_s23_fraenkel)
            & ! [B] :
                ( m1_subset_1(B,f1_s23_fraenkel)
               => ~ ( r2_hidden(B,f2_s23_fraenkel)
                    & p1_s23_fraenkel(B,A)
                    & ! [C] :
                        ( m1_subset_1(C,f1_s23_fraenkel)
                       => ( ( r2_hidden(C,f2_s23_fraenkel)
                            & p1_s23_fraenkel(C,B) )
                         => p1_s23_fraenkel(B,C) ) ) ) ) ) ) ) ).

fof(s24_fraenkel,axiom,
    ? [A] :
      ( m1_subset_1(A,k5_finsub_1(f1_s24_fraenkel))
      & ! [B] :
          ( m1_subset_1(B,f1_s24_fraenkel)
         => ( r2_hidden(B,A)
          <=> ? [C] :
                ( m1_subset_1(C,f2_s24_fraenkel)
                & r2_hidden(C,f3_s24_fraenkel)
                & B = f4_s24_fraenkel(C)
                & p1_s24_fraenkel(B,C) ) ) ) ) ).

fof(s26_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s26_fraenkel)
       => ~ ( r2_hidden(A,f3_s26_fraenkel)
            & ! [B] :
                ( m1_subset_1(B,f2_s26_fraenkel)
               => ~ p1_s26_fraenkel(A,B) ) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s26_fraenkel,f2_s26_fraenkel)
        & m2_relset_1(A,f1_s26_fraenkel,f2_s26_fraenkel)
        & ! [B] :
            ( m1_subset_1(B,f1_s26_fraenkel)
           => ( r2_hidden(B,f3_s26_fraenkel)
             => p1_s26_fraenkel(B,k8_funct_2(f1_s26_fraenkel,f2_s26_fraenkel,A,B)) ) ) ) ) ).

fof(s27_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s27_fraenkel)
       => ~ ( r2_hidden(A,f3_s27_fraenkel)
            & ! [B] :
                ( m1_subset_1(B,f2_s27_fraenkel)
               => ~ p1_s27_fraenkel(A,B) ) ) )
   => ? [A] :
        ( m2_fraenkel(A,f1_s27_fraenkel,f2_s27_fraenkel,k1_fraenkel(f1_s27_fraenkel,f2_s27_fraenkel))
        & ! [B] :
            ( m1_subset_1(B,f1_s27_fraenkel)
           => ( r2_hidden(B,f3_s27_fraenkel)
             => p1_s27_fraenkel(B,k8_funct_2(f1_s27_fraenkel,f2_s27_fraenkel,A,B)) ) ) ) ) ).

fof(dt_m1_fraenkel,axiom,
    ! [A,B,C] :
      ( m1_fraenkel(C,A,B)
     => ( ~ v1_xboole_0(C)
        & v1_fraenkel(C) ) ) ).

fof(existence_m1_fraenkel,axiom,
    ! [A,B] :
    ? [C] : m1_fraenkel(C,A,B) ).

fof(dt_m2_fraenkel,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & m1_fraenkel(C,A,B) )
     => ! [D] :
          ( m2_fraenkel(D,A,B,C)
         => ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) ) ) ) ).

fof(existence_m2_fraenkel,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & m1_fraenkel(C,A,B) )
     => ? [D] : m2_fraenkel(D,A,B,C) ) ).

fof(redefinition_m2_fraenkel,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(B)
        & m1_fraenkel(C,A,B) )
     => ! [D] :
          ( m2_fraenkel(D,A,B,C)
        <=> m1_subset_1(D,C) ) ) ).

fof(dt_k1_fraenkel,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => m1_fraenkel(k1_fraenkel(A,B),A,B) ) ).

fof(redefinition_k1_fraenkel,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => k1_fraenkel(A,B) = k1_funct_2(A,B) ) ).

fof(s1_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s1_fraenkel)
       => ( p1_s1_fraenkel(A)
         => p2_s1_fraenkel(A) ) )
   => r1_tarski(a_0_0_fraenkel,a_0_1_fraenkel) ) ).

fof(s2_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s2_fraenkel)
       => ! [B] :
            ( m1_subset_1(B,f2_s2_fraenkel)
           => ( p1_s2_fraenkel(A,B)
             => p2_s2_fraenkel(A,B) ) ) )
   => r1_tarski(a_0_2_fraenkel,a_0_3_fraenkel) ) ).

fof(s3_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s3_fraenkel)
       => ( p1_s3_fraenkel(A)
        <=> p2_s3_fraenkel(A) ) )
   => a_0_4_fraenkel = a_0_5_fraenkel ) ).

fof(s4_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s4_fraenkel)
       => ! [B] :
            ( m1_subset_1(B,f2_s4_fraenkel)
           => ( p1_s4_fraenkel(A,B)
            <=> p2_s4_fraenkel(A,B) ) ) )
   => a_0_6_fraenkel = a_0_7_fraenkel ) ).

fof(s5_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s5_fraenkel)
       => f2_s5_fraenkel(A) = f3_s5_fraenkel(A) )
   => a_0_8_fraenkel = a_0_9_fraenkel ) ).

fof(s6_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s6_fraenkel)
       => ( p1_s6_fraenkel(A)
         => f2_s6_fraenkel(A) = f3_s6_fraenkel(A) ) )
   => a_0_10_fraenkel = a_0_11_fraenkel ) ).

fof(s7_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s7_fraenkel)
       => ! [B] :
            ( m1_subset_1(B,f2_s7_fraenkel)
           => f3_s7_fraenkel(A,B) = f4_s7_fraenkel(A,B) ) )
   => a_0_12_fraenkel = a_0_13_fraenkel ) ).

fof(s8_fraenkel,axiom,
    ( ( ! [A] :
          ( m1_subset_1(A,f1_s8_fraenkel)
         => ! [B] :
              ( m1_subset_1(B,f2_s8_fraenkel)
             => ( p1_s8_fraenkel(A,B)
              <=> p2_s8_fraenkel(A,B) ) ) )
      & ! [A] :
          ( m1_subset_1(A,f1_s8_fraenkel)
         => ! [B] :
              ( m1_subset_1(B,f2_s8_fraenkel)
             => f3_s8_fraenkel(A,B) = f3_s8_fraenkel(B,A) ) ) )
   => a_0_14_fraenkel = a_0_15_fraenkel ) ).

fof(s9_fraenkel,axiom,
    ( ( k7_relat_1(f4_s9_fraenkel,f3_s9_fraenkel) = k7_relat_1(f5_s9_fraenkel,f3_s9_fraenkel)
      & ! [A] :
          ( m1_subset_1(A,f1_s9_fraenkel)
         => ( r2_hidden(A,f3_s9_fraenkel)
           => ( p1_s9_fraenkel(A)
            <=> p2_s9_fraenkel(A) ) ) ) )
   => a_0_16_fraenkel = a_0_17_fraenkel ) ).

fof(s10_fraenkel,axiom,
    r1_tarski(a_0_18_fraenkel,f1_s10_fraenkel) ).

fof(s11_fraenkel,axiom,
    ( ! [A] :
        ( r2_hidden(A,a_0_19_fraenkel)
       => p2_s11_fraenkel(A) )
   => ! [A] :
        ( m1_subset_1(A,f1_s11_fraenkel)
       => ! [B] :
            ( m1_subset_1(B,f2_s11_fraenkel)
           => ( p1_s11_fraenkel(A,B)
             => p2_s11_fraenkel(f3_s11_fraenkel(A,B)) ) ) ) ) ).

fof(s12_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s12_fraenkel)
       => ! [B] :
            ( m1_subset_1(B,f2_s12_fraenkel)
           => ( p1_s12_fraenkel(A,B)
             => p2_s12_fraenkel(f3_s12_fraenkel(A,B)) ) ) )
   => ! [A] :
        ( r2_hidden(A,a_0_20_fraenkel)
       => p2_s12_fraenkel(A) ) ) ).

fof(s13_fraenkel,axiom,
    a_0_21_fraenkel = a_0_23_fraenkel ).

fof(s14_fraenkel,axiom,
    a_0_24_fraenkel = a_0_26_fraenkel ).

fof(s15_fraenkel,axiom,
    a_0_27_fraenkel = a_0_29_fraenkel ).

fof(s16_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s16_fraenkel)
       => ! [B] :
            ( m1_subset_1(B,f2_s16_fraenkel)
           => ~ ( p1_s16_fraenkel(A,B)
                & ! [C] :
                    ( m1_subset_1(C,f1_s16_fraenkel)
                   => ~ ( p2_s16_fraenkel(C,B)
                        & f3_s16_fraenkel(A,B) = f3_s16_fraenkel(C,B) ) ) ) ) )
   => r1_tarski(a_0_30_fraenkel,a_0_31_fraenkel) ) ).

fof(s17_fraenkel,axiom,
    r1_tarski(a_0_32_fraenkel,f2_s17_fraenkel) ).

fof(s18_fraenkel,axiom,
    r1_xboole_0(a_0_33_fraenkel,f2_s18_fraenkel) ).

fof(s19_fraenkel,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s19_fraenkel)
       => ! [B] :
            ( m1_subset_1(B,f2_s19_fraenkel)
           => ( p2_s19_fraenkel(A,B)
            <=> ( B = f4_s19_fraenkel
                & p1_s19_fraenkel(A,B) ) ) ) )
   => a_0_34_fraenkel = a_0_35_fraenkel ) ).

fof(s20_fraenkel,axiom,
    a_0_36_fraenkel = a_0_37_fraenkel ).

fof(s21_fraenkel,axiom,
    ( v1_finset_1(f2_s21_fraenkel)
   => v1_finset_1(a_0_38_fraenkel) ) ).

fof(s22_fraenkel,axiom,
    ( ( v1_finset_1(f3_s22_fraenkel)
      & v1_finset_1(f4_s22_fraenkel) )
   => v1_finset_1(a_0_39_fraenkel) ) ).

fof(s25_fraenkel,axiom,
    ( ( v1_finset_1(f3_s25_fraenkel)
      & v1_finset_1(f4_s25_fraenkel)
      & ! [A] :
          ( m2_fraenkel(A,f1_s25_fraenkel,f2_s25_fraenkel,k1_fraenkel(f1_s25_fraenkel,f2_s25_fraenkel))
         => ! [B] :
              ( m2_fraenkel(B,f1_s25_fraenkel,f2_s25_fraenkel,k1_fraenkel(f1_s25_fraenkel,f2_s25_fraenkel))
             => ( k7_relat_1(A,f3_s25_fraenkel) = k7_relat_1(B,f3_s25_fraenkel)
               => f5_s25_fraenkel(A) = f5_s25_fraenkel(B) ) ) ) )
   => v1_finset_1(a_0_40_fraenkel) ) ).

fof(fraenkel_a_0_0_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s1_fraenkel)
          & A = f2_s1_fraenkel(B)
          & p1_s1_fraenkel(B) ) ) ).

fof(fraenkel_a_0_1_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_1_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s1_fraenkel)
          & A = f2_s1_fraenkel(B)
          & p2_s1_fraenkel(B) ) ) ).

fof(fraenkel_a_0_2_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_2_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s2_fraenkel)
          & m1_subset_1(C,f2_s2_fraenkel)
          & A = f3_s2_fraenkel(B,C)
          & p1_s2_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_3_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_3_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s2_fraenkel)
          & m1_subset_1(C,f2_s2_fraenkel)
          & A = f3_s2_fraenkel(B,C)
          & p2_s2_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_4_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_4_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s3_fraenkel)
          & A = f2_s3_fraenkel(B)
          & p1_s3_fraenkel(B) ) ) ).

fof(fraenkel_a_0_5_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_5_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s3_fraenkel)
          & A = f2_s3_fraenkel(B)
          & p2_s3_fraenkel(B) ) ) ).

fof(fraenkel_a_0_6_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_6_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s4_fraenkel)
          & m1_subset_1(C,f2_s4_fraenkel)
          & A = f3_s4_fraenkel(B,C)
          & p1_s4_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_7_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_7_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s4_fraenkel)
          & m1_subset_1(C,f2_s4_fraenkel)
          & A = f3_s4_fraenkel(B,C)
          & p2_s4_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_8_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_8_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s5_fraenkel)
          & A = f2_s5_fraenkel(B)
          & p1_s5_fraenkel(B) ) ) ).

fof(fraenkel_a_0_9_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_9_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s5_fraenkel)
          & A = f3_s5_fraenkel(B)
          & p1_s5_fraenkel(B) ) ) ).

fof(fraenkel_a_0_10_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_10_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s6_fraenkel)
          & A = f2_s6_fraenkel(B)
          & p1_s6_fraenkel(B) ) ) ).

fof(fraenkel_a_0_11_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_11_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s6_fraenkel)
          & A = f3_s6_fraenkel(B)
          & p1_s6_fraenkel(B) ) ) ).

fof(fraenkel_a_0_12_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_12_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s7_fraenkel)
          & m1_subset_1(C,f2_s7_fraenkel)
          & A = f3_s7_fraenkel(B,C)
          & p1_s7_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_13_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_13_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s7_fraenkel)
          & m1_subset_1(C,f2_s7_fraenkel)
          & A = f4_s7_fraenkel(B,C)
          & p1_s7_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_14_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_14_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s8_fraenkel)
          & m1_subset_1(C,f2_s8_fraenkel)
          & A = f3_s8_fraenkel(B,C)
          & p1_s8_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_15_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_15_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s8_fraenkel)
          & m1_subset_1(C,f2_s8_fraenkel)
          & A = f3_s8_fraenkel(C,B)
          & p2_s8_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_16_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_16_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s9_fraenkel)
          & A = k8_funct_2(f1_s9_fraenkel,f2_s9_fraenkel,f4_s9_fraenkel,B)
          & p1_s9_fraenkel(B)
          & r2_hidden(B,f3_s9_fraenkel) ) ) ).

fof(fraenkel_a_0_17_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_17_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s9_fraenkel)
          & A = k8_funct_2(f1_s9_fraenkel,f2_s9_fraenkel,f5_s9_fraenkel,B)
          & p2_s9_fraenkel(B)
          & r2_hidden(B,f3_s9_fraenkel) ) ) ).

fof(fraenkel_a_0_18_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_18_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s10_fraenkel)
          & A = B
          & p1_s10_fraenkel(B) ) ) ).

fof(fraenkel_a_0_19_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_19_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s11_fraenkel)
          & m1_subset_1(C,f2_s11_fraenkel)
          & A = f3_s11_fraenkel(B,C)
          & p1_s11_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_20_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_20_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s12_fraenkel)
          & m1_subset_1(C,f2_s12_fraenkel)
          & A = f3_s12_fraenkel(B,C)
          & p1_s12_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_21_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_21_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f3_s13_fraenkel)
          & A = B
          & r2_hidden(B,a_0_22_fraenkel)
          & p2_s13_fraenkel(B) ) ) ).

fof(fraenkel_a_0_22_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_22_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s13_fraenkel)
          & m1_subset_1(C,f2_s13_fraenkel)
          & A = f4_s13_fraenkel(B,C)
          & p1_s13_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_23_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_23_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s13_fraenkel)
          & m1_subset_1(C,f2_s13_fraenkel)
          & A = f4_s13_fraenkel(B,C)
          & p1_s13_fraenkel(B,C)
          & p2_s13_fraenkel(f4_s13_fraenkel(B,C)) ) ) ).

fof(fraenkel_a_0_24_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_24_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s14_fraenkel)
          & A = f2_s14_fraenkel(B)
          & r2_hidden(B,a_0_25_fraenkel)
          & p1_s14_fraenkel(B) ) ) ).

fof(fraenkel_a_0_25_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_25_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s14_fraenkel)
          & A = B
          & p2_s14_fraenkel(B) ) ) ).

fof(fraenkel_a_0_26_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_26_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s14_fraenkel)
          & A = f2_s14_fraenkel(B)
          & p2_s14_fraenkel(B)
          & p1_s14_fraenkel(B) ) ) ).

fof(fraenkel_a_0_27_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_27_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s15_fraenkel)
          & m1_subset_1(C,f2_s15_fraenkel)
          & A = f3_s15_fraenkel(B,C)
          & r2_hidden(B,a_0_28_fraenkel)
          & p1_s15_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_28_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_28_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s15_fraenkel)
          & A = B
          & p2_s15_fraenkel(B) ) ) ).

fof(fraenkel_a_0_29_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_29_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s15_fraenkel)
          & m1_subset_1(C,f2_s15_fraenkel)
          & A = f3_s15_fraenkel(B,C)
          & p2_s15_fraenkel(B)
          & p1_s15_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_30_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_30_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s16_fraenkel)
          & m1_subset_1(C,f2_s16_fraenkel)
          & A = f3_s16_fraenkel(B,C)
          & p1_s16_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_31_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_31_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s16_fraenkel)
          & m1_subset_1(C,f2_s16_fraenkel)
          & A = f3_s16_fraenkel(B,C)
          & p2_s16_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_32_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_32_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s17_fraenkel)
          & A = f3_s17_fraenkel(B)
          & r2_hidden(f3_s17_fraenkel(B),f2_s17_fraenkel)
          & p1_s17_fraenkel(B) ) ) ).

fof(fraenkel_a_0_33_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_33_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s18_fraenkel)
          & A = f3_s18_fraenkel(B)
          & p1_s18_fraenkel(B)
          & ~ r2_hidden(f3_s18_fraenkel(B),f2_s18_fraenkel) ) ) ).

fof(fraenkel_a_0_34_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_34_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s19_fraenkel)
          & m1_subset_1(C,f2_s19_fraenkel)
          & A = f3_s19_fraenkel(B,C)
          & p2_s19_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_35_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_35_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s19_fraenkel)
          & A = f3_s19_fraenkel(B,f4_s19_fraenkel)
          & p1_s19_fraenkel(B,f4_s19_fraenkel) ) ) ).

fof(fraenkel_a_0_36_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_36_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s20_fraenkel)
          & m1_subset_1(C,f2_s20_fraenkel)
          & A = f3_s20_fraenkel(B,C)
          & C = f4_s20_fraenkel
          & p1_s20_fraenkel(B,C) ) ) ).

fof(fraenkel_a_0_37_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_37_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s20_fraenkel)
          & A = f3_s20_fraenkel(B,f4_s20_fraenkel)
          & p1_s20_fraenkel(B,f4_s20_fraenkel) ) ) ).

fof(fraenkel_a_0_38_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_38_fraenkel)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s21_fraenkel)
          & A = f3_s21_fraenkel(B)
          & r2_hidden(B,f2_s21_fraenkel) ) ) ).

fof(fraenkel_a_0_39_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_39_fraenkel)
    <=> ? [B,C] :
          ( m1_subset_1(B,f1_s22_fraenkel)
          & m1_subset_1(C,f2_s22_fraenkel)
          & A = f5_s22_fraenkel(B,C)
          & r2_hidden(B,f3_s22_fraenkel)
          & r2_hidden(C,f4_s22_fraenkel) ) ) ).

fof(fraenkel_a_0_40_fraenkel,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_40_fraenkel)
    <=> ? [B] :
          ( m2_fraenkel(B,f1_s25_fraenkel,f2_s25_fraenkel,k1_fraenkel(f1_s25_fraenkel,f2_s25_fraenkel))
          & A = f5_s25_fraenkel(B)
          & r1_tarski(k2_funct_2(f1_s25_fraenkel,f2_s25_fraenkel,B,f3_s25_fraenkel),f4_s25_fraenkel) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_numbers,axiom,
    ~ v1_xboole_0(k1_numbers) ).

fof(fc2_numbers,axiom,
    ~ v1_xboole_0(k2_numbers) ).

fof(fc3_numbers,axiom,
    ~ v1_xboole_0(k3_numbers) ).

fof(fc4_numbers,axiom,
    ~ v1_xboole_0(k4_numbers) ).

fof(d1_numbers,axiom,
    k1_numbers = k4_xboole_0(k2_xboole_0(k2_arytm_2,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)),k1_tarski(k4_tarski(np__0,np__0))) ).

fof(d3_numbers,axiom,
    k3_numbers = k4_xboole_0(k2_xboole_0(k6_arytm_3,k2_zfmisc_1(k1_tarski(np__0),k6_arytm_3)),k1_tarski(k4_tarski(np__0,np__0))) ).

fof(d4_numbers,axiom,
    k4_numbers = k4_xboole_0(k2_xboole_0(k5_ordinal2,k2_zfmisc_1(k1_tarski(np__0),k5_ordinal2)),k1_tarski(k4_tarski(np__0,np__0))) ).

fof(t1_numbers,axiom,
    r2_xboole_0(k1_numbers,k2_numbers) ).

fof(t2_numbers,axiom,
    r2_xboole_0(k3_numbers,k1_numbers) ).

fof(t3_numbers,axiom,
    r2_xboole_0(k3_numbers,k2_numbers) ).

fof(t4_numbers,axiom,
    r2_xboole_0(k4_numbers,k3_numbers) ).

fof(t5_numbers,axiom,
    r2_xboole_0(k4_numbers,k1_numbers) ).

fof(t6_numbers,axiom,
    r2_xboole_0(k4_numbers,k2_numbers) ).

fof(t7_numbers,axiom,
    r2_xboole_0(k5_numbers,k4_numbers) ).

fof(t8_numbers,axiom,
    r2_xboole_0(k5_numbers,k3_numbers) ).

fof(t9_numbers,axiom,
    r2_xboole_0(k5_numbers,k1_numbers) ).

fof(t10_numbers,axiom,
    r2_xboole_0(k5_numbers,k2_numbers) ).

fof(t11_numbers,axiom,
    r1_tarski(k1_numbers,k2_numbers) ).

fof(t12_numbers,axiom,
    r1_tarski(k3_numbers,k1_numbers) ).

fof(t13_numbers,axiom,
    r1_tarski(k3_numbers,k2_numbers) ).

fof(t14_numbers,axiom,
    r1_tarski(k4_numbers,k3_numbers) ).

fof(t15_numbers,axiom,
    r1_tarski(k4_numbers,k1_numbers) ).

fof(t16_numbers,axiom,
    r1_tarski(k4_numbers,k2_numbers) ).

fof(t17_numbers,axiom,
    r1_tarski(k5_numbers,k4_numbers) ).

fof(t18_numbers,axiom,
    r1_tarski(k5_numbers,k3_numbers) ).

fof(t19_numbers,axiom,
    r1_tarski(k5_numbers,k1_numbers) ).

fof(t20_numbers,axiom,
    r1_tarski(k5_numbers,k2_numbers) ).

fof(t21_numbers,axiom,
    k1_numbers != k2_numbers ).

fof(t22_numbers,axiom,
    k3_numbers != k1_numbers ).

fof(t23_numbers,axiom,
    k3_numbers != k2_numbers ).

fof(t24_numbers,axiom,
    k4_numbers != k3_numbers ).

fof(t25_numbers,axiom,
    k4_numbers != k1_numbers ).

fof(t26_numbers,axiom,
    k4_numbers != k2_numbers ).

fof(t27_numbers,axiom,
    k5_numbers != k4_numbers ).

fof(t28_numbers,axiom,
    k5_numbers != k3_numbers ).

fof(t29_numbers,axiom,
    k5_numbers != k1_numbers ).

fof(t30_numbers,axiom,
    k5_numbers != k2_numbers ).

fof(dt_k1_numbers,axiom,
    $true ).

fof(dt_k2_numbers,axiom,
    $true ).

fof(dt_k3_numbers,axiom,
    $true ).

fof(dt_k4_numbers,axiom,
    $true ).

fof(dt_k5_numbers,axiom,
    m1_subset_1(k5_numbers,k1_zfmisc_1(k1_numbers)) ).

fof(redefinition_k5_numbers,axiom,
    k5_numbers = k5_ordinal2 ).

fof(d2_numbers,axiom,
    k2_numbers = k2_xboole_0(k4_xboole_0(k1_funct_2(k2_tarski(np__0,k13_arytm_3),k1_numbers),a_0_0_numbers),k1_numbers) ).

fof(fraenkel_a_0_0_numbers,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_numbers)
    <=> ? [B] :
          ( m1_subset_1(B,k1_funct_2(k2_tarski(np__0,k13_arytm_3),k1_numbers))
          & A = B
          & k1_funct_1(B,k13_arytm_3) = np__0 ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_arytm_0,axiom,
    r1_tarski(k2_arytm_2,k1_numbers) ).

fof(t2_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ( A != k12_arytm_3
       => r2_hidden(k4_tarski(k12_arytm_3,A),k1_numbers) ) ) ).

fof(t3_arytm_0,axiom,
    ! [A] :
      ~ ( r2_hidden(k4_tarski(k12_arytm_3,A),k1_numbers)
        & A = k12_arytm_3 ) ).

fof(t4_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => r2_hidden(k2_arytm_1(A,B),k1_numbers) ) ) ).

fof(t5_arytm_0,axiom,
    r1_subset_1(k2_arytm_2,k2_zfmisc_1(k1_tarski(k12_arytm_3),k2_arytm_2)) ).

fof(t6_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ( k2_arytm_1(A,B) = k12_arytm_3
           => A = B ) ) ) ).

fof(t7_arytm_0,axiom,
    ! [A,B] : k13_arytm_3 != k4_tarski(A,B) ).

fof(t8_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_arytm_2)
     => ! [B] :
          ( m1_subset_1(B,k2_arytm_2)
         => ! [C] :
              ( m1_subset_1(C,k2_arytm_2)
             => ( k8_arytm_2(A,B) = k8_arytm_2(A,C)
               => ( A = k12_arytm_3
                  | B = C ) ) ) ) ) ).

fof(d1_arytm_0,axiom,
    $true ).

fof(d2_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ! [C] :
              ( m1_subset_1(C,k1_numbers)
             => ( ( ( r2_hidden(A,k2_arytm_2)
                    & r2_hidden(B,k2_arytm_2) )
                 => ( C = k1_arytm_0(A,B)
                  <=> ? [D] :
                        ( m1_subset_1(D,k2_arytm_2)
                        & ? [E] :
                            ( m1_subset_1(E,k2_arytm_2)
                            & A = D
                            & B = E
                            & C = k7_arytm_2(D,E) ) ) ) )
                & ( ( r2_hidden(A,k2_arytm_2)
                    & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                 => ( C = k1_arytm_0(A,B)
                  <=> ? [D] :
                        ( m1_subset_1(D,k2_arytm_2)
                        & ? [E] :
                            ( m1_subset_1(E,k2_arytm_2)
                            & A = D
                            & B = k4_tarski(np__0,E)
                            & C = k2_arytm_1(D,E) ) ) ) )
                & ( ( r2_hidden(B,k2_arytm_2)
                    & r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                 => ( C = k1_arytm_0(A,B)
                  <=> ? [D] :
                        ( m1_subset_1(D,k2_arytm_2)
                        & ? [E] :
                            ( m1_subset_1(E,k2_arytm_2)
                            & A = k4_tarski(np__0,D)
                            & B = E
                            & C = k2_arytm_1(E,D) ) ) ) )
                & ~ ( ~ ( r2_hidden(A,k2_arytm_2)
                        & r2_hidden(B,k2_arytm_2) )
                    & ~ ( r2_hidden(A,k2_arytm_2)
                        & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                    & ~ ( r2_hidden(B,k2_arytm_2)
                        & r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                    & ~ ( C = k1_arytm_0(A,B)
                      <=> ? [D] :
                            ( m1_subset_1(D,k2_arytm_2)
                            & ? [E] :
                                ( m1_subset_1(E,k2_arytm_2)
                                & A = k4_tarski(np__0,D)
                                & B = k4_tarski(np__0,E)
                                & C = k4_tarski(np__0,k7_arytm_2(D,E)) ) ) ) ) ) ) ) ) ).

fof(d3_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ! [C] :
              ( m1_subset_1(C,k1_numbers)
             => ( ( ( r2_hidden(A,k2_arytm_2)
                    & r2_hidden(B,k2_arytm_2) )
                 => ( C = k2_arytm_0(A,B)
                  <=> ? [D] :
                        ( m1_subset_1(D,k2_arytm_2)
                        & ? [E] :
                            ( m1_subset_1(E,k2_arytm_2)
                            & A = D
                            & B = E
                            & C = k8_arytm_2(D,E) ) ) ) )
                & ( ( r2_hidden(A,k2_arytm_2)
                    & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                 => ( A = np__0
                    | ( C = k2_arytm_0(A,B)
                    <=> ? [D] :
                          ( m1_subset_1(D,k2_arytm_2)
                          & ? [E] :
                              ( m1_subset_1(E,k2_arytm_2)
                              & A = D
                              & B = k4_tarski(np__0,E)
                              & C = k4_tarski(np__0,k8_arytm_2(D,E)) ) ) ) ) )
                & ( ( r2_hidden(B,k2_arytm_2)
                    & r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                 => ( B = np__0
                    | ( C = k2_arytm_0(A,B)
                    <=> ? [D] :
                          ( m1_subset_1(D,k2_arytm_2)
                          & ? [E] :
                              ( m1_subset_1(E,k2_arytm_2)
                              & A = k4_tarski(np__0,D)
                              & B = E
                              & C = k4_tarski(np__0,k8_arytm_2(E,D)) ) ) ) ) )
                & ( ( r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2))
                    & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                 => ( C = k2_arytm_0(A,B)
                  <=> ? [D] :
                        ( m1_subset_1(D,k2_arytm_2)
                        & ? [E] :
                            ( m1_subset_1(E,k2_arytm_2)
                            & A = k4_tarski(np__0,D)
                            & B = k4_tarski(np__0,E)
                            & C = k8_arytm_2(E,D) ) ) ) )
                & ~ ( ~ ( r2_hidden(A,k2_arytm_2)
                        & r2_hidden(B,k2_arytm_2) )
                    & ~ ( r2_hidden(A,k2_arytm_2)
                        & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2))
                        & A != np__0 )
                    & ~ ( r2_hidden(B,k2_arytm_2)
                        & r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2))
                        & B != np__0 )
                    & ~ ( r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2))
                        & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                    & ~ ( C = k2_arytm_0(A,B)
                      <=> C = np__0 ) ) ) ) ) ) ).

fof(d4_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( B = k3_arytm_0(A)
          <=> k1_arytm_0(A,B) = np__0 ) ) ) ).

fof(d5_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( ( A != np__0
             => ( B = k4_arytm_0(A)
              <=> k2_arytm_0(A,B) = k13_arytm_3 ) )
            & ( A = np__0
             => ( B = k4_arytm_0(A)
              <=> B = np__0 ) ) ) ) ) ).

fof(t9_arytm_0,axiom,
    $true ).

fof(t10_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ~ r2_hidden(k5_funct_4(k1_numbers,np__0,k13_arytm_3,A,B),k1_numbers) ) ) ).

fof(d6_arytm_0,axiom,
    $true ).

fof(d7_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( ( B = np__0
             => k5_arytm_0(A,B) = A )
            & ( B != np__0
             => k5_arytm_0(A,B) = k5_funct_4(k1_numbers,np__0,k13_arytm_3,A,B) ) ) ) ) ).

fof(t11_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => ? [B] :
          ( m1_subset_1(B,k1_numbers)
          & ? [C] :
              ( m1_subset_1(C,k1_numbers)
              & A = k5_arytm_0(B,C) ) ) ) ).

fof(t12_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ! [C] :
              ( m1_subset_1(C,k1_numbers)
             => ! [D] :
                  ( m1_subset_1(D,k1_numbers)
                 => ( k5_arytm_0(A,B) = k5_arytm_0(C,D)
                   => ( A = C
                      & B = D ) ) ) ) ) ) ).

fof(t13_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( B = np__0
           => k1_arytm_0(A,B) = A ) ) ) ).

fof(t14_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( B = np__0
           => k2_arytm_0(A,B) = np__0 ) ) ) ).

fof(t15_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ! [C] :
              ( m1_subset_1(C,k1_numbers)
             => k2_arytm_0(A,k2_arytm_0(B,C)) = k2_arytm_0(k2_arytm_0(A,B),C) ) ) ) ).

fof(t16_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ! [C] :
              ( m1_subset_1(C,k1_numbers)
             => k2_arytm_0(A,k1_arytm_0(B,C)) = k1_arytm_0(k2_arytm_0(A,B),k2_arytm_0(A,C)) ) ) ) ).

fof(t17_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => k2_arytm_0(k3_arytm_0(A),B) = k3_arytm_0(k2_arytm_0(A,B)) ) ) ).

fof(t18_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => r2_hidden(k2_arytm_0(A,A),k2_arytm_2) ) ).

fof(t19_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( k1_arytm_0(k2_arytm_0(A,A),k2_arytm_0(B,B)) = np__0
           => A = np__0 ) ) ) ).

fof(t20_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ! [C] :
              ( m1_subset_1(C,k1_numbers)
             => ( ( k2_arytm_0(A,B) = k13_arytm_3
                  & k2_arytm_0(A,C) = k13_arytm_3 )
               => ( A = np__0
                  | B = C ) ) ) ) ) ).

fof(t21_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( B = k13_arytm_3
           => k2_arytm_0(A,B) = A ) ) ) ).

fof(t22_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( B != np__0
           => k2_arytm_0(k2_arytm_0(A,B),k4_arytm_0(B)) = A ) ) ) ).

fof(t23_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ~ ( k2_arytm_0(A,B) = np__0
              & A != np__0
              & B != np__0 ) ) ) ).

fof(t24_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => k4_arytm_0(k2_arytm_0(A,B)) = k2_arytm_0(k4_arytm_0(A),k4_arytm_0(B)) ) ) ).

fof(t25_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ! [C] :
              ( m1_subset_1(C,k1_numbers)
             => k1_arytm_0(A,k1_arytm_0(B,C)) = k1_arytm_0(k1_arytm_0(A,B),C) ) ) ) ).

fof(t26_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( r2_hidden(k5_arytm_0(A,B),k1_numbers)
           => B = np__0 ) ) ) ).

fof(t27_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => k3_arytm_0(k1_arytm_0(A,B)) = k1_arytm_0(k3_arytm_0(A),k3_arytm_0(B)) ) ) ).

fof(dt_k1_arytm_0,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k1_arytm_0(A,B),k1_numbers) ) ).

fof(commutativity_k1_arytm_0,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k1_arytm_0(A,B) = k1_arytm_0(B,A) ) ).

fof(dt_k2_arytm_0,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k2_arytm_0(A,B),k1_numbers) ) ).

fof(commutativity_k2_arytm_0,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k2_arytm_0(A,B) = k2_arytm_0(B,A) ) ).

fof(dt_k3_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k3_arytm_0(A),k1_numbers) ) ).

fof(involutiveness_k3_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k3_arytm_0(k3_arytm_0(A)) = A ) ).

fof(dt_k4_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k4_arytm_0(A),k1_numbers) ) ).

fof(involutiveness_k4_arytm_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k4_arytm_0(k4_arytm_0(A)) = A ) ).

fof(dt_k5_arytm_0,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k5_arytm_0(A,B),k2_numbers) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_numerals,axiom,
    m1_subset_1(np__0,k5_numbers) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_xcmplx_0,axiom,
    v1_xcmplx_0(k1_xcmplx_0) ).

fof(rc1_xcmplx_0,axiom,
    ? [A] : v1_xcmplx_0(A) ).

fof(fc2_xcmplx_0,axiom,
    ! [A,B] :
      ( ( v1_xcmplx_0(A)
        & v1_xcmplx_0(B) )
     => v1_xcmplx_0(k2_xcmplx_0(A,B)) ) ).

fof(fc3_xcmplx_0,axiom,
    ! [A,B] :
      ( ( v1_xcmplx_0(A)
        & v1_xcmplx_0(B) )
     => v1_xcmplx_0(k3_xcmplx_0(A,B)) ) ).

fof(fc4_xcmplx_0,axiom,
    ! [A,B] :
      ( ( v1_xcmplx_0(A)
        & v1_xcmplx_0(B) )
     => v1_xcmplx_0(k6_xcmplx_0(A,B)) ) ).

fof(fc5_xcmplx_0,axiom,
    ! [A,B] :
      ( ( v1_xcmplx_0(A)
        & v1_xcmplx_0(B) )
     => v1_xcmplx_0(k7_xcmplx_0(A,B)) ) ).

fof(rc2_xcmplx_0,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_xcmplx_0(A) ) ).

fof(fc6_xcmplx_0,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_xcmplx_0(A) )
     => ( ~ v1_xboole_0(k4_xcmplx_0(A))
        & v1_xcmplx_0(k4_xcmplx_0(A)) ) ) ).

fof(fc7_xcmplx_0,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_xcmplx_0(A) )
     => ( ~ v1_xboole_0(k5_xcmplx_0(A))
        & v1_xcmplx_0(k5_xcmplx_0(A)) ) ) ).

fof(fc8_xcmplx_0,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_xcmplx_0(A)
        & ~ v1_xboole_0(B)
        & v1_xcmplx_0(B) )
     => ( ~ v1_xboole_0(k3_xcmplx_0(A,B))
        & v1_xcmplx_0(k3_xcmplx_0(A,B)) ) ) ).

fof(fc9_xcmplx_0,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_xcmplx_0(A)
        & ~ v1_xboole_0(B)
        & v1_xcmplx_0(B) )
     => ( ~ v1_xboole_0(k7_xcmplx_0(A,B))
        & v1_xcmplx_0(k7_xcmplx_0(A,B)) ) ) ).

fof(cc1_xcmplx_0,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => v1_xcmplx_0(A) ) ).

fof(cc2_xcmplx_0,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => v1_xcmplx_0(A) ) ).

fof(d1_xcmplx_0,axiom,
    k1_xcmplx_0 = k5_funct_4(k1_numbers,np__0,np__1,np__0,np__1) ).

fof(d2_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
    <=> r2_hidden(A,k2_numbers) ) ).

fof(d3_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ( v1_xboole_0(A)
      <=> A = np__0 ) ) ).

fof(d4_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( C = k2_xcmplx_0(A,B)
            <=> ? [D] :
                  ( m1_subset_1(D,k1_numbers)
                  & ? [E] :
                      ( m1_subset_1(E,k1_numbers)
                      & ? [F] :
                          ( m1_subset_1(F,k1_numbers)
                          & ? [G] :
                              ( m1_subset_1(G,k1_numbers)
                              & A = k5_arytm_0(D,E)
                              & B = k5_arytm_0(F,G)
                              & C = k5_arytm_0(k1_arytm_0(D,F),k1_arytm_0(E,G)) ) ) ) ) ) ) ) ).

fof(d5_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( C = k3_xcmplx_0(A,B)
            <=> ? [D] :
                  ( m1_subset_1(D,k1_numbers)
                  & ? [E] :
                      ( m1_subset_1(E,k1_numbers)
                      & ? [F] :
                          ( m1_subset_1(F,k1_numbers)
                          & ? [G] :
                              ( m1_subset_1(G,k1_numbers)
                              & A = k5_arytm_0(D,E)
                              & B = k5_arytm_0(F,G)
                              & C = k5_arytm_0(k1_arytm_0(k2_arytm_0(D,F),k3_arytm_0(k2_arytm_0(E,G))),k1_arytm_0(k2_arytm_0(D,G),k2_arytm_0(E,F))) ) ) ) ) ) ) ) ).

fof(d6_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( B = k4_xcmplx_0(A)
          <=> k2_xcmplx_0(A,B) = np__0 ) ) ) ).

fof(d7_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( ( A != np__0
             => ( B = k5_xcmplx_0(A)
              <=> k3_xcmplx_0(A,B) = np__1 ) )
            & ( A = np__0
             => ( B = k5_xcmplx_0(A)
              <=> B = np__0 ) ) ) ) ) ).

fof(d8_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k6_xcmplx_0(A,B) = k2_xcmplx_0(A,k4_xcmplx_0(B)) ) ) ).

fof(d9_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(A,B) = k3_xcmplx_0(A,k5_xcmplx_0(B)) ) ) ).

fof(dt_k1_xcmplx_0,axiom,
    $true ).

fof(dt_k2_xcmplx_0,axiom,
    $true ).

fof(commutativity_k2_xcmplx_0,axiom,
    ! [A,B] :
      ( ( v1_xcmplx_0(A)
        & v1_xcmplx_0(B) )
     => k2_xcmplx_0(A,B) = k2_xcmplx_0(B,A) ) ).

fof(dt_k3_xcmplx_0,axiom,
    $true ).

fof(commutativity_k3_xcmplx_0,axiom,
    ! [A,B] :
      ( ( v1_xcmplx_0(A)
        & v1_xcmplx_0(B) )
     => k3_xcmplx_0(A,B) = k3_xcmplx_0(B,A) ) ).

fof(dt_k4_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => v1_xcmplx_0(k4_xcmplx_0(A)) ) ).

fof(involutiveness_k4_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k4_xcmplx_0(k4_xcmplx_0(A)) = A ) ).

fof(dt_k5_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => v1_xcmplx_0(k5_xcmplx_0(A)) ) ).

fof(involutiveness_k5_xcmplx_0,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k5_xcmplx_0(k5_xcmplx_0(A)) = A ) ).

fof(dt_k6_xcmplx_0,axiom,
    $true ).

fof(dt_k7_xcmplx_0,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_arithm,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k2_xcmplx_0(A,np__0) = A ) ).

fof(t2_arithm,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k3_xcmplx_0(A,np__0) = np__0 ) ).

fof(t3_arithm,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k3_xcmplx_0(np__1,A) = A ) ).

fof(t4_arithm,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k6_xcmplx_0(A,np__0) = A ) ).

fof(t5_arithm,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(np__0,A) = np__0 ) ).

fof(t6_arithm,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(A,np__1) = A ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_xreal_0,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => v1_xreal_0(A) ) ).

fof(cc2_xreal_0,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => v1_xcmplx_0(A) ) ).

fof(rc1_xreal_0,axiom,
    ? [A] :
      ( v1_xcmplx_0(A)
      & v1_xreal_0(A) ) ).

fof(fc1_xreal_0,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( v1_xcmplx_0(k4_xcmplx_0(A))
        & v1_xreal_0(k4_xcmplx_0(A)) ) ) ).

fof(fc2_xreal_0,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( v1_xcmplx_0(k5_xcmplx_0(A))
        & v1_xreal_0(k5_xcmplx_0(A)) ) ) ).

fof(fc3_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B)) ) ) ).

fof(fc4_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B)) ) ) ).

fof(fc5_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B)) ) ) ).

fof(fc6_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => ( v1_xcmplx_0(k7_xcmplx_0(A,B))
        & v1_xreal_0(k7_xcmplx_0(A,B)) ) ) ).

fof(cc3_xreal_0,axiom,
    ! [A] :
      ( ( v1_xreal_0(A)
        & v2_xreal_0(A) )
     => ( ~ v1_xboole_0(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & ~ v3_xreal_0(A) ) ) ).

fof(cc4_xreal_0,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_xreal_0(A)
        & ~ v3_xreal_0(A) )
     => ( v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & v2_xreal_0(A) ) ) ).

fof(cc5_xreal_0,axiom,
    ! [A] :
      ( ( v1_xreal_0(A)
        & v3_xreal_0(A) )
     => ( ~ v1_xboole_0(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & ~ v2_xreal_0(A) ) ) ).

fof(cc6_xreal_0,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_xreal_0(A)
        & ~ v2_xreal_0(A) )
     => ( v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & v3_xreal_0(A) ) ) ).

fof(cc7_xreal_0,axiom,
    ! [A] :
      ( ( v1_xboole_0(A)
        & v1_xreal_0(A) )
     => ( v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & ~ v2_xreal_0(A)
        & ~ v3_xreal_0(A) ) ) ).

fof(cc8_xreal_0,axiom,
    ! [A] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A)
        & ~ v3_xreal_0(A) )
     => ( v1_xboole_0(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A) ) ) ).

fof(rc2_xreal_0,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_xcmplx_0(A)
      & v1_xreal_0(A)
      & v2_xreal_0(A)
      & ~ v3_xreal_0(A) ) ).

fof(rc3_xreal_0,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_xcmplx_0(A)
      & v1_xreal_0(A)
      & ~ v2_xreal_0(A)
      & v3_xreal_0(A) ) ).

fof(rc4_xreal_0,axiom,
    ? [A] :
      ( v1_xboole_0(A)
      & v1_xcmplx_0(A)
      & v1_xreal_0(A)
      & ~ v2_xreal_0(A)
      & ~ v3_xreal_0(A) ) ).

fof(fc7_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & ~ v3_xreal_0(k2_xcmplx_0(A,B)) ) ) ).

fof(fc8_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & ~ v2_xreal_0(k2_xcmplx_0(A,B)) ) ) ).

fof(fc9_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( ~ v1_xboole_0(k2_xcmplx_0(A,B))
        & v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & v2_xreal_0(k2_xcmplx_0(A,B))
        & ~ v3_xreal_0(k2_xcmplx_0(A,B)) ) ) ).

fof(fc10_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( ~ v1_xboole_0(k2_xcmplx_0(B,A))
        & v1_xcmplx_0(k2_xcmplx_0(B,A))
        & v1_xreal_0(k2_xcmplx_0(B,A))
        & v2_xreal_0(k2_xcmplx_0(B,A))
        & ~ v3_xreal_0(k2_xcmplx_0(B,A)) ) ) ).

fof(fc11_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( ~ v1_xboole_0(k2_xcmplx_0(A,B))
        & v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & ~ v2_xreal_0(k2_xcmplx_0(A,B))
        & v3_xreal_0(k2_xcmplx_0(A,B)) ) ) ).

fof(fc12_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( ~ v1_xboole_0(k2_xcmplx_0(B,A))
        & v1_xcmplx_0(k2_xcmplx_0(B,A))
        & v1_xreal_0(k2_xcmplx_0(B,A))
        & ~ v2_xreal_0(k2_xcmplx_0(B,A))
        & v3_xreal_0(k2_xcmplx_0(B,A)) ) ) ).

fof(fc13_xreal_0,axiom,
    ! [A] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A) )
     => ( v1_xcmplx_0(k4_xcmplx_0(A))
        & v1_xreal_0(k4_xcmplx_0(A))
        & ~ v3_xreal_0(k4_xcmplx_0(A)) ) ) ).

fof(fc14_xreal_0,axiom,
    ! [A] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A) )
     => ( v1_xcmplx_0(k4_xcmplx_0(A))
        & v1_xreal_0(k4_xcmplx_0(A))
        & ~ v2_xreal_0(k4_xcmplx_0(A)) ) ) ).

fof(fc15_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & ~ v3_xreal_0(k6_xcmplx_0(A,B)) ) ) ).

fof(fc16_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(B,A))
        & v1_xreal_0(k6_xcmplx_0(B,A))
        & ~ v2_xreal_0(k6_xcmplx_0(B,A)) ) ) ).

fof(fc17_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( ~ v1_xboole_0(k6_xcmplx_0(A,B))
        & v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v2_xreal_0(k6_xcmplx_0(A,B))
        & ~ v3_xreal_0(k6_xcmplx_0(A,B)) ) ) ).

fof(fc18_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( ~ v1_xboole_0(k6_xcmplx_0(B,A))
        & v1_xcmplx_0(k6_xcmplx_0(B,A))
        & v1_xreal_0(k6_xcmplx_0(B,A))
        & ~ v2_xreal_0(k6_xcmplx_0(B,A))
        & v3_xreal_0(k6_xcmplx_0(B,A)) ) ) ).

fof(fc19_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( ~ v1_xboole_0(k6_xcmplx_0(A,B))
        & v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & ~ v2_xreal_0(k6_xcmplx_0(A,B))
        & v3_xreal_0(k6_xcmplx_0(A,B)) ) ) ).

fof(fc20_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( ~ v1_xboole_0(k6_xcmplx_0(B,A))
        & v1_xcmplx_0(k6_xcmplx_0(B,A))
        & v1_xreal_0(k6_xcmplx_0(B,A))
        & v2_xreal_0(k6_xcmplx_0(B,A))
        & ~ v3_xreal_0(k6_xcmplx_0(B,A)) ) ) ).

fof(fc21_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & ~ v2_xreal_0(k3_xcmplx_0(A,B)) ) ) ).

fof(fc22_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(B,A))
        & v1_xreal_0(k3_xcmplx_0(B,A))
        & ~ v2_xreal_0(k3_xcmplx_0(B,A)) ) ) ).

fof(fc23_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & ~ v3_xreal_0(k3_xcmplx_0(A,B)) ) ) ).

fof(fc24_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & ~ v3_xreal_0(k3_xcmplx_0(A,B)) ) ) ).

fof(fc25_xreal_0,axiom,
    ! [A] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A) )
     => ( v1_xcmplx_0(k5_xcmplx_0(A))
        & v1_xreal_0(k5_xcmplx_0(A))
        & ~ v2_xreal_0(k5_xcmplx_0(A)) ) ) ).

fof(fc26_xreal_0,axiom,
    ! [A] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A) )
     => ( v1_xcmplx_0(k5_xcmplx_0(A))
        & v1_xreal_0(k5_xcmplx_0(A))
        & ~ v3_xreal_0(k5_xcmplx_0(A)) ) ) ).

fof(fc27_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( v1_xcmplx_0(k7_xcmplx_0(A,B))
        & v1_xreal_0(k7_xcmplx_0(A,B))
        & ~ v2_xreal_0(k7_xcmplx_0(A,B)) ) ) ).

fof(fc28_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( v1_xcmplx_0(k7_xcmplx_0(B,A))
        & v1_xreal_0(k7_xcmplx_0(B,A))
        & ~ v2_xreal_0(k7_xcmplx_0(B,A)) ) ) ).

fof(fc29_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v3_xreal_0(B) )
     => ( v1_xcmplx_0(k7_xcmplx_0(A,B))
        & v1_xreal_0(k7_xcmplx_0(A,B))
        & ~ v3_xreal_0(k7_xcmplx_0(A,B)) ) ) ).

fof(fc30_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & ~ v2_xreal_0(A)
        & v1_xreal_0(B)
        & ~ v2_xreal_0(B) )
     => ( v1_xcmplx_0(k7_xcmplx_0(A,B))
        & v1_xreal_0(k7_xcmplx_0(A,B))
        & ~ v3_xreal_0(k7_xcmplx_0(A,B)) ) ) ).

fof(d1_xreal_0,axiom,
    ! [A] :
      ( v1_xreal_0(A)
    <=> r2_hidden(A,k1_numbers) ) ).

fof(d2_xreal_0,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( ( r2_hidden(A,k2_arytm_2)
                & r2_hidden(B,k2_arytm_2) )
             => ( r1_xreal_0(A,B)
              <=> ? [C] :
                    ( m1_subset_1(C,k2_arytm_2)
                    & ? [D] :
                        ( m1_subset_1(D,k2_arytm_2)
                        & A = C
                        & B = D
                        & r1_arytm_2(C,D) ) ) ) )
            & ( ( r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2))
                & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
             => ( r1_xreal_0(A,B)
              <=> ? [C] :
                    ( m1_subset_1(C,k2_arytm_2)
                    & ? [D] :
                        ( m1_subset_1(D,k2_arytm_2)
                        & A = k4_tarski(np__0,C)
                        & B = k4_tarski(np__0,D)
                        & r1_arytm_2(D,C) ) ) ) )
            & ~ ( ~ ( r2_hidden(A,k2_arytm_2)
                    & r2_hidden(B,k2_arytm_2) )
                & ~ ( r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2))
                    & r2_hidden(B,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) )
                & ~ ( r1_xreal_0(A,B)
                  <=> ( r2_hidden(B,k2_arytm_2)
                      & r2_hidden(A,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)) ) ) ) ) ) ) ).

fof(d3_xreal_0,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( v2_xreal_0(A)
      <=> ~ r1_xreal_0(A,np__0) ) ) ).

fof(d4_xreal_0,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( v3_xreal_0(A)
      <=> ~ r1_xreal_0(np__0,A) ) ) ).

fof(reflexivity_r1_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => r1_xreal_0(A,A) ) ).

fof(connectedness_r1_xreal_0,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => ( r1_xreal_0(A,B)
        | r1_xreal_0(B,A) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,B)
              & v2_xreal_0(A) )
           => v2_xreal_0(B) ) ) ) ).

fof(t2_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,B)
              & v3_xreal_0(B) )
           => v3_xreal_0(A) ) ) ) ).

fof(t3_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(A,B)
              & ~ v3_xreal_0(A)
              & v3_xreal_0(B) ) ) ) ).

fof(t4_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(A,B)
              & ~ v2_xreal_0(B)
              & v2_xreal_0(A) ) ) ) ).

fof(t5_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
           => ( v1_xboole_0(B)
              | v3_xreal_0(A)
              | v2_xreal_0(B) ) ) ) ) ).

fof(t6_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
           => ( v1_xboole_0(A)
              | v2_xreal_0(B)
              | v3_xreal_0(A) ) ) ) ) ).

fof(t7_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,B)
              & ~ v2_xreal_0(A)
              & ~ v3_xreal_0(B) ) ) ) ).

fof(t8_real,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,B)
              & ~ v3_xreal_0(B)
              & ~ v2_xreal_0(A) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(A,k2_xcmplx_0(B,C)) = k2_xcmplx_0(k2_xcmplx_0(A,B),C) ) ) ) ).

fof(t2_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( k2_xcmplx_0(A,B) = k2_xcmplx_0(C,B)
               => A = C ) ) ) ) ).

fof(t3_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A = k2_xcmplx_0(A,B)
           => B = np__0 ) ) ) ).

fof(t4_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(A,k3_xcmplx_0(B,C)) = k3_xcmplx_0(k3_xcmplx_0(A,B),C) ) ) ) ).

fof(t5_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( k3_xcmplx_0(B,A) = k3_xcmplx_0(C,A)
               => ( A = np__0
                  | B = C ) ) ) ) ) ).

fof(t6_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( k3_xcmplx_0(A,B) = np__0
              & A != np__0
              & B != np__0 ) ) ) ).

fof(t7_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k3_xcmplx_0(B,A) = A
           => ( A = np__0
              | B = np__1 ) ) ) ) ).

fof(t8_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(A,k2_xcmplx_0(B,C)) = k2_xcmplx_0(k3_xcmplx_0(A,B),k3_xcmplx_0(A,C)) ) ) ) ).

fof(t9_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(A,B),C),D) = k2_xcmplx_0(k2_xcmplx_0(k3_xcmplx_0(A,D),k3_xcmplx_0(B,D)),k3_xcmplx_0(C,D)) ) ) ) ) ).

fof(t10_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k2_xcmplx_0(A,B),k2_xcmplx_0(C,D)) = k2_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(k3_xcmplx_0(A,C),k3_xcmplx_0(A,D)),k3_xcmplx_0(B,C)),k3_xcmplx_0(B,D)) ) ) ) ) ).

fof(t11_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k3_xcmplx_0(np__2,A) = k2_xcmplx_0(A,A) ) ).

fof(t12_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k3_xcmplx_0(np__3,A) = k2_xcmplx_0(k2_xcmplx_0(A,A),A) ) ).

fof(t13_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k3_xcmplx_0(np__4,A) = k2_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(A,A),A),A) ) ).

fof(t14_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k6_xcmplx_0(A,A) = np__0 ) ).

fof(t15_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k6_xcmplx_0(A,B) = np__0
           => A = B ) ) ) ).

fof(t16_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k6_xcmplx_0(A,B) = A
           => B = np__0 ) ) ) ).

fof(t17_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k6_xcmplx_0(A,k6_xcmplx_0(B,B)) ) ) ).

fof(t18_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k6_xcmplx_0(A,k6_xcmplx_0(A,B)) = B ) ) ).

fof(t19_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( k6_xcmplx_0(A,B) = k6_xcmplx_0(C,B)
               => A = C ) ) ) ) ).

fof(t20_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( k6_xcmplx_0(A,B) = k6_xcmplx_0(A,C)
               => B = C ) ) ) ) ).

fof(t21_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(A,B),C) = k6_xcmplx_0(k6_xcmplx_0(A,C),B) ) ) ) ).

fof(t22_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(A,B) = k6_xcmplx_0(k6_xcmplx_0(A,C),k6_xcmplx_0(B,C)) ) ) ) ).

fof(t23_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(A,B),k6_xcmplx_0(A,C)) = k6_xcmplx_0(C,B) ) ) ) ).

fof(t24_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k6_xcmplx_0(A,B) = k6_xcmplx_0(C,D)
                   => k6_xcmplx_0(A,C) = k6_xcmplx_0(B,D) ) ) ) ) ) ).

fof(t25_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k2_xcmplx_0(A,k6_xcmplx_0(B,B)) ) ) ).

fof(t26_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k6_xcmplx_0(k2_xcmplx_0(A,B),B) ) ) ).

fof(t27_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k2_xcmplx_0(k6_xcmplx_0(A,B),B) ) ) ).

fof(t28_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(A,B) = k2_xcmplx_0(k2_xcmplx_0(A,C),k6_xcmplx_0(B,C)) ) ) ) ).

fof(t29_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k2_xcmplx_0(A,B),C) = k2_xcmplx_0(k6_xcmplx_0(A,C),B) ) ) ) ).

fof(t30_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(k6_xcmplx_0(A,B),C) = k2_xcmplx_0(k6_xcmplx_0(C,B),A) ) ) ) ).

fof(t31_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(A,B) = k6_xcmplx_0(k2_xcmplx_0(A,C),k6_xcmplx_0(C,B)) ) ) ) ).

fof(t32_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(A,B) = k6_xcmplx_0(k2_xcmplx_0(A,C),k2_xcmplx_0(B,C)) ) ) ) ).

fof(t33_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k2_xcmplx_0(A,B) = k2_xcmplx_0(C,D)
                   => k6_xcmplx_0(A,C) = k6_xcmplx_0(D,B) ) ) ) ) ) ).

fof(t34_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k6_xcmplx_0(A,B) = k6_xcmplx_0(C,D)
                   => k2_xcmplx_0(A,D) = k2_xcmplx_0(B,C) ) ) ) ) ) ).

fof(t35_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k2_xcmplx_0(A,B) = k6_xcmplx_0(C,D)
                   => k2_xcmplx_0(A,D) = k6_xcmplx_0(C,B) ) ) ) ) ) ).

fof(t36_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(A,k2_xcmplx_0(B,C)) = k6_xcmplx_0(k6_xcmplx_0(A,B),C) ) ) ) ).

fof(t37_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(A,k6_xcmplx_0(B,C)) = k2_xcmplx_0(k6_xcmplx_0(A,B),C) ) ) ) ).

fof(t38_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(A,k6_xcmplx_0(B,C)) = k2_xcmplx_0(A,k6_xcmplx_0(C,B)) ) ) ) ).

fof(t39_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(A,B) = k2_xcmplx_0(k6_xcmplx_0(A,C),k6_xcmplx_0(C,B)) ) ) ) ).

fof(t40_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(A,k6_xcmplx_0(B,C)) = k6_xcmplx_0(k3_xcmplx_0(A,B),k3_xcmplx_0(A,C)) ) ) ) ).

fof(t41_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k6_xcmplx_0(A,B),k6_xcmplx_0(C,D)) = k3_xcmplx_0(k6_xcmplx_0(B,A),k6_xcmplx_0(D,C)) ) ) ) ) ).

fof(t42_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k6_xcmplx_0(k6_xcmplx_0(A,B),C),D) = k6_xcmplx_0(k6_xcmplx_0(k3_xcmplx_0(A,D),k3_xcmplx_0(B,D)),k3_xcmplx_0(C,D)) ) ) ) ) ).

fof(t43_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k6_xcmplx_0(k2_xcmplx_0(A,B),C),D) = k6_xcmplx_0(k2_xcmplx_0(k3_xcmplx_0(A,D),k3_xcmplx_0(B,D)),k3_xcmplx_0(C,D)) ) ) ) ) ).

fof(t44_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k2_xcmplx_0(k6_xcmplx_0(A,B),C),D) = k2_xcmplx_0(k6_xcmplx_0(k3_xcmplx_0(A,D),k3_xcmplx_0(B,D)),k3_xcmplx_0(C,D)) ) ) ) ) ).

fof(t45_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k2_xcmplx_0(A,B),k6_xcmplx_0(C,D)) = k6_xcmplx_0(k2_xcmplx_0(k6_xcmplx_0(k3_xcmplx_0(A,C),k3_xcmplx_0(A,D)),k3_xcmplx_0(B,C)),k3_xcmplx_0(B,D)) ) ) ) ) ).

fof(t46_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k6_xcmplx_0(A,B),k2_xcmplx_0(C,D)) = k6_xcmplx_0(k6_xcmplx_0(k2_xcmplx_0(k3_xcmplx_0(A,C),k3_xcmplx_0(A,D)),k3_xcmplx_0(B,C)),k3_xcmplx_0(B,D)) ) ) ) ) ).

fof(t47_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k6_xcmplx_0(A,B),k6_xcmplx_0(C,D)) = k2_xcmplx_0(k6_xcmplx_0(k6_xcmplx_0(k3_xcmplx_0(A,C),k3_xcmplx_0(A,D)),k3_xcmplx_0(B,C)),k3_xcmplx_0(B,D)) ) ) ) ) ).

fof(t48_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(k7_xcmplx_0(A,B),C) = k7_xcmplx_0(k7_xcmplx_0(A,C),B) ) ) ) ).

fof(t49_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(A,np__0) = np__0 ) ).

fof(t50_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( A != np__0
              & B != np__0
              & k7_xcmplx_0(A,B) = np__0 ) ) ) ).

fof(t51_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k7_xcmplx_0(B,k7_xcmplx_0(A,A)) ) ) ) ).

fof(t52_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => k7_xcmplx_0(A,k7_xcmplx_0(A,B)) = B ) ) ) ).

fof(t53_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( k7_xcmplx_0(B,A) = k7_xcmplx_0(C,A)
               => ( A = np__0
                  | B = C ) ) ) ) ) ).

fof(t54_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k7_xcmplx_0(A,B) != np__0
           => B = k7_xcmplx_0(A,k7_xcmplx_0(A,B)) ) ) ) ).

fof(t55_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k7_xcmplx_0(B,C) = k7_xcmplx_0(k7_xcmplx_0(B,A),k7_xcmplx_0(C,A)) ) ) ) ) ).

fof(t56_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(np__1,k7_xcmplx_0(np__1,A)) = A ) ).

fof(t57_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(np__1,k7_xcmplx_0(A,B)) = k7_xcmplx_0(B,A) ) ) ).

fof(t58_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k7_xcmplx_0(A,B) = np__1
           => A = B ) ) ) ).

fof(t59_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k7_xcmplx_0(np__1,A) = k7_xcmplx_0(np__1,B)
           => A = B ) ) ) ).

fof(t60_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ( A != np__0
       => k7_xcmplx_0(A,A) = np__1 ) ) ).

fof(t61_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k7_xcmplx_0(A,B) = A
           => ( A = np__0
              | B = np__1 ) ) ) ) ).

fof(t62_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(A,np__0) = np__0 ) ).

fof(t63_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(k7_xcmplx_0(A,B),k7_xcmplx_0(C,B)) = k7_xcmplx_0(k2_xcmplx_0(A,C),B) ) ) ) ).

fof(t64_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k7_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(A,B),C),D) = k2_xcmplx_0(k2_xcmplx_0(k7_xcmplx_0(A,D),k7_xcmplx_0(B,D)),k7_xcmplx_0(C,D)) ) ) ) ) ).

fof(t65_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(k2_xcmplx_0(A,A),np__2) = A ) ).

fof(t66_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k2_xcmplx_0(k7_xcmplx_0(A,np__2),k7_xcmplx_0(A,np__2)) = A ) ).

fof(t67_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A = k7_xcmplx_0(k2_xcmplx_0(A,B),np__2)
           => A = B ) ) ) ).

fof(t68_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(A,A),A),np__3) = A ) ).

fof(t69_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k2_xcmplx_0(k2_xcmplx_0(k7_xcmplx_0(A,np__3),k7_xcmplx_0(A,np__3)),k7_xcmplx_0(A,np__3)) = A ) ).

fof(t70_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(A,A),A),A),np__4) = A ) ).

fof(t71_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k2_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(k7_xcmplx_0(A,np__4),k7_xcmplx_0(A,np__4)),k7_xcmplx_0(A,np__4)),k7_xcmplx_0(A,np__4)) = A ) ).

fof(t72_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k2_xcmplx_0(k7_xcmplx_0(A,np__4),k7_xcmplx_0(A,np__4)) = k7_xcmplx_0(A,np__2) ) ).

fof(t73_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(k2_xcmplx_0(A,A),np__4) = k7_xcmplx_0(A,np__2) ) ).

fof(t74_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k3_xcmplx_0(A,B) = np__1
           => A = k7_xcmplx_0(np__1,B) ) ) ) ).

fof(t75_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(A,k7_xcmplx_0(B,C)) = k7_xcmplx_0(k3_xcmplx_0(A,B),C) ) ) ) ).

fof(t76_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(k7_xcmplx_0(A,B),C) = k3_xcmplx_0(k7_xcmplx_0(C,B),A) ) ) ) ).

fof(t77_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k7_xcmplx_0(A,B),k7_xcmplx_0(C,D)) = k7_xcmplx_0(k3_xcmplx_0(A,C),k3_xcmplx_0(B,D)) ) ) ) ) ).

fof(t78_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(A,k7_xcmplx_0(B,C)) = k7_xcmplx_0(k3_xcmplx_0(A,C),B) ) ) ) ).

fof(t79_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(A,k3_xcmplx_0(B,C)) = k7_xcmplx_0(k7_xcmplx_0(A,B),C) ) ) ) ).

fof(t80_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(A,k7_xcmplx_0(B,C)) = k3_xcmplx_0(A,k7_xcmplx_0(C,B)) ) ) ) ).

fof(t81_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(A,k7_xcmplx_0(B,C)) = k3_xcmplx_0(k7_xcmplx_0(C,B),A) ) ) ) ).

fof(t82_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(A,k7_xcmplx_0(B,C)) = k3_xcmplx_0(C,k7_xcmplx_0(A,B)) ) ) ) ).

fof(t83_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(A,k7_xcmplx_0(B,C)) = k3_xcmplx_0(k7_xcmplx_0(A,B),C) ) ) ) ).

fof(t84_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k7_xcmplx_0(k3_xcmplx_0(A,B),k3_xcmplx_0(C,D)) = k7_xcmplx_0(k3_xcmplx_0(k7_xcmplx_0(A,C),B),D) ) ) ) ) ).

fof(t85_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k7_xcmplx_0(k7_xcmplx_0(A,B),k7_xcmplx_0(C,D)) = k7_xcmplx_0(k3_xcmplx_0(A,D),k3_xcmplx_0(B,C)) ) ) ) ) ).

fof(t86_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k3_xcmplx_0(k7_xcmplx_0(A,B),k7_xcmplx_0(C,D)) = k3_xcmplx_0(k7_xcmplx_0(A,D),k7_xcmplx_0(C,B)) ) ) ) ) ).

fof(t87_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ! [E] :
                      ( v1_xcmplx_0(E)
                     => k7_xcmplx_0(A,k3_xcmplx_0(k3_xcmplx_0(B,C),k7_xcmplx_0(D,E))) = k3_xcmplx_0(k7_xcmplx_0(E,C),k7_xcmplx_0(A,k3_xcmplx_0(B,D))) ) ) ) ) ) ).

fof(t88_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => k3_xcmplx_0(k7_xcmplx_0(B,A),A) = B ) ) ) ).

fof(t89_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k3_xcmplx_0(B,k7_xcmplx_0(A,A)) ) ) ) ).

fof(t90_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k7_xcmplx_0(k3_xcmplx_0(B,A),A) ) ) ) ).

fof(t91_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k3_xcmplx_0(B,C) = k3_xcmplx_0(k3_xcmplx_0(B,A),k7_xcmplx_0(C,A)) ) ) ) ) ).

fof(t92_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k7_xcmplx_0(B,C) = k7_xcmplx_0(k3_xcmplx_0(B,A),k3_xcmplx_0(C,A)) ) ) ) ) ).

fof(t93_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k7_xcmplx_0(B,C) = k3_xcmplx_0(k7_xcmplx_0(B,k3_xcmplx_0(C,A)),A) ) ) ) ) ).

fof(t94_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k3_xcmplx_0(B,C) = k7_xcmplx_0(k3_xcmplx_0(B,A),k7_xcmplx_0(A,C)) ) ) ) ) ).

fof(t95_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k3_xcmplx_0(C,A) = k3_xcmplx_0(D,B)
                   => ( A = np__0
                      | B = np__0
                      | k7_xcmplx_0(C,B) = k7_xcmplx_0(D,A) ) ) ) ) ) ) ).

fof(t96_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k7_xcmplx_0(C,B) = k7_xcmplx_0(D,A)
                   => ( A = np__0
                      | B = np__0
                      | k3_xcmplx_0(C,A) = k3_xcmplx_0(D,B) ) ) ) ) ) ) ).

fof(t97_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k3_xcmplx_0(C,A) = k7_xcmplx_0(D,B)
                   => ( A = np__0
                      | B = np__0
                      | k3_xcmplx_0(C,B) = k7_xcmplx_0(D,A) ) ) ) ) ) ) ).

fof(t98_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k7_xcmplx_0(B,C) = k3_xcmplx_0(A,k7_xcmplx_0(k7_xcmplx_0(B,A),C)) ) ) ) ) ).

fof(t99_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k7_xcmplx_0(B,C) = k3_xcmplx_0(k7_xcmplx_0(B,A),k7_xcmplx_0(A,C)) ) ) ) ) ).

fof(t100_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k3_xcmplx_0(A,k7_xcmplx_0(np__1,B)) = k7_xcmplx_0(A,B) ) ) ).

fof(t101_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(A,k7_xcmplx_0(np__1,B)) = k3_xcmplx_0(A,B) ) ) ).

fof(t102_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(k7_xcmplx_0(A,B),C) = k3_xcmplx_0(k3_xcmplx_0(k7_xcmplx_0(np__1,B),C),A) ) ) ) ).

fof(t103_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k3_xcmplx_0(k7_xcmplx_0(np__1,A),k7_xcmplx_0(np__1,B)) = k7_xcmplx_0(np__1,k3_xcmplx_0(A,B)) ) ) ).

fof(t104_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(k7_xcmplx_0(np__1,A),k7_xcmplx_0(B,C)) = k7_xcmplx_0(B,k3_xcmplx_0(C,A)) ) ) ) ).

fof(t105_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(k7_xcmplx_0(A,B),C) = k3_xcmplx_0(k7_xcmplx_0(np__1,B),k7_xcmplx_0(A,C)) ) ) ) ).

fof(t106_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k7_xcmplx_0(k7_xcmplx_0(A,B),C) = k3_xcmplx_0(k7_xcmplx_0(np__1,C),k7_xcmplx_0(A,B)) ) ) ) ).

fof(t107_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ( A != np__0
       => k3_xcmplx_0(A,k7_xcmplx_0(np__1,A)) = np__1 ) ) ).

fof(t108_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k3_xcmplx_0(k3_xcmplx_0(B,A),k7_xcmplx_0(np__1,A)) ) ) ) ).

fof(t109_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k3_xcmplx_0(B,k3_xcmplx_0(k7_xcmplx_0(np__1,A),A)) ) ) ) ).

fof(t110_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k3_xcmplx_0(k3_xcmplx_0(B,k7_xcmplx_0(np__1,A)),A) ) ) ) ).

fof(t111_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k7_xcmplx_0(B,k3_xcmplx_0(A,k7_xcmplx_0(np__1,A))) ) ) ) ).

fof(t112_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( A != np__0
              & B != np__0
              & k7_xcmplx_0(np__1,k3_xcmplx_0(A,B)) = np__0 ) ) ) ).

fof(t113_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( A != np__0
              & B != np__0
              & k3_xcmplx_0(k7_xcmplx_0(A,B),k7_xcmplx_0(B,A)) != np__1 ) ) ) ).

fof(t114_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k2_xcmplx_0(k7_xcmplx_0(B,A),C) = k7_xcmplx_0(k2_xcmplx_0(B,k3_xcmplx_0(A,C)),A) ) ) ) ) ).

fof(t115_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k2_xcmplx_0(B,C) = k3_xcmplx_0(A,k2_xcmplx_0(k7_xcmplx_0(B,A),k7_xcmplx_0(C,A))) ) ) ) ) ).

fof(t116_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k2_xcmplx_0(B,C) = k7_xcmplx_0(k2_xcmplx_0(k3_xcmplx_0(B,A),k3_xcmplx_0(C,A)),A) ) ) ) ) ).

fof(t117_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ~ ( A != np__0
                      & B != np__0
                      & k2_xcmplx_0(k7_xcmplx_0(C,A),k7_xcmplx_0(D,B)) != k7_xcmplx_0(k2_xcmplx_0(k3_xcmplx_0(C,B),k3_xcmplx_0(D,A)),k3_xcmplx_0(A,B)) ) ) ) ) ) ).

fof(t118_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => k2_xcmplx_0(A,B) = k3_xcmplx_0(A,k2_xcmplx_0(np__1,k7_xcmplx_0(B,A))) ) ) ) ).

fof(t119_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k2_xcmplx_0(k7_xcmplx_0(A,k3_xcmplx_0(np__2,B)),k7_xcmplx_0(A,k3_xcmplx_0(np__2,B))) = k7_xcmplx_0(A,B) ) ) ).

fof(t120_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k2_xcmplx_0(k2_xcmplx_0(k7_xcmplx_0(A,k3_xcmplx_0(np__3,B)),k7_xcmplx_0(A,k3_xcmplx_0(np__3,B))),k7_xcmplx_0(A,k3_xcmplx_0(np__3,B))) = k7_xcmplx_0(A,B) ) ) ).

fof(t121_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k7_xcmplx_0(A,B),k7_xcmplx_0(C,B)) = k7_xcmplx_0(k6_xcmplx_0(A,C),B) ) ) ) ).

fof(t122_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k6_xcmplx_0(A,k7_xcmplx_0(A,np__2)) = k7_xcmplx_0(A,np__2) ) ).

fof(t123_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k7_xcmplx_0(k6_xcmplx_0(k6_xcmplx_0(A,B),C),D) = k6_xcmplx_0(k6_xcmplx_0(k7_xcmplx_0(A,D),k7_xcmplx_0(B,D)),k7_xcmplx_0(C,D)) ) ) ) ) ).

fof(t124_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k7_xcmplx_0(C,A) = k7_xcmplx_0(D,B)
                   => ( A = np__0
                      | B = np__0
                      | A = B
                      | k7_xcmplx_0(C,A) = k7_xcmplx_0(k6_xcmplx_0(C,D),k6_xcmplx_0(A,B)) ) ) ) ) ) ) ).

fof(t125_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k7_xcmplx_0(k6_xcmplx_0(k2_xcmplx_0(A,B),C),D) = k6_xcmplx_0(k2_xcmplx_0(k7_xcmplx_0(A,D),k7_xcmplx_0(B,D)),k7_xcmplx_0(C,D)) ) ) ) ) ).

fof(t126_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k7_xcmplx_0(k2_xcmplx_0(k6_xcmplx_0(A,B),C),D) = k2_xcmplx_0(k6_xcmplx_0(k7_xcmplx_0(A,D),k7_xcmplx_0(B,D)),k7_xcmplx_0(C,D)) ) ) ) ) ).

fof(t127_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k6_xcmplx_0(k7_xcmplx_0(B,A),C) = k7_xcmplx_0(k6_xcmplx_0(B,k3_xcmplx_0(C,A)),A) ) ) ) ) ).

fof(t128_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k6_xcmplx_0(B,k7_xcmplx_0(C,A)) = k7_xcmplx_0(k6_xcmplx_0(k3_xcmplx_0(B,A),C),A) ) ) ) ) ).

fof(t129_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k6_xcmplx_0(B,C) = k3_xcmplx_0(A,k6_xcmplx_0(k7_xcmplx_0(B,A),k7_xcmplx_0(C,A))) ) ) ) ) ).

fof(t130_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k6_xcmplx_0(B,C) = k7_xcmplx_0(k6_xcmplx_0(k3_xcmplx_0(B,A),k3_xcmplx_0(C,A)),A) ) ) ) ) ).

fof(t131_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ~ ( A != np__0
                      & B != np__0
                      & k6_xcmplx_0(k7_xcmplx_0(C,A),k7_xcmplx_0(D,B)) != k7_xcmplx_0(k6_xcmplx_0(k3_xcmplx_0(C,B),k3_xcmplx_0(D,A)),k3_xcmplx_0(A,B)) ) ) ) ) ) ).

fof(t132_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => k6_xcmplx_0(A,B) = k3_xcmplx_0(A,k6_xcmplx_0(np__1,k7_xcmplx_0(B,A))) ) ) ) ).

fof(t133_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => B = k7_xcmplx_0(k6_xcmplx_0(k2_xcmplx_0(k3_xcmplx_0(A,B),C),C),A) ) ) ) ) ).

fof(t134_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k4_xcmplx_0(A) = k4_xcmplx_0(B)
           => A = B ) ) ) ).

fof(t135_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ( k4_xcmplx_0(A) = np__0
       => A = np__0 ) ) ).

fof(t136_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k2_xcmplx_0(A,k4_xcmplx_0(B)) = np__0
           => A = B ) ) ) ).

fof(t137_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k2_xcmplx_0(k2_xcmplx_0(A,B),k4_xcmplx_0(B)) ) ) ).

fof(t138_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k2_xcmplx_0(A,k2_xcmplx_0(B,k4_xcmplx_0(B))) ) ) ).

fof(t139_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k2_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(B),A),B) ) ) ).

fof(t140_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k2_xcmplx_0(A,B)) = k2_xcmplx_0(k4_xcmplx_0(A),k4_xcmplx_0(B)) ) ) ).

fof(t141_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B)) = k2_xcmplx_0(A,k4_xcmplx_0(B)) ) ) ).

fof(t142_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k2_xcmplx_0(A,B) = k4_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),k4_xcmplx_0(B))) ) ) ).

fof(t143_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k6_xcmplx_0(A,B)) = k6_xcmplx_0(B,A) ) ) ).

fof(t144_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k6_xcmplx_0(k4_xcmplx_0(A),B) = k6_xcmplx_0(k4_xcmplx_0(B),A) ) ) ).

fof(t145_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k6_xcmplx_0(k4_xcmplx_0(B),k6_xcmplx_0(k4_xcmplx_0(A),B)) ) ) ).

fof(t146_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),C) = k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),C),B) ) ) ) ).

fof(t147_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),C) = k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(B),C),A) ) ) ) ).

fof(t148_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),C) = k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(C),B),A) ) ) ) ).

fof(t149_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(A,B),k6_xcmplx_0(A,C)) = k4_xcmplx_0(k6_xcmplx_0(B,C)) ) ) ) ).

fof(t150_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k6_xcmplx_0(np__0,A) = k4_xcmplx_0(A) ) ).

fof(t151_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k2_xcmplx_0(A,B) = k6_xcmplx_0(A,k4_xcmplx_0(B)) ) ) ).

fof(t152_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => A = k6_xcmplx_0(A,k2_xcmplx_0(B,k4_xcmplx_0(B))) ) ) ).

fof(t153_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( k6_xcmplx_0(A,B) = k2_xcmplx_0(C,k4_xcmplx_0(B))
               => A = C ) ) ) ) ).

fof(t154_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( k6_xcmplx_0(A,B) = k2_xcmplx_0(A,k4_xcmplx_0(C))
               => B = C ) ) ) ) ).

fof(t155_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k2_xcmplx_0(A,B),C) = k2_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(C),A),B) ) ) ) ).

fof(t156_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(k6_xcmplx_0(A,B),C) = k2_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(B),C),A) ) ) ) ).

fof(t157_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(A,k6_xcmplx_0(k4_xcmplx_0(B),C)) = k2_xcmplx_0(k2_xcmplx_0(A,B),C) ) ) ) ).

fof(t158_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(A,B),C) = k2_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(B),C),A) ) ) ) ).

fof(t159_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(A,B),C) = k6_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(C),A),B) ) ) ) ).

fof(t160_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(A,B),C) = k2_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(C),B),A) ) ) ) ).

fof(t161_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k2_xcmplx_0(A,B)) = k6_xcmplx_0(k4_xcmplx_0(B),A) ) ) ).

fof(t162_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k6_xcmplx_0(A,B)) = k2_xcmplx_0(k4_xcmplx_0(A),B) ) ) ).

fof(t163_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B)) = k6_xcmplx_0(A,B) ) ) ).

fof(t164_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k2_xcmplx_0(A,B) = k4_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B)) ) ) ).

fof(t165_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B),C) = k6_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(C),B),A) ) ) ) ).

fof(t166_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B),C) = k2_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(C),A),B) ) ) ) ).

fof(t167_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(A,B),C)) = k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),C) ) ) ) ).

fof(t168_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k6_xcmplx_0(k2_xcmplx_0(A,B),C)) = k2_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),C) ) ) ) ).

fof(t169_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k2_xcmplx_0(k6_xcmplx_0(A,B),C)) = k6_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B),C) ) ) ) ).

fof(t170_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k6_xcmplx_0(k6_xcmplx_0(A,B),C)) = k2_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B),C) ) ) ) ).

fof(t171_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B),C)) = k6_xcmplx_0(k6_xcmplx_0(A,B),C) ) ) ) ).

fof(t172_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k6_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),B),C)) = k2_xcmplx_0(k6_xcmplx_0(A,B),C) ) ) ) ).

fof(t173_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k2_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),C)) = k6_xcmplx_0(k2_xcmplx_0(A,B),C) ) ) ) ).

fof(t174_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k4_xcmplx_0(k6_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),C)) = k2_xcmplx_0(k2_xcmplx_0(A,B),C) ) ) ) ).

fof(t175_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k3_xcmplx_0(k4_xcmplx_0(A),B) = k4_xcmplx_0(k3_xcmplx_0(A,B)) ) ) ).

fof(t176_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k3_xcmplx_0(k4_xcmplx_0(A),B) = k3_xcmplx_0(A,k4_xcmplx_0(B)) ) ) ).

fof(t177_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k3_xcmplx_0(k4_xcmplx_0(A),k4_xcmplx_0(B)) = k3_xcmplx_0(A,B) ) ) ).

fof(t178_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k3_xcmplx_0(A,k4_xcmplx_0(B))) = k3_xcmplx_0(A,B) ) ) ).

fof(t179_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k3_xcmplx_0(k4_xcmplx_0(A),B)) = k3_xcmplx_0(A,B) ) ) ).

fof(t180_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k3_xcmplx_0(k4_xcmplx_0(np__1),A) = k4_xcmplx_0(A) ) ).

fof(t181_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k3_xcmplx_0(k4_xcmplx_0(A),k4_xcmplx_0(np__1)) = A ) ).

fof(t182_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k3_xcmplx_0(B,A) = k4_xcmplx_0(A)
           => ( A = np__0
              | B = k4_xcmplx_0(np__1) ) ) ) ) ).

fof(t183_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ~ ( k3_xcmplx_0(A,A) = np__1
          & A != np__1
          & A != k4_xcmplx_0(np__1) ) ) ).

fof(t184_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k2_xcmplx_0(k4_xcmplx_0(A),k3_xcmplx_0(np__2,A)) = A ) ).

fof(t185_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(k6_xcmplx_0(A,B),C) = k3_xcmplx_0(k6_xcmplx_0(B,A),k4_xcmplx_0(C)) ) ) ) ).

fof(t186_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(k6_xcmplx_0(A,B),C) = k4_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(B,A),C)) ) ) ) ).

fof(t187_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k6_xcmplx_0(A,k3_xcmplx_0(np__2,A)) = k4_xcmplx_0(A) ) ).

fof(t188_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k7_xcmplx_0(A,B)) = k7_xcmplx_0(k4_xcmplx_0(A),B) ) ) ).

fof(t189_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(A,k4_xcmplx_0(B)) = k4_xcmplx_0(k7_xcmplx_0(A,B)) ) ) ).

fof(t190_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k7_xcmplx_0(A,k4_xcmplx_0(B))) = k7_xcmplx_0(A,B) ) ) ).

fof(t191_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k4_xcmplx_0(k7_xcmplx_0(k4_xcmplx_0(A),B)) = k7_xcmplx_0(A,B) ) ) ).

fof(t192_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(k4_xcmplx_0(A),k4_xcmplx_0(B)) = k7_xcmplx_0(A,B) ) ) ).

fof(t193_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(k4_xcmplx_0(A),B) = k7_xcmplx_0(A,k4_xcmplx_0(B)) ) ) ).

fof(t194_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k4_xcmplx_0(A) = k7_xcmplx_0(A,k4_xcmplx_0(np__1)) ) ).

fof(t195_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => A = k7_xcmplx_0(k4_xcmplx_0(A),k4_xcmplx_0(np__1)) ) ).

fof(t196_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k7_xcmplx_0(A,B) = k4_xcmplx_0(np__1)
           => ( A = k4_xcmplx_0(B)
              & B = k4_xcmplx_0(A) ) ) ) ) ).

fof(t197_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k7_xcmplx_0(A,B) = k4_xcmplx_0(A)
           => ( A = np__0
              | B = k4_xcmplx_0(np__1) ) ) ) ) ).

fof(t198_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ( A != np__0
       => k7_xcmplx_0(k4_xcmplx_0(A),A) = k4_xcmplx_0(np__1) ) ) ).

fof(t199_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ( A != np__0
       => k7_xcmplx_0(A,k4_xcmplx_0(A)) = k4_xcmplx_0(np__1) ) ) ).

fof(t200_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ~ ( A != np__0
          & A = k7_xcmplx_0(np__1,A)
          & A != np__1
          & A != k4_xcmplx_0(np__1) ) ) ).

fof(t201_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ( k7_xcmplx_0(C,A) = k7_xcmplx_0(D,B)
                   => ( A = np__0
                      | B = np__0
                      | A = k4_xcmplx_0(B)
                      | k7_xcmplx_0(C,A) = k7_xcmplx_0(k2_xcmplx_0(C,D),k2_xcmplx_0(A,B)) ) ) ) ) ) ) ).

fof(t202_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k5_xcmplx_0(A) = k5_xcmplx_0(B)
           => A = B ) ) ) ).

fof(t203_xcmplx_1,axiom,
    k5_xcmplx_0(np__0) = np__0 ).

fof(t204_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( A != np__0
           => B = k3_xcmplx_0(k3_xcmplx_0(B,A),k5_xcmplx_0(A)) ) ) ) ).

fof(t205_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k3_xcmplx_0(k5_xcmplx_0(A),k5_xcmplx_0(B)) = k5_xcmplx_0(k3_xcmplx_0(A,B)) ) ) ).

fof(t206_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k5_xcmplx_0(k3_xcmplx_0(A,k5_xcmplx_0(B))) = k3_xcmplx_0(k5_xcmplx_0(A),B) ) ) ).

fof(t207_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k5_xcmplx_0(k3_xcmplx_0(k5_xcmplx_0(A),k5_xcmplx_0(B))) = k3_xcmplx_0(A,B) ) ) ).

fof(t208_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( A != np__0
              & B != np__0
              & k3_xcmplx_0(A,k5_xcmplx_0(B)) = np__0 ) ) ) ).

fof(t209_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( A != np__0
              & B != np__0
              & k3_xcmplx_0(k5_xcmplx_0(A),k5_xcmplx_0(B)) = np__0 ) ) ) ).

fof(t210_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k3_xcmplx_0(A,k5_xcmplx_0(B)) = np__1
           => A = B ) ) ) ).

fof(t211_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k3_xcmplx_0(A,B) = np__1
           => A = k5_xcmplx_0(B) ) ) ) ).

fof(t212_xcmplx_1,axiom,
    $true ).

fof(t213_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( A != np__0
              & B != np__0
              & k2_xcmplx_0(k5_xcmplx_0(A),k5_xcmplx_0(B)) != k3_xcmplx_0(k2_xcmplx_0(A,B),k5_xcmplx_0(k3_xcmplx_0(A,B))) ) ) ) ).

fof(t214_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( A != np__0
              & B != np__0
              & k6_xcmplx_0(k5_xcmplx_0(A),k5_xcmplx_0(B)) != k3_xcmplx_0(k6_xcmplx_0(B,A),k5_xcmplx_0(k3_xcmplx_0(A,B))) ) ) ) ).

fof(t215_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k5_xcmplx_0(k7_xcmplx_0(A,B)) = k7_xcmplx_0(B,A) ) ) ).

fof(t216_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(k5_xcmplx_0(A),k5_xcmplx_0(B)) = k7_xcmplx_0(B,A) ) ) ).

fof(t217_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(np__1,A) = k5_xcmplx_0(A) ) ).

fof(t218_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k7_xcmplx_0(np__1,k5_xcmplx_0(A)) = A ) ).

fof(t219_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k5_xcmplx_0(k7_xcmplx_0(np__1,A)) = A ) ).

fof(t220_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k7_xcmplx_0(np__1,A) = k5_xcmplx_0(B)
           => A = B ) ) ) ).

fof(t221_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(A,k5_xcmplx_0(B)) = k3_xcmplx_0(A,B) ) ) ).

fof(t222_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k3_xcmplx_0(k5_xcmplx_0(A),k7_xcmplx_0(B,C)) = k7_xcmplx_0(B,k3_xcmplx_0(A,C)) ) ) ) ).

fof(t223_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k7_xcmplx_0(k5_xcmplx_0(A),B) = k5_xcmplx_0(k3_xcmplx_0(A,B)) ) ) ).

fof(t224_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k5_xcmplx_0(k4_xcmplx_0(A)) = k4_xcmplx_0(k5_xcmplx_0(A)) ) ).

fof(t225_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ~ ( A != np__0
          & A = k5_xcmplx_0(A)
          & A != np__1
          & A != k4_xcmplx_0(np__1) ) ) ).

fof(t226_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k2_xcmplx_0(k2_xcmplx_0(A,B),C),B) = k2_xcmplx_0(A,C) ) ) ) ).

fof(t227_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(k2_xcmplx_0(k6_xcmplx_0(A,B),C),B) = k2_xcmplx_0(A,C) ) ) ) ).

fof(t228_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k6_xcmplx_0(k6_xcmplx_0(k2_xcmplx_0(A,B),C),B) = k6_xcmplx_0(A,C) ) ) ) ).

fof(t229_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => k2_xcmplx_0(k6_xcmplx_0(k6_xcmplx_0(A,B),C),B) = k6_xcmplx_0(A,C) ) ) ) ).

fof(t230_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k6_xcmplx_0(k6_xcmplx_0(A,A),B) = k4_xcmplx_0(B) ) ) ).

fof(t231_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k6_xcmplx_0(k2_xcmplx_0(k4_xcmplx_0(A),A),B) = k4_xcmplx_0(B) ) ) ).

fof(t232_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k6_xcmplx_0(k6_xcmplx_0(A,B),A) = k4_xcmplx_0(B) ) ) ).

fof(t233_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k2_xcmplx_0(k6_xcmplx_0(k4_xcmplx_0(A),B),A) = k4_xcmplx_0(B) ) ) ).

fof(t234_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ~ ( B != np__0
              & ! [C] :
                  ( v1_xcmplx_0(C)
                 => A != k7_xcmplx_0(B,C) ) ) ) ) ).

fof(t235_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => ! [E] :
                      ( v1_xcmplx_0(E)
                     => k7_xcmplx_0(A,k3_xcmplx_0(k3_xcmplx_0(B,C),k7_xcmplx_0(D,E))) = k3_xcmplx_0(k7_xcmplx_0(E,C),k7_xcmplx_0(A,k3_xcmplx_0(B,D))) ) ) ) ) ) ).

fof(t236_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ! [D] :
                  ( v1_xcmplx_0(D)
                 => k2_xcmplx_0(k3_xcmplx_0(k7_xcmplx_0(k6_xcmplx_0(A,B),C),D),B) = k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,k7_xcmplx_0(D,C)),B),k3_xcmplx_0(k7_xcmplx_0(D,C),A)) ) ) ) ) ).

fof(t237_xcmplx_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ! [C] :
              ( v1_xcmplx_0(C)
             => ( A != np__0
               => k2_xcmplx_0(k3_xcmplx_0(A,B),C) = k3_xcmplx_0(A,k2_xcmplx_0(B,k7_xcmplx_0(C,A))) ) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,B)
              & r1_xreal_0(B,A) )
           => A = B ) ) ) ).

fof(t2_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,B)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(A,C) ) ) ) ) ).

fof(t3_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ! [B] :
            ( v1_xreal_0(B)
           => r1_xreal_0(B,A) ) ) ).

fof(t4_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ! [B] :
            ( v1_xreal_0(B)
           => r1_xreal_0(A,B) ) ) ).

fof(t5_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ? [C] :
              ( v1_xreal_0(C)
              & ~ r1_xreal_0(C,A)
              & ~ r1_xreal_0(C,B) ) ) ) ).

fof(t6_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ? [C] :
              ( v1_xreal_0(C)
              & ~ r1_xreal_0(A,C)
              & ~ r1_xreal_0(B,C) ) ) ) ).

fof(t7_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(B,A)
              & ! [C] :
                  ( v1_xreal_0(C)
                 => ~ ( ~ r1_xreal_0(C,A)
                      & ~ r1_xreal_0(B,C) ) ) ) ) ) ).

fof(t8_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(A,B)
              <=> r1_xreal_0(k2_xcmplx_0(A,C),k2_xcmplx_0(B,C)) ) ) ) ) ).

fof(t9_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( ( r1_xreal_0(A,B)
                      & r1_xreal_0(C,D) )
                   => r1_xreal_0(k2_xcmplx_0(A,C),k2_xcmplx_0(B,D)) ) ) ) ) ) ).

fof(t10_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(B,A)
                      & r1_xreal_0(C,D)
                      & r1_xreal_0(k2_xcmplx_0(B,D),k2_xcmplx_0(A,C)) ) ) ) ) ) ).

fof(t11_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(A,B)
              <=> r1_xreal_0(k6_xcmplx_0(A,C),k6_xcmplx_0(B,C)) ) ) ) ) ).

fof(t12_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(A,B)
              <=> r1_xreal_0(k6_xcmplx_0(C,B),k6_xcmplx_0(C,A)) ) ) ) ) ).

fof(t13_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(A,k6_xcmplx_0(B,C))
               => r1_xreal_0(C,k6_xcmplx_0(B,A)) ) ) ) ) ).

fof(t14_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(k6_xcmplx_0(A,B),C)
               => r1_xreal_0(k6_xcmplx_0(A,C),B) ) ) ) ) ).

fof(t15_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( ( r1_xreal_0(A,B)
                      & r1_xreal_0(C,D) )
                   => r1_xreal_0(k6_xcmplx_0(A,D),k6_xcmplx_0(B,C)) ) ) ) ) ) ).

fof(t16_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(B,A)
                      & r1_xreal_0(C,D)
                      & r1_xreal_0(k6_xcmplx_0(B,C),k6_xcmplx_0(A,D)) ) ) ) ) ) ).

fof(t17_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( r1_xreal_0(A,B)
                      & ~ r1_xreal_0(D,C)
                      & r1_xreal_0(k6_xcmplx_0(B,C),k6_xcmplx_0(A,D)) ) ) ) ) ) ).

fof(t18_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k6_xcmplx_0(A,B),k6_xcmplx_0(C,D))
                   => r1_xreal_0(k6_xcmplx_0(A,C),k6_xcmplx_0(B,D)) ) ) ) ) ) ).

fof(t19_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k6_xcmplx_0(A,B),k6_xcmplx_0(C,D))
                   => r1_xreal_0(k6_xcmplx_0(D,B),k6_xcmplx_0(C,A)) ) ) ) ) ) ).

fof(t20_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k6_xcmplx_0(A,B),k6_xcmplx_0(C,D))
                   => r1_xreal_0(k6_xcmplx_0(D,C),k6_xcmplx_0(B,A)) ) ) ) ) ) ).

fof(t21_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(k2_xcmplx_0(A,B),C)
              <=> r1_xreal_0(A,k6_xcmplx_0(C,B)) ) ) ) ) ).

fof(t22_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(A,k2_xcmplx_0(B,C))
              <=> r1_xreal_0(k6_xcmplx_0(A,B),C) ) ) ) ) ).

fof(t23_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k2_xcmplx_0(A,B),k2_xcmplx_0(C,D))
                  <=> r1_xreal_0(k6_xcmplx_0(A,C),k6_xcmplx_0(D,B)) ) ) ) ) ) ).

fof(t24_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k2_xcmplx_0(A,B),k6_xcmplx_0(C,D))
                   => r1_xreal_0(k2_xcmplx_0(A,D),k6_xcmplx_0(C,B)) ) ) ) ) ) ).

fof(t25_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k6_xcmplx_0(A,B),k2_xcmplx_0(C,D))
                   => r1_xreal_0(k6_xcmplx_0(A,D),k2_xcmplx_0(C,B)) ) ) ) ) ) ).

fof(t26_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
          <=> r1_xreal_0(k4_xcmplx_0(B),k4_xcmplx_0(A)) ) ) ) ).

fof(t27_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,k4_xcmplx_0(B))
           => r1_xreal_0(B,k4_xcmplx_0(A)) ) ) ) ).

fof(t28_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(k4_xcmplx_0(A),B)
           => r1_xreal_0(k4_xcmplx_0(B),A) ) ) ) ).

fof(t29_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B)
              & k2_xcmplx_0(A,B) = np__0 )
           => A = np__0 ) ) ) ).

fof(t30_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(B,np__0)
              & k2_xcmplx_0(A,B) = np__0 )
           => A = np__0 ) ) ) ).

fof(t31_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & r1_xreal_0(k2_xcmplx_0(B,A),B) ) ) ) ).

fof(t32_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & r1_xreal_0(B,k2_xcmplx_0(A,B)) ) ) ) ).

fof(t33_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(np__0,A)
           => r1_xreal_0(B,k2_xcmplx_0(A,B)) ) ) ) ).

fof(t34_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,np__0)
           => r1_xreal_0(k2_xcmplx_0(A,B),B) ) ) ) ).

fof(t35_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => r1_xreal_0(np__0,k2_xcmplx_0(A,B)) ) ) ) ).

fof(t36_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,np__0)
              & r1_xreal_0(k2_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t37_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,np__0)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(k2_xcmplx_0(B,A),C) ) ) ) ) ).

fof(t38_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(C,k2_xcmplx_0(B,A)) ) ) ) ) ).

fof(t39_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & r1_xreal_0(B,C)
                  & r1_xreal_0(C,k2_xcmplx_0(B,A)) ) ) ) ) ).

fof(t40_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(B,k2_xcmplx_0(A,C)) ) ) ) ) ).

fof(t41_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(A,np__0)
                  & r1_xreal_0(B,C)
                  & r1_xreal_0(k2_xcmplx_0(A,C),B) ) ) ) ) ).

fof(t42_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k2_xcmplx_0(A,C),B) ) ) ) ) ).

fof(t43_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ( ~ r1_xreal_0(C,np__0)
                 => r1_xreal_0(A,k2_xcmplx_0(B,C)) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t44_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ( ~ r1_xreal_0(np__0,C)
                 => r1_xreal_0(k2_xcmplx_0(A,C),B) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t45_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(np__0,A)
           => r1_xreal_0(k6_xcmplx_0(B,A),B) ) ) ) ).

fof(t46_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & r1_xreal_0(B,k6_xcmplx_0(B,A)) ) ) ) ).

fof(t47_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,np__0)
           => r1_xreal_0(B,k6_xcmplx_0(B,A)) ) ) ) ).

fof(t48_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & r1_xreal_0(k6_xcmplx_0(B,A),B) ) ) ) ).

fof(t49_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
           => r1_xreal_0(k6_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t50_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
           => r1_xreal_0(np__0,k6_xcmplx_0(B,A)) ) ) ) ).

fof(t51_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(B,A)
              & r1_xreal_0(np__0,k6_xcmplx_0(A,B)) ) ) ) ).

fof(t52_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(B,A)
              & r1_xreal_0(k6_xcmplx_0(B,A),np__0) ) ) ) ).

fof(t53_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(C,k6_xcmplx_0(B,A)) ) ) ) ) ).

fof(t54_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,np__0)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(B,k6_xcmplx_0(C,A)) ) ) ) ) ).

fof(t55_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k6_xcmplx_0(C,A),B) ) ) ) ) ).

fof(t56_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & r1_xreal_0(B,C)
                  & r1_xreal_0(k6_xcmplx_0(C,A),B) ) ) ) ) ).

fof(t57_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( A != B
              & r1_xreal_0(k6_xcmplx_0(A,B),np__0)
              & r1_xreal_0(k6_xcmplx_0(B,A),np__0) ) ) ) ).

fof(t58_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ( ~ r1_xreal_0(np__0,C)
                 => r1_xreal_0(A,k6_xcmplx_0(B,C)) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t59_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ( ~ r1_xreal_0(C,np__0)
                 => r1_xreal_0(k6_xcmplx_0(A,C),B) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t60_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ ( ~ r1_xreal_0(np__0,A)
            & r1_xreal_0(k4_xcmplx_0(A),np__0) )
        & ~ ( ~ r1_xreal_0(k4_xcmplx_0(A),np__0)
            & r1_xreal_0(np__0,A) ) ) ) ).

fof(t61_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,k4_xcmplx_0(B))
           => r1_xreal_0(k2_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t62_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(k4_xcmplx_0(A),B)
           => r1_xreal_0(np__0,k2_xcmplx_0(A,B)) ) ) ) ).

fof(t63_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(k4_xcmplx_0(B),A)
              & r1_xreal_0(np__0,k2_xcmplx_0(A,B)) ) ) ) ).

fof(t64_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(B,k4_xcmplx_0(A))
              & r1_xreal_0(k2_xcmplx_0(B,A),np__0) ) ) ) ).

fof(t65_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => r1_xreal_0(np__0,k3_xcmplx_0(A,A)) ) ).

fof(t66_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,B)
                  & r1_xreal_0(np__0,C) )
               => r1_xreal_0(k3_xcmplx_0(A,C),k3_xcmplx_0(B,C)) ) ) ) ) ).

fof(t67_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,B)
                  & r1_xreal_0(C,np__0) )
               => r1_xreal_0(k3_xcmplx_0(B,C),k3_xcmplx_0(A,C)) ) ) ) ) ).

fof(t68_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( ( r1_xreal_0(np__0,A)
                      & r1_xreal_0(A,B)
                      & r1_xreal_0(np__0,C)
                      & r1_xreal_0(C,D) )
                   => r1_xreal_0(k3_xcmplx_0(A,C),k3_xcmplx_0(B,D)) ) ) ) ) ) ).

fof(t69_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( ( r1_xreal_0(A,np__0)
                      & r1_xreal_0(B,A)
                      & r1_xreal_0(C,np__0)
                      & r1_xreal_0(D,C) )
                   => r1_xreal_0(k3_xcmplx_0(A,C),k3_xcmplx_0(B,D)) ) ) ) ) ) ).

fof(t70_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k3_xcmplx_0(C,A),k3_xcmplx_0(B,A)) ) ) ) ) ).

fof(t71_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k3_xcmplx_0(B,A),k3_xcmplx_0(C,A)) ) ) ) ) ).

fof(t72_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(np__0,A)
                      & r1_xreal_0(B,A)
                      & ~ r1_xreal_0(np__0,C)
                      & ~ r1_xreal_0(C,D)
                      & r1_xreal_0(k3_xcmplx_0(B,D),k3_xcmplx_0(A,C)) ) ) ) ) ) ).

fof(t73_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( r1_xreal_0(np__0,A)
                      & r1_xreal_0(np__0,B)
                      & r1_xreal_0(np__0,C)
                      & r1_xreal_0(np__0,D)
                      & k2_xcmplx_0(k3_xcmplx_0(A,C),k3_xcmplx_0(B,D)) = np__0
                      & A != np__0
                      & C != np__0 ) ) ) ) ) ).

fof(t74_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(k7_xcmplx_0(B,A),k7_xcmplx_0(C,A)) ) ) ) ) ).

fof(t75_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,np__0)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(B,A)) ) ) ) ) ).

fof(t76_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(B,A)) ) ) ) ) ).

fof(t77_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k7_xcmplx_0(B,A),k7_xcmplx_0(C,A)) ) ) ) ) ).

fof(t78_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(B,np__0)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k7_xcmplx_0(A,B),k7_xcmplx_0(A,C)) ) ) ) ) ).

fof(t79_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(k3_xcmplx_0(B,A),C)
               => ( r1_xreal_0(A,np__0)
                  | r1_xreal_0(B,k7_xcmplx_0(C,A)) ) ) ) ) ) ).

fof(t80_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(k3_xcmplx_0(B,A),C)
               => ( r1_xreal_0(np__0,A)
                  | r1_xreal_0(k7_xcmplx_0(C,A),B) ) ) ) ) ) ).

fof(t81_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(B,k3_xcmplx_0(C,A))
               => ( r1_xreal_0(A,np__0)
                  | r1_xreal_0(k7_xcmplx_0(B,A),C) ) ) ) ) ) ).

fof(t82_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( r1_xreal_0(B,k3_xcmplx_0(C,A))
               => ( r1_xreal_0(np__0,A)
                  | r1_xreal_0(C,k7_xcmplx_0(B,A)) ) ) ) ) ) ).

fof(t83_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(C,k3_xcmplx_0(B,A))
                  & r1_xreal_0(k7_xcmplx_0(C,A),B) ) ) ) ) ).

fof(t84_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(C,k3_xcmplx_0(B,A))
                  & r1_xreal_0(B,k7_xcmplx_0(C,A)) ) ) ) ) ).

fof(t85_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(k3_xcmplx_0(C,A),B)
                  & r1_xreal_0(C,k7_xcmplx_0(B,A)) ) ) ) ) ).

fof(t86_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(k3_xcmplx_0(C,A),B)
                  & r1_xreal_0(k7_xcmplx_0(B,A),C) ) ) ) ) ).

fof(t87_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
           => ( r1_xreal_0(A,np__0)
              | r1_xreal_0(k5_xcmplx_0(B),k5_xcmplx_0(A)) ) ) ) ) ).

fof(t88_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(B,A)
           => ( r1_xreal_0(np__0,A)
              | r1_xreal_0(k5_xcmplx_0(A),k5_xcmplx_0(B)) ) ) ) ) ).

fof(t89_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(A,B)
              & r1_xreal_0(k5_xcmplx_0(B),k5_xcmplx_0(A)) ) ) ) ).

fof(t90_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(B,A)
              & r1_xreal_0(k5_xcmplx_0(A),k5_xcmplx_0(B)) ) ) ) ).

fof(t91_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(k5_xcmplx_0(A),k5_xcmplx_0(B))
           => ( r1_xreal_0(k5_xcmplx_0(A),np__0)
              | r1_xreal_0(B,A) ) ) ) ) ).

fof(t92_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(k5_xcmplx_0(B),k5_xcmplx_0(A))
           => ( r1_xreal_0(np__0,k5_xcmplx_0(A))
              | r1_xreal_0(A,B) ) ) ) ) ).

fof(t93_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(k5_xcmplx_0(A),np__0)
              & ~ r1_xreal_0(k5_xcmplx_0(B),k5_xcmplx_0(A))
              & r1_xreal_0(A,B) ) ) ) ).

fof(t94_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,k5_xcmplx_0(A))
              & ~ r1_xreal_0(k5_xcmplx_0(A),k5_xcmplx_0(B))
              & r1_xreal_0(B,A) ) ) ) ).

fof(t95_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(k3_xcmplx_0(k6_xcmplx_0(B,A),k2_xcmplx_0(B,A)),np__0) )
           => ( r1_xreal_0(k4_xcmplx_0(A),B)
              & r1_xreal_0(B,A) ) ) ) ) ).

fof(t96_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(np__0,A)
           => ( r1_xreal_0(np__0,k3_xcmplx_0(k6_xcmplx_0(B,A),k2_xcmplx_0(B,A)))
              | ( ~ r1_xreal_0(B,k4_xcmplx_0(A))
                & ~ r1_xreal_0(A,B) ) ) ) ) ) ).

fof(t97_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,k3_xcmplx_0(k6_xcmplx_0(B,A),k2_xcmplx_0(B,A)))
              & ~ r1_xreal_0(B,k4_xcmplx_0(A))
              & ~ r1_xreal_0(A,B) ) ) ) ).

fof(t98_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( r1_xreal_0(np__0,A)
                      & r1_xreal_0(np__0,B)
                      & ~ r1_xreal_0(C,A)
                      & ~ r1_xreal_0(D,B)
                      & r1_xreal_0(k3_xcmplx_0(C,D),k3_xcmplx_0(A,B)) ) ) ) ) ) ).

fof(t99_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( r1_xreal_0(np__0,A)
                      & ~ r1_xreal_0(B,np__0)
                      & ~ r1_xreal_0(C,A)
                      & r1_xreal_0(B,D)
                      & r1_xreal_0(k3_xcmplx_0(C,D),k3_xcmplx_0(A,B)) ) ) ) ) ) ).

fof(t100_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(B,np__0)
                      & r1_xreal_0(A,C)
                      & ~ r1_xreal_0(D,B)
                      & r1_xreal_0(k3_xcmplx_0(C,D),k3_xcmplx_0(A,B)) ) ) ) ) ) ).

fof(t101_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(np__0,B)
                  & ~ r1_xreal_0(B,C)
                  & r1_xreal_0(k7_xcmplx_0(A,C),k7_xcmplx_0(A,B)) ) ) ) ) ).

fof(t102_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(B,np__0)
                  & ~ r1_xreal_0(C,B)
                  & r1_xreal_0(k7_xcmplx_0(A,C),k7_xcmplx_0(A,B)) ) ) ) ) ).

fof(t103_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(np__0,B)
                  & ~ r1_xreal_0(B,C)
                  & r1_xreal_0(k7_xcmplx_0(A,B),k7_xcmplx_0(A,C)) ) ) ) ) ).

fof(t104_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k3_xcmplx_0(C,B),k3_xcmplx_0(D,A))
                   => ( r1_xreal_0(A,np__0)
                      | r1_xreal_0(B,np__0)
                      | r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(D,B)) ) ) ) ) ) ) ).

fof(t105_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k3_xcmplx_0(C,B),k3_xcmplx_0(D,A))
                   => ( r1_xreal_0(np__0,A)
                      | r1_xreal_0(np__0,B)
                      | r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(D,B)) ) ) ) ) ) ) ).

fof(t106_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k3_xcmplx_0(C,B),k3_xcmplx_0(D,A))
                   => ( r1_xreal_0(A,np__0)
                      | r1_xreal_0(np__0,B)
                      | r1_xreal_0(k7_xcmplx_0(D,B),k7_xcmplx_0(C,A)) ) ) ) ) ) ) ).

fof(t107_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( r1_xreal_0(k3_xcmplx_0(C,B),k3_xcmplx_0(D,A))
                   => ( r1_xreal_0(np__0,A)
                      | r1_xreal_0(B,np__0)
                      | r1_xreal_0(k7_xcmplx_0(D,B),k7_xcmplx_0(C,A)) ) ) ) ) ) ) ).

fof(t108_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(B,np__0)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k3_xcmplx_0(C,B))
                      & r1_xreal_0(k7_xcmplx_0(D,B),k7_xcmplx_0(C,A)) ) ) ) ) ) ).

fof(t109_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(np__0,A)
                      & ~ r1_xreal_0(np__0,B)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k3_xcmplx_0(C,B))
                      & r1_xreal_0(k7_xcmplx_0(D,B),k7_xcmplx_0(C,A)) ) ) ) ) ) ).

fof(t110_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(np__0,B)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k3_xcmplx_0(C,B))
                      & r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(D,B)) ) ) ) ) ) ).

fof(t111_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(np__0,A)
                      & ~ r1_xreal_0(B,np__0)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k3_xcmplx_0(C,B))
                      & r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(D,B)) ) ) ) ) ) ).

fof(t112_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(np__0,A)
                      & ~ r1_xreal_0(np__0,B)
                      & ~ r1_xreal_0(k7_xcmplx_0(D,B),k3_xcmplx_0(C,A))
                      & r1_xreal_0(k7_xcmplx_0(D,A),k3_xcmplx_0(C,B)) ) ) ) ) ) ).

fof(t113_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(B,np__0)
                      & ~ r1_xreal_0(k7_xcmplx_0(D,B),k3_xcmplx_0(C,A))
                      & r1_xreal_0(k7_xcmplx_0(D,A),k3_xcmplx_0(C,B)) ) ) ) ) ) ).

fof(t114_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(np__0,A)
                      & ~ r1_xreal_0(np__0,B)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k7_xcmplx_0(C,B))
                      & r1_xreal_0(k3_xcmplx_0(D,B),k7_xcmplx_0(C,A)) ) ) ) ) ) ).

fof(t115_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(B,np__0)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k7_xcmplx_0(C,B))
                      & r1_xreal_0(k3_xcmplx_0(D,B),k7_xcmplx_0(C,A)) ) ) ) ) ) ).

fof(t116_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(np__0,A)
                      & ~ r1_xreal_0(B,np__0)
                      & ~ r1_xreal_0(k7_xcmplx_0(D,B),k3_xcmplx_0(C,A))
                      & r1_xreal_0(k3_xcmplx_0(C,B),k7_xcmplx_0(D,A)) ) ) ) ) ) ).

fof(t117_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(np__0,B)
                      & ~ r1_xreal_0(k7_xcmplx_0(D,B),k3_xcmplx_0(C,A))
                      & r1_xreal_0(k3_xcmplx_0(C,B),k7_xcmplx_0(D,A)) ) ) ) ) ) ).

fof(t118_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(np__0,A)
                      & ~ r1_xreal_0(B,np__0)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k7_xcmplx_0(C,B))
                      & r1_xreal_0(k7_xcmplx_0(C,A),k3_xcmplx_0(D,B)) ) ) ) ) ) ).

fof(t119_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(np__0,B)
                      & ~ r1_xreal_0(k3_xcmplx_0(D,A),k7_xcmplx_0(C,B))
                      & r1_xreal_0(k7_xcmplx_0(C,A),k3_xcmplx_0(D,B)) ) ) ) ) ) ).

fof(t120_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,B)
                  & r1_xreal_0(A,C) )
               => ( r1_xreal_0(A,np__0)
                  | r1_xreal_0(k7_xcmplx_0(B,C),k7_xcmplx_0(B,A)) ) ) ) ) ) ).

fof(t121_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(C,B) )
               => ( r1_xreal_0(np__0,B)
                  | r1_xreal_0(k7_xcmplx_0(A,B),k7_xcmplx_0(A,C)) ) ) ) ) ) ).

fof(t122_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,np__0)
                  & r1_xreal_0(B,C) )
               => ( r1_xreal_0(B,np__0)
                  | r1_xreal_0(k7_xcmplx_0(A,B),k7_xcmplx_0(A,C)) ) ) ) ) ) ).

fof(t123_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,np__0)
                  & r1_xreal_0(C,B) )
               => ( r1_xreal_0(np__0,B)
                  | r1_xreal_0(k7_xcmplx_0(A,C),k7_xcmplx_0(A,B)) ) ) ) ) ) ).

fof(t124_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ ( ~ r1_xreal_0(A,np__0)
            & r1_xreal_0(k5_xcmplx_0(A),np__0) )
        & ~ ( ~ r1_xreal_0(k5_xcmplx_0(A),np__0)
            & r1_xreal_0(A,np__0) ) ) ) ).

fof(t125_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ ( ~ r1_xreal_0(np__0,A)
            & r1_xreal_0(np__0,k5_xcmplx_0(A)) )
        & ~ ( ~ r1_xreal_0(np__0,k5_xcmplx_0(A))
            & r1_xreal_0(np__0,A) ) ) ) ).

fof(t126_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,np__0)
              & r1_xreal_0(k5_xcmplx_0(B),k5_xcmplx_0(A)) ) ) ) ).

fof(t127_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,k5_xcmplx_0(A))
              & ~ r1_xreal_0(k5_xcmplx_0(B),np__0)
              & r1_xreal_0(B,A) ) ) ) ).

fof(t128_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(np__0,A) )
           => np__0 = k3_xcmplx_0(A,B) ) ) ) ).

fof(t129_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => r1_xreal_0(np__0,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t130_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(B,np__0) )
           => r1_xreal_0(np__0,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t131_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(B,np__0)
              & r1_xreal_0(k3_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t132_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(np__0,B)
              & r1_xreal_0(k3_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t133_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(B,np__0) )
           => r1_xreal_0(k3_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t134_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(np__0,B)
              & r1_xreal_0(np__0,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t135_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,k3_xcmplx_0(A,B))
              & ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(np__0,B) )
              & ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(B,np__0) ) ) ) ) ).

fof(t136_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(k3_xcmplx_0(A,B),np__0)
              & ~ ( ~ r1_xreal_0(A,np__0)
                  & ~ r1_xreal_0(B,np__0) )
              & ~ ( ~ r1_xreal_0(np__0,A)
                  & ~ r1_xreal_0(np__0,B) ) ) ) ) ).

fof(t137_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(B,np__0) )
           => r1_xreal_0(np__0,k7_xcmplx_0(A,B)) ) ) ) ).

fof(t138_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => r1_xreal_0(np__0,k7_xcmplx_0(A,B)) ) ) ) ).

fof(t139_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(B,np__0) )
           => r1_xreal_0(k7_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t140_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(np__0,B) )
           => r1_xreal_0(k7_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t141_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(B,np__0)
              & r1_xreal_0(k7_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t142_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(np__0,B)
              & r1_xreal_0(k7_xcmplx_0(A,B),np__0) ) ) ) ).

fof(t143_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,np__0)
              & r1_xreal_0(np__0,k7_xcmplx_0(A,B)) ) ) ) ).

fof(t144_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,np__0)
              & r1_xreal_0(np__0,k7_xcmplx_0(B,A)) ) ) ) ).

fof(t145_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,k7_xcmplx_0(A,B))
              & ~ ( ~ r1_xreal_0(np__0,B)
                  & ~ r1_xreal_0(A,np__0) )
              & ~ ( ~ r1_xreal_0(B,np__0)
                  & ~ r1_xreal_0(np__0,A) ) ) ) ) ).

fof(t146_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(k7_xcmplx_0(A,B),np__0)
              & ~ ( ~ r1_xreal_0(B,np__0)
                  & ~ r1_xreal_0(A,np__0) )
              & ~ ( ~ r1_xreal_0(np__0,B)
                  & ~ r1_xreal_0(np__0,A) ) ) ) ) ).

fof(t147_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(A,B)
              & r1_xreal_0(k2_xcmplx_0(B,np__1),A) ) ) ) ).

fof(t148_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ r1_xreal_0(A,k6_xcmplx_0(A,np__1)) ) ).

fof(t149_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(A,B)
              & r1_xreal_0(B,k6_xcmplx_0(A,np__1)) ) ) ) ).

fof(t150_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,k4_xcmplx_0(np__1))
          & r1_xreal_0(k2_xcmplx_0(np__1,A),np__0) ) ) ).

fof(t151_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(np__1,A)
          & r1_xreal_0(k6_xcmplx_0(np__1,A),np__0) ) ) ).

fof(t152_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(A,np__1)
              & r1_xreal_0(np__0,B)
              & r1_xreal_0(B,np__1)
              & k3_xcmplx_0(A,B) = np__1 )
           => A = np__1 ) ) ) ).

fof(t153_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__1,B) )
           => r1_xreal_0(A,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t154_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(B,np__1) )
           => r1_xreal_0(A,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t155_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(B,np__1) )
           => r1_xreal_0(k3_xcmplx_0(A,B),A) ) ) ) ).

fof(t156_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(np__1,B) )
           => r1_xreal_0(k3_xcmplx_0(A,B),A) ) ) ) ).

fof(t157_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(B,np__1)
              & r1_xreal_0(k3_xcmplx_0(A,B),A) ) ) ) ).

fof(t158_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(np__1,B)
              & r1_xreal_0(k3_xcmplx_0(A,B),A) ) ) ) ).

fof(t159_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(np__1,B)
              & r1_xreal_0(A,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t160_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,np__1)
              & r1_xreal_0(A,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t161_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__1,A)
              & r1_xreal_0(np__1,B) )
           => r1_xreal_0(np__1,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t162_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(A,np__1)
              & r1_xreal_0(np__0,B)
              & r1_xreal_0(B,np__1) )
           => r1_xreal_0(k3_xcmplx_0(A,B),np__1) ) ) ) ).

fof(t163_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__1)
              & r1_xreal_0(np__1,B)
              & r1_xreal_0(k3_xcmplx_0(A,B),np__1) ) ) ) ).

fof(t164_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(np__1,A)
              & r1_xreal_0(np__0,B)
              & r1_xreal_0(B,np__1)
              & r1_xreal_0(np__1,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t165_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,k4_xcmplx_0(np__1))
              & r1_xreal_0(B,k4_xcmplx_0(np__1)) )
           => r1_xreal_0(np__1,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t166_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(k4_xcmplx_0(np__1),A)
              & r1_xreal_0(B,k4_xcmplx_0(np__1))
              & r1_xreal_0(k3_xcmplx_0(A,B),np__1) ) ) ) ).

fof(t167_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(k4_xcmplx_0(np__1),A)
              & r1_xreal_0(B,np__0)
              & r1_xreal_0(k4_xcmplx_0(np__1),B) )
           => r1_xreal_0(k3_xcmplx_0(A,B),np__1) ) ) ) ).

fof(t168_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(A,k4_xcmplx_0(np__1))
              & r1_xreal_0(B,np__0)
              & r1_xreal_0(k4_xcmplx_0(np__1),B)
              & r1_xreal_0(np__1,k3_xcmplx_0(A,B)) ) ) ) ).

fof(t169_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ( ~ r1_xreal_0(C,np__1)
                 => r1_xreal_0(A,k3_xcmplx_0(B,C)) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t170_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ~ ( ~ r1_xreal_0(C,np__0)
                    & ~ r1_xreal_0(np__1,C)
                    & ~ r1_xreal_0(k3_xcmplx_0(A,C),B) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t171_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ~ ( ~ r1_xreal_0(C,np__0)
                    & ~ r1_xreal_0(np__1,C)
                    & ~ r1_xreal_0(A,k3_xcmplx_0(C,B)) ) )
           => r1_xreal_0(A,np__0) ) ) ) ).

fof(t172_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ~ ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(A,np__1)
                  & r1_xreal_0(np__0,B)
                  & r1_xreal_0(np__0,C)
                  & k2_xcmplx_0(k3_xcmplx_0(A,B),k3_xcmplx_0(k6_xcmplx_0(np__1,A),C)) = np__0
                  & ~ ( A = np__0
                      & C = np__0 )
                  & ~ ( A = np__1
                      & B = np__0 )
                  & ~ ( B = np__0
                      & C = np__0 ) ) ) ) ) ).

fof(t173_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(A,np__1)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(B,k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,C))) ) ) ) ) ).

fof(t174_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(A,np__1)
                  & r1_xreal_0(B,C) )
               => r1_xreal_0(k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,C)),C) ) ) ) ) ).

fof(t175_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( ( r1_xreal_0(np__0,A)
                      & r1_xreal_0(A,np__1)
                      & r1_xreal_0(B,C)
                      & r1_xreal_0(B,D) )
                   => r1_xreal_0(B,k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),C),k3_xcmplx_0(A,D))) ) ) ) ) ) ).

fof(t176_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( ( r1_xreal_0(np__0,A)
                      & r1_xreal_0(A,np__1)
                      & r1_xreal_0(B,C)
                      & r1_xreal_0(D,C) )
                   => r1_xreal_0(k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,D)),C) ) ) ) ) ) ).

fof(t177_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( r1_xreal_0(np__0,A)
                      & r1_xreal_0(A,np__1)
                      & ~ r1_xreal_0(C,B)
                      & ~ r1_xreal_0(D,B)
                      & r1_xreal_0(k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),C),k3_xcmplx_0(A,D)),B) ) ) ) ) ) ).

fof(t178_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( r1_xreal_0(np__0,A)
                      & r1_xreal_0(A,np__1)
                      & ~ r1_xreal_0(C,B)
                      & ~ r1_xreal_0(C,D)
                      & r1_xreal_0(C,k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,D))) ) ) ) ) ) ).

fof(t179_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(np__1,A)
                      & r1_xreal_0(B,C)
                      & ~ r1_xreal_0(D,B)
                      & r1_xreal_0(k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),C),k3_xcmplx_0(A,D)),B) ) ) ) ) ) ).

fof(t180_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ~ ( ~ r1_xreal_0(A,np__0)
                      & ~ r1_xreal_0(np__1,A)
                      & ~ r1_xreal_0(C,B)
                      & r1_xreal_0(D,C)
                      & r1_xreal_0(C,k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,D))) ) ) ) ) ) ).

fof(t181_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(A,np__1)
                  & r1_xreal_0(B,k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,C))) )
               => ( r1_xreal_0(k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,C)),C)
                  | A = np__0 ) ) ) ) ) ).

fof(t182_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(A,np__1)
                  & r1_xreal_0(k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,C)),B) )
               => ( r1_xreal_0(C,k2_xcmplx_0(k3_xcmplx_0(k6_xcmplx_0(np__1,A),B),k3_xcmplx_0(A,C)))
                  | A = np__0 ) ) ) ) ) ).

fof(t183_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
           => ( r1_xreal_0(A,np__0)
              | r1_xreal_0(np__1,k7_xcmplx_0(B,A)) ) ) ) ) ).

fof(t184_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(B,A)
           => ( r1_xreal_0(np__0,A)
              | r1_xreal_0(np__1,k7_xcmplx_0(B,A)) ) ) ) ) ).

fof(t185_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(A,B) )
           => r1_xreal_0(k7_xcmplx_0(A,B),np__1) ) ) ) ).

fof(t186_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,B)
              & r1_xreal_0(B,np__0) )
           => r1_xreal_0(k7_xcmplx_0(B,A),np__1) ) ) ) ).

fof(t187_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(B,A) )
           => r1_xreal_0(k7_xcmplx_0(B,A),np__1) ) ) ) ).

fof(t188_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(A,B) )
           => r1_xreal_0(k7_xcmplx_0(B,A),np__1) ) ) ) ).

fof(t189_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(B,A)
              & r1_xreal_0(k7_xcmplx_0(B,A),np__1) ) ) ) ).

fof(t190_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(A,B)
              & r1_xreal_0(k7_xcmplx_0(B,A),np__1) ) ) ) ).

fof(t191_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,A)
              & r1_xreal_0(np__1,k7_xcmplx_0(A,B)) ) ) ) ).

fof(t192_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(A,B)
              & r1_xreal_0(np__1,k7_xcmplx_0(A,B)) ) ) ) ).

fof(t193_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(A,B)
              & r1_xreal_0(np__1,k7_xcmplx_0(B,A)) ) ) ) ).

fof(t194_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,A)
              & r1_xreal_0(np__1,k7_xcmplx_0(B,A)) ) ) ) ).

fof(t195_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(k4_xcmplx_0(A),B) )
           => r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t196_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(k4_xcmplx_0(B),A) )
           => r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t197_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(B,k4_xcmplx_0(A)) )
           => r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t198_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,np__0)
              & r1_xreal_0(A,k4_xcmplx_0(B)) )
           => r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t199_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(B,k4_xcmplx_0(A))
              & r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ).

fof(t200_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(A,k4_xcmplx_0(B))
              & r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ).

fof(t201_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(k4_xcmplx_0(A),B)
              & r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ).

fof(t202_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(k4_xcmplx_0(B),A)
              & r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ).

fof(t203_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(B,k4_xcmplx_0(A))
           => ( r1_xreal_0(A,np__0)
              | r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ) ).

fof(t204_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,k4_xcmplx_0(B))
           => ( r1_xreal_0(A,np__0)
              | r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ) ).

fof(t205_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(k4_xcmplx_0(A),B)
           => ( r1_xreal_0(np__0,A)
              | r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ) ).

fof(t206_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(k4_xcmplx_0(B),A)
           => ( r1_xreal_0(np__0,A)
              | r1_xreal_0(k7_xcmplx_0(B,A),k4_xcmplx_0(np__1)) ) ) ) ) ).

fof(t207_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(k4_xcmplx_0(A),B)
              & r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t208_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & ~ r1_xreal_0(k4_xcmplx_0(B),A)
              & r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t209_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,k4_xcmplx_0(A))
              & r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t210_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(A,k4_xcmplx_0(B))
              & r1_xreal_0(k4_xcmplx_0(np__1),k7_xcmplx_0(B,A)) ) ) ) ).

fof(t211_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ~ ( ~ r1_xreal_0(C,np__0)
                    & ~ r1_xreal_0(np__1,C)
                    & ~ r1_xreal_0(A,k7_xcmplx_0(B,C)) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t212_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ! [C] :
                ( v1_xreal_0(C)
               => ( ~ r1_xreal_0(C,np__1)
                 => r1_xreal_0(k7_xcmplx_0(A,C),B) ) )
           => r1_xreal_0(A,B) ) ) ) ).

fof(t213_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(np__1,A)
       => r1_xreal_0(k5_xcmplx_0(A),np__1) ) ) ).

fof(t214_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__1)
          & r1_xreal_0(np__1,k5_xcmplx_0(A)) ) ) ).

fof(t215_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(A,k4_xcmplx_0(np__1))
       => r1_xreal_0(k4_xcmplx_0(np__1),k5_xcmplx_0(A)) ) ) ).

fof(t216_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(k4_xcmplx_0(np__1),A)
          & r1_xreal_0(k5_xcmplx_0(A),k4_xcmplx_0(np__1)) ) ) ).

fof(t217_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & r1_xreal_0(k7_xcmplx_0(A,np__2),np__0) ) ) ).

fof(t218_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & r1_xreal_0(A,k7_xcmplx_0(A,np__2)) ) ) ).

fof(t219_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(A,k7_xcmplx_0(np__1,np__2))
       => r1_xreal_0(k6_xcmplx_0(k3_xcmplx_0(np__2,A),np__1),np__0) ) ) ).

fof(t220_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(A,k7_xcmplx_0(np__1,np__2))
       => r1_xreal_0(np__0,k6_xcmplx_0(np__1,k3_xcmplx_0(np__2,A))) ) ) ).

fof(t221_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(k7_xcmplx_0(np__1,np__2),A)
       => r1_xreal_0(np__0,k6_xcmplx_0(k3_xcmplx_0(np__2,A),np__1)) ) ) ).

fof(t222_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(k7_xcmplx_0(np__1,np__2),A)
       => r1_xreal_0(k6_xcmplx_0(np__1,k3_xcmplx_0(np__2,A)),np__0) ) ) ).

fof(t223_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & r1_xreal_0(A,k7_xcmplx_0(A,np__3)) ) ) ).

fof(t224_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & r1_xreal_0(k7_xcmplx_0(A,np__3),np__0) ) ) ).

fof(t225_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & r1_xreal_0(A,k7_xcmplx_0(A,np__4)) ) ) ).

fof(t226_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & r1_xreal_0(k7_xcmplx_0(A,np__4),np__0) ) ) ).

fof(t227_xreal_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( B != np__0
              & ! [C] :
                  ( v1_xreal_0(C)
                 => A != k7_xcmplx_0(B,C) ) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_axioms,axiom,
    $true ).

fof(t2_axioms,axiom,
    $true ).

fof(t3_axioms,axiom,
    $true ).

fof(t4_axioms,axiom,
    $true ).

fof(t5_axioms,axiom,
    $true ).

fof(t6_axioms,axiom,
    $true ).

fof(t7_axioms,axiom,
    $true ).

fof(t8_axioms,axiom,
    $true ).

fof(t9_axioms,axiom,
    $true ).

fof(t10_axioms,axiom,
    $true ).

fof(t11_axioms,axiom,
    $true ).

fof(t12_axioms,axiom,
    $true ).

fof(t13_axioms,axiom,
    $true ).

fof(t14_axioms,axiom,
    $true ).

fof(t15_axioms,axiom,
    $true ).

fof(t16_axioms,axiom,
    $true ).

fof(t17_axioms,axiom,
    $true ).

fof(t18_axioms,axiom,
    $true ).

fof(t19_axioms,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ? [B] :
          ( v1_xreal_0(B)
          & k2_xcmplx_0(A,B) = np__0 ) ) ).

fof(t20_axioms,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( A != np__0
          & ! [B] :
              ( v1_xreal_0(B)
             => k3_xcmplx_0(A,B) != np__1 ) ) ) ).

fof(t21_axioms,axiom,
    $true ).

fof(t22_axioms,axiom,
    $true ).

fof(t23_axioms,axiom,
    $true ).

fof(t24_axioms,axiom,
    $true ).

fof(t25_axioms,axiom,
    $true ).

fof(t26_axioms,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k1_numbers))
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_numbers))
         => ~ ( ! [C] :
                  ( v1_xreal_0(C)
                 => ! [D] :
                      ( v1_xreal_0(D)
                     => ( ( r2_hidden(C,A)
                          & r2_hidden(D,B) )
                       => r1_xreal_0(C,D) ) ) )
              & ! [C] :
                  ( v1_xreal_0(C)
                 => ? [D] :
                      ( v1_xreal_0(D)
                      & ? [E] :
                          ( v1_xreal_0(E)
                          & r2_hidden(D,A)
                          & r2_hidden(E,B)
                          & ~ ( r1_xreal_0(D,C)
                              & r1_xreal_0(C,E) ) ) ) ) ) ) ) ).

fof(t27_axioms,axiom,
    $true ).

fof(t28_axioms,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r2_hidden(A,k5_numbers)
              & r2_hidden(B,k5_numbers) )
           => r2_hidden(k2_xcmplx_0(A,B),k5_numbers) ) ) ) ).

fof(t29_axioms,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k1_numbers))
     => ( ( r2_hidden(np__0,A)
          & ! [B] :
              ( v1_xreal_0(B)
             => ( r2_hidden(B,A)
               => r2_hidden(k2_xcmplx_0(B,np__1),A) ) ) )
       => r1_tarski(k5_numbers,A) ) ) ).

fof(t30_axioms,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => A = a_1_0_axioms(A) ) ).

fof(fraenkel_a_1_0_axioms,axiom,
    ! [A,B] :
      ( v4_ordinal2(B)
     => ( r2_hidden(A,a_1_0_axioms(B))
      <=> ? [C] :
            ( m2_subset_1(C,k1_numbers,k5_numbers)
            & A = C
            & ~ r1_xreal_0(B,C) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_real_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => ( v1_xreal_0(A)
        & v1_xcmplx_0(A) ) ) ).

fof(t1_real_1,axiom,
    $true ).

fof(t2_real_1,axiom,
    $true ).

fof(t3_real_1,axiom,
    $true ).

fof(t4_real_1,axiom,
    $true ).

fof(t5_real_1,axiom,
    $true ).

fof(t6_real_1,axiom,
    $true ).

fof(t7_real_1,axiom,
    $true ).

fof(t8_real_1,axiom,
    $true ).

fof(t9_real_1,axiom,
    $true ).

fof(t10_real_1,axiom,
    $true ).

fof(t11_real_1,axiom,
    $true ).

fof(t12_real_1,axiom,
    $true ).

fof(t13_real_1,axiom,
    $true ).

fof(t14_real_1,axiom,
    $true ).

fof(t15_real_1,axiom,
    $true ).

fof(t16_real_1,axiom,
    $true ).

fof(t17_real_1,axiom,
    $true ).

fof(t18_real_1,axiom,
    $true ).

fof(t19_real_1,axiom,
    $true ).

fof(t20_real_1,axiom,
    $true ).

fof(t21_real_1,axiom,
    $true ).

fof(t22_real_1,axiom,
    $true ).

fof(t23_real_1,axiom,
    $true ).

fof(t24_real_1,axiom,
    $true ).

fof(t25_real_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k6_xcmplx_0(A,np__0) = A ) ).

fof(t26_real_1,axiom,
    k1_real_1(np__0) = np__0 ).

fof(d1_real_1,axiom,
    $true ).

fof(d2_real_1,axiom,
    $true ).

fof(d3_real_1,axiom,
    $true ).

fof(d4_real_1,axiom,
    $true ).

fof(d5_real_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
          <=> ~ ( r1_xreal_0(B,A)
                & B != A ) ) ) ) ).

fof(t27_real_1,axiom,
    $true ).

fof(t28_real_1,axiom,
    $true ).

fof(t29_real_1,axiom,
    $true ).

fof(t30_real_1,axiom,
    $true ).

fof(t31_real_1,axiom,
    $true ).

fof(t32_real_1,axiom,
    $true ).

fof(t33_real_1,axiom,
    $true ).

fof(t34_real_1,axiom,
    $true ).

fof(t35_real_1,axiom,
    $true ).

fof(t36_real_1,axiom,
    $true ).

fof(t37_real_1,axiom,
    $true ).

fof(t38_real_1,axiom,
    $true ).

fof(t39_real_1,axiom,
    $true ).

fof(t40_real_1,axiom,
    $true ).

fof(t41_real_1,axiom,
    $true ).

fof(t42_real_1,axiom,
    $true ).

fof(t43_real_1,axiom,
    $true ).

fof(t44_real_1,axiom,
    $true ).

fof(t45_real_1,axiom,
    $true ).

fof(t46_real_1,axiom,
    $true ).

fof(t47_real_1,axiom,
    $true ).

fof(t48_real_1,axiom,
    $true ).

fof(t49_real_1,axiom,
    $true ).

fof(t50_real_1,axiom,
    $true ).

fof(t51_real_1,axiom,
    $true ).

fof(t52_real_1,axiom,
    $true ).

fof(t53_real_1,axiom,
    $true ).

fof(t54_real_1,axiom,
    $true ).

fof(t55_real_1,axiom,
    $true ).

fof(t56_real_1,axiom,
    $true ).

fof(t57_real_1,axiom,
    $true ).

fof(t58_real_1,axiom,
    $true ).

fof(t59_real_1,axiom,
    $true ).

fof(t60_real_1,axiom,
    $true ).

fof(t61_real_1,axiom,
    $true ).

fof(t62_real_1,axiom,
    $true ).

fof(t63_real_1,axiom,
    $true ).

fof(t64_real_1,axiom,
    $true ).

fof(t65_real_1,axiom,
    $true ).

fof(t66_real_1,axiom,
    $true ).

fof(t67_real_1,axiom,
    $true ).

fof(t68_real_1,axiom,
    $true ).

fof(t69_real_1,axiom,
    $true ).

fof(t70_real_1,axiom,
    $true ).

fof(t71_real_1,axiom,
    $true ).

fof(t72_real_1,axiom,
    $true ).

fof(t73_real_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ~ r1_xreal_0(A,np__0)
               => ( ~ ( ~ r1_xreal_0(C,B)
                      & r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(B,A)) )
                  & ~ ( ~ r1_xreal_0(k7_xcmplx_0(C,A),k7_xcmplx_0(B,A))
                      & r1_xreal_0(C,B) ) ) ) ) ) ) ).

fof(t74_real_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ~ r1_xreal_0(np__0,A)
               => ( ~ ( ~ r1_xreal_0(C,B)
                      & r1_xreal_0(k7_xcmplx_0(B,A),k7_xcmplx_0(C,A)) )
                  & ~ ( ~ r1_xreal_0(k7_xcmplx_0(B,A),k7_xcmplx_0(C,A))
                      & r1_xreal_0(C,B) ) ) ) ) ) ) ).

fof(t75_real_1,axiom,
    $true ).

fof(t76_real_1,axiom,
    $true ).

fof(t77_real_1,axiom,
    $true ).

fof(t78_real_1,axiom,
    $true ).

fof(t79_real_1,axiom,
    $true ).

fof(t80_real_1,axiom,
    $true ).

fof(t81_real_1,axiom,
    $true ).

fof(t82_real_1,axiom,
    $true ).

fof(t83_real_1,axiom,
    $true ).

fof(t84_real_1,axiom,
    $true ).

fof(t85_real_1,axiom,
    $true ).

fof(t86_real_1,axiom,
    $true ).

fof(t87_real_1,axiom,
    $true ).

fof(t88_real_1,axiom,
    $true ).

fof(t89_real_1,axiom,
    $true ).

fof(t90_real_1,axiom,
    $true ).

fof(t91_real_1,axiom,
    $true ).

fof(t92_real_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ! [D] :
                  ( v1_xreal_0(D)
                 => ( ( ( r1_xreal_0(A,B)
                        & r1_xreal_0(C,D) )
                     => r1_xreal_0(k6_xcmplx_0(A,D),k6_xcmplx_0(B,C)) )
                    & ~ ( ( ( ~ r1_xreal_0(B,A)
                            & r1_xreal_0(C,D) )
                          | ( r1_xreal_0(A,B)
                            & ~ r1_xreal_0(D,C) ) )
                        & r1_xreal_0(k6_xcmplx_0(B,C),k6_xcmplx_0(A,D)) ) ) ) ) ) ) ).

fof(s1_real_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k1_numbers))
      & ! [B] :
          ( m1_subset_1(B,k1_numbers)
         => ( r2_hidden(B,A)
          <=> p1_s1_real_1(B) ) ) ) ).

fof(dt_k1_real_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k1_real_1(A),k1_numbers) ) ).

fof(involutiveness_k1_real_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k1_real_1(k1_real_1(A)) = A ) ).

fof(redefinition_k1_real_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k1_real_1(A) = k4_xcmplx_0(A) ) ).

fof(dt_k2_real_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k2_real_1(A),k1_numbers) ) ).

fof(involutiveness_k2_real_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k2_real_1(k2_real_1(A)) = A ) ).

fof(redefinition_k2_real_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k2_real_1(A) = k5_xcmplx_0(A) ) ).

fof(dt_k3_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k3_real_1(A,B),k1_numbers) ) ).

fof(commutativity_k3_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k3_real_1(A,B) = k3_real_1(B,A) ) ).

fof(redefinition_k3_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k3_real_1(A,B) = k2_xcmplx_0(A,B) ) ).

fof(dt_k4_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k4_real_1(A,B),k1_numbers) ) ).

fof(commutativity_k4_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k4_real_1(A,B) = k4_real_1(B,A) ) ).

fof(redefinition_k4_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k4_real_1(A,B) = k3_xcmplx_0(A,B) ) ).

fof(dt_k5_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k5_real_1(A,B),k1_numbers) ) ).

fof(redefinition_k5_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k5_real_1(A,B) = k6_xcmplx_0(A,B) ) ).

fof(dt_k6_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k6_real_1(A,B),k1_numbers) ) ).

fof(redefinition_k6_real_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k6_real_1(A,B) = k7_xcmplx_0(A,B) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_square_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => v1_xcmplx_0(A) ) ).

fof(fc1_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => v1_xcmplx_0(k5_square_1(A)) ) ).

fof(fc2_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( v1_xcmplx_0(k5_square_1(A))
        & v1_xreal_0(k5_square_1(A)) ) ) ).

fof(t1_square_1,axiom,
    $true ).

fof(t2_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__1)
          & r1_xreal_0(np__1,k7_xcmplx_0(np__1,A)) ) ) ).

fof(t3_square_1,axiom,
    $true ).

fof(t4_square_1,axiom,
    $true ).

fof(t5_square_1,axiom,
    $true ).

fof(t6_square_1,axiom,
    $true ).

fof(t7_square_1,axiom,
    $true ).

fof(t8_square_1,axiom,
    $true ).

fof(t9_square_1,axiom,
    $true ).

fof(t10_square_1,axiom,
    $true ).

fof(t11_square_1,axiom,
    $true ).

fof(t12_square_1,axiom,
    $true ).

fof(t13_square_1,axiom,
    $true ).

fof(t14_square_1,axiom,
    $true ).

fof(t15_square_1,axiom,
    $true ).

fof(t16_square_1,axiom,
    $true ).

fof(t17_square_1,axiom,
    $true ).

fof(t18_square_1,axiom,
    $true ).

fof(t19_square_1,axiom,
    $true ).

fof(t20_square_1,axiom,
    $true ).

fof(t21_square_1,axiom,
    $true ).

fof(t22_square_1,axiom,
    $true ).

fof(t23_square_1,axiom,
    $true ).

fof(t24_square_1,axiom,
    $true ).

fof(t25_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(np__0,k3_xcmplx_0(A,B))
              & ~ ( r1_xreal_0(np__0,A)
                  & r1_xreal_0(np__0,B) )
              & ~ ( r1_xreal_0(A,np__0)
                  & r1_xreal_0(B,np__0) ) ) ) ) ).

fof(d1_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(A,B)
             => k1_square_1(A,B) = A )
            & ( ~ r1_xreal_0(A,B)
             => k1_square_1(A,B) = B ) ) ) ) ).

fof(d2_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(B,A)
             => k2_square_1(A,B) = A )
            & ( ~ r1_xreal_0(B,A)
             => k2_square_1(A,B) = B ) ) ) ) ).

fof(t26_square_1,axiom,
    $true ).

fof(t27_square_1,axiom,
    $true ).

fof(t28_square_1,axiom,
    $true ).

fof(t29_square_1,axiom,
    $true ).

fof(t30_square_1,axiom,
    $true ).

fof(t31_square_1,axiom,
    $true ).

fof(t32_square_1,axiom,
    $true ).

fof(t33_square_1,axiom,
    $true ).

fof(t34_square_1,axiom,
    $true ).

fof(t35_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => r1_xreal_0(k1_square_1(A,B),A) ) ) ).

fof(t36_square_1,axiom,
    $true ).

fof(t37_square_1,axiom,
    $true ).

fof(t38_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( k1_square_1(A,B) = A
            | k1_square_1(A,B) = B ) ) ) ).

fof(t39_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,B)
                  & r1_xreal_0(A,C) )
              <=> r1_xreal_0(A,k1_square_1(B,C)) ) ) ) ) ).

fof(t40_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => k1_square_1(A,k1_square_1(B,C)) = k1_square_1(k1_square_1(A,B),C) ) ) ) ).

fof(t41_square_1,axiom,
    $true ).

fof(t42_square_1,axiom,
    $true ).

fof(t43_square_1,axiom,
    $true ).

fof(t44_square_1,axiom,
    $true ).

fof(t45_square_1,axiom,
    $true ).

fof(t46_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => r1_xreal_0(A,k2_square_1(A,B)) ) ) ).

fof(t47_square_1,axiom,
    $true ).

fof(t48_square_1,axiom,
    $true ).

fof(t49_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( k2_square_1(A,B) = A
            | k2_square_1(A,B) = B ) ) ) ).

fof(t50_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => ( ( r1_xreal_0(A,B)
                  & r1_xreal_0(C,B) )
              <=> r1_xreal_0(k2_square_1(A,C),B) ) ) ) ) ).

fof(t51_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => k2_square_1(A,k2_square_1(B,C)) = k2_square_1(k2_square_1(A,B),C) ) ) ) ).

fof(t52_square_1,axiom,
    $true ).

fof(t53_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => k2_xcmplx_0(k1_square_1(A,B),k2_square_1(A,B)) = k2_xcmplx_0(A,B) ) ) ).

fof(t54_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => k2_square_1(A,k1_square_1(A,B)) = A ) ) ).

fof(t55_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => k1_square_1(A,k2_square_1(A,B)) = A ) ) ).

fof(t56_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => k1_square_1(A,k2_square_1(B,C)) = k2_square_1(k1_square_1(A,B),k1_square_1(A,C)) ) ) ) ).

fof(t57_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ! [C] :
              ( v1_xreal_0(C)
             => k2_square_1(A,k1_square_1(B,C)) = k1_square_1(k2_square_1(A,B),k2_square_1(A,C)) ) ) ) ).

fof(d3_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k5_square_1(A) = k3_xcmplx_0(A,A) ) ).

fof(t58_square_1,axiom,
    $true ).

fof(t59_square_1,axiom,
    k7_square_1(np__1) = np__1 ).

fof(t60_square_1,axiom,
    k7_square_1(np__0) = np__0 ).

fof(t61_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k5_square_1(A) = k5_square_1(k4_xcmplx_0(A)) ) ).

fof(t62_square_1,axiom,
    $true ).

fof(t63_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k5_square_1(k2_xcmplx_0(A,B)) = k2_xcmplx_0(k2_xcmplx_0(k5_square_1(A),k3_xcmplx_0(k3_xcmplx_0(np__2,A),B)),k5_square_1(B)) ) ) ).

fof(t64_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k5_square_1(k6_xcmplx_0(A,B)) = k2_xcmplx_0(k6_xcmplx_0(k5_square_1(A),k3_xcmplx_0(k3_xcmplx_0(np__2,A),B)),k5_square_1(B)) ) ) ).

fof(t65_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k5_square_1(k2_xcmplx_0(A,np__1)) = k2_xcmplx_0(k2_xcmplx_0(k5_square_1(A),k3_xcmplx_0(np__2,A)),np__1) ) ).

fof(t66_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => k5_square_1(k6_xcmplx_0(A,np__1)) = k2_xcmplx_0(k6_xcmplx_0(k5_square_1(A),k3_xcmplx_0(np__2,A)),np__1) ) ).

fof(t67_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k3_xcmplx_0(k6_xcmplx_0(A,B),k2_xcmplx_0(A,B)) = k6_xcmplx_0(k5_square_1(A),k5_square_1(B)) ) ) ).

fof(t68_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k5_square_1(k3_xcmplx_0(A,B)) = k3_xcmplx_0(k5_square_1(A),k5_square_1(B)) ) ) ).

fof(t69_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => k5_square_1(k7_xcmplx_0(A,B)) = k7_xcmplx_0(k5_square_1(A),k5_square_1(B)) ) ) ).

fof(t70_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k6_xcmplx_0(k5_square_1(A),k5_square_1(B)) != np__0
           => k7_xcmplx_0(np__1,k2_xcmplx_0(A,B)) = k7_xcmplx_0(k6_xcmplx_0(A,B),k6_xcmplx_0(k5_square_1(A),k5_square_1(B))) ) ) ) ).

fof(t71_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ! [B] :
          ( v1_xcmplx_0(B)
         => ( k6_xcmplx_0(k5_square_1(A),k5_square_1(B)) != np__0
           => k7_xcmplx_0(np__1,k6_xcmplx_0(A,B)) = k7_xcmplx_0(k2_xcmplx_0(A,B),k6_xcmplx_0(k5_square_1(A),k5_square_1(B))) ) ) ) ).

fof(t72_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => r1_xreal_0(np__0,k5_square_1(A)) ) ).

fof(t73_square_1,axiom,
    ! [A] :
      ( v1_xcmplx_0(A)
     => ( k5_square_1(A) = np__0
       => A = np__0 ) ) ).

fof(t74_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( np__0 != A
          & r1_xreal_0(k5_square_1(A),np__0) ) ) ).

fof(t75_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & ~ r1_xreal_0(np__1,A)
          & r1_xreal_0(A,k5_square_1(A)) ) ) ).

fof(t76_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__1)
          & r1_xreal_0(k5_square_1(A),A) ) ) ).

fof(t77_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(A,B) )
           => r1_xreal_0(k5_square_1(A),k5_square_1(B)) ) ) ) ).

fof(t78_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,A)
              & r1_xreal_0(k5_square_1(B),k5_square_1(A)) ) ) ) ).

fof(d4_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(np__0,A)
       => ! [B] :
            ( v1_xreal_0(B)
           => ( B = k8_square_1(A)
            <=> ( r1_xreal_0(np__0,B)
                & k5_square_1(B) = A ) ) ) ) ) ).

fof(t79_square_1,axiom,
    $true ).

fof(t80_square_1,axiom,
    $true ).

fof(t81_square_1,axiom,
    $true ).

fof(t82_square_1,axiom,
    k9_square_1(np__0) = np__0 ).

fof(t83_square_1,axiom,
    k9_square_1(np__1) = np__1 ).

fof(t84_square_1,axiom,
    ~ r1_xreal_0(k9_square_1(np__2),np__1) ).

fof(t85_square_1,axiom,
    k9_square_1(np__4) = np__2 ).

fof(t86_square_1,axiom,
    ~ r1_xreal_0(np__2,k9_square_1(np__2)) ).

fof(t87_square_1,axiom,
    $true ).

fof(t88_square_1,axiom,
    $true ).

fof(t89_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(np__0,A)
       => k8_square_1(k5_square_1(A)) = A ) ) ).

fof(t90_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(A,np__0)
       => k8_square_1(k5_square_1(A)) = k4_xcmplx_0(A) ) ) ).

fof(t91_square_1,axiom,
    $true ).

fof(t92_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ( r1_xreal_0(np__0,A)
          & k8_square_1(A) = np__0 )
       => A = np__0 ) ) ).

fof(t93_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( ~ r1_xreal_0(A,np__0)
          & r1_xreal_0(k8_square_1(A),np__0) ) ) ).

fof(t94_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(A,B) )
           => r1_xreal_0(k8_square_1(A),k8_square_1(B)) ) ) ) ).

fof(t95_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( r1_xreal_0(np__0,A)
              & ~ r1_xreal_0(B,A)
              & r1_xreal_0(k8_square_1(B),k8_square_1(A)) ) ) ) ).

fof(t96_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B)
              & k8_square_1(A) = k8_square_1(B) )
           => A = B ) ) ) ).

fof(t97_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => k8_square_1(k3_xcmplx_0(A,B)) = k3_xcmplx_0(k8_square_1(A),k8_square_1(B)) ) ) ) ).

fof(t98_square_1,axiom,
    $true ).

fof(t99_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => k8_square_1(k7_xcmplx_0(A,B)) = k7_xcmplx_0(k8_square_1(A),k8_square_1(B)) ) ) ) ).

fof(t100_square_1,axiom,
    $true ).

fof(t101_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ r1_xreal_0(A,np__0)
       => k8_square_1(k7_xcmplx_0(np__1,A)) = k7_xcmplx_0(np__1,k8_square_1(A)) ) ) ).

fof(t102_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ r1_xreal_0(A,np__0)
       => k7_xcmplx_0(k8_square_1(A),A) = k7_xcmplx_0(np__1,k8_square_1(A)) ) ) ).

fof(t103_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ r1_xreal_0(A,np__0)
       => k7_xcmplx_0(A,k8_square_1(A)) = k8_square_1(A) ) ) ).

fof(t104_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => k3_xcmplx_0(k6_xcmplx_0(k8_square_1(A),k8_square_1(B)),k2_xcmplx_0(k8_square_1(A),k8_square_1(B))) = k6_xcmplx_0(A,B) ) ) ) ).

fof(t105_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => ( A = B
              | k7_xcmplx_0(np__1,k2_xcmplx_0(k8_square_1(A),k8_square_1(B))) = k7_xcmplx_0(k6_xcmplx_0(k8_square_1(A),k8_square_1(B)),k6_xcmplx_0(A,B)) ) ) ) ) ).

fof(t106_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(np__0,A)
           => ( r1_xreal_0(B,A)
              | k7_xcmplx_0(np__1,k2_xcmplx_0(k8_square_1(B),k8_square_1(A))) = k7_xcmplx_0(k6_xcmplx_0(k8_square_1(B),k8_square_1(A)),k6_xcmplx_0(B,A)) ) ) ) ) ).

fof(t107_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( ( r1_xreal_0(np__0,A)
              & r1_xreal_0(np__0,B) )
           => k7_xcmplx_0(np__1,k6_xcmplx_0(k8_square_1(A),k8_square_1(B))) = k7_xcmplx_0(k2_xcmplx_0(k8_square_1(A),k8_square_1(B)),k6_xcmplx_0(A,B)) ) ) ) ).

fof(t108_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(np__0,A)
           => ( r1_xreal_0(B,A)
              | k7_xcmplx_0(np__1,k6_xcmplx_0(k8_square_1(B),k8_square_1(A))) = k7_xcmplx_0(k2_xcmplx_0(k8_square_1(B),k8_square_1(A)),k6_xcmplx_0(B,A)) ) ) ) ) ).

fof(s1_square_1,axiom,
    ( ! [A] :
        ( v1_xreal_0(A)
       => ! [B] :
            ( v1_xreal_0(B)
           => ( ( p1_s1_square_1(A)
                & p2_s1_square_1(B) )
             => r1_xreal_0(A,B) ) ) )
   => ? [A] :
        ( v1_xreal_0(A)
        & ! [B] :
            ( v1_xreal_0(B)
           => ! [C] :
                ( v1_xreal_0(C)
               => ( ( p1_s1_square_1(B)
                    & p2_s1_square_1(C) )
                 => ( r1_xreal_0(B,A)
                    & r1_xreal_0(A,C) ) ) ) ) ) ) ).

fof(dt_k1_square_1,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => v1_xreal_0(k1_square_1(A,B)) ) ).

fof(commutativity_k1_square_1,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => k1_square_1(A,B) = k1_square_1(B,A) ) ).

fof(idempotence_k1_square_1,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => k1_square_1(A,A) = A ) ).

fof(dt_k2_square_1,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => v1_xreal_0(k2_square_1(A,B)) ) ).

fof(commutativity_k2_square_1,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => k2_square_1(A,B) = k2_square_1(B,A) ) ).

fof(idempotence_k2_square_1,axiom,
    ! [A,B] :
      ( ( v1_xreal_0(A)
        & v1_xreal_0(B) )
     => k2_square_1(A,A) = A ) ).

fof(dt_k3_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k3_square_1(A,B),k1_numbers) ) ).

fof(commutativity_k3_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k3_square_1(A,B) = k3_square_1(B,A) ) ).

fof(idempotence_k3_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k3_square_1(A,A) = A ) ).

fof(redefinition_k3_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k3_square_1(A,B) = k1_square_1(A,B) ) ).

fof(dt_k4_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k4_square_1(A,B),k1_numbers) ) ).

fof(commutativity_k4_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k4_square_1(A,B) = k4_square_1(B,A) ) ).

fof(idempotence_k4_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k4_square_1(A,A) = A ) ).

fof(redefinition_k4_square_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k4_square_1(A,B) = k2_square_1(A,B) ) ).

fof(dt_k5_square_1,axiom,
    $true ).

fof(dt_k6_square_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => m1_subset_1(k6_square_1(A),k2_numbers) ) ).

fof(redefinition_k6_square_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => k6_square_1(A) = k5_square_1(A) ) ).

fof(dt_k7_square_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k7_square_1(A),k1_numbers) ) ).

fof(redefinition_k7_square_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k7_square_1(A) = k5_square_1(A) ) ).

fof(dt_k8_square_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => v1_xreal_0(k8_square_1(A)) ) ).

fof(dt_k9_square_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k9_square_1(A),k1_numbers) ) ).

fof(redefinition_k9_square_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k9_square_1(A) = k8_square_1(A) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_nat_1,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & v4_ordinal2(B) )
     => ( v4_ordinal2(k2_xcmplx_0(A,B))
        & v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B)) ) ) ).

fof(fc2_nat_1,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & v4_ordinal2(B) )
     => ( v4_ordinal2(k3_xcmplx_0(A,B))
        & v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B)) ) ) ).

fof(rc1_nat_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v4_ordinal2(A)
      & v1_xcmplx_0(A)
      & v1_xreal_0(A) ) ).

fof(fc3_nat_1,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & ~ v1_xboole_0(B)
        & v4_ordinal2(B) )
     => ( ~ v1_xboole_0(k2_xcmplx_0(A,B))
        & v4_ordinal2(k2_xcmplx_0(A,B))
        & v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B)) ) ) ).

fof(fc4_nat_1,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & ~ v1_xboole_0(B)
        & v4_ordinal2(B) )
     => ( ~ v1_xboole_0(k2_xcmplx_0(B,A))
        & v4_ordinal2(k2_xcmplx_0(B,A))
        & v1_xcmplx_0(k2_xcmplx_0(B,A))
        & v1_xreal_0(k2_xcmplx_0(B,A)) ) ) ).

fof(cc1_nat_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_numbers)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A)
        & v4_ordinal2(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A) ) ) ).

fof(rc2_nat_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k1_numbers))
      & ~ v1_xboole_0(A)
      & v3_ordinal1(A) ) ).

fof(rc3_nat_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k5_numbers)
      & ~ v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A)
      & v4_ordinal2(A)
      & v1_xcmplx_0(A)
      & v1_xreal_0(A) ) ).

fof(cc2_nat_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_numbers)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A)
        & v4_ordinal2(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & ~ v3_xreal_0(A) ) ) ).

fof(cc3_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ( v4_ordinal2(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & ~ v3_xreal_0(A) ) ) ).

fof(t1_nat_1,axiom,
    $true ).

fof(t2_nat_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k1_numbers))
     => ( ( r2_hidden(np__0,A)
          & ! [B] :
              ( m1_subset_1(B,k1_numbers)
             => ( r2_hidden(B,A)
               => r2_hidden(k3_real_1(B,np__1),A) ) ) )
       => ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => r2_hidden(B,A) ) ) ) ).

fof(t3_nat_1,axiom,
    $true ).

fof(t4_nat_1,axiom,
    $true ).

fof(t5_nat_1,axiom,
    $true ).

fof(t6_nat_1,axiom,
    $true ).

fof(t7_nat_1,axiom,
    $true ).

fof(t8_nat_1,axiom,
    $true ).

fof(t9_nat_1,axiom,
    $true ).

fof(t10_nat_1,axiom,
    $true ).

fof(t11_nat_1,axiom,
    $true ).

fof(t12_nat_1,axiom,
    $true ).

fof(t13_nat_1,axiom,
    $true ).

fof(t14_nat_1,axiom,
    $true ).

fof(t15_nat_1,axiom,
    $true ).

fof(t16_nat_1,axiom,
    $true ).

fof(t17_nat_1,axiom,
    $true ).

fof(t18_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => r1_xreal_0(np__0,A) ) ).

fof(t19_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ~ ( np__0 != A
          & r1_xreal_0(A,np__0) ) ) ).

fof(t20_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( r1_xreal_0(A,B)
               => r1_xreal_0(k3_xcmplx_0(A,C),k3_xcmplx_0(B,C)) ) ) ) ) ).

fof(t21_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ~ r1_xreal_0(k2_xcmplx_0(A,np__1),np__0) ) ).

fof(t22_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ~ ( A != np__0
          & ! [B] :
              ( m2_subset_1(B,k1_numbers,k5_numbers)
             => A != k1_nat_1(B,np__1) ) ) ) ).

fof(t23_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( k2_xcmplx_0(A,B) = np__0
           => ( A = np__0
              & B = np__0 ) ) ) ) ).

fof(t24_nat_1,axiom,
    $true ).

fof(t25_nat_1,axiom,
    $true ).

fof(t26_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ~ ( r1_xreal_0(A,k2_xcmplx_0(B,np__1))
              & ~ r1_xreal_0(A,B)
              & A != k2_xcmplx_0(B,np__1) ) ) ) ).

fof(t27_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ~ ( r1_xreal_0(A,B)
              & r1_xreal_0(B,k2_xcmplx_0(A,np__1))
              & A != B
              & B != k2_xcmplx_0(A,np__1) ) ) ) ).

fof(t28_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ~ ( r1_xreal_0(A,B)
              & ! [C] :
                  ( m2_subset_1(C,k1_numbers,k5_numbers)
                 => B != k2_xcmplx_0(A,C) ) ) ) ) ).

fof(t29_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => r1_xreal_0(A,k2_xcmplx_0(A,B)) ) ) ).

fof(t30_nat_1,axiom,
    $true ).

fof(t31_nat_1,axiom,
    $true ).

fof(t32_nat_1,axiom,
    $true ).

fof(t33_nat_1,axiom,
    $true ).

fof(t34_nat_1,axiom,
    $true ).

fof(t35_nat_1,axiom,
    $true ).

fof(t36_nat_1,axiom,
    $true ).

fof(t37_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( r1_xreal_0(A,B)
               => r1_xreal_0(A,k2_xcmplx_0(B,C)) ) ) ) ) ).

fof(t38_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ~ r1_xreal_0(k2_xcmplx_0(B,np__1),A)
          <=> r1_xreal_0(A,B) ) ) ) ).

fof(t39_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ( ~ r1_xreal_0(np__1,A)
       => A = np__0 ) ) ).

fof(t40_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( k3_xcmplx_0(A,B) = np__1
           => ( A = np__1
              & B = np__1 ) ) ) ) ).

fof(t41_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ~ ( A != np__0
              & r1_xreal_0(k2_xcmplx_0(B,A),B) ) ) ) ).

fof(t42_nat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ( ~ r1_xreal_0(A,np__0)
       => ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ? [C] :
                ( m2_subset_1(C,k1_numbers,k5_numbers)
                & ? [D] :
                    ( m2_subset_1(D,k1_numbers,k5_numbers)
                    & B = k1_nat_1(k2_nat_1(A,C),D)
                    & ~ r1_xreal_0(A,D) ) ) ) ) ) ).

fof(t43_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ! [D] :
                  ( v4_ordinal2(D)
                 => ! [E] :
                      ( v4_ordinal2(E)
                     => ! [F] :
                          ( v4_ordinal2(F)
                         => ( ( A = k2_xcmplx_0(k3_xcmplx_0(B,C),E)
                              & A = k2_xcmplx_0(k3_xcmplx_0(B,D),F) )
                           => ( r1_xreal_0(B,E)
                              | r1_xreal_0(B,F)
                              | ( C = D
                                & E = F ) ) ) ) ) ) ) ) ) ).

fof(d1_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( C = k3_nat_1(A,B)
              <=> ~ ( ! [D] :
                        ( m2_subset_1(D,k1_numbers,k5_numbers)
                       => ~ ( A = k2_xcmplx_0(k3_xcmplx_0(B,C),D)
                            & ~ r1_xreal_0(B,D) ) )
                    & ~ ( C = np__0
                        & B = np__0 ) ) ) ) ) ) ).

fof(d2_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( C = k4_nat_1(A,B)
              <=> ~ ( ! [D] :
                        ( m2_subset_1(D,k1_numbers,k5_numbers)
                       => ~ ( A = k2_xcmplx_0(k3_xcmplx_0(B,D),C)
                            & ~ r1_xreal_0(B,C) ) )
                    & ~ ( C = np__0
                        & B = np__0 ) ) ) ) ) ) ).

fof(t44_nat_1,axiom,
    $true ).

fof(t45_nat_1,axiom,
    $true ).

fof(t46_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ~ ( ~ r1_xreal_0(A,np__0)
              & r1_xreal_0(A,k4_nat_1(B,A)) ) ) ) ).

fof(t47_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ~ r1_xreal_0(A,np__0)
           => B = k2_xcmplx_0(k3_xcmplx_0(A,k3_nat_1(B,A)),k4_nat_1(B,A)) ) ) ) ).

fof(d3_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( r1_nat_1(A,B)
          <=> ? [C] :
                ( m2_subset_1(C,k1_numbers,k5_numbers)
                & B = k3_xcmplx_0(A,C) ) ) ) ) ).

fof(t48_nat_1,axiom,
    $true ).

fof(t49_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( r1_nat_1(A,B)
          <=> B = k3_xcmplx_0(A,k3_nat_1(B,A)) ) ) ) ).

fof(t50_nat_1,axiom,
    $true ).

fof(t51_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( ( r1_nat_1(A,B)
                  & r1_nat_1(B,C) )
               => r1_nat_1(A,C) ) ) ) ) ).

fof(t52_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ( r1_nat_1(A,B)
              & r1_nat_1(B,A) )
           => A = B ) ) ) ).

fof(t53_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ( r1_nat_1(A,np__0)
        & r1_nat_1(np__1,A) ) ) ).

fof(t54_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( r1_nat_1(B,A)
           => ( r1_xreal_0(A,np__0)
              | r1_xreal_0(B,A) ) ) ) ) ).

fof(t55_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( ( r1_nat_1(A,B)
                  & r1_nat_1(A,C) )
               => r1_nat_1(A,k2_xcmplx_0(B,C)) ) ) ) ) ).

fof(t56_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( r1_nat_1(A,B)
               => r1_nat_1(A,k3_xcmplx_0(B,C)) ) ) ) ) ).

fof(t57_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( ( r1_nat_1(A,B)
                  & r1_nat_1(A,k2_xcmplx_0(B,C)) )
               => r1_nat_1(A,C) ) ) ) ) ).

fof(t58_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( ( r1_nat_1(A,B)
                  & r1_nat_1(A,C) )
               => r1_nat_1(A,k4_nat_1(B,C)) ) ) ) ) ).

fof(d4_nat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( C = k5_nat_1(A,B)
              <=> ( r1_nat_1(A,C)
                  & r1_nat_1(B,C)
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ( ( r1_nat_1(A,D)
                          & r1_nat_1(B,D) )
                       => r1_nat_1(C,D) ) ) ) ) ) ) ) ).

fof(d5_nat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( C = k6_nat_1(A,B)
              <=> ( r1_nat_1(C,A)
                  & r1_nat_1(C,B)
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ( ( r1_nat_1(D,A)
                          & r1_nat_1(D,B) )
                       => r1_nat_1(D,C) ) ) ) ) ) ) ) ).

fof(t59_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ~ r1_xreal_0(k2_xcmplx_0(A,B),A)
          <=> r1_xreal_0(np__1,B) ) ) ) ).

fof(t60_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ~ r1_xreal_0(B,A)
           => m2_subset_1(k6_xcmplx_0(B,np__1),k1_numbers,k5_numbers) ) ) ) ).

fof(t61_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( r1_xreal_0(A,B)
           => m2_subset_1(k6_xcmplx_0(B,A),k1_numbers,k5_numbers) ) ) ) ).

fof(t62_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ( k4_nat_1(A,np__2) = np__0
        | k4_nat_1(A,np__2) = np__1 ) ) ).

fof(t63_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => k4_nat_1(k3_xcmplx_0(A,B),A) = np__0 ) ) ).

fof(t64_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ~ r1_xreal_0(A,np__1)
           => k4_nat_1(np__1,A) = np__1 ) ) ) ).

fof(t65_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ! [D] :
                  ( v4_ordinal2(D)
                 => ( ( k4_nat_1(A,C) = np__0
                      & B = k6_xcmplx_0(A,k3_xcmplx_0(D,C)) )
                   => k4_nat_1(B,C) = np__0 ) ) ) ) ) ).

fof(t66_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( k4_nat_1(A,C) = np__0
               => ( C = np__0
                  | r1_xreal_0(C,B)
                  | k4_nat_1(k2_xcmplx_0(A,B),C) = B ) ) ) ) ) ).

fof(t67_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( k4_nat_1(A,C) = np__0
               => k4_nat_1(k2_xcmplx_0(A,B),C) = k4_nat_1(B,C) ) ) ) ) ).

fof(t68_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( A != np__0
           => k3_nat_1(k3_xcmplx_0(A,B),A) = B ) ) ) ).

fof(t69_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( k4_nat_1(A,B) = np__0
               => k3_nat_1(k2_xcmplx_0(A,C),B) = k1_nat_1(k3_nat_1(A,B),k3_nat_1(C,B)) ) ) ) ) ).

fof(t70_nat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ~ ( ~ r1_xreal_0(k1_nat_1(B,np__1),A)
              & r1_xreal_0(B,A)
              & A != B ) ) ) ).

fof(t71_nat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ~ ( ~ r1_xreal_0(np__2,A)
          & A != np__0
          & A != np__1 ) ) ).

fof(t72_nat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( B != np__0
           => k3_nat_1(k2_nat_1(A,B),B) = A ) ) ) ).

fof(t73_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => k4_nat_1(A,B) = k4_nat_1(k2_xcmplx_0(k3_xcmplx_0(B,C),A),B) ) ) ) ).

fof(t74_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => k4_nat_1(k2_xcmplx_0(A,B),C) = k4_nat_1(k2_xcmplx_0(k4_nat_1(A,C),B),C) ) ) ) ).

fof(t75_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => k4_nat_1(k2_xcmplx_0(A,B),C) = k4_nat_1(k2_xcmplx_0(A,k4_nat_1(B,C)),C) ) ) ) ).

fof(t76_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ~ r1_xreal_0(A,B)
           => k4_nat_1(B,A) = B ) ) ) ).

fof(t77_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k4_nat_1(A,A) = np__0 ) ).

fof(t78_nat_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => np__0 = k4_nat_1(np__0,A) ) ).

fof(s1_nat_1,axiom,
    ( ( p1_s1_nat_1(np__0)
      & ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => ( p1_s1_nat_1(A)
           => p1_s1_nat_1(k1_nat_1(A,np__1)) ) ) )
   => ! [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
       => p1_s1_nat_1(A) ) ) ).

fof(s2_nat_1,axiom,
    ( ( p1_s2_nat_1(np__0)
      & ! [A] :
          ( v4_ordinal2(A)
         => ( p1_s2_nat_1(A)
           => p1_s2_nat_1(k2_xcmplx_0(A,np__1)) ) ) )
   => ! [A] :
        ( v4_ordinal2(A)
       => p1_s2_nat_1(A) ) ) ).

fof(s3_nat_1,axiom,
    ( ! [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
       => ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ( p1_s3_nat_1(A,B)
            <=> ~ ( ~ ( A = np__0
                      & B = f1_s3_nat_1 )
                  & ! [C] :
                      ( m2_subset_1(C,k1_numbers,k5_numbers)
                     => ! [D] :
                          ( m2_subset_1(D,k1_numbers,k5_numbers)
                         => ~ ( A = k1_nat_1(C,np__1)
                              & p1_s3_nat_1(C,D)
                              & B = f2_s3_nat_1(A,D) ) ) ) ) ) ) )
   => ( ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => ? [B] :
              ( m2_subset_1(B,k1_numbers,k5_numbers)
              & p1_s3_nat_1(A,B) ) )
      & ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => ! [B] :
              ( m2_subset_1(B,k1_numbers,k5_numbers)
             => ! [C] :
                  ( m2_subset_1(C,k1_numbers,k5_numbers)
                 => ( ( p1_s3_nat_1(A,B)
                      & p1_s3_nat_1(A,C) )
                   => B = C ) ) ) ) ) ) ).

fof(s4_nat_1,axiom,
    ( ! [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
       => ( ! [B] :
              ( m2_subset_1(B,k1_numbers,k5_numbers)
             => ( ~ r1_xreal_0(A,B)
               => p1_s4_nat_1(B) ) )
         => p1_s4_nat_1(A) ) )
   => ! [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
       => p1_s4_nat_1(A) ) ) ).

fof(s5_nat_1,axiom,
    ( ? [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
        & p1_s5_nat_1(A) )
   => ? [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
        & p1_s5_nat_1(A)
        & ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ( p1_s5_nat_1(B)
             => r1_xreal_0(A,B) ) ) ) ) ).

fof(s6_nat_1,axiom,
    ( ( ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => ( p1_s6_nat_1(A)
           => r1_xreal_0(A,f1_s6_nat_1) ) )
      & ? [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
          & p1_s6_nat_1(A) ) )
   => ? [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
        & p1_s6_nat_1(A)
        & ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ( p1_s6_nat_1(B)
             => r1_xreal_0(B,A) ) ) ) ) ).

fof(s7_nat_1,axiom,
    ( ( ? [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
          & p1_s7_nat_1(A) )
      & ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => ~ ( A != np__0
              & p1_s7_nat_1(A)
              & ! [B] :
                  ( m2_subset_1(B,k1_numbers,k5_numbers)
                 => ~ ( ~ r1_xreal_0(A,B)
                      & p1_s7_nat_1(B) ) ) ) ) )
   => p1_s7_nat_1(np__0) ) ).

fof(s8_nat_1,axiom,
    ( ( ~ r1_xreal_0(f3_s8_nat_1,np__0)
      & ~ r1_xreal_0(f2_s8_nat_1,f3_s8_nat_1)
      & f1_s8_nat_1(np__0) = f2_s8_nat_1
      & f1_s8_nat_1(np__1) = f3_s8_nat_1
      & ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => f1_s8_nat_1(k1_nat_1(A,np__2)) = k4_nat_1(f1_s8_nat_1(A),f1_s8_nat_1(k1_nat_1(A,np__1))) ) )
   => ? [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
        & f1_s8_nat_1(A) = k6_nat_1(f2_s8_nat_1,f3_s8_nat_1)
        & f1_s8_nat_1(k1_nat_1(A,np__1)) = np__0 ) ) ).

fof(reflexivity_r1_nat_1,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & v4_ordinal2(B) )
     => r1_nat_1(A,A) ) ).

fof(dt_k1_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => m2_subset_1(k1_nat_1(A,B),k1_numbers,k5_numbers) ) ).

fof(commutativity_k1_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k1_nat_1(A,B) = k1_nat_1(B,A) ) ).

fof(redefinition_k1_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k1_nat_1(A,B) = k2_xcmplx_0(A,B) ) ).

fof(dt_k2_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => m2_subset_1(k2_nat_1(A,B),k1_numbers,k5_numbers) ) ).

fof(commutativity_k2_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k2_nat_1(A,B) = k2_nat_1(B,A) ) ).

fof(redefinition_k2_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k2_nat_1(A,B) = k3_xcmplx_0(A,B) ) ).

fof(dt_k3_nat_1,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & v4_ordinal2(B) )
     => m2_subset_1(k3_nat_1(A,B),k1_numbers,k5_numbers) ) ).

fof(dt_k4_nat_1,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & v4_ordinal2(B) )
     => m2_subset_1(k4_nat_1(A,B),k1_numbers,k5_numbers) ) ).

fof(dt_k5_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => m2_subset_1(k5_nat_1(A,B),k1_numbers,k5_numbers) ) ).

fof(commutativity_k5_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k5_nat_1(A,B) = k5_nat_1(B,A) ) ).

fof(idempotence_k5_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k5_nat_1(A,A) = A ) ).

fof(dt_k6_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => m2_subset_1(k6_nat_1(A,B),k1_numbers,k5_numbers) ) ).

fof(commutativity_k6_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k6_nat_1(A,B) = k6_nat_1(B,A) ) ).

fof(idempotence_k6_nat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k6_nat_1(A,A) = A ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_int_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_numbers)
      & v1_xcmplx_0(A)
      & v1_xreal_0(A)
      & v1_int_1(A) ) ).

fof(rc2_int_1,axiom,
    ? [A] : v1_int_1(A) ).

fof(cc1_int_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k4_numbers)
     => v1_int_1(A) ) ).

fof(cc2_int_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_numbers)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A)
        & v4_ordinal2(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_int_1(A) ) ) ).

fof(cc3_int_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => v1_int_1(A) ) ).

fof(cc4_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ( v1_xcmplx_0(A)
        & v1_xreal_0(A) ) ) ).

fof(fc1_int_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & v1_int_1(k2_xcmplx_0(A,B)) ) ) ).

fof(fc2_int_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & v1_int_1(k3_xcmplx_0(A,B)) ) ) ).

fof(fc3_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ( v1_xcmplx_0(k4_xcmplx_0(A))
        & v1_xreal_0(k4_xcmplx_0(A))
        & v1_int_1(k4_xcmplx_0(A)) ) ) ).

fof(fc4_int_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v1_int_1(k6_xcmplx_0(A,B)) ) ) ).

fof(fc5_int_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_numbers)
     => ( v1_xcmplx_0(k4_xcmplx_0(A))
        & v1_xreal_0(k4_xcmplx_0(A))
        & ~ v2_xreal_0(k4_xcmplx_0(A))
        & v1_int_1(k4_xcmplx_0(A)) ) ) ).

fof(fc6_int_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(B,A))
        & v1_xreal_0(k2_xcmplx_0(B,A))
        & v1_int_1(k2_xcmplx_0(B,A)) ) ) ).

fof(fc7_int_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(B,A))
        & v1_xreal_0(k3_xcmplx_0(B,A))
        & v1_int_1(k3_xcmplx_0(B,A)) ) ) ).

fof(fc8_int_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(B,A))
        & v1_xreal_0(k6_xcmplx_0(B,A))
        & v1_int_1(k6_xcmplx_0(B,A)) ) ) ).

fof(fc9_int_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v1_int_1(k6_xcmplx_0(A,B)) ) ) ).

fof(fc10_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( v1_xcmplx_0(k3_int_1(A))
        & v1_xreal_0(k3_int_1(A)) ) ) ).

fof(d1_int_1,axiom,
    ! [A] :
      ( A = k4_numbers
    <=> ! [B] :
          ( r2_hidden(B,A)
        <=> ~ ! [C] :
                ( m2_subset_1(C,k1_numbers,k5_numbers)
               => ( B != C
                  & B != k1_real_1(C) ) ) ) ) ).

fof(d2_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
    <=> r2_hidden(A,k4_numbers) ) ).

fof(t1_int_1,axiom,
    $true ).

fof(t2_int_1,axiom,
    $true ).

fof(t3_int_1,axiom,
    $true ).

fof(t4_int_1,axiom,
    $true ).

fof(t5_int_1,axiom,
    $true ).

fof(t6_int_1,axiom,
    $true ).

fof(t7_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( ( A = B
              | A = k4_xcmplx_0(B) )
           => v1_int_1(A) ) ) ) ).

fof(t8_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ ( v1_int_1(A)
          & ! [B] :
              ( m2_subset_1(B,k1_numbers,k5_numbers)
             => ( A != B
                & A != k1_real_1(B) ) ) ) ) ).

fof(t9_int_1,axiom,
    $true ).

fof(t10_int_1,axiom,
    $true ).

fof(t11_int_1,axiom,
    $true ).

fof(t12_int_1,axiom,
    $true ).

fof(t13_int_1,axiom,
    $true ).

fof(t14_int_1,axiom,
    $true ).

fof(t15_int_1,axiom,
    $true ).

fof(t16_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ( r1_xreal_0(np__0,A)
       => r2_hidden(A,k5_numbers) ) ) ).

fof(t17_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( v1_int_1(A)
       => ( v1_int_1(k2_xcmplx_0(A,np__1))
          & v1_int_1(k6_xcmplx_0(A,np__1)) ) ) ) ).

fof(t18_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( r1_xreal_0(A,B)
           => r2_hidden(k6_xcmplx_0(B,A),k5_numbers) ) ) ) ).

fof(t19_int_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ( k2_xcmplx_0(B,A) = C
               => r1_xreal_0(B,C) ) ) ) ) ).

fof(t20_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( ~ r1_xreal_0(B,A)
           => r1_xreal_0(k2_xcmplx_0(A,np__1),B) ) ) ) ).

fof(t21_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ( ~ r1_xreal_0(np__0,A)
       => r1_xreal_0(A,k1_real_1(np__1)) ) ) ).

fof(t22_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( k3_xcmplx_0(A,B) = np__1
          <=> ( ( A = np__1
                & B = np__1 )
              | ( A = k1_real_1(np__1)
                & B = k1_real_1(np__1) ) ) ) ) ) ).

fof(t23_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( k3_xcmplx_0(A,B) = k1_real_1(np__1)
          <=> ( ( A = k1_real_1(np__1)
                & B = np__1 )
              | ( A = np__1
                & B = k1_real_1(np__1) ) ) ) ) ) ).

fof(d3_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ( r1_int_1(A,B,C)
              <=> ? [D] :
                    ( v1_int_1(D)
                    & k3_xcmplx_0(C,D) = k6_xcmplx_0(A,B) ) ) ) ) ) ).

fof(t24_int_1,axiom,
    $true ).

fof(t25_int_1,axiom,
    $true ).

fof(t26_int_1,axiom,
    $true ).

fof(t27_int_1,axiom,
    $true ).

fof(t28_int_1,axiom,
    $true ).

fof(t29_int_1,axiom,
    $true ).

fof(t30_int_1,axiom,
    $true ).

fof(t31_int_1,axiom,
    $true ).

fof(t32_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => r1_int_1(A,A,B) ) ) ).

fof(t33_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ( r1_int_1(A,np__0,A)
        & r1_int_1(np__0,A,A) ) ) ).

fof(t34_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => r1_int_1(A,B,np__1) ) ) ).

fof(t35_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ( r1_int_1(A,B,C)
               => r1_int_1(B,A,C) ) ) ) ) ).

fof(t36_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ! [D] :
                  ( v1_int_1(D)
                 => ( ( r1_int_1(A,B,C)
                      & r1_int_1(B,D,C) )
                   => r1_int_1(A,D,C) ) ) ) ) ) ).

fof(t37_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ! [D] :
                  ( v1_int_1(D)
                 => ! [E] :
                      ( v1_int_1(E)
                     => ( ( r1_int_1(A,B,C)
                          & r1_int_1(D,E,C) )
                       => r1_int_1(k2_xcmplx_0(A,D),k2_xcmplx_0(B,E),C) ) ) ) ) ) ) ).

fof(t38_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ! [D] :
                  ( v1_int_1(D)
                 => ! [E] :
                      ( v1_int_1(E)
                     => ( ( r1_int_1(A,B,C)
                          & r1_int_1(D,E,C) )
                       => r1_int_1(k6_xcmplx_0(A,D),k6_xcmplx_0(B,E),C) ) ) ) ) ) ) ).

fof(t39_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ! [D] :
                  ( v1_int_1(D)
                 => ! [E] :
                      ( v1_int_1(E)
                     => ( ( r1_int_1(A,B,C)
                          & r1_int_1(D,E,C) )
                       => r1_int_1(k3_xcmplx_0(A,D),k3_xcmplx_0(B,E),C) ) ) ) ) ) ) ).

fof(t40_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ! [D] :
                  ( v1_int_1(D)
                 => ( r1_int_1(k2_xcmplx_0(A,B),C,D)
                  <=> r1_int_1(A,k6_xcmplx_0(C,B),D) ) ) ) ) ) ).

fof(t41_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ! [D] :
                  ( v1_int_1(D)
                 => ! [E] :
                      ( v1_int_1(E)
                     => ( ( k3_xcmplx_0(A,B) = C
                          & r1_int_1(D,E,C) )
                       => r1_int_1(D,E,A) ) ) ) ) ) ) ).

fof(t42_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ( r1_int_1(A,B,C)
              <=> r1_int_1(k2_xcmplx_0(A,C),B,C) ) ) ) ) ).

fof(t43_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ( r1_int_1(A,B,C)
              <=> r1_int_1(k6_xcmplx_0(A,C),B,C) ) ) ) ) ).

fof(t44_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ( ( r1_xreal_0(B,A)
                  & r1_xreal_0(C,A) )
               => ( r1_xreal_0(B,k6_xcmplx_0(A,np__1))
                  | r1_xreal_0(C,k6_xcmplx_0(A,np__1))
                  | B = C ) ) ) ) ) ).

fof(t45_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_int_1(C)
             => ( ( r1_xreal_0(A,B)
                  & r1_xreal_0(A,C) )
               => ( r1_xreal_0(k2_xcmplx_0(A,np__1),B)
                  | r1_xreal_0(k2_xcmplx_0(A,np__1),C)
                  | B = C ) ) ) ) ) ).

fof(d4_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( B = k1_int_1(A)
          <=> ( r1_xreal_0(B,A)
              & ~ r1_xreal_0(B,k6_xcmplx_0(A,np__1)) ) ) ) ) ).

fof(t46_int_1,axiom,
    $true ).

fof(t47_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( k1_int_1(A) = A
      <=> v1_int_1(A) ) ) ).

fof(t48_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ ( ~ r1_xreal_0(A,k1_int_1(A))
            & v1_int_1(A) )
        & ~ ( ~ v1_int_1(A)
            & r1_xreal_0(A,k1_int_1(A)) ) ) ) ).

fof(t49_int_1,axiom,
    $true ).

fof(t50_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ r1_xreal_0(A,k6_xcmplx_0(k1_int_1(A),np__1))
        & ~ r1_xreal_0(k2_xcmplx_0(A,np__1),k1_int_1(A)) ) ) ).

fof(t51_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_int_1(B)
         => k2_xcmplx_0(k1_int_1(A),B) = k1_int_1(k2_xcmplx_0(A,B)) ) ) ).

fof(t52_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ~ r1_xreal_0(k2_xcmplx_0(k1_int_1(A),np__1),A) ) ).

fof(d5_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( B = k2_int_1(A)
          <=> ( r1_xreal_0(A,B)
              & ~ r1_xreal_0(k2_xcmplx_0(A,np__1),B) ) ) ) ) ).

fof(t53_int_1,axiom,
    $true ).

fof(t54_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( k2_int_1(A) = A
      <=> v1_int_1(A) ) ) ).

fof(t55_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ ( ~ r1_xreal_0(k2_int_1(A),A)
            & v1_int_1(A) )
        & ~ ( ~ v1_int_1(A)
            & r1_xreal_0(k2_int_1(A),A) ) ) ) ).

fof(t56_int_1,axiom,
    $true ).

fof(t57_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ r1_xreal_0(k2_int_1(A),k6_xcmplx_0(A,np__1))
        & ~ r1_xreal_0(k2_xcmplx_0(k2_int_1(A),np__1),A) ) ) ).

fof(t58_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_int_1(B)
         => k2_xcmplx_0(k2_int_1(A),B) = k2_int_1(k2_xcmplx_0(A,B)) ) ) ).

fof(t59_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( k1_int_1(A) = k2_int_1(A)
      <=> v1_int_1(A) ) ) ).

fof(t60_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ ( ~ r1_xreal_0(k2_int_1(A),k1_int_1(A))
            & v1_int_1(A) )
        & ~ ( ~ v1_int_1(A)
            & r1_xreal_0(k2_int_1(A),k1_int_1(A)) ) ) ) ).

fof(t61_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => r1_xreal_0(k1_int_1(A),k2_int_1(A)) ) ).

fof(t62_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k1_int_1(k2_int_1(A)) = k2_int_1(A) ) ).

fof(t63_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k1_int_1(k1_int_1(A)) = k1_int_1(A) ) ).

fof(t64_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k2_int_1(k2_int_1(A)) = k2_int_1(A) ) ).

fof(t65_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k2_int_1(k1_int_1(A)) = k1_int_1(A) ) ).

fof(t66_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( k1_int_1(A) = k2_int_1(A)
      <=> k2_xcmplx_0(k1_int_1(A),np__1) != k2_int_1(A) ) ) ).

fof(d6_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k3_int_1(A) = k6_xcmplx_0(A,k1_int_1(A)) ) ).

fof(t67_int_1,axiom,
    $true ).

fof(t68_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => A = k2_xcmplx_0(k1_int_1(A),k4_int_1(A)) ) ).

fof(t69_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ r1_xreal_0(np__1,k4_int_1(A))
        & r1_xreal_0(np__0,k4_int_1(A)) ) ) ).

fof(t70_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k1_int_1(k4_int_1(A)) = np__0 ) ).

fof(t71_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( k4_int_1(A) = np__0
      <=> v1_int_1(A) ) ) ).

fof(t72_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( ~ ( ~ r1_xreal_0(k4_int_1(A),np__0)
            & v1_int_1(A) )
        & ~ ( ~ v1_int_1(A)
            & r1_xreal_0(k4_int_1(A),np__0) ) ) ) ).

fof(d7_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => k5_int_1(A,B) = k1_int_1(k7_xcmplx_0(A,B)) ) ) ).

fof(d8_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( ( B != np__0
             => k6_int_1(A,B) = k6_xcmplx_0(A,k3_xcmplx_0(k5_int_1(A,B),B)) )
            & ( B = np__0
             => k6_int_1(A,B) = np__0 ) ) ) ) ).

fof(d9_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( r2_int_1(A,B)
          <=> ? [C] :
                ( v1_int_1(C)
                & B = k3_xcmplx_0(A,C) ) ) ) ) ).

fof(t73_int_1,axiom,
    $true ).

fof(t74_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( A != np__0
       => k1_int_1(k7_xcmplx_0(A,A)) = np__1 ) ) ).

fof(t75_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => k5_int_1(A,np__0) = np__0 ) ).

fof(t76_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ( A != np__0
       => k5_int_1(A,A) = np__1 ) ) ).

fof(t77_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => k6_int_1(A,A) = np__0 ) ).

fof(t78_int_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( v1_int_1(B)
         => ~ ( ~ r1_xreal_0(B,A)
              & ! [C] :
                  ( m2_subset_1(C,k1_numbers,k5_numbers)
                 => ~ ( C = k6_xcmplx_0(B,A)
                      & r1_xreal_0(np__1,C) ) ) ) ) ) ).

fof(t79_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ( ~ r1_xreal_0(B,A)
           => r1_xreal_0(A,k6_xcmplx_0(B,np__1)) ) ) ) ).

fof(t80_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ( r1_xreal_0(np__0,A)
       => ( r1_xreal_0(np__0,k2_int_1(A))
          & r1_xreal_0(np__0,k1_int_1(A))
          & m2_subset_1(k2_int_1(A),k1_numbers,k5_numbers)
          & m2_subset_1(k1_int_1(A),k1_numbers,k5_numbers) ) ) ) ).

fof(t81_int_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ( r1_xreal_0(A,B)
           => r1_xreal_0(A,k1_int_1(B)) ) ) ) ).

fof(t82_int_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => r1_xreal_0(np__0,k5_int_1(A,B)) ) ) ).

fof(s1_int_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_zfmisc_1(k4_numbers))
      & ! [B] :
          ( v1_int_1(B)
         => ( r2_hidden(B,A)
          <=> p1_s1_int_1(B) ) ) ) ).

fof(s2_int_1,axiom,
    ( ( p1_s2_int_1(f1_s2_int_1)
      & ! [A] :
          ( v1_int_1(A)
         => ( ( r1_xreal_0(f1_s2_int_1,A)
              & p1_s2_int_1(A) )
           => p1_s2_int_1(k2_xcmplx_0(A,np__1)) ) ) )
   => ! [A] :
        ( v1_int_1(A)
       => ( r1_xreal_0(f1_s2_int_1,A)
         => p1_s2_int_1(A) ) ) ) ).

fof(s3_int_1,axiom,
    ( ( p1_s3_int_1(f1_s3_int_1)
      & ! [A] :
          ( v1_int_1(A)
         => ( ( r1_xreal_0(A,f1_s3_int_1)
              & p1_s3_int_1(A) )
           => p1_s3_int_1(k6_xcmplx_0(A,np__1)) ) ) )
   => ! [A] :
        ( v1_int_1(A)
       => ( r1_xreal_0(A,f1_s3_int_1)
         => p1_s3_int_1(A) ) ) ) ).

fof(s4_int_1,axiom,
    ( ( p1_s4_int_1(f1_s4_int_1)
      & ! [A] :
          ( v1_int_1(A)
         => ( p1_s4_int_1(A)
           => ( p1_s4_int_1(k6_xcmplx_0(A,np__1))
              & p1_s4_int_1(k2_xcmplx_0(A,np__1)) ) ) ) )
   => ! [A] :
        ( v1_int_1(A)
       => p1_s4_int_1(A) ) ) ).

fof(s5_int_1,axiom,
    ( ( ! [A] :
          ( v1_int_1(A)
         => ( p1_s5_int_1(A)
           => r1_xreal_0(f1_s5_int_1,A) ) )
      & ? [A] :
          ( v1_int_1(A)
          & p1_s5_int_1(A) ) )
   => ? [A] :
        ( v1_int_1(A)
        & p1_s5_int_1(A)
        & ! [B] :
            ( v1_int_1(B)
           => ( p1_s5_int_1(B)
             => r1_xreal_0(A,B) ) ) ) ) ).

fof(s6_int_1,axiom,
    ( ( ! [A] :
          ( v1_int_1(A)
         => ( p1_s6_int_1(A)
           => r1_xreal_0(A,f1_s6_int_1) ) )
      & ? [A] :
          ( v1_int_1(A)
          & p1_s6_int_1(A) ) )
   => ? [A] :
        ( v1_int_1(A)
        & p1_s6_int_1(A)
        & ! [B] :
            ( v1_int_1(B)
           => ( p1_s6_int_1(B)
             => r1_xreal_0(B,A) ) ) ) ) ).

fof(reflexivity_r2_int_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_int_1(B) )
     => r2_int_1(A,A) ) ).

fof(dt_k1_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => v1_int_1(k1_int_1(A)) ) ).

fof(dt_k2_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => v1_int_1(k2_int_1(A)) ) ).

fof(dt_k3_int_1,axiom,
    $true ).

fof(dt_k4_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => m1_subset_1(k4_int_1(A),k1_numbers) ) ).

fof(redefinition_k4_int_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => k4_int_1(A) = k3_int_1(A) ) ).

fof(dt_k5_int_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_int_1(B) )
     => v1_int_1(k5_int_1(A,B)) ) ).

fof(dt_k6_int_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_int_1(B) )
     => v1_int_1(k6_int_1(A,B)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_rat_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_numbers)
      & v1_xcmplx_0(A)
      & v1_xreal_0(A)
      & v1_rat_1(A) ) ).

fof(rc2_rat_1,axiom,
    ? [A] : v1_rat_1(A) ).

fof(cc1_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( v1_xcmplx_0(A)
        & v1_xreal_0(A) ) ) ).

fof(cc2_rat_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ( v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & v1_rat_1(A) ) ) ).

fof(fc1_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & v1_rat_1(k3_xcmplx_0(A,B)) ) ) ).

fof(fc2_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & v1_rat_1(k2_xcmplx_0(A,B)) ) ) ).

fof(fc3_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v1_rat_1(k6_xcmplx_0(A,B)) ) ) ).

fof(fc4_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & v1_rat_1(k2_xcmplx_0(A,B)) ) ) ).

fof(fc5_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v1_rat_1(k6_xcmplx_0(A,B)) ) ) ).

fof(fc6_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & v1_int_1(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & v1_rat_1(k3_xcmplx_0(A,B)) ) ) ).

fof(fc7_rat_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & v1_rat_1(k2_xcmplx_0(A,B)) ) ) ).

fof(fc8_rat_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v1_rat_1(k6_xcmplx_0(A,B)) ) ) ).

fof(fc9_rat_1,axiom,
    ! [A,B] :
      ( ( v1_int_1(A)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & v1_rat_1(k3_xcmplx_0(A,B)) ) ) ).

fof(fc10_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & m1_subset_1(B,k5_numbers) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & v1_rat_1(k2_xcmplx_0(A,B)) ) ) ).

fof(fc11_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & m1_subset_1(B,k5_numbers) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v1_rat_1(k6_xcmplx_0(A,B)) ) ) ).

fof(fc12_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & m1_subset_1(B,k5_numbers) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & v1_rat_1(k3_xcmplx_0(A,B)) ) ) ).

fof(fc13_rat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k2_xcmplx_0(A,B))
        & v1_xreal_0(k2_xcmplx_0(A,B))
        & v1_rat_1(k2_xcmplx_0(A,B)) ) ) ).

fof(fc14_rat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k6_xcmplx_0(A,B))
        & v1_xreal_0(k6_xcmplx_0(A,B))
        & v1_rat_1(k6_xcmplx_0(A,B)) ) ) ).

fof(fc15_rat_1,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k3_xcmplx_0(A,B))
        & v1_xreal_0(k3_xcmplx_0(A,B))
        & v1_rat_1(k3_xcmplx_0(A,B)) ) ) ).

fof(fc16_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( v1_xcmplx_0(k4_xcmplx_0(A))
        & v1_xreal_0(k4_xcmplx_0(A))
        & v1_rat_1(k4_xcmplx_0(A)) ) ) ).

fof(fc17_rat_1,axiom,
    ! [A,B] :
      ( ( v1_rat_1(A)
        & v1_rat_1(B) )
     => ( v1_xcmplx_0(k7_xcmplx_0(A,B))
        & v1_xreal_0(k7_xcmplx_0(A,B))
        & v1_rat_1(k7_xcmplx_0(A,B)) ) ) ).

fof(fc18_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( v1_xcmplx_0(k5_xcmplx_0(A))
        & v1_xreal_0(k5_xcmplx_0(A))
        & v1_rat_1(k5_xcmplx_0(A)) ) ) ).

fof(d1_rat_1,axiom,
    ! [A] :
      ( A = k3_numbers
    <=> ! [B] :
          ( r2_hidden(B,A)
        <=> ? [C] :
              ( v1_int_1(C)
              & ? [D] :
                  ( v1_int_1(D)
                  & B = k7_xcmplx_0(C,D) ) ) ) ) ).

fof(d2_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
    <=> r2_hidden(A,k3_numbers) ) ).

fof(t1_rat_1,axiom,
    ! [A] :
      ~ ( r2_hidden(A,k3_numbers)
        & ! [B] :
            ( v1_int_1(B)
           => ! [C] :
                ( v1_int_1(C)
               => ~ ( C != np__0
                    & A = k7_xcmplx_0(B,C) ) ) ) ) ).

fof(t2_rat_1,axiom,
    $true ).

fof(t3_rat_1,axiom,
    ! [A] :
      ~ ( v1_rat_1(A)
        & ! [B] :
            ( v1_int_1(B)
           => ! [C] :
                ( v1_int_1(C)
               => ~ ( C != np__0
                    & A = k7_xcmplx_0(B,C) ) ) ) ) ).

fof(t4_rat_1,axiom,
    $true ).

fof(t5_rat_1,axiom,
    $true ).

fof(t6_rat_1,axiom,
    ! [A] :
      ( ? [B] :
          ( v1_int_1(B)
          & ? [C] :
              ( v1_int_1(C)
              & A = k7_xcmplx_0(B,C) ) )
     => v1_rat_1(A) ) ).

fof(t7_rat_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => v1_rat_1(A) ) ).

fof(t8_rat_1,axiom,
    $true ).

fof(t9_rat_1,axiom,
    $true ).

fof(t10_rat_1,axiom,
    $true ).

fof(t11_rat_1,axiom,
    $true ).

fof(t12_rat_1,axiom,
    $true ).

fof(t13_rat_1,axiom,
    $true ).

fof(t14_rat_1,axiom,
    $true ).

fof(t15_rat_1,axiom,
    $true ).

fof(t16_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ! [B] :
          ( v1_rat_1(B)
         => v1_rat_1(k7_xcmplx_0(A,B)) ) ) ).

fof(t17_rat_1,axiom,
    $true ).

fof(t18_rat_1,axiom,
    $true ).

fof(t19_rat_1,axiom,
    $true ).

fof(t20_rat_1,axiom,
    $true ).

fof(t21_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => v1_rat_1(k5_xcmplx_0(A)) ) ).

fof(t22_rat_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_xreal_0(B)
         => ~ ( ~ r1_xreal_0(B,A)
              & ! [C] :
                  ( v1_rat_1(C)
                 => ~ ( ~ r1_xreal_0(C,A)
                      & ~ r1_xreal_0(B,C) ) ) ) ) ) ).

fof(t23_rat_1,axiom,
    $true ).

fof(t24_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ? [B] :
          ( v1_int_1(B)
          & ? [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
              & C != np__0
              & A = k7_xcmplx_0(B,C) ) ) ) ).

fof(t25_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ? [B] :
          ( v1_int_1(B)
          & ? [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
              & C != np__0
              & A = k7_xcmplx_0(B,C)
              & ! [D] :
                  ( v1_int_1(D)
                 => ! [E] :
                      ( m2_subset_1(E,k1_numbers,k5_numbers)
                     => ( A = k7_xcmplx_0(D,E)
                       => ( E = np__0
                          | r1_xreal_0(C,E) ) ) ) ) ) ) ) ).

fof(d3_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( B = k1_rat_1(A)
          <=> ( B != np__0
              & ? [C] :
                  ( v1_int_1(C)
                  & A = k7_xcmplx_0(C,B) )
              & ! [C] :
                  ( v1_int_1(C)
                 => ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ( A = k7_xcmplx_0(C,D)
                       => ( D = np__0
                          | r1_xreal_0(B,D) ) ) ) ) ) ) ) ) ).

fof(d4_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => k2_rat_1(A) = k3_xcmplx_0(k1_rat_1(A),A) ) ).

fof(t26_rat_1,axiom,
    $true ).

fof(t27_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ~ r1_xreal_0(k1_rat_1(A),np__0) ) ).

fof(t28_rat_1,axiom,
    $true ).

fof(t29_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => r1_xreal_0(np__1,k1_rat_1(A)) ) ).

fof(t30_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ~ r1_xreal_0(k2_real_1(k1_rat_1(A)),np__0) ) ).

fof(t31_rat_1,axiom,
    $true ).

fof(t32_rat_1,axiom,
    $true ).

fof(t33_rat_1,axiom,
    $true ).

fof(t34_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => r1_xreal_0(k2_real_1(k1_rat_1(A)),np__1) ) ).

fof(t35_rat_1,axiom,
    $true ).

fof(t36_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( k2_rat_1(A) = np__0
      <=> A = np__0 ) ) ).

fof(t37_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( A = k7_xcmplx_0(k2_rat_1(A),k1_rat_1(A))
        & A = k3_xcmplx_0(k2_rat_1(A),k2_real_1(k1_rat_1(A)))
        & A = k3_xcmplx_0(k2_real_1(k1_rat_1(A)),k2_rat_1(A)) ) ) ).

fof(t38_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( A != np__0
       => k1_rat_1(A) = k7_xcmplx_0(k2_rat_1(A),A) ) ) ).

fof(t39_rat_1,axiom,
    $true ).

fof(t40_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( v1_int_1(A)
       => ( k1_rat_1(A) = np__1
          & k2_rat_1(A) = A ) ) ) ).

fof(t41_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( ( k2_rat_1(A) = A
          | k1_rat_1(A) = np__1 )
       => v1_int_1(A) ) ) ).

fof(t42_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( k2_rat_1(A) = A
      <=> k1_rat_1(A) = np__1 ) ) ).

fof(t43_rat_1,axiom,
    $true ).

fof(t44_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( r1_xreal_0(np__0,A)
       => ( ( k2_rat_1(A) != A
            & k1_rat_1(A) != np__1 )
          | m2_subset_1(A,k1_numbers,k5_numbers) ) ) ) ).

fof(t45_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( ~ ( ~ r1_xreal_0(k1_rat_1(A),np__1)
            & v1_int_1(A) )
        & ~ ( ~ v1_int_1(A)
            & r1_xreal_0(k1_rat_1(A),np__1) ) ) ) ).

fof(t46_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( ~ ( ~ r1_xreal_0(np__1,k2_real_1(k1_rat_1(A)))
            & v1_int_1(A) )
        & ~ ( ~ v1_int_1(A)
            & r1_xreal_0(np__1,k2_real_1(k1_rat_1(A))) ) ) ) ).

fof(t47_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( k2_rat_1(A) = k1_rat_1(A)
      <=> A = np__1 ) ) ).

fof(t48_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( k2_rat_1(A) = k1_real_1(k1_rat_1(A))
      <=> A = k1_real_1(np__1) ) ) ).

fof(t49_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( k4_xcmplx_0(k2_rat_1(A)) = k1_rat_1(A)
      <=> A = k1_real_1(np__1) ) ) ).

fof(t50_rat_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_rat_1(B)
         => ( A != np__0
           => B = k7_xcmplx_0(k3_xcmplx_0(k2_rat_1(B),A),k3_xcmplx_0(k1_rat_1(B),A)) ) ) ) ).

fof(t51_rat_1,axiom,
    $true ).

fof(t52_rat_1,axiom,
    $true ).

fof(t53_rat_1,axiom,
    $true ).

fof(t54_rat_1,axiom,
    $true ).

fof(t55_rat_1,axiom,
    $true ).

fof(t56_rat_1,axiom,
    $true ).

fof(t57_rat_1,axiom,
    $true ).

fof(t58_rat_1,axiom,
    $true ).

fof(t59_rat_1,axiom,
    $true ).

fof(t60_rat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_rat_1(C)
             => ~ ( A != np__0
                  & C = k7_xcmplx_0(B,A)
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ~ ( B = k3_xcmplx_0(k2_rat_1(C),D)
                          & A = k2_nat_1(k1_rat_1(C),D) ) ) ) ) ) ) ).

fof(t61_rat_1,axiom,
    ! [A] :
      ( v1_int_1(A)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_rat_1(C)
             => ~ ( C = k7_xcmplx_0(A,B)
                  & B != np__0
                  & ! [D] :
                      ( v1_int_1(D)
                     => ~ ( A = k3_xcmplx_0(k2_rat_1(C),D)
                          & B = k3_xcmplx_0(k1_rat_1(C),D) ) ) ) ) ) ) ).

fof(t62_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ~ ( ~ r1_xreal_0(B,np__1)
              & ? [C] :
                  ( v1_int_1(C)
                  & ? [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                      & k2_rat_1(A) = k3_xcmplx_0(C,B)
                      & k1_rat_1(A) = k2_nat_1(D,B) ) ) ) ) ) ).

fof(t63_rat_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( v1_int_1(B)
         => ! [C] :
              ( v1_rat_1(C)
             => ( ( C = k7_xcmplx_0(B,A)
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ~ ( ~ r1_xreal_0(D,np__1)
                          & ? [E] :
                              ( v1_int_1(E)
                              & ? [F] :
                                  ( m2_subset_1(F,k1_numbers,k5_numbers)
                                  & B = k3_xcmplx_0(E,D)
                                  & A = k2_nat_1(F,D) ) ) ) ) )
               => ( A = np__0
                  | ( A = k1_rat_1(C)
                    & B = k2_rat_1(C) ) ) ) ) ) ) ).

fof(t64_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( ~ ( ~ r1_xreal_0(k1_real_1(np__1),A)
            & r1_xreal_0(k1_real_1(k1_rat_1(A)),k2_rat_1(A)) )
        & ~ ( ~ r1_xreal_0(k1_real_1(k1_rat_1(A)),k2_rat_1(A))
            & r1_xreal_0(k1_real_1(np__1),A) ) ) ) ).

fof(t65_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( r1_xreal_0(A,k1_real_1(np__1))
      <=> r1_xreal_0(k2_rat_1(A),k1_real_1(k1_rat_1(A))) ) ) ).

fof(t66_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( ~ ( ~ r1_xreal_0(k1_real_1(np__1),A)
            & r1_xreal_0(k4_xcmplx_0(k2_rat_1(A)),k1_rat_1(A)) )
        & ~ ( ~ r1_xreal_0(k4_xcmplx_0(k2_rat_1(A)),k1_rat_1(A))
            & r1_xreal_0(k1_real_1(np__1),A) ) ) ) ).

fof(t67_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( r1_xreal_0(A,k1_real_1(np__1))
      <=> r1_xreal_0(k1_rat_1(A),k4_xcmplx_0(k2_rat_1(A))) ) ) ).

fof(t68_rat_1,axiom,
    $true ).

fof(t69_rat_1,axiom,
    $true ).

fof(t70_rat_1,axiom,
    $true ).

fof(t71_rat_1,axiom,
    $true ).

fof(t72_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( ~ ( ~ r1_xreal_0(np__1,A)
            & r1_xreal_0(k1_rat_1(A),k2_rat_1(A)) )
        & ~ ( ~ r1_xreal_0(k1_rat_1(A),k2_rat_1(A))
            & r1_xreal_0(np__1,A) ) ) ) ).

fof(t73_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( r1_xreal_0(A,np__1)
      <=> r1_xreal_0(k2_rat_1(A),k1_rat_1(A)) ) ) ).

fof(t74_rat_1,axiom,
    $true ).

fof(t75_rat_1,axiom,
    $true ).

fof(t76_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( ~ ( ~ r1_xreal_0(np__0,A)
            & r1_xreal_0(np__0,k2_rat_1(A)) )
        & ~ ( ~ r1_xreal_0(np__0,k2_rat_1(A))
            & r1_xreal_0(np__0,A) ) ) ) ).

fof(t77_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( r1_xreal_0(A,np__0)
      <=> r1_xreal_0(k2_rat_1(A),np__0) ) ) ).

fof(t78_rat_1,axiom,
    $true ).

fof(t79_rat_1,axiom,
    $true ).

fof(t80_rat_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_rat_1(B)
         => ( ~ ( ~ r1_xreal_0(B,A)
                & r1_xreal_0(k2_rat_1(B),k3_xcmplx_0(A,k1_rat_1(B))) )
            & ~ ( ~ r1_xreal_0(k2_rat_1(B),k3_xcmplx_0(A,k1_rat_1(B)))
                & r1_xreal_0(B,A) ) ) ) ) ).

fof(t81_rat_1,axiom,
    ! [A] :
      ( v1_xreal_0(A)
     => ! [B] :
          ( v1_rat_1(B)
         => ( r1_xreal_0(A,B)
          <=> r1_xreal_0(k3_xcmplx_0(A,k1_rat_1(B)),k2_rat_1(B)) ) ) ) ).

fof(t82_rat_1,axiom,
    $true ).

fof(t83_rat_1,axiom,
    $true ).

fof(t84_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ! [B] :
          ( v1_rat_1(B)
         => ( ( k1_rat_1(A) = k1_rat_1(B)
              & k2_rat_1(A) = k2_rat_1(B) )
           => A = B ) ) ) ).

fof(t85_rat_1,axiom,
    $true ).

fof(t86_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ! [B] :
          ( v1_rat_1(B)
         => ( ~ ( ~ r1_xreal_0(B,A)
                & r1_xreal_0(k3_xcmplx_0(k2_rat_1(B),k1_rat_1(A)),k3_xcmplx_0(k2_rat_1(A),k1_rat_1(B))) )
            & ~ ( ~ r1_xreal_0(k3_xcmplx_0(k2_rat_1(B),k1_rat_1(A)),k3_xcmplx_0(k2_rat_1(A),k1_rat_1(B)))
                & r1_xreal_0(B,A) ) ) ) ) ).

fof(t87_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ( k1_rat_1(k4_xcmplx_0(A)) = k1_rat_1(A)
        & k2_rat_1(k4_xcmplx_0(A)) = k4_xcmplx_0(k2_rat_1(A)) ) ) ).

fof(t88_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ! [B] :
          ( v1_rat_1(B)
         => ( ( B = k7_xcmplx_0(np__1,A)
             => ( r1_xreal_0(A,np__0)
                | ( k2_rat_1(B) = k1_rat_1(A)
                  & k1_rat_1(B) = k2_rat_1(A) ) ) )
            & ( ( k2_rat_1(B) = k1_rat_1(A)
                & k1_rat_1(B) = k2_rat_1(A) )
             => ( ~ r1_xreal_0(A,np__0)
                & B = k7_xcmplx_0(np__1,A) ) ) ) ) ) ).

fof(t89_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => ! [B] :
          ( v1_rat_1(B)
         => ( ( B = k7_xcmplx_0(np__1,A)
             => ( r1_xreal_0(np__0,A)
                | ( k2_rat_1(B) = k1_real_1(k1_rat_1(A))
                  & k1_rat_1(B) = k4_xcmplx_0(k2_rat_1(A)) ) ) )
            & ( ( k2_rat_1(B) = k1_real_1(k1_rat_1(A))
                & k1_rat_1(B) = k4_xcmplx_0(k2_rat_1(A)) )
             => ( ~ r1_xreal_0(np__0,A)
                & B = k7_xcmplx_0(np__1,A) ) ) ) ) ) ).

fof(dt_k1_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => m2_subset_1(k1_rat_1(A),k1_numbers,k5_numbers) ) ).

fof(dt_k2_rat_1,axiom,
    ! [A] :
      ( v1_rat_1(A)
     => v1_int_1(k2_rat_1(A)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k3_numbers)
     => ( v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & v1_rat_1(A) ) ) ).

fof(fc1_binop_2,axiom,
    ( v1_funct_1(k27_binop_2)
    & v1_funct_2(k27_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & v1_binop_1(k27_binop_2,k2_numbers)
    & v2_binop_1(k27_binop_2,k2_numbers) ) ).

fof(fc2_binop_2,axiom,
    ( v1_funct_1(k29_binop_2)
    & v1_funct_2(k29_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & v1_binop_1(k29_binop_2,k2_numbers)
    & v2_binop_1(k29_binop_2,k2_numbers) ) ).

fof(fc3_binop_2,axiom,
    ( v1_funct_1(k33_binop_2)
    & v1_funct_2(k33_binop_2,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
    & v1_binop_1(k33_binop_2,k1_numbers)
    & v2_binop_1(k33_binop_2,k1_numbers) ) ).

fof(fc4_binop_2,axiom,
    ( v1_funct_1(k35_binop_2)
    & v1_funct_2(k35_binop_2,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
    & v1_binop_1(k35_binop_2,k1_numbers)
    & v2_binop_1(k35_binop_2,k1_numbers) ) ).

fof(fc5_binop_2,axiom,
    ( v1_funct_1(k39_binop_2)
    & v1_funct_2(k39_binop_2,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
    & v1_binop_1(k39_binop_2,k3_numbers)
    & v2_binop_1(k39_binop_2,k3_numbers) ) ).

fof(fc6_binop_2,axiom,
    ( v1_funct_1(k41_binop_2)
    & v1_funct_2(k41_binop_2,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
    & v1_binop_1(k41_binop_2,k3_numbers)
    & v2_binop_1(k41_binop_2,k3_numbers) ) ).

fof(fc7_binop_2,axiom,
    ( v1_funct_1(k44_binop_2)
    & v1_funct_2(k44_binop_2,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers)
    & v1_binop_1(k44_binop_2,k4_numbers)
    & v2_binop_1(k44_binop_2,k4_numbers) ) ).

fof(fc8_binop_2,axiom,
    ( v1_funct_1(k46_binop_2)
    & v1_funct_2(k46_binop_2,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers)
    & v1_binop_1(k46_binop_2,k4_numbers)
    & v2_binop_1(k46_binop_2,k4_numbers) ) ).

fof(fc9_binop_2,axiom,
    ( v1_funct_1(k47_binop_2)
    & v1_funct_2(k47_binop_2,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers)
    & v1_binop_1(k47_binop_2,k5_numbers)
    & v2_binop_1(k47_binop_2,k5_numbers) ) ).

fof(fc10_binop_2,axiom,
    ( v1_funct_1(k48_binop_2)
    & v1_funct_2(k48_binop_2,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers)
    & v1_binop_1(k48_binop_2,k5_numbers)
    & v2_binop_1(k48_binop_2,k5_numbers) ) ).

fof(fc11_binop_2,axiom,
    ( v1_funct_1(k27_binop_2)
    & v1_funct_2(k27_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & v1_binop_1(k27_binop_2,k2_numbers)
    & v2_binop_1(k27_binop_2,k2_numbers)
    & v1_setwiseo(k27_binop_2,k2_numbers) ) ).

fof(fc12_binop_2,axiom,
    ( v1_funct_1(k33_binop_2)
    & v1_funct_2(k33_binop_2,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
    & v1_binop_1(k33_binop_2,k1_numbers)
    & v2_binop_1(k33_binop_2,k1_numbers)
    & v1_setwiseo(k33_binop_2,k1_numbers) ) ).

fof(fc13_binop_2,axiom,
    ( v1_funct_1(k39_binop_2)
    & v1_funct_2(k39_binop_2,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
    & v1_binop_1(k39_binop_2,k3_numbers)
    & v2_binop_1(k39_binop_2,k3_numbers)
    & v1_setwiseo(k39_binop_2,k3_numbers) ) ).

fof(fc14_binop_2,axiom,
    ( v1_funct_1(k44_binop_2)
    & v1_funct_2(k44_binop_2,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers)
    & v1_binop_1(k44_binop_2,k4_numbers)
    & v2_binop_1(k44_binop_2,k4_numbers)
    & v1_setwiseo(k44_binop_2,k4_numbers) ) ).

fof(fc15_binop_2,axiom,
    ( v1_funct_1(k47_binop_2)
    & v1_funct_2(k47_binop_2,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers)
    & v1_binop_1(k47_binop_2,k5_numbers)
    & v2_binop_1(k47_binop_2,k5_numbers)
    & v1_setwiseo(k47_binop_2,k5_numbers) ) ).

fof(fc16_binop_2,axiom,
    ( v1_funct_1(k29_binop_2)
    & v1_funct_2(k29_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & v1_binop_1(k29_binop_2,k2_numbers)
    & v2_binop_1(k29_binop_2,k2_numbers)
    & v1_setwiseo(k29_binop_2,k2_numbers) ) ).

fof(fc17_binop_2,axiom,
    ( v1_funct_1(k35_binop_2)
    & v1_funct_2(k35_binop_2,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
    & v1_binop_1(k35_binop_2,k1_numbers)
    & v2_binop_1(k35_binop_2,k1_numbers)
    & v1_setwiseo(k35_binop_2,k1_numbers) ) ).

fof(fc18_binop_2,axiom,
    ( v1_funct_1(k41_binop_2)
    & v1_funct_2(k41_binop_2,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
    & v1_binop_1(k41_binop_2,k3_numbers)
    & v2_binop_1(k41_binop_2,k3_numbers)
    & v1_setwiseo(k41_binop_2,k3_numbers) ) ).

fof(fc19_binop_2,axiom,
    ( v1_funct_1(k46_binop_2)
    & v1_funct_2(k46_binop_2,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers)
    & v1_binop_1(k46_binop_2,k4_numbers)
    & v2_binop_1(k46_binop_2,k4_numbers)
    & v1_setwiseo(k46_binop_2,k4_numbers) ) ).

fof(fc20_binop_2,axiom,
    ( v1_funct_1(k48_binop_2)
    & v1_funct_2(k48_binop_2,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers)
    & v1_binop_1(k48_binop_2,k5_numbers)
    & v2_binop_1(k48_binop_2,k5_numbers)
    & v1_setwiseo(k48_binop_2,k5_numbers) ) ).

fof(d1_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_numbers,k2_numbers)
        & m2_relset_1(A,k2_numbers,k2_numbers) )
     => ( A = k25_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k2_numbers)
           => k8_funct_2(k2_numbers,k2_numbers,A,B) = k1_binop_2(B) ) ) ) ).

fof(d2_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_numbers,k2_numbers)
        & m2_relset_1(A,k2_numbers,k2_numbers) )
     => ( A = k26_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k2_numbers)
           => k8_funct_2(k2_numbers,k2_numbers,A,B) = k2_binop_2(B) ) ) ) ).

fof(d3_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) )
     => ( A = k27_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k2_numbers)
           => ! [C] :
                ( m1_subset_1(C,k2_numbers)
               => k2_binop_1(k2_numbers,k2_numbers,k2_numbers,A,B,C) = k3_binop_2(B,C) ) ) ) ) ).

fof(d4_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) )
     => ( A = k28_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k2_numbers)
           => ! [C] :
                ( m1_subset_1(C,k2_numbers)
               => k2_binop_1(k2_numbers,k2_numbers,k2_numbers,A,B,C) = k4_binop_2(B,C) ) ) ) ) ).

fof(d5_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) )
     => ( A = k29_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k2_numbers)
           => ! [C] :
                ( m1_subset_1(C,k2_numbers)
               => k2_binop_1(k2_numbers,k2_numbers,k2_numbers,A,B,C) = k5_binop_2(B,C) ) ) ) ) ).

fof(d6_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) )
     => ( A = k30_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k2_numbers)
           => ! [C] :
                ( m1_subset_1(C,k2_numbers)
               => k2_binop_1(k2_numbers,k2_numbers,k2_numbers,A,B,C) = k6_binop_2(B,C) ) ) ) ) ).

fof(d7_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k1_numbers,k1_numbers)
        & m2_relset_1(A,k1_numbers,k1_numbers) )
     => ( A = k31_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k1_numbers)
           => k8_funct_2(k1_numbers,k1_numbers,A,B) = k7_binop_2(B) ) ) ) ).

fof(d8_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k1_numbers,k1_numbers)
        & m2_relset_1(A,k1_numbers,k1_numbers) )
     => ( A = k32_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k1_numbers)
           => k8_funct_2(k1_numbers,k1_numbers,A,B) = k8_binop_2(B) ) ) ) ).

fof(d9_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers) )
     => ( A = k33_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k1_numbers)
           => ! [C] :
                ( m1_subset_1(C,k1_numbers)
               => k2_binop_1(k1_numbers,k1_numbers,k1_numbers,A,B,C) = k9_binop_2(B,C) ) ) ) ) ).

fof(d10_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers) )
     => ( A = k34_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k1_numbers)
           => ! [C] :
                ( m1_subset_1(C,k1_numbers)
               => k2_binop_1(k1_numbers,k1_numbers,k1_numbers,A,B,C) = k10_binop_2(B,C) ) ) ) ) ).

fof(d11_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers) )
     => ( A = k35_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k1_numbers)
           => ! [C] :
                ( m1_subset_1(C,k1_numbers)
               => k2_binop_1(k1_numbers,k1_numbers,k1_numbers,A,B,C) = k11_binop_2(B,C) ) ) ) ) ).

fof(d12_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers) )
     => ( A = k36_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k1_numbers)
           => ! [C] :
                ( m1_subset_1(C,k1_numbers)
               => k2_binop_1(k1_numbers,k1_numbers,k1_numbers,A,B,C) = k12_binop_2(B,C) ) ) ) ) ).

fof(d13_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k3_numbers,k3_numbers)
        & m2_relset_1(A,k3_numbers,k3_numbers) )
     => ( A = k37_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k3_numbers)
           => k8_funct_2(k3_numbers,k3_numbers,A,B) = k13_binop_2(B) ) ) ) ).

fof(d14_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k3_numbers,k3_numbers)
        & m2_relset_1(A,k3_numbers,k3_numbers) )
     => ( A = k38_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k3_numbers)
           => k8_funct_2(k3_numbers,k3_numbers,A,B) = k14_binop_2(B) ) ) ) ).

fof(d15_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers) )
     => ( A = k39_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k3_numbers)
           => ! [C] :
                ( m1_subset_1(C,k3_numbers)
               => k2_binop_1(k3_numbers,k3_numbers,k3_numbers,A,B,C) = k15_binop_2(B,C) ) ) ) ) ).

fof(d16_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers) )
     => ( A = k40_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k3_numbers)
           => ! [C] :
                ( m1_subset_1(C,k3_numbers)
               => k2_binop_1(k3_numbers,k3_numbers,k3_numbers,A,B,C) = k16_binop_2(B,C) ) ) ) ) ).

fof(d17_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers) )
     => ( A = k41_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k3_numbers)
           => ! [C] :
                ( m1_subset_1(C,k3_numbers)
               => k2_binop_1(k3_numbers,k3_numbers,k3_numbers,A,B,C) = k17_binop_2(B,C) ) ) ) ) ).

fof(d18_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k3_numbers,k3_numbers),k3_numbers) )
     => ( A = k42_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k3_numbers)
           => ! [C] :
                ( m1_subset_1(C,k3_numbers)
               => k2_binop_1(k3_numbers,k3_numbers,k3_numbers,A,B,C) = k18_binop_2(B,C) ) ) ) ) ).

fof(d19_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k4_numbers,k4_numbers)
        & m2_relset_1(A,k4_numbers,k4_numbers) )
     => ( A = k43_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k4_numbers)
           => k8_funct_2(k4_numbers,k4_numbers,A,B) = k19_binop_2(B) ) ) ) ).

fof(d20_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers) )
     => ( A = k44_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k4_numbers)
           => ! [C] :
                ( m1_subset_1(C,k4_numbers)
               => k2_binop_1(k4_numbers,k4_numbers,k4_numbers,A,B,C) = k20_binop_2(B,C) ) ) ) ) ).

fof(d21_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers) )
     => ( A = k45_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k4_numbers)
           => ! [C] :
                ( m1_subset_1(C,k4_numbers)
               => k2_binop_1(k4_numbers,k4_numbers,k4_numbers,A,B,C) = k21_binop_2(B,C) ) ) ) ) ).

fof(d22_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k4_numbers,k4_numbers),k4_numbers) )
     => ( A = k46_binop_2
      <=> ! [B] :
            ( m1_subset_1(B,k4_numbers)
           => ! [C] :
                ( m1_subset_1(C,k4_numbers)
               => k2_binop_1(k4_numbers,k4_numbers,k4_numbers,A,B,C) = k22_binop_2(B,C) ) ) ) ) ).

fof(d23_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers) )
     => ( A = k47_binop_2
      <=> ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ! [C] :
                ( m2_subset_1(C,k1_numbers,k5_numbers)
               => k2_binop_1(k5_numbers,k5_numbers,k5_numbers,A,B,C) = k23_binop_2(B,C) ) ) ) ) ).

fof(d24_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers)
        & m2_relset_1(A,k2_zfmisc_1(k5_numbers,k5_numbers),k5_numbers) )
     => ( A = k48_binop_2
      <=> ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ! [C] :
                ( m2_subset_1(C,k1_numbers,k5_numbers)
               => k2_binop_1(k5_numbers,k5_numbers,k5_numbers,A,B,C) = k24_binop_2(B,C) ) ) ) ) ).

fof(t1_binop_2,axiom,
    k3_binop_1(k2_numbers,k27_binop_2) = np__0 ).

fof(t2_binop_2,axiom,
    k3_binop_1(k1_numbers,k33_binop_2) = np__0 ).

fof(t3_binop_2,axiom,
    k3_binop_1(k3_numbers,k39_binop_2) = np__0 ).

fof(t4_binop_2,axiom,
    k3_binop_1(k4_numbers,k44_binop_2) = np__0 ).

fof(t5_binop_2,axiom,
    k3_binop_1(k5_numbers,k47_binop_2) = np__0 ).

fof(t6_binop_2,axiom,
    k3_binop_1(k2_numbers,k29_binop_2) = np__1 ).

fof(t7_binop_2,axiom,
    k3_binop_1(k1_numbers,k35_binop_2) = np__1 ).

fof(t8_binop_2,axiom,
    k3_binop_1(k3_numbers,k41_binop_2) = np__1 ).

fof(t9_binop_2,axiom,
    k3_binop_1(k4_numbers,k46_binop_2) = np__1 ).

fof(t10_binop_2,axiom,
    k3_binop_1(k5_numbers,k48_binop_2) = np__1 ).

fof(s1_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,f1_s1_binop_2,f2_s1_binop_2)
        & m2_relset_1(A,f1_s1_binop_2,f2_s1_binop_2) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,f1_s1_binop_2,f2_s1_binop_2)
            & m2_relset_1(B,f1_s1_binop_2,f2_s1_binop_2) )
         => ( ( ! [C] :
                  ( m1_subset_1(C,f1_s1_binop_2)
                 => k8_funct_2(f1_s1_binop_2,f2_s1_binop_2,A,C) = f3_s1_binop_2(C) )
              & ! [C] :
                  ( m1_subset_1(C,f1_s1_binop_2)
                 => k8_funct_2(f1_s1_binop_2,f2_s1_binop_2,B,C) = f3_s1_binop_2(C) ) )
           => A = B ) ) ) ).

fof(s2_binop_2,axiom,
    ! [A] :
      ( ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s2_binop_2,f1_s2_binop_2),f1_s2_binop_2)
        & m2_relset_1(A,k2_zfmisc_1(f1_s2_binop_2,f1_s2_binop_2),f1_s2_binop_2) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(f1_s2_binop_2,f1_s2_binop_2),f1_s2_binop_2)
            & m2_relset_1(B,k2_zfmisc_1(f1_s2_binop_2,f1_s2_binop_2),f1_s2_binop_2) )
         => ( ( ! [C] :
                  ( m1_subset_1(C,f1_s2_binop_2)
                 => ! [D] :
                      ( m1_subset_1(D,f1_s2_binop_2)
                     => k2_binop_1(f1_s2_binop_2,f1_s2_binop_2,f1_s2_binop_2,A,C,D) = f2_s2_binop_2(C,D) ) )
              & ! [C] :
                  ( m1_subset_1(C,f1_s2_binop_2)
                 => ! [D] :
                      ( m1_subset_1(D,f1_s2_binop_2)
                     => k2_binop_1(f1_s2_binop_2,f1_s2_binop_2,f1_s2_binop_2,B,C,D) = f2_s2_binop_2(C,D) ) ) )
           => A = B ) ) ) ).

fof(dt_k1_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => m1_subset_1(k1_binop_2(A),k2_numbers) ) ).

fof(involutiveness_k1_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => k1_binop_2(k1_binop_2(A)) = A ) ).

fof(redefinition_k1_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => k1_binop_2(A) = k4_xcmplx_0(A) ) ).

fof(dt_k2_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => m1_subset_1(k2_binop_2(A),k2_numbers) ) ).

fof(involutiveness_k2_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => k2_binop_2(k2_binop_2(A)) = A ) ).

fof(redefinition_k2_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k2_numbers)
     => k2_binop_2(A) = k5_xcmplx_0(A) ) ).

fof(dt_k3_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => m1_subset_1(k3_binop_2(A,B),k2_numbers) ) ).

fof(commutativity_k3_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => k3_binop_2(A,B) = k3_binop_2(B,A) ) ).

fof(redefinition_k3_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => k3_binop_2(A,B) = k2_xcmplx_0(A,B) ) ).

fof(dt_k4_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => m1_subset_1(k4_binop_2(A,B),k2_numbers) ) ).

fof(redefinition_k4_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => k4_binop_2(A,B) = k6_xcmplx_0(A,B) ) ).

fof(dt_k5_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => m1_subset_1(k5_binop_2(A,B),k2_numbers) ) ).

fof(commutativity_k5_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => k5_binop_2(A,B) = k5_binop_2(B,A) ) ).

fof(redefinition_k5_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => k5_binop_2(A,B) = k3_xcmplx_0(A,B) ) ).

fof(dt_k6_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => m1_subset_1(k6_binop_2(A,B),k2_numbers) ) ).

fof(redefinition_k6_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k2_numbers)
        & m1_subset_1(B,k2_numbers) )
     => k6_binop_2(A,B) = k7_xcmplx_0(A,B) ) ).

fof(dt_k7_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k7_binop_2(A),k1_numbers) ) ).

fof(involutiveness_k7_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k7_binop_2(k7_binop_2(A)) = A ) ).

fof(redefinition_k7_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k7_binop_2(A) = k4_xcmplx_0(A) ) ).

fof(dt_k8_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => m1_subset_1(k8_binop_2(A),k1_numbers) ) ).

fof(involutiveness_k8_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k8_binop_2(k8_binop_2(A)) = A ) ).

fof(redefinition_k8_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_numbers)
     => k8_binop_2(A) = k5_xcmplx_0(A) ) ).

fof(dt_k9_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k9_binop_2(A,B),k1_numbers) ) ).

fof(commutativity_k9_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k9_binop_2(A,B) = k9_binop_2(B,A) ) ).

fof(redefinition_k9_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k9_binop_2(A,B) = k2_xcmplx_0(A,B) ) ).

fof(dt_k10_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k10_binop_2(A,B),k1_numbers) ) ).

fof(redefinition_k10_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k10_binop_2(A,B) = k6_xcmplx_0(A,B) ) ).

fof(dt_k11_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k11_binop_2(A,B),k1_numbers) ) ).

fof(commutativity_k11_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k11_binop_2(A,B) = k11_binop_2(B,A) ) ).

fof(redefinition_k11_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k11_binop_2(A,B) = k3_xcmplx_0(A,B) ) ).

fof(dt_k12_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => m1_subset_1(k12_binop_2(A,B),k1_numbers) ) ).

fof(redefinition_k12_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k1_numbers)
        & m1_subset_1(B,k1_numbers) )
     => k12_binop_2(A,B) = k7_xcmplx_0(A,B) ) ).

fof(dt_k13_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k3_numbers)
     => m1_subset_1(k13_binop_2(A),k3_numbers) ) ).

fof(involutiveness_k13_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k3_numbers)
     => k13_binop_2(k13_binop_2(A)) = A ) ).

fof(redefinition_k13_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k3_numbers)
     => k13_binop_2(A) = k4_xcmplx_0(A) ) ).

fof(dt_k14_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k3_numbers)
     => m1_subset_1(k14_binop_2(A),k3_numbers) ) ).

fof(involutiveness_k14_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k3_numbers)
     => k14_binop_2(k14_binop_2(A)) = A ) ).

fof(redefinition_k14_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k3_numbers)
     => k14_binop_2(A) = k5_xcmplx_0(A) ) ).

fof(dt_k15_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => m1_subset_1(k15_binop_2(A,B),k3_numbers) ) ).

fof(commutativity_k15_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => k15_binop_2(A,B) = k15_binop_2(B,A) ) ).

fof(redefinition_k15_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => k15_binop_2(A,B) = k2_xcmplx_0(A,B) ) ).

fof(dt_k16_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => m1_subset_1(k16_binop_2(A,B),k3_numbers) ) ).

fof(redefinition_k16_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => k16_binop_2(A,B) = k6_xcmplx_0(A,B) ) ).

fof(dt_k17_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => m1_subset_1(k17_binop_2(A,B),k3_numbers) ) ).

fof(commutativity_k17_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => k17_binop_2(A,B) = k17_binop_2(B,A) ) ).

fof(redefinition_k17_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => k17_binop_2(A,B) = k3_xcmplx_0(A,B) ) ).

fof(dt_k18_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => m1_subset_1(k18_binop_2(A,B),k3_numbers) ) ).

fof(redefinition_k18_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k3_numbers)
        & m1_subset_1(B,k3_numbers) )
     => k18_binop_2(A,B) = k7_xcmplx_0(A,B) ) ).

fof(dt_k19_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k4_numbers)
     => m1_subset_1(k19_binop_2(A),k4_numbers) ) ).

fof(involutiveness_k19_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k4_numbers)
     => k19_binop_2(k19_binop_2(A)) = A ) ).

fof(redefinition_k19_binop_2,axiom,
    ! [A] :
      ( m1_subset_1(A,k4_numbers)
     => k19_binop_2(A) = k4_xcmplx_0(A) ) ).

fof(dt_k20_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => m1_subset_1(k20_binop_2(A,B),k4_numbers) ) ).

fof(commutativity_k20_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => k20_binop_2(A,B) = k20_binop_2(B,A) ) ).

fof(redefinition_k20_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => k20_binop_2(A,B) = k2_xcmplx_0(A,B) ) ).

fof(dt_k21_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => m1_subset_1(k21_binop_2(A,B),k4_numbers) ) ).

fof(redefinition_k21_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => k21_binop_2(A,B) = k6_xcmplx_0(A,B) ) ).

fof(dt_k22_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => m1_subset_1(k22_binop_2(A,B),k4_numbers) ) ).

fof(commutativity_k22_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => k22_binop_2(A,B) = k22_binop_2(B,A) ) ).

fof(redefinition_k22_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k4_numbers)
        & m1_subset_1(B,k4_numbers) )
     => k22_binop_2(A,B) = k3_xcmplx_0(A,B) ) ).

fof(dt_k23_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => m2_subset_1(k23_binop_2(A,B),k1_numbers,k5_numbers) ) ).

fof(commutativity_k23_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k23_binop_2(A,B) = k23_binop_2(B,A) ) ).

fof(redefinition_k23_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k23_binop_2(A,B) = k2_xcmplx_0(A,B) ) ).

fof(dt_k24_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => m2_subset_1(k24_binop_2(A,B),k1_numbers,k5_numbers) ) ).

fof(commutativity_k24_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k24_binop_2(A,B) = k24_binop_2(B,A) ) ).

fof(redefinition_k24_binop_2,axiom,
    ! [A,B] :
      ( ( m1_subset_1(A,k5_numbers)
        & m1_subset_1(B,k5_numbers) )
     => k24_binop_2(A,B) = k3_xcmplx_0(A,B) ) ).

fof(dt_k25_binop_2,axiom,
    ( v1_funct_1(k25_binop_2)
    & v1_funct_2(k25_binop_2,k2_numbers,k2_numbers)
    & m2_relset_1(k25_binop_2,k2_numbers,k2_numbers) ) ).

fof(dt_k26_binop_2,axiom,
    ( v1_funct_1(k26_binop_2)
    & v1_funct_2(k26_binop_2,k2_numbers,k2_numbers)
    & m2_relset_1(k26_binop_2,k2_numbers,k2_numbers) ) ).

fof(dt_k27_binop_2,axiom,
    ( v1_funct_1(k27_binop_2)
    & v1_funct_2(k27_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & m2_relset_1(k27_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) ) ).

fof(dt_k28_binop_2,axiom,
    ( v1_funct_1(k28_binop_2)
    & v1_funct_2(k28_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & m2_relset_1(k28_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) ) ).

fof(dt_k29_binop_2,axiom,
    ( v1_funct_1(k29_binop_2)
    & v1_funct_2(k29_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & m2_relset_1(k29_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) ) ).

fof(dt_k30_binop_2,axiom,
    ( v1_funct_1(k30_binop_2)
    & v1_funct_2(k30_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers)
    & m2_relset_1(k30_binop_2,k2_zfmisc_1(k2_numbers,k2_numbers),k2_numbers) ) ).

fof(dt_k31_binop_2,axiom,
    ( v1_funct_1(k31_binop_2)
    & v1_funct_2(k31_binop_2,k1_numbers,k1_numbers)
    & m2_relset_1(k31_binop_2,k1_numbers,k1_numbers) ) ).

fof(dt_k32_binop_2,axiom,
    ( v1_funct_1(k32_binop_2)
    & v1_funct_2(k32_binop_2,k1_numbers,k1_numbers)
    & m2_relset_1(k32_binop_2,k1_numbers,k1_numbers) ) ).

fof(dt_k33_binop_2,axiom,
    ( v1_funct_1(k33_binop_2)
    & v1_funct_2(k33_binop_2,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers)
    & m2_relset_1(k33_binop_2,k2_zfmisc_1(k1_numbers,k1_numbers),k1_numbers) ) ).

fof(dt_k34_binop_2,axiom,
    ( v1_funct_1(k34_binop_2)
    & v1_funct_2(k34_binop_2,k2_zfmisc_1(k1_numbers,k1_numbers)