%------------------------------------------------------------------------------
% File     : CSR212+1 : TPTP v9.0.0. Released v7.3.0.
% Domain   : Common Sense Reasoning
% Problem  : Agent relation 0444
% Version  : Especial.
% English  :

% Refs     : [ALR12] Alvez et al. (2012), Adimen-SUMO: Reengineering an Ont
%          : [AGR18] Alvez et al. (2018), Cross-checking WordNet and SUMO U
%          : [Alv18] Alvez, J. (2018), Email to Geoff Sutcliffe
% Source   : [Alv18]
% Names    : agentRelation0444 [Alv18]

% Status   : Theorem
% Rating   : 0.94 v8.1.0, 0.92 v7.5.0, 0.91 v7.4.0, 0.97 v7.3.0
% Syntax   : Number of formulae    : 7433 (4642 unt;   0 def)
%            Number of atoms       : 16529 ( 372 equ)
%            Maximal formula atoms :   50 (   2 avg)
%            Number of connectives : 9471 ( 375   ~; 270   |;5288   &)
%                                         ( 709 <=>;2829  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   30 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  607 ( 606 usr;   0 prp; 1-7 aty)
%            Number of functors    : 3311 (3311 usr;3238 con; 0-4 aty)
%            Number of variables   : 6727 (5553   !;1174   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Work done by Javier Alvez, Paqui Lucio and German Rigau, of
%            IXA & LoRea Groups, University of the Basque Country UPV/EHU.
%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(predefinitionsA7,axiom,
    ! [X] : p__d__subclass(X,X) ).

fof(predefinitionsA8,axiom,
    ! [X,Y,Z] :
      ( ( p__d__subclass(X,Y)
        & p__d__subclass(Y,Z) )
     => p__d__subclass(X,Z) ) ).

fof(predefinitionsA9,axiom,
    ! [X,Y] :
      ( ( p__d__subclass(X,Y)
        & p__d__subclass(Y,X) )
     => X = Y ) ).

fof(predefinitionsA12,axiom,
    ! [X,Y,Z] :
      ( ( p__d__instance(X,Y)
        & p__d__subclass(Y,Z) )
     => p__d__instance(X,Z) ) ).

fof(predefinitionsA15,axiom,
    ! [CLASS1,CLASS2] :
      ( p__d__disjoint(CLASS1,CLASS2)
    <=> ! [INST] :
          ( ~ p__d__instance(INST,CLASS1)
          | ~ p__d__instance(INST,CLASS2) ) ) ).

fof(predefinitionsA18,axiom,
    ( ! [CLASS,ROW1,ROW2] :
        ( p__d__partition3(CLASS,ROW1,ROW2)
      <=> ( p__d__exhaustiveDecomposition3(CLASS,ROW1,ROW2)
          & p__d__disjointDecomposition3(CLASS,ROW1,ROW2) ) )
    & ! [CLASS,ROW1,ROW2,ROW3] :
        ( p__d__partition4(CLASS,ROW1,ROW2,ROW3)
      <=> ( p__d__exhaustiveDecomposition4(CLASS,ROW1,ROW2,ROW3)
          & p__d__disjointDecomposition4(CLASS,ROW1,ROW2,ROW3) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4] :
        ( p__d__partition5(CLASS,ROW1,ROW2,ROW3,ROW4)
      <=> ( p__d__exhaustiveDecomposition5(CLASS,ROW1,ROW2,ROW3,ROW4)
          & p__d__disjointDecomposition5(CLASS,ROW1,ROW2,ROW3,ROW4) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4,ROW5] :
        ( p__d__partition6(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5)
      <=> ( p__d__exhaustiveDecomposition6(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5)
          & p__d__disjointDecomposition6(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6] :
        ( p__d__partition7(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6)
      <=> ( p__d__exhaustiveDecomposition7(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6)
          & p__d__disjointDecomposition7(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6) ) ) ) ).

fof(predefinitionsA21,axiom,
    ( ! [CLASS,ROW1,ROW2] :
        ( p__d__exhaustiveDecomposition3(CLASS,ROW1,ROW2)
      <=> ! [X] :
            ( p__d__instance(X,CLASS)
           => ( p__d__instance(X,ROW1)
              | p__d__instance(X,ROW2) ) ) )
    & ! [CLASS,ROW1,ROW2,ROW3] :
        ( p__d__exhaustiveDecomposition4(CLASS,ROW1,ROW2,ROW3)
      <=> ! [X] :
            ( p__d__instance(X,CLASS)
           => ( p__d__instance(X,ROW1)
              | p__d__instance(X,ROW2)
              | p__d__instance(X,ROW3) ) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4] :
        ( p__d__exhaustiveDecomposition5(CLASS,ROW1,ROW2,ROW3,ROW4)
      <=> ! [X] :
            ( p__d__instance(X,CLASS)
           => ( p__d__instance(X,ROW1)
              | p__d__instance(X,ROW2)
              | p__d__instance(X,ROW3)
              | p__d__instance(X,ROW4) ) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4,ROW5] :
        ( p__d__exhaustiveDecomposition6(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5)
      <=> ! [X] :
            ( p__d__instance(X,CLASS)
           => ( p__d__instance(X,ROW1)
              | p__d__instance(X,ROW2)
              | p__d__instance(X,ROW3)
              | p__d__instance(X,ROW4)
              | p__d__instance(X,ROW5) ) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6] :
        ( p__d__exhaustiveDecomposition7(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6)
      <=> ! [X] :
            ( p__d__instance(X,CLASS)
           => ( p__d__instance(X,ROW1)
              | p__d__instance(X,ROW2)
              | p__d__instance(X,ROW3)
              | p__d__instance(X,ROW4)
              | p__d__instance(X,ROW5)
              | p__d__instance(X,ROW6) ) ) ) ) ).

fof(predefinitionsA24,axiom,
    ( ! [CLASS,ROW1,ROW2] :
        ( p__d__disjointDecomposition3(CLASS,ROW1,ROW2)
      <=> p__d__disjoint(ROW1,ROW2) )
    & ! [CLASS,ROW1,ROW2,ROW3] :
        ( p__d__disjointDecomposition4(CLASS,ROW1,ROW2,ROW3)
      <=> ( p__d__disjoint(ROW1,ROW2)
          & p__d__disjoint(ROW1,ROW3)
          & p__d__disjoint(ROW2,ROW3) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4] :
        ( p__d__disjointDecomposition5(CLASS,ROW1,ROW2,ROW3,ROW4)
      <=> ( p__d__disjoint(ROW1,ROW2)
          & p__d__disjoint(ROW1,ROW3)
          & p__d__disjoint(ROW1,ROW4)
          & p__d__disjoint(ROW2,ROW3)
          & p__d__disjoint(ROW2,ROW4)
          & p__d__disjoint(ROW3,ROW4) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4,ROW5] :
        ( p__d__disjointDecomposition6(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5)
      <=> ( p__d__disjoint(ROW1,ROW2)
          & p__d__disjoint(ROW1,ROW3)
          & p__d__disjoint(ROW1,ROW4)
          & p__d__disjoint(ROW1,ROW5)
          & p__d__disjoint(ROW2,ROW3)
          & p__d__disjoint(ROW2,ROW4)
          & p__d__disjoint(ROW2,ROW5)
          & p__d__disjoint(ROW3,ROW4)
          & p__d__disjoint(ROW3,ROW5)
          & p__d__disjoint(ROW4,ROW5) ) )
    & ! [CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6] :
        ( p__d__disjointDecomposition7(CLASS,ROW1,ROW2,ROW3,ROW4,ROW5,ROW6)
      <=> ( p__d__disjoint(ROW1,ROW2)
          & p__d__disjoint(ROW1,ROW3)
          & p__d__disjoint(ROW1,ROW4)
          & p__d__disjoint(ROW1,ROW5)
          & p__d__disjoint(ROW1,ROW6)
          & p__d__disjoint(ROW2,ROW3)
          & p__d__disjoint(ROW2,ROW4)
          & p__d__disjoint(ROW2,ROW5)
          & p__d__disjoint(ROW2,ROW6)
          & p__d__disjoint(ROW3,ROW4)
          & p__d__disjoint(ROW3,ROW5)
          & p__d__disjoint(ROW3,ROW6)
          & p__d__disjoint(ROW4,ROW5)
          & p__d__disjoint(ROW4,ROW6)
          & p__d__disjoint(ROW5,ROW6) ) ) ) ).

fof(mergeA1,axiom,
    p__d__instance(c__instance,c__BinaryPredicate) ).

fof(mergeA4,axiom,
    p__subrelation(c__immediateInstance,c__instance) ).

fof(mergeA5,axiom,
    p__d__instance(c__immediateInstance,c__AsymmetricRelation) ).

fof(mergeA6,axiom,
    p__d__instance(c__immediateInstance,c__IntransitiveRelation) ).

fof(mergeA7,axiom,
    ! [CLASS,ENTITY] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__immediateInstance(ENTITY,CLASS) )
     => ! [SUBCLASS] :
          ( ~ p__d__instance(SUBCLASS,c__SetOrClass)
          | ~ p__subclass(SUBCLASS,CLASS)
          | SUBCLASS = CLASS
          | ~ p__instance(ENTITY,SUBCLASS) ) ) ).

fof(mergeA8,axiom,
    p__d__instance(c__inverse,c__BinaryPredicate) ).

fof(mergeA9,axiom,
    p__d__instance(c__inverse,c__IrreflexiveRelation) ).

fof(mergeA10,axiom,
    p__d__instance(c__inverse,c__IntransitiveRelation) ).

fof(mergeA11,axiom,
    p__d__instance(c__inverse,c__SymmetricRelation) ).

fof(mergeA14,axiom,
    ! [REL1,REL2,INST1,INST2] :
      ( ( p__d__instance(REL2,c__BinaryRelation)
        & p__d__instance(REL1,c__BinaryRelation)
        & p__inverse(REL1,REL2) )
     => ( p__d__holds3(REL1,INST1,INST2)
      <=> p__d__holds3(REL2,INST2,INST1) ) ) ).

fof(mergeA15,axiom,
    p__d__instance(c__subclass,c__BinaryPredicate) ).

fof(mergeA16,axiom,
    p__d__instance(c__subclass,c__PartialOrderingRelation) ).

fof(mergeA20,axiom,
    ! [X,Z,Y] :
      ( ( p__d__instance(Y,c__SetOrClass)
        & p__d__instance(X,c__SetOrClass)
        & p__subclass(X,Y)
        & p__instance(Z,X) )
     => p__instance(Z,Y) ) ).

fof(mergeA21,axiom,
    p__subrelation(c__immediateSubclass,c__subclass) ).

fof(mergeA22,axiom,
    p__d__instance(c__immediateSubclass,c__AsymmetricRelation) ).

fof(mergeA23,axiom,
    p__d__instance(c__immediateSubclass,c__IntransitiveRelation) ).

fof(mergeA24,axiom,
    ! [CLASS2,CLASS1] :
      ( ( p__d__instance(CLASS2,c__SetOrClass)
        & p__d__instance(CLASS1,c__SetOrClass)
        & p__immediateSubclass(CLASS1,CLASS2) )
     => ! [CLASS3] :
          ( ~ p__d__instance(CLASS3,c__SetOrClass)
          | ~ p__subclass(CLASS3,CLASS2)
          | ~ p__subclass(CLASS1,CLASS3)
          | CLASS2 = CLASS3
          | CLASS1 = CLASS3 ) ) ).

fof(mergeA25,axiom,
    p__d__instance(c__subrelation,c__BinaryPredicate) ).

fof(mergeA26,axiom,
    p__d__instance(c__subrelation,c__PartialOrderingRelation) ).

fof(mergeA29,axiom,
    ! [PRED1,PRED2,NUMBER] :
      ( ( p__d__instance(PRED2,c__Relation)
        & p__d__instance(PRED1,c__Relation)
        & p__d__instance(NUMBER,c__PositiveInteger)
        & p__subrelation(PRED1,PRED2)
        & p__valence(PRED1,NUMBER) )
     => p__valence(PRED2,NUMBER) ) ).

fof(mergeA30,axiom,
    ! [REL1,REL2] :
      ( ( p__subrelation(REL1,REL2)
        & p__d__instance(REL2,c__BinaryRelation) )
     => ( p__d__instance(REL1,c__BinaryRelation)
        & ! [INST1,INST2] :
            ( p__d__holds3(REL1,INST1,INST2)
           => p__d__holds3(REL2,INST1,INST2) ) ) ) ).

fof(mergeA31,axiom,
    ! [REL1,REL2] :
      ( ( p__subrelation(REL1,REL2)
        & p__d__instance(REL2,c__TernaryRelation) )
     => ( p__d__instance(REL1,c__TernaryRelation)
        & ! [INST1,INST2,INST3] :
            ( p__d__holds4(REL1,INST1,INST2,INST3)
           => p__d__holds4(REL2,INST1,INST2,INST3) ) ) ) ).

fof(mergeA32,axiom,
    ! [REL1,REL2] :
      ( ( p__subrelation(REL1,REL2)
        & p__d__instance(REL2,c__QuaternaryRelation) )
     => ( p__d__instance(REL1,c__QuaternaryRelation)
        & ! [INST1,INST2,INST3,INST4] :
            ( p__d__holds5(REL1,INST1,INST2,INST3,INST4)
           => p__d__holds5(REL2,INST1,INST2,INST3,INST4) ) ) ) ).

fof(mergeA33,axiom,
    ! [REL1,REL2] :
      ( ( p__subrelation(REL1,REL2)
        & p__d__instance(REL2,c__QuintaryRelation) )
     => ( p__d__instance(REL1,c__QuintaryRelation)
        & ! [INST1,INST2,INST3,INST4,INST5] :
            ( p__d__holds6(REL1,INST1,INST2,INST3,INST4,INST5)
           => p__d__holds6(REL2,INST1,INST2,INST3,INST4,INST5) ) ) ) ).

fof(mergeA34,axiom,
    ! [CLASS,PRED1,PRED2] :
      ( ( p__subrelation(PRED1,PRED2)
        & p__d__instance(PRED2,CLASS)
        & p__d__instance(CLASS,c__InheritableRelation) )
     => p__d__instance(PRED1,CLASS) ) ).

fof(mergeA35,axiom,
    p__d__instance(c__domain,c__TernaryPredicate) ).

fof(mergeA39,axiom,
    p__d__instance(c__domainSubclass,c__TernaryPredicate) ).

fof(mergeA43,axiom,
    p__d__instance(c__equal,c__BinaryPredicate) ).

fof(mergeA44,axiom,
    p__d__instance(c__equal,c__EquivalenceRelation) ).

fof(mergeA45,axiom,
    p__d__instance(c__equal,c__RelationExtendedToQuantities) ).

fof(mergeA48,axiom,
    p__d__instance(c__range,c__BinaryPredicate) ).

fof(mergeA49,axiom,
    p__d__instance(c__range,c__AsymmetricRelation) ).

fof(mergeA52,axiom,
    p__d__instance(c__rangeSubclass,c__BinaryPredicate) ).

fof(mergeA53,axiom,
    p__d__instance(c__rangeSubclass,c__AsymmetricRelation) ).

fof(mergeA56,axiom,
    p__d__instance(c__valence,c__BinaryPredicate) ).

fof(mergeA57,axiom,
    p__d__instance(c__valence,c__AsymmetricRelation) ).

fof(mergeA58,axiom,
    p__d__instance(c__valence,c__SingleValuedRelation) ).

fof(mergeA61,axiom,
    p__d__instance(c__documentation,c__TernaryPredicate) ).

fof(mergeA65,axiom,
    p__d__instance(c__format,c__TernaryPredicate) ).

fof(mergeA69,axiom,
    p__d__instance(c__termFormat,c__TernaryPredicate) ).

fof(mergeA73,axiom,
    p__d__instance(c__disjoint,c__BinaryPredicate) ).

fof(mergeA74,axiom,
    p__d__instance(c__disjoint,c__SymmetricRelation) ).

fof(mergeA77,axiom,
    ! [CLASS1,CLASS2] :
      ( ( p__d__instance(CLASS2,c__SetOrClass)
        & p__d__instance(CLASS1,c__SetOrClass) )
     => ( p__disjoint(CLASS1,CLASS2)
      <=> ! [INST] :
            ( ~ p__instance(INST,CLASS1)
            | ~ p__instance(INST,CLASS2) ) ) ) ).

fof(mergeA78,axiom,
    p__d__instance(c__disjointRelation,c__BinaryPredicate) ).

fof(mergeA79,axiom,
    p__d__instance(c__disjointRelation,c__IrreflexiveRelation) ).

fof(mergeA82,axiom,
    p__relatedInternalConcept(c__disjointRelation,c__disjoint) ).

fof(mergeA83,axiom,
    ! [INST1,INST2,REL1,REL2] :
      ( ( p__d__instance(REL1,c__BinaryRelation)
        & p__d__instance(REL2,c__BinaryRelation)
        & p__disjointRelation(REL1,REL2) )
     => ( ~ p__d__holds3(REL1,INST1,INST2)
        | ~ p__d__holds3(REL2,INST1,INST2) ) ) ).

fof(mergeA84,axiom,
    ! [INST1,INST2,INST3,REL1,REL2] :
      ( ( p__d__instance(REL1,c__TernaryRelation)
        & p__d__instance(REL2,c__TernaryRelation)
        & p__disjointRelation(REL1,REL2) )
     => ( ~ p__d__holds4(REL1,INST1,INST2,INST3)
        | ~ p__d__holds4(REL2,INST1,INST2,INST3) ) ) ).

fof(mergeA85,axiom,
    ! [INST1,INST2,INST3,INST4,REL1,REL2] :
      ( ( p__d__instance(REL1,c__QuaternaryRelation)
        & p__d__instance(REL2,c__QuaternaryRelation)
        & p__disjointRelation(REL1,REL2) )
     => ( ~ p__d__holds5(REL1,INST1,INST2,INST3,INST4)
        | ~ p__d__holds5(REL2,INST1,INST2,INST3,INST4) ) ) ).

fof(mergeA86,axiom,
    ! [INST1,INST2,INST3,INST4,INST5,REL1,REL2] :
      ( ( p__d__instance(REL1,c__QuintaryRelation)
        & p__d__instance(REL2,c__QuintaryRelation)
        & p__disjointRelation(REL1,REL2) )
     => ( ~ p__d__holds6(REL1,INST1,INST2,INST3,INST4,INST5)
        | ~ p__d__holds6(REL2,INST1,INST2,INST3,INST4,INST5) ) ) ).

fof(mergeA87,axiom,
    p__d__instance(c__contraryAttribute,c__Predicate) ).

fof(mergeA88,axiom,
    p__d__instance(c__contraryAttribute,c__VariableArityRelation) ).

fof(mergeA90,axiom,
    ( ! [ROW1,ROW2] :
        ( ( p__d__instance(ROW2,c__Attribute)
          & p__d__instance(ROW1,c__Attribute) )
       => ( p__contraryAttribute2(ROW1,ROW2)
        <=> ( ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW1) )
               => ~ p__attribute(OBJ,ROW2) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW2) )
               => ~ p__attribute(OBJ,ROW1) ) ) ) )
    & ! [ROW1,ROW2,ROW3,ROW4] :
        ( ( p__d__instance(ROW4,c__Attribute)
          & p__d__instance(ROW3,c__Attribute)
          & p__d__instance(ROW2,c__Attribute)
          & p__d__instance(ROW1,c__Attribute) )
       => ( p__contraryAttribute4(ROW1,ROW2,ROW3,ROW4)
        <=> ( ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW1) )
               => ~ p__attribute(OBJ,ROW2) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW2) )
               => ~ p__attribute(OBJ,ROW1) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW1) )
               => ~ p__attribute(OBJ,ROW3) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW3) )
               => ~ p__attribute(OBJ,ROW1) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW1) )
               => ~ p__attribute(OBJ,ROW4) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW4) )
               => ~ p__attribute(OBJ,ROW1) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW2) )
               => ~ p__attribute(OBJ,ROW3) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW3) )
               => ~ p__attribute(OBJ,ROW2) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW2) )
               => ~ p__attribute(OBJ,ROW4) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW4) )
               => ~ p__attribute(OBJ,ROW2) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW3) )
               => ~ p__attribute(OBJ,ROW4) )
            & ! [OBJ] :
                ( ( p__d__instance(OBJ,c__Object)
                  & p__attribute(OBJ,ROW4) )
               => ~ p__attribute(OBJ,ROW3) ) ) ) ) ) ).

fof(mergeA94,axiom,
    p__d__instance(c__exhaustiveAttribute,c__Predicate) ).

fof(mergeA95,axiom,
    p__d__instance(c__exhaustiveAttribute,c__VariableArityRelation) ).

fof(mergeA98,axiom,
    ( ! [ATTR,ROW1,ROW2] :
        ( ( p__d__instance(ROW2,c__Attribute)
          & p__d__instance(ROW1,c__Attribute)
          & p__d__instance(ATTR,c__Attribute) )
       => ( p__exhaustiveAttribute3(ATTR,ROW1,ROW2)
        <=> ! [OBJ] :
              ( ( p__d__instance(OBJ,c__Object)
                & p__attribute(OBJ,ATTR) )
             => ( p__attribute(OBJ,ROW1)
                | p__attribute(OBJ,ROW2) ) ) ) )
    & ! [ATTR,ROW1,ROW2,ROW3,ROW4,ROW5] :
        ( ( p__d__instance(ROW5,c__Attribute)
          & p__d__instance(ROW4,c__Attribute)
          & p__d__instance(ROW3,c__Attribute)
          & p__d__instance(ROW2,c__Attribute)
          & p__d__instance(ROW1,c__Attribute)
          & p__d__instance(ATTR,c__Attribute) )
       => ( p__exhaustiveAttribute6(ATTR,ROW1,ROW2,ROW3,ROW4,ROW5)
        <=> ! [OBJ] :
              ( ( p__d__instance(OBJ,c__Object)
                & p__attribute(OBJ,ATTR) )
             => ( p__attribute(OBJ,ROW1)
                | p__attribute(OBJ,ROW2)
                | p__attribute(OBJ,ROW3)
                | p__attribute(OBJ,ROW4)
                | p__attribute(OBJ,ROW5) ) ) ) ) ) ).

fof(mergeA102,axiom,
    p__d__instance(c__exhaustiveDecomposition,c__Predicate) ).

fof(mergeA103,axiom,
    p__d__instance(c__exhaustiveDecomposition,c__VariableArityRelation) ).

fof(mergeA105,axiom,
    p__relatedInternalConcept(c__exhaustiveDecomposition,c__partition) ).

fof(mergeA107,axiom,
    p__d__instance(c__disjointDecomposition,c__Predicate) ).

fof(mergeA108,axiom,
    p__d__instance(c__disjointDecomposition,c__VariableArityRelation) ).

fof(mergeA110,axiom,
    p__relatedInternalConcept(c__disjointDecomposition,c__exhaustiveDecomposition) ).

fof(mergeA111,axiom,
    p__relatedInternalConcept(c__disjointDecomposition,c__disjoint) ).

fof(mergeA113,axiom,
    p__d__instance(c__partition,c__Predicate) ).

fof(mergeA114,axiom,
    p__d__instance(c__partition,c__VariableArityRelation) ).

fof(mergeA117,axiom,
    p__d__instance(c__relatedInternalConcept,c__BinaryPredicate) ).

fof(mergeA118,axiom,
    p__d__instance(c__relatedInternalConcept,c__EquivalenceRelation) ).

fof(mergeA121,axiom,
    p__d__instance(c__relatedExternalConcept,c__TernaryPredicate) ).

fof(mergeA125,axiom,
    p__relatedInternalConcept(c__relatedExternalConcept,c__relatedInternalConcept) ).

fof(mergeA126,axiom,
    p__subrelation(c__synonymousExternalConcept,c__relatedExternalConcept) ).

fof(mergeA127,axiom,
    p__disjointRelation(c__synonymousExternalConcept,c__subsumedExternalConcept) ).

fof(mergeA128,axiom,
    p__disjointRelation(c__synonymousExternalConcept,c__subsumingExternalConcept) ).

fof(mergeA129,axiom,
    p__disjointRelation(c__subsumedExternalConcept,c__subsumingExternalConcept) ).

fof(mergeA130,axiom,
    p__subrelation(c__subsumingExternalConcept,c__relatedExternalConcept) ).

fof(mergeA131,axiom,
    p__subrelation(c__subsumedExternalConcept,c__relatedExternalConcept) ).

fof(mergeA132,axiom,
    p__d__instance(c__externalImage,c__BinaryPredicate) ).

fof(mergeA135,axiom,
    p__d__instance(c__subAttribute,c__BinaryPredicate) ).

fof(mergeA136,axiom,
    p__d__instance(c__subAttribute,c__PartialOrderingRelation) ).

fof(mergeA139,axiom,
    p__disjointRelation(c__subAttribute,c__successorAttribute) ).

fof(mergeA140,axiom,
    ! [ATTR1,ATTR2,OBJ] :
      ( ( p__d__instance(ATTR2,c__Attribute)
        & p__d__instance(ATTR1,c__Attribute)
        & p__d__instance(OBJ,c__Object)
        & p__subAttribute(ATTR1,ATTR2)
        & p__attribute(OBJ,ATTR1) )
     => p__attribute(OBJ,ATTR2) ) ).

fof(mergeA141,axiom,
    ! [CLASS,ATTR1,ATTR2] :
      ( ( p__subAttribute(ATTR1,ATTR2)
        & p__d__instance(ATTR2,CLASS) )
     => p__d__instance(ATTR1,CLASS) ) ).

fof(mergeA142,axiom,
    p__d__instance(c__successorAttribute,c__BinaryPredicate) ).

fof(mergeA143,axiom,
    p__d__instance(c__successorAttribute,c__AsymmetricRelation) ).

fof(mergeA147,axiom,
    p__d__instance(c__successorAttributeClosure,c__BinaryPredicate) ).

fof(mergeA148,axiom,
    p__d__instance(c__successorAttributeClosure,c__TransitiveRelation) ).

fof(mergeA149,axiom,
    p__d__instance(c__successorAttributeClosure,c__IrreflexiveRelation) ).

fof(mergeA152,axiom,
    p__relatedInternalConcept(c__successorAttributeClosure,c__successorAttribute) ).

fof(mergeA153,axiom,
    ! [ATTR1,ATTR2] :
      ( ( p__d__instance(ATTR2,c__Attribute)
        & p__d__instance(ATTR1,c__Attribute)
        & p__successorAttribute(ATTR1,ATTR2) )
     => p__successorAttributeClosure(ATTR1,ATTR2) ) ).

fof(mergeA154,axiom,
    p__d__instance(c__greaterThanByQuality,c__TernaryPredicate) ).

fof(mergeA158,axiom,
    ! [E2,E1,E3,ATT] :
      ( ( p__d__instance(ATT,c__Attribute)
        & p__greaterThanByQuality(E1,E2,ATT)
        & p__greaterThanByQuality(E2,E3,ATT) )
     => p__greaterThanByQuality(E1,E3,ATT) ) ).

fof(mergeA159,axiom,
    ! [E2,E1,ATT] :
      ( ( p__d__instance(ATT,c__Attribute)
        & p__greaterThanByQuality(E1,E2,ATT) )
     => ~ p__greaterThanByQuality(E2,E1,ATT) ) ).

fof(mergeA160,axiom,
    ! [ATT,E2,E1] :
      ( ( p__d__instance(ATT,c__Attribute)
        & p__greaterThanByQuality(E1,E2,ATT) )
     => E2 != E1 ) ).

fof(mergeA161,axiom,
    p__d__instance(c__entails,c__BinaryPredicate) ).

fof(mergeA164,axiom,
    p__d__instance(c__AssignmentFn,c__Function) ).

fof(mergeA165,axiom,
    p__d__instance(c__AssignmentFn,c__VariableArityRelation) ).

fof(mergeA168,axiom,
    p__d__instance(c__PowerSetFn,c__UnaryFunction) ).

fof(mergeA169,axiom,
    p__d__instance(c__PowerSetFn,c__TotalValuedRelation) ).

fof(mergeA172,axiom,
    p__d__topClass(c__Entity) ).

fof(mergeA173,axiom,
    p__d__partition3(c__Entity,c__Physical,c__Abstract) ).

fof(mergeA174,axiom,
    ! [THING] : p__d__instance(THING,c__Entity) ).

fof(mergeA175,axiom,
    ? [THING] : p__d__instance(THING,c__Entity) ).

fof(mergeA176,axiom,
    ! [CLASS] :
      ( p__d__subclass(CLASS,c__Entity)
     => ? [THING] : p__d__instance(THING,CLASS) ) ).

fof(mergeA177,axiom,
    ! [CLASS] :
      ( p__d__instance(CLASS,c__Class)
    <=> p__d__subclass(CLASS,c__Entity) ) ).

fof(mergeA178,axiom,
    p__d__subclass(c__Physical,c__Entity) ).

fof(mergeA179,axiom,
    p__d__partition3(c__Physical,c__Object,c__Process) ).

fof(mergeA180,axiom,
    ! [PHYS] :
      ( p__d__instance(PHYS,c__Physical)
     => ? [LOC,TIME] :
          ( p__d__instance(LOC,c__Object)
          & p__d__instance(TIME,c__TimePosition)
          & p__located(PHYS,LOC)
          & p__time(PHYS,TIME) ) ) ).

fof(mergeA181,axiom,
    p__d__subclass(c__Object,c__Physical) ).

fof(mergeA182,axiom,
    p__d__subclass(c__SelfConnectedObject,c__Object) ).

fof(mergeA183,axiom,
    p__d__subclass(c__OrganicThing,c__SelfConnectedObject) ).

fof(mergeA184,axiom,
    p__d__instance(c__FrontFn,c__SpatialRelation) ).

fof(mergeA185,axiom,
    p__d__instance(c__FrontFn,c__PartialValuedRelation) ).

fof(mergeA186,axiom,
    p__d__instance(c__FrontFn,c__UnaryFunction) ).

fof(mergeA187,axiom,
    p__d__instance(c__FrontFn,c__AsymmetricRelation) ).

fof(mergeA188,axiom,
    p__d__instance(c__FrontFn,c__IrreflexiveRelation) ).

fof(mergeA191,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__SelfConnectedObject)
     => p__side(f__FrontFn1(OBJ),OBJ) ) ).

fof(mergeA192,axiom,
    p__d__instance(c__BackFn,c__SpatialRelation) ).

fof(mergeA193,axiom,
    p__d__instance(c__BackFn,c__PartialValuedRelation) ).

fof(mergeA194,axiom,
    p__d__instance(c__BackFn,c__UnaryFunction) ).

fof(mergeA195,axiom,
    p__d__instance(c__BackFn,c__AsymmetricRelation) ).

fof(mergeA196,axiom,
    p__d__instance(c__BackFn,c__IrreflexiveRelation) ).

fof(mergeA199,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__SelfConnectedObject)
     => p__side(f__BackFn1(OBJ),OBJ) ) ).

fof(mergeA200,axiom,
    p__d__instance(c__part,c__SpatialRelation) ).

fof(mergeA201,axiom,
    p__d__instance(c__part,c__PartialOrderingRelation) ).

fof(mergeA204,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__part(OBJ1,OBJ2)
      <=> ! [PART] :
            ( ( p__d__instance(PART,c__Object)
              & p__overlapsSpatially(PART,OBJ1) )
           => p__overlapsSpatially(PART,OBJ2) ) ) ) ).

fof(mergeA205,axiom,
    p__d__instance(c__properPart,c__AsymmetricRelation) ).

fof(mergeA206,axiom,
    p__d__instance(c__properPart,c__TransitiveRelation) ).

fof(mergeA207,axiom,
    p__subrelation(c__properPart,c__part) ).

fof(mergeA208,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__properPart(OBJ1,OBJ2)
      <=> ( p__part(OBJ1,OBJ2)
          & ~ p__part(OBJ2,OBJ1) ) ) ) ).

fof(mergeA209,axiom,
    p__subrelation(c__piece,c__part) ).

fof(mergeA212,axiom,
    ! [SUBSTANCE1,SUBSTANCE2,CLASS] :
      ( ( p__d__instance(SUBSTANCE2,c__Substance)
        & p__d__instance(SUBSTANCE1,c__Substance)
        & p__piece(SUBSTANCE1,SUBSTANCE2)
        & p__d__instance(SUBSTANCE1,CLASS) )
     => p__d__instance(SUBSTANCE2,CLASS) ) ).

fof(mergeA213,axiom,
    p__subrelation(c__component,c__part) ).

fof(mergeA216,axiom,
    p__d__instance(c__material,c__BinaryPredicate) ).

fof(mergeA219,axiom,
    p__subrelation(c__contains,c__partlyLocated) ).

fof(mergeA220,axiom,
    p__d__instance(c__contains,c__SpatialRelation) ).

fof(mergeA221,axiom,
    p__d__instance(c__contains,c__AsymmetricRelation) ).

fof(mergeA222,axiom,
    p__disjointRelation(c__contains,c__part) ).

fof(mergeA225,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__SelfConnectedObject) )
     => ( p__contains(OBJ1,OBJ2)
      <=> ? [HOLE] :
            ( p__d__instance(HOLE,c__Hole)
            & p__hole(HOLE,OBJ1)
            & p__properlyFills(OBJ2,HOLE) ) ) ) ).

fof(mergeA226,axiom,
    p__d__subclass(c__Substance,c__SelfConnectedObject) ).

fof(mergeA227,axiom,
    p__d__partition3(c__Substance,c__PureSubstance,c__Mixture) ).

fof(mergeA228,axiom,
    p__d__partition3(c__Substance,c__SyntheticSubstance,c__NaturalSubstance) ).

fof(mergeA229,axiom,
    ! [OBJ,PART,ATTR] :
      ( ( p__d__instance(ATTR,c__Attribute)
        & p__d__instance(PART,c__Object)
        & p__d__instance(OBJ,c__Substance)
        & p__attribute(OBJ,ATTR)
        & p__part(PART,OBJ) )
     => p__attribute(PART,ATTR) ) ).

fof(mergeA230,axiom,
    p__d__subclass(c__SyntheticSubstance,c__Substance) ).

fof(mergeA231,axiom,
    ! [SUBSTANCE] :
      ( p__d__instance(SUBSTANCE,c__SyntheticSubstance)
    <=> ? [PROCESS] :
          ( p__d__instance(PROCESS,c__IntentionalProcess)
          & p__result(PROCESS,SUBSTANCE)
          & p__d__instance(SUBSTANCE,c__Substance) ) ) ).

fof(mergeA232,axiom,
    p__d__subclass(c__NaturalSubstance,c__Substance) ).

fof(mergeA233,axiom,
    p__d__subclass(c__PureSubstance,c__Substance) ).

fof(mergeA234,axiom,
    p__d__partition3(c__PureSubstance,c__CompoundSubstance,c__ElementalSubstance) ).

fof(mergeA235,axiom,
    p__d__subclass(c__ElementalSubstance,c__PureSubstance) ).

fof(mergeA236,axiom,
    p__d__subclass(c__Metal,c__ElementalSubstance) ).

fof(mergeA237,axiom,
    p__d__subclass(c__Atom,c__ElementalSubstance) ).

fof(mergeA238,axiom,
    ! [ATOM] :
      ( p__d__instance(ATOM,c__Atom)
     => ? [PROTON,ELECTRON] :
          ( p__part(PROTON,ATOM)
          & p__part(ELECTRON,ATOM)
          & p__d__instance(PROTON,c__Proton)
          & p__d__instance(ELECTRON,c__Electron) ) ) ).

fof(mergeA239,axiom,
    ! [ATOM,NUCLEUS1,NUCLEUS2] :
      ( ( p__d__instance(ATOM,c__Atom)
        & p__part(NUCLEUS1,ATOM)
        & p__part(NUCLEUS2,ATOM)
        & p__d__instance(NUCLEUS1,c__AtomicNucleus)
        & p__d__instance(NUCLEUS2,c__AtomicNucleus) )
     => NUCLEUS1 = NUCLEUS2 ) ).

fof(mergeA240,axiom,
    p__d__subclass(c__SubatomicParticle,c__ElementalSubstance) ).

fof(mergeA241,axiom,
    ! [PARTICLE] :
      ( p__d__instance(PARTICLE,c__SubatomicParticle)
     => ? [ATOM] :
          ( p__d__instance(ATOM,c__Atom)
          & p__part(PARTICLE,ATOM) ) ) ).

fof(mergeA242,axiom,
    p__d__subclass(c__AtomicNucleus,c__SubatomicParticle) ).

fof(mergeA243,axiom,
    ! [NUCLEUS] :
      ( p__d__instance(NUCLEUS,c__AtomicNucleus)
     => ? [NEUTRON,PROTON] :
          ( p__part(NEUTRON,NUCLEUS)
          & p__part(PROTON,NUCLEUS)
          & p__d__instance(NEUTRON,c__Neutron)
          & p__d__instance(PROTON,c__Proton) ) ) ).

fof(mergeA244,axiom,
    p__d__subclass(c__Electron,c__SubatomicParticle) ).

fof(mergeA245,axiom,
    p__d__subclass(c__Proton,c__SubatomicParticle) ).

fof(mergeA246,axiom,
    p__d__subclass(c__Neutron,c__SubatomicParticle) ).

fof(mergeA247,axiom,
    p__d__subclass(c__CompoundSubstance,c__PureSubstance) ).

fof(mergeA248,axiom,
    p__d__subclass(c__Mixture,c__Substance) ).

fof(mergeA249,axiom,
    ! [MIXTURE] :
      ( p__d__instance(MIXTURE,c__Mixture)
     => ? [PURE1,PURE2] :
          ( p__d__instance(PURE1,c__PureSubstance)
          & p__d__instance(PURE2,c__PureSubstance)
          & PURE1 != PURE2
          & p__part(PURE1,MIXTURE)
          & p__part(PURE2,MIXTURE) ) ) ).

fof(mergeA250,axiom,
    ! [MIXTURE,SUBSTANCE] :
      ( ( p__d__instance(SUBSTANCE,c__Object)
        & p__d__instance(MIXTURE,c__Mixture)
        & p__part(SUBSTANCE,MIXTURE)
        & ~ p__d__instance(SUBSTANCE,c__Mixture) )
     => p__d__instance(SUBSTANCE,c__PureSubstance) ) ).

fof(mergeA251,axiom,
    p__d__subclass(c__CorpuscularObject,c__SelfConnectedObject) ).

fof(mergeA252,axiom,
    p__d__disjoint(c__CorpuscularObject,c__Substance) ).

fof(mergeA253,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__CorpuscularObject)
     => ? [SUBSTANCE1,SUBSTANCE2] :
          ( p__d__subclass(SUBSTANCE1,c__Substance)
          & p__d__subclass(SUBSTANCE2,c__Substance)
          & p__material(SUBSTANCE1,OBJ)
          & p__material(SUBSTANCE2,OBJ)
          & SUBSTANCE1 != SUBSTANCE2 ) ) ).

fof(mergeA254,axiom,
    p__d__subclass(c__Region,c__Object) ).

fof(mergeA255,axiom,
    ! [REGION] :
      ( p__d__instance(REGION,c__Region)
     => ? [PHYS] :
          ( p__d__instance(PHYS,c__Physical)
          & p__located(PHYS,REGION) ) ) ).

fof(mergeA256,axiom,
    p__d__subclass(c__Collection,c__Object) ).

fof(mergeA257,axiom,
    p__d__disjoint(c__Collection,c__SelfConnectedObject) ).

fof(mergeA258,axiom,
    ! [COLL] :
      ( p__d__instance(COLL,c__Collection)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__SelfConnectedObject)
          & p__member(OBJ,COLL) ) ) ).

fof(mergeA259,axiom,
    p__subrelation(c__member,c__part) ).

fof(mergeA260,axiom,
    p__d__instance(c__member,c__AsymmetricRelation) ).

fof(mergeA261,axiom,
    p__d__instance(c__member,c__IntransitiveRelation) ).

fof(mergeA264,axiom,
    p__relatedInternalConcept(c__member,c__instance) ).

fof(mergeA265,axiom,
    p__relatedInternalConcept(c__member,c__element) ).

fof(mergeA266,axiom,
    p__d__instance(c__subCollection,c__BinaryPredicate) ).

fof(mergeA267,axiom,
    p__d__instance(c__subCollection,c__PartialOrderingRelation) ).

fof(mergeA270,axiom,
    p__subrelation(c__subCollection,c__part) ).

fof(mergeA271,axiom,
    ! [COLL1,COLL2] :
      ( ( p__d__instance(COLL2,c__Collection)
        & p__d__instance(COLL1,c__Collection) )
     => ( p__subCollection(COLL1,COLL2)
      <=> ! [MEMBER] :
            ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
              & p__member(MEMBER,COLL1) )
           => p__member(MEMBER,COLL2) ) ) ) ).

fof(mergeA272,axiom,
    p__d__subclass(c__ContentBearingPhysical,c__Physical) ).

fof(mergeA273,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__ContentBearingPhysical)
     => ? [THING] : p__represents(OBJ,THING) ) ).

fof(mergeA274,axiom,
    p__d__subclass(c__ContentBearingProcess,c__ContentBearingPhysical) ).

fof(mergeA275,axiom,
    p__d__subclass(c__ContentBearingProcess,c__Process) ).

fof(mergeA276,axiom,
    p__d__subclass(c__ContentBearingObject,c__CorpuscularObject) ).

fof(mergeA277,axiom,
    p__d__subclass(c__ContentBearingObject,c__ContentBearingPhysical) ).

fof(mergeA279,axiom,
    p__d__subclass(c__SymbolicString,c__ContentBearingObject) ).

fof(mergeA280,axiom,
    p__d__subclass(c__Character,c__SymbolicString) ).

fof(mergeA281,axiom,
    ! [STRING] :
      ( p__d__instance(STRING,c__SymbolicString)
     => ? [PART] :
          ( p__part(PART,STRING)
          & p__d__instance(PART,c__Character) ) ) ).

fof(mergeA282,axiom,
    p__d__instance(c__containsInformation,c__BinaryPredicate) ).

fof(mergeA283,axiom,
    p__d__instance(c__containsInformation,c__AsymmetricRelation) ).

fof(mergeA284,axiom,
    p__subrelation(c__containsInformation,c__represents) ).

fof(mergeA287,axiom,
    p__d__subclass(c__Icon,c__ContentBearingPhysical) ).

fof(mergeA288,axiom,
    p__d__subclass(c__MotionPicture,c__Text) ).

fof(mergeA289,axiom,
    p__d__subclass(c__LinguisticExpression,c__ContentBearingPhysical) ).

fof(mergeA290,axiom,
    p__d__disjoint(c__LinguisticExpression,c__Icon) ).

fof(mergeA291,axiom,
    p__d__subclass(c__Language,c__LinguisticExpression) ).

fof(mergeA292,axiom,
    p__d__disjointDecomposition4(c__Language,c__AnimalLanguage,c__HumanLanguage,c__ComputerLanguage) ).

fof(mergeA293,axiom,
    p__d__subclass(c__AnimalLanguage,c__Language) ).

fof(mergeA294,axiom,
    ! [PROC,LANG,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(PROC,c__Process)
        & p__d__instance(LANG,c__AnimalLanguage)
        & p__agent(PROC,AGENT)
        & p__instrument(PROC,LANG) )
     => ( p__d__instance(AGENT,c__Animal)
        & ~ p__d__instance(AGENT,c__Human) ) ) ).

fof(mergeA295,axiom,
    p__d__subclass(c__ArtificialLanguage,c__Language) ).

fof(mergeA296,axiom,
    p__d__subclass(c__ComputerLanguage,c__ArtificialLanguage) ).

fof(mergeA297,axiom,
    ! [PROC,LANG,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(PROC,c__Process)
        & p__d__instance(LANG,c__ComputerLanguage)
        & p__agent(PROC,AGENT)
        & p__instrument(PROC,LANG) )
     => p__d__instance(AGENT,c__Machine) ) ).

fof(mergeA298,axiom,
    p__d__subclass(c__HumanLanguage,c__Language) ).

fof(mergeA299,axiom,
    p__d__partition3(c__HumanLanguage,c__NaturalLanguage,c__ConstructedLanguage) ).

fof(mergeA300,axiom,
    p__d__partition3(c__HumanLanguage,c__SpokenHumanLanguage,c__ManualHumanLanguage) ).

fof(mergeA301,axiom,
    ! [PROC,LANG,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(PROC,c__Process)
        & p__d__instance(LANG,c__HumanLanguage)
        & p__agent(PROC,AGENT)
        & p__instrument(PROC,LANG) )
     => p__d__instance(AGENT,c__Human) ) ).

fof(mergeA302,axiom,
    p__d__subclass(c__ConstructedLanguage,c__HumanLanguage) ).

fof(mergeA303,axiom,
    p__d__subclass(c__ConstructedLanguage,c__ArtificialLanguage) ).

fof(mergeA304,axiom,
    ! [LANG] :
      ( p__d__instance(LANG,c__ConstructedLanguage)
     => ? [PLAN] :
          ( p__d__instance(PLAN,c__Planning)
          & p__result(PLAN,LANG) ) ) ).

fof(mergeA305,axiom,
    p__d__subclass(c__NaturalLanguage,c__HumanLanguage) ).

fof(mergeA306,axiom,
    p__d__subclass(c__ManualHumanLanguage,c__HumanLanguage) ).

fof(mergeA307,axiom,
    p__d__subclass(c__SpokenHumanLanguage,c__HumanLanguage) ).

fof(mergeA308,axiom,
    p__d__instance(c__EnglishLanguage,c__NaturalLanguage) ).

fof(mergeA309,axiom,
    p__d__instance(c__EnglishLanguage,c__SpokenHumanLanguage) ).

fof(mergeA310,axiom,
    p__d__subclass(c__Word,c__LinguisticExpression) ).

fof(mergeA311,axiom,
    p__d__subclass(c__Formula,c__Sentence) ).

fof(mergeA312,axiom,
    p__d__subclass(c__Agent,c__Object) ).

fof(mergeA313,axiom,
    ! [AGENT] :
      ( p__d__instance(AGENT,c__Agent)
     => ? [PROC] :
          ( p__d__instance(PROC,c__Process)
          & p__agent(PROC,AGENT) ) ) ).

fof(mergeA314,axiom,
    p__d__subclass(c__SentientAgent,c__Agent) ).

fof(mergeA315,axiom,
    p__d__subclass(c__CognitiveAgent,c__SentientAgent) ).

fof(mergeA316,axiom,
    p__d__subclass(c__LegalAgent,c__Agent) ).

fof(mergeA318,axiom,
    p__d__instance(c__leader,c__BinaryPredicate) ).

fof(mergeA319,axiom,
    p__d__instance(c__leader,c__AsymmetricRelation) ).

fof(mergeA320,axiom,
    p__d__instance(c__leader,c__SingleValuedRelation) ).

fof(mergeA324,axiom,
    p__d__subclass(c__Process,c__Physical) ).

fof(mergeA325,axiom,
    p__d__subclass(c__DualObjectProcess,c__Process) ).

fof(mergeA326,axiom,
    ! [PROCESS] :
      ( p__d__instance(PROCESS,c__DualObjectProcess)
     => ? [OBJ1,OBJ2] :
          ( p__patient(PROCESS,OBJ1)
          & p__patient(PROCESS,OBJ2)
          & OBJ1 != OBJ2 ) ) ).

fof(mergeA327,axiom,
    p__d__subclass(c__SingleAgentProcess,c__Process) ).

fof(mergeA328,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__SingleAgentProcess)
     => ? [AGENT] :
          ( p__d__instance(AGENT,c__Agent)
          & p__agent(PROC,AGENT) ) ) ).

fof(mergeA329,axiom,
    ! [PROC,AGENT_1,AGENT_2] :
      ( ( p__d__instance(AGENT_1,c__Agent)
        & p__d__instance(AGENT_2,c__Agent)
        & p__d__instance(PROC,c__SingleAgentProcess)
        & p__agent(PROC,AGENT_1)
        & p__agent(PROC,AGENT_2) )
     => AGENT_1 = AGENT_2 ) ).

fof(mergeA330,axiom,
    p__d__subclass(c__Abstract,c__Entity) ).

fof(mergeA331,axiom,
    p__d__disjointDecomposition6(c__Abstract,c__Quantity,c__Attribute,c__SetOrClass,c__Relation,c__Proposition) ).

fof(mergeA332,axiom,
    p__d__subclass(c__Quantity,c__Abstract) ).

fof(mergeA333,axiom,
    p__d__subclass(c__Attribute,c__Abstract) ).

fof(mergeA334,axiom,
    p__d__partition4(c__Attribute,c__InternalAttribute,c__RelationalAttribute,c__PerceptualAttribute) ).

fof(mergeA335,axiom,
    p__d__instance(c__property,c__BinaryPredicate) ).

fof(mergeA338,axiom,
    p__d__instance(c__attribute,c__AsymmetricRelation) ).

fof(mergeA339,axiom,
    p__d__instance(c__attribute,c__IrreflexiveRelation) ).

fof(mergeA340,axiom,
    p__subrelation(c__attribute,c__property) ).

fof(mergeA342,axiom,
    p__d__instance(c__manner,c__AsymmetricRelation) ).

fof(mergeA343,axiom,
    p__d__instance(c__manner,c__IrreflexiveRelation) ).

fof(mergeA344,axiom,
    p__subrelation(c__manner,c__property) ).

fof(mergeA346,axiom,
    p__disjointRelation(c__manner,c__attribute) ).

fof(mergeA347,axiom,
    p__d__instance(c__ExtensionFn,c__UnaryFunction) ).

fof(mergeA348,axiom,
    p__d__instance(c__ExtensionFn,c__PartialValuedRelation) ).

fof(mergeA351,axiom,
    p__d__subclass(c__InternalAttribute,c__Attribute) ).

fof(mergeA352,axiom,
    p__d__subclass(c__PhysicalAttribute,c__InternalAttribute) ).

fof(mergeA353,axiom,
    p__d__subclass(c__RelationalAttribute,c__Attribute) ).

fof(mergeA354,axiom,
    p__d__subclass(c__Number,c__Quantity) ).

fof(mergeA355,axiom,
    p__d__partition4(c__Number,c__RealNumber,c__ImaginaryNumber,c__ComplexNumber) ).

fof(mergeA356,axiom,
    p__d__instance(c__lessThan,c__BinaryPredicate) ).

fof(mergeA357,axiom,
    p__d__instance(c__lessThan,c__TransitiveRelation) ).

fof(mergeA358,axiom,
    p__d__instance(c__lessThan,c__IrreflexiveRelation) ).

fof(mergeA359,axiom,
    p__d__instance(c__lessThan,c__RelationExtendedToQuantities) ).

fof(mergeA363,axiom,
    p__d__instance(c__greaterThan,c__BinaryPredicate) ).

fof(mergeA364,axiom,
    p__d__instance(c__greaterThan,c__TransitiveRelation) ).

fof(mergeA365,axiom,
    p__d__instance(c__greaterThan,c__IrreflexiveRelation) ).

fof(mergeA366,axiom,
    p__d__instance(c__greaterThan,c__RelationExtendedToQuantities) ).

fof(mergeA370,axiom,
    p__inverse(c__greaterThan,c__lessThan) ).

fof(mergeA371,axiom,
    p__d__instance(c__lessThanOrEqualTo,c__BinaryPredicate) ).

fof(mergeA372,axiom,
    p__d__instance(c__lessThanOrEqualTo,c__PartialOrderingRelation) ).

fof(mergeA373,axiom,
    p__d__instance(c__lessThanOrEqualTo,c__RelationExtendedToQuantities) ).

fof(mergeA377,axiom,
    ! [NUMBER1,NUMBER2] :
      ( ( p__d__instance(NUMBER2,c__Quantity)
        & p__d__instance(NUMBER1,c__Quantity) )
     => ( p__lessThanOrEqualTo(NUMBER1,NUMBER2)
      <=> ( NUMBER1 = NUMBER2
          | p__lessThan(NUMBER1,NUMBER2) ) ) ) ).

fof(mergeA378,axiom,
    p__d__instance(c__greaterThanOrEqualTo,c__BinaryPredicate) ).

fof(mergeA379,axiom,
    p__d__instance(c__greaterThanOrEqualTo,c__PartialOrderingRelation) ).

fof(mergeA380,axiom,
    p__d__instance(c__greaterThanOrEqualTo,c__RelationExtendedToQuantities) ).

fof(mergeA384,axiom,
    p__inverse(c__greaterThanOrEqualTo,c__lessThanOrEqualTo) ).

fof(mergeA385,axiom,
    ! [NUMBER1,NUMBER2] :
      ( ( p__d__instance(NUMBER2,c__Quantity)
        & p__d__instance(NUMBER1,c__Quantity) )
     => ( p__greaterThanOrEqualTo(NUMBER1,NUMBER2)
      <=> ( NUMBER1 = NUMBER2
          | p__greaterThan(NUMBER1,NUMBER2) ) ) ) ).

fof(mergeA386,axiom,
    p__d__subclass(c__RealNumber,c__Number) ).

fof(mergeA387,axiom,
    p__d__partition3(c__RealNumber,c__NegativeRealNumber,c__NonnegativeRealNumber) ).

fof(mergeA388,axiom,
    p__d__partition3(c__RealNumber,c__RationalNumber,c__IrrationalNumber) ).

fof(mergeA389,axiom,
    p__d__subclass(c__ImaginaryNumber,c__Number) ).

fof(mergeA390,axiom,
    p__d__subclass(c__RationalNumber,c__RealNumber) ).

fof(mergeA391,axiom,
    p__d__subclass(c__IrrationalNumber,c__RealNumber) ).

fof(mergeA392,axiom,
    p__d__subclass(c__NonnegativeRealNumber,c__RealNumber) ).

fof(mergeA393,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__Quantity)
     => ( p__d__instance(NUMBER,c__NonnegativeRealNumber)
      <=> ( p__greaterThanOrEqualTo(NUMBER,c__0)
          & p__d__instance(NUMBER,c__RealNumber) ) ) ) ).

fof(mergeA394,axiom,
    p__d__subclass(c__PositiveRealNumber,c__NonnegativeRealNumber) ).

fof(mergeA395,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__Quantity)
     => ( p__d__instance(NUMBER,c__PositiveRealNumber)
      <=> ( p__greaterThan(NUMBER,c__0)
          & p__d__instance(NUMBER,c__RealNumber) ) ) ) ).

fof(mergeA396,axiom,
    p__d__subclass(c__NegativeRealNumber,c__RealNumber) ).

fof(mergeA397,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__Quantity)
     => ( p__d__instance(NUMBER,c__NegativeRealNumber)
      <=> ( p__lessThan(NUMBER,c__0)
          & p__d__instance(NUMBER,c__RealNumber) ) ) ) ).

fof(mergeA398,axiom,
    p__d__subclass(c__Integer,c__RationalNumber) ).

fof(mergeA399,axiom,
    p__d__partition3(c__Integer,c__OddInteger,c__EvenInteger) ).

fof(mergeA400,axiom,
    p__d__partition3(c__Integer,c__NegativeInteger,c__NonnegativeInteger) ).

fof(mergeA401,axiom,
    p__d__instance(c__0,c__Integer) ).

fof(mergeA402,axiom,
    p__d__subclass(c__EvenInteger,c__Integer) ).

fof(mergeA403,axiom,
    p__d__subclass(c__OddInteger,c__Integer) ).

fof(mergeA404,axiom,
    p__d__subclass(c__PrimeNumber,c__Integer) ).

fof(mergeA405,axiom,
    p__d__subclass(c__NonnegativeInteger,c__Integer) ).

fof(mergeA406,axiom,
    p__d__subclass(c__NonnegativeInteger,c__NonnegativeRealNumber) ).

fof(mergeA407,axiom,
    p__d__subclass(c__NegativeInteger,c__Integer) ).

fof(mergeA408,axiom,
    p__d__subclass(c__NegativeInteger,c__NegativeRealNumber) ).

fof(mergeA409,axiom,
    ! [X] :
      ( p__d__instance(X,c__NegativeInteger)
     => p__greaterThan(c__0,X) ) ).

fof(mergeA410,axiom,
    p__d__subclass(c__PositiveInteger,c__NonnegativeInteger) ).

fof(mergeA411,axiom,
    p__d__subclass(c__PositiveInteger,c__PositiveRealNumber) ).

fof(mergeA412,axiom,
    p__d__instance(c__1,c__PositiveInteger) ).

fof(mergeA413,axiom,
    p__d__instance(c__2,c__PositiveInteger) ).

fof(mergeA414,axiom,
    p__d__instance(c__3,c__PositiveInteger) ).

fof(mergeA415,axiom,
    p__d__instance(c__4,c__PositiveInteger) ).

fof(mergeA416,axiom,
    p__d__instance(c__5,c__PositiveInteger) ).

fof(mergeA417,axiom,
    p__d__instance(c__6,c__PositiveInteger) ).

fof(mergeA418,axiom,
    p__d__instance(c__7,c__PositiveInteger) ).

fof(mergeA419,axiom,
    p__d__instance(c__8,c__PositiveInteger) ).

fof(mergeA420,axiom,
    p__d__instance(c__9,c__PositiveInteger) ).

fof(mergeA421,axiom,
    p__d__instance(c__10,c__PositiveInteger) ).

fof(mergeA422,axiom,
    p__d__instance(c__11,c__PositiveInteger) ).

fof(mergeA423,axiom,
    p__d__instance(c__12,c__PositiveInteger) ).

fof(mergeA424,axiom,
    p__d__instance(c__13,c__PositiveInteger) ).

fof(mergeA425,axiom,
    p__d__instance(c__14,c__PositiveInteger) ).

fof(mergeA426,axiom,
    p__d__instance(c__15,c__PositiveInteger) ).

fof(mergeA427,axiom,
    p__d__instance(c__16,c__PositiveInteger) ).

fof(mergeA428,axiom,
    p__d__instance(c__17,c__PositiveInteger) ).

fof(mergeA429,axiom,
    p__d__instance(c__18,c__PositiveInteger) ).

fof(mergeA430,axiom,
    p__d__instance(c__19,c__PositiveInteger) ).

fof(mergeA431,axiom,
    p__d__instance(c__20,c__PositiveInteger) ).

fof(mergeA432,axiom,
    p__d__instance(c__21,c__PositiveInteger) ).

fof(mergeA433,axiom,
    p__d__instance(c__22,c__PositiveInteger) ).

fof(mergeA434,axiom,
    p__d__instance(c__23,c__PositiveInteger) ).

fof(mergeA435,axiom,
    p__d__instance(c__24,c__PositiveInteger) ).

fof(mergeA436,axiom,
    p__d__instance(c__25,c__PositiveInteger) ).

fof(mergeA437,axiom,
    p__d__instance(c__26,c__PositiveInteger) ).

fof(mergeA438,axiom,
    p__d__instance(c__27,c__PositiveInteger) ).

fof(mergeA439,axiom,
    p__d__instance(c__28,c__PositiveInteger) ).

fof(mergeA440,axiom,
    p__d__instance(c__29,c__PositiveInteger) ).

fof(mergeA441,axiom,
    p__d__instance(c__30,c__PositiveInteger) ).

fof(mergeA442,axiom,
    p__d__instance(c__31,c__PositiveInteger) ).

fof(mergeA443,axiom,
    p__d__instance(c__32,c__PositiveInteger) ).

fof(mergeA444,axiom,
    p__d__instance(c__33,c__PositiveInteger) ).

fof(mergeA445,axiom,
    p__d__instance(c__34,c__PositiveInteger) ).

fof(mergeA446,axiom,
    p__d__instance(c__35,c__PositiveInteger) ).

fof(mergeA447,axiom,
    p__d__instance(c__36,c__PositiveInteger) ).

fof(mergeA448,axiom,
    p__d__instance(c__37,c__PositiveInteger) ).

fof(mergeA449,axiom,
    p__d__instance(c__38,c__PositiveInteger) ).

fof(mergeA450,axiom,
    p__d__instance(c__39,c__PositiveInteger) ).

fof(mergeA451,axiom,
    p__d__instance(c__40,c__PositiveInteger) ).

fof(mergeA452,axiom,
    p__d__instance(c__41,c__PositiveInteger) ).

fof(mergeA453,axiom,
    p__d__instance(c__42,c__PositiveInteger) ).

fof(mergeA454,axiom,
    p__d__instance(c__43,c__PositiveInteger) ).

fof(mergeA455,axiom,
    p__d__instance(c__44,c__PositiveInteger) ).

fof(mergeA456,axiom,
    p__d__instance(c__45,c__PositiveInteger) ).

fof(mergeA457,axiom,
    p__d__instance(c__46,c__PositiveInteger) ).

fof(mergeA458,axiom,
    p__d__instance(c__47,c__PositiveInteger) ).

fof(mergeA459,axiom,
    p__d__instance(c__48,c__PositiveInteger) ).

fof(mergeA460,axiom,
    p__d__instance(c__49,c__PositiveInteger) ).

fof(mergeA461,axiom,
    p__d__instance(c__50,c__PositiveInteger) ).

fof(mergeA462,axiom,
    p__d__instance(c__51,c__PositiveInteger) ).

fof(mergeA463,axiom,
    p__d__instance(c__52,c__PositiveInteger) ).

fof(mergeA464,axiom,
    p__d__instance(c__53,c__PositiveInteger) ).

fof(mergeA465,axiom,
    p__d__instance(c__54,c__PositiveInteger) ).

fof(mergeA466,axiom,
    p__d__instance(c__55,c__PositiveInteger) ).

fof(mergeA467,axiom,
    p__d__instance(c__56,c__PositiveInteger) ).

fof(mergeA468,axiom,
    p__d__instance(c__57,c__PositiveInteger) ).

fof(mergeA469,axiom,
    p__d__instance(c__58,c__PositiveInteger) ).

fof(mergeA470,axiom,
    p__d__instance(c__59,c__PositiveInteger) ).

fof(mergeA471,axiom,
    p__d__instance(c__60,c__PositiveInteger) ).

fof(mergeA472,axiom,
    p__d__instance(c__61,c__PositiveInteger) ).

fof(mergeA473,axiom,
    p__d__instance(c__62,c__PositiveInteger) ).

fof(mergeA474,axiom,
    p__d__instance(c__63,c__PositiveInteger) ).

fof(mergeA475,axiom,
    p__d__instance(c__64,c__PositiveInteger) ).

fof(mergeA476,axiom,
    p__d__instance(c__65,c__PositiveInteger) ).

fof(mergeA477,axiom,
    p__d__instance(c__66,c__PositiveInteger) ).

fof(mergeA478,axiom,
    p__d__instance(c__67,c__PositiveInteger) ).

fof(mergeA479,axiom,
    p__d__instance(c__68,c__PositiveInteger) ).

fof(mergeA480,axiom,
    p__d__instance(c__69,c__PositiveInteger) ).

fof(mergeA481,axiom,
    p__d__instance(c__70,c__PositiveInteger) ).

fof(mergeA482,axiom,
    p__d__instance(c__71,c__PositiveInteger) ).

fof(mergeA483,axiom,
    p__d__instance(c__72,c__PositiveInteger) ).

fof(mergeA484,axiom,
    p__d__instance(c__73,c__PositiveInteger) ).

fof(mergeA485,axiom,
    p__d__instance(c__74,c__PositiveInteger) ).

fof(mergeA486,axiom,
    p__d__instance(c__75,c__PositiveInteger) ).

fof(mergeA487,axiom,
    p__d__instance(c__76,c__PositiveInteger) ).

fof(mergeA488,axiom,
    p__d__instance(c__77,c__PositiveInteger) ).

fof(mergeA489,axiom,
    p__d__instance(c__78,c__PositiveInteger) ).

fof(mergeA490,axiom,
    p__d__instance(c__79,c__PositiveInteger) ).

fof(mergeA491,axiom,
    p__d__instance(c__80,c__PositiveInteger) ).

fof(mergeA492,axiom,
    p__d__instance(c__81,c__PositiveInteger) ).

fof(mergeA493,axiom,
    p__d__instance(c__82,c__PositiveInteger) ).

fof(mergeA494,axiom,
    p__d__instance(c__83,c__PositiveInteger) ).

fof(mergeA495,axiom,
    p__d__instance(c__84,c__PositiveInteger) ).

fof(mergeA496,axiom,
    p__d__instance(c__85,c__PositiveInteger) ).

fof(mergeA497,axiom,
    p__d__instance(c__86,c__PositiveInteger) ).

fof(mergeA498,axiom,
    p__d__instance(c__87,c__PositiveInteger) ).

fof(mergeA499,axiom,
    p__d__instance(c__88,c__PositiveInteger) ).

fof(mergeA500,axiom,
    p__d__instance(c__89,c__PositiveInteger) ).

fof(mergeA501,axiom,
    p__d__instance(c__90,c__PositiveInteger) ).

fof(mergeA502,axiom,
    p__d__instance(c__91,c__PositiveInteger) ).

fof(mergeA503,axiom,
    p__d__instance(c__92,c__PositiveInteger) ).

fof(mergeA504,axiom,
    p__d__instance(c__93,c__PositiveInteger) ).

fof(mergeA505,axiom,
    p__d__instance(c__94,c__PositiveInteger) ).

fof(mergeA506,axiom,
    p__d__instance(c__95,c__PositiveInteger) ).

fof(mergeA507,axiom,
    p__d__instance(c__96,c__PositiveInteger) ).

fof(mergeA508,axiom,
    p__d__instance(c__97,c__PositiveInteger) ).

fof(mergeA509,axiom,
    p__d__instance(c__98,c__PositiveInteger) ).

fof(mergeA510,axiom,
    p__d__instance(c__99,c__PositiveInteger) ).

fof(mergeA511,axiom,
    p__d__instance(c__100,c__PositiveInteger) ).

fof(mergeA512,axiom,
    p__d__instance(c__101,c__PositiveInteger) ).

fof(mergeA513,axiom,
    p__d__instance(c__102,c__PositiveInteger) ).

fof(mergeA514,axiom,
    p__d__instance(c__103,c__PositiveInteger) ).

fof(mergeA515,axiom,
    p__d__instance(c__104,c__PositiveInteger) ).

fof(mergeA516,axiom,
    p__d__instance(c__105,c__PositiveInteger) ).

fof(mergeA517,axiom,
    p__d__instance(c__106,c__PositiveInteger) ).

fof(mergeA518,axiom,
    p__d__instance(c__107,c__PositiveInteger) ).

fof(mergeA519,axiom,
    p__d__instance(c__108,c__PositiveInteger) ).

fof(mergeA520,axiom,
    p__d__instance(c__109,c__PositiveInteger) ).

fof(mergeA521,axiom,
    p__d__instance(c__110,c__PositiveInteger) ).

fof(mergeA522,axiom,
    p__d__instance(c__147,c__PositiveInteger) ).

fof(mergeA523,axiom,
    p__d__instance(c__180,c__PositiveInteger) ).

fof(mergeA524,axiom,
    p__d__instance(c__210,c__PositiveInteger) ).

fof(mergeA525,axiom,
    p__d__instance(c__222,c__PositiveInteger) ).

fof(mergeA526,axiom,
    p__d__instance(c__223,c__PositiveInteger) ).

fof(mergeA527,axiom,
    p__d__instance(c__226,c__PositiveInteger) ).

fof(mergeA528,axiom,
    p__d__instance(c__227,c__PositiveInteger) ).

fof(mergeA529,axiom,
    p__d__instance(c__231,c__PositiveInteger) ).

fof(mergeA530,axiom,
    p__d__instance(c__237,c__PositiveInteger) ).

fof(mergeA531,axiom,
    p__d__instance(c__242,c__PositiveInteger) ).

fof(mergeA532,axiom,
    p__d__instance(c__243,c__PositiveInteger) ).

fof(mergeA533,axiom,
    p__d__instance(c__247,c__PositiveInteger) ).

fof(mergeA534,axiom,
    p__d__instance(c__249,c__PositiveInteger) ).

fof(mergeA535,axiom,
    p__d__instance(c__253,c__PositiveInteger) ).

fof(mergeA536,axiom,
    p__d__instance(c__254,c__PositiveInteger) ).

fof(mergeA537,axiom,
    p__d__instance(c__256,c__PositiveInteger) ).

fof(mergeA538,axiom,
    p__d__instance(c__261,c__PositiveInteger) ).

fof(mergeA539,axiom,
    p__d__instance(c__262,c__PositiveInteger) ).

fof(mergeA540,axiom,
    p__d__instance(c__263,c__PositiveInteger) ).

fof(mergeA541,axiom,
    p__d__instance(c__265,c__PositiveInteger) ).

fof(mergeA542,axiom,
    p__d__instance(c__266,c__PositiveInteger) ).

fof(mergeA543,axiom,
    p__d__instance(c__267,c__PositiveInteger) ).

fof(mergeA544,axiom,
    p__d__instance(c__272,c__PositiveInteger) ).

fof(mergeA545,axiom,
    p__d__instance(c__360,c__PositiveInteger) ).

fof(mergeA546,axiom,
    p__d__instance(c__365,c__PositiveInteger) ).

fof(mergeA547,axiom,
    p__d__instance(c__400,c__PositiveInteger) ).

fof(mergeA548,axiom,
    p__d__instance(c__746,c__PositiveInteger) ).

fof(mergeA549,axiom,
    p__d__instance(c__1000,c__PositiveInteger) ).

fof(mergeA550,axiom,
    p__d__instance(c__1024,c__PositiveInteger) ).

fof(mergeA551,axiom,
    p__d__instance(c__2000,c__PositiveInteger) ).

fof(mergeA552,axiom,
    p__d__instance(c__2205,c__PositiveInteger) ).

fof(mergeA553,axiom,
    p__d__instance(c__2240,c__PositiveInteger) ).

fof(mergeA554,axiom,
    p__d__instance(c__1000000,c__PositiveInteger) ).

fof(mergeA555,axiom,
    p__d__instance(c__1000000000,c__PositiveInteger) ).

fof(mergeA556,axiom,
    p__d__instance(c__1000000000000,c__PositiveInteger) ).

fof(mergeA557,axiom,
    ! [X] :
      ( p__d__instance(X,c__PositiveInteger)
     => p__greaterThan(X,c__0) ) ).

fof(mergeA558,axiom,
    p__d__subclass(c__BinaryNumber,c__RealNumber) ).

fof(mergeA559,axiom,
    p__d__subclass(c__ComplexNumber,c__Number) ).

fof(mergeA560,axiom,
    p__d__disjoint(c__ComplexNumber,c__RealNumber) ).

fof(mergeA561,axiom,
    p__d__subclass(c__PhysicalQuantity,c__Quantity) ).

fof(mergeA562,axiom,
    p__d__partition3(c__PhysicalQuantity,c__ConstantQuantity,c__FunctionQuantity) ).

fof(mergeA563,axiom,
    p__d__subclass(c__ConstantQuantity,c__PhysicalQuantity) ).

fof(mergeA564,axiom,
    p__d__subclass(c__TimeMeasure,c__ConstantQuantity) ).

fof(mergeA565,axiom,
    p__d__subclass(c__TimeDuration,c__TimeMeasure) ).

fof(mergeA566,axiom,
    p__d__subclass(c__TimePosition,c__TimeMeasure) ).

fof(mergeA567,axiom,
    p__d__partition3(c__TimePosition,c__TimeInterval,c__TimePoint) ).

fof(mergeA568,axiom,
    p__d__subclass(c__TimeInterval,c__TimePosition) ).

fof(mergeA569,axiom,
    p__d__subclass(c__TimePoint,c__TimePosition) ).

fof(mergeA570,axiom,
    p__d__subclass(c__FunctionQuantity,c__PhysicalQuantity) ).

fof(mergeA571,axiom,
    p__d__subclass(c__UnaryConstantFunctionQuantity,c__FunctionQuantity) ).

fof(mergeA572,axiom,
    p__d__subclass(c__TimeDependentQuantity,c__UnaryConstantFunctionQuantity) ).

fof(mergeA573,axiom,
    p__d__subclass(c__SetOrClass,c__Abstract) ).

fof(mergeA574,axiom,
    p__d__partition3(c__SetOrClass,c__Set,c__Class) ).

fof(mergeA575,axiom,
    p__d__subclass(c__Class,c__SetOrClass) ).

fof(mergeA576,axiom,
    p__d__subclass(c__Set,c__SetOrClass) ).

fof(mergeA577,axiom,
    p__d__subclass(c__Relation,c__Abstract) ).

fof(mergeA578,axiom,
    p__d__disjointDecomposition6(c__Relation,c__BinaryRelation,c__TernaryRelation,c__QuaternaryRelation,c__QuintaryRelation,c__VariableArityRelation) ).

fof(mergeA579,axiom,
    p__d__partition4(c__Relation,c__Predicate,c__Function,c__List) ).

fof(mergeA580,axiom,
    p__d__partition3(c__Relation,c__TotalValuedRelation,c__PartialValuedRelation) ).

fof(mergeA581,axiom,
    p__d__subclass(c__SingleValuedRelation,c__Relation) ).

fof(mergeA582,axiom,
    p__d__subclass(c__TotalValuedRelation,c__Relation) ).

fof(mergeA583,axiom,
    p__d__subclass(c__PartialValuedRelation,c__Relation) ).

fof(mergeA584,axiom,
    p__d__subclass(c__BinaryRelation,c__Relation) ).

fof(mergeA591,axiom,
    p__d__subclass(c__ReflexiveRelation,c__BinaryRelation) ).

fof(mergeA592,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__ReflexiveRelation)
      <=> ! [INST] : p__d__holds3(REL,INST,INST) ) ) ).

fof(mergeA593,axiom,
    p__d__subclass(c__IrreflexiveRelation,c__BinaryRelation) ).

fof(mergeA594,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__IrreflexiveRelation)
      <=> ! [INST] : ~ p__d__holds3(REL,INST,INST) ) ) ).

fof(mergeA595,axiom,
    p__d__subclass(c__SymmetricRelation,c__BinaryRelation) ).

fof(mergeA596,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__SymmetricRelation)
      <=> ! [INST1,INST2] :
            ( p__d__holds3(REL,INST1,INST2)
           => p__d__holds3(REL,INST2,INST1) ) ) ) ).

fof(mergeA597,axiom,
    p__d__subclass(c__AsymmetricRelation,c__IrreflexiveRelation) ).

fof(mergeA598,axiom,
    p__d__subclass(c__AsymmetricRelation,c__AntisymmetricRelation) ).

fof(mergeA599,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__AsymmetricRelation)
    <=> ( p__d__instance(REL,c__AntisymmetricRelation)
        & p__d__instance(REL,c__IrreflexiveRelation) ) ) ).

fof(mergeA600,axiom,
    p__d__subclass(c__AntisymmetricRelation,c__BinaryRelation) ).

fof(mergeA601,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__AntisymmetricRelation)
      <=> ! [INST1,INST2] :
            ( ( p__d__holds3(REL,INST1,INST2)
              & p__d__holds3(REL,INST2,INST1) )
           => INST1 = INST2 ) ) ) ).

fof(mergeA602,axiom,
    p__d__subclass(c__TrichotomizingRelation,c__BinaryRelation) ).

fof(mergeA603,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__TrichotomizingRelation)
      <=> ! [INST1,INST2] :
            ( p__d__holds3(REL,INST1,INST2)
            | INST1 = INST2
            | p__d__holds3(REL,INST2,INST1) ) ) ) ).

fof(mergeA604,axiom,
    p__d__subclass(c__TransitiveRelation,c__BinaryRelation) ).

fof(mergeA605,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__TransitiveRelation)
      <=> ! [INST1,INST2,INST3] :
            ( ( p__d__holds3(REL,INST1,INST2)
              & p__d__holds3(REL,INST2,INST3) )
           => p__d__holds3(REL,INST1,INST3) ) ) ) ).

fof(mergeA606,axiom,
    p__d__subclass(c__IntransitiveRelation,c__BinaryRelation) ).

fof(mergeA607,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__IntransitiveRelation)
      <=> ! [INST1,INST2,INST3] :
            ( ( p__d__holds3(REL,INST1,INST2)
              & p__d__holds3(REL,INST2,INST3) )
           => ~ p__d__holds3(REL,INST1,INST3) ) ) ) ).

fof(mergeA608,axiom,
    p__d__subclass(c__PartialOrderingRelation,c__TransitiveRelation) ).

fof(mergeA609,axiom,
    p__d__subclass(c__PartialOrderingRelation,c__AntisymmetricRelation) ).

fof(mergeA610,axiom,
    p__d__subclass(c__PartialOrderingRelation,c__ReflexiveRelation) ).

fof(mergeA611,axiom,
    p__d__subclass(c__TotalOrderingRelation,c__PartialOrderingRelation) ).

fof(mergeA612,axiom,
    p__d__subclass(c__TotalOrderingRelation,c__TrichotomizingRelation) ).

fof(mergeA613,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryRelation)
     => ( p__d__instance(REL,c__TotalOrderingRelation)
      <=> ! [INST1,INST2] :
            ( p__d__holds3(REL,INST1,INST2)
            | p__d__holds3(REL,INST2,INST1) ) ) ) ).

fof(mergeA614,axiom,
    p__d__subclass(c__EquivalenceRelation,c__TransitiveRelation) ).

fof(mergeA615,axiom,
    p__d__subclass(c__EquivalenceRelation,c__SymmetricRelation) ).

fof(mergeA616,axiom,
    p__d__subclass(c__EquivalenceRelation,c__ReflexiveRelation) ).

fof(mergeA617,axiom,
    p__d__subclass(c__CaseRole,c__BinaryPredicate) ).

fof(mergeA618,axiom,
    p__d__subclass(c__CaseRole,c__InheritableRelation) ).

fof(mergeA619,axiom,
    p__d__subclass(c__CaseRole,c__AsymmetricRelation) ).

fof(mergeA620,axiom,
    p__d__instance(c__involvedInEvent,c__BinaryPredicate) ).

fof(mergeA621,axiom,
    p__d__instance(c__involvedInEvent,c__AsymmetricRelation) ).

fof(mergeA624,axiom,
    ! [R] :
      ( p__d__instance(R,c__CaseRole)
     => p__subrelation(R,c__involvedInEvent) ) ).

fof(mergeA625,axiom,
    p__d__instance(c__agent,c__CaseRole) ).

fof(mergeA628,axiom,
    p__subrelation(c__agent,c__involvedInEvent) ).

fof(mergeA629,axiom,
    p__d__instance(c__destination,c__CaseRole) ).

fof(mergeA632,axiom,
    p__subrelation(c__destination,c__involvedInEvent) ).

fof(mergeA633,axiom,
    p__d__instance(c__experiencer,c__CaseRole) ).

fof(mergeA636,axiom,
    p__subrelation(c__experiencer,c__involvedInEvent) ).

fof(mergeA637,axiom,
    p__subrelation(c__instrument,c__patient) ).

fof(mergeA640,axiom,
    p__d__instance(c__origin,c__CaseRole) ).

fof(mergeA643,axiom,
    p__subrelation(c__origin,c__involvedInEvent) ).

fof(mergeA644,axiom,
    p__d__instance(c__patient,c__CaseRole) ).

fof(mergeA647,axiom,
    p__subrelation(c__patient,c__involvedInEvent) ).

fof(mergeA648,axiom,
    p__subrelation(c__resource,c__patient) ).

fof(mergeA651,axiom,
    p__disjointRelation(c__resource,c__result) ).

fof(mergeA652,axiom,
    p__disjointRelation(c__resource,c__instrument) ).

fof(mergeA653,axiom,
    p__disjointRelation(c__result,c__instrument) ).

fof(mergeA654,axiom,
    p__subrelation(c__result,c__patient) ).

fof(mergeA657,axiom,
    p__d__subclass(c__InheritableRelation,c__Relation) ).

fof(mergeA658,axiom,
    p__d__subclass(c__ProbabilityRelation,c__Relation) ).

fof(mergeA659,axiom,
    p__d__subclass(c__ProbabilityRelation,c__InheritableRelation) ).

fof(mergeA660,axiom,
    p__d__instance(c__ProbabilityFn,c__ProbabilityRelation) ).

fof(mergeA661,axiom,
    p__d__instance(c__ProbabilityFn,c__TotalValuedRelation) ).

fof(mergeA662,axiom,
    p__d__instance(c__ProbabilityFn,c__UnaryFunction) ).

fof(mergeA665,axiom,
    p__d__instance(c__ProbabilityFn,c__AsymmetricRelation) ).

fof(mergeA666,axiom,
    p__d__instance(c__conditionalProbability,c__ProbabilityRelation) ).

fof(mergeA667,axiom,
    p__d__instance(c__conditionalProbability,c__TernaryPredicate) ).

fof(mergeA671,axiom,
    p__d__instance(c__increasesLikelihood,c__ProbabilityRelation) ).

fof(mergeA672,axiom,
    p__d__instance(c__increasesLikelihood,c__BinaryPredicate) ).

fof(mergeA673,axiom,
    p__d__instance(c__increasesLikelihood,c__IrreflexiveRelation) ).

fof(mergeA676,axiom,
    p__disjointRelation(c__increasesLikelihood,c__decreasesLikelihood) ).

fof(mergeA677,axiom,
    p__disjointRelation(c__increasesLikelihood,c__independentProbability) ).

fof(mergeA678,axiom,
    p__disjointRelation(c__decreasesLikelihood,c__independentProbability) ).

fof(mergeA679,axiom,
    ! [FORMULA1,FORMULA2,NUMBER2,NUMBER1] :
      ( ( p__d__instance(FORMULA2,c__Formula)
        & p__d__instance(FORMULA1,c__Formula)
        & p__d__instance(NUMBER1,c__RealNumber)
        & p__d__instance(NUMBER2,c__RealNumber)
        & p__increasesLikelihood(FORMULA1,FORMULA2)
        & f__ProbabilityFn1(FORMULA2) = NUMBER1
        & p__conditionalProbability(FORMULA1,FORMULA2,NUMBER2) )
     => p__greaterThan(NUMBER2,NUMBER1) ) ).

fof(mergeA680,axiom,
    p__d__instance(c__decreasesLikelihood,c__ProbabilityRelation) ).

fof(mergeA681,axiom,
    p__d__instance(c__decreasesLikelihood,c__BinaryPredicate) ).

fof(mergeA682,axiom,
    p__d__instance(c__decreasesLikelihood,c__IrreflexiveRelation) ).

fof(mergeA685,axiom,
    ! [FORMULA1,FORMULA2,NUMBER2,NUMBER1] :
      ( ( p__d__instance(FORMULA2,c__Formula)
        & p__d__instance(FORMULA1,c__Formula)
        & p__d__instance(NUMBER1,c__RealNumber)
        & p__d__instance(NUMBER2,c__RealNumber)
        & p__decreasesLikelihood(FORMULA1,FORMULA2)
        & f__ProbabilityFn1(FORMULA2) = NUMBER1
        & p__conditionalProbability(FORMULA1,FORMULA2,NUMBER2) )
     => p__lessThan(NUMBER2,NUMBER1) ) ).

fof(mergeA686,axiom,
    p__d__instance(c__independentProbability,c__ProbabilityRelation) ).

fof(mergeA687,axiom,
    p__d__instance(c__independentProbability,c__BinaryPredicate) ).

fof(mergeA688,axiom,
    p__d__instance(c__independentProbability,c__SymmetricRelation) ).

fof(mergeA691,axiom,
    ! [FORMULA1,FORMULA2,NUMBER2,NUMBER1] :
      ( ( p__d__instance(FORMULA2,c__Formula)
        & p__d__instance(FORMULA1,c__Formula)
        & p__d__instance(NUMBER1,c__RealNumber)
        & p__d__instance(NUMBER2,c__RealNumber)
        & p__independentProbability(FORMULA1,FORMULA2)
        & f__ProbabilityFn1(FORMULA2) = NUMBER1
        & p__conditionalProbability(FORMULA1,FORMULA2,NUMBER2) )
     => NUMBER2 = NUMBER1 ) ).

fof(mergeA692,axiom,
    ! [FORMULA1,FORMULA2] :
      ( ( p__d__instance(FORMULA1,c__Formula)
        & p__d__instance(FORMULA2,c__Formula) )
     => ( p__increasesLikelihood(FORMULA1,FORMULA2)
        | p__decreasesLikelihood(FORMULA1,FORMULA2)
        | p__independentProbability(FORMULA1,FORMULA2) ) ) ).

fof(mergeA693,axiom,
    p__d__subclass(c__SpatialRelation,c__Relation) ).

fof(mergeA694,axiom,
    p__d__subclass(c__SpatialRelation,c__InheritableRelation) ).

fof(mergeA695,axiom,
    p__d__subclass(c__TemporalRelation,c__Relation) ).

fof(mergeA696,axiom,
    p__d__subclass(c__TemporalRelation,c__InheritableRelation) ).

fof(mergeA697,axiom,
    p__d__subclass(c__IntentionalRelation,c__InheritableRelation) ).

fof(mergeA698,axiom,
    p__d__subclass(c__IntentionalRelation,c__Relation) ).

fof(mergeA699,axiom,
    p__d__instance(c__prefers,c__TernaryPredicate) ).

fof(mergeA700,axiom,
    p__d__instance(c__prefers,c__IntentionalRelation) ).

fof(mergeA704,axiom,
    p__d__subclass(c__PropositionalAttitude,c__IntentionalRelation) ).

fof(mergeA705,axiom,
    p__d__subclass(c__PropositionalAttitude,c__AsymmetricRelation) ).

fof(mergeA706,axiom,
    p__d__subclass(c__PropositionalAttitude,c__InheritableRelation) ).

fof(mergeA707,axiom,
    ! [REL,AGENT,FORMULA] :
      ( ( p__d__instance(REL,c__PropositionalAttitude)
        & p__d__holds3(REL,AGENT,FORMULA) )
     => p__d__instance(FORMULA,c__Formula) ) ).

fof(mergeA708,axiom,
    p__d__subclass(c__ObjectAttitude,c__IntentionalRelation) ).

fof(mergeA709,axiom,
    p__d__subclass(c__ObjectAttitude,c__InheritableRelation) ).

fof(mergeA710,axiom,
    p__d__disjoint(c__ObjectAttitude,c__PropositionalAttitude) ).

fof(mergeA711,axiom,
    ! [REL,AGENT,THING] :
      ( ( p__d__instance(REL,c__BinaryRelation)
        & p__d__instance(REL,c__ObjectAttitude)
        & p__d__holds3(REL,AGENT,THING) )
     => p__d__instance(THING,c__Physical) ) ).

fof(mergeA712,axiom,
    p__d__instance(c__inScopeOfInterest,c__BinaryPredicate) ).

fof(mergeA713,axiom,
    p__d__instance(c__inScopeOfInterest,c__IntentionalRelation) ).

fof(mergeA716,axiom,
    ! [AGENT,OBJECT] :
      ( p__d__instance(AGENT,c__CognitiveAgent)
     => ( ? [PROCESS] :
            ( p__d__instance(PROCESS,c__IntentionalProcess)
            & p__agent(PROCESS,AGENT)
            & p__patient(PROCESS,OBJECT) )
      <=> p__inScopeOfInterest(AGENT,OBJECT) ) ) ).

fof(mergeA717,axiom,
    p__d__instance(c__needs,c__ObjectAttitude) ).

fof(mergeA718,axiom,
    p__d__instance(c__needs,c__BinaryPredicate) ).

fof(mergeA719,axiom,
    p__subrelation(c__needs,c__inScopeOfInterest) ).

fof(mergeA722,axiom,
    ! [AGENT,OBJECT] :
      ( ( p__d__instance(OBJECT,c__Physical)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__needs(AGENT,OBJECT) )
     => p__wants(AGENT,OBJECT) ) ).

fof(mergeA723,axiom,
    p__d__instance(c__wants,c__ObjectAttitude) ).

fof(mergeA724,axiom,
    p__d__instance(c__wants,c__BinaryPredicate) ).

fof(mergeA725,axiom,
    p__subrelation(c__wants,c__inScopeOfInterest) ).

fof(mergeA726,axiom,
    p__relatedInternalConcept(c__wants,c__desires) ).

fof(mergeA729,axiom,
    ! [OBJ,AGENT] :
      ( ( p__d__instance(OBJ,c__Physical)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__wants(AGENT,OBJ) )
     => ? [PURP] :
          ( p__d__instance(PURP,c__Formula)
          & p__hasPurposeForAgent(OBJ,PURP,AGENT) ) ) ).

fof(mergeA731,axiom,
    p__d__instance(c__desires,c__PropositionalAttitude) ).

fof(mergeA732,axiom,
    p__d__instance(c__desires,c__BinaryPredicate) ).

fof(mergeA733,axiom,
    p__subrelation(c__desires,c__inScopeOfInterest) ).

fof(mergeA734,axiom,
    p__relatedInternalConcept(c__desires,c__wants) ).

fof(mergeA737,axiom,
    p__d__instance(c__considers,c__PropositionalAttitude) ).

fof(mergeA738,axiom,
    p__d__instance(c__considers,c__BinaryPredicate) ).

fof(mergeA739,axiom,
    p__subrelation(c__considers,c__inScopeOfInterest) ).

fof(mergeA742,axiom,
    p__d__instance(c__believes,c__PropositionalAttitude) ).

fof(mergeA743,axiom,
    p__d__instance(c__believes,c__BinaryPredicate) ).

fof(mergeA744,axiom,
    p__subrelation(c__believes,c__inScopeOfInterest) ).

fof(mergeA748,axiom,
    p__d__instance(c__knows,c__PropositionalAttitude) ).

fof(mergeA749,axiom,
    p__d__instance(c__knows,c__BinaryPredicate) ).

fof(mergeA750,axiom,
    p__subrelation(c__knows,c__inScopeOfInterest) ).

fof(mergeA753,axiom,
    ! [AGENT,FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__knows(AGENT,FORMULA) )
     => p__believes(AGENT,FORMULA) ) ).

fof(mergeA754,axiom,
    ! [AGENT,FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__knows(AGENT,FORMULA) )
     => p__truth(FORMULA,c__True) ) ).

fof(mergeA755,axiom,
    p__d__subclass(c__TernaryRelation,c__Relation) ).

fof(mergeA764,axiom,
    p__d__subclass(c__QuaternaryRelation,c__Relation) ).

fof(mergeA775,axiom,
    p__d__subclass(c__QuintaryRelation,c__Relation) ).

fof(mergeA788,axiom,
    p__d__subclass(c__List,c__Relation) ).

fof(mergeA789,axiom,
    p__d__subclass(c__UniqueList,c__List) ).

fof(mergeA791,axiom,
    p__d__instance(c__NullList,c__List) ).

fof(mergeA792,axiom,
    ! [ITEM] : ~ p__inList(ITEM,c__NullList) ).

fof(mergeA793,axiom,
    p__d__instance(c__ListFn,c__Function) ).

fof(mergeA794,axiom,
    p__d__instance(c__ListFn,c__VariableArityRelation) ).

fof(mergeA796,axiom,
    p__d__instance(c__ListOrderFn,c__BinaryFunction) ).

fof(mergeA797,axiom,
    p__d__instance(c__ListOrderFn,c__PartialValuedRelation) ).

fof(mergeA801,axiom,
    p__d__instance(c__ListLengthFn,c__UnaryFunction) ).

fof(mergeA802,axiom,
    p__d__instance(c__ListLengthFn,c__TotalValuedRelation) ).

fof(mergeA807,axiom,
    p__d__instance(c__ListConcatenateFn,c__BinaryFunction) ).

fof(mergeA808,axiom,
    p__d__instance(c__ListConcatenateFn,c__TotalValuedRelation) ).

fof(mergeA812,axiom,
    p__d__instance(c__inList,c__BinaryPredicate) ).

fof(mergeA813,axiom,
    p__d__instance(c__inList,c__IrreflexiveRelation) ).

fof(mergeA814,axiom,
    p__d__instance(c__inList,c__AsymmetricRelation) ).

fof(mergeA818,axiom,
    p__d__instance(c__subList,c__BinaryPredicate) ).

fof(mergeA819,axiom,
    p__d__instance(c__subList,c__PartialOrderingRelation) ).

fof(mergeA822,axiom,
    p__d__instance(c__initialList,c__BinaryPredicate) ).

fof(mergeA823,axiom,
    p__d__instance(c__initialList,c__PartialOrderingRelation) ).

fof(mergeA824,axiom,
    p__subrelation(c__initialList,c__subList) ).

fof(mergeA826,axiom,
    p__d__instance(c__identicalListItems,c__BinaryPredicate) ).

fof(mergeA827,axiom,
    p__d__instance(c__identicalListItems,c__EquivalenceRelation) ).

fof(mergeA830,axiom,
    p__d__subclass(c__Predicate,c__Relation) ).

fof(mergeA831,axiom,
    p__d__subclass(c__Function,c__SingleValuedRelation) ).

fof(mergeA832,axiom,
    p__d__subclass(c__UnaryFunction,c__Function) ).

fof(mergeA833,axiom,
    p__d__subclass(c__UnaryFunction,c__BinaryRelation) ).

fof(mergeA834,axiom,
    ! [FUNCTION] :
      ( p__d__instance(FUNCTION,c__UnaryFunction)
     => p__valence(FUNCTION,c__1) ) ).

fof(mergeA835,axiom,
    p__d__subclass(c__OneToOneFunction,c__UnaryFunction) ).

fof(mergeA837,axiom,
    p__d__subclass(c__SequenceFunction,c__OneToOneFunction) ).

fof(mergeA838,axiom,
    ! [SEQ,CLASS] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(SEQ,c__SequenceFunction)
        & p__range(SEQ,CLASS) )
     => p__d__subclass(CLASS,c__Integer) ) ).

fof(mergeA839,axiom,
    p__d__subclass(c__BinaryFunction,c__Function) ).

fof(mergeA840,axiom,
    p__d__subclass(c__BinaryFunction,c__TernaryRelation) ).

fof(mergeA841,axiom,
    ! [FUNCTION] :
      ( p__d__instance(FUNCTION,c__BinaryFunction)
     => p__valence(FUNCTION,c__2) ) ).

fof(mergeA842,axiom,
    p__d__subclass(c__AssociativeFunction,c__BinaryFunction) ).

fof(mergeA844,axiom,
    p__d__subclass(c__CommutativeFunction,c__BinaryFunction) ).

fof(mergeA846,axiom,
    p__d__subclass(c__TernaryFunction,c__Function) ).

fof(mergeA847,axiom,
    p__d__subclass(c__TernaryFunction,c__QuaternaryRelation) ).

fof(mergeA848,axiom,
    ! [FUNCTION] :
      ( p__d__instance(FUNCTION,c__TernaryFunction)
     => p__valence(FUNCTION,c__3) ) ).

fof(mergeA849,axiom,
    p__d__subclass(c__QuaternaryFunction,c__Function) ).

fof(mergeA850,axiom,
    p__d__subclass(c__QuaternaryFunction,c__QuintaryRelation) ).

fof(mergeA851,axiom,
    ! [FUNCTION] :
      ( p__d__instance(FUNCTION,c__QuaternaryFunction)
     => p__valence(FUNCTION,c__4) ) ).

fof(mergeA852,axiom,
    p__d__subclass(c__ContinuousFunction,c__Function) ).

fof(mergeA853,axiom,
    p__d__subclass(c__BinaryPredicate,c__Predicate) ).

fof(mergeA854,axiom,
    p__d__subclass(c__BinaryPredicate,c__BinaryRelation) ).

fof(mergeA855,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__BinaryPredicate)
     => p__valence(REL,c__2) ) ).

fof(mergeA856,axiom,
    p__d__subclass(c__TernaryPredicate,c__Predicate) ).

fof(mergeA857,axiom,
    p__d__subclass(c__TernaryPredicate,c__TernaryRelation) ).

fof(mergeA858,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__TernaryPredicate)
     => p__valence(REL,c__3) ) ).

fof(mergeA859,axiom,
    p__d__subclass(c__QuaternaryPredicate,c__Predicate) ).

fof(mergeA860,axiom,
    p__d__subclass(c__QuaternaryPredicate,c__QuaternaryRelation) ).

fof(mergeA861,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__QuaternaryPredicate)
     => p__valence(REL,c__4) ) ).

fof(mergeA862,axiom,
    p__d__subclass(c__QuintaryPredicate,c__Predicate) ).

fof(mergeA863,axiom,
    p__d__subclass(c__QuintaryPredicate,c__QuintaryRelation) ).

fof(mergeA864,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__QuintaryPredicate)
     => p__valence(REL,c__5) ) ).

fof(mergeA865,axiom,
    p__d__subclass(c__VariableArityRelation,c__Relation) ).

fof(mergeA866,axiom,
    ! [REL] :
      ( p__d__instance(REL,c__VariableArityRelation)
     => ! [INT] :
          ( ~ p__d__instance(INT,c__PositiveInteger)
          | ~ p__valence(REL,INT) ) ) ).

fof(mergeA867,axiom,
    p__d__subclass(c__RelationExtendedToQuantities,c__Relation) ).

fof(mergeA868,axiom,
    p__d__subclass(c__RelationExtendedToQuantities,c__InheritableRelation) ).

fof(mergeA869,axiom,
    p__d__subclass(c__LogicalOperator,c__Predicate) ).

fof(mergeA870,axiom,
    p__d__subclass(c__Proposition,c__Abstract) ).

fof(mergeA871,axiom,
    p__d__instance(c__closedOn,c__BinaryPredicate) ).

fof(mergeA872,axiom,
    p__d__instance(c__closedOn,c__AsymmetricRelation) ).

fof(mergeA877,axiom,
    p__d__instance(c__reflexiveOn,c__BinaryPredicate) ).

fof(mergeA878,axiom,
    p__d__instance(c__reflexiveOn,c__AsymmetricRelation) ).

fof(mergeA881,axiom,
    ! [CLASS,RELATION,INST] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(RELATION,c__BinaryRelation)
        & p__reflexiveOn(RELATION,CLASS)
        & p__d__instance(INST,CLASS) )
     => p__d__holds3(RELATION,INST,INST) ) ).

fof(mergeA882,axiom,
    p__d__instance(c__irreflexiveOn,c__BinaryPredicate) ).

fof(mergeA883,axiom,
    p__d__instance(c__irreflexiveOn,c__AsymmetricRelation) ).

fof(mergeA886,axiom,
    ! [CLASS,RELATION,INST] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(RELATION,c__BinaryRelation)
        & p__irreflexiveOn(RELATION,CLASS)
        & p__d__instance(INST,CLASS) )
     => ~ p__d__holds3(RELATION,INST,INST) ) ).

fof(mergeA887,axiom,
    p__d__instance(c__partialOrderingOn,c__BinaryPredicate) ).

fof(mergeA888,axiom,
    p__d__instance(c__partialOrderingOn,c__AsymmetricRelation) ).

fof(mergeA891,axiom,
    ! [CLASS,RELATION] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(RELATION,c__BinaryRelation)
        & p__partialOrderingOn(RELATION,CLASS) )
     => ( p__reflexiveOn(RELATION,CLASS)
        & p__d__instance(RELATION,c__TransitiveRelation)
        & p__d__instance(RELATION,c__AntisymmetricRelation) ) ) ).

fof(mergeA892,axiom,
    p__d__instance(c__totalOrderingOn,c__BinaryPredicate) ).

fof(mergeA893,axiom,
    p__d__instance(c__totalOrderingOn,c__AsymmetricRelation) ).

fof(mergeA896,axiom,
    ! [RELATION,CLASS] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(RELATION,c__BinaryRelation) )
     => ( p__totalOrderingOn(RELATION,CLASS)
      <=> ( p__partialOrderingOn(RELATION,CLASS)
          & p__trichotomizingOn(RELATION,CLASS) ) ) ) ).

fof(mergeA897,axiom,
    p__d__instance(c__trichotomizingOn,c__BinaryPredicate) ).

fof(mergeA898,axiom,
    p__d__instance(c__trichotomizingOn,c__AsymmetricRelation) ).

fof(mergeA901,axiom,
    ! [CLASS,RELATION,INST1,INST2] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(RELATION,c__BinaryRelation)
        & p__trichotomizingOn(RELATION,CLASS)
        & p__d__instance(INST1,CLASS)
        & p__d__instance(INST2,CLASS) )
     => ( p__d__holds3(RELATION,INST1,INST2)
        | p__d__holds3(RELATION,INST2,INST1)
        | INST1 = INST2 ) ) ).

fof(mergeA902,axiom,
    p__d__instance(c__equivalenceRelationOn,c__BinaryPredicate) ).

fof(mergeA903,axiom,
    p__d__instance(c__equivalenceRelationOn,c__AsymmetricRelation) ).

fof(mergeA906,axiom,
    ! [RELATION,CLASS] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(RELATION,c__BinaryRelation)
        & p__equivalenceRelationOn(RELATION,CLASS) )
     => ( p__d__instance(RELATION,c__TransitiveRelation)
        & p__d__instance(RELATION,c__SymmetricRelation)
        & p__reflexiveOn(RELATION,CLASS) ) ) ).

fof(mergeA907,axiom,
    p__d__instance(c__distributes,c__BinaryPredicate) ).

fof(mergeA911,axiom,
    p__d__instance(c__relatedEvent,c__BinaryPredicate) ).

fof(mergeA912,axiom,
    p__d__instance(c__relatedEvent,c__SymmetricRelation) ).

fof(mergeA915,axiom,
    ! [P,S1,S2] :
      ( ( p__d__instance(P,c__Process)
        & p__d__instance(S1,c__Process)
        & p__d__instance(S2,c__Process)
        & p__subProcess(S1,P)
        & p__subProcess(S2,P) )
     => p__relatedEvent(S1,S2) ) ).

fof(mergeA916,axiom,
    p__d__instance(c__causes,c__BinaryPredicate) ).

fof(mergeA917,axiom,
    p__d__instance(c__causes,c__AsymmetricRelation) ).

fof(mergeA920,axiom,
    p__relatedInternalConcept(c__causes,c__causesSubclass) ).

fof(mergeA921,axiom,
    p__subrelation(c__causes,c__relatedEvent) ).

fof(mergeA922,axiom,
    ! [PROC1] :
      ( p__d__instance(PROC1,c__Process)
     => ? [PROC2] :
          ( p__d__instance(PROC2,c__Process)
          & p__causes(PROC2,PROC1) ) ) ).

fof(mergeA923,axiom,
    ! [P1,P2] :
      ( ( p__d__instance(P2,c__Process)
        & p__d__instance(P1,c__Process)
        & p__causes(P1,P2) )
     => p__earlier(f__WhenFn1(P1),f__WhenFn1(P2)) ) ).

fof(mergeA924,axiom,
    p__d__instance(c__causesSubclass,c__BinaryPredicate) ).

fof(mergeA925,axiom,
    p__d__instance(c__causesSubclass,c__AsymmetricRelation) ).

fof(mergeA928,axiom,
    ! [PROC2,PROC1,INST2] :
      ( ( p__d__subclass(PROC2,c__Process)
        & p__d__subclass(PROC1,c__Process)
        & p__d__instance(INST2,c__Process)
        & p__causesSubclass(PROC1,PROC2)
        & p__d__instance(INST2,PROC2) )
     => ? [INST1] :
          ( p__d__instance(INST1,c__Process)
          & p__d__instance(INST1,PROC1)
          & p__causes(INST1,INST2) ) ) ).

fof(mergeA929,axiom,
    p__d__instance(c__causesProposition,c__BinaryPredicate) ).

fof(mergeA930,axiom,
    p__d__instance(c__causesProposition,c__AsymmetricRelation) ).

fof(mergeA933,axiom,
    ! [SIT1,SIT2,T1,T2] :
      ( ( p__d__instance(SIT2,c__Formula)
        & p__d__instance(SIT1,c__Formula)
        & p__holdsDuring(T2,SIT2)
        & p__holdsDuring(T1,SIT1)
        & p__d__instance(T1,c__TimeInterval)
        & p__d__instance(T2,c__TimeInterval)
        & p__causesProposition(SIT1,SIT2) )
     => p__beforeOrEqual(f__BeginFn1(T1),f__BeginFn1(T2)) ) ).

fof(mergeA934,axiom,
    p__d__instance(c__copy,c__BinaryPredicate) ).

fof(mergeA935,axiom,
    p__d__instance(c__copy,c__EquivalenceRelation) ).

fof(mergeA938,axiom,
    ! [OBJ1,OBJ2,ATTR] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(ATTR,c__Attribute)
        & p__copy(OBJ1,OBJ2)
        & p__attribute(OBJ1,ATTR) )
     => p__attribute(OBJ2,ATTR) ) ).

fof(mergeA939,axiom,
    p__d__instance(c__time,c__BinaryPredicate) ).

fof(mergeA940,axiom,
    p__d__instance(c__time,c__TemporalRelation) ).

fof(mergeA941,axiom,
    p__d__instance(c__time,c__AsymmetricRelation) ).

fof(mergeA944,axiom,
    p__relatedInternalConcept(c__time,c__located) ).

fof(mergeA945,axiom,
    p__relatedInternalConcept(c__time,c__holdsDuring) ).

fof(mergeA946,axiom,
    p__d__instance(c__holdsDuring,c__BinaryPredicate) ).

fof(mergeA947,axiom,
    p__d__instance(c__holdsDuring,c__AsymmetricRelation) ).

fof(mergeA950,axiom,
    ! [SITUATION1,TIME,SITUATION2] :
      ( ( p__d__instance(SITUATION1,c__Formula)
        & p__d__instance(TIME,c__TimePosition)
        & p__d__instance(SITUATION2,c__Formula)
        & p__holdsDuring(TIME,SITUATION1)
        & p__entails(SITUATION1,SITUATION2) )
     => p__holdsDuring(TIME,SITUATION2) ) ).

fof(mergeA952,axiom,
    p__d__instance(c__capability,c__TernaryPredicate) ).

fof(mergeA956,axiom,
    ! [ARG1,PROC,ROLE,ARG2] :
      ( ( p__d__instance(ARG2,c__Object)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__holds3(ROLE,ARG1,ARG2)
        & p__d__instance(ARG1,PROC)
        & p__d__subclass(PROC,c__Process) )
     => p__capability(PROC,ROLE,ARG2) ) ).

fof(mergeA957,axiom,
    p__d__instance(c__exploits,c__BinaryPredicate) ).

fof(mergeA958,axiom,
    p__d__instance(c__exploits,c__AsymmetricRelation) ).

fof(mergeA961,axiom,
    ! [AGENT,OBJ] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(OBJ,c__Object)
        & p__exploits(OBJ,AGENT) )
     => ? [PROCESS] :
          ( p__d__instance(PROCESS,c__Process)
          & p__agent(PROCESS,AGENT)
          & p__resource(PROCESS,OBJ) ) ) ).

fof(mergeA962,axiom,
    p__d__instance(c__hasPurpose,c__BinaryPredicate) ).

fof(mergeA963,axiom,
    p__d__instance(c__hasPurpose,c__AsymmetricRelation) ).

fof(mergeA966,axiom,
    p__d__instance(c__hasPurposeForAgent,c__TernaryPredicate) ).

fof(mergeA970,axiom,
    ! [THING,PURPOSE] :
      ( ( p__d__instance(PURPOSE,c__Formula)
        & p__d__instance(THING,c__Physical)
        & p__hasPurpose(THING,PURPOSE) )
     => ? [AGENT] :
          ( p__d__instance(AGENT,c__CognitiveAgent)
          & p__hasPurposeForAgent(THING,PURPOSE,AGENT) ) ) ).

fof(mergeA971,axiom,
    p__d__instance(c__hasSkill,c__BinaryPredicate) ).

fof(mergeA972,axiom,
    p__d__instance(c__hasSkill,c__AsymmetricRelation) ).

fof(mergeA975,axiom,
    ! [PROC,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__subclass(PROC,c__Process)
        & p__hasSkill(PROC,AGENT) )
     => p__capability(PROC,c__agent,AGENT) ) ).

fof(mergeA976,axiom,
    p__d__instance(c__confersNorm,c__TernaryPredicate) ).

fof(mergeA981,axiom,
    p__d__instance(c__deprivesNorm,c__TernaryPredicate) ).

fof(mergeA982,axiom,
    p__disjointRelation(c__deprivesNorm,c__confersNorm) ).

fof(mergeA987,axiom,
    p__d__instance(c__partlyLocated,c__SpatialRelation) ).

fof(mergeA988,axiom,
    p__d__instance(c__partlyLocated,c__BinaryPredicate) ).

fof(mergeA991,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__partlyLocated(OBJ1,OBJ2) )
     => p__overlapsSpatially(OBJ1,OBJ2) ) ).

fof(mergeA992,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__partlyLocated(OBJ1,OBJ2) )
     => ? [SUB] :
          ( p__d__instance(SUB,c__Object)
          & p__part(SUB,OBJ1)
          & p__located(SUB,OBJ2) ) ) ).

fof(mergeA993,axiom,
    p__d__instance(c__located,c__AntisymmetricRelation) ).

fof(mergeA994,axiom,
    p__d__instance(c__located,c__TransitiveRelation) ).

fof(mergeA995,axiom,
    p__subrelation(c__located,c__partlyLocated) ).

fof(mergeA996,axiom,
    ! [OBJ1,OBJ2,SUB] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(SUB,c__Object)
        & p__located(OBJ1,OBJ2)
        & p__part(SUB,OBJ1) )
     => p__located(SUB,OBJ2) ) ).

fof(mergeA997,axiom,
    p__d__instance(c__eventPartlyLocated,c__CaseRole) ).

fof(mergeA998,axiom,
    p__subrelation(c__eventPartlyLocated,c__partlyLocated) ).

fof(mergeA1001,axiom,
    ! [PROC,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(PROC,c__Process)
        & p__eventPartlyLocated(PROC,OBJ) )
     => ? [SUB] :
          ( p__d__instance(SUB,c__Process)
          & p__subProcess(SUB,PROC)
          & p__eventLocated(SUB,OBJ) ) ) ).

fof(mergeA1002,axiom,
    ! [PROCESS,LOC] :
      ( ( p__d__instance(LOC,c__Object)
        & p__d__instance(PROCESS,c__Process)
        & p__origin(PROCESS,LOC) )
     => p__eventPartlyLocated(PROCESS,LOC) ) ).

fof(mergeA1003,axiom,
    ! [PROCESS,LOC] :
      ( ( p__d__instance(LOC,c__Object)
        & p__d__instance(PROCESS,c__Process)
        & p__destination(PROCESS,LOC) )
     => p__eventPartlyLocated(PROCESS,LOC) ) ).

fof(mergeA1004,axiom,
    p__subrelation(c__eventLocated,c__eventPartlyLocated) ).

fof(mergeA1005,axiom,
    ! [PROCESS,OBJ,SUB] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(PROCESS,c__Process)
        & p__d__instance(SUB,c__Process)
        & p__eventLocated(PROCESS,OBJ)
        & p__subProcess(SUB,PROCESS) )
     => p__eventLocated(SUB,OBJ) ) ).

fof(mergeA1006,axiom,
    p__subrelation(c__exactlyLocated,c__located) ).

fof(mergeA1007,axiom,
    ! [REGION,OBJ] :
      ( ( p__d__instance(REGION,c__Object)
        & p__d__instance(OBJ,c__Physical)
        & p__exactlyLocated(OBJ,REGION) )
     => ! [OTHEROBJ] :
          ( ~ p__d__instance(OTHEROBJ,c__Physical)
          | ~ p__exactlyLocated(OTHEROBJ,REGION)
          | OTHEROBJ = OBJ ) ) ).

fof(mergeA1008,axiom,
    p__d__instance(c__between,c__SpatialRelation) ).

fof(mergeA1009,axiom,
    p__d__instance(c__between,c__TernaryPredicate) ).

fof(mergeA1013,axiom,
    ! [END2,MID,END1] :
      ( ( p__d__instance(END2,c__Object)
        & p__d__instance(MID,c__Object)
        & p__d__instance(END1,c__Object)
        & p__between(END1,MID,END2) )
     => p__between(END2,MID,END1) ) ).

fof(mergeA1014,axiom,
    p__d__instance(c__betweenOnPath,c__SpatialRelation) ).

fof(mergeA1015,axiom,
    p__d__instance(c__betweenOnPath,c__QuaternaryPredicate) ).

fof(mergeA1020,axiom,
    ! [PATH,OBJ1,OBJ2,OBJ3] :
      ( ( p__d__instance(PATH,c__Object)
        & p__d__instance(OBJ3,c__Object)
        & p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__betweenOnPath(OBJ1,OBJ2,OBJ3,PATH) )
     => p__between(OBJ1,OBJ2,OBJ3) ) ).

fof(mergeA1021,axiom,
    p__d__instance(c__traverses,c__BinaryPredicate) ).

fof(mergeA1022,axiom,
    p__d__instance(c__traverses,c__SpatialRelation) ).

fof(mergeA1025,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__traverses(OBJ1,OBJ2) )
     => ( p__crosses(OBJ1,OBJ2)
        | p__penetrates(OBJ1,OBJ2) ) ) ).

fof(mergeA1026,axiom,
    p__subrelation(c__crosses,c__traverses) ).

fof(mergeA1027,axiom,
    p__d__instance(c__crosses,c__AsymmetricRelation) ).

fof(mergeA1028,axiom,
    p__d__instance(c__crosses,c__TransitiveRelation) ).

fof(mergeA1029,axiom,
    p__disjointRelation(c__crosses,c__connected) ).

fof(mergeA1030,axiom,
    p__subrelation(c__penetrates,c__traverses) ).

fof(mergeA1031,axiom,
    p__subrelation(c__penetrates,c__meetsSpatially) ).

fof(mergeA1032,axiom,
    p__d__instance(c__penetrates,c__AsymmetricRelation) ).

fof(mergeA1033,axiom,
    p__d__instance(c__penetrates,c__IntransitiveRelation) ).

fof(mergeA1034,axiom,
    p__d__instance(c__WhereFn,c__BinaryFunction) ).

fof(mergeA1035,axiom,
    p__d__instance(c__WhereFn,c__SpatialRelation) ).

fof(mergeA1036,axiom,
    p__d__instance(c__WhereFn,c__TotalValuedRelation) ).

fof(mergeA1040,axiom,
    p__relatedInternalConcept(c__WhereFn,c__WhenFn) ).

fof(mergeA1042,axiom,
    p__d__instance(c__possesses,c__BinaryPredicate) ).

fof(mergeA1043,axiom,
    p__d__instance(c__possesses,c__AsymmetricRelation) ).

fof(mergeA1048,axiom,
    p__d__instance(c__PropertyFn,c__UnaryFunction) ).

fof(mergeA1049,axiom,
    p__d__instance(c__PropertyFn,c__TotalValuedRelation) ).

fof(mergeA1053,axiom,
    p__d__instance(c__precondition,c__BinaryPredicate) ).

fof(mergeA1054,axiom,
    p__d__instance(c__precondition,c__AsymmetricRelation) ).

fof(mergeA1055,axiom,
    p__d__instance(c__precondition,c__TransitiveRelation) ).

fof(mergeA1058,axiom,
    ! [PROC2,PROC1] :
      ( ( p__d__subclass(PROC2,c__Process)
        & p__d__subclass(PROC1,c__Process)
        & p__precondition(PROC1,PROC2)
        & ? [INST2] : p__d__instance(INST2,PROC2) )
     => ? [INST1] : p__d__instance(INST1,PROC1) ) ).

fof(mergeA1059,axiom,
    p__d__instance(c__hindersSubclass,c__BinaryPredicate) ).

fof(mergeA1060,axiom,
    p__d__instance(c__hindersSubclass,c__IrreflexiveRelation) ).

fof(mergeA1064,axiom,
    p__d__instance(c__preventsSubclass,c__BinaryPredicate) ).

fof(mergeA1065,axiom,
    p__d__instance(c__preventsSubclass,c__IrreflexiveRelation) ).

fof(mergeA1068,axiom,
    p__relatedInternalConcept(c__preventsSubclass,c__hindersSubclass) ).

fof(mergeA1070,axiom,
    p__d__instance(c__prevents,c__BinaryPredicate) ).

fof(mergeA1071,axiom,
    p__d__instance(c__prevents,c__IrreflexiveRelation) ).

fof(mergeA1074,axiom,
    p__relatedInternalConcept(c__prevents,c__preventsSubclass) ).

fof(mergeA1075,axiom,
    p__relatedInternalConcept(c__prevents,c__hinders) ).

fof(mergeA1077,axiom,
    p__d__instance(c__hinders,c__BinaryPredicate) ).

fof(mergeA1078,axiom,
    p__d__instance(c__hinders,c__IrreflexiveRelation) ).

fof(mergeA1081,axiom,
    p__relatedInternalConcept(c__hinders,c__hindersSubclass) ).

fof(mergeA1083,axiom,
    p__d__instance(c__refers,c__BinaryPredicate) ).

fof(mergeA1086,axiom,
    p__subrelation(c__names,c__refers) ).

fof(mergeA1088,axiom,
    p__subrelation(c__uniqueIdentifier,c__names) ).

fof(mergeA1089,axiom,
    p__d__instance(c__uniqueIdentifier,c__SingleValuedRelation) ).

fof(mergeA1090,axiom,
    p__subrelation(c__represents,c__refers) ).

fof(mergeA1091,axiom,
    p__d__instance(c__representsForAgent,c__TernaryPredicate) ).

fof(mergeA1095,axiom,
    ! [AGENT,REP,ENTITY] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__representsForAgent(REP,ENTITY,AGENT) )
     => p__represents(REP,ENTITY) ) ).

fof(mergeA1096,axiom,
    p__d__instance(c__representsInLanguage,c__TernaryPredicate) ).

fof(mergeA1100,axiom,
    ! [LANGUAGE,REP,ENTITY] :
      ( ( p__d__instance(LANGUAGE,c__Language)
        & p__d__instance(REP,c__LinguisticExpression)
        & p__representsInLanguage(REP,ENTITY,LANGUAGE) )
     => ? [AGENT] :
          ( p__d__instance(AGENT,c__Agent)
          & p__representsForAgent(REP,ENTITY,AGENT) ) ) ).

fof(mergeA1101,axiom,
    p__subrelation(c__equivalentContentClass,c__subsumesContentClass) ).

fof(mergeA1102,axiom,
    p__d__instance(c__equivalentContentClass,c__EquivalenceRelation) ).

fof(mergeA1105,axiom,
    ! [CLASS1,CLASS2] :
      ( ( p__d__subclass(CLASS2,c__ContentBearingPhysical)
        & p__d__subclass(CLASS1,c__ContentBearingPhysical) )
     => ( ( p__subsumesContentClass(CLASS1,CLASS2)
          & p__subsumesContentClass(CLASS2,CLASS1) )
      <=> p__equivalentContentClass(CLASS1,CLASS2) ) ) ).

fof(mergeA1106,axiom,
    p__d__instance(c__subsumesContentClass,c__BinaryPredicate) ).

fof(mergeA1107,axiom,
    p__d__instance(c__subsumesContentClass,c__PartialOrderingRelation) ).

fof(mergeA1110,axiom,
    ! [CLASS2,CLASS1,OBJ2,INFO] :
      ( ( p__d__subclass(CLASS2,c__ContentBearingPhysical)
        & p__d__subclass(CLASS1,c__ContentBearingPhysical)
        & p__d__instance(OBJ2,c__ContentBearingPhysical)
        & p__d__instance(INFO,c__Proposition)
        & p__subsumesContentClass(CLASS1,CLASS2)
        & p__d__instance(OBJ2,CLASS2)
        & p__containsInformation(OBJ2,INFO) )
     => ? [OBJ1] :
          ( p__d__instance(OBJ1,c__ContentBearingPhysical)
          & p__d__instance(OBJ1,CLASS1)
          & p__containsInformation(OBJ1,INFO) ) ) ).

fof(mergeA1111,axiom,
    p__subrelation(c__equivalentContentInstance,c__subsumesContentInstance) ).

fof(mergeA1112,axiom,
    p__d__instance(c__equivalentContentInstance,c__EquivalenceRelation) ).

fof(mergeA1115,axiom,
    p__relatedInternalConcept(c__equivalentContentInstance,c__equivalentContentClass) ).

fof(mergeA1116,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__ContentBearingPhysical)
        & p__d__instance(OBJ1,c__ContentBearingPhysical) )
     => ( ( p__subsumesContentInstance(OBJ1,OBJ2)
          & p__subsumesContentInstance(OBJ2,OBJ1) )
      <=> p__equivalentContentInstance(OBJ1,OBJ2) ) ) ).

fof(mergeA1117,axiom,
    p__d__instance(c__subsumesContentInstance,c__BinaryPredicate) ).

fof(mergeA1118,axiom,
    p__d__instance(c__subsumesContentInstance,c__PartialOrderingRelation) ).

fof(mergeA1121,axiom,
    p__relatedInternalConcept(c__subsumesContentInstance,c__subsumesContentClass) ).

fof(mergeA1122,axiom,
    ! [OBJ2,OBJ1,INFO] :
      ( ( p__d__instance(OBJ2,c__ContentBearingPhysical)
        & p__d__instance(OBJ1,c__ContentBearingPhysical)
        & p__d__instance(INFO,c__Proposition)
        & p__subsumesContentInstance(OBJ1,OBJ2)
        & p__containsInformation(OBJ2,INFO) )
     => p__containsInformation(OBJ1,INFO) ) ).

fof(mergeA1123,axiom,
    p__subrelation(c__realization,c__represents) ).

fof(mergeA1124,axiom,
    p__d__instance(c__realization,c__AsymmetricRelation) ).

fof(mergeA1127,axiom,
    p__relatedInternalConcept(c__realization,c__equivalentContentInstance) ).

fof(mergeA1128,axiom,
    p__relatedInternalConcept(c__realization,c__containsInformation) ).

fof(mergeA1129,axiom,
    ! [PROCESS,PROP] :
      ( ( p__d__instance(PROP,c__Proposition)
        & p__d__instance(PROCESS,c__Process)
        & p__realization(PROCESS,PROP) )
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__ContentBearingObject)
          & p__containsInformation(OBJ,PROP) ) ) ).

fof(mergeA1130,axiom,
    p__d__instance(c__expressedInLanguage,c__BinaryPredicate) ).

fof(mergeA1131,axiom,
    p__d__instance(c__expressedInLanguage,c__AsymmetricRelation) ).

fof(mergeA1134,axiom,
    ! [EXPRESS,LANGUAGE] :
      ( ( p__d__instance(LANGUAGE,c__Language)
        & p__d__instance(EXPRESS,c__LinguisticExpression) )
     => ( p__expressedInLanguage(EXPRESS,LANGUAGE)
      <=> ? [PROP] : p__representsInLanguage(EXPRESS,PROP,LANGUAGE) ) ) ).

fof(mergeA1135,axiom,
    p__d__instance(c__subProposition,c__BinaryPredicate) ).

fof(mergeA1136,axiom,
    p__d__instance(c__subProposition,c__TransitiveRelation) ).

fof(mergeA1137,axiom,
    p__d__instance(c__subProposition,c__IrreflexiveRelation) ).

fof(mergeA1140,axiom,
    ! [PROP1,PROP2,OBJ1,OBJ2] :
      ( ( p__d__instance(PROP2,c__Proposition)
        & p__d__instance(PROP1,c__Proposition)
        & p__d__instance(OBJ1,c__ContentBearingPhysical)
        & p__d__instance(OBJ2,c__ContentBearingPhysical)
        & p__subProposition(PROP1,PROP2)
        & p__containsInformation(OBJ1,PROP1)
        & p__containsInformation(OBJ2,PROP2) )
     => p__subsumesContentInstance(OBJ2,OBJ1) ) ).

fof(mergeA1141,axiom,
    p__subrelation(c__subPlan,c__subProposition) ).

fof(mergeA1142,axiom,
    p__d__instance(c__subPlan,c__TransitiveRelation) ).

fof(mergeA1143,axiom,
    p__d__instance(c__subPlan,c__IrreflexiveRelation) ).

fof(mergeA1146,axiom,
    p__d__instance(c__uses,c__BinaryPredicate) ).

fof(mergeA1147,axiom,
    p__d__instance(c__uses,c__AsymmetricRelation) ).

fof(mergeA1150,axiom,
    ! [AGENT,OBJ] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(OBJ,c__Object)
        & p__uses(OBJ,AGENT) )
     => ? [PROC] :
          ( p__d__instance(PROC,c__Process)
          & p__agent(PROC,AGENT)
          & p__instrument(PROC,OBJ) ) ) ).

fof(mergeA1151,axiom,
    p__d__instance(c__MultiplicationFn,c__BinaryFunction) ).

fof(mergeA1152,axiom,
    p__d__instance(c__MultiplicationFn,c__AssociativeFunction) ).

fof(mergeA1153,axiom,
    p__d__instance(c__MultiplicationFn,c__CommutativeFunction) ).

fof(mergeA1154,axiom,
    p__d__instance(c__MultiplicationFn,c__RelationExtendedToQuantities) ).

fof(mergeA1155,axiom,
    p__d__instance(c__MultiplicationFn,c__TotalValuedRelation) ).

fof(mergeA1159,axiom,
    p__d__instance(c__AdditionFn,c__BinaryFunction) ).

fof(mergeA1160,axiom,
    p__d__instance(c__AdditionFn,c__AssociativeFunction) ).

fof(mergeA1161,axiom,
    p__d__instance(c__AdditionFn,c__CommutativeFunction) ).

fof(mergeA1162,axiom,
    p__d__instance(c__AdditionFn,c__RelationExtendedToQuantities) ).

fof(mergeA1163,axiom,
    p__d__instance(c__AdditionFn,c__TotalValuedRelation) ).

fof(mergeA1167,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__Integer)
     => f__SuccessorFn1(NUMBER) = f__AdditionFn2(NUMBER,c__1) ) ).

fof(mergeA1168,axiom,
    p__d__instance(c__SubtractionFn,c__BinaryFunction) ).

fof(mergeA1169,axiom,
    p__d__instance(c__SubtractionFn,c__AssociativeFunction) ).

fof(mergeA1170,axiom,
    p__d__instance(c__SubtractionFn,c__RelationExtendedToQuantities) ).

fof(mergeA1171,axiom,
    p__d__instance(c__SubtractionFn,c__TotalValuedRelation) ).

fof(mergeA1175,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__Integer)
     => f__PredecessorFn1(NUMBER) = f__SubtractionFn2(NUMBER,c__1) ) ).

fof(mergeA1176,axiom,
    p__d__instance(c__DivisionFn,c__BinaryFunction) ).

fof(mergeA1177,axiom,
    p__d__instance(c__DivisionFn,c__AssociativeFunction) ).

fof(mergeA1178,axiom,
    p__d__instance(c__DivisionFn,c__RelationExtendedToQuantities) ).

fof(mergeA1179,axiom,
    p__d__instance(c__DivisionFn,c__PartialValuedRelation) ).

fof(mergeA1183,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__RationalNumber)
     => ? [INT1,INT2] :
          ( p__d__instance(INT1,c__Integer)
          & p__d__instance(INT2,c__Integer)
          & NUMBER = f__DivisionFn2(INT1,INT2) ) ) ).

fof(mergeA1184,axiom,
    p__d__instance(c__AbsoluteValueFn,c__UnaryFunction) ).

fof(mergeA1185,axiom,
    p__d__instance(c__AbsoluteValueFn,c__TotalValuedRelation) ).

fof(mergeA1188,axiom,
    ! [NUMBER2,NUMBER1] :
      ( ( p__d__instance(NUMBER1,c__RealNumber)
        & p__d__instance(NUMBER2,c__NonnegativeRealNumber) )
     => ( ( f__AbsoluteValueFn1(NUMBER1) = NUMBER2
          & p__d__instance(NUMBER1,c__RealNumber)
          & p__d__instance(NUMBER2,c__RealNumber) )
      <=> ( ( p__d__instance(NUMBER1,c__NonnegativeRealNumber)
            & NUMBER1 = NUMBER2 )
          | ( p__d__instance(NUMBER1,c__NegativeRealNumber)
            & NUMBER2 = f__SubtractionFn2(c__0,NUMBER1) ) ) ) ) ).

fof(mergeA1189,axiom,
    p__d__instance(c__CeilingFn,c__UnaryFunction) ).

fof(mergeA1190,axiom,
    p__d__instance(c__CeilingFn,c__TotalValuedRelation) ).

fof(mergeA1193,axiom,
    ! [NUMBER,INT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(INT,c__Integer)
        & f__CeilingFn1(NUMBER) = INT )
     => ! [OTHERINT] :
          ( ~ p__d__instance(OTHERINT,c__Quantity)
          | ~ p__d__instance(OTHERINT,c__Integer)
          | ~ p__greaterThanOrEqualTo(OTHERINT,NUMBER)
          | ~ p__lessThan(OTHERINT,INT) ) ) ).

fof(mergeA1194,axiom,
    p__d__instance(c__CosineFn,c__UnaryFunction) ).

fof(mergeA1195,axiom,
    p__d__instance(c__CosineFn,c__TotalValuedRelation) ).

fof(mergeA1198,axiom,
    p__d__instance(c__DenominatorFn,c__UnaryFunction) ).

fof(mergeA1199,axiom,
    p__d__instance(c__DenominatorFn,c__TotalValuedRelation) ).

fof(mergeA1202,axiom,
    p__d__instance(c__ExponentiationFn,c__BinaryFunction) ).

fof(mergeA1203,axiom,
    p__d__instance(c__ExponentiationFn,c__RelationExtendedToQuantities) ).

fof(mergeA1204,axiom,
    p__d__instance(c__ExponentiationFn,c__TotalValuedRelation) ).

fof(mergeA1208,axiom,
    p__d__instance(c__FloorFn,c__UnaryFunction) ).

fof(mergeA1209,axiom,
    p__d__instance(c__FloorFn,c__TotalValuedRelation) ).

fof(mergeA1212,axiom,
    ! [NUMBER,INT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(INT,c__Integer)
        & f__FloorFn1(NUMBER) = INT )
     => ! [OTHERINT] :
          ( ~ p__d__instance(OTHERINT,c__Quantity)
          | ~ p__d__instance(OTHERINT,c__Integer)
          | ~ p__lessThanOrEqualTo(OTHERINT,NUMBER)
          | ~ p__greaterThan(OTHERINT,INT) ) ) ).

fof(mergeA1213,axiom,
    p__d__instance(c__GreatestCommonDivisorFn,c__Function) ).

fof(mergeA1214,axiom,
    p__d__instance(c__GreatestCommonDivisorFn,c__VariableArityRelation) ).

fof(mergeA1215,axiom,
    p__d__instance(c__GreatestCommonDivisorFn,c__PartialValuedRelation) ).

fof(mergeA1219,axiom,
    p__d__instance(c__multiplicativeFactor,c__BinaryPredicate) ).

fof(mergeA1220,axiom,
    p__d__instance(c__multiplicativeFactor,c__TransitiveRelation) ).

fof(mergeA1223,axiom,
    ! [N2,N1] :
      ( ( p__d__instance(N2,c__Integer)
        & p__d__instance(N1,c__Integer)
        & p__multiplicativeFactor(N1,N2) )
     => ? [I] :
          ( p__d__instance(I,c__Integer)
          & N2 = f__MultiplicationFn2(N1,I) ) ) ).

fof(mergeA1224,axiom,
    p__d__instance(c__ImaginaryPartFn,c__UnaryFunction) ).

fof(mergeA1225,axiom,
    p__d__instance(c__ImaginaryPartFn,c__TotalValuedRelation) ).

fof(mergeA1228,axiom,
    p__d__instance(c__IntegerSquareRootFn,c__UnaryFunction) ).

fof(mergeA1229,axiom,
    p__d__instance(c__IntegerSquareRootFn,c__PartialValuedRelation) ).

fof(mergeA1232,axiom,
    p__d__instance(c__LeastCommonMultipleFn,c__Function) ).

fof(mergeA1233,axiom,
    p__d__instance(c__LeastCommonMultipleFn,c__PartialValuedRelation) ).

fof(mergeA1234,axiom,
    p__d__instance(c__LeastCommonMultipleFn,c__VariableArityRelation) ).

fof(mergeA1238,axiom,
    p__d__instance(c__LogFn,c__BinaryFunction) ).

fof(mergeA1242,axiom,
    p__d__instance(c__MaxFn,c__BinaryFunction) ).

fof(mergeA1243,axiom,
    p__d__instance(c__MaxFn,c__AssociativeFunction) ).

fof(mergeA1244,axiom,
    p__d__instance(c__MaxFn,c__CommutativeFunction) ).

fof(mergeA1245,axiom,
    p__d__instance(c__MaxFn,c__RelationExtendedToQuantities) ).

fof(mergeA1246,axiom,
    p__d__instance(c__MaxFn,c__TotalValuedRelation) ).

fof(mergeA1250,axiom,
    ! [NUMBER1,NUMBER,NUMBER2] :
      ( ( p__d__instance(NUMBER2,c__Quantity)
        & p__d__instance(NUMBER1,c__Quantity)
        & p__d__instance(NUMBER,c__Quantity)
        & f__MaxFn2(NUMBER1,NUMBER2) = NUMBER )
     => ( ( NUMBER = NUMBER1
          & p__greaterThan(NUMBER1,NUMBER2) )
        | ( NUMBER = NUMBER2
          & p__greaterThan(NUMBER2,NUMBER1) )
        | ( NUMBER = NUMBER1
          & NUMBER = NUMBER2 ) ) ) ).

fof(mergeA1251,axiom,
    p__d__instance(c__MinFn,c__BinaryFunction) ).

fof(mergeA1252,axiom,
    p__d__instance(c__MinFn,c__AssociativeFunction) ).

fof(mergeA1253,axiom,
    p__d__instance(c__MinFn,c__CommutativeFunction) ).

fof(mergeA1254,axiom,
    p__d__instance(c__MinFn,c__RelationExtendedToQuantities) ).

fof(mergeA1255,axiom,
    p__d__instance(c__MinFn,c__TotalValuedRelation) ).

fof(mergeA1259,axiom,
    ! [NUMBER1,NUMBER,NUMBER2] :
      ( ( p__d__instance(NUMBER2,c__Quantity)
        & p__d__instance(NUMBER1,c__Quantity)
        & p__d__instance(NUMBER,c__Quantity)
        & f__MinFn2(NUMBER1,NUMBER2) = NUMBER )
     => ( ( NUMBER = NUMBER1
          & p__lessThan(NUMBER1,NUMBER2) )
        | ( NUMBER = NUMBER2
          & p__lessThan(NUMBER2,NUMBER1) )
        | ( NUMBER = NUMBER1
          & NUMBER = NUMBER2 ) ) ) ).

fof(mergeA1260,axiom,
    p__d__instance(c__NumeratorFn,c__UnaryFunction) ).

fof(mergeA1261,axiom,
    p__d__instance(c__NumeratorFn,c__TotalValuedRelation) ).

fof(mergeA1264,axiom,
    p__d__instance(c__Pi,c__PositiveRealNumber) ).

fof(mergeA1265,axiom,
    p__d__instance(c__NumberE,c__PositiveRealNumber) ).

fof(mergeA1266,axiom,
    p__d__instance(c__RationalNumberFn,c__UnaryFunction) ).

fof(mergeA1269,axiom,
    p__d__instance(c__RealNumberFn,c__UnaryFunction) ).

fof(mergeA1272,axiom,
    p__d__instance(c__ReciprocalFn,c__UnaryFunction) ).

fof(mergeA1273,axiom,
    p__d__instance(c__ReciprocalFn,c__RelationExtendedToQuantities) ).

fof(mergeA1274,axiom,
    p__d__instance(c__ReciprocalFn,c__TotalValuedRelation) ).

fof(mergeA1277,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__Quantity)
     => c__1 = f__MultiplicationFn2(NUMBER,f__ReciprocalFn1(NUMBER)) ) ).

fof(mergeA1278,axiom,
    p__d__instance(c__RemainderFn,c__BinaryFunction) ).

fof(mergeA1279,axiom,
    p__d__instance(c__RemainderFn,c__RelationExtendedToQuantities) ).

fof(mergeA1280,axiom,
    p__d__instance(c__RemainderFn,c__PartialValuedRelation) ).

fof(mergeA1284,axiom,
    ! [NUMBER2,NUMBER,NUMBER1] :
      ( ( p__d__instance(NUMBER2,c__Quantity)
        & p__d__instance(NUMBER1,c__Quantity)
        & p__d__instance(NUMBER,c__Quantity) )
     => ( f__RemainderFn2(NUMBER1,NUMBER2) = NUMBER
      <=> f__AdditionFn2(f__MultiplicationFn2(f__FloorFn1(f__DivisionFn2(NUMBER1,NUMBER2)),NUMBER2),NUMBER) = NUMBER1 ) ) ).

fof(mergeA1285,axiom,
    ! [NUMBER1,NUMBER2,NUMBER] :
      ( ( p__d__instance(NUMBER2,c__RealNumber)
        & p__d__instance(NUMBER1,c__Quantity)
        & p__d__instance(NUMBER,c__RealNumber)
        & f__RemainderFn2(NUMBER1,NUMBER2) = NUMBER )
     => f__SignumFn1(NUMBER2) = f__SignumFn1(NUMBER) ) ).

fof(mergeA1286,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__EvenInteger)
     => f__RemainderFn2(NUMBER,c__2) = c__0 ) ).

fof(mergeA1287,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__OddInteger)
     => f__RemainderFn2(NUMBER,c__2) = c__1 ) ).

fof(mergeA1288,axiom,
    ! [PRIME,NUMBER] :
      ( ( p__d__instance(PRIME,c__PrimeNumber)
        & p__d__instance(NUMBER,c__Quantity)
        & f__RemainderFn2(PRIME,NUMBER) = c__0 )
     => ( NUMBER = c__1
        | NUMBER = PRIME ) ) ).

fof(mergeA1289,axiom,
    p__d__instance(c__RoundFn,c__UnaryFunction) ).

fof(mergeA1290,axiom,
    p__d__instance(c__RoundFn,c__RelationExtendedToQuantities) ).

fof(mergeA1291,axiom,
    p__d__instance(c__RoundFn,c__TotalValuedRelation) ).

fof(mergeA1294,axiom,
    p__d__instance(c__SignumFn,c__UnaryFunction) ).

fof(mergeA1295,axiom,
    p__d__instance(c__SignumFn,c__TotalValuedRelation) ).

fof(mergeA1298,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__NonnegativeRealNumber)
     => ( f__SignumFn1(NUMBER) = c__1
        | f__SignumFn1(NUMBER) = c__0 ) ) ).

fof(mergeA1299,axiom,
    ! [NUMBER] :
      ( p__d__instance(NUMBER,c__PositiveRealNumber)
     => f__SignumFn1(NUMBER) = c__1 ) ).

fof(mergeA1300,axiom,
    p__d__instance(c__SineFn,c__UnaryFunction) ).

fof(mergeA1301,axiom,
    p__d__instance(c__SineFn,c__TotalValuedRelation) ).

fof(mergeA1304,axiom,
    p__d__instance(c__SquareRootFn,c__UnaryFunction) ).

fof(mergeA1307,axiom,
    ! [NUMBER2,NUMBER1] :
      ( ( p__d__instance(NUMBER1,c__RealNumber)
        & p__d__instance(NUMBER2,c__Number)
        & f__SquareRootFn1(NUMBER1) = NUMBER2 )
     => f__MultiplicationFn2(NUMBER2,NUMBER2) = NUMBER1 ) ).

fof(mergeA1308,axiom,
    p__d__instance(c__TangentFn,c__UnaryFunction) ).

fof(mergeA1309,axiom,
    p__d__instance(c__TangentFn,c__TotalValuedRelation) ).

fof(mergeA1312,axiom,
    ! [DEGREE] :
      ( p__d__instance(DEGREE,c__PlaneAngleMeasure)
     => f__TangentFn1(DEGREE) = f__DivisionFn2(f__SineFn1(DEGREE),f__CosineFn1(DEGREE)) ) ).

fof(mergeA1313,axiom,
    p__d__instance(c__identityElement,c__BinaryPredicate) ).

fof(mergeA1314,axiom,
    p__d__instance(c__identityElement,c__AsymmetricRelation) ).

fof(mergeA1318,axiom,
    p__identityElement(c__MultiplicationFn,c__1) ).

fof(mergeA1319,axiom,
    p__identityElement(c__AdditionFn,c__0) ).

fof(mergeA1320,axiom,
    p__identityElement(c__SubtractionFn,c__0) ).

fof(mergeA1321,axiom,
    p__identityElement(c__DivisionFn,c__1) ).

fof(mergeA1322,axiom,
    p__d__instance(c__SuccessorFn,c__UnaryFunction) ).

fof(mergeA1323,axiom,
    p__d__instance(c__SuccessorFn,c__TotalValuedRelation) ).

fof(mergeA1326,axiom,
    ! [INT1,INT2] :
      ( ( p__d__instance(INT1,c__Integer)
        & p__d__instance(INT2,c__Integer)
        & f__SuccessorFn1(INT1) = f__SuccessorFn1(INT2) )
     => INT1 = INT2 ) ).

fof(mergeA1327,axiom,
    ! [INT] :
      ( p__d__instance(INT,c__Integer)
     => p__lessThan(INT,f__SuccessorFn1(INT)) ) ).

fof(mergeA1328,axiom,
    ! [INT2,INT1] :
      ( ( p__d__instance(INT1,c__Integer)
        & p__d__instance(INT2,c__Integer) )
     => ( ~ p__lessThan(INT1,INT2)
        | ~ p__lessThan(INT2,f__SuccessorFn1(INT1)) ) ) ).

fof(mergeA1329,axiom,
    ! [INT] :
      ( p__d__instance(INT,c__Integer)
     => INT = f__SuccessorFn1(f__PredecessorFn1(INT)) ) ).

fof(mergeA1330,axiom,
    ! [INT] :
      ( p__d__instance(INT,c__Integer)
     => INT = f__PredecessorFn1(f__SuccessorFn1(INT)) ) ).

fof(mergeA1331,axiom,
    p__d__instance(c__PredecessorFn,c__UnaryFunction) ).

fof(mergeA1332,axiom,
    p__d__instance(c__PredecessorFn,c__TotalValuedRelation) ).

fof(mergeA1335,axiom,
    ! [INT1,INT2] :
      ( ( p__d__instance(INT1,c__Integer)
        & p__d__instance(INT2,c__Integer)
        & f__PredecessorFn1(INT1) = f__PredecessorFn1(INT2) )
     => INT1 = INT2 ) ).

fof(mergeA1336,axiom,
    ! [INT] :
      ( p__d__instance(INT,c__Integer)
     => p__greaterThan(INT,f__PredecessorFn1(INT)) ) ).

fof(mergeA1337,axiom,
    ! [INT1,INT2] :
      ( ( p__d__instance(INT1,c__Integer)
        & p__d__instance(INT2,c__Integer) )
     => ( ~ p__lessThan(INT2,INT1)
        | ~ p__lessThan(f__PredecessorFn1(INT1),INT2) ) ) ).

fof(mergeA1338,axiom,
    p__d__instance(c__average,c__PartialValuedRelation) ).

fof(mergeA1339,axiom,
    p__d__instance(c__average,c__BinaryPredicate) ).

fof(mergeA1340,axiom,
    p__d__instance(c__average,c__SingleValuedRelation) ).

fof(mergeA1343,axiom,
    ! [AVERAGE,LIST,LISTITEM] :
      ( ( p__d__instance(AVERAGE,c__RealNumber)
        & p__d__instance(LIST,c__List)
        & p__average(LIST,AVERAGE)
        & p__inList(LISTITEM,LIST) )
     => p__d__instance(LISTITEM,c__RealNumber) ) ).

fof(mergeA1344,axiom,
    p__subrelation(c__subset,c__subclass) ).

fof(mergeA1347,axiom,
    ! [SUBSET,SET,ELEMENT] :
      ( ( p__d__instance(SET,c__Set)
        & p__d__instance(SUBSET,c__Set)
        & p__subset(SUBSET,SET)
        & p__element(ELEMENT,SUBSET) )
     => p__element(ELEMENT,SET) ) ).

fof(mergeA1348,axiom,
    p__d__instance(c__element,c__BinaryPredicate) ).

fof(mergeA1349,axiom,
    p__d__instance(c__element,c__AsymmetricRelation) ).

fof(mergeA1350,axiom,
    p__subrelation(c__element,c__instance) ).

fof(mergeA1353,axiom,
    ! [SET1,SET2] :
      ( ( p__d__instance(SET1,c__Set)
        & p__d__instance(SET2,c__Set)
        & ! [ELEMENT] :
            ( p__element(ELEMENT,SET1)
          <=> p__element(ELEMENT,SET2) ) )
     => SET1 = SET2 ) ).

fof(mergeA1354,axiom,
    p__d__instance(c__UnionFn,c__BinaryFunction) ).

fof(mergeA1355,axiom,
    p__d__instance(c__UnionFn,c__TotalValuedRelation) ).

fof(mergeA1359,axiom,
    p__d__instance(c__IntersectionFn,c__BinaryFunction) ).

fof(mergeA1360,axiom,
    p__d__instance(c__IntersectionFn,c__TotalValuedRelation) ).

fof(mergeA1364,axiom,
    p__d__instance(c__RelativeComplementFn,c__BinaryFunction) ).

fof(mergeA1365,axiom,
    p__d__instance(c__RelativeComplementFn,c__TotalValuedRelation) ).

fof(mergeA1369,axiom,
    p__d__instance(c__ComplementFn,c__UnaryFunction) ).

fof(mergeA1370,axiom,
    p__d__instance(c__ComplementFn,c__TotalValuedRelation) ).

fof(mergeA1373,axiom,
    p__d__instance(c__GeneralizedUnionFn,c__UnaryFunction) ).

fof(mergeA1374,axiom,
    p__d__instance(c__GeneralizedUnionFn,c__TotalValuedRelation) ).

fof(mergeA1377,axiom,
    p__d__instance(c__GeneralizedIntersectionFn,c__UnaryFunction) ).

fof(mergeA1378,axiom,
    p__d__instance(c__GeneralizedIntersectionFn,c__TotalValuedRelation) ).

fof(mergeA1381,axiom,
    p__d__instance(c__CardinalityFn,c__UnaryFunction) ).

fof(mergeA1382,axiom,
    p__d__instance(c__CardinalityFn,c__TotalValuedRelation) ).

fof(mergeA1383,axiom,
    p__d__instance(c__CardinalityFn,c__AsymmetricRelation) ).

fof(mergeA1386,axiom,
    p__d__subclass(c__NullSet,c__SetOrClass) ).

fof(mergeA1387,axiom,
    ! [SET] :
      ( p__d__instance(SET,c__NullSet)
     => ! [INST] : ~ p__instance(INST,SET) ) ).

fof(mergeA1388,axiom,
    p__d__subclass(c__NonNullSet,c__SetOrClass) ).

fof(mergeA1389,axiom,
    ! [SET] :
      ( p__d__instance(SET,c__NonNullSet)
     => ? [INST] : p__instance(INST,SET) ) ).

fof(mergeA1390,axiom,
    p__d__subclass(c__FiniteSet,c__Set) ).

fof(mergeA1391,axiom,
    ! [SET] :
      ( p__d__instance(SET,c__FiniteSet)
     => ? [NUMBER] :
          ( p__d__instance(NUMBER,c__NonnegativeInteger)
          & NUMBER = f__CardinalityFn1(SET) ) ) ).

fof(mergeA1392,axiom,
    p__d__subclass(c__PairwiseDisjointClass,c__SetOrClass) ).

fof(mergeA1393,axiom,
    ! [SUPERCLASS,CLASS1,CLASS2] :
      ( ( p__d__instance(SUPERCLASS,c__PairwiseDisjointClass)
        & p__d__instance(CLASS1,SUPERCLASS)
        & p__d__instance(CLASS2,SUPERCLASS) )
     => ( CLASS1 = CLASS2
        | p__d__disjoint(CLASS1,CLASS2) ) ) ).

fof(mergeA1394,axiom,
    p__d__subclass(c__MutuallyDisjointClass,c__SetOrClass) ).

fof(mergeA1395,axiom,
    ! [CLASS,INST1,INST2] :
      ( ( p__d__instance(CLASS,c__MutuallyDisjointClass)
        & p__d__instance(INST1,CLASS)
        & p__d__instance(INST2,INST1) )
     => ? [INST3] :
          ( p__d__instance(INST3,CLASS)
          & ~ p__d__instance(INST2,INST3) ) ) ).

fof(mergeA1396,axiom,
    p__d__instance(c__KappaFn,c__BinaryFunction) ).

fof(mergeA1400,axiom,
    p__d__subclass(c__Graph,c__Abstract) ).

fof(mergeA1401,axiom,
    ! [GRAPH,NODE2,NODE1] :
      ( ( p__d__instance(GRAPH,c__Graph)
        & p__d__instance(NODE1,c__GraphNode)
        & p__d__instance(NODE2,c__GraphNode)
        & p__graphPart(NODE1,GRAPH)
        & p__graphPart(NODE2,GRAPH)
        & NODE1 != NODE2 )
     => ? [ARC,PATH] :
          ( p__d__instance(ARC,c__GraphArc)
          & p__d__instance(PATH,c__GraphPath)
          & ( p__links(NODE1,NODE2,ARC)
            | ( p__subGraph(PATH,GRAPH)
              & p__d__instance(PATH,c__GraphPath)
              & ( ( f__BeginNodeFn1(PATH) = NODE1
                  & f__EndNodeFn1(PATH) = NODE2 )
                | ( f__BeginNodeFn1(PATH) = NODE2
                  & f__EndNodeFn1(PATH) = NODE1 ) ) ) ) ) ) ).

fof(mergeA1402,axiom,
    ! [GRAPH] :
      ( p__d__instance(GRAPH,c__Graph)
     => ? [NODE1,NODE2,NODE3,ARC1,ARC2] :
          ( p__d__instance(NODE1,c__GraphNode)
          & p__d__instance(NODE2,c__GraphNode)
          & p__d__instance(NODE3,c__GraphNode)
          & p__d__instance(ARC1,c__GraphArc)
          & p__d__instance(ARC2,c__GraphArc)
          & p__graphPart(NODE1,GRAPH)
          & p__graphPart(NODE2,GRAPH)
          & p__graphPart(NODE3,GRAPH)
          & p__graphPart(ARC1,GRAPH)
          & p__graphPart(ARC2,GRAPH)
          & p__links(NODE1,NODE2,ARC1)
          & p__links(NODE2,NODE3,ARC2)
          & NODE1 != NODE2
          & NODE2 != NODE3
          & NODE1 != NODE3
          & ARC1 != ARC2 ) ) ).

fof(mergeA1403,axiom,
    p__d__subclass(c__DirectedGraph,c__Graph) ).

fof(mergeA1404,axiom,
    p__d__subclass(c__Tree,c__DirectedGraph) ).

fof(mergeA1405,axiom,
    ! [GRAPH] :
      ( p__d__instance(GRAPH,c__Tree)
     => ! [LOOP] :
          ( ~ p__d__instance(LOOP,c__GraphElement)
          | ~ p__d__instance(LOOP,c__GraphLoop)
          | ~ p__graphPart(LOOP,GRAPH) ) ) ).

fof(mergeA1406,axiom,
    ! [GRAPH] :
      ( p__d__instance(GRAPH,c__Tree)
     => ! [LOOP] :
          ( ~ p__d__instance(LOOP,c__GraphElement)
          | ~ p__d__instance(LOOP,c__GraphCircuit)
          | ~ p__graphPart(LOOP,GRAPH) ) ) ).

fof(mergeA1407,axiom,
    ! [GRAPH] :
      ( p__d__instance(GRAPH,c__Tree)
     => ! [ARC1,ARC2,NODE] :
          ( ~ p__d__instance(ARC1,c__GraphArc)
          | ~ p__d__instance(ARC2,c__GraphArc)
          | ~ p__d__instance(NODE,c__GraphNode)
          | ~ p__graphPart(ARC1,GRAPH)
          | ~ p__graphPart(ARC2,GRAPH)
          | ~ p__graphPart(NODE,GRAPH)
          | f__TerminalNodeFn1(ARC1) != NODE
          | f__TerminalNodeFn1(ARC2) != NODE
          | ARC1 = ARC2 ) ) ).

fof(mergeA1408,axiom,
    p__d__subclass(c__GraphPath,c__DirectedGraph) ).

fof(mergeA1409,axiom,
    ! [GRAPH,NODE,ARC] :
      ( ( p__d__instance(NODE,c__GraphNode)
        & p__d__instance(GRAPH,c__GraphPath)
        & p__d__instance(ARC,c__GraphArc)
        & p__graphPart(ARC,GRAPH)
        & f__InitialNodeFn1(ARC) = NODE )
     => ! [OTHER] :
          ( ~ p__d__instance(OTHER,c__GraphArc)
          | f__InitialNodeFn1(OTHER) != NODE
          | OTHER = ARC ) ) ).

fof(mergeA1410,axiom,
    ! [GRAPH,NODE,ARC] :
      ( ( p__d__instance(NODE,c__GraphNode)
        & p__d__instance(GRAPH,c__GraphPath)
        & p__d__instance(ARC,c__GraphArc)
        & p__graphPart(ARC,GRAPH)
        & f__TerminalNodeFn1(ARC) = NODE )
     => ! [OTHER] :
          ( ~ p__d__instance(OTHER,c__GraphArc)
          | f__TerminalNodeFn1(OTHER) != NODE
          | OTHER = ARC ) ) ).

fof(mergeA1411,axiom,
    p__d__subclass(c__GraphCircuit,c__GraphPath) ).

fof(mergeA1412,axiom,
    ! [GRAPH] :
      ( p__d__instance(GRAPH,c__GraphPath)
     => ( p__d__instance(GRAPH,c__GraphCircuit)
      <=> ? [NODE] :
            ( p__d__instance(NODE,c__GraphNode)
            & f__BeginNodeFn1(GRAPH) = NODE
            & f__EndNodeFn1(GRAPH) = NODE ) ) ) ).

fof(mergeA1413,axiom,
    p__d__subclass(c__MultiGraph,c__Graph) ).

fof(mergeA1414,axiom,
    ! [GRAPH] :
      ( p__d__instance(GRAPH,c__Graph)
     => ( p__d__instance(GRAPH,c__MultiGraph)
      <=> ? [ARC1,ARC2,NODE1,NODE2] :
            ( p__d__instance(ARC1,c__GraphArc)
            & p__d__instance(ARC2,c__GraphArc)
            & p__d__instance(NODE1,c__GraphNode)
            & p__d__instance(NODE2,c__GraphNode)
            & p__graphPart(ARC1,GRAPH)
            & p__graphPart(ARC2,GRAPH)
            & p__graphPart(NODE1,GRAPH)
            & p__graphPart(NODE2,GRAPH)
            & p__links(NODE1,NODE2,ARC1)
            & p__links(NODE1,NODE2,ARC2)
            & ARC1 != ARC2 ) ) ) ).

fof(mergeA1415,axiom,
    p__d__subclass(c__PseudoGraph,c__Graph) ).

fof(mergeA1416,axiom,
    ! [GRAPH] :
      ( p__d__instance(GRAPH,c__Graph)
     => ( p__d__instance(GRAPH,c__PseudoGraph)
      <=> ? [LOOP] :
            ( p__d__instance(LOOP,c__GraphLoop)
            & p__graphPart(LOOP,GRAPH) ) ) ) ).

fof(mergeA1417,axiom,
    p__d__subclass(c__GraphElement,c__Abstract) ).

fof(mergeA1418,axiom,
    p__d__partition3(c__GraphElement,c__GraphNode,c__GraphArc) ).

fof(mergeA1419,axiom,
    ! [PART] :
      ( p__d__instance(PART,c__GraphElement)
     => ? [GRAPH] :
          ( p__d__instance(GRAPH,c__Graph)
          & p__graphPart(PART,GRAPH) ) ) ).

fof(mergeA1420,axiom,
    p__d__subclass(c__GraphNode,c__GraphElement) ).

fof(mergeA1421,axiom,
    ! [NODE] :
      ( p__d__instance(NODE,c__GraphNode)
     => ? [OTHER,ARC] :
          ( p__d__instance(ARC,c__GraphArc)
          & p__d__instance(OTHER,c__GraphNode)
          & p__links(NODE,OTHER,ARC) ) ) ).

fof(mergeA1422,axiom,
    p__d__subclass(c__GraphArc,c__GraphElement) ).

fof(mergeA1423,axiom,
    ! [ARC] :
      ( p__d__instance(ARC,c__GraphArc)
     => ? [NODE1,NODE2] :
          ( p__d__instance(NODE2,c__GraphNode)
          & p__d__instance(NODE1,c__GraphNode)
          & p__links(NODE1,NODE2,ARC) ) ) ).

fof(mergeA1424,axiom,
    p__d__subclass(c__GraphLoop,c__GraphArc) ).

fof(mergeA1425,axiom,
    ! [LOOP] :
      ( p__d__instance(LOOP,c__GraphArc)
     => ( p__d__instance(LOOP,c__GraphLoop)
      <=> ? [NODE] :
            ( p__d__instance(NODE,c__GraphNode)
            & p__links(NODE,NODE,LOOP) ) ) ) ).

fof(mergeA1426,axiom,
    ! [NODE,ARC] :
      ( ( p__d__instance(ARC,c__GraphArc)
        & p__d__instance(NODE,c__GraphNode)
        & f__InitialNodeFn1(ARC) = NODE
        & f__TerminalNodeFn1(ARC) = NODE )
     => p__d__instance(ARC,c__GraphLoop) ) ).

fof(mergeA1427,axiom,
    p__d__instance(c__links,c__TernaryPredicate) ).

fof(mergeA1431,axiom,
    ! [NODE2,NODE1,ARC] :
      ( ( p__d__instance(ARC,c__GraphArc)
        & p__d__instance(NODE2,c__GraphNode)
        & p__d__instance(NODE1,c__GraphNode)
        & p__links(NODE1,NODE2,ARC) )
     => p__links(NODE2,NODE1,ARC) ) ).

fof(mergeA1432,axiom,
    p__d__instance(c__graphPart,c__BinaryPredicate) ).

fof(mergeA1433,axiom,
    p__d__instance(c__graphPart,c__AsymmetricRelation) ).

fof(mergeA1434,axiom,
    p__d__instance(c__graphPart,c__IrreflexiveRelation) ).

fof(mergeA1437,axiom,
    p__d__instance(c__subGraph,c__BinaryPredicate) ).

fof(mergeA1438,axiom,
    p__d__instance(c__subGraph,c__ReflexiveRelation) ).

fof(mergeA1439,axiom,
    p__d__instance(c__subGraph,c__TransitiveRelation) ).

fof(mergeA1442,axiom,
    ! [GRAPH1,ELEMENT,GRAPH2] :
      ( ( p__d__instance(GRAPH2,c__Graph)
        & p__d__instance(GRAPH1,c__Graph)
        & p__d__instance(ELEMENT,c__GraphElement)
        & p__subGraph(GRAPH1,GRAPH2)
        & p__graphPart(ELEMENT,GRAPH1) )
     => p__graphPart(ELEMENT,GRAPH2) ) ).

fof(mergeA1443,axiom,
    p__d__instance(c__pathLength,c__BinaryPredicate) ).

fof(mergeA1444,axiom,
    p__d__instance(c__pathLength,c__AsymmetricRelation) ).

fof(mergeA1445,axiom,
    p__d__instance(c__pathLength,c__IrreflexiveRelation) ).

fof(mergeA1448,axiom,
    p__d__instance(c__InitialNodeFn,c__UnaryFunction) ).

fof(mergeA1449,axiom,
    p__d__instance(c__InitialNodeFn,c__PartialValuedRelation) ).

fof(mergeA1452,axiom,
    p__d__instance(c__TerminalNodeFn,c__UnaryFunction) ).

fof(mergeA1453,axiom,
    p__d__instance(c__TerminalNodeFn,c__PartialValuedRelation) ).

fof(mergeA1456,axiom,
    p__d__instance(c__BeginNodeFn,c__UnaryFunction) ).

fof(mergeA1457,axiom,
    p__d__instance(c__BeginNodeFn,c__TotalValuedRelation) ).

fof(mergeA1460,axiom,
    p__relatedInternalConcept(c__BeginNodeFn,c__InitialNodeFn) ).

fof(mergeA1461,axiom,
    p__d__instance(c__EndNodeFn,c__UnaryFunction) ).

fof(mergeA1462,axiom,
    p__d__instance(c__EndNodeFn,c__TotalValuedRelation) ).

fof(mergeA1465,axiom,
    p__relatedInternalConcept(c__EndNodeFn,c__TerminalNodeFn) ).

fof(mergeA1466,axiom,
    p__d__instance(c__arcWeight,c__BinaryPredicate) ).

fof(mergeA1467,axiom,
    p__d__instance(c__arcWeight,c__SingleValuedRelation) ).

fof(mergeA1470,axiom,
    p__d__instance(c__PathWeightFn,c__UnaryFunction) ).

fof(mergeA1473,axiom,
    ! [PATH,ARC1,SUM,SUBPATH,NUMBER1] :
      ( ( p__d__instance(PATH,c__GraphPath)
        & p__d__instance(SUM,c__Quantity)
        & p__d__instance(SUBPATH,c__GraphPath)
        & p__d__instance(ARC1,c__GraphArc)
        & p__d__instance(NUMBER1,c__Quantity)
        & f__PathWeightFn1(PATH) = SUM
        & p__subGraph(SUBPATH,PATH)
        & p__graphPart(ARC1,PATH)
        & p__arcWeight(ARC1,NUMBER1)
        & ! [ARC2] :
            ( ( p__d__instance(ARC2,c__GraphElement)
              & p__graphPart(ARC2,PATH) )
           => ( p__graphPart(ARC2,SUBPATH)
              | ARC2 = ARC1 ) ) )
     => SUM = f__AdditionFn2(f__PathWeightFn1(SUBPATH),NUMBER1) ) ).

fof(mergeA1474,axiom,
    ! [SUM,ARC1,ARC2,PATH,NUMBER1,NUMBER2] :
      ( ( p__d__instance(PATH,c__GraphPath)
        & p__d__instance(SUM,c__Quantity)
        & p__d__instance(ARC1,c__GraphArc)
        & p__d__instance(ARC2,c__GraphArc)
        & p__d__instance(NUMBER1,c__Quantity)
        & p__d__instance(NUMBER2,c__Quantity)
        & f__PathWeightFn1(PATH) = SUM
        & p__graphPart(ARC1,PATH)
        & p__graphPart(ARC2,PATH)
        & p__arcWeight(ARC1,NUMBER1)
        & p__arcWeight(ARC2,NUMBER2)
        & ! [ARC3] :
            ( ( p__d__instance(ARC3,c__GraphArc)
              & p__graphPart(ARC3,PATH) )
           => ( ARC3 = ARC1
              | ARC3 = ARC2 ) ) )
     => f__PathWeightFn1(PATH) = f__AdditionFn2(NUMBER1,NUMBER2) ) ).

fof(mergeA1475,axiom,
    p__d__instance(c__MinimalWeightedPathFn,c__BinaryFunction) ).

fof(mergeA1481,axiom,
    p__d__instance(c__MaximalWeightedPathFn,c__BinaryFunction) ).

fof(mergeA1487,axiom,
    p__d__instance(c__GraphPathFn,c__BinaryFunction) ).

fof(mergeA1488,axiom,
    p__d__instance(c__GraphPathFn,c__TotalValuedRelation) ).

fof(mergeA1492,axiom,
    ! [GRAPH,NODE2,NODE1,PATH] :
      ( ( p__d__instance(GRAPH,c__Graph)
        & p__d__instance(PATH,c__GraphElement)
        & p__d__subclass(PATH,c__GraphPath)
        & p__d__instance(NODE2,c__GraphNode)
        & p__d__instance(NODE1,c__GraphNode)
        & p__graphPart(PATH,GRAPH)
        & ~ p__d__instance(GRAPH,c__DirectedGraph) )
     => ( f__GraphPathFn2(NODE1,NODE2) = PATH
      <=> f__GraphPathFn2(NODE2,NODE1) = PATH ) ) ).

fof(mergeA1493,axiom,
    p__d__instance(c__CutSetFn,c__UnaryFunction) ).

fof(mergeA1496,axiom,
    p__d__instance(c__MinimalCutSetFn,c__UnaryFunction) ).

fof(mergeA1499,axiom,
    p__relatedInternalConcept(c__MinimalCutSetFn,c__CutSetFn) ).

fof(mergeA1501,axiom,
    ! [GRAPH,PATHCLASS] :
      ( ( p__d__instance(GRAPH,c__Graph)
        & p__d__subclass(PATHCLASS,c__GraphPath)
        & f__MinimalCutSetFn1(GRAPH) = PATHCLASS )
     => ? [NUMBER] :
          ( p__d__instance(NUMBER,c__PositiveInteger)
          & ! [PATH] :
              ( ( p__d__instance(PATH,c__GraphPath)
                & p__d__instance(PATH,PATHCLASS) )
             => p__pathLength(PATH,NUMBER) ) ) ) ).

fof(mergeA1503,axiom,
    p__d__instance(c__abstractCounterpart,c__BinaryPredicate) ).

fof(mergeA1506,axiom,
    p__subrelation(c__abstractCounterpart,c__represents) ).

fof(mergeA1507,axiom,
    p__d__subclass(c__PhysicalSystem,c__Physical) ).

fof(mergeA1508,axiom,
    p__d__instance(c__subSystem,c__BinaryPredicate) ).

fof(mergeA1511,axiom,
    p__d__instance(c__systemPart,c__BinaryPredicate) ).

fof(mergeA1514,axiom,
    ! [SUB,PART,SYSTEM] :
      ( ( p__d__instance(SYSTEM,c__PhysicalSystem)
        & p__d__instance(SUB,c__PhysicalSystem)
        & p__d__instance(PART,c__Physical)
        & p__subSystem(SUB,SYSTEM)
        & p__systemPart(PART,SUB) )
     => p__systemPart(PART,SYSTEM) ) ).

fof(mergeA1515,axiom,
    p__d__instance(c__graphMeasure,c__BinaryPredicate) ).

fof(mergeA1518,axiom,
    ! [M,G,AC] :
      ( ( p__d__instance(M,c__UnitOfMeasure)
        & p__d__instance(G,c__Graph)
        & p__d__instance(AC,c__GraphElement)
        & p__graphMeasure(G,M) )
     => ( p__graphPart(AC,G)
        & ? [PC] :
            ( p__d__instance(PC,c__Physical)
            & p__abstractCounterpart(AC,PC) ) ) ) ).

fof(mergeA1519,axiom,
    ! [G,AN,PN,AA,PA,N,M] :
      ( ( p__d__instance(M,c__UnitOfMeasure)
        & p__d__instance(G,c__Graph)
        & p__d__instance(PN,c__Physical)
        & p__d__instance(PA,c__Object)
        & p__d__instance(N,c__RealNumber)
        & p__graphMeasure(G,M)
        & p__d__instance(AN,c__GraphNode)
        & p__d__instance(AA,c__GraphArc)
        & p__abstractCounterpart(AN,PN)
        & p__abstractCounterpart(AA,PA)
        & p__arcWeight(AA,f__MeasureFn2(N,M)) )
     => p__measure(PA,f__MeasureFn2(N,M)) ) ).

fof(mergeA1520,axiom,
    p__d__subclass(c__UnitOfMeasure,c__PhysicalQuantity) ).

fof(mergeA1521,axiom,
    p__d__subclass(c__CompositeUnitOfMeasure,c__UnitOfMeasure) ).

fof(mergeA1522,axiom,
    p__d__subclass(c__NonCompositeUnitOfMeasure,c__UnitOfMeasure) ).

fof(mergeA1523,axiom,
    p__d__partition3(c__UnitOfMeasure,c__CompositeUnitOfMeasure,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1526,axiom,
    p__d__subclass(c__SystemeInternationalUnit,c__UnitOfMeasure) ).

fof(mergeA1527,axiom,
    p__d__subclass(c__LengthMeasure,c__ConstantQuantity) ).

fof(mergeA1528,axiom,
    p__d__subclass(c__UnitOfLength,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1529,axiom,
    p__d__subclass(c__MassMeasure,c__ConstantQuantity) ).

fof(mergeA1530,axiom,
    p__d__subclass(c__UnitOfMass,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1531,axiom,
    p__d__subclass(c__AreaMeasure,c__FunctionQuantity) ).

fof(mergeA1532,axiom,
    p__d__subclass(c__UnitOfArea,c__CompositeUnitOfMeasure) ).

fof(mergeA1533,axiom,
    p__d__subclass(c__VolumeMeasure,c__FunctionQuantity) ).

fof(mergeA1534,axiom,
    p__d__subclass(c__UnitOfVolume,c__CompositeUnitOfMeasure) ).

fof(mergeA1535,axiom,
    p__d__subclass(c__TemperatureMeasure,c__ConstantQuantity) ).

fof(mergeA1536,axiom,
    p__d__subclass(c__UnitOfTemperature,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1537,axiom,
    p__d__subclass(c__CurrencyMeasure,c__ConstantQuantity) ).

fof(mergeA1538,axiom,
    p__d__subclass(c__UnitOfCurrency,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1539,axiom,
    p__d__subclass(c__AngleMeasure,c__ConstantQuantity) ).

fof(mergeA1540,axiom,
    p__d__subclass(c__UnitOfAngularMeasure,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1541,axiom,
    p__d__subclass(c__PlaneAngleMeasure,c__AngleMeasure) ).

fof(mergeA1542,axiom,
    p__d__subclass(c__SolidAngleMeasure,c__AngleMeasure) ).

fof(mergeA1543,axiom,
    p__d__disjoint(c__SolidAngleMeasure,c__PlaneAngleMeasure) ).

fof(mergeA1544,axiom,
    p__d__subclass(c__UnitOfInformation,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1545,axiom,
    p__d__subclass(c__UnitOfDuration,c__NonCompositeUnitOfMeasure) ).

fof(mergeA1546,axiom,
    p__d__instance(c__MeasureFn,c__BinaryFunction) ).

fof(mergeA1547,axiom,
    p__d__instance(c__MeasureFn,c__TotalValuedRelation) ).

fof(mergeA1551,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfLength) )
     => p__d__instance(QUANT,c__LengthMeasure) ) ).

fof(mergeA1552,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfMass) )
     => p__d__instance(QUANT,c__MassMeasure) ) ).

fof(mergeA1553,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfArea) )
     => p__d__instance(QUANT,c__AreaMeasure) ) ).

fof(mergeA1554,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfVolume) )
     => p__d__instance(QUANT,c__VolumeMeasure) ) ).

fof(mergeA1555,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfTemperature) )
     => p__d__instance(QUANT,c__TemperatureMeasure) ) ).

fof(mergeA1556,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfCurrency) )
     => p__d__instance(QUANT,c__CurrencyMeasure) ) ).

fof(mergeA1557,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfAngularMeasure) )
     => p__d__instance(QUANT,c__AngleMeasure) ) ).

fof(mergeA1558,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfDuration) )
     => p__d__instance(QUANT,c__TimeDuration) ) ).

fof(mergeA1559,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfInformation) )
     => p__d__instance(QUANT,c__InformationMeasure) ) ).

fof(mergeA1561,axiom,
    p__d__subclass(c__UnitOfMeasureMultiplier,c__UnaryFunction) ).

fof(mergeA1562,axiom,
    p__d__subclass(c__UnitOfMeasureMultiplier,c__TotalValuedRelation) ).

fof(mergeA1563,axiom,
    p__d__instance(c__KiloFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1566,axiom,
    ! [KILOUNIT,UNIT] :
      ( ( p__d__instance(KILOUNIT,c__UnitOfMeasure)
        & p__d__instance(UNIT,c__UnitOfMeasure)
        & KILOUNIT = f__KiloFn1(UNIT) )
     => f__MeasureFn2(c__1,KILOUNIT) = f__MeasureFn2(c__1000,UNIT) ) ).

fof(mergeA1567,axiom,
    p__d__instance(c__MegaFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1570,axiom,
    ! [MEGAUNIT,UNIT] :
      ( ( p__d__instance(MEGAUNIT,c__UnitOfMeasure)
        & p__d__instance(UNIT,c__UnitOfMeasure)
        & MEGAUNIT = f__MegaFn1(UNIT) )
     => f__MeasureFn2(c__1,MEGAUNIT) = f__MeasureFn2(c__1000000,UNIT) ) ).

fof(mergeA1571,axiom,
    p__d__instance(c__GigaFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1574,axiom,
    ! [GIGAUNIT,UNIT] :
      ( ( p__d__instance(GIGAUNIT,c__UnitOfMeasure)
        & p__d__instance(UNIT,c__UnitOfMeasure)
        & GIGAUNIT = f__GigaFn1(UNIT) )
     => f__MeasureFn2(c__1,GIGAUNIT) = f__MeasureFn2(c__1000000000,UNIT) ) ).

fof(mergeA1575,axiom,
    p__d__instance(c__TeraFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1578,axiom,
    ! [TERAUNIT,UNIT] :
      ( ( p__d__instance(TERAUNIT,c__UnitOfMeasure)
        & p__d__instance(UNIT,c__UnitOfMeasure)
        & TERAUNIT = f__TeraFn1(UNIT) )
     => f__MeasureFn2(c__1,TERAUNIT) = f__MeasureFn2(c__1000000000000,UNIT) ) ).

fof(mergeA1579,axiom,
    p__d__instance(c__MilliFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1582,axiom,
    p__d__instance(c__MicroFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1585,axiom,
    p__d__instance(c__NanoFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1588,axiom,
    p__d__instance(c__PicoFn,c__UnitOfMeasureMultiplier) ).

fof(mergeA1591,axiom,
    p__d__instance(c__IntervalFn,c__BinaryFunction) ).

fof(mergeA1595,axiom,
    p__relatedInternalConcept(c__IntervalFn,c__RecurrentTimeIntervalFn) ).

fof(mergeA1598,axiom,
    p__d__instance(c__MagnitudeFn,c__UnaryFunction) ).

fof(mergeA1601,axiom,
    ! [UNIT,QUANT,NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER)
        & p__d__instance(UNIT,c__UnitOfMeasure)
        & QUANT = f__MeasureFn2(NUMBER,UNIT) )
     => f__MagnitudeFn1(QUANT) = NUMBER ) ).

fof(mergeA1602,axiom,
    p__d__instance(c__UnitFn,c__UnaryFunction) ).

fof(mergeA1605,axiom,
    ! [NUMBER,QUANT,UNIT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER)
        & p__d__instance(UNIT,c__UnitOfMeasure)
        & QUANT = f__MeasureFn2(NUMBER,UNIT) )
     => f__UnitFn1(QUANT) = UNIT ) ).

fof(mergeA1606,axiom,
    p__d__instance(c__PerFn,c__BinaryFunction) ).

fof(mergeA1607,axiom,
    p__d__instance(c__PerFn,c__TotalValuedRelation) ).

fof(mergeA1611,axiom,
    p__subrelation(c__DensityFn,c__PerFn) ).

fof(mergeA1612,axiom,
    p__d__instance(c__DensityFn,c__TotalValuedRelation) ).

fof(mergeA1616,axiom,
    p__subrelation(c__SpeedFn,c__PerFn) ).

fof(mergeA1617,axiom,
    p__d__instance(c__SpeedFn,c__TotalValuedRelation) ).

fof(mergeA1621,axiom,
    p__d__instance(c__VelocityFn,c__QuaternaryFunction) ).

fof(mergeA1622,axiom,
    p__d__instance(c__VelocityFn,c__TotalValuedRelation) ).

fof(mergeA1628,axiom,
    ! [REF,DIRECTION,OBJECT,DISTANCE,TIME] :
      ( ( p__d__instance(DIRECTION,c__DirectionalAttribute)
        & p__d__instance(REF,c__Region)
        & p__d__instance(TIME,c__TimeDuration)
        & p__d__instance(DISTANCE,c__LengthMeasure)
        & p__d__instance(OBJECT,c__Object)
        & p__measure(OBJECT,f__VelocityFn4(DISTANCE,TIME,REF,DIRECTION)) )
     => p__measure(OBJECT,f__SpeedFn2(DISTANCE,TIME)) ) ).

fof(mergeA1629,axiom,
    p__d__instance(c__Meter,c__UnitOfLength) ).

fof(mergeA1630,axiom,
    p__d__instance(c__Meter,c__SystemeInternationalUnit) ).

fof(mergeA1631,axiom,
    p__d__instance(c__Gram,c__UnitOfMass) ).

fof(mergeA1632,axiom,
    p__d__instance(c__Gram,c__SystemeInternationalUnit) ).

fof(mergeA1633,axiom,
    p__d__instance(c__SecondDuration,c__UnitOfDuration) ).

fof(mergeA1634,axiom,
    p__d__instance(c__SecondDuration,c__SystemeInternationalUnit) ).

fof(mergeA1635,axiom,
    p__d__instance(c__Ampere,c__CompositeUnitOfMeasure) ).

fof(mergeA1636,axiom,
    p__d__instance(c__Ampere,c__SystemeInternationalUnit) ).

fof(mergeA1637,axiom,
    p__d__instance(c__KelvinDegree,c__UnitOfTemperature) ).

fof(mergeA1638,axiom,
    p__d__instance(c__KelvinDegree,c__SystemeInternationalUnit) ).

fof(mergeA1639,axiom,
    p__d__instance(c__Mole,c__UnitOfMass) ).

fof(mergeA1640,axiom,
    p__d__instance(c__Mole,c__SystemeInternationalUnit) ).

fof(mergeA1641,axiom,
    p__d__instance(c__Candela,c__CompositeUnitOfMeasure) ).

fof(mergeA1642,axiom,
    p__d__instance(c__Candela,c__SystemeInternationalUnit) ).

fof(mergeA1643,axiom,
    p__d__instance(c__Liter,c__UnitOfVolume) ).

fof(mergeA1644,axiom,
    p__d__instance(c__Centimeter,c__UnitOfLength) ).

fof(mergeA1645,axiom,
    p__d__instance(c__Millimeter,c__UnitOfLength) ).

fof(mergeA1646,axiom,
    p__d__instance(c__Kilometer,c__UnitOfLength) ).

fof(mergeA1647,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__Kilometer) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__1000),c__Meter) ) ).

fof(mergeA1648,axiom,
    p__d__instance(c__Radian,c__UnitOfAngularMeasure) ).

fof(mergeA1649,axiom,
    p__d__instance(c__Radian,c__SystemeInternationalUnit) ).

fof(mergeA1650,axiom,
    p__d__instance(c__Steradian,c__UnitOfAngularMeasure) ).

fof(mergeA1651,axiom,
    p__d__instance(c__Steradian,c__SystemeInternationalUnit) ).

fof(mergeA1652,axiom,
    p__d__subclass(c__FrequencyMeasure,c__TimeDependentQuantity) ).

fof(mergeA1653,axiom,
    p__d__subclass(c__UnitOfFrequency,c__CompositeUnitOfMeasure) ).

fof(mergeA1654,axiom,
    ! [NUMBER,UNIT,QUANT] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & f__MeasureFn2(NUMBER,UNIT) = QUANT
        & p__d__instance(UNIT,c__UnitOfFrequency) )
     => p__d__instance(QUANT,c__FrequencyMeasure) ) ).

fof(mergeA1655,axiom,
    p__d__instance(c__Hertz,c__UnitOfFrequency) ).

fof(mergeA1656,axiom,
    p__d__instance(c__Hertz,c__SystemeInternationalUnit) ).

fof(mergeA1657,axiom,
    p__d__instance(c__Newton,c__CompositeUnitOfMeasure) ).

fof(mergeA1658,axiom,
    p__d__instance(c__Newton,c__SystemeInternationalUnit) ).

fof(mergeA1659,axiom,
    p__d__instance(c__Pascal,c__CompositeUnitOfMeasure) ).

fof(mergeA1660,axiom,
    p__d__instance(c__Pascal,c__SystemeInternationalUnit) ).

fof(mergeA1661,axiom,
    p__d__instance(c__Joule,c__CompositeUnitOfMeasure) ).

fof(mergeA1662,axiom,
    p__d__instance(c__Joule,c__SystemeInternationalUnit) ).

fof(mergeA1663,axiom,
    p__d__instance(c__Watt,c__CompositeUnitOfMeasure) ).

fof(mergeA1664,axiom,
    p__d__instance(c__Watt,c__SystemeInternationalUnit) ).

fof(mergeA1665,axiom,
    p__d__instance(c__Horsepower,c__CompositeUnitOfMeasure) ).

fof(mergeA1666,axiom,
    ! [N] :
      ( p__d__instance(N,c__RealNumber)
     => f__MeasureFn2(N,c__Horsepower) = f__MeasureFn2(f__MultiplicationFn2(N,c__746),c__Watt) ) ).

fof(mergeA1667,axiom,
    p__d__instance(c__Coulomb,c__CompositeUnitOfMeasure) ).

fof(mergeA1668,axiom,
    p__d__instance(c__Coulomb,c__SystemeInternationalUnit) ).

fof(mergeA1669,axiom,
    ! [NUMBER,QUANTITY] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANTITY,c__PhysicalQuantity)
        & QUANTITY = f__MeasureFn2(NUMBER,c__Coulomb) )
     => p__d__instance(QUANTITY,c__TimeDependentQuantity) ) ).

fof(mergeA1670,axiom,
    p__d__instance(c__Volt,c__CompositeUnitOfMeasure) ).

fof(mergeA1671,axiom,
    p__d__instance(c__Volt,c__SystemeInternationalUnit) ).

fof(mergeA1672,axiom,
    p__d__instance(c__Farad,c__CompositeUnitOfMeasure) ).

fof(mergeA1673,axiom,
    p__d__instance(c__Farad,c__SystemeInternationalUnit) ).

fof(mergeA1674,axiom,
    p__d__instance(c__Ohm,c__CompositeUnitOfMeasure) ).

fof(mergeA1675,axiom,
    p__d__instance(c__Ohm,c__SystemeInternationalUnit) ).

fof(mergeA1676,axiom,
    p__d__instance(c__Siemens,c__CompositeUnitOfMeasure) ).

fof(mergeA1677,axiom,
    p__d__instance(c__Siemens,c__SystemeInternationalUnit) ).

fof(mergeA1678,axiom,
    p__d__instance(c__Weber,c__CompositeUnitOfMeasure) ).

fof(mergeA1679,axiom,
    p__d__instance(c__Weber,c__SystemeInternationalUnit) ).

fof(mergeA1680,axiom,
    p__d__instance(c__Tesla,c__CompositeUnitOfMeasure) ).

fof(mergeA1681,axiom,
    p__d__instance(c__Tesla,c__SystemeInternationalUnit) ).

fof(mergeA1682,axiom,
    p__d__instance(c__Henry,c__CompositeUnitOfMeasure) ).

fof(mergeA1683,axiom,
    p__d__instance(c__Henry,c__SystemeInternationalUnit) ).

fof(mergeA1684,axiom,
    p__d__instance(c__CelsiusDegree,c__UnitOfTemperature) ).

fof(mergeA1685,axiom,
    p__d__instance(c__CelsiusDegree,c__SystemeInternationalUnit) ).

fof(mergeA1686,axiom,
    p__d__instance(c__Lumen,c__CompositeUnitOfMeasure) ).

fof(mergeA1687,axiom,
    p__d__instance(c__Lumen,c__SystemeInternationalUnit) ).

fof(mergeA1688,axiom,
    p__d__instance(c__Lux,c__CompositeUnitOfMeasure) ).

fof(mergeA1689,axiom,
    p__d__instance(c__Lux,c__SystemeInternationalUnit) ).

fof(mergeA1690,axiom,
    p__d__instance(c__Becquerel,c__CompositeUnitOfMeasure) ).

fof(mergeA1691,axiom,
    p__d__instance(c__Becquerel,c__SystemeInternationalUnit) ).

fof(mergeA1692,axiom,
    ! [NUMBER,QUANTITY] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(QUANTITY,c__PhysicalQuantity)
        & QUANTITY = f__MeasureFn2(NUMBER,c__Becquerel) )
     => p__d__instance(QUANTITY,c__TimeDependentQuantity) ) ).

fof(mergeA1693,axiom,
    p__d__instance(c__Gray,c__CompositeUnitOfMeasure) ).

fof(mergeA1694,axiom,
    p__d__instance(c__Gray,c__SystemeInternationalUnit) ).

fof(mergeA1695,axiom,
    p__d__instance(c__Sievert,c__CompositeUnitOfMeasure) ).

fof(mergeA1696,axiom,
    p__d__instance(c__Sievert,c__SystemeInternationalUnit) ).

fof(mergeA1697,axiom,
    p__d__instance(c__DayDuration,c__UnitOfDuration) ).

fof(mergeA1698,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__DayDuration) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__24),c__HourDuration) ) ).

fof(mergeA1699,axiom,
    p__d__instance(c__HourDuration,c__UnitOfDuration) ).

fof(mergeA1700,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__HourDuration) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__60),c__MinuteDuration) ) ).

fof(mergeA1701,axiom,
    p__d__instance(c__MinuteDuration,c__UnitOfDuration) ).

fof(mergeA1702,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__MinuteDuration) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__60),c__SecondDuration) ) ).

fof(mergeA1703,axiom,
    p__d__instance(c__WeekDuration,c__UnitOfDuration) ).

fof(mergeA1704,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__WeekDuration) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__7),c__DayDuration) ) ).

fof(mergeA1705,axiom,
    p__d__instance(c__MonthDuration,c__UnitOfDuration) ).

fof(mergeA1708,axiom,
    p__d__instance(c__YearDuration,c__UnitOfDuration) ).

fof(mergeA1709,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__YearDuration) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__365),c__DayDuration) ) ).

fof(mergeA1710,axiom,
    p__d__instance(c__Amu,c__UnitOfMass) ).

fof(mergeA1711,axiom,
    p__d__instance(c__ElectronVolt,c__CompositeUnitOfMeasure) ).

fof(mergeA1712,axiom,
    p__d__instance(c__Angstrom,c__UnitOfLength) ).

fof(mergeA1713,axiom,
    p__d__instance(c__FootLength,c__UnitOfLength) ).

fof(mergeA1714,axiom,
    p__d__instance(c__Inch,c__UnitOfLength) ).

fof(mergeA1715,axiom,
    p__d__instance(c__Mile,c__UnitOfLength) ).

fof(mergeA1716,axiom,
    p__d__instance(c__UnitedStatesGallon,c__UnitOfVolume) ).

fof(mergeA1717,axiom,
    p__relatedInternalConcept(c__UnitedStatesGallon,c__UnitedKingdomGallon) ).

fof(mergeA1718,axiom,
    p__d__instance(c__Quart,c__UnitOfVolume) ).

fof(mergeA1719,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__Quart) = f__MeasureFn2(f__DivisionFn2(NUMBER,c__4),c__UnitedStatesGallon) ) ).

fof(mergeA1720,axiom,
    p__d__instance(c__Pint,c__UnitOfVolume) ).

fof(mergeA1721,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__Pint) = f__MeasureFn2(f__DivisionFn2(NUMBER,c__2),c__Quart) ) ).

fof(mergeA1722,axiom,
    p__d__instance(c__Cup,c__UnitOfVolume) ).

fof(mergeA1723,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__Cup) = f__MeasureFn2(f__DivisionFn2(NUMBER,c__2),c__Pint) ) ).

fof(mergeA1724,axiom,
    p__d__instance(c__Ounce,c__UnitOfVolume) ).

fof(mergeA1725,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__Ounce) = f__MeasureFn2(f__DivisionFn2(NUMBER,c__8),c__Cup) ) ).

fof(mergeA1726,axiom,
    p__d__instance(c__UnitedKingdomGallon,c__UnitOfVolume) ).

fof(mergeA1727,axiom,
    p__d__instance(c__AtomGram,c__UnitOfMass) ).

fof(mergeA1728,axiom,
    p__d__instance(c__Kilogram,c__SystemeInternationalUnit) ).

fof(mergeA1729,axiom,
    p__d__instance(c__Kilogram,c__UnitOfMass) ).

fof(mergeA1730,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__Kilogram) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__1000),c__Gram) ) ).

fof(mergeA1733,axiom,
    p__d__instance(c__weight,c__BinaryPredicate) ).

fof(mergeA1734,axiom,
    p__subrelation(c__weight,c__measure) ).

fof(mergeA1735,axiom,
    p__d__instance(c__PoundMass,c__UnitOfMass) ).

fof(mergeA1736,axiom,
    p__d__instance(c__Slug,c__UnitOfMass) ).

fof(mergeA1737,axiom,
    p__d__instance(c__RankineDegree,c__UnitOfTemperature) ).

fof(mergeA1738,axiom,
    p__d__instance(c__FahrenheitDegree,c__UnitOfTemperature) ).

fof(mergeA1739,axiom,
    p__d__instance(c__PoundForce,c__CompositeUnitOfMeasure) ).

fof(mergeA1740,axiom,
    p__d__instance(c__Calorie,c__CompositeUnitOfMeasure) ).

fof(mergeA1741,axiom,
    p__d__instance(c__BritishThermalUnit,c__CompositeUnitOfMeasure) ).

fof(mergeA1742,axiom,
    p__d__instance(c__AngularDegree,c__UnitOfAngularMeasure) ).

fof(mergeA1743,axiom,
    ! [N,QUANT] :
      ( ( p__d__instance(N,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & QUANT = f__MeasureFn2(N,c__AngularDegree) )
     => p__d__instance(QUANT,c__PlaneAngleMeasure) ) ).

fof(mergeA1744,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__AngularDegree) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,f__DivisionFn2(c__Pi,c__180)),c__Radian) ) ).

fof(mergeA1745,axiom,
    ! [ANGLE,NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(ANGLE,c__Object)
        & p__measure(ANGLE,f__MeasureFn2(NUMBER,c__AngularDegree)) )
     => ( p__greaterThanOrEqualTo(NUMBER,c__0)
        & p__lessThanOrEqualTo(NUMBER,c__360) ) ) ).

fof(mergeA1746,axiom,
    f__MeasureFn2(c__0,c__AngularDegree) = f__MeasureFn2(c__360,c__AngularDegree) ).

fof(mergeA1747,axiom,
    p__d__instance(c__UnitedStatesDollar,c__UnitOfCurrency) ).

fof(mergeA1748,axiom,
    p__d__instance(c__UnitedStatesCent,c__UnitOfCurrency) ).

fof(mergeA1749,axiom,
    p__d__instance(c__EuroDollar,c__UnitOfCurrency) ).

fof(mergeA1750,axiom,
    p__d__instance(c__EuroCent,c__UnitOfCurrency) ).

fof(mergeA1751,axiom,
    p__d__subclass(c__InformationMeasure,c__ConstantQuantity) ).

fof(mergeA1752,axiom,
    p__d__instance(c__Bit,c__UnitOfInformation) ).

fof(mergeA1753,axiom,
    p__d__instance(c__Byte,c__UnitOfInformation) ).

fof(mergeA1754,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__Byte) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__8),c__Bit) ) ).

fof(mergeA1755,axiom,
    p__d__instance(c__KiloByte,c__UnitOfInformation) ).

fof(mergeA1756,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__KiloByte) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__1024),c__Byte) ) ).

fof(mergeA1757,axiom,
    p__d__instance(c__MegaByte,c__UnitOfInformation) ).

fof(mergeA1758,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__MegaByte) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__1024),c__KiloByte) ) ).

fof(mergeA1759,axiom,
    p__d__instance(c__measure,c__BinaryPredicate) ).

fof(mergeA1760,axiom,
    p__d__instance(c__measure,c__AsymmetricRelation) ).

fof(mergeA1763,axiom,
    p__d__instance(c__age,c__SingleValuedRelation) ).

fof(mergeA1764,axiom,
    p__subrelation(c__age,c__measure) ).

fof(mergeA1767,axiom,
    p__subrelation(c__linearExtent,c__measure) ).

fof(mergeA1769,axiom,
    p__d__instance(c__width,c__SingleValuedRelation) ).

fof(mergeA1770,axiom,
    p__subrelation(c__width,c__linearExtent) ).

fof(mergeA1771,axiom,
    p__subrelation(c__height,c__linearExtent) ).

fof(mergeA1774,axiom,
    p__d__instance(c__length,c__SingleValuedRelation) ).

fof(mergeA1775,axiom,
    p__subrelation(c__length,c__linearExtent) ).

fof(mergeA1776,axiom,
    ! [O,M] :
      ( ( p__d__instance(M,c__LengthMeasure)
        & p__d__instance(O,c__Object)
        & p__length(O,M) )
     => ! [M2] :
          ( ~ p__d__instance(M2,c__LengthMeasure)
          | ~ p__linearExtent(O,M2)
          | ~ p__greaterThan(M2,M) ) ) ).

fof(mergeA1777,axiom,
    p__d__subclass(c__Oval,c__ClosedTwoDimensionalFigure) ).

fof(mergeA1778,axiom,
    p__d__subclass(c__Circle,c__Oval) ).

fof(mergeA1779,axiom,
    ! [C] :
      ( p__d__instance(C,c__Circle)
     => ? [R] :
          ( p__d__instance(R,c__LengthMeasure)
          & p__radius(C,R) ) ) ).

fof(mergeA1780,axiom,
    p__d__instance(c__CenterOfCircleFn,c__UnaryFunction) ).

fof(mergeA1781,axiom,
    p__d__instance(c__CenterOfCircleFn,c__TotalValuedRelation) ).

fof(mergeA1784,axiom,
    p__d__instance(c__radius,c__BinaryPredicate) ).

fof(mergeA1785,axiom,
    p__d__instance(c__radius,c__SingleValuedRelation) ).

fof(mergeA1786,axiom,
    p__d__instance(c__radius,c__TotalValuedRelation) ).

fof(mergeA1789,axiom,
    ! [CIRCLE,RADIUS] :
      ( ( p__d__instance(RADIUS,c__LengthMeasure)
        & p__d__instance(CIRCLE,c__Circle)
        & p__radius(CIRCLE,RADIUS) )
     => ? [POINT] :
          ( p__d__instance(POINT,c__GeometricPoint)
          & ! [PART] :
              ( ( p__d__instance(PART,c__GeometricPoint)
                & p__pointOfFigure(PART,CIRCLE) )
             => p__geometricDistance(PART,POINT,RADIUS) ) ) ) ).

fof(mergeA1790,axiom,
    p__subrelation(c__diameter,c__width) ).

fof(mergeA1791,axiom,
    p__d__instance(c__diameter,c__BinaryPredicate) ).

fof(mergeA1792,axiom,
    p__d__instance(c__diameter,c__SingleValuedRelation) ).

fof(mergeA1793,axiom,
    p__d__instance(c__diameter,c__TotalValuedRelation) ).

fof(mergeA1796,axiom,
    ! [CIRCLE,LENGTH] :
      ( ( p__d__instance(LENGTH,c__LengthMeasure)
        & p__d__instance(CIRCLE,c__Circle)
        & p__diameter(CIRCLE,LENGTH) )
     => ? [HALF] :
          ( p__d__instance(HALF,c__LengthMeasure)
          & p__radius(CIRCLE,HALF)
          & f__MultiplicationFn2(HALF,c__2) = LENGTH ) ) ).

fof(mergeA1797,axiom,
    p__d__instance(c__distance,c__SingleValuedRelation) ).

fof(mergeA1798,axiom,
    p__d__instance(c__distance,c__SpatialRelation) ).

fof(mergeA1799,axiom,
    p__d__instance(c__distance,c__TernaryPredicate) ).

fof(mergeA1803,axiom,
    ! [OBJ2,OBJ1,QUANT] :
      ( ( p__d__instance(QUANT,c__LengthMeasure)
        & p__d__instance(OBJ2,c__Physical)
        & p__d__instance(OBJ1,c__Physical)
        & p__distance(OBJ1,OBJ2,QUANT) )
     => p__distance(OBJ2,OBJ1,QUANT) ) ).

fof(mergeA1804,axiom,
    p__subrelation(c__altitude,c__distance) ).

fof(mergeA1805,axiom,
    p__d__instance(c__altitude,c__SingleValuedRelation) ).

fof(mergeA1806,axiom,
    ! [HEIGHT,OBJ1,OBJ2] :
      ( ( p__d__instance(HEIGHT,c__LengthMeasure)
        & p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__altitude(OBJ1,OBJ2,HEIGHT) )
     => p__orientation(OBJ1,OBJ2,c__Above) ) ).

fof(mergeA1807,axiom,
    ! [OBJ1,OBJ2,HEIGHT] :
      ( ( p__d__instance(HEIGHT,c__LengthMeasure)
        & p__d__instance(OBJ2,c__Physical)
        & p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__altitude(OBJ1,OBJ2,HEIGHT) )
     => ? [TOP] :
          ( p__d__instance(TOP,c__SelfConnectedObject)
          & p__top(TOP,OBJ1)
          & p__distance(TOP,OBJ2,HEIGHT) ) ) ).

fof(mergeA1808,axiom,
    p__subrelation(c__depth,c__distance) ).

fof(mergeA1809,axiom,
    p__d__instance(c__depth,c__SingleValuedRelation) ).

fof(mergeA1810,axiom,
    ! [DEPTH,OBJ1,OBJ2] :
      ( ( p__d__instance(DEPTH,c__LengthMeasure)
        & p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__depth(OBJ1,OBJ2,DEPTH) )
     => p__orientation(OBJ1,OBJ2,c__Below) ) ).

fof(mergeA1811,axiom,
    ! [OBJ1,OBJ2,DEPTH] :
      ( ( p__d__instance(DEPTH,c__LengthMeasure)
        & p__d__instance(OBJ2,c__Physical)
        & p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__depth(OBJ1,OBJ2,DEPTH) )
     => ? [BOTTOM] :
          ( p__d__instance(BOTTOM,c__SelfConnectedObject)
          & p__bottom(BOTTOM,OBJ1)
          & p__distance(BOTTOM,OBJ2,DEPTH) ) ) ).

fof(mergeA1812,axiom,
    p__d__instance(c__larger,c__BinaryPredicate) ).

fof(mergeA1813,axiom,
    p__d__instance(c__larger,c__SpatialRelation) ).

fof(mergeA1814,axiom,
    p__d__instance(c__larger,c__TransitiveRelation) ).

fof(mergeA1815,axiom,
    p__d__instance(c__larger,c__IrreflexiveRelation) ).

fof(mergeA1818,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__larger(OBJ1,OBJ2)
      <=> ! [QUANT1,QUANT2,UNIT] :
            ( ( p__d__instance(QUANT1,c__RealNumber)
              & p__d__instance(QUANT2,c__RealNumber)
              & p__measure(OBJ1,f__MeasureFn2(QUANT1,UNIT))
              & p__measure(OBJ2,f__MeasureFn2(QUANT2,UNIT))
              & p__d__instance(UNIT,c__UnitOfLength) )
           => p__greaterThan(QUANT1,QUANT2) ) ) ) ).

fof(mergeA1819,axiom,
    p__d__instance(c__smaller,c__BinaryPredicate) ).

fof(mergeA1820,axiom,
    p__d__instance(c__smaller,c__SpatialRelation) ).

fof(mergeA1821,axiom,
    p__d__instance(c__smaller,c__TransitiveRelation) ).

fof(mergeA1822,axiom,
    p__d__instance(c__smaller,c__IrreflexiveRelation) ).

fof(mergeA1825,axiom,
    p__inverse(c__smaller,c__larger) ).

fof(mergeA1826,axiom,
    p__d__instance(c__monetaryValue,c__SingleValuedRelation) ).

fof(mergeA1827,axiom,
    p__subrelation(c__monetaryValue,c__measure) ).

fof(mergeA1830,axiom,
    p__d__instance(c__WealthFn,c__UnaryFunction) ).

fof(mergeA1834,axiom,
    p__d__instance(c__barometricPressure,c__BinaryPredicate) ).

fof(mergeA1835,axiom,
    p__d__instance(c__barometricPressure,c__AsymmetricRelation) ).

fof(mergeA1836,axiom,
    p__subrelation(c__barometricPressure,c__measure) ).

fof(mergeA1839,axiom,
    p__d__subclass(c__UnitOfAtmosphericPressure,c__CompositeUnitOfMeasure) ).

fof(mergeA1840,axiom,
    p__d__instance(c__InchMercury,c__UnitOfAtmosphericPressure) ).

fof(mergeA1841,axiom,
    p__d__instance(c__MmMercury,c__UnitOfAtmosphericPressure) ).

fof(mergeA1842,axiom,
    p__d__instance(c__PositiveInfinity,c__TimePoint) ).

fof(mergeA1843,axiom,
    ! [POINT] :
      ( ( p__d__instance(POINT,c__TimePoint)
        & POINT != c__PositiveInfinity )
     => p__before(POINT,c__PositiveInfinity) ) ).

fof(mergeA1844,axiom,
    ! [POINT] :
      ( ( p__d__instance(POINT,c__TimePoint)
        & POINT != c__PositiveInfinity )
     => ? [OTHERPOINT] :
          ( p__d__instance(OTHERPOINT,c__TimePoint)
          & p__temporallyBetween(POINT,OTHERPOINT,c__PositiveInfinity) ) ) ).

fof(mergeA1845,axiom,
    p__d__instance(c__NegativeInfinity,c__TimePoint) ).

fof(mergeA1846,axiom,
    ! [POINT] :
      ( ( p__d__instance(POINT,c__TimePoint)
        & POINT != c__NegativeInfinity )
     => p__before(c__NegativeInfinity,POINT) ) ).

fof(mergeA1847,axiom,
    ! [POINT] :
      ( ( p__d__instance(POINT,c__TimePoint)
        & POINT != c__NegativeInfinity )
     => ? [OTHERPOINT] :
          ( p__d__instance(OTHERPOINT,c__TimePoint)
          & p__temporallyBetween(c__NegativeInfinity,OTHERPOINT,POINT) ) ) ).

fof(mergeA1848,axiom,
    p__d__instance(c__duration,c__BinaryPredicate) ).

fof(mergeA1849,axiom,
    p__d__instance(c__duration,c__AsymmetricRelation) ).

fof(mergeA1850,axiom,
    p__d__instance(c__duration,c__TotalValuedRelation) ).

fof(mergeA1853,axiom,
    p__d__instance(c__frequency,c__BinaryPredicate) ).

fof(mergeA1854,axiom,
    p__d__instance(c__frequency,c__AsymmetricRelation) ).

fof(mergeA1858,axiom,
    p__d__instance(c__temporalPart,c__BinaryPredicate) ).

fof(mergeA1859,axiom,
    p__d__instance(c__temporalPart,c__TemporalRelation) ).

fof(mergeA1860,axiom,
    p__d__instance(c__temporalPart,c__PartialOrderingRelation) ).

fof(mergeA1863,axiom,
    ! [POINT] :
      ( p__d__instance(POINT,c__TimePoint)
     => ? [INTERVAL] :
          ( p__d__instance(INTERVAL,c__TimeInterval)
          & p__temporalPart(POINT,INTERVAL) ) ) ).

fof(mergeA1864,axiom,
    ! [INTERVAL] :
      ( p__d__instance(INTERVAL,c__TimeInterval)
     => ? [POINT] :
          ( p__d__instance(POINT,c__TimePoint)
          & p__temporalPart(POINT,INTERVAL) ) ) ).

fof(mergeA1865,axiom,
    ! [TIME1,TIME2,SITUATION] :
      ( ( p__d__instance(SITUATION,c__Formula)
        & p__d__instance(TIME1,c__TimePosition)
        & p__d__instance(TIME2,c__TimePosition)
        & p__holdsDuring(TIME1,SITUATION)
        & p__temporalPart(TIME2,TIME1) )
     => p__holdsDuring(TIME2,SITUATION) ) ).

fof(mergeA1867,axiom,
    ! [THING,POS] :
      ( ( p__d__instance(THING,c__Physical)
        & p__d__instance(POS,c__TimePosition) )
     => ( p__temporalPart(POS,f__WhenFn1(THING))
      <=> p__time(THING,POS) ) ) ).

fof(mergeA1868,axiom,
    p__d__instance(c__BeginFn,c__TemporalRelation) ).

fof(mergeA1869,axiom,
    p__d__instance(c__BeginFn,c__UnaryFunction) ).

fof(mergeA1870,axiom,
    p__d__instance(c__BeginFn,c__TotalValuedRelation) ).

fof(mergeA1874,axiom,
    ! [INTERVAL,POINT,OTHERPOINT] :
      ( ( p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__instance(POINT,c__TimePoint)
        & f__BeginFn1(INTERVAL) = POINT
        & p__d__instance(OTHERPOINT,c__TimePoint)
        & p__temporalPart(OTHERPOINT,INTERVAL)
        & OTHERPOINT != POINT
        & OTHERPOINT != c__NegativeInfinity )
     => p__before(POINT,OTHERPOINT) ) ).

fof(mergeA1875,axiom,
    p__d__instance(c__EndFn,c__TemporalRelation) ).

fof(mergeA1876,axiom,
    p__d__instance(c__EndFn,c__UnaryFunction) ).

fof(mergeA1877,axiom,
    p__d__instance(c__EndFn,c__TotalValuedRelation) ).

fof(mergeA1880,axiom,
    ! [INTERVAL,POINT,OTHERPOINT] :
      ( ( p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__instance(POINT,c__TimePoint)
        & f__EndFn1(INTERVAL) = POINT
        & p__d__instance(OTHERPOINT,c__TimePoint)
        & p__temporalPart(OTHERPOINT,INTERVAL)
        & OTHERPOINT != POINT
        & OTHERPOINT != c__PositiveInfinity )
     => p__before(OTHERPOINT,POINT) ) ).

fof(mergeA1882,axiom,
    p__subrelation(c__starts,c__temporalPart) ).

fof(mergeA1883,axiom,
    p__d__instance(c__starts,c__TemporalRelation) ).

fof(mergeA1884,axiom,
    p__d__instance(c__starts,c__TransitiveRelation) ).

fof(mergeA1885,axiom,
    p__d__instance(c__starts,c__IrreflexiveRelation) ).

fof(mergeA1888,axiom,
    ! [INTERVAL1,INTERVAL2] :
      ( ( p__d__instance(INTERVAL2,c__TimeInterval)
        & p__d__instance(INTERVAL1,c__TimeInterval) )
     => ( p__starts(INTERVAL1,INTERVAL2)
      <=> ( f__BeginFn1(INTERVAL1) = f__BeginFn1(INTERVAL2)
          & p__before(f__EndFn1(INTERVAL1),f__EndFn1(INTERVAL2)) ) ) ) ).

fof(mergeA1889,axiom,
    p__subrelation(c__finishes,c__temporalPart) ).

fof(mergeA1890,axiom,
    p__d__instance(c__finishes,c__TemporalRelation) ).

fof(mergeA1891,axiom,
    p__d__instance(c__finishes,c__TransitiveRelation) ).

fof(mergeA1892,axiom,
    p__d__instance(c__finishes,c__IrreflexiveRelation) ).

fof(mergeA1895,axiom,
    ! [INTERVAL2,INTERVAL1] :
      ( ( p__d__instance(INTERVAL2,c__TimeInterval)
        & p__d__instance(INTERVAL1,c__TimeInterval) )
     => ( p__finishes(INTERVAL1,INTERVAL2)
      <=> ( p__before(f__BeginFn1(INTERVAL2),f__BeginFn1(INTERVAL1))
          & f__EndFn1(INTERVAL2) = f__EndFn1(INTERVAL1) ) ) ) ).

fof(mergeA1896,axiom,
    p__d__instance(c__before,c__TemporalRelation) ).

fof(mergeA1897,axiom,
    p__d__instance(c__before,c__IrreflexiveRelation) ).

fof(mergeA1898,axiom,
    p__d__instance(c__before,c__TransitiveRelation) ).

fof(mergeA1899,axiom,
    p__subrelation(c__before,c__beforeOrEqual) ).

fof(mergeA1900,axiom,
    p__relatedInternalConcept(c__before,c__earlier) ).

fof(mergeA1903,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Object)
     => ? [TIME1,TIME2] :
          ( p__d__instance(TIME1,c__TimePoint)
          & p__d__instance(TIME2,c__TimePoint)
          & p__before(TIME1,TIME2)
          & ! [TIME] :
              ( ( p__d__instance(TIME,c__TimePoint)
                & p__beforeOrEqual(TIME1,TIME)
                & p__beforeOrEqual(TIME,TIME2) )
             => p__time(OBJ,TIME) ) ) ) ).

fof(mergeA1904,axiom,
    ! [PROC,OBJ,TIME] :
      ( ( p__d__instance(OBJ,c__Physical)
        & p__d__instance(PROC,c__Process)
        & p__result(PROC,OBJ)
        & p__d__instance(TIME,c__TimePoint)
        & p__before(TIME,f__BeginFn1(f__WhenFn1(PROC))) )
     => ~ p__time(OBJ,TIME) ) ).

fof(mergeA1905,axiom,
    ! [INTERVAL] :
      ( ( p__d__instance(INTERVAL,c__TimeInterval)
        & f__BeginFn1(INTERVAL) != c__PositiveInfinity
        & f__EndFn1(INTERVAL) != c__NegativeInfinity )
     => p__before(f__BeginFn1(INTERVAL),f__EndFn1(INTERVAL)) ) ).

fof(mergeA1906,axiom,
    p__d__instance(c__beforeOrEqual,c__BinaryPredicate) ).

fof(mergeA1907,axiom,
    p__d__instance(c__beforeOrEqual,c__TemporalRelation) ).

fof(mergeA1908,axiom,
    p__d__instance(c__beforeOrEqual,c__PartialOrderingRelation) ).

fof(mergeA1911,axiom,
    ! [POINT1,POINT2] :
      ( ( p__d__instance(POINT2,c__TimePoint)
        & p__d__instance(POINT1,c__TimePoint)
        & p__beforeOrEqual(POINT1,POINT2) )
     => ( p__before(POINT1,POINT2)
        | POINT1 = POINT2 ) ) ).

fof(mergeA1912,axiom,
    p__d__instance(c__temporallyBetween,c__TemporalRelation) ).

fof(mergeA1913,axiom,
    p__d__instance(c__temporallyBetween,c__TernaryPredicate) ).

fof(mergeA1914,axiom,
    p__subrelation(c__temporallyBetween,c__temporallyBetweenOrEqual) ).

fof(mergeA1918,axiom,
    ! [POINT1,POINT2,POINT3] :
      ( ( p__d__instance(POINT3,c__TimePoint)
        & p__d__instance(POINT2,c__TimePoint)
        & p__d__instance(POINT1,c__TimePoint) )
     => ( p__temporallyBetween(POINT1,POINT2,POINT3)
      <=> ( p__before(POINT1,POINT2)
          & p__before(POINT2,POINT3) ) ) ) ).

fof(mergeA1919,axiom,
    p__d__instance(c__temporallyBetweenOrEqual,c__TemporalRelation) ).

fof(mergeA1920,axiom,
    p__d__instance(c__temporallyBetweenOrEqual,c__TernaryPredicate) ).

fof(mergeA1924,axiom,
    ! [POINT1,POINT2,POINT3] :
      ( ( p__d__instance(POINT3,c__TimePoint)
        & p__d__instance(POINT2,c__TimePoint)
        & p__d__instance(POINT1,c__TimePoint) )
     => ( p__temporallyBetweenOrEqual(POINT1,POINT2,POINT3)
      <=> ( p__beforeOrEqual(POINT1,POINT2)
          & p__beforeOrEqual(POINT2,POINT3) ) ) ) ).

fof(mergeA1925,axiom,
    ! [TIME,PHYS] :
      ( ( p__d__instance(TIME,c__TimePoint)
        & p__d__instance(PHYS,c__Physical) )
     => ( ( p__time(PHYS,TIME)
          & p__d__instance(TIME,c__TimePoint) )
      <=> p__temporallyBetweenOrEqual(f__BeginFn1(f__WhenFn1(PHYS)),TIME,f__EndFn1(f__WhenFn1(PHYS))) ) ) ).

fof(mergeA1926,axiom,
    p__d__instance(c__overlapsTemporally,c__BinaryPredicate) ).

fof(mergeA1927,axiom,
    p__d__instance(c__overlapsTemporally,c__TemporalRelation) ).

fof(mergeA1928,axiom,
    p__d__instance(c__overlapsTemporally,c__ReflexiveRelation) ).

fof(mergeA1929,axiom,
    p__d__instance(c__overlapsTemporally,c__SymmetricRelation) ).

fof(mergeA1932,axiom,
    ! [INTERVAL1,INTERVAL2] :
      ( ( p__d__instance(INTERVAL2,c__TimeInterval)
        & p__d__instance(INTERVAL1,c__TimeInterval) )
     => ( p__overlapsTemporally(INTERVAL1,INTERVAL2)
      <=> ? [INTERVAL3] :
            ( p__d__instance(INTERVAL3,c__TimeInterval)
            & p__temporalPart(INTERVAL3,INTERVAL1)
            & p__temporalPart(INTERVAL3,INTERVAL2) ) ) ) ).

fof(mergeA1933,axiom,
    ! [REL,OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Physical)
        & p__d__instance(OBJ1,c__Physical)
        & p__d__instance(REL,c__BinaryPredicate)
        & p__d__instance(REL,c__SpatialRelation)
        & p__d__holds3(REL,OBJ1,OBJ2) )
     => p__overlapsTemporally(f__WhenFn1(OBJ1),f__WhenFn1(OBJ2)) ) ).

fof(mergeA1934,axiom,
    p__subrelation(c__during,c__temporalPart) ).

fof(mergeA1935,axiom,
    p__d__instance(c__during,c__TransitiveRelation) ).

fof(mergeA1936,axiom,
    p__d__instance(c__during,c__IrreflexiveRelation) ).

fof(mergeA1937,axiom,
    p__subrelation(c__during,c__overlapsTemporally) ).

fof(mergeA1940,axiom,
    ! [INTERVAL2,INTERVAL1] :
      ( ( p__d__instance(INTERVAL2,c__TimeInterval)
        & p__d__instance(INTERVAL1,c__TimeInterval)
        & p__during(INTERVAL1,INTERVAL2) )
     => ( p__before(f__EndFn1(INTERVAL1),f__EndFn1(INTERVAL2))
        & p__before(f__BeginFn1(INTERVAL2),f__BeginFn1(INTERVAL1)) ) ) ).

fof(mergeA1941,axiom,
    p__d__instance(c__meetsTemporally,c__BinaryPredicate) ).

fof(mergeA1942,axiom,
    p__d__instance(c__meetsTemporally,c__TemporalRelation) ).

fof(mergeA1943,axiom,
    p__d__instance(c__meetsTemporally,c__AsymmetricRelation) ).

fof(mergeA1944,axiom,
    p__d__instance(c__meetsTemporally,c__IntransitiveRelation) ).

fof(mergeA1947,axiom,
    ! [INTERVAL1,INTERVAL2] :
      ( ( p__d__instance(INTERVAL2,c__TimeInterval)
        & p__d__instance(INTERVAL1,c__TimeInterval) )
     => ( p__meetsTemporally(INTERVAL1,INTERVAL2)
      <=> f__EndFn1(INTERVAL1) = f__BeginFn1(INTERVAL2) ) ) ).

fof(mergeA1948,axiom,
    ! [INTERVAL1,INTERVAL2] :
      ( ( p__d__instance(INTERVAL1,c__TimeInterval)
        & p__d__instance(INTERVAL2,c__TimeInterval)
        & f__BeginFn1(INTERVAL1) = f__BeginFn1(INTERVAL2)
        & f__EndFn1(INTERVAL1) = f__EndFn1(INTERVAL2) )
     => INTERVAL1 = INTERVAL2 ) ).

fof(mergeA1949,axiom,
    p__d__instance(c__earlier,c__BinaryPredicate) ).

fof(mergeA1950,axiom,
    p__d__instance(c__earlier,c__TemporalRelation) ).

fof(mergeA1951,axiom,
    p__d__instance(c__earlier,c__TransitiveRelation) ).

fof(mergeA1952,axiom,
    p__d__instance(c__earlier,c__IrreflexiveRelation) ).

fof(mergeA1955,axiom,
    ! [INTERVAL1,INTERVAL2] :
      ( ( p__d__instance(INTERVAL2,c__TimeInterval)
        & p__d__instance(INTERVAL1,c__TimeInterval) )
     => ( p__earlier(INTERVAL1,INTERVAL2)
      <=> p__before(f__EndFn1(INTERVAL1),f__BeginFn1(INTERVAL2)) ) ) ).

fof(mergeA1956,axiom,
    p__d__instance(c__cooccur,c__BinaryPredicate) ).

fof(mergeA1957,axiom,
    p__d__instance(c__cooccur,c__TemporalRelation) ).

fof(mergeA1958,axiom,
    p__d__instance(c__cooccur,c__EquivalenceRelation) ).

fof(mergeA1961,axiom,
    ! [PHYS1,PHYS2] :
      ( ( p__d__instance(PHYS2,c__Physical)
        & p__d__instance(PHYS1,c__Physical) )
     => ( p__cooccur(PHYS1,PHYS2)
      <=> f__WhenFn1(PHYS1) = f__WhenFn1(PHYS2) ) ) ).

fof(mergeA1962,axiom,
    p__d__instance(c__TimeIntervalFn,c__BinaryFunction) ).

fof(mergeA1963,axiom,
    p__d__instance(c__TimeIntervalFn,c__TemporalRelation) ).

fof(mergeA1967,axiom,
    ! [POINT1,INTERVAL,POINT2] :
      ( ( p__d__instance(POINT1,c__TimePoint)
        & p__d__instance(POINT2,c__TimePoint)
        & POINT1 != c__NegativeInfinity
        & POINT2 != c__PositiveInfinity
        & p__d__instance(INTERVAL,c__TimeInterval)
        & f__TimeIntervalFn2(POINT1,POINT2) = INTERVAL )
     => ( f__BeginFn1(INTERVAL) = POINT1
        & f__EndFn1(INTERVAL) = POINT2 ) ) ).

fof(mergeA1968,axiom,
    ! [POINT1,POINT2,INTERVAL,POINT] :
      ( ( p__d__instance(POINT1,c__TimePoint)
        & p__d__instance(POINT2,c__TimePoint)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & f__TimeIntervalFn2(POINT1,POINT2) = INTERVAL
        & p__d__instance(POINT,c__TimePoint) )
     => ( p__temporallyBetweenOrEqual(POINT1,POINT,POINT2)
      <=> p__temporalPart(POINT,INTERVAL) ) ) ).

fof(mergeA1969,axiom,
    p__d__instance(c__RecurrentTimeIntervalFn,c__TemporalRelation) ).

fof(mergeA1970,axiom,
    p__d__instance(c__RecurrentTimeIntervalFn,c__BinaryFunction) ).

fof(mergeA1975,axiom,
    p__d__instance(c__WhenFn,c__TemporalRelation) ).

fof(mergeA1976,axiom,
    p__d__instance(c__WhenFn,c__UnaryFunction) ).

fof(mergeA1977,axiom,
    p__d__instance(c__WhenFn,c__TotalValuedRelation) ).

fof(mergeA1980,axiom,
    p__d__instance(c__PastFn,c__TemporalRelation) ).

fof(mergeA1981,axiom,
    p__d__instance(c__PastFn,c__UnaryFunction) ).

fof(mergeA1982,axiom,
    p__d__instance(c__PastFn,c__TotalValuedRelation) ).

fof(mergeA1985,axiom,
    ! [INTERVAL] :
      ( ( p__d__instance(INTERVAL,c__TimeInterval)
        & f__BeginFn1(INTERVAL) != c__NegativeInfinity )
     => p__meetsTemporally(f__PastFn1(INTERVAL),INTERVAL) ) ).

fof(mergeA1986,axiom,
    ! [INTERVAL] :
      ( p__d__instance(INTERVAL,c__TimeInterval)
     => f__PastFn1(INTERVAL) = f__TimeIntervalFn2(c__NegativeInfinity,f__BeginFn1(INTERVAL)) ) ).

fof(mergeA1987,axiom,
    p__d__instance(c__ImmediatePastFn,c__TemporalRelation) ).

fof(mergeA1988,axiom,
    p__d__instance(c__ImmediatePastFn,c__UnaryFunction) ).

fof(mergeA1989,axiom,
    p__d__instance(c__ImmediatePastFn,c__TotalValuedRelation) ).

fof(mergeA1992,axiom,
    ! [INTERVAL] :
      ( p__d__instance(INTERVAL,c__TimeInterval)
     => p__finishes(f__ImmediatePastFn1(INTERVAL),f__PastFn1(INTERVAL)) ) ).

fof(mergeA1993,axiom,
    p__d__instance(c__FutureFn,c__TemporalRelation) ).

fof(mergeA1994,axiom,
    p__d__instance(c__FutureFn,c__UnaryFunction) ).

fof(mergeA1995,axiom,
    p__d__instance(c__FutureFn,c__TotalValuedRelation) ).

fof(mergeA1998,axiom,
    ! [INTERVAL] :
      ( ( p__d__instance(INTERVAL,c__TimeInterval)
        & f__EndFn1(INTERVAL) != c__PositiveInfinity )
     => p__meetsTemporally(INTERVAL,f__FutureFn1(INTERVAL)) ) ).

fof(mergeA1999,axiom,
    ! [INTERVAL] :
      ( p__d__instance(INTERVAL,c__TimeInterval)
     => f__FutureFn1(INTERVAL) = f__TimeIntervalFn2(f__EndFn1(INTERVAL),c__PositiveInfinity) ) ).

fof(mergeA2000,axiom,
    p__d__instance(c__ImmediateFutureFn,c__TemporalRelation) ).

fof(mergeA2001,axiom,
    p__d__instance(c__ImmediateFutureFn,c__UnaryFunction) ).

fof(mergeA2002,axiom,
    p__d__instance(c__ImmediateFutureFn,c__TotalValuedRelation) ).

fof(mergeA2005,axiom,
    ! [INTERVAL] :
      ( p__d__instance(INTERVAL,c__TimeInterval)
     => p__starts(f__ImmediateFutureFn1(INTERVAL),f__FutureFn1(INTERVAL)) ) ).

fof(mergeA2006,axiom,
    p__d__instance(c__date,c__BinaryPredicate) ).

fof(mergeA2007,axiom,
    p__d__instance(c__date,c__SingleValuedRelation) ).

fof(mergeA2008,axiom,
    p__d__instance(c__date,c__AsymmetricRelation) ).

fof(mergeA2011,axiom,
    p__subrelation(c__date,c__time) ).

fof(mergeA2012,axiom,
    p__d__instance(c__YearFn,c__TemporalRelation) ).

fof(mergeA2013,axiom,
    p__d__instance(c__YearFn,c__UnaryFunction) ).

fof(mergeA2016,axiom,
    p__d__instance(c__MonthFn,c__TemporalRelation) ).

fof(mergeA2017,axiom,
    p__d__instance(c__MonthFn,c__BinaryFunction) ).

fof(mergeA2021,axiom,
    p__d__instance(c__DayFn,c__TemporalRelation) ).

fof(mergeA2022,axiom,
    p__d__instance(c__DayFn,c__BinaryFunction) ).

fof(mergeA2028,axiom,
    p__d__instance(c__HourFn,c__TemporalRelation) ).

fof(mergeA2029,axiom,
    p__d__instance(c__HourFn,c__BinaryFunction) ).

fof(mergeA2035,axiom,
    p__d__instance(c__MinuteFn,c__TemporalRelation) ).

fof(mergeA2036,axiom,
    p__d__instance(c__MinuteFn,c__BinaryFunction) ).

fof(mergeA2042,axiom,
    p__d__instance(c__SecondFn,c__TemporalRelation) ).

fof(mergeA2043,axiom,
    p__d__instance(c__SecondFn,c__BinaryFunction) ).

fof(mergeA2049,axiom,
    p__d__subclass(c__Year,c__TimeInterval) ).

fof(mergeA2053,axiom,
    ! [YEAR1,YEAR2] :
      ( ( p__d__instance(YEAR1,c__Year)
        & p__d__instance(YEAR2,c__Year)
        & f__SubtractionFn2(YEAR2,YEAR1) = c__1 )
     => p__meetsTemporally(YEAR1,YEAR2) ) ).

fof(mergeA2054,axiom,
    p__d__subclass(c__LeapYear,c__Year) ).

fof(mergeA2056,axiom,
    p__d__subclass(c__Month,c__TimeInterval) ).

fof(mergeA2058,axiom,
    p__d__subclass(c__January,c__Month) ).

fof(mergeA2061,axiom,
    p__d__subclass(c__February,c__Month) ).

fof(mergeA2065,axiom,
    p__d__subclass(c__March,c__Month) ).

fof(mergeA2068,axiom,
    p__d__subclass(c__April,c__Month) ).

fof(mergeA2071,axiom,
    p__d__subclass(c__May,c__Month) ).

fof(mergeA2074,axiom,
    p__d__subclass(c__June,c__Month) ).

fof(mergeA2077,axiom,
    p__d__subclass(c__July,c__Month) ).

fof(mergeA2080,axiom,
    p__d__subclass(c__August,c__Month) ).

fof(mergeA2083,axiom,
    p__d__subclass(c__September,c__Month) ).

fof(mergeA2086,axiom,
    p__d__subclass(c__October,c__Month) ).

fof(mergeA2089,axiom,
    p__d__subclass(c__November,c__Month) ).

fof(mergeA2092,axiom,
    p__d__subclass(c__December,c__Month) ).

fof(mergeA2095,axiom,
    p__d__subclass(c__Day,c__TimeInterval) ).

fof(mergeA2099,axiom,
    p__d__subclass(c__Monday,c__Day) ).

fof(mergeA2100,axiom,
    p__d__subclass(c__Tuesday,c__Day) ).

fof(mergeA2101,axiom,
    ! [WEEK,DAY1,DAY2] :
      ( ( p__d__instance(DAY1,c__Monday)
        & p__d__instance(DAY2,c__Tuesday)
        & p__d__instance(WEEK,c__Week)
        & p__temporalPart(DAY1,WEEK)
        & p__temporalPart(DAY2,WEEK) )
     => p__meetsTemporally(DAY1,DAY2) ) ).

fof(mergeA2102,axiom,
    p__d__subclass(c__Wednesday,c__Day) ).

fof(mergeA2103,axiom,
    ! [WEEK,DAY1,DAY2] :
      ( ( p__d__instance(DAY1,c__Tuesday)
        & p__d__instance(DAY2,c__Wednesday)
        & p__d__instance(WEEK,c__Week)
        & p__temporalPart(DAY1,WEEK)
        & p__temporalPart(DAY2,WEEK) )
     => p__meetsTemporally(DAY1,DAY2) ) ).

fof(mergeA2104,axiom,
    p__d__subclass(c__Thursday,c__Day) ).

fof(mergeA2105,axiom,
    ! [WEEK,DAY1,DAY2] :
      ( ( p__d__instance(DAY1,c__Wednesday)
        & p__d__instance(DAY2,c__Thursday)
        & p__d__instance(WEEK,c__Week)
        & p__temporalPart(DAY1,WEEK)
        & p__temporalPart(DAY2,WEEK) )
     => p__meetsTemporally(DAY1,DAY2) ) ).

fof(mergeA2106,axiom,
    p__d__subclass(c__Friday,c__Day) ).

fof(mergeA2107,axiom,
    ! [WEEK,DAY1,DAY2] :
      ( ( p__d__instance(DAY1,c__Thursday)
        & p__d__instance(DAY2,c__Friday)
        & p__d__instance(WEEK,c__Week)
        & p__temporalPart(DAY1,WEEK)
        & p__temporalPart(DAY2,WEEK) )
     => p__meetsTemporally(DAY1,DAY2) ) ).

fof(mergeA2108,axiom,
    p__d__subclass(c__Saturday,c__Day) ).

fof(mergeA2109,axiom,
    ! [WEEK,DAY1,DAY2] :
      ( ( p__d__instance(DAY1,c__Friday)
        & p__d__instance(DAY2,c__Saturday)
        & p__d__instance(WEEK,c__Week)
        & p__temporalPart(DAY1,WEEK)
        & p__temporalPart(DAY2,WEEK) )
     => p__meetsTemporally(DAY1,DAY2) ) ).

fof(mergeA2110,axiom,
    p__d__subclass(c__Sunday,c__Day) ).

fof(mergeA2111,axiom,
    ! [WEEK,DAY1,DAY2] :
      ( ( p__d__instance(DAY1,c__Saturday)
        & p__d__instance(DAY2,c__Sunday)
        & p__d__instance(WEEK,c__Week)
        & p__temporalPart(DAY1,WEEK)
        & p__temporalPart(DAY2,WEEK) )
     => p__meetsTemporally(DAY1,DAY2) ) ).

fof(mergeA2112,axiom,
    ! [WEEK1,WEEK2,DAY1,DAY2] :
      ( ( p__d__instance(DAY1,c__Sunday)
        & p__d__instance(DAY2,c__Monday)
        & p__d__instance(WEEK1,c__Week)
        & p__d__instance(WEEK2,c__Week)
        & p__temporalPart(DAY1,WEEK1)
        & p__temporalPart(DAY2,WEEK2)
        & p__meetsTemporally(WEEK1,WEEK2) )
     => p__meetsTemporally(DAY1,DAY2) ) ).

fof(mergeA2113,axiom,
    p__d__subclass(c__Week,c__TimeInterval) ).

fof(mergeA2115,axiom,
    p__d__subclass(c__Hour,c__TimeInterval) ).

fof(mergeA2119,axiom,
    p__d__subclass(c__Minute,c__TimeInterval) ).

fof(mergeA2123,axiom,
    p__d__subclass(c__Second,c__TimeInterval) ).

fof(mergeA2127,axiom,
    p__d__instance(c__TemporalCompositionFn,c__TemporalRelation) ).

fof(mergeA2128,axiom,
    p__d__instance(c__TemporalCompositionFn,c__BinaryFunction) ).

fof(mergeA2132,axiom,
    ! [INTERVAL,INTERVALTYPE,CLASS,TIME1,TIME2] :
      ( ( p__d__subclass(INTERVALTYPE,c__TimeInterval)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__subclass(CLASS,c__TimeInterval)
        & f__TemporalCompositionFn2(INTERVAL,INTERVALTYPE) = CLASS
        & p__d__instance(TIME1,c__TimeInterval)
        & p__d__instance(TIME2,c__TimeInterval)
        & p__d__instance(TIME1,INTERVALTYPE)
        & p__d__instance(TIME2,CLASS) )
     => ? [DURATION] :
          ( p__d__instance(DURATION,c__TimeDuration)
          & p__duration(TIME1,DURATION)
          & p__duration(TIME2,DURATION) ) ) ).

fof(mergeA2133,axiom,
    ! [INTERVAL,INTERVALTYPE,CLASS,TIME1,TIME2] :
      ( ( p__d__subclass(INTERVALTYPE,c__TimeInterval)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__subclass(CLASS,c__TimeInterval)
        & f__TemporalCompositionFn2(INTERVAL,INTERVALTYPE) = CLASS
        & p__d__instance(TIME1,c__TimeInterval)
        & p__d__instance(TIME2,c__TimeInterval)
        & p__d__instance(TIME1,CLASS)
        & p__d__instance(TIME2,CLASS)
        & TIME1 != TIME2 )
     => ( p__meetsTemporally(TIME1,TIME2)
        | p__meetsTemporally(TIME2,TIME1)
        | p__earlier(TIME1,TIME2)
        | p__earlier(TIME2,TIME1) ) ) ).

fof(mergeA2134,axiom,
    ! [INTERVALTYPE,CLASS,INTERVAL] :
      ( ( p__d__subclass(INTERVALTYPE,c__TimeInterval)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__subclass(CLASS,c__TimeInterval)
        & f__TemporalCompositionFn2(INTERVAL,INTERVALTYPE) = CLASS )
     => ? [TIME] :
          ( p__d__instance(TIME,c__TimeInterval)
          & p__d__instance(TIME,CLASS)
          & p__starts(TIME,INTERVAL) ) ) ).

fof(mergeA2135,axiom,
    ! [INTERVALTYPE,CLASS,INTERVAL] :
      ( ( p__d__subclass(INTERVALTYPE,c__TimeInterval)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__subclass(CLASS,c__TimeInterval)
        & f__TemporalCompositionFn2(INTERVAL,INTERVALTYPE) = CLASS )
     => ? [TIME] :
          ( p__d__instance(TIME,c__TimeInterval)
          & p__d__instance(TIME,CLASS)
          & p__finishes(TIME,INTERVAL) ) ) ).

fof(mergeA2136,axiom,
    ! [INTERVALTYPE,INTERVAL,CLASS,TIME1] :
      ( ( p__d__subclass(INTERVALTYPE,c__TimeInterval)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__subclass(CLASS,c__TimeInterval)
        & f__TemporalCompositionFn2(INTERVAL,INTERVALTYPE) = CLASS
        & p__d__instance(TIME1,c__TimeInterval)
        & p__d__instance(TIME1,CLASS)
        & ~ p__finishes(TIME1,INTERVAL) )
     => ? [TIME2] :
          ( p__d__instance(TIME2,c__TimeInterval)
          & p__d__instance(TIME2,CLASS)
          & p__meetsTemporally(TIME1,TIME2) ) ) ).

fof(mergeA2137,axiom,
    ! [INTERVALTYPE,INTERVAL,CLASS,TIME1] :
      ( ( p__d__subclass(INTERVALTYPE,c__TimeInterval)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__subclass(CLASS,c__TimeInterval)
        & f__TemporalCompositionFn2(INTERVAL,INTERVALTYPE) = CLASS
        & p__d__instance(TIME1,c__TimeInterval)
        & p__d__instance(TIME1,CLASS)
        & ~ p__starts(TIME1,INTERVAL) )
     => ? [TIME2] :
          ( p__d__instance(TIME2,c__TimeInterval)
          & p__d__instance(TIME2,CLASS)
          & p__meetsTemporally(TIME2,TIME1) ) ) ).

fof(mergeA2138,axiom,
    ! [INTERVALTYPE,INTERVAL,CLASS,TIME] :
      ( ( p__d__subclass(INTERVALTYPE,c__TimeInterval)
        & p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__subclass(CLASS,c__TimeInterval)
        & f__TemporalCompositionFn2(INTERVAL,INTERVALTYPE) = CLASS
        & p__d__instance(TIME,c__TimePoint)
        & p__temporalPart(TIME,INTERVAL) )
     => ? [INSTANCE] :
          ( p__d__instance(INSTANCE,c__TimePosition)
          & p__d__instance(INSTANCE,CLASS)
          & p__temporalPart(TIME,INSTANCE) ) ) ).

fof(mergeA2139,axiom,
    ! [YEAR] :
      ( p__d__instance(YEAR,c__Year)
     => f__CardinalityFn1(f__TemporalCompositionFn2(YEAR,c__Month)) = c__12 ) ).

fof(mergeA2141,axiom,
    ! [WEEK] :
      ( p__d__instance(WEEK,c__Week)
     => f__CardinalityFn1(f__TemporalCompositionFn2(WEEK,c__Day)) = c__7 ) ).

fof(mergeA2142,axiom,
    ! [DAY] :
      ( p__d__instance(DAY,c__Day)
     => f__CardinalityFn1(f__TemporalCompositionFn2(DAY,c__Hour)) = c__24 ) ).

fof(mergeA2143,axiom,
    ! [HOUR] :
      ( p__d__instance(HOUR,c__Hour)
     => f__CardinalityFn1(f__TemporalCompositionFn2(HOUR,c__Minute)) = c__60 ) ).

fof(mergeA2144,axiom,
    ! [MINUTE] :
      ( p__d__instance(MINUTE,c__Minute)
     => f__CardinalityFn1(f__TemporalCompositionFn2(MINUTE,c__Second)) = c__60 ) ).

fof(mergeA2145,axiom,
    p__d__instance(c__connected,c__BinaryPredicate) ).

fof(mergeA2146,axiom,
    p__d__instance(c__connected,c__SpatialRelation) ).

fof(mergeA2147,axiom,
    p__d__instance(c__connected,c__ReflexiveRelation) ).

fof(mergeA2148,axiom,
    p__d__instance(c__connected,c__SymmetricRelation) ).

fof(mergeA2151,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__connected(OBJ1,OBJ2) )
     => ( p__meetsSpatially(OBJ1,OBJ2)
        | p__overlapsSpatially(OBJ1,OBJ2) ) ) ).

fof(mergeA2152,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Object)
     => ( p__d__instance(OBJ,c__SelfConnectedObject)
      <=> ! [PART1,PART2] :
            ( ( p__d__instance(PART2,c__Object)
              & p__d__instance(PART1,c__Object)
              & OBJ = f__MereologicalSumFn2(PART1,PART2) )
           => p__connected(PART1,PART2) ) ) ) ).

fof(mergeA2153,axiom,
    p__d__instance(c__connects,c__SpatialRelation) ).

fof(mergeA2154,axiom,
    p__d__instance(c__connects,c__TernaryPredicate) ).

fof(mergeA2158,axiom,
    ! [OBJ2,OBJ1,OBJ3] :
      ( ( p__d__instance(OBJ3,c__SelfConnectedObject)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__d__instance(OBJ1,c__SelfConnectedObject) )
     => ( p__connects(OBJ1,OBJ2,OBJ3)
      <=> p__between(OBJ2,OBJ1,OBJ3) ) ) ).

fof(mergeA2159,axiom,
    ! [OBJ1,OBJ2,OBJ3] :
      ( ( p__d__instance(OBJ3,c__SelfConnectedObject)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__d__instance(OBJ1,c__SelfConnectedObject) )
     => ( p__connects(OBJ1,OBJ2,OBJ3)
      <=> ( p__connected(OBJ1,OBJ2)
          & p__connected(OBJ1,OBJ3)
          & ~ p__connected(OBJ2,OBJ3) ) ) ) ).

fof(mergeA2160,axiom,
    ! [ARC,NODE2,NODE1] :
      ( ( p__d__instance(NODE2,c__SelfConnectedObject)
        & p__d__instance(NODE1,c__SelfConnectedObject)
        & p__d__instance(ARC,c__SelfConnectedObject)
        & p__connects(ARC,NODE1,NODE2) )
     => p__connects(ARC,NODE2,NODE1) ) ).

fof(mergeA2161,axiom,
    p__subrelation(c__meetsSpatially,c__connected) ).

fof(mergeA2162,axiom,
    p__d__instance(c__meetsSpatially,c__IrreflexiveRelation) ).

fof(mergeA2163,axiom,
    p__d__instance(c__meetsSpatially,c__SymmetricRelation) ).

fof(mergeA2164,axiom,
    p__disjointRelation(c__meetsSpatially,c__overlapsSpatially) ).

fof(mergeA2165,axiom,
    p__subrelation(c__overlapsSpatially,c__connected) ).

fof(mergeA2166,axiom,
    p__d__instance(c__overlapsSpatially,c__ReflexiveRelation) ).

fof(mergeA2167,axiom,
    p__d__instance(c__overlapsSpatially,c__SymmetricRelation) ).

fof(mergeA2168,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__overlapsSpatially(OBJ1,OBJ2)
      <=> ? [OBJ3] :
            ( p__d__instance(OBJ3,c__Object)
            & p__part(OBJ3,OBJ1)
            & p__part(OBJ3,OBJ2) ) ) ) ).

fof(mergeA2169,axiom,
    ! [COLL,OBJ1,OBJ2] :
      ( ( p__d__instance(COLL,c__Collection)
        & p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__member(OBJ1,COLL)
        & p__member(OBJ2,COLL)
        & OBJ1 != OBJ2 )
     => ~ p__overlapsSpatially(OBJ1,OBJ2) ) ).

fof(mergeA2170,axiom,
    ! [REL,PROCESS,OBJ] :
      ( ( p__d__instance(PROCESS,c__Physical)
        & p__d__instance(REL,c__CaseRole)
        & p__d__instance(OBJ,c__Object)
        & p__d__holds3(REL,PROCESS,OBJ) )
     => ? [TIME] :
          ( p__d__instance(TIME,c__TimePoint)
          & p__overlapsSpatially(f__WhereFn2(PROCESS,TIME),OBJ) ) ) ).

fof(mergeA2171,axiom,
    p__d__instance(c__overlapsPartially,c__SymmetricRelation) ).

fof(mergeA2172,axiom,
    p__d__instance(c__overlapsPartially,c__IrreflexiveRelation) ).

fof(mergeA2173,axiom,
    p__subrelation(c__overlapsPartially,c__overlapsSpatially) ).

fof(mergeA2174,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__overlapsPartially(OBJ1,OBJ2)
      <=> ( ~ p__part(OBJ1,OBJ2)
          & ~ p__part(OBJ2,OBJ1)
          & ? [OBJ3] :
              ( p__d__instance(OBJ3,c__Object)
              & p__part(OBJ3,OBJ1)
              & p__part(OBJ3,OBJ2) ) ) ) ) ).

fof(mergeA2175,axiom,
    p__subrelation(c__superficialPart,c__part) ).

fof(mergeA2176,axiom,
    p__d__instance(c__superficialPart,c__IrreflexiveRelation) ).

fof(mergeA2177,axiom,
    p__d__instance(c__superficialPart,c__TransitiveRelation) ).

fof(mergeA2178,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__superficialPart(OBJ1,OBJ2) )
     => ( ~ p__interiorPart(OBJ1,OBJ2)
        & ! [OBJ3] :
            ( ~ p__d__instance(OBJ3,c__Object)
            | ~ p__interiorPart(OBJ3,OBJ1) ) ) ) ).

fof(mergeA2179,axiom,
    p__d__instance(c__surface,c__AsymmetricRelation) ).

fof(mergeA2180,axiom,
    p__subrelation(c__surface,c__superficialPart) ).

fof(mergeA2183,axiom,
    ! [OBJ2,OBJ1,OBJ3] :
      ( ( p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__d__instance(OBJ3,c__Object)
        & p__surface(OBJ1,OBJ2)
        & p__superficialPart(OBJ3,OBJ2) )
     => p__part(OBJ3,OBJ1) ) ).

fof(mergeA2184,axiom,
    p__subrelation(c__interiorPart,c__part) ).

fof(mergeA2185,axiom,
    p__d__instance(c__interiorPart,c__AsymmetricRelation) ).

fof(mergeA2186,axiom,
    p__d__instance(c__interiorPart,c__TransitiveRelation) ).

fof(mergeA2187,axiom,
    ! [OBJ2,OBJ1,PART] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(PART,c__Object)
        & p__interiorPart(OBJ1,OBJ2)
        & p__superficialPart(PART,OBJ2) )
     => ~ p__overlapsSpatially(OBJ1,PART) ) ).

fof(mergeA2188,axiom,
    p__subrelation(c__bottom,c__superficialPart) ).

fof(mergeA2191,axiom,
    ! [OBJECT,PART,BOTTOM] :
      ( ( p__d__instance(OBJECT,c__SelfConnectedObject)
        & p__d__instance(BOTTOM,c__SelfConnectedObject)
        & p__d__instance(PART,c__Object)
        & p__bottom(BOTTOM,OBJECT)
        & p__part(PART,OBJECT)
        & ~ p__connected(PART,BOTTOM) )
     => p__orientation(PART,BOTTOM,c__Above) ) ).

fof(mergeA2192,axiom,
    p__subrelation(c__top,c__superficialPart) ).

fof(mergeA2195,axiom,
    ! [OBJECT,PART,TOP] :
      ( ( p__d__instance(OBJECT,c__SelfConnectedObject)
        & p__d__instance(TOP,c__SelfConnectedObject)
        & p__d__instance(PART,c__Object)
        & p__top(TOP,OBJECT)
        & p__part(PART,OBJECT)
        & ~ p__connected(PART,TOP) )
     => p__orientation(PART,TOP,c__Below) ) ).

fof(mergeA2196,axiom,
    p__subrelation(c__side,c__superficialPart) ).

fof(mergeA2199,axiom,
    ! [OBJECT,SIDE,PART] :
      ( ( p__d__instance(OBJECT,c__SelfConnectedObject)
        & p__d__instance(SIDE,c__SelfConnectedObject)
        & p__d__instance(PART,c__Object)
        & p__side(SIDE,OBJECT)
        & p__part(PART,OBJECT)
        & ~ p__connected(PART,SIDE) )
     => ? [DIRECT] :
          ( p__d__instance(DIRECT,c__PositionalAttribute)
          & p__orientation(SIDE,PART,DIRECT) ) ) ).

fof(mergeA2200,axiom,
    ! [O,TOP,S] :
      ( ( p__d__instance(O,c__SelfConnectedObject)
        & p__d__instance(TOP,c__SelfConnectedObject)
        & p__d__instance(S,c__SelfConnectedObject)
        & p__top(TOP,O)
        & p__side(S,O) )
     => TOP != S ) ).

fof(mergeA2201,axiom,
    ! [OBJECT,WIDTH] :
      ( ( p__d__instance(WIDTH,c__LengthMeasure)
        & p__d__instance(OBJECT,c__SelfConnectedObject) )
     => ( p__width(OBJECT,WIDTH)
      <=> ? [SIDE1,SIDE2] :
            ( p__d__instance(SIDE1,c__SelfConnectedObject)
            & p__d__instance(SIDE2,c__SelfConnectedObject)
            & p__side(SIDE1,OBJECT)
            & p__side(SIDE2,OBJECT)
            & p__distance(SIDE1,SIDE2,WIDTH) ) ) ) ).

fof(mergeA2202,axiom,
    ! [OBJECT,TOP,BOTTOM,HEIGHT] :
      ( ( p__d__instance(HEIGHT,c__LengthMeasure)
        & p__d__instance(OBJECT,c__SelfConnectedObject)
        & p__d__instance(TOP,c__SelfConnectedObject)
        & p__d__instance(BOTTOM,c__SelfConnectedObject)
        & p__height(OBJECT,HEIGHT)
        & p__top(TOP,OBJECT)
        & p__bottom(BOTTOM,OBJECT) )
     => p__distance(TOP,BOTTOM,HEIGHT) ) ).

fof(mergeA2203,axiom,
    p__d__instance(c__MereologicalSumFn,c__SpatialRelation) ).

fof(mergeA2204,axiom,
    p__d__instance(c__MereologicalSumFn,c__BinaryFunction) ).

fof(mergeA2205,axiom,
    p__d__instance(c__MereologicalSumFn,c__TotalValuedRelation) ).

fof(mergeA2209,axiom,
    p__relatedInternalConcept(c__MereologicalSumFn,c__MereologicalProductFn) ).

fof(mergeA2210,axiom,
    p__relatedInternalConcept(c__MereologicalSumFn,c__MereologicalDifferenceFn) ).

fof(mergeA2211,axiom,
    ! [C1,C2,P,O1,O2,S,CP,PART] :
      ( ( p__d__instance(O1,c__Object)
        & p__d__instance(C1,c__Object)
        & p__d__instance(O2,c__Object)
        & p__d__instance(C2,c__Object)
        & p__d__instance(P,c__Object)
        & p__d__instance(CP,c__Object)
        & p__d__instance(S,c__Object)
        & C1 = f__MereologicalComplementFn1(O1)
        & C2 = f__MereologicalComplementFn1(O2)
        & P = f__MereologicalProductFn2(C1,C2)
        & CP = f__MereologicalComplementFn1(P)
        & S = f__MereologicalSumFn2(O1,O2)
        & p__d__instance(PART,c__Object) )
     => ( p__part(PART,S)
      <=> p__part(PART,CP) ) ) ).

fof(mergeA2212,axiom,
    ! [OBJ3,OBJ1,OBJ2,PART] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ3,c__Object)
        & OBJ3 = f__MereologicalSumFn2(OBJ1,OBJ2)
        & p__d__instance(PART,c__Object) )
     => ( p__overlapsSpatially(PART,OBJ3)
      <=> ( p__overlapsSpatially(PART,OBJ1)
          | p__overlapsSpatially(PART,OBJ2) ) ) ) ).

fof(mergeA2213,axiom,
    ! [OBJ1,OBJ2,OBJ3,PART] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ3,c__Object)
        & OBJ3 = f__MereologicalSumFn2(OBJ1,OBJ2)
        & p__d__instance(PART,c__Object)
        & ( p__part(PART,OBJ1)
          | p__part(PART,OBJ2) ) )
     => p__part(PART,OBJ3) ) ).

fof(mergeA2214,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => f__MereologicalSumFn2(OBJ1,OBJ2) = f__MereologicalSumFn2(OBJ2,OBJ1) ) ).

fof(mergeA2215,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => f__MereologicalSumFn2(OBJ1,OBJ2) = f__MereologicalSumFn2(f__MereologicalSumFn2(OBJ1,OBJ2),OBJ2) ) ).

fof(mergeA2216,axiom,
    p__d__instance(c__MereologicalProductFn,c__SpatialRelation) ).

fof(mergeA2217,axiom,
    p__d__instance(c__MereologicalProductFn,c__BinaryFunction) ).

fof(mergeA2218,axiom,
    p__d__instance(c__MereologicalProductFn,c__TotalValuedRelation) ).

fof(mergeA2222,axiom,
    p__relatedInternalConcept(c__MereologicalProductFn,c__MereologicalDifferenceFn) ).

fof(mergeA2223,axiom,
    ! [OBJ3,OBJ1,OBJ2,PART] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ3,c__Object)
        & OBJ3 = f__MereologicalProductFn2(OBJ1,OBJ2)
        & p__d__instance(PART,c__Object) )
     => ( p__part(PART,OBJ3)
      <=> ( p__part(PART,OBJ1)
          & p__part(PART,OBJ2) ) ) ) ).

fof(mergeA2224,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => f__MereologicalProductFn2(OBJ1,OBJ2) = f__MereologicalProductFn2(OBJ2,OBJ1) ) ).

fof(mergeA2225,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => f__MereologicalProductFn2(OBJ1,OBJ2) = f__MereologicalProductFn2(f__MereologicalProductFn2(OBJ1,OBJ2),OBJ2) ) ).

fof(mergeA2226,axiom,
    p__d__instance(c__MereologicalDifferenceFn,c__SpatialRelation) ).

fof(mergeA2227,axiom,
    p__d__instance(c__MereologicalDifferenceFn,c__BinaryFunction) ).

fof(mergeA2228,axiom,
    p__d__instance(c__MereologicalDifferenceFn,c__TotalValuedRelation) ).

fof(mergeA2232,axiom,
    ! [OBJ3,OBJ1,OBJ2,PART] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ3,c__Object)
        & OBJ3 = f__MereologicalDifferenceFn2(OBJ1,OBJ2)
        & p__d__instance(PART,c__Object) )
     => ( p__part(PART,OBJ3)
      <=> ( p__part(PART,OBJ1)
          & ~ p__overlapsSpatially(PART,OBJ2) ) ) ) ).

fof(mergeA2233,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => f__MereologicalDifferenceFn2(OBJ1,OBJ2) = f__MereologicalDifferenceFn2(f__MereologicalDifferenceFn2(OBJ1,OBJ2),OBJ2) ) ).

fof(mergeA2234,axiom,
    p__d__instance(c__MereologicalComplementFn,c__SpatialRelation) ).

fof(mergeA2235,axiom,
    p__d__instance(c__MereologicalComplementFn,c__UnaryFunction) ).

fof(mergeA2236,axiom,
    p__d__instance(c__MereologicalComplementFn,c__TotalValuedRelation) ).

fof(mergeA2239,axiom,
    ! [OBJ2,OBJ1,PART] :
      ( ( p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object)
        & OBJ2 = f__MereologicalComplementFn1(OBJ1)
        & p__d__instance(PART,c__Object) )
     => ( ( p__part(PART,OBJ1)
        <=> ~ p__overlapsSpatially(PART,OBJ2) )
        & ( p__part(PART,OBJ2)
        <=> ~ p__overlapsSpatially(PART,OBJ1) ) ) ) ).

fof(mergeA2240,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Object)
     => OBJ = f__MereologicalComplementFn1(f__MereologicalComplementFn1(OBJ)) ) ).

fof(mergeA2241,axiom,
    ! [OBJ1,OBJ2,PART] :
      ( ( p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object)
        & OBJ2 = f__MereologicalComplementFn1(OBJ1)
        & p__d__instance(PART,c__Object) )
     => ( p__overlapsSpatially(PART,OBJ1)
        | p__overlapsSpatially(PART,OBJ2) ) ) ).

fof(mergeA2242,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object) )
     => f__MereologicalSumFn2(OBJ1,f__MereologicalComplementFn1(OBJ1)) = f__MereologicalSumFn2(OBJ2,f__MereologicalComplementFn1(OBJ2)) ) ).

fof(mergeA2243,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object) )
     => f__MereologicalProductFn2(OBJ1,f__MereologicalComplementFn1(OBJ1)) = f__MereologicalProductFn2(OBJ2,f__MereologicalComplementFn1(OBJ2)) ) ).

fof(mergeA2244,axiom,
    ! [PART,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(PART,c__Object) )
     => p__part(PART,f__MereologicalSumFn2(OBJ,f__MereologicalComplementFn1(OBJ))) ) ).

fof(mergeA2245,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object) )
     => f__MereologicalProductFn2(OBJ1,f__MereologicalComplementFn1(OBJ1)) = f__MereologicalComplementFn1(f__MereologicalSumFn2(OBJ2,f__MereologicalComplementFn1(OBJ2))) ) ).

fof(mergeA2246,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object) )
     => f__MereologicalSumFn2(OBJ1,f__MereologicalComplementFn1(OBJ1)) = f__MereologicalComplementFn1(f__MereologicalProductFn2(OBJ2,f__MereologicalComplementFn1(OBJ2))) ) ).

fof(mergeA2247,axiom,
    p__d__instance(c__hole,c__BinaryPredicate) ).

fof(mergeA2248,axiom,
    p__d__instance(c__hole,c__SpatialRelation) ).

fof(mergeA2249,axiom,
    p__d__instance(c__hole,c__AsymmetricRelation) ).

fof(mergeA2252,axiom,
    p__d__subclass(c__Hole,c__Region) ).

fof(mergeA2253,axiom,
    ! [HOLE] :
      ( p__d__instance(HOLE,c__Hole)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__SelfConnectedObject)
          & p__hole(HOLE,OBJ) ) ) ).

fof(mergeA2254,axiom,
    ! [HOLE,OBJ] :
      ( ( p__d__instance(OBJ,c__SelfConnectedObject)
        & p__d__instance(HOLE,c__Hole)
        & p__hole(HOLE,OBJ) )
     => ~ p__d__instance(OBJ,c__Hole) ) ).

fof(mergeA2255,axiom,
    ! [HOLE,OBJ] :
      ( ( p__d__instance(OBJ,c__SelfConnectedObject)
        & p__d__instance(HOLE,c__Hole)
        & p__hole(HOLE,OBJ) )
     => ~ p__overlapsSpatially(HOLE,OBJ) ) ).

fof(mergeA2256,axiom,
    ! [OBJ1,OBJ2,HOLE] :
      ( ( p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__hole(HOLE,OBJ1)
        & p__hole(HOLE,OBJ2) )
     => ? [OBJ3] :
          ( p__d__instance(OBJ3,c__SelfConnectedObject)
          & p__properPart(OBJ3,f__MereologicalProductFn2(OBJ1,OBJ2))
          & p__hole(HOLE,OBJ3) ) ) ).

fof(mergeA2257,axiom,
    ! [HOLE1,HOLE2,OBJ,HOLE3] :
      ( ( p__d__instance(OBJ,c__SelfConnectedObject)
        & p__d__instance(HOLE1,c__Hole)
        & p__d__instance(HOLE2,c__Hole)
        & p__hole(HOLE1,OBJ)
        & p__hole(HOLE2,OBJ)
        & p__d__instance(HOLE3,c__Hole)
        & p__part(HOLE3,f__MereologicalSumFn2(HOLE1,HOLE2)) )
     => p__hole(HOLE3,OBJ) ) ).

fof(mergeA2258,axiom,
    ! [OBJ1,HOLE,OBJ2] :
      ( ( p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__hole(HOLE,OBJ1)
        & p__part(OBJ1,OBJ2) )
     => ( p__overlapsSpatially(HOLE,OBJ2)
        | p__hole(HOLE,OBJ2) ) ) ).

fof(mergeA2259,axiom,
    ! [HOLE1,HOLE2,OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__d__instance(HOLE1,c__Hole)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__d__instance(HOLE2,c__Hole)
        & p__hole(HOLE1,OBJ1)
        & p__hole(HOLE2,OBJ2)
        & p__overlapsSpatially(HOLE1,HOLE2) )
     => p__overlapsSpatially(OBJ1,OBJ2) ) ).

fof(mergeA2260,axiom,
    ! [HOLE1] :
      ( p__d__instance(HOLE1,c__Hole)
     => ? [HOLE2] :
          ( p__d__instance(HOLE2,c__Object)
          & p__properPart(HOLE2,HOLE1) ) ) ).

fof(mergeA2261,axiom,
    p__d__instance(c__HoleHostFn,c__SpatialRelation) ).

fof(mergeA2262,axiom,
    p__d__instance(c__HoleHostFn,c__UnaryFunction) ).

fof(mergeA2263,axiom,
    p__d__instance(c__HoleHostFn,c__TotalValuedRelation) ).

fof(mergeA2264,axiom,
    p__d__instance(c__HoleHostFn,c__AsymmetricRelation) ).

fof(mergeA2267,axiom,
    ! [HOLE,OBJ] :
      ( ( p__d__instance(OBJ,c__SelfConnectedObject)
        & p__d__instance(HOLE,c__Hole)
        & p__hole(HOLE,OBJ) )
     => p__connected(HOLE,OBJ) ) ).

fof(mergeA2268,axiom,
    ! [HOLE1,HOLE2] :
      ( ( p__d__instance(HOLE2,c__Object)
        & p__d__instance(HOLE1,c__Hole)
        & p__properPart(HOLE2,HOLE1) )
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__Object)
          & p__meetsSpatially(HOLE1,OBJ)
          & ~ p__meetsSpatially(HOLE2,OBJ) ) ) ).

fof(mergeA2269,axiom,
    p__d__instance(c__Fillable,c__ShapeAttribute) ).

fof(mergeA2271,axiom,
    ! [HOLE1] :
      ( p__d__instance(HOLE1,c__Object)
     => ( p__attribute(HOLE1,c__Fillable)
      <=> ? [HOLE2] :
            ( p__d__instance(HOLE2,c__Hole)
            & p__properPart(HOLE1,HOLE2) ) ) ) ).

fof(mergeA2272,axiom,
    p__subrelation(c__partiallyFills,c__located) ).

fof(mergeA2273,axiom,
    p__d__instance(c__partiallyFills,c__SpatialRelation) ).

fof(mergeA2274,axiom,
    p__d__instance(c__partiallyFills,c__AsymmetricRelation) ).

fof(mergeA2277,axiom,
    ! [HOLE1,OBJ] :
      ( ( p__d__instance(HOLE1,c__Hole)
        & p__d__instance(OBJ,c__Object)
        & p__partiallyFills(OBJ,HOLE1) )
     => ? [HOLE2] :
          ( p__d__instance(HOLE2,c__Hole)
          & p__part(HOLE2,HOLE1)
          & p__completelyFills(OBJ,HOLE2) ) ) ).

fof(mergeA2278,axiom,
    p__d__instance(c__properlyFills,c__AsymmetricRelation) ).

fof(mergeA2279,axiom,
    p__subrelation(c__properlyFills,c__partiallyFills) ).

fof(mergeA2282,axiom,
    ! [HOLE1,OBJ] :
      ( ( p__d__instance(HOLE1,c__Hole)
        & p__d__instance(OBJ,c__Object)
        & p__properlyFills(OBJ,HOLE1) )
     => ? [HOLE2] :
          ( p__d__instance(HOLE2,c__Hole)
          & p__part(HOLE2,HOLE1)
          & p__fills(OBJ,HOLE2) ) ) ).

fof(mergeA2283,axiom,
    p__d__instance(c__completelyFills,c__AsymmetricRelation) ).

fof(mergeA2284,axiom,
    p__subrelation(c__completelyFills,c__partiallyFills) ).

fof(mergeA2285,axiom,
    ! [OBJ1,HOLE] :
      ( ( p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ1,c__Object)
        & p__completelyFills(OBJ1,HOLE) )
     => ? [OBJ2] :
          ( p__d__instance(OBJ2,c__Object)
          & p__part(OBJ2,OBJ1)
          & p__fills(OBJ2,HOLE) ) ) ).

fof(mergeA2286,axiom,
    p__d__instance(c__fills,c__AsymmetricRelation) ).

fof(mergeA2287,axiom,
    p__subrelation(c__fills,c__completelyFills) ).

fof(mergeA2288,axiom,
    p__subrelation(c__fills,c__properlyFills) ).

fof(mergeA2291,axiom,
    p__relatedInternalConcept(c__fills,c__Fillable) ).

fof(mergeA2292,axiom,
    ! [HOLE,OBJ1,OBJ2] :
      ( ( p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object)
        & p__fills(OBJ1,HOLE)
        & p__attribute(OBJ2,c__Fillable) )
     => ~ p__overlapsSpatially(OBJ1,OBJ2) ) ).

fof(mergeA2293,axiom,
    ! [HOLE,OBJ1,OBJ2] :
      ( ( p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object)
        & p__completelyFills(OBJ1,HOLE)
        & p__connected(OBJ2,HOLE) )
     => p__connected(OBJ2,OBJ1) ) ).

fof(mergeA2294,axiom,
    ! [OBJ1,HOLE,OBJ2] :
      ( ( p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object)
        & p__properlyFills(OBJ1,HOLE)
        & p__connected(OBJ2,OBJ1) )
     => p__connected(HOLE,OBJ2) ) ).

fof(mergeA2295,axiom,
    ! [HOLE1,OBJ,HOLE2] :
      ( ( p__d__instance(HOLE1,c__Hole)
        & p__d__instance(OBJ,c__Object)
        & p__d__instance(HOLE2,c__Hole)
        & p__fills(OBJ,HOLE1)
        & p__properPart(HOLE2,HOLE1) )
     => p__completelyFills(OBJ,HOLE2) ) ).

fof(mergeA2296,axiom,
    ! [OBJ1,OBJ2,HOLE] :
      ( ( p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__Object)
        & p__fills(OBJ1,HOLE)
        & p__properPart(OBJ2,OBJ1) )
     => p__properlyFills(OBJ2,HOLE) ) ).

fof(mergeA2297,axiom,
    p__d__instance(c__HoleSkinFn,c__SpatialRelation) ).

fof(mergeA2298,axiom,
    p__d__instance(c__HoleSkinFn,c__UnaryFunction) ).

fof(mergeA2299,axiom,
    p__d__instance(c__HoleSkinFn,c__TotalValuedRelation) ).

fof(mergeA2300,axiom,
    p__d__instance(c__HoleSkinFn,c__AsymmetricRelation) ).

fof(mergeA2303,axiom,
    ! [OBJ1,HOLE,OBJ2] :
      ( ( p__d__instance(HOLE,c__Hole)
        & p__d__instance(OBJ1,c__Object)
        & OBJ1 = f__HoleSkinFn1(HOLE)
        & p__d__instance(OBJ2,c__Object) )
     => ( p__overlapsSpatially(OBJ2,OBJ1)
      <=> ? [OBJ3] :
            ( p__d__instance(OBJ3,c__Object)
            & p__superficialPart(OBJ3,f__HoleHostFn1(HOLE))
            & p__meetsSpatially(HOLE,OBJ3)
            & p__overlapsSpatially(OBJ2,OBJ3) ) ) ) ).

fof(mergeA2304,axiom,
    p__d__instance(c__subProcess,c__BinaryPredicate) ).

fof(mergeA2305,axiom,
    p__d__instance(c__subProcess,c__PartialOrderingRelation) ).

fof(mergeA2308,axiom,
    ! [SUBPROC,PROC] :
      ( ( p__d__instance(PROC,c__Process)
        & p__d__instance(SUBPROC,c__Process)
        & p__subProcess(SUBPROC,PROC) )
     => p__temporalPart(f__WhenFn1(SUBPROC),f__WhenFn1(PROC)) ) ).

fof(mergeA2309,axiom,
    p__d__subclass(c__BiologicalProcess,c__InternalChange) ).

fof(mergeA2310,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__BiologicalProcess)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__Organism)
          & p__eventLocated(PROC,OBJ) ) ) ).

fof(mergeA2311,axiom,
    ! [PROC,ORG] :
      ( ( p__d__instance(ORG,c__Agent)
        & p__d__instance(PROC,c__BiologicalProcess)
        & p__experiencer(PROC,ORG) )
     => p__d__instance(ORG,c__Organism) ) ).

fof(mergeA2312,axiom,
    p__d__subclass(c__PhysiologicProcess,c__BiologicalProcess) ).

fof(mergeA2313,axiom,
    p__d__subclass(c__AutonomicProcess,c__PhysiologicProcess) ).

fof(mergeA2314,axiom,
    p__d__disjoint(c__AutonomicProcess,c__IntentionalProcess) ).

fof(mergeA2315,axiom,
    p__d__subclass(c__OrganOrTissueProcess,c__AutonomicProcess) ).

fof(mergeA2316,axiom,
    p__d__disjoint(c__OrganOrTissueProcess,c__OrganismProcess) ).

fof(mergeA2317,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__OrganOrTissueProcess)
     => ? [THING] :
          ( p__d__instance(THING,c__Object)
          & p__eventLocated(PROC,THING)
          & ( p__d__instance(THING,c__Organ)
            | p__d__instance(THING,c__Tissue) ) ) ) ).

fof(mergeA2318,axiom,
    p__d__subclass(c__OrganismProcess,c__PhysiologicProcess) ).

fof(mergeA2319,axiom,
    p__d__subclass(c__Birth,c__OrganismProcess) ).

fof(mergeA2320,axiom,
    ! [BIRTH,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(BIRTH,c__Birth)
        & p__experiencer(BIRTH,AGENT) )
     => ? [DEATH] :
          ( p__d__instance(DEATH,c__Death)
          & p__experiencer(DEATH,AGENT) ) ) ).

fof(mergeA2321,axiom,
    p__d__subclass(c__Death,c__OrganismProcess) ).

fof(mergeA2323,axiom,
    p__d__subclass(c__Breathing,c__OrganismProcess) ).

fof(mergeA2324,axiom,
    p__d__subclass(c__Breathing,c__AutonomicProcess) ).

fof(mergeA2325,axiom,
    p__d__subclass(c__Ingesting,c__OrganismProcess) ).

fof(mergeA2327,axiom,
    p__d__subclass(c__Eating,c__Ingesting) ).

fof(mergeA2328,axiom,
    ! [ACT,FOOD] :
      ( ( p__d__instance(FOOD,c__Object)
        & p__d__instance(ACT,c__Eating)
        & p__resource(ACT,FOOD) )
     => p__attribute(FOOD,c__Solid) ) ).

fof(mergeA2329,axiom,
    p__d__subclass(c__Drinking,c__Ingesting) ).

fof(mergeA2330,axiom,
    ! [ACT,FOOD] :
      ( ( p__d__instance(FOOD,c__Object)
        & p__d__instance(ACT,c__Drinking)
        & p__resource(ACT,FOOD) )
     => p__attribute(FOOD,c__Liquid) ) ).

fof(mergeA2331,axiom,
    p__d__subclass(c__Digesting,c__OrganismProcess) ).

fof(mergeA2332,axiom,
    p__d__subclass(c__Digesting,c__AutonomicProcess) ).

fof(mergeA2333,axiom,
    ! [ORGANISM,DIGEST] :
      ( ( p__d__instance(ORGANISM,c__Agent)
        & p__d__instance(DIGEST,c__Digesting)
        & p__agent(DIGEST,ORGANISM) )
     => ? [INGEST] :
          ( p__d__instance(INGEST,c__Ingesting)
          & p__agent(INGEST,ORGANISM)
          & p__overlapsTemporally(f__WhenFn1(INGEST),f__WhenFn1(DIGEST)) ) ) ).

fof(mergeA2334,axiom,
    ! [DIGEST] :
      ( p__d__instance(DIGEST,c__Digesting)
     => ? [DECOMP] :
          ( p__d__instance(DECOMP,c__ChemicalDecomposition)
          & p__subProcess(DECOMP,DIGEST) ) ) ).

fof(mergeA2335,axiom,
    p__d__subclass(c__Growth,c__AutonomicProcess) ).

fof(mergeA2336,axiom,
    p__d__subclass(c__Replication,c__OrganismProcess) ).

fof(mergeA2337,axiom,
    ! [REP,CHILD,PARENT] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__d__instance(REP,c__Replication)
        & p__agent(REP,PARENT)
        & p__result(REP,CHILD) )
     => p__parent(CHILD,PARENT) ) ).

fof(mergeA2338,axiom,
    ! [REP] :
      ( p__d__instance(REP,c__Replication)
     => ? [BODY] :
          ( p__d__instance(BODY,c__ReproductiveBody)
          & p__result(REP,BODY) ) ) ).

fof(mergeA2339,axiom,
    p__d__subclass(c__SexualReproduction,c__Replication) ).

fof(mergeA2340,axiom,
    p__d__disjoint(c__SexualReproduction,c__AsexualReproduction) ).

fof(mergeA2341,axiom,
    ! [REP,ORGANISM] :
      ( ( p__d__instance(ORGANISM,c__Organism)
        & p__d__instance(REP,c__SexualReproduction)
        & p__result(REP,ORGANISM) )
     => ? [MOTHER,FATHER] :
          ( p__d__instance(MOTHER,c__Organism)
          & p__d__instance(FATHER,c__Organism)
          & p__mother(ORGANISM,MOTHER)
          & p__father(ORGANISM,FATHER) ) ) ).

fof(mergeA2342,axiom,
    p__d__subclass(c__AsexualReproduction,c__Replication) ).

fof(mergeA2343,axiom,
    ! [REP,ORGANISM,PARENT1,PARENT2] :
      ( ( p__d__instance(ORGANISM,c__Organism)
        & p__d__instance(PARENT1,c__Organism)
        & p__d__instance(PARENT2,c__Organism)
        & p__d__instance(REP,c__AsexualReproduction)
        & p__result(REP,ORGANISM)
        & p__parent(ORGANISM,PARENT1)
        & p__parent(ORGANISM,PARENT2) )
     => PARENT1 = PARENT2 ) ).

fof(mergeA2344,axiom,
    p__d__subclass(c__PsychologicalProcess,c__BiologicalProcess) ).

fof(mergeA2345,axiom,
    ! [PROCESS] :
      ( p__d__instance(PROCESS,c__PsychologicalProcess)
     => ? [ANIMAL] :
          ( p__d__instance(ANIMAL,c__Animal)
          & p__experiencer(PROCESS,ANIMAL) ) ) ).

fof(mergeA2346,axiom,
    p__d__subclass(c__PathologicProcess,c__BiologicalProcess) ).

fof(mergeA2347,axiom,
    p__d__disjoint(c__PathologicProcess,c__PhysiologicProcess) ).

fof(mergeA2348,axiom,
    ! [PATH,ORG] :
      ( ( p__d__instance(ORG,c__Agent)
        & p__d__instance(PATH,c__PathologicProcess)
        & p__experiencer(PATH,ORG) )
     => ? [PART,DISEASE] :
          ( p__d__instance(PART,c__Object)
          & p__part(PART,ORG)
          & p__d__instance(DISEASE,c__DiseaseOrSyndrome)
          & p__attribute(PART,DISEASE) ) ) ).

fof(mergeA2349,axiom,
    p__d__subclass(c__Injuring,c__PathologicProcess) ).

fof(mergeA2350,axiom,
    p__d__subclass(c__Injuring,c__Damaging) ).

fof(mergeA2351,axiom,
    ! [INJ] :
      ( p__d__instance(INJ,c__Process)
     => ( p__d__instance(INJ,c__Injuring)
      <=> ( p__d__instance(INJ,c__Damaging)
          & ? [ORGANISM] :
              ( p__d__instance(ORGANISM,c__Organism)
              & p__patient(INJ,ORGANISM) ) ) ) ) ).

fof(mergeA2352,axiom,
    p__d__subclass(c__Poisoning,c__Injuring) ).

fof(mergeA2353,axiom,
    ! [POISON] :
      ( p__d__instance(POISON,c__Poisoning)
     => ? [THING] :
          ( p__patient(POISON,THING)
          & ( p__d__instance(THING,c__Organism)
            | p__d__instance(THING,c__AnatomicalStructure) ) ) ) ).

fof(mergeA2354,axiom,
    ! [POISON] :
      ( p__d__instance(POISON,c__Poisoning)
     => ? [SUBSTANCE] :
          ( p__d__instance(SUBSTANCE,c__BiologicallyActiveSubstance)
          & p__instrument(POISON,SUBSTANCE) ) ) ).

fof(mergeA2355,axiom,
    p__d__subclass(c__NaturalProcess,c__Process) ).

fof(mergeA2356,axiom,
    p__d__disjoint(c__NaturalProcess,c__IntentionalProcess) ).

fof(mergeA2357,axiom,
    p__d__subclass(c__IntentionalProcess,c__Process) ).

fof(mergeA2358,axiom,
    ! [PROC,AGENT] :
      ( ( p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(PROC,c__IntentionalProcess)
        & p__agent(PROC,AGENT) )
     => ? [PURP] :
          ( p__d__instance(PURP,c__Formula)
          & p__hasPurposeForAgent(PROC,PURP,AGENT) ) ) ).

fof(mergeA2359,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__IntentionalProcess)
     => ? [AGENT] :
          ( p__d__instance(AGENT,c__CognitiveAgent)
          & p__agent(PROC,AGENT) ) ) ).

fof(mergeA2361,axiom,
    p__d__subclass(c__IntentionalPsychologicalProcess,c__IntentionalProcess) ).

fof(mergeA2362,axiom,
    p__d__subclass(c__IntentionalPsychologicalProcess,c__PsychologicalProcess) ).

fof(mergeA2363,axiom,
    p__d__subclass(c__RecreationOrExercise,c__IntentionalProcess) ).

fof(mergeA2364,axiom,
    p__d__subclass(c__OrganizationalProcess,c__IntentionalProcess) ).

fof(mergeA2365,axiom,
    ! [ACT,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(AGENT,c__SelfConnectedObject)
        & p__d__instance(ACT,c__OrganizationalProcess)
        & p__agent(ACT,AGENT) )
     => ( p__d__instance(AGENT,c__Organization)
        | ? [ORG] :
            ( p__d__instance(ORG,c__Organization)
            & p__member(AGENT,ORG) ) ) ) ).

fof(mergeA2366,axiom,
    p__d__subclass(c__Election,c__OrganizationalProcess) ).

fof(mergeA2367,axiom,
    p__d__subclass(c__ReligiousProcess,c__OrganizationalProcess) ).

fof(mergeA2368,axiom,
    ! [ACT,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(AGENT,c__SelfConnectedObject)
        & p__d__instance(ACT,c__ReligiousProcess)
        & p__agent(ACT,AGENT) )
     => ( p__d__instance(AGENT,c__ReligiousOrganization)
        | ? [ORG] :
            ( p__member(AGENT,ORG)
            & p__d__instance(ORG,c__ReligiousOrganization) ) ) ) ).

fof(mergeA2369,axiom,
    p__d__subclass(c__JoiningAnOrganization,c__OrganizationalProcess) ).

fof(mergeA2371,axiom,
    p__d__subclass(c__LeavingAnOrganization,c__OrganizationalProcess) ).

fof(mergeA2372,axiom,
    p__d__disjoint(c__LeavingAnOrganization,c__JoiningAnOrganization) ).

fof(mergeA2374,axiom,
    p__d__subclass(c__Graduation,c__LeavingAnOrganization) ).

fof(mergeA2375,axiom,
    ! [GRAD,ORG] :
      ( ( p__d__instance(ORG,c__Agent)
        & p__d__instance(GRAD,c__Graduation)
        & p__agent(GRAD,ORG) )
     => p__d__instance(ORG,c__EducationalOrganization) ) ).

fof(mergeA2376,axiom,
    p__d__subclass(c__Matriculation,c__JoiningAnOrganization) ).

fof(mergeA2377,axiom,
    ! [MAT,ORG] :
      ( ( p__d__instance(ORG,c__Agent)
        & p__d__instance(MAT,c__Matriculation)
        & p__agent(MAT,ORG) )
     => p__d__instance(ORG,c__EducationalOrganization) ) ).

fof(mergeA2378,axiom,
    p__d__subclass(c__Hiring,c__JoiningAnOrganization) ).

fof(mergeA2380,axiom,
    p__d__subclass(c__TerminatingEmployment,c__LeavingAnOrganization) ).

fof(mergeA2382,axiom,
    p__d__subclass(c__PoliticalProcess,c__OrganizationalProcess) ).

fof(mergeA2383,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__PoliticalProcess)
     => ? [POL] :
          ( p__d__instance(POL,c__SelfConnectedObject)
          & p__d__instance(POL,c__Agent)
          & ( p__d__instance(POL,c__Government)
            | ? [GOV] :
                ( p__d__instance(GOV,c__Government)
                & p__member(POL,GOV) ) )
          & ( p__agent(PROC,POL)
            | p__patient(PROC,POL) ) ) ) ).

fof(mergeA2384,axiom,
    p__d__subclass(c__JudicialProcess,c__PoliticalProcess) ).

fof(mergeA2385,axiom,
    ! [PROCESS,ORG] :
      ( ( p__d__instance(PROCESS,c__JudicialProcess)
        & p__agent(PROCESS,ORG)
        & p__d__instance(ORG,c__Organization) )
     => p__d__instance(ORG,c__JudicialOrganization) ) ).

fof(mergeA2386,axiom,
    p__d__subclass(c__LegalDecision,c__JudicialProcess) ).

fof(mergeA2387,axiom,
    p__d__subclass(c__LegalDecision,c__Declaring) ).

fof(mergeA2388,axiom,
    ! [DECISION] :
      ( p__d__instance(DECISION,c__LegalDecision)
     => ? [ACTION] :
          ( p__d__instance(ACTION,c__LegalAction)
          & p__refers(DECISION,ACTION) ) ) ).

fof(mergeA2389,axiom,
    ! [DECISION] :
      ( p__d__instance(DECISION,c__LegalDecision)
     => ? [DECIDE] :
          ( p__d__instance(DECIDE,c__Deciding)
          & p__earlier(f__WhenFn1(DECIDE),f__WhenFn1(DECISION)) ) ) ).

fof(mergeA2390,axiom,
    p__d__subclass(c__MilitaryProcess,c__PoliticalProcess) ).

fof(mergeA2391,axiom,
    p__d__subclass(c__MilitaryProcess,c__OrganizationalProcess) ).

fof(mergeA2392,axiom,
    p__d__subclass(c__RegulatoryProcess,c__Guiding) ).

fof(mergeA2393,axiom,
    p__d__subclass(c__Managing,c__OrganizationalProcess) ).

fof(mergeA2394,axiom,
    p__d__subclass(c__Managing,c__Guiding) ).

fof(mergeA2395,axiom,
    p__d__subclass(c__Planning,c__IntentionalPsychologicalProcess) ).

fof(mergeA2396,axiom,
    ! [EVENT,CBO] :
      ( ( p__d__instance(EVENT,c__Planning)
        & p__result(EVENT,CBO)
        & p__d__instance(CBO,c__ContentBearingObject) )
     => ? [PLAN] :
          ( p__d__instance(PLAN,c__Plan)
          & p__containsInformation(CBO,PLAN) ) ) ).

fof(mergeA2397,axiom,
    p__d__subclass(c__Designing,c__IntentionalPsychologicalProcess) ).

fof(mergeA2398,axiom,
    p__d__subclass(c__Interpreting,c__IntentionalPsychologicalProcess) ).

fof(mergeA2400,axiom,
    p__d__subclass(c__QuantityChange,c__InternalChange) ).

fof(mergeA2401,axiom,
    p__d__partition3(c__QuantityChange,c__Increasing,c__Decreasing) ).

fof(mergeA2402,axiom,
    p__d__subclass(c__Increasing,c__QuantityChange) ).

fof(mergeA2405,axiom,
    p__d__subclass(c__Heating,c__Increasing) ).

fof(mergeA2406,axiom,
    p__d__disjoint(c__Heating,c__Cooling) ).

fof(mergeA2408,axiom,
    p__d__subclass(c__Decreasing,c__QuantityChange) ).

fof(mergeA2411,axiom,
    p__d__subclass(c__Cooling,c__Decreasing) ).

fof(mergeA2413,axiom,
    p__d__instance(c__moves,c__CaseRole) ).

fof(mergeA2416,axiom,
    p__subrelation(c__moves,c__involvedInEvent) ).

fof(mergeA2417,axiom,
    p__d__instance(c__changesLocation,c__CaseRole) ).

fof(mergeA2420,axiom,
    p__subrelation(c__changesLocation,c__moves) ).

fof(mergeA2421,axiom,
    ! [EVENT,OBJ] :
      ( ( p__d__instance(OBJ,c__Agent)
        & p__d__instance(EVENT,c__Translocation)
        & p__changesLocation(EVENT,OBJ) )
     => ( p__d__instance(EVENT,c__Translocation)
        & p__d__instance(OBJ,c__Object)
        & ( p__patient(EVENT,OBJ)
          | p__agent(EVENT,OBJ)
          | p__experiencer(EVENT,OBJ) ) ) ) ).

fof(mergeA2422,axiom,
    p__d__subclass(c__Motion,c__Process) ).

fof(mergeA2423,axiom,
    ! [MOTION] :
      ( p__d__instance(MOTION,c__Motion)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__Object)
          & p__moves(MOTION,OBJ) ) ) ).

fof(mergeA2426,axiom,
    p__d__subclass(c__MotionUpward,c__Motion) ).

fof(mergeA2427,axiom,
    p__d__disjoint(c__MotionUpward,c__MotionDownward) ).

fof(mergeA2428,axiom,
    p__d__subclass(c__MotionDownward,c__Motion) ).

fof(mergeA2429,axiom,
    p__d__instance(c__path,c__CaseRole) ).

fof(mergeA2430,axiom,
    p__subrelation(c__path,c__eventPartlyLocated) ).

fof(mergeA2433,axiom,
    ! [PROCESS,MEASURE1,DISTANCE,PATH1,SOURCE,DEST,OBJ] :
      ( ( p__d__instance(PATH1,c__Object)
        & p__d__instance(PROCESS,c__Motion)
        & p__d__instance(SOURCE,c__Object)
        & p__d__instance(DEST,c__Object)
        & p__d__instance(MEASURE1,c__LengthMeasure)
        & p__d__instance(DISTANCE,c__LengthMeasure)
        & p__d__instance(OBJ,c__Object)
        & p__path(PROCESS,PATH1)
        & p__origin(PROCESS,SOURCE)
        & p__destination(PROCESS,DEST)
        & p__length(PATH1,MEASURE1)
        & p__distance(SOURCE,DEST,DISTANCE)
        & ~ p__greaterThan(MEASURE1,DISTANCE)
        & p__part(OBJ,PATH1) )
     => p__between(SOURCE,OBJ,DEST) ) ).

fof(mergeA2434,axiom,
    p__d__subclass(c__BodyMotion,c__Motion) ).

fof(mergeA2435,axiom,
    ! [MOTION,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(MOTION,c__BodyMotion)
        & p__moves(MOTION,OBJ) )
     => ( p__d__instance(OBJ,c__BodyPart)
        & p__patient(MOTION,OBJ) ) ) ).

fof(mergeA2436,axiom,
    ! [MOTION] :
      ( p__d__instance(MOTION,c__BodyMotion)
     => ? [AGENT] :
          ( p__d__instance(AGENT,c__Organism)
          & p__agent(MOTION,AGENT) ) ) ).

fof(mergeA2437,axiom,
    p__d__subclass(c__VocalCords,c__Organ) ).

fof(mergeA2438,axiom,
    p__typicalPart(c__VocalCords,c__Human) ).

fof(mergeA2439,axiom,
    p__typicallyContainsPart(c__VocalCords,c__Human) ).

fof(mergeA2440,axiom,
    p__initialPart(c__VocalCords,c__Human) ).

fof(mergeA2441,axiom,
    p__d__subclass(c__Vocalizing,c__RadiatingSound) ).

fof(mergeA2442,axiom,
    ! [VOCAL] :
      ( p__d__instance(VOCAL,c__Vocalizing)
     => ? [CORD,ORGANISM] :
          ( p__d__instance(CORD,c__VocalCords)
          & p__instrument(VOCAL,CORD)
          & p__part(CORD,ORGANISM)
          & p__d__instance(ORGANISM,c__Organism) ) ) ).

fof(mergeA2443,axiom,
    p__d__subclass(c__Speaking,c__LinguisticCommunication) ).

fof(mergeA2444,axiom,
    p__d__subclass(c__Speaking,c__Vocalizing) ).

fof(mergeA2445,axiom,
    p__d__subclass(c__Ambulating,c__BodyMotion) ).

fof(mergeA2446,axiom,
    p__d__subclass(c__Ambulating,c__Translocation) ).

fof(mergeA2447,axiom,
    p__d__partition3(c__Ambulating,c__Walking,c__Running) ).

fof(mergeA2448,axiom,
    p__d__subclass(c__Walking,c__Ambulating) ).

fof(mergeA2449,axiom,
    p__d__subclass(c__Running,c__Ambulating) ).

fof(mergeA2451,axiom,
    p__d__subclass(c__Swimming,c__BodyMotion) ).

fof(mergeA2452,axiom,
    ! [SWIM,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(SWIM,c__Swimming)
        & p__agent(SWIM,AGENT) )
     => ? [AREA] :
          ( p__d__instance(AREA,c__WaterArea)
          & p__located(AGENT,AREA) ) ) ).

fof(mergeA2453,axiom,
    p__d__subclass(c__Dancing,c__BodyMotion) ).

fof(mergeA2454,axiom,
    p__d__subclass(c__GeologicalProcess,c__Motion) ).

fof(mergeA2455,axiom,
    p__d__subclass(c__GeologicalProcess,c__InternalChange) ).

fof(mergeA2456,axiom,
    p__d__disjoint(c__GeologicalProcess,c__IntentionalProcess) ).

fof(mergeA2457,axiom,
    p__d__subclass(c__WeatherProcess,c__Motion) ).

fof(mergeA2458,axiom,
    p__d__disjoint(c__WeatherProcess,c__IntentionalProcess) ).

fof(mergeA2459,axiom,
    p__d__subclass(c__Precipitation,c__WeatherProcess) ).

fof(mergeA2460,axiom,
    p__d__subclass(c__Precipitation,c__WaterMotion) ).

fof(mergeA2461,axiom,
    p__d__subclass(c__Precipitation,c__Falling) ).

fof(mergeA2462,axiom,
    ! [PROCESS] :
      ( p__d__instance(PROCESS,c__Precipitation)
     => ? [STUFF] :
          ( p__d__instance(STUFF,c__Water)
          & p__patient(PROCESS,STUFF) ) ) ).

fof(mergeA2463,axiom,
    p__d__subclass(c__LiquidMotion,c__Motion) ).

fof(mergeA2464,axiom,
    ! [MOTION,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(MOTION,c__LiquidMotion)
        & p__patient(MOTION,OBJ) )
     => p__attribute(OBJ,c__Liquid) ) ).

fof(mergeA2465,axiom,
    p__d__subclass(c__WaterMotion,c__LiquidMotion) ).

fof(mergeA2466,axiom,
    ! [MOTION] :
      ( p__d__instance(MOTION,c__WaterMotion)
     => ? [WATER] :
          ( p__patient(MOTION,WATER)
          & p__d__instance(WATER,c__Water) ) ) ).

fof(mergeA2467,axiom,
    p__d__subclass(c__GasMotion,c__Motion) ).

fof(mergeA2468,axiom,
    ! [MOTION,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(MOTION,c__GasMotion)
        & p__patient(MOTION,OBJ) )
     => p__attribute(OBJ,c__Gas) ) ).

fof(mergeA2469,axiom,
    p__d__subclass(c__Wind,c__GasMotion) ).

fof(mergeA2470,axiom,
    p__d__subclass(c__DirectionChange,c__Motion) ).

fof(mergeA2472,axiom,
    p__d__subclass(c__Transfer,c__Translocation) ).

fof(mergeA2473,axiom,
    ! [TRANSFER,AGENT,PATIENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(TRANSFER,c__Transfer)
        & p__agent(TRANSFER,AGENT)
        & p__patient(TRANSFER,PATIENT) )
     => AGENT != PATIENT ) ).

fof(mergeA2474,axiom,
    ! [D1,O1,D2,P,T1,T2] :
      ( ( p__d__instance(O1,c__Object)
        & p__d__instance(D1,c__Object)
        & p__d__instance(P,c__Agent)
        & p__d__instance(T1,c__Translocation)
        & p__d__instance(T2,c__Translocation)
        & p__origin(T1,O1)
        & p__origin(T2,D1)
        & p__destination(T1,D1)
        & p__destination(T2,D2)
        & p__experiencer(T1,P)
        & p__experiencer(T2,P) )
     => ? [T] :
          ( p__d__instance(T,c__Translocation)
          & p__origin(T,O1)
          & p__destination(T,D2)
          & p__subProcess(T1,T)
          & p__subProcess(T2,T)
          & p__experiencer(T,P)
          & p__starts(f__WhenFn1(T1),f__WhenFn1(T))
          & p__finishes(f__WhenFn1(T2),f__WhenFn1(T)) ) ) ).

fof(mergeA2475,axiom,
    p__d__subclass(c__Carrying,c__Transfer) ).

fof(mergeA2476,axiom,
    ! [CARRY] :
      ( p__d__instance(CARRY,c__Carrying)
     => ? [ANIMAL] :
          ( p__d__instance(ANIMAL,c__Animal)
          & p__instrument(CARRY,ANIMAL) ) ) ).

fof(mergeA2477,axiom,
    p__d__subclass(c__Removing,c__Transfer) ).

fof(mergeA2479,axiom,
    p__d__subclass(c__Uncovering,c__Removing) ).

fof(mergeA2480,axiom,
    p__d__disjoint(c__Uncovering,c__Covering) ).

fof(mergeA2481,axiom,
    p__d__subclass(c__Putting,c__Transfer) ).

fof(mergeA2483,axiom,
    p__d__subclass(c__Covering,c__Putting) ).

fof(mergeA2484,axiom,
    p__d__subclass(c__Inserting,c__Putting) ).

fof(mergeA2486,axiom,
    p__d__subclass(c__Injecting,c__Inserting) ).

fof(mergeA2487,axiom,
    ! [INJECT] :
      ( p__d__instance(INJECT,c__Injecting)
     => ? [SUBSTANCE,ANIMAL] :
          ( p__patient(INJECT,SUBSTANCE)
          & p__d__instance(SUBSTANCE,c__BiologicallyActiveSubstance)
          & p__attribute(SUBSTANCE,c__Liquid)
          & p__destination(INJECT,ANIMAL)
          & p__d__instance(ANIMAL,c__Animal) ) ) ).

fof(mergeA2488,axiom,
    p__d__subclass(c__Substituting,c__Transfer) ).

fof(mergeA2489,axiom,
    p__d__subclass(c__Substituting,c__DualObjectProcess) ).

fof(mergeA2490,axiom,
    ! [SUB] :
      ( p__d__instance(SUB,c__Substituting)
     => ? [PUT,REMOVE,OBJ1,OBJ2,PLACE] :
          ( p__d__instance(PLACE,c__Object)
          & p__d__instance(PUT,c__Putting)
          & p__d__instance(REMOVE,c__Removing)
          & p__subProcess(PUT,SUB)
          & p__subProcess(REMOVE,SUB)
          & p__patient(REMOVE,OBJ1)
          & p__origin(REMOVE,PLACE)
          & p__patient(PUT,OBJ2)
          & p__destination(PUT,PLACE)
          & OBJ1 != OBJ2 ) ) ).

fof(mergeA2491,axiom,
    p__d__subclass(c__Impelling,c__Transfer) ).

fof(mergeA2492,axiom,
    p__d__subclass(c__Shooting,c__Impelling) ).

fof(mergeA2493,axiom,
    p__d__subclass(c__Touching,c__Transfer) ).

fof(mergeA2495,axiom,
    p__subrelation(c__grasps,c__meetsSpatially) ).

fof(mergeA2498,axiom,
    p__d__subclass(c__Grabbing,c__Touching) ).

fof(mergeA2499,axiom,
    p__d__subclass(c__Grabbing,c__Attaching) ).

fof(mergeA2501,axiom,
    p__d__subclass(c__Releasing,c__Transfer) ).

fof(mergeA2503,axiom,
    p__d__subclass(c__Impacting,c__Touching) ).

fof(mergeA2504,axiom,
    ! [OBJ,IMPACT] :
      ( ( p__d__instance(IMPACT,c__Impacting)
        & p__patient(IMPACT,OBJ) )
     => ? [IMPEL] :
          ( p__d__instance(IMPEL,c__Impelling)
          & p__patient(IMPEL,OBJ)
          & p__earlier(f__WhenFn1(IMPEL),f__WhenFn1(IMPACT)) ) ) ).

fof(mergeA2505,axiom,
    p__d__subclass(c__Translocation,c__Motion) ).

fof(mergeA2506,axiom,
    ! [PLACE1,MOVEMENT] :
      ( ( p__d__instance(PLACE1,c__Object)
        & p__d__instance(MOVEMENT,c__Translocation)
        & p__origin(MOVEMENT,PLACE1) )
     => ? [PLACE2,STAGE] :
          ( p__d__instance(STAGE,c__Process)
          & p__d__instance(PLACE2,c__Region)
          & PLACE1 != PLACE2
          & p__subProcess(STAGE,MOVEMENT)
          & p__located(STAGE,PLACE2) ) ) ).

fof(mergeA2507,axiom,
    ! [T] :
      ( p__d__instance(T,c__Translocation)
     => ? [O,D,P] :
          ( p__d__instance(O,c__Object)
          & p__d__instance(D,c__Object)
          & p__d__instance(P,c__Object)
          & p__path(T,P)
          & p__origin(T,O)
          & p__destination(T,D) ) ) ).

fof(mergeA2508,axiom,
    p__d__subclass(c__Falling,c__Translocation) ).

fof(mergeA2509,axiom,
    p__d__subclass(c__Falling,c__MotionDownward) ).

fof(mergeA2510,axiom,
    ! [DROP,FINISH,START] :
      ( ( p__d__instance(START,c__Object)
        & p__d__instance(FINISH,c__Object)
        & p__d__instance(DROP,c__Falling)
        & p__origin(DROP,START)
        & p__destination(DROP,FINISH) )
     => p__orientation(FINISH,START,c__Below) ) ).

fof(mergeA2511,axiom,
    p__d__subclass(c__Transportation,c__Translocation) ).

fof(mergeA2513,axiom,
    ! [TRANS] :
      ( p__d__instance(TRANS,c__Transportation)
     => ? [DEVICE] :
          ( p__d__instance(DEVICE,c__TransportationDevice)
          & p__instrument(TRANS,DEVICE) ) ) ).

fof(mergeA2514,axiom,
    p__d__subclass(c__Guiding,c__IntentionalProcess) ).

fof(mergeA2515,axiom,
    p__d__subclass(c__Driving,c__Guiding) ).

fof(mergeA2516,axiom,
    ! [DRIVE] :
      ( p__d__instance(DRIVE,c__Driving)
     => ? [VEHICLE] :
          ( p__d__instance(VEHICLE,c__Vehicle)
          & p__patient(DRIVE,VEHICLE) ) ) ).

fof(mergeA2517,axiom,
    p__d__subclass(c__EducationalProcess,c__Guiding) ).

fof(mergeA2519,axiom,
    p__d__subclass(c__ChangeOfPossession,c__SocialInteraction) ).

fof(mergeA2523,axiom,
    p__d__subclass(c__Giving,c__ChangeOfPossession) ).

fof(mergeA2524,axiom,
    ! [GIVE,AGENT2,AGENT1,OBJ] :
      ( ( p__d__instance(AGENT1,c__Agent)
        & p__d__instance(GIVE,c__Giving)
        & p__agent(GIVE,AGENT1)
        & p__destination(GIVE,AGENT2)
        & p__d__instance(AGENT2,c__Agent)
        & p__patient(GIVE,OBJ) )
     => ? [GET] :
          ( p__d__instance(GET,c__Getting)
          & p__agent(GET,AGENT2)
          & p__origin(GET,AGENT1)
          & p__patient(GET,OBJ) ) ) ).

fof(mergeA2525,axiom,
    ! [GIVE,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(GIVE,c__Giving)
        & p__agent(GIVE,AGENT) )
     => p__origin(GIVE,AGENT) ) ).

fof(mergeA2526,axiom,
    p__d__subclass(c__Funding,c__Giving) ).

fof(mergeA2527,axiom,
    ! [FUND] :
      ( p__d__instance(FUND,c__Funding)
     => ? [MONEY] :
          ( p__d__instance(MONEY,c__Currency)
          & p__patient(FUND,MONEY) ) ) ).

fof(mergeA2528,axiom,
    p__d__subclass(c__UnilateralGiving,c__Giving) ).

fof(mergeA2529,axiom,
    ! [GIVE] :
      ( p__d__instance(GIVE,c__UnilateralGiving)
     => ! [TRANS] :
          ( ~ p__d__instance(TRANS,c__Process)
          | ~ p__d__instance(TRANS,c__Transaction)
          | ~ p__subProcess(GIVE,TRANS) ) ) ).

fof(mergeA2530,axiom,
    p__d__subclass(c__Lending,c__Giving) ).

fof(mergeA2531,axiom,
    ! [AGENT2,AGENT1,OBJECT] :
      ( ( p__d__instance(AGENT1,c__Agent)
        & p__d__instance(AGENT2,c__Agent) )
     => ( ? [BORROW] :
            ( p__d__instance(BORROW,c__Borrowing)
            & p__agent(BORROW,AGENT1)
            & p__origin(BORROW,AGENT2)
            & p__patient(BORROW,OBJECT) )
      <=> ? [LEND] :
            ( p__d__instance(LEND,c__Lending)
            & p__agent(LEND,AGENT2)
            & p__destination(LEND,AGENT1)
            & p__patient(LEND,OBJECT) ) ) ) ).

fof(mergeA2532,axiom,
    p__d__subclass(c__GivingBack,c__Giving) ).

fof(mergeA2533,axiom,
    ! [DEST,AGENT,RETURN] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(DEST,c__Agent)
        & p__d__instance(RETURN,c__GivingBack)
        & p__agent(RETURN,AGENT)
        & p__destination(RETURN,DEST) )
     => ? [GIVE] :
          ( p__d__instance(GIVE,c__Giving)
          & p__agent(GIVE,DEST)
          & p__destination(GIVE,AGENT)
          & p__earlier(f__WhenFn1(GIVE),f__WhenFn1(RETURN)) ) ) ).

fof(mergeA2534,axiom,
    p__d__subclass(c__Getting,c__ChangeOfPossession) ).

fof(mergeA2535,axiom,
    ! [GET,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(GET,c__Getting)
        & p__agent(GET,AGENT) )
     => p__destination(GET,AGENT) ) ).

fof(mergeA2536,axiom,
    p__d__subclass(c__UnilateralGetting,c__Getting) ).

fof(mergeA2538,axiom,
    ! [GET] :
      ( p__d__instance(GET,c__UnilateralGetting)
     => ! [TRANS] :
          ( ~ p__d__instance(TRANS,c__Process)
          | ~ p__d__instance(TRANS,c__Transaction)
          | ~ p__subProcess(GET,TRANS) ) ) ).

fof(mergeA2539,axiom,
    p__d__subclass(c__Borrowing,c__Getting) ).

fof(mergeA2540,axiom,
    p__d__subclass(c__Transaction,c__ChangeOfPossession) ).

fof(mergeA2541,axiom,
    p__d__subclass(c__Transaction,c__DualObjectProcess) ).

fof(mergeA2542,axiom,
    ! [TRANS] :
      ( p__d__instance(TRANS,c__Transaction)
     => ? [AGENT1,AGENT2,GIVE1,GIVE2,OBJ1,OBJ2] :
          ( p__d__instance(AGENT1,c__Agent)
          & p__d__instance(AGENT2,c__Agent)
          & p__d__instance(GIVE1,c__Giving)
          & p__d__instance(GIVE2,c__Giving)
          & p__subProcess(GIVE1,TRANS)
          & p__subProcess(GIVE2,TRANS)
          & p__agent(GIVE1,AGENT1)
          & p__agent(GIVE2,AGENT2)
          & p__patient(GIVE1,OBJ1)
          & p__patient(GIVE2,OBJ2)
          & p__destination(GIVE1,AGENT2)
          & p__destination(GIVE2,AGENT1)
          & AGENT1 != AGENT2
          & OBJ1 != OBJ2 ) ) ).

fof(mergeA2543,axiom,
    p__d__subclass(c__FinancialTransaction,c__Transaction) ).

fof(mergeA2544,axiom,
    ! [TRANS] :
      ( p__d__instance(TRANS,c__FinancialTransaction)
     => ? [OBJ] :
          ( p__patient(TRANS,OBJ)
          & p__d__instance(OBJ,c__FinancialInstrument) ) ) ).

fof(mergeA2545,axiom,
    p__d__instance(c__transactionAmount,c__BinaryPredicate) ).

fof(mergeA2546,axiom,
    p__d__instance(c__transactionAmount,c__SingleValuedRelation) ).

fof(mergeA2547,axiom,
    p__d__instance(c__transactionAmount,c__TotalValuedRelation) ).

fof(mergeA2550,axiom,
    ! [TRANS,AMOUNT] :
      ( ( p__d__instance(AMOUNT,c__CurrencyMeasure)
        & p__d__instance(TRANS,c__FinancialTransaction)
        & p__transactionAmount(TRANS,AMOUNT) )
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__Physical)
          & p__patient(TRANS,OBJ)
          & p__monetaryValue(OBJ,AMOUNT) ) ) ).

fof(mergeA2551,axiom,
    p__d__subclass(c__ServiceProcess,c__SocialInteraction) ).

fof(mergeA2552,axiom,
    p__d__subclass(c__CommercialService,c__FinancialTransaction) ).

fof(mergeA2553,axiom,
    p__d__subclass(c__CommercialService,c__ServiceProcess) ).

fof(mergeA2554,axiom,
    ! [BUSINESS] :
      ( p__d__instance(BUSINESS,c__CommercialService)
     => ? [AGENT] :
          ( p__d__instance(AGENT,c__CommercialAgent)
          & p__agent(BUSINESS,AGENT) ) ) ).

fof(mergeA2555,axiom,
    p__d__subclass(c__Betting,c__FinancialTransaction) ).

fof(mergeA2556,axiom,
    p__d__subclass(c__Buying,c__FinancialTransaction) ).

fof(mergeA2558,axiom,
    ! [BUY,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(BUY,c__Buying)
        & p__agent(BUY,AGENT) )
     => p__destination(BUY,AGENT) ) ).

fof(mergeA2559,axiom,
    p__d__subclass(c__Selling,c__FinancialTransaction) ).

fof(mergeA2560,axiom,
    ! [AGENT2,AGENT1,OBJECT] :
      ( ( p__d__instance(AGENT1,c__Agent)
        & p__d__instance(AGENT2,c__Agent) )
     => ( ? [BUY] :
            ( p__d__instance(BUY,c__Buying)
            & p__agent(BUY,AGENT1)
            & p__origin(BUY,AGENT2)
            & p__patient(BUY,OBJECT) )
      <=> ? [SELL] :
            ( p__d__instance(SELL,c__Selling)
            & p__agent(SELL,AGENT2)
            & p__destination(SELL,AGENT1)
            & p__patient(SELL,OBJECT) ) ) ) ).

fof(mergeA2561,axiom,
    ! [SELL,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(SELL,c__Selling)
        & p__agent(SELL,AGENT) )
     => p__origin(SELL,AGENT) ) ).

fof(mergeA2562,axiom,
    p__d__subclass(c__Learning,c__IntentionalPsychologicalProcess) ).

fof(mergeA2563,axiom,
    ! [LEARN,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(LEARN,c__Learning)
        & p__agent(LEARN,AGENT) )
     => p__d__instance(AGENT,c__CognitiveAgent) ) ).

fof(mergeA2565,axiom,
    p__d__subclass(c__Discovering,c__IntentionalPsychologicalProcess) ).

fof(mergeA2566,axiom,
    ! [OBJ,DISCOVER] :
      ( ( p__d__instance(DISCOVER,c__Discovering)
        & p__patient(DISCOVER,OBJ) )
     => ? [PURSUE] :
          ( p__d__instance(PURSUE,c__Pursuing)
          & p__meetsTemporally(f__WhenFn1(PURSUE),f__WhenFn1(DISCOVER)) ) ) ).

fof(mergeA2568,axiom,
    p__d__subclass(c__Classifying,c__IntentionalPsychologicalProcess) ).

fof(mergeA2569,axiom,
    p__d__subclass(c__Reasoning,c__IntentionalPsychologicalProcess) ).

fof(mergeA2570,axiom,
    ! [AGENT] :
      ( p__d__instance(AGENT,c__CognitiveAgent)
     => p__capability(c__Reasoning,c__agent,AGENT) ) ).

fof(mergeA2571,axiom,
    p__d__subclass(c__Selecting,c__IntentionalPsychologicalProcess) ).

fof(mergeA2572,axiom,
    p__d__subclass(c__Deciding,c__Selecting) ).

fof(mergeA2573,axiom,
    ! [DECIDE,PROCESS,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(PROCESS,c__Process)
        & p__d__instance(DECIDE,c__Deciding)
        & p__agent(DECIDE,AGENT)
        & p__patient(DECIDE,PROCESS) )
     => ( p__d__instance(PROCESS,c__IntentionalProcess)
        & p__agent(PROCESS,AGENT) ) ) ).

fof(mergeA2574,axiom,
    p__d__subclass(c__Voting,c__Deciding) ).

fof(mergeA2575,axiom,
    ! [VOTE] :
      ( p__d__instance(VOTE,c__Voting)
     => ? [ELECT] :
          ( p__d__instance(ELECT,c__Election)
          & p__subProcess(VOTE,ELECT) ) ) ).

fof(mergeA2576,axiom,
    p__d__subclass(c__Judging,c__Selecting) ).

fof(mergeA2578,axiom,
    p__d__subclass(c__Comparing,c__IntentionalPsychologicalProcess) ).

fof(mergeA2579,axiom,
    p__d__subclass(c__Comparing,c__DualObjectProcess) ).

fof(mergeA2580,axiom,
    p__d__subclass(c__Calculating,c__IntentionalPsychologicalProcess) ).

fof(mergeA2581,axiom,
    p__d__subclass(c__Measuring,c__Calculating) ).

fof(mergeA2583,axiom,
    p__d__subclass(c__Counting,c__Calculating) ).

fof(mergeA2585,axiom,
    p__d__subclass(c__Predicting,c__IntentionalPsychologicalProcess) ).

fof(mergeA2587,axiom,
    p__d__subclass(c__Remembering,c__PsychologicalProcess) ).

fof(mergeA2589,axiom,
    p__d__subclass(c__Keeping,c__IntentionalProcess) ).

fof(mergeA2590,axiom,
    ! [AGENT,OBJ,KEEP] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(KEEP,c__Keeping)
        & p__agent(KEEP,AGENT)
        & p__patient(KEEP,OBJ) )
     => ? [PUT] :
          ( p__d__instance(PUT,c__Putting)
          & p__agent(PUT,AGENT)
          & p__patient(PUT,OBJ)
          & p__earlier(f__WhenFn1(PUT),f__WhenFn1(KEEP)) ) ) ).

fof(mergeA2592,axiom,
    p__d__subclass(c__Confining,c__Keeping) ).

fof(mergeA2593,axiom,
    ! [CONFINE] :
      ( p__d__instance(CONFINE,c__Confining)
     => ? [AGENT] :
          ( p__d__instance(AGENT,c__Animal)
          & p__patient(CONFINE,AGENT) ) ) ).

fof(mergeA2595,axiom,
    p__d__subclass(c__Maintaining,c__IntentionalProcess) ).

fof(mergeA2596,axiom,
    p__d__subclass(c__Repairing,c__IntentionalProcess) ).

fof(mergeA2598,axiom,
    ! [OBJ,REPAIR] :
      ( ( p__d__instance(REPAIR,c__Repairing)
        & p__patient(REPAIR,OBJ) )
     => ? [DAMAGE] :
          ( p__d__instance(DAMAGE,c__Damaging)
          & p__patient(DAMAGE,OBJ)
          & p__earlier(f__WhenFn1(DAMAGE),f__WhenFn1(REPAIR)) ) ) ).

fof(mergeA2599,axiom,
    p__d__subclass(c__TherapeuticProcess,c__Repairing) ).

fof(mergeA2600,axiom,
    ! [PROC,BIO] :
      ( ( p__d__instance(BIO,c__Object)
        & p__d__instance(PROC,c__TherapeuticProcess)
        & p__patient(PROC,BIO) )
     => ( p__d__instance(BIO,c__Organism)
        | ? [ORG] :
            ( p__d__instance(ORG,c__Organism)
            & p__part(BIO,ORG) ) ) ) ).

fof(mergeA2601,axiom,
    p__d__subclass(c__Surgery,c__TherapeuticProcess) ).

fof(mergeA2602,axiom,
    ! [ANIMAL,ACT] :
      ( ( p__d__instance(ACT,c__Surgery)
        & p__patient(ACT,ANIMAL) )
     => ? [SUBACT] :
          ( p__d__instance(SUBACT,c__Cutting)
          & p__d__instance(ANIMAL,c__Animal)
          & p__patient(SUBACT,ANIMAL)
          & p__subProcess(SUBACT,ACT) ) ) ).

fof(mergeA2603,axiom,
    p__d__subclass(c__Damaging,c__InternalChange) ).

fof(mergeA2604,axiom,
    p__d__disjoint(c__Damaging,c__Repairing) ).

fof(mergeA2605,axiom,
    p__d__subclass(c__Destruction,c__Damaging) ).

fof(mergeA2606,axiom,
    ! [PROCESS] :
      ( p__d__instance(PROCESS,c__Process)
     => ( p__d__instance(PROCESS,c__Destruction)
      <=> ? [PATIENT] :
            ( p__d__instance(PATIENT,c__Physical)
            & p__patient(PROCESS,PATIENT)
            & p__time(PATIENT,f__BeginFn1(f__WhenFn1(PROCESS)))
            & ~ p__time(PATIENT,f__EndFn1(f__WhenFn1(PROCESS))) ) ) ) ).

fof(mergeA2607,axiom,
    p__d__subclass(c__Killing,c__Destruction) ).

fof(mergeA2608,axiom,
    ! [KILL,AGENT,PATIENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(KILL,c__Killing)
        & p__agent(KILL,AGENT)
        & p__patient(KILL,PATIENT) )
     => ( p__d__instance(AGENT,c__Organism)
        & p__d__instance(PATIENT,c__Organism) ) ) ).

fof(mergeA2610,axiom,
    ! [OBJ,KILL] :
      ( ( p__d__instance(OBJ,c__Agent)
        & p__d__instance(KILL,c__Killing)
        & p__patient(KILL,OBJ) )
     => ? [DEATH] :
          ( p__d__instance(DEATH,c__Death)
          & p__experiencer(DEATH,OBJ)
          & p__causes(KILL,DEATH) ) ) ).

fof(mergeA2611,axiom,
    p__d__subclass(c__Poking,c__IntentionalProcess) ).

fof(mergeA2613,axiom,
    p__d__subclass(c__Cutting,c__Poking) ).

fof(mergeA2614,axiom,
    p__d__subclass(c__Attaching,c__DualObjectProcess) ).

fof(mergeA2615,axiom,
    p__d__disjoint(c__Attaching,c__Detaching) ).

fof(mergeA2618,axiom,
    ! [ATTACH] :
      ( p__d__instance(ATTACH,c__Attaching)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__CorpuscularObject)
          & p__patient(ATTACH,OBJ) ) ) ).

fof(mergeA2619,axiom,
    p__d__subclass(c__Detaching,c__DualObjectProcess) ).

fof(mergeA2621,axiom,
    ! [DETACH] :
      ( p__d__instance(DETACH,c__Detaching)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__CorpuscularObject)
          & p__patient(DETACH,OBJ) ) ) ).

fof(mergeA2622,axiom,
    p__d__subclass(c__Ungrasping,c__Detaching) ).

fof(mergeA2624,axiom,
    p__d__subclass(c__Combining,c__DualObjectProcess) ).

fof(mergeA2626,axiom,
    ! [COMBINE] :
      ( p__d__instance(COMBINE,c__Combining)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__SelfConnectedObject)
          & p__patient(COMBINE,OBJ) ) ) ).

fof(mergeA2627,axiom,
    p__d__subclass(c__Separating,c__DualObjectProcess) ).

fof(mergeA2628,axiom,
    p__d__disjoint(c__Separating,c__Combining) ).

fof(mergeA2629,axiom,
    ! [SEPARATE] :
      ( p__d__instance(SEPARATE,c__Separating)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__SelfConnectedObject)
          & p__patient(SEPARATE,OBJ) ) ) ).

fof(mergeA2630,axiom,
    p__d__subclass(c__ChemicalProcess,c__InternalChange) ).

fof(mergeA2631,axiom,
    p__d__partition3(c__ChemicalProcess,c__ChemicalSynthesis,c__ChemicalDecomposition) ).

fof(mergeA2632,axiom,
    ! [PROC,STUFF] :
      ( ( p__d__instance(STUFF,c__Object)
        & p__d__instance(PROC,c__ChemicalProcess)
        & ( p__resource(PROC,STUFF)
          | p__result(PROC,STUFF) ) )
     => p__d__instance(STUFF,c__PureSubstance) ) ).

fof(mergeA2633,axiom,
    p__d__subclass(c__ChemicalSynthesis,c__ChemicalProcess) ).

fof(mergeA2634,axiom,
    p__d__subclass(c__ChemicalSynthesis,c__Combining) ).

fof(mergeA2635,axiom,
    ! [SUBSTANCE1,SUBSTANCE2,PROC] :
      ( ( p__d__instance(PROC,c__Process)
        & p__resource(PROC,SUBSTANCE1)
        & p__result(PROC,SUBSTANCE2)
        & p__d__instance(SUBSTANCE1,c__ElementalSubstance)
        & p__d__instance(SUBSTANCE2,c__CompoundSubstance) )
     => p__d__instance(PROC,c__ChemicalSynthesis) ) ).

fof(mergeA2636,axiom,
    ! [COMPOUND] :
      ( p__d__instance(COMPOUND,c__CompoundSubstance)
    <=> ? [ELEMENT1,ELEMENT2,PROCESS] :
          ( p__d__instance(ELEMENT1,c__ElementalSubstance)
          & p__d__instance(ELEMENT2,c__ElementalSubstance)
          & ELEMENT1 != ELEMENT2
          & p__d__instance(PROCESS,c__ChemicalSynthesis)
          & p__resource(PROCESS,ELEMENT1)
          & p__resource(PROCESS,ELEMENT2)
          & p__result(PROCESS,COMPOUND) ) ) ).

fof(mergeA2637,axiom,
    p__d__subclass(c__ChemicalDecomposition,c__ChemicalProcess) ).

fof(mergeA2638,axiom,
    p__d__subclass(c__ChemicalDecomposition,c__Separating) ).

fof(mergeA2639,axiom,
    ! [SUBSTANCE1,SUBSTANCE2,PROC] :
      ( ( p__d__instance(PROC,c__Process)
        & p__resource(PROC,SUBSTANCE1)
        & p__result(PROC,SUBSTANCE2)
        & p__d__instance(SUBSTANCE1,c__CompoundSubstance)
        & p__d__instance(SUBSTANCE2,c__ElementalSubstance) )
     => p__d__instance(PROC,c__ChemicalDecomposition) ) ).

fof(mergeA2640,axiom,
    p__d__subclass(c__Combustion,c__ChemicalDecomposition) ).

fof(mergeA2641,axiom,
    ! [COMBUSTION] :
      ( p__d__instance(COMBUSTION,c__Combustion)
     => ? [HEAT,LIGHT] :
          ( p__d__instance(HEAT,c__Heating)
          & p__d__instance(LIGHT,c__RadiatingLight)
          & p__subProcess(HEAT,COMBUSTION)
          & p__subProcess(LIGHT,COMBUSTION) ) ) ).

fof(mergeA2642,axiom,
    p__d__instance(c__Flammable,c__PhysicalAttribute) ).

fof(mergeA2643,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Flammable) )
     => p__capability(c__Combustion,c__patient,X) ) ).

fof(mergeA2644,axiom,
    p__d__subclass(c__InternalChange,c__Process) ).

fof(mergeA2646,axiom,
    p__d__subclass(c__SurfaceChange,c__InternalChange) ).

fof(mergeA2648,axiom,
    p__d__subclass(c__Coloring,c__SurfaceChange) ).

fof(mergeA2650,axiom,
    p__d__subclass(c__ShapeChange,c__InternalChange) ).

fof(mergeA2652,axiom,
    p__d__subclass(c__ContentDevelopment,c__IntentionalProcess) ).

fof(mergeA2653,axiom,
    ! [DEVELOP] :
      ( p__d__instance(DEVELOP,c__ContentDevelopment)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__ContentBearingObject)
          & p__result(DEVELOP,OBJ) ) ) ).

fof(mergeA2654,axiom,
    p__d__subclass(c__Reading,c__ContentDevelopment) ).

fof(mergeA2656,axiom,
    ! [READ] :
      ( p__d__instance(READ,c__Reading)
     => ? [TEXT,PROP] :
          ( p__d__instance(PROP,c__Proposition)
          & p__d__instance(TEXT,c__Text)
          & p__containsInformation(TEXT,PROP)
          & p__realization(READ,PROP) ) ) ).

fof(mergeA2657,axiom,
    p__d__subclass(c__Writing,c__ContentDevelopment) ).

fof(mergeA2658,axiom,
    p__d__subclass(c__Encoding,c__Writing) ).

fof(mergeA2659,axiom,
    p__d__subclass(c__Decoding,c__Writing) ).

fof(mergeA2660,axiom,
    p__d__disjoint(c__Decoding,c__Encoding) ).

fof(mergeA2662,axiom,
    p__d__subclass(c__Translating,c__ContentDevelopment) ).

fof(mergeA2663,axiom,
    p__d__subclass(c__Translating,c__DualObjectProcess) ).

fof(mergeA2664,axiom,
    ! [TRANSLATE,EXPRESSION1,EXPRESSION2] :
      ( ( p__d__instance(EXPRESSION1,c__LinguisticExpression)
        & p__d__instance(EXPRESSION2,c__LinguisticExpression)
        & p__d__instance(TRANSLATE,c__Translating)
        & p__patient(TRANSLATE,EXPRESSION1)
        & p__result(TRANSLATE,EXPRESSION2) )
     => ? [LANGUAGE1,LANGUAGE2,ENTITY] :
          ( p__d__instance(LANGUAGE1,c__Language)
          & p__d__instance(LANGUAGE2,c__Language)
          & p__representsInLanguage(EXPRESSION1,ENTITY,LANGUAGE1)
          & p__representsInLanguage(EXPRESSION2,ENTITY,LANGUAGE2)
          & LANGUAGE1 != LANGUAGE2 ) ) ).

fof(mergeA2665,axiom,
    p__d__subclass(c__Wetting,c__Putting) ).

fof(mergeA2667,axiom,
    ! [WET] :
      ( p__d__instance(WET,c__Wetting)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__Object)
          & p__attribute(OBJ,c__Liquid)
          & p__patient(WET,OBJ) ) ) ).

fof(mergeA2668,axiom,
    p__d__subclass(c__Drying,c__Removing) ).

fof(mergeA2670,axiom,
    p__d__subclass(c__Creation,c__InternalChange) ).

fof(mergeA2672,axiom,
    ! [ACTION] :
      ( p__d__instance(ACTION,c__Creation)
     => ? [RESULT] : p__result(ACTION,RESULT) ) ).

fof(mergeA2673,axiom,
    ! [PROCESS] :
      ( p__d__instance(PROCESS,c__Process)
     => ( p__d__instance(PROCESS,c__Creation)
      <=> ? [PATIENT] :
            ( p__d__instance(PATIENT,c__Physical)
            & p__patient(PROCESS,PATIENT)
            & p__time(PATIENT,f__EndFn1(f__WhenFn1(PROCESS)))
            & ~ p__time(PATIENT,f__BeginFn1(f__WhenFn1(PROCESS))) ) ) ) ).

fof(mergeA2674,axiom,
    p__d__subclass(c__Making,c__Creation) ).

fof(mergeA2675,axiom,
    p__d__subclass(c__Making,c__IntentionalProcess) ).

fof(mergeA2676,axiom,
    p__d__subclass(c__Constructing,c__Making) ).

fof(mergeA2677,axiom,
    ! [ARTIFACT] :
      ( ? [BUILD] :
          ( p__d__instance(BUILD,c__Constructing)
          & p__result(BUILD,ARTIFACT) )
    <=> p__d__instance(ARTIFACT,c__StationaryArtifact) ) ).

fof(mergeA2678,axiom,
    p__d__subclass(c__Manufacture,c__Making) ).

fof(mergeA2679,axiom,
    p__d__subclass(c__Publication,c__Manufacture) ).

fof(mergeA2680,axiom,
    p__d__subclass(c__Publication,c__ContentDevelopment) ).

fof(mergeA2681,axiom,
    ! [PUB,TEXT] :
      ( ( p__d__instance(PUB,c__Publication)
        & p__patient(PUB,TEXT) )
     => p__d__instance(TEXT,c__Text) ) ).

fof(mergeA2682,axiom,
    p__d__subclass(c__Cooking,c__Making) ).

fof(mergeA2684,axiom,
    p__d__subclass(c__Pursuing,c__IntentionalProcess) ).

fof(mergeA2685,axiom,
    ! [PURSUE] :
      ( p__d__instance(PURSUE,c__Pursuing)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__Object)
          & p__patient(PURSUE,OBJ) ) ) ).

fof(mergeA2688,axiom,
    p__d__subclass(c__Hunting,c__Pursuing) ).

fof(mergeA2689,axiom,
    ! [H] :
      ( p__d__instance(H,c__Hunting)
     => ? [T] :
          ( p__d__instance(T,c__Animal)
          & p__patient(H,T) ) ) ).

fof(mergeA2691,axiom,
    p__d__subclass(c__Investigating,c__IntentionalPsychologicalProcess) ).

fof(mergeA2692,axiom,
    ! [INVESTIGATE,PROP] :
      ( ( p__d__instance(INVESTIGATE,c__Investigating)
        & p__patient(INVESTIGATE,PROP) )
     => p__d__instance(PROP,c__Formula) ) ).

fof(mergeA2694,axiom,
    p__d__subclass(c__Experimenting,c__Investigating) ).

fof(mergeA2695,axiom,
    p__d__subclass(c__DiagnosticProcess,c__Investigating) ).

fof(mergeA2697,axiom,
    p__d__subclass(c__SocialInteraction,c__IntentionalProcess) ).

fof(mergeA2698,axiom,
    ! [INTERACTION] :
      ( p__d__instance(INTERACTION,c__SocialInteraction)
     => ? [AGENT1,AGENT2] :
          ( p__involvedInEvent(INTERACTION,AGENT1)
          & p__involvedInEvent(INTERACTION,AGENT2)
          & p__d__instance(AGENT1,c__Agent)
          & p__d__instance(AGENT2,c__Agent)
          & AGENT1 != AGENT2 ) ) ).

fof(mergeA2699,axiom,
    p__d__subclass(c__Pretending,c__SocialInteraction) ).

fof(mergeA2701,axiom,
    p__d__subclass(c__Communication,c__SocialInteraction) ).

fof(mergeA2702,axiom,
    p__d__subclass(c__Communication,c__ContentBearingProcess) ).

fof(mergeA2703,axiom,
    p__d__partition7(c__Communication,c__Stating,c__Supposing,c__Directing,c__Committing,c__Expressing,c__Declaring) ).

fof(mergeA2705,axiom,
    ! [COMMUNICATE] :
      ( p__d__instance(COMMUNICATE,c__Communication)
     => ? [PHYS,ENTITY,AGENT1,AGENT2] :
          ( p__refers(PHYS,ENTITY)
          & p__patient(COMMUNICATE,PHYS)
          & p__d__instance(AGENT1,c__CognitiveAgent)
          & p__agent(COMMUNICATE,AGENT1)
          & p__d__instance(AGENT2,c__CognitiveAgent)
          & p__destination(COMMUNICATE,AGENT2) ) ) ).

fof(mergeA2706,axiom,
    p__d__subclass(c__Disseminating,c__Communication) ).

fof(mergeA2707,axiom,
    ! [DISSEMINATE] :
      ( p__d__instance(DISSEMINATE,c__Disseminating)
     => ? [AGENT1,AGENT2] :
          ( p__destination(DISSEMINATE,AGENT1)
          & p__d__instance(AGENT1,c__CognitiveAgent)
          & p__destination(DISSEMINATE,AGENT2)
          & p__d__instance(AGENT2,c__CognitiveAgent)
          & AGENT1 != AGENT2 ) ) ).

fof(mergeA2708,axiom,
    p__d__subclass(c__Demonstrating,c__Disseminating) ).

fof(mergeA2709,axiom,
    ! [DEMO] :
      ( p__d__instance(DEMO,c__Demonstrating)
     => ? [PERSON] :
          ( p__d__instance(PERSON,c__Human)
          & p__attends(DEMO,PERSON) ) ) ).

fof(mergeA2710,axiom,
    p__subrelation(c__attends,c__experiencer) ).

fof(mergeA2713,axiom,
    p__d__subclass(c__Gesture,c__Communication) ).

fof(mergeA2714,axiom,
    p__d__subclass(c__Gesture,c__BodyMotion) ).

fof(mergeA2715,axiom,
    p__d__subclass(c__Advertising,c__Disseminating) ).

fof(mergeA2717,axiom,
    p__d__subclass(c__Expressing,c__Communication) ).

fof(mergeA2718,axiom,
    ! [AGENT,EXPRESS] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(EXPRESS,c__Expressing)
        & p__agent(EXPRESS,AGENT) )
     => ? [STATE] :
          ( p__d__instance(STATE,c__StateOfMind)
          & p__attribute(AGENT,STATE)
          & p__represents(EXPRESS,STATE) ) ) ).

fof(mergeA2719,axiom,
    p__d__subclass(c__LinguisticCommunication,c__Communication) ).

fof(mergeA2720,axiom,
    ! [COMMUNICATE] :
      ( p__d__instance(COMMUNICATE,c__LinguisticCommunication)
     => ? [OBJ] :
          ( p__represents(COMMUNICATE,OBJ)
          & p__d__instance(OBJ,c__LinguisticExpression)
          & p__patient(COMMUNICATE,OBJ) ) ) ).

fof(mergeA2721,axiom,
    p__d__subclass(c__Stating,c__LinguisticCommunication) ).

fof(mergeA2723,axiom,
    p__d__subclass(c__Disagreeing,c__Stating) ).

fof(mergeA2724,axiom,
    ! [DIS] :
      ( p__d__instance(DIS,c__Disagreeing)
     => ? [A1,A2,STATE1,STATE2,STMT1,STMT2] :
          ( p__d__instance(STATE1,c__Process)
          & p__d__instance(STATE1,c__ContentBearingPhysical)
          & p__d__instance(STATE2,c__Process)
          & p__d__instance(STATE2,c__ContentBearingPhysical)
          & p__d__instance(A1,c__Agent)
          & p__d__instance(A2,c__Agent)
          & p__d__instance(STMT1,c__Proposition)
          & p__d__instance(STMT2,c__Proposition)
          & p__subProcess(STATE1,DIS)
          & p__subProcess(STATE2,DIS)
          & p__agent(STATE1,A1)
          & p__agent(STATE2,A2)
          & p__containsInformation(STATE1,STMT1)
          & p__containsInformation(STATE2,STMT2)
          & ~ p__consistent(STMT1,STMT2) ) ) ).

fof(mergeA2725,axiom,
    p__d__subclass(c__Supposing,c__LinguisticCommunication) ).

fof(mergeA2726,axiom,
    p__d__subclass(c__Directing,c__LinguisticCommunication) ).

fof(mergeA2727,axiom,
    p__d__subclass(c__Ordering,c__Directing) ).

fof(mergeA2728,axiom,
    ! [ORDER,FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__d__instance(ORDER,c__Ordering)
        & p__patient(ORDER,FORMULA) )
     => p__modalAttribute(FORMULA,c__Obligation) ) ).

fof(mergeA2729,axiom,
    p__d__subclass(c__Requesting,c__Directing) ).

fof(mergeA2730,axiom,
    ! [REQUEST,AGENT,FORMULA] :
      ( ( p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(REQUEST,c__Requesting)
        & p__agent(REQUEST,AGENT)
        & p__patient(REQUEST,FORMULA)
        & p__d__instance(FORMULA,c__Formula) )
     => p__desires(AGENT,FORMULA) ) ).

fof(mergeA2731,axiom,
    p__d__subclass(c__Questioning,c__Directing) ).

fof(mergeA2733,axiom,
    p__d__subclass(c__Committing,c__LinguisticCommunication) ).

fof(mergeA2734,axiom,
    ! [COMMIT,FORMULA] :
      ( ( p__d__instance(COMMIT,c__Committing)
        & p__patient(COMMIT,FORMULA)
        & p__d__instance(FORMULA,c__Formula) )
     => p__modalAttribute(FORMULA,c__Promise) ) ).

fof(mergeA2735,axiom,
    p__d__subclass(c__Offering,c__Committing) ).

fof(mergeA2736,axiom,
    p__d__subclass(c__Declaring,c__LinguisticCommunication) ).

fof(mergeA2737,axiom,
    ! [DECLARE] :
      ( p__d__instance(DECLARE,c__Declaring)
     => ? [PROP,NORM] :
          ( p__d__instance(NORM,c__ObjectiveNorm)
          & p__d__instance(PROP,c__Formula)
          & ( p__confersNorm(DECLARE,PROP,NORM)
            | p__deprivesNorm(DECLARE,PROP,NORM) ) ) ) ).

fof(mergeA2738,axiom,
    p__d__subclass(c__Naming,c__Declaring) ).

fof(mergeA2740,axiom,
    p__d__subclass(c__Cooperation,c__SocialInteraction) ).

fof(mergeA2741,axiom,
    ! [COOPERATE] :
      ( p__d__instance(COOPERATE,c__Cooperation)
     => ? [PURP] :
          ( p__d__instance(PURP,c__Formula)
          & ! [AGENT] :
              ( ( p__d__instance(AGENT,c__CognitiveAgent)
                & p__agent(COOPERATE,AGENT) )
             => p__hasPurposeForAgent(COOPERATE,PURP,AGENT) ) ) ) ).

fof(mergeA2742,axiom,
    p__d__subclass(c__Meeting,c__SocialInteraction) ).

fof(mergeA2745,axiom,
    p__d__subclass(c__Contest,c__SocialInteraction) ).

fof(mergeA2746,axiom,
    ! [CONTEST] :
      ( p__d__instance(CONTEST,c__Contest)
     => ? [AGENT1,AGENT2,PURP1,PURP2] :
          ( p__d__instance(AGENT1,c__CognitiveAgent)
          & p__d__instance(AGENT2,c__CognitiveAgent)
          & p__d__instance(PURP1,c__Formula)
          & p__d__instance(PURP2,c__Formula)
          & p__agent(CONTEST,AGENT1)
          & p__agent(CONTEST,AGENT2)
          & p__hasPurposeForAgent(CONTEST,PURP1,AGENT1)
          & p__hasPurposeForAgent(CONTEST,PURP2,AGENT2)
          & AGENT1 != AGENT2
          & PURP1 != PURP2 ) ) ).

fof(mergeA2747,axiom,
    p__d__subclass(c__ViolentContest,c__Contest) ).

fof(mergeA2748,axiom,
    p__d__subclass(c__War,c__ViolentContest) ).

fof(mergeA2749,axiom,
    ! [WAR] :
      ( p__d__instance(WAR,c__War)
     => ? [BATTLE] :
          ( p__d__instance(BATTLE,c__Battle)
          & p__subProcess(BATTLE,WAR) ) ) ).

fof(mergeA2750,axiom,
    ! [WAR,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(AGENT,c__Collection)
        & p__d__instance(WAR,c__War)
        & p__agent(WAR,AGENT) )
     => ( p__d__instance(AGENT,c__GeopoliticalArea)
        | ( p__d__instance(AGENT,c__Organization)
          & ! [MEMBER] :
              ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
                & p__member(MEMBER,AGENT) )
             => p__d__instance(MEMBER,c__GeopoliticalArea) ) ) ) ) ).

fof(mergeA2751,axiom,
    p__d__subclass(c__Battle,c__ViolentContest) ).

fof(mergeA2752,axiom,
    ! [BATTLE] :
      ( p__d__instance(BATTLE,c__Battle)
     => ? [WAR] :
          ( p__d__instance(WAR,c__War)
          & p__subProcess(BATTLE,WAR) ) ) ).

fof(mergeA2753,axiom,
    ! [BATTLE] :
      ( p__d__instance(BATTLE,c__Battle)
     => ? [ATTACK] :
          ( p__d__instance(ATTACK,c__ViolentContest)
          & p__subProcess(ATTACK,BATTLE) ) ) ).

fof(mergeA2754,axiom,
    p__d__subclass(c__Game,c__Contest) ).

fof(mergeA2755,axiom,
    p__d__subclass(c__Game,c__RecreationOrExercise) ).

fof(mergeA2756,axiom,
    p__d__subclass(c__Sport,c__Game) ).

fof(mergeA2757,axiom,
    p__d__subclass(c__LegalAction,c__Contest) ).

fof(mergeA2758,axiom,
    p__d__subclass(c__Maneuver,c__IntentionalProcess) ).

fof(mergeA2759,axiom,
    ! [MOVE] :
      ( p__d__instance(MOVE,c__Maneuver)
     => ? [CONTEST] :
          ( p__d__instance(CONTEST,c__Contest)
          & p__subProcess(MOVE,CONTEST) ) ) ).

fof(mergeA2760,axiom,
    p__d__subclass(c__Attack,c__Maneuver) ).

fof(mergeA2761,axiom,
    ! [ATTACK] :
      ( p__d__instance(ATTACK,c__Attack)
     => ? [CONTEST] :
          ( p__d__instance(CONTEST,c__ViolentContest)
          & p__subProcess(ATTACK,CONTEST) ) ) ).

fof(mergeA2763,axiom,
    p__d__subclass(c__DefensiveManeuver,c__Maneuver) ).

fof(mergeA2764,axiom,
    ! [DEFENSE] :
      ( p__d__instance(DEFENSE,c__DefensiveManeuver)
     => ? [CONTEST] :
          ( p__d__instance(CONTEST,c__ViolentContest)
          & p__subProcess(DEFENSE,CONTEST) ) ) ).

fof(mergeA2766,axiom,
    ! [CONTEST,MANEUVER] :
      ( ( p__d__instance(MANEUVER,c__Maneuver)
        & p__d__instance(CONTEST,c__ViolentContest)
        & p__subProcess(MANEUVER,CONTEST) )
     => ( p__d__instance(MANEUVER,c__Attack)
        | p__d__instance(MANEUVER,c__DefensiveManeuver) ) ) ).

fof(mergeA2767,axiom,
    p__d__subclass(c__Perception,c__PsychologicalProcess) ).

fof(mergeA2768,axiom,
    ! [PERCEPT,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(PERCEPT,c__Perception)
        & p__agent(PERCEPT,AGENT) )
     => p__d__instance(AGENT,c__Animal) ) ).

fof(mergeA2769,axiom,
    ! [AGENT] :
      ( p__d__instance(AGENT,c__SentientAgent)
     => p__capability(c__Perception,c__experiencer,AGENT) ) ).

fof(mergeA2770,axiom,
    p__d__subclass(c__Seeing,c__Perception) ).

fof(mergeA2774,axiom,
    p__d__subclass(c__Looking,c__Seeing) ).

fof(mergeA2775,axiom,
    p__d__subclass(c__Looking,c__IntentionalProcess) ).

fof(mergeA2776,axiom,
    p__d__subclass(c__Smelling,c__Perception) ).

fof(mergeA2777,axiom,
    ! [SMELL,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(SMELL,c__Smelling)
        & p__patient(SMELL,OBJ) )
     => ? [ATTR] :
          ( p__d__instance(ATTR,c__OlfactoryAttribute)
          & p__attribute(OBJ,ATTR) ) ) ).

fof(mergeA2778,axiom,
    p__d__subclass(c__Tasting,c__Perception) ).

fof(mergeA2779,axiom,
    ! [TASTE,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(TASTE,c__Tasting)
        & p__patient(TASTE,OBJ) )
     => ? [ATTR] :
          ( p__d__instance(ATTR,c__TasteAttribute)
          & p__attribute(OBJ,ATTR) ) ) ).

fof(mergeA2780,axiom,
    p__d__subclass(c__Hearing,c__Perception) ).

fof(mergeA2781,axiom,
    ! [HEAR,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(HEAR,c__Hearing)
        & p__patient(HEAR,OBJ) )
     => ? [ATTR] :
          ( p__d__instance(ATTR,c__SoundAttribute)
          & p__attribute(OBJ,ATTR) ) ) ).

fof(mergeA2782,axiom,
    p__d__subclass(c__SoundAttribute,c__PerceptualAttribute) ).

fof(mergeA2783,axiom,
    p__d__instance(c__Audible,c__SoundAttribute) ).

fof(mergeA2785,axiom,
    p__d__subclass(c__Listening,c__Hearing) ).

fof(mergeA2786,axiom,
    p__d__subclass(c__Listening,c__IntentionalProcess) ).

fof(mergeA2787,axiom,
    p__d__subclass(c__TactilePerception,c__Perception) ).

fof(mergeA2788,axiom,
    ! [TACTILE] :
      ( p__d__instance(TACTILE,c__TactilePerception)
     => ? [TOUCH] :
          ( p__d__instance(TOUCH,c__Touching)
          & p__subProcess(TOUCH,TACTILE) ) ) ).

fof(mergeA2789,axiom,
    p__d__subclass(c__Radiating,c__Motion) ).

fof(mergeA2790,axiom,
    p__d__subclass(c__RadiatingLight,c__RadiatingElectromagnetic) ).

fof(mergeA2791,axiom,
    ! [REGION] :
      ( p__d__instance(REGION,c__Object)
     => ( ? [EMIT] :
            ( p__d__instance(EMIT,c__RadiatingLight)
            & p__patient(EMIT,REGION)
            & p__d__instance(REGION,c__Region) )
      <=> p__attribute(REGION,c__Illuminated) ) ) ).

fof(mergeA2792,axiom,
    p__d__subclass(c__RadiatingInfrared,c__RadiatingElectromagnetic) ).

fof(mergeA2793,axiom,
    p__d__subclass(c__RadiatingXRay,c__RadiatingElectromagnetic) ).

fof(mergeA2794,axiom,
    p__d__subclass(c__RadiatingSound,c__Radiating) ).

fof(mergeA2795,axiom,
    ! [EMIT,SOUND] :
      ( ( p__d__instance(SOUND,c__Agent)
        & p__d__instance(EMIT,c__RadiatingSound)
        & p__agent(EMIT,SOUND) )
     => ? [ATTR] :
          ( p__d__instance(ATTR,c__SoundAttribute)
          & p__attribute(SOUND,ATTR) ) ) ).

fof(mergeA2796,axiom,
    p__d__subclass(c__MakingMusic,c__RadiatingSound) ).

fof(mergeA2797,axiom,
    p__d__partition3(c__MakingMusic,c__MakingInstrumentalMusic,c__MakingVocalMusic) ).

fof(mergeA2798,axiom,
    p__d__subclass(c__MakingInstrumentalMusic,c__MakingMusic) ).

fof(mergeA2799,axiom,
    ! [M] :
      ( p__d__instance(M,c__MakingInstrumentalMusic)
     => ? [I] :
          ( p__d__instance(I,c__MusicalInstrument)
          & p__instrument(M,I) ) ) ).

fof(mergeA2800,axiom,
    p__d__subclass(c__MakingVocalMusic,c__MakingMusic) ).

fof(mergeA2801,axiom,
    p__d__subclass(c__MakingVocalMusic,c__Vocalizing) ).

fof(mergeA2802,axiom,
    p__d__subclass(c__Singing,c__MakingVocalMusic) ).

fof(mergeA2803,axiom,
    ! [S] :
      ( p__d__instance(S,c__Singing)
     => ? [W] :
          ( p__patient(S,W)
          & p__d__instance(W,c__Word) ) ) ).

fof(mergeA2804,axiom,
    p__d__subclass(c__RadiatingElectromagnetic,c__Radiating) ).

fof(mergeA2805,axiom,
    p__d__subclass(c__RadiatingNuclear,c__Radiating) ).

fof(mergeA2806,axiom,
    p__d__subclass(c__StateChange,c__InternalChange) ).

fof(mergeA2808,axiom,
    p__d__instance(c__atomicNumber,c__BinaryPredicate) ).

fof(mergeA2809,axiom,
    p__d__instance(c__atomicNumber,c__AsymmetricRelation) ).

fof(mergeA2813,axiom,
    p__d__instance(c__boilingPoint,c__BinaryPredicate) ).

fof(mergeA2819,axiom,
    p__d__instance(c__meltingPoint,c__BinaryPredicate) ).

fof(mergeA2824,axiom,
    ! [TYPE,BOIL,MELT] :
      ( ( p__d__instance(MELT,c__TemperatureMeasure)
        & p__d__subclass(TYPE,c__PureSubstance)
        & p__d__instance(BOIL,c__TemperatureMeasure)
        & p__meltingPoint(TYPE,MELT)
        & p__boilingPoint(TYPE,BOIL) )
     => p__greaterThanOrEqualTo(BOIL,MELT) ) ).

fof(mergeA2825,axiom,
    p__d__subclass(c__Melting,c__StateChange) ).

fof(mergeA2826,axiom,
    ! [MELT] :
      ( p__d__instance(MELT,c__Melting)
     => ? [HEAT] :
          ( p__d__instance(HEAT,c__Heating)
          & p__subProcess(HEAT,MELT) ) ) ).

fof(mergeA2828,axiom,
    p__d__subclass(c__Boiling,c__StateChange) ).

fof(mergeA2829,axiom,
    ! [BOIL] :
      ( p__d__instance(BOIL,c__Boiling)
     => ? [HEAT] :
          ( p__d__instance(HEAT,c__Heating)
          & p__subProcess(HEAT,BOIL) ) ) ).

fof(mergeA2831,axiom,
    p__d__subclass(c__Evaporating,c__StateChange) ).

fof(mergeA2833,axiom,
    p__d__subclass(c__Condensing,c__StateChange) ).

fof(mergeA2834,axiom,
    ! [COND] :
      ( p__d__instance(COND,c__Condensing)
     => ? [COOL] :
          ( p__d__instance(COOL,c__Cooling)
          & p__subProcess(COOL,COND) ) ) ).

fof(mergeA2836,axiom,
    p__d__subclass(c__Freezing,c__StateChange) ).

fof(mergeA2837,axiom,
    ! [FREEZE] :
      ( p__d__instance(FREEZE,c__Freezing)
     => ? [COOL] :
          ( p__d__instance(COOL,c__Cooling)
          & p__subProcess(COOL,FREEZE) ) ) ).

fof(mergeA2839,axiom,
    p__d__subclass(c__AstronomicalBody,c__Object) ).

fof(mergeA2840,axiom,
    p__d__disjoint(c__AstronomicalBody,c__GeographicArea) ).

fof(mergeA2841,axiom,
    p__d__subclass(c__GeographicArea,c__Region) ).

fof(mergeA2842,axiom,
    p__d__partition3(c__GeographicArea,c__WaterArea,c__LandArea) ).

fof(mergeA2843,axiom,
    p__d__subclass(c__LocalizablePlace,c__GeographicArea) ).

fof(mergeA2844,axiom,
    p__d__instance(c__geographicSubregion,c__BinaryPredicate) ).

fof(mergeA2845,axiom,
    p__d__instance(c__geographicSubregion,c__TransitiveRelation) ).

fof(mergeA2846,axiom,
    p__d__instance(c__geographicSubregion,c__AsymmetricRelation) ).

fof(mergeA2847,axiom,
    p__subrelation(c__geographicSubregion,c__properPart) ).

fof(mergeA2848,axiom,
    p__subrelation(c__geographicSubregion,c__located) ).

fof(mergeA2851,axiom,
    p__d__subclass(c__GeopoliticalArea,c__GeographicArea) ).

fof(mergeA2852,axiom,
    p__d__subclass(c__GeopoliticalArea,c__Agent) ).

fof(mergeA2853,axiom,
    ! [AREA,PERSON] :
      ( ( p__d__instance(PERSON,c__Human)
        & p__d__instance(AREA,c__GeopoliticalArea)
        & p__leader(f__GovernmentFn1(AREA),PERSON) )
     => p__leader(AREA,PERSON) ) ).

fof(mergeA2854,axiom,
    ! [AREA,PERSON] :
      ( ( p__d__instance(PERSON,c__Human)
        & p__d__instance(AREA,c__GeopoliticalArea)
        & p__leader(AREA,PERSON) )
     => p__leader(f__GovernmentFn1(AREA),PERSON) ) ).

fof(mergeA2855,axiom,
    ! [AGENT,EVENT] :
      ( ( p__d__instance(EVENT,c__Election)
        & p__agent(EVENT,AGENT)
        & p__d__instance(AGENT,c__GeopoliticalArea) )
     => p__d__instance(EVENT,c__PoliticalProcess) ) ).

fof(mergeA2857,axiom,
    p__d__instance(c__geopoliticalSubdivision,c__AsymmetricRelation) ).

fof(mergeA2858,axiom,
    p__d__instance(c__geopoliticalSubdivision,c__TransitiveRelation) ).

fof(mergeA2859,axiom,
    p__subrelation(c__geopoliticalSubdivision,c__geographicSubregion) ).

fof(mergeA2862,axiom,
    p__d__subclass(c__WaterArea,c__GeographicArea) ).

fof(mergeA2863,axiom,
    ! [AREA] :
      ( p__d__instance(AREA,c__WaterArea)
     => ? [BED,HOLE,WATER] :
          ( p__d__instance(HOLE,c__Hole)
          & p__d__instance(BED,c__Object)
          & f__HoleHostFn1(HOLE) = BED
          & p__d__instance(WATER,c__Water)
          & p__properlyFills(WATER,HOLE)
          & f__MereologicalSumFn2(BED,WATER) = AREA ) ) ).

fof(mergeA2864,axiom,
    p__d__subclass(c__SaltWaterArea,c__WaterArea) ).

fof(mergeA2865,axiom,
    p__d__disjoint(c__SaltWaterArea,c__FreshWaterArea) ).

fof(mergeA2866,axiom,
    p__d__subclass(c__FreshWaterArea,c__WaterArea) ).

fof(mergeA2867,axiom,
    p__d__subclass(c__LandArea,c__GeographicArea) ).

fof(mergeA2868,axiom,
    ! [LAND1] :
      ( p__d__instance(LAND1,c__LandArea)
     => ? [LAND2] :
          ( p__d__instance(LAND2,c__Object)
          & p__part(LAND1,LAND2)
          & ( p__d__instance(LAND2,c__Continent)
            | p__d__instance(LAND2,c__Island) ) ) ) ).

fof(mergeA2869,axiom,
    p__d__subclass(c__ShoreArea,c__LandArea) ).

fof(mergeA2870,axiom,
    ! [BANK] :
      ( p__d__instance(BANK,c__ShoreArea)
     => ? [WATER] :
          ( p__d__instance(WATER,c__WaterArea)
          & p__meetsSpatially(BANK,WATER) ) ) ).

fof(mergeA2871,axiom,
    p__d__subclass(c__Continent,c__LandArea) ).

fof(mergeA2872,axiom,
    f__CardinalityFn1(c__Continent) = c__7 ).

fof(mergeA2873,axiom,
    p__d__subclass(c__Island,c__LandArea) ).

fof(mergeA2874,axiom,
    ! [ISLAND] :
      ( p__d__instance(ISLAND,c__Island)
     => ! [AREA,PART1,PART2] :
          ( ~ p__d__instance(AREA,c__Object)
          | ~ p__d__instance(PART1,c__Object)
          | ~ p__d__instance(PART2,c__Object)
          | ~ p__d__instance(AREA,c__LandArea)
          | ~ p__part(PART1,ISLAND)
          | ~ p__part(PART2,AREA)
          | p__part(ISLAND,AREA)
          | p__part(AREA,ISLAND)
          | ~ p__meetsSpatially(PART1,PART2) ) ) ).

fof(mergeA2875,axiom,
    ! [ISLE,AREA] :
      ( ( p__d__instance(ISLE,c__Island)
        & p__d__instance(AREA,c__GeographicArea)
        & p__meetsSpatially(ISLE,AREA) )
     => ~ p__d__instance(AREA,c__LandArea) ) ).

fof(mergeA2876,axiom,
    ! [ISLE] :
      ( p__d__instance(ISLE,c__Island)
     => ? [WATER] :
          ( p__d__instance(WATER,c__WaterArea)
          & p__meetsSpatially(ISLE,WATER) ) ) ).

fof(mergeA2877,axiom,
    p__d__subclass(c__Nation,c__GeopoliticalArea) ).

fof(mergeA2878,axiom,
    p__d__subclass(c__Nation,c__LandArea) ).

fof(mergeA2879,axiom,
    p__d__subclass(c__StateOrProvince,c__GeopoliticalArea) ).

fof(mergeA2880,axiom,
    p__d__subclass(c__StateOrProvince,c__LandArea) ).

fof(mergeA2881,axiom,
    ! [STATE] :
      ( p__d__instance(STATE,c__StateOrProvince)
     => ? [LAND] :
          ( p__d__instance(LAND,c__Nation)
          & p__properPart(STATE,LAND) ) ) ).

fof(mergeA2882,axiom,
    p__d__subclass(c__City,c__GeopoliticalArea) ).

fof(mergeA2883,axiom,
    p__d__subclass(c__City,c__LandArea) ).

fof(mergeA2884,axiom,
    p__d__subclass(c__County,c__GeopoliticalArea) ).

fof(mergeA2885,axiom,
    p__d__subclass(c__County,c__LandArea) ).

fof(mergeA2886,axiom,
    ! [STATE] :
      ( p__d__instance(STATE,c__County)
     => ? [LAND] :
          ( p__d__instance(LAND,c__StateOrProvince)
          & p__properPart(STATE,LAND) ) ) ).

fof(mergeA2887,axiom,
    p__d__subclass(c__Transitway,c__Region) ).

fof(mergeA2888,axiom,
    p__d__subclass(c__Transitway,c__SelfConnectedObject) ).

fof(mergeA2889,axiom,
    p__d__subclass(c__LandTransitway,c__Transitway) ).

fof(mergeA2890,axiom,
    p__d__subclass(c__LandTransitway,c__LandArea) ).

fof(mergeA2892,axiom,
    p__d__subclass(c__Roadway,c__LandTransitway) ).

fof(mergeA2893,axiom,
    p__d__subclass(c__Water,c__CompoundSubstance) ).

fof(mergeA2894,axiom,
    p__d__subclass(c__Mineral,c__Substance) ).

fof(mergeA2895,axiom,
    p__d__instance(c__developmentalForm,c__BinaryPredicate) ).

fof(mergeA2896,axiom,
    p__d__instance(c__developmentalForm,c__AsymmetricRelation) ).

fof(mergeA2897,axiom,
    p__d__instance(c__developmentalForm,c__TransitiveRelation) ).

fof(mergeA2898,axiom,
    p__subrelation(c__developmentalForm,c__attribute) ).

fof(mergeA2902,axiom,
    p__d__subclass(c__OrganicObject,c__CorpuscularObject) ).

fof(mergeA2903,axiom,
    p__d__subclass(c__OrganicObject,c__OrganicThing) ).

fof(mergeA2904,axiom,
    p__d__partition3(c__OrganicObject,c__Organism,c__AnatomicalStructure) ).

fof(mergeA2905,axiom,
    p__d__subclass(c__Organism,c__OrganicObject) ).

fof(mergeA2906,axiom,
    p__d__subclass(c__Organism,c__Agent) ).

fof(mergeA2907,axiom,
    p__d__disjoint(c__Organism,c__Artifact) ).

fof(mergeA2908,axiom,
    p__d__partition4(c__Organism,c__Animal,c__Plant,c__Microorganism) ).

fof(mergeA2909,axiom,
    ! [ORGANISM] :
      ( p__d__instance(ORGANISM,c__Organism)
     => ? [BIRTH] :
          ( p__d__instance(BIRTH,c__Birth)
          & p__experiencer(BIRTH,ORGANISM) ) ) ).

fof(mergeA2910,axiom,
    p__d__instance(c__inhabits,c__BinaryPredicate) ).

fof(mergeA2911,axiom,
    p__d__instance(c__inhabits,c__AsymmetricRelation) ).

fof(mergeA2915,axiom,
    p__subrelation(c__home,c__inhabits) ).

fof(mergeA2918,axiom,
    p__subrelation(c__stays,c__inhabits) ).

fof(mergeA2919,axiom,
    p__disjointRelation(c__stays,c__home) ).

fof(mergeA2922,axiom,
    p__d__subclass(c__Plant,c__Organism) ).

fof(mergeA2923,axiom,
    p__d__subclass(c__FloweringPlant,c__Plant) ).

fof(mergeA2924,axiom,
    p__d__subclass(c__NonFloweringPlant,c__Plant) ).

fof(mergeA2925,axiom,
    p__d__disjoint(c__NonFloweringPlant,c__FloweringPlant) ).

fof(mergeA2926,axiom,
    p__d__disjointDecomposition4(c__NonFloweringPlant,c__Alga,c__Fern,c__Moss) ).

fof(mergeA2927,axiom,
    p__d__subclass(c__Alga,c__NonFloweringPlant) ).

fof(mergeA2928,axiom,
    ! [ALGA] :
      ( p__d__instance(ALGA,c__Alga)
     => ? [WATER] :
          ( p__inhabits(ALGA,WATER)
          & p__d__instance(WATER,c__Water) ) ) ).

fof(mergeA2929,axiom,
    p__d__subclass(c__Fungus,c__Organism) ).

fof(mergeA2930,axiom,
    ! [FUNGUS,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(FUNGUS,c__Fungus)
        & p__inhabits(FUNGUS,OBJ) )
     => p__d__instance(OBJ,c__Organism) ) ).

fof(mergeA2931,axiom,
    p__d__subclass(c__Moss,c__NonFloweringPlant) ).

fof(mergeA2932,axiom,
    p__d__subclass(c__Fern,c__NonFloweringPlant) ).

fof(mergeA2933,axiom,
    p__d__subclass(c__Animal,c__Organism) ).

fof(mergeA2934,axiom,
    p__d__partition3(c__Animal,c__Vertebrate,c__Invertebrate) ).

fof(mergeA2935,axiom,
    p__d__subclass(c__Microorganism,c__Organism) ).

fof(mergeA2936,axiom,
    p__d__subclass(c__Bacterium,c__Microorganism) ).

fof(mergeA2937,axiom,
    ! [BACTERIUM] :
      ( p__d__instance(BACTERIUM,c__Bacterium)
     => ? [CELL1] :
          ( p__component(CELL1,BACTERIUM)
          & p__d__instance(CELL1,c__Cell)
          & ! [CELL2] :
              ( ( p__component(CELL2,BACTERIUM)
                & p__d__instance(CELL2,c__Cell) )
             => CELL1 = CELL2 ) ) ) ).

fof(mergeA2938,axiom,
    ! [BACTERIUM,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(BACTERIUM,c__Bacterium)
        & p__inhabits(BACTERIUM,OBJ) )
     => p__d__instance(OBJ,c__Organism) ) ).

fof(mergeA2939,axiom,
    p__d__subclass(c__Virus,c__Microorganism) ).

fof(mergeA2940,axiom,
    ! [VIRUS,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(VIRUS,c__Virus)
        & p__inhabits(VIRUS,OBJ) )
     => p__d__instance(OBJ,c__Organism) ) ).

fof(mergeA2941,axiom,
    ! [VIRUS,PROC] :
      ( ( p__d__instance(VIRUS,c__Virus)
        & p__d__instance(PROC,c__Replication)
        & p__agent(PROC,VIRUS) )
     => ? [CELL] :
          ( p__located(PROC,CELL)
          & p__d__instance(CELL,c__Cell) ) ) ).

fof(mergeA2942,axiom,
    p__d__subclass(c__Vertebrate,c__Animal) ).

fof(mergeA2943,axiom,
    p__d__subclass(c__Invertebrate,c__Animal) ).

fof(mergeA2944,axiom,
    p__d__disjointDecomposition4(c__Invertebrate,c__Worm,c__Mollusk,c__Arthropod) ).

fof(mergeA2945,axiom,
    p__d__subclass(c__Worm,c__Invertebrate) ).

fof(mergeA2946,axiom,
    p__d__subclass(c__Mollusk,c__Invertebrate) ).

fof(mergeA2947,axiom,
    p__d__subclass(c__Arthropod,c__Invertebrate) ).

fof(mergeA2948,axiom,
    p__d__disjointDecomposition5(c__Arthropod,c__Arachnid,c__Myriapod,c__Insect,c__Crustacean) ).

fof(mergeA2949,axiom,
    p__d__subclass(c__Arachnid,c__Arthropod) ).

fof(mergeA2950,axiom,
    p__d__subclass(c__Myriapod,c__Arthropod) ).

fof(mergeA2951,axiom,
    p__d__subclass(c__Insect,c__Arthropod) ).

fof(mergeA2952,axiom,
    p__d__subclass(c__Crustacean,c__Arthropod) ).

fof(mergeA2953,axiom,
    p__d__subclass(c__ColdBloodedVertebrate,c__Vertebrate) ).

fof(mergeA2954,axiom,
    p__d__disjointDecomposition4(c__ColdBloodedVertebrate,c__Amphibian,c__Fish,c__Reptile) ).

fof(mergeA2955,axiom,
    p__d__subclass(c__WarmBloodedVertebrate,c__Vertebrate) ).

fof(mergeA2956,axiom,
    p__d__disjoint(c__WarmBloodedVertebrate,c__ColdBloodedVertebrate) ).

fof(mergeA2957,axiom,
    p__d__subclass(c__Amphibian,c__ColdBloodedVertebrate) ).

fof(mergeA2958,axiom,
    p__d__subclass(c__Bird,c__WarmBloodedVertebrate) ).

fof(mergeA2959,axiom,
    p__d__disjoint(c__Bird,c__Mammal) ).

fof(mergeA2960,axiom,
    p__d__subclass(c__Fish,c__ColdBloodedVertebrate) ).

fof(mergeA2961,axiom,
    ! [FISH] :
      ( p__d__instance(FISH,c__Fish)
     => ? [WATER] :
          ( p__inhabits(FISH,WATER)
          & p__d__instance(WATER,c__Water) ) ) ).

fof(mergeA2962,axiom,
    p__d__subclass(c__Mammal,c__WarmBloodedVertebrate) ).

fof(mergeA2963,axiom,
    p__d__disjointDecomposition6(c__Mammal,c__AquaticMammal,c__HoofedMammal,c__Marsupial,c__Rodent,c__Primate) ).

fof(mergeA2964,axiom,
    p__d__subclass(c__AquaticMammal,c__Mammal) ).

fof(mergeA2965,axiom,
    p__d__subclass(c__HoofedMammal,c__Mammal) ).

fof(mergeA2966,axiom,
    p__d__subclass(c__Marsupial,c__Mammal) ).

fof(mergeA2967,axiom,
    p__d__subclass(c__Carnivore,c__Mammal) ).

fof(mergeA2968,axiom,
    ! [CARNIVORE,EAT,PREY] :
      ( ( p__d__instance(CARNIVORE,c__Carnivore)
        & p__d__instance(EAT,c__Eating)
        & p__agent(EAT,CARNIVORE)
        & p__patient(EAT,PREY) )
     => p__d__instance(PREY,c__Animal) ) ).

fof(mergeA2969,axiom,
    p__d__subclass(c__Canine,c__Carnivore) ).

fof(mergeA2970,axiom,
    p__d__disjoint(c__Canine,c__Feline) ).

fof(mergeA2971,axiom,
    p__d__subclass(c__Feline,c__Carnivore) ).

fof(mergeA2972,axiom,
    p__d__subclass(c__Rodent,c__Mammal) ).

fof(mergeA2973,axiom,
    p__d__subclass(c__Primate,c__Mammal) ).

fof(mergeA2974,axiom,
    p__d__disjointDecomposition4(c__Primate,c__Ape,c__Monkey,c__Hominid) ).

fof(mergeA2975,axiom,
    p__d__subclass(c__Ape,c__Primate) ).

fof(mergeA2976,axiom,
    p__d__subclass(c__Monkey,c__Primate) ).

fof(mergeA2977,axiom,
    p__d__subclass(c__Hominid,c__Primate) ).

fof(mergeA2978,axiom,
    p__d__subclass(c__Human,c__Hominid) ).

fof(mergeA2979,axiom,
    p__d__subclass(c__Human,c__CognitiveAgent) ).

fof(mergeA2980,axiom,
    p__d__partition3(c__Human,c__Man,c__Woman) ).

fof(mergeA2981,axiom,
    p__d__subclass(c__Man,c__Human) ).

fof(mergeA2982,axiom,
    ! [MAN] :
      ( p__d__instance(MAN,c__Man)
     => p__attribute(MAN,c__Male) ) ).

fof(mergeA2983,axiom,
    p__d__subclass(c__Woman,c__Human) ).

fof(mergeA2984,axiom,
    ! [WOMAN] :
      ( p__d__instance(WOMAN,c__Woman)
     => p__attribute(WOMAN,c__Female) ) ).

fof(mergeA2985,axiom,
    p__d__subclass(c__Reptile,c__ColdBloodedVertebrate) ).

fof(mergeA2986,axiom,
    p__d__subclass(c__BiologicallyActiveSubstance,c__Substance) ).

fof(mergeA2987,axiom,
    p__d__subclass(c__Nutrient,c__BiologicallyActiveSubstance) ).

fof(mergeA2988,axiom,
    p__d__disjointDecomposition4(c__Nutrient,c__Protein,c__Carbohydrate,c__Vitamin) ).

fof(mergeA2989,axiom,
    p__d__subclass(c__Protein,c__Nutrient) ).

fof(mergeA2990,axiom,
    p__d__subclass(c__Enzyme,c__Protein) ).

fof(mergeA2991,axiom,
    p__d__subclass(c__Carbohydrate,c__Nutrient) ).

fof(mergeA2992,axiom,
    p__d__subclass(c__Vitamin,c__Nutrient) ).

fof(mergeA2993,axiom,
    p__d__subclass(c__LiquidMixture,c__Mixture) ).

fof(mergeA2994,axiom,
    p__d__partition3(c__LiquidMixture,c__Solution,c__Suspension) ).

fof(mergeA2995,axiom,
    ! [MIX] :
      ( p__d__instance(MIX,c__LiquidMixture)
     => ? [PART] :
          ( p__d__instance(PART,c__Object)
          & p__part(PART,MIX)
          & p__attribute(PART,c__Liquid) ) ) ).

fof(mergeA2996,axiom,
    p__d__subclass(c__Solution,c__LiquidMixture) ).

fof(mergeA2997,axiom,
    p__d__subclass(c__Suspension,c__LiquidMixture) ).

fof(mergeA2998,axiom,
    p__d__subclass(c__GasMixture,c__Mixture) ).

fof(mergeA2999,axiom,
    p__d__disjoint(c__GasMixture,c__LiquidMixture) ).

fof(mergeA3000,axiom,
    ! [MIX] :
      ( p__d__instance(MIX,c__GasMixture)
     => ? [PART] :
          ( p__d__instance(PART,c__Object)
          & p__part(PART,MIX)
          & p__attribute(PART,c__Gas) ) ) ).

fof(mergeA3001,axiom,
    p__d__subclass(c__Cloud,c__GasMixture) ).

fof(mergeA3002,axiom,
    ! [CLOUD] :
      ( p__d__instance(CLOUD,c__Cloud)
     => p__capability(c__Seeing,c__patient,CLOUD) ) ).

fof(mergeA3003,axiom,
    p__d__subclass(c__Smoke,c__Cloud) ).

fof(mergeA3004,axiom,
    p__d__subclass(c__WaterCloud,c__Cloud) ).

fof(mergeA3005,axiom,
    ! [CLOUD] :
      ( p__d__instance(CLOUD,c__WaterCloud)
     => ? [WATER] :
          ( p__d__instance(WATER,c__Water)
          & p__part(WATER,CLOUD) ) ) ).

fof(mergeA3006,axiom,
    ! [CLOUD,PART] :
      ( ( p__d__instance(PART,c__Object)
        & p__d__instance(CLOUD,c__WaterCloud)
        & p__part(PART,CLOUD)
        & ~ p__d__instance(PART,c__Water) )
     => ? [WATER,MEASURE1,MEASURE2] :
          ( p__d__instance(MEASURE1,c__PhysicalQuantity)
          & p__d__instance(MEASURE2,c__PhysicalQuantity)
          & p__d__instance(WATER,c__Water)
          & p__part(WATER,CLOUD)
          & p__measure(WATER,MEASURE1)
          & p__measure(PART,MEASURE2)
          & p__greaterThan(MEASURE1,MEASURE2) ) ) ).

fof(mergeA3007,axiom,
    p__d__subclass(c__Air,c__GasMixture) ).

fof(mergeA3008,axiom,
    ! [WIND] :
      ( p__d__instance(WIND,c__Wind)
     => ? [AIR] :
          ( p__patient(WIND,AIR)
          & p__d__instance(AIR,c__Air) ) ) ).

fof(mergeA3009,axiom,
    p__d__subclass(c__BodySubstance,c__Substance) ).

fof(mergeA3010,axiom,
    p__d__subclass(c__AnimalSubstance,c__BodySubstance) ).

fof(mergeA3011,axiom,
    ! [SUBSTANCE,ANIMAL] :
      ( ( p__d__instance(SUBSTANCE,c__AnimalSubstance)
        & p__d__instance(ANIMAL,c__Organism)
        & p__part(SUBSTANCE,ANIMAL) )
     => p__d__instance(ANIMAL,c__Animal) ) ).

fof(mergeA3012,axiom,
    p__d__subclass(c__PlantSubstance,c__BodySubstance) ).

fof(mergeA3013,axiom,
    ! [SUBSTANCE,PLANT] :
      ( ( p__d__instance(SUBSTANCE,c__PlantSubstance)
        & p__d__instance(PLANT,c__Organism)
        & p__part(SUBSTANCE,PLANT) )
     => p__d__instance(PLANT,c__Plant) ) ).

fof(mergeA3014,axiom,
    p__d__subclass(c__Hormone,c__BodySubstance) ).

fof(mergeA3015,axiom,
    p__d__subclass(c__Hormone,c__BiologicallyActiveSubstance) ).

fof(mergeA3016,axiom,
    ! [HORMONE] :
      ( p__d__instance(HORMONE,c__Hormone)
     => ? [PROCESS,GLAND] :
          ( p__d__instance(PROCESS,c__Process)
          & p__d__instance(GLAND,c__Gland)
          & p__instrument(PROCESS,GLAND)
          & p__result(PROCESS,HORMONE) ) ) ).

fof(mergeA3017,axiom,
    p__d__subclass(c__Blood,c__BodySubstance) ).

fof(mergeA3018,axiom,
    p__d__instance(c__FoodForFn,c__UnaryFunction) ).

fof(mergeA3022,axiom,
    p__d__subclass(c__Meat,c__SelfConnectedObject) ).

fof(mergeA3024,axiom,
    p__d__subclass(c__AnatomicalStructure,c__OrganicObject) ).

fof(mergeA3025,axiom,
    p__d__partition3(c__AnatomicalStructure,c__BodyPart,c__AbnormalAnatomicalStructure) ).

fof(mergeA3026,axiom,
    p__d__partition3(c__AnatomicalStructure,c__AnimalAnatomicalStructure,c__PlantAnatomicalStructure) ).

fof(mergeA3028,axiom,
    ! [PART] :
      ( p__d__instance(PART,c__AnatomicalStructure)
     => ? [CELL] :
          ( p__d__instance(CELL,c__Cell)
          & p__part(CELL,PART) ) ) ).

fof(mergeA3029,axiom,
    p__d__subclass(c__AbnormalAnatomicalStructure,c__AnatomicalStructure) ).

fof(mergeA3030,axiom,
    ! [STRUCTURE] :
      ( p__d__instance(STRUCTURE,c__AbnormalAnatomicalStructure)
     => ? [PROC] :
          ( p__d__instance(PROC,c__PathologicProcess)
          & p__result(PROC,STRUCTURE) ) ) ).

fof(mergeA3031,axiom,
    p__d__subclass(c__BodyPart,c__AnatomicalStructure) ).

fof(mergeA3033,axiom,
    ! [PART] :
      ( p__d__instance(PART,c__BodyPart)
     => ? [PROC] :
          ( p__d__instance(PROC,c__PhysiologicProcess)
          & p__result(PROC,PART) ) ) ).

fof(mergeA3034,axiom,
    p__d__subclass(c__AnimalAnatomicalStructure,c__AnatomicalStructure) ).

fof(mergeA3035,axiom,
    ! [STRUCTURE,ANIMAL] :
      ( ( p__d__instance(ANIMAL,c__Object)
        & p__d__instance(STRUCTURE,c__AnimalAnatomicalStructure)
        & p__properPart(STRUCTURE,ANIMAL) )
     => p__d__instance(ANIMAL,c__Animal) ) ).

fof(mergeA3036,axiom,
    p__d__subclass(c__PlantAnatomicalStructure,c__AnatomicalStructure) ).

fof(mergeA3037,axiom,
    ! [STRUCTURE,PLANT] :
      ( ( p__d__instance(PLANT,c__Object)
        & p__d__instance(STRUCTURE,c__PlantAnatomicalStructure)
        & p__properPart(STRUCTURE,PLANT) )
     => p__d__instance(PLANT,c__Plant) ) ).

fof(mergeA3038,axiom,
    p__d__subclass(c__ReproductiveBody,c__BodyPart) ).

fof(mergeA3039,axiom,
    p__d__subclass(c__Egg,c__ReproductiveBody) ).

fof(mergeA3040,axiom,
    p__d__subclass(c__Egg,c__AnimalAnatomicalStructure) ).

fof(mergeA3041,axiom,
    p__d__subclass(c__Seed,c__ReproductiveBody) ).

fof(mergeA3042,axiom,
    p__d__subclass(c__Seed,c__PlantAnatomicalStructure) ).

fof(mergeA3044,axiom,
    p__d__subclass(c__Pollen,c__ReproductiveBody) ).

fof(mergeA3045,axiom,
    p__d__subclass(c__Pollen,c__PlantAnatomicalStructure) ).

fof(mergeA3046,axiom,
    p__d__subclass(c__FruitOrVegetable,c__PlantAnatomicalStructure) ).

fof(mergeA3047,axiom,
    p__d__subclass(c__FruitOrVegetable,c__ReproductiveBody) ).

fof(mergeA3048,axiom,
    p__d__subclass(c__Spore,c__ReproductiveBody) ).

fof(mergeA3049,axiom,
    p__d__subclass(c__Spore,c__PlantAnatomicalStructure) ).

fof(mergeA3051,axiom,
    p__d__subclass(c__BodyCovering,c__BodyPart) ).

fof(mergeA3052,axiom,
    ! [COVER] :
      ( p__d__instance(COVER,c__BodyCovering)
     => ? [BODY] :
          ( p__d__instance(BODY,c__Object)
          & p__superficialPart(COVER,BODY)
          & ( p__d__instance(BODY,c__Organism)
            | p__d__instance(BODY,c__BodyPart) ) ) ) ).

fof(mergeA3053,axiom,
    p__d__subclass(c__BodyJunction,c__BodyPart) ).

fof(mergeA3054,axiom,
    ! [JUNCT] :
      ( p__d__instance(JUNCT,c__BodyJunction)
     => ? [OBJ1,OBJ2] :
          ( p__d__instance(OBJ1,c__BodyPart)
          & p__d__instance(OBJ2,c__BodyPart)
          & p__connects(JUNCT,OBJ1,OBJ2) ) ) ).

fof(mergeA3055,axiom,
    p__d__subclass(c__BodyCavity,c__BodyPart) ).

fof(mergeA3056,axiom,
    p__d__subclass(c__BodyVessel,c__BodyCavity) ).

fof(mergeA3057,axiom,
    p__d__subclass(c__Cell,c__BodyPart) ).

fof(mergeA3058,axiom,
    p__d__subclass(c__Organ,c__BodyPart) ).

fof(mergeA3059,axiom,
    ! [ORGAN] :
      ( p__d__instance(ORGAN,c__Organ)
     => ? [PURP] :
          ( p__d__instance(PURP,c__Formula)
          & p__hasPurpose(ORGAN,PURP) ) ) ).

fof(mergeA3060,axiom,
    p__d__subclass(c__Gland,c__Organ) ).

fof(mergeA3061,axiom,
    p__d__subclass(c__Tissue,c__BodySubstance) ).

fof(mergeA3062,axiom,
    p__d__disjointDecomposition4(c__Tissue,c__Bone,c__Muscle,c__FatTissue) ).

fof(mergeA3063,axiom,
    ! [STUFF] :
      ( p__d__instance(STUFF,c__Tissue)
     => ? [ORGANISM] :
          ( p__d__instance(ORGANISM,c__Organism)
          & p__part(STUFF,ORGANISM) ) ) ).

fof(mergeA3064,axiom,
    p__d__subclass(c__Bone,c__Tissue) ).

fof(mergeA3065,axiom,
    p__d__subclass(c__Bone,c__AnimalSubstance) ).

fof(mergeA3066,axiom,
    ! [BONE] :
      ( p__d__instance(BONE,c__Bone)
     => ? [VERT] :
          ( p__d__instance(VERT,c__Vertebrate)
          & p__properPart(BONE,VERT) ) ) ).

fof(mergeA3067,axiom,
    p__d__subclass(c__Muscle,c__Tissue) ).

fof(mergeA3068,axiom,
    p__d__subclass(c__Muscle,c__AnimalSubstance) ).

fof(mergeA3069,axiom,
    p__d__subclass(c__FatTissue,c__Tissue) ).

fof(mergeA3070,axiom,
    p__d__subclass(c__Noun,c__Word) ).

fof(mergeA3071,axiom,
    p__d__partition6(c__Word,c__Noun,c__Verb,c__Adjective,c__Adverb,c__ParticleWord) ).

fof(mergeA3072,axiom,
    p__d__subclass(c__Verb,c__Word) ).

fof(mergeA3073,axiom,
    p__d__subclass(c__Adjective,c__Word) ).

fof(mergeA3074,axiom,
    p__d__subclass(c__Adverb,c__Word) ).

fof(mergeA3075,axiom,
    p__d__subclass(c__ParticleWord,c__Word) ).

fof(mergeA3076,axiom,
    p__d__subclass(c__Morpheme,c__LinguisticExpression) ).

fof(mergeA3077,axiom,
    ! [MORPH] :
      ( ( p__d__instance(MORPH,c__Object)
        & p__d__instance(MORPH,c__Morpheme) )
     => ! [OTHERMORPH] :
          ( ~ p__d__instance(OTHERMORPH,c__Object)
          | ~ p__d__instance(OTHERMORPH,c__Morpheme)
          | ~ p__part(OTHERMORPH,MORPH)
          | OTHERMORPH = MORPH ) ) ).

fof(mergeA3078,axiom,
    ! [MORPH] :
      ( ( p__d__instance(MORPH,c__Object)
        & p__d__instance(MORPH,c__Morpheme) )
     => ? [WORD] :
          ( p__d__instance(WORD,c__Object)
          & p__d__instance(WORD,c__Word)
          & p__part(MORPH,WORD) ) ) ).

fof(mergeA3079,axiom,
    ! [WORD] :
      ( ( p__d__instance(WORD,c__Object)
        & p__d__instance(WORD,c__Word) )
     => ? [PART] :
          ( p__d__instance(PART,c__Object)
          & p__part(PART,WORD)
          & p__d__instance(PART,c__Morpheme) ) ) ).

fof(mergeA3080,axiom,
    p__d__subclass(c__Phrase,c__LinguisticExpression) ).

fof(mergeA3081,axiom,
    p__d__disjointDecomposition4(c__Phrase,c__VerbPhrase,c__NounPhrase,c__PrepositionalPhrase) ).

fof(mergeA3082,axiom,
    ! [PHRASE] :
      ( ( p__d__instance(PHRASE,c__Object)
        & p__d__instance(PHRASE,c__Phrase) )
     => ? [PART1,PART2] :
          ( p__d__instance(PART1,c__Object)
          & p__d__instance(PART2,c__Object)
          & p__part(PART1,PHRASE)
          & p__part(PART2,PHRASE)
          & p__d__instance(PART1,c__Word)
          & p__d__instance(PART2,c__Word)
          & PART1 != PART2 ) ) ).

fof(mergeA3083,axiom,
    p__d__subclass(c__VerbPhrase,c__Phrase) ).

fof(mergeA3084,axiom,
    ! [PHRASE] :
      ( ( p__d__instance(PHRASE,c__Object)
        & p__d__instance(PHRASE,c__VerbPhrase) )
     => ? [VERB] :
          ( p__d__instance(VERB,c__Object)
          & p__d__instance(VERB,c__Verb)
          & p__part(VERB,PHRASE) ) ) ).

fof(mergeA3085,axiom,
    p__d__subclass(c__NounPhrase,c__Phrase) ).

fof(mergeA3086,axiom,
    p__d__disjoint(c__NounPhrase,c__VerbPhrase) ).

fof(mergeA3087,axiom,
    ! [SENTENCE] :
      ( ( p__d__instance(SENTENCE,c__Object)
        & p__d__instance(SENTENCE,c__Sentence) )
     => ? [PHRASE1,PHRASE2] :
          ( p__d__instance(PHRASE1,c__Object)
          & p__d__instance(PHRASE2,c__Object)
          & p__d__instance(PHRASE1,c__NounPhrase)
          & p__d__instance(PHRASE2,c__VerbPhrase)
          & p__part(PHRASE1,SENTENCE)
          & p__part(PHRASE2,SENTENCE) ) ) ).

fof(mergeA3088,axiom,
    ! [PHRASE] :
      ( ( p__d__instance(PHRASE,c__Object)
        & p__d__instance(PHRASE,c__NounPhrase) )
     => ? [NOUN] :
          ( p__d__instance(NOUN,c__Object)
          & p__d__instance(NOUN,c__Noun)
          & p__part(NOUN,PHRASE) ) ) ).

fof(mergeA3089,axiom,
    p__d__subclass(c__PrepositionalPhrase,c__Phrase) ).

fof(mergeA3090,axiom,
    ! [PHRASE] :
      ( ( p__d__instance(PHRASE,c__Object)
        & p__d__instance(PHRASE,c__PrepositionalPhrase) )
     => ? [PREP] :
          ( p__d__instance(PREP,c__Object)
          & p__d__instance(PREP,c__ParticleWord)
          & p__part(PREP,PHRASE) ) ) ).

fof(mergeA3091,axiom,
    p__d__subclass(c__Text,c__LinguisticExpression) ).

fof(mergeA3092,axiom,
    p__d__subclass(c__Text,c__ContentBearingObject) ).

fof(mergeA3093,axiom,
    p__d__subclass(c__Text,c__Artifact) ).

fof(mergeA3094,axiom,
    ! [TEXT] :
      ( p__d__instance(TEXT,c__Text)
     => ? [PART] :
          ( p__d__instance(PART,c__Object)
          & p__part(PART,TEXT)
          & p__d__instance(PART,c__LinguisticExpression) ) ) ).

fof(mergeA3095,axiom,
    ! [TEXT] :
      ( p__d__instance(TEXT,c__Text)
     => ? [WRITE] :
          ( p__d__instance(WRITE,c__Writing)
          & p__result(WRITE,TEXT) ) ) ).

fof(mergeA3096,axiom,
    p__d__subclass(c__FactualText,c__Text) ).

fof(mergeA3097,axiom,
    p__d__disjoint(c__FactualText,c__FictionalText) ).

fof(mergeA3098,axiom,
    ! [CLASS,TEXT,AGENT,CONTENT] :
      ( ( p__d__instance(TEXT,c__ContentBearingPhysical)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(TEXT,CLASS)
        & p__d__subclass(CLASS,c__FactualText)
        & p__authors(AGENT,CLASS)
        & p__subsumesContentInstance(TEXT,CONTENT)
        & p__d__instance(CONTENT,c__Formula) )
     => p__believes(AGENT,CONTENT) ) ).

fof(mergeA3099,axiom,
    p__d__subclass(c__FictionalText,c__Text) ).

fof(mergeA3100,axiom,
    ! [CLASS,TEXT,AGENT] :
      ( ( p__d__instance(TEXT,c__ContentBearingPhysical)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(TEXT,CLASS)
        & p__d__subclass(CLASS,c__FictionalText)
        & p__authors(AGENT,CLASS) )
     => ? [CONTENT] :
          ( p__subsumesContentInstance(TEXT,CONTENT)
          & p__d__instance(CONTENT,c__Formula)
          & ~ p__believes(AGENT,CONTENT) ) ) ).

fof(mergeA3101,axiom,
    p__d__subclass(c__Sentence,c__LinguisticExpression) ).

fof(mergeA3102,axiom,
    ! [SENT] :
      ( p__d__instance(SENT,c__Sentence)
     => ? [PROP] :
          ( p__d__instance(PROP,c__Proposition)
          & p__containsInformation(SENT,PROP) ) ) ).

fof(mergeA3103,axiom,
    p__d__instance(c__authors,c__BinaryPredicate) ).

fof(mergeA3104,axiom,
    p__d__instance(c__authors,c__AsymmetricRelation) ).

fof(mergeA3107,axiom,
    ! [AGENT,TEXTCLASS] :
      ( ( p__d__subclass(TEXTCLASS,c__Text)
        & p__d__instance(AGENT,c__Agent)
        & p__authors(AGENT,TEXTCLASS) )
     => ? [PROCESS,INSTANCE] :
          ( p__d__instance(PROCESS,c__Process)
          & p__agent(PROCESS,AGENT)
          & p__d__instance(INSTANCE,TEXTCLASS)
          & p__result(PROCESS,INSTANCE) ) ) ).

fof(mergeA3108,axiom,
    p__d__instance(c__editor,c__BinaryPredicate) ).

fof(mergeA3109,axiom,
    p__d__instance(c__editor,c__AsymmetricRelation) ).

fof(mergeA3112,axiom,
    p__d__instance(c__publishes,c__BinaryPredicate) ).

fof(mergeA3113,axiom,
    p__d__instance(c__publishes,c__AsymmetricRelation) ).

fof(mergeA3116,axiom,
    ! [TEXTCLASS,ORG,INST] :
      ( ( p__d__subclass(TEXTCLASS,c__Text)
        & p__d__instance(ORG,c__Organization)
        & p__publishes(ORG,TEXTCLASS)
        & p__d__instance(INST,TEXTCLASS) )
     => ? [PUB] :
          ( p__d__instance(PUB,c__Publication)
          & p__agent(PUB,ORG)
          & p__patient(PUB,INST) ) ) ).

fof(mergeA3117,axiom,
    p__d__instance(c__EditionFn,c__BinaryFunction) ).

fof(mergeA3118,axiom,
    p__d__instance(c__EditionFn,c__PartialValuedRelation) ).

fof(mergeA3122,axiom,
    ! [TEXT,INT2,INT1,EDITION1,EDITION2,CBO1,CBO2,PUB1,PUB2,DATE1,DATE2] :
      ( ( p__d__instance(INT1,c__PositiveInteger)
        & p__d__subclass(TEXT,c__ContentBearingObject)
        & p__d__subclass(EDITION1,c__ContentBearingObject)
        & p__d__instance(INT2,c__PositiveInteger)
        & p__d__subclass(EDITION2,c__ContentBearingObject)
        & p__d__instance(DATE1,c__Day)
        & p__d__instance(DATE2,c__Day)
        & f__EditionFn2(TEXT,INT1) = EDITION1
        & f__EditionFn2(TEXT,INT2) = EDITION2
        & p__greaterThan(INT2,INT1)
        & p__d__instance(PUB1,c__Publication)
        & p__d__instance(PUB2,c__Publication)
        & p__d__instance(CBO1,EDITION1)
        & p__d__instance(CBO2,EDITION2)
        & p__patient(PUB1,CBO1)
        & p__patient(PUB2,CBO2)
        & p__date(PUB1,DATE1)
        & p__date(PUB2,DATE2) )
     => p__before(f__EndFn1(DATE1),f__EndFn1(DATE2)) ) ).

fof(mergeA3123,axiom,
    ! [NUMBER,TEXT1,TEXT2] :
      ( ( p__d__instance(NUMBER,c__PositiveInteger)
        & p__d__subclass(TEXT1,c__ContentBearingObject)
        & p__d__subclass(TEXT2,c__ContentBearingObject)
        & f__EditionFn2(TEXT1,NUMBER) = TEXT2 )
     => p__subsumesContentClass(TEXT1,TEXT2) ) ).

fof(mergeA3124,axiom,
    p__d__subclass(c__Summary,c__Text) ).

fof(mergeA3125,axiom,
    ! [TEXT] :
      ( p__d__instance(TEXT,c__Summary)
     => ? [TEXT2] :
          ( p__d__instance(TEXT2,c__Text)
          & p__subsumesContentInstance(TEXT2,TEXT) ) ) ).

fof(mergeA3126,axiom,
    p__d__subclass(c__Certificate,c__Text) ).

fof(mergeA3127,axiom,
    ! [DOC] :
      ( p__d__instance(DOC,c__Certificate)
     => ? [PROP,NORM] :
          ( p__d__instance(NORM,c__ObjectiveNorm)
          & p__d__instance(PROP,c__Formula)
          & ( p__confersNorm(DOC,PROP,NORM)
            | p__deprivesNorm(DOC,PROP,NORM) ) ) ) ).

fof(mergeA3128,axiom,
    p__d__subclass(c__FinancialInstrument,c__Certificate) ).

fof(mergeA3129,axiom,
    p__d__subclass(c__Currency,c__FinancialInstrument) ).

fof(mergeA3130,axiom,
    ! [CURRENCY] :
      ( p__d__instance(CURRENCY,c__Currency)
     => ? [MEASURE] :
          ( p__d__instance(MEASURE,c__CurrencyMeasure)
          & p__monetaryValue(CURRENCY,MEASURE) ) ) ).

fof(mergeA3131,axiom,
    p__d__subclass(c__Patent,c__Certificate) ).

fof(mergeA3132,axiom,
    p__d__subclass(c__Molecule,c__CompoundSubstance) ).

fof(mergeA3133,axiom,
    ! [MOLE] :
      ( p__d__instance(MOLE,c__Molecule)
     => ? [ATOM1,ATOM2] :
          ( p__d__instance(ATOM1,c__Atom)
          & p__d__instance(ATOM2,c__Atom)
          & p__part(ATOM1,MOLE)
          & p__part(ATOM2,MOLE)
          & ATOM1 != ATOM2 ) ) ).

fof(mergeA3134,axiom,
    p__d__subclass(c__Artifact,c__Object) ).

fof(mergeA3135,axiom,
    ! [ARTIFACT] :
      ( p__d__instance(ARTIFACT,c__Artifact)
    <=> ? [MAKING] :
          ( p__d__instance(MAKING,c__Making)
          & p__result(MAKING,ARTIFACT) ) ) ).

fof(mergeA3136,axiom,
    p__d__subclass(c__Product,c__Artifact) ).

fof(mergeA3137,axiom,
    ! [PRODUCT] :
      ( p__d__instance(PRODUCT,c__Product)
     => ? [MANUFACTURE] :
          ( p__d__instance(MANUFACTURE,c__Manufacture)
          & p__result(MANUFACTURE,PRODUCT) ) ) ).

fof(mergeA3138,axiom,
    p__d__instance(c__version,c__BinaryPredicate) ).

fof(mergeA3139,axiom,
    p__d__instance(c__version,c__AsymmetricRelation) ).

fof(mergeA3140,axiom,
    p__d__instance(c__version,c__TransitiveRelation) ).

fof(mergeA3143,axiom,
    ! [ARTIFACT1,ARTIFACT2] :
      ( ( p__d__subclass(ARTIFACT2,c__Artifact)
        & p__d__subclass(ARTIFACT1,c__Artifact)
        & p__version(ARTIFACT1,ARTIFACT2) )
     => p__d__subclass(ARTIFACT1,ARTIFACT2) ) ).

fof(mergeA3144,axiom,
    p__d__subclass(c__StationaryArtifact,c__Artifact) ).

fof(mergeA3146,axiom,
    p__d__subclass(c__Building,c__StationaryArtifact) ).

fof(mergeA3147,axiom,
    ! [BUILDING] :
      ( p__d__instance(BUILDING,c__Building)
     => ? [HUMAN] :
          ( p__d__instance(HUMAN,c__Human)
          & ( p__inhabits(HUMAN,BUILDING)
            | ? [ACT] :
                ( p__d__instance(ACT,c__Process)
                & p__agent(ACT,HUMAN)
                & p__located(ACT,BUILDING) ) ) ) ) ).

fof(mergeA3148,axiom,
    p__d__subclass(c__Room,c__StationaryArtifact) ).

fof(mergeA3149,axiom,
    p__d__disjoint(c__Room,c__Building) ).

fof(mergeA3150,axiom,
    ! [ROOM] :
      ( p__d__instance(ROOM,c__Room)
     => ? [BUILD] :
          ( p__d__instance(BUILD,c__Building)
          & p__properPart(ROOM,BUILD) ) ) ).

fof(mergeA3151,axiom,
    p__d__subclass(c__House,c__ResidentialBuilding) ).

fof(mergeA3152,axiom,
    p__d__subclass(c__House,c__SingleFamilyResidence) ).

fof(mergeA3153,axiom,
    p__d__subclass(c__Residence,c__StationaryArtifact) ).

fof(mergeA3154,axiom,
    p__d__partition3(c__Residence,c__PermanentResidence,c__TemporaryResidence) ).

fof(mergeA3155,axiom,
    ! [RESIDENCE] :
      ( p__d__instance(RESIDENCE,c__Residence)
     => ( p__d__instance(RESIDENCE,c__House)
        | ? [BUILDING] :
            ( p__d__instance(BUILDING,c__ResidentialBuilding)
            & p__part(RESIDENCE,BUILDING) ) ) ) ).

fof(mergeA3156,axiom,
    p__d__subclass(c__PermanentResidence,c__Residence) ).

fof(mergeA3157,axiom,
    ! [RESIDENCE] :
      ( p__d__instance(RESIDENCE,c__PermanentResidence)
     => ? [PERSON] :
          ( p__d__instance(PERSON,c__Human)
          & p__home(PERSON,RESIDENCE) ) ) ).

fof(mergeA3158,axiom,
    p__d__subclass(c__TemporaryResidence,c__Residence) ).

fof(mergeA3159,axiom,
    p__d__subclass(c__ResidentialBuilding,c__Building) ).

fof(mergeA3160,axiom,
    p__d__subclass(c__ResidentialBuilding,c__Residence) ).

fof(mergeA3161,axiom,
    p__d__subclass(c__SingleFamilyResidence,c__PermanentResidence) ).

fof(mergeA3163,axiom,
    p__d__subclass(c__ArtWork,c__Artifact) ).

fof(mergeA3166,axiom,
    p__d__subclass(c__RepresentationalArtWork,c__ArtWork) ).

fof(mergeA3167,axiom,
    p__d__subclass(c__RepresentationalArtWork,c__Icon) ).

fof(mergeA3168,axiom,
    ! [RA] :
      ( p__d__instance(RA,c__RepresentationalArtWork)
     => ? [P] :
          ( p__d__instance(P,c__Physical)
          & p__represents(RA,P) ) ) ).

fof(mergeA3169,axiom,
    p__d__subclass(c__Fabric,c__Artifact) ).

fof(mergeA3170,axiom,
    p__d__disjoint(c__Fabric,c__StationaryArtifact) ).

fof(mergeA3171,axiom,
    p__d__subclass(c__WearableItem,c__Artifact) ).

fof(mergeA3173,axiom,
    p__d__subclass(c__Clothing,c__WearableItem) ).

fof(mergeA3174,axiom,
    p__d__disjoint(c__Clothing,c__StationaryArtifact) ).

fof(mergeA3175,axiom,
    ! [CLOTHING] :
      ( p__d__instance(CLOTHING,c__Clothing)
     => ? [FABRIC] :
          ( p__d__instance(FABRIC,c__Fabric)
          & p__part(FABRIC,CLOTHING) ) ) ).

fof(mergeA3176,axiom,
    p__d__instance(c__wears,c__BinaryPredicate) ).

fof(mergeA3179,axiom,
    ! [WI,AGENT] :
      ( ( p__d__instance(WI,c__WearableItem)
        & p__d__instance(AGENT,c__Animal)
        & p__wears(AGENT,WI) )
     => p__located(WI,AGENT) ) ).

fof(mergeA3180,axiom,
    ! [C,A,P] :
      ( ( p__d__instance(C,c__WearableItem)
        & p__d__instance(A,c__Animal)
        & p__d__instance(P,c__WearableItem)
        & p__wears(A,C)
        & p__part(P,C) )
     => p__wears(A,P) ) ).

fof(mergeA3181,axiom,
    p__d__subclass(c__Device,c__Artifact) ).

fof(mergeA3182,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__Device)
     => ? [PROC] :
          ( p__d__subclass(PROC,c__Process)
          & p__capability(PROC,c__instrument,DEVICE) ) ) ).

fof(mergeA3184,axiom,
    p__d__subclass(c__MusicalInstrument,c__Device) ).

fof(mergeA3185,axiom,
    ! [INSTRUMENT] :
      ( p__d__instance(INSTRUMENT,c__MusicalInstrument)
     => p__capability(c__MakingMusic,c__instrument,INSTRUMENT) ) ).

fof(mergeA3186,axiom,
    p__d__subclass(c__TransportationDevice,c__Device) ).

fof(mergeA3187,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__TransportationDevice)
     => p__capability(c__Transportation,c__instrument,DEVICE) ) ).

fof(mergeA3188,axiom,
    p__d__subclass(c__Vehicle,c__TransportationDevice) ).

fof(mergeA3191,axiom,
    p__d__subclass(c__MeasuringDevice,c__Device) ).

fof(mergeA3193,axiom,
    p__d__subclass(c__AttachingDevice,c__Device) ).

fof(mergeA3194,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__AttachingDevice)
     => ? [ATTACH] :
          ( p__d__instance(ATTACH,c__Attaching)
          & p__instrument(ATTACH,DEVICE) ) ) ).

fof(mergeA3195,axiom,
    p__d__subclass(c__Weapon,c__Device) ).

fof(mergeA3196,axiom,
    ! [WEAPON] :
      ( p__d__instance(WEAPON,c__Weapon)
     => p__capability(c__Damaging,c__instrument,WEAPON) ) ).

fof(mergeA3198,axiom,
    p__d__subclass(c__Machine,c__Device) ).

fof(mergeA3199,axiom,
    ! [MACHINE,PROC] :
      ( ( p__d__instance(PROC,c__Process)
        & p__d__instance(MACHINE,c__Machine)
        & p__instrument(PROC,MACHINE) )
     => ? [RESOURCE,RESULT] :
          ( p__d__instance(RESOURCE,c__Object)
          & p__resource(PROC,RESOURCE)
          & p__result(PROC,RESULT) ) ) ).

fof(mergeA3200,axiom,
    p__d__subclass(c__EngineeringComponent,c__Device) ).

fof(mergeA3201,axiom,
    ! [COMP] :
      ( ( p__d__instance(COMP,c__CorpuscularObject)
        & p__d__instance(COMP,c__EngineeringComponent) )
     => ? [DEVICE] :
          ( p__d__instance(DEVICE,c__CorpuscularObject)
          & p__d__instance(DEVICE,c__Device)
          & p__component(COMP,DEVICE) ) ) ).

fof(mergeA3202,axiom,
    ! [MACHINE] :
      ( p__d__instance(MACHINE,c__Machine)
     => ? [COMP1,COMP2] :
          ( p__d__instance(COMP1,c__EngineeringComponent)
          & p__d__instance(COMP2,c__EngineeringComponent)
          & COMP1 != COMP2
          & p__part(COMP1,MACHINE)
          & p__part(COMP2,MACHINE) ) ) ).

fof(mergeA3203,axiom,
    p__subrelation(c__engineeringSubcomponent,c__properPart) ).

fof(mergeA3206,axiom,
    p__d__instance(c__connectedEngineeringComponents,c__SymmetricRelation) ).

fof(mergeA3207,axiom,
    p__d__instance(c__connectedEngineeringComponents,c__IrreflexiveRelation) ).

fof(mergeA3208,axiom,
    p__subrelation(c__connectedEngineeringComponents,c__connected) ).

fof(mergeA3211,axiom,
    ! [COMP2,COMP1] :
      ( ( p__d__instance(COMP2,c__EngineeringComponent)
        & p__d__instance(COMP1,c__EngineeringComponent)
        & p__connectedEngineeringComponents(COMP1,COMP2) )
     => ( ~ p__engineeringSubcomponent(COMP1,COMP2)
        & ~ p__engineeringSubcomponent(COMP2,COMP1) ) ) ).

fof(mergeA3212,axiom,
    p__d__subclass(c__EngineeringConnection,c__EngineeringComponent) ).

fof(mergeA3213,axiom,
    ! [CONNECTION] :
      ( p__d__instance(CONNECTION,c__EngineeringConnection)
     => ? [COMP1,COMP2] :
          ( p__d__instance(COMP2,c__EngineeringComponent)
          & p__d__instance(COMP1,c__EngineeringComponent)
          & p__connectsEngineeringComponents(CONNECTION,COMP1,COMP2) ) ) ).

fof(mergeA3214,axiom,
    ! [COMP1,COMP2] :
      ( ( p__d__instance(COMP2,c__EngineeringComponent)
        & p__d__instance(COMP1,c__EngineeringComponent)
        & p__connectedEngineeringComponents(COMP1,COMP2) )
     => ( ~ p__d__instance(COMP1,c__EngineeringConnection)
        & ~ p__d__instance(COMP2,c__EngineeringConnection) ) ) ).

fof(mergeA3215,axiom,
    ! [COMP1,COMP2] :
      ( ( p__d__instance(COMP2,c__EngineeringComponent)
        & p__d__instance(COMP1,c__EngineeringComponent) )
     => ( p__connectedEngineeringComponents(COMP1,COMP2)
      <=> ? [CONNECTION] :
            ( p__d__instance(CONNECTION,c__EngineeringConnection)
            & p__connectsEngineeringComponents(CONNECTION,COMP1,COMP2) ) ) ) ).

fof(mergeA3216,axiom,
    p__subrelation(c__connectsEngineeringComponents,c__connects) ).

fof(mergeA3220,axiom,
    p__d__subclass(c__CommercialAgent,c__Agent) ).

fof(mergeA3221,axiom,
    p__d__subclass(c__Business,c__CommercialAgent) ).

fof(mergeA3222,axiom,
    p__d__subclass(c__Business,c__Organization) ).

fof(mergeA3223,axiom,
    p__d__subclass(c__Corporation,c__Business) ).

fof(mergeA3224,axiom,
    p__d__subclass(c__Corporation,c__LegalAgent) ).

fof(mergeA3225,axiom,
    p__d__subclass(c__Manufacturer,c__Corporation) ).

fof(mergeA3227,axiom,
    p__d__subclass(c__MercantileOrganization,c__Corporation) ).

fof(mergeA3229,axiom,
    p__d__subclass(c__Group,c__Collection) ).

fof(mergeA3230,axiom,
    p__d__subclass(c__Group,c__Agent) ).

fof(mergeA3231,axiom,
    ! [GROUP,MEMB] :
      ( ( p__d__instance(MEMB,c__SelfConnectedObject)
        & p__d__instance(GROUP,c__Group)
        & p__member(MEMB,GROUP) )
     => p__d__instance(MEMB,c__Agent) ) ).

fof(mergeA3232,axiom,
    p__d__subclass(c__GroupOfPeople,c__Group) ).

fof(mergeA3233,axiom,
    ! [GROUP,MEMBER] :
      ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
        & p__d__instance(GROUP,c__GroupOfPeople)
        & p__member(MEMBER,GROUP) )
     => p__d__instance(MEMBER,c__Human) ) ).

fof(mergeA3234,axiom,
    p__d__subclass(c__AgeGroup,c__GroupOfPeople) ).

fof(mergeA3235,axiom,
    ! [GROUP,MEMB1,MEMB2,AGE1,AGE2] :
      ( ( p__d__instance(MEMB1,c__SelfConnectedObject)
        & p__d__instance(MEMB2,c__SelfConnectedObject)
        & p__d__instance(AGE1,c__TimeDuration)
        & p__d__instance(AGE2,c__TimeDuration)
        & p__d__instance(GROUP,c__AgeGroup)
        & p__member(MEMB1,GROUP)
        & p__member(MEMB2,GROUP)
        & p__age(MEMB1,AGE1)
        & p__age(MEMB2,AGE2) )
     => AGE1 = AGE2 ) ).

fof(mergeA3236,axiom,
    p__d__subclass(c__FamilyGroup,c__GroupOfPeople) ).

fof(mergeA3237,axiom,
    ! [GROUP,MEMB1,MEMB2] :
      ( ( p__d__instance(MEMB1,c__Organism)
        & p__d__instance(MEMB2,c__Organism)
        & p__d__instance(GROUP,c__FamilyGroup)
        & p__member(MEMB1,GROUP)
        & p__member(MEMB2,GROUP) )
     => p__familyRelation(MEMB1,MEMB2) ) ).

fof(mergeA3238,axiom,
    p__d__subclass(c__SocialUnit,c__GroupOfPeople) ).

fof(mergeA3239,axiom,
    ! [UNIT,MEMBER] :
      ( ( p__d__instance(MEMBER,c__Human)
        & p__d__instance(UNIT,c__SocialUnit) )
     => ? [HOME] :
          ( p__d__instance(HOME,c__PermanentResidence)
          & ( p__member(MEMBER,UNIT)
           => p__home(MEMBER,HOME) ) ) ) ).

fof(mergeA3240,axiom,
    p__d__instance(c__ImmediateFamilyFn,c__UnaryFunction) ).

fof(mergeA3243,axiom,
    ! [P,FAMILY,MEMBER] :
      ( ( p__d__instance(P,c__Human)
        & p__d__instance(FAMILY,c__FamilyGroup)
        & f__ImmediateFamilyFn1(P) = FAMILY
        & p__d__instance(MEMBER,c__Organism)
        & p__member(MEMBER,FAMILY) )
     => ? [OTHER] :
          ( p__d__instance(OTHER,c__Organism)
          & ( p__parent(MEMBER,OTHER)
            | p__parent(OTHER,MEMBER) ) ) ) ).

fof(mergeA3244,axiom,
    ! [FAMILY,PERSON] :
      ( ( p__d__instance(PERSON,c__Human)
        & p__d__instance(FAMILY,c__FamilyGroup)
        & f__ImmediateFamilyFn1(PERSON) = FAMILY )
     => ? [MEMBER] :
          ( p__d__instance(MEMBER,c__Organism)
          & p__member(MEMBER,FAMILY)
          & ( p__parent(MEMBER,PERSON)
            | p__parent(PERSON,MEMBER) ) ) ) ).

fof(mergeA3245,axiom,
    p__d__instance(c__relative,c__BinaryPredicate) ).

fof(mergeA3246,axiom,
    p__d__instance(c__relative,c__SymmetricRelation) ).

fof(mergeA3249,axiom,
    p__subrelation(c__familyRelation,c__relative) ).

fof(mergeA3250,axiom,
    p__subrelation(c__spouse,c__relative) ).

fof(mergeA3252,axiom,
    p__d__instance(c__familyRelation,c__BinaryPredicate) ).

fof(mergeA3253,axiom,
    p__d__instance(c__familyRelation,c__EquivalenceRelation) ).

fof(mergeA3256,axiom,
    ! [ORGANISM1,ORGANISM2] :
      ( ( p__d__instance(ORGANISM2,c__Organism)
        & p__d__instance(ORGANISM1,c__Organism)
        & p__familyRelation(ORGANISM1,ORGANISM2) )
     => ? [ORGANISM3] :
          ( p__d__instance(ORGANISM3,c__Organism)
          & p__ancestor(ORGANISM3,ORGANISM1)
          & p__ancestor(ORGANISM3,ORGANISM2) ) ) ).

fof(mergeA3257,axiom,
    p__subrelation(c__ancestor,c__familyRelation) ).

fof(mergeA3258,axiom,
    p__d__instance(c__ancestor,c__TransitiveRelation) ).

fof(mergeA3259,axiom,
    p__d__instance(c__ancestor,c__IrreflexiveRelation) ).

fof(mergeA3262,axiom,
    p__subrelation(c__parent,c__ancestor) ).

fof(mergeA3263,axiom,
    p__d__instance(c__parent,c__BinaryPredicate) ).

fof(mergeA3264,axiom,
    p__subrelation(c__parent,c__familyRelation) ).

fof(mergeA3265,axiom,
    p__d__instance(c__parent,c__AsymmetricRelation) ).

fof(mergeA3266,axiom,
    p__d__instance(c__parent,c__IntransitiveRelation) ).

fof(mergeA3269,axiom,
    ! [PARENT,CHILD] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__parent(CHILD,PARENT) )
     => p__before(f__BeginFn1(f__WhenFn1(PARENT)),f__BeginFn1(f__WhenFn1(CHILD))) ) ).

fof(mergeA3270,axiom,
    ! [PARENT,CHILD,CLASS] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__parent(CHILD,PARENT)
        & p__d__subclass(CLASS,c__Organism)
        & p__d__instance(PARENT,CLASS) )
     => p__d__instance(CHILD,CLASS) ) ).

fof(mergeA3271,axiom,
    ! [REP,CHILD,PARENT] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__parent(CHILD,PARENT)
        & p__d__instance(REP,c__SexualReproduction)
        & p__agent(REP,PARENT)
        & p__result(REP,CHILD) )
     => ( p__mother(CHILD,PARENT)
        | p__father(CHILD,PARENT) ) ) ).

fof(mergeA3272,axiom,
    ! [ORGANISM] :
      ( p__d__instance(ORGANISM,c__Organism)
     => ? [PARENT] :
          ( p__d__instance(PARENT,c__Organism)
          & p__parent(ORGANISM,PARENT) ) ) ).

fof(mergeA3273,axiom,
    p__d__instance(c__mother,c__SingleValuedRelation) ).

fof(mergeA3274,axiom,
    p__subrelation(c__mother,c__parent) ).

fof(mergeA3277,axiom,
    ! [CHILD,MOTHER] :
      ( ( p__d__instance(MOTHER,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__mother(CHILD,MOTHER) )
     => p__attribute(MOTHER,c__Female) ) ).

fof(mergeA3278,axiom,
    p__d__instance(c__father,c__SingleValuedRelation) ).

fof(mergeA3279,axiom,
    p__subrelation(c__father,c__parent) ).

fof(mergeA3282,axiom,
    ! [CHILD,FATHER] :
      ( ( p__d__instance(FATHER,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__father(CHILD,FATHER) )
     => p__attribute(FATHER,c__Male) ) ).

fof(mergeA3283,axiom,
    p__subrelation(c__daughter,c__parent) ).

fof(mergeA3286,axiom,
    ! [PARENT,CHILD] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__daughter(CHILD,PARENT) )
     => p__attribute(CHILD,c__Female) ) ).

fof(mergeA3287,axiom,
    p__subrelation(c__son,c__parent) ).

fof(mergeA3290,axiom,
    ! [PARENT,CHILD] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__son(CHILD,PARENT) )
     => p__attribute(CHILD,c__Male) ) ).

fof(mergeA3291,axiom,
    p__d__instance(c__sibling,c__BinaryPredicate) ).

fof(mergeA3292,axiom,
    p__subrelation(c__sibling,c__familyRelation) ).

fof(mergeA3293,axiom,
    p__d__instance(c__sibling,c__SymmetricRelation) ).

fof(mergeA3294,axiom,
    p__d__instance(c__sibling,c__IrreflexiveRelation) ).

fof(mergeA3297,axiom,
    ! [PARENT1,PARENT2,ORGANISM1,ORGANISM2] :
      ( ( p__d__instance(PARENT1,c__Organism)
        & p__d__instance(ORGANISM1,c__Organism)
        & p__d__instance(ORGANISM2,c__Organism)
        & p__d__instance(PARENT2,c__Organism)
        & p__parent(ORGANISM1,PARENT1)
        & p__parent(ORGANISM2,PARENT1)
        & p__parent(ORGANISM1,PARENT2)
        & p__parent(ORGANISM2,PARENT2)
        & ORGANISM1 != ORGANISM2
        & PARENT1 != PARENT2 )
     => p__sibling(ORGANISM1,ORGANISM2) ) ).

fof(mergeA3298,axiom,
    ! [ORG1,ORG2,PARENT] :
      ( ( p__d__instance(ORG2,c__Organism)
        & p__d__instance(ORG1,c__Organism)
        & p__d__instance(PARENT,c__Organism)
        & p__sibling(ORG1,ORG2)
        & p__parent(ORG1,PARENT) )
     => p__parent(ORG2,PARENT) ) ).

fof(mergeA3299,axiom,
    ! [CHILD,PARENT] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__parent(CHILD,PARENT)
        & p__attribute(PARENT,c__Male) )
     => p__father(CHILD,PARENT) ) ).

fof(mergeA3300,axiom,
    ! [CHILD,PARENT] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__d__instance(CHILD,c__Organism)
        & p__parent(CHILD,PARENT)
        & p__attribute(PARENT,c__Female) )
     => p__mother(CHILD,PARENT) ) ).

fof(mergeA3301,axiom,
    p__subrelation(c__brother,c__sibling) ).

fof(mergeA3302,axiom,
    p__d__instance(c__brother,c__IrreflexiveRelation) ).

fof(mergeA3303,axiom,
    p__d__instance(c__brother,c__TransitiveRelation) ).

fof(mergeA3306,axiom,
    p__subrelation(c__sister,c__sibling) ).

fof(mergeA3307,axiom,
    p__d__instance(c__sister,c__IrreflexiveRelation) ).

fof(mergeA3308,axiom,
    p__d__instance(c__sister,c__TransitiveRelation) ).

fof(mergeA3311,axiom,
    p__d__instance(c__legalRelation,c__BinaryPredicate) ).

fof(mergeA3312,axiom,
    p__d__instance(c__legalRelation,c__SymmetricRelation) ).

fof(mergeA3315,axiom,
    ! [AGENT1,AGENT2] :
      ( ( p__d__instance(AGENT2,c__Human)
        & p__d__instance(AGENT1,c__Human)
        & p__legalRelation(AGENT1,AGENT2) )
     => ? [DECLARE,OBLIGATION] :
          ( p__d__instance(OBLIGATION,c__Formula)
          & p__d__instance(DECLARE,c__Declaring)
          & p__confersObligation(OBLIGATION,DECLARE,AGENT1)
          & p__confersObligation(OBLIGATION,DECLARE,AGENT2) ) ) ).

fof(mergeA3316,axiom,
    p__d__instance(c__acquaintance,c__BinaryPredicate) ).

fof(mergeA3319,axiom,
    p__d__instance(c__mutualAcquaintance,c__BinaryPredicate) ).

fof(mergeA3320,axiom,
    p__d__instance(c__mutualAcquaintance,c__SymmetricRelation) ).

fof(mergeA3323,axiom,
    p__subrelation(c__mutualAcquaintance,c__acquaintance) ).

fof(mergeA3324,axiom,
    p__subrelation(c__spouse,c__mutualAcquaintance) ).

fof(mergeA3325,axiom,
    p__subrelation(c__spouse,c__legalRelation) ).

fof(mergeA3326,axiom,
    p__d__instance(c__spouse,c__IrreflexiveRelation) ).

fof(mergeA3327,axiom,
    p__d__instance(c__spouse,c__SymmetricRelation) ).

fof(mergeA3330,axiom,
    p__subrelation(c__husband,c__spouse) ).

fof(mergeA3331,axiom,
    p__d__instance(c__husband,c__AsymmetricRelation) ).

fof(mergeA3332,axiom,
    p__d__instance(c__husband,c__IrreflexiveRelation) ).

fof(mergeA3335,axiom,
    p__inverse(c__husband,c__wife) ).

fof(mergeA3336,axiom,
    p__subrelation(c__wife,c__spouse) ).

fof(mergeA3337,axiom,
    p__d__instance(c__wife,c__AsymmetricRelation) ).

fof(mergeA3338,axiom,
    p__d__instance(c__wife,c__IrreflexiveRelation) ).

fof(mergeA3341,axiom,
    p__d__subclass(c__EthnicGroup,c__GroupOfPeople) ).

fof(mergeA3342,axiom,
    p__d__subclass(c__BeliefGroup,c__GroupOfPeople) ).

fof(mergeA3343,axiom,
    ! [GROUP] :
      ( p__d__instance(GROUP,c__BeliefGroup)
     => ? [BELIEF] :
          ( p__d__instance(BELIEF,c__Formula)
          & ! [MEMB] :
              ( ( p__d__instance(MEMB,c__SelfConnectedObject)
                & p__d__instance(MEMB,c__CognitiveAgent)
                & p__member(MEMB,GROUP) )
             => p__believes(MEMB,BELIEF) ) ) ) ).

fof(mergeA3344,axiom,
    p__d__subclass(c__Organization,c__Group) ).

fof(mergeA3345,axiom,
    p__d__subclass(c__Organization,c__Agent) ).

fof(mergeA3346,axiom,
    ! [ORG] :
      ( p__d__instance(ORG,c__Organization)
     => ? [PURP] :
          ( p__d__instance(PURP,c__Formula)
          & ! [MEMBER] :
              ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
                & p__member(MEMBER,ORG) )
             => p__hasPurpose(MEMBER,PURP) ) ) ) ).

fof(mergeA3347,axiom,
    ! [ORG,AGENT] :
      ( ( p__d__instance(AGENT,c__SelfConnectedObject)
        & p__d__instance(ORG,c__Organization)
        & p__member(AGENT,ORG) )
     => p__d__instance(AGENT,c__Agent) ) ).

fof(mergeA3348,axiom,
    p__d__instance(c__employs,c__BinaryPredicate) ).

fof(mergeA3351,axiom,
    p__d__subclass(c__PoliticalOrganization,c__Organization) ).

fof(mergeA3352,axiom,
    ! [POL] :
      ( p__d__instance(POL,c__PoliticalOrganization)
     => ? [PROC] :
          ( p__d__instance(PROC,c__PoliticalProcess)
          & p__agent(PROC,POL) ) ) ).

fof(mergeA3353,axiom,
    p__d__subclass(c__MilitaryForce,c__PoliticalOrganization) ).

fof(mergeA3354,axiom,
    ! [ORG] :
      ( p__d__instance(ORG,c__MilitaryForce)
     => p__capability(c__ViolentContest,c__agent,ORG) ) ).

fof(mergeA3355,axiom,
    p__d__subclass(c__MilitaryOrganization,c__MilitaryForce) ).

fof(mergeA3356,axiom,
    p__d__subclass(c__MilitaryOrganization,c__GovernmentOrganization) ).

fof(mergeA3357,axiom,
    p__d__subclass(c__ParamilitaryOrganization,c__MilitaryForce) ).

fof(mergeA3358,axiom,
    p__d__disjoint(c__ParamilitaryOrganization,c__GovernmentOrganization) ).

fof(mergeA3359,axiom,
    p__d__subclass(c__GovernmentOrganization,c__Organization) ).

fof(mergeA3360,axiom,
    ! [ORG] :
      ( p__d__instance(ORG,c__Organization)
     => ( p__d__instance(ORG,c__GovernmentOrganization)
      <=> ? [GOV] :
            ( p__d__instance(GOV,c__Government)
            & p__subOrganization(ORG,GOV) ) ) ) ).

fof(mergeA3361,axiom,
    ! [GOV,ORG] :
      ( ( p__d__instance(ORG,c__Organization)
        & p__subOrganization(ORG,GOV)
        & p__d__instance(GOV,c__GovernmentOrganization) )
     => p__d__instance(ORG,c__GovernmentOrganization) ) ).

fof(mergeA3362,axiom,
    p__d__subclass(c__Government,c__GovernmentOrganization) ).

fof(mergeA3363,axiom,
    p__d__subclass(c__Government,c__LegalAgent) ).

fof(mergeA3364,axiom,
    p__d__instance(c__GovernmentFn,c__UnaryFunction) ).

fof(mergeA3367,axiom,
    p__d__subclass(c__PoliceOrganization,c__GovernmentOrganization) ).

fof(mergeA3368,axiom,
    p__d__subclass(c__JudicialOrganization,c__Organization) ).

fof(mergeA3369,axiom,
    p__d__subclass(c__EducationalOrganization,c__Organization) ).

fof(mergeA3370,axiom,
    p__d__subclass(c__ReligiousOrganization,c__Organization) ).

fof(mergeA3371,axiom,
    p__d__subclass(c__ReligiousOrganization,c__BeliefGroup) ).

fof(mergeA3372,axiom,
    p__subrelation(c__subOrganization,c__subCollection) ).

fof(mergeA3373,axiom,
    p__d__instance(c__subOrganization,c__PartialOrderingRelation) ).

fof(mergeA3376,axiom,
    p__d__instance(c__citizen,c__BinaryPredicate) ).

fof(mergeA3377,axiom,
    p__d__instance(c__citizen,c__AsymmetricRelation) ).

fof(mergeA3380,axiom,
    p__d__subclass(c__FieldOfStudy,c__Proposition) ).

fof(mergeA3381,axiom,
    p__d__subclass(c__Procedure,c__Proposition) ).

fof(mergeA3382,axiom,
    p__d__subclass(c__ComputerProgram,c__Procedure) ).

fof(mergeA3383,axiom,
    p__d__subclass(c__ComputerProgramming,c__ContentDevelopment) ).

fof(mergeA3384,axiom,
    ! [CP] :
      ( p__d__instance(CP,c__ComputerProgramming)
     => ? [C] :
          ( p__d__instance(C,c__ComputerProgram)
          & p__result(CP,C) ) ) ).

fof(mergeA3385,axiom,
    p__d__subclass(c__Plan,c__Procedure) ).

fof(mergeA3386,axiom,
    ! [PLAN,OBJ] :
      ( ( p__d__instance(PLAN,c__Plan)
        & p__d__instance(OBJ,c__ContentBearingObject)
        & p__containsInformation(OBJ,PLAN) )
     => ? [PLANNING] :
          ( p__d__instance(PLANNING,c__Planning)
          & p__result(PLANNING,OBJ) ) ) ).

fof(mergeA3387,axiom,
    p__d__subclass(c__Argument,c__Proposition) ).

fof(mergeA3388,axiom,
    p__d__partition3(c__Argument,c__DeductiveArgument,c__InductiveArgument) ).

fof(mergeA3389,axiom,
    ! [REASON] :
      ( p__d__instance(REASON,c__Reasoning)
     => ? [ARGUMENT] :
          ( p__d__instance(ARGUMENT,c__Argument)
          & p__realization(REASON,ARGUMENT) ) ) ).

fof(mergeA3390,axiom,
    ! [ARGUMENT] :
      ( p__d__instance(ARGUMENT,c__Argument)
     => ? [PREMISES,CONCLUSION] :
          ( p__d__instance(PREMISES,c__Proposition)
          & p__d__instance(CONCLUSION,c__Argument)
          & f__PremisesFn1(ARGUMENT) = PREMISES
          & p__conclusion(CONCLUSION,ARGUMENT) ) ) ).

fof(mergeA3391,axiom,
    p__d__subclass(c__DeductiveArgument,c__Argument) ).

fof(mergeA3392,axiom,
    p__d__partition3(c__DeductiveArgument,c__ValidDeductiveArgument,c__InvalidDeductiveArgument) ).

fof(mergeA3393,axiom,
    p__d__subclass(c__ValidDeductiveArgument,c__DeductiveArgument) ).

fof(mergeA3394,axiom,
    p__d__subclass(c__InvalidDeductiveArgument,c__DeductiveArgument) ).

fof(mergeA3395,axiom,
    p__d__subclass(c__Explanation,c__DeductiveArgument) ).

fof(mergeA3396,axiom,
    p__d__subclass(c__InductiveArgument,c__Argument) ).

fof(mergeA3397,axiom,
    p__d__instance(c__premise,c__BinaryPredicate) ).

fof(mergeA3398,axiom,
    p__d__instance(c__premise,c__TotalValuedRelation) ).

fof(mergeA3401,axiom,
    p__d__instance(c__PremisesFn,c__UnaryFunction) ).

fof(mergeA3404,axiom,
    ! [PREMISES,ARGUMENT,PROPOSITION] :
      ( ( p__d__instance(PREMISES,c__Proposition)
        & p__d__instance(PROPOSITION,c__Proposition)
        & p__d__instance(ARGUMENT,c__Argument)
        & PREMISES = f__PremisesFn1(ARGUMENT) )
     => ( p__subProposition(PROPOSITION,PREMISES)
      <=> p__premise(ARGUMENT,PROPOSITION) ) ) ).

fof(mergeA3405,axiom,
    p__d__instance(c__conclusion,c__BinaryPredicate) ).

fof(mergeA3406,axiom,
    p__d__instance(c__conclusion,c__SingleValuedRelation) ).

fof(mergeA3407,axiom,
    p__d__instance(c__conclusion,c__TotalValuedRelation) ).

fof(mergeA3410,axiom,
    p__d__instance(c__consistent,c__BinaryPredicate) ).

fof(mergeA3411,axiom,
    p__d__instance(c__consistent,c__SymmetricRelation) ).

fof(mergeA3414,axiom,
    p__d__instance(c__orientation,c__SpatialRelation) ).

fof(mergeA3415,axiom,
    p__d__instance(c__orientation,c__TernaryPredicate) ).

fof(mergeA3420,axiom,
    p__d__instance(c__direction,c__CaseRole) ).

fof(mergeA3423,axiom,
    p__subrelation(c__direction,c__involvedInEvent) ).

fof(mergeA3425,axiom,
    p__d__instance(c__faces,c__BinaryPredicate) ).

fof(mergeA3429,axiom,
    p__d__subclass(c__TruthValue,c__RelationalAttribute) ).

fof(mergeA3430,axiom,
    ! [VALUE,ITEM] :
      ( ( p__property(ITEM,VALUE)
        & p__d__instance(VALUE,c__TruthValue) )
     => ( p__d__instance(ITEM,c__Sentence)
        | p__d__instance(ITEM,c__Proposition) ) ) ).

fof(mergeA3431,axiom,
    p__d__instance(c__True,c__TruthValue) ).

fof(mergeA3432,axiom,
    p__d__instance(c__False,c__TruthValue) ).

fof(mergeA3433,axiom,
    p__contraryAttribute2(c__False,c__True) ).

fof(mergeA3434,axiom,
    p__subrelation(c__truth,c__property) ).

fof(mergeA3437,axiom,
    p__d__subclass(c__PositionalAttribute,c__RelationalAttribute) ).

fof(mergeA3438,axiom,
    p__d__subclass(c__DirectionalAttribute,c__PositionalAttribute) ).

fof(mergeA3439,axiom,
    ! [DIRECT,OBJ1,OBJ2,OBJ3] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ3,c__Object)
        & p__d__instance(DIRECT,c__DirectionalAttribute)
        & p__orientation(OBJ1,OBJ2,DIRECT)
        & p__orientation(OBJ2,OBJ3,DIRECT) )
     => p__between(OBJ1,OBJ2,OBJ3) ) ).

fof(mergeA3440,axiom,
    p__d__instance(c__North,c__DirectionalAttribute) ).

fof(mergeA3441,axiom,
    p__contraryAttribute4(c__North,c__South,c__East,c__West) ).

fof(mergeA3442,axiom,
    p__d__instance(c__South,c__DirectionalAttribute) ).

fof(mergeA3443,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__orientation(OBJ1,OBJ2,c__North)
      <=> p__orientation(OBJ2,OBJ1,c__South) ) ) ).

fof(mergeA3444,axiom,
    p__d__instance(c__East,c__DirectionalAttribute) ).

fof(mergeA3445,axiom,
    p__d__instance(c__West,c__DirectionalAttribute) ).

fof(mergeA3446,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__orientation(OBJ1,OBJ2,c__East)
      <=> p__orientation(OBJ2,OBJ1,c__West) ) ) ).

fof(mergeA3447,axiom,
    p__d__instance(c__Vertical,c__PositionalAttribute) ).

fof(mergeA3448,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__orientation(OBJ1,OBJ2,c__Vertical)
      <=> p__orientation(OBJ2,OBJ1,c__Vertical) ) ) ).

fof(mergeA3449,axiom,
    p__d__instance(c__Horizontal,c__PositionalAttribute) ).

fof(mergeA3450,axiom,
    p__contraryAttribute2(c__Horizontal,c__Vertical) ).

fof(mergeA3451,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__orientation(OBJ1,OBJ2,c__Horizontal)
      <=> p__orientation(OBJ2,OBJ1,c__Horizontal) ) ) ).

fof(mergeA3452,axiom,
    p__d__subclass(c__SymmetricPositionalAttribute,c__PositionalAttribute) ).

fof(mergeA3453,axiom,
    ! [O2,O1,P] :
      ( ( p__d__instance(O2,c__Object)
        & p__d__instance(O1,c__Object)
        & p__d__instance(P,c__SymmetricPositionalAttribute)
        & p__orientation(O1,O2,P) )
     => p__orientation(O2,O1,P) ) ).

fof(mergeA3454,axiom,
    p__d__subclass(c__AntiSymmetricPositionalAttribute,c__PositionalAttribute) ).

fof(mergeA3455,axiom,
    ! [O2,O1,P] :
      ( ( p__d__instance(O2,c__Object)
        & p__d__instance(O1,c__Object)
        & p__d__instance(P,c__AntiSymmetricPositionalAttribute)
        & p__orientation(O1,O2,P) )
     => ~ p__orientation(O2,O1,P) ) ).

fof(mergeA3456,axiom,
    p__d__instance(c__Above,c__PositionalAttribute) ).

fof(mergeA3457,axiom,
    p__d__instance(c__Above,c__AntiSymmetricPositionalAttribute) ).

fof(mergeA3458,axiom,
    p__contraryAttribute2(c__Above,c__Below) ).

fof(mergeA3459,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__Above) )
     => ~ p__connected(OBJ1,OBJ2) ) ).

fof(mergeA3460,axiom,
    p__d__instance(c__Below,c__PositionalAttribute) ).

fof(mergeA3461,axiom,
    p__d__instance(c__Below,c__AntiSymmetricPositionalAttribute) ).

fof(mergeA3462,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__orientation(OBJ1,OBJ2,c__Below)
      <=> ( p__orientation(OBJ2,OBJ1,c__On)
          | p__orientation(OBJ2,OBJ1,c__Above) ) ) ) ).

fof(mergeA3463,axiom,
    p__d__instance(c__Adjacent,c__SymmetricPositionalAttribute) ).

fof(mergeA3464,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__orientation(OBJ1,OBJ2,c__Adjacent)
      <=> ( p__orientation(OBJ1,OBJ2,c__Near)
          | p__connected(OBJ1,OBJ2) ) ) ) ).

fof(mergeA3465,axiom,
    p__d__instance(c__Left,c__PositionalAttribute) ).

fof(mergeA3466,axiom,
    p__d__instance(c__Left,c__AntiSymmetricPositionalAttribute) ).

fof(mergeA3467,axiom,
    p__d__instance(c__Right,c__PositionalAttribute) ).

fof(mergeA3468,axiom,
    p__d__instance(c__Right,c__AntiSymmetricPositionalAttribute) ).

fof(mergeA3469,axiom,
    p__contraryAttribute2(c__Right,c__Left) ).

fof(mergeA3470,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object) )
     => ( p__orientation(OBJ1,OBJ2,c__Right)
      <=> p__orientation(OBJ2,OBJ1,c__Left) ) ) ).

fof(mergeA3471,axiom,
    p__d__instance(c__Near,c__SymmetricPositionalAttribute) ).

fof(mergeA3472,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__Near) )
     => ~ p__connected(OBJ1,OBJ2) ) ).

fof(mergeA3473,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__Near) )
     => p__orientation(OBJ2,OBJ1,c__Near) ) ).

fof(mergeA3474,axiom,
    p__d__instance(c__On,c__AntiSymmetricPositionalAttribute) ).

fof(mergeA3475,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__On) )
     => p__connected(OBJ1,OBJ2) ) ).

fof(mergeA3476,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__On) )
     => p__located(OBJ1,OBJ2) ) ).

fof(mergeA3477,axiom,
    ! [OBJ2,OBJ1] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__On) )
     => ~ p__orientation(OBJ2,OBJ1,c__On) ) ).

fof(mergeA3478,axiom,
    p__d__subclass(c__TimeZone,c__RelationalAttribute) ).

fof(mergeA3479,axiom,
    p__d__instance(c__CoordinatedUniversalTimeZone,c__TimeZone) ).

fof(mergeA3480,axiom,
    p__d__instance(c__PacificTimeZone,c__TimeZone) ).

fof(mergeA3481,axiom,
    ! [TIME2,TIME1] :
      ( ( p__d__instance(TIME1,c__TimePosition)
        & p__d__instance(TIME2,c__TimePosition)
        & f__RelativeTimeFn2(TIME1,c__PacificTimeZone) = TIME2 )
     => TIME2 = f__AdditionFn2(TIME1,c__8) ) ).

fof(mergeA3482,axiom,
    p__d__instance(c__MountainTimeZone,c__TimeZone) ).

fof(mergeA3483,axiom,
    ! [TIME2,TIME1] :
      ( ( p__d__instance(TIME1,c__TimePosition)
        & p__d__instance(TIME2,c__TimePosition)
        & f__RelativeTimeFn2(TIME1,c__MountainTimeZone) = TIME2 )
     => TIME2 = f__AdditionFn2(TIME1,c__7) ) ).

fof(mergeA3484,axiom,
    p__d__instance(c__CentralTimeZone,c__TimeZone) ).

fof(mergeA3485,axiom,
    ! [TIME2,TIME1] :
      ( ( p__d__instance(TIME1,c__TimePosition)
        & p__d__instance(TIME2,c__TimePosition)
        & f__RelativeTimeFn2(TIME1,c__CentralTimeZone) = TIME2 )
     => TIME2 = f__AdditionFn2(TIME1,c__6) ) ).

fof(mergeA3486,axiom,
    p__d__instance(c__EasternTimeZone,c__TimeZone) ).

fof(mergeA3487,axiom,
    ! [TIME2,TIME1] :
      ( ( p__d__instance(TIME1,c__TimePosition)
        & p__d__instance(TIME2,c__TimePosition)
        & f__RelativeTimeFn2(TIME1,c__EasternTimeZone) = TIME2 )
     => TIME2 = f__AdditionFn2(TIME1,c__5) ) ).

fof(mergeA3488,axiom,
    p__d__instance(c__RelativeTimeFn,c__BinaryFunction) ).

fof(mergeA3489,axiom,
    p__d__instance(c__RelativeTimeFn,c__TemporalRelation) ).

fof(mergeA3490,axiom,
    p__d__instance(c__RelativeTimeFn,c__TotalValuedRelation) ).

fof(mergeA3494,axiom,
    p__d__subclass(c__SocialRole,c__RelationalAttribute) ).

fof(mergeA3495,axiom,
    ! [ATTRIBUTE,PERSON] :
      ( ( p__d__instance(PERSON,c__Object)
        & p__attribute(PERSON,ATTRIBUTE)
        & p__d__instance(ATTRIBUTE,c__SocialRole) )
     => p__d__instance(PERSON,c__Human) ) ).

fof(mergeA3496,axiom,
    p__d__instance(c__Unemployed,c__SocialRole) ).

fof(mergeA3497,axiom,
    ! [PERSON] :
      ( p__d__instance(PERSON,c__CognitiveAgent)
     => ( ( p__d__instance(PERSON,c__Human)
          & ! [ORG] :
              ( p__d__instance(ORG,c__Organization)
             => ~ p__employs(ORG,PERSON) ) )
      <=> p__attribute(PERSON,c__Unemployed) ) ) ).

fof(mergeA3498,axiom,
    p__d__subclass(c__Position,c__SocialRole) ).

fof(mergeA3499,axiom,
    p__d__instance(c__occupiesPosition,c__TernaryPredicate) ).

fof(mergeA3503,axiom,
    ! [ORG,AGENT,POSITION] :
      ( ( p__d__instance(ORG,c__Organization)
        & p__d__instance(POSITION,c__Position)
        & p__d__instance(AGENT,c__Human)
        & p__occupiesPosition(AGENT,POSITION,ORG) )
     => p__attribute(AGENT,POSITION) ) ).

fof(mergeA3504,axiom,
    ! [PERSON,ORG] :
      ( ( p__d__instance(PERSON,c__Human)
        & p__d__instance(ORG,c__Organization)
        & p__employs(ORG,PERSON) )
     => ? [POSITION] :
          ( p__d__instance(POSITION,c__Position)
          & p__occupiesPosition(PERSON,POSITION,ORG) ) ) ).

fof(mergeA3505,axiom,
    ! [POSITION,PERSON,ORGANIZATION] :
      ( ( p__d__instance(ORGANIZATION,c__Organization)
        & p__d__instance(POSITION,c__Position)
        & p__d__instance(PERSON,c__Human)
        & p__occupiesPosition(PERSON,POSITION,ORGANIZATION) )
     => p__member(PERSON,ORGANIZATION) ) ).

fof(mergeA3506,axiom,
    p__d__subclass(c__NormativeAttribute,c__RelationalAttribute) ).

fof(mergeA3507,axiom,
    p__d__instance(c__modalAttribute,c__BinaryPredicate) ).

fof(mergeA3508,axiom,
    p__d__instance(c__modalAttribute,c__AsymmetricRelation) ).

fof(mergeA3509,axiom,
    p__d__instance(c__modalAttribute,c__IrreflexiveRelation) ).

fof(mergeA3510,axiom,
    p__subrelation(c__modalAttribute,c__property) ).

fof(mergeA3513,axiom,
    ! [FORMULA1,FORMULA2,PROP] :
      ( ( p__d__instance(PROP,c__NormativeAttribute)
        & p__d__instance(FORMULA1,c__Formula)
        & p__d__instance(FORMULA2,c__Formula)
        & p__modalAttribute(FORMULA1,PROP)
        & p__entails(FORMULA1,FORMULA2) )
     => p__modalAttribute(FORMULA2,PROP) ) ).

fof(mergeA3514,axiom,
    ! [FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__modalAttribute(FORMULA,c__Permission) )
     => p__modalAttribute(FORMULA,c__Possibility) ) ).

fof(mergeA3515,axiom,
    p__d__subclass(c__SubjectiveAssessmentAttribute,c__NormativeAttribute) ).

fof(mergeA3516,axiom,
    p__d__disjoint(c__SubjectiveAssessmentAttribute,c__ObjectiveNorm) ).

fof(mergeA3517,axiom,
    p__d__subclass(c__ObjectiveNorm,c__NormativeAttribute) ).

fof(mergeA3518,axiom,
    p__d__subclass(c__ContestAttribute,c__ObjectiveNorm) ).

fof(mergeA3519,axiom,
    p__d__subclass(c__AlethicAttribute,c__ObjectiveNorm) ).

fof(mergeA3520,axiom,
    p__d__instance(c__Possibility,c__AlethicAttribute) ).

fof(mergeA3521,axiom,
    p__d__instance(c__Necessity,c__AlethicAttribute) ).

fof(mergeA3523,axiom,
    ! [FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__modalAttribute(FORMULA,c__Necessity) )
     => p__modalAttribute(FORMULA,c__Possibility) ) ).

fof(mergeA3524,axiom,
    p__d__instance(c__holdsRight,c__BinaryPredicate) ).

fof(mergeA3525,axiom,
    p__d__instance(c__holdsRight,c__AsymmetricRelation) ).

fof(mergeA3528,axiom,
    p__d__instance(c__confersRight,c__TernaryPredicate) ).

fof(mergeA3532,axiom,
    ! [AGENT1,FORMULA,AGENT2] :
      ( ( p__d__instance(AGENT2,c__CognitiveAgent)
        & p__d__instance(FORMULA,c__Formula)
        & p__confersRight(FORMULA,AGENT1,AGENT2) )
     => p__holdsRight(FORMULA,AGENT2) ) ).

fof(mergeA3533,axiom,
    p__d__instance(c__holdsObligation,c__BinaryPredicate) ).

fof(mergeA3534,axiom,
    p__d__instance(c__holdsObligation,c__AsymmetricRelation) ).

fof(mergeA3537,axiom,
    p__relatedInternalConcept(c__holdsObligation,c__holdsRight) ).

fof(mergeA3538,axiom,
    p__d__instance(c__confersObligation,c__TernaryPredicate) ).

fof(mergeA3542,axiom,
    p__relatedInternalConcept(c__confersObligation,c__confersRight) ).

fof(mergeA3543,axiom,
    ! [AGENT1,FORMULA,AGENT2] :
      ( ( p__d__instance(AGENT2,c__CognitiveAgent)
        & p__d__instance(FORMULA,c__Formula)
        & p__confersObligation(FORMULA,AGENT1,AGENT2) )
     => p__holdsObligation(FORMULA,AGENT2) ) ).

fof(mergeA3544,axiom,
    p__d__subclass(c__DeonticAttribute,c__ObjectiveNorm) ).

fof(mergeA3545,axiom,
    p__d__instance(c__Permission,c__DeonticAttribute) ).

fof(mergeA3546,axiom,
    p__d__instance(c__Obligation,c__DeonticAttribute) ).

fof(mergeA3548,axiom,
    ! [FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__modalAttribute(FORMULA,c__Obligation) )
     => p__modalAttribute(FORMULA,c__Permission) ) ).

fof(mergeA3549,axiom,
    p__subAttribute(c__Law,c__Obligation) ).

fof(mergeA3550,axiom,
    p__d__instance(c__Law,c__DeonticAttribute) ).

fof(mergeA3551,axiom,
    p__subAttribute(c__Promise,c__Obligation) ).

fof(mergeA3552,axiom,
    p__d__instance(c__Prohibition,c__DeonticAttribute) ).

fof(mergeA3553,axiom,
    ! [FORMULA] :
      ( p__d__instance(FORMULA,c__Formula)
     => ( p__modalAttribute(FORMULA,c__Prohibition)
      <=> ~ p__modalAttribute(FORMULA,c__Permission) ) ) ).

fof(mergeA3554,axiom,
    p__d__subclass(c__ProbabilityAttribute,c__ObjectiveNorm) ).

fof(mergeA3555,axiom,
    p__d__instance(c__Likely,c__ProbabilityAttribute) ).

fof(mergeA3556,axiom,
    p__contraryAttribute2(c__Likely,c__Unlikely) ).

fof(mergeA3558,axiom,
    p__d__instance(c__Unlikely,c__ProbabilityAttribute) ).

fof(mergeA3560,axiom,
    p__d__subclass(c__PhysicalState,c__InternalAttribute) ).

fof(mergeA3561,axiom,
    p__contraryAttribute4(c__Solid,c__Liquid,c__Gas,c__Plasma) ).

fof(mergeA3563,axiom,
    p__d__instance(c__Solid,c__PhysicalState) ).

fof(mergeA3564,axiom,
    p__d__instance(c__Fluid,c__PhysicalState) ).

fof(mergeA3565,axiom,
    p__d__instance(c__Liquid,c__PhysicalState) ).

fof(mergeA3566,axiom,
    p__subAttribute(c__Liquid,c__Fluid) ).

fof(mergeA3567,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Solution)
     => p__attribute(OBJ,c__Liquid) ) ).

fof(mergeA3568,axiom,
    p__d__instance(c__Gas,c__PhysicalState) ).

fof(mergeA3569,axiom,
    p__subAttribute(c__Gas,c__Fluid) ).

fof(mergeA3570,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Object)
     => ( p__d__instance(OBJ,c__Substance)
      <=> ? [ATTR] :
            ( p__d__instance(ATTR,c__PhysicalState)
            & p__attribute(OBJ,ATTR) ) ) ) ).

fof(mergeA3571,axiom,
    p__d__instance(c__Plasma,c__PhysicalState) ).

fof(mergeA3572,axiom,
    p__subAttribute(c__Plasma,c__Fluid) ).

fof(mergeA3573,axiom,
    p__d__subclass(c__PerceptualAttribute,c__Attribute) ).

fof(mergeA3574,axiom,
    ! [PERCEPTION,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(PERCEPTION,c__Perception)
        & p__patient(PERCEPTION,OBJ) )
     => ? [PROP] :
          ( p__d__instance(PROP,c__PerceptualAttribute)
          & p__attribute(OBJ,PROP) ) ) ).

fof(mergeA3575,axiom,
    p__d__subclass(c__TasteAttribute,c__PerceptualAttribute) ).

fof(mergeA3577,axiom,
    p__d__subclass(c__OlfactoryAttribute,c__PerceptualAttribute) ).

fof(mergeA3578,axiom,
    p__d__subclass(c__VisualAttribute,c__PerceptualAttribute) ).

fof(mergeA3579,axiom,
    p__d__instance(c__Illuminated,c__VisualAttribute) ).

fof(mergeA3580,axiom,
    p__d__instance(c__Unilluminated,c__VisualAttribute) ).

fof(mergeA3581,axiom,
    p__contraryAttribute2(c__Unilluminated,c__Illuminated) ).

fof(mergeA3582,axiom,
    p__d__subclass(c__ColorAttribute,c__VisualAttribute) ).

fof(mergeA3583,axiom,
    p__d__subclass(c__PrimaryColor,c__ColorAttribute) ).

fof(mergeA3584,axiom,
    p__d__instance(c__Red,c__PrimaryColor) ).

fof(mergeA3585,axiom,
    p__d__instance(c__Blue,c__PrimaryColor) ).

fof(mergeA3586,axiom,
    p__d__instance(c__Yellow,c__PrimaryColor) ).

fof(mergeA3587,axiom,
    p__d__instance(c__White,c__PrimaryColor) ).

fof(mergeA3588,axiom,
    p__d__instance(c__Black,c__PrimaryColor) ).

fof(mergeA3589,axiom,
    p__d__instance(c__Monochromatic,c__ColorAttribute) ).

fof(mergeA3590,axiom,
    ! [PART,OBJ,COLOR,ELEMENT] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(PART,c__Object)
        & p__d__instance(ELEMENT,c__Object)
        & p__attribute(OBJ,c__Monochromatic)
        & p__superficialPart(PART,OBJ)
        & p__attribute(PART,COLOR)
        & p__d__instance(COLOR,c__PrimaryColor)
        & p__superficialPart(ELEMENT,OBJ) )
     => p__attribute(ELEMENT,COLOR) ) ).

fof(mergeA3591,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Object)
     => ( p__attribute(OBJ,c__Monochromatic)
        | p__attribute(OBJ,c__Polychromatic) ) ) ).

fof(mergeA3592,axiom,
    p__d__instance(c__Polychromatic,c__ColorAttribute) ).

fof(mergeA3593,axiom,
    p__contraryAttribute2(c__Polychromatic,c__Monochromatic) ).

fof(mergeA3594,axiom,
    ! [OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__attribute(OBJ,c__Polychromatic) )
     => ? [PART1,PART2,COLOR1,COLOR2] :
          ( p__d__instance(PART1,c__Object)
          & p__d__instance(PART2,c__Object)
          & p__superficialPart(PART1,OBJ)
          & p__superficialPart(PART2,OBJ)
          & p__attribute(PART1,COLOR1)
          & p__attribute(PART2,COLOR2)
          & p__d__instance(COLOR1,c__ColorAttribute)
          & p__d__instance(COLOR2,c__ColorAttribute)
          & COLOR1 != COLOR2 ) ) ).

fof(mergeA3595,axiom,
    p__d__subclass(c__StructureAttribute,c__InternalAttribute) ).

fof(mergeA3596,axiom,
    p__d__subclass(c__ShapeAttribute,c__StructureAttribute) ).

fof(mergeA3597,axiom,
    ! [OBJ,SURFACE,ATTRIBUTE] :
      ( ( p__d__instance(OBJ,c__SelfConnectedObject)
        & p__d__instance(SURFACE,c__SelfConnectedObject)
        & p__d__instance(ATTRIBUTE,c__ShapeAttribute)
        & p__attribute(OBJ,ATTRIBUTE)
        & p__surface(SURFACE,OBJ) )
     => p__attribute(SURFACE,ATTRIBUTE) ) ).

fof(mergeA3598,axiom,
    p__d__instance(c__Pliable,c__InternalAttribute) ).

fof(mergeA3599,axiom,
    ! [OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__attribute(OBJ,c__Pliable) )
     => ? [CHANGE] :
          ( p__d__instance(CHANGE,c__ShapeChange)
          & p__patient(CHANGE,OBJ) ) ) ).

fof(mergeA3600,axiom,
    p__d__instance(c__Rigid,c__InternalAttribute) ).

fof(mergeA3601,axiom,
    p__contraryAttribute2(c__Rigid,c__Pliable) ).

fof(mergeA3602,axiom,
    p__d__subclass(c__TextureAttribute,c__PerceptualAttribute) ).

fof(mergeA3603,axiom,
    ! [OBJ,SURFACE,ATTRIBUTE] :
      ( ( p__d__instance(OBJ,c__SelfConnectedObject)
        & p__d__instance(SURFACE,c__SelfConnectedObject)
        & p__d__instance(ATTRIBUTE,c__TextureAttribute)
        & p__attribute(OBJ,ATTRIBUTE)
        & p__surface(SURFACE,OBJ) )
     => p__attribute(SURFACE,ATTRIBUTE) ) ).

fof(mergeA3604,axiom,
    p__d__instance(c__Smooth,c__TextureAttribute) ).

fof(mergeA3605,axiom,
    p__d__instance(c__Rough,c__TextureAttribute) ).

fof(mergeA3606,axiom,
    p__contraryAttribute2(c__Smooth,c__Rough) ).

fof(mergeA3607,axiom,
    p__d__subclass(c__GeometricFigure,c__ShapeAttribute) ).

fof(mergeA3608,axiom,
    p__d__partition5(c__GeometricFigure,c__GeometricPoint,c__OneDimensionalFigure,c__TwoDimensionalFigure,c__ThreeDimensionalFigure) ).

fof(mergeA3609,axiom,
    p__d__subclass(c__GeometricPoint,c__GeometricFigure) ).

fof(mergeA3610,axiom,
    p__d__subclass(c__OneDimensionalFigure,c__GeometricFigure) ).

fof(mergeA3611,axiom,
    p__d__subclass(c__TwoDimensionalFigure,c__GeometricFigure) ).

fof(mergeA3612,axiom,
    p__d__partition3(c__TwoDimensionalFigure,c__OpenTwoDimensionalFigure,c__ClosedTwoDimensionalFigure) ).

fof(mergeA3613,axiom,
    p__d__subclass(c__OpenTwoDimensionalFigure,c__TwoDimensionalFigure) ).

fof(mergeA3614,axiom,
    p__d__subclass(c__TwoDimensionalAngle,c__OpenTwoDimensionalFigure) ).

fof(mergeA3615,axiom,
    p__d__subclass(c__ClosedTwoDimensionalFigure,c__TwoDimensionalFigure) ).

fof(mergeA3616,axiom,
    p__d__subclass(c__ThreeDimensionalFigure,c__GeometricFigure) ).

fof(mergeA3617,axiom,
    p__d__instance(c__geometricPart,c__BinaryPredicate) ).

fof(mergeA3618,axiom,
    p__d__instance(c__geometricPart,c__PartialOrderingRelation) ).

fof(mergeA3621,axiom,
    p__subrelation(c__pointOfFigure,c__geometricPart) ).

fof(mergeA3624,axiom,
    p__subrelation(c__angleOfFigure,c__geometricPart) ).

fof(mergeA3627,axiom,
    p__d__instance(c__pointOfIntersection,c__TernaryPredicate) ).

fof(mergeA3631,axiom,
    ! [FIGURE1,POINT,FIGURE2] :
      ( ( p__d__instance(POINT,c__GeometricPoint)
        & p__d__instance(FIGURE2,c__OneDimensionalFigure)
        & p__d__instance(FIGURE1,c__OneDimensionalFigure)
        & p__pointOfIntersection(FIGURE1,FIGURE2,POINT) )
     => ( p__pointOfFigure(POINT,FIGURE1)
        & p__pointOfFigure(POINT,FIGURE2) ) ) ).

fof(mergeA3632,axiom,
    p__d__instance(c__parallel,c__BinaryPredicate) ).

fof(mergeA3635,axiom,
    ! [LINE1,LINE2] :
      ( ( p__d__instance(LINE2,c__OneDimensionalFigure)
        & p__d__instance(LINE1,c__OneDimensionalFigure)
        & p__parallel(LINE1,LINE2) )
     => ! [POINT] :
          ( ~ p__d__instance(POINT,c__GeometricPoint)
          | ~ p__pointOfIntersection(LINE1,LINE2,POINT) ) ) ).

fof(mergeA3636,axiom,
    p__d__instance(c__angularMeasure,c__BinaryPredicate) ).

fof(mergeA3637,axiom,
    p__d__instance(c__angularMeasure,c__TotalValuedRelation) ).

fof(mergeA3640,axiom,
    p__d__instance(c__lineMeasure,c__BinaryPredicate) ).

fof(mergeA3641,axiom,
    p__d__instance(c__lineMeasure,c__TotalValuedRelation) ).

fof(mergeA3644,axiom,
    p__d__instance(c__geometricDistance,c__TernaryPredicate) ).

fof(mergeA3645,axiom,
    p__d__instance(c__geometricDistance,c__SingleValuedRelation) ).

fof(mergeA3646,axiom,
    p__d__instance(c__geometricDistance,c__TotalValuedRelation) ).

fof(mergeA3650,axiom,
    ! [POINT2,POINT1,LENGTH] :
      ( ( p__d__instance(LENGTH,c__LengthMeasure)
        & p__d__instance(POINT2,c__GeometricPoint)
        & p__d__instance(POINT1,c__GeometricPoint)
        & p__geometricDistance(POINT1,POINT2,LENGTH) )
     => p__geometricDistance(POINT2,POINT1,LENGTH) ) ).

fof(mergeA3651,axiom,
    p__d__subclass(c__SaturationAttribute,c__InternalAttribute) ).

fof(mergeA3652,axiom,
    p__d__instance(c__Dry,c__SaturationAttribute) ).

fof(mergeA3653,axiom,
    p__contraryAttribute2(c__Dry,c__Damp) ).

fof(mergeA3654,axiom,
    ! [OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__attribute(OBJ,c__Dry) )
     => ! [SUBOBJ] :
          ( ~ p__d__instance(SUBOBJ,c__Object)
          | ~ p__part(SUBOBJ,OBJ)
          | ~ p__attribute(SUBOBJ,c__Liquid) ) ) ).

fof(mergeA3655,axiom,
    p__d__instance(c__Damp,c__SaturationAttribute) ).

fof(mergeA3656,axiom,
    p__d__instance(c__Wet,c__SaturationAttribute) ).

fof(mergeA3657,axiom,
    p__subAttribute(c__Wet,c__Damp) ).

fof(mergeA3658,axiom,
    ! [OBJ,PART] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(PART,c__Object)
        & p__attribute(OBJ,c__Wet)
        & p__part(PART,OBJ) )
     => ? [SUBPART] :
          ( p__d__instance(SUBPART,c__Object)
          & p__part(SUBPART,PART)
          & p__attribute(SUBPART,c__Liquid) ) ) ).

fof(mergeA3659,axiom,
    p__d__subclass(c__BiologicalAttribute,c__InternalAttribute) ).

fof(mergeA3660,axiom,
    ! [ATT,ORG] :
      ( ( p__d__instance(ORG,c__Object)
        & p__attribute(ORG,ATT)
        & p__d__instance(ATT,c__BiologicalAttribute) )
     => p__d__instance(ORG,c__OrganicObject) ) ).

fof(mergeA3661,axiom,
    p__d__subclass(c__BodyPosition,c__BiologicalAttribute) ).

fof(mergeA3662,axiom,
    ! [ANIMAL] :
      ( p__d__instance(ANIMAL,c__Animal)
     => ( ? [MOTION] :
            ( p__d__instance(MOTION,c__BodyMotion)
            & p__agent(MOTION,ANIMAL) )
        | ? [ATTR] :
            ( p__d__instance(ATTR,c__BodyPosition)
            & p__attribute(ANIMAL,ATTR) ) ) ) ).

fof(mergeA3663,axiom,
    p__d__instance(c__Standing,c__BodyPosition) ).

fof(mergeA3664,axiom,
    ! [AMBULATE,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(AMBULATE,c__Ambulating)
        & p__agent(AMBULATE,AGENT) )
     => p__attribute(AGENT,c__Standing) ) ).

fof(mergeA3665,axiom,
    p__d__instance(c__Sitting,c__BodyPosition) ).

fof(mergeA3666,axiom,
    p__d__instance(c__Prostrate,c__BodyPosition) ).

fof(mergeA3667,axiom,
    p__d__subclass(c__AnimacyAttribute,c__BiologicalAttribute) ).

fof(mergeA3669,axiom,
    p__d__instance(c__Living,c__AnimacyAttribute) ).

fof(mergeA3671,axiom,
    p__d__instance(c__Dead,c__AnimacyAttribute) ).

fof(mergeA3672,axiom,
    p__contraryAttribute2(c__Dead,c__Living) ).

fof(mergeA3673,axiom,
    ! [ORG] :
      ( p__d__instance(ORG,c__Object)
     => ( p__d__instance(ORG,c__Organism)
      <=> ? [ATTR] :
            ( p__d__instance(ATTR,c__AnimacyAttribute)
            & p__attribute(ORG,ATTR) ) ) ) ).

fof(mergeA3674,axiom,
    p__d__subclass(c__SexAttribute,c__BiologicalAttribute) ).

fof(mergeA3676,axiom,
    p__d__instance(c__Female,c__SexAttribute) ).

fof(mergeA3677,axiom,
    ! [BODY,ORG] :
      ( ( p__d__instance(BODY,c__ReproductiveBody)
        & p__part(BODY,ORG)
        & p__d__instance(ORG,c__Organism) )
     => p__attribute(ORG,c__Female) ) ).

fof(mergeA3678,axiom,
    p__d__instance(c__Male,c__SexAttribute) ).

fof(mergeA3679,axiom,
    p__contraryAttribute2(c__Male,c__Female) ).

fof(mergeA3680,axiom,
    ! [ANIMAL] :
      ( p__d__instance(ANIMAL,c__Animal)
     => ? [ATTR] :
          ( p__d__instance(ATTR,c__SexAttribute)
          & p__attribute(ANIMAL,ATTR) ) ) ).

fof(mergeA3681,axiom,
    p__d__subclass(c__DevelopmentalAttribute,c__BiologicalAttribute) ).

fof(mergeA3683,axiom,
    p__d__instance(c__FullyFormed,c__DevelopmentalAttribute) ).

fof(mergeA3685,axiom,
    p__d__instance(c__NonFullyFormed,c__DevelopmentalAttribute) ).

fof(mergeA3686,axiom,
    p__contraryAttribute2(c__NonFullyFormed,c__FullyFormed) ).

fof(mergeA3687,axiom,
    p__successorAttribute(c__NonFullyFormed,c__FullyFormed) ).

fof(mergeA3688,axiom,
    ! [ORG] :
      ( p__d__instance(ORG,c__Organism)
     => ? [ATTR] :
          ( p__d__instance(ATTR,c__DevelopmentalAttribute)
          & p__attribute(ORG,ATTR) ) ) ).

fof(mergeA3689,axiom,
    p__subAttribute(c__Larval,c__NonFullyFormed) ).

fof(mergeA3691,axiom,
    p__subAttribute(c__Embryonic,c__NonFullyFormed) ).

fof(mergeA3692,axiom,
    p__contraryAttribute2(c__Embryonic,c__Larval) ).

fof(mergeA3693,axiom,
    ! [ORG] :
      ( ( p__d__instance(ORG,c__Object)
        & p__attribute(ORG,c__Embryonic) )
     => ? [BODY] :
          ( p__d__instance(BODY,c__ReproductiveBody)
          & p__located(ORG,BODY) ) ) ).

fof(mergeA3695,axiom,
    p__d__subclass(c__DiseaseOrSyndrome,c__BiologicalAttribute) ).

fof(mergeA3696,axiom,
    p__d__subclass(c__PsychologicalAttribute,c__BiologicalAttribute) ).

fof(mergeA3697,axiom,
    p__d__partition3(c__PsychologicalAttribute,c__StateOfMind,c__TraitAttribute) ).

fof(mergeA3699,axiom,
    ! [ATTR,AGENT] :
      ( ( p__d__instance(AGENT,c__Object)
        & p__d__instance(ATTR,c__PsychologicalAttribute)
        & p__attribute(AGENT,ATTR) )
     => p__d__instance(AGENT,c__SentientAgent) ) ).

fof(mergeA3700,axiom,
    p__d__subclass(c__StateOfMind,c__PsychologicalAttribute) ).

fof(mergeA3701,axiom,
    p__d__subclass(c__EmotionalState,c__StateOfMind) ).

fof(mergeA3702,axiom,
    p__d__subclass(c__ConsciousnessAttribute,c__StateOfMind) ).

fof(mergeA3703,axiom,
    ! [AGENT] :
      ( p__d__instance(AGENT,c__Object)
     => ( ( p__d__instance(AGENT,c__SentientAgent)
          & p__attribute(AGENT,c__Living) )
      <=> ? [ATTR] :
            ( p__d__instance(ATTR,c__ConsciousnessAttribute)
            & p__attribute(AGENT,ATTR) ) ) ) ).

fof(mergeA3704,axiom,
    p__d__instance(c__Asleep,c__ConsciousnessAttribute) ).

fof(mergeA3705,axiom,
    p__d__instance(c__Unconscious,c__ConsciousnessAttribute) ).

fof(mergeA3706,axiom,
    p__contraryAttribute2(c__Unconscious,c__Awake) ).

fof(mergeA3707,axiom,
    p__d__instance(c__Awake,c__ConsciousnessAttribute) ).

fof(mergeA3708,axiom,
    ! [AGENT] :
      ( ( p__d__instance(AGENT,c__Object)
        & ( p__attribute(AGENT,c__Asleep)
          | p__attribute(AGENT,c__Awake) ) )
     => p__attribute(AGENT,c__Living) ) ).

fof(mergeA3709,axiom,
    p__d__subclass(c__TraitAttribute,c__PsychologicalAttribute) ).

fof(mergeA3710,axiom,
    p__d__subclass(c__PsychologicalDysfunction,c__PsychologicalAttribute) ).

fof(mergeA3711,axiom,
    p__d__subclass(c__PsychologicalDysfunction,c__DiseaseOrSyndrome) ).

fof(mergeA3712,axiom,
    p__d__instance(c__comment,c__TernaryPredicate) ).

fof(miloA1,axiom,
    p__d__subclass(c__OrganismRemains,c__OrganicObject) ).

fof(miloA4,axiom,
    ! [ORG,DEATH,REM] :
      ( ( p__d__instance(REM,c__OrganicObject)
        & p__d__instance(DEATH,c__Death)
        & p__d__instance(ORG,c__Organism)
        & p__experiencer(DEATH,ORG)
        & p__result(DEATH,REM) )
     => p__d__instance(REM,c__OrganismRemains) ) ).

fof(miloA5,axiom,
    ! [REM] :
      ( p__d__instance(REM,c__OrganismRemains)
     => ? [DEATH] :
          ( p__d__instance(DEATH,c__Death)
          & p__result(DEATH,REM) ) ) ).

fof(miloA9,axiom,
    p__d__subclass(c__HumanCorpse,c__OrganismRemains) ).

fof(miloA11,axiom,
    p__d__instance(c__DeadFn,c__UnaryFunction) ).

fof(miloA16,axiom,
    p__d__instance(c__HumanSlave,c__SocialRole) ).

fof(miloA18,axiom,
    p__d__subclass(c__HumanAdult,c__Human) ).

fof(miloA19,axiom,
    p__d__subclass(c__HumanAdult,c__LegalAgent) ).

fof(miloA26,axiom,
    p__d__subclass(c__HumanYouth,c__Human) ).

fof(miloA30,axiom,
    p__d__subclass(c__HumanChild,c__HumanYouth) ).

fof(miloA36,axiom,
    p__d__subclass(c__Teenager,c__Human) ).

fof(miloA40,axiom,
    p__d__subclass(c__Boy,c__HumanChild) ).

fof(miloA41,axiom,
    p__d__subclass(c__Boy,c__Man) ).

fof(miloA43,axiom,
    p__d__subclass(c__Girl,c__HumanChild) ).

fof(miloA44,axiom,
    p__d__subclass(c__Girl,c__Woman) ).

fof(miloA46,axiom,
    p__d__subclass(c__HumanBaby,c__HumanChild) ).

fof(miloA50,axiom,
    p__d__instance(c__older,c__BinaryPredicate) ).

fof(miloA54,axiom,
    p__d__instance(c__StartFn,c__UnaryFunction) ).

fof(miloA58,axiom,
    p__d__instance(c__StopFn,c__UnaryFunction) ).

fof(miloA62,axiom,
    p__d__subclass(c__Dodging,c__BodyMotion) ).

fof(miloA63,axiom,
    p__d__subclass(c__Dodging,c__IntentionalProcess) ).

fof(miloA65,axiom,
    p__d__subclass(c__Mounting,c__BodyMotion) ).

fof(miloA67,axiom,
    p__d__subclass(c__Stepping,c__BodyMotion) ).

fof(miloA68,axiom,
    ! [AMBULATE,DURATION] :
      ( ( p__d__instance(DURATION,c__TimeInterval)
        & p__d__instance(AMBULATE,c__Ambulating)
        & DURATION = f__WhenFn1(AMBULATE) )
     => ? [STEP1,STEPN] :
          ( p__d__instance(STEP1,c__Stepping)
          & p__d__instance(STEPN,c__Stepping)
          & p__subProcess(STEP1,AMBULATE)
          & p__subProcess(STEPN,AMBULATE)
          & p__starts(f__WhenFn1(STEP1),DURATION)
          & p__finishes(f__WhenFn1(STEPN),DURATION)
          & STEP1 != STEPN ) ) ).

fof(miloA69,axiom,
    ! [A,S2START,S1START,S1,S2] :
      ( ( p__d__instance(S1START,c__TimePoint)
        & p__d__instance(S2START,c__TimePoint)
        & p__d__instance(A,c__Ambulating)
        & p__subProcess(S1,A)
        & p__d__instance(S1,c__Stepping)
        & p__subProcess(S2,A)
        & p__d__instance(S2,c__Stepping)
        & S1START = f__BeginFn1(f__WhenFn1(S1))
        & S2START = f__BeginFn1(f__WhenFn1(S2))
        & ~ p__before(S1START,S2START)
        & ~ p__before(S2START,S1START) )
     => S1 = S2 ) ).

fof(miloA70,axiom,
    ! [AMBULATE,STEP,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(AMBULATE,c__Ambulating)
        & p__d__instance(STEP,c__Stepping)
        & p__subProcess(STEP,AMBULATE)
        & p__agent(AMBULATE,AGENT) )
     => p__agent(STEP,AGENT) ) ).

fof(miloA71,axiom,
    ! [STEP,AMBULATE,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(AMBULATE,c__Ambulating)
        & p__d__instance(STEP,c__Stepping)
        & p__subProcess(STEP,AMBULATE)
        & p__agent(STEP,AGENT) )
     => p__agent(AMBULATE,AGENT) ) ).

fof(miloA72,axiom,
    p__d__subclass(c__Wading,c__Walking) ).

fof(miloA73,axiom,
    ! [P] :
      ( p__d__instance(P,c__Wading)
     => ? [W] :
          ( p__d__instance(W,c__WaterArea)
          & p__eventLocated(P,W) ) ) ).

fof(miloA74,axiom,
    p__d__subclass(c__Jumping,c__BodyMotion) ).

fof(miloA75,axiom,
    p__d__subclass(c__Jumping,c__MotionUpward) ).

fof(miloA77,axiom,
    p__d__subclass(c__Somersaulting,c__BodyMotion) ).

fof(miloA79,axiom,
    p__d__subclass(c__Reflecting,c__Radiating) ).

fof(miloA80,axiom,
    p__d__subclass(c__ReflectingLight,c__Reflecting) ).

fof(miloA81,axiom,
    p__d__subclass(c__ReflectingLight,c__RadiatingLight) ).

fof(miloA82,axiom,
    p__d__instance(c__wavelength,c__SingleValuedRelation) ).

fof(miloA85,axiom,
    p__subrelation(c__wavelength,c__measure) ).

fof(miloA86,axiom,
    p__d__subclass(c__RadiatingInfrared,c__Radiating) ).

fof(miloA87,axiom,
    p__d__disjoint(c__RadiatingInfrared,c__RadiatingLight) ).

fof(miloA88,axiom,
    p__d__disjoint(c__RadiatingInfrared,c__RadioEmission) ).

fof(miloA89,axiom,
    p__d__subclass(c__RadiatingUltraviolet,c__RadiatingElectromagnetic) ).

fof(miloA90,axiom,
    p__d__disjoint(c__RadiatingUltraviolet,c__RadiatingLight) ).

fof(miloA91,axiom,
    p__d__disjoint(c__RadiatingUltraviolet,c__XRayRadiation) ).

fof(miloA92,axiom,
    p__d__subclass(c__XRayRadiation,c__Radiating) ).

fof(miloA93,axiom,
    p__d__subclass(c__RadiatingVisibleLight,c__RadiatingLight) ).

fof(miloA94,axiom,
    p__d__disjoint(c__RadiatingVisibleLight,c__RadiatingUltraviolet) ).

fof(miloA95,axiom,
    ! [H,S,R] :
      ( ( p__d__instance(R,c__RadiatingLight)
        & p__d__instance(H,c__Human)
        & p__d__instance(S,c__Seeing)
        & p__agent(S,H)
        & p__patient(S,R) )
     => p__d__instance(R,c__RadiatingVisibleLight) ) ).

fof(miloA96,axiom,
    p__d__subclass(c__Sunlight,c__RadiatingLight) ).

fof(miloA97,axiom,
    p__d__subclass(c__RadioReceiver,c__ReceiverDevice) ).

fof(miloA98,axiom,
    p__d__subclass(c__Script,c__Collection) ).

fof(miloA99,axiom,
    ! [W] :
      ( p__d__instance(W,c__WrittenCommunication)
     => ? [T,C,S] :
          ( p__result(W,T)
          & p__d__instance(T,c__Text)
          & p__part(C,T)
          & p__d__instance(C,c__Character)
          & p__d__instance(S,c__Script)
          & p__member(C,S) ) ) ).

fof(miloA100,axiom,
    p__d__subclass(c__Orthography,c__Procedure) ).

fof(miloA101,axiom,
    p__d__subclass(c__Lyrics,c__Text) ).

fof(miloA103,axiom,
    p__d__subclass(c__Paragraph,c__Text) ).

fof(miloA104,axiom,
    ! [T] :
      ( p__d__instance(T,c__Paragraph)
     => ? [S] :
          ( p__d__instance(S,c__Object)
          & p__d__instance(S,c__Sentence)
          & p__part(S,T) ) ) ).

fof(miloA107,axiom,
    p__subrelation(c__sententialObject,c__grammaticalRelation) ).

fof(miloA110,axiom,
    p__subrelation(c__sententialSubject,c__grammaticalRelation) ).

fof(miloA111,axiom,
    p__d__instance(c__speaksLanguage,c__BinaryPredicate) ).

fof(miloA114,axiom,
    p__d__instance(c__MonophonicMusic,c__RelationalAttribute) ).

fof(miloA115,axiom,
    p__d__instance(c__PolyphonicMusic,c__RelationalAttribute) ).

fof(miloA116,axiom,
    p__d__subclass(c__MusicalTone,c__RadiatingSound) ).

fof(miloA117,axiom,
    p__d__subclass(c__RadiatingSoundUltrasonic,c__RadiatingSound) ).

fof(miloA118,axiom,
    p__d__instance(c__soundFrequency,c__BinaryPredicate) ).

fof(miloA121,axiom,
    p__d__subclass(c__WrittenCommunication,c__LinguisticCommunication) ).

fof(miloA122,axiom,
    p__d__subclass(c__Corresponding,c__LinguisticCommunication) ).

fof(miloA123,axiom,
    ! [C] :
      ( p__d__instance(C,c__Corresponding)
     => ? [M,T] :
          ( p__d__instance(M,c__Mailing)
          & p__subProcess(M,C)
          & p__d__instance(T,c__Text)
          & p__patient(M,T)
          & p__patient(C,T) ) ) ).

fof(miloA124,axiom,
    p__d__subclass(c__Reminding,c__Requesting) ).

fof(miloA125,axiom,
    ! [REMIND] :
      ( p__d__instance(REMIND,c__Reminding)
     => ? [REMEMBER] :
          ( p__d__instance(REMEMBER,c__Remembering)
          & p__causes(REMIND,REMEMBER) ) ) ).

fof(miloA126,axiom,
    p__d__subclass(c__Threatening,c__Committing) ).

fof(miloA127,axiom,
    ! [AGENT,THREATEN,DEST,PROP] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(PROP,c__Formula)
        & p__d__instance(DEST,c__CognitiveAgent)
        & p__d__instance(THREATEN,c__Threatening)
        & p__agent(THREATEN,AGENT)
        & p__patient(THREATEN,PROP)
        & p__destination(THREATEN,DEST) )
     => ~ p__desires(DEST,PROP) ) ).

fof(miloA128,axiom,
    p__d__subclass(c__Punishing,c__RegulatoryProcess) ).

fof(miloA130,axiom,
    p__d__subclass(c__Registering,c__Stating) ).

fof(miloA131,axiom,
    p__d__subclass(c__Registering,c__PoliticalProcess) ).

fof(miloA132,axiom,
    ! [ACTION] :
      ( p__d__instance(ACTION,c__LegalAction)
     => ? [REGISTER] :
          ( p__d__instance(REGISTER,c__Registering)
          & p__subProcess(REGISTER,ACTION) ) ) ).

fof(miloA133,axiom,
    p__d__subclass(c__Answering,c__Stating) ).

fof(miloA134,axiom,
    ! [ANSWER] :
      ( p__d__instance(ANSWER,c__Answering)
     => ? [QUESTION] :
          ( p__d__instance(QUESTION,c__Questioning)
          & p__refers(ANSWER,QUESTION)
          & p__earlier(f__WhenFn1(QUESTION),f__WhenFn1(ANSWER)) ) ) ).

fof(miloA135,axiom,
    p__d__subclass(c__Arguing,c__Stating) ).

fof(miloA136,axiom,
    ! [ARGUE] :
      ( p__d__instance(ARGUE,c__Arguing)
     => ? [STATEMENT,ARGUMENT] :
          ( p__patient(ARGUE,STATEMENT)
          & p__d__instance(STATEMENT,c__Statement)
          & p__containsInformation(STATEMENT,ARGUMENT)
          & p__d__instance(ARGUMENT,c__Argument) ) ) ).

fof(miloA137,axiom,
    p__d__subclass(c__TellingALie,c__LinguisticCommunication) ).

fof(miloA139,axiom,
    p__d__subclass(c__Founding,c__Declaring) ).

fof(miloA140,axiom,
    p__d__subclass(c__Founding,c__OrganizationalProcess) ).

fof(miloA141,axiom,
    ! [FOUND] :
      ( p__d__instance(FOUND,c__Founding)
     => ? [ORG] :
          ( p__d__instance(ORG,c__Organization)
          & p__result(FOUND,ORG) ) ) ).

fof(miloA142,axiom,
    p__d__subclass(c__Club,c__Organization) ).

fof(miloA143,axiom,
    ! [CLUB,MEM1,MEM2] :
      ( ( p__d__instance(MEM1,c__SelfConnectedObject)
        & p__d__instance(MEM1,c__CognitiveAgent)
        & p__d__instance(MEM2,c__SelfConnectedObject)
        & p__d__instance(MEM2,c__CognitiveAgent)
        & p__d__instance(CLUB,c__Club)
        & p__member(MEM1,CLUB)
        & p__member(MEM2,CLUB) )
     => ? [DESIRE] :
          ( p__d__instance(DESIRE,c__Formula)
          & p__desires(MEM1,DESIRE)
          & p__desires(MEM2,DESIRE) ) ) ).

fof(miloA144,axiom,
    p__d__instance(c__yearOfFounding,c__BinaryPredicate) ).

fof(miloA145,axiom,
    p__d__instance(c__yearOfFounding,c__AsymmetricRelation) ).

fof(miloA148,axiom,
    ! [O,Y] :
      ( ( p__d__instance(Y,c__Integer)
        & p__d__instance(O,c__Organization)
        & p__yearOfFounding(O,Y) )
     => p__dateEstablished(O,f__YearFn1(Y)) ) ).

fof(miloA150,axiom,
    p__d__instance(c__dateEstablished,c__BinaryPredicate) ).

fof(miloA154,axiom,
    p__d__instance(c__dateUsed,c__TernaryPredicate) ).

fof(miloA158,axiom,
    ! [OBJECT,AGENT,DATE] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(DATE,c__TimePoint)
        & p__d__instance(OBJECT,c__Object)
        & p__dateUsed(OBJECT,DATE,AGENT) )
     => ? [PROCESS] :
          ( p__d__instance(PROCESS,c__Process)
          & p__patient(PROCESS,OBJECT)
          & p__agent(PROCESS,AGENT)
          & p__uses(OBJECT,AGENT)
          & p__temporalPart(DATE,f__WhenFn1(PROCESS)) ) ) ).

fof(miloA159,axiom,
    p__d__subclass(c__Accrediting,c__Declaring) ).

fof(miloA160,axiom,
    ! [A,EO] :
      ( ( p__d__instance(A,c__Accrediting)
        & p__patient(A,EO) )
     => p__d__instance(EO,c__EducationalOrganization) ) ).

fof(miloA161,axiom,
    p__d__subclass(c__Indicating,c__Communication) ).

fof(miloA162,axiom,
    p__d__subclass(c__Indicating,c__BodyMotion) ).

fof(miloA163,axiom,
    p__d__subclass(c__Divorcing,c__Declaring) ).

fof(miloA165,axiom,
    p__d__subclass(c__Appointing,c__Declaring) ).

fof(miloA167,axiom,
    ! [A] :
      ( p__d__instance(A,c__Appointing)
     => ! [H] :
          ( ~ p__d__instance(H,c__Agent)
          | ~ p__agent(A,H)
          | ~ p__d__instance(H,c__Public) ) ) ).

fof(miloA168,axiom,
    p__d__subclass(c__TurningOffDevice,c__InternalChange) ).

fof(miloA170,axiom,
    ! [P,D] :
      ( ( p__d__instance(P,c__TurningOffDevice)
        & p__patient(P,D) )
     => p__d__instance(D,c__Device) ) ).

fof(miloA171,axiom,
    p__d__subclass(c__TurningOnDevice,c__InternalChange) ).

fof(miloA173,axiom,
    ! [P,D] :
      ( ( p__d__instance(P,c__TurningOnDevice)
        & p__patient(P,D) )
     => p__d__instance(D,c__Device) ) ).

fof(miloA174,axiom,
    p__d__subclass(c__Projectile,c__Weapon) ).

fof(miloA175,axiom,
    ! [PROJECTILE] :
      ( p__d__instance(PROJECTILE,c__Projectile)
     => p__capability(c__Shooting,c__patient,PROJECTILE) ) ).

fof(miloA176,axiom,
    p__d__subclass(c__ProjectileShell,c__Container) ).

fof(miloA177,axiom,
    ! [PROJECTILE] :
      ( p__d__instance(PROJECTILE,c__Projectile)
     => ? [SHELL] :
          ( p__d__instance(SHELL,c__ProjectileShell)
          & p__part(SHELL,PROJECTILE) ) ) ).

fof(miloA178,axiom,
    p__d__subclass(c__ProjectileLauncher,c__Weapon) ).

fof(miloA179,axiom,
    ! [L] :
      ( p__d__instance(L,c__ProjectileLauncher)
     => p__capability(c__Shooting,c__instrument,L) ) ).

fof(miloA180,axiom,
    ! [S] :
      ( p__d__instance(S,c__Shooting)
     => ? [P,L] :
          ( p__d__instance(P,c__Projectile)
          & p__patient(S,P)
          & p__d__instance(L,c__ProjectileLauncher)
          & p__instrument(S,L) ) ) ).

fof(miloA181,axiom,
    p__d__subclass(c__Spear,c__Weapon) ).

fof(miloA182,axiom,
    p__d__subclass(c__Sword,c__Weapon) ).

fof(miloA183,axiom,
    p__d__subclass(c__Whip,c__Weapon) ).

fof(miloA184,axiom,
    p__d__subclass(c__Gun,c__Weapon) ).

fof(miloA185,axiom,
    p__d__subclass(c__Gun,c__ProjectileLauncher) ).

fof(miloA186,axiom,
    p__d__partition3(c__Gun,c__ArtilleryGun,c__Firearm) ).

fof(miloA187,axiom,
    ! [GUN] :
      ( p__d__instance(GUN,c__Gun)
     => p__capability(c__Shooting,c__instrument,GUN) ) ).

fof(miloA188,axiom,
    ! [SHOOT] :
      ( p__d__instance(SHOOT,c__Shooting)
     => ? [PROJECTILE,GUN] :
          ( p__d__instance(PROJECTILE,c__Projectile)
          & p__patient(SHOOT,PROJECTILE)
          & p__d__instance(GUN,c__Gun)
          & p__instrument(SHOOT,GUN) ) ) ).

fof(miloA189,axiom,
    p__d__subclass(c__MortarGun,c__ArtilleryGun) ).

fof(miloA190,axiom,
    p__d__subclass(c__Bullet,c__Projectile) ).

fof(miloA192,axiom,
    p__d__subclass(c__BulletCartridge,c__Projectile) ).

fof(miloA194,axiom,
    p__d__subclass(c__CartridgeCase,c__EngineeringComponent) ).

fof(miloA195,axiom,
    ! [CASE] :
      ( ( p__d__instance(CASE,c__Agent)
        & p__d__instance(CASE,c__CartridgeCase) )
     => ? [CARTRIDGE,BULLET,K] :
          ( p__d__instance(CARTRIDGE,c__BulletCartridge)
          & p__d__instance(BULLET,c__Bullet)
          & p__d__instance(K,c__Keeping)
          & p__properPart(CASE,CARTRIDGE)
          & p__properPart(BULLET,CARTRIDGE)
          & p__agent(K,CASE)
          & p__patient(K,BULLET) ) ) ).

fof(miloA196,axiom,
    p__d__subclass(c__GunBarrel,c__EngineeringComponent) ).

fof(miloA197,axiom,
    ! [B] :
      ( p__d__instance(B,c__GunBarrel)
     => ? [G] :
          ( p__d__instance(G,c__Gun)
          & p__part(B,G) ) ) ).

fof(miloA198,axiom,
    ! [G,GUN,P,S,B] :
      ( ( p__d__instance(GUN,c__Physical)
        & p__d__instance(G,c__Gun)
        & p__d__instance(B,c__GunBarrel)
        & p__part(B,G)
        & p__d__instance(S,c__Shooting)
        & p__instrument(S,GUN)
        & p__patient(S,P)
        & p__d__instance(P,c__Projectile) )
     => ? [SUB] :
          ( p__d__instance(SUB,c__Motion)
          & p__subProcess(SUB,S)
          & p__path(SUB,B) ) ) ).

fof(miloA199,axiom,
    p__d__subclass(c__GunPowder,c__Mixture) ).

fof(miloA200,axiom,
    p__d__subclass(c__Lever,c__Device) ).

fof(miloA201,axiom,
    ! [L] :
      ( p__d__instance(L,c__Lever)
     => ? [A] :
          ( p__d__instance(A,c__Object)
          & p__axis(A,L) ) ) ).

fof(miloA203,axiom,
    ! [P] :
      ( p__d__instance(P,c__GunPowder)
     => p__capability(c__Explosion,c__instrument,P) ) ).

fof(miloA204,axiom,
    p__d__subclass(c__GunTrigger,c__EngineeringComponent) ).

fof(miloA205,axiom,
    p__d__subclass(c__GunTrigger,c__Lever) ).

fof(miloA206,axiom,
    p__typicalPart(c__GunTrigger,c__Gun) ).

fof(miloA207,axiom,
    p__typicallyContainsPart(c__GunTrigger,c__Gun) ).

fof(miloA208,axiom,
    p__d__subclass(c__LoadingWeapon,c__Inserting) ).

fof(miloA209,axiom,
    ! [L,P] :
      ( ( p__d__instance(L,c__LoadingWeapon)
        & p__patient(L,P) )
     => p__d__instance(P,c__Projectile) ) ).

fof(miloA210,axiom,
    ! [L,W] :
      ( ( p__d__instance(L,c__LoadingWeapon)
        & p__destination(L,W) )
     => p__d__instance(W,c__ProjectileLauncher) ) ).

fof(miloA211,axiom,
    p__d__instance(c__effectiveRange,c__BinaryPredicate) ).

fof(miloA212,axiom,
    p__d__instance(c__effectiveRange,c__SingleValuedRelation) ).

fof(miloA213,axiom,
    p__subrelation(c__effectiveRange,c__measure) ).

fof(miloA218,axiom,
    p__d__subclass(c__GunStock,c__EngineeringComponent) ).

fof(miloA219,axiom,
    ! [STOCK] :
      ( p__d__instance(STOCK,c__GunStock)
     => ? [GUN] :
          ( p__d__instance(GUN,c__Gun)
          & p__part(STOCK,GUN) ) ) ).

fof(miloA220,axiom,
    p__d__subclass(c__WeaponOfMassDestruction,c__Weapon) ).

fof(miloA221,axiom,
    p__d__subclass(c__Handle,c__EngineeringComponent) ).

fof(miloA223,axiom,
    p__d__subclass(c__Shield,c__Artifact) ).

fof(miloA225,axiom,
    ! [S] :
      ( p__d__instance(S,c__Shield)
     => ? [H] :
          ( p__d__instance(H,c__Handle)
          & p__part(H,S) ) ) ).

fof(miloA226,axiom,
    p__d__subclass(c__Mast,c__Artifact) ).

fof(miloA227,axiom,
    ! [M] :
      ( p__d__instance(M,c__Mast)
     => ? [W] :
          ( p__d__instance(W,c__WaterVehicle)
          & p__part(M,W) ) ) ).

fof(miloA228,axiom,
    p__d__subclass(c__WingDevice,c__EngineeringComponent) ).

fof(miloA229,axiom,
    ! [W] :
      ( p__d__instance(W,c__WingDevice)
     => ? [A] :
          ( p__d__instance(A,c__Aircraft)
          & p__part(W,A) ) ) ).

fof(miloA230,axiom,
    p__d__subclass(c__Tube,c__Artifact) ).

fof(miloA232,axiom,
    p__d__subclass(c__PhotographicFilm,c__Artifact) ).

fof(miloA233,axiom,
    p__d__subclass(c__PictureFrame,c__Artifact) ).

fof(miloA235,axiom,
    p__d__subclass(c__Shelf,c__Artifact) ).

fof(miloA236,axiom,
    ! [S] :
      ( p__d__instance(S,c__Shelf)
     => ? [F] :
          ( p__d__instance(F,c__Furniture)
          & p__part(S,F) ) ) ).

fof(miloA237,axiom,
    p__d__subclass(c__AutomaticGun,c__Gun) ).

fof(miloA240,axiom,
    p__d__subclass(c__ArtilleryGun,c__Gun) ).

fof(miloA241,axiom,
    p__d__subclass(c__Firearm,c__Gun) ).

fof(miloA242,axiom,
    p__d__partition3(c__Firearm,c__Rifle,c__Pistol) ).

fof(miloA243,axiom,
    p__d__subclass(c__Rifle,c__Firearm) ).

fof(miloA244,axiom,
    p__d__subclass(c__Pistol,c__Firearm) ).

fof(miloA245,axiom,
    p__d__subclass(c__RevolverGun,c__Pistol) ).

fof(miloA246,axiom,
    p__d__instance(c__ContainerEmpty,c__RelationalAttribute) ).

fof(miloA247,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__Object)
        & p__attribute(C,c__ContainerEmpty) )
     => p__d__instance(C,c__Container) ) ).

fof(miloA248,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__SelfConnectedObject)
        & p__attribute(C,c__ContainerEmpty) )
     => ! [H,S] :
          ( ~ p__d__instance(H,c__Hole)
          | ~ p__d__instance(S,c__Object)
          | ~ p__hole(H,C)
          | ~ p__partiallyFills(S,H) ) ) ).

fof(miloA249,axiom,
    p__d__instance(c__ContainerFull,c__RelationalAttribute) ).

fof(miloA250,axiom,
    p__contraryAttribute2(c__ContainerFull,c__ContainerEmpty) ).

fof(miloA251,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__Object)
        & p__attribute(C,c__ContainerFull) )
     => p__d__instance(C,c__Container) ) ).

fof(miloA252,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__SelfConnectedObject)
        & p__attribute(C,c__ContainerFull) )
     => ? [H,S] :
          ( p__d__instance(H,c__Hole)
          & p__d__instance(S,c__Object)
          & p__hole(H,C)
          & p__fills(S,H) ) ) ).

fof(miloA253,axiom,
    p__d__subclass(c__Holster,c__Container) ).

fof(miloA255,axiom,
    p__d__subclass(c__Wastebasket,c__Container) ).

fof(miloA256,axiom,
    p__d__subclass(c__ArrowProjectile,c__Projectile) ).

fof(miloA257,axiom,
    p__d__subclass(c__DriveComponent,c__EngineeringComponent) ).

fof(miloA258,axiom,
    p__d__subclass(c__PetroleumProduct,c__Oil) ).

fof(miloA259,axiom,
    ! [PP] :
      ( p__d__instance(PP,c__PetroleumProduct)
     => ? [O] :
          ( p__d__instance(O,c__OrganicCompound)
          & p__part(O,PP) ) ) ).

fof(miloA260,axiom,
    p__d__subclass(c__FossilFuel,c__Fuel) ).

fof(miloA261,axiom,
    p__d__subclass(c__FossilFuel,c__PetroleumProduct) ).

fof(miloA262,axiom,
    p__d__subclass(c__Fuel,c__Substance) ).

fof(miloA263,axiom,
    ! [X] :
      ( p__d__instance(X,c__FossilFuel)
     => p__attribute(X,c__Flammable) ) ).

fof(miloA264,axiom,
    p__d__subclass(c__Wax,c__Substance) ).

fof(miloA265,axiom,
    p__d__subclass(c__LiquefiedPetroleumGas,c__FossilFuel) ).

fof(miloA266,axiom,
    p__d__subclass(c__Gasoline,c__FossilFuel) ).

fof(miloA267,axiom,
    p__d__subclass(c__DieselFuel,c__FossilFuel) ).

fof(miloA268,axiom,
    p__d__subclass(c__Transducer,c__Device) ).

fof(miloA269,axiom,
    p__d__subclass(c__Engine,c__Transducer) ).

fof(miloA270,axiom,
    p__d__instance(c__powerPlant,c__BinaryPredicate) ).

fof(miloA271,axiom,
    p__d__instance(c__powerPlant,c__AsymmetricRelation) ).

fof(miloA272,axiom,
    p__d__instance(c__powerPlant,c__IrreflexiveRelation) ).

fof(miloA275,axiom,
    p__subrelation(c__powerPlant,c__component) ).

fof(miloA276,axiom,
    ! [G,O] :
      ( ( p__d__instance(G,c__Device)
        & p__powerPlant(G,O)
        & p__d__instance(O,c__Device) )
     => p__d__instance(O,c__SelfPoweredDevice) ) ).

fof(miloA277,axiom,
    ! [O,G] :
      ( ( p__d__instance(O,c__Artifact)
        & p__d__instance(G,c__Device)
        & p__powerPlant(G,O) )
     => ( p__d__instance(G,c__Engine)
        | p__d__instance(G,c__Battery) ) ) ).

fof(miloA278,axiom,
    p__d__subclass(c__SteamEngine,c__Engine) ).

fof(miloA279,axiom,
    p__d__subclass(c__Turbine,c__Engine) ).

fof(miloA280,axiom,
    p__d__subclass(c__Windmill,c__Engine) ).

fof(miloA281,axiom,
    p__d__subclass(c__InternalCombustionEngine,c__Engine) ).

fof(miloA283,axiom,
    p__d__subclass(c__Manifold,c__EngineeringComponent) ).

fof(miloA284,axiom,
    p__d__subclass(c__ElectricMotor,c__Engine) ).

fof(miloA285,axiom,
    p__d__subclass(c__ElectricMotor,c__ElectricDevice) ).

fof(miloA286,axiom,
    p__d__subclass(c__SwitchDevice,c__EngineeringComponent) ).

fof(miloA287,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__SwitchDevice)
     => ? [PROC1,PROC2,ELECTRIC] :
          ( p__d__instance(PROC1,c__Process)
          & p__d__instance(PROC2,c__Process)
          & p__instrument(PROC1,DEVICE)
          & p__causes(PROC1,PROC2)
          & p__instrument(PROC2,ELECTRIC)
          & p__d__instance(ELECTRIC,c__ElectricDevice) ) ) ).

fof(miloA288,axiom,
    p__d__subclass(c__Microphone,c__ElectricDevice) ).

fof(miloA289,axiom,
    p__d__subclass(c__Microphone,c__CommunicationDevice) ).

fof(miloA290,axiom,
    p__d__subclass(c__ReceiverDevice,c__CommunicationDevice) ).

fof(miloA291,axiom,
    p__d__subclass(c__ReceiverDevice,c__ElectricDevice) ).

fof(miloA292,axiom,
    ! [E,D] :
      ( ( p__d__instance(E,c__RadioEmission)
        & p__destination(E,D) )
     => p__d__instance(D,c__ReceiverDevice) ) ).

fof(miloA293,axiom,
    p__d__subclass(c__Telegraph,c__ElectricDevice) ).

fof(miloA294,axiom,
    p__d__subclass(c__Telegraph,c__CommunicationDevice) ).

fof(miloA295,axiom,
    p__d__subclass(c__ProjectionScreen,c__CommunicationDevice) ).

fof(miloA296,axiom,
    p__d__subclass(c__Pencil,c__WritingDevice) ).

fof(miloA297,axiom,
    p__d__subclass(c__DeviceAttribute,c__ObjectiveNorm) ).

fof(miloA298,axiom,
    ! [ATTRIBUTE,DEVICE] :
      ( ( p__d__instance(DEVICE,c__Object)
        & p__attribute(DEVICE,ATTRIBUTE)
        & p__d__instance(ATTRIBUTE,c__DeviceAttribute) )
     => p__d__instance(DEVICE,c__Device) ) ).

fof(miloA299,axiom,
    p__d__instance(c__Functioning,c__DeviceAttribute) ).

fof(miloA300,axiom,
    p__contraryAttribute2(c__Functioning,c__Malfunctioning) ).

fof(miloA301,axiom,
    ! [DEVICE,PROP] :
      ( ( p__d__instance(DEVICE,c__Object)
        & p__d__instance(PROP,c__Formula)
        & p__attribute(DEVICE,c__Functioning)
        & p__hasPurpose(DEVICE,PROP) )
     => p__truth(PROP,c__True) ) ).

fof(miloA302,axiom,
    p__d__instance(c__Malfunctioning,c__DeviceAttribute) ).

fof(miloA303,axiom,
    ! [DEVICE,PROP] :
      ( ( p__d__instance(DEVICE,c__Object)
        & p__d__instance(PROP,c__Formula)
        & p__attribute(DEVICE,c__Malfunctioning)
        & p__hasPurpose(DEVICE,PROP) )
     => p__truth(PROP,c__False) ) ).

fof(miloA304,axiom,
    p__d__subclass(c__DeviceStateAttribute,c__InternalAttribute) ).

fof(miloA305,axiom,
    p__d__instance(c__DeviceClosed,c__DeviceStateAttribute) ).

fof(miloA306,axiom,
    p__d__instance(c__DeviceOff,c__DeviceStateAttribute) ).

fof(miloA307,axiom,
    p__d__instance(c__DeviceOn,c__DeviceStateAttribute) ).

fof(miloA308,axiom,
    p__d__instance(c__DeviceOpen,c__DeviceStateAttribute) ).

fof(miloA309,axiom,
    p__d__instance(c__deviceState,c__BinaryPredicate) ).

fof(miloA312,axiom,
    p__subrelation(c__deviceState,c__attribute) ).

fof(miloA313,axiom,
    p__d__subclass(c__Aerator,c__Device) ).

fof(miloA315,axiom,
    p__d__subclass(c__Aerating,c__Combining) ).

fof(miloA316,axiom,
    ! [AERATE] :
      ( p__d__instance(AERATE,c__Aerating)
     => ? [AIR,S] :
          ( p__d__instance(S,c__Object)
          & p__patient(AERATE,AIR)
          & p__d__instance(AIR,c__Air)
          & p__patient(AERATE,S)
          & p__attribute(S,c__Liquid) ) ) ).

fof(miloA317,axiom,
    p__d__subclass(c__Broom,c__BrushOrComb) ).

fof(miloA319,axiom,
    p__d__subclass(c__BrushOrComb,c__Device) ).

fof(miloA321,axiom,
    p__d__subclass(c__MatchDevice,c__Device) ).

fof(miloA323,axiom,
    p__d__subclass(c__VendingDevice,c__Device) ).

fof(miloA325,axiom,
    p__d__subclass(c__WritingDevice,c__Device) ).

fof(miloA327,axiom,
    p__d__subclass(c__SmokingDevice,c__Device) ).

fof(miloA329,axiom,
    p__d__subclass(c__SmokingPipe,c__SmokingDevice) ).

fof(miloA330,axiom,
    p__d__subclass(c__Shower,c__BathingDevice) ).

fof(miloA332,axiom,
    ! [SHOWER] :
      ( p__d__instance(SHOWER,c__Shower)
     => ? [X,FLOOR] :
          ( p__d__instance(X,c__Object)
          & ( p__d__instance(X,c__Wall)
            | p__d__instance(X,c__Ceiling) )
          & p__connected(SHOWER,X)
          & p__d__instance(FLOOR,c__Floor)
          & p__orientation(SHOWER,FLOOR,c__Above) ) ) ).

fof(miloA333,axiom,
    p__d__subclass(c__BathTub,c__BathingDevice) ).

fof(miloA334,axiom,
    p__d__subclass(c__BathTub,c__FluidContainer) ).

fof(miloA336,axiom,
    p__d__subclass(c__Excrement,c__BodySubstance) ).

fof(miloA337,axiom,
    ! [X] :
      ( p__d__instance(X,c__Excrement)
     => ? [PROC,ORG] :
          ( p__d__instance(ORG,c__Organism)
          & p__d__instance(PROC,c__PhysiologicProcess)
          & p__result(PROC,X)
          & p__agent(PROC,ORG) ) ) ).

fof(miloA338,axiom,
    p__d__subclass(c__Feces,c__Excrement) ).

fof(miloA339,axiom,
    ! [X] :
      ( p__d__instance(X,c__Feces)
     => p__attribute(X,c__Solid) ) ).

fof(miloA340,axiom,
    ! [X] :
      ( p__d__instance(X,c__Feces)
     => ? [PROC,INT] :
          ( p__d__instance(PROC,c__PhysiologicProcess)
          & p__instrument(PROC,INT)
          & p__d__instance(INT,c__Intestine)
          & p__result(PROC,X) ) ) ).

fof(miloA341,axiom,
    p__d__subclass(c__Urine,c__Excrement) ).

fof(miloA342,axiom,
    ! [X] :
      ( p__d__instance(X,c__Urine)
     => p__attribute(X,c__Liquid) ) ).

fof(miloA343,axiom,
    ! [X] :
      ( p__d__instance(X,c__Urine)
     => ? [PROC,KIDNEY] :
          ( p__d__instance(PROC,c__PhysiologicProcess)
          & p__instrument(PROC,KIDNEY)
          & p__d__instance(KIDNEY,c__Kidney)
          & p__result(PROC,X) ) ) ).

fof(miloA344,axiom,
    p__d__subclass(c__Excretion,c__OrganismProcess) ).

fof(miloA345,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__Excretion)
     => ? [ORG,WASTE,PART] :
          ( p__d__instance(ORG,c__Organism)
          & p__agent(PROC,ORG)
          & p__patient(PROC,WASTE)
          & p__d__instance(WASTE,c__Excrement)
          & p__d__instance(PART,c__BodyPart)
          & p__instrument(PROC,PART) ) ) ).

fof(miloA346,axiom,
    p__d__subclass(c__Urination,c__Excretion) ).

fof(miloA347,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__Urination)
     => ? [URINE] :
          ( p__d__instance(URINE,c__Urine)
          & p__patient(PROC,URINE) ) ) ).

fof(miloA348,axiom,
    p__d__subclass(c__Defecation,c__Excretion) ).

fof(miloA349,axiom,
    ! [PROC] :
      ( p__d__instance(PROC,c__Defecation)
     => ? [FECES] :
          ( p__d__instance(FECES,c__Feces)
          & p__patient(PROC,FECES) ) ) ).

fof(miloA350,axiom,
    p__d__subclass(c__Sewage,c__Mixture) ).

fof(miloA351,axiom,
    ! [D,ANI] :
      ( ( p__d__instance(ANI,c__Animal)
        & p__d__instance(D,c__DiseaseOrSyndrome)
        & ~ p__attribute(ANI,D) )
     => ? [P,W] :
          ( p__d__instance(P,c__BiologicalProcess)
          & p__d__instance(P,c__Removing)
          & p__origin(P,ANI)
          & p__d__instance(W,c__Sewage)
          & p__agent(P,ANI)
          & p__patient(P,W) ) ) ).

fof(miloA352,axiom,
    p__d__subclass(c__Bidet,c__WashingDevice) ).

fof(miloA354,axiom,
    p__d__subclass(c__Toilet,c__Device) ).

fof(miloA355,axiom,
    ! [T,R] :
      ( ( p__located(T,R)
        & p__d__instance(T,c__Toilet)
        & p__d__instance(R,c__Room) )
     => p__d__instance(R,c__Bathroom) ) ).

fof(miloA357,axiom,
    p__d__subclass(c__Toothbrush,c__BrushOrComb) ).

fof(miloA359,axiom,
    p__d__subclass(c__CigarOrCigarette,c__SmokingDevice) ).

fof(miloA360,axiom,
    ! [C] :
      ( p__d__instance(C,c__CigarOrCigarette)
     => ? [T] :
          ( p__d__instance(T,c__Tobacco)
          & p__part(T,C) ) ) ).

fof(miloA361,axiom,
    p__d__subclass(c__Tableware,c__Device) ).

fof(miloA363,axiom,
    p__d__subclass(c__Compass,c__Device) ).

fof(miloA364,axiom,
    p__d__subclass(c__Compass,c__ContentBearingObject) ).

fof(miloA365,axiom,
    ! [C] :
      ( p__d__instance(C,c__Compass)
     => ? [D] :
          ( p__d__instance(D,c__DirectionalAttribute)
          & p__represents(C,D) ) ) ).

fof(miloA366,axiom,
    p__d__subclass(c__MajorAppliance,c__Device) ).

fof(miloA367,axiom,
    p__d__subclass(c__Refrigerator,c__MajorAppliance) ).

fof(miloA368,axiom,
    p__d__subclass(c__Freezer,c__MajorAppliance) ).

fof(miloA369,axiom,
    p__d__subclass(c__CookingRange,c__MajorAppliance) ).

fof(miloA370,axiom,
    p__d__subclass(c__CookingOven,c__MajorAppliance) ).

fof(miloA371,axiom,
    p__d__subclass(c__HotWaterHeater,c__MajorAppliance) ).

fof(miloA372,axiom,
    p__d__subclass(c__ClothesWashingMachine,c__MajorAppliance) ).

fof(miloA373,axiom,
    p__d__subclass(c__ClothesDryer,c__MajorAppliance) ).

fof(miloA374,axiom,
    p__d__subclass(c__Dishwasher,c__MajorAppliance) ).

fof(miloA375,axiom,
    p__d__subclass(c__CoolingDevice,c__Device) ).

fof(miloA377,axiom,
    p__d__subclass(c__FanDevice,c__CoolingDevice) ).

fof(miloA379,axiom,
    p__d__subclass(c__HeatingDevice,c__Device) ).

fof(miloA381,axiom,
    p__d__subclass(c__Oven,c__HeatingDevice) ).

fof(miloA382,axiom,
    p__d__subclass(c__Oven,c__Container) ).

fof(miloA384,axiom,
    p__d__subclass(c__Stove,c__HeatingDevice) ).

fof(miloA386,axiom,
    p__d__subclass(c__Refrigerator,c__CoolingDevice) ).

fof(miloA387,axiom,
    p__d__subclass(c__Refrigerator,c__ElectricDevice) ).

fof(miloA388,axiom,
    p__d__subclass(c__Refrigerator,c__Container) ).

fof(miloA389,axiom,
    p__d__subclass(c__PotOrPan,c__Container) ).

fof(miloA391,axiom,
    p__d__subclass(c__Ramp,c__SelfConnectedObject) ).

fof(miloA392,axiom,
    ! [R] :
      ( p__d__instance(R,c__Ramp)
     => p__capability(c__MotionUpward,c__path,R) ) ).

fof(miloA393,axiom,
    ! [R] :
      ( p__d__instance(R,c__Ramp)
     => p__capability(c__MotionDownward,c__path,R) ) ).

fof(miloA394,axiom,
    p__d__subclass(c__RecreationOrExerciseDevice,c__Device) ).

fof(miloA396,axiom,
    p__d__subclass(c__WalkingCane,c__Device) ).

fof(miloA398,axiom,
    p__d__subclass(c__WashingDevice,c__Device) ).

fof(miloA400,axiom,
    p__d__subclass(c__MaterialHandlingEquipment,c__Device) ).

fof(miloA401,axiom,
    p__d__subclass(c__Crane,c__MaterialHandlingEquipment) ).

fof(miloA402,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__CorpuscularObject)
        & p__d__instance(C,c__Crane) )
     => ? [H] :
          ( p__d__instance(H,c__CorpuscularObject)
          & p__d__instance(H,c__HoistingDevice)
          & p__component(H,C) ) ) ).

fof(miloA403,axiom,
    p__d__subclass(c__HoistingDevice,c__MaterialHandlingEquipment) ).

fof(miloA404,axiom,
    ! [H] :
      ( p__d__instance(H,c__HoistingDevice)
     => p__capability(c__MotionUpward,c__instrument,H) ) ).

fof(miloA405,axiom,
    ! [H] :
      ( p__d__instance(H,c__HoistingDevice)
     => p__capability(c__MotionDownward,c__instrument,H) ) ).

fof(miloA406,axiom,
    p__d__subclass(c__OpticalDevice,c__Device) ).

fof(miloA408,axiom,
    p__d__subclass(c__EyeGlass,c__OpticalDevice) ).

fof(miloA409,axiom,
    p__d__subclass(c__Lens,c__OpticalDevice) ).

fof(miloA410,axiom,
    p__d__subclass(c__Microscope,c__OpticalDevice) ).

fof(miloA411,axiom,
    p__d__subclass(c__Filter,c__Device) ).

fof(miloA413,axiom,
    p__d__subclass(c__FileDevice,c__Device) ).

fof(miloA414,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__FileDevice)
     => p__capability(c__SurfaceChange,c__instrument,DEVICE) ) ).

fof(miloA415,axiom,
    p__d__subclass(c__ElectricDevice,c__Device) ).

fof(miloA416,axiom,
    ! [DEV,EV] :
      ( ( p__d__instance(DEV,c__ElectricDevice)
        & p__d__instance(EV,c__Process)
        & p__instrument(EV,DEV) )
     => ? [R] :
          ( p__d__instance(R,c__Electricity)
          & p__resource(EV,R) ) ) ).

fof(miloA417,axiom,
    p__d__subclass(c__Electricity,c__Substance) ).

fof(miloA418,axiom,
    p__d__subclass(c__PowerSource,c__Device) ).

fof(miloA419,axiom,
    ! [PS] :
      ( p__d__instance(PS,c__PowerSource)
     => ? [RE] :
          ( p__d__instance(RE,c__RadiatingElectromagnetic)
          & p__origin(RE,PS) ) ) ).

fof(miloA420,axiom,
    p__d__subclass(c__DCPowerSource,c__PowerSource) ).

fof(miloA421,axiom,
    p__d__subclass(c__Battery,c__DCPowerSource) ).

fof(miloA422,axiom,
    p__d__subclass(c__Battery,c__ElectricDevice) ).

fof(miloA423,axiom,
    p__d__subclass(c__Radar,c__ElectricDevice) ).

fof(miloA425,axiom,
    ! [RADAR] :
      ( p__d__instance(RADAR,c__Radar)
     => p__capability(c__RadiatingElectromagnetic,c__agent,RADAR) ) ).

fof(miloA426,axiom,
    p__d__instance(c__discovers,c__BinaryPredicate) ).

fof(miloA429,axiom,
    ! [AGENT,OBJECT] :
      ( ( p__d__instance(OBJECT,c__Object)
        & p__d__instance(AGENT,c__Agent)
        & p__discovers(AGENT,OBJECT) )
     => ? [DISCOVERING] :
          ( p__d__instance(DISCOVERING,c__Discovering)
          & p__agent(DISCOVERING,AGENT)
          & p__patient(DISCOVERING,OBJECT) ) ) ).

fof(miloA430,axiom,
    p__d__subclass(c__Sonar,c__CorpuscularObject) ).

fof(miloA432,axiom,
    ! [SONAR] :
      ( p__d__instance(SONAR,c__Sonar)
     => p__capability(c__RadiatingSound,c__agent,SONAR) ) ).

fof(miloA433,axiom,
    p__d__subclass(c__Echoing,c__RadiatingSound) ).

fof(miloA434,axiom,
    p__d__subclass(c__ElectricalSignalling,c__Signalling) ).

fof(miloA435,axiom,
    ! [S] :
      ( p__d__instance(S,c__ElectricalSignalling)
     => ? [D] :
          ( p__d__instance(D,c__ElectricDevice)
          & p__instrument(S,D) ) ) ).

fof(miloA436,axiom,
    p__d__subclass(c__ElectronicSignalling,c__ElectricalSignalling) ).

fof(miloA437,axiom,
    p__d__subclass(c__SecurityDevice,c__Device) ).

fof(miloA438,axiom,
    p__d__subclass(c__Lock,c__SecurityDevice) ).

fof(miloA439,axiom,
    p__d__subclass(c__Key,c__SecurityDevice) ).

fof(miloA441,axiom,
    p__d__instance(c__Locked,c__RelationalAttribute) ).

fof(miloA443,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Locked) )
     => p__d__instance(X,c__Object) ) ).

fof(miloA444,axiom,
    p__d__subclass(c__SafeContainer,c__Container) ).

fof(miloA445,axiom,
    p__d__subclass(c__SafeContainer,c__SecurityDevice) ).

fof(miloA446,axiom,
    ! [S] :
      ( p__d__instance(S,c__SafeContainer)
     => ? [L] :
          ( p__d__instance(L,c__Lock)
          & p__part(L,S) ) ) ).

fof(miloA447,axiom,
    p__d__subclass(c__AnimalController,c__Device) ).

fof(miloA449,axiom,
    p__d__subclass(c__SelfPoweredDevice,c__Device) ).

fof(miloA450,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__SelfPoweredDevice)
     => ? [SOURCE] :
          ( p__d__instance(SOURCE,c__Device)
          & p__powerPlant(DEVICE,SOURCE) ) ) ).

fof(miloA451,axiom,
    p__d__subclass(c__AnimalPoweredDevice,c__Device) ).

fof(miloA452,axiom,
    ! [D,P] :
      ( ( p__d__instance(P,c__Process)
        & p__d__instance(D,c__AnimalPoweredDevice)
        & p__instrument(P,D) )
     => ? [A] :
          ( p__d__instance(A,c__Animal)
          & p__instrument(P,A) ) ) ).

fof(miloA453,axiom,
    p__d__instance(c__Flat,c__ShapeAttribute) ).

fof(miloA454,axiom,
    ! [F] :
      ( ( p__d__instance(F,c__SelfConnectedObject)
        & p__attribute(F,c__Flat) )
     => ? [H,S1,S2,H1,H2] :
          ( p__d__instance(S1,c__SelfConnectedObject)
          & p__d__instance(S2,c__SelfConnectedObject)
          & p__d__instance(H,c__LengthMeasure)
          & p__d__instance(H1,c__LengthMeasure)
          & p__d__instance(H2,c__LengthMeasure)
          & p__side(S1,F)
          & p__side(S2,F)
          & p__meetsSpatially(S1,S2)
          & S1 != S2
          & p__height(F,H)
          & p__height(S1,H1)
          & p__height(S2,H2)
          & p__greaterThan(H1,f__MultiplicationFn2(c__2,H))
          & p__greaterThan(H2,f__MultiplicationFn2(c__2,H)) ) ) ).

fof(miloA455,axiom,
    p__d__instance(c__LongAndThin,c__ShapeAttribute) ).

fof(miloA456,axiom,
    ! [F] :
      ( ( p__d__instance(F,c__SelfConnectedObject)
        & p__attribute(F,c__LongAndThin) )
     => ? [H,S1,S2,H1,H2] :
          ( p__d__instance(S1,c__SelfConnectedObject)
          & p__d__instance(S2,c__SelfConnectedObject)
          & p__d__instance(H,c__LengthMeasure)
          & p__d__instance(H1,c__LengthMeasure)
          & p__d__instance(H2,c__LengthMeasure)
          & p__side(S1,F)
          & p__side(S2,F)
          & p__meetsSpatially(S1,S2)
          & S1 != S2
          & p__length(F,H)
          & p__length(S1,H1)
          & p__length(S2,H2)
          & p__lessThan(H1,f__MultiplicationFn2(c__3,H))
          & p__lessThan(H2,f__MultiplicationFn2(c__3,H)) ) ) ).

fof(miloA457,axiom,
    p__d__instance(c__LevelShape,c__ShapeAttribute) ).

fof(miloA458,axiom,
    ! [O] :
      ( ( p__d__instance(O,c__SelfConnectedObject)
        & p__attribute(O,c__LevelShape) )
     => ! [P1,P2,T,H1,H2] :
          ( ~ p__d__instance(T,c__SelfConnectedObject)
          | ~ p__d__instance(P1,c__SelfConnectedObject)
          | ~ p__d__instance(P2,c__SelfConnectedObject)
          | ~ p__d__instance(H1,c__LengthMeasure)
          | ~ p__d__instance(H2,c__LengthMeasure)
          | ~ p__top(T,O)
          | ~ p__part(P1,T)
          | ~ p__part(P2,T)
          | ~ p__height(P1,H1)
          | ~ p__height(P2,H2)
          | ~ p__greaterThan(H1,H2) ) ) ).

fof(miloA459,axiom,
    p__d__instance(c__SymmetricShape,c__ShapeAttribute) ).

fof(miloA460,axiom,
    ! [T] :
      ( ( p__d__instance(T,c__Object)
        & p__attribute(T,c__SymmetricShape) )
     => ? [C1,C2] :
          ( p__d__instance(C2,c__Object)
          & p__d__instance(C1,c__Object)
          & p__copy(C1,C2)
          & T = f__MereologicalSumFn2(C1,C2) ) ) ).

fof(miloA461,axiom,
    p__d__subclass(c__Baton,c__Device) ).

fof(miloA463,axiom,
    ! [B] :
      ( p__d__instance(B,c__Baton)
     => p__attribute(B,c__LongAndThin) ) ).

fof(miloA464,axiom,
    p__d__subclass(c__SecurityAlarm,c__SecurityDevice) ).

fof(miloA465,axiom,
    p__d__subclass(c__SecurityAlarm,c__ElectricDevice) ).

fof(miloA466,axiom,
    p__d__partition3(c__Quantity,c__FiniteQuantity,c__InfiniteQuantity) ).

fof(miloA467,axiom,
    p__d__subclass(c__FiniteQuantity,c__Quantity) ).

fof(miloA468,axiom,
    p__d__subclass(c__InfiniteQuantity,c__Quantity) ).

fof(miloA469,axiom,
    p__d__subclass(c__Clock,c__MeasuringDevice) ).

fof(miloA470,axiom,
    ! [M,C,Q] :
      ( ( p__d__instance(M,c__Measuring)
        & p__result(M,Q)
        & p__instrument(M,C)
        & p__d__instance(C,c__Clock) )
     => p__d__instance(Q,c__TimeMeasure) ) ).

fof(miloA471,axiom,
    p__d__subclass(c__WatchClock,c__Clock) ).

fof(miloA472,axiom,
    ! [P,W,C] :
      ( ( p__d__instance(C,c__WearableItem)
        & p__d__instance(P,c__Animal)
        & p__wears(P,C)
        & p__located(C,W)
        & p__d__instance(C,c__Clock)
        & p__d__instance(W,c__Wrist) )
     => p__d__instance(C,c__WatchClock) ) ).

fof(miloA473,axiom,
    p__d__subclass(c__Thermometer,c__MeasuringDevice) ).

fof(miloA474,axiom,
    ! [MEASURE,THERMOMETER,QUANTITY] :
      ( ( p__d__instance(MEASURE,c__Measuring)
        & p__result(MEASURE,QUANTITY)
        & p__instrument(MEASURE,THERMOMETER)
        & p__d__instance(THERMOMETER,c__Thermometer) )
     => p__d__instance(QUANTITY,c__TemperatureMeasure) ) ).

fof(miloA475,axiom,
    p__d__subclass(c__PressureMeasuringDevice,c__MeasuringDevice) ).

fof(miloA476,axiom,
    ! [M,T,Q] :
      ( ( p__d__instance(M,c__Measuring)
        & p__result(M,Q)
        & p__instrument(M,T)
        & p__d__instance(T,c__Thermometer) )
     => p__d__instance(Q,c__TemperatureMeasure) ) ).

fof(miloA477,axiom,
    p__d__instance(c__measurementReading,c__BinaryPredicate) ).

fof(miloA480,axiom,
    p__d__subclass(c__CommunicationDevice,c__EngineeringComponent) ).

fof(miloA482,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__CommunicationDevice)
     => p__capability(c__Communication,c__instrument,DEVICE) ) ).

fof(miloA483,axiom,
    p__d__subclass(c__Telephone,c__ElectricDevice) ).

fof(miloA484,axiom,
    p__d__subclass(c__Telephone,c__CommunicationDevice) ).

fof(miloA485,axiom,
    p__d__subclass(c__Telephoning,c__Communication) ).

fof(miloA486,axiom,
    ! [TEL] :
      ( p__d__instance(TEL,c__Telephoning)
     => ? [DEVICE] :
          ( p__d__instance(DEVICE,c__Telephone)
          & p__instrument(TEL,DEVICE) ) ) ).

fof(miloA487,axiom,
    ! [TEL,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(TEL,c__Telephoning) )
     => ? [SPEAK] :
          ( p__d__instance(SPEAK,c__Speaking)
          & p__subProcess(SPEAK,TEL)
          & ( p__agent(TEL,AGENT)
           => p__agent(SPEAK,AGENT) ) ) ) ).

fof(miloA488,axiom,
    p__d__subclass(c__Fax,c__ArtifactMediatedCommunication) ).

fof(miloA489,axiom,
    ! [Fax] :
      ( p__d__instance(Fax,c__Fax)
     => ? [FaxMachine] :
          ( p__d__instance(FaxMachine,c__FaxMachine)
          & p__instrument(Fax,FaxMachine) ) ) ).

fof(miloA490,axiom,
    p__d__subclass(c__FaxMachine,c__TelephonyDevice) ).

fof(miloA491,axiom,
    p__d__subclass(c__FaxMachine,c__ElectricDevice) ).

fof(miloA492,axiom,
    p__d__subclass(c__FaxMachine,c__CommunicationDevice) ).

fof(miloA493,axiom,
    p__d__instance(c__emailAddress,c__BinaryPredicate) ).

fof(miloA494,axiom,
    p__subrelation(c__emailAddress,c__refers) ).

fof(miloA497,axiom,
    p__d__subclass(c__LightFixture,c__Device) ).

fof(miloA498,axiom,
    ! [F] :
      ( p__d__instance(F,c__LightFixture)
     => p__capability(c__RadiatingLight,c__instrument,F) ) ).

fof(miloA499,axiom,
    p__d__subclass(c__Candle,c__LightFixture) ).

fof(miloA500,axiom,
    ! [CANDLE] :
      ( ( p__d__instance(CANDLE,c__CorpuscularObject)
        & p__d__instance(CANDLE,c__Candle) )
     => p__material(c__Wax,CANDLE) ) ).

fof(miloA502,axiom,
    p__d__subclass(c__Lightning,c__WeatherProcess) ).

fof(miloA503,axiom,
    p__d__subclass(c__Lightning,c__Radiating) ).

fof(miloA504,axiom,
    ! [L] :
      ( p__d__instance(L,c__Lightning)
     => ? [C] :
          ( p__d__instance(C,c__Cloud)
          & p__eventLocated(L,C) ) ) ).

fof(miloA505,axiom,
    p__d__subclass(c__Thunder,c__WeatherProcess) ).

fof(miloA506,axiom,
    p__d__subclass(c__Thunder,c__RadiatingSound) ).

fof(miloA507,axiom,
    ! [T] :
      ( p__d__instance(T,c__Thunder)
     => ? [L] :
          ( p__d__instance(L,c__Lightning)
          & p__causes(L,T) ) ) ).

fof(miloA508,axiom,
    p__d__subclass(c__VehicleLight,c__LightFixture) ).

fof(miloA509,axiom,
    ! [L] :
      ( p__d__instance(L,c__VehicleLight)
     => ? [V] :
          ( p__d__instance(V,c__Vehicle)
          & p__part(L,V) ) ) ).

fof(miloA510,axiom,
    p__d__subclass(c__Headlight,c__VehicleLight) ).

fof(miloA511,axiom,
    ! [L] :
      ( p__d__instance(L,c__Headlight)
     => ? [V] :
          ( p__d__instance(V,c__SelfConnectedObject)
          & p__d__instance(V,c__Vehicle)
          & p__part(L,f__FrontFn1(V)) ) ) ).

fof(miloA512,axiom,
    p__d__subclass(c__Taillight,c__VehicleLight) ).

fof(miloA513,axiom,
    ! [L] :
      ( p__d__instance(L,c__Taillight)
     => ? [V] :
          ( p__d__instance(V,c__SelfConnectedObject)
          & p__d__instance(V,c__Vehicle)
          & p__part(L,f__BackFn1(V)) ) ) ).

fof(miloA514,axiom,
    p__d__subclass(c__PaintedPicture,c__ArtWork) ).

fof(miloA515,axiom,
    ! [PP] :
      ( p__d__instance(PP,c__PaintedPicture)
     => ? [PAINT,PAINTING] :
          ( p__d__instance(PAINT,c__Paint)
          & p__d__instance(PAINTING,c__Painting)
          & p__resource(PAINTING,PAINT)
          & p__result(PAINTING,PP) ) ) ).

fof(miloA516,axiom,
    p__d__subclass(c__WatercolorPicture,c__PaintedPicture) ).

fof(miloA517,axiom,
    ! [W] :
      ( p__d__instance(W,c__WatercolorPicture)
     => ? [WP,P] :
          ( p__d__instance(WP,c__WatercolorPaint)
          & p__d__instance(P,c__Painting)
          & p__resource(P,WP)
          & p__result(P,W) ) ) ).

fof(miloA518,axiom,
    p__d__subclass(c__Wallpaper,c__ArtWork) ).

fof(miloA519,axiom,
    ! [W,P] :
      ( ( p__d__instance(P,c__Object)
        & p__d__instance(W,c__Wallpaper)
        & p__part(P,W) )
     => p__d__instance(P,c__Paper) ) ).

fof(miloA521,axiom,
    p__d__subclass(c__Sculpture,c__ArtWork) ).

fof(miloA522,axiom,
    p__d__subclass(c__Portrait,c__PaintedPicture) ).

fof(miloA523,axiom,
    ! [P] :
      ( p__d__instance(P,c__Portrait)
     => ? [F] :
          ( p__d__instance(F,c__Face)
          & p__represents(P,F) ) ) ).

fof(miloA524,axiom,
    p__d__subclass(c__Sketch,c__ArtWork) ).

fof(miloA525,axiom,
    p__d__subclass(c__Collage,c__ArtWork) ).

fof(miloA526,axiom,
    p__d__subclass(c__Folding,c__ShapeChange) ).

fof(miloA527,axiom,
    ! [F,O] :
      ( ( p__d__instance(O,c__Object)
        & p__d__instance(F,c__Folding)
        & p__patient(F,O) )
     => ? [C,P1,P2] :
          ( p__d__instance(P1,c__Object)
          & p__d__instance(P2,c__Object)
          & p__d__instance(C,c__Covering)
          & p__subProcess(C,F)
          & p__part(P1,O)
          & p__part(P2,O)
          & p__instrument(C,P1)
          & p__patient(C,P2) ) ) ).

fof(miloA528,axiom,
    p__d__subclass(c__Painting,c__Covering) ).

fof(miloA529,axiom,
    p__d__subclass(c__Painting,c__Coloring) ).

fof(miloA530,axiom,
    ! [PAINT,SURFACE,STUFF] :
      ( ( p__d__instance(SURFACE,c__SelfConnectedObject)
        & p__d__instance(STUFF,c__Object)
        & p__d__instance(PAINT,c__Painting)
        & p__patient(PAINT,SURFACE)
        & p__resource(PAINT,STUFF) )
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__SelfConnectedObject)
          & p__surface(SURFACE,OBJ)
          & p__d__instance(STUFF,c__Paint) ) ) ).

fof(miloA531,axiom,
    p__d__subclass(c__Paint,c__Solution) ).

fof(miloA532,axiom,
    ! [PAINT] :
      ( p__d__instance(PAINT,c__Paint)
     => p__capability(c__Coloring,c__instrument,PAINT) ) ).

fof(miloA533,axiom,
    p__d__subclass(c__WatercolorPaint,c__Paint) ).

fof(miloA534,axiom,
    ! [P] :
      ( p__d__instance(P,c__WatercolorPaint)
     => ? [W] :
          ( p__d__instance(W,c__Water)
          & p__part(W,P) ) ) ).

fof(miloA535,axiom,
    p__d__subclass(c__OilPaint,c__Paint) ).

fof(miloA536,axiom,
    p__d__disjoint(c__OilPaint,c__WatercolorPaint) ).

fof(miloA537,axiom,
    ! [P] :
      ( p__d__instance(P,c__OilPaint)
     => ? [O] :
          ( p__d__instance(O,c__Oil)
          & p__part(O,P) ) ) ).

fof(miloA538,axiom,
    p__d__subclass(c__OilPicture,c__PaintedPicture) ).

fof(miloA539,axiom,
    p__d__disjoint(c__OilPicture,c__WatercolorPicture) ).

fof(miloA540,axiom,
    ! [P] :
      ( p__d__instance(P,c__OilPicture)
     => ? [O,PAINTING] :
          ( p__d__instance(O,c__OilPaint)
          & p__d__instance(PAINTING,c__Painting)
          & p__resource(PAINTING,O)
          & p__result(PAINTING,P) ) ) ).

fof(miloA541,axiom,
    p__d__subclass(c__ArtPainting,c__ContentDevelopment) ).

fof(miloA542,axiom,
    p__d__subclass(c__ArtPainting,c__Painting) ).

fof(miloA543,axiom,
    ! [PAINT] :
      ( p__d__instance(PAINT,c__ArtPainting)
     => ? [PICTURE] :
          ( p__d__instance(PICTURE,c__PaintedPicture)
          & p__result(PAINT,PICTURE) ) ) ).

fof(miloA544,axiom,
    p__d__subclass(c__PaintingDevice,c__Device) ).

fof(miloA545,axiom,
    ! [PD] :
      ( p__d__instance(PD,c__PaintingDevice)
     => ? [PAINT] :
          ( p__d__subclass(PAINT,c__Painting)
          & p__capability(PAINT,c__instrument,PD) ) ) ).

fof(miloA547,axiom,
    p__d__instance(c__potentialOfHydrogen,c__BinaryPredicate) ).

fof(miloA550,axiom,
    ! [S,N] :
      ( ( p__d__instance(N,c__RealNumber)
        & p__d__instance(S,c__Solution)
        & p__potentialOfHydrogen(S,N) )
     => ( p__greaterThanOrEqualTo(N,c__0)
        & p__lessThanOrEqualTo(N,c__14) ) ) ).

fof(miloA551,axiom,
    p__d__subclass(c__Tracing,c__ContentDevelopment) ).

fof(miloA552,axiom,
    p__d__subclass(c__Tracing,c__SurfaceChange) ).

fof(miloA553,axiom,
    ! [T] :
      ( p__d__instance(T,c__Tracing)
     => ? [P] :
          ( p__d__instance(P,c__Blueprint)
          & p__result(T,P) ) ) ).

fof(miloA554,axiom,
    p__d__subclass(c__ComposingMusic,c__ContentDevelopment) ).

fof(miloA555,axiom,
    ! [C] :
      ( p__d__instance(C,c__ComposingMusic)
     => ? [M] :
          ( p__d__instance(M,c__MusicalComposition)
          & p__result(C,M) ) ) ).

fof(miloA556,axiom,
    p__d__subclass(c__Drawing,c__ContentDevelopment) ).

fof(miloA557,axiom,
    p__d__subclass(c__Drawing,c__SurfaceChange) ).

fof(miloA558,axiom,
    ! [DRAW] :
      ( p__d__instance(DRAW,c__Drawing)
     => ? [SKETCH] :
          ( p__d__instance(SKETCH,c__Sketch)
          & p__result(DRAW,SKETCH) ) ) ).

fof(miloA559,axiom,
    p__d__subclass(c__Focusing,c__QuantityChange) ).

fof(miloA560,axiom,
    ! [F] :
      ( p__d__instance(F,c__Focusing)
     => ? [L] :
          ( p__d__instance(L,c__Lens)
          & p__patient(F,L) ) ) ).

fof(miloA561,axiom,
    p__d__subclass(c__DisplayArtifact,c__Artifact) ).

fof(miloA563,axiom,
    p__d__subclass(c__VehicleWheel,c__Wheel) ).

fof(miloA564,axiom,
    p__d__subclass(c__Wheel,c__Artifact) ).

fof(miloA565,axiom,
    ! [VEHICLE] :
      ( p__d__instance(VEHICLE,c__LandVehicle)
     => ? [WHEEL] :
          ( p__d__instance(WHEEL,c__Wheel)
          & p__part(WHEEL,VEHICLE) ) ) ).

fof(miloA566,axiom,
    p__d__subclass(c__VehicleController,c__Device) ).

fof(miloA567,axiom,
    ! [C] :
      ( p__d__instance(C,c__VehicleController)
     => ? [V] :
          ( p__d__instance(V,c__Vehicle)
          & p__part(C,V) ) ) ).

fof(miloA569,axiom,
    p__d__subclass(c__SteeringWheel,c__VehicleController) ).

fof(miloA570,axiom,
    ! [W] :
      ( p__d__instance(W,c__SteeringWheel)
     => p__capability(c__DirectionChange,c__instrument,W) ) ).

fof(miloA571,axiom,
    p__d__subclass(c__VehicleBrake,c__VehicleController) ).

fof(miloA573,axiom,
    p__d__subclass(c__VehicleThrottle,c__VehicleController) ).

fof(miloA574,axiom,
    p__d__subclass(c__VehicleTire,c__Artifact) ).

fof(miloA575,axiom,
    ! [T] :
      ( p__d__instance(T,c__VehicleTire)
     => ? [W] :
          ( p__d__instance(W,c__VehicleWheel)
          & p__part(T,W) ) ) ).

fof(miloA576,axiom,
    p__d__subclass(c__VehicleWindow,c__Window) ).

fof(miloA577,axiom,
    ! [W] :
      ( p__d__instance(W,c__VehicleWindow)
     => ? [V] :
          ( p__d__instance(V,c__Vehicle)
          & p__part(W,V) ) ) ).

fof(miloA578,axiom,
    p__d__subclass(c__Windshield,c__VehicleWindow) ).

fof(miloA579,axiom,
    p__d__disjoint(c__Windshield,c__RearWindow) ).

fof(miloA580,axiom,
    ! [W] :
      ( p__d__instance(W,c__Windshield)
     => ? [A] :
          ( p__d__instance(A,c__SelfConnectedObject)
          & p__d__instance(A,c__RoadVehicle)
          & p__part(W,f__FrontFn1(A)) ) ) ).

fof(miloA581,axiom,
    p__d__subclass(c__LandVehicle,c__Vehicle) ).

fof(miloA583,axiom,
    p__d__subclass(c__WaterVehicle,c__Vehicle) ).

fof(miloA585,axiom,
    ! [CRAFT,EVENT] :
      ( ( p__d__instance(CRAFT,c__WaterVehicle)
        & p__d__instance(EVENT,c__Transportation)
        & p__instrument(EVENT,CRAFT) )
     => ? [WATER] :
          ( p__d__instance(WATER,c__WaterArea)
          & p__eventLocated(EVENT,WATER) ) ) ).

fof(miloA586,axiom,
    p__d__subclass(c__RoadVehicle,c__LandVehicle) ).

fof(miloA587,axiom,
    p__d__subclass(c__Fleet,c__Collection) ).

fof(miloA589,axiom,
    p__d__instance(c__fleetSize,c__BinaryPredicate) ).

fof(miloA592,axiom,
    ! [AGENT,FLEET,NUM] :
      ( ( p__d__instance(NUM,c__Integer)
        & p__d__instance(AGENT,c__Agent)
        & p__d__instance(FLEET,c__Fleet)
        & p__fleetSize(AGENT,NUM)
        & p__possesses(AGENT,FLEET) )
     => p__memberCount(FLEET,NUM) ) ).

fof(miloA593,axiom,
    p__d__subclass(c__Axle,c__Device) ).

fof(miloA594,axiom,
    ! [V,W] :
      ( ( p__d__instance(V,c__CorpuscularObject)
        & p__d__instance(W,c__VehicleWheel)
        & p__d__instance(V,c__RoadVehicle)
        & p__part(W,V) )
     => ? [A] :
          ( p__d__instance(A,c__CorpuscularObject)
          & p__d__instance(A,c__Axle)
          & p__component(A,V)
          & p__connected(W,A) ) ) ).

fof(miloA595,axiom,
    p__d__subclass(c__Paper,c__Artifact) ).

fof(miloA597,axiom,
    p__d__subclass(c__CurrencyBill,c__Currency) ).

fof(miloA598,axiom,
    p__d__partition3(c__Currency,c__CurrencyBill,c__CurrencyCoin) ).

fof(miloA599,axiom,
    ! [BILL] :
      ( p__d__instance(BILL,c__CurrencyBill)
     => ? [PAPER] :
          ( p__d__instance(PAPER,c__Paper)
          & p__part(PAPER,BILL) ) ) ).

fof(miloA600,axiom,
    p__d__subclass(c__CurrencyCoin,c__Currency) ).

fof(miloA601,axiom,
    ! [COIN] :
      ( p__d__instance(COIN,c__CurrencyCoin)
     => ? [METAL] :
          ( p__d__subclass(METAL,c__Metal)
          & p__material(METAL,COIN) ) ) ).

fof(miloA602,axiom,
    p__d__subclass(c__Wire,c__Artifact) ).

fof(miloA603,axiom,
    ! [WIRE] :
      ( ( p__d__instance(WIRE,c__CorpuscularObject)
        & p__d__instance(WIRE,c__Wire) )
     => p__material(c__Metal,WIRE) ) ).

fof(miloA604,axiom,
    p__d__subclass(c__WireSpring,c__Wire) ).

fof(miloA605,axiom,
    p__d__subclass(c__WireSpring,c__EngineeringComponent) ).

fof(miloA606,axiom,
    p__d__subclass(c__WireLine,c__Wire) ).

fof(miloA607,axiom,
    p__d__subclass(c__WireLine,c__EngineeringComponent) ).

fof(miloA609,axiom,
    p__d__subclass(c__TelephoneLine,c__WireLine) ).

fof(miloA610,axiom,
    ! [TL] :
      ( ( p__d__instance(TL,c__SelfConnectedObject)
        & p__d__instance(TL,c__TelephoneLine) )
     => ? [T1,T2] :
          ( p__d__instance(T1,c__SelfConnectedObject)
          & p__d__instance(T2,c__SelfConnectedObject)
          & ( p__d__instance(T1,c__Telephone)
            | p__d__instance(T1,c__Telegraph) )
          & ( p__d__instance(T2,c__Telephone)
            | p__d__instance(T2,c__Telegraph) )
          & T1 != T2
          & p__connects(TL,T1,T2) ) ) ).

fof(miloA611,axiom,
    p__d__subclass(c__String,c__Artifact) ).

fof(miloA613,axiom,
    p__d__subclass(c__Plug,c__Artifact) ).

fof(miloA614,axiom,
    ! [PLUG] :
      ( p__d__instance(PLUG,c__Plug)
     => ? [HOLE] :
          ( p__d__instance(HOLE,c__Hole)
          & p__completelyFills(PLUG,HOLE) ) ) ).

fof(miloA615,axiom,
    p__d__subclass(c__Pottery,c__Artifact) ).

fof(miloA616,axiom,
    ! [POTTERY] :
      ( p__d__instance(POTTERY,c__Pottery)
     => ? [CLAY] :
          ( p__d__instance(CLAY,c__Clay)
          & p__part(CLAY,POTTERY) ) ) ).

fof(miloA617,axiom,
    p__d__subclass(c__Pillow,c__Artifact) ).

fof(miloA618,axiom,
    p__d__subclass(c__Mirror,c__Artifact) ).

fof(miloA619,axiom,
    ! [M] :
      ( p__d__instance(M,c__Mirror)
     => p__capability(c__ReflectingLight,c__instrument,M) ) ).

fof(miloA620,axiom,
    p__d__subclass(c__Furniture,c__Artifact) ).

fof(miloA622,axiom,
    ! [F] :
      ( p__d__instance(F,c__Furniture)
     => p__capability(c__Translocation,c__moves,F) ) ).

fof(miloA623,axiom,
    p__d__disjoint(c__Furniture,c__EngineeringComponent) ).

fof(miloA624,axiom,
    p__d__disjoint(c__Furniture,c__Machine) ).

fof(miloA625,axiom,
    p__d__disjoint(c__Furniture,c__TransportationDevice) ).

fof(miloA626,axiom,
    p__d__disjoint(c__Furniture,c__Weapon) ).

fof(miloA627,axiom,
    p__d__subclass(c__Seat,c__Furniture) ).

fof(miloA629,axiom,
    p__d__subclass(c__Chair,c__Seat) ).

fof(miloA630,axiom,
    ! [CHAIR] :
      ( p__d__instance(CHAIR,c__Chair)
     => ! [PERSON1,PERSON2] :
          ( ~ p__d__instance(PERSON1,c__Object)
          | ~ p__d__instance(PERSON2,c__Object)
          | ~ p__d__instance(PERSON1,c__Human)
          | ~ p__d__instance(PERSON2,c__Human)
          | ~ p__attribute(PERSON1,c__Sitting)
          | ~ p__attribute(PERSON2,c__Sitting)
          | ~ p__located(PERSON1,CHAIR)
          | ~ p__located(PERSON2,CHAIR)
          | PERSON1 = PERSON2 ) ) ).

fof(miloA631,axiom,
    p__d__subclass(c__Sofa,c__Seat) ).

fof(miloA633,axiom,
    p__d__subclass(c__Bed,c__Furniture) ).

fof(miloA635,axiom,
    p__d__subclass(c__KingBed,c__Bed) ).

fof(miloA637,axiom,
    p__d__subclass(c__QueenBed,c__Bed) ).

fof(miloA639,axiom,
    p__d__subclass(c__DoubleBed,c__Bed) ).

fof(miloA641,axiom,
    p__d__subclass(c__SingleBed,c__Bed) ).

fof(miloA642,axiom,
    p__d__subclass(c__BunkBed,c__Bed) ).

fof(miloA643,axiom,
    ! [X] :
      ( p__d__instance(X,c__BunkBed)
     => ? [BED1,BED2] :
          ( p__d__instance(BED1,c__SingleBed)
          & p__d__instance(BED2,c__SingleBed)
          & p__part(BED1,X)
          & p__part(BED2,X)
          & p__orientation(BED1,BED2,c__Above) ) ) ).

fof(miloA644,axiom,
    p__d__subclass(c__MurphyBed,c__Bed) ).

fof(miloA646,axiom,
    p__d__subclass(c__RollawayBed,c__Bed) ).

fof(miloA647,axiom,
    ! [X] :
      ( p__d__instance(X,c__RollawayBed)
     => ? [WHEEL] :
          ( p__d__instance(WHEEL,c__Wheel)
          & p__part(WHEEL,X) ) ) ).

fof(miloA648,axiom,
    p__d__subclass(c__SofaBed,c__Bed) ).

fof(miloA650,axiom,
    p__d__subclass(c__Crib,c__Bed) ).

fof(miloA652,axiom,
    p__d__subclass(c__Hammock,c__Bed) ).

fof(miloA655,axiom,
    p__d__subclass(c__Mattress,c__Artifact) ).

fof(miloA656,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__CorpuscularObject)
        & p__d__instance(X,c__Mattress) )
     => ? [BED] :
          ( p__d__instance(BED,c__CorpuscularObject)
          & p__d__instance(BED,c__Bed)
          & p__component(X,BED) ) ) ).

fof(miloA658,axiom,
    p__d__subclass(c__BedFrame,c__Artifact) ).

fof(miloA659,axiom,
    ! [X,MATTRESS,BEDFRAME] :
      ( ( p__d__instance(X,c__CorpuscularObject)
        & p__d__instance(BEDFRAME,c__CorpuscularObject)
        & p__d__instance(MATTRESS,c__CorpuscularObject)
        & p__d__instance(X,c__Bed)
        & p__component(BEDFRAME,X)
        & p__d__instance(BEDFRAME,c__BedFrame)
        & p__component(MATTRESS,X)
        & p__d__instance(MATTRESS,c__Mattress) )
     => p__orientation(MATTRESS,BEDFRAME,c__On) ) ).

fof(miloA660,axiom,
    p__d__subclass(c__FourPosterBed,c__BedFrame) ).

fof(miloA661,axiom,
    ! [X] :
      ( p__d__instance(X,c__FourPosterBed)
     => ? [SHAPE] :
          ( p__attribute(X,SHAPE)
          & p__d__instance(SHAPE,c__Quadrilateral) ) ) ).

fof(miloA662,axiom,
    p__d__subclass(c__BedAttribute,c__RelationalAttribute) ).

fof(miloA663,axiom,
    ! [ATTR,X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,ATTR)
        & p__d__instance(ATTR,c__BedAttribute) )
     => p__d__instance(X,c__Bed) ) ).

fof(miloA664,axiom,
    p__d__instance(c__WaterBed,c__BedAttribute) ).

fof(miloA665,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__CorpuscularObject)
        & p__attribute(X,c__WaterBed) )
     => ? [MATTRESS,WATER] :
          ( p__d__instance(MATTRESS,c__CorpuscularObject)
          & p__component(MATTRESS,X)
          & p__contains(MATTRESS,WATER)
          & p__d__instance(WATER,c__Water) ) ) ).

fof(miloA666,axiom,
    p__d__subclass(c__BedLinen,c__Artifact) ).

fof(miloA669,axiom,
    p__d__subclass(c__Table,c__Furniture) ).

fof(miloA670,axiom,
    p__d__subclass(c__Desk,c__Table) ).

fof(miloA671,axiom,
    p__d__subclass(c__ChestOrCabinet,c__Furniture) ).

fof(miloA672,axiom,
    p__d__subclass(c__ChestOrCabinet,c__Container) ).

fof(miloA673,axiom,
    p__d__subclass(c__Coffin,c__Container) ).

fof(miloA675,axiom,
    p__d__subclass(c__Compartment,c__Container) ).

fof(miloA676,axiom,
    ! [C] :
      ( p__d__instance(C,c__Compartment)
     => ? [O] :
          ( p__d__instance(O,c__Container)
          & C != O
          & p__part(C,O) ) ) ).

fof(miloA677,axiom,
    p__d__subclass(c__Mailbox,c__Container) ).

fof(miloA679,axiom,
    p__d__subclass(c__Screw,c__AttachingDevice) ).

fof(miloA680,axiom,
    p__d__subclass(c__Screwdriver,c__Device) ).

fof(miloA682,axiom,
    p__d__subclass(c__Hammer,c__Device) ).

fof(miloA684,axiom,
    p__d__subclass(c__Nail,c__AttachingDevice) ).

fof(miloA685,axiom,
    p__d__subclass(c__Tape,c__AttachingDevice) ).

fof(miloA686,axiom,
    ! [TAPE] :
      ( p__d__instance(TAPE,c__Tape)
     => ? [PART] :
          ( p__d__instance(PART,c__Object)
          & p__part(PART,TAPE)
          & ( p__d__instance(PART,c__Paper)
            | p__d__instance(PART,c__Fabric) ) ) ) ).

fof(miloA687,axiom,
    p__d__subclass(c__Anchor,c__AttachingDevice) ).

fof(miloA688,axiom,
    ! [A,ATTACH,S] :
      ( ( p__d__instance(A,c__Anchor)
        & p__d__instance(ATTACH,c__Attaching)
        & p__instrument(ATTACH,A)
        & p__patient(ATTACH,S) )
     => p__d__instance(S,c__WaterVehicle) ) ).

fof(miloA689,axiom,
    p__d__subclass(c__BoatDeck,c__Artifact) ).

fof(miloA690,axiom,
    ! [D] :
      ( p__d__instance(D,c__BoatDeck)
     => ? [B] :
          ( p__d__instance(B,c__WaterVehicle)
          & p__part(D,B) ) ) ).

fof(miloA691,axiom,
    p__d__subclass(c__Button,c__AttachingDevice) ).

fof(miloA693,axiom,
    p__d__subclass(c__Clamp,c__AttachingDevice) ).

fof(miloA694,axiom,
    p__d__subclass(c__Washer,c__Device) ).

fof(miloA696,axiom,
    ! [O1,O2,W] :
      ( ( p__d__instance(W,c__SelfConnectedObject)
        & p__d__instance(W,c__Washer)
        & p__d__instance(O1,c__CorpuscularObject)
        & p__d__instance(O2,c__AttachingDevice)
        & p__meetsSpatially(O1,W)
        & p__contains(W,O2) )
     => ? [PURPOSE] :
          ( p__d__instance(PURPOSE,c__Formula)
          & p__hasPurpose(W,PURPOSE) ) ) ).

fof(miloA698,axiom,
    p__d__subclass(c__Holder,c__Device) ).

fof(miloA699,axiom,
    ! [DEVICE] :
      ( p__d__instance(DEVICE,c__Holder)
     => p__capability(c__Keeping,c__instrument,DEVICE) ) ).

fof(miloA700,axiom,
    p__d__subclass(c__Saddle,c__Holder) ).

fof(miloA702,axiom,
    p__d__subclass(c__HorseRiding,c__Carrying) ).

fof(miloA703,axiom,
    ! [R] :
      ( p__d__instance(R,c__HorseRiding)
     => ? [H] :
          ( p__d__instance(H,c__Horse)
          & p__instrument(R,H) ) ) ).

fof(miloA704,axiom,
    p__d__instance(c__carries,c__BinaryPredicate) ).

fof(miloA707,axiom,
    ! [AGENT,OBJECT] :
      ( ( p__d__instance(OBJECT,c__Object)
        & p__d__instance(AGENT,c__Agent)
        & p__carries(AGENT,OBJECT) )
     => ? [CARRYING] :
          ( p__d__instance(CARRYING,c__Process)
          & p__instrument(CARRYING,AGENT)
          & p__patient(CARRYING,OBJECT) ) ) ).

fof(miloA708,axiom,
    p__d__subclass(c__Tray,c__Holder) ).

fof(miloA709,axiom,
    p__d__subclass(c__Dish,c__Holder) ).

fof(miloA711,axiom,
    p__d__subclass(c__Container,c__Holder) ).

fof(miloA713,axiom,
    p__d__subclass(c__Bag,c__Container) ).

fof(miloA714,axiom,
    ! [BAG] :
      ( p__d__instance(BAG,c__Bag)
     => p__attribute(BAG,c__Pliable) ) ).

fof(miloA716,axiom,
    p__d__subclass(c__Box,c__Container) ).

fof(miloA718,axiom,
    p__d__subclass(c__TrapOrCage,c__Holder) ).

fof(miloA720,axiom,
    p__d__subclass(c__Envelope,c__Container) ).

fof(miloA721,axiom,
    p__d__subclass(c__TravelContainer,c__Container) ).

fof(miloA722,axiom,
    p__d__subclass(c__FluidContainer,c__Container) ).

fof(miloA723,axiom,
    ! [TANK,STUFF] :
      ( ( p__d__instance(TANK,c__SelfConnectedObject)
        & p__d__instance(STUFF,c__Object)
        & p__d__instance(TANK,c__FluidContainer)
        & p__contains(TANK,STUFF) )
     => p__attribute(STUFF,c__Fluid) ) ).

fof(miloA724,axiom,
    p__d__subclass(c__Bottle,c__FluidContainer) ).

fof(miloA725,axiom,
    ! [BOTTLE,STUFF] :
      ( ( p__d__instance(BOTTLE,c__SelfConnectedObject)
        & p__d__instance(STUFF,c__Object)
        & p__d__instance(BOTTLE,c__Bottle)
        & p__contains(BOTTLE,STUFF) )
     => p__attribute(STUFF,c__Liquid) ) ).

fof(miloA726,axiom,
    ! [BOTTLE,BOTTOM,TOP,WIDTH2,WIDTH1] :
      ( ( p__d__instance(BOTTLE,c__SelfConnectedObject)
        & p__d__instance(BOTTOM,c__SelfConnectedObject)
        & p__d__instance(TOP,c__SelfConnectedObject)
        & p__d__instance(WIDTH1,c__LengthMeasure)
        & p__d__instance(WIDTH2,c__LengthMeasure)
        & p__d__instance(BOTTLE,c__Bottle)
        & p__bottom(BOTTOM,BOTTLE)
        & p__top(TOP,BOTTLE)
        & p__width(BOTTOM,WIDTH1)
        & p__width(TOP,WIDTH2) )
     => p__lessThan(WIDTH2,WIDTH1) ) ).

fof(miloA727,axiom,
    p__d__subclass(c__DrinkingCup,c__FluidContainer) ).

fof(miloA728,axiom,
    ! [CUP,STUFF] :
      ( ( p__d__instance(CUP,c__SelfConnectedObject)
        & p__d__instance(STUFF,c__Object)
        & p__d__instance(CUP,c__DrinkingCup)
        & p__contains(CUP,STUFF) )
     => p__d__instance(STUFF,c__Beverage) ) ).

fof(miloA729,axiom,
    p__d__subclass(c__SwimmingPool,c__FluidContainer) ).

fof(miloA730,axiom,
    p__d__subclass(c__SwimmingPool,c__StationaryArtifact) ).

fof(miloA733,axiom,
    p__d__subclass(c__BoardOrBlock,c__Artifact) ).

fof(miloA734,axiom,
    ! [BOARD] :
      ( p__d__instance(BOARD,c__BoardOrBlock)
     => p__capability(c__Constructing,c__resource,BOARD) ) ).

fof(miloA735,axiom,
    p__d__subclass(c__Brick,c__BoardOrBlock) ).

fof(miloA736,axiom,
    ! [B] :
      ( ( p__d__instance(B,c__CorpuscularObject)
        & p__d__instance(B,c__Brick) )
     => p__material(c__Clay,B) ) ).

fof(miloA738,axiom,
    p__d__subclass(c__Veneer,c__Artifact) ).

fof(miloA739,axiom,
    ! [V] :
      ( p__d__instance(V,c__Veneer)
     => p__attribute(V,c__Flat) ) ).

fof(miloA741,axiom,
    p__d__instance(c__tangent,c__BinaryPredicate) ).

fof(miloA744,axiom,
    ! [LINE,CIRCLE] :
      ( ( p__d__instance(CIRCLE,c__TwoDimensionalFigure)
        & p__d__instance(LINE,c__OneDimensionalFigure)
        & p__tangent(LINE,CIRCLE) )
     => ? [POINT1] :
          ( p__d__instance(POINT1,c__GeometricPoint)
          & p__pointOfFigure(POINT1,LINE)
          & p__pointOfFigure(POINT1,CIRCLE)
          & ! [POINT2] :
              ( ( p__d__instance(POINT2,c__GeometricPoint)
                & p__pointOfFigure(POINT2,LINE)
                & p__pointOfFigure(POINT2,CIRCLE) )
             => POINT1 = POINT2 ) ) ) ).

fof(miloA745,axiom,
    p__d__subclass(c__TwoDimensionalObject,c__Object) ).

fof(miloA746,axiom,
    p__d__instance(c__sliceOfFigure,c__BinaryPredicate) ).

fof(miloA749,axiom,
    p__d__instance(c__RoundShape,c__ThreeDimensionalFigure) ).

fof(miloA750,axiom,
    p__d__subclass(c__Cone,c__ThreeDimensionalFigure) ).

fof(miloA751,axiom,
    p__d__subclass(c__Cylinder,c__ThreeDimensionalFigure) ).

fof(miloA752,axiom,
    p__d__subclass(c__ObliqueAngle,c__TwoDimensionalAngle) ).

fof(miloA754,axiom,
    p__d__subclass(c__RightAngle,c__TwoDimensionalAngle) ).

fof(miloA756,axiom,
    p__d__subclass(c__AcuteAngle,c__TwoDimensionalAngle) ).

fof(miloA757,axiom,
    p__d__partition4(c__TwoDimensionalAngle,c__RightAngle,c__ObliqueAngle,c__AcuteAngle) ).

fof(miloA759,axiom,
    p__d__subclass(c__Polygon,c__ClosedTwoDimensionalFigure) ).

fof(miloA760,axiom,
    ! [POLYGON,PART] :
      ( ( p__d__instance(PART,c__OneDimensionalFigure)
        & p__d__instance(POLYGON,c__Polygon)
        & p__geometricPart(PART,POLYGON) )
     => ( p__sideOfFigure(PART,POLYGON)
        | ? [SIDE] :
            ( p__d__instance(SIDE,c__OneDimensionalFigure)
            & p__sideOfFigure(SIDE,POLYGON)
            & p__geometricPart(PART,SIDE) ) ) ) ).

fof(miloA761,axiom,
    p__d__subclass(c__Triangle,c__Polygon) ).

fof(miloA763,axiom,
    p__d__subclass(c__RightTriangle,c__Triangle) ).

fof(miloA764,axiom,
    ! [T] :
      ( p__d__instance(T,c__RightTriangle)
     => ? [A] :
          ( p__d__instance(A,c__RightAngle)
          & p__angleOfFigure(A,T) ) ) ).

fof(miloA765,axiom,
    p__d__subclass(c__Quadrilateral,c__Polygon) ).

fof(miloA767,axiom,
    p__d__subclass(c__Rectangle,c__Quadrilateral) ).

fof(miloA768,axiom,
    ! [RECTANGLE,ANGLE] :
      ( ( p__d__instance(ANGLE,c__TwoDimensionalAngle)
        & p__d__instance(RECTANGLE,c__Rectangle)
        & p__angleOfFigure(ANGLE,RECTANGLE) )
     => p__d__instance(ANGLE,c__RightAngle) ) ).

fof(miloA769,axiom,
    p__d__subclass(c__Square,c__Rectangle) ).

fof(miloA770,axiom,
    ! [SQUARE] :
      ( p__d__instance(SQUARE,c__Square)
     => ? [LENGTH] :
          ( p__d__instance(LENGTH,c__LengthMeasure)
          & ! [SIDE] :
              ( ( p__d__instance(SIDE,c__OneDimensionalFigure)
                & p__sideOfFigure(SIDE,SQUARE) )
             => p__lineMeasure(SIDE,LENGTH) ) ) ) ).

fof(miloA771,axiom,
    p__d__instance(c__DiameterFn,c__UnaryFunction) ).

fof(miloA772,axiom,
    p__d__instance(c__DiameterFn,c__TotalValuedRelation) ).

fof(miloA775,axiom,
    ! [C,L] :
      ( ( p__d__instance(C,c__Circle)
        & p__d__instance(L,c__LengthMeasure)
        & f__DiameterFn1(C) = L )
     => ? [R] :
          ( p__d__instance(R,c__LengthMeasure)
          & f__RadiusFn1(C) = R
          & f__MultiplicationFn2(R,c__2) = L ) ) ).

fof(miloA776,axiom,
    p__d__instance(c__RadiusFn,c__UnaryFunction) ).

fof(miloA777,axiom,
    p__d__instance(c__RadiusFn,c__TotalValuedRelation) ).

fof(miloA780,axiom,
    ! [P2,P,C,R] :
      ( ( p__d__instance(C,c__Circle)
        & p__d__instance(P,c__GeometricPoint)
        & p__d__instance(P2,c__GeometricPoint)
        & p__d__instance(R,c__LengthMeasure)
        & f__CenterOfCircleFn1(C) = P
        & p__pointOfFigure(P2,C)
        & p__geometricDistance(P2,P,R) )
     => f__RadiusFn1(C) = R ) ).

fof(miloA781,axiom,
    p__d__subclass(c__CircleSector,c__ClosedTwoDimensionalFigure) ).

fof(miloA782,axiom,
    p__subrelation(c__sideOfFigure,c__geometricPart) ).

fof(miloA785,axiom,
    p__d__subclass(c__Sphere,c__ThreeDimensionalFigure) ).

fof(miloA786,axiom,
    p__d__subclass(c__Bubble,c__CorpuscularObject) ).

fof(miloA787,axiom,
    ! [B] :
      ( p__d__instance(B,c__Bubble)
     => ? [S] :
          ( p__d__instance(S,c__SelfConnectedObject)
          & p__surface(S,B)
          & p__attribute(S,c__Liquid) ) ) ).

fof(miloA788,axiom,
    ! [B,P] :
      ( ( p__d__instance(P,c__Object)
        & p__d__instance(B,c__Bubble)
        & p__interiorPart(P,B) )
     => p__attribute(P,c__Gas) ) ).

fof(miloA789,axiom,
    ! [B] :
      ( ( p__d__instance(B,c__Bubble)
        & ! [X,S] :
            ( ~ p__d__instance(S,c__Attribute)
            | ~ p__d__instance(X,c__Object)
            | ~ p__attribute(X,S)
            | X = c__Gas
            | ~ p__meetsSpatially(X,B) ) )
     => p__attribute(B,c__RoundShape) ) ).

fof(miloA790,axiom,
    p__d__subclass(c__Nest,c__CorpuscularObject) ).

fof(miloA792,axiom,
    p__d__subclass(c__OutdoorClothing,c__Clothing) ).

fof(miloA794,axiom,
    p__d__subclass(c__Apron,c__Clothing) ).

fof(miloA796,axiom,
    p__d__subclass(c__Belt,c__Clothing) ).

fof(miloA797,axiom,
    ! [P,B] :
      ( ( p__d__instance(P,c__Animal)
        & p__wears(P,B)
        & p__d__instance(B,c__Belt) )
     => ? [C] :
          ( p__d__instance(C,c__Clothing)
          & p__wears(P,C)
          & p__meetsSpatially(B,C) ) ) ).

fof(miloA798,axiom,
    p__d__subclass(c__TieClothing,c__Clothing) ).

fof(miloA799,axiom,
    ! [P,T] :
      ( ( p__d__instance(T,c__SelfConnectedObject)
        & p__d__instance(P,c__Animal)
        & p__wears(P,T)
        & p__d__instance(T,c__TieClothing) )
     => ? [N] :
          ( p__d__instance(N,c__Neck)
          & p__part(N,P)
          & p__contains(T,N) ) ) ).

fof(miloA800,axiom,
    p__d__subclass(c__Cloak,c__Clothing) ).

fof(miloA801,axiom,
    p__d__subclass(c__Collar,c__Clothing) ).

fof(miloA802,axiom,
    ! [C] :
      ( p__d__instance(C,c__Collar)
     => ? [OC] :
          ( p__d__instance(OC,c__Object)
          & p__part(C,OC)
          & ( p__d__instance(OC,c__Coat)
            | p__d__instance(OC,c__Shirt) ) ) ) ).

fof(miloA803,axiom,
    ! [P,C] :
      ( ( p__d__instance(P,c__Animal)
        & p__wears(P,C)
        & p__d__instance(C,c__Collar) )
     => ? [N] :
          ( p__d__instance(N,c__Neck)
          & p__part(N,P)
          & p__meetsSpatially(C,N) ) ) ).

fof(miloA804,axiom,
    p__d__subclass(c__Glove,c__Clothing) ).

fof(miloA805,axiom,
    ! [P,G] :
      ( ( p__d__instance(P,c__Animal)
        & p__wears(P,G)
        & p__d__instance(G,c__Glove) )
     => ? [H] :
          ( p__d__instance(H,c__Hand)
          & p__part(H,P)
          & p__meetsSpatially(G,H) ) ) ).

fof(miloA806,axiom,
    p__d__subclass(c__Hat,c__Clothing) ).

fof(miloA807,axiom,
    ! [PERSON,HAT] :
      ( ( p__d__instance(PERSON,c__Animal)
        & p__wears(PERSON,HAT)
        & p__d__instance(HAT,c__Hat) )
     => ? [HEAD] :
          ( p__d__instance(HEAD,c__Head)
          & p__part(HEAD,PERSON)
          & p__meetsSpatially(HAT,HEAD) ) ) ).

fof(miloA808,axiom,
    p__d__subclass(c__Coat,c__OutdoorClothing) ).

fof(miloA809,axiom,
    p__d__subclass(c__Trousers,c__Clothing) ).

fof(miloA810,axiom,
    ! [H,T] :
      ( ( p__d__instance(T,c__SelfConnectedObject)
        & p__d__instance(H,c__Animal)
        & p__wears(H,T)
        & p__d__instance(T,c__Trousers) )
     => ? [L] :
          ( p__d__instance(L,c__Leg)
          & p__part(L,H)
          & p__contains(T,L) ) ) ).

fof(miloA811,axiom,
    p__d__subclass(c__Shoe,c__Clothing) ).

fof(miloA812,axiom,
    ! [PERSON,SHOE] :
      ( ( p__d__instance(PERSON,c__Animal)
        & p__wears(PERSON,SHOE)
        & p__d__instance(SHOE,c__Shoe) )
     => ? [FOOT] :
          ( p__d__instance(FOOT,c__Foot)
          & p__part(FOOT,PERSON)
          & p__meetsSpatially(SHOE,FOOT) ) ) ).

fof(miloA813,axiom,
    p__d__subclass(c__ShoeSole,c__Artifact) ).

fof(miloA814,axiom,
    ! [SS] :
      ( ( p__d__instance(SS,c__SelfConnectedObject)
        & p__d__instance(SS,c__ShoeSole) )
     => ? [S] :
          ( p__d__instance(S,c__SelfConnectedObject)
          & p__d__instance(S,c__Shoe)
          & p__bottom(SS,S) ) ) ).

fof(miloA815,axiom,
    p__d__subclass(c__Sandal,c__Shoe) ).

fof(miloA817,axiom,
    ! [S] :
      ( p__d__instance(S,c__Sandal)
     => ? [SOLE] :
          ( p__d__instance(SOLE,c__ShoeSole)
          & p__part(SOLE,S)
          & p__attribute(SOLE,c__Flat) ) ) ).

fof(miloA818,axiom,
    p__d__subclass(c__Sock,c__Clothing) ).

fof(miloA819,axiom,
    ! [P,S] :
      ( ( p__d__instance(S,c__SelfConnectedObject)
        & p__d__instance(P,c__Animal)
        & p__wears(P,S)
        & p__d__instance(S,c__Sock) )
     => ? [F] :
          ( p__d__instance(F,c__Foot)
          & p__part(F,P)
          & p__contains(S,F) ) ) ).

fof(miloA820,axiom,
    p__d__subclass(c__Shirt,c__Clothing) ).

fof(miloA821,axiom,
    ! [SHIRT,PERSON] :
      ( ( p__d__instance(PERSON,c__Animal)
        & p__d__instance(SHIRT,c__Shirt)
        & p__wears(PERSON,SHIRT) )
     => p__d__instance(PERSON,c__Human) ) ).

fof(miloA822,axiom,
    p__d__subclass(c__Sleeve,c__Clothing) ).

fof(miloA823,axiom,
    ! [P,S] :
      ( ( p__d__instance(S,c__SelfConnectedObject)
        & p__d__instance(P,c__Animal)
        & p__wears(P,S)
        & p__d__instance(S,c__Sleeve) )
     => ? [A] :
          ( p__d__instance(A,c__Arm)
          & p__part(A,P)
          & p__contains(S,A) ) ) ).

fof(miloA824,axiom,
    ! [S] :
      ( p__d__instance(S,c__Sleeve)
     => ? [C] :
          ( p__d__instance(C,c__Object)
          & p__part(S,C)
          & ( p__d__instance(C,c__Shirt)
            | p__d__instance(C,c__Coat) ) ) ) ).

fof(miloA825,axiom,
    p__d__subclass(c__Dress,c__Clothing) ).

fof(miloA826,axiom,
    ! [DRESS,PERSON] :
      ( ( p__d__instance(PERSON,c__Animal)
        & p__d__instance(DRESS,c__Dress)
        & p__wears(PERSON,DRESS) )
     => p__d__instance(PERSON,c__Woman) ) ).

fof(miloA827,axiom,
    p__d__subclass(c__ClothingSuit,c__Collection) ).

fof(miloA829,axiom,
    p__d__subclass(c__Rug,c__Fabric) ).

fof(miloA831,axiom,
    p__d__subclass(c__Towel,c__Fabric) ).

fof(miloA832,axiom,
    ! [X] :
      ( p__d__instance(X,c__Towel)
     => p__capability(c__Drying,c__instrument,X) ) ).

fof(miloA834,axiom,
    p__d__subclass(c__Leather,c__Fabric) ).

fof(miloA835,axiom,
    ! [LEATHER] :
      ( p__d__instance(LEATHER,c__Leather)
     => ? [MAKE,SKIN] :
          ( p__d__instance(MAKE,c__Making)
          & p__resource(MAKE,SKIN)
          & p__d__instance(SKIN,c__Skin)
          & p__result(MAKE,LEATHER) ) ) ).

fof(miloA836,axiom,
    p__d__subclass(c__Silk,c__Fabric) ).

fof(miloA837,axiom,
    ! [S] :
      ( p__d__instance(S,c__Silk)
     => ? [M,T,I] :
          ( p__d__instance(T,c__Object)
          & p__d__instance(M,c__Making)
          & p__result(M,S)
          & p__resource(M,T)
          & p__part(T,I)
          & p__d__instance(I,c__Insect)
          & p__attribute(I,c__Larval) ) ) ).

fof(miloA838,axiom,
    p__d__subclass(c__Wool,c__Fabric) ).

fof(miloA839,axiom,
    ! [W] :
      ( p__d__instance(W,c__Wool)
     => ? [M,H,S] :
          ( p__d__instance(M,c__Making)
          & p__result(M,W)
          & p__resource(M,H)
          & p__part(H,S)
          & p__d__instance(H,c__Hair)
          & p__d__instance(S,c__Sheep) ) ) ).

fof(miloA840,axiom,
    p__d__subclass(c__Pocket,c__Fabric) ).

fof(miloA841,axiom,
    ! [POCKET] :
      ( p__d__instance(POCKET,c__Pocket)
     => ? [CLOTHING] :
          ( p__d__instance(CLOTHING,c__Clothing)
          & p__part(POCKET,CLOTHING) ) ) ).

fof(miloA842,axiom,
    ! [POCKET] :
      ( p__d__instance(POCKET,c__Pocket)
     => p__capability(c__Keeping,c__instrument,POCKET) ) ).

fof(miloA843,axiom,
    p__d__subclass(c__Blanket,c__Fabric) ).

fof(miloA845,axiom,
    p__d__subclass(c__Cotton,c__PlantAnatomicalStructure) ).

fof(miloA846,axiom,
    p__d__subclass(c__CottonFabric,c__Fabric) ).

fof(miloA847,axiom,
    ! [F] :
      ( p__d__instance(F,c__CottonFabric)
     => ? [M,C] :
          ( p__d__instance(M,c__Making)
          & p__resource(M,C)
          & p__d__instance(C,c__Cotton)
          & p__result(M,F) ) ) ).

fof(miloA849,axiom,
    p__d__subclass(c__Veil,c__Clothing) ).

fof(miloA851,axiom,
    p__d__subclass(c__Concealing,c__Putting) ).

fof(miloA853,axiom,
    p__d__subclass(c__Dressing,c__Putting) ).

fof(miloA855,axiom,
    p__d__subclass(c__ChangingClothing,c__Transfer) ).

fof(miloA856,axiom,
    ! [CC] :
      ( p__d__instance(CC,c__ChangingClothing)
     => ? [R,D] :
          ( p__d__instance(R,c__RemovingClothing)
          & p__d__instance(D,c__Dressing)
          & p__subProcess(R,CC)
          & p__subProcess(D,CC) ) ) ).

fof(miloA857,axiom,
    p__d__subclass(c__RemovingClothing,c__Uncovering) ).

fof(miloA859,axiom,
    p__d__subclass(c__Cleaning,c__Maintaining) ).

fof(miloA861,axiom,
    p__d__subclass(c__Sweeping,c__Removing) ).

fof(miloA862,axiom,
    ! [S,B] :
      ( ( p__d__instance(B,c__Physical)
        & p__d__instance(S,c__Sweeping)
        & p__instrument(S,B) )
     => p__d__instance(B,c__Broom) ) ).

fof(miloA863,axiom,
    p__d__subclass(c__Washing,c__Removing) ).

fof(miloA864,axiom,
    p__d__subclass(c__Washing,c__Cleaning) ).

fof(miloA865,axiom,
    p__d__subclass(c__CleaningDevice,c__Device) ).

fof(miloA867,axiom,
    p__d__subclass(c__Tying,c__Attaching) ).

fof(miloA868,axiom,
    p__d__subclass(c__Untying,c__Detaching) ).

fof(miloA869,axiom,
    p__d__disjoint(c__Untying,c__Tying) ).

fof(miloA870,axiom,
    p__d__subclass(c__Sewing,c__Attaching) ).

fof(miloA871,axiom,
    ! [S] :
      ( p__d__instance(S,c__Sewing)
     => ? [F] :
          ( p__d__instance(F,c__Fabric)
          & p__patient(S,F) ) ) ).

fof(miloA872,axiom,
    p__d__subclass(c__Soldering,c__Attaching) ).

fof(miloA873,axiom,
    ! [S,OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__d__instance(S,c__Soldering)
        & p__patient(S,OBJ1)
        & p__patient(S,OBJ2)
        & OBJ1 != OBJ2 )
     => ? [A] :
          ( p__d__instance(A,c__MetallicAlloy)
          & p__connects(A,OBJ1,OBJ2) ) ) ).

fof(miloA874,axiom,
    p__d__subclass(c__SolderingIron,c__ElectricDevice) ).

fof(miloA875,axiom,
    ! [S] :
      ( p__d__instance(S,c__Soldering)
     => ? [SI] :
          ( p__d__instance(SI,c__SolderingIron)
          & p__instrument(S,SI) ) ) ).

fof(miloA876,axiom,
    ! [SI] :
      ( p__d__instance(SI,c__SolderingIron)
     => ? [X] :
          ( p__d__instance(X,c__CorpuscularObject)
          & p__part(X,SI)
          & p__material(c__Metal,X) ) ) ).

fof(miloA877,axiom,
    ! [S] :
      ( p__d__instance(S,c__Soldering)
     => ? [M] :
          ( p__d__instance(M,c__Melting)
          & p__subProcess(M,S) ) ) ).

fof(miloA878,axiom,
    p__d__instance(c__patientMedical,c__BinaryPredicate) ).

fof(miloA881,axiom,
    ! [PATIENT,DOCTOR] :
      ( ( p__d__instance(DOCTOR,c__CognitiveAgent)
        & p__d__instance(PATIENT,c__Human)
        & p__patientMedical(PATIENT,DOCTOR) )
     => ? [PROCESS] :
          ( p__d__instance(PROCESS,c__Process)
          & p__patient(PROCESS,PATIENT)
          & p__agent(PROCESS,DOCTOR)
          & ( p__d__instance(PROCESS,c__DiagnosticProcess)
            | p__d__instance(PROCESS,c__TherapeuticProcess) ) ) ) ).

fof(miloA882,axiom,
    p__d__subclass(c__Bandage,c__Fabric) ).

fof(miloA884,axiom,
    p__d__subclass(c__Massaging,c__TherapeuticProcess) ).

fof(miloA885,axiom,
    p__d__subclass(c__Massaging,c__Touching) ).

fof(miloA886,axiom,
    p__d__subclass(c__RelievingPain,c__TherapeuticProcess) ).

fof(miloA888,axiom,
    p__d__subclass(c__NonspecificDisease,c__DiseaseOrSyndrome) ).

fof(miloA889,axiom,
    ! [DISEASE] :
      ( p__d__instance(DISEASE,c__NonspecificDisease)
     => ! [AGENT] :
          ( ~ p__d__instance(AGENT,c__Physical)
          | ~ p__d__instance(AGENT,c__Microorganism)
          | ? [VICTIM] :
              ( p__d__instance(VICTIM,c__Object)
              & p__attribute(VICTIM,DISEASE)
              & ~ p__located(AGENT,VICTIM) ) ) ) ).

fof(miloA890,axiom,
    p__d__subclass(c__BacterialDisease,c__InfectiousDisease) ).

fof(miloA891,axiom,
    p__d__subclass(c__InfectiousDisease,c__DiseaseOrSyndrome) ).

fof(miloA892,axiom,
    ! [I,A] :
      ( ( p__d__instance(A,c__Agent)
        & p__d__instance(I,c__InfectiousDisease)
        & p__attribute(A,I) )
     => ? [P,O] :
          ( p__d__instance(P,c__PathologicProcess)
          & p__agent(P,O)
          & p__d__instance(O,c__Microorganism)
          & p__experiencer(P,A) ) ) ).

fof(miloA893,axiom,
    p__d__subclass(c__TakingIll,c__PathologicProcess) ).

fof(miloA895,axiom,
    p__d__subclass(c__ViralDisease,c__InfectiousDisease) ).

fof(miloA896,axiom,
    p__d__instance(c__Diarrhea,c__DiseaseOrSyndrome) ).

fof(miloA897,axiom,
    p__d__instance(c__Emphysema,c__DiseaseOrSyndrome) ).

fof(miloA898,axiom,
    ! [H] :
      ( ( p__d__instance(H,c__Object)
        & p__attribute(H,c__Emphysema) )
     => ? [L,P] :
          ( p__d__instance(L,c__Lung)
          & p__part(L,H)
          & p__d__instance(P,c__PathologicProcess)
          & p__eventLocated(P,L) ) ) ).

fof(miloA899,axiom,
    p__d__instance(c__Fever,c__DiseaseOrSyndrome) ).

fof(miloA900,axiom,
    p__d__instance(c__Goiter,c__DiseaseOrSyndrome) ).

fof(miloA901,axiom,
    ! [H] :
      ( ( p__d__instance(H,c__Object)
        & p__attribute(H,c__Goiter) )
     => ? [G,P] :
          ( p__d__instance(G,c__ThyroidGland)
          & p__part(G,H)
          & p__d__instance(P,c__PathologicProcess)
          & p__eventLocated(P,G) ) ) ).

fof(miloA902,axiom,
    p__d__instance(c__Tuberculosis,c__BacterialDisease) ).

fof(miloA903,axiom,
    p__d__subclass(c__RecoveringFromIllness,c__OrganismProcess) ).

fof(miloA905,axiom,
    p__d__subclass(c__Protozoa,c__Microorganism) ).

fof(miloA906,axiom,
    p__d__instance(c__parasite,c__BinaryPredicate) ).

fof(miloA909,axiom,
    ! [O1,O2] :
      ( ( p__d__instance(O2,c__Organism)
        & p__d__instance(O1,c__Organism)
        & p__parasite(O1,O2) )
     => p__inhabits(O1,O2) ) ).

fof(miloA910,axiom,
    ! [O1,O2] :
      ( ( p__d__instance(O2,c__Organism)
        & p__d__instance(O1,c__Organism)
        & p__parasite(O1,O2) )
     => ? [I] :
          ( p__d__instance(I,c__Injuring)
          & p__agent(I,O1)
          & p__patient(I,O2) ) ) ).

fof(miloA911,axiom,
    p__d__instance(c__Cancer,c__DiseaseOrSyndrome) ).

fof(miloA912,axiom,
    ! [PERSON] :
      ( ( p__d__instance(PERSON,c__Object)
        & p__attribute(PERSON,c__Cancer) )
     => ? [TUMOR] :
          ( p__d__instance(TUMOR,c__Tumor)
          & p__part(TUMOR,PERSON) ) ) ).

fof(miloA913,axiom,
    p__d__subclass(c__Neurosis,c__PsychologicalDysfunction) ).

fof(miloA914,axiom,
    p__d__subclass(c__Psychosis,c__PsychologicalDysfunction) ).

fof(miloA915,axiom,
    p__d__subclass(c__Atrophy,c__PathologicProcess) ).

fof(miloA916,axiom,
    p__d__subclass(c__Atrophy,c__Decreasing) ).

fof(miloA917,axiom,
    p__d__subclass(c__Bloating,c__Increasing) ).

fof(miloA918,axiom,
    p__d__subclass(c__Bloating,c__PathologicProcess) ).

fof(miloA920,axiom,
    p__d__subclass(c__ConjugatedSubstance,c__CompoundSubstance) ).

fof(miloA921,axiom,
    ! [CS] :
      ( p__d__instance(CS,c__ConjugatedSubstance)
    <=> ? [C1,C2,P] :
          ( p__d__instance(C1,c__CompoundSubstance)
          & p__d__instance(C2,c__CompoundSubstance)
          & C1 != C2
          & p__d__instance(P,c__ChemicalSynthesis)
          & p__resource(P,C1)
          & p__resource(P,C2)
          & p__result(P,CS) ) ) ).

fof(miloA922,axiom,
    p__d__instance(c__conjugate,c__BinaryPredicate) ).

fof(miloA923,axiom,
    p__d__instance(c__conjugate,c__IrreflexiveRelation) ).

fof(miloA924,axiom,
    p__d__instance(c__conjugate,c__TransitiveRelation) ).

fof(miloA927,axiom,
    ! [COMPOUND1,COMPOUND2] :
      ( ( p__d__instance(COMPOUND2,c__CompoundSubstance)
        & p__d__instance(COMPOUND1,c__CompoundSubstance)
        & p__conjugate(COMPOUND1,COMPOUND2) )
     => ? [NUMBER1,NUMBER2] :
          ( p__d__instance(NUMBER1,c__PositiveInteger)
          & p__d__instance(NUMBER2,c__PositiveInteger)
          & p__protonNumber(COMPOUND1,NUMBER1)
          & p__protonNumber(COMPOUND2,NUMBER2)
          & NUMBER1 = f__AdditionFn2(NUMBER2,c__1) ) ) ).

fof(miloA928,axiom,
    p__d__subclass(c__Biting,c__Grabbing) ).

fof(miloA929,axiom,
    ! [ANIMAL,BITE] :
      ( ( p__d__instance(ANIMAL,c__Agent)
        & p__d__instance(BITE,c__Biting)
        & p__agent(BITE,ANIMAL) )
     => ? [MOUTH] :
          ( p__d__instance(MOUTH,c__Mouth)
          & p__part(MOUTH,ANIMAL)
          & p__instrument(BITE,MOUTH) ) ) ).

fof(miloA930,axiom,
    p__d__subclass(c__Strangling,c__Grabbing) ).

fof(miloA931,axiom,
    ! [S] :
      ( p__d__instance(S,c__Strangling)
     => ? [T] :
          ( p__patient(S,T)
          & p__d__instance(T,c__Throat) ) ) ).

fof(miloA933,axiom,
    p__d__subclass(c__Spitting,c__Impelling) ).

fof(miloA934,axiom,
    ! [ANIMAL,SPIT] :
      ( ( p__d__instance(ANIMAL,c__Agent)
        & p__d__instance(SPIT,c__Spitting)
        & p__agent(SPIT,ANIMAL) )
     => ? [MOUTH] :
          ( p__d__instance(MOUTH,c__Mouth)
          & p__part(MOUTH,ANIMAL)
          & p__origin(SPIT,MOUTH) ) ) ).

fof(miloA935,axiom,
    p__d__subclass(c__Punching,c__Impelling) ).

fof(miloA936,axiom,
    ! [A,P] :
      ( ( p__d__instance(A,c__Agent)
        & p__d__instance(P,c__Punching)
        & p__agent(P,A) )
     => ? [H] :
          ( p__d__instance(H,c__Hand)
          & p__attribute(H,c__Fist)
          & p__part(H,A)
          & p__instrument(P,H) ) ) ).

fof(miloA937,axiom,
    p__d__subclass(c__Kicking,c__Impelling) ).

fof(miloA938,axiom,
    ! [ANIMAL,KICK] :
      ( ( p__d__instance(ANIMAL,c__Agent)
        & p__d__instance(KICK,c__Kicking)
        & p__agent(KICK,ANIMAL) )
     => ? [FOOT] :
          ( p__d__instance(FOOT,c__Foot)
          & p__part(FOOT,ANIMAL)
          & p__instrument(KICK,FOOT) ) ) ).

fof(miloA939,axiom,
    p__d__subclass(c__Mailing,c__Transfer) ).

fof(miloA940,axiom,
    p__d__subclass(c__Messaging,c__Transfer) ).

fof(miloA941,axiom,
    ! [MESSAGING] :
      ( p__d__instance(MESSAGING,c__Messaging)
     => ? [M] :
          ( p__d__instance(M,c__Message)
          & p__patient(MESSAGING,M) ) ) ).

fof(miloA942,axiom,
    p__d__instance(c__neighbor,c__BinaryPredicate) ).

fof(miloA943,axiom,
    p__d__instance(c__neighbor,c__SymmetricRelation) ).

fof(miloA944,axiom,
    p__d__instance(c__neighbor,c__IrreflexiveRelation) ).

fof(miloA947,axiom,
    ! [PERSON1,PERSON2] :
      ( ( p__d__instance(PERSON2,c__Human)
        & p__d__instance(PERSON1,c__Human)
        & p__neighbor(PERSON1,PERSON2) )
     => ? [HOME1,HOME2] :
          ( p__d__instance(HOME1,c__PermanentResidence)
          & p__d__instance(HOME2,c__PermanentResidence)
          & p__home(PERSON1,HOME1)
          & p__home(PERSON2,HOME2)
          & HOME1 != HOME2
          & p__orientation(HOME1,HOME2,c__Near) ) ) ).

fof(miloA948,axiom,
    p__d__instance(c__capacity,c__BinaryPredicate) ).

fof(miloA951,axiom,
    p__relatedInternalConcept(c__capacity,c__humanCapacity) ).

fof(miloA952,axiom,
    ! [OBJ1,OBJ2,MEAS] :
      ( ( p__d__instance(MEAS,c__ConstantQuantity)
        & p__d__instance(OBJ1,c__Object)
        & p__d__instance(OBJ2,c__SelfConnectedObject)
        & p__measure(OBJ1,MEAS)
        & p__contains(OBJ2,OBJ1) )
     => p__capacity(OBJ2,MEAS) ) ).

fof(miloA953,axiom,
    p__d__instance(c__humanCapacity,c__BinaryPredicate) ).

fof(miloA954,axiom,
    p__d__instance(c__humanCapacity,c__SingleValuedRelation) ).

fof(miloA957,axiom,
    p__d__instance(c__LastFn,c__UnaryFunction) ).

fof(miloA961,axiom,
    p__d__instance(c__FirstFn,c__UnaryFunction) ).

fof(miloA965,axiom,
    p__d__instance(c__StreetAddressFn,c__QuaternaryFunction) ).

fof(miloA971,axiom,
    ! [ROAD,CITY,COUNTRY,PLACE,AGENT] :
      ( ( p__d__instance(COUNTRY,c__Nation)
        & p__d__instance(CITY,c__City)
        & p__d__instance(ROAD,c__Roadway)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__d__instance(AGENT,c__Agent)
        & f__StreetAddressFn4(PLACE,ROAD,CITY,COUNTRY) = AGENT )
     => p__postContactSite(PLACE,AGENT) ) ).

fof(miloA972,axiom,
    ! [ROAD,CITY,COUNTRY,AGENT,PLACE] :
      ( ( p__d__instance(COUNTRY,c__Nation)
        & p__d__instance(CITY,c__City)
        & p__d__instance(ROAD,c__Roadway)
        & p__d__instance(PLACE,c__StationaryArtifact)
        & p__d__instance(AGENT,c__Agent)
        & f__StreetAddressFn4(PLACE,ROAD,CITY,COUNTRY) = AGENT )
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__Building)
          & p__part(PLACE,BUILDING) ) ) ).

fof(miloA973,axiom,
    p__d__subclass(c__ArtStudio,c__Workshop) ).

fof(miloA975,axiom,
    p__d__subclass(c__Mine,c__StationaryArtifact) ).

fof(miloA977,axiom,
    p__d__subclass(c__MobileResidence,c__Artifact) ).

fof(miloA978,axiom,
    p__d__disjoint(c__MobileResidence,c__Residence) ).

fof(miloA979,axiom,
    p__d__subclass(c__Prison,c__StationaryArtifact) ).

fof(miloA981,axiom,
    p__d__instance(c__detainee,c__CaseRole) ).

fof(miloA984,axiom,
    p__subrelation(c__detainee,c__patient) ).

fof(miloA985,axiom,
    p__d__instance(c__targetInAttack,c__BinaryPredicate) ).

fof(miloA986,axiom,
    p__d__instance(c__targetInAttack,c__CaseRole) ).

fof(miloA989,axiom,
    p__subrelation(c__targetInAttack,c__patient) ).

fof(miloA990,axiom,
    p__d__subclass(c__VotingPoll,c__StationaryArtifact) ).

fof(miloA991,axiom,
    ! [P] :
      ( p__d__instance(P,c__VotingPoll)
     => ? [V] :
          ( p__d__instance(V,c__Voting)
          & p__eventLocated(V,P) ) ) ).

fof(miloA992,axiom,
    p__d__subclass(c__Camp,c__MobileResidence) ).

fof(miloA993,axiom,
    ! [CAMP] :
      ( p__d__instance(CAMP,c__Camp)
     => ? [TENT] :
          ( p__d__instance(TENT,c__Tent)
          & p__part(TENT,CAMP) ) ) ).

fof(miloA994,axiom,
    p__d__subclass(c__Tent,c__MobileResidence) ).

fof(miloA995,axiom,
    ! [TENT] :
      ( p__d__instance(TENT,c__Tent)
     => ? [FABRIC] :
          ( p__d__instance(FABRIC,c__Fabric)
          & p__part(FABRIC,TENT) ) ) ).

fof(miloA996,axiom,
    p__d__subclass(c__Monument,c__StationaryArtifact) ).

fof(miloA998,axiom,
    p__d__subclass(c__Tomb,c__StationaryArtifact) ).

fof(miloA1000,axiom,
    p__d__subclass(c__Workshop,c__StationaryArtifact) ).

fof(miloA1002,axiom,
    p__d__subclass(c__ApartmentUnit,c__SingleFamilyResidence) ).

fof(miloA1003,axiom,
    ! [PERSON,UNIT] :
      ( ( p__d__instance(PERSON,c__Human)
        & p__d__instance(UNIT,c__ApartmentUnit)
        & p__home(PERSON,UNIT) )
     => ~ p__possesses(PERSON,UNIT) ) ).

fof(miloA1004,axiom,
    ! [UNIT] :
      ( p__d__instance(UNIT,c__ApartmentUnit)
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__ApartmentBuilding)
          & p__part(UNIT,BUILDING) ) ) ).

fof(miloA1005,axiom,
    p__d__instance(c__landlord,c__BinaryPredicate) ).

fof(miloA1008,axiom,
    ! [L,U] :
      ( ( p__d__instance(U,c__PermanentResidence)
        & p__d__instance(L,c__Agent)
        & p__landlord(L,U) )
     => ? [R,P] :
          ( p__d__instance(P,c__Agent)
          & p__possesses(L,U)
          & p__tenant(P,U)
          & p__agent(R,P)
          & p__d__instance(R,c__Renting)
          & p__patient(R,U) ) ) ).

fof(miloA1009,axiom,
    p__d__instance(c__tenant,c__BinaryPredicate) ).

fof(miloA1012,axiom,
    ! [P,U] :
      ( ( p__d__instance(U,c__PermanentResidence)
        & p__d__instance(P,c__Agent)
        & p__tenant(P,U) )
     => ? [L,R] :
          ( p__d__instance(L,c__Agent)
          & p__d__instance(R,c__Renting)
          & p__landlord(L,U)
          & p__agent(R,P)
          & p__possesses(L,U)
          & p__patient(R,U) ) ) ).

fof(miloA1013,axiom,
    p__d__subclass(c__CondominiumUnit,c__SingleFamilyResidence) ).

fof(miloA1014,axiom,
    ! [PERSON,UNIT] :
      ( ( p__d__instance(PERSON,c__Human)
        & p__d__instance(UNIT,c__SingleFamilyResidence)
        & p__home(PERSON,UNIT)
        & p__possesses(PERSON,UNIT)
        & ~ p__d__instance(UNIT,c__Building) )
     => p__d__instance(UNIT,c__CondominiumUnit) ) ).

fof(miloA1015,axiom,
    ! [UNIT] :
      ( p__d__instance(UNIT,c__CondominiumUnit)
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__CondominiumBuilding)
          & p__part(UNIT,BUILDING) ) ) ).

fof(miloA1016,axiom,
    p__d__subclass(c__ApartmentBuilding,c__ResidentialBuilding) ).

fof(miloA1017,axiom,
    p__d__disjoint(c__ApartmentBuilding,c__SingleFamilyResidence) ).

fof(miloA1018,axiom,
    ! [BUILDING] :
      ( p__d__instance(BUILDING,c__ApartmentBuilding)
     => ? [UNIT1,UNIT2] :
          ( p__d__instance(UNIT1,c__ApartmentUnit)
          & p__d__instance(UNIT2,c__ApartmentUnit)
          & p__part(UNIT1,BUILDING)
          & p__part(UNIT2,BUILDING)
          & UNIT1 != UNIT2 ) ) ).

fof(miloA1019,axiom,
    p__d__subclass(c__CondominiumBuilding,c__ResidentialBuilding) ).

fof(miloA1020,axiom,
    p__d__disjoint(c__CondominiumBuilding,c__SingleFamilyResidence) ).

fof(miloA1021,axiom,
    ! [BUILDING] :
      ( p__d__instance(BUILDING,c__CondominiumBuilding)
     => ? [UNIT1,UNIT2] :
          ( p__d__instance(UNIT1,c__CondominiumUnit)
          & p__d__instance(UNIT2,c__CondominiumUnit)
          & p__part(UNIT1,BUILDING)
          & p__part(UNIT2,BUILDING)
          & UNIT1 != UNIT2 ) ) ).

fof(miloA1022,axiom,
    p__d__subclass(c__Dormitory,c__ResidentialBuilding) ).

fof(miloA1023,axiom,
    p__d__subclass(c__Dormitory,c__TemporaryResidence) ).

fof(miloA1024,axiom,
    p__d__disjoint(c__Dormitory,c__SingleFamilyResidence) ).

fof(miloA1025,axiom,
    ! [D] :
      ( p__d__instance(D,c__Dormitory)
     => ? [S] :
          ( p__d__instance(S,c__School)
          & p__possesses(S,D) ) ) ).

fof(miloA1026,axiom,
    p__d__subclass(c__AnimalResidence,c__Artifact) ).

fof(miloA1028,axiom,
    p__d__subclass(c__SportsFacility,c__StationaryArtifact) ).

fof(miloA1030,axiom,
    p__d__subclass(c__SportsLeague,c__Organization) ).

fof(miloA1031,axiom,
    p__d__subclass(c__PlaceOfCommerce,c__StationaryArtifact) ).

fof(miloA1032,axiom,
    p__d__partition3(c__PlaceOfCommerce,c__CommercialBuilding,c__CommercialUnit) ).

fof(miloA1033,axiom,
    ! [OFFICE] :
      ( p__d__instance(OFFICE,c__PlaceOfCommerce)
     => ( p__d__instance(OFFICE,c__CommercialBuilding)
        | ? [BUILDING] :
            ( p__d__instance(BUILDING,c__CommercialBuilding)
            & p__part(OFFICE,BUILDING) ) ) ) ).

fof(miloA1034,axiom,
    p__d__subclass(c__CommercialBuilding,c__Building) ).

fof(miloA1035,axiom,
    p__d__subclass(c__CommercialBuilding,c__PlaceOfCommerce) ).

fof(miloA1036,axiom,
    p__d__subclass(c__Warehouse,c__CommercialBuilding) ).

fof(miloA1038,axiom,
    p__d__subclass(c__CommercialUnit,c__PlaceOfCommerce) ).

fof(miloA1039,axiom,
    ! [UNIT,ORG] :
      ( ( p__d__instance(UNIT,c__CommercialUnit)
        & p__d__instance(ORG,c__Organization)
        & p__located(ORG,UNIT) )
     => ! [OTHER] :
          ( ~ p__d__instance(OTHER,c__Physical)
          | ~ p__d__instance(OTHER,c__Organization)
          | ~ p__located(OTHER,UNIT)
          | OTHER = ORG ) ) ).

fof(miloA1040,axiom,
    p__d__subclass(c__Store,c__Building) ).

fof(miloA1042,axiom,
    p__d__subclass(c__FarmBuilding,c__Building) ).

fof(miloA1043,axiom,
    p__d__disjoint(c__FarmBuilding,c__ResidentialBuilding) ).

fof(miloA1044,axiom,
    ! [B] :
      ( p__d__instance(B,c__FarmBuilding)
     => ? [F] :
          ( p__d__instance(F,c__Farm)
          & p__located(B,F) ) ) ).

fof(miloA1045,axiom,
    p__d__subclass(c__Agency,c__Business) ).

fof(miloA1046,axiom,
    ! [A,C] :
      ( ( p__d__instance(A,c__CognitiveAgent)
        & p__d__instance(C,c__CognitiveAgent)
        & p__d__instance(A,c__Agency)
        & p__customer(C,A) )
     => p__d__instance(C,c__CommercialAgent) ) ).

fof(miloA1047,axiom,
    p__d__subclass(c__EntertainmentCompany,c__Business) ).

fof(miloA1048,axiom,
    ! [C] :
      ( p__d__instance(C,c__EntertainmentCompany)
     => ? [P] :
          ( p__d__instance(P,c__CommercialService)
          & p__agent(P,C)
          & p__d__instance(P,c__Performance) ) ) ).

fof(miloA1049,axiom,
    p__d__subclass(c__FinancialCompany,c__Business) ).

fof(miloA1050,axiom,
    p__d__subclass(c__SavingsAndLoan,c__FinancialCompany) ).

fof(miloA1051,axiom,
    p__d__instance(c__insured,c__BinaryPredicate) ).

fof(miloA1052,axiom,
    p__d__instance(c__insured,c__AsymmetricRelation) ).

fof(miloA1055,axiom,
    ! [ORG,PROP] :
      ( ( p__d__instance(ORG,c__Organization)
        & p__d__instance(PROP,c__Proposition)
        & p__insured(PROP,ORG) )
     => p__property(PROP,c__Contract) ) ).

fof(miloA1056,axiom,
    p__d__subclass(c__InsuranceCompany,c__Business) ).

fof(miloA1057,axiom,
    ! [I] :
      ( p__d__instance(I,c__InsuranceCompany)
     => ? [C] :
          ( p__d__instance(C,c__Proposition)
          & p__insured(C,I) ) ) ).

fof(miloA1058,axiom,
    p__d__subclass(c__TransportationCompany,c__Business) ).

fof(miloA1059,axiom,
    ! [C] :
      ( p__d__instance(C,c__TransportationCompany)
     => ? [S] :
          ( p__d__instance(S,c__CommercialService)
          & p__agent(S,C)
          & p__d__instance(S,c__Transportation) ) ) ).

fof(miloA1060,axiom,
    p__d__subclass(c__FinancialService,c__CommercialService) ).

fof(miloA1061,axiom,
    ! [S] :
      ( p__d__instance(S,c__FinancialService)
     => ? [O] :
          ( p__d__instance(O,c__FinancialCompany)
          & p__agent(S,O) ) ) ).

fof(miloA1062,axiom,
    p__d__instance(c__loss,c__AsymmetricRelation) ).

fof(miloA1065,axiom,
    p__d__subclass(c__Financing,c__Funding) ).

fof(miloA1066,axiom,
    p__d__subclass(c__Financing,c__FinancialService) ).

fof(miloA1067,axiom,
    p__d__subclass(c__Partnership,c__Business) ).

fof(miloA1068,axiom,
    ! [C] :
      ( p__d__instance(C,c__Partnership)
     => ? [H1,H2] :
          ( p__d__instance(H1,c__Human)
          & p__d__instance(H2,c__Human)
          & H1 != H2
          & p__possesses(H1,C)
          & p__possesses(H2,C) ) ) ).

fof(miloA1069,axiom,
    p__d__subclass(c__Scholarship,c__Funding) ).

fof(miloA1071,axiom,
    p__d__subclass(c__Welfare,c__Funding) ).

fof(miloA1072,axiom,
    ! [W] :
      ( p__d__instance(W,c__Welfare)
     => ? [O] :
          ( p__d__instance(O,c__ServiceOrganization)
          & p__agent(W,O) ) ) ).

fof(miloA1073,axiom,
    p__d__subclass(c__Publisher,c__Manufacturer) ).

fof(miloA1074,axiom,
    ! [C] :
      ( p__d__instance(C,c__Publisher)
     => ? [S] :
          ( p__d__instance(S,c__CommercialService)
          & p__agent(S,C)
          & p__d__instance(S,c__Publication) ) ) ).

fof(miloA1075,axiom,
    p__d__subclass(c__FamilyBusiness,c__Partnership) ).

fof(miloA1076,axiom,
    ! [C,P1,P2] :
      ( ( p__d__instance(P1,c__Organism)
        & p__d__instance(P2,c__Organism)
        & p__d__instance(C,c__FamilyBusiness)
        & p__possesses(P1,C)
        & p__possesses(P2,C) )
     => p__familyRelation(P1,P2) ) ).

fof(miloA1077,axiom,
    p__d__subclass(c__Restaurant,c__Business) ).

fof(miloA1079,axiom,
    ! [PLACE] :
      ( p__d__instance(PLACE,c__RestaurantBuilding)
     => p__capability(c__Cooking,c__eventLocated,PLACE) ) ).

fof(miloA1080,axiom,
    ! [R] :
      ( p__d__instance(R,c__Restaurant)
     => ? [D] :
          ( p__possesses(R,D)
          & p__d__instance(D,c__DiningArea) ) ) ).

fof(miloA1081,axiom,
    p__d__subclass(c__Proprietorship,c__Business) ).

fof(miloA1082,axiom,
    ! [C] :
      ( p__d__instance(C,c__Proprietorship)
     => ? [H] :
          ( p__d__instance(H,c__Human)
          & p__possesses(H,C)
          & ! [H2] :
              ( ~ p__d__instance(H2,c__Agent)
              | H = H2
              | ~ p__possesses(H2,C) ) ) ) ).

fof(miloA1083,axiom,
    p__d__subclass(c__Auditorium,c__Building) ).

fof(miloA1085,axiom,
    ! [AUDITORIUM] :
      ( p__d__instance(AUDITORIUM,c__Auditorium)
     => ? [STAGE] :
          ( p__d__instance(STAGE,c__PerformanceStage)
          & p__part(STAGE,AUDITORIUM) ) ) ).

fof(miloA1086,axiom,
    p__d__subclass(c__AuditoriumSeat,c__Seat) ).

fof(miloA1087,axiom,
    ! [SEAT] :
      ( p__d__instance(SEAT,c__AuditoriumSeat)
     => ? [AUDITORIUM] :
          ( p__d__instance(AUDITORIUM,c__Auditorium)
          & p__part(SEAT,AUDITORIUM) ) ) ).

fof(miloA1088,axiom,
    ! [AUDITORIUM,SEAT,STAGE,SEE,PERSON] :
      ( ( p__d__instance(SEAT,c__AuditoriumSeat)
        & p__part(SEAT,AUDITORIUM)
        & p__part(STAGE,AUDITORIUM)
        & p__d__instance(AUDITORIUM,c__Auditorium)
        & p__d__instance(STAGE,c__PerformanceStage)
        & p__located(PERSON,SEAT)
        & p__d__instance(PERSON,c__Human)
        & p__d__subclass(SEE,c__Seeing)
        & ! [INST] :
            ( ( p__d__instance(INST,c__Process)
              & p__d__instance(INST,SEE) )
           => p__patient(INST,STAGE) ) )
     => p__capability(SEE,c__agent,PERSON) ) ).

fof(miloA1089,axiom,
    p__subrelation(c__enjoys,c__inScopeOfInterest) ).

fof(miloA1093,axiom,
    p__d__instance(c__expects,c__BinaryPredicate) ).

fof(miloA1097,axiom,
    p__subrelation(c__fears,c__expects) ).

fof(miloA1098,axiom,
    ! [AGENT,FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__fears(AGENT,FORMULA) )
     => ~ p__desires(AGENT,FORMULA) ) ).

fof(miloA1099,axiom,
    p__subrelation(c__hopes,c__expects) ).

fof(miloA1100,axiom,
    ! [AGENT,FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__hopes(AGENT,FORMULA) )
     => p__desires(AGENT,FORMULA) ) ).

fof(miloA1101,axiom,
    p__d__instance(c__doubts,c__PropositionalAttitude) ).

fof(miloA1102,axiom,
    p__d__instance(c__doubts,c__BinaryPredicate) ).

fof(miloA1105,axiom,
    ! [AGENT,FORMULA] :
      ( ( p__d__instance(FORMULA,c__Formula)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__doubts(AGENT,FORMULA) )
     => ~ p__believes(AGENT,FORMULA) ) ).

fof(miloA1106,axiom,
    p__d__instance(c__dislikes,c__ObjectAttitude) ).

fof(miloA1107,axiom,
    p__subrelation(c__dislikes,c__inScopeOfInterest) ).

fof(miloA1108,axiom,
    p__disjointRelation(c__dislikes,c__wants) ).

fof(miloA1109,axiom,
    p__relatedInternalConcept(c__dislikes,c__disapproves) ).

fof(miloA1113,axiom,
    p__d__instance(c__disapproves,c__PropositionalAttitude) ).

fof(miloA1114,axiom,
    p__d__instance(c__disapproves,c__BinaryPredicate) ).

fof(miloA1115,axiom,
    p__subrelation(c__disapproves,c__inScopeOfInterest) ).

fof(miloA1116,axiom,
    p__disjointRelation(c__disapproves,c__desires) ).

fof(miloA1119,axiom,
    p__subrelation(c__lacks,c__needs) ).

fof(miloA1121,axiom,
    p__d__instance(c__DescendantsFn,c__UnaryFunction) ).

fof(miloA1124,axiom,
    ! [DESCENDANTS,PERSON,MEMBER] :
      ( ( p__d__instance(DESCENDANTS,c__FamilyGroup)
        & p__d__instance(PERSON,c__Human)
        & f__DescendantsFn1(PERSON) = DESCENDANTS
        & p__d__instance(MEMBER,c__Organism) )
     => ( p__member(MEMBER,DESCENDANTS)
      <=> p__ancestor(MEMBER,PERSON) ) ) ).

fof(miloA1125,axiom,
    p__d__subclass(c__GroupOfAnimals,c__Group) ).

fof(miloA1126,axiom,
    ! [GROUP,MEMBER] :
      ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
        & p__d__instance(GROUP,c__GroupOfAnimals)
        & p__member(MEMBER,GROUP) )
     => ( p__d__instance(MEMBER,c__Animal)
        & ~ p__d__instance(MEMBER,c__Human) ) ) ).

fof(miloA1127,axiom,
    p__d__subclass(c__Brood,c__GroupOfAnimals) ).

fof(miloA1128,axiom,
    ! [BROOD,MEMBER1,MEMBER2] :
      ( ( p__d__instance(MEMBER1,c__Organism)
        & p__d__instance(MEMBER2,c__Organism)
        & p__d__instance(BROOD,c__Brood)
        & p__member(MEMBER1,BROOD)
        & p__member(MEMBER2,BROOD)
        & MEMBER1 != MEMBER2 )
     => p__sibling(MEMBER1,MEMBER2) ) ).

fof(miloA1129,axiom,
    ! [BROOD] :
      ( p__d__instance(BROOD,c__Brood)
     => ? [TIME] :
          ( p__d__instance(TIME,c__TimeInterval)
          & ! [MEMBER] :
              ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
                & p__d__instance(MEMBER,c__Agent)
                & p__member(MEMBER,BROOD) )
             => ? [BIRTH] :
                  ( p__d__instance(BIRTH,c__Birth)
                  & p__experiencer(BIRTH,MEMBER)
                  & TIME = f__WhenFn1(BIRTH) ) ) ) ) ).

fof(miloA1130,axiom,
    p__d__subclass(c__AnimalTeam,c__GroupOfAnimals) ).

fof(miloA1131,axiom,
    ! [AT] :
      ( p__d__instance(AT,c__AnimalTeam)
     => ? [P] :
          ( p__d__instance(P,c__Pulling)
          & p__agent(P,AT) ) ) ).

fof(miloA1132,axiom,
    p__d__subclass(c__SportsTeam,c__GroupOfPeople) ).

fof(miloA1133,axiom,
    ! [TEAM] :
      ( p__d__instance(TEAM,c__SportsTeam)
     => ? [SPORT] :
          ( p__d__subclass(SPORT,c__Sport)
          & p__capability(SPORT,c__agent,TEAM) ) ) ).

fof(miloA1134,axiom,
    p__d__subclass(c__TeamSport,c__Sport) ).

fof(miloA1135,axiom,
    ! [S] :
      ( p__d__instance(S,c__TeamSport)
     => ? [T1,T2] :
          ( p__contestParticipant(S,T1)
          & p__contestParticipant(S,T2)
          & p__d__instance(T1,c__SportsTeam)
          & p__d__instance(T2,c__SportsTeam)
          & T1 != T2 ) ) ).

fof(miloA1136,axiom,
    p__d__subclass(c__Racing,c__Sport) ).

fof(miloA1137,axiom,
    p__subrelation(c__groupMember,c__member) ).

fof(miloA1142,axiom,
    p__subrelation(c__headquartersOfOrganization,c__located) ).

fof(miloA1143,axiom,
    p__d__subclass(c__CommunicationOrganization,c__Organization) ).

fof(miloA1144,axiom,
    ! [CO] :
      ( p__d__instance(CO,c__CommunicationOrganization)
     => ? [CS,C] :
          ( p__d__instance(C,c__Communication)
          & p__d__instance(CS,c__CommunicationSystem)
          & p__instrument(C,CS)
          & p__agent(C,CO) ) ) ).

fof(miloA1145,axiom,
    p__d__subclass(c__MediaOrganization,c__Organization) ).

fof(miloA1146,axiom,
    p__d__instance(c__profit,c__AsymmetricRelation) ).

fof(miloA1149,axiom,
    p__d__subclass(c__NonprofitOrganization,c__Organization) ).

fof(miloA1150,axiom,
    p__d__disjoint(c__NonprofitOrganization,c__CommercialAgent) ).

fof(miloA1152,axiom,
    p__d__subclass(c__CommunicationSystem,c__Collection) ).

fof(miloA1153,axiom,
    p__d__subclass(c__CareOrganization,c__Organization) ).

fof(miloA1154,axiom,
    p__d__partition3(c__CareOrganization,c__HospitalOrganization,c__MedicalClinic) ).

fof(miloA1155,axiom,
    p__d__instance(c__medicalPatient,c__BinaryPredicate) ).

fof(miloA1159,axiom,
    p__d__subclass(c__HospitalOrganization,c__CareOrganization) ).

fof(miloA1160,axiom,
    p__d__subclass(c__HospitalBuilding,c__TemporaryResidence) ).

fof(miloA1161,axiom,
    p__d__subclass(c__MedicalClinic,c__CareOrganization) ).

fof(miloA1163,axiom,
    p__d__subclass(c__MedicalClinicBuilding,c__Building) ).

fof(miloA1164,axiom,
    p__d__subclass(c__Cafeteria,c__Restaurant) ).

fof(miloA1166,axiom,
    p__d__subclass(c__Tavern,c__Restaurant) ).

fof(miloA1167,axiom,
    ! [COMPANY] :
      ( p__d__instance(COMPANY,c__Tavern)
     => ? [SERVICE,BEVERAGE] :
          ( p__d__instance(SERVICE,c__CommercialService)
          & p__agent(SERVICE,COMPANY)
          & p__d__instance(SERVICE,c__Selling)
          & p__patient(SERVICE,BEVERAGE)
          & p__d__instance(BEVERAGE,c__AlcoholicBeverage) ) ) ).

fof(miloA1168,axiom,
    p__d__subclass(c__Shipping,c__Transportation) ).

fof(miloA1169,axiom,
    p__d__subclass(c__CommercialShipping,c__Shipping) ).

fof(miloA1170,axiom,
    p__d__subclass(c__CommercialShipping,c__CommercialService) ).

fof(miloA1171,axiom,
    p__d__subclass(c__Smuggling,c__Transportation) ).

fof(miloA1172,axiom,
    p__d__subclass(c__Smuggling,c__CriminalAction) ).

fof(miloA1173,axiom,
    p__d__instance(c__customer,c__IrreflexiveRelation) ).

fof(miloA1174,axiom,
    p__d__instance(c__customer,c__BinaryPredicate) ).

fof(miloA1175,axiom,
    p__d__instance(c__customer,c__AsymmetricRelation) ).

fof(miloA1178,axiom,
    ! [AGENT2,AGENT1] :
      ( ( p__d__instance(AGENT2,c__CognitiveAgent)
        & p__d__instance(AGENT1,c__CognitiveAgent) )
     => ( p__customer(AGENT1,AGENT2)
      <=> ? [SERVICE] :
            ( p__d__instance(SERVICE,c__FinancialTransaction)
            & p__origin(SERVICE,AGENT2)
            & p__destination(SERVICE,AGENT1) ) ) ) ).

fof(miloA1179,axiom,
    p__d__instance(c__price,c__TernaryPredicate) ).

fof(miloA1183,axiom,
    ! [Agent,Obj,Money] :
      ( ( p__d__instance(Agent,c__Agent)
        & p__d__instance(Money,c__CurrencyMeasure)
        & p__d__instance(Obj,c__Physical)
        & p__price(Obj,Money,Agent) )
     => ? [Buying] :
          ( p__d__instance(Buying,c__Buying)
          & p__agent(Buying,Agent)
          & p__patient(Buying,Obj)
          & p__transactionAmount(Buying,Money) ) ) ).

fof(miloA1184,axiom,
    p__d__subclass(c__WholesaleStore,c__MercantileOrganization) ).

fof(miloA1185,axiom,
    ! [STORE,CUSTOMER] :
      ( ( p__d__instance(STORE,c__CognitiveAgent)
        & p__d__instance(CUSTOMER,c__CognitiveAgent)
        & p__d__instance(STORE,c__WholesaleStore)
        & p__customer(CUSTOMER,STORE) )
     => p__d__instance(CUSTOMER,c__CommercialAgent) ) ).

fof(miloA1186,axiom,
    p__d__subclass(c__RetailStore,c__MercantileOrganization) ).

fof(miloA1187,axiom,
    p__d__disjoint(c__RetailStore,c__WholesaleStore) ).

fof(miloA1188,axiom,
    ! [X] :
      ( p__d__instance(X,c__RetailStore)
     => p__capability(c__Selling,c__agent,X) ) ).

fof(miloA1189,axiom,
    p__d__subclass(c__ShoppingMall,c__MercantileOrganization) ).

fof(miloA1190,axiom,
    p__d__subclass(c__DrugStore,c__RetailStore) ).

fof(miloA1191,axiom,
    ! [D] :
      ( p__d__instance(D,c__DrugStore)
     => ? [S,M] :
          ( p__d__instance(S,c__Selling)
          & p__agent(S,D)
          & p__patient(S,M)
          & p__d__instance(M,c__Medicine) ) ) ).

fof(miloA1192,axiom,
    p__d__subclass(c__GroceryStore,c__RetailStore) ).

fof(miloA1194,axiom,
    p__d__subclass(c__OfferingForSale,c__Offering) ).

fof(miloA1196,axiom,
    p__d__subclass(c__OfferingToPurchase,c__Offering) ).

fof(miloA1197,axiom,
    p__d__subclass(c__BargainSale,c__Offering) ).

fof(miloA1199,axiom,
    p__d__subclass(c__ChristianBible,c__Book) ).

fof(miloA1200,axiom,
    p__subsumesContentClass(c__ChristianBible,c__NewTestament) ).

fof(miloA1201,axiom,
    p__subsumesContentClass(c__ChristianBible,c__OldTestament) ).

fof(miloA1202,axiom,
    p__d__subclass(c__ChristianGospel,c__Text) ).

fof(miloA1203,axiom,
    p__d__subclass(c__OldTestament,c__Book) ).

fof(miloA1204,axiom,
    p__d__subclass(c__NewTestament,c__Book) ).

fof(miloA1205,axiom,
    p__subsumesContentClass(c__NewTestament,c__ChristianGospel) ).

fof(miloA1206,axiom,
    p__d__instance(c__BeforeCommonEra,c__TimeInterval) ).

fof(miloA1207,axiom,
    f__BeginFn1(c__BeforeCommonEra) = c__NegativeInfinity ).

fof(miloA1208,axiom,
    ~ p__overlapsTemporally(c__CommonEra,c__BeforeCommonEra) ).

fof(miloA1209,axiom,
    p__d__instance(c__CommonEra,c__TimeInterval) ).

fof(miloA1210,axiom,
    f__EndFn1(c__CommonEra) = c__PositiveInfinity ).

fof(miloA1211,axiom,
    p__d__subclass(c__MissionOrganization,c__ReligiousOrganization) ).

fof(miloA1212,axiom,
    p__d__subclass(c__ReligiousBuilding,c__Building) ).

fof(miloA1213,axiom,
    p__d__subclass(c__ReligiousBuilding,c__PlaceOfWorship) ).

fof(miloA1214,axiom,
    p__d__subclass(c__Steeple,c__StationaryArtifact) ).

fof(miloA1215,axiom,
    ! [STEEPLE] :
      ( p__d__instance(STEEPLE,c__Steeple)
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__Building)
          & p__part(STEEPLE,BUILDING) ) ) ).

fof(miloA1216,axiom,
    p__d__subclass(c__Ceremony,c__IntentionalProcess) ).

fof(miloA1217,axiom,
    p__d__subclass(c__Ceremony,c__SocialInteraction) ).

fof(miloA1218,axiom,
    p__d__subclass(c__Wedding,c__Ceremony) ).

fof(miloA1219,axiom,
    p__d__subclass(c__Wedding,c__Declaring) ).

fof(miloA1222,axiom,
    p__d__subclass(c__ReligiousService,c__ReligiousProcess) ).

fof(miloA1223,axiom,
    p__d__subclass(c__ReligiousService,c__Demonstrating) ).

fof(miloA1224,axiom,
    p__d__subclass(c__Baptizing,c__Ceremony) ).

fof(miloA1225,axiom,
    p__d__subclass(c__Baptizing,c__ReligiousProcess) ).

fof(miloA1226,axiom,
    p__d__subclass(c__Baptizing,c__JoiningAnOrganization) ).

fof(miloA1227,axiom,
    ! [B,H] :
      ( ( p__d__instance(B,c__Baptizing)
        & p__patient(B,H) )
     => p__d__instance(H,c__Human) ) ).

fof(miloA1228,axiom,
    p__d__subclass(c__Praying,c__ReligiousProcess) ).

fof(miloA1229,axiom,
    p__d__subclass(c__Praying,c__Requesting) ).

fof(miloA1230,axiom,
    p__d__subclass(c__ReferenceText,c__FactualText) ).

fof(miloA1231,axiom,
    p__d__subclass(c__IndependentState,c__GeopoliticalArea) ).

fof(miloA1232,axiom,
    p__d__subclass(c__IndependentState,c__Nation) ).

fof(miloA1233,axiom,
    p__d__subclass(c__DependencyOrSpecialSovereigntyArea,c__GeopoliticalArea) ).

fof(miloA1234,axiom,
    p__d__disjoint(c__IndependentState,c__DependencyOrSpecialSovereigntyArea) ).

fof(miloA1235,axiom,
    p__d__subclass(c__OverseasArea,c__DependencyOrSpecialSovereigntyArea) ).

fof(miloA1236,axiom,
    p__d__instance(c__ResidentFn,c__UnaryFunction) ).

fof(miloA1239,axiom,
    ! [PERSON,AREA] :
      ( ( p__d__instance(AREA,c__GeopoliticalArea)
        & p__d__instance(AREA,c__PermanentResidence)
        & p__d__instance(PERSON,c__Human)
        & p__member(PERSON,f__ResidentFn1(AREA)) )
     => p__home(PERSON,AREA) ) ).

fof(miloA1240,axiom,
    p__subrelation(c__CitizenryFn,c__ResidentFn) ).

fof(miloA1243,axiom,
    p__d__instance(c__PerCapitaFn,c__BinaryFunction) ).

fof(miloA1247,axiom,
    ! [AREA,QUANTITY2,QUANTITY1] :
      ( ( p__d__instance(AREA,c__GeopoliticalArea)
        & p__d__instance(QUANTITY1,c__Quantity)
        & p__d__instance(QUANTITY2,c__Quantity)
        & f__PerCapitaFn2(QUANTITY1,AREA) = QUANTITY2 )
     => ? [POPULATION] :
          ( p__d__instance(POPULATION,c__Number)
          & POPULATION = f__CardinalityFn1(f__ResidentFn1(AREA))
          & QUANTITY2 = f__DivisionFn2(QUANTITY1,POPULATION) ) ) ).

fof(miloA1248,axiom,
    p__d__subclass(c__CityDistrict,c__GeopoliticalArea) ).

fof(miloA1249,axiom,
    ! [DISTRICT] :
      ( p__d__instance(DISTRICT,c__GeopoliticalArea)
     => ( p__d__instance(DISTRICT,c__CityDistrict)
      <=> ? [CITY] :
            ( p__d__instance(CITY,c__City)
            & p__geopoliticalSubdivision(DISTRICT,CITY) ) ) ) ).

fof(miloA1250,axiom,
    p__d__subclass(c__Downtown,c__CityDistrict) ).

fof(miloA1251,axiom,
    p__d__subclass(c__Cemetery,c__LandArea) ).

fof(miloA1252,axiom,
    ! [C] :
      ( p__d__instance(C,c__Cemetery)
     => ? [T] :
          ( p__d__instance(T,c__Tomb)
          & p__located(T,C) ) ) ).

fof(miloA1253,axiom,
    p__d__subclass(c__Park,c__LandArea) ).

fof(miloA1254,axiom,
    ! [PARK] :
      ( p__d__instance(PARK,c__Park)
     => ? [GOV] :
          ( p__d__instance(GOV,c__Government)
          & p__possesses(GOV,PARK) ) ) ).

fof(miloA1256,axiom,
    p__d__subclass(c__PublicPark,c__Park) ).

fof(miloA1257,axiom,
    ! [P] :
      ( p__d__instance(P,c__PublicPark)
     => ? [G] :
          ( p__d__instance(G,c__Government)
          & p__possesses(G,P) ) ) ).

fof(miloA1258,axiom,
    p__d__subclass(c__CultivatedLandArea,c__LandArea) ).

fof(miloA1259,axiom,
    ! [A] :
      ( p__d__instance(A,c__CultivatedLandArea)
     => ? [C] :
          ( p__d__instance(C,c__Agriculture)
          & p__eventLocated(C,A) ) ) ).

fof(miloA1260,axiom,
    p__d__subclass(c__Campground,c__LandArea) ).

fof(miloA1262,axiom,
    p__d__subclass(c__CityBlock,c__LandArea) ).

fof(miloA1263,axiom,
    ! [B] :
      ( p__d__instance(B,c__CityBlock)
     => ? [C] :
          ( p__d__instance(C,c__City)
          & p__part(B,C) ) ) ).

fof(miloA1264,axiom,
    p__d__subclass(c__AerobicExerciseDevice,c__RecreationOrExerciseDevice) ).

fof(miloA1265,axiom,
    p__d__subclass(c__AnaerobicExerciseDevice,c__RecreationOrExerciseDevice) ).

fof(miloA1266,axiom,
    p__d__disjoint(c__AnaerobicExerciseDevice,c__AerobicExerciseDevice) ).

fof(miloA1267,axiom,
    p__d__subclass(c__SkilledOccupation,c__OccupationalRole) ).

fof(miloA1268,axiom,
    ! [OCCUPATION,PERSON] :
      ( ( p__d__instance(PERSON,c__Object)
        & p__d__instance(OCCUPATION,c__SkilledOccupation)
        & p__attribute(PERSON,OCCUPATION) )
     => ? [TRAINING] :
          ( p__d__instance(TRAINING,c__EducationalProcess)
          & p__destination(TRAINING,PERSON) ) ) ).

fof(miloA1269,axiom,
    p__d__subclass(c__ManualLabor,c__Position) ).

fof(miloA1270,axiom,
    p__d__subclass(c__ManualLabor,c__OccupationalRole) ).

fof(miloA1271,axiom,
    p__d__subclass(c__UnskilledOccupation,c__ManualLabor) ).

fof(miloA1272,axiom,
    p__d__disjoint(c__UnskilledOccupation,c__SkilledOccupation) ).

fof(miloA1273,axiom,
    p__d__subclass(c__OccupationalTrade,c__SkilledOccupation) ).

fof(miloA1274,axiom,
    p__d__subclass(c__OccupationalTrade,c__ManualLabor) ).

fof(miloA1275,axiom,
    p__d__subclass(c__Profession,c__SkilledOccupation) ).

fof(miloA1276,axiom,
    p__d__disjoint(c__Profession,c__OccupationalTrade) ).

fof(miloA1278,axiom,
    p__d__instance(c__GovernmentSecretary,c__GovernmentPosition) ).

fof(miloA1279,axiom,
    p__d__instance(c__SecretaryOfTheInterior,c__GovernmentPosition) ).

fof(miloA1280,axiom,
    p__subAttribute(c__SecretaryOfTheInterior,c__GovernmentSecretary) ).

fof(miloA1281,axiom,
    p__d__instance(c__SecretaryOfTheTreasury,c__GovernmentPosition) ).

fof(miloA1282,axiom,
    p__subAttribute(c__SecretaryOfTheTreasury,c__GovernmentSecretary) ).

fof(miloA1283,axiom,
    p__d__subclass(c__StateGovernment,c__Government) ).

fof(miloA1285,axiom,
    p__d__subclass(c__CityGovernment,c__Government) ).

fof(miloA1287,axiom,
    p__d__subclass(c__MilitaryService,c__MilitaryOrganization) ).

fof(miloA1288,axiom,
    p__d__subclass(c__CoastGuard,c__GovernmentOrganization) ).

fof(miloA1289,axiom,
    p__d__subclass(c__Army,c__MilitaryService) ).

fof(miloA1290,axiom,
    p__d__subclass(c__AirForce,c__MilitaryService) ).

fof(miloA1291,axiom,
    p__d__subclass(c__MilitaryUnit,c__MilitaryOrganization) ).

fof(miloA1292,axiom,
    ! [B] :
      ( p__d__instance(B,c__Battle)
     => ? [U1,U2] :
          ( p__d__instance(U1,c__MilitaryUnit)
          & p__d__instance(U2,c__MilitaryUnit)
          & U1 != U2
          & p__agent(B,U1)
          & p__agent(B,U2) ) ) ).

fof(miloA1293,axiom,
    p__d__subclass(c__MilitaryReserveForce,c__MilitaryOrganization) ).

fof(miloA1294,axiom,
    p__d__subclass(c__MilitarySquad,c__MilitaryUnit) ).

fof(miloA1295,axiom,
    p__d__subclass(c__MilitaryCorps,c__MilitaryUnit) ).

fof(miloA1296,axiom,
    p__d__subclass(c__CavalryUnit,c__MilitaryUnit) ).

fof(miloA1297,axiom,
    p__d__subclass(c__MilitarySurplus,c__MilitaryArtifact) ).

fof(miloA1299,axiom,
    p__d__instance(c__hostileForces,c__BinaryPredicate) ).

fof(miloA1300,axiom,
    p__d__instance(c__hostileForces,c__IrreflexiveRelation) ).

fof(miloA1303,axiom,
    ! [U1,U2] :
      ( ( p__d__instance(U2,c__MilitaryUnit)
        & p__d__instance(U1,c__MilitaryUnit)
        & p__hostileForces(U1,U2) )
     => ? [W,A1,A2] :
          ( p__d__instance(A1,c__GeopoliticalArea)
          & p__d__instance(A2,c__GeopoliticalArea)
          & p__d__instance(W,c__War)
          & p__contestParticipant(W,A1)
          & p__contestParticipant(W,A2)
          & p__subOrganization(U1,f__GovernmentFn1(A1))
          & p__subOrganization(U2,f__GovernmentFn1(A2)) ) ) ).

fof(miloA1304,axiom,
    p__d__subclass(c__Commission,c__Organization) ).

fof(miloA1306,axiom,
    p__d__subclass(c__ServiceOrganization,c__Organization) ).

fof(miloA1307,axiom,
    ! [ORG] :
      ( p__d__instance(ORG,c__ServiceOrganization)
     => ? [PROC,GOV] :
          ( p__d__instance(PROC,c__RegulatoryProcess)
          & p__patient(PROC,ORG)
          & p__agent(PROC,GOV)
          & p__d__instance(GOV,c__Government) ) ) ).

fof(miloA1308,axiom,
    p__d__subclass(c__Library,c__EducationalOrganization) ).

fof(miloA1309,axiom,
    ! [L] :
      ( p__d__instance(L,c__Library)
     => ? [B,T] :
          ( p__possesses(L,B)
          & p__d__instance(B,c__Building)
          & p__d__instance(T,c__Text)
          & p__located(T,B) ) ) ).

fof(miloA1310,axiom,
    p__d__subclass(c__PublicLibrary,c__Library) ).

fof(miloA1311,axiom,
    p__d__subclass(c__PublicLibrary,c__GovernmentOrganization) ).

fof(miloA1312,axiom,
    p__d__subclass(c__Museum,c__EducationalOrganization) ).

fof(miloA1313,axiom,
    p__d__subclass(c__OrganizationalBoard,c__Organization) ).

fof(miloA1314,axiom,
    ! [BOARD] :
      ( p__d__instance(BOARD,c__OrganizationalBoard)
     => ? [ORG,MANAGE] :
          ( p__d__instance(ORG,c__Organization)
          & p__subOrganization(BOARD,ORG)
          & p__d__instance(MANAGE,c__Managing)
          & p__agent(MANAGE,BOARD)
          & p__patient(MANAGE,ORG) ) ) ).

fof(miloA1315,axiom,
    p__d__subclass(c__SecurityUnit,c__Organization) ).

fof(miloA1317,axiom,
    p__d__subclass(c__UnionOrganization,c__Organization) ).

fof(miloA1318,axiom,
    p__d__subclass(c__OrganicCompound,c__CompoundSubstance) ).

fof(miloA1319,axiom,
    ! [COMPOUND] :
      ( ( p__d__instance(COMPOUND,c__OrganicCompound)
        & p__d__instance(COMPOUND,c__Molecule) )
     => ? [CARBON] :
          ( p__d__instance(CARBON,c__Carbon)
          & p__part(CARBON,COMPOUND) ) ) ).

fof(miloA1320,axiom,
    p__d__subclass(c__Urea,c__OrganicCompound) ).

fof(miloA1321,axiom,
    p__d__subclass(c__Steroid,c__OrganicCompound) ).

fof(miloA1322,axiom,
    p__d__subclass(c__Steroid,c__BiologicallyActiveSubstance) ).

fof(miloA1323,axiom,
    p__d__subclass(c__Hydrocarbon,c__OrganicCompound) ).

fof(miloA1324,axiom,
    ! [S] :
      ( p__d__instance(S,c__Hydrocarbon)
     => ? [P1,P2] :
          ( S = f__MereologicalSumFn2(P1,P2)
          & p__d__instance(P1,c__Carbon)
          & p__d__instance(P2,c__Hydrogen) ) ) ).

fof(miloA1325,axiom,
    p__d__subclass(c__Alcohol,c__OrganicCompound) ).

fof(miloA1326,axiom,
    p__d__subclass(c__Alkaloid,c__ChemicalBase) ).

fof(miloA1327,axiom,
    p__d__subclass(c__Alkaloid,c__PlantSubstance) ).

fof(miloA1328,axiom,
    p__d__subclass(c__Alkaloid,c__BiologicallyActiveSubstance) ).

fof(miloA1329,axiom,
    ! [A] :
      ( p__d__instance(A,c__Alkaloid)
     => ? [N] :
          ( p__d__instance(N,c__Nitrogen)
          & p__part(N,A) ) ) ).

fof(miloA1330,axiom,
    p__d__instance(c__Drugged,c__ConsciousnessAttribute) ).

fof(miloA1331,axiom,
    p__contraryAttribute2(c__Drugged,c__Sober) ).

fof(miloA1333,axiom,
    p__subAttribute(c__Drunk,c__Drugged) ).

fof(miloA1336,axiom,
    p__d__subclass(c__AminoAcid,c__ChemicalAcid) ).

fof(miloA1337,axiom,
    p__d__subclass(c__AminoAcid,c__OrganicCompound) ).

fof(miloA1338,axiom,
    ! [P] :
      ( p__d__instance(P,c__Protein)
     => ? [A] :
          ( p__d__instance(A,c__AminoAcid)
          & p__part(A,P) ) ) ).

fof(miloA1339,axiom,
    p__d__subclass(c__Cholesterol,c__Steroid) ).

fof(miloA1340,axiom,
    p__d__subclass(c__Cholesterol,c__AnimalSubstance) ).

fof(miloA1341,axiom,
    ! [S] :
      ( p__d__instance(S,c__Cholesterol)
     => ? [P,L] :
          ( p__d__instance(P,c__BiologicalProcess)
          & p__eventLocated(P,L)
          & p__d__instance(L,c__Liver)
          & p__result(P,S) ) ) ).

fof(miloA1342,axiom,
    p__d__subclass(c__ChemicalAcid,c__CompoundSubstance) ).

fof(miloA1343,axiom,
    p__d__disjoint(c__ChemicalAcid,c__ChemicalBase) ).

fof(miloA1344,axiom,
    ! [CA,CB,C] :
      ( ( p__d__instance(CA,c__ChemicalAcid)
        & p__d__instance(CB,c__ChemicalBase)
        & p__d__instance(C,c__ChemicalProcess)
        & p__patient(C,CA)
        & p__patient(C,CB) )
     => ? [CS] :
          ( p__d__instance(CS,c__ChemicalSalt)
          & p__result(C,CS) ) ) ).

fof(miloA1345,axiom,
    p__d__subclass(c__ChemicalBase,c__CompoundSubstance) ).

fof(miloA1346,axiom,
    p__d__subclass(c__ChemicalSalt,c__CompoundSubstance) ).

fof(miloA1347,axiom,
    p__d__subclass(c__SodiumChloride,c__ChemicalSalt) ).

fof(miloA1348,axiom,
    ! [SALT] :
      ( p__d__instance(SALT,c__SodiumChloride)
     => ? [SYNTHESIS,SODIUM,CHLORINE] :
          ( p__d__instance(SYNTHESIS,c__ChemicalSynthesis)
          & p__resource(SYNTHESIS,SODIUM)
          & p__d__instance(SODIUM,c__Sodium)
          & p__resource(SYNTHESIS,CHLORINE)
          & p__d__instance(CHLORINE,c__Chlorine)
          & p__result(SYNTHESIS,SALT) ) ) ).

fof(miloA1349,axiom,
    p__d__subclass(c__Diamond,c__Mineral) ).

fof(miloA1350,axiom,
    p__d__subclass(c__Diamond,c__Carbon) ).

fof(miloA1351,axiom,
    p__d__subclass(c__SalineSolution,c__Solution) ).

fof(miloA1352,axiom,
    ! [SOLUTION,PART] :
      ( ( p__d__instance(PART,c__Object)
        & p__d__instance(SOLUTION,c__SalineSolution)
        & p__properPart(PART,SOLUTION) )
     => ( p__d__instance(PART,c__SodiumChloride)
        | p__d__instance(PART,c__Water) ) ) ).

fof(miloA1353,axiom,
    ! [WATER] :
      ( p__d__instance(WATER,c__Water)
     => ? [SYNTHESIS,HYDROGEN,OXYGEN] :
          ( p__d__instance(SYNTHESIS,c__ChemicalSynthesis)
          & p__resource(SYNTHESIS,HYDROGEN)
          & p__d__instance(HYDROGEN,c__Hydrogen)
          & p__resource(SYNTHESIS,OXYGEN)
          & p__d__instance(OXYGEN,c__Oxygen)
          & p__result(SYNTHESIS,WATER) ) ) ).

fof(miloA1356,axiom,
    p__subrelation(c__reactant,c__resource) ).

fof(miloA1359,axiom,
    p__subrelation(c__reagent,c__instrument) ).

fof(miloA1360,axiom,
    p__d__subclass(c__Oil,c__Solution) ).

fof(miloA1361,axiom,
    ! [OIL] :
      ( p__d__instance(OIL,c__Oil)
     => ! [MIX,WATER] :
          ( ~ p__d__instance(MIX,c__Object)
          | ~ p__d__instance(WATER,c__Object)
          | ~ p__d__instance(MIX,c__Mixture)
          | ~ p__part(WATER,MIX)
          | ~ p__d__instance(WATER,c__Water)
          | ~ p__part(OIL,MIX) ) ) ).

fof(miloA1362,axiom,
    p__d__subclass(c__Surfactant,c__Substance) ).

fof(miloA1363,axiom,
    p__d__subclass(c__Detergent,c__Surfactant) ).

fof(miloA1364,axiom,
    p__d__subclass(c__Detergent,c__Mixture) ).

fof(miloA1366,axiom,
    p__d__subclass(c__Bathing,c__Washing) ).

fof(miloA1367,axiom,
    ! [B,A] :
      ( ( p__d__instance(B,c__Bathing)
        & p__patient(B,A) )
     => p__d__instance(A,c__Animal) ) ).

fof(miloA1368,axiom,
    p__d__subclass(c__BathingDevice,c__WashingDevice) ).

fof(miloA1370,axiom,
    p__d__subclass(c__WashBasin,c__WashingDevice) ).

fof(miloA1372,axiom,
    p__d__subclass(c__Glue,c__Mixture) ).

fof(miloA1373,axiom,
    p__d__subclass(c__Glue,c__AttachingDevice) ).

fof(miloA1375,axiom,
    p__d__subclass(c__Glass,c__Mixture) ).

fof(miloA1376,axiom,
    p__d__subclass(c__MetallicAlloy,c__Mixture) ).

fof(miloA1377,axiom,
    ! [ALLOY] :
      ( p__d__instance(ALLOY,c__MetallicAlloy)
     => ? [METAL1,METAL2] :
          ( p__d__instance(METAL1,c__Metal)
          & p__d__instance(METAL2,c__Metal)
          & METAL1 != METAL2
          & p__part(METAL1,ALLOY)
          & p__part(METAL2,ALLOY) ) ) ).

fof(miloA1378,axiom,
    p__d__subclass(c__Steel,c__MetallicAlloy) ).

fof(miloA1379,axiom,
    ! [STEEL] :
      ( p__d__instance(STEEL,c__Steel)
     => ? [IRON] :
          ( p__d__instance(IRON,c__Iron)
          & p__part(IRON,STEEL) ) ) ).

fof(miloA1380,axiom,
    p__d__subclass(c__Brass,c__MetallicAlloy) ).

fof(miloA1381,axiom,
    ! [BRASS] :
      ( p__d__instance(BRASS,c__Brass)
     => ? [COPPER,ZINC] :
          ( p__d__instance(COPPER,c__Copper)
          & p__d__instance(ZINC,c__Zinc)
          & p__part(COPPER,BRASS)
          & p__part(ZINC,BRASS) ) ) ).

fof(miloA1382,axiom,
    p__d__subclass(c__Powder,c__Substance) ).

fof(miloA1383,axiom,
    ! [POWDER] :
      ( p__d__instance(POWDER,c__Powder)
     => p__attribute(POWDER,c__Solid) ) ).

fof(miloA1384,axiom,
    p__d__subclass(c__Fallout,c__Powder) ).

fof(miloA1385,axiom,
    ! [POWDER] :
      ( p__d__instance(POWDER,c__Fallout)
     => p__capability(c__RadiatingNuclear,c__instrument,POWDER) ) ).

fof(miloA1386,axiom,
    p__d__subclass(c__Fog,c__WaterCloud) ).

fof(miloA1387,axiom,
    ! [FOG] :
      ( p__d__instance(FOG,c__Fog)
     => ? [LAND] :
          ( p__d__instance(LAND,c__LandArea)
          & p__meetsSpatially(FOG,LAND) ) ) ).

fof(miloA1388,axiom,
    p__d__subclass(c__Ice,c__Water) ).

fof(miloA1389,axiom,
    ! [ICE] :
      ( p__d__instance(ICE,c__Object)
     => ( p__d__instance(ICE,c__Ice)
      <=> ( p__d__instance(ICE,c__Water)
          & p__attribute(ICE,c__Solid) ) ) ) ).

fof(miloA1390,axiom,
    ! [ICE,NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & p__d__instance(ICE,c__Ice)
        & p__measure(ICE,f__MeasureFn2(NUMBER,c__CelsiusDegree)) )
     => p__lessThanOrEqualTo(NUMBER,c__0) ) ).

fof(miloA1391,axiom,
    p__d__subclass(c__Field,c__LandArea) ).

fof(miloA1392,axiom,
    ! [FIELD] :
      ( p__d__instance(FIELD,c__Field)
     => ! [TREE] :
          ( ~ p__d__instance(TREE,c__Physical)
          | ~ p__d__instance(TREE,c__BotanicalTree)
          | ~ p__located(TREE,FIELD) ) ) ).

fof(miloA1393,axiom,
    p__d__subclass(c__Lawn,c__Field) ).

fof(miloA1394,axiom,
    ! [L] :
      ( p__d__instance(L,c__Lawn)
     => ? [G] :
          ( p__d__instance(G,c__Grass)
          & p__located(G,L) ) ) ).

fof(miloA1395,axiom,
    p__d__subclass(c__MilitaryFront,c__GeographicArea) ).

fof(miloA1397,axiom,
    p__d__partition3(c__Region,c__GeographicArea,c__SpaceRegion) ).

fof(miloA1398,axiom,
    p__d__subclass(c__AtmosphericRegion,c__SpaceRegion) ).

fof(miloA1399,axiom,
    p__d__subclass(c__StreamWaterArea,c__WaterArea) ).

fof(miloA1400,axiom,
    p__d__subclass(c__StreamWaterArea,c__FlowRegion) ).

fof(miloA1401,axiom,
    p__d__disjoint(c__StreamWaterArea,c__StaticWaterArea) ).

fof(miloA1402,axiom,
    p__d__subclass(c__StaticWaterArea,c__WaterArea) ).

fof(miloA1403,axiom,
    p__d__subclass(c__FlowRegion,c__Region) ).

fof(miloA1404,axiom,
    ! [FR,FLUID] :
      ( ( p__d__instance(FLUID,c__Object)
        & p__d__instance(FR,c__FlowRegion)
        & p__located(FLUID,FR) )
     => p__attribute(FLUID,c__Fluid) ) ).

fof(miloA1405,axiom,
    p__d__subclass(c__SpaceRegion,c__Region) ).

fof(miloA1406,axiom,
    p__d__disjoint(c__SpaceRegion,c__GeographicArea) ).

fof(miloA1407,axiom,
    p__d__partition3(c__SpaceRegion,c__AtmosphericRegion,c__OuterSpaceRegion) ).

fof(miloA1408,axiom,
    p__d__subclass(c__OuterSpaceRegion,c__SpaceRegion) ).

fof(miloA1409,axiom,
    p__d__subclass(c__StormFront,c__AtmosphericRegion) ).

fof(miloA1410,axiom,
    ! [FRONT] :
      ( p__d__instance(FRONT,c__StormFront)
     => ? [AIR1,AIR2] :
          ( p__d__instance(AIR1,c__Air)
          & p__d__instance(AIR2,c__Air)
          & p__between(AIR1,FRONT,AIR2) ) ) ).

fof(miloA1411,axiom,
    p__d__instance(c__Inside,c__PositionalAttribute) ).

fof(miloA1413,axiom,
    p__d__instance(c__Outside,c__PositionalAttribute) ).

fof(miloA1414,axiom,
    p__contraryAttribute2(c__Inside,c__Outside) ).

fof(miloA1415,axiom,
    ! [OBJ,REGION] :
      ( ( p__d__instance(REGION,c__Object)
        & p__d__instance(OBJ,c__Object)
        & p__orientation(OBJ,REGION,c__Outside) )
     => p__d__instance(REGION,c__Region) ) ).

fof(miloA1416,axiom,
    ! [OBJ,REGION] :
      ( ( p__d__instance(REGION,c__Object)
        & p__d__instance(OBJ,c__Object)
        & p__orientation(OBJ,REGION,c__Inside) )
     => p__d__instance(REGION,c__Region) ) ).

fof(miloA1417,axiom,
    ! [OBJ,REGION] :
      ( ( p__d__instance(REGION,c__Object)
        & p__d__instance(OBJ,c__Object) )
     => ( p__orientation(OBJ,REGION,c__Outside)
      <=> ~ p__partlyLocated(OBJ,REGION) ) ) ).

fof(miloA1418,axiom,
    ! [OBJ,REGION] :
      ( ( p__d__instance(REGION,c__Object)
        & p__d__instance(OBJ,c__Object)
        & p__part(OBJ,REGION) )
     => ~ p__orientation(OBJ,REGION,c__Outside) ) ).

fof(miloA1419,axiom,
    p__d__subclass(c__Outdoors,c__Region) ).

fof(miloA1420,axiom,
    ! [OUTDOORS] :
      ( p__d__instance(OUTDOORS,c__Outdoors)
     => ! [BUILDING] :
          ( ~ p__d__instance(BUILDING,c__Object)
          | ~ p__d__instance(BUILDING,c__Building)
          | ~ p__orientation(OUTDOORS,BUILDING,c__Inside) ) ) ).

fof(miloA1421,axiom,
    p__d__subclass(c__Indoors,c__Region) ).

fof(miloA1422,axiom,
    p__d__disjoint(c__Indoors,c__Outdoors) ).

fof(miloA1423,axiom,
    ! [INDOORS] :
      ( p__d__instance(INDOORS,c__Indoors)
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__Building)
          & p__orientation(INDOORS,BUILDING,c__Inside) ) ) ).

fof(miloA1424,axiom,
    p__d__subclass(c__BiologicalSpecies,c__Class) ).

fof(miloA1425,axiom,
    ! [SPECIES] :
      ( p__d__instance(SPECIES,c__BiologicalSpecies)
     => p__d__subclass(SPECIES,c__Organism) ) ).

fof(miloA1426,axiom,
    p__d__subclass(c__Wood,c__Tissue) ).

fof(miloA1427,axiom,
    p__d__subclass(c__Wood,c__PlantSubstance) ).

fof(miloA1428,axiom,
    ! [X] :
      ( p__d__instance(X,c__Wood)
     => ? [CELL] :
          ( p__d__instance(CELL,c__Cellulose)
          & p__part(CELL,X) ) ) ).

fof(miloA1430,axiom,
    p__d__subclass(c__WoodArtifact,c__Artifact) ).

fof(miloA1431,axiom,
    ! [W] :
      ( ( p__d__instance(W,c__CorpuscularObject)
        & p__d__instance(W,c__WoodArtifact) )
     => p__material(c__Wood,W) ) ).

fof(miloA1432,axiom,
    p__d__subclass(c__OakWood,c__WoodArtifact) ).

fof(miloA1433,axiom,
    p__d__subclass(c__Rubber,c__PlantSubstance) ).

fof(miloA1434,axiom,
    p__d__subclass(c__Rubber,c__BodySubstance) ).

fof(miloA1435,axiom,
    p__d__subclass(c__Rubber,c__Hydrocarbon) ).

fof(miloA1436,axiom,
    ! [R] :
      ( p__d__instance(R,c__Rubber)
     => ? [T] :
          ( p__d__instance(T,c__BotanicalTree)
          & p__part(R,T) ) ) ).

fof(miloA1437,axiom,
    p__d__subclass(c__Plastic,c__Hydrocarbon) ).

fof(miloA1438,axiom,
    p__d__subclass(c__Polypropylene,c__Plastic) ).

fof(miloA1439,axiom,
    p__d__subclass(c__Polystyrene,c__Plastic) ).

fof(miloA1440,axiom,
    p__d__subclass(c__Cellulose,c__PlantSubstance) ).

fof(miloA1441,axiom,
    p__d__subclass(c__Cellulose,c__Carbohydrate) ).

fof(miloA1442,axiom,
    p__d__subclass(c__Starch,c__Carbohydrate) ).

fof(miloA1443,axiom,
    p__d__subclass(c__Sugar,c__Carbohydrate) ).

fof(miloA1444,axiom,
    p__d__subclass(c__Nectar,c__PlantSubstance) ).

fof(miloA1445,axiom,
    p__d__subclass(c__Medicine,c__BiologicallyActiveSubstance) ).

fof(miloA1446,axiom,
    ! [M] :
      ( p__d__instance(M,c__Medicine)
     => ? [P] :
          ( p__d__instance(P,c__TherapeuticProcess)
          & p__instrument(P,M) ) ) ).

fof(miloA1447,axiom,
    p__d__subclass(c__Stimulant,c__BiologicallyActiveSubstance) ).

fof(miloA1448,axiom,
    p__d__disjoint(c__Stimulant,c__Depressant) ).

fof(miloA1449,axiom,
    p__d__subclass(c__Depressant,c__BiologicallyActiveSubstance) ).

fof(miloA1450,axiom,
    p__d__subclass(c__Opium,c__BiologicallyActiveSubstance) ).

fof(miloA1451,axiom,
    p__d__subclass(c__Opium,c__PlantSubstance) ).

fof(miloA1452,axiom,
    p__d__subclass(c__Opium,c__Depressant) ).

fof(miloA1453,axiom,
    ! [O] :
      ( p__d__instance(O,c__Opium)
     => ? [A] :
          ( p__d__instance(A,c__Alkaloid)
          & p__part(A,O) ) ) ).

fof(miloA1454,axiom,
    p__d__subclass(c__Grass,c__FloweringPlant) ).

fof(miloA1455,axiom,
    p__d__subclass(c__Lilac,c__FloweringPlant) ).

fof(miloA1456,axiom,
    p__d__subclass(c__Tobacco,c__FloweringPlant) ).

fof(miloA1457,axiom,
    p__d__subclass(c__Lesion,c__AbnormalAnatomicalStructure) ).

fof(miloA1458,axiom,
    ! [L] :
      ( p__d__instance(L,c__Lesion)
     => ? [I] :
          ( p__d__instance(I,c__Injuring)
          & p__result(I,L) ) ) ).

fof(miloA1459,axiom,
    ! [L] :
      ( p__d__instance(L,c__Lesion)
     => ? [S,O] :
          ( p__d__instance(S,c__SelfConnectedObject)
          & p__surface(S,O)
          & p__d__instance(O,c__Organ)
          & p__located(L,S) ) ) ).

fof(miloA1460,axiom,
    p__d__subclass(c__Scar,c__AbnormalAnatomicalStructure) ).

fof(miloA1462,axiom,
    p__d__subclass(c__Tumor,c__AbnormalAnatomicalStructure) ).

fof(miloA1463,axiom,
    ! [TUMOR,PART] :
      ( ( p__d__subclass(PART,c__Substance)
        & p__d__instance(TUMOR,c__Tumor)
        & p__material(PART,TUMOR) )
     => p__d__subclass(PART,c__Tissue) ) ).

fof(miloA1464,axiom,
    p__d__subclass(c__Tendon,c__Tissue) ).

fof(miloA1465,axiom,
    p__d__subclass(c__Tendon,c__AnimalSubstance) ).

fof(miloA1466,axiom,
    ! [T] :
      ( p__d__instance(T,c__Tendon)
     => ? [M,B] :
          ( p__d__instance(M,c__Muscle)
          & p__d__instance(B,c__Bone)
          & p__connects(T,M,B) ) ) ).

fof(miloA1467,axiom,
    p__d__subclass(c__Sweat,c__AnimalSubstance) ).

fof(miloA1468,axiom,
    ! [SWEAT] :
      ( p__d__instance(SWEAT,c__Sweat)
     => ? [PART] :
          ( p__d__instance(PART,c__SodiumChloride)
          & p__part(PART,SWEAT) ) ) ).

fof(miloA1469,axiom,
    p__d__subclass(c__PlantLeaf,c__PlantAnatomicalStructure) ).

fof(miloA1470,axiom,
    p__d__subclass(c__PlantLeaf,c__Organ) ).

fof(miloA1471,axiom,
    p__d__subclass(c__PlantBranch,c__PlantAnatomicalStructure) ).

fof(miloA1472,axiom,
    p__d__subclass(c__PlantBranch,c__BodyPart) ).

fof(miloA1473,axiom,
    p__d__subclass(c__BotanicalTree,c__FloweringPlant) ).

fof(miloA1474,axiom,
    ! [X] :
      ( p__d__instance(X,c__BotanicalTree)
     => p__material(c__Wood,X) ) ).

fof(miloA1475,axiom,
    p__d__subclass(c__TreeBranch,c__PlantBranch) ).

fof(miloA1476,axiom,
    ! [B] :
      ( p__d__instance(B,c__TreeBranch)
     => ? [T] :
          ( p__d__instance(T,c__BotanicalTree)
          & p__part(B,T) ) ) ).

fof(miloA1477,axiom,
    p__d__subclass(c__WillowTree,c__BotanicalTree) ).

fof(miloA1478,axiom,
    p__d__subclass(c__PlantRoot,c__PlantAnatomicalStructure) ).

fof(miloA1479,axiom,
    p__d__subclass(c__PlantRoot,c__Organ) ).

fof(miloA1480,axiom,
    p__d__subclass(c__Flower,c__PlantAnatomicalStructure) ).

fof(miloA1481,axiom,
    p__d__subclass(c__Flower,c__Organ) ).

fof(miloA1483,axiom,
    p__d__subclass(c__Antibody,c__Protein) ).

fof(miloA1485,axiom,
    p__d__subclass(c__Antibiotic,c__BiologicallyActiveSubstance) ).

fof(miloA1486,axiom,
    p__d__subclass(c__Antigen,c__BiologicallyActiveSubstance) ).

fof(miloA1487,axiom,
    p__d__subclass(c__AntigenA,c__Antigen) ).

fof(miloA1488,axiom,
    p__d__subclass(c__AntigenB,c__Antigen) ).

fof(miloA1489,axiom,
    p__d__subclass(c__BloodCell,c__Cell) ).

fof(miloA1490,axiom,
    p__d__subclass(c__BloodCell,c__AnimalAnatomicalStructure) ).

fof(miloA1491,axiom,
    p__d__subclass(c__RedBloodCell,c__BloodCell) ).

fof(miloA1492,axiom,
    ! [C] :
      ( p__d__instance(C,c__RedBloodCell)
     => ! [N] :
          ( ~ p__d__instance(N,c__Object)
          | ~ p__d__instance(N,c__CellNucleus)
          | ~ p__part(N,C) ) ) ).

fof(miloA1493,axiom,
    p__d__subclass(c__WhiteBloodCell,c__BloodCell) ).

fof(miloA1494,axiom,
    ! [C] :
      ( p__d__instance(C,c__WhiteBloodCell)
     => ? [N] :
          ( p__d__instance(N,c__CellNucleus)
          & p__part(N,C) ) ) ).

fof(miloA1495,axiom,
    p__d__subclass(c__BloodTypeA,c__Blood) ).

fof(miloA1496,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeA)
     => ? [A] :
          ( p__d__instance(A,c__AntigenA)
          & p__part(A,B) ) ) ).

fof(miloA1497,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeA)
     => ! [A] :
          ( ~ p__d__instance(A,c__Object)
          | ~ p__d__instance(A,c__AntigenB)
          | ~ p__part(A,B) ) ) ).

fof(miloA1498,axiom,
    p__d__subclass(c__BloodTypeAB,c__Blood) ).

fof(miloA1499,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeAB)
     => ? [A] :
          ( p__d__instance(A,c__AntigenA)
          & p__part(A,B) ) ) ).

fof(miloA1500,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeAB)
     => ? [A] :
          ( p__d__instance(A,c__AntigenB)
          & p__part(A,B) ) ) ).

fof(miloA1501,axiom,
    p__d__subclass(c__BloodTypeB,c__Blood) ).

fof(miloA1502,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeB)
     => ? [A] :
          ( p__d__instance(A,c__AntigenB)
          & p__part(A,B) ) ) ).

fof(miloA1503,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeB)
     => ! [A] :
          ( ~ p__d__instance(A,c__Object)
          | ~ p__d__instance(A,c__AntigenA)
          | ~ p__part(A,B) ) ) ).

fof(miloA1504,axiom,
    p__d__subclass(c__BloodTypeO,c__Blood) ).

fof(miloA1505,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeO)
     => ! [A] :
          ( ~ p__d__instance(A,c__Object)
          | ~ p__d__instance(A,c__AntigenA)
          | ~ p__part(A,B) ) ) ).

fof(miloA1506,axiom,
    ! [B] :
      ( p__d__instance(B,c__BloodTypeO)
     => ! [A] :
          ( ~ p__d__instance(A,c__Object)
          | ~ p__d__instance(A,c__AntigenB)
          | ~ p__part(A,B) ) ) ).

fof(miloA1507,axiom,
    p__d__subclass(c__NerveCell,c__Cell) ).

fof(miloA1508,axiom,
    p__d__subclass(c__NerveCell,c__AnimalAnatomicalStructure) ).

fof(miloA1509,axiom,
    ! [N] :
      ( p__d__instance(N,c__NerveCell)
     => ? [S] :
          ( p__d__instance(S,c__NervousSystem)
          & p__part(N,S) ) ) ).

fof(miloA1510,axiom,
    p__d__subclass(c__LiquidBodySubstance,c__BodySubstance) ).

fof(miloA1511,axiom,
    ! [SUBSTANCE] :
      ( p__d__instance(SUBSTANCE,c__LiquidBodySubstance)
     => p__attribute(SUBSTANCE,c__Liquid) ) ).

fof(miloA1512,axiom,
    p__d__subclass(c__Serum,c__LiquidBodySubstance) ).

fof(miloA1513,axiom,
    p__d__disjoint(c__Serum,c__Blood) ).

fof(miloA1514,axiom,
    p__d__subclass(c__TearSubstance,c__LiquidBodySubstance) ).

fof(miloA1515,axiom,
    p__d__subclass(c__TearSubstance,c__SalineSolution) ).

fof(miloA1516,axiom,
    ! [T] :
      ( p__d__instance(T,c__TearSubstance)
     => ? [P,E] :
          ( p__d__instance(P,c__Process)
          & p__d__instance(E,c__Eye)
          & p__instrument(P,E)
          & p__result(P,T) ) ) ).

fof(miloA1517,axiom,
    p__d__subclass(c__Milk,c__LiquidBodySubstance) ).

fof(miloA1518,axiom,
    p__d__subclass(c__Milk,c__Beverage) ).

fof(miloA1519,axiom,
    ! [MILK] :
      ( p__d__instance(MILK,c__Milk)
     => ? [PROCESS,MAMMAL] :
          ( p__d__instance(PROCESS,c__Process)
          & p__d__instance(MAMMAL,c__Mammal)
          & p__attribute(MAMMAL,c__Female)
          & p__instrument(PROCESS,MAMMAL)
          & p__result(PROCESS,MILK) ) ) ).

fof(miloA1520,axiom,
    p__d__subclass(c__CellPart,c__BodyPart) ).

fof(miloA1521,axiom,
    ! [OBJ1] :
      ( p__d__instance(OBJ1,c__CellPart)
     => ? [CELL] :
          ( p__d__instance(CELL,c__Cell)
          & p__properPart(OBJ1,CELL) ) ) ).

fof(miloA1522,axiom,
    p__d__subclass(c__CellNucleus,c__CellPart) ).

fof(miloA1523,axiom,
    ! [NUCLEUS] :
      ( p__d__instance(NUCLEUS,c__CellNucleus)
     => ? [CELL] :
          ( p__d__instance(CELL,c__Cell)
          & p__part(NUCLEUS,CELL) ) ) ).

fof(miloA1524,axiom,
    p__d__subclass(c__Tea,c__Beverage) ).

fof(miloA1525,axiom,
    p__d__subclass(c__Tea,c__PreparedFood) ).

fof(miloA1526,axiom,
    p__d__subclass(c__AlcoholicBeverage,c__Beverage) ).

fof(miloA1527,axiom,
    p__d__subclass(c__AlcoholicBeverage,c__Depressant) ).

fof(miloA1528,axiom,
    ! [BEVERAGE] :
      ( p__d__instance(BEVERAGE,c__AlcoholicBeverage)
     => ? [ALCOHOL] :
          ( p__d__instance(ALCOHOL,c__Alcohol)
          & p__part(ALCOHOL,BEVERAGE) ) ) ).

fof(miloA1529,axiom,
    p__d__subclass(c__Wine,c__AlcoholicBeverage) ).

fof(miloA1530,axiom,
    p__d__subclass(c__DistilledAlcoholicBeverage,c__AlcoholicBeverage) ).

fof(miloA1531,axiom,
    ! [BEVERAGE] :
      ( p__d__instance(BEVERAGE,c__DistilledAlcoholicBeverage)
     => ? [REMOVE,WATER] :
          ( p__d__instance(REMOVE,c__Removing)
          & p__patient(REMOVE,WATER)
          & p__d__instance(WATER,c__Water)
          & p__origin(REMOVE,BEVERAGE) ) ) ).

fof(miloA1532,axiom,
    p__d__subclass(c__Beer,c__AlcoholicBeverage) ).

fof(miloA1533,axiom,
    p__d__subclass(c__SpinalColumn,c__Organ) ).

fof(miloA1534,axiom,
    p__d__subclass(c__SpinalColumn,c__AnimalAnatomicalStructure) ).

fof(miloA1535,axiom,
    ! [VERT] :
      ( p__d__instance(VERT,c__CorpuscularObject)
     => ( p__d__instance(VERT,c__Vertebrate)
      <=> ? [SPINE] :
            ( p__d__instance(VERT,c__Animal)
            & p__component(SPINE,VERT)
            & p__d__instance(SPINE,c__SpinalColumn) ) ) ) ).

fof(miloA1536,axiom,
    p__d__subclass(c__SpinalCord,c__Organ) ).

fof(miloA1537,axiom,
    ! [C] :
      ( p__d__instance(C,c__SpinalCord)
     => ? [S] :
          ( p__d__instance(S,c__NervousSystem)
          & p__part(C,S) ) ) ).

fof(miloA1538,axiom,
    ! [C] :
      ( p__d__instance(C,c__SpinalCord)
     => ? [S] :
          ( p__d__instance(S,c__SpinalColumn)
          & p__contains(S,C) ) ) ).

fof(miloA1539,axiom,
    p__d__subclass(c__Tail,c__AnimalAnatomicalStructure) ).

fof(miloA1540,axiom,
    ! [T] :
      ( p__d__instance(T,c__Tail)
     => ? [V] :
          ( p__d__instance(V,c__Vertebrate)
          & p__part(T,V)
          & ~ p__d__instance(V,c__Human) ) ) ).

fof(miloA1541,axiom,
    p__d__subclass(c__Wing,c__Limb) ).

fof(miloA1542,axiom,
    p__d__subclass(c__Skin,c__BodyCovering) ).

fof(miloA1543,axiom,
    p__d__subclass(c__Skin,c__AnimalAnatomicalStructure) ).

fof(miloA1544,axiom,
    ! [SKIN] :
      ( p__d__instance(SKIN,c__Skin)
     => ? [SURFACE,ANIMAL] :
          ( p__d__instance(SURFACE,c__SelfConnectedObject)
          & p__surface(SURFACE,ANIMAL)
          & p__part(SKIN,ANIMAL)
          & p__d__instance(ANIMAL,c__Animal)
          & p__overlapsSpatially(SKIN,SURFACE) ) ) ).

fof(miloA1545,axiom,
    p__d__subclass(c__Retina,c__Organ) ).

fof(miloA1546,axiom,
    p__d__subclass(c__Retina,c__AnimalAnatomicalStructure) ).

fof(miloA1547,axiom,
    ! [R] :
      ( p__d__instance(R,c__Retina)
     => ? [E] :
          ( p__d__instance(E,c__Eye)
          & p__part(R,E) ) ) ).

fof(miloA1548,axiom,
    p__d__subclass(c__BronchialDuct,c__BodyVessel) ).

fof(miloA1549,axiom,
    p__d__subclass(c__BronchialDuct,c__AnimalAnatomicalStructure) ).

fof(miloA1550,axiom,
    ! [DUCT] :
      ( p__d__instance(DUCT,c__BronchialDuct)
     => ? [LUNG] :
          ( p__d__instance(LUNG,c__Lung)
          & p__located(DUCT,LUNG) ) ) ).

fof(miloA1551,axiom,
    p__d__subclass(c__BloodVessel,c__BodyVessel) ).

fof(miloA1552,axiom,
    p__d__subclass(c__BloodVessel,c__AnimalAnatomicalStructure) ).

fof(miloA1553,axiom,
    ! [VESSEL] :
      ( p__d__instance(VESSEL,c__BloodVessel)
     => ? [BLOOD,TRANSFER] :
          ( p__d__instance(BLOOD,c__Blood)
          & p__d__instance(TRANSFER,c__Transfer)
          & p__patient(TRANSFER,BLOOD)
          & p__instrument(TRANSFER,VESSEL) ) ) ).

fof(miloA1554,axiom,
    p__d__subclass(c__Alveolus,c__BodyVessel) ).

fof(miloA1555,axiom,
    p__d__subclass(c__Alveolus,c__AnimalAnatomicalStructure) ).

fof(miloA1556,axiom,
    ! [A] :
      ( p__d__instance(A,c__Alveolus)
     => ? [L] :
          ( p__d__instance(L,c__Lung)
          & p__located(A,L) ) ) ).

fof(miloA1557,axiom,
    p__d__subclass(c__Artery,c__BloodVessel) ).

fof(miloA1558,axiom,
    ! [ARTERY,BLOOD,TRANSFER] :
      ( ( p__d__instance(ARTERY,c__Artery)
        & p__d__instance(TRANSFER,c__Transfer)
        & p__patient(TRANSFER,BLOOD)
        & p__instrument(TRANSFER,ARTERY)
        & p__d__instance(BLOOD,c__Blood) )
     => ? [HEART] :
          ( p__d__instance(HEART,c__Heart)
          & p__origin(TRANSFER,HEART) ) ) ).

fof(miloA1559,axiom,
    p__d__subclass(c__Vein,c__BloodVessel) ).

fof(miloA1561,axiom,
    ! [V,B,T] :
      ( ( p__d__instance(V,c__Vein)
        & p__d__instance(T,c__Transfer)
        & p__patient(T,B)
        & p__instrument(T,V)
        & p__d__instance(B,c__Blood) )
     => ? [H] :
          ( p__d__instance(H,c__Heart)
          & p__destination(T,H) ) ) ).

fof(miloA1562,axiom,
    p__d__subclass(c__PulmonaryArtery,c__Artery) ).

fof(miloA1563,axiom,
    ! [ARTERY,BLOOD,TRANSFER] :
      ( ( p__d__instance(ARTERY,c__PulmonaryArtery)
        & p__d__instance(TRANSFER,c__Transfer)
        & p__patient(TRANSFER,BLOOD)
        & p__instrument(TRANSFER,ARTERY)
        & p__d__instance(BLOOD,c__Blood) )
     => ? [LUNG] :
          ( p__d__instance(LUNG,c__Lung)
          & p__destination(TRANSFER,LUNG) ) ) ).

fof(miloA1564,axiom,
    p__d__subclass(c__PulmonaryVein,c__Vein) ).

fof(miloA1565,axiom,
    ! [B,V,T] :
      ( ( p__d__instance(V,c__PulmonaryVein)
        & p__d__instance(T,c__Transfer)
        & p__patient(T,B)
        & p__instrument(T,V)
        & p__d__instance(B,c__Blood) )
     => ? [L,H,P] :
          ( p__d__instance(P,c__Object)
          & p__d__instance(L,c__Lung)
          & p__origin(T,L)
          & p__part(V,P)
          & p__part(L,P)
          & p__part(H,P)
          & p__d__instance(H,c__Heart)
          & p__destination(T,H) ) ) ).

fof(miloA1566,axiom,
    p__d__subclass(c__Capillary,c__BloodVessel) ).

fof(miloA1567,axiom,
    ! [C] :
      ( p__d__instance(C,c__Capillary)
     => ? [A,V] :
          ( p__d__instance(A,c__Artery)
          & p__d__instance(V,c__Vein)
          & p__connects(C,A,V) ) ) ).

fof(miloA1568,axiom,
    p__d__subclass(c__Lung,c__Organ) ).

fof(miloA1569,axiom,
    p__d__subclass(c__Lung,c__AnimalAnatomicalStructure) ).

fof(miloA1570,axiom,
    ! [ANIMAL] :
      ( ( p__d__instance(ANIMAL,c__Object)
        & p__capability(c__Breathing,c__experiencer,ANIMAL) )
     => ? [LUNG] :
          ( p__properPart(LUNG,ANIMAL)
          & p__d__instance(LUNG,c__Lung) ) ) ).

fof(miloA1571,axiom,
    p__d__subclass(c__Kidney,c__Organ) ).

fof(miloA1572,axiom,
    p__d__subclass(c__Kidney,c__AnimalAnatomicalStructure) ).

fof(miloA1573,axiom,
    p__d__subclass(c__Spleen,c__Organ) ).

fof(miloA1574,axiom,
    p__d__subclass(c__Spleen,c__AnimalAnatomicalStructure) ).

fof(miloA1575,axiom,
    p__d__subclass(c__Inhaling,c__Breathing) ).

fof(miloA1576,axiom,
    ! [I] :
      ( p__d__instance(I,c__Inhaling)
     => ? [L] :
          ( p__d__instance(L,c__Lung)
          & p__destination(I,L) ) ) ).

fof(miloA1577,axiom,
    p__d__subclass(c__Exhaling,c__Breathing) ).

fof(miloA1578,axiom,
    ! [E] :
      ( p__d__instance(E,c__Exhaling)
     => ? [L] :
          ( p__d__instance(L,c__Lung)
          & p__origin(E,L) ) ) ).

fof(miloA1579,axiom,
    p__d__subclass(c__Nostril,c__BodyVessel) ).

fof(miloA1580,axiom,
    p__d__subclass(c__Nostril,c__AnimalAnatomicalStructure) ).

fof(miloA1581,axiom,
    ! [NOSE] :
      ( p__d__instance(NOSE,c__Nose)
     => ? [N1,N2] :
          ( p__d__instance(N1,c__Nostril)
          & p__d__instance(N2,c__Nostril)
          & N1 != N2
          & p__connected(N1,NOSE)
          & p__connected(N2,NOSE) ) ) ).

fof(miloA1582,axiom,
    ! [NOS] :
      ( p__d__instance(NOS,c__Nostril)
     => ? [N,T] :
          ( p__d__instance(N,c__Nose)
          & p__d__instance(T,c__Throat)
          & p__connects(NOS,N,T) ) ) ).

fof(miloA1583,axiom,
    p__d__subclass(c__Heart,c__Organ) ).

fof(miloA1584,axiom,
    p__d__subclass(c__Heart,c__AnimalAnatomicalStructure) ).

fof(miloA1585,axiom,
    ! [HEART] :
      ( p__d__instance(HEART,c__Heart)
     => ? [TRANSFER,BLOOD] :
          ( p__d__instance(TRANSFER,c__Transfer)
          & p__d__instance(BLOOD,c__Blood)
          & p__instrument(TRANSFER,HEART)
          & p__patient(TRANSFER,BLOOD) ) ) ).

fof(miloA1586,axiom,
    p__d__subclass(c__Liver,c__Organ) ).

fof(miloA1587,axiom,
    p__d__subclass(c__Liver,c__AnimalAnatomicalStructure) ).

fof(miloA1588,axiom,
    p__d__subclass(c__Mouth,c__AnimalAnatomicalStructure) ).

fof(miloA1589,axiom,
    p__d__subclass(c__Mouth,c__BodyPart) ).

fof(miloA1590,axiom,
    ! [MOUTH] :
      ( p__d__instance(MOUTH,c__Mouth)
     => ? [FACE] :
          ( p__d__instance(FACE,c__Face)
          & p__part(MOUTH,FACE) ) ) ).

fof(miloA1591,axiom,
    p__d__subclass(c__Tongue,c__AnimalAnatomicalStructure) ).

fof(miloA1592,axiom,
    p__d__subclass(c__Tongue,c__BodyPart) ).

fof(miloA1593,axiom,
    ! [TONGUE] :
      ( p__d__instance(TONGUE,c__Tongue)
     => ? [MOUTH] :
          ( p__d__instance(MOUTH,c__Mouth)
          & p__part(TONGUE,MOUTH) ) ) ).

fof(miloA1594,axiom,
    p__d__subclass(c__NervousSystem,c__Organ) ).

fof(miloA1595,axiom,
    p__d__subclass(c__NervousSystem,c__AnimalAnatomicalStructure) ).

fof(miloA1596,axiom,
    ! [S,A] :
      ( ( p__d__instance(S,c__NervousSystem)
        & p__part(S,A)
        & p__d__instance(A,c__Animal) )
     => p__d__instance(A,c__Vertebrate) ) ).

fof(miloA1597,axiom,
    p__d__subclass(c__Hoof,c__AnimalAnatomicalStructure) ).

fof(miloA1598,axiom,
    p__d__subclass(c__Hoof,c__BodyPart) ).

fof(miloA1599,axiom,
    ! [H] :
      ( p__d__instance(H,c__Hoof)
     => ? [F,A] :
          ( p__d__instance(F,c__Foot)
          & p__d__instance(A,c__HoofedMammal)
          & p__part(H,F)
          & p__part(F,A) ) ) ).

fof(miloA1600,axiom,
    p__d__subclass(c__Tooth,c__Bone) ).

fof(miloA1601,axiom,
    ! [TOOTH] :
      ( p__d__instance(TOOTH,c__Tooth)
     => ? [MOUTH] :
          ( p__d__instance(MOUTH,c__Mouth)
          & p__part(TOOTH,MOUTH) ) ) ).

fof(miloA1602,axiom,
    p__d__subclass(c__Skull,c__Bone) ).

fof(miloA1603,axiom,
    ! [S] :
      ( p__d__instance(S,c__Skull)
     => ? [V,H] :
          ( p__d__instance(V,c__Vertebrate)
          & p__d__instance(H,c__Head)
          & p__part(H,V)
          & p__part(S,H) ) ) ).

fof(miloA1604,axiom,
    p__d__subclass(c__Horn,c__Bone) ).

fof(miloA1605,axiom,
    ! [H] :
      ( p__d__instance(H,c__Horn)
     => ? [M] :
          ( p__d__instance(M,c__HoofedMammal)
          & p__part(H,M) ) ) ).

fof(miloA1606,axiom,
    p__d__subclass(c__Ivory,c__Bone) ).

fof(miloA1607,axiom,
    p__d__subclass(c__AnimalShell,c__AnimalAnatomicalStructure) ).

fof(miloA1608,axiom,
    p__d__subclass(c__AnimalShell,c__BodyPart) ).

fof(miloA1609,axiom,
    ! [S,A] :
      ( ( p__d__instance(A,c__Animal)
        & p__d__instance(S,c__AnimalShell)
        & p__part(S,A) )
     => ( p__d__instance(A,c__Invertebrate)
        | p__d__instance(A,c__Reptile) ) ) ).

fof(miloA1610,axiom,
    p__d__subclass(c__Ossification,c__OrganOrTissueProcess) ).

fof(miloA1611,axiom,
    ! [O] :
      ( p__d__instance(O,c__Ossification)
     => ? [B] :
          ( p__d__instance(B,c__Bone)
          & p__result(O,B) ) ) ).

fof(miloA1612,axiom,
    p__d__subclass(c__Chewing,c__BodyMotion) ).

fof(miloA1614,axiom,
    ! [CHEW,TOOTH] :
      ( ( p__d__instance(TOOTH,c__Physical)
        & p__d__instance(CHEW,c__Chewing)
        & p__instrument(CHEW,TOOTH) )
     => p__d__instance(TOOTH,c__Tooth) ) ).

fof(miloA1615,axiom,
    ! [CHEW] :
      ( p__d__instance(CHEW,c__Chewing)
     => ? [EAT] :
          ( p__d__instance(EAT,c__Eating)
          & p__subProcess(CHEW,EAT) ) ) ).

fof(miloA1616,axiom,
    p__d__subclass(c__Feeding,c__Giving) ).

fof(miloA1618,axiom,
    ! [F,A] :
      ( ( p__d__instance(F,c__Feeding)
        & p__destination(F,A) )
     => p__d__instance(A,c__Animal) ) ).

fof(miloA1619,axiom,
    p__d__subclass(c__Lip,c__AnimalAnatomicalStructure) ).

fof(miloA1620,axiom,
    p__d__subclass(c__Lip,c__BodyPart) ).

fof(miloA1621,axiom,
    ! [LIP] :
      ( p__d__instance(LIP,c__Lip)
     => ? [MOUTH] :
          ( p__d__instance(MOUTH,c__Mouth)
          & p__part(LIP,MOUTH) ) ) ).

fof(miloA1622,axiom,
    p__d__subclass(c__Kissing,c__Touching) ).

fof(miloA1624,axiom,
    p__d__subclass(c__Licking,c__Touching) ).

fof(miloA1625,axiom,
    ! [L] :
      ( p__d__instance(L,c__Licking)
     => ? [T] :
          ( p__d__instance(T,c__Tongue)
          & p__instrument(L,T) ) ) ).

fof(miloA1626,axiom,
    p__d__subclass(c__Embracing,c__Touching) ).

fof(miloA1627,axiom,
    ! [E] :
      ( p__d__instance(E,c__Embracing)
     => ? [P1,P2] :
          ( p__d__instance(P1,c__Human)
          & p__d__instance(P2,c__Human)
          & P1 != P2
          & p__agent(E,P1)
          & p__agent(E,P2) ) ) ).

fof(miloA1628,axiom,
    p__d__subclass(c__Skeleton,c__AnimalAnatomicalStructure) ).

fof(miloA1629,axiom,
    p__d__subclass(c__Skeleton,c__BodyPart) ).

fof(miloA1630,axiom,
    ! [SKELETON,ANIMAL] :
      ( ( p__d__instance(ANIMAL,c__Animal)
        & p__d__instance(SKELETON,c__Skeleton)
        & p__part(SKELETON,ANIMAL) )
     => p__d__instance(ANIMAL,c__Vertebrate) ) ).

fof(miloA1631,axiom,
    ! [S] :
      ( p__d__instance(S,c__Skeleton)
     => ? [A] :
          ( p__d__instance(A,c__Animal)
          & p__interiorPart(S,A) ) ) ).

fof(miloA1632,axiom,
    p__d__subclass(c__Exoskeleton,c__AnimalAnatomicalStructure) ).

fof(miloA1633,axiom,
    p__d__subclass(c__Exoskeleton,c__BodyPart) ).

fof(miloA1634,axiom,
    ! [SKELETON,ANIMAL] :
      ( ( p__d__instance(ANIMAL,c__Animal)
        & p__d__instance(SKELETON,c__Exoskeleton)
        & p__part(SKELETON,ANIMAL) )
     => p__d__instance(ANIMAL,c__Invertebrate) ) ).

fof(miloA1635,axiom,
    ! [BONE] :
      ( p__d__instance(BONE,c__Object)
     => ( p__d__instance(BONE,c__Bone)
      <=> ? [SKELETON] :
            ( p__d__instance(SKELETON,c__Object)
            & ( p__d__instance(SKELETON,c__Skeleton)
              | p__d__instance(SKELETON,c__Exoskeleton) )
            & p__properPart(BONE,SKELETON) ) ) ) ).

fof(miloA1636,axiom,
    ! [X] :
      ( p__d__instance(X,c__Exoskeleton)
     => ? [A] :
          ( p__d__instance(A,c__Animal)
          & p__part(X,A)
          & ! [PART] :
              ( ~ p__d__instance(PART,c__Object)
              | ~ p__properPart(PART,A)
              | ~ p__orientation(PART,X,c__Outside) ) ) ) ).

fof(miloA1637,axiom,
    p__d__subclass(c__BodyJoint,c__BodyJunction) ).

fof(miloA1638,axiom,
    ! [J] :
      ( p__d__instance(J,c__BodyJoint)
     => ? [S,P1,P2] :
          ( p__d__instance(P1,c__CorpuscularObject)
          & p__d__instance(P2,c__CorpuscularObject)
          & p__d__instance(S,c__Skeleton)
          & p__component(P1,S)
          & p__component(P2,S)
          & p__component(J,S)
          & p__connects(J,P1,P2) ) ) ).

fof(miloA1639,axiom,
    p__d__subclass(c__Airway,c__Transitway) ).

fof(miloA1640,axiom,
    p__d__subclass(c__Throat,c__AnimalAnatomicalStructure) ).

fof(miloA1641,axiom,
    p__d__subclass(c__Throat,c__BodyVessel) ).

fof(miloA1642,axiom,
    p__d__subclass(c__Throat,c__Airway) ).

fof(miloA1643,axiom,
    ! [THROAT] :
      ( p__d__instance(THROAT,c__Throat)
     => ? [MOUTH] :
          ( p__d__instance(MOUTH,c__Mouth)
          & p__connected(THROAT,MOUTH) ) ) ).

fof(miloA1644,axiom,
    p__d__subclass(c__Hair,c__AnimalAnatomicalStructure) ).

fof(miloA1646,axiom,
    p__d__subclass(c__FacialHair,c__Hair) ).

fof(miloA1647,axiom,
    ! [H] :
      ( p__d__instance(H,c__FacialHair)
     => ? [F] :
          ( p__d__instance(F,c__Face)
          & p__part(H,F) ) ) ).

fof(miloA1648,axiom,
    p__d__subclass(c__HairRemoval,c__Removing) ).

fof(miloA1649,axiom,
    ! [REMOVE,HAIR] :
      ( ( p__d__instance(HAIR,c__Object)
        & p__d__instance(REMOVE,c__HairRemoval)
        & p__resource(REMOVE,HAIR) )
     => p__d__instance(HAIR,c__Hair) ) ).

fof(miloA1650,axiom,
    p__d__subclass(c__Peeling,c__Removing) ).

fof(miloA1651,axiom,
    ! [P,O] :
      ( ( p__d__instance(O,c__Object)
        & p__d__instance(P,c__Peeling)
        & p__patient(P,O) )
     => ? [S] :
          ( p__d__instance(S,c__Skin)
          & p__part(O,S) ) ) ).

fof(miloA1652,axiom,
    p__d__subclass(c__Brain,c__Organ) ).

fof(miloA1653,axiom,
    p__d__subclass(c__Brain,c__AnimalAnatomicalStructure) ).

fof(miloA1654,axiom,
    p__d__instance(c__intelligenceQuotient,c__BinaryPredicate) ).

fof(miloA1655,axiom,
    p__d__instance(c__intelligenceQuotient,c__SingleValuedRelation) ).

fof(miloA1658,axiom,
    p__d__subclass(c__Stomach,c__Organ) ).

fof(miloA1659,axiom,
    p__d__subclass(c__Stomach,c__AnimalAnatomicalStructure) ).

fof(miloA1660,axiom,
    ! [S] :
      ( p__d__instance(S,c__Stomach)
     => p__capability(c__Digesting,c__instrument,S) ) ).

fof(miloA1661,axiom,
    p__d__subclass(c__Intestine,c__BodyVessel) ).

fof(miloA1662,axiom,
    p__d__subclass(c__Intestine,c__AnimalAnatomicalStructure) ).

fof(miloA1663,axiom,
    ! [I] :
      ( p__d__instance(I,c__Intestine)
     => p__capability(c__Digesting,c__instrument,I) ) ).

fof(miloA1664,axiom,
    ! [I] :
      ( p__d__instance(I,c__Intestine)
     => ? [S] :
          ( p__d__instance(S,c__Stomach)
          & p__connected(I,S) ) ) ).

fof(miloA1665,axiom,
    p__d__subclass(c__Hypothalamus,c__BodyPart) ).

fof(miloA1666,axiom,
    p__d__subclass(c__Hypothalamus,c__AnimalAnatomicalStructure) ).

fof(miloA1667,axiom,
    ! [HYPO] :
      ( p__d__instance(HYPO,c__Hypothalamus)
     => ? [BRAIN] :
          ( p__d__instance(BRAIN,c__Brain)
          & p__part(HYPO,BRAIN) ) ) ).

fof(miloA1668,axiom,
    p__d__subclass(c__Eye,c__Organ) ).

fof(miloA1669,axiom,
    p__d__subclass(c__Eye,c__AnimalAnatomicalStructure) ).

fof(miloA1670,axiom,
    ! [EYE] :
      ( p__d__instance(EYE,c__Eye)
     => p__capability(c__Seeing,c__instrument,EYE) ) ).

fof(miloA1671,axiom,
    ! [EYE] :
      ( p__d__instance(EYE,c__Eye)
     => ? [HEAD] :
          ( p__d__instance(HEAD,c__Head)
          & p__part(EYE,HEAD) ) ) ).

fof(miloA1672,axiom,
    p__d__subclass(c__Ear,c__Organ) ).

fof(miloA1673,axiom,
    p__d__subclass(c__Ear,c__AnimalAnatomicalStructure) ).

fof(miloA1674,axiom,
    ! [EAR] :
      ( p__d__instance(EAR,c__Ear)
     => p__capability(c__Hearing,c__instrument,EAR) ) ).

fof(miloA1675,axiom,
    ! [EAR] :
      ( p__d__instance(EAR,c__Ear)
     => ? [HEAD] :
          ( p__d__instance(HEAD,c__Head)
          & p__part(EAR,HEAD) ) ) ).

fof(miloA1676,axiom,
    p__d__subclass(c__Eyelid,c__Skin) ).

fof(miloA1677,axiom,
    ! [E] :
      ( p__d__instance(E,c__Eyelid)
     => p__capability(c__Covering,c__instrument,E) ) ).

fof(miloA1679,axiom,
    p__d__subclass(c__Nose,c__Organ) ).

fof(miloA1680,axiom,
    p__d__subclass(c__Nose,c__AnimalAnatomicalStructure) ).

fof(miloA1681,axiom,
    ! [NOSE] :
      ( p__d__instance(NOSE,c__Nose)
     => p__capability(c__Smelling,c__instrument,NOSE) ) ).

fof(miloA1682,axiom,
    ! [NOSE] :
      ( p__d__instance(NOSE,c__Nose)
     => ? [FACE] :
          ( p__d__instance(FACE,c__Face)
          & p__part(NOSE,FACE) ) ) ).

fof(miloA1683,axiom,
    p__d__instance(c__secretesSubstance,c__BinaryPredicate) ).

fof(miloA1686,axiom,
    ! [O,S,I1] :
      ( ( p__d__subclass(S,c__NaturalSubstance)
        & p__d__subclass(O,c__OrganicObject)
        & p__d__instance(I1,c__Object)
        & p__secretesSubstance(O,S)
        & p__d__instance(I1,O) )
     => ? [P,I2] :
          ( p__d__instance(P,c__BiologicalProcess)
          & p__eventLocated(P,I1)
          & p__result(P,I2)
          & p__d__instance(I2,S) ) ) ).

fof(miloA1687,axiom,
    p__d__subclass(c__ThyroidGland,c__Gland) ).

fof(miloA1688,axiom,
    p__d__subclass(c__ThyroidHormone,c__Hormone) ).

fof(miloA1689,axiom,
    p__d__subclass(c__PituitaryGland,c__Gland) ).

fof(miloA1690,axiom,
    p__d__subclass(c__HormoneTSH,c__Hormone) ).

fof(miloA1691,axiom,
    ! [HORMONE] :
      ( p__d__instance(HORMONE,c__HormoneTSH)
     => ? [PROC,GLAND] :
          ( p__d__instance(PROC,c__Process)
          & p__d__instance(GLAND,c__ThyroidGland)
          & p__instrument(PROC,GLAND)
          & p__result(PROC,HORMONE) ) ) ).

fof(miloA1692,axiom,
    p__d__subclass(c__Pancreas,c__Gland) ).

fof(miloA1694,axiom,
    p__d__subclass(c__Insulin,c__Hormone) ).

fof(miloA1695,axiom,
    p__d__subclass(c__Arm,c__Limb) ).

fof(miloA1696,axiom,
    ! [ARM] :
      ( p__d__instance(ARM,c__Arm)
     => ? [PRIMATE] :
          ( p__d__instance(PRIMATE,c__Primate)
          & p__part(ARM,PRIMATE) ) ) ).

fof(miloA1697,axiom,
    p__d__subclass(c__Hand,c__AnimalAnatomicalStructure) ).

fof(miloA1698,axiom,
    p__d__subclass(c__Hand,c__BodyPart) ).

fof(miloA1699,axiom,
    ! [HAND] :
      ( p__d__instance(HAND,c__Hand)
     => ? [ARM] :
          ( p__d__instance(ARM,c__Arm)
          & p__part(HAND,ARM) ) ) ).

fof(miloA1700,axiom,
    p__d__subclass(c__DigitAppendage,c__AnimalAnatomicalStructure) ).

fof(miloA1701,axiom,
    p__d__subclass(c__DigitAppendage,c__BodyPart) ).

fof(miloA1702,axiom,
    ! [DIGIT] :
      ( p__d__instance(DIGIT,c__DigitAppendage)
     => ? [LIMB] :
          ( p__d__instance(LIMB,c__Limb)
          & p__part(DIGIT,LIMB) ) ) ).

fof(miloA1703,axiom,
    p__d__subclass(c__Toad,c__Amphibian) ).

fof(miloA1704,axiom,
    ! [A] :
      ( p__d__instance(A,c__Toad)
     => ! [T] :
          ( ~ p__d__instance(T,c__Object)
          | ~ p__d__instance(T,c__Tail)
          | ~ p__part(T,A) ) ) ).

fof(miloA1705,axiom,
    p__initialPart(c__DigitAppendage,c__Limb) ).

fof(miloA1706,axiom,
    p__d__subclass(c__Finger,c__DigitAppendage) ).

fof(miloA1707,axiom,
    ! [FINGER] :
      ( p__d__instance(FINGER,c__Finger)
     => ? [HAND] :
          ( p__d__instance(HAND,c__Hand)
          & p__part(FINGER,HAND) ) ) ).

fof(miloA1708,axiom,
    p__d__subclass(c__Thumb,c__Finger) ).

fof(miloA1709,axiom,
    p__d__subclass(c__NailDigit,c__AnimalAnatomicalStructure) ).

fof(miloA1710,axiom,
    ! [N] :
      ( p__d__instance(N,c__NailDigit)
     => ? [D] :
          ( p__d__instance(D,c__DigitAppendage)
          & p__part(N,D) ) ) ).

fof(miloA1711,axiom,
    p__d__subclass(c__Fingerprint,c__ShapeAttribute) ).

fof(miloA1712,axiom,
    p__d__subclass(c__Fingerprint,c__BiologicalAttribute) ).

fof(miloA1713,axiom,
    ! [P,O] :
      ( ( p__d__instance(O,c__Object)
        & p__attribute(O,P)
        & p__d__instance(P,c__Fingerprint)
        & ~ p__d__instance(O,c__Finger) )
     => ? [PR,F] :
          ( p__d__instance(PR,c__Process)
          & p__instrument(PR,F)
          & p__d__instance(F,c__Finger)
          & p__attribute(F,P)
          & p__patient(PR,O) ) ) ).

fof(miloA1714,axiom,
    p__d__subclass(c__Limb,c__AnimalAnatomicalStructure) ).

fof(miloA1715,axiom,
    p__d__subclass(c__Limb,c__BodyPart) ).

fof(miloA1716,axiom,
    ! [LIMB] :
      ( p__d__instance(LIMB,c__Limb)
     => ? [VERTEBRATE] :
          ( p__d__instance(VERTEBRATE,c__Vertebrate)
          & p__part(LIMB,VERTEBRATE) ) ) ).

fof(miloA1717,axiom,
    p__d__subclass(c__Snake,c__Reptile) ).

fof(miloA1718,axiom,
    ! [SNAKE] :
      ( p__d__instance(SNAKE,c__Snake)
     => ! [LIMB] :
          ( ~ p__d__instance(LIMB,c__Object)
          | ~ p__d__instance(LIMB,c__Limb)
          | ~ p__part(LIMB,SNAKE) ) ) ).

fof(miloA1719,axiom,
    p__d__subclass(c__Rattlesnake,c__Snake) ).

fof(miloA1720,axiom,
    p__d__subclass(c__ConstrictorSnake,c__Snake) ).

fof(miloA1721,axiom,
    p__d__subclass(c__AntInsect,c__Insect) ).

fof(miloA1722,axiom,
    p__d__subclass(c__Anaconda,c__ConstrictorSnake) ).

fof(miloA1723,axiom,
    p__d__subclass(c__Bee,c__Insect) ).

fof(miloA1724,axiom,
    p__d__subclass(c__BumbleBee,c__Bee) ).

fof(miloA1725,axiom,
    p__d__subclass(c__FlyInsect,c__Insect) ).

fof(miloA1726,axiom,
    p__d__subclass(c__Grasshopper,c__Insect) ).

fof(miloA1727,axiom,
    p__d__subclass(c__Moth,c__Insect) ).

fof(miloA1728,axiom,
    p__d__subclass(c__QueenInsect,c__Insect) ).

fof(miloA1729,axiom,
    p__d__disjoint(c__QueenInsect,c__WorkerInsect) ).

fof(miloA1730,axiom,
    ! [INSECT] :
      ( p__d__instance(INSECT,c__QueenInsect)
     => ( p__attribute(INSECT,c__Female)
        & p__capability(c__Replication,c__agent,INSECT) ) ) ).

fof(miloA1731,axiom,
    ! [INSECT] :
      ( p__d__instance(INSECT,c__QueenInsect)
     => ? [GROUP] :
          ( p__d__instance(GROUP,c__Group)
          & p__member(INSECT,GROUP)
          & ! [MEMBER] :
              ( ~ p__d__instance(MEMBER,c__SelfConnectedObject)
              | ~ p__member(MEMBER,GROUP)
              | ~ p__capability(c__Replication,c__agent,MEMBER)
              | MEMBER = INSECT ) ) ) ).

fof(miloA1732,axiom,
    p__d__subclass(c__WorkerInsect,c__Insect) ).

fof(miloA1733,axiom,
    p__d__subclass(c__Leg,c__Limb) ).

fof(miloA1734,axiom,
    ! [LEG] :
      ( p__d__instance(LEG,c__Leg)
     => ? [ANIMAL] :
          ( p__d__instance(ANIMAL,c__Animal)
          & p__part(LEG,ANIMAL) ) ) ).

fof(miloA1735,axiom,
    p__d__subclass(c__Foot,c__AnimalAnatomicalStructure) ).

fof(miloA1736,axiom,
    p__d__subclass(c__Foot,c__BodyPart) ).

fof(miloA1737,axiom,
    ! [FOOT] :
      ( p__d__instance(FOOT,c__Foot)
     => ? [LIMB] :
          ( p__d__instance(LIMB,c__Leg)
          & p__part(FOOT,LIMB) ) ) ).

fof(miloA1738,axiom,
    p__d__subclass(c__Ankle,c__BodyJoint) ).

fof(miloA1739,axiom,
    ! [A] :
      ( p__d__instance(A,c__Ankle)
     => ? [L] :
          ( p__d__instance(L,c__Leg)
          & p__part(A,L) ) ) ).

fof(miloA1740,axiom,
    p__d__subclass(c__Elbow,c__BodyJoint) ).

fof(miloA1741,axiom,
    ! [E] :
      ( p__d__instance(E,c__Elbow)
     => ? [A] :
          ( p__d__instance(A,c__Arm)
          & p__part(E,A) ) ) ).

fof(miloA1742,axiom,
    p__d__subclass(c__Wrist,c__BodyJoint) ).

fof(miloA1743,axiom,
    ! [W] :
      ( p__d__instance(W,c__Wrist)
     => ? [A] :
          ( p__d__instance(A,c__Arm)
          & p__part(W,A) ) ) ).

fof(miloA1744,axiom,
    p__d__subclass(c__Toe,c__AnimalAnatomicalStructure) ).

fof(miloA1745,axiom,
    p__d__subclass(c__Toe,c__BodyPart) ).

fof(miloA1746,axiom,
    p__d__subclass(c__Toe,c__DigitAppendage) ).

fof(miloA1747,axiom,
    ! [TOE] :
      ( p__d__instance(TOE,c__Toe)
     => ? [FOOT] :
          ( p__d__instance(FOOT,c__Foot)
          & p__part(TOE,FOOT) ) ) ).

fof(miloA1748,axiom,
    p__d__subclass(c__Knee,c__BodyJoint) ).

fof(miloA1749,axiom,
    ! [KNEE] :
      ( p__d__instance(KNEE,c__Knee)
     => ? [LEG] :
          ( p__d__instance(LEG,c__Leg)
          & p__part(KNEE,LEG) ) ) ).

fof(miloA1750,axiom,
    p__d__subclass(c__Shoulder,c__AnimalAnatomicalStructure) ).

fof(miloA1751,axiom,
    p__d__subclass(c__Shoulder,c__BodyPart) ).

fof(miloA1752,axiom,
    ! [SHOULDER] :
      ( p__d__instance(SHOULDER,c__Shoulder)
     => ? [PRIMATE] :
          ( p__d__instance(PRIMATE,c__Primate)
          & p__part(SHOULDER,PRIMATE) ) ) ).

fof(miloA1753,axiom,
    p__d__subclass(c__Knuckle,c__BodyJoint) ).

fof(miloA1754,axiom,
    ! [KNUCKLE] :
      ( p__d__instance(KNUCKLE,c__Knuckle)
     => ? [FINGER] :
          ( p__d__instance(FINGER,c__Finger)
          & p__part(KNUCKLE,FINGER) ) ) ).

fof(miloA1755,axiom,
    p__d__subclass(c__Torso,c__AnimalAnatomicalStructure) ).

fof(miloA1756,axiom,
    p__d__subclass(c__Torso,c__BodyPart) ).

fof(miloA1757,axiom,
    ! [TORSO,LIMB] :
      ( ( p__d__instance(TORSO,c__Torso)
        & p__d__instance(LIMB,c__Limb) )
     => ~ p__overlapsSpatially(TORSO,LIMB) ) ).

fof(miloA1758,axiom,
    p__d__subclass(c__Breast,c__AnimalAnatomicalStructure) ).

fof(miloA1759,axiom,
    p__d__subclass(c__Breast,c__Organ) ).

fof(miloA1760,axiom,
    ! [B] :
      ( p__d__instance(B,c__Breast)
     => ? [T] :
          ( p__d__instance(T,c__Torso)
          & p__part(B,f__FrontFn1(T)) ) ) ).

fof(miloA1761,axiom,
    ! [B] :
      ( p__d__instance(B,c__Breast)
     => ? [P] :
          ( p__d__instance(P,c__Primate)
          & p__part(B,P) ) ) ).

fof(miloA1762,axiom,
    p__d__subclass(c__Head,c__AnimalAnatomicalStructure) ).

fof(miloA1763,axiom,
    p__d__subclass(c__Head,c__BodyPart) ).

fof(miloA1764,axiom,
    p__d__subclass(c__Neck,c__AnimalAnatomicalStructure) ).

fof(miloA1765,axiom,
    p__d__subclass(c__Neck,c__BodyPart) ).

fof(miloA1766,axiom,
    ! [NECK] :
      ( p__d__instance(NECK,c__Neck)
     => ? [HEAD] :
          ( p__d__instance(HEAD,c__Head)
          & p__connected(NECK,HEAD) ) ) ).

fof(miloA1767,axiom,
    p__d__subclass(c__Face,c__AnimalAnatomicalStructure) ).

fof(miloA1768,axiom,
    p__d__subclass(c__Face,c__BodyPart) ).

fof(miloA1769,axiom,
    ! [FACE] :
      ( p__d__instance(FACE,c__Face)
     => ? [HEAD] :
          ( p__d__instance(HEAD,c__Head)
          & p__part(FACE,HEAD) ) ) ).

fof(miloA1770,axiom,
    ! [FACE] :
      ( p__d__instance(FACE,c__Face)
     => ? [VERTEBRATE] :
          ( p__d__instance(VERTEBRATE,c__Vertebrate)
          & p__part(FACE,VERTEBRATE) ) ) ).

fof(miloA1771,axiom,
    p__d__subclass(c__Chin,c__AnimalAnatomicalStructure) ).

fof(miloA1772,axiom,
    p__d__subclass(c__Chin,c__BodyPart) ).

fof(miloA1773,axiom,
    ! [CHIN] :
      ( p__d__instance(CHIN,c__Chin)
     => ? [FACE] :
          ( p__d__instance(FACE,c__Face)
          & p__part(CHIN,FACE) ) ) ).

fof(miloA1774,axiom,
    ! [FACE,CHIN,PART] :
      ( ( p__d__instance(FACE,c__Object)
        & p__d__instance(PART,c__Object)
        & p__d__instance(CHIN,c__Chin)
        & p__part(PART,FACE)
        & ~ p__part(PART,CHIN) )
     => p__orientation(PART,CHIN,c__Below) ) ).

fof(miloA1776,axiom,
    p__d__disjointDecomposition3(c__Expressing,c__ExpressingApproval,c__ExpressingDisapproval) ).

fof(miloA1777,axiom,
    p__d__subclass(c__ExpressingApproval,c__Expressing) ).

fof(miloA1778,axiom,
    ! [EXPRESS,AGENT,THING] :
      ( ( p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(THING,c__Formula)
        & p__d__instance(EXPRESS,c__ExpressingApproval)
        & p__agent(EXPRESS,AGENT)
        & p__patient(EXPRESS,THING) )
     => ( p__wants(AGENT,THING)
        | p__desires(AGENT,THING) ) ) ).

fof(miloA1779,axiom,
    p__d__subclass(c__ExpressingDisapproval,c__Expressing) ).

fof(miloA1780,axiom,
    ! [EXPRESS,AGENT,THING] :
      ( ( p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(THING,c__Object)
        & p__d__instance(THING,c__Formula)
        & p__d__instance(EXPRESS,c__ExpressingDisapproval)
        & p__agent(EXPRESS,AGENT)
        & p__patient(EXPRESS,THING) )
     => ( p__dislikes(AGENT,THING)
        | p__disapproves(AGENT,THING) ) ) ).

fof(miloA1781,axiom,
    p__d__subclass(c__Regretting,c__ExpressingDisapproval) ).

fof(miloA1782,axiom,
    ! [R,T] :
      ( ( p__d__instance(R,c__Regretting)
        & p__patient(R,T)
        & p__d__instance(T,c__Sentence) )
     => p__truth(T,c__True) ) ).

fof(miloA1783,axiom,
    p__d__subclass(c__ExpressingFarewell,c__Expressing) ).

fof(miloA1784,axiom,
    p__d__subclass(c__Congratulating,c__ExpressingApproval) ).

fof(miloA1785,axiom,
    ! [C] :
      ( p__d__instance(C,c__Congratulating)
     => ? [P,A,D] :
          ( p__d__instance(D,c__Agent)
          & p__d__instance(P,c__Process)
          & p__d__instance(A,c__CognitiveAgent)
          & p__destination(C,D)
          & p__agent(P,D)
          & p__agent(C,A)
          & p__wants(A,P)
          & p__refers(C,P) ) ) ).

fof(miloA1786,axiom,
    p__d__subclass(c__FacialExpression,c__Gesture) ).

fof(miloA1787,axiom,
    ! [AGENT,EXPRESS] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(EXPRESS,c__FacialExpression)
        & p__agent(EXPRESS,AGENT) )
     => ? [FACE] :
          ( p__part(FACE,AGENT)
          & p__d__instance(FACE,c__Face)
          & p__instrument(EXPRESS,FACE) ) ) ).

fof(miloA1788,axiom,
    p__d__subclass(c__Smiling,c__FacialExpression) ).

fof(miloA1790,axiom,
    p__d__subclass(c__Frowning,c__FacialExpression) ).

fof(miloA1792,axiom,
    p__d__subclass(c__Laughing,c__Vocalizing) ).

fof(miloA1793,axiom,
    p__d__subclass(c__Laughing,c__FacialExpression) ).

fof(miloA1794,axiom,
    ! [LAUGH] :
      ( p__d__instance(LAUGH,c__Laughing)
     => ? [SMILE] :
          ( p__d__instance(SMILE,c__Smiling)
          & p__subProcess(SMILE,LAUGH) ) ) ).

fof(miloA1795,axiom,
    p__d__subclass(c__Weeping,c__FacialExpression) ).

fof(miloA1797,axiom,
    p__d__subclass(c__Nodding,c__Gesture) ).

fof(miloA1798,axiom,
    ! [NOD,HEAD] :
      ( ( p__d__instance(NOD,c__Nodding)
        & p__patient(NOD,HEAD) )
     => p__d__instance(HEAD,c__Head) ) ).

fof(miloA1799,axiom,
    p__d__subclass(c__HandGesture,c__Gesture) ).

fof(miloA1800,axiom,
    ! [HG] :
      ( p__d__instance(HG,c__HandGesture)
     => ? [H] :
          ( p__d__instance(H,c__Hand)
          & p__patient(HG,H) ) ) ).

fof(miloA1801,axiom,
    p__d__subclass(c__Waving,c__HandGesture) ).

fof(miloA1802,axiom,
    ! [WAVE,HAND] :
      ( ( p__d__instance(WAVE,c__Waving)
        & p__patient(WAVE,HAND) )
     => p__d__instance(HAND,c__Hand) ) ).

fof(miloA1803,axiom,
    p__d__subclass(c__Clapping,c__HandGesture) ).

fof(miloA1804,axiom,
    p__d__subclass(c__Clapping,c__RadiatingSound) ).

fof(miloA1805,axiom,
    p__d__subclass(c__Clapping,c__Impacting) ).

fof(miloA1806,axiom,
    p__d__subclass(c__Inclining,c__BodyMotion) ).

fof(miloA1807,axiom,
    p__d__subclass(c__Inclining,c__MotionDownward) ).

fof(miloA1808,axiom,
    p__d__subclass(c__Bowing,c__Gesture) ).

fof(miloA1809,axiom,
    p__d__subclass(c__Bowing,c__Inclining) ).

fof(miloA1810,axiom,
    p__d__subclass(c__Bowing,c__MotionDownward) ).

fof(miloA1811,axiom,
    p__d__subclass(c__Sinking,c__Falling) ).

fof(miloA1812,axiom,
    ! [S] :
      ( p__d__instance(S,c__Sinking)
     => ? [W] :
          ( p__d__instance(W,c__WaterArea)
          & p__eventLocated(S,W) ) ) ).

fof(miloA1813,axiom,
    p__d__subclass(c__Ducking,c__IntentionalProcess) ).

fof(miloA1814,axiom,
    p__d__subclass(c__Ducking,c__BodyMotion) ).

fof(miloA1815,axiom,
    p__d__subclass(c__Ducking,c__MotionDownward) ).

fof(miloA1817,axiom,
    p__d__subclass(c__ExpressingInLanguage,c__Expressing) ).

fof(miloA1818,axiom,
    p__d__subclass(c__ExpressingInLanguage,c__LinguisticCommunication) ).

fof(miloA1819,axiom,
    p__d__subclass(c__TonalLanguage,c__SpokenHumanLanguage) ).

fof(miloA1820,axiom,
    p__d__subclass(c__Thanking,c__ExpressingInLanguage) ).

fof(miloA1821,axiom,
    p__d__subclass(c__Thanking,c__ExpressingApproval) ).

fof(miloA1823,axiom,
    ! [T,P] :
      ( ( p__d__instance(T,c__Thanking)
        & p__destination(T,P) )
     => p__d__instance(P,c__Human) ) ).

fof(miloA1824,axiom,
    p__d__subclass(c__Greeting,c__Expressing) ).

fof(miloA1825,axiom,
    p__subrelation(c__half,c__part) ).

fof(miloA1826,axiom,
    ! [WHOLE,HALF] :
      ( ( p__d__instance(WHOLE,c__Object)
        & p__d__instance(HALF,c__Object)
        & p__half(HALF,WHOLE) )
     => ? [OTHER] :
          ( p__d__instance(OTHER,c__Object)
          & p__half(OTHER,WHOLE)
          & OTHER != HALF
          & WHOLE = f__MereologicalSumFn2(HALF,OTHER) ) ) ).

fof(miloA1827,axiom,
    p__subrelation(c__third,c__part) ).

fof(miloA1828,axiom,
    ! [W,T] :
      ( ( p__d__instance(W,c__Object)
        & p__d__instance(T,c__Object)
        & p__third(T,W) )
     => ? [O1,O2] :
          ( p__d__instance(O1,c__Object)
          & p__d__instance(O2,c__Object)
          & p__third(O1,W)
          & p__third(O2,W)
          & O1 != T
          & O2 != T
          & O1 != O2
          & W = f__MereologicalSumFn2(T,f__MereologicalSumFn2(O1,O2)) ) ) ).

fof(miloA1829,axiom,
    p__subrelation(c__quarter,c__part) ).

fof(miloA1830,axiom,
    ! [W,Q] :
      ( ( p__d__instance(W,c__Object)
        & p__d__instance(Q,c__Object) )
     => ( p__quarter(Q,W)
      <=> ? [H] :
            ( p__d__instance(H,c__Object)
            & p__half(H,W)
            & p__half(Q,H) ) ) ) ).

fof(miloA1831,axiom,
    p__subrelation(c__most,c__part) ).

fof(miloA1832,axiom,
    ! [WHOLE,MOST] :
      ( ( p__d__instance(WHOLE,c__Object)
        & p__d__instance(MOST,c__Object)
        & p__most(MOST,WHOLE) )
     => ? [HALF,NUMBER1,NUMBER2,UNIT] :
          ( p__d__instance(HALF,c__Object)
          & p__d__instance(UNIT,c__UnitOfMeasure)
          & p__d__instance(NUMBER1,c__RealNumber)
          & p__d__instance(NUMBER2,c__RealNumber)
          & p__half(HALF,WHOLE)
          & p__measure(HALF,f__MeasureFn2(NUMBER1,UNIT))
          & p__measure(MOST,f__MeasureFn2(NUMBER2,UNIT))
          & p__greaterThan(NUMBER2,NUMBER1) ) ) ).

fof(miloA1833,axiom,
    p__d__subclass(c__Blueprint,c__Icon) ).

fof(miloA1835,axiom,
    p__d__subclass(c__Chart,c__Icon) ).

fof(miloA1836,axiom,
    ! [CHART] :
      ( p__d__instance(CHART,c__Chart)
     => ? [QUANTITY] :
          ( p__d__instance(QUANTITY,c__PhysicalQuantity)
          & p__refers(CHART,QUANTITY) ) ) ).

fof(miloA1837,axiom,
    p__d__subclass(c__Flag,c__Icon) ).

fof(miloA1838,axiom,
    ! [FLAG] :
      ( ( p__d__instance(FLAG,c__Object)
        & p__d__instance(FLAG,c__Flag) )
     => ? [FABRIC] :
          ( p__d__instance(FABRIC,c__Fabric)
          & p__part(FABRIC,FLAG) ) ) ).

fof(miloA1839,axiom,
    p__d__subclass(c__NationalFlag,c__Flag) ).

fof(miloA1840,axiom,
    ! [F] :
      ( p__d__instance(F,c__NationalFlag)
     => ? [N] :
          ( p__d__instance(N,c__Nation)
          & p__refers(F,N) ) ) ).

fof(miloA1841,axiom,
    p__d__subclass(c__GraphDiagram,c__Icon) ).

fof(miloA1842,axiom,
    ! [G] :
      ( p__d__instance(G,c__GraphDiagram)
     => ? [Q] :
          ( p__d__instance(Q,c__PhysicalQuantity)
          & p__refers(G,Q) ) ) ).

fof(miloA1843,axiom,
    p__d__subclass(c__ArrowIcon,c__Icon) ).

fof(miloA1844,axiom,
    p__d__subclass(c__Map,c__Icon) ).

fof(miloA1845,axiom,
    ! [M] :
      ( p__d__instance(M,c__Map)
     => ? [A] :
          ( p__d__instance(A,c__GeographicArea)
          & p__represents(M,A) ) ) ).

fof(miloA1846,axiom,
    p__d__subclass(c__Photograph,c__Image) ).

fof(miloA1847,axiom,
    p__d__subclass(c__Photograph,c__Recording) ).

fof(miloA1848,axiom,
    p__d__subclass(c__Photographing,c__ContentDevelopment) ).

fof(miloA1849,axiom,
    ! [SHOOT] :
      ( p__d__instance(SHOOT,c__Photographing)
     => ? [PHOTO,CAMERA] :
          ( p__d__instance(PHOTO,c__Photograph)
          & p__result(SHOOT,PHOTO)
          & p__instrument(SHOOT,CAMERA)
          & p__d__instance(CAMERA,c__Camera) ) ) ).

fof(miloA1850,axiom,
    p__d__subclass(c__Camera,c__Device) ).

fof(miloA1851,axiom,
    ! [CAMERA] :
      ( p__d__instance(CAMERA,c__Camera)
     => p__capability(c__Photographing,c__instrument,CAMERA) ) ).

fof(miloA1852,axiom,
    p__d__instance(c__TonMass,c__UnitOfMass) ).

fof(miloA1853,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__TonMass) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__2000),c__PoundMass) ) ).

fof(miloA1854,axiom,
    p__d__instance(c__MetricTon,c__UnitOfMass) ).

fof(miloA1855,axiom,
    f__MeasureFn2(c__1,c__MetricTon) = f__MeasureFn2(c__2205,c__PoundMass) ).

fof(miloA1857,axiom,
    p__d__instance(c__LongTon,c__UnitOfMass) ).

fof(miloA1858,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__LongTon) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__2240),c__PoundMass) ) ).

fof(miloA1859,axiom,
    p__d__instance(c__CubicFoot,c__UnitOfVolume) ).

fof(miloA1860,axiom,
    f__MeasureFn2(c__1,c__CubicFoot) = f__MultiplicationFn2(f__MeasureFn2(c__1,c__FootLength),f__MultiplicationFn2(f__MeasureFn2(c__1,c__FootLength),f__MeasureFn2(c__1,c__FootLength))) ).

fof(miloA1861,axiom,
    ! [N1,N2,N3,QUANT,N4] :
      ( ( p__d__instance(N3,c__RealNumber)
        & p__d__instance(N2,c__RealNumber)
        & p__d__instance(N1,c__RealNumber)
        & p__d__instance(N4,c__RealNumber)
        & p__d__instance(QUANT,c__PhysicalQuantity)
        & N4 = f__MultiplicationFn2(N1,f__MultiplicationFn2(N2,N3))
        & QUANT = f__MultiplicationFn2(f__MeasureFn2(N1,c__FootLength),f__MultiplicationFn2(f__MeasureFn2(N2,c__FootLength),f__MeasureFn2(N3,c__FootLength))) )
     => QUANT = f__MeasureFn2(N4,c__CubicFoot) ) ).

fof(miloA1862,axiom,
    p__d__instance(c__RegistryTon,c__UnitOfVolume) ).

fof(miloA1863,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__RegistryTon) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__100),c__CubicFoot) ) ).

fof(miloA1864,axiom,
    p__d__instance(c__Page,c__UnitOfInformation) ).

fof(miloA1865,axiom,
    p__d__instance(c__LiquorShot,c__UnitOfVolume) ).

fof(miloA1866,axiom,
    p__d__instance(c__MillenniumDuration,c__UnitOfDuration) ).

fof(miloA1867,axiom,
    ! [N] :
      ( ( p__d__instance(N,c__RealNumber)
        & N = f__MultiplicationFn2(c__1,N) )
     => f__MeasureFn2(N,c__MillenniumDuration) = f__MeasureFn2(f__MultiplicationFn2(N,c__1000),c__YearDuration) ) ).

fof(miloA1868,axiom,
    p__d__instance(c__Acre,c__UnitOfArea) ).

fof(miloA1869,axiom,
    p__d__instance(c__SquareMile,c__UnitOfArea) ).

fof(miloA1870,axiom,
    f__MeasureFn2(c__1,c__SquareMile) = f__PerFn2(f__MeasureFn2(c__1,c__Mile),f__MeasureFn2(c__1,c__Mile)) ).

fof(miloA1871,axiom,
    p__d__instance(c__SquareYard,c__UnitOfArea) ).

fof(miloA1872,axiom,
    f__MeasureFn2(c__1,c__SquareYard) = f__PerFn2(f__MeasureFn2(c__1,c__YardLength),f__MeasureFn2(c__1,c__YardLength)) ).

fof(miloA1873,axiom,
    p__d__instance(c__creator,c__BinaryPredicate) ).

fof(miloA1876,axiom,
    ! [AGENT,ENTITY] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__creator(AGENT,ENTITY) )
     => ? [CREATION] :
          ( p__d__instance(CREATION,c__Creation)
          & p__agent(CREATION,AGENT)
          & p__result(CREATION,ENTITY) ) ) ).

fof(miloA1877,axiom,
    p__d__subclass(c__Music,c__Proposition) ).

fof(miloA1878,axiom,
    ! [MC,MUSIC] :
      ( ( p__d__instance(MUSIC,c__Process)
        & p__d__instance(MC,c__Music)
        & p__realization(MUSIC,MC) )
     => p__d__instance(MUSIC,c__MakingMusic) ) ).

fof(miloA1879,axiom,
    p__d__subclass(c__MusicalComposition,c__Music) ).

fof(miloA1880,axiom,
    p__d__subclass(c__Song,c__Music) ).

fof(miloA1881,axiom,
    p__d__subclass(c__LyricalContent,c__Proposition) ).

fof(miloA1883,axiom,
    ! [L] :
      ( p__d__instance(L,c__LyricalContent)
     => ? [W,I] :
          ( p__d__instance(I,c__Proposition)
          & p__d__instance(W,c__Word)
          & p__containsInformation(W,I)
          & p__subProposition(I,L) ) ) ).

fof(miloA1884,axiom,
    p__d__instance(c__LegislativeBill,c__DeonticAttribute) ).

fof(miloA1886,axiom,
    p__d__subclass(c__PassingABill,c__PoliticalProcess) ).

fof(miloA1887,axiom,
    p__d__subclass(c__PassingABill,c__Declaring) ).

fof(miloA1889,axiom,
    p__subAttribute(c__InternationalLaw,c__Law) ).

fof(miloA1890,axiom,
    p__subAttribute(c__Illegal,c__Prohibition) ).

fof(miloA1891,axiom,
    p__contraryAttribute2(c__Illegal,c__Legal) ).

fof(miloA1892,axiom,
    p__subAttribute(c__Legal,c__Permission) ).

fof(miloA1893,axiom,
    p__d__subclass(c__CriminalAction,c__IntentionalProcess) ).

fof(miloA1894,axiom,
    ! [ACTION] :
      ( p__d__instance(ACTION,c__CriminalAction)
     => ? [LAW,CONTENT,CRIME] :
          ( p__d__instance(LAW,c__Formula)
          & p__d__instance(CONTENT,c__Proposition)
          & p__d__instance(CRIME,c__Proposition)
          & p__modalAttribute(LAW,c__Law)
          & p__containsInformation(LAW,CONTENT)
          & p__realization(ACTION,CRIME)
          & ~ p__consistent(CONTENT,CRIME) ) ) ).

fof(miloA1895,axiom,
    p__d__subclass(c__PoliticalCrime,c__CriminalAction) ).

fof(miloA1896,axiom,
    p__d__subclass(c__PoliticalCrime,c__PoliticalProcess) ).

fof(miloA1897,axiom,
    p__d__subclass(c__PoliticalRevolution,c__PoliticalProcess) ).

fof(miloA1898,axiom,
    p__d__subclass(c__PoliticalRevolution,c__ViolentContest) ).

fof(miloA1899,axiom,
    ! [R,A] :
      ( ( p__d__instance(R,c__PoliticalRevolution)
        & p__patient(R,A) )
     => p__d__instance(A,c__GeopoliticalArea) ) ).

fof(miloA1901,axiom,
    p__d__subclass(c__LawEnforcement,c__PoliticalProcess) ).

fof(miloA1902,axiom,
    p__d__subclass(c__LawEnforcement,c__RegulatoryProcess) ).

fof(miloA1903,axiom,
    ! [L,AGENT,P] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(P,c__SelfConnectedObject)
        & p__d__instance(L,c__LawEnforcement)
        & p__agent(L,AGENT) )
     => ( p__d__instance(P,c__PoliceOrganization)
        | ? [O] :
            ( p__d__instance(O,c__PoliceOrganization)
            & p__member(P,O) ) ) ) ).

fof(miloA1904,axiom,
    p__d__subclass(c__Imprisoning,c__Confining) ).

fof(miloA1905,axiom,
    ! [I] :
      ( p__d__instance(I,c__Imprisoning)
     => ? [P] :
          ( p__d__instance(P,c__Prison)
          & p__eventLocated(I,P) ) ) ).

fof(miloA1906,axiom,
    p__d__subclass(c__Espionage,c__PoliticalProcess) ).

fof(miloA1907,axiom,
    p__d__subclass(c__Espionage,c__Investigating) ).

fof(miloA1908,axiom,
    ! [S] :
      ( p__d__instance(S,c__Espionage)
     => ? [GOV1,GOV2] :
          ( p__d__instance(GOV1,c__Government)
          & p__d__instance(GOV2,c__Government)
          & p__agent(S,GOV1)
          & p__patient(S,GOV2)
          & GOV1 != GOV2 ) ) ).

fof(miloA1909,axiom,
    p__d__subclass(c__Polling,c__Investigating) ).

fof(miloA1910,axiom,
    p__d__subclass(c__MilitaryInfiltration,c__MilitaryProcess) ).

fof(miloA1911,axiom,
    p__d__subclass(c__MilitaryInfiltration,c__Translocation) ).

fof(miloA1912,axiom,
    p__d__subclass(c__Agreement,c__Proposition) ).

fof(miloA1913,axiom,
    ! [COMPACT] :
      ( p__d__instance(COMPACT,c__Agreement)
     => ? [COMM] :
          ( p__d__instance(COMM,c__Committing)
          & p__represents(COMM,COMPACT) ) ) ).

fof(miloA1914,axiom,
    ! [AGREEMENT] :
      ( p__d__instance(AGREEMENT,c__Agreement)
     => ? [AGENT1,AGENT2] :
          ( p__d__instance(AGENT1,c__CognitiveAgent)
          & p__d__instance(AGENT2,c__CognitiveAgent)
          & p__partyToAgreement(AGENT1,AGREEMENT)
          & p__partyToAgreement(AGENT2,AGREEMENT)
          & AGENT1 != AGENT2 ) ) ).

fof(miloA1915,axiom,
    p__d__instance(c__partyToAgreement,c__BinaryPredicate) ).

fof(miloA1918,axiom,
    ! [AGENT,CONTENT] :
      ( ( p__d__instance(CONTENT,c__Agreement)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__partyToAgreement(AGENT,CONTENT) )
     => ? [C] :
          ( p__d__instance(C,c__Committing)
          & p__agent(C,AGENT)
          & p__patient(C,CONTENT) ) ) ).

fof(miloA1919,axiom,
    p__d__instance(c__agreementPeriod,c__BinaryPredicate) ).

fof(miloA1923,axiom,
    p__d__instance(c__agreementEffectiveDate,c__BinaryPredicate) ).

fof(miloA1926,axiom,
    p__d__instance(c__TimePeriodFn,c__BinaryFunction) ).

fof(miloA1930,axiom,
    ! [T2,INTERVAL,T1,PERIOD] :
      ( ( p__d__instance(INTERVAL,c__TimeInterval)
        & p__d__instance(PERIOD,c__TimeDuration)
        & p__d__instance(T1,c__TimePoint)
        & p__d__instance(T2,c__TimePoint)
        & INTERVAL = f__TimeIntervalFn2(T1,T2)
        & p__duration(INTERVAL,PERIOD) )
     => INTERVAL = f__TimePeriodFn2(T1,PERIOD) ) ).

fof(miloA1931,axiom,
    p__d__instance(c__agreementExpirationDate,c__BinaryPredicate) ).

fof(miloA1935,axiom,
    p__d__instance(c__agreementClause,c__QuaternaryPredicate) ).

fof(miloA1940,axiom,
    ! [ATTR,PROP,AGENT,AGREEMENT] :
      ( ( p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(AGREEMENT,c__Agreement)
        & p__d__instance(ATTR,c__DeonticAttribute)
        & p__d__instance(PROP,c__Proposition)
        & p__agreementClause(PROP,ATTR,AGREEMENT,AGENT) )
     => ( ? [CLAUSE] :
            ( p__d__instance(CLAUSE,c__ContentBearingPhysical)
            & p__containsInformation(CLAUSE,PROP) )
        & p__partyToAgreement(AGENT,AGREEMENT) ) ) ).

fof(miloA1944,axiom,
    p__d__instance(c__ActiveAgreement,c__RelationalAttribute) ).

fof(miloA1945,axiom,
    ! [AGREEMENT] :
      ( p__property(AGREEMENT,c__ActiveAgreement)
     => p__d__instance(AGREEMENT,c__Agreement) ) ).

fof(miloA1947,axiom,
    ! [ENTITY] :
      ( p__property(ENTITY,c__Promise)
     => ( p__property(ENTITY,c__Contract)
        | p__property(ENTITY,c__NakedPromise) ) ) ).

fof(miloA1948,axiom,
    p__subAttribute(c__NakedPromise,c__Promise) ).

fof(miloA1949,axiom,
    p__subAttribute(c__Contract,c__ActiveAgreement) ).

fof(miloA1950,axiom,
    p__subAttribute(c__Contract,c__Promise) ).

fof(miloA1951,axiom,
    p__contraryAttribute2(c__NakedPromise,c__Contract) ).

fof(miloA1953,axiom,
    p__subAttribute(c__MarriageContract,c__Contract) ).

fof(miloA1954,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__Agreement)
        & p__property(C,c__MarriageContract) )
     => ? [P1,P2] :
          ( p__d__instance(P1,c__Human)
          & p__d__instance(P2,c__Human)
          & p__partyToAgreement(P1,C)
          & p__partyToAgreement(P2,C)
          & p__spouse(P1,P2) ) ) ).

fof(miloA1955,axiom,
    p__subAttribute(c__PurchaseContract,c__Contract) ).

fof(miloA1956,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__Agreement)
        & p__property(C,c__PurchaseContract) )
     => ? [S,SELLER,BUYER] :
          ( p__d__instance(SELLER,c__CognitiveAgent)
          & p__d__instance(BUYER,c__CognitiveAgent)
          & p__d__instance(S,c__Selling)
          & p__origin(S,SELLER)
          & p__destination(S,BUYER)
          & p__realization(S,C)
          & p__partyToAgreement(SELLER,C)
          & p__partyToAgreement(BUYER,C) ) ) ).

fof(miloA1957,axiom,
    p__subAttribute(c__ServiceContract,c__Contract) ).

fof(miloA1958,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__Agreement)
        & p__property(C,c__ServiceContract) )
     => ? [SP,SERVICE,CUST] :
          ( p__d__instance(SERVICE,c__CognitiveAgent)
          & p__d__instance(CUST,c__CognitiveAgent)
          & p__d__instance(SP,c__ServiceProcess)
          & p__realization(SP,C)
          & p__serviceProvider(SP,SERVICE)
          & p__serviceRecipient(SP,CUST)
          & p__partyToAgreement(SERVICE,C)
          & p__partyToAgreement(CUST,C) ) ) ).

fof(miloA1959,axiom,
    p__subAttribute(c__Warranty,c__ServiceContract) ).

fof(miloA1960,axiom,
    p__subAttribute(c__Treaty,c__Contract) ).

fof(miloA1961,axiom,
    ! [T] :
      ( ( p__d__instance(T,c__Agreement)
        & p__property(T,c__Treaty) )
     => ? [N1,N2] :
          ( p__d__instance(N1,c__CognitiveAgent)
          & p__d__instance(N2,c__CognitiveAgent)
          & p__partyToAgreement(N1,T)
          & p__partyToAgreement(N2,T)
          & p__d__instance(N1,c__Nation)
          & p__d__instance(N2,c__Nation)
          & N1 != N2 ) ) ).

fof(miloA1962,axiom,
    p__d__disjointDecomposition6(c__Sentence,c__Statement,c__Supposition,c__Question,c__Request,c__Order) ).

fof(miloA1963,axiom,
    p__d__subclass(c__Statement,c__Sentence) ).

fof(miloA1964,axiom,
    ! [STATE,SENTENCE] :
      ( ( p__d__instance(STATE,c__Stating)
        & p__result(STATE,SENTENCE)
        & p__d__instance(SENTENCE,c__Sentence) )
     => p__d__instance(SENTENCE,c__Statement) ) ).

fof(miloA1965,axiom,
    p__d__subclass(c__Fact,c__Statement) ).

fof(miloA1966,axiom,
    ! [FACT] :
      ( p__d__instance(FACT,c__Fact)
     => p__truth(FACT,c__True) ) ).

fof(miloA1967,axiom,
    p__d__subclass(c__Question,c__Sentence) ).

fof(miloA1968,axiom,
    ! [QUESTION,SENTENCE] :
      ( ( p__d__instance(QUESTION,c__Questioning)
        & p__result(QUESTION,SENTENCE)
        & p__d__instance(SENTENCE,c__Sentence) )
     => p__d__instance(SENTENCE,c__Question) ) ).

fof(miloA1969,axiom,
    p__d__subclass(c__Supposition,c__Sentence) ).

fof(miloA1970,axiom,
    ! [SUPPOSE,SENTENCE] :
      ( ( p__d__instance(SUPPOSE,c__Supposing)
        & p__result(SUPPOSE,SENTENCE)
        & p__d__instance(SENTENCE,c__Sentence) )
     => p__d__instance(SENTENCE,c__Supposition) ) ).

fof(miloA1971,axiom,
    p__d__subclass(c__Request,c__Sentence) ).

fof(miloA1972,axiom,
    ! [REQUEST,SENTENCE] :
      ( ( p__d__instance(REQUEST,c__Requesting)
        & p__result(REQUEST,SENTENCE)
        & p__d__instance(SENTENCE,c__Sentence) )
     => p__d__instance(SENTENCE,c__Request) ) ).

fof(miloA1973,axiom,
    p__d__subclass(c__Order,c__Sentence) ).

fof(miloA1974,axiom,
    ! [ORDER,SENTENCE] :
      ( ( p__d__instance(ORDER,c__Ordering)
        & p__result(ORDER,SENTENCE)
        & p__d__instance(SENTENCE,c__Sentence) )
     => p__d__instance(SENTENCE,c__Order) ) ).

fof(miloA1975,axiom,
    p__d__subclass(c__AudioRecording,c__Recording) ).

fof(miloA1976,axiom,
    ! [X] :
      ( p__d__instance(X,c__AudioRecording)
     => ? [EV] :
          ( p__d__instance(EV,c__RadiatingSound)
          & p__represents(X,EV)
          & p__capability(c__RadiatingSound,c__patient,X) ) ) ).

fof(miloA1977,axiom,
    ! [RECORD] :
      ( p__d__instance(RECORD,c__AudioRecording)
     => ? [INFO,SOUND] :
          ( p__d__instance(INFO,c__Proposition)
          & p__containsInformation(RECORD,INFO)
          & p__realization(SOUND,INFO)
          & p__d__instance(SOUND,c__RadiatingSound) ) ) ).

fof(miloA1978,axiom,
    p__subrelation(c__record,c__represents) ).

fof(miloA1981,axiom,
    ! [REC,PHYS] :
      ( ( p__d__instance(PHYS,c__ContentBearingPhysical)
        & p__d__instance(REC,c__ContentBearingObject)
        & p__record(REC,PHYS) )
     => p__equivalentContentInstance(REC,PHYS) ) ).

fof(miloA1982,axiom,
    ! [PHYS,REC] :
      ( ( p__d__instance(PHYS,c__Physical)
        & p__d__instance(REC,c__ContentBearingObject)
        & p__record(REC,PHYS) )
     => ? [DS] :
          ( p__d__instance(DS,c__DataStorageDevice)
          & p__stored(REC,DS) ) ) ).

fof(miloA1983,axiom,
    p__d__instance(c__stored,c__BinaryPredicate) ).

fof(miloA1984,axiom,
    p__d__instance(c__stored,c__AntisymmetricRelation) ).

fof(miloA1985,axiom,
    p__d__instance(c__stored,c__TransitiveRelation) ).

fof(miloA1988,axiom,
    ! [D,O] :
      ( ( p__d__instance(D,c__DataStorageDevice)
        & p__d__instance(O,c__ContentBearingObject)
        & p__stored(O,D) )
     => ? [P] :
          ( p__d__instance(P,c__Writing)
          & p__destination(P,D)
          & p__patient(P,O) ) ) ).

fof(miloA1990,axiom,
    p__d__instance(c__Blank,c__RelationalAttribute) ).

fof(miloA1991,axiom,
    ! [DSTORE] :
      ( ( p__d__instance(DSTORE,c__DataStorageDevice)
        & p__attribute(DSTORE,c__Blank) )
     => ! [DATA] :
          ( ~ p__d__instance(DATA,c__ContentBearingObject)
          | ~ p__stored(DATA,DSTORE) ) ) ).

fof(miloA1992,axiom,
    p__d__subclass(c__Recording,c__ContentBearingObject) ).

fof(miloA1993,axiom,
    ! [R] :
      ( p__d__instance(R,c__Recording)
     => ? [P] :
          ( p__d__instance(P,c__Process)
          & p__record(R,P) ) ) ).

fof(miloA1994,axiom,
    p__d__subclass(c__MusicRecording,c__AudioRecording) ).

fof(miloA1995,axiom,
    ! [M] :
      ( p__d__instance(M,c__MusicRecording)
     => ? [P] :
          ( p__d__instance(P,c__MakingMusic)
          & p__record(M,P) ) ) ).

fof(miloA1996,axiom,
    p__d__subclass(c__SheetMusic,c__ContentBearingObject) ).

fof(miloA1997,axiom,
    ! [SM] :
      ( p__d__instance(SM,c__SheetMusic)
     => ? [MC] :
          ( p__d__instance(MC,c__MusicalComposition)
          & p__containsInformation(SM,MC) ) ) ).

fof(miloA1998,axiom,
    p__d__subclass(c__MusicText,c__Text) ).

fof(miloA1999,axiom,
    ! [X] :
      ( p__d__instance(X,c__MusicText)
     => p__capability(c__MakingMusic,c__patient,X) ) ).

fof(miloA2000,axiom,
    p__d__subclass(c__VideoRecording,c__Recording) ).

fof(miloA2001,axiom,
    ! [X] :
      ( p__d__instance(X,c__VideoRecording)
     => ? [EV] :
          ( p__d__instance(EV,c__Process)
          & p__represents(X,EV)
          & p__capability(c__RadiatingLight,c__patient,X) ) ) ).

fof(miloA2003,axiom,
    p__d__subclass(c__MediaSystem,c__Collection) ).

fof(miloA2005,axiom,
    p__d__subclass(c__Label,c__Text) ).

fof(miloA2006,axiom,
    ! [LABEL] :
      ( p__d__instance(LABEL,c__Label)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__SelfConnectedObject)
          & p__connected(LABEL,OBJ)
          & p__refers(LABEL,OBJ) ) ) ).

fof(miloA2007,axiom,
    p__d__subclass(c__FormText,c__Text) ).

fof(miloA2008,axiom,
    p__d__subclass(c__TestForm,c__FormText) ).

fof(miloA2009,axiom,
    p__d__subclass(c__TestForm,c__MeasuringDevice) ).

fof(miloA2010,axiom,
    p__d__subclass(c__Ballot,c__FormText) ).

fof(miloA2012,axiom,
    p__d__subclass(c__Application,c__FormText) ).

fof(miloA2014,axiom,
    p__d__subclass(c__Announcement,c__FactualText) ).

fof(miloA2015,axiom,
    ! [A] :
      ( p__d__instance(A,c__Announcement)
     => ? [CD,I] :
          ( p__d__instance(CD,c__ContentDevelopment)
          & p__result(CD,A)
          & p__refers(A,I)
          & p__d__instance(I,c__SocialInteraction)
          & p__earlier(f__WhenFn1(CD),f__WhenFn1(I)) ) ) ).

fof(miloA2016,axiom,
    p__d__subclass(c__PerformanceProgram,c__FactualText) ).

fof(miloA2017,axiom,
    ! [PROG] :
      ( p__d__instance(PROG,c__PerformanceProgram)
     => ? [PERF,PROP] :
          ( p__d__instance(PROP,c__Proposition)
          & p__containsInformation(PROG,PROP)
          & p__realization(PERF,PROP)
          & p__d__instance(PERF,c__Performance) ) ) ).

fof(miloA2018,axiom,
    p__d__subclass(c__MotionPictureShot,c__MotionPicture) ).

fof(miloA2019,axiom,
    ! [SHOT] :
      ( p__d__instance(SHOT,c__MotionPictureShot)
     => ? [MOVIE] :
          ( p__d__instance(MOVIE,c__MotionPicture)
          & p__subsumesContentInstance(MOVIE,SHOT) ) ) ).

fof(miloA2020,axiom,
    p__d__subclass(c__MotionPictureScene,c__MotionPicture) ).

fof(miloA2021,axiom,
    ! [MOVIE,S] :
      ( ( p__d__instance(MOVIE,c__ContentBearingPhysical)
        & p__d__instance(S,c__MotionPictureScene) )
     => ? [M] :
          ( p__d__instance(M,c__MotionPicture)
          & p__subsumesContentInstance(MOVIE,S) ) ) ).

fof(miloA2022,axiom,
    p__d__subclass(c__Documentary,c__MotionPicture) ).

fof(miloA2023,axiom,
    p__d__subclass(c__Documentary,c__FactualText) ).

fof(miloA2024,axiom,
    p__d__subclass(c__BroadcastProgram,c__Series) ).

fof(miloA2025,axiom,
    ! [PROGRAM] :
      ( p__d__instance(PROGRAM,c__BroadcastProgram)
     => ? [BROADCAST] :
          ( p__d__instance(BROADCAST,c__Broadcasting)
          & p__patient(BROADCAST,PROGRAM) ) ) ).

fof(miloA2026,axiom,
    p__d__subclass(c__NewsProgram,c__BroadcastProgram) ).

fof(miloA2027,axiom,
    ! [PROGRAM,NUMBER,EPISODE] :
      ( ( p__d__instance(NUMBER,c__PositiveInteger)
        & p__d__subclass(EPISODE,c__Text)
        & p__d__subclass(PROGRAM,c__NewsProgram)
        & EPISODE = f__SeriesVolumeFn2(PROGRAM,NUMBER) )
     => ? [DISSEMINATE] :
          ( p__d__instance(DISSEMINATE,c__Disseminating)
          & p__patient(DISSEMINATE,EPISODE) ) ) ).

fof(miloA2028,axiom,
    p__d__instance(c__SeriesVolumeFn,c__BinaryFunction) ).

fof(miloA2029,axiom,
    p__d__instance(c__SeriesVolumeFn,c__PartialValuedRelation) ).

fof(miloA2033,axiom,
    ! [TEXT,INT2,INT1,VOLUME1,VOLUME2,CBO1,CBO2,PUB1,PUB2,DATE1,DATE2] :
      ( ( p__d__instance(INT1,c__PositiveInteger)
        & p__d__subclass(VOLUME1,c__Text)
        & p__d__instance(INT2,c__PositiveInteger)
        & p__d__subclass(VOLUME2,c__Text)
        & p__d__instance(DATE1,c__Day)
        & p__d__instance(DATE2,c__Day)
        & p__d__subclass(TEXT,c__Periodical)
        & f__SeriesVolumeFn2(TEXT,INT1) = VOLUME1
        & f__SeriesVolumeFn2(TEXT,INT2) = VOLUME2
        & p__greaterThan(INT2,INT1)
        & p__d__instance(PUB1,c__Publication)
        & p__d__instance(PUB2,c__Publication)
        & p__d__instance(CBO1,VOLUME1)
        & p__d__instance(CBO2,VOLUME2)
        & p__patient(PUB1,CBO1)
        & p__patient(PUB2,CBO2)
        & p__date(PUB1,DATE1)
        & p__date(PUB2,DATE2) )
     => p__before(f__EndFn1(DATE1),f__EndFn1(DATE2)) ) ).

fof(miloA2034,axiom,
    ! [NUMBER,SERIES,VOLUME] :
      ( ( p__d__instance(NUMBER,c__PositiveInteger)
        & p__d__subclass(SERIES,c__Series)
        & p__d__subclass(VOLUME,c__Text)
        & f__SeriesVolumeFn2(SERIES,NUMBER) = VOLUME )
     => p__subsumesContentClass(SERIES,VOLUME) ) ).

fof(miloA2035,axiom,
    p__d__subclass(c__Series,c__Text) ).

fof(miloA2036,axiom,
    ! [SERIES] :
      ( p__d__instance(SERIES,c__Series)
     => ? [BOOK1,BOOK2] :
          ( p__d__instance(BOOK1,c__Book)
          & p__d__instance(BOOK2,c__Book)
          & p__subsumesContentInstance(SERIES,BOOK1)
          & p__subsumesContentInstance(SERIES,BOOK2)
          & BOOK1 != BOOK2 ) ) ).

fof(miloA2037,axiom,
    p__d__instance(c__PeriodicalIssueFn,c__BinaryFunction) ).

fof(miloA2038,axiom,
    p__d__instance(c__PeriodicalIssueFn,c__PartialValuedRelation) ).

fof(miloA2042,axiom,
    ! [NUMBER,PERIODICAL,ISSUE] :
      ( ( p__d__instance(NUMBER,c__PositiveInteger)
        & p__d__subclass(PERIODICAL,c__Periodical)
        & p__d__subclass(ISSUE,c__Periodical)
        & f__PeriodicalIssueFn2(PERIODICAL,NUMBER) = ISSUE )
     => p__subsumesContentClass(PERIODICAL,ISSUE) ) ).

fof(miloA2043,axiom,
    p__d__subclass(c__Periodical,c__Series) ).

fof(miloA2044,axiom,
    p__d__subclass(c__Article,c__Text) ).

fof(miloA2045,axiom,
    p__d__disjoint(c__Article,c__Book) ).

fof(miloA2046,axiom,
    ! [ARTICLE1,BOOK] :
      ( ( p__d__instance(ARTICLE1,c__Article)
        & p__d__instance(BOOK,c__Book)
        & p__subsumesContentInstance(BOOK,ARTICLE1) )
     => ? [ARTICLE2] :
          ( p__d__instance(ARTICLE2,c__Article)
          & ARTICLE2 != ARTICLE1
          & p__subsumesContentInstance(BOOK,ARTICLE2) ) ) ).

fof(miloA2047,axiom,
    p__d__subclass(c__Chapter,c__Article) ).

fof(miloA2048,axiom,
    ! [CHAPTER] :
      ( p__d__instance(CHAPTER,c__Chapter)
     => ? [BOOK] :
          ( p__d__instance(BOOK,c__Book)
          & p__subsumesContentInstance(BOOK,CHAPTER) ) ) ).

fof(miloA2049,axiom,
    p__subrelation(c__titles,c__names) ).

fof(miloA2052,axiom,
    p__subrelation(c__formerName,c__names) ).

fof(miloA2053,axiom,
    p__d__instance(c__familyName,c__BinaryPredicate) ).

fof(miloA2054,axiom,
    p__d__instance(c__familyName,c__AsymmetricRelation) ).

fof(miloA2057,axiom,
    p__subrelation(c__familyName,c__names) ).

fof(miloA2058,axiom,
    p__d__instance(c__middleName,c__BinaryPredicate) ).

fof(miloA2059,axiom,
    p__d__instance(c__middleName,c__AsymmetricRelation) ).

fof(miloA2062,axiom,
    p__subrelation(c__middleName,c__names) ).

fof(miloA2063,axiom,
    p__d__instance(c__givenName,c__BinaryPredicate) ).

fof(miloA2064,axiom,
    p__d__instance(c__givenName,c__AsymmetricRelation) ).

fof(miloA2065,axiom,
    p__subrelation(c__givenName,c__names) ).

fof(miloA2068,axiom,
    p__d__instance(c__localLongName,c__BinaryPredicate) ).

fof(miloA2071,axiom,
    p__subrelation(c__localLongName,c__names) ).

fof(miloA2072,axiom,
    p__subrelation(c__localShortName,c__names) ).

fof(miloA2073,axiom,
    p__d__instance(c__localShortName,c__BinaryPredicate) ).

fof(miloA2076,axiom,
    p__d__subclass(c__Message,c__FactualText) ).

fof(miloA2077,axiom,
    p__d__subclass(c__Report,c__FactualText) ).

fof(miloA2078,axiom,
    p__d__subclass(c__Report,c__Article) ).

fof(miloA2079,axiom,
    p__d__subclass(c__Newspaper,c__Periodical) ).

fof(miloA2080,axiom,
    ! [PAPER] :
      ( p__d__instance(PAPER,c__Newspaper)
     => ? [REPORT] :
          ( p__d__instance(REPORT,c__Report)
          & p__subsumesContentInstance(PAPER,REPORT) ) ) ).

fof(miloA2081,axiom,
    ! [WEEK,PAPER] :
      ( ( p__d__subclass(PAPER,c__Newspaper)
        & p__d__instance(WEEK,c__Week) )
     => ? [PUBLICATION,ISSUE] :
          ( p__d__instance(PUBLICATION,c__Publication)
          & p__temporalPart(f__WhenFn1(PUBLICATION),WEEK)
          & p__result(PUBLICATION,ISSUE)
          & p__d__instance(ISSUE,PAPER) ) ) ).

fof(miloA2082,axiom,
    p__d__subclass(c__Magazine,c__Periodical) ).

fof(miloA2083,axiom,
    p__d__subclass(c__Letter,c__FactualText) ).

fof(miloA2084,axiom,
    p__d__subclass(c__Holiday,c__TimeInterval) ).

fof(miloA2085,axiom,
    p__d__subclass(c__FixedHoliday,c__Holiday) ).

fof(miloA2086,axiom,
    p__d__subclass(c__MoveableHoliday,c__Holiday) ).

fof(miloA2087,axiom,
    p__d__subclass(c__HolidayCard,c__ContentBearingObject) ).

fof(miloA2089,axiom,
    ! [C] :
      ( p__d__instance(C,c__HolidayCard)
     => ? [H] :
          ( p__d__instance(H,c__Holiday)
          & p__refers(C,H) ) ) ).

fof(miloA2090,axiom,
    p__d__subclass(c__HistoricalAccount,c__NarrativeText) ).

fof(miloA2091,axiom,
    p__d__subclass(c__HistoricalAccount,c__FactualText) ).

fof(miloA2092,axiom,
    ! [ACCOUNT] :
      ( p__d__instance(ACCOUNT,c__HistoricalAccount)
     => ? [EVENT] :
          ( p__d__instance(EVENT,c__Physical)
          & p__represents(ACCOUNT,EVENT)
          & p__earlier(f__WhenFn1(EVENT),f__WhenFn1(ACCOUNT)) ) ) ).

fof(miloA2093,axiom,
    p__d__subclass(c__Biography,c__HistoricalAccount) ).

fof(miloA2094,axiom,
    ! [B] :
      ( p__d__instance(B,c__Biography)
     => ? [H] :
          ( p__d__instance(H,c__Human)
          & p__refers(B,H) ) ) ).

fof(miloA2095,axiom,
    p__d__subclass(c__FinancialText,c__Report) ).

fof(miloA2096,axiom,
    p__d__subclass(c__FinancialBill,c__FinancialText) ).

fof(miloA2097,axiom,
    p__d__subclass(c__ReferenceBook,c__Book) ).

fof(miloA2098,axiom,
    p__d__subclass(c__ReferenceBook,c__FactualText) ).

fof(miloA2099,axiom,
    p__d__subclass(c__Dictionary,c__ReferenceBook) ).

fof(miloA2100,axiom,
    p__d__subclass(c__NarrativeText,c__Text) ).

fof(miloA2102,axiom,
    p__d__subclass(c__ShortStory,c__FictionalText) ).

fof(miloA2103,axiom,
    p__d__subclass(c__ShortStory,c__Article) ).

fof(miloA2104,axiom,
    p__d__subclass(c__MysteryStory,c__FictionalText) ).

fof(miloA2105,axiom,
    ! [S] :
      ( p__d__instance(S,c__MysteryStory)
     => ? [C] :
          ( p__d__instance(C,c__CriminalAction)
          & p__refers(S,C) ) ) ).

fof(miloA2106,axiom,
    p__d__subclass(c__Novel,c__FictionalText) ).

fof(miloA2107,axiom,
    p__d__subclass(c__Novel,c__Book) ).

fof(miloA2108,axiom,
    p__d__subclass(c__DramaticPlay,c__FictionalText) ).

fof(miloA2110,axiom,
    p__d__subclass(c__Opera,c__DramaticPlay) ).

fof(miloA2111,axiom,
    p__d__instance(c__FrenchLanguage,c__SpokenHumanLanguage) ).

fof(miloA2112,axiom,
    p__d__instance(c__FrenchLanguage,c__NaturalLanguage) ).

fof(miloA2113,axiom,
    p__d__instance(c__GermanLanguage,c__SpokenHumanLanguage) ).

fof(miloA2114,axiom,
    p__d__instance(c__GermanLanguage,c__NaturalLanguage) ).

fof(miloA2115,axiom,
    p__d__instance(c__GreekLanguage,c__SpokenHumanLanguage) ).

fof(miloA2116,axiom,
    p__d__instance(c__GreekLanguage,c__NaturalLanguage) ).

fof(miloA2117,axiom,
    p__d__instance(c__LatinLanguage,c__SpokenHumanLanguage) ).

fof(miloA2118,axiom,
    p__d__instance(c__LatinLanguage,c__NaturalLanguage) ).

fof(miloA2119,axiom,
    p__d__instance(c__RussianLanguage,c__SpokenHumanLanguage) ).

fof(miloA2120,axiom,
    p__d__instance(c__RussianLanguage,c__NaturalLanguage) ).

fof(miloA2121,axiom,
    p__d__instance(c__SpanishLanguage,c__SpokenHumanLanguage) ).

fof(miloA2122,axiom,
    p__d__instance(c__SpanishLanguage,c__NaturalLanguage) ).

fof(miloA2124,axiom,
    p__d__subclass(c__LiteracyAttribute,c__TraitAttribute) ).

fof(miloA2125,axiom,
    p__d__subclass(c__Industry,c__Collection) ).

fof(miloA2126,axiom,
    p__d__subclass(c__Chimney,c__StationaryArtifact) ).

fof(miloA2127,axiom,
    p__d__subclass(c__Chimney,c__Device) ).

fof(miloA2129,axiom,
    p__d__subclass(c__Curb,c__StationaryArtifact) ).

fof(miloA2130,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__SelfConnectedObject)
        & p__d__instance(C,c__Curb) )
     => ? [S,R] :
          ( p__d__instance(S,c__SelfConnectedObject)
          & p__d__instance(S,c__Sidewalk)
          & p__d__instance(R,c__Roadway)
          & p__connects(C,S,R) ) ) ).

fof(miloA2131,axiom,
    p__d__instance(c__Paved,c__Attribute) ).

fof(miloA2132,axiom,
    p__d__instance(c__Unpaved,c__Attribute) ).

fof(miloA2133,axiom,
    p__d__subclass(c__Stairway,c__StationaryArtifact) ).

fof(miloA2134,axiom,
    ! [S] :
      ( p__d__instance(S,c__Stairway)
     => ( p__capability(c__MotionUpward,c__instrument,S)
        & p__capability(c__MotionDownward,c__instrument,S) ) ) ).

fof(miloA2136,axiom,
    p__d__subclass(c__Steps,c__StationaryArtifact) ).

fof(miloA2137,axiom,
    ! [STEPS] :
      ( p__d__instance(STEPS,c__Steps)
     => ( p__capability(c__MotionUpward,c__instrument,STEPS)
        & p__capability(c__MotionDownward,c__instrument,STEPS) ) ) ).

fof(miloA2138,axiom,
    ! [BUILDING,LEVEL1,LEVEL2] :
      ( ( p__d__instance(LEVEL1,c__SelfConnectedObject)
        & p__d__instance(LEVEL2,c__SelfConnectedObject)
        & p__d__instance(LEVEL1,c__BuildingLevel)
        & p__d__instance(LEVEL2,c__BuildingLevel)
        & LEVEL1 != LEVEL2
        & p__d__instance(BUILDING,c__Building)
        & p__part(LEVEL1,BUILDING)
        & p__part(LEVEL2,BUILDING) )
     => ? [STEPS] :
          ( p__d__instance(STEPS,c__SelfConnectedObject)
          & p__d__instance(STEPS,c__Steps)
          & p__connects(STEPS,LEVEL1,LEVEL2) ) ) ).

fof(miloA2139,axiom,
    p__d__subclass(c__Ladder,c__Artifact) ).

fof(miloA2140,axiom,
    ! [LADDER] :
      ( p__d__instance(LADDER,c__Ladder)
     => ( p__capability(c__MotionUpward,c__instrument,LADDER)
        & p__capability(c__MotionDownward,c__instrument,LADDER) ) ) ).

fof(miloA2141,axiom,
    p__d__instance(c__Transparent,c__InternalAttribute) ).

fof(miloA2143,axiom,
    p__d__subclass(c__Curtain,c__WindowCovering) ).

fof(miloA2144,axiom,
    p__d__subclass(c__Curtain,c__Fabric) ).

fof(miloA2145,axiom,
    p__d__subclass(c__Window,c__Artifact) ).

fof(miloA2146,axiom,
    ! [W] :
      ( p__d__instance(W,c__Window)
     => ? [A] :
          ( p__d__instance(A,c__Object)
          & p__part(W,A)
          & ( p__d__instance(A,c__Building)
            | p__d__instance(A,c__Room)
            | p__d__instance(A,c__Vehicle) ) ) ) ).

fof(miloA2147,axiom,
    ! [W] :
      ( p__d__instance(W,c__Window)
     => p__attribute(W,c__Transparent) ) ).

fof(miloA2148,axiom,
    p__d__subclass(c__Skylight,c__Window) ).

fof(miloA2149,axiom,
    ! [W] :
      ( p__d__instance(W,c__Skylight)
     => ? [C] :
          ( p__d__instance(C,c__Ceiling)
          & p__part(W,C) ) ) ).

fof(miloA2150,axiom,
    p__d__subclass(c__RearWindow,c__VehicleWindow) ).

fof(miloA2151,axiom,
    ! [W] :
      ( p__d__instance(W,c__RearWindow)
     => ? [A] :
          ( p__d__instance(A,c__SelfConnectedObject)
          & p__d__instance(A,c__RoadVehicle)
          & p__part(W,f__BackFn1(A)) ) ) ).

fof(miloA2152,axiom,
    p__d__subclass(c__WindowCovering,c__Artifact) ).

fof(miloA2154,axiom,
    p__d__instance(c__AdjoiningRoom,c__RelationalAttribute) ).

fof(miloA2155,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__AdjoiningRoom) )
     => p__d__instance(X,c__Room) ) ).

fof(miloA2156,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__AdjoiningRoom) )
     => ? [ROOM,WALL,DOOR] :
          ( p__d__instance(ROOM,c__Object)
          & p__attribute(ROOM,c__AdjoiningRoom)
          & ROOM != X
          & p__orientation(X,ROOM,c__Adjacent)
          & p__d__instance(WALL,c__Wall)
          & p__part(WALL,ROOM)
          & p__part(WALL,X)
          & p__d__instance(DOOR,c__Door)
          & p__part(DOOR,WALL) ) ) ).

fof(miloA2157,axiom,
    p__d__subclass(c__TransitwayObstacle,c__Object) ).

fof(miloA2158,axiom,
    p__d__subclass(c__Door,c__TransitwayObstacle) ).

fof(miloA2159,axiom,
    p__d__subclass(c__Door,c__Device) ).

fof(miloA2160,axiom,
    ! [DOOR] :
      ( p__d__instance(DOOR,c__Door)
     => ? [WAY] :
          ( p__part(DOOR,WAY)
          & p__d__instance(WAY,c__Doorway) ) ) ).

fof(miloA2161,axiom,
    p__d__subclass(c__Hinge,c__EngineeringComponent) ).

fof(miloA2163,axiom,
    p__d__subclass(c__Doorway,c__StationaryArtifact) ).

fof(miloA2164,axiom,
    ! [WAY] :
      ( p__d__instance(WAY,c__Doorway)
     => ? [ARTIFACT] :
          ( p__d__instance(ARTIFACT,c__Object)
          & p__part(WAY,ARTIFACT)
          & ( p__d__instance(ARTIFACT,c__Building)
            | p__d__instance(ARTIFACT,c__Room) ) ) ) ).

fof(miloA2165,axiom,
    ! [DOOR] :
      ( p__d__instance(DOOR,c__Door)
     => ? [ARTIFACT] :
          ( p__d__instance(ARTIFACT,c__Object)
          & p__part(DOOR,ARTIFACT)
          & ( p__d__instance(ARTIFACT,c__Building)
            | p__d__instance(ARTIFACT,c__Room) ) ) ) ).

fof(miloA2166,axiom,
    p__d__subclass(c__Wall,c__StationaryArtifact) ).

fof(miloA2167,axiom,
    ! [WALL] :
      ( p__d__instance(WALL,c__Wall)
     => ? [ARTIFACT] :
          ( p__d__instance(ARTIFACT,c__Object)
          & p__part(WALL,ARTIFACT)
          & ( p__d__instance(ARTIFACT,c__Building)
            | p__d__instance(ARTIFACT,c__Room) ) ) ) ).

fof(miloA2168,axiom,
    p__d__subclass(c__Floor,c__StationaryArtifact) ).

fof(miloA2169,axiom,
    ! [FLOOR] :
      ( p__d__instance(FLOOR,c__Floor)
     => ? [ARTIFACT] :
          ( p__part(FLOOR,ARTIFACT)
          & p__d__instance(ARTIFACT,c__Room) ) ) ).

fof(miloA2170,axiom,
    p__d__subclass(c__Ceiling,c__StationaryArtifact) ).

fof(miloA2171,axiom,
    ! [C] :
      ( ( p__d__instance(C,c__SelfConnectedObject)
        & p__d__instance(C,c__Ceiling) )
     => ? [R] :
          ( p__d__instance(R,c__SelfConnectedObject)
          & p__top(C,R)
          & p__d__instance(R,c__Room) ) ) ).

fof(miloA2172,axiom,
    p__d__subclass(c__Roof,c__StationaryArtifact) ).

fof(miloA2173,axiom,
    ! [ROOF] :
      ( ( p__d__instance(ROOF,c__SelfConnectedObject)
        & p__d__instance(ROOF,c__Roof) )
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__SelfConnectedObject)
          & p__d__instance(BUILDING,c__Building)
          & p__top(ROOF,BUILDING) ) ) ).

fof(miloA2174,axiom,
    p__d__subclass(c__Fireplace,c__StationaryArtifact) ).

fof(miloA2175,axiom,
    p__d__subclass(c__Fireplace,c__Device) ).

fof(miloA2177,axiom,
    ! [F] :
      ( p__d__instance(F,c__Fireplace)
     => ? [C] :
          ( p__d__instance(C,c__Chimney)
          & p__connected(F,C) ) ) ).

fof(miloA2178,axiom,
    ! [F] :
      ( p__d__instance(F,c__Fireplace)
     => ? [B] :
          ( p__d__instance(B,c__Building)
          & p__part(F,B) ) ) ).

fof(miloA2179,axiom,
    p__d__subclass(c__Balcony,c__StationaryArtifact) ).

fof(miloA2180,axiom,
    ! [BALCONY] :
      ( p__d__instance(BALCONY,c__Balcony)
     => ? [WALL,LANDAREA] :
          ( p__d__instance(WALL,c__Object)
          & p__meetsSpatially(WALL,BALCONY)
          & p__d__instance(LANDAREA,c__LandArea)
          & p__located(WALL,LANDAREA)
          & p__orientation(BALCONY,LANDAREA,c__Above) ) ) ).

fof(miloA2181,axiom,
    p__d__subclass(c__BuildingLevel,c__StationaryArtifact) ).

fof(miloA2182,axiom,
    ! [LEVEL] :
      ( p__d__instance(LEVEL,c__BuildingLevel)
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__Building)
          & p__part(LEVEL,BUILDING) ) ) ).

fof(miloA2183,axiom,
    p__d__subclass(c__Basement,c__BuildingLevel) ).

fof(miloA2184,axiom,
    ! [BASEMENT] :
      ( p__d__instance(BASEMENT,c__Basement)
     => ! [LEVEL,BUILDING] :
          ( ~ p__d__instance(LEVEL,c__Object)
          | ~ p__d__instance(BUILDING,c__Object)
          | ~ p__d__instance(LEVEL,c__BuildingLevel)
          | ~ p__d__instance(BUILDING,c__Building)
          | ~ p__part(LEVEL,BUILDING)
          | ~ p__part(BASEMENT,BUILDING)
          | LEVEL = BASEMENT
          | ~ p__orientation(LEVEL,BASEMENT,c__Below) ) ) ).

fof(miloA2185,axiom,
    p__d__subclass(c__Elevator,c__TransportationDevice) ).

fof(miloA2187,axiom,
    ! [E] :
      ( p__d__instance(E,c__Elevator)
     => ( p__capability(c__MotionUpward,c__instrument,E)
        & p__capability(c__MotionDownward,c__instrument,E) ) ) ).

fof(miloA2188,axiom,
    p__d__subclass(c__Pump,c__TransportationDevice) ).

fof(miloA2189,axiom,
    ! [D,T] :
      ( ( p__d__instance(T,c__Transportation)
        & p__instrument(T,D)
        & p__d__instance(D,c__Pump) )
     => ? [F] :
          ( p__d__instance(F,c__Object)
          & p__instrument(T,F)
          & p__attribute(F,c__Fluid) ) ) ).

fof(miloA2190,axiom,
    p__d__subclass(c__Oar,c__TransportationDevice) ).

fof(miloA2192,axiom,
    p__d__subclass(c__Garage,c__StationaryArtifact) ).

fof(miloA2194,axiom,
    ! [GARAGE] :
      ( p__d__instance(GARAGE,c__Garage)
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__Building)
          & p__part(GARAGE,BUILDING) ) ) ).

fof(miloA2195,axiom,
    p__d__subclass(c__Bathroom,c__Room) ).

fof(miloA2196,axiom,
    ! [B] :
      ( p__d__instance(B,c__Bathroom)
     => ? [W] :
          ( p__d__instance(W,c__WashBasin)
          & p__located(W,B) ) ) ).

fof(miloA2197,axiom,
    p__d__subclass(c__Closet,c__Room) ).

fof(miloA2199,axiom,
    p__d__subclass(c__DressingRoom,c__Room) ).

fof(miloA2201,axiom,
    p__d__subclass(c__SittingArea,c__Region) ).

fof(miloA2202,axiom,
    ! [AREA] :
      ( p__d__instance(AREA,c__SittingArea)
     => ? [SEAT] :
          ( p__d__instance(SEAT,c__Seat)
          & p__located(SEAT,AREA) ) ) ).

fof(miloA2203,axiom,
    p__d__subclass(c__KitchenArea,c__Region) ).

fof(miloA2205,axiom,
    p__d__subclass(c__Kitchen,c__Room) ).

fof(miloA2206,axiom,
    p__d__subclass(c__Kitchen,c__KitchenArea) ).

fof(miloA2208,axiom,
    p__d__subclass(c__DiningArea,c__Region) ).

fof(miloA2210,axiom,
    p__d__subclass(c__DiningRoom,c__Room) ).

fof(miloA2211,axiom,
    p__d__subclass(c__DiningRoom,c__DiningArea) ).

fof(miloA2212,axiom,
    p__d__subclass(c__Bedroom,c__Room) ).

fof(miloA2213,axiom,
    ! [ROOM] :
      ( p__d__instance(ROOM,c__Bedroom)
     => ? [BED] :
          ( p__d__instance(BED,c__Bed)
          & p__located(BED,ROOM) ) ) ).

fof(miloA2214,axiom,
    p__d__subclass(c__Classroom,c__Room) ).

fof(miloA2215,axiom,
    ! [R] :
      ( p__d__instance(R,c__Classroom)
     => ? [S] :
          ( p__d__instance(S,c__School)
          & p__part(R,S) ) ) ).

fof(miloA2217,axiom,
    p__d__subclass(c__Porch,c__StationaryArtifact) ).

fof(miloA2218,axiom,
    ! [PORCH] :
      ( p__d__instance(PORCH,c__Porch)
     => ? [BUILDING] :
          ( p__d__instance(BUILDING,c__Building)
          & p__connected(PORCH,BUILDING) ) ) ).

fof(miloA2219,axiom,
    p__d__subclass(c__Sidewalk,c__StationaryArtifact) ).

fof(miloA2221,axiom,
    ! [SIDE] :
      ( p__d__instance(SIDE,c__Sidewalk)
     => ? [ROAD] :
          ( p__d__instance(ROAD,c__Roadway)
          & p__orientation(SIDE,ROAD,c__Near) ) ) ).

fof(miloA2222,axiom,
    p__d__subclass(c__Fence,c__StationaryArtifact) ).

fof(miloA2223,axiom,
    p__d__subclass(c__SportsGround,c__StationaryArtifact) ).

fof(miloA2225,axiom,
    p__d__subclass(c__IndustrialPlant,c__StationaryArtifact) ).

fof(miloA2226,axiom,
    ! [PLANT] :
      ( p__d__instance(PLANT,c__IndustrialPlant)
     => ( p__d__instance(PLANT,c__Building)
        | ? [BUILDING] :
            ( p__d__instance(BUILDING,c__Building)
            & p__located(BUILDING,PLANT) ) ) ) ).

fof(miloA2228,axiom,
    p__d__subclass(c__Laboratory,c__StationaryArtifact) ).

fof(miloA2229,axiom,
    ! [LAB] :
      ( p__d__instance(LAB,c__Laboratory)
     => ? [EXPERIMENT] :
          ( p__d__instance(EXPERIMENT,c__Experimenting)
          & p__eventLocated(EXPERIMENT,LAB) ) ) ).

fof(miloA2230,axiom,
    p__d__instance(c__experimentalControl,c__CaseRole) ).

fof(miloA2233,axiom,
    p__subrelation(c__experimentalControl,c__patient) ).

fof(miloA2234,axiom,
    p__d__subclass(c__MilitaryInstallation,c__StationaryArtifact) ).

fof(miloA2235,axiom,
    p__d__subclass(c__MilitaryInstallation,c__MilitaryArtifact) ).

fof(miloA2236,axiom,
    p__d__subclass(c__Farm,c__StationaryArtifact) ).

fof(miloA2237,axiom,
    p__d__subclass(c__Barn,c__Building) ).

fof(miloA2238,axiom,
    p__d__disjoint(c__Barn,c__ResidentialBuilding) ).

fof(miloA2239,axiom,
    ! [BARN] :
      ( p__d__instance(BARN,c__Barn)
     => ? [FARM] :
          ( p__d__instance(FARM,c__Farm)
          & p__located(BARN,FARM) ) ) ).

fof(miloA2240,axiom,
    p__d__subclass(c__PerformanceStage,c__StationaryArtifact) ).

fof(miloA2242,axiom,
    ! [STAGE] :
      ( p__d__instance(STAGE,c__PerformanceStage)
     => ? [AUDITORIUM] :
          ( p__d__instance(AUDITORIUM,c__Auditorium)
          & p__part(STAGE,AUDITORIUM) ) ) ).

fof(miloA2243,axiom,
    p__d__subclass(c__PerformanceStageWing,c__StationaryArtifact) ).

fof(miloA2244,axiom,
    ! [W] :
      ( p__d__instance(W,c__PerformanceStageWing)
     => ? [S] :
          ( p__d__instance(S,c__PerformanceStage)
          & p__part(W,S) ) ) ).

fof(miloA2245,axiom,
    p__d__subclass(c__Magnetism,c__RadiatingElectromagnetic) ).

fof(miloA2246,axiom,
    p__d__subclass(c__RadioEmission,c__RadiatingElectromagnetic) ).

fof(miloA2247,axiom,
    p__d__subclass(c__Broadcasting,c__Disseminating) ).

fof(miloA2248,axiom,
    p__d__subclass(c__Broadcasting,c__RadioEmission) ).

fof(miloA2249,axiom,
    ! [BROADCAST] :
      ( p__d__instance(BROADCAST,c__Broadcasting)
     => ? [DEVICE] :
          ( p__d__instance(DEVICE,c__CommunicationDevice)
          & p__instrument(BROADCAST,DEVICE) ) ) ).

fof(miloA2250,axiom,
    p__d__subclass(c__RadioBroadcasting,c__Broadcasting) ).

fof(miloA2251,axiom,
    ! [RADIO] :
      ( p__d__instance(RADIO,c__RadioReceiver)
     => p__capability(c__RadioBroadcasting,c__patient,RADIO) ) ).

fof(miloA2252,axiom,
    p__d__subclass(c__TelevisionBroadcasting,c__Broadcasting) ).

fof(miloA2253,axiom,
    p__d__subclass(c__PeriodicalPublisher,c__Publisher) ).

fof(miloA2254,axiom,
    ! [C] :
      ( p__d__instance(C,c__PeriodicalPublisher)
     => ? [PUBLISH,PERIODICAL] :
          ( p__d__instance(PUBLISH,c__Publication)
          & p__agent(PUBLISH,C)
          & p__patient(PUBLISH,PERIODICAL)
          & p__d__instance(PERIODICAL,c__Periodical) ) ) ).

fof(miloA2255,axiom,
    p__d__subclass(c__Antenna,c__CommunicationDevice) ).

fof(miloA2256,axiom,
    ! [ANTENNA] :
      ( p__d__instance(ANTENNA,c__Antenna)
     => p__capability(c__RadioEmission,c__instrument,ANTENNA) ) ).

fof(miloA2257,axiom,
    p__d__subclass(c__Explosion,c__Radiating) ).

fof(miloA2258,axiom,
    ! [EXPLOSION] :
      ( p__d__instance(EXPLOSION,c__Explosion)
     => ? [PROC] :
          ( p__d__instance(PROC,c__ChemicalProcess)
          & p__causes(PROC,EXPLOSION) ) ) ).

fof(miloA2259,axiom,
    p__d__subclass(c__Performance,c__Demonstrating) ).

fof(miloA2260,axiom,
    ! [PERFORMANCE] :
      ( p__d__instance(PERFORMANCE,c__Performance)
     => ? [SUB] :
          ( p__d__instance(SUB,c__Process)
          & p__subProcess(SUB,PERFORMANCE)
          & ( p__d__instance(SUB,c__DramaticActing)
            | p__d__instance(SUB,c__MakingMusic) ) ) ) ).

fof(miloA2261,axiom,
    ! [PERFORMANCE] :
      ( p__d__instance(PERFORMANCE,c__Performance)
     => ? [STAGE] :
          ( p__d__instance(STAGE,c__PerformanceStage)
          & p__eventLocated(PERFORMANCE,STAGE) ) ) ).

fof(miloA2262,axiom,
    p__d__subclass(c__PerformanceAct,c__Performance) ).

fof(miloA2263,axiom,
    p__d__subclass(c__Lecture,c__Demonstrating) ).

fof(miloA2264,axiom,
    p__d__subclass(c__Lecture,c__Speaking) ).

fof(miloA2265,axiom,
    p__d__subclass(c__Proclaiming,c__Lecture) ).

fof(miloA2266,axiom,
    p__d__subclass(c__Proclaiming,c__Declaring) ).

fof(miloA2267,axiom,
    p__d__subclass(c__Commenting,c__IntentionalProcess) ).

fof(miloA2268,axiom,
    ! [COMMENTING,PROCESS] :
      ( ( p__d__instance(COMMENTING,c__Commenting)
        & p__d__instance(PROCESS,c__Process)
        & p__patient(COMMENTING,PROCESS) )
     => ? [AGENT,SPEAKING,LOOKING] :
          ( p__d__instance(AGENT,c__Agent)
          & p__d__instance(SPEAKING,c__Speaking)
          & p__d__instance(LOOKING,c__Looking)
          & p__agent(SPEAKING,AGENT)
          & p__agent(LOOKING,AGENT)
          & p__patient(LOOKING,PROCESS)
          & p__refers(SPEAKING,PROCESS) ) ) ).

fof(miloA2269,axiom,
    p__d__instance(c__commentator,c__BinaryPredicate) ).

fof(miloA2272,axiom,
    ! [AGENT,PROCESS] :
      ( ( p__d__instance(PROCESS,c__Process)
        & p__d__instance(AGENT,c__Agent)
        & p__commentator(AGENT,PROCESS) )
     => ? [COMMENTING] :
          ( p__d__instance(COMMENTING,c__Commenting)
          & p__agent(COMMENTING,AGENT)
          & p__patient(COMMENTING,PROCESS) ) ) ).

fof(miloA2273,axiom,
    p__d__subclass(c__Reciting,c__Speaking) ).

fof(miloA2274,axiom,
    ! [R] :
      ( p__d__instance(R,c__Reciting)
     => ? [P,T] :
          ( p__d__instance(P,c__Proposition)
          & p__realization(R,P)
          & p__containsInformation(T,P)
          & p__d__instance(T,c__Text) ) ) ).

fof(miloA2275,axiom,
    p__d__subclass(c__MusicalPerformance,c__Performance) ).

fof(miloA2276,axiom,
    ! [P,M] :
      ( ( p__d__instance(M,c__Process)
        & p__d__instance(P,c__MusicalPerformance)
        & p__subProcess(M,P) )
     => p__d__instance(M,c__MakingMusic) ) ).

fof(miloA2277,axiom,
    p__d__subclass(c__Sermon,c__Lecture) ).

fof(miloA2278,axiom,
    ! [SERMON] :
      ( p__d__instance(SERMON,c__Sermon)
     => ? [SERVICE] :
          ( p__d__instance(SERVICE,c__ReligiousService)
          & p__subProcess(SERMON,SERVICE) ) ) ).

fof(miloA2279,axiom,
    p__d__subclass(c__DramaticActing,c__Pretending) ).

fof(miloA2280,axiom,
    p__d__subclass(c__DramaticPerformance,c__Performance) ).

fof(miloA2281,axiom,
    ! [P,A] :
      ( ( p__d__instance(A,c__Process)
        & p__d__instance(P,c__DramaticPerformance)
        & p__subProcess(A,P) )
     => p__d__instance(A,c__DramaticActing) ) ).

fof(miloA2282,axiom,
    p__d__subclass(c__DramaticCast,c__GroupOfPeople) ).

fof(miloA2283,axiom,
    ! [CAST] :
      ( p__d__instance(CAST,c__DramaticCast)
     => ? [TEXT,PROP,PROC] :
          ( p__d__instance(PROP,c__Proposition)
          & p__d__instance(PROC,c__Process)
          & p__d__instance(TEXT,c__FictionalText)
          & p__containsInformation(TEXT,PROP)
          & p__realization(PROC,PROP)
          & ! [MEMBER] :
              ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
                & p__d__instance(MEMBER,c__Agent)
                & p__member(MEMBER,CAST) )
             => ? [SUB] :
                  ( p__d__instance(SUB,c__DramaticActing)
                  & p__agent(SUB,MEMBER)
                  & p__subProcess(SUB,PROC) ) ) ) ) ).

fof(miloA2284,axiom,
    p__d__subclass(c__SocialParty,c__Meeting) ).

fof(miloA2285,axiom,
    p__d__subclass(c__SocialParty,c__RecreationOrExercise) ).

fof(miloA2286,axiom,
    p__d__subclass(c__FormalMeeting,c__Meeting) ).

fof(miloA2287,axiom,
    p__d__disjoint(c__FormalMeeting,c__SocialParty) ).

fof(miloA2288,axiom,
    ! [MEETING] :
      ( p__d__instance(MEETING,c__FormalMeeting)
     => ? [PLANNING] :
          ( p__d__instance(PLANNING,c__Planning)
          & p__result(PLANNING,MEETING)
          & p__earlier(f__WhenFn1(PLANNING),f__WhenFn1(MEETING)) ) ) ).

fof(miloA2289,axiom,
    p__d__subclass(c__Funeral,c__Ceremony) ).

fof(miloA2290,axiom,
    p__d__subclass(c__Funeral,c__FormalMeeting) ).

fof(miloA2291,axiom,
    ! [F] :
      ( p__d__instance(F,c__Funeral)
     => ? [D] :
          ( p__d__instance(D,c__Death)
          & p__refers(F,D) ) ) ).

fof(miloA2292,axiom,
    p__d__subclass(c__Interviewing,c__FormalMeeting) ).

fof(miloA2293,axiom,
    p__d__subclass(c__Choreographing,c__Planning) ).

fof(miloA2294,axiom,
    ! [G,P,D] :
      ( ( p__d__instance(P,c__Proposition)
        & p__d__instance(D,c__Process)
        & p__d__instance(G,c__Choreographing)
        & p__result(G,P)
        & p__realization(D,P) )
     => p__d__instance(D,c__Dancing) ) ).

fof(miloA2295,axiom,
    p__d__subclass(c__Resolution,c__Deciding) ).

fof(miloA2296,axiom,
    ! [RESOLUTION] :
      ( p__d__instance(RESOLUTION,c__Resolution)
     => ? [AGENT,MEETING] :
          ( p__d__instance(AGENT,c__Organization)
          & p__agent(RESOLUTION,AGENT)
          & p__subProcess(RESOLUTION,MEETING)
          & p__d__instance(MEETING,c__FormalMeeting) ) ) ).

fof(miloA2297,axiom,
    p__d__subclass(c__Smoking,c__RecreationOrExercise) ).

fof(miloA2298,axiom,
    ! [SMOKING] :
      ( p__d__instance(SMOKING,c__Smoking)
     => ? [BURN,BREATHE,SMOKE] :
          ( p__subProcess(BURN,SMOKING)
          & p__d__instance(BURN,c__Combustion)
          & p__result(BURN,SMOKE)
          & p__patient(BREATHE,SMOKE)
          & p__d__instance(BREATHE,c__Breathing)
          & p__subProcess(BREATHE,SMOKING) ) ) ).

fof(miloA2299,axiom,
    p__d__subclass(c__Jury,c__GroupOfPeople) ).

fof(miloA2301,axiom,
    p__d__subclass(c__CriminalGang,c__GroupOfPeople) ).

fof(miloA2303,axiom,
    p__d__subclass(c__LegalCharge,c__LegalAction) ).

fof(miloA2304,axiom,
    ! [CHARGE] :
      ( p__d__instance(CHARGE,c__LegalCharge)
     => ? [GOV] :
          ( p__d__instance(GOV,c__Government)
          & p__agent(CHARGE,GOV) ) ) ).

fof(miloA2305,axiom,
    p__d__subclass(c__LegalAppeal,c__Requesting) ).

fof(miloA2306,axiom,
    p__d__subclass(c__LegalAppeal,c__JudicialProcess) ).

fof(miloA2307,axiom,
    p__d__subclass(c__Pleading,c__Stating) ).

fof(miloA2308,axiom,
    ! [P] :
      ( p__d__instance(P,c__Pleading)
     => ? [J] :
          ( p__d__instance(J,c__JudicialProcess)
          & p__subProcess(P,J) ) ) ).

fof(miloA2309,axiom,
    ! [P] :
      ( p__d__instance(P,c__Pleading)
     => ? [C] :
          ( p__d__instance(C,c__CriminalAction)
          & p__refers(P,C) ) ) ).

fof(miloA2310,axiom,
    p__d__instance(c__describes,c__BinaryPredicate) ).

fof(miloA2313,axiom,
    ! [FORMULA,OBJECT] :
      ( ( p__d__instance(OBJECT,c__Object)
        & p__d__instance(FORMULA,c__Formula)
        & p__describes(FORMULA,OBJECT) )
     => ? [STATING,AGENT] :
          ( p__d__instance(AGENT,c__Agent)
          & p__d__instance(STATING,c__Stating)
          & p__agent(STATING,AGENT)
          & p__patient(STATING,FORMULA)
          & p__refers(STATING,OBJECT) ) ) ).

fof(miloA2314,axiom,
    p__d__subclass(c__Testifying,c__Stating) ).

fof(miloA2315,axiom,
    ! [TESTIFY] :
      ( p__d__instance(TESTIFY,c__Testifying)
     => ? [PROC] :
          ( p__d__instance(PROC,c__JudicialProcess)
          & p__subProcess(TESTIFY,PROC) ) ) ).

fof(miloA2316,axiom,
    p__d__subclass(c__CourtRoom,c__Room) ).

fof(miloA2317,axiom,
    ! [PROCESS] :
      ( p__d__instance(PROCESS,c__JudicialProcess)
     => ? [ROOM] :
          ( p__d__instance(ROOM,c__CourtRoom)
          & p__eventLocated(PROCESS,ROOM) ) ) ).

fof(miloA2318,axiom,
    p__d__subclass(c__LegalOpinion,c__Argument) ).

fof(miloA2319,axiom,
    ! [OPINION] :
      ( p__d__instance(OPINION,c__LegalOpinion)
     => ? [DECISION,TEXT,PROPOSITION] :
          ( p__d__instance(TEXT,c__ContentBearingPhysical)
          & p__d__instance(PROPOSITION,c__Argument)
          & p__d__instance(DECISION,c__LegalDecision)
          & p__result(DECISION,TEXT)
          & p__containsInformation(TEXT,PROPOSITION)
          & p__conclusion(PROPOSITION,OPINION) ) ) ).

fof(miloA2320,axiom,
    p__d__subclass(c__LegalAward,c__LegalDecision) ).

fof(miloA2322,axiom,
    p__d__subclass(c__LegalConviction,c__LegalDecision) ).

fof(miloA2323,axiom,
    p__d__subclass(c__LegalDismissal,c__LegalDecision) ).

fof(miloA2324,axiom,
    p__d__subclass(c__LegalSummons,c__Ordering) ).

fof(miloA2325,axiom,
    p__d__subclass(c__LegalSummons,c__JudicialProcess) ).

fof(miloA2327,axiom,
    p__d__subclass(c__LegalAquittal,c__LegalDecision) ).

fof(miloA2328,axiom,
    p__d__subclass(c__Sentencing,c__LegalDecision) ).

fof(miloA2329,axiom,
    ! [P,S] :
      ( ( p__d__instance(S,c__Sentencing)
        & p__patient(S,P) )
     => ? [C] :
          ( p__causes(C,S)
          & p__d__instance(C,c__LegalConviction)
          & p__patient(C,P)
          & p__earlier(f__WhenFn1(C),f__WhenFn1(S)) ) ) ).

fof(miloA2332,axiom,
    p__subrelation(c__defendant,c__patient) ).

fof(miloA2335,axiom,
    p__subrelation(c__plaintiff,c__agent) ).

fof(miloA2336,axiom,
    p__d__subclass(c__GameCall,c__Deciding) ).

fof(miloA2337,axiom,
    p__d__subclass(c__GameCall,c__Declaring) ).

fof(miloA2338,axiom,
    ! [CALL] :
      ( p__d__instance(CALL,c__GameCall)
     => ? [GAME] :
          ( p__d__instance(GAME,c__Game)
          & p__refers(CALL,GAME) ) ) ).

fof(miloA2339,axiom,
    p__d__subclass(c__BeginningOperations,c__OrganizationalProcess) ).

fof(miloA2340,axiom,
    p__d__disjoint(c__BeginningOperations,c__CeasingOperations) ).

fof(miloA2341,axiom,
    p__d__subclass(c__OrganizationalMerging,c__OrganizationalProcess) ).

fof(miloA2343,axiom,
    p__d__subclass(c__CeasingOperations,c__OrganizationalProcess) ).

fof(miloA2344,axiom,
    p__d__subclass(c__BecomingDrunk,c__PsychologicalProcess) ).

fof(miloA2345,axiom,
    p__d__disjoint(c__BecomingDrunk,c__SoberingUp) ).

fof(miloA2347,axiom,
    p__d__instance(c__Sober,c__ConsciousnessAttribute) ).

fof(miloA2348,axiom,
    p__d__subclass(c__SoberingUp,c__PsychologicalProcess) ).

fof(miloA2350,axiom,
    p__d__subclass(c__FallingAsleep,c__PsychologicalProcess) ).

fof(miloA2351,axiom,
    p__d__disjoint(c__FallingAsleep,c__WakingUp) ).

fof(miloA2353,axiom,
    p__d__subclass(c__WakingUp,c__PsychologicalProcess) ).

fof(miloA2355,axiom,
    p__d__subclass(c__GainingConsciousness,c__PsychologicalProcess) ).

fof(miloA2357,axiom,
    p__d__subclass(c__LosingConsciousness,c__PsychologicalProcess) ).

fof(miloA2358,axiom,
    p__d__disjoint(c__LosingConsciousness,c__GainingConsciousness) ).

fof(miloA2360,axiom,
    p__d__instance(c__issuedBy,c__BinaryPredicate) ).

fof(miloA2363,axiom,
    ! [AGENT,CERT] :
      ( ( p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(CERT,c__Certificate)
        & p__issuedBy(CERT,AGENT) )
     => ? [P] :
          ( p__d__instance(P,c__IntentionalProcess)
          & p__agent(P,AGENT)
          & p__result(P,CERT) ) ) ).

fof(miloA2364,axiom,
    p__d__subclass(c__AcademicDegree,c__Certificate) ).

fof(miloA2365,axiom,
    ! [DEGREE,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(DEGREE,c__AcademicDegree)
        & p__possesses(AGENT,DEGREE) )
     => ? [PROGRAM,STUDY] :
          ( p__d__instance(STUDY,c__Process)
          & p__d__instance(PROGRAM,c__EducationalProgram)
          & p__realization(STUDY,PROGRAM)
          & p__experiencer(STUDY,AGENT) ) ) ).

fof(miloA2366,axiom,
    p__d__subclass(c__License,c__Certificate) ).

fof(miloA2367,axiom,
    ! [L] :
      ( p__d__instance(L,c__License)
     => ? [ORG] :
          ( p__d__instance(ORG,c__CognitiveAgent)
          & p__d__instance(ORG,c__GovernmentOrganization)
          & p__issuedBy(L,ORG) ) ) ).

fof(miloA2368,axiom,
    p__d__subclass(c__Ticket,c__Certificate) ).

fof(miloA2370,axiom,
    p__d__subclass(c__Passport,c__License) ).

fof(miloA2372,axiom,
    p__d__subclass(c__PassCertificate,c__Certificate) ).

fof(miloA2374,axiom,
    p__d__subclass(c__Testament,c__Certificate) ).

fof(miloA2375,axiom,
    ! [T] :
      ( p__d__instance(T,c__Testament)
     => ? [B] :
          ( p__d__instance(B,c__Bequeathing)
          & p__refers(T,B) ) ) ).

fof(miloA2376,axiom,
    p__d__instance(c__registeredItem,c__BinaryPredicate) ).

fof(miloA2379,axiom,
    p__subrelation(c__registeredItem,c__refers) ).

fof(miloA2380,axiom,
    p__d__subclass(c__EducationalProgram,c__Plan) ).

fof(miloA2381,axiom,
    ! [PROGRAM] :
      ( p__d__instance(PROGRAM,c__EducationalProgram)
     => ? [COURSE1,COURSE2] :
          ( p__d__instance(COURSE1,c__EducationalCourse)
          & p__d__instance(COURSE2,c__EducationalCourse)
          & COURSE1 != COURSE2
          & p__subPlan(COURSE1,PROGRAM)
          & p__subPlan(COURSE2,PROGRAM) ) ) ).

fof(miloA2382,axiom,
    p__d__subclass(c__EducationalCourse,c__EducationalProgram) ).

fof(miloA2383,axiom,
    ! [COURSE] :
      ( p__d__instance(COURSE,c__EducationalCourse)
     => ? [CLASS,ORG] :
          ( p__realization(CLASS,COURSE)
          & p__d__instance(CLASS,c__EducationalProcess)
          & p__eventLocated(CLASS,ORG)
          & p__d__instance(ORG,c__EducationalOrganization) ) ) ).

fof(miloA2384,axiom,
    p__d__subclass(c__SportsPlay,c__Plan) ).

fof(miloA2385,axiom,
    ! [SP,P] :
      ( ( p__d__instance(P,c__Process)
        & p__d__instance(SP,c__SportsPlay)
        & p__realization(P,SP) )
     => ? [S] :
          ( p__d__instance(S,c__TeamSport)
          & p__d__instance(P,c__Maneuver)
          & p__subProcess(P,S) ) ) ).

fof(miloA2386,axiom,
    p__d__subclass(c__School,c__EducationalOrganization) ).

fof(miloA2387,axiom,
    p__d__subclass(c__PublicSchool,c__School) ).

fof(miloA2388,axiom,
    p__d__subclass(c__PublicSchool,c__GovernmentOrganization) ).

fof(miloA2389,axiom,
    p__d__subclass(c__PrivateSchool,c__School) ).

fof(miloA2390,axiom,
    p__d__disjoint(c__PrivateSchool,c__GovernmentOrganization) ).

fof(miloA2391,axiom,
    p__d__subclass(c__HighSchool,c__School) ).

fof(miloA2392,axiom,
    ! [COLLEGE,STUDENT,ENTER] :
      ( ( p__d__instance(ENTER,c__Matriculation)
        & p__agent(ENTER,COLLEGE)
        & p__patient(ENTER,STUDENT)
        & p__d__instance(COLLEGE,c__College) )
     => ? [GRAD,SCHOOL] :
          ( p__d__instance(GRAD,c__Graduation)
          & p__agent(GRAD,SCHOOL)
          & p__patient(GRAD,STUDENT)
          & p__d__instance(SCHOOL,c__HighSchool)
          & p__earlier(f__WhenFn1(GRAD),f__WhenFn1(ENTER)) ) ) ).

fof(miloA2393,axiom,
    p__d__subclass(c__SecondarySchool,c__School) ).

fof(miloA2394,axiom,
    ! [C,P,E] :
      ( ( p__d__instance(E,c__Matriculation)
        & p__agent(E,C)
        & p__patient(E,P)
        & p__d__instance(C,c__College) )
     => ? [G,S] :
          ( p__d__instance(G,c__Graduation)
          & p__agent(G,S)
          & p__patient(G,P)
          & p__d__instance(S,c__SecondarySchool)
          & p__earlier(f__WhenFn1(G),f__WhenFn1(E)) ) ) ).

fof(miloA2395,axiom,
    p__d__subclass(c__VocationalSchool,c__School) ).

fof(miloA2397,axiom,
    p__d__subclass(c__PostSecondarySchool,c__School) ).

fof(miloA2398,axiom,
    p__d__partition4(c__PostSecondarySchool,c__JuniorCollege,c__College,c__University) ).

fof(miloA2399,axiom,
    p__d__subclass(c__JuniorCollege,c__PostSecondarySchool) ).

fof(miloA2400,axiom,
    p__d__subclass(c__College,c__PostSecondarySchool) ).

fof(miloA2401,axiom,
    p__d__subclass(c__University,c__PostSecondarySchool) ).

fof(miloA2402,axiom,
    p__d__subclass(c__GraduateSchool,c__PostSecondarySchool) ).

fof(miloA2403,axiom,
    ! [S] :
      ( p__d__instance(S,c__GraduateSchool)
     => ? [U] :
          ( p__d__instance(U,c__University)
          & p__part(S,U) ) ) ).

fof(miloA2404,axiom,
    p__d__subclass(c__MedicalSchool,c__GraduateSchool) ).

fof(miloA2405,axiom,
    p__d__subclass(c__ArtSchool,c__School) ).

fof(miloA2406,axiom,
    ! [AS,P] :
      ( ( p__d__instance(AS,c__ArtSchool)
        & p__d__instance(P,c__EducationalProcess)
        & p__eventLocated(P,AS) )
     => ? [M,ART] :
          ( p__d__instance(M,c__Making)
          & p__patient(M,ART)
          & p__d__instance(ART,c__ArtWork)
          & p__refers(P,M) ) ) ).

fof(miloA2407,axiom,
    p__d__subclass(c__DaySchool,c__School) ).

fof(miloA2408,axiom,
    ! [DS] :
      ( ( p__d__instance(DS,c__PermanentResidence)
        & p__d__instance(DS,c__DaySchool) )
     => ! [S] :
          ( ~ p__d__instance(S,c__Human)
          | ~ p__student(S,DS)
          | ~ p__home(S,DS) ) ) ).

fof(miloA2409,axiom,
    p__subrelation(c__student,c__member) ).

fof(miloA2412,axiom,
    ! [ORG,AGENT] :
      ( ( p__d__instance(ORG,c__EducationalOrganization)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__student(AGENT,ORG) )
     => ? [PROCESS] :
          ( p__d__instance(PROCESS,c__EducationalProcess)
          & p__eventLocated(PROCESS,ORG)
          & p__destination(PROCESS,AGENT) ) ) ).

fof(miloA2413,axiom,
    p__subrelation(c__teacher,c__member) ).

fof(miloA2416,axiom,
    ! [ORG,AGENT] :
      ( ( p__d__instance(ORG,c__EducationalOrganization)
        & p__d__instance(AGENT,c__CognitiveAgent)
        & p__teacher(AGENT,ORG) )
     => ? [PROCESS] :
          ( p__d__instance(PROCESS,c__EducationalProcess)
          & p__eventLocated(PROCESS,ORG)
          & p__agent(PROCESS,AGENT) ) ) ).

fof(miloA2417,axiom,
    p__d__subclass(c__DriversLicense,c__License) ).

fof(miloA2419,axiom,
    p__d__subclass(c__InsurancePolicy,c__Certificate) ).

fof(miloA2420,axiom,
    p__d__subclass(c__EconomicRelation,c__BinaryRelation) ).

fof(miloA2421,axiom,
    ! [REL,CLASS] :
      ( ( p__d__instance(CLASS,c__SetOrClass)
        & p__d__instance(REL,c__EconomicRelation)
        & p__domain(REL,c__1,CLASS) )
     => p__d__subclass(CLASS,c__GeopoliticalArea) ) ).

fof(miloA2422,axiom,
    p__d__subclass(c__LaborStriking,c__OrganizationalProcess) ).

fof(miloA2423,axiom,
    ! [STRIKE,ORG,PERSON] :
      ( ( p__d__instance(STRIKE,c__LaborStriking)
        & p__agent(STRIKE,PERSON)
        & p__d__instance(PERSON,c__Human)
        & p__patient(STRIKE,ORG)
        & p__d__instance(ORG,c__Organization) )
     => p__employs(ORG,PERSON) ) ).

fof(miloA2424,axiom,
    p__d__subclass(c__EmploymentFiring,c__TerminatingEmployment) ).

fof(miloA2425,axiom,
    p__d__subclass(c__Resigning,c__TerminatingEmployment) ).

fof(miloA2426,axiom,
    ! [A,R] :
      ( ( p__d__instance(A,c__CognitiveAgent)
        & p__d__instance(R,c__Resigning)
        & p__agent(R,A) )
     => p__wants(A,R) ) ).

fof(miloA2427,axiom,
    p__d__subclass(c__Retiring,c__Resigning) ).

fof(miloA2428,axiom,
    p__d__subclass(c__TransferringPosition,c__OrganizationalProcess) ).

fof(miloA2430,axiom,
    p__d__instance(c__monetaryWage,c__QuaternaryPredicate) ).

fof(miloA2435,axiom,
    ! [TIME,MONEY,ORG,PERSON] :
      ( ( p__d__instance(MONEY,c__CurrencyMeasure)
        & p__d__instance(TIME,c__TimeDuration)
        & p__d__instance(PERSON,c__Human)
        & p__d__instance(ORG,c__Organization)
        & p__monetaryWage(ORG,PERSON,TIME,MONEY) )
     => p__employs(ORG,PERSON) ) ).

fof(miloA2436,axiom,
    p__d__subclass(c__GameArtifact,c__Artifact) ).

fof(miloA2437,axiom,
    p__d__disjointDecomposition3(c__GameArtifact,c__GameBoard,c__GamePiece) ).

fof(miloA2438,axiom,
    ! [ARTIFACT] :
      ( p__d__instance(ARTIFACT,c__GameArtifact)
     => ? [GAME] :
          ( p__d__subclass(GAME,c__Game)
          & p__capability(GAME,c__instrument,ARTIFACT) ) ) ).

fof(miloA2439,axiom,
    p__d__subclass(c__GameBoard,c__GameArtifact) ).

fof(miloA2441,axiom,
    p__d__subclass(c__GamePiece,c__GameArtifact) ).

fof(miloA2442,axiom,
    p__d__subclass(c__GameDie,c__GamePiece) ).

fof(miloA2443,axiom,
    p__d__subclass(c__Ball,c__GamePiece) ).

fof(miloA2445,axiom,
    p__d__subclass(c__ShotBall,c__Ball) ).

fof(miloA2446,axiom,
    p__d__subclass(c__GameShot,c__Impelling) ).

fof(miloA2447,axiom,
    p__d__subclass(c__GameShot,c__Maneuver) ).

fof(miloA2448,axiom,
    ! [SHOT] :
      ( p__d__instance(SHOT,c__GameShot)
     => ? [PIECE] :
          ( p__d__instance(PIECE,c__GamePiece)
          & p__patient(SHOT,PIECE) ) ) ).

fof(miloA2449,axiom,
    ! [SHOT] :
      ( p__d__instance(SHOT,c__GameShot)
     => ? [GAME] :
          ( p__d__instance(GAME,c__Game)
          & p__subProcess(SHOT,GAME) ) ) ).

fof(miloA2451,axiom,
    p__d__subclass(c__Score,c__GameShot) ).

fof(miloA2452,axiom,
    p__d__subclass(c__GameGoal,c__GameArtifact) ).

fof(miloA2454,axiom,
    p__d__subclass(c__SportServe,c__GameShot) ).

fof(miloA2455,axiom,
    ! [SS] :
      ( p__d__instance(SS,c__SportServe)
     => ? [S] :
          ( p__d__instance(S,c__Sport)
          & p__subProcess(SS,S)
          & p__starts(f__WhenFn1(SS),f__WhenFn1(S)) ) ) ).

fof(miloA2456,axiom,
    p__d__subclass(c__Throwing,c__Impelling) ).

fof(miloA2457,axiom,
    p__d__subclass(c__Throwing,c__BodyMotion) ).

fof(miloA2458,axiom,
    ! [THROW] :
      ( p__d__instance(THROW,c__Throwing)
     => ? [ARM] :
          ( p__d__instance(ARM,c__Arm)
          & p__instrument(THROW,ARM) ) ) ).

fof(miloA2459,axiom,
    p__d__subclass(c__Pitching,c__Throwing) ).

fof(miloA2460,axiom,
    p__d__subclass(c__Pitching,c__GameShot) ).

fof(miloA2461,axiom,
    ! [PITCH,BALL] :
      ( ( p__d__instance(PITCH,c__Pitching)
        & p__patient(PITCH,BALL) )
     => p__d__instance(BALL,c__Ball) ) ).

fof(miloA2462,axiom,
    p__d__subclass(c__Catching,c__Touching) ).

fof(miloA2463,axiom,
    p__d__subclass(c__Catching,c__Maneuver) ).

fof(miloA2464,axiom,
    ! [CATCH,BALL] :
      ( ( p__d__instance(CATCH,c__Catching)
        & p__patient(CATCH,BALL) )
     => p__d__instance(BALL,c__Ball) ) ).

fof(miloA2466,axiom,
    p__d__subclass(c__Sign,c__ContentBearingObject) ).

fof(miloA2467,axiom,
    p__d__subclass(c__Sign,c__DisplayArtifact) ).

fof(miloA2468,axiom,
    p__d__subclass(c__PlayingCard,c__GameArtifact) ).

fof(miloA2469,axiom,
    p__d__subclass(c__PlayingCard,c__ContentBearingObject) ).

fof(miloA2471,axiom,
    p__d__subclass(c__Stretching,c__Motion) ).

fof(miloA2472,axiom,
    p__d__subclass(c__Stretching,c__Lengthening) ).

fof(miloA2473,axiom,
    p__d__subclass(c__Accelerating,c__Translocation) ).

fof(miloA2474,axiom,
    p__d__subclass(c__Accelerating,c__Increasing) ).

fof(miloA2476,axiom,
    p__d__subclass(c__Decelerating,c__Translocation) ).

fof(miloA2477,axiom,
    p__d__subclass(c__Decelerating,c__Decreasing) ).

fof(miloA2479,axiom,
    ! [A,E,T] :
      ( ( p__d__instance(T,c__TimeInterval)
        & p__d__instance(E,c__Agent)
        & p__d__instance(A,c__Accelerating)
        & T = f__WhenFn1(A)
        & p__experiencer(A,E) )
     => ! [D] :
          ( ~ p__d__instance(D,c__Process)
          | ~ p__d__instance(D,c__Decelerating)
          | ~ p__experiencer(D,E)
          | T != f__WhenFn1(D) ) ) ).

fof(miloA2480,axiom,
    p__d__subclass(c__Shortening,c__Decreasing) ).

fof(miloA2482,axiom,
    p__d__subclass(c__Flying,c__Translocation) ).

fof(miloA2483,axiom,
    ! [FLY] :
      ( p__d__instance(FLY,c__Flying)
     => ? [REGION] :
          ( p__d__instance(REGION,c__AtmosphericRegion)
          & p__eventLocated(FLY,REGION) ) ) ).

fof(miloA2484,axiom,
    p__d__subclass(c__TakingOff,c__Translocation) ).

fof(miloA2486,axiom,
    p__d__subclass(c__Landing,c__Translocation) ).

fof(miloA2488,axiom,
    p__d__subclass(c__Returning,c__Translocation) ).

fof(miloA2490,axiom,
    p__d__subclass(c__Escaping,c__Translocation) ).

fof(miloA2491,axiom,
    ! [AGENT,ESCAPE] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(ESCAPE,c__Escaping)
        & p__agent(ESCAPE,AGENT) )
     => ? [CONFINE] :
          ( p__d__instance(CONFINE,c__Confining)
          & p__patient(CONFINE,AGENT)
          & p__meetsTemporally(f__WhenFn1(CONFINE),f__WhenFn1(ESCAPE)) ) ) ).

fof(miloA2493,axiom,
    p__d__subclass(c__Leaving,c__Translocation) ).

fof(miloA2494,axiom,
    ! [LEAVE] :
      ( p__d__instance(LEAVE,c__Leaving)
     => ? [GO] :
          ( p__d__instance(GO,c__Translocation)
          & p__subProcess(LEAVE,GO)
          & p__starts(f__WhenFn1(LEAVE),f__WhenFn1(GO)) ) ) ).

fof(miloA2495,axiom,
    p__d__subclass(c__Arriving,c__Translocation) ).

fof(miloA2496,axiom,
    ! [ARRIVE] :
      ( p__d__instance(ARRIVE,c__Arriving)
     => ? [GO] :
          ( p__d__instance(GO,c__Translocation)
          & p__subProcess(ARRIVE,GO)
          & p__finishes(f__WhenFn1(ARRIVE),f__WhenFn1(GO)) ) ) ).

fof(miloA2497,axiom,
    p__d__subclass(c__Immigrating,c__Translocation) ).

fof(miloA2499,axiom,
    ! [I,A] :
      ( ( p__d__instance(A,c__Agent)
        & p__d__instance(I,c__Immigrating)
        & p__agent(I,A) )
     => p__d__instance(A,c__Human) ) ).

fof(miloA2500,axiom,
    p__d__subclass(c__Boarding,c__Translocation) ).

fof(miloA2501,axiom,
    ! [B,V] :
      ( ( p__d__instance(B,c__Boarding)
        & p__patient(B,V) )
     => p__d__instance(V,c__Vehicle) ) ).

fof(miloA2505,axiom,
    p__subrelation(c__onboard,c__located) ).

fof(miloA2506,axiom,
    ! [V,O] :
      ( ( p__d__instance(V,c__Vehicle)
        & p__d__instance(V,c__SelfConnectedObject)
        & p__d__instance(O,c__SelfConnectedObject)
        & p__onboard(O,V) )
     => p__contains(V,O) ) ).

fof(miloA2507,axiom,
    ! [V,T,O] :
      ( ( p__d__instance(V,c__Vehicle)
        & p__d__instance(O,c__SelfConnectedObject)
        & p__onboard(O,V)
        & p__instrument(T,V)
        & p__d__instance(T,c__Transportation) )
     => p__patient(T,O) ) ).

fof(miloA2508,axiom,
    p__d__subclass(c__Deboarding,c__Translocation) ).

fof(miloA2510,axiom,
    ! [B,VEHICLE] :
      ( ( p__d__instance(B,c__Deboarding)
        & p__patient(B,VEHICLE) )
     => p__d__instance(VEHICLE,c__Vehicle) ) ).

fof(miloA2512,axiom,
    p__d__subclass(c__Rotating,c__Motion) ).

fof(miloA2514,axiom,
    p__d__subclass(c__Tremor,c__Rotating) ).

fof(miloA2515,axiom,
    p__d__instance(c__axis,c__BinaryPredicate) ).

fof(miloA2518,axiom,
    ! [OBJ,AXIS] :
      ( ( p__d__instance(OBJ,c__Agent)
        & p__d__instance(AXIS,c__Agent)
        & p__axis(AXIS,OBJ) )
     => ? [R] :
          ( p__d__instance(R,c__Rotating)
          & p__part(AXIS,OBJ)
          & p__experiencer(R,OBJ)
          & ! [R2] :
              ( ~ p__d__instance(R2,c__Process)
              | ~ p__d__instance(R2,c__Rotating)
              | ~ p__subProcess(R2,R)
              | ~ p__experiencer(R2,AXIS) ) ) ) ).

fof(miloA2519,axiom,
    p__d__subclass(c__CentrifugalMotion,c__Rotating) ).

fof(miloA2520,axiom,
    p__d__disjoint(c__CentrifugalMotion,c__CentripetalMotion) ).

fof(miloA2521,axiom,
    ! [CM] :
      ( p__d__instance(CM,c__CentrifugalMotion)
     => ? [R,A,O1,O2] :
          ( p__d__instance(O1,c__Agent)
          & p__d__instance(A,c__Object)
          & p__d__instance(O2,c__Agent)
          & p__d__instance(R,c__Rotating)
          & p__axis(A,O1)
          & p__origin(CM,A)
          & p__experiencer(R,O1)
          & p__experiencer(CM,O2)
          & p__causes(R,CM) ) ) ).

fof(miloA2522,axiom,
    p__d__subclass(c__CentripetalMotion,c__Rotating) ).

fof(miloA2523,axiom,
    ! [CM] :
      ( p__d__instance(CM,c__CentripetalMotion)
     => ? [R,A,O1,O2] :
          ( p__d__instance(O1,c__Agent)
          & p__d__instance(A,c__Object)
          & p__d__instance(O2,c__Agent)
          & p__d__instance(R,c__Rotating)
          & p__axis(A,O1)
          & p__destination(CM,A)
          & p__experiencer(R,O1)
          & p__experiencer(CM,O2)
          & p__causes(R,CM) ) ) ).

fof(miloA2524,axiom,
    p__d__subclass(c__Reversing,c__Motion) ).

fof(miloA2526,axiom,
    p__d__subclass(c__Dripping,c__LiquidMotion) ).

fof(miloA2527,axiom,
    p__d__subclass(c__Stirring,c__LiquidMotion) ).

fof(miloA2528,axiom,
    p__d__subclass(c__Stirring,c__Combining) ).

fof(miloA2529,axiom,
    p__d__subclass(c__Pouring,c__LiquidMotion) ).

fof(miloA2530,axiom,
    p__d__subclass(c__Pouring,c__Transfer) ).

fof(miloA2531,axiom,
    ! [POUR] :
      ( p__d__instance(POUR,c__Pouring)
     => ? [LIQUID,CONTAINER1,CONTAINER2] :
          ( p__origin(POUR,CONTAINER1)
          & p__destination(POUR,CONTAINER2)
          & p__d__instance(CONTAINER1,c__Container)
          & p__d__instance(CONTAINER2,c__Container)
          & CONTAINER1 != CONTAINER2
          & p__patient(POUR,LIQUID)
          & p__attribute(LIQUID,c__Liquid)
          & p__d__instance(LIQUID,c__Substance) ) ) ).

fof(miloA2532,axiom,
    p__d__subclass(c__WaterWave,c__LiquidMotion) ).

fof(miloA2533,axiom,
    ! [WAVE] :
      ( p__d__instance(WAVE,c__WaterWave)
     => ? [AREA] :
          ( p__d__instance(AREA,c__WaterArea)
          & p__eventLocated(WAVE,AREA) ) ) ).

fof(miloA2534,axiom,
    p__d__instance(c__waterDepth,c__BinaryPredicate) ).

fof(miloA2537,axiom,
    p__subrelation(c__waterDepth,c__length) ).

fof(miloA2538,axiom,
    ! [DEPTH,AREA] :
      ( ( p__d__instance(DEPTH,c__LengthMeasure)
        & p__d__instance(AREA,c__WaterArea)
        & p__d__instance(AREA,c__SelfConnectedObject)
        & p__waterDepth(AREA,DEPTH) )
     => ? [BOTTOM,TOP] :
          ( p__d__instance(BOTTOM,c__SelfConnectedObject)
          & p__d__instance(TOP,c__SelfConnectedObject)
          & p__depth(TOP,BOTTOM,DEPTH)
          & p__top(TOP,AREA)
          & p__bottom(BOTTOM,AREA) ) ) ).

fof(miloA2539,axiom,
    p__d__subclass(c__Flooding,c__LiquidMotion) ).

fof(miloA2541,axiom,
    p__d__subclass(c__Spraying,c__LiquidMotion) ).

fof(miloA2542,axiom,
    p__d__subclass(c__Spraying,c__Transfer) ).

fof(miloA2543,axiom,
    p__d__subclass(c__Pulling,c__Motion) ).

fof(miloA2544,axiom,
    p__d__subclass(c__Submarine,c__WaterVehicle) ).

fof(miloA2545,axiom,
    p__d__subclass(c__AirTransportation,c__Transportation) ).

fof(miloA2546,axiom,
    ! [TRANSPORT] :
      ( p__d__instance(TRANSPORT,c__AirTransportation)
     => ? [CRAFT,REGION] :
          ( p__d__instance(CRAFT,c__Aircraft)
          & p__d__instance(REGION,c__AtmosphericRegion)
          & p__instrument(TRANSPORT,CRAFT)
          & p__eventLocated(TRANSPORT,REGION) ) ) ).

fof(miloA2547,axiom,
    p__d__subclass(c__SpaceTransportation,c__Transportation) ).

fof(miloA2548,axiom,
    ! [TRANSPORT] :
      ( p__d__instance(TRANSPORT,c__SpaceTransportation)
     => ? [CRAFT,REGION] :
          ( p__d__instance(CRAFT,c__Spacecraft)
          & p__d__instance(REGION,c__SpaceRegion)
          & p__instrument(TRANSPORT,CRAFT)
          & p__eventLocated(TRANSPORT,REGION) ) ) ).

fof(miloA2549,axiom,
    p__d__subclass(c__Spacecraft,c__Vehicle) ).

fof(miloA2550,axiom,
    ! [CRAFT] :
      ( p__d__instance(CRAFT,c__Spacecraft)
     => p__capability(c__SpaceTransportation,c__instrument,CRAFT) ) ).

fof(miloA2551,axiom,
    p__d__subclass(c__Rocket,c__Spacecraft) ).

fof(miloA2552,axiom,
    p__d__subclass(c__Missile,c__Projectile) ).

fof(miloA2553,axiom,
    p__d__subclass(c__Missile,c__SelfPoweredDevice) ).

fof(miloA2554,axiom,
    ! [M] :
      ( p__d__instance(M,c__Missile)
     => ? [B] :
          ( p__d__instance(B,c__Bomb)
          & p__part(B,M) ) ) ).

fof(miloA2555,axiom,
    p__d__subclass(c__BallisticMissile,c__Missile) ).

fof(miloA2556,axiom,
    p__d__subclass(c__WaterTransportation,c__Transportation) ).

fof(miloA2557,axiom,
    ! [TRANSPORT] :
      ( p__d__instance(TRANSPORT,c__WaterTransportation)
     => ? [CRAFT,AREA] :
          ( p__d__instance(CRAFT,c__WaterVehicle)
          & p__d__instance(AREA,c__WaterArea)
          & p__instrument(TRANSPORT,CRAFT)
          & p__eventLocated(TRANSPORT,AREA) ) ) ).

fof(miloA2558,axiom,
    ! [CRAFT] :
      ( p__d__instance(CRAFT,c__WaterVehicle)
     => p__capability(c__WaterTransportation,c__instrument,CRAFT) ) ).

fof(miloA2559,axiom,
    p__d__subclass(c__Rowing,c__WaterTransportation) ).

fof(miloA2560,axiom,
    ! [R] :
      ( p__d__instance(R,c__Rowing)
     => ? [O] :
          ( p__d__instance(O,c__Oar)
          & p__instrument(R,O) ) ) ).

fof(miloA2561,axiom,
    p__d__subclass(c__LandTransportation,c__Transportation) ).

fof(miloA2562,axiom,
    ! [LAND] :
      ( p__d__instance(LAND,c__LandTransportation)
     => ? [CRAFT,AREA] :
          ( p__d__instance(CRAFT,c__LandVehicle)
          & p__d__instance(AREA,c__LandArea)
          & p__instrument(LAND,CRAFT)
          & p__located(CRAFT,AREA) ) ) ).

fof(miloA2563,axiom,
    ! [VEHICLE] :
      ( p__d__instance(VEHICLE,c__LandVehicle)
     => p__capability(c__LandTransportation,c__instrument,VEHICLE) ) ).

fof(miloA2564,axiom,
    ! [T,P] :
      ( ( p__d__instance(P,c__Object)
        & p__d__instance(T,c__LandTransportation)
        & p__path(T,P) )
     => p__d__instance(P,c__LandTransitway) ) ).

fof(miloA2565,axiom,
    p__d__subclass(c__TransportViaRoadVehicle,c__Transportation) ).

fof(miloA2566,axiom,
    p__d__subclass(c__TransportViaRoadVehicle,c__LandTransportation) ).

fof(miloA2567,axiom,
    p__d__subclass(c__FlyingAircraft,c__Driving) ).

fof(miloA2568,axiom,
    ! [FLY] :
      ( p__d__instance(FLY,c__FlyingAircraft)
     => ? [CRAFT] :
          ( p__d__instance(CRAFT,c__Aircraft)
          & p__patient(FLY,CRAFT) ) ) ).

fof(miloA2569,axiom,
    ! [FLY] :
      ( p__d__instance(FLY,c__FlyingAircraft)
     => ? [FLIGHT] :
          ( p__d__instance(FLIGHT,c__AirTransportation)
          & p__subProcess(FLY,FLIGHT) ) ) ).

fof(miloA2570,axiom,
    p__d__subclass(c__Aircraft,c__Vehicle) ).

fof(miloA2571,axiom,
    ! [CRAFT] :
      ( p__d__instance(CRAFT,c__Aircraft)
     => p__capability(c__AirTransportation,c__instrument,CRAFT) ) ).

fof(miloA2572,axiom,
    p__d__subclass(c__Helicopter,c__Aircraft) ).

fof(miloA2573,axiom,
    p__d__subclass(c__MilitaryArtifact,c__Artifact) ).

fof(miloA2575,axiom,
    p__d__subclass(c__ExplosiveDevice,c__Device) ).

fof(miloA2577,axiom,
    p__d__subclass(c__ExplosiveMine,c__ExplosiveDevice) ).

fof(miloA2578,axiom,
    p__d__subclass(c__ExplosiveMine,c__Weapon) ).

fof(miloA2579,axiom,
    p__d__subclass(c__ExplosiveSubstance,c__Substance) ).

fof(miloA2580,axiom,
    ! [S] :
      ( p__d__instance(S,c__ExplosiveSubstance)
     => p__capability(c__Explosion,c__instrument,S) ) ).

fof(miloA2581,axiom,
    ! [D] :
      ( p__d__instance(D,c__ExplosiveDevice)
     => ? [S] :
          ( p__d__instance(S,c__ExplosiveSubstance)
          & p__part(S,D) ) ) ).

fof(miloA2582,axiom,
    p__d__subclass(c__Driveway,c__Roadway) ).

fof(miloA2583,axiom,
    p__d__instance(c__OperatingFn,c__UnaryFunction) ).

fof(miloA2586,axiom,
    p__d__subclass(c__Installing,c__Putting) ).

fof(miloA2587,axiom,
    ! [INSTALL,DEVICE] :
      ( ( p__d__instance(INSTALL,c__Installing)
        & p__patient(INSTALL,DEVICE) )
     => p__d__instance(DEVICE,c__Device) ) ).

fof(miloA2589,axiom,
    p__d__subclass(c__Rock,c__Substance) ).

fof(miloA2590,axiom,
    ! [Rock] :
      ( p__d__instance(Rock,c__Rock)
     => p__attribute(Rock,c__Solid) ) ).

fof(miloA2591,axiom,
    ! [Rock] :
      ( p__d__instance(Rock,c__Rock)
     => ? [Mineral] :
          ( p__d__instance(Mineral,c__Mineral)
          & p__part(Mineral,Rock) ) ) ).

fof(miloA2592,axiom,
    p__d__subclass(c__Soil,c__Mixture) ).

fof(miloA2593,axiom,
    ! [Soil] :
      ( p__d__instance(Soil,c__Soil)
     => ? [Humus,Mineral] :
          ( p__d__instance(Humus,c__Humus)
          & p__d__instance(Mineral,c__Mineral)
          & p__part(Humus,Soil)
          & p__part(Mineral,Soil) ) ) ).

fof(miloA2594,axiom,
    p__d__subclass(c__Clay,c__Soil) ).

fof(miloA2595,axiom,
    p__d__subclass(c__Humus,c__Mixture) ).

fof(miloA2596,axiom,
    ! [Humus] :
      ( p__d__instance(Humus,c__Humus)
     => ? [Soil] :
          ( p__d__instance(Soil,c__Soil)
          & p__part(Humus,Soil) ) ) ).

fof(miloA2597,axiom,
    p__d__subclass(c__Burying,c__Putting) ).

fof(miloA2598,axiom,
    p__d__subclass(c__Burying,c__Digging) ).

fof(miloA2599,axiom,
    ! [B] :
      ( p__d__instance(B,c__Burying)
     => ? [C,S] :
          ( p__d__instance(C,c__Covering)
          & p__instrument(C,S)
          & p__d__instance(S,c__Soil)
          & p__subProcess(C,B) ) ) ).

fof(miloA2600,axiom,
    p__d__subclass(c__Digging,c__IntentionalProcess) ).

fof(miloA2601,axiom,
    p__d__subclass(c__Digging,c__SurfaceChange) ).

fof(miloA2602,axiom,
    ! [D] :
      ( p__d__instance(D,c__Digging)
     => ? [S] :
          ( p__patient(D,S)
          & p__d__instance(S,c__Soil) ) ) ).

fof(miloA2603,axiom,
    p__d__subclass(c__Tilling,c__Digging) ).

fof(miloA2604,axiom,
    p__d__subclass(c__Tilling,c__IntentionalProcess) ).

fof(miloA2605,axiom,
    p__d__subclass(c__Tilling,c__SurfaceChange) ).

fof(miloA2606,axiom,
    ! [TILL,SOIL] :
      ( ( p__d__instance(TILL,c__Tilling)
        & p__patient(TILL,SOIL) )
     => p__d__instance(SOIL,c__Soil) ) ).

fof(miloA2607,axiom,
    ! [T] :
      ( p__d__instance(T,c__Tilling)
     => ? [A] :
          ( p__d__instance(A,c__Agriculture)
          & p__subProcess(T,A) ) ) ).

fof(miloA2608,axiom,
    p__d__subclass(c__Entombing,c__Putting) ).

fof(miloA2609,axiom,
    ! [E,C] :
      ( ( p__d__instance(E,c__Entombing)
        & p__patient(E,C) )
     => p__d__instance(C,c__HumanCorpse) ) ).

fof(miloA2610,axiom,
    ! [E,T] :
      ( ( p__d__instance(E,c__Entombing)
        & p__destination(E,T) )
     => p__d__instance(T,c__Tomb) ) ).

fof(miloA2611,axiom,
    p__d__subclass(c__MovingResidence,c__Transfer) ).

fof(miloA2613,axiom,
    p__d__subclass(c__Harvesting,c__Removing) ).

fof(miloA2614,axiom,
    ! [H] :
      ( p__d__instance(H,c__Harvesting)
     => ? [A] :
          ( p__d__instance(A,c__Agriculture)
          & p__subProcess(H,A) ) ) ).

fof(miloA2615,axiom,
    ! [H,C] :
      ( ( p__d__instance(H,c__Harvesting)
        & p__result(H,C) )
     => ( p__d__instance(C,c__PlantAnatomicalStructure)
        | p__d__instance(C,c__PlantSubstance) ) ) ).

fof(miloA2616,axiom,
    p__d__subclass(c__Drilling,c__IntentionalProcess) ).

fof(miloA2617,axiom,
    p__d__subclass(c__Drilling,c__SurfaceChange) ).

fof(miloA2619,axiom,
    p__d__subclass(c__Drill,c__CuttingDevice) ).

fof(miloA2621,axiom,
    p__d__subclass(c__Saw,c__CuttingDevice) ).

fof(miloA2623,axiom,
    p__d__subclass(c__PaperShredder,c__CuttingDevice) ).

fof(miloA2626,axiom,
    p__d__subclass(c__Memorizing,c__Learning) ).

fof(miloA2627,axiom,
    ! [M,T] :
      ( ( p__d__instance(M,c__Memorizing)
        & p__patient(M,T) )
     => p__d__instance(T,c__Text) ) ).

fof(miloA2628,axiom,
    p__d__subclass(c__Imagining,c__PsychologicalProcess) ).

fof(miloA2629,axiom,
    p__d__subclass(c__Dreaming,c__Imagining) ).

fof(miloA2630,axiom,
    p__d__disjoint(c__Dreaming,c__IntentionalProcess) ).

fof(miloA2632,axiom,
    p__d__subclass(c__Frightening,c__PsychologicalProcess) ).

fof(miloA2634,axiom,
    p__d__subclass(c__Execution,c__Killing) ).

fof(miloA2635,axiom,
    ! [E] :
      ( p__d__instance(E,c__Execution)
     => ? [P] :
          ( p__patient(E,P)
          & p__d__instance(P,c__Human) ) ) ).

fof(miloA2636,axiom,
    p__d__subclass(c__Suicide,c__Killing) ).

fof(miloA2637,axiom,
    ! [S] :
      ( p__d__instance(S,c__Suicide)
     => ? [A] :
          ( p__d__instance(A,c__Agent)
          & p__agent(S,A)
          & p__experiencer(S,A) ) ) ).

fof(miloA2638,axiom,
    p__d__subclass(c__Trespassing,c__CriminalAction) ).

fof(miloA2639,axiom,
    p__d__subclass(c__Trespassing,c__Translocation) ).

fof(miloA2641,axiom,
    p__d__subclass(c__Protecting,c__Maintaining) ).

fof(miloA2643,axiom,
    p__d__subclass(c__Murder,c__Killing) ).

fof(miloA2644,axiom,
    p__d__subclass(c__Murder,c__CriminalAction) ).

fof(miloA2645,axiom,
    ! [MURDER] :
      ( p__d__instance(MURDER,c__Murder)
     => ? [PERSON] :
          ( p__patient(MURDER,PERSON)
          & p__d__instance(PERSON,c__Human) ) ) ).

fof(miloA2646,axiom,
    p__d__subclass(c__Suffocating,c__Killing) ).

fof(miloA2648,axiom,
    p__d__subclass(c__Hanging,c__Suffocating) ).

fof(miloA2650,axiom,
    p__d__subclass(c__Starving,c__Killing) ).

fof(miloA2651,axiom,
    p__d__subclass(c__MusicalConducting,c__Guiding) ).

fof(miloA2652,axiom,
    ! [CONDUCT] :
      ( p__d__instance(CONDUCT,c__MusicalConducting)
     => ? [MUSIC] :
          ( p__d__instance(MUSIC,c__MusicalPerformance)
          & p__subProcess(CONDUCT,MUSIC) ) ) ).

fof(miloA2654,axiom,
    p__d__subclass(c__OrchestralConducting,c__MusicalConducting) ).

fof(miloA2655,axiom,
    ! [CONDUCT,GRP] :
      ( ( p__d__instance(CONDUCT,c__OrchestralConducting)
        & p__patient(CONDUCT,GRP) )
     => p__d__instance(GRP,c__Orchestra) ) ).

fof(miloA2656,axiom,
    p__d__subclass(c__MusicalGroup,c__GroupOfPeople) ).

fof(miloA2657,axiom,
    p__d__subclass(c__Orchestra,c__MusicalGroup) ).

fof(miloA2659,axiom,
    p__d__subclass(c__DramaticDirecting,c__Guiding) ).

fof(miloA2660,axiom,
    ! [DIRECT,ACT] :
      ( ( p__d__instance(DIRECT,c__DramaticDirecting)
        & p__patient(DIRECT,ACT) )
     => p__d__instance(ACT,c__DramaticActing) ) ).

fof(miloA2661,axiom,
    p__d__subclass(c__Sharing,c__ChangeOfPossession) ).

fof(miloA2662,axiom,
    ! [SHARE,OBJ,AGENT1,AGENT2] :
      ( ( p__d__instance(AGENT1,c__Agent)
        & p__d__instance(OBJ,c__Object)
        & p__d__instance(SHARE,c__Sharing)
        & p__agent(SHARE,AGENT1)
        & p__destination(SHARE,AGENT2)
        & p__patient(SHARE,OBJ) )
     => ? [GIVE,PART] :
          ( p__d__instance(PART,c__Object)
          & p__d__instance(GIVE,c__Giving)
          & p__subProcess(GIVE,SHARE)
          & p__patient(GIVE,PART)
          & p__properPart(PART,OBJ)
          & p__agent(GIVE,AGENT1)
          & p__destination(GIVE,AGENT2) ) ) ).

fof(miloA2663,axiom,
    p__d__subclass(c__Stealing,c__UnilateralGetting) ).

fof(miloA2664,axiom,
    p__d__subclass(c__Stealing,c__CriminalAction) ).

fof(miloA2666,axiom,
    p__d__subclass(c__Robbing,c__Stealing) ).

fof(miloA2668,axiom,
    p__d__subclass(c__Inheriting,c__UnilateralGetting) ).

fof(miloA2670,axiom,
    p__d__subclass(c__Awarding,c__UnilateralGiving) ).

fof(miloA2671,axiom,
    ! [A] :
      ( p__d__instance(A,c__Awarding)
     => ? [RECIPIENT,GIVER,PROCESS,AWARD] :
          ( p__d__instance(RECIPIENT,c__Agent)
          & p__d__instance(GIVER,c__Agent)
          & p__d__instance(PROCESS,c__Process)
          & p__d__instance(AWARD,c__Object)
          & p__agent(PROCESS,RECIPIENT)
          & p__agent(A,GIVER)
          & p__patient(A,AWARD)
          & p__destination(A,RECIPIENT)
          & p__causes(PROCESS,A) ) ) ).

fof(miloA2672,axiom,
    p__d__instance(c__hasAward,c__BinaryPredicate) ).

fof(miloA2675,axiom,
    ! [RECIPIENT,AWARD] :
      ( ( p__d__instance(AWARD,c__Object)
        & p__d__instance(RECIPIENT,c__Agent)
        & p__hasAward(RECIPIENT,AWARD) )
     => ? [A] :
          ( p__d__instance(A,c__Awarding)
          & p__destination(A,RECIPIENT)
          & p__patient(A,AWARD) ) ) ).

fof(miloA2676,axiom,
    p__d__subclass(c__Bequeathing,c__UnilateralGiving) ).

fof(miloA2678,axiom,
    p__d__subclass(c__SeizingProperty,c__UnilateralGetting) ).

fof(miloA2680,axiom,
    p__d__partition3(c__Position,c__FullTimePosition,c__PartTimePosition) ).

fof(miloA2681,axiom,
    p__d__subclass(c__FullTimePosition,c__Position) ).

fof(miloA2682,axiom,
    p__d__subclass(c__PartTimePosition,c__Position) ).

fof(miloA2683,axiom,
    p__d__instance(c__CollegeFreshman,c__CollegeStudentPosition) ).

fof(miloA2685,axiom,
    p__d__instance(c__CollegeJunior,c__CollegeStudentPosition) ).

fof(miloA2687,axiom,
    p__d__instance(c__CollegeSenior,c__CollegeStudentPosition) ).

fof(miloA2689,axiom,
    p__d__instance(c__CollegeSophomore,c__CollegeStudentPosition) ).

fof(miloA2691,axiom,
    p__d__subclass(c__CollegeStudentPosition,c__Position) ).

fof(miloA2692,axiom,
    p__d__instance(c__Comedian,c__EntertainmentProfession) ).

fof(miloA2693,axiom,
    ! [P] :
      ( ( p__d__instance(P,c__Agent)
        & p__attribute(P,c__Comedian) )
     => ? [PERF,L] :
          ( p__d__instance(PERF,c__Performance)
          & p__agent(PERF,P)
          & p__d__instance(L,c__Laughing)
          & p__causes(PERF,L) ) ) ).

fof(miloA2694,axiom,
    p__d__instance(c__Treasurer,c__SkilledOccupation) ).

fof(miloA2695,axiom,
    p__d__subclass(c__SalesPosition,c__SkilledOccupation) ).

fof(miloA2696,axiom,
    p__d__instance(c__ClericalSecretary,c__SkilledOccupation) ).

fof(miloA2697,axiom,
    p__d__subclass(c__ServicePosition,c__SkilledOccupation) ).

fof(miloA2698,axiom,
    p__d__instance(c__Dentist,c__Profession) ).

fof(miloA2699,axiom,
    ! [P] :
      ( ( p__d__instance(P,c__Agent)
        & p__attribute(P,c__Dentist) )
     => ? [D,T] :
          ( p__d__instance(D,c__DiagnosticProcess)
          & p__agent(D,P)
          & p__d__instance(T,c__Tooth)
          & p__patient(D,T) ) ) ).

fof(miloA2700,axiom,
    p__d__instance(c__Pharmacist,c__Profession) ).

fof(miloA2701,axiom,
    p__d__instance(c__Researcher,c__Profession) ).

fof(miloA2702,axiom,
    ! [P] :
      ( ( p__d__instance(P,c__Human)
        & p__attribute(P,c__Researcher) )
     => ? [S] :
          ( p__d__instance(S,c__Science)
          & p__hasExpertise(P,S) ) ) ).

fof(miloA2703,axiom,
    p__d__instance(c__Teacher,c__Profession) ).

fof(miloA2706,axiom,
    p__d__subclass(c__EntertainmentProfession,c__SkilledOccupation) ).

fof(miloA2708,axiom,
    p__d__subclass(c__SportsPosition,c__SkilledOccupation) ).

fof(miloA2709,axiom,
    ! [H,P,O] :
      ( ( p__d__instance(O,c__Organization)
        & p__d__instance(H,c__Human)
        & p__occupiesPosition(H,P,O)
        & p__d__instance(P,c__SportsPosition) )
     => p__d__instance(O,c__SportsTeam) ) ).

fof(miloA2710,axiom,
    p__d__subclass(c__GovernmentPosition,c__Profession) ).

fof(miloA2711,axiom,
    ! [P,O,ORG] :
      ( ( p__d__instance(ORG,c__Organization)
        & p__d__instance(P,c__Human)
        & p__d__instance(O,c__GovernmentPosition)
        & p__occupiesPosition(P,O,ORG) )
     => p__d__instance(ORG,c__GovernmentOrganization) ) ).

fof(miloA2712,axiom,
    p__d__instance(c__Journalist,c__Profession) ).

fof(miloA2714,axiom,
    p__d__subclass(c__ModellingPosition,c__Position) ).

fof(miloA2715,axiom,
    p__d__instance(c__Soldier,c__GovernmentPosition) ).

fof(miloA2716,axiom,
    p__d__instance(c__ConfederateSoldier,c__GovernmentPosition) ).

fof(miloA2717,axiom,
    p__subAttribute(c__ConfederateSoldier,c__Soldier) ).

fof(miloA2718,axiom,
    p__d__instance(c__Sailor,c__SkilledOccupation) ).

fof(miloA2719,axiom,
    p__subAttribute(c__ShipCaptain,c__Sailor) ).

fof(miloA2720,axiom,
    p__subAttribute(c__ShipOfficer,c__Sailor) ).

fof(miloA2721,axiom,
    p__subAttribute(c__ShipMate,c__Sailor) ).

fof(miloA2722,axiom,
    p__d__instance(c__MilitaryPrivate,c__GovernmentPosition) ).

fof(miloA2723,axiom,
    p__subAttribute(c__MilitaryPrivate,c__Soldier) ).

fof(miloA2724,axiom,
    p__subAttribute(c__MilitaryOfficer,c__Soldier) ).

fof(miloA2725,axiom,
    p__d__instance(c__MilitaryOfficer,c__GovernmentPosition) ).

fof(miloA2727,axiom,
    p__subAttribute(c__MilitaryGeneral,c__MilitaryOfficer) ).

fof(miloA2728,axiom,
    p__subAttribute(c__MajorGeneral,c__MilitaryGeneral) ).

fof(miloA2729,axiom,
    p__d__instance(c__MajorGeneral,c__GovernmentPosition) ).

fof(miloA2730,axiom,
    p__subAttribute(c__BrigadierGeneral,c__MilitaryGeneral) ).

fof(miloA2731,axiom,
    p__d__instance(c__BrigadierGeneral,c__GovernmentPosition) ).

fof(miloA2732,axiom,
    p__subAttribute(c__Lieutenant,c__MilitaryOfficer) ).

fof(miloA2733,axiom,
    p__d__instance(c__Lieutenant,c__GovernmentPosition) ).

fof(miloA2734,axiom,
    p__subAttribute(c__CaptainOfficer,c__MilitaryOfficer) ).

fof(miloA2735,axiom,
    p__d__instance(c__CaptainOfficer,c__GovernmentPosition) ).

fof(miloA2736,axiom,
    p__subAttribute(c__Colonel,c__MilitaryOfficer) ).

fof(miloA2737,axiom,
    p__d__instance(c__Colonel,c__GovernmentPosition) ).

fof(miloA2738,axiom,
    p__subAttribute(c__Sergeant,c__MilitaryOfficer) ).

fof(miloA2739,axiom,
    p__d__instance(c__Sergeant,c__GovernmentPosition) ).

fof(miloA2740,axiom,
    p__subAttribute(c__Corporal,c__MilitaryOfficer) ).

fof(miloA2741,axiom,
    p__d__instance(c__Corporal,c__GovernmentPosition) ).

fof(miloA2742,axiom,
    p__d__instance(c__CenturyDuration,c__UnitOfDuration) ).

fof(miloA2743,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__CenturyDuration) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__100),c__YearDuration) ) ).

fof(miloA2744,axiom,
    p__d__instance(c__DecadeDuration,c__UnitOfDuration) ).

fof(miloA2745,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__DecadeDuration) = f__MeasureFn2(f__MultiplicationFn2(NUMBER,c__10),c__YearDuration) ) ).

fof(miloA2746,axiom,
    p__d__instance(c__YardLength,c__UnitOfLength) ).

fof(miloA2747,axiom,
    ! [NUMBER] :
      ( ( p__d__instance(NUMBER,c__RealNumber)
        & NUMBER = f__MultiplicationFn2(c__1,NUMBER) )
     => f__MeasureFn2(NUMBER,c__YardLength) = f__MeasureFn2(f__MultiplicationFn2(c__3,NUMBER),c__FootLength) ) ).

fof(miloA2748,axiom,
    p__d__instance(c__Nanometer,c__UnitOfLength) ).

fof(miloA2749,axiom,
    p__d__subclass(c__NightTime,c__TimeInterval) ).

fof(miloA2750,axiom,
    ! [NIGHT] :
      ( p__d__instance(NIGHT,c__NightTime)
     => ? [DAY1,DAY2] :
          ( p__d__instance(DAY1,c__DayTime)
          & p__d__instance(DAY2,c__DayTime)
          & p__meetsTemporally(NIGHT,DAY1)
          & p__meetsTemporally(DAY2,NIGHT) ) ) ).

fof(miloA2751,axiom,
    ! [NIGHT] :
      ( p__d__instance(NIGHT,c__NightTime)
     => ? [RISE,SET] :
          ( p__d__instance(RISE,c__Sunrise)
          & p__d__instance(SET,c__Sunset)
          & p__starts(SET,NIGHT)
          & p__finishes(RISE,NIGHT) ) ) ).

fof(miloA2752,axiom,
    p__d__subclass(c__DayTime,c__TimeInterval) ).

fof(miloA2753,axiom,
    ! [DAY] :
      ( p__d__instance(DAY,c__DayTime)
     => ? [NIGHT1,NIGHT2] :
          ( p__d__instance(NIGHT1,c__NightTime)
          & p__d__instance(NIGHT2,c__NightTime)
          & p__meetsTemporally(DAY,NIGHT1)
          & p__meetsTemporally(NIGHT2,DAY) ) ) ).

fof(miloA2754,axiom,
    ! [DAY] :
      ( p__d__instance(DAY,c__DayTime)
     => ? [RISE,SET] :
          ( p__d__instance(RISE,c__Sunrise)
          & p__d__instance(SET,c__Sunset)
          & p__starts(RISE,DAY)
          & p__finishes(SET,DAY) ) ) ).

fof(miloA2755,axiom,
    p__d__subclass(c__Morning,c__DayTime) ).

fof(miloA2757,axiom,
    p__d__subclass(c__AnteMeridiem,c__TimeInterval) ).

fof(miloA2759,axiom,
    p__d__subclass(c__PostMeridiem,c__TimeInterval) ).

fof(miloA2761,axiom,
    p__d__subclass(c__Afternoon,c__DayTime) ).

fof(miloA2763,axiom,
    p__d__subclass(c__Sunrise,c__TimeInterval) ).

fof(miloA2764,axiom,
    p__d__subclass(c__Sunset,c__TimeInterval) ).

fof(miloA2765,axiom,
    p__d__subclass(c__Weekend,c__TimeInterval) ).

fof(miloA2766,axiom,
    ! [WEEKEND] :
      ( p__d__instance(WEEKEND,c__Weekend)
     => ? [SATURDAY,SUNDAY] :
          ( p__d__instance(SATURDAY,c__Saturday)
          & p__d__instance(SUNDAY,c__Sunday)
          & p__starts(SATURDAY,WEEKEND)
          & p__finishes(SUNDAY,WEEKEND)
          & p__meetsTemporally(SATURDAY,SUNDAY) ) ) ).

fof(miloA2767,axiom,
    p__d__subclass(c__SeasonOfYear,c__TimeInterval) ).

fof(miloA2768,axiom,
    p__d__partition5(c__SeasonOfYear,c__WinterSeason,c__SpringSeason,c__SummerSeason,c__FallSeason) ).

fof(miloA2769,axiom,
    p__d__subclass(c__WinterSeason,c__SeasonOfYear) ).

fof(miloA2770,axiom,
    ! [WINTER] :
      ( p__d__instance(WINTER,c__WinterSeason)
     => ? [SPRING] :
          ( p__d__instance(SPRING,c__SpringSeason)
          & p__meetsTemporally(WINTER,SPRING) ) ) ).

fof(miloA2771,axiom,
    ! [WINTER] :
      ( p__d__instance(WINTER,c__WinterSeason)
     => ? [AUTUMN] :
          ( p__d__instance(AUTUMN,c__FallSeason)
          & p__meetsTemporally(AUTUMN,WINTER) ) ) ).

fof(miloA2772,axiom,
    p__d__subclass(c__SpringSeason,c__SeasonOfYear) ).

fof(miloA2773,axiom,
    ! [SPRING] :
      ( p__d__instance(SPRING,c__SpringSeason)
     => ? [SUMMER] :
          ( p__d__instance(SUMMER,c__SummerSeason)
          & p__meetsTemporally(SPRING,SUMMER) ) ) ).

fof(miloA2774,axiom,
    ! [SPRING] :
      ( p__d__instance(SPRING,c__SpringSeason)
     => ? [WINTER] :
          ( p__d__instance(WINTER,c__WinterSeason)
          & p__meetsTemporally(WINTER,SPRING) ) ) ).

fof(miloA2775,axiom,
    p__d__subclass(c__SummerSeason,c__SeasonOfYear) ).

fof(miloA2776,axiom,
    ! [SUMMER] :
      ( p__d__instance(SUMMER,c__SummerSeason)
     => ? [SPRING] :
          ( p__d__instance(SPRING,c__SpringSeason)
          & p__meetsTemporally(SPRING,SUMMER) ) ) ).

fof(miloA2777,axiom,
    ! [SUMMER] :
      ( p__d__instance(SUMMER,c__SummerSeason)
     => ? [AUTUMN] :
          ( p__d__instance(AUTUMN,c__FallSeason)
          & p__meetsTemporally(SUMMER,AUTUMN) ) ) ).

fof(miloA2778,axiom,
    p__d__subclass(c__FallSeason,c__SeasonOfYear) ).

fof(miloA2779,axiom,
    ! [AUTUMN] :
      ( p__d__instance(AUTUMN,c__FallSeason)
     => ? [SUMMER] :
          ( p__d__instance(SUMMER,c__SummerSeason)
          & p__meetsTemporally(SUMMER,AUTUMN) ) ) ).

fof(miloA2780,axiom,
    ! [AUTUMN] :
      ( p__d__instance(AUTUMN,c__FallSeason)
     => ? [WINTER] :
          ( p__d__instance(WINTER,c__WinterSeason)
          & p__meetsTemporally(AUTUMN,WINTER) ) ) ).

fof(miloA2781,axiom,
    p__d__instance(c__Upstairs,c__PositionalAttribute) ).

fof(miloA2782,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__Upstairs) )
     => ? [LEVEL1,LEVEL2,BUILDING] :
          ( p__d__instance(LEVEL1,c__BuildingLevel)
          & p__d__instance(LEVEL2,c__BuildingLevel)
          & p__d__instance(BUILDING,c__Building)
          & p__part(LEVEL1,BUILDING)
          & p__part(LEVEL2,BUILDING)
          & p__located(OBJ1,LEVEL1)
          & p__located(OBJ2,LEVEL2)
          & p__orientation(LEVEL1,LEVEL2,c__Above) ) ) ).

fof(miloA2783,axiom,
    p__d__instance(c__Downstairs,c__PositionalAttribute) ).

fof(miloA2784,axiom,
    ! [OBJ1,OBJ2] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__Object)
        & p__orientation(OBJ1,OBJ2,c__Downstairs) )
     => ? [LEVEL1,LEVEL2,BUILDING] :
          ( p__d__instance(LEVEL1,c__BuildingLevel)
          & p__d__instance(LEVEL2,c__BuildingLevel)
          & p__d__instance(BUILDING,c__Building)
          & p__part(LEVEL1,BUILDING)
          & p__part(LEVEL2,BUILDING)
          & p__located(OBJ1,LEVEL1)
          & p__located(OBJ2,LEVEL2)
          & p__orientation(LEVEL1,LEVEL2,c__Below) ) ) ).

fof(miloA2785,axiom,
    p__d__subclass(c__LinguisticAttribute,c__InternalAttribute) ).

fof(miloA2786,axiom,
    p__d__instance(c__Happiness,c__EmotionalState) ).

fof(miloA2787,axiom,
    ! [PERSON] :
      ( ( p__d__instance(PERSON,c__CognitiveAgent)
        & p__attribute(PERSON,c__Happiness) )
     => ! [PROP] :
          ( ~ p__d__instance(PROP,c__Formula)
          | ~ p__fears(PERSON,PROP) ) ) ).

fof(miloA2788,axiom,
    p__subAttribute(c__Satisfaction,c__Happiness) ).

fof(miloA2789,axiom,
    p__subAttribute(c__Tranquility,c__Happiness) ).

fof(miloA2790,axiom,
    p__contraryAttribute2(c__Tranquility,c__Anxiety) ).

fof(miloA2791,axiom,
    p__d__instance(c__Unhappiness,c__EmotionalState) ).

fof(miloA2792,axiom,
    p__contraryAttribute2(c__Unhappiness,c__Happiness) ).

fof(miloA2793,axiom,
    p__subAttribute(c__Excitement,c__Happiness) ).

fof(miloA2794,axiom,
    p__subAttribute(c__Anxiety,c__Unhappiness) ).

fof(miloA2795,axiom,
    ! [PERSON] :
      ( ( p__d__instance(PERSON,c__CognitiveAgent)
        & p__attribute(PERSON,c__Anxiety) )
     => ? [PROP] :
          ( p__d__instance(PROP,c__Formula)
          & p__fears(PERSON,PROP) ) ) ).

fof(miloA2796,axiom,
    p__subAttribute(c__Anger,c__Unhappiness) ).

fof(miloA2797,axiom,
    ! [PERSON] :
      ( ( p__d__instance(PERSON,c__CognitiveAgent)
        & p__attribute(PERSON,c__Anger) )
     => ? [PROP] :
          ( p__d__instance(PROP,c__Formula)
          & p__disapproves(PERSON,PROP) ) ) ).

fof(miloA2798,axiom,
    p__subAttribute(c__Pain,c__Unhappiness) ).

fof(miloA2799,axiom,
    p__subAttribute(c__Headache,c__Pain) ).

fof(miloA2800,axiom,
    ! [E] :
      ( ( p__d__instance(E,c__Object)
        & p__attribute(E,c__Headache) )
     => ? [H] :
          ( p__d__instance(H,c__Head)
          & p__properPart(H,E)
          & p__attribute(H,c__Pain) ) ) ).

fof(miloA2801,axiom,
    p__d__instance(c__Surprise,c__EmotionalState) ).

fof(miloA2803,axiom,
    p__d__instance(c__structure,c__BinaryPredicate) ).

fof(miloA2804,axiom,
    p__d__instance(c__structure,c__IrreflexiveRelation) ).

fof(miloA2805,axiom,
    p__d__instance(c__structure,c__AsymmetricRelation) ).

fof(miloA2806,axiom,
    p__subrelation(c__structure,c__attribute) ).

fof(miloA2809,axiom,
    p__subrelation(c__color,c__attribute) ).

fof(miloA2813,axiom,
    p__d__subclass(c__SecondaryColor,c__ColorAttribute) ).

fof(miloA2814,axiom,
    ! [COLOR,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(COLOR,c__SecondaryColor)
        & p__attribute(OBJ,COLOR) )
     => ? [PROCESS,RESOURCE1,RESOURCE2,PRIMARY1,PRIMARY2] :
          ( p__d__instance(PROCESS,c__Process)
          & p__d__instance(RESOURCE1,c__Object)
          & p__d__instance(RESOURCE2,c__Object)
          & p__result(PROCESS,OBJ)
          & p__resource(PROCESS,RESOURCE1)
          & p__resource(PROCESS,RESOURCE2)
          & p__attribute(RESOURCE1,PRIMARY1)
          & p__attribute(RESOURCE2,PRIMARY2)
          & p__d__instance(PRIMARY1,c__PrimaryColor)
          & p__d__instance(PRIMARY2,c__PrimaryColor)
          & PRIMARY1 != PRIMARY2 ) ) ).

fof(miloA2815,axiom,
    p__d__instance(c__GrayColor,c__SecondaryColor) ).

fof(miloA2816,axiom,
    p__d__instance(c__Pink,c__SecondaryColor) ).

fof(miloA2817,axiom,
    p__d__instance(c__Brown,c__SecondaryColor) ).

fof(miloA2818,axiom,
    p__d__instance(c__OrangeColor,c__SecondaryColor) ).

fof(miloA2819,axiom,
    p__d__instance(c__Green,c__SecondaryColor) ).

fof(miloA2820,axiom,
    p__d__instance(c__Purple,c__SecondaryColor) ).

fof(miloA2821,axiom,
    p__d__instance(c__LineFormation,c__ShapeAttribute) ).

fof(miloA2822,axiom,
    ! [COLLECTION] :
      ( ( p__d__instance(COLLECTION,c__Object)
        & p__attribute(COLLECTION,c__LineFormation) )
     => p__d__instance(COLLECTION,c__Collection) ) ).

fof(miloA2823,axiom,
    p__d__instance(c__Stressed,c__SoundAttribute) ).

fof(miloA2824,axiom,
    ! [SYLLABLE] :
      ( ( p__d__instance(SYLLABLE,c__Object)
        & p__attribute(SYLLABLE,c__Stressed) )
     => p__d__instance(SYLLABLE,c__Syllable) ) ).

fof(miloA2825,axiom,
    ! [WORD,SYLLABLE] :
      ( ( p__d__instance(SYLLABLE,c__Object)
        & p__d__instance(WORD,c__Object)
        & p__attribute(SYLLABLE,c__Stressed)
        & p__d__instance(WORD,c__Word)
        & p__part(SYLLABLE,WORD) )
     => ! [SYLLABLE2] :
          ( ~ p__d__instance(SYLLABLE2,c__Object)
          | ~ p__d__instance(SYLLABLE2,c__Syllable)
          | ~ p__part(SYLLABLE2,WORD)
          | ~ p__attribute(SYLLABLE2,c__Stressed)
          | SYLLABLE2 = SYLLABLE ) ) ).

fof(miloA2826,axiom,
    p__d__subclass(c__Syllable,c__SymbolicString) ).

fof(miloA2827,axiom,
    ! [WORD] :
      ( ( p__d__instance(WORD,c__Object)
        & p__d__instance(WORD,c__Word) )
     => ? [SYLLABLE] :
          ( p__d__instance(SYLLABLE,c__Syllable)
          & p__part(SYLLABLE,WORD) ) ) ).

fof(miloA2828,axiom,
    p__d__subclass(c__AlphabeticCharacter,c__Character) ).

fof(miloA2829,axiom,
    p__d__subclass(c__DigitCharacter,c__Character) ).

fof(miloA2830,axiom,
    p__d__subclass(c__Consonant,c__AlphabeticCharacter) ).

fof(miloA2831,axiom,
    p__d__subclass(c__Vowel,c__AlphabeticCharacter) ).

fof(miloA2832,axiom,
    p__d__instance(c__Lost,c__ContestAttribute) ).

fof(miloA2833,axiom,
    p__contraryAttribute2(c__Lost,c__Won) ).

fof(miloA2834,axiom,
    p__d__instance(c__Won,c__ContestAttribute) ).

fof(miloA2835,axiom,
    p__d__instance(c__TieScore,c__ContestAttribute) ).

fof(miloA2836,axiom,
    p__d__subclass(c__GameAttribute,c__ContestAttribute) ).

fof(miloA2837,axiom,
    p__d__subclass(c__SportsAttribute,c__GameAttribute) ).

fof(miloA2838,axiom,
    p__d__instance(c__Foul,c__SportsAttribute) ).

fof(miloA2839,axiom,
    p__d__instance(c__SportsOut,c__SportsAttribute) ).

fof(miloA2840,axiom,
    p__d__subclass(c__PoliticoEconomicAttribute,c__RelationalAttribute) ).

fof(miloA2841,axiom,
    p__d__partition3(c__PoliticoEconomicAttribute,c__FormOfGovernment,c__EconomicAttribute) ).

fof(miloA2842,axiom,
    ! [ATTRIBUTE,GOVERNMENT] :
      ( ( p__d__instance(GOVERNMENT,c__Object)
        & p__d__instance(ATTRIBUTE,c__PoliticoEconomicAttribute)
        & p__attribute(GOVERNMENT,ATTRIBUTE) )
     => p__d__instance(GOVERNMENT,c__Government) ) ).

fof(miloA2843,axiom,
    p__d__subclass(c__EconomicAttribute,c__PoliticoEconomicAttribute) ).

fof(miloA2844,axiom,
    p__d__subclass(c__FormOfGovernment,c__PoliticoEconomicAttribute) ).

fof(miloA2845,axiom,
    p__d__subclass(c__ChemicalReduction,c__ChemicalSynthesis) ).

fof(miloA2846,axiom,
    p__d__disjoint(c__ChemicalReduction,c__Oxidation) ).

fof(miloA2848,axiom,
    p__d__subclass(c__Oxidation,c__ChemicalDecomposition) ).

fof(miloA2850,axiom,
    p__d__subclass(c__Dialysis,c__Separating) ).

fof(miloA2851,axiom,
    ! [DIALYSIS] :
      ( p__d__instance(DIALYSIS,c__Dialysis)
     => ? [SOLUTION,SUBSTANCE1,SUBSTANCE2] :
          ( p__resource(DIALYSIS,SOLUTION)
          & p__d__instance(SOLUTION,c__Solution)
          & p__result(DIALYSIS,SUBSTANCE1)
          & p__d__instance(SUBSTANCE1,c__PureSubstance)
          & p__result(DIALYSIS,SUBSTANCE2)
          & p__d__instance(SUBSTANCE2,c__PureSubstance)
          & SUBSTANCE1 != SUBSTANCE2 ) ) ).

fof(miloA2852,axiom,
    p__d__subclass(c__Diluting,c__Putting) ).

fof(miloA2853,axiom,
    ! [D] :
      ( p__d__instance(D,c__Diluting)
     => ? [S] :
          ( p__patient(D,S)
          & p__d__instance(S,c__Solution)
          & p__attribute(S,c__Liquid) ) ) ).

fof(miloA2854,axiom,
    p__d__instance(c__ChemicalEquilibrium,c__InternalAttribute) ).

fof(miloA2855,axiom,
    ! [PROCESS] :
      ( p__property(PROCESS,c__ChemicalEquilibrium)
     => p__d__instance(PROCESS,c__ChemicalProcess) ) ).

fof(miloA2857,axiom,
    p__d__subclass(c__Chromatography,c__Separating) ).

fof(miloA2858,axiom,
    ! [C] :
      ( p__d__instance(C,c__Chromatography)
     => ? [M] :
          ( p__d__instance(M,c__Object)
          & p__resource(C,M)
          & ( p__d__instance(M,c__LiquidMixture)
            | p__d__instance(M,c__GasMixture) ) ) ) ).

fof(miloA2859,axiom,
    ! [C] :
      ( p__d__instance(C,c__Chromatography)
     => ? [S] :
          ( p__d__instance(S,c__PureSubstance)
          & p__result(C,S) ) ) ).

fof(miloA2860,axiom,
    p__d__subclass(c__BreakabilityAttribute,c__InternalAttribute) ).

fof(miloA2861,axiom,
    p__d__instance(c__Fragile,c__BreakabilityAttribute) ).

fof(miloA2862,axiom,
    p__d__instance(c__Unbreakable,c__BreakabilityAttribute) ).

fof(miloA2863,axiom,
    p__contraryAttribute2(c__Unbreakable,c__Fragile) ).

fof(miloA2864,axiom,
    p__subrelation(c__contestParticipant,c__agent) ).

fof(miloA2865,axiom,
    p__d__instance(c__contestParticipant,c__TotalValuedRelation) ).

fof(miloA2868,axiom,
    p__d__subclass(c__CivilWar,c__War) ).

fof(miloA2869,axiom,
    ! [WAR] :
      ( p__d__instance(WAR,c__CivilWar)
     => ? [NATION] :
          ( p__d__instance(NATION,c__Nation)
          & ! [AGENT] :
              ( ( p__d__instance(AGENT,c__GeopoliticalArea)
                & p__contestParticipant(WAR,AGENT) )
             => p__geopoliticalSubdivision(AGENT,NATION) ) ) ) ).

fof(miloA2870,axiom,
    p__d__subclass(c__Debating,c__Contest) ).

fof(miloA2871,axiom,
    p__d__subclass(c__Debating,c__LinguisticCommunication) ).

fof(miloA2872,axiom,
    p__d__subclass(c__Negotiating,c__Contest) ).

fof(miloA2873,axiom,
    p__d__subclass(c__Negotiating,c__LinguisticCommunication) ).

fof(miloA2875,axiom,
    p__d__subclass(c__BusinessCompetition,c__Contest) ).

fof(miloA2876,axiom,
    ! [CONTEST,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(CONTEST,c__BusinessCompetition)
        & p__contestParticipant(CONTEST,AGENT) )
     => p__d__instance(AGENT,c__Corporation) ) ).

fof(miloA2877,axiom,
    p__d__subclass(c__VisualAcuityAttribute,c__BiologicalAttribute) ).

fof(miloA2878,axiom,
    p__d__instance(c__ColorBlind,c__VisualAcuityAttribute) ).

fof(miloA2879,axiom,
    p__d__subclass(c__Disability,c__DiseaseOrSyndrome) ).

fof(miloA2880,axiom,
    p__d__subclass(c__PhysicalDisability,c__Disability) ).

fof(miloA2881,axiom,
    p__d__subclass(c__SensoryDisability,c__Disability) ).

fof(miloA2882,axiom,
    p__d__instance(c__Blind,c__VisualAcuityAttribute) ).

fof(miloA2883,axiom,
    p__d__instance(c__Blind,c__SensoryDisability) ).

fof(miloA2884,axiom,
    ! [AGENT] :
      ( ( p__d__instance(AGENT,c__Object)
        & p__attribute(AGENT,c__Blind) )
     => ~ p__capability(c__Seeing,c__agent,AGENT) ) ).

fof(miloA2885,axiom,
    p__d__instance(c__Deaf,c__SensoryDisability) ).

fof(miloA2886,axiom,
    ! [A] :
      ( ( p__d__instance(A,c__Object)
        & p__attribute(A,c__Deaf) )
     => ~ p__capability(c__Hearing,c__agent,A) ) ).

fof(miloA2887,axiom,
    p__d__instance(c__Hungry,c__BiologicalAttribute) ).

fof(miloA2889,axiom,
    p__d__instance(c__Pregnant,c__BiologicalAttribute) ).

fof(miloA2890,axiom,
    ! [H] :
      ( ( p__d__instance(H,c__Object)
        & p__attribute(H,c__Pregnant) )
     => p__attribute(H,c__Female) ) ).

fof(miloA2891,axiom,
    p__subAttribute(c__Puberty,c__NonFullyFormed) ).

fof(miloA2892,axiom,
    p__d__instance(c__Fist,c__BodyPosition) ).

fof(miloA2893,axiom,
    ! [HAND] :
      ( ( p__d__instance(HAND,c__Object)
        & p__attribute(HAND,c__Fist) )
     => p__d__instance(HAND,c__Hand) ) ).

fof(miloA2894,axiom,
    p__d__subclass(c__LyingDown,c__BodyMotion) ).

fof(miloA2895,axiom,
    p__d__subclass(c__LyingDown,c__MotionDownward) ).

fof(miloA2897,axiom,
    p__d__instance(c__Handstand,c__BodyPosition) ).

fof(miloA2898,axiom,
    p__d__instance(c__Kneeling,c__BodyPosition) ).

fof(miloA2899,axiom,
    p__d__instance(c__Splitting,c__BodyPosition) ).

fof(miloA2900,axiom,
    p__subAttribute(c__Squatting,c__Sitting) ).

fof(miloA2901,axiom,
    p__d__subclass(c__SittingDown,c__BodyMotion) ).

fof(miloA2902,axiom,
    p__d__subclass(c__SittingDown,c__MotionDownward) ).

fof(miloA2904,axiom,
    p__d__subclass(c__StandingUp,c__BodyMotion) ).

fof(miloA2905,axiom,
    p__d__subclass(c__StandingUp,c__MotionUpward) ).

fof(miloA2907,axiom,
    p__d__subclass(c__EyeMotion,c__BodyMotion) ).

fof(miloA2908,axiom,
    ! [A,EM] :
      ( ( p__d__instance(A,c__Agent)
        & p__d__instance(EM,c__EyeMotion)
        & p__agent(EM,A) )
     => ? [E] :
          ( p__d__instance(E,c__Eyelid)
          & p__part(E,A)
          & p__patient(EM,E) ) ) ).

fof(miloA2909,axiom,
    p__d__subclass(c__OpeningEyes,c__EyeMotion) ).

fof(miloA2910,axiom,
    p__d__subclass(c__OpeningEyes,c__Opening) ).

fof(miloA2911,axiom,
    p__d__disjoint(c__OpeningEyes,c__ClosingEyes) ).

fof(miloA2912,axiom,
    p__d__subclass(c__ClosingEyes,c__EyeMotion) ).

fof(miloA2913,axiom,
    p__d__subclass(c__ClosingEyes,c__Closing) ).

fof(miloA2914,axiom,
    p__d__subclass(c__Winking,c__ClosingEyes) ).

fof(miloA2915,axiom,
    p__d__subclass(c__Winking,c__Gesture) ).

fof(miloA2916,axiom,
    p__d__subclass(c__Shrugging,c__BodyMotion) ).

fof(miloA2917,axiom,
    p__d__subclass(c__Shrugging,c__Gesture) ).

fof(miloA2918,axiom,
    ! [SHRUG,SHOULDER] :
      ( ( p__d__instance(SHRUG,c__Shrugging)
        & p__patient(SHRUG,SHOULDER) )
     => p__d__instance(SHOULDER,c__Shoulder) ) ).

fof(miloA2919,axiom,
    p__d__subclass(c__Trembling,c__BodyMotion) ).

fof(miloA2920,axiom,
    p__d__subclass(c__Trembling,c__AutonomicProcess) ).

fof(miloA2921,axiom,
    p__d__subclass(c__Trembling,c__Tremor) ).

fof(miloA2922,axiom,
    p__d__disjoint(c__Trembling,c__IntentionalProcess) ).

fof(miloA2923,axiom,
    p__d__subclass(c__ReflexiveProcess,c__AutonomicProcess) ).

fof(miloA2924,axiom,
    ! [P] :
      ( p__d__instance(P,c__ReflexiveProcess)
     => ? [M] :
          ( p__d__instance(M,c__Muscle)
          & p__patient(P,M) ) ) ).

fof(miloA2925,axiom,
    p__d__subclass(c__Dismounting,c__BodyMotion) ).

fof(miloA2927,axiom,
    p__d__subclass(c__DomesticAnimal,c__Animal) ).

fof(miloA2928,axiom,
    p__d__disjoint(c__DomesticAnimal,c__Human) ).

fof(miloA2929,axiom,
    ! [ANIMAL] :
      ( p__d__instance(ANIMAL,c__DomesticAnimal)
     => ? [KEEP,PERSON] :
          ( p__d__instance(KEEP,c__Keeping)
          & p__agent(KEEP,PERSON)
          & p__d__instance(PERSON,c__Human)
          & p__patient(KEEP,ANIMAL) ) ) ).

fof(miloA2931,axiom,
    p__d__subclass(c__Fodder,c__OrganicObject) ).

fof(miloA2933,axiom,
    p__d__subclass(c__Herbivore,c__Mammal) ).

fof(miloA2934,axiom,
    p__d__disjoint(c__Herbivore,c__Carnivore) ).

fof(miloA2935,axiom,
    ! [A,E,F] :
      ( ( p__d__instance(A,c__Herbivore)
        & p__agent(E,A)
        & p__d__instance(E,c__Eating)
        & p__patient(E,F) )
     => p__d__instance(F,c__Plant) ) ).

fof(miloA2936,axiom,
    p__d__subclass(c__Antelope,c__HoofedMammal) ).

fof(miloA2937,axiom,
    p__d__subclass(c__Buffalo,c__HoofedMammal) ).

fof(miloA2938,axiom,
    p__d__subclass(c__DomesticCat,c__DomesticAnimal) ).

fof(miloA2939,axiom,
    p__d__subclass(c__DomesticCat,c__Feline) ).

fof(miloA2940,axiom,
    p__d__subclass(c__DomesticDog,c__DomesticAnimal) ).

fof(miloA2941,axiom,
    p__d__subclass(c__DomesticDog,c__Canine) ).

fof(miloA2942,axiom,
    p__d__subclass(c__Fox,c__Canine) ).

fof(miloA2943,axiom,
    p__d__subclass(c__Elephant,c__Herbivore) ).

fof(miloA2944,axiom,
    p__d__subclass(c__Horse,c__HoofedMammal) ).

fof(miloA2945,axiom,
    p__d__subclass(c__Pig,c__HoofedMammal) ).

fof(miloA2946,axiom,
    p__d__subclass(c__Donkey,c__HoofedMammal) ).

fof(miloA2947,axiom,
    p__d__subclass(c__Gastropod,c__Mollusk) ).

fof(miloA2948,axiom,
    p__d__subclass(c__Mule,c__HoofedMammal) ).

fof(miloA2949,axiom,
    p__d__subclass(c__Mule,c__DomesticAnimal) ).

fof(miloA2950,axiom,
    ! [MULE] :
      ( p__d__instance(MULE,c__Mule)
     => ? [DONKEY,HORSE] :
          ( p__father(MULE,DONKEY)
          & p__d__instance(DONKEY,c__Donkey)
          & p__mother(MULE,HORSE)
          & p__d__instance(HORSE,c__Horse) ) ) ).

fof(miloA2951,axiom,
    ! [MULE] :
      ( p__d__instance(MULE,c__Mule)
     => ~ p__capability(c__SexualReproduction,c__agent,MULE) ) ).

fof(miloA2952,axiom,
    p__d__subclass(c__Sheep,c__HoofedMammal) ).

fof(miloA2953,axiom,
    p__d__subclass(c__Sheep,c__DomesticAnimal) ).

fof(miloA2954,axiom,
    p__d__subclass(c__Lamb,c__Sheep) ).

fof(miloA2955,axiom,
    ! [L] :
      ( p__d__instance(L,c__Object)
     => ( p__d__instance(L,c__Lamb)
      <=> ( p__d__instance(L,c__Sheep)
          & p__attribute(L,c__NonFullyFormed) ) ) ) ).

fof(miloA2956,axiom,
    p__d__subclass(c__Cow,c__HoofedMammal) ).

fof(miloA2957,axiom,
    p__d__subclass(c__Cow,c__DomesticAnimal) ).

fof(miloA2958,axiom,
    p__d__subclass(c__Calf,c__Cow) ).

fof(miloA2959,axiom,
    ! [C] :
      ( p__d__instance(C,c__Object)
     => ( p__d__instance(C,c__Calf)
      <=> ( p__d__instance(C,c__Cow)
          & p__attribute(C,c__NonFullyFormed) ) ) ) ).

fof(miloA2960,axiom,
    p__d__subclass(c__Bull,c__Cow) ).

fof(miloA2961,axiom,
    ! [B] :
      ( p__d__instance(B,c__Object)
     => ( p__d__instance(B,c__Bull)
      <=> ( p__d__instance(B,c__Cow)
          & p__attribute(B,c__Male) ) ) ) ).

fof(miloA2962,axiom,
    p__d__subclass(c__FemaleCow,c__Cow) ).

fof(miloA2963,axiom,
    ! [COW] :
      ( p__d__instance(COW,c__Object)
     => ( p__d__instance(COW,c__FemaleCow)
      <=> ( p__d__instance(COW,c__Cow)
          & p__attribute(COW,c__Female) ) ) ) ).

fof(miloA2964,axiom,
    p__d__subclass(c__Poultry,c__Bird) ).

fof(miloA2965,axiom,
    p__d__subclass(c__Chicken,c__Poultry) ).

fof(miloA2966,axiom,
    p__d__subclass(c__Hen,c__Chicken) ).

fof(miloA2967,axiom,
    ! [H] :
      ( p__d__instance(H,c__Object)
     => ( p__d__instance(H,c__Hen)
      <=> ( p__d__instance(H,c__Chicken)
          & p__attribute(H,c__Female) ) ) ) ).

fof(miloA2968,axiom,
    p__d__subclass(c__Rooster,c__Chicken) ).

fof(miloA2969,axiom,
    ! [R] :
      ( p__d__instance(R,c__Object)
     => ( p__d__instance(R,c__Rooster)
      <=> ( p__d__instance(R,c__Chicken)
          & p__attribute(R,c__Male) ) ) ) ).

fof(miloA2970,axiom,
    p__d__subclass(c__Duck,c__Poultry) ).

fof(miloA2971,axiom,
    p__d__subclass(c__Goose,c__Poultry) ).

fof(miloA2972,axiom,
    p__d__subclass(c__Owl,c__Bird) ).

fof(miloA2973,axiom,
    p__d__subclass(c__Pigeon,c__Bird) ).

fof(miloA2974,axiom,
    p__d__subclass(c__Vulture,c__Bird) ).

fof(miloA2975,axiom,
    p__d__subclass(c__Feather,c__AnimalAnatomicalStructure) ).

fof(miloA2976,axiom,
    p__d__subclass(c__Feather,c__BodyPart) ).

fof(miloA2977,axiom,
    ! [F] :
      ( p__d__instance(F,c__Feather)
     => ? [B] :
          ( p__d__instance(B,c__Bird)
          & p__part(F,B) ) ) ).

fof(miloA2978,axiom,
    p__d__instance(c__meatOfAnimal,c__BinaryPredicate) ).

fof(miloA2982,axiom,
    p__d__subclass(c__Beef,c__Meat) ).

fof(miloA2983,axiom,
    p__meatOfAnimal(c__Beef,c__Cow) ).

fof(miloA2984,axiom,
    p__d__subclass(c__ChickenMeat,c__Meat) ).

fof(miloA2985,axiom,
    p__meatOfAnimal(c__ChickenMeat,c__Chicken) ).

fof(miloA2986,axiom,
    p__d__subclass(c__Pork,c__Meat) ).

fof(miloA2987,axiom,
    p__meatOfAnimal(c__Pork,c__Pig) ).

fof(miloA2988,axiom,
    p__d__subclass(c__Mouse,c__Rodent) ).

fof(miloA2989,axiom,
    p__d__subclass(c__Rat,c__Rodent) ).

fof(miloA2990,axiom,
    p__d__subclass(c__Rabbit,c__Rodent) ).

fof(miloA2991,axiom,
    p__d__subclass(c__Squirrel,c__Rodent) ).

fof(miloA2992,axiom,
    p__d__subclass(c__Hay,c__Fodder) ).

fof(miloA2993,axiom,
    ! [HAY] :
      ( p__d__instance(HAY,c__Hay)
     => ? [MAKE,GRASS] :
          ( p__d__instance(MAKE,c__Making)
          & p__resource(MAKE,GRASS)
          & p__d__instance(GRASS,c__Grass)
          & p__result(MAKE,HAY) ) ) ).

fof(miloA2994,axiom,
    p__d__subclass(c__Copying,c__Making) ).

fof(miloA2995,axiom,
    ! [COPY,THING1,THING2] :
      ( ( p__d__instance(THING1,c__Object)
        & p__d__instance(THING2,c__Object)
        & p__d__instance(COPY,c__Copying)
        & p__resource(COPY,THING1)
        & p__result(COPY,THING2) )
     => p__copy(THING1,THING2) ) ).

fof(miloA2996,axiom,
    p__d__subclass(c__Vacationing,c__RecreationOrExercise) ).

fof(miloA2997,axiom,
    ! [PERSON,VACATION,WORK] :
      ( ( p__d__instance(VACATION,c__Vacationing)
        & p__d__instance(WORK,c__Working)
        & p__agent(VACATION,PERSON)
        & p__agent(WORK,PERSON)
        & p__d__instance(PERSON,c__Human) )
     => ~ p__overlapsTemporally(f__WhenFn1(VACATION),f__WhenFn1(WORK)) ) ).

fof(miloA2998,axiom,
    p__d__instance(c__OccupationFn,c__UnaryFunction) ).

fof(miloA3001,axiom,
    p__d__instance(c__occupation,c__BinaryPredicate) ).

fof(miloA3004,axiom,
    p__d__subclass(c__Working,c__FinancialTransaction) ).

fof(miloA3005,axiom,
    p__d__subclass(c__Farming,c__Working) ).

fof(miloA3007,axiom,
    p__d__subclass(c__Serving,c__Working) ).

fof(miloA3008,axiom,
    p__d__subclass(c__Sales,c__Working) ).

fof(miloA3009,axiom,
    p__subAttribute(c__Retired,c__Unemployed) ).

fof(miloA3010,axiom,
    p__subAttribute(c__Housewife,c__Unemployed) ).

fof(miloA3011,axiom,
    ! [W] :
      ( ( p__d__instance(W,c__Woman)
        & p__attribute(W,c__Housewife) )
     => ? [H] :
          ( p__d__instance(H,c__Man)
          & p__wife(W,H) ) ) ).

fof(miloA3012,axiom,
    p__d__instance(c__Waiter,c__ServicePosition) ).

fof(miloA3013,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Waiter) )
     => p__d__instance(X,c__Human) ) ).

fof(miloA3015,axiom,
    p__d__instance(c__Maid,c__ServicePosition) ).

fof(miloA3017,axiom,
    p__d__subclass(c__Janitor,c__UnskilledOccupation) ).

fof(miloA3019,axiom,
    p__d__subclass(c__TheaterProfession,c__EntertainmentProfession) ).

fof(miloA3020,axiom,
    p__d__instance(c__FilmDirector,c__FilmMakingProfession) ).

fof(miloA3021,axiom,
    p__d__subclass(c__FilmMaking,c__ContentDevelopment) ).

fof(miloA3022,axiom,
    ! [FM] :
      ( p__d__instance(FM,c__FilmMaking)
     => ? [M,F] :
          ( p__d__instance(M,c__MotionPicture)
          & p__result(FM,M)
          & p__d__instance(F,c__PhotographicFilm)
          & p__resource(FM,F) ) ) ).

fof(miloA3023,axiom,
    p__d__subclass(c__FilmMakingProfession,c__EntertainmentProfession) ).

fof(miloA3025,axiom,
    p__d__instance(c__FilmProducer,c__FilmMakingProfession) ).

fof(miloA3026,axiom,
    p__d__instance(c__Coach,c__SkilledOccupation) ).

fof(miloA3027,axiom,
    p__d__instance(c__GameReferee,c__SkilledOccupation) ).

fof(miloA3028,axiom,
    p__d__instance(c__Carpenter,c__OccupationalTrade) ).

fof(miloA3029,axiom,
    ! [P] :
      ( ( p__d__instance(P,c__Agent)
        & p__attribute(P,c__Carpenter) )
     => p__hasSkill(c__Carpentry,P) ) ).

fof(miloA3030,axiom,
    p__d__subclass(c__Carpentry,c__Making) ).

fof(miloA3031,axiom,
    ! [C] :
      ( p__d__instance(C,c__Carpentry)
     => ? [B,W] :
          ( p__d__instance(B,c__Building)
          & p__d__instance(W,c__Wood)
          & p__part(W,B)
          & p__result(C,B) ) ) ).

fof(miloA3032,axiom,
    p__d__instance(c__constructionPeriod,c__BinaryPredicate) ).

fof(miloA3036,axiom,
    p__d__instance(c__contractor,c__BinaryPredicate) ).

fof(miloA3040,axiom,
    p__d__subclass(c__Agriculture,c__Maintaining) ).

fof(miloA3041,axiom,
    ! [AGRO] :
      ( p__d__instance(AGRO,c__Agriculture)
     => ? [GROWTH] :
          ( p__d__instance(GROWTH,c__Growth)
          & p__subProcess(GROWTH,AGRO) ) ) ).

fof(miloA3042,axiom,
    p__d__instance(c__FarmHand,c__OccupationalTrade) ).

fof(miloA3043,axiom,
    ! [P] :
      ( ( p__d__instance(P,c__Agent)
        & p__attribute(P,c__FarmHand) )
     => ? [F] :
          ( p__d__instance(F,c__Agriculture)
          & p__agent(F,P) ) ) ).

fof(miloA3044,axiom,
    p__d__instance(c__Plumber,c__OccupationalTrade) ).

fof(miloA3045,axiom,
    p__d__instance(c__Potter,c__OccupationalTrade) ).

fof(miloA3046,axiom,
    ! [H] :
      ( ( p__d__instance(H,c__Agent)
        & p__attribute(H,c__Potter) )
     => ? [M,P] :
          ( p__d__instance(P,c__Pottery)
          & p__d__instance(M,c__Making)
          & p__agent(M,H)
          & p__result(M,P) ) ) ).

fof(miloA3047,axiom,
    p__d__subclass(c__ReligiousPosition,c__Position) ).

fof(miloA3048,axiom,
    ! [H,P,O] :
      ( ( p__d__instance(O,c__Organization)
        & p__d__instance(H,c__Human)
        & p__occupiesPosition(H,P,O)
        & p__d__instance(P,c__ReligiousPosition) )
     => p__d__instance(O,c__ReligiousOrganization) ) ).

fof(miloA3049,axiom,
    p__d__instance(c__Cleric,c__Profession) ).

fof(miloA3050,axiom,
    p__d__instance(c__Cleric,c__ReligiousPosition) ).

fof(miloA3051,axiom,
    p__d__instance(c__Deacon,c__ReligiousPosition) ).

fof(miloA3052,axiom,
    p__d__instance(c__Deacon,c__PartTimePosition) ).

fof(miloA3054,axiom,
    p__d__instance(c__PoliceOfficer,c__SkilledOccupation) ).

fof(miloA3055,axiom,
    p__d__instance(c__PoliceOfficer,c__GovernmentPosition) ).

fof(miloA3056,axiom,
    ! [P] :
      ( ( p__d__instance(P,c__Agent)
        & p__attribute(P,c__PoliceOfficer) )
     => p__hasSkill(c__PlacingUnderArrest,P) ) ).

fof(miloA3057,axiom,
    p__subAttribute(c__PoliceCaptain,c__PoliceOfficer) ).

fof(miloA3058,axiom,
    p__subAttribute(c__PoliceSergeant,c__PoliceOfficer) ).

fof(miloA3059,axiom,
    p__subAttribute(c__Sheriff,c__PoliceOfficer) ).

fof(miloA3060,axiom,
    p__subAttribute(c__Marshal,c__PoliceOfficer) ).

fof(miloA3061,axiom,
    p__subAttribute(c__Deputy,c__PoliceOfficer) ).

fof(miloA3062,axiom,
    p__d__instance(c__Coroner,c__GovernmentPosition) ).

fof(miloA3063,axiom,
    p__subAttribute(c__PoliceDetective,c__PoliceOfficer) ).

fof(miloA3064,axiom,
    p__d__instance(c__PrivateDetective,c__Profession) ).

fof(miloA3065,axiom,
    p__contraryAttribute2(c__PrivateDetective,c__PoliceDetective) ).

fof(miloA3066,axiom,
    p__d__instance(c__Lawyer,c__Profession) ).

fof(miloA3067,axiom,
    p__subAttribute(c__Attorney,c__Lawyer) ).

fof(miloA3068,axiom,
    ! [P] :
      ( ( p__d__instance(P,c__Human)
        & p__attribute(P,c__Lawyer) )
     => p__hasExpertise(P,c__FieldOfLaw) ) ).

fof(miloA3069,axiom,
    p__subAttribute(c__AttorneyGeneral,c__Attorney) ).

fof(miloA3070,axiom,
    p__d__instance(c__AttorneyGeneral,c__GovernmentPosition) ).

fof(miloA3071,axiom,
    p__subAttribute(c__PublicDefender,c__Attorney) ).

fof(miloA3072,axiom,
    p__d__instance(c__PublicDefender,c__GovernmentPosition) ).

fof(miloA3073,axiom,
    p__subAttribute(c__PublicProsecutor,c__Attorney) ).

fof(miloA3074,axiom,
    p__d__instance(c__PublicProsecutor,c__GovernmentPosition) ).

fof(miloA3075,axiom,
    p__subAttribute(c__Judge,c__Attorney) ).

fof(miloA3076,axiom,
    p__d__instance(c__Judge,c__GovernmentPosition) ).

fof(miloA3079,axiom,
    p__subAttribute(c__Professor,c__Teacher) ).

fof(miloA3081,axiom,
    p__d__instance(c__MedicalDoctor,c__Profession) ).

fof(miloA3082,axiom,
    ! [DOCTOR] :
      ( ( p__d__instance(DOCTOR,c__Object)
        & p__attribute(DOCTOR,c__MedicalDoctor) )
     => ? [PROCESS1,PROCESS2] :
          ( p__d__subclass(PROCESS1,c__DiagnosticProcess)
          & p__d__subclass(PROCESS2,c__TherapeuticProcess)
          & p__capability(PROCESS1,c__agent,DOCTOR)
          & p__capability(PROCESS2,c__agent,DOCTOR) ) ) ).

fof(miloA3083,axiom,
    p__subAttribute(c__Surgeon,c__MedicalDoctor) ).

fof(miloA3084,axiom,
    p__d__subclass(c__Circumision,c__Removing) ).

fof(miloA3085,axiom,
    p__d__subclass(c__Circumision,c__Surgery) ).

fof(miloA3086,axiom,
    p__d__instance(c__NewsReporter,c__Profession) ).

fof(miloA3087,axiom,
    ! [H] :
      ( ( p__d__instance(H,c__Agent)
        & p__attribute(H,c__NewsReporter) )
     => ? [T,EV] :
          ( p__d__subclass(T,c__Text)
          & p__d__instance(EV,c__Process)
          & p__overlapsTemporally(f__WhenFn1(EV),f__WhenFn1(H))
          & p__authors(H,T)
          & p__refers(T,EV) ) ) ).

fof(miloA3088,axiom,
    p__subAttribute(c__ArtCritic,c__Journalist) ).

fof(miloA3089,axiom,
    ! [H] :
      ( ( p__d__instance(H,c__Agent)
        & p__attribute(H,c__ArtCritic) )
     => ? [T,AW] :
          ( p__d__subclass(T,c__Text)
          & p__d__instance(AW,c__ArtWork)
          & p__authors(H,T)
          & p__refers(T,AW) ) ) ).

fof(miloA3090,axiom,
    p__d__instance(c__Accountant,c__Profession) ).

fof(miloA3091,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Accountant) )
     => p__capability(c__Calculating,c__agent,X) ) ).

fof(miloA3092,axiom,
    p__d__instance(c__Literature,c__FieldOfStudy) ).

fof(miloA3093,axiom,
    p__d__instance(c__Mathematics,c__FieldOfStudy) ).

fof(miloA3094,axiom,
    p__d__instance(c__InteriorDesign,c__FieldOfStudy) ).

fof(miloA3095,axiom,
    p__d__subclass(c__Science,c__FieldOfStudy) ).

fof(miloA3096,axiom,
    p__d__subclass(c__SocialScience,c__Science) ).

fof(miloA3097,axiom,
    p__d__instance(c__PoliticalScience,c__SocialScience) ).

fof(miloA3098,axiom,
    p__d__instance(c__Anthropology,c__SocialScience) ).

fof(miloA3099,axiom,
    p__d__instance(c__Architecture,c__FieldOfStudy) ).

fof(miloA3100,axiom,
    ! [H] :
      ( ( p__d__instance(H,c__Human)
        & p__hasExpertise(H,c__Architecture) )
     => ? [D,P,B] :
          ( p__d__instance(D,c__ContentDevelopment)
          & p__agent(D,H)
          & p__result(D,P)
          & p__d__instance(P,c__Blueprint)
          & p__represents(P,B)
          & p__d__instance(B,c__Building) ) ) ).

fof(miloA3101,axiom,
    p__d__instance(c__Economics,c__SocialScience) ).

fof(miloA3102,axiom,
    p__d__instance(c__Linguistics,c__SocialScience) ).

fof(miloA3103,axiom,
    p__d__instance(c__Psychology,c__SocialScience) ).

fof(miloA3104,axiom,
    p__d__instance(c__Biology,c__Science) ).

fof(miloA3105,axiom,
    p__subField(c__Physiology,c__Biology) ).

fof(miloA3106,axiom,
    p__d__instance(c__Physiology,c__Science) ).

fof(miloA3107,axiom,
    p__subField(c__MedicalScience,c__Biology) ).

fof(miloA3108,axiom,
    p__d__instance(c__MedicalScience,c__Science) ).

fof(miloA3109,axiom,
    p__d__instance(c__Chemistry,c__Science) ).

fof(miloA3110,axiom,
    p__d__instance(c__Physics,c__Science) ).

fof(miloA3111,axiom,
    p__d__instance(c__Engineering,c__Science) ).

fof(miloA3112,axiom,
    p__subField(c__Electronics,c__Physics) ).

fof(miloA3113,axiom,
    p__subField(c__Electronics,c__Engineering) ).

fof(miloA3114,axiom,
    p__d__instance(c__Electronics,c__FieldOfStudy) ).

fof(miloA3115,axiom,
    p__d__instance(c__Theology,c__FieldOfStudy) ).

fof(miloA3117,axiom,
    p__d__instance(c__MilitaryScience,c__FieldOfStudy) ).

fof(miloA3118,axiom,
    p__d__instance(c__History,c__FieldOfStudy) ).

fof(miloA3119,axiom,
    p__d__instance(c__Philosophy,c__FieldOfStudy) ).

fof(miloA3120,axiom,
    p__d__instance(c__FieldOfLaw,c__FieldOfStudy) ).

fof(miloA3121,axiom,
    p__subrelation(c__subField,c__subProposition) ).

fof(miloA3122,axiom,
    p__d__instance(c__subField,c__TransitiveRelation) ).

fof(miloA3123,axiom,
    p__d__instance(c__subField,c__IrreflexiveRelation) ).

fof(miloA3126,axiom,
    p__d__instance(c__hasExpertise,c__BinaryPredicate) ).

fof(miloA3129,axiom,
    ! [PERSON,FIELD] :
      ( ( p__d__instance(FIELD,c__FieldOfStudy)
        & p__d__instance(PERSON,c__Human)
        & p__hasExpertise(PERSON,FIELD) )
     => ? [LEARN] :
          ( p__d__instance(LEARN,c__Learning)
          & p__agent(LEARN,PERSON)
          & p__realization(LEARN,FIELD) ) ) ).

fof(miloA3130,axiom,
    p__d__instance(c__hasOccupation,c__BinaryPredicate) ).

fof(miloA3133,axiom,
    ! [WORK,PERSON] :
      ( ( p__d__subclass(WORK,c__IntentionalProcess)
        & p__d__instance(PERSON,c__Human)
        & p__hasOccupation(PERSON,WORK) )
     => ? [INST] :
          ( p__d__instance(INST,WORK)
          & p__d__instance(INST,c__Working)
          & p__agent(INST,PERSON) ) ) ).

fof(miloA3134,axiom,
    p__d__subclass(c__Bleeding,c__AutonomicProcess) ).

fof(miloA3135,axiom,
    ! [BLEED] :
      ( p__d__instance(BLEED,c__Bleeding)
     => ? [INJURY] :
          ( p__d__instance(INJURY,c__Injuring)
          & p__causes(INJURY,BLEED) ) ) ).

fof(miloA3136,axiom,
    ! [BLEED,ANIMAL] :
      ( ( p__d__instance(ANIMAL,c__Agent)
        & p__d__instance(BLEED,c__Bleeding)
        & p__experiencer(BLEED,ANIMAL) )
     => p__d__instance(ANIMAL,c__Animal) ) ).

fof(miloA3138,axiom,
    p__d__subclass(c__Blushing,c__AutonomicProcess) ).

fof(miloA3140,axiom,
    p__d__subclass(c__Aborting,c__Removing) ).

fof(miloA3142,axiom,
    p__d__subclass(c__ClosingContract,c__Committing) ).

fof(miloA3143,axiom,
    ! [CLOSE,AGENT,CONTRACT] :
      ( ( p__d__instance(AGENT,c__CognitiveAgent)
        & p__d__instance(CONTRACT,c__Agreement)
        & p__d__instance(CLOSE,c__ClosingContract)
        & p__agent(CLOSE,AGENT)
        & p__destination(CLOSE,CONTRACT) )
     => p__partyToAgreement(AGENT,CONTRACT) ) ).

fof(miloA3144,axiom,
    p__d__subclass(c__Opening,c__Motion) ).

fof(miloA3146,axiom,
    p__d__subclass(c__Closing,c__Motion) ).

fof(miloA3147,axiom,
    p__d__subclass(c__Diet,c__Plan) ).

fof(miloA3148,axiom,
    ! [D,P] :
      ( ( p__d__instance(P,c__Process)
        & p__d__instance(D,c__Diet)
        & p__realization(P,D) )
     => ? [E] :
          ( p__subProcess(E,P)
          & p__d__instance(E,c__Eating) ) ) ).

fof(miloA3149,axiom,
    p__d__subclass(c__PreparedFood,c__Object) ).

fof(miloA3151,axiom,
    ! [X] :
      ( p__d__instance(X,c__PreparedFood)
     => ? [PROC] :
          ( p__d__instance(PROC,c__IntentionalProcess)
          & p__result(PROC,X) ) ) ).

fof(miloA3152,axiom,
    p__d__subclass(c__SolidFood,c__PreparedFood) ).

fof(miloA3153,axiom,
    ! [X] :
      ( p__d__instance(X,c__SolidFood)
     => ? [ING] :
          ( p__d__instance(ING,c__Object)
          & p__part(ING,X)
          & p__attribute(ING,c__Solid) ) ) ).

fof(miloA3154,axiom,
    p__d__subclass(c__LiquidFood,c__PreparedFood) ).

fof(miloA3155,axiom,
    ! [X] :
      ( p__d__instance(X,c__LiquidFood)
     => ! [ING] :
          ( ~ p__d__instance(ING,c__Object)
          | ~ p__part(ING,X)
          | ~ p__attribute(ING,c__Solid) ) ) ).

fof(miloA3156,axiom,
    p__d__subclass(c__Beverage,c__LiquidFood) ).

fof(miloA3157,axiom,
    p__d__subclass(c__Beverage,c__Substance) ).

fof(miloA3158,axiom,
    p__d__disjoint(c__Meat,c__Beverage) ).

fof(miloA3159,axiom,
    ! [BEV] :
      ( p__d__instance(BEV,c__Beverage)
     => p__attribute(BEV,c__Liquid) ) ).

fof(miloA3160,axiom,
    ! [DRINK,BEV] :
      ( ( p__d__instance(DRINK,c__Drinking)
        & p__patient(DRINK,BEV) )
     => p__d__instance(BEV,c__Beverage) ) ).

fof(miloA3161,axiom,
    p__d__instance(c__CookedAttribute,c__RelationalAttribute) ).

fof(miloA3162,axiom,
    ! [FOOD] :
      ( ( p__d__instance(FOOD,c__Object)
        & p__attribute(FOOD,c__CookedAttribute) )
     => ? [PROC] :
          ( p__d__instance(PROC,c__Cooking)
          & p__result(PROC,FOOD) ) ) ).

fof(miloA3163,axiom,
    p__d__instance(c__RawAttribute,c__RelationalAttribute) ).

fof(miloA3165,axiom,
    ! [FOOD] :
      ( ( p__d__instance(FOOD,c__Object)
        & p__attribute(FOOD,c__RawAttribute) )
     => ! [PROC] :
          ( ~ p__d__instance(PROC,c__Process)
          | ~ p__d__instance(PROC,c__Cooking)
          | ~ p__result(PROC,FOOD) ) ) ).

fof(miloA3166,axiom,
    p__d__subclass(c__Baking,c__Cooking) ).

fof(miloA3167,axiom,
    p__d__subclass(c__Baking,c__Heating) ).

fof(miloA3168,axiom,
    ! [B] :
      ( p__d__instance(B,c__Baking)
     => ? [O] :
          ( p__d__instance(O,c__Oven)
          & p__instrument(B,O) ) ) ).

fof(miloA3169,axiom,
    p__d__subclass(c__BreadOrBiscuit,c__PreparedFood) ).

fof(miloA3170,axiom,
    ! [B] :
      ( p__d__instance(B,c__BreadOrBiscuit)
     => ? [D,BAKE] :
          ( p__d__instance(D,c__Dough)
          & p__d__instance(BAKE,c__Baking)
          & p__resource(BAKE,D)
          & p__result(BAKE,B) ) ) ).

fof(miloA3171,axiom,
    p__d__subclass(c__Sandwich,c__PreparedFood) ).

fof(miloA3173,axiom,
    p__d__subclass(c__Dough,c__PreparedFood) ).

fof(miloA3174,axiom,
    p__d__subclass(c__Dough,c__Mixture) ).

fof(miloA3175,axiom,
    ! [D] :
      ( p__d__instance(D,c__Dough)
     => ? [F,W] :
          ( p__d__instance(F,c__Flour)
          & p__d__instance(W,c__Water)
          & p__part(F,D)
          & p__part(W,D) ) ) ).

fof(miloA3176,axiom,
    p__d__subclass(c__Butter,c__PreparedFood) ).

fof(miloA3177,axiom,
    ! [B] :
      ( p__d__instance(B,c__Butter)
     => ? [C,M] :
          ( p__d__instance(C,c__Cooking)
          & p__resource(C,M)
          & p__d__instance(M,c__Milk)
          & p__result(C,B) ) ) ).

fof(miloA3178,axiom,
    p__d__subclass(c__CerealGrain,c__Seed) ).

fof(miloA3179,axiom,
    p__d__subclass(c__RiceGrain,c__CerealGrain) ).

fof(miloA3180,axiom,
    p__d__subclass(c__WheatGrain,c__CerealGrain) ).

fof(miloA3181,axiom,
    p__d__subclass(c__Pea,c__Seed) ).

fof(miloA3183,axiom,
    p__d__subclass(c__Flour,c__PreparedFood) ).

fof(miloA3184,axiom,
    p__d__subclass(c__Flour,c__Powder) ).

fof(miloA3185,axiom,
    ! [F] :
      ( p__d__instance(F,c__Flour)
     => ? [P,C] :
          ( p__d__instance(P,c__IntentionalProcess)
          & p__resource(P,C)
          & p__d__instance(C,c__CerealGrain)
          & p__result(P,F) ) ) ).

fof(miloA3186,axiom,
    p__d__subclass(c__Honey,c__AnimalSubstance) ).

fof(miloA3188,axiom,
    ! [H] :
      ( p__d__instance(H,c__Honey)
     => ? [P,B] :
          ( p__d__instance(P,c__PhysiologicProcess)
          & p__agent(P,B)
          & p__d__instance(B,c__Bee)
          & p__result(P,H) ) ) ).

fof(miloA3189,axiom,
    p__d__subclass(c__Coconut,c__FruitOrVegetable) ).

fof(miloA3191,axiom,
    p__d__subclass(c__MaizeGrain,c__CerealGrain) ).

fof(miloA3192,axiom,
    p__d__subclass(c__SoupStock,c__PreparedFood) ).

fof(miloA3193,axiom,
    p__d__subclass(c__Coffee,c__Beverage) ).

fof(miloA3194,axiom,
    p__d__subclass(c__Coffee,c__PreparedFood) ).

fof(miloA3195,axiom,
    p__d__subclass(c__Apple,c__FruitOrVegetable) ).

fof(miloA3197,axiom,
    p__d__subclass(c__DateFruit,c__FruitOrVegetable) ).

fof(miloA3199,axiom,
    p__d__subclass(c__PearFruit,c__FruitOrVegetable) ).

fof(miloA3201,axiom,
    p__d__subclass(c__Avocado,c__FruitOrVegetable) ).

fof(miloA3203,axiom,
    p__d__subclass(c__Ion,c__PureSubstance) ).

fof(miloA3204,axiom,
    p__d__subclass(c__FreeAtom,c__Atom) ).

fof(miloA3205,axiom,
    ! [A] :
      ( p__d__instance(A,c__FreeAtom)
     => ! [M] :
          ( ~ p__d__instance(M,c__Object)
          | ~ p__d__instance(M,c__Molecule)
          | ~ p__part(A,M) ) ) ).

fof(miloA3206,axiom,
    p__d__instance(c__protonNumber,c__BinaryPredicate) ).

fof(miloA3207,axiom,
    p__d__instance(c__protonNumber,c__SingleValuedRelation) ).

fof(miloA3208,axiom,
    p__d__instance(c__protonNumber,c__TotalValuedRelation) ).

fof(miloA3212,axiom,
    p__d__instance(c__electronNumber,c__BinaryPredicate) ).

fof(miloA3213,axiom,
    p__d__instance(c__electronNumber,c__SingleValuedRelation) ).

fof(miloA3214,axiom,
    p__d__instance(c__electronNumber,c__TotalValuedRelation) ).

fof(miloA3218,axiom,
    p__d__subclass(c__AtomicGroup,c__CompoundSubstance) ).

fof(miloA3219,axiom,
    ! [G] :
      ( p__d__instance(G,c__AtomicGroup)
     => ? [ATOM1,ATOM2] :
          ( p__d__instance(ATOM1,c__Atom)
          & p__d__instance(ATOM2,c__Atom)
          & ATOM1 != ATOM2
          & p__part(ATOM1,G)
          & p__part(ATOM2,G) ) ) ).

fof(miloA3220,axiom,
    ! [G] :
      ( p__d__instance(G,c__AtomicGroup)
     => ? [M] :
          ( p__d__instance(M,c__Molecule)
          & p__part(G,M) ) ) ).

fof(miloA3221,axiom,
    p__d__subclass(c__Ambush,c__Maneuver) ).

fof(miloA3223,axiom,
    p__d__subclass(c__Blockade,c__Maneuver) ).

fof(miloA3225,axiom,
    p__d__subclass(c__MilitaryManeuver,c__Maneuver) ).

fof(miloA3226,axiom,
    ! [M] :
      ( p__d__instance(M,c__MilitaryManeuver)
     => ? [B] :
          ( p__d__instance(B,c__Battle)
          & p__subProcess(M,B) ) ) ).

fof(miloA3227,axiom,
    p__d__subclass(c__Fire,c__Combustion) ).

fof(miloA3228,axiom,
    p__d__subclass(c__Arson,c__Fire) ).

fof(miloA3229,axiom,
    p__d__subclass(c__Arson,c__Destruction) ).

fof(miloA3230,axiom,
    p__d__subclass(c__Bombing,c__Destruction) ).

fof(miloA3231,axiom,
    p__d__subclass(c__Bomb,c__Weapon) ).

fof(miloA3232,axiom,
    p__d__subclass(c__Bomb,c__ExplosiveDevice) ).

fof(miloA3233,axiom,
    ! [X] :
      ( p__d__instance(X,c__Bombing)
     => ? [BOMB] :
          ( p__d__instance(BOMB,c__Bomb)
          & p__instrument(X,BOMB) ) ) ).

fof(miloA3234,axiom,
    p__d__subclass(c__CarBombing,c__Bombing) ).

fof(miloA3235,axiom,
    ! [X] :
      ( p__d__instance(X,c__CarBombing)
     => ? [BOMB,CAR] :
          ( p__d__instance(BOMB,c__Bomb)
          & p__d__instance(CAR,c__TransportationDevice)
          & p__instrument(X,CAR)
          & p__instrument(X,BOMB)
          & p__connected(CAR,BOMB) ) ) ).

fof(miloA3236,axiom,
    p__d__subclass(c__ChemicalAttack,c__ViolentContest) ).

fof(miloA3237,axiom,
    ! [X] :
      ( p__d__instance(X,c__ChemicalAttack)
     => ? [CHEM] :
          ( p__d__instance(CHEM,c__Substance)
          & p__instrument(X,CHEM) ) ) ).

fof(miloA3238,axiom,
    p__d__subclass(c__HandgrenadeAttack,c__Bombing) ).

fof(miloA3239,axiom,
    p__d__subclass(c__HandGrenade,c__Bomb) ).

fof(miloA3240,axiom,
    ! [X] :
      ( p__d__instance(X,c__HandGrenade)
     => ? [N] :
          ( p__d__instance(N,c__RealNumber)
          & p__measure(X,f__MeasureFn2(N,c__PoundMass))
          & p__lessThan(N,c__10) ) ) ).

fof(miloA3241,axiom,
    ! [X] :
      ( p__d__instance(X,c__HandgrenadeAttack)
     => ? [HG] :
          ( p__d__instance(HG,c__HandGrenade)
          & p__instrument(X,HG) ) ) ).

fof(miloA3242,axiom,
    p__d__subclass(c__Hijacking,c__Robbing) ).

fof(miloA3243,axiom,
    ! [H] :
      ( p__d__instance(H,c__Hijacking)
     => ? [V] :
          ( p__d__instance(V,c__Vehicle)
          & p__patient(H,V) ) ) ).

fof(miloA3244,axiom,
    ! [H] :
      ( p__d__instance(H,c__Hijacking)
     => ? [D] :
          ( p__subProcess(D,H)
          & p__d__instance(D,c__Driving) ) ) ).

fof(miloA3246,axiom,
    p__d__subclass(c__HostageTaking,c__UnilateralGetting) ).

fof(miloA3247,axiom,
    ! [X] :
      ( p__d__instance(X,c__HostageTaking)
     => ? [A] :
          ( p__d__instance(A,c__SentientAgent)
          & p__patient(X,A) ) ) ).

fof(miloA3248,axiom,
    p__d__subclass(c__IncendiaryDeviceAttack,c__Combustion) ).

fof(miloA3249,axiom,
    p__d__subclass(c__IncendiaryDeviceAttack,c__ViolentContest) ).

fof(miloA3250,axiom,
    p__d__subclass(c__Infiltration,c__JoiningAnOrganization) ).

fof(miloA3251,axiom,
    p__d__subclass(c__Kidnapping,c__Robbing) ).

fof(miloA3252,axiom,
    ! [X,G,N] :
      ( ( p__d__instance(N,c__Integer)
        & p__d__instance(X,c__Kidnapping)
        & p__d__instance(G,c__GroupOfPeople)
        & p__memberCount(G,N)
        & p__patient(X,G) )
     => p__lessThan(N,c__3) ) ).

fof(miloA3254,axiom,
    p__d__subclass(c__KnifeAttack,c__ViolentContest) ).

fof(miloA3255,axiom,
    p__d__subclass(c__Knife,c__CuttingDevice) ).

fof(miloA3256,axiom,
    p__d__subclass(c__CuttingDevice,c__Device) ).

fof(miloA3258,axiom,
    ! [X] :
      ( p__d__instance(X,c__KnifeAttack)
     => ? [HG] :
          ( p__d__instance(HG,c__Knife)
          & p__instrument(X,HG) ) ) ).

fof(miloA3259,axiom,
    p__d__subclass(c__Blade,c__CuttingDevice) ).

fof(miloA3260,axiom,
    ! [B] :
      ( p__d__instance(B,c__Blade)
     => ? [CD] :
          ( p__d__instance(CD,c__CuttingDevice)
          & p__part(B,CD) ) ) ).

fof(miloA3261,axiom,
    ! [CUT,B,OBJ] :
      ( ( p__d__instance(B,c__Blade)
        & p__d__instance(CUT,c__Cutting)
        & p__d__instance(OBJ,c__Object)
        & p__instrument(CUT,B)
        & p__patient(CUT,OBJ)
        & B != OBJ )
     => p__meetsSpatially(B,OBJ) ) ).

fof(miloA3262,axiom,
    p__d__subclass(c__LetterBombAttack,c__Bombing) ).

fof(miloA3263,axiom,
    p__d__subclass(c__Lynching,c__Killing) ).

fof(miloA3264,axiom,
    p__d__subclass(c__MortarAttack,c__Bombing) ).

fof(miloA3265,axiom,
    p__d__subclass(c__Mortar,c__Weapon) ).

fof(miloA3266,axiom,
    ! [X] :
      ( p__d__instance(X,c__MortarAttack)
     => ? [MA] :
          ( p__d__instance(MA,c__Mortar)
          & p__instrument(X,MA) ) ) ).

fof(miloA3267,axiom,
    p__d__subclass(c__RocketMissileAttack,c__Bombing) ).

fof(miloA3268,axiom,
    p__d__subclass(c__Rocket,c__Projectile) ).

fof(miloA3269,axiom,
    p__d__subclass(c__Stoning,c__ViolentContest) ).

fof(miloA3270,axiom,
    ! [X] :
      ( p__d__instance(X,c__Stoning)
     => ? [ST] :
          ( p__d__instance(ST,c__Rock)
          & p__instrument(X,ST) ) ) ).

fof(miloA3271,axiom,
    p__d__subclass(c__SuicideBombing,c__Bombing) ).

fof(miloA3272,axiom,
    p__d__subclass(c__SuicideBombing,c__Killing) ).

fof(miloA3275,axiom,
    p__d__subclass(c__Vandalism,c__Destruction) ).

fof(miloA3276,axiom,
    ! [X] :
      ( p__d__instance(X,c__Vandalism)
     => ! [A] :
          ( ~ p__d__instance(A,c__Agent)
          | ~ p__patient(X,A) ) ) ).

fof(miloA3277,axiom,
    p__d__subclass(c__VehicleAttack,c__ViolentContest) ).

fof(miloA3278,axiom,
    ! [X] :
      ( p__d__instance(X,c__VehicleAttack)
     => ? [V] :
          ( p__d__instance(V,c__TransportationDevice)
          & p__instrument(X,V) ) ) ).

fof(miloA3279,axiom,
    p__d__instance(c__BusinessPerson,c__OccupationalRole) ).

fof(miloA3280,axiom,
    p__subAttribute(c__BusinessExecutive,c__BusinessPerson) ).

fof(miloA3281,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Agent)
        & p__attribute(X,c__BusinessExecutive) )
     => ? [BUSINESS,MANAGE] :
          ( p__d__instance(MANAGE,c__Managing)
          & p__d__instance(BUSINESS,c__Organization)
          & p__patient(MANAGE,BUSINESS)
          & p__agent(MANAGE,X) ) ) ).

fof(miloA3282,axiom,
    p__d__instance(c__Celebrity,c__SocialRole) ).

fof(miloA3284,axiom,
    p__d__instance(c__Knight,c__SocialRole) ).

fof(miloA3285,axiom,
    p__d__instance(c__Musician,c__SocialRole) ).

fof(miloA3286,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Agent)
        & p__attribute(X,c__Musician) )
     => p__hasSkill(c__MusicalPerformance,X) ) ).

fof(miloA3287,axiom,
    p__d__instance(c__Veteran,c__SocialRole) ).

fof(miloA3289,axiom,
    p__d__subclass(c__Road,c__Region) ).

fof(miloA3290,axiom,
    p__d__subclass(c__Road,c__Roadway) ).

fof(miloA3292,axiom,
    p__contraryAttribute2(c__Civilian,c__MilitaryPerson) ).

fof(miloA3293,axiom,
    p__d__subclass(c__OccupationalRole,c__Position) ).

fof(miloA3294,axiom,
    p__d__instance(c__Civilian,c__SocialRole) ).

fof(miloA3296,axiom,
    p__d__instance(c__Widowed,c__SocialRole) ).

fof(miloA3298,axiom,
    p__d__subclass(c__Convoy,c__Collection) ).

fof(miloA3300,axiom,
    ! [C,VEH] :
      ( ( p__d__instance(VEH,c__SelfConnectedObject)
        & p__d__instance(C,c__Convoy)
        & p__member(VEH,C) )
     => ? [DRIVE] :
          ( p__d__instance(DRIVE,c__Driving)
          & p__overlapsTemporally(f__WhenFn1(DRIVE),f__WhenFn1(C))
          & p__patient(DRIVE,VEH) ) ) ).

fof(miloA3301,axiom,
    ! [C] :
      ( p__d__instance(C,c__Convoy)
     => p__attribute(C,c__LineFormation) ) ).

fof(miloA3302,axiom,
    p__d__instance(c__Diplomat,c__OccupationalRole) ).

fof(miloA3303,axiom,
    p__subAttribute(c__Diplomat,c__GovernmentPerson) ).

fof(miloA3304,axiom,
    p__d__instance(c__Dissident,c__SocialRole) ).

fof(miloA3305,axiom,
    p__d__subclass(c__EmbassyBuilding,c__GovernmentBuilding) ).

fof(miloA3306,axiom,
    ! [X] :
      ( p__d__instance(X,c__EmbassyBuilding)
     => ? [EGOV,OTHERGOV] :
          ( p__d__instance(EGOV,c__Nation)
          & p__d__instance(OTHERGOV,c__Nation)
          & EGOV != OTHERGOV
          & p__possesses(EGOV,X)
          & p__located(X,OTHERGOV) ) ) ).

fof(miloA3307,axiom,
    p__d__subclass(c__EntertainmentBuilding,c__Building) ).

fof(miloA3309,axiom,
    p__d__subclass(c__GovernmentBuilding,c__Building) ).

fof(miloA3310,axiom,
    ! [X] :
      ( p__d__instance(X,c__GovernmentBuilding)
     => ? [G] :
          ( p__d__instance(G,c__Government)
          & p__possesses(G,X) ) ) ).

fof(miloA3311,axiom,
    p__d__instance(c__GovernmentPerson,c__OccupationalRole) ).

fof(miloA3313,axiom,
    p__d__subclass(c__Renting,c__FinancialTransaction) ).

fof(miloA3314,axiom,
    p__d__subclass(c__Renting,c__Borrowing) ).

fof(miloA3316,axiom,
    p__d__subclass(c__Marketplace,c__GeographicArea) ).

fof(miloA3318,axiom,
    p__d__instance(c__StoreOwner,c__OccupationalRole) ).

fof(miloA3319,axiom,
    p__subAttribute(c__StoreOwner,c__BusinessPerson) ).

fof(miloA3320,axiom,
    p__d__instance(c__Militant,c__SocialRole) ).

fof(miloA3321,axiom,
    p__d__instance(c__MilitaryPerson,c__OccupationalRole) ).

fof(miloA3324,axiom,
    p__d__subclass(c__OfficeBuilding,c__Building) ).

fof(miloA3325,axiom,
    p__d__subclass(c__PeaceKeepingMission,c__MilitaryOrganization) ).

fof(miloA3326,axiom,
    p__d__subclass(c__PlaceOfWorship,c__Building) ).

fof(miloA3328,axiom,
    p__d__subclass(c__PoliceFacility,c__Building) ).

fof(miloA3329,axiom,
    p__d__instance(c__PolicePerson,c__OccupationalRole) ).

fof(miloA3330,axiom,
    p__subAttribute(c__PolicePerson,c__GovernmentPerson) ).

fof(miloA3331,axiom,
    p__subAttribute(c__PoliticalFigure,c__Celebrity) ).

fof(miloA3332,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Agent)
        & p__attribute(X,c__PoliticalFigure) )
     => ? [EV] :
          ( p__agent(EV,X)
          & p__d__instance(EV,c__PoliticalProcess) ) ) ).

fof(miloA3334,axiom,
    p__subAttribute(c__ReligiousFigure,c__Celebrity) ).

fof(miloA3335,axiom,
    p__d__subclass(c__RestaurantBuilding,c__Building) ).

fof(miloA3337,axiom,
    p__d__subclass(c__EducationalFacility,c__StationaryArtifact) ).

fof(miloA3338,axiom,
    ! [X] :
      ( p__d__instance(X,c__EducationalFacility)
     => ? [ORG] :
          ( p__d__instance(ORG,c__EducationalOrganization)
          & p__possesses(ORG,X) ) ) ).

fof(miloA3340,axiom,
    p__d__instance(c__Student,c__SocialRole) ).

fof(miloA3341,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Student) )
     => ? [EV] :
          ( p__d__instance(EV,c__EducationalProcess)
          & p__patient(EV,X) ) ) ).

fof(miloA3342,axiom,
    p__d__subclass(c__Subway,c__Hole) ).

fof(miloA3345,axiom,
    p__d__instance(c__Tourist,c__SocialRole) ).

fof(miloA3346,axiom,
    p__d__subclass(c__TouristSite,c__GeographicArea) ).

fof(miloA3347,axiom,
    p__d__subclass(c__TerroristOrganization,c__PoliticalOrganization) ).

fof(miloA3348,axiom,
    ! [X] :
      ( p__d__instance(X,c__TerroristOrganization)
     => ? [EV] :
          ( p__d__instance(EV,c__ViolentContest)
          & p__agent(EV,X) ) ) ).

fof(miloA3349,axiom,
    p__d__instance(c__memberCount,c__BinaryPredicate) ).

fof(miloA3353,axiom,
    p__d__instance(c__memberType,c__BinaryPredicate) ).

fof(miloA3356,axiom,
    ! [GROUP,MEMBER,TYPE] :
      ( ( p__d__instance(TYPE,c__SetOrClass)
        & p__d__instance(GROUP,c__Collection)
        & p__d__instance(MEMBER,c__SelfConnectedObject)
        & p__memberType(GROUP,TYPE)
        & p__member(MEMBER,GROUP) )
     => p__d__instance(MEMBER,TYPE) ) ).

fof(miloA3357,axiom,
    p__d__instance(c__memberTypeCount,c__TernaryPredicate) ).

fof(miloA3361,axiom,
    ! [GROUP,NUMBER,TYPE] :
      ( ( p__d__instance(NUMBER,c__NonnegativeInteger)
        & p__d__instance(TYPE,c__SetOrClass)
        & p__d__instance(GROUP,c__Collection)
        & p__memberTypeCount(GROUP,TYPE,NUMBER)
        & p__greaterThan(NUMBER,c__0) )
     => ? [SUBGROUP] :
          ( p__d__instance(SUBGROUP,c__Collection)
          & p__subCollection(SUBGROUP,GROUP)
          & p__memberCount(SUBGROUP,NUMBER)
          & p__memberType(SUBGROUP,TYPE) ) ) ).

fof(miloA3362,axiom,
    ! [GROUP,TYPE,NUMBER1,NUMBER2] :
      ( ( p__d__instance(NUMBER1,c__Integer)
        & p__d__instance(GROUP,c__Collection)
        & p__d__instance(NUMBER2,c__NonnegativeInteger)
        & p__d__instance(TYPE,c__SetOrClass)
        & p__memberCount(GROUP,NUMBER1)
        & p__memberTypeCount(GROUP,TYPE,NUMBER2) )
     => p__greaterThanOrEqualTo(NUMBER1,NUMBER2) ) ).

fof(miloA3363,axiom,
    ! [NUMBER,TYPE,GROUP] :
      ( ( p__d__instance(NUMBER,c__NonnegativeInteger)
        & p__d__instance(TYPE,c__SetOrClass)
        & p__d__instance(GROUP,c__Collection)
        & p__memberTypeCount(GROUP,TYPE,NUMBER)
        & NUMBER = c__0 )
     => ! [ITEM] :
          ( ~ p__d__instance(ITEM,c__SelfConnectedObject)
          | ~ p__d__instance(ITEM,TYPE)
          | ~ p__member(ITEM,GROUP) ) ) ).

fof(miloA3364,axiom,
    p__d__instance(c__memberAtTime,c__TernaryPredicate) ).

fof(miloA3369,axiom,
    ! [COLLECTION,OBJ,TIME,PLACE] :
      ( ( p__d__instance(PLACE,c__Object)
        & p__d__instance(TIME,c__TimePosition)
        & p__d__instance(COLLECTION,c__Collection)
        & p__d__instance(OBJ,c__SelfConnectedObject)
        & p__locatedAtTime(COLLECTION,TIME,PLACE)
        & p__memberAtTime(OBJ,COLLECTION,TIME) )
     => p__locatedAtTime(OBJ,TIME,PLACE) ) ).

fof(miloA3370,axiom,
    p__d__instance(c__inventory,c__BinaryPredicate) ).

fof(miloA3373,axiom,
    ! [C,O,I] :
      ( ( p__d__instance(C,c__Collection)
        & p__d__instance(O,c__ContentBearingObject)
        & p__d__instance(I,c__SelfConnectedObject)
        & p__inventory(O,C)
        & p__member(I,C) )
     => p__refers(O,I) ) ).

fof(miloA3374,axiom,
    p__d__instance(c__subordinateInOrganization,c__TernaryPredicate) ).

fof(miloA3378,axiom,
    ! [PERSON2,ORG,PERSON1] :
      ( ( p__d__instance(PERSON2,c__Human)
        & p__d__instance(PERSON1,c__Human)
        & p__d__instance(ORG,c__Organization)
        & p__subordinateInOrganization(ORG,PERSON1,PERSON2) )
     => p__employs(ORG,PERSON1) ) ).

fof(miloA3379,axiom,
    ! [PERSON1,ORG,PERSON2] :
      ( ( p__d__instance(PERSON2,c__Human)
        & p__d__instance(PERSON1,c__Human)
        & p__d__instance(ORG,c__Organization)
        & p__subordinateInOrganization(ORG,PERSON1,PERSON2) )
     => p__employs(ORG,PERSON2) ) ).

fof(miloA3380,axiom,
    p__d__instance(c__subordinatePosition,c__TernaryPredicate) ).

fof(miloA3384,axiom,
    ! [ROLE1,ROLE2,ORG,PERSON1] :
      ( ( p__d__instance(ROLE2,c__Position)
        & p__d__instance(ROLE1,c__Position)
        & p__d__instance(ORG,c__Organization)
        & p__d__instance(PERSON1,c__Human)
        & p__subordinatePosition(ORG,ROLE1,ROLE2)
        & p__occupiesPosition(PERSON1,ROLE1,ORG) )
     => ? [PERSON2] :
          ( p__d__instance(PERSON2,c__Human)
          & p__occupiesPosition(PERSON2,ROLE2,ORG)
          & p__subordinateInOrganization(ORG,PERSON1,PERSON2) ) ) ).

fof(miloA3385,axiom,
    p__d__instance(c__operator,c__BinaryPredicate) ).

fof(miloA3386,axiom,
    p__d__instance(c__operator,c__AsymmetricRelation) ).

fof(miloA3387,axiom,
    p__d__instance(c__operator,c__IrreflexiveRelation) ).

fof(miloA3390,axiom,
    p__d__subclass(c__ClassificationScheme,c__Proposition) ).

fof(miloA3391,axiom,
    p__d__subclass(c__Taxonomy,c__ClassificationScheme) ).

fof(miloA3392,axiom,
    p__d__instance(c__abstractPart,c__PartialOrderingRelation) ).

fof(miloA3395,axiom,
    p__d__subclass(c__Ontology,c__ClassificationScheme) ).

fof(miloA3396,axiom,
    ! [ONT] :
      ( p__d__instance(ONT,c__Ontology)
     => ? [TAX] :
          ( p__d__instance(TAX,c__Taxonomy)
          & p__abstractPart(TAX,ONT) ) ) ).

fof(miloA3397,axiom,
    p__d__instance(c__transported,c__BinaryPredicate) ).

fof(miloA3398,axiom,
    p__d__instance(c__transported,c__AsymmetricRelation) ).

fof(miloA3401,axiom,
    p__subrelation(c__transported,c__patient) ).

fof(miloA3402,axiom,
    p__d__instance(c__cargo,c__BinaryPredicate) ).

fof(miloA3403,axiom,
    p__d__instance(c__cargo,c__AsymmetricRelation) ).

fof(miloA3406,axiom,
    p__subrelation(c__cargo,c__transported) ).

fof(miloA3407,axiom,
    p__d__instance(c__serviceProvider,c__BinaryPredicate) ).

fof(miloA3408,axiom,
    p__d__instance(c__serviceProvider,c__AsymmetricRelation) ).

fof(miloA3409,axiom,
    p__d__instance(c__serviceProvider,c__IntentionalRelation) ).

fof(miloA3412,axiom,
    p__subrelation(c__serviceProvider,c__agent) ).

fof(miloA3413,axiom,
    p__d__instance(c__serviceRecipient,c__BinaryPredicate) ).

fof(miloA3414,axiom,
    p__d__instance(c__serviceRecipient,c__AsymmetricRelation) ).

fof(miloA3415,axiom,
    p__d__instance(c__serviceRecipient,c__IntentionalRelation) ).

fof(miloA3418,axiom,
    p__subrelation(c__serviceRecipient,c__experiencer) ).

fof(miloA3419,axiom,
    ! [EVENT] :
      ( p__d__instance(EVENT,c__ServiceProcess)
     => ? [PROVIDER] :
          ( p__d__instance(PROVIDER,c__CognitiveAgent)
          & p__serviceProvider(EVENT,PROVIDER) ) ) ).

fof(miloA3420,axiom,
    ! [EVENT] :
      ( p__d__instance(EVENT,c__ServiceProcess)
     => ? [RECEIVER] :
          ( p__d__instance(RECEIVER,c__CognitiveAgent)
          & p__serviceRecipient(EVENT,RECEIVER) ) ) ).

fof(miloA3421,axiom,
    p__d__instance(c__benefits,c__BinaryPredicate) ).

fof(miloA3422,axiom,
    p__d__instance(c__benefits,c__AsymmetricRelation) ).

fof(miloA3425,axiom,
    ! [PROCESS,AGENT,PROCESSSTART,AGENTEND] :
      ( ( p__d__instance(PROCESS,c__Process)
        & p__d__instance(PROCESSSTART,c__TimePoint)
        & p__d__instance(AGENT,c__Agent)
        & p__d__instance(AGENTEND,c__TimePoint)
        & PROCESSSTART = f__BeginFn1(f__WhenFn1(PROCESS))
        & AGENTEND = f__EndFn1(f__WhenFn1(AGENT))
        & p__benefits(PROCESS,AGENT) )
     => p__before(PROCESSSTART,AGENTEND) ) ).

fof(miloA3426,axiom,
    p__d__instance(c__areaOfResponsibility,c__TernaryPredicate) ).

fof(miloA3430,axiom,
    p__d__instance(c__friend,c__BinaryPredicate) ).

fof(miloA3431,axiom,
    p__d__instance(c__friend,c__SymmetricRelation) ).

fof(miloA3432,axiom,
    p__d__instance(c__friend,c__IntentionalRelation) ).

fof(miloA3435,axiom,
    p__subrelation(c__friend,c__mutualAcquaintance) ).

fof(miloA3436,axiom,
    p__d__instance(c__coworker,c__BinaryPredicate) ).

fof(miloA3437,axiom,
    p__d__instance(c__coworker,c__SymmetricRelation) ).

fof(miloA3440,axiom,
    p__subrelation(c__coworker,c__mutualAcquaintance) ).

fof(miloA3442,axiom,
    p__d__instance(c__cohabitant,c__BinaryPredicate) ).

fof(miloA3443,axiom,
    p__d__instance(c__cohabitant,c__SymmetricRelation) ).

fof(miloA3444,axiom,
    p__d__instance(c__cohabitant,c__IntentionalRelation) ).

fof(miloA3447,axiom,
    p__subrelation(c__cohabitant,c__mutualAcquaintance) ).

fof(miloA3450,axiom,
    p__d__instance(c__grandparent,c__BinaryPredicate) ).

fof(miloA3451,axiom,
    p__d__instance(c__grandparent,c__AsymmetricRelation) ).

fof(miloA3454,axiom,
    p__subrelation(c__grandmother,c__grandparent) ).

fof(miloA3455,axiom,
    p__subrelation(c__grandfather,c__grandparent) ).

fof(miloA3456,axiom,
    p__subrelation(c__grandparent,c__ancestor) ).

fof(miloA3457,axiom,
    ! [CHILD,PARENT] :
      ( ( p__d__instance(CHILD,c__Organism)
        & p__parent(CHILD,PARENT)
        & p__d__instance(PARENT,c__Man) )
     => p__father(CHILD,PARENT) ) ).

fof(miloA3458,axiom,
    ! [CHILD,PARENT] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__parent(CHILD,PARENT)
        & p__d__instance(CHILD,c__Man) )
     => p__son(CHILD,PARENT) ) ).

fof(miloA3459,axiom,
    ! [CHILD,PARENT] :
      ( ( p__d__instance(PARENT,c__Organism)
        & p__parent(CHILD,PARENT)
        & p__d__instance(CHILD,c__Woman) )
     => p__daughter(CHILD,PARENT) ) ).

fof(miloA3462,axiom,
    p__subrelation(c__aunt,c__familyRelation) ).

fof(miloA3463,axiom,
    ! [A,H] :
      ( ( p__d__instance(H,c__Human)
        & p__d__instance(A,c__Woman) )
     => ( p__aunt(A,H)
      <=> ? [P] :
            ( p__d__instance(P,c__Human)
            & p__sister(A,P)
            & p__parent(H,P) ) ) ) ).

fof(miloA3466,axiom,
    p__subrelation(c__cousin,c__familyRelation) ).

fof(miloA3467,axiom,
    ! [P1,P2] :
      ( ( p__d__instance(P2,c__Human)
        & p__d__instance(P1,c__Human) )
     => ( p__cousin(P1,P2)
      <=> ( ? [G1,G2] :
              ( p__d__instance(G1,c__Woman)
              & p__d__instance(G2,c__Man)
              & p__grandmother(P1,G1)
              & p__grandfather(P1,G2)
              & p__grandmother(P2,G1)
              & p__grandfather(P2,G2) )
          & ! [M,F] :
              ( ~ p__d__instance(M,c__Organism)
              | ~ p__d__instance(F,c__Organism)
              | ~ p__mother(P1,M)
              | ~ p__father(P1,F)
              | ~ p__mother(P2,M)
              | ~ p__father(P2,F) ) ) ) ) ).

fof(miloA3470,axiom,
    p__subrelation(c__grandfather,c__familyRelation) ).

fof(miloA3471,axiom,
    ! [P,H] :
      ( ( p__d__instance(P,c__Man)
        & p__d__instance(H,c__Human)
        & p__grandfather(H,P) )
     => ? [C] :
          ( p__d__instance(C,c__Organism)
          & p__father(C,P)
          & p__parent(H,C) ) ) ).

fof(miloA3474,axiom,
    p__subrelation(c__grandmother,c__familyRelation) ).

fof(miloA3475,axiom,
    ! [P,H] :
      ( ( p__d__instance(P,c__Woman)
        & p__d__instance(H,c__Human)
        & p__grandmother(H,P) )
     => ? [C] :
          ( p__d__instance(C,c__Organism)
          & p__mother(C,P)
          & p__parent(H,C) ) ) ).

fof(miloA3478,axiom,
    p__subrelation(c__nephew,c__familyRelation) ).

fof(miloA3479,axiom,
    ! [H,N] :
      ( ( p__d__instance(H,c__Human)
        & p__d__instance(N,c__Man) )
     => ( p__nephew(N,H)
      <=> ? [S] :
            ( p__d__instance(S,c__Organism)
            & p__sibling(S,H)
            & p__son(N,S) ) ) ) ).

fof(miloA3482,axiom,
    p__subrelation(c__niece,c__familyRelation) ).

fof(miloA3483,axiom,
    ! [H,N] :
      ( ( p__d__instance(H,c__Human)
        & p__d__instance(N,c__Woman) )
     => ( p__niece(N,H)
      <=> ? [S] :
            ( p__d__instance(S,c__Organism)
            & p__sibling(S,H)
            & p__daughter(N,S) ) ) ) ).

fof(miloA3486,axiom,
    p__subrelation(c__uncle,c__familyRelation) ).

fof(miloA3487,axiom,
    ! [U,H] :
      ( ( p__d__instance(H,c__Human)
        & p__d__instance(U,c__Man) )
     => ( p__uncle(U,H)
      <=> ? [P] :
            ( p__d__instance(P,c__Human)
            & p__brother(U,P)
            & p__parent(H,P) ) ) ) ).

fof(miloA3490,axiom,
    p__subrelation(c__stepfather,c__legalRelation) ).

fof(miloA3491,axiom,
    ! [P,F] :
      ( ( p__d__instance(F,c__Man)
        & p__d__instance(P,c__Human) )
     => ( p__stepfather(P,F)
      <=> ? [M] :
            ( p__d__instance(M,c__Human)
            & p__mother(P,M)
            & p__spouse(F,M)
            & ~ p__father(P,F) ) ) ) ).

fof(miloA3494,axiom,
    p__subrelation(c__stepmother,c__legalRelation) ).

fof(miloA3495,axiom,
    ! [P,M] :
      ( ( p__d__instance(M,c__Woman)
        & p__d__instance(P,c__Human) )
     => ( p__stepmother(P,M)
      <=> ? [F] :
            ( p__d__instance(F,c__Human)
            & p__father(P,F)
            & p__spouse(M,F)
            & ~ p__mother(P,M) ) ) ) ).

fof(miloA3496,axiom,
    p__d__subclass(c__NuclearFamily,c__FamilyGroup) ).

fof(miloA3497,axiom,
    p__d__subclass(c__NuclearFamily,c__SocialUnit) ).

fof(miloA3499,axiom,
    p__d__instance(c__alias,c__BinaryPredicate) ).

fof(miloA3500,axiom,
    p__d__instance(c__alias,c__AsymmetricRelation) ).

fof(miloA3503,axiom,
    p__subrelation(c__alias,c__names) ).

fof(miloA3504,axiom,
    p__d__instance(c__workAddress,c__BinaryPredicate) ).

fof(miloA3505,axiom,
    p__d__instance(c__workAddress,c__AsymmetricRelation) ).

fof(miloA3506,axiom,
    p__subrelation(c__workAddress,c__postContactSite) ).

fof(miloA3509,axiom,
    p__d__instance(c__homeAddress,c__BinaryPredicate) ).

fof(miloA3510,axiom,
    p__d__instance(c__homeAddress,c__AsymmetricRelation) ).

fof(miloA3513,axiom,
    p__subrelation(c__homeAddress,c__postContactSite) ).

fof(miloA3514,axiom,
    p__d__instance(c__playsRoleInEvent,c__TernaryPredicate) ).

fof(miloA3518,axiom,
    ! [ROLE,EVENT,OBJ] :
      ( ( p__d__instance(EVENT,c__Process)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__instance(OBJ,c__Object)
        & p__playsRoleInEvent(OBJ,ROLE,EVENT) )
     => p__d__holds3(ROLE,EVENT,OBJ) ) ).

fof(miloA3519,axiom,
    ! [ROLE,OBJ,ROLE2,EVENT] :
      ( ( p__d__instance(EVENT,c__Process)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__instance(OBJ,c__Object)
        & p__d__instance(ROLE2,c__CaseRole)
        & p__playsRoleInEvent(OBJ,ROLE,EVENT)
        & p__subrelation(ROLE,ROLE2) )
     => p__playsRoleInEvent(OBJ,ROLE2,EVENT) ) ).

fof(miloA3520,axiom,
    ! [OBJ,ROLE,EVENT] :
      ( ( p__d__holds3(ROLE,EVENT,OBJ)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__instance(EVENT,c__Process)
        & p__d__instance(OBJ,c__Object) )
     => p__playsRoleInEvent(OBJ,ROLE,EVENT) ) ).

fof(miloA3521,axiom,
    ! [EVENT,OBJ,ROLE,CLASS,TIME,PLACE] :
      ( ( p__d__instance(EVENT,c__Process)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__instance(OBJ,c__Object)
        & p__d__instance(TIME,c__TimePosition)
        & p__d__instance(PLACE,c__Object)
        & p__playsRoleInEvent(OBJ,ROLE,EVENT)
        & p__d__instance(EVENT,CLASS)
        & p__d__subclass(CLASS,c__Process)
        & p__time(EVENT,TIME)
        & p__eventLocated(EVENT,PLACE) )
     => p__playsRoleInEventOfType(OBJ,ROLE,CLASS,TIME,PLACE) ) ).

fof(miloA3522,axiom,
    p__d__instance(c__playsRoleInEventOfType,c__QuintaryPredicate) ).

fof(miloA3528,axiom,
    ! [TYPE,TIME,PLACE,OBJ,ROLE] :
      ( ( p__d__instance(PLACE,c__Object)
        & p__d__instance(TIME,c__TimePosition)
        & p__d__subclass(TYPE,c__Process)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__instance(OBJ,c__Object)
        & p__playsRoleInEventOfType(OBJ,ROLE,TYPE,TIME,PLACE) )
     => ? [EVENT] :
          ( p__d__instance(EVENT,c__Process)
          & p__d__instance(EVENT,TYPE)
          & p__time(EVENT,TIME)
          & p__eventLocated(EVENT,PLACE)
          & p__playsRoleInEvent(OBJ,ROLE,EVENT) ) ) ).

fof(miloA3529,axiom,
    ! [EVENT,OBJ,ROLE,TYPE,TIME,PLACE] :
      ( ( p__d__instance(EVENT,c__Process)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__instance(OBJ,c__Object)
        & p__d__instance(TIME,c__TimePosition)
        & p__d__instance(PLACE,c__Object)
        & p__playsRoleInEvent(OBJ,ROLE,EVENT)
        & p__d__instance(EVENT,TYPE)
        & p__d__subclass(TYPE,c__Process)
        & p__time(EVENT,TIME)
        & p__eventLocated(EVENT,PLACE) )
     => p__playsRoleInEventOfType(OBJ,ROLE,TYPE,TIME,PLACE) ) ).

fof(miloA3530,axiom,
    p__d__instance(c__locatedAtTime,c__TernaryPredicate) ).

fof(miloA3535,axiom,
    ! [ROLE,EVENT,OBJ,TIME,PLACE] :
      ( ( p__d__instance(EVENT,c__Process)
        & p__d__instance(ROLE,c__CaseRole)
        & p__d__instance(OBJ,c__Object)
        & p__d__instance(TIME,c__TimePosition)
        & p__d__instance(PLACE,c__Object)
        & p__playsRoleInEvent(OBJ,ROLE,EVENT)
        & p__time(EVENT,TIME)
        & p__eventLocated(EVENT,PLACE) )
     => p__locatedAtTime(OBJ,TIME,PLACE) ) ).

fof(miloA3536,axiom,
    p__d__instance(c__deceptiveIdentifier,c__BinaryPredicate) ).

fof(miloA3537,axiom,
    p__d__instance(c__deceptiveIdentifier,c__AsymmetricRelation) ).

fof(miloA3540,axiom,
    p__subrelation(c__deceptiveIdentifier,c__refers) ).

fof(miloA3541,axiom,
    p__subrelation(c__alias,c__deceptiveIdentifier) ).

fof(miloA3542,axiom,
    p__d__instance(c__stranger,c__BinaryPredicate) ).

fof(miloA3545,axiom,
    p__disjointRelation(c__stranger,c__acquaintance) ).

fof(miloA3546,axiom,
    p__d__instance(c__mutualStranger,c__BinaryPredicate) ).

fof(miloA3547,axiom,
    p__d__instance(c__mutualStranger,c__SymmetricRelation) ).

fof(miloA3550,axiom,
    p__subrelation(c__mutualStranger,c__stranger) ).

fof(miloA3551,axiom,
    p__disjointRelation(c__mutualStranger,c__mutualAcquaintance) ).

fof(miloA3552,axiom,
    p__d__instance(c__domesticPartner,c__BinaryPredicate) ).

fof(miloA3553,axiom,
    p__d__instance(c__domesticPartner,c__SymmetricRelation) ).

fof(miloA3554,axiom,
    p__d__instance(c__domesticPartner,c__IntentionalRelation) ).

fof(miloA3557,axiom,
    p__disjointRelation(c__spouse,c__domesticPartner) ).

fof(miloA3558,axiom,
    p__subrelation(c__domesticPartner,c__cohabitant) ).

fof(miloA3559,axiom,
    p__d__instance(c__legalGuardian,c__BinaryPredicate) ).

fof(miloA3560,axiom,
    p__d__instance(c__legalGuardian,c__AntisymmetricRelation) ).

fof(miloA3563,axiom,
    ! [PLACE,OBJ,TIME,REGION] :
      ( ( p__d__instance(PLACE,c__GeographicArea)
        & p__d__instance(TIME,c__TimePosition)
        & p__d__instance(OBJ,c__Object)
        & p__d__instance(REGION,c__GeographicArea)
        & p__locatedAtTime(OBJ,TIME,PLACE)
        & p__geographicSubregion(PLACE,REGION) )
     => p__locatedAtTime(OBJ,TIME,REGION) ) ).

fof(miloA3564,axiom,
    p__d__subclass(c__Seating,c__Guiding) ).

fof(miloA3565,axiom,
    ! [S] :
      ( p__d__instance(S,c__Seating)
     => ? [P,H] :
          ( p__experiencer(S,H)
          & p__d__instance(H,c__Human)
          & p__destination(S,P)
          & p__d__instance(P,c__Seat) ) ) ).

fof(miloA3566,axiom,
    p__d__subclass(c__Signalling,c__Guiding) ).

fof(miloA3567,axiom,
    p__d__subclass(c__AchievingControl,c__Guiding) ).

fof(miloA3568,axiom,
    p__d__instance(c__controlled,c__CaseRole) ).

fof(miloA3569,axiom,
    p__subrelation(c__controlled,c__patient) ).

fof(miloA3572,axiom,
    p__d__instance(c__gainsControl,c__CaseRole) ).

fof(miloA3573,axiom,
    p__subrelation(c__gainsControl,c__agent) ).

fof(miloA3576,axiom,
    p__d__subclass(c__ChangeOfControl,c__AchievingControl) ).

fof(miloA3577,axiom,
    p__d__instance(c__losesControl,c__CaseRole) ).

fof(miloA3578,axiom,
    p__subrelation(c__losesControl,c__experiencer) ).

fof(miloA3581,axiom,
    p__d__subclass(c__Capturing,c__ChangeOfControl) ).

fof(miloA3582,axiom,
    ! [CAPTURE,OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(CAPTURE,c__Capturing)
        & p__controlled(CAPTURE,OBJ) )
     => p__d__instance(OBJ,c__Agent) ) ).

fof(miloA3583,axiom,
    p__d__subclass(c__PlacingUnderArrest,c__Capturing) ).

fof(miloA3584,axiom,
    p__d__subclass(c__PlacingUnderArrest,c__LawEnforcement) ).

fof(miloA3585,axiom,
    p__d__subclass(c__PlacingUnderArrest,c__SocialInteraction) ).

fof(miloA3586,axiom,
    p__d__subclass(c__PlacingUnderArrest,c__LegalAction) ).

fof(miloA3587,axiom,
    p__d__instance(c__arrested,c__CaseRole) ).

fof(miloA3590,axiom,
    p__subrelation(c__arrested,c__controlled) ).

fof(miloA3591,axiom,
    ! [ARREST,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(ARREST,c__PlacingUnderArrest)
        & p__agent(ARREST,AGENT) )
     => p__d__instance(AGENT,c__CognitiveAgent) ) ).

fof(miloA3592,axiom,
    ! [ARREST,OBJ] :
      ( ( p__d__instance(OBJ,c__Agent)
        & p__d__instance(ARREST,c__PlacingUnderArrest)
        & p__arrested(ARREST,OBJ) )
     => ( p__d__instance(OBJ,c__Human)
        | p__d__instance(OBJ,c__GroupOfPeople) ) ) ).

fof(miloA3593,axiom,
    ! [AGENT,MEMBER,ARREST] :
      ( ( p__d__instance(MEMBER,c__SelfConnectedObject)
        & p__d__instance(MEMBER,c__Agent)
        & p__d__instance(ARREST,c__PlacingUnderArrest)
        & p__arrested(ARREST,AGENT)
        & p__d__instance(AGENT,c__GroupOfPeople)
        & p__member(MEMBER,AGENT) )
     => ? [ARREST1] :
          ( p__d__instance(ARREST1,c__PlacingUnderArrest)
          & p__arrested(ARREST1,MEMBER)
          & p__subProcess(ARREST1,ARREST) ) ) ).

fof(miloA3594,axiom,
    ! [PROC,SUB,LOC] :
      ( ( p__d__instance(LOC,c__Object)
        & p__d__instance(SUB,c__Process)
        & p__d__instance(PROC,c__Process)
        & p__eventLocated(PROC,LOC)
        & p__subProcess(SUB,PROC) )
     => p__eventLocated(SUB,LOC) ) ).

fof(miloA3595,axiom,
    ! [IMPRISON,INTERVAL,AGENT] :
      ( ( p__d__instance(IMPRISON,c__Imprisoning)
        & p__detainee(IMPRISON,AGENT)
        & p__d__instance(AGENT,c__Human)
        & p__time(IMPRISON,INTERVAL)
        & p__d__instance(INTERVAL,c__TimeInterval) )
     => ? [ARREST,TIME] :
          ( p__d__instance(TIME,c__TimeInterval)
          & p__time(ARREST,TIME)
          & p__earlier(TIME,INTERVAL)
          & p__d__instance(ARREST,c__PlacingUnderArrest)
          & p__arrested(ARREST,AGENT) ) ) ).

fof(miloA3596,axiom,
    p__d__instance(c__conveyance,c__CaseRole) ).

fof(miloA3597,axiom,
    p__subrelation(c__conveyance,c__instrument) ).

fof(miloA3600,axiom,
    ! [VEHICLE,TRANSPORT] :
      ( ( p__d__instance(TRANSPORT,c__Transportation)
        & p__instrument(TRANSPORT,VEHICLE)
        & p__d__instance(VEHICLE,c__RoadVehicle) )
     => p__d__instance(TRANSPORT,c__TransportViaRoadVehicle) ) ).

fof(miloA3601,axiom,
    ! [TRANSPORT,VEHICLE] :
      ( ( p__d__instance(VEHICLE,c__TransportationDevice)
        & p__d__instance(TRANSPORT,c__TransportViaRoadVehicle)
        & p__conveyance(TRANSPORT,VEHICLE) )
     => p__d__instance(VEHICLE,c__RoadVehicle) ) ).

fof(miloA3602,axiom,
    ! [TRANSPORT] :
      ( p__d__instance(TRANSPORT,c__TransportViaRoadVehicle)
     => ? [DRIVING] :
          ( p__d__instance(DRIVING,c__Driving)
          & p__subProcess(TRANSPORT,DRIVING) ) ) ).

fof(miloA3603,axiom,
    ! [TRANSPORT,DRIVE,VEHICLE] :
      ( ( p__d__instance(TRANSPORT,c__Transportation)
        & p__subProcess(TRANSPORT,DRIVE)
        & p__d__instance(DRIVE,c__Driving)
        & p__instrument(TRANSPORT,VEHICLE)
        & p__d__instance(VEHICLE,c__TransportationDevice) )
     => p__patient(DRIVE,VEHICLE) ) ).

fof(miloA3604,axiom,
    ! [VEHICLE,DRIVE] :
      ( ( p__d__instance(DRIVE,c__Driving)
        & p__patient(DRIVE,VEHICLE)
        & p__d__instance(VEHICLE,c__RoadVehicle) )
     => ? [TRANSPORT] :
          ( p__d__instance(TRANSPORT,c__TransportViaRoadVehicle)
          & p__subProcess(TRANSPORT,DRIVE) ) ) ).

fof(miloA3605,axiom,
    ! [DRIVING,TRANSPORT,DRIVER] :
      ( ( p__d__instance(DRIVER,c__Agent)
        & p__d__instance(DRIVING,c__Driving)
        & p__subProcess(TRANSPORT,DRIVING)
        & p__d__instance(TRANSPORT,c__Transportation)
        & p__agent(DRIVING,DRIVER) )
     => p__transported(TRANSPORT,DRIVER) ) ).

fof(miloA3606,axiom,
    ! [DRIVING,TRANSPORT,DEST] :
      ( ( p__d__instance(DRIVING,c__Driving)
        & p__subProcess(TRANSPORT,DRIVING)
        & p__d__instance(TRANSPORT,c__Transportation)
        & p__destination(DRIVING,DEST) )
     => p__destination(TRANSPORT,DEST) ) ).

fof(miloA3607,axiom,
    ! [DRIVING,TRANSPORT,VEHICLE] :
      ( ( p__d__instance(DRIVING,c__Driving)
        & p__subProcess(TRANSPORT,DRIVING)
        & p__d__instance(TRANSPORT,c__Transportation)
        & p__d__instance(VEHICLE,c__Vehicle)
        & p__patient(DRIVING,VEHICLE) )
     => p__conveyance(TRANSPORT,VEHICLE) ) ).

fof(miloA3608,axiom,
    p__d__subclass(c__GasolineEngine,c__InternalCombustionEngine) ).

fof(miloA3610,axiom,
    p__d__subclass(c__DieselEngine,c__InternalCombustionEngine) ).

fof(miloA3612,axiom,
    p__d__instance(c__typicalPart,c__BinaryPredicate) ).

fof(miloA3613,axiom,
    p__d__instance(c__typicalPart,c__SpatialRelation) ).

fof(miloA3614,axiom,
    p__relatedInternalConcept(c__typicalPart,c__part) ).

fof(miloA3617,axiom,
    ! [WHOLE,PART] :
      ( ( p__d__subclass(WHOLE,c__Object)
        & p__d__subclass(PART,c__Object)
        & p__typicalPart(PART,WHOLE) )
     => ? [X,Y] :
          ( p__d__instance(X,c__Object)
          & p__d__instance(Y,c__Object)
          & p__d__instance(X,WHOLE)
          & p__d__instance(Y,PART)
          & p__part(Y,X) ) ) ).

fof(miloA3619,axiom,
    p__d__instance(c__typicallyContainsPart,c__BinaryPredicate) ).

fof(miloA3620,axiom,
    p__d__instance(c__typicallyContainsPart,c__SpatialRelation) ).

fof(miloA3621,axiom,
    p__relatedInternalConcept(c__typicallyContainsPart,c__part) ).

fof(miloA3624,axiom,
    ! [WHOLE,PART] :
      ( ( p__d__subclass(WHOLE,c__Object)
        & p__d__subclass(PART,c__Object)
        & p__typicallyContainsPart(PART,WHOLE) )
     => ? [X,Y] :
          ( p__d__instance(X,c__Object)
          & p__d__instance(Y,c__Object)
          & p__d__instance(X,WHOLE)
          & p__d__instance(Y,PART)
          & p__part(Y,X) ) ) ).

fof(miloA3626,axiom,
    p__d__instance(c__initialPart,c__BinaryPredicate) ).

fof(miloA3627,axiom,
    p__d__instance(c__initialPart,c__SpatialRelation) ).

fof(miloA3628,axiom,
    p__relatedInternalConcept(c__initialPart,c__part) ).

fof(miloA3632,axiom,
    p__initialPart(c__AnimalAnatomicalStructure,c__Animal) ).

fof(miloA3633,axiom,
    p__d__instance(c__initiallyContainsPart,c__BinaryPredicate) ).

fof(miloA3634,axiom,
    p__d__instance(c__initiallyContainsPart,c__SpatialRelation) ).

fof(miloA3635,axiom,
    p__relatedInternalConcept(c__initiallyContainsPart,c__part) ).

fof(miloA3639,axiom,
    p__d__subclass(c__CausingHappiness,c__Process) ).

fof(miloA3641,axiom,
    p__d__subclass(c__CausingPain,c__CausingUnhappiness) ).

fof(miloA3642,axiom,
    p__d__subclass(c__CausingUnhappiness,c__Process) ).

fof(miloA3644,axiom,
    p__d__subclass(c__Lengthening,c__Increasing) ).

fof(miloA3646,axiom,
    p__d__subclass(c__Saving,c__Increasing) ).

fof(miloA3650,axiom,
    p__subrelation(c__financialAsset,c__possesses) ).

fof(miloA3651,axiom,
    ! [P,A] :
      ( ( p__d__instance(A,c__Object)
        & p__d__instance(P,c__Agent)
        & p__financialAsset(P,A) )
     => ? [V] :
          ( p__d__instance(V,c__CurrencyMeasure)
          & p__monetaryValue(A,V) ) ) ).

fof(miloA3652,axiom,
    p__d__subclass(c__Barking,c__RadiatingSound) ).

fof(miloA3653,axiom,
    ! [B] :
      ( p__d__instance(B,c__Barking)
     => ? [D] :
          ( p__d__instance(D,c__Canine)
          & p__agent(B,D) ) ) ).

fof(miloA3654,axiom,
    p__d__subclass(c__Menstruation,c__OrganOrTissueProcess) ).

fof(miloA3655,axiom,
    p__d__subclass(c__Organification,c__OrganOrTissueProcess) ).

fof(miloA3656,axiom,
    ! [P] :
      ( p__d__instance(P,c__Organification)
     => ? [O] :
          ( p__d__instance(O,c__Organ)
          & p__result(P,O) ) ) ).

fof(miloA3657,axiom,
    p__d__subclass(c__BiologicalConception,c__OrganOrTissueProcess) ).

fof(miloA3661,axiom,
    ! [SR] :
      ( p__d__instance(SR,c__SexualReproduction)
     => ? [C] :
          ( p__d__instance(C,c__BiologicalConception)
          & p__subProcess(C,SR) ) ) ).

fof(miloA3662,axiom,
    p__d__subclass(c__ContraceptiveDevice,c__Device) ).

fof(miloA3664,axiom,
    p__d__subclass(c__BirdEgg,c__Egg) ).

fof(miloA3665,axiom,
    ! [E] :
      ( p__d__instance(E,c__BirdEgg)
     => ? [SR,B] :
          ( p__d__instance(SR,c__SexualReproduction)
          & p__agent(SR,B)
          & p__d__instance(B,c__Bird)
          & p__result(SR,E) ) ) ).

fof(miloA3666,axiom,
    p__d__subclass(c__Biopsy,c__DiagnosticProcess) ).

fof(miloA3667,axiom,
    p__d__subclass(c__Biopsy,c__Removing) ).

fof(miloA3668,axiom,
    ! [B,BS] :
      ( ( p__d__instance(B,c__Biopsy)
        & p__patient(B,BS) )
     => p__d__instance(BS,c__BodySubstance) ) ).

fof(miloA3669,axiom,
    p__d__subclass(c__Mating,c__OrganismProcess) ).

fof(miloA3670,axiom,
    p__d__subclass(c__Raping,c__Mating) ).

fof(miloA3671,axiom,
    p__d__subclass(c__Raping,c__CriminalAction) ).

fof(miloA3672,axiom,
    ! [R] :
      ( p__d__instance(R,c__Raping)
     => ? [A] :
          ( p__d__instance(A,c__CognitiveAgent)
          & p__experiencer(R,A)
          & ~ p__wants(A,R) ) ) ).

fof(miloA3673,axiom,
    p__d__subclass(c__LayingEggs,c__OrganismProcess) ).

fof(miloA3675,axiom,
    ! [L,A] :
      ( ( p__d__instance(A,c__Agent)
        & p__d__instance(L,c__LayingEggs)
        & p__experiencer(L,A) )
     => ( p__d__instance(A,c__Animal)
        & p__attribute(A,c__Female) ) ) ).

fof(miloA3676,axiom,
    p__d__instance(c__affiliatedOrganization,c__BinaryPredicate) ).

fof(miloA3679,axiom,
    p__d__instance(c__ideologicalAffiliationOfOrganization,c__BinaryPredicate) ).

fof(miloA3682,axiom,
    p__d__instance(c__religiousAffiliationOfOrganization,c__BinaryPredicate) ).

fof(miloA3685,axiom,
    p__d__instance(c__allegiance,c__BinaryPredicate) ).

fof(miloA3688,axiom,
    p__d__instance(c__ancestorOrganization,c__BinaryPredicate) ).

fof(miloA3689,axiom,
    p__d__instance(c__ancestorOrganization,c__TransitiveRelation) ).

fof(miloA3690,axiom,
    p__d__instance(c__ancestorOrganization,c__IrreflexiveRelation) ).

fof(miloA3693,axiom,
    p__disjointRelation(c__ancestorOrganization,c__subOrganization) ).

fof(miloA3694,axiom,
    p__d__instance(c__anniversary,c__BinaryPredicate) ).

fof(miloA3695,axiom,
    p__d__instance(c__anniversary,c__TemporalRelation) ).

fof(miloA3700,axiom,
    p__subrelation(c__birthday,c__anniversary) ).

fof(miloA3701,axiom,
    p__d__instance(c__birthplace,c__BinaryPredicate) ).

fof(miloA3704,axiom,
    ! [INDIV,PLACE] :
      ( ( p__d__instance(PLACE,c__Object)
        & p__d__instance(INDIV,c__Animal)
        & p__birthplace(INDIV,PLACE) )
     => ? [BIRTH] :
          ( p__d__instance(BIRTH,c__Birth)
          & p__experiencer(BIRTH,INDIV)
          & p__eventLocated(BIRTH,PLACE) ) ) ).

fof(miloA3705,axiom,
    p__d__instance(c__birthdate,c__BinaryPredicate) ).

fof(miloA3708,axiom,
    ! [P,D] :
      ( ( p__d__instance(D,c__Day)
        & p__d__instance(P,c__Human)
        & p__birthdate(P,D) )
     => ? [B] :
          ( p__d__instance(B,c__Birth)
          & p__experiencer(B,P)
          & p__date(B,D) ) ) ).

fof(miloA3711,axiom,
    p__d__instance(c__deathdate,c__BinaryPredicate) ).

fof(miloA3712,axiom,
    ! [P,T] :
      ( ( p__d__instance(T,c__Day)
        & p__d__instance(P,c__Human)
        & p__deathdate(P,T) )
     => ? [D] :
          ( p__d__instance(D,c__Death)
          & p__experiencer(D,P)
          & p__date(D,T) ) ) ).

fof(miloA3713,axiom,
    p__d__instance(c__deathplace,c__BinaryPredicate) ).

fof(miloA3716,axiom,
    ! [P,L] :
      ( ( p__d__instance(L,c__Object)
        & p__d__instance(P,c__Animal)
        & p__deathplace(P,L) )
     => ? [D] :
          ( p__d__instance(D,c__Death)
          & p__experiencer(D,P)
          & p__eventLocated(D,L) ) ) ).

fof(miloA3717,axiom,
    p__d__instance(c__equipmentCount,c__TernaryPredicate) ).

fof(miloA3721,axiom,
    p__d__instance(c__equipmentType,c__BinaryPredicate) ).

fof(miloA3724,axiom,
    ! [T,O] :
      ( ( p__d__instance(T,c__Device)
        & p__d__instance(O,c__Artifact)
        & p__equipmentType(O,T) )
     => ? [D] :
          ( p__d__instance(D,c__Object)
          & p__d__instance(D,T)
          & ( p__part(D,O)
            | p__connected(D,O) ) ) ) ).

fof(miloA3725,axiom,
    p__d__instance(c__grammaticalRelation,c__BinaryPredicate) ).

fof(miloA3728,axiom,
    p__d__instance(c__distanceOnPath,c__BinaryPredicate) ).

fof(miloA3731,axiom,
    p__d__instance(c__inString,c__BinaryPredicate) ).

fof(miloA3734,axiom,
    p__subrelation(c__inString,c__part) ).

fof(miloA3735,axiom,
    ! [CHAR,STRING] :
      ( ( p__d__instance(STRING,c__SymbolicString)
        & p__part(CHAR,STRING)
        & p__d__instance(CHAR,c__Character) )
     => p__inString(CHAR,STRING) ) ).

fof(miloA3736,axiom,
    p__d__instance(c__subString,c__AntisymmetricRelation) ).

fof(miloA3737,axiom,
    p__d__instance(c__subString,c__ReflexiveRelation) ).

fof(miloA3738,axiom,
    p__d__instance(c__subString,c__BinaryPredicate) ).

fof(miloA3741,axiom,
    p__subrelation(c__subString,c__part) ).

fof(miloA3742,axiom,
    ! [S1,S2,L1,L2] :
      ( ( p__d__instance(S2,c__SymbolicString)
        & p__d__instance(S1,c__SymbolicString)
        & p__d__instance(L1,c__NonnegativeInteger)
        & p__d__instance(L2,c__NonnegativeInteger)
        & p__subString(S1,S2)
        & L1 = f__StringLengthFn1(S1)
        & L2 = f__StringLengthFn1(S2) )
     => p__lessThanOrEqualTo(L1,L2) ) ).

fof(miloA3743,axiom,
    ! [S1,CH,S2] :
      ( ( p__d__instance(S2,c__SymbolicString)
        & p__d__instance(S1,c__SymbolicString)
        & p__d__instance(CH,c__Character)
        & p__subString(S1,S2)
        & p__inString(CH,S1) )
     => p__inString(CH,S2) ) ).

fof(miloA3744,axiom,
    p__d__instance(c__SubstringFn,c__TernaryFunction) ).

fof(miloA3745,axiom,
    p__d__instance(c__SubstringFn,c__PartialValuedRelation) ).

fof(miloA3746,axiom,
    p__d__instance(c__SubstringFn,c__SingleValuedRelation) ).

fof(miloA3751,axiom,
    p__d__instance(c__StringLengthFn,c__UnaryFunction) ).

fof(miloA3752,axiom,
    p__d__instance(c__StringLengthFn,c__TotalValuedRelation) ).

fof(miloA3753,axiom,
    p__d__instance(c__StringLengthFn,c__SingleValuedRelation) ).

fof(miloA3756,axiom,
    p__d__instance(c__stringLength,c__BinaryPredicate) ).

fof(miloA3757,axiom,
    p__d__instance(c__stringLength,c__TotalValuedRelation) ).

fof(miloA3758,axiom,
    p__d__instance(c__stringLength,c__SingleValuedRelation) ).

fof(miloA3759,axiom,
    p__d__instance(c__stringLength,c__AsymmetricRelation) ).

fof(miloA3762,axiom,
    ! [INT,STRING] :
      ( ( p__d__instance(STRING,c__SymbolicString)
        & p__d__instance(INT,c__NonnegativeInteger) )
     => ( p__stringLength(INT,STRING)
      <=> INT = f__StringLengthFn1(STRING) ) ) ).

fof(miloA3763,axiom,
    p__d__instance(c__StringConcatenateFn,c__BinaryFunction) ).

fof(miloA3764,axiom,
    p__d__instance(c__StringConcatenateFn,c__TotalValuedRelation) ).

fof(miloA3765,axiom,
    p__d__instance(c__StringConcatenateFn,c__SingleValuedRelation) ).

fof(miloA3769,axiom,
    p__d__instance(c__stringConcatenation,c__TernaryPredicate) ).

fof(miloA3770,axiom,
    p__d__instance(c__stringConcatenation,c__TotalValuedRelation) ).

fof(miloA3771,axiom,
    p__d__instance(c__stringConcatenation,c__SingleValuedRelation) ).

fof(miloA3775,axiom,
    ! [S3,S1,S2] :
      ( ( p__d__instance(S3,c__SymbolicString)
        & p__d__instance(S1,c__SymbolicString)
        & p__d__instance(S2,c__SymbolicString) )
     => ( p__stringConcatenation(S1,S1,S3)
      <=> S3 = f__StringConcatenateFn2(S1,S2) ) ) ).

fof(miloA3776,axiom,
    p__d__instance(c__precedesInString,c__TernaryPredicate) ).

fof(miloA3780,axiom,
    p__subrelation(c__stringConcatenation,c__precedesInString) ).

fof(miloA3781,axiom,
    ! [S1,S2,S3] :
      ( ( p__d__instance(S3,c__SymbolicString)
        & p__d__instance(S2,c__SymbolicString)
        & p__d__instance(S1,c__SymbolicString)
        & p__precedesInString(S1,S2,S3) )
     => ( p__subString(S1,S3)
        & p__subString(S2,S3) ) ) ).

fof(miloA3782,axiom,
    ! [S2,S1,S3,S4] :
      ( ( p__d__instance(S4,c__SymbolicString)
        & p__d__instance(S2,c__SymbolicString)
        & p__d__instance(S1,c__SymbolicString)
        & p__d__instance(S3,c__SymbolicString)
        & p__precedesInString(S1,S2,S4)
        & p__precedesInString(S2,S3,S4) )
     => p__precedesInString(S1,S3,S4) ) ).

fof(miloA3783,axiom,
    p__d__subclass(c__Descriptor,c__ContentBearingObject) ).

fof(miloA3784,axiom,
    p__d__subclass(c__Name,c__Descriptor) ).

fof(miloA3785,axiom,
    p__d__subclass(c__Identifier,c__Name) ).

fof(miloA3786,axiom,
    p__d__subclass(c__PlaceDescriptor,c__Descriptor) ).

fof(miloA3787,axiom,
    p__d__subclass(c__DescriptorPart,c__ContentBearingObject) ).

fof(miloA3788,axiom,
    p__d__subclass(c__NamePart,c__DescriptorPart) ).

fof(miloA3789,axiom,
    p__d__subclass(c__IdentifierPart,c__NamePart) ).

fof(miloA3790,axiom,
    p__d__subclass(c__PlaceID,c__PlaceDescriptor) ).

fof(miloA3791,axiom,
    p__d__subclass(c__LocalizablePlaceID,c__PlaceID) ).

fof(miloA3792,axiom,
    p__d__subclass(c__PlaceAddress,c__PlaceID) ).

fof(miloA3793,axiom,
    p__d__subclass(c__ContactSite,c__Object) ).

fof(miloA3794,axiom,
    p__d__subclass(c__TelephonyDevice,c__ContactSite) ).

fof(miloA3795,axiom,
    p__d__subclass(c__TelephonyDevice,c__CommunicationDevice) ).

fof(miloA3796,axiom,
    p__d__subclass(c__TelephonyDevice,c__ElectricDevice) ).

fof(miloA3797,axiom,
    p__d__subclass(c__Telephone,c__TelephonyDevice) ).

fof(miloA3798,axiom,
    p__d__instance(c__canonicalPlaceName,c__TernaryPredicate) ).

fof(miloA3802,axiom,
    ! [LANG,STR,PLACE] :
      ( ( p__d__instance(STR,c__SymbolicString)
        & p__d__instance(LANG,c__Language)
        & p__d__instance(PLACE,c__Region)
        & p__canonicalPlaceName(PLACE,LANG,STR) )
     => p__names(STR,PLACE) ) ).

fof(miloA3803,axiom,
    p__d__subclass(c__PostalPlace,c__StationaryArtifact) ).

fof(miloA3804,axiom,
    p__d__subclass(c__PostalPlace,c__LocalizablePlace) ).

fof(miloA3805,axiom,
    p__d__subclass(c__PostalPlace,c__ContactSite) ).

fof(miloA3806,axiom,
    p__d__subclass(c__MilitaryInstallation,c__PostalPlace) ).

fof(miloA3807,axiom,
    p__d__subclass(c__Residence,c__PostalPlace) ).

fof(miloA3808,axiom,
    p__d__subclass(c__PlaceOfCommerce,c__PostalPlace) ).

fof(miloA3809,axiom,
    p__d__instance(c__siteForContact,c__AsymmetricRelation) ).

fof(miloA3810,axiom,
    p__d__instance(c__siteForContact,c__BinaryPredicate) ).

fof(miloA3813,axiom,
    p__d__instance(c__postContactSite,c__AsymmetricRelation) ).

fof(miloA3814,axiom,
    p__d__instance(c__postContactSite,c__BinaryPredicate) ).

fof(miloA3817,axiom,
    p__subrelation(c__postContactSite,c__siteForContact) ).

fof(miloA3818,axiom,
    p__d__instance(c__unitNumber,c__BinaryPredicate) ).

fof(miloA3821,axiom,
    p__d__instance(c__floorCode,c__BinaryPredicate) ).

fof(miloA3824,axiom,
    ! [PLACE,UNITSTR,FLRCODE] :
      ( ( p__d__instance(PLACE,c__PostalPlace)
        & p__d__instance(UNITSTR,c__SymbolicString)
        & p__d__instance(FLRCODE,c__SymbolicString)
        & p__unitNumber(UNITSTR,PLACE)
        & p__floorCode(FLRCODE,PLACE) )
     => ? [UNIT,FLOOR] :
          ( p__d__instance(FLOOR,c__BuildingLevel)
          & p__d__instance(UNIT,c__Room)
          & p__located(UNIT,FLOOR)
          & p__part(FLOOR,PLACE)
          & p__names(UNITSTR,UNIT)
          & p__names(FLRCODE,FLOOR) ) ) ).

fof(miloA3825,axiom,
    ! [PLACE,UNITSTR,BLDG] :
      ( ( p__d__instance(PLACE,c__PostalPlace)
        & p__d__instance(UNITSTR,c__SymbolicString)
        & p__d__instance(BLDG,c__Object)
        & p__unitNumber(UNITSTR,PLACE)
        & ! [FLR] :
            ( ~ p__d__instance(FLR,c__SymbolicString)
            | ~ p__floorCode(FLR,PLACE) ) )
     => ? [UNIT] :
          ( p__d__instance(UNIT,c__Room)
          & p__names(UNITSTR,UNIT)
          & p__located(UNIT,BLDG) ) ) ).

fof(miloA3826,axiom,
    p__d__subclass(c__Neighborhood,c__GeographicArea) ).

fof(miloA3827,axiom,
    ! [PLACE] :
      ( p__d__instance(PLACE,c__Neighborhood)
     => ? [AREA] :
          ( p__d__instance(AREA,c__GeographicArea)
          & p__geographicSubregion(PLACE,AREA) ) ) ).

fof(miloA3828,axiom,
    p__d__instance(c__postNeighborhood,c__BinaryPredicate) ).

fof(miloA3829,axiom,
    p__d__instance(c__postNeighborhood,c__AsymmetricRelation) ).

fof(miloA3830,axiom,
    p__subrelation(c__postNeighborhood,c__located) ).

fof(miloA3833,axiom,
    ! [PLACE,GEO] :
      ( ( p__d__instance(GEO,c__Neighborhood)
        & p__d__instance(PLACE,c__PostalPlace) )
     => ( ( p__located(PLACE,GEO)
          & p__d__instance(PLACE,c__PostalPlace)
          & p__d__instance(GEO,c__Neighborhood) )
      <=> p__postNeighborhood(PLACE,GEO) ) ) ).

fof(miloA3834,axiom,
    ! [NEIGHBORHOOD,PLACE,CITY] :
      ( ( p__d__instance(NEIGHBORHOOD,c__Neighborhood)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__postNeighborhood(PLACE,NEIGHBORHOOD)
        & p__geographicSubregion(NEIGHBORHOOD,CITY)
        & p__d__instance(CITY,c__City) )
     => p__postCity(PLACE,CITY) ) ).

fof(miloA3835,axiom,
    ! [NEIGHBORHOOD,PLACE,STATE] :
      ( ( p__d__instance(NEIGHBORHOOD,c__Neighborhood)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__postNeighborhood(PLACE,NEIGHBORHOOD)
        & p__geographicSubregion(NEIGHBORHOOD,STATE)
        & p__d__instance(STATE,c__StateOrProvince) )
     => p__postDistrict(PLACE,STATE) ) ).

fof(miloA3836,axiom,
    p__d__instance(c__postCountry,c__AsymmetricRelation) ).

fof(miloA3837,axiom,
    p__d__instance(c__postCountry,c__BinaryPredicate) ).

fof(miloA3840,axiom,
    p__subrelation(c__postCountry,c__located) ).

fof(miloA3841,axiom,
    ! [PLACE,COUNTRY] :
      ( ( p__d__instance(COUNTRY,c__GeopoliticalArea)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__postCountry(PLACE,COUNTRY) )
     => ( p__d__instance(COUNTRY,c__Nation)
        | p__d__instance(COUNTRY,c__DependencyOrSpecialSovereigntyArea) ) ) ).

fof(miloA3842,axiom,
    ! [PLACE,GEO] :
      ( ( p__d__instance(GEO,c__GeopoliticalArea)
        & p__d__instance(PLACE,c__PostalPlace) )
     => ( ( p__located(PLACE,GEO)
          & p__d__instance(PLACE,c__PostalPlace)
          & ( p__d__instance(GEO,c__Nation)
            | p__d__instance(GEO,c__DependencyOrSpecialSovereigntyArea) ) )
      <=> p__postCountry(PLACE,GEO) ) ) ).

fof(miloA3843,axiom,
    ! [CITY,PLACE,AREA] :
      ( ( p__d__instance(CITY,c__City)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__postCity(PLACE,CITY)
        & p__geographicSubregion(CITY,AREA)
        & p__d__instance(AREA,c__StateOrProvince) )
     => p__postDistrict(PLACE,AREA) ) ).

fof(miloA3844,axiom,
    ! [CITY,PLACE,AREA] :
      ( ( p__d__instance(CITY,c__City)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__d__instance(AREA,c__GeopoliticalArea)
        & p__postCity(PLACE,CITY)
        & p__geographicSubregion(CITY,AREA)
        & ( p__d__instance(AREA,c__Nation)
          | p__d__instance(AREA,c__DependencyOrSpecialSovereigntyArea) ) )
     => p__postCountry(PLACE,AREA) ) ).

fof(miloA3845,axiom,
    p__d__instance(c__postDistrict,c__AsymmetricRelation) ).

fof(miloA3846,axiom,
    p__d__instance(c__postDistrict,c__BinaryPredicate) ).

fof(miloA3849,axiom,
    p__subrelation(c__postDistrict,c__located) ).

fof(miloA3850,axiom,
    ! [PLACE,GEO] :
      ( ( p__d__instance(GEO,c__StateOrProvince)
        & p__d__instance(PLACE,c__PostalPlace) )
     => ( ( p__located(PLACE,GEO)
          & p__d__instance(PLACE,c__PostalPlace)
          & p__d__instance(GEO,c__StateOrProvince) )
      <=> p__postDistrict(PLACE,GEO) ) ) ).

fof(miloA3851,axiom,
    p__d__instance(c__postCity,c__AsymmetricRelation) ).

fof(miloA3852,axiom,
    p__d__instance(c__postCity,c__BinaryPredicate) ).

fof(miloA3855,axiom,
    p__subrelation(c__postCity,c__located) ).

fof(miloA3856,axiom,
    ! [PLACE,GEO] :
      ( ( p__d__instance(GEO,c__City)
        & p__d__instance(PLACE,c__PostalPlace) )
     => ( ( p__located(PLACE,GEO)
          & p__d__instance(PLACE,c__PostalPlace)
          & p__d__instance(GEO,c__City) )
      <=> p__postCity(PLACE,GEO) ) ) ).

fof(miloA3857,axiom,
    p__d__subclass(c__PostcodeArea,c__LocalizablePlace) ).

fof(miloA3858,axiom,
    ! [AREA] :
      ( p__d__instance(AREA,c__PostcodeArea)
     => ? [GEO] :
          ( p__d__instance(GEO,c__GeographicArea)
          & p__geographicSubregion(AREA,GEO) ) ) ).

fof(miloA3859,axiom,
    p__d__instance(c__postPostcodeArea,c__AsymmetricRelation) ).

fof(miloA3860,axiom,
    p__d__instance(c__postPostcodeArea,c__BinaryPredicate) ).

fof(miloA3863,axiom,
    p__subrelation(c__postPostcodeArea,c__located) ).

fof(miloA3864,axiom,
    ! [PLACE,AREA] :
      ( ( p__d__instance(AREA,c__PostcodeArea)
        & p__d__instance(PLACE,c__PostalPlace) )
     => ( ( p__located(PLACE,AREA)
          & p__d__instance(PLACE,c__PostalPlace)
          & p__d__instance(AREA,c__PostcodeArea) )
      <=> p__postPostcodeArea(PLACE,AREA) ) ) ).

fof(miloA3865,axiom,
    ! [AREA,PLACE,CITY] :
      ( ( p__d__instance(AREA,c__PostcodeArea)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__postPostcodeArea(PLACE,AREA)
        & p__geographicSubregion(AREA,CITY)
        & p__d__instance(CITY,c__City) )
     => p__postCity(PLACE,CITY) ) ).

fof(miloA3866,axiom,
    ! [AREA,PLACE,GEO] :
      ( ( p__d__instance(AREA,c__PostcodeArea)
        & p__d__instance(PLACE,c__PostalPlace)
        & p__postPostcodeArea(PLACE,AREA)
        & p__geographicSubregion(AREA,GEO)
        & p__d__instance(GEO,c__StateOrProvince) )
     => p__postDistrict(PLACE,GEO) ) ).

fof(miloA3867,axiom,
    p__d__instance(c__postStreet,c__AsymmetricRelation) ).

fof(miloA3868,axiom,
    p__d__instance(c__postStreet,c__BinaryPredicate) ).

fof(miloA3871,axiom,
    ! [POSTPLACE,ROADWAY] :
      ( ( p__d__instance(ROADWAY,c__Roadway)
        & p__d__instance(POSTPLACE,c__PostalPlace)
        & p__postStreet(POSTPLACE,ROADWAY) )
     => p__orientation(POSTPLACE,ROADWAY,c__Adjacent) ) ).

fof(miloA3872,axiom,
    p__d__instance(c__postStreetNumber,c__AsymmetricRelation) ).

fof(miloA3873,axiom,
    p__d__instance(c__postStreetNumber,c__BinaryPredicate) ).

fof(miloA3876,axiom,
    p__d__instance(c__postPostOfficeBox,c__AsymmetricRelation) ).

fof(miloA3877,axiom,
    p__d__instance(c__postPostOfficeBox,c__BinaryPredicate) ).

fof(miloA3880,axiom,
    p__d__subclass(c__PostalAddressText,c__PlaceAddress) ).

fof(miloA3881,axiom,
    p__d__subclass(c__PostalAddressText,c__LocalizablePlaceID) ).

fof(miloA3882,axiom,
    p__d__subclass(c__PostalAddressText,c__SymbolicString) ).

fof(miloA3883,axiom,
    p__d__subclass(c__PostalAddressText,c__LinguisticExpression) ).

fof(miloA3884,axiom,
    p__d__instance(c__postAddressText,c__AsymmetricRelation) ).

fof(miloA3885,axiom,
    p__d__instance(c__postAddressText,c__BinaryPredicate) ).

fof(miloA3888,axiom,
    p__d__instance(c__telecomContactDevice,c__AsymmetricRelation) ).

fof(miloA3889,axiom,
    p__d__instance(c__telecomContactDevice,c__BinaryPredicate) ).

fof(miloA3892,axiom,
    p__subrelation(c__telecomContactDevice,c__siteForContact) ).

fof(miloA3893,axiom,
    p__d__subclass(c__VirtualPlaceID,c__PlaceID) ).

fof(miloA3894,axiom,
    p__d__subclass(c__VirtualAddress,c__PlaceAddress) ).

fof(miloA3895,axiom,
    p__d__subclass(c__VirtualAddress,c__VirtualPlaceID) ).

fof(miloA3896,axiom,
    p__d__subclass(c__TelecomNumber,c__VirtualAddress) ).

fof(miloA3897,axiom,
    p__d__subclass(c__TelecomNumber,c__SymbolicString) ).

fof(miloA3898,axiom,
    p__d__subclass(c__TelecomNumber,c__ContactSite) ).

fof(miloA3899,axiom,
    p__d__instance(c__deviceTelecomNumber,c__BinaryPredicate) ).

fof(miloA3900,axiom,
    p__d__instance(c__deviceTelecomNumber,c__AsymmetricRelation) ).

fof(miloA3903,axiom,
    p__d__instance(c__telecomCoreNumber,c__BinaryPredicate) ).

fof(miloA3904,axiom,
    p__d__instance(c__telecomCoreNumber,c__AsymmetricRelation) ).

fof(miloA3907,axiom,
    p__subrelation(c__telecomCoreNumber,c__subString) ).

fof(miloA3908,axiom,
    p__d__instance(c__telecomCountryCode,c__BinaryPredicate) ).

fof(miloA3909,axiom,
    p__d__instance(c__telecomCountryCode,c__AsymmetricRelation) ).

fof(miloA3912,axiom,
    p__subrelation(c__telecomCountryCode,c__subString) ).

fof(miloA3913,axiom,
    p__d__instance(c__telecomAreaCode,c__BinaryPredicate) ).

fof(miloA3914,axiom,
    p__d__instance(c__telecomAreaCode,c__AsymmetricRelation) ).

fof(miloA3917,axiom,
    p__subrelation(c__telecomAreaCode,c__subString) ).

fof(miloA3918,axiom,
    p__d__instance(c__telecomCode2,c__BinaryPredicate) ).

fof(miloA3919,axiom,
    p__d__instance(c__telecomCode2,c__AsymmetricRelation) ).

fof(miloA3922,axiom,
    p__subrelation(c__telecomCode2,c__subString) ).

fof(miloA3923,axiom,
    p__d__instance(c__telecomExtension,c__BinaryPredicate) ).

fof(miloA3924,axiom,
    p__d__instance(c__telecomExtension,c__AsymmetricRelation) ).

fof(miloA3927,axiom,
    ! [AC,CN,WHOLE] :
      ( ( p__d__instance(WHOLE,c__TelecomNumber)
        & p__d__instance(CN,c__SymbolicString)
        & p__d__instance(AC,c__SymbolicString)
        & p__telecomCoreNumber(CN,WHOLE)
        & p__telecomAreaCode(AC,WHOLE) )
     => p__precedesInString(AC,CN,WHOLE) ) ).

fof(miloA3928,axiom,
    ! [CC,CN,WHOLE] :
      ( ( p__d__instance(WHOLE,c__TelecomNumber)
        & p__d__instance(CN,c__SymbolicString)
        & p__d__instance(CC,c__SymbolicString)
        & p__telecomCoreNumber(CN,WHOLE)
        & p__telecomCountryCode(CC,WHOLE) )
     => p__precedesInString(CC,CN,WHOLE) ) ).

fof(miloA3929,axiom,
    ! [CC,AC,WHOLE] :
      ( ( p__d__instance(WHOLE,c__TelecomNumber)
        & p__d__instance(AC,c__SymbolicString)
        & p__d__instance(CC,c__SymbolicString)
        & p__telecomAreaCode(AC,WHOLE)
        & p__telecomCountryCode(CC,WHOLE) )
     => p__precedesInString(CC,AC,WHOLE) ) ).

fof(miloA3930,axiom,
    ! [CN,EX,WHOLE] :
      ( ( p__d__instance(WHOLE,c__TelecomNumber)
        & p__d__instance(CN,c__SymbolicString)
        & p__d__instance(EX,c__SymbolicString)
        & p__telecomCoreNumber(CN,WHOLE)
        & p__telecomExtension(EX,WHOLE) )
     => p__precedesInString(CN,EX,WHOLE) ) ).

fof(miloA3931,axiom,
    ! [AC,C2,WHOLE] :
      ( ( p__d__instance(WHOLE,c__TelecomNumber)
        & p__d__instance(C2,c__SymbolicString)
        & p__d__instance(AC,c__SymbolicString)
        & p__telecomCode2(C2,WHOLE)
        & p__telecomAreaCode(AC,WHOLE) )
     => p__precedesInString(AC,C2,WHOLE) ) ).

fof(miloA3932,axiom,
    ! [CC,C2,WHOLE] :
      ( ( p__d__instance(WHOLE,c__TelecomNumber)
        & p__d__instance(C2,c__SymbolicString)
        & p__d__instance(CC,c__SymbolicString)
        & p__telecomCode2(C2,WHOLE)
        & p__telecomCountryCode(CC,WHOLE) )
     => p__precedesInString(CC,C2,WHOLE) ) ).

fof(miloA3933,axiom,
    p__d__instance(c__telephoneNumber,c__BinaryPredicate) ).

fof(miloA3934,axiom,
    p__d__instance(c__telephoneNumber,c__AsymmetricRelation) ).

fof(miloA3937,axiom,
    ! [NUMBER,AGENT] :
      ( ( p__d__instance(AGENT,c__Agent)
        & p__d__instance(NUMBER,c__TelecomNumber)
        & p__telephoneNumber(NUMBER,AGENT) )
     => p__siteForContact(NUMBER,AGENT) ) ).

fof(miloA3938,axiom,
    p__d__instance(c__personalPhoneNumber,c__BinaryPredicate) ).

fof(miloA3939,axiom,
    p__d__instance(c__personalPhoneNumber,c__AsymmetricRelation) ).

fof(miloA3942,axiom,
    p__subrelation(c__personalPhoneNumber,c__telephoneNumber) ).

fof(miloA3944,axiom,
    p__d__instance(c__homePhoneNumber,c__BinaryPredicate) ).

fof(miloA3945,axiom,
    p__d__instance(c__homePhoneNumber,c__AsymmetricRelation) ).

fof(miloA3948,axiom,
    p__subrelation(c__homePhoneNumber,c__telephoneNumber) ).

fof(miloA3951,axiom,
    p__d__instance(c__workPhoneNumber,c__BinaryPredicate) ).

fof(miloA3952,axiom,
    p__d__instance(c__workPhoneNumber,c__AsymmetricRelation) ).

fof(miloA3955,axiom,
    p__subrelation(c__workPhoneNumber,c__telephoneNumber) ).

fof(miloA3956,axiom,
    p__d__subclass(c__FixedPhone,c__Telephone) ).

fof(miloA3957,axiom,
    p__d__subclass(c__MobileCellPhone,c__ReceiverDevice) ).

fof(miloA3958,axiom,
    p__d__subclass(c__MobileCellPhone,c__Telephone) ).

fof(miloA3959,axiom,
    p__d__instance(c__mobilePhoneNumber,c__BinaryPredicate) ).

fof(miloA3960,axiom,
    p__d__instance(c__mobilePhoneNumber,c__AsymmetricRelation) ).

fof(miloA3963,axiom,
    p__subrelation(c__mobilePhoneNumber,c__telephoneNumber) ).

fof(miloA3967,axiom,
    p__d__instance(c__faxNumber,c__BinaryPredicate) ).

fof(miloA3968,axiom,
    p__d__instance(c__faxNumber,c__AsymmetricRelation) ).

fof(miloA3973,axiom,
    p__d__subclass(c__FabricIron,c__Device) ).

fof(miloA3974,axiom,
    ! [IRON] :
      ( ( p__d__instance(IRON,c__SelfConnectedObject)
        & p__d__instance(IRON,c__FabricIron) )
     => ? [BASE] :
          ( p__d__instance(BASE,c__CorpuscularObject)
          & p__bottom(BASE,IRON)
          & p__material(c__Metal,BASE)
          & p__attribute(BASE,c__Flat) ) ) ).

fof(miloA3975,axiom,
    p__d__subclass(c__IroningBoard,c__Device) ).

fof(miloA3977,axiom,
    p__d__subclass(c__Smoothing,c__SurfaceChange) ).

fof(miloA3979,axiom,
    p__d__subclass(c__Ironing,c__Smoothing) ).

fof(miloA3980,axiom,
    ! [OBJ,I] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(I,c__Ironing)
        & p__patient(I,OBJ) )
     => ? [HEAT,IRON,PART] :
          ( p__d__instance(PART,c__Object)
          & p__d__instance(IRON,c__Physical)
          & p__superficialPart(PART,OBJ)
          & p__d__instance(HEAT,c__Heating)
          & p__patient(HEAT,IRON)
          & p__patient(I,PART)
          & p__instrument(I,IRON) ) ) ).

fof(miloA3981,axiom,
    ! [OBJ,FABRIC,I] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__d__instance(I,c__Ironing)
        & p__patient(I,OBJ)
        & p__part(FABRIC,OBJ)
        & p__d__instance(FABRIC,c__Fabric) )
     => ? [IRON,HEAT] :
          ( p__d__instance(HEAT,c__Heating)
          & p__patient(HEAT,IRON)
          & p__d__instance(IRON,c__FabricIron)
          & p__instrument(I,IRON) ) ) ).

fof(miloA3982,axiom,
    p__d__subclass(c__WhirlpoolTub,c__FluidContainer) ).

fof(miloA3984,axiom,
    p__d__subclass(c__HotTub,c__WhirlpoolTub) ).

fof(miloA3986,axiom,
    p__d__subclass(c__SizeAttribute,c__RelationalAttribute) ).

fof(miloA3987,axiom,
    ! [ATTR,X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,ATTR)
        & p__d__instance(ATTR,c__SizeAttribute) )
     => p__d__instance(X,c__Object) ) ).

fof(miloA3988,axiom,
    p__d__instance(c__DoubleSize,c__SizeAttribute) ).

fof(miloA3990,axiom,
    p__d__subclass(c__Kennel,c__TrapOrCage) ).

fof(miloA3992,axiom,
    p__d__subclass(c__DryingDevice,c__Device) ).

fof(miloA3994,axiom,
    p__d__subclass(c__ClothesDryer,c__DryingDevice) ).

fof(miloA3995,axiom,
    p__d__subclass(c__ClothesWashingMachine,c__WashingDevice) ).

fof(miloA3996,axiom,
    p__d__subclass(c__HairDryer,c__DryingDevice) ).

fof(miloA3997,axiom,
    p__d__subclass(c__HairDryer,c__ElectricDevice) ).

fof(miloA3999,axiom,
    p__d__subclass(c__SelfServiceLaundry,c__Room) ).

fof(miloA4001,axiom,
    ! [ROOM] :
      ( p__d__instance(ROOM,c__SelfServiceLaundry)
     => p__attribute(ROOM,c__CommunalAttribute) ) ).

fof(miloA4002,axiom,
    p__d__subclass(c__Microwave,c__ElectricDevice) ).

fof(miloA4004,axiom,
    ! [M] :
      ( ( p__d__instance(M,c__Microwave)
        & p__attribute(M,c__DeviceOn) )
     => ? [PROC] :
          ( p__d__instance(PROC,c__RadiatingElectromagnetic)
          & p__instrument(PROC,M) ) ) ).

fof(miloA4005,axiom,
    p__d__subclass(c__SmokeDetector,c__Device) ).

fof(miloA4007,axiom,
    p__d__subclass(c__Sprinkler,c__Device) ).

fof(miloA4008,axiom,
    p__d__subclass(c__WaterSprinkler,c__Sprinkler) ).

fof(miloA4010,axiom,
    p__d__subclass(c__FireSprinklerSystem,c__Collection) ).

fof(miloA4011,axiom,
    ! [X] :
      ( p__d__instance(X,c__FireSprinklerSystem)
     => ? [DETECT,SPRINKLER] :
          ( p__d__instance(DETECT,c__SelfConnectedObject)
          & p__d__instance(SPRINKLER,c__SelfConnectedObject)
          & p__d__instance(DETECT,c__SmokeDetector)
          & p__d__instance(SPRINKLER,c__WaterSprinkler)
          & p__member(DETECT,X)
          & p__member(SPRINKLER,X) ) ) ).

fof(miloA4012,axiom,
    ! [X] :
      ( p__d__instance(X,c__FireSprinklerSystem)
     => ? [FIRE,DISCOVER,WM] :
          ( p__d__instance(DISCOVER,c__Discovering)
          & p__d__instance(FIRE,c__Fire)
          & p__instrument(DISCOVER,X)
          & p__patient(DISCOVER,FIRE)
          & p__d__instance(WM,c__WaterMotion)
          & p__origin(WM,X)
          & p__causes(DISCOVER,WM) ) ) ).

fof(miloA4013,axiom,
    p__d__subclass(c__FireExtinguisher,c__Device) ).

fof(miloA4015,axiom,
    ! [FE] :
      ( p__d__instance(FE,c__FireExtinguisher)
     => ? [PERSON,CARRYING,CARRY] :
          ( p__d__instance(CARRY,c__Process)
          & p__d__instance(PERSON,c__Human)
          & p__d__subclass(CARRYING,c__Carrying)
          & p__d__instance(CARRY,CARRYING)
          & p__patient(CARRY,FE)
          & p__capability(CARRYING,c__instrument,PERSON) ) ) ).

fof(miloA4016,axiom,
    p__d__subclass(c__IceMachine,c__Machine) ).

fof(miloA4018,axiom,
    p__d__subclass(c__AlarmClock,c__Clock) ).

fof(miloA4020,axiom,
    p__d__subclass(c__AMFMAlarmClock,c__AlarmClock) ).

fof(miloA4021,axiom,
    p__d__subclass(c__AMFMAlarmClock,c__RadioReceiver) ).

fof(miloA4022,axiom,
    p__d__subclass(c__ElectricCoffeeMaker,c__ElectricDevice) ).

fof(miloA4024,axiom,
    p__d__instance(c__Clean,c__SubjectiveAssessmentAttribute) ).

fof(miloA4025,axiom,
    p__d__instance(c__Dirty,c__SubjectiveAssessmentAttribute) ).

fof(miloA4026,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Clean) )
     => p__d__instance(X,c__Object) ) ).

fof(miloA4027,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Dirty) )
     => p__d__instance(X,c__Object) ) ).

fof(miloA4028,axiom,
    p__contraryAttribute2(c__Dirty,c__Clean) ).

fof(miloA4029,axiom,
    p__d__subclass(c__DataStorageDevice,c__Device) ).

fof(miloA4030,axiom,
    p__d__subclass(c__Whiteboard,c__DataStorageDevice) ).

fof(miloA4031,axiom,
    p__d__subclass(c__Whiteboard,c__DisplayArtifact) ).

fof(miloA4032,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Whiteboard)
     => p__color(OBJ,c__White) ) ).

fof(miloA4033,axiom,
    ! [OBJ] :
      ( p__d__instance(OBJ,c__Whiteboard)
     => p__structure(OBJ,c__Flat) ) ).

fof(miloA4035,axiom,
    p__d__subclass(c__Steam,c__Water) ).

fof(miloA4036,axiom,
    ! [STEAM] :
      ( p__d__instance(STEAM,c__Steam)
     => ? [BOIL,WATER] :
          ( p__d__instance(BOIL,c__Boiling)
          & p__d__instance(WATER,c__Water)
          & p__patient(BOIL,WATER)
          & p__result(BOIL,STEAM)
          & p__attribute(STEAM,c__Gas) ) ) ).

fof(miloA4037,axiom,
    p__d__subclass(c__WaterHeater,c__HeatingDevice) ).

fof(miloA4041,axiom,
    p__subrelation(c__airTemperature,c__measure) ).

fof(miloA4042,axiom,
    p__d__subclass(c__TemperatureAttribute,c__SubjectiveAssessmentAttribute) ).

fof(miloA4043,axiom,
    p__d__instance(c__ColdTemperature,c__TemperatureAttribute) ).

fof(miloA4044,axiom,
    p__successorAttributeClosure(c__ColdTemperature,c__HotTemperature) ).

fof(miloA4045,axiom,
    p__d__instance(c__CoolTemperature,c__TemperatureAttribute) ).

fof(miloA4046,axiom,
    p__successorAttribute(c__ColdTemperature,c__CoolTemperature) ).

fof(miloA4047,axiom,
    p__d__instance(c__WarmTemperature,c__TemperatureAttribute) ).

fof(miloA4048,axiom,
    p__successorAttribute(c__CoolTemperature,c__WarmTemperature) ).

fof(miloA4049,axiom,
    p__d__instance(c__HotTemperature,c__TemperatureAttribute) ).

fof(miloA4050,axiom,
    p__successorAttribute(c__WarmTemperature,c__HotTemperature) ).

fof(miloA4051,axiom,
    ! [CLASS,X,Y] :
      ( ( p__d__instance(X,c__Object)
        & p__d__instance(Y,c__Object)
        & p__d__instance(X,CLASS)
        & p__d__instance(Y,CLASS)
        & p__attribute(X,c__ColdTemperature)
        & p__attribute(Y,c__HotTemperature) )
     => ? [TEMPX,TEMPY] :
          ( p__measure(X,TEMPX)
          & p__d__instance(TEMPX,c__TemperatureMeasure)
          & p__measure(Y,TEMPY)
          & p__d__instance(TEMPY,c__TemperatureMeasure)
          & p__greaterThan(TEMPY,TEMPX) ) ) ).

fof(miloA4052,axiom,
    p__d__instance(c__Multilingual,c__RelationalAttribute) ).

fof(miloA4053,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Multilingual) )
     => p__d__instance(X,c__Human) ) ).

fof(miloA4055,axiom,
    p__d__subclass(c__RecreationalVehicle,c__Vehicle) ).

fof(miloA4056,axiom,
    p__d__subclass(c__RecreationalVehicle,c__MobileResidence) ).

fof(miloA4058,axiom,
    p__d__subclass(c__ElectronicLock,c__Lock) ).

fof(miloA4060,axiom,
    p__d__subclass(c__RunningTrack,c__StationaryArtifact) ).

fof(miloA4061,axiom,
    p__d__subclass(c__RunningTrack,c__LandTransitway) ).

fof(miloA4063,axiom,
    p__d__subclass(c__KnockLight,c__Device) ).

fof(miloA4066,axiom,
    p__d__subclass(c__PrayerMat,c__Rug) ).

fof(miloA4068,axiom,
    p__d__subclass(c__VideoGame,c__Game) ).

fof(miloA4069,axiom,
    ! [GAME] :
      ( p__d__instance(GAME,c__VideoGame)
     => ? [VIDEO] :
          ( p__d__instance(VIDEO,c__VideoRecording)
          & p__represents(VIDEO,GAME) ) ) ).

fof(miloA4070,axiom,
    p__d__subclass(c__VideoGamePlayer,c__MediaSystem) ).

fof(miloA4072,axiom,
    p__d__subclass(c__ElectricalOutlet,c__Device) ).

fof(miloA4075,axiom,
    p__d__subclass(c__ElectricalPlug,c__Plug) ).

fof(miloA4076,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__CorpuscularObject)
        & p__d__instance(X,c__ElectricalPlug) )
     => p__material(c__Metal,X) ) ).

fof(miloA4078,axiom,
    ! [PLUG,OUTLET,POWER,DEVICE] :
      ( ( p__d__instance(PLUG,c__EngineeringComponent)
        & p__d__instance(DEVICE,c__EngineeringComponent)
        & p__d__instance(OUTLET,c__Hole)
        & p__d__instance(OUTLET,c__EngineeringComponent)
        & p__d__instance(POWER,c__EngineeringComponent)
        & p__d__instance(PLUG,c__ElectricalPlug)
        & p__d__instance(DEVICE,c__ElectricDevice)
        & p__d__instance(OUTLET,c__ElectricalOutlet)
        & p__connectedEngineeringComponents(DEVICE,PLUG)
        & p__completelyFills(PLUG,OUTLET)
        & p__d__instance(POWER,c__PowerSource)
        & p__connectedEngineeringComponents(POWER,OUTLET) )
     => ? [RE] :
          ( p__d__instance(RE,c__RadiatingElectromagnetic)
          & p__origin(RE,POWER)
          & p__destination(RE,DEVICE) ) ) ).

fof(miloA4079,axiom,
    p__d__subclass(c__OutletAdapter,c__Device) ).

fof(miloA4082,axiom,
    p__d__subclass(c__AirConditioner,c__ElectricDevice) ).

fof(miloA4084,axiom,
    p__d__instance(c__Surrounded,c__PositionalAttribute) ).

fof(miloA4085,axiom,
    ! [OBJ1,OBJ2,X] :
      ( ( p__d__instance(OBJ2,c__Object)
        & p__d__instance(OBJ1,c__SelfConnectedObject)
        & p__d__instance(X,c__SelfConnectedObject)
        & p__orientation(OBJ1,OBJ2,c__Surrounded)
        & p__side(X,OBJ1) )
     => p__meetsSpatially(X,OBJ2) ) ).

fof(miloA4086,axiom,
    p__d__subclass(c__Courtyard,c__StationaryArtifact) ).

fof(miloA4087,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__SelfConnectedObject)
        & p__d__instance(X,c__Courtyard) )
     => ( ! [ROOF] :
            ( ~ p__d__instance(ROOF,c__SelfConnectedObject)
            | ~ p__d__instance(ROOF,c__Roof)
            | ~ p__top(ROOF,X) )
        & ? [BLDG] :
            ( p__d__instance(BLDG,c__Building)
            & p__orientation(X,BLDG,c__Surrounded) ) ) ) ).

fof(miloA4088,axiom,
    p__d__subclass(c__SpeakerDevice,c__ElectricDevice) ).

fof(miloA4090,axiom,
    p__d__subclass(c__Earphone,c__Device) ).

fof(miloA4092,axiom,
    p__d__subclass(c__Public,c__GroupOfPeople) ).

fof(miloA4094,axiom,
    p__d__subclass(c__PublicAddressSystem,c__CommunicationSystem) ).

fof(miloA4097,axiom,
    p__d__subclass(c__Wheelchair,c__TransportationDevice) ).

fof(miloA4098,axiom,
    ! [X] :
      ( p__d__instance(X,c__Wheelchair)
     => ? [WHEEL,SEAT] :
          ( p__d__instance(SEAT,c__Seat)
          & p__d__instance(WHEEL,c__Wheel)
          & p__part(SEAT,X)
          & p__part(WHEEL,X) ) ) ).

fof(miloA4100,axiom,
    p__d__instance(c__WheelchairAccessible,c__ObjectiveNorm) ).

fof(miloA4101,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__WheelchairAccessible) )
     => p__attribute(X,c__HandicappedFriendly) ) ).

fof(miloA4103,axiom,
    p__d__instance(c__HandicappedFriendly,c__SubjectiveAssessmentAttribute) ).

fof(miloA4104,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__HandicappedFriendly) )
     => p__d__instance(X,c__Object) ) ).

fof(miloA4105,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__HandicappedFriendly) )
     => ? [ATTR,PERSON] :
          ( p__d__instance(ATTR,c__Disability)
          & p__d__instance(PERSON,c__Human)
          & p__attribute(PERSON,ATTR)
          & p__inScopeOfInterest(PERSON,X) ) ) ).

fof(miloA4106,axiom,
    p__d__subclass(c__Recliner,c__Seat) ).

fof(miloA4108,axiom,
    p__d__subclass(c__VisualContentBearingPhysical,c__ContentBearingPhysical) ).

fof(miloA4109,axiom,
    p__d__subclass(c__VisualContentBearingObject,c__ContentBearingPhysical) ).

fof(miloA4110,axiom,
    p__d__subclass(c__VisualContentBearingObject,c__VisualContentBearingPhysical) ).

fof(miloA4111,axiom,
    p__d__subclass(c__Image,c__VisualContentBearingObject) ).

fof(miloA4112,axiom,
    p__d__subclass(c__MultimediaProjector,c__MediaSystem) ).

fof(miloA4114,axiom,
    p__d__subclass(c__AudioRecorder,c__Device) ).

fof(miloA4116,axiom,
    p__d__subclass(c__VideoDisplay,c__ElectricDevice) ).

fof(miloA4118,axiom,
    p__d__subclass(c__TDDPhone,c__Telephone) ).

fof(miloA4120,axiom,
    p__d__subclass(c__Photocopier,c__ElectricDevice) ).

fof(miloA4123,axiom,
    p__d__subclass(c__Photocopying,c__Making) ).

fof(miloA4124,axiom,
    ! [COPY] :
      ( p__d__instance(COPY,c__Photocopying)
     => ? [OBJ1,OBJ2] :
          ( p__d__instance(OBJ1,c__Object)
          & p__d__instance(OBJ2,c__VisualContentBearingObject)
          & p__patient(COPY,OBJ1)
          & p__result(COPY,OBJ2)
          & p__represents(OBJ2,OBJ1) ) ) ).

fof(miloA4125,axiom,
    p__d__subclass(c__Sail,c__Artifact) ).

fof(miloA4127,axiom,
    p__d__subclass(c__ACPowerSource,c__PowerSource) ).

fof(miloA4128,axiom,
    p__d__subclass(c__SinglePhasePowerSource,c__ACPowerSource) ).

fof(miloA4129,axiom,
    p__d__subclass(c__ThreePhasePowerSource,c__ACPowerSource) ).

fof(miloA4130,axiom,
    p__d__instance(c__voltageMeasure,c__BinaryPredicate) ).

fof(miloA4133,axiom,
    ! [OBJ,MEAS,QUANT] :
      ( ( p__d__instance(MEAS,c__PhysicalQuantity)
        & p__d__instance(OBJ,c__PowerSource)
        & p__d__instance(QUANT,c__RealNumber)
        & p__voltageMeasure(OBJ,MEAS) )
     => MEAS = f__MeasureFn2(QUANT,c__Volt) ) ).

fof(miloA4134,axiom,
    ! [OBJ,MEAS] :
      ( ( p__d__instance(MEAS,c__PhysicalQuantity)
        & p__d__instance(OBJ,c__PowerSource)
        & p__voltageMeasure(OBJ,MEAS) )
     => ? [ELEC,PROC] :
          ( p__d__instance(ELEC,c__Electricity)
          & p__d__instance(PROC,c__Process)
          & p__instrument(PROC,OBJ)
          & p__result(PROC,ELEC)
          & p__measure(ELEC,MEAS) ) ) ).

fof(miloA4135,axiom,
    p__d__subclass(c__Document,c__ContentBearingObject) ).

fof(miloA4136,axiom,
    p__d__subclass(c__Document,c__Artifact) ).

fof(miloA4138,axiom,
    p__d__subclass(c__Book,c__Document) ).

fof(miloA4139,axiom,
    p__d__subclass(c__GuideBook,c__Book) ).

fof(miloA4140,axiom,
    ! [X] :
      ( p__d__instance(X,c__GuideBook)
     => ? [LOC] :
          ( p__d__instance(LOC,c__GeographicArea)
          & p__refers(X,LOC) ) ) ).

fof(miloA4141,axiom,
    p__d__subclass(c__DiningGuide,c__GuideBook) ).

fof(miloA4142,axiom,
    ! [X] :
      ( p__d__instance(X,c__DiningGuide)
     => ? [LOC,REST] :
          ( p__d__instance(LOC,c__GeographicArea)
          & p__refers(X,LOC)
          & p__d__instance(REST,c__Restaurant)
          & p__located(REST,LOC)
          & p__refers(X,REST) ) ) ).

fof(miloA4143,axiom,
    p__d__subclass(c__TelephoneHandset,c__Device) ).

fof(miloA4144,axiom,
    ! [X] :
      ( p__d__instance(X,c__TelephoneHandset)
     => ? [EARPHONE,MIC] :
          ( p__d__instance(EARPHONE,c__Earphone)
          & p__d__instance(MIC,c__Microphone)
          & p__part(EARPHONE,X)
          & p__part(MIC,X) ) ) ).

fof(miloA4145,axiom,
    p__d__subclass(c__FireAlarm,c__Device) ).

fof(miloA4147,axiom,
    p__d__subclass(c__GrabBar,c__Artifact) ).

fof(miloA4150,axiom,
    p__d__subclass(c__HighRise,c__Building) ).

fof(miloA4151,axiom,
    ! [X] :
      ( p__d__instance(X,c__HighRise)
     => ? [LEVELS,NUM] :
          ( p__d__instance(NUM,c__Integer)
          & p__d__instance(LEVELS,c__Collection)
          & ! [FLR] :
              ( ( p__d__instance(FLR,c__SelfConnectedObject)
                & p__d__instance(FLR,c__BuildingLevel)
                & p__part(FLR,X) )
             => p__member(FLR,LEVELS) )
          & p__memberCount(LEVELS,NUM)
          & p__greaterThanOrEqualTo(NUM,c__10) ) ) ).

fof(miloA4152,axiom,
    p__d__subclass(c__Soaking,c__Wetting) ).

fof(miloA4154,axiom,
    p__d__subclass(c__GrecianTub,c__BathTub) ).

fof(miloA4156,axiom,
    p__d__subclass(c__HemisphereFigure,c__ThreeDimensionalFigure) ).

fof(miloA4158,axiom,
    p__d__subclass(c__Dome,c__Ceiling) ).

fof(miloA4159,axiom,
    ! [X] :
      ( p__d__instance(X,c__Dome)
     => ? [HEMI] :
          ( p__attribute(X,HEMI)
          & p__d__instance(HEMI,c__HemisphereFigure) ) ) ).

fof(miloA4160,axiom,
    p__d__instance(c__Historical,c__RelationalAttribute) ).

fof(miloA4161,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Historical) )
     => p__d__instance(X,c__Physical) ) ).

fof(miloA4162,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__Historical) )
     => p__refers(c__History,X) ) ).

fof(miloA4163,axiom,
    p__d__instance(c__Rural,c__RelationalAttribute) ).

fof(miloA4164,axiom,
    p__d__instance(c__Suburban,c__RelationalAttribute) ).

fof(miloA4165,axiom,
    p__d__instance(c__Urban,c__RelationalAttribute) ).

fof(miloA4166,axiom,
    p__d__subclass(c__Patio,c__Region) ).

fof(miloA4168,axiom,
    p__d__subclass(c__Lanai,c__Patio) ).

fof(miloA4169,axiom,
    p__d__subclass(c__Lanai,c__StationaryArtifact) ).

fof(miloA4171,axiom,
    p__d__instance(c__hasUniform,c__BinaryPredicate) ).

fof(miloA4175,axiom,
    p__d__subclass(c__UniformClothing,c__Clothing) ).

fof(miloA4176,axiom,
    ! [X] :
      ( p__d__subclass(X,c__UniformClothing)
     => ? [GRP] :
          ( p__d__instance(GRP,c__Group)
          & p__hasUniform(GRP,X) ) ) ).

fof(miloA4177,axiom,
    ! [X] :
      ( p__d__instance(X,c__UniformClothing)
     => ? [PROC,DESIGN] :
          ( p__d__instance(PROC,c__IntentionalProcess)
          & p__result(PROC,DESIGN)
          & p__represents(X,DESIGN) ) ) ).

fof(miloA4178,axiom,
    p__d__subclass(c__Tripod,c__Device) ).

fof(miloA4179,axiom,
    ! [X] :
      ( p__d__instance(X,c__Tripod)
     => ? [LEG1,LEG2,LEG3] :
          ( p__d__instance(LEG1,c__Object)
          & p__d__instance(LEG2,c__Object)
          & p__d__instance(LEG3,c__Object)
          & p__part(LEG1,X)
          & p__part(LEG2,X)
          & p__part(LEG3,X)
          & p__meetsSpatially(LEG1,LEG2)
          & p__meetsSpatially(LEG2,LEG3)
          & p__meetsSpatially(LEG1,LEG3) ) ) ).

fof(miloA4181,axiom,
    p__d__subclass(c__Easel,c__Tripod) ).

fof(miloA4183,axiom,
    p__d__subclass(c__Solarium,c__Room) ).

fof(miloA4184,axiom,
    ! [X] :
      ( p__d__instance(X,c__Solarium)
     => ? [WALL] :
          ( p__d__instance(WALL,c__Wall)
          & p__part(WALL,X)
          & p__attribute(WALL,c__Transparent) ) ) ).

fof(miloA4185,axiom,
    p__d__subclass(c__ExerciseCenter,c__SportsFacility) ).

fof(miloA4187,axiom,
    p__d__subclass(c__GameRoom,c__Room) ).

fof(miloA4189,axiom,
    p__d__subclass(c__Nursery,c__Room) ).

fof(miloA4190,axiom,
    ! [X] :
      ( p__d__instance(X,c__Nursery)
     => ? [CRIB] :
          ( p__d__instance(CRIB,c__Crib)
          & p__located(CRIB,X) ) ) ).

fof(miloA4191,axiom,
    p__d__subclass(c__SteamBath,c__Room) ).

fof(miloA4192,axiom,
    ! [X] :
      ( p__d__instance(X,c__SteamBath)
     => ? [STEAM] :
          ( p__d__instance(STEAM,c__Steam)
          & p__located(STEAM,X) ) ) ).

fof(miloA4194,axiom,
    p__d__subclass(c__HeatedPool,c__SwimmingPool) ).

fof(miloA4195,axiom,
    ! [X,HEATER,WATER] :
      ( ( p__d__instance(X,c__SelfConnectedObject)
        & p__d__instance(X,c__HeatedPool)
        & p__contains(X,WATER)
        & p__d__instance(WATER,c__Water)
        & p__part(X,HEATER)
        & p__d__instance(HEATER,c__WaterHeater)
        & p__attribute(HEATER,c__DeviceOn) )
     => p__attribute(WATER,c__WarmTemperature) ) ).

fof(miloA4196,axiom,
    p__d__subclass(c__RoomHeater,c__HeatingDevice) ).

fof(miloA4198,axiom,
    p__d__subclass(c__DanceHall,c__StationaryArtifact) ).

fof(miloA4200,axiom,
    p__d__subclass(c__NightClub,c__DanceHall) ).

fof(miloA4201,axiom,
    ! [X] :
      ( p__d__instance(X,c__NightClub)
     => ? [BAR] :
          ( p__d__instance(BAR,c__Tavern)
          & p__located(BAR,X) ) ) ).

fof(miloA4202,axiom,
    p__d__subclass(c__ScubaDiving,c__Swimming) ).

fof(miloA4203,axiom,
    p__d__instance(c__AmericansWithDisabilitiesAct,c__Proposition) ).

fof(miloA4204,axiom,
    p__subrelation(c__conforms,c__represents) ).

fof(miloA4207,axiom,
    ! [OBJ] :
      ( ( p__d__instance(OBJ,c__Object)
        & p__conforms(OBJ,c__AmericansWithDisabilitiesAct) )
     => p__attribute(OBJ,c__HandicappedFriendly) ) ).

fof(miloA4208,axiom,
    p__d__instance(c__USFEMA,c__GovernmentOrganization) ).

fof(miloA4209,axiom,
    p__subrelation(c__approves,c__inScopeOfInterest) ).

fof(miloA4213,axiom,
    p__d__subclass(c__WetBar,c__Artifact) ).

fof(miloA4215,axiom,
    p__d__subclass(c__SurveillanceSystem,c__Collection) ).

fof(miloA4219,axiom,
    p__d__subclass(c__ArtifactMediatedCommunication,c__Communication) ).

fof(miloA4220,axiom,
    ! [X] :
      ( p__d__instance(X,c__ArtifactMediatedCommunication)
     => ? [OBJ] :
          ( p__d__instance(OBJ,c__Artifact)
          & p__instrument(X,OBJ) ) ) ).

fof(miloA4221,axiom,
    p__d__subclass(c__TelephoneCommunication,c__ArtifactMediatedCommunication) ).

fof(miloA4222,axiom,
    ! [X] :
      ( p__d__instance(X,c__TelephoneCommunication)
     => ? [TEL1,TEL2,ORIGIN,DEST] :
          ( p__d__instance(ORIGIN,c__ContactSite)
          & p__d__instance(DEST,c__ContactSite)
          & p__d__instance(TEL1,c__Agent)
          & p__d__instance(TEL2,c__Agent)
          & p__origin(X,ORIGIN)
          & p__destination(X,DEST)
          & p__siteForContact(ORIGIN,TEL1)
          & p__siteForContact(DEST,TEL2)
          & p__d__instance(TEL1,c__Telephone)
          & p__d__instance(TEL2,c__Telephone)
          & p__instrument(X,TEL1)
          & p__instrument(X,TEL2) ) ) ).

fof(miloA4223,axiom,
    p__d__subclass(c__OperatorAssistedTelephoneCommunication,c__TelephoneCommunication) ).

fof(miloA4225,axiom,
    p__d__subclass(c__DirectDialTelephoneCommunication,c__TelephoneCommunication) ).

fof(miloA4227,axiom,
    p__d__subclass(c__VoiceMail,c__AudioRecording) ).

fof(miloA4228,axiom,
    ! [X] :
      ( p__d__instance(X,c__VoiceMail)
     => ? [TEL] :
          ( p__d__instance(TEL,c__TelephoneCommunication)
          & p__patient(TEL,X) ) ) ).

fof(miloA4229,axiom,
    p__d__instance(c__Local,c__RelationalAttribute) ).

fof(miloA4230,axiom,
    p__d__instance(c__Domestic,c__RelationalAttribute) ).

fof(miloA4231,axiom,
    p__d__instance(c__International,c__RelationalAttribute) ).

fof(miloA4232,axiom,
    p__d__instance(c__CommunalAttribute,c__RelationalAttribute) ).

fof(miloA4233,axiom,
    p__d__instance(c__PrivateAttribute,c__RelationalAttribute) ).

fof(miloA4234,axiom,
    ! [X] :
      ( ( p__d__instance(X,c__Object)
        & p__attribute(X,c__CommunalAttribute) )
     => p__d__instance(X,c__Object) ) ).

fof(miloA4237,axiom,
    p__d__subclass(c__Policy,c__Proposition) ).

fof(miloA4238,axiom,
    ! [POLICY] :
      ( p__d__instance(POLICY,c__Policy)
     => ? [ORG] :
          ( p__d__instance(ORG,c__Organization)
          & p__policyOwner(ORG,POLICY) ) ) ).

fof(miloA4239,axiom,
    p__d__instance(c__policyOwner,c__BinaryPredicate) ).

fof(miloA4242,axiom,
    ! [AGENT,POLICY] :
      ( ( p__d__instance(POLICY,c__Policy)
        & p__d__instance(AGENT,c__Organization)
        & p__policyOwner(AGENT,POLICY) )
     => ? [CREATE] :
          ( p__d__instance(CREATE,c__Creation)
          & p__agent(CREATE,AGENT)
          & p__result(CREATE,POLICY) ) ) ).

fof(miloA4243,axiom,
    p__d__subclass(c__Hydrogen,c__ElementalSubstance) ).

fof(miloA4244,axiom,
    p__atomicNumber(c__Hydrogen,c__1) ).

fof(miloA4245,axiom,
    p__d__subclass(c__Helium,c__ElementalSubstance) ).

fof(miloA4246,axiom,
    p__atomicNumber(c__Helium,c__2) ).

fof(miloA4247,axiom,
    p__d__subclass(c__Lithium,c__ElementalSubstance) ).

fof(miloA4248,axiom,
    p__atomicNumber(c__Lithium,c__3) ).

fof(miloA4249,axiom,
    p__d__subclass(c__Beryllium,c__ElementalSubstance) ).

fof(miloA4250,axiom,
    p__atomicNumber(c__Beryllium,c__4) ).

fof(miloA4251,axiom,
    p__d__subclass(c__Boron,c__ElementalSubstance) ).

fof(miloA4252,axiom,
    p__atomicNumber(c__Boron,c__5) ).

fof(miloA4253,axiom,
    p__d__subclass(c__Carbon,c__ElementalSubstance) ).

fof(miloA4254,axiom,
    p__atomicNumber(c__Carbon,c__6) ).

fof(miloA4255,axiom,
    p__d__subclass(c__Nitrogen,c__ElementalSubstance) ).

fof(miloA4256,axiom,
    p__atomicNumber(c__Nitrogen,c__7) ).

fof(miloA4257,axiom,
    p__d__subclass(c__Oxygen,c__ElementalSubstance) ).

fof(miloA4258,axiom,
    p__atomicNumber(c__Oxygen,c__8) ).

fof(miloA4259,axiom,
    p__d__subclass(c__Fluorine,c__ElementalSubstance) ).

fof(miloA4260,axiom,
    p__atomicNumber(c__Fluorine,c__9) ).

fof(miloA4261,axiom,
    p__d__subclass(c__Neon,c__ElementalSubstance) ).

fof(miloA4262,axiom,
    p__atomicNumber(c__Neon,c__10) ).

fof(miloA4263,axiom,
    p__d__subclass(c__Sodium,c__ElementalSubstance) ).

fof(miloA4264,axiom,
    p__atomicNumber(c__Sodium,c__11) ).

fof(miloA4265,axiom,
    p__d__subclass(c__Magnesium,c__ElementalSubstance) ).

fof(miloA4266,axiom,
    p__atomicNumber(c__Magnesium,c__12) ).

fof(miloA4267,axiom,
    p__d__subclass(c__Aluminum,c__ElementalSubstance) ).

fof(miloA4268,axiom,
    p__atomicNumber(c__Aluminum,c__13) ).

fof(miloA4269,axiom,
    p__d__subclass(c__Silicon,c__ElementalSubstance) ).

fof(miloA4270,axiom,
    p__atomicNumber(c__Silicon,c__14) ).

fof(miloA4271,axiom,
    p__d__subclass(c__Phosphorus,c__ElementalSubstance) ).

fof(miloA4272,axiom,
    p__atomicNumber(c__Phosphorus,c__15) ).

fof(miloA4273,axiom,
    p__d__subclass(c__Sulphur,c__ElementalSubstance) ).

fof(miloA4274,axiom,
    p__atomicNumber(c__Sulphur,c__16) ).

fof(miloA4275,axiom,
    p__d__subclass(c__Chlorine,c__ElementalSubstance) ).

fof(miloA4276,axiom,
    p__atomicNumber(c__Chlorine,c__17) ).

fof(miloA4277,axiom,
    p__d__subclass(c__Argon,c__ElementalSubstance) ).

fof(miloA4278,axiom,
    p__atomicNumber(c__Argon,c__18) ).

fof(miloA4279,axiom,
    p__d__subclass(c__Potassium,c__ElementalSubstance) ).

fof(miloA4280,axiom,
    p__atomicNumber(c__Potassium,c__19) ).

fof(miloA4281,axiom,
    p__d__subclass(c__Calcium,c__ElementalSubstance) ).

fof(miloA4282,axiom,
    p__atomicNumber(c__Calcium,c__20) ).

fof(miloA4283,axiom,
    p__d__subclass(c__Scandium,c__ElementalSubstance) ).

fof(miloA4284,axiom,
    p__atomicNumber(c__Scandium,c__21) ).

fof(miloA4285,axiom,
    p__d__subclass(c__Titanium,c__ElementalSubstance) ).

fof(miloA4286,axiom,
    p__atomicNumber(c__Titanium,c__22) ).

fof(miloA4287,axiom,
    p__d__subclass(c__Vanadium,c__ElementalSubstance) ).

fof(miloA4288,axiom,
    p__atomicNumber(c__Vanadium,c__23) ).

fof(miloA4289,axiom,
    p__d__subclass(c__Chromium,c__ElementalSubstance) ).

fof(miloA4290,axiom,
    p__atomicNumber(c__Chromium,c__24) ).

fof(miloA4291,axiom,
    p__d__subclass(c__Manganese,c__ElementalSubstance) ).

fof(miloA4292,axiom,
    p__atomicNumber(c__Manganese,c__25) ).

fof(miloA4293,axiom,
    p__d__subclass(c__Iron,c__ElementalSubstance) ).

fof(miloA4294,axiom,
    p__atomicNumber(c__Iron,c__26) ).

fof(miloA4295,axiom,
    p__d__subclass(c__Cobalt,c__ElementalSubstance) ).

fof(miloA4296,axiom,
    p__atomicNumber(c__Cobalt,c__27) ).

fof(miloA4297,axiom,
    p__d__subclass(c__Nickel,c__ElementalSubstance) ).

fof(miloA4298,axiom,
    p__atomicNumber(c__Nickel,c__28) ).

fof(miloA4299,axiom,
    p__d__subclass(c__Copper,c__ElementalSubstance) ).

fof(miloA4300,axiom,
    p__atomicNumber(c__Copper,c__29) ).

fof(miloA4301,axiom,
    p__d__subclass(c__Zinc,c__ElementalSubstance) ).

fof(miloA4302,axiom,
    p__atomicNumber(c__Zinc,c__30) ).

fof(miloA4303,axiom,
    p__d__subclass(c__Gallium,c__ElementalSubstance) ).

fof(miloA4304,axiom,
    p__atomicNumber(c__Gallium,c__31) ).

fof(miloA4305,axiom,
    p__d__subclass(c__Germanium,c__ElementalSubstance) ).

fof(miloA4306,axiom,
    p__atomicNumber(c__Germanium,c__32) ).

fof(miloA4307,axiom,
    p__d__subclass(c__Arsenic,c__ElementalSubstance) ).

fof(miloA4308,axiom,
    p__atomicNumber(c__Arsenic,c__33) ).

fof(miloA4309,axiom,
    p__d__subclass(c__Selenium,c__ElementalSubstance) ).

fof(miloA4310,axiom,
    p__atomicNumber(c__Selenium,c__34) ).

fof(miloA4311,axiom,
    p__d__subclass(c__Bromine,c__ElementalSubstance) ).

fof(miloA4312,axiom,
    p__atomicNumber(c__Bromine,c__35) ).

fof(miloA4313,axiom,
    p__d__subclass(c__Krypton,c__ElementalSubstance) ).

fof(miloA4314,axiom,
    p__atomicNumber(c__Krypton,c__36) ).

fof(miloA4315,axiom,
    p__d__subclass(c__Rubidium,c__ElementalSubstance) ).

fof(miloA4316,axiom,
    p__atomicNumber(c__Rubidium,c__37) ).

fof(miloA4317,axiom,
    p__d__subclass(c__Strontium,c__ElementalSubstance) ).

fof(miloA4318,axiom,
    p__atomicNumber(c__Strontium,c__38) ).

fof(miloA4319,axiom,
    p__d__subclass(c__Yttrium,c__ElementalSubstance) ).

fof(miloA4320,axiom,
    p__atomicNumber(c__Yttrium,c__39) ).

fof(miloA4321,axiom,
    p__d__subclass(c__Zirconium,c__ElementalSubstance) ).

fof(miloA4322,axiom,
    p__atomicNumber(c__Zirconium,c__40) ).

fof(miloA4323,axiom,
    p__d__subclass(c__Niobium,c__ElementalSubstance) ).

fof(miloA4324,axiom,
    p__atomicNumber(c__Niobium,c__41) ).

fof(miloA4325,axiom,
    p__d__subclass(c__Molybdenum,c__ElementalSubstance) ).

fof(miloA4326,axiom,
    p__atomicNumber(c__Molybdenum,c__42) ).

fof(miloA4327,axiom,
    p__d__subclass(c__Technetium,c__ElementalSubstance) ).

fof(miloA4328,axiom,
    p__atomicNumber(c__Technetium,c__43) ).

fof(miloA4329,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Technetium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__98,c__Amu)) ) ).

fof(miloA4330,axiom,
    p__d__subclass(c__Ruthenium,c__ElementalSubstance) ).

fof(miloA4331,axiom,
    p__atomicNumber(c__Ruthenium,c__44) ).

fof(miloA4332,axiom,
    p__d__subclass(c__Rhodium,c__ElementalSubstance) ).

fof(miloA4333,axiom,
    p__atomicNumber(c__Rhodium,c__45) ).

fof(miloA4334,axiom,
    p__d__subclass(c__Palladium,c__ElementalSubstance) ).

fof(miloA4335,axiom,
    p__atomicNumber(c__Palladium,c__46) ).

fof(miloA4336,axiom,
    p__d__subclass(c__Silver,c__ElementalSubstance) ).

fof(miloA4337,axiom,
    p__atomicNumber(c__Silver,c__47) ).

fof(miloA4338,axiom,
    p__d__subclass(c__Cadmium,c__ElementalSubstance) ).

fof(miloA4339,axiom,
    p__atomicNumber(c__Cadmium,c__48) ).

fof(miloA4340,axiom,
    p__d__subclass(c__Indium,c__ElementalSubstance) ).

fof(miloA4341,axiom,
    p__atomicNumber(c__Indium,c__49) ).

fof(miloA4342,axiom,
    p__d__subclass(c__Tin,c__ElementalSubstance) ).

fof(miloA4343,axiom,
    p__atomicNumber(c__Tin,c__50) ).

fof(miloA4344,axiom,
    p__d__subclass(c__Antimony,c__ElementalSubstance) ).

fof(miloA4345,axiom,
    p__atomicNumber(c__Antimony,c__51) ).

fof(miloA4346,axiom,
    p__d__subclass(c__Tellurium,c__ElementalSubstance) ).

fof(miloA4347,axiom,
    p__atomicNumber(c__Tellurium,c__52) ).

fof(miloA4348,axiom,
    p__d__subclass(c__Iodine,c__ElementalSubstance) ).

fof(miloA4349,axiom,
    p__atomicNumber(c__Iodine,c__53) ).

fof(miloA4350,axiom,
    p__d__subclass(c__Xenon,c__ElementalSubstance) ).

fof(miloA4351,axiom,
    p__atomicNumber(c__Xenon,c__54) ).

fof(miloA4352,axiom,
    p__d__subclass(c__Caesium,c__ElementalSubstance) ).

fof(miloA4353,axiom,
    p__atomicNumber(c__Caesium,c__55) ).

fof(miloA4354,axiom,
    p__d__subclass(c__Barium,c__ElementalSubstance) ).

fof(miloA4355,axiom,
    p__atomicNumber(c__Barium,c__56) ).

fof(miloA4356,axiom,
    p__d__subclass(c__Lanthanum,c__ElementalSubstance) ).

fof(miloA4357,axiom,
    p__atomicNumber(c__Lanthanum,c__57) ).

fof(miloA4358,axiom,
    p__d__subclass(c__Cerium,c__ElementalSubstance) ).

fof(miloA4359,axiom,
    p__atomicNumber(c__Cerium,c__58) ).

fof(miloA4360,axiom,
    p__d__subclass(c__Praseodymium,c__ElementalSubstance) ).

fof(miloA4361,axiom,
    p__atomicNumber(c__Praseodymium,c__59) ).

fof(miloA4362,axiom,
    p__d__subclass(c__Neodymium,c__ElementalSubstance) ).

fof(miloA4363,axiom,
    p__atomicNumber(c__Neodymium,c__60) ).

fof(miloA4364,axiom,
    p__d__subclass(c__Promethium,c__ElementalSubstance) ).

fof(miloA4365,axiom,
    p__atomicNumber(c__Promethium,c__61) ).

fof(miloA4366,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Promethium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__147,c__Amu)) ) ).

fof(miloA4367,axiom,
    p__d__subclass(c__Samarium,c__ElementalSubstance) ).

fof(miloA4368,axiom,
    p__atomicNumber(c__Samarium,c__62) ).

fof(miloA4369,axiom,
    p__d__subclass(c__Europium,c__ElementalSubstance) ).

fof(miloA4370,axiom,
    p__atomicNumber(c__Europium,c__63) ).

fof(miloA4371,axiom,
    p__d__subclass(c__Gadolinium,c__ElementalSubstance) ).

fof(miloA4372,axiom,
    p__atomicNumber(c__Gadolinium,c__64) ).

fof(miloA4373,axiom,
    p__d__subclass(c__Terbium,c__ElementalSubstance) ).

fof(miloA4374,axiom,
    p__atomicNumber(c__Terbium,c__65) ).

fof(miloA4375,axiom,
    p__d__subclass(c__Dysprosium,c__ElementalSubstance) ).

fof(miloA4376,axiom,
    p__atomicNumber(c__Dysprosium,c__66) ).

fof(miloA4377,axiom,
    p__d__subclass(c__Holmium,c__ElementalSubstance) ).

fof(miloA4378,axiom,
    p__atomicNumber(c__Holmium,c__67) ).

fof(miloA4379,axiom,
    p__d__subclass(c__Erbium,c__ElementalSubstance) ).

fof(miloA4380,axiom,
    p__atomicNumber(c__Erbium,c__68) ).

fof(miloA4381,axiom,
    p__d__subclass(c__Thulium,c__ElementalSubstance) ).

fof(miloA4382,axiom,
    p__atomicNumber(c__Thulium,c__69) ).

fof(miloA4383,axiom,
    p__d__subclass(c__Ytterbium,c__ElementalSubstance) ).

fof(miloA4384,axiom,
    p__atomicNumber(c__Ytterbium,c__70) ).

fof(miloA4385,axiom,
    p__d__subclass(c__Lutetium,c__ElementalSubstance) ).

fof(miloA4386,axiom,
    p__atomicNumber(c__Lutetium,c__71) ).

fof(miloA4387,axiom,
    p__d__subclass(c__Hafnium,c__ElementalSubstance) ).

fof(miloA4388,axiom,
    p__atomicNumber(c__Hafnium,c__72) ).

fof(miloA4389,axiom,
    p__d__subclass(c__Tantalum,c__ElementalSubstance) ).

fof(miloA4390,axiom,
    p__atomicNumber(c__Tantalum,c__73) ).

fof(miloA4391,axiom,
    p__d__subclass(c__Tungsten,c__ElementalSubstance) ).

fof(miloA4392,axiom,
    p__atomicNumber(c__Tungsten,c__74) ).

fof(miloA4393,axiom,
    p__d__subclass(c__Rhenium,c__ElementalSubstance) ).

fof(miloA4394,axiom,
    p__atomicNumber(c__Rhenium,c__75) ).

fof(miloA4395,axiom,
    p__d__subclass(c__Osmium,c__ElementalSubstance) ).

fof(miloA4396,axiom,
    p__atomicNumber(c__Osmium,c__76) ).

fof(miloA4397,axiom,
    p__d__subclass(c__Iridium,c__ElementalSubstance) ).

fof(miloA4398,axiom,
    p__atomicNumber(c__Iridium,c__77) ).

fof(miloA4399,axiom,
    p__d__subclass(c__Platinum,c__ElementalSubstance) ).

fof(miloA4400,axiom,
    p__atomicNumber(c__Platinum,c__78) ).

fof(miloA4401,axiom,
    p__d__subclass(c__Gold,c__ElementalSubstance) ).

fof(miloA4402,axiom,
    p__atomicNumber(c__Gold,c__79) ).

fof(miloA4403,axiom,
    p__d__subclass(c__Mercury,c__ElementalSubstance) ).

fof(miloA4404,axiom,
    p__atomicNumber(c__Mercury,c__80) ).

fof(miloA4405,axiom,
    p__d__subclass(c__Thallium,c__ElementalSubstance) ).

fof(miloA4406,axiom,
    p__atomicNumber(c__Thallium,c__81) ).

fof(miloA4407,axiom,
    p__d__subclass(c__Lead,c__ElementalSubstance) ).

fof(miloA4408,axiom,
    p__atomicNumber(c__Lead,c__82) ).

fof(miloA4409,axiom,
    p__d__subclass(c__Bismuth,c__ElementalSubstance) ).

fof(miloA4410,axiom,
    p__atomicNumber(c__Bismuth,c__83) ).

fof(miloA4411,axiom,
    p__d__subclass(c__Polonium,c__ElementalSubstance) ).

fof(miloA4412,axiom,
    p__atomicNumber(c__Polonium,c__84) ).

fof(miloA4413,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Polonium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__210,c__Amu)) ) ).

fof(miloA4414,axiom,
    p__d__subclass(c__Astatine,c__ElementalSubstance) ).

fof(miloA4415,axiom,
    p__atomicNumber(c__Astatine,c__85) ).

fof(miloA4416,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Astatine)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__210,c__Amu)) ) ).

fof(miloA4417,axiom,
    p__d__subclass(c__Radon,c__ElementalSubstance) ).

fof(miloA4418,axiom,
    p__atomicNumber(c__Radon,c__86) ).

fof(miloA4419,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Radon)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__222,c__Amu)) ) ).

fof(miloA4420,axiom,
    p__d__subclass(c__Francium,c__ElementalSubstance) ).

fof(miloA4421,axiom,
    p__atomicNumber(c__Francium,c__87) ).

fof(miloA4422,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Francium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__223,c__Amu)) ) ).

fof(miloA4423,axiom,
    p__d__subclass(c__Radium,c__ElementalSubstance) ).

fof(miloA4424,axiom,
    p__atomicNumber(c__Radium,c__88) ).

fof(miloA4425,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Radium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__226,c__Amu)) ) ).

fof(miloA4426,axiom,
    p__d__subclass(c__Actinium,c__ElementalSubstance) ).

fof(miloA4427,axiom,
    p__atomicNumber(c__Actinium,c__89) ).

fof(miloA4428,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Actinium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__227,c__Amu)) ) ).

fof(miloA4429,axiom,
    p__d__subclass(c__Thorium,c__ElementalSubstance) ).

fof(miloA4430,axiom,
    p__atomicNumber(c__Thorium,c__90) ).

fof(miloA4431,axiom,
    p__d__subclass(c__Protactinium,c__ElementalSubstance) ).

fof(miloA4432,axiom,
    p__atomicNumber(c__Protactinium,c__91) ).

fof(miloA4433,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Protactinium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__231,c__Amu)) ) ).

fof(miloA4434,axiom,
    p__d__subclass(c__Uranium,c__ElementalSubstance) ).

fof(miloA4435,axiom,
    p__atomicNumber(c__Uranium,c__92) ).

fof(miloA4436,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Uranium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__231,c__Amu)) ) ).

fof(miloA4437,axiom,
    p__d__subclass(c__Neptunium,c__ElementalSubstance) ).

fof(miloA4438,axiom,
    p__atomicNumber(c__Neptunium,c__93) ).

fof(miloA4439,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Neptunium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__237,c__Amu)) ) ).

fof(miloA4440,axiom,
    p__d__subclass(c__Plutonium,c__ElementalSubstance) ).

fof(miloA4441,axiom,
    p__atomicNumber(c__Plutonium,c__94) ).

fof(miloA4442,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Plutonium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__242,c__Amu)) ) ).

fof(miloA4443,axiom,
    p__d__subclass(c__Americium,c__ElementalSubstance) ).

fof(miloA4444,axiom,
    p__atomicNumber(c__Americium,c__95) ).

fof(miloA4445,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Americium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__243,c__Amu)) ) ).

fof(miloA4446,axiom,
    p__d__subclass(c__Curium,c__ElementalSubstance) ).

fof(miloA4447,axiom,
    p__atomicNumber(c__Curium,c__96) ).

fof(miloA4448,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Curium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__247,c__Amu)) ) ).

fof(miloA4449,axiom,
    p__d__subclass(c__Berkelium,c__ElementalSubstance) ).

fof(miloA4450,axiom,
    p__atomicNumber(c__Berkelium,c__97) ).

fof(miloA4451,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Berkelium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__247,c__Amu)) ) ).

fof(miloA4452,axiom,
    p__d__subclass(c__Californium,c__ElementalSubstance) ).

fof(miloA4453,axiom,
    p__atomicNumber(c__Californium,c__98) ).

fof(miloA4454,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Californium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__249,c__Amu)) ) ).

fof(miloA4455,axiom,
    p__d__subclass(c__Einsteinium,c__ElementalSubstance) ).

fof(miloA4456,axiom,
    p__atomicNumber(c__Einsteinium,c__99) ).

fof(miloA4457,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Einsteinium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__254,c__Amu)) ) ).

fof(miloA4458,axiom,
    p__d__subclass(c__Fermium,c__ElementalSubstance) ).

fof(miloA4459,axiom,
    p__atomicNumber(c__Fermium,c__100) ).

fof(miloA4460,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Fermium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__253,c__Amu)) ) ).

fof(miloA4461,axiom,
    p__d__subclass(c__Mendelevium,c__ElementalSubstance) ).

fof(miloA4462,axiom,
    p__atomicNumber(c__Mendelevium,c__101) ).

fof(miloA4463,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Mendelevium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__256,c__Amu)) ) ).

fof(miloA4464,axiom,
    p__d__subclass(c__Nobelium,c__ElementalSubstance) ).

fof(miloA4465,axiom,
    p__atomicNumber(c__Nobelium,c__102) ).

fof(miloA4466,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Nobelium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__254,c__Amu)) ) ).

fof(miloA4467,axiom,
    p__d__subclass(c__Lawrencium,c__ElementalSubstance) ).

fof(miloA4468,axiom,
    p__atomicNumber(c__Lawrencium,c__103) ).

fof(miloA4469,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Lawrencium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__262,c__Amu)) ) ).

fof(miloA4470,axiom,
    p__d__subclass(c__Unnilquadium,c__ElementalSubstance) ).

fof(miloA4471,axiom,
    p__atomicNumber(c__Unnilquadium,c__104) ).

fof(miloA4472,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Unnilquadium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__261,c__Amu)) ) ).

fof(miloA4473,axiom,
    p__d__subclass(c__Unnilpentium,c__ElementalSubstance) ).

fof(miloA4474,axiom,
    p__atomicNumber(c__Unnilpentium,c__105) ).

fof(miloA4475,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Unnilpentium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__262,c__Amu)) ) ).

fof(miloA4476,axiom,
    p__d__subclass(c__Unnilhexium,c__ElementalSubstance) ).

fof(miloA4477,axiom,
    p__atomicNumber(c__Unnilhexium,c__106) ).

fof(miloA4478,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Unnilhexium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__263,c__Amu)) ) ).

fof(miloA4479,axiom,
    p__d__subclass(c__Unnilseptium,c__ElementalSubstance) ).

fof(miloA4480,axiom,
    p__atomicNumber(c__Unnilseptium,c__107) ).

fof(miloA4481,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Unnilseptium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__262,c__Amu)) ) ).

fof(miloA4482,axiom,
    p__d__subclass(c__Unniloctium,c__ElementalSubstance) ).

fof(miloA4483,axiom,
    p__atomicNumber(c__Unniloctium,c__108) ).

fof(miloA4484,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Unniloctium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__265,c__Amu)) ) ).

fof(miloA4485,axiom,
    p__d__subclass(c__Meitnerium,c__ElementalSubstance) ).

fof(miloA4486,axiom,
    p__atomicNumber(c__Meitnerium,c__109) ).

fof(miloA4487,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Meitnerium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__266,c__Amu)) ) ).

fof(miloA4488,axiom,
    p__d__subclass(c__Unnildecium,c__ElementalSubstance) ).

fof(miloA4489,axiom,
    p__atomicNumber(c__Unnildecium,c__110) ).

fof(miloA4490,axiom,
    ! [ATOM] :
      ( ( p__d__instance(ATOM,c__Unnildecium)
        & p__d__instance(ATOM,c__Atom) )
     => p__measure(ATOM,f__MeasureFn2(c__272,c__Amu)) ) ).

fof(miloA4633,axiom,
    p__d__subclass(c__VehicleDoor,c__Device) ).

fof(miloA4639,axiom,
    p__d__instance(c__DeviceNormal,c__InternalAttribute) ).

fof(miloA4640,axiom,
    ! [D,F] :
      ( ( p__d__instance(D,c__Object)
        & p__d__instance(F,c__Formula)
        & p__attribute(D,c__DeviceNormal)
        & p__hasPurpose(D,F) )
     => p__modalAttribute(F,c__Possibility) ) ).

fof(miloA4641,axiom,
    p__d__instance(c__DeviceDamaged,c__InternalAttribute) ).

fof(miloA4642,axiom,
    p__contraryAttribute2(c__DeviceDamaged,c__DeviceNormal) ).

fof(miloA4643,axiom,
    ! [D,F] :
      ( ( p__d__instance(D,c__Object)
        & p__d__instance(F,c__Formula)
        & p__attribute(D,c__DeviceDamaged)
        & p__hasPurpose(D,F) )
     => ~ p__modalAttribute(F,c__Possibility) ) ).

fof(miloA4644,axiom,
    p__d__subclass(c__Vending,c__FinancialTransaction) ).

fof(miloA4645,axiom,
    ! [V] :
      ( p__d__instance(V,c__Vending)
     => ? [VM] :
          ( p__d__instance(VM,c__VendingMachine)
          & p__origin(V,VM) ) ) ).

fof(miloA4646,axiom,
    p__d__subclass(c__VendingMachine,c__Machine) ).

fof(miloA4649,axiom,
    p__d__instance(c__CoinOperated,c__Attribute) ).

fof(miloA4650,axiom,
    ! [M] :
      ( ( p__d__instance(M,c__Object)
        & p__attribute(M,c__CoinOperated) )
     => p__d__instance(M,c__Machine) ) ).

fof(miloA4652,axiom,
    p__d__subclass(c__FishTank,c__FluidContainer) ).

fof(miloA4654,axiom,
    p__d__instance(c__Collectible,c__RelationalAttribute) ).

fof(miloA4656,axiom,
    p__d__subclass(c__TradingCard,c__Icon) ).

fof(miloA4657,axiom,
    ! [TC] :
      ( ( p__d__instance(TC,c__Object)
        & p__d__instance(TC,c__TradingCard) )
     => p__attribute(TC,c__Collectible) ) ).

fof(miloA4666,axiom,
    p__d__subclass(c__SmartPhone,c__MobileCellPhone) ).

fof(miloA4668,axiom,
    p__d__instance(c__suffers,c__CaseRole) ).

fof(miloA4669,axiom,
    p__d__instance(c__suffers,c__BinaryRelation) ).

fof(miloA4672,axiom,
    ! [A,B] :
      ( ( p__d__instance(B,c__Agent)
        & p__d__instance(A,c__Process)
        & p__suffers(A,B) )
     => ~ p__benefits(A,B) ) ).

fof(miloA4673,axiom,
    ! [A,B] :
      ( ( p__d__instance(B,c__Agent)
        & p__d__instance(A,c__Process)
        & p__benefits(A,B) )
     => ~ p__suffers(A,B) ) ).

fof(miloA4674,axiom,
    ! [PROCESS,AGENT,PROCESSSTART,AGENTEND] :
      ( ( p__d__instance(PROCESS,c__Process)
        & p__d__instance(PROCESSSTART,c__TimePoint)
        & p__d__instance(AGENT,c__Agent)
        & p__d__instance(AGENTEND,c__TimePoint)
        & PROCESSSTART = f__BeginFn1(f__WhenFn1(PROCESS))
        & AGENTEND = f__EndFn1(f__WhenFn1(AGENT))
        & p__suffers(PROCESS,AGENT) )
     => p__before(PROCESSSTART,AGENTEND) ) ).

fof(miloA4675,axiom,
    ! [B,A] :
      ( ( p__d__instance(B,c__CognitiveAgent)
        & p__d__instance(A,c__Process)
        & p__benefits(A,B) )
     => p__wants(B,A) ) ).

fof(miloA4676,axiom,
    ! [B,A] :
      ( ( p__d__instance(B,c__CognitiveAgent)
        & p__d__instance(A,c__Process)
        & p__suffers(A,B) )
     => ~ p__wants(B,A) ) ).

fof(miloA4677,axiom,
    p__d__subclass(c__Apologizing,c__Stating) ).

fof(miloA4679,axiom,
    p__d__subclass(c__Confirming,c__Stating) ).

fof(miloA4681,axiom,
    p__d__subclass(c__Elaborating,c__LinguisticCommunication) ).

fof(miloA4682,axiom,
    p__d__subclass(c__Restating,c__LinguisticCommunication) ).

fof(miloA4683,axiom,
    p__d__subclass(c__Correcting,c__Stating) ).

fof(miloA4684,axiom,
    ! [C,CS] :
      ( ( p__d__instance(CS,c__Proposition)
        & p__d__instance(C,c__Correcting) )
     => ? [D,S,SP,CP] :
          ( p__d__instance(SP,c__Proposition)
          & p__d__instance(CP,c__Proposition)
          & p__d__instance(D,c__Disagreeing)
          & p__subProcess(C,D)
          & p__d__instance(S,c__Stating)
          & p__containsInformation(S,SP)
          & p__containsInformation(C,CP)
          & p__refers(CP,SP)
          & ~ p__consistent(CS,SP) ) ) ).

fof(miloA4685,axiom,
    p__d__subclass(c__Prompting,c__Requesting) ).

fof(miloA4687,axiom,
    p__d__instance(c__CoveringFn,c__UnaryFunction) ).

fof(miloA4691,axiom,
    p__d__instance(c__covers,c__BinaryPredicate) ).

fof(miloA4692,axiom,
    p__d__instance(c__covers,c__TransitiveRelation) ).

fof(miloA4693,axiom,
    p__d__instance(c__covers,c__SpatialRelation) ).

fof(miloA4696,axiom,
    ! [B,A,S] :
      ( ( p__d__instance(B,c__Object)
        & p__d__instance(A,c__Object)
        & p__d__instance(S,c__Object)
        & p__covers(A,B)
        & p__superficialPart(S,B) )
     => p__meetsSpatially(A,S) ) ).

fof(miloA4702,axiom,
    p__d__instance(c__beforeOnPath,c__QuaternaryPredicate) ).

fof(miloA4703,axiom,
    p__d__instance(c__beforeOnPath,c__SpatialRelation) ).

fof(miloA4704,axiom,
    ! [O1,O2,O3,PATH,T] :
      ( ( p__d__instance(PATH,c__Object)
        & p__d__instance(O3,c__Object)
        & p__d__instance(O2,c__Object)
        & p__d__instance(O1,c__Object)
        & p__betweenOnPath(O1,O2,O3,PATH)
        & p__d__instance(T,c__Transfer)
        & p__path(T,PATH)
        & p__origin(T,O1)
        & p__destination(T,O3) )
     => ( p__beforeOnPath(O1,O2,PATH,T)
        & p__beforeOnPath(O2,O3,PATH,T) ) ) ).

fof(miloA4709,axiom,
    p__d__instance(c__approximateValue,c__BinaryPredicate) ).

fof(schemaBinaryRelationA1,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__SetOrClass) )
     => ( p__d__holds3(c__subclass,VAR1,VAR2)
      <=> p__subclass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA2,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Relation)
        & p__d__instance(VAR1,c__Relation) )
     => ( p__d__holds3(c__subrelation,VAR1,VAR2)
      <=> p__subrelation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA3,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Attribute)
        & p__d__instance(VAR1,c__Attribute) )
     => ( p__d__holds3(c__subAttribute,VAR1,VAR2)
      <=> p__subAttribute(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA4,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__part,VAR1,VAR2)
      <=> p__part(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA5,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Collection)
        & p__d__instance(VAR1,c__Collection) )
     => ( p__d__holds3(c__subCollection,VAR1,VAR2)
      <=> p__subCollection(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA6,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds3(c__lessThanOrEqualTo,VAR1,VAR2)
      <=> p__lessThanOrEqualTo(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA7,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds3(c__greaterThanOrEqualTo,VAR1,VAR2)
      <=> p__greaterThanOrEqualTo(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA8,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__List)
        & p__d__instance(VAR1,c__List) )
     => ( p__d__holds3(c__subList,VAR1,VAR2)
      <=> p__subList(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA9,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__List)
        & p__d__instance(VAR1,c__List) )
     => ( p__d__holds3(c__initialList,VAR1,VAR2)
      <=> p__initialList(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA10,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__ContentBearingPhysical)
        & p__d__subclass(VAR1,c__ContentBearingPhysical) )
     => ( p__d__holds3(c__subsumesContentClass,VAR1,VAR2)
      <=> p__subsumesContentClass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA11,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__ContentBearingPhysical)
        & p__d__instance(VAR1,c__ContentBearingPhysical) )
     => ( p__d__holds3(c__subsumesContentInstance,VAR1,VAR2)
      <=> p__subsumesContentInstance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA12,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimePosition)
        & p__d__instance(VAR1,c__TimePosition) )
     => ( p__d__holds3(c__temporalPart,VAR1,VAR2)
      <=> p__temporalPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA13,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__TimePoint) )
     => ( p__d__holds3(c__beforeOrEqual,VAR1,VAR2)
      <=> p__beforeOrEqual(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA14,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Process)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__subProcess,VAR1,VAR2)
      <=> p__subProcess(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA15,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organization)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__subOrganization,VAR1,VAR2)
      <=> p__subOrganization(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA16,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeometricFigure)
        & p__d__instance(VAR1,c__GeometricFigure) )
     => ( p__d__holds3(c__geometricPart,VAR1,VAR2)
      <=> p__geometricPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA17,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Abstract)
        & p__d__instance(VAR1,c__Abstract) )
     => ( p__d__holds3(c__abstractPart,VAR1,VAR2)
      <=> p__abstractPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA18,axiom,
    ! [VAR1,VAR2] :
      ( p__d__holds3(c__equal,VAR1,VAR2)
    <=> VAR1 = VAR2 ) ).

fof(schemaBinaryRelationA19,axiom,
    ! [VAR1,VAR2] :
      ( p__d__holds3(c__relatedInternalConcept,VAR1,VAR2)
    <=> p__relatedInternalConcept(VAR1,VAR2) ) ).

fof(schemaBinaryRelationA20,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__List)
        & p__d__instance(VAR1,c__List) )
     => ( p__d__holds3(c__identicalListItems,VAR1,VAR2)
      <=> p__identicalListItems(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA21,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__copy,VAR1,VAR2)
      <=> p__copy(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA22,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__ContentBearingPhysical)
        & p__d__subclass(VAR1,c__ContentBearingPhysical) )
     => ( p__d__holds3(c__equivalentContentClass,VAR1,VAR2)
      <=> p__equivalentContentClass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA23,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__ContentBearingPhysical)
        & p__d__instance(VAR1,c__ContentBearingPhysical) )
     => ( p__d__holds3(c__equivalentContentInstance,VAR1,VAR2)
      <=> p__equivalentContentInstance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA24,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__cooccur,VAR1,VAR2)
      <=> p__cooccur(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA25,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__familyRelation,VAR1,VAR2)
      <=> p__familyRelation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA26,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Graph)
        & p__d__instance(VAR1,c__Graph) )
     => ( p__d__holds3(c__subGraph,VAR1,VAR2)
      <=> p__subGraph(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA27,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds3(c__overlapsTemporally,VAR1,VAR2)
      <=> p__overlapsTemporally(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA28,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__connected,VAR1,VAR2)
      <=> p__connected(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA29,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__overlapsSpatially,VAR1,VAR2)
      <=> p__overlapsSpatially(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA30,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SymbolicString)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__subString,VAR1,VAR2)
      <=> p__subString(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA31,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__agent,VAR1,VAR2)
      <=> p__agent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA32,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Process)
     => ( p__d__holds3(c__destination,VAR1,VAR2)
      <=> p__destination(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA33,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__experiencer,VAR1,VAR2)
      <=> p__experiencer(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA34,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__origin,VAR1,VAR2)
      <=> p__origin(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA35,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Process)
     => ( p__d__holds3(c__patient,VAR1,VAR2)
      <=> p__patient(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA36,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__eventPartlyLocated,VAR1,VAR2)
      <=> p__eventPartlyLocated(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA37,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Motion) )
     => ( p__d__holds3(c__moves,VAR1,VAR2)
      <=> p__moves(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA38,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Translocation) )
     => ( p__d__holds3(c__changesLocation,VAR1,VAR2)
      <=> p__changesLocation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA39,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Motion) )
     => ( p__d__holds3(c__path,VAR1,VAR2)
      <=> p__path(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA40,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PositionalAttribute)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__direction,VAR1,VAR2)
      <=> p__direction(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA41,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Animal)
        & p__d__instance(VAR1,c__Confining) )
     => ( p__d__holds3(c__detainee,VAR1,VAR2)
      <=> p__detainee(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA42,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__targetInAttack,VAR1,VAR2)
      <=> p__targetInAttack(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA43,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Experimenting) )
     => ( p__d__holds3(c__experimentalControl,VAR1,VAR2)
      <=> p__experimentalControl(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA44,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__AchievingControl) )
     => ( p__d__holds3(c__controlled,VAR1,VAR2)
      <=> p__controlled(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA45,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__AchievingControl) )
     => ( p__d__holds3(c__gainsControl,VAR1,VAR2)
      <=> p__gainsControl(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA46,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__ChangeOfControl) )
     => ( p__d__holds3(c__losesControl,VAR1,VAR2)
      <=> p__losesControl(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA47,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__PlacingUnderArrest) )
     => ( p__d__holds3(c__arrested,VAR1,VAR2)
      <=> p__arrested(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA48,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TransportationDevice)
        & p__d__instance(VAR1,c__Transportation) )
     => ( p__d__holds3(c__conveyance,VAR1,VAR2)
      <=> p__conveyance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA49,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__suffers,VAR1,VAR2)
      <=> p__suffers(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA50,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__desires,VAR1,VAR2)
      <=> p__desires(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA51,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__considers,VAR1,VAR2)
      <=> p__considers(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA52,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__believes,VAR1,VAR2)
      <=> p__believes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA53,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__knows,VAR1,VAR2)
      <=> p__knows(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA54,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__doubts,VAR1,VAR2)
      <=> p__doubts(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA55,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__disapproves,VAR1,VAR2)
      <=> p__disapproves(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA56,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR2,c__SetOrClass)
     => ( p__d__holds3(c__immediateInstance,VAR1,VAR2)
      <=> p__immediateInstance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA57,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__SetOrClass) )
     => ( p__d__holds3(c__immediateSubclass,VAR1,VAR2)
      <=> p__immediateSubclass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA58,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__Function) )
     => ( p__d__holds3(c__range,VAR1,VAR2)
      <=> p__range(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA59,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__Function) )
     => ( p__d__holds3(c__rangeSubclass,VAR1,VAR2)
      <=> p__rangeSubclass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA60,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__Relation) )
     => ( p__d__holds3(c__valence,VAR1,VAR2)
      <=> p__valence(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA61,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Attribute)
        & p__d__instance(VAR1,c__Attribute) )
     => ( p__d__holds3(c__successorAttribute,VAR1,VAR2)
      <=> p__successorAttribute(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA62,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SelfConnectedObject)
     => ( p__d__holds3(c__FrontFn,VAR1,VAR2)
      <=> p__FrontFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA63,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SelfConnectedObject)
     => ( p__d__holds3(c__BackFn,VAR1,VAR2)
      <=> p__BackFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA64,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__properPart,VAR1,VAR2)
      <=> p__properPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA65,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__contains,VAR1,VAR2)
      <=> p__contains(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA66,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Collection)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__member,VAR1,VAR2)
      <=> p__member(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA67,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Proposition)
        & p__d__instance(VAR1,c__ContentBearingPhysical) )
     => ( p__d__holds3(c__containsInformation,VAR1,VAR2)
      <=> p__containsInformation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA68,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__leader,VAR1,VAR2)
      <=> p__leader(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA69,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Attribute)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__attribute,VAR1,VAR2)
      <=> p__attribute(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA70,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Attribute)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__manner,VAR1,VAR2)
      <=> p__manner(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA71,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Process)
     => ( p__d__holds3(c__involvedInEvent,VAR1,VAR2)
      <=> p__involvedInEvent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA72,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Formula)
     => ( p__d__holds3(c__ProbabilityFn,VAR1,VAR2)
      <=> p__ProbabilityFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA73,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR2,c__List)
     => ( p__d__holds3(c__inList,VAR1,VAR2)
      <=> p__inList(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA74,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__Function) )
     => ( p__d__holds3(c__closedOn,VAR1,VAR2)
      <=> p__closedOn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA75,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__BinaryRelation) )
     => ( p__d__holds3(c__reflexiveOn,VAR1,VAR2)
      <=> p__reflexiveOn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA76,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__BinaryRelation) )
     => ( p__d__holds3(c__irreflexiveOn,VAR1,VAR2)
      <=> p__irreflexiveOn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA77,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__BinaryRelation) )
     => ( p__d__holds3(c__partialOrderingOn,VAR1,VAR2)
      <=> p__partialOrderingOn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA78,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__BinaryRelation) )
     => ( p__d__holds3(c__totalOrderingOn,VAR1,VAR2)
      <=> p__totalOrderingOn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA79,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__BinaryRelation) )
     => ( p__d__holds3(c__trichotomizingOn,VAR1,VAR2)
      <=> p__trichotomizingOn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA80,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__BinaryRelation) )
     => ( p__d__holds3(c__equivalenceRelationOn,VAR1,VAR2)
      <=> p__equivalenceRelationOn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA81,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Process)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__causes,VAR1,VAR2)
      <=> p__causes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA82,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Process)
        & p__d__subclass(VAR1,c__Process) )
     => ( p__d__holds3(c__causesSubclass,VAR1,VAR2)
      <=> p__causesSubclass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA83,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__causesProposition,VAR1,VAR2)
      <=> p__causesProposition(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA84,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimePosition)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__time,VAR1,VAR2)
      <=> p__time(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA85,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__TimePosition) )
     => ( p__d__holds3(c__holdsDuring,VAR1,VAR2)
      <=> p__holdsDuring(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA86,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__exploits,VAR1,VAR2)
      <=> p__exploits(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA87,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__hasPurpose,VAR1,VAR2)
      <=> p__hasPurpose(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA88,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__subclass(VAR1,c__Process) )
     => ( p__d__holds3(c__hasSkill,VAR1,VAR2)
      <=> p__hasSkill(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA89,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__crosses,VAR1,VAR2)
      <=> p__crosses(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA90,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__penetrates,VAR1,VAR2)
      <=> p__penetrates(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA91,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__possesses,VAR1,VAR2)
      <=> p__possesses(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA92,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Process)
        & p__d__subclass(VAR1,c__Process) )
     => ( p__d__holds3(c__precondition,VAR1,VAR2)
      <=> p__precondition(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA93,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Proposition)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__realization,VAR1,VAR2)
      <=> p__realization(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA94,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Language)
        & p__d__instance(VAR1,c__LinguisticExpression) )
     => ( p__d__holds3(c__expressedInLanguage,VAR1,VAR2)
      <=> p__expressedInLanguage(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA95,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__uses,VAR1,VAR2)
      <=> p__uses(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA96,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__BinaryFunction)
     => ( p__d__holds3(c__identityElement,VAR1,VAR2)
      <=> p__identityElement(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA97,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR2,c__Set)
     => ( p__d__holds3(c__element,VAR1,VAR2)
      <=> p__element(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA98,axiom,
    ! [VAR1,VAR2] :
      ( p__d__holds3(c__CardinalityFn,VAR1,VAR2)
    <=> p__CardinalityFn(VAR1,VAR2) ) ).

fof(schemaBinaryRelationA99,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Graph)
        & p__d__instance(VAR1,c__GraphElement) )
     => ( p__d__holds3(c__graphPart,VAR1,VAR2)
      <=> p__graphPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA100,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__GraphPath) )
     => ( p__d__holds3(c__pathLength,VAR1,VAR2)
      <=> p__pathLength(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA101,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PhysicalQuantity)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__measure,VAR1,VAR2)
      <=> p__measure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA102,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__UnitOfAtmosphericPressure)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__barometricPressure,VAR1,VAR2)
      <=> p__barometricPressure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA103,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeDuration)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds3(c__duration,VAR1,VAR2)
      <=> p__duration(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA104,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeDuration)
        & p__d__subclass(VAR1,c__Process) )
     => ( p__d__holds3(c__frequency,VAR1,VAR2)
      <=> p__frequency(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA105,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds3(c__meetsTemporally,VAR1,VAR2)
      <=> p__meetsTemporally(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA106,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Day)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__date,VAR1,VAR2)
      <=> p__date(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA107,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SelfConnectedObject)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__surface,VAR1,VAR2)
      <=> p__surface(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA108,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__interiorPart,VAR1,VAR2)
      <=> p__interiorPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA109,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SelfConnectedObject)
        & p__d__instance(VAR1,c__Hole) )
     => ( p__d__holds3(c__hole,VAR1,VAR2)
      <=> p__hole(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA110,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Hole)
     => ( p__d__holds3(c__HoleHostFn,VAR1,VAR2)
      <=> p__HoleHostFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA111,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Hole)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__partiallyFills,VAR1,VAR2)
      <=> p__partiallyFills(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA112,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Hole)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__properlyFills,VAR1,VAR2)
      <=> p__properlyFills(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA113,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Hole)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__completelyFills,VAR1,VAR2)
      <=> p__completelyFills(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA114,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Hole)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__fills,VAR1,VAR2)
      <=> p__fills(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA115,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Hole)
     => ( p__d__holds3(c__HoleSkinFn,VAR1,VAR2)
      <=> p__HoleSkinFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA116,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__subclass(VAR1,c__ElementalSubstance) )
     => ( p__d__holds3(c__atomicNumber,VAR1,VAR2)
      <=> p__atomicNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA117,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeographicArea)
        & p__d__instance(VAR1,c__GeographicArea) )
     => ( p__d__holds3(c__geographicSubregion,VAR1,VAR2)
      <=> p__geographicSubregion(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA118,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeopoliticalArea)
        & p__d__instance(VAR1,c__GeopoliticalArea) )
     => ( p__d__holds3(c__geopoliticalSubdivision,VAR1,VAR2)
      <=> p__geopoliticalSubdivision(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA119,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__DevelopmentalAttribute)
        & p__d__instance(VAR1,c__OrganicObject) )
     => ( p__d__holds3(c__developmentalForm,VAR1,VAR2)
      <=> p__developmentalForm(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA120,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__inhabits,VAR1,VAR2)
      <=> p__inhabits(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA121,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Text)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__authors,VAR1,VAR2)
      <=> p__authors(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA122,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Text)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__editor,VAR1,VAR2)
      <=> p__editor(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA123,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Text)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__publishes,VAR1,VAR2)
      <=> p__publishes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA124,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Artifact)
        & p__d__subclass(VAR1,c__Artifact) )
     => ( p__d__holds3(c__version,VAR1,VAR2)
      <=> p__version(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA125,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__parent,VAR1,VAR2)
      <=> p__parent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA126,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Woman)
        & p__d__instance(VAR1,c__Man) )
     => ( p__d__holds3(c__husband,VAR1,VAR2)
      <=> p__husband(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA127,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Man)
        & p__d__instance(VAR1,c__Woman) )
     => ( p__d__holds3(c__wife,VAR1,VAR2)
      <=> p__wife(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA128,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Nation)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__citizen,VAR1,VAR2)
      <=> p__citizen(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA129,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__NormativeAttribute)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__modalAttribute,VAR1,VAR2)
      <=> p__modalAttribute(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA130,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__holdsRight,VAR1,VAR2)
      <=> p__holdsRight(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA131,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__holdsObligation,VAR1,VAR2)
      <=> p__holdsObligation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA132,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Integer)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__yearOfFounding,VAR1,VAR2)
      <=> p__yearOfFounding(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA133,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Artifact)
        & p__d__instance(VAR1,c__Device) )
     => ( p__d__holds3(c__powerPlant,VAR1,VAR2)
      <=> p__powerPlant(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA134,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organization)
        & p__d__instance(VAR1,c__Proposition) )
     => ( p__d__holds3(c__insured,VAR1,VAR2)
      <=> p__insured(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA135,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CurrencyMeasure)
        & p__d__instance(VAR1,c__FinancialTransaction) )
     => ( p__d__holds3(c__loss,VAR1,VAR2)
      <=> p__loss(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA136,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CurrencyMeasure)
        & p__d__instance(VAR1,c__FinancialTransaction) )
     => ( p__d__holds3(c__profit,VAR1,VAR2)
      <=> p__profit(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA137,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__customer,VAR1,VAR2)
      <=> p__customer(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA138,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__familyName,VAR1,VAR2)
      <=> p__familyName(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA139,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__middleName,VAR1,VAR2)
      <=> p__middleName(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA140,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__givenName,VAR1,VAR2)
      <=> p__givenName(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA141,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__StructureAttribute)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__structure,VAR1,VAR2)
      <=> p__structure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA142,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__operator,VAR1,VAR2)
      <=> p__operator(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA143,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Transportation) )
     => ( p__d__holds3(c__transported,VAR1,VAR2)
      <=> p__transported(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA144,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Shipping) )
     => ( p__d__holds3(c__cargo,VAR1,VAR2)
      <=> p__cargo(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA145,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__ServiceProcess) )
     => ( p__d__holds3(c__serviceProvider,VAR1,VAR2)
      <=> p__serviceProvider(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA146,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__ServiceProcess) )
     => ( p__d__holds3(c__serviceRecipient,VAR1,VAR2)
      <=> p__serviceRecipient(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA147,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__benefits,VAR1,VAR2)
      <=> p__benefits(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA148,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__grandparent,VAR1,VAR2)
      <=> p__grandparent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA149,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__alias,VAR1,VAR2)
      <=> p__alias(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA150,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PostalPlace)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__workAddress,VAR1,VAR2)
      <=> p__workAddress(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA151,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__PermanentResidence) )
     => ( p__d__holds3(c__homeAddress,VAR1,VAR2)
      <=> p__homeAddress(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA152,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__ContentBearingObject) )
     => ( p__d__holds3(c__deceptiveIdentifier,VAR1,VAR2)
      <=> p__deceptiveIdentifier(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA153,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SymbolicString)
        & p__d__instance(VAR1,c__NonnegativeInteger) )
     => ( p__d__holds3(c__stringLength,VAR1,VAR2)
      <=> p__stringLength(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA154,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__ContactSite) )
     => ( p__d__holds3(c__siteForContact,VAR1,VAR2)
      <=> p__siteForContact(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA155,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__PostalPlace) )
     => ( p__d__holds3(c__postContactSite,VAR1,VAR2)
      <=> p__postContactSite(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA156,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Neighborhood)
        & p__d__instance(VAR1,c__PostalPlace) )
     => ( p__d__holds3(c__postNeighborhood,VAR1,VAR2)
      <=> p__postNeighborhood(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA157,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeopoliticalArea)
        & p__d__instance(VAR1,c__PostalPlace) )
     => ( p__d__holds3(c__postCountry,VAR1,VAR2)
      <=> p__postCountry(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA158,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__StateOrProvince)
        & p__d__instance(VAR1,c__PostalPlace) )
     => ( p__d__holds3(c__postDistrict,VAR1,VAR2)
      <=> p__postDistrict(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA159,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__City)
        & p__d__instance(VAR1,c__PostalPlace) )
     => ( p__d__holds3(c__postCity,VAR1,VAR2)
      <=> p__postCity(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA160,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PostcodeArea)
        & p__d__instance(VAR1,c__PostalPlace) )
     => ( p__d__holds3(c__postPostcodeArea,VAR1,VAR2)
      <=> p__postPostcodeArea(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA161,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Roadway)
        & p__d__instance(VAR1,c__PostalPlace) )
     => ( p__d__holds3(c__postStreet,VAR1,VAR2)
      <=> p__postStreet(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA162,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PostalPlace)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__postStreetNumber,VAR1,VAR2)
      <=> p__postStreetNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA163,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PostalPlace)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__postPostOfficeBox,VAR1,VAR2)
      <=> p__postPostOfficeBox(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA164,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PostalPlace)
        & p__d__instance(VAR1,c__PostalAddressText) )
     => ( p__d__holds3(c__postAddressText,VAR1,VAR2)
      <=> p__postAddressText(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA165,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__TelephonyDevice) )
     => ( p__d__holds3(c__telecomContactDevice,VAR1,VAR2)
      <=> p__telecomContactDevice(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA166,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TelephonyDevice)
        & p__d__instance(VAR1,c__TelecomNumber) )
     => ( p__d__holds3(c__deviceTelecomNumber,VAR1,VAR2)
      <=> p__deviceTelecomNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA167,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TelecomNumber)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__telecomCoreNumber,VAR1,VAR2)
      <=> p__telecomCoreNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA168,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TelecomNumber)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__telecomCountryCode,VAR1,VAR2)
      <=> p__telecomCountryCode(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA169,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TelecomNumber)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__telecomAreaCode,VAR1,VAR2)
      <=> p__telecomAreaCode(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA170,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TelecomNumber)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__telecomCode2,VAR1,VAR2)
      <=> p__telecomCode2(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA171,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TelecomNumber)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__telecomExtension,VAR1,VAR2)
      <=> p__telecomExtension(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA172,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__TelecomNumber) )
     => ( p__d__holds3(c__telephoneNumber,VAR1,VAR2)
      <=> p__telephoneNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA173,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__TelecomNumber) )
     => ( p__d__holds3(c__personalPhoneNumber,VAR1,VAR2)
      <=> p__personalPhoneNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA174,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__TelecomNumber) )
     => ( p__d__holds3(c__homePhoneNumber,VAR1,VAR2)
      <=> p__homePhoneNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA175,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__TelecomNumber) )
     => ( p__d__holds3(c__workPhoneNumber,VAR1,VAR2)
      <=> p__workPhoneNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA176,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__TelecomNumber) )
     => ( p__d__holds3(c__mobilePhoneNumber,VAR1,VAR2)
      <=> p__mobilePhoneNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA177,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__TelecomNumber) )
     => ( p__d__holds3(c__faxNumber,VAR1,VAR2)
      <=> p__faxNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA178,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__BinaryRelation)
        & p__d__instance(VAR1,c__BinaryRelation) )
     => ( p__d__holds3(c__inverse,VAR1,VAR2)
      <=> p__inverse(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA179,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Relation)
        & p__d__instance(VAR1,c__Relation) )
     => ( p__d__holds3(c__disjointRelation,VAR1,VAR2)
      <=> p__disjointRelation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA180,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Attribute)
        & p__d__instance(VAR1,c__Attribute) )
     => ( p__d__holds3(c__successorAttributeClosure,VAR1,VAR2)
      <=> p__successorAttributeClosure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA181,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds3(c__lessThan,VAR1,VAR2)
      <=> p__lessThan(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA182,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds3(c__greaterThan,VAR1,VAR2)
      <=> p__greaterThan(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA183,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__increasesLikelihood,VAR1,VAR2)
      <=> p__increasesLikelihood(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA184,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__decreasesLikelihood,VAR1,VAR2)
      <=> p__decreasesLikelihood(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA185,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Process)
        & p__d__subclass(VAR1,c__Process) )
     => ( p__d__holds3(c__hindersSubclass,VAR1,VAR2)
      <=> p__hindersSubclass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA186,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Process)
        & p__d__subclass(VAR1,c__Process) )
     => ( p__d__holds3(c__preventsSubclass,VAR1,VAR2)
      <=> p__preventsSubclass(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA187,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Process)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__prevents,VAR1,VAR2)
      <=> p__prevents(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA188,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Process)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__hinders,VAR1,VAR2)
      <=> p__hinders(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA189,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Proposition)
        & p__d__instance(VAR1,c__Proposition) )
     => ( p__d__holds3(c__subProposition,VAR1,VAR2)
      <=> p__subProposition(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA190,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Plan)
        & p__d__instance(VAR1,c__Plan) )
     => ( p__d__holds3(c__subPlan,VAR1,VAR2)
      <=> p__subPlan(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA191,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__larger,VAR1,VAR2)
      <=> p__larger(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA192,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__smaller,VAR1,VAR2)
      <=> p__smaller(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA193,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds3(c__starts,VAR1,VAR2)
      <=> p__starts(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA194,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds3(c__finishes,VAR1,VAR2)
      <=> p__finishes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA195,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__TimePoint) )
     => ( p__d__holds3(c__before,VAR1,VAR2)
      <=> p__before(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA196,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds3(c__during,VAR1,VAR2)
      <=> p__during(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA197,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds3(c__earlier,VAR1,VAR2)
      <=> p__earlier(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA198,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__meetsSpatially,VAR1,VAR2)
      <=> p__meetsSpatially(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA199,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__overlapsPartially,VAR1,VAR2)
      <=> p__overlapsPartially(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA200,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__superficialPart,VAR1,VAR2)
      <=> p__superficialPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA201,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__EngineeringComponent)
        & p__d__instance(VAR1,c__EngineeringComponent) )
     => ( p__d__holds3(c__connectedEngineeringComponents,VAR1,VAR2)
      <=> p__connectedEngineeringComponents(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA202,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__ancestor,VAR1,VAR2)
      <=> p__ancestor(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA203,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__sibling,VAR1,VAR2)
      <=> p__sibling(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA204,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Man) )
     => ( p__d__holds3(c__brother,VAR1,VAR2)
      <=> p__brother(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA205,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Woman) )
     => ( p__d__holds3(c__sister,VAR1,VAR2)
      <=> p__sister(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA206,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__spouse,VAR1,VAR2)
      <=> p__spouse(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA207,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CompoundSubstance)
        & p__d__instance(VAR1,c__CompoundSubstance) )
     => ( p__d__holds3(c__conjugate,VAR1,VAR2)
      <=> p__conjugate(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA208,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__neighbor,VAR1,VAR2)
      <=> p__neighbor(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA209,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__MilitaryUnit)
        & p__d__instance(VAR1,c__MilitaryUnit) )
     => ( p__d__holds3(c__hostileForces,VAR1,VAR2)
      <=> p__hostileForces(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA210,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__FieldOfStudy)
        & p__d__instance(VAR1,c__FieldOfStudy) )
     => ( p__d__holds3(c__subField,VAR1,VAR2)
      <=> p__subField(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA211,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organization)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__ancestorOrganization,VAR1,VAR2)
      <=> p__ancestorOrganization(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA212,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__SetOrClass) )
     => ( p__d__holds3(c__disjoint,VAR1,VAR2)
      <=> p__disjoint(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA213,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__independentProbability,VAR1,VAR2)
      <=> p__independentProbability(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA214,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Process)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__relatedEvent,VAR1,VAR2)
      <=> p__relatedEvent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA215,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__relative,VAR1,VAR2)
      <=> p__relative(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA216,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__legalRelation,VAR1,VAR2)
      <=> p__legalRelation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA217,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__mutualAcquaintance,VAR1,VAR2)
      <=> p__mutualAcquaintance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA218,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Proposition)
        & p__d__instance(VAR1,c__Proposition) )
     => ( p__d__holds3(c__consistent,VAR1,VAR2)
      <=> p__consistent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA219,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__friend,VAR1,VAR2)
      <=> p__friend(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA220,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__coworker,VAR1,VAR2)
      <=> p__coworker(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA221,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__cohabitant,VAR1,VAR2)
      <=> p__cohabitant(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA222,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__mutualStranger,VAR1,VAR2)
      <=> p__mutualStranger(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA223,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__domesticPartner,VAR1,VAR2)
      <=> p__domesticPartner(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA224,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__located,VAR1,VAR2)
      <=> p__located(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA225,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__DataStorageDevice)
        & p__d__instance(VAR1,c__ContentBearingObject) )
     => ( p__d__holds3(c__stored,VAR1,VAR2)
      <=> p__stored(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA226,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__legalGuardian,VAR1,VAR2)
      <=> p__legalGuardian(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA227,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Integer)
        & p__d__instance(VAR1,c__Integer) )
     => ( p__d__holds3(c__multiplicativeFactor,VAR1,VAR2)
      <=> p__multiplicativeFactor(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA228,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__covers,VAR1,VAR2)
      <=> p__covers(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA229,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__KiloFn,VAR1,VAR2)
      <=> p__KiloFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA230,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__MegaFn,VAR1,VAR2)
      <=> p__MegaFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA231,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__GigaFn,VAR1,VAR2)
      <=> p__GigaFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA232,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__TeraFn,VAR1,VAR2)
      <=> p__TeraFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA233,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__MilliFn,VAR1,VAR2)
      <=> p__MilliFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA234,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__MicroFn,VAR1,VAR2)
      <=> p__MicroFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA235,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__NanoFn,VAR1,VAR2)
      <=> p__NanoFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA236,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__UnitOfMeasure)
     => ( p__d__holds3(c__PicoFn,VAR1,VAR2)
      <=> p__PicoFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA237,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SetOrClass)
     => ( p__d__holds3(c__PowerSetFn,VAR1,VAR2)
      <=> p__PowerSetFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA238,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Attribute)
     => ( p__d__holds3(c__ExtensionFn,VAR1,VAR2)
      <=> p__ExtensionFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA239,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__List)
     => ( p__d__holds3(c__ListLengthFn,VAR1,VAR2)
      <=> p__ListLengthFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA240,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Agent)
     => ( p__d__holds3(c__PropertyFn,VAR1,VAR2)
      <=> p__PropertyFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA241,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__AbsoluteValueFn,VAR1,VAR2)
      <=> p__AbsoluteValueFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA242,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__CeilingFn,VAR1,VAR2)
      <=> p__CeilingFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA243,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__PlaneAngleMeasure)
     => ( p__d__holds3(c__CosineFn,VAR1,VAR2)
      <=> p__CosineFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA244,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__DenominatorFn,VAR1,VAR2)
      <=> p__DenominatorFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA245,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__FloorFn,VAR1,VAR2)
      <=> p__FloorFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA246,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__ComplexNumber)
     => ( p__d__holds3(c__ImaginaryPartFn,VAR1,VAR2)
      <=> p__ImaginaryPartFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA247,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__IntegerSquareRootFn,VAR1,VAR2)
      <=> p__IntegerSquareRootFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA248,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__NumeratorFn,VAR1,VAR2)
      <=> p__NumeratorFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA249,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Number)
     => ( p__d__holds3(c__RationalNumberFn,VAR1,VAR2)
      <=> p__RationalNumberFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA250,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Number)
     => ( p__d__holds3(c__RealNumberFn,VAR1,VAR2)
      <=> p__RealNumberFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA251,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Quantity)
     => ( p__d__holds3(c__ReciprocalFn,VAR1,VAR2)
      <=> p__ReciprocalFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA252,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Quantity)
     => ( p__d__holds3(c__RoundFn,VAR1,VAR2)
      <=> p__RoundFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA253,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__SignumFn,VAR1,VAR2)
      <=> p__SignumFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA254,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__PlaneAngleMeasure)
     => ( p__d__holds3(c__SineFn,VAR1,VAR2)
      <=> p__SineFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA255,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__RealNumber)
     => ( p__d__holds3(c__SquareRootFn,VAR1,VAR2)
      <=> p__SquareRootFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA256,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__PlaneAngleMeasure)
     => ( p__d__holds3(c__TangentFn,VAR1,VAR2)
      <=> p__TangentFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA257,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Integer)
     => ( p__d__holds3(c__SuccessorFn,VAR1,VAR2)
      <=> p__SuccessorFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA258,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Integer)
     => ( p__d__holds3(c__PredecessorFn,VAR1,VAR2)
      <=> p__PredecessorFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA259,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SetOrClass)
     => ( p__d__holds3(c__ComplementFn,VAR1,VAR2)
      <=> p__ComplementFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA260,axiom,
    ! [VAR1,VAR2] :
      ( p__d__subclass(VAR1,c__SetOrClass)
     => ( p__d__holds3(c__GeneralizedUnionFn,VAR1,VAR2)
      <=> p__GeneralizedUnionFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA261,axiom,
    ! [VAR1,VAR2] :
      ( p__d__subclass(VAR1,c__SetOrClass)
     => ( p__d__holds3(c__GeneralizedIntersectionFn,VAR1,VAR2)
      <=> p__GeneralizedIntersectionFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA262,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GraphArc)
     => ( p__d__holds3(c__InitialNodeFn,VAR1,VAR2)
      <=> p__InitialNodeFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA263,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GraphArc)
     => ( p__d__holds3(c__TerminalNodeFn,VAR1,VAR2)
      <=> p__TerminalNodeFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA264,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GraphPath)
     => ( p__d__holds3(c__BeginNodeFn,VAR1,VAR2)
      <=> p__BeginNodeFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA265,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GraphPath)
     => ( p__d__holds3(c__EndNodeFn,VAR1,VAR2)
      <=> p__EndNodeFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA266,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GraphPath)
     => ( p__d__holds3(c__PathWeightFn,VAR1,VAR2)
      <=> p__PathWeightFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA267,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Graph)
     => ( p__d__holds3(c__CutSetFn,VAR1,VAR2)
      <=> p__CutSetFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA268,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Graph)
     => ( p__d__holds3(c__MinimalCutSetFn,VAR1,VAR2)
      <=> p__MinimalCutSetFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA269,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__PhysicalQuantity)
     => ( p__d__holds3(c__MagnitudeFn,VAR1,VAR2)
      <=> p__MagnitudeFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA270,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__PhysicalQuantity)
     => ( p__d__holds3(c__UnitFn,VAR1,VAR2)
      <=> p__UnitFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA271,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Circle)
     => ( p__d__holds3(c__CenterOfCircleFn,VAR1,VAR2)
      <=> p__CenterOfCircleFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA272,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Agent)
     => ( p__d__holds3(c__WealthFn,VAR1,VAR2)
      <=> p__WealthFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA273,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__TimeInterval)
     => ( p__d__holds3(c__BeginFn,VAR1,VAR2)
      <=> p__BeginFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA274,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__TimeInterval)
     => ( p__d__holds3(c__EndFn,VAR1,VAR2)
      <=> p__EndFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA275,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Physical)
     => ( p__d__holds3(c__WhenFn,VAR1,VAR2)
      <=> p__WhenFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA276,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__TimePosition)
     => ( p__d__holds3(c__PastFn,VAR1,VAR2)
      <=> p__PastFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA277,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__TimePosition)
     => ( p__d__holds3(c__ImmediatePastFn,VAR1,VAR2)
      <=> p__ImmediatePastFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA278,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__TimePosition)
     => ( p__d__holds3(c__FutureFn,VAR1,VAR2)
      <=> p__FutureFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA279,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__TimePosition)
     => ( p__d__holds3(c__ImmediateFutureFn,VAR1,VAR2)
      <=> p__ImmediateFutureFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA280,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Integer)
     => ( p__d__holds3(c__YearFn,VAR1,VAR2)
      <=> p__YearFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA281,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Object)
     => ( p__d__holds3(c__MereologicalComplementFn,VAR1,VAR2)
      <=> p__MereologicalComplementFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA282,axiom,
    ! [VAR1,VAR2] :
      ( p__d__subclass(VAR1,c__Organism)
     => ( p__d__holds3(c__FoodForFn,VAR1,VAR2)
      <=> p__FoodForFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA283,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Human)
     => ( p__d__holds3(c__ImmediateFamilyFn,VAR1,VAR2)
      <=> p__ImmediateFamilyFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA284,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GeopoliticalArea)
     => ( p__d__holds3(c__GovernmentFn,VAR1,VAR2)
      <=> p__GovernmentFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA285,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Argument)
     => ( p__d__holds3(c__PremisesFn,VAR1,VAR2)
      <=> p__PremisesFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA286,axiom,
    ! [VAR1,VAR2] :
      ( p__d__subclass(VAR1,c__Organism)
     => ( p__d__holds3(c__DeadFn,VAR1,VAR2)
      <=> p__DeadFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA287,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Process)
     => ( p__d__holds3(c__StartFn,VAR1,VAR2)
      <=> p__StartFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA288,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Process)
     => ( p__d__holds3(c__StopFn,VAR1,VAR2)
      <=> p__StopFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA289,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Circle)
     => ( p__d__holds3(c__DiameterFn,VAR1,VAR2)
      <=> p__DiameterFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA290,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Circle)
     => ( p__d__holds3(c__RadiusFn,VAR1,VAR2)
      <=> p__RadiusFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA291,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__List)
     => ( p__d__holds3(c__LastFn,VAR1,VAR2)
      <=> p__LastFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA292,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__List)
     => ( p__d__holds3(c__FirstFn,VAR1,VAR2)
      <=> p__FirstFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA293,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Human)
     => ( p__d__holds3(c__DescendantsFn,VAR1,VAR2)
      <=> p__DescendantsFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA294,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GeopoliticalArea)
     => ( p__d__holds3(c__ResidentFn,VAR1,VAR2)
      <=> p__ResidentFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA295,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Device)
     => ( p__d__holds3(c__OperatingFn,VAR1,VAR2)
      <=> p__OperatingFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA296,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__IntentionalProcess)
     => ( p__d__holds3(c__OccupationFn,VAR1,VAR2)
      <=> p__OccupationFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA297,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SymbolicString)
     => ( p__d__holds3(c__StringLengthFn,VAR1,VAR2)
      <=> p__StringLengthFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA298,axiom,
    ! [VAR1,VAR2] :
      ( p__d__subclass(VAR1,c__BodyPart)
     => ( p__d__holds3(c__CoveringFn,VAR1,VAR2)
      <=> p__CoveringFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA299,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR2,c__SetOrClass)
     => ( p__d__holds3(c__instance,VAR1,VAR2)
      <=> p__instance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA300,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR2,c__SymbolicString)
     => ( p__d__holds3(c__externalImage,VAR1,VAR2)
      <=> p__externalImage(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA301,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__entails,VAR1,VAR2)
      <=> p__entails(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA302,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CorpuscularObject)
        & p__d__subclass(VAR1,c__Substance) )
     => ( p__d__holds3(c__material,VAR1,VAR2)
      <=> p__material(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA303,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR2,c__Attribute)
     => ( p__d__holds3(c__property,VAR1,VAR2)
      <=> p__property(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA304,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__CognitiveAgent)
     => ( p__d__holds3(c__inScopeOfInterest,VAR1,VAR2)
      <=> p__inScopeOfInterest(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA305,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__needs,VAR1,VAR2)
      <=> p__needs(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA306,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__wants,VAR1,VAR2)
      <=> p__wants(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA307,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__BinaryFunction)
        & p__d__instance(VAR1,c__BinaryFunction) )
     => ( p__d__holds3(c__distributes,VAR1,VAR2)
      <=> p__distributes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA308,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__partlyLocated,VAR1,VAR2)
      <=> p__partlyLocated(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA309,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__traverses,VAR1,VAR2)
      <=> p__traverses(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA310,axiom,
    ! [VAR1,VAR2] :
      ( p__d__holds3(c__refers,VAR1,VAR2)
    <=> p__refers(VAR1,VAR2) ) ).

fof(schemaBinaryRelationA311,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__RealNumber)
        & p__d__instance(VAR1,c__List) )
     => ( p__d__holds3(c__average,VAR1,VAR2)
      <=> p__average(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA312,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__GraphArc) )
     => ( p__d__holds3(c__arcWeight,VAR1,VAR2)
      <=> p__arcWeight(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA313,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__Abstract) )
     => ( p__d__holds3(c__abstractCounterpart,VAR1,VAR2)
      <=> p__abstractCounterpart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA314,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PhysicalSystem)
        & p__d__instance(VAR1,c__PhysicalSystem) )
     => ( p__d__holds3(c__subSystem,VAR1,VAR2)
      <=> p__subSystem(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA315,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PhysicalSystem)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__systemPart,VAR1,VAR2)
      <=> p__systemPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA316,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__UnitOfMeasure)
        & p__d__instance(VAR1,c__Graph) )
     => ( p__d__holds3(c__graphMeasure,VAR1,VAR2)
      <=> p__graphMeasure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA317,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__MassMeasure)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__weight,VAR1,VAR2)
      <=> p__weight(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA318,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__Circle) )
     => ( p__d__holds3(c__radius,VAR1,VAR2)
      <=> p__radius(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA319,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__Circle) )
     => ( p__d__holds3(c__diameter,VAR1,VAR2)
      <=> p__diameter(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA320,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CurrencyMeasure)
        & p__d__instance(VAR1,c__FinancialTransaction) )
     => ( p__d__holds3(c__transactionAmount,VAR1,VAR2)
      <=> p__transactionAmount(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA321,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TemperatureMeasure)
        & p__d__subclass(VAR1,c__PureSubstance) )
     => ( p__d__holds3(c__boilingPoint,VAR1,VAR2)
      <=> p__boilingPoint(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA322,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TemperatureMeasure)
        & p__d__subclass(VAR1,c__PureSubstance) )
     => ( p__d__holds3(c__meltingPoint,VAR1,VAR2)
      <=> p__meltingPoint(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA323,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__WearableItem)
        & p__d__instance(VAR1,c__Animal) )
     => ( p__d__holds3(c__wears,VAR1,VAR2)
      <=> p__wears(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA324,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__acquaintance,VAR1,VAR2)
      <=> p__acquaintance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA325,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__employs,VAR1,VAR2)
      <=> p__employs(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA326,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Proposition)
        & p__d__instance(VAR1,c__Argument) )
     => ( p__d__holds3(c__premise,VAR1,VAR2)
      <=> p__premise(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA327,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Proposition)
        & p__d__instance(VAR1,c__Argument) )
     => ( p__d__holds3(c__conclusion,VAR1,VAR2)
      <=> p__conclusion(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA328,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__DirectionalAttribute)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__faces,VAR1,VAR2)
      <=> p__faces(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA329,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__OneDimensionalFigure)
        & p__d__instance(VAR1,c__OneDimensionalFigure) )
     => ( p__d__holds3(c__parallel,VAR1,VAR2)
      <=> p__parallel(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA330,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PlaneAngleMeasure)
        & p__d__instance(VAR1,c__TwoDimensionalAngle) )
     => ( p__d__holds3(c__angularMeasure,VAR1,VAR2)
      <=> p__angularMeasure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA331,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__OneDimensionalFigure) )
     => ( p__d__holds3(c__lineMeasure,VAR1,VAR2)
      <=> p__lineMeasure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA332,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__older,VAR1,VAR2)
      <=> p__older(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA333,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Language)
        & p__d__instance(VAR1,c__SentientAgent) )
     => ( p__d__holds3(c__speaksLanguage,VAR1,VAR2)
      <=> p__speaksLanguage(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA334,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__FunctionQuantity)
        & p__d__instance(VAR1,c__MusicalTone) )
     => ( p__d__holds3(c__soundFrequency,VAR1,VAR2)
      <=> p__soundFrequency(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA335,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__TimePosition)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__dateEstablished,VAR1,VAR2)
      <=> p__dateEstablished(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA336,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__Device) )
     => ( p__d__holds3(c__effectiveRange,VAR1,VAR2)
      <=> p__effectiveRange(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA337,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__DeviceStateAttribute)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__deviceState,VAR1,VAR2)
      <=> p__deviceState(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA338,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__discovers,VAR1,VAR2)
      <=> p__discovers(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA339,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__ConstantQuantity)
        & p__d__instance(VAR1,c__MeasuringDevice) )
     => ( p__d__holds3(c__measurementReading,VAR1,VAR2)
      <=> p__measurementReading(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA340,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__emailAddress,VAR1,VAR2)
      <=> p__emailAddress(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA341,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__RealNumber)
        & p__d__instance(VAR1,c__Solution) )
     => ( p__d__holds3(c__potentialOfHydrogen,VAR1,VAR2)
      <=> p__potentialOfHydrogen(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA342,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Integer)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__fleetSize,VAR1,VAR2)
      <=> p__fleetSize(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA343,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__carries,VAR1,VAR2)
      <=> p__carries(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA344,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TwoDimensionalFigure)
        & p__d__instance(VAR1,c__OneDimensionalFigure) )
     => ( p__d__holds3(c__tangent,VAR1,VAR2)
      <=> p__tangent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA345,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CorpuscularObject)
        & p__d__instance(VAR1,c__TwoDimensionalObject) )
     => ( p__d__holds3(c__sliceOfFigure,VAR1,VAR2)
      <=> p__sliceOfFigure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA346,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__patientMedical,VAR1,VAR2)
      <=> p__patientMedical(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA347,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__parasite,VAR1,VAR2)
      <=> p__parasite(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA348,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__ConstantQuantity)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__capacity,VAR1,VAR2)
      <=> p__capacity(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA349,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__StationaryArtifact) )
     => ( p__d__holds3(c__humanCapacity,VAR1,VAR2)
      <=> p__humanCapacity(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA350,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PermanentResidence)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__landlord,VAR1,VAR2)
      <=> p__landlord(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA351,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Residence)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__tenant,VAR1,VAR2)
      <=> p__tenant(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA352,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__expects,VAR1,VAR2)
      <=> p__expects(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA353,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CareOrganization)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__medicalPatient,VAR1,VAR2)
      <=> p__medicalPatient(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA354,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__RationalNumber)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__intelligenceQuotient,VAR1,VAR2)
      <=> p__intelligenceQuotient(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA355,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__NaturalSubstance)
        & p__d__subclass(VAR1,c__OrganicObject) )
     => ( p__d__holds3(c__secretesSubstance,VAR1,VAR2)
      <=> p__secretesSubstance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA356,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Agent)
     => ( p__d__holds3(c__creator,VAR1,VAR2)
      <=> p__creator(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA357,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agreement)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__partyToAgreement,VAR1,VAR2)
      <=> p__partyToAgreement(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA358,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__Agreement) )
     => ( p__d__holds3(c__agreementPeriod,VAR1,VAR2)
      <=> p__agreementPeriod(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA359,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__Agreement) )
     => ( p__d__holds3(c__agreementEffectiveDate,VAR1,VAR2)
      <=> p__agreementEffectiveDate(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA360,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__Agreement) )
     => ( p__d__holds3(c__agreementExpirationDate,VAR1,VAR2)
      <=> p__agreementExpirationDate(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA361,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SymbolicString)
     => ( p__d__holds3(c__localLongName,VAR1,VAR2)
      <=> p__localLongName(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA362,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SymbolicString)
     => ( p__d__holds3(c__localShortName,VAR1,VAR2)
      <=> p__localShortName(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA363,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Process)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__commentator,VAR1,VAR2)
      <=> p__commentator(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA364,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds3(c__describes,VAR1,VAR2)
      <=> p__describes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA365,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__Certificate) )
     => ( p__d__holds3(c__issuedBy,VAR1,VAR2)
      <=> p__issuedBy(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA366,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__Text) )
     => ( p__d__holds3(c__registeredItem,VAR1,VAR2)
      <=> p__registeredItem(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA367,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__axis,VAR1,VAR2)
      <=> p__axis(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA368,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__WaterArea) )
     => ( p__d__holds3(c__waterDepth,VAR1,VAR2)
      <=> p__waterDepth(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA369,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__hasAward,VAR1,VAR2)
      <=> p__hasAward(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA370,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Animal)
        & p__d__subclass(VAR1,c__Meat) )
     => ( p__d__holds3(c__meatOfAnimal,VAR1,VAR2)
      <=> p__meatOfAnimal(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA371,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__FinancialTransaction)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__occupation,VAR1,VAR2)
      <=> p__occupation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA372,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__StationaryArtifact) )
     => ( p__d__holds3(c__constructionPeriod,VAR1,VAR2)
      <=> p__constructionPeriod(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA373,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__StationaryArtifact) )
     => ( p__d__holds3(c__contractor,VAR1,VAR2)
      <=> p__contractor(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA374,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__FieldOfStudy)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__hasExpertise,VAR1,VAR2)
      <=> p__hasExpertise(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA375,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__IntentionalProcess)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__hasOccupation,VAR1,VAR2)
      <=> p__hasOccupation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA376,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__PureSubstance) )
     => ( p__d__holds3(c__protonNumber,VAR1,VAR2)
      <=> p__protonNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA377,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__PureSubstance) )
     => ( p__d__holds3(c__electronNumber,VAR1,VAR2)
      <=> p__electronNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA378,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Integer)
        & p__d__instance(VAR1,c__Collection) )
     => ( p__d__holds3(c__memberCount,VAR1,VAR2)
      <=> p__memberCount(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA379,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__Collection) )
     => ( p__d__holds3(c__memberType,VAR1,VAR2)
      <=> p__memberType(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA380,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Collection)
        & p__d__instance(VAR1,c__ContentBearingObject) )
     => ( p__d__holds3(c__inventory,VAR1,VAR2)
      <=> p__inventory(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA381,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__stranger,VAR1,VAR2)
      <=> p__stranger(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA382,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Object)
        & p__d__subclass(VAR1,c__Object) )
     => ( p__d__holds3(c__typicalPart,VAR1,VAR2)
      <=> p__typicalPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA383,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Object)
        & p__d__subclass(VAR1,c__Object) )
     => ( p__d__holds3(c__typicallyContainsPart,VAR1,VAR2)
      <=> p__typicallyContainsPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA384,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Object)
        & p__d__subclass(VAR1,c__Object) )
     => ( p__d__holds3(c__initialPart,VAR1,VAR2)
      <=> p__initialPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA385,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__Object)
        & p__d__subclass(VAR1,c__Object) )
     => ( p__d__holds3(c__initiallyContainsPart,VAR1,VAR2)
      <=> p__initiallyContainsPart(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA386,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organization)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__affiliatedOrganization,VAR1,VAR2)
      <=> p__affiliatedOrganization(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA387,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__FormOfGovernment)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__ideologicalAffiliationOfOrganization,VAR1,VAR2)
      <=> p__ideologicalAffiliationOfOrganization(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA388,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__BeliefGroup)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__religiousAffiliationOfOrganization,VAR1,VAR2)
      <=> p__religiousAffiliationOfOrganization(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA389,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__allegiance,VAR1,VAR2)
      <=> p__allegiance(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA390,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__anniversary,VAR1,VAR2)
      <=> p__anniversary(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA391,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Animal) )
     => ( p__d__holds3(c__birthplace,VAR1,VAR2)
      <=> p__birthplace(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA392,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Day)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__birthdate,VAR1,VAR2)
      <=> p__birthdate(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA393,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Day)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__deathdate,VAR1,VAR2)
      <=> p__deathdate(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA394,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Animal) )
     => ( p__d__holds3(c__deathplace,VAR1,VAR2)
      <=> p__deathplace(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA395,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Device)
        & p__d__instance(VAR1,c__Artifact) )
     => ( p__d__holds3(c__equipmentType,VAR1,VAR2)
      <=> p__equipmentType(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA396,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Sentence)
        & p__d__instance(VAR1,c__Phrase) )
     => ( p__d__holds3(c__grammaticalRelation,VAR1,VAR2)
      <=> p__grammaticalRelation(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA397,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Transitway)
        & p__d__instance(VAR1,c__ConstantQuantity) )
     => ( p__d__holds3(c__distanceOnPath,VAR1,VAR2)
      <=> p__distanceOnPath(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA398,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SymbolicString)
        & p__d__instance(VAR1,c__Character) )
     => ( p__d__holds3(c__inString,VAR1,VAR2)
      <=> p__inString(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA399,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PostalPlace)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__unitNumber,VAR1,VAR2)
      <=> p__unitNumber(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA400,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PostalPlace)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds3(c__floorCode,VAR1,VAR2)
      <=> p__floorCode(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA401,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PhysicalQuantity)
        & p__d__instance(VAR1,c__PowerSource) )
     => ( p__d__holds3(c__voltageMeasure,VAR1,VAR2)
      <=> p__voltageMeasure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA402,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__subclass(VAR2,c__UniformClothing)
        & p__d__instance(VAR1,c__Group) )
     => ( p__d__holds3(c__hasUniform,VAR1,VAR2)
      <=> p__hasUniform(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA403,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Policy)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__policyOwner,VAR1,VAR2)
      <=> p__policyOwner(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA404,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__RealNumber)
        & p__d__instance(VAR1,c__RealNumber) )
     => ( p__d__holds3(c__approximateValue,VAR1,VAR2)
      <=> p__approximateValue(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA405,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__GeopoliticalArea)
     => ( p__d__holds3(c__CitizenryFn,VAR1,VAR2)
      <=> p__CitizenryFn(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA406,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Set)
        & p__d__instance(VAR1,c__Set) )
     => ( p__d__holds3(c__subset,VAR1,VAR2)
      <=> p__subset(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA407,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Substance)
        & p__d__instance(VAR1,c__Substance) )
     => ( p__d__holds3(c__piece,VAR1,VAR2)
      <=> p__piece(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA408,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CorpuscularObject)
        & p__d__instance(VAR1,c__CorpuscularObject) )
     => ( p__d__holds3(c__component,VAR1,VAR2)
      <=> p__component(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA409,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SelfConnectedObject)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__bottom,VAR1,VAR2)
      <=> p__bottom(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA410,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SelfConnectedObject)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__top,VAR1,VAR2)
      <=> p__top(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA411,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__SelfConnectedObject)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__side,VAR1,VAR2)
      <=> p__side(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA412,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__EngineeringComponent)
        & p__d__instance(VAR1,c__EngineeringComponent) )
     => ( p__d__holds3(c__engineeringSubcomponent,VAR1,VAR2)
      <=> p__engineeringSubcomponent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA413,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GroupOfPeople)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__groupMember,VAR1,VAR2)
      <=> p__groupMember(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA414,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__half,VAR1,VAR2)
      <=> p__half(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA415,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__third,VAR1,VAR2)
      <=> p__third(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA416,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__quarter,VAR1,VAR2)
      <=> p__quarter(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA417,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__most,VAR1,VAR2)
      <=> p__most(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA418,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__EducationalOrganization)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__student,VAR1,VAR2)
      <=> p__student(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA419,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__EducationalOrganization)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__teacher,VAR1,VAR2)
      <=> p__teacher(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA420,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeometricFigure)
        & p__d__instance(VAR1,c__GeometricPoint) )
     => ( p__d__holds3(c__pointOfFigure,VAR1,VAR2)
      <=> p__pointOfFigure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA421,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeometricFigure)
        & p__d__instance(VAR1,c__TwoDimensionalAngle) )
     => ( p__d__holds3(c__angleOfFigure,VAR1,VAR2)
      <=> p__angleOfFigure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA422,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeometricFigure)
        & p__d__instance(VAR1,c__OneDimensionalFigure) )
     => ( p__d__holds3(c__sideOfFigure,VAR1,VAR2)
      <=> p__sideOfFigure(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA423,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__mother,VAR1,VAR2)
      <=> p__mother(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA424,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__father,VAR1,VAR2)
      <=> p__father(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA425,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__daughter,VAR1,VAR2)
      <=> p__daughter(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA426,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Organism)
        & p__d__instance(VAR1,c__Organism) )
     => ( p__d__holds3(c__son,VAR1,VAR2)
      <=> p__son(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA427,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Woman)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__grandmother,VAR1,VAR2)
      <=> p__grandmother(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA428,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Man)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__grandfather,VAR1,VAR2)
      <=> p__grandfather(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA429,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Woman) )
     => ( p__d__holds3(c__aunt,VAR1,VAR2)
      <=> p__aunt(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA430,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__cousin,VAR1,VAR2)
      <=> p__cousin(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA431,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Man) )
     => ( p__d__holds3(c__nephew,VAR1,VAR2)
      <=> p__nephew(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA432,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Woman) )
     => ( p__d__holds3(c__niece,VAR1,VAR2)
      <=> p__niece(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA433,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Man) )
     => ( p__d__holds3(c__uncle,VAR1,VAR2)
      <=> p__uncle(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA434,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Animal) )
     => ( p__d__holds3(c__grasps,VAR1,VAR2)
      <=> p__grasps(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA435,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__LegalAction) )
     => ( p__d__holds3(c__plaintiff,VAR1,VAR2)
      <=> p__plaintiff(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA436,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Agent)
        & p__d__instance(VAR1,c__Contest) )
     => ( p__d__holds3(c__contestParticipant,VAR1,VAR2)
      <=> p__contestParticipant(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA437,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Demonstrating) )
     => ( p__d__holds3(c__attends,VAR1,VAR2)
      <=> p__attends(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA438,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__instrument,VAR1,VAR2)
      <=> p__instrument(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA439,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__resource,VAR1,VAR2)
      <=> p__resource(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA440,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__Process)
     => ( p__d__holds3(c__result,VAR1,VAR2)
      <=> p__result(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA441,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Substance)
        & p__d__instance(VAR1,c__ChemicalProcess) )
     => ( p__d__holds3(c__reactant,VAR1,VAR2)
      <=> p__reactant(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA442,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Substance)
        & p__d__instance(VAR1,c__ChemicalProcess) )
     => ( p__d__holds3(c__reagent,VAR1,VAR2)
      <=> p__reagent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA443,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LegalAction)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__defendant,VAR1,VAR2)
      <=> p__defendant(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA444,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Process) )
     => ( p__d__holds3(c__eventLocated,VAR1,VAR2)
      <=> p__eventLocated(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA445,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__ColorAttribute)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__color,VAR1,VAR2)
      <=> p__color(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA446,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds3(c__financialAsset,VAR1,VAR2)
      <=> p__financialAsset(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA447,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TimeDuration)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__age,VAR1,VAR2)
      <=> p__age(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA448,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__linearExtent,VAR1,VAR2)
      <=> p__linearExtent(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA449,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__width,VAR1,VAR2)
      <=> p__width(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA450,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__height,VAR1,VAR2)
      <=> p__height(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA451,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__length,VAR1,VAR2)
      <=> p__length(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA452,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CurrencyMeasure)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__monetaryValue,VAR1,VAR2)
      <=> p__monetaryValue(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA453,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__LengthMeasure)
        & p__d__instance(VAR1,c__Radiating) )
     => ( p__d__holds3(c__wavelength,VAR1,VAR2)
      <=> p__wavelength(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA454,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TemperatureMeasure)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__airTemperature,VAR1,VAR2)
      <=> p__airTemperature(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA455,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__PermanentResidence)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__home,VAR1,VAR2)
      <=> p__home(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA456,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TemporaryResidence)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__stays,VAR1,VAR2)
      <=> p__stays(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA457,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Man)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__stepfather,VAR1,VAR2)
      <=> p__stepfather(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA458,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Woman)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__stepmother,VAR1,VAR2)
      <=> p__stepmother(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA459,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds3(c__exactlyLocated,VAR1,VAR2)
      <=> p__exactlyLocated(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA460,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__GeopoliticalArea)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds3(c__headquartersOfOrganization,VAR1,VAR2)
      <=> p__headquartersOfOrganization(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA461,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Vehicle)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds3(c__onboard,VAR1,VAR2)
      <=> p__onboard(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA462,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__TruthValue)
        & p__d__instance(VAR1,c__Sentence) )
     => ( p__d__holds3(c__truth,VAR1,VAR2)
      <=> p__truth(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA463,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__CognitiveAgent)
     => ( p__d__holds3(c__enjoys,VAR1,VAR2)
      <=> p__enjoys(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA464,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__dislikes,VAR1,VAR2)
      <=> p__dislikes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA465,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__lacks,VAR1,VAR2)
      <=> p__lacks(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA466,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__CognitiveAgent)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__approves,VAR1,VAR2)
      <=> p__approves(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA467,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SymbolicString)
     => ( p__d__holds3(c__names,VAR1,VAR2)
      <=> p__names(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA468,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SymbolicString)
     => ( p__d__holds3(c__uniqueIdentifier,VAR1,VAR2)
      <=> p__uniqueIdentifier(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA469,axiom,
    ! [VAR1,VAR2] :
      ( p__d__holds3(c__represents,VAR1,VAR2)
    <=> p__represents(VAR1,VAR2) ) ).

fof(schemaBinaryRelationA470,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__ContentBearingObject) )
     => ( p__d__holds3(c__record,VAR1,VAR2)
      <=> p__record(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA471,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SymbolicString)
     => ( p__d__holds3(c__titles,VAR1,VAR2)
      <=> p__titles(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA472,axiom,
    ! [VAR1,VAR2] :
      ( p__d__instance(VAR1,c__SymbolicString)
     => ( p__d__holds3(c__formerName,VAR1,VAR2)
      <=> p__formerName(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA473,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Proposition)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds3(c__conforms,VAR1,VAR2)
      <=> p__conforms(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA474,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__fears,VAR1,VAR2)
      <=> p__fears(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA475,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds3(c__hopes,VAR1,VAR2)
      <=> p__hopes(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA476,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Day)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds3(c__birthday,VAR1,VAR2)
      <=> p__birthday(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA477,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Sentence)
        & p__d__instance(VAR1,c__NounPhrase) )
     => ( p__d__holds3(c__sententialObject,VAR1,VAR2)
      <=> p__sententialObject(VAR1,VAR2) ) ) ).

fof(schemaBinaryRelationA478,axiom,
    ! [VAR1,VAR2] :
      ( ( p__d__instance(VAR2,c__Sentence)
        & p__d__instance(VAR1,c__NounPhrase) )
     => ( p__d__holds3(c__sententialSubject,VAR1,VAR2)
      <=> p__sententialSubject(VAR1,VAR2) ) ) ).

fof(schemaTernaryRelationA1,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__MultiplicationFn,VAR1,VAR2,VAR3)
      <=> p__MultiplicationFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA2,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__AdditionFn,VAR1,VAR2,VAR3)
      <=> p__AdditionFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA3,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__SubtractionFn,VAR1,VAR2,VAR3)
      <=> p__SubtractionFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA4,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__DivisionFn,VAR1,VAR2,VAR3)
      <=> p__DivisionFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA5,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__MaxFn,VAR1,VAR2,VAR3)
      <=> p__MaxFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA6,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__MinFn,VAR1,VAR2,VAR3)
      <=> p__MinFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA7,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__List) )
     => ( p__d__holds4(c__ListOrderFn,VAR1,VAR2,VAR3)
      <=> p__ListOrderFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA8,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__List)
        & p__d__instance(VAR1,c__List) )
     => ( p__d__holds4(c__ListConcatenateFn,VAR1,VAR2,VAR3)
      <=> p__ListConcatenateFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA9,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds4(c__WhereFn,VAR1,VAR2,VAR3)
      <=> p__WhereFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA10,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Integer)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__ExponentiationFn,VAR1,VAR2,VAR3)
      <=> p__ExponentiationFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA11,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__RealNumber) )
     => ( p__d__holds4(c__LogFn,VAR1,VAR2,VAR3)
      <=> p__LogFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA12,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Quantity)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__RemainderFn,VAR1,VAR2,VAR3)
      <=> p__RemainderFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA13,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__SetOrClass) )
     => ( p__d__holds4(c__UnionFn,VAR1,VAR2,VAR3)
      <=> p__UnionFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA14,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__SetOrClass) )
     => ( p__d__holds4(c__IntersectionFn,VAR1,VAR2,VAR3)
      <=> p__IntersectionFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA15,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__SetOrClass) )
     => ( p__d__holds4(c__RelativeComplementFn,VAR1,VAR2,VAR3)
      <=> p__RelativeComplementFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA16,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__KappaFn,VAR1,VAR2,VAR3)
      <=> p__KappaFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA17,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__GraphNode)
        & p__d__instance(VAR1,c__GraphNode) )
     => ( p__d__holds4(c__MinimalWeightedPathFn,VAR1,VAR2,VAR3)
      <=> p__MinimalWeightedPathFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA18,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__GraphNode)
        & p__d__instance(VAR1,c__GraphNode) )
     => ( p__d__holds4(c__MaximalWeightedPathFn,VAR1,VAR2,VAR3)
      <=> p__MaximalWeightedPathFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA19,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__GraphNode)
        & p__d__instance(VAR1,c__GraphNode) )
     => ( p__d__holds4(c__GraphPathFn,VAR1,VAR2,VAR3)
      <=> p__GraphPathFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA20,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__UnitOfMeasure)
        & p__d__instance(VAR1,c__RealNumber) )
     => ( p__d__holds4(c__MeasureFn,VAR1,VAR2,VAR3)
      <=> p__MeasureFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA21,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__ConstantQuantity)
        & p__d__instance(VAR1,c__ConstantQuantity) )
     => ( p__d__holds4(c__IntervalFn,VAR1,VAR2,VAR3)
      <=> p__IntervalFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA22,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__PhysicalQuantity)
        & p__d__instance(VAR1,c__PhysicalQuantity) )
     => ( p__d__holds4(c__PerFn,VAR1,VAR2,VAR3)
      <=> p__PerFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA23,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__TimePoint) )
     => ( p__d__holds4(c__TimeIntervalFn,VAR1,VAR2,VAR3)
      <=> p__TimeIntervalFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA24,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__subclass(VAR2,c__TimeInterval)
        & p__d__subclass(VAR1,c__TimeInterval) )
     => ( p__d__holds4(c__RecurrentTimeIntervalFn,VAR1,VAR2,VAR3)
      <=> p__RecurrentTimeIntervalFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA25,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__subclass(VAR2,c__Year)
        & p__d__subclass(VAR1,c__Month) )
     => ( p__d__holds4(c__MonthFn,VAR1,VAR2,VAR3)
      <=> p__MonthFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA26,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__subclass(VAR2,c__Month)
        & p__d__instance(VAR1,c__PositiveInteger) )
     => ( p__d__holds4(c__DayFn,VAR1,VAR2,VAR3)
      <=> p__DayFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA27,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__subclass(VAR2,c__Day)
        & p__d__instance(VAR1,c__NonnegativeInteger) )
     => ( p__d__holds4(c__HourFn,VAR1,VAR2,VAR3)
      <=> p__HourFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA28,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__subclass(VAR2,c__Hour)
        & p__d__instance(VAR1,c__NonnegativeInteger) )
     => ( p__d__holds4(c__MinuteFn,VAR1,VAR2,VAR3)
      <=> p__MinuteFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA29,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__subclass(VAR2,c__Minute)
        & p__d__instance(VAR1,c__PositiveRealNumber) )
     => ( p__d__holds4(c__SecondFn,VAR1,VAR2,VAR3)
      <=> p__SecondFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA30,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__subclass(VAR2,c__TimeInterval)
        & p__d__instance(VAR1,c__TimeInterval) )
     => ( p__d__holds4(c__TemporalCompositionFn,VAR1,VAR2,VAR3)
      <=> p__TemporalCompositionFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA31,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__MereologicalSumFn,VAR1,VAR2,VAR3)
      <=> p__MereologicalSumFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA32,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__MereologicalProductFn,VAR1,VAR2,VAR3)
      <=> p__MereologicalProductFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA33,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__MereologicalDifferenceFn,VAR1,VAR2,VAR3)
      <=> p__MereologicalDifferenceFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA34,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__subclass(VAR1,c__ContentBearingObject) )
     => ( p__d__holds4(c__EditionFn,VAR1,VAR2,VAR3)
      <=> p__EditionFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA35,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__TimeZone)
        & p__d__instance(VAR1,c__TimePosition) )
     => ( p__d__holds4(c__RelativeTimeFn,VAR1,VAR2,VAR3)
      <=> p__RelativeTimeFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA36,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__GeopoliticalArea)
        & p__d__instance(VAR1,c__Quantity) )
     => ( p__d__holds4(c__PerCapitaFn,VAR1,VAR2,VAR3)
      <=> p__PerCapitaFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA37,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__TimeDuration)
        & p__d__instance(VAR1,c__TimePoint) )
     => ( p__d__holds4(c__TimePeriodFn,VAR1,VAR2,VAR3)
      <=> p__TimePeriodFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA38,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__subclass(VAR1,c__Series) )
     => ( p__d__holds4(c__SeriesVolumeFn,VAR1,VAR2,VAR3)
      <=> p__SeriesVolumeFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA39,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__PositiveInteger)
        & p__d__subclass(VAR1,c__Periodical) )
     => ( p__d__holds4(c__PeriodicalIssueFn,VAR1,VAR2,VAR3)
      <=> p__PeriodicalIssueFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA40,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__SymbolicString)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__StringConcatenateFn,VAR1,VAR2,VAR3)
      <=> p__StringConcatenateFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA41,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SetOrClass)
        & p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__Relation) )
     => ( p__d__holds4(c__domain,VAR1,VAR2,VAR3)
      <=> p__domain(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA42,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SetOrClass)
        & p__d__instance(VAR2,c__PositiveInteger)
        & p__d__instance(VAR1,c__Relation) )
     => ( p__d__holds4(c__domainSubclass,VAR1,VAR2,VAR3)
      <=> p__domainSubclass(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA43,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SymbolicString)
        & p__d__instance(VAR2,c__HumanLanguage) )
     => ( p__d__holds4(c__documentation,VAR1,VAR2,VAR3)
      <=> p__documentation(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA44,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SymbolicString)
        & p__d__instance(VAR1,c__Language) )
     => ( p__d__holds4(c__format,VAR1,VAR2,VAR3)
      <=> p__format(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA45,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SymbolicString)
        & p__d__instance(VAR1,c__Language) )
     => ( p__d__holds4(c__termFormat,VAR1,VAR2,VAR3)
      <=> p__termFormat(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA46,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Language)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__relatedExternalConcept,VAR1,VAR2,VAR3)
      <=> p__relatedExternalConcept(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA47,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( p__d__instance(VAR3,c__Attribute)
     => ( p__d__holds4(c__greaterThanByQuality,VAR1,VAR2,VAR3)
      <=> p__greaterThanByQuality(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA48,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__RealNumber)
        & p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds4(c__conditionalProbability,VAR1,VAR2,VAR3)
      <=> p__conditionalProbability(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA49,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Formula)
        & p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__CognitiveAgent) )
     => ( p__d__holds4(c__prefers,VAR1,VAR2,VAR3)
      <=> p__prefers(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA50,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Object)
        & p__d__instance(VAR2,c__CaseRole)
        & p__d__subclass(VAR1,c__Process) )
     => ( p__d__holds4(c__capability,VAR1,VAR2,VAR3)
      <=> p__capability(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA51,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__CognitiveAgent)
        & p__d__instance(VAR2,c__Formula)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds4(c__hasPurposeForAgent,VAR1,VAR2,VAR3)
      <=> p__hasPurposeForAgent(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA52,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__ObjectiveNorm)
        & p__d__instance(VAR2,c__Formula) )
     => ( p__d__holds4(c__confersNorm,VAR1,VAR2,VAR3)
      <=> p__confersNorm(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA53,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__ObjectiveNorm)
        & p__d__instance(VAR2,c__Formula) )
     => ( p__d__holds4(c__deprivesNorm,VAR1,VAR2,VAR3)
      <=> p__deprivesNorm(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA54,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Object)
        & p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__between,VAR1,VAR2,VAR3)
      <=> p__between(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA55,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( p__d__instance(VAR3,c__Agent)
     => ( p__d__holds4(c__representsForAgent,VAR1,VAR2,VAR3)
      <=> p__representsForAgent(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA56,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Language)
        & p__d__instance(VAR1,c__LinguisticExpression) )
     => ( p__d__holds4(c__representsInLanguage,VAR1,VAR2,VAR3)
      <=> p__representsInLanguage(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA57,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__GraphArc)
        & p__d__instance(VAR2,c__GraphNode)
        & p__d__instance(VAR1,c__GraphNode) )
     => ( p__d__holds4(c__links,VAR1,VAR2,VAR3)
      <=> p__links(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA58,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__LengthMeasure)
        & p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds4(c__distance,VAR1,VAR2,VAR3)
      <=> p__distance(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA59,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__TimePoint)
        & p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__TimePoint) )
     => ( p__d__holds4(c__temporallyBetween,VAR1,VAR2,VAR3)
      <=> p__temporallyBetween(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA60,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__TimePoint)
        & p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__TimePoint) )
     => ( p__d__holds4(c__temporallyBetweenOrEqual,VAR1,VAR2,VAR3)
      <=> p__temporallyBetweenOrEqual(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA61,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SelfConnectedObject)
        & p__d__instance(VAR2,c__SelfConnectedObject)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds4(c__connects,VAR1,VAR2,VAR3)
      <=> p__connects(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA62,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__PositionalAttribute)
        & p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__orientation,VAR1,VAR2,VAR3)
      <=> p__orientation(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA63,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Organization)
        & p__d__instance(VAR2,c__Position)
        & p__d__instance(VAR1,c__Human) )
     => ( p__d__holds4(c__occupiesPosition,VAR1,VAR2,VAR3)
      <=> p__occupiesPosition(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA64,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__CognitiveAgent)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds4(c__confersRight,VAR1,VAR2,VAR3)
      <=> p__confersRight(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA65,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__CognitiveAgent)
        & p__d__instance(VAR1,c__Formula) )
     => ( p__d__holds4(c__confersObligation,VAR1,VAR2,VAR3)
      <=> p__confersObligation(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA66,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__GeometricPoint)
        & p__d__instance(VAR2,c__OneDimensionalFigure)
        & p__d__instance(VAR1,c__OneDimensionalFigure) )
     => ( p__d__holds4(c__pointOfIntersection,VAR1,VAR2,VAR3)
      <=> p__pointOfIntersection(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA67,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__LengthMeasure)
        & p__d__instance(VAR2,c__GeometricPoint)
        & p__d__instance(VAR1,c__GeometricPoint) )
     => ( p__d__holds4(c__geometricDistance,VAR1,VAR2,VAR3)
      <=> p__geometricDistance(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA68,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SymbolicString)
        & p__d__instance(VAR2,c__SymbolicString) )
     => ( p__d__holds4(c__comment,VAR1,VAR2,VAR3)
      <=> p__comment(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA69,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Agent)
        & p__d__instance(VAR2,c__TimePoint)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__dateUsed,VAR1,VAR2,VAR3)
      <=> p__dateUsed(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA70,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Agent)
        & p__d__instance(VAR2,c__CurrencyMeasure)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds4(c__price,VAR1,VAR2,VAR3)
      <=> p__price(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA71,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__NonnegativeInteger)
        & p__d__instance(VAR2,c__SetOrClass)
        & p__d__instance(VAR1,c__Collection) )
     => ( p__d__holds4(c__memberTypeCount,VAR1,VAR2,VAR3)
      <=> p__memberTypeCount(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA72,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__TimePosition)
        & p__d__instance(VAR2,c__Collection)
        & p__d__instance(VAR1,c__SelfConnectedObject) )
     => ( p__d__holds4(c__memberAtTime,VAR1,VAR2,VAR3)
      <=> p__memberAtTime(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA73,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Human)
        & p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds4(c__subordinateInOrganization,VAR1,VAR2,VAR3)
      <=> p__subordinateInOrganization(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA74,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Position)
        & p__d__instance(VAR2,c__Position)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds4(c__subordinatePosition,VAR1,VAR2,VAR3)
      <=> p__subordinatePosition(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA75,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__GeographicArea)
        & p__d__subclass(VAR2,c__Process)
        & p__d__instance(VAR1,c__Agent) )
     => ( p__d__holds4(c__areaOfResponsibility,VAR1,VAR2,VAR3)
      <=> p__areaOfResponsibility(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA76,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Process)
        & p__d__instance(VAR2,c__CaseRole)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__playsRoleInEvent,VAR1,VAR2,VAR3)
      <=> p__playsRoleInEvent(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA77,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Object)
        & p__d__instance(VAR2,c__TimePosition)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__locatedAtTime,VAR1,VAR2,VAR3)
      <=> p__locatedAtTime(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA78,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Quantity)
        & p__d__subclass(VAR2,c__Device)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds4(c__equipmentCount,VAR1,VAR2,VAR3)
      <=> p__equipmentCount(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA79,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SymbolicString)
        & p__d__instance(VAR2,c__SymbolicString)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__stringConcatenation,VAR1,VAR2,VAR3)
      <=> p__stringConcatenation(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA80,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SymbolicString)
        & p__d__instance(VAR2,c__SymbolicString)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__precedesInString,VAR1,VAR2,VAR3)
      <=> p__precedesInString(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA81,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__SymbolicString)
        & p__d__instance(VAR2,c__Language)
        & p__d__instance(VAR1,c__Region) )
     => ( p__d__holds4(c__canonicalPlaceName,VAR1,VAR2,VAR3)
      <=> p__canonicalPlaceName(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA82,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__VolumeMeasure)
        & p__d__instance(VAR1,c__MassMeasure) )
     => ( p__d__holds4(c__DensityFn,VAR1,VAR2,VAR3)
      <=> p__DensityFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA83,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR2,c__TimeDuration)
        & p__d__instance(VAR1,c__LengthMeasure) )
     => ( p__d__holds4(c__SpeedFn,VAR1,VAR2,VAR3)
      <=> p__SpeedFn(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA84,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__LengthMeasure)
        & p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds4(c__altitude,VAR1,VAR2,VAR3)
      <=> p__altitude(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA85,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__LengthMeasure)
        & p__d__instance(VAR2,c__Physical)
        & p__d__instance(VAR1,c__Physical) )
     => ( p__d__holds4(c__depth,VAR1,VAR2,VAR3)
      <=> p__depth(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA86,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__EngineeringComponent)
        & p__d__instance(VAR2,c__EngineeringComponent)
        & p__d__instance(VAR1,c__EngineeringConnection) )
     => ( p__d__holds4(c__connectsEngineeringComponents,VAR1,VAR2,VAR3)
      <=> p__connectsEngineeringComponents(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA87,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Language)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__synonymousExternalConcept,VAR1,VAR2,VAR3)
      <=> p__synonymousExternalConcept(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA88,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Language)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__subsumingExternalConcept,VAR1,VAR2,VAR3)
      <=> p__subsumingExternalConcept(VAR1,VAR2,VAR3) ) ) ).

fof(schemaTernaryRelationA89,axiom,
    ! [VAR1,VAR2,VAR3] :
      ( ( p__d__instance(VAR3,c__Language)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds4(c__subsumedExternalConcept,VAR1,VAR2,VAR3)
      <=> p__subsumedExternalConcept(VAR1,VAR2,VAR3) ) ) ).

fof(schemaQuaternaryRelationA1,axiom,
    ! [VAR1,VAR2,VAR3,VAR4] :
      ( ( p__d__instance(VAR3,c__NonnegativeInteger)
        & p__d__instance(VAR2,c__NonnegativeInteger)
        & p__d__instance(VAR1,c__SymbolicString) )
     => ( p__d__holds5(c__SubstringFn,VAR1,VAR2,VAR3,VAR4)
      <=> p__SubstringFn(VAR1,VAR2,VAR3,VAR4) ) ) ).

fof(schemaQuaternaryRelationA2,axiom,
    ! [VAR1,VAR2,VAR3,VAR4] :
      ( ( p__d__instance(VAR4,c__Object)
        & p__d__instance(VAR3,c__Object)
        & p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds5(c__betweenOnPath,VAR1,VAR2,VAR3,VAR4)
      <=> p__betweenOnPath(VAR1,VAR2,VAR3,VAR4) ) ) ).

fof(schemaQuaternaryRelationA3,axiom,
    ! [VAR1,VAR2,VAR3,VAR4] :
      ( ( p__d__instance(VAR4,c__CognitiveAgent)
        & p__d__instance(VAR3,c__Agreement)
        & p__d__instance(VAR2,c__DeonticAttribute)
        & p__d__instance(VAR1,c__Proposition) )
     => ( p__d__holds5(c__agreementClause,VAR1,VAR2,VAR3,VAR4)
      <=> p__agreementClause(VAR1,VAR2,VAR3,VAR4) ) ) ).

fof(schemaQuaternaryRelationA4,axiom,
    ! [VAR1,VAR2,VAR3,VAR4] :
      ( ( p__d__instance(VAR4,c__CurrencyMeasure)
        & p__d__instance(VAR3,c__TimeDuration)
        & p__d__instance(VAR2,c__Human)
        & p__d__instance(VAR1,c__Organization) )
     => ( p__d__holds5(c__monetaryWage,VAR1,VAR2,VAR3,VAR4)
      <=> p__monetaryWage(VAR1,VAR2,VAR3,VAR4) ) ) ).

fof(schemaQuaternaryRelationA5,axiom,
    ! [VAR1,VAR2,VAR3,VAR4] :
      ( ( p__d__instance(VAR4,c__Transfer)
        & p__d__instance(VAR3,c__Object)
        & p__d__instance(VAR2,c__Object)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds5(c__beforeOnPath,VAR1,VAR2,VAR3,VAR4)
      <=> p__beforeOnPath(VAR1,VAR2,VAR3,VAR4) ) ) ).

fof(schemaQuintaryRelationA1,axiom,
    ! [VAR1,VAR2,VAR3,VAR4,VAR5] :
      ( ( p__d__instance(VAR4,c__DirectionalAttribute)
        & p__d__instance(VAR3,c__Region)
        & p__d__instance(VAR2,c__TimeDuration)
        & p__d__instance(VAR1,c__LengthMeasure) )
     => ( p__d__holds6(c__VelocityFn,VAR1,VAR2,VAR3,VAR4,VAR5)
      <=> p__VelocityFn(VAR1,VAR2,VAR3,VAR4,VAR5) ) ) ).

fof(schemaQuintaryRelationA2,axiom,
    ! [VAR1,VAR2,VAR3,VAR4,VAR5] :
      ( ( p__d__instance(VAR4,c__Nation)
        & p__d__instance(VAR3,c__City)
        & p__d__instance(VAR2,c__Roadway)
        & p__d__instance(VAR1,c__StationaryArtifact) )
     => ( p__d__holds6(c__StreetAddressFn,VAR1,VAR2,VAR3,VAR4,VAR5)
      <=> p__StreetAddressFn(VAR1,VAR2,VAR3,VAR4,VAR5) ) ) ).

fof(schemaQuintaryRelationA3,axiom,
    ! [VAR1,VAR2,VAR3,VAR4,VAR5] :
      ( ( p__d__instance(VAR5,c__Object)
        & p__d__instance(VAR4,c__TimePosition)
        & p__d__subclass(VAR3,c__Process)
        & p__d__instance(VAR2,c__CaseRole)
        & p__d__instance(VAR1,c__Object) )
     => ( p__d__holds6(c__playsRoleInEventOfType,VAR1,VAR2,VAR3,VAR4,VAR5)
      <=> p__playsRoleInEventOfType(VAR1,VAR2,VAR3,VAR4,VAR5) ) ) ).

fof(typeA1,axiom,
    ! [X1,X2] :
      ( p__subrelation(X1,X2)
     => ( p__d__instance(X2,c__Relation)
        & p__d__instance(X1,c__Relation) ) ) ).

fof(typeA2,axiom,
    ! [X1,X2] :
      ( p__subAttribute(X1,X2)
     => ( p__d__instance(X2,c__Attribute)
        & p__d__instance(X1,c__Attribute) ) ) ).

fof(typeA3,axiom,
    ! [X1,X2,X3] :
      ( p__d__holds3(X1,X2,X3)
     => p__d__instance(X1,c__BinaryRelation) ) ).

fof(typeA4,axiom,
    ! [X1,X2] :
      ( p__subclass(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__SetOrClass) ) ) ).

fof(typeA5,axiom,
    ! [X1,X2] :
      ( p__part(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA6,axiom,
    ! [X1,X2] :
      ( p__subCollection(X1,X2)
     => ( p__d__instance(X2,c__Collection)
        & p__d__instance(X1,c__Collection) ) ) ).

fof(typeA7,axiom,
    ! [X1,X2] :
      ( p__lessThanOrEqualTo(X1,X2)
     => ( p__d__instance(X2,c__Quantity)
        & p__d__instance(X1,c__Quantity) ) ) ).

fof(typeA8,axiom,
    ! [X1,X2] :
      ( p__greaterThanOrEqualTo(X1,X2)
     => ( p__d__instance(X2,c__Quantity)
        & p__d__instance(X1,c__Quantity) ) ) ).

fof(typeA9,axiom,
    ! [X1,X2] :
      ( p__subList(X1,X2)
     => ( p__d__instance(X2,c__List)
        & p__d__instance(X1,c__List) ) ) ).

fof(typeA10,axiom,
    ! [X1,X2] :
      ( p__initialList(X1,X2)
     => ( p__d__instance(X2,c__List)
        & p__d__instance(X1,c__List) ) ) ).

fof(typeA11,axiom,
    ! [X1,X2] :
      ( p__subsumesContentClass(X1,X2)
     => ( p__d__subclass(X2,c__ContentBearingPhysical)
        & p__d__subclass(X1,c__ContentBearingPhysical) ) ) ).

fof(typeA12,axiom,
    ! [X1,X2] :
      ( p__subsumesContentInstance(X1,X2)
     => ( p__d__instance(X2,c__ContentBearingPhysical)
        & p__d__instance(X1,c__ContentBearingPhysical) ) ) ).

fof(typeA13,axiom,
    ! [X1,X2] :
      ( p__temporalPart(X1,X2)
     => ( p__d__instance(X2,c__TimePosition)
        & p__d__instance(X1,c__TimePosition) ) ) ).

fof(typeA14,axiom,
    ! [X1,X2] :
      ( p__beforeOrEqual(X1,X2)
     => ( p__d__instance(X2,c__TimePoint)
        & p__d__instance(X1,c__TimePoint) ) ) ).

fof(typeA15,axiom,
    ! [X1,X2] :
      ( p__subProcess(X1,X2)
     => ( p__d__instance(X2,c__Process)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA16,axiom,
    ! [X1,X2] :
      ( p__subOrganization(X1,X2)
     => ( p__d__instance(X2,c__Organization)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA17,axiom,
    ! [X1,X2] :
      ( p__geometricPart(X1,X2)
     => ( p__d__instance(X2,c__GeometricFigure)
        & p__d__instance(X1,c__GeometricFigure) ) ) ).

fof(typeA18,axiom,
    ! [X1,X2] :
      ( p__abstractPart(X1,X2)
     => ( p__d__instance(X2,c__Abstract)
        & p__d__instance(X1,c__Abstract) ) ) ).

fof(typeA19,axiom,
    ! [X1,X2] :
      ( p__identicalListItems(X1,X2)
     => ( p__d__instance(X2,c__List)
        & p__d__instance(X1,c__List) ) ) ).

fof(typeA20,axiom,
    ! [X1,X2] :
      ( p__copy(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA21,axiom,
    ! [X1,X2] :
      ( p__equivalentContentClass(X1,X2)
     => ( p__d__subclass(X2,c__ContentBearingPhysical)
        & p__d__subclass(X1,c__ContentBearingPhysical) ) ) ).

fof(typeA22,axiom,
    ! [X1,X2] :
      ( p__equivalentContentInstance(X1,X2)
     => ( p__d__instance(X2,c__ContentBearingPhysical)
        & p__d__instance(X1,c__ContentBearingPhysical) ) ) ).

fof(typeA23,axiom,
    ! [X1,X2] :
      ( p__cooccur(X1,X2)
     => ( p__d__instance(X2,c__Physical)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA24,axiom,
    ! [X1,X2] :
      ( p__familyRelation(X1,X2)
     => ( p__d__instance(X2,c__Organism)
        & p__d__instance(X1,c__Organism) ) ) ).

fof(typeA25,axiom,
    ! [X1,X2] :
      ( p__subGraph(X1,X2)
     => ( p__d__instance(X2,c__Graph)
        & p__d__instance(X1,c__Graph) ) ) ).

fof(typeA26,axiom,
    ! [X1,X2] :
      ( p__overlapsTemporally(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__TimeInterval) ) ) ).

fof(typeA27,axiom,
    ! [X1,X2] :
      ( p__connected(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA28,axiom,
    ! [X1,X2] :
      ( p__overlapsSpatially(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA29,axiom,
    ! [X1,X2] :
      ( p__subString(X1,X2)
     => ( p__d__instance(X2,c__SymbolicString)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA30,axiom,
    ! [X1,X2] :
      ( p__agent(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA31,axiom,
    ! [X1,X2] :
      ( p__destination(X1,X2)
     => p__d__instance(X1,c__Process) ) ).

fof(typeA32,axiom,
    ! [X1,X2] :
      ( p__experiencer(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA33,axiom,
    ! [X1,X2] :
      ( p__origin(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA34,axiom,
    ! [X1,X2] :
      ( p__patient(X1,X2)
     => p__d__instance(X1,c__Process) ) ).

fof(typeA35,axiom,
    ! [X1,X2] :
      ( p__eventPartlyLocated(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA36,axiom,
    ! [X1,X2] :
      ( p__moves(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Motion) ) ) ).

fof(typeA37,axiom,
    ! [X1,X2] :
      ( p__changesLocation(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Translocation) ) ) ).

fof(typeA38,axiom,
    ! [X1,X2] :
      ( p__path(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Motion) ) ) ).

fof(typeA39,axiom,
    ! [X1,X2] :
      ( p__direction(X1,X2)
     => ( p__d__instance(X2,c__PositionalAttribute)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA40,axiom,
    ! [X1,X2] :
      ( p__detainee(X1,X2)
     => ( p__d__instance(X2,c__Animal)
        & p__d__instance(X1,c__Confining) ) ) ).

fof(typeA41,axiom,
    ! [X1,X2] :
      ( p__targetInAttack(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA42,axiom,
    ! [X1,X2] :
      ( p__experimentalControl(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Experimenting) ) ) ).

fof(typeA43,axiom,
    ! [X1,X2] :
      ( p__controlled(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__AchievingControl) ) ) ).

fof(typeA44,axiom,
    ! [X1,X2] :
      ( p__gainsControl(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__AchievingControl) ) ) ).

fof(typeA45,axiom,
    ! [X1,X2] :
      ( p__losesControl(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__ChangeOfControl) ) ) ).

fof(typeA46,axiom,
    ! [X1,X2] :
      ( p__arrested(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__PlacingUnderArrest) ) ) ).

fof(typeA47,axiom,
    ! [X1,X2] :
      ( p__conveyance(X1,X2)
     => ( p__d__instance(X2,c__TransportationDevice)
        & p__d__instance(X1,c__Transportation) ) ) ).

fof(typeA48,axiom,
    ! [X1,X2] :
      ( p__suffers(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA49,axiom,
    ! [X1,X2] :
      ( p__desires(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA50,axiom,
    ! [X1,X2] :
      ( p__considers(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA51,axiom,
    ! [X1,X2] :
      ( p__believes(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA52,axiom,
    ! [X1,X2] :
      ( p__knows(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA53,axiom,
    ! [X1,X2] :
      ( p__doubts(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA54,axiom,
    ! [X1,X2] :
      ( p__disapproves(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA55,axiom,
    ! [X1,X2] :
      ( p__immediateInstance(X1,X2)
     => p__d__instance(X2,c__SetOrClass) ) ).

fof(typeA56,axiom,
    ! [X1,X2] :
      ( p__immediateSubclass(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__SetOrClass) ) ) ).

fof(typeA57,axiom,
    ! [X1,X2] :
      ( p__range(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__Function) ) ) ).

fof(typeA58,axiom,
    ! [X1,X2] :
      ( p__rangeSubclass(X1,X2)
     => ( p__d__subclass(X2,c__SetOrClass)
        & p__d__instance(X1,c__Function) ) ) ).

fof(typeA59,axiom,
    ! [X1,X2] :
      ( p__valence(X1,X2)
     => ( p__d__instance(X2,c__PositiveInteger)
        & p__d__instance(X1,c__Relation) ) ) ).

fof(typeA60,axiom,
    ! [X1,X2] :
      ( p__successorAttribute(X1,X2)
     => ( p__d__instance(X2,c__Attribute)
        & p__d__instance(X1,c__Attribute) ) ) ).

fof(typeA61,axiom,
    ! [X1,X2] :
      ( p__FrontFn(X1,X2)
     => p__d__instance(X1,c__SelfConnectedObject) ) ).

fof(typeA62,axiom,
    ! [X1,X2] :
      ( p__BackFn(X1,X2)
     => p__d__instance(X1,c__SelfConnectedObject) ) ).

fof(typeA63,axiom,
    ! [X1,X2] :
      ( p__properPart(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA64,axiom,
    ! [X1,X2] :
      ( p__contains(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA65,axiom,
    ! [X1,X2] :
      ( p__member(X1,X2)
     => ( p__d__instance(X2,c__Collection)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA66,axiom,
    ! [X1,X2] :
      ( p__containsInformation(X1,X2)
     => ( p__d__instance(X2,c__Proposition)
        & p__d__instance(X1,c__ContentBearingPhysical) ) ) ).

fof(typeA67,axiom,
    ! [X1,X2] :
      ( p__leader(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA68,axiom,
    ! [X1,X2] :
      ( p__attribute(X1,X2)
     => ( p__d__instance(X2,c__Attribute)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA69,axiom,
    ! [X1,X2] :
      ( p__manner(X1,X2)
     => ( p__d__instance(X2,c__Attribute)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA70,axiom,
    ! [X1,X2] :
      ( p__involvedInEvent(X1,X2)
     => p__d__instance(X1,c__Process) ) ).

fof(typeA71,axiom,
    ! [X1,X2] :
      ( p__ProbabilityFn(X1,X2)
     => p__d__instance(X1,c__Formula) ) ).

fof(typeA72,axiom,
    ! [X1,X2] :
      ( p__inList(X1,X2)
     => p__d__instance(X2,c__List) ) ).

fof(typeA73,axiom,
    ! [X1,X2] :
      ( p__closedOn(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__Function) ) ) ).

fof(typeA74,axiom,
    ! [X1,X2] :
      ( p__reflexiveOn(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__BinaryRelation) ) ) ).

fof(typeA75,axiom,
    ! [X1,X2] :
      ( p__irreflexiveOn(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__BinaryRelation) ) ) ).

fof(typeA76,axiom,
    ! [X1,X2] :
      ( p__partialOrderingOn(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__BinaryRelation) ) ) ).

fof(typeA77,axiom,
    ! [X1,X2] :
      ( p__totalOrderingOn(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__BinaryRelation) ) ) ).

fof(typeA78,axiom,
    ! [X1,X2] :
      ( p__trichotomizingOn(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__BinaryRelation) ) ) ).

fof(typeA79,axiom,
    ! [X1,X2] :
      ( p__equivalenceRelationOn(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__BinaryRelation) ) ) ).

fof(typeA80,axiom,
    ! [X1,X2] :
      ( p__causes(X1,X2)
     => ( p__d__instance(X2,c__Process)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA81,axiom,
    ! [X1,X2] :
      ( p__causesSubclass(X1,X2)
     => ( p__d__subclass(X2,c__Process)
        & p__d__subclass(X1,c__Process) ) ) ).

fof(typeA82,axiom,
    ! [X1,X2] :
      ( p__causesProposition(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA83,axiom,
    ! [X1,X2] :
      ( p__time(X1,X2)
     => ( p__d__instance(X2,c__TimePosition)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA84,axiom,
    ! [X1,X2] :
      ( p__holdsDuring(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__TimePosition) ) ) ).

fof(typeA85,axiom,
    ! [X1,X2] :
      ( p__exploits(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA86,axiom,
    ! [X1,X2] :
      ( p__hasPurpose(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA87,axiom,
    ! [X1,X2] :
      ( p__hasSkill(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__subclass(X1,c__Process) ) ) ).

fof(typeA88,axiom,
    ! [X1,X2] :
      ( p__crosses(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA89,axiom,
    ! [X1,X2] :
      ( p__penetrates(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA90,axiom,
    ! [X1,X2] :
      ( p__possesses(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA91,axiom,
    ! [X1,X2] :
      ( p__precondition(X1,X2)
     => ( p__d__subclass(X2,c__Process)
        & p__d__subclass(X1,c__Process) ) ) ).

fof(typeA92,axiom,
    ! [X1,X2] :
      ( p__realization(X1,X2)
     => ( p__d__instance(X2,c__Proposition)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA93,axiom,
    ! [X1,X2] :
      ( p__expressedInLanguage(X1,X2)
     => ( p__d__instance(X2,c__Language)
        & p__d__instance(X1,c__LinguisticExpression) ) ) ).

fof(typeA94,axiom,
    ! [X1,X2] :
      ( p__uses(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA95,axiom,
    ! [X1,X2] :
      ( p__identityElement(X1,X2)
     => p__d__instance(X1,c__BinaryFunction) ) ).

fof(typeA96,axiom,
    ! [X1,X2] :
      ( p__element(X1,X2)
     => p__d__instance(X2,c__Set) ) ).

fof(typeA97,axiom,
    ! [X1,X2] :
      ( p__graphPart(X1,X2)
     => ( p__d__instance(X2,c__Graph)
        & p__d__instance(X1,c__GraphElement) ) ) ).

fof(typeA98,axiom,
    ! [X1,X2] :
      ( p__pathLength(X1,X2)
     => ( p__d__instance(X2,c__PositiveInteger)
        & p__d__instance(X1,c__GraphPath) ) ) ).

fof(typeA99,axiom,
    ! [X1,X2] :
      ( p__measure(X1,X2)
     => ( p__d__instance(X2,c__PhysicalQuantity)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA100,axiom,
    ! [X1,X2] :
      ( p__barometricPressure(X1,X2)
     => ( p__d__instance(X2,c__UnitOfAtmosphericPressure)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA101,axiom,
    ! [X1,X2] :
      ( p__duration(X1,X2)
     => ( p__d__instance(X2,c__TimeDuration)
        & p__d__instance(X1,c__TimeInterval) ) ) ).

fof(typeA102,axiom,
    ! [X1,X2] :
      ( p__frequency(X1,X2)
     => ( p__d__instance(X2,c__TimeDuration)
        & p__d__subclass(X1,c__Process) ) ) ).

fof(typeA103,axiom,
    ! [X1,X2] :
      ( p__meetsTemporally(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__TimeInterval) ) ) ).

fof(typeA104,axiom,
    ! [X1,X2] :
      ( p__date(X1,X2)
     => ( p__d__instance(X2,c__Day)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA105,axiom,
    ! [X1,X2] :
      ( p__surface(X1,X2)
     => ( p__d__instance(X2,c__SelfConnectedObject)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA106,axiom,
    ! [X1,X2] :
      ( p__interiorPart(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA107,axiom,
    ! [X1,X2] :
      ( p__hole(X1,X2)
     => ( p__d__instance(X2,c__SelfConnectedObject)
        & p__d__instance(X1,c__Hole) ) ) ).

fof(typeA108,axiom,
    ! [X1,X2] :
      ( p__HoleHostFn(X1,X2)
     => p__d__instance(X1,c__Hole) ) ).

fof(typeA109,axiom,
    ! [X1,X2] :
      ( p__partiallyFills(X1,X2)
     => ( p__d__instance(X2,c__Hole)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA110,axiom,
    ! [X1,X2] :
      ( p__properlyFills(X1,X2)
     => ( p__d__instance(X2,c__Hole)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA111,axiom,
    ! [X1,X2] :
      ( p__completelyFills(X1,X2)
     => ( p__d__instance(X2,c__Hole)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA112,axiom,
    ! [X1,X2] :
      ( p__fills(X1,X2)
     => ( p__d__instance(X2,c__Hole)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA113,axiom,
    ! [X1,X2] :
      ( p__HoleSkinFn(X1,X2)
     => p__d__instance(X1,c__Hole) ) ).

fof(typeA114,axiom,
    ! [X1,X2] :
      ( p__atomicNumber(X1,X2)
     => ( p__d__instance(X2,c__PositiveInteger)
        & p__d__subclass(X1,c__ElementalSubstance) ) ) ).

fof(typeA115,axiom,
    ! [X1,X2] :
      ( p__geographicSubregion(X1,X2)
     => ( p__d__instance(X2,c__GeographicArea)
        & p__d__instance(X1,c__GeographicArea) ) ) ).

fof(typeA116,axiom,
    ! [X1,X2] :
      ( p__geopoliticalSubdivision(X1,X2)
     => ( p__d__instance(X2,c__GeopoliticalArea)
        & p__d__instance(X1,c__GeopoliticalArea) ) ) ).

fof(typeA117,axiom,
    ! [X1,X2] :
      ( p__developmentalForm(X1,X2)
     => ( p__d__instance(X2,c__DevelopmentalAttribute)
        & p__d__instance(X1,c__OrganicObject) ) ) ).

fof(typeA118,axiom,
    ! [X1,X2] :
      ( p__inhabits(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Organism) ) ) ).

fof(typeA119,axiom,
    ! [X1,X2] :
      ( p__authors(X1,X2)
     => ( p__d__subclass(X2,c__Text)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA120,axiom,
    ! [X1,X2] :
      ( p__editor(X1,X2)
     => ( p__d__subclass(X2,c__Text)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA121,axiom,
    ! [X1,X2] :
      ( p__publishes(X1,X2)
     => ( p__d__subclass(X2,c__Text)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA122,axiom,
    ! [X1,X2] :
      ( p__version(X1,X2)
     => ( p__d__subclass(X2,c__Artifact)
        & p__d__subclass(X1,c__Artifact) ) ) ).

fof(typeA123,axiom,
    ! [X1,X2] :
      ( p__parent(X1,X2)
     => ( p__d__instance(X2,c__Organism)
        & p__d__instance(X1,c__Organism) ) ) ).

fof(typeA124,axiom,
    ! [X1,X2] :
      ( p__husband(X1,X2)
     => ( p__d__instance(X2,c__Woman)
        & p__d__instance(X1,c__Man) ) ) ).

fof(typeA125,axiom,
    ! [X1,X2] :
      ( p__wife(X1,X2)
     => ( p__d__instance(X2,c__Man)
        & p__d__instance(X1,c__Woman) ) ) ).

fof(typeA126,axiom,
    ! [X1,X2] :
      ( p__citizen(X1,X2)
     => ( p__d__instance(X2,c__Nation)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA127,axiom,
    ! [X1,X2] :
      ( p__modalAttribute(X1,X2)
     => ( p__d__instance(X2,c__NormativeAttribute)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA128,axiom,
    ! [X1,X2] :
      ( p__holdsRight(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA129,axiom,
    ! [X1,X2] :
      ( p__holdsObligation(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA130,axiom,
    ! [X1,X2] :
      ( p__yearOfFounding(X1,X2)
     => ( p__d__instance(X2,c__Integer)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA131,axiom,
    ! [X1,X2] :
      ( p__powerPlant(X1,X2)
     => ( p__d__instance(X2,c__Artifact)
        & p__d__instance(X1,c__Device) ) ) ).

fof(typeA132,axiom,
    ! [X1,X2] :
      ( p__insured(X1,X2)
     => ( p__d__instance(X2,c__Organization)
        & p__d__instance(X1,c__Proposition) ) ) ).

fof(typeA133,axiom,
    ! [X1,X2] :
      ( p__loss(X1,X2)
     => ( p__d__instance(X2,c__CurrencyMeasure)
        & p__d__instance(X1,c__FinancialTransaction) ) ) ).

fof(typeA134,axiom,
    ! [X1,X2] :
      ( p__profit(X1,X2)
     => ( p__d__instance(X2,c__CurrencyMeasure)
        & p__d__instance(X1,c__FinancialTransaction) ) ) ).

fof(typeA135,axiom,
    ! [X1,X2] :
      ( p__customer(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA136,axiom,
    ! [X1,X2] :
      ( p__familyName(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA137,axiom,
    ! [X1,X2] :
      ( p__middleName(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA138,axiom,
    ! [X1,X2] :
      ( p__givenName(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA139,axiom,
    ! [X1,X2] :
      ( p__structure(X1,X2)
     => ( p__d__instance(X2,c__StructureAttribute)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA140,axiom,
    ! [X1,X2] :
      ( p__operator(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA141,axiom,
    ! [X1,X2] :
      ( p__transported(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Transportation) ) ) ).

fof(typeA142,axiom,
    ! [X1,X2] :
      ( p__cargo(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Shipping) ) ) ).

fof(typeA143,axiom,
    ! [X1,X2] :
      ( p__serviceProvider(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__ServiceProcess) ) ) ).

fof(typeA144,axiom,
    ! [X1,X2] :
      ( p__serviceRecipient(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__ServiceProcess) ) ) ).

fof(typeA145,axiom,
    ! [X1,X2] :
      ( p__benefits(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA146,axiom,
    ! [X1,X2] :
      ( p__grandparent(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA147,axiom,
    ! [X1,X2] :
      ( p__alias(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA148,axiom,
    ! [X1,X2] :
      ( p__workAddress(X1,X2)
     => ( p__d__instance(X2,c__PostalPlace)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA149,axiom,
    ! [X1,X2] :
      ( p__homeAddress(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__PermanentResidence) ) ) ).

fof(typeA150,axiom,
    ! [X1,X2] :
      ( p__deceptiveIdentifier(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__ContentBearingObject) ) ) ).

fof(typeA151,axiom,
    ! [X1,X2] :
      ( p__stringLength(X1,X2)
     => ( p__d__instance(X2,c__SymbolicString)
        & p__d__instance(X1,c__NonnegativeInteger) ) ) ).

fof(typeA152,axiom,
    ! [X1,X2] :
      ( p__siteForContact(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__ContactSite) ) ) ).

fof(typeA153,axiom,
    ! [X1,X2] :
      ( p__postContactSite(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__PostalPlace) ) ) ).

fof(typeA154,axiom,
    ! [X1,X2] :
      ( p__postNeighborhood(X1,X2)
     => ( p__d__instance(X2,c__Neighborhood)
        & p__d__instance(X1,c__PostalPlace) ) ) ).

fof(typeA155,axiom,
    ! [X1,X2] :
      ( p__postCountry(X1,X2)
     => ( p__d__instance(X2,c__GeopoliticalArea)
        & p__d__instance(X1,c__PostalPlace) ) ) ).

fof(typeA156,axiom,
    ! [X1,X2] :
      ( p__postDistrict(X1,X2)
     => ( p__d__instance(X2,c__StateOrProvince)
        & p__d__instance(X1,c__PostalPlace) ) ) ).

fof(typeA157,axiom,
    ! [X1,X2] :
      ( p__postCity(X1,X2)
     => ( p__d__instance(X2,c__City)
        & p__d__instance(X1,c__PostalPlace) ) ) ).

fof(typeA158,axiom,
    ! [X1,X2] :
      ( p__postPostcodeArea(X1,X2)
     => ( p__d__instance(X2,c__PostcodeArea)
        & p__d__instance(X1,c__PostalPlace) ) ) ).

fof(typeA159,axiom,
    ! [X1,X2] :
      ( p__postStreet(X1,X2)
     => ( p__d__instance(X2,c__Roadway)
        & p__d__instance(X1,c__PostalPlace) ) ) ).

fof(typeA160,axiom,
    ! [X1,X2] :
      ( p__postStreetNumber(X1,X2)
     => ( p__d__instance(X2,c__PostalPlace)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA161,axiom,
    ! [X1,X2] :
      ( p__postPostOfficeBox(X1,X2)
     => ( p__d__instance(X2,c__PostalPlace)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA162,axiom,
    ! [X1,X2] :
      ( p__postAddressText(X1,X2)
     => ( p__d__instance(X2,c__PostalPlace)
        & p__d__instance(X1,c__PostalAddressText) ) ) ).

fof(typeA163,axiom,
    ! [X1,X2] :
      ( p__telecomContactDevice(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__TelephonyDevice) ) ) ).

fof(typeA164,axiom,
    ! [X1,X2] :
      ( p__deviceTelecomNumber(X1,X2)
     => ( p__d__instance(X2,c__TelephonyDevice)
        & p__d__instance(X1,c__TelecomNumber) ) ) ).

fof(typeA165,axiom,
    ! [X1,X2] :
      ( p__telecomCoreNumber(X1,X2)
     => ( p__d__instance(X2,c__TelecomNumber)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA166,axiom,
    ! [X1,X2] :
      ( p__telecomCountryCode(X1,X2)
     => ( p__d__instance(X2,c__TelecomNumber)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA167,axiom,
    ! [X1,X2] :
      ( p__telecomAreaCode(X1,X2)
     => ( p__d__instance(X2,c__TelecomNumber)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA168,axiom,
    ! [X1,X2] :
      ( p__telecomCode2(X1,X2)
     => ( p__d__instance(X2,c__TelecomNumber)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA169,axiom,
    ! [X1,X2] :
      ( p__telecomExtension(X1,X2)
     => ( p__d__instance(X2,c__TelecomNumber)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA170,axiom,
    ! [X1,X2] :
      ( p__telephoneNumber(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__TelecomNumber) ) ) ).

fof(typeA171,axiom,
    ! [X1,X2] :
      ( p__personalPhoneNumber(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__TelecomNumber) ) ) ).

fof(typeA172,axiom,
    ! [X1,X2] :
      ( p__homePhoneNumber(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__TelecomNumber) ) ) ).

fof(typeA173,axiom,
    ! [X1,X2] :
      ( p__workPhoneNumber(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__TelecomNumber) ) ) ).

fof(typeA174,axiom,
    ! [X1,X2] :
      ( p__mobilePhoneNumber(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__TelecomNumber) ) ) ).

fof(typeA175,axiom,
    ! [X1,X2] :
      ( p__faxNumber(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__TelecomNumber) ) ) ).

fof(typeA176,axiom,
    ! [X1,X2] :
      ( p__inverse(X1,X2)
     => ( p__d__instance(X2,c__BinaryRelation)
        & p__d__instance(X1,c__BinaryRelation) ) ) ).

fof(typeA177,axiom,
    ! [X1,X2] :
      ( p__disjointRelation(X1,X2)
     => ( p__d__instance(X2,c__Relation)
        & p__d__instance(X1,c__Relation) ) ) ).

fof(typeA178,axiom,
    ! [X1,X2] :
      ( p__successorAttributeClosure(X1,X2)
     => ( p__d__instance(X2,c__Attribute)
        & p__d__instance(X1,c__Attribute) ) ) ).

fof(typeA179,axiom,
    ! [X1,X2] :
      ( p__lessThan(X1,X2)
     => ( p__d__instance(X2,c__Quantity)
        & p__d__instance(X1,c__Quantity) ) ) ).

fof(typeA180,axiom,
    ! [X1,X2] :
      ( p__greaterThan(X1,X2)
     => ( p__d__instance(X2,c__Quantity)
        & p__d__instance(X1,c__Quantity) ) ) ).

fof(typeA181,axiom,
    ! [X1,X2] :
      ( p__increasesLikelihood(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA182,axiom,
    ! [X1,X2] :
      ( p__decreasesLikelihood(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA183,axiom,
    ! [X1,X2] :
      ( p__hindersSubclass(X1,X2)
     => ( p__d__subclass(X2,c__Process)
        & p__d__subclass(X1,c__Process) ) ) ).

fof(typeA184,axiom,
    ! [X1,X2] :
      ( p__preventsSubclass(X1,X2)
     => ( p__d__subclass(X2,c__Process)
        & p__d__subclass(X1,c__Process) ) ) ).

fof(typeA185,axiom,
    ! [X1,X2] :
      ( p__prevents(X1,X2)
     => ( p__d__subclass(X2,c__Process)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA186,axiom,
    ! [X1,X2] :
      ( p__hinders(X1,X2)
     => ( p__d__subclass(X2,c__Process)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA187,axiom,
    ! [X1,X2] :
      ( p__subProposition(X1,X2)
     => ( p__d__instance(X2,c__Proposition)
        & p__d__instance(X1,c__Proposition) ) ) ).

fof(typeA188,axiom,
    ! [X1,X2] :
      ( p__subPlan(X1,X2)
     => ( p__d__instance(X2,c__Plan)
        & p__d__instance(X1,c__Plan) ) ) ).

fof(typeA189,axiom,
    ! [X1,X2] :
      ( p__larger(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA190,axiom,
    ! [X1,X2] :
      ( p__smaller(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA191,axiom,
    ! [X1,X2] :
      ( p__starts(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__TimeInterval) ) ) ).

fof(typeA192,axiom,
    ! [X1,X2] :
      ( p__finishes(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__TimeInterval) ) ) ).

fof(typeA193,axiom,
    ! [X1,X2] :
      ( p__before(X1,X2)
     => ( p__d__instance(X2,c__TimePoint)
        & p__d__instance(X1,c__TimePoint) ) ) ).

fof(typeA194,axiom,
    ! [X1,X2] :
      ( p__during(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__TimeInterval) ) ) ).

fof(typeA195,axiom,
    ! [X1,X2] :
      ( p__earlier(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__TimeInterval) ) ) ).

fof(typeA196,axiom,
    ! [X1,X2] :
      ( p__meetsSpatially(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA197,axiom,
    ! [X1,X2] :
      ( p__overlapsPartially(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA198,axiom,
    ! [X1,X2] :
      ( p__superficialPart(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA199,axiom,
    ! [X1,X2] :
      ( p__connectedEngineeringComponents(X1,X2)
     => ( p__d__instance(X2,c__EngineeringComponent)
        & p__d__instance(X1,c__EngineeringComponent) ) ) ).

fof(typeA200,axiom,
    ! [X1,X2] :
      ( p__ancestor(X1,X2)
     => ( p__d__instance(X2,c__Organism)
        & p__d__instance(X1,c__Organism) ) ) ).

fof(typeA201,axiom,
    ! [X1,X2] :
      ( p__sibling(X1,X2)
     => ( p__d__instance(X2,c__Organism)
        & p__d__instance(X1,c__Organism) ) ) ).

fof(typeA202,axiom,
    ! [X1,X2] :
      ( p__brother(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Man) ) ) ).

fof(typeA203,axiom,
    ! [X1,X2] :
      ( p__sister(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Woman) ) ) ).

fof(typeA204,axiom,
    ! [X1,X2] :
      ( p__spouse(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA205,axiom,
    ! [X1,X2] :
      ( p__conjugate(X1,X2)
     => ( p__d__instance(X2,c__CompoundSubstance)
        & p__d__instance(X1,c__CompoundSubstance) ) ) ).

fof(typeA206,axiom,
    ! [X1,X2] :
      ( p__neighbor(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA207,axiom,
    ! [X1,X2] :
      ( p__hostileForces(X1,X2)
     => ( p__d__instance(X2,c__MilitaryUnit)
        & p__d__instance(X1,c__MilitaryUnit) ) ) ).

fof(typeA208,axiom,
    ! [X1,X2] :
      ( p__subField(X1,X2)
     => ( p__d__instance(X2,c__FieldOfStudy)
        & p__d__instance(X1,c__FieldOfStudy) ) ) ).

fof(typeA209,axiom,
    ! [X1,X2] :
      ( p__ancestorOrganization(X1,X2)
     => ( p__d__instance(X2,c__Organization)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA210,axiom,
    ! [X1,X2] :
      ( p__disjoint(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__SetOrClass) ) ) ).

fof(typeA211,axiom,
    ! [X1,X2] :
      ( p__independentProbability(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA212,axiom,
    ! [X1,X2] :
      ( p__relatedEvent(X1,X2)
     => ( p__d__instance(X2,c__Process)
        & p__d__instance(X1,c__Process) ) ) ).

fof(typeA213,axiom,
    ! [X1,X2] :
      ( p__relative(X1,X2)
     => ( p__d__instance(X2,c__Organism)
        & p__d__instance(X1,c__Organism) ) ) ).

fof(typeA214,axiom,
    ! [X1,X2] :
      ( p__legalRelation(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA215,axiom,
    ! [X1,X2] :
      ( p__mutualAcquaintance(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA216,axiom,
    ! [X1,X2] :
      ( p__consistent(X1,X2)
     => ( p__d__instance(X2,c__Proposition)
        & p__d__instance(X1,c__Proposition) ) ) ).

fof(typeA217,axiom,
    ! [X1,X2] :
      ( p__friend(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA218,axiom,
    ! [X1,X2] :
      ( p__coworker(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA219,axiom,
    ! [X1,X2] :
      ( p__cohabitant(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA220,axiom,
    ! [X1,X2] :
      ( p__mutualStranger(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA221,axiom,
    ! [X1,X2] :
      ( p__domesticPartner(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA222,axiom,
    ! [X1,X2] :
      ( p__located(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA223,axiom,
    ! [X1,X2] :
      ( p__stored(X1,X2)
     => ( p__d__instance(X2,c__DataStorageDevice)
        & p__d__instance(X1,c__ContentBearingObject) ) ) ).

fof(typeA224,axiom,
    ! [X1,X2] :
      ( p__legalGuardian(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA225,axiom,
    ! [X1,X2] :
      ( p__multiplicativeFactor(X1,X2)
     => ( p__d__instance(X2,c__Integer)
        & p__d__instance(X1,c__Integer) ) ) ).

fof(typeA226,axiom,
    ! [X1,X2] :
      ( p__covers(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA227,axiom,
    ! [X1,X2] :
      ( p__KiloFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA228,axiom,
    ! [X1,X2] :
      ( p__MegaFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA229,axiom,
    ! [X1,X2] :
      ( p__GigaFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA230,axiom,
    ! [X1,X2] :
      ( p__TeraFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA231,axiom,
    ! [X1,X2] :
      ( p__MilliFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA232,axiom,
    ! [X1,X2] :
      ( p__MicroFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA233,axiom,
    ! [X1,X2] :
      ( p__NanoFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA234,axiom,
    ! [X1,X2] :
      ( p__PicoFn(X1,X2)
     => p__d__instance(X1,c__UnitOfMeasure) ) ).

fof(typeA235,axiom,
    ! [X1,X2] :
      ( p__PowerSetFn(X1,X2)
     => p__d__instance(X1,c__SetOrClass) ) ).

fof(typeA236,axiom,
    ! [X1,X2] :
      ( p__ExtensionFn(X1,X2)
     => p__d__instance(X1,c__Attribute) ) ).

fof(typeA237,axiom,
    ! [X1,X2] :
      ( p__ListLengthFn(X1,X2)
     => p__d__instance(X1,c__List) ) ).

fof(typeA238,axiom,
    ! [X1,X2] :
      ( p__PropertyFn(X1,X2)
     => p__d__instance(X1,c__Agent) ) ).

fof(typeA239,axiom,
    ! [X1,X2] :
      ( p__AbsoluteValueFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA240,axiom,
    ! [X1,X2] :
      ( p__CeilingFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA241,axiom,
    ! [X1,X2] :
      ( p__CosineFn(X1,X2)
     => p__d__instance(X1,c__PlaneAngleMeasure) ) ).

fof(typeA242,axiom,
    ! [X1,X2] :
      ( p__DenominatorFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA243,axiom,
    ! [X1,X2] :
      ( p__FloorFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA244,axiom,
    ! [X1,X2] :
      ( p__ImaginaryPartFn(X1,X2)
     => p__d__instance(X1,c__ComplexNumber) ) ).

fof(typeA245,axiom,
    ! [X1,X2] :
      ( p__IntegerSquareRootFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA246,axiom,
    ! [X1,X2] :
      ( p__NumeratorFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA247,axiom,
    ! [X1,X2] :
      ( p__RationalNumberFn(X1,X2)
     => p__d__instance(X1,c__Number) ) ).

fof(typeA248,axiom,
    ! [X1,X2] :
      ( p__RealNumberFn(X1,X2)
     => p__d__instance(X1,c__Number) ) ).

fof(typeA249,axiom,
    ! [X1,X2] :
      ( p__ReciprocalFn(X1,X2)
     => p__d__instance(X1,c__Quantity) ) ).

fof(typeA250,axiom,
    ! [X1,X2] :
      ( p__RoundFn(X1,X2)
     => p__d__instance(X1,c__Quantity) ) ).

fof(typeA251,axiom,
    ! [X1,X2] :
      ( p__SignumFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA252,axiom,
    ! [X1,X2] :
      ( p__SineFn(X1,X2)
     => p__d__instance(X1,c__PlaneAngleMeasure) ) ).

fof(typeA253,axiom,
    ! [X1,X2] :
      ( p__SquareRootFn(X1,X2)
     => p__d__instance(X1,c__RealNumber) ) ).

fof(typeA254,axiom,
    ! [X1,X2] :
      ( p__TangentFn(X1,X2)
     => p__d__instance(X1,c__PlaneAngleMeasure) ) ).

fof(typeA255,axiom,
    ! [X1,X2] :
      ( p__SuccessorFn(X1,X2)
     => p__d__instance(X1,c__Integer) ) ).

fof(typeA256,axiom,
    ! [X1,X2] :
      ( p__PredecessorFn(X1,X2)
     => p__d__instance(X1,c__Integer) ) ).

fof(typeA257,axiom,
    ! [X1,X2] :
      ( p__ComplementFn(X1,X2)
     => p__d__instance(X1,c__SetOrClass) ) ).

fof(typeA258,axiom,
    ! [X1,X2] :
      ( p__GeneralizedUnionFn(X1,X2)
     => p__d__subclass(X1,c__SetOrClass) ) ).

fof(typeA259,axiom,
    ! [X1,X2] :
      ( p__GeneralizedIntersectionFn(X1,X2)
     => p__d__subclass(X1,c__SetOrClass) ) ).

fof(typeA260,axiom,
    ! [X1,X2] :
      ( p__InitialNodeFn(X1,X2)
     => p__d__instance(X1,c__GraphArc) ) ).

fof(typeA261,axiom,
    ! [X1,X2] :
      ( p__TerminalNodeFn(X1,X2)
     => p__d__instance(X1,c__GraphArc) ) ).

fof(typeA262,axiom,
    ! [X1,X2] :
      ( p__BeginNodeFn(X1,X2)
     => p__d__instance(X1,c__GraphPath) ) ).

fof(typeA263,axiom,
    ! [X1,X2] :
      ( p__EndNodeFn(X1,X2)
     => p__d__instance(X1,c__GraphPath) ) ).

fof(typeA264,axiom,
    ! [X1,X2] :
      ( p__PathWeightFn(X1,X2)
     => p__d__instance(X1,c__GraphPath) ) ).

fof(typeA265,axiom,
    ! [X1,X2] :
      ( p__CutSetFn(X1,X2)
     => p__d__instance(X1,c__Graph) ) ).

fof(typeA266,axiom,
    ! [X1,X2] :
      ( p__MinimalCutSetFn(X1,X2)
     => p__d__instance(X1,c__Graph) ) ).

fof(typeA267,axiom,
    ! [X1,X2] :
      ( p__MagnitudeFn(X1,X2)
     => p__d__instance(X1,c__PhysicalQuantity) ) ).

fof(typeA268,axiom,
    ! [X1,X2] :
      ( p__UnitFn(X1,X2)
     => p__d__instance(X1,c__PhysicalQuantity) ) ).

fof(typeA269,axiom,
    ! [X1,X2] :
      ( p__CenterOfCircleFn(X1,X2)
     => p__d__instance(X1,c__Circle) ) ).

fof(typeA270,axiom,
    ! [X1,X2] :
      ( p__WealthFn(X1,X2)
     => p__d__instance(X1,c__Agent) ) ).

fof(typeA271,axiom,
    ! [X1,X2] :
      ( p__BeginFn(X1,X2)
     => p__d__instance(X1,c__TimeInterval) ) ).

fof(typeA272,axiom,
    ! [X1,X2] :
      ( p__EndFn(X1,X2)
     => p__d__instance(X1,c__TimeInterval) ) ).

fof(typeA273,axiom,
    ! [X1,X2] :
      ( p__WhenFn(X1,X2)
     => p__d__instance(X1,c__Physical) ) ).

fof(typeA274,axiom,
    ! [X1,X2] :
      ( p__PastFn(X1,X2)
     => p__d__instance(X1,c__TimePosition) ) ).

fof(typeA275,axiom,
    ! [X1,X2] :
      ( p__ImmediatePastFn(X1,X2)
     => p__d__instance(X1,c__TimePosition) ) ).

fof(typeA276,axiom,
    ! [X1,X2] :
      ( p__FutureFn(X1,X2)
     => p__d__instance(X1,c__TimePosition) ) ).

fof(typeA277,axiom,
    ! [X1,X2] :
      ( p__ImmediateFutureFn(X1,X2)
     => p__d__instance(X1,c__TimePosition) ) ).

fof(typeA278,axiom,
    ! [X1,X2] :
      ( p__YearFn(X1,X2)
     => p__d__instance(X1,c__Integer) ) ).

fof(typeA279,axiom,
    ! [X1,X2] :
      ( p__MereologicalComplementFn(X1,X2)
     => p__d__instance(X1,c__Object) ) ).

fof(typeA280,axiom,
    ! [X1,X2] :
      ( p__FoodForFn(X1,X2)
     => p__d__subclass(X1,c__Organism) ) ).

fof(typeA281,axiom,
    ! [X1,X2] :
      ( p__ImmediateFamilyFn(X1,X2)
     => p__d__instance(X1,c__Human) ) ).

fof(typeA282,axiom,
    ! [X1,X2] :
      ( p__GovernmentFn(X1,X2)
     => p__d__instance(X1,c__GeopoliticalArea) ) ).

fof(typeA283,axiom,
    ! [X1,X2] :
      ( p__PremisesFn(X1,X2)
     => p__d__instance(X1,c__Argument) ) ).

fof(typeA284,axiom,
    ! [X1,X2] :
      ( p__DeadFn(X1,X2)
     => p__d__subclass(X1,c__Organism) ) ).

fof(typeA285,axiom,
    ! [X1,X2] :
      ( p__StartFn(X1,X2)
     => p__d__instance(X1,c__Process) ) ).

fof(typeA286,axiom,
    ! [X1,X2] :
      ( p__StopFn(X1,X2)
     => p__d__instance(X1,c__Process) ) ).

fof(typeA287,axiom,
    ! [X1,X2] :
      ( p__DiameterFn(X1,X2)
     => p__d__instance(X1,c__Circle) ) ).

fof(typeA288,axiom,
    ! [X1,X2] :
      ( p__RadiusFn(X1,X2)
     => p__d__instance(X1,c__Circle) ) ).

fof(typeA289,axiom,
    ! [X1,X2] :
      ( p__LastFn(X1,X2)
     => p__d__instance(X1,c__List) ) ).

fof(typeA290,axiom,
    ! [X1,X2] :
      ( p__FirstFn(X1,X2)
     => p__d__instance(X1,c__List) ) ).

fof(typeA291,axiom,
    ! [X1,X2] :
      ( p__DescendantsFn(X1,X2)
     => p__d__instance(X1,c__Human) ) ).

fof(typeA292,axiom,
    ! [X1,X2] :
      ( p__ResidentFn(X1,X2)
     => p__d__instance(X1,c__GeopoliticalArea) ) ).

fof(typeA293,axiom,
    ! [X1,X2] :
      ( p__OperatingFn(X1,X2)
     => p__d__instance(X1,c__Device) ) ).

fof(typeA294,axiom,
    ! [X1,X2] :
      ( p__OccupationFn(X1,X2)
     => p__d__instance(X1,c__IntentionalProcess) ) ).

fof(typeA295,axiom,
    ! [X1,X2] :
      ( p__StringLengthFn(X1,X2)
     => p__d__instance(X1,c__SymbolicString) ) ).

fof(typeA296,axiom,
    ! [X1,X2] :
      ( p__CoveringFn(X1,X2)
     => p__d__subclass(X1,c__BodyPart) ) ).

fof(typeA297,axiom,
    ! [X1,X2] :
      ( p__instance(X1,X2)
     => p__d__instance(X2,c__SetOrClass) ) ).

fof(typeA298,axiom,
    ! [X1,X2] :
      ( p__externalImage(X1,X2)
     => p__d__instance(X2,c__SymbolicString) ) ).

fof(typeA299,axiom,
    ! [X1,X2] :
      ( p__entails(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA300,axiom,
    ! [X1,X2] :
      ( p__material(X1,X2)
     => ( p__d__instance(X2,c__CorpuscularObject)
        & p__d__subclass(X1,c__Substance) ) ) ).

fof(typeA301,axiom,
    ! [X1,X2] :
      ( p__property(X1,X2)
     => p__d__instance(X2,c__Attribute) ) ).

fof(typeA302,axiom,
    ! [X1,X2] :
      ( p__inScopeOfInterest(X1,X2)
     => p__d__instance(X1,c__CognitiveAgent) ) ).

fof(typeA303,axiom,
    ! [X1,X2] :
      ( p__needs(X1,X2)
     => ( p__d__instance(X2,c__Physical)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA304,axiom,
    ! [X1,X2] :
      ( p__wants(X1,X2)
     => ( p__d__instance(X2,c__Physical)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA305,axiom,
    ! [X1,X2] :
      ( p__distributes(X1,X2)
     => ( p__d__instance(X2,c__BinaryFunction)
        & p__d__instance(X1,c__BinaryFunction) ) ) ).

fof(typeA306,axiom,
    ! [X1,X2] :
      ( p__partlyLocated(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA307,axiom,
    ! [X1,X2] :
      ( p__traverses(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA308,axiom,
    ! [X1,X2] :
      ( p__average(X1,X2)
     => ( p__d__instance(X2,c__RealNumber)
        & p__d__instance(X1,c__List) ) ) ).

fof(typeA309,axiom,
    ! [X1,X2] :
      ( p__arcWeight(X1,X2)
     => ( p__d__instance(X2,c__Quantity)
        & p__d__instance(X1,c__GraphArc) ) ) ).

fof(typeA310,axiom,
    ! [X1,X2] :
      ( p__abstractCounterpart(X1,X2)
     => ( p__d__instance(X2,c__Physical)
        & p__d__instance(X1,c__Abstract) ) ) ).

fof(typeA311,axiom,
    ! [X1,X2] :
      ( p__subSystem(X1,X2)
     => ( p__d__instance(X2,c__PhysicalSystem)
        & p__d__instance(X1,c__PhysicalSystem) ) ) ).

fof(typeA312,axiom,
    ! [X1,X2] :
      ( p__systemPart(X1,X2)
     => ( p__d__instance(X2,c__PhysicalSystem)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA313,axiom,
    ! [X1,X2] :
      ( p__graphMeasure(X1,X2)
     => ( p__d__instance(X2,c__UnitOfMeasure)
        & p__d__instance(X1,c__Graph) ) ) ).

fof(typeA314,axiom,
    ! [X1,X2] :
      ( p__weight(X1,X2)
     => ( p__d__instance(X2,c__MassMeasure)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA315,axiom,
    ! [X1,X2] :
      ( p__radius(X1,X2)
     => ( p__d__instance(X2,c__LengthMeasure)
        & p__d__instance(X1,c__Circle) ) ) ).

fof(typeA316,axiom,
    ! [X1,X2] :
      ( p__diameter(X1,X2)
     => ( p__d__instance(X2,c__LengthMeasure)
        & p__d__instance(X1,c__Circle) ) ) ).

fof(typeA317,axiom,
    ! [X1,X2] :
      ( p__transactionAmount(X1,X2)
     => ( p__d__instance(X2,c__CurrencyMeasure)
        & p__d__instance(X1,c__FinancialTransaction) ) ) ).

fof(typeA318,axiom,
    ! [X1,X2] :
      ( p__boilingPoint(X1,X2)
     => ( p__d__instance(X2,c__TemperatureMeasure)
        & p__d__subclass(X1,c__PureSubstance) ) ) ).

fof(typeA319,axiom,
    ! [X1,X2] :
      ( p__meltingPoint(X1,X2)
     => ( p__d__instance(X2,c__TemperatureMeasure)
        & p__d__subclass(X1,c__PureSubstance) ) ) ).

fof(typeA320,axiom,
    ! [X1,X2] :
      ( p__wears(X1,X2)
     => ( p__d__instance(X2,c__WearableItem)
        & p__d__instance(X1,c__Animal) ) ) ).

fof(typeA321,axiom,
    ! [X1,X2] :
      ( p__acquaintance(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA322,axiom,
    ! [X1,X2] :
      ( p__employs(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA323,axiom,
    ! [X1,X2] :
      ( p__premise(X1,X2)
     => ( p__d__instance(X2,c__Proposition)
        & p__d__instance(X1,c__Argument) ) ) ).

fof(typeA324,axiom,
    ! [X1,X2] :
      ( p__conclusion(X1,X2)
     => ( p__d__instance(X2,c__Proposition)
        & p__d__instance(X1,c__Argument) ) ) ).

fof(typeA325,axiom,
    ! [X1,X2] :
      ( p__faces(X1,X2)
     => ( p__d__instance(X2,c__DirectionalAttribute)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA326,axiom,
    ! [X1,X2] :
      ( p__parallel(X1,X2)
     => ( p__d__instance(X2,c__OneDimensionalFigure)
        & p__d__instance(X1,c__OneDimensionalFigure) ) ) ).

fof(typeA327,axiom,
    ! [X1,X2] :
      ( p__angularMeasure(X1,X2)
     => ( p__d__instance(X2,c__PlaneAngleMeasure)
        & p__d__instance(X1,c__TwoDimensionalAngle) ) ) ).

fof(typeA328,axiom,
    ! [X1,X2] :
      ( p__lineMeasure(X1,X2)
     => ( p__d__instance(X2,c__LengthMeasure)
        & p__d__instance(X1,c__OneDimensionalFigure) ) ) ).

fof(typeA329,axiom,
    ! [X1,X2] :
      ( p__older(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA330,axiom,
    ! [X1,X2] :
      ( p__speaksLanguage(X1,X2)
     => ( p__d__instance(X2,c__Language)
        & p__d__instance(X1,c__SentientAgent) ) ) ).

fof(typeA331,axiom,
    ! [X1,X2] :
      ( p__soundFrequency(X1,X2)
     => ( p__d__instance(X2,c__FunctionQuantity)
        & p__d__instance(X1,c__MusicalTone) ) ) ).

fof(typeA332,axiom,
    ! [X1,X2] :
      ( p__dateEstablished(X1,X2)
     => ( p__d__subclass(X2,c__TimePosition)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA333,axiom,
    ! [X1,X2] :
      ( p__effectiveRange(X1,X2)
     => ( p__d__instance(X2,c__LengthMeasure)
        & p__d__instance(X1,c__Device) ) ) ).

fof(typeA334,axiom,
    ! [X1,X2] :
      ( p__deviceState(X1,X2)
     => ( p__d__instance(X2,c__DeviceStateAttribute)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA335,axiom,
    ! [X1,X2] :
      ( p__discovers(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA336,axiom,
    ! [X1,X2] :
      ( p__measurementReading(X1,X2)
     => ( p__d__instance(X2,c__ConstantQuantity)
        & p__d__instance(X1,c__MeasuringDevice) ) ) ).

fof(typeA337,axiom,
    ! [X1,X2] :
      ( p__emailAddress(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA338,axiom,
    ! [X1,X2] :
      ( p__potentialOfHydrogen(X1,X2)
     => ( p__d__instance(X2,c__RealNumber)
        & p__d__instance(X1,c__Solution) ) ) ).

fof(typeA339,axiom,
    ! [X1,X2] :
      ( p__fleetSize(X1,X2)
     => ( p__d__instance(X2,c__Integer)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA340,axiom,
    ! [X1,X2] :
      ( p__carries(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA341,axiom,
    ! [X1,X2] :
      ( p__tangent(X1,X2)
     => ( p__d__instance(X2,c__TwoDimensionalFigure)
        & p__d__instance(X1,c__OneDimensionalFigure) ) ) ).

fof(typeA342,axiom,
    ! [X1,X2] :
      ( p__sliceOfFigure(X1,X2)
     => ( p__d__instance(X2,c__CorpuscularObject)
        & p__d__instance(X1,c__TwoDimensionalObject) ) ) ).

fof(typeA343,axiom,
    ! [X1,X2] :
      ( p__patientMedical(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA344,axiom,
    ! [X1,X2] :
      ( p__parasite(X1,X2)
     => ( p__d__instance(X2,c__Organism)
        & p__d__instance(X1,c__Organism) ) ) ).

fof(typeA345,axiom,
    ! [X1,X2] :
      ( p__capacity(X1,X2)
     => ( p__d__instance(X2,c__ConstantQuantity)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA346,axiom,
    ! [X1,X2] :
      ( p__humanCapacity(X1,X2)
     => ( p__d__instance(X2,c__PositiveInteger)
        & p__d__instance(X1,c__StationaryArtifact) ) ) ).

fof(typeA347,axiom,
    ! [X1,X2] :
      ( p__landlord(X1,X2)
     => ( p__d__instance(X2,c__PermanentResidence)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA348,axiom,
    ! [X1,X2] :
      ( p__tenant(X1,X2)
     => ( p__d__instance(X2,c__Residence)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA349,axiom,
    ! [X1,X2] :
      ( p__expects(X1,X2)
     => ( p__d__instance(X2,c__Formula)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA350,axiom,
    ! [X1,X2] :
      ( p__medicalPatient(X1,X2)
     => ( p__d__instance(X2,c__CareOrganization)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA351,axiom,
    ! [X1,X2] :
      ( p__intelligenceQuotient(X1,X2)
     => ( p__d__instance(X2,c__RationalNumber)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA352,axiom,
    ! [X1,X2] :
      ( p__secretesSubstance(X1,X2)
     => ( p__d__subclass(X2,c__NaturalSubstance)
        & p__d__subclass(X1,c__OrganicObject) ) ) ).

fof(typeA353,axiom,
    ! [X1,X2] :
      ( p__creator(X1,X2)
     => p__d__instance(X1,c__Agent) ) ).

fof(typeA354,axiom,
    ! [X1,X2] :
      ( p__partyToAgreement(X1,X2)
     => ( p__d__instance(X2,c__Agreement)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA355,axiom,
    ! [X1,X2] :
      ( p__agreementPeriod(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__Agreement) ) ) ).

fof(typeA356,axiom,
    ! [X1,X2] :
      ( p__agreementEffectiveDate(X1,X2)
     => ( p__d__instance(X2,c__TimePoint)
        & p__d__instance(X1,c__Agreement) ) ) ).

fof(typeA357,axiom,
    ! [X1,X2] :
      ( p__agreementExpirationDate(X1,X2)
     => ( p__d__instance(X2,c__TimePoint)
        & p__d__instance(X1,c__Agreement) ) ) ).

fof(typeA358,axiom,
    ! [X1,X2] :
      ( p__localLongName(X1,X2)
     => p__d__instance(X1,c__SymbolicString) ) ).

fof(typeA359,axiom,
    ! [X1,X2] :
      ( p__localShortName(X1,X2)
     => p__d__instance(X1,c__SymbolicString) ) ).

fof(typeA360,axiom,
    ! [X1,X2] :
      ( p__commentator(X1,X2)
     => ( p__d__instance(X2,c__Process)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA361,axiom,
    ! [X1,X2] :
      ( p__describes(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Formula) ) ) ).

fof(typeA362,axiom,
    ! [X1,X2] :
      ( p__issuedBy(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__Certificate) ) ) ).

fof(typeA363,axiom,
    ! [X1,X2] :
      ( p__registeredItem(X1,X2)
     => ( p__d__instance(X2,c__Physical)
        & p__d__instance(X1,c__Text) ) ) ).

fof(typeA364,axiom,
    ! [X1,X2] :
      ( p__axis(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA365,axiom,
    ! [X1,X2] :
      ( p__waterDepth(X1,X2)
     => ( p__d__instance(X2,c__LengthMeasure)
        & p__d__instance(X1,c__WaterArea) ) ) ).

fof(typeA366,axiom,
    ! [X1,X2] :
      ( p__hasAward(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Agent) ) ) ).

fof(typeA367,axiom,
    ! [X1,X2] :
      ( p__meatOfAnimal(X1,X2)
     => ( p__d__subclass(X2,c__Animal)
        & p__d__subclass(X1,c__Meat) ) ) ).

fof(typeA368,axiom,
    ! [X1,X2] :
      ( p__occupation(X1,X2)
     => ( p__d__instance(X2,c__FinancialTransaction)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA369,axiom,
    ! [X1,X2] :
      ( p__constructionPeriod(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__StationaryArtifact) ) ) ).

fof(typeA370,axiom,
    ! [X1,X2] :
      ( p__contractor(X1,X2)
     => ( p__d__instance(X2,c__Agent)
        & p__d__instance(X1,c__StationaryArtifact) ) ) ).

fof(typeA371,axiom,
    ! [X1,X2] :
      ( p__hasExpertise(X1,X2)
     => ( p__d__instance(X2,c__FieldOfStudy)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA372,axiom,
    ! [X1,X2] :
      ( p__hasOccupation(X1,X2)
     => ( p__d__subclass(X2,c__IntentionalProcess)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA373,axiom,
    ! [X1,X2] :
      ( p__protonNumber(X1,X2)
     => ( p__d__instance(X2,c__PositiveInteger)
        & p__d__instance(X1,c__PureSubstance) ) ) ).

fof(typeA374,axiom,
    ! [X1,X2] :
      ( p__electronNumber(X1,X2)
     => ( p__d__instance(X2,c__PositiveInteger)
        & p__d__instance(X1,c__PureSubstance) ) ) ).

fof(typeA375,axiom,
    ! [X1,X2] :
      ( p__memberCount(X1,X2)
     => ( p__d__instance(X2,c__Integer)
        & p__d__instance(X1,c__Collection) ) ) ).

fof(typeA376,axiom,
    ! [X1,X2] :
      ( p__memberType(X1,X2)
     => ( p__d__instance(X2,c__SetOrClass)
        & p__d__instance(X1,c__Collection) ) ) ).

fof(typeA377,axiom,
    ! [X1,X2] :
      ( p__inventory(X1,X2)
     => ( p__d__instance(X2,c__Collection)
        & p__d__instance(X1,c__ContentBearingObject) ) ) ).

fof(typeA378,axiom,
    ! [X1,X2] :
      ( p__stranger(X1,X2)
     => ( p__d__instance(X2,c__Human)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA379,axiom,
    ! [X1,X2] :
      ( p__typicalPart(X1,X2)
     => ( p__d__subclass(X2,c__Object)
        & p__d__subclass(X1,c__Object) ) ) ).

fof(typeA380,axiom,
    ! [X1,X2] :
      ( p__typicallyContainsPart(X1,X2)
     => ( p__d__subclass(X2,c__Object)
        & p__d__subclass(X1,c__Object) ) ) ).

fof(typeA381,axiom,
    ! [X1,X2] :
      ( p__initialPart(X1,X2)
     => ( p__d__subclass(X2,c__Object)
        & p__d__subclass(X1,c__Object) ) ) ).

fof(typeA382,axiom,
    ! [X1,X2] :
      ( p__initiallyContainsPart(X1,X2)
     => ( p__d__subclass(X2,c__Object)
        & p__d__subclass(X1,c__Object) ) ) ).

fof(typeA383,axiom,
    ! [X1,X2] :
      ( p__affiliatedOrganization(X1,X2)
     => ( p__d__instance(X2,c__Organization)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA384,axiom,
    ! [X1,X2] :
      ( p__ideologicalAffiliationOfOrganization(X1,X2)
     => ( p__d__instance(X2,c__FormOfGovernment)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA385,axiom,
    ! [X1,X2] :
      ( p__religiousAffiliationOfOrganization(X1,X2)
     => ( p__d__instance(X2,c__BeliefGroup)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA386,axiom,
    ! [X1,X2] :
      ( p__allegiance(X1,X2)
     => ( p__d__instance(X2,c__CognitiveAgent)
        & p__d__instance(X1,c__CognitiveAgent) ) ) ).

fof(typeA387,axiom,
    ! [X1,X2] :
      ( p__anniversary(X1,X2)
     => ( p__d__instance(X2,c__TimeInterval)
        & p__d__instance(X1,c__Physical) ) ) ).

fof(typeA388,axiom,
    ! [X1,X2] :
      ( p__birthplace(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Animal) ) ) ).

fof(typeA389,axiom,
    ! [X1,X2] :
      ( p__birthdate(X1,X2)
     => ( p__d__instance(X2,c__Day)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA390,axiom,
    ! [X1,X2] :
      ( p__deathdate(X1,X2)
     => ( p__d__instance(X2,c__Day)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA391,axiom,
    ! [X1,X2] :
      ( p__deathplace(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Animal) ) ) ).

fof(typeA392,axiom,
    ! [X1,X2] :
      ( p__equipmentType(X1,X2)
     => ( p__d__instance(X2,c__Device)
        & p__d__instance(X1,c__Artifact) ) ) ).

fof(typeA393,axiom,
    ! [X1,X2] :
      ( p__grammaticalRelation(X1,X2)
     => ( p__d__instance(X2,c__Sentence)
        & p__d__instance(X1,c__Phrase) ) ) ).

fof(typeA394,axiom,
    ! [X1,X2] :
      ( p__distanceOnPath(X1,X2)
     => ( p__d__instance(X2,c__Transitway)
        & p__d__instance(X1,c__ConstantQuantity) ) ) ).

fof(typeA395,axiom,
    ! [X1,X2] :
      ( p__inString(X1,X2)
     => ( p__d__instance(X2,c__SymbolicString)
        & p__d__instance(X1,c__Character) ) ) ).

fof(typeA396,axiom,
    ! [X1,X2] :
      ( p__unitNumber(X1,X2)
     => ( p__d__instance(X2,c__PostalPlace)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA397,axiom,
    ! [X1,X2] :
      ( p__floorCode(X1,X2)
     => ( p__d__instance(X2,c__PostalPlace)
        & p__d__instance(X1,c__SymbolicString) ) ) ).

fof(typeA398,axiom,
    ! [X1,X2] :
      ( p__voltageMeasure(X1,X2)
     => ( p__d__instance(X2,c__PhysicalQuantity)
        & p__d__instance(X1,c__PowerSource) ) ) ).

fof(typeA399,axiom,
    ! [X1,X2] :
      ( p__hasUniform(X1,X2)
     => ( p__d__subclass(X2,c__UniformClothing)
        & p__d__instance(X1,c__Group) ) ) ).

fof(typeA400,axiom,
    ! [X1,X2] :
      ( p__policyOwner(X1,X2)
     => ( p__d__instance(X2,c__Policy)
        & p__d__instance(X1,c__Organization) ) ) ).

fof(typeA401,axiom,
    ! [X1,X2] :
      ( p__approximateValue(X1,X2)
     => ( p__d__instance(X2,c__RealNumber)
        & p__d__instance(X1,c__RealNumber) ) ) ).

fof(typeA402,axiom,
    ! [X1,X2] :
      ( p__CitizenryFn(X1,X2)
     => p__d__instance(X1,c__GeopoliticalArea) ) ).

fof(typeA403,axiom,
    ! [X1,X2] :
      ( p__subset(X1,X2)
     => ( p__d__instance(X2,c__Set)
        & p__d__instance(X1,c__Set) ) ) ).

fof(typeA404,axiom,
    ! [X1,X2] :
      ( p__piece(X1,X2)
     => ( p__d__instance(X2,c__Substance)
        & p__d__instance(X1,c__Substance) ) ) ).

fof(typeA405,axiom,
    ! [X1,X2] :
      ( p__component(X1,X2)
     => ( p__d__instance(X2,c__CorpuscularObject)
        & p__d__instance(X1,c__CorpuscularObject) ) ) ).

fof(typeA406,axiom,
    ! [X1,X2] :
      ( p__bottom(X1,X2)
     => ( p__d__instance(X2,c__SelfConnectedObject)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA407,axiom,
    ! [X1,X2] :
      ( p__top(X1,X2)
     => ( p__d__instance(X2,c__SelfConnectedObject)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA408,axiom,
    ! [X1,X2] :
      ( p__side(X1,X2)
     => ( p__d__instance(X2,c__SelfConnectedObject)
        & p__d__instance(X1,c__SelfConnectedObject) ) ) ).

fof(typeA409,axiom,
    ! [X1,X2] :
      ( p__engineeringSubcomponent(X1,X2)
     => ( p__d__instance(X2,c__EngineeringComponent)
        & p__d__instance(X1,c__EngineeringComponent) ) ) ).

fof(typeA410,axiom,
    ! [X1,X2] :
      ( p__groupMember(X1,X2)
     => ( p__d__instance(X2,c__GroupOfPeople)
        & p__d__instance(X1,c__Human) ) ) ).

fof(typeA411,axiom,
    ! [X1,X2] :
      ( p__half(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA412,axiom,
    ! [X1,X2] :
      ( p__third(X1,X2)
     => ( p__d__instance(X2,c__Object)
        & p__d__instance(X1,c__Object) ) ) ).

fof(typeA413,axiom,
    ! [X1,X2] :
      ( p__quarter(X1,X2)