% A Ring with x^6=x is commutativ.
% Based on the 6th problem from
% @TechReport{LO82,
%   author =       {E.L. Lusk and R.A. Overbeek},
%   title =        {{A Short Problem Set for Testing Systems that
%                   Include Equality Reasoning}},
%   institution =  {Argonne National Laboratory},
%   year =         {1982},
%   key =          {LO82},
%   address =      {Illinois},
% }

fof(neutral_r,axiom,
    ! [X1] : j(X1,e) = X1 ).

fof(inverse_r,axiom,
    ! [X1] : j(X1,g(X1)) = e ).

fof(plus_commutes,axiom,
    ! [X1,X2] : j(X1,X2) = j(X2,X1) ).

fof(plus_associates,axiom,
    ! [X1,X2,X3] : j(j(X1,X2),X3) = j(X1,j(X2,X3)) ).

fof(time_associates,axiom,
    ! [X1,X2,X3] : f(f(X1,X2),X3) = f(X1,f(X2,X3)) ).

fof(distrib1,axiom,
    ! [X1,X2,X3] : j(f(X1,X2),f(X1,X3)) = f(X1,j(X2,X3)) ).

fof(distrib2,axiom,
    ! [X1,X2,X3] : j(f(X1,X3),f(X2,X3)) = f(j(X1,X2),X3) ).

fof(xpow6isx,hypothesis,
    ! [X1] : f(f(f(f(f(X1,X1),X1),X1),X1),X1) = X1 ).

fof(i_0_22,conjecture,
    f(a,b) = f(b,a) ).
